﻿## Active Perl 5.8.8

use utf8;
use warnings;
use strict;
use Encode;
binmode STDOUT, ':encoding(cp932)'; $|=1;

my $DEBUG = 0;

&start('./');

exit 0;

sub start {
	my ($subDir) = @_;

	opendir DIR,$subDir  or die $!;
	my @files = readdir DIR;
	closedir DIR;

	foreach my $fileName (@files) {
		next if $fileName =~ m/^\./;
		next if $fileName =~ m/ /;

		my $filePath = $subDir.$fileName;
		if (-d $filePath) {
			next if $fileName eq 'tele';	# skip data/html/admin/tele/**
			&start($filePath.'/');

		} elsif ($fileName =~ m!\.html?$!) {
			next if $fileName eq 'teleports-j.htm';	# skip teleports-j.htm
			open FILE, '<:utf8', $filePath  or die "'$filePath' $!";
			read FILE, my $htm, -s FILE;
			my $mtime = (stat FILE)[9];
			close FILE;

			my $original = $htm;
			$_           = $htm;
#----------------------------------------------------------------------------
my @TABLE = split /(?=<table)|(?<=<\/table>)/, $htm, -1;
for (@TABLE) {s/<table/<table CELLSPACING=0 CELLPADDING=0 BORDER=0/s if m/<button/s}
$_ = join '', @TABLE;
undef @TABLE;

s/width="(\d+)"/width=$1/gs;
s/height="(\d+)"/height=$1/gs;
s!(<button value="Main"[^>]+)width=\d+ height=\d+!$1WIDTH=50 HEIGHT=21!gs;
s!(<button value=":Main:"[^>]+)width=\d+ height=\d+!$1WIDTH=50 HEIGHT=21!gs;
s!(<button value="Back"[^>]+)width=\d+ height=\d+!$1WIDTH=50 HEIGHT=21!gs;
s!(<button value="メイン"[^>]+)width=\d+ height=\d+!$1WIDTH=50 HEIGHT=21!gs;
s!(<button value="戻る"[^>]+)width=\d+ height=\d+!$1WIDTH=50 HEIGHT=21!gs;

s{(?<=[^>\s])(\s*<table)}{<BR1>$1}gsi;		# HighFive
s{(?<=</font>)(\s*<table)}{<BR1>$1}gsi;		# HighFive
s{(?<=</color>)(\s*<table)}{<BR1>$1}gsi;		# HighFive

s{(?<=<html>)(?=<body>)}{<TITLE>Admin</TITLE>}gsi;					# HighFive
s!\Qfore="L2UI_ct1.button_df_down"!fore="L2UI_ct1.button_df"!gsi;	# HighFive
s!\Qback="L2UI_ct1.button_df"!back="L2UI_ct1.button_df_down"!gsi;	# HighFive
#----------------------------------------------------------------------------
			$htm = $_;

			if ($htm ne $original) {
				print $filePath,"\n";
				my $output = $filePath;
				   $output = $filePath.'.text' if $DEBUG;
				open FILE, '>:utf8', $output  or die "'$output' $!";
#				$htm = "\x{feff}".$htm unless $htm =~ m/^\x{feff}/;  #BOM
				print FILE $htm;
				close FILE;
				utime $mtime,$mtime,$output;
			}
		}
	}
}
