/*
 * Copyright (C) 2004-2013 L2J DataPack
 * 
 * This file is part of L2J DataPack.
 * 
 * L2J DataPack is free software: you can redistribute it and/or modify
 * it under the terms of the GNU General Public License as published by
 * the Free Software Foundation, either version 3 of the License, or
 * (at your option) any later version.
 * 
 * L2J DataPack is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE. See the GNU
 * General Public License for more details.
 * 
 * You should have received a copy of the GNU General Public License
 * along with this program. If not, see <http://www.gnu.org/licenses/>.
 */
package ai.npc.Alexandria;

import java.util.HashMap;

import ai.npc.AbstractNpcAI;

import com.l2jserver.gameserver.model.actor.L2Npc;
import com.l2jserver.gameserver.model.actor.instance.L2PcInstance;
import com.l2jserver.gameserver.model.holders.ItemHolder;

/**
 * Alexandria (Armor Merchant) AI.
 * @author xban1x
 */
public final class Alexandria extends AbstractNpcAI
{
	// NPC
	private static final int ALEXANDRIA = 30098;
	// Items
	private static final ItemHolder[] REQUIRED_ITEMS = new ItemHolder[]
	{
		// 30098-02.html
		new ItemHolder(57, 7500000),	// Afi
		new ItemHolder(5094, 50),	// O[g Rh
		new ItemHolder(6471, 25),	// rbO bh XEBtg tBbV
		new ItemHolder(9814, 4),	// _̓
		new ItemHolder(9815, 3),	// hS̐S
		new ItemHolder(9816, 5),	// n̗
		new ItemHolder(9817, 5),	// U̐̊j
	};
	// Agathions
	private static final Reward[] LITTLE_DEVILS = new Reward[]
	{
		new Reward(600, 10321, 10408),	// eFS[h oCLO T[Nbg, I[h AKVI
		new Reward( 10, 10322),			// AKVĨuXbgFg fr - ԉ
		new Reward( 10, 10323),			// AKVĨuXbgFg fr - ~XeAX
		new Reward(  5, 10324),			// AKVĨuXbgFg fr - A
		new Reward(  5, 10325),			// AKVĨuXbgFg fr - 
		new Reward(370, 10326),			// AKVĨuXbgFg fr
	};
	private static final Reward[] LITTLE_ANGELS = new Reward[]
	{
		new Reward(600, 10315, 10408),	// eFp[v oCLO T[Nbg, I[h AKVI
		new Reward( 10, 10316),			// AKVĨuXbgFg GWF - ԉ
		new Reward( 10, 10317),			// AKVĨuXbgFg GWF - ~XeAX
		new Reward(  5, 10318),			// AKVĨuXbgFg GWF - A
		new Reward(  5, 10319),			// AKVĨuXbgFg GWF - 
		new Reward(370, 10320),			// AKVĨuXbgFg GWF
	};
	private static final HashMap<String, Reward[]> AGATHIONS = new HashMap<>();
	static
	{
		AGATHIONS.put("littleAngel", LITTLE_ANGELS);
		AGATHIONS.put("littleDevil", LITTLE_DEVILS);
	}
	
	private Alexandria()
	{
		super(Alexandria.class.getSimpleName(), "ai/npc");
		addStartNpc(ALEXANDRIA);
		addTalkId(ALEXANDRIA);
		addFirstTalkId(ALEXANDRIA);
	}
	
	@Override
	public String onAdvEvent(String event, L2Npc npc, L2PcInstance player)
	{
		String htmltext = null;
		if (event.equals("30098-02.html"))
		{
			htmltext = event;
		}
		else if (AGATHIONS.containsKey(event))
		{
			final int chance = getRandom(1000);
			int chance3 = 0;
			for (Reward agathion : AGATHIONS.get(event))
			{
				chance3 += agathion.chance;
				if (chance < chance3)
				{
					boolean hasAllItems = true;
					for (ItemHolder item : REQUIRED_ITEMS)
					{
						if (getQuestItemsCount(player, item.getId()) < item.getCount())
						{
							hasAllItems = false;
							break;
						}
					}
					if (hasAllItems)
					{
						for (ItemHolder item : REQUIRED_ITEMS)
						{
							takeItems(player, item);
						}
						giveItems(player, agathion.reward1, 1);
						if (agathion.reward2 == 0)
						{
							htmltext = "30098-03.html";
						}
						else
						{
							giveItems(player, agathion.reward2, 1);
							htmltext = "30098-03a.html";
						}
					}
					else
					{
						htmltext = "30098-04.html";
					}
					break;
				}
			}
		}
		return htmltext;
	}
	
	public static void main(String[] args)
	{
		new Alexandria();
	}
	
	private static final class Reward
	{
		final int chance, reward1, reward2;
		
		public Reward(int chance, int reward1)
		{
			this.chance = chance;
			this.reward1 = reward1;
			this.reward2 = 0;
		}
		public Reward(int chance, int reward1, int reward2)
		{
			this.chance = chance;
			this.reward1 = reward1;
			this.reward2 = reward2;
		}
	}
}
