/*
 * Decompiled with CFR 0.152.
 */
package javolution.context;

import javolution.context.AllocatorContext;
import javolution.context.ConcurrentContext;
import javolution.context.ObjectFactory;
import javolution.xml.XMLSerializable;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public abstract class Context
implements XMLSerializable {
    public static final Context ROOT = new Root();
    private static final ThreadLocal CURRENT = new ThreadLocal(){

        protected Object initialValue() {
            return ROOT;
        }
    };
    private Thread _owner;
    private Context _outer;
    private ObjectFactory _factory;
    private AllocatorContext _allocator;

    protected Context() {
    }

    public static Context getCurrent() {
        return (Context)CURRENT.get();
    }

    public final Thread getOwner() {
        return this._owner;
    }

    public final Context getOuter() {
        return this._outer;
    }

    public String toString() {
        return "Instance of " + this.getClass().getName();
    }

    protected abstract void enterAction();

    protected abstract void exitAction();

    public static final void enter(Context context) {
        Context current;
        if (context._owner != null) {
            throw new IllegalStateException("Context is currently in use");
        }
        context._outer = current = Context.getCurrent();
        context._owner = Thread.currentThread();
        context._allocator = context instanceof AllocatorContext ? (AllocatorContext)context : current._allocator;
        CURRENT.set(context);
        context.enterAction();
    }

    public static final void exit(Context context) {
        if (Context.getCurrent() != context) {
            throw new IllegalArgumentException("The specified context is not the current context");
        }
        Context.exit(context.getClass());
    }

    public static final void enter(Class<? extends Context> contextType) {
        ObjectFactory<? extends Context> factory = ObjectFactory.getInstance(contextType);
        Context context = factory.object();
        context._factory = factory;
        Context.enter(context);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void exit(Class<? extends Context> contextType) {
        Context context = Context.getCurrent();
        Context outer = context._outer;
        if (outer == null) {
            throw new IllegalStateException("Cannot exit root context");
        }
        if (context._owner != Thread.currentThread()) {
            throw new IllegalStateException("The current thread is not the context owner");
        }
        if (!contextType.isInstance(context)) {
            throw new ClassCastException("Current context is an instance of " + context.getClass().getName());
        }
        try {
            context.exitAction();
        }
        finally {
            CURRENT.set(outer);
            context._outer = null;
            context._owner = null;
            context._allocator = null;
            if (context._factory != null) {
                context._factory.recycle(context);
                context._factory = null;
            }
        }
    }

    protected static void setCurrent(ConcurrentContext context) {
        CURRENT.set(context);
    }

    final AllocatorContext getAllocatorContext() {
        return this._allocator == null ? AllocatorContext.getDefault() : this._allocator;
    }

    private static final class Root
    extends Context {
        private Root() {
        }

        protected void enterAction() {
            throw new UnsupportedOperationException("Cannot enter the root context");
        }

        protected void exitAction() {
            throw new UnsupportedOperationException("Cannot enter the root context");
        }
    }
}

