/*
 * Decompiled with CFR 0.152.
 */
package javolution.context;

import javolution.Javolution;
import javolution.context.Context;
import javolution.context.ObjectFactory;
import javolution.lang.Configurable;
import javolution.text.TextBuilder;
import javolution.util.StandardLog;

public abstract class LogContext
extends Context {
    private static volatile LogContext _Default = new StandardLog();
    public static final Class<? extends LogContext> STANDARD = StandardLog.class;
    public static final Class<? extends LogContext> NULL = Null.class;
    public static final Class<? extends LogContext> SYSTEM_OUT = SystemOut.class;
    public static final Class<? extends LogContext> CONSOLE = Console.class;
    public static final Configurable<Class<? extends LogContext>> DEFAULT = new Configurable(STANDARD){

        protected void notifyChange() {
            _Default = (LogContext)ObjectFactory.getInstance((Class)this.get()).object();
        }
    };

    protected LogContext() {
    }

    public static Context getCurrent() {
        for (Context ctx = Context.getCurrent(); ctx != null; ctx = ctx.getOuter()) {
            if (!(ctx instanceof LogContext)) continue;
            return (LogContext)ctx;
        }
        return _Default;
    }

    public static LogContext getDefault() {
        return _Default;
    }

    public static boolean isDebugLogged() {
        return ((LogContext)LogContext.getCurrent()).isLogged("debug");
    }

    public static void debug(CharSequence message) {
        ((LogContext)LogContext.getCurrent()).logDebug(message);
    }

    public static void debug(String message) {
        ((LogContext)LogContext.getCurrent()).logDebug(Javolution.j2meToCharSeq(message));
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void debug(String message, Object obj) {
        LogContext logContext = (LogContext)LogContext.getCurrent();
        if (logContext.isLogged("debug")) {
            TextBuilder tmp = TextBuilder.newInstance();
            try {
                tmp.append(message);
                tmp.append(obj);
                logContext.logDebug(tmp);
            }
            finally {
                TextBuilder.recycle(tmp);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void debug(String messagePart1, Object obj, String messagePart2) {
        LogContext logContext = (LogContext)LogContext.getCurrent();
        if (logContext.isLogged("debug")) {
            TextBuilder tmp = TextBuilder.newInstance();
            try {
                tmp.append(messagePart1);
                tmp.append(obj);
                tmp.append(messagePart2);
                logContext.logDebug(tmp);
            }
            finally {
                TextBuilder.recycle(tmp);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void debug(String messagePart1, Object obj1, String messagePart2, Object obj2) {
        LogContext logContext = (LogContext)LogContext.getCurrent();
        if (logContext.isLogged("debug")) {
            TextBuilder tmp = TextBuilder.newInstance();
            try {
                tmp.append(messagePart1);
                tmp.append(obj1);
                tmp.append(messagePart2);
                tmp.append(obj2);
                logContext.logDebug(tmp);
            }
            finally {
                TextBuilder.recycle(tmp);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void debug(String messagePart1, Object obj1, String messagePart2, Object obj2, String messagePart3) {
        LogContext logContext = (LogContext)LogContext.getCurrent();
        if (logContext.isLogged("debug")) {
            TextBuilder tmp = TextBuilder.newInstance();
            try {
                tmp.append(messagePart1);
                tmp.append(obj1);
                tmp.append(messagePart2);
                tmp.append(obj2);
                tmp.append(messagePart3);
                logContext.logDebug(tmp);
            }
            finally {
                TextBuilder.recycle(tmp);
            }
        }
    }

    public static boolean isInfoLogged() {
        return ((LogContext)LogContext.getCurrent()).isLogged("info");
    }

    public static void info(CharSequence message) {
        ((LogContext)LogContext.getCurrent()).logInfo(message);
    }

    public static void info(String message) {
        ((LogContext)LogContext.getCurrent()).logInfo(Javolution.j2meToCharSeq(message));
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void info(String message, Object obj) {
        LogContext logContext = (LogContext)LogContext.getCurrent();
        if (logContext.isLogged("info")) {
            TextBuilder tmp = TextBuilder.newInstance();
            try {
                tmp.append(message);
                tmp.append(obj);
                logContext.logInfo(tmp);
            }
            finally {
                TextBuilder.recycle(tmp);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void info(String messagePart1, Object obj, String messagePart2) {
        LogContext logContext = (LogContext)LogContext.getCurrent();
        if (logContext.isLogged("info")) {
            TextBuilder tmp = TextBuilder.newInstance();
            try {
                tmp.append(messagePart1);
                tmp.append(obj);
                tmp.append(messagePart2);
                logContext.logInfo(tmp);
            }
            finally {
                TextBuilder.recycle(tmp);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void info(String messagePart1, Object obj1, String messagePart2, Object obj2) {
        LogContext logContext = (LogContext)LogContext.getCurrent();
        if (logContext.isLogged("info")) {
            TextBuilder tmp = TextBuilder.newInstance();
            try {
                tmp.append(messagePart1);
                tmp.append(obj1);
                tmp.append(messagePart2);
                tmp.append(obj2);
                logContext.logInfo(tmp);
            }
            finally {
                TextBuilder.recycle(tmp);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void info(String messagePart1, Object obj1, String messagePart2, Object obj2, String messagePart3) {
        LogContext logContext = (LogContext)LogContext.getCurrent();
        if (logContext.isLogged("info")) {
            TextBuilder tmp = TextBuilder.newInstance();
            try {
                tmp.append(messagePart1);
                tmp.append(obj1);
                tmp.append(messagePart2);
                tmp.append(obj2);
                tmp.append(messagePart3);
                logContext.logInfo(tmp);
            }
            finally {
                TextBuilder.recycle(tmp);
            }
        }
    }

    public static boolean isWarningLogged() {
        return ((LogContext)LogContext.getCurrent()).isLogged("warning");
    }

    public static void warning(CharSequence message) {
        ((LogContext)LogContext.getCurrent()).logWarning(message);
    }

    public static void warning(String message) {
        ((LogContext)LogContext.getCurrent()).logWarning(Javolution.j2meToCharSeq(message));
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void warning(String message, Object obj) {
        LogContext logContext = (LogContext)LogContext.getCurrent();
        if (logContext.isLogged("warning")) {
            TextBuilder tmp = TextBuilder.newInstance();
            try {
                tmp.append(message);
                tmp.append(obj);
                logContext.logWarning(tmp);
            }
            finally {
                TextBuilder.recycle(tmp);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void warning(String messagePart1, Object obj, String messagePart2) {
        LogContext logContext = (LogContext)LogContext.getCurrent();
        if (logContext.isLogged("warning")) {
            TextBuilder tmp = TextBuilder.newInstance();
            try {
                tmp.append(messagePart1);
                tmp.append(obj);
                tmp.append(messagePart2);
                logContext.logWarning(tmp);
            }
            finally {
                TextBuilder.recycle(tmp);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void warning(String messagePart1, Object obj1, String messagePart2, Object obj2) {
        LogContext logContext = (LogContext)LogContext.getCurrent();
        if (logContext.isLogged("warning")) {
            TextBuilder tmp = TextBuilder.newInstance();
            try {
                tmp.append(messagePart1);
                tmp.append(obj1);
                tmp.append(messagePart2);
                tmp.append(obj2);
                logContext.logWarning(tmp);
            }
            finally {
                TextBuilder.recycle(tmp);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void warning(String messagePart1, Object obj1, String messagePart2, Object obj2, String messagePart3) {
        LogContext logContext = (LogContext)LogContext.getCurrent();
        if (logContext.isLogged("warning")) {
            TextBuilder tmp = TextBuilder.newInstance();
            try {
                tmp.append(messagePart1);
                tmp.append(obj1);
                tmp.append(messagePart2);
                tmp.append(obj2);
                tmp.append(messagePart3);
                logContext.logWarning(tmp);
            }
            finally {
                TextBuilder.recycle(tmp);
            }
        }
    }

    public static boolean isErrorLogged() {
        return ((LogContext)LogContext.getCurrent()).isLogged("error");
    }

    public static void error(Throwable error) {
        ((LogContext)LogContext.getCurrent()).logError(error, null);
    }

    public static void error(Throwable error, CharSequence message) {
        ((LogContext)LogContext.getCurrent()).logError(error, message);
    }

    public static void error(Throwable error, String message) {
        ((LogContext)LogContext.getCurrent()).logError(error, Javolution.j2meToCharSeq(message));
    }

    public static void error(CharSequence message) {
        ((LogContext)LogContext.getCurrent()).logError(null, message);
    }

    public static final void error(String message) {
        ((LogContext)LogContext.getCurrent()).logError(null, Javolution.j2meToCharSeq(message));
    }

    protected abstract void logMessage(String var1, CharSequence var2);

    protected boolean isLogged(String category) {
        return true;
    }

    protected void logDebug(CharSequence message) {
        this.logMessage("debug", message);
    }

    protected void logInfo(CharSequence message) {
        this.logMessage("info", message);
    }

    protected void logWarning(CharSequence message) {
        this.logMessage("warning", message);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void logError(Throwable error, CharSequence message) {
        TextBuilder tmp = TextBuilder.newInstance();
        try {
            if (error != null) {
                tmp.append(error.getClass().getName());
                tmp.append(" - ");
            }
            if (message != null) {
                tmp.append(message);
            } else if (error != null) {
                tmp.append(error.getMessage());
            }
            if (error != null) {
                StackTraceElement[] trace = error.getStackTrace();
                for (int i = 0; i < trace.length; ++i) {
                    tmp.append("\n\tat ");
                    tmp.append(trace[i]);
                }
            }
            this.logMessage("error", tmp);
        }
        finally {
            TextBuilder.recycle(tmp);
        }
    }

    protected void enterAction() {
    }

    protected void exitAction() {
    }

    static {
        ObjectFactory.setInstance(new ObjectFactory(){

            protected Object create() {
                return new Console();
            }
        }, CONSOLE);
        ObjectFactory.setInstance(new ObjectFactory(){

            protected Object create() {
                return new Null();
            }
        }, NULL);
        ObjectFactory.setInstance(new ObjectFactory(){

            protected Object create() {
                return new SystemOut();
            }
        }, SYSTEM_OUT);
    }

    private static class Console
    extends SystemOut {
        private Console() {
        }
    }

    private static final class Null
    extends SystemOut {
        private Null() {
        }

        protected boolean isLogged(String category) {
            return false;
        }

        protected void logMessage(String category, CharSequence message) {
        }
    }

    private static class SystemOut
    extends LogContext {
        private SystemOut() {
        }

        protected void logMessage(String category, CharSequence message) {
            System.out.print("[");
            System.out.print(category);
            System.out.print("] ");
            System.out.println(message);
        }
    }
}

