/*
 * Decompiled with CFR 0.152.
 */
package javolution.lang;

import java.util.Map;
import javolution.Javolution;
import javolution.context.LogContext;
import javolution.context.SecurityContext;
import javolution.lang.Reflection;
import javolution.text.Text;
import javolution.text.TextFormat;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class Configurable<T> {
    private T _current;
    private final T _default;
    private volatile boolean _isUnmodifiable;
    static final Logic LOGIC = new Logic(){};

    public Configurable(T defaultValue) {
        this._default = defaultValue;
        this._current = defaultValue;
    }

    public final T get() {
        return this._current;
    }

    public final T getDefault() {
        return this._default;
    }

    public final Configurable<T> setUnmodifiable() {
        this._isUnmodifiable = true;
        return this;
    }

    public String toString() {
        return String.valueOf(this._current);
    }

    public static void read(Map properties) {
        for (Map.Entry entry : properties.entrySet()) {
            String key = String.valueOf(entry.getKey());
            Object value = entry.getValue();
            try {
                int sep = key.indexOf(35);
                if (sep < 0) continue;
                LogContext.info("Configure " + key + " to " + value);
                String className = key.substring(0, sep);
                String fieldName = key.substring(sep + 1);
                Class cls = Reflection.getClass(className);
                Configurable cfg = (Configurable)cls.getDeclaredField(fieldName).get(null);
                Object previous = cfg.get();
                if (previous == null || !(value instanceof String)) {
                    LOGIC.configure(cfg, value);
                    continue;
                }
                String str = (String)value;
                if (previous instanceof String) {
                    LOGIC.configure(cfg, value);
                    continue;
                }
                TextFormat<?> format = TextFormat.getInstance(previous.getClass());
                if (format != null) {
                    LOGIC.configure(cfg, format.parse(Javolution.j2meToCharSeq(str)));
                    continue;
                }
                LogContext.warning(Text.valueOf((Object)("No text format found for type " + previous.getClass() + " (" + key + "), please register the text format" + " using TextFormat.setInstance(Class, TextFormat) static method")));
            }
            catch (Exception ex) {
                LogContext.warning(Text.valueOf((Object)("Cannot set property " + key + "(" + ex.toString() + ")")));
            }
        }
    }

    protected void notifyChange() {
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    public static abstract class Logic {
        protected final <T> void configure(Configurable<T> cfg, T value) {
            boolean change;
            if (((Configurable)cfg)._isUnmodifiable) {
                throw new SecurityException("Dynamic configuration is no more allowed (configuration performed too late)");
            }
            SecurityContext policy = (SecurityContext)SecurityContext.getCurrent();
            if (!policy.isModifiable(cfg)) {
                throw new SecurityException("Configuration disallowed by SecurityContext");
            }
            Object previous = ((Configurable)cfg)._current;
            ((Configurable)cfg)._current = value;
            boolean bl = value == null ? previous != null : (change = !value.equals(previous));
            if (change) {
                cfg.notifyChange();
            }
        }
    }
}

