/*
 * Decompiled with CFR 0.152.
 */
package javolution.text;

import java.text.ParsePosition;
import javolution.lang.Reusable;
import javolution.text.CharSet;

public class Cursor
extends ParsePosition
implements Reusable {
    public Cursor() {
        super(0);
    }

    public final int getIndex() {
        return super.getIndex();
    }

    public void setIndex(int i) {
        super.setIndex(i);
    }

    public final boolean hasNext(CharSequence csq) {
        return this.getIndex() < csq.length();
    }

    public final char next(CharSequence csq) {
        int i = this.getIndex();
        this.setIndex(i + 1);
        return csq.charAt(i);
    }

    public final boolean skip(char c, CharSequence csq) {
        int n = csq.length();
        for (int i = this.getIndex(); i < n; ++i) {
            if (csq.charAt(i) == c) continue;
            this.setIndex(i);
            return true;
        }
        this.setIndex(n);
        return false;
    }

    public final boolean skip(CharSet charSet, CharSequence csq) {
        int n = csq.length();
        for (int i = this.getIndex(); i < n; ++i) {
            if (charSet.contains(csq.charAt(i))) continue;
            this.setIndex(i);
            return true;
        }
        this.setIndex(n);
        return false;
    }

    public final CharSequence nextToken(CharSequence csq, char c) {
        int n = csq.length();
        for (int i = this.getIndex(); i < n; ++i) {
            if (csq.charAt(i) == c) continue;
            int j = i;
            while (++j < n && csq.charAt(j) != c) {
            }
            this.setIndex(j);
            return csq.subSequence(i, j);
        }
        this.setIndex(n);
        return null;
    }

    public final CharSequence nextToken(CharSequence csq, CharSet charSet) {
        int n = csq.length();
        for (int i = this.getIndex(); i < n; ++i) {
            if (charSet.contains(csq.charAt(i))) continue;
            int j = i;
            while (++j < n && !charSet.contains(csq.charAt(j))) {
            }
            this.setIndex(j);
            return csq.subSequence(i, j);
        }
        this.setIndex(n);
        return null;
    }

    public final Cursor increment() {
        return this.increment(1);
    }

    public final Cursor increment(int i) {
        this.setIndex(this.getIndex() + i);
        return this;
    }

    public String toString() {
        return "Index: " + this.getIndex();
    }

    public boolean equals(Object obj) {
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof Cursor)) {
            return false;
        }
        return this.getIndex() == ((Cursor)obj).getIndex();
    }

    public int hashCode() {
        return this.getIndex();
    }

    public void reset() {
        super.setIndex(0);
        super.setErrorIndex(-1);
    }
}

