/*
 * Decompiled with CFR 0.152.
 */
package javolution.util;

import java.util.Collection;
import java.util.Iterator;
import java.util.List;
import java.util.ListIterator;
import java.util.Set;
import javax.realtime.MemoryArea;
import javolution.lang.Realtime;
import javolution.text.Text;
import javolution.util.FastComparator;
import javolution.util.FastIterator;
import javolution.xml.XMLSerializable;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public abstract class FastCollection<E>
implements Collection<E>,
XMLSerializable,
Realtime {
    private Unmodifiable _unmodifiable;

    protected FastCollection() {
    }

    @Override
    public abstract int size();

    public abstract Record head();

    public abstract Record tail();

    public abstract E valueOf(Record var1);

    public abstract void delete(Record var1);

    public Collection<E> unmodifiable() {
        if (this._unmodifiable == null) {
            MemoryArea.getMemoryArea(this).executeInArea(new Runnable(){

                public void run() {
                    FastCollection.this._unmodifiable = new Unmodifiable();
                }
            });
        }
        return this._unmodifiable;
    }

    @Override
    public Iterator<E> iterator() {
        return FastIterator.valueOf(this);
    }

    public FastComparator<? super E> getValueComparator() {
        return FastComparator.DEFAULT;
    }

    @Override
    public boolean add(E value) {
        throw new UnsupportedOperationException();
    }

    @Override
    public boolean remove(Object value) {
        FastComparator<E> valueComp = this.getValueComparator();
        Record r = this.head();
        Record end = this.tail();
        while ((r = r.getNext()) != end) {
            if (!valueComp.areEqual(value, this.valueOf(r))) continue;
            this.delete(r);
            return true;
        }
        return false;
    }

    @Override
    public void clear() {
        Record head = this.head();
        for (Record r = this.tail().getPrevious(); r != head; r = r.getPrevious()) {
            this.delete(r);
        }
    }

    @Override
    public final boolean isEmpty() {
        return this.size() == 0;
    }

    @Override
    public boolean contains(Object value) {
        FastComparator<E> valueComp = this.getValueComparator();
        Record r = this.head();
        Record end = this.tail();
        while ((r = r.getNext()) != end) {
            if (!valueComp.areEqual(value, this.valueOf(r))) continue;
            return true;
        }
        return false;
    }

    @Override
    public boolean addAll(Collection<? extends E> c) {
        boolean modified = false;
        Iterator<E> itr = c.iterator();
        while (itr.hasNext()) {
            if (!this.add(itr.next())) continue;
            modified = true;
        }
        return modified;
    }

    @Override
    public boolean containsAll(Collection<?> c) {
        Iterator<?> itr = c.iterator();
        while (itr.hasNext()) {
            if (this.contains(itr.next())) continue;
            return false;
        }
        return true;
    }

    @Override
    public boolean removeAll(Collection<?> c) {
        boolean modified = false;
        Record head = this.head();
        Record r = this.tail().getPrevious();
        while (r != head) {
            Record previous = r.getPrevious();
            if (FastCollection.contains(c, this.valueOf(r), this.getValueComparator())) {
                this.delete(r);
                modified = true;
            }
            r = previous;
        }
        return modified;
    }

    private static boolean contains(Collection c, Object obj, FastComparator cmp) {
        if (c instanceof FastCollection && ((FastCollection)c).getValueComparator().equals(cmp)) {
            return c.contains(obj);
        }
        Iterator itr = c.iterator();
        while (itr.hasNext()) {
            if (!cmp.areEqual(obj, itr.next())) continue;
            return true;
        }
        return false;
    }

    @Override
    public boolean retainAll(Collection<?> c) {
        boolean modified = false;
        Record head = this.head();
        Record r = this.tail().getPrevious();
        while (r != head) {
            Record previous = r.getPrevious();
            if (!FastCollection.contains(c, this.valueOf(r), this.getValueComparator())) {
                this.delete(r);
                modified = true;
            }
            r = previous;
        }
        return modified;
    }

    @Override
    public Object[] toArray() {
        return this.toArray(new Object[this.size()]);
    }

    @Override
    public <T> T[] toArray(T[] array) {
        int size = this.size();
        if (array.length < size) {
            throw new UnsupportedOperationException("Destination array too small");
        }
        if (array.length > size) {
            array[size] = null;
        }
        int i = 0;
        T[] arrayView = array;
        Record r = this.head();
        Record end = this.tail();
        while ((r = r.getNext()) != end) {
            arrayView[i++] = this.valueOf(r);
        }
        return array;
    }

    @Override
    public final Text toText() {
        Text text = Text.valueOf((Object)"{");
        Record r = this.head();
        Record end = this.tail();
        while ((r = r.getNext()) != end) {
            text = text.plus(this.valueOf(r));
            if (r.getNext() == end) continue;
            text = text.plus(", ");
        }
        return text.plus("}");
    }

    public final String toString() {
        return this.toText().toString();
    }

    @Override
    public boolean equals(Object obj) {
        if (this instanceof List) {
            return obj instanceof List ? this.equalsOrder((List)obj) : false;
        }
        if (obj instanceof List) {
            return false;
        }
        if (!(obj instanceof Collection)) {
            return false;
        }
        Collection that = (Collection)obj;
        return this == that || this.size() == that.size() && this.containsAll(that);
    }

    private boolean equalsOrder(List that) {
        if (that == this) {
            return true;
        }
        if (this.size() != that.size()) {
            return false;
        }
        Iterator thatIterator = that.iterator();
        FastComparator<E> comp = this.getValueComparator();
        Record r = this.head();
        Record end = this.tail();
        while ((r = r.getNext()) != end) {
            Object o2;
            E o1 = this.valueOf(r);
            if (comp.areEqual(o1, o2 = thatIterator.next())) continue;
            return false;
        }
        return true;
    }

    @Override
    public int hashCode() {
        if (this instanceof List) {
            return this.hashCodeList();
        }
        FastComparator<E> valueComp = this.getValueComparator();
        int hash = 0;
        Record r = this.head();
        Record end = this.tail();
        while ((r = r.getNext()) != end) {
            hash += valueComp.hashCodeOf(this.valueOf(r));
        }
        return hash;
    }

    private int hashCodeList() {
        FastComparator<E> comp = this.getValueComparator();
        int h = 1;
        Record r = this.head();
        Record end = this.tail();
        while ((r = r.getNext()) != end) {
            h = 31 * h + comp.hashCodeOf(this.valueOf(r));
        }
        return h;
    }

    class Unmodifiable
    extends FastCollection
    implements List,
    Set {
        Unmodifiable() {
        }

        public int size() {
            return FastCollection.this.size();
        }

        public Record head() {
            return FastCollection.this.head();
        }

        public Record tail() {
            return FastCollection.this.tail();
        }

        public Object valueOf(Record record) {
            return FastCollection.this.valueOf(record);
        }

        public boolean contains(Object value) {
            return FastCollection.this.contains(value);
        }

        public boolean containsAll(Collection c) {
            return FastCollection.this.containsAll(c);
        }

        public FastComparator getValueComparator() {
            return FastCollection.this.getValueComparator();
        }

        public boolean add(Object obj) {
            throw new UnsupportedOperationException("Unmodifiable");
        }

        public void delete(Record node) {
            throw new UnsupportedOperationException("Unmodifiable");
        }

        public boolean addAll(int index, Collection c) {
            throw new UnsupportedOperationException("Unmodifiable");
        }

        public Object get(int index) {
            return ((List)((Object)FastCollection.this)).get(index);
        }

        public Object set(int index, Object element) {
            throw new UnsupportedOperationException("Unmodifiable");
        }

        public void add(int index, Object element) {
            throw new UnsupportedOperationException("Unmodifiable");
        }

        public Object remove(int index) {
            throw new UnsupportedOperationException("Unmodifiable");
        }

        public int indexOf(Object o) {
            return ((List)((Object)FastCollection.this)).indexOf(o);
        }

        public int lastIndexOf(Object o) {
            return ((List)((Object)FastCollection.this)).lastIndexOf(o);
        }

        public ListIterator listIterator() {
            throw new UnsupportedOperationException("List iterator not supported for unmodifiable collection");
        }

        public ListIterator listIterator(int index) {
            throw new UnsupportedOperationException("List iterator not supported for unmodifiable collection");
        }

        public List subList(int fromIndex, int toIndex) {
            throw new UnsupportedOperationException("Sub-List not supported for unmodifiable collection");
        }
    }

    public static interface Record {
        public Record getPrevious();

        public Record getNext();
    }
}

