﻿## Active Perl 5.8.8

# datapack_development language tool for Japanese.
# part 2 - *.htm、*.py 中の基本単語を一括して日本語化する.

use utf8;
use warnings;
use strict;
use Encode;

binmode STDOUT,':encoding(cp932)';
sub   FS {Encode::encode('cp932',shift)}
sub UTF8 {Encode::decode('cp932',shift)}

my $DEBUG = 0; # 1 or 0
my @CC;

my $LogFile = UTF8(__FILE__);
   $LogFile =~ s!\.[^.\/\\]*$!.log!;
open LOG, '>:utf8', FS($LogFile) or die "'$LogFile' $!";

&start('build/dist/');

print LOG "\n";
for (my $i=0; $i <= $#CC; ++$i) {
	if ($CC[$i]) {print LOG __FILE__,"($i)\t",$CC[$i],"\n"}
}

close LOG;
exit 0;

sub start {
	my ($subDir) = @_;

	print ' [',$subDir,"]\n";
	opendir DIR, FS($subDir) or die "'$subDir' $!";
	my @files = readdir DIR; $_ = UTF8($_) foreach (@files);
	closedir DIR;

	foreach my $fileName (@files) {
		next if $fileName =~ m/^\./;
		next if $fileName =~ m/ /;
		my $filePath = $subDir.$fileName;
		my $outPath = $filePath;
		   $outPath .= '.text' if $DEBUG;

		if (-d FS($filePath)) {
			$filePath =~ s!^\.\/!!;
			&start($filePath.'/');
			next;
		}

		my ($ext, $encode);
		if    ($fileName =~ /\.htm$/) {$ext = 'htm'; $encode = ':utf8'}
		elsif ($fileName =~ /\.py$/ ) {$ext = 'py' ; $encode = ':encoding(cp932)'}
		else {next}

		print "  $filePath\n" if $DEBUG;
		open FILE, '<'.$encode, FS($filePath) or die "'$filePath' $!";
		read FILE,my $text,-s FILE;
		my $mtime = (stat FILE)[9];
		close FILE;

		my $original = $text;
		$_           = $text;
#
s/\bl2ui_ch3\.smallbutton2_down\b/L2UI_ct1.button_df_down/gi;
s/\bl2ui_ch3\.smallbutton2\b/L2UI_ct1.button_df/gi;
#
# .py 用 #
if ($ext eq 'py') {
s{\Q<body>You are either not on a quest that involves this NPC, or you don't meet this NPC's minimum quest requirements.</body>\E}
 {<body>クエストを遂行していないか条件が合いません</body>}g;	#2008.08.25
s{\Q<body>I have nothing to say you</body>\E}
 {<body>クエストを遂行していないか条件が合いません</body>}g;

s{\bYou are either not carrying out your quest or don't meet the criteria\b}
 {クエストを遂行していないか条件が合いません}gi	&&die;	#2007.10.01
s{\bI have nothing to say you\b}
 {クエストを遂行していないか条件が合いません}gi	&&die;

s/\bThis quest have already been completed\b/すでに遂行したクエストです/gsi;
s/\bThis quest has already been completed\b/すでに遂行したクエストです/gsi;
s/\bThis quest have already been State\.COMPLETED\./すでに遂行したクエストです/gsi;	#カマ
s/\bThis quest has already been State\.COMPLETED\./すでに遂行したクエストです/gsi;	#カマ
s/\bQuest for characters level ([0-9]*) and above\b/キャラクターレベルが $1 以上から遂行できるクエストです/gsi;
s/\bQuest for characters level ([0-9]*) or above\b/キャラクターレベルが $1 以上から遂行できるクエストです/gsi;
s/\bQuest for characters level ([0-9]*) above\b/キャラクターレベルが $1 以上から遂行できるクエストです/gsi;

# 漢字. ⇒ 漢字。
s/([\x{3000}-\x{efff}])\./$1。/gsi;	#2007.10.01
}

# .htm 用 #
if ($ext eq 'htm') {

#+080812+
s!<A ACTION!<a action!gi;
s!</A>!</a>!gi;
#

s!(<a action="bypass -h npc_%objectId%_exc_multisell 003">).*?</a>!$1装備を交換する</a>!s;
s!(<a action="bypass -h npc_%objectId%_exc_multisell 1000">).*?</a>!$1ペット装備アップグレード</a>!s;
s!(<a action="bypass -h npc_%objectId%_exc_multisell 1002">).*?</a>!$1Bグレード グローブ、ブーツの封印を解除する</a>!s;
s!(<a action="bypass -h npc_%objectId%_exc_multisell 1003">).*?</a>!$1封印を解除したBグレード グローブ、ブーツをもう一度封印する</a>!s;
#未	s!(<a action="bypass -h npc_%objectId%_exc_multisell 1005">).*?</a>!$1	View list.</a>!s;
s!(<a action="bypass -h npc_%objectId%_FishSkillList">).*?</a>!$1釣りのスキルを習う</a>!s;
s!(<a action="bypass -h npc_%objectId%_multisell 002">).*?</a>!$1ディメンション ダイアモンドを交換する</a>!s;
s!(<a action="bypass -h npc_%objectId%_multisell 009">).*?</a>!$1材料を漁獲の証と交換する</a>!s;
	#
#s!(<a action="bypass -h npc_%objectId%_Quest 1101_teleport_to_race_track") msg="811;.*?">.*?</a>!$1 msg="811;モンスター レース場">モンスター レース場へ移動(無料)</a>!s;
#s!(<a action="bypass -h npc_%objectId%_Quest 1101_teleport_to_race_track") msg="1298;.*?">.*?</a>!$1 msg="1298;モンスター レース場">モンスター レース場から出る</a>!s;
s!(<a action="bypass -h npc_%objectId%_Quest 1104_NewbieTravelToken">).*?</a>!$1トラベラーズトークンでテレポートする</a>!s;
s!(<a action="bypass -h npc_%objectId%_Quest 2000_NoblesseTeleport">).*?</a>!$1\[ノーブレス専用\] テレポートする</a>!s;
s!(<a action="bypass -h npc_%objectId%_Quest 4000_ShadowWeapons">).*?</a>!$1幻影兵器交換券を使う</a>!s;
s!(<a action="bypass -h npc_%objectId%_Quest 8000_RaidbossInfo">).*?</a>!$1レイド モンスター情報</a>!s;
s!(<a action="bypass -h npc_%objectId%_Quest 8001_NpcLocationInfo">).*?</a>!$1NPCの位置案内</a>!s;
s!(<a action="bypass -h npc_%objectId%_Quest 9000_clan">).*?</a>!$1血盟</a>!s;
s!(<a action="bypass -h npc_%objectId%_Quest 9001_alliance">).*?</a>!$1同盟</a>!s;
	#
s!(<a action="bypass -h npc_%objectId%_questlist">).*?</a>!$1クエスト情報</a>!s;
s!(<a action="bypass -h npc_%objectId%_Sell">).*?</a>!$1品物を売る</a>!s;
s!(<a action="bypass -h npc_%objectId%_SkillList">).*?</a>!$1スキルを習う</a>!s;
s!(<a action="bypass -h npc_%objectId%_SupportMagic">).*?</a>!$1補助魔法の力を借りる</a>!s;
#|																補助魔法をかけてもらう
s!(<a action="bypass -h npc_%objectId%_TerritoryStatus">).*?</a>!$1領主及び税率情報を見る</a>!s;
s!(<a action="bypass -h npc_%objectId%_Buy 4[012][0-9]">).*?</a>!$1釣り用品を買う</a>!s;
s!(<a action="bypass -h npc_%objectId%_Link common/augmentation_01.htm">).*?</a>!$1装備を精錬する</a>!s;	#[13]
s!(<a action="bypass -h npc_%objectId%_Link common/augmentation_02.htm">).*?</a>!$1精錬を解除する</a>!s;	#[13]
s!(<a action="bypass -h npc_%objectId%_Link common/crafting_01.htm">).*?</a>!$1アイテム製作</a>!s;	#[21]
s!(<a action="bypass -h npc_%objectId%_Link common/duals_01.htm">).*?</a>!$1二刀流の製作</a>!s;	#[18]
s!(<a action="bypass -h npc_%objectId%_Link common/shadow_01.htm">).*?</a>!$1幻影兵器を買う</a>!s;	#[12]〓〓
s!(<a action="bypass -h npc_%objectId%_Link common/skill_enchant.htm">).*?</a>!$1スキルを強化する</a>!s;	#[26]
s!(<a action="bypass -h npc_%objectId%_Link common/skill_enchant_help.htm">).*?</a>!$1スキルの強化について聞く</a>!s;	#[5]
#未	s!(<a action="bypass -h npc_%objectId%_Link common/skill_enchant_help_01.htm">).*?</a>!$1	〓〓</a>!s;	#[1]
#未	s!(<a action="bypass -h npc_%objectId%_Link common/skill_enchant_help_02.htm">).*?</a>!$1	〓〓</a>!s;	#[1]
#未	s!(<a action="bypass -h npc_%objectId%_Link common/skill_enchant_help_03.htm">).*?</a>!$1	〓〓</a>!s;	#[1]
s!(<a action="bypass -h npc_%objectId%_Link common/weapon_sa_01.htm">).*?</a>!$1武器に特殊能力付与</a>!s;	#[11]
s!(<a action="bypass -h npc_%objectId%_Link fisherman/fishing_championship.htm">).*?</a>!$1釣り王選抜大会</a>!s;	#[69]

s!(<a action="bypass -h player_help 7561.htm">).*?</a>!$1釣りの説明を聞く</a>!s;
s!(<a action="bypass -h player_help 7561.htm#7561">).*?</a>!$1目次に戻る</a>!s;

#
#
#
#
#
#

s!(<a action="bypass -h npc_%objectId%_Chat 0">)[^a-z]*(?:go back|back|return)[^a-z<]*</a>!$1戻る</a>!si;

#未	<a action="bypass -h npc_%objectId%_EnchantSkillList">Skill enchantment.<a><br>
#未	<a action="bypass -h npc_%objectId%_SafeEnchantSkillList">Safe enchantment.</a><br>
#未	<a action="bypass -h npc_%objectId%_UntrainEnchantSkillList">Untrain enchanted skills.</a><br>
#未	<a action="bypass -h npc_%objectId%_ChangeEnchantSkillList">Change enchanted routes.</a>

#++++++++

# ボタン
s!<button value="Main"!<button value="メイン"!g;
s!<button value="Back"!<button value="戻る"!g;
s!<button value="Next"!<button value="次へ"!g;
s!<button value="Return"!<button value="戻る"!;
s!<button value="Go Back"!<button value="戻る"!;
s!<button value="Cancel"!<button value="ｷｬﾝｾﾙ"!;
s!<button value="Yes"!<button value="はい"!;
s!<button value="No"!<button value="いいえ"!;
s!<button value="Close"!<button value="閉じる"!;
s!<button value="Submit"!<button value="送信"!;
s!<button value="Enter"!<button value="確定"!;	#〓〓

# 頻出文・基本単語

s/(>\s*\(?)Quest for characters level ([0-9]*) and above\.?(\)?\s*<)/$1キャラクターレベルが $2 以上から遂行できるクエストです。$3/gsi;
s/(>\s*\(?)Quest for characters level ([0-9]*) or above\.?(\)?\s*<)/$1キャラクターレベルが $2 以上から遂行できるクエストです。$3/gsi;
#

s/(>\s*)Get information on changing occupations?\.?(\s*<)/$1転職に関する情報を聞く$2/si;
s/(>\s*)Ask about changing occupations?(\.?\s*<)/$1転職について尋ねる$2/si;
s/(>\s*)Hear about changing occupations?(\.?\s*<)/$1転職について$2/si;
s/(>\s*)Get information on 2nd occupational change(\.\s*<)/$1２次転職に関する情報を聞く$2/si;
s/(>\s*)Listen to information about 2nd occupational change(\.?\s*<)/$1２次転職についての情報を聞く$2/si;
s/(>\s*)Hear information on 2nd occupational change(\.?\s*<)/$1２次転職について$2/si;

s/(>\s*)Buy Fighters?\'? Equipment\.?(\s*<)/$1ファイター用の装備を買う$2/si;
s/(>\s*)Buy Mystics?\'? Equipment\.?(\s*<)/$1メイジ用の装備を買う$2/si;
	s/(>\s*)Buy Equipment for a Warrior\.?(\s*<)/$1ファイター用の装備を買う$2/si;
	s/(>\s*)Buy Equipment for a Mystic\.?(\s*<)/$1メイジ用の装備を買う$2/si;
s/(>\s*)Wear Fighters?\'? Equipment\.?(\s*<)/$1ファイター用の装備を試着してみる$2/si;
s/(>\s*)Wear Mystics?\'? Equipment\.?(\s*<)/$1メイジ用の装備を試着してみる$2/si;
	s/>Buy Fighters\' Weapon</>ファイター用の武器を買う</si;
	s/>Buy Mystics\' Weapon</>メイジ用の武器を買う</si;
	s/>Wear Fighters\' Weapon</>ファイター用の武器を試着してみる</si;
	s/>Wear Mystics\' Weapon</>メイジ用の武器を試着してみる</si;
s/>Buy Accessories</>アクセサリーを買う</si;


s/(?<=[>"])Say you will take the task\.?(?=["<])/手伝うと言う/si;
s/(?<=[>"])I will help you\.?(?=["<])/手伝うと言う/si;
s/(?<=[>"])I will help\.?(?=["<])/手伝うと言う/si;

#
#
#

#
#
#

s!>Back\.?</a>!>戻る</a>!gi;
s!>Quit\.?</a>!>閉じる</a>!gi;	#2007.10.01 -- 仮
s!>Quest\.?</a>!>クエスト</a>!gi;
s!>Return\.?</a>!>戻る</a>!gi;
s/(>\s*)Buy(\s*<)/$1買う$2/si;
s!(>\s*)Teleport(\.?\s*</)!$1テレポートする$2!gsi;

	s/\bAdventure Guild Member\b/【冒険家組合員】/gsi;
s/\bFishermen\'s Guild Member\b/釣り場組合員/gsi;
s/\bFishing Guild Member\b/釣り場組合員/gsi;
s/\bnewbie helper\b/初心者インストラクター/gsi;
s/\bAdventure Guide\b/冒険者 インストラクター/gsi;	#2008.08.31
s/\bnewbie guides\b/初心者 案内人/gsi;
s/\bnewbie guide\b/初心者 案内人/gsi;
s/\bnewbie Character\b/【新規キャラクター】/gsi;
	s/\bnewbies\b/【新規キャラクター】/gsi;
s/\bnewbie\b/【新規キャラクター】/gsi;

#未確認 -- s/>"Tell me about novice characters\.?"</>新規キャラクターについて</si;
#未確認 -- s/>View the list of assist magics\.?</>初心者補助魔法の一覧を見る</si;

# 地名
s/\bTalking Island Village\b/話せる島の村/gsi;
s/\bDark Elven Village\b/ダークエルフの村/gsi;
s/\bDark Elf Village\b/ダークエルフの村/gsi;
s/\bElven Village\b/エルフの村/gsi;
s/\bDwarven Village\b/ドワーフ村/gsi;
s/\bOrc Village\b/オーク村/gsi;
s/\bKamael Village\b/カマエルの村/gsi;

s/\bGludin Village\b/グルーディン村/gsi;
s/\bThe Village of Gludin\b/グルーディン村/gsi;
s/\bGludin Arena\b/グルーディン村決闘場/gsi;
s/\bTown of Gludio\b/グルーディオ城の村/gsi;
s/\bTown of Dion\b/ディオン村/gsi;
s/\bFloran Village\b/フローラン村/gsi;
s/\bTown of Giran\b/ギラン城の村/gsi;
s/\bGiran Arena\b/ギラン決闘場/gsi;
s/\bHunters Village\b/猟師の村/gsi;
s/\bTown of Aden\b/アデン城の村/gsi;
s/\bColiseum\b/コロシアム/gsi;
s/\bTown of Oren\b/オーレン城の村/gsi;
s/\bRune Township\b/ルウン城の村/gsi;
s/\bTown of Goddard\b/ゴダード城の村/gsi;
s/\bHeine\b/水上都市ハイネス/gsi;
s/\bTown of Schuttgart\b/シュチュッツガルド城の村/gsi;
s/\bIvory Tower\b/象牙の塔/gsi;

s/\bAnt Nest\b/蟻の巣/gsi;
s/\bWindawood Manor\b/ウインダウッドの荘園/gsi;
s/\bRuins of Agony\b/悲嘆の廃墟/gsi;
s/\bRuins of Despair/絶望の廃墟/gsi;

# The 漢字 の The を消す
s/\bThe ([\x{3000}-\x{efff}])/$1/gsi;

# 墓場
	s/(>\s*)I have nothing to say you\.?(\s*<)/$1クエストを遂行していないか条件が合いません。$2/gsi;
	s/(>\s*)This quest have already been completed\.?(\s*<)/$1すでに遂行したクエストです。$2/gsi;
	s/(>\s*)This quest has already been completed[\.!]?(\s*<)/$1すでに遂行したクエストです。$2/gsi;
	s/(>\s*\(?)Quest for characters level ([0-9]*) above\.?(\)?\s*<)/$1キャラクターレベルが $2 以上から遂行できるクエストです。$3/gsi;

	s!>Alliance\.?</a>!>同盟</a>!gi;
	s!>Clan\.?</a>!>血盟</a>!gi;

	s!>Alliance\.?</a>!>同盟</a>!gsi;
	s!>Clan\.?</a>!>血盟</a>!gsi;
	s!>Back\.?</a>!>戻る</a>!gsi;
	s!>Quit\.?</a>!>閉じる</a>!gsi;	#2007.10.01 -- 仮
	s!>Quest\.?</a>!>〓クエスト〓</a>!gsi;
	s!>Return\.?</a>!>戻る</a>!gsi;
} # htm用
#
		$text = $_;
		next if $text eq $original;

		open FILE, '>'.$encode, FS($outPath) or die "'$outPath' $!";
		print FILE $text;
		close FILE;
		utime $mtime, $mtime, FS($outPath);

		my $i = &minidiff($text, $original);
		print '●',$outPath,"($i)\n";
		print LOG  $outPath,"($i)\n";
	}
}

sub minidiff {
	my ($textA, $textB) = @_;

	$textA =~ s/^\x{FEFF}//;
	$textB =~ s/^\x{FEFF}//;
	my @A = split /\n/,$textA;
	my @B = split /\n/,$textB;
	my $min = $#A <= $#B ? $#A : $#B;
	for (my $i=0; $i <=$min; ++$i) {
		return $i+1 if $A[$i] ne $B[$i];
	}
	return 0;
}
