## Active Perl 5.8.8
# 注意>ppm install DBD-mysql

# *.htm 中のクラス名を一括して日本語化する
# クラスマスター編

use utf8;
use strict;
use warnings;
use Encode;
use DBI;

binmode STDOUT,':encoding(cp932)';
sub   FS {Encode::encode('cp932',shift)}
sub UTF8 {Encode::decode('cp932',shift)}

my $vars_txt = 'tools/vars.txt';
open FILE,'<',$vars_txt  or do {warn "'$vars_txt' $!";exit 0};
read FILE,my $vars,-s FILE;
close FILE;
my $gsuser = ($vars =~ m/^\@*set gsuser=(.+)$/m)[0];
my $gspass = ($vars =~ m/^@*set gspass=(.+)$/m)[0];
my $gsdb   = ($vars =~ m/^@*set gsdb=(.+)$/m)[0];
my $gshost = ($vars =~ m/^@*set gshost=(.+)$/m)[0];

my $DEBUG = 0; # 1 or 0

my $LogFile = UTF8(__FILE__);
   $LogFile =~ s!\.[^.\/\\]*$!.log!;
open LOG, '>:utf8', FS($LogFile)  or die "'$LogFile' $!";

my $db = DBI->connect("DBI:mysql:$gsdb:$gshost", $gsuser, $gspass) or do{warn DBI::errstr;exit 0};
   $db->do('SET NAMES UTF8');

&start('build/dist/gameserver/data/html/classmaster/');

close LOG;
exit 0;

sub start {
	my ($subDir) = @_;

	print ' [',$subDir,"]\n" if $DEBUG;
	opendir DIR, FS($subDir) or die "'$subDir' $!";
	my @files = readdir DIR; foreach (@files) { $_ = UTF8($_) }
	closedir DIR;

	foreach my $fileName (@files) {
		next if $fileName =~ m/^\./;
		next if $fileName =~ m/ /;

		my $filePath = $subDir.$fileName;

		if (-d FS($filePath)) {
		#	&start($filePath.'/');
			next;

		}

		next unless $fileName =~ /^[0-9]+\.htm$/;

		my $outPath = $filePath;
		   $outPath .= '.text' if $DEBUG;

		print "  $filePath\n" if $DEBUG;
		open FILE, '<:utf8', FS($filePath) or die "'$filePath' $!";
		my $mtime = (stat FILE)[9];
		my @TEXT = <FILE>;
		close FILE;

		my $UPDATE = 0;
		my ($id, $name_en);
		my $name_jp;
		for my $ix (0..$#TEXT) {
			my $text = $TEXT[$ix];

			if ($text =~ m!>(.*?)Class Master:<!) {
				$name_en = $1;
				$id = ($fileName =~ /^([0-9]+)\.htm$/)[0];

				$name_jp = &GetName($id).' クラスマスター';
				next unless $name_jp;
				next if $name_jp eq $name_en;

				$text =~ s!>(.*?)Class Master:<!>$name_jp:<!;

			} elsif ($text =~ m!<a action="bypass -h npc_%objectId%_change_class (\d+)">(Advance to .*?)</a>!) {
				$id = $1;
				$name_en = $2;
				
				$name_jp = &GetName($id).'に転職する';
				next unless $name_jp;
				next if $name_jp eq $name_en;

				$text =~ s!<a action="bypass -h npc_%objectId%_change_class (\d+)">(Advance to .*?)</a>!<a action="bypass -h npc_%objectId%_change_class $id">$name_jp</a>!;
			}

			if ($text ne $TEXT[$ix]) {
				print '●',$outPath,"(",$ix+1,")\n" unless $UPDATE;
				print     "\t[",$name_en,"]\n";
				print     "\t[",$name_jp,"]\n";
				print LOG  $outPath,"(",$ix+1,")\n" unless $UPDATE;
				print LOG "\t[",$name_en,"]\n";
				print LOG "\t[",$name_jp,"]\n";

				$TEXT[$ix] = $text;
				$UPDATE = 1;
			}
		}
		if ($UPDATE) {
			open FILE, '>:utf8', FS($outPath) or die "'$outPath' $!";
			print FILE @TEXT;
			close FILE;
			utime $mtime, $mtime, FS($outPath);
		}
	}
}

sub GetName {
	my ($id) = @_;

	my $sql = "SELECT name FROM classname_ja WHERE id=?";
	my $sth = $db->prepare($sql);
	$sth->execute($id) or die DBI::errstr;
	$sth->bind_columns(undef, \(my($N_name))) or die DBI::errstr;
	my $rc = $sth->fetch();
	   utf8::decode($N_name);

	return '' unless $N_name;
#	$N_name =~ s/\([男女]性?\)$//;	# カマエル
	return $N_name;
}
