-- Information about category:
-- Only one drop will be given per category, except in the cases when category is -1.
-- Category -1 is used for SPOIL/SWEEP drops only!  Do NOT change this.
-- In general, category 0 is for adena and 1 seal stone color (each seal stone color should be in a different category).
-- In general, category 1 is for full drops and parts of equipable items.  However, you can change this.
-- In general, category 2 is for all other items.  However, you can change this.
-- In general, more categories are only used for RBs who have 1 item per category (i.e. do not really drop categorized),
-- with the sole exception of category 200 that is used for Life Stones. However, you can change this too.
-- You can create more categories as you see fit.  Just make sure the "category" number is non-negative!!
-- Also, it is NOT a problem if category numbers are skipped (so you can have -1, 1, 5, 10 as your categories).
--
-- If you wish to allow more than one item to be given from the same category, you can
-- split them up over several categories.
-- In addition, RBs and Grandbosses (mainly) may have the exact same item repeated in multiple categories.
-- This allows mobs to give 1 copy of the drop to each of several people (if they are lucky enough to get the drops).
-- Calculation for each drop, when in categories, is equivallent in chance as when outside of categories.
-- First, the sum of chances for each category is calculated as category chance.  If the category is selected
-- for drops (i.e. its chance is successful), then exactly 1 item from that category will be selected, with 
-- such a chance that the overall probability is maintained unchanged. 


--
-- Table structure for table `droplist`
--
DROP TABLE IF EXISTS `droplist`;
CREATE TABLE `droplist` (
  `mobId` INT NOT NULL DEFAULT '0',
  `itemId` INT NOT NULL DEFAULT '0',
  `min` INT NOT NULL DEFAULT '0',
  `max` INT NOT NULL DEFAULT '0',
  `category` INT NOT NULL DEFAULT '0',
  `chance` INT NOT NULL DEFAULT '0',
  PRIMARY KEY  (`mobId`,`itemId`,`category`),
  KEY `key_mobId` (`mobId`)
) ENGINE=MyISAM;

-- 
-- Dumping data for table `droplist`
-- 
-- Category Explanation (non-RaidBoss & non-GrandBoss)
--   -1 is sweep
--    0 is adena and one of the seal stones (your choice)
--    1 is any item that is in weapon.sql, any item in armor.sql, and some of the items from etcitem. Before dropping the column, I had those marked in etcitem.sql. However, you can recognize them easily. If they are parts unique for crafting equipable items, it's category 1.
--    2 is almost all of the other items except:
--    3 and 4 are used for the other two seal stones (1 category each).
-- 
INSERT INTO `droplist` VALUES 
(18001,1806,1,1,-1,10868), -- Recipe: Soulshot: B-Grade
(18001,57,765,1528,0,700000), -- Adena
(18001,2397,1,1,1,12), -- Tunic of Zubei
(18001,2402,1,1,1,19), -- Stockings of Zubei
(18001,2406,1,1,1,8), -- Avadon Robe
(18001,4069,1,1,1,2102), -- Tunic of Zubei Fabric
(18001,4070,1,1,1,3192), -- Stockings of Zubei Fabric
(18001,4071,1,1,1,1615), -- Avadon Robe Fabric
(18001,1419,1,1,2,200000), -- Blood Mark
(18001,1864,1,1,2,178349), -- Stem
(18001,1866,1,1,2,59450), -- Suede
(18001,1878,1,1,2,35670), -- Braided Hemp
(18001,1885,1,1,2,7432), -- High Grade Suede
(18001,1889,1,1,2,5945), -- Compound Braid
(18001,4197,1,1,2,68), -- Recipe: Demon\'s Sword
(18003,1871,1,1,-1,9797), -- Charcoal
(18010,57,173,347,0,700000), -- Adena
(18012,57,148,293,0,700000), -- Adena
(18013,57,148,293,0,700000), -- Adena
(18014,57,228,455,0,700000), -- Adena
(18015,57,194,387,0,700000), -- Adena
(18017,57,194,387,0,700000), -- Adena
(18018,57,253,504,0,700000), -- Adena
(18020,57,305,611,0,700000), -- Adena
(18022,57,265,529,0,700000), -- Adena
(18023,57,265,529,0,700000), -- Adena
(18024,57,381,761,0,700000), -- Adena
(18025,57,335,669,0,700000), -- Adena
(18027,57,335,669,0,700000), -- Adena
(18028,57,414,829,0,700000), -- Adena
(18030,57,486,972,0,700000), -- Adena
(18032,57,431,863,0,700000), -- Adena
(18033,57,431,863,0,700000), -- Adena
(18034,57,585,1171,0,700000), -- Adena
(18035,57,525,1049,0,700000), -- Adena
(18037,57,525,1049,0,700000), -- Adena
(18038,57,629,1257,0,700000), -- Adena
(18040,57,721,1443,0,700000), -- Adena
(18042,57,651,1302,0,700000), -- Adena
(18043,57,651,1302,0,700000), -- Adena
(18044,57,848,1697,0,700000), -- Adena
(18045,57,770,1541,0,700000), -- Adena
(18047,57,770,1541,0,700000), -- Adena
(18048,57,902,1804,0,700000), -- Adena
(18050,57,902,1804,0,700000), -- Adena
(18052,57,902,1804,0,700000), -- Adena
(18053,57,902,1804,0,700000), -- Adena
(18054,57,902,1804,0,700000), -- Adena
(18055,57,902,1804,0,700000), -- Adena
(18057,57,902,1804,0,700000), -- Adena
(18058,57,902,1804,0,700000), -- Adena
(18060,57,173,347,0,700000), -- Adena
(18062,57,148,293,0,700000), -- Adena
(18063,57,148,293,0,700000), -- Adena
(18064,57,228,455,0,700000), -- Adena
(18065,57,194,387,0,700000), -- Adena
(18067,57,194,387,0,700000), -- Adena
(18068,57,253,504,0,700000), -- Adena
(18070,57,305,611,0,700000), -- Adena
(18072,57,265,529,0,700000), -- Adena
(18073,57,265,529,0,700000), -- Adena
(18074,57,381,761,0,700000), -- Adena
(18075,57,335,669,0,700000), -- Adena
(18077,57,335,669,0,700000), -- Adena
(18078,57,414,829,0,700000), -- Adena
(18080,57,486,972,0,700000), -- Adena
(18082,57,431,863,0,700000), -- Adena
(18083,57,431,863,0,700000), -- Adena
(18084,57,585,1171,0,700000), -- Adena
(18085,57,525,1049,0,700000), -- Adena
(18087,57,525,1049,0,700000), -- Adena
(18088,57,629,1257,0,700000), -- Adena
(18090,57,721,1443,0,700000), -- Adena
(18092,57,651,1302,0,700000), -- Adena
(18093,57,651,1302,0,700000), -- Adena
(18094,57,848,1697,0,700000), -- Adena
(18095,57,770,1541,0,700000), -- Adena
(18097,57,770,1541,0,700000), -- Adena
(18098,57,902,1804,0,700000), -- Adena
(18100,57,902,1804,0,700000), -- Adena
(18102,57,902,1804,0,700000), -- Adena
(18103,57,902,1804,0,700000), -- Adena
(18104,57,902,1804,0,700000), -- Adena
(18105,57,902,1804,0,700000), -- Adena
(18107,57,902,1804,0,700000), -- Adena
(18108,57,902,1804,0,700000), -- Adena
(18109,955,1,1,2,2000), -- Scroll: Enchant Weapon (Grade D)
(18109,956,1,1,2,15000), -- Scroll: Enchant Armor (Grade D)
(18109,1060,1,1,2,50000), -- Lesser Healing Potion
(18109,1061,1,1,2,50000), -- Healing Potion
(18110,951,1,1,2,1500), -- Scroll: Enchant Weapon (Grade C)
(18110,952,1,1,2,12000), -- Scroll: Enchant Armor (Grade C)
(18110,1061,1,1,2,50000), -- Healing Potion
(18110,1832,1,1,2,25000), -- Greater Antidote
(18110,1834,1,1,2,25000), -- Emergency Dressing
(18111,734,1,1,2,25000), -- Haste Potion
(18111,735,1,1,2,25000), -- Potion of Alacrity
(18111,951,1,1,2,2000), -- Scroll: Enchant Weapon (Grade C)
(18111,952,1,1,2,18000), -- Scroll: Enchant Armor (Grade C)
(18111,1539,1,1,2,50000), -- Greater Healing Potion
(18112,734,1,1,2,25000), -- Haste Potion
(18112,735,1,1,2,25000), -- Potion of Alacrity
(18112,947,1,1,2,500), -- Scroll: Enchant Weapon (Grade B)
(18112,948,1,1,2,7000), -- Scroll: Enchant Armor (Grade B)
(18112,1539,1,1,2,50000), -- Greater Healing Potion
(18113,729,1,1,2,300), -- Scroll: Enchant Weapon (Grade A)
(18113,730,1,1,2,2500), -- Scroll: Enchant Armor (Grade A)
(18113,734,1,1,2,25000), -- Haste Potion
(18113,735,1,1,2,25000), -- Potion of Alacrity
(18113,1539,1,1,2,50000), -- Greater Healing Potion
(18114,955,1,1,2,2000), -- Scroll: Enchant Weapon (Grade D)
(18114,956,1,1,2,15000), -- Scroll: Enchant Armor (Grade D)
(18114,1060,1,1,2,50000), -- Lesser Healing Potion
(18114,1061,1,1,2,50000), -- Healing Potion
(18115,951,1,1,2,1500), -- Scroll: Enchant Weapon (Grade C)
(18115,952,1,1,2,12000), -- Scroll: Enchant Armor (Grade C)
(18115,1061,1,1,2,50000), -- Healing Potion
(18115,1832,1,1,2,25000), -- Greater Antidote
(18115,1834,1,1,2,25000), -- Emergency Dressing
(18116,734,1,1,2,25000), -- Haste Potion
(18116,735,1,1,2,25000), -- Potion of Alacrity
(18116,951,1,1,2,2000), -- Scroll: Enchant Weapon (Grade C)
(18116,952,1,1,2,18000), -- Scroll: Enchant Armor (Grade C)
(18116,1539,1,1,2,50000), -- Greater Healing Potion
(18117,734,1,1,2,25000), -- Haste Potion
(18117,735,1,1,2,25000), -- Potion of Alacrity
(18117,947,1,1,2,500), -- Scroll: Enchant Weapon (Grade B)
(18117,948,1,1,2,7000), -- Scroll: Enchant Armor (Grade B)
(18117,1539,1,1,2,50000), -- Greater Healing Potion
(18118,729,1,1,2,300), -- Scroll: Enchant Weapon (Grade A)
(18118,730,1,1,2,2500), -- Scroll: Enchant Armor (Grade A)
(18118,734,1,1,2,25000), -- Haste Potion
(18118,735,1,1,2,25000), -- Potion of Alacrity
(18118,1539,1,1,2,50000), -- Greater Healing Potion
(18256,57,1370,2743,0,700000), -- Adena
(18256,81,1,1,1,2), -- Dragon Slayer
(18256,151,1,1,1,2), -- Sword of Miracles 
(18256,2500,1,1,1,2), -- Dark Legion\'s Edge
(18256,5529,1,1,1,440), -- Dragon Slayer Edge
(18256,5545,1,1,1,440), -- Dark Legion\'s Edge Blade
(18256,5546,1,1,1,483), -- Sword of Miracles Edge
(18256,959,1,1,2,8), -- Scroll: Enchant Weapon (Grade S)
(18256,1895,1,1,2,54858), -- Metallic Fiber
(18256,4040,1,1,2,3841), -- Mold Lubricant
(18256,4042,1,1,2,3201), -- Enria
(18256,4043,1,1,2,6401), -- Asofe
(18265,57,480,858,0,700000), -- Adena
(18265,955,1,1,2,3740), -- Scroll: Enchant Weapon (Grade D)
(18265,956,1,1,2,31162), -- Scroll: Enchant Armor (Grade D)
(18266,57,483,891,0,700000), -- Adena
(18266,955,1,1,2,3855), -- Scroll: Enchant Weapon (Grade D)
(18266,956,1,1,2,32122), -- Scroll: Enchant Armor (Grade D)
(18267,57,484,932,0,700000), -- Adena
(18267,955,1,1,2,3905), -- Scroll: Enchant Weapon (Grade D)
(18267,956,1,1,2,32541), -- Scroll: Enchant Armor (Grade D)
(18268,57,708,1417,0,700000), -- Adena
(18268,955,1,1,2,5804), -- Scroll: Enchant Weapon (Grade D)
(18268,956,1,1,2,48367), -- Scroll: Enchant Armor (Grade D)
(18269,57,732,1465,0,700000), -- Adena
(18269,955,1,1,2,5940), -- Scroll: Enchant Weapon (Grade D)
(18269,956,1,1,2,49492), -- Scroll: Enchant Armor (Grade D)
(18270,57,758,1520,0,700000), -- Adena
(18270,955,1,1,2,6163), -- Scroll: Enchant Weapon (Grade D)
(18270,956,1,1,2,51357), -- Scroll: Enchant Armor (Grade D)
(18271,57,789,1572,0,700000), -- Adena
(18271,955,1,1,2,6338), -- Scroll: Enchant Weapon (Grade D)
(18271,956,1,1,2,52816), -- Scroll: Enchant Armor (Grade D)
(18272,57,1257,2519,0,700000), -- Adena
(18272,951,1,1,2,4563), -- Scroll: Enchant Weapon (Grade C)
(18272,952,1,1,2,33462), -- Scroll: Enchant Armor (Grade C)
(18273,57,1293,2582,0,700000), -- Adena
(18273,951,1,1,2,4604), -- Scroll: Enchant Weapon (Grade C)
(18273,952,1,1,2,33756), -- Scroll: Enchant Armor (Grade C)
(18274,57,1330,2656,0,700000), -- Adena
(18274,951,1,1,2,4652), -- Scroll: Enchant Weapon (Grade C)
(18274,952,1,1,2,34111), -- Scroll: Enchant Armor (Grade C)
(18275,57,1952,3909,0,700000), -- Adena
(18275,951,1,1,2,6718), -- Scroll: Enchant Weapon (Grade C)
(18275,952,1,1,2,49264), -- Scroll: Enchant Armor (Grade C)
(18276,57,1997,3995,0,700000), -- Adena
(18276,947,1,1,2,1468), -- Scroll: Enchant Weapon (Grade B)
(18276,948,1,1,2,9176), -- Scroll: Enchant Armor (Grade B)
(18277,57,2049,4095,0,700000), -- Adena
(18277,947,1,1,2,1433), -- Scroll: Enchant Weapon (Grade B)
(18277,948,1,1,2,8957), -- Scroll: Enchant Armor (Grade B)
(18278,57,2683,5361,0,700000), -- Adena
(18278,947,1,1,2,1877), -- Scroll: Enchant Weapon (Grade B)
(18278,948,1,1,2,11732), -- Scroll: Enchant Armor (Grade B)
(18279,57,2736,5473,0,700000), -- Adena
(18279,947,1,1,2,1916), -- Scroll: Enchant Weapon (Grade B)
(18279,948,1,1,2,11969), -- Scroll: Enchant Armor (Grade B)
(18280,57,2790,5576,0,700000), -- Adena
(18280,729,1,1,2,543), -- Scroll: Enchant Weapon (Grade A)
(18280,730,1,1,2,4067), -- Scroll: Enchant Armor (Grade A)
(18281,57,2849,5701,0,700000), -- Adena
(18281,729,1,1,2,555), -- Scroll: Enchant Weapon (Grade A)
(18281,730,1,1,2,4157), -- Scroll: Enchant Armor (Grade A)
(18282,57,4009,8028,0,700000), -- Adena
(18282,729,1,1,2,781), -- Scroll: Enchant Weapon (Grade A)
(18282,730,1,1,2,5854), -- Scroll: Enchant Armor (Grade A)
(18283,57,4078,8168,0,700000), -- Adena
(18283,959,1,1,2,286), -- Scroll: Enchant Weapon (Grade S)
(18283,960,1,1,2,2860), -- Scroll: Enchant Armor (Grade S)
(18284,57,4146,8295,0,700000), -- Adena
(18284,959,1,1,2,291), -- Scroll: Enchant Weapon (Grade S)
(18284,960,1,1,2,2904), -- Scroll: Enchant Armor (Grade S)
(18285,57,5312,10638,0,700000), -- Adena
(18285,959,1,1,2,373), -- Scroll: Enchant Weapon (Grade S)
(18285,960,1,1,2,3724), -- Scroll: Enchant Armor (Grade S)
(18286,57,5393,10798,0,700000), -- Adena
(18286,959,1,1,2,378), -- Scroll: Enchant Weapon (Grade S)
(18286,960,1,1,2,3780), -- Scroll: Enchant Armor (Grade S)
(18287,57,186,372,0,700000), -- Adena
(18287,955,1,1,2,1508), -- Scroll: Enchant Weapon (Grade D)
(18287,956,1,1,2,12560), -- Scroll: Enchant Armor (Grade D)
(18288,57,207,413,0,700000), -- Adena
(18288,955,1,1,2,1680), -- Scroll: Enchant Weapon (Grade D)
(18288,956,1,1,2,13997), -- Scroll: Enchant Armor (Grade D)
(18289,57,308,617,0,700000), -- Adena
(18289,951,1,1,2,1119), -- Scroll: Enchant Weapon (Grade C)
(18289,952,1,1,2,8205), -- Scroll: Enchant Armor (Grade C)
(18290,57,338,676,0,700000), -- Adena
(18290,951,1,1,2,1205), -- Scroll: Enchant Weapon (Grade C)
(18290,952,1,1,2,8833), -- Scroll: Enchant Armor (Grade C)
(18291,57,472,944,0,700000), -- Adena
(18291,947,1,1,2,347), -- Scroll: Enchant Weapon (Grade B)
(18291,948,1,1,2,2168), -- Scroll: Enchant Armor (Grade B)
(18292,57,519,1010,0,700000), -- Adena
(18292,947,1,1,2,375), -- Scroll: Enchant Weapon (Grade B)
(18292,948,1,1,2,2342), -- Scroll: Enchant Armor (Grade B)
(18293,57,681,1361,0,700000), -- Adena
(18293,729,1,1,2,133), -- Scroll: Enchant Weapon (Grade A)
(18293,730,1,1,2,993), -- Scroll: Enchant Armor (Grade A)
(18294,57,728,1457,0,700000), -- Adena
(18294,729,1,1,2,142), -- Scroll: Enchant Weapon (Grade A)
(18294,730,1,1,2,1063), -- Scroll: Enchant Armor (Grade A)
(18295,57,938,1879,0,700000), -- Adena
(18295,729,1,1,2,183), -- Scroll: Enchant Weapon (Grade A)
(18295,730,1,1,2,1370), -- Scroll: Enchant Armor (Grade A)
(18296,57,995,1993,0,700000), -- Adena
(18296,959,1,1,2,70), -- Scroll: Enchant Weapon (Grade S)
(18296,960,1,1,2,698), -- Scroll: Enchant Armor (Grade S)
(18297,57,1239,2481,0,700000), -- Adena
(18297,959,1,1,2,87), -- Scroll: Enchant Weapon (Grade S)
(18297,960,1,1,2,869), -- Scroll: Enchant Armor (Grade S)
(18298,57,1301,2604,0,700000), -- Adena
(18298,959,1,1,2,92), -- Scroll: Enchant Weapon (Grade S)
(18298,960,1,1,2,912), -- Scroll: Enchant Armor (Grade S)
(18319,6529,1,1,1,1159), -- Baby Duck Rod
(18319,6519,1,1,2,86953), -- Green Colored Lure - Low Grade
(18319,6522,1,1,2,57969), -- Purple Colored Lure - Low Grade
(18319,6525,1,1,2,72461), -- Yellow Colored Lure - Low Grade
(18319,6535,12,36,2,120768), -- Fishing Shot: non-grade
(18320,6530,1,1,1,527), -- Albatross Rod
(18320,6519,1,1,2,131712), -- Green Colored Lure - Low Grade
(18320,6522,1,1,2,87808), -- Purple Colored Lure - Low Grade
(18320,6525,1,1,2,109760), -- Yellow Colored Lure - Low Grade
(18320,6536,12,36,2,109760), -- Fishing Shot: D-grade
(18321,6531,1,1,1,200), -- Pelican Rod
(18321,6520,2,6,2,33251), -- Green Colored Lure 
(18321,6523,1,1,2,110836), -- Purple Colored Lure
(18321,6526,1,1,2,133003), -- Yellow Colored Lure
(18321,6537,12,36,2,118753), -- Fishing Shot: C-grade
(18322,6532,1,1,1,108), -- KingFisher Rod
(18322,6520,2,6,2,67551), -- Green Colored Lure 
(18322,6523,1,1,2,180134), -- Purple Colored Lure
(18322,6526,3,9,2,36027), -- Yellow Colored Lure
(18322,6538,15,45,2,43232), -- Fishing Shot: B-grade
(18323,6533,1,1,1,41), -- Cygnus Pole
(18323,6521,2,6,2,67649), -- Green Colored Lure - High Grade
(18323,6524,1,1,2,202945), -- Purple Colored Lure - High Grade
(18323,6527,2,6,2,45099), -- Yellow Colored Lure - High Grade
(18323,6539,3,9,2,169121), -- Fishing Shot: A-grade
(18324,6533,1,1,1,61), -- Cygnus Pole
(18324,6521,2,6,2,81602), -- Green Colored Lure - High Grade
(18324,6524,1,1,2,244805), -- Purple Colored Lure - High Grade
(18324,6527,2,6,2,54401), -- Yellow Colored Lure - High Grade
(18324,6539,3,9,2,204004), -- Fishing Shot: A-grade
(18325,6534,1,1,1,17), -- Triton Pole
(18325,6521,2,6,2,70774), -- Green Colored Lure - High Grade
(18325,6524,1,1,2,212320), -- Purple Colored Lure - High Grade
(18325,6527,2,6,2,47183), -- Yellow Colored Lure - High Grade
(18325,6540,3,9,2,141547), -- Fishing Shot: S-grade
(18326,6534,1,1,1,30), -- Triton Pole
(18326,6521,2,6,2,85774), -- Green Colored Lure - High Grade
(18326,6524,1,1,2,257320), -- Purple Colored Lure - High Grade
(18326,6527,2,6,2,57183), -- Yellow Colored Lure - High Grade
(18326,6540,3,9,2,171547), -- Fishing Shot: S-grade
(20003,116,1,1,-1,343131), -- Magic Ring
(20003,1786,1,1,-1,45293), -- Recipe: Broad Sword
(20003,1871,1,1,-1,56617), -- Charcoal
(20003,57,30,42,0,700000), -- Adena
(20003,112,1,1,1,79637), -- Apprentice\'s Earring
(20003,116,1,1,1,118249), -- Magic Ring
(20003,118,1,1,1,59125), -- Necklace of Magic
(20003,1788,1,1,2,7805), -- Recipe: Bow 
(20003,1864,1,1,2,19512), -- Stem
(20003,1865,1,1,2,9756), -- Varnish
(20003,1866,1,1,2,6504), -- Suede
(20003,1868,1,1,2,19512), -- Thread
(20003,1873,1,1,2,3903), -- Silver Nugget
(20004,1866,1,1,-1,51827), -- Suede
(20004,2005,1,1,-1,5553), -- Broadsword Blade
(20004,2006,1,1,-1,5553), -- Willow Staff Head
(20004,57,41,58,0,700000), -- Adena
(20004,1119,1,1,1,5045), -- Short Leather Gloves
(20004,1122,1,1,1,5044), -- Cotton Shoes
(20004,1129,1,1,1,5044), -- Crude Leather Shoes
(20004,1666,1,1,2,5104), -- Recipe: Wooden Arrow
(20004,1866,1,1,2,10206), -- Suede
(20004,1871,1,1,2,15309), -- Charcoal
(20005,1060,1,1,-1,216259), -- Lesser Healing Potion
(20005,1666,1,1,-1,32439), -- Recipe: Wooden Arrow
(20005,1866,1,1,-1,64878), -- Suede
(20005,57,51,72,0,700000), -- Adena
(20005,19,1,1,1,9012), -- Small Shield
(20005,42,1,1,1,6311), -- Leather Cap
(20005,17,10,30,2,71865), -- Wooden Arrow
(20005,1789,1,1,2,2657), -- Recipe: Cedar Staff
(20005,1865,1,1,2,14373), -- Varnish
(20005,1870,1,1,2,14373), -- Coal
(20006,113,1,1,-1,31655), -- Mystic\'s Earring
(20006,1060,1,1,-1,285245), -- Lesser Healing Potion
(20006,2006,1,1,-1,9169), -- Willow Staff Head
(20006,57,69,94,0,700000), -- Adena
(20006,14,1,1,1,607), -- Bow
(20006,2007,1,1,1,2709), -- Bow Shaft
(20006,1866,1,1,2,16852), -- Suede
(20006,1871,1,1,2,25278), -- Charcoal
(20006,2136,1,1,2,7435), -- Recipe: Cokes
(20007,1122,1,1,-1,49042), -- Cotton Shoes
(20007,1866,1,1,-1,99228), -- Suede
(20007,1875,1,1,-1,9923), -- Stone of Purity
(20007,57,80,108,0,700000), -- Adena
(20007,22,1,1,1,3619), -- Leather Shirt
(20007,29,1,1,1,5786), -- Leather Pants
(20007,1796,1,1,2,36869), -- Recipe: Leather Tunic
(20007,1864,1,1,2,58621), -- Stem
(20007,1869,1,1,2,29311), -- Iron Ore
(20008,1793,1,1,-1,16388), -- Recipe: Sword of Reflection
(20008,1870,1,1,-1,222882), -- Coal
(20008,1871,1,1,-1,222882), -- Charcoal
(20008,57,114,168,0,700000), -- Adena
(20008,255,1,1,1,244), -- Fox Claw Gloves
(20008,2371,1,1,1,517), -- Fist of Butcher
(20008,1792,1,1,2,3228), -- Recipe: Short Spear
(20008,1865,1,1,2,43891), -- Varnish
(20008,1870,1,1,2,43891), -- Coal
(20009,43,1,1,-1,11200), -- Wooden Helmet
(20009,1831,1,1,-1,594351), -- Antidote
(20009,1870,1,1,-1,222882), -- Coal
(20009,57,114,168,0,700000), -- Adena
(20009,255,1,1,1,244), -- Fox Claw Gloves
(20009,2371,1,1,1,517), -- Fist of Butcher
(20009,736,1,1,2,21946), -- Scroll of Escape
(20009,1866,1,1,2,29261), -- Suede
(20009,1871,1,1,2,43891), -- Charcoal
(20010,1792,1,1,-1,17030), -- Recipe: Short Spear
(20010,1833,1,1,-1,617635), -- Bandage
(20010,1896,1,1,-1,98141), -- Necklace of Anguish Chain
(20010,57,116,177,0,700000), -- Adena
(20010,271,1,1,1,506), -- Hunting Bow
(20010,1798,1,1,2,44716), -- Recipe: Leather Helmet
(20010,1866,1,1,2,30407), -- Suede
(20010,1871,1,1,2,45610), -- Charcoal
(20011,1792,1,1,-1,17541), -- Recipe: Short Spear
(20011,1867,1,1,-1,318082), -- Animal Skin
(20011,1921,1,1,-1,153911), -- Leather Shoes Texture
(20011,57,120,182,0,700000), -- Adena
(20011,271,1,1,1,521), -- Hunting Bow
(20011,1799,1,1,2,69598), -- Recipe: Leather Gloves
(20011,1867,1,1,2,62638), -- Animal Skin
(20011,1872,1,1,2,62638), -- Animal Bone
(20012,734,1,1,-1,40386), -- Haste Potion
(20012,1865,1,1,-1,242317), -- Varnish
(20012,1897,1,1,-1,57694), -- Necklace of Wisdom Chain
(20012,57,120,187,0,700000), -- Adena
(20012,1101,1,1,1,706), -- Tunic of Devotion
(20012,1104,1,1,1,1127), -- Stockings of Devotion
(20012,1800,1,1,2,11255), -- Recipe: Piece Bone Breastplate
(20012,1865,1,1,2,35789), -- Varnish
(20012,1870,1,1,2,35789), -- Coal
(20012,6035,1,1,2,2983), -- Magic Haste Potion
(20013,1866,1,1,-1,143423), -- Suede
(20013,1896,1,1,-1,91159), -- Necklace of Anguish Chain
(20013,1922,1,1,-1,54881), -- Leather Tunic Pattern
(20013,57,113,160,0,700000), -- Adena
(20013,9,1,1,1,157), -- Cedar Staff
(20013,154,1,1,1,157), -- Dwarven Mace
(20013,2008,1,1,1,1649), -- Cedar Staff Head
(20013,1792,1,1,2,3115), -- Recipe: Short Spear
(20013,1865,1,1,2,42366), -- Varnish
(20013,1870,1,1,2,42366), -- Coal
(20014,1867,1,1,-1,328104), -- Animal Skin
(20014,2254,1,1,-1,10085), -- Recipe: Composition Bow
(20014,57,120,193,0,700000), -- Adena
(20014,2,1,1,1,54), -- Long Sword
(20014,120,1,1,1,54), -- Sword of Reflection
(20014,121,1,1,1,54), -- Sword of Watershadow
(20014,2012,1,1,1,758), -- Sword of Reflection Blade
(20014,1800,1,1,2,15239), -- Recipe: Piece Bone Breastplate
(20014,1867,1,1,2,64612), -- Animal Skin
(20014,1872,1,1,2,64612), -- Animal Bone
(20015,1798,1,1,-1,237113), -- Recipe: Leather Helmet
(20015,1864,1,1,-1,483710), -- Stem
(20015,1871,1,1,-1,241855), -- Charcoal
(20015,57,127,180,0,700000), -- Adena
(20015,9,1,1,1,177), -- Cedar Staff
(20015,154,1,1,1,177), -- Dwarven Mace
(20015,2008,1,1,1,1853), -- Cedar Staff Head
(20015,1798,1,1,2,46693), -- Recipe: Leather Helmet
(20015,1864,1,1,2,95254), -- Stem
(20015,1869,1,1,2,47627), -- Iron Ore
(20016,37,1,1,-1,18253), -- Leather Shoes
(20016,1833,1,1,-1,644946), -- Bandage
(20016,1865,1,1,-1,241855), -- Varnish
(20016,57,127,180,0,700000), -- Adena
(20016,271,1,1,1,528), -- Hunting Bow
(20016,736,1,1,2,23814), -- Scroll of Escape
(20016,1866,1,1,2,31752), -- Suede
(20016,1871,1,1,2,47627), -- Charcoal
(20017,1870,1,1,-1,251000), -- Coal
(20017,1897,1,1,-1,59762), -- Necklace of Wisdom Chain
(20017,57,122,197,0,700000), -- Adena
(20017,2,1,1,1,55), -- Long Sword
(20017,120,1,1,1,55), -- Sword of Reflection
(20017,121,1,1,1,55), -- Sword of Watershadow
(20017,2012,1,1,1,773), -- Sword of Reflection Blade
(20017,1817,1,1,2,7415), -- Recipe: Cord
(20017,1865,1,1,2,37071), -- Varnish
(20017,1870,1,1,2,37071), -- Coal
(20017,5268,1,1,2,1483), -- Recipe: Greater Soulshot (D) Compressed Package (100%)
(20019,1792,1,1,-1,16388), -- Recipe: Short Spear
(20019,1864,1,1,-1,445764), -- Stem
(20019,1923,1,1,-1,91345), -- Leather Stocking Pattern
(20019,57,114,168,0,700000), -- Adena
(20019,429,1,1,1,828), -- Leather Tunic
(20019,464,1,1,1,1325), -- Leather Stockings
(20019,1922,1,1,1,8398), -- Leather Tunic Pattern
(20019,1923,1,1,1,13491), -- Leather Stocking Pattern
(20019,1793,1,1,2,3228), -- Recipe: Sword of Reflection
(20019,1866,1,1,2,29261), -- Suede
(20019,1871,1,1,2,43891), -- Charcoal
(20020,1799,1,1,-1,371205), -- Recipe: Leather Gloves
(20020,1831,1,1,-1,668170), -- Antidote
(20020,1896,1,1,-1,106171), -- Necklace of Anguish Chain
(20020,57,128,189,0,700000), -- Adena
(20020,37,1,1,1,3724), -- Leather Shoes
(20020,49,1,1,1,3724), -- Gloves
(20020,1921,1,1,1,31834), -- Leather Shoes Texture
(20020,1794,1,1,2,3628), -- Recipe: Forest Bow
(20020,1865,1,1,2,49342), -- Varnish
(20020,1870,1,1,2,49342), -- Coal
(20021,1792,1,1,-1,16388), -- Recipe: Short Spear
(20021,1793,1,1,-1,16388), -- Recipe: Sword of Reflection
(20021,1921,1,1,-1,143795), -- Leather Shoes Texture
(20021,57,114,168,0,700000), -- Adena
(20021,9,1,1,1,163), -- Cedar Staff
(20021,154,1,1,1,163), -- Dwarven Mace
(20021,2008,1,1,1,1708), -- Cedar Staff Head
(20021,1060,1,1,2,73151), -- Lesser Healing Potion
(20021,1798,1,1,2,32273), -- Recipe: Leather Helmet
(20021,1865,1,1,2,32918), -- Varnish
(20021,1870,1,1,2,32918), -- Coal
(20022,1831,1,1,-1,505199), -- Antidote
(20022,1872,1,1,-1,252599), -- Animal Bone
(20022,1921,1,1,-1,122225), -- Leather Shoes Texture
(20022,57,97,143,0,700000), -- Adena
(20022,20,1,1,1,4026), -- Buckler
(20022,43,1,1,1,2813), -- Wooden Helmet
(20022,1799,1,1,2,55270), -- Recipe: Leather Gloves
(20022,1864,1,1,2,74615), -- Stem
(20022,1869,1,1,2,37307), -- Iron Ore
(20023,1831,1,1,-1,617635), -- Antidote
(20023,1868,1,1,-1,463226), -- Thread
(20023,1922,1,1,-1,59085), -- Leather Tunic Pattern
(20023,57,116,177,0,700000), -- Adena
(20023,429,1,1,1,860), -- Leather Tunic
(20023,464,1,1,1,1377), -- Leather Stockings
(20023,1922,1,1,1,8727), -- Leather Tunic Pattern
(20023,1923,1,1,1,14020), -- Leather Stocking Pattern
(20023,735,1,1,2,2851), -- Potion of Alacrity
(20023,1803,1,1,2,28746), -- Recipe: Necklace of Wisdom
(20023,1868,1,1,2,68415), -- Thread
(20023,1873,1,1,2,13683), -- Silver Nugget
(20024,734,1,1,-1,41833), -- Haste Potion
(20024,1864,1,1,-1,501999), -- Stem
(20024,1897,1,1,-1,59762), -- Necklace of Wisdom Chain
(20024,57,122,197,0,700000), -- Adena
(20024,2,1,1,1,55), -- Long Sword
(20024,120,1,1,1,55), -- Sword of Reflection
(20024,121,1,1,1,55), -- Sword of Watershadow
(20024,2012,1,1,1,773), -- Sword of Reflection Blade
(20024,1801,1,1,2,24901), -- Recipe: Piece Bone Gaiters
(20024,1864,1,1,2,98856), -- Stem
(20024,1869,1,1,2,49428), -- Iron Ore
(20025,1799,1,1,-1,349993), -- Recipe: Leather Gloves
(20025,1866,1,1,-1,157497), -- Suede
(20025,1869,1,1,-1,236245), -- Iron Ore
(20025,57,119,180,0,700000), -- Adena
(20025,429,1,1,1,877), -- Leather Tunic
(20025,464,1,1,1,1405), -- Leather Stockings
(20025,1922,1,1,1,8902), -- Leather Tunic Pattern
(20025,1923,1,1,1,14301), -- Leather Stocking Pattern
(20025,736,1,1,2,23262), -- Scroll of Escape
(20025,1866,1,1,2,31015), -- Suede
(20025,1871,1,1,2,46523), -- Charcoal
(20026,1865,1,1,-1,260380), -- Varnish
(20026,1866,1,1,-1,173586), -- Suede
(20026,1923,1,1,-1,106713), -- Leather Stocking Pattern
(20026,57,131,199,0,700000), -- Adena
(20026,37,1,1,1,3870), -- Leather Shoes
(20026,49,1,1,1,3870), -- Gloves
(20026,1921,1,1,1,33081), -- Leather Shoes Texture
(20026,1792,1,1,2,3771), -- Recipe: Short Spear
(20026,1865,1,1,2,51275), -- Varnish
(20026,1870,1,1,2,51275), -- Coal
(20027,1800,1,1,-1,74706), -- Recipe: Piece Bone Breastplate
(20027,1801,1,1,-1,119680), -- Recipe: Piece Bone Gaiters
(20027,1924,1,1,-1,76634), -- Leather Helmet Design
(20027,57,118,183,0,700000), -- Adena
(20027,176,1,1,1,103), -- Journeyman\'s Staff
(20027,2501,1,1,1,103), -- Bone Club
(20027,1800,1,1,2,11034), -- Recipe: Piece Bone Breastplate
(20027,1865,1,1,2,35087), -- Varnish
(20027,1870,1,1,2,35087), -- Coal
(20027,5158,1,1,2,1404), -- Recipe: Spiritshot (D) Compressed Package (100%)
(20028,734,1,1,-1,39594), -- Haste Potion
(20028,1801,1,1,-1,119680), -- Recipe: Piece Bone Gaiters
(20028,1868,1,1,-1,475131), -- Thread
(20028,57,118,183,0,700000), -- Adena
(20028,845,1,1,1,790), -- Cat\'s Eye Earring
(20028,877,1,1,1,1186), -- Ring of Wisdom
(20028,908,1,1,1,590), -- Necklace of Wisdom
(20028,1897,1,1,1,8354), -- Necklace of Wisdom Chain
(20028,1817,1,1,2,9357), -- Recipe: Cord
(20028,1864,1,1,2,93565), -- Stem
(20028,1869,1,1,2,46783), -- Iron Ore
(20029,1864,1,1,-1,534142), -- Stem
(20029,1897,1,1,-1,63588), -- Necklace of Wisdom Chain
(20029,2013,1,1,-1,5764), -- Forest Bow Shaft
(20029,57,132,206,0,700000), -- Adena
(20029,15,1,1,1,117), -- Short Spear
(20029,2011,1,1,1,1800), -- Short Spear Edge
(20029,1865,1,1,2,39445), -- Varnish
(20029,1870,1,1,2,39445), -- Coal
(20029,2139,1,1,2,7889), -- Recipe: Steel Mold
(20029,5268,1,1,2,1578), -- Recipe: Greater Soulshot (D) Compressed Package (100%)
(20030,1794,1,1,-1,17030), -- Recipe: Forest Bow
(20030,1798,1,1,-1,227072), -- Recipe: Leather Helmet
(20030,1831,1,1,-1,617635), -- Antidote
(20030,57,116,177,0,700000), -- Adena
(20030,216,1,1,1,253), -- Dirk
(20030,2009,1,1,1,2427), -- Dirk Blade
(20030,1793,1,1,2,3354), -- Recipe: Sword of Reflection
(20030,1865,1,1,2,45611), -- Varnish
(20030,1870,1,1,2,45611), -- Coal
(20031,24,1,1,-1,2020), -- Bone Breastplate
(20031,1865,1,1,-1,205065), -- Varnish
(20031,1924,1,1,-1,66150), -- Leather Helmet Design
(20031,57,100,161,0,700000), -- Adena
(20031,24,1,1,1,299), -- Bone Breastplate
(20031,31,1,1,1,478), -- Bone Gaiters
(20031,390,1,1,1,299), -- Cotton Shirt
(20031,412,1,1,1,478), -- Cotton Pants
(20031,1865,1,1,2,30287), -- Varnish
(20031,1870,1,1,2,30287), -- Coal
(20031,2140,1,1,2,6058), -- Recipe: High Grade Suede
(20031,5273,1,1,2,1212), -- Recipe: Greater Spiritshot (D) Compressed Package(100%)
(20032,734,1,1,-1,41013), -- Haste Potion
(20032,1800,1,1,-1,77383), -- Recipe: Piece Bone Breastplate
(20032,1868,1,1,-1,492156), -- Thread
(20032,57,120,193,0,700000), -- Adena
(20032,24,1,1,1,359), -- Bone Breastplate
(20032,31,1,1,1,573), -- Bone Gaiters
(20032,390,1,1,1,359), -- Cotton Shirt
(20032,412,1,1,1,573), -- Cotton Pants
(20032,1865,1,1,2,48459), -- Varnish
(20032,1870,1,1,2,48459), -- Coal
(20032,2141,1,1,2,9692), -- Recipe: Silver Mold
(20033,1924,1,1,-1,66150), -- Leather Helmet Design
(20033,1925,1,1,-1,134469), -- Leather Gloves Lining
(20033,2139,1,1,-1,41013), -- Recipe: Steel Mold
(20033,57,100,161,0,700000), -- Adena
(20033,845,1,1,1,682), -- Cat\'s Eye Earring
(20033,877,1,1,1,1024), -- Ring of Wisdom
(20033,908,1,1,1,510), -- Necklace of Wisdom
(20033,1897,1,1,1,7212), -- Necklace of Wisdom Chain
(20033,1865,1,1,2,30287), -- Varnish
(20033,1870,1,1,2,30287), -- Coal
(20033,2142,1,1,2,6058), -- Recipe: Varnish of Purity
(20033,5158,1,1,2,1212), -- Recipe: Spiritshot (D) Compressed Package (100%)
(20034,1868,1,1,-1,501999), -- Thread
(20034,1873,1,1,-1,100400), -- Silver Nugget
(20034,2254,1,1,-1,10287), -- Recipe: Composition Bow
(20034,57,122,197,0,700000), -- Adena
(20034,256,1,1,1,218), -- Cestus
(20034,1868,1,1,2,74142), -- Thread
(20034,1873,1,1,2,14829), -- Silver Nugget
(20034,2143,1,1,2,7415), -- Recipe: Synthetic Cokes
(20034,6035,1,1,2,3090), -- Magic Haste Potion
(20035,1868,1,1,-1,492156), -- Thread
(20035,1925,1,1,-1,161363), -- Leather Gloves Lining
(20035,2140,1,1,-1,49216), -- Recipe: High Grade Suede
(20035,57,120,193,0,700000), -- Adena
(20035,38,1,1,1,1432), -- Low Boots
(20035,50,1,1,1,1432), -- Leather Gloves
(20035,1925,1,1,1,31776), -- Leather Gloves Lining
(20035,1817,1,1,2,7269), -- Recipe: Cord
(20035,1868,1,1,2,72688), -- Thread
(20035,1873,1,1,2,14538), -- Silver Nugget
(20035,5268,1,1,2,1454), -- Recipe: Greater Soulshot (D) Compressed Package (100%)
(20036,735,1,1,-1,21527), -- Potion of Alacrity
(20036,1873,1,1,-1,103328), -- Silver Nugget
(20036,2175,1,1,-1,210017), -- Recipe: Boots
(20036,57,124,204,0,700000), -- Adena
(20036,845,1,1,1,859), -- Cat\'s Eye Earring
(20036,877,1,1,1,1289), -- Ring of Wisdom
(20036,908,1,1,1,642), -- Necklace of Wisdom
(20036,1897,1,1,1,9084), -- Necklace of Wisdom Chain
(20036,1864,1,1,2,76304), -- Stem
(20036,1869,1,1,2,38152), -- Iron Ore
(20036,1878,1,1,2,15261), -- Braided Hemp
(20036,2173,1,1,2,10340), -- Recipe: Hard Leather Shirt
(20038,1868,1,1,-1,557163), -- Thread
(20038,2011,1,1,-1,6355), -- Short Spear Edge
(20038,2174,1,1,-1,121122), -- Recipe: Hard Leather Gaiters
(20038,57,133,220,0,700000), -- Adena
(20038,217,1,1,1,121), -- Shining Knife
(20038,218,1,1,1,121), -- Throwing Knife
(20038,1831,1,1,2,54859), -- Antidote
(20038,1867,1,1,2,27430), -- Animal Skin
(20038,1869,1,1,2,20573), -- Iron Ore
(20038,1870,1,1,2,20573), -- Coal
(20038,1871,1,1,2,20573), -- Charcoal
(20038,1872,1,1,2,27430), -- Animal Bone
(20038,2174,1,1,2,8945), -- Recipe: Hard Leather Gaiters
(20038,5273,1,1,2,823), -- Recipe: Greater Spiritshot (D) Compressed Package(100%)
(20039,1801,1,1,-1,127585), -- Recipe: Piece Bone Gaiters
(20039,1872,1,1,-1,337674), -- Animal Bone
(20039,2011,1,1,-1,5777), -- Short Spear Edge
(20039,57,121,200,0,700000), -- Adena
(20039,44,1,1,1,734), -- Leather Helmet
(20039,102,1,1,1,1053), -- Round Shield
(20039,945,1,1,1,2175), -- Skeleton Buckler
(20039,1924,1,1,1,12066), -- Leather Helmet Design
(20039,735,1,1,2,1782), -- Potion of Alacrity
(20039,1864,1,1,2,42748), -- Stem
(20039,1865,1,1,2,21374), -- Varnish
(20039,1866,1,1,2,14250), -- Suede
(20039,1868,1,1,2,42748), -- Thread
(20039,1873,1,1,2,8550), -- Silver Nugget
(20039,2175,1,1,2,17377), -- Recipe: Boots
(20040,2012,1,1,-1,4397), -- Sword of Reflection Blade
(20040,2140,1,1,-1,42209), -- Recipe: High Grade Suede
(20040,2175,1,1,-1,171583), -- Recipe: Boots
(20040,57,101,167,0,700000), -- Adena
(20040,44,1,1,1,612), -- Leather Helmet
(20040,102,1,1,1,877), -- Round Shield
(20040,945,1,1,1,1813), -- Skeleton Buckler
(20040,1924,1,1,1,10055), -- Leather Helmet Design
(20040,1868,1,1,2,62340), -- Thread
(20040,1873,1,1,2,12468), -- Silver Nugget
(20040,2252,1,1,2,1278), -- Recipe: Iron Hammer
(20040,5158,1,1,2,1247), -- Recipe: Spiritshot (D) Compressed Package (100%)
(20041,1817,1,1,-1,47452), -- Recipe: Cord
(20041,1880,1,1,-1,23726), -- Steel
(20041,2012,1,1,-1,4943), -- Sword of Reflection Blade
(20041,57,114,187,0,700000), -- Adena
(20041,217,1,1,1,103), -- Shining Knife
(20041,218,1,1,1,103), -- Throwing Knife
(20041,1866,1,1,2,31148), -- Suede
(20041,1871,1,1,2,46722), -- Charcoal
(20041,2253,1,1,2,1915), -- Recipe: Sword Breaker
(20042,734,1,1,-1,43053), -- Haste Potion
(20042,2013,1,1,-1,5575), -- Forest Bow Shaft
(20042,57,124,204,0,700000), -- Adena
(20042,309,1,1,1,112), -- Tears of Eva
(20042,310,1,1,1,112), -- Relic of The Saints
(20042,1867,1,1,2,40696), -- Animal Skin
(20042,1872,1,1,2,40696), -- Animal Bone
(20042,1882,1,1,2,6783), -- Leather
(20042,2254,1,1,2,1251), -- Recipe: Composition Bow
(20042,5268,1,1,2,1221), -- Recipe: Greater Soulshot (D) Compressed Package (100%)
(20043,1817,1,1,-1,58608), -- Recipe: Cord
(20043,1864,1,1,-1,586083), -- Stem
(20043,1924,1,1,-1,94529), -- Leather Helmet Design
(20043,57,137,234,0,700000), -- Adena
(20043,2,1,1,1,64), -- Long Sword
(20043,120,1,1,1,64), -- Sword of Reflection
(20043,121,1,1,1,64), -- Sword of Watershadow
(20043,2012,1,1,1,902), -- Sword of Reflection Blade
(20043,1831,1,1,2,57707), -- Antidote
(20043,1864,1,1,2,43280), -- Stem
(20043,1865,1,1,2,21640), -- Varnish
(20043,1866,1,1,2,14427), -- Suede
(20043,1868,1,1,2,43280), -- Thread
(20043,1873,1,1,2,8657), -- Silver Nugget
(20043,2143,1,1,2,4328), -- Recipe: Synthetic Cokes
(20043,5158,1,1,2,866), -- Recipe: Spiritshot (D) Compressed Package (100%)
(20044,1865,1,1,-1,266401), -- Varnish
(20044,1872,1,1,-1,355202), -- Animal Bone
(20044,2142,1,1,-1,53280), -- Recipe: Varnish of Purity
(20044,57,125,213,0,700000), -- Adena
(20044,309,1,1,1,116), -- Tears of Eva
(20044,310,1,1,1,116), -- Relic of The Saints
(20044,1867,1,1,2,52461), -- Animal Skin
(20044,1872,1,1,2,52461), -- Animal Bone
(20044,1881,1,1,2,5246), -- Coarse Bone Powder
(20044,2144,1,1,2,7870), -- Recipe: Compound Braid
(20045,734,1,1,-1,44835), -- Haste Potion
(20045,1925,1,1,-1,176402), -- Leather Gloves Lining
(20045,57,126,215,0,700000), -- Adena
(20045,217,1,1,1,117), -- Shining Knife
(20045,218,1,1,1,117), -- Throwing Knife
(20045,1866,1,1,2,26488), -- Suede
(20045,1871,1,1,2,39732), -- Charcoal
(20045,2150,1,1,2,18654), -- Recipe: Blue Diamond Necklace
(20045,5268,1,1,2,1590), -- Recipe: Greater Soulshot (D) Compressed Package (100%)
(20046,735,1,1,-1,20390), -- Potion of Alacrity
(20046,1897,1,1,-1,58257), -- Necklace of Wisdom Chain
(20046,2139,1,1,-1,48936), -- Recipe: Steel Mold
(20046,57,115,195,0,700000), -- Adena
(20046,845,1,1,1,813), -- Cat\'s Eye Earring
(20046,877,1,1,1,1221), -- Ring of Wisdom
(20046,908,1,1,1,608), -- Necklace of Wisdom
(20046,1897,1,1,1,8604), -- Necklace of Wisdom Chain
(20046,1867,1,1,2,48184), -- Animal Skin
(20046,1872,1,1,2,48184), -- Animal Bone
(20046,1882,1,1,2,8031), -- Leather
(20046,2173,1,1,2,9794), -- Recipe: Hard Leather Shirt
(20047,38,1,1,-1,6558), -- Low Boots
(20047,1869,1,1,-1,222001), -- Iron Ore
(20047,2139,1,1,-1,44400), -- Recipe: Steel Mold
(20047,57,104,177,0,700000), -- Adena
(20047,24,1,1,1,324), -- Bone Breastplate
(20047,31,1,1,1,517), -- Bone Gaiters
(20047,390,1,1,1,324), -- Cotton Shirt
(20047,412,1,1,1,517), -- Cotton Pants
(20047,734,1,1,2,3644), -- Haste Potion
(20047,1864,1,1,2,43717), -- Stem
(20047,1869,1,1,2,21859), -- Iron Ore
(20047,1878,1,1,2,8744), -- Braided Hemp
(20047,2174,1,1,2,9504), -- Recipe: Hard Leather Gaiters
(20047,5273,1,1,2,875), -- Recipe: Greater Spiritshot (D) Compressed Package(100%)
(20048,50,1,1,-1,6785), -- Leather Gloves
(20048,1924,1,1,-1,74091), -- Leather Helmet Design
(20048,2144,1,1,-1,45937), -- Recipe: Compound Braid
(20048,57,106,184,0,700000), -- Adena
(20048,256,1,1,1,200), -- Cestus
(20048,1868,1,1,2,90461), -- Thread
(20048,1873,1,1,2,18092), -- Silver Nugget
(20048,2142,1,1,2,9046), -- Recipe: Varnish of Purity
(20049,1882,1,1,-1,61249), -- Leather
(20049,1924,1,1,-1,88910), -- Leather Helmet Design
(20049,2140,1,1,-1,55124), -- Recipe: High Grade Suede
(20049,57,127,221,0,700000), -- Adena
(20049,256,1,1,1,239), -- Cestus
(20049,1867,1,1,2,43421), -- Animal Skin
(20049,1872,1,1,2,43421), -- Animal Bone
(20049,1881,1,1,2,4343), -- Coarse Bone Powder
(20049,2143,1,1,2,6514), -- Recipe: Synthetic Cokes
(20049,5158,1,1,2,1303), -- Recipe: Spiritshot (D) Compressed Package (100%)
(20050,735,1,1,-1,25265), -- Potion of Alacrity
(20050,1866,1,1,-1,202121), -- Suede
(20050,1925,1,1,-1,198808), -- Leather Gloves Lining
(20050,57,140,243,0,700000), -- Adena
(20050,15,1,1,1,132), -- Short Spear
(20050,2011,1,1,1,2044), -- Short Spear Edge
(20050,1831,1,1,2,119407), -- Antidote
(20050,1866,1,1,2,29852), -- Suede
(20050,1871,1,1,2,44778), -- Charcoal
(20050,2144,1,1,2,8956), -- Recipe: Compound Braid
(20051,1867,1,1,-1,371096), -- Animal Skin
(20051,1925,1,1,-1,182506), -- Leather Gloves Lining
(20051,2254,1,1,-1,11407), -- Recipe: Composition Bow
(20051,57,129,223,0,700000), -- Adena
(20051,272,1,1,1,121), -- Forest Bow
(20051,2013,1,1,1,1775), -- Forest Bow Shaft
(20051,1867,1,1,2,43847), -- Animal Skin
(20051,1872,1,1,2,43847), -- Animal Bone
(20051,1881,1,1,2,4385), -- Coarse Bone Powder
(20051,2150,1,1,2,15439), -- Recipe: Blue Diamond Necklace
(20051,5268,1,1,2,1316), -- Recipe: Greater Soulshot (D) Compressed Package (100%)
(20052,1866,1,1,-1,161368), -- Suede
(20052,1868,1,1,-1,484105), -- Thread
(20052,1869,1,1,-1,242053), -- Iron Ore
(20052,57,110,197,0,700000), -- Adena
(20052,219,1,1,1,59), -- Sword Breaker
(20052,2015,1,1,1,873), -- Sword Breaker Edge
(20052,1804,1,1,2,1145), -- Recipe: Soulshot: D-Grade
(20052,1864,1,1,2,57199), -- Stem
(20052,1869,1,1,2,28600), -- Iron Ore
(20052,1880,1,1,2,2860), -- Steel
(20052,5158,1,1,2,1144), -- Recipe: Spiritshot (D) Compressed Package (100%)
(20053,1898,1,1,-1,30130), -- Blue Diamond Necklace Gem
(20053,1926,1,1,-1,29627), -- Piece Bone Breastplate Fragment
(20053,2015,1,1,-1,3577), -- Sword Breaker Edge
(20053,57,134,238,0,700000), -- Adena
(20053,39,1,1,1,940), -- Boots
(20053,51,1,1,1,940), -- Bracer
(20053,1930,1,1,1,14811), -- Boot Lining
(20053,1864,1,1,2,69312), -- Stem
(20053,1869,1,1,2,34656), -- Iron Ore
(20053,1878,1,1,2,13863), -- Braided Hemp
(20053,2151,1,1,2,9654), -- Recipe: Necklace of Devotion
(20053,5437,1,1,2,848), -- Recipe: Heavy Sword(100%)
(20054,1804,1,1,-1,11391), -- Recipe: Soulshot: D-Grade
(20054,1880,1,1,-1,28477), -- Steel
(20054,3032,1,1,-1,11391), -- Recipe: Spiritshot D
(20054,57,130,231,0,700000), -- Adena
(20054,39,1,1,1,912), -- Boots
(20054,51,1,1,1,912), -- Bracer
(20054,1930,1,1,1,14379), -- Boot Lining
(20054,1867,1,1,2,44862), -- Animal Skin
(20054,1872,1,1,2,44862), -- Animal Bone
(20054,1882,1,1,2,7477), -- Leather
(20054,2176,1,1,2,16099), -- Recipe: Leather Boots
(20054,5268,1,1,2,1346), -- Recipe: Greater Soulshot (D) Compressed Package (100%)
(20055,1926,1,1,-1,28764), -- Piece Bone Breastplate Fragment
(20055,1928,1,1,-1,41481), -- Piece Bone Gaiters Fragment
(20055,2176,1,1,-1,136253), -- Recipe: Leather Boots
(20055,57,130,231,0,700000), -- Adena
(20055,219,1,1,1,69), -- Sword Breaker
(20055,2015,1,1,1,1027), -- Sword Breaker Edge
(20055,735,1,1,2,2804), -- Potion of Alacrity
(20055,1864,1,1,2,67293), -- Stem
(20055,1869,1,1,2,33647), -- Iron Ore
(20055,1880,1,1,2,3365), -- Steel
(20055,2177,1,1,2,10750), -- Recipe: Bone Helmet
(20056,1926,1,1,-1,28501), -- Piece Bone Breastplate Fragment
(20056,2151,1,1,-1,78595), -- Recipe: Necklace of Devotion
(20056,5163,1,1,-1,11286), -- Recipe: Blessed Spiritshot (D) Compressed Package (100%)
(20056,57,128,230,0,700000), -- Adena
(20056,27,1,1,1,226), -- Hard Leather Shirt
(20056,33,1,1,1,363), -- Hard Leather Gaiters
(20056,1927,1,1,1,3325), -- Hard Leather Shirt Pattern
(20056,1929,1,1,1,5378), -- Hard Leather Gaiters Material
(20056,734,1,1,2,6946), -- Haste Potion
(20056,1868,1,1,2,83345), -- Thread
(20056,1873,1,1,2,16669), -- Silver Nugget
(20056,2256,1,1,2,1019), -- Recipe: Assassin Knife
(20057,1927,1,1,-1,20463), -- Hard Leather Shirt Pattern
(20057,2176,1,1,-1,122730), -- Recipe: Leather Boots
(20057,2258,1,1,-1,6272), -- Recipe: Temptation of Abyss
(20057,57,116,209,0,700000), -- Adena
(20057,1102,1,1,1,411), -- Tunic of Magic
(20057,1105,1,1,1,660), -- Stockings of Magic
(20057,1865,1,1,2,37884), -- Varnish
(20057,1870,1,1,2,37884), -- Coal
(20057,2257,1,1,2,927), -- Recipe: Trident
(20057,5273,1,1,2,1516), -- Recipe: Greater Spiritshot (D) Compressed Package(100%)
(20058,1865,1,1,-1,301771), -- Varnish
(20058,1873,1,1,-1,120708), -- Silver Nugget
(20058,1926,1,1,-1,30482), -- Piece Bone Breastplate Fragment
(20058,57,137,246,0,700000), -- Adena
(20058,16,1,1,1,146), -- Long Spear
(20058,1865,1,1,2,44570), -- Varnish
(20058,1870,1,1,2,44570), -- Coal
(20058,1879,1,1,2,7429), -- Cokes
(20058,2258,1,1,2,1090), -- Recipe: Temptation of Abyss
(20059,32,1,1,-1,3033), -- Piece Bone Gaiters
(20059,1879,1,1,-1,50295), -- Cokes
(20059,2177,1,1,-1,96413), -- Recipe: Bone Helmet
(20059,57,137,246,0,700000), -- Adena
(20059,625,1,1,1,1383), -- Bone Shield
(20059,1148,1,1,1,969), -- Hard Leather Helmet
(20059,1865,1,1,2,44570), -- Varnish
(20059,1870,1,1,2,44570), -- Coal
(20059,3032,1,1,2,1783), -- Recipe: Spiritshot D
(20059,5158,1,1,2,1783), -- Recipe: Spiritshot (D) Compressed Package (100%)
(20060,1869,1,1,-1,307807), -- Iron Ore
(20060,1928,1,1,-1,44837), -- Piece Bone Gaiters Fragment
(20060,57,140,251,0,700000), -- Adena
(20060,87,1,1,1,38), -- Iron Hammer
(20060,155,1,1,1,38), -- Buzdygan
(20060,177,1,1,1,38), -- Mage Staff
(20060,2014,1,1,1,523), -- Iron Hammer Head
(20060,735,1,1,2,3031), -- Potion of Alacrity
(20060,1865,1,1,2,36369), -- Varnish
(20060,1870,1,1,2,36369), -- Coal
(20060,3953,1,1,2,1455), -- Recipe: Blessed Spiritshot D
(20060,6666,1,1,2,36369), -- Deluxe Chest Key - Grade 2
(20061,1880,1,1,-1,32142), -- Steel
(20061,1927,1,1,-1,25642), -- Hard Leather Shirt Pattern
(20061,2176,1,1,-1,153791), -- Recipe: Leather Boots
(20061,57,147,260,0,700000), -- Adena
(20061,273,1,1,1,78), -- Composition Bow
(20061,2016,1,1,1,1113), -- Composition Bow Shaft
(20061,1866,1,1,2,25319), -- Suede
(20061,1871,1,1,2,37978), -- Charcoal
(20061,2257,1,1,2,929), -- Recipe: Trident
(20061,5268,1,1,2,1520), -- Recipe: Greater Soulshot (D) Compressed Package (100%)
(20061,6666,1,1,2,37978), -- Deluxe Chest Key - Grade 2
(20062,27,1,1,-1,1708), -- Hard Leather Shirt
(20062,1929,1,1,-1,40661), -- Hard Leather Gaiters Material
(20062,2257,1,1,-1,7705), -- Recipe: Trident
(20062,57,144,255,0,700000), -- Adena
(20062,219,1,1,1,77), -- Sword Breaker
(20062,2015,1,1,1,1135), -- Sword Breaker Edge
(20062,1867,1,1,2,49644), -- Animal Skin
(20062,1872,1,1,2,49644), -- Animal Bone
(20062,1881,1,1,2,4965), -- Coarse Bone Powder
(20062,2258,1,1,2,911), -- Recipe: Temptation of Abyss
(20062,6666,1,1,2,37233), -- Deluxe Chest Key - Grade 2
(20063,34,1,1,-1,2233), -- Bronze Gaiters
(20063,2176,1,1,-1,164023), -- Recipe: Leather Boots
(20063,2177,1,1,-1,109523), -- Recipe: Bone Helmet
(20063,57,152,281,0,700000), -- Adena
(20063,273,1,1,1,84), -- Composition Bow
(20063,2016,1,1,1,1187), -- Composition Bow Shaft
(20063,1804,1,1,2,1621), -- Recipe: Soulshot: D-Grade
(20063,1867,1,1,2,54006), -- Animal Skin
(20063,1872,1,1,2,54006), -- Animal Bone
(20063,1882,1,1,2,9001), -- Leather
(20063,6666,1,1,2,40504), -- Deluxe Chest Key - Grade 2
(20064,1873,1,1,-1,135792), -- Silver Nugget
(20064,1926,1,1,-1,34291), -- Piece Bone Breastplate Fragment
(20064,1930,1,1,-1,87046), -- Boot Lining
(20064,57,151,278,0,700000), -- Adena
(20064,27,1,1,1,272), -- Hard Leather Shirt
(20064,33,1,1,1,436), -- Hard Leather Gaiters
(20064,1927,1,1,1,4000), -- Hard Leather Shirt Pattern
(20064,1929,1,1,1,6470), -- Hard Leather Gaiters Material
(20064,734,1,1,2,6686), -- Haste Potion
(20064,1866,1,1,2,26741), -- Suede
(20064,1871,1,1,2,40111), -- Charcoal
(20064,2179,1,1,2,19192), -- Recipe: Crafted Leather Gloves
(20064,5273,1,1,2,1605), -- Recipe: Greater Spiritshot (D) Compressed Package(100%)
(20066,347,1,1,-1,889), -- Ring Mail Breastplate
(20066,1865,1,1,-1,371004), -- Varnish
(20066,1873,1,1,-1,148401), -- Silver Nugget
(20066,57,163,306,0,700000), -- Adena
(20066,347,1,1,1,250), -- Ring Mail Breastplate
(20066,376,1,1,1,399), -- Iron Plate Gaiters
(20066,1868,1,1,2,104110), -- Thread
(20066,1873,1,1,2,20822), -- Silver Nugget
(20066,2178,1,1,2,8329), -- Recipe: Dark Stockings
(20066,5549,1,1,2,5206), -- Metallic Thread
(20067,1869,1,1,-1,349739), -- Iron Ore
(20067,2020,1,1,-1,6122), -- Temptation of Abyss Piece
(20067,2180,1,1,-1,26296), -- Recipe: Scale Mail
(20067,57,154,288,0,700000), -- Adena
(20067,847,1,1,1,365), -- Red Crescent Earring
(20067,890,1,1,1,546), -- Ring of Devotion
(20067,910,1,1,1,274), -- Necklace of Devotion
(20067,1899,1,1,1,7668), -- Necklace of Devotion Chain
(20067,1864,1,1,2,98143), -- Stem
(20067,1869,1,1,2,49072), -- Iron Ore
(20067,1878,1,1,2,19629), -- Braided Hemp
(20067,2180,1,1,2,3690), -- Recipe: Scale Mail
(20068,391,1,1,-1,1201), -- Puma Skin Shirt
(20068,1899,1,1,-1,58713), -- Necklace of Devotion Chain
(20068,2261,1,1,-1,5835), -- Recipe: Conjuror\'s Staff
(20068,57,163,312,0,700000), -- Adena
(20068,101,1,1,1,21), -- Scroll of Wisdom
(20068,312,1,1,1,21), -- Branch of Life
(20068,313,1,1,1,21), -- Temptation of Abyss
(20068,314,1,1,1,21), -- Proof of Revenge
(20068,2020,1,1,1,739), -- Temptation of Abyss Piece
(20068,1864,1,1,2,105445), -- Stem
(20068,1869,1,1,2,52723), -- Iron Ore
(20068,1878,1,1,2,21089), -- Braided Hemp
(20068,2262,1,1,2,819), -- Recipe: Elven Bow
(20070,1872,1,1,-1,517936), -- Animal Bone
(20070,2152,1,1,-1,68389), -- Recipe: Enchanted Necklace
(20070,2182,1,1,-1,46633), -- Recipe: Scale Gaiters
(20070,57,168,323,0,700000), -- Adena
(20070,40,1,1,1,522), -- Leather Boots
(20070,604,1,1,1,522), -- Crafted Leather Gloves
(20070,1931,1,1,1,7125), -- Leather Boot Lining
(20070,1934,1,1,1,7125), -- Crafted Leather Gloves Lining
(20070,1867,1,1,2,58137), -- Animal Skin
(20070,1872,1,1,2,58137), -- Animal Bone
(20070,1875,1,1,2,2907), -- Stone of Purity
(20070,1881,1,1,2,5814), -- Coarse Bone Powder
(20070,2263,1,1,2,678), -- Recipe: Dwarven Trident
(20072,1931,1,1,-1,53375), -- Leather Boot Lining
(20072,2263,1,1,-1,6340), -- Recipe: Dwarven Trident
(20072,3953,1,1,-1,16333), -- Recipe: Blessed Spiritshot D
(20072,57,175,343,0,700000), -- Adena
(20072,45,1,1,1,489), -- Bone Helmet
(20072,626,1,1,1,698), -- Bronze Shield
(20072,1932,1,1,1,12126), -- Bone Helmet Design
(20072,1866,1,1,2,21825), -- Suede
(20072,1871,1,1,2,32738), -- Charcoal
(20072,1885,1,1,2,2729), -- High Grade Suede
(20072,2262,1,1,2,509), -- Recipe: Elven Bow
(20072,5220,1,1,2,1310), -- Metal Hardener
(20072,6035,1,1,2,2729), -- Magic Haste Potion
(20072,6666,1,1,2,32738), -- Deluxe Chest Key - Grade 2
(20074,1061,1,1,-1,256459), -- Healing Potion
(20074,1869,1,1,-1,423158), -- Iron Ore
(20074,1900,1,1,-1,46297), -- Enchanted Necklace Chain
(20074,57,179,355,0,700000), -- Adena
(20074,605,1,1,1,695), -- Leather Gauntlets
(20074,1123,1,1,1,695), -- Blue Buckskin Boots
(20074,737,1,1,2,3855), -- Scroll of Resurrection
(20074,1864,1,1,2,77080), -- Stem
(20074,1869,1,1,2,38540), -- Iron Ore
(20074,1880,1,1,2,3855), -- Steel
(20074,5550,1,1,2,514), -- Durable Metal Plate
(20074,6387,1,1,2,1542), -- Blessed Scroll of Resurrection for Pets
(20075,348,1,1,-1,583), -- Scale Mail
(20075,1061,1,1,-1,235088), -- Healing Potion
(20075,2153,1,1,-1,60326), -- Recipe: Tiger\'s Eye Earring
(20075,57,164,326,0,700000), -- Adena
(20075,848,1,1,1,249), -- Enchanted Earring
(20075,879,1,1,1,374), -- Enchanted Ring
(20075,911,1,1,1,187), -- Enchanted Necklace
(20075,1900,1,1,1,5798), -- Enchanted Necklace Chain
(20075,955,1,1,2,142), -- Scroll: Enchant Weapon (Grade D)
(20075,1831,1,1,2,94209), -- Antidote
(20075,1866,1,1,2,23553), -- Suede
(20075,1871,1,1,2,35329), -- Charcoal
(20075,1877,1,1,2,1414), -- Adamantite Nugget
(20075,2193,1,1,2,4730), -- Recipe: Boots of Power
(20076,1880,1,1,-1,44889), -- Steel
(20076,1900,1,1,-1,49112), -- Enchanted Necklace Chain
(20076,2250,1,1,-1,112222), -- Recipe: Bone Arrow
(20076,57,190,377,0,700000), -- Adena
(20076,605,1,1,1,737), -- Leather Gauntlets
(20076,1123,1,1,1,737), -- Blue Buckskin Boots
(20076,956,1,1,2,1363), -- Scroll: Enchant Armor (Grade D)
(20076,1864,1,1,2,81767), -- Stem
(20076,1869,1,1,2,40884), -- Iron Ore
(20076,1880,1,1,2,4089), -- Steel
(20076,2274,1,1,2,292), -- Recipe: Skull Breaker
(20076,5550,1,1,2,546), -- Durable Metal Plate
(20077,1933,1,1,-1,52057), -- Dark Stocking Fabric
(20077,2153,1,1,-1,68815), -- Recipe: Tiger\'s Eye Earring
(20077,2183,1,1,-1,29111), -- Recipe: Mithril Banded Mail
(20077,57,187,373,0,700000), -- Adena
(20077,46,1,1,1,484), -- Bronze Helmet
(20077,627,1,1,1,691), -- Aspis
(20077,955,1,1,2,242), -- Scroll: Enchant Weapon (Grade D)
(20077,1865,1,1,2,60450), -- Varnish
(20077,1870,1,1,2,60450), -- Coal
(20077,1874,1,1,2,4031), -- Oriharukon Ore
(20078,1900,1,1,-1,48411), -- Enchanted Necklace Chain
(20078,2023,1,1,-1,5483), -- Conjuror\'s Staff Head
(20078,2024,1,1,-1,6303), -- Elven Bow Shaft
(20078,57,187,373,0,700000), -- Adena
(20078,433,1,1,1,61), -- Elven Tunic
(20078,434,1,1,1,61), -- White Tunic
(20078,435,1,1,1,61), -- Mystic\'s Tunic
(20078,466,1,1,1,97), -- Elven Stockings
(20078,467,1,1,1,97), -- Dark Stockings
(20078,468,1,1,1,97), -- Mystic\'s Stockings
(20078,1933,1,1,1,3556), -- Dark Stocking Fabric
(20078,1936,1,1,1,2474), -- White Tunic Pattern
(20078,736,1,1,2,24180), -- Scroll of Escape
(20078,1868,1,1,2,96720), -- Thread
(20078,1873,1,1,2,19344), -- Silver Nugget
(20078,1889,1,1,2,3224), -- Compound Braid
(20078,5549,1,1,2,4837), -- Metallic Thread
(20079,1866,1,1,-1,294987), -- Suede
(20079,1881,1,1,-1,58997), -- Coarse Bone Powder
(20079,2266,1,1,-1,4576), -- Recipe: Shilen Knife
(20079,57,187,373,0,700000), -- Adena
(20079,848,1,1,1,284), -- Enchanted Earring
(20079,879,1,1,1,426), -- Enchanted Ring
(20079,911,1,1,1,213), -- Enchanted Necklace
(20079,1900,1,1,1,6614), -- Enchanted Necklace Chain
(20079,1061,1,1,2,20935), -- Healing Potion
(20079,1867,1,1,2,46058), -- Animal Skin
(20079,1872,1,1,2,46058), -- Animal Bone
(20079,1875,1,1,2,2303), -- Stone of Purity
(20079,1881,1,1,2,4606), -- Coarse Bone Powder
(20079,2183,1,1,2,2273), -- Recipe: Mithril Banded Mail
(20079,2278,1,1,2,247), -- Recipe: Strengthened Long Bow
(20080,1878,1,1,-1,191782), -- Braided Hemp
(20080,2021,1,1,-1,6054), -- Spinebone Sword Blade
(20080,2268,1,1,-1,4958), -- Recipe: Tome of Blood
(20080,57,203,404,0,700000), -- Adena
(20080,259,1,1,1,81), -- Single-Edged Jamadhr
(20080,737,1,1,2,4367), -- Scroll of Resurrection
(20080,1864,1,1,2,87335), -- Stem
(20080,1869,1,1,2,43668), -- Iron Ore
(20080,1878,1,1,2,17467), -- Braided Hemp
(20080,1884,1,1,2,26873), -- Cord
(20080,6387,1,1,2,1747), -- Blessed Scroll of Resurrection for Pets
(20081,1061,1,1,-1,486166), -- Healing Potion
(20081,1933,1,1,-1,94373), -- Dark Stocking Fabric
(20081,57,338,678,0,700000), -- Adena
(20081,848,1,1,1,515), -- Enchanted Earring
(20081,879,1,1,1,772), -- Enchanted Ring
(20081,911,1,1,1,386), -- Enchanted Necklace
(20081,1900,1,1,1,11990), -- Enchanted Necklace Chain
(20081,1874,1,1,2,4175), -- Oriharukon Ore
(20081,1878,1,1,2,25049), -- Braided Hemp
(20081,1884,1,1,2,38537), -- Cord
(20081,1889,1,1,2,4175), -- Compound Braid
(20081,2267,1,1,2,648), -- Recipe: Gastraphetes
(20081,2274,1,1,2,448), -- Recipe: Skull Breaker
(20081,5220,1,1,2,2505), -- Metal Hardener
(20082,1884,1,1,-1,297748), -- Cord
(20082,1901,1,1,-1,66829), -- Tiger\'s Eye Earring Stone
(20082,2275,1,1,-1,3456), -- Recipe: Heavy Bone Club
(20082,57,204,409,0,700000), -- Adena
(20082,63,1,1,1,145), -- Gauntlets
(20082,553,1,1,1,145), -- Iron Boots
(20082,1940,1,1,1,5485), -- Iron Boots Design
(20082,2422,1,1,1,145), -- Reinforced Leather Boots
(20082,2423,1,1,1,145), -- Boots of Knowledge
(20082,2446,1,1,1,145), -- Reinforced Leather Gloves
(20082,2447,1,1,1,145), -- Gloves of Knowledge
(20082,1832,1,1,2,35730), -- Greater Antidote
(20082,1875,1,1,2,2144), -- Stone of Purity
(20082,1879,1,1,2,5360), -- Cokes
(20082,1885,1,1,2,2680), -- High Grade Suede
(20082,2154,1,1,2,3443), -- Recipe: Elven Earring
(20082,2190,1,1,2,2297), -- Recipe: Mithril Stockings
(20082,5549,1,1,2,3216), -- Metallic Thread
(20082,5550,1,1,2,429), -- Durable Metal Plate
(20083,2154,1,1,-1,63531), -- Recipe: Elven Earring
(20083,2975,1,1,-1,52981), -- Recipe: Brigandine Helmet
(20083,2987,1,1,-1,57610), -- Recipe: Plate Shield
(20083,57,251,501,0,700000), -- Adena
(20083,393,1,1,1,70), -- Mithril Banded Mail
(20083,394,1,1,1,70), -- Reinforced Leather Shirt
(20083,415,1,1,1,111), -- Mithril Banded Gaiters
(20083,416,1,1,1,111), -- Reinforced Leather Gaiters
(20083,1938,1,1,1,3536), -- Mithril Banded Mail Material
(20083,1939,1,1,1,4619), -- Mithril Banded Gaiters Material
(20083,1874,1,1,2,2630), -- Oriharukon Ore
(20083,1878,1,1,2,15775), -- Braided Hemp
(20083,1884,1,1,2,24269), -- Cord
(20083,1889,1,1,2,2630), -- Compound Braid
(20083,2155,1,1,2,6331), -- Recipe: Elven Ring
(20083,2286,1,1,2,220), -- Recipe: Bonebreaker
(20083,2985,1,1,2,4033), -- Recipe: Plate Boots
(20083,5220,1,1,2,1578), -- Metal Hardener
(20084,1885,1,1,-1,46006), -- High Grade Suede
(20084,1938,1,1,-1,37114), -- Mithril Banded Mail Material
(20084,2978,1,1,-1,73905), -- Recipe: Elven Mithril Boots
(20084,57,233,465,0,700000), -- Adena
(20084,47,1,1,1,386), -- Helmet
(20084,628,1,1,1,551), -- Hoplon
(20084,1341,10,30,2,122305), -- Bone Arrow
(20084,1876,1,1,2,7339), -- Mithril Ore
(20084,1877,1,1,2,1468), -- Adamantite Nugget
(20084,1880,1,1,2,3670), -- Steel
(20084,1881,1,1,2,4893), -- Coarse Bone Powder
(20084,1882,1,1,2,8154), -- Leather
(20084,2269,1,1,2,263), -- Recipe: Morning Star
(20084,2971,1,1,2,1963), -- Recipe: Mithril Scale Gaiters
(20085,2155,1,1,-1,102468), -- Recipe: Elven Ring
(20085,2278,1,1,-1,4560), -- Recipe: Strengthened Long Bow
(20085,2422,1,1,-1,2513), -- Reinforced Leather Boots
(20085,57,270,538,0,700000), -- Adena
(20085,63,1,1,1,191), -- Gauntlets
(20085,553,1,1,1,191), -- Iron Boots
(20085,1940,1,1,1,7237), -- Iron Boots Design
(20085,2422,1,1,1,191), -- Reinforced Leather Boots
(20085,2423,1,1,1,191), -- Boots of Knowledge
(20085,2446,1,1,1,191), -- Reinforced Leather Gloves
(20085,2447,1,1,1,191), -- Gloves of Knowledge
(20085,1865,1,1,2,56570), -- Varnish
(20085,1870,1,1,2,56570), -- Coal
(20085,1874,1,1,2,3772), -- Oriharukon Ore
(20085,2270,1,1,2,405), -- Recipe: Goat Head Staff
(20085,2293,1,1,2,315), -- Recipe: Glaive
(20085,2986,1,1,2,5785), -- Recipe: Sage\'s Worn Gloves
(20086,469,1,1,-1,1030), -- Stockings of Knowledge
(20086,1868,1,3,-1,490187), -- Thread
(20086,1939,1,1,-1,43055), -- Mithril Banded Gaiters Material
(20086,57,207,413,0,700000), -- Adena
(20086,436,1,1,1,172), -- Tunic of Knowledge
(20086,469,1,1,1,274), -- Stockings of Knowledge
(20086,1874,1,1,2,2896), -- Oriharukon Ore
(20086,1878,1,1,2,17376), -- Braided Hemp
(20086,1884,1,1,2,26732), -- Cord
(20086,1889,1,1,2,2896), -- Compound Braid
(20086,2972,1,1,2,2323), -- Recipe: Brigandine Gaiters
(20086,5220,1,1,2,1738), -- Metal Hardener
(20087,1866,1,1,-1,783985), -- Suede
(20087,1940,1,1,-1,175519), -- Iron Boots Design
(20087,2191,1,1,-1,157427), -- Recipe: RIP Gauntlets
(20087,57,497,991,0,700000), -- Adena
(20087,393,1,1,1,138), -- Mithril Banded Mail
(20087,394,1,1,1,138), -- Reinforced Leather Shirt
(20087,415,1,1,1,219), -- Mithril Banded Gaiters
(20087,416,1,1,1,219), -- Reinforced Leather Gaiters
(20087,1938,1,1,1,7007), -- Mithril Banded Mail Material
(20087,1939,1,1,1,9154), -- Mithril Banded Gaiters Material
(20087,1832,1,1,2,86842), -- Greater Antidote
(20087,1866,1,1,2,52105), -- Suede
(20087,1871,1,1,2,78158), -- Charcoal
(20087,1877,1,1,2,3127), -- Adamantite Nugget
(20087,2975,1,1,2,6979), -- Recipe: Brigandine Helmet
(20087,2980,1,1,2,10463), -- Recipe: Brigandine Gauntlets
(20087,2984,1,1,2,7992), -- Recipe: Salamander Skin Boots
(20087,3020,1,1,2,435), -- Recipe: Elven Long Sword
(20088,1875,1,1,-1,87191), -- Stone of Purity
(20088,1895,1,1,-1,373675), -- Metallic Fiber
(20088,2149,1,1,-1,93419), -- Recipe: Metallic Fiber
(20088,57,551,1105,0,700000), -- Adena
(20088,293,1,1,1,72), -- War Hammer
(20088,296,1,1,1,72), -- Dwarven Pike
(20088,1867,1,1,2,154529), -- Animal Skin
(20088,1872,1,1,2,154529), -- Animal Bone
(20088,1875,1,1,2,7727), -- Stone of Purity
(20088,1881,1,1,2,15454), -- Coarse Bone Powder
(20088,2270,1,1,2,828), -- Recipe: Goat Head Staff
(20088,2288,1,1,2,644), -- Recipe: Ghost Staff
(20089,1884,1,1,-1,335320), -- Cord
(20089,1902,1,1,-1,55207), -- Elven Earring Beads
(20089,2159,1,1,-1,33635), -- Recipe: Necklace of Darkness
(20089,57,230,460,0,700000), -- Adena
(20089,395,1,1,1,63), -- Manticore Skin Shirt
(20089,417,1,1,1,101), -- Manticore Skin Gaiters
(20089,1942,1,1,1,3592), -- Manticore Skin Shirt Texture
(20089,1943,1,1,1,5593), -- Manticore Skin Gaiters Pattern
(20089,1825,1,1,2,2515), -- Recipe: Oriharukon
(20089,1875,1,1,2,2348), -- Stone of Purity
(20089,1879,1,1,2,5869), -- Cokes
(20089,1885,1,1,2,2935), -- High Grade Suede
(20089,2205,1,1,2,1115), -- Recipe: Chain Gaiters
(20089,2989,1,1,2,1863), -- Recipe: Chain Hood
(20089,5549,1,1,2,3521), -- Metallic Thread
(20089,5550,1,1,2,470), -- Durable Metal Plate
(20090,1825,1,1,-1,85633), -- Recipe: Oriharukon
(20090,1868,1,5,-1,799241), -- Thread
(20090,2197,1,1,-1,25133), -- Recipe: Salamander Skin Mail
(20090,57,507,1012,0,700000), -- Adena
(20090,352,1,1,1,70), -- Brigandine Tunic
(20090,1941,1,1,1,4108), -- Brigandine Temper
(20090,2377,1,1,1,111), -- Mithril Scale Gaiters
(20090,2378,1,1,1,111), -- Brigandine Gaiters
(20090,2918,1,1,1,6128), -- Mithril Scale Gaiters Material
(20090,2919,1,1,1,6128), -- Brigandine Gaiters Material
(20090,1341,10,30,2,258214), -- Bone Arrow
(20090,1876,1,1,2,15493), -- Mithril Ore
(20090,1877,1,1,2,3099), -- Adamantite Nugget
(20090,1880,1,1,2,7747), -- Steel
(20090,1881,1,1,2,10329), -- Coarse Bone Powder
(20090,1882,1,1,2,17215), -- Leather
(20090,2158,1,1,2,9588), -- Recipe: Mithril Ring
(20090,5472,1,1,2,5534), -- Recipe: Metallic Thread(100%)
(20092,1666,1,1,-1,49062), -- Recipe: Wooden Arrow
(20092,1866,1,1,-1,98124), -- Suede
(20092,2005,1,1,-1,10513), -- Broadsword Blade
(20092,57,79,107,0,700000), -- Adena
(20092,113,1,1,1,7148), -- Mystic\'s Earring
(20092,875,1,1,1,10735), -- Ring of Knowledge
(20092,906,1,1,1,5368), -- Necklace of Knowledge
(20092,1867,1,1,2,19323), -- Animal Skin
(20092,1869,1,1,2,14493), -- Iron Ore
(20092,1870,1,1,2,14493), -- Coal
(20092,1871,1,1,2,14493), -- Charcoal
(20092,1872,1,1,2,19323), -- Animal Bone
(20092,2137,1,1,2,4263), -- Recipe: Steel
(20093,1666,1,1,-1,60652), -- Recipe: Wooden Arrow
(20093,1867,1,1,-1,242609), -- Animal Skin
(20093,2007,1,1,-1,12997), -- Bow Shaft
(20093,57,98,132,0,700000), -- Adena
(20093,3,1,1,1,860), -- Broadsword
(20093,2005,1,1,1,3840), -- Broadsword Blade
(20093,1060,1,1,2,59720), -- Lesser Healing Potion
(20093,1867,1,1,2,35832), -- Animal Skin
(20093,1872,1,1,2,35832), -- Animal Bone
(20093,2138,1,1,2,7905), -- Recipe: Coarse Bone Powder (100%)
(20095,1864,1,1,-1,297315), -- Stem
(20095,2006,1,1,-1,10618), -- Willow Staff Head
(20095,57,80,108,0,700000), -- Adena
(20095,428,1,1,1,1808), -- Feriotic Tunic
(20095,463,1,1,1,2889), -- Feriotic Stockings
(20095,1100,1,1,1,1808), -- Cotton Tunic
(20095,1103,1,1,1,2889), -- Cotton Stockings
(20095,1789,1,1,2,5412), -- Recipe: Cedar Staff
(20095,1864,1,1,2,58548), -- Stem
(20095,1869,1,1,2,29274), -- Iron Ore
(20096,1792,1,1,-1,14822), -- Recipe: Short Spear
(20096,1799,1,1,-1,298635), -- Recipe: Leather Gloves
(20096,1921,1,1,-1,130051), -- Leather Shoes Texture
(20096,57,109,147,0,700000), -- Adena
(20096,37,1,1,1,2996), -- Leather Shoes
(20096,49,1,1,1,2996), -- Gloves
(20096,1921,1,1,1,25611), -- Leather Shoes Texture
(20096,736,1,1,2,9924), -- Scroll of Escape
(20096,1867,1,1,2,26464), -- Animal Skin
(20096,1869,1,1,2,19848), -- Iron Ore
(20096,1870,1,1,2,19848), -- Coal
(20096,1871,1,1,2,19848), -- Charcoal
(20096,1872,1,1,2,26464), -- Animal Bone
(20097,1793,1,1,-1,12352), -- Recipe: Sword of Reflection
(20097,1864,1,1,-1,335964), -- Stem
(20097,1872,1,1,-1,223976), -- Animal Bone
(20097,57,91,122,0,700000), -- Adena
(20097,23,1,1,1,832), -- Wooden Breastplate
(20097,30,1,1,1,1331), -- Hard Leather Pants
(20097,2386,1,1,1,1331), -- Wooden Gaiters
(20097,1792,1,1,2,2433), -- Recipe: Short Spear
(20097,1867,1,1,2,44106), -- Animal Skin
(20097,1872,1,1,2,44106), -- Animal Bone
(20098,1867,1,1,-1,292048), -- Animal Skin
(20098,1870,1,1,-1,219036), -- Coal
(20098,1896,1,1,-1,92812), -- Necklace of Anguish Chain
(20098,57,117,161,0,700000), -- Adena
(20098,66,1,1,1,160), -- Gladius
(20098,1333,1,1,1,160), -- Brandish
(20098,2010,1,1,1,1679), -- Brandish Blade
(20098,1793,1,1,2,3172), -- Recipe: Sword of Reflection
(20098,1865,1,1,2,43134), -- Varnish
(20098,1870,1,1,2,43134), -- Coal
(20099,1831,1,1,-1,473949), -- Antidote
(20099,1896,1,1,-1,75310), -- Necklace of Anguish Chain
(20099,2009,1,1,-1,6303), -- Dirk Blade
(20099,57,95,131,0,700000), -- Adena
(20099,66,1,1,1,130), -- Gladius
(20099,1333,1,1,1,130), -- Brandish
(20099,2010,1,1,1,1363), -- Brandish Blade
(20099,1794,1,1,2,1287), -- Recipe: Forest Bow
(20099,1864,1,1,2,35000), -- Stem
(20099,1865,1,1,2,17500), -- Varnish
(20099,1866,1,1,2,11667), -- Suede
(20099,1868,1,1,2,35000), -- Thread
(20099,1873,1,1,2,7000), -- Silver Nugget
(20100,1792,1,1,-1,13849), -- Recipe: Short Spear
(20100,1833,1,1,-1,502269), -- Bandage
(20100,1866,1,1,-1,125567), -- Suede
(20100,57,99,140,0,700000), -- Adena
(20100,271,1,1,1,411), -- Hunting Bow
(20100,1799,1,1,2,54950), -- Recipe: Leather Gloves
(20100,1866,1,1,2,24728), -- Suede
(20100,1871,1,1,2,37091), -- Charcoal
(20101,20,1,1,-1,18026), -- Buckler
(20101,1793,1,1,-1,18424), -- Recipe: Sword of Reflection
(20101,1921,1,1,-1,161654), -- Leather Shoes Texture
(20101,57,128,189,0,700000), -- Adena
(20101,114,1,1,1,1687), -- Earring of Strength
(20101,115,1,1,1,1687), -- Earring of Wisdom
(20101,876,1,1,1,2531), -- Ring of Anguish
(20101,907,1,1,1,1266), -- Necklace of Anguish
(20101,1896,1,1,1,12545), -- Necklace of Anguish Chain
(20101,1803,1,1,2,20732), -- Recipe: Necklace of Wisdom
(20101,1864,1,1,2,49342), -- Stem
(20101,1865,1,1,2,24671), -- Varnish
(20101,1866,1,1,2,16448), -- Suede
(20101,1868,1,1,2,49342), -- Thread
(20101,1873,1,1,2,9869), -- Silver Nugget
(20102,1793,1,1,-1,14067), -- Recipe: Sword of Reflection
(20102,1866,1,1,-1,127538), -- Suede
(20102,1922,1,1,-1,48803), -- Leather Tunic Pattern
(20102,57,98,145,0,700000), -- Adena
(20102,271,1,1,1,418), -- Hunting Bow
(20102,736,1,1,2,18837), -- Scroll of Escape
(20102,1864,1,1,2,75346), -- Stem
(20102,1869,1,1,2,37673), -- Iron Ore
(20103,1803,1,1,-1,198526), -- Recipe: Necklace of Wisdom
(20103,1871,1,1,-1,236245), -- Charcoal
(20103,1921,1,1,-1,152416), -- Leather Shoes Texture
(20103,57,119,180,0,700000), -- Adena
(20103,37,1,1,1,3512), -- Leather Shoes
(20103,49,1,1,1,3512), -- Gloves
(20103,1921,1,1,1,30015), -- Leather Shoes Texture
(20103,17,10,30,2,174458), -- Wooden Arrow
(20103,1794,1,1,2,2566), -- Recipe: Forest Bow
(20103,1867,1,1,2,46523), -- Animal Skin
(20103,1872,1,1,2,46523), -- Animal Bone
(20104,1868,1,1,-1,386022), -- Thread
(20104,1869,1,1,-1,193011), -- Iron Ore
(20104,57,97,147,0,700000), -- Adena
(20104,271,1,1,1,422), -- Hunting Bow
(20104,17,10,30,2,142531), -- Wooden Arrow
(20104,736,1,1,2,14254), -- Scroll of Escape
(20104,1868,1,1,2,57013), -- Thread
(20104,1873,1,1,2,11403), -- Silver Nugget
(20105,734,1,1,-1,39986), -- Haste Potion
(20105,1801,1,1,-1,120865), -- Recipe: Piece Bone Gaiters
(20105,1872,1,1,-1,319890), -- Animal Bone
(20105,57,119,185,0,700000), -- Adena
(20105,15,1,1,1,105), -- Short Spear
(20105,2011,1,1,1,1617), -- Short Spear Edge
(20105,735,1,1,2,2953), -- Potion of Alacrity
(20105,1867,1,1,2,47246), -- Animal Skin
(20105,1872,1,1,2,47246), -- Animal Bone
(20105,2140,1,1,2,7087), -- Recipe: High Grade Suede
(20106,734,1,1,-1,39594), -- Haste Potion
(20106,1897,1,1,-1,56563), -- Necklace of Wisdom Chain
(20106,2150,1,1,-1,111533), -- Recipe: Blue Diamond Necklace
(20106,57,118,183,0,700000), -- Adena
(20106,38,1,1,1,1383), -- Low Boots
(20106,50,1,1,1,1383), -- Leather Gloves
(20106,1925,1,1,1,30677), -- Leather Gloves Lining
(20106,1867,1,1,2,46783), -- Animal Skin
(20106,1872,1,1,2,46783), -- Animal Bone
(20106,2141,1,1,2,7018), -- Recipe: Silver Mold
(20106,5273,1,1,2,1404), -- Recipe: Greater Spiritshot (D) Compressed Package(100%)
(20107,734,1,1,-1,32995), -- Haste Potion
(20107,1869,1,1,-1,197971), -- Iron Ore
(20107,1897,1,1,-1,47136), -- Necklace of Wisdom Chain
(20107,57,98,153,0,700000), -- Adena
(20107,217,1,1,1,86), -- Shining Knife
(20107,218,1,1,1,86), -- Throwing Knife
(20107,1865,1,1,2,29239), -- Varnish
(20107,1870,1,1,2,29239), -- Coal
(20107,2142,1,1,2,5848), -- Recipe: Varnish of Purity
(20107,6035,1,1,2,2437), -- Magic Haste Potion
(20108,734,1,1,-1,41833), -- Haste Potion
(20108,1800,1,1,-1,78931), -- Recipe: Piece Bone Breastplate
(20108,1866,1,1,-1,167333), -- Suede
(20108,57,122,197,0,700000), -- Adena
(20108,38,1,1,1,1461), -- Low Boots
(20108,50,1,1,1,1461), -- Leather Gloves
(20108,1925,1,1,1,32412), -- Leather Gloves Lining
(20108,735,1,1,2,3090), -- Potion of Alacrity
(20108,1867,1,1,2,49428), -- Animal Skin
(20108,1872,1,1,2,49428), -- Animal Bone
(20108,2144,1,1,2,7415), -- Recipe: Compound Braid
(20109,845,1,1,-1,9042), -- Cat\'s Eye Earring
(20109,1865,1,1,-1,401928), -- Varnish
(20109,1924,1,1,-1,129654), -- Leather Helmet Design
(20109,57,196,315,0,700000), -- Adena
(20109,24,1,1,1,585), -- Bone Breastplate
(20109,31,1,1,1,935), -- Bone Gaiters
(20109,390,1,1,1,585), -- Cotton Shirt
(20109,412,1,1,1,935), -- Cotton Pants
(20109,1864,1,1,2,67842), -- Stem
(20109,1865,1,1,2,33921), -- Varnish
(20109,1866,1,1,2,22614), -- Suede
(20109,1868,1,1,2,67842), -- Thread
(20109,1873,1,1,2,13569), -- Silver Nugget
(20109,2150,1,1,2,15926), -- Recipe: Blue Diamond Necklace
(20109,5273,1,1,2,1357), -- Recipe: Greater Spiritshot (D) Compressed Package(100%)
(20110,734,1,1,-1,64842), -- Haste Potion
(20110,1801,1,1,-1,195995), -- Recipe: Piece Bone Gaiters
(20110,1897,1,1,-1,92631), -- Necklace of Wisdom Chain
(20110,57,190,305,0,700000), -- Adena
(20110,24,1,1,1,567), -- Bone Breastplate
(20110,31,1,1,1,905), -- Bone Gaiters
(20110,390,1,1,1,567), -- Cotton Shirt
(20110,412,1,1,1,905), -- Cotton Pants
(20110,1866,1,1,2,51076), -- Suede
(20110,1871,1,1,2,76613), -- Charcoal
(20110,2173,1,1,2,20763), -- Recipe: Hard Leather Shirt
(20112,1800,1,1,-1,123442), -- Recipe: Piece Bone Breastplate
(20112,1801,1,1,-1,197756), -- Recipe: Piece Bone Gaiters
(20112,1924,1,1,-1,126628), -- Leather Helmet Design
(20112,57,188,310,0,700000), -- Adena
(20112,1101,1,1,1,1143), -- Tunic of Devotion
(20112,1104,1,1,1,1826), -- Stockings of Devotion
(20112,734,1,1,2,7730), -- Haste Potion
(20112,1800,1,1,2,14586), -- Recipe: Piece Bone Breastplate
(20112,1864,1,1,2,92762), -- Stem
(20112,1869,1,1,2,46381), -- Iron Ore
(20112,1878,1,1,2,18553), -- Braided Hemp
(20113,1870,1,1,-1,400397), -- Coal
(20113,1879,1,1,-1,66733), -- Cokes
(20113,1925,1,1,-1,262556), -- Leather Gloves Lining
(20113,57,192,316,0,700000), -- Adena
(20113,24,1,1,1,583), -- Bone Breastplate
(20113,31,1,1,1,932), -- Bone Gaiters
(20113,390,1,1,1,583), -- Cotton Shirt
(20113,412,1,1,1,932), -- Cotton Pants
(20113,1801,1,1,2,23834), -- Recipe: Piece Bone Gaiters
(20113,1865,1,1,2,47309), -- Varnish
(20113,1870,1,1,2,47309), -- Coal
(20113,1879,1,1,2,7885), -- Cokes
(20113,5273,1,1,2,1893), -- Recipe: Greater Spiritshot (D) Compressed Package(100%)
(20114,735,1,1,-1,33735), -- Potion of Alacrity
(20114,1817,1,1,-1,80965), -- Recipe: Cord
(20114,2011,1,1,-1,9235), -- Short Spear Edge
(20114,57,190,323,0,700000), -- Adena
(20114,845,1,1,1,1346), -- Cat\'s Eye Earring
(20114,877,1,1,1,2020), -- Ring of Wisdom
(20114,908,1,1,1,1005), -- Necklace of Wisdom
(20114,1897,1,1,1,14236), -- Necklace of Wisdom Chain
(20114,1817,1,1,2,11958), -- Recipe: Cord
(20114,1866,1,1,2,39860), -- Suede
(20114,1871,1,1,2,59790), -- Charcoal
(20114,6035,1,1,2,4983), -- Magic Haste Potion
(20115,2012,1,1,-1,8603), -- Sword of Reflection Blade
(20115,2013,1,1,-1,8912), -- Forest Bow Shaft
(20115,2139,1,1,-1,82584), -- Recipe: Steel Mold
(20115,57,194,330,0,700000), -- Adena
(20115,38,1,1,1,2403), -- Low Boots
(20115,50,1,1,1,2403), -- Leather Gloves
(20115,1925,1,1,1,53321), -- Leather Gloves Lining
(20115,1867,1,1,2,46466), -- Animal Skin
(20115,1869,1,1,2,34849), -- Iron Ore
(20115,1870,1,1,2,34849), -- Coal
(20115,1871,1,1,2,34849), -- Charcoal
(20115,1872,1,1,2,46466), -- Animal Bone
(20115,2139,1,1,2,6970), -- Recipe: Steel Mold
(20115,5158,1,1,2,1394), -- Recipe: Spiritshot (D) Compressed Package (100%)
(20117,734,1,1,-1,42109), -- Haste Potion
(20117,1868,1,1,-1,505303), -- Thread
(20117,1925,1,1,-1,165673), -- Leather Gloves Lining
(20117,57,117,203,0,700000), -- Adena
(20117,176,1,1,1,110), -- Journeyman\'s Staff
(20117,2501,1,1,1,110), -- Bone Club
(20117,735,1,1,2,2488), -- Potion of Alacrity
(20117,1867,1,1,2,39803), -- Animal Skin
(20117,1872,1,1,2,39803), -- Animal Bone
(20117,1882,1,1,2,6634), -- Leather
(20117,2173,1,1,2,8090), -- Recipe: Hard Leather Shirt
(20118,846,1,1,-1,3026), -- Coral Earring
(20118,1866,1,1,-1,161368), -- Suede
(20118,5549,1,1,-1,24205), -- Metallic Thread
(20118,57,110,197,0,700000), -- Adena
(20118,87,1,1,1,30), -- Iron Hammer
(20118,155,1,1,1,30), -- Buzdygan
(20118,177,1,1,1,30), -- Mage Staff
(20118,2014,1,1,1,412), -- Iron Hammer Head
(20118,1868,1,1,2,71499), -- Thread
(20118,1873,1,1,2,14300), -- Silver Nugget
(20118,2179,1,1,2,17105), -- Recipe: Crafted Leather Gloves
(20118,5273,1,1,2,1430), -- Recipe: Greater Spiritshot (D) Compressed Package(100%)
(20120,1787,1,1,-1,30885), -- Recipe: Willow Staff
(20120,1864,1,1,-1,77212), -- Stem
(20120,1874,1,1,-1,2574), -- Oriharukon Ore
(20120,57,19,29,0,700000), -- Adena
(20120,13,1,1,1,10394), -- Short Bow
(20120,1060,1,1,2,22174), -- Lesser Healing Potion
(20120,1786,1,1,2,7983), -- Recipe: Broad Sword
(20120,1865,1,1,2,9979), -- Varnish
(20120,1870,1,1,2,9979), -- Coal
(20121,1786,1,1,-1,45293), -- Recipe: Broad Sword
(20121,1788,1,1,-1,45293), -- Recipe: Bow 
(20121,1864,1,1,-1,113233), -- Stem
(20121,57,30,42,0,700000), -- Adena
(20121,4,1,1,1,7622), -- Club
(20121,7,1,1,1,7622), -- Apprentice\'s Rod
(20121,17,10,30,2,73166), -- Wooden Arrow
(20121,1786,1,1,2,11707), -- Recipe: Broad Sword
(20121,1866,1,1,2,9756), -- Suede
(20121,1871,1,1,2,14634), -- Charcoal
(20130,1060,1,1,-1,172757), -- Lesser Healing Potion
(20130,1666,1,1,-1,25914), -- Recipe: Wooden Arrow
(20130,2005,1,1,-1,5553), -- Broadsword Blade
(20130,57,41,58,0,700000), -- Adena
(20130,1119,1,1,1,5045), -- Short Leather Gloves
(20130,1122,1,1,1,5044), -- Cotton Shoes
(20130,1129,1,1,1,5044), -- Crude Leather Shoes
(20130,1666,1,1,2,5103), -- Recipe: Wooden Arrow
(20130,1864,1,1,2,30618), -- Stem
(20130,1869,1,1,2,15309), -- Iron Ore
(20131,1666,1,1,-1,32439), -- Recipe: Wooden Arrow
(20131,1789,1,1,-1,17988), -- Recipe: Cedar Staff
(20131,2006,1,1,-1,6951), -- Willow Staff Head
(20131,57,51,72,0,700000), -- Adena
(20131,19,1,1,1,9012), -- Small Shield
(20131,42,1,1,1,6311), -- Leather Cap
(20131,1797,1,1,2,38715), -- Recipe: Leather Stockings
(20131,1865,1,1,2,19164), -- Varnish
(20131,1870,1,1,2,19164), -- Coal
(20132,1060,1,1,-1,330759), -- Lesser Healing Potion
(20132,2006,1,1,-1,10632), -- Willow Staff Head
(20132,57,80,108,0,700000), -- Adena
(20132,254,1,1,1,1407), -- Iron Gloves
(20132,734,1,1,2,3664), -- Haste Potion
(20132,1797,1,1,2,44410), -- Recipe: Leather Stockings
(20132,1867,1,1,2,29311), -- Animal Skin
(20132,1872,1,1,2,29311), -- Animal Bone
(20134,356,1,1,-1,163), -- Full Plate Armor
(20134,947,1,1,-1,679), -- Scroll: Enchant Weapon (Grade B)
(20134,1871,1,3,-1,849303), -- Charcoal
(20134,57,684,1394,0,700000), -- Adena
(20134,357,1,1,1,7), -- Zubei\'s Breastplate
(20134,383,1,1,1,10), -- Zubei\'s Gaiters
(20134,2376,1,1,1,7), -- Avadon Breastplate
(20134,2379,1,1,1,10), -- Avadon Gaiters
(20134,4056,1,1,1,1136), -- Zubei\'s Breastplate Part
(20134,4057,1,1,1,1755), -- Zubei\'s Gaiter Material
(20134,4064,1,1,1,1136), -- Avadon Breastplate Part
(20134,4065,1,1,1,1755), -- Avadon Gaiters Material
(20134,947,1,1,2,26), -- Scroll: Enchant Weapon (Grade B)
(20134,1866,1,1,2,41812), -- Suede
(20134,1871,1,1,2,62718), -- Charcoal
(20134,1885,1,1,2,5227), -- High Grade Suede
(20134,4041,1,1,2,546), -- Mold Hardener
(20134,4192,1,1,2,48), -- Recipe: Sword of Damascus
(20134,4993,1,1,2,781), -- Recipe: Doom Gloves (60%)
(20134,5220,1,1,2,2509), -- Metal Hardener
(20135,1882,1,1,-1,172318), -- Leather
(20135,2038,1,1,-1,8193), -- Maingauche Edge
(20135,5231,1,1,-1,55388), -- Recipe: Metal Hardener (100%)
(20135,57,325,649,0,700000), -- Adena
(20135,261,1,1,1,29), -- Bich\'Hwa
(20135,2039,1,1,1,2029), -- Bich\'Hwa Edge
(20135,1867,1,1,2,76351), -- Animal Skin
(20135,1872,1,1,2,76351), -- Animal Bone
(20135,1882,1,1,2,12726), -- Leather
(20135,1894,1,1,2,2010), -- Crafted Leather
(20135,2286,1,1,2,319), -- Recipe: Bonebreaker
(20135,2296,1,1,2,319), -- Recipe: Atuba Mace
(20135,2985,1,1,2,5856), -- Recipe: Plate Boots
(20136,1539,1,1,-1,589837), -- Greater Healing Potion
(20136,1914,1,1,-1,149116), -- Earring of Binding Gemstone
(20136,4601,1,1,-1,5898), -- Greater Dye of Strength <Str+3 Con-3>
(20136,57,1071,2177,0,700000), -- Adena
(20136,75,1,1,1,5), -- Caliburs
(20136,76,1,1,1,5), -- Sword of Delusion
(20136,77,1,1,1,5), -- Tsurugi
(20136,84,1,1,1,5), -- Homunkulus\'s Sword
(20136,134,1,1,1,5), -- Sword of Nightmare
(20136,145,1,1,1,5), -- Sword of Whispering Death
(20136,2089,1,1,1,499), -- Caliburs Edge
(20136,2090,1,1,1,499), -- Delusional Blade
(20136,2091,1,1,1,499), -- Tsurugi Blade
(20136,2092,1,1,1,499), -- Homunkulus\'s Sword Blade
(20136,2095,1,1,1,499), -- Sword of Nightmare Blade
(20136,2096,1,1,1,499), -- Sword of Whispering Death Blade
(20136,1864,1,1,2,313612), -- Stem
(20136,1869,1,1,2,156806), -- Iron Ore
(20136,1880,1,1,2,15681), -- Steel
(20136,2169,1,1,2,2776), -- Recipe: Necklace of Binding
(20136,2232,1,1,2,902), -- Recipe: Drake Leather Armor
(20136,4043,1,1,2,5227), -- Asofe
(20136,5550,1,1,2,2091), -- Durable Metal Plate
(20137,1877,1,1,-1,63802), -- Adamantite Nugget
(20137,2961,1,1,-1,86853), -- Full Plate Boots Part
(20137,4049,1,1,-1,83664), -- Adamantite Earring Gemstone
(20137,57,642,1310,0,700000), -- Adena
(20137,78,1,1,1,2), -- Great Sword
(20137,142,1,1,1,2), -- Keshanberk
(20137,148,1,1,1,2), -- Sword of Valhalla
(20137,4104,1,1,1,450), -- Great Sword Blade
(20137,4107,1,1,1,443), -- Keshanberk Blade
(20137,4108,1,1,1,443), -- Sword of Valhalla Blade
(20137,1864,1,1,2,104702), -- Stem
(20137,1869,1,1,2,52351), -- Iron Ore
(20137,1880,1,1,2,5236), -- Steel
(20137,4043,1,1,2,1746), -- Asofe
(20137,4163,1,1,2,347), -- Recipe: Blue Wolf Stockings
(20137,4952,1,1,2,673), -- Recipe: Avadon Circlet (60%)
(20137,4999,1,1,2,652), -- Recipe: Doom Boots (60%)
(20137,5550,1,1,2,699), -- Durable Metal Plate
(20137,6669,1,1,2,12175), -- Deluxe Chest Key - Grade 5
(20143,1792,1,1,-1,15682), -- Recipe: Short Spear
(20143,1867,1,1,-1,284370), -- Animal Skin
(20143,1872,1,1,-1,284370), -- Animal Bone
(20143,57,114,157,0,700000), -- Adena
(20143,20,1,1,1,4533), -- Buckler
(20143,43,1,1,1,3166), -- Wooden Helmet
(20143,17,10,30,2,157499), -- Wooden Arrow
(20143,1798,1,1,2,30882), -- Recipe: Leather Helmet
(20143,1866,1,1,2,21000), -- Suede
(20143,1871,1,1,2,31500), -- Charcoal
(20144,1880,1,1,-1,59999), -- Steel
(20144,1901,1,1,-1,82871), -- Tiger\'s Eye Earring Stone
(20144,2272,1,1,-1,4286), -- Recipe: Sword of Revolution
(20144,57,253,506,0,700000), -- Adena
(20144,393,1,1,1,70), -- Mithril Banded Mail
(20144,394,1,1,1,70), -- Reinforced Leather Shirt
(20144,415,1,1,1,112), -- Mithril Banded Gaiters
(20144,416,1,1,1,112), -- Reinforced Leather Gaiters
(20144,1938,1,1,1,3575), -- Mithril Banded Mail Material
(20144,1939,1,1,1,4671), -- Mithril Banded Gaiters Material
(20144,1341,10,30,2,106336), -- Bone Arrow
(20144,1875,1,1,2,2127), -- Stone of Purity
(20144,1879,1,1,2,5317), -- Cokes
(20144,1885,1,1,2,2659), -- High Grade Suede
(20144,2274,1,1,2,228), -- Recipe: Skull Breaker
(20144,2976,1,1,2,4271), -- Recipe: Manticore Skin Boots
(20144,2985,1,1,2,3262), -- Recipe: Plate Boots
(20144,5549,1,1,2,3191), -- Metallic Thread
(20144,5550,1,1,2,426), -- Durable Metal Plate
(20144,6667,1,1,2,19938), -- Deluxe Chest Key - Grade 3
(20145,2153,1,1,-1,78158), -- Recipe: Tiger\'s Eye Earring
(20145,2183,1,1,-1,33063), -- Recipe: Mithril Banded Mail
(20145,2268,1,1,-1,5197), -- Recipe: Tome of Blood
(20145,57,212,425,0,700000), -- Adena
(20145,848,1,1,1,323), -- Enchanted Earring
(20145,879,1,1,1,484), -- Enchanted Ring
(20145,911,1,1,1,242), -- Enchanted Necklace
(20145,1900,1,1,1,7512), -- Enchanted Necklace Chain
(20145,1868,1,1,2,91542), -- Thread
(20145,1873,1,1,2,18309), -- Silver Nugget
(20145,1889,1,1,2,3052), -- Compound Braid
(20145,2268,1,1,2,474), -- Recipe: Tome of Blood
(20145,2276,1,1,2,327), -- Recipe: Maingauche
(20145,5549,1,1,2,4578), -- Metallic Thread
(20146,1869,1,3,-1,606685), -- Iron Ore
(20146,1914,1,1,-1,68167), -- Earring of Binding Gemstone
(20146,1915,1,1,-1,106905), -- Ring of Ages Gemstone
(20146,57,490,995,0,700000), -- Adena
(20146,103,1,1,1,49), -- Tower Shield
(20146,107,1,1,1,49), -- Composite Shield
(20146,517,1,1,1,35), -- Composite Helmet
(20146,1149,1,1,1,35), -- Shining Circlet
(20146,1978,1,1,1,4021), -- Tower Shield Fragment
(20146,1983,1,1,1,2751), -- Shining Circlet Pattern
(20146,2957,1,1,1,2751), -- Composite Helmet Design
(20146,4055,1,1,1,4021), -- Composite Shield Fragment
(20146,1866,1,1,2,37169), -- Suede
(20146,1871,1,1,2,55753), -- Charcoal
(20146,1877,1,1,2,2231), -- Adamantite Nugget
(20146,2170,1,1,2,1315), -- Recipe: Nassen\'s Earring
(20146,3014,1,1,2,1558), -- Recipe: Full Plate Boots
(20146,4040,1,1,2,1116), -- Mold Lubricant
(20146,4041,1,1,2,485), -- Mold Hardener
(20146,4188,1,1,2,65), -- Recipe: Hell Knife
(20146,4609,1,1,2,124), -- Greater Dye of Mental Strength <Men+3 Int-3>
(20147,1870,1,1,-1,284768), -- Coal
(20147,1876,1,1,-1,56954), -- Mithril Ore
(20147,57,130,231,0,700000), -- Adena
(20147,27,1,1,1,228), -- Hard Leather Shirt
(20147,33,1,1,1,366), -- Hard Leather Gaiters
(20147,1927,1,1,1,3356), -- Hard Leather Shirt Pattern
(20147,1929,1,1,1,5427), -- Hard Leather Gaiters Material
(20147,1868,1,1,2,84117), -- Thread
(20147,1873,1,1,2,16824), -- Silver Nugget
(20147,2255,1,1,2,1029), -- Recipe: Saber
(20147,6666,1,1,2,42059), -- Deluxe Chest Key - Grade 2
(20153,30,1,1,-1,8112), -- Hard Leather Pants
(20153,1831,1,1,-1,537542), -- Antidote
(20153,1867,1,1,-1,268771), -- Animal Skin
(20153,57,109,147,0,700000), -- Adena
(20153,429,1,1,1,749), -- Leather Tunic
(20153,464,1,1,1,1199), -- Leather Stockings
(20153,1922,1,1,1,7596), -- Leather Tunic Pattern
(20153,1923,1,1,1,12202), -- Leather Stocking Pattern
(20153,1793,1,1,2,2919), -- Recipe: Sword of Reflection
(20153,1867,1,1,2,52928), -- Animal Skin
(20153,1872,1,1,2,52928), -- Animal Bone
(20154,1898,1,1,-1,29252), -- Blue Diamond Necklace Gem
(20154,1929,1,1,-1,36744), -- Hard Leather Gaiters Material
(20154,2178,1,1,-1,45563), -- Recipe: Dark Stockings
(20154,57,130,231,0,700000), -- Adena
(20154,846,1,1,1,526), -- Coral Earring
(20154,878,1,1,1,787), -- Blue Coral Ring
(20154,909,1,1,1,395), -- Blue Diamond Necklace
(20154,1898,1,1,1,4321), -- Blue Diamond Necklace Gem
(20154,1868,1,1,2,84117), -- Thread
(20154,1873,1,1,2,16824), -- Silver Nugget
(20154,2256,1,1,2,1029), -- Recipe: Assassin Knife
(20154,5158,1,1,2,1683), -- Recipe: Spiritshot (D) Compressed Package (100%)
(20155,1804,1,1,-1,12857), -- Recipe: Soulshot: D-Grade
(20155,1865,1,1,-1,321422), -- Varnish
(20155,1898,1,1,-1,33017), -- Blue Diamond Necklace Gem
(20155,57,147,260,0,700000), -- Adena
(20155,846,1,1,1,594), -- Coral Earring
(20155,878,1,1,1,888), -- Blue Coral Ring
(20155,909,1,1,1,446), -- Blue Diamond Necklace
(20155,1898,1,1,1,4877), -- Blue Diamond Necklace Gem
(20155,735,1,1,2,2261), -- Potion of Alacrity
(20155,1864,1,1,2,54254), -- Stem
(20155,1869,1,1,2,27127), -- Iron Ore
(20155,1880,1,1,2,2713), -- Steel
(20155,3032,1,1,2,1086), -- Recipe: Spiritshot D
(20155,5273,1,1,2,1086), -- Recipe: Greater Spiritshot (D) Compressed Package(100%)
(20155,6666,1,1,2,27127), -- Deluxe Chest Key - Grade 2
(20156,1899,1,1,-1,55740), -- Necklace of Devotion Chain
(20156,2181,1,1,-1,35709), -- Recipe: White Tunic
(20156,57,157,294,0,700000), -- Adena
(20156,847,1,1,1,373), -- Red Crescent Earring
(20156,890,1,1,1,557), -- Ring of Devotion
(20156,910,1,1,1,279), -- Necklace of Devotion
(20156,1899,1,1,1,7821), -- Necklace of Devotion Chain
(20156,1061,1,1,2,17335), -- Healing Potion
(20156,1876,1,1,2,5721), -- Mithril Ore
(20156,1877,1,1,2,1145), -- Adamantite Nugget
(20156,1880,1,1,2,2861), -- Steel
(20156,1881,1,1,2,3814), -- Coarse Bone Powder
(20156,1882,1,1,2,6356), -- Leather
(20156,2181,1,1,2,2864), -- Recipe: White Tunic
(20157,1879,1,1,-1,85605), -- Cokes
(20157,2024,1,1,-1,7317), -- Elven Bow Shaft
(20157,2153,1,1,-1,79880), -- Recipe: Tiger\'s Eye Earring
(20157,57,218,431,0,700000), -- Adena
(20157,86,1,1,1,9), -- Tomahawk
(20157,179,1,1,1,9), -- Mace of Prayer
(20157,180,1,1,1,9), -- Mace of Judgment
(20157,181,1,1,1,9), -- Mace of Miracle
(20157,182,1,1,1,9), -- Doom Hammer
(20157,183,1,1,1,9), -- Mystic Staff
(20157,184,1,1,1,9), -- Conjuror\'s Staff
(20157,185,1,1,1,9), -- Staff of Mana
(20157,2022,1,1,1,438), -- Mace of Judgment Head
(20157,2023,1,1,1,348), -- Conjuror\'s Staff Head
(20157,1061,1,1,2,21264), -- Healing Potion
(20157,1829,1,1,2,14034), -- Scroll of Escape: Clan Hall
(20157,1864,1,1,2,70170), -- Stem
(20157,1869,1,1,2,35085), -- Iron Ore
(20157,1878,1,1,2,14034), -- Braided Hemp
(20157,1884,1,1,2,21591), -- Cord
(20157,2274,1,1,2,251), -- Recipe: Skull Breaker
(20157,2282,1,1,2,251), -- Recipe: Cursed Maingauche
(20158,1876,1,1,-1,113569), -- Mithril Ore
(20158,1901,1,1,-1,78432), -- Tiger\'s Eye Earring Stone
(20158,1939,1,1,-1,49877), -- Mithril Banded Gaiters Material
(20158,57,240,478,0,700000), -- Adena
(20158,436,1,1,1,199), -- Tunic of Knowledge
(20158,469,1,1,1,318), -- Stockings of Knowledge
(20158,1864,1,1,2,100640), -- Stem
(20158,1869,1,1,2,50320), -- Iron Ore
(20158,1880,1,1,2,5032), -- Steel
(20158,2271,1,1,2,360), -- Recipe: Winged Spear
(20158,2972,1,1,2,2692), -- Recipe: Brigandine Gaiters
(20158,5550,1,1,2,671), -- Durable Metal Plate
(20160,1874,1,1,-1,27494), -- Oriharukon Ore
(20160,2152,1,1,-1,72606), -- Recipe: Enchanted Necklace
(20160,2261,1,1,-1,6404), -- Recipe: Conjuror\'s Staff
(20160,57,177,346,0,700000), -- Adena
(20160,258,1,1,1,113), -- Bagh-Nakh
(20160,1874,1,1,2,2572), -- Oriharukon Ore
(20160,1878,1,1,2,15431), -- Braided Hemp
(20160,1884,1,1,2,23739), -- Cord
(20160,1889,1,1,2,2572), -- Compound Braid
(20160,2152,1,1,2,6792), -- Recipe: Enchanted Necklace
(20160,5220,1,1,2,1544), -- Metal Hardener
(20161,1806,1,1,-1,2737), -- Recipe: Soulshot: B-Grade
(20161,1872,1,3,-1,912482), -- Animal Bone
(20161,1984,1,1,-1,29340), -- Theca Leather Armor Pattern
(20161,57,553,1123,0,700000), -- Adena
(20161,266,1,1,1,9), -- Great Pata
(20161,2120,1,1,1,1214), -- Great Pata Blade
(20161,1806,1,1,2,92), -- Recipe: Soulshot: B-Grade
(20161,1867,1,1,2,61258), -- Animal Skin
(20161,1872,1,1,2,61258), -- Animal Bone
(20161,1882,1,1,2,10210), -- Leather
(20161,1894,1,1,2,1612), -- Crafted Leather
(20161,3955,1,1,2,92), -- Recipe: Blessed Spiritshot B
(20161,4042,1,1,2,766), -- Enria
(20161,4180,1,1,2,5105), -- Recipe: Silver Arrow
(20161,5165,1,1,2,92), -- Recipe: Blessed Spiritshot (B) Compressed Package (100%)
(20161,5280,1,1,2,92), -- Recipe: Greater Blessed Spiritshot (B) Compressed Package(100%)
(20161,6669,1,1,2,10685), -- Deluxe Chest Key - Grade 5
(20168,955,1,1,-1,1770), -- Scroll: Enchant Weapon (Grade D)
(20168,1061,1,1,-1,268170), -- Healing Potion
(20168,1877,1,1,-1,17699), -- Adamantite Nugget
(20168,57,187,373,0,700000), -- Adena
(20168,46,1,1,1,484), -- Bronze Helmet
(20168,627,1,1,1,691), -- Aspis
(20168,1865,1,1,2,40300), -- Varnish
(20168,1870,1,1,2,40300), -- Coal
(20168,1875,1,1,2,2687), -- Stone of Purity
(20168,1879,1,1,2,6717), -- Cokes
(20168,2184,1,1,2,4234), -- Recipe: Mithril Banded Gaiters
(20168,2274,1,1,2,288), -- Recipe: Skull Breaker
(20171,1880,1,1,-1,37576), -- Steel
(20171,1899,1,1,-1,58713), -- Necklace of Devotion Chain
(20171,2019,1,1,-1,8081), -- Trident Edge
(20171,57,163,312,0,700000), -- Adena
(20171,101,1,1,1,21), -- Scroll of Wisdom
(20171,312,1,1,1,21), -- Branch of Life
(20171,313,1,1,1,21), -- Temptation of Abyss
(20171,314,1,1,1,21), -- Proof of Revenge
(20171,2020,1,1,1,739), -- Temptation of Abyss Piece
(20171,1061,1,1,2,21302), -- Healing Potion
(20171,1875,1,1,2,2344), -- Stone of Purity
(20171,1879,1,1,2,5859), -- Cokes
(20171,2263,1,1,2,546), -- Recipe: Dwarven Trident
(20171,5549,1,1,2,3515), -- Metallic Thread
(20171,6666,1,1,2,35149), -- Deluxe Chest Key - Grade 2
(20176,1873,1,1,-1,239995), -- Silver Nugget
(20176,2154,1,1,-1,64239), -- Recipe: Elven Earring
(20176,2273,1,1,-1,4286), -- Recipe: Tarbar
(20176,57,253,506,0,700000), -- Adena
(20176,63,1,1,1,180), -- Gauntlets
(20176,553,1,1,1,180), -- Iron Boots
(20176,1940,1,1,1,6802), -- Iron Boots Design
(20176,2422,1,1,1,180), -- Reinforced Leather Boots
(20176,2423,1,1,1,180), -- Boots of Knowledge
(20176,2446,1,1,1,180), -- Reinforced Leather Gloves
(20176,2447,1,1,1,180), -- Gloves of Knowledge
(20176,1867,1,1,2,60764), -- Animal Skin
(20176,1872,1,1,2,60764), -- Animal Bone
(20176,1882,1,1,2,10128), -- Leather
(20176,2286,1,1,2,254), -- Recipe: Bonebreaker
(20176,2977,1,1,2,6101), -- Recipe: Brigandine Boots
(20176,2981,1,1,2,6101), -- Recipe: Elven Mithril Gloves
(20176,2985,1,1,2,4660), -- Recipe: Plate Boots
(20190,1864,1,1,-1,889140), -- Stem
(20190,1900,1,1,-1,48640), -- Enchanted Necklace Chain
(20190,2025,1,1,-1,6157), -- Dwarven Trident Edge
(20190,57,188,373,0,700000), -- Adena
(20190,275,1,1,1,26), -- Long Bow
(20190,276,1,1,1,26), -- Elven Bow
(20190,2024,1,1,1,1154), -- Elven Bow Shaft
(20190,1866,1,1,2,32392), -- Suede
(20190,1871,1,1,2,48589), -- Charcoal
(20190,1885,1,1,2,4049), -- High Grade Suede
(20190,2153,1,1,2,7557), -- Recipe: Tiger\'s Eye Earring
(20190,5220,1,1,2,1944), -- Metal Hardener
(20191,1900,1,1,-1,49380), -- Enchanted Necklace Chain
(20191,2153,1,1,-1,70191), -- Recipe: Tiger\'s Eye Earring
(20191,2264,1,1,-1,4667), -- Recipe: Two-handed Sword
(20191,57,190,381,0,700000), -- Adena
(20191,605,1,1,1,741), -- Leather Gauntlets
(20191,1123,1,1,1,741), -- Blue Buckskin Boots
(20191,1867,1,1,2,46979), -- Animal Skin
(20191,1872,1,1,2,46979), -- Animal Bone
(20191,1882,1,1,2,7830), -- Leather
(20191,2185,1,1,2,6936), -- Recipe: Iron Boots
(20191,2274,1,1,2,252), -- Recipe: Skull Breaker
(20191,2279,1,1,2,252), -- Recipe: War Pick
(20191,6667,1,1,2,22021), -- Deluxe Chest Key - Grade 3
(20192,1901,1,1,-1,81246), -- Tiger\'s Eye Earring Stone
(20192,2146,1,1,-1,42016), -- Recipe: Artisan\'s frame
(20192,2447,1,1,-1,2316), -- Gloves of Knowledge
(20192,57,248,496,0,700000), -- Adena
(20192,223,1,1,1,13), -- Kukuri
(20192,238,1,1,1,13), -- Dagger of Mana
(20192,239,1,1,1,13), -- Mystic Knife
(20192,241,1,1,1,13), -- Shilen Knife
(20192,2028,1,1,1,744), -- Shilen Knife Edge
(20192,1864,1,1,2,104252), -- Stem
(20192,1869,1,1,2,52126), -- Iron Ore
(20192,1878,1,1,2,20851), -- Braided Hemp
(20192,1884,1,1,2,32078), -- Cord
(20192,2978,1,1,2,6979), -- Recipe: Elven Mithril Boots
(20192,6667,1,1,2,32579), -- Deluxe Chest Key - Grade 3
(20193,1874,1,1,-1,42231), -- Oriharukon Ore
(20193,1882,1,1,-1,140771), -- Leather
(20193,2027,1,1,-1,8299), -- Spiked Club Head
(20193,57,267,535,0,700000), -- Adena
(20193,47,1,1,1,443), -- Helmet
(20193,628,1,1,1,632), -- Hoplon
(20193,1341,10,30,2,160386), -- Bone Arrow
(20193,1867,1,1,2,64155), -- Animal Skin
(20193,1872,1,1,2,64155), -- Animal Bone
(20193,1882,1,1,2,10693), -- Leather
(20193,1894,1,1,2,1689), -- Crafted Leather
(20193,2271,1,1,2,344), -- Recipe: Winged Spear
(20193,2286,1,1,2,268), -- Recipe: Bonebreaker
(20197,1876,1,1,-1,76167), -- Mithril Ore
(20197,2020,1,1,-1,6667), -- Temptation of Abyss Piece
(20197,2259,1,1,-1,5914), -- Recipe: Spinebone Sword
(20197,57,164,317,0,700000), -- Adena
(20197,847,1,1,1,398), -- Red Crescent Earring
(20197,890,1,1,1,594), -- Ring of Devotion
(20197,910,1,1,1,298), -- Necklace of Devotion
(20197,1899,1,1,1,8350), -- Necklace of Devotion Chain
(20197,1341,10,30,2,101780), -- Bone Arrow
(20197,1876,1,1,2,6107), -- Mithril Ore
(20197,1877,1,1,2,1222), -- Adamantite Nugget
(20197,1880,1,1,2,3054), -- Steel
(20197,1881,1,1,2,4072), -- Coarse Bone Powder
(20197,1882,1,1,2,6786), -- Leather
(20197,2178,1,1,2,4886), -- Recipe: Dark Stockings
(20198,1832,1,1,-1,479579), -- Greater Antidote
(20198,57,183,362,0,700000), -- Adena
(20198,259,1,1,1,73), -- Single-Edged Jamadhr
(20198,1874,1,1,2,1966), -- Oriharukon Ore
(20198,1878,1,1,2,11794), -- Braided Hemp
(20198,1884,1,1,2,18144), -- Cord
(20198,1889,1,1,2,1966), -- Compound Braid
(20198,2183,1,1,2,1940), -- Recipe: Mithril Banded Mail
(20198,2274,1,1,2,211), -- Recipe: Skull Breaker
(20198,2982,1,1,2,3761), -- Recipe: Brigandine Shield
(20198,5220,1,1,2,1180), -- Metal Hardener
(20199,1834,1,1,-1,585058), -- Emergency Dressing
(20199,1882,1,1,-1,117012), -- Leather
(20199,1900,1,1,-1,57610), -- Enchanted Necklace Chain
(20199,57,222,444,0,700000), -- Adena
(20199,605,1,1,1,864), -- Leather Gauntlets
(20199,1123,1,1,1,864), -- Blue Buckskin Boots
(20199,1867,1,1,2,76731), -- Animal Skin
(20199,1872,1,1,2,76731), -- Animal Bone
(20199,1882,1,1,2,12789), -- Leather
(20199,2250,1,1,2,14388), -- Recipe: Bone Arrow
(20199,6035,1,1,2,4796); -- Magic Haste Potion

INSERT INTO `droplist` VALUES 
(20200,1061,1,1,-1,282061), -- Healing Potion
(20200,1877,1,1,-1,18616), -- Adamantite Nugget
(20200,2183,1,1,-1,30618), -- Recipe: Mithril Banded Mail
(20200,57,197,392,0,700000), -- Adena
(20200,433,1,1,1,64), -- Elven Tunic
(20200,434,1,1,1,64), -- White Tunic
(20200,435,1,1,1,64), -- Mystic\'s Tunic
(20200,466,1,1,1,102), -- Elven Stockings
(20200,467,1,1,1,102), -- Dark Stockings
(20200,468,1,1,1,102), -- Mystic\'s Stockings
(20200,1933,1,1,1,3741), -- Dark Stocking Fabric
(20200,1936,1,1,1,2602), -- White Tunic Pattern
(20200,955,1,1,2,114), -- Scroll: Enchant Weapon (Grade D)
(20200,1834,1,1,2,31399), -- Emergency Dressing
(20200,1875,1,1,2,1884), -- Stone of Purity
(20200,1879,1,1,2,4710), -- Cokes
(20200,1885,1,1,2,2355), -- High Grade Suede
(20200,2188,1,1,2,2019), -- Recipe: Manticore Skin Gaiters
(20200,5549,1,1,2,2826), -- Metallic Thread
(20200,5550,1,1,2,377), -- Durable Metal Plate
(20200,6667,1,1,2,17662), -- Deluxe Chest Key - Grade 3
(20201,466,1,1,-1,1772), -- Elven Stockings
(20201,1870,1,1,-1,553893), -- Coal
(20201,1933,1,1,-1,65164), -- Dark Stocking Fabric
(20201,57,233,468,0,700000), -- Adena
(20201,392,1,1,1,303), -- Lion Skin Shirt
(20201,414,1,1,1,485), -- Lion Skin Gaiters
(20201,737,1,1,2,4325), -- Scroll of Resurrection
(20201,1876,1,1,2,8649), -- Mithril Ore
(20201,1877,1,1,2,1730), -- Adamantite Nugget
(20201,1880,1,1,2,4325), -- Steel
(20201,1881,1,1,2,5766), -- Coarse Bone Powder
(20201,1882,1,1,2,9610), -- Leather
(20201,6387,1,1,2,1730), -- Blessed Scroll of Resurrection for Pets
(20202,1872,1,1,-1,734933), -- Animal Bone
(20202,2154,1,1,-1,59015), -- Recipe: Elven Earring
(20202,2198,1,1,-1,11556), -- Recipe: Sage\'s Rag
(20202,57,233,464,0,700000), -- Adena
(20202,849,1,1,1,228), -- Tiger\'s Eye Earring
(20202,880,1,1,1,343), -- Black Pearl Ring
(20202,912,1,1,1,171), -- Near Forest Necklace
(20202,1901,1,1,1,10120), -- Tiger\'s Eye Earring Stone
(20202,1874,1,1,2,2792), -- Oriharukon Ore
(20202,1878,1,1,2,16747), -- Braided Hemp
(20202,1884,1,1,2,25765), -- Cord
(20202,1889,1,1,2,2792), -- Compound Braid
(20202,2272,1,1,2,300), -- Recipe: Sword of Revolution
(20202,2274,1,1,2,300), -- Recipe: Skull Breaker
(20202,5220,1,1,2,1675), -- Metal Hardener
(20203,1882,1,1,-1,59453), -- Leather
(20203,1897,1,1,-1,63700), -- Necklace of Wisdom Chain
(20203,57,124,215,0,700000), -- Adena
(20203,176,1,1,1,116), -- Journeyman\'s Staff
(20203,2501,1,1,1,116), -- Bone Club
(20203,1867,1,1,2,42148), -- Animal Skin
(20203,1872,1,1,2,42148), -- Animal Bone
(20203,1882,1,1,2,7025), -- Leather
(20203,2174,1,1,2,13744), -- Recipe: Hard Leather Gaiters
(20203,5273,1,1,2,1265), -- Recipe: Greater Spiritshot (D) Compressed Package(100%)
(20204,1867,1,1,-1,457600), -- Animal Skin
(20204,1868,1,1,-1,686400), -- Thread
(20204,2014,1,1,-1,3945), -- Iron Hammer Head
(20204,57,157,277,0,700000), -- Adena
(20204,846,1,1,1,634), -- Coral Earring
(20204,878,1,1,1,948), -- Blue Coral Ring
(20204,909,1,1,1,476), -- Blue Diamond Necklace
(20204,1898,1,1,1,5207), -- Blue Diamond Necklace Gem
(20204,1831,1,1,2,108135), -- Antidote
(20204,1867,1,1,2,54068), -- Animal Skin
(20204,1872,1,1,2,54068), -- Animal Bone
(20204,1882,1,1,2,9012), -- Leather
(20204,3953,1,1,2,1623), -- Recipe: Blessed Spiritshot D
(20205,1868,1,1,-1,678960), -- Thread
(20205,1871,1,1,-1,339480), -- Charcoal
(20205,1928,1,1,-1,49451), -- Piece Bone Gaiters Fragment
(20205,57,151,278,0,700000), -- Adena
(20205,257,1,1,1,164), -- Viper\'s Fang
(20205,1868,1,1,2,100278), -- Thread
(20205,1873,1,1,2,20056), -- Silver Nugget
(20205,2255,1,1,2,1226), -- Recipe: Saber
(20205,6037,1,1,2,100278), -- Waking Scroll
(20206,376,1,1,-1,1327), -- Iron Plate Gaiters
(20206,1899,1,1,-1,54106), -- Necklace of Devotion Chain
(20206,2182,1,1,-1,41570), -- Recipe: Scale Gaiters
(20206,57,152,286,0,700000), -- Adena
(20206,391,1,1,1,311), -- Puma Skin Shirt
(20206,413,1,1,1,497), -- Puma Skin Gaiters
(20206,1864,1,1,2,77737), -- Stem
(20206,1869,1,1,2,38869), -- Iron Ore
(20206,1880,1,1,2,3887), -- Steel
(20206,2182,1,1,2,4667), -- Recipe: Scale Gaiters
(20206,6666,1,1,2,38869), -- Deluxe Chest Key - Grade 2
(20207,2152,1,1,-1,120636), -- Recipe: Enchanted Necklace
(20207,2181,1,1,-1,68590), -- Recipe: White Tunic
(20207,2263,1,1,-1,10640), -- Recipe: Dwarven Trident
(20207,57,298,568,0,700000), -- Adena
(20207,220,1,1,1,188), -- Crafted Dagger
(20207,1865,1,1,2,76913), -- Varnish
(20207,1870,1,1,2,76913), -- Coal
(20207,1875,1,1,2,5128), -- Stone of Purity
(20207,1879,1,1,2,12819), -- Cokes
(20207,2152,1,1,2,13541), -- Recipe: Enchanted Necklace
(20208,1869,1,1,-1,715437), -- Iron Ore
(20208,1872,1,3,-1,476958), -- Animal Bone
(20208,1931,1,1,-1,93521), -- Leather Boot Lining
(20208,57,309,595,0,700000), -- Adena
(20208,45,1,1,1,856), -- Bone Helmet
(20208,626,1,1,1,1223), -- Bronze Shield
(20208,1932,1,1,1,21245), -- Bone Helmet Design
(20208,1866,1,1,2,44614), -- Suede
(20208,1871,1,1,2,66921), -- Charcoal
(20208,1885,1,1,2,5577), -- High Grade Suede
(20208,2180,1,1,2,5032), -- Recipe: Scale Mail
(20208,5220,1,1,2,2677), -- Metal Hardener
(20208,6666,1,1,2,66921), -- Deluxe Chest Key - Grade 2
(20209,45,1,1,-1,4949), -- Bone Helmet
(20209,1889,1,1,-1,51639), -- Compound Braid
(20209,2178,1,1,-1,123934), -- Recipe: Dark Stockings
(20209,57,332,650,0,700000), -- Adena
(20209,274,1,1,1,213), -- Strengthened Bow
(20209,1061,1,1,2,52695), -- Healing Potion
(20209,1867,1,1,2,115927), -- Animal Skin
(20209,1872,1,1,2,115927), -- Animal Bone
(20209,1882,1,1,2,19321), -- Leather
(20209,2178,1,1,2,13912), -- Recipe: Dark Stockings
(20210,377,1,1,-1,1890), -- Scale Gaiters
(20210,1900,1,1,-1,86113), -- Enchanted Necklace Chain
(20210,2183,1,1,-1,51781), -- Recipe: Mithril Banded Mail
(20210,57,334,661,0,700000), -- Adena
(20210,348,1,1,1,162), -- Scale Mail
(20210,377,1,1,1,259), -- Scale Gaiters
(20210,1935,1,1,1,6008), -- Scale Mail Fragment
(20210,1937,1,1,1,9238), -- Scale Gaiters Fragment
(20210,1868,1,1,2,143369), -- Thread
(20210,1873,1,1,2,28674), -- Silver Nugget
(20210,1889,1,1,2,4779), -- Compound Braid
(20210,2184,1,1,2,7530), -- Recipe: Mithril Banded Gaiters
(20210,2274,1,1,2,512), -- Recipe: Skull Breaker
(20210,5549,1,1,2,7169), -- Metallic Thread
(20211,1865,1,1,-1,839475), -- Varnish
(20211,1869,1,1,-1,839475), -- Iron Ore
(20211,57,354,708,0,700000), -- Adena
(20211,86,1,1,1,15), -- Tomahawk
(20211,179,1,1,1,15), -- Mace of Prayer
(20211,180,1,1,1,15), -- Mace of Judgment
(20211,181,1,1,1,15), -- Mace of Miracle
(20211,182,1,1,1,15), -- Doom Hammer
(20211,183,1,1,1,15), -- Mystic Staff
(20211,184,1,1,1,15), -- Conjuror\'s Staff
(20211,185,1,1,1,15), -- Staff of Mana
(20211,2022,1,1,1,715), -- Mace of Judgment Head
(20211,2023,1,1,1,569), -- Conjuror\'s Staff Head
(20211,1864,1,1,2,152915), -- Stem
(20211,1869,1,1,2,76457), -- Iron Ore
(20211,1880,1,1,2,7646), -- Steel
(20211,2264,1,1,2,791), -- Recipe: Two-handed Sword
(20211,2280,1,1,2,547), -- Recipe: Crucifix of Blood
(20211,5550,1,1,2,1020), -- Durable Metal Plate
(20213,1884,1,1,-1,878893), -- Cord
(20213,1894,1,1,-1,50112), -- Crafted Leather
(20213,2292,1,1,-1,7934), -- Recipe: Light Crossbow
(20213,57,599,1195,0,700000), -- Adena
(20213,352,1,1,1,83), -- Brigandine Tunic
(20213,1941,1,1,1,4893), -- Brigandine Temper
(20213,2377,1,1,1,132), -- Mithril Scale Gaiters
(20213,2378,1,1,1,132), -- Brigandine Gaiters
(20213,2918,1,1,1,7300), -- Mithril Scale Gaiters Material
(20213,2919,1,1,1,7300), -- Brigandine Gaiters Material
(20213,1341,20,60,2,153807), -- Bone Arrow
(20213,1864,1,3,2,61523), -- Stem
(20213,1869,1,1,2,92284), -- Iron Ore
(20213,1878,1,1,2,36914), -- Braided Hemp
(20213,1884,1,1,2,56790), -- Cord
(20213,2286,1,1,2,513), -- Recipe: Bonebreaker
(20213,2290,1,1,2,513), -- Recipe: Mithril Dagger
(20213,2983,1,1,2,6278), -- Recipe: Plate Helmet
(20214,1877,1,1,-1,52984), -- Adamantite Nugget
(20214,1879,1,1,-1,220767), -- Cokes
(20214,2997,1,1,-1,105127), -- Recipe: Karmian Gloves
(20214,57,545,1090,0,700000), -- Adena
(20214,851,1,1,1,184), -- Omen Beast\'s Eye Earring
(20214,882,1,1,1,275), -- Mithril Ring
(20214,914,1,1,1,137), -- Necklace of Darkness
(20214,1905,1,1,1,10784), -- Omen Beast\'s Eye Earring Gemstone
(20214,1906,1,1,1,15238), -- Mithril Ring Wire
(20214,1907,1,1,1,7712), -- Necklace of Darkness Gem
(20214,1805,1,1,2,370), -- Recipe: Soulshot: C-Grade
(20214,1865,1,1,2,110859), -- Varnish
(20214,1870,1,1,2,110859), -- Coal
(20214,1875,1,1,2,7391), -- Stone of Purity
(20214,1879,1,1,2,18477), -- Cokes
(20214,5269,1,1,2,370), -- Recipe: Greater Soulshot (C) Compressed Package(100%)
(20215,1872,1,5,-1,711850), -- Animal Bone
(20215,2206,1,1,-1,42260), -- Recipe: Mithril Shirt
(20215,4469,1,1,-1,9152), -- Dye of Strength <Str+1 Con-1>
(20215,57,655,1323,0,700000), -- Adena
(20215,297,1,1,1,45), -- Glaive
(20215,2055,1,1,1,3326), -- Glaive Edge
(20215,1866,1,1,2,67024), -- Suede
(20215,1871,1,1,2,100535), -- Charcoal
(20215,1885,1,1,2,8378), -- High Grade Suede
(20215,2205,1,1,2,3182), -- Recipe: Chain Gaiters
(20215,2212,1,1,2,3604), -- Recipe: Plated Leather Gaiters
(20215,2299,1,1,2,440), -- Recipe: Big Hammer
(20215,2989,1,1,2,5320), -- Recipe: Chain Hood
(20215,5220,1,1,2,4022), -- Metal Hardener
(20216,1905,1,1,-1,133555), -- Omen Beast\'s Eye Earring Gemstone
(20216,2297,1,1,-1,5995), -- Recipe: Flamberge
(20216,2933,1,1,-1,153230), -- Sage\'s Worn Gloves Lining
(20216,57,554,1125,0,700000), -- Adena
(20216,61,1,1,1,118), -- Mithril Gloves
(20216,607,1,1,1,118), -- Ogre Power Gauntlets
(20216,1125,1,1,1,118), -- Assault Boots
(20216,1949,1,1,1,6412), -- Mithril Gloves Design
(20216,1957,1,1,1,6412), -- Assault Boots Part
(20216,1963,1,1,1,6412), -- Ogre Power Gauntlets Part
(20216,2427,1,1,1,118), -- Salamander Skin Boots
(20216,2428,1,1,1,118), -- Plate Boots
(20216,2451,1,1,1,118), -- Sage\'s Worn Gloves
(20216,2931,1,1,1,6412), -- Salamander Skin Boot Lining
(20216,2932,1,1,1,6412), -- Plate Boots Design
(20216,2933,1,1,1,6412), -- Sage\'s Worn Gloves Lining
(20216,1867,1,1,2,153206), -- Animal Skin
(20216,1872,1,1,2,153206), -- Animal Bone
(20216,1882,1,1,2,25535), -- Leather
(20216,1894,1,1,2,4032), -- Crafted Leather
(20216,2314,1,1,2,502), -- Recipe: Body Slasher
(20216,5269,1,1,2,384), -- Recipe: Greater Soulshot (C) Compressed Package(100%)
(20217,1873,1,1,-1,643598), -- Silver Nugget
(20217,2075,1,1,-1,12620), -- Orcish Glaive Blade
(20217,2163,1,1,-1,82092), -- Recipe: Earring of Protection
(20217,57,646,1324,0,700000), -- Adena
(20217,62,1,1,1,68), -- Mithril Boots
(20217,1958,1,1,1,3798), -- Mithril Boots Design
(20217,2429,1,1,1,68), -- Chain Boots
(20217,2430,1,1,1,68), -- Karmian Boots
(20217,2431,1,1,1,68), -- Plated Leather Boots
(20217,2432,1,1,1,68), -- Dwarven Chain Boots
(20217,2433,1,1,1,68), -- Boots of Seal
(20217,2452,1,1,1,68), -- Reinforced Mithril Gloves
(20217,2453,1,1,1,68), -- Chain Gloves
(20217,2454,1,1,1,68), -- Karmian Gloves
(20217,2937,1,1,1,3798), -- Chain Boots Part
(20217,2938,1,1,1,3798), -- Karmian Boots Fabric
(20217,2939,1,1,1,3798), -- Plate Leather Boot Lining
(20217,2940,1,1,1,3798), -- Dwarven Chain Boots Part
(20217,2941,1,1,1,3798), -- Boots of Seal Pattern
(20217,2942,1,1,1,3798), -- Reinforced Mithril Gloves Design
(20217,2943,1,1,1,3798), -- Chain Gloves Design
(20217,2944,1,1,1,3798), -- Karmian Gloves Fabric
(20217,1868,1,1,2,190110), -- Thread
(20217,1873,1,1,2,38022), -- Silver Nugget
(20217,1889,1,1,2,6337), -- Compound Braid
(20217,2163,1,1,2,4850), -- Recipe: Earring of Protection
(20217,2225,1,1,2,2067), -- Recipe: Demon\'s Stockings
(20217,2321,1,1,2,332), -- Recipe: Stiletto
(20217,5279,1,1,2,317), -- Recipe: Greater Blessed Spiritshot (C) Compressed Package(100%)
(20217,5549,1,1,2,9506), -- Metallic Thread
(20218,1876,1,1,-1,349385), -- Mithril Ore
(20218,1908,1,1,-1,165429), -- Moonstone Earring Wire
(20218,2073,1,1,-1,13503), -- Chakram Edge
(20218,57,705,1432,0,700000), -- Adena
(20218,631,1,1,1,207), -- Eldarake
(20218,1964,1,1,1,11120), -- Eldarake Temper
(20218,2413,1,1,1,146), -- Chain Hood
(20218,2495,1,1,1,207), -- Chain Shield
(20218,2936,1,1,1,10100), -- Chain Hood Pattern
(20218,2945,1,1,1,11120), -- Chain Shield Fragment
(20218,1864,1,1,2,206406), -- Stem
(20218,1869,1,1,2,103204), -- Iron Ore
(20218,1878,1,1,2,41282), -- Braided Hemp
(20218,1884,1,1,2,63510), -- Cord
(20218,2217,1,1,2,6107), -- Recipe: Knight\'s Shield
(20218,2319,1,1,2,360), -- Recipe: Raid Sword
(20218,2320,1,1,2,360), -- Recipe: Cursed Staff
(20218,4039,1,1,2,3441), -- Mold Glue
(20219,1873,1,1,-1,628922), -- Silver Nugget
(20219,2060,1,1,-1,12485), -- Stormbringer Blade
(20219,2164,1,1,-1,120947), -- Recipe: Ring of Protection
(20219,57,632,1292,0,700000), -- Adena
(20219,281,1,1,1,33), -- Crystallized Ice Bow
(20219,2074,1,1,1,2632), -- Crystallized Ice Bow Shaft
(20219,1865,1,1,2,106157), -- Varnish
(20219,1870,1,1,2,106157), -- Coal
(20219,1874,1,1,2,7078), -- Oriharukon Ore
(20219,2230,1,1,2,2058), -- Recipe: Theca Leather Gaiters
(20219,2326,1,1,2,371), -- Recipe: Horn of Glory
(20219,4039,1,1,2,3539), -- Mold Glue
(20219,4043,1,1,2,3539), -- Asofe
(20220,1895,1,1,-1,494901), -- Metallic Fiber
(20220,1911,1,1,-1,128833), -- Earring of Protection Gemstone
(20220,2944,1,1,-1,155699), -- Karmian Gloves Fabric
(20220,57,697,1423,0,700000), -- Adena
(20220,1126,1,1,1,80), -- Crimson Boots
(20220,1974,1,1,1,5379), -- Crimson Boot Fabric
(20220,2434,1,1,1,80), -- Rind Leather Boots
(20220,2455,1,1,1,86), -- Plated Leather Gloves
(20220,2456,1,1,1,80), -- Dwarven Chain Gloves
(20220,2457,1,1,1,80), -- Gloves of Seal
(20220,2458,1,1,1,80), -- Rind Leather Gloves
(20220,2946,1,1,1,3575), -- Plate Leather Gloves Design
(20220,2948,1,1,1,5379), -- Rind Leather Boot Lining
(20220,2949,1,1,1,5379), -- Dwarven Chain Gloves Design
(20220,2950,1,1,1,5379), -- Gloves of Seal Pattern
(20220,2951,1,1,1,5379), -- Rind Leather Gloves Design
(20220,951,1,1,2,175), -- Scroll: Enchant Weapon (Grade C)
(20220,1866,1,1,2,63957), -- Suede
(20220,1871,1,1,2,95935), -- Charcoal
(20220,1877,1,1,2,3838), -- Adamantite Nugget
(20220,2343,1,1,2,224), -- Recipe: Mace of the Underworld
(20220,2345,1,1,2,224), -- Recipe: Dark Screamer
(20220,4040,1,1,2,1919), -- Mold Lubricant
(20220,4041,1,1,2,835), -- Mold Hardener
(20221,951,1,1,-1,3773), -- Scroll: Enchant Weapon (Grade C)
(20221,2073,1,1,-1,16041), -- Chakram Edge
(20221,2352,1,1,-1,4342), -- Recipe: Widow Maker
(20221,57,837,1702,0,700000), -- Adena
(20221,1126,1,1,1,96), -- Crimson Boots
(20221,1974,1,1,1,6444), -- Crimson Boot Fabric
(20221,2434,1,1,1,96), -- Rind Leather Boots
(20221,2455,1,1,1,103), -- Plated Leather Gloves
(20221,2456,1,1,1,96), -- Dwarven Chain Gloves
(20221,2457,1,1,1,96), -- Gloves of Seal
(20221,2458,1,1,1,96), -- Rind Leather Gloves
(20221,2946,1,1,1,4283), -- Plate Leather Gloves Design
(20221,2948,1,1,1,6444), -- Rind Leather Boot Lining
(20221,2949,1,1,1,6444), -- Dwarven Chain Gloves Design
(20221,2950,1,1,1,6444), -- Gloves of Seal Pattern
(20221,2951,1,1,1,6444), -- Rind Leather Gloves Design
(20221,1539,1,1,2,20434), -- Greater Healing Potion
(20221,1867,1,1,2,122602), -- Animal Skin
(20221,1872,1,1,2,122602), -- Animal Bone
(20221,1875,1,1,2,6131), -- Stone of Purity
(20221,1881,1,1,2,12261), -- Coarse Bone Powder
(20221,2334,1,1,2,214), -- Recipe: Sword of Whispering Death
(20221,2351,1,1,2,193), -- Recipe: Scorpion
(20221,3005,1,1,2,3754), -- Recipe: Demon\'s Boots
(20221,4041,1,1,2,800), -- Mold Hardener
(20221,6668,1,1,2,32840), -- Deluxe Chest Key - Grade 4
(20222,1876,1,1,-1,366230), -- Mithril Ore
(20222,1895,1,1,-1,523186), -- Metallic Fiber
(20222,2168,1,1,-1,46594), -- Recipe: Necklace of Mermaid
(20222,57,737,1504,0,700000), -- Adena
(20222,500,1,1,1,112), -- Great Helmet
(20222,632,1,1,1,161), -- Knight\'s Shield
(20222,1971,1,1,1,8279), -- Great Helmet Material
(20222,1972,1,1,1,10819), -- Knight\'s Shield Fragment
(20222,2496,1,1,1,174), -- Dwarven Chain Shield
(20222,2947,1,1,1,9660), -- Dwarven Chain Shield Fragment
(20222,1539,1,1,2,22537), -- Greater Healing Potion
(20222,1868,1,1,2,202835), -- Thread
(20222,1873,1,1,2,40568), -- Silver Nugget
(20222,1876,1,1,2,20284), -- Mithril Ore
(20222,1895,1,1,2,28977), -- Metallic Fiber
(20222,2222,1,1,2,634), -- Recipe: Composite Armor
(20222,3006,1,1,2,4140), -- Recipe: Demon\'s Gloves
(20222,4042,1,1,2,1691), -- Enria
(20223,734,1,1,-1,49539), -- Haste Potion
(20223,1864,1,1,-1,594474), -- Stem
(20223,2011,1,1,-1,6781), -- Short Spear Edge
(20223,57,137,239,0,700000), -- Adena
(20223,845,1,1,1,988), -- Cat\'s Eye Earring
(20223,877,1,1,1,1484), -- Ring of Wisdom
(20223,908,1,1,1,738), -- Necklace of Wisdom
(20223,1897,1,1,1,10453), -- Necklace of Wisdom Chain
(20223,1864,1,1,2,87799), -- Stem
(20223,1869,1,1,2,43900), -- Iron Ore
(20223,1878,1,1,2,17560), -- Braided Hemp
(20223,2175,1,1,2,35691), -- Recipe: Boots
(20224,1865,1,1,-1,389152), -- Varnish
(20224,1898,1,1,-1,39975), -- Blue Diamond Necklace Gem
(20224,2178,1,1,-1,62264), -- Recipe: Dark Stockings
(20224,57,177,317,0,700000), -- Adena
(20224,27,1,1,1,312), -- Hard Leather Shirt
(20224,33,1,1,1,500), -- Hard Leather Gaiters
(20224,1927,1,1,1,4586), -- Hard Leather Shirt Pattern
(20224,1929,1,1,1,7417), -- Hard Leather Gaiters Material
(20224,1867,1,1,2,61307), -- Animal Skin
(20224,1872,1,1,2,61307), -- Animal Bone
(20224,1881,1,1,2,6131), -- Coarse Bone Powder
(20224,5153,1,1,2,1840), -- Recipe: Soulshot (D) Compressed Package (100%)
(20224,5268,1,1,2,1840), -- Recipe: Greater Soulshot (D) Compressed Package (100%)
(20225,1931,1,1,-1,45718), -- Leather Boot Lining
(20225,2152,1,1,-1,61574), -- Recipe: Enchanted Necklace
(20225,2259,1,1,-1,5431), -- Recipe: Spinebone Sword
(20225,57,154,288,0,700000), -- Adena
(20225,40,1,1,1,470), -- Leather Boots
(20225,604,1,1,1,470), -- Crafted Leather Gloves
(20225,1931,1,1,1,6415), -- Leather Boot Lining
(20225,1934,1,1,1,6415), -- Crafted Leather Gloves Lining
(20225,1865,1,1,2,32714), -- Varnish
(20225,1870,1,1,2,32714), -- Coal
(20225,1875,1,1,2,2181), -- Stone of Purity
(20225,1879,1,1,2,5453), -- Cokes
(20225,2259,1,1,2,509), -- Recipe: Spinebone Sword
(20225,5437,1,1,2,800), -- Recipe: Heavy Sword(100%)
(20226,413,1,1,-1,1884), -- Puma Skin Gaiters
(20226,1868,1,1,-1,736790), -- Thread
(20226,1899,1,1,-1,57562), -- Necklace of Devotion Chain
(20226,57,160,305,0,700000), -- Adena
(20226,123,1,1,1,26), -- Saber
(20226,2017,1,1,1,687), -- Saber Blade
(20226,5285,1,1,1,26), -- Heavy Sword
(20226,5531,1,1,1,868), -- Heavy Sword Edge
(20226,1866,1,1,2,34459), -- Suede
(20226,1871,1,1,2,51689), -- Charcoal
(20226,2178,1,1,2,8271), -- Recipe: Dark Stockings
(20226,5220,1,1,2,2068), -- Metal Hardener
(20227,1899,1,1,-1,60696), -- Necklace of Devotion Chain
(20227,2178,1,1,-1,62152), -- Recipe: Dark Stockings
(20227,2260,1,1,-1,6032), -- Recipe: Mace of Judgment
(20227,57,168,323,0,700000), -- Adena
(20227,391,1,1,1,349), -- Puma Skin Shirt
(20227,413,1,1,1,558), -- Puma Skin Gaiters
(20227,1867,1,1,2,58137), -- Animal Skin
(20227,1872,1,1,2,58137), -- Animal Bone
(20227,1882,1,1,2,9690), -- Leather
(20227,2181,1,1,2,4365), -- Recipe: White Tunic
(20227,6035,1,1,2,3634), -- Magic Haste Potion
(20228,1884,1,1,-1,273691), -- Cord
(20228,1931,1,1,-1,58137), -- Leather Boot Lining
(20228,2180,1,1,-1,33440), -- Recipe: Scale Mail
(20228,57,191,373,0,700000), -- Adena
(20228,847,1,1,1,464), -- Red Crescent Earring
(20228,890,1,1,1,694), -- Ring of Devotion
(20228,910,1,1,1,348), -- Necklace of Devotion
(20228,1899,1,1,1,9751), -- Necklace of Devotion Chain
(20228,1831,1,1,2,110936), -- Antidote
(20228,1868,1,1,2,83203), -- Thread
(20228,1873,1,1,2,16641), -- Silver Nugget
(20228,1889,1,1,2,2774), -- Compound Braid
(20228,2180,1,1,2,3128), -- Recipe: Scale Mail
(20228,5549,1,1,2,4161), -- Metallic Thread
(20229,414,1,1,-1,1573), -- Lion Skin Gaiters
(20229,1061,1,1,-1,297908), -- Healing Potion
(20229,1864,1,3,-1,491548), -- Stem
(20229,57,207,415,0,700000), -- Adena
(20229,848,1,1,1,316), -- Enchanted Earring
(20229,879,1,1,1,473), -- Enchanted Ring
(20229,911,1,1,1,237), -- Enchanted Necklace
(20229,1900,1,1,1,7348), -- Enchanted Necklace Chain
(20229,1832,1,1,2,42637), -- Greater Antidote
(20229,1864,1,1,2,76747), -- Stem
(20229,1869,1,1,2,38374), -- Iron Ore
(20229,1880,1,1,2,3838), -- Steel
(20229,2265,1,1,2,397), -- Recipe: Spiked Club
(20229,2274,1,1,2,275), -- Recipe: Skull Breaker
(20229,5550,1,1,2,512), -- Durable Metal Plate
(20230,434,1,1,-1,1120), -- White Tunic
(20230,1834,1,1,-1,621516), -- Emergency Dressing
(20230,1870,1,1,-1,559364), -- Coal
(20230,57,237,472,0,700000), -- Adena
(20230,292,1,1,1,95), -- Pike
(20230,956,1,1,2,2548), -- Scroll: Enchant Armor (Grade D)
(20230,1865,1,1,2,76418), -- Varnish
(20230,1870,1,1,2,76418), -- Coal
(20230,1874,1,1,2,5095), -- Oriharukon Ore
(20231,1832,1,1,-1,602189), -- Greater Antidote
(20231,1877,1,1,-1,21679), -- Adamantite Nugget
(20231,2282,1,1,-1,3871), -- Recipe: Cursed Maingauche
(20231,57,228,458,0,700000), -- Adena
(20231,605,1,1,1,890), -- Leather Gauntlets
(20231,1123,1,1,1,890), -- Blue Buckskin Boots
(20231,955,1,1,2,198), -- Scroll: Enchant Weapon (Grade D)
(20231,1832,1,1,2,54846), -- Greater Antidote
(20231,1866,1,1,2,32908), -- Suede
(20231,1871,1,1,2,49361), -- Charcoal
(20231,1877,1,1,2,1975), -- Adamantite Nugget
(20231,2277,1,1,2,353), -- Recipe: Bich\'hwa
(20232,1901,1,1,-1,72904), -- Tiger\'s Eye Earring Stone
(20232,2027,1,1,-1,6915), -- Spiked Club Head
(20232,2147,1,1,-1,37702), -- Recipe: Blacksmith\'s frame
(20232,57,223,446,0,700000), -- Adena
(20232,47,1,1,1,369), -- Helmet
(20232,628,1,1,1,527), -- Hoplon
(20232,1867,1,1,2,62365), -- Animal Skin
(20232,1872,1,1,2,62365), -- Animal Bone
(20232,1875,1,1,2,3119), -- Stone of Purity
(20232,1881,1,1,2,6237), -- Coarse Bone Powder
(20232,2156,1,1,2,3742), -- Recipe: Elven Necklace
(20232,2191,1,1,2,6262), -- Recipe: RIP Gauntlets
(20233,955,1,1,-1,2474), -- Scroll: Enchant Weapon (Grade D)
(20233,2154,1,1,-1,66215), -- Recipe: Elven Earring
(20233,2280,1,1,-1,4417), -- Recipe: Crucifix of Blood
(20233,57,261,521,0,700000), -- Adena
(20233,849,1,1,1,256), -- Tiger\'s Eye Earring
(20233,880,1,1,1,385), -- Black Pearl Ring
(20233,912,1,1,1,192), -- Near Forest Necklace
(20233,1901,1,1,1,11355), -- Tiger\'s Eye Earring Stone
(20233,1832,1,1,2,52195), -- Greater Antidote
(20233,1868,1,1,2,93950), -- Thread
(20233,1873,1,1,2,18790), -- Silver Nugget
(20233,1876,1,1,2,9395), -- Mithril Ore
(20233,2273,1,1,2,336), -- Recipe: Tarbar
(20233,2274,1,1,2,336), -- Recipe: Skull Breaker
(20233,2975,1,1,2,4195), -- Recipe: Brigandine Helmet
(20234,1879,1,1,-1,103998), -- Cokes
(20234,1938,1,1,-1,41949), -- Mithril Banded Mail Material
(20234,2971,1,1,-1,33368), -- Recipe: Mithril Scale Gaiters
(20234,57,264,526,0,700000), -- Adena
(20234,293,1,1,1,35), -- War Hammer
(20234,296,1,1,1,35), -- Dwarven Pike
(20234,1868,1,1,2,132709), -- Thread
(20234,1873,1,1,2,26542), -- Silver Nugget
(20234,1876,1,1,2,13271), -- Mithril Ore
(20234,2188,1,1,2,4740), -- Recipe: Manticore Skin Gaiters
(20234,2979,1,1,2,8883), -- Recipe: Manticore Skin Gloves
(20235,2074,1,1,-1,6875), -- Crystallized Ice Bow Shaft
(20235,2163,1,1,-1,49522), -- Recipe: Earring of Protection
(20235,2340,1,1,-1,2257), -- Recipe: Pa\'agrian Hammer
(20235,57,392,796,0,700000), -- Adena
(20235,96,1,1,1,7), -- Scythe
(20235,298,1,1,1,7), -- Orcish Glaive
(20235,302,1,1,1,7), -- Body Slasher
(20235,2062,1,1,1,600), -- Scythe Edge
(20235,2075,1,1,1,600), -- Orcish Glaive Blade
(20235,2076,1,1,1,600), -- Body Slasher Blade
(20235,3075,1,1,2,7168), -- Spellbook: Blazing Circle
(20235,3076,1,1,2,7168), -- Spellbook: Prominence
(20235,3077,1,1,2,7168), -- Spellbook: Blazing Skin
(20235,3081,1,1,2,7168), -- Spellbook: Aura Flare
(20235,10188,1,1,2,4132), -- Battle Manual: Thin Skin
(20236,1908,1,1,-1,95118), -- Moonstone Earring Wire
(20236,2219,1,1,-1,62388), -- Recipe: Crimson Boots
(20236,3021,1,1,-1,3500), -- Recipe: Dwarven War Hammer
(20236,57,404,825,0,700000), -- Adena
(20236,62,1,1,1,42), -- Mithril Boots
(20236,1958,1,1,1,2371), -- Mithril Boots Design
(20236,2429,1,1,1,42), -- Chain Boots
(20236,2430,1,1,1,42), -- Karmian Boots
(20236,2431,1,1,1,42), -- Plated Leather Boots
(20236,2432,1,1,1,42), -- Dwarven Chain Boots
(20236,2433,1,1,1,42), -- Boots of Seal
(20236,2452,1,1,1,42), -- Reinforced Mithril Gloves
(20236,2453,1,1,1,42), -- Chain Gloves
(20236,2454,1,1,1,42), -- Karmian Gloves
(20236,2937,1,1,1,2371), -- Chain Boots Part
(20236,2938,1,1,1,2371), -- Karmian Boots Fabric
(20236,2939,1,1,1,2371), -- Plate Leather Boot Lining
(20236,2940,1,1,1,2371), -- Dwarven Chain Boots Part
(20236,2941,1,1,1,2371), -- Boots of Seal Pattern
(20236,2942,1,1,1,2371), -- Reinforced Mithril Gloves Design
(20236,2943,1,1,1,2371), -- Chain Gloves Design
(20236,2944,1,1,1,2371), -- Karmian Gloves Fabric
(20236,1865,1,1,2,79120), -- Varnish
(20236,1870,1,1,2,79120), -- Coal
(20236,1874,1,1,2,5275), -- Oriharukon Ore
(20236,2216,1,1,2,3270), -- Recipe: Great Helmet
(20236,4039,1,1,2,2638), -- Mold Glue
(20236,4043,1,1,2,2638), -- Asofe
(20237,951,1,1,-1,2457), -- Scroll: Enchant Weapon (Grade C)
(20237,2329,1,1,-1,3142), -- Recipe: Tsurugi
(20237,3010,1,1,-1,36717), -- Recipe: Composite Helmet
(20237,57,544,1110,0,700000), -- Adena
(20237,282,1,1,1,11), -- Elemental Bow
(20237,285,1,1,1,11), -- Noble Elven Bow
(20237,2085,1,1,1,1036), -- Crossbow Shaft
(20237,2086,1,1,1,1036), -- Elven Bow of Nobility Shaft
(20237,952,1,1,2,998), -- Scroll: Enchant Armor (Grade C)
(20237,1342,10,30,2,149669), -- Fine Steel Arrow
(20237,1864,1,1,2,149669), -- Stem
(20237,1869,1,1,2,74834), -- Iron Ore
(20237,1880,1,1,2,7484), -- Steel
(20237,2230,1,1,2,1451), -- Recipe: Theca Leather Gaiters
(20237,4043,1,1,2,2495), -- Asofe
(20237,5550,1,1,2,998), -- Durable Metal Plate
(20238,1877,1,1,-1,52062), -- Adamantite Nugget
(20238,2357,1,1,-1,2123), -- Recipe: Crystal Dagger
(20238,4041,1,1,-1,11318), -- Mold Hardener
(20238,57,525,1067,0,700000), -- Adena
(20238,355,1,1,1,45), -- Dwarven Chain Mail Shirt
(20238,382,1,1,1,72), -- Dwarven Chain Gaiters
(20238,1968,1,1,1,3474), -- Dwarven Chain Mail Shirt Material
(20238,1969,1,1,1,5510), -- Dwarven Chain Gaiters Material
(20238,1866,1,1,2,48057), -- Suede
(20238,1871,1,1,2,72086), -- Charcoal
(20238,1877,1,1,2,2884), -- Adamantite Nugget
(20238,2335,1,1,2,168), -- Recipe: War Axe
(20238,2348,1,1,2,168), -- Recipe: Heathen\'s Book
(20238,4040,1,1,2,1442), -- Mold Lubricant
(20238,4041,1,1,2,627), -- Mold Hardener
(20238,6668,1,1,2,25745), -- Deluxe Chest Key - Grade 4
(20239,1867,1,3,-1,923295), -- Animal Skin
(20239,2079,1,1,-1,9515), -- Bec De Corbin Blade
(20239,3007,1,1,-1,50362), -- Recipe: Theca Leather Boots
(20239,57,558,1137,0,700000), -- Adena
(20239,73,1,1,1,6), -- Shamshir
(20239,74,1,1,1,6), -- Katana
(20239,131,1,1,1,6), -- Spirit Sword
(20239,133,1,1,1,6), -- Raid Sword
(20239,2077,1,1,1,510), -- Shamshir Blade
(20239,2078,1,1,1,510), -- Katana Blade
(20239,2080,1,1,1,510), -- Spirit Sword Blade
(20239,2081,1,1,1,510), -- Raid Sword Blade
(20239,952,1,1,2,1023), -- Scroll: Enchant Armor (Grade C)
(20239,1867,1,1,2,102273), -- Animal Skin
(20239,1872,1,1,2,102273), -- Animal Bone
(20239,1875,1,1,2,5114), -- Stone of Purity
(20239,1881,1,1,2,10228), -- Coarse Bone Powder
(20239,2351,1,1,2,161), -- Recipe: Scorpion
(20239,3007,1,1,2,2790), -- Recipe: Theca Leather Boots
(20239,4041,1,1,2,668), -- Mold Hardener
(20240,2092,1,1,-1,8118), -- Homunkulus\'s Sword Blade
(20240,2353,1,1,-1,2430), -- Recipe: Samurai Longsword
(20240,4601,1,1,-1,3310), -- Greater Dye of Strength <Str+3 Con-3>
(20240,57,602,1222,0,700000), -- Adena
(20240,265,1,1,1,15), -- Fist Blade
(20240,2108,1,1,1,1650), -- Fist Blade Piece
(20240,1864,1,1,2,175999), -- Stem
(20240,1869,1,1,2,88000), -- Iron Ore
(20240,1878,1,1,2,35200), -- Braided Hemp
(20240,1884,1,1,2,54154), -- Cord
(20240,3019,1,1,2,2347), -- Recipe: Full Plate Shield
(20240,3022,1,1,2,144), -- Recipe: Yaksa Mace
(20240,4039,1,1,2,2934), -- Mold Glue
(20241,1539,1,1,-1,337590), -- Greater Healing Potion
(20241,2100,1,1,-1,8563), -- Paradia Staff Head
(20241,3015,1,1,-1,42434), -- Recipe: Drake Leather Gloves
(20241,57,615,1244,0,700000), -- Adena
(20241,854,1,1,1,71), -- Earring of Binding
(20241,885,1,1,1,107), -- Ring of Ages
(20241,917,1,1,1,54), -- Necklace of Mermaid
(20241,1914,1,1,1,5883), -- Earring of Binding Gemstone
(20241,1915,1,1,1,9226), -- Ring of Ages Gemstone
(20241,1916,1,1,1,4456), -- Necklace of Mermaid Teardrop
(20241,1867,1,1,2,93071), -- Animal Skin
(20241,1872,1,1,2,93071), -- Animal Bone
(20241,1875,1,1,2,4654), -- Stone of Purity
(20241,1881,1,1,2,9308), -- Coarse Bone Powder
(20241,2359,1,1,2,114), -- Recipe: Eminence Bow
(20241,3014,1,1,2,1950), -- Recipe: Full Plate Boots
(20241,4041,1,1,2,608), -- Mold Hardener
(20241,4604,1,1,2,156), -- Greater Dye of Constitution <Con+3 Dex-3>
(20241,4609,1,1,2,156), -- Greater Dye of Mental Strength <Men+3 Int-3>
(20242,1868,1,7,-1,790517), -- Thread
(20242,1918,1,1,-1,68473), -- Nassen\'s Earring Gemstone
(20242,1985,1,1,-1,54518), -- Theca Leather Gaiters Pattern
(20242,57,638,1297,0,700000), -- Adena
(20242,400,1,1,1,24), -- Theca Leather Armor
(20242,401,1,1,1,13), -- Drake Leather Armor
(20242,420,1,1,1,38), -- Theca Leather Gaiters
(20242,1984,1,1,1,2086), -- Theca Leather Armor Pattern
(20242,1985,1,1,1,3356), -- Theca Leather Gaiters Pattern
(20242,1987,1,1,1,1485), -- Drake Leather Armor Texture
(20242,1867,1,1,2,77836), -- Animal Skin
(20242,1872,1,1,2,77836), -- Animal Bone
(20242,1875,1,1,2,3892), -- Stone of Purity
(20242,1881,1,1,2,7784), -- Coarse Bone Powder
(20242,3034,1,1,2,117), -- Recipe: Spiritshot B
(20242,4041,1,1,2,508), -- Mold Hardener
(20242,4941,1,1,2,450), -- Recipe: Zubei\'s Gaiters  (60%)
(20242,4959,1,1,2,1125), -- Recipe: Avadon Boots (60%)
(20242,5270,1,1,2,117), -- Recipe: Greater Soulshot (B) Compressed Package(100%)
(20242,6669,1,1,2,13577), -- Deluxe Chest Key - Grade 5
(20243,1806,1,1,-1,2819), -- Recipe: Soulshot: B-Grade
(20243,1873,1,1,-1,563815), -- Silver Nugget
(20243,4599,1,1,-1,4698), -- Greater Dye of Wit <Wit+2 Int-2>
(20243,57,568,1157,0,700000), -- Adena
(20243,203,1,1,1,3), -- Pa\'agrian Axe
(20243,204,1,1,1,2), -- Deadman\'s Staff
(20243,205,1,1,1,2), -- Ghoul\'s Staff
(20243,206,1,1,1,2), -- Demon\'s Staff
(20243,2112,1,1,1,253), -- Pa\'agrian Axe Blade
(20243,2116,1,1,1,245), -- Deadman\'s Staff Head
(20243,2117,1,1,1,245), -- Ghoul\'s Staff Head
(20243,2118,1,1,1,245), -- Demon\'s Staff Head
(20243,2503,1,1,1,2), -- Yaksa Mace
(20243,2969,1,1,1,251), -- Yaksa Mace Head
(20243,1864,1,1,2,130112), -- Stem
(20243,1869,1,1,2,65056), -- Iron Ore
(20243,1880,1,1,2,6506), -- Steel
(20243,4043,1,1,2,2169), -- Asofe
(20243,4144,1,1,2,669), -- Recipe: Zubei\'s Leather Gaiters
(20243,4184,1,1,2,76), -- Recipe: Sprite\'s Staff
(20243,5155,1,1,2,131), -- Recipe: Soulshot (B) Compressed Package (100%)
(20243,5550,1,1,2,868), -- Durable Metal Plate
(20244,2117,1,1,-1,6820), -- Ghoul\'s Staff Head
(20244,3955,1,1,-1,2899), -- Recipe: Blessed Spiritshot B
(20244,4592,1,1,-1,4832), -- Greater Dye of Constitution <Con+2 Dex-2>
(20244,57,584,1190,0,700000), -- Adena
(20244,400,1,1,1,22), -- Theca Leather Armor
(20244,401,1,1,1,12), -- Drake Leather Armor
(20244,420,1,1,1,35), -- Theca Leather Gaiters
(20244,1984,1,1,1,1913), -- Theca Leather Armor Pattern
(20244,1985,1,1,1,3077), -- Theca Leather Gaiters Pattern
(20244,1987,1,1,1,1362), -- Drake Leather Armor Texture
(20244,1867,1,1,2,101947), -- Animal Skin
(20244,1872,1,1,2,101947), -- Animal Bone
(20244,1875,1,1,2,5098), -- Stone of Purity
(20244,1881,1,1,2,10195), -- Coarse Bone Powder
(20244,4041,1,1,2,665), -- Mold Hardener
(20244,4185,1,1,2,89), -- Recipe: Keshanberk
(20244,5436,1,1,2,125), -- Recipe: Berserker Blade(100%)
(20245,1895,1,1,-1,430289), -- Metallic Fiber
(20245,4071,1,1,-1,27278), -- Avadon Robe Fabric
(20245,4129,1,1,-1,16299), -- Recipe: Earrings of Black Ore
(20245,57,606,1237,0,700000), -- Adena
(20245,503,1,1,1,15), -- Zubei\'s Helmet
(20245,633,1,1,1,21), -- Zubei\'s Shield
(20245,673,1,1,1,21), -- Avadon Shield
(20245,2415,1,1,1,15), -- Avadon Circlet
(20245,4072,1,1,1,2498), -- Avadon Circlet Pattern
(20245,4101,1,1,1,3225), -- Zubei\'s Shield Fragment
(20245,4102,1,1,1,2498), -- Zubei\'s Helmet Design
(20245,4439,1,1,1,3836), -- Avadon Shield Fragment
(20245,1864,1,1,2,111213), -- Stem
(20245,1869,1,1,2,55607), -- Iron Ore
(20245,1878,1,1,2,22243), -- Braided Hemp
(20245,1884,1,1,2,34220), -- Cord
(20245,4039,1,1,2,1854), -- Mold Glue
(20245,4945,1,1,2,428), -- Recipe: Avadon Gaiters (60%)
(20245,4999,1,1,2,692), -- Recipe: Doom Boots (60%)
(20245,6036,1,1,2,1854), -- Greater Magic Haste Potion
(20246,947,1,1,-1,772), -- Scroll: Enchant Weapon (Grade B)
(20246,2964,1,1,-1,105072), -- Divine Gloves Pattern
(20246,4049,1,1,-1,101214), -- Adamantite Earring Gemstone
(20246,57,777,1584,0,700000), -- Adena
(20246,856,1,1,1,32), -- Adamantite Earring
(20246,887,1,1,1,48), -- Adamantite Ring
(20246,918,1,1,1,24), -- Adamantite Necklace
(20246,4049,1,1,1,4984), -- Adamantite Earring Gemstone
(20246,4050,1,1,1,5888), -- Adamantite Ring Wire
(20246,4051,1,1,1,3686), -- Adamantite Necklace Chain
(20246,1864,1,1,2,142497), -- Stem
(20246,1869,1,1,2,71249), -- Iron Ore
(20246,1880,1,1,2,7125), -- Steel
(20246,4043,1,1,2,2375), -- Asofe
(20246,4157,1,1,2,355), -- Recipe: Blue Wolf Gaiters
(20246,4176,1,1,2,887), -- Recipe: Doom Boots
(20246,4969,1,1,2,83), -- Recipe: Hell Knife (60%)
(20246,5550,1,1,2,950), -- Durable Metal Plate
(20248,955,1,1,-1,1880), -- Scroll: Enchant Weapon (Grade D)
(20248,1865,1,1,-1,470054), -- Varnish
(20248,2250,1,1,-1,117514), -- Recipe: Bone Arrow
(20248,57,199,396,0,700000), -- Adena
(20248,86,1,1,1,8), -- Tomahawk
(20248,179,1,1,1,8), -- Mace of Prayer
(20248,180,1,1,1,8), -- Mace of Judgment
(20248,181,1,1,1,8), -- Mace of Miracle
(20248,182,1,1,1,8), -- Doom Hammer
(20248,183,1,1,1,8), -- Mystic Staff
(20248,184,1,1,1,8), -- Conjuror\'s Staff
(20248,185,1,1,1,8), -- Staff of Mana
(20248,2022,1,1,1,400), -- Mace of Judgment Head
(20248,2023,1,1,1,319), -- Conjuror\'s Staff Head
(20248,1829,1,1,2,17125), -- Scroll of Escape: Clan Hall
(20248,1865,1,1,2,42812), -- Varnish
(20248,1870,1,1,2,42812), -- Coal
(20248,1874,1,1,2,2855), -- Oriharukon Ore
(20248,2192,1,1,2,5461), -- Recipe: Kite Shield
(20248,2274,1,1,2,306), -- Recipe: Skull Breaker
(20249,1865,1,3,-1,500696), -- Varnish
(20249,1873,1,1,-1,400557), -- Silver Nugget
(20249,57,423,846,0,700000), -- Adena
(20249,260,1,1,1,110), -- Triple-Edged Jamadhr
(20249,1341,10,30,2,253539), -- Bone Arrow
(20249,1868,1,1,2,152124), -- Thread
(20249,1873,1,1,2,30425), -- Silver Nugget
(20249,1889,1,1,2,5071), -- Compound Braid
(20249,2186,1,1,2,2545), -- Recipe: Brigandine Tunic
(20249,5549,1,1,2,7607), -- Metallic Thread
(20249,6667,1,1,2,47539), -- Deluxe Chest Key - Grade 3
(20250,1884,1,1,-1,234360), -- Cord
(20250,1899,1,1,-1,59505), -- Necklace of Devotion Chain
(20250,2259,1,1,-1,5914), -- Recipe: Spinebone Sword
(20250,57,164,317,0,700000), -- Adena
(20250,847,1,1,1,398), -- Red Crescent Earring
(20250,890,1,1,1,594), -- Ring of Devotion
(20250,910,1,1,1,298), -- Necklace of Devotion
(20250,1899,1,1,1,8350), -- Necklace of Devotion Chain
(20250,1865,1,1,2,42748), -- Varnish
(20250,1870,1,1,2,42748), -- Coal
(20250,1874,1,1,2,2850), -- Oriharukon Ore
(20250,2182,1,1,2,5132), -- Recipe: Scale Gaiters
(20250,5437,1,1,2,1046), -- Recipe: Heavy Sword(100%)
(20251,1880,1,1,-1,40031), -- Steel
(20251,2017,1,1,-1,5320), -- Saber Blade
(20251,2152,1,1,-1,70478), -- Recipe: Enchanted Necklace
(20251,57,172,336,0,700000), -- Adena
(20251,123,1,1,1,28), -- Saber
(20251,2017,1,1,1,747), -- Saber Blade
(20251,5285,1,1,1,28), -- Heavy Sword
(20251,5531,1,1,1,943), -- Heavy Sword Edge
(20251,1866,1,1,2,37445), -- Suede
(20251,1871,1,1,2,56168), -- Charcoal
(20251,1877,1,1,2,2247), -- Adamantite Nugget
(20251,2181,1,1,2,5623), -- Recipe: White Tunic
(20252,1061,1,1,-1,253920), -- Healing Potion
(20252,1865,1,1,-1,418968), -- Varnish
(20252,1900,1,1,-1,45839), -- Enchanted Necklace Chain
(20252,57,178,352,0,700000), -- Adena
(20252,605,1,1,1,688), -- Leather Gauntlets
(20252,1123,1,1,1,688), -- Blue Buckskin Boots
(20252,1867,1,1,2,38159), -- Animal Skin
(20252,1872,1,1,2,38159), -- Animal Bone
(20252,1875,1,1,2,1908), -- Stone of Purity
(20252,1881,1,1,2,3816), -- Coarse Bone Powder
(20252,2185,1,1,2,5634), -- Recipe: Iron Boots
(20252,2187,1,1,2,1278), -- Recipe: Manticore Skin Shirt
(20252,2274,1,1,2,205), -- Recipe: Skull Breaker
(20252,6666,1,1,2,28619), -- Deluxe Chest Key - Grade 2
(20253,1900,1,1,-1,48891), -- Enchanted Necklace Chain
(20253,2153,1,1,-1,69496), -- Recipe: Tiger\'s Eye Earring
(20253,2265,1,1,-1,4621), -- Recipe: Spiked Club
(20253,57,188,377,0,700000), -- Adena
(20253,348,1,1,1,92), -- Scale Mail
(20253,377,1,1,1,147), -- Scale Gaiters
(20253,1935,1,1,1,3411), -- Scale Mail Fragment
(20253,1937,1,1,1,5245), -- Scale Gaiters Fragment
(20253,1868,1,1,2,97678), -- Thread
(20253,1873,1,1,2,19536), -- Silver Nugget
(20253,1876,1,1,2,9768), -- Mithril Ore
(20253,2266,1,1,2,506), -- Recipe: Shilen Knife
(20253,2971,1,1,2,2612), -- Recipe: Mithril Scale Gaiters
(20254,1899,1,1,-1,64438), -- Necklace of Devotion Chain
(20254,2181,1,1,-1,41282), -- Recipe: White Tunic
(20254,2262,1,1,-1,6404), -- Recipe: Elven Bow
(20254,57,177,346,0,700000), -- Adena
(20254,291,1,1,1,57), -- Trident
(20254,2019,1,1,1,2489), -- Trident Edge
(20254,1876,1,1,2,7716), -- Mithril Ore
(20254,1877,1,1,2,1543), -- Adamantite Nugget
(20254,1880,1,1,2,3858), -- Steel
(20254,1881,1,1,2,5144), -- Coarse Bone Powder
(20254,1882,1,1,2,8573), -- Leather
(20254,2182,1,1,2,4631), -- Recipe: Scale Gaiters
(20265,1866,1,1,-1,374196), -- Suede
(20265,1872,1,1,-1,748392), -- Animal Bone
(20265,2015,1,1,-1,6845), -- Sword Breaker Edge
(20265,57,255,458,0,700000), -- Adena
(20265,219,1,1,1,136), -- Sword Breaker
(20265,2015,1,1,1,2023), -- Sword Breaker Edge
(20265,1867,1,1,2,110532), -- Animal Skin
(20265,1872,1,1,2,110532), -- Animal Bone
(20265,1882,1,1,2,18423), -- Leather
(20265,5158,1,1,2,3316), -- Recipe: Spiritshot (D) Compressed Package (100%)
(20266,1866,1,1,-1,233160), -- Suede
(20266,1878,1,1,-1,139896), -- Braided Hemp
(20266,2180,1,1,-1,26296), -- Recipe: Scale Mail
(20266,57,154,288,0,700000), -- Adena
(20266,432,1,1,1,314), -- Cursed Tunic
(20266,465,1,1,1,503), -- Cursed Stockings
(20266,1874,1,1,2,3272), -- Oriharukon Ore
(20266,1878,1,1,2,19629), -- Braided Hemp
(20266,2260,1,1,2,762), -- Recipe: Mace of Judgment
(20266,5220,1,1,2,1963), -- Metal Hardener
(20267,1061,1,1,-1,284881), -- Healing Potion
(20267,1882,1,1,-1,104456), -- Leather
(20267,2203,1,1,-1,102408), -- Recipe: Mithril Boots
(20267,57,199,396,0,700000), -- Adena
(20267,69,1,1,1,16), -- Bastard Sword
(20267,125,1,1,1,16), -- Spinebone Sword
(20267,126,1,1,1,16), -- Artisan\'s Sword
(20267,128,1,1,1,16), -- Knight\'s Sword
(20267,2021,1,1,1,649), -- Spinebone Sword Blade
(20267,1868,1,1,2,102747), -- Thread
(20267,1873,1,1,2,20550), -- Silver Nugget
(20267,1876,1,1,2,10275), -- Mithril Ore
(20267,2153,1,1,2,7990), -- Recipe: Tiger\'s Eye Earring
(20267,2274,1,1,2,367), -- Recipe: Skull Breaker
(20268,1878,1,1,-1,256688), -- Braided Hemp
(20268,1900,1,1,-1,70210), -- Enchanted Necklace Chain
(20268,57,270,542,0,700000), -- Adena
(20268,275,1,1,1,37), -- Long Bow
(20268,276,1,1,1,37), -- Elven Bow
(20268,2024,1,1,1,1666), -- Elven Bow Shaft
(20268,956,1,1,2,2338), -- Scroll: Enchant Armor (Grade D)
(20268,1867,1,1,2,93514), -- Animal Skin
(20268,1872,1,1,2,93514), -- Animal Bone
(20268,1875,1,1,2,4676), -- Stone of Purity
(20268,1881,1,1,2,9352), -- Coarse Bone Powder
(20269,1879,1,1,-1,92785), -- Cokes
(20269,2029,1,1,-1,6641), -- Gastraphetes Shaft
(20269,2154,1,1,-1,59605), -- Recipe: Elven Earring
(20269,57,235,469,0,700000), -- Adena
(20269,157,1,1,1,21), -- Spiked Club
(20269,186,1,1,1,21), -- Staff of Magic
(20269,2027,1,1,1,1293), -- Spiked Club Head
(20269,1875,1,1,2,2467), -- Stone of Purity
(20269,1879,1,1,2,6167), -- Cokes
(20269,1885,1,1,2,3084), -- High Grade Suede
(20269,2275,1,1,2,265), -- Recipe: Heavy Bone Club
(20269,2286,1,1,2,206), -- Recipe: Bonebreaker
(20269,5549,1,1,2,3700), -- Metallic Thread
(20269,5550,1,1,2,494), -- Durable Metal Plate
(20269,6667,1,1,2,23126), -- Deluxe Chest Key - Grade 3
(20270,1901,1,1,-1,108561), -- Tiger\'s Eye Earring Stone
(20270,2972,1,1,-1,42031), -- Recipe: Brigandine Gaiters
(20270,2976,1,1,-1,105219), -- Recipe: Manticore Skin Boots
(20270,57,332,662,0,700000), -- Adena
(20270,393,1,1,1,92), -- Mithril Banded Mail
(20270,394,1,1,1,92), -- Reinforced Leather Shirt
(20270,415,1,1,1,147), -- Mithril Banded Gaiters
(20270,416,1,1,1,147), -- Reinforced Leather Gaiters
(20270,1938,1,1,1,4683), -- Mithril Banded Mail Material
(20270,1939,1,1,1,6119), -- Mithril Banded Gaiters Material
(20270,1341,10,30,2,278603), -- Bone Arrow
(20270,1865,1,1,2,83581), -- Varnish
(20270,1870,1,1,2,83581), -- Coal
(20270,1874,1,1,2,5573), -- Oriharukon Ore
(20270,2980,1,1,2,11189), -- Recipe: Brigandine Gauntlets
(20271,1882,1,1,-1,142372), -- Leather
(20271,2155,1,1,-1,102837), -- Recipe: Elven Ring
(20271,2271,1,1,-1,4576), -- Recipe: Winged Spear
(20271,57,271,541,0,700000), -- Adena
(20271,849,1,1,1,265), -- Tiger\'s Eye Earring
(20271,880,1,1,1,398), -- Black Pearl Ring
(20271,912,1,1,1,199), -- Near Forest Necklace
(20271,1901,1,1,1,11763), -- Tiger\'s Eye Earring Stone
(20271,1874,1,1,2,2839), -- Oriharukon Ore
(20271,1878,1,1,2,17033), -- Braided Hemp
(20271,1884,1,1,2,26204), -- Cord
(20271,1889,1,1,2,2839), -- Compound Braid
(20271,2187,1,1,2,1901), -- Recipe: Manticore Skin Shirt
(20271,2269,1,1,2,305), -- Recipe: Morning Star
(20271,2293,1,1,2,237), -- Recipe: Glaive
(20271,5220,1,1,2,1704), -- Metal Hardener
(20291,1879,1,1,-1,57609), -- Cokes
(20291,1898,1,1,-1,35506), -- Blue Diamond Necklace Gem
(20291,2255,1,1,-1,8451), -- Recipe: Saber
(20291,57,157,281,0,700000), -- Adena
(20291,27,1,1,1,277), -- Hard Leather Shirt
(20291,33,1,1,1,444), -- Hard Leather Gaiters
(20291,1927,1,1,1,4073), -- Hard Leather Shirt Pattern
(20291,1929,1,1,1,6587), -- Hard Leather Gaiters Material
(20291,734,1,1,2,6807), -- Haste Potion
(20291,1864,1,1,2,81680), -- Stem
(20291,1869,1,1,2,40840), -- Iron Ore
(20291,1878,1,1,2,16336), -- Braided Hemp
(20291,2257,1,1,2,999), -- Recipe: Trident
(20292,2139,1,1,-1,61663), -- Recipe: Steel Mold
(20292,2150,1,1,-1,144749), -- Recipe: Blue Diamond Necklace
(20292,5220,1,1,-1,12333), -- Metal Hardener
(20292,57,142,248,0,700000), -- Adena
(20292,845,1,1,1,1025), -- Cat\'s Eye Earring
(20292,877,1,1,1,1539), -- Ring of Wisdom
(20292,908,1,1,1,766), -- Necklace of Wisdom
(20292,1897,1,1,1,10842), -- Necklace of Wisdom Chain
(20292,1866,1,1,2,30358), -- Suede
(20292,1871,1,1,2,45537), -- Charcoal
(20292,2252,1,1,2,1867), -- Recipe: Iron Hammer
(20292,5158,1,1,2,1822), -- Recipe: Spiritshot (D) Compressed Package (100%)
(20307,1060,1,1,-1,330759), -- Lesser Healing Potion
(20307,1867,1,1,-1,198456), -- Animal Skin
(20307,2137,1,1,-1,43777), -- Recipe: Steel
(20307,57,80,108,0,700000), -- Adena
(20307,5,1,1,1,352), -- Mace
(20307,8,1,1,1,352), -- Willow Staff
(20307,152,1,1,1,545), -- Heavy Chisel
(20307,2006,1,1,1,1570), -- Willow Staff Head
(20307,1802,1,1,2,31517), -- Recipe: Necklace of Anguish
(20307,1864,1,1,2,29311), -- Stem
(20307,1865,1,1,2,14656), -- Varnish
(20307,1866,1,1,2,9771), -- Suede
(20307,1868,1,1,2,29311), -- Thread
(20307,1873,1,1,2,5863), -- Silver Nugget
(20308,1868,1,1,-1,475131), -- Thread
(20308,1897,1,1,-1,56563), -- Necklace of Wisdom Chain
(20308,1924,1,1,-1,76634), -- Leather Helmet Design
(20308,57,118,183,0,700000), -- Adena
(20308,38,1,1,1,1383), -- Low Boots
(20308,50,1,1,1,1383), -- Leather Gloves
(20308,1925,1,1,1,30677), -- Leather Gloves Lining
(20308,1868,1,1,2,70174), -- Thread
(20308,1873,1,1,2,14035), -- Silver Nugget
(20308,2143,1,1,2,7018), -- Recipe: Synthetic Cokes
(20308,5158,1,1,2,1404), -- Recipe: Spiritshot (D) Compressed Package (100%)
(20310,735,1,1,-1,19993), -- Potion of Alacrity
(20310,1800,1,1,-1,75446), -- Recipe: Piece Bone Breastplate
(20310,1872,1,1,-1,319890), -- Animal Bone
(20310,57,119,185,0,700000), -- Adena
(20310,38,1,1,1,1396), -- Low Boots
(20310,50,1,1,1,1396), -- Leather Gloves
(20310,1925,1,1,1,30981), -- Leather Gloves Lining
(20310,1865,1,1,2,47246), -- Varnish
(20310,1870,1,1,2,47246), -- Coal
(20310,2144,1,1,2,9450), -- Recipe: Compound Braid
(20311,1060,1,1,-1,172757), -- Lesser Healing Potion
(20311,2005,1,1,-1,5553), -- Broadsword Blade
(20311,57,41,58,0,700000), -- Adena
(20311,1119,1,1,1,5045), -- Short Leather Gloves
(20311,1122,1,1,1,5044), -- Cotton Shoes
(20311,1129,1,1,1,5044), -- Crude Leather Shoes
(20311,1060,1,1,2,25515), -- Lesser Healing Potion
(20311,1789,1,1,2,2123), -- Recipe: Cedar Staff
(20311,1868,1,1,2,22964), -- Thread
(20311,1873,1,1,2,4593), -- Silver Nugget
(20312,1666,1,1,-1,32439), -- Recipe: Wooden Arrow
(20312,1866,1,1,-1,64878), -- Suede
(20312,2136,1,1,-1,28622), -- Recipe: Cokes
(20312,57,51,72,0,700000), -- Adena
(20312,19,1,1,1,9012), -- Small Shield
(20312,42,1,1,1,6311), -- Leather Cap
(20312,734,1,1,2,2396), -- Haste Potion
(20312,1802,1,1,2,30910), -- Recipe: Necklace of Anguish
(20312,1864,1,1,2,28746), -- Stem
(20312,1869,1,1,2,14373), -- Iron Ore
(20313,22,1,1,-1,14976), -- Leather Shirt
(20313,1814,1,1,-1,95767), -- Recipe: Leather
(20313,2006,1,1,-1,12997), -- Willow Staff Head
(20313,57,98,132,0,700000), -- Adena
(20313,428,1,1,1,2212), -- Feriotic Tunic
(20313,463,1,1,1,3537), -- Feriotic Stockings
(20313,1100,1,1,1,2212), -- Cotton Tunic
(20313,1103,1,1,1,3537), -- Cotton Stockings
(20313,1790,1,1,2,4968), -- Recipe: Dirk
(20313,1864,1,1,2,53748), -- Stem
(20313,1869,1,1,2,26874), -- Iron Ore
(20313,6037,1,1,2,53747), -- Waking Scroll
(20314,1869,1,1,-1,710924), -- Iron Ore
(20314,1874,1,1,-1,47395), -- Oriharukon Ore
(20314,4472,1,1,-1,4062), -- Dye of Constitution <Con+1 Dex-1>
(20314,57,291,587,0,700000), -- Adena
(20314,70,1,1,1,10), -- Claymore
(20314,2047,1,1,1,785), -- Claymore Blade
(20314,2499,1,1,1,10), -- Elven Long Sword
(20314,2967,1,1,1,774), -- Elven Long Sword Blade
(20314,1864,1,1,2,101999), -- Stem
(20314,1869,1,1,2,51000), -- Iron Ore
(20314,1878,1,1,2,20400), -- Braided Hemp
(20314,1884,1,1,2,31385), -- Cord
(20314,2205,1,1,2,1614), -- Recipe: Chain Gaiters
(20314,2209,1,1,2,3835), -- Recipe: Eldarake
(20314,2299,1,1,2,223), -- Recipe: Big Hammer
(20316,1792,1,1,-1,14822), -- Recipe: Short Spear
(20316,1803,1,1,-1,169394), -- Recipe: Necklace of Wisdom
(20316,1864,1,1,-1,403157), -- Stem
(20316,57,109,147,0,700000), -- Adena
(20316,23,1,1,1,998), -- Wooden Breastplate
(20316,30,1,1,1,1598), -- Hard Leather Pants
(20316,2386,1,1,1,1598), -- Wooden Gaiters
(20316,734,1,1,2,4962), -- Haste Potion
(20316,1794,1,1,2,2190), -- Recipe: Forest Bow
(20316,1865,1,1,2,29772), -- Varnish
(20316,1870,1,1,2,29772), -- Coal
(20317,1786,1,1,-1,30885), -- Recipe: Broad Sword
(20317,1867,1,1,-1,51475), -- Animal Skin
(20317,57,19,29,0,700000), -- Adena
(20317,1,1,1,1,10394), -- Short Sword
(20317,1787,1,1,2,5322), -- Recipe: Willow Staff
(20317,1867,1,1,2,8870), -- Animal Skin
(20317,1869,1,1,2,6653), -- Iron Ore
(20317,1870,1,1,2,6653), -- Coal
(20317,1871,1,1,2,6653), -- Charcoal
(20317,1872,1,1,2,8870), -- Animal Bone
(20318,1060,1,1,-1,171046), -- Lesser Healing Potion
(20318,1866,1,1,-1,51314), -- Suede
(20318,2005,1,1,-1,5498), -- Broadsword Blade
(20318,57,41,58,0,700000), -- Adena
(20318,3,1,1,1,364), -- Broadsword
(20318,2005,1,1,1,1625), -- Broadsword Blade
(20318,1866,1,1,2,15158), -- Suede
(20318,1871,1,1,2,22736), -- Charcoal
(20319,1787,1,1,-1,45293), -- Recipe: Willow Staff
(20319,1865,1,1,-1,56617), -- Varnish
(20319,57,30,42,0,700000), -- Adena
(20319,112,1,1,1,79637), -- Apprentice\'s Earring
(20319,116,1,1,1,118249), -- Magic Ring
(20319,118,1,1,1,59125), -- Necklace of Magic
(20319,1787,1,1,2,7805), -- Recipe: Willow Staff
(20319,1864,1,1,2,19512), -- Stem
(20319,1865,1,1,2,9756), -- Varnish
(20319,1866,1,1,2,6504), -- Suede
(20319,1868,1,1,2,19512), -- Thread
(20319,1873,1,1,2,3903), -- Silver Nugget
(20320,1831,1,1,-1,557587), -- Antidote
(20320,1867,1,1,-1,278794), -- Animal Skin
(20320,2010,1,1,-1,8136), -- Brandish Blade
(20320,57,112,154,0,700000), -- Adena
(20320,216,1,1,1,229), -- Dirk
(20320,2009,1,1,1,2191), -- Dirk Blade
(20320,1799,1,1,2,61001), -- Recipe: Leather Gloves
(20320,1867,1,1,2,54902), -- Animal Skin
(20320,1872,1,1,2,54902), -- Animal Bone
(20321,1060,1,1,-1,396420), -- Lesser Healing Potion
(20321,1870,1,1,-1,178389), -- Coal
(20321,2005,1,1,-1,12742), -- Broadsword Blade
(20321,57,96,130,0,700000), -- Adena
(20321,5,1,1,1,422), -- Mace
(20321,8,1,1,1,422), -- Willow Staff
(20321,152,1,1,1,653), -- Heavy Chisel
(20321,2006,1,1,1,1882), -- Willow Staff Head
(20321,1791,1,1,2,2783), -- Recipe: Brandish
(20321,1833,1,1,2,40148), -- Bandage
(20321,1864,1,1,2,30111), -- Stem
(20321,1865,1,1,2,15056), -- Varnish
(20321,1866,1,1,2,10037), -- Suede
(20321,1868,1,1,2,30111), -- Thread
(20321,1873,1,1,2,6023), -- Silver Nugget
(20322,1796,1,1,-1,156757), -- Recipe: Leather Tunic
(20322,1870,1,1,-1,124622), -- Coal
(20322,2005,1,1,-1,8902), -- Broadsword Blade
(20322,57,67,91,0,700000), -- Adena
(20322,12,1,1,1,589), -- Knife
(20322,215,1,1,1,589), -- Doom Dagger
(20322,17,10,30,2,92028), -- Wooden Arrow
(20322,1867,1,1,2,24541), -- Animal Skin
(20322,1872,1,1,2,24541), -- Animal Bone
(20322,2137,1,1,2,5414), -- Recipe: Steel
(20323,1792,1,1,-1,16716), -- Recipe: Short Spear
(20323,1865,1,1,-1,227339), -- Varnish
(20323,1869,1,1,-1,227339), -- Iron Ore
(20323,57,116,172,0,700000), -- Adena
(20323,216,1,1,1,249), -- Dirk
(20323,2009,1,1,1,2382), -- Dirk Blade
(20323,1792,1,1,2,2469), -- Recipe: Short Spear
(20323,1866,1,1,2,22385), -- Suede
(20323,1871,1,1,2,33577), -- Charcoal
(20323,6037,1,1,2,67153), -- Waking Scroll
(20324,1791,1,1,-1,33633), -- Recipe: Brandish
(20324,1871,1,1,-1,181957), -- Charcoal
(20324,2006,1,1,-1,12997), -- Willow Staff Head
(20324,57,98,132,0,700000), -- Adena
(20324,5,1,1,1,431), -- Mace
(20324,8,1,1,1,431), -- Willow Staff
(20324,152,1,1,1,667), -- Heavy Chisel
(20324,2006,1,1,1,1920), -- Willow Staff Head
(20324,1795,1,1,2,67608), -- Recipe:Leather Shoes
(20324,1867,1,1,2,23888), -- Animal Skin
(20324,1869,1,1,2,17916), -- Iron Ore
(20324,1870,1,1,2,17916), -- Coal
(20324,1871,1,1,2,17916), -- Charcoal
(20324,1872,1,1,2,23888), -- Animal Bone
(20325,118,1,1,-1,171565), -- Necklace of Magic
(20325,1786,1,1,-1,45293), -- Recipe: Broad Sword
(20325,1787,1,1,-1,45293), -- Recipe: Willow Staff
(20325,57,30,42,0,700000), -- Adena
(20325,112,1,1,1,79637), -- Apprentice\'s Earring
(20325,116,1,1,1,118249), -- Magic Ring
(20325,118,1,1,1,59125), -- Necklace of Magic
(20325,1060,1,1,2,26015), -- Lesser Healing Potion
(20325,1788,1,1,2,9366), -- Recipe: Bow 
(20325,1865,1,1,2,11707), -- Varnish
(20325,1870,1,1,2,11707), -- Coal
(20325,6037,1,1,2,23414), -- Waking Scroll
(20326,2006,1,1,-1,8902), -- Willow Staff Head
(20326,2007,1,1,-1,8902), -- Bow Shaft
(20326,2135,1,1,-1,36653), -- Recipe: Braided Hemp
(20326,57,67,91,0,700000), -- Adena
(20326,22,1,1,1,3030), -- Leather Shirt
(20326,29,1,1,1,4844), -- Leather Pants
(20326,1864,1,1,2,24542), -- Stem
(20326,1865,1,1,2,12271), -- Varnish
(20326,1866,1,1,2,8181), -- Suede
(20326,1868,1,1,2,24542), -- Thread
(20326,1873,1,1,2,4909), -- Silver Nugget
(20326,2138,1,1,2,3609), -- Recipe: Coarse Bone Powder (100%)
(20327,1865,1,1,-1,56617), -- Varnish
(20327,1870,1,1,-1,56617), -- Coal
(20327,1872,1,1,-1,75489), -- Animal Bone
(20327,57,30,42,0,700000), -- Adena
(20327,112,1,1,1,79637), -- Apprentice\'s Earring
(20327,116,1,1,1,118249), -- Magic Ring
(20327,118,1,1,1,59125), -- Necklace of Magic
(20327,1786,1,1,2,15609), -- Recipe: Broad Sword
(20327,1867,1,1,2,26015), -- Animal Skin
(20327,1872,1,1,2,26015), -- Animal Bone
(20328,1865,1,1,-1,124622), -- Varnish
(20328,1869,1,1,-1,124622), -- Iron Ore
(20328,2137,1,1,-1,36653), -- Recipe: Steel
(20328,57,67,91,0,700000), -- Adena
(20328,12,1,1,1,589), -- Knife
(20328,215,1,1,1,589), -- Doom Dagger
(20328,1060,1,1,2,23373), -- Lesser Healing Potion
(20328,1666,1,1,2,3506), -- Recipe: Wooden Arrow
(20328,1867,1,1,2,14024), -- Animal Skin
(20328,1869,1,1,2,10518), -- Iron Ore
(20328,1870,1,1,2,10518), -- Coal
(20328,1871,1,1,2,10518), -- Charcoal
(20328,1872,1,1,2,14024), -- Animal Bone
(20329,1869,1,1,-1,239656), -- Iron Ore
(20329,1880,1,1,-1,23966), -- Steel
(20329,1898,1,1,-1,24618), -- Blue Diamond Necklace Gem
(20329,57,109,195,0,700000), -- Adena
(20329,16,1,1,1,116), -- Long Spear
(20329,1867,1,1,2,26968), -- Animal Skin
(20329,1869,1,1,2,20226), -- Iron Ore
(20329,1870,1,1,2,20226), -- Coal
(20329,1871,1,1,2,20226), -- Charcoal
(20329,1872,1,1,2,26968), -- Animal Bone
(20329,2258,1,1,2,495), -- Recipe: Temptation of Abyss
(20329,5268,1,1,2,810), -- Recipe: Greater Soulshot (D) Compressed Package (100%)
(20330,1792,1,1,-1,12352), -- Recipe: Short Spear
(20330,1866,1,1,-1,111988), -- Suede
(20330,1896,1,1,-1,71179), -- Necklace of Anguish Chain
(20330,57,91,122,0,700000), -- Adena
(20330,37,1,1,1,2497), -- Leather Shoes
(20330,49,1,1,1,2497), -- Gloves
(20330,1921,1,1,1,21342), -- Leather Shoes Texture
(20330,1798,1,1,2,32431), -- Recipe: Leather Helmet
(20330,1864,1,1,2,66159), -- Stem
(20330,1869,1,1,2,33080), -- Iron Ore
(20331,1871,1,1,-1,148657), -- Charcoal
(20331,2005,1,1,-1,10618), -- Broadsword Blade
(20331,2007,1,1,-1,10618), -- Bow Shaft
(20331,57,80,108,0,700000), -- Adena
(20331,113,1,1,1,7220), -- Mystic\'s Earring
(20331,875,1,1,1,10843), -- Ring of Knowledge
(20331,906,1,1,1,5422), -- Necklace of Knowledge
(20331,734,1,1,2,3660), -- Haste Potion
(20331,1796,1,1,2,27617), -- Recipe: Leather Tunic
(20331,1865,1,1,2,21956), -- Varnish
(20331,1870,1,1,2,21956), -- Coal
(20333,1792,1,1,-1,17783), -- Recipe: Short Spear
(20333,1798,1,1,-1,237113), -- Recipe: Leather Helmet
(20333,2008,1,1,-1,9411), -- Cedar Staff Head
(20333,57,127,180,0,700000), -- Adena
(20333,255,1,1,1,264), -- Fox Claw Gloves
(20333,2371,1,1,1,561), -- Fist of Butcher
(20333,734,1,1,2,5954), -- Haste Potion
(20333,1803,1,1,2,30018), -- Recipe: Necklace of Wisdom
(20333,1868,1,1,2,71441), -- Thread
(20333,1873,1,1,2,14289), -- Silver Nugget
(20335,734,1,1,-1,40607), -- Haste Potion
(20335,1867,1,1,-1,324856), -- Animal Skin
(20335,1897,1,1,-1,58010), -- Necklace of Wisdom Chain
(20335,57,119,191,0,700000), -- Adena
(20335,2,1,1,1,53), -- Long Sword
(20335,120,1,1,1,53), -- Sword of Reflection
(20335,121,1,1,1,53), -- Sword of Watershadow
(20335,2012,1,1,1,750), -- Sword of Reflection Blade
(20335,1867,1,1,2,47979), -- Animal Skin
(20335,1872,1,1,2,47979), -- Animal Bone
(20335,2174,1,1,2,15646), -- Recipe: Hard Leather Gaiters
(20335,5158,1,1,2,1440), -- Recipe: Spiritshot (D) Compressed Package (100%)
(20336,29,1,1,-1,16398), -- Leather Pants
(20336,1060,1,1,-1,276937), -- Lesser Healing Potion
(20336,1802,1,1,-1,268004), -- Recipe: Necklace of Anguish
(20336,57,67,91,0,700000), -- Adena
(20336,428,1,1,1,1515), -- Feriotic Tunic
(20336,463,1,1,1,2422), -- Feriotic Stockings
(20336,1100,1,1,1,1515), -- Cotton Tunic
(20336,1103,1,1,1,2422), -- Cotton Stockings
(20336,1789,1,1,2,2269), -- Recipe: Cedar Staff
(20336,1864,1,1,2,24541), -- Stem
(20336,1865,1,1,2,12271), -- Varnish
(20336,1866,1,1,2,8181), -- Suede
(20336,1868,1,1,2,24541), -- Thread
(20336,1873,1,1,2,4909), -- Silver Nugget
(20338,1898,1,1,-1,27080), -- Blue Diamond Necklace Gem
(20338,1927,1,1,-1,21031), -- Hard Leather Shirt Pattern
(20338,3032,1,1,-1,10545), -- Recipe: Spiritshot D
(20338,57,120,214,0,700000), -- Adena
(20338,16,1,1,1,128), -- Long Spear
(20338,1831,1,1,2,103827), -- Antidote
(20338,1868,1,1,2,77870), -- Thread
(20338,1873,1,1,2,15574), -- Silver Nugget
(20338,3032,1,1,2,1558), -- Recipe: Spiritshot D
(20340,1792,1,1,-1,13068), -- Recipe: Short Spear
(20340,57,95,131,0,700000), -- Adena
(20340,255,1,1,1,195), -- Fox Claw Gloves
(20340,2371,1,1,1,412), -- Fist of Butcher
(20340,1803,1,1,2,29412), -- Recipe: Necklace of Wisdom
(20340,1865,1,1,2,35000), -- Varnish
(20340,1870,1,1,2,35000), -- Coal
(20341,1897,1,1,-1,58257), -- Necklace of Wisdom Chain
(20341,2141,1,1,-1,48936), -- Recipe: Silver Mold
(20341,2143,1,1,-1,48936), -- Recipe: Synthetic Cokes
(20341,57,115,195,0,700000), -- Adena
(20341,44,1,1,1,709), -- Leather Helmet
(20341,102,1,1,1,1017), -- Round Shield
(20341,945,1,1,1,2101), -- Skeleton Buckler
(20341,1924,1,1,1,11657), -- Leather Helmet Design
(20341,1866,1,1,2,32123), -- Suede
(20341,1871,1,1,2,48184), -- Charcoal
(20341,2175,1,1,2,39174), -- Recipe: Boots
(20342,429,1,1,-1,5359), -- Leather Tunic
(20342,1793,1,1,-1,15682), -- Recipe: Sword of Reflection
(20342,1870,1,1,-1,213277), -- Coal
(20342,57,114,157,0,700000), -- Adena
(20342,255,1,1,1,233), -- Fox Claw Gloves
(20342,2371,1,1,1,495), -- Fist of Butcher
(20342,736,1,1,2,21000), -- Scroll of Escape
(20342,1864,1,1,2,83999), -- Stem
(20342,1869,1,1,2,42000), -- Iron Ore
(20343,1060,1,1,-1,404348), -- Lesser Healing Potion
(20343,1795,1,1,-1,686629), -- Recipe:Leather Shoes
(20343,2005,1,1,-1,12997), -- Broadsword Blade
(20343,57,98,132,0,700000), -- Adena
(20343,113,1,1,1,8837), -- Mystic\'s Earring
(20343,875,1,1,1,13272), -- Ring of Knowledge
(20343,906,1,1,1,6636), -- Necklace of Knowledge
(20343,1797,1,1,2,72387), -- Recipe: Leather Stockings
(20343,1864,1,1,2,71663), -- Stem
(20343,1869,1,1,2,35832), -- Iron Ore
(20345,1925,1,1,-1,145655), -- Leather Gloves Lining
(20345,2174,1,1,-1,96576), -- Recipe: Hard Leather Gaiters
(20345,5220,1,1,-1,8885), -- Metal Hardener
(20345,57,110,171,0,700000), -- Adena
(20345,24,1,1,1,324), -- Bone Breastplate
(20345,31,1,1,1,517), -- Bone Gaiters
(20345,390,1,1,1,324), -- Cotton Shirt
(20345,412,1,1,1,517), -- Cotton Pants
(20345,1800,1,1,2,8254), -- Recipe: Piece Bone Breastplate
(20345,1831,1,1,2,69986), -- Antidote
(20345,1866,1,1,2,17497), -- Suede
(20345,1871,1,1,2,26245), -- Charcoal
(20345,5268,1,1,2,1050), -- Recipe: Greater Soulshot (D) Compressed Package (100%)
(20346,1803,1,1,-1,169366), -- Recipe: Necklace of Wisdom
(20346,1831,1,1,-1,537455), -- Antidote
(20346,1869,1,1,-1,201546), -- Iron Ore
(20346,57,106,150,0,700000), -- Adena
(20346,20,1,1,1,4284), -- Buckler
(20346,43,1,1,1,2992), -- Wooden Helmet
(20346,736,1,1,2,19845), -- Scroll of Escape
(20346,1866,1,1,2,26460), -- Suede
(20346,1871,1,1,2,39690), -- Charcoal
(20348,1794,1,1,-1,14192), -- Recipe: Forest Bow
(20348,1831,1,1,-1,514696), -- Antidote
(20348,1896,1,1,-1,81784), -- Necklace of Anguish Chain
(20348,57,97,147,0,700000), -- Adena
(20348,66,1,1,1,141), -- Gladius
(20348,1333,1,1,1,141), -- Brandish
(20348,2010,1,1,1,1479), -- Brandish Blade
(20348,1799,1,1,2,56309), -- Recipe: Leather Gloves
(20348,1866,1,1,2,25339), -- Suede
(20348,1871,1,1,2,38009), -- Charcoal
(20349,1794,1,1,-1,13182), -- Recipe: Forest Bow
(20349,1921,1,1,-1,115664), -- Leather Shoes Texture
(20349,2009,1,1,-1,6357), -- Dirk Blade
(20349,57,94,133,0,700000), -- Adena
(20349,23,1,1,1,887), -- Wooden Breastplate
(20349,30,1,1,1,1421), -- Hard Leather Pants
(20349,2386,1,1,1,1421), -- Wooden Gaiters
(20349,1792,1,1,2,2596), -- Recipe: Short Spear
(20349,1867,1,1,2,47073), -- Animal Skin
(20349,1872,1,1,2,47073), -- Animal Bone
(20350,1800,1,1,-1,63500), -- Recipe: Piece Bone Breastplate
(20350,1866,1,1,-1,134620), -- Suede
(20350,2150,1,1,-1,94803), -- Recipe: Blue Diamond Necklace
(20350,57,100,156,0,700000), -- Adena
(20350,845,1,1,1,671), -- Cat\'s Eye Earring
(20350,877,1,1,1,1008), -- Ring of Wisdom
(20350,908,1,1,1,502), -- Necklace of Wisdom
(20350,1897,1,1,1,7102), -- Necklace of Wisdom Chain
(20350,734,1,1,2,4971), -- Haste Potion
(20350,1868,1,1,2,59648), -- Thread
(20350,1873,1,1,2,11930), -- Silver Nugget
(20350,2150,1,1,2,14002), -- Recipe: Blue Diamond Necklace
(20351,735,1,1,-1,19140), -- Potion of Alacrity
(20351,1897,1,1,-1,54686), -- Necklace of Wisdom Chain
(20351,2173,1,1,-1,62245), -- Recipe: Hard Leather Shirt
(20351,57,106,184,0,700000), -- Adena
(20351,272,1,1,1,100), -- Forest Bow
(20351,2013,1,1,1,1465), -- Forest Bow Shaft
(20351,1864,1,1,2,67846), -- Stem
(20351,1869,1,1,2,33923), -- Iron Ore
(20351,1878,1,1,2,13570), -- Braided Hemp
(20351,2253,1,1,2,1391), -- Recipe: Sword Breaker
(20352,26,1,1,-1,1147), -- Bronze Breastplate
(20352,1878,1,1,-1,112862), -- Braided Hemp
(20352,57,128,230,0,700000), -- Adena
(20352,68,1,1,1,69), -- Falchion
(20352,5284,1,1,1,69), -- Zweihander
(20352,1864,1,1,2,66676), -- Stem
(20352,1869,1,1,2,33338), -- Iron Ore
(20352,1878,1,1,2,13336), -- Braided Hemp
(20352,5163,1,1,2,1334), -- Recipe: Blessed Spiritshot (D) Compressed Package (100%)
(20352,5273,1,1,2,1334), -- Recipe: Greater Spiritshot (D) Compressed Package(100%)
(20353,1864,1,1,-1,484105), -- Stem
(20353,1878,1,1,-1,96821), -- Braided Hemp
(20353,2256,1,1,-1,5918), -- Recipe: Assassin Knife
(20353,57,110,197,0,700000), -- Adena
(20353,16,1,1,1,117), -- Long Spear
(20353,1864,1,1,2,57199), -- Stem
(20353,1869,1,1,2,28600), -- Iron Ore
(20353,1878,1,1,2,11440), -- Braided Hemp
(20353,3953,1,1,2,1144), -- Recipe: Blessed Spiritshot D
(20353,5273,1,1,2,1144), -- Recipe: Greater Spiritshot (D) Compressed Package(100%)
(20356,1868,1,1,-1,713468), -- Thread
(20356,1873,1,1,-1,142694), -- Silver Nugget
(20356,1899,1,1,-1,55740), -- Necklace of Devotion Chain
(20356,57,157,294,0,700000), -- Adena
(20356,220,1,1,1,98), -- Crafted Dagger
(20356,1868,1,1,2,100106), -- Thread
(20356,1873,1,1,2,20022), -- Silver Nugget
(20356,2178,1,1,2,8009), -- Recipe: Dark Stockings
(20356,5549,1,1,2,5006), -- Metallic Thread
(20357,1804,1,1,-1,12071), -- Recipe: Soulshot: D-Grade
(20357,1898,1,1,-1,30999), -- Blue Diamond Necklace Gem
(20357,1926,1,1,-1,30482), -- Piece Bone Breastplate Fragment
(20357,57,137,246,0,700000), -- Adena
(20357,68,1,1,1,73), -- Falchion
(20357,5284,1,1,1,73), -- Zweihander
(20357,1864,1,1,2,89139), -- Stem
(20357,1869,1,1,2,44570), -- Iron Ore
(20357,1880,1,1,2,4457), -- Steel
(20357,2176,1,1,2,21326), -- Recipe: Leather Boots
(20358,1924,1,1,-1,81695), -- Leather Helmet Design
(20358,2140,1,1,-1,50651), -- Recipe: High Grade Suede
(20358,2141,1,1,-1,50651), -- Recipe: Silver Mold
(20358,57,121,200,0,700000), -- Adena
(20358,217,1,1,1,110), -- Shining Knife
(20358,218,1,1,1,110), -- Throwing Knife
(20358,1800,1,1,2,15684), -- Recipe: Piece Bone Breastplate
(20358,1866,1,1,2,33248), -- Suede
(20358,1871,1,1,2,49872), -- Charcoal
(20359,44,1,1,-1,5121), -- Leather Helmet
(20359,1872,1,1,-1,348237), -- Animal Bone
(20359,1924,1,1,-1,84251), -- Leather Helmet Design
(20359,57,122,208,0,700000), -- Adena
(20359,176,1,1,1,114), -- Journeyman\'s Staff
(20359,2501,1,1,1,114), -- Bone Club
(20359,1865,1,1,2,38575), -- Varnish
(20359,1870,1,1,2,38575), -- Coal
(20359,2252,1,1,2,1581), -- Recipe: Iron Hammer
(20359,5268,1,1,2,1543), -- Recipe: Greater Soulshot (D) Compressed Package (100%)
(20360,908,1,1,-1,3993), -- Necklace of Wisdom
(20360,1801,1,1,-1,119680), -- Recipe: Piece Bone Gaiters
(20360,2175,1,1,-1,193143), -- Recipe: Boots
(20360,57,118,183,0,700000), -- Adena
(20360,44,1,1,1,688), -- Leather Helmet
(20360,102,1,1,1,987), -- Round Shield
(20360,945,1,1,1,2040), -- Skeleton Buckler
(20360,1924,1,1,1,11319), -- Leather Helmet Design
(20360,1867,1,1,2,46782), -- Animal Skin
(20360,1872,1,1,2,46782), -- Animal Bone
(20360,2173,1,1,2,9509), -- Recipe: Hard Leather Shirt
(20360,5273,1,1,2,1404), -- Recipe: Greater Spiritshot (D) Compressed Package(100%)
(20361,42,1,1,-1,33615), -- Leather Cap
(20361,1790,1,1,-1,28303), -- Recipe: Dirk
(20361,2005,1,1,-1,10937), -- Broadsword Blade
(20361,57,82,111,0,700000), -- Adena
(20361,14,1,1,1,724), -- Bow
(20361,2007,1,1,1,3231), -- Bow Shaft
(20361,735,1,1,2,1885), -- Potion of Alacrity
(20361,1802,1,1,2,48633), -- Recipe: Necklace of Anguish
(20361,1864,1,1,2,45229), -- Stem
(20361,1869,1,1,2,22615), -- Iron Ore
(20362,1792,1,1,-1,13068), -- Recipe: Short Spear
(20362,1799,1,1,-1,263305), -- Recipe: Leather Gloves
(20362,1867,1,1,-1,236975), -- Animal Skin
(20362,57,95,131,0,700000), -- Adena
(20362,37,1,1,1,2642), -- Leather Shoes
(20362,49,1,1,1,2642), -- Gloves
(20362,1921,1,1,1,22581), -- Leather Shoes Texture
(20362,1060,1,1,2,58333), -- Lesser Healing Potion
(20362,1792,1,1,2,1931), -- Recipe: Short Spear
(20362,1864,1,1,2,52500), -- Stem
(20362,1869,1,1,2,26250), -- Iron Ore
(20363,1867,1,1,-1,198456), -- Animal Skin
(20363,2005,1,1,-1,10632), -- Broadsword Blade
(20363,2006,1,1,-1,10632), -- Willow Staff Head
(20363,57,80,108,0,700000), -- Adena
(20363,254,1,1,1,1407), -- Iron Gloves
(20363,735,1,1,2,1832), -- Potion of Alacrity
(20363,1814,1,1,2,11570), -- Recipe: Leather
(20363,1864,1,1,2,43966), -- Stem
(20363,1869,1,1,2,21983), -- Iron Ore
(20364,1867,1,1,-1,303119), -- Animal Skin
(20364,1896,1,1,-1,96330), -- Necklace of Anguish Chain
(20364,2008,1,1,-1,8846), -- Cedar Staff Head
(20364,57,116,172,0,700000), -- Adena
(20364,255,1,1,1,249), -- Fox Claw Gloves
(20364,2371,1,1,1,527), -- Fist of Butcher
(20364,1793,1,1,2,3292), -- Recipe: Sword of Reflection
(20364,1865,1,1,2,44769), -- Varnish
(20364,1870,1,1,2,44769), -- Coal
(20365,1864,1,1,-1,249244), -- Stem
(20365,1866,1,1,-1,83081), -- Suede
(20365,1871,1,1,-1,124622), -- Charcoal
(20365,57,67,91,0,700000), -- Adena
(20365,22,1,1,1,3030), -- Leather Shirt
(20365,29,1,1,1,4844), -- Leather Pants
(20365,1666,1,1,2,8181), -- Recipe: Wooden Arrow
(20365,1866,1,1,2,16361), -- Suede
(20365,1871,1,1,2,24541), -- Charcoal
(20367,1831,1,1,-1,612488), -- Antidote
(20367,1864,1,1,-1,459366), -- Stem
(20367,1896,1,1,-1,97323), -- Necklace of Anguish Chain
(20367,57,106,184,0,700000), -- Adena
(20367,44,1,1,1,666), -- Leather Helmet
(20367,102,1,1,1,955), -- Round Shield
(20367,945,1,1,1,1973), -- Skeleton Buckler
(20367,1924,1,1,1,10943), -- Leather Helmet Design
(20367,735,1,1,2,2262), -- Potion of Alacrity
(20367,1864,1,1,2,54276), -- Stem
(20367,1869,1,1,2,27138), -- Iron Ore
(20367,1878,1,1,2,10856), -- Braided Hemp
(20367,5153,1,1,2,1086), -- Recipe: Soulshot (D) Compressed Package (100%)
(20368,1793,1,1,-1,14820), -- Recipe: Sword of Reflection
(20368,1833,1,1,-1,537455), -- Bandage
(20368,1873,1,1,-1,80618), -- Silver Nugget
(20368,57,106,150,0,700000), -- Adena
(20368,271,1,1,1,440), -- Hunting Bow
(20368,1793,1,1,2,2919), -- Recipe: Sword of Reflection
(20368,1866,1,1,2,26460), -- Suede
(20368,1871,1,1,2,39690), -- Charcoal
(20369,390,1,1,-1,2400), -- Cotton Shirt
(20369,1897,1,1,-1,58010), -- Necklace of Wisdom Chain
(20369,2143,1,1,-1,48728), -- Recipe: Synthetic Cokes
(20369,57,119,191,0,700000), -- Adena
(20369,1101,1,1,1,709), -- Tunic of Devotion
(20369,1104,1,1,1,1134), -- Stockings of Devotion
(20369,1868,1,1,2,95958), -- Thread
(20369,1873,1,1,2,19192), -- Silver Nugget
(20369,2175,1,1,2,39008), -- Recipe: Boots
(20370,1794,1,1,-1,15375), -- Recipe: Forest Bow
(20370,1864,1,1,-1,418191), -- Stem
(20370,1922,1,1,-1,53341), -- Leather Tunic Pattern
(20370,57,112,154,0,700000), -- Adena
(20370,23,1,1,1,1035), -- Wooden Breastplate
(20370,30,1,1,1,1658), -- Hard Leather Pants
(20370,2386,1,1,1,1658), -- Wooden Gaiters
(20370,1793,1,1,2,3028), -- Recipe: Sword of Reflection
(20370,1864,1,1,2,82352), -- Stem
(20370,1869,1,1,2,41176), -- Iron Ore
(20371,114,1,1,-1,11218), -- Earring of Strength
(20371,1869,1,1,-1,196871), -- Iron Ore
(20371,1896,1,1,-1,83420), -- Necklace of Anguish Chain
(20371,57,99,150,0,700000), -- Adena
(20371,429,1,1,1,731), -- Leather Tunic
(20371,464,1,1,1,1171), -- Leather Stockings
(20371,1922,1,1,1,7418), -- Leather Tunic Pattern
(20371,1923,1,1,1,11917), -- Leather Stocking Pattern
(20371,1803,1,1,2,32579), -- Recipe: Necklace of Wisdom
(20371,1866,1,1,2,25846), -- Suede
(20371,1871,1,1,2,38769), -- Charcoal
(20372,1864,1,1,-1,303261), -- Stem
(20372,1870,1,1,-1,151631), -- Coal
(20372,57,81,110,0,700000), -- Adena
(20372,3,1,1,1,717), -- Broadsword
(20372,2005,1,1,1,3200), -- Broadsword Blade
(20372,1814,1,1,2,15716), -- Recipe: Leather
(20372,1864,1,1,2,59719), -- Stem
(20372,1869,1,1,2,29860), -- Iron Ore
(20373,1793,1,1,-1,12352), -- Recipe: Sword of Reflection
(20373,1869,1,1,-1,167982), -- Iron Ore
(20373,1871,1,1,-1,167982), -- Charcoal
(20373,57,91,122,0,700000), -- Adena
(20373,255,1,1,1,184), -- Fox Claw Gloves
(20373,2371,1,1,1,390), -- Fist of Butcher
(20373,1799,1,1,2,49008), -- Recipe: Leather Gloves
(20373,1864,1,1,2,66160), -- Stem
(20373,1869,1,1,2,33080), -- Iron Ore
(20374,1871,1,1,-1,334740), -- Charcoal
(20374,1898,1,1,-1,34385), -- Blue Diamond Necklace Gem
(20374,2255,1,1,-1,8184), -- Recipe: Saber
(20374,57,152,273,0,700000), -- Adena
(20374,257,1,1,1,162), -- Viper\'s Fang
(20374,1868,1,1,2,98878), -- Thread
(20374,1873,1,1,2,19776), -- Silver Nugget
(20374,5158,1,1,2,1978), -- Recipe: Spiritshot (D) Compressed Package (100%)
(20374,5273,1,1,2,1978), -- Recipe: Greater Spiritshot (D) Compressed Package(100%)
(20375,1804,1,1,-1,9682), -- Recipe: Soulshot: D-Grade
(20375,2014,1,1,-1,2782), -- Iron Hammer Head
(20375,2257,1,1,-1,5918), -- Recipe: Trident
(20375,57,110,197,0,700000), -- Adena
(20375,16,1,1,1,117), -- Long Spear
(20375,1865,1,1,2,28600), -- Varnish
(20375,1870,1,1,2,28600), -- Coal
(20375,1879,1,1,2,4767), -- Cokes
(20375,5158,1,1,2,1144), -- Recipe: Spiritshot (D) Compressed Package (100%)
(20378,49,1,1,-1,15211), -- Gloves
(20378,1831,1,1,-1,537455), -- Antidote
(20378,1896,1,1,-1,85401), -- Necklace of Anguish Chain
(20378,57,106,150,0,700000), -- Adena
(20378,114,1,1,1,1357), -- Earring of Strength
(20378,115,1,1,1,1357), -- Earring of Wisdom
(20378,876,1,1,1,2036), -- Ring of Anguish
(20378,907,1,1,1,1018), -- Necklace of Anguish
(20378,1896,1,1,1,10091), -- Necklace of Anguish Chain
(20378,736,1,1,2,19845), -- Scroll of Escape
(20378,1866,1,1,2,26460), -- Suede
(20378,1871,1,1,2,39690), -- Charcoal
(20379,1792,1,1,-1,18424), -- Recipe: Short Spear
(20379,1871,1,1,-1,250564), -- Charcoal
(20379,1872,1,1,-1,334085), -- Animal Bone
(20379,57,128,189,0,700000), -- Adena
(20379,114,1,1,1,1687), -- Earring of Strength
(20379,115,1,1,1,1687), -- Earring of Wisdom
(20379,876,1,1,1,2531), -- Ring of Anguish
(20379,907,1,1,1,1266), -- Necklace of Anguish
(20379,1896,1,1,1,12545), -- Necklace of Anguish Chain
(20379,1794,1,1,2,3629), -- Recipe: Forest Bow
(20379,1867,1,1,2,65789), -- Animal Skin
(20379,1872,1,1,2,65789), -- Animal Bone
(20380,1866,1,1,-1,178047), -- Suede
(20380,1869,1,1,-1,267071), -- Iron Ore
(20380,1873,1,1,-1,106828), -- Silver Nugget
(20380,57,132,206,0,700000), -- Adena
(20380,176,1,1,1,116), -- Journeyman\'s Staff
(20380,2501,1,1,1,116), -- Bone Club
(20380,1866,1,1,2,35062), -- Suede
(20380,1871,1,1,2,52593), -- Charcoal
(20380,2174,1,1,2,22867), -- Recipe: Hard Leather Gaiters
(20381,1867,1,1,-1,198210), -- Animal Skin
(20381,1875,1,1,-1,9910), -- Stone of Purity
(20381,2006,1,1,-1,10618), -- Willow Staff Head
(20381,57,80,108,0,700000), -- Adena
(20381,99,1,1,1,1405), -- Apprentice\'s Spellbook
(20381,1865,1,1,2,29274), -- Varnish
(20381,1870,1,1,2,29274), -- Coal
(20381,2136,1,1,2,8611), -- Recipe: Cokes
(20382,1831,1,1,-1,447952), -- Antidote
(20382,1870,1,1,-1,167982), -- Coal
(20382,2008,1,1,-1,6536), -- Cedar Staff Head
(20382,57,91,122,0,700000), -- Adena
(20382,20,1,1,1,3570), -- Buckler
(20382,43,1,1,1,2494), -- Wooden Helmet
(20382,1803,1,1,2,27798), -- Recipe: Necklace of Wisdom
(20382,1866,1,1,2,22053), -- Suede
(20382,1871,1,1,2,33080), -- Charcoal
(20385,1060,1,1,-1,285245), -- Lesser Healing Potion
(20385,2005,1,1,-1,9169), -- Broadsword Blade
(20385,57,69,94,0,700000), -- Adena
(20385,14,1,1,1,607), -- Bow
(20385,2007,1,1,1,2709), -- Bow Shaft
(20385,1790,1,1,2,4673), -- Recipe: Dirk
(20385,1868,1,1,2,50555), -- Thread
(20385,1873,1,1,2,10111), -- Silver Nugget
(20386,1060,1,1,-1,404348), -- Lesser Healing Potion
(20386,1666,1,1,-1,60652), -- Recipe: Wooden Arrow
(20386,1796,1,1,-1,228876), -- Recipe: Leather Tunic
(20386,57,98,132,0,700000), -- Adena
(20386,3,1,1,1,860), -- Broadsword
(20386,2005,1,1,1,3840), -- Broadsword Blade
(20386,17,10,30,2,134369), -- Wooden Arrow
(20386,1666,1,1,2,8958), -- Recipe: Wooden Arrow
(20386,1864,1,1,2,53748), -- Stem
(20386,1869,1,1,2,26874), -- Iron Ore
(20387,1794,1,1,-1,15682), -- Recipe: Forest Bow
(20387,1833,1,1,-1,568739), -- Bandage
(20387,1896,1,1,-1,90372), -- Necklace of Anguish Chain
(20387,57,114,157,0,700000), -- Adena
(20387,66,1,1,1,156), -- Gladius
(20387,1333,1,1,1,156), -- Brandish
(20387,2010,1,1,1,1635), -- Brandish Blade
(20387,1794,1,1,2,3089), -- Recipe: Forest Bow
(20387,1864,1,1,2,83999), -- Stem
(20387,1869,1,1,2,42000), -- Iron Ore
(20388,1833,1,1,-1,537542), -- Bandage
(20388,1880,1,1,-1,20158), -- Steel
(20388,57,109,147,0,700000), -- Adena
(20388,37,1,1,1,2996), -- Leather Shoes
(20388,49,1,1,1,2996), -- Gloves
(20388,1921,1,1,1,25611), -- Leather Shoes Texture
(20388,735,1,1,2,2481), -- Potion of Alacrity
(20388,736,1,1,2,14886), -- Scroll of Escape
(20388,1864,1,1,2,59543), -- Stem
(20388,1869,1,1,2,29772), -- Iron Ore
(20389,734,1,1,-1,32995), -- Haste Potion
(20389,1872,1,1,-1,263962), -- Animal Bone
(20389,2011,1,1,-1,4516), -- Short Spear Edge
(20389,57,98,153,0,700000), -- Adena
(20389,44,1,1,1,574), -- Leather Helmet
(20389,102,1,1,1,823), -- Round Shield
(20389,945,1,1,1,1700), -- Skeleton Buckler
(20389,1924,1,1,1,9433), -- Leather Helmet Design
(20389,1867,1,1,2,38986), -- Animal Skin
(20389,1872,1,1,2,38986), -- Animal Bone
(20389,2175,1,1,2,23772), -- Recipe: Boots
(20389,5158,1,1,2,1170), -- Recipe: Spiritshot (D) Compressed Package (100%)
(20390,1873,1,1,-1,84419), -- Silver Nugget
(20390,1881,1,1,-1,28140), -- Coarse Bone Powder
(20390,1897,1,1,-1,50249), -- Necklace of Wisdom Chain
(20390,57,101,167,0,700000), -- Adena
(20390,2,1,1,1,46), -- Long Sword
(20390,120,1,1,1,46), -- Sword of Reflection
(20390,121,1,1,1,46), -- Sword of Watershadow
(20390,2012,1,1,1,650), -- Sword of Reflection Blade
(20390,734,1,1,2,4157), -- Haste Potion
(20390,1801,1,1,2,12563), -- Recipe: Piece Bone Gaiters
(20390,1868,1,1,2,49872), -- Thread
(20390,1873,1,1,2,9975), -- Silver Nugget
(20390,5158,1,1,2,998), -- Recipe: Spiritshot (D) Compressed Package (100%)
(20392,1798,1,1,-1,227072), -- Recipe: Leather Helmet
(20392,1831,1,1,-1,617635), -- Antidote
(20392,1833,1,1,-1,617635), -- Bandage
(20392,57,116,177,0,700000), -- Adena
(20392,23,1,1,1,1147), -- Wooden Breastplate
(20392,30,1,1,1,1836), -- Hard Leather Pants
(20392,2386,1,1,1,1836), -- Wooden Gaiters
(20392,736,1,1,2,17104), -- Scroll of Escape
(20392,1060,1,1,2,76017), -- Lesser Healing Potion
(20392,1864,1,1,2,68416), -- Stem
(20392,1869,1,1,2,34208), -- Iron Ore
(20393,1897,1,1,-1,56563), -- Necklace of Wisdom Chain
(20393,2252,1,1,-1,9736), -- Recipe: Iron Hammer
(20393,57,118,183,0,700000), -- Adena
(20393,217,1,1,1,103), -- Shining Knife
(20393,218,1,1,1,103), -- Throwing Knife
(20393,1867,1,1,2,62377), -- Animal Skin
(20393,1872,1,1,2,62377), -- Animal Bone
(20393,2252,1,1,2,1918), -- Recipe: Iron Hammer
(20400,1803,1,1,-1,175710), -- Recipe: Necklace of Wisdom
(20400,1921,1,1,-1,134900), -- Leather Shoes Texture
(20400,1923,1,1,-1,85695), -- Leather Stocking Pattern
(20400,57,112,154,0,700000), -- Adena
(20400,114,1,1,1,1408), -- Earring of Strength
(20400,115,1,1,1,1408), -- Earring of Wisdom
(20400,876,1,1,1,2112), -- Ring of Anguish
(20400,907,1,1,1,1056), -- Necklace of Anguish
(20400,1896,1,1,1,10469), -- Necklace of Anguish Chain
(20400,1798,1,1,2,40369), -- Recipe: Leather Helmet
(20400,1864,1,1,2,82352), -- Stem
(20400,1869,1,1,2,41176), -- Iron Ore
(20401,1866,1,1,-1,210080), -- Suede
(20401,1873,1,1,-1,126048), -- Silver Nugget
(20401,2151,1,1,-1,87777), -- Recipe: Necklace of Devotion
(20401,57,144,255,0,700000), -- Adena
(20401,87,1,1,1,39), -- Iron Hammer
(20401,155,1,1,1,39), -- Buzdygan
(20401,177,1,1,1,39), -- Mage Staff
(20401,2014,1,1,1,535), -- Iron Hammer Head
(20401,1866,1,1,2,31028), -- Suede
(20401,1871,1,1,2,46541), -- Charcoal
(20401,5153,1,1,2,1862), -- Recipe: Soulshot (D) Compressed Package (100%)
(20401,5158,1,1,2,1862), -- Recipe: Spiritshot (D) Compressed Package (100%)
(20402,1871,1,1,-1,339480), -- Charcoal
(20402,1880,1,1,-1,33948), -- Steel
(20402,2179,1,1,-1,162431), -- Recipe: Crafted Leather Gloves
(20402,57,151,278,0,700000), -- Adena
(20402,25,1,1,1,211), -- Piece Bone Breastplate
(20402,26,1,1,1,136), -- Bronze Breastplate
(20402,32,1,1,1,336), -- Piece Bone Gaiters
(20402,34,1,1,1,218), -- Bronze Gaiters
(20402,1926,1,1,1,3377), -- Piece Bone Breastplate Fragment
(20402,1928,1,1,1,4869), -- Piece Bone Gaiters Fragment
(20402,1866,1,1,2,33426), -- Suede
(20402,1871,1,1,2,50139), -- Charcoal
(20402,2256,1,1,2,1226), -- Recipe: Assassin Knife
(20402,5158,1,1,2,2006), -- Recipe: Spiritshot (D) Compressed Package (100%)
(20403,734,1,1,-1,39594), -- Haste Potion
(20403,1868,1,1,-1,475131), -- Thread
(20403,2012,1,1,-1,4949), -- Sword of Reflection Blade
(20403,57,118,183,0,700000), -- Adena
(20403,38,1,1,1,1383), -- Low Boots
(20403,50,1,1,1,1383), -- Leather Gloves
(20403,1925,1,1,1,30677), -- Leather Gloves Lining
(20403,735,1,1,2,2340), -- Potion of Alacrity
(20403,1867,1,1,2,37426), -- Animal Skin
(20403,1872,1,1,2,37426), -- Animal Bone
(20403,2253,1,1,2,1151), -- Recipe: Sword Breaker
(20403,5268,1,1,2,1123), -- Recipe: Greater Soulshot (D) Compressed Package (100%)
(20404,735,1,1,-1,16828), -- Potion of Alacrity
(20404,1897,1,1,-1,48079), -- Necklace of Wisdom Chain
(20404,2253,1,1,-1,8276), -- Recipe: Sword Breaker
(20404,57,100,156,0,700000), -- Adena
(20404,1101,1,1,1,588), -- Tunic of Devotion
(20404,1104,1,1,1,940), -- Stockings of Devotion
(20404,1866,1,1,2,19883), -- Suede
(20404,1871,1,1,2,29824), -- Charcoal
(20404,2254,1,1,2,1223), -- Recipe: Composition Bow
(20404,6035,1,1,2,2486), -- Magic Haste Potion
(20410,1792,1,1,-1,17371), -- Recipe: Short Spear
(20410,1868,1,1,-1,472491), -- Thread
(20410,2009,1,1,-1,8377), -- Dirk Blade
(20410,57,119,180,0,700000), -- Adena
(20410,9,1,1,1,172), -- Cedar Staff
(20410,154,1,1,1,172), -- Dwarven Mace
(20410,2008,1,1,1,1811), -- Cedar Staff Head
(20410,1793,1,1,2,3421), -- Recipe: Sword of Reflection
(20410,1867,1,1,2,62030), -- Animal Skin
(20410,1872,1,1,2,62030), -- Animal Bone
(20411,735,1,1,-1,21105), -- Potion of Alacrity
(20411,1897,1,1,-1,60299), -- Necklace of Wisdom Chain
(20411,2141,1,1,-1,50651), -- Recipe: Silver Mold
(20411,57,121,200,0,700000), -- Adena
(20411,217,1,1,1,110), -- Shining Knife
(20411,218,1,1,1,110), -- Throwing Knife
(20411,1817,1,1,2,5985), -- Recipe: Cord
(20411,1864,1,1,2,59847), -- Stem
(20411,1869,1,1,2,29924), -- Iron Ore
(20411,1878,1,1,2,11970), -- Braided Hemp
(20411,6037,1,1,2,59847), -- Waking Scroll
(20415,735,1,1,-1,18798), -- Potion of Alacrity
(20415,1865,1,1,-1,225572), -- Varnish
(20415,2144,1,1,-1,45114), -- Recipe: Compound Braid
(20415,57,110,177,0,700000), -- Adena
(20415,309,1,1,1,98), -- Tears of Eva
(20415,310,1,1,1,98), -- Relic of The Saints
(20415,1864,1,1,2,44421), -- Stem
(20415,1865,1,1,2,22211), -- Varnish
(20415,1866,1,1,2,14807), -- Suede
(20415,1868,1,1,2,44421), -- Thread
(20415,1873,1,1,2,8885), -- Silver Nugget
(20415,2253,1,1,2,911), -- Recipe: Sword Breaker
(20416,102,1,1,-1,6530), -- Round Shield
(20416,1924,1,1,-1,74887), -- Leather Helmet Design
(20416,2254,1,1,-1,9514), -- Recipe: Composition Bow
(20416,57,111,183,0,700000), -- Adena
(20416,1101,1,1,1,676), -- Tunic of Devotion
(20416,1104,1,1,1,1081), -- Stockings of Devotion
(20416,1866,1,1,2,22859), -- Suede
(20416,1871,1,1,2,34288), -- Charcoal
(20416,2139,1,1,2,6858), -- Recipe: Steel Mold
(20416,5268,1,1,2,1372), -- Recipe: Greater Soulshot (D) Compressed Package (100%)
(20418,1800,1,1,-1,78852), -- Recipe: Piece Bone Breastplate
(20418,1872,1,1,-1,334331), -- Animal Bone
(20418,1925,1,1,-1,164425), -- Leather Gloves Lining
(20418,57,120,198,0,700000), -- Adena
(20418,845,1,1,1,834), -- Cat\'s Eye Earring
(20418,877,1,1,1,1252), -- Ring of Wisdom
(20418,908,1,1,1,623), -- Necklace of Wisdom
(20418,1897,1,1,1,8818), -- Necklace of Wisdom Chain
(20418,1867,1,1,2,49379), -- Animal Skin
(20418,1872,1,1,2,49379), -- Animal Bone
(20418,1882,1,1,2,8230), -- Leather
(20418,2140,1,1,2,7407), -- Recipe: High Grade Suede
(20420,1804,1,1,-1,9682), -- Recipe: Soulshot: D-Grade
(20420,1866,1,1,-1,161368), -- Suede
(20420,1868,1,1,-1,484105), -- Thread
(20420,57,110,197,0,700000), -- Adena
(20420,1102,1,1,1,388), -- Tunic of Magic
(20420,1105,1,1,1,622), -- Stockings of Magic
(20420,1864,1,1,2,47666), -- Stem
(20420,1865,1,1,2,23833), -- Varnish
(20420,1866,1,1,2,15889), -- Suede
(20420,1868,1,1,2,47666), -- Thread
(20420,1873,1,1,2,9534), -- Silver Nugget
(20420,5163,1,1,2,954), -- Recipe: Blessed Spiritshot (D) Compressed Package (100%)
(20421,1866,1,1,-1,171004), -- Suede
(20421,1898,1,1,-1,26349), -- Blue Diamond Necklace Gem
(20421,1929,1,1,-1,33097), -- Hard Leather Gaiters Material
(20421,57,116,209,0,700000), -- Adena
(20421,273,1,1,1,63), -- Composition Bow
(20421,2016,1,1,1,888), -- Composition Bow Shaft
(20421,1867,1,1,2,33675), -- Animal Skin
(20421,1869,1,1,2,25256), -- Iron Ore
(20421,1870,1,1,2,25256), -- Coal
(20421,1871,1,1,2,25256), -- Charcoal
(20421,1872,1,1,2,33675), -- Animal Bone
(20421,5278,1,1,2,1011), -- Recipe: Greater Blessed Spiritshot (D) Compressed Package(100%)
(20422,1864,1,1,-1,497816), -- Stem
(20422,1869,1,1,-1,248908), -- Iron Ore
(20422,2013,1,1,-1,5372), -- Forest Bow Shaft
(20422,57,121,195,0,700000), -- Adena
(20422,176,1,1,1,108), -- Journeyman\'s Staff
(20422,2501,1,1,1,108), -- Bone Club
(20422,1864,1,1,2,73524), -- Stem
(20422,1869,1,1,2,36762), -- Iron Ore
(20422,2254,1,1,2,1507), -- Recipe: Composition Bow
(20422,5273,1,1,2,1471), -- Recipe: Greater Spiritshot (D) Compressed Package(100%)
(20423,1792,1,1,-1,14067), -- Recipe: Short Spear
(20423,1793,1,1,-1,14067), -- Recipe: Sword of Reflection
(20423,1921,1,1,-1,123424), -- Leather Shoes Texture
(20423,57,98,145,0,700000), -- Adena
(20423,271,1,1,1,418), -- Hunting Bow
(20423,1867,1,1,2,75346), -- Animal Skin
(20423,1872,1,1,2,75346), -- Animal Bone
(20424,1870,1,1,-1,227995), -- Coal
(20424,1880,1,1,-1,22799), -- Steel
(20424,2142,1,1,-1,45599), -- Recipe: Varnish of Purity
(20424,57,107,182,0,700000), -- Adena
(20424,2,1,1,1,50), -- Long Sword
(20424,120,1,1,1,50), -- Sword of Reflection
(20424,121,1,1,1,50), -- Sword of Watershadow
(20424,2012,1,1,1,702), -- Sword of Reflection Blade
(20424,1865,1,1,2,44898), -- Varnish
(20424,1870,1,1,2,44898), -- Coal
(20424,2253,1,1,2,1841), -- Recipe: Sword Breaker
(20425,1831,1,1,-1,473949), -- Antidote
(20425,1869,1,1,-1,177731), -- Iron Ore
(20425,57,95,131,0,700000), -- Adena
(20425,66,1,1,1,130), -- Gladius
(20425,1333,1,1,1,130), -- Brandish
(20425,2010,1,1,1,1363), -- Brandish Blade
(20425,1799,1,1,2,51851), -- Recipe: Leather Gloves
(20425,1866,1,1,2,23333), -- Suede
(20425,1871,1,1,2,35000), -- Charcoal
(20426,1796,1,1,-1,224389), -- Recipe: Leather Tunic
(20426,2005,1,1,-1,12742), -- Broadsword Blade
(20426,57,96,130,0,700000), -- Adena
(20426,113,1,1,1,8664), -- Mystic\'s Earring
(20426,875,1,1,1,13011), -- Ring of Knowledge
(20426,906,1,1,1,6506), -- Necklace of Knowledge
(20426,1060,1,1,2,58549), -- Lesser Healing Potion
(20426,1868,1,1,2,52694), -- Thread
(20426,1873,1,1,2,10539), -- Silver Nugget
(20426,2137,1,1,2,7750), -- Recipe: Steel
(20427,1060,1,1,-1,330350), -- Lesser Healing Potion
(20427,1666,1,1,-1,49552), -- Recipe: Wooden Arrow
(20427,1866,1,1,-1,99105), -- Suede
(20427,57,80,108,0,700000), -- Adena
(20427,254,1,1,1,1405), -- Iron Gloves
(20427,1864,1,1,2,58549), -- Stem
(20427,1869,1,1,2,29274), -- Iron Ore
(20427,2138,1,1,2,8611), -- Recipe: Coarse Bone Powder (100%)
(20428,1831,1,1,-1,594351), -- Antidote
(20428,1864,1,1,-1,445764), -- Stem
(20428,1896,1,1,-1,94441), -- Necklace of Anguish Chain
(20428,57,114,168,0,700000), -- Adena
(20428,114,1,1,1,1501), -- Earring of Strength
(20428,115,1,1,1,1501), -- Earring of Wisdom
(20428,876,1,1,1,2251), -- Ring of Anguish
(20428,907,1,1,1,1126), -- Necklace of Anguish
(20428,1896,1,1,1,11159), -- Necklace of Anguish Chain
(20428,1799,1,1,2,27868), -- Recipe: Leather Gloves
(20428,1833,1,1,2,50161), -- Bandage
(20428,1864,1,1,2,37621), -- Stem
(20428,1865,1,1,2,18811), -- Varnish
(20428,1866,1,1,2,12541), -- Suede
(20428,1868,1,1,2,37621), -- Thread
(20428,1873,1,1,2,7525), -- Silver Nugget
(20429,1792,1,1,-1,13657), -- Recipe: Short Spear
(20429,1921,1,1,-1,119829), -- Leather Shoes Texture
(20429,2009,1,1,-1,6586), -- Dirk Blade
(20429,57,95,140,0,700000), -- Adena
(20429,429,1,1,1,690), -- Leather Tunic
(20429,464,1,1,1,1104), -- Leather Stockings
(20429,1922,1,1,1,6999), -- Leather Tunic Pattern
(20429,1923,1,1,1,11243), -- Leather Stocking Pattern
(20429,1803,1,1,2,30736), -- Recipe: Necklace of Wisdom
(20429,1868,1,1,2,73152), -- Thread
(20429,1873,1,1,2,14631), -- Silver Nugget
(20432,1871,1,1,-1,15920), -- Charcoal
(20432,1873,1,1,-1,6368), -- Silver Nugget
(20432,57,8,12,0,700000), -- Adena
(20432,11,1,1,1,4286), -- Bone Dagger
(20432,17,10,30,2,11757), -- Wooden Arrow
(20432,1787,1,1,2,1881), -- Recipe: Willow Staff
(20432,1864,1,1,2,4703), -- Stem
(20432,1865,1,1,2,2352), -- Varnish
(20432,1866,1,1,2,1568), -- Suede
(20432,1868,1,1,2,4703), -- Thread
(20432,1873,1,1,2,941), -- Silver Nugget
(20433,1864,1,1,-1,430270), -- Stem
(20433,1865,1,1,-1,215135), -- Varnish
(20433,1921,1,1,-1,138797), -- Leather Shoes Texture
(20433,57,113,160,0,700000), -- Adena
(20433,429,1,1,1,799), -- Leather Tunic
(20433,464,1,1,1,1279), -- Leather Stockings
(20433,1922,1,1,1,8106), -- Leather Tunic Pattern
(20433,1923,1,1,1,13023), -- Leather Stocking Pattern
(20433,735,1,1,2,2648), -- Potion of Alacrity
(20433,1794,1,1,2,2337), -- Recipe: Forest Bow
(20433,1865,1,1,2,31774), -- Varnish
(20433,1870,1,1,2,31774), -- Coal
(20435,1793,1,1,-1,14332), -- Recipe: Sword of Reflection
(20435,1833,1,1,-1,519792), -- Bandage
(20435,1871,1,1,-1,194922), -- Charcoal
(20435,57,98,149,0,700000), -- Adena
(20435,216,1,1,1,213), -- Dirk
(20435,2009,1,1,1,2043), -- Dirk Blade
(20435,1794,1,1,2,2823), -- Recipe: Forest Bow
(20435,1867,1,1,2,51180), -- Animal Skin
(20435,1872,1,1,2,51180), -- Animal Bone
(20436,1869,1,1,-1,315120), -- Iron Ore
(20436,1898,1,1,-1,32370), -- Blue Diamond Necklace Gem
(20436,2016,1,1,-1,3693), -- Composition Bow Shaft
(20436,57,144,255,0,700000), -- Adena
(20436,16,1,1,1,153), -- Long Spear
(20436,1865,1,1,2,62055), -- Varnish
(20436,1870,1,1,2,62055), -- Coal
(20436,5158,1,1,2,2483), -- Recipe: Spiritshot (D) Compressed Package (100%)
(20437,1804,1,1,-1,11391), -- Recipe: Soulshot: D-Grade
(20437,2016,1,1,-1,3337), -- Composition Bow Shaft
(20437,2258,1,1,-1,6963), -- Recipe: Temptation of Abyss
(20437,57,130,231,0,700000), -- Adena
(20437,39,1,1,1,912), -- Boots
(20437,51,1,1,1,912), -- Bracer
(20437,1930,1,1,1,14379), -- Boot Lining
(20437,1866,1,1,2,28039), -- Suede
(20437,1871,1,1,2,42058), -- Charcoal
(20437,5268,1,1,2,1683), -- Recipe: Greater Soulshot (D) Compressed Package (100%)
(20437,5437,1,1,2,1029), -- Recipe: Heavy Sword(100%)
(20438,1865,1,1,-1,375763), -- Varnish
(20438,1869,1,1,-1,375763), -- Iron Ore
(20438,1899,1,1,-1,58713), -- Necklace of Devotion Chain
(20438,57,163,312,0,700000), -- Adena
(20438,291,1,1,1,52), -- Trident
(20438,2019,1,1,1,2268), -- Trident Edge
(20438,1875,1,1,2,2812), -- Stone of Purity
(20438,1879,1,1,2,7030), -- Cokes
(20438,2180,1,1,2,3172), -- Recipe: Scale Mail
(20438,5549,1,1,2,4218), -- Metallic Thread
(20438,6666,1,1,2,42178), -- Deluxe Chest Key - Grade 2
(20439,2015,1,1,-1,4059), -- Sword Breaker Edge
(20439,2151,1,1,-1,92709), -- Recipe: Necklace of Devotion
(20439,2255,1,1,-1,8137), -- Recipe: Saber
(20439,57,148,273,0,700000), -- Adena
(20439,25,1,1,1,207), -- Piece Bone Breastplate
(20439,26,1,1,1,134), -- Bronze Breastplate
(20439,32,1,1,1,330), -- Piece Bone Gaiters
(20439,34,1,1,1,214), -- Bronze Gaiters
(20439,1926,1,1,1,3311), -- Piece Bone Breastplate Fragment
(20439,1928,1,1,1,4774), -- Piece Bone Gaiters Fragment
(20439,1868,1,1,2,131082), -- Thread
(20439,1873,1,1,2,26217), -- Silver Nugget
(20439,2257,1,1,2,1603), -- Recipe: Trident
(20442,1786,1,1,-1,44845), -- Recipe: Broad Sword
(20442,1864,1,1,-1,112112), -- Stem
(20442,5549,1,1,-1,5606), -- Metallic Thread
(20442,57,30,42,0,700000), -- Adena
(20442,4,1,1,1,7546), -- Club
(20442,7,1,1,1,7546), -- Apprentice\'s Rod
(20442,17,10,30,2,72442), -- Wooden Arrow
(20442,1787,1,1,2,11591), -- Recipe: Willow Staff
(20442,1868,1,1,2,28977), -- Thread
(20442,1873,1,1,2,5796), -- Silver Nugget
(20446,1869,1,1,-1,77741), -- Iron Ore
(20446,1870,1,1,-1,77741), -- Coal
(20446,2007,1,1,-1,5553), -- Bow Shaft
(20446,57,41,58,0,700000), -- Adena
(20446,22,1,1,1,1890), -- Leather Shirt
(20446,29,1,1,1,3022), -- Leather Pants
(20446,1791,1,1,2,2830), -- Recipe: Brandish
(20446,1864,1,1,2,30618), -- Stem
(20446,1869,1,1,2,15309); -- Iron Ore

INSERT INTO `droplist` VALUES 
(20447,1060,1,1,-1,285245), -- Lesser Healing Potion
(20447,1797,1,1,-1,259314), -- Recipe: Leather Stockings
(20447,2138,1,1,-1,37753), -- Recipe: Coarse Bone Powder (100%)
(20447,57,69,94,0,700000), -- Adena
(20447,14,1,1,1,607), -- Bow
(20447,2007,1,1,1,2709), -- Bow Shaft
(20447,1791,1,1,2,4673), -- Recipe: Brandish
(20447,1868,1,1,2,50555), -- Thread
(20447,1873,1,1,2,10111), -- Silver Nugget
(20448,1666,1,1,-1,32439), -- Recipe: Wooden Arrow
(20448,1789,1,1,-1,17988), -- Recipe: Cedar Staff
(20448,2006,1,1,-1,6951), -- Willow Staff Head
(20448,57,51,72,0,700000), -- Adena
(20448,3,1,1,1,460), -- Broadsword
(20448,2005,1,1,1,2054), -- Broadsword Blade
(20448,1866,1,1,2,19164), -- Suede
(20448,1871,1,1,2,28746), -- Charcoal
(20449,115,1,1,-1,13164), -- Earring of Wisdom
(20449,1873,1,1,-1,92414), -- Silver Nugget
(20449,1896,1,1,-1,97896), -- Necklace of Anguish Chain
(20449,57,116,177,0,700000), -- Adena
(20449,429,1,1,1,858), -- Leather Tunic
(20449,464,1,1,1,1374), -- Leather Stockings
(20449,1922,1,1,1,8705), -- Leather Tunic Pattern
(20449,1923,1,1,1,13985), -- Leather Stocking Pattern
(20449,1798,1,1,2,44605), -- Recipe: Leather Helmet
(20449,1868,1,1,2,90993), -- Thread
(20449,1873,1,1,2,18199), -- Silver Nugget
(20450,1666,1,1,-1,41345), -- Recipe: Wooden Arrow
(20450,1870,1,1,-1,124035), -- Coal
(20450,57,67,90,0,700000), -- Adena
(20450,5,1,1,1,294), -- Mace
(20450,8,1,1,1,294), -- Willow Staff
(20450,152,1,1,1,455), -- Heavy Chisel
(20450,2006,1,1,1,1309), -- Willow Staff Head
(20450,1864,1,1,2,48851), -- Stem
(20450,1869,1,1,2,24426), -- Iron Ore
(20450,2135,1,1,2,7184), -- Recipe: Braided Hemp
(20455,1794,1,1,-1,13930), -- Recipe: Forest Bow
(20455,1869,1,1,-1,189449), -- Iron Ore
(20455,1896,1,1,-1,80275), -- Necklace of Anguish Chain
(20455,57,97,143,0,700000), -- Adena
(20455,20,1,1,1,4026), -- Buckler
(20455,43,1,1,1,2813), -- Wooden Helmet
(20455,736,1,1,2,18654), -- Scroll of Escape
(20455,1868,1,1,2,74614), -- Thread
(20455,1873,1,1,2,14923), -- Silver Nugget
(20456,1788,1,1,-1,30885), -- Recipe: Bow 
(20456,1868,1,1,-1,77212), -- Thread
(20456,1872,1,1,-1,51475), -- Animal Bone
(20456,57,19,29,0,700000), -- Adena
(20456,308,1,1,1,10394), -- Buffalo\'s Horn
(20456,17,10,30,2,49891), -- Wooden Arrow
(20456,1788,1,1,2,7983), -- Recipe: Bow 
(20456,1868,1,1,2,19957), -- Thread
(20456,1873,1,1,2,3992), -- Silver Nugget
(20457,1864,1,1,-1,587232), -- Stem
(20457,1866,1,1,-1,195744), -- Suede
(20457,2013,1,1,-1,6337), -- Forest Bow Shaft
(20457,57,138,234,0,700000), -- Adena
(20457,15,1,1,1,128), -- Short Spear
(20457,2011,1,1,1,1979), -- Short Spear Edge
(20457,1864,1,1,2,69384), -- Stem
(20457,1869,1,1,2,34692), -- Iron Ore
(20457,1880,1,1,2,3470), -- Steel
(20457,2254,1,1,2,1422), -- Recipe: Composition Bow
(20457,5273,1,1,2,1388), -- Recipe: Greater Spiritshot (D) Compressed Package(100%)
(20458,1898,1,1,-1,35546), -- Blue Diamond Necklace Gem
(20458,2176,1,1,-1,165568), -- Recipe: Leather Boots
(20458,2256,1,1,-1,8461), -- Recipe: Assassin Knife
(20458,57,157,282,0,700000), -- Adena
(20458,846,1,1,1,639), -- Coral Earring
(20458,878,1,1,1,956), -- Blue Coral Ring
(20458,909,1,1,1,480), -- Blue Diamond Necklace
(20458,1898,1,1,1,5250), -- Blue Diamond Necklace Gem
(20458,1804,1,1,2,1169), -- Recipe: Soulshot: D-Grade
(20458,1864,1,1,2,58409), -- Stem
(20458,1869,1,1,2,29205), -- Iron Ore
(20458,1880,1,1,2,2921), -- Steel
(20458,5268,1,1,2,1169), -- Recipe: Greater Soulshot (D) Compressed Package (100%)
(20458,5437,1,1,2,715), -- Recipe: Heavy Sword(100%)
(20458,6666,1,1,2,29205), -- Deluxe Chest Key - Grade 2
(20460,1792,1,1,-1,17371), -- Recipe: Short Spear
(20460,1833,1,1,-1,629988), -- Bandage
(20460,1866,1,1,-1,157497), -- Suede
(20460,57,119,180,0,700000), -- Adena
(20460,66,1,1,1,172), -- Gladius
(20460,1333,1,1,1,172), -- Brandish
(20460,2010,1,1,1,1811), -- Brandish Blade
(20460,1799,1,1,2,68922), -- Recipe: Leather Gloves
(20460,1867,1,1,2,62030), -- Animal Skin
(20460,1872,1,1,2,62030), -- Animal Bone
(20461,1803,1,1,-1,165438), -- Recipe: Necklace of Wisdom
(20461,1896,1,1,-1,83420), -- Necklace of Anguish Chain
(20461,2010,1,1,-1,7660), -- Brandish Blade
(20461,57,99,150,0,700000), -- Adena
(20461,66,1,1,1,144), -- Gladius
(20461,1333,1,1,1,144), -- Brandish
(20461,2010,1,1,1,1509), -- Brandish Blade
(20461,1803,1,1,2,32579), -- Recipe: Necklace of Wisdom
(20461,1867,1,1,2,51692), -- Animal Skin
(20461,1872,1,1,2,51692), -- Animal Bone
(20462,1800,1,1,-1,65776), -- Recipe: Piece Bone Breastplate
(20462,1865,1,1,-1,209166), -- Varnish
(20462,1872,1,1,-1,278888), -- Animal Bone
(20462,57,102,164,0,700000), -- Adena
(20462,256,1,1,1,182), -- Cestus
(20462,1800,1,1,2,12953), -- Recipe: Piece Bone Breastplate
(20462,1867,1,1,2,54920), -- Animal Skin
(20462,1872,1,1,2,54920), -- Animal Bone
(20463,1799,1,1,-1,273567), -- Recipe: Leather Gloves
(20463,1921,1,1,-1,119134), -- Leather Shoes Texture
(20463,2010,1,1,-1,7185), -- Brandish Blade
(20463,57,97,137,0,700000), -- Adena
(20463,271,1,1,1,403), -- Hunting Bow
(20463,1798,1,1,2,35651), -- Recipe: Leather Helmet
(20463,1864,1,1,2,72727), -- Stem
(20463,1869,1,1,2,36364), -- Iron Ore
(20464,464,1,1,-1,7152), -- Leather Stockings
(20464,1870,1,1,-1,177731), -- Coal
(20464,1874,1,1,-1,11849), -- Oriharukon Ore
(20464,57,95,131,0,700000), -- Adena
(20464,9,1,1,1,130), -- Cedar Staff
(20464,154,1,1,1,130), -- Dwarven Mace
(20464,2008,1,1,1,1363), -- Cedar Staff Head
(20464,1803,1,1,2,29412), -- Recipe: Necklace of Wisdom
(20464,1865,1,1,2,35000), -- Varnish
(20464,1870,1,1,2,35000), -- Coal
(20466,734,1,1,-1,41833), -- Haste Potion
(20466,1868,1,1,-1,501999), -- Thread
(20466,1897,1,1,-1,59762), -- Necklace of Wisdom Chain
(20466,57,122,197,0,700000), -- Adena
(20466,24,1,1,1,366), -- Bone Breastplate
(20466,31,1,1,1,584), -- Bone Gaiters
(20466,390,1,1,1,366), -- Cotton Shirt
(20466,412,1,1,1,584), -- Cotton Pants
(20466,1801,1,1,2,18676), -- Recipe: Piece Bone Gaiters
(20466,1867,1,1,2,49428), -- Animal Skin
(20466,1872,1,1,2,49428), -- Animal Bone
(20466,5158,1,1,2,1483), -- Recipe: Spiritshot (D) Compressed Package (100%)
(20468,1790,1,1,-1,14370), -- Recipe: Dirk
(20468,1814,1,1,-1,40916), -- Recipe: Leather
(20468,2005,1,1,-1,5553), -- Broadsword Blade
(20468,57,41,58,0,700000), -- Adena
(20468,99,1,1,1,735), -- Apprentice\'s Spellbook
(20468,1795,1,1,2,57770), -- Recipe:Leather Shoes
(20468,1864,1,1,2,30618), -- Stem
(20468,1869,1,1,2,15309), -- Iron Ore
(20469,1666,1,1,-1,42787), -- Recipe: Wooden Arrow
(20469,1864,1,1,-1,256721), -- Stem
(20469,2007,1,1,-1,9169), -- Bow Shaft
(20469,57,69,94,0,700000), -- Adena
(20469,14,1,1,1,607), -- Bow
(20469,2007,1,1,1,2709), -- Bow Shaft
(20469,1795,1,1,2,71539), -- Recipe:Leather Shoes
(20469,1833,1,1,2,50554), -- Bandage
(20469,1868,1,1,2,37916), -- Thread
(20469,1873,1,1,2,7584), -- Silver Nugget
(20470,1060,1,1,-1,216259), -- Lesser Healing Potion
(20470,1791,1,1,-1,17988), -- Recipe: Brandish
(20470,2006,1,1,-1,6951), -- Willow Staff Head
(20470,57,51,72,0,700000), -- Adena
(20470,19,1,1,1,9012), -- Small Shield
(20470,42,1,1,1,6311), -- Leather Cap
(20470,735,1,1,2,1198), -- Potion of Alacrity
(20470,1864,1,1,2,28746), -- Stem
(20470,1869,1,1,2,14373), -- Iron Ore
(20470,2135,1,1,2,4228), -- Recipe: Braided Hemp
(20471,428,1,1,-1,14976), -- Feriotic Tunic
(20471,1797,1,1,-1,367589), -- Recipe: Leather Stockings
(20471,1869,1,1,-1,181957), -- Iron Ore
(20471,57,98,132,0,700000), -- Adena
(20471,3,1,1,1,860), -- Broadsword
(20471,2005,1,1,1,3840), -- Broadsword Blade
(20471,1666,1,1,2,11944), -- Recipe: Wooden Arrow
(20471,1864,1,1,2,71663), -- Stem
(20471,1869,1,1,2,35832), -- Iron Ore
(20472,1864,1,1,-1,426554), -- Stem
(20472,1867,1,1,-1,284370), -- Animal Skin
(20472,1922,1,1,-1,54407), -- Leather Tunic Pattern
(20472,57,114,157,0,700000), -- Adena
(20472,66,1,1,1,156), -- Gladius
(20472,1333,1,1,1,156), -- Brandish
(20472,2010,1,1,1,1635), -- Brandish Blade
(20472,736,1,1,2,21000), -- Scroll of Escape
(20472,1864,1,1,2,83999), -- Stem
(20472,1869,1,1,2,42000), -- Iron Ore
(20473,23,1,1,-1,5065), -- Wooden Breastplate
(20473,1831,1,1,-1,537542), -- Antidote
(20473,1896,1,1,-1,85415), -- Necklace of Anguish Chain
(20473,57,109,147,0,700000), -- Adena
(20473,9,1,1,1,147), -- Cedar Staff
(20473,154,1,1,1,147), -- Dwarven Mace
(20473,2008,1,1,1,1545), -- Cedar Staff Head
(20473,1792,1,1,2,2919), -- Recipe: Short Spear
(20473,1864,1,1,2,79391), -- Stem
(20473,1869,1,1,2,39696), -- Iron Ore
(20474,1792,1,1,-1,17030), -- Recipe: Short Spear
(20474,1799,1,1,-1,343131), -- Recipe: Leather Gloves
(20474,1866,1,1,-1,154409), -- Suede
(20474,57,116,177,0,700000), -- Adena
(20474,216,1,1,1,253), -- Dirk
(20474,2009,1,1,1,2427), -- Dirk Blade
(20474,736,1,1,2,11403), -- Scroll of Escape
(20474,1867,1,1,2,30407), -- Animal Skin
(20474,1869,1,1,2,22806), -- Iron Ore
(20474,1870,1,1,2,22806), -- Coal
(20474,1871,1,1,2,22806), -- Charcoal
(20474,1872,1,1,2,30407), -- Animal Bone
(20475,426,1,1,-1,52525), -- Tunic
(20475,1786,1,1,-1,30885), -- Recipe: Broad Sword
(20475,1873,1,1,-1,15442), -- Silver Nugget
(20475,57,19,29,0,700000), -- Adena
(20475,253,1,1,1,10394), -- Spiked Gloves
(20475,1786,1,1,2,10644), -- Recipe: Broad Sword
(20475,1868,1,1,2,26609), -- Thread
(20475,1873,1,1,2,5322), -- Silver Nugget
(20476,945,1,1,-1,13812), -- Skeleton Buckler
(20476,1866,1,1,-1,158377), -- Suede
(20476,5549,1,1,-1,23757), -- Metallic Thread
(20476,57,118,183,0,700000), -- Adena
(20476,2,1,1,1,52), -- Long Sword
(20476,120,1,1,1,52), -- Sword of Reflection
(20476,121,1,1,1,52), -- Sword of Watershadow
(20476,2012,1,1,1,732), -- Sword of Reflection Blade
(20476,1800,1,1,2,11034), -- Recipe: Piece Bone Breastplate
(20476,1868,1,1,2,70174), -- Thread
(20476,1873,1,1,2,14035), -- Silver Nugget
(20476,5273,1,1,2,1404), -- Recipe: Greater Spiritshot (D) Compressed Package(100%)
(20477,906,1,1,-1,14254), -- Necklace of Knowledge
(20477,1060,1,1,-1,171046), -- Lesser Healing Potion
(20477,1872,1,1,-1,102628), -- Animal Bone
(20477,57,41,58,0,700000), -- Adena
(20477,12,1,1,1,364), -- Knife
(20477,215,1,1,1,364), -- Doom Dagger
(20477,1796,1,1,2,14300), -- Recipe: Leather Tunic
(20477,1833,1,1,2,30315), -- Bandage
(20477,1866,1,1,2,7579), -- Suede
(20477,1871,1,1,2,11369), -- Charcoal
(20478,735,1,1,-1,22557), -- Potion of Alacrity
(20478,1801,1,1,-1,136366), -- Recipe: Piece Bone Gaiters
(20478,1897,1,1,-1,64449), -- Necklace of Wisdom Chain
(20478,57,132,212,0,700000), -- Adena
(20478,217,1,1,1,118), -- Shining Knife
(20478,218,1,1,1,118), -- Throwing Knife
(20478,735,1,1,2,2221), -- Potion of Alacrity
(20478,1817,1,1,2,5331), -- Recipe: Cord
(20478,1831,1,1,2,71073), -- Antidote
(20478,1864,1,1,2,53305), -- Stem
(20478,1869,1,1,2,26653), -- Iron Ore
(20478,6037,1,1,2,53305), -- Waking Scroll
(20479,1792,1,1,-1,17199), -- Recipe: Short Spear
(20479,1793,1,1,-1,17199), -- Recipe: Sword of Reflection
(20479,1922,1,1,-1,59670), -- Leather Tunic Pattern
(20479,57,118,179,0,700000), -- Adena
(20479,9,1,1,1,171), -- Cedar Staff
(20479,154,1,1,1,171), -- Dwarven Mace
(20479,2008,1,1,1,1793), -- Cedar Staff Head
(20479,1792,1,1,2,2541), -- Recipe: Short Spear
(20479,1833,1,1,2,92124), -- Bandage
(20479,1867,1,1,2,46062), -- Animal Skin
(20479,1872,1,1,2,46062), -- Animal Bone
(20480,1864,1,1,-1,356778), -- Stem
(20480,2005,1,1,-1,12742), -- Broadsword Blade
(20480,2007,1,1,-1,12742), -- Bow Shaft
(20480,57,96,130,0,700000), -- Adena
(20480,22,1,1,1,4337), -- Leather Shirt
(20480,29,1,1,1,6934), -- Leather Pants
(20480,1789,1,1,2,6494), -- Recipe: Cedar Staff
(20480,1864,1,1,2,70258), -- Stem
(20480,1869,1,1,2,35129), -- Iron Ore
(20481,1786,1,1,-1,12736), -- Recipe: Broad Sword
(20481,1788,1,1,-1,12736), -- Recipe: Bow 
(20481,1868,1,1,-1,31839), -- Thread
(20481,57,8,12,0,700000), -- Adena
(20481,426,1,1,1,11197), -- Tunic
(20481,462,1,1,1,17890), -- Stockings
(20481,17,10,30,2,20574), -- Wooden Arrow
(20481,1786,1,1,2,3292), -- Recipe: Broad Sword
(20481,1868,1,1,2,8230), -- Thread
(20481,1873,1,1,2,1646), -- Silver Nugget
(20483,1833,1,1,-1,654568), -- Bandage
(20483,1868,1,1,-1,490926), -- Thread
(20483,57,120,192,0,700000), -- Adena
(20483,845,1,1,1,816), -- Cat\'s Eye Earring
(20483,877,1,1,1,1225), -- Ring of Wisdom
(20483,908,1,1,1,610), -- Necklace of Wisdom
(20483,1897,1,1,1,8632), -- Necklace of Wisdom Chain
(20483,1864,1,1,2,41433), -- Stem
(20483,1865,1,1,2,20716), -- Varnish
(20483,1866,1,1,2,13811), -- Suede
(20483,1868,1,1,2,41433), -- Thread
(20483,1873,1,1,2,8287), -- Silver Nugget
(20483,2139,1,1,2,4144), -- Recipe: Steel Mold
(20483,5268,1,1,2,829), -- Recipe: Greater Soulshot (D) Compressed Package (100%)
(20487,1060,1,1,-1,439936), -- Lesser Healing Potion
(20487,1897,1,1,-1,47136), -- Necklace of Wisdom Chain
(20487,2136,1,1,-1,58227), -- Recipe: Cokes
(20487,57,98,153,0,700000), -- Adena
(20487,217,1,1,1,86), -- Shining Knife
(20487,218,1,1,1,86), -- Throwing Knife
(20487,1800,1,1,2,12260), -- Recipe: Piece Bone Breastplate
(20487,1865,1,1,2,38986), -- Varnish
(20487,1870,1,1,2,38986), -- Coal
(20488,412,1,1,-1,3229), -- Cotton Pants
(20488,734,1,1,-1,34178), -- Haste Potion
(20488,1800,1,1,-1,64486), -- Recipe: Piece Bone Breastplate
(20488,57,100,161,0,700000), -- Adena
(20488,256,1,1,1,178), -- Cestus
(20488,1864,1,1,2,80765), -- Stem
(20488,1869,1,1,2,40383), -- Iron Ore
(20488,2140,1,1,2,8077), -- Recipe: High Grade Suede
(20489,1060,1,1,-1,433160), -- Lesser Healing Potion
(20489,1872,1,1,-1,259896), -- Animal Bone
(20489,1896,1,1,-1,82594), -- Necklace of Anguish Chain
(20489,57,98,149,0,700000), -- Adena
(20489,429,1,1,1,724), -- Leather Tunic
(20489,464,1,1,1,1159), -- Leather Stockings
(20489,1922,1,1,1,7345), -- Leather Tunic Pattern
(20489,1923,1,1,1,11799), -- Leather Stocking Pattern
(20489,1793,1,1,2,2823), -- Recipe: Sword of Reflection
(20489,1868,1,1,2,76770), -- Thread
(20489,1873,1,1,2,15354), -- Silver Nugget
(20491,876,1,1,-1,16827), -- Ring of Anguish
(20491,1794,1,1,-1,14476), -- Recipe: Forest Bow
(20491,1803,1,1,-1,165438), -- Recipe: Necklace of Wisdom
(20491,57,99,150,0,700000), -- Adena
(20491,37,1,1,1,2926), -- Leather Shoes
(20491,49,1,1,1,2926), -- Gloves
(20491,1921,1,1,1,25013), -- Leather Shoes Texture
(20491,1794,1,1,2,2851), -- Recipe: Forest Bow
(20491,1866,1,1,2,25846), -- Suede
(20491,1871,1,1,2,38769), -- Charcoal
(20492,25,1,1,-1,1492), -- Piece Bone Breastplate
(20492,1865,1,1,-1,237307), -- Varnish
(20492,1879,1,1,-1,39551), -- Cokes
(20492,57,108,193,0,700000), -- Adena
(20492,27,1,1,1,190), -- Hard Leather Shirt
(20492,33,1,1,1,305), -- Hard Leather Gaiters
(20492,1927,1,1,1,2796), -- Hard Leather Shirt Pattern
(20492,1929,1,1,1,4523), -- Hard Leather Gaiters Material
(20492,1865,1,1,2,28039), -- Varnish
(20492,1870,1,1,2,28039), -- Coal
(20492,1879,1,1,2,4674), -- Cokes
(20492,5278,1,1,2,1122), -- Recipe: Greater Blessed Spiritshot (D) Compressed Package(100%)
(20492,5437,1,1,2,686), -- Recipe: Heavy Sword(100%)
(20494,1804,1,1,-1,24762), -- Recipe: Soulshot: D-Grade
(20494,1881,1,1,-1,82540), -- Coarse Bone Powder
(20494,2179,1,1,-1,296197), -- Recipe: Crafted Leather Gloves
(20494,57,275,507,0,700000), -- Adena
(20494,257,1,1,1,300), -- Viper\'s Fang
(20494,735,1,1,2,6096), -- Potion of Alacrity
(20494,1866,1,1,2,48763), -- Suede
(20494,1871,1,1,2,73144), -- Charcoal
(20494,2258,1,1,2,1789), -- Recipe: Temptation of Abyss
(20494,5268,1,1,2,2926), -- Recipe: Greater Soulshot (D) Compressed Package (100%)
(20495,1900,1,1,-1,102868), -- Enchanted Necklace Chain
(20495,1936,1,1,-1,76940), -- White Tunic Pattern
(20495,2267,1,1,-1,9723), -- Recipe: Gastraphetes
(20495,57,397,793,0,700000), -- Adena
(20495,69,1,1,1,32), -- Bastard Sword
(20495,125,1,1,1,32), -- Spinebone Sword
(20495,126,1,1,1,32), -- Artisan\'s Sword
(20495,128,1,1,1,32), -- Knight\'s Sword
(20495,2021,1,1,1,1298), -- Spinebone Sword Blade
(20495,955,1,1,2,229), -- Scroll: Enchant Weapon (Grade D)
(20495,1875,1,1,2,3806), -- Stone of Purity
(20495,1879,1,1,2,9515), -- Cokes
(20495,1885,1,1,2,4758), -- High Grade Suede
(20495,2274,1,1,2,408), -- Recipe: Skull Breaker
(20495,2975,1,1,2,5098), -- Recipe: Brigandine Helmet
(20495,5549,1,1,2,5709), -- Metallic Thread
(20495,5550,1,1,2,762), -- Durable Metal Plate
(20495,6667,1,1,2,35680), -- Deluxe Chest Key - Grade 3
(20496,465,1,1,-1,3807), -- Cursed Stockings
(20496,1885,1,1,-1,62016), -- High Grade Suede
(20496,2152,1,1,-1,131020), -- Recipe: Enchanted Necklace
(20496,57,321,619,0,700000), -- Adena
(20496,274,1,1,1,204), -- Strengthened Bow
(20496,1876,1,1,2,11934), -- Mithril Ore
(20496,1877,1,1,2,2387), -- Adamantite Nugget
(20496,1880,1,1,2,5967), -- Steel
(20496,1881,1,1,2,7956), -- Coarse Bone Powder
(20496,1882,1,1,2,13260), -- Leather
(20496,2260,1,1,2,927), -- Recipe: Mace of Judgment
(20496,6666,1,1,2,59667), -- Deluxe Chest Key - Grade 2
(20497,1899,1,1,-1,119855), -- Necklace of Devotion Chain
(20497,2018,1,1,-1,10194), -- Assassin Knife Edge
(20497,2259,1,1,-1,11911), -- Recipe: Spinebone Sword
(20497,57,329,644,0,700000), -- Adena
(20497,391,1,1,1,688), -- Puma Skin Shirt
(20497,413,1,1,1,1102), -- Puma Skin Gaiters
(20497,1874,1,1,2,4784), -- Oriharukon Ore
(20497,1878,1,1,2,28701), -- Braided Hemp
(20497,1884,1,1,2,44154), -- Cord
(20497,1889,1,1,2,4784), -- Compound Braid
(20497,2261,1,1,2,1115), -- Recipe: Conjuror\'s Staff
(20497,5220,1,1,2,2871), -- Metal Hardener
(20498,1885,1,1,-1,59620), -- High Grade Suede
(20498,2262,1,1,-1,11109), -- Recipe: Elven Bow
(20498,3953,1,1,-1,28617), -- Recipe: Blessed Spiritshot D
(20498,57,309,595,0,700000), -- Adena
(20498,45,1,1,1,856), -- Bone Helmet
(20498,626,1,1,1,1223), -- Bronze Shield
(20498,1932,1,1,1,21245), -- Bone Helmet Design
(20498,1875,1,1,2,4462), -- Stone of Purity
(20498,1879,1,1,2,11154), -- Cokes
(20498,1885,1,1,2,5577), -- High Grade Suede
(20498,2261,1,1,2,1040), -- Recipe: Conjuror\'s Staff
(20498,5549,1,1,2,6693), -- Metallic Thread
(20498,5550,1,1,2,893), -- Durable Metal Plate
(20499,1870,1,1,-1,685215), -- Coal
(20499,1880,1,1,-1,68521), -- Steel
(20499,2017,1,1,-1,9106), -- Saber Blade
(20499,57,298,568,0,700000), -- Adena
(20499,40,1,1,1,921), -- Leather Boots
(20499,604,1,1,1,921), -- Crafted Leather Gloves
(20499,1931,1,1,1,12568), -- Leather Boot Lining
(20499,1934,1,1,1,12568), -- Crafted Leather Gloves Lining
(20499,1876,1,1,2,12819), -- Mithril Ore
(20499,1877,1,1,2,2564), -- Adamantite Nugget
(20499,1880,1,1,2,6410), -- Steel
(20499,1881,1,1,2,8546), -- Coarse Bone Powder
(20499,1882,1,1,2,14244), -- Leather
(20499,2182,1,1,2,7695), -- Recipe: Scale Gaiters
(20500,1867,1,1,-1,867354), -- Animal Skin
(20500,1931,1,1,-1,85035), -- Leather Boot Lining
(20500,1932,1,1,-1,103256), -- Bone Helmet Design
(20500,57,286,537,0,700000), -- Adena
(20500,847,1,1,1,679), -- Red Crescent Earring
(20500,890,1,1,1,1015), -- Ring of Devotion
(20500,910,1,1,1,509), -- Necklace of Devotion
(20500,1899,1,1,1,14262), -- Necklace of Devotion Chain
(20500,1874,1,1,2,6085), -- Oriharukon Ore
(20500,1878,1,1,2,36509), -- Braided Hemp
(20500,2262,1,1,2,1418), -- Recipe: Elven Bow
(20500,5220,1,1,2,3651), -- Metal Hardener
(20501,1870,1,1,-1,787074), -- Coal
(20501,1933,1,1,-1,92597), -- Dark Stocking Fabric
(20501,2153,1,1,-1,122407), -- Recipe: Tiger\'s Eye Earring
(20501,57,334,661,0,700000), -- Adena
(20501,433,1,1,1,108), -- Elven Tunic
(20501,434,1,1,1,108), -- White Tunic
(20501,435,1,1,1,108), -- Mystic\'s Tunic
(20501,466,1,1,1,173), -- Elven Stockings
(20501,467,1,1,1,173), -- Dark Stockings
(20501,468,1,1,1,173), -- Mystic\'s Stockings
(20501,1933,1,1,1,6326), -- Dark Stocking Fabric
(20501,1936,1,1,1,4400), -- White Tunic Pattern
(20501,1875,1,1,2,4097), -- Stone of Purity
(20501,1879,1,1,2,10241), -- Cokes
(20501,1885,1,1,2,5121), -- High Grade Suede
(20501,2264,1,1,2,636), -- Recipe: Two-handed Sword
(20501,2274,1,1,2,439), -- Recipe: Skull Breaker
(20501,5549,1,1,2,6145), -- Metallic Thread
(20501,5550,1,1,2,820), -- Durable Metal Plate
(20502,1871,1,1,-1,233906), -- Charcoal
(20502,1896,1,1,-1,99113), -- Necklace of Anguish Chain
(20502,1923,1,1,-1,95863), -- Leather Stocking Pattern
(20502,57,118,179,0,700000), -- Adena
(20502,23,1,1,1,1158), -- Wooden Breastplate
(20502,30,1,1,1,1854), -- Hard Leather Pants
(20502,2386,1,1,1,1854), -- Wooden Gaiters
(20502,1798,1,1,2,45159), -- Recipe: Leather Helmet
(20502,1868,1,1,2,92123), -- Thread
(20502,1873,1,1,2,18425), -- Silver Nugget
(20504,1792,1,1,-1,13930), -- Recipe: Short Spear
(20504,1921,1,1,-1,122225), -- Leather Shoes Texture
(20504,2010,1,1,-1,7372), -- Brandish Blade
(20504,57,97,143,0,700000), -- Adena
(20504,20,1,1,1,4026), -- Buckler
(20504,43,1,1,1,2813), -- Wooden Helmet
(20504,1792,1,1,2,2744), -- Recipe: Short Spear
(20504,1865,1,1,2,37307), -- Varnish
(20504,1870,1,1,2,37307), -- Coal
(20505,734,1,1,-1,45036), -- Haste Potion
(20505,1800,1,1,-1,84973), -- Recipe: Piece Bone Breastplate
(20505,1869,1,1,-1,270215), -- Iron Ore
(20505,57,125,217,0,700000), -- Adena
(20505,217,1,1,1,118), -- Shining Knife
(20505,218,1,1,1,118), -- Throwing Knife
(20505,1817,1,1,2,6386), -- Recipe: Cord
(20505,1864,1,1,2,63854), -- Stem
(20505,1869,1,1,2,31927), -- Iron Ore
(20505,1878,1,1,2,12771), -- Braided Hemp
(20505,5273,1,1,2,1278), -- Recipe: Greater Spiritshot (D) Compressed Package(100%)
(20506,1864,1,1,-1,492156), -- Stem
(20506,1924,1,1,-1,79380), -- Leather Helmet Design
(20506,2150,1,1,-1,115530), -- Recipe: Blue Diamond Necklace
(20506,57,120,193,0,700000), -- Adena
(20506,24,1,1,1,359), -- Bone Breastplate
(20506,31,1,1,1,573), -- Bone Gaiters
(20506,390,1,1,1,359), -- Cotton Shirt
(20506,412,1,1,1,573), -- Cotton Pants
(20506,1864,1,1,2,72688), -- Stem
(20506,1869,1,1,2,36344), -- Iron Ore
(20506,2141,1,1,2,7269), -- Recipe: Silver Mold
(20506,5273,1,1,2,1454), -- Recipe: Greater Spiritshot (D) Compressed Package(100%)
(20507,1866,1,1,-1,193642), -- Suede
(20507,1898,1,1,-1,29837), -- Blue Diamond Necklace Gem
(20507,3032,1,1,-1,11619), -- Recipe: Spiritshot D
(20507,57,132,236,0,700000), -- Adena
(20507,273,1,1,1,71), -- Composition Bow
(20507,2016,1,1,1,1006), -- Composition Bow Shaft
(20507,1804,1,1,2,1373), -- Recipe: Soulshot: D-Grade
(20507,1864,1,1,2,68639), -- Stem
(20507,1869,1,1,2,34320), -- Iron Ore
(20507,1878,1,1,2,13728), -- Braided Hemp
(20507,5273,1,1,2,1373), -- Recipe: Greater Spiritshot (D) Compressed Package(100%)
(20508,1800,1,1,-1,78931), -- Recipe: Piece Bone Breastplate
(20508,1866,1,1,-1,167333), -- Suede
(20508,57,122,197,0,700000), -- Adena
(20508,1101,1,1,1,731), -- Tunic of Devotion
(20508,1104,1,1,1,1168), -- Stockings of Devotion
(20508,1867,1,1,2,65904), -- Animal Skin
(20508,1872,1,1,2,65904), -- Animal Bone
(20508,2142,1,1,2,9886), -- Recipe: Varnish of Purity
(20509,1060,1,1,-1,330759), -- Lesser Healing Potion
(20509,1129,1,1,-1,49042), -- Crude Leather Shoes
(20509,2005,1,1,-1,10632), -- Broadsword Blade
(20509,57,80,108,0,700000), -- Adena
(20509,428,1,1,1,1810), -- Feriotic Tunic
(20509,463,1,1,1,2893), -- Feriotic Stockings
(20509,1100,1,1,1,1810), -- Cotton Tunic
(20509,1103,1,1,1,2893), -- Cotton Stockings
(20509,17,10,30,2,109915), -- Wooden Arrow
(20509,1864,1,1,2,43966), -- Stem
(20509,1869,1,1,2,21983), -- Iron Ore
(20509,2136,1,1,2,6466), -- Recipe: Cokes
(20510,1792,1,1,-1,15222), -- Recipe: Short Spear
(20510,1798,1,1,-1,202966), -- Recipe: Leather Helmet
(20510,1923,1,1,-1,84846), -- Leather Stocking Pattern
(20510,57,110,152,0,700000), -- Adena
(20510,23,1,1,1,1025), -- Wooden Breastplate
(20510,30,1,1,1,1641), -- Hard Leather Pants
(20510,2386,1,1,1,1641), -- Wooden Gaiters
(20510,1792,1,1,2,2998), -- Recipe: Short Spear
(20510,1868,1,1,2,81537), -- Thread
(20510,1873,1,1,2,16308), -- Silver Nugget
(20511,734,1,1,-1,40780), -- Haste Potion
(20511,1897,1,1,-1,58257), -- Necklace of Wisdom Chain
(20511,2144,1,1,-1,48936), -- Recipe: Compound Braid
(20511,57,115,195,0,700000), -- Adena
(20511,176,1,1,1,107), -- Journeyman\'s Staff
(20511,2501,1,1,1,107), -- Bone Club
(20511,735,1,1,2,1721), -- Potion of Alacrity
(20511,1800,1,1,2,6494), -- Recipe: Piece Bone Breastplate
(20511,1867,1,1,2,27534), -- Animal Skin
(20511,1869,1,1,2,20650), -- Iron Ore
(20511,1870,1,1,2,20650), -- Coal
(20511,1871,1,1,2,20650), -- Charcoal
(20511,1872,1,1,2,27534), -- Animal Bone
(20514,1870,1,1,-1,231613), -- Coal
(20514,1872,1,1,-1,308818), -- Animal Bone
(20514,57,116,177,0,700000), -- Adena
(20514,20,1,1,1,4923), -- Buckler
(20514,43,1,1,1,3438), -- Wooden Helmet
(20514,734,1,1,2,5702), -- Haste Potion
(20514,1799,1,1,2,50678), -- Recipe: Leather Gloves
(20514,1865,1,1,2,34208), -- Varnish
(20514,1870,1,1,2,34208), -- Coal
(20515,735,1,1,-1,19797), -- Potion of Alacrity
(20515,1865,1,1,-1,237565), -- Varnish
(20515,2013,1,1,-1,5127), -- Forest Bow Shaft
(20515,57,118,183,0,700000), -- Adena
(20515,15,1,1,1,104), -- Short Spear
(20515,2011,1,1,1,1601), -- Short Spear Edge
(20515,1801,1,1,2,17676), -- Recipe: Piece Bone Gaiters
(20515,1865,1,1,2,35087), -- Varnish
(20515,1870,1,1,2,35087), -- Coal
(20515,5158,1,1,2,1404), -- Recipe: Spiritshot (D) Compressed Package (100%)
(20517,1831,1,1,-1,473949), -- Antidote
(20517,1869,1,1,-1,177731), -- Iron Ore
(20517,1921,1,1,-1,114665), -- Leather Shoes Texture
(20517,57,95,131,0,700000), -- Adena
(20517,271,1,1,1,388), -- Hunting Bow
(20517,1793,1,1,2,1931), -- Recipe: Sword of Reflection
(20517,1833,1,1,2,69999), -- Bandage
(20517,1864,1,1,2,52499), -- Stem
(20517,1869,1,1,2,26250), -- Iron Ore
(20518,1831,1,1,-1,492420), -- Antidote
(20518,1864,1,1,-1,369315), -- Stem
(20518,1866,1,1,-1,123105), -- Suede
(20518,57,97,137,0,700000), -- Adena
(20518,271,1,1,1,403), -- Hunting Bow
(20518,1799,1,1,2,53872), -- Recipe: Leather Gloves
(20518,1865,1,1,2,36364), -- Varnish
(20518,1870,1,1,2,36364), -- Coal
(20521,1896,1,1,-1,106171), -- Necklace of Anguish Chain
(20521,1897,1,1,-1,59658), -- Necklace of Wisdom Chain
(20521,2143,1,1,-1,50113), -- Recipe: Synthetic Cokes
(20521,57,128,189,0,700000), -- Adena
(20521,9,1,1,1,183), -- Cedar Staff
(20521,154,1,1,1,183), -- Dwarven Mace
(20521,2008,1,1,1,1921), -- Cedar Staff Head
(20521,734,1,1,2,6168), -- Haste Potion
(20521,1793,1,1,2,2722), -- Recipe: Sword of Reflection
(20521,1866,1,1,2,24671), -- Suede
(20521,1871,1,1,2,37007), -- Charcoal
(20525,1867,1,1,-1,51475), -- Animal Skin
(20525,1872,1,1,-1,51475), -- Animal Bone
(20525,5549,1,1,-1,3861), -- Metallic Thread
(20525,57,19,29,0,700000), -- Adena
(20525,1,1,1,1,10394), -- Short Sword
(20525,1060,1,1,2,22174), -- Lesser Healing Potion
(20525,1787,1,1,2,7983), -- Recipe: Willow Staff
(20525,1868,1,1,2,19957), -- Thread
(20525,1873,1,1,2,3992), -- Silver Nugget
(20526,1833,1,1,-1,694345), -- Bandage
(20526,1921,1,1,-1,167987), -- Leather Shoes Texture
(20526,5220,1,1,-1,10415), -- Metal Hardener
(20526,57,131,199,0,700000), -- Adena
(20526,114,1,1,1,1753), -- Earring of Strength
(20526,115,1,1,1,1753), -- Earring of Wisdom
(20526,876,1,1,1,2630), -- Ring of Anguish
(20526,907,1,1,1,1315), -- Necklace of Anguish
(20526,1896,1,1,1,13036), -- Necklace of Anguish Chain
(20526,1803,1,1,2,43088), -- Recipe: Necklace of Wisdom
(20526,1866,1,1,2,34184), -- Suede
(20526,1871,1,1,2,51275), -- Charcoal
(20528,1833,1,1,-1,568013), -- Bandage
(20528,1922,1,1,-1,54338), -- Leather Tunic Pattern
(20528,57,112,158,0,700000), -- Adena
(20528,216,1,1,1,233), -- Dirk
(20528,2009,1,1,1,2232), -- Dirk Blade
(20528,1803,1,1,2,35249), -- Recipe: Necklace of Wisdom
(20528,1865,1,1,2,41946), -- Varnish
(20528,1870,1,1,2,41946), -- Coal
(20529,1121,1,1,-1,454845), -- Apprentice\'s Shoes
(20529,1786,1,1,-1,12736), -- Recipe: Broad Sword
(20529,1867,1,1,-1,21226), -- Animal Skin
(20529,57,8,12,0,700000), -- Adena
(20529,35,1,1,1,22242), -- Cloth Shoes
(20529,36,1,1,1,22242), -- Leather Sandals
(20529,48,1,1,1,22241), -- Short Gloves
(20529,1121,1,1,1,117560), -- Apprentice\'s Shoes
(20529,1788,1,1,2,4389), -- Recipe: Bow 
(20529,1868,1,1,2,10973), -- Thread
(20529,1873,1,1,2,2195), -- Silver Nugget
(20530,1787,1,1,-1,12736), -- Recipe: Willow Staff
(20530,1867,1,1,-1,21226), -- Animal Skin
(20530,1868,1,1,-1,31839), -- Thread
(20530,57,8,12,0,700000), -- Adena
(20530,426,1,1,1,11197), -- Tunic
(20530,462,1,1,1,17890), -- Stockings
(20530,1060,1,1,2,9144), -- Lesser Healing Potion
(20530,1786,1,1,2,3292), -- Recipe: Broad Sword
(20530,1868,1,1,2,8230), -- Thread
(20530,1873,1,1,2,1646), -- Silver Nugget
(20531,1788,1,1,-1,12736), -- Recipe: Bow 
(20531,1872,1,1,-1,21226), -- Animal Bone
(20531,1873,1,1,-1,6368), -- Silver Nugget
(20531,57,8,12,0,700000), -- Adena
(20531,426,1,1,1,11197), -- Tunic
(20531,462,1,1,1,17890), -- Stockings
(20531,1787,1,1,2,4389), -- Recipe: Willow Staff
(20531,1868,1,1,2,10973), -- Thread
(20531,1873,1,1,2,2195), -- Silver Nugget
(20532,35,1,1,-1,96841), -- Cloth Shoes
(20532,1786,1,1,-1,14332), -- Recipe: Broad Sword
(20532,1787,1,1,-1,14332), -- Recipe: Willow Staff
(20532,57,8,13,0,700000), -- Adena
(20532,18,1,1,1,47493), -- Leather Shield
(20532,41,1,1,1,33677), -- Cloth Cap
(20532,1786,1,1,2,4940), -- Recipe: Broad Sword
(20532,1868,1,1,2,12349), -- Thread
(20532,1873,1,1,2,2470), -- Silver Nugget
(20533,1872,1,1,-1,23887), -- Animal Bone
(20533,5549,1,1,-1,1792), -- Metallic Thread
(20533,57,8,13,0,700000), -- Adena
(20533,13,1,1,1,4823), -- Short Bow
(20533,1060,1,1,2,10291), -- Lesser Healing Potion
(20533,1787,1,1,2,3705), -- Recipe: Willow Staff
(20533,1868,1,1,2,9262), -- Thread
(20533,1873,1,1,2,1853), -- Silver Nugget
(20534,1786,1,1,-1,14332), -- Recipe: Broad Sword
(20534,1868,1,1,-1,35831), -- Thread
(20534,57,8,13,0,700000), -- Adena
(20534,21,1,1,1,12601), -- Shirt
(20534,28,1,1,1,20133), -- Pants
(20534,1788,1,1,2,4940), -- Recipe: Bow 
(20534,1868,1,1,2,12349), -- Thread
(20534,1873,1,1,2,2470), -- Silver Nugget
(20535,36,1,1,-1,96841), -- Leather Sandals
(20535,1787,1,1,-1,14332), -- Recipe: Willow Staff
(20535,1867,1,1,-1,23887), -- Animal Skin
(20535,57,8,13,0,700000), -- Adena
(20535,21,1,1,1,12601), -- Shirt
(20535,28,1,1,1,20133), -- Pants
(20535,17,10,30,2,23153), -- Wooden Arrow
(20535,1786,1,1,2,3705), -- Recipe: Broad Sword
(20535,1865,1,1,2,4631), -- Varnish
(20535,1870,1,1,2,4631), -- Coal
(20536,18,1,1,-1,139007), -- Leather Shield
(20536,1788,1,1,-1,21685), -- Recipe: Bow 
(20536,1871,1,1,-1,27106), -- Charcoal
(20536,57,13,20,0,700000), -- Adena
(20536,13,1,1,1,7298), -- Short Bow
(20536,1787,1,1,2,7474), -- Recipe: Willow Staff
(20536,1864,1,1,2,18683), -- Stem
(20536,1869,1,1,2,9342), -- Iron Ore
(20537,1788,1,1,-1,21685), -- Recipe: Bow 
(20537,1864,1,1,-1,54213), -- Stem
(20537,1867,1,1,-1,36142), -- Animal Skin
(20537,57,13,20,0,700000), -- Adena
(20537,308,1,1,1,7298), -- Buffalo\'s Horn
(20537,1060,1,1,2,15569), -- Lesser Healing Potion
(20537,1788,1,1,2,5605), -- Recipe: Bow 
(20537,1864,1,1,2,14012), -- Stem
(20537,1869,1,1,2,7006), -- Iron Ore
(20538,1786,1,1,-1,21685), -- Recipe: Broad Sword
(20538,1865,1,1,-1,27106), -- Varnish
(20538,1869,1,1,-1,27106), -- Iron Ore
(20538,57,13,20,0,700000), -- Adena
(20538,1,1,1,1,7298), -- Short Sword
(20538,1786,1,1,2,7474), -- Recipe: Broad Sword
(20538,1864,1,1,2,18683), -- Stem
(20538,1869,1,1,2,9342), -- Iron Ore
(20539,41,1,1,-1,98569), -- Cloth Cap
(20539,1786,1,1,-1,21685), -- Recipe: Broad Sword
(20539,1787,1,1,-1,21685), -- Recipe: Willow Staff
(20539,57,13,20,0,700000), -- Adena
(20539,253,1,1,1,7298), -- Spiked Gloves
(20539,17,10,30,2,35031), -- Wooden Arrow
(20539,1787,1,1,2,5605), -- Recipe: Willow Staff
(20539,1864,1,1,2,14013), -- Stem
(20539,1869,1,1,2,7007), -- Iron Ore
(20540,1831,1,1,-1,460056), -- Antidote
(20540,1873,1,1,-1,69008), -- Silver Nugget
(20540,1896,1,1,-1,73102), -- Necklace of Anguish Chain
(20540,57,92,127,0,700000), -- Adena
(20540,23,1,1,1,854), -- Wooden Breastplate
(20540,30,1,1,1,1368), -- Hard Leather Pants
(20540,2386,1,1,1,1368), -- Wooden Gaiters
(20540,736,1,1,2,16987), -- Scroll of Escape
(20540,1868,1,1,2,67947), -- Thread
(20540,1873,1,1,2,13590), -- Silver Nugget
(20541,1897,1,1,-1,48342), -- Necklace of Wisdom Chain
(20541,1925,1,1,-1,133138), -- Leather Gloves Lining
(20541,2173,1,1,-1,55023), -- Recipe: Hard Leather Shirt
(20541,57,99,159,0,700000), -- Adena
(20541,272,1,1,1,89), -- Forest Bow
(20541,2013,1,1,1,1295), -- Forest Bow Shaft
(20541,734,1,1,2,2499), -- Haste Potion
(20541,1864,1,1,2,29987), -- Stem
(20541,1865,1,1,2,14994), -- Varnish
(20541,1866,1,1,2,9996), -- Suede
(20541,1868,1,1,2,29987), -- Thread
(20541,1873,1,1,2,5998), -- Silver Nugget
(20541,2143,1,1,2,2999), -- Recipe: Synthetic Cokes
(20541,5158,1,1,2,600), -- Recipe: Spiritshot (D) Compressed Package (100%)
(20542,734,1,1,-1,37733), -- Haste Potion
(20542,1869,1,1,-1,226397), -- Iron Ore
(20542,1878,1,1,-1,90559), -- Braided Hemp
(20542,57,106,181,0,700000), -- Adena
(20542,272,1,1,1,99), -- Forest Bow
(20542,2013,1,1,1,1444), -- Forest Bow Shaft
(20542,1801,1,1,2,13476), -- Recipe: Piece Bone Gaiters
(20542,1864,1,1,2,53500), -- Stem
(20542,1869,1,1,2,26750), -- Iron Ore
(20542,1878,1,1,2,10700), -- Braided Hemp
(20542,5158,1,1,2,1070), -- Recipe: Spiritshot (D) Compressed Package (100%)
(20543,908,1,1,-1,3822), -- Necklace of Wisdom
(20543,1882,1,1,-1,50535), -- Leather
(20543,2252,1,1,-1,9320), -- Recipe: Iron Hammer
(20543,57,105,183,0,700000), -- Adena
(20543,309,1,1,1,99), -- Tears of Eva
(20543,310,1,1,1,99), -- Relic of The Saints
(20543,1867,1,1,2,35826), -- Animal Skin
(20543,1872,1,1,2,35826), -- Animal Bone
(20543,1882,1,1,2,5971), -- Leather
(20543,2139,1,1,2,5374), -- Recipe: Steel Mold
(20543,6037,1,1,2,53739), -- Waking Scroll
(20544,1788,1,1,-1,21685), -- Recipe: Bow 
(20544,1870,1,1,-1,27106), -- Coal
(20544,1872,1,1,-1,36142), -- Animal Bone
(20544,57,13,20,0,700000), -- Adena
(20544,21,1,1,1,19065), -- Shirt
(20544,28,1,1,1,30461), -- Pants
(20544,1788,1,1,2,7474), -- Recipe: Bow 
(20544,1864,1,1,2,18683), -- Stem
(20544,1869,1,1,2,9342), -- Iron Ore
(20545,21,1,1,-1,21659), -- Shirt
(20545,1786,1,1,-1,12736), -- Recipe: Broad Sword
(20545,1873,1,1,-1,6368), -- Silver Nugget
(20545,57,8,12,0,700000), -- Adena
(20545,18,1,1,1,42201), -- Leather Shield
(20545,41,1,1,1,29925), -- Cloth Cap
(20545,17,10,30,2,16459), -- Wooden Arrow
(20545,1788,1,1,2,2634), -- Recipe: Bow 
(20545,1868,1,1,2,6584), -- Thread
(20545,1873,1,1,2,1317), -- Silver Nugget
(20545,6037,1,1,2,6584), -- Waking Scroll
(20546,1877,1,1,-1,22714), -- Adamantite Nugget
(20546,2279,1,1,-1,4056), -- Recipe: War Pick
(20546,2979,1,1,-1,76017), -- Recipe: Manticore Skin Gloves
(20546,57,240,478,0,700000), -- Adena
(20546,849,1,1,1,235), -- Tiger\'s Eye Earring
(20546,880,1,1,1,353), -- Black Pearl Ring
(20546,912,1,1,1,177), -- Near Forest Necklace
(20546,1901,1,1,1,10426), -- Tiger\'s Eye Earring Stone
(20546,1876,1,1,2,7549), -- Mithril Ore
(20546,1877,1,1,2,1510), -- Adamantite Nugget
(20546,1880,1,1,2,3775), -- Steel
(20546,1881,1,1,2,5033), -- Coarse Bone Powder
(20546,1882,1,1,2,8387), -- Leather
(20546,2274,1,1,2,270), -- Recipe: Skull Breaker
(20546,2276,1,1,2,270), -- Recipe: Maingauche
(20546,2976,1,1,2,5053), -- Recipe: Manticore Skin Boots
(20547,1804,1,1,-1,12605), -- Recipe: Soulshot: D-Grade
(20547,1898,1,1,-1,32370), -- Blue Diamond Necklace Gem
(20547,2151,1,1,-1,87777), -- Recipe: Necklace of Devotion
(20547,57,144,255,0,700000), -- Adena
(20547,39,1,1,1,1009), -- Boots
(20547,51,1,1,1,1009), -- Bracer
(20547,1930,1,1,1,15912), -- Boot Lining
(20547,734,1,1,2,6206), -- Haste Potion
(20547,1865,1,1,2,37233), -- Varnish
(20547,1870,1,1,2,37233), -- Coal
(20547,5163,1,1,2,1490), -- Recipe: Blessed Spiritshot (D) Compressed Package (100%)
(20547,5268,1,1,2,1490), -- Recipe: Greater Soulshot (D) Compressed Package (100%)
(20548,1804,1,1,-1,12857), -- Recipe: Soulshot: D-Grade
(20548,1865,1,1,-1,321422), -- Varnish
(20548,1930,1,1,-1,82416), -- Boot Lining
(20548,57,147,260,0,700000), -- Adena
(20548,625,1,1,1,1472), -- Bone Shield
(20548,1148,1,1,1,1033), -- Hard Leather Helmet
(20548,1864,1,1,2,94944), -- Stem
(20548,1869,1,1,2,47472), -- Iron Ore
(20548,1880,1,1,2,4748), -- Steel
(20548,5268,1,1,2,1899), -- Recipe: Greater Soulshot (D) Compressed Package (100%)
(20549,1880,1,1,-1,116806), -- Steel
(20549,1901,1,1,-1,161334), -- Tiger\'s Eye Earring Stone
(20549,1938,1,1,-1,78525), -- Mithril Banded Mail Material
(20549,57,493,984,0,700000), -- Adena
(20549,83,1,1,1,29), -- Sword of Magic
(20549,124,1,1,1,22), -- Two-Handed Sword
(20549,127,1,1,1,22), -- Crimson Sword
(20549,130,1,1,1,22), -- Elven Sword
(20549,144,1,1,1,29), -- Sword of Occult
(20549,2026,1,1,1,1246), -- Two-Handed Sword Edge
(20549,1341,20,60,2,172514), -- Bone Arrow
(20549,1866,1,1,2,69006), -- Suede
(20549,1871,1,1,2,103508), -- Charcoal
(20549,1877,1,1,2,4141), -- Adamantite Nugget
(20549,2277,1,1,2,740), -- Recipe: Bich\'hwa
(20549,6667,1,1,2,64693), -- Deluxe Chest Key - Grade 3
(20550,394,1,1,-1,850), -- Reinforced Leather Shirt
(20550,2154,1,1,-1,69153), -- Recipe: Elven Earring
(20550,2276,1,1,-1,4614), -- Recipe: Maingauche
(20550,57,272,546,0,700000), -- Adena
(20550,393,1,1,1,76), -- Mithril Banded Mail
(20550,394,1,1,1,76), -- Reinforced Leather Shirt
(20550,415,1,1,1,121), -- Mithril Banded Gaiters
(20550,416,1,1,1,121), -- Reinforced Leather Gaiters
(20550,1938,1,1,1,3849), -- Mithril Banded Mail Material
(20550,1939,1,1,1,5028), -- Mithril Banded Gaiters Material
(20550,1868,1,1,2,98119), -- Thread
(20550,1873,1,1,2,19624), -- Silver Nugget
(20550,1889,1,1,2,3271), -- Compound Braid
(20550,2148,1,1,2,3505), -- Recipe: Crafted Leather
(20550,2272,1,1,2,351), -- Recipe: Sword of Revolution
(20550,2274,1,1,2,351), -- Recipe: Skull Breaker
(20550,5549,1,1,2,4906), -- Metallic Thread
(20551,1874,1,1,-1,43592), -- Oriharukon Ore
(20551,1902,1,1,-1,66249), -- Elven Earring Beads
(20551,2034,1,1,-1,6909), -- Sword of Revolution Blade
(20551,57,276,551,0,700000), -- Adena
(20551,850,1,1,1,121), -- Elven Earring
(20551,881,1,1,1,181), -- Elven Ring
(20551,913,1,1,1,91), -- Elven Necklace
(20551,1902,1,1,1,5708), -- Elven Earring Beads
(20551,1903,1,1,1,9398), -- Elven Ring Piece
(20551,1904,1,1,1,5258), -- Elven Necklace Beads
(20551,1867,1,1,2,64382), -- Animal Skin
(20551,1872,1,1,2,64382), -- Animal Bone
(20551,1875,1,1,2,3220), -- Stone of Purity
(20551,1881,1,1,2,6439), -- Coarse Bone Powder
(20551,2145,1,1,2,3450), -- Recipe: Mithril Alloy
(20551,2287,1,1,2,269), -- Recipe: Atuba Hammer
(20551,2288,1,1,2,269), -- Recipe: Ghost Staff
(20552,1825,1,1,-1,100458), -- Recipe: Oriharukon
(20552,1902,1,1,-1,142493), -- Elven Earring Beads
(20552,1903,1,1,-1,234596), -- Elven Ring Piece
(20552,57,595,1187,0,700000), -- Adena
(20552,129,1,1,1,52), -- Sword of Revolution
(20552,2034,1,1,1,3842), -- Sword of Revolution Blade
(20552,1864,1,1,2,242335), -- Stem
(20552,1869,1,1,2,121168), -- Iron Ore
(20552,1878,1,1,2,48467), -- Braided Hemp
(20552,1884,1,1,2,74565), -- Cord
(20552,2208,1,1,2,12390), -- Recipe: Ogre Power Gauntlets
(20552,2285,1,1,2,673), -- Recipe: Claymore
(20553,1865,1,1,-1,724776), -- Varnish
(20553,1904,1,1,-1,67641), -- Elven Necklace Beads
(20553,2145,1,1,-1,51770), -- Recipe: Mithril Alloy
(20553,57,307,611,0,700000), -- Adena
(20553,318,1,1,1,27), -- Crucifix of Blood
(20553,2042,1,1,1,1732), -- Crucifix of Blood Piece
(20553,1865,1,1,2,62443), -- Varnish
(20553,1870,1,1,2,62443), -- Coal
(20553,1875,1,1,2,4163), -- Stone of Purity
(20553,1879,1,1,2,10407), -- Cokes
(20553,2208,1,1,2,6385), -- Recipe: Ogre Power Gauntlets
(20553,2285,1,1,2,347), -- Recipe: Claymore
(20554,1902,1,1,-1,85565), -- Elven Earring Beads
(20554,1941,1,1,-1,33586), -- Brigandine Temper
(20554,2146,1,1,-1,60324), -- Recipe: Artisan\'s frame
(20554,57,354,707,0,700000), -- Adena
(20554,224,1,1,1,16), -- Maingauche
(20554,1660,1,1,1,16), -- Cursed Maingauche
(20554,2038,1,1,1,1154), -- Maingauche Edge
(20554,2044,1,1,1,1154), -- Cursed Maingauche Edge
(20554,1864,1,1,2,124731), -- Stem
(20554,1869,1,1,2,62366), -- Iron Ore
(20554,1880,1,1,2,6237), -- Steel
(20554,2208,1,1,2,6377), -- Recipe: Ogre Power Gauntlets
(20554,5473,1,1,2,4455), -- Recipe: Durable Metal Plate(100%)
(20554,5550,1,1,2,832), -- Durable Metal Plate
(20554,6036,1,1,2,2079), -- Greater Magic Haste Potion
(20555,1878,1,1,-1,304091), -- Braided Hemp
(20555,1903,1,1,-1,126810), -- Elven Ring Piece
(20555,2296,1,1,-1,4223), -- Recipe: Atuba Mace
(20555,57,319,636,0,700000), -- Adena
(20555,395,1,1,1,88), -- Manticore Skin Shirt
(20555,417,1,1,1,141), -- Manticore Skin Gaiters
(20555,1942,1,1,1,5011), -- Manticore Skin Shirt Texture
(20555,1943,1,1,1,7803), -- Manticore Skin Gaiters Pattern
(20555,4203,1,1,2,8187), -- Spellbook: Life Leech
(20555,4204,1,1,2,8187), -- Amulet: Pa\'agrio\'s Tact
(20555,4206,1,1,2,8188), -- Spellbook: Transfer Pain
(20555,10185,1,1,2,3817), -- Battle Manual: Destroy Instinct
(20555,10040,1,1,2,4255), -- Battle Manual: Life To Soul
(20555,10034,1,1,2,3817), -- Battle Manual: Shift Target
(20556,1874,1,1,-1,53220), -- Oriharukon Ore
(20556,1957,1,1,-1,89096), -- Assault Boots Part
(20556,2305,1,1,-1,3486), -- Recipe: Crystal Staff
(20556,57,328,657,0,700000), -- Adena
(20556,438,1,1,1,94), -- Sage\'s Rag
(20556,1953,1,1,1,6421), -- Sage\'s Rag Lining
(20556,1865,1,1,2,66812), -- Varnish
(20556,1870,1,1,2,66812), -- Coal
(20556,1874,1,1,2,4455), -- Oriharukon Ore
(20556,2160,1,1,2,4311), -- Recipe: Moonstone Earring
(20556,2205,1,1,2,2115), -- Recipe: Chain Gaiters
(20556,5154,1,1,2,223), -- Recipe: Soulshot (C) Compressed Package (100%)
(20557,2055,1,1,-1,6984), -- Glaive Edge
(20557,3954,1,1,-1,2816), -- Recipe: Blessed Spiritshot C
(20557,4469,1,1,-1,4827), -- Dye of Strength <Str+1 Con-1>
(20557,57,345,698,0,700000), -- Adena
(20557,297,1,1,1,24), -- Glaive
(20557,2055,1,1,1,1754), -- Glaive Edge
(20557,1866,1,1,2,40396), -- Suede
(20557,1871,1,1,2,60594), -- Charcoal
(20557,1877,1,1,2,2424), -- Adamantite Nugget
(20557,2297,1,1,2,265), -- Recipe: Flamberge
(20557,2994,1,1,2,4809), -- Recipe: Boots of Seal
(20557,5154,1,1,2,203), -- Recipe: Soulshot (C) Compressed Package (100%)
(20557,6668,1,1,2,21641), -- Deluxe Chest Key - Grade 4
(20558,1905,1,1,-1,84475), -- Omen Beast\'s Eye Earring Gemstone
(20558,2310,1,1,-1,3792), -- Recipe: Dark Elven Dagger
(20558,2932,1,1,-1,96920), -- Plate Boots Design
(20558,57,350,712,0,700000), -- Adena
(20558,851,1,1,1,121), -- Omen Beast\'s Eye Earring
(20558,882,1,1,1,180), -- Mithril Ring
(20558,914,1,1,1,90), -- Necklace of Darkness
(20558,1905,1,1,1,7070), -- Omen Beast\'s Eye Earring Gemstone
(20558,1906,1,1,1,9990), -- Mithril Ring Wire
(20558,1907,1,1,1,5056), -- Necklace of Darkness Gem
(20558,1342,10,30,2,109019), -- Fine Steel Arrow
(20558,1875,1,1,2,3634), -- Stone of Purity
(20558,1879,1,1,2,9085), -- Cokes
(20558,1885,1,1,2,4543), -- High Grade Suede
(20558,2303,1,1,2,238), -- Recipe: Skull Graver
(20558,2988,1,1,2,2300), -- Recipe: Tempered Mithril Gaiters
(20558,5549,1,1,2,5451), -- Metallic Thread
(20558,5550,1,1,2,727), -- Durable Metal Plate
(20559,1873,1,1,-1,408624), -- Silver Nugget
(20559,2163,1,1,-1,52120), -- Recipe: Earring of Protection
(20559,2164,1,1,-1,78582), -- Recipe: Ring of Protection
(20559,57,410,840,0,700000), -- Adena
(20559,71,1,1,1,11), -- Flamberge
(20559,72,1,1,1,11), -- Stormbringer
(20559,2059,1,1,1,897), -- Flamberge Blade
(20559,2060,1,1,1,959), -- Stormbringer Blade
(20559,1895,1,1,2,34487), -- Metallic Fiber
(20559,2164,1,1,2,9285), -- Recipe: Ring of Protection
(20559,2219,1,1,2,7497), -- Recipe: Crimson Boots
(20559,5154,1,1,2,403), -- Recipe: Soulshot (C) Compressed Package (100%)
(20560,1908,1,1,-1,90114), -- Moonstone Earring Wire
(20560,2165,1,1,-1,36460), -- Recipe: Necklace of Protection
(20560,2320,1,1,-1,3316), -- Recipe: Cursed Staff
(20560,57,384,780,0,700000), -- Adena
(20560,852,1,1,1,97), -- Moonstone Earring
(20560,883,1,1,1,146), -- Aquastone Ring
(20560,915,1,1,1,73), -- Aquastone Necklace
(20560,1908,1,1,1,7098), -- Moonstone Earring Wire
(20560,1909,1,1,1,10122), -- Aquastone Ring Wire
(20560,1910,1,1,1,5644), -- Aquastone Necklace Chain
(20560,1864,1,1,2,99943), -- Stem
(20560,1865,1,1,2,49972), -- Varnish
(20560,1866,1,1,2,33315), -- Suede
(20560,1868,1,1,2,99943), -- Thread
(20560,1873,1,1,2,19989), -- Silver Nugget
(20560,2225,1,1,2,1087), -- Recipe: Demon\'s Stockings
(20560,2321,1,1,2,175), -- Recipe: Stiletto
(20560,2323,1,1,2,175), -- Recipe: Elemental Bow
(20560,3003,1,1,2,3104), -- Recipe: Gloves of Seal
(20561,1880,1,1,-1,112699), -- Steel
(20561,2164,1,1,-1,86691), -- Recipe: Ring of Protection
(20561,2940,1,1,-1,101302), -- Dwarven Chain Boots Part
(20561,57,453,926,0,700000), -- Adena
(20561,96,1,1,1,8), -- Scythe
(20561,298,1,1,1,8), -- Orcish Glaive
(20561,302,1,1,1,8), -- Body Slasher
(20561,2062,1,1,1,697), -- Scythe Edge
(20561,2075,1,1,1,697), -- Orcish Glaive Blade
(20561,2076,1,1,1,697), -- Body Slasher Blade
(20561,1832,1,1,2,73978), -- Greater Antidote
(20561,1866,1,1,2,44386), -- Suede
(20561,1871,1,1,2,66580), -- Charcoal
(20561,1885,1,1,2,5549), -- High Grade Suede
(20561,4041,1,1,2,579), -- Mold Hardener
(20561,5220,1,1,2,2664), -- Metal Hardener
(20561,6037,1,1,2,133159), -- Waking Scroll
(20561,6668,1,1,2,23779), -- Deluxe Chest Key - Grade 4
(20562,440,1,1,-1,307), -- Robe of Seal
(20562,1867,1,3,-1,723243), -- Animal Skin
(20562,2346,1,1,-1,2523), -- Recipe: Fist Blade
(20562,57,437,891,0,700000), -- Adena
(20562,853,1,1,1,82), -- Earring of Protection
(20562,884,1,1,1,124), -- Ring of Protection
(20562,916,1,1,1,62), -- Necklace of Protection
(20562,1911,1,1,1,5960), -- Earring of Protection Gemstone
(20562,1912,1,1,1,8635), -- Ring of Protection Gemstone
(20562,1913,1,1,1,4873), -- Necklace of Protection Gemstone
(20562,1342,10,30,2,106818), -- Fine Steel Arrow
(20562,1864,1,1,2,106818), -- Stem
(20562,1869,1,1,2,53409), -- Iron Ore
(20562,1880,1,1,2,5341), -- Steel
(20562,2166,1,1,2,1811), -- Recipe: Earrings of Binding (100%)
(20562,2226,1,1,2,2180), -- Recipe: Mithril Gauntlets
(20562,2230,1,1,2,1036), -- Recipe: Theca Leather Gaiters
(20562,4043,1,1,2,1781), -- Asofe
(20562,5550,1,1,2,713), -- Durable Metal Plate
(20563,1825,1,1,-1,64619), -- Recipe: Oriharukon
(20563,1864,1,3,-1,904670), -- Stem
(20563,1941,1,1,-1,35978), -- Brigandine Temper
(20563,57,379,757,0,700000), -- Adena
(20563,606,1,1,1,79), -- Rip Gauntlets
(20563,1124,1,1,1,79), -- Boots of Power
(20563,1946,1,1,1,3951), -- Rip Gauntlets Pattern
(20563,1948,1,1,1,3951), -- Boots of Power Pattern
(20563,2424,1,1,1,79), -- Manticore Skin Boots
(20563,2425,1,1,1,79), -- Brigandine Boots
(20563,2426,1,1,1,79), -- Elven Mithril Boots
(20563,2448,1,1,1,79), -- Manticore Skin Gloves
(20563,2449,1,1,1,79), -- Brigandine Gauntlets
(20563,2450,1,1,1,79), -- Elven Mithril Gloves
(20563,2923,1,1,1,3951), -- Manticore Skin Boot Lining
(20563,2924,1,1,1,3951), -- Brigandine Boots Design
(20563,2925,1,1,1,3951), -- Elven Mithril Boots Design
(20563,2926,1,1,1,3951), -- Manticore Skin Gloves Lining
(20563,2927,1,1,1,3951), -- Brigandine Gauntlets Pattern
(20563,2928,1,1,1,3951), -- Elven Mithril Gloves Design
(20563,3039,1,1,2,5846), -- Spellbook: Summon Storm Cubic
(20563,3041,1,1,2,5846), -- Spellbook: Summon Phantom Cubic
(20563,3042,1,1,2,5846), -- Spellbook: Life Scavenge
(20563,3429,1,1,2,5846), -- Spellbook: Greater Heal
(20563,4200,1,1,2,4859), -- Spellbook: Restore Life
(20564,1864,1,3,-1,814270), -- Stem
(20564,1885,1,1,-1,67856), -- High Grade Suede
(20564,2306,1,1,-1,3556), -- Recipe: Stick of Faith
(20564,57,335,670,0,700000), -- Adena
(20564,630,1,1,1,133), -- Square Shield
(20564,1956,1,1,1,7736), -- Square Shield Fragment
(20564,2412,1,1,1,93), -- Plate Helmet
(20564,2494,1,1,1,133), -- Plate Shield
(20564,2930,1,1,1,5494), -- Plate Helmet Design
(20564,2934,1,1,1,7736), -- Plate Shield Fragment
(20564,3048,1,1,2,5112), -- Spellbook: Reflect Damage
(20564,3050,1,1,2,5112), -- Spellbook: Hex
(20564,3051,1,1,2,5112), -- Spellbook: Spirit Barrier
(20564,3430,1,1,2,5112), -- Spellbook: Greater Battle Heal
(20564,4201,1,1,2,5112), -- Spellbook: Resist Shock
(20564,10086,1,1,2,4464), -- Battle Manual: Bleeding Shot
(20565,1865,1,1,-1,940260), -- Varnish
(20565,3954,1,1,-1,3134), -- Recipe: Blessed Spiritshot C
(20565,4470,1,1,-1,5373), -- Dye of Strength <Str+1 Dex-1>
(20565,57,384,777,0,700000), -- Adena
(20565,262,1,1,1,27), -- Scallop Jamadhr
(20565,2053,1,1,1,1952), -- Scallop Jamadhr Edge
(20565,3053,1,1,2,7378), -- Spellbook: Holy Blessing
(20565,3056,1,1,2,7378), -- Spellbook: Summon Dark Panther
(20565,3058,1,1,2,7378), -- Spellbook: Summon Corrupted Man
(20565,3431,1,1,2,7378), -- Spellbook: Greater Group Heal
(20565,10186,1,1,2,5208), -- Battle Manual: Restoration
(20566,1905,1,1,-1,95916), -- Omen Beast\'s Eye Earring Gemstone
(20566,2995,1,1,-1,78255), -- Recipe: Reinforced Mithril Gloves
(20566,3000,1,1,-1,63206), -- Recipe: Dwarven Chain Shield
(20566,57,398,808,0,700000), -- Adena
(20566,630,1,1,1,161), -- Square Shield
(20566,1956,1,1,1,9368), -- Square Shield Fragment
(20566,2412,1,1,1,113), -- Plate Helmet
(20566,2494,1,1,1,161), -- Plate Shield
(20566,2930,1,1,1,6653), -- Plate Helmet Design
(20566,2934,1,1,1,9368), -- Plate Shield Fragment
(20566,3061,1,1,2,7737), -- Spellbook: Curse Discord
(20566,3062,1,1,2,7737), -- Spellbook: Curse Fear
(20566,3064,1,1,2,7737), -- Spellbook: Silence
(20566,3432,1,1,2,7737), -- Spellbook: Remedy
(20566,10182,1,1,2,5917), -- Battle Manual: Ultimate Escape
(20567,2061,1,1,-1,8442), -- Big Hammer Head
(20567,2165,1,1,-1,41845), -- Recipe: Necklace of Protection
(20567,3004,1,1,-1,67836), -- Recipe: Rind Leather Gloves
(20567,57,438,899,0,700000), -- Adena
(20567,263,1,1,1,23), -- Chakram
(20567,2073,1,1,1,1995), -- Chakram Edge
(20567,3067,1,1,2,8066), -- Spellbook: Vampiric Claw
(20567,3071,1,1,2,8066), -- Spellbook: Requiem
(20567,3073,1,1,2,8066), -- Spellbook: Might of Heaven
(20567,3074,1,1,2,8066), -- Spellbook: Surrender to Wind
(20568,1884,1,1,-1,591456), -- Cord
(20568,1908,1,1,-1,91015), -- Moonstone Earring Wire
(20568,1961,1,1,-1,30756), -- Mithril Shirt Fabric
(20568,57,388,788,0,700000), -- Adena
(20568,89,1,1,1,3), -- Big Hammer
(20568,160,1,1,1,3), -- Battle Axe
(20568,161,1,1,1,3), -- Silver Axe
(20568,173,1,1,1,3), -- Skull Graver
(20568,191,1,1,1,3), -- Heavy Doom Hammer
(20568,192,1,1,1,3), -- Crystal Staff
(20568,193,1,1,1,3), -- Stick of Faith
(20568,194,1,1,1,3), -- Heavy Doom Axe
(20568,2061,1,1,1,220), -- Big Hammer Head
(20568,2063,1,1,1,220), -- Battle Axe Head
(20568,2064,1,1,1,220), -- Silver Axe Head
(20568,2065,1,1,1,220), -- Skull Graver Head
(20568,2066,1,1,1,223), -- Heavy Doom Hammer Head
(20568,2067,1,1,1,205), -- Crystal Staff Head
(20568,2068,1,1,1,205), -- Stick of Faith Shaft
(20568,2069,1,1,1,223), -- Heavy Doom Axe Blade
(20568,1864,1,1,2,129783), -- Stem
(20568,1865,1,1,2,64892), -- Varnish
(20568,1866,1,1,2,43261), -- Suede
(20568,1868,1,1,2,129783), -- Thread
(20568,1873,1,1,2,25957), -- Silver Nugget
(20568,2321,1,1,2,227), -- Recipe: Stiletto
(20568,2324,1,1,2,227), -- Recipe: Elven Bow of Nobility
(20569,1961,1,1,-1,33428), -- Mithril Shirt Fabric
(20569,2213,1,1,-1,16221), -- Recipe: Dwarven Chain Mail Shirt
(20569,3001,1,1,-1,64883), -- Recipe: Rind Leather Boots
(20569,57,420,858,0,700000), -- Adena
(20569,631,1,1,1,124), -- Eldarake
(20569,1964,1,1,1,6650), -- Eldarake Temper
(20569,2413,1,1,1,88), -- Chain Hood
(20569,2495,1,1,1,124), -- Chain Shield
(20569,2936,1,1,1,6040), -- Chain Hood Pattern
(20569,2945,1,1,1,6650), -- Chain Shield Fragment
(20569,1865,1,1,2,61713), -- Varnish
(20569,1870,1,1,2,61713), -- Coal
(20569,1875,1,1,2,4115), -- Stone of Purity
(20569,1879,1,1,2,10286), -- Cokes
(20569,2220,1,1,2,1278), -- Recipe: Rind Leather Armor
(20569,2230,1,1,2,1196), -- Recipe: Theca Leather Gaiters
(20569,2508,1,1,2,51428), -- Cursed Bone
(20569,4040,1,1,2,1235), -- Mold Lubricant
(20570,1911,1,1,-1,77930), -- Earring of Protection Gemstone
(20570,2216,1,1,-1,43296), -- Recipe: Great Helmet
(20570,3008,1,1,-1,38101), -- Recipe: Theca Leather Gloves
(20570,57,422,861,0,700000), -- Adena
(20570,355,1,1,1,37), -- Dwarven Chain Mail Shirt
(20570,382,1,1,1,58), -- Dwarven Chain Gaiters
(20570,1968,1,1,1,2797), -- Dwarven Chain Mail Shirt Material
(20570,1969,1,1,1,4436), -- Dwarven Chain Gaiters Material
(20570,1866,1,1,2,44214), -- Suede
(20570,1871,1,1,2,66321), -- Charcoal
(20570,1885,1,1,2,5527), -- High Grade Suede
(20570,2167,1,1,2,3384), -- Recipe: Ring of Ages
(20570,2343,1,1,2,155), -- Recipe: Mace of the Underworld
(20570,4041,1,1,2,577), -- Mold Hardener
(20570,5220,1,1,2,2653), -- Metal Hardener
(20571,951,1,1,-1,2251), -- Scroll: Enchant Weapon (Grade C)
(20571,2335,1,1,-1,2880), -- Recipe: War Axe
(20571,2968,1,1,-1,8355), -- Dwarven Warhammer Head
(20571,57,499,1015,0,700000), -- Adena
(20571,73,1,1,1,5), -- Shamshir
(20571,74,1,1,1,5), -- Katana
(20571,131,1,1,1,5), -- Spirit Sword
(20571,133,1,1,1,5), -- Raid Sword
(20571,2077,1,1,1,456), -- Shamshir Blade
(20571,2078,1,1,1,456), -- Katana Blade
(20571,2080,1,1,1,456), -- Spirit Sword Blade
(20571,2081,1,1,1,456), -- Raid Sword Blade
(20571,1866,1,1,2,40643), -- Suede
(20571,1871,1,1,2,60964), -- Charcoal
(20571,1885,1,1,2,5081), -- High Grade Suede
(20571,2336,1,1,2,142), -- Recipe: Nirvana Axe
(20571,2351,1,1,2,128), -- Recipe: Scorpion
(20571,2508,1,1,2,50804), -- Cursed Bone
(20571,4041,1,1,2,531), -- Mold Hardener
(20571,5220,1,1,2,2439), -- Metal Hardener
(20571,6668,1,1,2,21773), -- Deluxe Chest Key - Grade 4
(20572,1894,1,1,-1,47642), -- Crafted Leather
(20572,2950,1,1,-1,114196), -- Gloves of Seal Pattern
(20572,4125,1,1,-1,60346), -- Recipe: Maestro Mold
(20572,57,547,1115,0,700000), -- Adena
(20572,94,1,1,1,21), -- Bec de Corbin
(20572,2079,1,1,1,2068), -- Bec De Corbin Blade
(20572,1342,10,30,2,133690), -- Fine Steel Arrow
(20572,1867,1,1,2,89127), -- Animal Skin
(20572,1872,1,1,2,89127), -- Animal Bone
(20572,1882,1,1,2,14855), -- Leather
(20572,1894,1,1,2,2346), -- Crafted Leather
(20572,2224,1,1,2,909), -- Recipe: Demon\'s Tunic
(20572,2508,1,1,2,55705), -- Cursed Bone
(20572,3009,1,1,2,2729), -- Recipe: Composite Boots
(20572,4042,1,1,2,1115), -- Enria
(20573,2119,1,1,-1,5367), -- Crystal Dagger Blade
(20573,4122,1,1,-1,52347), -- Recipe: Maestro Holder
(20573,5549,1,1,-1,117780), -- Metallic Thread
(20573,57,475,966,0,700000), -- Adena
(20573,64,1,1,1,100), -- Composite Boots
(20573,608,1,1,1,100), -- Mithril Gauntlets
(20573,1981,1,1,1,7163), -- Mithril Gauntlets Design
(20573,2956,1,1,1,7163), -- Composite Boots Part
(20573,1342,10,30,2,108237), -- Fine Steel Arrow
(20573,1868,1,1,2,108237), -- Thread
(20573,1873,1,1,2,21648), -- Silver Nugget
(20573,1889,1,1,2,3608), -- Compound Braid
(20573,2231,1,1,2,234), -- Recipe: Full Plate Armor
(20573,3014,1,1,2,1512), -- Recipe: Full Plate Boots
(20573,3019,1,1,2,1444), -- Recipe: Full Plate Shield
(20573,4044,1,1,2,1805), -- Thons
(20573,5549,1,1,2,5412), -- Metallic Thread
(20574,1539,1,1,-1,278165), -- Greater Healing Potion
(20574,1867,1,3,-1,834496), -- Animal Skin
(20574,4601,1,1,-1,2782), -- Greater Dye of Strength <Str+3 Con-3>
(20574,57,506,1027,0,700000), -- Adena
(20574,75,1,1,1,3), -- Caliburs
(20574,76,1,1,1,3), -- Sword of Delusion
(20574,77,1,1,1,3), -- Tsurugi
(20574,84,1,1,1,3), -- Homunkulus\'s Sword
(20574,134,1,1,1,3), -- Sword of Nightmare
(20574,145,1,1,1,3), -- Sword of Whispering Death
(20574,2089,1,1,1,236), -- Caliburs Edge
(20574,2090,1,1,1,236), -- Delusional Blade
(20574,2091,1,1,1,236), -- Tsurugi Blade
(20574,2092,1,1,1,236), -- Homunkulus\'s Sword Blade
(20574,2095,1,1,1,236), -- Sword of Nightmare Blade
(20574,2096,1,1,1,236), -- Sword of Whispering Death Blade
(20574,1539,1,1,2,12782), -- Greater Healing Potion
(20574,1864,1,1,2,115033), -- Stem
(20574,1869,1,1,2,57517), -- Iron Ore
(20574,1880,1,1,2,5752), -- Steel
(20574,4043,1,1,2,1918), -- Asofe
(20574,4122,1,1,2,2557), -- Recipe: Maestro Holder
(20574,4123,1,1,2,2557), -- Recipe: Maestro Anvil Lock
(20574,4609,1,1,2,128), -- Greater Dye of Mental Strength <Men+3 Int-3>
(20574,5550,1,1,2,767), -- Durable Metal Plate
(20575,1806,1,1,-1,2791), -- Recipe: Soulshot: B-Grade
(20575,1870,1,3,-1,697860), -- Coal
(20575,4598,1,1,-1,4652), -- Greater Dye of Mental Strength <Men+2 Wit-2>
(20575,57,562,1145,0,700000), -- Adena
(20575,135,1,1,1,5), -- Samurai Longsword
(20575,2115,1,1,1,591), -- Samurai Longsword Blade
(20575,5286,1,1,1,5), -- Berserker Blade
(20575,5530,1,1,1,592), -- Berserker Blade Edge
(20575,1865,1,1,2,57261), -- Varnish
(20575,1870,1,1,2,57261), -- Coal
(20575,1874,1,1,2,3818), -- Oriharukon Ore
(20575,4039,1,1,2,1909), -- Mold Glue
(20575,4043,1,1,2,1909), -- Asofe
(20575,4145,1,1,2,252), -- Recipe: Avadon Leather Armor
(20575,4180,1,1,2,6363), -- Recipe: Silver Arrow
(20575,4184,1,1,2,67), -- Recipe: Sprite\'s Staff
(20575,5165,1,1,2,115), -- Recipe: Blessed Spiritshot (B) Compressed Package (100%)
(20576,2119,1,1,-1,13217), -- Crystal Dagger Blade
(20576,4145,1,1,-1,12722), -- Recipe: Avadon Leather Armor
(20576,4591,1,1,-1,9669), -- Greater Dye of Constitution <Con+2 Str-2>
(20576,57,1169,2382,0,700000), -- Adena
(20576,119,1,1,1,64), -- Necklace of Binding
(20576,855,1,1,1,85), -- Nassen\'s Earring
(20576,886,1,1,1,127), -- Ring of Binding
(20576,1918,1,1,1,7730), -- Nassen\'s Earring Gemstone
(20576,1920,1,1,1,6107), -- Necklace of Binding Chain
(20576,2917,1,1,1,10252), -- Ring of Binding Gemstone
(20576,1865,1,1,2,118998), -- Varnish
(20576,1870,1,1,2,118998), -- Coal
(20576,1875,1,1,2,7934), -- Stone of Purity
(20576,1879,1,1,2,19833), -- Cokes
(20576,4040,1,1,2,2380), -- Mold Lubricant
(20576,4178,1,1,2,2185), -- Recipe: Zubei\'s Shield (100%)
(20576,4187,1,1,2,138), -- Recipe: Kris
(20576,5155,1,1,2,238), -- Recipe: Soulshot (B) Compressed Package (100%)
(20576,5275,1,1,2,238), -- Recipe: Greater Spiritshot (B) Compressed Package(100%)
(20577,351,1,1,-1,580), -- Blast Plate
(20577,2030,1,1,-1,6880), -- Tome of Blood Page
(20577,2154,1,1,-1,62979), -- Recipe: Elven Earring
(20577,57,248,496,0,700000), -- Adena
(20577,849,1,1,1,244), -- Tiger\'s Eye Earring
(20577,880,1,1,1,366), -- Black Pearl Ring
(20577,912,1,1,1,183), -- Near Forest Necklace
(20577,1901,1,1,1,10800), -- Tiger\'s Eye Earring Stone
(20577,1867,1,1,2,59573), -- Animal Skin
(20577,1872,1,1,2,59573), -- Animal Bone
(20577,1875,1,1,2,2979), -- Stone of Purity
(20577,1881,1,1,2,5958), -- Coarse Bone Powder
(20577,2154,1,1,2,4784), -- Recipe: Elven Earring
(20577,2270,1,1,2,320), -- Recipe: Goat Head Staff
(20577,2274,1,1,2,320), -- Recipe: Skull Breaker
(20578,1882,1,1,-1,142151), -- Leather
(20578,1901,1,1,-1,88354), -- Tiger\'s Eye Earring Stone
(20578,1939,1,1,-1,56186), -- Mithril Banded Gaiters Material
(20578,57,270,541,0,700000), -- Adena
(20578,278,1,1,1,36), -- Gastraphetes
(20578,2029,1,1,1,2029), -- Gastraphetes Shaft
(20578,1868,1,1,2,113372), -- Thread
(20578,1873,1,1,2,22675), -- Silver Nugget
(20578,1889,1,1,2,3780), -- Compound Braid
(20578,2273,1,1,2,405), -- Recipe: Tarbar
(20578,5549,1,1,2,5669), -- Metallic Thread
(20578,6037,1,1,2,113372), -- Waking Scroll
(20579,1889,1,1,-1,44463), -- Compound Braid
(20579,1943,1,1,-1,52975), -- Manticore Skin Gaiters Pattern
(20579,1946,1,1,-1,90129), -- Rip Gauntlets Pattern
(20579,57,282,562,0,700000), -- Adena
(20579,606,1,1,1,58), -- Rip Gauntlets
(20579,1124,1,1,1,58), -- Boots of Power
(20579,1946,1,1,1,2913), -- Rip Gauntlets Pattern
(20579,1948,1,1,1,2913), -- Boots of Power Pattern
(20579,2424,1,1,1,58), -- Manticore Skin Boots
(20579,2425,1,1,1,58), -- Brigandine Boots
(20579,2426,1,1,1,58), -- Elven Mithril Boots
(20579,2448,1,1,1,58), -- Manticore Skin Gloves
(20579,2449,1,1,1,58), -- Brigandine Gauntlets
(20579,2450,1,1,1,58), -- Elven Mithril Gloves
(20579,2923,1,1,1,2913), -- Manticore Skin Boot Lining
(20579,2924,1,1,1,2913), -- Brigandine Boots Design
(20579,2925,1,1,1,2913), -- Elven Mithril Boots Design
(20579,2926,1,1,1,2913), -- Manticore Skin Gloves Lining
(20579,2927,1,1,1,2913), -- Brigandine Gauntlets Pattern
(20579,2928,1,1,1,2913), -- Elven Mithril Gloves Design
(20579,1868,1,1,2,98504), -- Thread
(20579,1873,1,1,2,19701), -- Silver Nugget
(20579,1889,1,1,2,3284), -- Compound Braid
(20579,2146,1,1,2,3518), -- Recipe: Artisan\'s frame
(20579,2286,1,1,2,274), -- Recipe: Bonebreaker
(20579,5549,1,1,2,4926), -- Metallic Thread
(20579,6668,1,1,2,17591), -- Deluxe Chest Key - Grade 4
(20580,1868,1,5,-1,853135), -- Thread
(20580,1881,1,1,-1,170627), -- Coarse Bone Powder
(20580,2031,1,1,-1,12954), -- Morning Star Head
(20580,57,541,1080,0,700000), -- Adena
(20580,395,1,1,1,148), -- Manticore Skin Shirt
(20580,417,1,1,1,237), -- Manticore Skin Gaiters
(20580,1942,1,1,1,8435), -- Manticore Skin Shirt Texture
(20580,1943,1,1,1,13135), -- Manticore Skin Gaiters Pattern
(20580,1868,1,1,2,220503), -- Thread
(20580,1873,1,1,2,44101), -- Silver Nugget
(20580,1889,1,1,2,7351), -- Compound Braid
(20580,2194,1,1,2,11274), -- Recipe: Mithril Gloves
(20580,2288,1,1,2,613), -- Recipe: Ghost Staff
(20580,5549,1,1,2,11026), -- Metallic Thread
(20581,1902,1,1,-1,73432), -- Elven Earring Beads
(20581,2036,1,1,-1,7337), -- Skull Breaker Head
(20581,2202,1,1,-1,74108), -- Recipe: Assault Boots
(20581,57,307,611,0,700000), -- Adena
(20581,279,1,1,1,27), -- Strengthened Long Bow
(20581,2040,1,1,1,2168), -- Strengthened Long Bow Shaft
(20581,1341,10,30,2,138762), -- Bone Arrow
(20581,1875,1,1,2,2776), -- Stone of Purity
(20581,1879,1,1,2,6939), -- Cokes
(20581,1885,1,1,2,3469), -- High Grade Suede
(20581,2198,1,1,2,873), -- Recipe: Sage\'s Rag
(20581,2287,1,1,2,232), -- Recipe: Atuba Hammer
(20581,2293,1,1,2,232), -- Recipe: Glaive
(20581,5549,1,1,2,4163), -- Metallic Thread
(20581,5550,1,1,2,556), -- Durable Metal Plate
(20582,1825,1,1,-1,103022), -- Recipe: Oriharukon
(20582,1894,1,1,-1,50607), -- Crafted Leather
(20582,1942,1,1,-1,73568), -- Manticore Skin Shirt Texture
(20582,57,605,1207,0,700000), -- Adena
(20582,629,1,1,1,317), -- Kite Shield
(20582,1947,1,1,1,17893), -- Kite Shield Fragment
(20582,2411,1,1,1,222), -- Brigandine Helmet
(20582,2493,1,1,1,317), -- Brigandine Shield
(20582,2922,1,1,1,4786), -- Brigandine Helmet Design
(20582,2929,1,1,1,17893), -- Brigandine Shield Fragment
(20582,1341,20,60,2,177515), -- Bone Arrow
(20582,1864,1,3,2,71006), -- Stem
(20582,1869,1,1,2,106509), -- Iron Ore
(20582,1880,1,1,2,10651), -- Steel
(20582,2987,1,1,2,10341), -- Recipe: Plate Shield
(20582,3020,1,1,2,592), -- Recipe: Elven Long Sword
(20582,5550,1,1,2,1421), -- Durable Metal Plate
(20583,1903,1,1,-1,126810), -- Elven Ring Piece
(20583,1944,1,1,-1,38777), -- Mithril Tunic Fabric
(20583,2157,1,1,-1,62829), -- Recipe: Omen Beast\'s Eye Earring
(20583,57,319,636,0,700000), -- Adena
(20583,261,1,1,1,29), -- Bich\'Hwa
(20583,2039,1,1,1,1989), -- Bich\'Hwa Edge
(20583,3103,1,1,2,8187), -- Amulet: Pa\'agrio\'s Wisdom
(20583,3104,1,1,2,8187), -- Amulet: Pa\'agrio\'s Glory
(20583,3105,1,1,2,8188), -- Amulet: Seal of Winter
(20583,10062,1,1,2,6250), -- Battle Manual: Binding Trap
(20584,1805,1,1,-1,3432), -- Recipe: Soulshot: C-Grade
(20584,2211,1,1,-1,23082), -- Recipe: Plated Leather Armor
(20584,2988,1,1,-1,43437), -- Recipe: Tempered Mithril Gaiters
(20584,57,424,847,0,700000), -- Adena
(20584,280,1,1,1,29), -- Light Crossbow
(20584,2054,1,1,1,2201), -- Light Crossbow Shaft
(20584,3110,1,1,2,10770), -- Amulet: Seal of Scourge
(20584,3113,1,1,2,10770), -- Amulet: Pa\'agrio\'s Protection
(20584,3114,1,1,2,10770), -- Amulet: Steal Essence
(20584,10088,1,1,2,8621), -- Battle Manual: Real Target
(20585,1905,1,1,-1,98755), -- Omen Beast\'s Eye Earring Gemstone
(20585,2204,1,1,-1,20103), -- Recipe: Chain Mail Shirt
(20585,2308,1,1,-1,4433), -- Recipe: Cursed Dagger
(20585,57,415,839,0,700000), -- Adena
(20585,159,1,1,1,6), -- Bonebreaker
(20585,187,1,1,1,6), -- Atuba Hammer
(20585,188,1,1,1,6), -- Ghost Staff
(20585,189,1,1,1,6), -- Staff of Life
(20585,190,1,1,1,6), -- Atuba Mace
(20585,2048,1,1,1,422), -- Bonebreaker Head
(20585,2049,1,1,1,422), -- Atuba Hammer Head
(20585,2050,1,1,1,447), -- Ghost Staff Head
(20585,2051,1,1,1,447), -- Staff of Life Shaft
(20585,2058,1,1,1,422), -- Atuba Mace Head
(20585,3107,1,1,2,8828), -- Amulet: Seal of Gloom
(20585,3115,1,1,2,10621), -- Amulet: Freezing Flame
(20585,3117,1,1,2,10621), -- Amulet: Chant of Evasion
(20585,10066,1,1,2,4739), -- Battle Manual: Decoy
(20585,10041,1,1,2,3968), -- Battle Manual: Scorn
(20586,1884,1,1,-1,599116), -- Cord
(20586,2314,1,1,-1,4251), -- Recipe: Body Slasher
(20586,3954,1,1,-1,3245), -- Recipe: Blessed Spiritshot C
(20586,57,393,798,0,700000), -- Adena
(20586,70,1,1,1,14), -- Claymore
(20586,2047,1,1,1,1075), -- Claymore Blade
(20586,2499,1,1,1,14), -- Elven Long Sword
(20586,2967,1,1,1,1060), -- Elven Long Sword Blade
(20586,3108,1,1,2,6350), -- Amulet: Seal of Mirage
(20586,3112,1,1,2,6350), -- Amulet: Pa\'agrio\'s Eye
(20586,3118,1,1,2,6350), -- Amulet: Chant of Rage
(20586,6668,1,1,2,43650), -- Deluxe Chest Key - Grade 4
(20587,1875,1,1,-1,61186), -- Stone of Purity
(20587,1953,1,1,-1,29397), -- Sage\'s Rag Lining
(20587,2062,1,1,-1,7198), -- Scythe Edge
(20587,57,368,755,0,700000), -- Adena
(20587,89,1,1,1,3), -- Big Hammer
(20587,160,1,1,1,3), -- Battle Axe
(20587,161,1,1,1,3), -- Silver Axe
(20587,173,1,1,1,3), -- Skull Graver
(20587,191,1,1,1,3), -- Heavy Doom Hammer
(20587,192,1,1,1,3), -- Crystal Staff
(20587,193,1,1,1,3), -- Stick of Faith
(20587,194,1,1,1,3), -- Heavy Doom Axe
(20587,2061,1,1,1,210), -- Big Hammer Head
(20587,2063,1,1,1,210), -- Battle Axe Head
(20587,2064,1,1,1,210), -- Silver Axe Head
(20587,2065,1,1,1,210), -- Skull Graver Head
(20587,2066,1,1,1,213), -- Heavy Doom Hammer Head
(20587,2067,1,1,1,196), -- Crystal Staff Head
(20587,2068,1,1,1,196), -- Stick of Faith Shaft
(20587,2069,1,1,1,213), -- Heavy Doom Axe Blade
(20587,3106,1,1,2,6287), -- Amulet: Seal of Flame
(20587,3109,1,1,2,6287), -- Amulet: Seal of Silence
(20587,6397,1,1,2,7512), -- Amulet: Chant of Vampire
(20587,10037,1,1,2,5435), -- Battle Manual: Slashing Blade
(20588,1959,1,1,-1,48799), -- Chain Mail Shirt Material
(20588,2324,1,1,-1,6312), -- Recipe: Elven Bow of Nobility
(20588,57,487,990,0,700000), -- Adena
(20588,71,1,1,1,13), -- Flamberge
(20588,72,1,1,1,13), -- Stormbringer
(20588,2059,1,1,1,1060), -- Flamberge Blade
(20588,2060,1,1,1,1134), -- Stormbringer Blade
(20588,3111,1,1,2,12409), -- Amulet: Seal of Suspension
(20588,3116,1,1,2,12409), -- Amulet: Chant of Fury
(20588,10187,1,1,2,8197), -- Battle Manual: Oblivion
(20588,10053,1,1,2,5376), -- Battle Manual: Rising Shot
(20588,10081,1,1,2,8196), -- Battle Manual: Soul To Empower
(20589,1908,1,1,-1,170964), -- Moonstone Earring Wire
(20589,1961,1,1,-1,57772), -- Mithril Shirt Fabric
(20589,1962,1,1,-1,57772), -- Karmian Tunic Pattern
(20589,57,729,1480,0,700000), -- Adena
(20589,439,1,1,1,113), -- Karmian Tunic
(20589,471,1,1,1,181), -- Karmian Stockings
(20589,1954,1,1,1,11341), -- Karmian Stocking Design
(20589,1962,1,1,1,6827), -- Karmian Tunic Pattern
(20589,3082,1,1,2,13332), -- Spellbook: Surrender to Water
(20589,3085,1,1,2,13332), -- Spellbook: Hydro Blast
(20589,3086,1,1,2,13332), -- Spellbook: Frost Bolt
(20589,3088,1,1,2,13332), -- Spellbook: Freezing Skin
(20589,10046,1,1,2,8475), -- Battle Manual: Dark Flame
(20590,2068,1,1,-1,13465), -- Stick of Faith Shaft
(20590,2163,1,1,-1,95320), -- Recipe: Earring of Protection
(20590,2935,1,1,-1,99323), -- Tempered Mithril Gaiters Fragment
(20590,57,751,1535,0,700000), -- Adena
(20590,354,1,1,1,88), -- Chain Mail Shirt
(20590,381,1,1,1,140), -- Chain Gaiters
(20590,1959,1,1,1,5947), -- Chain Mail Shirt Material
(20590,1960,1,1,1,12097), -- Chain Gaiters Part
(20590,3090,1,1,2,13797), -- Spellbook: Hurricane
(20590,3092,1,1,2,13797), -- Spellbook: Servitor Physical Shield
(20590,3094,1,1,2,13797), -- Spellbook: Invigor
(20590,3098,1,1,2,13797), -- Spellbook: Return
(20590,10083,1,1,2,6410), -- Battle Manual: Dark Weapon
(20590,10189,1,1,2,7407), -- Battle Manual: Protection Instinct
(20591,951,1,1,-1,3983), -- Scroll: Enchant Weapon (Grade C)
(20591,1911,1,1,-1,162953), -- Earring of Protection Gemstone
(20591,2947,1,1,-1,156493), -- Dwarven Chain Shield Fragment
(20591,57,882,1799,0,700000), -- Adena
(20591,94,1,1,1,34), -- Bec de Corbin
(20591,2079,1,1,1,3336), -- Bec De Corbin Blade
(20591,3040,1,1,2,10495), -- Spellbook: Summon Vampiric Cubic
(20591,3100,1,1,2,12135), -- Spellbook: Guidance
(20591,3101,1,1,2,12135), -- Spellbook: Death Whisper
(20591,3102,1,1,2,12135), -- Spellbook: Bless Shield
(20591,6395,1,1,2,8442), -- Amulet: Chant of Predator
(20592,1880,1,1,-1,301213), -- Steel
(20592,2166,1,1,-1,102106), -- Recipe: Earrings of Binding (100%)
(20592,2951,1,1,-1,253333), -- Rind Leather Gloves Design
(20592,57,1215,2470,0,700000), -- Adena
(20592,195,1,1,1,24), -- Cursed Staff
(20592,2082,1,1,1,2352), -- Cursed Staff Head
(20592,2502,1,1,1,24), -- Dwarven War Hammer
(20592,2968,1,1,1,2252), -- Dwarven Warhammer Head
(20592,3045,1,1,2,14429), -- Spellbook: Summon Life Cubic
(20592,3047,1,1,2,14429), -- Spellbook: Iron Will
(20592,3052,1,1,2,14429), -- Spellbook: Hamstring
(20592,3057,1,1,2,13867), -- Spellbook: Summon Reanimated Man 
(20592,6396,1,1,2,11606), -- Amulet: Chant of Eagle
(20592,10043,1,1,2,10753), -- Battle Manual: Shining Edge
(20593,1912,1,1,-1,348570), -- Ring of Protection Gemstone
(20593,2083,1,1,-1,21493), -- Stiletto Edge
(20593,2341,1,1,-1,7523), -- Recipe: Sage\'s Staff
(20593,57,1302,2656,0,700000), -- Adena
(20593,398,1,1,1,81), -- Plated Leather
(20593,399,1,1,1,75), -- Rind Leather Armor
(20593,418,1,1,1,129), -- Plated Leather Gaiters
(20593,419,1,1,1,119), -- Rind Leather Gaiters
(20593,1966,1,1,1,6541), -- Plated Leather Fragment
(20593,1967,1,1,1,9770), -- Plated Leather Gaiters Material
(20593,1975,1,1,1,5884), -- Rind Leather Armor Design
(20593,1976,1,1,1,10893), -- Rind Leather Gaiters Material
(20593,3060,1,1,2,12409), -- Spellbook: Forget
(20593,3063,1,1,2,12409), -- Spellbook: Anchor
(20593,3065,1,1,2,12409), -- Spellbook: Death Spike
(20593,3069,1,1,2,12409), -- Spellbook: Repose
(20593,6398,1,1,2,10386), -- Spellbook: Body of Avatar
(20593,10059,1,1,2,8403), -- Battle Manual: Poison Trap
(20593,10184,1,1,2,8130), -- Battle Manual: Restoration Impact
(20593,6668,1,1,2,85312), -- Deluxe Chest Key - Grade 4
(20594,1871,1,5,-1,737538), -- Charcoal
(20594,1895,1,1,-1,632176), -- Metallic Fiber
(20594,1978,1,1,-1,141834), -- Tower Shield Fragment
(20594,57,893,1815,0,700000), -- Adena
(20594,231,1,1,1,11), -- Grace Dagger
(20594,233,1,1,1,11), -- Dark Screamer
(20594,2106,1,1,1,1247), -- Grace Dagger Edge
(20594,2107,1,1,1,1247), -- Dark Screamer Edge
(20594,3072,1,1,2,11884), -- Spellbook: Purify
(20594,3080,1,1,2,11884), -- Spellbook: Sleeping Cloud
(20594,3084,1,1,2,11884), -- Spellbook: Freezing Shackle
(20594,3087,1,1,2,11884), -- Spellbook: Ice Dagger
(20594,10036,1,1,2,8065), -- Battle Manual: Spread Wing
(20595,1894,1,1,-1,80892), -- Crafted Leather
(20595,2096,1,1,-1,12564), -- Sword of Whispering Death Blade
(20595,2354,1,1,-1,3761), -- Recipe: Deadman\'s Staff
(20595,57,931,1891,0,700000), -- Adena
(20595,231,1,1,1,12), -- Grace Dagger
(20595,233,1,1,1,12), -- Dark Screamer
(20595,2106,1,1,1,1299), -- Grace Dagger Edge
(20595,2107,1,1,1,1299), -- Dark Screamer Edge
(20595,3091,1,1,2,12382), -- Spellbook: Servitor Magic Shield
(20595,3093,1,1,2,12382), -- Spellbook: Servitor Haste
(20595,3095,1,1,2,12382), -- Spellbook: Magic Barrier
(20595,3096,1,1,2,12382), -- Spellbook: Bless the Body
(20595,10092,1,1,2,5348), -- Battle Manual: Shadow Bind
(20595,10055,1,1,2,6711), -- Battle Manual: Temptation
(20596,1539,1,1,-1,543597), -- Greater Healing Potion
(20596,1875,1,1,-1,163079), -- Stone of Purity
(20596,4609,1,1,-1,5436), -- Greater Dye of Mental Strength <Men+3 Int-3>
(20596,57,991,2003,0,700000), -- Adena
(20596,162,1,1,1,3), -- War Axe
(20596,174,1,1,1,3), -- Nirvana Axe
(20596,196,1,1,1,3), -- Stick of Eternity
(20596,197,1,1,1,3), -- Paradia Staff
(20596,199,1,1,1,3), -- Pa\'agrian Hammer
(20596,200,1,1,1,3), -- Sage\'s Staff
(20596,201,1,1,1,3), -- Club of Nature
(20596,202,1,1,1,3), -- Mace of The Underworld
(20596,2097,1,1,1,339), -- War Axe Blade
(20596,2098,1,1,1,339), -- Nirvana Axe Blade
(20596,2099,1,1,1,357), -- Stick of Eternity Shaft
(20596,2100,1,1,1,357), -- Paradia Staff Head
(20596,2102,1,1,1,344), -- Pa\'agrian Hammer Head
(20596,2103,1,1,1,357), -- Sage\'s Staff Head
(20596,2104,1,1,1,357), -- Club of Nature Head
(20596,2105,1,1,1,339), -- Mace of The Underworld Head
(20596,3043,1,1,2,11901), -- Spellbook: Holy Strike
(20596,3044,1,1,2,11901), -- Spellbook: Horror
(20596,3097,1,1,2,13138), -- Spellbook: Bless the Soul
(20596,3099,1,1,2,13138), -- Spellbook: Haste
(20596,10044,1,1,2,5556), -- Battle Manual: Checkmate
(20596,10071,1,1,2,4630), -- Battle Manual: Quiver Of Bolts - Grade B
(20596,10190,1,1,2,5319), -- Battle Manual: Vampiric Impulse
(20597,1918,1,1,-1,176400), -- Nassen\'s Earring Gemstone
(20597,2113,1,1,-1,19724), -- Scorpion Blade
(20597,3034,1,1,-1,8146), -- Recipe: Spiritshot B
(20597,57,1644,3340,0,700000), -- Adena
(20597,442,1,1,1,71), -- Divine Tunic
(20597,473,1,1,1,113), -- Divine Stockings
(20597,1988,1,1,1,7225), -- Divine Tunic Fabric
(20597,1989,1,1,1,11333), -- Divine Stocking Pattern
(20597,3049,1,1,2,11796), -- Spellbook: Corpse Plague
(20597,3059,1,1,2,10898), -- Spellbook: Corpse Burst
(20597,3068,1,1,2,10898), -- Spellbook: Vitalize
(20597,3070,1,1,2,10898), -- Spellbook: Hold Undead
(20597,4184,1,1,2,289), -- Recipe: Sprite\'s Staff
(20597,6669,1,1,2,58291), -- Deluxe Chest Key - Grade 5
(20598,1806,1,1,-1,7537), -- Recipe: Soulshot: B-Grade
(20598,2120,1,1,-1,18102), -- Great Pata Blade
(20598,4180,1,1,-1,418716), -- Recipe: Silver Arrow
(20598,57,1518,3092,0,700000), -- Adena
(20598,442,1,1,1,66), -- Divine Tunic
(20598,473,1,1,1,104), -- Divine Stockings
(20598,1988,1,1,1,6685), -- Divine Tunic Fabric
(20598,1989,1,1,1,10486), -- Divine Stocking Pattern
(20598,3054,1,1,2,14494), -- Spellbook: Summon Viper Cubic
(20598,3078,1,1,2,15125), -- Spellbook: Decay
(20598,3079,1,1,2,15125), -- Spellbook: Cancel
(20598,3089,1,1,2,15125), -- Spellbook: Tempest
(20598,8946,1,1,2,4717), -- Spellbook: Invocation
(20599,2120,1,1,-1,18800), -- Great Pata Blade
(20599,4146,1,1,-1,25088), -- Recipe: Tunic of Zubei
(20599,4590,1,1,-1,13046), -- Greater Dye of Strength <Str+2 Dex-2>
(20599,57,1577,3213,0,700000), -- Adena
(20599,2436,1,1,1,76), -- Theca Leather Boots
(20599,2437,1,1,1,58), -- Drake Leather Boots
(20599,2438,1,1,1,58), -- Full Plate Boots
(20599,2460,1,1,1,76), -- Theca Leather Gloves
(20599,2461,1,1,1,58), -- Drake Leather Gloves
(20599,2462,1,1,1,58), -- Full Plate Gauntlets
(20599,2463,1,1,1,58), -- Divine Gloves
(20599,2954,1,1,1,6534), -- Theca Leather Boots Texture
(20599,2955,1,1,1,6534), -- Theca Leather Gloves Texture
(20599,2960,1,1,1,5622), -- Drake Leather Boots Design
(20599,2961,1,1,1,5622), -- Full Plate Boots Part
(20599,2962,1,1,1,5622), -- Drake Leather Gloves Design
(20599,2963,1,1,1,5622), -- Full Plate Gauntlets Part
(20599,2964,1,1,1,5622), -- Divine Gloves Pattern
(20599,3046,1,1,2,13381), -- Spellbook: Sacrifice
(20599,3055,1,1,2,10705), -- Spellbook: Lightening Strike
(20599,3066,1,1,2,13381), -- Spellbook: Curse Death Link
(20599,3083,1,1,2,13381), -- Spellbook: Frost Wall
(20599,10191,1,1,2,6849), -- Battle Manual: Magic Impulse
(20599,10060,1,1,2,7752), -- Battle Manual: Slow Trap
(20600,1825,1,1,-1,63980), -- Recipe: Oriharukon
(20600,1873,1,1,-1,358285), -- Silver Nugget
(20600,1945,1,1,-1,71145), -- Mithril Stocking Design
(20600,57,376,750,0,700000), -- Adena
(20600,629,1,1,1,197), -- Kite Shield
(20600,1947,1,1,1,11112), -- Kite Shield Fragment
(20600,2411,1,1,1,138), -- Brigandine Helmet
(20600,2493,1,1,1,197), -- Brigandine Shield
(20600,2922,1,1,1,2973), -- Brigandine Helmet Design
(20600,2929,1,1,1,11112), -- Brigandine Shield Fragment
(20600,1868,1,1,2,154339), -- Thread
(20600,1873,1,1,2,30868), -- Silver Nugget
(20600,1889,1,1,2,5145), -- Compound Braid
(20600,2286,1,1,2,429), -- Recipe: Bonebreaker
(20600,5231,1,1,2,5513), -- Recipe: Metal Hardener (100%)
(20600,5549,1,1,2,7717), -- Metallic Thread
(20601,1880,1,1,-1,79830), -- Steel
(20601,1905,1,1,-1,77656), -- Omen Beast\'s Eye Earring Gemstone
(20601,2304,1,1,-1,3486), -- Recipe: Heavy Doom Hammer
(20601,57,328,657,0,700000), -- Adena
(20601,353,1,1,1,52), -- Half Plate Armor
(20601,380,1,1,1,83), -- Plate Gaiters
(20601,1950,1,1,1,3253), -- Half Plate Temper
(20601,1951,1,1,1,5059), -- Plate Gaiters Part
(20601,1864,1,1,2,133624), -- Stem
(20601,1869,1,1,2,66812), -- Iron Ore
(20601,1880,1,1,2,6682), -- Steel
(20601,2199,1,1,2,2819), -- Recipe: Karmian Stockings
(20601,5269,1,1,2,223), -- Recipe: Greater Soulshot (C) Compressed Package(100%)
(20601,5550,1,1,2,891), -- Durable Metal Plate
(20602,1873,1,1,-1,431425), -- Silver Nugget
(20602,1889,1,1,-1,71904), -- Compound Braid
(20602,2999,1,1,-1,72387), -- Recipe: Plated Leather Gloves
(20602,57,441,891,0,700000), -- Adena
(20602,280,1,1,1,31), -- Light Crossbow
(20602,2054,1,1,1,2305), -- Light Crossbow Shaft
(20602,1868,1,1,2,135402), -- Thread
(20602,1873,1,1,2,27081), -- Silver Nugget
(20602,1876,1,1,2,13541), -- Mithril Ore
(20602,1895,1,1,2,19344), -- Metallic Fiber
(20602,2205,1,1,2,2143), -- Recipe: Chain Gaiters
(20602,2300,1,1,2,296), -- Recipe: Scythe
(20602,2311,1,1,2,296), -- Recipe: Chakram
(20602,5154,1,1,2,226), -- Recipe: Soulshot (C) Compressed Package (100%)
(20603,1872,1,3,-1,590512), -- Animal Bone
(20603,1952,1,1,-1,28372), -- Salamander Skin Mail Texture
(20603,2311,1,1,-1,3868), -- Recipe: Chakram
(20603,57,357,726,0,700000), -- Adena
(20603,61,1,1,1,76), -- Mithril Gloves
(20603,607,1,1,1,76), -- Ogre Power Gauntlets
(20603,1125,1,1,1,76), -- Assault Boots
(20603,1949,1,1,1,4137), -- Mithril Gloves Design
(20603,1957,1,1,1,4137), -- Assault Boots Part
(20603,1963,1,1,1,4137), -- Ogre Power Gauntlets Part
(20603,2427,1,1,1,76), -- Salamander Skin Boots
(20603,2428,1,1,1,76), -- Plate Boots
(20603,2451,1,1,1,76), -- Sage\'s Worn Gloves
(20603,2931,1,1,1,4137), -- Salamander Skin Boot Lining
(20603,2932,1,1,1,4137), -- Plate Boots Design
(20603,2933,1,1,1,4137), -- Sage\'s Worn Gloves Lining
(20603,1867,1,1,2,84723), -- Animal Skin
(20603,1872,1,1,2,84723), -- Animal Bone
(20603,1875,1,1,2,4237), -- Stone of Purity
(20603,1881,1,1,2,8473), -- Coarse Bone Powder
(20603,2991,1,1,2,5044), -- Recipe: Karmian Boots
(20603,5279,1,1,2,212), -- Recipe: Greater Blessed Spiritshot (C) Compressed Package(100%)
(20603,6668,1,1,2,22694), -- Deluxe Chest Key - Grade 4
(20604,2322,1,1,-1,3768), -- Recipe: Soulfire Dirk
(20604,2323,1,1,-1,3768), -- Recipe: Elemental Bow
(20604,4553,1,1,-1,4325), -- Greater Dye of Strength <Str+1 Con-1>
(20604,57,434,890,0,700000), -- Adena
(20604,852,1,1,1,110), -- Moonstone Earring
(20604,883,1,1,1,166), -- Aquastone Ring
(20604,915,1,1,1,83), -- Aquastone Necklace
(20604,1908,1,1,1,8066), -- Moonstone Earring Wire
(20604,1909,1,1,1,11502), -- Aquastone Ring Wire
(20604,1910,1,1,1,6414), -- Aquastone Necklace Chain
(20604,4205,1,1,2,8850), -- Amulet: Pa\'agrio\'s Rage
(20604,4207,1,1,2,10648), -- Spellbook: Mana Regeneration
(20604,4208,1,1,2,8850), -- Spellbook: Curse Gloom
(20604,10045,1,1,2,7092), -- Battle Manual: Soul Of Pain
(20605,1867,1,3,-1,653559), -- Animal Skin
(20605,1908,1,1,-1,92835), -- Moonstone Earring Wire
(20605,2059,1,1,-1,7282), -- Flamberge Blade
(20605,57,396,804,0,700000), -- Adena
(20605,439,1,1,1,62), -- Karmian Tunic
(20605,471,1,1,1,98), -- Karmian Stockings
(20605,1954,1,1,1,6159), -- Karmian Stocking Design
(20605,1962,1,1,1,3707), -- Karmian Tunic Pattern
(20605,1868,1,1,2,132379), -- Thread
(20605,1873,1,1,2,26476), -- Silver Nugget
(20605,1889,1,1,2,4413), -- Compound Braid
(20605,2214,1,1,2,1643), -- Recipe: Dwarven Chain Gaiters
(20605,3003,1,1,2,4112), -- Recipe: Gloves of Seal
(20605,4044,1,1,2,2207), -- Thons
(20605,5549,1,1,2,6619), -- Metallic Thread
(20606,1932,1,1,-1,104301), -- Bone Helmet Design
(20606,2152,1,1,-1,115686), -- Recipe: Enchanted Necklace
(20606,2260,1,1,-1,10203), -- Recipe: Mace of Judgment
(20606,57,284,547,0,700000), -- Adena
(20606,220,1,1,1,180), -- Crafted Dagger
(20606,1864,1,1,2,147514), -- Stem
(20606,1869,1,1,2,73757), -- Iron Ore
(20606,1880,1,1,2,7376), -- Steel
(20606,2262,1,1,2,1146), -- Recipe: Elven Bow
(20606,5550,1,1,2,984), -- Durable Metal Plate
(20607,626,1,1,-1,6308), -- Bronze Shield
(20607,1899,1,1,-1,107923), -- Necklace of Devotion Chain
(20607,2020,1,1,-1,12091), -- Temptation of Abyss Piece
(20607,57,296,580,0,700000), -- Adena
(20607,101,1,1,1,38), -- Scroll of Wisdom
(20607,312,1,1,1,38), -- Branch of Life
(20607,313,1,1,1,38), -- Temptation of Abyss
(20607,314,1,1,1,38), -- Proof of Revenge
(20607,2020,1,1,1,1358), -- Temptation of Abyss Piece
(20607,1865,1,1,2,96912), -- Varnish
(20607,1870,1,1,2,96912), -- Coal
(20607,1874,1,1,2,6461), -- Oriharukon Ore
(20607,2262,1,1,2,1505), -- Recipe: Elven Bow
(20608,1874,1,1,-1,46394), -- Oriharukon Ore
(20608,2022,1,1,-1,10840), -- Mace of Judgment Head
(20608,2153,1,1,-1,108228), -- Recipe: Tiger\'s Eye Earring
(20608,57,295,584,0,700000), -- Adena
(20608,315,1,1,1,118), -- Divine Tome
(20608,1867,1,1,2,72436), -- Animal Skin
(20608,1872,1,1,2,72436), -- Animal Bone
(20608,1875,1,1,2,3622), -- Stone of Purity
(20608,1881,1,1,2,7244), -- Coarse Bone Powder
(20608,2189,1,1,2,2426), -- Recipe: Mithril Tunic
(20608,2265,1,1,2,562), -- Recipe: Spiked Club
(20608,2274,1,1,2,389), -- Recipe: Skull Breaker
(20609,433,1,1,-1,1447), -- Elven Tunic
(20609,1900,1,1,-1,79072), -- Enchanted Necklace Chain
(20609,2265,1,1,-1,7474), -- Recipe: Spiked Club
(20609,57,305,610,0,700000), -- Adena
(20609,259,1,1,1,123), -- Single-Edged Jamadhr
(20609,956,1,1,2,2195), -- Scroll: Enchant Armor (Grade D)
(20609,1866,1,1,2,43883), -- Suede
(20609,1871,1,1,2,65824), -- Charcoal
(20609,1885,1,1,2,5486), -- High Grade Suede
(20609,5220,1,1,2,2633), -- Metal Hardener
(20609,6667,1,1,2,41140), -- Deluxe Chest Key - Grade 3
(20610,1864,1,3,-1,728584), -- Stem
(20610,2025,1,1,-1,10091), -- Dwarven Trident Edge
(20610,2267,1,1,-1,7534), -- Recipe: Gastraphetes
(20610,57,308,614,0,700000), -- Adena
(20610,292,1,1,1,124), -- Pike
(20610,1341,10,30,2,165893), -- Bone Arrow
(20610,1864,1,1,2,99536), -- Stem
(20610,1865,1,1,2,49768), -- Varnish
(20610,1866,1,1,2,33179), -- Suede
(20610,1868,1,1,2,99536), -- Thread
(20610,1873,1,1,2,19908), -- Silver Nugget
(20610,2183,1,1,2,3275), -- Recipe: Mithril Banded Mail
(20610,2270,1,1,2,356), -- Recipe: Goat Head Staff
(20611,467,1,1,-1,2468), -- Dark Stockings
(20611,1884,1,1,-1,474660), -- Cord
(20611,2153,1,1,-1,119957), -- Recipe: Tiger\'s Eye Earring
(20611,57,325,652,0,700000), -- Adena
(20611,86,1,1,1,14), -- Tomahawk
(20611,179,1,1,1,14), -- Mace of Prayer
(20611,180,1,1,1,14), -- Mace of Judgment
(20611,181,1,1,1,14), -- Mace of Miracle
(20611,182,1,1,1,14), -- Doom Hammer
(20611,183,1,1,1,14), -- Mystic Staff
(20611,184,1,1,1,14), -- Conjuror\'s Staff
(20611,185,1,1,1,14), -- Staff of Mana
(20611,2022,1,1,1,657), -- Mace of Judgment Head
(20611,2023,1,1,1,523), -- Conjuror\'s Staff Head
(20611,1829,1,1,2,24086), -- Scroll of Escape: Clan Hall
(20611,1834,1,1,2,66905), -- Emergency Dressing
(20611,1864,1,1,2,120428), -- Stem
(20611,1869,1,1,2,60214), -- Iron Ore
(20611,1878,1,1,2,24086), -- Braided Hemp
(20611,1884,1,1,2,37055), -- Cord
(20611,2193,1,1,2,8061), -- Recipe: Boots of Power
(20612,349,1,1,-1,961), -- Compound Scale Mail
(20612,1869,1,1,-1,879358), -- Iron Ore
(20612,1885,1,1,-1,73280), -- High Grade Suede
(20612,57,372,743,0,700000), -- Adena
(20612,436,1,1,1,308), -- Tunic of Knowledge
(20612,469,1,1,1,492), -- Stockings of Knowledge
(20612,1832,1,1,2,74215), -- Greater Antidote
(20612,1866,1,1,2,44529), -- Suede
(20612,1871,1,1,2,66793), -- Charcoal
(20612,1885,1,1,2,5567), -- High Grade Suede
(20612,2188,1,1,2,4771), -- Recipe: Manticore Skin Gaiters
(20612,2274,1,1,2,478), -- Recipe: Skull Breaker
(20612,5220,1,1,2,2672), -- Metal Hardener
(20613,40,1,1,-1,6288), -- Leather Boots
(20613,1899,1,1,-1,102672), -- Necklace of Devotion Chain
(20613,1934,1,1,-1,85895), -- Crafted Leather Gloves Lining
(20613,57,284,547,0,700000), -- Adena
(20613,432,1,1,1,589), -- Cursed Tunic
(20613,465,1,1,1,944), -- Cursed Stockings
(20613,1831,1,1,2,140490), -- Antidote
(20613,1864,1,1,2,105368), -- Stem
(20613,1865,1,1,2,52684), -- Varnish
(20613,1866,1,1,2,35123), -- Suede
(20613,1868,1,1,2,105368), -- Thread
(20613,1873,1,1,2,21074), -- Silver Nugget
(20613,2263,1,1,2,819), -- Recipe: Dwarven Trident
(20614,1869,1,1,-1,645491), -- Iron Ore
(20614,1899,1,1,-1,100858), -- Necklace of Devotion Chain
(20614,2152,1,1,-1,113643), -- Recipe: Enchanted Necklace
(20614,57,277,542,0,700000), -- Adena
(20614,220,1,1,1,177), -- Crafted Dagger
(20614,1834,1,1,2,80505), -- Emergency Dressing
(20614,1865,1,1,2,72455), -- Varnish
(20614,1870,1,1,2,72455), -- Coal
(20614,1874,1,1,2,4831), -- Oriharukon Ore
(20614,2263,1,1,2,1126), -- Recipe: Dwarven Trident
(20615,392,1,1,-1,1491), -- Lion Skin Shirt
(20615,1900,1,1,-1,81472), -- Enchanted Necklace Chain
(20615,2185,1,1,-1,146585), -- Recipe: Iron Boots
(20615,57,316,625,0,700000), -- Adena
(20615,46,1,1,1,814), -- Bronze Helmet
(20615,627,1,1,1,1163), -- Aspis
(20615,1834,1,1,2,64592), -- Emergency Dressing
(20615,1875,1,1,2,3876), -- Stone of Purity
(20615,1879,1,1,2,9689), -- Cokes
(20615,1885,1,1,2,4845), -- High Grade Suede
(20615,2266,1,1,2,602), -- Recipe: Shilen Knife
(20615,5549,1,1,2,5814), -- Metallic Thread
(20615,5550,1,1,2,776), -- Durable Metal Plate
(20616,1874,1,1,-1,51402), -- Oriharukon Ore
(20616,1937,1,1,-1,66239), -- Scale Gaiters Fragment
(20616,2153,1,1,-1,119911), -- Recipe: Tiger\'s Eye Earring
(20616,57,325,650,0,700000), -- Adena
(20616,433,1,1,1,106), -- Elven Tunic
(20616,434,1,1,1,106), -- White Tunic
(20616,435,1,1,1,106), -- Mystic\'s Tunic
(20616,466,1,1,1,169), -- Elven Stockings
(20616,467,1,1,1,169), -- Dark Stockings
(20616,468,1,1,1,169), -- Mystic\'s Stockings
(20616,1933,1,1,1,6197), -- Dark Stocking Fabric
(20616,1936,1,1,1,4310), -- White Tunic Pattern
(20616,737,1,1,2,5267), -- Scroll of Resurrection
(20616,1867,1,1,2,70223), -- Animal Skin
(20616,1872,1,1,2,70223), -- Animal Bone
(20616,1875,1,1,2,3512), -- Stone of Purity
(20616,1881,1,1,2,7023), -- Coarse Bone Powder
(20616,2274,1,1,2,377), -- Recipe: Skull Breaker
(20616,2976,1,1,2,7051), -- Recipe: Manticore Skin Boots
(20616,6667,1,1,2,32917), -- Deluxe Chest Key - Grade 3
(20617,435,1,1,-1,1473), -- Mystic\'s Tunic
(20617,1875,1,1,-1,49053), -- Stone of Purity
(20617,1933,1,1,-1,86564), -- Dark Stocking Fabric
(20617,57,311,620,0,700000), -- Adena
(20617,392,1,1,1,403), -- Lion Skin Shirt
(20617,414,1,1,1,644), -- Lion Skin Gaiters
(20617,1867,1,1,2,107223), -- Animal Skin
(20617,1872,1,1,2,107223), -- Animal Bone
(20617,1875,1,1,2,5362), -- Stone of Purity
(20617,1881,1,1,2,10723), -- Coarse Bone Powder
(20617,2184,1,1,2,8447), -- Recipe: Mithril Banded Gaiters
(20618,955,1,1,-1,3251), -- Scroll: Enchant Weapon (Grade D)
(20618,1885,1,1,-1,67733), -- High Grade Suede
(20618,1935,1,1,-1,45407), -- Scale Mail Fragment
(20618,57,342,687,0,700000), -- Adena
(20618,315,1,1,1,138), -- Divine Tome
(20618,1875,1,1,2,4936), -- Stone of Purity
(20618,1879,1,1,2,12338), -- Cokes
(20618,1885,1,1,2,6169), -- High Grade Suede
(20618,2153,1,1,2,11513), -- Recipe: Tiger\'s Eye Earring
(20618,5549,1,1,2,7403), -- Metallic Thread
(20618,5550,1,1,2,988), -- Durable Metal Plate
(20619,1867,1,3,-1,556329), -- Animal Skin
(20619,2270,1,1,-1,5961), -- Recipe: Goat Head Staff
(20619,2981,1,1,-1,111713), -- Recipe: Elven Mithril Gloves
(20619,57,353,705,0,700000), -- Adena
(20619,157,1,1,1,31), -- Spiked Club
(20619,186,1,1,1,31), -- Staff of Magic
(20619,2027,1,1,1,1938), -- Spiked Club Head
(20619,1867,1,1,2,98599), -- Animal Skin
(20619,1872,1,1,2,98599), -- Animal Bone
(20619,1875,1,1,2,4930), -- Stone of Purity
(20619,1881,1,1,2,9860), -- Coarse Bone Powder
(20619,2154,1,1,2,7918), -- Recipe: Elven Earring
(20619,2278,1,1,2,528), -- Recipe: Strengthened Long Bow
(20620,948,1,1,-1,10769), -- Scroll: Enchant Armor (Grade B)
(20620,4039,1,1,-1,143581), -- Mold Glue
(20620,4051,1,1,-1,167052), -- Adamantite Necklace Chain
(20620,57,1741,3531,0,700000), -- Adena
(20620,78,1,1,1,5), -- Great Sword
(20620,142,1,1,1,5), -- Keshanberk
(20620,148,1,1,1,5), -- Sword of Valhalla
(20620,4104,1,1,1,1214), -- Great Sword Blade
(20620,4107,1,1,1,1195), -- Keshanberk Blade
(20620,4108,1,1,1,1195), -- Sword of Valhalla Blade
(20620,1894,1,1,2,6378), -- Crafted Leather
(20620,4039,1,1,2,6059), -- Mold Glue
(20620,4041,1,1,2,1581), -- Mold Hardener
(20620,4044,1,1,2,6059), -- Thons
(20620,4402,1,1,2,364), -- Blue Dimensional Stone
(20620,4614,1,1,2,251), -- Greater Dye of Strength <Str+4 Dex-4>
(20620,4999,1,1,2,2261), -- Recipe: Doom Boots (60%)
(20621,4052,1,1,-1,164789), -- Earring of Black Ore Piece
(20621,4199,1,1,-1,3553), -- Recipe: Bow of Peril
(20621,5230,1,1,-1,6206), -- Recipe: Mithril Arrow (100%)
(20621,57,1883,3814,0,700000), -- Adena
(20621,2391,1,1,1,20), -- Blue Wolf Leather Armor
(20621,2392,1,1,1,20), -- Leather Armor of Doom
(20621,4082,1,1,1,3884), -- Blue Wolf Leather Armor Texture
(20621,4083,1,1,1,3884), -- Leather Armor of Doom Design
(20621,1868,1,3,2,196409), -- Thread
(20621,1873,1,1,2,78564), -- Silver Nugget
(20621,1876,1,1,2,39282), -- Mithril Ore
(20621,1895,1,1,2,56117), -- Metallic Fiber
(20621,4042,1,1,2,3274), -- Enria
(20621,4623,1,1,2,271), -- Greater Dye of Wit <Wit+4 Int-4>
(20621,5276,1,1,2,262), -- Recipe: Greater Spiritshot (A) Compressed Package(100%)
(20622,4042,1,1,-1,83042), -- Enria
(20622,4044,1,1,-1,166084), -- Thons
(20622,4053,1,1,-1,213567), -- Ring of Black Ore Gemstone
(20622,57,2016,4081,0,700000), -- Adena
(20622,864,1,1,1,54), -- Earring of Black Ore
(20622,895,1,1,1,80), -- Ring of Black Ore
(20622,926,1,1,1,40), -- Necklace of Black Ore
(20622,4052,1,1,1,8684), -- Earring of Black Ore Piece
(20622,4053,1,1,1,10513), -- Ring of Black Ore Gemstone
(20622,4054,1,1,1,4831), -- Necklace of Black Ore Beads
(20622,1867,1,3,2,122647), -- Animal Skin
(20622,1872,1,1,2,245294), -- Animal Bone
(20622,1882,1,1,2,40883), -- Leather
(20622,1894,1,1,2,6456), -- Crafted Leather
(20622,4042,1,1,2,3067), -- Enria
(20622,4401,1,1,2,369), -- Green Dimensional Stone
(20622,4988,1,1,2,1219), -- Recipe: Blue Wolf Stockings (60%)
(20622,6670,1,1,2,30662), -- Deluxe Chest Key - Grade 6
(20623,4039,1,1,-1,222007), -- Mold Glue
(20623,4040,1,1,-1,133204), -- Mold Lubricant
(20623,5230,1,1,-1,8880), -- Recipe: Mithril Arrow (100%)
(20623,57,2697,5454,0,700000), -- Adena
(20623,110,1,1,1,78), -- Doom Shield
(20623,2416,1,1,1,55), -- Blue Wolf Helmet
(20623,2417,1,1,1,55), -- Doom Helmet
(20623,4077,1,1,1,14749), -- Doom Shield Fragment
(20623,4088,1,1,1,12392), -- Blue Wolf Helmet Design
(20623,4089,1,1,1,12392), -- Doom Helmet Pattern
(20623,1868,3,9,2,109296), -- Thread
(20623,1873,1,1,2,131156), -- Silver Nugget
(20623,1889,1,1,2,21860), -- Compound Braid
(20623,4044,1,1,2,10930), -- Thons
(20623,4177,1,1,2,6318), -- Recipe: Zubei\'s Gauntlets
(20623,5549,1,1,2,32789), -- Metallic Thread
(20624,1877,1,1,-1,271744), -- Adamantite Nugget
(20624,4052,1,1,-1,240524), -- Earring of Black Ore Piece
(20624,4054,1,1,-1,133811), -- Necklace of Black Ore Beads
(20624,57,2746,5568,0,700000), -- Adena
(20624,79,1,1,1,16), -- Sword of Damascus
(20624,4114,1,1,1,4392), -- Sword of Damascus Blade
(20624,1868,1,3,2,250840), -- Thread
(20624,1873,1,1,2,100337), -- Silver Nugget
(20624,1876,1,1,2,50169), -- Mithril Ore
(20624,1895,1,1,2,71669), -- Metallic Fiber
(20624,4042,1,1,2,4181), -- Enria
(20624,4154,1,1,2,2969), -- Recipe: Doom Shield
(20624,4403,1,1,2,502), -- Red Dimensional Stone
(20624,5281,1,1,2,334), -- Recipe: Greater Blessed Spiritshot (A) Compressed Package(100%)
(20625,4043,1,1,-1,226724), -- Asofe
(20625,4044,1,1,-1,226724), -- Thons
(20625,5230,1,1,-1,9069), -- Recipe: Mithril Arrow (100%)
(20625,57,2749,5574,0,700000), -- Adena
(20625,268,1,1,1,16), -- Bellion Cestus
(20625,4120,1,1,1,4390), -- Bellion Cestus Edge
(20625,1894,1,1,2,11750), -- Crafted Leather
(20625,4039,1,1,2,11162), -- Mold Glue
(20625,4041,1,1,2,2912), -- Mold Hardener
(20625,4044,1,1,2,11162), -- Thons
(20625,4192,1,1,2,256), -- Recipe: Sword of Damascus
(20625,5276,1,1,2,447); -- Recipe: Greater Spiritshot (A) Compressed Package(100%)

INSERT INTO `droplist` VALUES 
(20626,1875,1,1,-1,560452), -- Stone of Purity
(20626,4053,1,1,-1,360342), -- Ring of Black Ore Gemstone
(20626,5230,1,1,-1,11209), -- Recipe: Mithril Arrow (100%)
(20626,57,3380,6908,0,700000), -- Adena
(20626,358,1,1,1,26), -- Blue Wolf Breastplate
(20626,2380,1,1,1,42), -- Blue Wolf Gaiters
(20626,2381,1,1,1,18), -- Doom Plate Armor
(20626,4078,1,1,1,6046), -- Blue Wolf Breastplate Part
(20626,4080,1,1,1,8514), -- Blue Wolf Gaiters Material
(20626,4081,1,1,1,4080), -- Doom Plate Armor Temper
(20626,1867,1,3,2,157667), -- Animal Skin
(20626,1872,1,3,2,236499), -- Animal Bone
(20626,1875,1,1,2,23650), -- Stone of Purity
(20626,1881,1,1,2,47300), -- Coarse Bone Powder
(20626,4041,1,1,2,3085), -- Mold Hardener
(20626,4402,1,1,2,710), -- Blue Dimensional Stone
(20626,4615,1,1,2,490), -- Greater Dye of Constitution <Con+4 Str-4>
(20627,1877,1,1,-1,337512), -- Adamantite Nugget
(20627,5478,1,1,-1,70954), -- Sealed Dark Crystal Leather Armor Pattern
(20627,57,3405,6921,0,700000), -- Adena
(20627,5290,1,1,1,54), -- Sealed Dark Crystal Gloves
(20627,5291,1,1,1,54), -- Sealed Dark Crystal Boots
(20627,5295,1,1,1,54), -- Sealed Tallum Gloves
(20627,5296,1,1,1,54), -- Sealed Tallum Boots
(20627,5496,1,1,1,7305), -- Sealed Dark Crystal Boots Lining
(20627,5497,1,1,1,7305), -- Sealed Tallum Boots Lining
(20627,5508,1,1,1,7305), -- Sealed Dark Crystal Gloves Design
(20627,5509,1,1,1,7305), -- Sealed Tallum Gloves Design
(20627,1866,1,1,2,207700), -- Suede
(20627,1871,1,3,2,155776), -- Charcoal
(20627,1877,1,1,2,12463), -- Adamantite Nugget
(20627,3956,1,1,2,416), -- Recipe: Blessed Spiritshot A
(20627,4040,1,1,2,6231), -- Mold Lubricant
(20627,4041,1,1,2,2710), -- Mold Hardener
(20627,4973,1,1,2,3372), -- Recipe: Earring of Black Ore (70%)
(20627,6670,1,1,2,51925), -- Deluxe Chest Key - Grade 6
(20628,1807,1,1,-1,12152), -- Recipe: Soulshot: A-Grade
(20628,1895,1,5,-1,868028), -- Metallic Fiber
(20628,5479,1,1,-1,53931), -- Sealed Tallum Leather Armor Pattern
(20628,57,3680,7472,0,700000), -- Adena
(20628,5304,1,1,1,26), -- Sealed Tallum Tunic
(20628,5305,1,1,1,42), -- Sealed Tallum Stockings
(20628,5308,1,1,1,18), -- Sealed Dark Crystal Robe
(20628,5485,1,1,1,3773), -- Sealed Tallum Tunic Texture
(20628,5486,1,1,1,2655), -- Sealed Dark Crystal Robe Fabric
(20628,5489,1,1,1,5922), -- Sealed Tallum Stockings Fabric
(20628,1895,1,1,2,128201), -- Metallic Fiber
(20628,4040,1,1,2,8975), -- Mold Lubricant
(20628,4042,1,1,2,7479), -- Enria
(20628,4043,1,1,2,14957), -- Asofe
(20628,4401,1,1,2,898), -- Green Dimensional Stone
(20628,4988,1,1,2,2972), -- Recipe: Blue Wolf Stockings (60%)
(20629,3035,1,1,-1,14274), -- Recipe: Spiritshot A
(20629,4077,1,1,-1,481585), -- Doom Shield Fragment
(20629,4078,1,1,-1,156378), -- Blue Wolf Breastplate Part
(20629,57,4318,8785,0,700000), -- Adena
(20629,5289,1,1,1,61), -- Sealed Dark Crystal Helmet
(20629,5292,1,1,1,87), -- Sealed Dark Crystal Shield
(20629,5294,1,1,1,61), -- Sealed Tallum Helmet
(20629,5494,1,1,1,11069), -- Sealed Dark Crystal Shield Fragment
(20629,5525,1,1,1,8147), -- Sealed Dark Crystal Helmet Design
(20629,5526,1,1,1,8147), -- Sealed Tallum Helm Design
(20629,1868,3,9,2,175683), -- Thread
(20629,1873,2,6,2,52705), -- Silver Nugget
(20629,1876,1,1,2,105410), -- Mithril Ore
(20629,1895,1,1,2,150586), -- Metallic Fiber
(20629,4042,1,1,2,8785), -- Enria
(20629,5006,1,1,2,403), -- Recipe: Bellion Cestus (60%)
(20630,1902,1,1,-1,77024), -- Elven Earring Beads
(20630,1943,1,1,-1,60383), -- Manticore Skin Gaiters Pattern
(20630,2291,1,1,-1,4223), -- Recipe: Scallop Jamadhr
(20630,57,319,636,0,700000), -- Adena
(20630,629,1,1,1,168), -- Kite Shield
(20630,1947,1,1,1,9431), -- Kite Shield Fragment
(20630,2411,1,1,1,117), -- Brigandine Helmet
(20630,2493,1,1,1,168), -- Brigandine Shield
(20630,2922,1,1,1,2523), -- Brigandine Helmet Design
(20630,2929,1,1,1,9431), -- Brigandine Shield Fragment
(20630,1866,1,1,2,37427), -- Suede
(20630,1871,1,1,2,56140), -- Charcoal
(20630,1885,1,1,2,4679), -- High Grade Suede
(20630,2286,1,1,2,312), -- Recipe: Bonebreaker
(20630,2987,1,1,2,5451), -- Recipe: Plate Shield
(20630,5220,1,1,2,2246), -- Metal Hardener
(20630,5472,1,1,2,4011), -- Recipe: Metallic Thread(100%)
(20631,1873,1,1,-1,411784), -- Silver Nugget
(20631,2996,1,1,-1,81703), -- Recipe: Chain Gloves
(20631,2998,1,1,-1,77403), -- Recipe: Chain Shield
(20631,57,424,847,0,700000), -- Adena
(20631,61,1,1,1,89), -- Mithril Gloves
(20631,607,1,1,1,89), -- Ogre Power Gauntlets
(20631,1125,1,1,1,89), -- Assault Boots
(20631,1949,1,1,1,4808), -- Mithril Gloves Design
(20631,1957,1,1,1,4808), -- Assault Boots Part
(20631,1963,1,1,1,4808), -- Ogre Power Gauntlets Part
(20631,2427,1,1,1,89), -- Salamander Skin Boots
(20631,2428,1,1,1,89), -- Plate Boots
(20631,2451,1,1,1,89), -- Sage\'s Worn Gloves
(20631,2931,1,1,1,4808), -- Salamander Skin Boot Lining
(20631,2932,1,1,1,4808), -- Plate Boots Design
(20631,2933,1,1,1,4808), -- Sage\'s Worn Gloves Lining
(20631,1342,10,30,2,129237), -- Fine Steel Arrow
(20631,1868,1,1,2,129237), -- Thread
(20631,1873,1,1,2,25848), -- Silver Nugget
(20631,1889,1,1,2,4308), -- Compound Braid
(20631,2203,1,1,2,14079), -- Recipe: Mithril Boots
(20631,5164,1,1,2,216), -- Recipe: Blessed Spiritshot (C) Compressed Package (100%)
(20631,5274,1,1,2,216), -- Recipe: Greater Spiritshot (C) Compressed Package(100%)
(20631,5549,1,1,2,6462), -- Metallic Thread
(20632,1873,1,1,-1,410100), -- Silver Nugget
(20632,1880,1,1,-1,102525), -- Steel
(20632,1951,1,1,-1,51754), -- Plate Gaiters Part
(20632,57,419,847,0,700000), -- Adena
(20632,353,1,1,1,66), -- Half Plate Armor
(20632,380,1,1,1,106), -- Plate Gaiters
(20632,1950,1,1,1,4178), -- Half Plate Temper
(20632,1951,1,1,1,6498), -- Plate Gaiters Part
(20632,1864,1,1,2,128709), -- Stem
(20632,1869,1,1,2,64355), -- Iron Ore
(20632,1880,1,1,2,6436), -- Steel
(20632,2205,1,1,2,2037), -- Recipe: Chain Gaiters
(20632,2301,1,1,2,281), -- Recipe: Battle Axe
(20632,5274,1,1,2,215), -- Recipe: Greater Spiritshot (C) Compressed Package(100%)
(20632,5550,1,1,2,859), -- Durable Metal Plate
(20632,6668,1,1,2,22984), -- Deluxe Chest Key - Grade 4
(20633,2212,1,1,-1,35869), -- Recipe: Plated Leather Gaiters
(20633,2313,1,1,-1,4370), -- Recipe: Orcish Glaive
(20633,4469,1,1,-1,5719), -- Dye of Strength <Str+1 Con-1>
(20633,57,404,820,0,700000), -- Adena
(20633,851,1,1,1,139), -- Omen Beast\'s Eye Earring
(20633,882,1,1,1,208), -- Mithril Ring
(20633,914,1,1,1,104), -- Necklace of Darkness
(20633,1905,1,1,1,8148), -- Omen Beast\'s Eye Earring Gemstone
(20633,1906,1,1,1,11513), -- Mithril Ring Wire
(20633,1907,1,1,1,5827), -- Necklace of Darkness Gem
(20633,1868,1,1,2,143581), -- Thread
(20633,1873,1,1,2,28717), -- Silver Nugget
(20633,1876,1,1,2,14359), -- Mithril Ore
(20633,1895,1,1,2,20512), -- Metallic Fiber
(20633,2211,1,1,2,1610), -- Recipe: Plated Leather Armor
(20633,2992,1,1,2,5698), -- Recipe: Plated Leather Boots
(20633,5159,1,1,2,240), -- Recipe: Spiritshot (C) Compressed Package (100%)
(20634,1880,1,1,-1,191909), -- Steel
(20634,1908,1,1,-1,181732), -- Moonstone Earring Wire
(20634,2213,1,1,-1,29800), -- Recipe: Dwarven Chain Mail Shirt
(20634,57,770,1579,0,700000), -- Adena
(20634,354,1,1,1,90), -- Chain Mail Shirt
(20634,381,1,1,1,144), -- Chain Gaiters
(20634,1959,1,1,1,6109), -- Chain Mail Shirt Material
(20634,1960,1,1,1,12426), -- Chain Gaiters Part
(20634,1867,1,1,2,151166), -- Animal Skin
(20634,1872,1,1,2,151166), -- Animal Bone
(20634,1875,1,1,2,7559), -- Stone of Purity
(20634,1881,1,1,2,15117), -- Coarse Bone Powder
(20634,2215,1,1,2,1445), -- Recipe: Robe of Seal
(20634,2225,1,1,2,2465), -- Recipe: Demon\'s Stockings
(20634,2251,1,1,2,18897), -- Recipe: Steel Arrow
(20634,2321,1,1,2,395), -- Recipe: Stiletto
(20635,1959,1,1,-1,26145), -- Chain Mail Shirt Material
(20635,2163,1,1,-1,49522), -- Recipe: Earring of Protection
(20635,2215,1,1,-1,12365), -- Recipe: Robe of Seal
(20635,57,392,796,0,700000), -- Adena
(20635,263,1,1,1,21), -- Chakram
(20635,2073,1,1,1,1773), -- Chakram Edge
(20635,1866,1,1,2,43690), -- Suede
(20635,1871,1,1,2,65534), -- Charcoal
(20635,1885,1,1,2,5462), -- High Grade Suede
(20635,3002,1,1,2,4071), -- Recipe: Dwarven Chain Gloves
(20635,3004,1,1,2,4071), -- Recipe: Rind Leather Gloves
(20635,4041,1,1,2,570), -- Mold Hardener
(20635,5220,1,1,2,2622), -- Metal Hardener
(20636,1909,1,1,-1,145932), -- Aquastone Ring Wire
(20636,2163,1,1,-1,55134), -- Recipe: Earring of Protection
(20636,2214,1,1,-1,26815), -- Recipe: Dwarven Chain Gaiters
(20636,57,434,888,0,700000), -- Adena
(20636,89,1,1,1,3), -- Big Hammer
(20636,160,1,1,1,3), -- Battle Axe
(20636,161,1,1,1,3), -- Silver Axe
(20636,173,1,1,1,3), -- Skull Graver
(20636,191,1,1,1,3), -- Heavy Doom Hammer
(20636,192,1,1,1,3), -- Crystal Staff
(20636,193,1,1,1,3), -- Stick of Faith
(20636,194,1,1,1,3), -- Heavy Doom Axe
(20636,2061,1,1,1,247), -- Big Hammer Head
(20636,2063,1,1,1,247), -- Battle Axe Head
(20636,2064,1,1,1,247), -- Silver Axe Head
(20636,2065,1,1,1,247), -- Skull Graver Head
(20636,2066,1,1,1,251), -- Heavy Doom Hammer Head
(20636,2067,1,1,1,231), -- Crystal Staff Head
(20636,2068,1,1,1,231), -- Stick of Faith Shaft
(20636,2069,1,1,1,251), -- Heavy Doom Axe Blade
(20636,1867,1,1,2,97281), -- Animal Skin
(20636,1872,1,1,2,97281), -- Animal Bone
(20636,1882,1,1,2,16214), -- Leather
(20636,1894,1,1,2,2561), -- Crafted Leather
(20636,2230,1,1,2,1414), -- Recipe: Theca Leather Gaiters
(20636,2320,1,1,2,255), -- Recipe: Cursed Staff
(20636,4042,1,1,2,1217), -- Enria
(20637,440,1,1,-1,319), -- Robe of Seal
(20637,2337,1,1,-1,2622), -- Recipe: Stick of Eternity
(20637,2338,1,1,-1,2622), -- Recipe: Paradia Staff
(20637,57,454,926,0,700000), -- Adena
(20637,1126,1,1,1,52), -- Crimson Boots
(20637,1974,1,1,1,3501), -- Crimson Boot Fabric
(20637,2434,1,1,1,52), -- Rind Leather Boots
(20637,2455,1,1,1,56), -- Plated Leather Gloves
(20637,2456,1,1,1,52), -- Dwarven Chain Gloves
(20637,2457,1,1,1,52), -- Gloves of Seal
(20637,2458,1,1,1,52), -- Rind Leather Gloves
(20637,2946,1,1,1,2327), -- Plate Leather Gloves Design
(20637,2948,1,1,1,3501), -- Rind Leather Boot Lining
(20637,2949,1,1,1,3501), -- Dwarven Chain Gloves Design
(20637,2950,1,1,1,3501), -- Gloves of Seal Pattern
(20637,2951,1,1,1,3501), -- Rind Leather Gloves Design
(20637,1539,1,1,2,13874), -- Greater Healing Potion
(20637,1864,1,1,2,124865), -- Stem
(20637,1869,1,1,2,62433), -- Iron Ore
(20637,1880,1,1,2,6244), -- Steel
(20637,2222,1,1,2,391), -- Recipe: Composite Armor
(20637,4043,1,1,2,2082), -- Asofe
(20637,5550,1,1,2,833), -- Durable Metal Plate
(20637,6668,1,1,2,22298), -- Deluxe Chest Key - Grade 4
(20638,1873,1,1,-1,470674), -- Silver Nugget
(20638,1911,1,1,-1,87518), -- Earring of Protection Gemstone
(20638,2946,1,1,-1,65773), -- Plate Leather Gloves Design
(20638,57,475,965,0,700000), -- Adena
(20638,282,1,1,1,10), -- Elemental Bow
(20638,285,1,1,1,10), -- Noble Elven Bow
(20638,2085,1,1,1,902), -- Crossbow Shaft
(20638,2086,1,1,1,902), -- Elven Bow of Nobility Shaft
(20638,952,1,1,2,773), -- Scroll: Enchant Armor (Grade C)
(20638,1867,1,1,2,77239), -- Animal Skin
(20638,1872,1,1,2,77239), -- Animal Bone
(20638,1882,1,1,2,12874), -- Leather
(20638,1894,1,1,2,2033), -- Crafted Leather
(20638,2338,1,1,2,135), -- Recipe: Paradia Staff
(20638,2351,1,1,2,122), -- Recipe: Scorpion
(20638,3005,1,1,2,2365), -- Recipe: Demon\'s Boots
(20638,4042,1,1,2,966), -- Enria
(20639,951,1,1,-1,4502), -- Scroll: Enchant Weapon (Grade C)
(20639,2334,1,1,-1,5758), -- Recipe: Sword of Whispering Death
(20639,2342,1,1,-1,5758), -- Recipe: Club of Nature
(20639,57,997,2033,0,700000), -- Adena
(20639,227,1,1,1,20), -- Stiletto
(20639,242,1,1,1,20), -- Soulfire Dirk
(20639,2083,1,1,1,1823), -- Stiletto Edge
(20639,2084,1,1,1,1823), -- Soulfire Dirk Blade
(20639,1868,1,1,2,274261), -- Thread
(20639,1873,1,1,2,54853), -- Silver Nugget
(20639,1889,1,1,2,9142), -- Compound Braid
(20639,2328,1,1,2,320), -- Recipe: Sword of Delusion
(20639,4044,1,1,2,4572), -- Thons
(20639,4132,1,1,2,5316), -- Recipe: Composite Shield
(20639,5549,1,1,2,13714), -- Metallic Thread
(20639,6668,1,1,2,48975), -- Deluxe Chest Key - Grade 4
(20640,1539,1,1,-1,264351), -- Greater Healing Potion
(20640,1868,1,5,-1,793052), -- Thread
(20640,1870,1,3,-1,594789), -- Coal
(20640,57,480,976,0,700000), -- Adena
(20640,283,1,1,1,12), -- Akat Long Bow
(20640,2109,1,1,1,1380), -- Akat Longbow Shaft
(20640,1865,1,1,2,54660), -- Varnish
(20640,1870,1,1,2,54660), -- Coal
(20640,1875,1,1,2,3645), -- Stone of Purity
(20640,1879,1,1,2,9110), -- Cokes
(20640,2233,1,1,2,511), -- Recipe: Divine Tunic
(20640,2970,1,1,2,1939), -- Recipe: Ring of Binding
(20640,3014,1,1,2,1527), -- Recipe: Full Plate Boots
(20640,4040,1,1,2,1094), -- Mold Lubricant
(20640,6669,1,1,2,12712), -- Deluxe Chest Key - Grade 5
(20641,2097,1,1,-1,7900), -- War Axe Blade
(20641,2355,1,1,-1,2406), -- Recipe: Ghoul\'s Staff
(20641,4042,1,1,-1,24583), -- Enria
(20641,57,596,1210,0,700000), -- Adena
(20641,854,1,1,1,69), -- Earring of Binding
(20641,885,1,1,1,104), -- Ring of Ages
(20641,917,1,1,1,52), -- Necklace of Mermaid
(20641,1914,1,1,1,5712), -- Earring of Binding Gemstone
(20641,1915,1,1,1,8958), -- Ring of Ages Gemstone
(20641,1916,1,1,1,4327), -- Necklace of Mermaid Teardrop
(20641,1867,1,1,2,101660), -- Animal Skin
(20641,1872,1,1,2,101660), -- Animal Bone
(20641,1882,1,1,2,16944), -- Leather
(20641,1894,1,1,2,2676), -- Crafted Leather
(20641,2353,1,1,2,125), -- Recipe: Samurai Longsword
(20641,4042,1,1,2,1271), -- Enria
(20641,4124,1,1,2,3389), -- Recipe: Craftsman Mold
(20641,4609,1,1,2,170), -- Greater Dye of Mental Strength <Men+3 Int-3>
(20642,2103,1,1,-1,7789), -- Sage\'s Staff Head
(20642,2358,1,1,-1,2254), -- Recipe: Great Pata
(20642,4602,1,1,-1,3070), -- Greater Dye of Strength <Str+3 Dex-3>
(20642,57,560,1131,0,700000), -- Adena
(20642,283,1,1,1,14), -- Akat Long Bow
(20642,2109,1,1,1,1602), -- Akat Longbow Shaft
(20642,1342,10,30,2,103889), -- Fine Steel Arrow
(20642,1868,1,1,2,103888), -- Thread
(20642,1873,1,1,2,20778), -- Silver Nugget
(20642,1876,1,1,2,10389), -- Mithril Ore
(20642,1895,1,1,2,14842), -- Metallic Fiber
(20642,3015,1,1,2,1451), -- Recipe: Drake Leather Gloves
(20642,3017,1,1,2,1451), -- Recipe: Divine Gloves
(20642,4042,1,1,2,866), -- Enria
(20642,4606,1,1,2,116), -- Greater Dye of Dexterity <Dex+3 Con-3>
(20642,5155,1,1,2,104), -- Recipe: Soulshot (B) Compressed Package (100%)
(20643,1918,1,1,-1,61625), -- Nassen\'s Earring Gemstone
(20643,2114,1,1,-1,6891), -- Widowmaker Head
(20643,3955,1,1,-1,2846), -- Recipe: Blessed Spiritshot B
(20643,57,574,1167,0,700000), -- Adena
(20643,2414,1,1,1,50), -- Full Plate Helmet
(20643,2497,1,1,1,71), -- Full Plate Shield
(20643,2959,1,1,1,4544), -- Full Plate Helmet Design
(20643,2966,1,1,1,7187), -- Full Plate Shield Fragment
(20643,1894,1,1,2,2305), -- Crafted Leather
(20643,4039,1,1,2,2190), -- Mold Glue
(20643,4041,1,1,2,572), -- Mold Hardener
(20643,4044,1,1,2,2190), -- Thons
(20643,4126,1,1,2,1084), -- Recipe: Adamantite Earrings
(20643,5270,1,1,2,132), -- Recipe: Greater Soulshot (B) Compressed Package(100%)
(20643,5275,1,1,2,132), -- Recipe: Greater Spiritshot (B) Compressed Package(100%)
(20643,6669,1,1,2,15273), -- Deluxe Chest Key - Grade 5
(20644,1806,1,1,-1,2791), -- Recipe: Soulshot: B-Grade
(20644,1865,1,3,-1,697860), -- Varnish
(20644,1987,1,1,-1,21294), -- Drake Leather Armor Texture
(20644,57,562,1145,0,700000), -- Adena
(20644,442,1,1,1,25), -- Divine Tunic
(20644,473,1,1,1,39), -- Divine Stockings
(20644,1988,1,1,1,2476), -- Divine Tunic Fabric
(20644,1989,1,1,1,3884), -- Divine Stocking Pattern
(20644,1864,1,1,2,114521), -- Stem
(20644,1869,1,1,2,57261), -- Iron Ore
(20644,1878,1,1,2,22905), -- Braided Hemp
(20644,1884,1,1,2,35238), -- Cord
(20644,4039,1,1,2,1909), -- Mold Glue
(20644,4142,1,1,2,441), -- Recipe: Avadon Gaiters
(20644,4147,1,1,2,589), -- Recipe: Stockings of Zubei
(20644,4184,1,1,2,66), -- Recipe: Sprite\'s Staff
(20644,5160,1,1,2,115), -- Recipe: Spiritshot (B) Compressed Package (100%)
(20645,1885,1,1,-1,261843), -- High Grade Suede
(20645,1920,1,1,-1,107515), -- Necklace of Binding Chain
(20645,2121,1,1,-1,14450), -- Eminence Bow Shaft
(20645,57,1266,2580,0,700000), -- Adena
(20645,286,1,1,1,19), -- Eminence Bow
(20645,2121,1,1,1,2668), -- Eminence Bow Shaft
(20645,1865,1,1,2,145021), -- Varnish
(20645,1870,1,1,2,145021), -- Coal
(20645,1874,1,1,2,9668), -- Oriharukon Ore
(20645,4039,1,1,2,4835), -- Mold Glue
(20645,4043,1,1,2,4835), -- Asofe
(20645,4179,1,1,2,1864), -- Recipe: Zubei\'s Helmet
(20645,4189,1,1,2,168), -- Recipe: Arthro Nail
(20645,5275,1,1,2,291), -- Recipe: Greater Spiritshot (B) Compressed Package(100%)
(20646,2122,1,1,-1,10807), -- Orcish Poleaxe Blade
(20646,3034,1,1,-1,4735), -- Recipe: Spiritshot B
(20646,4044,1,1,-1,78920), -- Thons
(20646,57,954,1944,0,700000), -- Adena
(20646,299,1,1,1,5), -- Orcish Poleaxe
(20646,301,1,1,1,7), -- Scorpion
(20646,303,1,1,1,7), -- Widow Maker
(20646,2113,1,1,1,706), -- Scorpion Blade
(20646,2114,1,1,1,706), -- Widowmaker Head
(20646,2122,1,1,1,665), -- Orcish Poleaxe Blade
(20646,1864,1,1,2,218549), -- Stem
(20646,1869,1,1,2,109274), -- Iron Ore
(20646,1878,1,1,2,43710), -- Braided Hemp
(20646,1884,1,1,2,67246), -- Cord
(20646,4039,1,1,2,3643), -- Mold Glue
(20646,4186,1,1,2,126), -- Recipe: Sword of Valhalla
(20646,4190,1,1,2,126), -- Recipe: Dark Elven Long Bow
(20646,5165,1,1,2,219), -- Recipe: Blessed Spiritshot (B) Compressed Package (100%)
(20647,947,1,1,-1,952), -- Scroll: Enchant Weapon (Grade B)
(20647,2960,1,1,-1,129649), -- Drake Leather Boots Design
(20647,4049,1,1,-1,124889), -- Adamantite Earring Gemstone
(20647,57,958,1956,0,700000), -- Adena
(20647,554,1,1,1,34), -- Zubei\'s Boots
(20647,600,1,1,1,34), -- Avadon Boots
(20647,612,1,1,1,34), -- Zubei\'s Gauntlets
(20647,2464,1,1,1,34), -- Avadon Gloves
(20647,4073,1,1,1,4575), -- Avadon Gloves Part
(20647,4097,1,1,1,4575), -- Zubei\'s Boots Design
(20647,4098,1,1,1,4575), -- Avadon Boots Design
(20647,4100,1,1,1,4575), -- Zubei\'s Gauntlets Part
(20647,1865,1,1,2,87914), -- Varnish
(20647,1870,1,1,2,87914), -- Coal
(20647,1875,1,1,2,5862), -- Stone of Purity
(20647,1879,1,1,2,14653), -- Cokes
(20647,4040,1,1,2,1759), -- Mold Lubricant
(20647,4176,1,1,2,1094), -- Recipe: Doom Boots
(20647,4946,1,1,2,564), -- Recipe: Zubei\'s Leather Shirt (60%)
(20647,5280,1,1,2,176), -- Recipe: Greater Blessed Spiritshot (B) Compressed Package(100%)
(20648,1868,1,11,-1,855624), -- Thread
(20648,2963,1,1,-1,139770), -- Full Plate Gauntlets Part
(20648,4191,1,1,-1,2957), -- Recipe: Great Axe
(20648,57,1033,2109,0,700000), -- Adena
(20648,554,1,1,1,37), -- Zubei\'s Boots
(20648,600,1,1,1,37), -- Avadon Boots
(20648,612,1,1,1,37), -- Zubei\'s Gauntlets
(20648,2464,1,1,1,37), -- Avadon Gloves
(20648,4073,1,1,1,4932), -- Avadon Gloves Part
(20648,4097,1,1,1,4932), -- Zubei\'s Boots Design
(20648,4098,1,1,1,4932), -- Avadon Boots Design
(20648,4100,1,1,1,4932), -- Zubei\'s Gauntlets Part
(20648,1868,1,1,2,189555), -- Thread
(20648,1873,1,1,2,37911), -- Silver Nugget
(20648,1876,1,1,2,18956), -- Mithril Ore
(20648,1895,1,1,2,27080), -- Metallic Fiber
(20648,4042,1,1,2,1580), -- Enria
(20648,4961,1,1,2,1740), -- Recipe: Zubei\'s Shield (60%)
(20648,4999,1,1,2,1179), -- Recipe: Doom Boots (60%)
(20648,6669,1,1,2,22042), -- Deluxe Chest Key - Grade 5
(20649,2112,1,1,-1,13082), -- Pa\'agrian Axe Blade
(20649,4133,1,1,-1,12988), -- Recipe: Zubei\'s Breastplate
(20649,5549,1,1,-1,270151), -- Metallic Thread
(20649,57,1088,2217,0,700000), -- Adena
(20649,78,1,1,1,4), -- Great Sword
(20649,142,1,1,1,4), -- Keshanberk
(20649,148,1,1,1,4), -- Sword of Valhalla
(20649,4104,1,1,1,761), -- Great Sword Blade
(20649,4107,1,1,1,750), -- Keshanberk Blade
(20649,4108,1,1,1,750), -- Sword of Valhalla Blade
(20649,1832,1,1,2,110832), -- Greater Antidote
(20649,1868,1,1,2,199496), -- Thread
(20649,1873,1,1,2,39900), -- Silver Nugget
(20649,1889,1,1,2,6650), -- Compound Braid
(20649,4044,1,1,2,3325), -- Thons
(20649,4194,1,1,2,77), -- Recipe: Deadman\'s Glory
(20649,4970,1,1,2,115), -- Recipe: Arthro Nail (60%)
(20649,5549,1,1,2,9975), -- Metallic Thread
(20650,4049,1,1,-1,153727), -- Adamantite Earring Gemstone
(20650,4195,1,1,-1,2237), -- Recipe: Art of Battle Axe
(20650,4613,1,1,-1,4042), -- Greater Dye of Strength <Str+4 Con-4>
(20650,57,1181,2405,0,700000), -- Adena
(20650,856,1,1,1,48), -- Adamantite Earring
(20650,887,1,1,1,72), -- Adamantite Ring
(20650,918,1,1,1,36), -- Adamantite Necklace
(20650,4049,1,1,1,7570), -- Adamantite Earring Gemstone
(20650,4050,1,1,1,8942), -- Adamantite Ring Wire
(20650,4051,1,1,1,5597), -- Adamantite Necklace Chain
(20650,948,1,1,2,271), -- Scroll: Enchant Armor (Grade B)
(20650,1867,1,1,2,144286), -- Animal Skin
(20650,1872,1,1,2,144286), -- Animal Bone
(20650,1882,1,1,2,24048), -- Leather
(20650,1894,1,1,2,3798), -- Crafted Leather
(20650,4042,1,1,2,1804), -- Enria
(20650,4167,1,1,2,1347), -- Recipe: Blue Wolf Boots
(20650,4168,1,1,2,1347), -- Recipe: Doom Gloves
(20651,4050,1,1,-1,168983), -- Adamantite Ring Wire
(20651,4196,1,1,-1,2082), -- Recipe: Staff of Evil Spirits
(20651,57,1100,2237,0,700000), -- Adena
(20651,78,1,1,1,4), -- Great Sword
(20651,142,1,1,1,4), -- Keshanberk
(20651,148,1,1,1,4), -- Sword of Valhalla
(20651,4104,1,1,1,769), -- Great Sword Blade
(20651,4107,1,1,1,757), -- Keshanberk Blade
(20651,4108,1,1,1,757), -- Sword of Valhalla Blade
(20651,5013,1,1,2,7460), -- Spellbook: Elemental Assault
(20651,5014,1,1,2,7460), -- Spellbook: Elemental Symphony 
(20651,5015,1,1,2,7460), -- Spellbook: Elemental Storm
(20651,10050,1,1,2,3484), -- Battle Manual: Blink
(20651,10093,1,1,2,2786), -- Battle Manual: Voice Bind
(20652,4042,1,1,-1,48043), -- Enria
(20652,4043,1,1,-1,96085), -- Asofe
(20652,4129,1,1,-1,31197), -- Recipe: Earrings of Black Ore
(20652,57,1165,2363,0,700000), -- Adena
(20652,2384,1,1,1,19), -- Zubei\'s Leather Shirt
(20652,2388,1,1,1,30), -- Zubei\'s Leather Gaiters
(20652,2390,1,1,1,13), -- Avadon Leather Armor
(20652,4066,1,1,1,3345), -- Zubei\'s Leather Shirt Fabric
(20652,4067,1,1,1,5079), -- Zubei\'s Leather Gaiter Texture
(20652,4068,1,1,1,2570), -- Avadon Leather Armor Lining
(20652,1864,1,1,2,212866), -- Stem
(20652,1869,1,1,2,106433), -- Iron Ore
(20652,1880,1,1,2,10644), -- Steel
(20652,4043,1,1,2,3548), -- Asofe
(20652,4173,1,1,2,1324), -- Recipe: Blue Wolf Gloves
(20652,4615,1,1,2,147), -- Greater Dye of Constitution <Con+4 Str-4>
(20652,4998,1,1,2,1324), -- Recipe: Blue Wolf Gloves (60%)
(20652,5550,1,1,2,1420), -- Durable Metal Plate
(20654,4052,1,1,-1,190253), -- Earring of Black Ore Piece
(20654,4064,1,1,-1,97262), -- Avadon Breastplate Part
(20654,5230,1,1,-1,7165), -- Recipe: Mithril Arrow (100%)
(20654,57,2174,4403,0,700000), -- Adena
(20654,2398,1,1,1,17), -- Blue Wolf Tunic
(20654,2399,1,1,1,17), -- Tunic of Doom
(20654,2403,1,1,1,27), -- Blue Wolf Stockings
(20654,2404,1,1,1,27), -- Stockings of Doom
(20654,4084,1,1,1,3447), -- Blue Wolf Tunic Fabric
(20654,4085,1,1,1,3447), -- Tunic of Doom Pattern
(20654,4086,1,1,1,4654), -- Blue Wolf Stockings Pattern
(20654,4087,1,1,1,4654), -- Stockings of Doom Pattern
(20654,1894,1,1,2,7957), -- Crafted Leather
(20654,4039,1,1,2,7559), -- Mold Glue
(20654,4041,1,1,2,1972), -- Mold Hardener
(20654,4044,1,1,2,7559), -- Thons
(20654,4624,1,1,2,313), -- Greater Dye of Wit <Wit+4 Men-4>
(20654,5276,1,1,2,303), -- Recipe: Greater Spiritshot (A) Compressed Package(100%)
(20654,6036,1,1,2,7559), -- Greater Magic Haste Potion
(20655,4053,1,1,-1,207665), -- Ring of Black Ore Gemstone
(20655,4067,1,1,-1,173432), -- Zubei\'s Leather Gaiter Texture
(20655,4160,1,1,-1,13725), -- Recipe: Leather Armor of Doom
(20655,57,1960,3968,0,700000), -- Adena
(20655,110,1,1,1,57), -- Doom Shield
(20655,2416,1,1,1,40), -- Blue Wolf Helmet
(20655,2417,1,1,1,40), -- Doom Helmet
(20655,4077,1,1,1,10729), -- Doom Shield Fragment
(20655,4088,1,1,1,9014), -- Blue Wolf Helmet Design
(20655,4089,1,1,1,9014), -- Doom Helmet Pattern
(20655,1343,20,60,2,113579), -- Silver Arrow
(20655,1865,1,1,2,159010), -- Varnish
(20655,1870,1,1,2,159010), -- Coal
(20655,1874,1,1,2,10601), -- Oriharukon Ore
(20655,4039,1,1,2,5301), -- Mold Glue
(20655,4043,1,1,2,5301), -- Asofe
(20655,4989,1,1,2,1053), -- Recipe: Stockings of Doom (60%)
(20655,5276,1,1,2,212), -- Recipe: Greater Spiritshot (A) Compressed Package(100%)
(20655,6670,1,1,2,26502), -- Deluxe Chest Key - Grade 6
(20656,4040,1,1,-1,93328), -- Mold Lubricant
(20656,4069,1,1,-1,110018), -- Tunic of Zubei Fabric
(20656,57,1888,3822,0,700000), -- Adena
(20656,2398,1,1,1,15), -- Blue Wolf Tunic
(20656,2399,1,1,1,15), -- Tunic of Doom
(20656,2403,1,1,1,23), -- Blue Wolf Stockings
(20656,2404,1,1,1,23), -- Stockings of Doom
(20656,4084,1,1,1,2994), -- Blue Wolf Tunic Fabric
(20656,4085,1,1,1,2994), -- Tunic of Doom Pattern
(20656,4086,1,1,1,4042), -- Blue Wolf Stockings Pattern
(20656,4087,1,1,1,4042), -- Stockings of Doom Pattern
(20656,1895,1,1,2,65638), -- Metallic Fiber
(20656,4040,1,1,2,4595), -- Mold Lubricant
(20656,4042,1,1,2,3829), -- Enria
(20656,4043,1,1,2,7658), -- Asofe
(20656,4990,1,1,2,1899), -- Recipe: Blue Wolf Helmet (60%)
(20656,6670,1,1,2,38289), -- Deluxe Chest Key - Grade 6
(20657,1877,1,1,-1,137950), -- Adamantite Nugget
(20657,1914,1,1,-1,193750), -- Earring of Binding Gemstone
(20657,1920,1,1,-1,118007), -- Necklace of Binding Chain
(20657,57,1397,2824,0,700000), -- Adena
(20657,2398,1,1,1,11), -- Blue Wolf Tunic
(20657,2399,1,1,1,11), -- Tunic of Doom
(20657,2403,1,1,1,17), -- Blue Wolf Stockings
(20657,2404,1,1,1,17), -- Stockings of Doom
(20657,4084,1,1,1,2213), -- Blue Wolf Tunic Fabric
(20657,4085,1,1,1,2213), -- Tunic of Doom Pattern
(20657,4086,1,1,1,2987), -- Blue Wolf Stockings Pattern
(20657,4087,1,1,1,2987), -- Stockings of Doom Pattern
(20657,1866,1,1,2,97020), -- Suede
(20657,1871,1,1,2,145530), -- Charcoal
(20657,1877,1,1,2,5822), -- Adamantite Nugget
(20657,4040,1,1,2,2911), -- Mold Lubricant
(20657,4041,1,1,2,1266), -- Mold Hardener
(20657,4960,1,1,2,2805), -- Recipe: Zubei\'s Gauntlets (60%)
(20657,5276,1,1,2,194), -- Recipe: Greater Spiritshot (A) Compressed Package(100%)
(20658,1960,1,1,-1,182200), -- Chain Gaiters Part
(20658,2220,1,1,-1,68844), -- Recipe: Rind Leather Armor
(20658,4054,1,1,-1,65494), -- Necklace of Black Ore Beads
(20658,57,1344,2725,0,700000), -- Adena
(20658,864,1,1,1,36), -- Earring of Black Ore
(20658,895,1,1,1,54), -- Ring of Black Ore
(20658,926,1,1,1,27), -- Necklace of Black Ore
(20658,4052,1,1,1,5796), -- Earring of Black Ore Piece
(20658,4053,1,1,1,7016), -- Ring of Black Ore Gemstone
(20658,4054,1,1,1,3224), -- Necklace of Black Ore Beads
(20658,730,1,1,2,103), -- Scroll: Enchant Armor (Grade A)
(20658,1832,1,1,2,136417), -- Greater Antidote
(20658,1866,1,1,2,81850), -- Suede
(20658,1871,1,1,2,122775), -- Charcoal
(20658,1885,1,1,2,10232), -- High Grade Suede
(20658,4041,1,1,2,1068), -- Mold Hardener
(20658,4155,1,1,2,382), -- Recipe: Blue Wolf Breastplate
(20658,5220,1,1,2,4911), -- Metal Hardener
(20659,1885,1,1,-1,89149), -- High Grade Suede
(20659,2062,1,1,-1,8390), -- Scythe Edge
(20659,2163,1,1,-1,54581), -- Recipe: Earring of Protection
(20659,57,432,877,0,700000), -- Adena
(20659,631,1,1,1,127), -- Eldarake
(20659,1964,1,1,1,6810), -- Eldarake Temper
(20659,2413,1,1,1,90), -- Chain Hood
(20659,2495,1,1,1,127), -- Chain Shield
(20659,2936,1,1,1,6185), -- Chain Hood Pattern
(20659,2945,1,1,1,6810), -- Chain Shield Fragment
(20659,1868,1,1,2,112356), -- Thread
(20659,1873,1,1,2,22471), -- Silver Nugget
(20659,1889,1,1,2,3746), -- Compound Braid
(20659,2215,1,1,2,716), -- Recipe: Robe of Seal
(20659,2225,1,1,2,1222), -- Recipe: Demon\'s Stockings
(20659,2321,1,1,2,196), -- Recipe: Stiletto
(20659,3021,1,1,2,196), -- Recipe: Dwarven War Hammer
(20659,4044,1,1,2,1873), -- Thons
(20659,5549,1,1,2,5618), -- Metallic Thread
(20660,1908,1,1,-1,125113), -- Moonstone Earring Wire
(20660,2084,1,1,-1,8779), -- Soulfire Dirk Blade
(20660,2330,1,1,-1,3073), -- Recipe: Homunkulus\'s Sword
(20660,57,531,1086,0,700000), -- Adena
(20660,439,1,1,1,83), -- Karmian Tunic
(20660,471,1,1,1,132), -- Karmian Stockings
(20660,1954,1,1,1,8300), -- Karmian Stocking Design
(20660,1962,1,1,1,4996), -- Karmian Tunic Pattern
(20660,1864,1,1,2,208140), -- Stem
(20660,1869,1,1,2,104070), -- Iron Ore
(20660,1880,1,1,2,10408), -- Steel
(20660,2163,1,1,2,5310), -- Recipe: Earring of Protection
(20660,4043,1,1,2,3469), -- Asofe
(20660,5550,1,1,2,1388), -- Durable Metal Plate
(20661,2166,1,1,-1,42266), -- Recipe: Earrings of Binding (100%)
(20661,2223,1,1,-1,48328), -- Recipe: Tower Shield
(20661,2347,1,1,-1,2900), -- Recipe: Akat Long Bow
(20661,57,502,1024,0,700000), -- Adena
(20661,500,1,1,1,77), -- Great Helmet
(20661,632,1,1,1,109), -- Knight\'s Shield
(20661,1971,1,1,1,5637), -- Great Helmet Material
(20661,1972,1,1,1,7367), -- Knight\'s Shield Fragment
(20661,2496,1,1,1,119), -- Dwarven Chain Shield
(20661,2947,1,1,1,6577), -- Dwarven Chain Shield Fragment
(20661,1343,10,30,2,78922), -- Silver Arrow
(20661,1868,1,1,2,110490), -- Thread
(20661,1873,1,1,2,22099), -- Silver Nugget
(20661,1876,1,1,2,11049), -- Mithril Ore
(20661,1895,1,1,2,15785), -- Metallic Fiber
(20661,2223,1,1,2,2142), -- Recipe: Tower Shield
(20661,2230,1,1,2,1071), -- Recipe: Theca Leather Gaiters
(20661,3005,1,1,2,2255), -- Recipe: Demon\'s Boots
(20661,4042,1,1,2,921), -- Enria
(20661,6668,1,1,2,19731), -- Deluxe Chest Key - Grade 4
(20662,951,1,1,-1,2366), -- Scroll: Enchant Weapon (Grade C)
(20662,1873,1,1,-1,520615), -- Silver Nugget
(20662,1911,1,1,-1,96805), -- Earring of Protection Gemstone
(20662,57,525,1067,0,700000), -- Adena
(20662,73,1,1,1,6), -- Shamshir
(20662,74,1,1,1,6), -- Katana
(20662,131,1,1,1,6), -- Spirit Sword
(20662,133,1,1,1,6), -- Raid Sword
(20662,2077,1,1,1,479), -- Shamshir Blade
(20662,2078,1,1,1,479), -- Katana Blade
(20662,2080,1,1,1,479), -- Spirit Sword Blade
(20662,2081,1,1,1,479), -- Raid Sword Blade
(20662,1343,10,30,2,102979), -- Silver Arrow
(20662,1866,1,1,2,48057), -- Suede
(20662,1871,1,1,2,72086), -- Charcoal
(20662,1877,1,1,2,2884), -- Adamantite Nugget
(20662,2340,1,1,2,168), -- Recipe: Pa\'agrian Hammer
(20662,3006,1,1,2,2943), -- Recipe: Demon\'s Gloves
(20662,4040,1,1,2,1442), -- Mold Lubricant
(20662,4041,1,1,2,627), -- Mold Hardener
(20663,951,1,1,-1,2075), -- Scroll: Enchant Weapon (Grade C)
(20663,1981,1,1,-1,67117), -- Mithril Gauntlets Design
(20663,4123,1,1,-1,50711), -- Recipe: Maestro Anvil Lock
(20663,57,459,937,0,700000), -- Adena
(20663,853,1,1,1,86), -- Earring of Protection
(20663,884,1,1,1,130), -- Ring of Protection
(20663,916,1,1,1,65), -- Necklace of Protection
(20663,1911,1,1,1,6268), -- Earring of Protection Gemstone
(20663,1912,1,1,1,9081), -- Ring of Protection Gemstone
(20663,1913,1,1,1,5125), -- Necklace of Protection Gemstone
(20663,3940,1,1,2,7022), -- Blueprint: Summon Siege Golem
(20663,3941,1,1,2,7327), -- Spellbook: Mass Resurrection
(20663,3942,1,1,2,7327), -- Spellbook: Party Return
(20663,10080,1,1,2,7092), -- Battle Manual: Violent Temper
(20664,1865,1,3,-1,600678), -- Varnish
(20664,1867,1,3,-1,800904), -- Animal Skin
(20664,2098,1,1,-1,6435), -- Nirvana Axe Blade
(20664,57,485,985,0,700000), -- Adena
(20664,64,1,1,1,102), -- Composite Boots
(20664,608,1,1,1,102), -- Mithril Gauntlets
(20664,1981,1,1,1,7306), -- Mithril Gauntlets Design
(20664,2956,1,1,1,7306), -- Composite Boots Part
(20664,1539,1,1,2,11041), -- Greater Healing Potion
(20664,1867,1,1,2,66241), -- Animal Skin
(20664,1872,1,1,2,66241), -- Animal Bone
(20664,1882,1,1,2,11041), -- Leather
(20664,1894,1,1,2,1744), -- Crafted Leather
(20664,2234,1,1,2,741), -- Recipe: Divine Stockings
(20664,2356,1,1,2,82), -- Recipe: Demon\'s Staff
(20664,4042,1,1,2,829), -- Enria
(20664,4609,1,1,2,111), -- Greater Dye of Mental Strength <Men+3 Int-3>
(20664,6669,1,1,2,11554), -- Deluxe Chest Key - Grade 5
(20665,2104,1,1,-1,8314), -- Club of Nature Head
(20665,2359,1,1,-1,2406), -- Recipe: Eminence Bow
(20665,4043,1,1,-1,49166), -- Asofe
(20665,57,596,1210,0,700000), -- Adena
(20665,162,1,1,1,2), -- War Axe
(20665,174,1,1,1,2), -- Nirvana Axe
(20665,196,1,1,1,2), -- Stick of Eternity
(20665,197,1,1,1,2), -- Paradia Staff
(20665,199,1,1,1,2), -- Pa\'agrian Hammer
(20665,200,1,1,1,2), -- Sage\'s Staff
(20665,201,1,1,1,2), -- Club of Nature
(20665,202,1,1,1,2), -- Mace of The Underworld
(20665,2097,1,1,1,205), -- War Axe Blade
(20665,2098,1,1,1,205), -- Nirvana Axe Blade
(20665,2099,1,1,1,215), -- Stick of Eternity Shaft
(20665,2100,1,1,1,215), -- Paradia Staff Head
(20665,2102,1,1,1,208), -- Pa\'agrian Hammer Head
(20665,2103,1,1,1,215), -- Sage\'s Staff Head
(20665,2104,1,1,1,215), -- Club of Nature Head
(20665,2105,1,1,1,205), -- Mace of The Underworld Head
(20665,1865,1,1,2,87137), -- Varnish
(20665,1870,1,1,2,87137), -- Coal
(20665,1874,1,1,2,5810), -- Oriharukon Ore
(20665,3014,1,1,2,2434), -- Recipe: Full Plate Boots
(20665,4039,1,1,2,2905), -- Mold Glue
(20665,4043,1,1,2,2905), -- Asofe
(20665,4125,1,1,2,3873), -- Recipe: Maestro Mold
(20666,1884,1,1,-1,944213), -- Cord
(20666,1977,1,1,-1,22697), -- Composite Armor Temper
(20666,4606,1,1,-1,3410), -- Greater Dye of Dexterity <Dex+3 Con-3>
(20666,57,622,1256,0,700000), -- Adena
(20666,64,1,1,1,130), -- Composite Boots
(20666,608,1,1,1,130), -- Mithril Gauntlets
(20666,1981,1,1,1,9332), -- Mithril Gauntlets Design
(20666,2956,1,1,1,9332), -- Composite Boots Part
(20666,1865,1,1,2,70502), -- Varnish
(20666,1870,1,1,2,70502), -- Coal
(20666,1874,1,1,2,4701), -- Oriharukon Ore
(20666,3955,1,1,2,142), -- Recipe: Blessed Spiritshot B
(20666,4039,1,1,2,2350), -- Mold Glue
(20666,4043,1,1,2,2350), -- Asofe
(20666,4607,1,1,2,157), -- Greater Dye of Intelligence <Int+3 Men-3>
(20666,4609,1,1,2,157), -- Greater Dye of Mental Strength <Men+3 Int-3>
(20666,5280,1,1,2,141), -- Recipe: Greater Blessed Spiritshot (B) Compressed Package(100%)
(20667,1988,1,1,-1,30378), -- Divine Tunic Fabric
(20667,4141,1,1,-1,7601), -- Recipe: Avadon Breastplate
(20667,4604,1,1,-1,3513), -- Greater Dye of Constitution <Con+3 Dex-3>
(20667,57,638,1297,0,700000), -- Adena
(20667,299,1,1,1,4), -- Orcish Poleaxe
(20667,301,1,1,1,5), -- Scorpion
(20667,303,1,1,1,5), -- Widow Maker
(20667,2113,1,1,1,471), -- Scorpion Blade
(20667,2114,1,1,1,471), -- Widowmaker Head
(20667,2122,1,1,1,444), -- Orcish Poleaxe Blade
(20667,1875,1,1,2,4325), -- Stone of Purity
(20667,1879,1,1,2,10811), -- Cokes
(20667,1885,1,1,2,5406), -- High Grade Suede
(20667,4127,1,1,2,1606), -- Recipe: Adamantite Ring
(20667,4184,1,1,2,75), -- Recipe: Sprite\'s Staff
(20667,5155,1,1,2,130), -- Recipe: Soulshot (B) Compressed Package (100%)
(20667,5165,1,1,2,130), -- Recipe: Blessed Spiritshot (B) Compressed Package (100%)
(20667,5549,1,1,2,6487), -- Metallic Thread
(20667,5550,1,1,2,865), -- Durable Metal Plate
(20668,1806,1,1,-1,2819), -- Recipe: Soulshot: B-Grade
(20668,2917,1,1,-1,80961), -- Ring of Binding Gemstone
(20668,4147,1,1,-1,14487), -- Recipe: Stockings of Zubei
(20668,57,568,1157,0,700000), -- Adena
(20668,203,1,1,1,3), -- Pa\'agrian Axe
(20668,204,1,1,1,2), -- Deadman\'s Staff
(20668,205,1,1,1,2), -- Ghoul\'s Staff
(20668,206,1,1,1,2), -- Demon\'s Staff
(20668,2112,1,1,1,253), -- Pa\'agrian Axe Blade
(20668,2116,1,1,1,245), -- Deadman\'s Staff Head
(20668,2117,1,1,1,245), -- Ghoul\'s Staff Head
(20668,2118,1,1,1,245), -- Demon\'s Staff Head
(20668,2503,1,1,1,2), -- Yaksa Mace
(20668,2969,1,1,1,251), -- Yaksa Mace Head
(20668,1866,1,1,2,49567), -- Suede
(20668,1871,1,1,2,74350), -- Charcoal
(20668,1885,1,1,2,6196), -- High Grade Suede
(20668,4041,1,1,2,647), -- Mold Hardener
(20668,4148,1,1,2,327), -- Recipe: Avadon Robe
(20668,4936,1,1,2,1365), -- Recipe: Avadon Shield (60%)
(20668,5220,1,1,2,2975), -- Metal Hardener
(20669,4057,1,1,-1,49216), -- Zubei\'s Gaiter Material
(20669,4198,1,1,-1,1343), -- Recipe: Bellion Cestus
(20669,4589,1,1,-1,5865), -- Greater Dye of Strength <Str+2 Con-2>
(20669,57,709,1445,0,700000), -- Adena
(20669,286,1,1,1,11), -- Eminence Bow
(20669,2121,1,1,1,1494), -- Eminence Bow Shaft
(20669,1866,1,1,2,43310), -- Suede
(20669,1871,1,1,2,64965), -- Charcoal
(20669,1877,1,1,2,2599), -- Adamantite Nugget
(20669,4040,1,1,2,1300), -- Mold Lubricant
(20669,4041,1,1,2,565), -- Mold Hardener
(20669,4186,1,1,2,75), -- Recipe: Sword of Valhalla
(20669,4191,1,1,2,75), -- Recipe: Great Axe
(20669,5160,1,1,2,130), -- Recipe: Spiritshot (B) Compressed Package (100%)
(20669,5275,1,1,2,130), -- Recipe: Greater Spiritshot (B) Compressed Package(100%)
(20669,6669,1,1,2,15108), -- Deluxe Chest Key - Grade 5
(20670,948,1,1,-1,4558), -- Scroll: Enchant Armor (Grade B)
(20670,4065,1,1,-1,51000), -- Avadon Gaiters Material
(20670,4129,1,1,-1,19732), -- Recipe: Earrings of Black Ore
(20670,57,737,1495,0,700000), -- Adena
(20670,503,1,1,1,18), -- Zubei\'s Helmet
(20670,633,1,1,1,25), -- Zubei\'s Shield
(20670,673,1,1,1,25), -- Avadon Shield
(20670,2415,1,1,1,18), -- Avadon Circlet
(20670,4072,1,1,1,3025), -- Avadon Circlet Pattern
(20670,4101,1,1,1,3904), -- Zubei\'s Shield Fragment
(20670,4102,1,1,1,3025), -- Zubei\'s Helmet Design
(20670,4439,1,1,1,4644), -- Avadon Shield Fragment
(20670,1864,1,1,2,134640), -- Stem
(20670,1869,1,1,2,67320), -- Iron Ore
(20670,1880,1,1,2,6733), -- Steel
(20670,4043,1,1,2,2245), -- Asofe
(20670,4164,1,1,2,446), -- Recipe: Stockings of Doom
(20670,4168,1,1,2,838), -- Recipe: Doom Gloves
(20670,4616,1,1,2,93), -- Greater Dye of Constitution <Con+4 Dex-4>
(20670,5550,1,1,2,898), -- Durable Metal Plate
(20671,947,1,1,-1,763), -- Scroll: Enchant Weapon (Grade B)
(20671,2098,1,1,-1,10215), -- Nirvana Axe Blade
(20671,4052,1,1,-1,67520), -- Earring of Black Ore Piece
(20671,57,771,1563,0,700000), -- Adena
(20671,358,1,1,1,6), -- Blue Wolf Breastplate
(20671,2380,1,1,1,10), -- Blue Wolf Gaiters
(20671,2381,1,1,1,4), -- Doom Plate Armor
(20671,4078,1,1,1,1372), -- Blue Wolf Breastplate Part
(20671,4080,1,1,1,1932), -- Blue Wolf Gaiters Material
(20671,4081,1,1,1,926), -- Doom Plate Armor Temper
(20671,1895,1,1,2,26826), -- Metallic Fiber
(20671,4040,1,1,2,1878), -- Mold Lubricant
(20671,4042,1,1,2,1565), -- Enria
(20671,4043,1,1,2,3130), -- Asofe
(20671,8616,1,1,2,3546), -- Spellbook: Summon Friend
(20671,8890,1,1,2,2358), -- Spellbook: Summon Attractive Cubic
(20671,10057,1,1,2,2950), -- Battle Manual: Create Dark Seed
(20671,10089,1,1,2,3289), -- Battle Manual: Imbue Dark Seed
(20671,4973,1,1,2,1017), -- Recipe: Earring of Black Ore (70%)
(20671,5276,1,1,2,126), -- Recipe: Greater Spiritshot (A) Compressed Package(100%)
(20672,4052,1,1,-1,68521), -- Earring of Black Ore Piece
(20672,4070,1,1,-1,69281), -- Stockings of Zubei Fabric
(20672,4154,1,1,-1,22904), -- Recipe: Doom Shield
(20672,57,783,1585,0,700000), -- Adena
(20672,601,1,1,1,18), -- Boots of Doom
(20672,2439,1,1,1,18), -- Blue Wolf Boots
(20672,2475,1,1,1,18), -- Doom Gloves
(20672,2487,1,1,1,18), -- Blue Wolf Gloves
(20672,4090,1,1,1,3208), -- Blue Wolf Boots Design
(20672,4091,1,1,1,3208), -- Doom Gloves Part
(20672,4096,1,1,1,3208), -- Blue Wolf Gloves Fabric
(20672,4099,1,1,1,3208), -- Doom Boots Part
(20672,1868,1,1,2,163337), -- Thread
(20672,1873,1,1,2,32668), -- Silver Nugget
(20672,1889,1,1,2,5445), -- Compound Braid
(20672,4044,1,1,2,2723), -- Thons
(20672,4991,1,1,2,675), -- Recipe: Doom Helmet (60%)
(20672,5276,1,1,2,109), -- Recipe: Greater Spiritshot (A) Compressed Package(100%)
(20672,5549,1,1,2,8167), -- Metallic Thread
(20673,4041,1,1,-1,17584), -- Mold Hardener
(20673,4052,1,1,-1,71593), -- Earring of Black Ore Piece
(20673,5230,1,1,-1,2696), -- Recipe: Mithril Arrow (100%)
(20673,57,819,1656,0,700000), -- Adena
(20673,79,1,1,1,5), -- Sword of Damascus
(20673,4114,1,1,1,1308), -- Sword of Damascus Blade
(20673,1867,1,1,2,113774), -- Animal Skin
(20673,1872,1,1,2,113774), -- Animal Bone
(20673,1875,1,1,2,5689), -- Stone of Purity
(20673,1881,1,1,2,11378), -- Coarse Bone Powder
(20673,4041,1,1,2,743), -- Mold Hardener
(20673,4150,1,1,2,1645), -- Recipe: Avadon Gloves
(20673,6037,1,1,2,170661), -- Waking Scroll
(20674,2089,1,1,-1,15893), -- Caliburs Edge
(20674,4053,1,1,-1,125008), -- Ring of Black Ore Gemstone
(20674,4124,1,1,-1,129619), -- Recipe: Craftsman Mold
(20674,57,1179,2390,0,700000), -- Adena
(20674,601,1,1,1,27), -- Boots of Doom
(20674,2439,1,1,1,27), -- Blue Wolf Boots
(20674,2475,1,1,1,27), -- Doom Gloves
(20674,2487,1,1,1,27), -- Blue Wolf Gloves
(20674,4090,1,1,1,4833), -- Blue Wolf Boots Design
(20674,4091,1,1,1,4833), -- Doom Gloves Part
(20674,4096,1,1,1,4833), -- Blue Wolf Gloves Fabric
(20674,4099,1,1,1,4833), -- Doom Boots Part
(20674,1867,1,1,2,164090), -- Animal Skin
(20674,1872,1,1,2,164090), -- Animal Bone
(20674,1875,1,1,2,8205), -- Stone of Purity
(20674,1881,1,1,2,16409), -- Coarse Bone Powder
(20674,4041,1,1,2,1071), -- Mold Hardener
(20674,4157,1,1,2,613), -- Recipe: Blue Wolf Gaiters
(20674,5276,1,1,2,164), -- Recipe: Greater Spiritshot (A) Compressed Package(100%)
(20675,1539,1,1,-1,277568), -- Greater Healing Potion
(20675,4042,1,1,-1,20818), -- Enria
(20675,4602,1,1,-1,2776), -- Greater Dye of Strength <Str+3 Dex-3>
(20675,57,504,1024,0,700000), -- Adena
(20675,60,1,1,1,36), -- Composite Armor
(20675,1977,1,1,1,3821), -- Composite Armor Temper
(20675,1867,1,1,2,86089), -- Animal Skin
(20675,1872,1,1,2,86089), -- Animal Bone
(20675,1875,1,1,2,4305), -- Stone of Purity
(20675,1881,1,1,2,8609), -- Coarse Bone Powder
(20675,2353,1,1,2,106), -- Recipe: Samurai Longsword
(20675,4041,1,1,2,562), -- Mold Hardener
(20675,4184,1,1,2,75), -- Recipe: Sprite\'s Staff
(20675,5155,1,1,2,130), -- Recipe: Soulshot (B) Compressed Package (100%)
(20676,1807,1,1,-1,2790), -- Recipe: Soulshot: A-Grade
(20676,5478,1,1,-1,17595), -- Sealed Dark Crystal Leather Armor Pattern
(20676,5479,1,1,-1,12381), -- Sealed Tallum Leather Armor Pattern
(20676,57,846,1715,0,700000), -- Adena
(20676,864,1,1,1,23), -- Earring of Black Ore
(20676,895,1,1,1,34), -- Ring of Black Ore
(20676,926,1,1,1,17), -- Necklace of Black Ore
(20676,4052,1,1,1,3647), -- Earring of Black Ore Piece
(20676,4053,1,1,1,4415), -- Ring of Black Ore Gemstone
(20676,4054,1,1,1,2029), -- Necklace of Black Ore Beads
(20676,1867,1,1,2,137350), -- Animal Skin
(20676,1872,1,1,2,137350), -- Animal Bone
(20676,1882,1,1,2,22892), -- Leather
(20676,1894,1,1,2,3615), -- Crafted Leather
(20676,4042,1,1,2,1717), -- Enria
(20676,6036,1,1,2,3435), -- Greater Magic Haste Potion
(20677,3035,1,1,-1,3141), -- Recipe: Spiritshot A
(20677,5230,1,1,-1,3141), -- Recipe: Mithril Arrow (100%)
(20677,5482,1,1,-1,31092), -- Sealed Dark Crystalline Leggings Design
(20677,57,952,1930,0,700000), -- Adena
(20677,287,1,1,1,6), -- Bow of Peril
(20677,4121,1,1,1,1516), -- Bow of Peril Shaft
(20677,1864,1,1,2,278330), -- Stem
(20677,1869,1,1,2,139165), -- Iron Ore
(20677,1880,1,1,2,13917), -- Steel
(20677,4043,1,1,2,4639), -- Asofe
(20677,5550,1,1,2,1856), -- Durable Metal Plate
(20678,1918,1,1,-1,58115), -- Nassen\'s Earring Gemstone
(20678,1989,1,1,-1,40443), -- Divine Stocking Pattern
(20678,4142,1,1,-1,10322), -- Recipe: Avadon Gaiters
(20678,57,542,1100,0,700000), -- Adena
(20678,266,1,1,1,9), -- Great Pata
(20678,2120,1,1,1,1190), -- Great Pata Blade
(20678,1895,1,1,2,20224), -- Metallic Fiber
(20678,4040,1,1,2,1416), -- Mold Lubricant
(20678,4042,1,1,2,1180), -- Enria
(20678,4043,1,1,2,2360), -- Asofe
(20678,4128,1,1,2,877), -- Recipe: Adamantite Necklace
(20678,4134,1,1,2,545), -- Recipe: Zubei\'s Gaiters
(20678,5280,1,1,2,142), -- Recipe: Greater Blessed Spiritshot (B) Compressed Package(100%)
(20679,1806,1,1,-1,2764), -- Recipe: Soulshot: B-Grade
(20679,1920,1,1,-1,47285), -- Necklace of Binding Chain
(20679,4148,1,1,-1,6061), -- Recipe: Avadon Robe
(20679,57,557,1134,0,700000), -- Adena
(20679,203,1,1,1,3), -- Pa\'agrian Axe
(20679,204,1,1,1,2), -- Deadman\'s Staff
(20679,205,1,1,1,2), -- Ghoul\'s Staff
(20679,206,1,1,1,2), -- Demon\'s Staff
(20679,2112,1,1,1,248), -- Pa\'agrian Axe Blade
(20679,2116,1,1,1,241), -- Deadman\'s Staff Head
(20679,2117,1,1,1,241), -- Ghoul\'s Staff Head
(20679,2118,1,1,1,241), -- Demon\'s Staff Head
(20679,2503,1,1,1,2), -- Yaksa Mace
(20679,2969,1,1,1,246), -- Yaksa Mace Head
(20679,1867,1,1,2,75592), -- Animal Skin
(20679,1869,1,1,2,56694), -- Iron Ore
(20679,1870,1,1,2,56694), -- Coal
(20679,1871,1,1,2,56694), -- Charcoal
(20679,1872,1,1,2,75592), -- Animal Bone
(20679,4143,1,1,2,364), -- Recipe: Zubei\'s Leather Shirt
(20679,4149,1,1,2,729), -- Recipe: Avadon Circlet
(20679,4186,1,1,2,66), -- Recipe: Sword of Valhalla
(20679,5160,1,1,2,114), -- Recipe: Spiritshot (B) Compressed Package (100%)
(20680,1873,1,1,-1,585562), -- Silver Nugget
(20680,1876,1,1,-1,292781), -- Mithril Ore
(20680,3034,1,1,-1,2928), -- Recipe: Spiritshot B
(20680,57,590,1202,0,700000), -- Adena
(20680,299,1,1,1,3), -- Orcish Poleaxe
(20680,301,1,1,1,4), -- Scorpion
(20680,303,1,1,1,4), -- Widow Maker
(20680,2113,1,1,1,437), -- Scorpion Blade
(20680,2114,1,1,1,437), -- Widowmaker Head
(20680,2122,1,1,1,412), -- Orcish Poleaxe Blade
(20680,1874,1,1,2,5148), -- Oriharukon Ore
(20680,1878,1,1,2,30887), -- Braided Hemp
(20680,1884,1,1,2,47518), -- Cord
(20680,1889,1,1,2,5148), -- Compound Braid
(20680,4441,1,1,2,1417), -- Recipe: Avadon Shield
(20680,5220,1,1,2,3089), -- Metal Hardener
(20680,5280,1,1,2,155), -- Recipe: Greater Blessed Spiritshot (B) Compressed Package(100%)
(20681,1873,1,1,-1,403669), -- Silver Nugget
(20681,1908,1,1,-1,95566), -- Moonstone Earring Wire
(20681,2063,1,1,-1,7800), -- Battle Axe Head
(20681,57,407,827,0,700000), -- Adena
(20681,71,1,1,1,11), -- Flamberge
(20681,72,1,1,1,11), -- Stormbringer
(20681,2059,1,1,1,886), -- Flamberge Blade
(20681,2060,1,1,1,947), -- Stormbringer Blade
(20681,1866,1,1,2,39746), -- Suede
(20681,1871,1,1,2,59620), -- Charcoal
(20681,1885,1,1,2,4969), -- High Grade Suede
(20681,2225,1,1,2,1297), -- Recipe: Demon\'s Stockings
(20681,2321,1,1,2,208), -- Recipe: Stiletto
(20681,4041,1,1,2,519), -- Mold Hardener
(20681,4440,1,1,2,208), -- Recipe: Knuckle Duster
(20681,5220,1,1,2,2385), -- Metal Hardener
(20682,951,1,1,-1,1826), -- Scroll: Enchant Weapon (Grade C)
(20682,1876,1,1,-1,200889), -- Mithril Ore
(20682,4039,1,1,-1,33482), -- Mold Glue
(20682,57,404,825,0,700000), -- Adena
(20682,397,1,1,1,63), -- Mithril Shirt
(20682,1961,1,1,1,3798), -- Mithril Shirt Fabric
(20682,2387,1,1,1,101), -- Tempered Mithril Gaiters
(20682,2935,1,1,1,6310), -- Tempered Mithril Gaiters Fragment
(20682,1865,1,1,2,79120), -- Varnish
(20682,1870,1,1,2,79120), -- Coal
(20682,1874,1,1,2,5275), -- Oriharukon Ore
(20682,2323,1,1,2,276), -- Recipe: Elemental Bow
(20682,4039,1,1,2,2638), -- Mold Glue
(20682,4043,1,1,2,2638), -- Asofe
(20683,1889,1,1,-1,87064), -- Compound Braid
(20683,1974,1,1,-1,109837), -- Crimson Boot Fabric
(20683,2336,1,1,-1,3037), -- Recipe: Nirvana Axe
(20683,57,526,1073,0,700000), -- Adena
(20683,227,1,1,1,11), -- Stiletto
(20683,242,1,1,1,11), -- Soulfire Dirk
(20683,2083,1,1,1,962), -- Stiletto Edge
(20683,2084,1,1,1,962), -- Soulfire Dirk Blade
(20683,1868,1,1,2,144661), -- Thread
(20683,1873,1,1,2,28933), -- Silver Nugget
(20683,1889,1,1,2,4822), -- Compound Braid
(20683,2224,1,1,2,983), -- Recipe: Demon\'s Tunic
(20683,2230,1,1,2,1402), -- Recipe: Theca Leather Gaiters
(20683,3005,1,1,2,2953), -- Recipe: Demon\'s Boots
(20683,4044,1,1,2,2412), -- Thons
(20683,5549,1,1,2,7234), -- Metallic Thread
(20684,1876,1,1,-1,273432), -- Mithril Ore
(20684,1966,1,1,-1,49915), -- Plated Leather Fragment
(20684,2078,1,1,-1,9084), -- Katana Blade
(20684,57,551,1121,0,700000), -- Adena
(20684,398,1,1,1,34), -- Plated Leather
(20684,399,1,1,1,32), -- Rind Leather Armor
(20684,418,1,1,1,55), -- Plated Leather Gaiters
(20684,419,1,1,1,51), -- Rind Leather Gaiters
(20684,1966,1,1,1,2765), -- Plated Leather Fragment
(20684,1967,1,1,1,4130), -- Plated Leather Gaiters Material
(20684,1975,1,1,1,2487), -- Rind Leather Armor Design
(20684,1976,1,1,1,4604), -- Rind Leather Gaiters Material
(20684,1539,1,1,2,16827), -- Greater Healing Potion
(20684,1866,1,1,2,50480), -- Suede
(20684,1871,1,1,2,75720), -- Charcoal
(20684,1877,1,1,2,3029), -- Adamantite Nugget
(20684,2341,1,1,2,177), -- Recipe: Sage\'s Staff
(20684,4040,1,1,2,1515), -- Mold Lubricant
(20684,4041,1,1,2,659), -- Mold Hardener
(20684,6668,1,1,2,27043), -- Deluxe Chest Key - Grade 4
(20685,1970,1,1,-1,25480), -- Robe of Seal Fabric
(20685,2090,1,1,-1,6218), -- Delusional Blade
(20685,2166,1,1,-1,38678), -- Recipe: Earrings of Binding (100%)
(20685,57,459,937,0,700000), -- Adena
(20685,195,1,1,1,9), -- Cursed Staff
(20685,2082,1,1,1,891), -- Cursed Staff Head
(20685,2502,1,1,1,9), -- Dwarven War Hammer
(20685,2968,1,1,1,853), -- Dwarven Warhammer Head
(20685,1867,1,1,2,96296), -- Animal Skin
(20685,1872,1,1,2,96296), -- Animal Bone
(20685,1875,1,1,2,4815), -- Stone of Purity
(20685,1881,1,1,2,9630), -- Coarse Bone Powder
(20685,2330,1,1,2,169), -- Recipe: Homunkulus\'s Sword
(20685,2351,1,1,2,151), -- Recipe: Scorpion
(20685,4041,1,1,2,629), -- Mold Hardener
(20686,1880,1,1,-1,238035), -- Steel
(20686,2169,1,1,-1,42130), -- Recipe: Necklace of Binding
(20686,2231,1,1,-1,10260), -- Recipe: Full Plate Armor
(20686,57,960,1952,0,700000), -- Adena
(20686,326,1,1,1,23), -- Heathen\'s Book
(20686,2110,1,1,1,2775), -- Heathen\'s Book Page
(20686,1866,1,1,2,82031), -- Suede
(20686,1871,1,1,2,123046), -- Charcoal
(20686,1877,1,1,2,4922), -- Adamantite Nugget
(20686,2354,1,1,2,201), -- Recipe: Deadman\'s Staff
(20686,2358,1,1,2,201), -- Recipe: Great Pata
(20686,4040,1,1,2,2461), -- Mold Lubricant
(20686,4041,1,1,2,1070), -- Mold Hardener
(20686,4609,1,1,2,274), -- Greater Dye of Mental Strength <Men+3 Int-3>
(20745,848,1,1,-1,4157), -- Enchanted Earring
(20745,1832,1,3,-1,491857), -- Greater Antidote
(20745,1901,1,1,-1,122285), -- Tiger\'s Eye Earring Stone
(20745,57,374,746,0,700000), -- Adena
(20745,393,1,1,1,104), -- Mithril Banded Mail
(20745,394,1,1,1,104), -- Reinforced Leather Shirt
(20745,415,1,1,1,165), -- Mithril Banded Gaiters
(20745,416,1,1,1,165), -- Reinforced Leather Gaiters
(20745,1938,1,1,1,5275), -- Mithril Banded Mail Material
(20745,1939,1,1,1,6892), -- Mithril Banded Gaiters Material
(20745,1867,1,1,2,125528), -- Animal Skin
(20745,1872,1,1,2,125528), -- Animal Bone
(20745,1882,1,1,2,20922), -- Leather
(20745,2156,1,1,2,7532), -- Recipe: Elven Necklace
(20745,2272,1,1,2,673), -- Recipe: Sword of Revolution
(20746,1061,1,1,-1,420371), -- Healing Potion
(20746,1900,1,1,-1,75887), -- Enchanted Necklace Chain
(20746,2153,1,1,-1,107871), -- Recipe: Tiger\'s Eye Earring
(20746,57,293,585,0,700000), -- Adena
(20746,259,1,1,1,118), -- Single-Edged Jamadhr
(20746,1865,1,1,2,63172), -- Varnish
(20746,1870,1,1,2,63172), -- Coal
(20746,1875,1,1,2,4212), -- Stone of Purity
(20746,1879,1,1,2,10529), -- Cokes
(20746,2184,1,1,2,6636), -- Recipe: Mithril Banded Gaiters
(20746,2272,1,1,2,452), -- Recipe: Sword of Revolution
(20747,1900,1,1,-1,106736), -- Enchanted Necklace Chain
(20747,2024,1,1,-1,13897), -- Elven Bow Shaft
(20747,2203,1,1,-1,212542), -- Recipe: Mithril Boots
(20747,57,411,824,0,700000), -- Adena
(20747,46,1,1,1,1067), -- Bronze Helmet
(20747,627,1,1,1,1523), -- Aspis
(20747,1867,1,1,2,101545), -- Animal Skin
(20747,1872,1,1,2,101545), -- Animal Bone
(20747,1875,1,1,2,5078), -- Stone of Purity
(20747,1881,1,1,2,10155), -- Coarse Bone Powder
(20747,2183,1,1,2,5011), -- Recipe: Mithril Banded Mail
(20747,2274,1,1,2,544), -- Recipe: Skull Breaker
(20747,2282,1,1,2,544), -- Recipe: Cursed Maingauche
(20748,1061,1,1,-1,556782), -- Healing Potion
(20748,1866,1,1,-1,612460), -- Suede
(20748,1871,1,1,-1,918690), -- Charcoal
(20748,57,389,771,0,700000), -- Adena
(20748,275,1,1,1,52), -- Long Bow
(20748,276,1,1,1,52), -- Elven Bow
(20748,2024,1,1,1,2385), -- Elven Bow Shaft
(20748,956,1,1,2,2391), -- Scroll: Enchant Armor (Grade D)
(20748,1831,1,1,2,191249), -- Antidote
(20748,1866,1,1,2,47813), -- Suede
(20748,1871,1,1,2,71719), -- Charcoal
(20748,1885,1,1,2,5977), -- High Grade Suede
(20748,2190,1,1,2,5123), -- Recipe: Mithril Stockings
(20748,5220,1,1,2,2869), -- Metal Hardener
(20749,1871,1,3,-1,487784), -- Charcoal
(20749,2025,1,1,-1,13512), -- Dwarven Trident Edge
(20749,2153,1,1,-1,151721), -- Recipe: Tiger\'s Eye Earring
(20749,57,411,824,0,700000), -- Adena
(20749,46,1,1,1,1067), -- Bronze Helmet
(20749,627,1,1,1,1523), -- Aspis
(20749,1866,1,1,2,88852), -- Suede
(20749,1871,1,1,2,133278), -- Charcoal
(20749,1877,1,1,2,5332), -- Adamantite Nugget
(20749,2184,1,1,2,14000), -- Recipe: Mithril Banded Gaiters
(20750,1933,1,1,-1,111906), -- Dark Stocking Fabric
(20750,1935,1,1,-1,53140), -- Scale Mail Fragment
(20750,2183,1,1,-1,62579), -- Recipe: Mithril Banded Mail
(20750,57,403,798,0,700000), -- Adena
(20750,222,1,1,1,161), -- Poniard Dagger
(20750,1829,1,1,2,41584), -- Scroll of Escape: Clan Hall
(20750,1831,1,3,2,138613), -- Antidote
(20750,1867,1,1,2,138613), -- Animal Skin
(20750,1872,1,1,2,138613), -- Animal Bone
(20750,1882,1,1,2,23103), -- Leather
(20751,1894,1,1,-1,77496), -- Crafted Leather
(20751,1949,1,1,-1,246500), -- Mithril Gloves Design
(20751,2161,1,1,-1,214431), -- Recipe: Aquastone Ring
(20751,57,887,1817,0,700000), -- Adena
(20751,62,1,1,1,93), -- Mithril Boots
(20751,1958,1,1,1,5213), -- Mithril Boots Design
(20751,2429,1,1,1,93), -- Chain Boots
(20751,2430,1,1,1,93), -- Karmian Boots
(20751,2431,1,1,1,93), -- Plated Leather Boots
(20751,2432,1,1,1,93), -- Dwarven Chain Boots
(20751,2433,1,1,1,93), -- Boots of Seal
(20751,2452,1,1,1,93), -- Reinforced Mithril Gloves
(20751,2453,1,1,1,93), -- Chain Gloves
(20751,2454,1,1,1,93), -- Karmian Gloves
(20751,2937,1,1,1,5213), -- Chain Boots Part
(20751,2938,1,1,1,5213), -- Karmian Boots Fabric
(20751,2939,1,1,1,5213), -- Plate Leather Boot Lining
(20751,2940,1,1,1,5213), -- Dwarven Chain Boots Part
(20751,2941,1,1,1,5213), -- Boots of Seal Pattern
(20751,2942,1,1,1,5213), -- Reinforced Mithril Gloves Design
(20751,2943,1,1,1,5213), -- Chain Gloves Design
(20751,2944,1,1,1,5213), -- Karmian Gloves Fabric
(20751,1894,1,1,2,9157), -- Crafted Leather
(20751,2216,1,1,2,10784), -- Recipe: Great Helmet
(20751,2225,1,1,2,5673), -- Recipe: Demon\'s Stockings
(20751,2321,1,1,2,910), -- Recipe: Stiletto
(20752,1805,1,1,-1,6668), -- Recipe: Soulshot: C-Grade
(20752,1905,1,1,-1,194586), -- Omen Beast\'s Eye Earring Gemstone
(20752,5549,1,1,-1,200035), -- Metallic Thread
(20752,57,817,1652,0,700000), -- Adena
(20752,353,1,1,1,129), -- Half Plate Armor
(20752,380,1,1,1,206), -- Plate Gaiters
(20752,1950,1,1,1,8151), -- Half Plate Temper
(20752,1951,1,1,1,12677), -- Plate Gaiters Part
(20752,1868,1,1,2,286995), -- Thread
(20752,1873,1,1,2,57399), -- Silver Nugget
(20752,1889,1,1,2,9567), -- Compound Braid
(20752,2160,1,1,2,9258), -- Recipe: Moonstone Earring
(20752,2312,1,1,2,628), -- Recipe: Crystallized Ice Bow
(20752,5159,1,1,2,479), -- Recipe: Spiritshot (C) Compressed Package (100%)
(20752,5549,1,1,2,14350), -- Metallic Thread
(20753,1874,1,1,-1,186818), -- Oriharukon Ore
(20753,1875,1,1,-1,186818), -- Stone of Purity
(20753,4601,1,1,-1,6227), -- Greater Dye of Strength <Str+3 Con-3>
(20753,57,1131,2298,0,700000), -- Adena
(20753,75,1,1,1,5), -- Caliburs
(20753,76,1,1,1,5), -- Sword of Delusion
(20753,77,1,1,1,5), -- Tsurugi
(20753,84,1,1,1,5), -- Homunkulus\'s Sword
(20753,134,1,1,1,5), -- Sword of Nightmare
(20753,145,1,1,1,5), -- Sword of Whispering Death
(20753,2089,1,1,1,527), -- Caliburs Edge
(20753,2090,1,1,1,527), -- Delusional Blade
(20753,2091,1,1,1,527), -- Tsurugi Blade
(20753,2092,1,1,1,527), -- Homunkulus\'s Sword Blade
(20753,2095,1,1,1,527), -- Sword of Nightmare Blade
(20753,2096,1,1,1,527), -- Sword of Whispering Death Blade
(20753,1342,10,30,2,257523), -- Fine Steel Arrow
(20753,1868,1,3,2,128762), -- Thread
(20753,1873,1,1,2,51505), -- Silver Nugget
(20753,1889,1,1,2,8585), -- Compound Braid
(20753,2355,1,1,2,210), -- Recipe: Ghoul\'s Staff
(20753,3019,1,1,2,3434), -- Recipe: Full Plate Shield
(20753,4044,1,1,2,4292), -- Thons
(20753,4609,1,1,2,287), -- Greater Dye of Mental Strength <Men+3 Int-3>
(20753,5549,1,1,2,12876), -- Metallic Thread
(20754,1869,1,7,-1,772301), -- Iron Ore
(20754,1911,1,1,-1,229766), -- Earring of Protection Gemstone
(20754,1967,1,1,-1,168487), -- Plated Leather Gaiters Material
(20754,57,1246,2533,0,700000), -- Adena
(20754,94,1,1,1,48), -- Bec de Corbin
(20754,2079,1,1,1,4703), -- Bec De Corbin Blade
(20754,1864,1,3,2,195537), -- Stem
(20754,1869,1,1,2,195537), -- Iron Ore
(20754,1880,1,1,2,19554), -- Steel
(20754,2167,1,1,2,9977), -- Recipe: Ring of Ages
(20754,3009,1,1,2,7982), -- Recipe: Composite Boots
(20754,4043,1,1,2,6518), -- Asofe
(20754,5550,1,1,2,2607), -- Durable Metal Plate
(20755,1061,1,1,-1,403626), -- Healing Potion
(20755,1900,1,1,-1,72865), -- Enchanted Necklace Chain
(20755,2184,1,1,-1,69956), -- Recipe: Mithril Banded Gaiters
(20755,57,281,562,0,700000), -- Adena
(20755,222,1,1,1,113), -- Poniard Dagger
(20755,1341,10,30,2,151641), -- Bone Arrow
(20755,1829,1,1,2,18197), -- Scroll of Escape: Clan Hall
(20755,1876,1,1,2,9099), -- Mithril Ore
(20755,1877,1,1,2,1820), -- Adamantite Nugget
(20755,1880,1,1,2,4550), -- Steel
(20755,1881,1,1,2,6066), -- Coarse Bone Powder
(20755,1882,1,1,2,10110), -- Leather
(20755,2274,1,1,2,325), -- Recipe: Skull Breaker
(20756,1899,1,1,-1,101019), -- Necklace of Devotion Chain
(20756,1932,1,1,-1,102623), -- Bone Helmet Design
(20756,2262,1,1,-1,10039), -- Recipe: Elven Bow
(20756,57,277,543,0,700000), -- Adena
(20756,274,1,1,1,177), -- Strengthened Bow
(20756,1868,1,1,2,145140), -- Thread
(20756,1873,1,1,2,29028), -- Silver Nugget
(20756,1876,1,1,2,14514), -- Mithril Ore
(20756,2152,1,1,2,12777), -- Recipe: Enchanted Necklace
(20756,6035,1,1,2,6048), -- Magic Haste Potion
(20757,847,1,1,-1,3546), -- Red Crescent Earring
(20757,1868,1,3,-1,476958), -- Thread
(20757,2180,1,1,-1,35861), -- Recipe: Scale Mail
(20757,57,206,397,0,700000), -- Adena
(20757,291,1,1,1,66), -- Trident
(20757,2019,1,1,1,2879), -- Trident Edge
(20757,1875,1,1,2,2975), -- Stone of Purity
(20757,1879,1,1,2,7436), -- Cokes
(20757,1885,1,1,2,3718), -- High Grade Suede
(20757,2152,1,1,2,7855), -- Recipe: Enchanted Necklace
(20757,5549,1,1,2,4462), -- Metallic Thread
(20757,5550,1,1,2,595), -- Durable Metal Plate
(20758,2167,1,1,-1,87619), -- Recipe: Ring of Ages
(20758,2946,1,1,-1,95994), -- Plate Leather Gloves Design
(20758,57,691,1410,0,700000), -- Adena
(20758,853,1,1,1,130), -- Earring of Protection
(20758,884,1,1,1,196), -- Ring of Protection
(20758,916,1,1,1,98), -- Necklace of Protection
(20758,1911,1,1,1,9434), -- Earring of Protection Gemstone
(20758,1912,1,1,1,13668), -- Ring of Protection Gemstone
(20758,1913,1,1,1,7713), -- Necklace of Protection Gemstone
(20758,952,1,1,2,1692), -- Scroll: Enchant Armor (Grade C)
(20758,1867,1,1,2,169091), -- Animal Skin
(20758,1872,1,1,2,169091), -- Animal Bone
(20758,1875,1,1,2,8455), -- Stone of Purity
(20758,1881,1,1,2,16910), -- Coarse Bone Powder
(20758,4041,1,1,2,1103), -- Mold Hardener
(20759,1912,1,1,-1,173912), -- Ring of Protection Gemstone
(20759,2166,1,1,-1,54709), -- Recipe: Earrings of Binding (100%)
(20759,2167,1,1,-1,82342), -- Recipe: Ring of Ages
(20759,57,651,1323,0,700000), -- Adena
(20759,398,1,1,1,41), -- Plated Leather
(20759,399,1,1,1,38), -- Rind Leather Armor
(20759,418,1,1,1,65), -- Plated Leather Gaiters
(20759,419,1,1,1,60), -- Rind Leather Gaiters
(20759,1966,1,1,1,3263), -- Plated Leather Fragment
(20759,1967,1,1,1,4875), -- Plated Leather Gaiters Material
(20759,1975,1,1,1,2936), -- Rind Leather Armor Design
(20759,1976,1,1,1,5435), -- Rind Leather Gaiters Material
(20759,952,1,1,2,1363), -- Scroll: Enchant Armor (Grade C)
(20759,1865,1,1,2,102155), -- Varnish
(20759,1870,1,1,2,102155), -- Coal
(20759,1874,1,1,2,6811), -- Oriharukon Ore
(20759,2168,1,1,2,2600), -- Recipe: Necklace of Mermaid
(20759,4039,1,1,2,3406), -- Mold Glue
(20759,4043,1,1,2,3406), -- Asofe
(20760,951,1,1,-1,3046), -- Scroll: Enchant Weapon (Grade C)
(20760,1871,1,3,-1,837724), -- Charcoal
(20760,1911,1,1,-1,124615), -- Earring of Protection Gemstone
(20760,57,674,1376,0,700000), -- Adena
(20760,398,1,1,1,42), -- Plated Leather
(20760,399,1,1,1,39), -- Rind Leather Armor
(20760,418,1,1,1,67), -- Plated Leather Gaiters
(20760,419,1,1,1,62), -- Rind Leather Gaiters
(20760,1966,1,1,1,3388), -- Plated Leather Fragment
(20760,1967,1,1,1,5061), -- Plated Leather Gaiters Material
(20760,1975,1,1,1,3048), -- Rind Leather Armor Design
(20760,1976,1,1,1,5642), -- Rind Leather Gaiters Material
(20760,951,1,1,2,169), -- Scroll: Enchant Weapon (Grade C)
(20760,1866,1,1,2,61863), -- Suede
(20760,1871,1,1,2,92795), -- Charcoal
(20760,1877,1,1,2,3712), -- Adamantite Nugget
(20760,2327,1,1,2,216), -- Recipe: Caliburs
(20760,2343,1,1,2,216), -- Recipe: Mace of the Underworld
(20760,4040,1,1,2,1856), -- Mold Lubricant
(20760,4041,1,1,2,807), -- Mold Hardener
(20761,1807,1,1,-1,9041), -- Recipe: Soulshot: A-Grade
(20761,1874,1,1,-1,452069), -- Oriharukon Ore
(20761,1875,1,1,-1,452069), -- Stone of Purity
(20761,57,2738,5559,0,700000), -- Adena
(20761,5287,1,1,1,15), -- Sealed Dark Crystal breastplate
(20761,5288,1,1,1,24), -- Sealed Dark Crystal Gaiters
(20761,5293,1,1,1,10), -- Sealed Tallum Plate Armor
(20761,5520,1,1,1,2153), -- Sealed Dark Crystal Breastplate Pattern
(20761,5521,1,1,1,1520), -- Sealed Tallum Plate Armor Pattern
(20761,5524,1,1,1,3291), -- Sealed Dark Crystal Gaiters Pattern
(20761,1868,1,3,2,286145), -- Thread
(20761,1873,1,1,2,114458), -- Silver Nugget
(20761,1889,1,1,2,19077), -- Compound Braid
(20761,4044,1,1,2,9539), -- Thons
(20761,4403,1,1,2,573), -- Red Dimensional Stone
(20761,4989,1,1,2,1896), -- Recipe: Stockings of Doom (60%)
(20761,5549,1,1,2,28615), -- Metallic Thread
(20762,1807,1,1,-1,6365), -- Recipe: Soulshot: A-Grade
(20762,5478,1,1,-1,40140), -- Sealed Dark Crystal Leather Armor Pattern
(20762,57,1926,3915,0,700000), -- Adena
(20762,5297,1,1,1,14), -- Sealed Dark Crystal Leather Armor
(20762,5298,1,1,1,22), -- Sealed Dark Crystalline Leggings
(20762,5301,1,1,1,10), -- Sealed Tallum Leather Armor
(20762,5478,1,1,1,1976), -- Sealed Dark Crystal Leather Armor Pattern
(20762,5479,1,1,1,1391), -- Sealed Tallum Leather Armor Pattern
(20762,5482,1,1,1,3102), -- Sealed Dark Crystalline Leggings Design
(20762,1807,1,1,2,314), -- Recipe: Soulshot: A-Grade
(20762,1867,1,3,2,104445), -- Animal Skin
(20762,1872,1,3,2,156667), -- Animal Bone
(20762,1875,1,1,2,15667), -- Stone of Purity
(20762,1881,1,1,2,31334), -- Coarse Bone Powder
(20762,4041,1,1,2,2044), -- Mold Hardener
(20763,1873,1,1,-1,505674), -- Silver Nugget
(20763,1902,1,1,-1,128084), -- Elven Earring Beads
(20763,1941,1,1,-1,50276), -- Brigandine Temper
(20763,57,530,1058,0,700000), -- Adena
(20763,129,1,1,1,47), -- Sword of Revolution
(20763,2034,1,1,1,3453), -- Sword of Revolution Blade
(20763,1867,1,1,2,145220), -- Animal Skin
(20763,1872,1,1,2,145220), -- Animal Bone
(20763,1875,1,1,2,7261), -- Stone of Purity
(20763,1881,1,1,2,14523), -- Coarse Bone Powder
(20763,2146,1,1,2,7780), -- Recipe: Artisan\'s frame
(20763,2196,1,1,2,4464), -- Recipe: Plate Gaiters
(20764,1825,1,1,-1,80925), -- Recipe: Oriharukon
(20764,1902,1,1,-1,114787), -- Elven Earring Beads
(20764,1903,1,1,-1,188982), -- Elven Ring Piece
(20764,57,479,955,0,700000), -- Adena
(20764,437,1,1,1,131), -- Mithril Tunic
(20764,470,1,1,1,210), -- Mithril Stockings
(20764,1944,1,1,1,7468), -- Mithril Tunic Fabric
(20764,1945,1,1,1,11629), -- Mithril Stocking Design
(20764,1867,1,1,2,130144), -- Animal Skin
(20764,1872,1,1,2,130144), -- Animal Bone
(20764,1875,1,1,2,6508), -- Stone of Purity
(20764,1881,1,1,2,13015), -- Coarse Bone Powder
(20764,2149,1,1,2,6972), -- Recipe: Metallic Fiber
(20764,5473,1,1,2,6972), -- Recipe: Durable Metal Plate(100%)
(20765,1873,1,1,-1,392112), -- Silver Nugget
(20765,1904,1,1,-1,91487), -- Elven Necklace Beads
(20765,2145,1,1,-1,70020), -- Recipe: Mithril Alloy
(20765,57,414,827,0,700000), -- Adena
(20765,850,1,1,1,181), -- Elven Earring
(20765,881,1,1,1,272), -- Elven Ring
(20765,913,1,1,1,136), -- Elven Necklace
(20765,1902,1,1,1,8558), -- Elven Earring Beads
(20765,1903,1,1,1,14089), -- Elven Ring Piece
(20765,1904,1,1,1,7883), -- Elven Necklace Beads
(20765,1868,1,1,2,168910), -- Thread
(20765,1873,1,1,2,33782), -- Silver Nugget
(20765,1876,1,1,2,16891), -- Mithril Ore
(20765,1895,1,1,2,24130), -- Metallic Fiber
(20765,2145,1,1,2,6033), -- Recipe: Mithril Alloy
(20765,2158,1,1,2,10453), -- Recipe: Mithril Ring
(20766,1869,1,1,-1,876362), -- Iron Ore
(20766,1901,1,1,-1,121045), -- Tiger\'s Eye Earring Stone
(20766,2154,1,1,-1,93829), -- Recipe: Elven Earring
(20766,57,369,741,0,700000), -- Adena
(20766,63,1,1,1,263), -- Gauntlets
(20766,553,1,1,1,263), -- Iron Boots
(20766,1940,1,1,1,9935), -- Iron Boots Design
(20766,2422,1,1,1,263), -- Reinforced Leather Boots
(20766,2423,1,1,1,263), -- Boots of Knowledge
(20766,2446,1,1,1,263), -- Reinforced Leather Gloves
(20766,2447,1,1,1,263), -- Gloves of Knowledge
(20766,1864,1,1,2,133131), -- Stem
(20766,1869,1,1,2,66566), -- Iron Ore
(20766,1878,1,1,2,26627), -- Braided Hemp
(20766,1884,1,1,2,40964), -- Cord
(20766,2155,1,1,2,10685), -- Recipe: Elven Ring
(20766,2195,1,1,2,1703), -- Recipe: Half Plate Armor
(20766,6035,1,1,2,5548), -- Magic Haste Potion
(20767,1879,1,1,-1,261151), -- Cokes
(20767,2076,1,1,-1,12289), -- Body Slasher Blade
(20767,2220,1,1,-1,32441), -- Recipe: Rind Leather Armor
(20767,57,632,1284,0,700000), -- Adena
(20767,281,1,1,1,33), -- Crystallized Ice Bow
(20767,2074,1,1,1,2623), -- Crystallized Ice Bow Shaft
(20767,1865,1,1,2,92568), -- Varnish
(20767,1870,1,1,2,92568), -- Coal
(20767,1875,1,1,2,6172), -- Stone of Purity
(20767,1879,1,1,2,15428), -- Cokes
(20767,2225,1,1,2,2013), -- Recipe: Demon\'s Stockings
(20767,2321,1,1,2,323), -- Recipe: Stiletto
(20767,2322,1,1,2,323), -- Recipe: Soulfire Dirk
(20767,4040,1,1,2,1852), -- Mold Lubricant
(20768,1908,1,1,-1,143002), -- Moonstone Earring Wire
(20768,1909,1,1,-1,203930), -- Aquastone Ring Wire
(20768,2163,1,1,-1,77046), -- Recipe: Earring of Protection
(20768,57,606,1242,0,700000), -- Adena
(20768,631,1,1,1,179), -- Eldarake
(20768,1964,1,1,1,9612), -- Eldarake Temper
(20768,2413,1,1,1,126), -- Chain Hood
(20768,2495,1,1,1,179), -- Chain Shield
(20768,2936,1,1,1,8730), -- Chain Hood Pattern
(20768,2945,1,1,1,9612), -- Chain Shield Fragment
(20768,1832,1,1,2,99125), -- Greater Antidote
(20768,1865,1,1,2,89212), -- Varnish
(20768,1870,1,1,2,89212), -- Coal
(20768,1875,1,1,2,5948), -- Stone of Purity
(20768,1879,1,1,2,14869), -- Cokes
(20768,2163,1,1,2,4552), -- Recipe: Earring of Protection
(20768,2315,1,1,2,311), -- Recipe: Shamshir
(20768,2319,1,1,2,311), -- Recipe: Raid Sword
(20769,1885,1,1,-1,100134), -- High Grade Suede
(20769,4469,1,1,-1,6866), -- Dye of Strength <Str+1 Con-1>
(20769,5220,1,1,-1,48064), -- Metal Hardener
(20769,57,485,985,0,700000), -- Adena
(20769,70,1,1,1,17), -- Claymore
(20769,2047,1,1,1,1327), -- Claymore Blade
(20769,2499,1,1,1,17), -- Elven Long Sword
(20769,2967,1,1,1,1309), -- Elven Long Sword Blade
(20769,1866,1,1,2,57466), -- Suede
(20769,1871,1,1,2,86199), -- Charcoal
(20769,1885,1,1,2,7184), -- High Grade Suede
(20769,2161,1,1,2,8369), -- Recipe: Aquastone Ring
(20769,2297,1,1,2,377), -- Recipe: Flamberge
(20769,5220,1,1,2,3449), -- Metal Hardener
(20769,5269,1,1,2,288), -- Recipe: Greater Soulshot (C) Compressed Package(100%)
(20770,1805,1,1,-1,4701), -- Recipe: Soulshot: C-Grade
(20770,1905,1,1,-1,137195), -- Omen Beast\'s Eye Earring Gemstone
(20770,1906,1,1,-1,193864), -- Mithril Ring Wire
(20770,57,580,1161,0,700000), -- Adena
(20770,159,1,1,1,8), -- Bonebreaker
(20770,187,1,1,1,8), -- Atuba Hammer
(20770,188,1,1,1,8), -- Ghost Staff
(20770,189,1,1,1,8), -- Staff of Life
(20770,190,1,1,1,8), -- Atuba Mace
(20770,2048,1,1,1,586), -- Bonebreaker Head
(20770,2049,1,1,1,586), -- Atuba Hammer Head
(20770,2050,1,1,1,621), -- Ghost Staff Head
(20770,2051,1,1,1,621), -- Staff of Life Shaft
(20770,2058,1,1,1,586), -- Atuba Mace Head
(20770,1805,1,1,2,338), -- Recipe: Soulshot: C-Grade
(20770,1867,1,1,2,134899), -- Animal Skin
(20770,1872,1,1,2,134899), -- Animal Bone
(20770,1882,1,1,2,22484), -- Leather
(20770,1894,1,1,2,3551), -- Crafted Leather
(20770,2298,1,1,2,442), -- Recipe: Stormbringer
(20770,5269,1,1,2,338), -- Recipe: Greater Soulshot (C) Compressed Package(100%)
(20771,948,1,1,-1,10950), -- Scroll: Enchant Armor (Grade B)
(20771,1875,1,1,-1,291994), -- Stone of Purity
(20771,4042,1,1,-1,72999), -- Enria
(20771,57,1774,3587,0,700000), -- Adena
(20771,171,1,1,1,4), -- Deadman\'s Glory
(20771,175,1,1,1,4), -- Art of Battle Axe
(20771,210,1,1,1,4), -- Staff of Evil Spirits
(20771,4116,1,1,1,943), -- Deadman\'s Glory Stone
(20771,4117,1,1,1,943), -- Art of Battle Axe Blade
(20771,4118,1,1,1,893), -- Evil Spirit Head
(20771,1895,1,1,2,61608), -- Metallic Fiber
(20771,4040,1,1,2,4313), -- Mold Lubricant
(20771,4042,1,1,2,3594), -- Enria
(20771,4043,1,1,2,7188), -- Asofe
(20771,4953,1,1,2,4155), -- Recipe: Avadon Gloves (60%)
(20771,5276,1,1,2,288), -- Recipe: Greater Spiritshot (A) Compressed Package(100%)
(20772,1875,1,1,-1,281689), -- Stone of Purity
(20772,1986,1,1,-1,44649), -- Full Plate Armor Temper
(20772,4613,1,1,-1,5828), -- Greater Dye of Strength <Str+4 Con-4>
(20772,57,1708,3463,0,700000), -- Adena
(20772,300,1,1,1,15), -- Great Axe
(20772,4113,1,1,1,3211), -- Great Axe Head
(20772,1867,1,1,2,208017), -- Animal Skin
(20772,1872,1,1,2,208017), -- Animal Bone
(20772,1875,1,1,2,10401), -- Stone of Purity
(20772,1881,1,1,2,20802), -- Coarse Bone Powder
(20772,4041,1,1,2,1357), -- Mold Hardener
(20772,4163,1,1,2,1033), -- Recipe: Blue Wolf Stockings
(20772,4618,1,1,2,216), -- Greater Dye of Dexterity <Dex+4 Con-4>
(20772,4999,1,1,2,1941), -- Recipe: Doom Boots (60%)
(20773,1807,1,1,-1,4827), -- Recipe: Soulshot: A-Grade
(20773,5478,1,1,-1,30441), -- Sealed Dark Crystal Leather Armor Pattern
(20773,5479,1,1,-1,21420), -- Sealed Tallum Leather Armor Pattern
(20773,57,1457,2974,0,700000), -- Adena
(20773,6323,1,1,1,21), -- Sealed Phoenix Necklace
(20773,6324,1,1,1,28), -- Sealed Phoenix Earring
(20773,6325,1,1,1,41), -- Sealed Phoenix Ring
(20773,6341,1,1,1,4930), -- Sealed Phoenix Earring Gemstone
(20773,6343,1,1,1,3811), -- Sealed Phoenix Necklace Beads
(20773,6345,1,1,1,6818), -- Sealed Phoenix Ring Gemstone
(20773,730,1,1,2,128), -- Scroll: Enchant Armor (Grade A)
(20773,1868,1,1,2,305516), -- Thread
(20773,1873,1,1,2,61103), -- Silver Nugget
(20773,1889,1,1,2,10184), -- Compound Braid
(20773,4044,1,1,2,5092), -- Thons
(20773,4157,1,1,2,760), -- Recipe: Blue Wolf Gaiters
(20773,5549,1,1,2,15276), -- Metallic Thread
(20774,1807,1,1,-1,5079), -- Recipe: Soulshot: A-Grade
(20774,1889,1,1,-1,253956), -- Compound Braid
(20774,5478,1,1,-1,32033), -- Sealed Dark Crystal Leather Armor Pattern
(20774,57,1536,3126,0,700000), -- Adena
(20774,5290,1,1,1,25), -- Sealed Dark Crystal Gloves
(20774,5291,1,1,1,25), -- Sealed Dark Crystal Boots
(20774,5295,1,1,1,25), -- Sealed Tallum Gloves
(20774,5296,1,1,1,25), -- Sealed Tallum Boots
(20774,5496,1,1,1,3298), -- Sealed Dark Crystal Boots Lining
(20774,5497,1,1,1,3298), -- Sealed Tallum Boots Lining
(20774,5508,1,1,1,3298), -- Sealed Dark Crystal Gloves Design
(20774,5509,1,1,1,3298), -- Sealed Tallum Gloves Design
(20774,1868,1,3,2,187537), -- Thread
(20774,1873,1,1,2,75015), -- Silver Nugget
(20774,1876,1,1,2,37508), -- Mithril Ore
(20774,1895,1,1,2,53582), -- Metallic Fiber
(20774,4042,1,1,2,3126), -- Enria
(20774,5271,1,1,2,250), -- Recipe: Greater Soulshot (A) Compressed Package(100%)
(20775,1800,1,1,-1,76617), -- Recipe: Piece Bone Breastplate
(20775,1897,1,1,-1,58010), -- Necklace of Wisdom Chain
(20775,2253,1,1,-1,9985), -- Recipe: Sword Breaker
(20775,57,119,191,0,700000), -- Adena
(20775,15,1,1,1,106), -- Short Spear
(20775,2011,1,1,1,1643), -- Short Spear Edge
(20775,1868,1,1,2,95958), -- Thread
(20775,1873,1,1,2,19192), -- Silver Nugget
(20775,2144,1,1,2,9596), -- Recipe: Compound Braid
(20776,1865,1,1,-1,297237), -- Varnish
(20776,1866,1,1,-1,198158), -- Suede
(20776,1897,1,1,-1,70771), -- Necklace of Wisdom Chain
(20776,57,137,239,0,700000), -- Adena
(20776,1101,1,1,1,866), -- Tunic of Devotion
(20776,1104,1,1,1,1383), -- Stockings of Devotion
(20776,735,1,1,2,1626), -- Potion of Alacrity
(20776,1831,1,1,2,52030), -- Antidote
(20776,1867,1,1,2,26015), -- Animal Skin
(20776,1869,1,1,2,19511), -- Iron Ore
(20776,1870,1,1,2,19511), -- Coal
(20776,1871,1,1,2,19511), -- Charcoal
(20776,1872,1,1,2,26015), -- Animal Bone
(20776,2140,1,1,2,3903), -- Recipe: High Grade Suede
(20776,5158,1,1,2,781), -- Recipe: Spiritshot (D) Compressed Package (100%)
(20777,1792,1,1,-1,16388), -- Recipe: Short Spear
(20777,1831,1,1,-1,594351), -- Antidote
(20777,1896,1,1,-1,94441), -- Necklace of Anguish Chain
(20777,57,114,168,0,700000), -- Adena
(20777,37,1,1,1,3313), -- Leather Shoes
(20777,49,1,1,1,3313), -- Gloves
(20777,1921,1,1,1,28317), -- Leather Shoes Texture
(20777,1794,1,1,2,3228), -- Recipe: Forest Bow
(20777,1868,1,1,2,87782), -- Thread
(20777,1873,1,1,2,17557), -- Silver Nugget
(20778,1902,1,1,-1,82244), -- Elven Earring Beads
(20778,1903,1,1,-1,135404), -- Elven Ring Piece
(20778,2290,1,1,-1,4510), -- Recipe: Mithril Dagger
(20778,57,343,684,0,700000), -- Adena
(20778,352,1,1,1,47), -- Brigandine Tunic
(20778,1941,1,1,1,2782), -- Brigandine Temper
(20778,2377,1,1,1,75), -- Mithril Scale Gaiters
(20778,2378,1,1,1,75), -- Brigandine Gaiters
(20778,2918,1,1,1,4149), -- Mithril Scale Gaiters Material
(20778,2919,1,1,1,4149), -- Brigandine Gaiters Material
(20778,1866,1,1,2,46624), -- Suede
(20778,1871,1,1,2,69936), -- Charcoal
(20778,1877,1,1,2,2798), -- Adamantite Nugget
(20778,2202,1,1,2,7151), -- Recipe: Assault Boots
(20778,2288,1,1,2,389), -- Recipe: Ghost Staff
(20778,2289,1,1,2,389), -- Recipe: Staff of Life
(20779,1866,1,1,-1,483184), -- Suede
(20779,1904,1,1,-1,67641), -- Elven Necklace Beads
(20779,2158,1,1,-1,89700), -- Recipe: Mithril Ring
(20779,57,307,611,0,700000), -- Adena
(20779,318,1,1,1,27), -- Crucifix of Blood
(20779,2042,1,1,1,1732), -- Crucifix of Blood Piece
(20779,1866,1,1,2,49954), -- Suede
(20779,1871,1,1,2,74931), -- Charcoal
(20779,1877,1,1,2,2998), -- Adamantite Nugget
(20779,2286,1,1,2,417), -- Recipe: Bonebreaker
(20779,2290,1,1,2,417), -- Recipe: Mithril Dagger
(20780,1877,1,1,-1,23762), -- Adamantite Nugget
(20780,1901,1,1,-1,82051), -- Tiger\'s Eye Earring Stone
(20780,2980,1,1,-1,79524), -- Recipe: Brigandine Gauntlets
(20780,57,251,501,0,700000), -- Adena
(20780,157,1,1,1,22), -- Spiked Club
(20780,186,1,1,1,22), -- Staff of Magic
(20780,2027,1,1,1,1380), -- Spiked Club Head
(20780,1866,1,1,2,52642), -- Suede
(20780,1871,1,1,2,78963), -- Charcoal
(20780,1877,1,1,2,3159), -- Adamantite Nugget
(20780,2186,1,1,2,2641), -- Recipe: Brigandine Tunic
(20781,1901,1,1,-1,81246), -- Tiger\'s Eye Earring Stone
(20781,1938,1,1,-1,39544), -- Mithril Banded Mail Material
(20781,2192,1,1,-1,75029), -- Recipe: Kite Shield
(20781,57,248,496,0,700000), -- Adena
(20781,436,1,1,1,206), -- Tunic of Knowledge
(20781,469,1,1,1,329), -- Stockings of Knowledge
(20781,1875,1,1,2,2607), -- Stone of Purity
(20781,1879,1,1,2,6516), -- Cokes
(20781,1885,1,1,2,3258), -- High Grade Suede
(20781,2187,1,1,2,1746), -- Recipe: Manticore Skin Shirt
(20781,2273,1,1,2,280), -- Recipe: Tarbar
(20781,5549,1,1,2,3910), -- Metallic Thread
(20781,5550,1,1,2,522), -- Durable Metal Plate
(20781,6667,1,1,2,24434), -- Deluxe Chest Key - Grade 3
(20782,1800,1,1,-1,78931), -- Recipe: Piece Bone Breastplate
(20782,1801,1,1,-1,126448), -- Recipe: Piece Bone Gaiters
(20782,1924,1,1,-1,80968), -- Leather Helmet Design
(20782,57,122,197,0,700000), -- Adena
(20782,256,1,1,1,218), -- Cestus
(20782,1867,1,1,2,49428), -- Animal Skin
(20782,1872,1,1,2,49428), -- Animal Bone
(20782,2150,1,1,2,17405), -- Recipe: Blue Diamond Necklace
(20782,5268,1,1,2,1483), -- Recipe: Greater Soulshot (D) Compressed Package (100%)
(20783,1900,1,1,-1,29540), -- Enchanted Necklace Chain
(20783,1935,1,1,-1,15084), -- Scale Mail Fragment
(20783,2203,1,1,-1,58822), -- Recipe: Mithril Boots
(20783,57,114,228,0,700000), -- Adena
(20783,316,1,1,1,10), -- Blood of Saints
(20783,317,1,1,1,10), -- Tome of Blood
(20783,2030,1,1,1,560), -- Tome of Blood Page
(20783,1874,1,1,2,1368), -- Oriharukon Ore
(20783,1878,1,1,2,8203), -- Braided Hemp
(20783,1884,1,1,2,12620), -- Cord
(20783,1889,1,1,2,1368), -- Compound Braid
(20783,2153,1,1,2,3190), -- Recipe: Tiger\'s Eye Earring
(20783,2977,1,1,2,2746), -- Recipe: Brigandine Boots
(20783,5220,1,1,2,821), -- Metal Hardener
(20784,2021,1,1,-1,3853), -- Spinebone Sword Blade
(20784,2153,1,1,-1,47454), -- Recipe: Tiger\'s Eye Earring
(20784,2184,1,1,-1,32051), -- Recipe: Mithril Banded Gaiters
(20784,57,129,258,0,700000), -- Adena
(20784,83,1,1,1,8), -- Sword of Magic
(20784,124,1,1,1,6), -- Two-Handed Sword
(20784,127,1,1,1,6), -- Crimson Sword
(20784,130,1,1,1,6), -- Elven Sword
(20784,144,1,1,1,8), -- Sword of Occult
(20784,2026,1,1,1,326), -- Two-Handed Sword Edge
(20784,1875,1,1,2,1803), -- Stone of Purity
(20784,1879,1,1,2,4507), -- Cokes
(20784,1885,1,1,2,2254), -- High Grade Suede
(20784,2250,1,1,2,6760), -- Recipe: Bone Arrow
(20784,5549,1,1,2,2704), -- Metallic Thread
(20784,5550,1,1,2,361), -- Durable Metal Plate
(20785,1875,1,1,-1,19616), -- Stone of Purity
(20785,1933,1,1,-1,34617), -- Dark Stocking Fabric
(20785,2022,1,1,-1,4583), -- Mace of Judgment Head
(20785,57,124,248,0,700000), -- Adena
(20785,606,1,1,1,26), -- Rip Gauntlets
(20785,1124,1,1,1,26), -- Boots of Power
(20785,1946,1,1,1,1285), -- Rip Gauntlets Pattern
(20785,1948,1,1,1,1285), -- Boots of Power Pattern
(20785,2424,1,1,1,26), -- Manticore Skin Boots
(20785,2425,1,1,1,26), -- Brigandine Boots
(20785,2426,1,1,1,26), -- Elven Mithril Boots
(20785,2448,1,1,1,26), -- Manticore Skin Gloves
(20785,2449,1,1,1,26), -- Brigandine Gauntlets
(20785,2450,1,1,1,26), -- Elven Mithril Gloves
(20785,2923,1,1,1,1285), -- Manticore Skin Boot Lining
(20785,2924,1,1,1,1285), -- Brigandine Boots Design
(20785,2925,1,1,1,1285), -- Elven Mithril Boots Design
(20785,2926,1,1,1,1285), -- Manticore Skin Gloves Lining
(20785,2927,1,1,1,1285), -- Brigandine Gauntlets Pattern
(20785,2928,1,1,1,1285), -- Elven Mithril Gloves Design
(20785,1341,10,30,2,56334), -- Bone Arrow
(20785,1875,1,1,2,1127), -- Stone of Purity
(20785,1879,1,1,2,2817), -- Cokes
(20785,1885,1,1,2,1409), -- High Grade Suede
(20785,2185,1,1,2,3327), -- Recipe: Iron Boots
(20785,2982,1,1,2,2156), -- Recipe: Brigandine Shield
(20785,5549,1,1,2,1691), -- Metallic Thread
(20785,5550,1,1,2,226), -- Durable Metal Plate
(20785,6667,1,1,2,10563), -- Deluxe Chest Key - Grade 3
(20786,2026,1,1,-1,3925), -- Two-Handed Sword Edge
(20786,2155,1,1,-1,52351), -- Recipe: Elven Ring
(20786,5550,1,1,-1,4349), -- Durable Metal Plate
(20786,57,138,275,0,700000), -- Adena
(20786,395,1,1,1,38), -- Manticore Skin Shirt
(20786,417,1,1,1,61), -- Manticore Skin Gaiters
(20786,1942,1,1,1,2150), -- Manticore Skin Shirt Texture
(20786,1943,1,1,1,3348), -- Manticore Skin Gaiters Pattern
(20786,1875,1,1,2,1405), -- Stone of Purity
(20786,1879,1,1,2,3513), -- Cokes
(20786,1885,1,1,2,1757), -- High Grade Suede
(20786,2278,1,1,2,151), -- Recipe: Strengthened Long Bow
(20786,2286,1,1,2,118), -- Recipe: Bonebreaker
(20786,2977,1,1,2,2822), -- Recipe: Brigandine Boots
(20786,5549,1,1,2,2108), -- Metallic Thread
(20786,5550,1,1,2,281), -- Durable Metal Plate
(20787,1870,1,1,-1,395470), -- Coal
(20787,2029,1,1,-1,4717), -- Gastraphetes Shaft
(20787,5549,1,1,-1,39547), -- Metallic Thread
(20787,57,166,331,0,700000), -- Adena
(20787,850,1,1,1,73), -- Elven Earring
(20787,881,1,1,1,110), -- Elven Ring
(20787,913,1,1,1,55), -- Elven Necklace
(20787,1902,1,1,1,3453), -- Elven Earring Beads
(20787,1903,1,1,1,5684), -- Elven Ring Piece
(20787,1904,1,1,1,3181), -- Elven Necklace Beads
(20787,1341,10,30,2,75717), -- Bone Arrow
(20787,1832,1,1,2,25239), -- Greater Antidote
(20787,1875,1,1,2,1515), -- Stone of Purity
(20787,1879,1,1,2,3786), -- Cokes
(20787,1885,1,1,2,1893), -- High Grade Suede
(20787,2188,1,1,2,1623), -- Recipe: Manticore Skin Gaiters
(20787,5473,1,1,2,1623), -- Recipe: Durable Metal Plate(100%)
(20787,5549,1,1,2,2272), -- Metallic Thread
(20787,5550,1,1,2,303), -- Durable Metal Plate
(20788,1901,1,1,-1,96683), -- Tiger\'s Eye Earring Stone
(20788,2186,1,1,-1,23411), -- Recipe: Brigandine Tunic
(20788,57,296,590,0,700000), -- Adena
(20788,260,1,1,1,77), -- Triple-Edged Jamadhr
(20788,1874,1,1,2,3102), -- Oriharukon Ore
(20788,1878,1,1,2,18609), -- Braided Hemp
(20788,1884,1,1,2,28629), -- Cord
(20788,1889,1,1,2,3102), -- Compound Braid
(20788,2189,1,1,2,2077), -- Recipe: Mithril Tunic
(20788,2275,1,1,2,333), -- Recipe: Heavy Bone Club
(20788,2293,1,1,2,259), -- Recipe: Glaive
(20788,5220,1,1,2,1861), -- Metal Hardener
(20789,2030,1,1,-1,7705), -- Tome of Blood Page
(20789,2154,1,1,-1,70536), -- Recipe: Elven Earring
(20789,2188,1,1,-1,47058), -- Recipe: Manticore Skin Gaiters
(20789,57,278,557,0,700000), -- Adena
(20789,393,1,1,1,77), -- Mithril Banded Mail
(20789,394,1,1,1,77), -- Reinforced Leather Shirt
(20789,415,1,1,1,123), -- Mithril Banded Gaiters
(20789,416,1,1,1,123), -- Reinforced Leather Gaiters
(20789,1938,1,1,1,3925), -- Mithril Banded Mail Material
(20789,1939,1,1,1,5129), -- Mithril Banded Gaiters Material
(20789,1341,10,30,2,145950), -- Bone Arrow
(20789,1661,1,1,2,8758), -- Thief Key
(20789,1874,1,1,2,2920), -- Oriharukon Ore
(20789,1878,1,1,2,17514), -- Braided Hemp
(20789,1884,1,1,2,26945), -- Cord
(20789,1889,1,1,2,2920), -- Compound Braid
(20789,2275,1,1,2,313), -- Recipe: Heavy Bone Club
(20789,5220,1,1,2,1752), -- Metal Hardener
(20790,1868,1,3,-1,843210), -- Thread
(20790,1902,1,1,-1,85432), -- Elven Earring Beads
(20790,2039,1,1,-1,8536), -- Bich\'Hwa Edge
(20790,57,356,711,0,700000), -- Adena
(20790,224,1,1,1,16), -- Maingauche
(20790,1660,1,1,1,16), -- Cursed Maingauche
(20790,2038,1,1,1,1152), -- Maingauche Edge
(20790,2044,1,1,1,1152), -- Cursed Maingauche Edge
(20790,1341,10,30,2,145287), -- Bone Arrow
(20790,1874,1,1,2,2906), -- Oriharukon Ore
(20790,1878,1,1,2,17435), -- Braided Hemp
(20790,1884,1,1,2,26823), -- Cord
(20790,1889,1,1,2,2906), -- Compound Braid
(20790,2147,1,1,2,3114), -- Recipe: Blacksmith\'s frame
(20790,2289,1,1,2,243), -- Recipe: Staff of Life
(20790,2984,1,1,2,4457), -- Recipe: Salamander Skin Boots
(20790,5220,1,1,2,1744), -- Metal Hardener
(20790,6667,1,1,2,27242), -- Deluxe Chest Key - Grade 3
(20791,1825,1,1,-1,103491), -- Recipe: Oriharukon
(20791,2041,1,1,-1,16162), -- War Pick Head
(20791,2196,1,1,-1,59380), -- Recipe: Plate Gaiters
(20791,57,613,1223,0,700000), -- Adena
(20791,352,1,1,1,84), -- Brigandine Tunic
(20791,1941,1,1,1,4964), -- Brigandine Temper
(20791,2377,1,1,1,134), -- Mithril Scale Gaiters
(20791,2378,1,1,1,134), -- Brigandine Gaiters
(20791,2918,1,1,1,7405), -- Mithril Scale Gaiters Material
(20791,2919,1,1,1,7405), -- Brigandine Gaiters Material
(20791,1876,1,1,2,21399), -- Mithril Ore
(20791,1877,1,1,2,4280), -- Adamantite Nugget
(20791,1880,1,1,2,10700), -- Steel
(20791,1881,1,1,2,14266), -- Coarse Bone Powder
(20791,1882,1,1,2,23777), -- Leather
(20791,2198,1,1,2,2244), -- Recipe: Sage\'s Rag
(20791,3020,1,1,2,595), -- Recipe: Elven Long Sword
(20792,1903,1,1,-1,224868), -- Elven Ring Piece
(20792,2035,1,1,-1,13647), -- Tarbar Head
(20792,2202,1,1,-1,137841), -- Recipe: Assault Boots
(20792,57,570,1136,0,700000), -- Adena
(20792,88,1,1,1,10), -- Morning Star
(20792,90,1,1,1,10), -- Goat Head Staff
(20792,158,1,1,1,10), -- Tarbar
(20792,169,1,1,1,10), -- Skull Breaker
(20792,172,1,1,1,10), -- Heavy Bone Club
(20792,2031,1,1,1,706), -- Morning Star Head
(20792,2032,1,1,1,644), -- Goat Head Staff Head
(20792,2035,1,1,1,706), -- Tarbar Head
(20792,2036,1,1,1,706), -- Skull Breaker Head
(20792,2037,1,1,1,706), -- Heavy Bone Club Head
(20792,7641,1,1,2,21777), -- Spellbook - Summon Queen of Cat
(20792,7642,1,1,2,21777), -- Spellbook - Summon Unicorn Seraphim
(20792,10030,1,1,2,10309), -- Battle Manual: Dark Smash
(20792,10042,1,1,2,10526), -- Battle Manual: Triple Thrust
(20793,1877,1,1,-1,58846), -- Adamantite Nugget
(20793,1881,1,1,-1,196153), -- Coarse Bone Powder
(20793,2037,1,1,-1,14892), -- Heavy Bone Club Head
(20793,57,617,1231,0,700000), -- Adena
(20793,93,1,1,1,28), -- Winged Spear
(20793,294,1,1,1,28), -- War Pick
(20793,2033,1,1,1,2121), -- Winged Spear Blade
(20793,2041,1,1,1,2121), -- War Pick Head
(20793,1341,10,30,2,316864), -- Bone Arrow
(20793,1876,1,1,2,19012), -- Mithril Ore
(20793,1877,1,1,2,3803), -- Adamantite Nugget
(20793,1880,1,1,2,9507), -- Steel
(20793,1881,1,1,2,12675), -- Coarse Bone Powder
(20793,1882,1,1,2,21125), -- Leather
(20793,2147,1,1,2,6791), -- Recipe: Blacksmith\'s frame
(20793,2205,1,1,2,3009), -- Recipe: Chain Gaiters
(20794,1866,1,1,-1,915655), -- Suede
(20794,1952,1,1,-1,43994), -- Salamander Skin Mail Texture
(20794,2991,1,1,-1,109007), -- Recipe: Karmian Boots
(20794,57,565,1130,0,700000), -- Adena
(20794,225,1,1,1,39), -- Mithril Dagger
(20794,2052,1,1,1,2991), -- Mithril Dagger Blade
(20794,1866,1,1,2,65686), -- Suede
(20794,1871,1,1,2,98529), -- Charcoal
(20794,1885,1,1,2,8211), -- High Grade Suede
(20794,2206,1,1,2,2600), -- Recipe: Mithril Shirt
(20794,4556,1,1,2,395), -- Greater Dye of Constitution <Con+1 Dex-1>
(20794,5220,1,1,2,3942), -- Metal Hardener
(20794,5274,1,1,2,329), -- Recipe: Greater Spiritshot (C) Compressed Package(100%)
(20795,2047,1,1,-1,11397), -- Claymore Blade
(20795,2161,1,1,-1,125863), -- Recipe: Aquastone Ring
(20795,4469,1,1,-1,7408), -- Dye of Strength <Str+1 Con-1>
(20795,57,530,1071,0,700000), -- Adena
(20795,851,1,1,1,180), -- Omen Beast\'s Eye Earring
(20795,882,1,1,1,269), -- Mithril Ring
(20795,914,1,1,1,134), -- Necklace of Darkness
(20795,1905,1,1,1,10554), -- Omen Beast\'s Eye Earring Gemstone
(20795,1906,1,1,1,14914), -- Mithril Ring Wire
(20795,1907,1,1,1,7548), -- Necklace of Darkness Gem
(20795,736,1,1,2,46500), -- Scroll of Escape
(20795,1867,1,1,2,123998), -- Animal Skin
(20795,1872,1,1,2,123998), -- Animal Bone
(20795,1882,1,1,2,20667), -- Leather
(20795,1894,1,1,2,3264), -- Crafted Leather
(20795,2303,1,1,2,406), -- Recipe: Skull Graver
(20795,2304,1,1,2,407), -- Recipe: Heavy Doom Hammer
(20796,1905,1,1,-1,134890), -- Omen Beast\'s Eye Earring Gemstone
(20796,2199,1,1,-1,58509), -- Recipe: Karmian Stockings
(20796,2930,1,1,-1,111783), -- Plate Helmet Design
(20796,57,560,1136,0,700000), -- Adena
(20796,396,1,1,1,163), -- Salamander Skin Mail
(20796,1952,1,1,1,11152), -- Salamander Skin Mail Texture
(20796,737,1,1,2,6964), -- Scroll of Resurrection
(20796,1868,1,1,2,139265), -- Thread
(20796,1873,1,1,2,27853), -- Silver Nugget
(20796,1889,1,1,2,4643), -- Compound Braid
(20796,2998,1,1,2,5236), -- Recipe: Chain Shield
(20796,3033,1,1,2,233), -- Recipe: Spiritshot C
(20796,3954,1,1,2,233), -- Recipe: Blessed Spiritshot C
(20796,4557,1,1,2,279), -- Greater Dye of Dexterity <Dex+1 Str-1>
(20796,5549,1,1,2,6964), -- Metallic Thread
(20796,6668,1,1,2,24869), -- Deluxe Chest Key - Grade 4
(20797,1908,1,1,-1,199462), -- Moonstone Earring Wire
(20797,2163,1,1,-1,107465), -- Recipe: Earring of Protection
(20797,4440,1,1,-1,7339), -- Recipe: Knuckle Duster
(20797,57,846,1733,0,700000), -- Adena
(20797,397,1,1,1,132), -- Mithril Shirt
(20797,1961,1,1,1,7965), -- Mithril Shirt Fabric
(20797,2387,1,1,1,211), -- Tempered Mithril Gaiters
(20797,2935,1,1,1,13232), -- Tempered Mithril Gaiters Fragment
(20797,1864,1,1,2,284423), -- Stem
(20797,1869,1,1,2,142212), -- Iron Ore
(20797,1880,1,1,2,14222), -- Steel
(20797,2220,1,1,2,2945), -- Recipe: Rind Leather Armor
(20797,2225,1,1,2,3092), -- Recipe: Demon\'s Stockings
(20797,2321,1,1,2,497), -- Recipe: Stiletto
(20797,5550,1,1,2,1896), -- Durable Metal Plate
(20798,1908,1,1,-1,161471), -- Moonstone Earring Wire
(20798,4042,1,1,-1,28419), -- Enria
(20798,4043,1,1,-1,56838), -- Asofe
(20798,57,688,1398,0,700000), -- Adena
(20798,71,1,1,1,18), -- Flamberge
(20798,72,1,1,1,18), -- Stormbringer
(20798,2059,1,1,1,1497), -- Flamberge Blade
(20798,2060,1,1,1,1600), -- Stormbringer Blade
(20798,4913,1,1,2,13955), -- Spellbook: Word of Fear
(20798,4914,1,1,2,13955), -- Spellbook: Serenade of Eva
(20798,4926,1,1,2,13955), -- Amulet: Soul Guard
(20798,10183,1,1,2,8130), -- Battle Manual: Create Special Bolt
(20798,10095,1,1,2,8547), -- Battle Manual: Storm Assault
(20799,2065,1,1,-1,13270), -- Skull Graver Head
(20799,2164,1,1,-1,132064), -- Recipe: Ring of Protection
(20799,2317,1,1,-1,5982), -- Recipe: Bec de Corbin
(20799,57,690,1411,0,700000), -- Adena
(20799,354,1,1,1,81), -- Chain Mail Shirt
(20799,381,1,1,1,129), -- Chain Gaiters
(20799,1959,1,1,1,5465), -- Chain Mail Shirt Material
(20799,1960,1,1,1,11116), -- Chain Gaiters Part
(20799,1866,1,1,2,77277), -- Suede
(20799,1871,1,1,2,115916), -- Charcoal
(20799,1877,1,1,2,4637), -- Adamantite Nugget
(20799,2230,1,1,2,2247), -- Recipe: Theca Leather Gaiters
(20799,2326,1,1,2,404), -- Recipe: Horn of Glory
(20799,4040,1,1,2,2319), -- Mold Lubricant
(20799,4041,1,1,2,1009), -- Mold Hardener
(20800,1911,1,1,-1,119596), -- Earring of Protection Gemstone
(20800,1966,1,1,-1,58706), -- Plated Leather Fragment
(20800,2223,1,1,-1,62324), -- Recipe: Tower Shield
(20800,57,647,1321,0,700000), -- Adena
(20800,355,1,1,1,56), -- Dwarven Chain Mail Shirt
(20800,382,1,1,1,89), -- Dwarven Chain Gaiters
(20800,1968,1,1,1,4292), -- Dwarven Chain Mail Shirt Material
(20800,1969,1,1,1,6808), -- Dwarven Chain Gaiters Material
(20800,1867,1,1,2,135706), -- Animal Skin
(20800,1872,1,1,2,135706), -- Animal Bone
(20800,1875,1,1,2,6786), -- Stone of Purity
(20800,1881,1,1,2,13571), -- Coarse Bone Powder
(20800,2226,1,1,2,4155), -- Recipe: Mithril Gauntlets
(20800,2333,1,1,2,237), -- Recipe: Sword of Nightmare
(20800,4041,1,1,2,885), -- Mold Hardener
(20801,951,1,1,-1,3528), -- Scroll: Enchant Weapon (Grade C)
(20801,2330,1,1,-1,4513), -- Recipe: Homunkulus\'s Sword
(20801,2946,1,1,-1,108463), -- Plate Leather Gloves Design
(20801,57,783,1591,0,700000), -- Adena
(20801,4233,1,1,1,30), -- Knuckle Duster
(20801,1539,1,1,2,19106), -- Greater Healing Potion
(20801,1868,1,1,2,171950), -- Thread
(20801,1873,1,1,2,34391), -- Silver Nugget
(20801,1876,1,1,2,17196), -- Mithril Ore
(20801,1895,1,1,2,24565), -- Metallic Fiber
(20801,2347,1,1,2,200), -- Recipe: Akat Long Bow
(20801,2351,1,1,2,180), -- Recipe: Scorpion
(20801,3010,1,1,2,2337), -- Recipe: Composite Helmet
(20801,4042,1,1,2,1433), -- Enria
(20801,4438,1,1,2,3067), -- Knuckle Duster Edge
(20801,6668,1,1,2,30706), -- Deluxe Chest Key - Grade 4
(20802,1975,1,1,-1,60146), -- Rind Leather Armor Design
(20802,2333,1,1,-1,4258), -- Recipe: Sword of Nightmare
(20802,4039,1,1,-1,61038), -- Mold Glue
(20802,57,737,1504,0,700000), -- Adena
(20802,325,1,1,1,29), -- Horn of Glory
(20802,2088,1,1,1,2859), -- Horn of Glory Fragment
(20802,737,1,1,2,11591), -- Scroll of Resurrection
(20802,1342,10,30,2,231811), -- Fine Steel Arrow
(20802,1894,1,1,2,4067), -- Crafted Leather
(20802,2334,1,1,2,270), -- Recipe: Sword of Whispering Death
(20802,4039,1,1,2,3864), -- Mold Glue
(20802,4041,1,1,2,1008), -- Mold Hardener
(20802,4044,1,1,2,3864), -- Thons
(20803,4042,1,1,-1,57307), -- Enria
(20803,4043,1,1,-1,114615), -- Asofe
(20803,4044,1,1,-1,114615), -- Thons
(20803,57,1387,2820,0,700000), -- Adena
(20803,231,1,1,1,17), -- Grace Dagger
(20803,233,1,1,1,17), -- Dark Screamer
(20803,2106,1,1,1,1938), -- Grace Dagger Edge
(20803,2107,1,1,1,1938), -- Dark Screamer Edge
(20803,1895,1,1,2,58038), -- Metallic Fiber
(20803,2356,1,1,2,332), -- Recipe: Demon\'s Staff
(20803,2360,1,1,2,332), -- Recipe: Orcish Poleaxe
(20803,3014,1,1,2,5675), -- Recipe: Full Plate Boots
(20803,4040,1,1,2,4063), -- Mold Lubricant
(20803,4042,1,1,2,3386), -- Enria
(20803,4043,1,1,2,6772), -- Asofe
(20804,1953,1,1,-1,53848), -- Sage\'s Rag Lining
(20804,2160,1,1,-1,108461), -- Recipe: Moonstone Earring
(20804,4470,1,1,-1,9607), -- Dye of Strength <Str+1 Dex-1>
(20804,57,692,1383,0,700000), -- Adena
(20804,630,1,1,1,274), -- Square Shield
(20804,1956,1,1,1,15971), -- Square Shield Fragment
(20804,2412,1,1,1,192), -- Plate Helmet
(20804,2494,1,1,1,274), -- Plate Shield
(20804,2930,1,1,1,11343), -- Plate Helmet Design
(20804,2934,1,1,1,15971), -- Plate Shield Fragment
(20804,735,1,1,2,8794), -- Potion of Alacrity
(20804,1864,1,1,2,211049), -- Stem
(20804,1869,1,1,2,105525), -- Iron Ore
(20804,1878,1,1,2,42210), -- Braided Hemp
(20804,1884,1,1,2,64938), -- Cord
(20804,2207,1,1,2,2785), -- Recipe: Karmian Tunic
(20804,2298,1,1,2,461), -- Recipe: Stormbringer
(20804,5274,1,1,2,352), -- Recipe: Greater Spiritshot (C) Compressed Package(100%)
(20805,1905,1,1,-1,176987), -- Omen Beast\'s Eye Earring Gemstone
(20805,2053,1,1,-1,15044), -- Scallop Jamadhr Edge
(20805,2162,1,1,-1,87895), -- Recipe: Aquastone Necklace
(20805,57,744,1503,0,700000), -- Adena
(20805,159,1,1,1,11), -- Bonebreaker
(20805,187,1,1,1,11), -- Atuba Hammer
(20805,188,1,1,1,11), -- Ghost Staff
(20805,189,1,1,1,11), -- Staff of Life
(20805,190,1,1,1,11), -- Atuba Mace
(20805,2048,1,1,1,756), -- Bonebreaker Head
(20805,2049,1,1,1,756), -- Atuba Hammer Head
(20805,2050,1,1,1,801), -- Ghost Staff Head
(20805,2051,1,1,1,801), -- Staff of Life Shaft
(20805,2058,1,1,1,756), -- Atuba Mace Head
(20805,1895,1,1,2,52208), -- Metallic Fiber
(20805,2205,1,1,2,5783), -- Recipe: Chain Gaiters
(20805,2305,1,1,2,798), -- Recipe: Crystal Staff
(20805,5164,1,1,2,610), -- Recipe: Blessed Spiritshot (C) Compressed Package (100%)
(20805,6668,1,1,2,65260), -- Deluxe Chest Key - Grade 4
(20806,1805,1,1,-1,5824), -- Recipe: Soulshot: C-Grade
(20806,2204,1,1,-1,34598), -- Recipe: Chain Mail Shirt
(20806,2934,1,1,-1,198321), -- Plate Shield Fragment
(20806,57,705,1432,0,700000), -- Adena
(20806,70,1,1,1,25), -- Claymore
(20806,2047,1,1,1,1929), -- Claymore Blade
(20806,2499,1,1,1,25), -- Elven Long Sword
(20806,2967,1,1,1,1903), -- Elven Long Sword Blade
(20806,1865,1,1,2,125338), -- Varnish
(20806,1870,1,1,2,125338), -- Coal
(20806,1875,1,1,2,8356), -- Stone of Purity
(20806,1879,1,1,2,20890), -- Cokes
(20806,2300,1,1,2,548), -- Recipe: Scythe
(20806,2999,1,1,2,8412), -- Recipe: Plated Leather Gloves
(20806,5159,1,1,2,418); -- Recipe: Spiritshot (C) Compressed Package (100%)

INSERT INTO `droplist` VALUES 
(20807,1908,1,1,-1,173910), -- Moonstone Earring Wire
(20807,1910,1,1,-1,138290), -- Aquastone Necklace Chain
(20807,2164,1,1,-1,141269), -- Recipe: Ring of Protection
(20807,57,737,1511,0,700000), -- Adena
(20807,439,1,1,1,115), -- Karmian Tunic
(20807,471,1,1,1,184), -- Karmian Stockings
(20807,1954,1,1,1,11537), -- Karmian Stocking Design
(20807,1962,1,1,1,6944), -- Karmian Tunic Pattern
(20807,737,1,1,2,9644), -- Scroll of Resurrection
(20807,1866,1,1,2,64294), -- Suede
(20807,1871,1,1,2,96440), -- Charcoal
(20807,1885,1,1,2,8037), -- High Grade Suede
(20807,2221,1,1,2,3194), -- Recipe: Rind Leather Gaiters
(20807,2225,1,1,2,2097), -- Recipe: Demon\'s Stockings
(20807,2316,1,1,2,337), -- Recipe: Katana
(20807,2321,1,1,2,336), -- Recipe: Stiletto
(20807,5220,1,1,2,3858), -- Metal Hardener
(20808,1908,1,1,-1,215579), -- Moonstone Earring Wire
(20808,1954,1,1,-1,121027), -- Karmian Stocking Design
(20808,2163,1,1,-1,116149), -- Recipe: Earring of Protection
(20808,57,919,1866,0,700000), -- Adena
(20808,439,1,1,1,142), -- Karmian Tunic
(20808,471,1,1,1,227), -- Karmian Stockings
(20808,1954,1,1,1,14301), -- Karmian Stocking Design
(20808,1962,1,1,1,8608), -- Karmian Tunic Pattern
(20808,1894,1,1,2,6292), -- Crafted Leather
(20808,2324,1,1,2,625), -- Recipe: Elven Bow of Nobility
(20808,4039,1,1,2,5978), -- Mold Glue
(20808,4041,1,1,2,1560), -- Mold Hardener
(20808,4044,1,1,2,5978), -- Thons
(20808,6668,1,1,2,64043), -- Deluxe Chest Key - Grade 4
(20809,4049,1,1,-1,211817), -- Adamantite Earring Gemstone
(20809,4439,1,1,-1,278503), -- Avadon Shield Fragment
(20809,4973,1,1,-1,43704), -- Recipe: Earring of Black Ore (70%)
(20809,57,1629,3312,0,700000), -- Adena
(20809,357,1,1,1,15), -- Zubei\'s Breastplate
(20809,383,1,1,1,23), -- Zubei\'s Gaiters
(20809,2376,1,1,1,15), -- Avadon Breastplate
(20809,2379,1,1,1,23), -- Avadon Gaiters
(20809,4056,1,1,1,2699), -- Zubei\'s Breastplate Part
(20809,4057,1,1,1,4171), -- Zubei\'s Gaiter Material
(20809,4064,1,1,1,2699), -- Avadon Breastplate Part
(20809,4065,1,1,1,4171), -- Avadon Gaiters Material
(20809,1868,1,1,2,298213), -- Thread
(20809,1873,1,1,2,59643), -- Silver Nugget
(20809,1889,1,1,2,9941), -- Compound Braid
(20809,4044,1,1,2,4971), -- Thons
(20809,4158,1,1,2,317), -- Recipe: Doom Plate Armor
(20809,4981,1,1,2,464), -- Recipe: Blue Wolf Breastplate (60%)
(20809,4999,1,1,2,1855), -- Recipe: Doom Boots (60%)
(20809,5549,1,1,2,14911), -- Metallic Thread
(20810,947,1,1,-1,1615), -- Scroll: Enchant Weapon (Grade B)
(20810,4109,1,1,-1,22751), -- Kris Edge
(20810,4974,1,1,-1,65557), -- Recipe: Ring of Black Ore (70%)
(20810,57,1629,3312,0,700000), -- Adena
(20810,91,1,1,1,7), -- Heavy War Axe
(20810,92,1,1,1,7), -- Sprite\'s Staff
(20810,4105,1,1,1,1707), -- Heavy War Axe Head
(20810,4106,1,1,1,1679), -- Sprite\'s Staff Head
(20810,1874,1,1,2,11361), -- Oriharukon Ore
(20810,1878,1,1,2,68163), -- Braided Hemp
(20810,1884,1,1,2,104866), -- Cord
(20810,1889,1,1,2,11361), -- Compound Braid
(20810,4159,1,1,2,483), -- Recipe: Blue Wolf Leather Armor
(20810,5220,1,1,2,6817), -- Metal Hardener
(20811,947,1,1,-1,1909), -- Scroll: Enchant Weapon (Grade B)
(20811,1875,1,1,-1,318218), -- Stone of Purity
(20811,4040,1,1,-1,95465), -- Mold Lubricant
(20811,57,1929,3913,0,700000), -- Adena
(20811,78,1,1,1,6), -- Great Sword
(20811,142,1,1,1,6), -- Keshanberk
(20811,148,1,1,1,6), -- Sword of Valhalla
(20811,4104,1,1,1,1345), -- Great Sword Blade
(20811,4107,1,1,1,1324), -- Keshanberk Blade
(20811,4108,1,1,1,1324), -- Sword of Valhalla Blade
(20811,1865,1,1,2,156662), -- Varnish
(20811,1870,1,1,2,156662), -- Coal
(20811,1875,1,1,2,10444), -- Stone of Purity
(20811,1879,1,1,2,26111), -- Cokes
(20811,4040,1,1,2,3134), -- Mold Lubricant
(20811,4167,1,1,2,1949), -- Recipe: Blue Wolf Boots
(20811,4401,1,1,2,314), -- Green Dimensional Stone
(20811,4619,1,1,2,216), -- Greater Dye of Intelligence <Int+4 Men-4>
(20811,6670,1,1,2,26111), -- Deluxe Chest Key - Grade 6
(20812,1875,1,1,-1,314143), -- Stone of Purity
(20812,4613,1,1,-1,6500), -- Greater Dye of Strength <Str+4 Con-4>
(20812,4617,1,1,-1,6500), -- Greater Dye of Dexterity <Dex+4 Str-4>
(20812,57,1904,3863,0,700000), -- Adena
(20812,284,1,1,1,17), -- Dark Elven Long Bow
(20812,4112,1,1,1,3940), -- Dark Elven Longbow Shaft
(20812,1867,1,3,2,103104), -- Animal Skin
(20812,1872,1,3,2,154655), -- Animal Bone
(20812,1875,1,1,2,15466), -- Stone of Purity
(20812,1881,1,1,2,30931), -- Coarse Bone Powder
(20812,4041,1,1,2,2018), -- Mold Hardener
(20812,4620,1,1,2,320), -- Greater Dye of Intelligence <Int+4 Wit-4>
(20813,4052,1,1,-1,151920), -- Earring of Black Ore Piece
(20813,4982,1,1,-1,21348), -- Recipe: Blue Wolf Gaiters (60%)
(20813,5230,1,1,-1,5721), -- Recipe: Mithril Arrow (100%)
(20813,57,1736,3516,0,700000), -- Adena
(20813,2398,1,1,1,14), -- Blue Wolf Tunic
(20813,2399,1,1,1,14), -- Tunic of Doom
(20813,2403,1,1,1,21), -- Blue Wolf Stockings
(20813,2404,1,1,1,21), -- Stockings of Doom
(20813,4084,1,1,1,2753), -- Blue Wolf Tunic Fabric
(20813,4085,1,1,1,2753), -- Tunic of Doom Pattern
(20813,4086,1,1,1,3717), -- Blue Wolf Stockings Pattern
(20813,4087,1,1,1,3717), -- Stockings of Doom Pattern
(20813,8945,1,1,2,6536), -- Spellbook: Celestial Shield
(20813,4927,1,1,2,4184), -- Amulet: Chant of Revenge
(20813,10048,1,1,2,8264), -- Battle Manual: Curse Of Divinity
(20813,10054,1,1,2,6410), -- Battle Manual: Deadly Roulette
(20813,10063,1,1,2,5495), -- Battle Manual: Quiver Of Bolts - Grade A
(20814,948,1,1,-1,12387), -- Scroll: Enchant Armor (Grade B)
(20814,4053,1,1,-1,212371), -- Ring of Black Ore Gemstone
(20814,5230,1,1,-1,6606), -- Recipe: Mithril Arrow (100%)
(20814,57,2004,4060,0,700000), -- Adena
(20814,601,1,1,1,46), -- Boots of Doom
(20814,2439,1,1,1,46), -- Blue Wolf Boots
(20814,2475,1,1,1,46), -- Doom Gloves
(20814,2487,1,1,1,46), -- Blue Wolf Gloves
(20814,4090,1,1,1,8211), -- Blue Wolf Boots Design
(20814,4091,1,1,1,8211), -- Doom Gloves Part
(20814,4096,1,1,1,8211), -- Blue Wolf Gloves Fabric
(20814,4099,1,1,1,8211), -- Doom Boots Part
(20814,1866,1,1,2,139383), -- Suede
(20814,1871,1,1,2,209074), -- Charcoal
(20814,1877,1,1,2,8363), -- Adamantite Nugget
(20814,4040,1,1,2,4182), -- Mold Lubricant
(20814,4041,1,1,2,1819), -- Mold Hardener
(20814,4975,1,1,2,1700), -- Recipe: Necklace of Black Ore (70%)
(20814,5276,1,1,2,279), -- Recipe: Greater Spiritshot (A) Compressed Package(100%)
(20815,4052,1,1,-1,217631), -- Earring of Black Ore Piece
(20815,4054,1,1,-1,121075), -- Necklace of Black Ore Beads
(20815,4984,1,1,-1,17414), -- Recipe: Blue Wolf Leather Armor (60%)
(20815,57,2487,5035,0,700000), -- Adena
(20815,2391,1,1,1,26), -- Blue Wolf Leather Armor
(20815,2392,1,1,1,26), -- Leather Armor of Doom
(20815,4082,1,1,1,5129), -- Blue Wolf Leather Armor Texture
(20815,4083,1,1,1,5129), -- Leather Armor of Doom Design
(20815,1865,1,1,2,259389), -- Varnish
(20815,1870,1,3,2,129695), -- Coal
(20815,1874,1,1,2,17293), -- Oriharukon Ore
(20815,4039,1,1,2,8647), -- Mold Glue
(20815,4043,1,1,2,8647), -- Asofe
(20815,5000,1,1,2,199), -- Recipe: Sword of Damascus (60%)
(20815,6670,1,1,2,43232), -- Deluxe Chest Key - Grade 6
(20816,947,1,1,-1,2051), -- Scroll: Enchant Weapon (Grade B)
(20816,4039,1,1,-1,170952), -- Mold Glue
(20816,5230,1,1,-1,6838), -- Recipe: Mithril Arrow (100%)
(20816,57,2075,4201,0,700000), -- Adena
(20816,2391,1,1,1,22), -- Blue Wolf Leather Armor
(20816,2392,1,1,1,22), -- Leather Armor of Doom
(20816,4082,1,1,1,4279), -- Blue Wolf Leather Armor Texture
(20816,4083,1,1,1,4279), -- Leather Armor of Doom Design
(20816,1864,3,9,2,63121), -- Stem
(20816,1869,1,1,2,189363), -- Iron Ore
(20816,1878,1,1,2,75746), -- Braided Hemp
(20816,1884,1,1,2,116532), -- Cord
(20816,4039,1,1,2,6313), -- Mold Glue
(20816,4402,1,1,2,379), -- Blue Dimensional Stone
(20816,5001,1,1,2,145), -- Recipe: Lance (60%)
(20816,5276,1,1,2,253), -- Recipe: Greater Spiritshot (A) Compressed Package(100%)
(20817,4040,1,1,-1,99540), -- Mold Lubricant
(20817,4053,1,1,-1,213331), -- Ring of Black Ore Gemstone
(20817,5230,1,1,-1,6636), -- Recipe: Mithril Arrow (100%)
(20817,57,2015,4076,0,700000), -- Adena
(20817,268,1,1,1,12), -- Bellion Cestus
(20817,4120,1,1,1,3212), -- Bellion Cestus Edge
(20817,1865,1,1,2,210019), -- Varnish
(20817,1870,1,1,2,210019), -- Coal
(20817,1875,1,1,2,14002), -- Stone of Purity
(20817,1879,1,1,2,35004), -- Cokes
(20817,4040,1,1,2,4201), -- Mold Lubricant
(20817,4174,1,1,2,4047), -- Recipe: Zubei\'s Boots
(20817,4402,1,1,2,420), -- Blue Dimensional Stone
(20818,4077,1,1,-1,223455), -- Doom Shield Fragment
(20818,4105,1,1,-1,28426), -- Heavy War Axe Head
(20818,4620,1,1,-1,6852), -- Greater Dye of Intelligence <Int+4 Wit-4>
(20818,57,2012,4068,0,700000), -- Adena
(20818,287,1,1,1,12), -- Bow of Peril
(20818,4121,1,1,1,3196), -- Bow of Peril Shaft
(20818,1866,1,1,2,122275), -- Suede
(20818,1871,1,1,2,183413), -- Charcoal
(20818,1885,1,1,2,15285), -- High Grade Suede
(20818,4041,1,1,2,1595), -- Mold Hardener
(20818,4401,1,1,2,367), -- Green Dimensional Stone
(20818,4958,1,1,2,3534), -- Recipe: Zubei\'s Boots (60%)
(20818,5220,1,1,2,7337), -- Metal Hardener
(20818,5276,1,1,2,245), -- Recipe: Greater Spiritshot (A) Compressed Package(100%)
(20819,4053,1,1,-1,212010), -- Ring of Black Ore Gemstone
(20819,4078,1,1,-1,72249), -- Blue Wolf Breastplate Part
(20819,5230,1,1,-1,6595), -- Recipe: Mithril Arrow (100%)
(20819,57,1999,4054,0,700000), -- Adena
(20819,171,1,1,1,4), -- Deadman\'s Glory
(20819,175,1,1,1,4), -- Art of Battle Axe
(20819,210,1,1,1,4), -- Staff of Evil Spirits
(20819,4116,1,1,1,1065), -- Deadman\'s Glory Stone
(20819,4117,1,1,1,1065), -- Art of Battle Axe Blade
(20819,4118,1,1,1,1009), -- Evil Spirit Head
(20819,730,1,1,2,152), -- Scroll: Enchant Armor (Grade A)
(20819,1874,1,1,2,12176), -- Oriharukon Ore
(20819,1878,1,1,2,73052), -- Braided Hemp
(20819,1884,1,1,2,112387), -- Cord
(20819,1889,1,1,2,12176), -- Compound Braid
(20819,4159,1,1,2,518), -- Recipe: Blue Wolf Leather Armor
(20819,4402,1,1,2,366), -- Blue Dimensional Stone
(20819,5220,1,1,2,7306), -- Metal Hardener
(20820,4054,1,1,-1,167723), -- Necklace of Black Ore Beads
(20820,4080,1,1,-1,175157), -- Blue Wolf Gaiters Material
(20820,5230,1,1,-1,11354), -- Recipe: Mithril Arrow (100%)
(20820,57,3442,6979,0,700000), -- Adena
(20820,864,1,1,1,91), -- Earring of Black Ore
(20820,895,1,1,1,137), -- Ring of Black Ore
(20820,926,1,1,1,69), -- Necklace of Black Ore
(20820,4052,1,1,1,14841), -- Earring of Black Ore Piece
(20820,4053,1,1,1,17967), -- Ring of Black Ore Gemstone
(20820,4054,1,1,1,8257), -- Necklace of Black Ore Beads
(20820,1867,1,3,2,239551), -- Animal Skin
(20820,1872,1,3,2,159701), -- Animal Bone
(20820,1882,1,1,2,79851), -- Leather
(20820,1894,1,1,2,12609), -- Crafted Leather
(20820,4042,1,1,2,5989), -- Enria
(20820,4160,1,1,2,1018), -- Recipe: Leather Armor of Doom
(20820,5276,1,1,2,479), -- Recipe: Greater Spiritshot (A) Compressed Package(100%)
(20821,1894,1,1,-1,234416), -- Crafted Leather
(20821,4080,1,1,-1,137424), -- Blue Wolf Gaiters Material
(20821,4084,1,1,-1,116108), -- Blue Wolf Tunic Fabric
(20821,57,2700,5475,0,700000), -- Adena
(20821,97,1,1,1,16), -- Lance
(20821,4115,1,1,1,4305), -- Lance Blade
(20821,1867,1,3,2,187945), -- Animal Skin
(20821,1872,1,3,2,125297), -- Animal Bone
(20821,1882,1,1,2,62649), -- Leather
(20821,1894,1,1,2,9892), -- Crafted Leather
(20821,4042,1,1,2,4699), -- Enria
(20821,4195,1,1,2,216), -- Recipe: Art of Battle Axe
(20821,5276,1,1,2,376), -- Recipe: Greater Spiritshot (A) Compressed Package(100%)
(20822,1889,1,1,-1,447541), -- Compound Braid
(20822,1894,1,1,-1,235548), -- Crafted Leather
(20822,4077,1,1,-1,301984), -- Doom Shield Fragment
(20822,57,2713,5501,0,700000), -- Adena
(20822,97,1,1,1,16), -- Lance
(20822,4115,1,1,1,4326), -- Lance Blade
(20822,1868,1,3,2,247869), -- Thread
(20822,1873,1,1,2,99148), -- Silver Nugget
(20822,1889,1,1,2,16525), -- Compound Braid
(20822,4044,1,1,2,8263), -- Thons
(20822,4196,1,1,2,190), -- Recipe: Staff of Evil Spirits
(20822,4402,1,1,2,496), -- Blue Dimensional Stone
(20822,5549,1,1,2,24787), -- Metallic Thread
(20822,6670,1,1,2,41313), -- Deluxe Chest Key - Grade 6
(20823,4043,1,1,-1,247340), -- Asofe
(20823,4088,1,1,-1,280431), -- Blue Wolf Helmet Design
(20823,4089,1,1,-1,280431), -- Doom Helmet Pattern
(20823,57,2984,6097,0,700000), -- Adena
(20823,2398,1,1,1,23), -- Blue Wolf Tunic
(20823,2399,1,1,1,23), -- Tunic of Doom
(20823,2403,1,1,1,37), -- Blue Wolf Stockings
(20823,2404,1,1,1,37), -- Stockings of Doom
(20823,4084,1,1,1,4760), -- Blue Wolf Tunic Fabric
(20823,4085,1,1,1,4760), -- Tunic of Doom Pattern
(20823,4086,1,1,1,6427), -- Blue Wolf Stockings Pattern
(20823,4087,1,1,1,6427), -- Stockings of Doom Pattern
(20823,1864,1,3,2,313116), -- Stem
(20823,1869,1,3,2,104372), -- Iron Ore
(20823,1880,1,1,2,31312), -- Steel
(20823,4043,1,1,2,10438), -- Asofe
(20823,4402,1,1,2,627), -- Blue Dimensional Stone
(20823,4616,1,1,2,432), -- Greater Dye of Constitution <Con+4 Dex-4>
(20823,5550,1,1,2,4175), -- Durable Metal Plate
(20824,4078,1,1,-1,102642), -- Blue Wolf Breastplate Part
(20824,4081,1,1,-1,69258), -- Doom Plate Armor Temper
(20824,57,2826,5774,0,700000), -- Adena
(20824,864,1,1,1,75), -- Earring of Black Ore
(20824,895,1,1,1,113), -- Ring of Black Ore
(20824,926,1,1,1,57), -- Necklace of Black Ore
(20824,4052,1,1,1,12247), -- Earring of Black Ore Piece
(20824,4053,1,1,1,14827), -- Ring of Black Ore Gemstone
(20824,4054,1,1,1,6814), -- Necklace of Black Ore Beads
(20824,1865,1,1,2,259455), -- Varnish
(20824,1870,1,3,2,129728), -- Coal
(20824,1874,1,1,2,17297), -- Oriharukon Ore
(20824,4039,1,1,2,8649), -- Mold Glue
(20824,4043,1,1,2,8649), -- Asofe
(20824,4617,1,1,2,358), -- Greater Dye of Dexterity <Dex+4 Str-4>
(20824,5276,1,1,2,347), -- Recipe: Greater Spiritshot (A) Compressed Package(100%)
(20824,6036,1,1,2,8648), -- Greater Magic Haste Potion
(20825,1807,1,1,-1,9816), -- Recipe: Soulshot: A-Grade
(20825,1876,1,3,-1,736209), -- Mithril Ore
(20825,57,2970,6039,0,700000), -- Adena
(20825,5289,1,1,1,42), -- Sealed Dark Crystal Helmet
(20825,5292,1,1,1,60), -- Sealed Dark Crystal Shield
(20825,5294,1,1,1,42), -- Sealed Tallum Helmet
(20825,5494,1,1,1,7612), -- Sealed Dark Crystal Shield Fragment
(20825,5525,1,1,1,5603), -- Sealed Dark Crystal Helmet Design
(20825,5526,1,1,1,5603), -- Sealed Tallum Helm Design
(20825,1866,1,1,2,207110), -- Suede
(20825,1871,1,3,2,155333), -- Charcoal
(20825,1877,1,1,2,12427), -- Adamantite Nugget
(20825,4040,1,1,2,6214), -- Mold Lubricant
(20825,4041,1,1,2,2702), -- Mold Hardener
(20825,4402,1,1,2,621), -- Blue Dimensional Stone
(20825,4975,1,1,2,2526), -- Recipe: Necklace of Black Ore (70%)
(20826,4041,1,1,-1,58279), -- Mold Hardener
(20826,5478,1,1,-1,56358), -- Sealed Dark Crystal Leather Armor Pattern
(20826,57,2704,5497,0,700000), -- Adena
(20826,5287,1,1,1,15), -- Sealed Dark Crystal breastplate
(20826,5288,1,1,1,23), -- Sealed Dark Crystal Gaiters
(20826,5293,1,1,1,10), -- Sealed Tallum Plate Armor
(20826,5520,1,1,1,2129), -- Sealed Dark Crystal Breastplate Pattern
(20826,5521,1,1,1,1502), -- Sealed Tallum Plate Armor Pattern
(20826,5524,1,1,1,3253), -- Sealed Dark Crystal Gaiters Pattern
(20826,1867,1,3,2,109984), -- Animal Skin
(20826,1872,1,3,2,164976), -- Animal Bone
(20826,1875,1,1,2,16498), -- Stone of Purity
(20826,1881,1,1,2,32996), -- Coarse Bone Powder
(20826,3956,1,1,2,330), -- Recipe: Blessed Spiritshot A
(20826,4041,1,1,2,2152), -- Mold Hardener
(20826,4980,1,1,2,2929), -- Recipe: Doom Shield (60%)
(20826,6670,1,1,2,41245), -- Deluxe Chest Key - Grade 6
(20827,3035,1,1,-1,10888), -- Recipe: Spiritshot A
(20827,4117,1,1,-1,35684), -- Art of Battle Axe Blade
(20827,4118,1,1,-1,33808), -- Evil Spirit Head
(20827,57,3297,6695,0,700000), -- Adena
(20827,5297,1,1,1,24), -- Sealed Dark Crystal Leather Armor
(20827,5298,1,1,1,38), -- Sealed Dark Crystalline Leggings
(20827,5301,1,1,1,16), -- Sealed Tallum Leather Armor
(20827,5478,1,1,1,3381), -- Sealed Dark Crystal Leather Armor Pattern
(20827,5479,1,1,1,2379), -- Sealed Tallum Leather Armor Pattern
(20827,5482,1,1,1,5306), -- Sealed Dark Crystalline Leggings Design
(20827,1868,3,9,2,114863), -- Thread
(20827,1873,1,1,2,137836), -- Silver Nugget
(20827,1876,1,1,2,68918), -- Mithril Ore
(20827,1895,1,1,2,98454), -- Metallic Fiber
(20827,4042,1,1,2,5743), -- Enria
(20827,4402,1,1,2,690), -- Blue Dimensional Stone
(20827,4990,1,1,2,2848), -- Recipe: Blue Wolf Helmet (60%)
(20828,4120,1,1,-1,40698), -- Bellion Cestus Edge
(20828,4121,1,1,-1,40562), -- Bow of Peril Shaft
(20828,5479,1,1,-1,55110), -- Sealed Tallum Leather Armor Pattern
(20828,57,3757,7643,0,700000), -- Adena
(20828,5304,1,1,1,27), -- Sealed Tallum Tunic
(20828,5305,1,1,1,43), -- Sealed Tallum Stockings
(20828,5308,1,1,1,19), -- Sealed Dark Crystal Robe
(20828,5485,1,1,1,3855), -- Sealed Tallum Tunic Texture
(20828,5486,1,1,1,2713), -- Sealed Dark Crystal Robe Fabric
(20828,5489,1,1,1,6051), -- Sealed Tallum Stockings Fabric
(20828,1864,3,9,2,152839), -- Stem
(20828,1869,2,6,2,114629), -- Iron Ore
(20828,1878,3,9,2,30568), -- Braided Hemp
(20828,1884,2,6,2,56433), -- Cord
(20828,4039,1,1,2,15284), -- Mold Glue
(20828,4177,1,1,2,8835), -- Recipe: Zubei\'s Gauntlets
(20829,1894,1,1,-1,438023), -- Crafted Leather
(20829,5479,1,1,-1,73868), -- Sealed Tallum Leather Armor Pattern
(20829,5550,1,1,-1,166449), -- Durable Metal Plate
(20829,57,5027,10247,0,700000), -- Adena
(20829,5287,1,1,1,27), -- Sealed Dark Crystal breastplate
(20829,5288,1,1,1,43), -- Sealed Dark Crystal Gaiters
(20829,5293,1,1,1,19), -- Sealed Tallum Plate Armor
(20829,5520,1,1,1,3964), -- Sealed Dark Crystal Breastplate Pattern
(20829,5521,1,1,1,2797), -- Sealed Tallum Plate Armor Pattern
(20829,5524,1,1,1,6059), -- Sealed Dark Crystal Gaiters Pattern
(20829,1866,1,3,2,117063), -- Suede
(20829,1871,1,3,2,263392), -- Charcoal
(20829,1877,1,1,2,21072), -- Adamantite Nugget
(20829,4040,1,1,2,10536), -- Mold Lubricant
(20829,4041,1,1,2,4581), -- Mold Hardener
(20829,4129,1,1,2,5702), -- Recipe: Earrings of Black Ore
(20829,6671,1,1,2,58532), -- Deluxe Chest Key - Grade 7
(20832,1825,1,1,-1,63369), -- Recipe: Oriharukon
(20832,1902,1,1,-1,89886), -- Elven Earring Beads
(20832,5231,1,1,-1,63369), -- Recipe: Metal Hardener (100%)
(20832,57,358,727,0,700000), -- Adena
(20832,61,1,1,1,76), -- Mithril Gloves
(20832,607,1,1,1,76), -- Ogre Power Gauntlets
(20832,1125,1,1,1,76), -- Assault Boots
(20832,1949,1,1,1,4144), -- Mithril Gloves Design
(20832,1957,1,1,1,4144), -- Assault Boots Part
(20832,1963,1,1,1,4144), -- Ogre Power Gauntlets Part
(20832,2427,1,1,1,76), -- Salamander Skin Boots
(20832,2428,1,1,1,76), -- Plate Boots
(20832,2451,1,1,1,76), -- Sage\'s Worn Gloves
(20832,2931,1,1,1,4144), -- Salamander Skin Boot Lining
(20832,2932,1,1,1,4144), -- Plate Boots Design
(20832,2933,1,1,1,4144), -- Sage\'s Worn Gloves Lining
(20832,1865,1,1,2,63643), -- Varnish
(20832,1870,1,1,2,63643), -- Coal
(20832,1875,1,1,2,4243), -- Stone of Purity
(20832,1879,1,1,2,10608), -- Cokes
(20832,2162,1,1,2,3075), -- Recipe: Aquastone Necklace
(20832,2312,1,1,2,278), -- Recipe: Crystallized Ice Bow
(20832,5159,1,1,2,213), -- Recipe: Spiritshot (C) Compressed Package (100%)
(20833,1874,1,1,-1,65752), -- Oriharukon Ore
(20833,1875,1,1,-1,65752), -- Stone of Purity
(20833,1905,1,1,-1,95942), -- Omen Beast\'s Eye Earring Gemstone
(20833,57,396,811,0,700000), -- Adena
(20833,281,1,1,1,21), -- Crystallized Ice Bow
(20833,2074,1,1,1,1651), -- Crystallized Ice Bow Shaft
(20833,1867,1,1,2,88788), -- Animal Skin
(20833,1872,1,1,2,88788), -- Animal Bone
(20833,1875,1,1,2,4440), -- Stone of Purity
(20833,1881,1,1,2,8879), -- Coarse Bone Powder
(20833,2205,1,1,2,2108), -- Recipe: Chain Gaiters
(20833,2209,1,1,2,5007), -- Recipe: Eldarake
(20833,2299,1,1,2,291), -- Recipe: Big Hammer
(20834,1805,1,1,-1,4893), -- Recipe: Soulshot: C-Grade
(20834,1878,1,1,-1,587109), -- Braided Hemp
(20834,1885,1,1,-1,122314), -- High Grade Suede
(20834,57,600,1212,0,700000), -- Adena
(20834,353,1,1,1,95), -- Half Plate Armor
(20834,380,1,1,1,152), -- Plate Gaiters
(20834,1950,1,1,1,5981), -- Half Plate Temper
(20834,1951,1,1,1,9302), -- Plate Gaiters Part
(20834,1864,1,1,2,184262), -- Stem
(20834,1869,1,1,2,92132), -- Iron Ore
(20834,1878,1,1,2,36853), -- Braided Hemp
(20834,1884,1,1,2,56696), -- Cord
(20834,2306,1,1,2,403), -- Recipe: Stick of Faith
(20834,2996,1,1,2,7312), -- Recipe: Chain Gloves
(20834,5274,1,1,2,307), -- Recipe: Greater Spiritshot (C) Compressed Package(100%)
(20834,6668,1,1,2,32905), -- Deluxe Chest Key - Grade 4
(20835,1871,1,1,-1,808860), -- Charcoal
(20835,1879,1,1,-1,134810), -- Cokes
(20835,1906,1,1,-1,111184), -- Mithril Ring Wire
(20835,57,326,663,0,700000), -- Adena
(20835,439,1,1,1,51), -- Karmian Tunic
(20835,471,1,1,1,81), -- Karmian Stockings
(20835,1954,1,1,1,5081), -- Karmian Stocking Design
(20835,1962,1,1,1,3059), -- Karmian Tunic Pattern
(20835,1865,1,1,2,38229), -- Varnish
(20835,1870,1,1,2,38229), -- Coal
(20835,1875,1,1,2,2549), -- Stone of Purity
(20835,1879,1,1,2,6372), -- Cokes
(20835,2303,1,1,2,167), -- Recipe: Skull Graver
(20835,2990,1,1,2,3034), -- Recipe: Chain Boots
(20835,3000,1,1,2,2451), -- Recipe: Dwarven Chain Shield
(20835,3033,1,1,2,128), -- Recipe: Spiritshot C
(20835,3954,1,1,2,128), -- Recipe: Blessed Spiritshot C
(20835,4040,1,1,2,765), -- Mold Lubricant
(20836,1874,1,1,-1,113820), -- Oriharukon Ore
(20836,1875,1,1,-1,113820), -- Stone of Purity
(20836,57,685,1405,0,700000), -- Adena
(20836,96,1,1,1,12), -- Scythe
(20836,298,1,1,1,12), -- Orcish Glaive
(20836,302,1,1,1,12), -- Body Slasher
(20836,2062,1,1,1,1055), -- Scythe Edge
(20836,2075,1,1,1,1055), -- Orcish Glaive Blade
(20836,2076,1,1,1,1055), -- Body Slasher Blade
(20836,1867,1,1,2,179311), -- Animal Skin
(20836,1872,1,1,2,179311), -- Animal Bone
(20836,1875,1,1,2,8966), -- Stone of Purity
(20836,1881,1,1,2,17932), -- Coarse Bone Powder
(20836,2251,1,1,2,22414), -- Recipe: Steel Arrow
(20836,2319,1,1,2,469), -- Recipe: Raid Sword
(20837,1895,1,1,-1,478498), -- Metallic Fiber
(20837,1960,1,1,-1,91767), -- Chain Gaiters Part
(20837,2214,1,1,-1,41557), -- Recipe: Dwarven Chain Gaiters
(20837,57,676,1373,0,700000), -- Adena
(20837,62,1,1,1,70), -- Mithril Boots
(20837,1958,1,1,1,3953), -- Mithril Boots Design
(20837,2429,1,1,1,70), -- Chain Boots
(20837,2430,1,1,1,70), -- Karmian Boots
(20837,2431,1,1,1,70), -- Plated Leather Boots
(20837,2432,1,1,1,70), -- Dwarven Chain Boots
(20837,2433,1,1,1,70), -- Boots of Seal
(20837,2452,1,1,1,70), -- Reinforced Mithril Gloves
(20837,2453,1,1,1,70), -- Chain Gloves
(20837,2454,1,1,1,70), -- Karmian Gloves
(20837,2937,1,1,1,3953), -- Chain Boots Part
(20837,2938,1,1,1,3953), -- Karmian Boots Fabric
(20837,2939,1,1,1,3953), -- Plate Leather Boot Lining
(20837,2940,1,1,1,3953), -- Dwarven Chain Boots Part
(20837,2941,1,1,1,3953), -- Boots of Seal Pattern
(20837,2942,1,1,1,3953), -- Reinforced Mithril Gloves Design
(20837,2943,1,1,1,3953), -- Chain Gloves Design
(20837,2944,1,1,1,3953), -- Karmian Gloves Fabric
(20837,1868,1,1,2,226147), -- Thread
(20837,1873,1,1,2,45230), -- Silver Nugget
(20837,1876,1,1,2,22615), -- Mithril Ore
(20837,1895,1,1,2,32307), -- Metallic Fiber
(20837,2225,1,1,2,2459), -- Recipe: Demon\'s Stockings
(20837,2321,1,1,2,395), -- Recipe: Stiletto
(20837,4042,1,1,2,1885), -- Enria
(20838,1866,1,3,-1,523274), -- Suede
(20838,1964,1,1,-1,126854), -- Eldarake Temper
(20838,2216,1,1,-1,64869), -- Recipe: Great Helmet
(20838,57,633,1287,0,700000), -- Adena
(20838,852,1,1,1,160), -- Moonstone Earring
(20838,883,1,1,1,241), -- Aquastone Ring
(20838,915,1,1,1,120), -- Aquastone Necklace
(20838,1908,1,1,1,11709), -- Moonstone Earring Wire
(20838,1909,1,1,1,16698), -- Aquastone Ring Wire
(20838,1910,1,1,1,9311), -- Aquastone Necklace Chain
(20838,1866,1,1,2,82436), -- Suede
(20838,1871,1,1,2,123654), -- Charcoal
(20838,1885,1,1,2,10305), -- High Grade Suede
(20838,3004,1,1,2,7681), -- Recipe: Rind Leather Gloves
(20838,4041,1,1,2,1076), -- Mold Hardener
(20838,5220,1,1,2,4947), -- Metal Hardener
(20839,1908,1,1,-1,88935), -- Moonstone Earring Wire
(20839,2066,1,1,-1,7366), -- Heavy Doom Hammer Head
(20839,2320,1,1,-1,3272), -- Recipe: Cursed Staff
(20839,57,377,772,0,700000), -- Adena
(20839,631,1,1,1,112), -- Eldarake
(20839,1964,1,1,1,5978), -- Eldarake Temper
(20839,2413,1,1,1,79), -- Chain Hood
(20839,2495,1,1,1,112), -- Chain Shield
(20839,2936,1,1,1,5430), -- Chain Hood Pattern
(20839,2945,1,1,1,5978), -- Chain Shield Fragment
(20839,1867,1,1,2,73977), -- Animal Skin
(20839,1872,1,1,2,73977), -- Animal Bone
(20839,1882,1,1,2,12330), -- Leather
(20839,1894,1,1,2,1947), -- Crafted Leather
(20839,2230,1,1,2,1076), -- Recipe: Theca Leather Gaiters
(20839,2326,1,1,2,194), -- Recipe: Horn of Glory
(20839,4042,1,1,2,925), -- Enria
(20839,6668,1,1,2,19816), -- Deluxe Chest Key - Grade 4
(20840,1967,1,1,-1,52860), -- Plated Leather Gaiters Material
(20840,2166,1,1,-1,32854), -- Recipe: Earrings of Binding (100%)
(20840,2328,1,1,-1,2254), -- Recipe: Sword of Delusion
(20840,57,390,796,0,700000), -- Adena
(20840,227,1,1,1,8), -- Stiletto
(20840,242,1,1,1,8), -- Soulfire Dirk
(20840,2083,1,1,1,714), -- Stiletto Edge
(20840,2084,1,1,1,714), -- Soulfire Dirk Blade
(20840,952,1,1,2,818), -- Scroll: Enchant Armor (Grade C)
(20840,1868,1,1,2,122694), -- Thread
(20840,1873,1,1,2,24539), -- Silver Nugget
(20840,1889,1,1,2,4090), -- Compound Braid
(20840,2229,1,1,2,744), -- Recipe: Theca Leather Armor
(20840,4044,1,1,2,2045), -- Thons
(20840,5549,1,1,2,6135), -- Metallic Thread
(20841,951,1,1,-1,1811), -- Scroll: Enchant Weapon (Grade C)
(20841,1911,1,1,-1,74098), -- Earring of Protection Gemstone
(20841,4438,1,1,-1,7105), -- Knuckle Duster Edge
(20841,57,402,817,0,700000), -- Adena
(20841,282,1,1,1,8), -- Elemental Bow
(20841,285,1,1,1,8), -- Noble Elven Bow
(20841,2085,1,1,1,764), -- Crossbow Shaft
(20841,2086,1,1,1,764), -- Elven Bow of Nobility Shaft
(20841,952,1,1,2,736), -- Scroll: Enchant Armor (Grade C)
(20841,1864,1,1,2,110354), -- Stem
(20841,1869,1,1,2,55177), -- Iron Ore
(20841,1880,1,1,2,5518), -- Steel
(20841,2348,1,1,2,129), -- Recipe: Heathen\'s Book
(20841,2351,1,1,2,116), -- Recipe: Scorpion
(20841,4043,1,1,2,1840), -- Asofe
(20841,5550,1,1,2,736), -- Durable Metal Plate
(20842,1976,1,1,-1,57819), -- Rind Leather Gaiters Material
(20842,2167,1,1,-1,48512), -- Recipe: Ring of Ages
(20842,2335,1,1,-1,2211), -- Recipe: War Axe
(20842,57,383,781,0,700000), -- Adena
(20842,853,1,1,1,72), -- Earring of Protection
(20842,884,1,1,1,109), -- Ring of Protection
(20842,916,1,1,1,54), -- Necklace of Protection
(20842,1911,1,1,1,5224), -- Earring of Protection Gemstone
(20842,1912,1,1,1,7568), -- Ring of Protection Gemstone
(20842,1913,1,1,1,4271), -- Necklace of Protection Gemstone
(20842,952,1,1,2,937), -- Scroll: Enchant Armor (Grade C)
(20842,1865,1,1,2,70215), -- Varnish
(20842,1870,1,1,2,70215), -- Coal
(20842,1874,1,1,2,4682), -- Oriharukon Ore
(20842,4039,1,1,2,2341), -- Mold Glue
(20842,4043,1,1,2,2341), -- Asofe
(20843,1539,1,1,-1,267391), -- Greater Healing Potion
(20843,1914,1,1,-1,67599), -- Earring of Binding Gemstone
(20843,4601,1,1,-1,2674), -- Greater Dye of Strength <Str+3 Con-3>
(20843,57,485,987,0,700000), -- Adena
(20843,283,1,1,1,12), -- Akat Long Bow
(20843,2109,1,1,1,1396), -- Akat Longbow Shaft
(20843,1866,1,1,2,41467), -- Suede
(20843,1871,1,1,2,62200), -- Charcoal
(20843,1877,1,1,2,2488), -- Adamantite Nugget
(20843,2357,1,1,2,102), -- Recipe: Crystal Dagger
(20843,3014,1,1,2,1738), -- Recipe: Full Plate Boots
(20843,4040,1,1,2,1245), -- Mold Lubricant
(20843,4041,1,1,2,541), -- Mold Hardener
(20843,4188,1,1,2,72), -- Recipe: Hell Knife
(20844,1539,1,1,-1,238805), -- Greater Healing Potion
(20844,4041,1,1,-1,9345), -- Mold Hardener
(20844,4603,1,1,-1,2388), -- Greater Dye of Constitution <Con+3 Str-3>
(20844,57,434,882,0,700000), -- Adena
(20844,854,1,1,1,51), -- Earring of Binding
(20844,885,1,1,1,76), -- Ring of Ages
(20844,917,1,1,1,38), -- Necklace of Mermaid
(20844,1914,1,1,1,4162), -- Earring of Binding Gemstone
(20844,1915,1,1,1,6527), -- Ring of Ages Gemstone
(20844,1916,1,1,1,3152), -- Necklace of Mermaid Teardrop
(20844,1867,1,1,2,74067), -- Animal Skin
(20844,1872,1,1,2,74067), -- Animal Bone
(20844,1875,1,1,2,3704), -- Stone of Purity
(20844,1881,1,1,2,7407), -- Coarse Bone Powder
(20844,2355,1,1,2,91), -- Recipe: Ghoul\'s Staff
(20844,4041,1,1,2,484), -- Mold Hardener
(20844,4601,1,1,2,124), -- Greater Dye of Strength <Str+3 Con-3>
(20844,4609,1,1,2,124), -- Greater Dye of Mental Strength <Men+3 Int-3>
(20845,2100,1,1,-1,8254), -- Paradia Staff Head
(20845,2354,1,1,-1,2389), -- Recipe: Deadman\'s Staff
(20845,4042,1,1,-1,24403), -- Enria
(20845,57,593,1199,0,700000), -- Adena
(20845,75,1,1,1,3), -- Caliburs
(20845,76,1,1,1,3), -- Sword of Delusion
(20845,77,1,1,1,3), -- Tsurugi
(20845,84,1,1,1,3), -- Homunkulus\'s Sword
(20845,134,1,1,1,3), -- Sword of Nightmare
(20845,145,1,1,1,3), -- Sword of Whispering Death
(20845,2089,1,1,1,275), -- Caliburs Edge
(20845,2090,1,1,1,275), -- Delusional Blade
(20845,2091,1,1,1,275), -- Tsurugi Blade
(20845,2092,1,1,1,275), -- Homunkulus\'s Sword Blade
(20845,2095,1,1,1,275), -- Sword of Nightmare Blade
(20845,2096,1,1,1,275), -- Sword of Whispering Death Blade
(20845,1868,1,1,2,121101), -- Thread
(20845,1873,1,1,2,24221), -- Silver Nugget
(20845,1876,1,1,2,12111), -- Mithril Ore
(20845,1895,1,1,2,17301), -- Metallic Fiber
(20845,3017,1,1,2,1692), -- Recipe: Divine Gloves
(20845,4042,1,1,2,1010), -- Enria
(20845,4608,1,1,2,135), -- Greater Dye of Intelligence <Int+3 Wit-3>
(20845,5155,1,1,2,122), -- Recipe: Soulshot (B) Compressed Package (100%)
(20845,6669,1,1,2,14082), -- Deluxe Chest Key - Grade 5
(20846,1918,1,1,-1,55929), -- Nassen\'s Earring Gemstone
(20846,2955,1,1,-1,81734), -- Theca Leather Gloves Texture
(20846,4042,1,1,-1,21523), -- Enria
(20846,57,521,1059,0,700000), -- Adena
(20846,400,1,1,1,20), -- Theca Leather Armor
(20846,401,1,1,1,11), -- Drake Leather Armor
(20846,420,1,1,1,31), -- Theca Leather Gaiters
(20846,1984,1,1,1,1704), -- Theca Leather Armor Pattern
(20846,1985,1,1,1,2741), -- Theca Leather Gaiters Pattern
(20846,1987,1,1,1,1213), -- Drake Leather Armor Texture
(20846,1865,1,1,2,59603), -- Varnish
(20846,1870,1,1,2,59603), -- Coal
(20846,1874,1,1,2,3974), -- Oriharukon Ore
(20846,4039,1,1,2,1987), -- Mold Glue
(20846,4043,1,1,2,1987), -- Asofe
(20846,4133,1,1,2,287), -- Recipe: Zubei\'s Breastplate
(20846,4941,1,1,2,459), -- Recipe: Zubei\'s Gaiters  (60%)
(20846,4959,1,1,2,1149), -- Recipe: Avadon Boots (60%)
(20847,1806,1,1,-1,2469), -- Recipe: Soulshot: B-Grade
(20847,1985,1,1,-1,42562), -- Theca Leather Gaiters Pattern
(20847,4937,1,1,-1,20368), -- Recipe: Adamantite Earrings (70%)
(20847,57,497,1013,0,700000), -- Adena
(20847,2436,1,1,1,24), -- Theca Leather Boots
(20847,2437,1,1,1,19), -- Drake Leather Boots
(20847,2438,1,1,1,19), -- Full Plate Boots
(20847,2460,1,1,1,24), -- Theca Leather Gloves
(20847,2461,1,1,1,19), -- Drake Leather Gloves
(20847,2462,1,1,1,19), -- Full Plate Gauntlets
(20847,2463,1,1,1,19), -- Divine Gloves
(20847,2954,1,1,1,2061), -- Theca Leather Boots Texture
(20847,2955,1,1,1,2061), -- Theca Leather Gloves Texture
(20847,2960,1,1,1,1773), -- Drake Leather Boots Design
(20847,2961,1,1,1,1773), -- Full Plate Boots Part
(20847,2962,1,1,1,1773), -- Drake Leather Gloves Design
(20847,2963,1,1,1,1773), -- Full Plate Gauntlets Part
(20847,2964,1,1,1,1773), -- Divine Gloves Pattern
(20847,1864,1,1,2,113935), -- Stem
(20847,1869,1,1,2,56968), -- Iron Ore
(20847,1878,1,1,2,22787), -- Braided Hemp
(20847,1884,1,1,2,35057), -- Cord
(20847,4039,1,1,2,1900), -- Mold Glue
(20847,4178,1,1,2,1046), -- Recipe: Zubei\'s Shield (100%)
(20847,4184,1,1,2,66), -- Recipe: Sprite\'s Staff
(20847,5160,1,1,2,114), -- Recipe: Spiritshot (B) Compressed Package (100%)
(20848,1871,1,3,-1,794014), -- Charcoal
(20848,1895,1,1,-1,453722), -- Metallic Fiber
(20848,1908,1,1,-1,150381), -- Moonstone Earring Wire
(20848,57,638,1305,0,700000), -- Adena
(20848,96,1,1,1,11), -- Scythe
(20848,298,1,1,1,11), -- Orcish Glaive
(20848,302,1,1,1,11), -- Body Slasher
(20848,2062,1,1,1,982), -- Scythe Edge
(20848,2075,1,1,1,982), -- Orcish Glaive Blade
(20848,2076,1,1,1,982), -- Body Slasher Blade
(20848,1864,1,3,2,125088), -- Stem
(20848,1865,1,1,2,125088), -- Varnish
(20848,1866,1,1,2,83392), -- Suede
(20848,1868,1,3,2,83392), -- Thread
(20848,1873,1,1,2,50036), -- Silver Nugget
(20848,2164,1,1,2,9622), -- Recipe: Ring of Protection
(20849,1805,1,1,-1,4207), -- Recipe: Soulshot: C-Grade
(20849,1956,1,1,-1,143260), -- Square Shield Fragment
(20849,4469,1,1,-1,7212), -- Dye of Strength <Str+1 Con-1>
(20849,57,519,1039,0,700000), -- Adena
(20849,438,1,1,1,148), -- Sage\'s Rag
(20849,1953,1,1,1,10151), -- Sage\'s Rag Lining
(20849,1867,1,1,2,93894), -- Animal Skin
(20849,1869,1,1,2,70420), -- Iron Ore
(20849,1870,1,1,2,70420), -- Coal
(20849,1871,1,1,2,70420), -- Charcoal
(20849,1872,1,1,2,93894), -- Animal Bone
(20849,2205,1,1,2,2229), -- Recipe: Chain Gaiters
(20849,2211,1,1,2,1580), -- Recipe: Plated Leather Armor
(20849,5274,1,1,2,235), -- Recipe: Greater Spiritshot (C) Compressed Package(100%)
(20849,5279,1,1,2,236), -- Recipe: Greater Blessed Spiritshot (C) Compressed Package(100%)
(20859,3035,1,1,-1,22803), -- Recipe: Spiritshot A
(20859,5479,1,1,-1,101196), -- Sealed Tallum Leather Armor Pattern
(20859,57,6881,14050,0,700000), -- Adena
(20859,5287,1,1,1,37), -- Sealed Dark Crystal breastplate
(20859,5288,1,1,1,59), -- Sealed Dark Crystal Gaiters
(20859,5293,1,1,1,25), -- Sealed Tallum Plate Armor
(20859,5520,1,1,1,5431), -- Sealed Dark Crystal Breastplate Pattern
(20859,5521,1,1,1,3832), -- Sealed Tallum Plate Armor Pattern
(20859,5524,1,1,1,8300), -- Sealed Dark Crystal Gaiters Pattern
(20859,1867,7,21,2,74841), -- Animal Skin
(20859,1872,4,12,2,140326), -- Animal Bone
(20859,1875,1,1,2,56130), -- Stone of Purity
(20859,1881,1,1,2,112260), -- Coarse Bone Powder
(20859,3035,1,1,2,1123), -- Recipe: Spiritshot A
(20859,4041,1,1,2,7322), -- Mold Hardener
(20860,5156,1,1,-1,32044), -- Recipe: Soulshot (A) Compressed Package (100%)
(20860,5482,1,1,-1,317205), -- Sealed Dark Crystalline Leggings Design
(20860,5485,1,1,-1,202094), -- Sealed Tallum Tunic Texture
(20860,57,9685,19719,0,700000), -- Adena
(20860,5287,1,1,1,52), -- Sealed Dark Crystal breastplate
(20860,5288,1,1,1,82), -- Sealed Dark Crystal Gaiters
(20860,5293,1,1,1,35), -- Sealed Tallum Plate Armor
(20860,5520,1,1,1,7631), -- Sealed Dark Crystal Breastplate Pattern
(20860,5521,1,1,1,5385), -- Sealed Tallum Plate Armor Pattern
(20860,5524,1,1,1,11663), -- Sealed Dark Crystal Gaiters Pattern
(20860,1868,15,45,2,78878), -- Thread
(20860,1873,2,6,2,118317), -- Silver Nugget
(20860,1876,3,9,2,33805), -- Mithril Ore
(20860,1895,3,9,2,56342), -- Metallic Fiber
(20860,4042,1,1,2,19720), -- Enria
(20860,5271,1,1,2,1578), -- Recipe: Greater Soulshot (A) Compressed Package(100%)
(20919,734,1,1,-1,20266), -- Haste Potion
(20919,1865,1,1,-1,121597), -- Varnish
(20919,5220,1,1,-1,4864), -- Metal Hardener
(20919,57,56,98,0,700000), -- Adena
(20919,24,1,1,1,178), -- Bone Breastplate
(20919,31,1,1,1,283), -- Bone Gaiters
(20919,390,1,1,1,178), -- Cotton Shirt
(20919,412,1,1,1,283), -- Cotton Pants
(20919,1867,1,1,2,23946), -- Animal Skin
(20919,1872,1,1,2,23946), -- Animal Bone
(20919,1881,1,1,2,2395), -- Coarse Bone Powder
(20919,2141,1,1,2,3592), -- Recipe: Silver Mold
(20920,1898,1,1,-1,22414), -- Blue Diamond Necklace Gem
(20920,2014,1,1,-1,2508), -- Iron Hammer Head
(20920,5163,1,1,-1,8728), -- Recipe: Blessed Spiritshot (D) Compressed Package (100%)
(20920,57,99,178,0,700000), -- Adena
(20920,273,1,1,1,53), -- Composition Bow
(20920,2016,1,1,1,756), -- Composition Bow Shaft
(20920,735,1,1,2,1791), -- Potion of Alacrity
(20920,1060,1,1,2,47743), -- Lesser Healing Potion
(20920,1865,1,1,2,21485), -- Varnish
(20920,1870,1,1,2,21485), -- Coal
(20920,1879,1,1,2,3581), -- Cokes
(20921,1804,1,1,-1,6111), -- Recipe: Soulshot: D-Grade
(20921,1864,1,1,-1,305532), -- Stem
(20921,1928,1,1,-1,22253), -- Piece Bone Gaiters Fragment
(20921,57,68,125,0,700000), -- Adena
(20921,39,1,1,1,490), -- Boots
(20921,51,1,1,1,490), -- Bracer
(20921,1930,1,1,1,7714), -- Boot Lining
(20921,1880,1,1,2,1806), -- Steel
(20921,1881,1,1,2,2407), -- Coarse Bone Powder
(20921,1882,1,1,2,4012), -- Leather
(20921,3032,1,1,2,723), -- Recipe: Spiritshot D
(20921,6666,1,1,2,18051), -- Deluxe Chest Key - Grade 2
(20922,1870,1,1,-1,165778), -- Coal
(20922,1899,1,1,-1,25903), -- Necklace of Devotion Chain
(20922,1932,1,1,-1,26314), -- Bone Helmet Design
(20922,57,72,137,0,700000), -- Adena
(20922,123,1,1,1,12), -- Saber
(20922,2017,1,1,1,309), -- Saber Blade
(20922,5285,1,1,1,12), -- Heavy Sword
(20922,5531,1,1,1,391), -- Heavy Sword Edge
(20922,1060,1,1,2,41351), -- Lesser Healing Potion
(20922,1874,1,1,2,1241), -- Oriharukon Ore
(20922,1878,1,1,2,7444), -- Braided Hemp
(20922,2259,1,1,2,289), -- Recipe: Spinebone Sword
(20922,5220,1,1,2,745), -- Metal Hardener
(20923,2019,1,1,-1,5139), -- Trident Edge
(20923,2152,1,1,-1,42069), -- Recipe: Enchanted Necklace
(20923,2263,1,1,-1,3710), -- Recipe: Dwarven Trident
(20923,57,102,201,0,700000), -- Adena
(20923,432,1,1,1,215), -- Cursed Tunic
(20923,465,1,1,1,343), -- Cursed Stockings
(20923,735,1,1,2,1863), -- Potion of Alacrity
(20923,1875,1,1,2,1491), -- Stone of Purity
(20923,1879,1,1,2,3726), -- Cokes
(20923,1885,1,1,2,1863), -- High Grade Suede
(20923,5549,1,1,2,2236), -- Metallic Thread
(20923,5550,1,1,2,299), -- Durable Metal Plate
(20924,1900,1,1,-1,31603), -- Enchanted Necklace Chain
(20924,1937,1,1,-1,24815), -- Scale Gaiters Fragment
(20924,2250,1,1,-1,72213), -- Recipe: Bone Arrow
(20924,57,122,244,0,700000), -- Adena
(20924,259,1,1,1,49), -- Single-Edged Jamadhr
(20924,1876,1,1,2,3947), -- Mithril Ore
(20924,1877,1,1,2,790), -- Adamantite Nugget
(20924,1880,1,1,2,1974), -- Steel
(20924,1881,1,1,2,2631), -- Coarse Bone Powder
(20924,1882,1,1,2,4385), -- Leather
(20924,2183,1,1,2,1299), -- Recipe: Mithril Banded Mail
(20924,2274,1,1,2,141), -- Recipe: Skull Breaker
(20924,6667,1,1,2,12332), -- Deluxe Chest Key - Grade 3
(20925,1874,1,1,-1,10384), -- Oriharukon Ore
(20925,2016,1,1,-1,1825), -- Composition Bow Shaft
(20925,2258,1,1,-1,3808), -- Recipe: Temptation of Abyss
(20925,57,69,128,0,700000), -- Adena
(20925,846,1,1,1,288), -- Coral Earring
(20925,878,1,1,1,431), -- Blue Coral Ring
(20925,909,1,1,1,217), -- Blue Diamond Necklace
(20925,1898,1,1,1,2364), -- Blue Diamond Necklace Gem
(20925,1060,1,1,2,40898), -- Lesser Healing Potion
(20925,1867,1,1,2,24539), -- Animal Skin
(20925,1872,1,1,2,24539), -- Animal Bone
(20925,1881,1,1,2,2454), -- Coarse Bone Powder
(20925,5273,1,1,2,737), -- Recipe: Greater Spiritshot (D) Compressed Package(100%)
(20926,1869,1,1,-1,178367), -- Iron Ore
(20926,1875,1,1,-1,11891), -- Stone of Purity
(20926,2018,1,1,-1,2370), -- Assassin Knife Edge
(20926,57,79,147,0,700000), -- Adena
(20926,156,1,1,1,17), -- Hand Axe
(20926,167,1,1,1,17), -- Scalpel
(20926,178,1,1,1,17), -- Bone Staff
(20926,1831,1,1,2,38135), -- Antidote
(20926,1834,1,1,2,15890), -- Emergency Dressing
(20926,1875,1,1,2,954), -- Stone of Purity
(20926,1879,1,1,2,2384), -- Cokes
(20926,2178,1,1,2,2289), -- Recipe: Dark Stockings
(20926,5437,1,1,2,350), -- Recipe: Heavy Sword(100%)
(20926,5549,1,1,2,1431), -- Metallic Thread
(20927,1866,1,1,-1,167397), -- Suede
(20927,1899,1,1,-1,39234), -- Necklace of Devotion Chain
(20927,1932,1,1,-1,39856), -- Bone Helmet Design
(20927,57,108,209,0,700000), -- Adena
(20927,220,1,1,1,69), -- Crafted Dagger
(20927,1876,1,1,2,4698), -- Mithril Ore
(20927,1877,1,1,2,940), -- Adamantite Nugget
(20927,1880,1,1,2,2349), -- Steel
(20927,1881,1,1,2,3132), -- Coarse Bone Powder
(20927,1882,1,1,2,5220), -- Leather
(20927,2178,1,1,2,3759), -- Recipe: Dark Stockings
(20928,2025,1,1,-1,3438), -- Dwarven Trident Edge
(20928,2153,1,1,-1,38605), -- Recipe: Tiger\'s Eye Earring
(20928,2183,1,1,-1,16331), -- Recipe: Mithril Banded Mail
(20928,57,105,209,0,700000), -- Adena
(20928,348,1,1,1,52), -- Scale Mail
(20928,377,1,1,1,82), -- Scale Gaiters
(20928,1935,1,1,1,1895), -- Scale Mail Fragment
(20928,1937,1,1,1,2914), -- Scale Gaiters Fragment
(20928,1832,1,1,2,18841), -- Greater Antidote
(20928,1867,1,1,2,22609), -- Animal Skin
(20928,1872,1,1,2,22609), -- Animal Bone
(20928,1875,1,1,2,1131), -- Stone of Purity
(20928,1881,1,1,2,2261), -- Coarse Bone Powder
(20928,2184,1,1,2,1782), -- Recipe: Mithril Banded Gaiters
(20928,2274,1,1,2,122), -- Recipe: Skull Breaker
(20928,2978,1,1,2,2270), -- Recipe: Elven Mithril Boots
(20929,956,1,1,-1,7763), -- Scroll: Enchant Armor (Grade D)
(20929,1871,1,1,-1,232889), -- Charcoal
(20929,1900,1,1,-1,25480), -- Enchanted Necklace Chain
(20929,57,98,197,0,700000), -- Adena
(20929,315,1,1,1,40), -- Divine Tome
(20929,1060,1,1,2,40402), -- Lesser Healing Potion
(20929,1865,1,1,2,18181), -- Varnish
(20929,1870,1,1,2,18181), -- Coal
(20929,1875,1,1,2,1213), -- Stone of Purity
(20929,1879,1,1,2,3031), -- Cokes
(20929,2250,1,1,2,4546), -- Recipe: Bone Arrow
(20929,6387,1,1,2,728), -- Blessed Scroll of Resurrection for Pets
(20930,2028,1,1,-1,4318), -- Shilen Knife Edge
(20930,2154,1,1,-1,38910), -- Recipe: Elven Earring
(20930,2156,1,1,-1,29074), -- Recipe: Elven Necklace
(20930,57,153,306,0,700000), -- Adena
(20930,83,1,1,1,10), -- Sword of Magic
(20930,124,1,1,1,7), -- Two-Handed Sword
(20930,127,1,1,1,7), -- Crimson Sword
(20930,130,1,1,1,7), -- Elven Sword
(20930,144,1,1,1,10), -- Sword of Occult
(20930,2026,1,1,1,388), -- Two-Handed Sword Edge
(20930,735,1,1,2,2684), -- Potion of Alacrity
(20930,1864,1,1,2,64410), -- Stem
(20930,1869,1,1,2,32205), -- Iron Ore
(20930,1880,1,1,2,3221), -- Steel
(20930,2279,1,1,2,230), -- Recipe: War Pick
(20930,5550,1,1,2,430), -- Durable Metal Plate
(20931,1901,1,1,-1,55757), -- Tiger\'s Eye Earring Stone
(20931,1940,1,1,-1,60251), -- Iron Boots Design
(20931,2271,1,1,-1,2883), -- Recipe: Winged Spear
(20931,57,170,341,0,700000), -- Adena
(20931,293,1,1,1,22), -- War Hammer
(20931,296,1,1,1,22), -- Dwarven Pike
(20931,1865,1,1,2,30663), -- Varnish
(20931,1870,1,1,2,30663), -- Coal
(20931,1875,1,1,2,2045), -- Stone of Purity
(20931,1879,1,1,2,5111), -- Cokes
(20931,2197,1,1,2,643), -- Recipe: Salamander Skin Mail
(20931,2276,1,1,2,220), -- Recipe: Maingauche
(20931,2286,1,1,2,171), -- Recipe: Bonebreaker
(20932,1825,1,1,-1,31452), -- Recipe: Oriharukon
(20932,2032,1,1,-1,4069), -- Goat Head Staff Head
(20932,5220,1,1,-1,17613), -- Metal Hardener
(20932,57,186,372,0,700000), -- Adena
(20932,850,1,1,1,82), -- Elven Earring
(20932,881,1,1,1,122), -- Elven Ring
(20932,913,1,1,1,61), -- Elven Necklace
(20932,1902,1,1,1,3844), -- Elven Earring Beads
(20932,1903,1,1,1,6329), -- Elven Ring Piece
(20932,1904,1,1,1,3541), -- Elven Necklace Beads
(20932,1060,1,1,2,72260), -- Lesser Healing Potion
(20932,1866,1,1,2,21678), -- Suede
(20932,1871,1,1,2,32517), -- Charcoal
(20932,1885,1,1,2,2710), -- High Grade Suede
(20932,2159,1,1,2,2008), -- Recipe: Necklace of Darkness
(20932,2201,1,1,2,3158), -- Recipe: Square Shield
(20932,5220,1,1,2,1301), -- Metal Hardener
(20933,1879,1,1,-1,83876), -- Cokes
(20933,1880,1,1,-1,50326), -- Steel
(20933,1894,1,1,-1,17658), -- Crafted Leather
(20933,57,211,421,0,700000), -- Adena
(20933,261,1,1,1,19), -- Bich\'Hwa
(20933,2039,1,1,1,1317), -- Bich\'Hwa Edge
(20933,4922,1,1,2,5420), -- Spellbook: Summon Binding Cubic
(20933,4923,1,1,2,5420), -- Spellbook: Summon Aqua Cubic
(20933,4924,1,1,2,5420), -- Spellbook: Summon Spark Cubic
(20933,10052,1,1,2,5025), -- Battle Manual: Twin Shot
(20934,1868,1,1,-1,545126), -- Thread
(20934,1938,1,1,-1,18324), -- Mithril Banded Mail Material
(20934,2028,1,1,-1,3238), -- Shilen Knife Edge
(20934,57,115,230,0,700000), -- Adena
(20934,436,1,1,1,96), -- Tunic of Knowledge
(20934,469,1,1,1,153), -- Stockings of Knowledge
(20934,1867,1,1,2,38646), -- Animal Skin
(20934,1872,1,1,2,38646), -- Animal Bone
(20934,1882,1,1,2,6441), -- Leather
(20934,2190,1,1,2,2071), -- Recipe: Mithril Stockings
(20934,3020,1,1,2,162), -- Recipe: Elven Long Sword
(20935,1825,1,1,-1,21225), -- Recipe: Oriharukon
(20935,1872,1,1,-1,396209), -- Animal Bone
(20935,2040,1,1,-1,3438), -- Strengthened Long Bow Shaft
(20935,57,126,251,0,700000), -- Adena
(20935,629,1,1,1,66), -- Kite Shield
(20935,1947,1,1,1,3687), -- Kite Shield Fragment
(20935,2411,1,1,1,46), -- Brigandine Helmet
(20935,2493,1,1,1,66), -- Brigandine Shield
(20935,2922,1,1,1,987), -- Brigandine Helmet Design
(20935,2929,1,1,1,3687), -- Brigandine Shield Fragment
(20935,1868,1,1,2,43888), -- Thread
(20935,1873,1,1,2,8778), -- Silver Nugget
(20935,1889,1,1,2,1463), -- Compound Braid
(20935,2148,1,1,2,1568), -- Recipe: Crafted Leather
(20935,2288,1,1,2,122), -- Recipe: Ghost Staff
(20935,2984,1,1,2,2244), -- Recipe: Salamander Skin Boots
(20935,5549,1,1,2,2195), -- Metallic Thread
(20936,1874,1,1,-1,37494), -- Oriharukon Ore
(20936,1875,1,1,-1,37494), -- Stone of Purity
(20936,1902,1,1,-1,56982), -- Elven Earring Beads
(20936,57,236,471,0,700000), -- Adena
(20936,437,1,1,1,65), -- Mithril Tunic
(20936,470,1,1,1,104), -- Mithril Stockings
(20936,1944,1,1,1,3707), -- Mithril Tunic Fabric
(20936,1945,1,1,1,5773), -- Mithril Stocking Design
(20936,1865,1,1,2,48455), -- Varnish
(20936,1870,1,1,2,48455), -- Coal
(20936,1875,1,1,2,3231), -- Stone of Purity
(20936,1879,1,1,2,8076), -- Cokes
(20936,2159,1,1,2,2991), -- Recipe: Necklace of Darkness
(20936,2298,1,1,2,212), -- Recipe: Stormbringer
(20937,1805,1,1,-1,2444), -- Recipe: Soulshot: C-Grade
(20937,2054,1,1,-1,6241), -- Light Crossbow Shaft
(20937,4480,1,1,-1,4191), -- Dye of Wit <Wit+1 Men-1>
(20937,57,300,606,0,700000), -- Adena
(20937,61,1,1,1,63), -- Mithril Gloves
(20937,607,1,1,1,63), -- Ogre Power Gauntlets
(20937,1125,1,1,1,63), -- Assault Boots
(20937,1949,1,1,1,3425), -- Mithril Gloves Design
(20937,1957,1,1,1,3425), -- Assault Boots Part
(20937,1963,1,1,1,3425), -- Ogre Power Gauntlets Part
(20937,2427,1,1,1,63), -- Salamander Skin Boots
(20937,2428,1,1,1,63), -- Plate Boots
(20937,2451,1,1,1,63), -- Sage\'s Worn Gloves
(20937,2931,1,1,1,3425), -- Salamander Skin Boot Lining
(20937,2932,1,1,1,3425), -- Plate Boots Design
(20937,2933,1,1,1,3425), -- Sage\'s Worn Gloves Lining
(20937,1866,1,1,2,35072), -- Suede
(20937,1871,1,1,2,52607), -- Charcoal
(20937,1885,1,1,2,4384), -- High Grade Suede
(20937,2205,1,1,2,1665), -- Recipe: Chain Gaiters
(20937,2307,1,1,2,230), -- Recipe: Heavy Doom Axe
(20937,5164,1,1,2,176), -- Recipe: Blessed Spiritshot (C) Compressed Package (100%)
(20937,5220,1,1,2,2105), -- Metal Hardener
(20938,1908,1,1,-1,76204), -- Moonstone Earring Wire
(20938,2070,1,1,-1,6390), -- Cursed Dagger Blade
(20938,2323,1,1,-1,2804), -- Recipe: Elemental Bow
(20938,57,323,662,0,700000), -- Adena
(20938,281,1,1,1,17), -- Crystallized Ice Bow
(20938,2074,1,1,1,1347), -- Crystallized Ice Bow Shaft
(20938,1867,1,1,2,72443), -- Animal Skin
(20938,1872,1,1,2,72443), -- Animal Bone
(20938,1882,1,1,2,12074), -- Leather
(20938,1894,1,1,2,1907), -- Crafted Leather
(20938,2315,1,1,2,190), -- Recipe: Shamshir
(20938,2317,1,1,2,190), -- Recipe: Bec de Corbin
(20938,2321,1,1,2,190), -- Recipe: Stiletto
(20939,1868,1,3,-1,898311), -- Thread
(20939,1873,1,1,-1,359325), -- Silver Nugget
(20939,2067,1,1,-1,6474), -- Crystal Staff Head
(20939,57,361,738,0,700000), -- Adena
(20939,397,1,1,1,57), -- Mithril Shirt
(20939,1961,1,1,1,3397), -- Mithril Shirt Fabric
(20939,2387,1,1,1,90), -- Tempered Mithril Gaiters
(20939,2935,1,1,1,5643), -- Tempered Mithril Gaiters Fragment
(20939,1868,1,1,2,121302), -- Thread
(20939,1873,1,1,2,24261), -- Silver Nugget
(20939,1889,1,1,2,4044), -- Compound Braid
(20939,2225,1,1,2,1319), -- Recipe: Demon\'s Stockings
(20939,2343,1,1,2,142), -- Recipe: Mace of the Underworld
(20939,4044,1,1,2,2022), -- Thons
(20939,5549,1,1,2,6066), -- Metallic Thread
(20940,1970,1,1,-1,30149), -- Robe of Seal Fabric
(20940,4589,1,1,-1,4500), -- Greater Dye of Strength <Str+2 Con-2>
(20940,5550,1,1,-1,18001), -- Durable Metal Plate
(20940,57,545,1107,0,700000), -- Adena
(20940,4233,1,1,1,21), -- Knuckle Duster
(20940,1864,1,1,2,149546), -- Stem
(20940,1869,1,1,2,74773), -- Iron Ore
(20940,1880,1,1,2,7478), -- Steel
(20940,2350,1,1,2,157), -- Recipe: Pa\'agrian Axe
(20940,3005,1,1,2,3052), -- Recipe: Demon\'s Boots
(20940,4043,1,1,2,2493), -- Asofe
(20940,4132,1,1,2,2899), -- Recipe: Composite Shield
(20940,4438,1,1,2,2134), -- Knuckle Duster Edge
(20940,5550,1,1,2,997), -- Durable Metal Plate
(20941,2109,1,1,-1,5965), -- Akat Longbow Shaft
(20941,2233,1,1,-1,9943), -- Recipe: Divine Tunic
(20941,4601,1,1,-1,2364), -- Greater Dye of Strength <Str+3 Con-3>
(20941,57,429,873,0,700000), -- Adena
(20941,60,1,1,1,31), -- Composite Armor
(20941,1977,1,1,1,3255), -- Composite Armor Temper
(20941,1865,1,1,2,54995), -- Varnish
(20941,1870,1,1,2,54995), -- Coal
(20941,1874,1,1,2,3667), -- Oriharukon Ore
(20941,3013,1,1,2,1537), -- Recipe: Drake Leather Boots
(20941,3014,1,1,2,1537), -- Recipe: Full Plate Boots
(20941,4039,1,1,2,1834), -- Mold Glue
(20941,4043,1,1,2,1834), -- Asofe
(20942,1905,1,1,-1,52079), -- Omen Beast\'s Eye Earring Gemstone
(20942,2301,1,1,-1,2338), -- Recipe: Battle Axe
(20942,2931,1,1,-1,59751), -- Salamander Skin Boot Lining
(20942,57,216,439,0,700000), -- Adena
(20942,225,1,1,1,15), -- Mithril Dagger
(20942,2052,1,1,1,1167), -- Mithril Dagger Blade
(20942,1866,1,1,2,29871), -- Suede
(20942,1871,1,1,2,44807), -- Charcoal
(20942,1877,1,1,2,1793), -- Adamantite Nugget
(20942,4907,1,1,2,2801), -- Spellbook: Solar Flare
(20942,4909,1,1,2,2801), -- Spellbook: Shadow Flare
(20942,4917,1,1,2,2801), -- Spellbook: Aura Bolt
(20943,1874,1,1,-1,51365), -- Oriharukon Ore
(20943,1875,1,1,-1,51365), -- Stone of Purity
(20943,2163,1,1,-1,39310), -- Recipe: Earring of Protection
(20943,57,311,632,0,700000), -- Adena
(20943,263,1,1,1,16), -- Chakram
(20943,2073,1,1,1,1408), -- Chakram Edge
(20943,1867,1,1,2,80921), -- Animal Skin
(20943,1872,1,1,2,80921), -- Animal Bone
(20943,1875,1,1,2,4047), -- Stone of Purity
(20943,1881,1,1,2,8093), -- Coarse Bone Powder
(20943,2225,1,1,2,1320), -- Recipe: Demon\'s Stockings
(20943,4041,1,1,2,528), -- Mold Hardener
(20944,1911,1,1,-1,48520), -- Earring of Protection Gemstone
(20944,2329,1,1,-1,1517), -- Recipe: Tsurugi
(20944,2947,1,1,-1,46596), -- Dwarven Chain Shield Fragment
(20944,57,263,536,0,700000), -- Adena
(20944,853,1,1,1,50), -- Earring of Protection
(20944,884,1,1,1,75), -- Ring of Protection
(20944,916,1,1,1,37), -- Necklace of Protection
(20944,1911,1,1,1,3584), -- Earring of Protection Gemstone
(20944,1912,1,1,1,5192), -- Ring of Protection Gemstone
(20944,1913,1,1,1,2930), -- Necklace of Protection Gemstone
(20944,1868,1,1,2,96347), -- Thread
(20944,1873,1,1,2,19270), -- Silver Nugget
(20944,1876,1,1,2,9635), -- Mithril Ore
(20944,1895,1,1,2,13764), -- Metallic Fiber
(20944,2328,1,1,2,112), -- Recipe: Sword of Delusion
(20944,4042,1,1,2,803), -- Enria
(20945,1868,1,3,-1,733375), -- Thread
(20945,1876,1,1,-1,146675), -- Mithril Ore
(20945,4601,1,1,-1,1630), -- Greater Dye of Strength <Str+3 Con-3>
(20945,57,296,601,0,700000), -- Adena
(20945,64,1,1,1,62), -- Composite Boots
(20945,608,1,1,1,62), -- Mithril Gauntlets
(20945,1981,1,1,1,4460), -- Mithril Gauntlets Design
(20945,2956,1,1,1,4460), -- Composite Boots Part
(20945,1868,1,1,2,86651), -- Thread
(20945,1873,1,1,2,17331), -- Silver Nugget
(20945,1876,1,1,2,8666), -- Mithril Ore
(20945,1895,1,1,2,12379), -- Metallic Fiber
(20945,2170,1,1,2,1022), -- Recipe: Nassen\'s Earring
(20945,2970,1,1,2,1537), -- Recipe: Ring of Binding
(20945,4042,1,1,2,723), -- Enria
(20946,1539,1,1,-1,251226), -- Greater Healing Potion
(20946,1914,1,1,-1,63512), -- Earring of Binding Gemstone
(20946,2169,1,1,-1,20009), -- Recipe: Necklace of Binding
(20946,57,458,926,0,700000), -- Adena
(20946,103,1,1,1,46), -- Tower Shield
(20946,107,1,1,1,46), -- Composite Shield
(20946,517,1,1,1,32), -- Composite Helmet
(20946,1149,1,1,1,32), -- Shining Circlet
(20946,1978,1,1,1,3746), -- Tower Shield Fragment
(20946,1983,1,1,1,2563), -- Shining Circlet Pattern
(20946,2957,1,1,1,2564), -- Composite Helmet Design
(20946,4055,1,1,1,3746), -- Composite Shield Fragment
(20946,1864,1,1,2,133576), -- Stem
(20946,1869,1,1,2,66788), -- Iron Ore
(20946,1878,1,1,2,26715), -- Braided Hemp
(20946,1884,1,1,2,41100), -- Cord
(20946,2233,1,1,2,625), -- Recipe: Divine Tunic
(20946,4039,1,1,2,2227), -- Mold Glue
(20946,4180,1,1,2,7421), -- Recipe: Silver Arrow
(20947,1806,1,1,-1,2448), -- Recipe: Soulshot: B-Grade
(20947,4938,1,1,-1,30291), -- Recipe: Adamantite Ring (70%)
(20947,4967,1,1,-1,1410), -- Recipe: Sword of Valhalla (60%)
(20947,57,493,1004,0,700000), -- Adena
(20947,356,1,1,1,22), -- Full Plate Armor
(20947,1986,1,1,1,2388), -- Full Plate Armor Temper
(20947,1864,1,1,2,112964), -- Stem
(20947,1869,1,1,2,56482), -- Iron Ore
(20947,1880,1,1,2,5649), -- Steel
(20947,4043,1,1,2,1883), -- Asofe
(20947,4144,1,1,2,581), -- Recipe: Zubei\'s Leather Gaiters
(20947,4179,1,1,2,727), -- Recipe: Zubei\'s Helmet
(20947,4184,1,1,2,66), -- Recipe: Sprite\'s Staff
(20947,5550,1,1,2,754), -- Durable Metal Plate
(20948,4049,1,1,-1,63959), -- Adamantite Earring Gemstone
(20948,4050,1,1,-1,75550), -- Adamantite Ring Wire
(20948,4129,1,1,-1,13197), -- Recipe: Earrings of Black Ore
(20948,57,491,1002,0,700000), -- Adena
(20948,78,1,1,1,2), -- Great Sword
(20948,142,1,1,1,2), -- Keshanberk
(20948,148,1,1,1,2), -- Sword of Valhalla
(20948,4104,1,1,1,344), -- Great Sword Blade
(20948,4107,1,1,1,339), -- Keshanberk Blade
(20948,4108,1,1,1,339), -- Sword of Valhalla Blade
(20948,948,1,1,2,113), -- Scroll: Enchant Armor (Grade B)
(20948,1865,1,1,2,45024), -- Varnish
(20948,1870,1,1,2,45024), -- Coal
(20948,1875,1,1,2,3002), -- Stone of Purity
(20948,1879,1,1,2,7504), -- Cokes
(20948,4040,1,1,2,901), -- Mold Lubricant
(20948,4158,1,1,2,96), -- Recipe: Doom Plate Armor
(20948,4176,1,1,2,560), -- Recipe: Doom Boots
(20949,947,1,1,-1,577), -- Scroll: Enchant Weapon (Grade B)
(20949,1866,1,3,-1,480591), -- Suede
(20949,4041,1,1,-1,12537), -- Mold Hardener
(20949,57,581,1183,0,700000), -- Adena
(20949,91,1,1,1,3), -- Heavy War Axe
(20949,92,1,1,1,3), -- Sprite\'s Staff
(20949,4105,1,1,1,610), -- Heavy War Axe Head
(20949,4106,1,1,1,600), -- Sprite\'s Staff Head
(20949,1866,1,1,2,35490), -- Suede
(20949,1871,1,1,2,53235), -- Charcoal
(20949,1885,1,1,2,4437), -- High Grade Suede
(20949,4041,1,1,2,463), -- Mold Hardener
(20949,4129,1,1,2,577), -- Recipe: Earrings of Black Ore
(20949,4165,1,1,2,440), -- Recipe: Blue Wolf Helmet
(20949,4993,1,1,2,663), -- Recipe: Doom Gloves (60%)
(20949,5220,1,1,2,2130), -- Metal Hardener
(20950,947,1,1,-1,623), -- Scroll: Enchant Weapon (Grade B)
(20950,4049,1,1,-1,81733), -- Adamantite Earring Gemstone
(20950,4056,1,1,-1,28204), -- Zubei\'s Breastplate Part
(20950,57,629,1278,0,700000), -- Adena
(20950,300,1,1,1,6), -- Great Axe
(20950,4113,1,1,1,1184), -- Great Axe Head
(20950,4931,1,1,2,3197), -- Spellbook: Aura Symphony
(20950,4932,1,1,2,3197), -- Spellbook: Inferno
(20950,4933,1,1,2,3197), -- Spellbook: Blizzard
(20950,4934,1,1,2,3197), -- Spellbook: Demon Wind
(20950,10192,1,1,2,4082), -- Battle Manual: Enervation
(20950,10087,1,1,2,3401), -- Battle Manual: Sharpshooting
(20951,1806,1,1,-1,1655), -- Recipe: Soulshot: B-Grade
(20951,1918,1,1,-1,35828), -- Nassen\'s Earring Gemstone
(20951,1920,1,1,-1,28307), -- Necklace of Binding Chain
(20951,57,334,678,0,700000), -- Adena
(20951,266,1,1,1,5), -- Great Pata
(20951,2120,1,1,1,735), -- Great Pata Blade
(20951,1806,1,1,2,77), -- Recipe: Soulshot: B-Grade
(20951,1867,1,1,2,50910), -- Animal Skin
(20951,1872,1,1,2,50910), -- Animal Bone
(20951,1882,1,1,2,8485), -- Leather
(20951,1894,1,1,2,1340), -- Crafted Leather
(20951,4042,1,1,2,637), -- Enria
(20951,5270,1,1,2,77), -- Recipe: Greater Soulshot (B) Compressed Package(100%)
(20951,5436,1,1,2,63), -- Recipe: Berserker Blade(100%)
(20952,1984,1,1,-1,32140), -- Theca Leather Armor Pattern
(20952,3034,1,1,-1,2999), -- Recipe: Spiritshot B
(20952,4044,1,1,-1,49978), -- Thons
(20952,57,604,1231,0,700000), -- Adena
(20952,286,1,1,1,10), -- Eminence Bow
(20952,2121,1,1,1,1273), -- Eminence Bow Shaft
(20952,1868,1,1,2,138402), -- Thread
(20952,1873,1,1,2,27681), -- Silver Nugget
(20952,1889,1,1,2,4614), -- Compound Braid
(20952,4044,1,1,2,2307), -- Thons
(20952,4128,1,1,2,857), -- Recipe: Adamantite Necklace
(20952,4187,1,1,2,80), -- Recipe: Kris
(20952,5275,1,1,2,139), -- Recipe: Greater Spiritshot (B) Compressed Package(100%)
(20952,5549,1,1,2,6921), -- Metallic Thread
(20953,1864,1,5,-1,932365), -- Stem
(20953,2962,1,1,-1,76153), -- Drake Leather Gloves Design
(20953,4948,1,1,-1,6134), -- Recipe: Avadon Leather Armor (60%)
(20953,57,563,1149,0,700000), -- Adena
(20953,856,1,1,1,23), -- Adamantite Earring
(20953,887,1,1,1,35), -- Adamantite Ring
(20953,918,1,1,1,18), -- Adamantite Necklace
(20953,4049,1,1,1,3612), -- Adamantite Earring Gemstone
(20953,4050,1,1,1,4267), -- Adamantite Ring Wire
(20953,4051,1,1,1,2671), -- Adamantite Necklace Chain
(20953,1864,1,1,2,118032), -- Stem
(20953,1869,1,1,2,59016), -- Iron Ore
(20953,1878,1,1,2,23607), -- Braided Hemp
(20953,1884,1,1,2,36318), -- Cord
(20953,4039,1,1,2,1968), -- Mold Glue
(20953,4962,1,1,2,759), -- Recipe: Zubei\'s Helmet (60%)
(20953,4999,1,1,2,735), -- Recipe: Doom Boots (60%)
(20954,1869,1,3,-1,830753), -- Iron Ore
(20954,4049,1,1,-1,87150), -- Adamantite Earring Gemstone
(20954,4613,1,1,-1,2292), -- Greater Dye of Strength <Str+4 Con-4>
(20954,57,670,1363,0,700000), -- Adena
(20954,229,1,1,1,3), -- Kris
(20954,243,1,1,1,3), -- Hell Knife
(20954,4109,1,1,1,692), -- Kris Edge
(20954,4110,1,1,1,692), -- Hell Knife Edge
(20954,1864,1,1,2,140225), -- Stem
(20954,1869,1,1,2,70113), -- Iron Ore
(20954,1880,1,1,2,7012), -- Steel
(20954,4043,1,1,2,2338), -- Asofe
(20954,4159,1,1,2,199), -- Recipe: Blue Wolf Leather Armor
(20954,4990,1,1,2,580), -- Recipe: Blue Wolf Helmet (60%)
(20954,5550,1,1,2,935), -- Durable Metal Plate
(20955,4052,1,1,-1,68637), -- Earring of Black Ore Piece
(20955,5230,1,1,-1,2585), -- Recipe: Mithril Arrow (100%)
(20955,57,784,1588,0,700000), -- Adena
(20955,2391,1,1,1,9), -- Blue Wolf Leather Armor
(20955,2392,1,1,1,9), -- Leather Armor of Doom
(20955,4082,1,1,1,1618), -- Blue Wolf Leather Armor Texture
(20955,4083,1,1,1,1618), -- Leather Armor of Doom Design
(20955,1830,1,1,2,32723), -- Scroll of Escape: Castle
(20955,1865,1,1,2,81808), -- Varnish
(20955,1870,1,1,2,81808), -- Coal
(20955,1874,1,1,2,5454), -- Oriharukon Ore
(20955,4039,1,1,2,2727), -- Mold Glue
(20955,4043,1,1,2,2727), -- Asofe
(20955,5276,1,1,2,110), -- Recipe: Greater Spiritshot (A) Compressed Package(100%)
(20956,1884,1,3,-1,599263), -- Cord
(20956,4106,1,1,-1,10962), -- Sprite\'s Staff Head
(20956,4987,1,1,-1,8081), -- Recipe: Tunic of Doom (60%)
(20956,57,789,1595,0,700000), -- Adena
(20956,234,1,1,1,5), -- Demon\'s Sword
(20956,4119,1,1,1,1259), -- Demon\'s Sword Edge
(20956,1874,1,1,2,4795), -- Oriharukon Ore
(20956,1878,1,1,2,28765), -- Braided Hemp
(20956,1884,1,1,2,44254), -- Cord
(20956,1889,1,1,2,4795), -- Compound Braid
(20956,2508,1,1,2,59927), -- Cursed Bone
(20956,3956,1,1,2,97), -- Recipe: Blessed Spiritshot A
(20956,4175,1,1,2,1386), -- Recipe: Avadon Boots
(20956,5220,1,1,2,2877), -- Metal Hardener
(20957,1877,1,1,-1,81685), -- Adamantite Nugget
(20957,4052,1,1,-1,72301), -- Earring of Black Ore Piece
(20957,4053,1,1,-1,87533), -- Ring of Black Ore Gemstone
(20957,57,825,1674,0,700000), -- Adena
(20957,110,1,1,1,24), -- Doom Shield
(20957,2416,1,1,1,17), -- Blue Wolf Helmet
(20957,2417,1,1,1,17), -- Doom Helmet
(20957,4077,1,1,1,4523), -- Doom Shield Fragment
(20957,4088,1,1,1,3800), -- Blue Wolf Helmet Design
(20957,4089,1,1,1,3800), -- Doom Helmet Pattern
(20957,1344,10,30,2,94253), -- Mithril Arrow
(20957,1830,1,1,2,30161), -- Scroll of Escape: Castle
(20957,1866,1,1,2,50269), -- Suede
(20957,1871,1,1,2,75403), -- Charcoal
(20957,1877,1,1,2,3017), -- Adamantite Nugget
(20957,4040,1,1,2,1508), -- Mold Lubricant
(20957,4041,1,1,2,656), -- Mold Hardener
(20957,5276,1,1,2,101), -- Recipe: Greater Spiritshot (A) Compressed Package(100%)
(20958,1807,1,1,-1,2044), -- Recipe: Soulshot: A-Grade
(20958,5478,1,1,-1,12889), -- Sealed Dark Crystal Leather Armor Pattern
(20958,57,618,1257,0,700000), -- Adena
(20958,5289,1,1,1,9), -- Sealed Dark Crystal Helmet
(20958,5292,1,1,1,13), -- Sealed Dark Crystal Shield
(20958,5294,1,1,1,9), -- Sealed Tallum Helmet
(20958,5494,1,1,1,1585), -- Sealed Dark Crystal Shield Fragment
(20958,5525,1,1,1,1167), -- Sealed Dark Crystal Helmet Design
(20958,5526,1,1,1,1167), -- Sealed Tallum Helm Design
(20958,1867,1,1,2,100610), -- Animal Skin
(20958,1872,1,1,2,100610), -- Animal Bone
(20958,1875,1,1,2,5031), -- Stone of Purity
(20958,1881,1,1,2,10061), -- Coarse Bone Powder
(20958,4041,1,1,2,657), -- Mold Hardener
(20958,5156,1,1,2,101), -- Recipe: Soulshot (A) Compressed Package (100%)
(20959,1807,1,1,-1,3291), -- Recipe: Soulshot: A-Grade
(20959,4054,1,1,-1,48618), -- Necklace of Black Ore Beads
(20959,5478,1,1,-1,20756), -- Sealed Dark Crystal Leather Armor Pattern
(20959,57,996,2026,0,700000), -- Adena
(20959,5304,1,1,1,8), -- Sealed Tallum Tunic
(20959,5305,1,1,1,12), -- Sealed Tallum Stockings
(20959,5308,1,1,1,5), -- Sealed Dark Crystal Robe
(20959,5485,1,1,1,1022), -- Sealed Tallum Tunic Texture
(20959,5486,1,1,1,719), -- Sealed Dark Crystal Robe Fabric
(20959,5489,1,1,1,1604), -- Sealed Tallum Stockings Fabric
(20959,1866,1,1,2,69439), -- Suede
(20959,1871,1,1,2,104159), -- Charcoal
(20959,1877,1,1,2,4167), -- Adamantite Nugget
(20959,4040,1,1,2,2084), -- Mold Lubricant
(20959,4041,1,1,2,906), -- Mold Hardener
(20959,4953,1,1,2,2007), -- Recipe: Avadon Gloves (60%)
(20959,5281,1,1,2,139), -- Recipe: Greater Blessed Spiritshot (A) Compressed Package(100%)
(20960,4052,1,1,-1,47533), -- Earring of Black Ore Piece
(20960,4053,1,1,-1,57546), -- Ring of Black Ore Gemstone
(20960,5230,1,1,-1,1790), -- Recipe: Mithril Arrow (100%)
(20960,57,544,1100,0,700000), -- Adena
(20960,97,1,1,1,4), -- Lance
(20960,4115,1,1,1,865), -- Lance Blade
(20960,1343,10,30,2,70816), -- Silver Arrow
(20960,1868,1,1,2,99143), -- Thread
(20960,1873,1,1,2,19829), -- Silver Nugget
(20960,1876,1,1,2,9915), -- Mithril Ore
(20960,1895,1,1,2,14164), -- Metallic Fiber
(20960,4042,1,1,2,827), -- Enria
(20960,5230,1,1,2,67), -- Recipe: Mithril Arrow (100%)
(20960,5276,1,1,2,67), -- Recipe: Greater Spiritshot (A) Compressed Package(100%)
(20961,1884,1,3,-1,607931), -- Cord
(20961,4053,1,1,-1,84688), -- Ring of Black Ore Gemstone
(20961,5230,1,1,-1,2634), -- Recipe: Mithril Arrow (100%)
(20961,57,799,1619,0,700000), -- Adena
(20961,601,1,1,1,19), -- Boots of Doom
(20961,2439,1,1,1,19), -- Blue Wolf Boots
(20961,2475,1,1,1,19), -- Doom Gloves
(20961,2487,1,1,1,19), -- Blue Wolf Gloves
(20961,4090,1,1,1,3275), -- Blue Wolf Boots Design
(20961,4091,1,1,1,3275), -- Doom Gloves Part
(20961,4096,1,1,1,3275), -- Blue Wolf Gloves Fabric
(20961,4099,1,1,1,3275), -- Doom Boots Part
(20961,1864,1,1,2,166747), -- Stem
(20961,1869,1,1,2,83374), -- Iron Ore
(20961,1878,1,1,2,33350), -- Braided Hemp
(20961,1884,1,1,2,51307), -- Cord
(20961,3956,1,1,2,112), -- Recipe: Blessed Spiritshot A
(20961,4039,1,1,2,2780), -- Mold Glue
(20961,5230,1,1,2,112), -- Recipe: Mithril Arrow (100%)
(20962,4054,1,1,-1,37144), -- Necklace of Black Ore Beads
(20962,4077,1,1,-1,84831), -- Doom Shield Fragment
(20962,5230,1,1,-1,2514), -- Recipe: Mithril Arrow (100%)
(20962,57,762,1545,0,700000), -- Adena
(20962,2391,1,1,1,8), -- Blue Wolf Leather Armor
(20962,2392,1,1,1,8), -- Leather Armor of Doom
(20962,4082,1,1,1,1574), -- Blue Wolf Leather Armor Texture
(20962,4083,1,1,1,1574), -- Leather Armor of Doom Design
(20962,1865,1,1,2,79577), -- Varnish
(20962,1870,1,1,2,79577), -- Coal
(20962,1875,1,1,2,5306), -- Stone of Purity
(20962,1879,1,1,2,13263), -- Cokes
(20962,3956,1,1,2,107), -- Recipe: Blessed Spiritshot A
(20962,4040,1,1,2,1592), -- Mold Lubricant
(20962,5230,1,1,2,107), -- Recipe: Mithril Arrow (100%)
(20963,4116,1,1,-1,7834), -- Deadman\'s Glory Stone
(20963,5478,1,1,-1,15075), -- Sealed Dark Crystal Leather Armor Pattern
(20963,5479,1,1,-1,10608), -- Sealed Tallum Leather Armor Pattern
(20963,57,723,1470,0,700000), -- Adena
(20963,5290,1,1,1,12), -- Sealed Dark Crystal Gloves
(20963,5291,1,1,1,12), -- Sealed Dark Crystal Boots
(20963,5295,1,1,1,12), -- Sealed Tallum Gloves
(20963,5296,1,1,1,12), -- Sealed Tallum Boots
(20963,5496,1,1,1,1552), -- Sealed Dark Crystal Boots Lining
(20963,5497,1,1,1,1552), -- Sealed Tallum Boots Lining
(20963,5508,1,1,1,1552), -- Sealed Dark Crystal Gloves Design
(20963,5509,1,1,1,1552), -- Sealed Tallum Gloves Design
(20963,1864,1,1,2,176512), -- Stem
(20963,1869,1,1,2,88256), -- Iron Ore
(20963,1880,1,1,2,8826), -- Steel
(20963,4043,1,1,2,2942), -- Asofe
(20963,4984,1,1,2,250), -- Recipe: Blue Wolf Leather Armor (60%)
(20963,5550,1,1,2,1177), -- Durable Metal Plate
(20964,1874,1,1,-1,122460), -- Oriharukon Ore
(20964,1875,1,1,-1,122460), -- Stone of Purity
(20964,3035,1,1,-1,2449), -- Recipe: Spiritshot A
(20964,57,741,1507,0,700000), -- Adena
(20964,5289,1,1,1,11), -- Sealed Dark Crystal Helmet
(20964,5292,1,1,1,15), -- Sealed Dark Crystal Shield
(20964,5294,1,1,1,11), -- Sealed Tallum Helmet
(20964,5494,1,1,1,1899), -- Sealed Dark Crystal Shield Fragment
(20964,5525,1,1,1,1398), -- Sealed Dark Crystal Helmet Design
(20964,5526,1,1,1,1398), -- Sealed Tallum Helm Design
(20964,1868,1,1,2,180864), -- Thread
(20964,1873,1,1,2,36173), -- Silver Nugget
(20964,1876,1,1,2,18087), -- Mithril Ore
(20964,1895,1,1,2,25838), -- Metallic Fiber
(20964,4042,1,1,2,1508), -- Enria
(20964,4174,1,1,2,1743), -- Recipe: Zubei\'s Boots
(20965,4043,1,1,-1,82345), -- Asofe
(20965,4089,1,1,-1,93362), -- Doom Helmet Pattern
(20965,5482,1,1,-1,32605), -- Sealed Dark Crystalline Leggings Design
(20965,57,994,2030,0,700000), -- Adena
(20965,6323,1,1,1,14), -- Sealed Phoenix Necklace
(20965,6324,1,1,1,19), -- Sealed Phoenix Earring
(20965,6325,1,1,1,28), -- Sealed Phoenix Ring
(20965,6341,1,1,1,3364), -- Sealed Phoenix Earring Gemstone
(20965,6343,1,1,1,2601), -- Sealed Phoenix Necklace Beads
(20965,6345,1,1,1,4653), -- Sealed Phoenix Ring Gemstone
(20965,1864,1,1,2,243235), -- Stem
(20965,1869,1,1,2,121618), -- Iron Ore
(20965,1880,1,1,2,12162), -- Steel
(20965,4043,1,1,2,4054), -- Asofe
(20965,4161,1,1,2,505), -- Recipe: Blue Wolf Tunic
(20965,5550,1,1,2,1622), -- Durable Metal Plate
(20966,1894,1,1,-1,93879), -- Crafted Leather
(20966,4044,1,1,-1,89185), -- Thons
(20966,4085,1,1,-1,46499), -- Tunic of Doom Pattern
(20966,57,1077,2196,0,700000), -- Adena
(20966,5297,1,1,1,8), -- Sealed Dark Crystal Leather Armor
(20966,5298,1,1,1,13), -- Sealed Dark Crystalline Leggings
(20966,5301,1,1,1,6), -- Sealed Tallum Leather Armor
(20966,5478,1,1,1,1108), -- Sealed Dark Crystal Leather Armor Pattern
(20966,5479,1,1,1,780), -- Sealed Tallum Leather Armor Pattern
(20966,5482,1,1,1,1739), -- Sealed Dark Crystalline Leggings Design
(20966,1894,1,1,2,4622), -- Crafted Leather
(20966,4039,1,1,2,4391), -- Mold Glue
(20966,4041,1,1,2,1146), -- Mold Hardener
(20966,4044,1,1,2,4391), -- Thons
(20966,4617,1,1,2,182), -- Greater Dye of Dexterity <Dex+4 Str-4>
(20966,6037,1,1,2,263438), -- Waking Scroll
(20967,4041,1,1,-1,24181), -- Mold Hardener
(20967,5156,1,1,-1,3708), -- Recipe: Soulshot (A) Compressed Package (100%)
(20967,5485,1,1,-1,23384), -- Sealed Tallum Tunic Texture
(20967,57,1116,2286,0,700000), -- Adena
(20967,6323,1,1,1,16), -- Sealed Phoenix Necklace
(20967,6324,1,1,1,21), -- Sealed Phoenix Earring
(20967,6325,1,1,1,32), -- Sealed Phoenix Ring
(20967,6341,1,1,1,3787), -- Sealed Phoenix Earring Gemstone
(20967,6343,1,1,1,2928), -- Sealed Phoenix Necklace Beads
(20967,6345,1,1,1,5238), -- Sealed Phoenix Ring Gemstone
(20967,1867,1,1,2,182539), -- Animal Skin
(20967,1872,1,1,2,182539), -- Animal Bone
(20967,1882,1,1,2,30424), -- Leather
(20967,1894,1,1,2,4804), -- Crafted Leather
(20967,4042,1,1,2,2282), -- Enria
(20967,5001,1,1,2,105), -- Recipe: Lance (60%)
(20968,5480,1,1,-1,12197), -- Sealed Leather Armor of Nightmare Fabric
(20968,5481,1,1,-1,12197), -- Sealed Majestic Leather Armor Fabric
(20968,5486,1,1,-1,16084), -- Sealed Dark Crystal Robe Fabric
(20968,57,1094,2233,0,700000), -- Adena
(20968,5290,1,1,1,18), -- Sealed Dark Crystal Gloves
(20968,5291,1,1,1,18), -- Sealed Dark Crystal Boots
(20968,5295,1,1,1,18), -- Sealed Tallum Gloves
(20968,5296,1,1,1,18), -- Sealed Tallum Boots
(20968,5496,1,1,1,2354), -- Sealed Dark Crystal Boots Lining
(20968,5497,1,1,1,2354), -- Sealed Tallum Boots Lining
(20968,5508,1,1,1,2354), -- Sealed Dark Crystal Gloves Design
(20968,5509,1,1,1,2354), -- Sealed Tallum Gloves Design
(20968,729,1,1,2,12), -- Scroll: Enchant Weapon (Grade A)
(20968,1868,1,1,2,200733), -- Thread
(20968,1873,1,1,2,40147), -- Silver Nugget
(20968,1889,1,1,2,6692), -- Compound Braid
(20968,4044,1,1,2,3346), -- Thons
(20968,5007,1,1,2,77), -- Recipe: Bow of Peril (60%)
(20968,5549,1,1,2,10037), -- Metallic Thread
(20968,6036,1,1,2,3346), -- Greater Magic Haste Potion
(20969,729,1,1,-1,253), -- Scroll: Enchant Weapon (Grade A)
(20969,5161,1,1,-1,3042), -- Recipe: Spiritshot (A) Compressed Package (100%)
(20969,5487,1,1,-1,10272), -- Sealed Robe of Nightmare Fabric
(20969,57,918,1873,0,700000), -- Adena
(20969,5313,1,1,1,10), -- Sealed Gloves of Nightmare
(20969,5314,1,1,1,10), -- Sealed Boots of Nightmare
(20969,5318,1,1,1,10), -- Sealed Majestic Gloves
(20969,5319,1,1,1,10), -- Sealed Majestic Boots
(20969,5502,1,1,1,1423), -- Sealed Boots of Nightmare Lining
(20969,5503,1,1,1,1423), -- Sealed Majestic Boots Lining
(20969,5514,1,1,1,1423), -- Sealed Gloves of Nightmare Design
(20969,5515,1,1,1,1423), -- Sealed Majestic Gloves Design
(20969,1894,1,1,2,4729), -- Crafted Leather
(20969,4039,1,1,2,4493), -- Mold Glue
(20969,4041,1,1,2,1172), -- Mold Hardener
(20969,4044,1,1,2,4493), -- Thons
(20969,4150,1,1,2,2597), -- Recipe: Avadon Gloves
(20970,1895,1,1,-1,537200), -- Metallic Fiber
(20970,4042,1,1,-1,31337), -- Enria
(20970,5489,1,1,-1,24816), -- Sealed Tallum Stockings Fabric
(20970,57,758,1543,0,700000), -- Adena
(20970,5290,1,1,1,12), -- Sealed Dark Crystal Gloves
(20970,5291,1,1,1,12), -- Sealed Dark Crystal Boots
(20970,5295,1,1,1,12), -- Sealed Tallum Gloves
(20970,5296,1,1,1,12), -- Sealed Tallum Boots
(20970,5496,1,1,1,1628), -- Sealed Dark Crystal Boots Lining
(20970,5497,1,1,1,1628), -- Sealed Tallum Boots Lining
(20970,5508,1,1,1,1628), -- Sealed Dark Crystal Gloves Design
(20970,5509,1,1,1,1628), -- Sealed Tallum Gloves Design
(20970,1866,1,1,2,61709), -- Suede
(20970,1871,1,1,2,92564), -- Charcoal
(20970,1885,1,1,2,7714), -- High Grade Suede
(20970,4041,1,1,2,805), -- Mold Hardener
(20970,4198,1,1,2,71), -- Recipe: Bellion Cestus
(20970,5220,1,1,2,3703), -- Metal Hardener
(20970,10609,1,1,3,2463), -- Amulet - Chant of Critical Attack
(20970,10581,1,1,3,2732), -- Forgotten Scroll - Improve Condition
(20970,10584,1,1,3,3460), -- Forgotten Scroll - Improve Movement
(20971,1876,1,1,-1,540396), -- Mithril Ore
(20971,1877,1,1,-1,108079), -- Adamantite Nugget
(20971,1895,1,1,-1,771995), -- Metallic Fiber
(20971,57,1088,2219,0,700000), -- Adena
(20971,5289,1,1,1,16), -- Sealed Dark Crystal Helmet
(20971,5292,1,1,1,22), -- Sealed Dark Crystal Shield
(20971,5294,1,1,1,16), -- Sealed Tallum Helmet
(20971,5494,1,1,1,2794), -- Sealed Dark Crystal Shield Fragment
(20971,5525,1,1,1,2057), -- Sealed Dark Crystal Helmet Design
(20971,5526,1,1,1,2057), -- Sealed Tallum Helm Design
(20971,1868,1,1,2,266041), -- Thread
(20971,1873,1,1,2,53209), -- Silver Nugget
(20971,1876,1,1,2,26604), -- Mithril Ore
(20971,1895,1,1,2,38006), -- Metallic Fiber
(20971,4042,1,1,2,2217), -- Enria
(20971,4981,1,1,2,414), -- Recipe: Blue Wolf Breastplate (60%)
(20972,4077,1,1,-1,85462), -- Doom Shield Fragment
(20972,4087,1,1,-1,44581), -- Stockings of Doom Pattern
(20972,5494,1,1,-1,39900), -- Sealed Dark Crystal Shield Fragment
(20972,57,765,1560,0,700000), -- Adena
(20972,5290,1,1,1,13), -- Sealed Dark Crystal Gloves
(20972,5291,1,1,1,13), -- Sealed Dark Crystal Boots
(20972,5295,1,1,1,13), -- Sealed Tallum Gloves
(20972,5296,1,1,1,13), -- Sealed Tallum Boots
(20972,5496,1,1,1,1645), -- Sealed Dark Crystal Boots Lining
(20972,5497,1,1,1,1645), -- Sealed Tallum Boots Lining
(20972,5508,1,1,1,1645), -- Sealed Dark Crystal Gloves Design
(20972,5509,1,1,1,1645), -- Sealed Tallum Gloves Design
(20972,1867,1,1,2,106892), -- Animal Skin
(20972,1872,1,1,2,106892), -- Animal Bone
(20972,1875,1,1,2,5345), -- Stone of Purity
(20972,1881,1,1,2,10690), -- Coarse Bone Powder
(20972,4041,1,1,2,698), -- Mold Hardener
(20972,4624,1,1,2,111), -- Greater Dye of Wit <Wit+4 Men-4>
(20972,4982,1,1,2,399), -- Recipe: Blue Wolf Gaiters (60%)
(20973,4078,1,1,-1,43112), -- Blue Wolf Breastplate Part
(20973,5166,1,1,-1,3935), -- Recipe: Blessed Spiritshot (A) Compressed Package (100%)
(20973,5496,1,1,-1,69201), -- Sealed Dark Crystal Boots Lining
(20973,57,1187,2425,0,700000), -- Adena
(20973,6323,1,1,1,17), -- Sealed Phoenix Necklace
(20973,6324,1,1,1,23), -- Sealed Phoenix Earring
(20973,6325,1,1,1,34), -- Sealed Phoenix Ring
(20973,6341,1,1,1,4019), -- Sealed Phoenix Earring Gemstone
(20973,6343,1,1,1,3107), -- Sealed Phoenix Necklace Beads
(20973,6345,1,1,1,5559), -- Sealed Phoenix Ring Gemstone
(20973,7656,1,1,2,3758), -- Spellbook - Warrior Servitor
(20973,7657,1,1,2,3758), -- Spellbook - Wizard Servitor
(20973,7658,1,1,2,3758), -- Spellbook - Assassin Servitor
(20973,7659,1,1,2,3758), -- Spellbook - Final Servitor
(20974,4052,1,1,-1,142857), -- Earring of Black Ore Piece
(20974,5230,1,1,-1,5291), -- Recipe: Mithril Arrow (100%)
(20974,57,1605,3252,0,700000), -- Adena
(20974,1871,1,1,2,100000), -- Charcoal
(20974,1866,1,1,2,58824), -- Suede
(20974,1885,1,1,2,5682), -- High Grade Suede
(20974,5220,1,1,2,3311), -- Metal Hardener
(20974,4912,1,1,2,2571), -- Spellbook: Benediction
(20974,4120,1,1,1,2386), -- Bellion Cestus Edge
(20974,8909,1,1,1,2386), -- Blueprint: Summon Swoop Cannon
(20974,4041,1,1,2,551), -- Mold Hardener
(20974,5276,1,1,2,224), -- Recipe: Greater Spiritshot (A) Compressed Package(100%)
(20974,10065,1,1,2,7813), -- Battle Manual: Cure Dark Seed
(20974,10196,1,1,2,6536), -- Battle Manual: Soul Harmony
(20975,4053,1,1,-1,150882), -- Ring of Black Ore Gemstone
(20975,4078,1,1,-1,51418), -- Blue Wolf Breastplate Part
(20975,5230,1,1,-1,4693), -- Recipe: Mithril Arrow (100%)
(20975,57,1424,2883,0,700000), -- Adena
(20975,110,1,1,1,42), -- Doom Shield
(20975,2416,1,1,1,29), -- Blue Wolf Helmet
(20975,2417,1,1,1,29), -- Doom Helmet
(20975,4077,1,1,1,7795), -- Doom Shield Fragment
(20975,4088,1,1,1,6549), -- Blue Wolf Helmet Design
(20975,4089,1,1,1,6549), -- Doom Helmet Pattern
(20975,1830,1,1,2,59417), -- Scroll of Escape: Castle
(20975,1866,1,1,2,99027), -- Suede
(20975,1871,1,1,2,148540), -- Charcoal
(20975,1885,1,1,2,12379), -- High Grade Suede
(20975,4041,1,1,2,1292), -- Mold Hardener
(20975,5220,1,1,2,5942), -- Metal Hardener
(20975,5276,1,1,2,199), -- Recipe: Greater Spiritshot (A) Compressed Package(100%)
(20976,4054,1,1,-1,58705), -- Necklace of Black Ore Beads
(20976,4080,1,1,-1,61307), -- Blue Wolf Gaiters Material
(20976,5230,1,1,-1,3974), -- Recipe: Mithril Arrow (100%)
(20976,57,1206,2442,0,700000), -- Adena
(20976,358,1,1,1,10), -- Blue Wolf Breastplate
(20976,2380,1,1,1,15), -- Blue Wolf Gaiters
(20976,2381,1,1,1,7), -- Doom Plate Armor
(20976,4078,1,1,1,2144), -- Blue Wolf Breastplate Part
(20976,4080,1,1,1,3019), -- Blue Wolf Gaiters Material
(20976,4081,1,1,1,1447), -- Doom Plate Armor Temper
(20976,1343,10,30,2,157211), -- Silver Arrow
(20976,1867,1,1,2,146730), -- Animal Skin
(20976,1872,1,1,2,146730), -- Animal Bone
(20976,1882,1,1,2,24455), -- Leather
(20976,1894,1,1,2,3862), -- Crafted Leather
(20976,4042,1,1,2,1834), -- Enria
(20976,5230,1,1,2,147), -- Recipe: Mithril Arrow (100%)
(20976,5276,1,1,2,147), -- Recipe: Greater Spiritshot (A) Compressed Package(100%)
(20977,947,1,1,-1,1877), -- Scroll: Enchant Weapon (Grade B)
(20977,1876,1,1,-1,938515), -- Mithril Ore
(20977,4052,1,1,-1,166138), -- Earring of Black Ore Piece
(20977,57,1897,3846,0,700000), -- Adena
(20977,864,1,1,1,51), -- Earring of Black Ore
(20977,895,1,1,1,76), -- Ring of Black Ore
(20977,926,1,1,1,38), -- Necklace of Black Ore
(20977,4052,1,1,1,8178), -- Earring of Black Ore Piece
(20977,4053,1,1,1,9901), -- Ring of Black Ore Gemstone
(20977,4054,1,1,1,4550), -- Necklace of Black Ore Beads
(20977,730,1,1,2,166), -- Scroll: Enchant Armor (Grade A)
(20977,1866,1,1,2,132012), -- Suede
(20977,1871,1,1,2,198017), -- Charcoal
(20977,1877,1,1,2,7921), -- Adamantite Nugget
(20977,4040,1,1,2,3961), -- Mold Lubricant
(20977,4041,1,1,2,1722), -- Mold Hardener
(20977,4164,1,1,2,1312), -- Recipe: Stockings of Doom
(20978,4081,1,1,-1,49498), -- Doom Plate Armor Temper
(20978,5230,1,1,-1,6696), -- Recipe: Mithril Arrow (100%)
(20978,57,2034,4113,0,700000), -- Adena
(20978,79,1,1,1,12), -- Sword of Damascus
(20978,4114,1,1,1,3247), -- Sword of Damascus Blade
(20978,1830,1,1,2,84769), -- Scroll of Escape: Castle
(20978,1868,1,3,2,211921), -- Thread
(20978,1873,1,1,2,84769), -- Silver Nugget
(20978,1889,1,1,2,14128), -- Compound Braid
(20978,3956,1,1,2,283), -- Recipe: Blessed Spiritshot A
(20978,4044,1,1,2,7065), -- Thons
(20978,5549,1,1,2,21193), -- Metallic Thread
(20979,4082,1,1,-1,50238), -- Blue Wolf Leather Armor Texture
(20979,5550,1,1,-1,59281), -- Durable Metal Plate
(20979,57,1800,3641,0,700000), -- Adena
(20979,171,1,1,1,4), -- Deadman\'s Glory
(20979,175,1,1,1,4), -- Art of Battle Axe
(20979,210,1,1,1,4), -- Staff of Evil Spirits
(20979,4116,1,1,1,957), -- Deadman\'s Glory Stone
(20979,4117,1,1,1,957), -- Art of Battle Axe Blade
(20979,4118,1,1,1,907), -- Evil Spirit Head
(20979,1343,30,90,2,78173), -- Silver Arrow
(20979,1864,1,3,2,164162), -- Stem
(20979,1869,1,1,2,164162), -- Iron Ore
(20979,1880,1,1,2,16417), -- Steel
(20979,4043,1,1,2,5473), -- Asofe
(20979,5230,1,1,2,219), -- Recipe: Mithril Arrow (100%)
(20979,5276,1,1,2,219), -- Recipe: Greater Spiritshot (A) Compressed Package(100%)
(20979,5550,1,1,2,2189), -- Durable Metal Plate
(20980,4039,1,1,-1,172365), -- Mold Glue
(20980,4041,1,1,-1,44965), -- Mold Hardener
(20980,4085,1,1,-1,89867), -- Tunic of Doom Pattern
(20980,57,2086,4241,0,700000), -- Adena
(20980,5287,1,1,1,11), -- Sealed Dark Crystal breastplate
(20980,5288,1,1,1,18), -- Sealed Dark Crystal Gaiters
(20980,5293,1,1,1,8), -- Sealed Tallum Plate Armor
(20980,5520,1,1,1,1642), -- Sealed Dark Crystal Breastplate Pattern
(20980,5521,1,1,1,1159), -- Sealed Tallum Plate Armor Pattern
(20980,5524,1,1,1,2510), -- Sealed Dark Crystal Gaiters Pattern
(20980,1867,1,3,2,113143), -- Animal Skin
(20980,1869,2,6,2,63643), -- Iron Ore
(20980,1870,2,6,2,50914), -- Coal
(20980,1871,3,9,2,42429), -- Charcoal
(20980,1872,1,3,2,169713), -- Animal Bone
(20980,4985,1,1,2,722), -- Recipe: Leather Armor of Doom (60%)
(20981,4083,1,1,-1,55065), -- Leather Armor of Doom Design
(20981,4085,1,1,-1,84693), -- Tunic of Doom Pattern
(20981,5230,1,1,-1,6498), -- Recipe: Mithril Arrow (100%)
(20981,57,1960,4004,0,700000), -- Adena
(20981,358,1,1,1,15), -- Blue Wolf Breastplate
(20981,2380,1,1,1,24), -- Blue Wolf Gaiters
(20981,2381,1,1,1,11), -- Doom Plate Armor
(20981,4078,1,1,1,3505), -- Blue Wolf Breastplate Part
(20981,4080,1,1,1,4935), -- Blue Wolf Gaiters Material
(20981,4081,1,1,1,2365), -- Doom Plate Armor Temper
(20981,1865,1,1,2,205641), -- Varnish
(20981,1870,1,1,2,205641), -- Coal
(20981,1874,1,1,2,13710), -- Oriharukon Ore
(20981,3956,1,1,2,275), -- Recipe: Blessed Spiritshot A
(20981,4039,1,1,2,6855), -- Mold Glue
(20981,4043,1,1,2,6855), -- Asofe
(20981,5230,1,1,2,275), -- Recipe: Mithril Arrow (100%)
(20982,4084,1,1,-1,78645), -- Blue Wolf Tunic Fabric
(20982,4085,1,1,-1,78645), -- Tunic of Doom Pattern
(20982,5230,1,1,-1,6034), -- Recipe: Mithril Arrow (100%)
(20982,57,1820,3719,0,700000), -- Adena
(20982,2398,1,1,1,14), -- Blue Wolf Tunic
(20982,2399,1,1,1,14), -- Tunic of Doom
(20982,2403,1,1,1,23), -- Blue Wolf Stockings
(20982,2404,1,1,1,23), -- Stockings of Doom
(20982,4084,1,1,1,2903), -- Blue Wolf Tunic Fabric
(20982,4085,1,1,1,2903), -- Tunic of Doom Pattern
(20982,4086,1,1,1,3920), -- Blue Wolf Stockings Pattern
(20982,4087,1,1,1,3920), -- Stockings of Doom Pattern
(20982,1344,20,60,2,104428), -- Mithril Arrow
(20982,1830,1,1,2,66835), -- Scroll of Escape: Castle
(20982,1866,1,1,2,111391), -- Suede
(20982,1871,1,1,2,167086), -- Charcoal
(20982,1877,1,1,2,6684), -- Adamantite Nugget
(20982,4040,1,1,2,3342), -- Mold Lubricant
(20982,4041,1,1,2,1454), -- Mold Hardener
(20982,5276,1,1,2,223), -- Recipe: Greater Spiritshot (A) Compressed Package(100%)
(20983,4080,1,1,-1,139529), -- Blue Wolf Gaiters Material
(20983,5478,1,1,-1,57040), -- Sealed Dark Crystal Leather Armor Pattern
(20983,5549,1,1,-1,678321), -- Metallic Thread
(20983,57,2734,5566,0,700000), -- Adena
(20983,5297,1,1,1,20), -- Sealed Dark Crystal Leather Armor
(20983,5298,1,1,1,31), -- Sealed Dark Crystalline Leggings
(20983,5301,1,1,1,14), -- Sealed Tallum Leather Armor
(20983,5478,1,1,1,2808), -- Sealed Dark Crystal Leather Armor Pattern
(20983,5479,1,1,1,1976), -- Sealed Tallum Leather Armor Pattern
(20983,5482,1,1,1,4408), -- Sealed Dark Crystalline Leggings Design
(20983,730,1,1,2,239), -- Scroll: Enchant Armor (Grade A)
(20983,1867,1,3,2,190825), -- Animal Skin
(20983,1872,1,3,2,127217), -- Animal Bone
(20983,1882,1,1,2,63609), -- Leather
(20983,1894,1,1,2,10044), -- Crafted Leather
(20983,4042,1,1,2,4771), -- Enria
(20983,4199,1,1,2,219), -- Recipe: Bow of Peril
(20984,4041,1,1,-1,54145), -- Mold Hardener
(20984,5478,1,1,-1,52361), -- Sealed Dark Crystal Leather Armor Pattern
(20984,57,2505,5116,0,700000), -- Adena
(20984,5304,1,1,1,18), -- Sealed Tallum Tunic
(20984,5305,1,1,1,29), -- Sealed Tallum Stockings
(20984,5308,1,1,1,13), -- Sealed Dark Crystal Robe
(20984,5485,1,1,1,2578), -- Sealed Tallum Tunic Texture
(20984,5486,1,1,1,1814), -- Sealed Dark Crystal Robe Fabric
(20984,5489,1,1,1,4046), -- Sealed Tallum Stockings Fabric
(20984,729,1,1,2,30), -- Scroll: Enchant Weapon (Grade A)
(20984,1865,1,1,2,262754), -- Varnish
(20984,1870,1,3,2,131377), -- Coal
(20984,1874,1,1,2,17517), -- Oriharukon Ore
(20984,4039,1,1,2,8759), -- Mold Glue
(20984,4043,1,1,2,8759), -- Asofe
(20984,5156,1,1,2,351), -- Recipe: Soulshot (A) Compressed Package (100%)
(20985,1807,1,1,-1,8840), -- Recipe: Soulshot: A-Grade
(20985,3035,1,1,-1,8840), -- Recipe: Spiritshot A
(20985,5479,1,1,-1,39229), -- Sealed Tallum Leather Armor Pattern
(20985,57,2667,5447,0,700000), -- Adena
(20985,6323,1,1,1,38), -- Sealed Phoenix Necklace
(20985,6324,1,1,1,50), -- Sealed Phoenix Earring
(20985,6325,1,1,1,75), -- Sealed Phoenix Ring
(20985,6341,1,1,1,9028), -- Sealed Phoenix Earring Gemstone
(20985,6343,1,1,1,6979), -- Sealed Phoenix Necklace Beads
(20985,6345,1,1,1,12486), -- Sealed Phoenix Ring Gemstone
(20985,1344,20,60,2,174849), -- Mithril Arrow
(20985,1866,1,1,2,186505), -- Suede
(20985,1871,1,3,2,93253), -- Charcoal
(20985,1877,1,1,2,11191), -- Adamantite Nugget
(20985,4040,1,1,2,5596), -- Mold Lubricant
(20985,4041,1,1,2,2433), -- Mold Hardener
(20985,5161,1,1,2,374), -- Recipe: Spiritshot (A) Compressed Package (100%)
(20986,1806,1,1,-1,7272), -- Recipe: Soulshot: B-Grade
(20986,1984,1,1,-1,77945), -- Theca Leather Armor Pattern
(20986,4043,1,1,-1,121204), -- Asofe
(20986,57,1465,2984,0,700000), -- Adena
(20986,2414,1,1,1,126), -- Full Plate Helmet
(20986,2497,1,1,1,180), -- Full Plate Shield
(20986,2959,1,1,1,11610), -- Full Plate Helmet Design
(20986,2966,1,1,1,18366), -- Full Plate Shield Fragment
(20986,1894,1,1,2,6730), -- Crafted Leather
(20986,4039,1,1,2,6394), -- Mold Glue
(20986,4041,1,1,2,1668), -- Mold Hardener
(20986,4044,1,1,2,6394), -- Thons
(20986,4180,1,1,2,21311), -- Recipe: Silver Arrow
(20986,4184,1,1,2,221), -- Recipe: Sprite\'s Staff
(20986,5436,1,1,2,313), -- Recipe: Berserker Blade(100%)
(20987,1864,1,13,-1,943145), -- Stem
(20987,1918,1,1,-1,142963), -- Nassen\'s Earring Gemstone
(20987,4039,1,1,-1,110034), -- Mold Glue
(20987,57,1333,2707,0,700000), -- Adena
(20987,299,1,1,1,7), -- Orcish Poleaxe
(20987,301,1,1,1,9), -- Scorpion
(20987,303,1,1,1,9), -- Widow Maker
(20987,2113,1,1,1,984), -- Scorpion Blade
(20987,2114,1,1,1,984), -- Widowmaker Head
(20987,2122,1,1,1,928), -- Orcish Poleaxe Blade
(20987,1864,1,3,2,152355), -- Stem
(20987,1869,1,1,2,152355), -- Iron Ore
(20987,1878,1,1,2,60942), -- Braided Hemp
(20987,1884,1,1,2,93757), -- Cord
(20987,3034,1,1,2,305), -- Recipe: Spiritshot B
(20987,3955,1,1,2,305), -- Recipe: Blessed Spiritshot B
(20987,4039,1,1,2,5079), -- Mold Glue
(20987,5270,1,1,2,305), -- Recipe: Greater Soulshot (B) Compressed Package(100%)
(20988,1806,1,1,-1,7262), -- Recipe: Soulshot: B-Grade
(20988,1920,1,1,-1,124241), -- Necklace of Binding Chain
(20988,1984,1,1,-1,77834), -- Theca Leather Armor Pattern
(20988,57,1466,2978,0,700000), -- Adena
(20988,400,1,1,1,55), -- Theca Leather Armor
(20988,401,1,1,1,29), -- Drake Leather Armor
(20988,420,1,1,1,87), -- Theca Leather Gaiters
(20988,1984,1,1,1,4791), -- Theca Leather Armor Pattern
(20988,1985,1,1,1,7706), -- Theca Leather Gaiters Pattern
(20988,1987,1,1,1,3410), -- Drake Leather Armor Texture
(20988,1865,1,1,2,167582), -- Varnish
(20988,1870,1,1,2,167582), -- Coal
(20988,1875,1,1,2,11173), -- Stone of Purity
(20988,1879,1,1,2,27931), -- Cokes
(20988,3955,1,1,2,336), -- Recipe: Blessed Spiritshot B
(20988,4040,1,1,2,3352), -- Mold Lubricant
(20988,4127,1,1,2,4148), -- Recipe: Adamantite Ring
(20988,5270,1,1,2,336), -- Recipe: Greater Soulshot (B) Compressed Package(100%)
(20989,1825,1,1,-1,64329), -- Recipe: Oriharukon
(20989,1871,1,1,-1,900608), -- Charcoal
(20989,1902,1,1,-1,91247), -- Elven Earring Beads
(20989,57,381,760,0,700000), -- Adena
(20989,352,1,1,1,52), -- Brigandine Tunic
(20989,1941,1,1,1,3086), -- Brigandine Temper
(20989,2377,1,1,1,83), -- Mithril Scale Gaiters
(20989,2378,1,1,1,83), -- Brigandine Gaiters
(20989,2918,1,1,1,4603), -- Mithril Scale Gaiters Material
(20989,2919,1,1,1,4603), -- Brigandine Gaiters Material
(20989,1866,1,1,2,51728), -- Suede
(20989,1871,1,1,2,77591), -- Charcoal
(20989,1885,1,1,2,6466), -- High Grade Suede
(20989,2146,1,1,2,5543), -- Recipe: Artisan\'s frame
(20989,5220,1,1,2,3104), -- Metal Hardener
(20989,5473,1,1,2,5543), -- Recipe: Durable Metal Plate(100%)
(20990,1882,1,1,-1,189994), -- Leather
(20990,1903,1,1,-1,142615), -- Elven Ring Piece
(20990,2145,1,1,-1,61070), -- Recipe: Mithril Alloy
(20990,57,361,721,0,700000), -- Adena
(20990,437,1,1,1,99), -- Mithril Tunic
(20990,470,1,1,1,158), -- Mithril Stockings
(20990,1944,1,1,1,5636), -- Mithril Tunic Fabric
(20990,1945,1,1,1,8776), -- Mithril Stocking Design
(20990,1341,10,30,2,210457), -- Bone Arrow
(20990,1867,1,1,2,84183), -- Animal Skin
(20990,1872,1,1,2,84183), -- Animal Bone
(20990,1882,1,1,2,14031), -- Leather
(20990,1894,1,1,2,2216), -- Crafted Leather
(20990,2147,1,1,2,4510), -- Recipe: Blacksmith\'s frame
(20990,2194,1,1,2,6456), -- Recipe: Mithril Gloves
(20991,1908,1,1,-1,317634), -- Moonstone Earring Wire
(20991,1909,1,1,-1,452966), -- Aquastone Ring Wire
(20991,2064,1,1,-1,25926), -- Silver Axe Head
(20991,57,1354,2749,0,700000), -- Adena
(20991,354,1,1,1,157), -- Chain Mail Shirt
(20991,381,1,1,1,251), -- Chain Gaiters
(20991,1959,1,1,1,10677), -- Chain Mail Shirt Material
(20991,1960,1,1,1,21718), -- Chain Gaiters Part
(20991,1875,1,1,2,15098), -- Stone of Purity
(20991,1879,1,1,2,37745), -- Cokes
(20991,1885,1,1,2,18873), -- High Grade Suede
(20991,3021,1,1,2,790), -- Recipe: Dwarven War Hammer
(20991,4556,1,1,2,906), -- Greater Dye of Constitution <Con+1 Dex-1>
(20991,5549,1,1,2,22647), -- Metallic Thread
(20991,5550,1,1,2,3020), -- Durable Metal Plate
(20992,1908,1,1,-1,284012), -- Moonstone Earring Wire
(20992,1909,1,1,-1,405019), -- Aquastone Ring Wire
(20992,2163,1,1,-1,153019), -- Recipe: Earring of Protection
(20992,57,1204,2467,0,700000), -- Adena
(20992,852,1,1,1,305), -- Moonstone Earring
(20992,883,1,1,1,459), -- Aquastone Ring
(20992,915,1,1,1,229), -- Aquastone Necklace
(20992,1908,1,1,1,22370), -- Moonstone Earring Wire
(20992,1909,1,1,1,31900), -- Aquastone Ring Wire
(20992,1910,1,1,1,17788), -- Aquastone Necklace Chain
(20992,1868,1,3,2,236242), -- Thread
(20992,1873,1,1,2,94497), -- Silver Nugget
(20992,1889,1,1,2,15750), -- Compound Braid
(20992,2164,1,1,2,18173), -- Recipe: Ring of Protection
(20992,2319,1,1,2,823), -- Recipe: Raid Sword
(20992,5549,1,1,2,23625), -- Metallic Thread
(20993,1864,1,13,-1,909305), -- Stem
(20993,1869,1,7,-1,795642), -- Iron Ore
(20993,2163,1,1,-1,162376), -- Recipe: Earring of Protection
(20993,57,1278,2618,0,700000), -- Adena
(20993,62,1,1,1,133), -- Mithril Boots
(20993,1958,1,1,1,7512), -- Mithril Boots Design
(20993,2429,1,1,1,133), -- Chain Boots
(20993,2430,1,1,1,133), -- Karmian Boots
(20993,2431,1,1,1,133), -- Plated Leather Boots
(20993,2432,1,1,1,133), -- Dwarven Chain Boots
(20993,2433,1,1,1,133), -- Boots of Seal
(20993,2452,1,1,1,133), -- Reinforced Mithril Gloves
(20993,2453,1,1,1,133), -- Chain Gloves
(20993,2454,1,1,1,133), -- Karmian Gloves
(20993,2937,1,1,1,7512), -- Chain Boots Part
(20993,2938,1,1,1,7512), -- Karmian Boots Fabric
(20993,2939,1,1,1,7512), -- Plate Leather Boot Lining
(20993,2940,1,1,1,7512), -- Dwarven Chain Boots Part
(20993,2941,1,1,1,7512), -- Boots of Seal Pattern
(20993,2942,1,1,1,7512), -- Reinforced Mithril Gloves Design
(20993,2943,1,1,1,7512), -- Chain Gloves Design
(20993,2944,1,1,1,7512), -- Karmian Gloves Fabric
(20993,1864,1,3,2,250689), -- Stem
(20993,1869,1,3,2,83563), -- Iron Ore
(20993,1880,1,1,2,25069), -- Steel
(20993,2165,1,1,2,9606), -- Recipe: Necklace of Protection
(20993,2318,1,1,2,874), -- Recipe: Spirit Sword
(20993,5550,1,1,2,3343), -- Durable Metal Plate
(20994,2169,1,1,-1,64202), -- Recipe: Necklace of Binding
(20994,4043,1,1,-1,120913), -- Asofe
(20994,4044,1,1,-1,120913), -- Thons
(20994,57,1464,2975,0,700000), -- Adena
(20994,265,1,1,1,35), -- Fist Blade
(20994,2108,1,1,1,4018), -- Fist Blade Piece
(20994,1894,1,1,2,7520), -- Crafted Leather
(20994,3015,1,1,2,5986), -- Recipe: Drake Leather Gloves
(20994,3016,1,1,2,5986), -- Recipe: Full Plate Gauntlets
(20994,4039,1,1,2,7144), -- Mold Glue
(20994,4041,1,1,2,1864), -- Mold Hardener
(20994,4044,1,1,2,7144), -- Thons
(20994,4186,1,1,2,247), -- Recipe: Sword of Valhalla
(20995,1911,1,1,-1,205015), -- Earring of Protection Gemstone
(20995,1966,1,1,-1,100636), -- Plated Leather Fragment
(20995,2166,1,1,-1,93438), -- Recipe: Earrings of Binding (100%)
(20995,57,1112,2260,0,700000), -- Adena
(20995,500,1,1,1,169), -- Great Helmet
(20995,632,1,1,1,241), -- Knight\'s Shield
(20995,1971,1,1,1,12462), -- Great Helmet Material
(20995,1972,1,1,1,16285), -- Knight\'s Shield Fragment
(20995,2496,1,1,1,261), -- Dwarven Chain Shield
(20995,2947,1,1,1,14540), -- Dwarven Chain Shield Fragment
(20995,1539,1,1,2,38773), -- Greater Healing Potion
(20995,1865,1,1,2,174473), -- Varnish
(20995,1870,1,1,2,174473), -- Coal
(20995,1874,1,1,2,11632), -- Oriharukon Ore
(20995,2222,1,1,2,1091), -- Recipe: Composite Armor
(20995,4039,1,1,2,5816), -- Mold Glue
(20995,4043,1,1,2,5816), -- Asofe
(20996,1864,1,5,-1,927568), -- Stem
(20996,1869,1,3,-1,695676), -- Iron Ore
(20996,1914,1,1,-1,78166), -- Earring of Binding Gemstone
(20996,57,561,1141,0,700000), -- Adena
(20996,265,1,1,1,14), -- Fist Blade
(20996,2108,1,1,1,1541), -- Fist Blade Piece
(20996,1864,1,1,2,164394), -- Stem
(20996,1869,1,1,2,82197), -- Iron Ore
(20996,1878,1,1,2,32879), -- Braided Hemp
(20996,1884,1,1,2,50583), -- Cord
(20996,2169,1,1,2,1455), -- Recipe: Necklace of Binding
(20996,3019,1,1,2,2192), -- Recipe: Full Plate Shield
(20996,4039,1,1,2,2740), -- Mold Glue
(20997,1539,1,1,-1,275438), -- Greater Healing Potion
(20997,1915,1,1,-1,109205), -- Ring of Ages Gemstone
(20997,4601,1,1,-1,2754), -- Greater Dye of Strength <Str+3 Con-3>
(20997,57,501,1017,0,700000), -- Adena
(20997,60,1,1,1,36), -- Composite Armor
(20997,1977,1,1,1,3792), -- Composite Armor Temper
(20997,1868,1,1,2,146448), -- Thread
(20997,1873,1,1,2,29290), -- Silver Nugget
(20997,1876,1,1,2,14645), -- Mithril Ore
(20997,1895,1,1,2,20922), -- Metallic Fiber
(20997,2170,1,1,2,1727), -- Recipe: Nassen\'s Earring
(20997,3012,1,1,2,1367), -- Recipe: Full Plate Helmet
(20997,4042,1,1,2,1221), -- Enria
(20998,1916,1,1,-1,58159), -- Necklace of Mermaid Teardrop
(20998,2169,1,1,-1,24190), -- Recipe: Necklace of Binding
(20998,2170,1,1,-1,32234), -- Recipe: Nassen\'s Earring
(20998,57,554,1119,0,700000), -- Adena
(20998,162,1,1,1,2), -- War Axe
(20998,174,1,1,1,2), -- Nirvana Axe
(20998,196,1,1,1,2), -- Stick of Eternity
(20998,197,1,1,1,2), -- Paradia Staff
(20998,199,1,1,1,2), -- Pa\'agrian Hammer
(20998,200,1,1,1,2), -- Sage\'s Staff
(20998,201,1,1,1,2), -- Club of Nature
(20998,202,1,1,1,2), -- Mace of The Underworld
(20998,2097,1,1,1,190), -- War Axe Blade
(20998,2098,1,1,1,190), -- Nirvana Axe Blade
(20998,2099,1,1,1,200), -- Stick of Eternity Shaft
(20998,2100,1,1,1,200), -- Paradia Staff Head
(20998,2102,1,1,1,192), -- Pa\'agrian Hammer Head
(20998,2103,1,1,1,200), -- Sage\'s Staff Head
(20998,2104,1,1,1,200), -- Club of Nature Head
(20998,2105,1,1,1,190), -- Mace of The Underworld Head
(20998,1832,1,1,2,69778), -- Greater Antidote
(20998,1866,1,1,2,41867), -- Suede
(20998,1871,1,1,2,62800), -- Charcoal
(20998,1877,1,1,2,2513), -- Adamantite Nugget
(20998,2231,1,1,2,271), -- Recipe: Full Plate Armor
(20998,4040,1,1,2,1256), -- Mold Lubricant
(20998,4041,1,1,2,547), -- Mold Hardener
(20998,5155,1,1,2,126), -- Recipe: Soulshot (B) Compressed Package (100%)
(20998,6669,1,1,2,14605), -- Deluxe Chest Key - Grade 5
(20999,1868,1,7,-1,811841), -- Thread
(20999,1873,1,1,-1,649473), -- Silver Nugget
(20999,1918,1,1,-1,70320), -- Nassen\'s Earring Gemstone
(20999,57,656,1332,0,700000), -- Adena
(20999,228,1,1,1,10), -- Crystal Dagger
(20999,2119,1,1,1,1367), -- Crystal Dagger Blade
(20999,1806,1,1,2,150), -- Recipe: Soulshot: B-Grade
(20999,1868,1,1,2,149879), -- Thread
(20999,1873,1,1,2,29976), -- Silver Nugget
(20999,1889,1,1,2,4996), -- Compound Braid
(20999,4044,1,1,2,2498), -- Thons
(20999,5270,1,1,2,150), -- Recipe: Greater Soulshot (B) Compressed Package(100%)
(20999,5280,1,1,2,150), -- Recipe: Greater Blessed Spiritshot (B) Compressed Package(100%)
(20999,5549,1,1,2,7494), -- Metallic Thread
(21000,1865,1,3,-1,711817), -- Varnish
(21000,1918,1,1,-1,61656), -- Nassen\'s Earring Gemstone
(21000,1986,1,1,-1,15043), -- Full Plate Armor Temper
(21000,57,574,1168,0,700000), -- Adena
(21000,299,1,1,1,3), -- Orcish Poleaxe
(21000,301,1,1,1,4), -- Scorpion
(21000,303,1,1,1,4), -- Widow Maker
(21000,2113,1,1,1,425), -- Scorpion Blade
(21000,2114,1,1,1,425), -- Widowmaker Head
(21000,2122,1,1,1,400), -- Orcish Poleaxe Blade
(21000,1865,1,1,2,58406), -- Varnish
(21000,1870,1,1,2,58406), -- Coal
(21000,1875,1,1,2,3894), -- Stone of Purity
(21000,1879,1,1,2,9735), -- Cokes
(21000,4040,1,1,2,1169), -- Mold Lubricant
(21000,4146,1,1,2,375), -- Recipe: Tunic of Zubei
(21000,4182,1,1,2,68), -- Recipe: Great Sword
(21000,5160,1,1,2,117), -- Recipe: Spiritshot (B) Compressed Package (100%)
(21000,5436,1,1,2,96); -- Recipe: Berserker Blade(100%)

INSERT INTO `droplist` VALUES 
(21001,1895,1,1,-1,551315), -- Metallic Fiber
(21001,1988,1,1,-1,37076), -- Divine Tunic Fabric
(21001,4042,1,1,-1,32160), -- Enria
(21001,57,778,1584,0,700000), -- Adena
(21001,286,1,1,1,12), -- Eminence Bow
(21001,2121,1,1,1,1639), -- Eminence Bow Shaft
(21001,1868,1,1,2,142494), -- Thread
(21001,1873,1,1,2,28499), -- Silver Nugget
(21001,1876,1,1,2,14250), -- Mithril Ore
(21001,1895,1,1,2,20357), -- Metallic Fiber
(21001,4042,1,1,2,1188), -- Enria
(21001,4180,1,1,2,7917), -- Recipe: Silver Arrow
(21001,4939,1,1,2,882), -- Recipe: Adamantite Necklace (70%)
(21001,4966,1,1,2,83), -- Recipe: Keshanberk (60%)
(21001,4971,1,1,2,83), -- Recipe: Dark Elven Long Bow (60%)
(21001,5165,1,1,2,143), -- Recipe: Blessed Spiritshot (B) Compressed Package (100%)
(21002,1874,1,1,-1,113674), -- Oriharukon Ore
(21002,2960,1,1,-1,92845), -- Drake Leather Boots Design
(21002,4613,1,1,-1,2352), -- Greater Dye of Strength <Str+4 Con-4>
(21002,57,686,1401,0,700000), -- Adena
(21002,284,1,1,1,6), -- Dark Elven Long Bow
(21002,4112,1,1,1,1427), -- Dark Elven Longbow Shaft
(21002,1867,1,1,2,95936), -- Animal Skin
(21002,1872,1,1,2,95936), -- Animal Bone
(21002,1875,1,1,2,4797), -- Stone of Purity
(21002,1881,1,1,2,9594), -- Coarse Bone Powder
(21002,4041,1,1,2,626), -- Mold Hardener
(21002,4949,1,1,2,462), -- Recipe: Tunic of Zubei (60%)
(21002,4992,1,1,2,896), -- Recipe: Blue Wolf Boots (60%)
(21003,2963,1,1,-1,85150), -- Full Plate Gauntlets Part
(21003,4049,1,1,-1,82024), -- Adamantite Earring Gemstone
(21003,4949,1,1,-1,10024), -- Recipe: Tunic of Zubei (60%)
(21003,57,629,1285,0,700000), -- Adena
(21003,503,1,1,1,15), -- Zubei\'s Helmet
(21003,633,1,1,1,22), -- Zubei\'s Shield
(21003,673,1,1,1,22), -- Avadon Shield
(21003,2415,1,1,1,15), -- Avadon Circlet
(21003,4072,1,1,1,2594), -- Avadon Circlet Pattern
(21003,4101,1,1,1,3348), -- Zubei\'s Shield Fragment
(21003,4102,1,1,1,2594), -- Zubei\'s Helmet Design
(21003,4439,1,1,1,3983), -- Avadon Shield Fragment
(21003,1832,1,1,2,57027), -- Greater Antidote
(21003,1866,1,1,2,34217), -- Suede
(21003,1871,1,1,2,51325), -- Charcoal
(21003,1885,1,1,2,4278), -- High Grade Suede
(21003,4041,1,1,2,447), -- Mold Hardener
(21003,4963,1,1,2,60), -- Recipe: Great Sword (60%)
(21003,4993,1,1,2,639), -- Recipe: Doom Gloves (60%)
(21003,4999,1,1,2,639), -- Recipe: Doom Boots (60%)
(21003,5220,1,1,2,2054), -- Metal Hardener
(21004,1920,1,1,-1,59425), -- Necklace of Binding Chain
(21004,4129,1,1,-1,18795), -- Recipe: Earrings of Black Ore
(21004,4951,1,1,-1,7617), -- Recipe: Avadon Robe (60%)
(21004,57,700,1425,0,700000), -- Adena
(21004,2384,1,1,1,11), -- Zubei\'s Leather Shirt
(21004,2388,1,1,1,18), -- Zubei\'s Leather Gaiters
(21004,2390,1,1,1,8), -- Avadon Leather Armor
(21004,4066,1,1,1,2016), -- Zubei\'s Leather Shirt Fabric
(21004,4067,1,1,1,3060), -- Zubei\'s Leather Gaiter Texture
(21004,4068,1,1,1,1549), -- Avadon Leather Armor Lining
(21004,4911,1,1,2,5067), -- Spellbook: Curse Disease
(21004,4925,1,1,2,5067), -- Amulet: Pa\'agrio\'s Haste
(21004,10047,1,1,2,3247), -- Battle Manual: Annihilation Circle
(21004,6669,1,1,2,39767), -- Deluxe Chest Key - Grade 5
(21005,947,1,1,-1,762), -- Scroll: Enchant Weapon (Grade B)
(21005,1880,1,1,-1,190431), -- Steel
(21005,4050,1,1,-1,117987), -- Adamantite Ring Wire
(21005,57,767,1563,0,700000), -- Adena
(21005,78,1,1,1,3), -- Great Sword
(21005,142,1,1,1,3), -- Keshanberk
(21005,148,1,1,1,3), -- Sword of Valhalla
(21005,4104,1,1,1,537), -- Great Sword Blade
(21005,4107,1,1,1,529), -- Keshanberk Blade
(21005,4108,1,1,1,529), -- Sword of Valhalla Blade
(21005,1868,1,1,2,140627), -- Thread
(21005,1873,1,1,2,28126), -- Silver Nugget
(21005,1876,1,1,2,14063), -- Mithril Ore
(21005,1895,1,1,2,20090), -- Metallic Fiber
(21005,4042,1,1,2,1172), -- Enria
(21005,4129,1,1,2,761), -- Recipe: Earrings of Black Ore
(21005,4167,1,1,2,875), -- Recipe: Blue Wolf Boots
(21005,4197,1,1,2,55), -- Recipe: Demon\'s Sword
(21006,948,1,1,-1,4532), -- Scroll: Enchant Armor (Grade B)
(21006,4066,1,1,-1,42738), -- Zubei\'s Leather Shirt Fabric
(21006,4130,1,1,-1,29428), -- Recipe: Ring of Black Ore
(21006,57,731,1487,0,700000), -- Adena
(21006,357,1,1,1,7), -- Zubei\'s Breastplate
(21006,383,1,1,1,11), -- Zubei\'s Gaiters
(21006,2376,1,1,1,7), -- Avadon Breastplate
(21006,2379,1,1,1,11), -- Avadon Gaiters
(21006,4056,1,1,1,1212), -- Zubei\'s Breastplate Part
(21006,4057,1,1,1,1872), -- Zubei\'s Gaiter Material
(21006,4064,1,1,1,1212), -- Avadon Breastplate Part
(21006,4065,1,1,1,1872), -- Avadon Gaiters Material
(21006,1864,1,1,2,133865), -- Stem
(21006,1869,1,1,2,66933), -- Iron Ore
(21006,1880,1,1,2,6694), -- Steel
(21006,4043,1,1,2,2231), -- Asofe
(21006,4173,1,1,2,833), -- Recipe: Blue Wolf Gloves
(21006,4193,1,1,2,52), -- Recipe: Lance
(21006,5003,1,1,2,52), -- Recipe: Art of Battle Axe (60%)
(21006,5550,1,1,2,893), -- Durable Metal Plate
(21007,948,1,1,-1,4875), -- Scroll: Enchant Armor (Grade B)
(21007,4051,1,1,-1,75618), -- Adamantite Necklace Chain
(21007,4981,1,1,-1,6055), -- Recipe: Blue Wolf Breastplate (60%)
(21007,57,788,1598,0,700000), -- Adena
(21007,91,1,1,1,4), -- Heavy War Axe
(21007,92,1,1,1,4), -- Sprite\'s Staff
(21007,4105,1,1,1,824), -- Heavy War Axe Head
(21007,4106,1,1,1,811), -- Sprite\'s Staff Head
(21007,1832,1,1,2,79991), -- Greater Antidote
(21007,1894,1,1,2,2527), -- Crafted Leather
(21007,4039,1,1,2,2400), -- Mold Glue
(21007,4041,1,1,2,627), -- Mold Hardener
(21007,4044,1,1,2,2400), -- Thons
(21007,4166,1,1,2,595), -- Recipe: Doom Helmet
(21007,4621,1,1,2,100), -- Greater Dye of Mental Strength <Men+4 Int-4>
(21007,4998,1,1,2,896), -- Recipe: Blue Wolf Gloves (60%)
(21008,4052,1,1,-1,88462), -- Earring of Black Ore Piece
(21008,4983,1,1,-1,5305), -- Recipe: Doom Plate Armor (60%)
(21008,5230,1,1,-1,3331), -- Recipe: Mithril Arrow (100%)
(21008,57,1011,2047,0,700000), -- Adena
(21008,601,1,1,1,23), -- Boots of Doom
(21008,2439,1,1,1,23), -- Blue Wolf Boots
(21008,2475,1,1,1,23), -- Doom Gloves
(21008,2487,1,1,1,23), -- Blue Wolf Gloves
(21008,4090,1,1,1,4141), -- Blue Wolf Boots Design
(21008,4091,1,1,1,4141), -- Doom Gloves Part
(21008,4096,1,1,1,4141), -- Blue Wolf Gloves Fabric
(21008,4099,1,1,1,4141), -- Doom Boots Part
(21008,1867,1,1,2,140582), -- Animal Skin
(21008,1872,1,1,2,140582), -- Animal Bone
(21008,1882,1,1,2,23431), -- Leather
(21008,1894,1,1,2,3700), -- Crafted Leather
(21008,4042,1,1,2,1758), -- Enria
(21008,4983,1,1,2,224), -- Recipe: Doom Plate Armor (60%)
(21008,5276,1,1,2,141), -- Recipe: Greater Spiritshot (A) Compressed Package(100%)
(21009,948,1,1,-1,6677), -- Scroll: Enchant Armor (Grade B)
(21009,4052,1,1,-1,94558), -- Earring of Black Ore Piece
(21009,4104,1,1,-1,15284), -- Great Sword Blade
(21009,57,1080,2188,0,700000), -- Adena
(21009,358,1,1,1,9), -- Blue Wolf Breastplate
(21009,2380,1,1,1,14), -- Blue Wolf Gaiters
(21009,2381,1,1,1,6), -- Doom Plate Armor
(21009,4078,1,1,1,1921), -- Blue Wolf Breastplate Part
(21009,4080,1,1,1,2705), -- Blue Wolf Gaiters Material
(21009,4081,1,1,1,1296), -- Doom Plate Armor Temper
(21009,1865,1,1,2,112702), -- Varnish
(21009,1870,1,1,2,112702), -- Coal
(21009,1875,1,1,2,7514), -- Stone of Purity
(21009,1879,1,1,2,18784), -- Cokes
(21009,4040,1,1,2,2254), -- Mold Lubricant
(21009,5004,1,1,2,86), -- Recipe: Staff of Evil Spirits (60%)
(21009,5281,1,1,2,151), -- Recipe: Greater Blessed Spiritshot (A) Compressed Package(100%)
(21010,4621,1,1,-1,2958), -- Greater Dye of Mental Strength <Men+4 Int-4>
(21010,5230,1,1,-1,2859), -- Recipe: Mithril Arrow (100%)
(21010,57,868,1756,0,700000), -- Adena
(21010,268,1,1,1,5), -- Bellion Cestus
(21010,4120,1,1,1,1385), -- Bellion Cestus Edge
(21010,1868,1,1,2,140767), -- Thread
(21010,1873,1,1,2,28154), -- Silver Nugget
(21010,1889,1,1,2,4693), -- Compound Braid
(21010,3956,1,1,2,94), -- Recipe: Blessed Spiritshot A
(21010,4044,1,1,2,2347), -- Thons
(21010,4129,1,1,2,762), -- Recipe: Earrings of Black Ore
(21010,4624,1,1,2,98), -- Greater Dye of Wit <Wit+4 Men-4>
(21010,5549,1,1,2,7039), -- Metallic Thread
(21010,6670,1,1,2,11731), -- Deluxe Chest Key - Grade 6
(21011,1832,1,1,-1,491646), -- Greater Antidote
(21011,1884,1,1,-1,272296), -- Cord
(21011,1900,1,1,-1,48411), -- Enchanted Necklace Chain
(21011,57,187,373,0,700000), -- Adena
(21011,46,1,1,1,484), -- Bronze Helmet
(21011,627,1,1,1,691), -- Aspis
(21011,1061,1,1,2,18319), -- Healing Potion
(21011,1864,1,1,2,60450), -- Stem
(21011,1865,1,1,2,30225), -- Varnish
(21011,1866,1,1,2,20150), -- Suede
(21011,1868,1,1,2,60450), -- Thread
(21011,1873,1,1,2,12090), -- Silver Nugget
(21011,2185,1,1,2,5950), -- Recipe: Iron Boots
(21011,2274,1,1,2,216), -- Recipe: Skull Breaker
(21012,1936,1,1,-1,44548), -- White Tunic Pattern
(21012,2153,1,1,-1,84661), -- Recipe: Tiger\'s Eye Earring
(21012,2185,1,1,-1,107160), -- Recipe: Iron Boots
(21012,57,230,459,0,700000), -- Adena
(21012,275,1,1,1,31), -- Long Bow
(21012,276,1,1,1,31), -- Elven Bow
(21012,2024,1,1,1,1413), -- Elven Bow Shaft
(21012,1833,1,1,2,113326), -- Bandage
(21012,1868,1,1,2,84994), -- Thread
(21012,1873,1,1,2,16999), -- Silver Nugget
(21012,1889,1,1,2,2834), -- Compound Braid
(21012,2264,1,1,2,440), -- Recipe: Two-handed Sword
(21012,2273,1,1,2,304), -- Recipe: Tarbar
(21012,5549,1,1,2,4250), -- Metallic Thread
(21013,1061,1,1,-1,388921), -- Healing Potion
(21013,1933,1,1,-1,75496), -- Dark Stocking Fabric
(21013,2023,1,1,-1,7952), -- Conjuror\'s Staff Head
(21013,57,270,542,0,700000), -- Adena
(21013,848,1,1,1,412), -- Enchanted Earring
(21013,879,1,1,1,618), -- Enchanted Ring
(21013,911,1,1,1,309), -- Enchanted Necklace
(21013,1900,1,1,1,9592), -- Enchanted Necklace Chain
(21013,737,1,1,2,5845), -- Scroll of Resurrection
(21013,1061,1,1,2,35422), -- Healing Potion
(21013,1866,1,1,2,38964), -- Suede
(21013,1871,1,1,2,58446), -- Charcoal
(21013,1877,1,1,2,2338), -- Adamantite Nugget
(21013,2187,1,1,2,2610), -- Recipe: Manticore Skin Shirt
(21014,1865,1,1,-1,662426), -- Varnish
(21014,1958,1,1,-1,59544), -- Mithril Boots Design
(21014,2977,1,1,-1,88678), -- Recipe: Brigandine Boots
(21014,57,280,560,0,700000), -- Adena
(21014,316,1,1,1,25), -- Blood of Saints
(21014,317,1,1,1,25), -- Tome of Blood
(21014,2030,1,1,1,1374), -- Tome of Blood Page
(21014,1865,1,1,2,58702), -- Varnish
(21014,1870,1,1,2,58702), -- Coal
(21014,1875,1,1,2,3914), -- Stone of Purity
(21014,1879,1,1,2,9784), -- Cokes
(21014,2189,1,1,2,2621), -- Recipe: Mithril Tunic
(21014,2286,1,1,2,327), -- Recipe: Bonebreaker
(21015,1869,1,1,-1,675737), -- Iron Ore
(21015,1873,1,1,-1,270295), -- Silver Nugget
(21015,1940,1,1,-1,100856), -- Iron Boots Design
(21015,57,285,569,0,700000), -- Adena
(21015,83,1,1,1,17), -- Sword of Magic
(21015,124,1,1,1,13), -- Two-Handed Sword
(21015,127,1,1,1,13), -- Crimson Sword
(21015,130,1,1,1,13), -- Elven Sword
(21015,144,1,1,1,17), -- Sword of Occult
(21015,2026,1,1,1,721), -- Two-Handed Sword Edge
(21015,1868,1,1,2,143714), -- Thread
(21015,1873,1,1,2,28743), -- Silver Nugget
(21015,1876,1,1,2,14372), -- Mithril Ore
(21015,2280,1,1,2,514), -- Recipe: Crucifix of Blood
(21015,2978,1,1,2,9620), -- Recipe: Elven Mithril Boots
(21016,1870,1,1,-1,723751), -- Coal
(21016,1882,1,1,-1,160833), -- Leather
(21016,1901,1,1,-1,99966), -- Tiger\'s Eye Earring Stone
(21016,57,306,610,0,700000), -- Adena
(21016,58,1,1,1,61), -- Mithril Breastplate
(21016,59,1,1,1,87), -- Mithril Gaiters
(21016,349,1,1,1,61), -- Compound Scale Mail
(21016,350,1,1,1,61), -- Dwarven Scale Mail
(21016,351,1,1,1,55), -- Blast Plate
(21016,378,1,1,1,87), -- Compound Scale Gaiters
(21016,379,1,1,1,87), -- Dwarven Scale Gaiters
(21016,1864,1,1,2,109947), -- Stem
(21016,1869,1,1,2,54974), -- Iron Ore
(21016,1880,1,1,2,5498), -- Steel
(21016,2191,1,1,2,7360), -- Recipe: RIP Gauntlets
(21016,2276,1,1,2,393), -- Recipe: Maingauche
(21016,2293,1,1,2,306), -- Recipe: Glaive
(21016,5550,1,1,2,733), -- Durable Metal Plate
(21017,1806,1,1,-1,2899), -- Recipe: Soulshot: B-Grade
(21017,1880,1,1,-1,144955), -- Steel
(21017,1989,1,1,-1,43688), -- Divine Stocking Pattern
(21017,57,584,1190,0,700000), -- Adena
(21017,400,1,1,1,22), -- Theca Leather Armor
(21017,401,1,1,1,12), -- Drake Leather Armor
(21017,420,1,1,1,35), -- Theca Leather Gaiters
(21017,1984,1,1,1,1913), -- Theca Leather Armor Pattern
(21017,1985,1,1,1,3077), -- Theca Leather Gaiters Pattern
(21017,1987,1,1,1,1362), -- Drake Leather Armor Texture
(21017,1866,1,1,2,44602), -- Suede
(21017,1871,1,1,2,66903), -- Charcoal
(21017,1885,1,1,2,5576), -- High Grade Suede
(21017,4041,1,1,2,582), -- Mold Hardener
(21017,4189,1,1,2,78), -- Recipe: Arthro Nail
(21017,4940,1,1,2,322), -- Recipe: Zubei\'s Breastplate (60%)
(21017,5220,1,1,2,2677), -- Metal Hardener
(21017,5280,1,1,2,134), -- Recipe: Greater Blessed Spiritshot (B) Compressed Package(100%)
(21018,2961,1,1,-1,99537), -- Full Plate Boots Part
(21018,4049,1,1,-1,95882), -- Adamantite Earring Gemstone
(21018,4947,1,1,-1,18787), -- Recipe: Zubei\'s Leather Gaiters (60%)
(21018,57,736,1502,0,700000), -- Adena
(21018,91,1,1,1,4), -- Heavy War Axe
(21018,92,1,1,1,4), -- Sprite\'s Staff
(21018,4105,1,1,1,773), -- Heavy War Axe Head
(21018,4106,1,1,1,760), -- Sprite\'s Staff Head
(21018,1867,1,1,2,102850), -- Animal Skin
(21018,1872,1,1,2,102850), -- Animal Bone
(21018,1875,1,1,2,5143), -- Stone of Purity
(21018,1881,1,1,2,10286), -- Coarse Bone Powder
(21018,4041,1,1,2,671), -- Mold Hardener
(21018,4950,1,1,2,793), -- Recipe: Stockings of Zubei (60%)
(21018,4999,1,1,2,960), -- Recipe: Doom Boots (60%)
(21019,2964,1,1,-1,109806), -- Divine Gloves Pattern
(21019,4129,1,1,-1,21825), -- Recipe: Earrings of Black Ore
(21019,4950,1,1,-1,20726), -- Recipe: Stockings of Zubei (60%)
(21019,57,811,1657,0,700000), -- Adena
(21019,267,1,1,1,7), -- Arthro Nail
(21019,4111,1,1,1,1705), -- Arthro Nail Blade
(21019,1865,1,1,2,74459), -- Varnish
(21019,1870,1,1,2,74459), -- Coal
(21019,1874,1,1,2,4964), -- Oriharukon Ore
(21019,4039,1,1,2,2483), -- Mold Glue
(21019,4043,1,1,2,2483), -- Asofe
(21019,4176,1,1,2,927), -- Recipe: Doom Boots
(21019,4964,1,1,2,86), -- Recipe: Heavy War Axe (60%)
(21019,5003,1,1,2,57), -- Recipe: Art of Battle Axe (60%)
(21020,1987,1,1,-1,34883), -- Drake Leather Armor Texture
(21020,4050,1,1,-1,141660), -- Adamantite Ring Wire
(21020,4952,1,1,-1,29388), -- Recipe: Avadon Circlet (60%)
(21020,57,921,1876,0,700000), -- Adena
(21020,78,1,1,1,3), -- Great Sword
(21020,142,1,1,1,3), -- Keshanberk
(21020,148,1,1,1,3), -- Sword of Valhalla
(21020,4104,1,1,1,645), -- Great Sword Blade
(21020,4107,1,1,1,635), -- Keshanberk Blade
(21020,4108,1,1,1,635), -- Sword of Valhalla Blade
(21020,1832,1,1,2,187604), -- Greater Antidote
(21020,4167,1,1,2,2100), -- Recipe: Blue Wolf Boots
(21020,4915,1,1,2,5003), -- Blueprint: Summon Wild Hog Cannon
(21020,4921,1,1,2,5003), -- Blueprint: Summon Big Boom
(21020,10082,1,1,2,5000), -- Battle Manual: Darkness Protection
(21021,947,1,1,-1,844), -- Scroll: Enchant Weapon (Grade B)
(21021,4040,1,1,-1,42217), -- Mold Lubricant
(21021,4613,1,1,-1,2912), -- Greater Dye of Strength <Str+4 Con-4>
(21021,57,850,1732,0,700000), -- Adena
(21021,284,1,1,1,8), -- Dark Elven Long Bow
(21021,4112,1,1,1,1765), -- Dark Elven Longbow Shaft
(21021,1867,1,1,2,103920), -- Animal Skin
(21021,1869,1,1,2,77940), -- Iron Ore
(21021,1870,1,1,2,77940), -- Coal
(21021,1871,1,1,2,77940), -- Charcoal
(21021,1872,1,1,2,103920), -- Animal Bone
(21021,4130,1,1,2,1266), -- Recipe: Ring of Black Ore
(21021,4998,1,1,2,970), -- Recipe: Blue Wolf Gloves (60%)
(21021,5001,1,1,2,60), -- Recipe: Lance (60%)
(21022,947,1,1,-1,860), -- Scroll: Enchant Weapon (Grade B)
(21022,4049,1,1,-1,112794), -- Adamantite Earring Gemstone
(21022,4613,1,1,-1,2966), -- Greater Dye of Strength <Str+4 Con-4>
(21022,57,868,1764,0,700000), -- Adena
(21022,2397,1,1,1,14), -- Tunic of Zubei
(21022,2402,1,1,1,22), -- Stockings of Zubei
(21022,2406,1,1,1,10), -- Avadon Robe
(21022,4069,1,1,1,2496), -- Tunic of Zubei Fabric
(21022,4070,1,1,1,3789), -- Stockings of Zubei Fabric
(21022,4071,1,1,1,1918), -- Avadon Robe Fabric
(21022,4928,1,1,2,5882), -- Spellbook: Seed of Fire
(21022,4929,1,1,2,5882), -- Spellbook: Seed of Water
(21022,4930,1,1,2,5882), -- Spellbook: Seed of Wind
(21022,10038,1,1,2,4608), -- Battle Manual: Crushing Pain
(21023,1866,1,1,-1,245597), -- Suede
(21023,2019,1,1,-1,7922), -- Trident Edge
(21023,2263,1,1,-1,5720), -- Recipe: Dwarven Trident
(21023,57,160,305,0,700000), -- Adena
(21023,156,1,1,1,34), -- Hand Axe
(21023,167,1,1,1,34), -- Scalpel
(21023,178,1,1,1,34), -- Bone Staff
(21023,1864,1,1,2,68919), -- Stem
(21023,1865,1,1,2,34460), -- Varnish
(21023,1866,1,1,2,22973), -- Suede
(21023,1868,1,1,2,68919), -- Thread
(21023,1873,1,1,2,13784), -- Silver Nugget
(21023,2260,1,1,2,535), -- Recipe: Mace of Judgment
(21024,1899,1,1,-1,60101), -- Necklace of Devotion Chain
(21024,1934,1,1,-1,50280), -- Crafted Leather Gloves Lining
(21024,2178,1,1,-1,61543), -- Recipe: Dark Stockings
(21024,57,166,320,0,700000), -- Adena
(21024,220,1,1,1,106), -- Crafted Dagger
(21024,1864,1,1,2,86350), -- Stem
(21024,1869,1,1,2,43175), -- Iron Ore
(21024,1878,1,1,2,17270), -- Braided Hemp
(21024,1884,1,1,2,26570), -- Cord
(21024,2180,1,1,2,3247), -- Recipe: Scale Mail
(21025,1868,1,1,-1,808633), -- Thread
(21025,1871,1,1,-1,404316), -- Charcoal
(21025,2152,1,1,-1,71182), -- Recipe: Enchanted Necklace
(21025,57,173,339,0,700000), -- Adena
(21025,291,1,1,1,56), -- Trident
(21025,2019,1,1,1,2440), -- Trident Edge
(21025,1864,1,1,2,75639), -- Stem
(21025,1865,1,1,2,37819), -- Varnish
(21025,1866,1,1,2,25213), -- Suede
(21025,1868,1,1,2,75639), -- Thread
(21025,1873,1,1,2,15128), -- Silver Nugget
(21025,2180,1,1,2,2844), -- Recipe: Scale Mail
(21026,1834,1,1,-1,479579), -- Emergency Dressing
(21026,1900,1,1,-1,47223), -- Enchanted Necklace Chain
(21026,2025,1,1,-1,5978), -- Dwarven Trident Edge
(21026,57,183,362,0,700000), -- Adena
(21026,275,1,1,1,25), -- Long Bow
(21026,276,1,1,1,25), -- Elven Bow
(21026,2024,1,1,1,1121), -- Elven Bow Shaft
(21026,737,1,1,2,3370), -- Scroll of Resurrection
(21026,1867,1,1,2,44927), -- Animal Skin
(21026,1872,1,1,2,44927), -- Animal Bone
(21026,1875,1,1,2,2247), -- Stone of Purity
(21026,1881,1,1,2,4493), -- Coarse Bone Powder
(21026,2191,1,1,2,4511), -- Recipe: RIP Gauntlets
(21026,2274,1,1,2,241), -- Recipe: Skull Breaker
(21034,1956,1,1,-1,66832), -- Square Shield Fragment
(21034,2154,1,1,-1,63039), -- Recipe: Elven Earring
(21034,2302,1,1,-1,2571), -- Recipe: Silver Axe
(21034,57,249,497,0,700000), -- Adena
(21034,88,1,1,1,5), -- Morning Star
(21034,90,1,1,1,5), -- Goat Head Staff
(21034,158,1,1,1,5), -- Tarbar
(21034,169,1,1,1,5), -- Skull Breaker
(21034,172,1,1,1,5), -- Heavy Bone Club
(21034,2031,1,1,1,309), -- Morning Star Head
(21034,2032,1,1,1,282), -- Goat Head Staff Head
(21034,2035,1,1,1,309), -- Tarbar Head
(21034,2036,1,1,1,309), -- Skull Breaker Head
(21034,2037,1,1,1,309), -- Heavy Bone Club Head
(21034,1341,10,30,2,126814), -- Bone Arrow
(21034,1874,1,1,2,2537), -- Oriharukon Ore
(21034,1878,1,1,2,15218), -- Braided Hemp
(21034,1884,1,1,2,23412), -- Cord
(21034,1889,1,1,2,2537), -- Compound Braid
(21034,2190,1,1,2,2718), -- Recipe: Mithril Stockings
(21034,2279,1,1,2,272), -- Recipe: War Pick
(21034,5220,1,1,2,1522), -- Metal Hardener
(21035,1873,1,1,-1,593536), -- Silver Nugget
(21035,1905,1,1,-1,144342), -- Omen Beast\'s Eye Earring Gemstone
(21035,1952,1,1,-1,47529), -- Salamander Skin Mail Texture
(21035,57,606,1226,0,700000), -- Adena
(21035,396,1,1,1,174), -- Salamander Skin Mail
(21035,1952,1,1,1,11934), -- Salamander Skin Mail Texture
(21035,1865,1,1,2,82791), -- Varnish
(21035,1870,1,1,2,82791), -- Coal
(21035,1875,1,1,2,5520), -- Stone of Purity
(21035,1879,1,1,2,13799), -- Cokes
(21035,2205,1,1,2,2620), -- Recipe: Chain Gaiters
(21035,2308,1,1,2,362), -- Recipe: Cursed Dagger
(21035,2989,1,1,2,4381), -- Recipe: Chain Hood
(21035,2997,1,1,2,6571), -- Recipe: Karmian Gloves
(21035,6668,1,1,2,29569), -- Deluxe Chest Key - Grade 4
(21036,1895,1,1,-1,534500), -- Metallic Fiber
(21036,2070,1,1,-1,14854), -- Cursed Dagger Blade
(21036,2316,1,1,-1,6518), -- Recipe: Katana
(21036,57,751,1539,0,700000), -- Adena
(21036,354,1,1,1,88), -- Chain Mail Shirt
(21036,381,1,1,1,140), -- Chain Gaiters
(21036,1959,1,1,1,5955), -- Chain Mail Shirt Material
(21036,1960,1,1,1,12113), -- Chain Gaiters Part
(21036,1895,1,1,2,126307), -- Metallic Fiber
(21036,2318,1,1,2,1541), -- Recipe: Spirit Sword
(21037,2166,1,1,-1,65513), -- Recipe: Earrings of Binding (100%)
(21037,4040,1,1,-1,38652), -- Mold Lubricant
(21037,5231,1,1,-1,138044), -- Recipe: Metal Hardener (100%)
(21037,57,778,1587,0,700000), -- Adena
(21037,1126,1,1,1,89), -- Crimson Boots
(21037,1974,1,1,1,6001), -- Crimson Boot Fabric
(21037,2434,1,1,1,89), -- Rind Leather Boots
(21037,2455,1,1,1,96), -- Plated Leather Gloves
(21037,2456,1,1,1,89), -- Dwarven Chain Gloves
(21037,2457,1,1,1,89), -- Gloves of Seal
(21037,2458,1,1,1,89), -- Rind Leather Gloves
(21037,2946,1,1,1,3989), -- Plate Leather Gloves Design
(21037,2948,1,1,1,6001), -- Rind Leather Boot Lining
(21037,2949,1,1,1,6001), -- Dwarven Chain Gloves Design
(21037,2950,1,1,1,6001), -- Gloves of Seal Pattern
(21037,2951,1,1,1,6001), -- Rind Leather Gloves Design
(21037,1895,1,1,2,30582), -- Metallic Fiber
(21037,2225,1,1,2,2327), -- Recipe: Demon\'s Stockings
(21037,2329,1,1,2,249), -- Recipe: Tsurugi
(21037,2344,1,1,2,249), -- Recipe: Grace Dagger
(21037,2345,1,1,2,249), -- Recipe: Dark Screamer
(21037,4040,1,1,2,2141), -- Mold Lubricant
(21037,4042,1,1,2,1784), -- Enria
(21037,4043,1,1,2,3568), -- Asofe
(21038,1911,1,1,-1,142220), -- Earring of Protection Gemstone
(21038,2166,1,1,-1,64819), -- Recipe: Earrings of Binding (100%)
(21038,5231,1,1,-1,136582), -- Recipe: Metal Hardener (100%)
(21038,57,770,1570,0,700000), -- Adena
(21038,500,1,1,1,117), -- Great Helmet
(21038,632,1,1,1,168), -- Knight\'s Shield
(21038,1971,1,1,1,8645), -- Great Helmet Material
(21038,1972,1,1,1,11297), -- Knight\'s Shield Fragment
(21038,2496,1,1,1,182), -- Dwarven Chain Shield
(21038,2947,1,1,1,10087), -- Dwarven Chain Shield Fragment
(21038,4918,1,1,2,17651), -- Spellbook: Summon Kai the Cat
(21038,4919,1,1,2,17651), -- Spellbook: Summon Unicorn Merrow
(21038,10084,1,1,2,11236), -- Battle Manual: Pride Of Kamael
(21038,4920,1,1,2,17651), -- Spellbook: Summon Soulless
(21039,1805,1,1,-1,6613), -- Recipe: Soulshot: C-Grade
(21039,1871,1,5,-1,661279), -- Charcoal
(21039,1905,1,1,-1,192980), -- Omen Beast\'s Eye Earring Gemstone
(21039,57,800,1626,0,700000), -- Adena
(21039,70,1,1,1,28), -- Claymore
(21039,2047,1,1,1,2190), -- Claymore Blade
(21039,2499,1,1,1,28), -- Elven Long Sword
(21039,2967,1,1,1,2160), -- Elven Long Sword Blade
(21039,1866,1,1,2,110689), -- Suede
(21039,1871,1,1,2,166033), -- Charcoal
(21039,1877,1,1,2,6642), -- Adamantite Nugget
(21039,2162,1,1,2,8021), -- Recipe: Aquastone Necklace
(21039,2312,1,1,2,725), -- Recipe: Crystallized Ice Bow
(21039,5159,1,1,2,554), -- Recipe: Spiritshot (C) Compressed Package (100%)
(21040,1875,1,1,-1,204167), -- Stone of Purity
(21040,1911,1,1,-1,227781), -- Earring of Protection Gemstone
(21040,1967,1,1,-1,167031), -- Plated Leather Gaiters Material
(21040,57,1233,2515,0,700000), -- Adena
(21040,195,1,1,1,24), -- Cursed Staff
(21040,2082,1,1,1,2391), -- Cursed Staff Head
(21040,2502,1,1,1,24), -- Dwarven War Hammer
(21040,2968,1,1,1,2289), -- Dwarven Warhammer Head
(21040,952,1,1,2,2585), -- Scroll: Enchant Armor (Grade C)
(21040,1867,1,1,2,258463), -- Animal Skin
(21040,1872,1,3,2,129232), -- Animal Bone
(21040,1875,1,1,2,12924), -- Stone of Purity
(21040,1881,1,1,2,25847), -- Coarse Bone Powder
(21040,2224,1,1,2,2635), -- Recipe: Demon\'s Tunic
(21040,4041,1,1,2,1686), -- Mold Hardener
(21058,4049,1,1,-1,256419), -- Adamantite Earring Gemstone
(21058,4129,1,1,-1,52907), -- Recipe: Earrings of Black Ore
(21058,4617,1,1,-1,6743), -- Greater Dye of Dexterity <Dex+4 Str-4>
(21058,57,1972,4009,0,700000), -- Adena
(21058,78,1,1,1,6), -- Great Sword
(21058,142,1,1,1,6), -- Keshanberk
(21058,148,1,1,1,6), -- Sword of Valhalla
(21058,4104,1,1,1,1378), -- Great Sword Blade
(21058,4107,1,1,1,1356), -- Keshanberk Blade
(21058,4108,1,1,1,1356), -- Sword of Valhalla Blade
(21058,1895,1,1,2,58940), -- Metallic Fiber
(21058,4040,1,1,2,4126), -- Mold Lubricant
(21058,4042,1,1,2,3439), -- Enria
(21058,4043,1,1,2,6877), -- Asofe
(21058,4163,1,1,2,1367), -- Recipe: Blue Wolf Stockings
(21058,4195,1,1,2,158), -- Recipe: Art of Battle Axe
(21058,4999,1,1,2,2566), -- Recipe: Doom Boots (60%)
(21059,4049,1,1,-1,219194), -- Adamantite Earring Gemstone
(21059,4129,1,1,-1,45227), -- Recipe: Earrings of Black Ore
(21059,4130,1,1,-1,67840), -- Recipe: Ring of Black Ore
(21059,57,1683,3430,0,700000), -- Adena
(21059,284,1,1,1,15), -- Dark Elven Long Bow
(21059,4112,1,1,1,3495), -- Dark Elven Longbow Shaft
(21059,1864,1,3,2,154300), -- Stem
(21059,1869,1,1,2,154300), -- Iron Ore
(21059,1878,1,1,2,61720), -- Braided Hemp
(21059,1884,1,1,2,94954), -- Cord
(21059,4039,1,1,2,5144), -- Mold Glue
(21059,4154,1,1,2,1827), -- Recipe: Doom Shield
(21059,4194,1,1,2,118), -- Recipe: Deadman\'s Glory
(21059,4198,1,1,2,118), -- Recipe: Bellion Cestus
(21060,947,1,1,-1,1672), -- Scroll: Enchant Weapon (Grade B)
(21060,1865,1,9,-1,835788), -- Varnish
(21060,4050,1,1,-1,258918), -- Adamantite Ring Wire
(21060,57,1683,3430,0,700000), -- Adena
(21060,229,1,1,1,8), -- Kris
(21060,243,1,1,1,8), -- Hell Knife
(21060,4109,1,1,1,1739), -- Kris Edge
(21060,4110,1,1,1,1739), -- Hell Knife Edge
(21060,1343,20,60,2,125960), -- Silver Arrow
(21060,1865,1,3,2,58781), -- Varnish
(21060,1870,1,1,2,176343), -- Coal
(21060,1875,1,1,2,11756), -- Stone of Purity
(21060,1879,1,1,2,29391), -- Cokes
(21060,4040,1,1,2,3527), -- Mold Lubricant
(21060,4155,1,1,2,548), -- Recipe: Blue Wolf Breastplate
(21061,1895,1,5,-1,790309), -- Metallic Fiber
(21061,5478,1,1,-1,69780), -- Sealed Dark Crystal Leather Armor Pattern
(21061,57,3350,6803,0,700000), -- Adena
(21061,5287,1,1,1,18), -- Sealed Dark Crystal breastplate
(21061,5288,1,1,1,29), -- Sealed Dark Crystal Gaiters
(21061,5293,1,1,1,13), -- Sealed Tallum Plate Armor
(21061,5520,1,1,1,2635), -- Sealed Dark Crystal Breastplate Pattern
(21061,5521,1,1,1,1860), -- Sealed Tallum Plate Armor Pattern
(21061,5524,1,1,1,4028), -- Sealed Dark Crystal Gaiters Pattern
(21061,730,1,1,2,292), -- Scroll: Enchant Armor (Grade A)
(21061,1868,3,9,2,116723), -- Thread
(21061,1873,1,1,2,140068), -- Silver Nugget
(21061,1876,1,1,2,70034), -- Mithril Ore
(21061,1895,1,1,2,100049), -- Metallic Fiber
(21061,4042,1,1,2,5837), -- Enria
(21061,5000,1,1,2,268), -- Recipe: Sword of Damascus (60%)
(21063,1807,1,1,-1,23854), -- Recipe: Soulshot: A-Grade
(21063,5220,1,1,-1,715633), -- Metal Hardener
(21063,5478,1,1,-1,150444), -- Sealed Dark Crystal Leather Armor Pattern
(21063,57,7216,14682,0,700000), -- Adena
(21063,5287,1,1,1,39), -- Sealed Dark Crystal breastplate
(21063,5288,1,1,1,61), -- Sealed Dark Crystal Gaiters
(21063,5293,1,1,1,27), -- Sealed Tallum Plate Armor
(21063,5520,1,1,1,5681), -- Sealed Dark Crystal Breastplate Pattern
(21063,5521,1,1,1,4009), -- Sealed Tallum Plate Armor Pattern
(21063,5524,1,1,1,8683), -- Sealed Dark Crystal Gaiters Pattern
(21063,729,1,1,2,85), -- Scroll: Enchant Weapon (Grade A)
(21063,1864,36,108,2,20971), -- Stem
(21063,1865,2,6,2,150992), -- Varnish
(21063,1866,3,9,2,83885), -- Suede
(21063,1868,10,30,2,71901), -- Thread
(21063,1873,4,12,2,37748), -- Silver Nugget
(21063,5281,1,1,2,1007), -- Recipe: Greater Blessed Spiritshot (A) Compressed Package(100%)
(21064,4119,1,1,-1,40287), -- Demon\'s Sword Edge
(21064,5230,1,1,-1,12272), -- Recipe: Mithril Arrow (100%)
(21064,5479,1,1,-1,54461), -- Sealed Tallum Leather Armor Pattern
(21064,57,3706,7555,0,700000), -- Adena
(21064,5287,1,1,1,20), -- Sealed Dark Crystal breastplate
(21064,5288,1,1,1,32), -- Sealed Dark Crystal Gaiters
(21064,5293,1,1,1,14), -- Sealed Tallum Plate Armor
(21064,5520,1,1,1,2923), -- Sealed Dark Crystal Breastplate Pattern
(21064,5521,1,1,1,2063), -- Sealed Tallum Plate Armor Pattern
(21064,5524,1,1,1,4467), -- Sealed Dark Crystal Gaiters Pattern
(21064,1344,40,120,2,106200), -- Mithril Arrow
(21064,1867,1,3,2,151039), -- Animal Skin
(21064,1872,5,15,2,45312), -- Animal Bone
(21064,1875,1,1,2,22656), -- Stone of Purity
(21064,1881,1,1,2,45312), -- Coarse Bone Powder
(21064,4041,1,1,2,2955), -- Mold Hardener
(21064,4130,1,1,2,5517), -- Recipe: Ring of Black Ore
(21064,4403,1,1,2,680), -- Red Dimensional Stone
(21065,1807,1,1,-1,13828), -- Recipe: Soulshot: A-Grade
(21065,4120,1,1,-1,45319), -- Bellion Cestus Edge
(21065,57,4173,8520,0,700000), -- Adena
(21065,5290,1,1,1,67), -- Sealed Dark Crystal Gloves
(21065,5291,1,1,1,67), -- Sealed Dark Crystal Boots
(21065,5295,1,1,1,67), -- Sealed Tallum Gloves
(21065,5296,1,1,1,67), -- Sealed Tallum Boots
(21065,5496,1,1,1,8979), -- Sealed Dark Crystal Boots Lining
(21065,5497,1,1,1,8979), -- Sealed Tallum Boots Lining
(21065,5508,1,1,1,8979), -- Sealed Dark Crystal Gloves Design
(21065,5509,1,1,1,8979), -- Sealed Tallum Gloves Design
(21065,1867,1,3,2,194505), -- Animal Skin
(21065,1872,4,12,2,72940), -- Animal Bone
(21065,1875,1,1,2,29176), -- Stone of Purity
(21065,1881,1,1,2,58352), -- Coarse Bone Powder
(21065,4041,1,1,2,3806), -- Mold Hardener
(21065,4164,1,1,2,2899), -- Recipe: Stockings of Doom
(21065,4401,1,1,2,875), -- Green Dimensional Stone
(21066,4081,1,1,-1,102859), -- Doom Plate Armor Temper
(21066,5230,1,1,-1,13915), -- Recipe: Mithril Arrow (100%)
(21066,5482,1,1,-1,137743), -- Sealed Dark Crystalline Leggings Design
(21066,57,4206,8563,0,700000), -- Adena
(21066,5289,1,1,1,60), -- Sealed Dark Crystal Helmet
(21066,5292,1,1,1,85), -- Sealed Dark Crystal Shield
(21066,5294,1,1,1,60), -- Sealed Tallum Helmet
(21066,5494,1,1,1,10790), -- Sealed Dark Crystal Shield Fragment
(21066,5525,1,1,1,7942), -- Sealed Dark Crystal Helmet Design
(21066,5526,1,1,1,7942), -- Sealed Tallum Helm Design
(21066,729,1,1,2,43), -- Scroll: Enchant Weapon (Grade A)
(21066,1868,3,9,2,128444), -- Thread
(21066,1873,1,1,2,154133), -- Silver Nugget
(21066,1889,1,1,2,25689), -- Compound Braid
(21066,4044,1,1,2,12845), -- Thons
(21066,4613,1,1,2,532), -- Greater Dye of Strength <Str+4 Con-4>
(21066,5549,1,1,2,38534), -- Metallic Thread
(21066,6671,1,1,2,42815), -- Deluxe Chest Key - Grade 7
(21068,3035,1,1,-1,32712), -- Recipe: Spiritshot A
(21068,5479,1,1,-1,145173), -- Sealed Tallum Leather Armor Pattern
(21068,5485,1,1,-1,206309), -- Sealed Tallum Tunic Texture
(21068,57,9880,20139,0,700000), -- Adena
(21068,5287,1,1,1,53), -- Sealed Dark Crystal breastplate
(21068,5288,1,1,1,84), -- Sealed Dark Crystal Gaiters
(21068,5293,1,1,1,36), -- Sealed Tallum Plate Armor
(21068,5520,1,1,1,7790), -- Sealed Dark Crystal Breastplate Pattern
(21068,5521,1,1,1,5497), -- Sealed Tallum Plate Armor Pattern
(21068,5524,1,1,1,11907), -- Sealed Dark Crystal Gaiters Pattern
(21068,729,1,1,2,115), -- Scroll: Enchant Weapon (Grade A)
(21068,1867,12,36,2,57517), -- Animal Skin
(21068,1869,18,54,2,28759), -- Iron Ore
(21068,1870,25,75,2,20706), -- Coal
(21068,1871,3,9,2,172548), -- Charcoal
(21068,1872,7,21,2,98599), -- Animal Bone
(21068,4402,1,1,2,2071), -- Blue Dimensional Stone
(21069,3035,1,1,-1,17599), -- Recipe: Spiritshot A
(21069,4041,1,1,-1,114774), -- Mold Hardener
(21069,4080,1,1,-1,271501), -- Blue Wolf Gaiters Material
(21069,57,5315,10834,0,700000), -- Adena
(21069,5290,1,1,1,85), -- Sealed Dark Crystal Gloves
(21069,5291,1,1,1,85), -- Sealed Dark Crystal Boots
(21069,5295,1,1,1,85), -- Sealed Tallum Gloves
(21069,5296,1,1,1,85), -- Sealed Tallum Boots
(21069,5496,1,1,1,11427), -- Sealed Dark Crystal Boots Lining
(21069,5497,1,1,1,11427), -- Sealed Tallum Boots Lining
(21069,5508,1,1,1,11427), -- Sealed Dark Crystal Gloves Design
(21069,5509,1,1,1,11427), -- Sealed Tallum Gloves Design
(21069,729,1,1,2,55), -- Scroll: Enchant Weapon (Grade A)
(21069,1866,2,6,2,64980), -- Suede
(21069,1871,1,3,2,162450), -- Charcoal
(21069,1877,1,1,2,19494), -- Adamantite Nugget
(21069,4040,1,1,2,9748), -- Mold Lubricant
(21069,4041,1,1,2,4238), -- Mold Hardener
(21069,4619,1,1,2,673), -- Greater Dye of Intelligence <Int+4 Men-4>
(21069,6037,4,12,2,121837), -- Waking Scroll
(21071,5156,1,1,-1,34020), -- Recipe: Soulshot (A) Compressed Package (100%)
(21071,5486,1,1,-1,150978), -- Sealed Dark Crystal Robe Fabric
(21071,5489,1,1,-1,336768), -- Sealed Tallum Stockings Fabric
(21071,57,10270,20955,0,700000), -- Adena
(21071,5297,1,1,1,73), -- Sealed Dark Crystal Leather Armor
(21071,5298,1,1,1,116), -- Sealed Dark Crystalline Leggings
(21071,5301,1,1,1,50), -- Sealed Tallum Leather Armor
(21071,5478,1,1,1,10562), -- Sealed Dark Crystal Leather Armor Pattern
(21071,5479,1,1,1,7432), -- Sealed Tallum Leather Armor Pattern
(21071,5482,1,1,1,16578), -- Sealed Dark Crystalline Leggings Design
(21071,729,1,1,2,140), -- Scroll: Enchant Weapon (Grade A)
(21071,1894,1,1,2,44075), -- Crafted Leather
(21071,4039,1,1,2,41872), -- Mold Glue
(21071,4041,1,1,2,10923), -- Mold Hardener
(21071,4044,1,1,2,41872), -- Thons
(21071,4403,1,1,2,2513), -- Red Dimensional Stone
(21072,4083,1,1,-1,122362), -- Leather Armor of Doom Design
(21072,5161,1,1,-1,14439), -- Recipe: Spiritshot (A) Compressed Package (100%)
(21072,5230,1,1,-1,14439), -- Recipe: Mithril Arrow (100%)
(21072,57,4359,8894,0,700000), -- Adena
(21072,5289,1,1,1,62), -- Sealed Dark Crystal Helmet
(21072,5292,1,1,1,88), -- Sealed Dark Crystal Shield
(21072,5294,1,1,1,62), -- Sealed Tallum Helmet
(21072,5494,1,1,1,11196), -- Sealed Dark Crystal Shield Fragment
(21072,5525,1,1,1,8241), -- Sealed Dark Crystal Helmet Design
(21072,5526,1,1,1,8241), -- Sealed Tallum Helm Design
(21072,1868,3,9,2,152321), -- Thread
(21072,1873,1,1,2,182786), -- Silver Nugget
(21072,1889,1,1,2,30465), -- Compound Braid
(21072,4044,1,1,2,15232), -- Thons
(21072,4403,1,1,2,914), -- Red Dimensional Stone
(21072,4984,1,1,2,1295), -- Recipe: Blue Wolf Leather Armor (60%)
(21072,5549,1,1,2,45697), -- Metallic Thread
(21073,4052,1,1,-1,167558), -- Earring of Black Ore Piece
(21073,5230,1,1,-1,6310), -- Recipe: Mithril Arrow (100%)
(21073,57,1916,3876,0,700000), -- Adena
(21073,287,1,1,1,11), -- Bow of Peril
(21073,4121,1,1,1,3045), -- Bow of Peril Shaft
(21073,1830,1,1,2,79884), -- Scroll of Escape: Castle
(21073,1864,1,3,2,199709), -- Stem
(21073,1869,1,3,2,66570), -- Iron Ore
(21073,1880,1,1,2,19971), -- Steel
(21073,4043,1,1,2,6657), -- Asofe
(21073,5276,1,1,2,267), -- Recipe: Greater Spiritshot (A) Compressed Package(100%)
(21073,5550,1,1,2,2663), -- Durable Metal Plate
(21074,1874,1,1,-1,411554), -- Oriharukon Ore
(21074,5478,1,1,-1,51911), -- Sealed Dark Crystal Leather Armor Pattern
(21074,5482,1,1,-1,81480), -- Sealed Dark Crystalline Leggings Design
(21074,57,2484,5072,0,700000), -- Adena
(21074,5290,1,1,1,40), -- Sealed Dark Crystal Gloves
(21074,5291,1,1,1,40), -- Sealed Dark Crystal Boots
(21074,5295,1,1,1,40), -- Sealed Tallum Gloves
(21074,5296,1,1,1,40), -- Sealed Tallum Boots
(21074,5496,1,1,1,5345), -- Sealed Dark Crystal Boots Lining
(21074,5497,1,1,1,5345), -- Sealed Tallum Boots Lining
(21074,5508,1,1,1,5345), -- Sealed Dark Crystal Gloves Design
(21074,5509,1,1,1,5345), -- Sealed Tallum Gloves Design
(21074,730,1,1,2,218), -- Scroll: Enchant Armor (Grade A)
(21074,1865,1,1,2,260500), -- Varnish
(21074,1870,1,3,2,130250), -- Coal
(21074,1874,1,1,2,17367), -- Oriharukon Ore
(21074,4039,1,1,2,8684), -- Mold Glue
(21074,4043,1,1,2,8684), -- Asofe
(21074,5166,1,1,2,348), -- Recipe: Blessed Spiritshot (A) Compressed Package (100%)
(21075,4041,1,1,-1,38815), -- Mold Hardener
(21075,4052,1,1,-1,158037), -- Earring of Black Ore Piece
(21075,4616,1,1,-1,6157), -- Greater Dye of Constitution <Con+4 Dex-4>
(21075,57,1806,3656,0,700000), -- Adena
(21075,601,1,1,1,41), -- Boots of Doom
(21075,2439,1,1,1,41), -- Blue Wolf Boots
(21075,2475,1,1,1,41), -- Doom Gloves
(21075,2487,1,1,1,41), -- Blue Wolf Gloves
(21075,4090,1,1,1,7398), -- Blue Wolf Boots Design
(21075,4091,1,1,1,7398), -- Doom Gloves Part
(21075,4096,1,1,1,7398), -- Blue Wolf Gloves Fabric
(21075,4099,1,1,1,7398), -- Doom Boots Part
(21075,1866,1,1,2,125574), -- Suede
(21075,1871,1,1,2,188361), -- Charcoal
(21075,1877,1,1,2,7535), -- Adamantite Nugget
(21075,4040,1,1,2,3768), -- Mold Lubricant
(21075,4041,1,1,2,1638), -- Mold Hardener
(21075,5005,1,1,2,144), -- Recipe: Demon\'s Sword (60%)
(21075,5276,1,1,2,252), -- Recipe: Greater Spiritshot (A) Compressed Package(100%)
(21076,4052,1,1,-1,155045), -- Earring of Black Ore Piece
(21076,4053,1,1,-1,187709), -- Ring of Black Ore Gemstone
(21076,5230,1,1,-1,5839), -- Recipe: Mithril Arrow (100%)
(21076,57,1771,3588,0,700000), -- Adena
(21076,2398,1,1,1,14), -- Blue Wolf Tunic
(21076,2399,1,1,1,14), -- Tunic of Doom
(21076,2403,1,1,1,22), -- Blue Wolf Stockings
(21076,2404,1,1,1,22), -- Stockings of Doom
(21076,4084,1,1,1,2809), -- Blue Wolf Tunic Fabric
(21076,4085,1,1,1,2809), -- Tunic of Doom Pattern
(21076,4086,1,1,1,3793), -- Blue Wolf Stockings Pattern
(21076,4087,1,1,1,3793), -- Stockings of Doom Pattern
(21076,1830,1,1,2,86238), -- Scroll of Escape: Castle
(21076,1866,1,1,2,143729), -- Suede
(21076,1871,1,1,2,215594), -- Charcoal
(21076,1877,1,1,2,8624), -- Adamantite Nugget
(21076,4040,1,1,2,4312), -- Mold Lubricant
(21076,4041,1,1,2,1875), -- Mold Hardener
(21077,4041,1,1,-1,36223), -- Mold Hardener
(21077,4054,1,1,-1,82050), -- Necklace of Black Ore Beads
(21077,5230,1,1,-1,5554), -- Recipe: Mithril Arrow (100%)
(21077,57,1685,3413,0,700000), -- Adena
(21077,864,1,1,1,45), -- Earring of Black Ore
(21077,895,1,1,1,67), -- Ring of Black Ore
(21077,926,1,1,1,34), -- Necklace of Black Ore
(21077,4052,1,1,1,7260), -- Earring of Black Ore Piece
(21077,4053,1,1,1,8790), -- Ring of Black Ore Gemstone
(21077,4054,1,1,1,4039), -- Necklace of Black Ore Beads
(21077,1343,20,60,2,109866), -- Silver Arrow
(21077,1867,1,1,2,205081), -- Animal Skin
(21077,1872,1,3,2,68361), -- Animal Bone
(21077,1875,1,1,2,10255), -- Stone of Purity
(21077,1881,1,1,2,20509), -- Coarse Bone Powder
(21077,4041,1,1,2,1338), -- Mold Hardener
(21077,5230,1,1,2,205), -- Recipe: Mithril Arrow (100%)
(21077,5276,1,1,2,205), -- Recipe: Greater Spiritshot (A) Compressed Package(100%)
(21078,3956,1,1,-1,7360), -- Recipe: Blessed Spiritshot A
(21078,4040,1,1,-1,110398), -- Mold Lubricant
(21078,5485,1,1,-1,46417), -- Sealed Tallum Tunic Texture
(21078,57,2226,4530,0,700000), -- Adena
(21078,5289,1,1,1,32), -- Sealed Dark Crystal Helmet
(21078,5292,1,1,1,45), -- Sealed Dark Crystal Shield
(21078,5294,1,1,1,32), -- Sealed Tallum Helmet
(21078,5494,1,1,1,5707), -- Sealed Dark Crystal Shield Fragment
(21078,5525,1,1,1,4201), -- Sealed Dark Crystal Helmet Design
(21078,5526,1,1,1,4201), -- Sealed Tallum Helm Design
(21078,1868,3,9,2,90583), -- Thread
(21078,1873,1,1,2,108700), -- Silver Nugget
(21078,1876,1,1,2,54350), -- Mithril Ore
(21078,1895,1,1,2,77643), -- Metallic Fiber
(21078,4042,1,1,2,4529), -- Enria
(21078,4175,1,1,2,5236), -- Recipe: Avadon Boots
(21079,1895,1,3,-1,750339), -- Metallic Fiber
(21079,4042,1,1,-1,87540), -- Enria
(21079,5478,1,1,-1,44167), -- Sealed Dark Crystal Leather Armor Pattern
(21079,57,2121,4306,0,700000), -- Adena
(21079,5304,1,1,1,15), -- Sealed Tallum Tunic
(21079,5305,1,1,1,24), -- Sealed Tallum Stockings
(21079,5308,1,1,1,11), -- Sealed Dark Crystal Robe
(21079,5485,1,1,1,2175), -- Sealed Tallum Tunic Texture
(21079,5486,1,1,1,1530), -- Sealed Dark Crystal Robe Fabric
(21079,5489,1,1,1,3413), -- Sealed Tallum Stockings Fabric
(21079,730,1,1,2,185), -- Scroll: Enchant Armor (Grade A)
(21079,1868,1,3,2,221639), -- Thread
(21079,1873,1,1,2,88656), -- Silver Nugget
(21079,1876,1,1,2,44328), -- Mithril Ore
(21079,1895,1,1,2,63326), -- Metallic Fiber
(21079,4042,1,1,2,3694), -- Enria
(21079,5161,1,1,2,296), -- Recipe: Spiritshot (A) Compressed Package (100%)
(21080,1807,1,1,-1,6473), -- Recipe: Soulshot: A-Grade
(21080,3035,1,1,-1,6473), -- Recipe: Spiritshot A
(21080,5479,1,1,-1,28725), -- Sealed Tallum Leather Armor Pattern
(21080,57,1960,3980,0,700000), -- Adena
(21080,6323,1,1,1,28), -- Sealed Phoenix Necklace
(21080,6324,1,1,1,37), -- Sealed Phoenix Earring
(21080,6325,1,1,1,55), -- Sealed Phoenix Ring
(21080,6341,1,1,1,6611), -- Sealed Phoenix Earring Gemstone
(21080,6343,1,1,1,5110), -- Sealed Phoenix Necklace Beads
(21080,6345,1,1,1,9143), -- Sealed Phoenix Ring Gemstone
(21080,1864,3,9,2,68284), -- Stem
(21080,1869,1,1,2,204850), -- Iron Ore
(21080,1878,1,1,2,81941), -- Braided Hemp
(21080,1884,1,1,2,126062), -- Cord
(21080,4039,1,1,2,6829), -- Mold Glue
(21080,5166,1,1,2,274), -- Recipe: Blessed Spiritshot (A) Compressed Package (100%)
(21080,6036,1,1,2,6828), -- Greater Magic Haste Potion
(21081,4119,1,1,-1,26946), -- Demon\'s Sword Edge
(21081,5230,1,1,-1,8208), -- Recipe: Mithril Arrow (100%)
(21081,5478,1,1,-1,51767), -- Sealed Dark Crystal Leather Armor Pattern
(21081,57,2478,5056,0,700000), -- Adena
(21081,5297,1,1,1,18), -- Sealed Dark Crystal Leather Armor
(21081,5298,1,1,1,28), -- Sealed Dark Crystalline Leggings
(21081,5301,1,1,1,12), -- Sealed Tallum Leather Armor
(21081,5478,1,1,1,2549), -- Sealed Dark Crystal Leather Armor Pattern
(21081,5479,1,1,1,1794), -- Sealed Tallum Leather Armor Pattern
(21081,5482,1,1,1,4000), -- Sealed Dark Crystalline Leggings Design
(21081,1867,1,3,2,134698), -- Animal Skin
(21081,1872,1,3,2,202048), -- Animal Bone
(21081,1875,1,1,2,20205), -- Stone of Purity
(21081,1881,1,1,2,40410), -- Coarse Bone Powder
(21081,4041,1,1,2,2636), -- Mold Hardener
(21081,4985,1,1,2,859), -- Recipe: Leather Armor of Doom (60%)
(21082,5156,1,1,-1,7871), -- Recipe: Soulshot (A) Compressed Package (100%)
(21082,5482,1,1,-1,77916), -- Sealed Dark Crystalline Leggings Design
(21082,5486,1,1,-1,34931), -- Sealed Dark Crystal Robe Fabric
(21082,57,2377,4846,0,700000), -- Adena
(21082,5304,1,1,1,17), -- Sealed Tallum Tunic
(21082,5305,1,1,1,27), -- Sealed Tallum Stockings
(21082,5308,1,1,1,12), -- Sealed Dark Crystal Robe
(21082,5485,1,1,1,2444), -- Sealed Tallum Tunic Texture
(21082,5486,1,1,1,1720), -- Sealed Dark Crystal Robe Fabric
(21082,5489,1,1,1,3836), -- Sealed Tallum Stockings Fabric
(21082,1865,1,3,2,145314), -- Varnish
(21082,1870,1,3,2,96876), -- Coal
(21082,1875,1,1,2,19376), -- Stone of Purity
(21082,1879,1,1,2,48438), -- Cokes
(21082,4040,1,1,2,5813), -- Mold Lubricant
(21082,5281,1,1,2,388), -- Recipe: Greater Blessed Spiritshot (A) Compressed Package(100%)
(21083,5156,1,1,-1,8223), -- Recipe: Soulshot (A) Compressed Package (100%)
(21083,5485,1,1,-1,51860), -- Sealed Tallum Tunic Texture
(21083,5486,1,1,-1,36492), -- Sealed Dark Crystal Robe Fabric
(21083,57,2484,5062,0,700000), -- Adena
(21083,6323,1,1,1,35), -- Sealed Phoenix Necklace
(21083,6324,1,1,1,47), -- Sealed Phoenix Earring
(21083,6325,1,1,1,70), -- Sealed Phoenix Ring
(21083,6341,1,1,1,8398), -- Sealed Phoenix Earring Gemstone
(21083,6343,1,1,1,6492), -- Sealed Phoenix Necklace Beads
(21083,6345,1,1,1,11615), -- Sealed Phoenix Ring Gemstone
(21083,730,1,1,2,217), -- Scroll: Enchant Armor (Grade A)
(21083,1807,1,1,2,347), -- Recipe: Soulshot: A-Grade
(21083,1866,1,1,2,173494), -- Suede
(21083,1871,1,1,2,260240), -- Charcoal
(21083,1885,1,1,2,21687), -- High Grade Suede
(21083,4041,1,1,2,2264), -- Mold Hardener
(21083,5220,1,1,2,10410), -- Metal Hardener
(21084,4056,1,1,-1,74312), -- Zubei\'s Breastplate Part
(21084,4129,1,1,-1,44434), -- Recipe: Earrings of Black Ore
(21084,57,1656,3367,0,700000), -- Adena
(21084,78,1,1,1,5), -- Great Sword
(21084,142,1,1,1,5), -- Keshanberk
(21084,148,1,1,1,5), -- Sword of Valhalla
(21084,4104,1,1,1,1157), -- Great Sword Blade
(21084,4107,1,1,1,1139), -- Keshanberk Blade
(21084,4108,1,1,1,1139), -- Sword of Valhalla Blade
(21084,1832,1,1,2,149726), -- Greater Antidote
(21084,1868,1,3,2,134753), -- Thread
(21084,1873,1,1,2,53901), -- Silver Nugget
(21084,1889,1,1,2,8984), -- Compound Braid
(21084,4044,1,1,2,4492), -- Thons
(21084,4196,1,1,2,103), -- Recipe: Staff of Evil Spirits
(21084,4402,1,1,2,270), -- Blue Dimensional Stone
(21084,5002,1,1,2,103), -- Recipe: Deadman\'s Glory (60%)
(21084,5549,1,1,2,13476), -- Metallic Thread
(21085,1889,1,1,-1,636970), -- Compound Braid
(21085,5479,1,1,-1,56536), -- Sealed Tallum Leather Armor Pattern
(21085,5489,1,1,-1,126108), -- Sealed Tallum Stockings Fabric
(21085,57,3848,7843,0,700000), -- Adena
(21085,5297,1,1,1,28), -- Sealed Dark Crystal Leather Armor
(21085,5298,1,1,1,44), -- Sealed Dark Crystalline Leggings
(21085,5301,1,1,1,19), -- Sealed Tallum Leather Armor
(21085,5478,1,1,1,3955), -- Sealed Dark Crystal Leather Armor Pattern
(21085,5479,1,1,1,2783), -- Sealed Tallum Leather Armor Pattern
(21085,5482,1,1,1,6208), -- Sealed Dark Crystalline Leggings Design
(21085,1868,3,9,2,134394), -- Thread
(21085,1873,1,1,2,161273), -- Silver Nugget
(21085,1889,1,1,2,26879), -- Compound Braid
(21085,4044,1,1,2,13440), -- Thons
(21085,4131,1,1,2,3278), -- Recipe: Necklace of Black Ore
(21085,5549,1,1,2,40318), -- Metallic Thread
(21085,6036,1,1,2,13440), -- Greater Magic Haste Potion
(21086,1807,1,1,-1,12750), -- Recipe: Soulshot: A-Grade
(21086,1895,1,5,-1,910686), -- Metallic Fiber
(21086,5482,1,1,-1,126209), -- Sealed Dark Crystalline Leggings Design
(21086,57,3847,7856,0,700000), -- Adena
(21086,5287,1,1,1,21), -- Sealed Dark Crystal breastplate
(21086,5288,1,1,1,33), -- Sealed Dark Crystal Gaiters
(21086,5293,1,1,1,14), -- Sealed Tallum Plate Armor
(21086,5520,1,1,1,3037), -- Sealed Dark Crystal Breastplate Pattern
(21086,5521,1,1,1,2143), -- Sealed Tallum Plate Armor Pattern
(21086,5524,1,1,1,4641), -- Sealed Dark Crystal Gaiters Pattern
(21086,1895,1,1,2,134502), -- Metallic Fiber
(21086,4040,1,1,2,9416), -- Mold Lubricant
(21086,4042,1,1,2,7846), -- Enria
(21086,4043,1,1,2,15692), -- Asofe
(21086,4166,1,1,2,3891), -- Recipe: Doom Helmet
(21086,4401,1,1,2,942), -- Green Dimensional Stone
(21087,1894,1,1,-1,465485), -- Crafted Leather
(21087,4082,1,1,-1,149902), -- Blue Wolf Leather Armor Texture
(21087,5494,1,1,-1,278616), -- Sealed Dark Crystal Shield Fragment
(21087,57,5346,10885,0,700000), -- Adena
(21087,5287,1,1,1,29), -- Sealed Dark Crystal breastplate
(21087,5288,1,1,1,46), -- Sealed Dark Crystal Gaiters
(21087,5293,1,1,1,20), -- Sealed Tallum Plate Armor
(21087,5520,1,1,1,4213), -- Sealed Dark Crystal Breastplate Pattern
(21087,5521,1,1,1,2973), -- Sealed Tallum Plate Armor Pattern
(21087,5524,1,1,1,6438), -- Sealed Dark Crystal Gaiters Pattern
(21087,729,1,1,2,49), -- Scroll: Enchant Weapon (Grade A)
(21087,1864,5,15,2,87082), -- Stem
(21087,1869,2,6,2,108852), -- Iron Ore
(21087,1880,1,1,2,43541), -- Steel
(21087,4043,1,1,2,14514), -- Asofe
(21087,4614,1,1,2,601), -- Greater Dye of Strength <Str+4 Dex-4>
(21087,5550,1,1,2,5806), -- Durable Metal Plate
(21087,6037,9,27,2,48379), -- Waking Scroll
(21087,6671,1,1,2,48379), -- Deluxe Chest Key - Grade 7
(21088,4042,1,1,-1,169225), -- Enria
(21088,5230,1,1,-1,13538), -- Recipe: Mithril Arrow (100%)
(21088,5485,1,1,-1,85381), -- Sealed Tallum Tunic Texture
(21088,57,4089,8335,0,700000), -- Adena
(21088,5287,1,1,1,22), -- Sealed Dark Crystal breastplate
(21088,5288,1,1,1,35), -- Sealed Dark Crystal Gaiters
(21088,5293,1,1,1,15), -- Sealed Tallum Plate Armor
(21088,5520,1,1,1,3224), -- Sealed Dark Crystal Breastplate Pattern
(21088,5521,1,1,1,2275), -- Sealed Tallum Plate Armor Pattern
(21088,5524,1,1,1,4928), -- Sealed Dark Crystal Gaiters Pattern
(21088,1864,4,12,2,107114), -- Stem
(21088,1869,1,3,2,142819), -- Iron Ore
(21088,1880,1,1,2,42846), -- Steel
(21088,4043,1,1,2,14282), -- Asofe
(21088,4403,1,1,2,857), -- Red Dimensional Stone
(21088,4622,1,1,2,592), -- Greater Dye of Mental Strength <Men+4 Wit-4>
(21088,5550,1,1,2,5713), -- Durable Metal Plate
(21089,3035,1,1,-1,15741), -- Recipe: Spiritshot A
(21089,4116,1,1,-1,51588), -- Deadman\'s Glory Stone
(21089,5480,1,1,-1,52974), -- Sealed Leather Armor of Nightmare Fabric
(21089,57,4752,9696,0,700000), -- Adena
(21089,5304,1,1,1,34), -- Sealed Tallum Tunic
(21089,5305,1,1,1,54), -- Sealed Tallum Stockings
(21089,5308,1,1,1,23), -- Sealed Dark Crystal Robe
(21089,5485,1,1,1,4887), -- Sealed Tallum Tunic Texture
(21089,5486,1,1,1,3439), -- Sealed Dark Crystal Robe Fabric
(21089,5489,1,1,1,7670), -- Sealed Tallum Stockings Fabric
(21089,1868,15,45,2,38747), -- Thread
(21089,1873,2,6,2,58121), -- Silver Nugget
(21089,1876,1,1,2,116241), -- Mithril Ore
(21089,1895,1,1,2,166058), -- Metallic Fiber
(21089,4042,1,1,2,9687), -- Enria
(21089,4986,1,1,2,2412), -- Recipe: Blue Wolf Tunic (60%)
(21090,5156,1,1,-1,12101), -- Recipe: Soulshot (A) Compressed Package (100%)
(21090,5230,1,1,-1,12101), -- Recipe: Mithril Arrow (100%)
(21090,5486,1,1,-1,53701), -- Sealed Dark Crystal Robe Fabric
(21090,57,3653,7453,0,700000), -- Adena
(21090,5287,1,1,1,20), -- Sealed Dark Crystal breastplate
(21090,5288,1,1,1,31), -- Sealed Dark Crystal Gaiters
(21090,5293,1,1,1,14), -- Sealed Tallum Plate Armor
(21090,5520,1,1,1,2882), -- Sealed Dark Crystal Breastplate Pattern
(21090,5521,1,1,1,2034), -- Sealed Tallum Plate Armor Pattern
(21090,5524,1,1,1,4405), -- Sealed Dark Crystal Gaiters Pattern
(21090,730,1,1,2,280), -- Scroll: Enchant Armor (Grade A)
(21090,1344,20,60,2,209434), -- Mithril Arrow
(21090,1866,2,6,2,55850), -- Suede
(21090,1871,1,3,2,111699), -- Charcoal
(21090,1877,1,1,2,13404), -- Adamantite Nugget
(21090,4040,1,1,2,6702), -- Mold Lubricant
(21090,4041,1,1,2,2914), -- Mold Hardener
(21090,4401,1,1,2,671), -- Green Dimensional Stone
(21091,3035,1,1,-1,8134), -- Recipe: Spiritshot A
(21091,5479,1,1,-1,36097), -- Sealed Tallum Leather Armor Pattern
(21091,5482,1,1,-1,80517), -- Sealed Dark Crystalline Leggings Design
(21091,57,2457,5008,0,700000), -- Adena
(21091,5297,1,1,1,18), -- Sealed Dark Crystal Leather Armor
(21091,5298,1,1,1,28), -- Sealed Dark Crystalline Leggings
(21091,5301,1,1,1,12), -- Sealed Tallum Leather Armor
(21091,5478,1,1,1,2526), -- Sealed Dark Crystal Leather Armor Pattern
(21091,5479,1,1,1,1777), -- Sealed Tallum Leather Armor Pattern
(21091,5482,1,1,1,3964), -- Sealed Dark Crystalline Leggings Design
(21091,1867,1,3,2,200218), -- Animal Skin
(21091,1872,1,3,2,133479), -- Animal Bone
(21091,1882,1,1,2,66740), -- Leather
(21091,1894,1,1,2,10538), -- Crafted Leather
(21091,3035,1,1,2,401), -- Recipe: Spiritshot A
(21091,4042,1,1,2,5006), -- Enria
(21092,5161,1,1,-1,7946), -- Recipe: Spiritshot (A) Compressed Package (100%)
(21092,5478,1,1,-1,50115), -- Sealed Dark Crystal Leather Armor Pattern
(21092,5485,1,1,-1,50115), -- Sealed Tallum Tunic Texture
(21092,57,2400,4892,0,700000), -- Adena
(21092,5289,1,1,1,34), -- Sealed Dark Crystal Helmet
(21092,5292,1,1,1,49), -- Sealed Dark Crystal Shield
(21092,5294,1,1,1,34), -- Sealed Tallum Helmet
(21092,5494,1,1,1,6162), -- Sealed Dark Crystal Shield Fragment
(21092,5525,1,1,1,4536), -- Sealed Dark Crystal Helmet Design
(21092,5526,1,1,1,4536), -- Sealed Tallum Helm Design
(21092,1344,30,90,2,104787), -- Mithril Arrow
(21092,1868,4,12,2,62872), -- Thread
(21092,1873,1,1,2,100595), -- Silver Nugget
(21092,1889,1,1,2,16766), -- Compound Braid
(21092,3956,1,1,2,336), -- Recipe: Blessed Spiritshot A
(21092,4044,1,1,2,8383), -- Thons
(21092,5549,1,1,2,25149), -- Metallic Thread
(21093,1800,1,1,-1,83774), -- Recipe: Piece Bone Breastplate
(21093,1864,1,1,-1,532802), -- Stem
(21093,1897,1,1,-1,63429), -- Necklace of Wisdom Chain
(21093,57,125,213,0,700000), -- Adena
(21093,2,1,1,1,58), -- Long Sword
(21093,120,1,1,1,58), -- Sword of Reflection
(21093,121,1,1,1,58), -- Sword of Watershadow
(21093,2012,1,1,1,820), -- Sword of Reflection Blade
(21093,1801,1,1,2,19822), -- Recipe: Piece Bone Gaiters
(21093,1864,1,1,2,78691), -- Stem
(21093,1869,1,1,2,39346), -- Iron Ore
(21093,1878,1,1,2,15739), -- Braided Hemp
(21094,734,1,1,-1,45036), -- Haste Potion
(21094,1870,1,1,-1,270215), -- Coal
(21094,1924,1,1,-1,87166), -- Leather Helmet Design
(21094,57,125,217,0,700000), -- Adena
(21094,176,1,1,1,118), -- Journeyman\'s Staff
(21094,2501,1,1,1,118), -- Bone Club
(21094,1865,1,1,2,39909), -- Varnish
(21094,1870,1,1,2,39909), -- Coal
(21094,1879,1,1,2,6652), -- Cokes
(21094,2141,1,1,2,7982), -- Recipe: Silver Mold
(21095,1804,1,1,-1,12530), -- Recipe: Soulshot: D-Grade
(21095,1898,1,1,-1,32177), -- Blue Diamond Necklace Gem
(21095,2151,1,1,-1,87255), -- Recipe: Necklace of Devotion
(21095,57,143,255,0,700000), -- Adena
(21095,257,1,1,1,152), -- Viper\'s Fang
(21095,1804,1,1,2,1851), -- Recipe: Soulshot: D-Grade
(21095,1831,1,1,2,123370), -- Antidote
(21095,1865,1,1,2,46264), -- Varnish
(21095,1870,1,1,2,46264), -- Coal
(21096,1866,1,1,-1,205204), -- Suede
(21096,1871,1,1,-1,307807), -- Charcoal
(21096,1926,1,1,-1,31092), -- Piece Bone Breastplate Fragment
(21096,57,140,251,0,700000), -- Adena
(21096,39,1,1,1,986), -- Boots
(21096,51,1,1,1,986), -- Bracer
(21096,1930,1,1,1,15542), -- Boot Lining
(21096,1866,1,1,2,40410), -- Suede
(21096,1871,1,1,2,60615), -- Charcoal
(21096,2179,1,1,2,29003), -- Recipe: Crafted Leather Gloves
(21097,1927,1,1,-1,28206), -- Hard Leather Shirt Pattern
(21097,1928,1,1,-1,51502), -- Piece Bone Gaiters Fragment
(21097,2176,1,1,-1,169170), -- Recipe: Leather Boots
(21097,57,162,286,0,700000), -- Adena
(21097,846,1,1,1,653), -- Coral Earring
(21097,878,1,1,1,977), -- Blue Coral Ring
(21097,909,1,1,1,491), -- Blue Diamond Necklace
(21097,1898,1,1,1,5364), -- Blue Diamond Necklace Gem
(21097,734,1,1,2,6963), -- Haste Potion
(21097,1831,1,1,2,111401), -- Antidote
(21097,1865,1,1,2,41775), -- Varnish
(21097,1870,1,1,2,41775), -- Coal
(21097,2257,1,1,2,1022), -- Recipe: Trident
(21098,1879,1,1,-1,55471), -- Cokes
(21098,1929,1,1,-1,42945), -- Hard Leather Gaiters Material
(21098,2177,1,1,-1,106333), -- Recipe: Bone Helmet
(21098,57,148,273,0,700000), -- Adena
(21098,16,1,1,1,161), -- Long Spear
(21098,1865,1,1,2,49156), -- Varnish
(21098,1870,1,1,2,49156), -- Coal
(21098,1879,1,1,2,8193), -- Cokes
(21098,5158,1,1,2,1967), -- Recipe: Spiritshot (D) Compressed Package (100%)
(21099,1875,1,1,-1,23782), -- Stone of Purity
(21099,1899,1,1,-1,55740), -- Necklace of Devotion Chain
(21099,2152,1,1,-1,62805), -- Recipe: Enchanted Necklace
(21099,57,157,294,0,700000), -- Adena
(21099,45,1,1,1,427), -- Bone Helmet
(21099,626,1,1,1,610), -- Bronze Shield
(21099,1932,1,1,1,10594), -- Bone Helmet Design
(21099,1875,1,1,2,3337), -- Stone of Purity
(21099,1879,1,1,2,8343), -- Cokes
(21099,2152,1,1,2,8812), -- Recipe: Enchanted Necklace
(21099,5549,1,1,2,5006), -- Metallic Thread
(21100,1800,1,1,-1,83774), -- Recipe: Piece Bone Breastplate
(21100,1897,1,1,-1,63429), -- Necklace of Wisdom Chain
(21100,1924,1,1,-1,85936), -- Leather Helmet Design
(21100,57,125,213,0,700000), -- Adena
(21100,845,1,1,1,886), -- Cat\'s Eye Earring
(21100,877,1,1,1,1330), -- Ring of Wisdom
(21100,908,1,1,1,662), -- Necklace of Wisdom
(21100,1897,1,1,1,9369), -- Necklace of Wisdom Chain
(21100,1817,1,1,2,7870), -- Recipe: Cord
(21100,1864,1,1,2,78691), -- Stem
(21100,1869,1,1,2,39346), -- Iron Ore
(21100,1880,1,1,2,3935), -- Steel
(21101,1865,1,1,-1,332824), -- Varnish
(21101,1870,1,1,-1,332824), -- Coal
(21101,1898,1,1,-1,34188), -- Blue Diamond Necklace Gem
(21101,57,148,273,0,700000), -- Adena
(21101,39,1,1,1,1066), -- Boots
(21101,51,1,1,1,1066), -- Bracer
(21101,1930,1,1,1,16806), -- Boot Lining
(21101,1865,1,1,2,39325), -- Varnish
(21101,1870,1,1,2,39325), -- Coal
(21101,5163,1,1,2,1573), -- Recipe: Blessed Spiritshot (D) Compressed Package (100%)
(21101,6035,1,1,2,3277), -- Magic Haste Potion
(21101,6666,1,1,2,39325), -- Deluxe Chest Key - Grade 2
(21102,1900,1,1,-1,49380), -- Enchanted Necklace Chain
(21102,2153,1,1,-1,70191), -- Recipe: Tiger\'s Eye Earring
(21102,2183,1,1,-1,29693), -- Recipe: Mithril Banded Mail
(21102,57,190,381,0,700000), -- Adena
(21102,433,1,1,1,62), -- Elven Tunic
(21102,434,1,1,1,62), -- White Tunic
(21102,435,1,1,1,62), -- Mystic\'s Tunic
(21102,466,1,1,1,99), -- Elven Stockings
(21102,467,1,1,1,99), -- Dark Stockings
(21102,468,1,1,1,99), -- Mystic\'s Stockings
(21102,1933,1,1,1,3628), -- Dark Stocking Fabric
(21102,1936,1,1,1,2523), -- White Tunic Pattern
(21102,956,1,1,2,1371), -- Scroll: Enchant Armor (Grade D)
(21102,1874,1,1,2,2741), -- Oriharukon Ore
(21102,1878,1,1,2,16443), -- Braided Hemp
(21102,1884,1,1,2,25296), -- Cord
(21102,1889,1,1,2,2741), -- Compound Braid
(21102,5220,1,1,2,1645), -- Metal Hardener
(21103,955,1,1,-1,1880), -- Scroll: Enchant Weapon (Grade D)
(21103,1879,1,1,-1,78342), -- Cokes
(21103,1933,1,1,-1,55300), -- Dark Stocking Fabric
(21103,57,199,396,0,700000), -- Adena
(21103,348,1,1,1,97), -- Scale Mail
(21103,377,1,1,1,155), -- Scale Gaiters
(21103,1935,1,1,1,3588), -- Scale Mail Fragment
(21103,1937,1,1,1,5517), -- Scale Gaiters Fragment
(21103,1061,1,1,2,22240), -- Healing Potion
(21103,1875,1,1,2,2447), -- Stone of Purity
(21103,1879,1,1,2,6116), -- Cokes
(21103,1885,1,1,2,3058), -- High Grade Suede
(21103,2185,1,1,2,7224), -- Recipe: Iron Boots
(21103,5549,1,1,2,3670), -- Metallic Thread
(21103,5550,1,1,2,490), -- Durable Metal Plate
(21104,1061,1,1,-1,355341), -- Healing Potion
(21104,1876,1,1,-1,117263), -- Mithril Ore
(21104,1935,1,1,-1,32755), -- Scale Mail Fragment
(21104,57,247,496,0,700000), -- Adena
(21104,605,1,1,1,962), -- Leather Gauntlets
(21104,1123,1,1,1,962), -- Blue Buckskin Boots
(21104,1876,1,1,2,9155), -- Mithril Ore
(21104,1877,1,1,2,1831), -- Adamantite Nugget
(21104,1880,1,1,2,4578), -- Steel
(21104,1881,1,1,2,6103), -- Coarse Bone Powder
(21104,1882,1,1,2,10172), -- Leather
(21104,2264,1,1,2,474), -- Recipe: Two-handed Sword
(21104,6667,1,1,2,28607), -- Deluxe Chest Key - Grade 3
(21105,1901,1,1,-1,93083), -- Tiger\'s Eye Earring Stone
(21105,2154,1,1,-1,72155), -- Recipe: Elven Earring
(21105,2155,1,1,-1,108174), -- Recipe: Elven Ring
(21105,57,285,569,0,700000), -- Adena
(21105,393,1,1,1,79), -- Mithril Banded Mail
(21105,394,1,1,1,79), -- Reinforced Leather Shirt
(21105,415,1,1,1,126), -- Mithril Banded Gaiters
(21105,416,1,1,1,126), -- Reinforced Leather Gaiters
(21105,1938,1,1,1,4016), -- Mithril Banded Mail Material
(21105,1939,1,1,1,5246), -- Mithril Banded Gaiters Material
(21105,1874,1,1,2,3982), -- Oriharukon Ore
(21105,1878,1,1,2,23888), -- Braided Hemp
(21105,1884,1,1,2,36751), -- Cord
(21105,1889,1,1,2,3982), -- Compound Braid
(21105,2154,1,1,2,6395), -- Recipe: Elven Earring
(21105,5220,1,1,2,2389), -- Metal Hardener
(21106,1885,1,1,-1,47321), -- High Grade Suede
(21106,1938,1,1,-1,38175), -- Mithril Banded Mail Material
(21106,5550,1,1,-1,7571), -- Durable Metal Plate
(21106,57,240,478,0,700000), -- Adena
(21106,47,1,1,1,397), -- Helmet
(21106,628,1,1,1,567), -- Hoplon
(21106,1341,10,30,2,143770), -- Bone Arrow
(21106,1875,1,1,2,2876), -- Stone of Purity
(21106,1879,1,1,2,7189), -- Cokes
(21106,1885,1,1,2,3595), -- High Grade Suede
(21106,2186,1,1,2,1443), -- Recipe: Brigandine Tunic
(21106,5549,1,1,2,4314), -- Metallic Thread
(21106,5550,1,1,2,576), -- Durable Metal Plate
(21107,1939,1,1,-1,105226), -- Mithril Banded Gaiters Material
(21107,1940,1,1,-1,178805), -- Iron Boots Design
(21107,2156,1,1,-1,95840), -- Recipe: Elven Necklace
(21107,57,506,1010,0,700000), -- Adena
(21107,260,1,1,1,132), -- Triple-Edged Jamadhr
(21107,1876,1,1,2,21233), -- Mithril Ore
(21107,1877,1,1,2,4247), -- Adamantite Nugget
(21107,1880,1,1,2,10617), -- Steel
(21107,1881,1,1,2,14155), -- Coarse Bone Powder
(21107,1882,1,1,2,23592), -- Leather
(21107,2188,1,1,2,7583), -- Recipe: Manticore Skin Gaiters
(21108,4052,1,1,-1,78329), -- Earring of Black Ore Piece
(21108,5230,1,1,-1,2950), -- Recipe: Mithril Arrow (100%)
(21108,5550,1,1,-1,29499), -- Durable Metal Plate
(21108,57,890,1818,0,700000), -- Adena
(21108,358,1,1,1,7), -- Blue Wolf Breastplate
(21108,2380,1,1,1,11), -- Blue Wolf Gaiters
(21108,2381,1,1,1,5), -- Doom Plate Armor
(21108,4078,1,1,1,1591), -- Blue Wolf Breastplate Part
(21108,4080,1,1,1,2241), -- Blue Wolf Gaiters Material
(21108,4081,1,1,1,1074), -- Doom Plate Armor Temper
(21108,1864,1,1,2,217837), -- Stem
(21108,1869,1,1,2,108919), -- Iron Ore
(21108,1880,1,1,2,10892), -- Steel
(21108,4043,1,1,2,3631), -- Asofe
(21108,5230,1,1,2,146), -- Recipe: Mithril Arrow (100%)
(21108,5550,1,1,2,1453), -- Durable Metal Plate
(21109,1874,1,1,-1,183146), -- Oriharukon Ore
(21109,4043,1,1,-1,91573), -- Asofe
(21109,5478,1,1,-1,23101), -- Sealed Dark Crystal Leather Armor Pattern
(21109,57,1108,2253,0,700000), -- Adena
(21109,6323,1,1,1,16), -- Sealed Phoenix Necklace
(21109,6324,1,1,1,21), -- Sealed Phoenix Earring
(21109,6325,1,1,1,32), -- Sealed Phoenix Ring
(21109,6341,1,1,1,3741), -- Sealed Phoenix Earring Gemstone
(21109,6343,1,1,1,2892), -- Sealed Phoenix Necklace Beads
(21109,6345,1,1,1,5175), -- Sealed Phoenix Ring Gemstone
(21109,1807,1,1,2,136), -- Recipe: Soulshot: A-Grade
(21109,1865,1,1,2,101435), -- Varnish
(21109,1870,1,1,2,101435), -- Coal
(21109,1874,1,1,2,6763), -- Oriharukon Ore
(21109,4039,1,1,2,3382), -- Mold Glue
(21109,4043,1,1,2,3382), -- Asofe
(21109,6037,1,1,2,202870), -- Waking Scroll
(21109,6670,1,1,2,16906), -- Deluxe Chest Key - Grade 6
(21110,1807,1,1,-1,3130), -- Recipe: Soulshot: A-Grade
(21110,3035,1,1,-1,3130), -- Recipe: Spiritshot A
(21110,5479,1,1,-1,13892), -- Sealed Tallum Leather Armor Pattern
(21110,57,948,1925,0,700000), -- Adena
(21110,5297,1,1,1,7), -- Sealed Dark Crystal Leather Armor
(21110,5298,1,1,1,11), -- Sealed Dark Crystalline Leggings
(21110,5301,1,1,1,5), -- Sealed Tallum Leather Armor
(21110,5478,1,1,1,972), -- Sealed Dark Crystal Leather Armor Pattern
(21110,5479,1,1,1,684), -- Sealed Tallum Leather Armor Pattern
(21110,5482,1,1,1,1526), -- Sealed Dark Crystalline Leggings Design
(21110,1866,1,1,2,77056), -- Suede
(21110,1871,1,1,2,115584), -- Charcoal
(21110,1877,1,1,2,4624), -- Adamantite Nugget
(21110,3956,1,1,2,155), -- Recipe: Blessed Spiritshot A
(21110,4040,1,1,2,2312), -- Mold Lubricant
(21110,4041,1,1,2,1006), -- Mold Hardener
(21111,4041,1,1,-1,21400), -- Mold Hardener
(21111,5479,1,1,-1,14562), -- Sealed Tallum Leather Armor Pattern
(21111,5482,1,1,-1,32483), -- Sealed Dark Crystalline Leggings Design
(21111,57,993,2020,0,700000), -- Adena
(21111,5297,1,1,1,7), -- Sealed Dark Crystal Leather Armor
(21111,5298,1,1,1,12), -- Sealed Dark Crystalline Leggings
(21111,5301,1,1,1,5), -- Sealed Tallum Leather Armor
(21111,5478,1,1,1,1019), -- Sealed Dark Crystal Leather Armor Pattern
(21111,5479,1,1,1,717), -- Sealed Tallum Leather Armor Pattern
(21111,5482,1,1,1,1599), -- Sealed Dark Crystalline Leggings Design
(21111,1344,10,30,2,129814), -- Mithril Arrow
(21111,1865,1,1,2,103852), -- Varnish
(21111,1870,1,1,2,103852), -- Coal
(21111,1875,1,1,2,6924), -- Stone of Purity
(21111,1879,1,1,2,17309), -- Cokes
(21111,4040,1,1,2,2078), -- Mold Lubricant
(21111,5166,1,1,2,139), -- Recipe: Blessed Spiritshot (A) Compressed Package (100%)
(21112,3956,1,1,-1,3987), -- Recipe: Blessed Spiritshot A
(21112,5485,1,1,-1,25148), -- Sealed Tallum Tunic Texture
(21112,5486,1,1,-1,17696), -- Sealed Dark Crystal Robe Fabric
(21112,57,1204,2455,0,700000), -- Adena
(21112,5290,1,1,1,20), -- Sealed Dark Crystal Gloves
(21112,5291,1,1,1,20), -- Sealed Dark Crystal Boots
(21112,5295,1,1,1,20), -- Sealed Tallum Gloves
(21112,5296,1,1,1,20), -- Sealed Tallum Boots
(21112,5496,1,1,1,2589), -- Sealed Dark Crystal Boots Lining
(21112,5497,1,1,1,2589), -- Sealed Tallum Boots Lining
(21112,5508,1,1,1,2589), -- Sealed Dark Crystal Gloves Design
(21112,5509,1,1,1,2589), -- Sealed Tallum Gloves Design
(21112,1868,1,1,2,294456), -- Thread
(21112,1873,1,1,2,58892), -- Silver Nugget
(21112,1876,1,1,2,29446), -- Mithril Ore
(21112,1895,1,1,2,42065), -- Metallic Fiber
(21112,4042,1,1,2,2454), -- Enria
(21112,5281,1,1,2,197), -- Recipe: Greater Blessed Spiritshot (A) Compressed Package(100%)
(21113,5156,1,1,-1,4454), -- Recipe: Soulshot (A) Compressed Package (100%)
(21113,5166,1,1,-1,4454), -- Recipe: Blessed Spiritshot (A) Compressed Package (100%)
(21113,5489,1,1,-1,44093), -- Sealed Tallum Stockings Fabric
(21113,57,1344,2745,0,700000), -- Adena
(21113,5297,1,1,1,10), -- Sealed Dark Crystal Leather Armor
(21113,5298,1,1,1,16), -- Sealed Dark Crystalline Leggings
(21113,5301,1,1,1,7), -- Sealed Tallum Leather Armor
(21113,5478,1,1,1,1383), -- Sealed Dark Crystal Leather Armor Pattern
(21113,5479,1,1,1,973), -- Sealed Tallum Leather Armor Pattern
(21113,5482,1,1,1,2171), -- Sealed Dark Crystalline Leggings Design
(21113,1344,30,90,2,58738), -- Mithril Arrow
(21113,1864,1,3,2,140969), -- Stem
(21113,1869,1,1,2,140969), -- Iron Ore
(21113,1878,1,1,2,56388), -- Braided Hemp
(21113,1884,1,1,2,86751), -- Cord
(21113,3035,1,1,2,189), -- Recipe: Spiritshot A
(21113,4039,1,1,2,4699), -- Mold Glue
(21114,1875,1,1,-1,212062), -- Stone of Purity
(21114,5161,1,1,-1,4241), -- Recipe: Spiritshot (A) Compressed Package (100%)
(21114,5494,1,1,-1,66805), -- Sealed Dark Crystal Shield Fragment
(21114,57,1282,2610,0,700000), -- Adena
(21114,5287,1,1,1,7), -- Sealed Dark Crystal breastplate
(21114,5288,1,1,1,11), -- Sealed Dark Crystal Gaiters
(21114,5293,1,1,1,5), -- Sealed Tallum Plate Armor
(21114,5520,1,1,1,1011), -- Sealed Dark Crystal Breastplate Pattern
(21114,5521,1,1,1,713), -- Sealed Tallum Plate Armor Pattern
(21114,5524,1,1,1,1544), -- Sealed Dark Crystal Gaiters Pattern
(21114,1344,10,30,2,167786), -- Mithril Arrow
(21114,1865,1,1,2,134229), -- Varnish
(21114,1870,1,1,2,134229), -- Coal
(21114,1874,1,1,2,8949), -- Oriharukon Ore
(21114,4039,1,1,2,4475), -- Mold Glue
(21114,4043,1,1,2,4475), -- Asofe
(21114,5271,1,1,2,180), -- Recipe: Greater Soulshot (A) Compressed Package(100%)
(21115,5166,1,1,-1,3704), -- Recipe: Blessed Spiritshot (A) Compressed Package (100%)
(21115,5496,1,1,-1,65134), -- Sealed Dark Crystal Boots Lining
(21115,5497,1,1,-1,65134), -- Sealed Tallum Boots Lining
(21115,57,1119,2280,0,700000), -- Adena
(21115,5304,1,1,1,8), -- Sealed Tallum Tunic
(21115,5305,1,1,1,13), -- Sealed Tallum Stockings
(21115,5308,1,1,1,6), -- Sealed Dark Crystal Robe
(21115,5485,1,1,1,1150), -- Sealed Tallum Tunic Texture
(21115,5486,1,1,1,810), -- Sealed Dark Crystal Robe Fabric
(21115,5489,1,1,1,1805), -- Sealed Tallum Stockings Fabric
(21115,1866,1,1,2,78150), -- Suede
(21115,1871,1,1,2,117225), -- Charcoal
(21115,1885,1,1,2,9769), -- High Grade Suede
(21115,4041,1,1,2,1020), -- Mold Hardener
(21115,5220,1,1,2,4689), -- Metal Hardener
(21115,5281,1,1,2,157), -- Recipe: Greater Blessed Spiritshot (A) Compressed Package(100%)
(21115,6671,1,1,2,13025), -- Deluxe Chest Key - Grade 7
(21116,729,1,1,-1,489), -- Scroll: Enchant Weapon (Grade A)
(21116,5480,1,1,-1,19737), -- Sealed Leather Armor of Nightmare Fabric
(21116,5481,1,1,-1,19737), -- Sealed Majestic Leather Armor Fabric
(21116,57,1770,3612,0,700000), -- Adena
(21116,6323,1,1,1,25), -- Sealed Phoenix Necklace
(21116,6324,1,1,1,34), -- Sealed Phoenix Earring
(21116,6325,1,1,1,50), -- Sealed Phoenix Ring
(21116,6341,1,1,1,5990), -- Sealed Phoenix Earring Gemstone
(21116,6343,1,1,1,4630), -- Sealed Phoenix Necklace Beads
(21116,6345,1,1,1,8285), -- Sealed Phoenix Ring Gemstone
(21116,729,1,1,2,21), -- Scroll: Enchant Weapon (Grade A)
(21116,1867,1,3,2,123739), -- Animal Skin
(21116,1872,1,1,2,247478), -- Animal Bone
(21116,1882,1,1,2,41247), -- Leather
(21116,1894,1,1,2,6513), -- Crafted Leather
(21116,4042,1,1,2,3094), -- Enria
(21116,4987,1,1,2,771), -- Recipe: Tunic of Doom (60%)
(21117,734,1,1,-1,43530), -- Haste Potion
(21117,1800,1,1,-1,82131), -- Recipe: Piece Bone Breastplate
(21117,1897,1,1,-1,62185), -- Necklace of Wisdom Chain
(21117,57,122,208,0,700000), -- Adena
(21117,38,1,1,1,1520), -- Low Boots
(21117,50,1,1,1,1520), -- Leather Gloves
(21117,1925,1,1,1,33727), -- Leather Gloves Lining
(21117,1868,1,1,2,102864), -- Thread
(21117,1873,1,1,2,20573), -- Silver Nugget
(21117,2139,1,1,2,10287), -- Recipe: Steel Mold
(21118,1801,1,1,-1,138851), -- Recipe: Piece Bone Gaiters
(21118,1924,1,1,-1,88910), -- Leather Helmet Design
(21118,1925,1,1,-1,180734), -- Leather Gloves Lining
(21118,57,127,221,0,700000), -- Adena
(21118,44,1,1,1,799), -- Leather Helmet
(21118,102,1,1,1,1146), -- Round Shield
(21118,945,1,1,1,2367), -- Skeleton Buckler
(21118,1924,1,1,1,13132), -- Leather Helmet Design
(21118,1864,1,1,2,65132), -- Stem
(21118,1869,1,1,2,32566), -- Iron Ore
(21118,1880,1,1,2,3257), -- Steel
(21118,2142,1,1,2,6514), -- Recipe: Varnish of Purity
(21118,6035,1,1,2,2714), -- Magic Haste Potion
(21119,1868,1,1,-1,569536), -- Thread
(21119,1873,1,1,-1,113907), -- Silver Nugget
(21119,1898,1,1,-1,29252), -- Blue Diamond Necklace Gem
(21119,57,130,231,0,700000), -- Adena
(21119,27,1,1,1,228), -- Hard Leather Shirt
(21119,33,1,1,1,366), -- Hard Leather Gaiters
(21119,1927,1,1,1,3356), -- Hard Leather Shirt Pattern
(21119,1929,1,1,1,5427), -- Hard Leather Gaiters Material
(21119,1868,1,1,2,168233), -- Thread
(21119,1873,1,1,2,33647), -- Silver Nugget
(21120,1804,1,1,-1,14652), -- Recipe: Soulshot: D-Grade
(21120,1926,1,1,-1,36999), -- Piece Bone Breastplate Fragment
(21120,2151,1,1,-1,102031), -- Recipe: Necklace of Devotion
(21120,57,166,299,0,700000), -- Adena
(21120,87,1,1,1,45), -- Iron Hammer
(21120,155,1,1,1,45), -- Buzdygan
(21120,177,1,1,1,45), -- Mage Staff
(21120,2014,1,1,1,622), -- Iron Hammer Head
(21120,1867,1,1,2,72131), -- Animal Skin
(21120,1872,1,1,2,72131), -- Animal Bone
(21120,1882,1,1,2,12022), -- Leather
(21120,2255,1,1,2,1323), -- Recipe: Saber
(21121,1875,1,1,-1,21428), -- Stone of Purity
(21121,1881,1,1,-1,42856), -- Coarse Bone Powder
(21121,1927,1,1,-1,25642), -- Hard Leather Shirt Pattern
(21121,57,147,260,0,700000), -- Adena
(21121,257,1,1,1,156), -- Viper\'s Fang
(21121,1867,1,1,2,63296), -- Animal Skin
(21121,1872,1,1,2,63296), -- Animal Bone
(21121,1881,1,1,2,6330), -- Coarse Bone Powder
(21121,2258,1,1,2,1161), -- Recipe: Temptation of Abyss
(21122,1928,1,1,-1,49451), -- Piece Bone Gaiters Fragment
(21122,1929,1,1,-1,43804), -- Hard Leather Gaiters Material
(21122,2176,1,1,-1,162431), -- Recipe: Leather Boots
(21122,57,151,278,0,700000), -- Adena
(21122,273,1,1,1,83), -- Composition Bow
(21122,2016,1,1,1,1175), -- Composition Bow Shaft
(21122,1868,1,1,2,133704), -- Thread
(21122,1873,1,1,2,26741), -- Silver Nugget
(21122,5268,1,1,2,2675), -- Recipe: Greater Soulshot (D) Compressed Package (100%)
(21123,1874,1,1,-1,29775), -- Oriharukon Ore
(21123,1899,1,1,-1,69786), -- Necklace of Devotion Chain
(21123,2152,1,1,-1,78632), -- Recipe: Enchanted Necklace
(21123,57,197,368,0,700000), -- Adena
(21123,220,1,1,1,123), -- Crafted Dagger
(21123,1874,1,1,2,4178), -- Oriharukon Ore
(21123,1878,1,1,2,25067), -- Braided Hemp
(21123,2178,1,1,2,10027), -- Recipe: Dark Stockings
(21123,5220,1,1,2,2507), -- Metal Hardener
(21124,735,1,1,-1,21105), -- Potion of Alacrity
(21124,1865,1,1,-1,253256), -- Varnish
(21124,1897,1,1,-1,60299), -- Necklace of Wisdom Chain
(21124,57,121,200,0,700000), -- Adena
(21124,309,1,1,1,110), -- Tears of Eva
(21124,310,1,1,1,110), -- Relic of The Saints
(21124,1800,1,1,2,11763), -- Recipe: Piece Bone Breastplate
(21124,1865,1,1,2,37404), -- Varnish
(21124,1870,1,1,2,37404), -- Coal
(21124,1879,1,1,2,6235), -- Cokes
(21125,1800,1,1,-1,82944), -- Recipe: Piece Bone Breastplate
(21125,1801,1,1,-1,132878), -- Recipe: Piece Bone Gaiters
(21125,1924,1,1,-1,85085), -- Leather Helmet Design
(21125,57,124,211,0,700000), -- Adena
(21125,15,1,1,1,115), -- Short Spear
(21125,2011,1,1,1,1778), -- Short Spear Edge
(21125,734,1,1,2,6493), -- Haste Potion
(21125,1866,1,1,2,25971), -- Suede
(21125,1871,1,1,2,38956), -- Charcoal
(21125,2140,1,1,2,7792), -- Recipe: High Grade Suede
(21126,1864,1,1,-1,540431), -- Stem
(21126,1865,1,1,-1,270215), -- Varnish
(21126,1925,1,1,-1,177190), -- Leather Gloves Lining
(21126,57,125,217,0,700000), -- Adena
(21126,24,1,1,1,394), -- Bone Breastplate
(21126,31,1,1,1,629), -- Bone Gaiters
(21126,390,1,1,1,394), -- Cotton Shirt
(21126,412,1,1,1,629), -- Cotton Pants
(21126,1864,1,1,2,53212), -- Stem
(21126,1865,1,1,2,26606), -- Varnish
(21126,1866,1,1,2,17738), -- Suede
(21126,1868,1,1,2,53212), -- Thread
(21126,1873,1,1,2,10643), -- Silver Nugget
(21126,2143,1,1,2,5322), -- Recipe: Synthetic Cokes
(21127,1804,1,1,-1,11391), -- Recipe: Soulshot: D-Grade
(21127,1898,1,1,-1,29252), -- Blue Diamond Necklace Gem
(21127,1926,1,1,-1,28764), -- Piece Bone Breastplate Fragment
(21127,57,130,231,0,700000), -- Adena
(21127,25,1,1,1,177), -- Piece Bone Breastplate
(21127,26,1,1,1,114), -- Bronze Breastplate
(21127,32,1,1,1,282), -- Piece Bone Gaiters
(21127,34,1,1,1,183), -- Bronze Gaiters
(21127,1926,1,1,1,2833), -- Piece Bone Breastplate Fragment
(21127,1928,1,1,1,4085), -- Piece Bone Gaiters Fragment
(21127,1868,1,1,2,84116), -- Thread
(21127,1873,1,1,2,16824), -- Silver Nugget
(21127,2151,1,1,2,11716), -- Recipe: Necklace of Devotion
(21127,6035,1,1,2,3505), -- Magic Haste Potion
(21128,1869,1,1,-1,301771), -- Iron Ore
(21128,1927,1,1,-1,24074), -- Hard Leather Shirt Pattern
(21128,2151,1,1,-1,84059), -- Recipe: Necklace of Devotion
(21128,57,137,246,0,700000), -- Adena
(21128,1102,1,1,1,484), -- Tunic of Magic
(21128,1105,1,1,1,775), -- Stockings of Magic
(21128,1867,1,1,2,39618), -- Animal Skin
(21128,1869,1,1,2,29713), -- Iron Ore
(21128,1870,1,1,2,29713), -- Coal
(21128,1871,1,1,2,29713), -- Charcoal
(21128,1872,1,1,2,39618), -- Animal Bone
(21128,2256,1,1,2,727), -- Recipe: Assassin Knife
(21129,1870,1,1,-1,321422), -- Coal
(21129,1928,1,1,-1,46820), -- Piece Bone Gaiters Fragment
(21129,2176,1,1,-1,153791), -- Recipe: Leather Boots
(21129,57,147,260,0,700000), -- Adena
(21129,846,1,1,1,594), -- Coral Earring
(21129,878,1,1,1,888), -- Blue Coral Ring
(21129,909,1,1,1,446), -- Blue Diamond Necklace
(21129,1898,1,1,1,4877), -- Blue Diamond Necklace Gem
(21129,1865,1,1,2,47472), -- Varnish
(21129,1870,1,1,2,47472), -- Coal
(21129,3032,1,1,2,1899), -- Recipe: Spiritshot D
(21129,6035,1,1,2,3956), -- Magic Haste Potion
(21130,1929,1,1,-1,43804), -- Hard Leather Gaiters Material
(21130,1930,1,1,-1,87046), -- Boot Lining
(21130,2177,1,1,-1,108460), -- Recipe: Bone Helmet
(21130,57,151,278,0,700000), -- Adena
(21130,39,1,1,1,1087), -- Boots
(21130,51,1,1,1,1087), -- Bracer
(21130,1930,1,1,1,17142), -- Boot Lining
(21130,734,1,1,2,8357), -- Haste Potion
(21130,1866,1,1,2,33426), -- Suede
(21130,1871,1,1,2,50139), -- Charcoal
(21130,5273,1,1,2,2006), -- Recipe: Greater Spiritshot (D) Compressed Package(100%)
(21131,1867,1,1,-1,466319), -- Animal Skin
(21131,1872,1,1,-1,466319), -- Animal Bone
(21131,1899,1,1,-1,54647), -- Necklace of Devotion Chain
(21131,57,154,288,0,700000), -- Adena
(21131,45,1,1,1,419), -- Bone Helmet
(21131,626,1,1,1,598), -- Bronze Shield
(21131,1932,1,1,1,10386), -- Bone Helmet Design
(21131,1867,1,1,2,52343), -- Animal Skin
(21131,1872,1,1,2,52343), -- Animal Bone
(21131,1875,1,1,2,2618), -- Stone of Purity
(21131,1881,1,1,2,5235), -- Coarse Bone Powder
(21131,2180,1,1,2,2952), -- Recipe: Scale Mail
(21132,1898,1,1,-1,28490), -- Blue Diamond Necklace Gem
(21132,2179,1,1,-1,132705), -- Recipe: Crafted Leather Gloves
(21132,2255,1,1,-1,6781), -- Recipe: Saber
(21132,57,123,227,0,700000), -- Adena
(21132,68,1,1,1,67), -- Falchion
(21132,5284,1,1,1,67), -- Zweihander
(21132,1868,1,1,2,109235), -- Thread
(21132,1873,1,1,2,21847), -- Silver Nugget
(21132,5278,1,1,2,2185), -- Recipe: Greater Blessed Spiritshot (D) Compressed Package(100%)
(21133,1864,1,1,-1,600386), -- Stem
(21133,1878,1,1,-1,120077), -- Braided Hemp
(21133,1899,1,1,-1,46905), -- Necklace of Devotion Chain
(21133,57,132,248,0,700000), -- Adena
(21133,156,1,1,1,28), -- Hand Axe
(21133,167,1,1,1,28), -- Scalpel
(21133,178,1,1,1,28), -- Bone Staff
(21133,1061,1,1,2,20422), -- Healing Potion
(21133,1864,1,1,2,67391), -- Stem
(21133,1869,1,1,2,33696), -- Iron Ore
(21133,1878,1,1,2,13479), -- Braided Hemp
(21133,2181,1,1,2,3373), -- Recipe: White Tunic
(21134,1931,1,1,-1,40933), -- Leather Boot Lining
(21134,1932,1,1,-1,49704), -- Bone Helmet Design
(21134,2152,1,1,-1,55130), -- Recipe: Enchanted Necklace
(21134,57,136,260,0,700000), -- Adena
(21134,258,1,1,1,86), -- Bagh-Nakh
(21134,1865,1,1,2,35149), -- Varnish
(21134,1870,1,1,2,35149), -- Coal
(21134,1875,1,1,2,2344), -- Stone of Purity
(21134,1879,1,1,2,5859), -- Cokes
(21134,2259,1,1,2,546), -- Recipe: Spinebone Sword
(21135,1934,1,1,-1,49861), -- Crafted Leather Gloves Lining
(21135,2178,1,1,-1,61030), -- Recipe: Dark Stockings
(21135,5220,1,1,-1,15258), -- Metal Hardener
(21135,57,165,317,0,700000), -- Adena
(21135,274,1,1,1,105), -- Strengthened Bow
(21135,1866,1,1,2,28544), -- Suede
(21135,1871,1,1,2,42816), -- Charcoal
(21135,1885,1,1,2,3568), -- High Grade Suede
(21135,2261,1,1,2,665), -- Recipe: Conjuror\'s Staff
(21135,5220,1,1,2,1713), -- Metal Hardener
(21136,1882,1,1,-1,74873), -- Leather
(21136,2017,1,1,-1,4477), -- Saber Blade
(21136,2180,1,1,-1,25333), -- Recipe: Scale Mail
(21136,57,144,283,0,700000), -- Adena
(21136,220,1,1,1,92), -- Crafted Dagger
(21136,1834,1,1,2,42022), -- Emergency Dressing
(21136,1867,1,1,2,50426), -- Animal Skin
(21136,1872,1,1,2,50426), -- Animal Bone
(21136,1882,1,1,2,8405), -- Leather
(21136,2152,1,1,2,6659), -- Recipe: Enchanted Necklace
(21137,1900,1,1,-1,39353), -- Enchanted Necklace Chain
(21137,1933,1,1,-1,42316), -- Dark Stocking Fabric
(21137,2153,1,1,-1,55938), -- Recipe: Tiger\'s Eye Earring
(21137,57,152,302,0,700000), -- Adena
(21137,315,1,1,1,61), -- Divine Tome
(21137,737,1,1,2,3276), -- Scroll of Resurrection
(21137,1868,1,1,2,65519), -- Thread
(21137,1873,1,1,2,13104), -- Silver Nugget
(21137,1889,1,1,2,2184), -- Compound Braid
(21137,5549,1,1,2,3276), -- Metallic Thread
(21137,6387,1,1,2,1311), -- Blessed Scroll of Resurrection for Pets
(21138,956,1,1,-1,12783), -- Scroll: Enchant Armor (Grade D)
(21138,1864,1,1,-1,766967), -- Stem
(21138,1869,1,1,-1,383484), -- Iron Ore
(21138,57,162,324,0,700000), -- Adena
(21138,292,1,1,1,65), -- Pike
(21138,1341,10,30,2,116423), -- Bone Arrow
(21138,1829,1,1,2,13971), -- Scroll of Escape: Clan Hall
(21138,1864,1,1,2,69854), -- Stem
(21138,1869,1,1,2,34927), -- Iron Ore
(21138,1880,1,1,2,3493), -- Steel
(21138,5550,1,1,2,466), -- Durable Metal Plate
(21139,1804,1,1,-1,37606), -- Recipe: Soulshot: D-Grade
(21139,1898,1,1,-1,96575), -- Blue Diamond Necklace Gem
(21139,1926,1,1,-1,94966), -- Piece Bone Breastplate Fragment
(21139,57,430,759,0,700000), -- Adena
(21139,27,1,1,1,753), -- Hard Leather Shirt
(21139,33,1,1,1,1208), -- Hard Leather Gaiters
(21139,1927,1,1,1,11078), -- Hard Leather Shirt Pattern
(21139,1929,1,1,1,17918), -- Hard Leather Gaiters Material
(21139,1865,1,1,2,185140), -- Varnish
(21139,1870,1,1,2,185140), -- Coal
(21139,3953,1,1,2,7406), -- Recipe: Blessed Spiritshot D
(21140,1871,1,3,-1,549553), -- Charcoal
(21140,1899,1,1,-1,171735), -- Necklace of Devotion Chain
(21140,2152,1,1,-1,193505), -- Recipe: Enchanted Necklace
(21140,57,477,911,0,700000), -- Adena
(21140,347,1,1,1,739), -- Ring Mail Breastplate
(21140,376,1,1,1,1182), -- Iron Plate Gaiters
(21140,1866,1,1,2,102809), -- Suede
(21140,1871,1,1,2,154213), -- Charcoal
(21140,1877,1,1,2,6169), -- Adamantite Nugget
(21140,2260,1,1,2,2395), -- Recipe: Mace of Judgment
(21141,1881,1,1,-1,169543), -- Coarse Bone Powder
(21141,1931,1,1,-1,166219), -- Leather Boot Lining
(21141,2178,1,1,-1,203452), -- Recipe: Dark Stockings
(21141,57,545,1067,0,700000), -- Adena
(21141,432,1,1,1,1140), -- Cursed Tunic
(21141,465,1,1,1,1826), -- Cursed Stockings
(21141,1867,1,1,2,190306), -- Animal Skin
(21141,1872,1,1,2,190306), -- Animal Bone
(21141,1875,1,1,2,9516), -- Stone of Purity
(21141,1881,1,1,2,19031), -- Coarse Bone Powder
(21141,2178,1,1,2,22837), -- Recipe: Dark Stockings
(21142,1900,1,1,-1,138128), -- Enchanted Necklace Chain
(21142,1933,1,1,-1,148528), -- Dark Stocking Fabric
(21142,2153,1,1,-1,196344), -- Recipe: Tiger\'s Eye Earring
(21142,57,535,1059,0,700000), -- Adena
(21142,848,1,1,1,810), -- Enchanted Earring
(21142,879,1,1,1,1215), -- Enchanted Ring
(21142,911,1,1,1,608), -- Enchanted Necklace
(21142,1900,1,1,1,18871), -- Enchanted Necklace Chain
(21142,955,1,1,2,690), -- Scroll: Enchant Weapon (Grade D)
(21142,1868,1,1,2,344952), -- Thread
(21142,1873,1,1,2,68991), -- Silver Nugget
(21142,1876,1,1,2,34496), -- Mithril Ore
(21143,955,1,1,-1,5610), -- Scroll: Enchant Weapon (Grade D)
(21143,1872,1,3,-1,934937), -- Animal Bone
(21143,1875,1,1,-1,93494), -- Stone of Purity
(21143,57,593,1182,0,700000), -- Adena
(21143,605,1,1,1,2302), -- Leather Gauntlets
(21143,1123,1,1,1,2302), -- Blue Buckskin Boots
(21143,1867,1,1,2,170303), -- Animal Skin
(21143,1872,1,1,2,170303), -- Animal Bone
(21143,1875,1,1,2,8515), -- Stone of Purity
(21143,1881,1,1,2,17031), -- Coarse Bone Powder
(21143,2250,1,1,2,31932), -- Recipe: Bone Arrow
(21143,6035,1,1,2,10644), -- Magic Haste Potion
(21144,1901,1,1,-1,229413), -- Tiger\'s Eye Earring Stone
(21144,1938,1,1,-1,111661), -- Mithril Banded Mail Material
(21144,2154,1,1,-1,177832), -- Recipe: Elven Earring
(21144,57,702,1399,0,700000), -- Adena
(21144,47,1,1,1,1160), -- Helmet
(21144,628,1,1,1,1657), -- Hoplon
(21144,1865,1,1,2,147186), -- Varnish
(21144,1870,1,1,2,147186), -- Coal
(21144,1875,1,1,2,9813), -- Stone of Purity
(21144,1879,1,1,2,24531), -- Cokes
(21144,2187,1,1,2,6571), -- Recipe: Manticore Skin Shirt
(21144,6035,1,1,2,12266), -- Magic Haste Potion
(21145,1825,1,1,-1,150797), -- Recipe: Oriharukon
(21145,1885,1,1,-1,175930), -- High Grade Suede
(21145,1902,1,1,-1,213897), -- Elven Earring Beads
(21145,57,893,1781,0,700000), -- Adena
(21145,129,1,1,1,78), -- Sword of Revolution
(21145,2034,1,1,1,5766), -- Sword of Revolution Blade
(21145,1832,1,1,2,173224), -- Greater Antidote
(21145,1866,1,1,2,103935), -- Suede
(21145,1871,1,1,2,155902), -- Charcoal
(21145,1885,1,1,2,12993), -- High Grade Suede
(21145,2146,1,1,2,11137), -- Recipe: Artisan\'s frame
(21145,5220,1,1,2,6237), -- Metal Hardener
(21145,5473,1,1,2,11137), -- Recipe: Durable Metal Plate(100%)
(21146,1894,1,1,-1,79584), -- Crafted Leather
(21146,1903,1,1,-1,378338), -- Elven Ring Piece
(21146,2145,1,1,-1,162010), -- Recipe: Mithril Alloy
(21146,57,951,1898,0,700000), -- Adena
(21146,88,1,1,1,17), -- Morning Star
(21146,90,1,1,1,17), -- Goat Head Staff
(21146,158,1,1,1,17), -- Tarbar
(21146,169,1,1,1,17), -- Skull Breaker
(21146,172,1,1,1,17), -- Heavy Bone Club
(21146,2031,1,1,1,1187), -- Morning Star Head
(21146,2032,1,1,1,1084), -- Goat Head Staff Head
(21146,2035,1,1,1,1187), -- Tarbar Head
(21146,2036,1,1,1,1187), -- Skull Breaker Head
(21146,2037,1,1,1,1187), -- Heavy Bone Club Head
(21146,7643,1,1,2,36639), -- Spellbook - Summon Nightshade
(21146,7644,1,1,2,36639), -- Spellbook - Summon Cursed Man
(21146,10097,1,1,2,23256), -- Battle Manual: Shoulder Charge
(21147,1805,1,1,-1,9195), -- Recipe: Soulshot: C-Grade
(21147,1905,1,1,-1,268330), -- Omen Beast\'s Eye Earring Gemstone
(21147,1906,1,1,-1,379166), -- Mithril Ring Wire
(21147,57,1113,2260,0,700000), -- Adena
(21147,262,1,1,1,77), -- Scallop Jamadhr
(21147,2053,1,1,1,5727), -- Scallop Jamadhr Edge
(21147,1868,1,3,2,230860), -- Thread
(21147,1873,1,1,2,92344), -- Silver Nugget
(21147,1889,1,1,2,15391), -- Compound Braid
(21147,2199,1,1,2,9741), -- Recipe: Karmian Stockings
(21147,2301,1,1,2,1009), -- Recipe: Battle Axe
(21147,5549,1,1,2,23087), -- Metallic Thread
(21148,1869,1,5,-1,912739), -- Iron Ore
(21148,1880,1,1,-1,273822), -- Steel
(21148,5550,1,1,-1,36510), -- Durable Metal Plate
(21148,57,1099,2253,0,700000), -- Adena
(21148,281,1,1,1,57), -- Crystallized Ice Bow
(21148,2074,1,1,1,4583), -- Crystallized Ice Bow Shaft
(21148,1864,1,3,2,184875), -- Stem
(21148,1869,2,6,2,46219), -- Iron Ore
(21148,1880,1,1,2,18488), -- Steel
(21148,2163,1,1,2,9433), -- Recipe: Earring of Protection
(21148,2217,1,1,2,10940), -- Recipe: Knight\'s Shield
(21148,5550,1,1,2,2466), -- Durable Metal Plate
(21148,6037,1,3,2,123250), -- Waking Scroll
(21149,1908,1,1,-1,299146), -- Moonstone Earring Wire
(21149,1909,1,1,-1,426601), -- Aquastone Ring Wire
(21149,2163,1,1,-1,161172), -- Recipe: Earring of Protection
(21149,57,1269,2596,0,700000), -- Adena
(21149,226,1,1,1,33), -- Cursed Dagger
(21149,232,1,1,1,33), -- Dark Elven Dagger
(21149,2070,1,1,1,2964), -- Cursed Dagger Blade
(21149,2072,1,1,1,2964), -- Dark Elven Dagger Edge
(21149,1868,1,3,2,213284), -- Thread
(21149,1873,1,1,2,85314), -- Silver Nugget
(21149,1876,1,1,2,42657), -- Mithril Ore
(21149,1895,1,1,2,60938), -- Metallic Fiber
(21149,2215,1,1,2,2718), -- Recipe: Robe of Seal
(21149,2228,1,1,2,5796), -- Recipe: Shining Circlet
(21149,4042,1,1,2,3555), -- Enria
(21150,951,1,1,-1,6524), -- Scroll: Enchant Weapon (Grade C)
(21150,1911,1,1,-1,266897), -- Earring of Protection Gemstone
(21150,2166,1,1,-1,121642), -- Recipe: Earrings of Binding (100%)
(21150,57,1445,2946,0,700000), -- Adena
(21150,325,1,1,1,56), -- Horn of Glory
(21150,2088,1,1,1,5603), -- Horn of Glory Fragment
(21150,1342,20,60,2,176662), -- Fine Steel Arrow
(21150,1866,1,1,2,117775), -- Suede
(21150,1871,1,1,2,176662), -- Charcoal
(21150,1877,1,1,2,7067), -- Adamantite Nugget
(21150,2166,1,1,2,5989), -- Recipe: Earrings of Binding (100%)
(21150,2234,1,1,2,2633), -- Recipe: Divine Stockings
(21150,3014,1,1,2,4935), -- Recipe: Full Plate Boots
(21150,4040,1,1,2,3534), -- Mold Lubricant
(21150,4041,1,1,2,1537), -- Mold Hardener
(21151,1869,1,7,-1,935306), -- Iron Ore
(21151,4043,1,1,-1,124707), -- Asofe
(21151,4601,1,1,-1,8314), -- Greater Dye of Strength <Str+3 Con-3>
(21151,57,1509,3068,0,700000), -- Adena
(21151,231,1,1,1,18), -- Grace Dagger
(21151,233,1,1,1,18), -- Dark Screamer
(21151,2106,1,1,1,2109), -- Grace Dagger Edge
(21151,2107,1,1,1,2109), -- Dark Screamer Edge
(21151,1864,1,3,2,257857), -- Stem
(21151,1869,1,3,2,85953), -- Iron Ore
(21151,1880,1,1,2,25786), -- Steel
(21151,2169,1,1,2,4564), -- Recipe: Necklace of Binding
(21151,4043,1,1,2,8596), -- Asofe
(21151,5550,1,1,2,3439), -- Durable Metal Plate
(21152,1806,1,1,-1,8007), -- Recipe: Soulshot: B-Grade
(21152,1920,1,1,-1,136989), -- Necklace of Binding Chain
(21152,4600,1,1,-1,13345), -- Greater Dye of Wit <Wit+2 Men-2>
(21152,57,1616,3283,0,700000), -- Adena
(21152,400,1,1,1,60), -- Theca Leather Armor
(21152,401,1,1,1,32), -- Drake Leather Armor
(21152,420,1,1,1,96), -- Theca Leather Gaiters
(21152,1984,1,1,1,5282), -- Theca Leather Armor Pattern
(21152,1985,1,1,1,8496), -- Theca Leather Gaiters Pattern
(21152,1987,1,1,1,3759), -- Drake Leather Armor Texture
(21152,1806,1,1,2,370), -- Recipe: Soulshot: B-Grade
(21152,1868,1,3,2,184778), -- Thread
(21152,1873,1,1,2,73912), -- Silver Nugget
(21152,1876,1,1,2,36956), -- Mithril Ore
(21152,1895,1,1,2,52794), -- Metallic Fiber
(21152,4042,1,1,2,3080), -- Enria
(21152,4941,1,1,2,1422), -- Recipe: Zubei\'s Gaiters  (60%)
(21152,4959,1,1,2,3561), -- Recipe: Avadon Boots (60%)
(21153,947,1,1,-1,1895), -- Scroll: Enchant Weapon (Grade B)
(21153,4049,1,1,-1,248435), -- Adamantite Earring Gemstone
(21153,4129,1,1,-1,51260), -- Recipe: Earrings of Black Ore
(21153,57,1906,3892,0,700000), -- Adena
(21153,357,1,1,1,17), -- Zubei\'s Breastplate
(21153,383,1,1,1,27), -- Zubei\'s Gaiters
(21153,2376,1,1,1,17), -- Avadon Breastplate
(21153,2379,1,1,1,27), -- Avadon Gaiters
(21153,4056,1,1,1,3165), -- Zubei\'s Breastplate Part
(21153,4057,1,1,1,4892), -- Zubei\'s Gaiter Material
(21153,4064,1,1,1,3165), -- Avadon Breastplate Part
(21153,4065,1,1,1,4892), -- Avadon Gaiters Material
(21153,947,1,1,2,80), -- Scroll: Enchant Weapon (Grade B)
(21153,1894,1,1,2,7013), -- Crafted Leather
(21153,3955,1,1,2,400), -- Recipe: Blessed Spiritshot B
(21153,4039,1,1,2,6663), -- Mold Glue
(21153,4041,1,1,2,1738), -- Mold Hardener
(21153,4044,1,1,2,6663), -- Thons
(21153,5280,1,1,2,400), -- Recipe: Greater Blessed Spiritshot (B) Compressed Package(100%)
(21154,4049,1,1,-1,260988), -- Adamantite Earring Gemstone
(21154,4613,1,1,-1,6863), -- Greater Dye of Strength <Str+4 Con-4>
(21154,4614,1,1,-1,6863), -- Greater Dye of Strength <Str+4 Dex-4>
(21154,57,2005,4083,0,700000), -- Adena
(21154,2397,1,1,1,32), -- Tunic of Zubei
(21154,2402,1,1,1,51), -- Stockings of Zubei
(21154,2406,1,1,1,22), -- Avadon Robe
(21154,4069,1,1,1,5774), -- Tunic of Zubei Fabric
(21154,4070,1,1,1,8767), -- Stockings of Zubei Fabric
(21154,4071,1,1,1,4436), -- Avadon Robe Fabric
(21154,1832,1,1,2,326619), -- Greater Antidote
(21154,5809,1,1,2,8710), -- Spellbook: Aqua Splash
(21154,5810,1,1,2,8710), -- Spellbook: Rain of Fire
(21154,5816,1,1,2,8710), -- Spellbook: Advanced Block
(21154,6351,1,1,2,7170), -- Amulet: Ritual of Life
(21155,4050,1,1,-1,310911), -- Adamantite Ring Wire
(21155,4051,1,1,-1,194613), -- Adamantite Necklace Chain
(21155,4130,1,1,-1,81463), -- Recipe: Ring of Black Ore
(21155,57,2021,4119,0,700000), -- Adena
(21155,856,1,1,1,82), -- Adamantite Earring
(21155,887,1,1,1,123), -- Adamantite Ring
(21155,918,1,1,1,62), -- Adamantite Necklace
(21155,4049,1,1,1,12961), -- Adamantite Earring Gemstone
(21155,4050,1,1,1,15310), -- Adamantite Ring Wire
(21155,4051,1,1,1,9583), -- Adamantite Necklace Chain
(21155,1895,1,1,2,70585), -- Metallic Fiber
(21155,4040,1,1,2,4942), -- Mold Lubricant
(21155,4042,1,1,2,4118), -- Enria
(21155,4043,1,1,2,8236), -- Asofe
(21155,4154,1,1,2,2924), -- Recipe: Doom Shield
(21155,6037,1,3,2,247046), -- Waking Scroll
(21156,948,1,1,-1,13466), -- Scroll: Enchant Armor (Grade B)
(21156,4056,1,1,-1,97490), -- Zubei\'s Breastplate Part
(21156,4131,1,1,-1,43791), -- Recipe: Necklace of Black Ore
(21156,57,2177,4415,0,700000), -- Adena
(21156,554,1,1,1,77), -- Zubei\'s Boots
(21156,600,1,1,1,77), -- Avadon Boots
(21156,612,1,1,1,77), -- Zubei\'s Gauntlets
(21156,2464,1,1,1,77), -- Avadon Gloves
(21156,4073,1,1,1,10348), -- Avadon Gloves Part
(21156,4097,1,1,1,10348), -- Zubei\'s Boots Design
(21156,4098,1,1,1,10348), -- Avadon Boots Design
(21156,4100,1,1,1,10348), -- Zubei\'s Gauntlets Part
(21156,1343,20,60,2,162352), -- Silver Arrow
(21156,1865,1,3,2,75764), -- Varnish
(21156,1870,2,6,2,56823), -- Coal
(21156,1875,1,1,2,15153), -- Stone of Purity
(21156,1879,1,1,2,37882), -- Cokes
(21156,4040,1,1,2,4546), -- Mold Lubricant
(21156,4160,1,1,2,644), -- Recipe: Leather Armor of Doom
(21157,1889,1,1,-1,409609), -- Compound Braid
(21157,4052,1,1,-1,217530), -- Earring of Black Ore Piece
(21157,5549,1,1,-1,614413), -- Metallic Thread
(21157,57,2488,5032,0,700000), -- Adena
(21157,110,1,1,1,72), -- Doom Shield
(21157,2416,1,1,1,50), -- Blue Wolf Helmet
(21157,2417,1,1,1,50), -- Doom Helmet
(21157,4077,1,1,1,13606), -- Doom Shield Fragment
(21157,4088,1,1,1,11431), -- Blue Wolf Helmet Design
(21157,4089,1,1,1,11431), -- Doom Helmet Pattern
(21157,1830,1,1,2,103708), -- Scroll of Escape: Castle
(21157,1832,1,3,2,96026), -- Greater Antidote
(21157,1868,4,12,2,64818), -- Thread
(21157,1873,1,1,2,103708), -- Silver Nugget
(21157,1889,1,1,2,17285), -- Compound Braid
(21157,4044,1,1,2,8643), -- Thons
(21157,5549,1,1,2,25927), -- Metallic Thread
(21158,4053,1,1,-1,298243), -- Ring of Black Ore Gemstone
(21158,5230,1,1,-1,9277), -- Recipe: Mithril Arrow (100%)
(21158,57,2798,5718,0,700000), -- Adena
(21158,2391,1,1,1,30), -- Blue Wolf Leather Armor
(21158,2392,1,1,1,30), -- Leather Armor of Doom
(21158,4082,1,1,1,5805), -- Blue Wolf Leather Armor Texture
(21158,4083,1,1,1,5805), -- Leather Armor of Doom Design
(21158,1344,30,90,2,122339), -- Mithril Arrow
(21158,1830,1,1,2,117445), -- Scroll of Escape: Castle
(21158,1864,5,15,2,58723), -- Stem
(21158,1869,2,6,2,73404), -- Iron Ore
(21158,1880,1,1,2,29362), -- Steel
(21158,4043,1,1,2,9788), -- Asofe
(21158,5550,1,1,2,3915), -- Durable Metal Plate
(21159,1874,1,1,-1,479284), -- Oriharukon Ore
(21159,4043,1,1,-1,239642), -- Asofe
(21159,5478,1,1,-1,60455), -- Sealed Dark Crystal Leather Armor Pattern
(21159,57,2901,5897,0,700000), -- Adena
(21159,5304,1,1,1,21), -- Sealed Tallum Tunic
(21159,5305,1,1,1,33), -- Sealed Tallum Stockings
(21159,5308,1,1,1,14), -- Sealed Dark Crystal Robe
(21159,5485,1,1,1,2976), -- Sealed Tallum Tunic Texture
(21159,5486,1,1,1,2094), -- Sealed Dark Crystal Robe Fabric
(21159,5489,1,1,1,4671), -- Sealed Tallum Stockings Fabric
(21159,1344,20,60,2,165907), -- Mithril Arrow
(21159,1865,2,6,2,66363), -- Varnish
(21159,1870,1,3,2,88484), -- Coal
(21159,1874,1,1,2,17697), -- Oriharukon Ore
(21159,3035,1,1,2,354), -- Recipe: Spiritshot A
(21159,4039,1,1,2,8849), -- Mold Glue
(21159,4043,1,1,2,8849), -- Asofe
(21159,5281,1,1,2,354), -- Recipe: Greater Blessed Spiritshot (A) Compressed Package(100%)
(21160,1807,1,1,-1,9997), -- Recipe: Soulshot: A-Grade
(21160,5479,1,1,-1,44366), -- Sealed Tallum Leather Armor Pattern
(21160,5482,1,1,-1,98961), -- Sealed Dark Crystalline Leggings Design
(21160,57,3019,6154,0,700000), -- Adena
(21160,5304,1,1,1,22), -- Sealed Tallum Tunic
(21160,5305,1,1,1,35), -- Sealed Tallum Stockings
(21160,5308,1,1,1,15), -- Sealed Dark Crystal Robe
(21160,5485,1,1,1,3104), -- Sealed Tallum Tunic Texture
(21160,5486,1,1,1,2184), -- Sealed Dark Crystal Robe Fabric
(21160,5489,1,1,1,4872), -- Sealed Tallum Stockings Fabric
(21160,729,1,1,2,35), -- Scroll: Enchant Weapon (Grade A)
(21160,1807,1,1,2,422), -- Recipe: Soulshot: A-Grade
(21160,1894,1,1,2,11102), -- Crafted Leather
(21160,4039,1,1,2,10547), -- Mold Glue
(21160,4041,1,1,2,2752), -- Mold Hardener
(21160,4044,1,1,2,10547), -- Thons
(21160,6037,1,3,2,316388), -- Waking Scroll
(21161,3035,1,1,-1,10926), -- Recipe: Spiritshot A
(21161,4041,1,1,-1,71260), -- Mold Hardener
(21161,5485,1,1,-1,68911), -- Sealed Tallum Tunic Texture
(21161,57,3302,6724,0,700000), -- Adena
(21161,6323,1,1,1,47), -- Sealed Phoenix Necklace
(21161,6324,1,1,1,62), -- Sealed Phoenix Earring
(21161,6325,1,1,1,93), -- Sealed Phoenix Ring
(21161,6341,1,1,1,11159), -- Sealed Phoenix Earring Gemstone
(21161,6343,1,1,1,8627), -- Sealed Phoenix Necklace Beads
(21161,6345,1,1,1,15434), -- Sealed Phoenix Ring Gemstone
(21161,1866,1,1,2,268960), -- Suede
(21161,1871,1,3,2,201720), -- Charcoal
(21161,1877,1,1,2,16138), -- Adamantite Nugget
(21161,4040,1,1,2,8069), -- Mold Lubricant
(21161,4041,1,1,2,3508), -- Mold Hardener
(21161,5276,1,1,2,539), -- Recipe: Greater Spiritshot (A) Compressed Package(100%)
(21162,3956,1,1,-1,10942), -- Recipe: Blessed Spiritshot A
(21162,5478,1,1,-1,69011), -- Sealed Dark Crystal Leather Armor Pattern
(21162,5486,1,1,-1,48561), -- Sealed Dark Crystal Robe Fabric
(21162,57,3305,6737,0,700000), -- Adena
(21162,5297,1,1,1,24), -- Sealed Dark Crystal Leather Armor
(21162,5298,1,1,1,38), -- Sealed Dark Crystalline Leggings
(21162,5301,1,1,1,16), -- Sealed Tallum Leather Armor
(21162,5478,1,1,1,3398), -- Sealed Dark Crystal Leather Armor Pattern
(21162,5479,1,1,1,2391), -- Sealed Tallum Leather Armor Pattern
(21162,5482,1,1,1,5333), -- Sealed Dark Crystalline Leggings Design
(21162,1807,1,1,2,462), -- Recipe: Soulshot: A-Grade
(21162,1868,3,9,2,115437), -- Thread
(21162,1873,1,1,2,138524), -- Silver Nugget
(21162,1876,1,1,2,69262), -- Mithril Ore
(21162,1895,1,1,2,98946), -- Metallic Fiber
(21162,4042,1,1,2,5772), -- Enria
(21162,6036,1,1,2,11545), -- Greater Magic Haste Potion
(21163,729,1,1,-1,967), -- Scroll: Enchant Weapon (Grade A)
(21163,5480,1,1,-1,39041), -- Sealed Leather Armor of Nightmare Fabric
(21163,5481,1,1,-1,39041), -- Sealed Majestic Leather Armor Fabric
(21163,57,3493,7152,0,700000), -- Adena
(21163,5290,1,1,1,56), -- Sealed Dark Crystal Gloves
(21163,5291,1,1,1,56), -- Sealed Dark Crystal Boots
(21163,5295,1,1,1,56), -- Sealed Tallum Gloves
(21163,5296,1,1,1,56), -- Sealed Tallum Boots
(21163,5496,1,1,1,7532), -- Sealed Dark Crystal Boots Lining
(21163,5497,1,1,1,7532), -- Sealed Tallum Boots Lining
(21163,5508,1,1,1,7532), -- Sealed Dark Crystal Gloves Design
(21163,5509,1,1,1,7532), -- Sealed Tallum Gloves Design
(21163,7654,1,1,2,11078), -- Spellbook - Mass Warrior Bane
(21163,7655,1,1,2,11078), -- Spellbook - Mass Mage Bane
(21163,7660,1,1,2,11078), -- Spellbook - Warrior Bane
(21163,7661,1,1,2,11078), -- Spellbook - Mage Bane
(21164,5480,1,1,-1,44804), -- Sealed Leather Armor of Nightmare Fabric
(21164,5481,1,1,-1,44804), -- Sealed Majestic Leather Armor Fabric
(21164,5487,1,1,-1,44963), -- Sealed Robe of Nightmare Fabric
(21164,57,4018,8199,0,700000), -- Adena
(21164,6326,1,1,1,38), -- Sealed Majestic Necklace
(21164,6327,1,1,1,51), -- Sealed Majestic Earring
(21164,6328,1,1,1,76), -- Sealed Majestic Ring
(21164,6342,1,1,1,11135), -- Sealed Majestic Earring Gemstone
(21164,6344,1,1,1,7206), -- Sealed Majestic Necklace Beads
(21164,6346,1,1,1,16004), -- Sealed Majestic Ring Gemstone
(21164,729,1,1,2,55), -- Scroll: Enchant Weapon (Grade A)
(21164,1866,1,3,2,109237), -- Suede
(21164,1871,1,3,2,245782), -- Charcoal
(21164,1877,1,1,2,19663), -- Adamantite Nugget
(21164,4040,1,1,2,9832), -- Mold Lubricant
(21164,4041,1,1,2,4275); -- Mold Hardener

INSERT INTO `droplist` VALUES 
(21165,730,1,1,-1,8591), -- Scroll: Enchant Armor (Grade A)
(21165,5488,1,1,-1,46422), -- Sealed Majestic Robe Fabric
(21165,5495,1,1,-1,156540), -- Sealed Shield of Nightmare Fragment
(21165,57,4147,8467,0,700000), -- Adena
(21165,5320,1,1,1,20), -- Sealed Leather Armor of Nightmare
(21165,5323,1,1,1,20), -- Sealed Majestic Leather Armor
(21165,5480,1,1,1,3417), -- Sealed Leather Armor of Nightmare Fabric
(21165,5481,1,1,1,3417), -- Sealed Majestic Leather Armor Fabric
(21165,729,1,1,2,49), -- Scroll: Enchant Weapon (Grade A)
(21165,730,1,1,2,363), -- Scroll: Enchant Armor (Grade A)
(21165,1895,1,1,2,124290), -- Metallic Fiber
(21165,4040,1,1,2,8701), -- Mold Lubricant
(21165,4042,1,1,2,7251), -- Enria
(21165,4043,1,1,2,14501), -- Asofe
(21165,6037,3,9,2,145005), -- Waking Scroll
(21166,1868,1,3,-1,886728), -- Thread
(21166,1873,1,1,-1,354691), -- Silver Nugget
(21166,1898,1,1,-1,91087), -- Blue Diamond Necklace Gem
(21166,6360,53,109,0,700000), -- Blue Seal Stone
(21166,25,1,1,1,550), -- Piece Bone Breastplate
(21166,26,1,1,1,355), -- Bronze Breastplate
(21166,32,1,1,1,878), -- Piece Bone Gaiters
(21166,34,1,1,1,569), -- Bronze Gaiters
(21166,1926,1,1,1,8819), -- Piece Bone Breastplate Fragment
(21166,1928,1,1,1,12718), -- Piece Bone Gaiters Fragment
(21166,1868,1,3,2,130963), -- Thread
(21166,1873,1,1,2,52386), -- Silver Nugget
(21166,2176,1,1,2,62662), -- Recipe: Leather Boots
(21166,6037,1,3,2,87309), -- Waking Scroll
(21166,6362,23,42,4,700000), -- Red Seal Stone
(21167,1804,1,1,-1,39326), -- Recipe: Soulshot: D-Grade
(21167,1926,1,1,-1,99308), -- Piece Bone Breastplate Fragment
(21167,2151,1,1,-1,273857), -- Recipe: Necklace of Devotion
(21167,6360,72,143,0,700000), -- Blue Seal Stone
(21167,1102,1,1,1,1574), -- Tunic of Magic
(21167,1105,1,1,1,2526), -- Stockings of Magic
(21167,735,1,1,2,12101), -- Potion of Alacrity
(21167,1867,1,1,2,193605), -- Animal Skin
(21167,1872,1,1,2,193605), -- Animal Bone
(21167,1882,1,1,2,32268), -- Leather
(21167,6362,21,39,4,700000), -- Red Seal Stone
(21168,1889,1,1,-1,78778), -- Compound Braid
(21168,1899,1,1,-1,184636), -- Necklace of Devotion Chain
(21168,5549,1,1,-1,118167), -- Metallic Thread
(21168,6360,97,190,0,700000), -- Blue Seal Stone
(21168,847,1,1,1,1233), -- Red Crescent Earring
(21168,890,1,1,1,1843), -- Ring of Devotion
(21168,910,1,1,1,924), -- Necklace of Devotion
(21168,1899,1,1,1,25907), -- Necklace of Devotion Chain
(21168,1868,1,3,2,110532), -- Thread
(21168,1873,1,1,2,44213), -- Silver Nugget
(21168,1889,1,1,2,7369), -- Compound Braid
(21168,2262,1,1,2,1717), -- Recipe: Elven Bow
(21168,5549,1,1,2,11054), -- Metallic Thread
(21168,6037,1,1,2,221064), -- Waking Scroll
(21168,6362,22,41,4,700000), -- Red Seal Stone
(21169,1061,1,1,-1,881783), -- Healing Potion
(21169,1900,1,1,-1,159184), -- Enchanted Necklace Chain
(21169,2153,1,1,-1,226274), -- Recipe: Tiger\'s Eye Earring
(21169,6360,128,259,0,700000), -- Blue Seal Stone
(21169,605,1,1,1,2388), -- Leather Gauntlets
(21169,1123,1,1,1,2388), -- Blue Buckskin Boots
(21169,1864,1,3,2,159015), -- Stem
(21169,1869,1,1,2,159015), -- Iron Ore
(21169,1880,1,1,2,15902), -- Steel
(21169,2153,1,1,2,24731), -- Recipe: Tiger\'s Eye Earring
(21169,5550,1,1,2,2121), -- Durable Metal Plate
(21169,6362,24,44,4,700000), -- Red Seal Stone
(21170,1901,1,1,-1,222980), -- Tiger\'s Eye Earring Stone
(21170,1938,1,1,-1,108529), -- Mithril Banded Mail Material
(21170,2154,1,1,-1,172845), -- Recipe: Elven Earring
(21170,6360,108,211,0,700000), -- Blue Seal Stone
(21170,47,1,1,1,1127), -- Helmet
(21170,628,1,1,1,1611), -- Hoplon
(21170,1864,1,1,2,286117), -- Stem
(21170,1869,1,1,2,143059), -- Iron Ore
(21170,1880,1,1,2,14306), -- Steel
(21170,2155,1,1,2,22963), -- Recipe: Elven Ring
(21170,5550,1,1,2,1908), -- Durable Metal Plate
(21170,6035,1,1,2,11922), -- Magic Haste Potion
(21170,6361,33,63,3,700000), -- Green Seal Stone
(21170,6362,22,41,4,700000), -- Red Seal Stone
(21171,1865,1,5,-1,684631), -- Varnish
(21171,1870,1,5,-1,684631), -- Coal
(21171,1939,1,1,-1,180403), -- Mithril Banded Gaiters Material
(21171,6360,96,192,0,700000), -- Blue Seal Stone
(21171,83,1,1,1,51), -- Sword of Magic
(21171,124,1,1,1,38), -- Two-Handed Sword
(21171,127,1,1,1,38), -- Crimson Sword
(21171,130,1,1,1,38), -- Elven Sword
(21171,144,1,1,1,51), -- Sword of Occult
(21171,2026,1,1,1,2191), -- Two-Handed Sword Edge
(21171,1865,1,1,2,273010), -- Varnish
(21171,1870,1,3,2,136505), -- Coal
(21171,1874,1,1,2,18201), -- Oriharukon Ore
(21171,2191,1,1,2,36548), -- Recipe: RIP Gauntlets
(21171,6361,68,136,3,700000), -- Green Seal Stone
(21171,6362,24,44,4,700000), -- Red Seal Stone
(21172,1825,1,1,-1,172903), -- Recipe: Oriharukon
(21172,1902,1,1,-1,245252), -- Elven Earring Beads
(21172,2145,1,1,-1,172903), -- Recipe: Mithril Alloy
(21172,6360,89,178,0,700000), -- Blue Seal Stone
(21172,88,1,1,1,18), -- Morning Star
(21172,90,1,1,1,18), -- Goat Head Staff
(21172,158,1,1,1,18), -- Tarbar
(21172,169,1,1,1,18), -- Skull Breaker
(21172,172,1,1,1,18), -- Heavy Bone Club
(21172,2031,1,1,1,1267), -- Morning Star Head
(21172,2032,1,1,1,1157), -- Goat Head Staff Head
(21172,2035,1,1,1,1267), -- Tarbar Head
(21172,2036,1,1,1,1267), -- Skull Breaker Head
(21172,2037,1,1,1,1267), -- Heavy Bone Club Head
(21172,1341,60,180,2,139032), -- Bone Arrow
(21172,1866,1,1,2,166838), -- Suede
(21172,1871,2,6,2,62565), -- Charcoal
(21172,1877,1,1,2,10011), -- Adamantite Nugget
(21172,2147,1,1,2,17876), -- Recipe: Blacksmith\'s frame
(21172,6361,105,206,3,700000), -- Green Seal Stone
(21172,6362,24,45,4,700000), -- Red Seal Stone
(21173,1875,1,1,-1,170540), -- Stone of Purity
(21173,1881,1,1,-1,341080), -- Coarse Bone Powder
(21173,1905,1,1,-1,248842), -- Omen Beast\'s Eye Earring Gemstone
(21173,6360,56,111,0,700000), -- Blue Seal Stone
(21173,262,1,1,1,72), -- Scallop Jamadhr
(21173,2053,1,1,1,5311), -- Scallop Jamadhr Edge
(21173,1805,1,1,2,536), -- Recipe: Soulshot: C-Grade
(21173,1867,1,1,2,214094), -- Animal Skin
(21173,1872,1,1,2,214094), -- Animal Bone
(21173,1875,1,1,2,10705), -- Stone of Purity
(21173,1881,1,1,2,21410), -- Coarse Bone Powder
(21173,2990,1,1,2,12744), -- Recipe: Chain Boots
(21173,5164,1,1,2,536), -- Recipe: Blessed Spiritshot (C) Compressed Package (100%)
(21173,6036,1,1,2,5354), -- Greater Magic Haste Potion
(21173,6361,137,274,3,700000), -- Green Seal Stone
(21173,6362,22,41,4,700000), -- Red Seal Stone
(21174,1873,1,3,-1,654639), -- Silver Nugget
(21174,1908,1,1,-1,309962), -- Moonstone Earring Wire
(21174,2163,1,1,-1,167000), -- Recipe: Earring of Protection
(21174,6360,33,62,0,700000), -- Blue Seal Stone
(21174,281,1,1,1,68), -- Crystallized Ice Bow
(21174,2074,1,1,1,5479), -- Crystallized Ice Bow Shaft
(21174,1868,1,3,2,220996), -- Thread
(21174,1873,1,1,2,88398), -- Silver Nugget
(21174,1876,1,1,2,44199), -- Mithril Ore
(21174,1895,1,1,2,63142), -- Metallic Fiber
(21174,2164,1,1,2,17000), -- Recipe: Ring of Protection
(21174,3002,1,1,2,13727), -- Recipe: Dwarven Chain Gloves
(21174,4042,1,1,2,3684), -- Enria
(21174,6361,211,425,3,700000), -- Green Seal Stone
(21174,6362,25,45,4,700000), -- Red Seal Stone
(21175,440,1,1,-1,1053), -- Robe of Seal
(21175,1912,1,1,-1,401114), -- Ring of Protection Gemstone
(21175,4590,1,1,-1,12408), -- Greater Dye of Strength <Str+2 Dex-2>
(21175,227,1,1,1,29), -- Stiletto
(21175,242,1,1,1,29), -- Soulfire Dirk
(21175,2083,1,1,1,2740), -- Stiletto Edge
(21175,2084,1,1,1,2740), -- Soulfire Dirk Blade
(21175,951,1,1,2,429), -- Scroll: Enchant Weapon (Grade C)
(21175,1866,1,1,2,157075), -- Suede
(21175,1871,1,3,2,78538), -- Charcoal
(21175,1877,1,1,2,9425), -- Adamantite Nugget
(21175,4040,1,1,2,4713), -- Mold Lubricant
(21175,4041,1,1,2,2049), -- Mold Hardener
(21175,6037,1,3,2,235612), -- Waking Scroll
(21175,6361,268,532,3,700000), -- Green Seal Stone
(21175,6362,25,45,4,700000), -- Red Seal Stone
(21176,1872,1,11,-1,842436), -- Animal Bone
(21176,4041,1,1,-1,32965), -- Mold Hardener
(21176,4601,1,1,-1,8424), -- Greater Dye of Strength <Str+3 Con-3>
(21176,6360,133,267,0,700000), -- Blue Seal Stone
(21176,326,1,1,1,37), -- Heathen\'s Book
(21176,2110,1,1,1,4419), -- Heathen\'s Book Page
(21176,1864,4,12,2,55990), -- Stem
(21176,1865,2,6,2,44792), -- Varnish
(21176,1866,1,1,2,149306), -- Suede
(21176,1868,1,3,2,149306), -- Thread
(21176,1873,1,1,2,89584), -- Silver Nugget
(21176,2232,1,1,2,1288), -- Recipe: Drake Leather Armor
(21176,3012,1,1,2,4180), -- Recipe: Full Plate Helmet
(21176,6361,219,437,3,700000), -- Green Seal Stone
(21176,6362,11,22,4,700000), -- Red Seal Stone
(21177,1806,1,1,-1,10342), -- Recipe: Soulshot: B-Grade
(21177,1920,1,1,-1,176944), -- Necklace of Binding Chain
(21177,4594,1,1,-1,17237), -- Greater Dye of Dexterity <Dex+2 Con-2>
(21177,6360,148,301,0,700000), -- Blue Seal Stone
(21177,299,1,1,1,11), -- Orcish Poleaxe
(21177,301,1,1,1,14), -- Scorpion
(21177,303,1,1,1,14), -- Widow Maker
(21177,2113,1,1,1,1541), -- Scorpion Blade
(21177,2114,1,1,1,1541), -- Widowmaker Head
(21177,2122,1,1,1,1453), -- Orcish Poleaxe Blade
(21177,1868,1,3,2,238671), -- Thread
(21177,1873,1,1,2,95469), -- Silver Nugget
(21177,1876,1,1,2,47734), -- Mithril Ore
(21177,1895,1,1,2,68192), -- Metallic Fiber
(21177,3034,1,1,2,478), -- Recipe: Spiritshot B
(21177,4042,1,1,2,3978), -- Enria
(21177,4944,1,1,2,1148), -- Recipe: Avadon Breastplate (60%)
(21177,4968,1,1,2,275), -- Recipe: Kris (60%)
(21177,6361,314,633,3,700000), -- Green Seal Stone
(21177,6362,13,27,4,700000), -- Red Seal Stone
(21178,947,1,1,-1,2218), -- Scroll: Enchant Weapon (Grade B)
(21178,4129,1,1,-1,59998), -- Recipe: Earrings of Black Ore
(21178,4610,1,1,-1,12320), -- Greater Dye of Mental Strength <Men+3 Wit-3>
(21178,6360,73,146,0,700000), -- Blue Seal Stone
(21178,2384,1,1,1,35), -- Zubei\'s Leather Shirt
(21178,2388,1,1,1,57), -- Zubei\'s Leather Gaiters
(21178,2390,1,1,1,24), -- Avadon Leather Armor
(21178,4066,1,1,1,6434), -- Zubei\'s Leather Shirt Fabric
(21178,4067,1,1,1,9768), -- Zubei\'s Leather Gaiter Texture
(21178,4068,1,1,1,4943), -- Avadon Leather Armor Lining
(21178,948,1,1,2,512), -- Scroll: Enchant Armor (Grade B)
(21178,1867,1,1,2,272927), -- Animal Skin
(21178,1872,1,3,2,136464), -- Animal Bone
(21178,1875,1,1,2,13647), -- Stone of Purity
(21178,1881,1,1,2,27293), -- Coarse Bone Powder
(21178,4041,1,1,2,1781), -- Mold Hardener
(21178,4162,1,1,2,850), -- Recipe: Tunic of Doom
(21178,5003,1,1,2,157), -- Recipe: Art of Battle Axe (60%)
(21178,6361,391,782,3,700000), -- Green Seal Stone
(21178,6362,13,26,4,700000), -- Red Seal Stone
(21179,947,1,1,-1,2132), -- Scroll: Enchant Weapon (Grade B)
(21179,1872,1,15,-1,888172), -- Animal Bone
(21179,4613,1,1,-1,7350), -- Greater Dye of Strength <Str+4 Con-4>
(21179,6360,7,15,0,700000), -- Blue Seal Stone
(21179,357,1,1,1,19), -- Zubei\'s Breastplate
(21179,383,1,1,1,31), -- Zubei\'s Gaiters
(21179,2376,1,1,1,19), -- Avadon Breastplate
(21179,2379,1,1,1,31), -- Avadon Gaiters
(21179,4056,1,1,1,3561), -- Zubei\'s Breastplate Part
(21179,4057,1,1,1,5504), -- Zubei\'s Gaiter Material
(21179,4064,1,1,1,3561), -- Avadon Breastplate Part
(21179,4065,1,1,1,5504), -- Avadon Gaiters Material
(21179,1343,20,60,2,160624), -- Silver Arrow
(21179,1867,2,6,2,74958), -- Animal Skin
(21179,1872,1,3,2,99944), -- Animal Bone
(21179,1875,1,1,2,14992), -- Stone of Purity
(21179,1881,1,1,2,29983), -- Coarse Bone Powder
(21179,4041,1,1,2,1956), -- Mold Hardener
(21179,4155,1,1,2,699), -- Recipe: Blue Wolf Breastplate
(21179,6361,415,830,3,700000), -- Green Seal Stone
(21179,6362,11,22,4,700000), -- Red Seal Stone
(21180,4052,1,1,-1,266218), -- Earring of Black Ore Piece
(21180,4053,1,1,-1,322303), -- Ring of Black Ore Gemstone
(21180,5230,1,1,-1,10026), -- Recipe: Mithril Arrow (100%)
(21180,2398,1,1,1,24), -- Blue Wolf Tunic
(21180,2399,1,1,1,24), -- Tunic of Doom
(21180,2403,1,1,1,37), -- Blue Wolf Stockings
(21180,2404,1,1,1,37), -- Stockings of Doom
(21180,4084,1,1,1,4824), -- Blue Wolf Tunic Fabric
(21180,4085,1,1,1,4824), -- Tunic of Doom Pattern
(21180,4086,1,1,1,6513), -- Blue Wolf Stockings Pattern
(21180,4087,1,1,1,6513), -- Stockings of Doom Pattern
(21180,1830,1,1,2,148073), -- Scroll of Escape: Castle
(21180,1866,1,3,2,82263), -- Suede
(21180,1871,1,3,2,185092), -- Charcoal
(21180,1877,1,1,2,14808), -- Adamantite Nugget
(21180,4040,1,1,2,7404), -- Mold Lubricant
(21180,4041,1,1,2,3220), -- Mold Hardener
(21180,6361,574,1144,3,700000), -- Green Seal Stone
(21180,6362,14,28,4,700000), -- Red Seal Stone
(21181,4041,1,1,-1,69372), -- Mold Hardener
(21181,4054,1,1,-1,157136), -- Necklace of Black Ore Beads
(21181,5230,1,1,-1,10637), -- Recipe: Mithril Arrow (100%)
(21181,864,1,1,1,86), -- Earring of Black Ore
(21181,895,1,1,1,128), -- Ring of Black Ore
(21181,926,1,1,1,64), -- Necklace of Black Ore
(21181,4052,1,1,1,13904), -- Earring of Black Ore Piece
(21181,4053,1,1,1,16833), -- Ring of Black Ore Gemstone
(21181,4054,1,1,1,7735), -- Necklace of Black Ore Beads
(21181,1867,1,3,2,149621), -- Animal Skin
(21181,1872,1,3,2,224431), -- Animal Bone
(21181,1875,1,1,2,22444), -- Stone of Purity
(21181,1881,1,1,2,44887), -- Coarse Bone Powder
(21181,4041,1,1,2,2928), -- Mold Hardener
(21181,5230,1,1,2,449), -- Recipe: Mithril Arrow (100%)
(21181,5276,1,1,2,449), -- Recipe: Greater Spiritshot (A) Compressed Package(100%)
(21181,6361,578,1160,3,700000), -- Green Seal Stone
(21181,6362,14,27,4,700000), -- Red Seal Stone
(21182,1876,1,3,-1,721648), -- Mithril Ore
(21182,5478,1,1,-1,60684), -- Sealed Dark Crystal Leather Armor Pattern
(21182,5290,1,1,1,46), -- Sealed Dark Crystal Gloves
(21182,5291,1,1,1,46), -- Sealed Dark Crystal Boots
(21182,5295,1,1,1,46), -- Sealed Tallum Gloves
(21182,5296,1,1,1,46), -- Sealed Tallum Boots
(21182,5496,1,1,1,6248), -- Sealed Dark Crystal Boots Lining
(21182,5497,1,1,1,6248), -- Sealed Tallum Boots Lining
(21182,5508,1,1,1,6248), -- Sealed Dark Crystal Gloves Design
(21182,5509,1,1,1,6248), -- Sealed Tallum Gloves Design
(21182,1344,30,90,2,126884), -- Mithril Arrow
(21182,1868,4,12,2,76131), -- Thread
(21182,1873,1,1,2,121809), -- Silver Nugget
(21182,1876,1,1,2,60905), -- Mithril Ore
(21182,1895,1,1,2,87006), -- Metallic Fiber
(21182,4042,1,1,2,5076), -- Enria
(21182,5156,1,1,2,407), -- Recipe: Soulshot (A) Compressed Package (100%)
(21182,6361,512,1023,3,700000), -- Green Seal Stone
(21182,6362,11,22,4,700000), -- Red Seal Stone
(21183,1807,1,1,-1,13420), -- Recipe: Soulshot: A-Grade
(21183,3035,1,1,-1,13420), -- Recipe: Spiritshot A
(21183,5479,1,1,-1,59556), -- Sealed Tallum Leather Armor Pattern
(21183,5289,1,1,1,57), -- Sealed Dark Crystal Helmet
(21183,5292,1,1,1,82), -- Sealed Dark Crystal Shield
(21183,5294,1,1,1,57), -- Sealed Tallum Helmet
(21183,5494,1,1,1,10406), -- Sealed Dark Crystal Shield Fragment
(21183,5525,1,1,1,7660), -- Sealed Dark Crystal Helmet Design
(21183,5526,1,1,1,7660), -- Sealed Tallum Helm Design
(21183,1894,1,1,2,20864), -- Crafted Leather
(21183,3956,1,1,2,793), -- Recipe: Blessed Spiritshot A
(21183,4039,1,1,2,19821), -- Mold Glue
(21183,4041,1,1,2,5171), -- Mold Hardener
(21183,4044,1,1,2,19821), -- Thons
(21183,6361,687,1380,3,700000), -- Green Seal Stone
(21183,6362,14,28,4,700000), -- Red Seal Stone
(21184,729,1,1,-1,1173), -- Scroll: Enchant Weapon (Grade A)
(21184,1895,1,7,-1,753968), -- Metallic Fiber
(21184,5480,1,1,-1,47365), -- Sealed Leather Armor of Nightmare Fabric
(21184,5304,1,1,1,30), -- Sealed Tallum Tunic
(21184,5305,1,1,1,48), -- Sealed Tallum Stockings
(21184,5308,1,1,1,21), -- Sealed Dark Crystal Robe
(21184,5485,1,1,1,4370), -- Sealed Tallum Tunic Texture
(21184,5486,1,1,1,3075), -- Sealed Dark Crystal Robe Fabric
(21184,5489,1,1,1,6858), -- Sealed Tallum Stockings Fabric
(21184,7645,1,1,2,17920), -- Spellbook - Balance Life
(21184,7672,1,1,2,17920), -- Amulet - Chant of Spirit
(21184,7673,1,1,2,17920), -- Amulet - Chant of Victory
(21184,10064,1,1,2,15625), -- Battle Manual: Quiver Of Bolts - Grade S
(21184,6361,700,1400,3,700000), -- Green Seal Stone
(21184,6362,14,27,4,700000), -- Red Seal Stone
(21185,1875,1,1,-1,629418), -- Stone of Purity
(21185,5481,1,1,-1,42365), -- Sealed Majestic Leather Armor Fabric
(21185,5487,1,1,-1,42515), -- Sealed Robe of Nightmare Fabric
(21185,5304,1,1,1,27), -- Sealed Tallum Tunic
(21185,5305,1,1,1,43), -- Sealed Tallum Stockings
(21185,5308,1,1,1,19), -- Sealed Dark Crystal Robe
(21185,5485,1,1,1,3909), -- Sealed Tallum Tunic Texture
(21185,5486,1,1,1,2750), -- Sealed Dark Crystal Robe Fabric
(21185,5489,1,1,1,6135), -- Sealed Tallum Stockings Fabric
(21185,7665,1,1,2,16028), -- Spellbook - Prophecy of Water
(21185,7666,1,1,2,16028), -- Spellbook - Prophecy of Fire
(21185,7667,1,1,2,16028), -- Spellbook - Prophecy of Wind
(21185,6361,612,1227,3,700000), -- Green Seal Stone
(21185,6362,11,22,4,700000), -- Red Seal Stone
(21186,730,1,1,-1,10564), -- Scroll: Enchant Armor (Grade A)
(21186,5480,1,1,-1,56883), -- Sealed Leather Armor of Nightmare Fabric
(21186,5488,1,1,-1,57085), -- Sealed Majestic Robe Fabric
(21186,5312,1,1,1,48), -- Sealed Helm of Nightmare
(21186,5315,1,1,1,68), -- Sealed Shield of Nightmare
(21186,5317,1,1,1,48), -- Sealed Majestic Circlet
(21186,5495,1,1,1,9477), -- Sealed Shield of Nightmare Fragment
(21186,5527,1,1,1,7462), -- Sealed Helm of Nightmare Design
(21186,5528,1,1,1,7462), -- Sealed Majestic Circlet Design
(21186,729,1,1,2,70), -- Scroll: Enchant Weapon (Grade A)
(21186,1866,1,3,2,138687), -- Suede
(21186,1871,1,3,2,312044), -- Charcoal
(21186,1877,1,1,2,24964), -- Adamantite Nugget
(21186,4040,1,1,2,12482), -- Mold Lubricant
(21186,4041,1,1,2,5427), -- Mold Hardener
(21186,6361,805,1610,3,700000), -- Green Seal Stone
(21186,6362,14,28,4,700000), -- Red Seal Stone
(21187,1868,1,3,-1,886728), -- Thread
(21187,1873,1,1,-1,354691), -- Silver Nugget
(21187,1898,1,1,-1,91087), -- Blue Diamond Necklace Gem
(21187,6360,53,109,0,700000), -- Blue Seal Stone
(21187,25,1,1,1,550), -- Piece Bone Breastplate
(21187,26,1,1,1,355), -- Bronze Breastplate
(21187,32,1,1,1,878), -- Piece Bone Gaiters
(21187,34,1,1,1,569), -- Bronze Gaiters
(21187,1926,1,1,1,8819), -- Piece Bone Breastplate Fragment
(21187,1928,1,1,1,12718), -- Piece Bone Gaiters Fragment
(21187,1868,1,1,2,261926), -- Thread
(21187,1873,1,1,2,52386), -- Silver Nugget
(21187,2176,1,1,2,62662), -- Recipe: Leather Boots
(21187,6035,1,1,2,10914), -- Magic Haste Potion
(21187,6362,23,42,4,700000), -- Red Seal Stone
(21188,1804,1,1,-1,39326), -- Recipe: Soulshot: D-Grade
(21188,1926,1,1,-1,99308), -- Piece Bone Breastplate Fragment
(21188,2151,1,1,-1,273857), -- Recipe: Necklace of Devotion
(21188,6360,72,143,0,700000), -- Blue Seal Stone
(21188,1102,1,1,1,1574), -- Tunic of Magic
(21188,1105,1,1,1,2526), -- Stockings of Magic
(21188,735,1,1,2,12101), -- Potion of Alacrity
(21188,1867,1,1,2,193605), -- Animal Skin
(21188,1872,1,1,2,193605), -- Animal Bone
(21188,1882,1,1,2,32268), -- Leather
(21188,6362,21,39,4,700000), -- Red Seal Stone
(21189,1889,1,1,-1,78778), -- Compound Braid
(21189,1899,1,1,-1,184636), -- Necklace of Devotion Chain
(21189,5549,1,1,-1,118167), -- Metallic Thread
(21189,6360,97,190,0,700000), -- Blue Seal Stone
(21189,847,1,1,1,1233), -- Red Crescent Earring
(21189,890,1,1,1,1843), -- Ring of Devotion
(21189,910,1,1,1,924), -- Necklace of Devotion
(21189,1899,1,1,1,25907), -- Necklace of Devotion Chain
(21189,1868,1,1,2,265276), -- Thread
(21189,1873,1,1,2,53056), -- Silver Nugget
(21189,1889,1,1,2,8843), -- Compound Braid
(21189,2262,1,1,2,2060), -- Recipe: Elven Bow
(21189,5549,1,1,2,13264), -- Metallic Thread
(21189,6362,22,41,4,700000), -- Red Seal Stone
(21190,1061,1,1,-1,881783), -- Healing Potion
(21190,1900,1,1,-1,159184), -- Enchanted Necklace Chain
(21190,2153,1,1,-1,226274), -- Recipe: Tiger\'s Eye Earring
(21190,6360,128,259,0,700000), -- Blue Seal Stone
(21190,605,1,1,1,2388), -- Leather Gauntlets
(21190,1123,1,1,1,2388), -- Blue Buckskin Boots
(21190,1864,1,1,2,265023), -- Stem
(21190,1869,1,1,2,132512), -- Iron Ore
(21190,1880,1,1,2,13252), -- Steel
(21190,2153,1,1,2,20609), -- Recipe: Tiger\'s Eye Earring
(21190,5550,1,1,2,1768), -- Durable Metal Plate
(21190,6035,1,1,2,11043), -- Magic Haste Potion
(21190,6362,24,44,4,700000), -- Red Seal Stone
(21191,1901,1,1,-1,222980), -- Tiger\'s Eye Earring Stone
(21191,1938,1,1,-1,108529), -- Mithril Banded Mail Material
(21191,2154,1,1,-1,172845), -- Recipe: Elven Earring
(21191,6360,108,211,0,700000), -- Blue Seal Stone
(21191,47,1,1,1,1127), -- Helmet
(21191,628,1,1,1,1611), -- Hoplon
(21191,1864,1,3,2,171670), -- Stem
(21191,1869,1,1,2,171670), -- Iron Ore
(21191,1880,1,1,2,17167), -- Steel
(21191,2155,1,1,2,27556), -- Recipe: Elven Ring
(21191,5550,1,1,2,2290), -- Durable Metal Plate
(21191,6361,33,63,3,700000), -- Green Seal Stone
(21191,6362,22,41,4,700000), -- Red Seal Stone
(21192,1865,1,5,-1,684631), -- Varnish
(21192,1870,1,5,-1,684631), -- Coal
(21192,1939,1,1,-1,180403), -- Mithril Banded Gaiters Material
(21192,6360,96,192,0,700000), -- Blue Seal Stone
(21192,83,1,1,1,51), -- Sword of Magic
(21192,124,1,1,1,38), -- Two-Handed Sword
(21192,127,1,1,1,38), -- Crimson Sword
(21192,130,1,1,1,38), -- Elven Sword
(21192,144,1,1,1,51), -- Sword of Occult
(21192,2026,1,1,1,2191), -- Two-Handed Sword Edge
(21192,1865,1,1,2,273010), -- Varnish
(21192,1870,1,3,2,136505), -- Coal
(21192,1874,1,1,2,18201), -- Oriharukon Ore
(21192,2191,1,1,2,36548), -- Recipe: RIP Gauntlets
(21192,6361,68,136,3,700000), -- Green Seal Stone
(21192,6362,24,44,4,700000), -- Red Seal Stone
(21193,1825,1,1,-1,172903), -- Recipe: Oriharukon
(21193,1902,1,1,-1,245252), -- Elven Earring Beads
(21193,2145,1,1,-1,172903), -- Recipe: Mithril Alloy
(21193,6360,89,178,0,700000), -- Blue Seal Stone
(21193,88,1,1,1,18), -- Morning Star
(21193,90,1,1,1,18), -- Goat Head Staff
(21193,158,1,1,1,18), -- Tarbar
(21193,169,1,1,1,18), -- Skull Breaker
(21193,172,1,1,1,18), -- Heavy Bone Club
(21193,2031,1,1,1,1267), -- Morning Star Head
(21193,2032,1,1,1,1157), -- Goat Head Staff Head
(21193,2035,1,1,1,1267), -- Tarbar Head
(21193,2036,1,1,1,1267), -- Skull Breaker Head
(21193,2037,1,1,1,1267), -- Heavy Bone Club Head
(21193,7638,1,1,2,26069), -- Spellbook - Mass Summon Storm Cubic
(21193,7639,1,1,2,26069), -- Spellbook - Mass Summon Aqua Cubic
(21193,7640,1,1,2,26069), -- Spellbook - Mass Summon Poltergeist Cubic
(21193,6361,105,206,3,700000), -- Green Seal Stone
(21193,6362,24,45,4,700000), -- Red Seal Stone
(21194,1875,1,1,-1,170540), -- Stone of Purity
(21194,1881,1,1,-1,341080), -- Coarse Bone Powder
(21194,1905,1,1,-1,248842), -- Omen Beast\'s Eye Earring Gemstone
(21194,6360,56,111,0,700000), -- Blue Seal Stone
(21194,262,1,1,1,72), -- Scallop Jamadhr
(21194,2053,1,1,1,5311), -- Scallop Jamadhr Edge
(21194,1805,1,1,2,612), -- Recipe: Soulshot: C-Grade
(21194,1867,2,6,2,61170), -- Animal Skin
(21194,1872,1,3,2,81560), -- Animal Bone
(21194,1875,1,1,2,12234), -- Stone of Purity
(21194,1881,1,1,2,24468), -- Coarse Bone Powder
(21194,2994,1,1,2,14564), -- Recipe: Boots of Seal
(21194,6037,1,3,2,183509), -- Waking Scroll
(21194,6361,137,274,3,700000), -- Green Seal Stone
(21194,6362,22,41,4,700000), -- Red Seal Stone
(21195,440,1,1,-1,926), -- Robe of Seal
(21195,1908,1,1,-1,309962), -- Moonstone Earring Wire
(21195,6360,33,62,0,700000), -- Blue Seal Stone
(21195,281,1,1,1,68), -- Crystallized Ice Bow
(21195,2074,1,1,1,5479), -- Crystallized Ice Bow Shaft
(21195,1868,1,3,2,193370), -- Thread
(21195,1873,1,1,2,77349), -- Silver Nugget
(21195,1876,1,1,2,38674), -- Mithril Ore
(21195,1895,1,1,2,55249), -- Metallic Fiber
(21195,2164,1,1,2,14875), -- Recipe: Ring of Protection
(21195,2228,1,1,2,5255), -- Recipe: Shining Circlet
(21195,4042,1,1,2,3223), -- Enria
(21195,6036,1,1,2,6446), -- Greater Magic Haste Potion
(21195,6361,211,425,3,700000), -- Green Seal Stone
(21195,6362,25,45,4,700000), -- Red Seal Stone
(21196,1911,1,1,-1,276857), -- Earring of Protection Gemstone
(21196,2166,1,1,-1,126181), -- Recipe: Earrings of Binding (100%)
(21196,2167,1,1,-1,189915), -- Recipe: Ring of Ages
(21196,227,1,1,1,29), -- Stiletto
(21196,242,1,1,1,29), -- Soulfire Dirk
(21196,2083,1,1,1,2740), -- Stiletto Edge
(21196,2084,1,1,1,2740), -- Soulfire Dirk Blade
(21196,951,1,1,2,500), -- Scroll: Enchant Weapon (Grade C)
(21196,1866,1,1,2,183255), -- Suede
(21196,1871,1,1,2,274881), -- Charcoal
(21196,1877,1,1,2,10996), -- Adamantite Nugget
(21196,4040,1,1,2,5498), -- Mold Lubricant
(21196,4041,1,1,2,2391), -- Mold Hardener
(21196,6361,268,532,3,700000), -- Green Seal Stone
(21196,6362,25,45,4,700000), -- Red Seal Stone
(21197,1872,1,11,-1,917243), -- Animal Bone
(21197,4041,1,1,-1,35892), -- Mold Hardener
(21197,4603,1,1,-1,9172), -- Greater Dye of Constitution <Con+3 Str-3>
(21197,6360,145,291,0,700000), -- Blue Seal Stone
(21197,326,1,1,1,40), -- Heathen\'s Book
(21197,2110,1,1,1,4811), -- Heathen\'s Book Page
(21197,1867,1,3,2,126439), -- Animal Skin
(21197,1869,2,6,2,71122), -- Iron Ore
(21197,1870,2,6,2,56898), -- Coal
(21197,1871,3,9,2,47415), -- Charcoal
(21197,1872,1,3,2,189658), -- Animal Bone
(21197,2232,1,1,2,1635), -- Recipe: Drake Leather Armor
(21197,6361,238,476,3,700000), -- Green Seal Stone
(21197,6362,12,24,4,700000), -- Red Seal Stone
(21198,1806,1,1,-1,10342), -- Recipe: Soulshot: B-Grade
(21198,1920,1,1,-1,176944), -- Necklace of Binding Chain
(21198,4593,1,1,-1,17237), -- Greater Dye of Dexterity <Dex+2 Str-2>
(21198,6360,148,301,0,700000), -- Blue Seal Stone
(21198,299,1,1,1,11), -- Orcish Poleaxe
(21198,301,1,1,1,14), -- Scorpion
(21198,303,1,1,1,14), -- Widow Maker
(21198,2113,1,1,1,1541), -- Scorpion Blade
(21198,2114,1,1,1,1541), -- Widowmaker Head
(21198,2122,1,1,1,1453), -- Orcish Poleaxe Blade
(21198,1868,1,3,2,238671), -- Thread
(21198,1873,1,1,2,95469), -- Silver Nugget
(21198,1876,1,1,2,47734), -- Mithril Ore
(21198,1895,1,1,2,68192), -- Metallic Fiber
(21198,3034,1,1,2,478), -- Recipe: Spiritshot B
(21198,4042,1,1,2,3978), -- Enria
(21198,4944,1,1,2,1148), -- Recipe: Avadon Breastplate (60%)
(21198,4968,1,1,2,275), -- Recipe: Kris (60%)
(21198,6361,314,633,3,700000), -- Green Seal Stone
(21198,6362,13,27,4,700000), -- Red Seal Stone
(21199,947,1,1,-1,2218), -- Scroll: Enchant Weapon (Grade B)
(21199,4129,1,1,-1,59998), -- Recipe: Earrings of Black Ore
(21199,4611,1,1,-1,12320), -- Greater Dye of Wit <Wit+3 Int-3>
(21199,6360,73,146,0,700000), -- Blue Seal Stone
(21199,2384,1,1,1,35), -- Zubei\'s Leather Shirt
(21199,2388,1,1,1,57), -- Zubei\'s Leather Gaiters
(21199,2390,1,1,1,24), -- Avadon Leather Armor
(21199,4066,1,1,1,6434), -- Zubei\'s Leather Shirt Fabric
(21199,4067,1,1,1,9768), -- Zubei\'s Leather Gaiter Texture
(21199,4068,1,1,1,4943), -- Avadon Leather Armor Lining
(21199,948,1,1,2,585), -- Scroll: Enchant Armor (Grade B)
(21199,1867,1,3,2,103973), -- Animal Skin
(21199,1872,1,3,2,155959), -- Animal Bone
(21199,1875,1,1,2,15596), -- Stone of Purity
(21199,1881,1,1,2,31192), -- Coarse Bone Powder
(21199,4041,1,1,2,2035), -- Mold Hardener
(21199,4163,1,1,2,1550), -- Recipe: Blue Wolf Stockings
(21199,6361,391,782,3,700000), -- Green Seal Stone
(21199,6362,13,26,4,700000), -- Red Seal Stone
(21200,4049,1,1,-1,304340), -- Adamantite Earring Gemstone
(21200,4129,1,1,-1,62795), -- Recipe: Earrings of Black Ore
(21200,4613,1,1,-1,8003), -- Greater Dye of Strength <Str+4 Con-4>
(21200,6360,8,16,0,700000), -- Blue Seal Stone
(21200,357,1,1,1,21), -- Zubei\'s Breastplate
(21200,383,1,1,1,33), -- Zubei\'s Gaiters
(21200,2376,1,1,1,21), -- Avadon Breastplate
(21200,2379,1,1,1,33), -- Avadon Gaiters
(21200,4056,1,1,1,3878), -- Zubei\'s Breastplate Part
(21200,4057,1,1,1,5993), -- Zubei\'s Gaiter Material
(21200,4064,1,1,1,3878), -- Avadon Breastplate Part
(21200,4065,1,1,1,5993), -- Avadon Gaiters Material
(21200,1343,20,60,2,174887), -- Silver Arrow
(21200,1867,2,6,2,81615), -- Animal Skin
(21200,1872,1,3,2,108819), -- Animal Bone
(21200,1875,1,1,2,16323), -- Stone of Purity
(21200,1881,1,1,2,32646), -- Coarse Bone Powder
(21200,4041,1,1,2,2129), -- Mold Hardener
(21200,4155,1,1,2,761), -- Recipe: Blue Wolf Breastplate
(21200,6361,452,904,3,700000), -- Green Seal Stone
(21200,6362,12,24,4,700000), -- Red Seal Stone
(21201,4052,1,1,-1,266218), -- Earring of Black Ore Piece
(21201,4053,1,1,-1,322303), -- Ring of Black Ore Gemstone
(21201,5230,1,1,-1,10026), -- Recipe: Mithril Arrow (100%)
(21201,2398,1,1,1,24), -- Blue Wolf Tunic
(21201,2399,1,1,1,24), -- Tunic of Doom
(21201,2403,1,1,1,37), -- Blue Wolf Stockings
(21201,2404,1,1,1,37), -- Stockings of Doom
(21201,4084,1,1,1,4824), -- Blue Wolf Tunic Fabric
(21201,4085,1,1,1,4824), -- Tunic of Doom Pattern
(21201,4086,1,1,1,6513), -- Blue Wolf Stockings Pattern
(21201,4087,1,1,1,6513), -- Stockings of Doom Pattern
(21201,1830,1,1,2,126920), -- Scroll of Escape: Castle
(21201,1866,1,3,2,70512), -- Suede
(21201,1871,1,3,2,158650), -- Charcoal
(21201,1877,1,1,2,12692), -- Adamantite Nugget
(21201,4040,1,1,2,6347), -- Mold Lubricant
(21201,4041,1,1,2,2760), -- Mold Hardener
(21201,6036,1,1,2,10577), -- Greater Magic Haste Potion
(21201,6361,574,1144,3,700000), -- Green Seal Stone
(21201,6362,14,28,4,700000), -- Red Seal Stone
(21202,4041,1,1,-1,69372), -- Mold Hardener
(21202,4054,1,1,-1,157136), -- Necklace of Black Ore Beads
(21202,5230,1,1,-1,10637), -- Recipe: Mithril Arrow (100%)
(21202,864,1,1,1,86), -- Earring of Black Ore
(21202,895,1,1,1,128), -- Ring of Black Ore
(21202,926,1,1,1,64), -- Necklace of Black Ore
(21202,4052,1,1,1,13904), -- Earring of Black Ore Piece
(21202,4053,1,1,1,16833), -- Ring of Black Ore Gemstone
(21202,4054,1,1,1,7735), -- Necklace of Black Ore Beads
(21202,1867,1,3,2,174557), -- Animal Skin
(21202,1872,4,12,2,65459), -- Animal Bone
(21202,1875,1,1,2,26184), -- Stone of Purity
(21202,1881,1,1,2,52368), -- Coarse Bone Powder
(21202,4041,1,1,2,3416), -- Mold Hardener
(21202,5230,1,1,2,524), -- Recipe: Mithril Arrow (100%)
(21202,6361,578,1160,3,700000), -- Green Seal Stone
(21202,6362,14,27,4,700000), -- Red Seal Stone
(21203,1876,1,3,-1,785729), -- Mithril Ore
(21203,4042,1,1,-1,130955), -- Enria
(21203,5478,1,1,-1,66072), -- Sealed Dark Crystal Leather Armor Pattern
(21203,5290,1,1,1,51), -- Sealed Dark Crystal Gloves
(21203,5291,1,1,1,51), -- Sealed Dark Crystal Boots
(21203,5295,1,1,1,51), -- Sealed Tallum Gloves
(21203,5296,1,1,1,51), -- Sealed Tallum Boots
(21203,5496,1,1,1,6802), -- Sealed Dark Crystal Boots Lining
(21203,5497,1,1,1,6802), -- Sealed Tallum Boots Lining
(21203,5508,1,1,1,6802), -- Sealed Dark Crystal Gloves Design
(21203,5509,1,1,1,6802), -- Sealed Tallum Gloves Design
(21203,1344,150,450,2,27630), -- Mithril Arrow
(21203,1868,4,12,2,82890), -- Thread
(21203,1873,1,1,2,132625), -- Silver Nugget
(21203,1876,1,1,2,66312), -- Mithril Ore
(21203,1895,1,1,2,94732), -- Metallic Fiber
(21203,4042,1,1,2,5527), -- Enria
(21203,5156,1,1,2,443), -- Recipe: Soulshot (A) Compressed Package (100%)
(21203,6361,557,1114,3,700000), -- Green Seal Stone
(21203,6362,12,24,4,700000), -- Red Seal Stone
(21204,1807,1,1,-1,13420), -- Recipe: Soulshot: A-Grade
(21204,3035,1,1,-1,13420), -- Recipe: Spiritshot A
(21204,5479,1,1,-1,59556), -- Sealed Tallum Leather Armor Pattern
(21204,5289,1,1,1,57), -- Sealed Dark Crystal Helmet
(21204,5292,1,1,1,82), -- Sealed Dark Crystal Shield
(21204,5294,1,1,1,57), -- Sealed Tallum Helmet
(21204,5494,1,1,1,10406), -- Sealed Dark Crystal Shield Fragment
(21204,5525,1,1,1,7660), -- Sealed Dark Crystal Helmet Design
(21204,5526,1,1,1,7660), -- Sealed Tallum Helm Design
(21204,1894,1,1,2,20864), -- Crafted Leather
(21204,3956,1,1,2,793), -- Recipe: Blessed Spiritshot A
(21204,4039,1,1,2,19821), -- Mold Glue
(21204,4041,1,1,2,5171), -- Mold Hardener
(21204,4044,1,1,2,19821), -- Thons
(21204,6361,687,1380,3,700000), -- Green Seal Stone
(21204,6362,14,28,4,700000), -- Red Seal Stone
(21205,729,1,1,-1,1173), -- Scroll: Enchant Weapon (Grade A)
(21205,1895,1,7,-1,753968), -- Metallic Fiber
(21205,5480,1,1,-1,47365), -- Sealed Leather Armor of Nightmare Fabric
(21205,5297,1,1,1,30), -- Sealed Dark Crystal Leather Armor
(21205,5298,1,1,1,48), -- Sealed Dark Crystalline Leggings
(21205,5301,1,1,1,21), -- Sealed Tallum Leather Armor
(21205,5478,1,1,1,4370), -- Sealed Dark Crystal Leather Armor Pattern
(21205,5479,1,1,1,3075), -- Sealed Tallum Leather Armor Pattern
(21205,5482,1,1,1,6858), -- Sealed Dark Crystalline Leggings Design
(21205,730,1,1,2,520), -- Scroll: Enchant Armor (Grade A)
(21205,1895,1,1,2,178169), -- Metallic Fiber
(21205,4040,1,1,2,12472), -- Mold Lubricant
(21205,4042,1,1,2,10394), -- Enria
(21205,4043,1,1,2,20787), -- Asofe
(21205,6361,700,1400,3,700000), -- Green Seal Stone
(21205,6362,14,27,4,700000), -- Red Seal Stone
(21206,1875,1,1,-1,685308), -- Stone of Purity
(21206,5481,1,1,-1,46127), -- Sealed Majestic Leather Armor Fabric
(21206,5487,1,1,-1,46290), -- Sealed Robe of Nightmare Fabric
(21206,5287,1,1,1,22), -- Sealed Dark Crystal breastplate
(21206,5288,1,1,1,36), -- Sealed Dark Crystal Gaiters
(21206,5293,1,1,1,15), -- Sealed Tallum Plate Armor
(21206,5520,1,1,1,3264), -- Sealed Dark Crystal Breastplate Pattern
(21206,5521,1,1,1,2304), -- Sealed Tallum Plate Armor Pattern
(21206,5524,1,1,1,4989), -- Sealed Dark Crystal Gaiters Pattern
(21206,7674,1,1,2,13088), -- Amulet - Pa\'agrio\'s Eye
(21206,7675,1,1,2,13088), -- Amulet - Pa\'agrio\'s Soul
(21206,7676,1,1,2,13088), -- Amulet - Seal of Despair
(21206,7835,1,1,2,13088), -- Amulet: Seal of Disease
(21206,6361,666,1336,3,700000), -- Green Seal Stone
(21206,6362,12,24,4,700000), -- Red Seal Stone
(21207,730,1,1,-1,10564), -- Scroll: Enchant Armor (Grade A)
(21207,5480,1,1,-1,56883), -- Sealed Leather Armor of Nightmare Fabric
(21207,5488,1,1,-1,57085), -- Sealed Majestic Robe Fabric
(21207,5312,1,1,1,48), -- Sealed Helm of Nightmare
(21207,5315,1,1,1,68), -- Sealed Shield of Nightmare
(21207,5317,1,1,1,48), -- Sealed Majestic Circlet
(21207,5495,1,1,1,9477), -- Sealed Shield of Nightmare Fragment
(21207,5527,1,1,1,7462), -- Sealed Helm of Nightmare Design
(21207,5528,1,1,1,7462), -- Sealed Majestic Circlet Design
(21207,729,1,1,2,70), -- Scroll: Enchant Weapon (Grade A)
(21207,1866,1,3,2,138687), -- Suede
(21207,1871,1,3,2,312044), -- Charcoal
(21207,1877,1,1,2,24964), -- Adamantite Nugget
(21207,4040,1,1,2,12482), -- Mold Lubricant
(21207,4041,1,1,2,5427), -- Mold Hardener
(21207,6361,805,1610,3,700000), -- Green Seal Stone
(21207,6362,14,28,4,700000), -- Red Seal Stone
(21208,734,1,1,-1,131730), -- Haste Potion
(21208,1871,1,1,-1,790380), -- Charcoal
(21208,1897,1,1,-1,188186), -- Necklace of Wisdom Chain
(21208,57,365,635,0,700000), -- Adena
(21208,38,1,1,1,4599), -- Low Boots
(21208,50,1,1,1,4599), -- Leather Gloves
(21208,1925,1,1,1,102062), -- Leather Gloves Lining
(21208,734,1,1,2,25941), -- Haste Potion
(21208,1866,1,1,2,103763), -- Suede
(21208,1871,1,1,2,155644), -- Charcoal
(21209,1804,1,1,-1,36013), -- Recipe: Soulshot: D-Grade
(21209,1898,1,1,-1,92484), -- Blue Diamond Necklace Gem
(21209,2151,1,1,-1,250789), -- Recipe: Necklace of Devotion
(21209,57,409,734,0,700000), -- Adena
(21209,625,1,1,1,4124), -- Bone Shield
(21209,1148,1,1,1,2891), -- Hard Leather Helmet
(21209,734,1,1,2,29550), -- Haste Potion
(21209,1865,1,1,2,177297), -- Varnish
(21209,1870,1,1,2,177297), -- Coal
(21210,1866,1,1,-1,733287), -- Suede
(21210,1877,1,1,-1,43997), -- Adamantite Nugget
(21210,1899,1,1,-1,171864), -- Necklace of Devotion Chain
(21210,57,484,907,0,700000), -- Adena
(21210,123,1,1,1,76), -- Saber
(21210,2017,1,1,1,2051), -- Saber Blade
(21210,5285,1,1,1,76), -- Heavy Sword
(21210,5531,1,1,1,2592), -- Heavy Sword Edge
(21210,1866,1,1,2,102886), -- Suede
(21210,1871,1,1,2,154329), -- Charcoal
(21210,1877,1,1,2,6174), -- Adamantite Nugget
(21210,2182,1,1,2,18527), -- Recipe: Scale Gaiters
(21211,1931,1,1,-1,150011), -- Leather Boot Lining
(21211,1932,1,1,-1,182156), -- Bone Helmet Design
(21211,2152,1,1,-1,202039), -- Recipe: Enchanted Necklace
(21211,57,495,955,0,700000), -- Adena
(21211,156,1,1,1,105), -- Hand Axe
(21211,167,1,1,1,105), -- Scalpel
(21211,178,1,1,1,106), -- Bone Staff
(21211,1867,1,1,2,171750), -- Animal Skin
(21211,1872,1,1,2,171750), -- Animal Bone
(21211,1875,1,1,2,8588), -- Stone of Purity
(21211,1881,1,1,2,17175), -- Coarse Bone Powder
(21211,5437,1,1,2,3150), -- Recipe: Heavy Sword(100%)
(21213,1900,1,1,-1,162437), -- Enchanted Necklace Chain
(21213,2153,1,1,-1,230897), -- Recipe: Tiger\'s Eye Earring
(21213,57,626,1255,0,700000), -- Adena
(21213,275,1,1,1,84), -- Long Bow
(21213,276,1,1,1,84), -- Elven Bow
(21213,2024,1,1,1,3853), -- Elven Bow Shaft
(21213,1061,1,1,2,98341), -- Healing Potion
(21213,1864,3,9,2,54088), -- Stem
(21213,1869,1,1,2,162263), -- Iron Ore
(21213,1878,1,1,2,64906), -- Braided Hemp
(21213,1884,1,1,2,99855), -- Cord
(21214,1865,1,3,-1,924982), -- Varnish
(21214,1875,1,1,-1,123331), -- Stone of Purity
(21214,1901,1,1,-1,255520), -- Tiger\'s Eye Earring Stone
(21214,57,781,1559,0,700000), -- Adena
(21214,223,1,1,1,41), -- Kukuri
(21214,238,1,1,1,41), -- Dagger of Mana
(21214,239,1,1,1,41), -- Mystic Knife
(21214,241,1,1,1,41), -- Shilen Knife
(21214,2028,1,1,1,2338), -- Shilen Knife Edge
(21214,1865,1,1,2,196723), -- Varnish
(21214,1870,1,1,2,196723), -- Coal
(21214,1875,1,1,2,13115), -- Stone of Purity
(21214,1879,1,1,2,32787), -- Cokes
(21214,2189,1,1,2,8783), -- Recipe: Mithril Tunic
(21215,1825,1,1,-1,139345), -- Recipe: Oriharukon
(21215,1902,1,1,-1,197653), -- Elven Earring Beads
(21215,2145,1,1,-1,139345), -- Recipe: Mithril Alloy
(21215,57,824,1645,0,700000), -- Adena
(21215,318,1,1,1,73), -- Crucifix of Blood
(21215,2042,1,1,1,4659), -- Crucifix of Blood Piece
(21215,1825,1,1,2,12006), -- Recipe: Oriharukon
(21215,1866,1,1,2,112048), -- Suede
(21215,1871,1,1,2,168072), -- Charcoal
(21215,1885,1,1,2,14006), -- High Grade Suede
(21215,5220,1,1,2,6723), -- Metal Hardener
(21215,5473,1,1,2,12005), -- Recipe: Durable Metal Plate(100%)
(21217,1868,1,11,-1,831781), -- Thread
(21217,1889,1,1,-1,166356), -- Compound Braid
(21217,1905,1,1,-1,242738), -- Omen Beast\'s Eye Earring Gemstone
(21217,57,1020,2061,0,700000), -- Adena
(21217,396,1,1,1,293), -- Salamander Skin Mail
(21217,1952,1,1,1,20068), -- Salamander Skin Mail Texture
(21217,1868,1,3,2,208842), -- Thread
(21217,1873,1,1,2,83537), -- Silver Nugget
(21217,1889,1,1,2,13923), -- Compound Braid
(21217,2161,1,1,2,20277), -- Recipe: Aquastone Ring
(21217,2993,1,1,2,16575), -- Recipe: Dwarven Chain Boots
(21217,5549,1,1,2,20884), -- Metallic Thread
(21218,1908,1,1,-1,286241), -- Moonstone Earring Wire
(21218,1909,1,1,-1,408198), -- Aquastone Ring Wire
(21218,2163,1,1,-1,154220), -- Recipe: Earring of Protection
(21218,57,1220,2478,0,700000), -- Adena
(21218,354,1,1,1,142), -- Chain Mail Shirt
(21218,381,1,1,1,227), -- Chain Gaiters
(21218,1959,1,1,1,9622), -- Chain Mail Shirt Material
(21218,1960,1,1,1,19572), -- Chain Gaiters Part
(21218,1864,1,3,2,238097), -- Stem
(21218,1869,1,3,2,79366), -- Iron Ore
(21218,1880,1,1,2,23810), -- Steel
(21218,2213,1,1,2,3698), -- Recipe: Dwarven Chain Mail Shirt
(21218,4043,1,1,2,7937), -- Asofe
(21218,5550,1,1,2,3175), -- Durable Metal Plate
(21219,1911,1,1,-1,232505), -- Earring of Protection Gemstone
(21219,1912,1,1,-1,336857), -- Ring of Protection Gemstone
(21219,2166,1,1,-1,105967), -- Recipe: Earrings of Binding (100%)
(21219,57,1258,2567,0,700000), -- Adena
(21219,440,1,1,1,196), -- Robe of Seal
(21219,1970,1,1,1,15466), -- Robe of Seal Fabric
(21219,5812,1,1,2,25650), -- Spellbook: Servitor Empowerment
(21219,5813,1,1,2,43284), -- Spellbook: Servitor Cure
(21219,10204,1,1,2,19608), -- Battle Manual: Soul Gathering
(21221,1867,1,11,-1,854850), -- Animal Skin
(21221,1872,1,11,-1,854850), -- Animal Bone
(21221,4605,1,1,-1,8548), -- Greater Dye of Dexterity <Dex+3 Str-3>
(21221,57,1558,3150,0,700000), -- Adena
(21221,64,1,1,1,325), -- Composite Boots
(21221,608,1,1,1,325), -- Mithril Gauntlets
(21221,1981,1,1,1,23394), -- Mithril Gauntlets Design
(21221,2956,1,1,1,23394), -- Composite Boots Part
(21221,1342,30,90,2,106054), -- Fine Steel Arrow
(21221,1867,2,6,2,42422), -- Animal Skin
(21221,1872,2,6,2,53028), -- Animal Bone
(21221,1875,1,1,2,10606), -- Stone of Purity
(21221,1881,1,1,2,21211), -- Coarse Bone Powder
(21221,2234,1,1,2,2371), -- Recipe: Divine Stockings
(21221,3955,1,1,2,319), -- Recipe: Blessed Spiritshot B
(21221,4041,1,1,2,1384), -- Mold Hardener
(21221,5280,1,1,2,319), -- Recipe: Greater Blessed Spiritshot (B) Compressed Package(100%)
(21221,6037,1,3,2,159082), -- Waking Scroll
(21222,1806,1,1,-1,9118), -- Recipe: Soulshot: B-Grade
(21222,1920,1,1,-1,155991), -- Necklace of Binding Chain
(21222,4126,1,1,-1,75228), -- Recipe: Adamantite Earrings
(21222,57,1837,3743,0,700000), -- Adena
(21222,2414,1,1,1,158), -- Full Plate Helmet
(21222,2497,1,1,1,225), -- Full Plate Shield
(21222,2959,1,1,1,14556), -- Full Plate Helmet Design
(21222,2966,1,1,1,23027), -- Full Plate Shield Fragment
(21222,1868,1,3,2,210408), -- Thread
(21222,1873,1,1,2,84164), -- Silver Nugget
(21222,1876,1,1,2,42082), -- Mithril Ore
(21222,1895,1,1,2,60117), -- Metallic Fiber
(21222,4042,1,1,2,3507), -- Enria
(21222,4126,1,1,2,3472), -- Recipe: Adamantite Earrings
(21222,4183,1,1,2,243), -- Recipe: Heavy War Axe
(21222,4965,1,1,2,243), -- Recipe: Sprite\'s Staff (60%)
(21223,4049,1,1,-1,244718), -- Adamantite Earring Gemstone
(21223,4129,1,1,-1,50493), -- Recipe: Earrings of Black Ore
(21223,4603,1,1,-1,10368), -- Greater Dye of Constitution <Con+3 Str-3>
(21223,57,1877,3833,0,700000), -- Adena
(21223,78,1,1,1,6), -- Great Sword
(21223,142,1,1,1,6), -- Keshanberk
(21223,148,1,1,1,6), -- Sword of Valhalla
(21223,4104,1,1,1,1314), -- Great Sword Blade
(21223,4107,1,1,1,1294), -- Keshanberk Blade
(21223,4108,1,1,1,1294), -- Sword of Valhalla Blade
(21223,1868,1,3,2,196876), -- Thread
(21223,1873,1,1,2,78751), -- Silver Nugget
(21223,1876,1,1,2,39375), -- Mithril Ore
(21223,1895,1,1,2,56251), -- Metallic Fiber
(21223,4042,1,1,2,3282), -- Enria
(21223,4130,1,1,2,3196), -- Recipe: Ring of Black Ore
(21223,4182,1,1,2,227), -- Recipe: Great Sword
(21224,1894,1,1,-1,178820), -- Crafted Leather
(21224,4039,1,1,-1,169879), -- Mold Glue
(21224,4613,1,1,-1,7029), -- Greater Dye of Strength <Str+4 Con-4>
(21224,57,2056,4180,0,700000), -- Adena
(21224,91,1,1,1,9), -- Heavy War Axe
(21224,92,1,1,1,9), -- Sprite\'s Staff
(21224,4105,1,1,1,2154), -- Heavy War Axe Head
(21224,4106,1,1,1,2119), -- Sprite\'s Staff Head
(21224,1343,10,30,2,358432), -- Silver Arrow
(21224,1894,1,1,2,8804), -- Crafted Leather
(21224,4039,1,1,2,8364), -- Mold Glue
(21224,4041,1,1,2,2182), -- Mold Hardener
(21224,4044,1,1,2,8364), -- Thons
(21224,4158,1,1,2,533), -- Recipe: Doom Plate Armor
(21225,4052,1,1,-1,197496), -- Earring of Black Ore Piece
(21225,4053,1,1,-1,239104), -- Ring of Black Ore Gemstone
(21225,5230,1,1,-1,7438), -- Recipe: Mithril Arrow (100%)
(21225,57,2256,4571,0,700000), -- Adena
(21225,2391,1,1,1,24), -- Blue Wolf Leather Armor
(21225,2392,1,1,1,24), -- Leather Armor of Doom
(21225,4082,1,1,1,4654), -- Blue Wolf Leather Armor Texture
(21225,4083,1,1,1,4654), -- Leather Armor of Doom Design
(21225,6350,1,1,2,18940), -- Amulet: Pa\'agrio\'s Honor 
(21225,6352,1,1,2,18940), -- Spellbook: Prayer
(21225,10039,1,1,2,9009), -- Battle Manual: Contagion
(21225,10195,1,1,2,8065), -- Battle Manual: Mental Impoverish
(21226,4052,1,1,-1,230702), -- Earring of Black Ore Piece
(21226,4054,1,1,-1,128347), -- Necklace of Black Ore Beads
(21226,5230,1,1,-1,8688), -- Recipe: Mithril Arrow (100%)
(21226,57,2634,5340,0,700000), -- Adena
(21226,79,1,1,1,15), -- Sword of Damascus
(21226,4114,1,1,1,4213), -- Sword of Damascus Blade
(21226,1867,1,3,2,213865), -- Animal Skin
(21226,1872,1,3,2,142577), -- Animal Bone
(21226,1882,1,1,2,71289), -- Leather
(21226,1894,1,1,2,11256), -- Crafted Leather
(21226,4042,1,1,2,5347), -- Enria
(21226,5230,1,1,2,428), -- Recipe: Mithril Arrow (100%)
(21227,4077,1,1,-1,314447), -- Doom Shield Fragment
(21227,5230,1,1,-1,9320), -- Recipe: Mithril Arrow (100%)
(21227,5549,1,1,-1,699015), -- Metallic Thread
(21227,57,2811,5744,0,700000), -- Adena
(21227,287,1,1,1,16), -- Bow of Peril
(21227,4121,1,1,1,4497), -- Bow of Peril Shaft
(21227,1868,3,9,2,114711), -- Thread
(21227,1873,1,1,2,137653), -- Silver Nugget
(21227,1889,1,1,2,22943), -- Compound Braid
(21227,4044,1,1,2,11471), -- Thons
(21227,5230,1,1,2,459), -- Recipe: Mithril Arrow (100%)
(21227,5549,1,1,2,34414), -- Metallic Thread
(21227,10193,1,1,2,9174), -- Battle Manual: Weak Constitution
(21228,1807,1,1,-1,9504), -- Recipe: Soulshot: A-Grade
(21228,3035,1,1,-1,9504), -- Recipe: Spiritshot A
(21228,5478,1,1,-1,59940), -- Sealed Dark Crystal Leather Armor Pattern
(21228,57,2875,5849,0,700000), -- Adena
(21228,5287,1,1,1,16), -- Sealed Dark Crystal breastplate
(21228,5288,1,1,1,25), -- Sealed Dark Crystal Gaiters
(21228,5293,1,1,1,11), -- Sealed Tallum Plate Armor
(21228,5520,1,1,1,2264), -- Sealed Dark Crystal Breastplate Pattern
(21228,5521,1,1,1,1597), -- Sealed Tallum Plate Armor Pattern
(21228,5524,1,1,1,3460), -- Sealed Dark Crystal Gaiters Pattern
(21228,1866,1,1,2,233946), -- Suede
(21228,1871,1,3,2,175459), -- Charcoal
(21228,1885,1,1,2,29244), -- High Grade Suede
(21228,4041,1,1,2,3052), -- Mold Hardener
(21228,5220,1,1,2,14037), -- Metal Hardener
(21228,5271,1,1,2,468), -- Recipe: Greater Soulshot (A) Compressed Package(100%)
(21229,4041,1,1,-1,67208), -- Mold Hardener
(21229,4044,1,1,-1,257630), -- Thons
(21229,5479,1,1,-1,45733), -- Sealed Tallum Leather Armor Pattern
(21229,57,3110,6350,0,700000), -- Adena
(21229,6323,1,1,1,44), -- Sealed Phoenix Necklace
(21229,6324,1,1,1,59), -- Sealed Phoenix Earring
(21229,6325,1,1,1,88), -- Sealed Phoenix Ring
(21229,6341,1,1,1,10525), -- Sealed Phoenix Earring Gemstone
(21229,6343,1,1,1,8136), -- Sealed Phoenix Necklace Beads
(21229,6345,1,1,1,14557), -- Sealed Phoenix Ring Gemstone
(21229,1894,1,1,2,16021), -- Crafted Leather
(21229,4039,1,1,2,15220), -- Mold Glue
(21229,4041,1,1,2,3971), -- Mold Hardener
(21229,4044,1,1,2,15220), -- Thons
(21229,5161,1,1,2,609), -- Recipe: Spiritshot (A) Compressed Package (100%)
(21230,5480,1,1,-1,39987), -- Sealed Leather Armor of Nightmare Fabric
(21230,5481,1,1,-1,39987), -- Sealed Majestic Leather Armor Fabric
(21230,5487,1,1,-1,40128), -- Sealed Robe of Nightmare Fabric
(21230,57,3587,7319,0,700000), -- Adena
(21230,5289,1,1,1,51), -- Sealed Dark Crystal Helmet
(21230,5292,1,1,1,72), -- Sealed Dark Crystal Shield
(21230,5294,1,1,1,51), -- Sealed Tallum Helmet
(21230,5494,1,1,1,9213), -- Sealed Dark Crystal Shield Fragment
(21230,5525,1,1,1,6782), -- Sealed Dark Crystal Helmet Design
(21230,5526,1,1,1,6782), -- Sealed Tallum Helm Design
(21230,730,1,1,2,439), -- Scroll: Enchant Armor (Grade A)
(21230,1895,1,1,2,150414), -- Metallic Fiber
(21230,4040,1,1,2,10529), -- Mold Lubricant
(21230,4042,1,1,2,8775), -- Enria
(21230,4043,1,1,2,17549), -- Asofe
(21231,729,1,1,-1,995), -- Scroll: Enchant Weapon (Grade A)
(21231,1875,1,1,-1,597002), -- Stone of Purity
(21231,5480,1,1,-1,40183), -- Sealed Leather Armor of Nightmare Fabric
(21231,57,3602,7359,0,700000), -- Adena
(21231,5289,1,1,1,51), -- Sealed Dark Crystal Helmet
(21231,5292,1,1,1,73), -- Sealed Dark Crystal Shield
(21231,5294,1,1,1,51), -- Sealed Tallum Helmet
(21231,5494,1,1,1,9259), -- Sealed Dark Crystal Shield Fragment
(21231,5525,1,1,1,6815), -- Sealed Dark Crystal Helmet Design
(21231,5526,1,1,1,6815), -- Sealed Tallum Helm Design
(21231,729,1,1,2,49), -- Scroll: Enchant Weapon (Grade A)
(21231,1867,1,3,2,195940), -- Animal Skin
(21231,1872,4,12,2,73478), -- Animal Bone
(21231,1875,1,1,2,29391), -- Stone of Purity
(21231,1881,1,1,2,58782), -- Coarse Bone Powder
(21231,4041,1,1,2,3834), -- Mold Hardener
(21236,1061,1,1,-1,784398), -- Healing Potion
(21236,1900,1,1,-1,141604), -- Enchanted Necklace Chain
(21236,2153,1,1,-1,201284), -- Recipe: Tiger\'s Eye Earring
(21236,57,546,1092,0,700000), -- Adena
(21236,69,1,1,1,44), -- Bastard Sword
(21236,125,1,1,1,44), -- Spinebone Sword
(21236,126,1,1,1,44), -- Artisan\'s Sword
(21236,128,1,1,1,44), -- Knight\'s Sword
(21236,2021,1,1,1,1787), -- Spinebone Sword Blade
(21236,1867,1,3,2,117878), -- Animal Skin
(21236,1872,1,1,2,235755), -- Animal Bone
(21236,1882,1,1,2,39293), -- Leather
(21236,2184,1,1,2,18574), -- Recipe: Mithril Banded Gaiters
(21237,1933,1,1,-1,174667), -- Dark Stocking Fabric
(21237,1935,1,1,-1,82942), -- Scale Mail Fragment
(21237,2183,1,1,-1,97676), -- Recipe: Mithril Banded Mail
(21237,57,626,1255,0,700000), -- Adena
(21237,86,1,1,1,26), -- Tomahawk
(21237,179,1,1,1,26), -- Mace of Prayer
(21237,180,1,1,1,26), -- Mace of Judgment
(21237,181,1,1,1,26), -- Mace of Miracle
(21237,182,1,1,1,26), -- Doom Hammer
(21237,183,1,1,1,26), -- Mystic Staff
(21237,184,1,1,1,26), -- Conjuror\'s Staff
(21237,185,1,1,1,26), -- Staff of Mana
(21237,2022,1,1,1,1264), -- Mace of Judgment Head
(21237,2023,1,1,1,1006), -- Conjuror\'s Staff Head
(21237,1868,1,3,2,135220), -- Thread
(21237,1873,1,1,2,54088), -- Silver Nugget
(21237,1889,1,1,2,9015), -- Compound Braid
(21237,2265,1,1,2,1399), -- Recipe: Spiked Club
(21237,5549,1,1,2,13522), -- Metallic Thread
(21237,6037,1,1,2,270440), -- Waking Scroll
(21238,1878,1,1,-1,739986), -- Braided Hemp
(21238,1884,1,3,-1,569220), -- Cord
(21238,1901,1,1,-1,255520), -- Tiger\'s Eye Earring Stone
(21238,57,781,1559,0,700000), -- Adena
(21238,260,1,1,1,203), -- Triple-Edged Jamadhr
(21238,1341,20,60,2,234192), -- Bone Arrow
(21238,1874,1,1,2,9368), -- Oriharukon Ore
(21238,1878,1,1,2,56206), -- Braided Hemp
(21238,1884,1,1,2,86472), -- Cord
(21238,1889,1,1,2,9368), -- Compound Braid
(21238,2190,1,1,2,10037), -- Recipe: Mithril Stockings
(21238,5220,1,1,2,5621), -- Metal Hardener
(21239,1825,1,1,-1,139345), -- Recipe: Oriharukon
(21239,1902,1,1,-1,197653), -- Elven Earring Beads
(21239,2145,1,1,-1,139345), -- Recipe: Mithril Alloy
(21239,57,824,1645,0,700000), -- Adena
(21239,279,1,1,1,73), -- Strengthened Long Bow
(21239,2040,1,1,1,5834), -- Strengthened Long Bow Shaft
(21239,1865,1,1,2,168072), -- Varnish
(21239,1870,1,1,2,168072), -- Coal
(21239,1874,1,1,2,11205), -- Oriharukon Ore
(21239,2145,1,1,2,12005), -- Recipe: Mithril Alloy
(21239,2208,1,1,2,17186), -- Recipe: Ogre Power Gauntlets
(21239,6036,1,1,2,5603), -- Greater Magic Haste Potion
(21240,1866,1,3,-1,741221), -- Suede
(21240,1871,1,5,-1,741221), -- Charcoal
(21240,1903,1,1,-1,370920), -- Elven Ring Piece
(21240,57,932,1861,0,700000), -- Adena
(21240,224,1,1,1,42), -- Maingauche
(21240,1660,1,1,1,42), -- Cursed Maingauche
(21240,2038,1,1,1,3037), -- Maingauche Edge
(21240,2044,1,1,1,3037), -- Cursed Maingauche Edge
(21240,1341,60,180,2,159648), -- Bone Arrow
(21240,1866,1,1,2,191577), -- Suede
(21240,1871,2,6,2,71842), -- Charcoal
(21240,1877,1,1,2,11495), -- Adamantite Nugget
(21241,1805,1,1,-1,8318), -- Recipe: Soulshot: C-Grade
(21241,1905,1,1,-1,242738), -- Omen Beast\'s Eye Earring Gemstone
(21241,4469,1,1,-1,14259), -- Dye of Strength <Str+1 Con-1>
(21241,57,1020,2061,0,700000), -- Adena
(21241,396,1,1,1,293), -- Salamander Skin Mail
(21241,1952,1,1,1,20068), -- Salamander Skin Mail Texture
(21241,1867,1,1,2,238676), -- Animal Skin
(21241,1872,1,3,2,119338), -- Animal Bone
(21241,1875,1,1,2,11934), -- Stone of Purity
(21241,1881,1,1,2,23868), -- Coarse Bone Powder
(21241,2162,1,1,2,8648), -- Recipe: Aquastone Necklace
(21241,2206,1,1,2,4723), -- Recipe: Mithril Shirt
(21241,2990,1,1,2,14207), -- Recipe: Chain Boots
(21242,1908,1,1,-1,286241), -- Moonstone Earring Wire
(21242,1909,1,1,-1,408198), -- Aquastone Ring Wire
(21242,2163,1,1,-1,154220), -- Recipe: Earring of Protection
(21242,57,1220,2478,0,700000), -- Adena
(21242,96,1,1,1,21), -- Scythe
(21242,298,1,1,1,21), -- Orcish Glaive
(21242,302,1,1,1,21), -- Body Slasher
(21242,2062,1,1,1,1868), -- Scythe Edge
(21242,2075,1,1,1,1868), -- Orcish Glaive Blade
(21242,2076,1,1,1,1868), -- Body Slasher Blade
(21242,1868,1,3,2,238096), -- Thread
(21242,1873,1,1,2,95239), -- Silver Nugget
(21242,1876,1,1,2,47620), -- Mithril Ore
(21242,1895,1,1,2,68028), -- Metallic Fiber
(21242,2214,1,1,2,5908), -- Recipe: Dwarven Chain Gaiters
(21242,4042,1,1,2,3969), -- Enria
(21243,951,1,1,-1,5684), -- Scroll: Enchant Weapon (Grade C)
(21243,1911,1,1,-1,232505), -- Earring of Protection Gemstone
(21243,2166,1,1,-1,105967), -- Recipe: Earrings of Binding (100%)
(21243,57,1258,2567,0,700000), -- Adena
(21243,398,1,1,1,78), -- Plated Leather
(21243,399,1,1,1,72), -- Rind Leather Armor
(21243,418,1,1,1,125), -- Plated Leather Gaiters
(21243,419,1,1,1,115), -- Rind Leather Gaiters
(21243,1966,1,1,1,6321), -- Plated Leather Fragment
(21243,1967,1,1,1,9442), -- Plated Leather Gaiters Material
(21243,1975,1,1,1,5687), -- Rind Leather Armor Design
(21243,1976,1,1,1,10527), -- Rind Leather Gaiters Material
(21243,951,1,1,2,420), -- Scroll: Enchant Weapon (Grade C)
(21243,1868,1,3,2,230846), -- Thread
(21243,1873,1,1,2,92339), -- Silver Nugget
(21243,1876,1,1,2,46170), -- Mithril Ore
(21243,1895,1,1,2,65956), -- Metallic Fiber
(21243,4042,1,1,2,3848), -- Enria
(21244,1539,1,1,-1,773226), -- Greater Healing Potion
(21244,1914,1,1,-1,195478), -- Earring of Binding Gemstone
(21244,4601,1,1,-1,7732), -- Greater Dye of Strength <Str+3 Con-3>
(21244,57,1404,2854,0,700000), -- Adena
(21244,60,1,1,1,100), -- Composite Armor
(21244,1977,1,1,1,10643), -- Composite Armor Temper
(21244,1865,1,1,2,205560), -- Varnish
(21244,1870,1,1,2,205560), -- Coal
(21244,1875,1,1,2,13704), -- Stone of Purity
(21244,1879,1,1,2,34260), -- Cokes
(21244,2170,1,1,2,4848), -- Recipe: Nassen\'s Earring
(21244,2970,1,1,2,7290), -- Recipe: Ring of Binding
(21244,4040,1,1,2,4112), -- Mold Lubricant
(21245,1915,1,1,-1,338927), -- Ring of Ages Gemstone
(21245,2169,1,1,-1,68085), -- Recipe: Necklace of Binding
(21245,2170,1,1,-1,90727), -- Recipe: Nassen\'s Earring
(21245,57,1558,3150,0,700000), -- Adena
(21245,60,1,1,1,111), -- Composite Armor
(21245,1977,1,1,1,11766), -- Composite Armor Temper
(21245,1866,1,1,2,151506), -- Suede
(21245,1871,1,1,2,227259), -- Charcoal
(21245,1877,1,1,2,9091), -- Adamantite Nugget
(21245,2353,1,1,2,371), -- Recipe: Samurai Longsword
(21245,4040,1,1,2,4546), -- Mold Lubricant
(21245,4041,1,1,2,1977), -- Mold Hardener
(21245,4122,1,1,2,10101), -- Recipe: Maestro Holder
(21246,1867,1,13,-1,868351), -- Animal Skin
(21246,1918,1,1,-1,197438), -- Nassen\'s Earring Gemstone
(21246,4042,1,1,-1,75981), -- Enria
(21246,57,1837,3743,0,700000), -- Adena
(21246,119,1,1,1,100), -- Necklace of Binding
(21246,855,1,1,1,133), -- Nassen\'s Earring
(21246,886,1,1,1,199), -- Ring of Binding
(21246,1918,1,1,1,12150), -- Nassen\'s Earring Gemstone
(21246,1920,1,1,1,9599), -- Necklace of Binding Chain
(21246,2917,1,1,1,16113), -- Ring of Binding Gemstone
(21246,1867,1,3,2,140273), -- Animal Skin
(21246,1872,1,1,2,280545), -- Animal Bone
(21246,1882,1,1,2,46758), -- Leather
(21246,1894,1,1,2,7383), -- Crafted Leather
(21246,4042,1,1,2,3507), -- Enria
(21246,4127,1,1,2,5209), -- Recipe: Adamantite Ring
(21246,4183,1,1,2,243), -- Recipe: Heavy War Axe
(21246,4965,1,1,2,243), -- Recipe: Sprite\'s Staff (60%)
(21247,4049,1,1,-1,244718), -- Adamantite Earring Gemstone
(21247,4129,1,1,-1,50493), -- Recipe: Earrings of Black Ore
(21247,4613,1,1,-1,6435), -- Greater Dye of Strength <Str+4 Con-4>
(21247,57,1877,3833,0,700000), -- Adena
(21247,554,1,1,1,67), -- Zubei\'s Boots
(21247,600,1,1,1,67), -- Avadon Boots
(21247,612,1,1,1,67), -- Zubei\'s Gauntlets
(21247,2464,1,1,1,67), -- Avadon Gloves
(21247,4073,1,1,1,8963), -- Avadon Gloves Part
(21247,4097,1,1,1,8963), -- Zubei\'s Boots Design
(21247,4098,1,1,1,8963), -- Avadon Boots Design
(21247,4100,1,1,1,8963), -- Zubei\'s Gauntlets Part
(21247,1867,1,1,2,262502), -- Animal Skin
(21247,1872,1,3,2,131251), -- Animal Bone
(21247,1875,1,1,2,13125), -- Stone of Purity
(21247,1881,1,1,2,26250), -- Coarse Bone Powder
(21247,4041,1,1,2,1713), -- Mold Hardener
(21247,4131,1,1,2,1601), -- Recipe: Necklace of Black Ore
(21247,4173,1,1,2,2450), -- Recipe: Blue Wolf Gloves
(21248,4050,1,1,-1,315761), -- Adamantite Ring Wire
(21248,4051,1,1,-1,197649), -- Adamantite Necklace Chain
(21248,4130,1,1,-1,82733), -- Recipe: Ring of Black Ore
(21248,57,2056,4180,0,700000), -- Adena
(21248,503,1,1,1,49), -- Zubei\'s Helmet
(21248,633,1,1,1,70), -- Zubei\'s Shield
(21248,673,1,1,1,70), -- Avadon Shield
(21248,2415,1,1,1,49), -- Avadon Circlet
(21248,4072,1,1,1,8454), -- Avadon Circlet Pattern
(21248,4101,1,1,1,10911), -- Zubei\'s Shield Fragment
(21248,4102,1,1,1,8453), -- Zubei\'s Helmet Design
(21248,4439,1,1,1,12980), -- Avadon Shield Fragment
(21248,1864,1,3,2,215056), -- Stem
(21248,1869,1,1,2,215056), -- Iron Ore
(21248,1880,1,1,2,21506), -- Steel
(21248,4043,1,1,2,7169), -- Asofe
(21248,4159,1,1,2,610), -- Recipe: Blue Wolf Leather Armor
(21248,5550,1,1,2,2868), -- Durable Metal Plate
(21248,6036,1,1,2,7169), -- Greater Magic Haste Potion
(21249,4052,1,1,-1,197496), -- Earring of Black Ore Piece
(21249,4053,1,1,-1,239104), -- Ring of Black Ore Gemstone
(21249,5230,1,1,-1,7438), -- Recipe: Mithril Arrow (100%)
(21249,57,2256,4571,0,700000), -- Adena
(21249,358,1,1,1,18), -- Blue Wolf Breastplate
(21249,2380,1,1,1,28), -- Blue Wolf Gaiters
(21249,2381,1,1,1,12), -- Doom Plate Armor
(21249,4078,1,1,1,4012), -- Blue Wolf Breastplate Part
(21249,4080,1,1,1,5649), -- Blue Wolf Gaiters Material
(21249,4081,1,1,1,2707), -- Doom Plate Armor Temper
(21249,5811,1,1,2,14266), -- Spellbook: Mass Slow
(21249,5814,1,1,2,14266), -- Spellbook: Servitor Blessing
(21249,5815,1,1,2,14267), -- Spellbook: Wild Magic
(21249,10194,1,1,2,10870), -- Battle Manual: Spite
(21250,4052,1,1,-1,230702), -- Earring of Black Ore Piece
(21250,4053,1,1,-1,279304), -- Ring of Black Ore Gemstone
(21250,5230,1,1,-1,8688), -- Recipe: Mithril Arrow (100%)
(21250,57,2634,5340,0,700000), -- Adena
(21250,171,1,1,1,5), -- Deadman\'s Glory
(21250,175,1,1,1,5), -- Art of Battle Axe
(21250,210,1,1,1,5), -- Staff of Evil Spirits
(21250,4116,1,1,1,1402), -- Deadman\'s Glory Stone
(21250,4117,1,1,1,1402), -- Art of Battle Axe Blade
(21250,4118,1,1,1,1329), -- Evil Spirit Head
(21250,1344,20,60,2,171856), -- Mithril Arrow
(21250,1830,1,1,2,109988), -- Scroll of Escape: Castle
(21250,1866,2,6,2,45829), -- Suede
(21250,1871,1,3,2,91656), -- Charcoal
(21250,1877,1,1,2,10999), -- Adamantite Nugget
(21250,4040,1,1,2,5500), -- Mold Lubricant
(21250,4041,1,1,2,2391), -- Mold Hardener
(21251,4053,1,1,-1,299621), -- Ring of Black Ore Gemstone
(21251,4054,1,1,-1,137683), -- Necklace of Black Ore Beads
(21251,5230,1,1,-1,9320), -- Recipe: Mithril Arrow (100%)
(21251,57,2811,5744,0,700000), -- Adena
(21251,2398,1,1,1,22), -- Blue Wolf Tunic
(21251,2399,1,1,1,22), -- Tunic of Doom
(21251,2403,1,1,1,35), -- Blue Wolf Stockings
(21251,2404,1,1,1,35), -- Stockings of Doom
(21251,4084,1,1,1,4484), -- Blue Wolf Tunic Fabric
(21251,4085,1,1,1,4484), -- Tunic of Doom Pattern
(21251,4086,1,1,1,6054), -- Blue Wolf Stockings Pattern
(21251,4087,1,1,1,6054), -- Stockings of Doom Pattern
(21251,1344,20,60,2,184355), -- Mithril Arrow
(21251,1830,1,1,2,117988), -- Scroll of Escape: Castle
(21251,1866,2,6,2,49162), -- Suede
(21251,1871,1,3,2,98323), -- Charcoal
(21251,1885,1,1,2,24581), -- High Grade Suede
(21251,4041,1,1,2,2566), -- Mold Hardener
(21251,5220,1,1,2,11799), -- Metal Hardener
(21252,4053,1,1,-1,305530), -- Ring of Black Ore Gemstone
(21252,5230,1,1,-1,9504), -- Recipe: Mithril Arrow (100%)
(21252,5478,1,1,-1,59940), -- Sealed Dark Crystal Leather Armor Pattern
(21252,57,2875,5849,0,700000), -- Adena
(21252,5297,1,1,1,21), -- Sealed Dark Crystal Leather Armor
(21252,5298,1,1,1,33), -- Sealed Dark Crystalline Leggings
(21252,5301,1,1,1,14), -- Sealed Tallum Leather Armor
(21252,5478,1,1,1,2951), -- Sealed Dark Crystal Leather Armor Pattern
(21252,5479,1,1,1,2077), -- Sealed Tallum Leather Armor Pattern
(21252,5482,1,1,1,4631), -- Sealed Dark Crystalline Leggings Design
(21252,1344,40,120,2,93996), -- Mithril Arrow
(21252,1867,5,15,2,40105), -- Animal Skin
(21252,1872,1,3,2,133683), -- Animal Bone
(21252,1882,1,1,2,66842), -- Leather
(21252,1894,1,1,2,10554), -- Crafted Leather
(21252,4042,1,1,2,5014), -- Enria
(21252,10608,1,1,3,7299), -- Amulet - Chant of Combat
(21252,10579,1,1,3,9524), -- Forgotten Scroll - Improve Combat
(21252,10583,1,1,3,9524), -- Forgotten Scroll - Improve Shield Defense
(21252,5276,1,1,2,402), -- Recipe: Greater Spiritshot (A) Compressed Package(100%)
(21253,1807,1,1,-1,10305), -- Recipe: Soulshot: A-Grade
(21253,3035,1,1,-1,10305), -- Recipe: Spiritshot A
(21253,5479,1,1,-1,45733), -- Sealed Tallum Leather Armor Pattern
(21253,57,3110,6350,0,700000), -- Adena
(21253,5304,1,1,1,22), -- Sealed Tallum Tunic
(21253,5305,1,1,1,36), -- Sealed Tallum Stockings
(21253,5308,1,1,1,15), -- Sealed Dark Crystal Robe
(21253,5485,1,1,1,3200), -- Sealed Tallum Tunic Texture
(21253,5486,1,1,1,2252), -- Sealed Dark Crystal Robe Fabric
(21253,5489,1,1,1,5022), -- Sealed Tallum Stockings Fabric
(21253,1344,30,90,2,135894), -- Mithril Arrow
(21253,1868,4,12,2,81536), -- Thread
(21253,1873,1,1,2,130457), -- Silver Nugget
(21253,1889,1,1,2,21743), -- Compound Braid
(21253,4044,1,1,2,10872), -- Thons
(21253,10610,1,1,3,394), -- Amulet - Chant of Blood Awakening
(21253,10582,1,1,3,310), -- Forgotten Scroll - Improve Critical Attack
(21253,10580,1,1,3,332), -- Forgotten Scroll - Improve Magic
(21253,5166,1,1,2,436), -- Recipe: Blessed Spiritshot (A) Compressed Package (100%)
(21253,5549,1,1,2,32615), -- Metallic Thread
(21254,729,1,1,-1,990), -- Scroll: Enchant Weapon (Grade A)
(21254,1877,1,1,-1,356449), -- Adamantite Nugget
(21254,5480,1,1,-1,39987), -- Sealed Leather Armor of Nightmare Fabric
(21254,57,3587,7319,0,700000), -- Adena
(21254,6323,1,1,1,51), -- Sealed Phoenix Necklace
(21254,6324,1,1,1,67), -- Sealed Phoenix Earring
(21254,6325,1,1,1,101), -- Sealed Phoenix Ring
(21254,6341,1,1,1,12134), -- Sealed Phoenix Earring Gemstone
(21254,6343,1,1,1,9381), -- Sealed Phoenix Necklace Beads
(21254,6345,1,1,1,16783), -- Sealed Phoenix Ring Gemstone
(21254,7646,1,1,2,15128), -- Spellbook - Curse of Doom
(21254,7647,1,1,2,15128), -- Spellbook - Curse of Abyss
(21254,7648,1,1,2,15128), -- Spellbook - Arcane Chaos
(21255,4041,1,1,-1,82464), -- Mold Hardener
(21255,5481,1,1,-1,42554), -- Sealed Majestic Leather Armor Fabric
(21255,5487,1,1,-1,42704), -- Sealed Robe of Nightmare Fabric
(21255,57,3814,7793,0,700000), -- Adena
(21255,5297,1,1,1,27), -- Sealed Dark Crystal Leather Armor
(21255,5298,1,1,1,44), -- Sealed Dark Crystalline Leggings
(21255,5301,1,1,1,19), -- Sealed Tallum Leather Armor
(21255,5478,1,1,1,3926), -- Sealed Dark Crystal Leather Armor Pattern
(21255,5479,1,1,1,2763), -- Sealed Tallum Leather Armor Pattern
(21255,5482,1,1,1,6162), -- Sealed Dark Crystalline Leggings Design
(21255,7662,1,1,2,16099), -- Spellbook - Elemental Protection
(21255,7663,1,1,2,16099), -- Spellbook - Divine Protection
(21255,7664,1,1,2,16100), -- Spellbook - Arcane Protection
(21256,1804,1,1,-1,10820), -- Recipe: Soulshot: D-Grade
(21256,1872,1,1,-1,360672), -- Animal Bone
(21256,1898,1,1,-1,27787), -- Blue Diamond Necklace Gem
(21256,57,124,218,0,700000), -- Adena
(21256,27,1,1,1,217), -- Hard Leather Shirt
(21256,33,1,1,1,348), -- Hard Leather Gaiters
(21256,1927,1,1,1,3188), -- Hard Leather Shirt Pattern
(21256,1929,1,1,1,5155), -- Hard Leather Gaiters Material
(21256,735,1,1,2,2664), -- Potion of Alacrity
(21256,1867,1,1,2,42615), -- Animal Skin
(21256,1872,1,1,2,42615), -- Animal Bone
(21256,1882,1,1,2,7103), -- Leather
(21256,5153,1,1,2,1279), -- Recipe: Soulshot (D) Compressed Package (100%)
(21257,734,1,1,-1,42627), -- Haste Potion
(21257,1868,1,1,-1,511527), -- Thread
(21257,1897,1,1,-1,60896), -- Necklace of Wisdom Chain
(21257,57,122,202,0,700000), -- Adena
(21257,217,1,1,1,111), -- Shining Knife
(21257,218,1,1,1,111), -- Throwing Knife
(21257,735,1,1,2,4198), -- Potion of Alacrity
(21257,1868,1,1,2,100732), -- Thread
(21257,1873,1,1,2,20147), -- Silver Nugget
(21259,4049,1,1,-1,226242), -- Adamantite Earring Gemstone
(21259,4129,1,1,-1,46681), -- Recipe: Earrings of Black Ore
(21259,4613,1,1,-1,5949), -- Greater Dye of Strength <Str+4 Con-4>
(21259,57,1737,3540,0,700000), -- Adena
(21259,229,1,1,1,8), -- Kris
(21259,243,1,1,1,8), -- Hell Knife
(21259,4109,1,1,1,1795), -- Kris Edge
(21259,4110,1,1,1,1795), -- Hell Knife Edge
(21259,947,1,1,2,85), -- Scroll: Enchant Weapon (Grade B)
(21259,1868,1,3,2,212348), -- Thread
(21259,1873,1,1,2,84939), -- Silver Nugget
(21259,1876,1,1,2,42470), -- Mithril Ore
(21259,1895,1,1,2,60671), -- Metallic Fiber
(21259,4042,1,1,2,3540), -- Enria
(21261,1914,1,1,-1,78741), -- Earring of Binding Gemstone
(21261,2169,1,1,-1,24807), -- Recipe: Necklace of Binding
(21261,2170,1,1,-1,33056), -- Recipe: Nassen\'s Earring
(21261,57,565,1150,0,700000), -- Adena
(21261,231,1,1,1,7), -- Grace Dagger
(21261,233,1,1,1,7), -- Dark Screamer
(21261,2106,1,1,1,790), -- Grace Dagger Edge
(21261,2107,1,1,1,790), -- Dark Screamer Edge
(21261,1539,1,1,2,18401), -- Greater Healing Potion
(21261,1864,1,1,2,165603), -- Stem
(21261,1869,1,1,2,82802), -- Iron Ore
(21261,1880,1,1,2,8280), -- Steel
(21261,2231,1,1,2,357), -- Recipe: Full Plate Armor
(21261,4043,1,1,2,2761), -- Asofe
(21261,5550,1,1,2,1105), -- Durable Metal Plate
(21262,1914,1,1,-1,142677), -- Earring of Binding Gemstone
(21262,2169,1,1,-1,44949), -- Recipe: Necklace of Binding
(21262,2170,1,1,-1,59897), -- Recipe: Nassen\'s Earring
(21262,57,1025,2083,0,700000), -- Adena
(21262,228,1,1,1,16), -- Crystal Dagger
(21262,2119,1,1,1,2137), -- Crystal Dagger Blade
(21262,1539,1,1,2,29769), -- Greater Healing Potion
(21262,1864,1,1,2,267919), -- Stem
(21262,1869,1,1,2,133960), -- Iron Ore
(21262,1880,1,1,2,13396), -- Steel
(21262,2231,1,1,2,578), -- Recipe: Full Plate Armor
(21262,4043,1,1,2,4466), -- Asofe
(21262,5550,1,1,2,1787), -- Durable Metal Plate
(21263,1914,1,1,-1,218248), -- Earring of Binding Gemstone
(21263,2169,1,1,-1,68758), -- Recipe: Necklace of Binding
(21263,2170,1,1,-1,91623), -- Recipe: Nassen\'s Earring
(21263,57,1566,3190,0,700000), -- Adena
(21263,228,1,1,1,24), -- Crystal Dagger
(21263,2119,1,1,1,3269), -- Crystal Dagger Blade
(21263,1539,1,1,2,45537), -- Greater Healing Potion
(21263,1864,1,3,2,204914), -- Stem
(21263,1869,1,1,2,204914), -- Iron Ore
(21263,1880,1,1,2,20492), -- Steel
(21263,2231,1,1,2,884), -- Recipe: Full Plate Armor
(21263,4043,1,1,2,6831), -- Asofe
(21263,5550,1,1,2,2733), -- Durable Metal Plate
(21264,1914,1,1,-1,355312), -- Earring of Binding Gemstone
(21264,2169,1,1,-1,111939), -- Recipe: Necklace of Binding
(21264,2170,1,1,-1,149164), -- Recipe: Nassen\'s Earring
(21264,57,2548,5190,0,700000), -- Adena
(21264,229,1,1,1,11), -- Kris
(21264,243,1,1,1,11), -- Hell Knife
(21264,4109,1,1,1,2631), -- Kris Edge
(21264,4110,1,1,1,2631), -- Hell Knife Edge
(21264,1539,1,1,2,59307), -- Greater Healing Potion
(21264,1864,1,3,2,266883), -- Stem
(21264,1869,1,3,2,88961), -- Iron Ore
(21264,1880,1,1,2,26689), -- Steel
(21264,2231,1,1,2,1151), -- Recipe: Full Plate Armor
(21264,4043,1,1,2,8897), -- Asofe
(21264,5550,1,1,2,3559), -- Durable Metal Plate
(21265,1864,1,3,-1,522665), -- Stem
(21265,1869,1,1,-1,522665), -- Iron Ore
(21265,1901,1,1,-1,72191), -- Tiger\'s Eye Earring Stone
(21265,57,220,442,0,700000), -- Adena
(21265,83,1,1,1,13), -- Sword of Magic
(21265,124,1,1,1,10), -- Two-Handed Sword
(21265,127,1,1,1,10), -- Crimson Sword
(21265,130,1,1,1,10), -- Elven Sword
(21265,144,1,1,1,13), -- Sword of Occult
(21265,2026,1,1,1,558), -- Two-Handed Sword Edge
(21265,1864,1,1,2,111159), -- Stem
(21265,1869,1,1,2,55580), -- Iron Ore
(21265,1878,1,1,2,22232), -- Braided Hemp
(21265,1884,1,1,2,34203), -- Cord
(21265,2154,1,1,2,5951), -- Recipe: Elven Earring
(21268,1940,1,1,-1,145098), -- Iron Boots Design
(21268,2026,1,1,-1,11701), -- Two-Handed Sword Edge
(21268,2156,1,1,-1,77773), -- Recipe: Elven Necklace
(21268,57,410,821,0,700000), -- Adena
(21268,278,1,1,1,54), -- Gastraphetes
(21268,2029,1,1,1,3083), -- Gastraphetes Shaft
(21268,1341,20,60,2,123069), -- Bone Arrow
(21268,1867,1,1,2,98456), -- Animal Skin
(21268,1872,1,1,2,98456), -- Animal Bone
(21268,1882,1,1,2,16410), -- Leather
(21268,1894,1,1,2,2591), -- Crafted Leather
(21268,2186,1,1,2,2470), -- Recipe: Brigandine Tunic
(21268,6037,1,1,2,147683), -- Waking Scroll
(21269,1825,1,1,-1,79006), -- Recipe: Oriharukon
(21269,1902,1,1,-1,112065), -- Elven Earring Beads
(21269,2145,1,1,-1,79006), -- Recipe: Mithril Alloy
(21269,57,467,933,0,700000), -- Adena
(21269,129,1,1,1,41), -- Sword of Revolution
(21269,2034,1,1,1,3021), -- Sword of Revolution Blade
(21269,1825,1,1,2,8168), -- Recipe: Oriharukon
(21269,1867,1,1,2,152470), -- Animal Skin
(21269,1872,1,1,2,152470), -- Animal Bone
(21269,1875,1,1,2,7624), -- Stone of Purity
(21269,1881,1,1,2,15247), -- Coarse Bone Powder
(21270,1902,1,1,-1,129174), -- Elven Earring Beads
(21270,1903,1,1,-1,212668), -- Elven Ring Piece
(21270,6036,1,1,-1,42498), -- Greater Magic Haste Potion
(21270,57,539,1076,0,700000), -- Adena
(21270,88,1,1,1,10), -- Morning Star
(21270,90,1,1,1,10), -- Goat Head Staff
(21270,158,1,1,1,10), -- Tarbar
(21270,169,1,1,1,10), -- Skull Breaker
(21270,172,1,1,1,10), -- Heavy Bone Club
(21270,2031,1,1,1,668), -- Morning Star Head
(21270,2032,1,1,1,609), -- Goat Head Staff Head
(21270,2035,1,1,1,668), -- Tarbar Head
(21270,2036,1,1,1,668), -- Skull Breaker Head
(21270,2037,1,1,1,668), -- Heavy Bone Club Head
(21270,1868,1,1,2,263620), -- Thread
(21270,1873,1,1,2,52724), -- Silver Nugget
(21270,1889,1,1,2,8788), -- Compound Braid
(21270,2145,1,1,2,9415), -- Recipe: Mithril Alloy
(21270,5549,1,1,2,13181), -- Metallic Thread
(21271,1864,1,3,-1,754767), -- Stem
(21271,1869,1,1,-1,754767), -- Iron Ore
(21271,1901,1,1,-1,104250), -- Tiger\'s Eye Earring Stone
(21271,57,319,637,0,700000), -- Adena
(21271,129,1,1,1,28), -- Sword of Revolution
(21271,2034,1,1,1,2062), -- Sword of Revolution Blade
(21271,1864,1,1,2,156063), -- Stem
(21271,1869,1,1,2,78032), -- Iron Ore
(21271,1878,1,1,2,31213), -- Braided Hemp
(21271,1884,1,1,2,48020), -- Cord
(21271,2154,1,1,2,8355), -- Recipe: Elven Earring
(21272,1864,1,5,-1,892175), -- Stem
(21272,1869,1,3,-1,669131), -- Iron Ore
(21272,1901,1,1,-1,184843), -- Tiger\'s Eye Earring Stone
(21272,57,566,1129,0,700000), -- Adena
(21272,129,1,1,1,50), -- Sword of Revolution
(21272,2034,1,1,1,3655), -- Sword of Revolution Blade
(21272,1864,1,3,2,138356), -- Stem
(21272,1869,1,1,2,138356), -- Iron Ore
(21272,1878,1,1,2,55343), -- Braided Hemp
(21272,1884,1,1,2,85143), -- Cord
(21272,2154,1,1,2,14814), -- Recipe: Elven Earring
(21273,1864,1,17,-1,861782), -- Stem
(21273,1869,1,9,-1,775604), -- Iron Ore
(21273,1901,1,1,-1,535638), -- Tiger\'s Eye Earring Stone
(21273,57,1641,3268,0,700000), -- Adena
(21273,129,1,1,1,144), -- Sword of Revolution
(21273,2034,1,1,1,10591), -- Sword of Revolution Blade
(21273,1864,3,9,2,133643), -- Stem
(21273,1869,2,6,2,100233), -- Iron Ore
(21273,1878,1,1,2,160371), -- Braided Hemp
(21273,1884,2,6,2,49345), -- Cord
(21273,2154,1,1,2,42926), -- Recipe: Elven Earring
(21274,4087,1,1,-1,33226), -- Stockings of Doom Pattern
(21274,4088,1,1,-1,53512), -- Blue Wolf Helmet Design
(21274,6333,1,1,-1,16256), -- Recipe: Sealed Phoenix Ring(70%)
(21274,57,569,1164,0,700000), -- Adena
(21274,864,1,1,1,16), -- Earring of Black Ore
(21274,895,1,1,1,23), -- Ring of Black Ore
(21274,926,1,1,1,12), -- Necklace of Black Ore
(21274,4052,1,1,1,2468), -- Earring of Black Ore Piece
(21274,4053,1,1,1,2988), -- Ring of Black Ore Gemstone
(21274,4054,1,1,1,1373), -- Necklace of Black Ore Beads
(21274,1343,10,30,2,85357), -- Silver Arrow
(21274,1864,1,1,2,119500), -- Stem
(21274,1869,1,1,2,59750), -- Iron Ore
(21274,1878,1,1,2,23900), -- Braided Hemp
(21274,1884,1,1,2,36769), -- Cord
(21274,4039,1,1,2,1992), -- Mold Glue
(21274,5456,1,1,2,23), -- Recipe: Tallum Glaive(60%)
(21275,4087,1,1,-1,33226), -- Stockings of Doom Pattern
(21275,4088,1,1,-1,53512), -- Blue Wolf Helmet Design
(21275,6333,1,1,-1,16256), -- Recipe: Sealed Phoenix Ring(70%)
(21275,57,569,1164,0,700000), -- Adena
(21275,864,1,1,1,16), -- Earring of Black Ore
(21275,895,1,1,1,23), -- Ring of Black Ore
(21275,926,1,1,1,12), -- Necklace of Black Ore
(21275,4052,1,1,1,2468), -- Earring of Black Ore Piece
(21275,4053,1,1,1,2988), -- Ring of Black Ore Gemstone
(21275,4054,1,1,1,1373), -- Necklace of Black Ore Beads
(21275,1343,10,30,2,85357), -- Silver Arrow
(21275,1864,1,1,2,119500), -- Stem
(21275,1869,1,1,2,59750), -- Iron Ore
(21275,1878,1,1,2,23900), -- Braided Hemp
(21275,1884,1,1,2,36769), -- Cord
(21275,4039,1,1,2,1992), -- Mold Glue
(21275,5456,1,1,2,23), -- Recipe: Tallum Glaive(60%)
(21276,4087,1,1,-1,33226), -- Stockings of Doom Pattern
(21276,4088,1,1,-1,53512), -- Blue Wolf Helmet Design
(21276,6333,1,1,-1,16256), -- Recipe: Sealed Phoenix Ring(70%)
(21276,57,569,1164,0,700000), -- Adena
(21276,864,1,1,1,16), -- Earring of Black Ore
(21276,895,1,1,1,23), -- Ring of Black Ore
(21276,926,1,1,1,12), -- Necklace of Black Ore
(21276,4052,1,1,1,2468), -- Earring of Black Ore Piece
(21276,4053,1,1,1,2988), -- Ring of Black Ore Gemstone
(21276,4054,1,1,1,1373), -- Necklace of Black Ore Beads
(21276,1343,10,30,2,85357), -- Silver Arrow
(21276,1864,1,1,2,119500), -- Stem
(21276,1869,1,1,2,59750), -- Iron Ore
(21276,1878,1,1,2,23900), -- Braided Hemp
(21276,1884,1,1,2,36769), -- Cord
(21276,4039,1,1,2,1992), -- Mold Glue
(21276,5456,1,1,2,23), -- Recipe: Tallum Glaive(60%)
(21277,4087,1,1,-1,23362), -- Stockings of Doom Pattern
(21277,4088,1,1,-1,37626), -- Blue Wolf Helmet Design
(21277,6333,1,1,-1,11430), -- Recipe: Sealed Phoenix Ring(70%)
(21277,57,400,818,0,700000), -- Adena
(21277,864,1,1,1,11), -- Earring of Black Ore
(21277,895,1,1,1,16), -- Ring of Black Ore
(21277,926,1,1,1,8), -- Necklace of Black Ore
(21277,4052,1,1,1,1735), -- Earring of Black Ore Piece
(21277,4053,1,1,1,2101), -- Ring of Black Ore Gemstone
(21277,4054,1,1,1,966), -- Necklace of Black Ore Beads
(21277,1343,10,30,2,60017), -- Silver Arrow
(21277,1864,1,1,2,84023), -- Stem
(21277,1869,1,1,2,42012), -- Iron Ore
(21277,1878,1,1,2,16805), -- Braided Hemp
(21277,1884,1,1,2,25854), -- Cord
(21277,4039,1,1,2,1401), -- Mold Glue
(21277,5456,1,1,2,16), -- Recipe: Tallum Glaive(60%)
(21278,729,1,1,-1,163), -- Scroll: Enchant Weapon (Grade A)
(21278,4040,1,1,-1,29260), -- Mold Lubricant
(21278,5478,1,1,-1,12302), -- Sealed Dark Crystal Leather Armor Pattern
(21278,57,590,1200,0,700000), -- Adena
(21278,80,1,1,1,2), -- Tallum Blade
(21278,150,1,1,1,2), -- Elemental Sword
(21278,5547,1,1,1,368), -- Elemental Sword Edge
(21278,5548,1,1,1,368), -- Tallum Blade Edge
(21278,1865,1,1,2,72025), -- Varnish
(21278,1870,1,1,2,72025), -- Coal
(21278,1875,1,1,2,4802), -- Stone of Purity
(21278,1879,1,1,2,12005), -- Cokes
(21278,4040,1,1,2,1441), -- Mold Lubricant
(21278,6339,1,1,2,555), -- Recipe: Sealed Majestic Ring(70%)
(21279,729,1,1,-1,163), -- Scroll: Enchant Weapon (Grade A)
(21279,4040,1,1,-1,29260), -- Mold Lubricant
(21279,5478,1,1,-1,12302), -- Sealed Dark Crystal Leather Armor Pattern
(21279,57,590,1200,0,700000), -- Adena
(21279,80,1,1,1,2), -- Tallum Blade
(21279,150,1,1,1,2), -- Elemental Sword
(21279,5547,1,1,1,368), -- Elemental Sword Edge
(21279,5548,1,1,1,368), -- Tallum Blade Edge
(21279,1865,1,1,2,72025), -- Varnish
(21279,1870,1,1,2,72025), -- Coal
(21279,1875,1,1,2,4802), -- Stone of Purity
(21279,1879,1,1,2,12005), -- Cokes
(21279,4040,1,1,2,1441), -- Mold Lubricant
(21279,6339,1,1,2,555), -- Recipe: Sealed Majestic Ring(70%)
(21280,729,1,1,-1,163), -- Scroll: Enchant Weapon (Grade A)
(21280,4040,1,1,-1,29260), -- Mold Lubricant
(21280,5478,1,1,-1,12302), -- Sealed Dark Crystal Leather Armor Pattern
(21280,57,590,1200,0,700000), -- Adena
(21280,80,1,1,1,2), -- Tallum Blade
(21280,150,1,1,1,2), -- Elemental Sword
(21280,5547,1,1,1,368), -- Elemental Sword Edge
(21280,5548,1,1,1,368), -- Tallum Blade Edge
(21280,1865,1,1,2,72025), -- Varnish
(21280,1870,1,1,2,72025), -- Coal
(21280,1875,1,1,2,4802), -- Stone of Purity
(21280,1879,1,1,2,12005), -- Cokes
(21280,4040,1,1,2,1441), -- Mold Lubricant
(21280,6339,1,1,2,555), -- Recipe: Sealed Majestic Ring(70%)
(21281,729,1,1,-1,114), -- Scroll: Enchant Weapon (Grade A)
(21281,4040,1,1,-1,20573), -- Mold Lubricant
(21281,5478,1,1,-1,8650), -- Sealed Dark Crystal Leather Armor Pattern
(21281,57,415,844,0,700000), -- Adena
(21281,80,1,1,1,1), -- Tallum Blade
(21281,150,1,1,1,1), -- Elemental Sword
(21281,5547,1,1,1,259), -- Elemental Sword Edge
(21281,5548,1,1,1,259), -- Tallum Blade Edge
(21281,1865,1,1,2,50643), -- Varnish
(21281,1870,1,1,2,50643), -- Coal
(21281,1875,1,1,2,3377), -- Stone of Purity
(21281,1879,1,1,2,8441), -- Cokes
(21281,4040,1,1,2,1013), -- Mold Lubricant
(21281,6339,1,1,2,390), -- Recipe: Sealed Majestic Ring(70%)
(21282,729,1,1,-1,171), -- Scroll: Enchant Weapon (Grade A)
(21282,4040,1,1,-1,30805), -- Mold Lubricant
(21282,5536,1,1,-1,5240), -- Bloody Orchid Head
(21282,57,622,1263,0,700000), -- Adena
(21282,80,1,1,1,2), -- Tallum Blade
(21282,150,1,1,1,2), -- Elemental Sword
(21282,5547,1,1,1,387), -- Elemental Sword Edge
(21282,5548,1,1,1,387), -- Tallum Blade Edge
(21282,730,1,1,2,64), -- Scroll: Enchant Armor (Grade A)
(21282,1865,1,1,2,75829), -- Varnish
(21282,1870,1,1,2,75829), -- Coal
(21282,1875,1,1,2,5056), -- Stone of Purity
(21282,1879,1,1,2,12638), -- Cokes
(21282,4040,1,1,2,1517), -- Mold Lubricant
(21283,729,1,1,-1,171), -- Scroll: Enchant Weapon (Grade A)
(21283,4040,1,1,-1,30805), -- Mold Lubricant
(21283,5536,1,1,-1,5240), -- Bloody Orchid Head
(21283,57,622,1263,0,700000), -- Adena
(21283,80,1,1,1,2), -- Tallum Blade
(21283,150,1,1,1,2), -- Elemental Sword
(21283,5547,1,1,1,387), -- Elemental Sword Edge
(21283,5548,1,1,1,387), -- Tallum Blade Edge
(21283,730,1,1,2,64), -- Scroll: Enchant Armor (Grade A)
(21283,1865,1,1,2,75829), -- Varnish
(21283,1870,1,1,2,75829), -- Coal
(21283,1875,1,1,2,5056), -- Stone of Purity
(21283,1879,1,1,2,12638), -- Cokes
(21283,4040,1,1,2,1517), -- Mold Lubricant
(21284,729,1,1,-1,171), -- Scroll: Enchant Weapon (Grade A)
(21284,4040,1,1,-1,30805), -- Mold Lubricant
(21284,5536,1,1,-1,5240), -- Bloody Orchid Head
(21284,57,622,1263,0,700000), -- Adena
(21284,80,1,1,1,2), -- Tallum Blade
(21284,150,1,1,1,2), -- Elemental Sword
(21284,5547,1,1,1,387), -- Elemental Sword Edge
(21284,5548,1,1,1,387), -- Tallum Blade Edge
(21284,730,1,1,2,64), -- Scroll: Enchant Armor (Grade A)
(21284,1865,1,1,2,75829), -- Varnish
(21284,1870,1,1,2,75829), -- Coal
(21284,1875,1,1,2,5056), -- Stone of Purity
(21284,1879,1,1,2,12638), -- Cokes
(21284,4040,1,1,2,1517), -- Mold Lubricant
(21285,729,1,1,-1,120), -- Scroll: Enchant Weapon (Grade A)
(21285,4040,1,1,-1,21660), -- Mold Lubricant
(21285,5536,1,1,-1,3685), -- Bloody Orchid Head
(21285,57,437,888,0,700000), -- Adena
(21285,80,1,1,1,1), -- Tallum Blade
(21285,150,1,1,1,1), -- Elemental Sword
(21285,5547,1,1,1,273), -- Elemental Sword Edge
(21285,5548,1,1,1,273), -- Tallum Blade Edge
(21285,730,1,1,2,45), -- Scroll: Enchant Armor (Grade A)
(21285,1865,1,1,2,53317), -- Varnish
(21285,1870,1,1,2,53317), -- Coal
(21285,1875,1,1,2,3555), -- Stone of Purity
(21285,1879,1,1,2,8887), -- Cokes
(21285,4040,1,1,2,1067), -- Mold Lubricant
(21286,1889,1,1,-1,103976), -- Compound Braid
(21286,5549,1,1,-1,155963), -- Metallic Thread
(21286,6343,1,1,-1,33347), -- Sealed Phoenix Necklace Beads
(21286,57,629,1280,0,700000), -- Adena
(21286,5290,1,1,1,10), -- Sealed Dark Crystal Gloves
(21286,5291,1,1,1,10), -- Sealed Dark Crystal Boots
(21286,5295,1,1,1,10), -- Sealed Tallum Gloves
(21286,5296,1,1,1,10), -- Sealed Tallum Boots
(21286,5496,1,1,1,1351), -- Sealed Dark Crystal Boots Lining
(21286,5497,1,1,1,1351), -- Sealed Tallum Boots Lining
(21286,5508,1,1,1,1351), -- Sealed Dark Crystal Gloves Design
(21286,5509,1,1,1,1351), -- Sealed Tallum Gloves Design
(21286,1868,1,1,2,153565), -- Thread
(21286,1873,1,1,2,30713), -- Silver Nugget
(21286,1889,1,1,2,5119), -- Compound Braid
(21286,4044,1,1,2,2560), -- Thons
(21286,5440,1,1,2,29), -- Recipe: Elysian(60%)
(21286,5549,1,1,2,7679), -- Metallic Thread
(21287,1889,1,1,-1,103976), -- Compound Braid
(21287,5549,1,1,-1,155963), -- Metallic Thread
(21287,6343,1,1,-1,33347), -- Sealed Phoenix Necklace Beads
(21287,57,629,1280,0,700000), -- Adena
(21287,5290,1,1,1,10), -- Sealed Dark Crystal Gloves
(21287,5291,1,1,1,10), -- Sealed Dark Crystal Boots
(21287,5295,1,1,1,10), -- Sealed Tallum Gloves
(21287,5296,1,1,1,10), -- Sealed Tallum Boots
(21287,5496,1,1,1,1351), -- Sealed Dark Crystal Boots Lining
(21287,5497,1,1,1,1351), -- Sealed Tallum Boots Lining
(21287,5508,1,1,1,1351), -- Sealed Dark Crystal Gloves Design
(21287,5509,1,1,1,1351), -- Sealed Tallum Gloves Design
(21287,1868,1,1,2,153565), -- Thread
(21287,1873,1,1,2,30713), -- Silver Nugget
(21287,1889,1,1,2,5119), -- Compound Braid
(21287,4044,1,1,2,2560), -- Thons
(21287,5440,1,1,2,29), -- Recipe: Elysian(60%)
(21287,5549,1,1,2,7679), -- Metallic Thread
(21288,1889,1,1,-1,103976), -- Compound Braid
(21288,5549,1,1,-1,155963), -- Metallic Thread
(21288,6343,1,1,-1,33347), -- Sealed Phoenix Necklace Beads
(21288,57,629,1280,0,700000), -- Adena
(21288,5290,1,1,1,10), -- Sealed Dark Crystal Gloves
(21288,5291,1,1,1,10), -- Sealed Dark Crystal Boots
(21288,5295,1,1,1,10), -- Sealed Tallum Gloves
(21288,5296,1,1,1,10), -- Sealed Tallum Boots
(21288,5496,1,1,1,1351), -- Sealed Dark Crystal Boots Lining
(21288,5497,1,1,1,1351), -- Sealed Tallum Boots Lining
(21288,5508,1,1,1,1351), -- Sealed Dark Crystal Gloves Design
(21288,5509,1,1,1,1351), -- Sealed Tallum Gloves Design
(21288,1868,1,1,2,153565), -- Thread
(21288,1873,1,1,2,30713), -- Silver Nugget
(21288,1889,1,1,2,5119), -- Compound Braid
(21288,4044,1,1,2,2560), -- Thons
(21288,5440,1,1,2,29), -- Recipe: Elysian(60%)
(21288,5549,1,1,2,7679), -- Metallic Thread
(21289,1889,1,1,-1,73108), -- Compound Braid
(21289,5549,1,1,-1,109662), -- Metallic Thread
(21289,6343,1,1,-1,23447), -- Sealed Phoenix Necklace Beads
(21289,57,442,900,0,700000), -- Adena
(21289,5290,1,1,1,7), -- Sealed Dark Crystal Gloves
(21289,5291,1,1,1,7), -- Sealed Dark Crystal Boots
(21289,5295,1,1,1,7), -- Sealed Tallum Gloves
(21289,5296,1,1,1,7), -- Sealed Tallum Boots
(21289,5496,1,1,1,950), -- Sealed Dark Crystal Boots Lining
(21289,5497,1,1,1,950), -- Sealed Tallum Boots Lining
(21289,5508,1,1,1,950), -- Sealed Dark Crystal Gloves Design
(21289,5509,1,1,1,950), -- Sealed Tallum Gloves Design
(21289,1868,1,1,2,107975), -- Thread
(21289,1873,1,1,2,21595), -- Silver Nugget
(21289,1889,1,1,2,3600), -- Compound Braid
(21289,4044,1,1,2,1800), -- Thons
(21289,5440,1,1,2,21), -- Recipe: Elysian(60%)
(21289,5549,1,1,2,5399), -- Metallic Thread
(21290,730,1,1,-1,1367), -- Scroll: Enchant Armor (Grade A)
(21290,1875,1,1,-1,109369), -- Stone of Purity
(21290,4041,1,1,-1,14266), -- Mold Hardener
(21290,57,661,1347,0,700000), -- Adena
(21290,80,1,1,1,2), -- Tallum Blade
(21290,150,1,1,1,2), -- Elemental Sword
(21290,5547,1,1,1,413), -- Elemental Sword Edge
(21290,5548,1,1,1,413), -- Tallum Blade Edge
(21290,1808,1,1,2,36), -- Recipe: Soulshot: S Grade
(21290,1867,1,1,2,107687), -- Animal Skin
(21290,1872,1,1,2,107687), -- Animal Bone
(21290,1875,1,1,2,5385), -- Stone of Purity
(21290,1881,1,1,2,10769), -- Coarse Bone Powder
(21290,4041,1,1,2,703), -- Mold Hardener
(21291,730,1,1,-1,1367), -- Scroll: Enchant Armor (Grade A)
(21291,1875,1,1,-1,109369), -- Stone of Purity
(21291,4041,1,1,-1,14266), -- Mold Hardener
(21291,57,661,1347,0,700000), -- Adena
(21291,80,1,1,1,2), -- Tallum Blade
(21291,150,1,1,1,2), -- Elemental Sword
(21291,5547,1,1,1,413), -- Elemental Sword Edge
(21291,5548,1,1,1,413), -- Tallum Blade Edge
(21291,1808,1,1,2,36), -- Recipe: Soulshot: S Grade
(21291,1867,1,1,2,107687), -- Animal Skin
(21291,1872,1,1,2,107687), -- Animal Bone
(21291,1875,1,1,2,5385), -- Stone of Purity
(21291,1881,1,1,2,10769), -- Coarse Bone Powder
(21291,4041,1,1,2,703), -- Mold Hardener
(21292,730,1,1,-1,1367), -- Scroll: Enchant Armor (Grade A)
(21292,1875,1,1,-1,109369), -- Stone of Purity
(21292,4041,1,1,-1,14266), -- Mold Hardener
(21292,57,661,1347,0,700000), -- Adena
(21292,80,1,1,1,2), -- Tallum Blade
(21292,150,1,1,1,2), -- Elemental Sword
(21292,5547,1,1,1,413), -- Elemental Sword Edge
(21292,5548,1,1,1,413), -- Tallum Blade Edge
(21292,1808,1,1,2,36), -- Recipe: Soulshot: S Grade
(21292,1867,1,1,2,107687), -- Animal Skin
(21292,1872,1,1,2,107687), -- Animal Bone
(21292,1875,1,1,2,5385), -- Stone of Purity
(21292,1881,1,1,2,10769), -- Coarse Bone Powder
(21292,4041,1,1,2,703), -- Mold Hardener
(21293,730,1,1,-1,961), -- Scroll: Enchant Armor (Grade A)
(21293,1875,1,1,-1,76900), -- Stone of Purity
(21293,4041,1,1,-1,10030), -- Mold Hardener
(21293,57,465,947,0,700000), -- Adena
(21293,80,1,1,1,1), -- Tallum Blade
(21293,150,1,1,1,1), -- Elemental Sword
(21293,5547,1,1,1,290), -- Elemental Sword Edge
(21293,5548,1,1,1,290), -- Tallum Blade Edge
(21293,1808,1,1,2,26), -- Recipe: Soulshot: S Grade
(21293,1867,1,1,2,75718), -- Animal Skin
(21293,1872,1,1,2,75718), -- Animal Bone
(21293,1875,1,1,2,3786), -- Stone of Purity
(21293,1881,1,1,2,7572), -- Coarse Bone Powder
(21293,4041,1,1,2,494), -- Mold Hardener
(21294,5442,1,1,-1,1736), -- Recipe: Soul Bow(60%)
(21294,5486,1,1,-1,27729), -- Sealed Dark Crystal Robe Fabric
(21294,5489,1,1,-1,61851), -- Sealed Tallum Stockings Fabric
(21294,57,1891,3844,0,700000), -- Adena
(21294,80,1,1,1,4), -- Tallum Blade
(21294,150,1,1,1,4), -- Elemental Sword
(21294,5547,1,1,1,1178), -- Elemental Sword Edge
(21294,5548,1,1,1,1178), -- Tallum Blade Edge
(21294,1864,1,3,2,230704), -- Stem
(21294,1869,1,1,2,230704), -- Iron Ore
(21294,1880,1,1,2,23071), -- Steel
(21294,4043,1,1,2,7690), -- Asofe
(21294,5440,1,1,2,86), -- Recipe: Elysian(60%)
(21294,5550,1,1,2,3076), -- Durable Metal Plate
(21295,5442,1,1,-1,1845), -- Recipe: Soul Bow(60%)
(21295,5547,1,1,-1,16952), -- Elemental Sword Edge
(21295,5548,1,1,-1,16952), -- Tallum Blade Edge
(21295,57,2012,4085,0,700000), -- Adena
(21295,80,1,1,1,5), -- Tallum Blade
(21295,150,1,1,1,5), -- Elemental Sword
(21295,5547,1,1,1,1252), -- Elemental Sword Edge
(21295,5548,1,1,1,1252), -- Tallum Blade Edge
(21295,1864,1,3,2,245292), -- Stem
(21295,1869,1,3,2,81764), -- Iron Ore
(21295,1880,1,1,2,24530), -- Steel
(21295,4043,1,1,2,8177), -- Asofe
(21295,5448,1,1,2,91), -- Recipe: Soul Separator(60%)
(21295,5550,1,1,2,3271), -- Durable Metal Plate
(21296,5440,1,1,-1,2753), -- Recipe: Elysian(60%)
(21296,5482,1,1,-1,98095), -- Sealed Dark Crystalline Leggings Design
(21296,5485,1,1,-1,62497), -- Sealed Tallum Tunic Texture
(21296,57,2998,6099,0,700000), -- Adena
(21296,288,1,1,1,12), -- Carnage Bow
(21296,5535,1,1,1,3746), -- Carnage Bow Stave
(21296,1867,1,3,2,162618), -- Animal Skin
(21296,1872,1,3,2,243927), -- Animal Bone
(21296,1875,1,1,2,24393), -- Stone of Purity
(21296,1881,1,1,2,48786), -- Coarse Bone Powder
(21296,4041,1,1,2,3182), -- Mold Hardener
(21296,5456,1,1,2,136), -- Recipe: Tallum Glaive(60%)
(21297,5450,1,1,-1,2771), -- Recipe: Dragon Grinder(60%)
(21297,5456,1,1,-1,2771), -- Recipe: Tallum Glaive(60%)
(21297,6345,1,1,-1,286205), -- Sealed Phoenix Ring Gemstone
(21297,57,3013,6141,0,700000), -- Adena
(21297,235,1,1,1,13), -- Bloody Orchid
(21297,5536,1,1,1,3759), -- Bloody Orchid Head
(21297,1868,3,9,2,122773), -- Thread
(21297,1873,1,1,2,147327), -- Silver Nugget
(21297,1876,1,1,2,73664), -- Mithril Ore
(21297,1895,1,1,2,105234), -- Metallic Fiber
(21297,4042,1,1,2,6139), -- Enria
(21297,5162,1,1,2,163), -- Recipe: Spiritshot (S) Compressed Package (100%)
(21298,730,1,1,-1,4013), -- Scroll: Enchant Armor (Grade A)
(21298,1895,1,3,-1,687861), -- Metallic Fiber
(21298,5478,1,1,-1,40490), -- Sealed Dark Crystal Leather Armor Pattern
(21298,57,1939,3952,0,700000), -- Adena
(21298,5290,1,1,1,31), -- Sealed Dark Crystal Gloves
(21298,5291,1,1,1,31), -- Sealed Dark Crystal Boots
(21298,5295,1,1,1,31), -- Sealed Tallum Gloves
(21298,5296,1,1,1,31), -- Sealed Tallum Boots
(21298,5496,1,1,1,4169), -- Sealed Dark Crystal Boots Lining
(21298,5497,1,1,1,4169), -- Sealed Tallum Boots Lining
(21298,5508,1,1,1,4169), -- Sealed Dark Crystal Gloves Design
(21298,5509,1,1,1,4169), -- Sealed Tallum Gloves Design
(21298,1344,30,90,2,84660), -- Mithril Arrow
(21298,1868,1,3,2,203183), -- Thread
(21298,1873,1,1,2,81274), -- Silver Nugget
(21298,1876,1,1,2,40637), -- Mithril Ore
(21298,1895,1,1,2,58053), -- Metallic Fiber
(21298,4042,1,1,2,3387), -- Enria
(21298,5167,1,1,2,91), -- Recipe: Blessed Spiritshot (S) Compressed Package (100%)
(21299,729,1,1,-1,857), -- Scroll: Enchant Weapon (Grade A)
(21299,4041,1,1,-1,67061), -- Mold Hardener
(21299,5508,1,1,-1,180821), -- Sealed Dark Crystal Gloves Design
(21299,57,3103,6336,0,700000), -- Adena
(21299,80,1,1,1,7), -- Tallum Blade
(21299,150,1,1,1,7), -- Elemental Sword
(21299,5547,1,1,1,1938), -- Elemental Sword Edge
(21299,5548,1,1,1,1938), -- Tallum Blade Edge
(21299,1344,40,120,2,101698), -- Mithril Arrow
(21299,1867,1,3,2,144637), -- Animal Skin
(21299,1872,5,15,2,43391), -- Animal Bone
(21299,1875,1,1,2,21696), -- Stone of Purity
(21299,1881,1,1,2,43391), -- Coarse Bone Powder
(21299,4041,1,1,2,2830), -- Mold Hardener
(21299,5157,1,1,2,145), -- Recipe: Soulshot (S) Compressed Package (100%)
(21300,1895,1,5,-1,722569), -- Metallic Fiber
(21300,5434,1,1,-1,2810), -- Recipe: Dragon Slayer(60%)
(21300,5509,1,1,-1,177889), -- Sealed Tallum Gloves Design
(21300,57,3053,6233,0,700000), -- Adena
(21300,212,1,1,1,7), -- Dasparion\'s Staff
(21300,2504,1,1,1,7), -- Meteor Shower
(21300,5532,1,1,1,1889), -- Meteor Shower Head
(21300,5543,1,1,1,1907), -- Dasparion\'s Staff Edge
(21300,1895,1,1,2,128062), -- Metallic Fiber
(21300,4040,1,1,2,8965), -- Mold Lubricant
(21300,4042,1,1,2,7471), -- Enria
(21300,4043,1,1,2,14941), -- Asofe
(21300,5162,1,1,2,200), -- Recipe: Spiritshot (S) Compressed Package (100%)
(21301,5440,1,1,-1,3372), -- Recipe: Elysian(60%)
(21301,5520,1,1,-1,58709), -- Sealed Dark Crystal Breastplate Pattern
(21301,5521,1,1,-1,41428), -- Sealed Tallum Plate Armor Pattern
(21301,57,3663,7480,0,700000), -- Adena
(21301,269,1,1,1,15), -- Blood Tornado
(21301,5539,1,1,1,4536), -- Blood Tornado Edge
(21301,1344,30,90,2,160077), -- Mithril Arrow
(21301,1868,4,12,2,96047), -- Thread
(21301,1873,1,1,2,153675), -- Silver Nugget
(21301,1889,1,1,2,25613), -- Compound Braid
(21301,4044,1,1,2,12807), -- Thons
(21301,5167,1,1,2,171), -- Recipe: Blessed Spiritshot (S) Compressed Package (100%)
(21301,5549,1,1,2,38419), -- Metallic Thread
(21302,729,1,1,-1,816), -- Scroll: Enchant Weapon (Grade A)
(21302,1875,1,1,-1,489683), -- Stone of Purity
(21302,4041,1,1,-1,63872), -- Mold Hardener
(21302,57,2960,6027,0,700000), -- Adena
(21302,80,1,1,1,6), -- Tallum Blade
(21302,150,1,1,1,6), -- Elemental Sword
(21302,5547,1,1,1,1846), -- Elemental Sword Edge
(21302,5548,1,1,1,1846), -- Tallum Blade Edge
(21302,1867,1,3,2,160717), -- Animal Skin
(21302,1872,1,3,2,241075), -- Animal Bone
(21302,1875,1,1,2,24108), -- Stone of Purity
(21302,1881,1,1,2,48216), -- Coarse Bone Powder
(21302,4041,1,1,2,3145), -- Mold Hardener
(21302,5162,1,1,2,162), -- Recipe: Spiritshot (S) Compressed Package (100%)
(21303,5466,1,1,-1,2751), -- Recipe: Sword of Miracles(60%)
(21303,5547,1,1,-1,25271), -- Elemental Sword Edge
(21303,5548,1,1,-1,25271), -- Tallum Blade Edge
(21303,57,2993,6095,0,700000), -- Adena
(21303,212,1,1,1,6), -- Dasparion\'s Staff
(21303,2504,1,1,1,6), -- Meteor Shower
(21303,5532,1,1,1,1850), -- Meteor Shower Head
(21303,5543,1,1,1,1867), -- Dasparion\'s Staff Edge
(21303,1344,40,120,2,97950), -- Mithril Arrow
(21303,1867,1,3,2,139305), -- Animal Skin
(21303,1872,5,15,2,41792), -- Animal Bone
(21303,1875,1,1,2,20896), -- Stone of Purity
(21303,1881,1,1,2,41792), -- Coarse Bone Powder
(21303,4041,1,1,2,2726), -- Mold Hardener
(21303,5167,1,1,2,140), -- Recipe: Blessed Spiritshot (S) Compressed Package (100%)
(21304,5440,1,1,-1,4052), -- Recipe: Elysian(60%)
(21304,5542,1,1,-1,36893), -- Halberd Edge
(21304,5543,1,1,-1,37241), -- Dasparion\'s Staff Edge
(21304,57,4406,8980,0,700000), -- Adena
(21304,212,1,1,1,9), -- Dasparion\'s Staff
(21304,2504,1,1,1,9), -- Meteor Shower
(21304,5532,1,1,1,2724), -- Meteor Shower Head
(21304,5543,1,1,1,2750), -- Dasparion\'s Staff Edge
(21304,1344,20,60,2,336627), -- Mithril Arrow
(21304,1894,1,1,2,18899), -- Crafted Leather
(21304,4039,1,1,2,17954), -- Mold Glue
(21304,4041,1,1,2,4684), -- Mold Hardener
(21304,4044,1,1,2,17954), -- Thons
(21304,5277,1,1,2,240), -- Recipe: Greater Spiritshot (S) Compressed Package(100%)
(21305,730,1,1,-1,6713), -- Scroll: Enchant Armor (Grade A)
(21305,1877,1,1,-1,322245), -- Adamantite Nugget
(21305,4040,1,1,-1,161122), -- Mold Lubricant
(21305,57,3244,6613,0,700000), -- Adena
(21305,212,1,1,1,7), -- Dasparion\'s Staff
(21305,2504,1,1,1,7), -- Meteor Shower
(21305,5532,1,1,1,2006), -- Meteor Shower Head
(21305,5543,1,1,1,2025), -- Dasparion\'s Staff Edge
(21305,1866,1,1,2,264407), -- Suede
(21305,1871,1,3,2,198305), -- Charcoal
(21305,1877,1,1,2,15865), -- Adamantite Nugget
(21305,4040,1,1,2,7933), -- Mold Lubricant
(21305,4041,1,1,2,3449), -- Mold Hardener
(21305,5282,1,1,2,176), -- Recipe: Greater Blessed Spiritshot (S) Compressed Package(100%)
(21306,5442,1,1,-1,5399), -- Recipe: Soul Bow(60%)
(21306,5547,1,1,-1,49597), -- Elemental Sword Edge
(21306,5548,1,1,-1,49597), -- Tallum Blade Edge
(21306,57,5871,11966,0,700000), -- Adena
(21306,269,1,1,1,24), -- Blood Tornado
(21306,5539,1,1,1,7262), -- Blood Tornado Edge
(21306,1344,100,300,2,76895), -- Mithril Arrow
(21306,1865,9,27,2,34176), -- Varnish
(21306,1870,2,6,2,153789), -- Coal
(21306,1875,1,1,2,41011), -- Stone of Purity
(21306,1879,1,1,2,102526), -- Cokes
(21306,4040,1,1,2,12304), -- Mold Lubricant
(21306,6901,1,1,2,616), -- Recipe: Shining Arrow (100%)
(21307,1808,1,1,-1,4553), -- Recipe: Soulshot: S Grade
(21307,5480,1,1,-1,45971), -- Sealed Leather Armor of Nightmare Fabric
(21307,5481,1,1,-1,45971), -- Sealed Majestic Leather Armor Fabric
(21307,57,4124,8414,0,700000), -- Adena
(21307,80,1,1,1,9), -- Tallum Blade
(21307,150,1,1,1,9), -- Elemental Sword
(21307,5547,1,1,1,2574), -- Elemental Sword Edge
(21307,5548,1,1,1,2574), -- Tallum Blade Edge
(21307,1868,3,9,2,168120), -- Thread
(21307,1873,1,1,2,201743), -- Silver Nugget
(21307,1889,1,1,2,33625), -- Compound Braid
(21307,4044,1,1,2,16812), -- Thons
(21307,5277,1,1,2,225), -- Recipe: Greater Spiritshot (S) Compressed Package(100%)
(21307,5549,1,1,2,50436), -- Metallic Thread
(21308,1875,1,1,-1,907479), -- Stone of Purity
(21308,3036,1,1,-1,6050), -- Recipe: Spiritshot S
(21308,5487,1,1,-1,61297), -- Sealed Robe of Nightmare Fabric
(21308,57,5479,11179,0,700000), -- Adena
(21308,212,1,1,1,11), -- Dasparion\'s Staff
(21308,2504,1,1,1,11), -- Meteor Shower
(21308,5532,1,1,1,3390), -- Meteor Shower Head
(21308,5543,1,1,1,3421), -- Dasparion\'s Staff Edge
(21308,1344,40,120,2,179502), -- Mithril Arrow
(21308,1867,9,27,2,42549), -- Animal Skin
(21308,1872,5,15,2,76588), -- Animal Bone
(21308,1875,1,1,2,38294), -- Stone of Purity
(21308,1881,1,1,2,76588), -- Coarse Bone Powder
(21308,4041,1,1,2,4995), -- Mold Hardener
(21308,5282,1,1,2,256), -- Recipe: Greater Blessed Spiritshot (S) Compressed Package(100%)
(21309,1875,1,1,-1,945811), -- Stone of Purity
(21309,3036,1,1,-1,6305), -- Recipe: Spiritshot S
(21309,5487,1,1,-1,63886), -- Sealed Robe of Nightmare Fabric
(21309,57,5710,11652,0,700000), -- Adena
(21309,212,1,1,1,12), -- Dasparion\'s Staff
(21309,2504,1,1,1,12), -- Meteor Shower
(21309,5532,1,1,1,3533), -- Meteor Shower Head
(21309,5543,1,1,1,3566), -- Dasparion\'s Staff Edge
(21309,1344,40,120,2,187084), -- Mithril Arrow
(21309,1867,9,27,2,44346), -- Animal Skin
(21309,1872,5,15,2,79823), -- Animal Bone
(21309,1875,1,1,2,39912), -- Stone of Purity
(21309,1881,1,1,2,79823), -- Coarse Bone Powder
(21309,4041,1,1,2,5206), -- Mold Hardener
(21309,5282,1,1,2,267); -- Recipe: Greater Blessed Spiritshot (S) Compressed Package(100%)

INSERT INTO `droplist` VALUES 
(21310,5162,1,1,-1,6226), -- Recipe: Spiritshot (S) Compressed Package (100%)
(21310,5546,1,1,-1,42217), -- Sword of Miracles Edge
(21310,5549,1,3,-1,700478), -- Metallic Thread
(21310,57,5625,11517,0,700000), -- Adena
(21310,80,1,1,1,12), -- Tallum Blade
(21310,150,1,1,1,12), -- Elemental Sword
(21310,5547,1,1,1,3520), -- Elemental Sword Edge
(21310,5548,1,1,1,3520), -- Tallum Blade Edge
(21310,1868,3,9,2,229901), -- Thread
(21310,1873,2,6,2,68971), -- Silver Nugget
(21310,1889,1,1,2,45980), -- Compound Braid
(21310,4044,1,1,2,22991), -- Thons
(21310,5157,1,1,2,307), -- Recipe: Soulshot (S) Compressed Package (100%)
(21310,5549,1,1,2,68971), -- Metallic Thread
(21311,5162,1,1,-1,5741), -- Recipe: Spiritshot (S) Compressed Package (100%)
(21311,5546,1,1,-1,38925), -- Sword of Miracles Edge
(21311,5549,1,3,-1,645849), -- Metallic Thread
(21311,57,5186,10619,0,700000), -- Adena
(21311,80,1,1,1,11), -- Tallum Blade
(21311,150,1,1,1,11), -- Elemental Sword
(21311,5547,1,1,1,3246), -- Elemental Sword Edge
(21311,5548,1,1,1,3246), -- Tallum Blade Edge
(21311,1868,3,9,2,211971), -- Thread
(21311,1873,2,6,2,63592), -- Silver Nugget
(21311,1889,1,1,2,42395), -- Compound Braid
(21311,4044,1,1,2,21198), -- Thons
(21311,5157,1,1,2,283), -- Recipe: Soulshot (S) Compressed Package (100%)
(21311,5549,1,1,2,63592), -- Metallic Thread
(21312,729,1,1,-1,1238), -- Scroll: Enchant Weapon (Grade A)
(21312,5448,1,1,-1,4126), -- Recipe: Soul Separator(60%)
(21312,6341,1,1,-1,308150), -- Sealed Phoenix Earring Gemstone
(21312,57,4487,9145,0,700000), -- Adena
(21312,288,1,1,1,18), -- Carnage Bow
(21312,5535,1,1,1,5615), -- Carnage Bow Stave
(21312,1808,1,1,2,244), -- Recipe: Soulshot: S Grade
(21312,1866,1,3,2,121887), -- Suede
(21312,1871,1,3,2,274244), -- Charcoal
(21312,1885,1,1,2,45708), -- High Grade Suede
(21312,4041,1,1,2,4770), -- Mold Hardener
(21312,5220,1,1,2,21940), -- Metal Hardener
(21313,730,1,1,-1,8843), -- Scroll: Enchant Armor (Grade A)
(21313,1895,1,7,-1,757976), -- Metallic Fiber
(21313,4042,1,1,-1,176861), -- Enria
(21313,57,4270,8718,0,700000), -- Adena
(21313,288,1,1,1,18), -- Carnage Bow
(21313,5535,1,1,1,5347), -- Carnage Bow Stave
(21313,1868,3,9,2,174142), -- Thread
(21313,1873,2,6,2,52243), -- Silver Nugget
(21313,1876,1,1,2,104485), -- Mithril Ore
(21313,1895,1,1,2,149264), -- Metallic Fiber
(21313,4042,1,1,2,8707), -- Enria
(21313,5272,1,1,2,233), -- Recipe: Greater Soulshot (S) Compressed Package(100%)
(21314,730,1,1,-1,4944), -- Scroll: Enchant Armor (Grade A)
(21314,6335,1,1,-1,22819), -- Recipe: Sealed Majestic Necklace(70%)
(21314,6341,1,1,-1,164100), -- Sealed Phoenix Earring Gemstone
(21314,57,2391,4868,0,700000), -- Adena
(21314,269,1,1,1,10), -- Blood Tornado
(21314,5539,1,1,1,2956), -- Blood Tornado Edge
(21314,1895,1,1,2,100145), -- Metallic Fiber
(21314,4040,1,1,2,7011), -- Mold Lubricant
(21314,4042,1,1,2,5842), -- Enria
(21314,4043,1,1,2,11684), -- Asofe
(21314,5272,1,1,2,156), -- Recipe: Greater Soulshot (S) Compressed Package(100%)
(21315,1889,1,1,-1,412195), -- Compound Braid
(21315,5549,1,1,-1,618292), -- Metallic Thread
(21315,6343,1,1,-1,132198), -- Sealed Phoenix Necklace Beads
(21315,57,2492,5073,0,700000), -- Adena
(21315,288,1,1,1,10), -- Carnage Bow
(21315,5535,1,1,1,3117), -- Carnage Bow Stave
(21315,1344,30,90,2,108711), -- Mithril Arrow
(21315,1868,4,12,2,65227), -- Thread
(21315,1873,1,1,2,104363), -- Silver Nugget
(21315,1889,1,1,2,17394), -- Compound Braid
(21315,4044,1,1,2,8698), -- Thons
(21315,5277,1,1,2,117), -- Recipe: Greater Spiritshot (S) Compressed Package(100%)
(21315,5549,1,1,2,26091), -- Metallic Thread
(21316,4043,1,1,-1,215511), -- Asofe
(21316,5550,1,1,-1,86204), -- Durable Metal Plate
(21316,6343,1,1,-1,138237), -- Sealed Phoenix Necklace Beads
(21316,57,2604,5307,0,700000), -- Adena
(21316,235,1,1,1,11), -- Bloody Orchid
(21316,5536,1,1,1,3249), -- Bloody Orchid Head
(21316,1344,30,90,2,113676), -- Mithril Arrow
(21316,1864,1,3,2,272823), -- Stem
(21316,1869,2,6,2,68206), -- Iron Ore
(21316,1880,1,1,2,27283), -- Steel
(21316,3036,1,1,2,122), -- Recipe: Spiritshot S
(21316,4043,1,1,2,9095), -- Asofe
(21316,5550,1,1,2,3638), -- Durable Metal Plate
(21317,5450,1,1,-1,2263), -- Recipe: Dragon Grinder(60%)
(21317,5456,1,1,-1,2263), -- Recipe: Tallum Glaive(60%)
(21317,6345,1,1,-1,233778), -- Sealed Phoenix Ring Gemstone
(21317,57,2461,5016,0,700000), -- Adena
(21317,269,1,1,1,10), -- Blood Tornado
(21317,5539,1,1,1,3045), -- Blood Tornado Edge
(21317,1867,1,3,2,200565), -- Animal Skin
(21317,1872,1,3,2,133710), -- Animal Bone
(21317,1882,1,1,2,66856), -- Leather
(21317,1894,1,1,2,10556), -- Crafted Leather
(21317,3957,1,1,2,134), -- Recipe: Blessed Spiritshot S
(21317,4042,1,1,2,5015), -- Enria
(21318,730,1,1,-1,5323), -- Scroll: Enchant Armor (Grade A)
(21318,5478,1,1,-1,53713), -- Sealed Dark Crystal Leather Armor Pattern
(21318,5549,1,1,-1,638760), -- Metallic Thread
(21318,57,2572,5243,0,700000), -- Adena
(21318,5290,1,1,1,41), -- Sealed Dark Crystal Gloves
(21318,5291,1,1,1,41), -- Sealed Dark Crystal Boots
(21318,5295,1,1,1,41), -- Sealed Tallum Gloves
(21318,5296,1,1,1,41), -- Sealed Tallum Boots
(21318,5496,1,1,1,5530), -- Sealed Dark Crystal Boots Lining
(21318,5497,1,1,1,5530), -- Sealed Tallum Boots Lining
(21318,5508,1,1,1,5530), -- Sealed Dark Crystal Gloves Design
(21318,5509,1,1,1,5530), -- Sealed Tallum Gloves Design
(21318,1344,30,90,2,112310), -- Mithril Arrow
(21318,1868,4,12,2,67386), -- Thread
(21318,1873,1,1,2,107818), -- Silver Nugget
(21318,1889,1,1,2,17970), -- Compound Braid
(21318,4044,1,1,2,8985), -- Thons
(21318,5157,1,1,2,120), -- Recipe: Soulshot (S) Compressed Package (100%)
(21318,5549,1,1,2,26955), -- Metallic Thread
(21319,5157,1,1,-1,3204), -- Recipe: Soulshot (S) Compressed Package (100%)
(21319,5495,1,1,-1,109466), -- Sealed Shield of Nightmare Fragment
(21319,5502,1,1,-1,121751), -- Sealed Boots of Nightmare Lining
(21319,57,2902,5920,0,700000), -- Adena
(21319,288,1,1,1,12), -- Carnage Bow
(21319,5535,1,1,1,3633), -- Carnage Bow Stave
(21319,1344,10,30,2,443632), -- Mithril Arrow
(21319,7649,1,1,2,6119), -- Spellbook - Fire Vortex
(21319,7650,1,1,2,6119), -- Spellbook - Ice Vortex
(21319,7651,1,1,2,6119), -- Spellbook - Wind Vortex
(21319,7652,1,1,2,6119), -- Spellbook - Light Vortex
(21319,7653,1,1,2,6119), -- Spellbook - Dark Vortex
(21320,1894,1,1,-1,230170), -- Crafted Leather
(21320,4042,1,1,-1,109331), -- Enria
(21320,5503,1,1,-1,110790), -- Sealed Majestic Boots Lining
(21320,57,2640,5387,0,700000), -- Adena
(21320,235,1,1,1,11), -- Bloody Orchid
(21320,5536,1,1,1,3297), -- Bloody Orchid Head
(21320,1867,1,3,2,215298), -- Animal Skin
(21320,1872,1,3,2,143532), -- Animal Bone
(21320,1882,1,1,2,71767), -- Leather
(21320,1894,1,1,2,11332), -- Crafted Leather
(21320,3036,1,1,2,144), -- Recipe: Spiritshot S
(21320,4042,1,1,2,5383), -- Enria
(21321,1876,1,3,-1,685417), -- Mithril Ore
(21321,1895,1,5,-1,652778), -- Metallic Fiber
(21321,6346,1,1,-1,223154), -- Sealed Majestic Ring Gemstone
(21321,57,2752,5635,0,700000), -- Adena
(21321,269,1,1,1,12), -- Blood Tornado
(21321,5539,1,1,1,3414), -- Blood Tornado Edge
(21321,1868,3,9,2,112480), -- Thread
(21321,1873,1,1,2,134975), -- Silver Nugget
(21321,1876,1,1,2,67488), -- Mithril Ore
(21321,1895,1,1,2,96411), -- Metallic Fiber
(21321,4042,1,1,2,5625), -- Enria
(21321,5167,1,1,2,150), -- Recipe: Blessed Spiritshot (S) Compressed Package (100%)
(21322,5272,1,1,-1,3046), -- Recipe: Greater Soulshot (S) Compressed Package(100%)
(21322,5277,1,1,-1,3046), -- Recipe: Greater Spiritshot (S) Compressed Package(100%)
(21322,5480,1,1,-1,30756), -- Sealed Leather Armor of Nightmare Fabric
(21322,57,2752,5635,0,700000), -- Adena
(21322,288,1,1,1,12), -- Carnage Bow
(21322,5535,1,1,1,3454), -- Carnage Bow Stave
(21322,1344,20,60,2,180770), -- Mithril Arrow
(21322,1866,1,1,2,192821), -- Suede
(21322,1871,1,3,2,96411), -- Charcoal
(21322,1877,1,1,2,11570), -- Adamantite Nugget
(21322,4040,1,1,2,5785), -- Mold Lubricant
(21322,4041,1,1,2,2516), -- Mold Hardener
(21322,5272,1,1,2,129), -- Recipe: Greater Soulshot (S) Compressed Package(100%)
(21323,1894,1,1,-1,237606), -- Crafted Leather
(21323,4042,1,1,-1,112863), -- Enria
(21323,5481,1,1,-1,30386), -- Sealed Majestic Leather Armor Fabric
(21323,57,2719,5567,0,700000), -- Adena
(21323,235,1,1,1,11), -- Bloody Orchid
(21323,5536,1,1,1,3404), -- Bloody Orchid Head
(21323,1867,1,3,2,222254), -- Animal Skin
(21323,1872,1,3,2,148169), -- Animal Bone
(21323,1882,1,1,2,74085), -- Leather
(21323,1894,1,1,2,11698), -- Crafted Leather
(21323,4042,1,1,2,5557), -- Enria
(21323,5277,1,1,2,149), -- Recipe: Greater Spiritshot (S) Compressed Package(100%)
(21324,1808,1,1,-1,2885), -- Recipe: Soulshot: S Grade
(21324,4042,1,1,-1,108175), -- Enria
(21324,5502,1,1,-1,109618), -- Sealed Boots of Nightmare Lining
(21324,57,2610,5333,0,700000), -- Adena
(21324,80,1,1,1,6), -- Tallum Blade
(21324,150,1,1,1,6), -- Elemental Sword
(21324,5547,1,1,1,1631), -- Elemental Sword Edge
(21324,5548,1,1,1,1631), -- Tallum Blade Edge
(21324,1344,30,90,2,114118), -- Mithril Arrow
(21324,1808,1,1,2,122), -- Recipe: Soulshot: S Grade
(21324,1868,4,12,2,68471), -- Thread
(21324,1873,1,1,2,109554), -- Silver Nugget
(21324,1876,1,1,2,54777), -- Mithril Ore
(21324,1895,1,1,2,78253), -- Metallic Fiber
(21324,4042,1,1,2,4565), -- Enria
(21325,3036,1,1,-1,2789), -- Recipe: Spiritshot S
(21325,5503,1,1,-1,105999), -- Sealed Majestic Boots Lining
(21325,5514,1,1,-1,105999), -- Sealed Gloves of Nightmare Design
(21325,57,2524,5157,0,700000), -- Adena
(21325,212,1,1,1,6), -- Dasparion\'s Staff
(21325,2504,1,1,1,6), -- Meteor Shower
(21325,5532,1,1,1,1563), -- Meteor Shower Head
(21325,5543,1,1,1,1578), -- Dasparion\'s Staff Edge
(21325,1894,1,1,2,13010), -- Crafted Leather
(21325,3036,1,1,2,165), -- Recipe: Spiritshot S
(21325,4039,1,1,2,12360), -- Mold Glue
(21325,4041,1,1,2,3225), -- Mold Hardener
(21325,4044,1,1,2,12360), -- Thons
(21326,1877,1,1,-1,251047), -- Adamantite Nugget
(21326,4041,1,1,-1,54575), -- Mold Hardener
(21326,5515,1,1,-1,105999), -- Sealed Majestic Gloves Design
(21326,57,2524,5157,0,700000), -- Adena
(21326,269,1,1,1,11), -- Blood Tornado
(21326,5539,1,1,1,3126), -- Blood Tornado Edge
(21326,1344,20,60,2,165526), -- Mithril Arrow
(21326,1866,1,1,2,176561), -- Suede
(21326,1871,1,3,2,88281), -- Charcoal
(21326,1877,1,1,2,10594), -- Adamantite Nugget
(21326,3957,1,1,2,118), -- Recipe: Blessed Spiritshot S
(21326,4040,1,1,2,5297), -- Mold Lubricant
(21326,4041,1,1,2,2304), -- Mold Hardener
(21327,4039,1,1,-1,238154), -- Mold Glue
(21327,5272,1,1,-1,3175), -- Recipe: Greater Soulshot (S) Compressed Package(100%)
(21327,5533,1,1,-1,19597), -- Elysian Head
(21327,57,2875,5868,0,700000), -- Adena
(21327,80,1,1,1,6), -- Tallum Blade
(21327,150,1,1,1,6), -- Elemental Sword
(21327,5547,1,1,1,1796), -- Elemental Sword Edge
(21327,5548,1,1,1,1796), -- Tallum Blade Edge
(21327,1894,1,1,2,14811), -- Crafted Leather
(21327,4039,1,1,2,14070), -- Mold Glue
(21327,4041,1,1,2,3671), -- Mold Hardener
(21327,4044,1,1,2,14070), -- Thons
(21327,5277,1,1,2,188), -- Recipe: Greater Spiritshot (S) Compressed Package(100%)
(21328,5277,1,1,-1,3044), -- Recipe: Greater Spiritshot (S) Compressed Package(100%)
(21328,5534,1,1,-1,18804), -- Soul Bow Stave
(21328,5537,1,1,-1,18791), -- Soul Separator Head
(21328,57,2756,5626,0,700000), -- Adena
(21328,212,1,1,1,6), -- Dasparion\'s Staff
(21328,2504,1,1,1,6), -- Meteor Shower
(21328,5532,1,1,1,1706), -- Meteor Shower Head
(21328,5543,1,1,1,1722), -- Dasparion\'s Staff Edge
(21328,1344,30,90,2,105375), -- Mithril Arrow
(21328,1868,4,12,2,63225), -- Thread
(21328,1873,1,1,2,101160), -- Silver Nugget
(21328,1876,1,1,2,50580), -- Mithril Ore
(21328,1895,1,1,2,72257), -- Metallic Fiber
(21328,4042,1,1,2,4215), -- Enria
(21328,5282,1,1,2,113), -- Recipe: Greater Blessed Spiritshot (S) Compressed Package(100%)
(21328,6671,1,1,2,28100), -- Deluxe Chest Key - Grade 7
(21329,5162,1,1,-1,3095), -- Recipe: Spiritshot (S) Compressed Package (100%)
(21329,5167,1,1,-1,3095), -- Recipe: Blessed Spiritshot (S) Compressed Package (100%)
(21329,5487,1,1,-1,31362), -- Sealed Robe of Nightmare Fabric
(21329,57,2802,5719,0,700000), -- Adena
(21329,81,1,1,1,3), -- Dragon Slayer
(21329,151,1,1,1,3), -- Sword of Miracles 
(21329,2500,1,1,1,3), -- Dark Legion\'s Edge
(21329,5529,1,1,1,941), -- Dragon Slayer Edge
(21329,5545,1,1,1,941), -- Dark Legion\'s Edge Blade
(21329,5546,1,1,1,1034), -- Sword of Miracles Edge
(21329,7668,1,1,2,8868), -- Spellbook - Block Shield
(21329,7669,1,1,2,8868), -- Spellbook - Block Wind Walk
(21329,7670,1,1,2,8868), -- Spellbook - Mass Block Shield
(21329,7671,1,1,2,8868), -- Spellbook - Mass Block Wind Walk
(21330,1885,1,1,-1,553215), -- High Grade Suede
(21330,4041,1,1,-1,57727), -- Mold Hardener
(21330,5488,1,1,-1,29894), -- Sealed Majestic Robe Fabric
(21330,57,2671,5451,0,700000), -- Adena
(21330,164,1,1,1,4), -- Elysian
(21330,213,1,1,1,4), -- Branch of The Mother Tree
(21330,5533,1,1,1,1346), -- Elysian Head
(21330,5544,1,1,1,1344), -- Branch of The Mother Tree Head
(21330,960,1,1,2,113), -- Scroll: Enchant Armor (Grade S)
(21330,1344,20,60,2,175083), -- Mithril Arrow
(21330,1866,1,1,2,186756), -- Suede
(21330,1871,1,3,2,93378), -- Charcoal
(21330,1885,1,1,2,23345), -- High Grade Suede
(21330,4041,1,1,2,2436), -- Mold Hardener
(21330,5220,1,1,2,11206), -- Metal Hardener
(21331,1895,1,3,-1,931857), -- Metallic Fiber
(21331,4042,1,1,-1,108717), -- Enria
(21331,5546,1,1,-1,19657), -- Sword of Miracles Edge
(21331,57,2624,5357,0,700000), -- Adena
(21331,81,1,1,1,3), -- Dragon Slayer
(21331,151,1,1,1,3), -- Sword of Miracles 
(21331,2500,1,1,1,3), -- Dark Legion\'s Edge
(21331,5529,1,1,1,882), -- Dragon Slayer Edge
(21331,5545,1,1,1,882), -- Dark Legion\'s Edge Blade
(21331,5546,1,1,1,968), -- Sword of Miracles Edge
(21331,960,1,1,2,111), -- Scroll: Enchant Armor (Grade S)
(21331,1344,30,90,2,114690), -- Mithril Arrow
(21331,1868,4,12,2,68815), -- Thread
(21331,1873,1,1,2,110103), -- Silver Nugget
(21331,1876,1,1,2,55052), -- Mithril Ore
(21331,1895,1,1,2,78645), -- Metallic Fiber
(21331,4042,1,1,2,4588), -- Enria
(21332,5282,1,1,-1,3247), -- Recipe: Greater Blessed Spiritshot (S) Compressed Package(100%)
(21332,6342,1,1,-1,165490), -- Sealed Majestic Earring Gemstone
(21332,6344,1,1,-1,107096), -- Sealed Majestic Necklace Beads
(21332,57,2939,6000,0,700000), -- Adena
(21332,164,1,1,1,4), -- Elysian
(21332,213,1,1,1,4), -- Branch of The Mother Tree
(21332,5533,1,1,1,1481), -- Elysian Head
(21332,5544,1,1,1,1479), -- Branch of The Mother Tree Head
(21332,959,1,1,2,18), -- Scroll: Enchant Weapon (Grade S)
(21332,1894,1,1,2,15144), -- Crafted Leather
(21332,4039,1,1,2,14387), -- Mold Glue
(21332,4041,1,1,2,3753), -- Mold Hardener
(21332,4044,1,1,2,14387), -- Thons
(21333,1808,1,1,-1,3114), -- Recipe: Soulshot: S Grade
(21333,3036,1,1,-1,3114), -- Recipe: Spiritshot S
(21333,5503,1,1,-1,118333), -- Sealed Majestic Boots Lining
(21333,57,2813,5760,0,700000), -- Adena
(21333,164,1,1,1,4), -- Elysian
(21333,213,1,1,1,4), -- Branch of The Mother Tree
(21333,5533,1,1,1,1420), -- Elysian Head
(21333,5544,1,1,1,1418), -- Branch of The Mother Tree Head
(21333,959,1,1,2,15), -- Scroll: Enchant Weapon (Grade S)
(21333,1864,4,12,2,86234), -- Stem
(21333,1865,2,6,2,68987), -- Varnish
(21333,1866,3,9,2,38327), -- Suede
(21333,1868,10,30,2,32851), -- Thread
(21333,1873,1,1,2,137974), -- Silver Nugget
(21334,5480,1,1,-1,42540), -- Sealed Leather Armor of Nightmare Fabric
(21334,5514,1,1,-1,160113), -- Sealed Gloves of Nightmare Design
(21334,57,3806,7794,0,700000), -- Adena
(21334,270,1,1,1,11), -- Dragon Grinder
(21334,5538,1,1,1,3841), -- Dragon Grinder Edge
(21334,960,1,1,2,140), -- Scroll: Enchant Armor (Grade S)
(21334,1344,40,120,2,109389), -- Mithril Arrow
(21334,1867,13,39,2,17286), -- Animal Skin
(21334,1869,2,6,2,70009), -- Iron Ore
(21334,1870,3,9,2,58341), -- Coal
(21334,1871,3,9,2,50007), -- Charcoal
(21334,1872,8,24,2,29171), -- Animal Bone
(21334,6672,1,1,2,29171), -- Deluxe Chest Key - Grade 8
(21335,1889,1,1,-1,451301), -- Compound Braid
(21335,5272,1,1,-1,3009), -- Recipe: Greater Soulshot (S) Compressed Package(100%)
(21335,5495,1,1,-1,102794), -- Sealed Shield of Nightmare Fragment
(21335,57,2718,5566,0,700000), -- Adena
(21335,305,1,1,1,8), -- Tallum Glaive
(21335,5541,1,1,1,2742), -- Tallum Glaive Edge
(21335,959,1,1,2,14), -- Scroll: Enchant Weapon (Grade S)
(21335,1868,3,9,2,111090), -- Thread
(21335,1873,1,1,2,133308), -- Silver Nugget
(21335,1889,1,1,2,22219), -- Compound Braid
(21335,4044,1,1,2,11110), -- Thons
(21335,5549,1,1,2,33327), -- Metallic Thread
(21336,5277,1,1,-1,3537), -- Recipe: Greater Spiritshot (S) Compressed Package(100%)
(21336,5502,1,1,-1,134421), -- Sealed Boots of Nightmare Lining
(21336,5503,1,1,-1,134421), -- Sealed Majestic Boots Lining
(21336,57,3195,6545,0,700000), -- Adena
(21336,5320,1,1,1,16), -- Sealed Leather Armor of Nightmare
(21336,5323,1,1,1,16), -- Sealed Majestic Leather Armor
(21336,5480,1,1,1,2638), -- Sealed Leather Armor of Nightmare Fabric
(21336,5481,1,1,1,2638), -- Sealed Majestic Leather Armor Fabric
(21336,960,1,1,2,135), -- Scroll: Enchant Armor (Grade S)
(21336,1344,40,120,2,104955), -- Mithril Arrow
(21336,1864,5,15,2,67172), -- Stem
(21336,1865,3,9,2,55977), -- Varnish
(21336,1866,3,9,2,31987), -- Suede
(21336,1868,12,36,2,27988), -- Thread
(21336,1873,1,1,2,134343), -- Silver Nugget
(21337,959,1,1,-1,295), -- Scroll: Enchant Weapon (Grade S)
(21337,1885,1,1,-1,614531), -- High Grade Suede
(21337,5220,1,1,-1,294975), -- Metal Hardener
(21337,57,2968,6057,0,700000), -- Adena
(21337,5326,1,1,1,15), -- Sealed Robe of Nightmare
(21337,5329,1,1,1,15), -- Sealed Majestic Robe
(21337,5487,1,1,1,2453), -- Sealed Robe of Nightmare Fabric
(21337,5488,1,1,1,2453), -- Sealed Majestic Robe Fabric
(21337,959,1,1,2,15), -- Scroll: Enchant Weapon (Grade S)
(21337,1866,1,1,2,242031), -- Suede
(21337,1871,1,3,2,181523), -- Charcoal
(21337,1885,1,1,2,30254), -- High Grade Suede
(21337,4041,1,1,2,3157), -- Mold Hardener
(21337,5220,1,1,2,14522), -- Metal Hardener
(21338,6688,1,1,-1,20974), -- Forgotten Blade Edge
(21338,6689,1,1,-1,20579), -- Basalt Battlehammer Head
(21338,6690,1,1,-1,21014), -- Imperial Staff Head
(21338,57,3905,7970,0,700000), -- Adena
(21338,6326,1,1,1,37), -- Sealed Majestic Necklace
(21338,6327,1,1,1,49), -- Sealed Majestic Earring
(21338,6328,1,1,1,74), -- Sealed Majestic Ring
(21338,6342,1,1,1,10822), -- Sealed Majestic Earring Gemstone
(21338,6344,1,1,1,7003), -- Sealed Majestic Necklace Beads
(21338,6346,1,1,1,15553), -- Sealed Majestic Ring Gemstone
(21338,960,1,1,2,164), -- Scroll: Enchant Armor (Grade S)
(21338,1344,30,90,2,170612), -- Mithril Arrow
(21338,1864,5,15,2,81894), -- Stem
(21338,1869,2,6,2,102368), -- Iron Ore
(21338,1880,1,1,2,40947), -- Steel
(21338,4043,1,1,2,13650), -- Asofe
(21338,5550,1,1,2,5460), -- Durable Metal Plate
(21339,6691,1,1,-1,15980), -- Angel Slayer Blade
(21339,6693,1,1,-1,16269), -- Dragon Hunter Axe Blade
(21339,6694,1,1,-1,16269), -- Saint Spear Blade
(21339,57,2975,6071,0,700000), -- Adena
(21339,236,1,1,1,9), -- Soul Separator
(21339,5537,1,1,1,2995), -- Soul Separator Head
(21339,960,1,1,2,125), -- Scroll: Enchant Armor (Grade S)
(21339,1344,40,120,2,97490), -- Mithril Arrow
(21339,1867,5,15,2,41596), -- Animal Skin
(21339,1872,1,3,2,138652), -- Animal Bone
(21339,1882,1,1,2,69326), -- Leather
(21339,1894,1,1,2,10947), -- Crafted Leather
(21339,4042,1,1,2,5200), -- Enria
(21340,960,1,1,-1,2957), -- Scroll: Enchant Armor (Grade S)
(21340,1889,1,1,-1,492862), -- Compound Braid
(21340,5549,1,1,-1,739293), -- Metallic Thread
(21340,57,2975,6071,0,700000), -- Adena
(21340,5312,1,1,1,28), -- Sealed Helm of Nightmare
(21340,5315,1,1,1,40), -- Sealed Shield of Nightmare
(21340,5317,1,1,1,28), -- Sealed Majestic Circlet
(21340,5495,1,1,1,5527), -- Sealed Shield of Nightmare Fragment
(21340,5527,1,1,1,4352), -- Sealed Helm of Nightmare Design
(21340,5528,1,1,1,4352), -- Sealed Majestic Circlet Design
(21340,959,1,1,2,13), -- Scroll: Enchant Weapon (Grade S)
(21340,1868,3,9,2,103989), -- Thread
(21340,1873,1,1,2,124786), -- Silver Nugget
(21340,1889,1,1,2,20798), -- Compound Braid
(21340,4044,1,1,2,10399), -- Thons
(21340,5549,1,1,2,31197), -- Metallic Thread
(21340,6672,1,1,2,25998), -- Deluxe Chest Key - Grade 8
(21341,960,1,1,-1,3097), -- Scroll: Enchant Armor (Grade S)
(21341,1876,1,3,-1,774226), -- Mithril Ore
(21341,4042,1,1,-1,129038), -- Enria
(21341,57,3115,6359,0,700000), -- Adena
(21341,81,1,1,1,3), -- Dragon Slayer
(21341,151,1,1,1,3), -- Sword of Miracles 
(21341,2500,1,1,1,3), -- Dark Legion\'s Edge
(21341,5529,1,1,1,1046), -- Dragon Slayer Edge
(21341,5545,1,1,1,1046), -- Dark Legion\'s Edge Blade
(21341,5546,1,1,1,1149), -- Sword of Miracles Edge
(21341,959,1,1,2,16), -- Scroll: Enchant Weapon (Grade S)
(21341,1868,3,9,2,127053), -- Thread
(21341,1873,1,1,2,152464), -- Silver Nugget
(21341,1876,1,1,2,76232), -- Mithril Ore
(21341,1895,1,1,2,108902), -- Metallic Fiber
(21341,4042,1,1,2,6353), -- Enria
(21342,6707,1,1,-1,50478), -- Sealed Draconic Leather Armor Part
(21342,6708,1,1,-1,145051), -- Sealed Draconic Leather Gloves Fabric
(21342,6709,1,1,-1,145051), -- Sealed Draconic Leather Boots Design
(21342,57,4098,8367,0,700000), -- Adena
(21342,164,1,1,1,6), -- Elysian
(21342,213,1,1,1,6), -- Branch of The Mother Tree
(21342,5533,1,1,1,2064), -- Elysian Head
(21342,5544,1,1,1,2062), -- Branch of The Mother Tree Head
(21342,960,1,1,2,172), -- Scroll: Enchant Armor (Grade S)
(21342,1344,100,300,2,53738), -- Mithril Arrow
(21342,1866,2,6,2,71650), -- Suede
(21342,1871,1,3,2,143299), -- Charcoal
(21342,1877,1,1,2,17196), -- Adamantite Nugget
(21342,4040,1,1,2,8598), -- Mold Lubricant
(21342,4041,1,1,2,3739), -- Mold Hardener
(21343,3957,1,1,-1,5119), -- Recipe: Blessed Spiritshot S
(21343,5515,1,1,-1,194527), -- Sealed Majestic Gloves Design
(21343,5522,1,1,-1,39225), -- Sealed Armor of Nightmare Pattern
(21343,57,4624,9470,0,700000), -- Adena
(21343,289,1,1,1,13), -- Soul Bow
(21343,5534,1,1,1,4671), -- Soul Bow Stave
(21343,959,1,1,2,28), -- Scroll: Enchant Weapon (Grade S)
(21343,1894,1,1,2,23876), -- Crafted Leather
(21343,4039,1,1,2,22682), -- Mold Glue
(21343,4041,1,1,2,5917), -- Mold Hardener
(21343,4044,1,1,2,22682), -- Thons
(21344,4040,1,1,-1,156171), -- Mold Lubricant
(21344,6346,1,1,-1,254226), -- Sealed Majestic Ring Gemstone
(21344,6901,1,1,-1,7809), -- Recipe: Shining Arrow (100%)
(21344,57,3141,6413,0,700000), -- Adena
(21344,270,1,1,1,9), -- Dragon Grinder
(21344,5538,1,1,1,3164), -- Dragon Grinder Edge
(21344,960,1,1,2,132), -- Scroll: Enchant Armor (Grade S)
(21344,1344,20,60,2,205940), -- Mithril Arrow
(21344,1866,2,6,2,54918), -- Suede
(21344,1871,1,3,2,109835), -- Charcoal
(21344,1877,1,1,2,13181), -- Adamantite Nugget
(21344,4040,1,1,2,6591), -- Mold Lubricant
(21344,4041,1,1,2,2866), -- Mold Hardener
(21345,959,1,1,-1,348), -- Scroll: Enchant Weapon (Grade S)
(21345,1894,1,1,-1,305635), -- Crafted Leather
(21345,4042,1,1,-1,145177), -- Enria
(21345,57,3504,7154,0,700000), -- Adena
(21345,270,1,1,1,10), -- Dragon Grinder
(21345,5538,1,1,1,3530), -- Dragon Grinder Edge
(21345,959,1,1,2,18), -- Scroll: Enchant Weapon (Grade S)
(21345,1867,4,12,2,71472), -- Animal Skin
(21345,1872,1,3,2,190592), -- Animal Bone
(21345,1882,1,1,2,95296), -- Leather
(21345,1894,1,1,2,15047), -- Crafted Leather
(21345,4042,1,1,2,7148), -- Enria
(21346,6695,1,1,-1,18346), -- Demon Splinter Blade
(21346,6696,1,1,-1,18995), -- Heavens Divider Edge
(21346,6697,1,1,-1,18346), -- Arcana Mace Head
(21346,57,3481,7103,0,700000), -- Adena
(21346,305,1,1,1,10), -- Tallum Glaive
(21346,5541,1,1,1,3504), -- Tallum Glaive Edge
(21346,960,1,1,2,147), -- Scroll: Enchant Armor (Grade S)
(21346,1344,40,120,2,114075), -- Mithril Arrow
(21346,1864,5,15,2,73008), -- Stem
(21346,1865,3,9,2,60840), -- Varnish
(21346,1866,3,9,2,34766), -- Suede
(21346,1868,12,36,2,30420), -- Thread
(21346,1873,1,1,2,146016), -- Silver Nugget
(21347,6710,1,1,-1,214664), -- Sealed Draconic Leather Helmet Pattern
(21347,6711,1,1,-1,65566), -- Sealed Major Arcana Robe Part
(21347,6712,1,1,-1,188410), -- Sealed Major Arcana Gloves fabric
(21347,57,5309,10884,0,700000), -- Adena
(21347,5311,1,1,1,19), -- Sealed Armor of Nightmare
(21347,5316,1,1,1,19), -- Sealed Majestic Plate Armor
(21347,5522,1,1,1,3328), -- Sealed Armor of Nightmare Pattern
(21347,5523,1,1,1,3328), -- Sealed Majestic Plate Armor Pattern
(21347,960,1,1,2,261), -- Scroll: Enchant Armor (Grade S)
(21347,1867,4,12,2,108579), -- Animal Skin
(21347,1872,7,21,2,57909), -- Animal Bone
(21347,1882,1,1,2,144771), -- Leather
(21347,1894,1,1,2,22859), -- Crafted Leather
(21347,4042,1,1,2,10858), -- Enria
(21348,6704,1,1,-1,129163), -- Sealed Imperial Crusader Boots Design
(21348,6705,1,1,-1,126515), -- Sealed Imperial Crusader Shield Part
(21348,6706,1,1,-1,147161), -- Sealed Imperial Crusader Helmet Pattern
(21348,57,3643,7457,0,700000), -- Adena
(21348,236,1,1,1,10), -- Soul Separator
(21348,5537,1,1,1,3676), -- Soul Separator Head
(21348,960,1,1,2,179), -- Scroll: Enchant Armor (Grade S)
(21348,1868,3,9,2,148870), -- Thread
(21348,1873,1,1,2,178644), -- Silver Nugget
(21348,1889,1,1,2,29774), -- Compound Braid
(21348,4044,1,1,2,14887), -- Thons
(21348,5549,1,1,2,44661), -- Metallic Thread
(21349,959,1,1,-1,369), -- Scroll: Enchant Weapon (Grade S)
(21349,1875,1,1,-1,614183), -- Stone of Purity
(21349,4041,1,1,-1,80111), -- Mold Hardener
(21349,57,3700,7573,0,700000), -- Adena
(21349,270,1,1,1,11), -- Dragon Grinder
(21349,5538,1,1,1,3733), -- Dragon Grinder Edge
(21349,959,1,1,2,19), -- Scroll: Enchant Weapon (Grade S)
(21349,1867,1,3,2,201579), -- Animal Skin
(21349,1872,4,12,2,75592), -- Animal Bone
(21349,1875,1,1,2,30237), -- Stone of Purity
(21349,1881,1,1,2,60474), -- Coarse Bone Powder
(21349,4041,1,1,2,3944), -- Mold Hardener
(21350,3957,1,1,-1,3048), -- Recipe: Blessed Spiritshot S
(21350,5157,1,1,-1,3048), -- Recipe: Soulshot (S) Compressed Package (100%)
(21350,5522,1,1,-1,23355), -- Sealed Armor of Nightmare Pattern
(21350,57,2758,5635,0,700000), -- Adena
(21350,288,1,1,1,12), -- Carnage Bow
(21350,5535,1,1,1,3456), -- Carnage Bow Stave
(21350,1865,1,3,2,168810), -- Varnish
(21350,1870,1,3,2,112540), -- Coal
(21350,1875,1,1,2,22508), -- Stone of Purity
(21350,1879,1,1,2,56270), -- Cokes
(21350,4040,1,1,2,6753), -- Mold Lubricant
(21350,5157,1,1,2,150), -- Recipe: Soulshot (S) Compressed Package (100%)
(21351,4041,1,1,-1,51381), -- Mold Hardener
(21351,5220,1,1,-1,236352), -- Metal Hardener
(21351,5523,1,1,-1,20123), -- Sealed Majestic Plate Armor Pattern
(21351,57,2376,4855,0,700000), -- Adena
(21351,235,1,1,1,10), -- Bloody Orchid
(21351,5536,1,1,1,2970), -- Bloody Orchid Head
(21351,1344,20,60,2,155837), -- Mithril Arrow
(21351,1866,1,1,2,166226), -- Suede
(21351,1871,1,3,2,83113), -- Charcoal
(21351,1885,1,1,2,20779), -- High Grade Suede
(21351,4041,1,1,2,2169), -- Mold Hardener
(21351,5162,1,1,2,111), -- Recipe: Spiritshot (S) Compressed Package (100%)
(21351,5220,1,1,2,9974), -- Metal Hardener
(21352,5162,1,1,-1,2789), -- Recipe: Spiritshot (S) Compressed Package (100%)
(21352,5527,1,1,-1,75038), -- Sealed Helm of Nightmare Design
(21352,5528,1,1,-1,75038), -- Sealed Majestic Circlet Design
(21352,57,2524,5157,0,700000), -- Adena
(21352,5297,1,1,1,18), -- Sealed Dark Crystal Leather Armor
(21352,5298,1,1,1,29), -- Sealed Dark Crystalline Leggings
(21352,5301,1,1,1,13), -- Sealed Tallum Leather Armor
(21352,5478,1,1,1,2598), -- Sealed Dark Crystal Leather Armor Pattern
(21352,5479,1,1,1,1829), -- Sealed Tallum Leather Armor Pattern
(21352,5482,1,1,1,4078), -- Sealed Dark Crystalline Leggings Design
(21352,1864,1,3,2,308981), -- Stem
(21352,1869,1,3,2,102994), -- Iron Ore
(21352,1880,1,1,2,30898), -- Steel
(21352,4043,1,1,2,10300), -- Asofe
(21352,5167,1,1,2,138), -- Recipe: Blessed Spiritshot (S) Compressed Package (100%)
(21352,5550,1,1,2,4120), -- Durable Metal Plate
(21353,1875,1,1,-1,460775), -- Stone of Purity
(21353,4041,1,1,-1,60101), -- Mold Hardener
(21353,5538,1,1,-1,18958), -- Dragon Grinder Edge
(21353,57,2782,5677,0,700000), -- Adena
(21353,269,1,1,1,12), -- Blood Tornado
(21353,5539,1,1,1,3443), -- Blood Tornado Edge
(21353,1867,1,3,2,151229), -- Animal Skin
(21353,1872,1,3,2,226844), -- Animal Bone
(21353,1875,1,1,2,22685), -- Stone of Purity
(21353,1881,1,1,2,45369), -- Coarse Bone Powder
(21353,4041,1,1,2,2960), -- Mold Hardener
(21353,6901,1,1,2,341), -- Recipe: Shining Arrow (100%)
(21354,5282,1,1,-1,3044), -- Recipe: Greater Blessed Spiritshot (S) Compressed Package(100%)
(21354,5541,1,1,-1,18784), -- Tallum Glaive Edge
(21354,6901,1,1,-1,6849), -- Recipe: Shining Arrow (100%)
(21354,57,2756,5626,0,700000), -- Adena
(21354,288,1,1,1,12), -- Carnage Bow
(21354,5535,1,1,1,3451), -- Carnage Bow Stave
(21354,1344,30,90,2,105375), -- Mithril Arrow
(21354,1808,1,1,2,113), -- Recipe: Soulshot: S Grade
(21354,1868,4,12,2,63225), -- Thread
(21354,1873,1,1,2,101160), -- Silver Nugget
(21354,1889,1,1,2,16860), -- Compound Braid
(21354,4044,1,1,2,8431), -- Thons
(21354,5549,1,1,2,25290), -- Metallic Thread
(21354,6671,1,1,2,28100), -- Deluxe Chest Key - Grade 7
(21355,5272,1,1,-1,2951), -- Recipe: Greater Soulshot (S) Compressed Package(100%)
(21355,5495,1,1,-1,100838), -- Sealed Shield of Nightmare Fragment
(21355,5502,1,1,-1,112155), -- Sealed Boots of Nightmare Lining
(21355,57,2672,5453,0,700000), -- Adena
(21355,270,1,1,1,8), -- Dragon Grinder
(21355,5538,1,1,1,2691), -- Dragon Grinder Edge
(21355,959,1,1,2,14), -- Scroll: Enchant Weapon (Grade S)
(21355,1864,1,3,2,326927), -- Stem
(21355,1869,1,3,2,108976), -- Iron Ore
(21355,1880,1,1,2,32693), -- Steel
(21355,4043,1,1,2,10898), -- Asofe
(21355,5550,1,1,2,4360), -- Durable Metal Plate
(21356,4042,1,1,-1,110643), -- Enria
(21356,5277,1,1,-1,2950), -- Recipe: Greater Spiritshot (S) Compressed Package(100%)
(21356,5503,1,1,-1,112119), -- Sealed Majestic Boots Lining
(21356,57,2671,5451,0,700000), -- Adena
(21356,289,1,1,1,8), -- Soul Bow
(21356,5534,1,1,1,2692), -- Soul Bow Stave
(21356,960,1,1,2,113), -- Scroll: Enchant Armor (Grade S)
(21356,1344,40,120,2,87542), -- Mithril Arrow
(21356,1867,1,3,2,186756), -- Animal Skin
(21356,1872,1,3,2,124504), -- Animal Bone
(21356,1882,1,1,2,62252), -- Leather
(21356,1894,1,1,2,9830), -- Crafted Leather
(21356,4042,1,1,2,4670), -- Enria
(21357,1808,1,1,-1,3202), -- Recipe: Soulshot: S Grade
(21357,4040,1,1,-1,144105), -- Mold Lubricant
(21357,5480,1,1,-1,32332), -- Sealed Leather Armor of Nightmare Fabric
(21357,57,2899,5918,0,700000), -- Adena
(21357,289,1,1,1,8), -- Soul Bow
(21357,5534,1,1,1,2922), -- Soul Bow Stave
(21357,959,1,1,2,15), -- Scroll: Enchant Weapon (Grade S)
(21357,1865,1,3,2,177361), -- Varnish
(21357,1870,1,3,2,118241), -- Coal
(21357,1875,1,1,2,23648), -- Stone of Purity
(21357,1879,1,1,2,59121), -- Cokes
(21357,4040,1,1,2,7095), -- Mold Lubricant
(21358,3036,1,1,-1,3356), -- Recipe: Spiritshot S
(21358,5481,1,1,-1,33887), -- Sealed Majestic Leather Armor Fabric
(21358,5487,1,1,-1,34007), -- Sealed Robe of Nightmare Fabric
(21358,57,3038,6202,0,700000), -- Adena
(21358,236,1,1,1,9), -- Soul Separator
(21358,5537,1,1,1,3060), -- Soul Separator Head
(21358,960,1,1,2,128), -- Scroll: Enchant Armor (Grade S)
(21358,1344,20,60,2,199170), -- Mithril Arrow
(21358,1866,2,6,2,53112), -- Suede
(21358,1871,1,3,2,106224), -- Charcoal
(21358,1885,1,1,2,26556), -- High Grade Suede
(21358,4041,1,1,2,2771), -- Mold Hardener
(21358,5220,1,1,2,12747), -- Metal Hardener
(21359,4042,1,1,-1,116775), -- Enria
(21359,5157,1,1,-1,3114), -- Recipe: Soulshot (S) Compressed Package (100%)
(21359,5523,1,1,-1,23861), -- Sealed Majestic Plate Armor Pattern
(21359,57,2813,5760,0,700000), -- Adena
(21359,236,1,1,1,8), -- Soul Separator
(21359,5537,1,1,1,2839), -- Soul Separator Head
(21359,960,1,1,2,119), -- Scroll: Enchant Armor (Grade S)
(21359,1344,30,90,2,123191), -- Mithril Arrow
(21359,1868,4,12,2,73915), -- Thread
(21359,1873,1,1,2,118264), -- Silver Nugget
(21359,1876,1,1,2,59132), -- Mithril Ore
(21359,1895,1,1,2,84474), -- Metallic Fiber
(21359,4042,1,1,2,4928), -- Enria
(21360,1875,1,1,-1,676905), -- Stone of Purity
(21360,5162,1,1,-1,4513), -- Recipe: Spiritshot (S) Compressed Package (100%)
(21360,5527,1,1,-1,121396), -- Sealed Helm of Nightmare Design
(21360,57,4077,8348,0,700000), -- Adena
(21360,236,1,1,1,12), -- Soul Separator
(21360,5537,1,1,1,4114), -- Soul Separator Head
(21360,959,1,1,2,21), -- Scroll: Enchant Weapon (Grade S)
(21360,1867,1,3,2,222164), -- Animal Skin
(21360,1872,4,12,2,83312), -- Animal Bone
(21360,1875,1,1,2,33325), -- Stone of Purity
(21360,1881,1,1,2,66650), -- Coarse Bone Powder
(21360,4041,1,1,2,4347), -- Mold Hardener
(21361,5481,1,1,-1,30376), -- Sealed Majestic Leather Armor Fabric
(21361,5514,1,1,-1,114331), -- Sealed Gloves of Nightmare Design
(21361,6901,1,1,-1,6770), -- Recipe: Shining Arrow (100%)
(21361,57,2718,5566,0,700000), -- Adena
(21361,5311,1,1,1,10), -- Sealed Armor of Nightmare
(21361,5316,1,1,1,10), -- Sealed Majestic Plate Armor
(21361,5522,1,1,1,1703), -- Sealed Armor of Nightmare Pattern
(21361,5523,1,1,1,1703), -- Sealed Majestic Plate Armor Pattern
(21361,959,1,1,2,12), -- Scroll: Enchant Weapon (Grade S)
(21361,1867,1,3,2,126960), -- Animal Skin
(21361,1869,2,6,2,71415), -- Iron Ore
(21361,1870,2,6,2,57132), -- Coal
(21361,1871,3,9,2,47610), -- Charcoal
(21361,1872,7,21,2,27206), -- Animal Bone
(21361,6672,1,1,2,23806), -- Deluxe Chest Key - Grade 8
(21362,5282,1,1,-1,3537), -- Recipe: Greater Blessed Spiritshot (S) Compressed Package(100%)
(21362,5515,1,1,-1,134421), -- Sealed Majestic Gloves Design
(21362,6901,1,1,-1,7959), -- Recipe: Shining Arrow (100%)
(21362,57,3195,6545,0,700000), -- Adena
(21362,5326,1,1,1,16), -- Sealed Robe of Nightmare
(21362,5329,1,1,1,16), -- Sealed Majestic Robe
(21362,5487,1,1,1,2648), -- Sealed Robe of Nightmare Fabric
(21362,5488,1,1,1,2648), -- Sealed Majestic Robe Fabric
(21362,960,1,1,2,157), -- Scroll: Enchant Armor (Grade S)
(21362,1344,20,60,2,244897), -- Mithril Arrow
(21362,1894,1,1,2,13749), -- Crafted Leather
(21362,4039,1,1,2,13062), -- Mold Glue
(21362,4041,1,1,2,3408), -- Mold Hardener
(21362,4044,1,1,2,13062), -- Thons
(21363,960,1,1,-1,2950), -- Scroll: Enchant Armor (Grade S)
(21363,1894,1,1,-1,258750), -- Crafted Leather
(21363,4042,1,1,-1,122906), -- Enria
(21363,57,2968,6057,0,700000), -- Adena
(21363,5313,1,1,1,31), -- Sealed Gloves of Nightmare
(21363,5314,1,1,1,31), -- Sealed Boots of Nightmare
(21363,5318,1,1,1,31), -- Sealed Majestic Gloves
(21363,5319,1,1,1,31), -- Sealed Majestic Boots
(21363,5502,1,1,1,4599), -- Sealed Boots of Nightmare Lining
(21363,5503,1,1,1,4599), -- Sealed Majestic Boots Lining
(21363,5514,1,1,1,4599), -- Sealed Gloves of Nightmare Design
(21363,5515,1,1,1,4599), -- Sealed Majestic Gloves Design
(21363,959,1,1,2,15), -- Scroll: Enchant Weapon (Grade S)
(21363,1867,4,12,2,60508), -- Animal Skin
(21363,1872,1,3,2,161354), -- Animal Bone
(21363,1882,1,1,2,80677), -- Leather
(21363,1894,1,1,2,12739), -- Crafted Leather
(21363,4042,1,1,2,6051), -- Enria
(21364,6691,1,1,-1,20197), -- Angel Slayer Blade
(21364,6693,1,1,-1,20563), -- Dragon Hunter Axe Blade
(21364,6694,1,1,-1,20563), -- Saint Spear Blade
(21364,57,3760,7675,0,700000), -- Adena
(21364,5312,1,1,1,35), -- Sealed Helm of Nightmare
(21364,5315,1,1,1,50), -- Sealed Shield of Nightmare
(21364,5317,1,1,1,35), -- Sealed Majestic Circlet
(21364,5495,1,1,1,6985), -- Sealed Shield of Nightmare Fragment
(21364,5527,1,1,1,5500), -- Sealed Helm of Nightmare Design
(21364,5528,1,1,1,5500), -- Sealed Majestic Circlet Design
(21364,960,1,1,2,158), -- Scroll: Enchant Armor (Grade S)
(21364,1344,30,90,2,164288), -- Mithril Arrow
(21364,1868,4,12,2,98573), -- Thread
(21364,1873,1,1,2,157716), -- Silver Nugget
(21364,1889,1,1,2,26286), -- Compound Braid
(21364,4044,1,1,2,13143), -- Thons
(21364,5549,1,1,2,39429), -- Metallic Thread
(21365,959,1,1,-1,325), -- Scroll: Enchant Weapon (Grade S)
(21365,6688,1,1,-1,17550), -- Forgotten Blade Edge
(21365,6689,1,1,-1,17219), -- Basalt Battlehammer Head
(21365,57,3267,6667,0,700000), -- Adena
(21365,5320,1,1,1,16), -- Sealed Leather Armor of Nightmare
(21365,5323,1,1,1,16), -- Sealed Majestic Leather Armor
(21365,5480,1,1,1,2691), -- Sealed Leather Armor of Nightmare Fabric
(21365,5481,1,1,1,2691), -- Sealed Majestic Leather Armor Fabric
(21365,959,1,1,2,17), -- Scroll: Enchant Weapon (Grade S)
(21365,1867,1,3,2,177653), -- Animal Skin
(21365,1869,2,6,2,99930), -- Iron Ore
(21365,1870,2,6,2,79944), -- Coal
(21365,1871,3,9,2,66620), -- Charcoal
(21365,1872,7,21,2,38069), -- Animal Bone
(21366,6698,1,1,-1,175995), -- Sealed Tateossian Earring  Part
(21366,6699,1,1,-1,195290), -- Sealed Tateossian Ring Gem
(21366,6700,1,1,-1,107266), -- Sealed Tateossian Ring Wire
(21366,57,3605,7357,0,700000), -- Adena
(21366,5311,1,1,1,13), -- Sealed Armor of Nightmare
(21366,5316,1,1,1,13), -- Sealed Majestic Plate Armor
(21366,5522,1,1,1,2254), -- Sealed Armor of Nightmare Pattern
(21366,5523,1,1,1,2254), -- Sealed Majestic Plate Armor Pattern
(21366,960,1,1,2,177), -- Scroll: Enchant Armor (Grade S)
(21366,1344,20,60,2,275691), -- Mithril Arrow
(21366,1894,1,1,2,15478), -- Crafted Leather
(21366,4039,1,1,2,14704), -- Mold Glue
(21366,4041,1,1,2,3836), -- Mold Hardener
(21366,4044,1,1,2,14704), -- Thons
(21367,6710,1,1,-1,125594), -- Sealed Draconic Leather Helmet Pattern
(21367,6711,1,1,-1,38361), -- Sealed Major Arcana Robe Part
(21367,6712,1,1,-1,110234), -- Sealed Major Arcana Gloves fabric
(21367,57,3115,6359,0,700000), -- Adena
(21367,289,1,1,1,9), -- Soul Bow
(21367,5534,1,1,1,3140), -- Soul Bow Stave
(21367,960,1,1,2,153), -- Scroll: Enchant Armor (Grade S)
(21367,1344,20,60,2,238224), -- Mithril Arrow
(21367,1895,1,1,2,108903), -- Metallic Fiber
(21367,4040,1,1,2,7624), -- Mold Lubricant
(21367,4042,1,1,2,6353), -- Enria
(21367,4043,1,1,2,12706), -- Asofe
(21368,960,1,1,-1,4337), -- Scroll: Enchant Armor (Grade S)
(21368,1895,1,7,-1,774442), -- Metallic Fiber
(21368,4042,1,1,-1,180703), -- Enria
(21368,57,4362,8904,0,700000), -- Adena
(21368,236,1,1,1,12), -- Soul Separator
(21368,5537,1,1,1,4394), -- Soul Separator Head
(21368,959,1,1,2,19), -- Scroll: Enchant Weapon (Grade S)
(21368,1868,3,9,2,152506), -- Thread
(21368,1873,2,6,2,45752), -- Silver Nugget
(21368,1876,1,1,2,91504), -- Mithril Ore
(21368,1895,1,1,2,130719), -- Metallic Fiber
(21368,4042,1,1,2,7626), -- Enria
(21368,6672,1,1,2,38127), -- Deluxe Chest Key - Grade 8
(21369,5167,1,1,-1,4980), -- Recipe: Blessed Spiritshot (S) Compressed Package (100%)
(21369,5528,1,1,-1,133959), -- Sealed Majestic Circlet Design
(21369,5529,1,1,-1,30739), -- Dragon Slayer Edge
(21369,57,4498,9212,0,700000), -- Adena
(21369,305,1,1,1,13), -- Tallum Glaive
(21369,5541,1,1,1,4538), -- Tallum Glaive Edge
(21369,960,1,1,2,189), -- Scroll: Enchant Armor (Grade S)
(21369,1344,150,450,2,39401), -- Mithril Arrow
(21369,1868,4,12,2,118200), -- Thread
(21369,1873,1,1,2,189120), -- Silver Nugget
(21369,1889,1,1,2,31520), -- Compound Braid
(21369,4044,1,1,2,15760), -- Thons
(21369,5549,1,1,2,47280), -- Metallic Thread
(21370,4043,1,1,-1,270265), -- Asofe
(21370,5488,1,1,-1,36511), -- Sealed Majestic Robe Fabric
(21370,5550,1,1,-1,108106), -- Durable Metal Plate
(21370,57,3262,6659,0,700000), -- Adena
(21370,5326,1,1,1,16), -- Sealed Robe of Nightmare
(21370,5329,1,1,1,16), -- Sealed Majestic Robe
(21370,5487,1,1,1,2697), -- Sealed Robe of Nightmare Fabric
(21370,5488,1,1,1,2697), -- Sealed Majestic Robe Fabric
(21370,959,1,1,2,16), -- Scroll: Enchant Weapon (Grade S)
(21370,1864,4,12,2,99791), -- Stem
(21370,1869,1,3,2,133054), -- Iron Ore
(21370,1880,1,1,2,39917), -- Steel
(21370,4043,1,1,2,13306), -- Asofe
(21370,5550,1,1,2,5323), -- Durable Metal Plate
(21371,6713,1,1,-1,124021), -- Sealed Major Arcana Boots Design
(21371,6714,1,1,-1,141303), -- Sealed Major Arcana Circlet Pattern
(21371,7579,1,1,-1,19046), -- Draconic Bow Shaft
(21371,57,3504,7154,0,700000), -- Adena
(21371,236,1,1,1,10), -- Soul Separator
(21371,5537,1,1,1,3530), -- Soul Separator Head
(21371,960,1,1,2,172), -- Scroll: Enchant Armor (Grade S)
(21371,1344,20,60,2,268021), -- Mithril Arrow
(21371,1894,1,1,2,15047), -- Crafted Leather
(21371,4039,1,1,2,14295), -- Mold Glue
(21371,4041,1,1,2,3729), -- Mold Hardener
(21371,4044,1,1,2,14295), -- Thons
(21372,960,1,1,-1,3460), -- Scroll: Enchant Armor (Grade S)
(21372,1876,1,3,-1,865067), -- Mithril Ore
(21372,1895,1,5,-1,823874), -- Metallic Fiber
(21372,57,3481,7103,0,700000), -- Adena
(21372,5326,1,1,1,17), -- Sealed Robe of Nightmare
(21372,5329,1,1,1,17), -- Sealed Majestic Robe
(21372,5487,1,1,1,2877), -- Sealed Robe of Nightmare Fabric
(21372,5488,1,1,1,2877), -- Sealed Majestic Robe Fabric
(21372,959,1,1,2,18), -- Scroll: Enchant Weapon (Grade S)
(21372,1868,3,9,2,141960), -- Thread
(21372,1873,2,6,2,42588), -- Silver Nugget
(21372,1876,1,1,2,85176), -- Mithril Ore
(21372,1895,1,1,2,121680), -- Metallic Fiber
(21372,4042,1,1,2,7098), -- Enria
(21373,959,1,1,-1,510), -- Scroll: Enchant Weapon (Grade S)
(21373,1895,1,7,-1,910171), -- Metallic Fiber
(21373,4040,1,1,-1,254848), -- Mold Lubricant
(21373,57,5113,10480,0,700000), -- Adena
(21373,5326,1,1,1,25), -- Sealed Robe of Nightmare
(21373,5329,1,1,1,25), -- Sealed Majestic Robe
(21373,5487,1,1,1,4239), -- Sealed Robe of Nightmare Fabric
(21373,5488,1,1,1,4239), -- Sealed Majestic Robe Fabric
(21373,959,1,1,2,30), -- Scroll: Enchant Weapon (Grade S)
(21373,1895,1,1,2,215081), -- Metallic Fiber
(21373,4040,1,1,2,15056), -- Mold Lubricant
(21373,4042,1,1,2,12547), -- Enria
(21373,4043,1,1,2,25093), -- Asofe
(21374,6707,1,1,-1,44949), -- Sealed Draconic Leather Armor Part
(21374,6708,1,1,-1,129163), -- Sealed Draconic Leather Gloves Fabric
(21374,6709,1,1,-1,129163), -- Sealed Draconic Leather Boots Design
(21374,57,3643,7457,0,700000), -- Adena
(21374,305,1,1,1,10), -- Tallum Glaive
(21374,5541,1,1,1,3675), -- Tallum Glaive Edge
(21374,960,1,1,2,179), -- Scroll: Enchant Armor (Grade S)
(21374,1868,3,9,2,148869), -- Thread
(21374,1873,2,6,2,44661), -- Silver Nugget
(21374,1876,1,1,2,89322), -- Mithril Ore
(21374,1895,1,1,2,127602), -- Metallic Fiber
(21374,4042,1,1,2,7444), -- Enria
(21375,960,1,1,-1,3497), -- Scroll: Enchant Armor (Grade S)
(21375,1877,1,1,-1,349708), -- Adamantite Nugget
(21375,4040,1,1,-1,174854), -- Mold Lubricant
(21375,57,3511,7187,0,700000), -- Adena
(21375,5320,1,1,1,17), -- Sealed Leather Armor of Nightmare
(21375,5323,1,1,1,17), -- Sealed Majestic Leather Armor
(21375,5480,1,1,1,2898), -- Sealed Leather Armor of Nightmare Fabric
(21375,5481,1,1,1,2898), -- Sealed Majestic Leather Armor Fabric
(21375,959,1,1,2,18), -- Scroll: Enchant Weapon (Grade S)
(21375,1866,1,3,2,95647), -- Suede
(21375,1871,1,3,2,215205), -- Charcoal
(21375,1877,1,1,2,17217), -- Adamantite Nugget
(21375,4040,1,1,2,8609), -- Mold Lubricant
(21375,4041,1,1,2,3743), -- Mold Hardener
(21376,1875,1,1,-1,820385), -- Stone of Purity
(21376,4041,1,1,-1,107007), -- Mold Hardener
(21376,5544,1,1,-1,33721), -- Branch of The Mother Tree Head
(21376,57,4952,10108,0,700000), -- Adena
(21376,235,1,1,1,20), -- Bloody Orchid
(21376,5536,1,1,1,6184), -- Bloody Orchid Head
(21376,1867,1,3,2,269255), -- Animal Skin
(21376,1872,4,12,2,100971), -- Animal Bone
(21376,1875,1,1,2,40389), -- Stone of Purity
(21376,1881,1,1,2,80777), -- Coarse Bone Powder
(21376,3036,1,1,2,270), -- Recipe: Spiritshot S
(21376,4041,1,1,2,5268), -- Mold Hardener
(21377,1808,1,1,-1,5353), -- Recipe: Soulshot: S Grade
(21377,5545,1,1,-1,33041), -- Dark Legion\'s Edge Blade
(21377,5546,1,1,-1,36292), -- Sword of Miracles Edge
(21377,57,4847,9892,0,700000), -- Adena
(21377,5287,1,1,1,26), -- Sealed Dark Crystal breastplate
(21377,5288,1,1,1,42), -- Sealed Dark Crystal Gaiters
(21377,5293,1,1,1,18), -- Sealed Tallum Plate Armor
(21377,5520,1,1,1,3824), -- Sealed Dark Crystal Breastplate Pattern
(21377,5521,1,1,1,2699), -- Sealed Tallum Plate Armor Pattern
(21377,5524,1,1,1,5845), -- Sealed Dark Crystal Gaiters Pattern
(21377,1344,150,450,2,42351), -- Mithril Arrow
(21377,1868,4,12,2,127052), -- Thread
(21377,1873,3,9,2,33881), -- Silver Nugget
(21377,1876,1,1,2,101642), -- Mithril Ore
(21377,1895,1,1,2,145203), -- Metallic Fiber
(21377,3957,1,1,2,226), -- Recipe: Blessed Spiritshot S
(21377,4042,1,1,2,8471), -- Enria
(21378,1889,1,3,-1,492955), -- Compound Braid
(21378,5282,1,1,-1,6573), -- Recipe: Greater Blessed Spiritshot (S) Compressed Package(100%)
(21378,5514,1,1,-1,249766), -- Sealed Gloves of Nightmare Design
(21378,57,5950,12144,0,700000), -- Adena
(21378,236,1,1,1,17), -- Soul Separator
(21378,5537,1,1,1,5992), -- Soul Separator Head
(21378,959,1,1,2,29), -- Scroll: Enchant Weapon (Grade S)
(21378,1868,3,9,2,242686), -- Thread
(21378,1873,2,6,2,72806), -- Silver Nugget
(21378,1889,1,1,2,48538), -- Compound Braid
(21378,4044,1,1,2,24269), -- Thons
(21378,5549,1,1,2,72806), -- Metallic Thread
(21379,5515,1,1,-1,209654), -- Sealed Majestic Gloves Design
(21379,5522,1,1,-1,42275), -- Sealed Armor of Nightmare Pattern
(21379,6901,1,1,-1,12414), -- Recipe: Shining Arrow (100%)
(21379,57,4995,10193,0,700000), -- Adena
(21379,5311,1,1,1,18), -- Sealed Armor of Nightmare
(21379,5316,1,1,1,18), -- Sealed Majestic Plate Armor
(21379,5522,1,1,1,3122), -- Sealed Armor of Nightmare Pattern
(21379,5523,1,1,1,3122), -- Sealed Majestic Plate Armor Pattern
(21379,960,1,1,2,210), -- Scroll: Enchant Armor (Grade S)
(21379,1344,40,120,2,163697), -- Mithril Arrow
(21379,1864,5,15,2,104766), -- Stem
(21379,1865,3,9,2,87305), -- Varnish
(21379,1866,3,9,2,49889), -- Suede
(21379,1868,12,36,2,43653), -- Thread
(21379,1873,4,12,2,23282), -- Silver Nugget
(21380,1808,1,1,-1,5625), -- Recipe: Soulshot: S Grade
(21380,5481,1,1,-1,56792), -- Sealed Majestic Leather Armor Fabric
(21380,5523,1,1,-1,43102), -- Sealed Majestic Plate Armor Pattern
(21380,57,5093,10393,0,700000), -- Adena
(21380,164,1,1,1,7), -- Elysian
(21380,213,1,1,1,7), -- Branch of The Mother Tree
(21380,5533,1,1,1,2565), -- Elysian Head
(21380,5544,1,1,1,2562), -- Branch of The Mother Tree Head
(21380,959,1,1,2,25), -- Scroll: Enchant Weapon (Grade S)
(21380,1867,12,36,2,34616), -- Animal Skin
(21380,1869,2,6,2,155773), -- Iron Ore
(21380,1870,2,6,2,124618), -- Coal
(21380,1871,3,9,2,103848), -- Charcoal
(21380,1872,7,21,2,59342), -- Animal Bone
(21381,3957,1,1,-1,6149), -- Recipe: Blessed Spiritshot S
(21381,5157,1,1,-1,6149), -- Recipe: Soulshot (S) Compressed Package (100%)
(21381,5495,1,1,-1,210102), -- Sealed Shield of Nightmare Fragment
(21381,57,5566,11364,0,700000), -- Adena
(21381,305,1,1,1,16), -- Tallum Glaive
(21381,5541,1,1,1,5604), -- Tallum Glaive Edge
(21381,960,1,1,2,234), -- Scroll: Enchant Armor (Grade S)
(21381,1344,40,120,2,182457), -- Mithril Arrow
(21381,1867,5,15,2,77849), -- Animal Skin
(21381,1872,9,27,2,43249), -- Animal Bone
(21381,1882,1,1,2,129747), -- Leather
(21381,1894,1,1,2,20487), -- Crafted Leather
(21381,4042,1,1,2,9731), -- Enria
(21382,1889,1,3,-1,491264), -- Compound Braid
(21382,5502,1,1,-1,248909), -- Sealed Boots of Nightmare Lining
(21382,5549,1,3,-1,736897), -- Metallic Thread
(21382,57,5929,12104,0,700000), -- Adena
(21382,5320,1,1,1,29), -- Sealed Leather Armor of Nightmare
(21382,5323,1,1,1,29), -- Sealed Majestic Leather Armor
(21382,5480,1,1,1,4885), -- Sealed Leather Armor of Nightmare Fabric
(21382,5481,1,1,1,4885), -- Sealed Majestic Leather Armor Fabric
(21382,959,1,1,2,29), -- Scroll: Enchant Weapon (Grade S)
(21382,1868,3,9,2,241854), -- Thread
(21382,1873,2,6,2,72557), -- Silver Nugget
(21382,1889,1,1,2,48371), -- Compound Braid
(21382,4044,1,1,2,24186), -- Thons
(21382,5549,1,1,2,72557), -- Metallic Thread
(21383,5162,1,1,-1,7001), -- Recipe: Spiritshot (S) Compressed Package (100%)
(21383,5503,1,1,-1,266055), -- Sealed Majestic Boots Lining
(21383,5514,1,1,-1,266055), -- Sealed Gloves of Nightmare Design
(21383,57,6337,12938,0,700000), -- Adena
(21383,5311,1,1,1,23), -- Sealed Armor of Nightmare
(21383,5316,1,1,1,23), -- Sealed Majestic Plate Armor
(21383,5522,1,1,1,3962), -- Sealed Armor of Nightmare Pattern
(21383,5523,1,1,1,3962), -- Sealed Majestic Plate Armor Pattern
(21383,960,1,1,2,266), -- Scroll: Enchant Armor (Grade S)
(21383,1344,400,1200,2,20774), -- Mithril Arrow
(21383,1864,5,15,2,132950), -- Stem
(21383,1865,3,9,2,110792), -- Varnish
(21383,1866,3,9,2,63309), -- Suede
(21383,1868,12,36,2,55396), -- Thread
(21383,1873,4,12,2,29545), -- Silver Nugget
(21384,1875,1,3,-1,488972), -- Stone of Purity
(21384,4041,1,1,-1,127558), -- Mold Hardener
(21384,5533,1,1,-1,40237), -- Elysian Head
(21384,57,5890,12060,0,700000), -- Adena
(21384,5320,1,1,1,29), -- Sealed Leather Armor of Nightmare
(21384,5323,1,1,1,29), -- Sealed Majestic Leather Armor
(21384,5480,1,1,1,4862), -- Sealed Leather Armor of Nightmare Fabric
(21384,5481,1,1,1,4862), -- Sealed Majestic Leather Armor Fabric
(21384,959,1,1,2,29), -- Scroll: Enchant Weapon (Grade S)
(21384,1867,7,21,2,64194), -- Animal Skin
(21384,1872,4,12,2,120363), -- Animal Bone
(21384,1875,1,1,2,48145), -- Stone of Purity
(21384,1881,1,1,2,96290), -- Coarse Bone Powder
(21384,4041,1,1,2,6280), -- Mold Hardener
(21385,5272,1,1,-1,6166), -- Recipe: Greater Soulshot (S) Compressed Package(100%)
(21385,5277,1,1,-1,6166), -- Recipe: Greater Spiritshot (S) Compressed Package(100%)
(21385,5534,1,1,-1,38091), -- Soul Bow Stave
(21385,57,5571,11407,0,700000), -- Adena
(21385,5311,1,1,1,20), -- Sealed Armor of Nightmare
(21385,5316,1,1,1,20), -- Sealed Majestic Plate Armor
(21385,5522,1,1,1,3490), -- Sealed Armor of Nightmare Pattern
(21385,5523,1,1,1,3490), -- Sealed Majestic Plate Armor Pattern
(21385,960,1,1,2,235), -- Scroll: Enchant Armor (Grade S)
(21385,1344,150,450,2,48790), -- Mithril Arrow
(21385,1868,4,12,2,146369), -- Thread
(21385,1873,3,9,2,39032), -- Silver Nugget
(21385,1876,1,1,2,117095), -- Mithril Ore
(21385,1895,3,9,2,23897), -- Metallic Fiber
(21385,4042,1,1,2,9758), -- Enria
(21386,1877,1,1,-1,572799), -- Adamantite Nugget
(21386,4041,1,1,-1,124522), -- Mold Hardener
(21386,5537,1,1,-1,39287), -- Soul Separator Head
(21386,57,5749,11773,0,700000), -- Adena
(21386,5326,1,1,1,28), -- Sealed Robe of Nightmare
(21386,5329,1,1,1,28), -- Sealed Majestic Robe
(21386,5487,1,1,1,4763), -- Sealed Robe of Nightmare Fabric
(21386,5488,1,1,1,4763), -- Sealed Majestic Robe Fabric
(21386,959,1,1,2,29), -- Scroll: Enchant Weapon (Grade S)
(21386,1866,1,3,2,156664), -- Suede
(21386,1871,4,12,2,88124), -- Charcoal
(21386,1877,1,1,2,28200), -- Adamantite Nugget
(21386,4040,1,1,2,14100), -- Mold Lubricant
(21386,4041,1,1,2,6131), -- Mold Hardener
(21387,1895,1,7,-1,918637), -- Metallic Fiber
(21387,4042,1,1,-1,214349), -- Enria
(21387,5522,1,1,-1,43798), -- Sealed Armor of Nightmare Pattern
(21387,57,5163,10575,0,700000), -- Adena
(21387,6326,1,1,1,49), -- Sealed Majestic Necklace
(21387,6327,1,1,1,65), -- Sealed Majestic Earring
(21387,6328,1,1,1,98), -- Sealed Majestic Ring
(21387,6342,1,1,1,14343), -- Sealed Majestic Earring Gemstone
(21387,6344,1,1,1,9282), -- Sealed Majestic Necklace Beads
(21387,6346,1,1,1,20614), -- Sealed Majestic Ring Gemstone
(21387,959,1,1,2,25), -- Scroll: Enchant Weapon (Grade S)
(21387,1868,15,45,2,42211), -- Thread
(21387,1873,2,6,2,63316), -- Silver Nugget
(21387,1876,1,1,2,126631), -- Mithril Ore
(21387,1895,1,1,2,180902), -- Metallic Fiber
(21387,4042,1,1,2,10553), -- Enria
(21388,1808,1,1,-1,8647), -- Recipe: Soulshot: S Grade
(21388,5523,1,1,-1,66254), -- Sealed Majestic Plate Armor Pattern
(21388,5527,1,1,-1,232602), -- Sealed Helm of Nightmare Design
(21388,57,7810,15997,0,700000), -- Adena
(21388,5313,1,1,1,82), -- Sealed Gloves of Nightmare
(21388,5314,1,1,1,82), -- Sealed Boots of Nightmare
(21388,5318,1,1,1,82), -- Sealed Majestic Gloves
(21388,5319,1,1,1,82), -- Sealed Majestic Boots
(21388,5502,1,1,1,12131), -- Sealed Boots of Nightmare Lining
(21388,5503,1,1,1,12131), -- Sealed Majestic Boots Lining
(21388,5514,1,1,1,12131), -- Sealed Gloves of Nightmare Design
(21388,5515,1,1,1,12131), -- Sealed Majestic Gloves Design
(21388,960,1,1,2,329), -- Scroll: Enchant Armor (Grade S)
(21388,1344,280,840,2,36650), -- Mithril Arrow
(21388,1867,9,27,2,60811), -- Animal Skin
(21388,1872,5,15,2,109461), -- Animal Bone
(21388,1875,1,1,2,54730), -- Stone of Purity
(21388,1881,1,1,2,109461), -- Coarse Bone Powder
(21388,4041,1,1,2,7139), -- Mold Hardener
(21389,959,1,1,-1,711), -- Scroll: Enchant Weapon (Grade S)
(21389,6690,1,1,-1,38470), -- Imperial Staff Head
(21389,6691,1,1,-1,38397), -- Angel Slayer Blade
(21389,57,7149,14591,0,700000), -- Adena
(21389,81,1,1,1,7), -- Dragon Slayer
(21389,151,1,1,1,7), -- Sword of Miracles 
(21389,2500,1,1,1,7), -- Dark Legion\'s Edge
(21389,5529,1,1,1,2400), -- Dragon Slayer Edge
(21389,5545,1,1,1,2400), -- Dark Legion\'s Edge Blade
(21389,5546,1,1,1,2636), -- Sword of Miracles Edge
(21389,959,1,1,2,36), -- Scroll: Enchant Weapon (Grade S)
(21389,1864,36,108,2,24293), -- Stem
(21389,1865,2,6,2,174909), -- Varnish
(21389,1866,3,9,2,97172), -- Suede
(21389,1868,10,30,2,83290), -- Thread
(21389,1873,4,12,2,43728), -- Silver Nugget
(21390,6701,1,1,-1,110268), -- Sealed Imperial Crusader Breastplate Part
(21390,6702,1,1,-1,141944), -- Sealed Imperial Crusader Gaiters Pattern
(21390,6703,1,1,-1,294882), -- Sealed Imperial Crusader Gauntlets Design
(21390,57,8333,17007,0,700000), -- Adena
(21390,6326,1,1,1,79), -- Sealed Majestic Necklace
(21390,6327,1,1,1,105), -- Sealed Majestic Earring
(21390,6328,1,1,1,157), -- Sealed Majestic Ring
(21390,6342,1,1,1,23097), -- Sealed Majestic Earring Gemstone
(21390,6344,1,1,1,14947), -- Sealed Majestic Necklace Beads
(21390,6346,1,1,1,33196), -- Sealed Majestic Ring Gemstone
(21390,960,1,1,2,350), -- Scroll: Enchant Armor (Grade S)
(21390,1344,280,840,2,39017), -- Mithril Arrow
(21390,1867,9,27,2,64738), -- Animal Skin
(21390,1872,5,15,2,116529), -- Animal Bone
(21390,1875,1,1,2,58264), -- Stone of Purity
(21390,1881,1,1,2,116529), -- Coarse Bone Powder
(21390,4041,1,1,2,7600), -- Mold Hardener
(21391,6695,1,1,-1,35325), -- Demon Splinter Blade
(21391,6696,1,1,-1,36575), -- Heavens Divider Edge
(21391,6697,1,1,-1,35325), -- Arcana Mace Head
(21391,57,6703,13681,0,700000), -- Adena
(21391,164,1,1,1,10), -- Elysian
(21391,213,1,1,1,10), -- Branch of The Mother Tree
(21391,5533,1,1,1,3375), -- Elysian Head
(21391,5544,1,1,1,3372), -- Branch of The Mother Tree Head
(21391,960,1,1,2,282), -- Scroll: Enchant Armor (Grade S)
(21391,1344,400,1200,2,21966), -- Mithril Arrow
(21391,1867,13,39,2,34710), -- Animal Skin
(21391,1869,2,6,2,140576), -- Iron Ore
(21391,1870,3,9,2,117147), -- Coal
(21391,1871,3,9,2,100412), -- Charcoal
(21391,1872,8,24,2,58574), -- Animal Bone
(21392,959,1,1,-1,822), -- Scroll: Enchant Weapon (Grade S)
(21392,4044,1,1,-1,684717), -- Thons
(21392,5549,1,5,-1,684717), -- Metallic Thread
(21392,57,8265,16868,0,700000), -- Adena
(21392,5313,1,1,1,87), -- Sealed Gloves of Nightmare
(21392,5314,1,1,1,87), -- Sealed Boots of Nightmare
(21392,5318,1,1,1,87), -- Sealed Majestic Gloves
(21392,5319,1,1,1,87), -- Sealed Majestic Boots
(21392,5502,1,1,1,12809), -- Sealed Boots of Nightmare Lining
(21392,5503,1,1,1,12809), -- Sealed Majestic Boots Lining
(21392,5514,1,1,1,12809), -- Sealed Gloves of Nightmare Design
(21392,5515,1,1,1,12809), -- Sealed Majestic Gloves Design
(21392,959,1,1,2,41), -- Scroll: Enchant Weapon (Grade S)
(21392,1868,15,45,2,67419), -- Thread
(21392,1873,2,6,2,101128), -- Silver Nugget
(21392,1889,1,1,2,67419), -- Compound Braid
(21392,4044,1,1,2,33710), -- Thons
(21392,5549,1,1,2,101128), -- Metallic Thread
(21393,959,1,1,-1,740), -- Scroll: Enchant Weapon (Grade S)
(21393,1877,1,1,-1,740087), -- Adamantite Nugget
(21393,4041,1,1,-1,160889), -- Mold Hardener
(21393,57,7443,15195,0,700000), -- Adena
(21393,305,1,1,1,21), -- Tallum Glaive
(21393,5541,1,1,1,7494), -- Tallum Glaive Edge
(21393,959,1,1,2,37), -- Scroll: Enchant Weapon (Grade S)
(21393,1866,1,3,2,202418), -- Suede
(21393,1871,4,12,2,113860), -- Charcoal
(21393,1877,1,1,2,36436), -- Adamantite Nugget
(21393,4040,1,1,2,18218), -- Mold Lubricant
(21393,4041,1,1,2,7921), -- Mold Hardener
(21394,1808,1,1,-1,6211), -- Recipe: Soulshot: S Grade
(21394,3036,1,1,-1,6211), -- Recipe: Spiritshot S
(21394,5527,1,1,-1,167086), -- Sealed Helm of Nightmare Design
(21394,57,5623,11476,0,700000), -- Adena
(21394,270,1,1,1,16), -- Dragon Grinder
(21394,5538,1,1,1,5662), -- Dragon Grinder Edge
(21394,960,1,1,2,276), -- Scroll: Enchant Armor (Grade S)
(21394,1344,60,180,2,143335), -- Mithril Arrow
(21394,1894,1,1,2,24141), -- Crafted Leather
(21394,4039,1,1,2,22934), -- Mold Glue
(21394,4041,1,1,2,5983), -- Mold Hardener
(21394,4044,1,1,2,22934), -- Thons
(21395,960,1,1,-1,7328), -- Scroll: Enchant Armor (Grade S)
(21395,1894,1,1,-1,642786), -- Crafted Leather
(21395,4039,1,1,-1,610647), -- Mold Glue
(21395,57,7372,15047,0,700000), -- Adena
(21395,270,1,1,1,21), -- Dragon Grinder
(21395,5538,1,1,1,7422), -- Dragon Grinder Edge
(21395,959,1,1,2,44), -- Scroll: Enchant Weapon (Grade S)
(21395,1894,1,1,2,37974), -- Crafted Leather
(21395,4039,1,1,2,36076), -- Mold Glue
(21395,4041,1,1,2,9411), -- Mold Hardener
(21395,4044,1,1,2,36076), -- Thons
(21396,3036,1,1,-1,3389), -- Recipe: Spiritshot S
(21396,4040,1,1,-1,152522), -- Mold Lubricant
(21396,6342,1,1,-1,172751), -- Sealed Majestic Earring Gemstone
(21396,57,3069,6264,0,700000), -- Adena
(21396,212,1,1,1,7), -- Dasparion\'s Staff
(21396,2504,1,1,1,7), -- Meteor Shower
(21396,5532,1,1,1,1899), -- Meteor Shower Head
(21396,5543,1,1,1,1917), -- Dasparion\'s Staff Edge
(21396,1866,1,1,2,250293), -- Suede
(21396,1871,1,3,2,187720), -- Charcoal
(21396,1877,1,1,2,15018), -- Adamantite Nugget
(21396,4040,1,1,2,7509), -- Mold Lubricant
(21396,4041,1,1,2,3265), -- Mold Hardener
(21396,5157,1,1,2,167), -- Recipe: Soulshot (S) Compressed Package (100%)
(21397,3036,1,1,-1,3304), -- Recipe: Spiritshot S
(21397,4040,1,1,-1,148684), -- Mold Lubricant
(21397,6342,1,1,-1,168404), -- Sealed Majestic Earring Gemstone
(21397,57,2992,6106,0,700000), -- Adena
(21397,212,1,1,1,6), -- Dasparion\'s Staff
(21397,2504,1,1,1,6), -- Meteor Shower
(21397,5532,1,1,1,1851), -- Meteor Shower Head
(21397,5543,1,1,1,1869), -- Dasparion\'s Staff Edge
(21397,1866,1,1,2,243995), -- Suede
(21397,1871,1,3,2,182996), -- Charcoal
(21397,1877,1,1,2,14640), -- Adamantite Nugget
(21397,4040,1,1,2,7320), -- Mold Lubricant
(21397,4041,1,1,2,3183), -- Mold Hardener
(21397,5157,1,1,2,163), -- Recipe: Soulshot (S) Compressed Package (100%)
(21398,5157,1,1,-1,6274), -- Recipe: Soulshot (S) Compressed Package (100%)
(21398,5480,1,1,-1,63343), -- Sealed Leather Armor of Nightmare Fabric
(21398,6346,1,1,-1,459587), -- Sealed Majestic Ring Gemstone
(21398,57,5681,11595,0,700000), -- Adena
(21398,98,1,1,1,23), -- Halberd
(21398,5542,1,1,1,7032), -- Halberd Edge
(21398,1895,1,1,2,238270), -- Metallic Fiber
(21398,4040,1,1,2,16679), -- Mold Lubricant
(21398,4042,1,1,2,13900), -- Enria
(21398,4043,1,1,2,27799), -- Asofe
(21398,5167,1,1,2,371), -- Recipe: Blessed Spiritshot (S) Compressed Package (100%)
(21399,5157,1,1,-1,5506), -- Recipe: Soulshot (S) Compressed Package (100%)
(21399,5480,1,1,-1,55588), -- Sealed Leather Armor of Nightmare Fabric
(21399,6346,1,1,-1,403326), -- Sealed Majestic Ring Gemstone
(21399,57,4986,10175,0,700000), -- Adena
(21399,98,1,1,1,20), -- Halberd
(21399,5542,1,1,1,6172), -- Halberd Edge
(21399,1895,1,1,2,209102), -- Metallic Fiber
(21399,4040,1,1,2,14638), -- Mold Lubricant
(21399,4042,1,1,2,12198), -- Enria
(21399,4043,1,1,2,24396), -- Asofe
(21399,5167,1,1,2,326), -- Recipe: Blessed Spiritshot (S) Compressed Package (100%)
(21400,1876,1,5,-1,770779), -- Mithril Ore
(21400,4042,1,1,-1,192695), -- Enria
(21400,5528,1,1,-1,138232), -- Sealed Majestic Circlet Design
(21400,57,4652,9494,0,700000), -- Adena
(21400,305,1,1,1,13), -- Tallum Glaive
(21400,5541,1,1,1,4683), -- Tallum Glaive Edge
(21400,959,1,1,2,23), -- Scroll: Enchant Weapon (Grade S)
(21400,1868,15,45,2,37947), -- Thread
(21400,1873,2,6,2,56920), -- Silver Nugget
(21400,1876,1,1,2,113839), -- Mithril Ore
(21400,1895,1,1,2,162627), -- Metallic Fiber
(21400,4042,1,1,2,9487), -- Enria
(21401,1876,1,5,-1,678250), -- Mithril Ore
(21401,4042,1,1,-1,169563), -- Enria
(21401,5528,1,1,-1,121637), -- Sealed Majestic Circlet Design
(21401,57,4094,8354,0,700000), -- Adena
(21401,305,1,1,1,12), -- Tallum Glaive
(21401,5541,1,1,1,4121), -- Tallum Glaive Edge
(21401,959,1,1,2,21), -- Scroll: Enchant Weapon (Grade S)
(21401,1868,3,9,2,166954), -- Thread
(21401,1873,2,6,2,50087), -- Silver Nugget
(21401,1876,1,1,2,100172), -- Mithril Ore
(21401,1895,1,1,2,143103), -- Metallic Fiber
(21401,4042,1,1,2,8348), -- Enria
(21402,4044,1,1,-1,349920), -- Thons
(21402,5157,1,1,-1,4666), -- Recipe: Soulshot (S) Compressed Package (100%)
(21402,5534,1,1,-1,28820), -- Soul Bow Stave
(21402,57,4224,8620,0,700000), -- Adena
(21402,289,1,1,1,12), -- Soul Bow
(21402,5534,1,1,1,4257), -- Soul Bow Stave
(21402,959,1,1,2,21), -- Scroll: Enchant Weapon (Grade S)
(21402,1868,3,9,2,172269), -- Thread
(21402,1873,1,1,2,206722), -- Silver Nugget
(21402,1889,1,1,2,34454), -- Compound Braid
(21402,4044,1,1,2,17227), -- Thons
(21402,5549,1,1,2,51681), -- Metallic Thread
(21403,4044,1,1,-1,403892), -- Thons
(21403,5157,1,1,-1,5385), -- Recipe: Soulshot (S) Compressed Package (100%)
(21403,5534,1,1,-1,33265), -- Soul Bow Stave
(21403,57,4875,9950,0,700000), -- Adena
(21403,289,1,1,1,14), -- Soul Bow
(21403,5534,1,1,1,4913), -- Soul Bow Stave
(21403,959,1,1,2,24), -- Scroll: Enchant Weapon (Grade S)
(21403,1868,3,9,2,198840), -- Thread
(21403,1873,2,6,2,59652), -- Silver Nugget
(21403,1889,1,1,2,39768), -- Compound Braid
(21403,4044,1,1,2,19884), -- Thons
(21403,5549,1,1,2,59652), -- Metallic Thread
(21404,5167,1,1,-1,6233), -- Recipe: Blessed Spiritshot (S) Compressed Package (100%)
(21404,5515,1,1,-1,236857), -- Sealed Majestic Gloves Design
(21404,6901,1,1,-1,14024), -- Recipe: Shining Arrow (100%)
(21404,57,5642,11518,0,700000), -- Adena
(21404,5326,1,1,1,27), -- Sealed Robe of Nightmare
(21404,5329,1,1,1,27), -- Sealed Majestic Robe
(21404,5487,1,1,1,4665), -- Sealed Robe of Nightmare Fabric
(21404,5488,1,1,1,4665), -- Sealed Majestic Robe Fabric
(21404,959,1,1,2,28), -- Scroll: Enchant Weapon (Grade S)
(21404,1867,12,36,2,38358), -- Animal Skin
(21404,1869,18,54,2,19179), -- Iron Ore
(21404,1870,2,6,2,138087), -- Coal
(21404,1871,3,9,2,115072), -- Charcoal
(21404,1872,7,21,2,65756), -- Animal Bone
(21405,5167,1,1,-1,4454), -- Recipe: Blessed Spiritshot (S) Compressed Package (100%)
(21405,5515,1,1,-1,169243), -- Sealed Majestic Gloves Design
(21405,6901,1,1,-1,10021), -- Recipe: Shining Arrow (100%)
(21405,57,4031,8230,0,700000), -- Adena
(21405,5326,1,1,1,20), -- Sealed Robe of Nightmare
(21405,5329,1,1,1,20), -- Sealed Majestic Robe
(21405,5487,1,1,1,3333), -- Sealed Robe of Nightmare Fabric
(21405,5488,1,1,1,3333), -- Sealed Majestic Robe Fabric
(21405,959,1,1,2,20), -- Scroll: Enchant Weapon (Grade S)
(21405,1867,12,36,2,27408), -- Animal Skin
(21405,1869,2,6,2,123334), -- Iron Ore
(21405,1870,2,6,2,98667), -- Coal
(21405,1871,3,9,2,82223), -- Charcoal
(21405,1872,7,21,2,46985), -- Animal Bone
(21406,5277,1,1,-1,6066), -- Recipe: Greater Spiritshot (S) Compressed Package(100%)
(21406,5523,1,1,-1,46482), -- Sealed Majestic Plate Armor Pattern
(21406,5527,1,1,-1,163187), -- Sealed Helm of Nightmare Design
(21406,57,5491,11210,0,700000), -- Adena
(21406,5313,1,1,1,58), -- Sealed Gloves of Nightmare
(21406,5314,1,1,1,58), -- Sealed Boots of Nightmare
(21406,5318,1,1,1,58), -- Sealed Majestic Gloves
(21406,5319,1,1,1,58), -- Sealed Majestic Boots
(21406,5502,1,1,1,8511), -- Sealed Boots of Nightmare Lining
(21406,5503,1,1,1,8511), -- Sealed Majestic Boots Lining
(21406,5514,1,1,1,8511), -- Sealed Gloves of Nightmare Design
(21406,5515,1,1,1,8511), -- Sealed Majestic Gloves Design
(21406,959,1,1,2,27), -- Scroll: Enchant Weapon (Grade S)
(21406,1868,15,45,2,44797), -- Thread
(21406,1873,2,6,2,67195), -- Silver Nugget
(21406,1876,1,1,2,134391), -- Mithril Ore
(21406,1895,1,1,2,191986), -- Metallic Fiber
(21406,4042,1,1,2,11200), -- Enria
(21407,5277,1,1,-1,3888), -- Recipe: Greater Spiritshot (S) Compressed Package(100%)
(21407,5523,1,1,-1,29795), -- Sealed Majestic Plate Armor Pattern
(21407,5527,1,1,-1,104602), -- Sealed Helm of Nightmare Design
(21407,57,3520,7185,0,700000), -- Adena
(21407,5313,1,1,1,37), -- Sealed Gloves of Nightmare
(21407,5314,1,1,1,37), -- Sealed Boots of Nightmare
(21407,5318,1,1,1,37), -- Sealed Majestic Gloves
(21407,5319,1,1,1,37), -- Sealed Majestic Boots
(21407,5502,1,1,1,5456), -- Sealed Boots of Nightmare Lining
(21407,5503,1,1,1,5456), -- Sealed Majestic Boots Lining
(21407,5514,1,1,1,5456), -- Sealed Gloves of Nightmare Design
(21407,5515,1,1,1,5456), -- Sealed Majestic Gloves Design
(21407,959,1,1,2,18), -- Scroll: Enchant Weapon (Grade S)
(21407,1868,3,9,2,143572), -- Thread
(21407,1873,2,6,2,43072), -- Silver Nugget
(21407,1876,1,1,2,86143), -- Mithril Ore
(21407,1895,1,1,2,123062), -- Metallic Fiber
(21407,4042,1,1,2,7179), -- Enria
(21408,5282,1,1,-1,5732), -- Recipe: Greater Blessed Spiritshot (S) Compressed Package(100%)
(21408,5529,1,1,-1,35381), -- Dragon Slayer Edge
(21408,6901,1,1,-1,12896), -- Recipe: Shining Arrow (100%)
(21408,57,5188,10592,0,700000), -- Adena
(21408,81,1,1,1,5), -- Dragon Slayer
(21408,151,1,1,1,5), -- Sword of Miracles 
(21408,2500,1,1,1,5), -- Dark Legion\'s Edge
(21408,5529,1,1,1,1743), -- Dragon Slayer Edge
(21408,5545,1,1,1,1743), -- Dark Legion\'s Edge Blade
(21408,5546,1,1,1,1914), -- Sword of Miracles Edge
(21408,959,1,1,2,25), -- Scroll: Enchant Weapon (Grade S)
(21408,1868,3,9,2,211631), -- Thread
(21408,1873,2,6,2,63490), -- Silver Nugget
(21408,1889,1,1,2,42327), -- Compound Braid
(21408,4044,1,1,2,21163), -- Thons
(21408,5549,1,1,2,63490), -- Metallic Thread
(21409,5282,1,1,-1,6410), -- Recipe: Greater Blessed Spiritshot (S) Compressed Package(100%)
(21409,5529,1,1,-1,39565), -- Dragon Slayer Edge
(21409,6901,1,1,-1,14422), -- Recipe: Shining Arrow (100%)
(21409,57,5802,11844,0,700000), -- Adena
(21409,81,1,1,1,6), -- Dragon Slayer
(21409,151,1,1,1,6), -- Sword of Miracles 
(21409,2500,1,1,1,6), -- Dark Legion\'s Edge
(21409,5529,1,1,1,1949), -- Dragon Slayer Edge
(21409,5545,1,1,1,1949), -- Dark Legion\'s Edge Blade
(21409,5546,1,1,1,2140), -- Sword of Miracles Edge
(21409,959,1,1,2,28), -- Scroll: Enchant Weapon (Grade S)
(21409,1868,3,9,2,236663), -- Thread
(21409,1873,2,6,2,70999), -- Silver Nugget
(21409,1889,1,1,2,47333), -- Compound Braid
(21409,4044,1,1,2,23667), -- Thons
(21409,5549,1,1,2,70999), -- Metallic Thread
(21410,5282,1,1,-1,5808), -- Recipe: Greater Blessed Spiritshot (S) Compressed Package(100%)
(21410,5538,1,1,-1,35845), -- Dragon Grinder Edge
(21410,5541,1,1,-1,35838), -- Tallum Glaive Edge
(21410,57,5247,10744,0,700000), -- Adena
(21410,6326,1,1,1,50), -- Sealed Majestic Necklace
(21410,6327,1,1,1,66), -- Sealed Majestic Earring
(21410,6328,1,1,1,99), -- Sealed Majestic Ring
(21410,6342,1,1,1,14574), -- Sealed Majestic Earring Gemstone
(21410,6344,1,1,1,9432), -- Sealed Majestic Necklace Beads
(21410,6346,1,1,1,20946), -- Sealed Majestic Ring Gemstone
(21410,960,1,1,2,221), -- Scroll: Enchant Armor (Grade S)
(21410,1344,40,120,2,172326), -- Mithril Arrow
(21410,1867,5,15,2,73526), -- Animal Skin
(21410,1872,9,27,2,40848), -- Animal Bone
(21410,1882,1,1,2,122543), -- Leather
(21410,1894,1,1,2,19349), -- Crafted Leather
(21410,4042,1,1,2,9191), -- Enria
(21411,5282,1,1,-1,4735), -- Recipe: Greater Blessed Spiritshot (S) Compressed Package(100%)
(21411,5538,1,1,-1,29220), -- Dragon Grinder Edge
(21411,5541,1,1,-1,29214), -- Tallum Glaive Edge
(21411,57,4277,8758,0,700000), -- Adena
(21411,6326,1,1,1,41), -- Sealed Majestic Necklace
(21411,6327,1,1,1,54), -- Sealed Majestic Earring
(21411,6328,1,1,1,81), -- Sealed Majestic Ring
(21411,6342,1,1,1,11880), -- Sealed Majestic Earring Gemstone
(21411,6344,1,1,1,7688), -- Sealed Majestic Necklace Beads
(21411,6346,1,1,1,17074), -- Sealed Majestic Ring Gemstone
(21411,960,1,1,2,180), -- Scroll: Enchant Armor (Grade S)
(21411,1344,40,120,2,140475), -- Mithril Arrow
(21411,1867,5,15,2,59936), -- Animal Skin
(21411,1872,9,27,2,33298), -- Animal Bone
(21411,1882,1,1,2,99894), -- Leather
(21411,1894,1,1,2,15773), -- Crafted Leather
(21411,4042,1,1,2,7492), -- Enria
(21412,1808,1,1,-1,7556), -- Recipe: Soulshot: S Grade
(21412,1876,1,7,-1,850033), -- Mithril Ore
(21412,5545,1,1,-1,46641), -- Dark Legion\'s Edge Blade
(21412,57,6826,13977,0,700000), -- Adena
(21412,5312,1,1,1,64), -- Sealed Helm of Nightmare
(21412,5315,1,1,1,91), -- Sealed Shield of Nightmare
(21412,5317,1,1,1,64), -- Sealed Majestic Circlet
(21412,5495,1,1,1,12709), -- Sealed Shield of Nightmare Fragment
(21412,5527,1,1,1,10007), -- Sealed Helm of Nightmare Design
(21412,5528,1,1,1,10007), -- Sealed Majestic Circlet Design
(21412,960,1,1,2,287), -- Scroll: Enchant Armor (Grade S)
(21412,1344,150,450,2,59783), -- Mithril Arrow
(21412,1868,4,12,2,179349), -- Thread
(21412,1873,3,9,2,47827), -- Silver Nugget
(21412,1876,1,1,2,143479), -- Mithril Ore
(21412,1895,3,9,2,29282), -- Metallic Fiber
(21412,4042,1,1,2,11957), -- Enria
(21413,1808,1,1,-1,5810), -- Recipe: Soulshot: S Grade
(21413,1876,1,5,-1,871537), -- Mithril Ore
(21413,5545,1,1,-1,35866), -- Dark Legion\'s Edge Blade
(21413,57,5249,10748,0,700000), -- Adena
(21413,5312,1,1,1,49), -- Sealed Helm of Nightmare
(21413,5315,1,1,1,70), -- Sealed Shield of Nightmare
(21413,5317,1,1,1,49), -- Sealed Majestic Circlet
(21413,5495,1,1,1,9773), -- Sealed Shield of Nightmare Fragment
(21413,5527,1,1,1,7695), -- Sealed Helm of Nightmare Design
(21413,5528,1,1,1,7695), -- Sealed Majestic Circlet Design
(21413,960,1,1,2,221), -- Scroll: Enchant Armor (Grade S)
(21413,1344,150,450,2,45972), -- Mithril Arrow
(21413,1868,4,12,2,137914), -- Thread
(21413,1873,3,9,2,36777), -- Silver Nugget
(21413,1876,1,1,2,110331), -- Mithril Ore
(21413,1895,1,1,2,157615), -- Metallic Fiber
(21413,4042,1,1,2,9194), -- Enria
(21414,1877,1,1,-1,508201), -- Adamantite Nugget
(21414,4040,1,1,-1,254101), -- Mold Lubricant
(21414,6344,1,1,-1,186250), -- Sealed Majestic Necklace Beads
(21414,57,5101,10446,0,700000), -- Adena
(21414,164,1,1,1,7), -- Elysian
(21414,213,1,1,1,7), -- Branch of The Mother Tree
(21414,5533,1,1,1,2574), -- Elysian Head
(21414,5544,1,1,1,2572), -- Branch of The Mother Tree Head
(21414,960,1,1,2,215), -- Scroll: Enchant Armor (Grade S)
(21414,1344,100,300,2,67016), -- Mithril Arrow
(21414,1866,2,6,2,89355), -- Suede
(21414,1871,1,3,2,178709), -- Charcoal
(21414,1877,1,1,2,21446), -- Adamantite Nugget
(21414,4040,1,1,2,10723), -- Mold Lubricant
(21414,4041,1,1,2,4662), -- Mold Hardener
(21415,1877,1,1,-1,512669), -- Adamantite Nugget
(21415,4040,1,1,-1,256334), -- Mold Lubricant
(21415,6344,1,1,-1,187887), -- Sealed Majestic Necklace Beads
(21415,57,5146,10537,0,700000), -- Adena
(21415,164,1,1,1,8), -- Elysian
(21415,213,1,1,1,8), -- Branch of The Mother Tree
(21415,5533,1,1,1,2597), -- Elysian Head
(21415,5544,1,1,1,2595), -- Branch of The Mother Tree Head
(21415,960,1,1,2,217), -- Scroll: Enchant Armor (Grade S)
(21415,1344,100,300,2,67605), -- Mithril Arrow
(21415,1866,2,6,2,90140), -- Suede
(21415,1871,1,3,2,180280), -- Charcoal
(21415,1877,1,1,2,21634), -- Adamantite Nugget
(21415,4040,1,1,2,10817), -- Mold Lubricant
(21415,4041,1,1,2,4703), -- Mold Hardener
(21416,1885,1,3,-1,547540), -- High Grade Suede
(21416,4041,1,1,-1,114269), -- Mold Hardener
(21416,5480,1,1,-1,58966), -- Sealed Leather Armor of Nightmare Fabric
(21416,57,5276,10804,0,700000), -- Adena
(21416,289,1,1,1,15), -- Soul Bow
(21416,5534,1,1,1,5328), -- Soul Bow Stave
(21416,960,1,1,2,222), -- Scroll: Enchant Armor (Grade S)
(21416,1344,100,300,2,69316), -- Mithril Arrow
(21416,1866,2,6,2,92420), -- Suede
(21416,1871,1,3,2,184840), -- Charcoal
(21416,1885,1,1,2,46210), -- High Grade Suede
(21416,4041,1,1,2,4822), -- Mold Hardener
(21416,5220,1,1,2,22181), -- Metal Hardener
(21417,1885,1,3,-1,853217), -- High Grade Suede
(21417,4041,1,1,-1,178063), -- Mold Hardener
(21417,5480,1,1,-1,91886), -- Sealed Leather Armor of Nightmare Fabric
(21417,57,8221,16836,0,700000), -- Adena
(21417,289,1,1,1,23), -- Soul Bow
(21417,5534,1,1,1,8303), -- Soul Bow Stave
(21417,960,1,1,2,346), -- Scroll: Enchant Armor (Grade S)
(21417,1344,100,300,2,108012), -- Mithril Arrow
(21417,1866,2,6,2,144016), -- Suede
(21417,1871,9,27,2,48006), -- Charcoal
(21417,1885,1,1,2,72008), -- High Grade Suede
(21417,4041,1,1,2,7514), -- Mold Hardener
(21417,5220,1,1,2,34564), -- Metal Hardener
(21418,3036,1,1,-1,4837), -- Recipe: Spiritshot S
(21418,4044,1,1,-1,362779), -- Thons
(21418,5528,1,1,-1,130122), -- Sealed Majestic Circlet Design
(21418,57,4369,8949,0,700000), -- Adena
(21418,5312,1,1,1,41), -- Sealed Helm of Nightmare
(21418,5315,1,1,1,58), -- Sealed Shield of Nightmare
(21418,5317,1,1,1,41), -- Sealed Majestic Circlet
(21418,5495,1,1,1,8136), -- Sealed Shield of Nightmare Fragment
(21418,5527,1,1,1,6406), -- Sealed Helm of Nightmare Design
(21418,5528,1,1,1,6406), -- Sealed Majestic Circlet Design
(21418,959,1,1,2,22), -- Scroll: Enchant Weapon (Grade S)
(21418,1868,3,9,2,178599), -- Thread
(21418,1873,2,6,2,53580), -- Silver Nugget
(21418,1889,1,1,2,35720), -- Compound Braid
(21418,4044,1,1,2,17860), -- Thons
(21418,5549,1,1,2,53580), -- Metallic Thread
(21419,3036,1,1,-1,4926), -- Recipe: Spiritshot S
(21419,4044,1,1,-1,369466), -- Thons
(21419,5528,1,1,-1,132520), -- Sealed Majestic Circlet Design
(21419,57,4450,9114,0,700000), -- Adena
(21419,5312,1,1,1,42), -- Sealed Helm of Nightmare
(21419,5315,1,1,1,59), -- Sealed Shield of Nightmare
(21419,5317,1,1,1,42), -- Sealed Majestic Circlet
(21419,5495,1,1,1,8286), -- Sealed Shield of Nightmare Fragment
(21419,5527,1,1,1,6524), -- Sealed Helm of Nightmare Design
(21419,5528,1,1,1,6524), -- Sealed Majestic Circlet Design
(21419,959,1,1,2,22), -- Scroll: Enchant Weapon (Grade S)
(21419,1868,3,9,2,181891), -- Thread
(21419,1873,2,6,2,54568), -- Silver Nugget
(21419,1889,1,1,2,36379), -- Compound Braid
(21419,4044,1,1,2,18189), -- Thons
(21419,5549,1,1,2,54568), -- Metallic Thread
(21420,5157,1,1,-1,6020), -- Recipe: Soulshot (S) Compressed Package (100%)
(21420,5533,1,1,-1,37153), -- Elysian Head
(21420,5534,1,1,-1,37186), -- Soul Bow Stave
(21420,57,5438,11138,0,700000), -- Adena
(21420,164,1,1,1,8), -- Elysian
(21420,213,1,1,1,8), -- Branch of The Mother Tree
(21420,5533,1,1,1,2744), -- Elysian Head
(21420,5544,1,1,1,2742), -- Branch of The Mother Tree Head
(21420,959,1,1,2,27), -- Scroll: Enchant Weapon (Grade S)
(21420,1868,15,45,2,44455), -- Thread
(21420,1873,2,6,2,66683), -- Silver Nugget
(21420,1876,1,1,2,133366), -- Mithril Ore
(21420,1895,1,1,2,190522), -- Metallic Fiber
(21420,4042,1,1,2,11114), -- Enria
(21421,5157,1,1,-1,5651), -- Recipe: Soulshot (S) Compressed Package (100%)
(21421,5533,1,1,-1,34876), -- Elysian Head
(21421,5534,1,1,-1,34907), -- Soul Bow Stave
(21421,57,5104,10455,0,700000), -- Adena
(21421,164,1,1,1,7), -- Elysian
(21421,213,1,1,1,7), -- Branch of The Mother Tree
(21421,5533,1,1,1,2576), -- Elysian Head
(21421,5544,1,1,1,2574), -- Branch of The Mother Tree Head
(21421,959,1,1,2,25), -- Scroll: Enchant Weapon (Grade S)
(21421,1868,15,45,2,41731), -- Thread
(21421,1873,2,6,2,62596), -- Silver Nugget
(21421,1876,1,1,2,125192), -- Mithril Ore
(21421,1895,1,1,2,178846), -- Metallic Fiber
(21421,4042,1,1,2,10433), -- Enria
(21422,5162,1,1,-1,6483), -- Recipe: Spiritshot (S) Compressed Package (100%)
(21422,5167,1,1,-1,6483), -- Recipe: Blessed Spiritshot (S) Compressed Package (100%)
(21422,5538,1,1,-1,40009), -- Dragon Grinder Edge
(21422,57,5855,11994,0,700000), -- Adena
(21422,289,1,1,1,16), -- Soul Bow
(21422,5534,1,1,1,5915), -- Soul Bow Stave
(21422,959,1,1,2,29), -- Scroll: Enchant Weapon (Grade S)
(21422,1867,4,12,2,119681), -- Animal Skin
(21422,1872,7,21,2,63830), -- Animal Bone
(21422,1882,1,1,2,159574), -- Leather
(21422,1894,1,1,2,25196), -- Crafted Leather
(21422,4042,1,1,2,11969), -- Enria
(21423,5162,1,1,-1,6872), -- Recipe: Spiritshot (S) Compressed Package (100%)
(21423,5167,1,1,-1,6872), -- Recipe: Blessed Spiritshot (S) Compressed Package (100%)
(21423,5538,1,1,-1,42413), -- Dragon Grinder Edge
(21423,57,6207,12714,0,700000), -- Adena
(21423,289,1,1,1,17), -- Soul Bow
(21423,5534,1,1,1,6270), -- Soul Bow Stave
(21423,959,1,1,2,31), -- Scroll: Enchant Weapon (Grade S)
(21423,1867,4,12,2,126871), -- Animal Skin
(21423,1872,7,21,2,67665), -- Animal Bone
(21423,1882,1,1,2,169161), -- Leather
(21423,1894,1,1,2,26710), -- Crafted Leather
(21423,4042,1,1,2,12688), -- Enria
(21424,5272,1,1,-1,8710), -- Recipe: Greater Soulshot (S) Compressed Package(100%)
(21424,5544,1,1,-1,53702), -- Branch of The Mother Tree Head
(21424,5545,1,1,-1,53765), -- Dark Legion\'s Edge Blade
(21424,57,7867,16114,0,700000), -- Adena
(21424,305,1,1,1,22), -- Tallum Glaive
(21424,5541,1,1,1,7937), -- Tallum Glaive Edge
(21424,959,1,1,2,34), -- Scroll: Enchant Weapon (Grade S)
(21424,1868,15,45,2,55132), -- Thread
(21424,1873,2,6,2,82697), -- Silver Nugget
(21424,1876,1,1,2,165394), -- Mithril Ore
(21424,1895,3,9,2,39380), -- Metallic Fiber
(21424,4042,1,1,2,13783), -- Enria
(21424,6672,1,1,2,68914), -- Deluxe Chest Key - Grade 8
(21425,5272,1,1,-1,8856), -- Recipe: Greater Soulshot (S) Compressed Package(100%)
(21425,5544,1,1,-1,54603), -- Branch of The Mother Tree Head
(21425,5545,1,1,-1,54667), -- Dark Legion\'s Edge Blade
(21425,57,7999,16385,0,700000), -- Adena
(21425,305,1,1,1,22), -- Tallum Glaive
(21425,5541,1,1,1,8071), -- Tallum Glaive Edge
(21425,959,1,1,2,40), -- Scroll: Enchant Weapon (Grade S)
(21425,1868,15,45,2,65399), -- Thread
(21425,1873,2,6,2,98099), -- Silver Nugget
(21425,1876,1,1,2,196196), -- Mithril Ore
(21425,1895,3,9,2,46714), -- Metallic Fiber
(21425,4042,1,1,2,16350), -- Enria
(21426,6698,1,1,-1,359685), -- Sealed Tateossian Earring  Part
(21426,6699,1,1,-1,399119), -- Sealed Tateossian Ring Gem
(21426,6700,1,1,-1,219221), -- Sealed Tateossian Ring Wire
(21426,57,7369,15040,0,700000), -- Adena
(21426,289,1,1,1,21), -- Soul Bow
(21426,5534,1,1,1,7425), -- Soul Bow Stave
(21426,960,1,1,2,310), -- Scroll: Enchant Armor (Grade S)
(21426,1344,150,450,2,64393), -- Mithril Arrow
(21426,1868,32,96,2,24148), -- Thread
(21426,1873,3,9,2,51514), -- Silver Nugget
(21426,1876,1,1,2,154542), -- Mithril Ore
(21426,1895,3,9,2,31540), -- Metallic Fiber
(21426,4042,1,1,2,12879), -- Enria
(21427,6698,1,1,-1,244891), -- Sealed Tateossian Earring  Part
(21427,6699,1,1,-1,271740), -- Sealed Tateossian Ring Gem
(21427,6700,1,1,-1,149257), -- Sealed Tateossian Ring Wire
(21427,57,5017,10240,0,700000), -- Adena
(21427,289,1,1,1,14), -- Soul Bow
(21427,5534,1,1,1,5056), -- Soul Bow Stave
(21427,960,1,1,2,211), -- Scroll: Enchant Armor (Grade S)
(21427,1344,150,450,2,43842), -- Mithril Arrow
(21427,1868,4,12,2,131525), -- Thread
(21427,1873,3,9,2,35074), -- Silver Nugget
(21427,1876,1,1,2,105220), -- Mithril Ore
(21427,1895,1,1,2,150314), -- Metallic Fiber
(21427,4042,1,1,2,8769), -- Enria
(21428,6701,1,1,-1,68629), -- Sealed Imperial Crusader Breastplate Part
(21428,6702,1,1,-1,88343), -- Sealed Imperial Crusader Gaiters Pattern
(21428,6703,1,1,-1,183529), -- Sealed Imperial Crusader Gauntlets Design
(21428,57,5187,10587,0,700000), -- Adena
(21428,236,1,1,1,15), -- Soul Separator
(21428,5537,1,1,1,5223), -- Soul Separator Head
(21428,960,1,1,2,218), -- Scroll: Enchant Armor (Grade S)
(21428,1344,150,450,2,45328), -- Mithril Arrow
(21428,1868,4,12,2,135984), -- Thread
(21428,1873,3,9,2,36263), -- Silver Nugget
(21428,1889,1,1,2,36263), -- Compound Braid
(21428,4044,1,1,2,18132), -- Thons
(21428,5549,1,1,2,54394), -- Metallic Thread
(21429,6701,1,1,-1,71661), -- Sealed Imperial Crusader Breastplate Part
(21429,6702,1,1,-1,92247), -- Sealed Imperial Crusader Gaiters Pattern
(21429,6703,1,1,-1,191638), -- Sealed Imperial Crusader Gauntlets Design
(21429,57,5417,11055,0,700000), -- Adena
(21429,236,1,1,1,15), -- Soul Separator
(21429,5537,1,1,1,5454), -- Soul Separator Head
(21429,960,1,1,2,228), -- Scroll: Enchant Armor (Grade S)
(21429,1344,150,450,2,47331), -- Mithril Arrow
(21429,1868,4,12,2,141993), -- Thread
(21429,1873,3,9,2,37865), -- Silver Nugget
(21429,1889,1,1,2,37865), -- Compound Braid
(21429,4044,1,1,2,18933), -- Thons
(21429,5549,1,1,2,56798), -- Metallic Thread
(21430,6704,1,1,-1,264663), -- Sealed Imperial Crusader Boots Design
(21430,6705,1,1,-1,259237), -- Sealed Imperial Crusader Shield Part
(21430,6706,1,1,-1,301543), -- Sealed Imperial Crusader Helmet Pattern
(21430,57,7481,15268,0,700000), -- Adena
(21430,5320,1,1,1,36), -- Sealed Leather Armor of Nightmare
(21430,5323,1,1,1,36), -- Sealed Majestic Leather Armor
(21430,5480,1,1,1,6161), -- Sealed Leather Armor of Nightmare Fabric
(21430,5481,1,1,1,6161), -- Sealed Majestic Leather Armor Fabric
(21430,960,1,1,2,314), -- Scroll: Enchant Armor (Grade S)
(21430,1344,150,450,2,65367), -- Mithril Arrow
(21430,1868,32,96,2,24513), -- Thread
(21430,1873,3,9,2,52294), -- Silver Nugget
(21430,1876,1,1,2,156881), -- Mithril Ore
(21430,1895,3,9,2,32017), -- Metallic Fiber
(21430,4042,1,1,2,13074), -- Enria
(21431,6704,1,1,-1,225750), -- Sealed Imperial Crusader Boots Design
(21431,6705,1,1,-1,221122), -- Sealed Imperial Crusader Shield Part
(21431,6706,1,1,-1,257207), -- Sealed Imperial Crusader Helmet Pattern
(21431,57,6381,13023,0,700000), -- Adena
(21431,5320,1,1,1,31), -- Sealed Leather Armor of Nightmare
(21431,5323,1,1,1,31), -- Sealed Majestic Leather Armor
(21431,5480,1,1,1,5255), -- Sealed Leather Armor of Nightmare Fabric
(21431,5481,1,1,1,5255), -- Sealed Majestic Leather Armor Fabric
(21431,960,1,1,2,268), -- Scroll: Enchant Armor (Grade S)
(21431,1344,150,450,2,55756), -- Mithril Arrow
(21431,1868,4,12,2,167268), -- Thread
(21431,1873,3,9,2,44605), -- Silver Nugget
(21431,1876,1,1,2,133814), -- Mithril Ore
(21431,1895,3,9,2,27310), -- Metallic Fiber
(21431,4042,1,1,2,11152), -- Enria
(21432,1808,1,1,-1,9332), -- Recipe: Soulshot: S Grade
(21432,5534,1,1,-1,57647), -- Soul Bow Stave
(21432,5537,1,1,-1,57607), -- Soul Separator Head
(21432,57,8447,17245,0,700000), -- Adena
(21432,270,1,1,1,23), -- Dragon Grinder
(21432,5538,1,1,1,8508), -- Dragon Grinder Edge
(21432,959,1,1,2,42), -- Scroll: Enchant Weapon (Grade S)
(21432,1868,15,45,2,68916), -- Thread
(21432,1873,2,6,2,103374), -- Silver Nugget
(21432,1876,1,1,2,206747), -- Mithril Ore
(21432,1895,3,9,2,49226), -- Metallic Fiber
(21432,4042,1,1,2,17229), -- Enria
(21433,5167,1,1,-1,9039), -- Recipe: Blessed Spiritshot (S) Compressed Package (100%)
(21433,5538,1,1,-1,55789), -- Dragon Grinder Edge
(21433,5541,1,1,-1,55777), -- Tallum Glaive Edge
(21433,57,8184,16701,0,700000), -- Adena
(21433,5311,1,1,1,30), -- Sealed Armor of Nightmare
(21433,5316,1,1,1,30), -- Sealed Majestic Plate Armor
(21433,5522,1,1,1,5115), -- Sealed Armor of Nightmare Pattern
(21433,5523,1,1,1,5115), -- Sealed Majestic Plate Armor Pattern
(21433,959,1,1,2,41), -- Scroll: Enchant Weapon (Grade S)
(21433,1868,15,45,2,66754), -- Thread
(21433,1873,2,6,2,100130), -- Silver Nugget
(21433,1876,1,1,2,200259), -- Mithril Ore
(21433,1895,3,9,2,47681), -- Metallic Fiber
(21433,4042,1,1,2,16689), -- Enria
(21434,1877,1,3,-1,773988), -- Adamantite Nugget
(21434,5282,1,1,-1,17200), -- Recipe: Greater Blessed Spiritshot (S) Compressed Package(100%)
(21434,6342,1,1,-1,876643), -- Sealed Majestic Earring Gemstone
(21434,57,15536,31822,0,700000), -- Adena
(21434,5320,1,1,1,74), -- Sealed Leather Armor of Nightmare
(21434,5323,1,1,1,74), -- Sealed Majestic Leather Armor
(21434,5480,1,1,1,12826), -- Sealed Leather Armor of Nightmare Fabric
(21434,5481,1,1,1,12826), -- Sealed Majestic Leather Armor Fabric
(21434,959,1,1,2,77), -- Scroll: Enchant Weapon (Grade S)
(21434,1866,7,21,2,84676), -- Suede
(21434,1871,4,12,2,238151), -- Charcoal
(21434,1877,1,1,2,76208), -- Adamantite Nugget
(21434,4040,1,1,2,38104), -- Mold Lubricant
(21434,4041,1,1,2,16568), -- Mold Hardener
(21435,1877,1,3,-1,501519), -- Adamantite Nugget
(21435,3036,1,1,-1,11145), -- Recipe: Spiritshot S
(21435,5538,1,1,-1,68782), -- Dragon Grinder Edge
(21435,57,10088,20595,0,700000), -- Adena
(21435,289,1,1,1,28), -- Soul Bow
(21435,5534,1,1,1,10168), -- Soul Bow Stave
(21435,960,1,1,2,424), -- Scroll: Enchant Armor (Grade S)
(21435,1344,100,300,2,132270), -- Mithril Arrow
(21435,1866,2,6,2,176359), -- Suede
(21435,1871,9,27,2,58787), -- Charcoal
(21435,1877,1,1,2,42326), -- Adamantite Nugget
(21435,4040,1,1,2,21163), -- Mold Lubricant
(21435,4041,1,1,2,9202), -- Mold Hardener
(21436,1894,1,1,-1,912701), -- Crafted Leather
(21436,3957,1,1,-1,11561), -- Recipe: Blessed Spiritshot S
(21436,5541,1,1,-1,71335), -- Tallum Glaive Edge
(21436,57,10464,21364,0,700000), -- Adena
(21436,236,1,1,1,29), -- Soul Separator
(21436,5537,1,1,1,10539), -- Soul Separator Head
(21436,959,1,1,2,51), -- Scroll: Enchant Weapon (Grade S)
(21436,1867,4,12,2,213432), -- Animal Skin
(21436,1872,7,21,2,113831), -- Animal Bone
(21436,1882,3,9,2,47430), -- Leather
(21436,1894,1,1,2,44934), -- Crafted Leather
(21436,4042,1,1,2,21344), -- Enria
(21437,1877,1,1,-1,419120), -- Adamantite Nugget
(21437,4041,1,1,-1,91113), -- Mold Hardener
(21437,5544,1,1,-1,28712), -- Branch of The Mother Tree Head
(21437,57,4216,8604,0,700000), -- Adena
(21437,164,1,1,1,6), -- Elysian
(21437,213,1,1,1,6), -- Branch of The Mother Tree
(21437,5533,1,1,1,2123), -- Elysian Head
(21437,5544,1,1,1,2121), -- Branch of The Mother Tree Head
(21437,960,1,1,2,177), -- Scroll: Enchant Armor (Grade S)
(21437,1344,100,300,2,55269), -- Mithril Arrow
(21437,1866,2,6,2,73692), -- Suede
(21437,1871,1,3,2,147384), -- Charcoal
(21437,1877,1,1,2,17686), -- Adamantite Nugget
(21437,4040,1,1,2,8843), -- Mold Lubricant
(21437,4041,1,1,2,3845), -- Mold Hardener
(21438,4077,1,1,-1,22626), -- Doom Shield Fragment
(21438,4078,1,1,-1,7347), -- Blue Wolf Breastplate Part
(21438,6333,1,1,-1,5775), -- Recipe: Sealed Phoenix Ring(70%)
(21438,57,203,412,0,700000), -- Adena
(21438,79,1,1,1,2), -- Sword of Damascus
(21438,4114,1,1,1,325), -- Sword of Damascus Blade
(21438,729,1,1,2,3), -- Scroll: Enchant Weapon (Grade A)
(21438,1868,1,1,2,49524), -- Thread
(21438,1873,1,1,2,9905), -- Silver Nugget
(21438,1876,1,1,2,4953), -- Mithril Ore
(21438,1895,1,1,2,7075), -- Metallic Fiber
(21438,4042,1,1,2,413), -- Enria
(21439,4116,1,1,-1,2272), -- Deadman\'s Glory Stone
(21439,4117,1,1,-1,2272), -- Art of Battle Axe Blade
(21439,5276,1,1,-1,693), -- Recipe: Greater Spiritshot (A) Compressed Package(100%)
(21439,57,210,426,0,700000), -- Adena
(21439,97,1,1,1,2), -- Lance
(21439,4115,1,1,1,335), -- Lance Blade
(21439,1343,10,30,2,31340), -- Silver Arrow
(21439,1864,1,1,2,43875), -- Stem
(21439,1865,1,1,2,21938), -- Varnish
(21439,1866,1,1,2,14625), -- Suede
(21439,1868,1,1,2,43875), -- Thread
(21439,1873,1,1,2,8776), -- Silver Nugget
(21439,5456,1,1,2,9), -- Recipe: Tallum Glaive(60%)
(21440,1875,1,1,-1,38040), -- Stone of Purity
(21440,4040,1,1,-1,11412), -- Mold Lubricant
(21440,4099,1,1,-1,25616), -- Doom Boots Part
(21440,57,229,469,0,700000), -- Adena
(21440,2398,1,1,1,2), -- Blue Wolf Tunic
(21440,2399,1,1,1,2), -- Tunic of Doom
(21440,2403,1,1,1,3), -- Blue Wolf Stockings
(21440,2404,1,1,1,3), -- Stockings of Doom
(21440,4084,1,1,1,366), -- Blue Wolf Tunic Fabric
(21440,4085,1,1,1,366), -- Tunic of Doom Pattern
(21440,4086,1,1,1,495), -- Blue Wolf Stockings Pattern
(21440,4087,1,1,1,495), -- Stockings of Doom Pattern
(21440,1343,10,30,2,34398), -- Silver Arrow
(21440,1865,1,1,2,24079), -- Varnish
(21440,1870,1,1,2,24079), -- Coal
(21440,1875,1,1,2,1606), -- Stone of Purity
(21440,1879,1,1,2,4014), -- Cokes
(21440,4040,1,1,2,482), -- Mold Lubricant
(21440,6335,1,1,2,93), -- Recipe: Sealed Majestic Necklace(70%)
(21441,729,1,1,-1,62), -- Scroll: Enchant Weapon (Grade A)
(21441,5448,1,1,-1,206), -- Recipe: Soul Separator(60%)
(21441,5494,1,1,-1,11655), -- Sealed Dark Crystal Shield Fragment
(21441,57,224,455,0,700000), -- Adena
(21441,212,1,1,1,1), -- Dasparion\'s Staff
(21441,2504,1,1,1,1), -- Meteor Shower
(21441,5532,1,1,1,139), -- Meteor Shower Head
(21441,5543,1,1,1,140), -- Dasparion\'s Staff Edge
(21441,1343,10,30,2,33454), -- Silver Arrow
(21441,1865,1,1,2,23418), -- Varnish
(21441,1870,1,1,2,23418), -- Coal
(21441,1874,1,1,2,1562), -- Oriharukon Ore
(21441,4039,1,1,2,781), -- Mold Glue
(21441,4043,1,1,2,781), -- Asofe
(21441,5442,1,1,2,9), -- Recipe: Soul Bow(60%)
(21442,729,1,1,-1,64), -- Scroll: Enchant Weapon (Grade A)
(21442,5448,1,1,-1,212), -- Recipe: Soul Separator(60%)
(21442,6341,1,1,-1,15842), -- Sealed Phoenix Earring Gemstone
(21442,57,231,470,0,700000), -- Adena
(21442,212,1,1,1,1), -- Dasparion\'s Staff
(21442,2504,1,1,1,1), -- Meteor Shower
(21442,5532,1,1,1,143), -- Meteor Shower Head
(21442,5543,1,1,1,144), -- Dasparion\'s Staff Edge
(21442,1343,10,30,2,34529), -- Silver Arrow
(21442,1865,1,1,2,24171), -- Varnish
(21442,1870,1,1,2,24171), -- Coal
(21442,1874,1,1,2,1612), -- Oriharukon Ore
(21442,4039,1,1,2,806), -- Mold Glue
(21442,4043,1,1,2,806), -- Asofe
(21442,5450,1,1,2,9), -- Recipe: Dragon Grinder(60%)
(21443,3956,1,1,-1,3132), -- Recipe: Blessed Spiritshot A
(21443,4077,1,1,-1,105674), -- Doom Shield Fragment
(21443,4078,1,1,-1,34314), -- Blue Wolf Breastplate Part
(21443,57,950,1924,0,700000), -- Adena
(21443,358,1,1,1,8), -- Blue Wolf Breastplate
(21443,2380,1,1,1,12), -- Blue Wolf Gaiters
(21443,2381,1,1,1,5), -- Doom Plate Armor
(21443,4078,1,1,1,1690), -- Blue Wolf Breastplate Part
(21443,4080,1,1,1,2380), -- Blue Wolf Gaiters Material
(21443,4081,1,1,1,1140), -- Doom Plate Armor Temper
(21443,1343,10,30,2,141613), -- Silver Arrow
(21443,1867,1,1,2,132172), -- Animal Skin
(21443,1872,1,1,2,132172), -- Animal Bone
(21443,1875,1,1,2,6609), -- Stone of Purity
(21443,1881,1,1,2,13218), -- Coarse Bone Powder
(21443,4041,1,1,2,863), -- Mold Hardener
(21443,5156,1,1,2,133), -- Recipe: Soulshot (A) Compressed Package (100%)
(21444,3956,1,1,-1,2632), -- Recipe: Blessed Spiritshot A
(21444,4077,1,1,-1,88802), -- Doom Shield Fragment
(21444,4078,1,1,-1,28835), -- Blue Wolf Breastplate Part
(21444,57,799,1617,0,700000), -- Adena
(21444,358,1,1,1,7), -- Blue Wolf Breastplate
(21444,2380,1,1,1,10), -- Blue Wolf Gaiters
(21444,2381,1,1,1,5), -- Doom Plate Armor
(21444,4078,1,1,1,1420), -- Blue Wolf Breastplate Part
(21444,4080,1,1,1,1999), -- Blue Wolf Gaiters Material
(21444,4081,1,1,1,958), -- Doom Plate Armor Temper
(21444,1343,10,30,2,119002), -- Silver Arrow
(21444,1867,1,1,2,111069), -- Animal Skin
(21444,1872,1,1,2,111069), -- Animal Bone
(21444,1875,1,1,2,5554), -- Stone of Purity
(21444,1881,1,1,2,11107), -- Coarse Bone Powder
(21444,4041,1,1,2,725), -- Mold Hardener
(21444,5156,1,1,2,112), -- Recipe: Soulshot (A) Compressed Package (100%)
(21445,1875,1,1,-1,136158), -- Stone of Purity
(21445,4118,1,1,-1,8456), -- Evil Spirit Head
(21445,5460,1,1,-1,1116), -- Recipe: Dasparion\'s Staff(60%)
(21445,57,827,1673,0,700000), -- Adena
(21445,79,1,1,1,5), -- Sword of Damascus
(21445,4114,1,1,1,1321), -- Sword of Damascus Blade
(21445,1865,1,1,2,100548), -- Varnish
(21445,1870,1,1,2,100548), -- Coal
(21445,1875,1,1,2,6704), -- Stone of Purity
(21445,1879,1,1,2,16758), -- Cokes
(21445,4040,1,1,2,2011), -- Mold Lubricant
(21445,6329,1,1,2,578), -- Recipe: Sealed Phoenix Necklace(70%)
(21446,1885,1,1,-1,209411), -- High Grade Suede
(21446,4119,1,1,-1,10999), -- Demon\'s Sword Edge
(21446,5468,1,1,-1,1373), -- Recipe: Elemental Sword(60%)
(21446,57,1018,2058,0,700000), -- Adena
(21446,171,1,1,1,2), -- Deadman\'s Glory
(21446,175,1,1,1,2), -- Art of Battle Axe
(21446,210,1,1,1,2), -- Staff of Evil Spirits
(21446,4116,1,1,1,541), -- Deadman\'s Glory Stone
(21446,4117,1,1,1,541), -- Art of Battle Axe Blade
(21446,4118,1,1,1,513), -- Evil Spirit Head
(21446,1343,10,30,2,151486), -- Silver Arrow
(21446,1866,1,1,2,70694), -- Suede
(21446,1871,1,1,2,106041), -- Charcoal
(21446,1885,1,1,2,8837), -- High Grade Suede
(21446,4041,1,1,2,923), -- Mold Hardener
(21446,5220,1,1,2,4242), -- Metal Hardener
(21446,6331,1,1,2,810), -- Recipe: Sealed Phoenix Earring(70%)
(21447,4052,1,1,-1,92029), -- Earring of Black Ore Piece
(21447,4118,1,1,-1,10762), -- Evil Spirit Head
(21447,5281,1,1,-1,3466), -- Recipe: Greater Blessed Spiritshot (A) Compressed Package(100%)
(21447,57,1050,2130,0,700000), -- Adena
(21447,110,1,1,1,31), -- Doom Shield
(21447,2416,1,1,1,22), -- Blue Wolf Helmet
(21447,2417,1,1,1,22), -- Doom Helmet
(21447,4077,1,1,1,5757), -- Doom Shield Fragment
(21447,4088,1,1,1,4837), -- Blue Wolf Helmet Design
(21447,4089,1,1,1,4837), -- Doom Helmet Pattern
(21447,1867,1,3,2,56875), -- Animal Skin
(21447,1869,2,6,2,31993), -- Iron Ore
(21447,1870,1,1,2,127969), -- Coal
(21447,1871,1,1,2,127969), -- Charcoal
(21447,1872,1,3,2,85313), -- Animal Bone
(21447,5462,1,1,2,48), -- Recipe: Branch of The Mother Tree(60%)
(21448,4118,1,1,-1,13565), -- Evil Spirit Head
(21448,5281,1,1,-1,4369), -- Recipe: Greater Blessed Spiritshot (A) Compressed Package(100%)
(21448,57,883,1790,0,700000), -- Adena
(21448,110,1,1,1,26), -- Doom Shield
(21448,2416,1,1,1,18), -- Blue Wolf Helmet
(21448,2417,1,1,1,18), -- Doom Helmet
(21448,4077,1,1,1,4838), -- Doom Shield Fragment
(21448,4088,1,1,1,4064), -- Blue Wolf Helmet Design
(21448,4089,1,1,1,4064), -- Doom Helmet Pattern
(21448,1867,1,3,2,47794), -- Animal Skin
(21448,1869,1,1,2,107537), -- Iron Ore
(21448,1870,1,1,2,107537), -- Coal
(21448,1871,1,1,2,107537), -- Charcoal
(21448,1872,1,3,2,71692), -- Animal Bone
(21448,5462,1,1,2,41), -- Recipe: Branch of The Mother Tree(60%)
(21449,4040,1,1,-1,57377), -- Mold Lubricant
(21449,4041,1,1,-1,24947), -- Mold Hardener
(21449,5496,1,1,-1,67265), -- Sealed Dark Crystal Boots Lining
(21449,57,1158,2353,0,700000), -- Adena
(21449,269,1,1,1,5), -- Blood Tornado
(21449,5539,1,1,1,1430), -- Blood Tornado Edge
(21449,1866,1,1,2,94158), -- Suede
(21449,1871,1,1,2,141237), -- Charcoal
(21449,1877,1,1,2,5650), -- Adamantite Nugget
(21449,4040,1,1,2,2825), -- Mold Lubricant
(21449,4041,1,1,2,1229), -- Mold Hardener
(21449,5448,1,1,2,52), -- Recipe: Soul Separator(60%)
(21450,5450,1,1,-1,1028), -- Recipe: Dragon Grinder(60%)
(21450,5456,1,1,-1,1028), -- Recipe: Tallum Glaive(60%)
(21450,5497,1,1,-1,65057), -- Sealed Tallum Boots Lining
(21450,57,1120,2276,0,700000), -- Adena
(21450,288,1,1,1,5), -- Carnage Bow
(21450,5535,1,1,1,1399), -- Carnage Bow Stave
(21450,1343,20,60,2,83633), -- Silver Arrow
(21450,1867,1,1,2,156114), -- Animal Skin
(21450,1872,1,1,2,156114), -- Animal Bone
(21450,1875,1,1,2,7806), -- Stone of Purity
(21450,1881,1,1,2,15612), -- Coarse Bone Powder
(21450,4041,1,1,2,1019), -- Mold Hardener
(21450,5450,1,1,2,44), -- Recipe: Dragon Grinder(60%)
(21451,1807,1,1,-1,1243), -- Recipe: Soulshot: A-Grade
(21451,4041,1,1,-1,8107), -- Mold Hardener
(21451,4080,1,1,-1,19178), -- Blue Wolf Gaiters Material
(21451,57,393,787,0,700000), -- Adena
(21451,171,1,1,1,1), -- Deadman\'s Glory
(21451,175,1,1,1,1), -- Art of Battle Axe
(21451,210,1,1,1,1), -- Staff of Evil Spirits
(21451,4116,1,1,1,201), -- Deadman\'s Glory Stone
(21451,4117,1,1,1,201), -- Art of Battle Axe Blade
(21451,4118,1,1,1,190), -- Evil Spirit Head
(21451,730,1,1,2,33), -- Scroll: Enchant Armor (Grade A)
(21451,1343,10,30,2,56206), -- Silver Arrow
(21451,1866,1,1,2,26230), -- Suede
(21451,1871,1,1,2,39344), -- Charcoal
(21451,1885,1,1,2,3279), -- High Grade Suede
(21451,4041,1,1,2,343), -- Mold Hardener
(21451,5220,1,1,2,1574), -- Metal Hardener
(21452,1875,1,1,-1,164372), -- Stone of Purity
(21452,3035,1,1,-1,3287), -- Recipe: Spiritshot A
(21452,4081,1,1,-1,24301), -- Doom Plate Armor Temper
(21452,57,1040,2081,0,700000); -- Adena

INSERT INTO `droplist` VALUES 
(21453,3956,1,1,-1,2763), -- Recipe: Blessed Spiritshot A
(21453,4082,1,1,-1,23411), -- Blue Wolf Leather Armor Texture
(21453,4083,1,1,-1,23411), -- Leather Armor of Doom Design
(21453,57,874,1749,0,700000), -- Adena
(21454,1884,1,3,-1,758639), -- Cord
(21454,1889,1,1,-1,164372), -- Compound Braid
(21454,4084,1,1,-1,42850), -- Blue Wolf Tunic Fabric
(21454,57,1040,2081,0,700000), -- Adena
(21455,4085,1,1,-1,36008), -- Tunic of Doom Pattern
(21455,5156,1,1,-1,2763), -- Recipe: Soulshot (A) Compressed Package (100%)
(21455,5161,1,1,-1,2763), -- Recipe: Spiritshot (A) Compressed Package (100%)
(21455,57,874,1749,0,700000), -- Adena
(21456,1884,1,3,-1,758639), -- Cord
(21456,4039,1,1,-1,82186), -- Mold Glue
(21456,4086,1,1,-1,57857), -- Blue Wolf Stockings Pattern
(21456,171,1,1,1,2), -- Deadman\'s Glory
(21456,175,1,1,1,2), -- Art of Battle Axe
(21456,210,1,1,1,2), -- Staff of Evil Spirits
(21456,4116,1,1,1,531), -- Deadman\'s Glory Stone
(21456,4117,1,1,1,531), -- Art of Battle Axe Blade
(21456,4118,1,1,1,503), -- Evil Spirit Head
(21456,1864,1,1,2,242765), -- Stem
(21456,1869,1,1,2,121383), -- Iron Ore
(21456,1878,1,1,2,48554), -- Braided Hemp
(21456,1884,1,1,2,74697), -- Cord
(21456,4039,1,1,2,4046), -- Mold Glue
(21456,5450,1,1,2,46), -- Recipe: Dragon Grinder(60%)
(21457,4087,1,1,-1,48619), -- Stockings of Doom Pattern
(21457,4088,1,1,-1,78304), -- Blue Wolf Helmet Design
(21457,5166,1,1,-1,2763), -- Recipe: Blessed Spiritshot (A) Compressed Package (100%)
(21457,864,1,1,1,23), -- Earring of Black Ore
(21457,895,1,1,1,34), -- Ring of Black Ore
(21457,926,1,1,1,17), -- Necklace of Black Ore
(21457,4052,1,1,1,3611), -- Earring of Black Ore Piece
(21457,4053,1,1,1,4372), -- Ring of Black Ore Gemstone
(21457,4054,1,1,1,2009), -- Necklace of Black Ore Beads
(21457,1343,10,30,2,124901), -- Silver Arrow
(21457,1866,1,1,2,58287), -- Suede
(21457,1871,1,1,2,87431), -- Charcoal
(21457,1885,1,1,2,7286), -- High Grade Suede
(21457,4041,1,1,2,761), -- Mold Hardener
(21457,5220,1,1,2,3498), -- Metal Hardener
(21457,5456,1,1,2,33), -- Recipe: Tallum Glaive(60%)
(21458,4041,1,1,-1,21440), -- Mold Hardener
(21458,4089,1,1,-1,93181), -- Doom Helmet Pattern
(21458,5230,1,1,-1,3287), -- Recipe: Mithril Arrow (100%)
(21458,601,1,1,1,23), -- Boots of Doom
(21458,2439,1,1,1,23), -- Blue Wolf Boots
(21458,2475,1,1,1,23), -- Doom Gloves
(21458,2487,1,1,1,23), -- Blue Wolf Gloves
(21458,4090,1,1,1,4086), -- Blue Wolf Boots Design
(21458,4091,1,1,1,4086), -- Doom Gloves Part
(21458,4096,1,1,1,4086), -- Blue Wolf Gloves Fabric
(21458,4099,1,1,1,4086), -- Doom Boots Part
(21458,1866,1,1,2,80922), -- Suede
(21458,1871,1,1,2,121383), -- Charcoal
(21458,1877,1,1,2,4856), -- Adamantite Nugget
(21458,4040,1,1,2,2428), -- Mold Lubricant
(21458,4041,1,1,2,1056), -- Mold Hardener
(21458,5462,1,1,2,45), -- Recipe: Branch of The Mother Tree(60%)
(21459,1894,1,1,-1,72699), -- Crafted Leather
(21459,4090,1,1,-1,93015), -- Blue Wolf Boots Design
(21459,5271,1,1,-1,2763), -- Recipe: Greater Soulshot (A) Compressed Package(100%)
(21459,268,1,1,1,5), -- Bellion Cestus
(21459,4120,1,1,1,1338), -- Bellion Cestus Edge
(21459,1343,10,30,2,124900), -- Silver Arrow
(21459,1867,1,1,2,116574), -- Animal Skin
(21459,1872,1,1,2,116574), -- Animal Bone
(21459,1882,1,1,2,19430), -- Leather
(21459,1894,1,1,2,3068), -- Crafted Leather
(21459,4042,1,1,2,1458), -- Enria
(21459,5464,1,1,2,33), -- Recipe: Dark Legion\'s Edge(60%)
(21460,4091,1,1,-1,231933), -- Doom Gloves Part
(21460,4096,1,1,-1,231933), -- Blue Wolf Gloves Fabric
(21460,5276,1,1,-1,6888), -- Recipe: Greater Spiritshot (A) Compressed Package(100%)
(21460,57,2179,4361,0,700000), -- Adena
(21461,1876,1,3,-1,537011), -- Mithril Ore
(21461,4042,1,1,-1,89502), -- Enria
(21461,4099,1,1,-1,241083), -- Doom Boots Part
(21461,57,2265,4533,0,700000), -- Adena
(21462,4114,1,1,-1,22614), -- Sword of Damascus Blade
(21462,5281,1,1,-1,6888), -- Recipe: Greater Blessed Spiritshot (A) Compressed Package(100%)
(21462,5438,1,1,-1,2823), -- Recipe: Meteor Shower(60%)
(21462,57,2179,4361,0,700000), -- Adena
(21463,1875,1,1,-1,331238), -- Stone of Purity
(21463,4041,1,1,-1,43205), -- Mold Hardener
(21463,4115,1,1,-1,21675), -- Lance Blade
(21463,57,2096,4194,0,700000), -- Adena
(21464,4116,1,1,-1,22576), -- Deadman\'s Glory Stone
(21464,4117,1,1,-1,22576), -- Art of Battle Axe Blade
(21464,5444,1,1,-1,2823), -- Recipe: Carnage Bow(60%)
(21464,171,1,1,1,4), -- Deadman\'s Glory
(21464,175,1,1,1,4), -- Art of Battle Axe
(21464,210,1,1,1,4), -- Staff of Evil Spirits
(21464,4116,1,1,1,1112), -- Deadman\'s Glory Stone
(21464,4117,1,1,1,1112), -- Art of Battle Axe Blade
(21464,4118,1,1,1,1054), -- Evil Spirit Head
(21464,729,1,1,2,29), -- Scroll: Enchant Weapon (Grade A)
(21464,1867,1,3,2,169561), -- Animal Skin
(21464,1872,1,3,2,113041), -- Animal Bone
(21464,1882,1,1,2,56521), -- Leather
(21464,1894,1,1,2,8925), -- Crafted Leather
(21464,4042,1,1,2,4240), -- Enria
(21465,4118,1,1,-1,22233), -- Evil Spirit Head
(21465,5220,1,1,-1,214805), -- Metal Hardener
(21465,5446,1,1,-1,2934), -- Recipe: Bloody Orchid(60%)
(21465,864,1,1,1,58), -- Earring of Black Ore
(21465,895,1,1,1,86), -- Ring of Black Ore
(21465,926,1,1,1,43), -- Necklace of Black Ore
(21465,4052,1,1,1,9359), -- Earring of Black Ore Piece
(21465,4053,1,1,1,11331), -- Ring of Black Ore Gemstone
(21465,4054,1,1,1,5207), -- Necklace of Black Ore Beads
(21465,730,1,1,2,189), -- Scroll: Enchant Armor (Grade A)
(21465,1343,20,60,2,161863), -- Silver Arrow
(21465,1874,1,1,2,15108), -- Oriharukon Ore
(21465,1878,1,1,2,90643), -- Braided Hemp
(21465,1884,1,1,2,139451), -- Cord
(21465,1889,1,1,2,15108), -- Compound Braid
(21465,5220,1,1,2,9065), -- Metal Hardener
(21466,4042,1,1,-1,86105), -- Enria
(21466,4119,1,1,-1,22614), -- Demon\'s Sword Edge
(21466,5452,1,1,-1,2823), -- Recipe: Blood Tornado(60%)
(21466,601,1,1,1,48), -- Boots of Doom
(21466,2439,1,1,1,48), -- Blue Wolf Boots
(21466,2475,1,1,1,48), -- Doom Gloves
(21466,2487,1,1,1,48), -- Blue Wolf Gloves
(21466,4090,1,1,1,8562), -- Blue Wolf Boots Design
(21466,4091,1,1,1,8562), -- Doom Gloves Part
(21466,4096,1,1,1,8562), -- Blue Wolf Gloves Fabric
(21466,4099,1,1,1,8562), -- Doom Boots Part
(21466,1867,1,3,2,169561), -- Animal Skin
(21466,1872,1,3,2,113041), -- Animal Bone
(21466,1882,1,1,2,56521), -- Leather
(21466,1894,1,1,2,8925), -- Crafted Leather
(21466,4042,1,1,2,4240), -- Enria
(21466,5434,1,1,2,95), -- Recipe: Dragon Slayer(60%)
(21467,4120,1,1,-1,21712), -- Bellion Cestus Edge
(21467,4121,1,1,-1,21639), -- Bow of Peril Shaft
(21467,5458,1,1,-1,2715), -- Recipe: Halberd(60%)
(21467,268,1,1,1,12), -- Bellion Cestus
(21467,4120,1,1,1,3207), -- Bellion Cestus Edge
(21467,1343,30,90,2,99840), -- Silver Arrow
(21467,1864,4,12,2,52416), -- Stem
(21467,1869,2,6,2,41933), -- Iron Ore
(21467,1878,1,1,2,83866), -- Braided Hemp
(21467,1884,1,1,2,129024), -- Cord
(21467,4039,1,1,2,6989), -- Mold Glue
(21467,5440,1,1,2,78), -- Recipe: Elysian(60%)
(21468,4052,1,1,-1,308357), -- Earring of Black Ore Piece
(21468,5220,1,1,-1,348382), -- Metal Hardener
(21468,57,3673,7352,0,700000), -- Adena
(21469,4053,1,1,-1,356108), -- Ring of Black Ore Gemstone
(21469,5460,1,1,-1,4540), -- Recipe: Dasparion\'s Staff(60%)
(21469,5468,1,1,-1,4540), -- Recipe: Elemental Sword(60%)
(21469,57,3504,7013,0,700000), -- Adena
(21470,4114,1,1,-1,4358), -- Sword of Damascus Blade
(21470,5156,1,1,-1,1327), -- Recipe: Soulshot (A) Compressed Package (100%)
(21470,5161,1,1,-1,1327), -- Recipe: Spiritshot (A) Compressed Package (100%)
(21470,57,420,840,0,700000), -- Adena
(21470,601,1,1,1,10), -- Boots of Doom
(21470,2439,1,1,1,10), -- Blue Wolf Boots
(21470,2475,1,1,1,10), -- Doom Gloves
(21470,2487,1,1,1,10), -- Blue Wolf Gloves
(21470,4090,1,1,1,1650), -- Blue Wolf Boots Design
(21470,4091,1,1,1,1650), -- Doom Gloves Part
(21470,4096,1,1,1,1650), -- Blue Wolf Gloves Fabric
(21470,4099,1,1,1,1650), -- Doom Boots Part
(21470,1866,1,1,2,32676), -- Suede
(21470,1871,1,1,2,49014), -- Charcoal
(21470,1885,1,1,2,4085), -- High Grade Suede
(21470,4041,1,1,2,427), -- Mold Hardener
(21470,5220,1,1,2,1961), -- Metal Hardener
(21470,6337,1,1,2,252), -- Recipe: Sealed Majestic Earring(70%)
(21471,1894,1,1,-1,92378), -- Crafted Leather
(21471,4042,1,1,-1,43879), -- Enria
(21471,4115,1,1,-1,11485), -- Lance Blade
(21471,57,1111,2223,0,700000), -- Adena
(21472,4116,1,1,-1,9668), -- Deadman\'s Glory Stone
(21472,4117,1,1,-1,9668), -- Art of Battle Axe Blade
(21472,5166,1,1,-1,2950), -- Recipe: Blessed Spiritshot (A) Compressed Package (100%)
(21472,57,933,1868,0,700000), -- Adena
(21473,4043,1,1,-1,87759), -- Asofe
(21473,4118,1,1,-1,10900), -- Evil Spirit Head
(21473,5230,1,1,-1,3510), -- Recipe: Mithril Arrow (100%)
(21473,57,1111,2223,0,700000), -- Adena
(21474,4039,1,1,-1,73747), -- Mold Glue
(21474,4119,1,1,-1,9684), -- Demon\'s Sword Edge
(21474,5271,1,1,-1,2950), -- Recipe: Greater Soulshot (A) Compressed Package(100%)
(21474,57,933,1868,0,700000), -- Adena
(21475,4120,1,1,-1,11505), -- Bellion Cestus Edge
(21475,4121,1,1,-1,11466), -- Bow of Peril Shaft
(21475,5276,1,1,-1,3510), -- Recipe: Greater Spiritshot (A) Compressed Package(100%)
(21475,2398,1,1,1,9), -- Blue Wolf Tunic
(21475,2399,1,1,1,9), -- Tunic of Doom
(21475,2403,1,1,1,13), -- Blue Wolf Stockings
(21475,2404,1,1,1,13), -- Stockings of Doom
(21475,4084,1,1,1,1689), -- Blue Wolf Tunic Fabric
(21475,4085,1,1,1,1689), -- Tunic of Doom Pattern
(21475,4086,1,1,1,2280), -- Blue Wolf Stockings Pattern
(21475,4087,1,1,1,2280), -- Stockings of Doom Pattern
(21475,1343,10,30,2,158710), -- Silver Arrow
(21475,1866,1,1,2,74065), -- Suede
(21475,1871,1,1,2,111097), -- Charcoal
(21475,1877,1,1,2,4444), -- Adamantite Nugget
(21475,4040,1,1,2,2223), -- Mold Lubricant
(21475,4041,1,1,2,967), -- Mold Hardener
(21475,5440,1,1,2,42), -- Recipe: Elysian(60%)
(21476,1875,1,1,-1,147494), -- Stone of Purity
(21476,4041,1,1,-1,19238), -- Mold Hardener
(21476,4052,1,1,-1,78329), -- Earring of Black Ore Piece
(21476,358,1,1,1,7), -- Blue Wolf Breastplate
(21476,2380,1,1,1,11), -- Blue Wolf Gaiters
(21476,2381,1,1,1,5), -- Doom Plate Armor
(21476,4078,1,1,1,1591), -- Blue Wolf Breastplate Part
(21476,4080,1,1,1,2241), -- Blue Wolf Gaiters Material
(21476,4081,1,1,1,1074), -- Doom Plate Armor Temper
(21476,1867,1,1,2,145225), -- Animal Skin
(21476,1872,1,1,2,145225), -- Animal Bone
(21476,1875,1,1,2,7262), -- Stone of Purity
(21476,1881,1,1,2,14523), -- Coarse Bone Powder
(21476,4041,1,1,2,948), -- Mold Hardener
(21476,5442,1,1,2,41), -- Recipe: Soul Bow(60%)
(21477,4053,1,1,-1,112849), -- Ring of Black Ore Gemstone
(21477,5281,1,1,-1,3510), -- Recipe: Greater Blessed Spiritshot (A) Compressed Package(100%)
(21477,5438,1,1,-1,1439), -- Recipe: Meteor Shower(60%)
(21477,2398,1,1,1,9), -- Blue Wolf Tunic
(21477,2399,1,1,1,9), -- Tunic of Doom
(21477,2403,1,1,1,13), -- Blue Wolf Stockings
(21477,2404,1,1,1,13), -- Stockings of Doom
(21477,4084,1,1,1,1689), -- Blue Wolf Tunic Fabric
(21477,4085,1,1,1,1689), -- Tunic of Doom Pattern
(21477,4086,1,1,1,2280), -- Blue Wolf Stockings Pattern
(21477,4087,1,1,1,2280), -- Stockings of Doom Pattern
(21477,1343,10,30,2,158710), -- Silver Arrow
(21477,1865,1,1,2,111097), -- Varnish
(21477,1870,1,1,2,111097), -- Coal
(21477,1875,1,1,2,7407), -- Stone of Purity
(21477,1879,1,1,2,18517), -- Cokes
(21477,4040,1,1,2,2222), -- Mold Lubricant
(21477,5448,1,1,2,42), -- Recipe: Soul Separator(60%)
(21478,1885,1,1,-1,184367), -- High Grade Suede
(21478,4041,1,1,-1,19238), -- Mold Hardener
(21478,4054,1,1,-1,43577), -- Necklace of Black Ore Beads
(21478,864,1,1,1,24), -- Earring of Black Ore
(21478,895,1,1,1,36), -- Ring of Black Ore
(21478,926,1,1,1,18), -- Necklace of Black Ore
(21478,4052,1,1,1,3856), -- Earring of Black Ore Piece
(21478,4053,1,1,1,4668), -- Ring of Black Ore Gemstone
(21478,4054,1,1,1,2145), -- Necklace of Black Ore Beads
(21478,1866,1,1,2,72613), -- Suede
(21478,1871,1,1,2,108919), -- Charcoal
(21478,1885,1,1,2,9077), -- High Grade Suede
(21478,4041,1,1,2,948), -- Mold Hardener
(21478,5220,1,1,2,4357), -- Metal Hardener
(21478,5450,1,1,2,41), -- Recipe: Dragon Grinder(60%)
(21479,4077,1,1,-1,248161), -- Doom Shield Fragment
(21479,4078,1,1,-1,80582), -- Blue Wolf Breastplate Part
(21479,5444,1,1,-1,3015), -- Recipe: Carnage Bow(60%)
(21479,57,2327,4657,0,700000), -- Adena
(21480,1889,1,1,-1,382283), -- Compound Braid
(21480,4080,1,1,-1,117952), -- Blue Wolf Gaiters Material
(21480,5446,1,1,-1,3133), -- Recipe: Bloody Orchid(60%)
(21480,57,2419,4841,0,700000), -- Adena
(21481,4081,1,1,-1,54372), -- Doom Plate Armor Temper
(21481,5452,1,1,-1,3015), -- Recipe: Blood Tornado(60%)
(21481,5550,1,1,-1,73555), -- Durable Metal Plate
(21481,57,2327,4657,0,700000), -- Adena
(21482,4082,1,1,-1,59949), -- Blue Wolf Leather Armor Texture
(21482,4083,1,1,-1,59949), -- Leather Armor of Doom Design
(21482,5458,1,1,-1,2899), -- Recipe: Halberd(60%)
(21482,57,2238,4479,0,700000), -- Adena
(21483,1877,1,1,-1,220665), -- Adamantite Nugget
(21483,4040,1,1,-1,110332), -- Mold Lubricant
(21483,287,1,1,1,13), -- Bow of Peril
(21483,4121,1,1,1,3549), -- Bow of Peril Shaft
(21483,1343,20,60,2,166279), -- Silver Arrow
(21483,1866,1,1,2,155194), -- Suede
(21483,1871,1,3,2,77597), -- Charcoal
(21483,1877,1,1,2,9312), -- Adamantite Nugget
(21483,4040,1,1,2,4656), -- Mold Lubricant
(21483,4041,1,1,2,2025), -- Mold Hardener
(21483,6335,1,1,2,896), -- Recipe: Sealed Majestic Necklace(70%)
(21484,4085,1,1,-1,99657), -- Tunic of Doom Pattern
(21484,5460,1,1,-1,3133), -- Recipe: Dasparion\'s Staff(60%)
(21484,5468,1,1,-1,3133), -- Recipe: Elemental Sword(60%)
(21484,2398,1,1,1,18), -- Blue Wolf Tunic
(21484,2399,1,1,1,18), -- Tunic of Doom
(21484,2403,1,1,1,29), -- Blue Wolf Stockings
(21484,2404,1,1,1,29), -- Stockings of Doom
(21484,4084,1,1,1,3678), -- Blue Wolf Tunic Fabric
(21484,4085,1,1,1,3678), -- Tunic of Doom Pattern
(21484,4086,1,1,1,4967), -- Blue Wolf Stockings Pattern
(21484,4087,1,1,1,4966), -- Stockings of Doom Pattern
(21484,1867,1,3,2,125468), -- Animal Skin
(21484,1872,1,3,2,188201), -- Animal Bone
(21484,1875,1,1,2,18821), -- Stone of Purity
(21484,1881,1,1,2,37641), -- Coarse Bone Powder
(21484,4041,1,1,2,2455), -- Mold Hardener
(21484,6337,1,1,2,1448), -- Recipe: Sealed Majestic Earring(70%)
(21485,4040,1,1,-1,110332), -- Mold Lubricant
(21485,4086,1,1,-1,129452), -- Blue Wolf Stockings Pattern
(21485,864,1,1,1,59), -- Earring of Black Ore
(21485,895,1,1,1,89), -- Ring of Black Ore
(21485,926,1,1,1,45), -- Necklace of Black Ore
(21485,4052,1,1,1,9615), -- Earring of Black Ore Piece
(21485,4053,1,1,1,11640), -- Ring of Black Ore Gemstone
(21485,4054,1,1,1,5349), -- Necklace of Black Ore Beads
(21485,1343,20,60,2,166278), -- Silver Arrow
(21485,1865,1,3,2,77597), -- Varnish
(21485,1870,2,6,2,58198), -- Coal
(21485,1875,1,1,2,15520), -- Stone of Purity
(21485,1879,1,1,2,38799), -- Cokes
(21485,4040,1,1,2,4656), -- Mold Lubricant
(21485,6339,1,1,2,1791), -- Recipe: Sealed Majestic Ring(70%)
(21486,4087,1,1,-1,124498), -- Stockings of Doom Pattern
(21486,4088,1,1,-1,200510), -- Blue Wolf Helmet Design
(21486,5470,1,1,-1,2899), -- Recipe: Tallum Blade(60%)
(21486,358,1,1,1,17), -- Blue Wolf Breastplate
(21486,2380,1,1,1,26), -- Blue Wolf Gaiters
(21486,2381,1,1,1,12), -- Doom Plate Armor
(21486,4078,1,1,1,3816), -- Blue Wolf Breastplate Part
(21486,4080,1,1,1,5373), -- Blue Wolf Gaiters Material
(21486,4081,1,1,1,2575), -- Doom Plate Armor Temper
(21486,729,1,1,2,30), -- Scroll: Enchant Weapon (Grade A)
(21486,1866,1,1,2,174129), -- Suede
(21486,1871,1,1,2,261194), -- Charcoal
(21486,1885,1,1,2,21767), -- High Grade Suede
(21486,4041,1,1,2,2272), -- Mold Hardener
(21486,5220,1,1,2,10448), -- Metal Hardener
(21487,1894,1,1,-1,326320), -- Crafted Leather
(21487,4089,1,1,-1,351478), -- Doom Helmet Pattern
(21487,57,3923,7851,0,700000), -- Adena
(21488,4044,1,1,-1,295712), -- Thons
(21488,4090,1,1,-1,398265), -- Blue Wolf Boots Design
(21488,57,3742,7489,0,700000), -- Adena
(21489,1877,1,1,-1,42470), -- Adamantite Nugget
(21489,4040,1,1,-1,21235), -- Mold Lubricant
(21489,6343,1,1,-1,22702), -- Sealed Phoenix Necklace Beads
(21489,57,448,896,0,700000), -- Adena
(21489,269,1,1,1,2), -- Blood Tornado
(21489,5539,1,1,1,530), -- Blood Tornado Edge
(21489,1866,1,1,2,34848), -- Suede
(21489,1871,1,1,2,52272), -- Charcoal
(21489,1877,1,1,2,2091), -- Adamantite Nugget
(21489,4040,1,1,2,1046), -- Mold Lubricant
(21489,4041,1,1,2,455), -- Mold Hardener
(21489,5456,1,1,2,20), -- Recipe: Tallum Glaive(60%)
(21490,5450,1,1,-1,1040), -- Recipe: Dragon Grinder(60%)
(21490,5456,1,1,-1,1040), -- Recipe: Tallum Glaive(60%)
(21490,6345,1,1,-1,107412), -- Sealed Phoenix Ring Gemstone
(21490,57,1184,2370,0,700000), -- Adena
(21491,730,1,1,-1,1966), -- Scroll: Enchant Armor (Grade A)
(21491,4041,1,1,-1,20517), -- Mold Hardener
(21491,5478,1,1,-1,19841), -- Sealed Dark Crystal Leather Armor Pattern
(21491,57,995,1991,0,700000), -- Adena
(21492,4040,1,1,-1,56155), -- Mold Lubricant
(21492,5462,1,1,-1,1040), -- Recipe: Branch of The Mother Tree(60%)
(21492,5479,1,1,-1,16614), -- Sealed Tallum Leather Armor Pattern
(21492,57,1184,2370,0,700000), -- Adena
(21493,5464,1,1,-1,874), -- Recipe: Dark Legion\'s Edge(60%)
(21493,5482,1,1,-1,31142), -- Sealed Dark Crystalline Leggings Design
(21493,5485,1,1,-1,19841), -- Sealed Tallum Tunic Texture
(21493,57,995,1991,0,700000), -- Adena
(21494,729,1,1,-1,312), -- Scroll: Enchant Weapon (Grade A)
(21494,1876,1,1,-1,561552), -- Mithril Ore
(21494,4042,1,1,-1,46796), -- Enria
(21494,288,1,1,1,5), -- Carnage Bow
(21494,5535,1,1,1,1415), -- Carnage Bow Stave
(21494,1343,10,30,2,169260), -- Silver Arrow
(21494,1868,1,3,2,118482), -- Thread
(21494,1873,1,1,2,47393), -- Silver Nugget
(21494,1876,1,1,2,23697), -- Mithril Ore
(21494,1895,1,1,2,33852), -- Metallic Fiber
(21494,4042,1,1,2,1975), -- Enria
(21494,6337,1,1,2,608), -- Recipe: Sealed Majestic Earring(70%)
(21495,5466,1,1,-1,874), -- Recipe: Sword of Miracles(60%)
(21495,5486,1,1,-1,13961), -- Sealed Dark Crystal Robe Fabric
(21495,5489,1,1,-1,31142), -- Sealed Tallum Stockings Fabric
(21495,235,1,1,1,4), -- Bloody Orchid
(21495,5536,1,1,1,1186), -- Bloody Orchid Head
(21495,1868,1,1,2,232316), -- Thread
(21495,1873,1,1,2,46464), -- Silver Nugget
(21495,1876,1,1,2,23232), -- Mithril Ore
(21495,1895,1,1,2,33188), -- Metallic Fiber
(21495,4042,1,1,2,1936), -- Enria
(21495,6339,1,1,2,894), -- Recipe: Sealed Majestic Ring(70%)
(21496,730,1,1,-1,2340), -- Scroll: Enchant Armor (Grade A)
(21496,5494,1,1,-1,58968), -- Sealed Dark Crystal Shield Fragment
(21496,6335,1,1,-1,10799), -- Recipe: Sealed Majestic Necklace(70%)
(21496,212,1,1,1,3), -- Dasparion\'s Staff
(21496,2504,1,1,1,3), -- Meteor Shower
(21496,5532,1,1,1,699), -- Meteor Shower Head
(21496,5543,1,1,1,706), -- Dasparion\'s Staff Edge
(21496,729,1,1,2,14), -- Scroll: Enchant Weapon (Grade A)
(21496,1343,10,30,2,169259), -- Silver Arrow
(21496,1868,1,3,2,118481), -- Thread
(21496,1873,1,1,2,47393), -- Silver Nugget
(21496,1876,1,1,2,23697), -- Mithril Ore
(21496,1895,1,1,2,33852), -- Metallic Fiber
(21496,4042,1,1,2,1975), -- Enria
(21497,1884,1,3,-1,725988), -- Cord
(21497,4039,1,1,-1,78649), -- Mold Glue
(21497,5496,1,1,-1,55321), -- Sealed Dark Crystal Boots Lining
(21497,80,1,1,1,2), -- Tallum Blade
(21497,150,1,1,1,2), -- Elemental Sword
(21497,5547,1,1,1,593), -- Elemental Sword Edge
(21497,5548,1,1,1,593), -- Tallum Blade Edge
(21497,730,1,1,2,97), -- Scroll: Enchant Armor (Grade A)
(21497,1864,1,1,2,232317), -- Stem
(21497,1869,1,1,2,116159), -- Iron Ore
(21497,1878,1,1,2,46464), -- Braided Hemp
(21497,1884,1,1,2,71483), -- Cord
(21497,4039,1,1,2,3872), -- Mold Glue
(21498,5497,1,1,-1,137944), -- Sealed Tallum Boots Lining
(21498,6337,1,1,-1,30171), -- Recipe: Sealed Majestic Earring(70%)
(21498,6339,1,1,-1,45256), -- Recipe: Sealed Majestic Ring(70%)
(21498,57,2481,4965,0,700000), -- Adena
(21499,729,1,1,-1,679), -- Scroll: Enchant Weapon (Grade A)
(21499,1895,1,3,-1,873628), -- Metallic Fiber
(21499,5508,1,1,-1,143386), -- Sealed Dark Crystal Gloves Design
(21499,57,2579,5161,0,700000), -- Adena
(21500,4042,1,1,-1,98055), -- Enria
(21500,5434,1,1,-1,2179), -- Recipe: Dragon Slayer(60%)
(21500,5509,1,1,-1,137944), -- Sealed Tallum Gloves Design
(21500,57,2481,4965,0,700000), -- Adena
(21501,5440,1,1,-1,2096), -- Recipe: Elysian(60%)
(21501,5520,1,1,-1,36486), -- Sealed Dark Crystal Breastplate Pattern
(21501,5521,1,1,-1,25746), -- Sealed Tallum Plate Armor Pattern
(21501,57,2386,4775,0,700000), -- Adena
(21502,730,1,1,-1,4903), -- Scroll: Enchant Armor (Grade A)
(21502,1885,1,1,-1,490275), -- High Grade Suede
(21502,1343,560,1680,2,79166), -- Silver Arrow
(21502,1866,20,60,2,51722), -- Suede
(21502,1871,9,27,2,172405), -- Charcoal
(21502,1885,4,12,2,28734), -- High Grade Suede
(21502,4041,1,1,2,26986), -- Mold Hardener
(21502,5220,1,1,2,124132), -- Metal Hardener
(21502,5450,1,1,2,1150), -- Recipe: Dragon Grinder(60%)
(21503,5442,1,1,-1,2265), -- Recipe: Soul Bow(60%)
(21503,5524,1,1,-1,60274), -- Sealed Dark Crystal Gaiters Pattern
(21503,5525,1,1,-1,94534), -- Sealed Dark Crystal Helmet Design
(21503,98,1,1,1,10), -- Halberd
(21503,5542,1,1,1,3047), -- Halberd Edge
(21503,1867,1,3,2,200711), -- Animal Skin
(21503,1872,1,3,2,133807), -- Animal Bone
(21503,1882,1,1,2,66904), -- Leather
(21503,1894,1,1,2,10564), -- Crafted Leather
(21503,4042,1,1,2,5018), -- Enria
(21503,5456,1,1,2,112), -- Recipe: Tallum Glaive(60%)
(21504,729,1,1,-1,654), -- Scroll: Enchant Weapon (Grade A)
(21504,5448,1,1,-1,2179), -- Recipe: Soul Separator(60%)
(21504,5526,1,1,-1,90946), -- Sealed Tallum Helm Design
(21504,288,1,1,1,10), -- Carnage Bow
(21504,5535,1,1,1,2965), -- Carnage Bow Stave
(21504,1343,30,90,2,118221), -- Silver Arrow
(21504,1868,4,12,2,62066), -- Thread
(21504,1873,1,1,2,99306), -- Silver Nugget
(21504,1889,1,1,2,16551), -- Compound Braid
(21504,4044,1,1,2,8276), -- Thons
(21504,5462,1,1,2,92), -- Recipe: Branch of The Mother Tree(60%)
(21504,5549,1,1,2,24827), -- Metallic Thread
(21505,4043,1,1,-1,188604), -- Asofe
(21505,5532,1,1,-1,19080), -- Meteor Shower Head
(21505,235,1,1,1,10), -- Bloody Orchid
(21505,5536,1,1,1,2843), -- Bloody Orchid Head
(21505,1864,1,3,2,278555), -- Stem
(21505,1869,1,3,2,92852), -- Iron Ore
(21505,1880,1,1,2,27856), -- Steel
(21505,4043,1,1,2,9286), -- Asofe
(21505,5464,1,1,2,103), -- Recipe: Dark Legion\'s Edge(60%)
(21505,5550,1,1,2,3715), -- Durable Metal Plate
(21506,5450,1,1,-1,3673), -- Recipe: Dragon Grinder(60%)
(21506,5456,1,1,-1,3673), -- Recipe: Tallum Glaive(60%)
(21506,5535,1,1,-1,33842), -- Carnage Bow Stave
(21506,57,4183,8371,0,700000), -- Adena
(21507,4041,1,1,-1,82270), -- Mold Hardener
(21507,5536,1,1,-1,32189), -- Bloody Orchid Head
(21507,57,3990,7985,0,700000), -- Adena
(21508,4120,1,1,-1,11696), -- Bellion Cestus Edge
(21508,4121,1,1,-1,11657), -- Bow of Peril Shaft
(21508,5444,1,1,-1,1463), -- Recipe: Carnage Bow(60%)
(21508,57,1082,2194,0,700000), -- Adena
(21508,864,1,1,1,29), -- Earring of Black Ore
(21508,895,1,1,1,43), -- Ring of Black Ore
(21508,926,1,1,1,22), -- Necklace of Black Ore
(21508,4052,1,1,1,4665), -- Earring of Black Ore Piece
(21508,4053,1,1,1,5648), -- Ring of Black Ore Gemstone
(21508,4054,1,1,1,2596), -- Necklace of Black Ore Beads
(21508,1875,1,1,2,7530), -- Stone of Purity
(21508,1879,1,1,2,18825), -- Cokes
(21508,1885,1,1,2,9413), -- High Grade Suede
(21508,5466,1,1,2,42), -- Recipe: Sword of Miracles(60%)
(21508,5549,1,1,2,11295), -- Metallic Thread
(21508,5550,1,1,2,1507), -- Durable Metal Plate
(21508,6670,1,1,2,18825), -- Deluxe Chest Key - Grade 6
(21509,4091,1,1,-1,104895), -- Doom Gloves Part
(21509,4096,1,1,-1,104895), -- Blue Wolf Gloves Fabric
(21509,6333,1,1,-1,26826), -- Recipe: Sealed Phoenix Ring(70%)
(21509,57,940,1920,0,700000), -- Adena
(21509,2391,1,1,1,10), -- Blue Wolf Leather Armor
(21509,2392,1,1,1,10), -- Leather Armor of Doom
(21509,4082,1,1,1,1950), -- Blue Wolf Leather Armor Texture
(21509,4083,1,1,1,1950), -- Leather Armor of Doom Design
(21509,1343,10,30,2,140853), -- Silver Arrow
(21509,1864,1,1,2,197194), -- Stem
(21509,1869,1,1,2,98597), -- Iron Ore
(21509,1880,1,1,2,9860), -- Steel
(21509,4043,1,1,2,3287), -- Asofe
(21509,5440,1,1,2,37), -- Recipe: Elysian(60%)
(21509,5550,1,1,2,1315), -- Durable Metal Plate
(21510,730,1,1,-1,2381), -- Scroll: Enchant Armor (Grade A)
(21510,1875,1,1,-1,190480), -- Stone of Purity
(21510,5508,1,1,-1,66992), -- Sealed Dark Crystal Gloves Design
(21510,57,1153,2344,0,700000), -- Adena
(21510,235,1,1,1,5), -- Bloody Orchid
(21510,5536,1,1,1,1436), -- Bloody Orchid Head
(21510,1865,1,1,2,140663), -- Varnish
(21510,1870,1,1,2,140663), -- Coal
(21510,1875,1,1,2,9378), -- Stone of Purity
(21510,1879,1,1,2,23444), -- Cokes
(21510,4040,1,1,2,2814), -- Mold Lubricant
(21510,5456,1,1,2,53), -- Recipe: Tallum Glaive(60%)
(21511,1875,1,1,-1,246682), -- Stone of Purity
(21511,5462,1,1,-1,1370), -- Recipe: Branch of The Mother Tree(60%)
(21511,5539,1,1,-1,12478), -- Blood Tornado Edge
(21511,57,1494,3034,0,700000), -- Adena
(21511,212,1,1,1,3), -- Dasparion\'s Staff
(21511,2504,1,1,1,3), -- Meteor Shower
(21511,5532,1,1,1,922), -- Meteor Shower Head
(21511,5543,1,1,1,930), -- Dasparion\'s Staff Edge
(21511,1343,20,60,2,111530), -- Silver Arrow
(21511,1867,1,1,2,208189), -- Animal Skin
(21511,1872,1,3,2,69397), -- Animal Bone
(21511,1875,1,1,2,10410), -- Stone of Purity
(21511,1881,1,1,2,20819), -- Coarse Bone Powder
(21511,4041,1,1,2,1358), -- Mold Hardener
(21511,6337,1,1,2,801), -- Recipe: Sealed Majestic Earring(70%)
(21512,730,1,1,-1,3601), -- Scroll: Enchant Armor (Grade A)
(21512,1875,1,1,-1,288061), -- Stone of Purity
(21512,4041,1,1,-1,37573), -- Mold Hardener
(21512,57,1743,3546,0,700000), -- Adena
(21512,235,1,1,1,7), -- Bloody Orchid
(21512,5536,1,1,1,2172), -- Bloody Orchid Head
(21512,1343,20,60,2,130239), -- Silver Arrow
(21512,1867,1,1,2,243112), -- Animal Skin
(21512,1872,1,3,2,81037), -- Animal Bone
(21512,1875,1,1,2,12156), -- Stone of Purity
(21512,1881,1,1,2,24312), -- Coarse Bone Powder
(21512,4041,1,1,2,1586), -- Mold Hardener
(21512,5462,1,1,2,68), -- Recipe: Branch of The Mother Tree(60%)
(21513,5442,1,1,-1,1128), -- Recipe: Soul Bow(60%)
(21513,5486,1,1,-1,18023), -- Sealed Dark Crystal Robe Fabric
(21513,5489,1,1,-1,40202), -- Sealed Tallum Stockings Fabric
(21513,57,1229,2500,0,700000), -- Adena
(21513,5290,1,1,1,20), -- Sealed Dark Crystal Gloves
(21513,5291,1,1,1,20), -- Sealed Dark Crystal Boots
(21513,5295,1,1,1,20), -- Sealed Tallum Gloves
(21513,5296,1,1,1,20), -- Sealed Tallum Boots
(21513,5496,1,1,1,2637), -- Sealed Dark Crystal Boots Lining
(21513,5497,1,1,1,2637), -- Sealed Tallum Boots Lining
(21513,5508,1,1,1,2637), -- Sealed Dark Crystal Gloves Design
(21513,5509,1,1,1,2637), -- Sealed Tallum Gloves Design
(21513,1895,1,1,2,51414), -- Metallic Fiber
(21513,4040,1,1,2,3599), -- Mold Lubricant
(21513,4042,1,1,2,3000), -- Enria
(21513,4043,1,1,2,5999), -- Asofe
(21513,5464,1,1,2,67), -- Recipe: Dark Legion\'s Edge(60%)
(21514,4039,1,1,-1,88470), -- Mold Glue
(21514,5462,1,1,-1,983), -- Recipe: Branch of The Mother Tree(60%)
(21514,5479,1,1,-1,15705), -- Sealed Tallum Leather Armor Pattern
(21514,57,1069,2179,0,700000), -- Adena
(21514,212,1,1,1,3), -- Dasparion\'s Staff
(21514,2504,1,1,1,3), -- Meteor Shower
(21514,5532,1,1,1,661), -- Meteor Shower Head
(21514,5543,1,1,1,667), -- Dasparion\'s Staff Edge
(21514,1864,1,3,2,130663), -- Stem
(21514,1869,1,1,2,130663), -- Iron Ore
(21514,1878,1,1,2,52266), -- Braided Hemp
(21514,1884,1,1,2,80408), -- Cord
(21514,4039,1,1,2,4356), -- Mold Glue
(21514,5272,1,1,2,58), -- Recipe: Greater Soulshot (S) Compressed Package(100%)
(21515,5442,1,1,-1,1199), -- Recipe: Soul Bow(60%)
(21515,5524,1,1,-1,31914), -- Sealed Dark Crystal Gaiters Pattern
(21515,5525,1,1,-1,50053), -- Sealed Dark Crystal Helmet Design
(21515,57,1303,2660,0,700000), -- Adena
(21515,235,1,1,1,6), -- Bloody Orchid
(21515,5536,1,1,1,1627), -- Bloody Orchid Head
(21515,1344,10,30,2,149445), -- Mithril Arrow
(21515,1868,1,3,2,119556), -- Thread
(21515,1873,1,1,2,47822), -- Silver Nugget
(21515,1876,1,1,2,23911), -- Mithril Ore
(21515,1895,1,1,2,34159), -- Metallic Fiber
(21515,4042,1,1,2,1993), -- Enria
(21515,5277,1,1,2,54), -- Recipe: Greater Spiritshot (S) Compressed Package(100%)
(21515,6670,1,1,2,19926), -- Deluxe Chest Key - Grade 6
(21516,6337,1,1,-1,20081), -- Recipe: Sealed Majestic Earring(70%)
(21516,6339,1,1,-1,30122), -- Recipe: Sealed Majestic Ring(70%)
(21516,6345,1,1,-1,149802), -- Sealed Phoenix Ring Gemstone
(21516,57,1578,3213,0,700000), -- Adena
(21516,235,1,1,1,7), -- Bloody Orchid
(21516,5536,1,1,1,1968), -- Bloody Orchid Head
(21516,1868,1,3,2,192780), -- Thread
(21516,1873,1,1,2,77112), -- Silver Nugget
(21516,1876,1,1,2,38556), -- Mithril Ore
(21516,1895,1,1,2,55080), -- Metallic Fiber
(21516,4042,1,1,2,3214), -- Enria
(21516,5282,1,1,2,86), -- Recipe: Greater Blessed Spiritshot (S) Compressed Package(100%)
(21517,5462,1,1,-1,1806), -- Recipe: Branch of The Mother Tree(60%)
(21517,5478,1,1,-1,41014), -- Sealed Dark Crystal Leather Armor Pattern
(21517,5479,1,1,-1,28860), -- Sealed Tallum Leather Armor Pattern
(21517,57,1964,4004,0,700000), -- Adena
(21517,5297,1,1,1,14), -- Sealed Dark Crystal Leather Armor
(21517,5298,1,1,1,23), -- Sealed Dark Crystalline Leggings
(21517,5301,1,1,1,10), -- Sealed Tallum Leather Armor
(21517,5478,1,1,1,2019), -- Sealed Dark Crystal Leather Armor Pattern
(21517,5479,1,1,1,1421), -- Sealed Tallum Leather Armor Pattern
(21517,5482,1,1,1,3169), -- Sealed Dark Crystalline Leggings Design
(21517,1864,4,12,2,60029), -- Stem
(21517,1865,2,6,2,48023), -- Varnish
(21517,1866,3,9,2,26680), -- Suede
(21517,1868,1,3,2,160077), -- Thread
(21517,1873,1,1,2,96046), -- Silver Nugget
(21517,5162,1,1,2,107), -- Recipe: Spiritshot (S) Compressed Package (100%)
(21518,4041,1,1,-1,23654), -- Mold Hardener
(21518,5462,1,1,-1,1008), -- Recipe: Branch of The Mother Tree(60%)
(21518,5509,1,1,-1,63781), -- Sealed Tallum Gloves Design
(21518,57,1098,2231,0,700000), -- Adena
(21518,288,1,1,1,5), -- Carnage Bow
(21518,5535,1,1,1,1371), -- Carnage Bow Stave
(21518,1343,10,30,2,163985), -- Silver Arrow
(21518,1866,1,1,2,76526), -- Suede
(21518,1871,1,1,2,114790), -- Charcoal
(21518,1885,1,1,2,9566), -- High Grade Suede
(21518,4041,1,1,2,999), -- Mold Hardener
(21518,5220,1,1,2,4592), -- Metal Hardener
(21518,5462,1,1,2,43), -- Recipe: Branch of The Mother Tree(60%)
(21519,729,1,1,-1,343), -- Scroll: Enchant Weapon (Grade A)
(21519,5448,1,1,-1,1142), -- Recipe: Soul Separator(60%)
(21519,5526,1,1,-1,47654), -- Sealed Tallum Helm Design
(21519,57,1240,2533,0,700000), -- Adena
(21519,5290,1,1,1,20), -- Sealed Dark Crystal Gloves
(21519,5291,1,1,1,20), -- Sealed Dark Crystal Boots
(21519,5295,1,1,1,20), -- Sealed Tallum Gloves
(21519,5296,1,1,1,20), -- Sealed Tallum Boots
(21519,5496,1,1,1,2669), -- Sealed Dark Crystal Boots Lining
(21519,5497,1,1,1,2669), -- Sealed Tallum Boots Lining
(21519,5508,1,1,1,2669), -- Sealed Dark Crystal Gloves Design
(21519,5509,1,1,1,2669), -- Sealed Tallum Gloves Design
(21519,1868,1,1,2,303532), -- Thread
(21519,1873,1,1,2,60707), -- Silver Nugget
(21519,1876,1,1,2,30354), -- Mithril Ore
(21519,1895,1,1,2,43362), -- Metallic Fiber
(21519,4042,1,1,2,2530), -- Enria
(21519,5282,1,1,2,68), -- Recipe: Greater Blessed Spiritshot (S) Compressed Package(100%)
(21520,4049,1,1,-1,130322), -- Adamantite Earring Gemstone
(21520,4050,1,1,-1,153940), -- Adamantite Ring Wire
(21520,4129,1,1,-1,26890), -- Recipe: Earrings of Black Ore
(21520,57,1002,2038,0,700000), -- Adena
(21520,856,1,1,1,41), -- Adamantite Earring
(21520,887,1,1,1,61), -- Adamantite Ring
(21520,918,1,1,1,31), -- Adamantite Necklace
(21520,4049,1,1,1,6418), -- Adamantite Earring Gemstone
(21520,4050,1,1,1,7581), -- Adamantite Ring Wire
(21520,4051,1,1,1,4745), -- Adamantite Necklace Chain
(21520,947,1,1,2,49), -- Scroll: Enchant Weapon (Grade B)
(21520,1832,1,1,2,135910), -- Greater Antidote
(21520,1895,1,1,2,34949), -- Metallic Fiber
(21520,4040,1,1,2,2447), -- Mold Lubricant
(21520,4042,1,1,2,2039), -- Enria
(21520,4043,1,1,2,4078), -- Asofe
(21521,947,1,1,-1,977), -- Scroll: Enchant Weapon (Grade B)
(21521,4051,1,1,-1,94736), -- Adamantite Necklace Chain
(21521,4130,1,1,-1,39655), -- Recipe: Ring of Black Ore
(21521,57,986,2003,0,700000), -- Adena
(21521,78,1,1,1,3), -- Great Sword
(21521,142,1,1,1,3), -- Keshanberk
(21521,148,1,1,1,3), -- Sword of Valhalla
(21521,4104,1,1,1,689), -- Great Sword Blade
(21521,4107,1,1,1,678), -- Keshanberk Blade
(21521,4108,1,1,1,678), -- Sword of Valhalla Blade
(21521,948,1,1,2,258), -- Scroll: Enchant Armor (Grade B)
(21521,1832,1,1,2,114534), -- Greater Antidote
(21521,1868,1,1,2,206160), -- Thread
(21521,1873,1,1,2,41232), -- Silver Nugget
(21521,1889,1,1,2,6872), -- Compound Braid
(21521,4044,1,1,2,3436), -- Thons
(21521,5549,1,1,2,10308), -- Metallic Thread
(21522,947,1,1,-1,1165), -- Scroll: Enchant Weapon (Grade B)
(21522,4051,1,1,-1,112905), -- Adamantite Necklace Chain
(21522,4130,1,1,-1,47261), -- Recipe: Ring of Black Ore
(21522,57,1175,2388,0,700000), -- Adena
(21522,78,1,1,1,4), -- Great Sword
(21522,142,1,1,1,4), -- Keshanberk
(21522,148,1,1,1,4), -- Sword of Valhalla
(21522,4104,1,1,1,820), -- Great Sword Blade
(21522,4107,1,1,1,808), -- Keshanberk Blade
(21522,4108,1,1,1,808), -- Sword of Valhalla Blade
(21522,948,1,1,2,308), -- Scroll: Enchant Armor (Grade B)
(21522,1832,1,1,2,136500), -- Greater Antidote
(21522,1868,1,1,2,245699), -- Thread
(21522,1873,1,1,2,49140), -- Silver Nugget
(21522,1889,1,1,2,8190), -- Compound Braid
(21522,4044,1,1,2,4095), -- Thons
(21522,5549,1,1,2,12285), -- Metallic Thread
(21523,948,1,1,-1,6279), -- Scroll: Enchant Armor (Grade B)
(21523,4070,1,1,-1,89915), -- Stockings of Zubei Fabric
(21523,4159,1,1,-1,7116), -- Recipe: Blue Wolf Leather Armor
(21523,57,1015,2059,0,700000), -- Adena
(21523,357,1,1,1,9), -- Zubei\'s Breastplate
(21523,383,1,1,1,15), -- Zubei\'s Gaiters
(21523,2376,1,1,1,9), -- Avadon Breastplate
(21523,2379,1,1,1,15), -- Avadon Gaiters
(21523,4056,1,1,1,1679), -- Zubei\'s Breastplate Part
(21523,4057,1,1,1,2594), -- Zubei\'s Gaiter Material
(21523,4064,1,1,1,1679), -- Avadon Breastplate Part
(21523,4065,1,1,1,2594), -- Avadon Gaiters Material
(21523,1832,1,1,2,103047), -- Greater Antidote
(21523,1864,1,3,2,92743), -- Stem
(21523,1865,1,1,2,92743), -- Varnish
(21523,1866,1,1,2,61829), -- Suede
(21523,1868,1,3,2,61829), -- Thread
(21523,1873,1,1,2,37098), -- Silver Nugget
(21523,4160,1,1,2,263), -- Recipe: Leather Armor of Doom
(21523,6670,1,1,2,15458), -- Deluxe Chest Key - Grade 6
(21524,948,1,1,-1,6696), -- Scroll: Enchant Armor (Grade B)
(21524,4070,1,1,-1,95874), -- Stockings of Zubei Fabric
(21524,4159,1,1,-1,7587), -- Recipe: Blue Wolf Leather Armor
(21524,57,1082,2195,0,700000), -- Adena
(21524,2384,1,1,1,17), -- Zubei\'s Leather Shirt
(21524,2388,1,1,1,28), -- Zubei\'s Leather Gaiters
(21524,2390,1,1,1,12), -- Avadon Leather Armor
(21524,4066,1,1,1,3108), -- Zubei\'s Leather Shirt Fabric
(21524,4067,1,1,1,4719), -- Zubei\'s Leather Gaiter Texture
(21524,4068,1,1,1,2388), -- Avadon Leather Armor Lining
(21524,1343,20,60,2,80727), -- Silver Arrow
(21524,1867,2,6,2,37673), -- Animal Skin
(21524,1869,2,6,2,22604), -- Iron Ore
(21524,1870,1,1,2,113017), -- Coal
(21524,1871,1,1,2,113017), -- Charcoal
(21524,1872,1,3,2,50230), -- Animal Bone
(21524,4161,1,1,2,470), -- Recipe: Blue Wolf Tunic
(21525,4049,1,1,-1,140479), -- Adamantite Earring Gemstone
(21525,4050,1,1,-1,165938), -- Adamantite Ring Wire
(21525,4129,1,1,-1,28985), -- Recipe: Earrings of Black Ore
(21525,57,1082,2195,0,700000), -- Adena
(21525,229,1,1,1,5), -- Kris
(21525,243,1,1,1,5), -- Hell Knife
(21525,4109,1,1,1,1114), -- Kris Edge
(21525,4110,1,1,1,1114), -- Hell Knife Edge
(21525,947,1,1,2,53), -- Scroll: Enchant Weapon (Grade B)
(21525,1343,10,30,2,188359), -- Silver Arrow
(21525,1894,1,1,2,4627), -- Crafted Leather
(21525,4039,1,1,2,4395), -- Mold Glue
(21525,4041,1,1,2,1147), -- Mold Hardener
(21525,4044,1,1,2,4395), -- Thons
(21526,1889,1,1,-1,198975), -- Compound Braid
(21526,4052,1,1,-1,105669), -- Earring of Black Ore Piece
(21526,5549,1,1,-1,298462), -- Metallic Thread
(21526,57,1207,2445,0,700000), -- Adena
(21526,79,1,1,1,7), -- Sword of Damascus
(21526,4114,1,1,1,1930), -- Sword of Damascus Blade
(21526,1807,1,1,2,197), -- Recipe: Soulshot: A-Grade
(21526,1868,1,1,2,293871), -- Thread
(21526,1873,1,1,2,58775), -- Silver Nugget
(21526,1889,1,1,2,9796), -- Compound Braid
(21526,4044,1,1,2,4898), -- Thons
(21526,5549,1,1,2,14694), -- Metallic Thread
(21527,4040,1,1,-1,52463), -- Mold Lubricant
(21527,4081,1,1,-1,25854), -- Doom Plate Armor Temper
(21527,5161,1,1,-1,3498), -- Recipe: Spiritshot (A) Compressed Package (100%)
(21527,57,1061,2149,0,700000), -- Adena
(21527,110,1,1,1,31), -- Doom Shield
(21527,2416,1,1,1,22), -- Blue Wolf Helmet
(21527,2417,1,1,1,22), -- Doom Helmet
(21527,4077,1,1,1,5810), -- Doom Shield Fragment
(21527,4088,1,1,1,4881), -- Blue Wolf Helmet Design
(21527,4089,1,1,1,4881), -- Doom Helmet Pattern
(21527,1343,10,30,2,158131), -- Silver Arrow
(21527,1866,1,1,2,73795), -- Suede
(21527,1871,1,1,2,110692), -- Charcoal
(21527,1877,1,1,2,4428), -- Adamantite Nugget
(21527,4040,1,1,2,2214), -- Mold Lubricant
(21527,4041,1,1,2,963), -- Mold Hardener
(21527,5166,1,1,2,148), -- Recipe: Blessed Spiritshot (A) Compressed Package (100%)
(21528,4040,1,1,-1,64675), -- Mold Lubricant
(21528,4081,1,1,-1,31872), -- Doom Plate Armor Temper
(21528,5161,1,1,-1,4312), -- Recipe: Spiritshot (A) Compressed Package (100%)
(21528,57,1308,2649,0,700000), -- Adena
(21528,110,1,1,1,38), -- Doom Shield
(21528,2416,1,1,1,27), -- Blue Wolf Helmet
(21528,2417,1,1,1,27), -- Doom Helmet
(21528,4077,1,1,1,7162), -- Doom Shield Fragment
(21528,4088,1,1,1,6017), -- Blue Wolf Helmet Design
(21528,4089,1,1,1,6017), -- Doom Helmet Pattern
(21528,1343,10,30,2,194940), -- Silver Arrow
(21528,1866,1,1,2,90972), -- Suede
(21528,1871,1,1,2,136458), -- Charcoal
(21528,1877,1,1,2,5459), -- Adamantite Nugget
(21528,4040,1,1,2,2730), -- Mold Lubricant
(21528,4041,1,1,2,1187), -- Mold Hardener
(21528,5166,1,1,2,182), -- Recipe: Blessed Spiritshot (A) Compressed Package (100%)
(21529,4082,1,1,-1,27949), -- Blue Wolf Leather Armor Texture
(21529,4083,1,1,-1,27949), -- Leather Armor of Doom Design
(21529,5166,1,1,-1,3298), -- Recipe: Blessed Spiritshot (A) Compressed Package (100%)
(21529,57,1001,2026,0,700000), -- Adena
(21529,2398,1,1,1,8), -- Blue Wolf Tunic
(21529,2399,1,1,1,8), -- Tunic of Doom
(21529,2403,1,1,1,13), -- Blue Wolf Stockings
(21529,2404,1,1,1,13), -- Stockings of Doom
(21529,4084,1,1,1,1587), -- Blue Wolf Tunic Fabric
(21529,4085,1,1,1,1587), -- Tunic of Doom Pattern
(21529,4086,1,1,1,2143), -- Blue Wolf Stockings Pattern
(21529,4087,1,1,1,2143), -- Stockings of Doom Pattern
(21529,1832,1,1,2,115975), -- Greater Antidote
(21529,1867,1,1,2,139169), -- Animal Skin
(21529,1872,1,1,2,139169), -- Animal Bone
(21529,1882,1,1,2,23195), -- Leather
(21529,1894,1,1,2,3663), -- Crafted Leather
(21529,4042,1,1,2,1740), -- Enria
(21529,5230,1,1,2,140), -- Recipe: Mithril Arrow (100%)
(21530,4120,1,1,-1,11550), -- Bellion Cestus Edge
(21530,4121,1,1,-1,11511), -- Bow of Peril Shaft
(21530,5470,1,1,-1,1444), -- Recipe: Tallum Blade(60%)
(21530,57,1070,2165,0,700000), -- Adena
(21530,268,1,1,1,6), -- Bellion Cestus
(21530,4120,1,1,1,1707), -- Bellion Cestus Edge
(21530,1874,1,1,2,7436), -- Oriharukon Ore
(21530,1878,1,1,2,44613), -- Braided Hemp
(21530,1884,1,1,2,68636), -- Cord
(21530,1889,1,1,2,7436), -- Compound Braid
(21530,5220,1,1,2,4462), -- Metal Hardener
(21530,6333,1,1,2,1281), -- Recipe: Sealed Phoenix Ring(70%)
(21530,6670,1,1,2,18589), -- Deluxe Chest Key - Grade 6
(21531,1876,1,1,-1,594082), -- Mithril Ore
(21531,1895,1,1,-1,848688), -- Metallic Fiber
(21531,4052,1,1,-1,105166), -- Earring of Black Ore Piece
(21531,57,1203,2433,0,700000), -- Adena
(21531,287,1,1,1,7), -- Bow of Peril
(21531,4121,1,1,1,1911), -- Bow of Peril Shaft
(21531,1343,10,30,2,179064), -- Silver Arrow
(21531,1807,1,1,2,168), -- Recipe: Soulshot: A-Grade
(21531,1868,1,3,2,125345), -- Thread
(21531,1873,1,1,2,50138), -- Silver Nugget
(21531,1876,1,1,2,25069), -- Mithril Ore
(21531,1895,1,1,2,35813), -- Metallic Fiber
(21531,4042,1,1,2,2090), -- Enria
(21532,1894,1,1,-1,107921), -- Crafted Leather
(21532,4042,1,1,-1,51262), -- Enria
(21532,4054,1,1,-1,60582), -- Necklace of Black Ore Beads
(21532,57,1243,2521,0,700000), -- Adena
(21532,171,1,1,1,3), -- Deadman\'s Glory
(21532,175,1,1,1,3), -- Art of Battle Axe
(21532,210,1,1,1,3), -- Staff of Evil Spirits
(21532,4116,1,1,1,662), -- Deadman\'s Glory Stone
(21532,4117,1,1,1,662), -- Art of Battle Axe Blade
(21532,4118,1,1,1,627), -- Evil Spirit Head
(21532,1867,1,1,2,201895), -- Animal Skin
(21532,1872,1,1,2,201895), -- Animal Bone
(21532,1882,1,1,2,33650), -- Leather
(21532,1894,1,1,2,5313), -- Crafted Leather
(21532,4042,1,1,2,2524), -- Enria
(21532,5450,1,1,2,57), -- Recipe: Dragon Grinder(60%)
(21533,4077,1,1,-1,117809), -- Doom Shield Fragment
(21533,4078,1,1,-1,38254), -- Blue Wolf Breastplate Part
(21533,5470,1,1,-1,1431), -- Recipe: Tallum Blade(60%)
(21533,57,1059,2146,0,700000), -- Adena
(21533,864,1,1,1,28), -- Earring of Black Ore
(21533,895,1,1,1,42), -- Ring of Black Ore
(21533,926,1,1,1,21), -- Necklace of Black Ore
(21533,4052,1,1,1,4565), -- Earring of Black Ore Piece
(21533,4053,1,1,1,5526), -- Ring of Black Ore Gemstone
(21533,4054,1,1,1,2540), -- Necklace of Black Ore Beads
(21533,1343,10,30,2,157874), -- Silver Arrow
(21533,1866,1,1,2,73675), -- Suede
(21533,1871,1,1,2,110512), -- Charcoal
(21533,1877,1,1,2,4421), -- Adamantite Nugget
(21533,4040,1,1,2,2211), -- Mold Lubricant
(21533,4041,1,1,2,961), -- Mold Hardener
(21533,5456,1,1,2,41), -- Recipe: Tallum Glaive(60%)
(21534,4077,1,1,-1,155732), -- Doom Shield Fragment
(21534,5470,1,1,-1,1892), -- Recipe: Tallum Blade(60%)
(21534,57,1399,2837,0,700000), -- Adena
(21534,864,1,1,1,37), -- Earring of Black Ore
(21534,895,1,1,1,56), -- Ring of Black Ore
(21534,926,1,1,1,28), -- Necklace of Black Ore
(21534,4052,1,1,1,6034), -- Earring of Black Ore Piece
(21534,4053,1,1,1,7305), -- Ring of Black Ore Gemstone
(21534,4054,1,1,1,3357), -- Necklace of Black Ore Beads
(21534,1343,10,30,2,208694), -- Silver Arrow
(21534,1866,1,1,2,97391), -- Suede
(21534,1871,1,1,2,146086), -- Charcoal
(21534,1877,1,1,2,5844), -- Adamantite Nugget
(21534,4040,1,1,2,2922), -- Mold Lubricant
(21534,4041,1,1,2,1271), -- Mold Hardener
(21534,5456,1,1,2,55), -- Recipe: Tallum Glaive(60%)
(21535,1876,1,1,-1,620351), -- Mithril Ore
(21535,1877,1,1,-1,124070), -- Adamantite Nugget
(21535,4052,1,1,-1,109816), -- Earring of Black Ore Piece
(21535,57,1253,2542,0,700000), -- Adena
(21535,79,1,1,1,7), -- Sword of Damascus
(21535,4114,1,1,1,2006), -- Sword of Damascus Blade
(21535,1343,10,30,2,186983), -- Silver Arrow
(21535,1876,1,1,2,26178), -- Mithril Ore
(21535,1877,1,1,2,5236), -- Adamantite Nugget
(21535,1880,1,1,2,13089), -- Steel
(21535,1881,1,1,2,17452), -- Coarse Bone Powder
(21535,1882,1,1,2,29087), -- Leather
(21535,6335,1,1,2,504), -- Recipe: Sealed Majestic Necklace(70%)
(21536,4053,1,1,-1,128534), -- Ring of Black Ore Gemstone
(21536,5446,1,1,-1,1639), -- Recipe: Bloody Orchid(60%)
(21536,5452,1,1,-1,1639), -- Recipe: Blood Tornado(60%)
(21536,57,1212,2457,0,700000), -- Adena
(21536,234,1,1,1,7), -- Demon\'s Sword
(21536,4119,1,1,1,1939), -- Demon\'s Sword Edge
(21536,1894,1,1,2,5180), -- Crafted Leather
(21536,4039,1,1,2,4921), -- Mold Glue
(21536,4041,1,1,2,1284), -- Mold Hardener
(21536,4044,1,1,2,4921), -- Thons
(21536,6337,1,1,2,758), -- Recipe: Sealed Majestic Earring(70%)
(21536,6670,1,1,2,24605), -- Deluxe Chest Key - Grade 6
(21537,1874,1,1,-1,201181), -- Oriharukon Ore
(21537,4043,1,1,-1,100591), -- Asofe
(21537,4099,1,1,-1,135476), -- Doom Boots Part
(21537,57,1213,2480,0,700000), -- Adena
(21537,287,1,1,1,7), -- Bow of Peril
(21537,4121,1,1,1,1942), -- Bow of Peril Shaft
(21537,1865,1,1,2,148565), -- Varnish
(21537,1870,1,1,2,148565), -- Coal
(21537,1874,1,1,2,9905), -- Oriharukon Ore
(21537,4039,1,1,2,4953), -- Mold Glue
(21537,4043,1,1,2,4953), -- Asofe
(21537,5442,1,1,2,55), -- Recipe: Soul Bow(60%)
(21538,1874,1,1,-1,246445), -- Oriharukon Ore
(21538,4043,1,1,-1,123222), -- Asofe
(21538,4099,1,1,-1,165956), -- Doom Boots Part
(21538,57,1486,3038,0,700000), -- Adena
(21538,287,1,1,1,9), -- Bow of Peril
(21538,4121,1,1,1,2378), -- Bow of Peril Shaft
(21538,1865,1,1,2,181990), -- Varnish
(21538,1870,1,1,2,181990), -- Coal
(21538,1874,1,1,2,12133), -- Oriharukon Ore
(21538,4039,1,1,2,6067), -- Mold Glue
(21538,4043,1,1,2,6067), -- Asofe
(21538,5442,1,1,2,68), -- Recipe: Soul Bow(60%)
(21539,1807,1,1,-1,4376), -- Recipe: Soulshot: A-Grade
(21539,3035,1,1,-1,4376), -- Recipe: Spiritshot A
(21539,4114,1,1,-1,14366), -- Sword of Damascus Blade
(21539,57,1320,2697,0,700000), -- Adena
(21539,2398,1,1,1,11), -- Blue Wolf Tunic
(21539,2399,1,1,1,11), -- Tunic of Doom
(21539,2403,1,1,1,17), -- Blue Wolf Stockings
(21539,2404,1,1,1,17), -- Stockings of Doom
(21539,4084,1,1,1,2106), -- Blue Wolf Tunic Fabric
(21539,4085,1,1,1,2106), -- Tunic of Doom Pattern
(21539,4086,1,1,1,2843), -- Blue Wolf Stockings Pattern
(21539,4087,1,1,1,2843), -- Stockings of Doom Pattern
(21539,1343,10,30,2,197851), -- Silver Arrow
(21539,1866,1,1,2,92331), -- Suede
(21539,1871,1,1,2,138496), -- Charcoal
(21539,1877,1,1,2,5540), -- Adamantite Nugget
(21539,4040,1,1,2,2771), -- Mold Lubricant
(21539,4041,1,1,2,1205), -- Mold Hardener
(21539,5448,1,1,2,52), -- Recipe: Soul Separator(60%)
(21540,1807,1,1,-1,4376), -- Recipe: Soulshot: A-Grade
(21540,3035,1,1,-1,4376), -- Recipe: Spiritshot A
(21540,4053,1,1,-1,140680), -- Ring of Black Ore Gemstone
(21540,57,1320,2697,0,700000), -- Adena
(21540,171,1,1,1,3), -- Deadman\'s Glory
(21540,175,1,1,1,3), -- Art of Battle Axe
(21540,210,1,1,1,3), -- Staff of Evil Spirits
(21540,4116,1,1,1,707), -- Deadman\'s Glory Stone
(21540,4117,1,1,1,707), -- Art of Battle Axe Blade
(21540,4118,1,1,1,670), -- Evil Spirit Head
(21540,729,1,1,2,18), -- Scroll: Enchant Weapon (Grade A)
(21540,1343,10,30,2,230827), -- Silver Arrow
(21540,1894,1,1,2,5670), -- Crafted Leather
(21540,4039,1,1,2,5386), -- Mold Glue
(21540,4041,1,1,2,1406), -- Mold Hardener
(21540,4044,1,1,2,5386), -- Thons
(21541,1874,1,1,-1,222264), -- Oriharukon Ore
(21541,4043,1,1,-1,111132), -- Asofe
(21541,4084,1,1,-1,57942), -- Blue Wolf Tunic Fabric
(21541,57,1349,2731,0,700000), -- Adena
(21541,79,1,1,1,8), -- Sword of Damascus
(21541,4114,1,1,1,2156), -- Sword of Damascus Blade
(21541,1343,20,60,2,100491), -- Silver Arrow
(21541,1865,1,1,2,140687), -- Varnish
(21541,1870,1,1,2,140687), -- Coal
(21541,1874,1,1,2,9379), -- Oriharukon Ore
(21541,4039,1,1,2,4690), -- Mold Glue
(21541,4043,1,1,2,4690), -- Asofe
(21541,5271,1,1,2,188), -- Recipe: Greater Soulshot (A) Compressed Package(100%)
(21542,1807,1,1,-1,3091), -- Recipe: Soulshot: A-Grade
(21542,3035,1,1,-1,3091), -- Recipe: Spiritshot A
(21542,4053,1,1,-1,99376), -- Ring of Black Ore Gemstone
(21542,57,938,1900,0,700000), -- Adena
(21542,234,1,1,1,6), -- Demon\'s Sword
(21542,4119,1,1,1,1499), -- Demon\'s Sword Edge
(21542,1343,10,30,2,139763), -- Silver Arrow
(21542,1864,1,1,2,195667), -- Stem
(21542,1869,1,1,2,97834), -- Iron Ore
(21542,1880,1,1,2,9784), -- Steel
(21542,3035,1,1,2,131), -- Recipe: Spiritshot A
(21542,4043,1,1,2,3261), -- Asofe
(21542,5550,1,1,2,1305), -- Durable Metal Plate
(21543,1877,1,1,-1,105814), -- Adamantite Nugget
(21543,4041,1,1,-1,23003), -- Mold Hardener
(21543,4054,1,1,-1,52104), -- Necklace of Black Ore Beads
(21543,57,1070,2167,0,700000), -- Adena
(21543,171,1,1,1,2), -- Deadman\'s Glory
(21543,175,1,1,1,2), -- Art of Battle Axe
(21543,210,1,1,1,2), -- Staff of Evil Spirits
(21543,4116,1,1,1,570), -- Deadman\'s Glory Stone
(21543,4117,1,1,1,570), -- Art of Battle Axe Blade
(21543,4118,1,1,1,540), -- Evil Spirit Head
(21543,1866,1,1,2,86822), -- Suede
(21543,1871,1,1,2,130233), -- Charcoal
(21543,1877,1,1,2,5210), -- Adamantite Nugget
(21543,3956,1,1,2,174), -- Recipe: Blessed Spiritshot A
(21543,4040,1,1,2,2605), -- Mold Lubricant
(21543,4041,1,1,2,1133), -- Mold Hardener
(21544,1875,1,1,-1,246302), -- Stone of Purity
(21544,4041,1,1,-1,32126), -- Mold Hardener
(21544,4115,1,1,-1,16117), -- Lance Blade
(21544,57,1486,3036,0,700000), -- Adena
(21544,864,1,1,1,40), -- Earring of Black Ore
(21544,895,1,1,1,60), -- Ring of Black Ore
(21544,926,1,1,1,30), -- Necklace of Black Ore
(21544,4052,1,1,1,6439), -- Earring of Black Ore Piece
(21544,4053,1,1,1,7796), -- Ring of Black Ore Gemstone
(21544,4054,1,1,1,3583), -- Necklace of Black Ore Beads
(21544,1867,1,1,2,242513), -- Animal Skin
(21544,1872,1,3,2,121257), -- Animal Bone
(21544,1875,1,1,2,12126), -- Stone of Purity
(21544,1881,1,1,2,24252), -- Coarse Bone Powder
(21544,4041,1,1,2,1582), -- Mold Hardener
(21544,5450,1,1,2,68), -- Recipe: Dragon Grinder(60%)
(21545,4052,1,1,-1,94015), -- Earring of Black Ore Piece
(21545,4054,1,1,-1,52304), -- Necklace of Black Ore Beads
(21545,5230,1,1,-1,3541), -- Recipe: Mithril Arrow (100%)
(21545,57,1073,2176,0,700000), -- Adena
(21545,358,1,1,1,9), -- Blue Wolf Breastplate
(21545,2380,1,1,1,14), -- Blue Wolf Gaiters
(21545,2381,1,1,1,6), -- Doom Plate Armor
(21545,4078,1,1,1,1910), -- Blue Wolf Breastplate Part
(21545,4080,1,1,1,2690), -- Blue Wolf Gaiters Material
(21545,4081,1,1,1,1289), -- Doom Plate Armor Temper
(21545,1343,40,120,2,40021), -- Silver Arrow
(21545,1864,1,3,2,112055), -- Stem
(21545,1865,1,1,2,112055), -- Varnish
(21545,1866,1,1,2,74704), -- Suede
(21545,1868,1,3,2,74704), -- Thread
(21545,1873,1,1,2,44823), -- Silver Nugget
(21545,6339,1,1,2,862), -- Recipe: Sealed Majestic Ring(70%)
(21546,4077,1,1,-1,136297), -- Doom Shield Fragment
(21546,4078,1,1,-1,44258), -- Blue Wolf Breastplate Part
(21546,5458,1,1,-1,1656), -- Recipe: Halberd(60%)
(21546,57,1224,2483,0,700000), -- Adena
(21546,2398,1,1,1,10), -- Blue Wolf Tunic
(21546,2399,1,1,1,10), -- Tunic of Doom
(21546,2403,1,1,1,15), -- Blue Wolf Stockings
(21546,2404,1,1,1,15), -- Stockings of Doom
(21546,4084,1,1,1,1944), -- Blue Wolf Tunic Fabric
(21546,4085,1,1,1,1944), -- Tunic of Doom Pattern
(21546,4086,1,1,1,2625), -- Blue Wolf Stockings Pattern
(21546,4087,1,1,1,2625), -- Stockings of Doom Pattern
(21546,729,1,1,2,17), -- Scroll: Enchant Weapon (Grade A)
(21546,1867,1,3,2,66295), -- Animal Skin
(21546,1869,2,6,2,37291), -- Iron Ore
(21546,1870,2,6,2,29833), -- Coal
(21546,1871,1,1,2,149164), -- Charcoal
(21546,1872,1,3,2,99442), -- Animal Bone
(21547,4085,1,1,-1,43995), -- Tunic of Doom Pattern
(21547,5230,1,1,-1,3375), -- Recipe: Mithril Arrow (100%)
(21547,5271,1,1,-1,3375), -- Recipe: Greater Soulshot (A) Compressed Package(100%)
(21547,57,1024,2074,0,700000), -- Adena
(21547,171,1,1,1,2), -- Deadman\'s Glory
(21547,175,1,1,1,2), -- Art of Battle Axe
(21547,210,1,1,1,2), -- Staff of Evil Spirits
(21547,4116,1,1,1,545), -- Deadman\'s Glory Stone
(21547,4117,1,1,1,545), -- Art of Battle Axe Blade
(21547,4118,1,1,1,517), -- Evil Spirit Head
(21547,1895,1,1,2,42729), -- Metallic Fiber
(21547,4040,1,1,2,2992), -- Mold Lubricant
(21547,4042,1,1,2,2493), -- Enria
(21547,4043,1,1,2,4986), -- Asofe
(21547,5276,1,1,2,200), -- Recipe: Greater Spiritshot (A) Compressed Package(100%)
(21548,4044,1,1,-1,72124), -- Thons
(21548,4086,1,1,-1,50774), -- Blue Wolf Stockings Pattern
(21548,5549,1,1,-1,216373), -- Metallic Thread
(21548,57,875,1772,0,700000), -- Adena
(21548,268,1,1,1,5), -- Bellion Cestus
(21548,4120,1,1,1,1397), -- Bellion Cestus Edge
(21548,1343,10,30,2,114131), -- Silver Arrow
(21548,1868,1,1,2,159784), -- Thread
(21548,1873,1,1,2,31957), -- Silver Nugget
(21548,1889,1,1,2,5327), -- Compound Braid
(21548,4044,1,1,2,2664), -- Thons
(21548,5281,1,1,2,107), -- Recipe: Greater Blessed Spiritshot (A) Compressed Package(100%)
(21548,5549,1,1,2,7990), -- Metallic Thread
(21548,6670,1,1,2,13316), -- Deluxe Chest Key - Grade 6
(21549,4053,1,1,-1,112261), -- Ring of Black Ore Gemstone
(21549,6329,1,1,-1,15052), -- Recipe: Sealed Phoenix Necklace(70%)
(21549,6331,1,1,-1,19993), -- Recipe: Sealed Phoenix Earring(70%)
(21549,57,1061,2145,0,700000), -- Adena
(21549,110,1,1,1,31), -- Doom Shield
(21549,2416,1,1,1,22), -- Blue Wolf Helmet
(21549,2417,1,1,1,22), -- Doom Helmet
(21549,4077,1,1,1,5800), -- Doom Shield Fragment
(21549,4088,1,1,1,4873), -- Blue Wolf Helmet Design
(21549,4089,1,1,1,4873), -- Doom Helmet Pattern
(21549,1864,1,3,2,128938), -- Stem
(21549,1865,1,1,2,128938), -- Varnish
(21549,1866,1,1,2,85959), -- Suede
(21549,1868,1,3,2,85959), -- Thread
(21549,1873,1,1,2,51576), -- Silver Nugget
(21549,3035,1,1,2,171), -- Recipe: Spiritshot A
(21550,4053,1,1,-1,114506), -- Ring of Black Ore Gemstone
(21550,6329,1,1,-1,15353), -- Recipe: Sealed Phoenix Necklace(70%)
(21550,6331,1,1,-1,20393), -- Recipe: Sealed Phoenix Earring(70%)
(21550,57,1082,2188,0,700000), -- Adena
(21550,110,1,1,1,32), -- Doom Shield
(21550,2416,1,1,1,22), -- Blue Wolf Helmet
(21550,2417,1,1,1,22), -- Doom Helmet
(21550,4077,1,1,1,5916), -- Doom Shield Fragment
(21550,4088,1,1,1,4970), -- Blue Wolf Helmet Design
(21550,4089,1,1,1,4970), -- Doom Helmet Pattern
(21550,1864,1,3,2,131517), -- Stem
(21550,1865,1,1,2,131517), -- Varnish
(21550,1866,1,1,2,87678), -- Suede
(21550,1868,1,3,2,87678), -- Thread
(21550,1873,1,1,2,52607), -- Silver Nugget
(21550,3035,1,1,2,175), -- Recipe: Spiritshot A
(21551,1884,1,3,-1,927765), -- Cord
(21551,4080,1,1,-1,62023), -- Blue Wolf Gaiters Material
(21551,5460,1,1,-1,1648), -- Recipe: Dasparion\'s Staff(60%)
(21551,57,1218,2471,0,700000), -- Adena
(21551,601,1,1,1,28), -- Boots of Doom
(21551,2439,1,1,1,28), -- Blue Wolf Boots
(21551,2475,1,1,1,28), -- Doom Gloves
(21551,2487,1,1,1,28), -- Blue Wolf Gloves
(21551,4090,1,1,1,4997), -- Blue Wolf Boots Design
(21551,4091,1,1,1,4997), -- Doom Gloves Part
(21551,4096,1,1,1,4997), -- Blue Wolf Gloves Fabric
(21551,4099,1,1,1,4997), -- Doom Boots Part
(21551,730,1,1,2,106), -- Scroll: Enchant Armor (Grade A)
(21551,1343,10,30,2,181763), -- Silver Arrow
(21551,1874,1,1,2,8483), -- Oriharukon Ore
(21551,1878,1,1,2,50894), -- Braided Hemp
(21551,1884,1,1,2,78298), -- Cord
(21551,1889,1,1,2,8483), -- Compound Braid
(21551,5220,1,1,2,5090), -- Metal Hardener
(21552,1884,1,3,-1,879110), -- Cord
(21552,4080,1,1,-1,58770), -- Blue Wolf Gaiters Material
(21552,5460,1,1,-1,1561), -- Recipe: Dasparion\'s Staff(60%)
(21552,57,1155,2341,0,700000), -- Adena
(21552,601,1,1,1,27), -- Boots of Doom
(21552,2439,1,1,1,27), -- Blue Wolf Boots
(21552,2475,1,1,1,27), -- Doom Gloves
(21552,2487,1,1,1,27), -- Blue Wolf Gloves
(21552,4090,1,1,1,4735), -- Blue Wolf Boots Design
(21552,4091,1,1,1,4735), -- Doom Gloves Part
(21552,4096,1,1,1,4735), -- Blue Wolf Gloves Fabric
(21552,4099,1,1,1,4735), -- Doom Boots Part
(21552,730,1,1,2,101), -- Scroll: Enchant Armor (Grade A)
(21552,1343,10,30,2,172231), -- Silver Arrow
(21552,1874,1,1,2,8038), -- Oriharukon Ore
(21552,1878,1,1,2,48225), -- Braided Hemp
(21552,1884,1,1,2,74192), -- Cord
(21552,1889,1,1,2,8038), -- Compound Braid
(21552,5220,1,1,2,4823), -- Metal Hardener
(21553,1895,1,1,-1,603815), -- Metallic Fiber
(21553,4080,1,1,-1,43471), -- Blue Wolf Gaiters Material
(21553,57,854,1732,0,700000), -- Adena
(21553,601,1,1,1,20), -- Boots of Doom
(21553,2439,1,1,1,20), -- Blue Wolf Boots
(21553,2475,1,1,1,20), -- Doom Gloves
(21553,2487,1,1,1,20), -- Blue Wolf Gloves
(21553,4090,1,1,1,3503), -- Blue Wolf Boots Design
(21553,4091,1,1,1,3503), -- Doom Gloves Part
(21553,4096,1,1,1,3503), -- Blue Wolf Gloves Fabric
(21553,4099,1,1,1,3503), -- Doom Boots Part
(21553,1868,1,1,2,208085), -- Thread
(21553,1873,1,1,2,41617), -- Silver Nugget
(21553,1876,1,1,2,20809), -- Mithril Ore
(21553,1895,1,1,2,29727), -- Metallic Fiber
(21553,4042,1,1,2,1735), -- Enria
(21553,5462,1,1,2,39), -- Recipe: Branch of The Mother Tree(60%)
(21554,1895,1,1,-1,603815), -- Metallic Fiber
(21554,4080,1,1,-1,43471), -- Blue Wolf Gaiters Material
(21554,6329,1,1,-1,12146), -- Recipe: Sealed Phoenix Necklace(70%)
(21554,57,854,1732,0,700000), -- Adena
(21554,601,1,1,1,20), -- Boots of Doom
(21554,2439,1,1,1,20), -- Blue Wolf Boots
(21554,2475,1,1,1,20), -- Doom Gloves
(21554,2487,1,1,1,20), -- Blue Wolf Gloves
(21554,4090,1,1,1,3503), -- Blue Wolf Boots Design
(21554,4091,1,1,1,3503), -- Doom Gloves Part
(21554,4096,1,1,1,3503), -- Blue Wolf Gloves Fabric
(21554,4099,1,1,1,3503), -- Doom Boots Part
(21554,1868,1,1,2,208085), -- Thread
(21554,1873,1,1,2,41617), -- Silver Nugget
(21554,1876,1,1,2,20809), -- Mithril Ore
(21554,1895,1,1,2,29727), -- Metallic Fiber
(21554,4042,1,1,2,1735), -- Enria
(21554,5462,1,1,2,39), -- Recipe: Branch of The Mother Tree(60%)
(21555,4082,1,1,-1,29030), -- Blue Wolf Leather Armor Texture
(21555,4083,1,1,-1,29030), -- Leather Armor of Doom Design
(21555,57,1038,2106,0,700000), -- Adena
(21555,268,1,1,1,6), -- Bellion Cestus
(21555,4120,1,1,1,1659), -- Bellion Cestus Edge
(21555,1867,1,1,2,168643), -- Animal Skin
(21555,1872,1,1,2,168643), -- Animal Bone
(21555,1875,1,1,2,8432), -- Stone of Purity
(21555,1881,1,1,2,16865), -- Coarse Bone Powder
(21555,4041,1,1,2,1100), -- Mold Hardener
(21555,5466,1,1,2,47), -- Recipe: Sword of Miracles(60%)
(21556,4082,1,1,-1,28328), -- Blue Wolf Leather Armor Texture
(21556,4083,1,1,-1,28328), -- Leather Armor of Doom Design
(21556,57,1013,2055,0,700000), -- Adena
(21556,268,1,1,1,6), -- Bellion Cestus
(21556,4120,1,1,1,1618), -- Bellion Cestus Edge
(21556,1867,1,1,2,164564), -- Animal Skin
(21556,1872,1,1,2,164564), -- Animal Bone
(21556,1875,1,1,2,8228), -- Stone of Purity
(21556,1881,1,1,2,16457), -- Coarse Bone Powder
(21556,4041,1,1,2,1074), -- Mold Hardener
(21556,5466,1,1,2,46), -- Recipe: Sword of Miracles(60%)
(21557,4082,1,1,-1,33514), -- Blue Wolf Leather Armor Texture
(21557,4083,1,1,-1,33514), -- Leather Armor of Doom Design
(21557,5470,1,1,-1,1621), -- Recipe: Tallum Blade(60%)
(21557,57,1199,2431,0,700000), -- Adena
(21557,358,1,1,1,10), -- Blue Wolf Breastplate
(21557,2380,1,1,1,15), -- Blue Wolf Gaiters
(21557,2381,1,1,1,7), -- Doom Plate Armor
(21557,4078,1,1,1,2134), -- Blue Wolf Breastplate Part
(21557,4080,1,1,1,3004), -- Blue Wolf Gaiters Material
(21557,4081,1,1,1,1440), -- Doom Plate Armor Temper
(21557,1343,10,30,2,178797), -- Silver Arrow
(21557,1876,1,1,2,25032), -- Mithril Ore
(21557,1877,1,1,2,5007), -- Adamantite Nugget
(21557,1880,1,1,2,12516), -- Steel
(21557,1881,1,1,2,16688), -- Coarse Bone Powder
(21557,1882,1,1,2,27813), -- Leather
(21557,5440,1,1,2,47), -- Recipe: Elysian(60%)
(21558,4082,1,1,-1,33514), -- Blue Wolf Leather Armor Texture
(21558,4083,1,1,-1,33514), -- Leather Armor of Doom Design
(21558,5470,1,1,-1,1621), -- Recipe: Tallum Blade(60%)
(21558,57,1199,2431,0,700000), -- Adena
(21558,358,1,1,1,10), -- Blue Wolf Breastplate
(21558,2380,1,1,1,15), -- Blue Wolf Gaiters
(21558,2381,1,1,1,7), -- Doom Plate Armor
(21558,4078,1,1,1,2134), -- Blue Wolf Breastplate Part
(21558,4080,1,1,1,3004), -- Blue Wolf Gaiters Material
(21558,4081,1,1,1,1440), -- Doom Plate Armor Temper
(21558,1343,10,30,2,178797), -- Silver Arrow
(21558,1876,1,1,2,25032), -- Mithril Ore
(21558,1877,1,1,2,5007), -- Adamantite Nugget
(21558,1880,1,1,2,12516), -- Steel
(21558,1881,1,1,2,16688), -- Coarse Bone Powder
(21558,1882,1,1,2,27813), -- Leather
(21558,5440,1,1,2,47), -- Recipe: Elysian(60%)
(21559,4085,1,1,-1,56374), -- Tunic of Doom Pattern
(21559,6329,1,1,-1,18642), -- Recipe: Sealed Phoenix Necklace(70%)
(21559,6331,1,1,-1,24761), -- Recipe: Sealed Phoenix Earring(70%)
(21559,57,1311,2658,0,700000), -- Adena
(21559,601,1,1,1,30), -- Boots of Doom
(21559,2439,1,1,1,30), -- Blue Wolf Boots
(21559,2475,1,1,1,30), -- Doom Gloves
(21559,2487,1,1,1,30), -- Blue Wolf Gloves
(21559,4090,1,1,1,5376), -- Blue Wolf Boots Design
(21559,4091,1,1,1,5376), -- Doom Gloves Part
(21559,4096,1,1,1,5376), -- Blue Wolf Gloves Fabric
(21559,4099,1,1,1,5376), -- Doom Boots Part
(21559,1343,30,90,2,65180), -- Silver Arrow
(21559,1864,1,3,2,136879), -- Stem
(21559,1869,1,1,2,136879), -- Iron Ore
(21559,1878,1,1,2,54752), -- Braided Hemp
(21559,1884,1,1,2,84233), -- Cord
(21559,4039,1,1,2,4563), -- Mold Glue
(21559,5448,1,1,2,51), -- Recipe: Soul Separator(60%)
(21560,1875,1,1,-1,216249), -- Stone of Purity
(21560,4040,1,1,-1,64875), -- Mold Lubricant
(21560,4086,1,1,-1,76117), -- Blue Wolf Stockings Pattern
(21560,57,1311,2658,0,700000), -- Adena
(21560,2398,1,1,1,10), -- Blue Wolf Tunic
(21560,2399,1,1,1,10), -- Tunic of Doom
(21560,2403,1,1,1,16), -- Blue Wolf Stockings
(21560,2404,1,1,1,16), -- Stockings of Doom
(21560,4084,1,1,1,2081), -- Blue Wolf Tunic Fabric
(21560,4085,1,1,1,2081), -- Tunic of Doom Pattern
(21560,4086,1,1,1,2810), -- Blue Wolf Stockings Pattern
(21560,4087,1,1,1,2810), -- Stockings of Doom Pattern
(21560,1865,1,1,2,159692), -- Varnish
(21560,1870,1,1,2,159692), -- Coal
(21560,1875,1,1,2,10647), -- Stone of Purity
(21560,1879,1,1,2,26616), -- Cokes
(21560,4040,1,1,2,3194), -- Mold Lubricant
(21560,5450,1,1,2,60), -- Recipe: Dragon Grinder(60%)
(21561,3956,1,1,-1,3641), -- Recipe: Blessed Spiritshot A
(21561,4116,1,1,-1,11932), -- Deadman\'s Glory Stone
(21561,4117,1,1,-1,11932), -- Art of Battle Axe Blade
(21561,57,1098,2244,0,700000), -- Adena
(21561,358,1,1,1,9), -- Blue Wolf Breastplate
(21561,2380,1,1,1,14), -- Blue Wolf Gaiters
(21561,2381,1,1,1,6), -- Doom Plate Armor
(21561,4078,1,1,1,1964), -- Blue Wolf Breastplate Part
(21561,4080,1,1,1,2766), -- Blue Wolf Gaiters Material
(21561,4081,1,1,1,1325), -- Doom Plate Armor Temper
(21561,1343,10,30,2,144029), -- Silver Arrow
(21561,1865,1,1,2,100821), -- Varnish
(21561,1870,1,1,2,100821), -- Coal
(21561,1875,1,1,2,6722), -- Stone of Purity
(21561,1879,1,1,2,16804), -- Cokes
(21561,4040,1,1,2,2017), -- Mold Lubricant
(21561,5456,1,1,2,38), -- Recipe: Tallum Glaive(60%)
(21561,6670,1,1,2,16804), -- Deluxe Chest Key - Grade 6
(21562,4118,1,1,-1,11706), -- Evil Spirit Head
(21562,5156,1,1,-1,3770), -- Recipe: Soulshot (A) Compressed Package (100%)
(21562,5220,1,1,-1,113103), -- Metal Hardener
(21562,57,1137,2324,0,700000), -- Adena
(21562,2398,1,1,1,9), -- Blue Wolf Tunic
(21562,2399,1,1,1,9), -- Tunic of Doom
(21562,2403,1,1,1,14), -- Blue Wolf Stockings
(21562,2404,1,1,1,14), -- Stockings of Doom
(21562,4084,1,1,1,1814), -- Blue Wolf Tunic Fabric
(21562,4085,1,1,1,1814), -- Tunic of Doom Pattern
(21562,4086,1,1,1,2449), -- Blue Wolf Stockings Pattern
(21562,4087,1,1,1,2449), -- Stockings of Doom Pattern
(21562,1866,1,1,2,92803), -- Suede
(21562,1871,1,1,2,139204), -- Charcoal
(21562,1885,1,1,2,11601), -- High Grade Suede
(21562,4041,1,1,2,1211), -- Mold Hardener
(21562,5220,1,1,2,5569), -- Metal Hardener
(21562,5462,1,1,2,52), -- Recipe: Branch of The Mother Tree(60%)
(21563,4042,1,1,-1,54757), -- Enria
(21563,4119,1,1,-1,14381), -- Demon\'s Sword Edge
(21563,5161,1,1,-1,4381), -- Recipe: Spiritshot (A) Compressed Package (100%)
(21563,57,1321,2700,0,700000), -- Adena
(21563,358,1,1,1,11), -- Blue Wolf Breastplate
(21563,2380,1,1,1,17), -- Blue Wolf Gaiters
(21563,2381,1,1,1,7), -- Doom Plate Armor
(21563,4078,1,1,1,2363), -- Blue Wolf Breastplate Part
(21563,4080,1,1,1,3328), -- Blue Wolf Gaiters Material
(21563,4081,1,1,1,1595), -- Doom Plate Armor Temper
(21563,1343,20,60,2,99028), -- Silver Arrow
(21563,1867,1,3,2,61617), -- Animal Skin
(21563,1872,1,1,2,184851), -- Animal Bone
(21563,1882,1,1,2,30809), -- Leather
(21563,1894,1,1,2,4865), -- Crafted Leather
(21563,4042,1,1,2,2311), -- Enria
(21563,5464,1,1,2,52), -- Recipe: Dark Legion\'s Edge(60%)
(21564,4120,1,1,-1,13658), -- Bellion Cestus Edge
(21564,4121,1,1,-1,13612), -- Bow of Peril Shaft
(21564,5166,1,1,-1,4167), -- Recipe: Blessed Spiritshot (A) Compressed Package (100%)
(21564,57,1257,2568,0,700000), -- Adena
(21564,2391,1,1,1,14), -- Blue Wolf Leather Armor
(21564,2392,1,1,1,14), -- Leather Armor of Doom
(21564,4082,1,1,1,2608), -- Blue Wolf Leather Armor Texture
(21564,4083,1,1,1,2608), -- Leather Armor of Doom Design
(21564,1868,1,1,2,307739), -- Thread
(21564,1873,1,1,2,61548), -- Silver Nugget
(21564,1889,1,1,2,10258), -- Compound Braid
(21564,4044,1,1,2,5130), -- Thons
(21564,5466,1,1,2,58), -- Recipe: Sword of Miracles(60%)
(21564,5549,1,1,2,15387), -- Metallic Thread
(21565,5464,1,1,-1,1173), -- Recipe: Dark Legion\'s Edge(60%)
(21565,5520,1,1,-1,20416), -- Sealed Dark Crystal Breastplate Pattern
(21565,5521,1,1,-1,14406), -- Sealed Tallum Plate Armor Pattern
(21565,57,1277,2597,0,700000), -- Adena
(21565,98,1,1,1,6), -- Halberd
(21565,5542,1,1,1,1577), -- Halberd Edge
(21565,1867,1,1,2,207821), -- Animal Skin
(21565,1872,1,1,2,207821), -- Animal Bone
(21565,1882,1,1,2,34637), -- Leather
(21565,1894,1,1,2,5469), -- Crafted Leather
(21565,4042,1,1,2,2598), -- Enria
(21565,5464,1,1,2,59), -- Recipe: Dark Legion\'s Edge(60%)
(21566,729,1,1,-1,385), -- Scroll: Enchant Weapon (Grade A)
(21566,4044,1,1,-1,115417), -- Thons
(21566,5549,1,1,-1,346250), -- Metallic Thread
(21566,57,1397,2840,0,700000), -- Adena
(21566,288,1,1,1,6), -- Carnage Bow
(21566,5535,1,1,1,1745), -- Carnage Bow Stave
(21566,1343,10,30,2,208729), -- Silver Arrow
(21566,1868,1,3,2,146110), -- Thread
(21566,1873,1,1,2,58444), -- Silver Nugget
(21566,1889,1,1,2,9741), -- Compound Braid
(21566,4044,1,1,2,4871), -- Thons
(21566,5466,1,1,2,54), -- Recipe: Sword of Miracles(60%)
(21566,5549,1,1,2,14612), -- Metallic Thread
(21567,5466,1,1,-1,1533), -- Recipe: Sword of Miracles(60%)
(21567,5524,1,1,-1,40791), -- Sealed Dark Crystal Gaiters Pattern
(21567,5525,1,1,-1,63977), -- Sealed Dark Crystal Helmet Design
(21567,57,1670,3395,0,700000), -- Adena
(21567,235,1,1,1,7), -- Bloody Orchid
(21567,5536,1,1,1,2080), -- Bloody Orchid Head
(21567,1864,1,3,2,203751), -- Stem
(21567,1869,1,1,2,203751), -- Iron Ore
(21567,1880,1,1,2,20376), -- Steel
(21567,4043,1,1,2,6792), -- Asofe
(21567,5550,1,1,2,2717), -- Durable Metal Plate
(21567,6335,1,1,2,784), -- Recipe: Sealed Majestic Necklace(70%)
(21568,730,1,1,-1,2722), -- Scroll: Enchant Armor (Grade A)
(21568,5526,1,1,-1,50497), -- Sealed Tallum Helm Design
(21568,6335,1,1,-1,12564), -- Recipe: Sealed Majestic Necklace(70%)
(21568,57,1318,2679,0,700000), -- Adena
(21568,235,1,1,1,6), -- Bloody Orchid
(21568,5536,1,1,1,1642), -- Bloody Orchid Head
(21568,1343,10,30,2,196922), -- Silver Arrow
(21568,1865,1,1,2,137846), -- Varnish
(21568,1870,1,1,2,137846), -- Coal
(21568,1874,1,1,2,9190), -- Oriharukon Ore
(21568,4039,1,1,2,4595), -- Mold Glue
(21568,4043,1,1,2,4595), -- Asofe
(21568,6337,1,1,2,708), -- Recipe: Sealed Majestic Earring(70%)
(21569,730,1,1,-1,2062), -- Scroll: Enchant Armor (Grade A)
(21569,5526,1,1,-1,38242), -- Sealed Tallum Helm Design
(21569,6335,1,1,-1,9515), -- Recipe: Sealed Majestic Necklace(70%)
(21569,57,998,2029,0,700000), -- Adena
(21569,235,1,1,1,4), -- Bloody Orchid
(21569,5536,1,1,1,1244), -- Bloody Orchid Head
(21569,1343,10,30,2,149132), -- Silver Arrow
(21569,1865,1,1,2,104393), -- Varnish
(21569,1870,1,1,2,104393), -- Coal
(21569,1874,1,1,2,6960), -- Oriharukon Ore
(21569,4039,1,1,2,3480), -- Mold Glue
(21569,4043,1,1,2,3480), -- Asofe
(21569,6337,1,1,2,536), -- Recipe: Sealed Majestic Earring(70%)
(21570,5464,1,1,-1,954), -- Recipe: Dark Legion\'s Edge(60%)
(21570,5542,1,1,-1,8684), -- Halberd Edge
(21570,5543,1,1,-1,8766), -- Dasparion\'s Staff Edge
(21570,57,1040,2111,0,700000), -- Adena
(21570,269,1,1,1,5), -- Blood Tornado
(21570,5539,1,1,1,1283), -- Blood Tornado Edge
(21570,1867,1,1,2,169034), -- Animal Skin
(21570,1872,1,1,2,169034), -- Animal Bone
(21570,1875,1,1,2,8452), -- Stone of Purity
(21570,1881,1,1,2,16904), -- Coarse Bone Powder
(21570,4041,1,1,2,1103), -- Mold Hardener
(21570,6339,1,1,2,976), -- Recipe: Sealed Majestic Ring(70%)
(21571,729,1,1,-1,377), -- Scroll: Enchant Weapon (Grade A)
(21571,4042,1,1,-1,56507), -- Enria
(21571,4043,1,1,-1,113015), -- Asofe
(21571,57,1369,2780,0,700000), -- Adena
(21571,288,1,1,1,6), -- Carnage Bow
(21571,5535,1,1,1,1709), -- Carnage Bow Stave
(21571,729,1,1,2,19), -- Scroll: Enchant Weapon (Grade A)
(21571,1343,10,30,2,238450), -- Silver Arrow
(21571,1895,1,1,2,47690), -- Metallic Fiber
(21571,4040,1,1,2,3339), -- Mold Lubricant
(21571,4042,1,1,2,2782), -- Enria
(21571,4043,1,1,2,5564), -- Asofe
(21572,5466,1,1,-1,1298), -- Recipe: Sword of Miracles(60%)
(21572,5547,1,1,-1,11921), -- Elemental Sword Edge
(21572,5548,1,1,-1,11921), -- Tallum Blade Edge
(21572,57,1415,2873,0,700000), -- Adena
(21572,235,1,1,1,6), -- Bloody Orchid
(21572,5536,1,1,1,1761), -- Bloody Orchid Head
(21572,730,1,1,2,145), -- Scroll: Enchant Armor (Grade A)
(21572,1868,1,1,2,344990), -- Thread
(21572,1873,1,1,2,68998), -- Silver Nugget
(21572,1889,1,1,2,11500), -- Compound Braid
(21572,4044,1,1,2,5750), -- Thons
(21572,5549,1,1,2,17250), -- Metallic Thread
(21573,730,1,1,-1,3010), -- Scroll: Enchant Armor (Grade A)
(21573,6335,1,1,-1,13894), -- Recipe: Sealed Majestic Necklace(70%)
(21573,6341,1,1,-1,99914), -- Sealed Phoenix Earring Gemstone
(21573,57,1458,2962,0,700000), -- Adena
(21573,5289,1,1,1,21), -- Sealed Dark Crystal Helmet
(21573,5292,1,1,1,30), -- Sealed Dark Crystal Shield
(21573,5294,1,1,1,21), -- Sealed Tallum Helmet
(21573,5494,1,1,1,3735), -- Sealed Dark Crystal Shield Fragment
(21573,5525,1,1,1,2750), -- Sealed Dark Crystal Helmet Design
(21573,5526,1,1,1,2750), -- Sealed Tallum Helm Design
(21573,1343,30,90,2,72588), -- Silver Arrow
(21573,1868,1,3,2,152435), -- Thread
(21573,1873,1,1,2,60974), -- Silver Nugget
(21573,1876,1,1,2,30487), -- Mithril Ore
(21573,1895,1,1,2,43553), -- Metallic Fiber
(21573,4042,1,1,2,2541), -- Enria
(21573,5434,1,1,2,57), -- Recipe: Dragon Slayer(60%)
(21574,729,1,1,-1,490), -- Scroll: Enchant Weapon (Grade A)
(21574,5448,1,1,-1,1634), -- Recipe: Soul Separator(60%)
(21574,5494,1,1,-1,92661), -- Sealed Dark Crystal Shield Fragment
(21574,57,1780,3621,0,700000), -- Adena
(21574,98,1,1,1,8), -- Halberd
(21574,5542,1,1,1,2198), -- Halberd Edge
(21574,1343,30,90,2,88658), -- Silver Arrow
(21574,1868,1,3,2,186180), -- Thread
(21574,1873,1,1,2,74472), -- Silver Nugget
(21574,1889,1,1,2,12412), -- Compound Braid
(21574,4044,1,1,2,6206), -- Thons
(21574,5466,1,1,2,69), -- Recipe: Sword of Miracles(60%)
(21574,5549,1,1,2,18619), -- Metallic Thread
(21575,729,1,1,-1,276), -- Scroll: Enchant Weapon (Grade A)
(21575,5448,1,1,-1,921), -- Recipe: Soul Separator(60%)
(21575,5494,1,1,-1,52203), -- Sealed Dark Crystal Shield Fragment
(21575,57,1003,2040,0,700000), -- Adena
(21575,98,1,1,1,5), -- Halberd
(21575,5542,1,1,1,1238), -- Halberd Edge
(21575,1343,10,30,2,149843), -- Silver Arrow
(21575,1868,1,1,2,209780), -- Thread
(21575,1873,1,1,2,41957), -- Silver Nugget
(21575,1889,1,1,2,6993), -- Compound Braid
(21575,4044,1,1,2,3497), -- Thons
(21575,5466,1,1,2,39), -- Recipe: Sword of Miracles(60%)
(21575,5549,1,1,2,10489), -- Metallic Thread
(21576,5450,1,1,-1,1075), -- Recipe: Dragon Grinder(60%)
(21576,5456,1,1,-1,1075), -- Recipe: Tallum Glaive(60%)
(21576,5497,1,1,-1,68051), -- Sealed Tallum Boots Lining
(21576,57,1171,2382,0,700000), -- Adena
(21576,235,1,1,1,5), -- Bloody Orchid
(21576,5536,1,1,1,1459), -- Bloody Orchid Head
(21576,1343,10,30,2,174964), -- Silver Arrow
(21576,1868,1,3,2,122475), -- Thread
(21576,1873,1,1,2,48990), -- Silver Nugget
(21576,1876,1,1,2,24496), -- Mithril Ore
(21576,1895,1,1,2,34993), -- Metallic Fiber
(21576,4042,1,1,2,2042), -- Enria
(21576,6337,1,1,2,628), -- Recipe: Sealed Majestic Earring(70%)
(21577,5450,1,1,-1,1038), -- Recipe: Dragon Grinder(60%)
(21577,5456,1,1,-1,1038), -- Recipe: Tallum Glaive(60%)
(21577,5497,1,1,-1,65708), -- Sealed Tallum Boots Lining
(21577,57,1130,2300,0,700000), -- Adena
(21577,235,1,1,1,5), -- Bloody Orchid
(21577,5536,1,1,1,1409), -- Bloody Orchid Head
(21577,1343,10,30,2,168941), -- Silver Arrow
(21577,1868,1,3,2,118259), -- Thread
(21577,1873,1,1,2,47304), -- Silver Nugget
(21577,1876,1,1,2,23652), -- Mithril Ore
(21577,1895,1,1,2,33789), -- Metallic Fiber
(21577,4042,1,1,2,1972), -- Enria
(21577,6337,1,1,2,607), -- Recipe: Sealed Majestic Earring(70%)
(21578,5464,1,1,-1,1217), -- Recipe: Dark Legion\'s Edge(60%)
(21578,5482,1,1,-1,43386), -- Sealed Dark Crystalline Leggings Design
(21578,5485,1,1,-1,27641), -- Sealed Tallum Tunic Texture
(21578,57,1324,2698,0,700000), -- Adena
(21578,269,1,1,1,6), -- Blood Tornado
(21578,5539,1,1,1,1638), -- Blood Tornado Edge
(21578,1344,10,30,2,173387), -- Mithril Arrow
(21578,1866,1,1,2,92473), -- Suede
(21578,1871,1,1,2,138709), -- Charcoal
(21578,1877,1,1,2,5549), -- Adamantite Nugget
(21578,4040,1,1,2,2775), -- Mold Lubricant
(21578,4041,1,1,2,1207), -- Mold Hardener
(21578,5277,1,1,2,62), -- Recipe: Greater Spiritshot (S) Compressed Package(100%)
(21579,729,1,1,-1,381), -- Scroll: Enchant Weapon (Grade A)
(21579,1876,1,1,-1,686571), -- Mithril Ore
(21579,4042,1,1,-1,57214), -- Enria
(21579,57,1382,2818,0,700000), -- Adena
(21579,288,1,1,1,6), -- Carnage Bow
(21579,5535,1,1,1,1730), -- Carnage Bow Stave
(21579,1868,1,1,2,338004), -- Thread
(21579,1873,1,1,2,67601), -- Silver Nugget
(21579,1876,1,1,2,33801), -- Mithril Ore
(21579,1895,1,1,2,48287), -- Metallic Fiber
(21579,4042,1,1,2,2817), -- Enria
(21579,5282,1,1,2,76), -- Recipe: Greater Blessed Spiritshot (S) Compressed Package(100%)
(21580,5466,1,1,-1,1289), -- Recipe: Sword of Miracles(60%)
(21580,5486,1,1,-1,20595), -- Sealed Dark Crystal Robe Fabric
(21580,5489,1,1,-1,45940), -- Sealed Tallum Stockings Fabric
(21580,57,1402,2857,0,700000), -- Adena
(21580,235,1,1,1,6), -- Bloody Orchid
(21580,5536,1,1,1,1750), -- Bloody Orchid Head
(21580,1344,10,30,2,160644), -- Mithril Arrow
(21580,1868,1,3,2,128515), -- Thread
(21580,1873,1,1,2,51407), -- Silver Nugget
(21580,1876,1,1,2,25703), -- Mithril Ore
(21580,1895,1,1,2,36719), -- Metallic Fiber
(21580,4042,1,1,2,2142), -- Enria
(21580,6671,1,1,2,14280), -- Deluxe Chest Key - Grade 7
(21580,6901,1,1,2,129), -- Recipe: Shining Arrow (100%)
(21581,730,1,1,-1,3172), -- Scroll: Enchant Armor (Grade A)
(21581,5494,1,1,-1,79945), -- Sealed Dark Crystal Shield Fragment
(21581,6335,1,1,-1,14641), -- Recipe: Sealed Majestic Necklace(70%)
(21581,57,1533,3125,0,700000), -- Adena
(21581,269,1,1,1,7), -- Blood Tornado
(21581,5539,1,1,1,1896), -- Blood Tornado Edge
(21581,1808,1,1,2,84), -- Recipe: Soulshot: S Grade
(21581,1865,1,1,2,187401), -- Varnish
(21581,1870,1,1,2,187401), -- Coal
(21581,1875,1,1,2,12494), -- Stone of Purity
(21581,1879,1,1,2,31234), -- Cokes
(21581,4040,1,1,2,3749), -- Mold Lubricant
(21582,4041,1,1,-1,32801), -- Mold Hardener
(21582,5220,1,1,-1,150885), -- Metal Hardener
(21582,5496,1,1,-1,88444), -- Sealed Dark Crystal Boots Lining
(21582,57,1519,3096,0,700000), -- Adena
(21582,288,1,1,1,7), -- Carnage Bow
(21582,5535,1,1,1,1901), -- Carnage Bow Stave
(21582,1344,10,30,2,198970), -- Mithril Arrow
(21582,1866,1,1,2,106118), -- Suede
(21582,1871,1,1,2,159176), -- Charcoal
(21582,1885,1,1,2,13265), -- High Grade Suede
(21582,3036,1,1,2,71), -- Recipe: Spiritshot S
(21582,4041,1,1,2,1385), -- Mold Hardener
(21582,5220,1,1,2,6367), -- Metal Hardener
(21583,1884,1,5,-1,789121), -- Cord
(21583,4039,1,1,-1,128232), -- Mold Glue
(21583,5532,1,1,-1,12973), -- Meteor Shower Head
(21583,57,1548,3160,0,700000), -- Adena
(21583,212,1,1,1,4), -- Dasparion\'s Staff
(21583,2504,1,1,1,4), -- Meteor Shower
(21583,5532,1,1,1,958), -- Meteor Shower Head
(21583,5543,1,1,1,967), -- Dasparion\'s Staff Edge
(21583,1344,30,90,2,67640), -- Mithril Arrow
(21583,1864,4,12,2,40584), -- Stem
(21583,1869,1,1,2,162334), -- Iron Ore
(21583,1878,1,1,2,64934), -- Braided Hemp
(21583,1884,1,1,2,99898), -- Cord
(21583,4039,1,1,2,5412), -- Mold Glue
(21583,6901,1,1,2,163), -- Recipe: Shining Arrow (100%)
(21584,1884,1,5,-1,735982), -- Cord
(21584,4039,1,1,-1,119597), -- Mold Glue
(21584,5532,1,1,-1,12099), -- Meteor Shower Head
(21584,57,1444,2948,0,700000), -- Adena
(21584,212,1,1,1,3), -- Dasparion\'s Staff
(21584,2504,1,1,1,3), -- Meteor Shower
(21584,5532,1,1,1,894), -- Meteor Shower Head
(21584,5543,1,1,1,902), -- Dasparion\'s Staff Edge
(21584,1344,30,90,2,63085), -- Mithril Arrow
(21584,1864,4,12,2,37851), -- Stem
(21584,1869,1,1,2,151402), -- Iron Ore
(21584,1878,1,1,2,60561), -- Braided Hemp
(21584,1884,1,1,2,93171), -- Cord
(21584,4039,1,1,2,5047), -- Mold Glue
(21584,6901,1,1,2,152), -- Recipe: Shining Arrow (100%)
(21585,730,1,1,-1,2490), -- Scroll: Enchant Armor (Grade A)
(21585,1876,1,1,-1,597702), -- Mithril Ore
(21585,5536,1,1,-1,10168), -- Bloody Orchid Head
(21585,57,1202,2455,0,700000), -- Adena
(21585,288,1,1,1,5), -- Carnage Bow
(21585,5535,1,1,1,1507), -- Carnage Bow Stave
(21585,1344,10,30,2,157637), -- Mithril Arrow
(21585,1868,1,3,2,126109), -- Thread
(21585,1873,1,1,2,50444), -- Silver Nugget
(21585,1876,1,1,2,25222), -- Mithril Ore
(21585,1895,1,1,2,36032), -- Metallic Fiber
(21585,3036,1,1,2,57), -- Recipe: Spiritshot S
(21585,4042,1,1,2,2102), -- Enria
(21586,1895,1,3,-1,512618), -- Metallic Fiber
(21586,5462,1,1,-1,1329), -- Recipe: Branch of The Mother Tree(60%)
(21586,5539,1,1,-1,12101), -- Blood Tornado Edge
(21586,57,1444,2948,0,700000), -- Adena
(21586,235,1,1,1,6), -- Bloody Orchid
(21586,5536,1,1,1,1804), -- Bloody Orchid Head
(21586,1868,1,3,2,176656), -- Thread
(21586,1873,1,1,2,70663), -- Silver Nugget
(21586,1876,1,1,2,35332), -- Mithril Ore
(21586,1895,1,1,2,50474), -- Metallic Fiber
(21586,3957,1,1,2,79), -- Recipe: Blessed Spiritshot S
(21586,4042,1,1,2,2945), -- Enria
(21587,5464,1,1,-1,1392), -- Recipe: Dark Legion\'s Edge(60%)
(21587,5542,1,1,-1,12676), -- Halberd Edge
(21587,5543,1,1,-1,12795), -- Dasparion\'s Staff Edge
(21587,57,1512,3088,0,700000), -- Adena
(21587,269,1,1,1,7), -- Blood Tornado
(21587,5539,1,1,1,1872), -- Blood Tornado Edge
(21587,1344,20,60,2,99136), -- Mithril Arrow
(21587,1865,1,1,2,158617), -- Varnish
(21587,1870,1,1,2,158617), -- Coal
(21587,1875,1,1,2,10575), -- Stone of Purity
(21587,1879,1,1,2,26437), -- Cokes
(21587,4040,1,1,2,3173), -- Mold Lubricant
(21587,5157,1,1,2,71), -- Recipe: Soulshot (S) Compressed Package (100%)
(21588,729,1,1,-1,345), -- Scroll: Enchant Weapon (Grade A)
(21588,4042,1,1,-1,51677), -- Enria
(21588,5478,1,1,-1,26073), -- Sealed Dark Crystal Leather Armor Pattern
(21588,57,1250,2544,0,700000), -- Adena
(21588,80,1,1,1,3), -- Tallum Blade
(21588,150,1,1,1,3), -- Elemental Sword
(21588,5547,1,1,1,779), -- Elemental Sword Edge
(21588,5548,1,1,1,779), -- Tallum Blade Edge
(21588,1344,10,30,2,163550), -- Mithril Arrow
(21588,1868,1,3,2,130840), -- Thread
(21588,1873,1,1,2,52336), -- Silver Nugget
(21588,1876,1,1,2,26168), -- Mithril Ore
(21588,1895,1,1,2,37383), -- Metallic Fiber
(21588,4042,1,1,2,2181), -- Enria
(21588,6901,1,1,2,131), -- Recipe: Shining Arrow (100%)
(21589,729,1,1,-1,353), -- Scroll: Enchant Weapon (Grade A)
(21589,4042,1,1,-1,53012), -- Enria
(21589,5478,1,1,-1,26747), -- Sealed Dark Crystal Leather Armor Pattern
(21589,57,1282,2610,0,700000), -- Adena
(21589,80,1,1,1,3), -- Tallum Blade
(21589,150,1,1,1,3), -- Elemental Sword
(21589,5547,1,1,1,799), -- Elemental Sword Edge
(21589,5548,1,1,1,799), -- Tallum Blade Edge
(21589,1344,10,30,2,167776), -- Mithril Arrow
(21589,1868,1,3,2,134221), -- Thread
(21589,1873,1,1,2,53689), -- Silver Nugget
(21589,1876,1,1,2,26845), -- Mithril Ore
(21589,1895,1,1,2,38349), -- Metallic Fiber
(21589,4042,1,1,2,2237), -- Enria
(21589,6901,1,1,2,135), -- Recipe: Shining Arrow (100%)
(21590,5440,1,1,-1,1148), -- Recipe: Elysian(60%)
(21590,5482,1,1,-1,40924), -- Sealed Dark Crystalline Leggings Design
(21590,5485,1,1,-1,26073), -- Sealed Tallum Tunic Texture
(21590,57,1250,2544,0,700000), -- Adena
(21590,269,1,1,1,6), -- Blood Tornado
(21590,5539,1,1,1,1544), -- Blood Tornado Edge
(21590,1344,30,90,2,54517), -- Mithril Arrow
(21590,1864,1,3,2,130840), -- Stem
(21590,1869,1,1,2,130840), -- Iron Ore
(21590,1878,1,1,2,52336), -- Braided Hemp
(21590,1884,1,1,2,80517), -- Cord
(21590,3036,1,1,2,59), -- Recipe: Spiritshot S
(21590,4039,1,1,2,4362), -- Mold Glue
(21591,5440,1,1,-1,1343), -- Recipe: Elysian(60%)
(21591,5482,1,1,-1,47868), -- Sealed Dark Crystalline Leggings Design
(21591,5485,1,1,-1,30497), -- Sealed Tallum Tunic Texture
(21591,57,1462,2976,0,700000), -- Adena
(21591,269,1,1,1,6), -- Blood Tornado
(21591,5539,1,1,1,1807), -- Blood Tornado Edge
(21591,1344,30,90,2,63766), -- Mithril Arrow
(21591,1864,4,12,2,38260), -- Stem
(21591,1869,1,1,2,153040), -- Iron Ore
(21591,1878,1,1,2,61217), -- Braided Hemp
(21591,1884,1,1,2,94179), -- Cord
(21591,3036,1,1,2,69), -- Recipe: Spiritshot S
(21591,4039,1,1,2,5102), -- Mold Glue
(21592,5440,1,1,-1,989), -- Recipe: Elysian(60%)
(21592,5482,1,1,-1,35249), -- Sealed Dark Crystalline Leggings Design
(21592,5485,1,1,-1,22457), -- Sealed Tallum Tunic Texture
(21592,57,1076,2191,0,700000), -- Adena
(21592,269,1,1,1,5), -- Blood Tornado
(21592,5539,1,1,1,1331), -- Blood Tornado Edge
(21592,1344,10,30,2,140871), -- Mithril Arrow
(21592,1864,1,3,2,112696), -- Stem
(21592,1869,1,1,2,112696), -- Iron Ore
(21592,1878,1,1,2,45078), -- Braided Hemp
(21592,1884,1,1,2,69352), -- Cord
(21592,3036,1,1,2,50), -- Recipe: Spiritshot S
(21592,4039,1,1,2,3757), -- Mold Glue
(21593,729,1,1,-1,475), -- Scroll: Enchant Weapon (Grade A)
(21593,5448,1,1,-1,1584), -- Recipe: Soul Separator(60%)
(21593,5494,1,1,-1,89797), -- Sealed Dark Crystal Shield Fragment
(21593,57,1723,3508,0,700000), -- Adena
(21593,269,1,1,1,7), -- Blood Tornado
(21593,5539,1,1,1,2131), -- Blood Tornado Edge
(21593,1868,1,3,2,210496), -- Thread
(21593,1873,1,1,2,84199), -- Silver Nugget
(21593,1876,1,1,2,42100), -- Mithril Ore
(21593,1895,1,1,2,60142), -- Metallic Fiber
(21593,4042,1,1,2,3509), -- Enria
(21593,5162,1,1,2,94), -- Recipe: Spiritshot (S) Compressed Package (100%)
(21594,729,1,1,-1,445), -- Scroll: Enchant Weapon (Grade A)
(21594,5448,1,1,-1,1485), -- Recipe: Soul Separator(60%)
(21594,5494,1,1,-1,84188), -- Sealed Dark Crystal Shield Fragment
(21594,57,1615,3289,0,700000), -- Adena
(21594,269,1,1,1,7), -- Blood Tornado
(21594,5539,1,1,1,1997), -- Blood Tornado Edge
(21594,1868,1,3,2,197348), -- Thread
(21594,1873,1,1,2,78940), -- Silver Nugget
(21594,1876,1,1,2,39470), -- Mithril Ore
(21594,1895,1,1,2,56386), -- Metallic Fiber
(21594,4042,1,1,2,3290), -- Enria
(21594,5162,1,1,2,88), -- Recipe: Spiritshot (S) Compressed Package (100%)
(21595,729,1,1,-1,315), -- Scroll: Enchant Weapon (Grade A)
(21595,5448,1,1,-1,1049), -- Recipe: Soul Separator(60%)
(21595,5494,1,1,-1,59510), -- Sealed Dark Crystal Shield Fragment
(21595,57,1142,2325,0,700000), -- Adena
(21595,269,1,1,1,5), -- Blood Tornado
(21595,5539,1,1,1,1412), -- Blood Tornado Edge
(21595,1868,1,1,2,278996), -- Thread
(21595,1873,1,1,2,55800), -- Silver Nugget
(21595,1876,1,1,2,27900), -- Mithril Ore
(21595,1895,1,1,2,39857), -- Metallic Fiber
(21595,4042,1,1,2,2326), -- Enria
(21595,5162,1,1,2,62), -- Recipe: Spiritshot (S) Compressed Package (100%)
(21596,5535,1,1,-1,13962), -- Carnage Bow Stave
(21596,6337,1,1,-1,20985), -- Recipe: Sealed Majestic Earring(70%)
(21596,6339,1,1,-1,31477), -- Recipe: Sealed Majestic Ring(70%)
(21596,57,1651,3356,0,700000), -- Adena
(21596,98,1,1,1,7), -- Halberd
(21596,5542,1,1,1,2039), -- Halberd Edge
(21596,729,1,1,2,20), -- Scroll: Enchant Weapon (Grade A)
(21596,1343,20,60,2,123340), -- Silver Arrow
(21596,1867,1,1,2,230234), -- Animal Skin
(21596,1872,1,3,2,76745), -- Animal Bone
(21596,1875,1,1,2,11512), -- Stone of Purity
(21596,1881,1,1,2,23024), -- Coarse Bone Powder
(21596,4041,1,1,2,1502), -- Mold Hardener
(21597,4043,1,1,-1,86136), -- Asofe
(21597,4052,1,1,-1,91488), -- Earring of Black Ore Piece
(21597,5550,1,1,-1,34455), -- Durable Metal Plate
(21597,57,1039,2123,0,700000), -- Adena
(21597,287,1,1,1,6), -- Bow of Peril
(21597,4121,1,1,1,1663), -- Bow of Peril Shaft
(21597,1343,10,30,2,155776), -- Silver Arrow
(21597,1864,1,1,2,218087), -- Stem
(21597,1869,1,1,2,109043), -- Iron Ore
(21597,1880,1,1,2,10905), -- Steel
(21597,4043,1,1,2,3635), -- Asofe
(21597,5550,1,1,2,1455), -- Durable Metal Plate
(21597,6335,1,1,2,420), -- Recipe: Sealed Majestic Necklace(70%)
(21598,4053,1,1,-1,124039), -- Ring of Black Ore Gemstone
(21598,5230,1,1,-1,3858), -- Recipe: Mithril Arrow (100%)
(21598,5271,1,1,-1,3858), -- Recipe: Greater Soulshot (A) Compressed Package(100%)
(21598,57,1164,2378,0,700000), -- Adena
(21598,2398,1,1,1,9), -- Blue Wolf Tunic
(21598,2399,1,1,1,9), -- Tunic of Doom
(21598,2403,1,1,1,15), -- Blue Wolf Stockings
(21598,2404,1,1,1,15), -- Stockings of Doom
(21598,4084,1,1,1,1857), -- Blue Wolf Tunic Fabric
(21598,4085,1,1,1,1857), -- Tunic of Doom Pattern
(21598,4086,1,1,1,2507), -- Blue Wolf Stockings Pattern
(21598,4087,1,1,1,2507), -- Stockings of Doom Pattern
(21598,1865,1,1,2,142466), -- Varnish
(21598,1870,1,1,2,142466), -- Coal
(21598,1874,1,1,2,9498), -- Oriharukon Ore
(21598,4039,1,1,2,4749), -- Mold Glue
(21598,4043,1,1,2,4749), -- Asofe
(21598,6337,1,1,2,731), -- Recipe: Sealed Majestic Earring(70%)
(21599,5497,1,1,-1,102474), -- Sealed Tallum Boots Lining
(21599,6337,1,1,-1,22413), -- Recipe: Sealed Majestic Earring(70%)
(21599,6339,1,1,-1,33619), -- Recipe: Sealed Majestic Ring(70%)
(21599,57,1760,3587,0,700000), -- Adena
(21599,235,1,1,1,8), -- Bloody Orchid
(21599,5536,1,1,1,2196), -- Bloody Orchid Head
(21599,1867,1,3,2,143442), -- Animal Skin
(21599,1872,1,1,2,286884), -- Animal Bone
(21599,1882,1,1,2,47814), -- Leather
(21599,1894,1,1,2,7550), -- Crafted Leather
(21599,3957,1,1,2,96), -- Recipe: Blessed Spiritshot S
(21599,4042,1,1,2,3587), -- Enria
(21600,1884,1,3,-1,875794), -- Cord
(21600,5462,1,1,-1,1054), -- Recipe: Branch of The Mother Tree(60%)
(21600,5509,1,1,-1,66737), -- Sealed Tallum Gloves Design
(21600,57,1148,2336,0,700000), -- Adena
(21600,80,1,1,1,3), -- Tallum Blade
(21600,150,1,1,1,3), -- Elemental Sword
(21600,5547,1,1,1,716), -- Elemental Sword Edge
(21600,5548,1,1,1,716), -- Tallum Blade Edge
(21600,729,1,1,2,14), -- Scroll: Enchant Weapon (Grade A)
(21600,1343,30,90,2,57195), -- Silver Arrow
(21600,1864,1,3,2,120109), -- Stem
(21600,1869,1,1,2,120109), -- Iron Ore
(21600,1878,1,1,2,48044), -- Braided Hemp
(21600,1884,1,1,2,73914), -- Cord
(21600,4039,1,1,2,4004), -- Mold Glue
(21601,5464,1,1,-1,1271), -- Recipe: Dark Legion\'s Edge(60%)
(21601,5520,1,1,-1,22126), -- Sealed Dark Crystal Breastplate Pattern
(21601,5521,1,1,-1,15613), -- Sealed Tallum Plate Armor Pattern
(21601,57,1384,2816,0,700000), -- Adena
(21601,212,1,1,1,3), -- Dasparion\'s Staff
(21601,2504,1,1,1,3), -- Meteor Shower
(21601,5532,1,1,1,855), -- Meteor Shower Head
(21601,5543,1,1,1,863), -- Dasparion\'s Staff Edge
(21601,730,1,1,2,142), -- Scroll: Enchant Armor (Grade A)
(21601,1866,1,1,2,112614), -- Suede
(21601,1871,1,1,2,168921), -- Charcoal
(21601,1877,1,1,2,6757), -- Adamantite Nugget
(21601,4040,1,1,2,3379), -- Mold Lubricant
(21601,4041,1,1,2,1469), -- Mold Hardener
(21602,1825,1,1,-1,86056), -- Recipe: Oriharukon
(21602,1902,1,1,-1,122065), -- Elven Earring Beads
(21602,5231,1,1,-1,86056), -- Recipe: Metal Hardener (100%)
(21602,57,486,987,0,700000), -- Adena
(21602,61,1,1,1,104), -- Mithril Gloves
(21602,607,1,1,1,104), -- Ogre Power Gauntlets
(21602,1125,1,1,1,104), -- Assault Boots
(21602,1949,1,1,1,5627), -- Mithril Gloves Design
(21602,1957,1,1,1,5627), -- Assault Boots Part
(21602,1963,1,1,1,5627), -- Ogre Power Gauntlets Part
(21602,2427,1,1,1,104), -- Salamander Skin Boots
(21602,2428,1,1,1,104), -- Plate Boots
(21602,2451,1,1,1,104), -- Sage\'s Worn Gloves
(21602,2931,1,1,1,5627), -- Salamander Skin Boot Lining
(21602,2932,1,1,1,5627), -- Plate Boots Design
(21602,2933,1,1,1,5627), -- Sage\'s Worn Gloves Lining
(21602,1865,1,1,2,86427), -- Varnish
(21602,1870,1,1,2,86427), -- Coal
(21602,1875,1,1,2,5762), -- Stone of Purity
(21602,1879,1,1,2,14405), -- Cokes
(21602,2162,1,1,2,4176), -- Recipe: Aquastone Necklace
(21602,2312,1,1,2,378), -- Recipe: Crystallized Ice Bow
(21602,5159,1,1,2,289), -- Recipe: Spiritshot (C) Compressed Package (100%)
(21603,1825,1,1,-1,121859), -- Recipe: Oriharukon
(21603,1902,1,1,-1,172850), -- Elven Earring Beads
(21603,5231,1,1,-1,121859), -- Recipe: Metal Hardener (100%)
(21603,57,688,1398,0,700000), -- Adena
(21603,61,1,1,1,146), -- Mithril Gloves
(21603,607,1,1,1,146), -- Ogre Power Gauntlets
(21603,1125,1,1,1,146), -- Assault Boots
(21603,1949,1,1,1,7968), -- Mithril Gloves Design
(21603,1957,1,1,1,7968), -- Assault Boots Part
(21603,1963,1,1,1,7968), -- Ogre Power Gauntlets Part
(21603,2427,1,1,1,146), -- Salamander Skin Boots
(21603,2428,1,1,1,146), -- Plate Boots
(21603,2451,1,1,1,146), -- Sage\'s Worn Gloves
(21603,2931,1,1,1,7968), -- Salamander Skin Boot Lining
(21603,2932,1,1,1,7968), -- Plate Boots Design
(21603,2933,1,1,1,7968), -- Sage\'s Worn Gloves Lining
(21603,1865,1,1,2,122385), -- Varnish
(21603,1870,1,1,2,122385), -- Coal
(21603,1875,1,1,2,8159), -- Stone of Purity
(21603,1879,1,1,2,20398), -- Cokes
(21603,2162,1,1,2,5913), -- Recipe: Aquastone Necklace
(21603,2312,1,1,2,535), -- Recipe: Crystallized Ice Bow
(21603,5159,1,1,2,408), -- Recipe: Spiritshot (C) Compressed Package (100%)
(21604,1805,1,1,-1,9195), -- Recipe: Soulshot: C-Grade
(21604,1905,1,1,-1,268330), -- Omen Beast\'s Eye Earring Gemstone
(21604,4469,1,1,-1,15762), -- Dye of Strength <Str+1 Con-1>
(21604,57,1113,2260,0,700000), -- Adena
(21604,353,1,1,1,178), -- Half Plate Armor
(21604,380,1,1,1,284), -- Plate Gaiters
(21604,1950,1,1,1,11240), -- Half Plate Temper
(21604,1951,1,1,1,17481), -- Plate Gaiters Part
(21604,1805,1,1,2,924), -- Recipe: Soulshot: C-Grade
(21604,1867,1,3,2,184688), -- Animal Skin
(21604,1872,1,3,2,123125), -- Animal Bone
(21604,1882,1,1,2,61563), -- Leather
(21604,1894,1,1,2,9721), -- Crafted Leather
(21605,1874,1,1,-1,89292), -- Oriharukon Ore
(21605,1875,1,1,-1,89292), -- Stone of Purity
(21605,1905,1,1,-1,130289), -- Omen Beast\'s Eye Earring Gemstone
(21605,57,538,1102,0,700000), -- Adena
(21605,281,1,1,1,28), -- Crystallized Ice Bow
(21605,2074,1,1,1,2242), -- Crystallized Ice Bow Shaft
(21605,1867,1,1,2,120574), -- Animal Skin
(21605,1872,1,1,2,120574), -- Animal Bone
(21605,1875,1,1,2,6029), -- Stone of Purity
(21605,1881,1,1,2,12058), -- Coarse Bone Powder
(21605,2205,1,1,2,2862), -- Recipe: Chain Gaiters
(21605,2209,1,1,2,6800), -- Recipe: Eldarake
(21605,2299,1,1,2,395), -- Recipe: Big Hammer
(21606,1874,1,1,-1,126442), -- Oriharukon Ore
(21606,1875,1,1,-1,126442), -- Stone of Purity
(21606,1905,1,1,-1,184497), -- Omen Beast\'s Eye Earring Gemstone
(21606,57,761,1560,0,700000), -- Adena
(21606,281,1,1,1,40), -- Crystallized Ice Bow
(21606,2074,1,1,1,3174), -- Crystallized Ice Bow Shaft
(21606,1867,1,1,2,170738), -- Animal Skin
(21606,1872,1,1,2,170738), -- Animal Bone
(21606,1875,1,1,2,8537), -- Stone of Purity
(21606,1881,1,1,2,17074), -- Coarse Bone Powder
(21606,2205,1,1,2,4053), -- Recipe: Chain Gaiters
(21606,2209,1,1,2,9629), -- Recipe: Eldarake
(21606,2299,1,1,2,560), -- Recipe: Big Hammer
(21607,1908,1,1,-1,280642), -- Moonstone Earring Wire
(21607,1909,1,1,-1,400213), -- Aquastone Ring Wire
(21607,2163,1,1,-1,151203), -- Recipe: Earring of Protection
(21607,57,1190,2438,0,700000), -- Adena
(21607,354,1,1,1,139), -- Chain Mail Shirt
(21607,381,1,1,1,222), -- Chain Gaiters
(21607,1959,1,1,1,9433), -- Chain Mail Shirt Material
(21607,1960,1,1,1,19189), -- Chain Gaiters Part
(21607,1875,1,1,2,15563), -- Stone of Purity
(21607,1879,1,1,2,38907), -- Cokes
(21607,1885,1,1,2,19454), -- High Grade Suede
(21607,2163,1,1,2,11911), -- Recipe: Earring of Protection
(21607,5549,1,1,2,23344), -- Metallic Thread
(21607,5550,1,1,2,3113), -- Durable Metal Plate
(21608,1871,1,3,-1,549216), -- Charcoal
(21608,1879,1,1,-1,183072), -- Cokes
(21608,1906,1,1,-1,150987), -- Mithril Ring Wire
(21608,57,443,900,0,700000), -- Adena
(21608,439,1,1,1,69), -- Karmian Tunic
(21608,471,1,1,1,110), -- Karmian Stockings
(21608,1954,1,1,1,6900), -- Karmian Stocking Design
(21608,1962,1,1,1,4154), -- Karmian Tunic Pattern
(21608,1865,1,1,2,51914), -- Varnish
(21608,1870,1,1,2,51914), -- Coal
(21608,1875,1,1,2,3461), -- Stone of Purity
(21608,1879,1,1,2,8653), -- Cokes
(21608,2303,1,1,2,227), -- Recipe: Skull Graver
(21608,2990,1,1,2,4121), -- Recipe: Chain Boots
(21608,3000,1,1,2,3328), -- Recipe: Dwarven Chain Shield
(21608,3033,1,1,2,173), -- Recipe: Spiritshot C
(21608,3954,1,1,2,174), -- Recipe: Blessed Spiritshot C
(21608,4040,1,1,2,1039), -- Mold Lubricant
(21609,1871,1,3,-1,777719), -- Charcoal
(21609,1879,1,1,-1,259240), -- Cokes
(21609,1906,1,1,-1,213806), -- Mithril Ring Wire
(21609,57,628,1275,0,700000), -- Adena
(21609,439,1,1,1,97), -- Karmian Tunic
(21609,471,1,1,1,156), -- Karmian Stockings
(21609,1954,1,1,1,9771), -- Karmian Stocking Design
(21609,1962,1,1,1,5882), -- Karmian Tunic Pattern
(21609,1865,1,1,2,73513), -- Varnish
(21609,1870,1,1,2,73513), -- Coal
(21609,1875,1,1,2,4901), -- Stone of Purity
(21609,1879,1,1,2,12253), -- Cokes
(21609,2303,1,1,2,322), -- Recipe: Skull Graver
(21609,2990,1,1,2,5835), -- Recipe: Chain Boots
(21609,3000,1,1,2,4713), -- Recipe: Dwarven Chain Shield
(21609,3033,1,1,2,245), -- Recipe: Spiritshot C
(21609,3954,1,1,2,246), -- Recipe: Blessed Spiritshot C
(21609,4040,1,1,2,1471); -- Mold Lubricant

INSERT INTO `droplist` VALUES 
(21610,1869,1,5,-1,946366), -- Iron Ore
(21610,2163,1,1,-1,144852), -- Recipe: Earring of Protection
(21610,4043,1,1,-1,94637), -- Asofe
(21610,57,1146,2327,0,700000), -- Adena
(21610,397,1,1,1,178), -- Mithril Shirt
(21610,1961,1,1,1,10735), -- Mithril Shirt Fabric
(21610,2387,1,1,1,284), -- Tempered Mithril Gaiters
(21610,2935,1,1,1,17835), -- Tempered Mithril Gaiters Fragment
(21610,1864,1,3,2,223634), -- Stem
(21610,1869,1,1,2,223634), -- Iron Ore
(21610,1880,1,1,2,22364), -- Steel
(21610,2164,1,1,2,17204), -- Recipe: Ring of Protection
(21610,4043,1,1,2,7455), -- Asofe
(21610,5550,1,1,2,2982), -- Durable Metal Plate
(21611,1908,1,1,-1,120774), -- Moonstone Earring Wire
(21611,2066,1,1,-1,10003), -- Heavy Doom Hammer Head
(21611,2320,1,1,-1,4444), -- Recipe: Cursed Staff
(21611,57,512,1048,0,700000), -- Adena
(21611,631,1,1,1,152), -- Eldarake
(21611,1964,1,1,1,8118), -- Eldarake Temper
(21611,2413,1,1,1,107), -- Chain Hood
(21611,2495,1,1,1,152), -- Chain Shield
(21611,2936,1,1,1,7374), -- Chain Hood Pattern
(21611,2945,1,1,1,8118), -- Chain Shield Fragment
(21611,1867,1,1,2,100461), -- Animal Skin
(21611,1872,1,1,2,100461), -- Animal Bone
(21611,1882,1,1,2,16744), -- Leather
(21611,1894,1,1,2,2644), -- Crafted Leather
(21611,2230,1,1,2,1461), -- Recipe: Theca Leather Gaiters
(21611,2326,1,1,2,263), -- Recipe: Horn of Glory
(21611,4042,1,1,2,1256), -- Enria
(21611,6668,1,1,2,26909), -- Deluxe Chest Key - Grade 4
(21612,1908,1,1,-1,171022), -- Moonstone Earring Wire
(21612,2066,1,1,-1,14165), -- Heavy Doom Hammer Head
(21612,2320,1,1,-1,6293), -- Recipe: Cursed Staff
(21612,57,726,1484,0,700000), -- Adena
(21612,631,1,1,1,214), -- Eldarake
(21612,1964,1,1,1,11496), -- Eldarake Temper
(21612,2413,1,1,1,151), -- Chain Hood
(21612,2495,1,1,1,214), -- Chain Shield
(21612,2936,1,1,1,10441), -- Chain Hood Pattern
(21612,2945,1,1,1,11496), -- Chain Shield Fragment
(21612,1867,1,1,2,142257), -- Animal Skin
(21612,1872,1,1,2,142257), -- Animal Bone
(21612,1882,1,1,2,23710), -- Leather
(21612,1894,1,1,2,3744), -- Crafted Leather
(21612,2230,1,1,2,2068), -- Recipe: Theca Leather Gaiters
(21612,2326,1,1,2,372), -- Recipe: Horn of Glory
(21612,4042,1,1,2,1779), -- Enria
(21612,6668,1,1,2,38105), -- Deluxe Chest Key - Grade 4
(21613,1864,1,13,-1,880611), -- Stem
(21613,2062,1,1,-1,24174), -- Scythe Edge
(21613,2219,1,1,-1,191437), -- Recipe: Crimson Boots
(21613,57,1238,2533,0,700000), -- Adena
(21613,226,1,1,1,32), -- Cursed Dagger
(21613,232,1,1,1,32), -- Dark Elven Dagger
(21613,2070,1,1,1,2892), -- Cursed Dagger Blade
(21613,2072,1,1,1,2892), -- Dark Elven Dagger Edge
(21613,1864,1,3,2,242778), -- Stem
(21613,1869,1,3,2,80926), -- Iron Ore
(21613,1880,1,1,2,24278), -- Steel
(21613,2251,1,1,2,40464), -- Recipe: Steel Arrow
(21613,4043,1,1,2,8093), -- Asofe
(21613,5550,1,1,2,3237), -- Durable Metal Plate
(21614,1967,1,1,-1,71784), -- Plated Leather Gaiters Material
(21614,2166,1,1,-1,44616), -- Recipe: Earrings of Binding (100%)
(21614,2328,1,1,-1,3061), -- Recipe: Sword of Delusion
(21614,57,530,1081,0,700000), -- Adena
(21614,227,1,1,1,11), -- Stiletto
(21614,242,1,1,1,11), -- Soulfire Dirk
(21614,2083,1,1,1,969), -- Stiletto Edge
(21614,2084,1,1,1,969), -- Soulfire Dirk Blade
(21614,952,1,1,2,1111), -- Scroll: Enchant Armor (Grade C)
(21614,1868,1,1,2,166618), -- Thread
(21614,1873,1,1,2,33324), -- Silver Nugget
(21614,1889,1,1,2,5554), -- Compound Braid
(21614,2229,1,1,2,1010), -- Recipe: Theca Leather Armor
(21614,4044,1,1,2,2777), -- Thons
(21614,5549,1,1,2,8331), -- Metallic Thread
(21615,1967,1,1,-1,101650), -- Plated Leather Gaiters Material
(21615,2166,1,1,-1,63178), -- Recipe: Earrings of Binding (100%)
(21615,2328,1,1,-1,4334), -- Recipe: Sword of Delusion
(21615,57,750,1531,0,700000), -- Adena
(21615,227,1,1,1,15), -- Stiletto
(21615,242,1,1,1,15), -- Soulfire Dirk
(21615,2083,1,1,1,1373), -- Stiletto Edge
(21615,2084,1,1,1,1373), -- Soulfire Dirk Blade
(21615,952,1,1,2,1573), -- Scroll: Enchant Armor (Grade C)
(21615,1868,1,1,2,235939), -- Thread
(21615,1873,1,1,2,47188), -- Silver Nugget
(21615,1889,1,1,2,7865), -- Compound Braid
(21615,2229,1,1,2,1430), -- Recipe: Theca Leather Armor
(21615,4044,1,1,2,3933), -- Thons
(21615,5549,1,1,2,11798), -- Metallic Thread
(21616,1873,1,3,-1,680372), -- Silver Nugget
(21616,1911,1,1,-1,253020), -- Earring of Protection Gemstone
(21616,1966,1,1,-1,124201), -- Plated Leather Fragment
(21616,57,1369,2794,0,700000), -- Adena
(21616,500,1,1,1,208), -- Great Helmet
(21616,632,1,1,1,298), -- Knight\'s Shield
(21616,1971,1,1,1,15380), -- Great Helmet Material
(21616,1972,1,1,1,20098), -- Knight\'s Shield Fragment
(21616,2496,1,1,1,323), -- Dwarven Chain Shield
(21616,2947,1,1,1,17945), -- Dwarven Chain Shield Fragment
(21616,951,1,1,2,457), -- Scroll: Enchant Weapon (Grade C)
(21616,1868,1,3,2,251215), -- Thread
(21616,1873,1,1,2,100486), -- Silver Nugget
(21616,1876,1,1,2,50243), -- Mithril Ore
(21616,1895,1,1,2,71776), -- Metallic Fiber
(21616,4042,1,1,2,4188), -- Enria
(21617,951,1,1,-1,2435), -- Scroll: Enchant Weapon (Grade C)
(21617,1911,1,1,-1,99629), -- Earring of Protection Gemstone
(21617,4438,1,1,-1,9553), -- Knuckle Duster Edge
(21617,57,540,1098,0,700000), -- Adena
(21617,282,1,1,1,11), -- Elemental Bow
(21617,285,1,1,1,11), -- Noble Elven Bow
(21617,2085,1,1,1,1027), -- Crossbow Shaft
(21617,2086,1,1,1,1027), -- Elven Bow of Nobility Shaft
(21617,952,1,1,2,990), -- Scroll: Enchant Armor (Grade C)
(21617,1864,1,1,2,148377), -- Stem
(21617,1869,1,1,2,74189), -- Iron Ore
(21617,1880,1,1,2,7419), -- Steel
(21617,2348,1,1,2,173), -- Recipe: Heathen\'s Book
(21617,2351,1,1,2,156), -- Recipe: Scorpion
(21617,4043,1,1,2,2473), -- Asofe
(21617,5550,1,1,2,990), -- Durable Metal Plate
(21618,951,1,1,-1,3449), -- Scroll: Enchant Weapon (Grade C)
(21618,1911,1,1,-1,141079), -- Earring of Protection Gemstone
(21618,4438,1,1,-1,13527), -- Knuckle Duster Edge
(21618,57,765,1555,0,700000), -- Adena
(21618,282,1,1,1,15), -- Elemental Bow
(21618,285,1,1,1,15), -- Noble Elven Bow
(21618,2085,1,1,1,1454), -- Crossbow Shaft
(21618,2086,1,1,1,1454), -- Elven Bow of Nobility Shaft
(21618,952,1,1,2,1401), -- Scroll: Enchant Armor (Grade C)
(21618,1864,1,1,2,210109), -- Stem
(21618,1869,1,1,2,105055), -- Iron Ore
(21618,1880,1,1,2,10506), -- Steel
(21618,2348,1,1,2,245), -- Recipe: Heathen\'s Book
(21618,2351,1,1,2,220), -- Recipe: Scorpion
(21618,4043,1,1,2,3502), -- Asofe
(21618,5550,1,1,2,1401), -- Durable Metal Plate
(21619,1912,1,1,-1,373082), -- Ring of Protection Gemstone
(21619,2166,1,1,-1,117363), -- Recipe: Earrings of Binding (100%)
(21619,2167,1,1,-1,176643), -- Recipe: Ring of Ages
(21619,57,1397,2839,0,700000), -- Adena
(21619,282,1,1,1,27), -- Elemental Bow
(21619,285,1,1,1,27), -- Noble Elven Bow
(21619,2085,1,1,1,2653), -- Crossbow Shaft
(21619,2086,1,1,1,2653), -- Elven Bow of Nobility Shaft
(21619,952,1,1,2,3410), -- Scroll: Enchant Armor (Grade C)
(21619,1867,1,3,2,113632), -- Animal Skin
(21619,1869,2,6,2,63918), -- Iron Ore
(21619,1870,2,6,2,51135), -- Coal
(21619,1871,3,9,2,42612), -- Charcoal
(21619,1872,1,3,2,170447), -- Animal Bone
(21620,1976,1,1,-1,78518), -- Rind Leather Gaiters Material
(21620,2167,1,1,-1,65879), -- Recipe: Ring of Ages
(21620,2335,1,1,-1,3003), -- Recipe: War Axe
(21620,57,520,1060,0,700000), -- Adena
(21620,853,1,1,1,98), -- Earring of Protection
(21620,884,1,1,1,147), -- Ring of Protection
(21620,916,1,1,1,74), -- Necklace of Protection
(21620,1911,1,1,1,7093), -- Earring of Protection Gemstone
(21620,1912,1,1,1,10277), -- Ring of Protection Gemstone
(21620,1913,1,1,1,5799), -- Necklace of Protection Gemstone
(21620,952,1,1,2,1272), -- Scroll: Enchant Armor (Grade C)
(21620,1865,1,1,2,95353), -- Varnish
(21620,1870,1,1,2,95353), -- Coal
(21620,1874,1,1,2,6357), -- Oriharukon Ore
(21620,4039,1,1,2,3179), -- Mold Glue
(21620,4043,1,1,2,3179), -- Asofe
(21621,1976,1,1,-1,111186), -- Rind Leather Gaiters Material
(21621,2167,1,1,-1,93288), -- Recipe: Ring of Ages
(21621,2335,1,1,-1,4252), -- Recipe: War Axe
(21621,57,736,1501,0,700000), -- Adena
(21621,853,1,1,1,138), -- Earring of Protection
(21621,884,1,1,1,208), -- Ring of Protection
(21621,916,1,1,1,104), -- Necklace of Protection
(21621,1911,1,1,1,10044), -- Earring of Protection Gemstone
(21621,1912,1,1,1,14552), -- Ring of Protection Gemstone
(21621,1913,1,1,1,8212), -- Necklace of Protection Gemstone
(21621,952,1,1,2,1800), -- Scroll: Enchant Armor (Grade C)
(21621,1865,1,1,2,135024), -- Varnish
(21621,1870,1,1,2,135024), -- Coal
(21621,1874,1,1,2,9002), -- Oriharukon Ore
(21621,4039,1,1,2,4501), -- Mold Glue
(21621,4043,1,1,2,4501), -- Asofe
(21622,951,1,1,-1,6068), -- Scroll: Enchant Weapon (Grade C)
(21622,1865,1,7,-1,834354), -- Varnish
(21622,1913,1,1,-1,202944), -- Necklace of Protection Gemstone
(21622,57,1344,2740,0,700000), -- Adena
(21622,853,1,1,1,252), -- Earring of Protection
(21622,884,1,1,1,380), -- Ring of Protection
(21622,916,1,1,1,189), -- Necklace of Protection
(21622,1911,1,1,1,18333), -- Earring of Protection Gemstone
(21622,1912,1,1,1,26561), -- Ring of Protection Gemstone
(21622,1913,1,1,1,14989), -- Necklace of Protection Gemstone
(21622,1342,40,120,2,105624), -- Fine Steel Arrow
(21622,1864,5,15,2,42250), -- Stem
(21622,1865,3,9,2,35208), -- Varnish
(21622,1866,3,9,2,20119), -- Suede
(21622,1868,1,3,2,140832), -- Thread
(21622,1873,1,1,2,84499), -- Silver Nugget
(21622,2166,1,1,2,7162), -- Recipe: Earrings of Binding (100%)
(21623,1539,1,1,-1,363117), -- Greater Healing Potion
(21623,1914,1,1,-1,91799), -- Earring of Binding Gemstone
(21623,4601,1,1,-1,3631), -- Greater Dye of Strength <Str+3 Con-3>
(21623,57,659,1340,0,700000), -- Adena
(21623,283,1,1,1,16), -- Akat Long Bow
(21623,2109,1,1,1,1895), -- Akat Longbow Shaft
(21623,1866,1,1,2,56312), -- Suede
(21623,1871,1,1,2,84467), -- Charcoal
(21623,1877,1,1,2,3379), -- Adamantite Nugget
(21623,2357,1,1,2,138), -- Recipe: Crystal Dagger
(21623,3014,1,1,2,2360), -- Recipe: Full Plate Boots
(21623,4040,1,1,2,1690), -- Mold Lubricant
(21623,4041,1,1,2,735), -- Mold Hardener
(21623,4188,1,1,2,98), -- Recipe: Hell Knife
(21624,1539,1,1,-1,514192), -- Greater Healing Potion
(21624,1914,1,1,-1,129992), -- Earring of Binding Gemstone
(21624,4601,1,1,-1,5142), -- Greater Dye of Strength <Str+3 Con-3>
(21624,57,934,1898,0,700000), -- Adena
(21624,283,1,1,1,23), -- Akat Long Bow
(21624,2109,1,1,1,2683), -- Akat Longbow Shaft
(21624,1866,1,1,2,79740), -- Suede
(21624,1871,1,1,2,119610), -- Charcoal
(21624,1877,1,1,2,4785), -- Adamantite Nugget
(21624,2357,1,1,2,196), -- Recipe: Crystal Dagger
(21624,3014,1,1,2,3341), -- Recipe: Full Plate Boots
(21624,4040,1,1,2,2393), -- Mold Lubricant
(21624,4041,1,1,2,1041), -- Mold Hardener
(21624,4188,1,1,2,138), -- Recipe: Hell Knife
(21625,1539,1,1,-1,831383), -- Greater Healing Potion
(21625,1882,1,1,-1,831383), -- Leather
(21625,4601,1,1,-1,8314), -- Greater Dye of Strength <Str+3 Con-3>
(21625,57,1509,3068,0,700000), -- Adena
(21625,1867,4,12,2,165765), -- Animal Skin
(21625,1872,7,21,2,88408), -- Animal Bone
(21625,1882,3,9,2,36837), -- Leather
(21625,1894,1,1,2,34898), -- Crafted Leather
(21625,2169,1,1,2,17604), -- Recipe: Necklace of Binding
(21625,4042,1,1,2,16577), -- Enria
(21626,1539,1,1,-1,324297), -- Greater Healing Potion
(21626,4041,1,1,-1,12690), -- Mold Hardener
(21626,4603,1,1,-1,3243), -- Greater Dye of Constitution <Con+3 Str-3>
(21626,57,589,1197,0,700000), -- Adena
(21626,854,1,1,1,69), -- Earring of Binding
(21626,885,1,1,1,103), -- Ring of Ages
(21626,917,1,1,1,52), -- Necklace of Mermaid
(21626,1914,1,1,1,5652), -- Earring of Binding Gemstone
(21626,1915,1,1,1,8863), -- Ring of Ages Gemstone
(21626,1916,1,1,1,4281), -- Necklace of Mermaid Teardrop
(21626,1867,1,1,2,100583), -- Animal Skin
(21626,1872,1,1,2,100583), -- Animal Bone
(21626,1875,1,1,2,5030), -- Stone of Purity
(21626,1881,1,1,2,10059), -- Coarse Bone Powder
(21626,2355,1,1,2,124), -- Recipe: Ghoul\'s Staff
(21626,4041,1,1,2,657), -- Mold Hardener
(21626,4601,1,1,2,168), -- Greater Dye of Strength <Str+3 Con-3>
(21626,4609,1,1,2,168), -- Greater Dye of Mental Strength <Men+3 Int-3>
(21627,1539,1,1,-1,459222), -- Greater Healing Potion
(21627,4041,1,1,-1,17970), -- Mold Hardener
(21627,4603,1,1,-1,4592), -- Greater Dye of Constitution <Con+3 Str-3>
(21627,57,835,1695,0,700000), -- Adena
(21627,854,1,1,1,97), -- Earring of Binding
(21627,885,1,1,1,146), -- Ring of Ages
(21627,917,1,1,1,73), -- Necklace of Mermaid
(21627,1914,1,1,1,8003), -- Earring of Binding Gemstone
(21627,1915,1,1,1,12550), -- Ring of Ages Gemstone
(21627,1916,1,1,1,6062), -- Necklace of Mermaid Teardrop
(21627,1867,1,1,2,142430), -- Animal Skin
(21627,1872,1,1,2,142430), -- Animal Bone
(21627,1875,1,1,2,7122), -- Stone of Purity
(21627,1881,1,1,2,14243), -- Coarse Bone Powder
(21627,2355,1,1,2,175), -- Recipe: Ghoul\'s Staff
(21627,4041,1,1,2,929), -- Mold Hardener
(21627,4601,1,1,2,238), -- Greater Dye of Strength <Str+3 Con-3>
(21627,4609,1,1,2,238), -- Greater Dye of Mental Strength <Men+3 Int-3>
(21628,1539,1,1,-1,838205), -- Greater Healing Potion
(21628,1874,1,1,-1,251462), -- Oriharukon Ore
(21628,4604,1,1,-1,8382), -- Greater Dye of Constitution <Con+3 Dex-3>
(21628,57,1523,3095,0,700000), -- Adena
(21628,162,1,1,1,5), -- War Axe
(21628,174,1,1,1,5), -- Nirvana Axe
(21628,196,1,1,1,5), -- Stick of Eternity
(21628,197,1,1,1,5), -- Paradia Staff
(21628,199,1,1,1,5), -- Pa\'agrian Hammer
(21628,200,1,1,1,5), -- Sage\'s Staff
(21628,201,1,1,1,5), -- Club of Nature
(21628,202,1,1,1,5), -- Mace of The Underworld
(21628,2097,1,1,1,523), -- War Axe Blade
(21628,2098,1,1,1,523), -- Nirvana Axe Blade
(21628,2099,1,1,1,550), -- Stick of Eternity Shaft
(21628,2100,1,1,1,550), -- Paradia Staff Head
(21628,2102,1,1,1,530), -- Pa\'agrian Hammer Head
(21628,2103,1,1,1,550), -- Sage\'s Staff Head
(21628,2104,1,1,1,550), -- Club of Nature Head
(21628,2105,1,1,1,523), -- Mace of The Underworld Head
(21628,1874,1,1,2,14856), -- Oriharukon Ore
(21628,1878,1,1,2,89133), -- Braided Hemp
(21628,1884,1,1,2,137128), -- Cord
(21628,1889,1,1,2,14856), -- Compound Braid
(21628,2356,1,1,2,364), -- Recipe: Demon\'s Staff
(21628,3012,1,1,2,4158), -- Recipe: Full Plate Helmet
(21628,5220,1,1,2,8914), -- Metal Hardener
(21629,2100,1,1,-1,11209), -- Paradia Staff Head
(21629,2354,1,1,-1,3244), -- Recipe: Deadman\'s Staff
(21629,4042,1,1,-1,33140), -- Enria
(21629,57,806,1628,0,700000), -- Adena
(21629,75,1,1,1,4), -- Caliburs
(21629,76,1,1,1,4), -- Sword of Delusion
(21629,77,1,1,1,4), -- Tsurugi
(21629,84,1,1,1,4), -- Homunkulus\'s Sword
(21629,134,1,1,1,4), -- Sword of Nightmare
(21629,145,1,1,1,4), -- Sword of Whispering Death
(21629,2089,1,1,1,374), -- Caliburs Edge
(21629,2090,1,1,1,374), -- Delusional Blade
(21629,2091,1,1,1,374), -- Tsurugi Blade
(21629,2092,1,1,1,374), -- Homunkulus\'s Sword Blade
(21629,2095,1,1,1,374), -- Sword of Nightmare Blade
(21629,2096,1,1,1,374), -- Sword of Whispering Death Blade
(21629,1868,1,1,2,164455), -- Thread
(21629,1873,1,1,2,32891), -- Silver Nugget
(21629,1876,1,1,2,16446), -- Mithril Ore
(21629,1895,1,1,2,23494), -- Metallic Fiber
(21629,3017,1,1,2,2297), -- Recipe: Divine Gloves
(21629,4042,1,1,2,1371), -- Enria
(21629,4608,1,1,2,183), -- Greater Dye of Intelligence <Int+3 Wit-3>
(21629,5155,1,1,2,165), -- Recipe: Soulshot (B) Compressed Package (100%)
(21629,6669,1,1,2,19123), -- Deluxe Chest Key - Grade 5
(21630,2100,1,1,-1,15872), -- Paradia Staff Head
(21630,2354,1,1,-1,4593), -- Recipe: Deadman\'s Staff
(21630,4042,1,1,-1,46928), -- Enria
(21630,57,1141,2305,0,700000), -- Adena
(21630,75,1,1,1,5), -- Caliburs
(21630,76,1,1,1,5), -- Sword of Delusion
(21630,77,1,1,1,5), -- Tsurugi
(21630,84,1,1,1,5), -- Homunkulus\'s Sword
(21630,134,1,1,1,5), -- Sword of Nightmare
(21630,145,1,1,1,5), -- Sword of Whispering Death
(21630,2089,1,1,1,529), -- Caliburs Edge
(21630,2090,1,1,1,529), -- Delusional Blade
(21630,2091,1,1,1,529), -- Tsurugi Blade
(21630,2092,1,1,1,529), -- Homunkulus\'s Sword Blade
(21630,2095,1,1,1,529), -- Sword of Nightmare Blade
(21630,2096,1,1,1,529), -- Sword of Whispering Death Blade
(21630,1868,1,1,2,232877), -- Thread
(21630,1873,1,1,2,46576), -- Silver Nugget
(21630,1876,1,1,2,23288), -- Mithril Ore
(21630,1895,1,1,2,33269), -- Metallic Fiber
(21630,3017,1,1,2,3253), -- Recipe: Divine Gloves
(21630,4042,1,1,2,1941), -- Enria
(21630,4608,1,1,2,259), -- Greater Dye of Intelligence <Int+3 Wit-3>
(21630,5155,1,1,2,233), -- Recipe: Soulshot (B) Compressed Package (100%)
(21630,6669,1,1,2,27079), -- Deluxe Chest Key - Grade 5
(21631,2091,1,1,-1,25159), -- Tsurugi Blade
(21631,2092,1,1,-1,25159), -- Homunkulus\'s Sword Blade
(21631,2353,1,1,-1,7531), -- Recipe: Samurai Longsword
(21631,57,1870,3780,0,700000), -- Adena
(21631,103,1,1,1,185), -- Tower Shield
(21631,107,1,1,1,185), -- Composite Shield
(21631,517,1,1,1,130), -- Composite Helmet
(21631,1149,1,1,1,130), -- Shining Circlet
(21631,1978,1,1,1,15297), -- Tower Shield Fragment
(21631,1983,1,1,1,10467), -- Shining Circlet Pattern
(21631,2957,1,1,1,10467), -- Composite Helmet Design
(21631,4055,1,1,1,15297), -- Composite Shield Fragment
(21631,1868,3,9,2,90914), -- Thread
(21631,1873,1,1,2,109097), -- Silver Nugget
(21631,1876,1,1,2,54548), -- Mithril Ore
(21631,1895,1,1,2,77926), -- Metallic Fiber
(21631,2357,1,1,2,445), -- Recipe: Crystal Dagger
(21631,3012,1,1,2,5089), -- Recipe: Full Plate Helmet
(21631,4042,1,1,2,4546), -- Enria
(21632,1918,1,1,-1,75951), -- Nassen\'s Earring Gemstone
(21632,2955,1,1,-1,110994), -- Theca Leather Gloves Texture
(21632,4042,1,1,-1,29228), -- Enria
(21632,57,708,1438,0,700000), -- Adena
(21632,400,1,1,1,27), -- Theca Leather Armor
(21632,401,1,1,1,14), -- Drake Leather Armor
(21632,420,1,1,1,42), -- Theca Leather Gaiters
(21632,1984,1,1,1,2314), -- Theca Leather Armor Pattern
(21632,1985,1,1,1,3722), -- Theca Leather Gaiters Pattern
(21632,1987,1,1,1,1647), -- Drake Leather Armor Texture
(21632,1865,1,1,2,80941), -- Varnish
(21632,1870,1,1,2,80941), -- Coal
(21632,1874,1,1,2,5396), -- Oriharukon Ore
(21632,4039,1,1,2,2699), -- Mold Glue
(21632,4043,1,1,2,2699), -- Asofe
(21632,4133,1,1,2,390), -- Recipe: Zubei\'s Breastplate
(21632,4941,1,1,2,623), -- Recipe: Zubei\'s Gaiters  (60%)
(21632,4959,1,1,2,1560), -- Recipe: Avadon Boots (60%)
(21633,1918,1,1,-1,107551), -- Nassen\'s Earring Gemstone
(21633,2955,1,1,-1,157174), -- Theca Leather Gloves Texture
(21633,4042,1,1,-1,41389), -- Enria
(21633,57,1003,2037,0,700000), -- Adena
(21633,400,1,1,1,38), -- Theca Leather Armor
(21633,401,1,1,1,20), -- Drake Leather Armor
(21633,420,1,1,1,60), -- Theca Leather Gaiters
(21633,1984,1,1,1,3276), -- Theca Leather Armor Pattern
(21633,1985,1,1,1,5270), -- Theca Leather Gaiters Pattern
(21633,1987,1,1,1,2332), -- Drake Leather Armor Texture
(21633,1865,1,1,2,114616), -- Varnish
(21633,1870,1,1,2,114616), -- Coal
(21633,1874,1,1,2,7641), -- Oriharukon Ore
(21633,4039,1,1,2,3821), -- Mold Glue
(21633,4043,1,1,2,3821), -- Asofe
(21633,4133,1,1,2,552), -- Recipe: Zubei\'s Breastplate
(21633,4941,1,1,2,882), -- Recipe: Zubei\'s Gaiters  (60%)
(21633,4959,1,1,2,2209), -- Recipe: Avadon Boots (60%)
(21634,1806,1,1,-1,9066), -- Recipe: Soulshot: B-Grade
(21634,1918,1,1,-1,196309), -- Nassen\'s Earring Gemstone
(21634,4039,1,1,-1,151093), -- Mold Glue
(21634,57,1830,3717,0,700000), -- Adena
(21634,135,1,1,1,14), -- Samurai Longsword
(21634,2115,1,1,1,1918), -- Samurai Longsword Blade
(21634,5286,1,1,1,14), -- Berserker Blade
(21634,5530,1,1,1,1920), -- Berserker Blade Edge
(21634,1806,1,1,2,558), -- Recipe: Soulshot: B-Grade
(21634,1894,1,1,2,9788), -- Crafted Leather
(21634,4039,1,1,2,9299), -- Mold Glue
(21634,4041,1,1,2,2426), -- Mold Hardener
(21634,4044,1,1,2,9299), -- Thons
(21634,4134,1,1,2,2146), -- Recipe: Zubei\'s Gaiters
(21635,1806,1,1,-1,3352), -- Recipe: Soulshot: B-Grade
(21635,1985,1,1,-1,57799), -- Theca Leather Gaiters Pattern
(21635,4937,1,1,-1,27660), -- Recipe: Adamantite Earrings (70%)
(21635,57,675,1375,0,700000), -- Adena
(21635,2436,1,1,1,33), -- Theca Leather Boots
(21635,2437,1,1,1,25), -- Drake Leather Boots
(21635,2438,1,1,1,25), -- Full Plate Boots
(21635,2460,1,1,1,33), -- Theca Leather Gloves
(21635,2461,1,1,1,25), -- Drake Leather Gloves
(21635,2462,1,1,1,25), -- Full Plate Gauntlets
(21635,2463,1,1,1,25), -- Divine Gloves
(21635,2954,1,1,1,2799), -- Theca Leather Boots Texture
(21635,2955,1,1,1,2799), -- Theca Leather Gloves Texture
(21635,2960,1,1,1,2408), -- Drake Leather Boots Design
(21635,2961,1,1,1,2408), -- Full Plate Boots Part
(21635,2962,1,1,1,2408), -- Drake Leather Gloves Design
(21635,2963,1,1,1,2408), -- Full Plate Gauntlets Part
(21635,2964,1,1,1,2408), -- Divine Gloves Pattern
(21635,1864,1,1,2,154723), -- Stem
(21635,1869,1,1,2,77362), -- Iron Ore
(21635,1878,1,1,2,30945), -- Braided Hemp
(21635,1884,1,1,2,47608), -- Cord
(21635,4039,1,1,2,2579), -- Mold Glue
(21635,4178,1,1,2,1420), -- Recipe: Zubei\'s Shield (100%)
(21635,4184,1,1,2,90), -- Recipe: Sprite\'s Staff
(21635,5160,1,1,2,155), -- Recipe: Spiritshot (B) Compressed Package (100%)
(21636,1806,1,1,-1,4747), -- Recipe: Soulshot: B-Grade
(21636,1985,1,1,-1,81846), -- Theca Leather Gaiters Pattern
(21636,4937,1,1,-1,39167), -- Recipe: Adamantite Earrings (70%)
(21636,57,956,1948,0,700000), -- Adena
(21636,2436,1,1,1,46), -- Theca Leather Boots
(21636,2437,1,1,1,35), -- Drake Leather Boots
(21636,2438,1,1,1,35), -- Full Plate Boots
(21636,2460,1,1,1,46), -- Theca Leather Gloves
(21636,2461,1,1,1,35), -- Drake Leather Gloves
(21636,2462,1,1,1,35), -- Full Plate Gauntlets
(21636,2463,1,1,1,35), -- Divine Gloves
(21636,2954,1,1,1,3963), -- Theca Leather Boots Texture
(21636,2955,1,1,1,3963), -- Theca Leather Gloves Texture
(21636,2960,1,1,1,3410), -- Drake Leather Boots Design
(21636,2961,1,1,1,3410), -- Full Plate Boots Part
(21636,2962,1,1,1,3410), -- Drake Leather Gloves Design
(21636,2963,1,1,1,3410), -- Full Plate Gauntlets Part
(21636,2964,1,1,1,3410), -- Divine Gloves Pattern
(21636,1864,1,1,2,219096), -- Stem
(21636,1869,1,1,2,109548), -- Iron Ore
(21636,1878,1,1,2,43820), -- Braided Hemp
(21636,1884,1,1,2,67415), -- Cord
(21636,4039,1,1,2,3652), -- Mold Glue
(21636,4178,1,1,2,2011), -- Recipe: Zubei\'s Shield (100%)
(21636,4184,1,1,2,127), -- Recipe: Sprite\'s Staff
(21636,5160,1,1,2,219), -- Recipe: Spiritshot (B) Compressed Package (100%)
(21637,2115,1,1,-1,19848), -- Samurai Longsword Blade
(21637,2116,1,1,-1,20383), -- Deadman\'s Staff Head
(21637,4141,1,1,-1,20829), -- Recipe: Avadon Breastplate
(21637,57,1746,3555,0,700000), -- Adena
(21637,135,1,1,1,14), -- Samurai Longsword
(21637,2115,1,1,1,1833), -- Samurai Longsword Blade
(21637,5286,1,1,1,14), -- Berserker Blade
(21637,5530,1,1,1,1835), -- Berserker Blade Edge
(21637,1864,4,12,2,57130), -- Stem
(21637,1865,2,6,2,45704), -- Varnish
(21637,1866,3,9,2,25392), -- Suede
(21637,1868,1,3,2,152347), -- Thread
(21637,1873,1,1,2,91408), -- Silver Nugget
(21637,4142,1,1,2,1758), -- Recipe: Avadon Gaiters
(21637,4936,1,1,2,4194), -- Recipe: Avadon Shield (60%)
(21638,1900,1,1,-1,41596), -- Enchanted Necklace Chain
(21638,1935,1,1,-1,21240), -- Scale Mail Fragment
(21638,2203,1,1,-1,82830), -- Recipe: Mithril Boots
(21638,57,161,320,0,700000), -- Adena
(21638,316,1,1,1,14), -- Blood of Saints
(21638,317,1,1,1,14), -- Tome of Blood
(21638,2030,1,1,1,789), -- Tome of Blood Page
(21638,1874,1,1,2,1926), -- Oriharukon Ore
(21638,1878,1,1,2,11551), -- Braided Hemp
(21638,1884,1,1,2,17771), -- Cord
(21638,1889,1,1,2,1926), -- Compound Braid
(21638,2153,1,1,2,4492), -- Recipe: Tiger\'s Eye Earring
(21638,2977,1,1,2,3866), -- Recipe: Brigandine Boots
(21638,5220,1,1,2,1156), -- Metal Hardener
(21639,2021,1,1,-1,5670), -- Spinebone Sword Blade
(21639,2153,1,1,-1,69838), -- Recipe: Tiger\'s Eye Earring
(21639,2184,1,1,-1,47170), -- Recipe: Mithril Banded Gaiters
(21639,57,189,379,0,700000), -- Adena
(21639,83,1,1,1,12), -- Sword of Magic
(21639,124,1,1,1,9), -- Two-Handed Sword
(21639,127,1,1,1,9), -- Crimson Sword
(21639,130,1,1,1,9), -- Elven Sword
(21639,144,1,1,1,12), -- Sword of Occult
(21639,2026,1,1,1,480), -- Two-Handed Sword Edge
(21639,1875,1,1,2,2653), -- Stone of Purity
(21639,1879,1,1,2,6633), -- Cokes
(21639,1885,1,1,2,3317), -- High Grade Suede
(21639,2250,1,1,2,9949), -- Recipe: Bone Arrow
(21639,5549,1,1,2,3980), -- Metallic Thread
(21639,5550,1,1,2,531), -- Durable Metal Plate
(21640,6036,1,1,-1,15233), -- Greater Magic Haste Potion
(21640,57,129,257,0,700000), -- Adena
(21640,1825,1,1,2,18481), -- Recipe: Oriharukon
(21640,6667,1,1,2,161705), -- Deluxe Chest Key - Grade 3
(21641,1956,1,1,-1,66115), -- Square Shield Fragment
(21641,2154,1,1,-1,62363), -- Recipe: Elven Earring
(21641,2302,1,1,-1,2544), -- Recipe: Silver Axe
(21641,57,246,491,0,700000), -- Adena
(21641,88,1,1,1,5), -- Morning Star
(21641,90,1,1,1,5), -- Goat Head Staff
(21641,158,1,1,1,5), -- Tarbar
(21641,169,1,1,1,5), -- Skull Breaker
(21641,172,1,1,1,5), -- Heavy Bone Club
(21641,2031,1,1,1,305), -- Morning Star Head
(21641,2032,1,1,1,279), -- Goat Head Staff Head
(21641,2035,1,1,1,305), -- Tarbar Head
(21641,2036,1,1,1,305), -- Skull Breaker Head
(21641,2037,1,1,1,305), -- Heavy Bone Club Head
(21641,1341,10,30,2,125454), -- Bone Arrow
(21641,1874,1,1,2,2510), -- Oriharukon Ore
(21641,1878,1,1,2,15055), -- Braided Hemp
(21641,1884,1,1,2,23161), -- Cord
(21641,1889,1,1,2,2510), -- Compound Braid
(21641,2190,1,1,2,2689), -- Recipe: Mithril Stockings
(21641,2279,1,1,2,269), -- Recipe: War Pick
(21641,5220,1,1,2,1506), -- Metal Hardener
(21642,1868,1,3,-1,534538), -- Thread
(21642,1904,1,1,-1,49887), -- Elven Necklace Beads
(21642,2145,1,1,-1,38181), -- Recipe: Mithril Alloy
(21642,57,226,451,0,700000), -- Adena
(21642,279,1,1,1,20), -- Strengthened Long Bow
(21642,2040,1,1,1,1599), -- Strengthened Long Bow Shaft
(21642,1868,1,1,2,92106), -- Thread
(21642,1873,1,1,2,18422), -- Silver Nugget
(21642,1876,1,1,2,9211), -- Mithril Ore
(21642,1895,1,1,2,13158), -- Metallic Fiber
(21642,2146,1,1,2,3290), -- Recipe: Artisan\'s frame
(21642,2285,1,1,2,256), -- Recipe: Claymore
(21643,1868,1,3,-1,679213), -- Thread
(21643,1904,1,1,-1,63389), -- Elven Necklace Beads
(21643,2145,1,1,-1,48515), -- Recipe: Mithril Alloy
(21643,57,287,572,0,700000), -- Adena
(21643,279,1,1,1,26), -- Strengthened Long Bow
(21643,2040,1,1,1,2031), -- Strengthened Long Bow Shaft
(21643,1868,1,1,2,117034), -- Thread
(21643,1873,1,1,2,23407), -- Silver Nugget
(21643,1876,1,1,2,11704), -- Mithril Ore
(21643,1895,1,1,2,16720), -- Metallic Fiber
(21643,2146,1,1,2,4180), -- Recipe: Artisan\'s frame
(21643,2285,1,1,2,326), -- Recipe: Claymore
(21644,2026,1,1,-1,3925), -- Two-Handed Sword Edge
(21644,2155,1,1,-1,52351), -- Recipe: Elven Ring
(21644,5550,1,1,-1,4349), -- Durable Metal Plate
(21644,57,138,275,0,700000), -- Adena
(21644,395,1,1,1,38), -- Manticore Skin Shirt
(21644,417,1,1,1,61), -- Manticore Skin Gaiters
(21644,1942,1,1,1,2150), -- Manticore Skin Shirt Texture
(21644,1943,1,1,1,3348), -- Manticore Skin Gaiters Pattern
(21644,1875,1,1,2,1405), -- Stone of Purity
(21644,1879,1,1,2,3513), -- Cokes
(21644,1885,1,1,2,1757), -- High Grade Suede
(21644,2278,1,1,2,151), -- Recipe: Strengthened Long Bow
(21644,2286,1,1,2,118), -- Recipe: Bonebreaker
(21644,2977,1,1,2,2822), -- Recipe: Brigandine Boots
(21644,5549,1,1,2,2108), -- Metallic Thread
(21644,5550,1,1,2,281), -- Durable Metal Plate
(21645,1870,1,1,-1,597803), -- Coal
(21645,2029,1,1,-1,7131), -- Gastraphetes Shaft
(21645,5549,1,1,-1,59780), -- Metallic Thread
(21645,57,251,500,0,700000), -- Adena
(21645,850,1,1,1,111), -- Elven Earring
(21645,881,1,1,1,166), -- Elven Ring
(21645,913,1,1,1,83), -- Elven Necklace
(21645,1902,1,1,1,5219), -- Elven Earring Beads
(21645,1903,1,1,1,8592), -- Elven Ring Piece
(21645,1904,1,1,1,4807), -- Elven Necklace Beads
(21645,1341,10,30,2,114456), -- Bone Arrow
(21645,1832,1,1,2,38152), -- Greater Antidote
(21645,1875,1,1,2,2290), -- Stone of Purity
(21645,1879,1,1,2,5723), -- Cokes
(21645,1885,1,1,2,2862), -- High Grade Suede
(21645,2188,1,1,2,2453), -- Recipe: Manticore Skin Gaiters
(21645,5473,1,1,2,2453), -- Recipe: Durable Metal Plate(100%)
(21645,5549,1,1,2,3434), -- Metallic Thread
(21645,5550,1,1,2,458), -- Durable Metal Plate
(21646,730,1,1,-1,2931), -- Scroll: Enchant Armor (Grade A)
(21646,1894,1,1,-1,123396), -- Crafted Leather
(21646,5508,1,1,-1,82457), -- Sealed Dark Crystal Gloves Design
(21646,57,1417,2886,0,700000), -- Adena
(21646,5289,1,1,1,20), -- Sealed Dark Crystal Helmet
(21646,5292,1,1,1,29), -- Sealed Dark Crystal Shield
(21646,5294,1,1,1,20), -- Sealed Tallum Helmet
(21646,5494,1,1,1,3636), -- Sealed Dark Crystal Shield Fragment
(21646,5525,1,1,1,2677), -- Sealed Dark Crystal Helmet Design
(21646,5526,1,1,1,2677), -- Sealed Tallum Helm Design
(21646,1344,10,30,2,185501), -- Mithril Arrow
(21646,1867,1,3,2,98934), -- Animal Skin
(21646,1872,1,3,2,65957), -- Animal Bone
(21646,1882,1,1,2,32979), -- Leather
(21646,1894,1,1,2,5207), -- Crafted Leather
(21646,4042,1,1,2,2474), -- Enria
(21646,5277,1,1,2,67), -- Recipe: Greater Spiritshot (S) Compressed Package(100%)
(21647,4044,1,1,-1,98893), -- Thons
(21647,5462,1,1,-1,1099), -- Recipe: Branch of The Mother Tree(60%)
(21647,5509,1,1,-1,69561), -- Sealed Tallum Gloves Design
(21647,57,1196,2434,0,700000), -- Adena
(21647,5287,1,1,1,7), -- Sealed Dark Crystal breastplate
(21647,5288,1,1,1,11), -- Sealed Dark Crystal Gaiters
(21647,5293,1,1,1,5), -- Sealed Tallum Plate Armor
(21647,5520,1,1,1,942), -- Sealed Dark Crystal Breastplate Pattern
(21647,5521,1,1,1,665), -- Sealed Tallum Plate Armor Pattern
(21647,5524,1,1,1,1440), -- Sealed Dark Crystal Gaiters Pattern
(21647,1868,1,1,2,292115), -- Thread
(21647,1873,1,1,2,58423), -- Silver Nugget
(21647,1889,1,1,2,9738), -- Compound Braid
(21647,4044,1,1,2,4869), -- Thons
(21647,5282,1,1,2,65), -- Recipe: Greater Blessed Spiritshot (S) Compressed Package(100%)
(21647,5549,1,1,2,14606), -- Metallic Thread
(21648,5464,1,1,-1,1200), -- Recipe: Dark Legion\'s Edge(60%)
(21648,5482,1,1,-1,42777), -- Sealed Dark Crystalline Leggings Design
(21648,5485,1,1,-1,27253), -- Sealed Tallum Tunic Texture
(21648,57,1305,2660,0,700000), -- Adena
(21648,5289,1,1,1,19), -- Sealed Dark Crystal Helmet
(21648,5292,1,1,1,27), -- Sealed Dark Crystal Shield
(21648,5294,1,1,1,19), -- Sealed Tallum Helmet
(21648,5494,1,1,1,3351), -- Sealed Dark Crystal Shield Fragment
(21648,5525,1,1,1,2467), -- Sealed Dark Crystal Helmet Design
(21648,5526,1,1,1,2467), -- Sealed Tallum Helm Design
(21648,1344,40,120,2,42738), -- Mithril Arrow
(21648,1867,1,3,2,60783), -- Animal Skin
(21648,1869,2,6,2,27353), -- Iron Ore
(21648,1870,1,1,2,136762), -- Coal
(21648,1871,1,1,2,136762), -- Charcoal
(21648,1872,1,3,2,91175), -- Animal Bone
(21648,5167,1,1,2,61), -- Recipe: Blessed Spiritshot (S) Compressed Package (100%)
(21649,729,1,1,-1,426), -- Scroll: Enchant Weapon (Grade A)
(21649,1894,1,1,-1,134512), -- Crafted Leather
(21649,4044,1,1,-1,127787), -- Thons
(21649,57,1544,3147,0,700000), -- Adena
(21649,5287,1,1,1,9), -- Sealed Dark Crystal breastplate
(21649,5288,1,1,1,14), -- Sealed Dark Crystal Gaiters
(21649,5293,1,1,1,6), -- Sealed Tallum Plate Armor
(21649,5520,1,1,1,1218), -- Sealed Dark Crystal Breastplate Pattern
(21649,5521,1,1,1,859), -- Sealed Tallum Plate Armor Pattern
(21649,5524,1,1,1,1861), -- Sealed Dark Crystal Gaiters Pattern
(21649,1894,1,1,2,7947), -- Crafted Leather
(21649,4039,1,1,2,7550), -- Mold Glue
(21649,4041,1,1,2,1970), -- Mold Hardener
(21649,4044,1,1,2,7550), -- Thons
(21649,5272,1,1,2,101), -- Recipe: Greater Soulshot (S) Compressed Package(100%)
(21650,5162,1,1,-1,1562), -- Recipe: Spiritshot (S) Compressed Package (100%)
(21650,5167,1,1,-1,1562), -- Recipe: Blessed Spiritshot (S) Compressed Package (100%)
(21650,5514,1,1,-1,59368), -- Sealed Gloves of Nightmare Design
(21650,57,1415,2887,0,700000), -- Adena
(21650,235,1,1,1,6), -- Bloody Orchid
(21650,5536,1,1,1,1767), -- Bloody Orchid Head
(21650,1344,10,30,2,216318), -- Mithril Arrow
(21650,1895,1,1,2,49445), -- Metallic Fiber
(21650,3957,1,1,2,77), -- Recipe: Blessed Spiritshot S
(21650,4040,1,1,2,3462), -- Mold Lubricant
(21650,4042,1,1,2,2885), -- Enria
(21650,4043,1,1,2,5769), -- Asofe
(21651,1889,1,1,-1,223871), -- Compound Braid
(21651,4044,1,1,-1,111935), -- Thons
(21651,5515,1,1,-1,56714), -- Sealed Majestic Gloves Design
(21651,57,1352,2758,0,700000), -- Adena
(21651,212,1,1,1,3), -- Dasparion\'s Staff
(21651,2504,1,1,1,3), -- Meteor Shower
(21651,5532,1,1,1,836), -- Meteor Shower Head
(21651,5543,1,1,1,844), -- Dasparion\'s Staff Edge
(21651,1868,1,1,2,330641), -- Thread
(21651,1873,1,1,2,66129), -- Silver Nugget
(21651,1889,1,1,2,11022), -- Compound Braid
(21651,4044,1,1,2,5511), -- Thons
(21651,5157,1,1,2,74), -- Recipe: Soulshot (S) Compressed Package (100%)
(21651,5549,1,1,2,16533), -- Metallic Thread
(21652,5272,1,1,-1,6225), -- Recipe: Greater Soulshot (S) Compressed Package(100%)
(21652,5277,1,1,-1,6225), -- Recipe: Greater Spiritshot (S) Compressed Package(100%)
(21652,5545,1,1,-1,38425), -- Dark Legion\'s Edge Blade
(21652,57,5636,11501,0,700000), -- Adena
(21652,305,1,1,1,16), -- Tallum Glaive
(21652,5541,1,1,1,5673), -- Tallum Glaive Edge
(21652,959,1,1,2,28), -- Scroll: Enchant Weapon (Grade S)
(21652,1867,4,12,2,114922), -- Animal Skin
(21652,1872,7,21,2,61292), -- Animal Bone
(21652,1882,1,1,2,153229), -- Leather
(21652,1894,1,1,2,24195), -- Crafted Leather
(21652,4042,1,1,2,11493), -- Enria
(21653,5157,1,1,-1,5300), -- Recipe: Soulshot (S) Compressed Package (100%)
(21653,5544,1,1,-1,32679), -- Branch of The Mother Tree Head
(21653,5545,1,1,-1,32718), -- Dark Legion\'s Edge Blade
(21653,57,4798,9794,0,700000), -- Adena
(21653,270,1,1,1,14), -- Dragon Grinder
(21653,5538,1,1,1,4832), -- Dragon Grinder Edge
(21653,960,1,1,2,235), -- Scroll: Enchant Armor (Grade S)
(21653,1344,60,180,2,122314), -- Mithril Arrow
(21653,1895,1,1,2,167744), -- Metallic Fiber
(21653,4040,1,1,2,11743), -- Mold Lubricant
(21653,4042,1,1,2,9785), -- Enria
(21653,4043,1,1,2,19571), -- Asofe
(21654,4042,1,1,-1,219733), -- Enria
(21654,5167,1,1,-1,5860), -- Recipe: Blessed Spiritshot (S) Compressed Package (100%)
(21654,5488,1,1,-1,59369), -- Sealed Majestic Robe Fabric
(21654,57,5293,10839,0,700000), -- Adena
(21654,81,1,1,1,5), -- Dragon Slayer
(21654,151,1,1,1,5), -- Sword of Miracles 
(21654,2500,1,1,1,5), -- Dark Legion\'s Edge
(21654,5529,1,1,1,1782), -- Dragon Slayer Edge
(21654,5545,1,1,1,1782), -- Dark Legion\'s Edge Blade
(21654,5546,1,1,1,1957), -- Sword of Miracles Edge
(21654,960,1,1,2,223), -- Scroll: Enchant Armor (Grade S)
(21654,1344,40,120,2,173855), -- Mithril Arrow
(21654,1867,5,15,2,74178), -- Animal Skin
(21654,1872,9,27,2,41211), -- Animal Bone
(21654,1882,1,1,2,123631), -- Leather
(21654,1894,1,1,2,19521), -- Crafted Leather
(21654,4042,1,1,2,9273), -- Enria
(21655,6344,1,1,-1,184250), -- Sealed Majestic Necklace Beads
(21655,6346,1,1,-1,409201), -- Sealed Majestic Ring Gemstone
(21655,6901,1,1,-1,12569), -- Recipe: Shining Arrow (100%)
(21655,57,5046,10335,0,700000), -- Adena
(21655,5311,1,1,1,19), -- Sealed Armor of Nightmare
(21655,5316,1,1,1,19), -- Sealed Majestic Plate Armor
(21655,5522,1,1,1,3161), -- Sealed Armor of Nightmare Pattern
(21655,5523,1,1,1,3161), -- Sealed Majestic Plate Armor Pattern
(21655,960,1,1,2,213), -- Scroll: Enchant Armor (Grade S)
(21655,1344,100,300,2,66297), -- Mithril Arrow
(21655,1865,9,27,2,29465), -- Varnish
(21655,1870,2,6,2,132593), -- Coal
(21655,1875,1,1,2,35359), -- Stone of Purity
(21655,1879,1,1,2,88395), -- Cokes
(21655,4040,1,1,2,10608), -- Mold Lubricant
(21656,6704,1,1,-1,268758), -- Sealed Imperial Crusader Boots Design
(21656,6705,1,1,-1,263248), -- Sealed Imperial Crusader Shield Part
(21656,6706,1,1,-1,306208), -- Sealed Imperial Crusader Helmet Pattern
(21656,57,7595,15500,0,700000), -- Adena
(21656,5312,1,1,1,71), -- Sealed Helm of Nightmare
(21656,5315,1,1,1,101), -- Sealed Shield of Nightmare
(21656,5317,1,1,1,71), -- Sealed Majestic Circlet
(21656,5495,1,1,1,14111), -- Sealed Shield of Nightmare Fragment
(21656,5527,1,1,1,11111), -- Sealed Helm of Nightmare Design
(21656,5528,1,1,1,11111), -- Sealed Majestic Circlet Design
(21656,960,1,1,2,319), -- Scroll: Enchant Armor (Grade S)
(21656,1344,280,840,2,35560), -- Mithril Arrow
(21656,1867,9,27,2,59003), -- Animal Skin
(21656,1872,5,15,2,106205), -- Animal Bone
(21656,1875,1,1,2,53103), -- Stone of Purity
(21656,1881,1,1,2,106205), -- Coarse Bone Powder
(21656,4041,1,1,2,6927), -- Mold Hardener
(21657,6688,1,1,-1,38019), -- Forgotten Blade Edge
(21657,6689,1,1,-1,37303), -- Basalt Battlehammer Head
(21657,6690,1,1,-1,38092), -- Imperial Staff Head
(21657,57,7076,14446,0,700000), -- Adena
(21657,5320,1,1,1,34), -- Sealed Leather Armor of Nightmare
(21657,5323,1,1,1,34), -- Sealed Majestic Leather Armor
(21657,5480,1,1,1,5830), -- Sealed Leather Armor of Nightmare Fabric
(21657,5481,1,1,1,5830), -- Sealed Majestic Leather Armor Fabric
(21657,960,1,1,2,297), -- Scroll: Enchant Armor (Grade S)
(21657,1344,100,300,2,92779), -- Mithril Arrow
(21657,1865,9,27,2,41236), -- Varnish
(21657,1870,14,42,2,26509), -- Coal
(21657,1875,1,1,2,49483), -- Stone of Purity
(21657,1879,1,1,2,123706), -- Cokes
(21657,4040,1,1,2,14845), -- Mold Lubricant
(21658,1876,1,1,-1,594082), -- Mithril Ore
(21658,4052,1,1,-1,105166), -- Earring of Black Ore Piece
(21658,57,1203,2433,0,700000), -- Adena
(21658,79,1,1,1,7), -- Sword of Damascus
(21658,4114,1,1,1,1921), -- Sword of Damascus Blade
(21658,1343,10,30,2,179065), -- Silver Arrow
(21658,1807,1,1,2,168), -- Recipe: Soulshot: A-Grade
(21658,1876,1,1,2,25069), -- Mithril Ore
(21658,1877,1,1,2,5014), -- Adamantite Nugget
(21658,1880,1,1,2,12535), -- Steel
(21658,1881,1,1,2,16713), -- Coarse Bone Powder
(21658,1882,1,1,2,27855), -- Leather
(21659,1061,1,1,-1,770744), -- Healing Potion
(21659,1869,1,3,-1,635864), -- Iron Ore
(21659,1900,1,1,-1,139139), -- Enchanted Necklace Chain
(21659,57,536,1073,0,700000), -- Adena
(21659,46,1,1,1,1390), -- Bronze Helmet
(21659,627,1,1,1,1986), -- Aspis
(21659,737,1,1,2,11583), -- Scroll of Resurrection
(21659,1864,1,1,2,231650), -- Stem
(21659,1869,1,1,2,115825), -- Iron Ore
(21659,1880,1,1,2,11583), -- Steel
(21659,5550,1,1,2,1545), -- Durable Metal Plate
(21659,6387,1,1,2,4633), -- Blessed Scroll of Resurrection for Pets
(21660,1870,1,3,-1,887208), -- Coal
(21660,1940,1,1,-1,264838), -- Iron Boots Design
(21660,2190,1,1,-1,126744), -- Recipe: Mithril Stockings
(21660,57,749,1495,0,700000), -- Adena
(21660,63,1,1,1,531), -- Gauntlets
(21660,553,1,1,1,531), -- Iron Boots
(21660,1940,1,1,1,20116), -- Iron Boots Design
(21660,2422,1,1,1,531), -- Reinforced Leather Boots
(21660,2423,1,1,1,531), -- Boots of Knowledge
(21660,2446,1,1,1,531), -- Reinforced Leather Gloves
(21660,2447,1,1,1,531), -- Gloves of Knowledge
(21660,1865,1,1,2,235862), -- Varnish
(21660,1870,1,3,2,117931), -- Coal
(21660,1874,1,1,2,15725), -- Oriharukon Ore
(21660,2192,1,1,2,30085), -- Recipe: Kite Shield
(21661,1875,1,1,-1,91332), -- Stone of Purity
(21661,1879,1,1,-1,228329), -- Cokes
(21661,1901,1,1,-1,189223), -- Tiger\'s Eye Earring Stone
(21661,57,579,1158,0,700000), -- Adena
(21661,278,1,1,1,76), -- Gastraphetes
(21661,2029,1,1,1,4345), -- Gastraphetes Shaft
(21661,1875,1,1,2,8094), -- Stone of Purity
(21661,1879,1,1,2,20234), -- Cokes
(21661,1885,1,1,2,10117), -- High Grade Suede
(21661,2154,1,1,2,12998), -- Recipe: Elven Earring
(21661,5549,1,1,2,12141), -- Metallic Thread
(21661,5550,1,1,2,1619), -- Durable Metal Plate
(21662,1876,1,1,-1,304870), -- Mithril Ore
(21662,2026,1,1,-1,18347), -- Two-Handed Sword Edge
(21662,2191,1,1,-1,204063), -- Recipe: RIP Gauntlets
(21662,57,644,1285,0,700000), -- Adena
(21662,849,1,1,1,631), -- Tiger\'s Eye Earring
(21662,880,1,1,1,947), -- Black Pearl Ring
(21662,912,1,1,1,473), -- Near Forest Necklace
(21662,1901,1,1,1,27987), -- Tiger\'s Eye Earring Stone
(21662,1876,1,1,2,27017), -- Mithril Ore
(21662,1877,1,1,2,5404), -- Adamantite Nugget
(21662,1880,1,1,2,13509), -- Steel
(21662,1881,1,1,2,18011), -- Coarse Bone Powder
(21662,1882,1,1,2,30018), -- Leather
(21662,2193,1,1,2,18084), -- Recipe: Boots of Power
(21663,1938,1,1,-1,100705), -- Mithril Banded Mail Material
(21663,1939,1,1,-1,131576), -- Mithril Banded Gaiters Material
(21663,2154,1,1,-1,160385), -- Recipe: Elven Earring
(21663,57,633,1266,0,700000), -- Adena
(21663,849,1,1,1,620), -- Tiger\'s Eye Earring
(21663,880,1,1,1,931), -- Black Pearl Ring
(21663,912,1,1,1,465), -- Near Forest Necklace
(21663,1901,1,1,1,27502), -- Tiger\'s Eye Earring Stone
(21663,1874,1,1,2,8850), -- Oriharukon Ore
(21663,1878,1,1,2,53098), -- Braided Hemp
(21663,1884,1,1,2,81689), -- Cord
(21663,1889,1,1,2,8850), -- Compound Braid
(21663,2155,1,1,2,21308), -- Recipe: Elven Ring
(21663,5220,1,1,2,5310), -- Metal Hardener
(21664,1933,1,1,-1,96826), -- Dark Stocking Fabric
(21664,2153,1,1,-1,127997), -- Recipe: Tiger\'s Eye Earring
(21664,2183,1,1,-1,54146), -- Recipe: Mithril Banded Mail
(21664,57,347,694,0,700000), -- Adena
(21664,848,1,1,1,528), -- Enchanted Earring
(21664,879,1,1,1,792), -- Enchanted Ring
(21664,911,1,1,1,396), -- Enchanted Necklace
(21664,1900,1,1,1,12302), -- Enchanted Necklace Chain
(21664,955,1,1,2,360), -- Scroll: Enchant Weapon (Grade D)
(21664,1864,1,1,2,179900), -- Stem
(21664,1869,1,1,2,89950), -- Iron Ore
(21664,1880,1,1,2,8996), -- Steel
(21664,5550,1,1,2,1200), -- Durable Metal Plate
(21665,2027,1,1,-1,17685), -- Spiked Club Head
(21665,2028,1,1,-1,16040), -- Shilen Knife Edge
(21665,2192,1,1,-1,172191), -- Recipe: Kite Shield
(21665,57,570,1138,0,700000), -- Adena
(21665,436,1,1,1,473), -- Tunic of Knowledge
(21665,469,1,1,1,754), -- Stockings of Knowledge
(21665,1341,10,30,2,341801), -- Bone Arrow
(21665,1875,1,1,2,6836), -- Stone of Purity
(21665,1879,1,1,2,17090), -- Cokes
(21665,1885,1,1,2,8546), -- High Grade Suede
(21665,2269,1,1,2,733), -- Recipe: Morning Star
(21665,5549,1,1,2,10255), -- Metallic Thread
(21665,5550,1,1,2,1368), -- Durable Metal Plate
(21666,955,1,1,-1,4130), -- Scroll: Enchant Weapon (Grade D)
(21666,1872,1,3,-1,688304), -- Animal Bone
(21666,1935,1,1,-1,57679), -- Scale Mail Fragment
(21666,57,436,871,0,700000), -- Adena
(21666,69,1,1,1,36), -- Bastard Sword
(21666,125,1,1,1,36), -- Spinebone Sword
(21666,126,1,1,1,36), -- Artisan\'s Sword
(21666,128,1,1,1,36), -- Knight\'s Sword
(21666,2021,1,1,1,1425), -- Spinebone Sword Blade
(21666,956,1,1,2,3762), -- Scroll: Enchant Armor (Grade D)
(21666,1867,1,1,2,150453), -- Animal Skin
(21666,1872,1,1,2,150453), -- Animal Bone
(21666,1875,1,1,2,7523), -- Stone of Purity
(21666,1881,1,1,2,15046), -- Coarse Bone Powder
(21667,1874,1,1,-1,80757), -- Oriharukon Ore
(21667,1940,1,1,-1,180800), -- Iron Boots Design
(21667,2155,1,1,-1,194440), -- Recipe: Elven Ring
(21667,57,512,1024,0,700000), -- Adena
(21667,47,1,1,1,846), -- Helmet
(21667,628,1,1,1,1209), -- Hoplon
(21667,1874,1,1,2,7157), -- Oriharukon Ore
(21667,1878,1,1,2,42939), -- Braided Hemp
(21667,1884,1,1,2,66060), -- Cord
(21667,1889,1,1,2,7157), -- Compound Braid
(21667,2156,1,1,2,8588), -- Recipe: Elven Necklace
(21667,5220,1,1,2,4294), -- Metal Hardener
(21668,1832,1,3,-1,603864), -- Greater Antidote
(21668,1864,1,5,-1,724636), -- Stem
(21668,1936,1,1,-1,88949), -- White Tunic Pattern
(21668,57,459,917,0,700000), -- Adena
(21668,348,1,1,1,224), -- Scale Mail
(21668,377,1,1,1,357), -- Scale Gaiters
(21668,1935,1,1,1,8296), -- Scale Mail Fragment
(21668,1937,1,1,1,12758), -- Scale Gaiters Fragment
(21668,1061,1,1,2,59999), -- Healing Potion
(21668,1829,1,1,2,39599), -- Scroll of Escape: Clan Hall
(21668,1864,1,1,2,197994), -- Stem
(21668,1869,1,1,2,98997), -- Iron Ore
(21668,1880,1,1,2,9900), -- Steel
(21668,5550,1,1,2,1321), -- Durable Metal Plate
(21669,2026,1,1,-1,15353), -- Two-Handed Sword Edge
(21669,2156,1,1,-1,102046), -- Recipe: Elven Necklace
(21669,5550,1,1,-1,17008), -- Durable Metal Plate
(21669,57,539,1078,0,700000), -- Adena
(21669,316,1,1,1,47), -- Blood of Saints
(21669,317,1,1,1,47), -- Tome of Blood
(21669,2030,1,1,1,2645), -- Tome of Blood Page
(21669,1341,20,60,2,188394), -- Bone Arrow
(21669,1864,1,3,2,75358), -- Stem
(21669,1869,1,1,2,113036), -- Iron Ore
(21669,1880,1,1,2,11304), -- Steel
(21669,2186,1,1,2,3781), -- Recipe: Brigandine Tunic
(21669,5550,1,1,2,1508), -- Durable Metal Plate
(21670,1878,1,1,-1,601988), -- Braided Hemp
(21670,1884,1,1,-1,926136), -- Cord
(21670,2029,1,1,-1,17952), -- Gastraphetes Shaft
(21670,57,636,1268,0,700000), -- Adena
(21670,393,1,1,1,176), -- Mithril Banded Mail
(21670,394,1,1,1,176), -- Reinforced Leather Shirt
(21670,415,1,1,1,281), -- Mithril Banded Gaiters
(21670,416,1,1,1,281), -- Reinforced Leather Gaiters
(21670,1938,1,1,1,8967), -- Mithril Banded Mail Material
(21670,1939,1,1,1,11715), -- Mithril Banded Gaiters Material
(21670,1874,1,1,2,8891), -- Oriharukon Ore
(21670,1878,1,1,2,53346), -- Braided Hemp
(21670,1884,1,1,2,82070), -- Cord
(21670,1889,1,1,2,8891), -- Compound Braid
(21670,2270,1,1,2,953), -- Recipe: Goat Head Staff
(21670,5220,1,1,2,5335), -- Metal Hardener
(21671,1937,1,1,-1,38014), -- Scale Gaiters Fragment
(21671,2184,1,1,-1,46479), -- Recipe: Mithril Banded Gaiters
(21671,2185,1,1,-1,87103), -- Recipe: Iron Boots
(21671,57,187,373,0,700000), -- Adena
(21671,605,1,1,1,726), -- Leather Gauntlets
(21671,1123,1,1,1,726), -- Blue Buckskin Boots
(21671,1830,1,1,2,13817), -- Scroll of Escape: Castle
(21671,1876,1,1,2,6909), -- Mithril Ore
(21671,1877,1,1,2,1382), -- Adamantite Nugget
(21671,1880,1,1,2,3455), -- Steel
(21671,1881,1,1,2,4606), -- Coarse Bone Powder
(21671,1882,1,1,2,7677), -- Leather
(21671,6667,1,1,2,21589), -- Deluxe Chest Key - Grade 3
(21672,2030,1,1,-1,37052), -- Tome of Blood Page
(21672,2193,1,1,-1,424088), -- Recipe: Boots of Power
(21672,2269,1,1,-1,22628), -- Recipe: Morning Star
(21672,57,1338,2670,0,700000), -- Adena
(21672,157,1,1,1,117), -- Spiked Club
(21672,186,1,1,1,117), -- Staff of Magic
(21672,2027,1,1,1,7355), -- Spiked Club Head
(21672,1864,4,12,2,70183), -- Stem
(21672,1865,2,6,2,56146), -- Varnish
(21672,1866,3,9,2,31192), -- Suede
(21672,1868,1,3,2,187152), -- Thread
(21672,1873,1,1,2,112291), -- Silver Nugget
(21672,2271,1,1,2,2006), -- Recipe: Winged Spear
(21673,1889,1,1,-1,215196), -- Compound Braid
(21673,1901,1,1,-1,445848), -- Tiger\'s Eye Earring Stone
(21673,5220,1,1,-1,129118), -- Metal Hardener
(21673,57,1363,2720,0,700000), -- Adena
(21673,393,1,1,1,377), -- Mithril Banded Mail
(21673,394,1,1,1,377), -- Reinforced Leather Shirt
(21673,415,1,1,1,601), -- Mithril Banded Gaiters
(21673,416,1,1,1,601), -- Reinforced Leather Gaiters
(21673,1938,1,1,1,19232), -- Mithril Banded Mail Material
(21673,1939,1,1,1,25127), -- Mithril Banded Gaiters Material
(21673,1874,1,1,2,19070), -- Oriharukon Ore
(21673,1878,1,1,2,114418), -- Braided Hemp
(21673,1884,1,1,2,176028), -- Cord
(21673,1889,1,1,2,19070), -- Compound Braid
(21673,2272,1,1,2,2043), -- Recipe: Sword of Revolution
(21673,5220,1,1,2,11442), -- Metal Hardener
(21674,1938,1,1,-1,8463), -- Mithril Banded Mail Material
(21674,1939,1,1,-1,11057), -- Mithril Banded Gaiters Material
(21674,2270,1,1,-1,899), -- Recipe: Goat Head Staff
(21674,57,53,106,0,700000), -- Adena
(21674,260,1,1,1,14), -- Triple-Edged Jamadhr
(21674,1875,1,1,2,638), -- Stone of Purity
(21674,1879,1,1,2,1594), -- Cokes
(21674,1885,1,1,2,797), -- High Grade Suede
(21674,2273,1,1,2,69), -- Recipe: Tarbar
(21674,5549,1,1,2,957), -- Metallic Thread
(21674,5550,1,1,2,128), -- Durable Metal Plate
(21674,6036,1,1,2,319), -- Greater Magic Haste Potion
(21675,956,1,1,-1,8761), -- Scroll: Enchant Armor (Grade D)
(21675,1880,1,1,-1,26283), -- Steel
(21675,2021,1,1,-1,3319), -- Spinebone Sword Blade
(21675,57,111,222,0,700000), -- Adena
(21675,292,1,1,1,45), -- Pike
(21675,1864,1,1,2,57452), -- Stem
(21675,1869,1,1,2,28726), -- Iron Ore
(21675,1880,1,1,2,2873), -- Steel
(21675,2153,1,1,2,4468), -- Recipe: Tiger\'s Eye Earring
(21675,5550,1,1,2,384), -- Durable Metal Plate
(21676,1865,1,7,-1,726143), -- Varnish
(21676,1870,1,7,-1,726143), -- Coal
(21676,2029,1,1,-1,34646), -- Gastraphetes Shaft
(21676,57,1227,2454,0,700000), -- Adena
(21676,849,1,1,1,1201), -- Tiger\'s Eye Earring
(21676,880,1,1,1,1805), -- Black Pearl Ring
(21676,912,1,1,1,901), -- Near Forest Necklace
(21676,1901,1,1,1,53326), -- Tiger\'s Eye Earring Stone
(21676,1865,1,3,2,154435), -- Varnish
(21676,1870,1,3,2,102956), -- Coal
(21676,1875,1,1,2,20592), -- Stone of Purity
(21676,1879,1,1,2,51479), -- Cokes
(21676,2188,1,1,2,22062), -- Recipe: Manticore Skin Gaiters
(21677,1900,1,1,-1,258453), -- Enchanted Necklace Chain
(21677,2250,1,1,-1,590566), -- Recipe: Bone Arrow
(21677,6667,1,3,-1,738208), -- Deluxe Chest Key - Grade 3
(21677,57,996,1993,0,700000), -- Adena
(21677,6667,3,9,2,425208), -- Deluxe Chest Key - Grade 3
(21678,1901,1,1,-1,389212), -- Tiger\'s Eye Earring Stone
(21678,2154,1,1,-1,301702), -- Recipe: Elven Earring
(21678,6667,1,3,-1,880592), -- Deluxe Chest Key - Grade 3
(21678,57,1191,2381,0,700000), -- Adena
(21678,6667,12,36,2,125721), -- Deluxe Chest Key - Grade 3
(21679,955,1,1,-1,9315), -- Scroll: Enchant Weapon (Grade D)
(21679,956,1,1,-1,77629), -- Scroll: Enchant Armor (Grade D)
(21679,6387,1,1,-1,93155), -- Blessed Scroll of Resurrection for Pets
(21679,57,982,1965,0,700000), -- Adena
(21679,605,1,1,1,3822), -- Leather Gauntlets
(21679,1123,1,1,1,3822), -- Blue Buckskin Boots
(21679,955,1,1,2,2546), -- Scroll: Enchant Weapon (Grade D)
(21679,956,1,1,2,21211), -- Scroll: Enchant Armor (Grade D)
(21680,1901,1,1,-1,427616), -- Tiger\'s Eye Earring Stone
(21680,1938,1,1,-1,208130), -- Mithril Banded Mail Material
(21680,2154,1,1,-1,331471), -- Recipe: Elven Earring
(21680,57,1308,2609,0,700000), -- Adena
(21680,316,1,1,1,114), -- Blood of Saints
(21680,317,1,1,1,114), -- Tome of Blood
(21680,2030,1,1,1,6418), -- Tome of Blood Page
(21680,955,1,1,2,3293), -- Scroll: Enchant Weapon (Grade D)
(21680,956,1,1,2,27435), -- Scroll: Enchant Armor (Grade D)
(21681,1939,1,1,-1,235980), -- Mithril Banded Gaiters Material
(21681,2155,1,1,-1,431241), -- Recipe: Elven Ring
(21681,2156,1,1,-1,214931), -- Recipe: Elven Necklace
(21681,57,1135,2270,0,700000), -- Adena
(21681,47,1,1,1,1875), -- Helmet
(21681,628,1,1,1,2681), -- Hoplon
(21681,955,1,1,2,2857), -- Scroll: Enchant Weapon (Grade D)
(21681,956,1,1,2,23809), -- Scroll: Enchant Armor (Grade D)
(21682,1944,1,1,-1,111449), -- Mithril Tunic Fabric
(21682,2148,1,1,-1,156068), -- Recipe: Crafted Leather
(21682,6036,1,1,-1,72832), -- Greater Magic Haste Potion
(21682,57,916,1829,0,700000), -- Adena
(21682,437,1,1,1,253), -- Mithril Tunic
(21682,470,1,1,1,404), -- Mithril Stockings
(21682,1944,1,1,1,14402), -- Mithril Tunic Fabric
(21682,1945,1,1,1,22426), -- Mithril Stocking Design
(21682,1867,1,3,2,150594), -- Animal Skin
(21682,1872,1,3,2,100396), -- Animal Bone
(21682,1882,1,1,2,50198), -- Leather
(21682,1894,1,1,2,7927), -- Crafted Leather
(21682,2157,1,1,2,18669), -- Recipe: Omen Beast\'s Eye Earring
(21683,1910,1,1,-1,218318), -- Aquastone Necklace Chain
(21683,1954,1,1,-1,154134), -- Karmian Stocking Design
(21683,2164,1,1,-1,223021), -- Recipe: Ring of Protection
(21683,57,1170,2376,0,700000), -- Adena
(21683,263,1,1,1,60), -- Chakram
(21683,2073,1,1,1,5296), -- Chakram Edge
(21683,1868,1,3,2,228373), -- Thread
(21683,1873,1,1,2,91350), -- Silver Nugget
(21683,1876,1,1,2,45675), -- Mithril Ore
(21683,1895,1,1,2,65250), -- Metallic Fiber
(21683,2165,1,1,2,8750), -- Recipe: Necklace of Protection
(21683,4042,1,1,2,3807), -- Enria
(21684,1906,1,1,-1,312918), -- Mithril Ring Wire
(21684,1907,1,1,-1,158364), -- Necklace of Darkness Gem
(21684,2160,1,1,-1,146870), -- Recipe: Moonstone Earring
(21684,57,919,1865,0,700000), -- Adena
(21684,353,1,1,1,147), -- Half Plate Armor
(21684,380,1,1,1,235), -- Plate Gaiters
(21684,1950,1,1,1,9276), -- Half Plate Temper
(21684,1951,1,1,1,14427), -- Plate Gaiters Part
(21684,1867,1,3,2,101613), -- Animal Skin
(21684,1872,1,3,2,152420), -- Animal Bone
(21684,1875,1,1,2,15243), -- Stone of Purity
(21684,1881,1,1,2,30484), -- Coarse Bone Powder
(21684,2160,1,1,2,14751), -- Recipe: Moonstone Earring
(21685,1873,1,3,-1,498136), -- Silver Nugget
(21685,1958,1,1,-1,223881), -- Mithril Boots Design
(21685,2165,1,1,-1,95428), -- Recipe: Necklace of Protection
(21685,57,1005,2042,0,700000), -- Adena
(21685,439,1,1,1,156), -- Karmian Tunic
(21685,471,1,1,1,249), -- Karmian Stockings
(21685,1954,1,1,1,15646), -- Karmian Stocking Design
(21685,1962,1,1,1,9418), -- Karmian Tunic Pattern
(21685,1868,1,3,2,196190), -- Thread
(21685,1873,1,1,2,78476), -- Silver Nugget
(21685,1889,1,1,2,13080), -- Compound Braid
(21685,2213,1,1,2,3047), -- Recipe: Dwarven Chain Mail Shirt
(21685,4044,1,1,2,6540), -- Thons
(21685,5549,1,1,2,19619), -- Metallic Thread
(21686,1864,1,11,-1,829734), -- Stem
(21686,1869,1,5,-1,829734), -- Iron Ore
(21686,4470,1,1,-1,14224), -- Dye of Strength <Str+1 Dex-1>
(21686,57,1004,2040,0,700000), -- Adena
(21686,280,1,1,1,70), -- Light Crossbow
(21686,2054,1,1,1,5320), -- Light Crossbow Shaft
(21686,1864,3,9,2,83331), -- Stem
(21686,1869,2,6,2,62499), -- Iron Ore
(21686,1878,1,1,2,99998), -- Braided Hemp
(21686,1884,1,1,2,153842), -- Cord
(21686,2161,1,1,2,24272), -- Recipe: Aquastone Ring
(21687,1945,1,1,-1,112314), -- Mithril Stocking Design
(21687,1946,1,1,-1,191085), -- Rip Gauntlets Pattern
(21687,2149,1,1,-1,101002), -- Recipe: Metallic Fiber
(21687,57,593,1184,0,700000), -- Adena
(21687,606,1,1,1,123), -- Rip Gauntlets
(21687,1124,1,1,1,123), -- Boots of Power
(21687,1946,1,1,1,6175), -- Rip Gauntlets Pattern
(21687,1948,1,1,1,6175), -- Boots of Power Pattern
(21687,2424,1,1,1,123), -- Manticore Skin Boots
(21687,2425,1,1,1,123), -- Brigandine Boots
(21687,2426,1,1,1,123), -- Elven Mithril Boots
(21687,2448,1,1,1,123), -- Manticore Skin Gloves
(21687,2449,1,1,1,123), -- Brigandine Gauntlets
(21687,2450,1,1,1,123), -- Elven Mithril Gloves
(21687,2923,1,1,1,6175), -- Manticore Skin Boot Lining
(21687,2924,1,1,1,6175), -- Brigandine Boots Design
(21687,2925,1,1,1,6175), -- Elven Mithril Boots Design
(21687,2926,1,1,1,6175), -- Manticore Skin Gloves Lining
(21687,2927,1,1,1,6175), -- Brigandine Gauntlets Pattern
(21687,2928,1,1,1,6175), -- Elven Mithril Gloves Design
(21687,1867,1,1,2,162433), -- Animal Skin
(21687,1872,1,1,2,162433), -- Animal Bone
(21687,1875,1,1,2,8122), -- Stone of Purity
(21687,1881,1,1,2,16244), -- Coarse Bone Powder
(21687,2158,1,1,2,15078), -- Recipe: Mithril Ring
(21687,6036,1,1,2,4061), -- Greater Magic Haste Potion
(21688,1908,1,1,-1,208879), -- Moonstone Earring Wire
(21688,1959,1,1,-1,59414), -- Chain Mail Shirt Material
(21688,4042,1,1,-1,36763), -- Enria
(21688,57,890,1808,0,700000), -- Adena
(21688,281,1,1,1,46), -- Crystallized Ice Bow
(21688,2074,1,1,1,3692), -- Crystallized Ice Bow Shaft
(21688,1868,1,3,2,173746), -- Thread
(21688,1873,1,1,2,69499), -- Silver Nugget
(21688,1876,1,1,2,34750), -- Mithril Ore
(21688,1895,1,1,2,49642), -- Metallic Fiber
(21688,2214,1,1,2,4312), -- Recipe: Dwarven Chain Gaiters
(21688,4042,1,1,2,2896), -- Enria
(21689,1867,1,5,-1,788384), -- Animal Skin
(21689,1872,1,5,-1,788384), -- Animal Bone
(21689,6036,1,1,-1,59129), -- Greater Magic Haste Potion
(21689,57,744,1485,0,700000), -- Adena
(21689,352,1,1,1,103), -- Brigandine Tunic
(21689,1941,1,1,1,6078), -- Brigandine Temper
(21689,2377,1,1,1,164), -- Mithril Scale Gaiters
(21689,2378,1,1,1,164), -- Brigandine Gaiters
(21689,2918,1,1,1,9066), -- Mithril Scale Gaiters Material
(21689,2919,1,1,1,9066), -- Brigandine Gaiters Material
(21689,1867,1,3,2,122260), -- Animal Skin
(21689,1872,1,1,2,244521), -- Animal Bone
(21689,1882,1,1,2,40754), -- Leather
(21689,1894,1,1,2,6435), -- Crafted Leather
(21689,2159,1,1,2,11321), -- Recipe: Necklace of Darkness
(21690,1949,1,1,-1,224655), -- Mithril Gloves Design
(21690,1950,1,1,-1,65333), -- Half Plate Temper
(21690,2161,1,1,-1,195428), -- Recipe: Aquastone Ring
(21690,57,812,1649,0,700000), -- Adena
(21690,61,1,1,1,173), -- Mithril Gloves
(21690,607,1,1,1,173), -- Ogre Power Gauntlets
(21690,1125,1,1,1,173), -- Assault Boots
(21690,1949,1,1,1,9401), -- Mithril Gloves Design
(21690,1957,1,1,1,9401), -- Assault Boots Part
(21690,1963,1,1,1,9401), -- Ogre Power Gauntlets Part
(21690,2427,1,1,1,173), -- Salamander Skin Boots
(21690,2428,1,1,1,173), -- Plate Boots
(21690,2451,1,1,1,173), -- Sage\'s Worn Gloves
(21690,2931,1,1,1,9401), -- Salamander Skin Boot Lining
(21690,2932,1,1,1,9401), -- Plate Boots Design
(21690,2933,1,1,1,9401), -- Sage\'s Worn Gloves Lining
(21690,1868,1,3,2,202158), -- Thread
(21690,1873,1,1,2,80864), -- Silver Nugget
(21690,1889,1,1,2,13478), -- Compound Braid
(21690,2162,1,1,2,9767), -- Recipe: Aquastone Necklace
(21690,5549,1,1,2,20216), -- Metallic Thread
(21691,1947,1,1,-1,268898), -- Kite Shield Fragment
(21691,1948,1,1,-1,252365), -- Boots of Power Pattern
(21691,2157,1,1,-1,154339), -- Recipe: Omen Beast\'s Eye Earring
(21691,57,783,1563,0,700000), -- Adena
(21691,279,1,1,1,69), -- Strengthened Long Bow
(21691,2040,1,1,1,5585), -- Strengthened Long Bow Shaft
(21691,1865,1,1,2,193071), -- Varnish
(21691,1870,1,1,2,193071), -- Coal
(21691,1875,1,1,2,12872), -- Stone of Purity
(21691,1879,1,1,2,32179), -- Cokes
(21691,2194,1,1,2,19741), -- Recipe: Mithril Gloves
(21692,1866,1,3,-1,706540), -- Suede
(21692,1951,1,1,-1,106997), -- Plate Gaiters Part
(21692,2162,1,1,-1,102397), -- Recipe: Aquastone Necklace
(21692,57,855,1737,0,700000), -- Adena
(21692,159,1,1,1,12), -- Bonebreaker
(21692,187,1,1,1,12), -- Atuba Hammer
(21692,188,1,1,1,12), -- Ghost Staff
(21692,189,1,1,1,12), -- Staff of Life
(21692,190,1,1,1,12), -- Atuba Mace
(21692,2048,1,1,1,881), -- Bonebreaker Head
(21692,2049,1,1,1,881), -- Atuba Hammer Head
(21692,2050,1,1,1,934), -- Ghost Staff Head
(21692,2051,1,1,1,934), -- Staff of Life Shaft
(21692,2058,1,1,1,881), -- Atuba Mace Head
(21692,1866,1,1,2,141917), -- Suede
(21692,1871,1,1,2,212876), -- Charcoal
(21692,1885,1,1,2,17740), -- High Grade Suede
(21692,2199,1,1,2,8982), -- Recipe: Karmian Stockings
(21692,5220,1,1,2,8516), -- Metal Hardener
(21693,1960,1,1,-1,134741), -- Chain Gaiters Part
(21693,2213,1,1,-1,38183), -- Recipe: Dwarven Chain Mail Shirt
(21693,2214,1,1,-1,61018), -- Recipe: Dwarven Chain Gaiters
(21693,57,992,2016,0,700000), -- Adena
(21693,631,1,1,1,292), -- Eldarake
(21693,1964,1,1,1,15652), -- Eldarake Temper
(21693,2413,1,1,1,205), -- Chain Hood
(21693,2495,1,1,1,292), -- Chain Shield
(21693,2936,1,1,1,14216), -- Chain Hood Pattern
(21693,2945,1,1,1,15652), -- Chain Shield Fragment
(21693,1868,1,3,2,193696), -- Thread
(21693,1873,1,1,2,77478), -- Silver Nugget
(21693,1876,1,1,2,38739), -- Mithril Ore
(21693,1895,1,1,2,55342), -- Metallic Fiber
(21693,2215,1,1,2,2468), -- Recipe: Robe of Seal
(21693,4042,1,1,2,3229), -- Enria
(21694,1895,1,1,-1,217208), -- Metallic Fiber
(21694,2031,1,1,-1,7696), -- Morning Star Head
(21694,2158,1,1,-1,94088), -- Recipe: Mithril Ring
(21694,57,319,636,0,700000), -- Adena
(21694,88,1,1,1,6), -- Morning Star
(21694,90,1,1,1,6), -- Goat Head Staff
(21694,158,1,1,1,6), -- Tarbar
(21694,169,1,1,1,6), -- Skull Breaker
(21694,172,1,1,1,6), -- Heavy Bone Club
(21694,2031,1,1,1,398), -- Morning Star Head
(21694,2032,1,1,1,364), -- Goat Head Staff Head
(21694,2035,1,1,1,398), -- Tarbar Head
(21694,2036,1,1,1,398), -- Skull Breaker Head
(21694,2037,1,1,1,398), -- Heavy Bone Club Head
(21694,1895,1,1,2,28070), -- Metallic Fiber
(21694,2195,1,1,2,2513), -- Recipe: Half Plate Armor
(21694,5473,1,1,2,7018), -- Recipe: Durable Metal Plate(100%)
(21694,6668,1,1,2,35088), -- Deluxe Chest Key - Grade 4
(21695,1872,1,15,-1,862698), -- Animal Bone
(21695,1961,1,1,-1,165638), -- Mithril Shirt Fabric
(21695,4041,1,1,-1,45010), -- Mold Hardener
(21695,57,2089,4243,0,700000), -- Adena
(21695,96,1,1,1,36), -- Scythe
(21695,298,1,1,1,36), -- Orcish Glaive
(21695,302,1,1,1,36), -- Body Slasher
(21695,2062,1,1,1,3198), -- Scythe Edge
(21695,2075,1,1,1,3198), -- Orcish Glaive Blade
(21695,2076,1,1,1,3198), -- Body Slasher Blade
(21695,1867,1,3,2,181212), -- Animal Skin
(21695,1872,4,12,2,67955), -- Animal Bone
(21695,1875,1,1,2,27182), -- Stone of Purity
(21695,1881,1,1,2,54364), -- Coarse Bone Powder
(21695,2216,1,1,2,16849), -- Recipe: Great Helmet
(21695,4041,1,1,2,3546), -- Mold Hardener
(21696,1894,1,1,-1,185060), -- Crafted Leather
(21696,1962,1,1,-1,168775), -- Karmian Tunic Pattern
(21696,2215,1,1,-1,67188), -- Recipe: Robe of Seal
(21696,57,2128,4323,0,700000), -- Adena
(21696,281,1,1,1,109), -- Crystallized Ice Bow
(21696,2074,1,1,1,8828), -- Crystallized Ice Bow Shaft
(21696,1894,1,1,2,17493), -- Crafted Leather
(21696,2217,1,1,2,29499), -- Recipe: Knight\'s Shield
(21696,4039,1,1,2,16618), -- Mold Glue
(21696,4041,1,1,2,4336), -- Mold Hardener
(21696,4044,1,1,2,16618), -- Thons
(21697,1964,1,1,-1,16621), -- Eldarake Temper
(21697,2059,1,1,-1,1528), -- Flamberge Blade
(21697,2216,1,1,-1,8499), -- Recipe: Great Helmet
(21697,57,83,169,0,700000), -- Adena
(21697,263,1,1,1,5), -- Chakram
(21697,2073,1,1,1,376), -- Chakram Edge
(21697,1864,1,1,2,32403), -- Stem
(21697,1869,1,1,2,16202), -- Iron Ore
(21697,1878,1,1,2,6481), -- Braided Hemp
(21697,1884,1,1,2,9970), -- Cord
(21697,2219,1,1,2,1007), -- Recipe: Crimson Boots
(21697,4039,1,1,2,541), -- Mold Glue
(21698,1871,1,1,-1,451575), -- Charcoal
(21698,2032,1,1,-1,4173), -- Goat Head Staff Head
(21698,6036,1,1,-1,15052), -- Greater Magic Haste Potion
(21698,57,189,378,0,700000), -- Adena
(21698,395,1,1,1,53), -- Manticore Skin Shirt
(21698,417,1,1,1,84), -- Manticore Skin Gaiters
(21698,1942,1,1,1,2977), -- Manticore Skin Shirt Texture
(21698,1943,1,1,1,4636), -- Manticore Skin Gaiters Pattern
(21698,1341,10,30,2,155621), -- Bone Arrow
(21698,1866,1,1,2,31124), -- Suede
(21698,1871,1,1,2,46686), -- Charcoal
(21698,1877,1,1,2,1868), -- Adamantite Nugget
(21698,2196,1,1,2,1914), -- Recipe: Plate Gaiters
(21699,1953,1,1,-1,154597), -- Sage\'s Rag Lining
(21699,2199,1,1,-1,203650), -- Recipe: Karmian Stockings
(21699,2203,1,3,-1,525763), -- Recipe: Mithril Boots
(21699,57,1947,3955,0,700000), -- Adena
(21699,70,1,1,1,68), -- Claymore
(21699,2047,1,1,1,5327), -- Claymore Blade
(21699,2499,1,1,1,68), -- Elven Long Sword
(21699,2967,1,1,1,5255), -- Elven Long Sword Blade
(21699,1864,4,12,2,121183), -- Stem
(21699,1869,1,3,2,161577), -- Iron Ore
(21699,1880,1,1,2,48473), -- Steel
(21699,2204,1,1,2,9599), -- Recipe: Chain Mail Shirt
(21699,5550,1,1,2,6464), -- Durable Metal Plate
(21700,1902,1,1,-1,411207), -- Elven Earring Beads
(21700,6036,1,1,-1,135287), -- Greater Magic Haste Potion
(21700,6668,1,3,-1,724752), -- Deluxe Chest Key - Grade 4
(21700,57,1702,3397,0,700000), -- Adena
(21700,6668,3,9,2,410321), -- Deluxe Chest Key - Grade 4
(21701,1905,1,1,-1,455493), -- Omen Beast\'s Eye Earring Gemstone
(21701,2160,1,1,-1,302095), -- Recipe: Moonstone Earring
(21701,6668,1,3,-1,836156), -- Deluxe Chest Key - Grade 4
(21701,57,1889,3837,0,700000), -- Adena
(21701,6668,3,9,2,469276), -- Deluxe Chest Key - Grade 4
(21702,1902,1,1,-1,405393), -- Elven Earring Beads
(21702,1903,1,1,-1,667427), -- Elven Ring Piece
(21702,2157,1,1,-1,330680), -- Recipe: Omen Beast\'s Eye Earring
(21702,57,1678,3349,0,700000), -- Adena
(21702,395,1,1,1,462), -- Manticore Skin Shirt
(21702,417,1,1,1,739), -- Manticore Skin Gaiters
(21702,1942,1,1,1,26373), -- Manticore Skin Shirt Texture
(21702,1943,1,1,1,41068), -- Manticore Skin Gaiters Pattern
(21702,951,1,1,2,1881), -- Scroll: Enchant Weapon (Grade C)
(21702,952,1,1,2,13789), -- Scroll: Enchant Armor (Grade C)
(21703,951,1,1,-1,9197), -- Scroll: Enchant Weapon (Grade C)
(21703,952,1,1,-1,67447), -- Scroll: Enchant Armor (Grade C)
(21703,2163,1,1,-1,258089), -- Recipe: Earring of Protection
(21703,57,2041,4146,0,700000), -- Adena
(21703,631,1,1,1,600), -- Eldarake
(21703,1964,1,1,1,32198), -- Eldarake Temper
(21703,2413,1,1,1,422), -- Chain Hood
(21703,2495,1,1,1,600), -- Chain Shield
(21703,2936,1,1,1,29245), -- Chain Hood Pattern
(21703,2945,1,1,1,32198), -- Chain Shield Fragment
(21703,951,1,1,2,2174), -- Scroll: Enchant Weapon (Grade C)
(21703,952,1,1,2,15939), -- Scroll: Enchant Armor (Grade C)
(21704,951,1,1,-1,8117), -- Scroll: Enchant Weapon (Grade C)
(21704,952,1,1,-1,59525), -- Scroll: Enchant Armor (Grade C)
(21704,1905,1,1,-1,434276), -- Omen Beast\'s Eye Earring Gemstone
(21704,57,1801,3658,0,700000), -- Adena
(21704,61,1,1,1,383), -- Mithril Gloves
(21704,607,1,1,1,383), -- Ogre Power Gauntlets
(21704,1125,1,1,1,383), -- Assault Boots
(21704,1949,1,1,1,20850), -- Mithril Gloves Design
(21704,1957,1,1,1,20850), -- Assault Boots Part
(21704,1963,1,1,1,20850), -- Ogre Power Gauntlets Part
(21704,2427,1,1,1,383), -- Salamander Skin Boots
(21704,2428,1,1,1,383), -- Plate Boots
(21704,2451,1,1,1,383), -- Sage\'s Worn Gloves
(21704,2931,1,1,1,20850), -- Salamander Skin Boot Lining
(21704,2932,1,1,1,20850), -- Plate Boots Design
(21704,2933,1,1,1,20850), -- Sage\'s Worn Gloves Lining
(21704,951,1,1,2,2038), -- Scroll: Enchant Weapon (Grade C)
(21704,952,1,1,2,14946), -- Scroll: Enchant Armor (Grade C)
(21705,1914,1,1,-1,192076), -- Earring of Binding Gemstone
(21705,1915,1,1,-1,301229), -- Ring of Ages Gemstone
(21705,2169,1,1,-1,60512), -- Recipe: Necklace of Binding
(21705,57,1379,2804,0,700000), -- Adena
(21705,75,1,1,1,6), -- Caliburs
(21705,76,1,1,1,6), -- Sword of Delusion
(21705,77,1,1,1,6), -- Tsurugi
(21705,84,1,1,1,6), -- Homunkulus\'s Sword
(21705,134,1,1,1,6), -- Sword of Nightmare
(21705,145,1,1,1,6), -- Sword of Whispering Death
(21705,2089,1,1,1,643), -- Caliburs Edge
(21705,2090,1,1,1,643), -- Delusional Blade
(21705,2091,1,1,1,643), -- Tsurugi Blade
(21705,2092,1,1,1,643), -- Homunkulus\'s Sword Blade
(21705,2095,1,1,1,643), -- Sword of Nightmare Blade
(21705,2096,1,1,1,643), -- Sword of Whispering Death Blade
(21705,1867,1,3,2,104732), -- Animal Skin
(21705,1872,1,3,2,157097), -- Animal Bone
(21705,1875,1,1,2,15710), -- Stone of Purity
(21705,1881,1,1,2,31420), -- Coarse Bone Powder
(21705,2170,1,1,2,5558), -- Recipe: Nassen\'s Earring
(21705,4041,1,1,2,2050), -- Mold Hardener
(21706,1870,1,9,-1,874534), -- Coal
(21706,2117,1,1,-1,20573), -- Ghoul\'s Staff Head
(21706,4039,1,1,-1,145756), -- Mold Glue
(21706,57,1762,3590,0,700000), -- Adena
(21706,135,1,1,1,14), -- Samurai Longsword
(21706,2115,1,1,1,1850), -- Samurai Longsword Blade
(21706,5286,1,1,1,14), -- Berserker Blade
(21706,5530,1,1,1,1852), -- Berserker Blade Edge
(21706,1865,1,1,2,230647), -- Varnish
(21706,1870,1,1,2,230647), -- Coal
(21706,1874,1,1,2,15377), -- Oriharukon Ore
(21706,4039,1,1,2,7689), -- Mold Glue
(21706,4043,1,1,2,7689), -- Asofe
(21706,4143,1,1,2,1479), -- Recipe: Zubei\'s Leather Shirt
(21706,4971,1,1,2,266), -- Recipe: Dark Elven Long Bow (60%)
(21707,1885,1,1,-1,290240), -- High Grade Suede
(21707,1920,1,1,-1,119175), -- Necklace of Binding Chain
(21707,3034,1,1,-1,6966), -- Recipe: Spiritshot B
(21707,57,1406,2856,0,700000), -- Adena
(21707,286,1,1,1,21), -- Eminence Bow
(21707,2121,1,1,1,2958), -- Eminence Bow Shaft
(21707,1875,1,1,2,14289), -- Stone of Purity
(21707,1879,1,1,2,35722), -- Cokes
(21707,1885,1,1,2,17861), -- High Grade Suede
(21707,4134,1,1,2,1649), -- Recipe: Zubei\'s Gaiters
(21707,5549,1,1,2,21434), -- Metallic Thread
(21707,5550,1,1,2,2858), -- Durable Metal Plate
(21708,2118,1,1,-1,17674), -- Demon\'s Staff Head
(21708,4142,1,1,-1,28896), -- Recipe: Avadon Gaiters
(21708,4143,1,1,-1,24080), -- Recipe: Zubei\'s Leather Shirt
(21708,57,1514,3084,0,700000), -- Adena
(21708,286,1,1,1,23), -- Eminence Bow
(21708,2121,1,1,1,3190), -- Eminence Bow Shaft
(21708,1864,3,9,2,66048), -- Stem
(21708,1869,1,1,2,198143), -- Iron Ore
(21708,1878,1,1,2,79257), -- Braided Hemp
(21708,1884,1,1,2,121934), -- Cord
(21708,4039,1,1,2,6605), -- Mold Glue
(21708,4144,1,1,2,2037), -- Recipe: Zubei\'s Leather Gaiters
(21708,4972,1,1,2,228), -- Recipe: Great Axe (60%)
(21709,1984,1,1,-1,81636), -- Theca Leather Armor Pattern
(21709,1985,1,1,-1,131322), -- Theca Leather Gaiters Pattern
(21709,3955,1,1,-1,7617), -- Recipe: Blessed Spiritshot B
(21709,57,1538,3123,0,700000), -- Adena
(21709,203,1,1,1,6), -- Pa\'agrian Axe
(21709,204,1,1,1,5), -- Deadman\'s Staff
(21709,205,1,1,1,5), -- Ghoul\'s Staff
(21709,206,1,1,1,5), -- Demon\'s Staff
(21709,2112,1,1,1,682), -- Pa\'agrian Axe Blade
(21709,2116,1,1,1,662), -- Deadman\'s Staff Head
(21709,2117,1,1,1,662), -- Ghoul\'s Staff Head
(21709,2118,1,1,1,662), -- Demon\'s Staff Head
(21709,2503,1,1,1,5), -- Yaksa Mace
(21709,2969,1,1,1,676), -- Yaksa Mace Head
(21709,1895,1,1,2,80352), -- Metallic Fiber
(21709,3955,1,1,2,563), -- Recipe: Blessed Spiritshot B
(21709,4040,1,1,2,5625), -- Mold Lubricant
(21709,4042,1,1,2,4688), -- Enria
(21709,4043,1,1,2,9375), -- Asofe
(21710,1866,1,3,-1,737542), -- Suede
(21710,1916,1,1,-1,94154), -- Necklace of Mermaid Teardrop
(21710,2170,1,1,-1,52185), -- Recipe: Nassen\'s Earring
(21710,57,893,1815,0,700000), -- Adena
(21710,64,1,1,1,187), -- Composite Boots
(21710,608,1,1,1,187), -- Mithril Gauntlets
(21710,1981,1,1,1,13456), -- Mithril Gauntlets Design
(21710,2956,1,1,1,13456), -- Composite Boots Part
(21710,1539,1,1,2,29049), -- Greater Healing Potion
(21710,1866,1,1,2,87144), -- Suede
(21710,1871,1,1,2,130716), -- Charcoal
(21710,1877,1,1,2,5229), -- Adamantite Nugget
(21710,2231,1,1,2,564), -- Recipe: Full Plate Armor
(21710,4040,1,1,2,2615), -- Mold Lubricant
(21710,4041,1,1,2,1137), -- Mold Hardener
(21711,2119,1,1,-1,15159), -- Crystal Dagger Blade
(21711,4040,1,1,-1,66534), -- Mold Lubricant
(21711,4041,1,1,-1,28928), -- Mold Hardener
(21711,57,1341,2731,0,700000), -- Adena
(21711,203,1,1,1,6), -- Pa\'agrian Axe
(21711,204,1,1,1,5), -- Deadman\'s Staff
(21711,205,1,1,1,5), -- Ghoul\'s Staff
(21711,206,1,1,1,5), -- Demon\'s Staff
(21711,2112,1,1,1,595), -- Pa\'agrian Axe Blade
(21711,2116,1,1,1,578), -- Deadman\'s Staff Head
(21711,2117,1,1,1,578), -- Ghoul\'s Staff Head
(21711,2118,1,1,1,578), -- Demon\'s Staff Head
(21711,2503,1,1,1,5), -- Yaksa Mace
(21711,2969,1,1,1,591), -- Yaksa Mace Head
(21711,1866,1,1,2,116984), -- Suede
(21711,1871,1,1,2,175476), -- Charcoal
(21711,1877,1,1,2,7020), -- Adamantite Nugget
(21711,4040,1,1,2,3510), -- Mold Lubricant
(21711,4041,1,1,2,1526), -- Mold Hardener
(21711,4145,1,1,2,770), -- Recipe: Avadon Leather Armor
(21711,4972,1,1,2,203), -- Recipe: Great Axe (60%)
(21712,1539,1,1,-1,616818), -- Greater Healing Potion
(21712,4602,1,1,-1,6168), -- Greater Dye of Strength <Str+3 Dex-3>
(21712,5549,1,1,-1,277568), -- Metallic Thread
(21712,57,1120,2277,0,700000), -- Adena
(21712,854,1,1,1,130), -- Earring of Binding
(21712,885,1,1,1,196), -- Ring of Ages
(21712,917,1,1,1,98), -- Necklace of Mermaid
(21712,1914,1,1,1,10749), -- Earring of Binding Gemstone
(21712,1915,1,1,1,16857), -- Ring of Ages Gemstone
(21712,1916,1,1,1,8142), -- Necklace of Mermaid Teardrop
(21712,1868,1,1,2,382618), -- Thread
(21712,1873,1,1,2,76524), -- Silver Nugget
(21712,1889,1,1,2,12754), -- Compound Braid
(21712,2232,1,1,2,1100), -- Recipe: Drake Leather Armor
(21712,4044,1,1,2,6377), -- Thons
(21712,5549,1,1,2,19132), -- Metallic Thread
(21713,1874,1,1,-1,205309), -- Oriharukon Ore
(21713,1986,1,1,-1,32542), -- Full Plate Armor Temper
(21713,4043,1,1,-1,102654), -- Asofe
(21713,57,1243,2526,0,700000), -- Adena
(21713,135,1,1,1,10), -- Samurai Longsword
(21713,2115,1,1,1,1303), -- Samurai Longsword Blade
(21713,5286,1,1,1,10), -- Berserker Blade
(21713,5530,1,1,1,1305), -- Berserker Blade Edge
(21713,1865,1,1,2,189516), -- Varnish
(21713,1870,1,1,2,189516), -- Coal
(21713,1874,1,1,2,12635), -- Oriharukon Ore
(21713,4039,1,1,2,6318), -- Mold Glue
(21713,4043,1,1,2,6318), -- Asofe
(21713,4126,1,1,2,3128), -- Recipe: Adamantite Earrings
(21714,1977,1,1,-1,43228), -- Composite Armor Temper
(21714,1978,1,1,-1,187320), -- Tower Shield Fragment
(21714,2231,1,1,-1,12596), -- Recipe: Full Plate Armor
(21714,57,1179,2397,0,700000), -- Adena
(21714,64,1,1,1,247), -- Composite Boots
(21714,608,1,1,1,247), -- Mithril Gauntlets
(21714,1981,1,1,1,17771), -- Mithril Gauntlets Design
(21714,2956,1,1,1,17771), -- Composite Boots Part
(21714,1895,1,1,2,57546), -- Metallic Fiber
(21714,2233,1,1,2,1883), -- Recipe: Divine Tunic
(21714,2970,1,1,2,7143), -- Recipe: Ring of Binding
(21714,4040,1,1,2,4029), -- Mold Lubricant
(21714,4042,1,1,2,3357), -- Enria
(21714,4043,1,1,2,6714), -- Asofe
(21715,1987,1,1,-1,49476), -- Drake Leather Armor Texture
(21715,4126,1,1,-1,53513), -- Recipe: Adamantite Earrings
(21715,4127,1,1,-1,80270), -- Recipe: Adamantite Ring
(21715,57,1309,2660,0,700000), -- Adena
(21715,442,1,1,1,56), -- Divine Tunic
(21715,473,1,1,1,90), -- Divine Stockings
(21715,1988,1,1,1,5753), -- Divine Tunic Fabric
(21715,1989,1,1,1,9024), -- Divine Stocking Pattern
(21715,1867,1,3,2,133042), -- Animal Skin
(21715,1872,1,1,2,266085), -- Animal Bone
(21715,1882,1,1,2,44348), -- Leather
(21715,1894,1,1,2,7003), -- Crafted Leather
(21715,4042,1,1,2,3326), -- Enria
(21715,4127,1,1,2,4940), -- Recipe: Adamantite Ring
(21716,2120,1,1,-1,17815), -- Great Pata Blade
(21716,2121,1,1,-1,17055), -- Eminence Bow Shaft
(21716,4144,1,1,-1,38116), -- Recipe: Zubei\'s Leather Gaiters
(21716,57,1495,3045,0,700000), -- Adena
(21716,135,1,1,1,12), -- Samurai Longsword
(21716,2115,1,1,1,1569), -- Samurai Longsword Blade
(21716,5286,1,1,1,12), -- Berserker Blade
(21716,5530,1,1,1,1571), -- Berserker Blade Edge
(21716,1874,1,1,2,15216), -- Oriharukon Ore
(21716,1878,1,1,2,91291), -- Braided Hemp
(21716,1884,1,1,2,140448), -- Cord
(21716,1889,1,1,2,15216), -- Compound Braid
(21716,4146,1,1,2,1464), -- Recipe: Tunic of Zubei
(21716,5220,1,1,2,9130), -- Metal Hardener
(21717,1877,1,1,-1,47583), -- Adamantite Nugget
(21717,1981,1,1,-1,69975), -- Mithril Gauntlets Design
(21717,2232,1,1,-1,6837), -- Recipe: Drake Leather Armor
(21717,57,480,976,0,700000), -- Adena
(21717,103,1,1,1,48), -- Tower Shield
(21717,107,1,1,1,48), -- Composite Shield
(21717,517,1,1,1,34), -- Composite Helmet
(21717,1149,1,1,1,34), -- Shining Circlet
(21717,1978,1,1,1,3942), -- Tower Shield Fragment
(21717,1983,1,1,1,2697), -- Shining Circlet Pattern
(21717,2957,1,1,1,2697), -- Composite Helmet Design
(21717,4055,1,1,1,3942), -- Composite Shield Fragment
(21717,1342,10,30,2,109320), -- Fine Steel Arrow
(21717,1866,1,1,2,36440), -- Suede
(21717,1871,1,1,2,54660), -- Charcoal
(21717,1877,1,1,2,2187), -- Adamantite Nugget
(21717,2234,1,1,2,815), -- Recipe: Divine Stockings
(21717,3012,1,1,2,1020), -- Recipe: Full Plate Helmet
(21717,4040,1,1,2,1094), -- Mold Lubricant
(21717,4041,1,1,2,476), -- Mold Hardener
(21717,6669,1,1,2,12712), -- Deluxe Chest Key - Grade 5
(21718,2122,1,1,-1,35632), -- Orcish Poleaxe Blade
(21718,4044,1,1,-1,260224), -- Thons
(21718,4145,1,1,-1,34240), -- Recipe: Avadon Leather Armor
(21718,57,3146,6410,0,700000), -- Adena
(21718,442,1,1,1,135), -- Divine Tunic
(21718,473,1,1,1,215), -- Divine Stockings
(21718,1988,1,1,1,13848), -- Divine Tunic Fabric
(21718,1989,1,1,1,21722), -- Divine Stocking Pattern
(21718,1868,3,9,2,160138), -- Thread
(21718,1873,1,1,2,192166), -- Silver Nugget
(21718,1889,1,1,2,32028), -- Compound Braid
(21718,4044,1,1,2,16014), -- Thons
(21718,4147,1,1,2,4938), -- Recipe: Stockings of Zubei
(21718,5549,1,1,2,48042), -- Metallic Thread
(21719,1876,1,3,-1,795456), -- Mithril Ore
(21719,2917,1,1,-1,456896), -- Ring of Binding Gemstone
(21719,4146,1,1,-1,50991), -- Recipe: Tunic of Zubei
(21719,57,3206,6531,0,700000), -- Adena
(21719,2436,1,1,1,153), -- Theca Leather Boots
(21719,2437,1,1,1,118), -- Drake Leather Boots
(21719,2438,1,1,1,118), -- Full Plate Boots
(21719,2460,1,1,1,153), -- Theca Leather Gloves
(21719,2461,1,1,1,118), -- Drake Leather Gloves
(21719,2462,1,1,1,118), -- Full Plate Gauntlets
(21719,2463,1,1,1,118), -- Divine Gloves
(21719,2954,1,1,1,13280), -- Theca Leather Boots Texture
(21719,2955,1,1,1,13280), -- Theca Leather Gloves Texture
(21719,2960,1,1,1,11426), -- Drake Leather Boots Design
(21719,2961,1,1,1,11426), -- Full Plate Boots Part
(21719,2962,1,1,1,11426), -- Drake Leather Gloves Design
(21719,2963,1,1,1,11426), -- Full Plate Gauntlets Part
(21719,2964,1,1,1,11426), -- Divine Gloves Pattern
(21719,1868,3,9,2,163170), -- Thread
(21719,1873,2,6,2,48952), -- Silver Nugget
(21719,1876,1,1,2,97902), -- Mithril Ore
(21719,1895,1,1,2,139860), -- Metallic Fiber
(21719,4042,1,1,2,8159), -- Enria
(21719,4148,1,1,2,2147), -- Recipe: Avadon Robe
(21720,2954,1,1,-1,19633), -- Theca Leather Boots Texture
(21720,2955,1,1,-1,19633), -- Theca Leather Gloves Texture
(21720,4147,1,1,-1,3188), -- Recipe: Stockings of Zubei
(21720,57,125,255,0,700000), -- Adena
(21720,299,1,1,1,1), -- Orcish Poleaxe
(21720,301,1,1,1,1), -- Scorpion
(21720,303,1,1,1,1), -- Widow Maker
(21720,2113,1,1,1,93), -- Scorpion Blade
(21720,2114,1,1,1,93), -- Widowmaker Head
(21720,2122,1,1,1,88), -- Orcish Poleaxe Blade
(21720,1866,1,1,2,12727), -- Suede
(21720,1871,1,1,2,19090), -- Charcoal
(21720,1885,1,1,2,1591), -- High Grade Suede
(21720,4041,1,1,2,166), -- Mold Hardener
(21720,4149,1,1,2,246), -- Recipe: Avadon Circlet
(21720,5220,1,1,2,764), -- Metal Hardener
(21721,1539,1,1,-1,157024), -- Greater Healing Potion
(21721,1865,1,1,-1,706609), -- Varnish
(21721,4603,1,1,-1,1570), -- Greater Dye of Constitution <Con+3 Str-3>
(21721,57,285,580,0,700000), -- Adena
(21721,231,1,1,1,4), -- Grace Dagger
(21721,233,1,1,1,4), -- Dark Screamer
(21721,2106,1,1,1,399), -- Grace Dagger Edge
(21721,2107,1,1,1,399), -- Dark Screamer Edge
(21721,1865,1,1,2,48702), -- Varnish
(21721,1870,1,1,2,48702), -- Coal
(21721,1874,1,1,2,3247), -- Oriharukon Ore
(21721,2353,1,1,2,80), -- Recipe: Samurai Longsword
(21721,4039,1,1,2,1624), -- Mold Glue
(21721,4043,1,1,2,1624), -- Asofe
(21722,1989,1,1,-1,222552), -- Divine Stocking Pattern
(21722,2112,1,1,-1,35759), -- Pa\'agrian Axe Blade
(21722,4128,1,1,-1,91389), -- Recipe: Adamantite Necklace
(21722,57,2981,6056,0,700000), -- Adena
(21722,299,1,1,1,15), -- Orcish Poleaxe
(21722,301,1,1,1,20), -- Scorpion
(21722,303,1,1,1,20), -- Widow Maker
(21722,2113,1,1,1,2201), -- Scorpion Blade
(21722,2114,1,1,1,2201), -- Widowmaker Head
(21722,2122,1,1,1,2074), -- Orcish Poleaxe Blade
(21722,1865,1,3,2,227209), -- Varnish
(21722,1870,1,3,2,151473), -- Coal
(21722,1875,1,1,2,30295), -- Stone of Purity
(21722,1879,1,1,2,75737), -- Cokes
(21722,4040,1,1,2,9089), -- Mold Lubricant
(21722,4133,1,1,2,2185), -- Recipe: Zubei\'s Breastplate
(21723,1539,1,3,-1,705642), -- Greater Healing Potion
(21723,4601,1,1,-1,14113), -- Greater Dye of Strength <Str+3 Con-3>
(21723,6669,1,3,-1,738462), -- Deluxe Chest Key - Grade 5
(21723,57,2562,5209,0,700000), -- Adena
(21723,6669,3,9,2,392635), -- Deluxe Chest Key - Grade 5
(21724,1984,1,1,-1,153567), -- Theca Leather Armor Pattern
(21724,4126,1,1,-1,118216), -- Recipe: Adamantite Earrings
(21724,6669,1,3,-1,833012), -- Deluxe Chest Key - Grade 5
(21724,57,2892,5875,0,700000), -- Adena
(21724,6669,3,9,2,430603), -- Deluxe Chest Key - Grade 5
(21725,951,1,1,-1,11384), -- Scroll: Enchant Weapon (Grade C)
(21725,952,1,1,-1,83480), -- Scroll: Enchant Armor (Grade C)
(21725,1914,1,1,-1,351741), -- Earring of Binding Gemstone
(21725,57,2526,5135,0,700000), -- Adena
(21725,162,1,1,1,8), -- War Axe
(21725,174,1,1,1,8), -- Nirvana Axe
(21725,196,1,1,1,8), -- Stick of Eternity
(21725,197,1,1,1,8), -- Paradia Staff
(21725,199,1,1,1,8), -- Pa\'agrian Hammer
(21725,200,1,1,1,8), -- Sage\'s Staff
(21725,201,1,1,1,8), -- Club of Nature
(21725,202,1,1,1,8), -- Mace of The Underworld
(21725,2097,1,1,1,867), -- War Axe Blade
(21725,2098,1,1,1,867), -- Nirvana Axe Blade
(21725,2099,1,1,1,913), -- Stick of Eternity Shaft
(21725,2100,1,1,1,913), -- Paradia Staff Head
(21725,2102,1,1,1,880), -- Pa\'agrian Hammer Head
(21725,2103,1,1,1,913), -- Sage\'s Staff Head
(21725,2104,1,1,1,913), -- Club of Nature Head
(21725,2105,1,1,1,867), -- Mace of The Underworld Head
(21725,951,1,1,2,785), -- Scroll: Enchant Weapon (Grade C)
(21725,952,1,1,2,5754), -- Scroll: Enchant Armor (Grade C)
(21725,1894,1,1,2,15142), -- Crafted Leather
(21725,4039,1,1,2,14385), -- Mold Glue
(21725,4041,1,1,2,3753), -- Mold Hardener
(21725,4044,1,1,2,14385), -- Thons
(21726,951,1,1,-1,13871), -- Scroll: Enchant Weapon (Grade C)
(21726,952,1,1,-1,101724), -- Scroll: Enchant Armor (Grade C)
(21726,4127,1,1,-1,188844), -- Recipe: Adamantite Ring
(21726,57,3075,6264,0,700000), -- Adena
(21726,119,1,1,1,167), -- Necklace of Binding
(21726,855,1,1,1,222), -- Nassen\'s Earring
(21726,886,1,1,1,333), -- Ring of Binding
(21726,1918,1,1,1,20332), -- Nassen\'s Earring Gemstone
(21726,1920,1,1,1,16064), -- Necklace of Binding Chain
(21726,2917,1,1,1,26965), -- Ring of Binding Gemstone
(21726,951,1,1,2,2561), -- Scroll: Enchant Weapon (Grade C)
(21726,952,1,1,2,18781), -- Scroll: Enchant Armor (Grade C)
(21727,951,1,1,-1,12419), -- Scroll: Enchant Weapon (Grade C)
(21727,952,1,1,-1,91069), -- Scroll: Enchant Armor (Grade C)
(21727,1984,1,1,-1,146414), -- Theca Leather Armor Pattern
(21727,57,2758,5602,0,700000), -- Adena
(21727,119,1,1,1,149), -- Necklace of Binding
(21727,855,1,1,1,199), -- Nassen\'s Earring
(21727,886,1,1,1,299), -- Ring of Binding
(21727,1918,1,1,1,18202), -- Nassen\'s Earring Gemstone
(21727,1920,1,1,1,14381), -- Necklace of Binding Chain
(21727,2917,1,1,1,24141), -- Ring of Binding Gemstone
(21727,951,1,1,2,2293), -- Scroll: Enchant Weapon (Grade C)
(21727,952,1,1,2,16813), -- Scroll: Enchant Armor (Grade C)
(21728,1867,1,15,-1,834610), -- Animal Skin
(21728,1881,1,1,-1,667688), -- Coarse Bone Powder
(21728,4614,1,1,-1,6907), -- Greater Dye of Strength <Str+4 Dex-4>
(21728,57,2020,4107,0,700000), -- Adena
(21728,357,1,1,1,18), -- Zubei\'s Breastplate
(21728,383,1,1,1,29), -- Zubei\'s Gaiters
(21728,2376,1,1,1,18), -- Avadon Breastplate
(21728,2379,1,1,1,29), -- Avadon Gaiters
(21728,4056,1,1,1,3347), -- Zubei\'s Breastplate Part
(21728,4057,1,1,1,5172), -- Zubei\'s Gaiter Material
(21728,4064,1,1,1,3347), -- Avadon Breastplate Part
(21728,4065,1,1,1,5172), -- Avadon Gaiters Material
(21728,1867,1,3,2,109570), -- Animal Skin
(21728,1872,1,3,2,164355), -- Animal Bone
(21728,1875,1,1,2,16436), -- Stone of Purity
(21728,1881,1,1,2,32871), -- Coarse Bone Powder
(21728,4041,1,1,2,2144), -- Mold Hardener
(21728,4129,1,1,2,2668), -- Recipe: Earrings of Black Ore
(21729,1807,1,1,-1,8333), -- Recipe: Soulshot: A-Grade
(21729,3035,1,1,-1,8333), -- Recipe: Spiritshot A
(21729,4085,1,1,-1,108621), -- Tunic of Doom Pattern
(21729,57,2526,5122,0,700000), -- Adena
(21729,97,1,1,1,15), -- Lance
(21729,4115,1,1,1,4028), -- Lance Blade
(21729,1874,1,1,2,20514), -- Oriharukon Ore
(21729,1878,1,1,2,123079), -- Braided Hemp
(21729,1884,1,1,2,189352), -- Cord
(21729,1889,1,1,2,20514), -- Compound Braid
(21729,5220,1,1,2,12308), -- Metal Hardener
(21729,6337,1,1,2,1578), -- Recipe: Sealed Majestic Earring(70%)
(21730,4087,1,1,-1,117875), -- Stockings of Doom Pattern
(21730,4088,1,1,-1,189843), -- Blue Wolf Helmet Design
(21730,5276,1,1,-1,6698), -- Recipe: Greater Spiritshot (A) Compressed Package(100%)
(21730,57,2032,4115,0,700000), -- Adena
(21730,287,1,1,1,12), -- Bow of Peril
(21730,4121,1,1,1,3232), -- Bow of Peril Shaft
(21730,1865,1,1,2,247299), -- Varnish
(21730,1870,1,3,2,123650), -- Coal
(21730,1874,1,1,2,16487), -- Oriharukon Ore
(21730,4039,1,1,2,8244), -- Mold Glue
(21730,4043,1,1,2,8244), -- Asofe
(21730,5438,1,1,2,136), -- Recipe: Meteor Shower(60%)
(21731,1894,1,1,-1,188395), -- Crafted Leather
(21731,4042,1,1,-1,89488), -- Enria
(21731,4086,1,1,-1,125994), -- Blue Wolf Stockings Pattern
(21731,57,2170,4400,0,700000), -- Adena
(21731,110,1,1,1,63), -- Doom Shield
(21731,2416,1,1,1,44), -- Blue Wolf Helmet
(21731,2417,1,1,1,44), -- Doom Helmet
(21731,4077,1,1,1,11890), -- Doom Shield Fragment
(21731,4088,1,1,1,9990), -- Blue Wolf Helmet Design
(21731,4089,1,1,1,9990), -- Doom Helmet Pattern
(21731,1343,20,60,2,161837), -- Silver Arrow
(21731,1867,1,3,2,100699), -- Animal Skin
(21731,1872,2,6,2,75524), -- Animal Bone
(21731,1882,1,1,2,50350), -- Leather
(21731,1894,1,1,2,7950), -- Crafted Leather
(21731,4042,1,1,2,3777), -- Enria
(21731,6339,1,1,2,1743), -- Recipe: Sealed Majestic Ring(70%)
(21732,4039,1,1,-1,183088), -- Mold Glue
(21732,4089,1,1,-1,207583), -- Doom Helmet Pattern
(21732,5281,1,1,-1,7324), -- Recipe: Greater Blessed Spiritshot (A) Compressed Package(100%)
(21732,57,2222,4499,0,700000), -- Adena
(21732,234,1,1,1,13), -- Demon\'s Sword
(21732,4119,1,1,1,3551), -- Demon\'s Sword Edge
(21732,1343,30,90,2,110370), -- Silver Arrow
(21732,1864,4,12,2,57945), -- Stem
(21732,1869,2,6,2,46356), -- Iron Ore
(21732,1878,1,1,2,92711), -- Braided Hemp
(21732,1884,1,1,2,142633), -- Cord
(21732,4039,1,1,2,7727), -- Mold Glue
(21732,5444,1,1,2,127), -- Recipe: Carnage Bow(60%)
(21733,4056,1,1,-1,58657), -- Zubei\'s Breastplate Part
(21733,4057,1,1,-1,90651), -- Zubei\'s Gaiter Material
(21733,4131,1,1,-1,26348), -- Recipe: Necklace of Black Ore
(21733,57,1308,2658,0,700000), -- Adena
(21733,91,1,1,1,6), -- Heavy War Axe
(21733,92,1,1,1,6), -- Sprite\'s Staff
(21733,4105,1,1,1,1370), -- Heavy War Axe Head
(21733,4106,1,1,1,1347), -- Sprite\'s Staff Head
(21733,1343,20,60,2,97682), -- Silver Arrow
(21733,1867,1,1,2,182340), -- Animal Skin
(21733,1872,1,1,2,182340), -- Animal Bone
(21733,1875,1,1,2,9117), -- Stone of Purity
(21733,1881,1,1,2,18235), -- Coarse Bone Powder
(21733,4041,1,1,2,1190), -- Mold Hardener
(21733,4130,1,1,2,2221), -- Recipe: Ring of Black Ore
(21734,3956,1,1,-1,6340), -- Recipe: Blessed Spiritshot A
(21734,4087,1,1,-1,111581), -- Stockings of Doom Pattern
(21734,4088,1,1,-1,179707), -- Blue Wolf Helmet Design
(21734,57,1922,3897,0,700000), -- Adena
(21734,2391,1,1,1,20), -- Blue Wolf Leather Armor
(21734,2392,1,1,1,20), -- Leather Armor of Doom
(21734,4082,1,1,1,3968), -- Blue Wolf Leather Armor Texture
(21734,4083,1,1,1,3968), -- Leather Armor of Doom Design
(21734,729,1,1,2,26), -- Scroll: Enchant Weapon (Grade A)
(21734,1864,3,9,2,78032), -- Stem
(21734,1869,2,6,2,58524), -- Iron Ore
(21734,1878,1,1,2,93638), -- Braided Hemp
(21734,1884,1,1,2,144058), -- Cord
(21734,4039,1,1,2,7804), -- Mold Glue
(21735,948,1,1,-1,10164), -- Scroll: Enchant Armor (Grade B)
(21735,4064,1,1,-1,73583), -- Avadon Breastplate Part
(21735,4154,1,1,-1,48112), -- Recipe: Doom Shield
(21735,57,1640,3334,0,700000), -- Adena
(21735,300,1,1,1,14), -- Great Axe
(21735,4113,1,1,1,3090), -- Great Axe Head
(21735,1894,1,1,2,8428), -- Crafted Leather
(21735,4039,1,1,2,8006), -- Mold Glue
(21735,4041,1,1,2,2089), -- Mold Hardener
(21735,4044,1,1,2,8006), -- Thons
(21735,4131,1,1,2,1953), -- Recipe: Necklace of Black Ore
(21736,4090,1,1,-1,199401), -- Blue Wolf Boots Design
(21736,5220,1,1,-1,177666), -- Metal Hardener
(21736,5438,1,1,-1,2427), -- Recipe: Meteor Shower(60%)
(21736,57,1797,3638,0,700000), -- Adena
(21736,97,1,1,1,11), -- Lance
(21736,4115,1,1,1,2862), -- Lance Blade
(21736,1866,1,1,2,145778), -- Suede
(21736,1871,1,1,2,218667), -- Charcoal
(21736,1885,1,1,2,18223), -- High Grade Suede
(21736,4041,1,1,2,1902), -- Mold Hardener
(21736,5220,1,1,2,8747), -- Metal Hardener
(21736,5446,1,1,2,120), -- Recipe: Bloody Orchid(60%)
(21737,1880,1,1,-1,428009), -- Steel
(21737,4615,1,1,-1,5904), -- Greater Dye of Constitution <Con+4 Str-4>
(21737,5550,1,1,-1,57068), -- Durable Metal Plate
(21737,57,1727,3510,0,700000), -- Adena
(21737,229,1,1,1,8), -- Kris
(21737,243,1,1,1,8), -- Hell Knife
(21737,4109,1,1,1,1781), -- Kris Edge
(21737,4110,1,1,1,1781), -- Hell Knife Edge
(21737,1343,30,90,2,86005), -- Silver Arrow
(21737,1864,1,3,2,180611), -- Stem
(21737,1869,1,1,2,180611), -- Iron Ore
(21737,1880,1,1,2,18061), -- Steel
(21737,4043,1,1,2,6021), -- Asofe
(21737,4154,1,1,2,2138), -- Recipe: Doom Shield
(21737,5550,1,1,2,2409), -- Durable Metal Plate
(21738,4091,1,1,-1,209972), -- Doom Gloves Part
(21738,4096,1,1,-1,209972), -- Blue Wolf Gloves Fabric
(21738,5444,1,1,-1,2556), -- Recipe: Carnage Bow(60%)
(21738,57,1892,3831,0,700000), -- Adena
(21738,79,1,1,1,11), -- Sword of Damascus
(21738,4114,1,1,1,3024), -- Sword of Damascus Blade
(21738,1343,20,60,2,140975), -- Silver Arrow
(21738,1865,1,3,2,65789), -- Varnish
(21738,1870,1,1,2,197365), -- Coal
(21738,1875,1,1,2,13158), -- Stone of Purity
(21738,1879,1,1,2,32895), -- Cokes
(21738,4040,1,1,2,3948), -- Mold Lubricant
(21738,5452,1,1,2,108), -- Recipe: Blood Tornado(60%)
(21739,4089,1,1,-1,200340), -- Doom Helmet Pattern
(21739,5156,1,1,-1,7068), -- Recipe: Soulshot (A) Compressed Package (100%)
(21739,5220,1,1,-1,212040), -- Metal Hardener
(21739,57,2143,4344,0,700000), -- Adena
(21739,864,1,1,1,57), -- Earring of Black Ore
(21739,895,1,1,1,85), -- Ring of Black Ore
(21739,926,1,1,1,43), -- Necklace of Black Ore
(21739,4052,1,1,1,9239), -- Earring of Black Ore Piece
(21739,4053,1,1,1,11185), -- Ring of Black Ore Gemstone
(21739,4054,1,1,1,5140), -- Necklace of Black Ore Beads
(21739,730,1,1,2,187), -- Scroll: Enchant Armor (Grade A)
(21739,1343,20,60,2,159779), -- Silver Arrow
(21739,1866,1,1,2,149127), -- Suede
(21739,1871,1,3,2,74564), -- Charcoal
(21739,1885,1,1,2,18642), -- High Grade Suede
(21739,4041,1,1,2,1946), -- Mold Hardener
(21739,5220,1,1,2,8948), -- Metal Hardener
(21740,4065,1,1,-1,48737), -- Avadon Gaiters Material
(21740,4066,1,1,-1,41079), -- Zubei\'s Leather Shirt Fabric
(21740,4155,1,1,-1,5411), -- Recipe: Blue Wolf Breastplate
(21740,57,703,1429,0,700000), -- Adena
(21740,357,1,1,1,7), -- Zubei\'s Breastplate
(21740,383,1,1,1,10), -- Zubei\'s Gaiters
(21740,2376,1,1,1,7), -- Avadon Breastplate
(21740,2379,1,1,1,10), -- Avadon Gaiters
(21740,4056,1,1,1,1165), -- Zubei\'s Breastplate Part
(21740,4057,1,1,1,1800), -- Zubei\'s Gaiter Material
(21740,4064,1,1,1,1165), -- Avadon Breastplate Part
(21740,4065,1,1,1,1800), -- Avadon Gaiters Material
(21740,1895,1,1,2,24508), -- Metallic Fiber
(21740,4040,1,1,2,1716), -- Mold Lubricant
(21740,4042,1,1,2,1430), -- Enria
(21740,4043,1,1,2,2860), -- Asofe
(21740,4155,1,1,2,267), -- Recipe: Blue Wolf Breastplate
(21740,6670,1,1,2,14297), -- Deluxe Chest Key - Grade 6
(21741,4040,1,1,-1,223170), -- Mold Lubricant
(21741,4090,1,1,-1,500943), -- Blue Wolf Boots Design
(21741,5161,1,1,-1,14878), -- Recipe: Spiritshot (A) Compressed Package (100%)
(21741,57,4510,9145,0,700000), -- Adena
(21741,79,1,1,1,26), -- Sword of Damascus
(21741,4114,1,1,1,7213), -- Sword of Damascus Blade
(21741,1866,1,3,2,122077), -- Suede
(21741,1871,1,3,2,274672), -- Charcoal
(21741,1877,1,1,2,21974), -- Adamantite Nugget
(21741,4040,1,1,2,10987), -- Mold Lubricant
(21741,4041,1,1,2,4777), -- Mold Hardener
(21741,5434,1,1,2,204), -- Recipe: Dragon Slayer(60%)
(21742,4091,1,1,-1,510430), -- Doom Gloves Part
(21742,4096,1,1,-1,510430), -- Blue Wolf Gloves Fabric
(21742,5166,1,1,-1,15160), -- Recipe: Blessed Spiritshot (A) Compressed Package (100%)
(21742,57,4596,9318,0,700000), -- Adena
(21742,234,1,1,1,26), -- Demon\'s Sword
(21742,4119,1,1,1,7350), -- Demon\'s Sword Edge
(21742,1343,100,300,2,68541), -- Silver Arrow
(21742,1867,9,27,2,35540), -- Animal Skin
(21742,1872,2,6,2,159928), -- Animal Bone
(21742,1882,1,1,2,106619), -- Leather
(21742,1894,1,1,2,16835), -- Crafted Leather
(21742,4042,1,1,2,7997), -- Enria
(21742,5440,1,1,2,178), -- Recipe: Elysian(60%)
(21743,1877,1,1,-1,17736), -- Adamantite Nugget
(21743,4041,1,1,-1,3856), -- Mold Hardener
(21743,4099,1,1,-1,19905), -- Doom Boots Part
(21743,57,179,363,0,700000), -- Adena
(21743,358,1,1,1,2), -- Blue Wolf Breastplate
(21743,2380,1,1,1,3), -- Blue Wolf Gaiters
(21743,2381,1,1,1,1), -- Doom Plate Armor
(21743,4078,1,1,1,319), -- Blue Wolf Breastplate Part
(21743,4080,1,1,1,449), -- Blue Wolf Gaiters Material
(21743,4081,1,1,1,216), -- Doom Plate Armor Temper
(21743,1866,1,1,2,14553), -- Suede
(21743,1871,1,1,2,21829), -- Charcoal
(21743,1877,1,1,2,874), -- Adamantite Nugget
(21743,4040,1,1,2,437), -- Mold Lubricant
(21743,4041,1,1,2,190), -- Mold Hardener
(21743,5442,1,1,2,9), -- Recipe: Soul Bow(60%)
(21744,947,1,1,-1,414), -- Scroll: Enchant Weapon (Grade B)
(21744,4067,1,1,-1,37049), -- Zubei\'s Leather Gaiter Texture
(21744,4157,1,1,-1,5149), -- Recipe: Blue Wolf Gaiters
(21744,57,418,849,0,700000), -- Adena
(21744,2397,1,1,1,7), -- Tunic of Zubei
(21744,2402,1,1,1,11), -- Stockings of Zubei
(21744,2406,1,1,1,5), -- Avadon Robe
(21744,4069,1,1,1,1202), -- Tunic of Zubei Fabric
(21744,4070,1,1,1,1824), -- Stockings of Zubei Fabric
(21744,4071,1,1,1,923), -- Avadon Robe Fabric
(21744,1343,10,30,2,62390), -- Silver Arrow
(21744,1868,1,1,2,87346), -- Thread
(21744,1873,1,1,2,17470), -- Silver Nugget
(21744,1889,1,1,2,2912), -- Compound Braid
(21744,4044,1,1,2,1456), -- Thons
(21744,4157,1,1,2,218), -- Recipe: Blue Wolf Gaiters
(21744,5549,1,1,2,4368), -- Metallic Thread
(21745,4114,1,1,-1,46617), -- Sword of Damascus Blade
(21745,5446,1,1,-1,5820), -- Recipe: Bloody Orchid(60%)
(21745,5452,1,1,-1,5820), -- Recipe: Blood Tornado(60%)
(21745,57,4309,8724,0,700000), -- Adena
(21745,268,1,1,1,25), -- Bellion Cestus
(21745,4120,1,1,1,6873), -- Bellion Cestus Edge
(21745,1343,80,240,2,80252), -- Silver Arrow
(21745,1866,2,6,2,59922), -- Suede
(21745,1871,1,3,2,149804), -- Charcoal
(21745,1877,1,1,2,17977), -- Adamantite Nugget
(21745,4040,1,1,2,8989), -- Mold Lubricant
(21745,4041,1,1,2,3909), -- Mold Hardener
(21745,5460,1,1,2,246); -- Recipe: Dasparion\'s Staff(60%)

INSERT INTO `droplist` VALUES 
(21746,947,1,1,-1,3721), -- Scroll: Enchant Weapon (Grade B)
(21746,6670,1,3,-1,775155), -- Deluxe Chest Key - Grade 6
(21746,57,3753,7629,0,700000), -- Adena
(21746,6670,3,9,2,381615), -- Deluxe Chest Key - Grade 6
(21747,1894,1,1,-1,362536), -- Crafted Leather
(21747,4052,1,1,-1,365809), -- Earring of Black Ore Piece
(21747,6670,1,3,-1,861023), -- Deluxe Chest Key - Grade 6
(21747,57,4180,8463,0,700000), -- Adena
(21747,6670,3,9,2,423888), -- Deluxe Chest Key - Grade 6
(21748,947,1,1,-1,3668), -- Scroll: Enchant Weapon (Grade B)
(21748,948,1,1,-1,22926), -- Scroll: Enchant Armor (Grade B)
(21748,4129,1,1,-1,99246), -- Recipe: Earrings of Black Ore
(21748,57,3700,7521,0,700000), -- Adena
(21748,267,1,1,1,32), -- Arthro Nail
(21748,4111,1,1,1,7751), -- Arthro Nail Blade
(21748,947,1,1,2,155), -- Scroll: Enchant Weapon (Grade B)
(21748,948,1,1,2,968), -- Scroll: Enchant Armor (Grade B)
(21748,1867,1,3,2,171987), -- Animal Skin
(21748,1872,4,12,2,64495), -- Animal Bone
(21748,1875,1,1,2,25798), -- Stone of Purity
(21748,1881,1,1,2,51596), -- Coarse Bone Powder
(21748,4041,1,1,2,3366), -- Mold Hardener
(21749,947,1,1,-1,4362), -- Scroll: Enchant Weapon (Grade B)
(21749,948,1,1,-1,27262), -- Scroll: Enchant Armor (Grade B)
(21749,4053,1,1,-1,467420), -- Ring of Black Ore Gemstone
(21749,57,4408,8937,0,700000), -- Adena
(21749,601,1,1,1,101), -- Boots of Doom
(21749,2439,1,1,1,101), -- Blue Wolf Boots
(21749,2475,1,1,1,101), -- Doom Gloves
(21749,2487,1,1,1,101), -- Blue Wolf Gloves
(21749,4090,1,1,1,18072), -- Blue Wolf Boots Design
(21749,4091,1,1,1,18072), -- Doom Gloves Part
(21749,4096,1,1,1,18072), -- Blue Wolf Gloves Fabric
(21749,4099,1,1,1,18072), -- Doom Boots Part
(21749,947,1,1,2,645), -- Scroll: Enchant Weapon (Grade B)
(21749,948,1,1,2,4027), -- Scroll: Enchant Armor (Grade B)
(21750,947,1,1,-1,3940), -- Scroll: Enchant Weapon (Grade B)
(21750,948,1,1,-1,24627), -- Scroll: Enchant Armor (Grade B)
(21750,5230,1,1,-1,13135), -- Recipe: Mithril Arrow (100%)
(21750,57,3985,8069,0,700000), -- Adena
(21750,110,1,1,1,115), -- Doom Shield
(21750,2416,1,1,1,81), -- Blue Wolf Helmet
(21750,2417,1,1,1,81), -- Doom Helmet
(21750,4077,1,1,1,21815), -- Doom Shield Fragment
(21750,4088,1,1,1,18328), -- Blue Wolf Helmet Design
(21750,4089,1,1,1,18328), -- Doom Helmet Pattern
(21750,947,1,1,2,582), -- Scroll: Enchant Weapon (Grade B)
(21750,948,1,1,2,3638), -- Scroll: Enchant Armor (Grade B)
(21751,729,1,1,-1,778), -- Scroll: Enchant Weapon (Grade A)
(21751,1876,1,3,-1,700393), -- Mithril Ore
(21751,1895,1,5,-1,667041), -- Metallic Fiber
(21751,57,2825,5748,0,700000), -- Adena
(21751,269,1,1,1,12), -- Blood Tornado
(21751,5539,1,1,1,3489), -- Blood Tornado Edge
(21751,1343,30,90,2,140739), -- Silver Arrow
(21751,1868,4,12,2,73888), -- Thread
(21751,1873,1,1,2,118221), -- Silver Nugget
(21751,1876,1,1,2,59111), -- Mithril Ore
(21751,1895,1,1,2,84444), -- Metallic Fiber
(21751,4042,1,1,2,4927), -- Enria
(21751,5434,1,1,2,110), -- Recipe: Dragon Slayer(60%)
(21752,5272,1,1,-1,3799), -- Recipe: Greater Soulshot (S) Compressed Package(100%)
(21752,5522,1,1,-1,29108), -- Sealed Armor of Nightmare Pattern
(21752,5523,1,1,-1,29108), -- Sealed Majestic Plate Armor Pattern
(21752,57,3440,7020,0,700000), -- Adena
(21752,269,1,1,1,14), -- Blood Tornado
(21752,5539,1,1,1,4258), -- Blood Tornado Edge
(21752,1344,40,120,2,112713), -- Mithril Arrow
(21752,1867,1,3,2,160302), -- Animal Skin
(21752,1872,5,15,2,48091), -- Animal Bone
(21752,1875,1,1,2,24046), -- Stone of Purity
(21752,1881,1,1,2,48091), -- Coarse Bone Powder
(21752,4041,1,1,2,3137), -- Mold Hardener
(21752,5162,1,1,2,161), -- Recipe: Spiritshot (S) Compressed Package (100%)
(21753,5464,1,1,-1,2567), -- Recipe: Dark Legion\'s Edge(60%)
(21753,5520,1,1,-1,44699), -- Sealed Dark Crystal Breastplate Pattern
(21753,5521,1,1,-1,31541), -- Sealed Tallum Plate Armor Pattern
(21753,57,2793,5688,0,700000), -- Adena
(21753,5287,1,1,1,15), -- Sealed Dark Crystal breastplate
(21753,5288,1,1,1,24), -- Sealed Dark Crystal Gaiters
(21753,5293,1,1,1,11), -- Sealed Tallum Plate Armor
(21753,5520,1,1,1,2201), -- Sealed Dark Crystal Breastplate Pattern
(21753,5521,1,1,1,1553), -- Sealed Tallum Plate Armor Pattern
(21753,5524,1,1,1,3364), -- Sealed Dark Crystal Gaiters Pattern
(21753,1344,30,90,2,121876), -- Mithril Arrow
(21753,1864,5,15,2,58501), -- Stem
(21753,1869,2,6,2,73126), -- Iron Ore
(21753,1880,1,1,2,29251), -- Steel
(21753,4043,1,1,2,9750), -- Asofe
(21753,5550,1,1,2,3901), -- Durable Metal Plate
(21753,6901,1,1,2,293), -- Recipe: Shining Arrow (100%)
(21754,4042,1,1,-1,122379), -- Enria
(21754,5277,1,1,-1,3263), -- Recipe: Greater Spiritshot (S) Compressed Package(100%)
(21754,5527,1,1,-1,87790), -- Sealed Helm of Nightmare Design
(21754,57,2956,6030,0,700000), -- Adena
(21754,288,1,1,1,12), -- Carnage Bow
(21754,5535,1,1,1,3701), -- Carnage Bow Stave
(21754,1868,3,9,2,120497), -- Thread
(21754,1873,1,1,2,144596), -- Silver Nugget
(21754,1876,1,1,2,72299), -- Mithril Ore
(21754,1895,1,1,2,103283), -- Metallic Fiber
(21754,4042,1,1,2,6025), -- Enria
(21754,5167,1,1,2,160), -- Recipe: Blessed Spiritshot (S) Compressed Package (100%)
(21755,729,1,1,-1,842), -- Scroll: Enchant Weapon (Grade A)
(21755,1874,1,1,-1,505293), -- Oriharukon Ore
(21755,4043,1,1,-1,252647), -- Asofe
(21755,57,3054,6219,0,700000), -- Adena
(21755,6323,1,1,1,43), -- Sealed Phoenix Necklace
(21755,6324,1,1,1,57), -- Sealed Phoenix Earring
(21755,6325,1,1,1,86), -- Sealed Phoenix Ring
(21755,6341,1,1,1,10321), -- Sealed Phoenix Earring Gemstone
(21755,6343,1,1,1,7979), -- Sealed Phoenix Necklace Beads
(21755,6345,1,1,1,14275), -- Sealed Phoenix Ring Gemstone
(21755,1808,1,1,2,166), -- Recipe: Soulshot: S Grade
(21755,1865,1,3,2,124380), -- Varnish
(21755,1870,1,3,2,186570), -- Coal
(21755,1874,1,1,2,24877), -- Oriharukon Ore
(21755,4039,1,1,2,12439), -- Mold Glue
(21755,4043,1,1,2,12439), -- Asofe
(21756,5466,1,1,-1,1679), -- Recipe: Sword of Miracles(60%)
(21756,5524,1,1,-1,44675), -- Sealed Dark Crystal Gaiters Pattern
(21756,5525,1,1,-1,70068), -- Sealed Dark Crystal Helmet Design
(21756,57,1828,3720,0,700000), -- Adena
(21756,288,1,1,1,8), -- Carnage Bow
(21756,5535,1,1,1,2284), -- Carnage Bow Stave
(21756,1868,1,3,2,223150), -- Thread
(21756,1873,1,1,2,89260), -- Silver Nugget
(21756,1876,1,1,2,44630), -- Mithril Ore
(21756,1895,1,1,2,63758), -- Metallic Fiber
(21756,4042,1,1,2,3720), -- Enria
(21756,5440,1,1,2,83), -- Recipe: Elysian(60%)
(21757,4041,1,1,-1,56546), -- Mold Hardener
(21757,5282,1,1,-1,2890), -- Recipe: Greater Blessed Spiritshot (S) Compressed Package(100%)
(21757,5528,1,1,-1,77747), -- Sealed Majestic Circlet Design
(21757,57,2617,5341,0,700000), -- Adena
(21757,235,1,1,1,11), -- Bloody Orchid
(21757,5536,1,1,1,3268), -- Bloody Orchid Head
(21757,1344,20,60,2,171502), -- Mithril Arrow
(21757,1866,1,1,2,182935), -- Suede
(21757,1871,1,3,2,91468), -- Charcoal
(21757,1877,1,1,2,10977), -- Adamantite Nugget
(21757,4040,1,1,2,5488), -- Mold Lubricant
(21757,4041,1,1,2,2387), -- Mold Hardener
(21757,5272,1,1,2,122), -- Recipe: Greater Soulshot (S) Compressed Package(100%)
(21758,730,1,1,-1,4738), -- Scroll: Enchant Armor (Grade A)
(21758,5526,1,1,-1,87899), -- Sealed Tallum Helm Design
(21758,6335,1,1,-1,21870), -- Recipe: Sealed Majestic Necklace(70%)
(21758,57,2294,4666,0,700000), -- Adena
(21758,235,1,1,1,10), -- Bloody Orchid
(21758,5536,1,1,1,2857), -- Bloody Orchid Head
(21758,1343,20,60,2,171389), -- Silver Arrow
(21758,1865,1,3,2,79982), -- Varnish
(21758,1870,2,6,2,59987), -- Coal
(21758,1875,1,1,2,15997), -- Stone of Purity
(21758,1879,1,1,2,39991), -- Cokes
(21758,4040,1,1,2,4799), -- Mold Lubricant
(21758,5442,1,1,2,89), -- Recipe: Soul Bow(60%)
(21759,5466,1,1,-1,2270), -- Recipe: Sword of Miracles(60%)
(21759,5524,1,1,-1,60409), -- Sealed Dark Crystal Gaiters Pattern
(21759,5525,1,1,-1,94746), -- Sealed Dark Crystal Helmet Design
(21759,57,2470,5029,0,700000), -- Adena
(21759,212,1,1,1,5), -- Dasparion\'s Staff
(21759,2504,1,1,1,5), -- Meteor Shower
(21759,5532,1,1,1,1526), -- Meteor Shower Head
(21759,5543,1,1,1,1541), -- Dasparion\'s Staff Edge
(21759,1344,20,60,2,161648), -- Mithril Arrow
(21759,1866,1,1,2,172424), -- Suede
(21759,1871,1,3,2,86212), -- Charcoal
(21759,1877,1,1,2,10346), -- Adamantite Nugget
(21759,3036,1,1,2,115), -- Recipe: Spiritshot S
(21759,4040,1,1,2,5173), -- Mold Lubricant
(21759,4041,1,1,2,2250), -- Mold Hardener
(21760,1885,1,1,-1,498859), -- High Grade Suede
(21760,5220,1,1,-1,239453), -- Metal Hardener
(21760,5532,1,1,-1,20187), -- Meteor Shower Head
(21760,57,2415,4913,0,700000), -- Adena
(21760,5290,1,1,1,39), -- Sealed Dark Crystal Gloves
(21760,5291,1,1,1,39), -- Sealed Dark Crystal Boots
(21760,5295,1,1,1,39), -- Sealed Tallum Gloves
(21760,5296,1,1,1,39), -- Sealed Tallum Boots
(21760,5496,1,1,1,5183), -- Sealed Dark Crystal Boots Lining
(21760,5497,1,1,1,5183), -- Sealed Tallum Boots Lining
(21760,5508,1,1,1,5183), -- Sealed Dark Crystal Gloves Design
(21760,5509,1,1,1,5183), -- Sealed Tallum Gloves Design
(21760,1866,1,1,2,196474), -- Suede
(21760,1871,1,3,2,147356), -- Charcoal
(21760,1885,1,1,2,24560), -- High Grade Suede
(21760,4041,1,1,2,2563), -- Mold Hardener
(21760,5220,1,1,2,11789), -- Metal Hardener
(21760,5448,1,1,2,110), -- Recipe: Soul Separator(60%)
(21761,730,1,1,-1,5378), -- Scroll: Enchant Armor (Grade A)
(21761,5526,1,1,-1,99769), -- Sealed Tallum Helm Design
(21761,6335,1,1,-1,24823), -- Recipe: Sealed Majestic Necklace(70%)
(21761,57,2601,5296,0,700000), -- Adena
(21761,269,1,1,1,11), -- Blood Tornado
(21761,5539,1,1,1,3215), -- Blood Tornado Edge
(21761,1867,1,3,2,141217), -- Animal Skin
(21761,1872,1,3,2,211826), -- Animal Bone
(21761,1875,1,1,2,21183), -- Stone of Purity
(21761,1881,1,1,2,42366), -- Coarse Bone Powder
(21761,3957,1,1,2,142), -- Recipe: Blessed Spiritshot S
(21761,4041,1,1,2,2763), -- Mold Hardener
(21762,5529,1,1,-1,19889), -- Dragon Slayer Edge
(21762,5533,1,1,-1,19885), -- Elysian Head
(21762,6901,1,1,-1,7249), -- Recipe: Shining Arrow (100%)
(21762,57,2918,5954,0,700000), -- Adena
(21762,269,1,1,1,12), -- Blood Tornado
(21762,5539,1,1,1,3612), -- Blood Tornado Edge
(21762,1867,1,3,2,237929), -- Animal Skin
(21762,1872,1,3,2,158620), -- Animal Bone
(21762,1882,1,1,2,79310), -- Leather
(21762,1894,1,1,2,12523), -- Crafted Leather
(21762,4042,1,1,2,5949), -- Enria
(21762,5277,1,1,2,159), -- Recipe: Greater Spiritshot (S) Compressed Package(100%)
(21763,5535,1,1,-1,8315), -- Carnage Bow Stave
(21763,6337,1,1,-1,12497), -- Recipe: Sealed Majestic Earring(70%)
(21763,6339,1,1,-1,18746), -- Recipe: Sealed Majestic Ring(70%)
(21763,57,983,2000,0,700000), -- Adena
(21763,212,1,1,1,2), -- Dasparion\'s Staff
(21763,2504,1,1,1,2), -- Meteor Shower
(21763,5532,1,1,1,607), -- Meteor Shower Head
(21763,5543,1,1,1,613), -- Dasparion\'s Staff Edge
(21763,1343,10,30,2,128541), -- Silver Arrow
(21763,1867,1,1,2,119972), -- Animal Skin
(21763,1872,1,1,2,119972), -- Animal Bone
(21763,1882,1,1,2,19996), -- Leather
(21763,1894,1,1,2,3158), -- Crafted Leather
(21763,4042,1,1,2,1500), -- Enria
(21763,5450,1,1,2,34), -- Recipe: Dragon Grinder(60%)
(21763,6671,1,1,2,9998), -- Deluxe Chest Key - Grade 7
(21764,4040,1,1,-1,305197), -- Mold Lubricant
(21764,4042,1,1,-1,254331), -- Enria
(21764,5534,1,1,-1,41894), -- Soul Bow Stave
(21764,57,6142,12533,0,700000), -- Adena
(21764,269,1,1,1,25), -- Blood Tornado
(21764,5539,1,1,1,7602), -- Blood Tornado Edge
(21764,1344,60,180,2,156512), -- Mithril Arrow
(21764,1895,1,1,2,214645), -- Metallic Fiber
(21764,4040,1,1,2,15026), -- Mold Lubricant
(21764,4042,1,1,2,12521), -- Enria
(21764,4043,1,1,2,25042), -- Asofe
(21764,5282,1,1,2,334), -- Recipe: Greater Blessed Spiritshot (S) Compressed Package(100%)
(21765,1808,1,1,-1,6911), -- Recipe: Soulshot: S Grade
(21765,3036,1,1,-1,6911), -- Recipe: Spiritshot S
(21765,5537,1,1,-1,42658), -- Soul Separator Head
(21765,57,6259,12770,0,700000), -- Adena
(21765,288,1,1,1,26), -- Carnage Bow
(21765,5535,1,1,1,7835), -- Carnage Bow Stave
(21765,1868,3,9,2,255161), -- Thread
(21765,1873,2,6,2,76549), -- Silver Nugget
(21765,1889,1,1,2,51033), -- Compound Braid
(21765,4044,1,1,2,25517), -- Thons
(21765,5549,1,1,2,76549), -- Metallic Thread
(21765,6901,1,1,2,766), -- Recipe: Shining Arrow (100%)
(21766,1875,1,1,-1,40424), -- Stone of Purity
(21766,4041,1,1,-1,5273), -- Mold Hardener
(21766,5538,1,1,-1,1663), -- Dragon Grinder Edge
(21766,57,244,498,0,700000), -- Adena
(21766,235,1,1,1,1), -- Bloody Orchid
(21766,5536,1,1,1,306), -- Bloody Orchid Head
(21766,1344,10,30,2,31984), -- Mithril Arrow
(21766,1808,1,1,2,12), -- Recipe: Soulshot: S Grade
(21766,1867,1,1,2,34116), -- Animal Skin
(21766,1872,1,1,2,34116), -- Animal Bone
(21766,1875,1,1,2,1706), -- Stone of Purity
(21766,1881,1,1,2,3412), -- Coarse Bone Powder
(21766,4041,1,1,2,223), -- Mold Hardener
(21767,729,1,1,-1,161), -- Scroll: Enchant Weapon (Grade A)
(21767,4044,1,1,-1,48251), -- Thons
(21767,5536,1,1,-1,4925), -- Bloody Orchid Head
(21767,57,584,1188,0,700000), -- Adena
(21767,269,1,1,1,3), -- Blood Tornado
(21767,5539,1,1,1,721), -- Blood Tornado Edge
(21767,1868,1,1,2,142527), -- Thread
(21767,1873,1,1,2,28506), -- Silver Nugget
(21767,1889,1,1,2,4751), -- Compound Braid
(21767,4044,1,1,2,2376), -- Thons
(21767,5456,1,1,2,27), -- Recipe: Tallum Glaive(60%)
(21767,5549,1,1,2,7127), -- Metallic Thread
(21768,5535,1,1,-1,50145), -- Carnage Bow Stave
(21768,6337,1,1,-1,75366), -- Recipe: Sealed Majestic Earring(70%)
(21768,6339,1,1,-1,113048), -- Recipe: Sealed Majestic Ring(70%)
(21768,57,5923,12058,0,700000), -- Adena
(21768,235,1,1,1,24), -- Bloody Orchid
(21768,5536,1,1,1,7385), -- Bloody Orchid Head
(21768,1866,1,3,2,160780), -- Suede
(21768,1871,4,12,2,90439), -- Charcoal
(21768,1877,1,1,2,28941), -- Adamantite Nugget
(21768,4040,1,1,2,14471), -- Mold Lubricant
(21768,4041,1,1,2,6292), -- Mold Hardener
(21768,5162,1,1,2,322), -- Recipe: Spiritshot (S) Compressed Package (100%)
(21769,729,1,1,-1,1446), -- Scroll: Enchant Weapon (Grade A)
(21769,5478,1,1,-1,109401), -- Sealed Dark Crystal Leather Armor Pattern
(21769,6671,1,3,-1,722777), -- Deluxe Chest Key - Grade 7
(21769,57,5248,10676,0,700000), -- Adena
(21769,6671,3,9,2,355828), -- Deluxe Chest Key - Grade 7
(21770,1894,1,1,-1,500270), -- Crafted Leather
(21770,6671,1,3,-1,792095), -- Deluxe Chest Key - Grade 7
(21770,57,5746,11699,0,700000), -- Adena
(21770,6671,3,9,2,389954), -- Deluxe Chest Key - Grade 7
(21771,729,1,1,-1,1425), -- Scroll: Enchant Weapon (Grade A)
(21771,730,1,1,-1,10688), -- Scroll: Enchant Armor (Grade A)
(21771,5479,1,1,-1,75894), -- Sealed Tallum Leather Armor Pattern
(21771,57,5173,10525,0,700000), -- Adena
(21771,235,1,1,1,21), -- Bloody Orchid
(21771,5536,1,1,1,6446), -- Bloody Orchid Head
(21771,729,1,1,2,211), -- Scroll: Enchant Weapon (Grade A)
(21771,730,1,1,2,1579), -- Scroll: Enchant Armor (Grade A)
(21772,729,1,1,-1,1657), -- Scroll: Enchant Weapon (Grade A)
(21772,730,1,1,-1,12428), -- Scroll: Enchant Armor (Grade A)
(21772,6901,1,1,-1,14913), -- Recipe: Shining Arrow (100%)
(21772,57,6003,12248,0,700000), -- Adena
(21772,212,1,1,1,13), -- Dasparion\'s Staff
(21772,2504,1,1,1,13), -- Meteor Shower
(21772,5532,1,1,1,3713), -- Meteor Shower Head
(21772,5543,1,1,1,3748), -- Dasparion\'s Staff Edge
(21772,729,1,1,2,245), -- Scroll: Enchant Weapon (Grade A)
(21772,730,1,1,2,1836), -- Scroll: Enchant Armor (Grade A)
(21773,729,1,1,-1,1510), -- Scroll: Enchant Weapon (Grade A)
(21773,730,1,1,-1,11328), -- Scroll: Enchant Armor (Grade A)
(21773,5482,1,1,-1,179418), -- Sealed Dark Crystalline Leggings Design
(21773,57,5478,11154,0,700000), -- Adena
(21773,288,1,1,1,22), -- Carnage Bow
(21773,5535,1,1,1,6851), -- Carnage Bow Stave
(21773,729,1,1,2,224), -- Scroll: Enchant Weapon (Grade A)
(21773,730,1,1,2,1673), -- Scroll: Enchant Armor (Grade A)
(21774,1876,1,3,-1,937757), -- Mithril Ore
(21774,1895,1,5,-1,893102), -- Metallic Fiber
(21774,5546,1,1,-1,28259), -- Sword of Miracles Edge
(21774,57,3773,7702,0,700000), -- Adena
(21774,305,1,1,1,11), -- Tallum Glaive
(21774,5541,1,1,1,3798), -- Tallum Glaive Edge
(21774,959,1,1,2,19), -- Scroll: Enchant Weapon (Grade S)
(21774,1868,3,9,2,153889), -- Thread
(21774,1873,2,6,2,46167), -- Silver Nugget
(21774,1876,1,1,2,92333), -- Mithril Ore
(21774,1895,1,1,2,131904), -- Metallic Fiber
(21774,4042,1,1,2,7695), -- Enria
(21775,960,1,1,-1,4468), -- Scroll: Enchant Armor (Grade S)
(21775,4041,1,1,-1,97124), -- Mold Hardener
(21775,5220,1,1,-1,446773), -- Metal Hardener
(21775,57,4493,9173,0,700000), -- Adena
(21775,5311,1,1,1,17), -- Sealed Armor of Nightmare
(21775,5316,1,1,1,17), -- Sealed Majestic Plate Armor
(21775,5522,1,1,1,2809), -- Sealed Armor of Nightmare Pattern
(21775,5523,1,1,1,2809), -- Sealed Majestic Plate Armor Pattern
(21775,959,1,1,2,22), -- Scroll: Enchant Weapon (Grade S)
(21775,1866,1,3,2,122195), -- Suede
(21775,1871,1,3,2,274937), -- Charcoal
(21775,1885,1,1,2,45823), -- High Grade Suede
(21775,4041,1,1,2,4782), -- Mold Hardener
(21775,5220,1,1,2,21995), -- Metal Hardener
(21776,6707,1,1,-1,45354), -- Sealed Draconic Leather Armor Part
(21776,6708,1,1,-1,130329), -- Sealed Draconic Leather Gloves Fabric
(21776,6709,1,1,-1,130329), -- Sealed Draconic Leather Boots Design
(21776,57,3684,7518,0,700000), -- Adena
(21776,5326,1,1,1,18), -- Sealed Robe of Nightmare
(21776,5329,1,1,1,18), -- Sealed Majestic Robe
(21776,5487,1,1,1,3045), -- Sealed Robe of Nightmare Fabric
(21776,5488,1,1,1,3045), -- Sealed Majestic Robe Fabric
(21776,960,1,1,2,155), -- Scroll: Enchant Armor (Grade S)
(21776,1344,40,120,2,120708), -- Mithril Arrow
(21776,1867,5,15,2,51502), -- Animal Skin
(21776,1872,1,3,2,171673), -- Animal Bone
(21776,1882,1,1,2,85837), -- Leather
(21776,1894,1,1,2,13554), -- Crafted Leather
(21776,4042,1,1,2,6438), -- Enria
(21777,6691,1,1,-1,20740), -- Angel Slayer Blade
(21777,6693,1,1,-1,21116), -- Dragon Hunter Axe Blade
(21777,6694,1,1,-1,21116), -- Saint Spear Blade
(21777,57,3860,7880,0,700000), -- Adena
(21777,5326,1,1,1,19), -- Sealed Robe of Nightmare
(21777,5329,1,1,1,19), -- Sealed Majestic Robe
(21777,5487,1,1,1,3192), -- Sealed Robe of Nightmare Fabric
(21777,5488,1,1,1,3192), -- Sealed Majestic Robe Fabric
(21777,960,1,1,2,163), -- Scroll: Enchant Armor (Grade S)
(21777,1344,30,90,2,168708), -- Mithril Arrow
(21777,1864,5,15,2,80980), -- Stem
(21777,1869,2,6,2,101225), -- Iron Ore
(21777,1880,1,1,2,40490), -- Steel
(21777,4043,1,1,2,13497), -- Asofe
(21777,5550,1,1,2,5399), -- Durable Metal Plate
(21778,960,1,1,-1,4004), -- Scroll: Enchant Armor (Grade S)
(21778,4042,1,1,-1,166816), -- Enria
(21778,4043,1,1,-1,333633), -- Asofe
(21778,57,4028,8221,0,700000), -- Adena
(21778,6326,1,1,1,38), -- Sealed Majestic Necklace
(21778,6327,1,1,1,51), -- Sealed Majestic Earring
(21778,6328,1,1,1,76), -- Sealed Majestic Ring
(21778,6342,1,1,1,11162), -- Sealed Majestic Earring Gemstone
(21778,6344,1,1,1,7224), -- Sealed Majestic Necklace Beads
(21778,6346,1,1,1,16043), -- Sealed Majestic Ring Gemstone
(21778,959,1,1,2,24), -- Scroll: Enchant Weapon (Grade S)
(21778,1895,1,1,2,168943), -- Metallic Fiber
(21778,4040,1,1,2,11827), -- Mold Lubricant
(21778,4042,1,1,2,9856), -- Enria
(21778,4043,1,1,2,19711), -- Asofe
(21779,5162,1,1,-1,2697), -- Recipe: Spiritshot (S) Compressed Package (100%)
(21779,5167,1,1,-1,2697), -- Recipe: Blessed Spiritshot (S) Compressed Package (100%)
(21779,6342,1,1,-1,137475), -- Sealed Majestic Earring Gemstone
(21779,57,2441,4984,0,700000), -- Adena
(21779,5320,1,1,1,12), -- Sealed Leather Armor of Nightmare
(21779,5323,1,1,1,12), -- Sealed Majestic Leather Armor
(21779,5480,1,1,1,2012), -- Sealed Leather Armor of Nightmare Fabric
(21779,5481,1,1,1,2012), -- Sealed Majestic Leather Armor Fabric
(21779,960,1,1,2,120), -- Scroll: Enchant Armor (Grade S)
(21779,1344,10,30,2,373464), -- Mithril Arrow
(21779,1894,1,1,2,10484), -- Crafted Leather
(21779,4039,1,1,2,9959), -- Mold Glue
(21779,4041,1,1,2,2599), -- Mold Hardener
(21779,4044,1,1,2,9959), -- Thons
(21780,959,1,1,-1,340), -- Scroll: Enchant Weapon (Grade S)
(21780,1894,1,1,-1,298162), -- Crafted Leather
(21780,4042,1,1,-1,141627), -- Enria
(21780,57,3419,6979,0,700000), -- Adena
(21780,6326,1,1,1,33), -- Sealed Majestic Necklace
(21780,6327,1,1,1,43), -- Sealed Majestic Earring
(21780,6328,1,1,1,65), -- Sealed Majestic Ring
(21780,6342,1,1,1,9477), -- Sealed Majestic Earring Gemstone
(21780,6344,1,1,1,6133), -- Sealed Majestic Necklace Beads
(21780,6346,1,1,1,13620), -- Sealed Majestic Ring Gemstone
(21780,959,1,1,2,17), -- Scroll: Enchant Weapon (Grade S)
(21780,1867,4,12,2,69724), -- Animal Skin
(21780,1872,1,3,2,185931), -- Animal Bone
(21780,1882,1,1,2,92965), -- Leather
(21780,1894,1,1,2,14679), -- Crafted Leather
(21780,4042,1,1,2,6973), -- Enria
(21781,4040,1,1,-1,152264), -- Mold Lubricant
(21781,4041,1,1,-1,66202), -- Mold Hardener
(21781,6344,1,1,-1,111606), -- Sealed Majestic Necklace Beads
(21781,57,3063,6253,0,700000), -- Adena
(21781,5311,1,1,1,11), -- Sealed Armor of Nightmare
(21781,5316,1,1,1,11), -- Sealed Majestic Plate Armor
(21781,5522,1,1,1,1915), -- Sealed Armor of Nightmare Pattern
(21781,5523,1,1,1,1915), -- Sealed Majestic Plate Armor Pattern
(21781,959,1,1,2,16), -- Scroll: Enchant Weapon (Grade S)
(21781,1866,1,1,2,249870), -- Suede
(21781,1871,1,3,2,187403), -- Charcoal
(21781,1877,1,1,2,14993), -- Adamantite Nugget
(21781,4040,1,1,2,7497), -- Mold Lubricant
(21781,4041,1,1,2,3260), -- Mold Hardener
(21782,6710,1,1,-1,131297), -- Sealed Draconic Leather Helmet Pattern
(21782,6711,1,1,-1,40103), -- Sealed Major Arcana Robe Part
(21782,6712,1,1,-1,115239), -- Sealed Major Arcana Gloves fabric
(21782,57,3257,6648,0,700000), -- Adena
(21782,5313,1,1,1,34), -- Sealed Gloves of Nightmare
(21782,5314,1,1,1,34), -- Sealed Boots of Nightmare
(21782,5318,1,1,1,34), -- Sealed Majestic Gloves
(21782,5319,1,1,1,34), -- Sealed Majestic Boots
(21782,5502,1,1,1,5047), -- Sealed Boots of Nightmare Lining
(21782,5503,1,1,1,5047), -- Sealed Majestic Boots Lining
(21782,5514,1,1,1,5047), -- Sealed Gloves of Nightmare Design
(21782,5515,1,1,1,5047), -- Sealed Majestic Gloves Design
(21782,960,1,1,2,137), -- Scroll: Enchant Armor (Grade S)
(21782,1344,150,450,2,28462), -- Mithril Arrow
(21782,1868,4,12,2,85386), -- Thread
(21782,1873,1,1,2,136617), -- Silver Nugget
(21782,1876,1,1,2,68309), -- Mithril Ore
(21782,1895,1,1,2,97584), -- Metallic Fiber
(21782,4042,1,1,2,5693), -- Enria
(21783,5272,1,1,-1,3562), -- Recipe: Greater Soulshot (S) Compressed Package(100%)
(21783,5480,1,1,-1,35965), -- Sealed Leather Armor of Nightmare Fabric
(21783,6346,1,1,-1,260950), -- Sealed Majestic Ring Gemstone
(21783,57,3224,6583,0,700000), -- Adena
(21783,5326,1,1,1,16), -- Sealed Robe of Nightmare
(21783,5329,1,1,1,16), -- Sealed Majestic Robe
(21783,5487,1,1,1,2666), -- Sealed Robe of Nightmare Fabric
(21783,5488,1,1,1,2666), -- Sealed Majestic Robe Fabric
(21783,960,1,1,2,136), -- Scroll: Enchant Armor (Grade S)
(21783,1344,20,60,2,211387), -- Mithril Arrow
(21783,1865,1,3,2,112740), -- Varnish
(21783,1870,2,6,2,84555), -- Coal
(21783,1875,1,1,2,22549), -- Stone of Purity
(21783,1879,1,1,2,56370), -- Cokes
(21783,4040,1,1,2,6765), -- Mold Lubricant
(21784,959,1,1,-1,341), -- Scroll: Enchant Weapon (Grade S)
(21784,4041,1,1,-1,74112), -- Mold Hardener
(21784,4044,1,1,-1,284097), -- Thons
(21784,57,3430,7000,0,700000), -- Adena
(21784,5312,1,1,1,32), -- Sealed Helm of Nightmare
(21784,5315,1,1,1,46), -- Sealed Shield of Nightmare
(21784,5317,1,1,1,32), -- Sealed Majestic Circlet
(21784,5495,1,1,1,6372), -- Sealed Shield of Nightmare Fragment
(21784,5527,1,1,1,5017), -- Sealed Helm of Nightmare Design
(21784,5528,1,1,1,5017), -- Sealed Majestic Circlet Design
(21784,959,1,1,2,21), -- Scroll: Enchant Weapon (Grade S)
(21784,1894,1,1,2,17667), -- Crafted Leather
(21784,4039,1,1,2,16784), -- Mold Glue
(21784,4041,1,1,2,4379), -- Mold Hardener
(21784,4044,1,1,2,16784), -- Thons
(21785,6695,1,1,-1,20090), -- Demon Splinter Blade
(21785,6696,1,1,-1,20802), -- Heavens Divider Edge
(21785,6697,1,1,-1,20090), -- Arcana Mace Head
(21785,57,3811,7780,0,700000), -- Adena
(21785,5313,1,1,1,40), -- Sealed Gloves of Nightmare
(21785,5314,1,1,1,40), -- Sealed Boots of Nightmare
(21785,5318,1,1,1,40), -- Sealed Majestic Gloves
(21785,5319,1,1,1,40), -- Sealed Majestic Boots
(21785,5502,1,1,1,5908), -- Sealed Boots of Nightmare Lining
(21785,5503,1,1,1,5908), -- Sealed Majestic Boots Lining
(21785,5514,1,1,1,5908), -- Sealed Gloves of Nightmare Design
(21785,5515,1,1,1,5908), -- Sealed Majestic Gloves Design
(21785,960,1,1,2,160), -- Scroll: Enchant Armor (Grade S)
(21785,1344,150,450,2,33313), -- Mithril Arrow
(21785,1868,4,12,2,99938), -- Thread
(21785,1873,1,1,2,159901), -- Silver Nugget
(21785,1889,1,1,2,26651), -- Compound Braid
(21785,4044,1,1,2,13326), -- Thons
(21785,5549,1,1,2,39976), -- Metallic Thread
(21786,5220,1,1,-1,130512), -- Metal Hardener
(21786,5277,1,1,-1,1450), -- Recipe: Greater Spiritshot (S) Compressed Package(100%)
(21786,5481,1,1,-1,14641), -- Sealed Majestic Leather Armor Fabric
(21786,57,1313,2680,0,700000), -- Adena
(21786,6326,1,1,1,13), -- Sealed Majestic Necklace
(21786,6327,1,1,1,17), -- Sealed Majestic Earring
(21786,6328,1,1,1,25), -- Sealed Majestic Ring
(21786,6342,1,1,1,3639), -- Sealed Majestic Earring Gemstone
(21786,6344,1,1,1,2355), -- Sealed Majestic Necklace Beads
(21786,6346,1,1,1,5230), -- Sealed Majestic Ring Gemstone
(21786,1866,1,1,2,107088), -- Suede
(21786,1871,1,1,2,160631), -- Charcoal
(21786,1885,1,1,2,13386), -- High Grade Suede
(21786,4041,1,1,2,1397), -- Mold Hardener
(21786,5220,1,1,2,6426), -- Metal Hardener
(21786,6672,1,1,2,13387), -- Deluxe Chest Key - Grade 8
(21787,959,1,1,-1,798), -- Scroll: Enchant Weapon (Grade S)
(21787,960,1,1,-1,7976), -- Scroll: Enchant Armor (Grade S)
(21787,6688,1,1,-1,43102), -- Forgotten Blade Edge
(21787,57,8022,16377,0,700000), -- Adena
(21787,5312,1,1,1,75), -- Sealed Helm of Nightmare
(21787,5315,1,1,1,107), -- Sealed Shield of Nightmare
(21787,5317,1,1,1,75), -- Sealed Majestic Circlet
(21787,5495,1,1,1,14907), -- Sealed Shield of Nightmare Fragment
(21787,5527,1,1,1,11737), -- Sealed Helm of Nightmare Design
(21787,5528,1,1,1,11737), -- Sealed Majestic Circlet Design
(21787,959,1,1,2,40), -- Scroll: Enchant Weapon (Grade S)
(21787,1864,36,108,2,27270), -- Stem
(21787,1865,2,6,2,196345), -- Varnish
(21787,1866,3,9,2,109080), -- Suede
(21787,1868,10,30,2,93498), -- Thread
(21787,1873,4,12,2,49086), -- Silver Nugget
(21788,6698,1,1,-1,399111), -- Sealed Tateossian Earring  Part
(21788,6699,1,1,-1,442867), -- Sealed Tateossian Ring Gem
(21788,6700,1,1,-1,243251), -- Sealed Tateossian Ring Wire
(21788,57,8174,16687,0,700000), -- Adena
(21788,81,1,1,1,8), -- Dragon Slayer
(21788,151,1,1,1,8), -- Sword of Miracles 
(21788,2500,1,1,1,8), -- Dark Legion\'s Edge
(21788,5529,1,1,1,2745), -- Dragon Slayer Edge
(21788,5545,1,1,1,2745), -- Dark Legion\'s Edge Blade
(21788,5546,1,1,1,3015), -- Sword of Miracles Edge
(21788,960,1,1,2,344), -- Scroll: Enchant Armor (Grade S)
(21788,1344,400,1200,2,26794), -- Mithril Arrow
(21788,1867,13,39,2,42341), -- Animal Skin
(21788,1869,27,81,2,15590), -- Iron Ore
(21788,1870,3,9,2,142899), -- Coal
(21788,1871,3,9,2,122485), -- Charcoal
(21788,1872,8,24,2,71450), -- Animal Bone
(21789,959,1,1,-1,32), -- Scroll: Enchant Weapon (Grade S)
(21789,1894,1,1,-1,27802), -- Crafted Leather
(21789,4039,1,1,-1,26412), -- Mold Glue
(21789,57,319,651,0,700000), -- Adena
(21789,164,1,1,1,1), -- Elysian
(21789,213,1,1,1,1), -- Branch of The Mother Tree
(21789,5533,1,1,1,161), -- Elysian Head
(21789,5544,1,1,1,161), -- Branch of The Mother Tree Head
(21789,959,1,1,2,2), -- Scroll: Enchant Weapon (Grade S)
(21789,1894,1,1,2,1643), -- Crafted Leather
(21789,4039,1,1,2,1561), -- Mold Glue
(21789,4041,1,1,2,408), -- Mold Hardener
(21789,4044,1,1,2,1561), -- Thons
(21790,5282,1,1,-1,861), -- Recipe: Greater Blessed Spiritshot (S) Compressed Package(100%)
(21790,5487,1,1,-1,8727), -- Sealed Robe of Nightmare Fabric
(21790,5550,1,1,-1,25841), -- Durable Metal Plate
(21790,57,780,1592,0,700000), -- Adena
(21790,5313,1,1,1,9), -- Sealed Gloves of Nightmare
(21790,5314,1,1,1,9), -- Sealed Boots of Nightmare
(21790,5318,1,1,1,9), -- Sealed Majestic Gloves
(21790,5319,1,1,1,9), -- Sealed Majestic Boots
(21790,5502,1,1,1,1209), -- Sealed Boots of Nightmare Lining
(21790,5503,1,1,1,1209), -- Sealed Majestic Boots Lining
(21790,5514,1,1,1,1209), -- Sealed Gloves of Nightmare Design
(21790,5515,1,1,1,1209), -- Sealed Majestic Gloves Design
(21790,960,1,1,2,33), -- Scroll: Enchant Armor (Grade S)
(21790,1344,10,30,2,102231), -- Mithril Arrow
(21790,1864,1,1,2,163568), -- Stem
(21790,1869,1,1,2,81784), -- Iron Ore
(21790,1880,1,1,2,8179), -- Steel
(21790,4043,1,1,2,2727), -- Asofe
(21790,5550,1,1,2,1091), -- Durable Metal Plate
(21791,960,1,1,-1,7763), -- Scroll: Enchant Armor (Grade S)
(21791,1875,1,3,-1,646906), -- Stone of Purity
(21791,4040,1,1,-1,388144), -- Mold Lubricant
(21791,57,7810,15940,0,700000), -- Adena
(21791,164,1,1,1,11), -- Elysian
(21791,213,1,1,1,11), -- Branch of The Mother Tree
(21791,5533,1,1,1,3932), -- Elysian Head
(21791,5544,1,1,1,3928), -- Branch of The Mother Tree Head
(21791,959,1,1,2,39), -- Scroll: Enchant Weapon (Grade S)
(21791,1865,4,12,2,119429), -- Varnish
(21791,1870,7,21,2,63696), -- Coal
(21791,1875,1,1,2,63696), -- Stone of Purity
(21791,1879,1,1,2,159239), -- Cokes
(21791,4040,1,1,2,19109), -- Mold Lubricant
(21792,1894,1,1,-1,611196), -- Crafted Leather
(21792,6672,1,3,-1,725795), -- Deluxe Chest Key - Grade 8
(21792,57,7008,14306,0,700000), -- Adena
(21792,6672,3,9,2,357314), -- Deluxe Chest Key - Grade 8
(21793,6672,1,3,-1,784501), -- Deluxe Chest Key - Grade 8
(21793,6689,1,1,-1,39930), -- Basalt Battlehammer Head
(21793,6690,1,1,-1,40774), -- Imperial Staff Head
(21793,57,7577,15464,0,700000), -- Adena
(21793,6672,3,9,2,386216), -- Deluxe Chest Key - Grade 8
(21794,959,1,1,-1,687), -- Scroll: Enchant Weapon (Grade S)
(21794,960,1,1,-1,6869), -- Scroll: Enchant Armor (Grade S)
(21794,1808,1,1,-1,7632), -- Recipe: Soulshot: S Grade
(21794,57,6908,14104,0,700000), -- Adena
(21794,81,1,1,1,7), -- Dragon Slayer
(21794,151,1,1,1,7), -- Sword of Miracles 
(21794,2500,1,1,1,7), -- Dark Legion\'s Edge
(21794,5529,1,1,1,2320), -- Dragon Slayer Edge
(21794,5545,1,1,1,2320), -- Dark Legion\'s Edge Blade
(21794,5546,1,1,1,2548), -- Sword of Miracles Edge
(21794,959,1,1,2,102), -- Scroll: Enchant Weapon (Grade S)
(21794,960,1,1,2,1015), -- Scroll: Enchant Armor (Grade S)
(21795,959,1,1,-1,780), -- Scroll: Enchant Weapon (Grade S)
(21795,960,1,1,-1,7795), -- Scroll: Enchant Armor (Grade S)
(21795,6691,1,1,-1,42123), -- Angel Slayer Blade
(21795,57,7840,16005,0,700000), -- Adena
(21795,289,1,1,1,22), -- Soul Bow
(21795,5534,1,1,1,7902), -- Soul Bow Stave
(21795,959,1,1,2,116), -- Scroll: Enchant Weapon (Grade S)
(21795,960,1,1,2,1151), -- Scroll: Enchant Armor (Grade S)
(21796,959,1,1,-1,718), -- Scroll: Enchant Weapon (Grade S)
(21796,960,1,1,-1,7180), -- Scroll: Enchant Armor (Grade S)
(21796,57,7224,14744,0,700000), -- Adena
(21796,289,1,1,1,20), -- Soul Bow
(21796,5534,1,1,1,7279), -- Soul Bow Stave
(21796,959,1,1,2,107), -- Scroll: Enchant Weapon (Grade S)
(21796,960,1,1,2,1061), -- Scroll: Enchant Armor (Grade S)
(21797,1867,1,1,-1,869731), -- Animal Skin
(21797,1869,1,1,-1,652298), -- Iron Ore
(21797,2961,1,1,-1,35519), -- Full Plate Boots Part
(21797,57,263,536,0,700000), -- Adena
(21797,2414,1,1,1,23), -- Full Plate Helmet
(21797,2497,1,1,1,33), -- Full Plate Shield
(21797,2959,1,1,1,2083), -- Full Plate Helmet Design
(21797,2966,1,1,1,3295), -- Full Plate Shield Fragment
(21797,1867,1,1,2,45876), -- Animal Skin
(21797,1869,1,1,2,34407), -- Iron Ore
(21797,1870,1,1,2,34407), -- Coal
(21797,1871,1,1,2,34407), -- Charcoal
(21797,1872,1,1,2,45876), -- Animal Bone
(21797,4175,1,1,2,663), -- Recipe: Avadon Boots
(21797,4972,1,1,2,40), -- Recipe: Great Axe (60%)
(21798,5282,1,1,-1,2192), -- Recipe: Greater Blessed Spiritshot (S) Compressed Package(100%)
(21798,5487,1,1,-1,22211), -- Sealed Robe of Nightmare Fabric
(21798,5488,1,1,-1,22211), -- Sealed Majestic Robe Fabric
(21798,57,1980,4055,0,700000), -- Adena
(21798,5297,1,1,1,14), -- Sealed Dark Crystal Leather Armor
(21798,5298,1,1,1,23), -- Sealed Dark Crystalline Leggings
(21798,5301,1,1,1,10), -- Sealed Tallum Leather Armor
(21798,5478,1,1,1,2042), -- Sealed Dark Crystal Leather Armor Pattern
(21798,5479,1,1,1,1437), -- Sealed Tallum Leather Armor Pattern
(21798,5482,1,1,1,3205), -- Sealed Dark Crystalline Leggings Design
(21798,1344,10,30,2,260174), -- Mithril Arrow
(21798,1895,1,1,2,59469), -- Metallic Fiber
(21798,4040,1,1,2,4163), -- Mold Lubricant
(21798,4042,1,1,2,3470), -- Enria
(21798,4043,1,1,2,6939), -- Asofe
(21798,5282,1,1,2,93), -- Recipe: Greater Blessed Spiritshot (S) Compressed Package(100%)
(21798,6672,1,1,2,17345), -- Deluxe Chest Key - Grade 8
(21799,1894,1,1,-1,318295), -- Crafted Leather
(21799,5495,1,1,-1,137748), -- Sealed Shield of Nightmare Fragment
(21799,6901,1,1,-1,9071), -- Recipe: Shining Arrow (100%)
(21799,57,3642,7457,0,700000), -- Adena
(21799,212,1,1,1,8), -- Dasparion\'s Staff
(21799,2504,1,1,1,8), -- Meteor Shower
(21799,5532,1,1,1,2259), -- Meteor Shower Head
(21799,5543,1,1,1,2280), -- Dasparion\'s Staff Edge
(21799,6901,1,1,2,2680), -- Recipe: Shining Arrow (100%)
(21800,4042,1,1,-1,76772), -- Enria
(21800,5167,1,1,-1,2047), -- Recipe: Blessed Spiritshot (S) Compressed Package (100%)
(21800,5529,1,1,-1,12637), -- Dragon Slayer Edge
(21800,57,1853,3785,0,700000), -- Adena
(21800,212,1,1,1,4), -- Dasparion\'s Staff
(21800,2504,1,1,1,4), -- Meteor Shower
(21800,5532,1,1,1,1147), -- Meteor Shower Head
(21800,5543,1,1,1,1158), -- Dasparion\'s Staff Edge
(21800,1344,40,120,2,60743), -- Mithril Arrow
(21800,1867,1,3,2,129584), -- Animal Skin
(21800,1872,1,3,2,86390), -- Animal Bone
(21800,1882,1,1,2,43195), -- Leather
(21800,1894,1,1,2,6821), -- Crafted Leather
(21800,4042,1,1,2,3240), -- Enria
(21800,5272,1,1,2,87), -- Recipe: Greater Soulshot (S) Compressed Package(100%)
(21801,1864,1,1,-1,469914), -- Stem
(21801,1869,1,1,-1,234957), -- Iron Ore
(21801,1926,1,1,-1,23733), -- Piece Bone Breastplate Fragment
(21801,57,107,191,0,700000), -- Adena
(21801,39,1,1,1,753), -- Boots
(21801,51,1,1,1,753), -- Bracer
(21801,1930,1,1,1,11864), -- Boot Lining
(21801,1864,1,1,2,69403), -- Stem
(21801,1869,1,1,2,34702), -- Iron Ore
(21801,1878,1,1,2,13881), -- Braided Hemp
(21801,2151,1,1,2,9667), -- Recipe: Necklace of Devotion
(21802,1928,1,1,-1,40001), -- Piece Bone Gaiters Fragment
(21802,2151,1,1,-1,76492), -- Recipe: Necklace of Devotion
(21802,2176,1,1,-1,131391), -- Recipe: Leather Boots
(21802,57,122,225,0,700000), -- Adena
(21802,625,1,1,1,1258), -- Bone Shield
(21802,1148,1,1,1,882), -- Hard Leather Helmet
(21802,1865,1,1,2,40558), -- Varnish
(21802,1870,1,1,2,40558), -- Coal
(21802,1879,1,1,2,6760), -- Cokes
(21802,2176,1,1,2,19406), -- Recipe: Leather Boots
(21803,1871,1,1,-1,317362), -- Charcoal
(21803,1899,1,1,-1,49588), -- Necklace of Devotion Chain
(21803,5220,1,1,-1,12695), -- Metal Hardener
(21803,57,137,264,0,700000), -- Adena
(21803,40,1,1,1,427), -- Leather Boots
(21803,604,1,1,1,427), -- Crafted Leather Gloves
(21803,1931,1,1,1,5821), -- Leather Boot Lining
(21803,1934,1,1,1,5821), -- Crafted Leather Gloves Lining
(21803,1866,1,1,2,23749), -- Suede
(21803,1871,1,1,2,35623), -- Charcoal
(21803,1885,1,1,2,2969), -- High Grade Suede
(21803,2152,1,1,2,6272), -- Recipe: Enchanted Necklace
(21803,5220,1,1,2,1425), -- Metal Hardener
(21804,1061,1,1,-1,221263), -- Healing Potion
(21804,1900,1,1,-1,39943), -- Enchanted Necklace Chain
(21804,2250,1,1,-1,91271), -- Recipe: Bone Arrow
(21804,57,154,308,0,700000), -- Adena
(21804,46,1,1,1,400), -- Bronze Helmet
(21804,627,1,1,1,570), -- Aspis
(21804,1867,1,1,2,66502), -- Animal Skin
(21804,1872,1,1,2,66502), -- Animal Bone
(21804,1882,1,1,2,11084), -- Leather
(21804,2250,1,1,2,12469), -- Recipe: Bone Arrow
(21805,1901,1,1,-1,60152), -- Tiger\'s Eye Earring Stone
(21805,1938,1,1,-1,29277), -- Mithril Banded Mail Material
(21805,2154,1,1,-1,46627), -- Recipe: Elven Earring
(21805,57,184,368,0,700000), -- Adena
(21805,63,1,1,1,131), -- Gauntlets
(21805,553,1,1,1,131), -- Iron Boots
(21805,1940,1,1,1,4937), -- Iron Boots Design
(21805,2422,1,1,1,131), -- Reinforced Leather Boots
(21805,2423,1,1,1,131), -- Boots of Knowledge
(21805,2446,1,1,1,131), -- Reinforced Leather Gloves
(21805,2447,1,1,1,131), -- Gloves of Knowledge
(21805,1868,1,1,2,92622), -- Thread
(21805,1873,1,1,2,18525), -- Silver Nugget
(21805,1889,1,1,2,3088), -- Compound Braid
(21805,2154,1,1,2,4959), -- Recipe: Elven Earring
(21805,5549,1,1,2,4632), -- Metallic Thread
(21806,1864,1,3,-1,512417), -- Stem
(21806,1880,1,1,-1,51242), -- Steel
(21806,1939,1,1,-1,45008), -- Mithril Banded Gaiters Material
(21806,57,216,433,0,700000), -- Adena
(21806,47,1,1,1,358), -- Helmet
(21806,628,1,1,1,512), -- Hoplon
(21806,1864,1,1,2,108980), -- Stem
(21806,1869,1,1,2,54490), -- Iron Ore
(21806,1880,1,1,2,5449), -- Steel
(21806,2155,1,1,2,8747), -- Recipe: Elven Ring
(21806,5550,1,1,2,727), -- Durable Metal Plate
(21807,1902,1,1,-1,60588), -- Elven Earring Beads
(21807,2157,1,1,-1,49421), -- Recipe: Omen Beast\'s Eye Earring
(21807,2158,1,1,-1,74010), -- Recipe: Mithril Ring
(21807,57,253,504,0,700000), -- Adena
(21807,606,1,1,1,52), -- Rip Gauntlets
(21807,1124,1,1,1,52), -- Boots of Power
(21807,1946,1,1,1,2612), -- Rip Gauntlets Pattern
(21807,1948,1,1,1,2612), -- Boots of Power Pattern
(21807,2424,1,1,1,52), -- Manticore Skin Boots
(21807,2425,1,1,1,52), -- Brigandine Boots
(21807,2426,1,1,1,52), -- Elven Mithril Boots
(21807,2448,1,1,1,52), -- Manticore Skin Gloves
(21807,2449,1,1,1,52), -- Brigandine Gauntlets
(21807,2450,1,1,1,52), -- Elven Mithril Gloves
(21807,2923,1,1,1,2612), -- Manticore Skin Boot Lining
(21807,2924,1,1,1,2612), -- Brigandine Boots Design
(21807,2925,1,1,1,2612), -- Elven Mithril Boots Design
(21807,2926,1,1,1,2612), -- Manticore Skin Gloves Lining
(21807,2927,1,1,1,2612), -- Brigandine Gauntlets Pattern
(21807,2928,1,1,1,2612), -- Elven Mithril Gloves Design
(21807,1865,1,1,2,77281), -- Varnish
(21807,1870,1,1,2,77281), -- Coal
(21807,1874,1,1,2,5153), -- Oriharukon Ore
(21807,2157,1,1,2,6387), -- Recipe: Omen Beast\'s Eye Earring
(21808,1866,1,1,-1,460056), -- Suede
(21808,1871,1,1,-1,690083), -- Charcoal
(21808,1905,1,1,-1,67129), -- Omen Beast\'s Eye Earring Gemstone
(21808,57,282,570,0,700000), -- Adena
(21808,630,1,1,1,113), -- Square Shield
(21808,1956,1,1,1,6556), -- Square Shield Fragment
(21808,2412,1,1,1,79), -- Plate Helmet
(21808,2494,1,1,1,113), -- Plate Shield
(21808,2930,1,1,1,4656), -- Plate Helmet Design
(21808,2934,1,1,1,6556), -- Plate Shield Fragment
(21808,1866,1,1,2,57755), -- Suede
(21808,1871,1,1,2,86632), -- Charcoal
(21808,1877,1,1,2,3466), -- Adamantite Nugget
(21808,2160,1,1,2,5590), -- Recipe: Moonstone Earring
(21809,1908,1,1,-1,75095), -- Moonstone Earring Wire
(21809,2163,1,1,-1,40459), -- Recipe: Earring of Protection
(21809,4553,1,1,-1,3172), -- Greater Dye of Strength <Str+1 Con-1>
(21809,57,320,650,0,700000), -- Adena
(21809,62,1,1,1,34), -- Mithril Boots
(21809,1958,1,1,1,1872), -- Mithril Boots Design
(21809,2429,1,1,1,34), -- Chain Boots
(21809,2430,1,1,1,34), -- Karmian Boots
(21809,2431,1,1,1,34), -- Plated Leather Boots
(21809,2432,1,1,1,34), -- Dwarven Chain Boots
(21809,2433,1,1,1,34), -- Boots of Seal
(21809,2452,1,1,1,34), -- Reinforced Mithril Gloves
(21809,2453,1,1,1,34), -- Chain Gloves
(21809,2454,1,1,1,34), -- Karmian Gloves
(21809,2937,1,1,1,1872), -- Chain Boots Part
(21809,2938,1,1,1,1872), -- Karmian Boots Fabric
(21809,2939,1,1,1,1872), -- Plate Leather Boot Lining
(21809,2940,1,1,1,1872), -- Dwarven Chain Boots Part
(21809,2941,1,1,1,1872), -- Boots of Seal Pattern
(21809,2942,1,1,1,1872), -- Reinforced Mithril Gloves Design
(21809,2943,1,1,1,1872), -- Chain Gloves Design
(21809,2944,1,1,1,1872), -- Karmian Gloves Fabric
(21809,1867,1,1,2,83286), -- Animal Skin
(21809,1872,1,1,2,83286), -- Animal Bone
(21809,1875,1,1,2,4165), -- Stone of Purity
(21809,1881,1,1,2,8329), -- Coarse Bone Powder
(21809,2163,1,1,2,3188), -- Recipe: Earring of Protection
(21809,4041,1,1,2,544), -- Mold Hardener
(21810,1966,1,1,-1,32947), -- Plated Leather Fragment
(21810,1967,1,1,-1,49218), -- Plated Leather Gaiters Material
(21810,2166,1,1,-1,30590), -- Recipe: Earrings of Binding (100%)
(21810,57,364,740,0,700000), -- Adena
(21810,500,1,1,1,56), -- Great Helmet
(21810,632,1,1,1,79), -- Knight\'s Shield
(21810,1971,1,1,1,4080), -- Great Helmet Material
(21810,1972,1,1,1,5332), -- Knight\'s Shield Fragment
(21810,2496,1,1,1,86), -- Dwarven Chain Shield
(21810,2947,1,1,1,4760), -- Dwarven Chain Shield Fragment
(21810,1868,1,1,2,133280), -- Thread
(21810,1873,1,1,2,26656), -- Silver Nugget
(21810,1876,1,1,2,13328), -- Mithril Ore
(21810,1895,1,1,2,19040), -- Metallic Fiber
(21810,2166,1,1,2,2260), -- Recipe: Earrings of Binding (100%)
(21810,4042,1,1,2,1111), -- Enria
(21811,1878,1,1,-1,409067), -- Braided Hemp
(21811,1884,1,1,-1,629333), -- Cord
(21811,4601,1,1,-1,2273), -- Greater Dye of Strength <Str+3 Con-3>
(21811,57,413,839,0,700000), -- Adena
(21811,64,1,1,1,87), -- Composite Boots
(21811,608,1,1,1,87), -- Mithril Gauntlets
(21811,1981,1,1,1,6220), -- Mithril Gauntlets Design
(21811,2956,1,1,1,6220), -- Composite Boots Part
(21811,1864,1,1,2,140971), -- Stem
(21811,1869,1,1,2,70486), -- Iron Ore
(21811,1878,1,1,2,28195), -- Braided Hemp
(21811,1884,1,1,2,43376), -- Cord
(21811,2169,1,1,2,1248), -- Recipe: Necklace of Binding
(21811,4039,1,1,2,2350), -- Mold Glue
(21812,1984,1,1,-1,24686), -- Theca Leather Armor Pattern
(21812,1985,1,1,-1,39710), -- Theca Leather Gaiters Pattern
(21812,4126,1,1,-1,19003), -- Recipe: Adamantite Earrings
(21812,57,464,945,0,700000), -- Adena
(21812,2414,1,1,1,40), -- Full Plate Helmet
(21812,2497,1,1,1,57), -- Full Plate Shield
(21812,2959,1,1,1,3677), -- Full Plate Helmet Design
(21812,2966,1,1,1,5817), -- Full Plate Shield Fragment
(21812,1865,1,1,2,70867), -- Varnish
(21812,1870,1,1,2,70867), -- Coal
(21812,1875,1,1,2,4725), -- Stone of Purity
(21812,1879,1,1,2,11812), -- Cokes
(21812,4040,1,1,2,1418), -- Mold Lubricant
(21812,4126,1,1,2,1170), -- Recipe: Adamantite Earrings
(21813,947,1,1,-1,516), -- Scroll: Enchant Weapon (Grade B)
(21813,4049,1,1,-1,67676), -- Adamantite Earring Gemstone
(21813,4129,1,1,-1,13964), -- Recipe: Earrings of Black Ore
(21813,57,519,1060,0,700000), -- Adena
(21813,554,1,1,1,19), -- Zubei\'s Boots
(21813,600,1,1,1,19), -- Avadon Boots
(21813,612,1,1,1,19), -- Zubei\'s Gauntlets
(21813,2464,1,1,1,19), -- Avadon Gloves
(21813,4073,1,1,1,2479), -- Avadon Gloves Part
(21813,4097,1,1,1,2479), -- Zubei\'s Boots Design
(21813,4098,1,1,1,2479), -- Avadon Boots Design
(21813,4100,1,1,1,2479), -- Zubei\'s Gauntlets Part
(21813,1866,1,1,2,42347), -- Suede
(21813,1871,1,1,2,63521), -- Charcoal
(21813,1885,1,1,2,5294), -- High Grade Suede
(21813,4041,1,1,2,553), -- Mold Hardener
(21813,4129,1,1,2,688), -- Recipe: Earrings of Black Ore
(21813,5220,1,1,2,2541), -- Metal Hardener
(21814,1867,1,5,-1,638926), -- Animal Skin
(21814,1872,1,5,-1,638926), -- Animal Bone
(21814,4613,1,1,-1,1983), -- Greater Dye of Strength <Str+4 Con-4>
(21814,57,580,1179,0,700000), -- Adena
(21814,503,1,1,1,14), -- Zubei\'s Helmet
(21814,633,1,1,1,20), -- Zubei\'s Shield
(21814,673,1,1,1,20), -- Avadon Shield
(21814,2415,1,1,1,14), -- Avadon Circlet
(21814,4072,1,1,1,2385), -- Avadon Circlet Pattern
(21814,4101,1,1,1,3078), -- Zubei\'s Shield Fragment
(21814,4102,1,1,1,2385), -- Zubei\'s Helmet Design
(21814,4439,1,1,1,3662), -- Avadon Shield Fragment
(21814,1867,1,1,2,94365), -- Animal Skin
(21814,1872,1,1,2,94365), -- Animal Bone
(21814,1882,1,1,2,15728), -- Leather
(21814,1894,1,1,2,2484), -- Crafted Leather
(21814,4042,1,1,2,1180), -- Enria
(21814,4130,1,1,2,1150), -- Recipe: Ring of Black Ore
(21815,4052,1,1,-1,56535), -- Earring of Black Ore Piece
(21815,4053,1,1,-1,68445), -- Ring of Black Ore Gemstone
(21815,5230,1,1,-1,2129), -- Recipe: Mithril Arrow (100%)
(21815,57,646,1308,0,700000), -- Adena
(21815,601,1,1,1,15), -- Boots of Doom
(21815,2439,1,1,1,15), -- Blue Wolf Boots
(21815,2475,1,1,1,15), -- Doom Gloves
(21815,2487,1,1,1,15), -- Blue Wolf Gloves
(21815,4090,1,1,1,2647), -- Blue Wolf Boots Design
(21815,4091,1,1,1,2647), -- Doom Gloves Part
(21815,4096,1,1,1,2647), -- Blue Wolf Gloves Fabric
(21815,4099,1,1,1,2647), -- Doom Boots Part
(21815,1868,1,1,2,157227), -- Thread
(21815,1873,1,1,2,31446), -- Silver Nugget
(21815,1889,1,1,2,5241), -- Compound Braid
(21815,4044,1,1,2,2621), -- Thons
(21815,5230,1,1,2,105), -- Recipe: Mithril Arrow (100%)
(21815,5549,1,1,2,7862), -- Metallic Thread
(21816,4054,1,1,-1,34802), -- Necklace of Black Ore Beads
(21816,5438,1,1,-1,966), -- Recipe: Meteor Shower(60%)
(21816,5550,1,1,-1,23559), -- Durable Metal Plate
(21816,57,714,1448,0,700000), -- Adena
(21816,110,1,1,1,21), -- Doom Shield
(21816,2416,1,1,1,15), -- Blue Wolf Helmet
(21816,2417,1,1,1,15), -- Doom Helmet
(21816,4077,1,1,1,3913), -- Doom Shield Fragment
(21816,4088,1,1,1,3288), -- Blue Wolf Helmet Design
(21816,4089,1,1,1,3288), -- Doom Helmet Pattern
(21816,1864,1,1,2,173974), -- Stem
(21816,1869,1,1,2,86987), -- Iron Ore
(21816,1880,1,1,2,8699), -- Steel
(21816,4043,1,1,2,2900), -- Asofe
(21816,5434,1,1,2,33), -- Recipe: Dragon Slayer(60%)
(21816,5550,1,1,2,1160), -- Durable Metal Plate
(21817,1874,1,1,-1,129783), -- Oriharukon Ore
(21817,5434,1,1,-1,721), -- Recipe: Dragon Slayer(60%)
(21817,5478,1,1,-1,16370), -- Sealed Dark Crystal Leather Armor Pattern
(21817,57,786,1596,0,700000), -- Adena
(21817,5290,1,1,1,13), -- Sealed Dark Crystal Gloves
(21817,5291,1,1,1,13), -- Sealed Dark Crystal Boots
(21817,5295,1,1,1,13), -- Sealed Tallum Gloves
(21817,5296,1,1,1,13), -- Sealed Tallum Boots
(21817,5496,1,1,1,1686), -- Sealed Dark Crystal Boots Lining
(21817,5497,1,1,1,1686), -- Sealed Tallum Boots Lining
(21817,5508,1,1,1,1686), -- Sealed Dark Crystal Gloves Design
(21817,5509,1,1,1,1686), -- Sealed Tallum Gloves Design
(21817,1865,1,1,2,95840), -- Varnish
(21817,1870,1,1,2,95840), -- Coal
(21817,1874,1,1,2,6390), -- Oriharukon Ore
(21817,4039,1,1,2,3195), -- Mold Glue
(21817,4043,1,1,2,3195), -- Asofe
(21817,5440,1,1,2,36), -- Recipe: Elysian(60%)
(21818,5440,1,1,-1,792), -- Recipe: Elysian(60%)
(21818,5479,1,1,-1,12647), -- Sealed Tallum Leather Armor Pattern
(21818,5482,1,1,-1,28211), -- Sealed Dark Crystalline Leggings Design
(21818,57,860,1756,0,700000), -- Adena
(21818,5289,1,1,1,13), -- Sealed Dark Crystal Helmet
(21818,5292,1,1,1,18), -- Sealed Dark Crystal Shield
(21818,5294,1,1,1,13), -- Sealed Tallum Helmet
(21818,5494,1,1,1,2210), -- Sealed Dark Crystal Shield Fragment
(21818,5525,1,1,1,1627), -- Sealed Dark Crystal Helmet Design
(21818,5526,1,1,1,1627), -- Sealed Tallum Helm Design
(21818,1866,1,1,2,70152), -- Suede
(21818,1871,1,1,2,105227), -- Charcoal
(21818,1877,1,1,2,4210), -- Adamantite Nugget
(21818,4040,1,1,2,2105), -- Mold Lubricant
(21818,4041,1,1,2,916), -- Mold Hardener
(21818,6901,1,1,2,106), -- Recipe: Shining Arrow (100%)
(21819,1875,1,1,-1,155856), -- Stone of Purity
(21819,4041,1,1,-1,20329), -- Mold Hardener
(21819,5480,1,1,-1,10490), -- Sealed Leather Armor of Nightmare Fabric
(21819,57,941,1920,0,700000), -- Adena
(21819,5290,1,1,1,15), -- Sealed Dark Crystal Gloves
(21819,5291,1,1,1,15), -- Sealed Dark Crystal Boots
(21819,5295,1,1,1,15), -- Sealed Tallum Gloves
(21819,5296,1,1,1,15), -- Sealed Tallum Boots
(21819,5496,1,1,1,2024), -- Sealed Dark Crystal Boots Lining
(21819,5497,1,1,1,2024), -- Sealed Tallum Boots Lining
(21819,5508,1,1,1,2024), -- Sealed Dark Crystal Gloves Design
(21819,5509,1,1,1,2024), -- Sealed Tallum Gloves Design
(21819,1808,1,1,2,51), -- Recipe: Soulshot: S Grade
(21819,1867,1,1,2,153458), -- Animal Skin
(21819,1872,1,1,2,153458), -- Animal Bone
(21819,1875,1,1,2,7673), -- Stone of Purity
(21819,1881,1,1,2,15346), -- Coarse Bone Powder
(21819,4041,1,1,2,1001), -- Mold Hardener
(21820,1808,1,1,-1,1132), -- Recipe: Soulshot: S Grade
(21820,5481,1,1,-1,11429), -- Sealed Majestic Leather Armor Fabric
(21820,6901,1,1,-1,2547), -- Recipe: Shining Arrow (100%)
(21820,57,1025,2092,0,700000), -- Adena
(21820,5289,1,1,1,15), -- Sealed Dark Crystal Helmet
(21820,5292,1,1,1,21), -- Sealed Dark Crystal Shield
(21820,5294,1,1,1,15), -- Sealed Tallum Helmet
(21820,5494,1,1,1,2634), -- Sealed Dark Crystal Shield Fragment
(21820,5525,1,1,1,1939), -- Sealed Dark Crystal Helmet Design
(21820,5526,1,1,1,1939), -- Sealed Tallum Helm Design
(21820,1344,10,30,2,134343), -- Mithril Arrow
(21820,1868,1,1,2,214949), -- Thread
(21820,1873,1,1,2,42990), -- Silver Nugget
(21820,1876,1,1,2,21495), -- Mithril Ore
(21820,1895,1,1,2,30707), -- Metallic Fiber
(21820,3036,1,1,2,48), -- Recipe: Spiritshot S
(21820,4042,1,1,2,1792), -- Enria
(21821,4039,1,1,-1,92156), -- Mold Glue
(21821,4041,1,1,-1,24041), -- Mold Hardener
(21821,5487,1,1,-1,12450), -- Sealed Robe of Nightmare Fabric
(21821,57,1110,2273,0,700000), -- Adena
(21821,5313,1,1,1,12), -- Sealed Gloves of Nightmare
(21821,5314,1,1,1,12), -- Sealed Boots of Nightmare
(21821,5318,1,1,1,12), -- Sealed Majestic Gloves
(21821,5319,1,1,1,12), -- Sealed Majestic Boots
(21821,5502,1,1,1,1724), -- Sealed Boots of Nightmare Lining
(21821,5503,1,1,1,1724), -- Sealed Majestic Boots Lining
(21821,5514,1,1,1,1724), -- Sealed Gloves of Nightmare Design
(21821,5515,1,1,1,1724), -- Sealed Majestic Gloves Design
(21821,959,1,1,2,7), -- Scroll: Enchant Weapon (Grade S)
(21821,1894,1,1,2,5731), -- Crafted Leather
(21821,4039,1,1,2,5445), -- Mold Glue
(21821,4041,1,1,2,1421), -- Mold Hardener
(21821,4044,1,1,2,5445), -- Thons
(21822,6688,1,1,-1,6446), -- Forgotten Blade Edge
(21822,6689,1,1,-1,6325), -- Basalt Battlehammer Head
(21822,6690,1,1,-1,6459), -- Imperial Staff Head
(21822,57,1200,2449,0,700000), -- Adena
(21822,5312,1,1,1,12), -- Sealed Helm of Nightmare
(21822,5315,1,1,1,16), -- Sealed Shield of Nightmare
(21822,5317,1,1,1,12), -- Sealed Majestic Circlet
(21822,5495,1,1,1,2230), -- Sealed Shield of Nightmare Fragment
(21822,5527,1,1,1,1756), -- Sealed Helm of Nightmare Design
(21822,5528,1,1,1,1756), -- Sealed Majestic Circlet Design
(21822,960,1,1,2,71), -- Scroll: Enchant Armor (Grade S)
(21822,1895,1,1,2,50341), -- Metallic Fiber
(21822,4040,1,1,2,3524), -- Mold Lubricant
(21822,4042,1,1,2,2937), -- Enria
(21822,4043,1,1,2,5874), -- Asofe
(21823,1894,1,1,-1,888656), -- Crafted Leather
(21823,4039,1,1,-1,844224), -- Mold Glue
(21823,5480,1,1,-1,113647), -- Sealed Leather Armor of Nightmare Fabric
(21823,57,10189,20801,0,700000), -- Adena
(21823,289,1,1,1,28), -- Soul Bow
(21823,5534,1,1,1,10269), -- Soul Bow Stave
(21823,959,1,1,2,60), -- Scroll: Enchant Weapon (Grade S)
(21823,1894,1,1,2,52500), -- Crafted Leather
(21823,4039,1,1,2,49875), -- Mold Glue
(21823,4041,1,1,2,13011), -- Mold Hardener
(21823,4044,1,1,2,49875); -- Thons

-- 
-- work in progress C5 mob drops - 22xxx mobs
-- 
INSERT INTO `droplist` VALUES 
(22001,57,136,255,0,700000), -- Adena
(22001,1872,1,1,2,58824), -- Animal Bone
(22001,1867,1,1,2,58824), -- Animal Skin
(22001,1882,1,1,2,11364), -- Leather
(22001,2152,1,1,2,7937), -- Recipe: Enchanted Necklace (Grade D)
(22001,391,1,1,1,166), -- Puma Skin Shirt (Grade D)
(22001,413,1,1,1,483), -- Puma Skin Gaiters (Grade D)
(22001,1867,1,2,-1,250000), -- Animal Skin
(22001,1899,1,1,-1,25000), -- Necklace of Devotion Chain
(22001,2152,1,1,-1,6500), -- Recipe: Enchanted Necklace (Grade D)
(22002,57,141,270,0,700000), -- Adena
(22002,1872,1,1,2,58824), -- Animal Bone
(22002,1867,1,1,2,41667), -- Animal Skin
(22002,1881,1,1,2,10753), -- Coarse Bone Powder
(22002,1875,1,1,2,4651), -- Stone of Purity
(22002,258,1,1,1,8), -- Bagh-Nakh (Grade D)
(22002,1931,1,1,-1,25000), -- Leather Boot Lining
(22002,2178,1,1,-1,6000), -- Recipe: Dark Stockings
(22002,1932,1,1,-1,25000), -- Bone Helmet Design
(22003,57,173,334,0,700000), -- Adena
(22003,1884,1,1,2,25000), -- Cord
(22003,1878,1,1,2,10526), -- Braided Hemp
(22003,1889,1,1,2,3086), -- Compound Braid
(22003,1874,1,1,2,2320), -- Oriharukon ore
(22003,5220,1,1,2,1030), -- Metal Hardener
(22003,274,1,1,1,8), -- Strengthened Bow (Grade D)
(22003,2180,1,1,2,6000), -- Recipe: Scale Mail
(22003,1874,1,1,-1,150000), -- Oriharukon ore
(22003,1878,1,1,-1,250000), -- Braided Hemp
(22003,1934,1,1,-1,25000), -- Crafted Leather Gloves Lining
(22004,57,207,397,0,700000), -- Adena
(22004,1061,1,1,2,16129), -- Healing Potion
(22004,1879,1,1,2,8475), -- Cokes
(22004,2181,1,1,2,5348), -- Recipe: White Tunic (Grade D)
(22004,1875,1,1,2,4464), -- Stone of Purity
(22004,5549,1,1,2,2681), -- Metallic Thread
(22004,5550,1,1,2,2232), -- Durable Metal Plate
(22004,2017,1,1,2,1786), -- Saber Blade
(22004,1885,1,3,2,40000), -- High Grade Suede
(22004,8327,1,1,2,1786), -- Steel Sword Blade
(22004,5531,1,1,2,1786), -- Heavy Sword Edge
(22004,123,1,1,1,12), -- Saber Sword (Grade D)
(22004,2180,1,1,-1,6280), -- Recipe: Scale Mail (Grade D)
(22004,2017,1,1,-1,6786), -- Saber Blade
(22004,2181,1,1,-1,6348), -- Recipe: White Tunic (Grade D)
(22005,57,182,353,0,700000), -- Adena
(22005,1880,1,1,2,11364), -- Steel
(22005,1881,1,1,2,2268), -- Coarse Bone Powder
(22005,2182,1,1,2,2268), -- Recipe: Scale Gaiters (Grade D)
(22005,220,1,1,1,8), -- Crafted Dagger (Grade D)
(22005,1876,1,1,2,10000), -- Mithril Ore
(22005,1877,1,1,2,4115), -- Adamantite Nugget
(22005,1882,1,1,2,11364), -- Leather
(22005,2018,1,1,-1,5000), -- Assassin Knife Edge
(22005,1876,1,1,-1,150000), -- Mithril Ore
(22005,1880,1,1,-1,250000), -- Steel
(22006,57,187,371,0,700000), -- Adena
(22006,1878,1,1,2,23256), -- Braided Hemp
(22006,1884,1,1,2,20000), -- Cord
(22006,1889,1,1,2,6711), -- Compound Braid
(22006,292,1,1,1,12), -- Pike (Grade D)
(22006,1874,1,1,2,5000), -- Oriharukon ore
(22006,5220,1,1,2,1030), -- Metal Hardener
(22006,737,1,1,2,4132), -- Scroll of Resurrection
(22006,1061,1,1,-1,26129), -- Healing Potion
(22006,1900,1,1,-1,25000), -- Enchanted Necklace Chain
(22006,2153,1,1,-1,5000), -- Recipe: Tiger\'s Eye Earring
(22007,57,204,404,0,700000), -- Adena
(22007,1876,1,1,2,6211), -- Mithril Ore
(22007,1880,1,1,2,3906), -- Steel
(22007,1877,1,1,2,1949), -- Adamantite Nugget
(22007,1881,1,1,2,5000), -- Coarse Bone Powder
(22007,1882,1,1,2,9709), -- Leather
(22007,955,1,1,2,300), -- Scroll: Enchant Weapon (Grade D)
(22007,2022,1,1,2,550), -- Mace of Judgment Head
(22007,2023,1,1,2,350), -- Conjuror\'s Staff Head
(22007,1933,1,1,-1,5000), -- Dark Stocking Fabric
(22007,2183,1,1,-1,6280), -- Recipe: Mithril Banded Mail (Grade D)
(22007,1935,1,1,-1,5000), -- Scale Mail Fragment
(22008,57,200,390,0,700000), -- Adena
(22008,1876,1,1,2,7813), -- Mithril Ore
(22008,1880,1,1,2,3891), -- Steel
(22008,1877,1,1,2,1733), -- Adamantite Nugget
(22008,1881,1,1,2,4878), -- Coarse Bone Powder
(22008,1882,1,1,2,8333), -- Leather
(22008,956,1,1,2,1727), -- Scroll: Enchant Armor (Grade D)
(22008,1937,1,1,2,5714), -- Scale Gaiters Fragment
(22008,1935,1,1,2,2660), -- Scale Mail Fragment
(22008,377,1,1,1,162), -- Scale Gaiters (Grade D)
(22008,955,1,1,-1,5000), -- Scroll: Enchant Weapon (Grade D)
(22008,1877,1,1,-1,25000), -- Adamantite Nugget
(22008,1881,1,3,-1,58667), -- Coarse Bone Powder
(22009,57,226,451,0,700000), -- Adena
(22009,848,1,1,1,204), -- Enchanted Earring (Grade D)
(22009,879,1,1,1,321), -- Enchanted Ring (Grade D)
(22009,911,1,1,1,409), -- Enchanted Necklace (Grade D)
(22009,1900,1,1,2,7092), -- Enchanted Necklace Chain
(22009,1875,1,1,2,2188), -- Stone of Purity
(22009,1879,1,1,2,7246), -- Cokes
(22009,1885,1,1,2,3096), -- High Grade Suede
(22009,5550,1,1,2,963), -- Durable Metal Plate
(22009,5549,1,1,2,4464), -- Metallic Thread
(22009,1829,1,1,2,19608), -- Scroll of Escape: Clan Hall
(22009,1832,1,1,2,47619), -- Greater Antidote
(22009,1832,1,3,-1,25641), -- Greater Antidote
(22009,1936,1,1,-1,6882), -- White Tunic Pattern
(22009,2184,1,1,-1,58192), -- Recipe: Mithril Banded Gaiters
(22010,57,239,479,0,700000), -- Adena
(22010,1868,1,1,2,125000), -- Thread
(22010,1873,1,1,2,24390), -- Silver Nugget
(22010,1829,1,1,2,22222), -- Scroll of Escape: Clan Hall
(22010,5549,1,1,2,5128), -- Metallic Thread
(22010,1889,1,1,2,3597), -- Compound Braid
(22010,46,1,1,1,981), -- Bronze Helmet (Grade D)
(22010,627,1,1,1,588), -- Aspis (Grade D)
(22010,1937,1,1,-1,5714), -- Scale Gaiters Fragment
(22010,2185,1,1,-1,8192), -- Recipe: Iron Boots
(22010,2021,1,1,-1,6882), -- Spinebone Sword Blade
(22011,57,276,547,0,700000), -- Adena
(22011,1871,1,1,2,111111), -- Charcoal
(22011,1866,1,1,2,55555), -- Suede
(22011,2154,1,1,2,12500), -- Recipe: Elven Earring
(22011,1877,1,1,2,3125), -- Adamantite Nugget
(22011,1871,1,3,-1,250000), -- Charcoal
(22011,1866,1,3,-1,76923), -- Suede
(22012,57,278,539,0,700000), -- Adena
(22012,1871,1,1,2,125000), -- Charcoal
(22012,1866,1,1,2,47619), -- Suede
(22012,1877,1,1,2,5181), -- Adamantite Nugget
(22012,2155,1,1,2,5181), -- Recipe: Elven Ring
(22012,2154,1,1,-1,25000), -- Recipe: Elven Earring
(22012,2155,1,1,-1,25000), -- Recipe: Elven Ring
(22013,57,274,546,0,700000), -- Adena
(22013,1865,1,1,2,62500), -- Varnish
(22013,1870,1,1,2,37037), -- Coal
(22013,1879,1,1,2,9434), -- Cokes
(22013,2156,1,1,2,9434), -- Recipe: Elven Necklace
(22013,1939,1,1,-1,5000), -- Mithril Banded Gaiters Material
(22013,1865,1,1,-1,25000), -- Varnish
(22013,1870,1,1,-1,25000), -- Coal
(22014,57,275,548,0,700000), -- Adena
(22014,1341,10,29,2,200000), -- Bone Arrow
(22014,1870,1,1,2,52632), -- Coal
(22014,1865,1,1,2,22222), -- Varnish
(22014,1879,1,1,2,7353), -- Cokes
(22015,57,277,546,0,700000), -- Adena
(22015,1884,1,1,2,34483), -- Cord
(22015,5220,1,1,2,13699), -- Metal Hardener
(22015,1878,1,1,2,6849), -- Braided Hemp
(22015,1884,1,1,-1,250000), -- Cord
(22016,57,275,544,0,700000), -- Adena
(22016,1884,1,1,2,37037), -- Cord
(22016,1878,1,1,2,25000), -- Braided Hemp
(22016,1889,1,1,2,12500), -- Compound Braid
(22016,1889,1,1,-1,250000), -- Compound Braid
(22016,2187,1,1,-1,5862), -- Recipe: Manticore Skin Shirt
(22017,57,208,416,0,700000), -- Adena
(22017,1864,1,1,2,90909), -- Stem
(22017,1869,1,1,2,47619), -- Iron Ore
(22017,1880,1,1,2,5208), -- Steel
(22017,737,1,1,2,4132), -- Scroll of Resurrection
(22017,2021,1,1,1,654), -- Spinebone Sword Blade
(22017,5550,1,1,2,528), -- Durable Metal Plate
(22017,125,1,1,1,8), -- Spinebone Sword
(22017,128,1,1,1,8), -- Knight\'s Sword
(22017,69,1,1,1,8), -- Bastard Sword
(22017,126,1,1,1,8), -- Artisan\'s Sword
(22017,1900,1,1,-1,25000), -- Enchanted Necklace Chain
(22017,2153,1,1,-1,5000), -- Recipe: Tiger\'s Eye Earring
(22017,1933,1,1,-1,25000), -- Dark Stocking Fabric
(22018,57,178,355,0,700000), -- Adena
(22018,1872,1,1,2,71429), -- Animal Bone
(22018,1867,1,1,2,71429), -- Animal Skin
(22018,1882,1,1,2,12048), -- Leather
(22018,392,1,1,1,88), -- Lion Skin Shirt
(22018,414,1,1,1,88), -- Lion Skin Gaiters
(22018,955,1,1,2,210), -- Scroll: Enchant Weapon (Grade D)
(22018,956,1,1,-1,5000), -- Scroll: Enchant Armor (Grade D)
(22018,1872,1,2,-1,250000), -- Animal Bone
(22018,1882,1,2,-1,50000), -- Leather
(22019,57,241,484,0,700000), -- Adena
(22019,1864,1,1,2,100000), -- Stem
(22019,1869,1,1,2,52632), -- Iron Ore
(22019,1061,1,1,2,28571), -- Healing Potion
(22019,1933,1,1,1,4926), -- Dark Stocking Fabric
(22019,1880,1,1,2,4673), -- Steel
(22019,1936,1,1,1,2681), -- White Tunic Pattern
(22019,956,1,1,2,1727), -- Scroll: Enchant Armor (Grade D)
(22019,5550,1,1,2,317), -- Durable Metal Plate
(22019,466,1,1,1,88), -- Elven Stockings
(22019,433,1,1,1,88), -- Elven Tunic
(22019,435,1,1,1,88), -- Mystic\'s Tunic
(22019,467,1,1,1,88), -- Dark Stockings
(22019,434,1,1,1,88), -- White Tunic
(22019,468,1,1,1,88), -- Mystic\'s Stockings
(22019,1834,1,2,-1,50000), -- Emergency Dressing
(22019,1935,1,1,-1,25000), -- Scale Mail Fragment
(22019,2183,1,1,-1,5000), -- Recipe: Mithril Banded Mail
(22020,57,200,399,0,700000), -- Adena
(22020,1872,1,1,2,66066), -- Animal Bone
(22020,1867,1,1,2,66066), -- Animal Skin
(22020,1881,1,1,2,6289), -- Coarse Bone Powder
(22020,1875,1,1,2,3012), -- Stone of Purity
(22020,8302,1,1,2,893), -- Recipe: Sword of Magic Fog (100%)
(22020,378,1,1,1,88), -- Compound Scale Gaiters
(22020,59,1,1,1,88), -- Mithril Gaiters
(22020,351,1,1,1,88), -- Blast Plate
(22020,58,1,1,1,88), -- Mithril Breastplate
(22020,349,1,1,1,88), -- Compound Scale Mail
(22020,379,1,1,1,88), -- Dwarven Scale Gaiters
(22020,350,1,1,1,88), -- Dwarven Scale Mail
(22020,1901,1,1,-1,25000), -- Tiger\'s Eye Earring Stone
(22020,2154,1,1,-1,5000), -- Recipe: Elven Earring
(22020,1938,1,1,-1,25000), -- Mithril Banded Mail Material
(22021,57,242,484,0,700000), -- Adena
(22021,1341,10,30,2,142857), -- Bone Arrow
(22021,1884,1,1,2,27027), -- Cord
(22021,1878,1,1,2,13514), -- Braided Hemp
(22021,1874,1,1,2,2618), -- Oriharukon Ore
(22021,1889,1,1,2,2513), -- Compound Braid
(22021,2027,1,1,1,1912), -- Spiked Club Head
(22021,5220,1,1,2,1057), -- Metal Hardener
(22021,8295,1,1,2,805), -- Recipe: Titan Sword (100%)
(22021,157,1,1,1,8), -- Spiked Club
(22021,186,1,1,1,8), -- Staff of Magic
(22021,5220,1,1,-1,50000), -- Metal Hardener
(22021,1874,1,1,-1,50000