-- ---------------------------
-- Table structure for etcitem
-- ---------------------------
DROP TABLE IF EXISTS `etcitem`;
CREATE TABLE IF NOT EXISTS `etcitem` (
  `item_id` decimal(11,0) NOT NULL default '0',
  `name` varchar(100) default NULL,
  `crystallizable` varchar(5) default NULL,
  `item_type` varchar(14) default NULL,
  `weight` decimal(4,0) default NULL,
  `consume_type` varchar(9) default NULL,
  `material` varchar(11) default NULL,
  `crystal_type` varchar(4) NOT NULL default 'none',
  `duration` decimal(3,0) default NULL,
  `price` decimal(11,0) default NULL,
  `crystal_count` int(4) default NULL,
  `sellable` varchar(5) default NULL,
  `dropable` varchar(5) default NULL,
  `destroyable` varchar(5) default NULL,
  `tradeable` varchar(5) default NULL,
  `oldname` varchar(100) NOT NULL default '',
  `oldtype` varchar(100) NOT NULL default '',
  PRIMARY KEY (`item_id`)
) DEFAULT CHARSET=utf8;
-- -------------------------
-- Records for table etcitem
-- -------------------------

INSERT INTO `etcitem` VALUES 
(17,'Wooden Arrow','false','arrow',6,'stackable','wood','none',-1,2,0,'true','true','true','true','wooden_arrow','arrow'),
(57,'Adena','false','none',0,'asset','gold','none',-1,1,0,'false','true','true','true','adena','none'),
(65,'Red Potion','false','potion',80,'stackable','liquid','none',-1,40,0,'true','true','true','true','red_potion','potion'),
(686,'Chair','false','none',100,'normal','wood','none',-1,1000,0,'true','true','true','true','chair_item','none'),
(687,'Darin\'s Letter','false','quest',0,'normal','paper','none',-1,0,0,'false','false','true','false','darings_letter','none'),
(688,'Roxxy\'s Kerchief','false','quest',0,'normal','cloth','none',-1,0,0,'false','false','true','false','rapunzels_kerchief','none'),
(689,'Poetry Book','false','quest',0,'normal','paper','none',-1,0,0,'false','false','true','false','poetry_book','none'),
(690,'Lyrics Book','false','quest',0,'normal','paper','none',-1,0,0,'false','false','true','false','lyrics_book','none'),
(691,'Romance Novel','false','quest',0,'normal','paper','none',-1,0,0,'false','false','true','false','romance_novel','none'),
(692,'Arujien\'s Letter','false','quest',0,'normal','paper','none',-1,0,0,'false','false','true','false','arujiens_letter','none'),
(693,'Greenis\'s Letter','false','quest',0,'normal','paper','none',-1,0,0,'false','false','true','false','greenis_letter','none'),
(694,'Ingredient List','false','quest',0,'normal','paper','none',-1,0,0,'false','false','true','false','talos_list','none'),
(695,'Omen Beast\'s Blood','false','quest',0,'stackable','steel','none',-1,0,0,'false','false','true','false','onyx_beast_blood','none'),
(696,'Mana Seeker\'s Husk','false','quest',0,'stackable','steel','none',-1,0,0,'false','false','true','false','mana_vampire_husk','none'),
(697,'Gargoyle\'s Horn','false','quest',0,'stackable','steel','none',-1,0,0,'false','false','true','false','gargoyle_horn','none'),
(698,'Gilbert\'s List','false','quest',0,'normal','steel','none',-1,0,0,'false','false','true','false','gilberts_list','none'),
(699,'Orc\'s Nose','false','quest',0,'stackable','steel','none',-1,0,0,'false','false','true','false','orc_nose','none'),
(700,'Hobgoblin Amulet','false','quest',0,'stackable','steel','none',-1,0,0,'false','false','true','false','_hobgoblin_amulet','none'),
(701,'Fungus Juice','false','quest',0,'stackable','steel','none',-1,0,0,'false','false','true','false','fungus_juice','none'),
(702,'Wolf Pelt','false','quest',0,'stackable','steel','none',-1,0,0,'false','false','true','false','wolf_pelt','none'),
(703,'Poison Sac','false','quest',0,'stackable','steel','none',-1,0,0,'false','false','true','false','poison_sac','none'),
(704,'Fever Medicine','false','quest',0,'stackable','steel','none',-1,0,0,'false','false','true','false','fever_medicine','none'),
(705,'Orc\'s Amulet','false','quest',0,'stackable','steel','none',-1,0,0,'false','false','true','false','_orc_amulet','none'),
(706,'Basilisk\'s Claw','false','quest',0,'stackable','steel','none',-1,0,0,'false','false','true','false','basilisk_claw','none'),
(707,'Spore Sac','false','quest',0,'stackable','steel','none',-1,0,0,'false','false','true','false','fungus_sac','none'),
(708,'Sylph Headband','false','quest',0,'stackable','steel','none',-1,0,0,'false','false','true','false','sylph_headband','none'),
(709,'Leather Shirt','false','none',400,'normal','leather','none',-1,0,0,'false','false','true','false','sek_temp_upper001','none'),
(710,'Hard Leather Shirt','false','none',400,'normal','leather','none',-1,0,0,'false','false','true','false','sek_temp_upper002','none'),
(711,'Piece Bone Breastplate','false','none',800,'normal','bone','none',-1,0,0,'false','false','true','false','sek_temp_upper003','none'),
(712,'Half Plate Armor','false','none',1200,'normal','steel','none',-1,0,0,'false','false','true','false','sek_temp_upper004','none'),
(713,'Leather Pants','false','none',250,'normal','leather','none',-1,0,0,'false','false','true','false','sek_temp_lower001','none'),
(714,'Hard Leather Pants','false','none',300,'normal','leather','none',-1,0,0,'false','false','true','false','sek_temp_lower002','none'),
(715,'Piece Bone Gaiters','false','none',500,'normal','bone','none',-1,0,0,'false','false','true','false','sek_temp_lower003','none'),
(716,'Plate Gaiters','false','none',800,'normal','steel','none',-1,0,0,'false','false','true','false','sek_temp_lower004','none'),
(717,'Leather Gloves','false','none',100,'normal','leather','none',-1,0,0,'false','false','true','false','sek_temp_glove001','none'),
(718,'Hard Leather Gloves','false','none',150,'normal','leather','none',-1,0,0,'false','false','true','false','sek_temp_glove002','none'),
(719,'Crafted Leather Gloves','false','none',150,'normal','leather','none',-1,0,0,'false','false','true','false','sek_temp_glove003','none'),
(720,'Reinforced Gloves','false','none',200,'normal','steel','none',-1,0,0,'false','false','true','false','sek_temp_glove004','none'),
(721,'Leather Boots','false','none',150,'normal','leather','none',-1,0,0,'false','false','true','false','sek_temp_boots001','none'),
(722,'Hard Leather Boots','false','none',150,'normal','leather','none',-1,0,0,'false','false','true','false','sek_temp_boots002','none'),
(723,'Crafted Leather Boots','false','none',200,'normal','leather','none',-1,0,0,'false','false','true','false','sek_temp_boots003','none'),
(724,'Reinforced Boots','false','none',250,'normal','steel','none',-1,0,0,'false','false','true','false','sek_temp_boots004','none'),
(725,'Healing Drug','false','potion',180,'stackable','liquid','none',-1,50,0,'true','true','true','true','healing_drug','potion'),
(726,'Mana Drug','false','potion',180,'stackable','liquid','none',-1,80,0,'true','true','true','true','mana_drug','potion'),
(727,'Healing Potion','false','potion',180,'stackable','liquid','none',-1,80,0,'true','true','true','true','_healing_potion','potion'),
(728,'Mana Potion','false','potion',180,'stackable','liquid','none',-1,2000,0,'true','true','true','true','mana_potion','potion'),
(729,'Scroll: Enchant Weapon (A)','false','scroll',120,'stackable','paper','none',-1,1800000,0,'true','true','true','true','scrl_of_ench_wp_a','scroll'),
(730,'Scroll: Enchant Armor (A)','false','scroll',120,'stackable','paper','none',-1,240000,0,'true','true','true','true','scrl_of_ench_am_a','scroll'),
(731,'Crystal Scroll: Enchant Weapon (A)','false','scroll',120,'stackable','paper','none',-1,240000,0,'true','true','true','true','cry_scrl_of_ench_wp_a','scroll'),
(732,'Crystal Scroll: Enchant Armor (A)','false','scroll',120,'stackable','paper','none',-1,240000,0,'true','true','true','true','cry_scrl_of_ench_am_a','scroll'),
(733,'Endeavor Potion','false','potion',180,'stackable','liquid','none',-1,500,0,'true','true','true','true','endeavor_potion','potion'),
(734,'Haste Potion','false','potion',20,'stackable','liquid','none',-1,1200,0,'true','true','true','true','quick_step_potion','potion'),
(735,'Potion of Alacrity','false','potion',20,'stackable','liquid','none',-1,2400,0,'true','true','true','true','swift_attack_potion','potion'),
(736,'Scroll of Escape','false','scroll',120,'stackable','paper','none',-1,400,0,'true','true','true','true','scroll_of_escape','scroll'),
(737,'Scroll of Resurrection','false','scroll',120,'stackable','paper','none',-1,2000,0,'true','true','true','true','scroll_of_resurrection','scroll'),
(739,'Broken Sword Handle','false','quest',0,'stackable','steel','none',-1,0,0,'false','false','true','false','broken_sword_handle','none'),
(740,'Broken Blade Bottom','false','quest',0,'stackable','steel','none',-1,0,0,'false','false','true','false','broken_blade_bottom','none'),
(741,'Broken Blade Top','false','quest',0,'stackable','steel','none',-1,0,0,'false','false','true','false','broken_blade_top','none'),
(742,'Altran\'s Note','false','quest',0,'stackable','steel','none',-1,0,0,'false','false','true','false','alltrans_note','none'),
(745,'Cobendell Medicine','false','quest',0,'stackable','steel','none',-1,0,0,'false','false','true','false','cobendell_medicine','none'),
(746,'Alberius\'s List','false','quest',0,'stackable','steel','none',-1,0,0,'false','false','true','false','alberryus_list','none'),
(750,'Kinship Crystal','false','quest',0,'stackable','steel','none',-1,0,0,'false','false','true','false','kinship_crystal','none'),
(751,'Cracked Kinship Crystal','false','quest',0,'stackable','steel','none',-1,0,0,'false','false','true','false','cracked_kinship_crystal','none'),
(752,'Orc Amulet','false','quest',0,'stackable','steel','none',-1,0,0,'false','false','true','false','orc_amulet','none'),
(753,'Silverleaf Brooch','false','quest',0,'stackable','steel','none',-1,0,0,'false','false','true','false','silverleaf_brooch','none'),
(755,'Colleen\'s Letter','false','quest',0,'stackable','steel','none',-1,0,0,'false','false','true','false','_cullinas_letter','none'),
(756,'Mandragora Root','false','quest',0,'stackable','steel','none',-1,0,0,'false','false','true','false','_mandragora_root','none'),
(757,'Mandragora Essence','false','quest',0,'stackable','steel','none',-1,0,0,'false','false','true','false','_mandragora_essence','none'),
(758,'Colleen\'s Receipt','false','quest',0,'stackable','steel','none',-1,0,0,'false','false','true','false','_cullinas_receipt','none'),
(759,'Etched Rune Sword','false','quest',0,'stackable','steel','none',-1,0,0,'false','false','true','false','_etched_rune_sword','none'),
(760,'Macabre Sword','false','quest',0,'stackable','steel','none',-1,0,0,'false','false','true','false','_macabre_sword','none'),
(761,'Thanatos Sword','false','quest',0,'stackable','steel','none',-1,0,0,'false','false','true','false','_thanatos_sword','none'),
(762,'Gray Bone Chip','false','quest',0,'stackable','steel','none',-1,0,0,'false','false','true','false','_grey_bone_chip','none'),
(763,'Esther\'s Letter','false','quest',0,'stackable','steel','none',-1,0,0,'false','false','true','false','_esthers_letter','none'),
(764,'Arbon\'s Letter','false','quest',0,'stackable','steel','none',-1,0,0,'false','false','true','false','__arbons_letter','none'),
(765,'Conspirator List','false','quest',0,'stackable','steel','none',-1,0,0,'false','false','true','false','_conspirator_list','none'),
(766,'Sabrin\'s Signet','false','quest',0,'stackable','steel','none',-1,0,0,'false','false','true','false','_sabrins_signet','none'),
(767,'Sealed Scroll','false','quest',0,'stackable','steel','none',-1,0,0,'false','false','true','false','_sealed_scroll','none'),
(768,'Oyen\'s Key','false','quest',0,'stackable','steel','none',-1,0,0,'false','false','true','false','_oyens_key_','none'),
(769,'Ricardo\'s Skull','false','quest',0,'stackable','steel','none',-1,0,0,'false','false','true','false','_rekards_skull','none'),
(770,'Shield of Honor','false','quest',0,'stackable','steel','none',-1,0,0,'false','false','true','false','__shield_of_honor','none'),
(771,'Saythus\'s Skull','false','quest',0,'stackable','steel','none',-1,0,0,'false','false','true','false','_saythus_skull','none'),
(772,'Trayer\'s Skull','false','quest',0,'stackable','steel','none',-1,0,0,'false','false','true','false','_trayer_skull','none'),
(773,'Falimar\'s Skull','false','quest',0,'stackable','steel','none',-1,0,0,'false','false','true','false','_falimar_skull','none'),
(774,'Fallen Sword of Honor','false','quest',0,'stackable','steel','none',-1,0,0,'false','false','true','false','_fallen_sword_of_honor','none'),
(775,'Sword of Honor','false','quest',0,'stackable','steel','none',-1,0,0,'false','false','true','false','_sword_of_honor','none'),
(776,'Nameless Sword','false','quest',0,'stackable','steel','none',-1,0,0,'false','false','true','false','_nameless_sword','none'),
(777,'Sword of Black Ice','false','quest',0,'stackable','steel','none',-1,0,0,'false','false','true','false','_sword_of_black_ice','none'),
(778,'Arodin\'s Letter','false','quest',0,'stackable','steel','none',-1,0,0,'false','false','true','false','_arodins_letter','none'),
(779,'Sabrin\'s Ring','false','quest',0,'stackable','steel','none',-1,0,0,'false','false','true','false','_sabrins_ring','none'),
(780,'Arbon\'s Letter','false','quest',0,'stackable','steel','none',-1,0,0,'false','false','true','false','__arbons_letter','none'),
(781,'Madclaw\'s Necklace','false','quest',0,'stackable','steel','none',-1,0,0,'false','false','true','false','_madclaws_necklace','none'),
(782,'Alex\'s Letter','false','quest',0,'stackable','steel','none',-1,0,0,'false','false','true','false','_alankells_letter','none'),
(783,'Alex\'s Receipt','false','quest',0,'stackable','steel','none',-1,0,0,'false','false','true','false','_alankells_receipt','none'),
(784,'Glass Dagger','false','quest',0,'stackable','steel','none',-1,0,0,'false','false','true','false','_glass_dagger','none'),
(785,'Broken Glass Dagger','false','quest',0,'stackable','steel','none',-1,0,0,'false','false','true','false','_broken_glass_dagger','none'),
(786,'Shadowguard Dagger','false','quest',0,'stackable','steel','none',-1,0,0,'false','false','true','false','_shadowguard_dagger','none'),
(787,'Coroli\'s Key','false','quest',0,'stackable','steel','none',-1,0,0,'false','false','true','false','_corollas_key','none'),
(788,'Midnight Onyx Necklace','false','quest',0,'stackable','steel','none',-1,0,0,'false','false','true','false','_midnight_onyx_necklace','none'),
(789,'Song: Moonlight Whisper','false','quest',0,'stackable','steel','none',-1,0,0,'false','false','true','false','_song_moonlight_whisper','none'),
(790,'Bloodsteel Kris','false','quest',0,'stackable','steel','none',-1,0,0,'false','false','true','false','_bloodsteel_kris','none'),
(791,'Karlun\'s Skull','false','quest',0,'stackable','steel','none',-1,0,0,'false','false','true','false','_karluns_skull','none'),
(792,'Karlun\'s Rib Bone','false','quest',0,'stackable','steel','none',-1,0,0,'false','false','true','false','_karluns_ribbone','none'),
(793,'Karlun\'s Thigh Bone','false','quest',0,'stackable','steel','none',-1,0,0,'false','false','true','false','_karluns_thighbone','none'),
(794,'Saint\'s Ash Urn','false','quest',0,'stackable','steel','none',-1,0,0,'false','false','true','false','_saints_ash_urn','none'),
(795,'Mace of Athebaldt','false','quest',0,'stackable','steel','none',-1,0,0,'false','false','true','false','_mace_of_athebaldt','none'),
(796,'Roien\'s Letter','false','quest',0,'stackable','steel','none',-1,0,0,'false','false','true','false','roiens_letter','none'),
(797,'Manuel\'s Letter','false','quest',0,'stackable','steel','none',-1,0,0,'false','false','true','false','_manuels_letter','none'),
(798,'Varan\'s Letter','false','quest',0,'stackable','steel','none',-1,0,0,'false','false','true','false','_varanket_letter','none'),
(799,'Groot\'s Letter','false','quest',0,'stackable','steel','none',-1,0,0,'false','false','true','false','_groot_letter','none'),
(800,'Tome of Nassen','false','quest',0,'stackable','steel','none',-1,0,0,'false','false','true','false','_tome_of_nassen','none'),
(801,'Cursed Tome of Nassen','false','quest',0,'stackable','steel','none',-1,0,0,'false','false','true','false','_cursed_tome_of_nassen','none'),
(802,'Bloodthirsty Dagger','false','quest',0,'stackable','steel','none',-1,0,0,'false','false','true','false','_bloodthirsty_dagger','none'),
(803,'Bloody Dagger','false','quest',0,'stackable','steel','none',-1,0,0,'false','false','true','false','_bloody_dagger','none'),
(804,'Staff of Shane','false','quest',0,'stackable','steel','none',-1,0,0,'false','false','true','false','_staff_of_shaneryss','none'),
(805,'Pinter\'s Bill','false','quest',0,'stackable','steel','none',-1,0,0,'false','false','true','false','__pinters_bill','none'),
(806,'Drake\'s Claw','false','quest',0,'stackable','steel','none',-1,0,0,'false','false','true','false','_drake_claw','none'),
(807,'Flawless Drake\'s Claw','false','quest',0,'stackable','steel','none',-1,0,0,'false','false','true','false','_flawless_drake_claw','none'),
(808,'Pushkin\'s Letter','false','quest',0,'stackable','steel','none',-1,0,0,'false','false','true','false','_pushkins_letter','none'),
(809,'Bone Fragment','false','quest',0,'stackable','steel','none',-1,0,0,'false','false','true','false','bone_fragment','none'),
(810,'Altran\'s Letter','false','quest',0,'stackable','steel','none',-1,0,0,'false','false','true','false','_alltrans_letter','none'),
(811,'Oil Paper','false','quest',0,'stackable','steel','none',-1,0,0,'false','false','true','false','_oil_paper','none'),
(812,'Adamantium Ore','false','quest',0,'stackable','steel','none',-1,0,0,'false','false','true','false','__adamantium_ore','none'),
(813,'Heart Stone','false','quest',0,'stackable','steel','none',-1,0,0,'false','false','true','false','_heart_stone','none'),
(814,'Pushkin\'s Receipt','false','quest',0,'stackable','steel','none',-1,0,0,'false','false','true','false','_pushkins_receipt','none'),
(815,'Leather Strap','false','quest',0,'stackable','steel','none',-1,0,0,'false','false','true','false','_leather_strap','none'),
(816,'Widow Maker','false','quest',0,'stackable','steel','none',-1,0,0,'false','false','true','false','__wm','none'),
(817,'Mithril Bottle','false','quest',0,'stackable','steel','none',-1,0,0,'false','false','true','false','_mithril_bottle','none'),
(818,'Grace Unicorn\'s Horn','false','quest',0,'stackable','steel','none',-1,0,0,'false','false','true','false','_grace_unicorn_horn','none'),
(819,'Drake\'s Bone','false','quest',0,'stackable','steel','none',-1,0,0,'false','false','true','false','_drake_bone','none'),
(820,'Zahak Fluids','false','quest',0,'stackable','steel','none',-1,0,0,'false','false','true','false','_zahak_fluids','none'),
(821,'Bone Knife','false','quest',0,'stackable','steel','none',-1,0,0,'false','false','true','false','_bone_knife','none'),
(822,'Drake Knife','false','quest',0,'stackable','steel','none',-1,0,0,'false','false','true','false','_drake_knife','none'),
(823,'Dull Dagger','false','quest',0,'stackable','steel','none',-1,0,0,'false','false','true','false','_dull_dagger','none'),
(824,'Siriel\'s Note','false','quest',0,'stackable','steel','none',-1,0,0,'false','false','true','false','_siriels_note','none'),
(825,'Raien\'s Letter','false','quest',0,'stackable','steel','none',-1,0,0,'false','false','true','false','_raiens_letter','none'),
(826,'Silver Spores','false','quest',0,'stackable','steel','none',-1,0,0,'false','false','true','false','_silver_spores','none'),
(827,'Star Dust','false','quest',0,'stackable','steel','none',-1,0,0,'false','false','true','false','_star_dust','none'),
(828,'Song of Awakening','false','quest',0,'stackable','steel','none',-1,0,0,'false','false','true','false','_song_of_awakening','none'),
(829,'Spirit Dagger','false','quest',0,'stackable','steel','none',-1,0,0,'false','false','true','false','_spirit_dagger','none'),
(830,'Medallion of Kwyllinas','false','quest',0,'stackable','steel','none',-1,0,0,'false','false','true','false','_medallion_of_kwyllinas','none'),
(831,'Echo Crystal','false','quest',0,'stackable','steel','none',-1,0,0,'false','false','true','false','_echo_crystal','none'),
(832,'Green Echo Crystal','false','quest',0,'stackable','steel','none',-1,0,0,'false','false','true','false','_green_echo_crystal','none'),
(833,'Red Echo Crystal','false','quest',0,'stackable','steel','none',-1,0,0,'false','false','true','false','_red_echo_crystal','none'),
(834,'Aquamarine Echo Crystal','false','quest',0,'stackable','steel','none',-1,0,0,'false','false','true','false','_aquamarine_echo_crystal','none'),
(835,'Blue Echo Crystal','false','quest',0,'stackable','steel','none',-1,0,0,'false','false','true','false','_blue_echo_crystal','none'),
(836,'Book of Kwyllinas','false','quest',0,'stackable','steel','none',-1,0,0,'false','false','true','false','_book_of_kwyllinas','none'),
(837,'Fairy Dust','false','quest',0,'stackable','steel','none',-1,0,0,'false','false','true','false','_fairy_dust','none'),
(838,'Vellior\'s Letter','false','quest',0,'stackable','steel','none',-1,0,0,'false','false','true','false','_velliors_letter','none'),
(839,'Icarus\'s Letter','false','quest',0,'stackable','steel','none',-1,0,0,'false','false','true','false','_icarus_letter','none'),
(840,'Drevanul Skull','false','quest',0,'stackable','steel','none',-1,0,0,'false','false','true','false','_drevanul_skull','none'),
(841,'Icarus\'s Order Form','false','quest',0,'stackable','steel','none',-1,0,0,'false','false','true','false','_icarus_orderform','none'),
(842,'Basilisk Ink','false','quest',0,'stackable','steel','none',-1,0,0,'false','false','true','false','_basilisk_ink','none'),
(843,'Book of Aklantoth','false','quest',0,'stackable','steel','none',-1,0,0,'false','false','true','false','_book_of_aklantoth','none'),
(844,'Book of Aklantoth P1 ~ P10','false','quest',0,'stackable','steel','none',-1,0,0,'false','false','true','false','book_of_aklantoth_p1_~_p10','none'),
(937,'Directions to Ruins','false','quest',0,'stackable','steel','none',-1,0,0,'false','false','true','false','howtogo_ruins','none'),
(938,'Deck','false','none',0,'normal','silver','none',-1,0,0,'false','true','true','false','test_deck','none'),
(939,'Gara\'s Quest Item #11','false','quest',0,'stackable','steel','none',-1,0,0,'false','false','true','false','gara_quest_item11','none'),
(940,'Gara\'s Quest Item #12','false','quest',0,'stackable','steel','none',-1,0,0,'false','false','true','false','gara_quest_item12','none'),
(941,'Gara\'s Proof of Bravery','false','quest',0,'stackable','steel','none',-1,0,0,'false','false','true','false','gara_proof_of_bravery','none'),
(942,'Gara\'s Proof of Justice','false','quest',0,'stackable','steel','none',-1,0,0,'false','false','true','false','gara_proof_of_justice','none'),
(943,'Gara\'s Proof of Despair','false','quest',0,'stackable','steel','none',-1,0,0,'false','false','true','false','gara_proof_of_despair','none'),
(944,'Deathknight Skull','false','quest',0,'stackable','steel','none',-1,0,0,'false','false','true','false','deathknight_skull','none'),
(947,'Scroll: Enchant Weapon (B)','false','scroll',120,'stackable','paper','none',-1,500000,0,'true','true','true','true','scrl_of_ench_wp_b','scroll'),
(948,'Scroll: Enchant Armor (B)','false','scroll',120,'stackable','paper','none',-1,80000,0,'true','true','true','true','scrl_of_ench_am_b','scroll'),
(949,'Crystal Scroll: Enchant Weapon (B)','false','scroll',120,'stackable','paper','none',-1,80000,0,'true','true','true','true','cry_scrl_of_ench_wp_b','scroll'),
(950,'Crystal Scroll: Enchant Armor (B)','false','scroll',120,'stackable','paper','none',-1,80000,0,'true','true','true','true','cry_scrl_of_ench_am_b','scroll'),
(951,'Scroll: Enchant Weapon (C)','false','scroll',120,'stackable','paper','none',-1,110000,0,'true','true','true','true','scrl_of_ench_wp_c','scroll'),
(952,'Scroll: Enchant Armor (C)','false','scroll',120,'stackable','paper','none',-1,15000,0,'true','true','true','true','scrl_of_ench_am_c','scroll'),
(953,'Crystal Scroll: Enchant Weapon (C)','false','scroll',120,'stackable','paper','none',-1,15000,0,'true','true','true','true','cry_scrl_of_ench_wp_c','scroll'),
(954,'Crystal Scroll: Enchant Armor (C)','false','scroll',120,'stackable','paper','none',-1,15000,0,'true','true','true','true','cry_scrl_of_ench_am_c','scroll'),
(955,'Scroll: Enchant Weapon (D)','false','scroll',120,'stackable','paper','none',-1,50000,0,'true','true','true','true','scrl_of_ench_wp_d','scroll'),
(956,'Scroll: Enchant Armor (D)','false','scroll',120,'stackable','paper','none',-1,6000,0,'true','true','true','true','scrl_of_ench_am_d','scroll'),
(957,'Crystal Scroll: Enchant Weapon (D)','false','scroll',120,'stackable','paper','none',-1,6000,0,'true','true','true','true','cry_scrl_of_ench_wp_d','scroll'),
(958,'Crystal Scroll: Enchant Armor (D)','false','scroll',120,'stackable','paper','none',-1,6000,0,'true','true','true','true','cry_scrl_of_ench_am_d','scroll'),
(959,'Scroll: Enchant Weapon (S)','false','scroll',120,'stackable','paper','none',-1,5000000,0,'true','true','true','true','scrl_of_ench_wp_s','scroll'),
(960,'Scroll: Enchant Armor (S)','false','scroll',120,'stackable','paper','none',-1,500000,0,'true','true','true','true','scrl_of_ench_am_s','scroll'),
(961,'Crystal Scroll: Enchant Weapon (S)','false','scroll',120,'stackable','paper','none',-1,500000,0,'true','true','true','true','cry_scrl_of_ench_wp_s','scroll'),
(962,'Crystal Scroll: Enchant Armor (S)','false','scroll',120,'stackable','paper','none',-1,500000,0,'true','true','true','true','cry_scrl_of_ench_am_s','scroll'),
(963,'Orcish Arrowhead','false','quest',0,'stackable','steel','none',-1,0,0,'false','false','true','false','orcish_arrowhead','none'),
(964,'Alberius\'s Letter','false','quest',0,'stackable','steel','none',-1,0,0,'false','false','true','false','alberryus_letter','none'),
(965,'Evergreen Amulet','false','quest',0,'stackable','steel','none',-1,0,0,'false','false','true','false','evergreen_amulet','none'),
(966,'Dryad\'s Tears','false','quest',0,'stackable','steel','none',-1,0,0,'false','false','true','false','dryad_tears','none'),
(967,'Cobendell Medicine','false','quest',0,'stackable','steel','none',-1,0,0,'false','false','true','false','cobs_medicine','none'),
(968,'Karrod\'s Letter','false','quest',0,'stackable','steel','none',-1,0,0,'false','false','true','false','karoyds_letter','none'),
(969,'Cecktinon\'s First Voucher','false','quest',0,'stackable','steel','none',-1,0,0,'false','false','true','false','cecktinons_voucher1','none'),
(970,'Cecktinon\'s Second Voucher','false','quest',0,'stackable','steel','none',-1,0,0,'false','false','true','false','cecktinons_voucher2','none'),
(971,'Soul Catcher','false','quest',0,'stackable','steel','none',-1,0,0,'false','false','true','false','soul_catcher','none'),
(972,'Preserving Oil','false','quest',0,'stackable','steel','none',-1,0,0,'false','false','true','false','preserve_oil','none'),
(973,'Zombie Head','false','quest',0,'stackable','steel','none',-1,0,0,'false','false','true','false','zombie_head','none'),
(974,'Steelbender Head','false','quest',0,'stackable','steel','none',-1,0,0,'false','false','true','false','steelbenders_head','none'),
(976,'1st Mark of Sentinel','false','quest',0,'stackable','steel','none',-1,0,0,'false','false','true','false','mark_of_sentinel1','none'),
(977,'2nd Mark of Sentinel','false','quest',0,'stackable','steel','none',-1,0,0,'false','false','true','false','mark_of_sentinel2','none'),
(978,'Skullcrusher Amulet','false','quest',0,'stackable','steel','none',-1,0,0,'false','false','true','false','skullcrusher_amulet','none'),
(979,'Bloodspear Amulet','false','quest',0,'stackable','steel','none',-1,0,0,'false','false','true','false','bloodspear_amulet','none'),
(980,'0','false','quest',0,'stackable','steel','none',-1,0,0,'false','false','true','false','_red_sunset_staff','none'),
(982,'Esrandell\'s Letter','false','quest',0,'stackable','steel','none',-1,0,0,'false','false','true','false','eso_letter','none'),
(983,'Kendell\'s Letter','false','quest',0,'stackable','steel','none',-1,0,0,'false','false','true','false','kendnell_letter','none'),
(984,'1st Onyx Talisman','false','quest',0,'stackable','steel','none',-1,0,0,'false','false','true','false','onyx_talisman1','none'),
(985,'2nd Onyx Talisman','false','quest',0,'stackable','steel','none',-1,0,0,'false','false','true','false','onyx_talisman2','none'),
(986,'Ancient Scroll','false','quest',0,'stackable','steel','none',-1,0,0,'false','false','true','false','ancient_scroll','none'),
(987,'Ancient Clay Tablet','false','quest',0,'stackable','steel','none',-1,0,0,'false','false','true','false','ancient_clay_tablet','none'),
(988,'Kartia\'s Translation','false','quest',0,'stackable','steel','none',-1,0,0,'false','false','true','false','kartas_translation','none'),
(1001,'Book of Aklantoth - Part 4','false','quest',0,'stackable','steel','none',-1,0,0,'false','false','true','false','_book_of_aklantoth_p4','none'),
(1002,'Book of Aklantoth - Part 5','false','quest',0,'stackable','steel','none',-1,0,0,'false','false','true','false','_book_of_aklantoth_p5','none'),
(1003,'Book of Aklantoth - Part 6','false','quest',0,'stackable','steel','none',-1,0,0,'false','false','true','false','_book_of_aklantoth_p6','none'),
(1004,'Book of Aklantoth - Part 7','false','quest',0,'stackable','steel','none',-1,0,0,'false','false','true','false','_book_of_aklantoth_p7','none'),
(1005,'Book of Aklantoth - Part 8','false','quest',0,'stackable','steel','none',-1,0,0,'false','false','true','false','_book_of_aklantoth_p8','none'),
(1006,'Book of Aklantoth - Part 9','false','quest',0,'stackable','steel','none',-1,0,0,'false','false','true','false','_book_of_aklantoth_p9','none'),
(1007,'Book of Aklantoth - Part 10','false','quest',0,'stackable','steel','none',-1,0,0,'false','false','true','false','_book_of_aklantoth_p10','none'),
(1008,'Harrys\'s 1st Receipt','false','quest',0,'stackable','steel','none',-1,0,0,'false','false','true','false','harrys_receipt1','none'),
(1009,'Harrys\'s 2nd Receipt','false','quest',0,'stackable','steel','none',-1,0,0,'false','false','true','false','harrys_receipt2','none'),
(1010,'Golem Shard','false','quest',0,'stackable','steel','none',-1,0,0,'false','false','true','false','golem_shard','none'),
(1011,'Tool Box','false','quest',0,'stackable','steel','none',-1,0,0,'false','false','true','false','tool_box','none'),
(1012,'Delivery List','false','quest',0,'stackable','steel','none',-1,0,0,'false','false','true','false','delivery_list','none'),
(1013,'Heavy Wood Box','false','quest',0,'stackable','steel','none',-1,0,0,'false','false','true','false','heavy_wood_box','none'),
(1014,'Cloth Bundle','false','quest',0,'stackable','steel','none',-1,0,0,'false','false','true','false','cloth_bundle','none'),
(1015,'Clay Pot','false','quest',0,'stackable','steel','none',-1,0,0,'false','false','true','false','clay_pot','none'),
(1016,'Jackson\'s Receipt','false','quest',0,'stackable','steel','none',-1,0,0,'false','false','true','false','jacksons_receipt','none'),
(1017,'Silvia\'s Receipt','false','quest',0,'stackable','steel','none',-1,0,0,'false','false','true','false','silvias_receipt','none'),
(1018,'Rant\'s Receipt','false','quest',0,'stackable','steel','none',-1,0,0,'false','false','true','false','rants_receipt','none'),
(1019,'official Letter','false','quest',0,'stackable','steel','none',-1,0,0,'false','false','true','false','official_letter','none'),
(1020,'Flame Shard','false','quest',0,'stackable','steel','none',-1,0,0,'false','false','true','false','flame_shard','none'),
(1021,'Ice Shard','false','quest',0,'stackable','steel','none',-1,0,0,'false','false','true','false','ice_shard','none'),
(1022,'Lilith\'s Letter','false','quest',0,'stackable','steel','none',-1,0,0,'false','false','true','false','ryliths_letter','none'),
(1023,'Theon\'s Diary','false','quest',0,'stackable','steel','none',-1,0,0,'false','false','true','false','theons_diary','none'),
(1024,'Adamantite Ore','false','quest',0,'stackable','steel','none',-1,0,0,'false','false','true','false','adamantite_ore','none'),
(1025,'Clay Tablet','false','quest',0,'stackable','steel','none',-1,0,0,'false','false','true','false','clay_tablet','none'),
(1026,'Silvery Spidersilk','false','quest',0,'stackable','steel','none',-1,0,0,'false','false','true','false','silvery_spidersilk','none'),
(1027,'Unoren\'s Receipt','false','quest',0,'stackable','steel','none',-1,0,0,'false','false','true','false','unos_receipt','none'),
(1028,'Creamees\'s Ticket','false','quest',0,'stackable','steel','none',-1,0,0,'false','false','true','false','cels_ticket','none'),
(1029,'Nightshade Leaf','false','quest',0,'stackable','steel','none',-1,0,0,'false','false','true','false','nightshade_leaf','none'),
(1030,'Cracked Skull','false','quest',0,'stackable','steel','none',-1,0,0,'false','false','true','false','cracked_skull','none'),
(1031,'Perfect Skull','false','quest',0,'stackable','steel','none',-1,0,0,'false','false','true','false','perfect_skull','none'),
(1032,'Fox Fur','false','quest',0,'stackable','steel','none',-1,0,0,'false','false','true','false','fox_fur','none'),
(1033,'Fox Fur Yarn','false','quest',0,'stackable','steel','none',-1,0,0,'false','false','true','false','fox_fur_yarn','none'),
(1034,'Maiden Doll','false','quest',0,'stackable','steel','none',-1,0,0,'false','false','true','false','maiden_doll','none'),
(1035,'Plague Dust','false','quest',0,'stackable','steel','none',-1,0,0,'false','false','true','false','plague_dust','none'),
(1036,'Andellia\'s Letter','false','quest',0,'stackable','steel','none',-1,0,0,'false','false','true','false','andellrias_letter','none'),
(1037,'Fruit of The Mother Tree','false','quest',0,'stackable','steel','none',-1,0,0,'false','false','true','false','mothertree_fruit','none'),
(1038,'Rumiel\'s 1st Poem','false','quest',0,'stackable','steel','none',-1,0,0,'false','false','true','false','rumiels_poem_1','none'),
(1039,'Rumiel\'s 2nd Poem','false','quest',0,'stackable','steel','none',-1,0,0,'false','false','true','false','rumiels_poem_3','none'),
(1040,'Rumiel\'s 3rd Poem','false','quest',0,'stackable','steel','none',-1,0,0,'false','false','true','false','rumiels_poem_4','none'),
(1041,'Rumiel\'s 4th Poem','false','quest',0,'stackable','steel','none',-1,0,0,'false','false','true','false','rumiels_poem_5','none'),
(1042,'Wererat\'s Fang','false','quest',0,'stackable','steel','none',-1,0,0,'false','false','true','false','wererat_fang','none'),
(1043,'Varool Foulclaw\'s Fang','false','quest',0,'stackable','steel','none',-1,0,0,'false','false','true','false','varool_foulclaws_fang','none'),
(1044,'Kirunak Skull','false','quest',0,'stackable','steel','none',-1,0,0,'false','false','true','false','kirunak_skull','none'),
(1045,'Zombie\'s Skin','false','quest',0,'stackable','steel','none',-1,0,0,'false','false','true','false','zombie_skin','none'),
(1046,'Nightmare Crystal','false','quest',0,'stackable','steel','none',-1,0,0,'false','false','true','false','nightmare_crystal','none'),
(1047,'Spellbook: Light','false','spellbook',120,'stackable','paper','none',-1,100,0,'true','true','true','true','sb_light','none'),
(1048,'Spellbook: Might','false','spellbook',120,'stackable','paper','none',-1,100,0,'true','true','true','true','sb_might1','none'),
(1049,'Spellbook: Ice Bolt','false','spellbook',120,'stackable','paper','none',-1,100,0,'true','true','true','true','sb_ice_bolt1','none'),
(1050,'Spellbook: Battle Heal','false','spellbook',120,'stackable','paper','none',-1,100,0,'true','true','true','true','sb_battle_heal1','none'),
(1051,'Spellbook: Vampiric Touch','false','spellbook',120,'stackable','paper','none',-1,100,0,'true','true','true','true','sb_vampiric_touch1','none'),
(1052,'Spellbook: Flame Strike','false','spellbook',120,'stackable','paper','none',-1,500,0,'true','true','true','true','sb_flame_strike1','none'),
(1053,'Spellbook: Cure Poison','false','spellbook',120,'stackable','paper','none',-1,500,0,'true','true','true','true','sb_cure_poison1','none'),
(1054,'Spellbook: Group Heal','false','spellbook',120,'stackable','paper','none',-1,500,0,'true','true','true','true','sb_group_heal1','none'),
(1055,'Spellbook: Curse: Poison','false','spellbook',120,'stackable','paper','none',-1,500,0,'true','true','true','true','sb_curse:poison1','none'),
(1056,'Spellbook: Curse: Weakness','false','spellbook',120,'stackable','paper','none',-1,500,0,'true','true','true','true','sb_curse:weakness','none'),
(1057,'Spellbook: Summon Meal','false','spellbook',120,'stackable','paper','none',-1,500,0,'true','true','true','true','sb_summon_meal','none'),
(1058,'Spellbook: Shield','false','spellbook',120,'stackable','paper','none',-1,500,0,'true','true','true','true','sb_shield1','none'),
(1059,'Spellbook: Know Enemy','false','spellbook',120,'stackable','paper','none',-1,500,0,'true','true','true','true','sb_know_enemy','none'),
(1060,'Lesser Healing Potion','false','potion',5,'stackable','liquid','none',-1,90,0,'true','true','true','true','lesser_healing_potion','potion'),
(1061,'Healing Potion','false','potion',5,'stackable','liquid','none',-1,330,0,'true','true','true','true','healing_potion','potion'),
(1062,'Haste Potion','false','potion',180,'stackable','liquid','none',-1,5000,0,'true','true','true','true','haste_potion','potion'),
(1063,'Tutorial Parchment','false','quest',0,'stackable','steel','none',-1,0,0,'false','false','true','false','_tutorial_parchment_01','none'),
(1064,'Tutorial Parchment','false','quest',0,'stackable','steel','none',-1,0,0,'false','false','true','false','_tutorial_parchment_02','none'),
(1065,'Tutorial Parchment','false','quest',0,'stackable','steel','none',-1,0,0,'false','false','true','false','_tutorial_parchment_03','none'),
(1066,'Tutorial Parchment','false','quest',0,'stackable','steel','none',-1,0,0,'false','false','true','false','_tutorial_parchment_04','none'),
(1067,'Recommendation','false','quest',0,'stackable','steel','none',-1,0,0,'false','false','true','false','recommendation_01','none'),
(1068,'Recommendation','false','quest',0,'stackable','steel','none',-1,0,0,'false','false','true','false','recommendation_02','none'),
(1069,'Leaf of the Mother Tree','false','quest',0,'stackable','steel','none',-1,0,0,'false','false','true','false','leaf_of_mothertree','none'),
(1070,'Blood of Mitraell','false','quest',0,'stackable','steel','none',-1,0,0,'false','false','true','false','blood_of_jundin','none'),
(1071,'Hyacinth Charm','false','quest',0,'stackable','steel','none',-1,0,0,'false','false','true','false','hyacinth_charm1','none'),
(1072,'Hyacinth Charm','false','quest',0,'stackable','steel','none',-1,0,0,'false','false','true','false','hyacinth_charm2','none'),
(1073,'Beginner\'s Potion','false','potion',5,'stackable','liquid','none',-1,0,0,'true','true','true','true','beginners_potion','potion'),
(1074,'Boat Ticket: Talking Island to Gludin','false','none',20,'stackable','paper','none',-1,1000,0,'true','true','true','true','boat_ticket_talk_glu','none'),
(1075,'Boat Ticket: Gludin to Talking Island','false','none',20,'stackable','paper','none',-1,1000,0,'true','true','true','true','boat_ticket_glu_talk','none'),
(1076,'Carlon\'s Letter','false','quest',0,'stackable','steel','none',-1,0,0,'false','false','true','false','calculains_letter','none'),
(1077,'Venom Sac','false','quest',0,'stackable','steel','none',-1,0,0,'false','false','true','false','venom_sac','none'),
(1078,'Wind Shard','false','quest',0,'stackable','steel','none',-1,0,0,'false','false','true','false','wind_shard','none'),
(1079,'Darin\'s Receipt','false','quest',0,'stackable','steel','none',-1,0,0,'false','false','true','false','darings_receipt','none'),
(1080,'Baulro\'s Potion','false','quest',0,'stackable','steel','none',-1,0,0,'false','false','true','false','bauls_potion','none'),
(1081,'Omen Beast\'s Eye','false','quest',0,'stackable','steel','none',-1,0,0,'false','false','true','false','onyx_beast_eye','none'),
(1082,'Taint Stone','false','quest',0,'stackable','steel','none',-1,0,0,'false','false','true','false','taint_stone','none'),
(1083,'Succubus Blood','false','quest',0,'stackable','steel','none',-1,0,0,'false','false','true','false','succubus_blood','none'),
(1084,'Gludio Lord\'s Mark','false','quest',0,'stackable','steel','none',-1,0,0,'false','false','true','false','gludio_lords_mark','none'),
(1085,'Orc\'s Necklace','false','quest',0,'stackable','steel','none',-1,0,0,'false','false','true','false','orc_necklace','none'),
(1086,'Werewolf\'s Fang','false','quest',0,'stackable','steel','none',-1,0,0,'false','false','true','false','werewolf_fang','none'),
(1087,'Giant Spider Leg','false','quest',0,'stackable','steel','none',-1,0,0,'false','false','true','false','giant_spider_leg','none'),
(1088,'Undrias\'s Letter','false','quest',0,'stackable','steel','none',-1,0,0,'false','false','true','false','undres_letter','none'),
(1089,'Ceremonial Dagger','false','quest',0,'stackable','steel','none',-1,0,0,'false','false','true','false','ceremonial_dagger','none'),
(1090,'Dreviant Wine','false','quest',0,'stackable','steel','none',-1,0,0,'false','false','true','false','dreviant_wine','none'),
(1091,'Garmiel\'s Scripture','false','quest',0,'stackable','steel','none',-1,0,0,'false','false','true','false','garmiels_scripture','none'),
(1092,'Arujien\'s Letter','false','quest',0,'stackable','steel','none',-1,0,0,'false','false','true','false','arujiens_letter1','none'),
(1093,'Arujien\'s Letter','false','quest',0,'stackable','steel','none',-1,0,0,'false','false','true','false','arujiens_letter2','none'),
(1094,'Arujien\'s Letter','false','quest',0,'stackable','steel','none',-1,0,0,'false','false','true','false','arujiens_letter3','none'),
(1095,'Spellbook: Attack Aura','false','spellbook',120,'stackable','paper','none',-1,75,0,'true','true','true','true','sb_advanced_attack_power1','none'),
(1096,'Spellbook: Elemental Heal','false','spellbook',120,'stackable','paper','none',-1,550,0,'true','true','true','true','sb_elemental_heal1','none'),
(1097,'Spellbook: Drain Health','false','spellbook',120,'stackable','paper','none',-1,550,0,'true','true','true','true','sb_drain_energy1','none'),
(1098,'Spellbook: Wind Walk','false','spellbook',120,'stackable','paper','none',-1,500,0,'true','true','true','true','sb_wind_walk1','none'),
(1099,'Spellbook: Wind Shackle','false','spellbook',120,'stackable','paper','none',-1,500,0,'true','true','true','true','sb_breeze1','none'),
(1106,'Norman\'s Letter','false','quest',0,'stackable','steel','none',-1,0,0,'false','false','true','false','normans_letter','none'),
(1107,'Bone Fragment','false','quest',0,'stackable','steel','none',-1,0,0,'false','false','true','false','bone_fragment1','none'),
(1108,'Arbon\'s Letter','false','quest',0,'stackable','steel','none',-1,0,0,'false','false','true','false','_arbons_letter1','none'),
(1109,'Roien\'s Letter','false','quest',0,'stackable','steel','none',-1,0,0,'false','false','true','false','_roiens_letter1','none'),
(1110,'Bone Fragment','false','quest',0,'stackable','steel','none',-1,0,0,'false','false','true','false','_bone_fragment2','none'),
(1111,'Adamantite Ore','false','quest',0,'stackable','steel','none',-1,0,0,'false','false','true','false','__adamantite_ore1','none'),
(1112,'Leaf of the Mother Tree','false','quest',0,'stackable','steel','none',-1,0,0,'false','false','true','false','leaf_of_mothertree_01','none'),
(1113,'Blood of Mitraell','false','quest',0,'stackable','steel','none',-1,0,0,'false','false','true','false','blood_of_jundin_01','none'),
(1114,'Orc Amulet','false','quest',0,'stackable','steel','none',-1,0,0,'false','false','true','false','orc_amulet1','none'),
(1115,'Orc\'s Necklace','false','quest',0,'stackable','steel','none',-1,0,0,'false','false','true','false','orc_necklace1','none'),
(1116,'Orc Amulet','false','quest',0,'stackable','steel','none',-1,0,0,'false','false','true','false','orc_amulet2','none'),
(1117,'Orc\'s Necklace','false','quest',0,'stackable','steel','none',-1,0,0,'false','false','true','false','orc_necklace2','none'),
(1118,'Spore Sac','false','quest',0,'stackable','steel','none',-1,0,0,'false','false','true','false','fungus_sac1','none'),
(1130,'Cobendell\'s Medicine','false','quest',0,'stackable','steel','none',-1,0,0,'false','false','true','false','cobs_medicine1','none'),
(1131,'Cobendell\'s Medicine','false','quest',0,'stackable','steel','none',-1,0,0,'false','false','true','false','cobs_medicine2','none'),
(1132,'Cobendell\'s Medicine','false','quest',0,'stackable','steel','none',-1,0,0,'false','false','true','false','cobs_medicine3','none'),
(1133,'Cobendell\'s Medicine','false','quest',0,'stackable','steel','none',-1,0,0,'false','false','true','false','cobs_medicine4','none'),
(1134,'Cobendell\'s Medicine','false','quest',0,'stackable','steel','none',-1,0,0,'false','false','true','false','cobs_medicine5','none'),
(1135,'Spiritbound Wand','false','quest',0,'stackable','steel','none',-1,0,0,'false','false','true','false','wand_spiritbound1','none'),
(1136,'Spiritbound Wand','false','quest',0,'stackable','steel','none',-1,0,0,'false','false','true','false','wand_spiritbound2','none'),
(1137,'Spiritbound Wand','false','quest',0,'stackable','steel','none',-1,0,0,'false','false','true','false','wand_spiritbound3','none'),
(1138,'Auron\'s Letter','false','quest',0,'stackable','steel','none',-1,0,0,'false','false','true','false','eins_letter','none'),
(1139,'Warrior Guild Mark','false','quest',0,'stackable','steel','none',-1,0,0,'false','false','true','false','warrior_guild_mark','none'),
(1140,'Rusted Bronze Sword','false','quest',0,'stackable','steel','none',-1,0,0,'false','false','true','false','rusted_bronze_sword1','none'),
(1141,'Rusted Bronze Sword','false','quest',0,'stackable','steel','none',-1,0,0,'true','false','true','true','rusted_bronze_sword2','none'),
(1143,'Simplon\'s Letter','false','quest',0,'stackable','steel','none',-1,0,0,'false','false','true','false','simplons_letter','none'),
(1144,'Venomous Spider Leg','false','quest',0,'stackable','steel','none',-1,0,0,'false','false','true','false','poison_spider_leg2','none'),
(1145,'Medallion of Warrior','false','quest',0,'stackable','steel','none',-1,0,0,'true','false','true','true','medallion_of_warrior','none'),
(1150,'Spellbook: Wind Strike','false','spellbook',120,'stackable','paper','none',-1,50,0,'true','true','true','true','sb_wind_strike1','none'),
(1151,'Spellbook: Self Heal','false','spellbook',120,'stackable','paper','none',-1,50,0,'true','true','true','true','sb_self_heal','none'),
(1152,'Spellbook: Heal','false','spellbook',120,'stackable','paper','none',-1,100,0,'true','true','true','true','sb_heal1','none'),
(1153,'Jenna\'s Letter','false','quest',0,'stackable','steel','none',-1,0,0,'false','false','true','false','jennies_letter','none'),
(1154,'Sentry Blade','false','quest',0,'stackable','steel','none',-1,0,0,'false','false','true','false','sentry_blade1','none'),
(1155,'Sentry Blade','false','quest',0,'stackable','steel','none',-1,0,0,'false','false','true','false','sentry_blade2','none'),
(1156,'Sentry Blade','false','quest',0,'stackable','steel','none',-1,0,0,'false','false','true','false','sentry_blade3','none'),
(1157,'Old Bronze Sword','false','quest',0,'stackable','steel','none',-1,0,0,'false','false','true','false','old_bronze_sword','none'),
(1158,'Bone Fragment','false','quest',0,'stackable','steel','none',-1,0,0,'false','false','true','false','bone_fragment3','none'),
(1159,'Elf Skull','false','quest',0,'stackable','steel','none',-1,0,0,'false','false','true','false','elf_skull','none'),
(1160,'Dark Bezoar','false','quest',0,'stackable','steel','none',-1,0,0,'false','false','true','false','dark_bezoar','none'),
(1161,'Sword of Ritual','false','quest',0,'stackable','steel','none',-1,0,0,'false','false','true','false','sword_of_ritual','none'),
(1162,'Coin of Lords','false','quest',0,'stackable','steel','none',-1,0,0,'false','false','true','false','coin_of_lords1','none'),
(1163,'Coin of Lords','false','quest',0,'stackable','steel','none',-1,0,0,'false','false','true','false','coin_of_lords2','none'),
(1164,'Coin of Lords','false','quest',0,'stackable','steel','none',-1,0,0,'false','false','true','false','coin_of_lords3','none'),
(1165,'Coin of Lords','false','quest',0,'stackable','steel','none',-1,0,0,'false','false','true','false','coin_of_lords4','none'),
(1166,'Coin of Lords','false','quest',0,'stackable','steel','none',-1,0,0,'false','false','true','false','coin_of_lords5','none'),
(1167,'Coin of Lords','false','quest',0,'stackable','steel','none',-1,0,0,'false','false','true','false','coin_of_lords6','none'),
(1168,'Gludio Guard\'s 1st Badge','false','quest',0,'stackable','steel','none',-1,0,0,'false','false','true','false','gludio_guards_mark1','none'),
(1169,'Bugbear Necklace','false','quest',0,'stackable','steel','none',-1,0,0,'false','false','true','false','bugbear_necklace','none'),
(1170,'Einhasad\'s 1st Temple Badge','false','quest',0,'stackable','steel','none',-1,0,0,'false','false','true','false','einhasad_church_mark1','none'),
(1171,'Einhasad\'s Crucifix','false','quest',0,'stackable','steel','none',-1,0,0,'false','false','true','false','einhasad_crucifix','none'),
(1172,'Gludio Guard\'s 2nd Badge','false','quest',0,'stackable','steel','none',-1,0,0,'false','false','true','false','gludio_guards_mark2','none'),
(1173,'Venomous Spider Leg','false','quest',0,'stackable','steel','none',-1,0,0,'false','false','true','false','poison_spider_leg1','none'),
(1174,'Einhasad\'s 2nd Temple Badge','false','quest',0,'stackable','steel','none',-1,0,0,'false','false','true','false','einhasad_church_mark2','none'),
(1175,'Lizardman\'s Totem','false','quest',0,'stackable','steel','none',-1,0,0,'false','false','true','false','lizardman_totem','none'),
(1176,'Gludio Guard\'s 3rd Badge','false','quest',0,'stackable','steel','none',-1,0,0,'false','false','true','false','gludio_guards_mark3','none'),
(1177,'Giant Spider\'s Husk','false','quest',0,'stackable','steel','none',-1,0,0,'false','false','true','false','giant_spider_husk','none'),
(1178,'Einhasad\'s 3rd Temple Badge','false','quest',0,'stackable','steel','none',-1,0,0,'false','false','true','false','einhasad_church_mark3','none'),
(1179,'Skull of Silent Horror','false','quest',0,'stackable','steel','none',-1,0,0,'false','false','true','false','horrible_skull','none'),
(1180,'Bezique\'s Letter','false','quest',0,'stackable','steel','none',-1,0,0,'false','false','true','false','beziques_letter','none'),
(1183,'Spartoi\'s Bones','false','quest',0,'stackable','steel','none',-1,0,0,'false','false','true','false','spatois_bones','none'),
(1184,'Horseshoe of Light','false','quest',0,'stackable','steel','none',-1,0,0,'false','false','true','false','horseshoe_of_light','none'),
(1185,'Most Wanted List','false','quest',0,'stackable','steel','none',-1,0,0,'false','false','true','false','wanted_bill','none'),
(1186,'Stolen Jewelry','false','quest',0,'stackable','steel','none',-1,0,0,'false','false','true','false','stolen_jewelry','none'),
(1187,'Stolen Tomes','false','quest',0,'stackable','steel','none',-1,0,0,'false','false','true','false','stolen_tomes','none'),
(1188,'Stolen Ring','false','quest',0,'stackable','steel','none',-1,0,0,'false','false','true','false','stolen_ring','none'),
(1189,'Stolen Necklace','false','quest',0,'stackable','steel','none',-1,0,0,'false','false','true','false','stolen_necklace','none'),
(1190,'Bezique\'s Recommendation','false','quest',0,'stackable','steel','none',-1,0,0,'false','false','true','false','beziques_recommendation','none'),
(1191,'1st Letter of Order','false','quest',0,'stackable','steel','none',-1,0,0,'false','false','true','false','letter_of_order1','none'),
(1192,'2nd Letter of Order','false','quest',0,'stackable','steel','none',-1,0,0,'false','false','true','false','letter_of_order2','none'),
(1193,'Lionel\'s Book','false','quest',0,'stackable','steel','none',-1,0,0,'false','false','true','false','book_of_lemoniell','none'),
(1194,'Book of Vivyan','false','quest',0,'stackable','steel','none',-1,0,0,'false','false','true','false','book_of_vivi','none'),
(1195,'Book of Simplon','false','quest',0,'stackable','steel','none',-1,0,0,'false','false','true','false','book_of_simlon','none'),
(1196,'Book of Praga','false','quest',0,'stackable','steel','none',-1,0,0,'false','false','true','false','book_of_praga','none'),
(1197,'Certificate of Gallint','false','quest',0,'stackable','steel','none',-1,0,0,'false','false','true','false','certificate_of_gallint','none'),
(1198,'Pendant of Mother','false','quest',0,'stackable','steel','none',-1,0,0,'false','false','true','false','pendant_of_mother','none'),
(1199,'Necklace of Mother','false','quest',0,'stackable','steel','none',-1,0,0,'false','false','true','false','necklace_of_mother','none'),
(1200,'Lionel\'s Covenant','false','quest',0,'stackable','steel','none',-1,0,0,'false','false','true','false','lemoniells_covenant','none'),
(1201,'Mark of Faith','false','quest',0,'stackable','steel','none',-1,0,0,'false','false','true','false','mark_of_faith','none'),
(1202,'Sorius\'s Letter','false','quest',0,'stackable','steel','none',-1,0,0,'false','false','true','false','sorius_letter1','none'),
(1203,'Kluto Box','false','quest',0,'stackable','steel','none',-1,0,0,'false','false','true','false','kluto_box','none'),
(1204,'Elven Knight Brooch','false','quest',0,'stackable','steel','none',-1,0,0,'false','false','true','false','elven_knight_brooch','none'),
(1205,'Topaz Piece','false','quest',0,'stackable','steel','none',-1,0,0,'false','false','true','false','topaz_piece','none'),
(1206,'Emerald Piece','false','quest',0,'stackable','steel','none',-1,0,0,'false','false','true','false','emerald_piece','none'),
(1207,'Reisa\'s Letter','false','quest',0,'stackable','steel','none',-1,0,0,'false','false','true','false','reoria_letter2','none'),
(1208,'Prias\'s 1st Torn Letter','false','quest',0,'stackable','steel','none',-1,0,0,'false','false','true','false','priguns_tear_letter1','none'),
(1209,'Prias\'s 2nd Torn Letter','false','quest',0,'stackable','steel','none',-1,0,0,'false','false','true','false','priguns_tear_letter2','none'),
(1210,'Prias\'s 3rd Torn Letter','false','quest',0,'stackable','steel','none',-1,0,0,'false','false','true','false','priguns_tear_letter3','none'),
(1211,'Prias\'s 4th Torn Letter','false','quest',0,'stackable','steel','none',-1,0,0,'false','false','true','false','priguns_tear_letter4','none'),
(1212,'Moretti\'s Herb','false','quest',0,'stackable','steel','none',-1,0,0,'false','false','true','false','morettis_herb','none'),
(1214,'Moretti\'s Letter','false','quest',0,'stackable','steel','none',-1,0,0,'false','false','true','false','morettis_letter','none'),
(1215,'Prias\'s Letter','false','quest',0,'stackable','steel','none',-1,0,0,'false','false','true','false','priguns_letter','none'),
(1216,'Honorary Guard','false','quest',0,'stackable','steel','none',-1,0,0,'false','false','true','false','honorary_guard','none'),
(1217,'Reisa\'s Recommendation','false','quest',0,'stackable','steel','none',-1,0,0,'false','false','true','false','reoria_recommendation','none'),
(1218,'Rosella\'s Letter','false','quest',0,'stackable','steel','none',-1,0,0,'false','false','true','false','rogellias_letter','none'),
(1219,'Red Down','false','quest',0,'stackable','steel','none',-1,0,0,'false','false','true','false','red_down','none'),
(1220,'Magical Powers Ruby','false','quest',0,'stackable','steel','none',-1,0,0,'false','false','true','false','magical_powers_ruby','none'),
(1221,'Pure Aquamarine','false','quest',0,'stackable','steel','none',-1,0,0,'false','false','true','false','pure_aquamarine','none'),
(1222,'Appetizing Apple','false','quest',0,'stackable','steel','none',-1,0,0,'false','false','true','false','appetizing_apple','none'),
(1223,'Gold Leaves','false','quest',0,'stackable','steel','none',-1,0,0,'false','false','true','false','gold_leaves','none'),
(1224,'Immortal Love','false','quest',0,'stackable','steel','none',-1,0,0,'false','false','true','false','immortal_love','none'),
(1225,'Amethyst','false','quest',0,'stackable','steel','none',-1,0,0,'false','false','true','false','amethyst','none'),
(1226,'Nobility Amethyst','false','quest',0,'stackable','steel','none',-1,0,0,'false','false','true','false','nobility_amethyst','none'),
(1227,'Rosella\'s Recommendation','false','quest',0,'stackable','steel','none',-1,0,0,'false','false','true','false','rogellias_recommend','none'),
(1228,'Peridot','false','quest',0,'stackable','steel','none',-1,0,0,'false','false','true','false','peridot','none'),
(1229,'Fertility Peridot','false','quest',0,'stackable','steel','none',-1,0,0,'false','false','true','false','fertility_peridot','none'),
(1230,'Eternity Diamond','false','quest',0,'stackable','steel','none',-1,0,0,'false','false','true','false','eternity_diamond','none'),
(1231,'Crystal Medallion','false','quest',0,'stackable','steel','none',-1,0,0,'false','false','true','false','crystal_medallion','none'),
(1232,'Swindler\'s Money','false','quest',0,'stackable','steel','none',-1,0,0,'false','false','true','false','money_of_swindler','none'),
(1233,'Allana\'s Diary','false','quest',0,'stackable','steel','none',-1,0,0,'false','false','true','false','dairy_of_allana','none'),
(1234,'Lizard Captain Order','false','quest',0,'stackable','steel','none',-1,0,0,'false','false','true','false','lizard_captain_order','none'),
(1235,'Leaf of Oracle','false','quest',0,'stackable','steel','none',-1,0,0,'false','false','true','false','leaf_of_oracle','none'),
(1236,'Half of Diary','false','quest',0,'stackable','steel','none',-1,0,0,'false','false','true','false','half_of_dairy','none'),
(1237,'Palus Talisman','false','quest',0,'stackable','steel','none',-1,0,0,'false','false','true','false','pallus_talisman','none'),
(1238,'Lycanthrope Skull','false','quest',0,'stackable','steel','none',-1,0,0,'false','false','true','false','lycanthrope_skull','none'),
(1239,'Virgil\'s Letter','false','quest',0,'stackable','steel','none',-1,0,0,'false','false','true','false','virgils_letter','none'),
(1240,'Morte Talisman','false','quest',0,'stackable','steel','none',-1,0,0,'false','false','true','false','morte_talisman','none'),
(1241,'Predator\'s Carapace','false','quest',0,'stackable','steel','none',-1,0,0,'false','false','true','false','predator_carapace','none'),
(1242,'Arachnid Tracker Silk','false','quest',0,'stackable','steel','none',-1,0,0,'false','false','true','false','trimden_silk','none'),
(1243,'Coffin of Eternal Rest','false','quest',0,'stackable','steel','none',-1,0,0,'false','false','true','false','coffin_eternal_rest','none'),
(1244,'Gaze of Abyss','false','quest',0,'stackable','steel','none',-1,0,0,'false','false','true','false','gaze_of_abyss','none'),
(1245,'Shilen\'s Call','false','quest',0,'stackable','steel','none',-1,0,0,'false','false','true','false','shilens_call','none'),
(1246,'Arkenia\'s Letter','false','quest',0,'stackable','steel','none',-1,0,0,'false','false','true','false','arkenias_letter','none'),
(1247,'Leikan\'s Note','false','quest',0,'stackable','steel','none',-1,0,0,'false','false','true','false','leikans_note','none'),
(1248,'Moonstone Beast\'s Molar','false','quest',0,'stackable','steel','none',-1,0,0,'false','false','true','false','onyx_beasts_molar','none'),
(1249,'Leikan\'s Knife','false','quest',0,'stackable','steel','none',-1,0,0,'false','false','true','false','leikans_knife','none'),
(1250,'Shilen\'s Tears','false','quest',0,'stackable','steel','none',-1,0,0,'false','false','true','false','shilens_tears','none'),
(1251,'Arkenia\'s Recommendation','false','quest',0,'stackable','steel','none',-1,0,0,'false','false','true','false','arkenia_recommend','none'),
(1252,'Iron Heart','false','quest',0,'stackable','steel','none',-1,0,0,'false','false','true','false','iron_heart','none'),
(1253,'Seed of Anger','false','quest',0,'stackable','steel','none',-1,0,0,'false','false','true','false','seeds_of_anger','none'),
(1254,'Seed of Despair','false','quest',0,'stackable','steel','none',-1,0,0,'false','false','true','false','seeds_of_despair','none'),
(1255,'Seed of Horror','false','quest',0,'stackable','steel','none',-1,0,0,'false','false','true','false','seeds_of_horror','none'),
(1256,'Seed of Lunacy','false','quest',0,'stackable','steel','none',-1,0,0,'false','false','true','false','seeds_of_lunacy','none'),
(1257,'Family\'s Remains','false','quest',0,'stackable','steel','none',-1,0,0,'false','false','true','false','familys_ashes','none'),
(1258,'Varika\'s Liquor','false','quest',0,'stackable','steel','none',-1,0,0,'false','false','true','false','varikas_liquor','none'),
(1259,'Knee Bone','false','quest',0,'stackable','steel','none',-1,0,0,'false','false','true','false','knee_bone','none'),
(1260,'Heart of Lunacy','false','quest',0,'stackable','steel','none',-1,0,0,'false','false','true','false','heart_of_lunacy','none'),
(1261,'Dark Jewel','false','quest',0,'stackable','steel','none',-1,0,0,'false','false','true','false','jewel_of_darkness','none'),
(1262,'Sidra\'s Letter','false','quest',0,'stackable','steel','none',-1,0,0,'false','false','true','false','sidras_letter1','none'),
(1263,'Blank Sheet','false','quest',0,'stackable','steel','none',-1,0,0,'false','false','true','false','blank_sheet1','none'),
(1264,'Bloody Rune','false','quest',0,'stackable','steel','none',-1,0,0,'false','false','true','false','bloody_rune1','none'),
(1265,'Garmiel Book','false','quest',0,'stackable','steel','none',-1,0,0,'false','false','true','false','garmiel_book','none'),
(1266,'Prayer of Adonius','false','quest',0,'stackable','steel','none',-1,0,0,'false','false','true','false','prayer_of_adon','none'),
(1267,'Penitent\'s Mark','false','quest',0,'stackable','steel','none',-1,0,0,'false','false','true','false','penitents_mark','none'),
(1268,'Ashen Bones','false','quest',0,'stackable','steel','none',-1,0,0,'false','false','true','false','ashen_bones','none'),
(1269,'Andariel Book','false','quest',0,'stackable','steel','none',-1,0,0,'false','false','true','false','andariel_book','none'),
(1270,'Orb of Abyss','false','quest',0,'stackable','steel','none',-1,0,0,'false','false','true','false','orb_of_abyss','none'),
(1271,'Mark of Esquire','false','quest',0,'stackable','steel','none',-1,0,0,'false','false','true','false','mark_of_esquire','none'),
(1272,'Charm of Grain','false','quest',0,'stackable','steel','none',-1,0,0,'false','false','true','false','charm_of_grain','none'),
(1273,'Sap of the Mother Tree','false','quest',0,'stackable','steel','none',-1,0,0,'false','false','true','false','sap_of_world_tree','none'),
(1274,'Lucky Potpourri','false','quest',0,'stackable','steel','none',-1,0,0,'false','false','true','false','lucky_potpouri','none'),
(1275,'Tamil\'s Necklace','false','quest',0,'stackable','steel','none',-1,0,0,'false','false','true','false','tamatos_necklace','none'),
(1276,'Kluto\'s Memo','false','quest',0,'stackable','steel','none',-1,0,0,'false','false','true','false','kluto_memo','none'),
(1277,'Lucky Key','false','quest',0,'stackable','steel','none',-1,0,0,'false','false','true','false','lucky_key','none'),
(1278,'Candle','false','quest',0,'stackable','steel','none',-1,0,0,'false','false','true','false','candle','none'),
(1279,'Hub Scent','false','quest',0,'stackable','steel','none',-1,0,0,'false','false','true','false','hub_scent','none'),
(1280,'Map of Luster','false','quest',0,'stackable','steel','none',-1,0,0,'false','false','true','false','map_of_luster','none'),
(1281,'Key of Flame','false','quest',0,'stackable','steel','none',-1,0,0,'false','false','true','false','key_of_flame','none'),
(1282,'Flame Earring','false','quest',0,'stackable','steel','none',-1,0,0,'false','false','true','false','flame_earing','none'),
(1283,'Broken Bronze Mirror','false','quest',0,'stackable','steel','none',-1,0,0,'false','false','true','false','broken_bronze_mirror','none'),
(1284,'Wind Feather','false','quest',0,'stackable','steel','none',-1,0,0,'false','false','true','false','wind_feather','none'),
(1285,'Wind Bangle','false','quest',0,'stackable','steel','none',-1,0,0,'false','false','true','false','wind_bangel','none'),
(1286,'Rama\'s Diary','false','quest',0,'stackable','steel','none',-1,0,0,'false','false','true','false','ramas_diary','none'),
(1287,'Sparkle Pebble','false','quest',0,'stackable','steel','none',-1,0,0,'false','false','true','false','sparkle_pebble','none'),
(1288,'Water Necklace','false','quest',0,'stackable','steel','none',-1,0,0,'false','false','true','false','water_necklace','none'),
(1289,'Rust Gold Coin','false','quest',0,'stackable','steel','none',-1,0,0,'false','false','true','false','rust_gold_coin','none'),
(1290,'Red Soil','false','quest',0,'stackable','steel','none',-1,0,0,'false','false','true','false','red_soil','none'),
(1291,'Earth Ring','false','quest',0,'stackable','steel','none',-1,0,0,'false','false','true','false','earth_ring','none'),
(1292,'Bead of Season','false','quest',0,'stackable','steel','none',-1,0,0,'false','false','true','false','bead_of_season','none'),
(1293,'Rusted Key','false','quest',0,'stackable','steel','none',-1,0,0,'false','false','true','false','rusted_key','none'),
(1294,'Spellbook: Defense Aura','false','spellbook',120,'stackable','paper','none',-1,75,0,'true','true','true','true','sb_adv_defence_power1','none'),
(1334,'Predator\'s Fang','false','quest',0,'stackable','steel','none',-1,0,0,'true','false','true','true','predators_fang','none'),
(1335,'Goblin Club','false','quest',0,'stackable','steel','none',-1,0,0,'true','false','true','true','goblin_club','none'),
(1336,'Glass Shard','false','none',80,'stackable','liquid','none',-1,200,0,'true','true','true','true','glass_shard','none'),
(1337,'Emerald','false','none',80,'stackable','liquid','none',-1,20000,0,'true','true','true','true','emerald','none'),
(1338,'Blue Onyx','false','none',80,'stackable','liquid','none',-1,1000,0,'true','true','true','true','blue_onyx','none'),
(1339,'Onyx','false','none',80,'stackable','liquid','none',-1,600,0,'true','true','true','true','onyx','none'),
(1340,'Silvery Leaf','false','none',3,'stackable','liquid','none',-1,20,0,'true','true','true','true','silvery_leaf','none'),
(1341,'Bone Arrow','false','arrow',5,'stackable','bone','d',-1,3,0,'true','true','true','true','bone_arrow','arrow'),
(1342,'Iron Arrow','false','arrow',4,'stackable','fine_steel','c',-1,5,0,'true','true','true','true','fine_steel_arrow','arrow'),
(1343,'Silver Arrow','false','arrow',4,'stackable','silver','b',-1,7,0,'true','true','true','true','silver_arrow','arrow'),
(1344,'Mithril Arrow','false','arrow',3,'stackable','mithril','a',-1,8,0,'true','true','true','true','mithril_arrow','arrow'),
(1345,'Shining Arrow','false','arrow',3,'stackable','adamantaite','s',-1,10,0,'true','true','true','true','shining_arrow','arrow'),
(1346,'Golem\'s Stoneheart','false','quest',0,'stackable','steel','none',-1,0,0,'false','false','true','false','golem_heartstone','none'),
(1347,'Monster Eye Carcass','false','quest',0,'stackable','steel','none',-1,0,0,'false','false','true','false','monster_eye_carcass','none'),
(1348,'Basilisk\'s Gizzard','false','quest',0,'stackable','steel','none',-1,0,0,'false','false','true','false','basilisk_gizzard','none'),
(1349,'Anatomy Diagram','false','quest',0,'stackable','steel','none',-1,0,0,'false','false','true','false','anatomy_diagram','none'),
(1350,'Zombie Head','false','quest',0,'stackable','steel','none',-1,0,0,'false','false','true','false','zombie_head1','none'),
(1351,'Zombie Heart','false','quest',0,'stackable','steel','none',-1,0,0,'false','false','true','false','zombie_heart1','none'),
(1352,'Zombie Liver','false','quest',0,'stackable','steel','none',-1,0,0,'false','false','true','false','zombie_liver1','none'),
(1353,'Skull','false','quest',0,'stackable','steel','none',-1,0,0,'false','false','true','false','skull1','none'),
(1354,'Rib Bone','false','quest',0,'stackable','steel','none',-1,0,0,'false','false','true','false','rib_bone1','none'),
(1355,'Spine','false','quest',0,'stackable','steel','none',-1,0,0,'false','false','true','false','spine1','none'),
(1356,'Arm Bone','false','quest',0,'stackable','steel','none',-1,0,0,'false','false','true','false','arm_bone1','none'),
(1357,'Thigh Bone','false','quest',0,'stackable','steel','none',-1,0,0,'false','false','true','false','thigh_bone1','none'),
(1358,'Complete Skeleton','false','quest',0,'stackable','steel','none',-1,0,0,'false','false','true','false','complete_skeleton','none'),
(1359,'Red Cross Badge','false','quest',0,'stackable','steel','none',-1,0,0,'false','false','true','false','red_cross_badge','none'),
(1360,'Blue Cross Badge','false','quest',0,'stackable','steel','none',-1,0,0,'false','false','true','false','blue_cross_badge','none'),
(1361,'Black Cross Badge','false','quest',0,'stackable','steel','none',-1,0,0,'false','false','true','false','black_cross_badge','none'),
(1362,'Spider\'s Carapace','false','quest',0,'stackable','steel','none',-1,0,0,'false','false','true','false','spider_carapace','none'),
(1363,'Spider Silk','false','quest',0,'stackable','steel','none',-1,0,0,'false','false','true','false','spider_silk','none'),
(1364,'Spider Venom Sac','false','quest',0,'stackable','steel','none',-1,0,0,'false','false','true','false','spider_venom_sac','none'),
(1365,'Broken Stoneheart','false','quest',0,'stackable','steel','none',-1,0,0,'false','false','true','false','broken_heartstone','none'),
(1366,'Monster Eye\'s Lens','false','quest',0,'stackable','steel','none',-1,0,0,'false','false','true','false','monster_eye_lens','none'),
(1367,'Wolf Claw','false','quest',0,'stackable','steel','none',-1,0,0,'false','false','true','false','wolf_claw1','none'),
(1368,'Imp Shackles','false','quest',0,'stackable','steel','none',-1,0,0,'false','false','true','false','imp_shackles','none'),
(1369,'Black Lion Mark','false','quest',0,'stackable','steel','none',-1,0,0,'false','false','true','false','black_lion_mark','none'),
(1370,'Spellbook: Aqua Swirl','false','spellbook',120,'stackable','paper','none',-1,800,0,'true','true','true','true','sb_aqua_swirl1','none'),
(1371,'Spellbook: Twister','false','spellbook',120,'stackable','paper','none',-1,800,0,'true','true','true','true','sb_twister1','none'),
(1372,'Spellbook: Blaze','false','spellbook',120,'stackable','paper','none',-1,800,0,'true','true','true','true','sb_blaze1','none'),
(1373,'Magic Gem','false','none',80,'stackable','liquid','none',-1,600,0,'true','true','true','true','magic_gem','none'),
(1374,'Greater Haste Potion','false','potion',20,'stackable','liquid','none',-1,3600,0,'true','true','true','true','adv_quick_step_potion','potion'),
(1375,'Greater Swift Attack Potion','false','potion',20,'stackable','liquid','none',-1,7200,0,'true','true','true','true','adv_swift_attack_potion','potion'),
(1377,'Spellbook: Poison Recovery','false','spellbook',120,'stackable','paper','none',-1,800,0,'true','true','true','true','sb_poison_recovery1','none'),
(1378,'Spellbook: Divine Heal','false','spellbook',120,'stackable','paper','none',-1,1550,0,'true','true','true','true','sb_touch_of_god1','none'),
(1379,'Spellbook: Cure Bleeding','false','spellbook',120,'stackable','paper','none',-1,1150,0,'true','true','true','true','sb_cure_bleeding1','none'),
(1380,'Spellbook: Entangle','false','spellbook',120,'stackable','paper','none',-1,500,0,'true','true','true','true','sb_zero_g1','none'),
(1381,'Spellbook: Freezing Strike','false','spellbook',120,'stackable','paper','none',-1,2600,0,'true','true','true','true','sb_freezing_strike1','none'),
(1382,'Spellbook: Power Break','false','spellbook',120,'stackable','paper','none',-1,2600,0,'true','true','true','true','sb_power_break1','none'),
(1383,'Spellbook: Poison','false','spellbook',120,'stackable','paper','none',-1,800,0,'true','true','true','true','sb_poison1','none'),
(1384,'Spellbook: Sprint','false','spellbook',120,'stackable','paper','none',-1,2600,0,'true','true','true','true','sb_speed_walk1','none'),
(1385,'Spellbook: Recharge','false','spellbook',120,'stackable','paper','none',-1,1800,0,'true','true','true','true','sb_recharge1','none'),
(1386,'Spellbook: Disrupt Undead','false','spellbook',120,'stackable','paper','none',-1,800,0,'true','true','true','true','sb_disrupt_undead1','none'),
(1387,'Spellbook: Resist Poison','false','spellbook',120,'stackable','paper','none',-1,2450,0,'true','true','true','true','sb_resist_poison1','none'),
(1388,'Spellbook: Mental Shield','false','spellbook',120,'stackable','paper','none',-1,1250,0,'true','true','true','true','sb_mental_shield1','none'),
(1389,'Spellbook: Holy Weapon','false','spellbook',120,'stackable','paper','none',-1,1250,0,'true','true','true','true','sb_holy_weapon1','none'),
(1390,'Spellbook: Regeneration','false','spellbook',120,'stackable','paper','none',-1,2450,0,'true','true','true','true','sb_regeneration1','none'),
(1391,'Spellbook: Empower','false','spellbook',120,'stackable','paper','none',-1,1250,0,'true','true','true','true','sb_empower1','none'),
(1392,'Spellbook: Berserker Spirit','false','spellbook',120,'stackable','paper','none',-1,2450,0,'true','true','true','true','sb_berserker_spirit1','none'),
(1393,'Spellbook: Quickness','false','spellbook',120,'stackable','paper','none',-1,1250,0,'true','true','true','true','sb_quickness1','none'),
(1394,'Spellbook: Sleep','false','spellbook',120,'stackable','paper','none',-1,1800,0,'true','true','true','true','sb_sleep1','none'),
(1395,'Spellbook: Surrender to Water','false','spellbook',120,'stackable','paper','none',-1,1250,0,'true','true','true','true','__sb_surrender_to_water1','none'),
(1396,'Spellbook: Surrender to Wind','false','spellbook',120,'stackable','paper','none',-1,1250,0,'true','true','true','true','__sb_surrender_to_wind1','none'),
(1397,'Spellbook: Peace','false','spellbook',120,'stackable','paper','none',-1,2450,0,'true','true','true','true','sb_erase_hostility1','none'),
(1398,'Spellbook: Focus','false','spellbook',120,'stackable','paper','none',-1,1250,0,'true','true','true','true','sb_focus1','none'),
(1399,'Spellbook: Concentration','false','spellbook',120,'stackable','paper','none',-1,800,0,'true','true','true','true','sb_concentration1','none'),
(1400,'Spellbook: Surrender To Fire','false','spellbook',120,'stackable','paper','none',-1,1250,0,'true','true','true','true','sb_surrender_to_fire1','none'),
(1401,'Spellbook: Acumen','false','spellbook',120,'stackable','paper','none',-1,800,0,'true','true','true','true','sb_arcane_acumen1','none'),
(1402,'Spellbook: Agility','false','spellbook',120,'stackable','paper','none',-1,1250,0,'true','true','true','true','sb_agility1','none'),
(1403,'Spellbook: Summon Kat the Cat','false','spellbook',120,'stackable','paper','none',-1,800,0,'true','true','true','true','sb_summon_blackcat1','none'),
(1404,'Spellbook: Servitor Recharge','false','spellbook',120,'stackable','paper','none',-1,1250,0,'true','true','true','true','sb_servitor_mana_charge1','none'),
(1405,'Spellbook: Servitor Heal','false','spellbook',120,'stackable','paper','none',-1,800,0,'true','true','true','true','sb_servitor_heal1','none'),
(1406,'Spellbook: Servitor Wind Walk','false','spellbook',120,'stackable','paper','none',-1,2450,0,'true','true','true','true','sb_fast_servitor1','none'),
(1407,'Spellbook: Servitor Magic Boost','false','spellbook',120,'stackable','paper','none',-1,2450,0,'true','true','true','true','sb_bright_servitor1','none'),
(1408,'Spellbook: Mighty Servitor','false','spellbook',120,'stackable','paper','none',-1,2450,0,'true','true','true','true','sb_mighty_servitor1','none'),
(1409,'Spellbook: Slow','false','spellbook',120,'stackable','paper','none',-1,2450,0,'true','true','true','true','sb_slow1','none'),
(1410,'Spellbook: Poisonous Cloud','false','spellbook',120,'stackable','paper','none',-1,1250,0,'true','true','true','true','sb_poison_cloud1','none'),
(1411,'Spellbook: Aura Burn','false','spellbook',120,'stackable','paper','none',-1,800,0,'true','true','true','true','sb_aura_burn1','none'),
(1412,'Spellbook: Resist Aqua','false','spellbook',120,'stackable','paper','none',-1,2450,0,'true','true','true','true','sb_auqa_resist1','none'),
(1413,'Spellbook: Resist Wind','false','spellbook',120,'stackable','paper','none',-1,2450,0,'true','true','true','true','sb_wind_resist1','none'),
(1414,'Spellbook: Resist Fire','false','spellbook',120,'stackable','paper','none',-1,1800,0,'true','true','true','true','sb_fire_resist1','none'),
(1415,'Spellbook: Dryad Root','false','spellbook',120,'stackable','paper','none',-1,1250,0,'true','true','true','true','sb_dryad_root1','none'),
(1416,'Spellbook: Curse of Chaos','false','spellbook',120,'stackable','paper','none',-1,2450,0,'true','true','true','true','sb_curse_bleary1','none'),
(1417,'Spellbook: Surrender To Earth','false','spellbook',120,'stackable','paper','none',-1,1250,0,'true','true','true','true','sb_surrender_to_earth1','none'),
(1418,'Spellbook: Surrender To Poison','false','spellbook',120,'stackable','paper','none',-1,1250,0,'true','true','true','true','sb_surrender_to_poison1','none'),
(1419,'Blood Mark','false','none',0,'stackable','liquid','none',-1,0,0,'true','true','true','true','proof_of_blood','none'),
(1420,'Ingredient List','false','quest',0,'stackable','steel','none',-1,0,0,'false','false','true','false','ingredient_list','none'),
(1421,'Sonia\'s Botany Book','false','quest',0,'stackable','steel','none',-1,0,0,'false','false','true','false','sonias_botanybook','none'),
(1422,'Red Mandragora Root','false','quest',0,'stackable','steel','none',-1,0,0,'false','false','true','false','red_mandragora_root','none'),
(1423,'White Mandragora Root','false','quest',0,'stackable','steel','none',-1,0,0,'false','false','true','false','white_mandragora_root','none'),
(1424,'Red Mandragora Sap','false','quest',0,'stackable','steel','none',-1,0,0,'false','false','true','false','red_mandragora_sap','none'),
(1425,'White Mandragora Sap','false','quest',0,'stackable','steel','none',-1,0,0,'false','false','true','false','white_mandragora_sap','none'),
(1426,'Jacob\'s Insect Book','false','quest',0,'stackable','steel','none',-1,0,0,'false','false','true','false','jaycubs_insectbook','none'),
(1427,'Nectar','false','quest',0,'stackable','steel','none',-1,0,0,'false','false','true','false','nectar','none'),
(1428,'Royal Jelly','false','quest',0,'stackable','steel','none',-1,0,0,'false','false','true','false','royal_jelly','none'),
(1429,'Honey','false','quest',0,'stackable','steel','none',-1,0,0,'false','false','true','false','honey','none'),
(1430,'Golden Honey','false','quest',0,'stackable','steel','none',-1,0,0,'false','false','true','false','golden_honey','none'),
(1431,'Pano\'s Contract','false','quest',0,'stackable','steel','none',-1,0,0,'false','false','true','false','panos_contract','none'),
(1432,'Hobgoblin Amulet','false','quest',0,'stackable','steel','none',-1,0,0,'false','false','true','false','hobgoblin_amulet','none'),
(1433,'Dionian Potato','false','quest',0,'stackable','steel','none',-1,0,0,'false','false','true','false','dionian_potato','none'),
(1434,'Glyvka\'s Botany Book','false','quest',0,'stackable','steel','none',-1,0,0,'false','false','true','false','glyvkas_botanybook','none'),
(1435,'Green Marsh Moss','false','quest',0,'stackable','steel','none',-1,0,0,'false','false','true','false','green_marsh_moss','none'),
(1436,'Brown Marsh Moss','false','quest',0,'stackable','steel','none',-1,0,0,'false','false','true','false','brown_marsh_moss','none'),
(1437,'Green Moss Bundle','false','quest',0,'stackable','steel','none',-1,0,0,'false','false','true','false','green_moss_bundle','none'),
(1438,'Brown Moss Bundle','false','quest',0,'stackable','steel','none',-1,0,0,'false','false','true','false','brown_moss_bundle','none'),
(1439,'Rollant\'s Creature Book','false','quest',0,'stackable','steel','none',-1,0,0,'false','false','true','false','rolants_creaturebook','none'),
(1440,'Body of Monster Eye','false','quest',0,'stackable','steel','none',-1,0,0,'false','false','true','false','monster_eye_body','none'),
(1441,'Meat of Monster Eye','false','quest',0,'stackable','steel','none',-1,0,0,'false','false','true','false','monster_eye_meat','none'),
(1442,'Jonas\'s 1st Steak Dish','false','quest',0,'stackable','steel','none',-1,0,0,'false','false','true','false','jonas_steak_dish1','none'),
(1443,'Jonas\'s 2nd Steak Dish','false','quest',0,'stackable','steel','none',-1,0,0,'false','false','true','false','jonas_steak_dish2','none'),
(1444,'Jonas\'s 3rd Steak Dish','false','quest',0,'stackable','steel','none',-1,0,0,'false','false','true','false','jonas_steak_dish3','none'),
(1445,'Jonas\'s 4th Steak Dish','false','quest',0,'stackable','steel','none',-1,0,0,'false','false','true','false','jonas_steak_dish4','none'),
(1446,'Jonas\'s 5th Steak Dish','false','quest',0,'stackable','steel','none',-1,0,0,'false','false','true','false','jonas_steak_dish5','none'),
(1447,'Mirien\'s Review','false','quest',0,'stackable','steel','none',-1,0,0,'false','false','true','false','miriens_review1','none'),
(1448,'Mirien\'s Review','false','quest',0,'stackable','steel','none',-1,0,0,'false','false','true','false','miriens_review2','none'),
(1449,'Mirien\'s Review','false','quest',0,'stackable','steel','none',-1,0,0,'false','false','true','false','miriens_review3','none'),
(1450,'Mirien\'s Review','false','quest',0,'stackable','steel','none',-1,0,0,'false','false','true','false','miriens_review4','none'),
(1451,'Mirien\'s Review','false','quest',0,'stackable','steel','none',-1,0,0,'false','false','true','false','miriens_review5','none'),
(1452,'Harpy Feather','false','quest',0,'stackable','steel','none',-1,0,0,'false','false','true','false','harpy_feather','none'),
(1453,'Medusa Venom','false','quest',0,'stackable','steel','none',-1,0,0,'false','false','true','false','medusa_venom','none'),
(1454,'Wyrm\'s Tooth','false','quest',0,'stackable','steel','none',-1,0,0,'false','false','true','false','wyrms_tooth','none'),
(1455,'Jonas\'s Salad Recipe','false','quest',0,'stackable','paper','none',-1,9000,0,'false','false','true','false','jonas_salad_recipe','none'),
(1456,'Jonas\'s Sauce Recipe','false','quest',0,'stackable','paper','none',-1,11250,0,'false','false','true','false','jonas_sauce_recipe','none'),
(1457,'Jonas\'s Steak Recipe','false','quest',0,'stackable','paper','none',-1,13500,0,'false','false','true','false','jonas_steak_recipe','none'),
(1458,'Crystal: D-Grade','false','none',0,'stackable','paper','d',-1,650,0,'true','true','true','true','crystal_d','none'),
(1459,'Crystal: C-Grade','false','none',0,'stackable','paper','c',-1,3000,0,'true','true','true','true','crystal_c','none'),
(1460,'Crystal: B-Grade','false','none',0,'stackable','paper','b',-1,9000,0,'true','true','true','true','crystal_b','none'),
(1461,'Crystal: A-Grade','false','none',0,'stackable','paper','a',-1,15000,0,'true','true','true','true','crystal_a','none'),
(1462,'Crystal: S Grade','false','none',0,'stackable','paper','s',-1,25000,0,'true','true','true','true','crystal_s','none'),
(1463,'Soulshot: D-grade','false','shot',3,'stackable','paper','d',-1,10,0,'true','true','true','true','Soulshot: D-Grade','none'),
(1464,'Soulshot: C-grade','false','shot',3,'stackable','paper','c',-1,15,0,'true','true','true','true','Soulshot: C-Grade','none'),
(1465,'Soulshot: B-grade','false','shot',2,'stackable','paper','b',-1,50,0,'true','true','true','true','Soulshot: B-Grade','none'),
(1466,'Soulshot: A-grade','false','shot',2,'stackable','paper','a',-1,80,0,'true','true','true','true','Soulshot: A-Grade','none'),
(1467,'Soulshot: S-grade','false','shot',2,'stackable','paper','s',-1,100,0,'true','true','true','true','Soulshot: S-Grade','none'),
(1468,'Gludin Panacen','false','quest',0,'stackable','paper','s',-1,0,0,'true','true','true','true','gludin_panacen','none'),
(1469,'Gludin Vermouth','false','quest',0,'stackable','paper','s',-1,0,0,'true','true','true','true','gludin_vermouth','none'),
(1470,'Artemeter','false','quest',0,'stackable','paper','s',-1,0,0,'true','true','true','true','artemeter','none'),
(1473,'Kasha Wolf Fang','false','quest',0,'stackable','steel','none',-1,0,0,'false','false','true','false','kasha_wolf_fang','none'),
(1474,'Grave Robber\'s Head','false','quest',0,'stackable','steel','none',-1,0,0,'false','false','true','false','grave_robbers_head','none'),
(1475,'Black Soulstone','false','quest',0,'stackable','steel','none',-1,0,0,'false','false','true','false','black_soulstone','none'),
(1476,'Red Soulstone','false','quest',0,'stackable','steel','none',-1,0,0,'false','false','true','false','red_soulstone','none'),
(1477,'Maraku Werewolf Head','false','quest',0,'stackable','steel','none',-1,0,0,'false','false','true','false','maraku_werewolf_head','none'),
(1478,'Darkwing Bat Fang','false','quest',0,'stackable','steel','none',-1,0,0,'false','false','true','false','darkwing_bat_fang','none'),
(1479,'Varangka\'s Parasite','false','quest',0,'stackable','steel','none',-1,0,0,'false','false','true','false','varangkas_parasite','none'),
(1480,'Kasha Parasite','false','quest',0,'stackable','steel','none',-1,0,0,'false','false','true','false','kasha_parasite','none'),
(1481,'Kasha Crystal','false','quest',0,'stackable','steel','none',-1,0,0,'false','false','true','false','kasha_crystal','none'),
(1482,'Black Wolf Pelt','false','quest',0,'stackable','steel','none',-1,0,0,'false','false','true','false','black_wolf_pelt','none'),
(1483,'Goblin Necklace','false','quest',0,'stackable','steel','none',-1,0,0,'false','false','true','false','goblin_necklace','none'),
(1484,'Goblin Pendant','false','quest',0,'stackable','steel','none',-1,0,0,'false','false','true','false','goblin_pendant','none'),
(1485,'Goblin Lord Pendant','false','quest',0,'stackable','steel','none',-1,0,0,'false','false','true','false','goblin_lord_pendant','none'),
(1486,'Suspicious Memo','false','quest',0,'stackable','steel','none',-1,0,0,'false','false','true','false','suspicious_memo','none'),
(1487,'Suspicious Contract','false','quest',0,'stackable','steel','none',-1,0,0,'false','false','true','false','suspicious_contract','none'),
(1488,'Chrysolite Ore','false','quest',0,'stackable','steel','none',-1,0,0,'false','false','true','false','oriharukon_ore_1','none'),
(1489,'Torn Map Fragment','false','quest',0,'stackable','steel','none',-1,0,0,'false','false','true','false','torn_map_fragment','none'),
(1490,'Hidden Ore Map','false','quest',0,'stackable','steel','none',-1,0,0,'false','false','true','false','hidden_vein_map','none'),
(1491,'Bat Fang','false','quest',0,'stackable','steel','none',-1,0,0,'false','false','true','false','bat_fang','none'),
(1492,'Floating Stone','false','quest',0,'stackable','steel','none',-1,0,0,'false','false','true','false','floating_stone','none'),
(1493,'Tarantula Spider Silk','false','quest',0,'stackable','steel','none',-1,0,0,'false','false','true','false','tarantula_spider_silk','none'),
(1494,'Tarantula Spinnerette','false','quest',0,'stackable','steel','none',-1,0,0,'false','false','true','false','tarantula_spinnerette','none'),
(1495,'Giant Spider Skin','false','quest',0,'stackable','steel','none',-1,0,0,'false','false','true','false','giant_spider_skin','none'),
(1496,'Voucher of Flame','false','quest',0,'stackable','steel','none',-1,0,0,'false','false','true','false','voucher_of_flame','none'),
(1497,'Necklace of Flame','false','quest',0,'stackable','steel','none',-1,0,0,'false','false','true','false','neckless_of_flame','none'),
(1498,'License of Miner','false','quest',0,'stackable','steel','none',-1,0,0,'false','false','true','false','license_of_miner','none'),
(1499,'Laferon\'s Recommendation','false','quest',0,'stackable','steel','none',-1,0,0,'false','false','true','false','laferons_recommend','none'),
(1500,'Totem of Hestui','false','none',10,'stackable','liquid','none',-1,11000,0,'true','true','true','true','hestuis_totem','none'),
(1501,'Maraku Werewolf Totem','false','none',10,'stackable','liquid','none',-1,1200,0,'true','true','true','true','maraku_wolfmen_totem','none'),
(1502,'Grandma\'s Pearl','false','none',10,'stackable','liquid','none',-1,5000,0,'true','true','true','true','grandmas_pearl','none'),
(1503,'Grandma\'s Mirror','false','none',10,'stackable','liquid','none',-1,500,0,'true','true','true','true','grandmas_mirror','none'),
(1504,'Grandma\'s Necklace','false','none',10,'stackable','liquid','none',-1,300,0,'true','true','true','true','grandmas_necklace','none'),
(1505,'Grandma\'s Hairpin','false','none',10,'stackable','liquid','none',-1,100,0,'true','true','true','true','grandmas_hairpin','none'),
(1512,'Spellbook: Confusion','false','spellbook',120,'stackable','paper','none',-1,1150,0,'true','true','true','true','sb_confusion1','none'),
(1513,'Spellbook: Charm','false','spellbook',120,'stackable','paper','none',-1,800,0,'true','true','true','true','sb_charm11','none'),
(1514,'Spellbook: Resurrection','false','spellbook',120,'stackable','paper','none',-1,800,0,'true','true','true','true','sb_resurrection1','none'),
(1515,'Spellbook: Kiss of Eva','false','spellbook',120,'stackable','paper','none',-1,800,0,'true','true','true','true','sb_water_breathing','none'),
(1516,'Spellbook: Corpse Life Drain','false','spellbook',120,'stackable','paper','none',-1,1800,0,'true','true','true','true','sb_corpse_life_drain1','none'),
(1517,'Spellbook: Body To Mind','false','spellbook',120,'stackable','paper','none',-1,1250,0,'true','true','true','true','sb_body_to_mind1','none'),
(1518,'Amulet: Flame Chant','false','spellbook',120,'stackable','paper','none',-1,1800,0,'true','true','true','true','sb_pure_inspiration1','none'),
(1519,'Amulet: Pa''agrio\'s Gift','false','spellbook',120,'stackable','paper','none',-1,1800,0,'true','true','true','true','sb_power_of_paagrio1','none'),
(1520,'Amulet: Pa''agrio\'s Blessing','false','spellbook',120,'stackable','paper','none',-1,2450,0,'true','true','true','true','sb_blessing_of_paagrio1','none'),
(1521,'Amulet: Chant of Fire','false','spellbook',120,'stackable','paper','none',-1,800,0,'true','true','true','true','sb_burning_spirit1','none'),
(1522,'Amulet: Chant of Battle','false','spellbook',120,'stackable','paper','none',-1,500,0,'true','true','true','true','sb_mass_frenzy1','none'),
(1523,'Amulet: Chant of Shielding','false','spellbook',120,'stackable','paper','none',-1,800,0,'true','true','true','true','sb_devotioin_of_soul1','none'),
(1524,'Amulet: Soul Shield','false','spellbook',120,'stackable','paper','none',-1,100,0,'true','true','true','true','sb_devotioin_of_shine1','none'),
(1525,'Amulet: Life Drain','false','spellbook',120,'stackable','paper','none',-1,100,0,'true','true','true','true','sb_blood_lust1','none'),
(1526,'Amulet: Fear','false','spellbook',120,'stackable','paper','none',-1,500,0,'true','true','true','true','sb_external_fear1','none'),
(1527,'Amulet: Venom','false','spellbook',120,'stackable','paper','none',-1,100,0,'true','true','true','true','sb_pain_thorn1','none'),
(1528,'Amulet: Seal of Chaos','false','spellbook',120,'stackable','paper','none',-1,1800,0,'true','true','true','true','sb_engrave_seal_of_timid1','none'),
(1529,'Amulet: Dreaming Spirit','false','spellbook',120,'stackable','paper','none',-1,100,0,'true','true','true','true','sb_night_murmur1','none'),
(1530,'Amulet: Seal of Slow','false','spellbook',120,'stackable','paper','none',-1,2450,0,'true','true','true','true','sb_engrave_seal_of_lazy1','none'),
(1531,'Amulet: Chill Flame','false','spellbook',120,'stackable','paper','none',-1,100,0,'true','true','true','true','sb_chill_flame1','none'),
(1532,'Amulet: Blaze Quake','false','spellbook',120,'stackable','paper','none',-1,1250,0,'true','true','true','true','sb_eternal_flame1','none'),
(1533,'Amulet: Aura Sink','false','spellbook',120,'stackable','paper','none',-1,1250,0,'true','true','true','true','sb_aura_sway1','none'),
(1534,'Amulet: Madness','false','spellbook',120,'stackable','paper','none',-1,800,0,'true','true','true','true','sb_entice_madness1','none'),
(1535,'Amulet: Frost Flame','false','spellbook',120,'stackable','paper','none',-1,800,0,'true','true','true','true','sb_blaze_quake1','none'),
(1536,'Amulet: Seal of Binding','false','spellbook',120,'stackable','paper','none',-1,1250,0,'true','true','true','true','sb_bind_will1','none'),
(1537,'Amulet: Seal of Poison','false','spellbook',120,'stackable','paper','none',-1,800,0,'true','true','true','true','sb_pain_edge1','none'),
(1538,'Blessed Scroll of Escape','false','scroll',120,'stackable','paper','none',-1,150000,0,'true','true','true','true','blessed_scroll_of_escape','scroll'),
(1539,'Greater Healing Potion','false','potion',5,'stackable','liquid','none',-1,1080,0,'true','true','true','true','greater_healing_potion','potion'),
(1540,'Quick Healing Potion','false','potion',180,'stackable','liquid','none',-1,10000,0,'true','true','true','true','quick_healing_potion','potion'),
(1541,'Honey Khandar','false','quest',0,'stackable','steel','none',-1,0,0,'false','false','true','false','honey_khandar','none'),
(1542,'Bear Fur Cloak','false','quest',0,'stackable','steel','none',-1,0,0,'false','false','true','false','bear_fur_cloak','none'),
(1543,'Bloody Axe','false','quest',0,'stackable','steel','none',-1,0,0,'false','false','true','false','bloody_axe','none'),
(1544,'Ancestor Skull','false','quest',0,'stackable','steel','none',-1,0,0,'false','false','true','false','ancestor_skull','none'),
(1545,'Spider Dust','false','quest',0,'stackable','steel','none',-1,0,0,'false','false','true','false','spider_dust','none'),
(1546,'Deep Sea Orb','false','quest',0,'stackable','steel','none',-1,0,0,'false','false','true','false','deep_sea_orb','none'),
(1547,'Bolter\'s List','false','quest',0,'stackable','steel','none',-1,0,0,'false','false','true','false','bolters_list','none'),
(1548,'Mining Boots','false','quest',0,'stackable','steel','none',-1,0,0,'false','false','true','false','mining_boots','none'),
(1549,'Miner\'s Pick','false','quest',0,'stackable','steel','none',-1,0,0,'false','false','true','false','miners_pick','none'),
(1550,'Boomboom Powder','false','quest',0,'stackable','steel','none',-1,0,0,'false','false','true','false','boomboom_powder','none'),
(1551,'Redstone Beer','false','quest',0,'stackable','steel','none',-1,0,0,'false','false','true','false','redstone_beer','none'),
(1552,'Bolter\'s Smelly Socks','false','quest',0,'stackable','steel','none',-1,0,0,'false','false','true','false','bolters_smelly_socks','none'),
(1553,'Hatos\'s 1st Order','false','quest',0,'stackable','steel','none',-1,0,0,'false','false','true','false','hatoss_order1','none'),
(1554,'Hatos\'s 2nd Order','false','quest',0,'stackable','steel','none',-1,0,0,'false','false','true','false','hatoss_order2','none'),
(1555,'Hatos\'s 3rd Order','false','quest',0,'stackable','steel','none',-1,0,0,'false','false','true','false','hatoss_order3','none'),
(1556,'Letter to Dark Elf','false','quest',0,'stackable','steel','none',-1,0,0,'false','false','true','false','letter_to_darkelf1','none'),
(1557,'Letter to Human','false','quest',0,'stackable','steel','none',-1,0,0,'false','false','true','false','letter_to_human','none'),
(1558,'Letter to Elf','false','quest',0,'stackable','steel','none',-1,0,0,'false','false','true','false','letter_to_elf1','none'),
(1559,'Gouph\'s Contract','false','quest',0,'stackable','steel','none',-1,0,0,'false','false','true','false','gouphs_contract','none'),
(1560,'Reep\'s Contract','false','quest',0,'stackable','steel','none',-1,0,0,'false','false','true','false','reeps_contract','none'),
(1561,'Elven Wine','false','quest',0,'stackable','steel','none',-1,0,0,'false','false','true','false','elven_wine','none'),
(1562,'Brunon\'s Dice','false','quest',0,'stackable','steel','none',-1,0,0,'false','false','true','false','bronps_dice','none'),
(1563,'Brunon\'s Contract','false','quest',0,'stackable','steel','none',-1,0,0,'false','false','true','false','bronps_contract','none'),
(1564,'Aquamarine','false','quest',0,'stackable','steel','none',-1,0,0,'false','false','true','false','aquamarine','none'),
(1565,'Chrysoberyl','false','quest',0,'stackable','steel','none',-1,0,0,'false','false','true','false','chrysoberyl','none'),
(1566,'Gem Box','false','quest',0,'stackable','steel','none',-1,0,0,'false','false','true','false','gem_box1','none'),
(1567,'Coal Piece','false','quest',0,'stackable','steel','none',-1,0,0,'false','false','true','false','coal_piece','none'),
(1568,'Brunon\'s Letter','false','quest',0,'stackable','steel','none',-1,0,0,'false','false','true','false','bronps_letter','none'),
(1569,'Berry Tart','false','quest',0,'stackable','steel','none',-1,0,0,'false','false','true','false','berry_tart','none'),
(1570,'Bat Diagram','false','quest',0,'stackable','steel','none',-1,0,0,'false','false','true','false','bat_diagram','none'),
(1571,'Star Diamond','false','quest',0,'stackable','steel','none',-1,0,0,'false','false','true','false','star_diamond','none'),
(1572,'Starstone','false','quest',0,'stackable','steel','none',-1,0,0,'false','false','true','false','starstone1','none'),
(1573,'Starstone','false','quest',0,'stackable','steel','none',-1,0,0,'false','false','true','false','starstone2','none'),
(1574,'Mirien\'s Review','false','quest',0,'stackable','steel','none',-1,0,0,'false','false','true','false','miriens_review2','none'),
(1575,'Mirien\'s Review','false','quest',0,'stackable','steel','none',-1,0,0,'false','false','true','false','miriens_review3','none'),
(1576,'Mirien\'s Review','false','quest',0,'stackable','steel','none',-1,0,0,'false','false','true','false','miriens_review4','none'),
(1577,'Mirien\'s Review','false','quest',0,'stackable','steel','none',-1,0,0,'false','false','true','false','miriens_review5','none'),
(1578,'Green Blood','false','quest',0,'stackable','steel','none',-1,0,0,'false','false','true','false','green_blood','none'),
(1579,'Goblin Dwelling Map','false','quest',0,'stackable','steel','none',-1,0,0,'false','false','true','false','goblin_dwelling_map','none'),
(1580,'Kuruka Ratman Tooth','false','quest',0,'stackable','steel','none',-1,0,0,'false','false','true','false','kuruka_ratman_tooth','none'),
(1581,'Betrayer\'s Report','false','quest',0,'stackable','steel','none',-1,0,0,'false','false','true','false','betrayer_sue_report','none'),
(1582,'Betrayer\'s Report','false','quest',0,'stackable','steel','none',-1,0,0,'false','false','true','false','betrayer_wanuk_report','none'),
(1583,'Betrayer\'s Report','false','quest',0,'stackable','steel','none',-1,0,0,'false','false','true','false','betrayer_chewba_report','none'),
(1584,'Betrayer\'s Report','false','quest',0,'stackable','steel','none',-1,0,0,'false','false','true','false','betrayer_heitafu_report','none'),
(1585,'Betrayer\'s Report','false','quest',0,'stackable','steel','none',-1,0,0,'false','false','true','false','betrayer_picubo_report','none'),
(1586,'Betrayer\'s Report','false','quest',0,'stackable','steel','none',-1,0,0,'false','false','true','false','betrayer_bumbum_report','none'),
(1587,'Betrayer\'s Report','false','quest',0,'stackable','steel','none',-1,0,0,'false','false','true','false','betrayer_minsku_report','none'),
(1588,'Betrayer\'s Report','false','quest',0,'stackable','steel','none',-1,0,0,'false','false','true','false','betrayer_chuchu_report','none'),
(1589,'Betrayer\'s Report','false','quest',0,'stackable','steel','none',-1,0,0,'false','false','true','false','betrayer_umbar_report','none'),
(1590,'Betrayer\'s Report','false','quest',0,'stackable','steel','none',-1,0,0,'false','false','true','false','betrayer_zakan_report','none'),
(1591,'Head of Betrayer','false','quest',0,'stackable','steel','none',-1,0,0,'false','false','true','false','head_of_betrayer','none'),
(1592,'Mark of Raider','false','quest',0,'stackable','steel','none',-1,0,0,'false','false','true','false','mark_of_raider','none'),
(1593,'Pomegranate','false','quest',0,'stackable','steel','none',-1,0,0,'false','false','true','false','pomegranate','none'),
(1594,'1st Leather Pouch','false','quest',0,'stackable','steel','none',-1,0,0,'false','false','true','false','leather_pouch1','none'),
(1595,'2nd Leather Pouch','false','quest',0,'stackable','steel','none',-1,0,0,'false','false','true','false','leather_pouch2','none'),
(1596,'3rd Leather Pouch','false','quest',0,'stackable','steel','none',-1,0,0,'false','false','true','false','leather_pouch3','none'),
(1597,'1st Leather Pouch (Full)','false','quest',0,'stackable','steel','none',-1,0,0,'false','false','true','false','leather_pouch1full','none'),
(1598,'2nd Leather Pouch (Full)','false','quest',0,'stackable','steel','none',-1,0,0,'false','false','true','false','leather_pouch2full','none'),
(1599,'3rd Leather Pouch (Full)','false','quest',0,'stackable','steel','none',-1,0,0,'false','false','true','false','leather_pouch3full','none'),
(1600,'Kasha Bear Claw','false','quest',0,'stackable','steel','none',-1,0,0,'false','false','true','false','kasha_bear_claw','none'),
(1601,'Kasha Blade Spider Talon','false','quest',0,'stackable','steel','none',-1,0,0,'false','false','true','false','kasha_bspider_talon','none'),
(1602,'Scarlet Salamander Scale','false','quest',0,'stackable','steel','none',-1,0,0,'false','false','true','false','s_salamander_scale','none'),
(1603,'Fiery Spirit Scroll','false','quest',0,'stackable','steel','none',-1,0,0,'false','false','true','false','scroll_fiery_spirit','none'),
(1604,'Rosheek\'s Letter','false','quest',0,'stackable','steel','none',-1,0,0,'false','false','true','false','rosheeks_letter','none'),
(1605,'Gantaki\'s Letter of Recommendation','false','quest',0,'stackable','steel','none',-1,0,0,'false','false','true','false','gantakis_letter','none'),
(1606,'Fig','false','quest',0,'stackable','steel','none',-1,0,0,'false','false','true','false','fig','none'),
(1607,'4th Leather Pouch','false','quest',0,'stackable','steel','none',-1,0,0,'false','false','true','false','leather_purse4','none'),
(1608,'4th Leather Pouch (Full)','false','quest',0,'stackable','steel','none',-1,0,0,'false','false','true','false','leather_pouch4full','none'),
(1609,'Vuku Orc Tusk','false','quest',0,'stackable','steel','none',-1,0,0,'false','false','true','false','vuku_tusk','none'),
(1610,'Ratman Fang','false','quest',0,'stackable','steel','none',-1,0,0,'false','false','true','false','ratman_fang','none'),
(1611,'Langk Lizardman Tooth','false','quest',0,'stackable','steel','none',-1,0,0,'false','false','true','false','langk_tooth','none'),
(1612,'Felim Lizardman Tooth','false','quest',0,'stackable','steel','none',-1,0,0,'false','false','true','false','felim_tooth','none'),
(1613,'Iron Will Scroll','false','quest',0,'stackable','steel','none',-1,0,0,'false','false','true','false','scroll_iron_will','none'),
(1614,'Toruku\'s Letter','false','quest',0,'stackable','steel','none',-1,0,0,'false','false','true','false','torukus_letter','none'),
(1615,'Khavatari Totem','false','quest',0,'stackable','steel','none',-1,0,0,'false','false','true','false','khavatari_totem','none'),
(1616,'Fire Charm','false','quest',0,'stackable','steel','none',-1,0,0,'false','false','true','false','fire_charm','none'),
(1617,'Kasha Bear Pelt','false','quest',0,'stackable','steel','none',-1,0,0,'false','false','true','false','kasha_bear_pelt','none'),
(1618,'Kasha Blade Spider Husk','false','quest',0,'stackable','steel','none',-1,0,0,'false','false','true','false','kasha_bspider_husk','none'),
(1619,'1st Fiery Egg','false','quest',0,'stackable','steel','none',-1,0,0,'false','false','true','false','fiery_egg1','none'),
(1620,'Hestui Mask','false','quest',0,'stackable','steel','none',-1,0,0,'false','false','true','false','hestui_mask','none'),
(1621,'2nd Fiery Egg','false','quest',0,'stackable','steel','none',-1,0,0,'false','false','true','false','fiery_egg2','none'),
(1622,'Totem Spirit Claw','false','quest',0,'stackable','steel','none',-1,0,0,'false','false','true','false','totem_spirit_claw','none'),
(1623,'Tataru\'s Letter of Recommendation','false','quest',0,'stackable','steel','none',-1,0,0,'false','false','true','false','tatarus_letter','none'),
(1624,'Flame Charm','false','quest',0,'stackable','steel','none',-1,0,0,'false','false','true','false','flame_charm','none'),
(1625,'Grizzly Blood','false','quest',0,'stackable','steel','none',-1,0,0,'false','false','true','false','grizzly_blood','none'),
(1626,'Blood Cauldron','false','quest',0,'stackable','steel','none',-1,0,0,'false','false','true','false','blood_cauldron','none'),
(1627,'Spirit Net','false','quest',0,'stackable','steel','none',-1,0,0,'false','false','true','false','spirit_net','none'),
(1628,'Bound Durka Spirit','false','quest',0,'stackable','steel','none',-1,0,0,'false','false','true','false','bound_durka_spirit','none'),
(1629,'Durka Parasite','false','quest',0,'stackable','steel','none',-1,0,0,'false','false','true','false','durka_parasite','none'),
(1630,'Totem Spirit Blood','false','quest',0,'stackable','steel','none',-1,0,0,'false','false','true','false','totem_spirit_blood','none'),
(1631,'Mask of Medium','false','quest',0,'stackable','steel','none',-1,0,0,'false','false','true','false','mask_of_medium','none'),
(1632,'Silvera\'s Ring','false','quest',0,'stackable','steel','none',-1,0,0,'false','false','true','false','silverys_ring','none'),
(1633,'1st Pass Certificate','false','quest',0,'stackable','steel','none',-1,0,0,'false','false','true','false','pass_1st','none'),
(1634,'2nd Pass Certificate','false','quest',0,'stackable','steel','none',-1,0,0,'false','false','true','false','pass_2nd','none'),
(1635,'Final Pass Certificate','false','quest',0,'stackable','steel','none',-1,0,0,'false','false','true','false','pass_final','none'),
(1636,'Boogle Ratman Tooth','false','quest',0,'stackable','steel','none',-1,0,0,'false','false','true','false','ratman_tooth','none'),
(1637,'Boogle Ratman Leader\'s Tooth','false','quest',0,'stackable','steel','none',-1,0,0,'false','false','true','false','big_ratman_tooth','none'),
(1638,'Kluto\'s Letter','false','quest',0,'stackable','steel','none',-1,0,0,'false','false','true','false','klutos_letter','none'),
(1639,'Footprint of Thief','false','quest',0,'stackable','steel','none',-1,0,0,'false','false','true','false','footprint','none'),
(1640,'Stolen Secret Box','false','quest',0,'stackable','steel','none',-1,0,0,'false','false','true','false','secret_box1','none'),
(1641,'Secret Box','false','quest',0,'stackable','steel','none',-1,0,0,'false','false','true','false','secret_box2','none'),
(1642,'Ring of Raven','false','quest',0,'stackable','steel','none',-1,0,0,'false','false','true','false','ring_of_raven','none'),
(1643,'Pippi\'s Letter of Recommendation','false','quest',0,'stackable','steel','none',-1,0,0,'false','false','true','false','pipis_letter','none'),
(1644,'Raut\'s Teleport Scroll','false','quest',0,'stackable','steel','none',-1,0,0,'false','false','true','false','routs_tp_scroll','none'),
(1645,'Succubus Undies','false','quest',0,'stackable','steel','none',-1,0,0,'false','false','true','false','succubus_undies','none'),
(1646,'Mion\'s Letter','false','quest',0,'stackable','steel','none',-1,0,0,'false','false','true','false','mions_letter','none'),
(1647,'Bronk\'s Ingot','false','quest',0,'stackable','steel','none',-1,0,0,'false','false','true','false','bronks_ingot','none'),
(1648,'Shari\'s Axe','false','quest',0,'stackable','steel','none',-1,0,0,'false','false','true','false','chalis_axe','none'),
(1649,'Zimenf\'s Potion','false','quest',0,'stackable','steel','none',-1,0,0,'false','false','true','false','zimenfs_potion','none'),
(1650,'Bronk\'s Pay','false','quest',0,'stackable','steel','none',-1,0,0,'false','false','true','false','bronks_pay','none'),
(1651,'Shari\'s Pay','false','quest',0,'stackable','steel','none',-1,0,0,'false','false','true','false','chalis_pay','none'),
(1652,'Zimenf\'s Pay','false','quest',0,'stackable','steel','none',-1,0,0,'false','false','true','false','zimenfs_pay','none'),
(1653,'Bear Picture','false','quest',0,'stackable','steel','none',-1,0,0,'false','false','true','false','bear_pic','none'),
(1654,'Tarantula Picture','false','quest',0,'stackable','steel','none',-1,0,0,'false','false','true','false','tarantula_pic','none'),
(1655,'Honey Jar','false','quest',0,'stackable','steel','none',-1,0,0,'false','false','true','false','honey_jar','none'),
(1656,'Bead','false','quest',0,'stackable','steel','none',-1,0,0,'false','false','true','false','bead','none'),
(1657,'Bead Parcel','false','quest',0,'stackable','steel','none',-1,0,0,'false','false','true','false','bead_parcel','none'),
(1658,'Gatekeeper Charm','false','none',10,'stackable','liquid','none',-1,0,0,'true','true','true','true','gatekeeper_charm','none'),
(1659,'Gatekeeper Token','false','none',10,'stackable','liquid','none',-1,0,0,'true','true','true','true','gatekeeper_token','none'),
(1661,'Thief Key','false','none',10,'stackable','liquid','none',-1,1000,0,'true','true','true','true','key_of_thief','none'),
(1662,'Wood','false','none',2,'stackable','liquid','none',-1,20,0,'true','true','true','true','__wood','none'),
(1663,'(Not used) Trunk','false','none',2,'stackable','liquid','none',-1,20,0,'true','true','true','true','__stem','none'),
(1664,'Steel Powder','false','none',2,'stackable','liquid','none',-1,80,0,'true','true','true','true','__steel_powder','none'),
(1665,'World Map','false','none',0,'normal','liquid','none',-1,500,0,'true','true','true','true','world_map','none'),
(1666,'Recipe: Wooden Arrow','false','recipe',30,'stackable','liquid','none',-1,600,0,'true','true','true','true','rp_wooden_arrow','recipe'),
(1667,'Spellbook: Summon Shadow','false','spellbook',120,'stackable','paper','none',-1,800,0,'true','true','true','true','sb_summon_shadow1','none'),
(1668,'Spellbook: Summon Mew the Cat','false','spellbook',120,'stackable','paper','none',-1,1250,0,'true','true','true','true','sb_summon_cuti_cat1','none'),
(1669,'Spellbook: Summon Boxer the Unicorn','false','spellbook',120,'stackable','paper','none',-1,800,0,'true','true','true','true','sb_summon_unicorn_boxer1','none'),
(1670,'Spellbook: Summon Mirage the Unicorn','false','spellbook',120,'stackable','paper','none',-1,1250,0,'true','true','true','true','sb_summon_unicorn_mirage1','none'),
(1671,'Spellbook: Summon Silhouette','false','spellbook',120,'stackable','paper','none',-1,800,0,'true','true','true','true','sb_summon_silhouette1','none'),
(1672,'__','false','none',40,'normal','paper','none',-1,800,0,'true','true','true','true','__1','none'),
(1673,'__','false','none',40,'normal','paper','none',-1,800,0,'true','true','true','true','__2','none'),
(1674,'Twig of Treant','false','material',2,'stackable','liquid','none',-1,80,0,'true','true','true','true','__twig_of_ent','material'),
(1675,'Beast Blood','false','material',2,'stackable','liquid','none',-1,40,0,'true','true','true','true','__beast_blood','material'),
(1676,'Beast Bone','false','material',2,'stackable','liquid','none',-1,20,0,'true','true','true','true','__beast_bone','material'),
(1677,'Hot Oil','false','material',2,'stackable','liquid','none',-1,40,0,'true','true','true','true','__hot_oil','material'),
(1678,'(Not used) Thread','false','material',2,'stackable','liquid','none',-1,10,0,'true','true','true','true','__thread','material'),
(1679,'Bronze','false','material',2,'stackable','liquid','none',-1,150,0,'true','true','true','true','__bronze','material'),
(1680,'Fur','false','material',2,'stackable','liquid','none',-1,40,0,'true','true','true','true','__fur','material'),
(1681,'Elf Stone','false','material',2,'stackable','liquid','none',-1,1500,0,'true','true','true','true','__elf_stone','material'),
(1682,'Tear of Holy Spirit','false','material',2,'stackable','liquid','none',-1,1000,0,'true','true','true','true','__tear_of_holyspirit','material'),
(1683,'Mithril','false','material',2,'stackable','liquid','none',-1,400,0,'true','true','true','true','__mythril','material'),
(1684,'Durable Stem','false','material',2,'stackable','liquid','none',-1,220,0,'true','true','true','true','__durable_stem','material'),
(1685,'Wooden Frame','false','material',2,'stackable','liquid','none',-1,2000,0,'true','true','true','true','__wooden_frame','material'),
(1686,'Bark of Treant','false','material',2,'stackable','liquid','none',-1,480,0,'true','true','true','true','__bark_of_ent','material'),
(1687,'(Not used) Coarse Bone Powder','false','material',2,'stackable','liquid','none',-1,80,0,'true','true','true','true','__rough_bone_powder','material'),
(1688,'Refined Steel','false','material',2,'stackable','liquid','none',-1,480,0,'true','true','true','true','__refined_steel','material'),
(1689,'(Not used) Leather','false','material',2,'stackable','liquid','none',-1,300,0,'true','true','true','true','__leather','material'),
(1690,'Bowstring','false','material',2,'stackable','liquid','none',-1,300,0,'true','true','true','true','__bowstring','material'),
(1691,'Steel Frame','false','material',2,'stackable','liquid','none',-1,4400,0,'true','true','true','true','__steel_frame','material'),
(1692,'(Not used) Cord','false','material',2,'stackable','liquid','none',-1,45,0,'true','true','true','true','__cord','material'),
(1693,'Refined Bronze','false','material',2,'stackable','liquid','none',-1,890,0,'true','true','true','true','__refined_bronze','material'),
(1694,'Treant Potion','false','material',2,'stackable','liquid','none',-1,800,0,'true','true','true','true','__ent_potion','material'),
(1695,'Spell Paper','false','material',2,'stackable','liquid','none',-1,580,0,'true','true','true','true','__spell_paper','material'),
(1696,'Flaming Oil','false','material',2,'stackable','liquid','none',-1,500,0,'true','true','true','true','__flaming_oil','material'),
(1697,'Magic Powder','false','material',2,'stackable','liquid','none',-1,3080,0,'true','true','true','true','__magic_powder','material'),
(1698,'Refined Mithril','false','material',2,'stackable','liquid','none',-1,2100,0,'true','true','true','true','__refined_mythril','material'),
(1699,'Fortified Steel','false','material',2,'stackable','liquid','none',-1,1860,0,'true','true','true','true','__fortified_steel','material'),
(1700,'(Not used) Oriharukon','false','material',2,'stackable','liquid','none',-1,6300,0,'true','true','true','true','__oriharukon','material'),
(1701,'Spell Solution','false','material',2,'stackable','liquid','none',-1,8160,0,'true','true','true','true','__spell_solution','material'),
(1702,'Metal Frame','false','material',2,'stackable','liquid','none',-1,12500,0,'true','true','true','true','__metal_frame','material'),
(1703,'Steel of The Highest Grade','false','material',2,'stackable','liquid','none',-1,3720,0,'true','true','true','true','__steel_of_highestgrade','material'),
(1704,'Stone of Anguish','false','material',60,'stackable','liquid','none',-1,157,0,'true','true','true','true','__stone_of_anguish','material'),
(1705,'Sprig of Wisdom','false','material',60,'stackable','liquid','none',-1,258,0,'true','true','true','true','__sprig_of_wisdom','material'),
(1706,'Blue Diamond Fragment','false','material',60,'stackable','liquid','none',-1,471,0,'true','true','true','true','__blue_diamond_fragment','material'),
(1707,'Saint\'s Molar','false','material',60,'stackable','liquid','none',-1,568,0,'true','true','true','true','__saint\'s_molar','material'),
(1708,'Smoky Quartz','false','material',60,'stackable','liquid','none',-1,1136,0,'true','true','true','true','__smoky_quartz','material'),
(1709,'Blood of Manticore','false','material',60,'stackable','liquid','none',-1,568,0,'true','true','true','true','__blood_of_manticor','material'),
(1710,'Tiger\'s Eye Crystal','false','material',60,'stackable','liquid','none',-1,3215,0,'true','true','true','true','__tiger\'seye_crystal','material'),
(1711,'Claw of Leopard','false','material',60,'stackable','liquid','none',-1,402,0,'true','true','true','true','__claw_of_leopard','material'),
(1712,'Leather Shoes Material','false','material',60,'stackable','liquid','none',-1,87,0,'true','true','true','true','__leather_shoes_material','material'),
(1713,'Leather Tunic Material','false','material',60,'stackable','liquid','none',-1,261,0,'true','true','true','true','__leather_tunic_material','material'),
(1714,'Leather Stockings Material','false','material',60,'stackable','liquid','none',-1,129,0,'true','true','true','true','__leather_hose_material','material'),
(1715,'Leather Helmet Material','false','material',60,'stackable','liquid','none',-1,240,0,'true','true','true','true','__leather_helmet_material','material'),
(1716,'Leather Gloves Texture','false','material',60,'stackable','liquid','none',-1,226,0,'true','true','true','true','__leather_gloves_texture','material'),
(1717,'Leather Gloves Lining','false','material',60,'stackable','liquid','none',-1,113,0,'true','true','true','true','__leather_gloves_lining','material'),
(1718,'Black Bone Fragment','false','material',60,'stackable','liquid','none',-1,693,0,'true','true','true','true','__black_bone_fragment','material'),
(1719,'Hard Leather Shirt Material','false','material',60,'stackable','liquid','none',-1,963,0,'true','true','true','true','__hard_leather_shirt_material','material'),
(1720,'Blue-Black Bone Fragment','false','material',60,'stackable','liquid','none',-1,1493,0,'true','true','true','true','__blue-black_bone_fragment','material'),
(1721,'Hard Leather Gaiter Material','false','material',60,'stackable','liquid','none',-1,500,0,'true','true','true','true','__hard_leather_gaiters_material','material'),
(1722,'Boots Material','false','material',60,'stackable','liquid','none',-1,271,0,'true','true','true','true','__boots_material','material'),
(1723,'Leather Boots Material','false','material',60,'stackable','liquid','none',-1,364,0,'true','true','true','true','__leather_boots_material','material'),
(1724,'Skull Fragment','false','material',60,'stackable','liquid','none',-1,512,0,'true','true','true','true','__skull_fragment','material'),
(1725,'Dark Stockings Material','false','material',60,'stackable','liquid','none',-1,632,0,'true','true','true','true','__dark_hose_material','material'),
(1726,'Crafted Leather Gloves Lining','false','material',60,'stackable','liquid','none',-1,523,0,'true','true','true','true','__excellence_leather_gloves_lining','material'),
(1727,'Crafted Leather Gloves Texture','false','material',60,'stackable','liquid','none',-1,261,0,'true','true','true','true','__excellence_leather_gloves_texture','material'),
(1728,'Steel Scale','false','material',60,'stackable','liquid','none',-1,1790,0,'true','true','true','true','__steel_scale','material'),
(1729,'Pure White Cloth','false','material',60,'stackable','liquid','none',-1,833,0,'true','true','true','true','__purewhite_cloth','material'),
(1730,'Purifying Potion','false','material',60,'stackable','liquid','none',-1,3330,0,'true','true','true','true','__purifying_potion','material'),
(1731,'Steel Scale Gaiters','false','material',60,'stackable','liquid','none',-1,1148,0,'true','true','true','true','__gaiters_steel_scale','material'),
(1732,'Leather Fittings','false','material',60,'stackable','liquid','none',-1,1520,0,'true','true','true','true','__leather_fittings','material'),
(1733,'Large Sheet Iron','false','material',60,'stackable','liquid','none',-1,1900,0,'true','true','true','true','__large_sheet_iron','material'),
(1734,'Small Leather Fittings','false','material',60,'stackable','liquid','none',-1,952,0,'true','true','true','true','__small_leather_fittings','material'),
(1735,'Small Sheet Iron','false','material',60,'stackable','liquid','none',-1,1190,0,'true','true','true','true','__small_sheet_iron','material'),
(1736,'Iron Boots Binding','false','material',60,'stackable','liquid','none',-1,635,0,'true','true','true','true','__iron_boots_binding','material'),
(1737,'Iron Boots Frame','false','material',60,'stackable','liquid','none',-1,508,0,'true','true','true','true','__iron_boots_frame','material'),
(1738,'Wide Blade','false','material',60,'stackable','liquid','none',-1,625,0,'true','true','true','true','__wide_blade','material'),
(1739,'Broadsword Mold','false','material',60,'stackable','liquid','none',-1,1250,0,'true','true','true','true','__broad_sword_mold','material'),
(1740,'Crafted Willow Branch','false','material',60,'stackable','liquid','none',-1,833,0,'true','true','true','true','__crafted_willow_branch','material'),
(1741,'Stave','false','material',60,'stackable','liquid','none',-1,900,0,'true','true','true','true','__stave','material'),
(1742,'Red Cedar Branch','false','material',60,'stackable','liquid','none',-1,1797,0,'true','true','true','true','__red_cedar_branch','material'),
(1743,'Dirk Blade','false','material',60,'stackable','liquid','none',-1,1082,0,'true','true','true','true','__dirk_blade','material'),
(1744,'Dirk Mold','false','material',60,'stackable','liquid','none',-1,5410,0,'true','true','true','true','__dirk_mold','material'),
(1745,'Brandish Blade','false','material',60,'stackable','liquid','none',-1,1880,0,'true','true','true','true','__brandish_blade','material'),
(1746,'Short Spear Blade','false','material',60,'stackable','liquid','none',-1,3000,0,'true','true','true','true','__short_spear_blade','material'),
(1747,'Shining Blade','false','material',60,'stackable','liquid','none',-1,1700,0,'true','true','true','true','__shining_blade','material'),
(1748,'Sword of Reflection Mold','false','material',60,'stackable','liquid','none',-1,13600,0,'true','true','true','true','__sword_of_reflexion_mold','material'),
(1749,'Branch of The Mother Tree','false','material',60,'stackable','liquid','none',-1,4533,0,'true','true','true','true','__branch_of_the_mothertree','material'),
(1750,'Dark Forest Leaf','false','material',60,'stackable','liquid','none',-1,2267,0,'true','true','true','true','__darkforest_leaf','material'),
(1751,'Lump of Iron','false','material',60,'stackable','liquid','none',-1,5278,0,'true','true','true','true','__lump_of_iron','material'),
(1752,'Piece of Sword Breaker','false','material',60,'stackable','liquid','none',-1,3050,0,'true','true','true','true','__piece_of_sword_breaker','material'),
(1753,'Sword Breaker Mold','false','material',60,'stackable','liquid','none',-1,24400,0,'true','true','true','true','__sword_breaker_mold','material'),
(1754,'Steel Bow Mold','false','material',60,'stackable','liquid','none',-1,4067,0,'true','true','true','true','__steel_bow_mold','material'),
(1755,'Metal Stave','false','material',60,'stackable','liquid','none',-1,8133,0,'true','true','true','true','__metal_stave','material'),
(1756,'Spirit of The Saber Smith','false','material',60,'stackable','liquid','none',-1,4544,0,'true','true','true','true','__spirit_of_the_saber_smith','material'),
(1757,'Saber Blade','false','material',60,'stackable','liquid','none',-1,5453,0,'true','true','true','true','__saber_blade','material'),
(1758,'Saber Mold','false','material',60,'stackable','liquid','none',-1,13633,0,'true','true','true','true','__saber_mold','material'),
(1759,'Blood of Assassin','false','material',60,'stackable','liquid','none',-1,4544,0,'true','true','true','true','__blood_of_the_assassin','material'),
(1760,'Assassin Blade','false','material',60,'stackable','liquid','none',-1,5453,0,'true','true','true','true','__assassin_blade','material'),
(1761,'Assassin Mold','false','material',60,'stackable','liquid','none',-1,27267,0,'true','true','true','true','__assassin_mold','material'),
(1762,'Piece of Trident','false','material',60,'stackable','liquid','none',-1,6850,0,'true','true','true','true','__piece_of_trident','material'),
(1763,'Ruby Fragment','false','material',60,'stackable','liquid','none',-1,5113,0,'true','true','true','true','__ruby_fragment','material'),
(1764,'Deep Sea Water','false','material',60,'stackable','liquid','none',-1,10225,0,'true','true','true','true','__deepsea_water','material'),
(1765,'Spinebone Fragment','false','material',60,'stackable','liquid','none',-1,6440,0,'true','true','true','true','__spinebone_fragment','material'),
(1766,'Spinebone Pattern','false','material',60,'stackable','liquid','none',-1,12880,0,'true','true','true','true','__spinebone_pattern','material'),
(1767,'Piece of Mace of Judgment','false','material',60,'stackable','liquid','none',-1,7156,0,'true','true','true','true','__piece_of_mage_of_judgement','material'),
(1768,'Pattern of Judgment','false','material',60,'stackable','liquid','none',-1,10733,0,'true','true','true','true','__pattern_of_judgement','material'),
(1769,'Piece of Conjuror\'s Staff','false','material',60,'stackable','liquid','none',-1,6440,0,'true','true','true','true','__piece_of_conjure_staff','material'),
(1770,'Magic Flute','false','material',60,'stackable','liquid','none',-1,12880,0,'true','true','true','true','__magic_flute','material'),
(1771,'Elven Stave','false','material',60,'stackable','liquid','none',-1,21467,0,'true','true','true','true','__elven_stave','material'),
(1772,'Leaf of the Mother Tree','false','material',60,'stackable','liquid','none',-1,5367,0,'true','true','true','true','__leaf_of_the_mothertree','material'),
(1773,'Piece of Dwarven Trident','false','material',60,'stackable','liquid','none',-1,8613,0,'true','true','true','true','__piece_of_dwarven_trident','material'),
(1774,'Piece of Two-Handed Sword','false','material',60,'stackable','liquid','none',-1,5688,0,'true','true','true','true','__piece_of_two-handed_sword','material'),
(1775,'Two-Handed Sword Mold','false','material',60,'stackable','liquid','none',-1,96700,0,'true','true','true','true','__two-handed_sword_mold','material'),
(1776,'Piece of Spiked Club','false','material',60,'stackable','liquid','none',-1,32233,0,'true','true','true','true','__piece_of_spike_club','material'),
(1777,'Steel Piece of Club','false','material',60,'stackable','liquid','none',-1,6447,0,'true','true','true','true','__steel_piece_of_club','material'),
(1778,'Shilen Bone','false','material',60,'stackable','liquid','none',-1,6447,0,'true','true','true','true','__bone_of_silenus','material'),
(1779,'Shilen Mane','false','material',60,'stackable','liquid','none',-1,64467,0,'true','true','true','true','__mane_of_silenus','material'),
(1780,'Purity Bronze','false','material',60,'stackable','liquid','none',-1,9210,0,'true','true','true','true','__purity_bronze','material'),
(1781,'Gastraphetes Stave','false','material',60,'stackable','liquid','none',-1,32233,0,'true','true','true','true','__gastraphetes_stave','material'),
(1782,'Gastraphetes Addendum','false','material',60,'stackable','liquid','none',-1,6447,0,'true','true','true','true','__gastraphetes_addendum','material'),
(1783,'Blood of Fiend','false','material',60,'stackable','liquid','none',-1,10744,0,'true','true','true','true','__blood_of_fiend','material'),
(1784,'Cursed Leather','false','material',60,'stackable','liquid','none',-1,10744,0,'true','true','true','true','__cursed_leather','material'),
(1785,'Soul Ore','false','material',10,'stackable','liquid','none',-1,250,0,'true','true','true','true','soul_ore','material'),
(1786,'Recipe: Broad Sword','false','recipe',30,'stackable','liquid','none',-1,250,0,'true','true','true','true','rp_broad_sword','recipe'),
(1787,'Recipe: Willow Staff','false','recipe',30,'stackable','liquid','none',-1,250,0,'true','true','true','true','rp_willow_staff','recipe'),
(1788,'Recipe: Bow','false','recipe',30,'stackable','liquid','none',-1,250,0,'true','true','true','true','rp_bow','recipe'),
(1789,'Recipe: Cedar Staff','false','recipe',30,'stackable','liquid','none',-1,1082,0,'true','true','true','true','rp_cedar_staff','recipe'),
(1790,'Recipe: Dirk','false','recipe',30,'stackable','liquid','none',-1,1082,0,'true','true','true','true','rp_dirk','recipe'),
(1791,'Recipe: Brandish','false','recipe',30,'stackable','liquid','none',-1,1082,0,'true','true','true','true','rp_brandish','recipe'),
(1792,'Recipe: Short Spear','false','recipe',30,'stackable','liquid','none',-1,2720,0,'true','true','true','true','rp_short_spear','recipe'),
(1793,'Recipe: Sword of Reflection','false','recipe',30,'stackable','liquid','none',-1,2720,0,'true','true','true','true','rp_sword_of_reflexion','recipe'),
(1794,'Recipe: Forest Bow','false','recipe',30,'stackable','liquid','none',-1,2720,0,'true','true','true','true','rp_bow_of_forest','recipe'),
(1795,'Recipe:Leather Shoes','false','recipe',30,'stackable','liquid','none',-1,53,0,'true','true','true','true','rp_leather_shoes','recipe'),
(1796,'Recipe: Leather Tunic','false','recipe',30,'stackable','liquid','none',-1,159,0,'true','true','true','true','rp_leather_tunic','recipe'),
(1797,'Recipe: Leather Stockings','false','recipe',30,'stackable','liquid','none',-1,99,0,'true','true','true','true','rp_leather_hose','recipe'),
(1798,'Recipe: Leather Helmet','false','recipe',30,'stackable','liquid','none',-1,204,0,'true','true','true','true','rp_leather_helmet','recipe'),
(1799,'Recipe: Leather Gloves','false','recipe',30,'stackable','liquid','none',-1,135,0,'true','true','true','true','rp_leather_gloves','recipe'),
(1800,'Recipe: Piece Bone Breastplate','false','recipe',30,'stackable','liquid','none',-1,636,0,'true','true','true','true','rp_piece_bone_breastplate','recipe'),
(1801,'Recipe: Piece Bone Gaiters','false','recipe',30,'stackable','liquid','none',-1,397,0,'true','true','true','true','rp_piece_bone_gaiters','recipe'),
(1802,'Recipe: Necklace of Anguish','false','recipe',30,'stackable','liquid','none',-1,93,0,'true','true','true','true','rp_necklace_of_anguish','recipe'),
(1803,'Recipe: Necklace of Wisdom','false','recipe',30,'stackable','liquid','none',-1,238,0,'true','true','true','true','rp_necklace_of_wisdom','recipe'),
(1804,'Recipe: Soulshot: D-Grade','false','recipe',30,'stackable','liquid','none',-1,5000,0,'true','true','true','true','rp_soulshot_d','recipe'),
(1805,'Recipe: Soulshot: C-Grade','false','recipe',30,'stackable','liquid','none',-1,60000,0,'true','true','true','true','rp_soulshot_c','recipe'),
(1806,'Recipe: Soulshot: B-Grade','false','recipe',30,'stackable','liquid','none',-1,100000,0,'true','true','true','true','rp_soulshot_b','recipe'),
(1807,'Recipe: Soulshot: A-Grade','false','recipe',30,'stackable','liquid','none',-1,150000,0,'true','true','true','true','rp_soulshot_a','recipe'),
(1808,'Recipe: Soulshot: S Grade','false','recipe',30,'stackable','liquid','none',-1,450000,0,'true','true','true','true','rp_soulshot_s','recipe'),
(1809,'Recipe: Durable Stem','false','recipe',30,'stackable','liquid','none',-1,100,0,'true','true','true','true','__rp_durable_stem','recipe'),
(1810,'Recipe: Wooden Frame','false','recipe',30,'stackable','liquid','none',-1,100,0,'true','true','true','true','__rp_wooden_frame','recipe'),
(1811,'Recipe: Bark of Treant','false','recipe',30,'stackable','liquid','none',-1,100,0,'true','true','true','true','__rp_bark_of_ent','recipe'),
(1812,'Recipe: Coarse Bone Powder','false','recipe',30,'stackable','liquid','none',-1,100,0,'true','true','true','true','__rp_rough_bone_powder','recipe'),
(1813,'Recipe: Refined Steel','false','recipe',30,'stackable','liquid','none',-1,100,0,'true','true','true','true','__rp_refined_steel','recipe'),
(1814,'Recipe: Leather','false','recipe',30,'stackable','liquid','none',-1,380,0,'true','true','true','true','rp_leather','recipe'),
(1815,'Recipe: Bowstring','false','recipe',30,'stackable','liquid','none',-1,100,0,'true','true','true','true','__rp_bowstring','recipe'),
(1816,'Recipe: Steel Frame','false','recipe',30,'stackable','liquid','none',-1,500,0,'true','true','true','true','__rp_steel_frame','recipe'),
(1817,'Recipe: Cord','false','recipe',30,'stackable','liquid','none',-1,1000,0,'true','true','true','true','rp_cord','recipe'),
(1818,'Recipe: Refined Bronze','false','recipe',30,'stackable','liquid','none',-1,500,0,'true','true','true','true','__rp_refined_bronze','recipe'),
(1819,'Recipe: Treant Potion','false','recipe',30,'stackable','liquid','none',-1,500,0,'true','true','true','true','__rp_ent_potion','recipe'),
(1820,'Recipe: Spell Paper','false','recipe',30,'stackable','liquid','none',-1,500,0,'true','true','true','true','__rp_spell_paper','recipe'),
(1821,'Recipe: Flaming Oil','false','recipe',30,'stackable','liquid','none',-1,500,0,'true','true','true','true','__rp_flaming_oil','recipe'),
(1822,'Recipe: Magic Powder','false','recipe',30,'stackable','liquid','none',-1,1000,0,'true','true','true','true','__rp_magic_powder','recipe'),
(1823,'Recipe: Refined Mythril','false','recipe',30,'stackable','liquid','none',-1,1000,0,'true','true','true','true','__rp_refined_mythril','recipe'),
(1824,'Recipe: Fortified Steel','false','recipe',30,'stackable','liquid','none',-1,1000,0,'true','true','true','true','__rp_fortified_steel','recipe'),
(1825,'Recipe: Oriharukon','false','recipe',30,'stackable','liquid','none',-1,2800,0,'true','true','true','true','rp_oriharukon','recipe'),
(1826,'Recipe: Spell Solution','false','recipe',30,'stackable','liquid','none',-1,1000,0,'true','true','true','true','__rp_spell_solution','recipe'),
(1827,'Recipe: Metal Frame','false','recipe',30,'stackable','liquid','none',-1,1000,0,'true','true','true','true','__rp_metal_frame','recipe'),
(1828,'Recipe: Steel of Highest Grade','false','recipe',30,'stackable','liquid','none',-1,1000,0,'true','true','true','true','__rp_steel_of_highestgrade','recipe'),
(1829,'Scroll of Escape: Clan Hall','false','scroll',120,'stackable','paper','none',-1,500,0,'true','true','true','true','scroll_of_escape_to_agit','scroll'),
(1830,'Scroll of Escape: Castle','false','scroll',120,'stackable','paper','none',-1,500,0,'true','true','true','true','scroll_of_escape_to_castle','scroll'),
(1831,'Antidote','false','potion',20,'stackable','liquid','none',-1,75,0,'true','true','true','true','antidote','potion'),
(1832,'Greater Antidote','false','potion',20,'stackable','liquid','none',-1,180,0,'true','true','true','true','advanced_antidote','potion'),
(1833,'Bandage','false','potion',20,'stackable','liquid','none',-1,75,0,'true','true','true','true','bandage','potion'),
(1834,'Emergency Dressing','false','potion',20,'stackable','liquid','none',-1,180,0,'true','true','true','true','emergency_dressing','potion'),
(1835,'Soulshot: No Grade','false','shot',4,'stackable','paper','none',-1,7,0,'true','true','true','true','soulshot_none','none'),
(1836,'Kendell\'s 1st Order','false','quest',0,'stackable','steel','none',-1,0,0,'false','false','true','false','kendnells_order1','none'),
(1837,'Kendell\'s 2nd Order','false','quest',0,'stackable','steel','none',-1,0,0,'false','false','true','false','kendnells_order2','none'),
(1838,'Kendell\'s 3rd Order','false','quest',0,'stackable','steel','none',-1,0,0,'false','false','true','false','kendnells_order3','none'),
(1839,'Kendell\'s 4th Order','false','quest',0,'stackable','steel','none',-1,0,0,'false','false','true','false','kendnells_order4','none'),
(1840,'Kendell\'s 5th Order','false','quest',0,'stackable','steel','none',-1,0,0,'false','false','true','false','kendnells_order5','none'),
(1841,'Kendell\'s 6th Order','false','quest',0,'stackable','steel','none',-1,0,0,'false','false','true','false','kendnells_order6','none'),
(1842,'Kendell\'s 7th Order','false','quest',0,'stackable','steel','none',-1,0,0,'false','false','true','false','kendnells_order7','none'),
(1843,'Kendell\'s 8th Order','false','quest',0,'stackable','steel','none',-1,0,0,'false','false','true','false','kendnells_order8','none'),
(1844,'Kaboo Chief\'s 1st Torque','false','quest',0,'stackable','steel','none',-1,0,0,'false','false','true','false','kaboo_chief_torc1','none'),
(1845,'Kaboo Chief\'s 2nd Torque','false','quest',0,'stackable','steel','none',-1,0,0,'false','false','true','false','kaboo_chief_torc2','none'),
(1846,'Turek Dog Tag','false','quest',0,'stackable','steel','none',-1,0,0,'false','false','true','false','turek_dogtag','none'),
(1847,'Turek Medallion','false','quest',0,'stackable','steel','none',-1,0,0,'false','false','true','false','turek_medallion','none'),
(1848,'Clay Urn Fragment','false','none',10,'stackable','liquid','none',-1,200,0,'true','true','true','true','clay_urn_fragment','none'),
(1849,'Brass Trinket Piece','false','none',10,'stackable','liquid','none',-1,240,0,'true','true','true','true','brass_trinket_piece','none'),
(1850,'Bronze Mirror Piece','false','none',10,'stackable','liquid','none',-1,240,0,'true','true','true','true','bronze_mirror_piece','none'),
(1851,'Jade Necklace Bead','false','none',10,'stackable','liquid','none',-1,280,0,'true','true','true','true','jade_necklace_bead','none'),
(1852,'Ancient Clay Urn','false','none',10,'stackable','liquid','none',-1,1200,0,'true','true','true','true','ancient_clay_urn','none'),
(1853,'Ancient Brass Tiara','false','none',10,'stackable','liquid','none',-1,1400,0,'true','true','true','true','ancient_brass_tiara','none'),
(1854,'Ancient Bronze Mirror','false','none',10,'stackable','liquid','none',-1,1400,0,'true','true','true','true','ancient_bronze_mirror','none'),
(1855,'Ancient Jade Necklace','false','none',10,'stackable','liquid','none',-1,1700,0,'true','true','true','true','ancient_jade_necklace','none'),
(1856,'Amulet: Chant of Life','false','spellbook',120,'stackable','paper','none',-1,800,0,'true','true','true','true','sb_inspire_life_force1','none'),
(1857,'Keltir Fang','false','quest',0,'stackable','steel','none',-1,0,0,'false','false','true','false','fox_fang1','none'),
(1858,'Keltir Fang','false','quest',0,'stackable','steel','none',-1,0,0,'false','false','true','false','fox_fang2','none'),
(1859,'Keltir Fang','false','quest',0,'stackable','steel','none',-1,0,0,'false','false','true','false','fox_fang3','none'),
(1860,'Keltir Fang','false','quest',0,'stackable','steel','none',-1,0,0,'false','false','true','false','fox_fang4','none'),
(1861,'Keltir Fang','false','quest',0,'stackable','steel','none',-1,0,0,'false','false','true','false','fox_fang5','none'),
(1862,'Keltir Fang','false','quest',0,'stackable','steel','none',-1,0,0,'false','false','true','false','fox_fang6','none'),
(1863,'Map: Elmore','false','none',0,'normal','liquid','none',-1,500,0,'true','true','true','true','world_map_2','none'),
(1864,'Stem','false','material',2,'stackable','liquid','none',-1,100,0,'true','true','true','true','stem','material'),
(1865,'Varnish','false','material',2,'stackable','liquid','none',-1,200,0,'true','true','true','true','varnish','material'),
(1866,'Suede','false','material',2,'stackable','liquid','none',-1,300,0,'true','true','true','true','suede','material'),
(1867,'Animal Skin','false','material',2,'stackable','liquid','none',-1,150,0,'true','true','true','true','animal_skin','material'),
(1868,'Thread','false','material',2,'stackable','liquid','none',-1,100,0,'true','true','true','true','thread','material'),
(1869,'Iron Ore','false','material',2,'stackable','liquid','none',-1,200,0,'true','true','true','true','iron_ore','material'),
(1870,'Coal','false','material',2,'stackable','liquid','none',-1,200,0,'true','true','true','true','coal','material'),
(1871,'Charcoal','false','material',2,'stackable','liquid','none',-1,200,0,'true','true','true','true','charcoal','material'),
(1872,'Animal Bone','false','material',2,'stackable','liquid','none',-1,150,0,'true','true','true','true','animal_bone','material'),
(1873,'Silver Nugget','false','material',2,'stackable','liquid','none',-1,500,0,'true','true','true','true','silver_nugget','material'),
(1874,'Oriharukon Ore','false','material',2,'stackable','liquid','none',-1,3000,0,'true','true','true','true','oriharukon_ore','material'),
(1875,'Stone of Purity','false','material',2,'stackable','liquid','none',-1,3000,0,'true','true','true','true','stone_of_purity','material'),
(1876,'Mithril Ore','false','material',2,'stackable','liquid','none',-1,1000,0,'true','true','true','true','mithril_ore','material'),
(1877,'Adamantite Nugget','false','material',2,'stackable','liquid','none',-1,5000,0,'true','true','true','true','admantite_nugget','material'),
(1878,'Braided Hemp','false','material',2,'stackable','liquid','none',-1,500,0,'true','true','true','true','braided_hemp','material'),
(1879,'Cokes','false','material',2,'stackable','liquid','none',-1,1200,0,'true','true','true','true','cokes','material'),
(1880,'Steel','false','material',2,'stackable','liquid','none',-1,2000,0,'true','true','true','true','steel','material'),
(1881,'Coarse Bone Powder','false','material',2,'stackable','liquid','none',-1,1500,0,'true','true','true','true','coarse_bone_powder','material'),
(1882,'Leather','false','material',2,'stackable','liquid','none',-1,900,0,'true','true','true','true','leather','material'),
(1883,'Steel Mold','false','material',2,'stackable','liquid','none',-1,4500,0,'true','true','true','true','steel_mold','material'),
(1884,'Cord','false','material',2,'stackable','liquid','none',-1,325,0,'true','true','true','true','cord','material'),
(1885,'High Grade Suede','false','material',2,'stackable','liquid','none',-1,2400,0,'true','true','true','true','high_grade_suede','material'),
(1886,'Silver Mold','false','material',2,'stackable','liquid','none',-1,13500,0,'true','true','true','true','silver_mold','material'),
(1887,'Varnish of Purity','false','material',2,'stackable','liquid','none',-1,8100,0,'true','true','true','true','varnish_of_purity','material'),
(1888,'Synthetic Cokes','false','material',2,'stackable','liquid','none',-1,6600,0,'true','true','true','true','synthesis_cokes','material'),
(1889,'Compound Braid','false','material',2,'stackable','liquid','none',-1,3000,0,'true','true','true','true','compound_braid','material'),
(1890,'Mithril Alloy','false','material',2,'stackable','liquid','none',-1,13100,0,'true','true','true','true','mithirl_alloy','material'),
(1891,'Artisan\'s Frame','false','material',2,'stackable','liquid','none',-1,95000,0,'true','true','true','true','artisan\'s_frame','material'),
(1892,'Blacksmith\'s Frame','false','material',2,'stackable','liquid','none',-1,64000,0,'true','true','true','true','blacksmith\'s_frame','material'),
(1893,'Oriharukon','false','material',2,'stackable','liquid','none',-1,24600,0,'true','true','true','true','oriharukon','material'),
(1894,'Crafted Leather','false','material',2,'stackable','liquid','none',-1,5700,0,'true','true','true','true','crafted_leather','material'),
(1895,'Metallic Fiber','false','material',2,'stackable','liquid','none',-1,700,0,'true','true','true','true','metallic_fiber','material'),
(1896,'Necklace of Anguish Chain','false','material',60,'stackable','liquid','none',-1,472,0,'true','true','true','true','necklace_of_anguish_chain','material'),
(1897,'Necklace of Wisdom Chain','false','material',60,'stackable','liquid','none',-1,840,0,'true','true','true','true','necklace_of_wisdom_chain','material'),
(1898,'Blue Diamond Necklace Gem','false','material',60,'stackable','liquid','none',-1,1947,0,'true','true','true','true','blue_diamond_necklace_gem','material'),
(1899,'Necklace of Devotion Chain','false','material',60,'stackable','liquid','none',-1,1280,0,'true','true','true','true','necklace_of_devotion_chain','material'),
(1900,'Enchanted Necklace Chain','false','material',60,'stackable','liquid','none',-1,1828,0,'true','true','true','true','enchanted_necklace_chain','material'),
(1901,'Tiger\'s Eye Earring Stone','false','material',60,'stackable','liquid','none',-1,1448,0,'true','true','true','true','tiger\'seye_earing_stone','material'),
(1902,'Elven Earring Beads','false','material',60,'stackable','liquid','none',-1,1974,0,'true','true','true','true','elven_earing_beads','material'),
(1903,'Elven Ring Piece','false','material',60,'stackable','liquid','none',-1,1199,0,'true','true','true','true','elven_ring_piece','material'),
(1904,'Elven Necklace Beads','false','material',60,'stackable','liquid','none',-1,2143,0,'true','true','true','true','elven_necklace_beads','material'),
(1905,'Omen Beast\'s Eye Earring Gemstone','false','material',60,'stackable','liquid','none',-1,2056,0,'true','true','true','true','onyxbeast\'seye_earing_gemstone','material'),
(1906,'Mithril Ring Wire','false','material',60,'stackable','liquid','none',-1,1455,0,'true','true','true','true','mithril_ring_wire','material'),
(1907,'Necklace of Darkness Gem','false','material',60,'stackable','liquid','none',-1,2875,0,'true','true','true','true','necklace_of_darkness_gem','material'),
(1908,'Moonstone Earring Wire','false','material',60,'stackable','liquid','none',-1,2112,0,'true','true','true','true','moonstone_earing_wire','material'),
(1909,'Aquastone Ring Wire','false','material',60,'stackable','liquid','none',-1,1481,0,'true','true','true','true','aquastone_ring_wire','material'),
(1910,'Aquastone Necklace Chain','false','material',60,'stackable','liquid','none',-1,2656,0,'true','true','true','true','aquastone_necklace_chain','material'),
(1911,'Earring of Protection Gemstone','false','material',60,'stackable','liquid','none',-1,2689,0,'true','true','true','true','earing_of_protection_gemstone','material'),
(1912,'Ring of Protection Gemstone','false','material',60,'stackable','liquid','none',-1,1856,0,'true','true','true','true','ring_of_protection_gemstone','material'),
(1913,'Necklace of Protection Gemstone','false','material',60,'stackable','liquid','none',-1,3289,0,'true','true','true','true','necklace_of_protection_gemstone','material'),
(1914,'Earring of Binding Gemstone','false','material',60,'stackable','liquid','none',-1,3560,0,'true','true','true','true','earing_of_binding_gemstone','material'),
(1915,'Ring of Ages Gemstone','false','material',60,'stackable','liquid','none',-1,2270,0,'true','true','true','true','ring_of_ages_gemstone','material'),
(1916,'Necklace of Mermaid Teardrop','false','material',60,'stackable','liquid','none',-1,4700,0,'true','true','true','true','necklace_of_mermaid_teardrop','material'),
(1917,'Sage\'s Necklace Chain','false','material',60,'stackable','liquid','none',-1,5845,0,'true','true','true','true','sage\'s_necklace_chain','material'),
(1918,'Nassen\'s Earring Gemstone','false','material',60,'stackable','liquid','none',-1,4618,0,'true','true','true','true','nassen\'s_earing_gemstone','material'),
(1919,'Ring of Sage Gemstone','false','material',60,'stackable','liquid','none',-1,3482,0,'true','true','true','true','ring_of_sage_gemstone','material'),
(1920,'Necklace of Binding Chain','false','material',60,'stackable','liquid','none',-1,5845,0,'true','true','true','true','necklace_of_binding_chain','material'),
(1921,'Leather Shoes Texture','false','material',60,'stackable','liquid','none',-1,310,0,'true','true','true','true','leather_shoes_texture','material'),
(1922,'Leather Tunic Pattern','false','material',60,'stackable','liquid','none',-1,784,0,'true','true','true','true','leather_tunic_pattern','material'),
(1923,'Leather Stocking Pattern','false','material',60,'stackable','liquid','none',-1,488,0,'true','true','true','true','leather_hose_pattern','material'),
(1924,'Leather Helmet Design','false','material',60,'stackable','liquid','none',-1,620,0,'true','true','true','true','leather_helmet_design','material'),
(1925,'Leather Gloves Lining','false','material',60,'stackable','liquid','none',-1,305,0,'true','true','true','true','leather_gloves_lining','material'),
(1926,'Piece Bone Breastplate Fragment','false','material',60,'stackable','liquid','none',-1,1980,0,'true','true','true','true','piece_bone_breastplate_fragment','material'),
(1927,'Hard Leather Shirt Pattern','false','material',60,'stackable','liquid','none',-1,2507,0,'true','true','true','true','hard_leather_shirt_pattern','material'),
(1928,'Piece Bone Gaiters Fragment','false','material',60,'stackable','liquid','none',-1,1373,0,'true','true','true','true','piece_bone_gaiters_fragment','material'),
(1929,'Hard Leather Gaiters Material','false','material',60,'stackable','liquid','none',-1,1550,0,'true','true','true','true','hard_leather_gaiters_material','material'),
(1930,'Boot Lining','false','material',60,'stackable','liquid','none',-1,780,0,'true','true','true','true','boots_lining','material'),
(1931,'Leather Boot Lining','false','material',60,'stackable','liquid','none',-1,1530,0,'true','true','true','true','leather_boots_lining','material'),
(1932,'Bone Helmet Design','false','material',60,'stackable','liquid','none',-1,1260,0,'true','true','true','true','bone_helmet_design','material'),
(1933,'Dark Stocking Fabric','false','material',60,'stackable','liquid','none',-1,1700,0,'true','true','true','true','dark_hose_fabric','material'),
(1934,'Crafted Leather Gloves Lining','false','material',60,'stackable','liquid','none',-1,1530,0,'true','true','true','true','excellence_leather_gloves_lining','material'),
(1935,'Scale Mail Fragment','false','material',60,'stackable','liquid','none',-1,3580,0,'true','true','true','true','scale_mail_fragment','material'),
(1936,'White Tunic Pattern','false','material',60,'stackable','liquid','none',-1,2444,0,'true','true','true','true','white_tunic_pattern','material'),
(1937,'Scale Gaiters Fragment','false','material',60,'stackable','liquid','none',-1,2328,0,'true','true','true','true','scale_gaiters_fragment','material'),
(1938,'Mithril Banded Mail Material','false','material',60,'stackable','liquid','none',-1,2975,0,'true','true','true','true','mithril_banded_mail_material','material'),
(1939,'Mithril Banded Gaiters Material','false','material',60,'stackable','liquid','none',-1,2277,0,'true','true','true','true','mithril_banded_gaiters_material','material'),
(1940,'Iron Boots Design','false','material',60,'stackable','liquid','none',-1,1340,0,'true','true','true','true','iron_boots_design','material'),
(1941,'Brigandine Temper','false','material',60,'stackable','liquid','none',-1,5029,0,'true','true','true','true','brigandine_temper','material'),
(1942,'Manticore Skin Shirt Texture','false','material',60,'stackable','liquid','none',-1,3921,0,'true','true','true','true','manticor_skin_shirt_texture','material'),
(1943,'Manticore Skin Gaiters Pattern','false','material',60,'stackable','liquid','none',-1,2518,0,'true','true','true','true','manticor_skin_gaiters_pattern','material'),
(1944,'Mithril Tunic Fabric','false','material',60,'stackable','liquid','none',-1,3921,0,'true','true','true','true','mithril_tunic_fabric','material'),
(1945,'Mithril Stocking Design','false','material',60,'stackable','liquid','none',-1,2518,0,'true','true','true','true','mithril_hose_design','material'),
(1946,'Rip Gauntlets Pattern','false','material',60,'stackable','liquid','none',-1,1480,0,'true','true','true','true','gauntlet_of_repose_of_the_soul_pattern','material'),
(1947,'Kite Shield Fragment','false','material',60,'stackable','liquid','none',-1,1389,0,'true','true','true','true','kite_shield_fragment','material'),
(1948,'Boots of Power Pattern','false','material',60,'stackable','liquid','none',-1,1480,0,'true','true','true','true','boots_of_power_pattern','material'),
(1949,'Mithril Gloves Design','false','material',60,'stackable','liquid','none',-1,1792,0,'true','true','true','true','mithril_glove_design','material'),
(1950,'Half Plate Temper','false','material',60,'stackable','liquid','none',-1,6162,0,'true','true','true','true','half_plate_temper','material'),
(1951,'Plate Gaiters Part','false','material',60,'stackable','liquid','none',-1,3962,0,'true','true','true','true','plate_gaiters_part','material'),
(1952,'Salamander Skin Mail Texture','false','material',60,'stackable','liquid','none',-1,6244,0,'true','true','true','true','slamander_skin_mail_texture','material'),
(1953,'Sage\'s Rag Lining','false','material',60,'stackable','liquid','none',-1,6244,0,'true','true','true','true','sage\'s_rag_lining','material'),
(1954,'Karmian Stocking Design','false','material',60,'stackable','liquid','none',-1,3762,0,'true','true','true','true','karmian_hose_pattern','material'),
(1955,'Chain Helmet Design','false','material',60,'stackable','liquid','none',-1,2481,0,'true','true','true','true','chain_helmet_design','material'),
(1956,'Square Shield Fragment','false','material',60,'stackable','liquid','none',-1,1762,0,'true','true','true','true','square_shield_fragment','material'),
(1957,'Assault Boots Part','false','material',60,'stackable','liquid','none',-1,1792,0,'true','true','true','true','assault_boots_part','material'),
(1958,'Mithril Boots Design','false','material',60,'stackable','liquid','none',-1,1120,0,'true','true','true','true','mithril_boots_design','material'),
(1959,'Chain Mail Shirt Material','false','material',60,'stackable','liquid','none',-1,7425,0,'true','true','true','true','chain_mail_shirt_material','material'),
(1960,'Chain Gaiters Part','false','material',60,'stackable','liquid','none',-1,3650,0,'true','true','true','true','chain_gaiters_part','material'),
(1961,'Mithril Shirt Fabric','false','material',60,'stackable','liquid','none',-1,6250,0,'true','true','true','true','tempered_mithril_shirt_fabric','material'),
(1962,'Karmian Tunic Pattern','false','material',60,'stackable','liquid','none',-1,6250,0,'true','true','true','true','karmian_tunic_pattern','material'),
(1963,'Ogre Power Gauntlets Part','false','material',60,'stackable','liquid','none',-1,1792,0,'true','true','true','true','ogre_power_gauntlet_part','material'),
(1964,'Eldarake Temper','false','material',60,'stackable','liquid','none',-1,2475,0,'true','true','true','true','eldarake_temper','material'),
(1965,'Metal Plate Helmet Material','false','material',60,'stackable','liquid','none',-1,2967,0,'true','true','true','true','metal_plate_helmet_material','material'),
(1966,'Plated Leather Fragment','false','material',60,'stackable','liquid','none',-1,5478,0,'true','true','true','true','plate_leather_fragment','material'),
(1967,'Plated Leather Gaiters Material','false','material',60,'stackable','liquid','none',-1,3667,0,'true','true','true','true','plate_leather_gaiters_material','material'),
(1968,'Dwarven Chain Mail Shirt Material','false','material',60,'stackable','liquid','none',-1,8300,0,'true','true','true','true','dwarven_chain_mail_shirt_material','material'),
(1969,'Dwarven Chain Gaiters Material','false','material',60,'stackable','liquid','none',-1,5233,0,'true','true','true','true','dwarven_chain_gaiters_material','material'),
(1970,'Robe of Seal Fabric','false','material',60,'stackable','liquid','none',-1,8956,0,'true','true','true','true','robe_of_seal_fabric','material'),
(1971,'Great Helmet Material','false','material',60,'stackable','liquid','none',-1,3267,0,'true','true','true','true','great_helmet_material','material'),
(1972,'Knight\'s Shield Fragment','false','material',60,'stackable','liquid','none',-1,2500,0,'true','true','true','true','knight_shield_fragment','material'),
(1973,'Pa''agrian Hand Design','false','material',60,'stackable','liquid','none',-1,2378,0,'true','true','true','true','paagrio_hand_design','material'),
(1974,'Crimson Boot Fabric','false','material',60,'stackable','liquid','none',-1,2378,0,'true','true','true','true','crimson_boots_fabric','material'),
(1975,'Rind Leather Armor Design','false','material',60,'stackable','liquid','none',-1,6089,0,'true','true','true','true','rind_leather_mail_design','material'),
(1976,'Rind Leather Gaiters Material','false','material',60,'stackable','liquid','none',-1,3289,0,'true','true','true','true','rind_leather_gaiters_material','material'),
(1977,'Composite Armor Temper','false','material',60,'stackable','liquid','none',-1,13520,0,'true','true','true','true','composite_armor_temper','material'),
(1978,'Tower Shield Fragment','false','material',60,'stackable','liquid','none',-1,3120,0,'true','true','true','true','tower_shield_fragment','material'),
(1979,'Demon\'s Tunic Fabric','false','material',60,'stackable','liquid','none',-1,8240,0,'true','true','true','true','demon\'s_tunic_fabric','material'),
(1980,'Demon\'s Stocking Pattern','false','material',60,'stackable','liquid','none',-1,4700,0,'true','true','true','true','demon\'s_hose_pattern','material'),
(1981,'Mithril Gauntlets Design','false','material',60,'stackable','liquid','none',-1,3400,0,'true','true','true','true','mithril_gauntlet_design','material'),
(1982,'Forgotten Boots Pattern','false','material',60,'stackable','liquid','none',-1,3400,0,'true','true','true','true','forgotten_boots_pattern','material'),
(1983,'Shining Circlet Pattern','false','material',60,'stackable','liquid','none',-1,4560,0,'true','true','true','true','shining_circlet_pattern','material'),
(1984,'Theca Leather Armor Pattern','false','material',60,'stackable','liquid','none',-1,9330,0,'true','true','true','true','theca_leather_mail_pattern','material'),
(1985,'Theca Leather Gaiters Pattern','false','material',60,'stackable','liquid','none',-1,5800,0,'true','true','true','true','theca_leather_gaiters_pattern','material'),
(1986,'Full Plate Armor Temper','false','material',60,'stackable','liquid','none',-1,18927,0,'true','true','true','true','full_plate_armor_temper','material'),
(1987,'Drake Leather Armor Texture','false','material',60,'stackable','liquid','none',-1,13109,0,'true','true','true','true','drake_leather_mail_texture','material'),
(1988,'Divine Tunic Fabric','false','material',60,'stackable','liquid','none',-1,10409,0,'true','true','true','true','divine_tunic_fabric','material'),
(1989,'Divine Stocking Pattern','false','material',60,'stackable','liquid','none',-1,6636,0,'true','true','true','true','divine_hose_pattern','material'),
(1990,'Mithril Helmet Design','false','material',60,'stackable','liquid','none',-1,5782,0,'true','true','true','true','mithril_helmet_design','material'),
(1991,'Cap of Mana Pattern','false','material',60,'stackable','liquid','none',-1,5782,0,'true','true','true','true','cap_of_mana_pattern','material'),
(1992,'Paradia Hood Material','false','material',60,'stackable','liquid','none',-1,5782,0,'true','true','true','true','paradia_hood_material','material'),
(1993,'Hood of Solar Eclipse Texture','false','material',60,'stackable','liquid','none',-1,5782,0,'true','true','true','true','hood_of_sola_eclipse_texture','material'),
(1994,'Hood of Summoning Texture','false','material',60,'stackable','liquid','none',-1,5782,0,'true','true','true','true','hood_of_summons_texture','material'),
(1995,'Elemental Hood Material','false','material',60,'stackable','liquid','none',-1,5782,0,'true','true','true','true','elemental_hood_material','material'),
(1996,'Hood of Grace Texture','false','material',60,'stackable','liquid','none',-1,5782,0,'true','true','true','true','hood_of_grace_texture','material'),
(1997,'Phoenix Hood Material','false','material',60,'stackable','liquid','none',-1,5782,0,'true','true','true','true','phoenix\'s_hood_material','material'),
(1998,'Hood of Aid Material','false','material',60,'stackable','liquid','none',-1,5782,0,'true','true','true','true','hood_of_assistance_material','material'),
(1999,'Flame Helm Design','false','material',60,'stackable','liquid','none',-1,5782,0,'true','true','true','true','flame_bonnet_design','material'),
(2000,'Tallum Helm Design','false','material',60,'stackable','liquid','none',-1,5782,0,'true','true','true','true','tallum_bonnet_design','material'),
(2001,'Helm of Avadon Design','false','material',60,'stackable','liquid','none',-1,5782,0,'true','true','true','true','bonnet_o''_avadon_design','material'),
(2002,'Helmet of Pledge Pattern','false','material',60,'stackable','liquid','none',-1,5782,0,'true','true','true','true','helmet_of_pledge_pattern','material'),
(2003,'Gauntlets of Ghost Pattern','false','material',60,'stackable','liquid','none',-1,3673,0,'true','true','true','true','gauntlet_of_ghost_pattern','material'),
(2004,'Adamantite Boots Design','false','material',60,'stackable','liquid','none',-1,3673,0,'true','true','true','true','adamantite_boots_design','material'),
(2005,'Broadsword Blade','false','material',60,'stackable','liquid','none',-1,2800,0,'true','true','true','true','broad_sword_blade','material'),
(2006,'Willow Staff Head','false','material',60,'stackable','liquid','none',-1,2800,0,'true','true','true','true','willow_staff_head','material'),
(2007,'Bow Shaft','false','material',60,'stackable','liquid','none',-1,2800,0,'true','true','true','true','bow_shaft','material'),
(2008,'Cedar Staff Head','false','material',60,'stackable','liquid','none',-1,5140,0,'true','true','true','true','cedar_staff_head','material'),
(2009,'Dirk Blade','false','material',60,'stackable','liquid','none',-1,5640,0,'true','true','true','true','dirk_blade','material'),
(2010,'Brandish Blade','false','material',60,'stackable','liquid','none',-1,5140,0,'true','true','true','true','brandish_blade','material'),
(2011,'Short Spear Edge','false','material',60,'stackable','liquid','none',-1,8767,0,'true','true','true','true','short_spear_edge','material'),
(2012,'Sword of Reflection Blade','false','material',60,'stackable','liquid','none',-1,9600,0,'true','true','true','true','sword_of_reflexion_blade','material'),
(2013,'Forest Bow Shaft','false','material',60,'stackable','liquid','none',-1,9267,0,'true','true','true','true','bow_of_forest_shaft','material'),
(2014,'Iron Hammer Head','false','material',60,'stackable','liquid','none',-1,17400,0,'true','true','true','true','iron_hammer_head','material'),
(2015,'Sword Breaker Edge','false','material',60,'stackable','liquid','none',-1,16400,0,'true','true','true','true','sword_breaker_edge','material'),
(2016,'Composite Bow Shaft','false','material',60,'stackable','liquid','none',-1,17067,0,'true','true','true','true','composition_bow_shaft','material'),
(2017,'Saber Blade','false','material',60,'stackable','liquid','none',-1,15050,0,'true','true','true','true','saber_blade','material'),
(2018,'Assassin Knife Edge','false','material',60,'stackable','liquid','none',-1,15050,0,'true','true','true','true','assassin_knife_edge','material'),
(2019,'Trident Edge','false','material',60,'stackable','liquid','none',-1,9300,0,'true','true','true','true','trident_edge','material'),
(2020,'Temptation of Abyss Piece','false','material',60,'stackable','liquid','none',-1,11425,0,'true','true','true','true','temptation_of_abyss_piece','material'),
(2021,'Spinebone Sword Blade','false','material',60,'stackable','liquid','none',-1,15840,0,'true','true','true','true','spinebone_sword_blade','material'),
(2022,'Mace of Judgment Head','false','material',60,'stackable','liquid','none',-1,12840,0,'true','true','true','true','mace_of_judgment_head','material'),
(2023,'Conjuror\'s Staff Head','false','material',60,'stackable','liquid','none',-1,16140,0,'true','true','true','true','conjure_staff_head','material'),
(2024,'Elven Bow Shaft','false','material',60,'stackable','liquid','none',-1,14040,0,'true','true','true','true','elven_bow_shaft','material'),
(2025,'Dwarven Trident Edge','false','material',60,'stackable','liquid','none',-1,14440,0,'true','true','true','true','dwarven_trident_edge','material'),
(2026,'Two-Handed Sword Edge','false','material',60,'stackable','liquid','none',-1,16617,0,'true','true','true','true','two-handed_sword_edge','material'),
(2027,'Spiked Club Head','false','material',60,'stackable','liquid','none',-1,15267,0,'true','true','true','true','spike_club_head','material'),
(2028,'Shilen Knife Edge','false','material',60,'stackable','liquid','none',-1,16833,0,'true','true','true','true','knife_o''_silenus_edge','material'),
(2029,'Gastraphetes Shaft','false','material',60,'stackable','liquid','none',-1,16767,0,'true','true','true','true','gastraphetes_shaft','material'),
(2030,'Tome of Blood Page','false','material',60,'stackable','liquid','none',-1,17100,0,'true','true','true','true','tome_of_blood_page','material'),
(2031,'Morning Star Head','false','material',60,'stackable','liquid','none',-1,19757,0,'true','true','true','true','morning_star_head','material'),
(2032,'Goat Head Staff Head','false','material',60,'stackable','liquid','none',-1,21643,0,'true','true','true','true','goathead_staff_head','material'),
(2033,'Winged Spear Blade','false','material',60,'stackable','liquid','none',-1,17929,0,'true','true','true','true','winged_spear_blade','material'),
(2034,'Sword of Revolution Blade','false','material',60,'stackable','liquid','none',-1,18929,0,'true','true','true','true','sword_of_revolution_blade','material'),
(2035,'Tarbar Head','false','material',60,'stackable','liquid','none',-1,19757,0,'true','true','true','true','tarbar_head','material'),
(2036,'Skull Breaker Head','false','material',60,'stackable','liquid','none',-1,19757,0,'true','true','true','true','skull_breaker_head','material'),
(2037,'Heavy Bone Club Head','false','material',60,'stackable','liquid','none',-1,19757,0,'true','true','true','true','heavy_bone_club_head','material'),
(2038,'Maingauche Edge','false','material',60,'stackable','liquid','none',-1,18929,0,'true','true','true','true','maingauche_edge','material'),
(2039,'Bich''Hwa Edge','false','material',60,'stackable','liquid','none',-1,19757,0,'true','true','true','true','bich''hwa_edge','material'),
(2040,'Strengthened Long Bow Shaft','false','material',60,'stackable','liquid','none',-1,17286,0,'true','true','true','true','strengthening_long_bow_shaft','material'),
(2041,'War Pick Head','false','material',60,'stackable','liquid','none',-1,17929,0,'true','true','true','true','hammer_in_flames_head','material'),
(2042,'Crucifix of Blood Piece','false','material',60,'stackable','liquid','none',-1,21643,0,'true','true','true','true','crucifix_of_blood_piece','material'),
(2043,'Eye of Infinity Stone','false','material',60,'stackable','liquid','none',-1,21643,0,'true','true','true','true','eye_of_infinity_stone','material'),
(2044,'Cursed Maingauche Edge','false','material',60,'stackable','liquid','none',-1,18929,0,'true','true','true','true','cursed_maingauche_edge','material'),
(2045,'Blue Crystal Skull Part','false','material',60,'stackable','liquid','none',-1,21786,0,'true','true','true','true','blue_crystal_skull_part','material'),
(2046,'Demon Fangs Part','false','material',60,'stackable','liquid','none',-1,21786,0,'true','true','true','true','demon_fangs_part','material'),
(2047,'Claymore Blade','false','material',60,'stackable','liquid','none',-1,22750,0,'true','true','true','true','claymore_blade','material'),
(2048,'Bonebreaker Head','false','material',60,'stackable','liquid','none',-1,24188,0,'true','true','true','true','bonebreaker_head','material'),
(2049,'Atuba Hammer Head','false','material',60,'stackable','liquid','none',-1,24188,0,'true','true','true','true','atuba_hammer_head','material'),
(2050,'Ghost Staff Head','false','material',60,'stackable','liquid','none',-1,22812,0,'true','true','true','true','ghost_staff_head','material'),
(2051,'Staff of Life Shaft','false','material',60,'stackable','liquid','none',-1,22812,0,'true','true','true','true','life_stick_shaft','material'),
(2052,'Mithril Dagger Blade','false','material',60,'stackable','liquid','none',-1,23062,0,'true','true','true','true','mithril_dagger_blade','material'),
(2053,'Scallop Jamadhr Edge','false','material',60,'stackable','liquid','none',-1,24188,0,'true','true','true','true','scallop_jamadhr_edge','material'),
(2054,'Light Crossbow Shaft','false','material',60,'stackable','liquid','none',-1,23500,0,'true','true','true','true','cyclone_bow_shaft','material'),
(2055,'Glaive Edge','false','material',60,'stackable','liquid','none',-1,24188,0,'true','true','true','true','glaive_edge','material'),
(2056,'Vajra Wand Frame','false','material',60,'stackable','liquid','none',-1,22812,0,'true','true','true','true','vajra_wands_frame','material'),
(2057,'Ancient Reagent Remnant','false','material',60,'stackable','liquid','none',-1,22812,0,'true','true','true','true','ancient_reagent_remnant','material'),
(2058,'Atuba Mace Head','false','material',60,'stackable','liquid','none',-1,24188,0,'true','true','true','true','atuba_mace_head','material'),
(2059,'Flamberge Blade','false','material',60,'stackable','liquid','none',-1,24125,0,'true','true','true','true','flamberge_blade','material'),
(2060,'Stormbringer Blade','false','material',60,'stackable','liquid','none',-1,24425,0,'true','true','true','true','stormbringer_blade','material'),
(2061,'Big Hammer Head','false','material',60,'stackable','liquid','none',-1,26800,0,'true','true','true','true','big_hammer_head','material'),
(2062,'Scythe Edge','false','material',60,'stackable','liquid','none',-1,22750,0,'true','true','true','true','scythe_edge','material'),
(2063,'Battle Axe Head','false','material',60,'stackable','liquid','none',-1,26800,0,'true','true','true','true','battle_axe_head','material'),
(2064,'Silver Axe Head','false','material',60,'stackable','liquid','none',-1,26800,0,'true','true','true','true','war_pick_head','material'),
(2065,'Skull Graver Head','false','material',60,'stackable','liquid','none',-1,26800,0,'true','true','true','true','skull_graver_head','material'),
(2066,'Heavy Doom Hammer Head','false','material',60,'stackable','liquid','none',-1,22750,0,'true','true','true','true','heavy_doom_hammer_head','material'),
(2067,'Crystal Staff Head','false','material',60,'stackable','liquid','none',-1,27000,0,'true','true','true','true','crystal_staff_head','material'),
(2068,'Stick of Faith Shaft','false','material',60,'stackable','liquid','none',-1,27000,0,'true','true','true','true','stick_of_faith_shaft','material'),
(2069,'Heavy Doom Axe Blade','false','material',60,'stackable','liquid','none',-1,22750,0,'true','true','true','true','heavy_doom_axe_blade','material'),
(2070,'Cursed Dagger Blade','false','material',60,'stackable','liquid','none',-1,24425,0,'true','true','true','true','cursed_dagger_blade','material'),
(2071,'Wolverine Needle Edge','false','material',60,'stackable','liquid','none',-1,24425,0,'true','true','true','true','needle_wolverine_edge','material'),
(2072,'Dark Elven Dagger Edge','false','material',60,'stackable','liquid','none',-1,24425,0,'true','true','true','true','darkelven_dagger_edge','material'),
(2073,'Chakram Edge','false','material',60,'stackable','liquid','none',-1,26800,0,'true','true','true','true','chakram_edge','material'),
(2074,'Crystallized Ice Bow Shaft','false','material',60,'stackable','liquid','none',-1,26538,0,'true','true','true','true','crystallized_ice_bow_shaft','material'),
(2075,'Orcish Glaive Blade','false','material',60,'stackable','liquid','none',-1,22750,0,'true','true','true','true','orcish_glaive_blade','material'),
(2076,'Body Slasher Blade','false','material',60,'stackable','liquid','none',-1,22750,0,'true','true','true','true','body_slasher_blade','material'),
(2077,'Shamshir Blade','false','material',60,'stackable','liquid','none',-1,29556,0,'true','true','true','true','shamshir_blade','material'),
(2078,'Katana Blade','false','material',60,'stackable','liquid','none',-1,29556,0,'true','true','true','true','katana_blade','material'),
(2079,'Bec De Corbin Blade','false','material',60,'stackable','liquid','none',-1,31667,0,'true','true','true','true','bech_de_corbin_blade','material'),
(2080,'Spirit Sword Blade','false','material',60,'stackable','liquid','none',-1,29556,0,'true','true','true','true','spirits_sword_blade','material'),
(2081,'Raid Sword Blade','false','material',60,'stackable','liquid','none',-1,29556,0,'true','true','true','true','raid_sword_blade','material'),
(2082,'Cursed Staff Head','false','material',60,'stackable','liquid','none',-1,30911,0,'true','true','true','true','cursed_staff_head','material'),
(2083,'Stiletto Edge','false','material',60,'stackable','liquid','none',-1,29556,0,'true','true','true','true','stiletto_edge','material'),
(2084,'Soulfire Dirk Blade','false','material',60,'stackable','liquid','none',-1,29556,0,'true','true','true','true','dagger_of_magicflame_blade','material'),
(2085,'Crossbow Shaft','false','material',60,'stackable','liquid','none',-1,26189,0,'true','true','true','true','elemental_bow_shaft','material'),
(2086,'Elven Bow of Nobility Shaft','false','material',60,'stackable','liquid','none',-1,26189,0,'true','true','true','true','noble_elven_bow_shaft','material'),
(2087,'Tears of Fairy Drop','false','material',60,'stackable','liquid','none',-1,30911,0,'true','true','true','true','tears_of_fairy_drop','material'),
(2088,'Horn of Glory Fragment','false','material',60,'stackable','liquid','none',-1,30911,0,'true','true','true','true','horn_of_glory_fragment','material'),
(2089,'Caliburs Edge','false','material',60,'stackable','liquid','none',-1,37450,0,'true','true','true','true','caliburs_edge','material'),
(2090,'Delusional Blade','false','material',60,'stackable','liquid','none',-1,37450,0,'true','true','true','true','sword_of_delusion_blade','material'),
(2091,'Tsurugi Blade','false','material',60,'stackable','liquid','none',-1,37450,0,'true','true','true','true','tsurugi_blade','material'),
(2092,'Homunkulus\'s Sword Blade','false','material',60,'stackable','liquid','none',-1,37450,0,'true','true','true','true','homunkulus\'s_sword_blade','material'),
(2093,'Poleaxe Blade','false','material',60,'stackable','liquid','none',-1,34200,0,'true','true','true','true','poleaxe_blade','material'),
(2094,'Sword of Limit Blade','false','material',60,'stackable','liquid','none',-1,37450,0,'true','true','true','true','sword_of_limit_blade','material'),
(2095,'Sword of Nightmare Blade','false','material',60,'stackable','liquid','none',-1,37450,0,'true','true','true','true','sword_of_nightmare_blade','material'),
(2096,'Sword of Whispering Death Blade','false','material',60,'stackable','liquid','none',-1,37450,0,'true','true','true','true','deathbreath_sword_blade','material'),
(2097,'War Axe Blade','false','material',60,'stackable','liquid','none',-1,37000,0,'true','true','true','true','war_axe_blade','material'),
(2098,'Nirvana Axe Blade','false','material',60,'stackable','liquid','none',-1,37000,0,'true','true','true','true','nirvana_axe_blade','material'),
(2099,'Stick of Eternity Shaft','false','material',60,'stackable','liquid','none',-1,35900,0,'true','true','true','true','stick_of_eternity_shaft','material'),
(2100,'Paradia Staff Head','false','material',60,'stackable','liquid','none',-1,35900,0,'true','true','true','true','paradia_staff_head','material'),
(2101,'Inferno Staff Head','false','material',60,'stackable','liquid','none',-1,35900,0,'true','true','true','true','inferno_staff_head','material'),
(2102,'Pa''agrian Hammer Head','false','material',60,'stackable','liquid','none',-1,34200,0,'true','true','true','true','paagrio_hammer_head','material'),
(2103,'Sage\'s Staff Head','false','material',60,'stackable','liquid','none',-1,35900,0,'true','true','true','true','sage\'s_staff_head','material'),
(2104,'Club of Nature Head','false','material',60,'stackable','liquid','none',-1,35900,0,'true','true','true','true','club_of_nature_head','material'),
(2105,'Mace of The Underworld Head','false','material',60,'stackable','liquid','none',-1,37000,0,'true','true','true','true','mace_of_underworld_head','material'),
(2106,'Grace Dagger Edge','false','material',60,'stackable','liquid','none',-1,37450,0,'true','true','true','true','grace_dagger_edge','material'),
(2107,'Dark Screamer Edge','false','material',60,'stackable','liquid','none',-1,37450,0,'true','true','true','true','dark_screamer_edge','material'),
(2108,'Fisted Blade Piece','false','material',60,'stackable','liquid','none',-1,37000,0,'true','true','true','true','fist_blade_piece','material'),
(2109,'Akat Longbow Shaft','false','material',60,'stackable','liquid','none',-1,41130,0,'true','true','true','true','akat_long_bow_shaft','material'),
(2110,'Heathen\'s Book Page','false','material',60,'stackable','liquid','none',-1,35900,0,'true','true','true','true','heathen\'s_book_page','material'),
(2111,'Hex Doll Fragment','false','material',60,'stackable','liquid','none',-1,35900,0,'true','true','true','true','hex_doll_fragment','material'),
(2112,'Pa''agrian Axe Blade','false','material',60,'stackable','liquid','none',-1,39900,0,'true','true','true','true','paagrio_axe_blade','material'),
(2113,'Scorpion Blade','false','material',60,'stackable','liquid','none',-1,39900,0,'true','true','true','true','scorpion_blade','material'),
(2114,'Widowmaker Head','false','material',60,'stackable','liquid','none',-1,39900,0,'true','true','true','true','widow_maker_head','material'),
(2115,'Samurai Longsword Blade','false','material',60,'stackable','liquid','none',-1,46636,0,'true','true','true','true','samurai_longsword_blade','material'),
(2116,'Deadman\'s Staff Head','false','material',60,'stackable','liquid','none',-1,43818,0,'true','true','true','true','deadman\'s_staff_head','material'),
(2117,'Ghoul\'s Staff Head','false','material',60,'stackable','liquid','none',-1,43818,0,'true','true','true','true','ghoul\'s_staff_head','material'),
(2118,'Demon\'s Staff Head','false','material',60,'stackable','liquid','none',-1,43818,0,'true','true','true','true','demon\'s_staff_head','material'),
(2119,'Crystal Dagger Blade','false','material',60,'stackable','liquid','none',-1,43136,0,'true','true','true','true','crystal_dagger_blade','material'),
(2120,'Great Pata Blade','false','material',60,'stackable','liquid','none',-1,45964,0,'true','true','true','true','great_pata_blade','material'),
(2121,'Eminence Bow Shaft','false','material',60,'stackable','liquid','none',-1,47218,0,'true','true','true','true','eminence_bow_shaft','material'),
(2122,'Orcish Poleaxe Blade','false','material',60,'stackable','liquid','none',-1,43818,0,'true','true','true','true','orcish_poleaxe_blade','material'),
(2123,'Candle of Wisdom Model','false','material',60,'stackable','liquid','none',-1,43818,0,'true','true','true','true','candle_of_wisdom_model','material'),
(2124,'Blessed Branch Splinter','false','material',60,'stackable','liquid','none',-1,43818,0,'true','true','true','true','blessed_branch_splinter','material'),
(2125,'Phoenix Feather Piece','false','material',60,'stackable','liquid','none',-1,43818,0,'true','true','true','true','phoenix\'s_feather_piece','material'),
(2126,'Cerberus Eye Fragment','false','material',60,'stackable','liquid','none',-1,43818,0,'true','true','true','true','cerberus\'s_eye_fragment','material'),
(2127,'Scroll of Destruction Page','false','material',60,'stackable','liquid','none',-1,43818,0,'true','true','true','true','scroll_of_destruction_page','material'),
(2128,'Claws of Black Dragon Piece','false','material',60,'stackable','liquid','none',-1,43818,0,'true','true','true','true','claws_of_blackdragon_piece','material'),
(2129,'Three Eyed Crow\'s Feather Piece','false','material',60,'stackable','liquid','none',-1,43818,0,'true','true','true','true','three_eye_crow\'s_feather_piece','material'),
(2130,'Gemstone D','false','material',2,'stackable','liquid','none',-1,1000,0,'true','true','true','true','gemstone_d','material'),
(2131,'Gemstone C','false','material',2,'stackable','liquid','none',-1,3000,0,'true','true','true','true','gemstone_c','material'),
(2132,'Gemstone B','false','material',2,'stackable','liquid','none',-1,10000,0,'true','true','true','true','gemstone_b','material'),
(2133,'Gemstone A','false','material',2,'stackable','liquid','none',-1,30000,0,'true','true','true','true','gemstone_a','material'),
(2134,'Gemstone S','false','material',2,'stackable','liquid','none',-1,100000,0,'true','true','true','true','gemstone_s','material'),
(2135,'Recipe: Braided Hemp','false','recipe',30,'stackable','liquid','none',-1,680,0,'true','true','true','true','rp_braided_hemp','recipe'),
(2136,'Recipe: Cokes','false','recipe',30,'stackable','liquid','none',-1,680,0,'true','true','true','true','rp_cokes','recipe'),
(2137,'Recipe: Steel','false','recipe',30,'stackable','liquid','none',-1,680,0,'true','true','true','true','rp_steel','recipe'),
(2138,'Recipe: Coarse Bone Powder (100%)','false','recipe',30,'stackable','liquid','none',-1,680,0,'true','true','true','true','rp_coarse_bone_powder','recipe'),
(2139,'Recipe: Steel Mold','false','recipe',30,'stackable','liquid','none',-1,1000,0,'true','true','true','true','rp_steel_mold','recipe'),
(2140,'Recipe: High Grade Suede','false','recipe',30,'stackable','liquid','none',-1,1000,0,'true','true','true','true','rp_high_grade_suede','recipe'),
(2141,'Recipe: Silver Mold','false','recipe',30,'stackable','liquid','none',-1,1000,0,'true','true','true','true','rp_silver_mold','recipe'),
(2142,'Recipe: Varnish of Purity','false','recipe',30,'stackable','liquid','none',-1,1000,0,'true','true','true','true','rp_varnish_of_purity','recipe'),
(2143,'Recipe: Synthetic Cokes','false','recipe',30,'stackable','liquid','none',-1,1000,0,'true','true','true','true','rp_synthesis_cokes','recipe'),
(2144,'Recipe: Compound Braid','false','recipe',30,'stackable','liquid','none',-1,1000,0,'true','true','true','true','rp_compound_braid','recipe'),
(2145,'Recipe: Mithril Alloy','false','recipe',30,'stackable','liquid','none',-1,2800,0,'true','true','true','true','rp_mithirl_alloy','recipe'),
(2146,'Recipe: Artisan\'s frame','false','recipe',30,'stackable','liquid','none',-1,2800,0,'true','true','true','true','rp_artisan\'s_frame','recipe'),
(2147,'Recipe: Blacksmith\'s frame','false','recipe',30,'stackable','liquid','none',-1,2800,0,'true','true','true','true','rp_blacksmith\'s_frame','recipe'),
(2148,'Recipe: Crafted Leather','false','recipe',30,'stackable','liquid','none',-1,2800,0,'true','true','true','true','rp_crafted_leather','recipe'),
(2149,'Recipe: Metallic Fiber','false','recipe',30,'stackable','liquid','none',-1,2800,0,'true','true','true','true','rp_metallic_fiber','recipe'),
(2150,'Recipe: Blue Diamond Necklace','false','recipe',30,'stackable','liquid','none',-1,426,0,'true','true','true','true','rp_blue_diamond_necklace','recipe'),
(2151,'Recipe: Necklace of Devotion','false','recipe',30,'stackable','liquid','none',-1,718,0,'true','true','true','true','rp_necklace_of_devotion','recipe'),
(2152,'Recipe: Enchanted Necklace','false','recipe',30,'stackable','liquid','none',-1,1136,0,'true','true','true','true','rp_enchanted_necklace','recipe'),
(2153,'Recipe: Tiger\'s Eye Earring','false','recipe',30,'stackable','liquid','none',-1,1286,0,'true','true','true','true','rp_tiger\'seye_earing','recipe'),
(2154,'Recipe: Elven Earring','false','recipe',30,'stackable','liquid','none',-1,1868,0,'true','true','true','true','rp_elven_earing','recipe'),
(2155,'Recipe: Elven Ring','false','recipe',30,'stackable','liquid','none',-1,1246,0,'true','true','true','true','rp_elven_ring','recipe'),
(2156,'Recipe: Elven Necklace','false','recipe',30,'stackable','liquid','none',-1,2500,0,'true','true','true','true','rp_elven_necklace','recipe'),
(2157,'Recipe: Omen Beast\'s Eye Earring','false','recipe',30,'stackable','liquid','none',-1,2420,0,'true','true','true','true','rp_onyxbeast\'seye_earing','recipe'),
(2158,'Recipe: Mithril Ring','false','recipe',30,'stackable','liquid','none',-1,1616,0,'true','true','true','true','rp_mithril_ring','recipe'),
(2159,'Recipe: Necklace of Darkness','false','recipe',30,'stackable','liquid','none',-1,3240,0,'true','true','true','true','rp_necklace_of_darkness','recipe'),
(2160,'Recipe: Moonstone Earring','false','recipe',30,'stackable','liquid','none',-1,3100,0,'true','true','true','true','rp_moonstone_earing','recipe'),
(2161,'Recipe: Aquastone Ring','false','recipe',30,'stackable','liquid','none',-1,2060,0,'true','true','true','true','rp_aquastone_ring','recipe'),
(2162,'Recipe: Aquastone Necklace','false','recipe',30,'stackable','liquid','none',-1,4140,0,'true','true','true','true','rp_aquastone_necklace','recipe'),
(2163,'Recipe: Earring of Protection','false','recipe',30,'stackable','liquid','none',-1,3920,0,'true','true','true','true','rp_earing_of_protection','recipe'),
(2164,'Recipe: Ring of Protection','false','recipe',30,'stackable','liquid','none',-1,2600,0,'true','true','true','true','rp_ring_of_protection','recipe'),
(2165,'Recipe: Necklace of Protection','false','recipe',30,'stackable','liquid','none',-1,5220,0,'true','true','true','true','rp_necklace_of_protection','recipe'),
(2166,'Recipe: Earrings of Binding (100%)','false','recipe',30,'stackable','liquid','none',-1,5900,0,'true','true','true','true','rp_earing_of_binding','recipe'),
(2167,'Recipe: Ring of Ages','false','recipe',30,'stackable','liquid','none',-1,3920,0,'true','true','true','true','rp_ring_of_ages','recipe'),
(2168,'Recipe: Necklace of Mermaid','false','recipe',30,'stackable','liquid','none',-1,7860,0,'true','true','true','true','rp_necklace_of_mermaid','recipe'),
(2169,'Recipe: Necklace of Binding','false','recipe',30,'stackable','liquid','none',-1,11300,0,'true','true','true','true','rp_necklace_of_binding','recipe'),
(2170,'Recipe: Nassen\'s Earring','false','recipe',30,'stackable','liquid','none',-1,8480,0,'true','true','true','true','rp_nassen\'s_earing','recipe'),
(2171,'Recipe: Sage\'s Ring','false','recipe',30,'stackable','liquid','none',-1,5640,0,'true','true','true','true','rp_ring_of_sage','recipe'),
(2172,'Recipe: Sage\'s Necklace','false','recipe',30,'stackable','liquid','none',-1,11300,0,'true','true','true','true','rp_sage\'s_necklace','recipe'),
(2173,'Recipe: Hard Leather Shirt','false','recipe',30,'stackable','liquid','none',-1,738,0,'true','true','true','true','rp_hard_leather_shirt','recipe'),
(2174,'Recipe: Hard Leather Gaiters','false','recipe',30,'stackable','liquid','none',-1,460,0,'true','true','true','true','rp_hard_leather_gaiters','recipe'),
(2175,'Recipe: Boots','false','recipe',30,'stackable','liquid','none',-1,246,0,'true','true','true','true','rp_boots','recipe'),
(2176,'Recipe: Leather Boots','false','recipe',30,'stackable','liquid','none',-1,418,0,'true','true','true','true','rp_leather_boots','recipe'),
(2177,'Recipe: Bone Helmet','false','recipe',30,'stackable','liquid','none',-1,626,0,'true','true','true','true','rp_bone_helmet','recipe'),
(2178,'Recipe: Dark Stockings','false','recipe',30,'stackable','liquid','none',-1,1250,0,'true','true','true','true','rp_dark_hose','recipe'),
(2179,'Recipe: Crafted Leather Gloves','false','recipe',30,'stackable','liquid','none',-1,418,0,'true','true','true','true','rp_excellence_leather_gloves','recipe'),
(2180,'Recipe: Scale Mail','false','recipe',30,'stackable','liquid','none',-1,2660,0,'true','true','true','true','rp_scale_mail','recipe'),
(2181,'Recipe: White Tunic','false','recipe',30,'stackable','liquid','none',-1,1998,0,'true','true','true','true','rp_white_tunic','recipe'),
(2182,'Recipe: Scale Gaiters','false','recipe',30,'stackable','liquid','none',-1,1666,0,'true','true','true','true','rp_scale_gaiters','recipe'),
(2183,'Recipe: Mithril Banded Mail','false','recipe',30,'stackable','liquid','none',-1,3040,0,'true','true','true','true','rp_mithril_banded_mail','recipe'),
(2184,'Recipe: Mithril Banded Gaiters','false','recipe',30,'stackable','liquid','none',-1,1904,0,'true','true','true','true','rp_mithril_banded_gaiters','recipe'),
(2185,'Recipe: Iron Boots','false','recipe',30,'stackable','liquid','none',-1,1016,0,'true','true','true','true','rp_iron_boots','recipe'),
(2186,'Recipe: Brigandine Tunic','false','recipe',30,'stackable','liquid','none',-1,5980,0,'true','true','true','true','rp_brigandine','recipe'),
(2187,'Recipe: Manticore Skin Shirt','false','recipe',30,'stackable','liquid','none',-1,4480,0,'true','true','true','true','rp_manticor_skin_shirt','recipe'),
(2188,'Recipe: Manticore Skin Gaiters','false','recipe',30,'stackable','liquid','none',-1,2800,0,'true','true','true','true','rp_manticor_skin_gaiters','recipe'),
(2189,'Recipe: Mithril Tunic','false','recipe',30,'stackable','liquid','none',-1,4480,0,'true','true','true','true','rp_mithril_tunic','recipe'),
(2190,'Recipe: Mithril Stockings','false','recipe',30,'stackable','liquid','none',-1,2800,0,'true','true','true','true','rp_mithril_hose','recipe'),
(2191,'Recipe: RIP Gauntlets','false','recipe',30,'stackable','liquid','none',-1,1494,0,'true','true','true','true','rp_gauntlet_of_repose_of_the_soul','recipe'),
(2192,'Recipe: Kite Shield','false','recipe',30,'stackable','liquid','none',-1,1568,0,'true','true','true','true','rp_kite_shield','recipe'),
(2193,'Recipe: Boots of Power','false','recipe',30,'stackable','liquid','none',-1,1494,0,'true','true','true','true','rp_boots_of_power','recipe'),
(2194,'Recipe: Mithril Gloves','false','recipe',30,'stackable','liquid','none',-1,1956,0,'true','true','true','true','rp_mithril_glove','recipe'),
(2195,'Recipe: Half Plate Armor','false','recipe',30,'stackable','liquid','none',-1,7820,0,'true','true','true','true','rp_half_plate','recipe'),
(2196,'Recipe: Plate Gaiters','false','recipe',30,'stackable','liquid','none',-1,4880,0,'true','true','true','true','rp_plate_gaiters','recipe'),
(2197,'Recipe: Salamander Skin Mail','false','recipe',30,'stackable','liquid','none',-1,9540,0,'true','true','true','true','rp_slamander_skin_mail','recipe'),
(2198,'Recipe: Sage\'s Rag','false','recipe',30,'stackable','liquid','none',-1,9540,0,'true','true','true','true','rp_sage\'s_rag','recipe'),
(2199,'Recipe: Karmian Stockings','false','recipe',30,'stackable','liquid','none',-1,4740,0,'true','true','true','true','rp_karmian_hose','recipe'),
(2200,'Recipe: Chain Helmet','false','recipe',30,'stackable','liquid','none',-1,2940,0,'true','true','true','true','rp_chain_helmet','recipe'),
(2201,'Recipe: Square Shield','false','recipe',30,'stackable','liquid','none',-1,2060,0,'true','true','true','true','rp_square_shield','recipe'),
(2202,'Recipe: Assault Boots','false','recipe',30,'stackable','liquid','none',-1,1956,0,'true','true','true','true','rp_assault_boots','recipe'),
(2203,'Recipe: Mithril Boots','false','recipe',30,'stackable','liquid','none',-1,918,0,'true','true','true','true','rp_mithril_boots','recipe'),
(2204,'Recipe: Chain Mail Shirt','false','recipe',30,'stackable','liquid','none',-1,10100,0,'true','true','true','true','rp_chain_mail_shirt','recipe'),
(2205,'Recipe: Chain Gaiters','false','recipe',30,'stackable','liquid','none',-1,6320,0,'true','true','true','true','rp_chain_gaiters','recipe'),
(2206,'Recipe: Mithril Shirt','false','recipe',30,'stackable','liquid','none',-1,7580,0,'true','true','true','true','rp_tempered_mithril_shirt','recipe'),
(2207,'Recipe: Karmian Tunic','false','recipe',30,'stackable','liquid','none',-1,7580,0,'true','true','true','true','rp_karmian_tunic','recipe'),
(2208,'Recipe: Ogre Power Gauntlets','false','recipe',30,'stackable','liquid','none',-1,1956,0,'true','true','true','true','rp_ogre_power_gauntlet','recipe'),
(2209,'Recipe: Eldarake','false','recipe',30,'stackable','liquid','none',-1,2660,0,'true','true','true','true','rp_eldarake','recipe'),
(2210,'Recipe: Steel Plate Helmet','false','recipe',30,'stackable','liquid','none',-1,4120,0,'true','true','true','true','rp_metal_plate_helmet','recipe'),
(2211,'Recipe: Plated Leather Armor','false','recipe',30,'stackable','liquid','none',-1,8920,0,'true','true','true','true','rp_plate_leather','recipe'),
(2212,'Recipe: Plated Leather Gaiters','false','recipe',30,'stackable','liquid','none',-1,5580,0,'true','true','true','true','rp_plate_leather_gaiters','recipe'),
(2213,'Recipe: Dwarven Chain Mail Shirt','false','recipe',30,'stackable','liquid','none',-1,12880,0,'true','true','true','true','rp_dwarven_chain_mail_shirt','recipe'),
(2214,'Recipe: Dwarven Chain Gaiters','false','recipe',30,'stackable','liquid','none',-1,8060,0,'true','true','true','true','rp_dwarven_chain_gaiters','recipe'),
(2215,'Recipe: Robe of Seal','false','recipe',30,'stackable','liquid','none',-1,15700,0,'true','true','true','true','rp_robe_of_seal','recipe'),
(2216,'Recipe: Great Helmet','false','recipe',30,'stackable','liquid','none',-1,4840,0,'true','true','true','true','rp_great_helmet','recipe'),
(2217,'Recipe: Knight\'s Shield','false','recipe',30,'stackable','liquid','none',-1,3380,0,'true','true','true','true','rp_knight_shield','recipe'),
(2218,'Recipe: Pa''agrian Hand','false','recipe',30,'stackable','liquid','none',-1,3220,0,'true','true','true','true','rp_paagrio_hand','recipe'),
(2219,'Recipe: Crimson Boots','false','recipe',30,'stackable','liquid','none',-1,3220,0,'true','true','true','true','rp_crimson_boots','recipe'),
(2220,'Recipe: Rind Leather Armor','false','recipe',30,'stackable','liquid','none',-1,9660,0,'true','true','true','true','rp_rind_leather_mail','recipe'),
(2221,'Recipe: Rind Leather Gaiters','false','recipe',30,'stackable','liquid','none',-1,6040,0,'true','true','true','true','rp_rind_leather_gaiters','recipe'),
(2222,'Recipe: Composite Armor','false','recipe',30,'stackable','liquid','none',-1,32000,0,'true','true','true','true','rp_composite_armor','recipe'),
(2223,'Recipe: Tower Shield','false','recipe',30,'stackable','liquid','none',-1,5160,0,'true','true','true','true','rp_tower_shield','recipe'),
(2224,'Recipe: Demon\'s Tunic','false','recipe',30,'stackable','liquid','none',-1,14720,0,'true','true','true','true','rp_demon\'s_tunic','recipe'),
(2225,'Recipe: Demon\'s Stockings','false','recipe',30,'stackable','liquid','none',-1,9200,0,'true','true','true','true','rp_demon\'s_hose','recipe'),
(2226,'Recipe: Mithril Gauntlets','false','recipe',30,'stackable','liquid','none',-1,4900,0,'true','true','true','true','rp_mithril_gauntlet','recipe'),
(2227,'Recipe: Forgotten Boots','false','recipe',30,'stackable','liquid','none',-1,4900,0,'true','true','true','true','rp_forgotten_boots','recipe'),
(2228,'Recipe: Shining Circlet','false','recipe',30,'stackable','liquid','none',-1,7360,0,'true','true','true','true','rp_shining_circlet','recipe'),
(2229,'Recipe: Theca Leather Armor','false','recipe',30,'stackable','liquid','none',-1,16500,0,'true','true','true','true','rp_theca_leather_mail','recipe'),
(2230,'Recipe: Theca Leather Gaiters','false','recipe',30,'stackable','liquid','none',-1,10320,0,'true','true','true','true','rp_theca_leather_gaiters','recipe'),
(2231,'Recipe: Full Plate Armor','false','recipe',30,'stackable','liquid','none',-1,46400,0,'true','true','true','true','rp_full_plate_armor','recipe'),
(2232,'Recipe: Drake Leather Armor','false','recipe',30,'stackable','liquid','none',-1,34800,0,'true','true','true','true','rp_drake_leather_mail','recipe'),
(2233,'Recipe: Divine Tunic','false','recipe',30,'stackable','liquid','none',-1,21400,0,'true','true','true','true','rp_divine_tunic','recipe'),
(2234,'Recipe: Divine Stockings','false','recipe',30,'stackable','liquid','none',-1,13420,0,'true','true','true','true','rp_divine_hose','recipe'),
(2235,'Recipe: Mithril Helmet','false','recipe',30,'stackable','liquid','none',-1,10720,0,'true','true','true','true','rp_mithril_helmet','recipe'),
(2236,'Recipe: Cap of Mana','false','recipe',30,'stackable','liquid','none',-1,10720,0,'true','true','true','true','rp_cap_of_mana','recipe'),
(2237,'Recipe: Paradia Hood','false','recipe',30,'stackable','liquid','none',-1,10720,0,'true','true','true','true','rp_paradia_hood','recipe'),
(2238,'Recipe: Hood of Solar Eclipse','false','recipe',30,'stackable','liquid','none',-1,10720,0,'true','true','true','true','rp_hood_of_sola_eclipse','recipe'),
(2239,'Recipe: Hood of Summoning','false','recipe',30,'stackable','liquid','none',-1,10720,0,'true','true','true','true','rp_hood_of_summons','recipe'),
(2240,'Recipe: Elemental Hood','false','recipe',30,'stackable','liquid','none',-1,10720,0,'true','true','true','true','rp_elemental_hood','recipe'),
(2241,'Recipe: Hood of Grace','false','recipe',30,'stackable','liquid','none',-1,10720,0,'true','true','true','true','rp_hood_of_grace','recipe'),
(2242,'Recipe: Phoenix Hood','false','recipe',30,'stackable','liquid','none',-1,10720,0,'true','true','true','true','rp_phoenix\'s_hood','recipe'),
(2243,'Recipe: Hood of Aid','false','recipe',30,'stackable','liquid','none',-1,10720,0,'true','true','true','true','rp_hood_of_assistance','recipe'),
(2244,'Recipe: Flame Helm','false','recipe',30,'stackable','liquid','none',-1,10720,0,'true','true','true','true','rp_flame_bonnet','recipe'),
(2245,'Recipe: Tallum Helm','false','recipe',30,'stackable','liquid','none',-1,10720,0,'true','true','true','true','rp_tallum_bonnet','recipe'),
(2246,'Recipe: Helm of Avadon','false','recipe',30,'stackable','liquid','none',-1,10720,0,'true','true','true','true','rp_bonnet_o''_avadon','recipe'),
(2247,'Recipe: Helmet of Pledge','false','recipe',30,'stackable','liquid','none',-1,10720,0,'true','true','true','true','rp_helmet_of_pledge','recipe'),
(2248,'Recipe: Gauntlets of Ghost','false','recipe',30,'stackable','liquid','none',-1,7160,0,'true','true','true','true','rp_gauntlet_of_ghost','recipe'),
(2249,'Recipe: Adamantite Boots','false','recipe',30,'stackable','liquid','none',-1,7160,0,'true','true','true','true','rp_adamantite_boots','recipe'),
(2250,'Recipe: Bone Arrow','false','recipe',30,'stackable','liquid','none',-1,800,0,'true','true','true','true','rp_bone_arrow','recipe'),
(2251,'Recipe: Steel Arrow','false','recipe',30,'stackable','liquid','none',-1,1200,0,'true','true','true','true','rp_fine_steel_arrow','recipe'),
(2252,'Recipe: Iron Hammer','false','recipe',30,'stackable','liquid','none',-1,4880,0,'true','true','true','true','rp_iron_hammer','recipe'),
(2253,'Recipe: Sword Breaker','false','recipe',30,'stackable','liquid','none',-1,4880,0,'true','true','true','true','rp_sword_breaker','recipe'),
(2254,'Recipe: Composite Bow','false','recipe',30,'stackable','liquid','none',-1,4880,0,'true','true','true','true','rp_composition_bow','recipe'),
(2255,'Recipe: Saber','false','recipe',30,'stackable','liquid','none',-1,8180,0,'true','true','true','true','rp_saber','recipe'),
(2256,'Recipe: Assassin Knife','false','recipe',30,'stackable','liquid','none',-1,8180,0,'true','true','true','true','rp_assassin_knife','recipe'),
(2257,'Recipe: Trident','false','recipe',30,'stackable','liquid','none',-1,8180,0,'true','true','true','true','rp_trident','recipe'),
(2258,'Recipe: Temptation of Abyss','false','recipe',30,'stackable','liquid','none',-1,8180,0,'true','true','true','true','rp_temptation_of_abyss','recipe'),
(2259,'Recipe: Spinebone Sword','false','recipe',30,'stackable','liquid','none',-1,12880,0,'true','true','true','true','rp_spinebone_sword','recipe'),
(2260,'Recipe: Mace of Judgment','false','recipe',30,'stackable','liquid','none',-1,12880,0,'true','true','true','true','rp_mace_of_judgment','recipe'),
(2261,'Recipe: Conjuror\'s Staff','false','recipe',30,'stackable','liquid','none',-1,12880,0,'true','true','true','true','rp_conjure_staff','recipe'),
(2262,'Recipe: Elven Bow','false','recipe',30,'stackable','liquid','none',-1,12880,0,'true','true','true','true','rp_elven_bow','recipe'),
(2263,'Recipe: Dwarven Trident','false','recipe',30,'stackable','liquid','none',-1,12880,0,'true','true','true','true','rp_dwarven_trident','recipe'),
(2264,'Recipe: Two-handed Sword','false','recipe',30,'stackable','liquid','none',-1,19340,0,'true','true','true','true','rp_two-handed_sword','recipe'),
(2265,'Recipe: Spiked Club','false','recipe',30,'stackable','liquid','none',-1,19340,0,'true','true','true','true','rp_spike_club','recipe'),
(2266,'Recipe: Shilen Knife','false','recipe',30,'stackable','liquid','none',-1,19340,0,'true','true','true','true','rp_knife_o''_silenus','recipe'),
(2267,'Recipe: Gastraphetes','false','recipe',30,'stackable','liquid','none',-1,19340,0,'true','true','true','true','rp_gastraphetes','recipe'),
(2268,'Recipe: Tome of Blood','false','recipe',30,'stackable','liquid','none',-1,19340,0,'true','true','true','true','rp_tome_of_blood','recipe'),
(2269,'Recipe: Morning Star','false','recipe',30,'stackable','liquid','none',-1,28000,0,'true','true','true','true','rp_morning_star','recipe'),
(2270,'Recipe: Goat Head Staff','false','recipe',30,'stackable','liquid','none',-1,28000,0,'true','true','true','true','rp_goathead_staff','recipe'),
(2271,'Recipe: Winged Spear','false','recipe',30,'stackable','liquid','none',-1,28000,0,'true','true','true','true','rp_winged_spear','recipe'),
(2272,'Recipe: Sword of Revolution','false','recipe',30,'stackable','liquid','none',-1,28000,0,'true','true','true','true','rp_sword_of_revolution','recipe'),
(2273,'Recipe: Tarbar','false','recipe',30,'stackable','liquid','none',-1,28000,0,'true','true','true','true','rp_tarbar','recipe'),
(2274,'Recipe: Skull Breaker','false','recipe',30,'stackable','liquid','none',-1,28000,0,'true','true','true','true','rp_skull_breaker','recipe'),
(2275,'Recipe: Heavy Bone Club','false','recipe',30,'stackable','liquid','none',-1,28000,0,'true','true','true','true','rp_heavy_bone_club','recipe'),
(2276,'Recipe: Maingauche','false','recipe',30,'stackable','liquid','none',-1,28000,0,'true','true','true','true','rp_maingauche','recipe'),
(2277,'Recipe: Bich''hwa','false','recipe',30,'stackable','liquid','none',-1,28000,0,'true','true','true','true','rp_bich''hwa','recipe'),
(2278,'Recipe: Strengthened Long Bow','false','recipe',30,'stackable','liquid','none',-1,28000,0,'true','true','true','true','rp_strengthening_long_bow','recipe'),
(2279,'Recipe: War Pick','false','recipe',30,'stackable','liquid','none',-1,28000,0,'true','true','true','true','rp_hammer_in_flames','recipe'),
(2280,'Recipe: Crucifix of Blood','false','recipe',30,'stackable','liquid','none',-1,28000,0,'true','true','true','true','rp_crucifix_of_blood','recipe'),
(2281,'Recipe: Eye of Infinity','false','recipe',30,'stackable','liquid','none',-1,28000,0,'true','true','true','true','rp_eye_of_infinity','recipe'),
(2282,'Recipe: Cursed Maingauche','false','recipe',30,'stackable','liquid','none',-1,28000,0,'true','true','true','true','rp_cursed_maingauche','recipe'),
(2283,'Recipe: Blue Crystal Skull','false','recipe',30,'stackable','liquid','none',-1,30400,0,'true','true','true','true','rp_blue_crystal_skull','recipe'),
(2284,'Recipe: Demon Fangs','false','recipe',30,'stackable','liquid','none',-1,30400,0,'true','true','true','true','rp_demon_fangs','recipe'),
(2285,'Recipe: Claymore','false','recipe',30,'stackable','liquid','none',-1,36000,0,'true','true','true','true','rp_claymore','recipe'),
(2286,'Recipe: Bonebreaker','false','recipe',30,'stackable','liquid','none',-1,36000,0,'true','true','true','true','rp_bonebreaker','recipe'),
(2287,'Recipe: Atuba Hammer','false','recipe',30,'stackable','liquid','none',-1,36000,0,'true','true','true','true','rp_atuba_hammer','recipe'),
(2288,'Recipe: Ghost Staff','false','recipe',30,'stackable','liquid','none',-1,36000,0,'true','true','true','true','rp_ghost_staff','recipe'),
(2289,'Recipe: Staff of Life','false','recipe',30,'stackable','liquid','none',-1,36000,0,'true','true','true','true','rp_life_stick','recipe'),
(2290,'Recipe: Mithril Dagger','false','recipe',30,'stackable','liquid','none',-1,36000,0,'true','true','true','true','rp_mithril_dagger','recipe'),
(2291,'Recipe: Scallop Jamadhr','false','recipe',30,'stackable','liquid','none',-1,36000,0,'true','true','true','true','rp_scallop_jamadhr','recipe'),
(2292,'Recipe: Light Crossbow','false','recipe',30,'stackable','liquid','none',-1,36000,0,'true','true','true','true','rp_cyclone_bow','recipe'),
(2293,'Recipe: Glaive','false','recipe',30,'stackable','liquid','none',-1,36000,0,'true','true','true','true','rp_glaive','recipe'),
(2294,'Recipe: Vajra Wands','false','recipe',30,'stackable','liquid','none',-1,36000,0,'true','true','true','true','rp_vajra_wands','recipe'),
(2295,'Recipe: Ancient Reagent','false','recipe',30,'stackable','liquid','none',-1,36000,0,'true','true','true','true','rp_ancient_reagent','recipe'),
(2296,'Recipe: Atuba Mace','false','recipe',30,'stackable','liquid','none',-1,36000,0,'true','true','true','true','rp_atuba_mace','recipe'),
(2297,'Recipe: Flamberge','false','recipe',30,'stackable','liquid','none',-1,45800,0,'true','true','true','true','rp_flamberge','recipe'),
(2298,'Recipe: Stormbringer','false','recipe',30,'stackable','liquid','none',-1,45800,0,'true','true','true','true','rp_stormbringer','recipe'),
(2299,'Recipe: Big Hammer','false','recipe',30,'stackable','liquid','none',-1,45800,0,'true','true','true','true','rp_big_hammer','recipe'),
(2300,'Recipe: Scythe','false','recipe',30,'stackable','liquid','none',-1,45800,0,'true','true','true','true','rp_scythe','recipe'),
(2301,'Recipe: Battle Axe','false','recipe',30,'stackable','liquid','none',-1,45800,0,'true','true','true','true','rp_battle_axe','recipe'),
(2302,'Recipe: Silver Axe','false','recipe',30,'stackable','liquid','none',-1,45800,0,'true','true','true','true','rp_war_pick','recipe'),
(2303,'Recipe: Skull Graver','false','recipe',30,'stackable','liquid','none',-1,45800,0,'true','true','true','true','rp_skull_graver','recipe'),
(2304,'Recipe: Heavy Doom Hammer','false','recipe',30,'stackable','liquid','none',-1,45800,0,'true','true','true','true','rp_heavy_doom_hammer','recipe'),
(2305,'Recipe: Crystal Staff','false','recipe',30,'stackable','liquid','none',-1,45800,0,'true','true','true','true','rp_crystal_staff','recipe'),
(2306,'Recipe: Stick of Faith','false','recipe',30,'stackable','liquid','none',-1,45800,0,'true','true','true','true','rp_stick_of_faith','recipe'),
(2307,'Recipe: Heavy Doom Axe','false','recipe',30,'stackable','liquid','none',-1,45800,0,'true','true','true','true','rp_heavy_doom_axe','recipe'),
(2308,'Recipe: Cursed Dagger','false','recipe',30,'stackable','liquid','none',-1,45800,0,'true','true','true','true','rp_cursed_dagger','recipe'),
(2309,'Recipe: Wolverine Needle','false','recipe',30,'stackable','liquid','none',-1,45800,0,'true','true','true','true','rp_needle_wolverine','recipe'),
(2310,'Recipe: Dark Elven Dagger','false','recipe',30,'stackable','liquid','none',-1,45800,0,'true','true','true','true','rp_darkelven_dagger','recipe'),
(2311,'Recipe: Chakram','false','recipe',30,'stackable','liquid','none',-1,45800,0,'true','true','true','true','rp_chakram','recipe'),
(2312,'Recipe: Crystallized Ice Bow','false','recipe',30,'stackable','liquid','none',-1,45800,0,'true','true','true','true','rp_crystallized_ice_bow','recipe'),
(2313,'Recipe: Orcish Glaive','false','recipe',30,'stackable','liquid','none',-1,45800,0,'true','true','true','true','rp_orcish_glaive','recipe'),
(2314,'Recipe: Body Slasher','false','recipe',30,'stackable','liquid','none',-1,45800,0,'true','true','true','true','rp_body_slasher','recipe'),
(2315,'Recipe: Shamshir','false','recipe',30,'stackable','liquid','none',-1,57400,0,'true','true','true','true','rp_shamshir','recipe'),
(2316,'Recipe: Katana','false','recipe',30,'stackable','liquid','none',-1,57400,0,'true','true','true','true','rp_katana','recipe'),
(2317,'Recipe: Bec de Corbin','false','recipe',30,'stackable','liquid','none',-1,57400,0,'true','true','true','true','rp_bech_de_corbin','recipe'),
(2318,'Recipe: Spirit Sword','false','recipe',30,'stackable','liquid','none',-1,57400,0,'true','true','true','true','rp_spirits_sword','recipe'),
(2319,'Recipe: Raid Sword','false','recipe',30,'stackable','liquid','none',-1,57400,0,'true','true','true','true','rp_raid_sword','recipe'),
(2320,'Recipe: Cursed Staff','false','recipe',30,'stackable','liquid','none',-1,57400,0,'true','true','true','true','rp_cursed_staff','recipe'),
(2321,'Recipe: Stiletto','false','recipe',30,'stackable','liquid','none',-1,57400,0,'true','true','true','true','rp_stiletto','recipe'),
(2322,'Recipe: Soulfire Dirk','false','recipe',30,'stackable','liquid','none',-1,57400,0,'true','true','true','true','rp_dagger_of_magicflame','recipe'),
(2323,'Recipe: Elemental Bow','false','recipe',30,'stackable','liquid','none',-1,57400,0,'true','true','true','true','rp_elemental_bow','recipe'),
(2324,'Recipe: Elven Bow of Nobility','false','recipe',30,'stackable','liquid','none',-1,57400,0,'true','true','true','true','rp_noble_elven_bow','recipe'),
(2325,'Recipe: Tears of Fairy','false','recipe',30,'stackable','liquid','none',-1,57400,0,'true','true','true','true','rp_tears_of_fairy','recipe'),
(2326,'Recipe: Horn of Glory','false','recipe',30,'stackable','liquid','none',-1,57400,0,'true','true','true','true','rp_horn_of_glory','recipe'),
(2327,'Recipe: Caliburs','false','recipe',30,'stackable','liquid','none',-1,86000,0,'true','true','true','true','rp_caliburs','recipe'),
(2328,'Recipe: Sword of Delusion','false','recipe',30,'stackable','liquid','none',-1,86000,0,'true','true','true','true','rp_sword_of_delusion','recipe'),
(2329,'Recipe: Tsurugi','false','recipe',30,'stackable','liquid','none',-1,86000,0,'true','true','true','true','rp_tsurugi','recipe'),
(2330,'Recipe: Homunkulus\'s Sword','false','recipe',30,'stackable','liquid','none',-1,86000,0,'true','true','true','true','rp_homunkulus\'s_sword','recipe'),
(2331,'Recipe: Poleaxe','false','recipe',30,'stackable','liquid','none',-1,86000,0,'true','true','true','true','rp_poleaxe','recipe'),
(2332,'Recipe: Sword of Limit','false','recipe',30,'stackable','liquid','none',-1,86000,0,'true','true','true','true','rp_sword_of_limit','recipe'),
(2333,'Recipe: Sword of Nightmare','false','recipe',30,'stackable','liquid','none',-1,86000,0,'true','true','true','true','rp_sword_of_nightmare','recipe'),
(2334,'Recipe: Sword of Whispering Death','false','recipe',30,'stackable','liquid','none',-1,86000,0,'true','true','true','true','rp_deathbreath_sword','recipe'),
(2335,'Recipe: War Axe','false','recipe',30,'stackable','liquid','none',-1,86000,0,'true','true','true','true','rp_war_axe','recipe'),
(2336,'Recipe: Nirvana Axe','false','recipe',30,'stackable','liquid','none',-1,86000,0,'true','true','true','true','rp_nirvana_axe','recipe'),
(2337,'Recipe: Stick of Eternity','false','recipe',30,'stackable','liquid','none',-1,86000,0,'true','true','true','true','rp_stick_of_eternity','recipe'),
(2338,'Recipe: Paradia Staff','false','recipe',30,'stackable','liquid','none',-1,86000,0,'true','true','true','true','rp_paradia_staff','recipe'),
(2339,'Recipe: Inferno Staff','false','recipe',30,'stackable','liquid','none',-1,86000,0,'true','true','true','true','rp_inferno_staff','recipe'),
(2340,'Recipe: Pa''agrian Hammer','false','recipe',30,'stackable','liquid','none',-1,86000,0,'true','true','true','true','rp_paagrio_hammer','recipe'),
(2341,'Recipe: Sage\'s Staff','false','recipe',30,'stackable','liquid','none',-1,86000,0,'true','true','true','true','rp_sage\'s_staff','recipe'),
(2342,'Recipe: Club of Nature','false','recipe',30,'stackable','liquid','none',-1,86000,0,'true','true','true','true','rp_club_of_nature','recipe');
INSERT INTO `etcitem` VALUES 
(2343,'Recipe: Mace of the Underworld','false','recipe',30,'stackable','liquid','none',-1,86000,0,'true','true','true','true','rp_mace_of_underworld','recipe'),
(2344,'Recipe: Grace Dagger','false','recipe',30,'stackable','liquid','none',-1,86000,0,'true','true','true','true','rp_grace_dagger','recipe'),
(2345,'Recipe: Dark Screamer','false','recipe',30,'stackable','liquid','none',-1,86000,0,'true','true','true','true','rp_dark_screamer','recipe'),
(2346,'Recipe: Fisted Blade','false','recipe',30,'stackable','liquid','none',-1,86000,0,'true','true','true','true','rp_fist_blade','recipe'),
(2347,'Recipe: Akat Long Bow','false','recipe',30,'stackable','liquid','none',-1,86000,0,'true','true','true','true','rp_akat_long_bow','recipe'),
(2348,'Recipe: Heathen\'s Book','false','recipe',30,'stackable','liquid','none',-1,86000,0,'true','true','true','true','rp_heathen\'s_book','recipe'),
(2349,'Recipe: Hex Doll','false','recipe',30,'stackable','liquid','none',-1,86000,0,'true','true','true','true','rp_hex_doll','recipe'),
(2350,'Recipe: Pa''agrian Axe','false','recipe',30,'stackable','liquid','none',-1,95600,0,'true','true','true','true','rp_paagrio_axe','recipe'),
(2351,'Recipe: Scorpion','false','recipe',30,'stackable','liquid','none',-1,95600,0,'true','true','true','true','rp_scorpion','recipe'),
(2352,'Recipe: Widow Maker','false','recipe',30,'stackable','liquid','none',-1,95600,0,'true','true','true','true','rp_widow_maker','recipe'),
(2353,'Recipe: Samurai Longsword','false','recipe',30,'stackable','liquid','none',-1,122600,0,'true','true','true','true','rp_samurai_longsword','recipe'),
(2354,'Recipe: Deadman\'s Staff','false','recipe',30,'stackable','liquid','none',-1,122600,0,'true','true','true','true','rp_deadman\'s_staff','recipe'),
(2355,'Recipe: Ghoul\'s Staff','false','recipe',30,'stackable','liquid','none',-1,122600,0,'true','true','true','true','rp_ghoul\'s_staff','recipe'),
(2356,'Recipe: Demon\'s Staff','false','recipe',30,'stackable','liquid','none',-1,122600,0,'true','true','true','true','rp_demon\'s_staff','recipe'),
(2357,'Recipe: Crystal Dagger','false','recipe',30,'stackable','liquid','none',-1,122600,0,'true','true','true','true','rp_crystal_dagger','recipe'),
(2358,'Recipe: Great Pata','false','recipe',30,'stackable','liquid','none',-1,122600,0,'true','true','true','true','rp_great_pata','recipe'),
(2359,'Recipe: Eminence Bow','false','recipe',30,'stackable','liquid','none',-1,122600,0,'true','true','true','true','rp_eminence_bow','recipe'),
(2360,'Recipe: Orcish Poleaxe','false','recipe',30,'stackable','liquid','none',-1,122600,0,'true','true','true','true','rp_orcish_poleaxe','recipe'),
(2361,'Recipe: Candle of Wisdom','false','recipe',30,'stackable','liquid','none',-1,122600,0,'true','true','true','true','rp_candle_of_wisdom','recipe'),
(2362,'Recipe: Blessed Branch','false','recipe',30,'stackable','liquid','none',-1,122600,0,'true','true','true','true','rp_blessed_branch','recipe'),
(2363,'Recipe: Phoenix Feather','false','recipe',30,'stackable','liquid','none',-1,122600,0,'true','true','true','true','rp_phoenix\'s_feather','recipe'),
(2364,'Recipe: Cerberus Eye','false','recipe',30,'stackable','liquid','none',-1,122600,0,'true','true','true','true','rp_cerberus\'s_eye','recipe'),
(2365,'Recipe: Scroll of Destruction','false','recipe',30,'stackable','liquid','none',-1,122600,0,'true','true','true','true','rp_scroll_of_destruction','recipe'),
(2366,'Recipe: Claws of Black Dragon','false','recipe',30,'stackable','liquid','none',-1,122600,0,'true','true','true','true','rp_claws_of_blackdragon','recipe'),
(2367,'Recipe: Three Eyed Crow\'s Feather','false','recipe',30,'stackable','liquid','none',-1,122600,0,'true','true','true','true','rp_three_eye_crow\'s_feather','recipe'),
(2375,'Wolf Collar','false','pet_collar',10,'normal','leather','none',-1,0,0,'true','true','true','true','wolf_collar','pet_collar'),
(2508,'Cursed Bone','false','material',3,'stackable','liquid','none',-1,300,0,'true','true','true','true','cursed_bone','material'),
(2509,'Spiritshot: No Grade','false','shot',5,'stackable','paper','none',-1,15,0,'true','true','true','true','spiritshot_none','none'),
(2510,'Spiritshot: D-grade','false','shot',5,'stackable','paper','d',-1,18,0,'true','true','true','true','spiritshot_d','none'),
(2511,'Spiritshot: C-grade','false','shot',3,'stackable','paper','c',-1,35,0,'true','true','true','true','spiritshot_c','none'),
(2512,'Spiritshot: B-grade','false','shot',3,'stackable','paper','b',-1,100,0,'true','true','true','true','spiritshot_b','none'),
(2513,'Spiritshot: A-grade','false','shot',2,'stackable','paper','a',-1,120,0,'true','true','true','true','spiritshot_a','none'),
(2514,'Spiritshot: S-grade','false','shot',2,'stackable','paper','s',-1,150,0,'true','true','true','true','spiritshot_s','none'),
(2515,'Food For Wolves','false','none',10,'stackable','liquid','none',-1,100,0,'true','true','true','true','food_for_wolves','none'),
(2627,'Mark of Challenger','false','quest',0,'stackable','steel','none',-1,0,0,'false','false','true','false','mark_of_challenger','none'),
(2628,'Letter of Kash','false','quest',0,'stackable','steel','none',-1,0,0,'false','false','true','false','letter_of_kash','none'),
(2629,'Watcher\'s 1st Eye','false','quest',0,'stackable','steel','none',-1,0,0,'false','false','true','false','watchers_eye1','none'),
(2630,'Watcher\'s 2nd Eye','false','quest',0,'stackable','steel','none',-1,0,0,'false','false','true','false','watchers_eye2','none'),
(2631,'Scroll of Shyslassys','false','quest',0,'stackable','steel','none',-1,0,0,'false','false','true','false','scroll_of_shyslassy','none'),
(2632,'Broken Key','false','quest',0,'stackable','steel','none',-1,0,0,'false','false','true','false','broken_key','none'),
(2633,'Mark of Duty','false','quest',0,'stackable','steel','none',-1,0,0,'false','false','true','false','mark_of_duty','none'),
(2634,'Letter of Dustin','false','quest',0,'stackable','steel','none',-1,0,0,'false','false','true','false','letter_of_dustin','none'),
(2635,'Knights Tear','false','quest',0,'stackable','steel','none',-1,0,0,'false','false','true','false','knights_tear','none'),
(2636,'Mirror of Orpic','false','quest',0,'stackable','steel','none',-1,0,0,'false','false','true','false','mirror_of_orpic','none'),
(2637,'Tear of Confession','false','quest',0,'stackable','steel','none',-1,0,0,'false','false','true','false','tear_of_confession','none'),
(2638,'Report Piece','false','quest',0,'stackable','steel','none',-1,0,0,'false','false','true','false','report_piece','none'),
(2639,'Report Piece','false','quest',0,'stackable','steel','none',-1,0,0,'false','false','true','false','talianuss_report','none'),
(2640,'Tear of Loyalty','false','quest',0,'stackable','steel','none',-1,0,0,'false','false','true','false','tear_of_loyalty','none'),
(2641,'Militas Article','false','quest',0,'stackable','steel','none',-1,0,0,'false','false','true','false','militas_article','none'),
(2642,'Saints Ashes Urn','false','quest',0,'stackable','steel','none',-1,0,0,'false','false','true','false','saints_ashes_urn','none'),
(2643,'Athebaldt\'s Skull','false','quest',0,'stackable','steel','none',-1,0,0,'false','false','true','false','atebalts_skull','none'),
(2644,'Athebaldt\'s Ribs','false','quest',0,'stackable','steel','none',-1,0,0,'false','false','true','false','atebalts_ribs','none'),
(2645,'Athebaldt\'s Shin','false','quest',0,'stackable','steel','none',-1,0,0,'false','false','true','false','atebalts_shin','none'),
(2646,'Letter of Windawood','false','quest',0,'stackable','steel','none',-1,0,0,'false','false','true','false','letter_of_windawood','none'),
(2647,'Dufners Letter','false','quest',0,'stackable','steel','none',-1,0,0,'false','false','true','false','dufners_letter','none'),
(2648,'Terry\'s 1st Order','false','quest',0,'stackable','steel','none',-1,0,0,'false','false','true','false','terys_order1','none'),
(2649,'Terry\'s 2nd Order','false','quest',0,'stackable','steel','none',-1,0,0,'false','false','true','false','terys_order2','none'),
(2650,'Terry\'s Letter','false','quest',0,'stackable','steel','none',-1,0,0,'false','false','true','false','terys_letter','none'),
(2651,'Viktor\'s Letter','false','quest',0,'stackable','steel','none',-1,0,0,'false','false','true','false','viktors_letter','none'),
(2652,'Hawkeye\'s Letter','false','quest',0,'stackable','steel','none',-1,0,0,'false','false','true','false','hawkeyes_letter','none'),
(2653,'Mysterious Runestone','false','quest',0,'stackable','steel','none',-1,0,0,'false','false','true','false','mysterious_runestone','none'),
(2654,'Ol Mahum Runestone','false','quest',0,'stackable','steel','none',-1,0,0,'false','false','true','false','ol_mahum_runestone','none'),
(2655,'Turek Runestone','false','quest',0,'stackable','steel','none',-1,0,0,'false','false','true','false','turek_runestone','none'),
(2656,'Ant Runestone','false','quest',0,'stackable','steel','none',-1,0,0,'false','false','true','false','ant_runestone','none'),
(2657,'Turak Bugbear Runestone','false','quest',0,'stackable','steel','none',-1,0,0,'false','false','true','false','turak_bugbear_runestone','none'),
(2658,'Terry\'s Box','false','quest',0,'stackable','steel','none',-1,0,0,'false','false','true','false','terys_box','none'),
(2659,'Viktor\'s Request','false','quest',0,'stackable','steel','none',-1,0,0,'false','false','true','false','viktors_request','none'),
(2660,'Medusa Scales','false','quest',0,'stackable','steel','none',-1,0,0,'false','false','true','false','medusas_scales','none'),
(2661,'Shilen\'s Runestone','false','quest',0,'stackable','steel','none',-1,0,0,'false','false','true','false','silens_runestone','none'),
(2662,'Analysis Request','false','quest',0,'stackable','steel','none',-1,0,0,'false','false','true','false','analysis_request','none'),
(2663,'Marina\'s Letter','false','quest',0,'stackable','steel','none',-1,0,0,'false','false','true','false','marinas_letter','none'),
(2664,'Experiment Tools','false','quest',0,'stackable','steel','none',-1,0,0,'false','false','true','false','experiment_tools','none'),
(2665,'Analysis Result','false','quest',0,'stackable','steel','none',-1,0,0,'false','false','true','false','analysis_result','none'),
(2666,'Terry\'s 3rd Order','false','quest',0,'stackable','steel','none',-1,0,0,'false','false','true','false','terys_order3','none'),
(2667,'List of Host','false','quest',0,'stackable','steel','none',-1,0,0,'false','false','true','false','list_of_host','none'),
(2668,'Abyss Runestone','false','quest',0,'stackable','steel','none',-1,0,0,'false','false','true','false','abyss_runestone1','none'),
(2669,'Abyss Runestone','false','quest',0,'stackable','steel','none',-1,0,0,'false','false','true','false','abyss_runestone2','none'),
(2670,'Abyss Runestone','false','quest',0,'stackable','steel','none',-1,0,0,'false','false','true','false','abyss_runestone3','none'),
(2671,'Abyss Runestone','false','quest',0,'stackable','steel','none',-1,0,0,'false','false','true','false','abyss_runestone4','none'),
(2672,'Terry\'s Report','false','quest',0,'stackable','steel','none',-1,0,0,'false','false','true','false','terys_report','none'),
(2673,'Mark of Seeker','false','quest',0,'stackable','steel','none',-1,0,0,'false','false','true','false','mark_of_seeker','none'),
(2674,'Mark of Scholar','false','quest',0,'stackable','steel','none',-1,0,0,'false','false','true','false','mark_of_scholar','none'),
(2675,'Mirien\'s 1st Sigil','false','quest',0,'stackable','steel','none',-1,0,0,'false','false','true','false','miriens_sigil1','none'),
(2676,'Mirien\'s 2nd Sigil','false','quest',0,'stackable','steel','none',-1,0,0,'false','false','true','false','miriens_sigil2','none'),
(2677,'Mirien\'s 3rd Sigil','false','quest',0,'stackable','steel','none',-1,0,0,'false','false','true','false','miriens_sigil3','none'),
(2678,'Mirien\'s Instruction','false','quest',0,'stackable','steel','none',-1,0,0,'false','false','true','false','miriens_instruction','none'),
(2679,'Maria\'s 1st Letter','false','quest',0,'stackable','steel','none',-1,0,0,'false','false','true','false','maryas_letter1','none'),
(2680,'Maria\'s 2nd Letter','false','quest',0,'stackable','steel','none',-1,0,0,'false','false','true','false','maryas_letter2','none'),
(2681,'Lucas\'s Letter','false','quest',0,'stackable','steel','none',-1,0,0,'false','false','true','false','lukas_letter','none'),
(2682,'Lucilla\'s Handbag','false','quest',0,'stackable','steel','none',-1,0,0,'false','false','true','false','lucillas_handbag','none'),
(2683,'Creta\'s 1st Letter','false','quest',0,'stackable','steel','none',-1,0,0,'false','false','true','false','cretas_letter1','none'),
(2684,'Creta\'s Painting1','false','quest',0,'stackable','steel','none',-1,0,0,'false','false','true','false','cretas_painting1','none'),
(2685,'Creta\'s Painting2','false','quest',0,'stackable','steel','none',-1,0,0,'false','false','true','false','cretas_painting2','none'),
(2686,'Creta\'s Painting3','false','quest',0,'stackable','steel','none',-1,0,0,'false','false','true','false','cretas_painting3','none'),
(2687,'Brown Scroll Scrap','false','quest',0,'stackable','steel','none',-1,0,0,'false','false','true','false','brown_scroll_scrap','none'),
(2688,'Crystal of Purity','false','quest',0,'stackable','steel','none',-1,0,0,'false','false','true','false','crystal_of_purity1','none'),
(2689,'High Priest\'s Sigil','false','quest',0,'stackable','steel','none',-1,0,0,'false','false','true','false','highpriests_sigil','none'),
(2690,'Grand Magister\'s Sigil','false','quest',0,'stackable','steel','none',-1,0,0,'false','false','true','false','gmagisters_sigil','none'),
(2691,'Crono\'s Sigil','false','quest',0,'stackable','steel','none',-1,0,0,'false','false','true','false','cronos_sigil','none'),
(2692,'Sylvain\'s Letter','false','quest',0,'stackable','steel','none',-1,0,0,'false','false','true','false','sylvains_letter','none'),
(2693,'Symbol of Sylvain','false','quest',0,'stackable','steel','none',-1,0,0,'false','false','true','false','symbol_of_sylvain','none'),
(2694,'Jurek\'s List','false','quest',0,'stackable','steel','none',-1,0,0,'false','false','true','false','jureks_list','none'),
(2695,'Monster Eye Destroyer Skin','false','quest',0,'stackable','steel','none',-1,0,0,'false','false','true','false','beamers_skin','none'),
(2696,'Shaman\'s Necklace','false','quest',0,'stackable','steel','none',-1,0,0,'false','false','true','false','shamans_necklace','none'),
(2697,'Shackle\'s Scalp','false','quest',0,'stackable','steel','none',-1,0,0,'false','false','true','false','shackles_scalp','none'),
(2698,'Symbol of Jurek','false','quest',0,'stackable','steel','none',-1,0,0,'false','false','true','false','symbol_of_jurek','none'),
(2699,'Cronos Letter','false','quest',0,'stackable','steel','none',-1,0,0,'false','false','true','false','cronos_letter','none'),
(2700,'Dieter\'s Key','false','quest',0,'stackable','steel','none',-1,0,0,'false','false','true','false','dieters_key','none'),
(2701,'Creta\'s 2nd Letter','false','quest',0,'stackable','steel','none',-1,0,0,'false','false','true','false','cretas_letter2','none'),
(2702,'Dieter\'s Letter','false','quest',0,'stackable','steel','none',-1,0,0,'false','false','true','false','dieters_letter','none'),
(2703,'Dieter\'s Diary','false','quest',0,'stackable','steel','none',-1,0,0,'false','false','true','false','dieters_diary','none'),
(2704,'Raut\'s Letter Envelope','false','quest',0,'stackable','steel','none',-1,0,0,'false','false','true','false','rauts_letter_envelope','none'),
(2705,'Triff\'s Ring','false','quest',0,'stackable','steel','none',-1,0,0,'false','false','true','false','treafs_ring','none'),
(2706,'Scripture Chapter 1','false','quest',0,'stackable','steel','none',-1,0,0,'false','false','true','false','scripture_chapter_1','none'),
(2707,'Scripture Chapter 2','false','quest',0,'stackable','steel','none',-1,0,0,'false','false','true','false','scripture_chapter_2','none'),
(2708,'Scripture Chapter 3','false','quest',0,'stackable','steel','none',-1,0,0,'false','false','true','false','scripture_chapter_3','none'),
(2709,'Scripture Chapter 4','false','quest',0,'stackable','steel','none',-1,0,0,'false','false','true','false','scripture_chapter_4','none'),
(2710,'Valkon\'s Request','false','quest',0,'stackable','steel','none',-1,0,0,'false','false','true','false','valkons_request','none'),
(2711,'Poitan\'s Notes','false','quest',0,'stackable','steel','none',-1,0,0,'false','false','true','false','poitans_notes','none'),
(2712,'Scriptures of Knowledge','false','quest',0,'stackable','steel','none',-1,0,0,'false','false','true','false','scripture_of_knowledge','none'),
(2713,'Strong Liquor','false','quest',0,'stackable','steel','none',-1,0,0,'false','false','true','false','strong_liquor','none'),
(2714,'Crystal of Purity','false','quest',0,'stackable','steel','none',-1,0,0,'false','false','true','false','crystal_of_purity2','none'),
(2715,'Casian\'s List','false','quest',0,'stackable','steel','none',-1,0,0,'false','false','true','false','kasians_list','none'),
(2716,'Ghoul\'s Skin','false','quest',0,'stackable','steel','none',-1,0,0,'false','false','true','false','ghouls_skin','none'),
(2717,'Medusa\'s Blood','false','quest',0,'stackable','steel','none',-1,0,0,'false','false','true','false','medusas_blood','none'),
(2718,'Fettered Soul\'s Ichor','false','quest',0,'stackable','steel','none',-1,0,0,'false','false','true','false','fetteredsouls_ichor','none'),
(2719,'Enchanted Gargoyle\'s Nail','false','quest',0,'stackable','steel','none',-1,0,0,'false','false','true','false','encht_gargoyles_nail','none'),
(2720,'Symbol of Cronos','false','quest',0,'stackable','steel','none',-1,0,0,'false','false','true','false','symbol_of_cronos','none'),
(2721,'Mark of Pilgrim','false','quest',0,'stackable','steel','none',-1,0,0,'false','false','true','false','mark_of_pilgrim','none'),
(2722,'Book of Sage','false','quest',0,'stackable','steel','none',-1,0,0,'false','false','true','false','book_of_sage','none'),
(2723,'Voucher of Trial','false','quest',0,'stackable','steel','none',-1,0,0,'false','false','true','false','voucher_of_trial','none'),
(2724,'Spirit of Flame','false','quest',0,'stackable','steel','none',-1,0,0,'false','false','true','false','spirit_of_flame','none'),
(2725,'Essence of Flame','false','quest',0,'stackable','steel','none',-1,0,0,'false','false','true','false','essense_of_flame','none'),
(2726,'Book of Gerald','false','quest',0,'stackable','steel','none',-1,0,0,'false','false','true','false','book_of_gerald','none'),
(2727,'Gray Badge','false','quest',0,'stackable','steel','none',-1,0,0,'false','false','true','false','grey_badge','none'),
(2728,'Picture of Nahir','false','quest',0,'stackable','steel','none',-1,0,0,'false','false','true','false','picture_of_nahir','none'),
(2729,'Hair of Nahir','false','quest',0,'stackable','steel','none',-1,0,0,'false','false','true','false','hair_of_nahir','none'),
(2730,'Statue of Einhasad','false','quest',0,'stackable','steel','none',-1,0,0,'false','false','true','false','statue_of_Einhasad','none'),
(2731,'Book of Darkness','false','quest',0,'stackable','steel','none',-1,0,0,'false','false','true','false','book_of_darkness','none'),
(2732,'Debris of Willow','false','quest',0,'stackable','steel','none',-1,0,0,'false','false','true','false','debris_of_willow','none'),
(2733,'Tag of Rumor','false','quest',0,'stackable','steel','none',-1,0,0,'false','false','true','false','tag_of_rumor','none'),
(2734,'Mark of Trust','false','quest',0,'stackable','steel','none',-1,0,0,'false','false','true','false','mark_of_trust','none'),
(2735,'Letter to Elf','false','quest',0,'stackable','steel','none',-1,0,0,'false','false','true','false','letter_to_elf','none'),
(2736,'Letter to Darkelf','false','quest',0,'stackable','steel','none',-1,0,0,'false','false','true','false','letter_to_darkelf','none'),
(2737,'Letter to Dwarf','false','quest',0,'stackable','steel','none',-1,0,0,'false','false','true','false','letter_to_dwarf','none'),
(2738,'Letter to Orc','false','quest',0,'stackable','steel','none',-1,0,0,'false','false','true','false','letter_to_orc','none'),
(2739,'Letter to Seresin','false','quest',0,'stackable','steel','none',-1,0,0,'false','false','true','false','letter_to_seresin','none'),
(2740,'Scroll of Dark Elf Trust','false','quest',0,'stackable','steel','none',-1,0,0,'false','false','true','false','scroll_of_darkelf_trust','none'),
(2741,'Scroll of Elf Trust','false','quest',0,'stackable','steel','none',-1,0,0,'false','false','true','false','scroll_of_elf_trust','none'),
(2742,'Scroll of Dwarf Trust','false','quest',0,'stackable','steel','none',-1,0,0,'false','false','true','false','scroll_of_dwarf_trust','none'),
(2743,'Scroll of Orc Trust','false','quest',0,'stackable','steel','none',-1,0,0,'false','false','true','false','scroll_of_orc_trust','none'),
(2744,'Recommendation of Hollint','false','quest',0,'stackable','steel','none',-1,0,0,'false','false','true','false','recommendation_of_hollin','none'),
(2745,'Order of Asterios','false','quest',0,'stackable','steel','none',-1,0,0,'false','false','true','false','order_of_ozzy','none'),
(2746,'Breath of Winds','false','quest',0,'stackable','steel','none',-1,0,0,'false','false','true','false','breath_of_winds','none'),
(2747,'Seed of Verdure','false','quest',0,'stackable','steel','none',-1,0,0,'false','false','true','false','seed_of_verdure','none'),
(2748,'Letter from Thifiell','false','quest',0,'stackable','steel','none',-1,0,0,'false','false','true','false','letter_of_thifiell','none'),
(2749,'Blood of Guardian Basilisk','false','quest',0,'stackable','steel','none',-1,0,0,'false','false','true','false','blood_of_guardian_basilisk','none'),
(2750,'Giant Aphid','false','quest',0,'stackable','steel','none',-1,0,0,'false','false','true','false','giant_aphid','none'),
(2751,'Stakatos Fluids','false','quest',0,'stackable','steel','none',-1,0,0,'false','false','true','false','stakatos_fluids','none'),
(2752,'Basilisk Plasma','false','quest',0,'stackable','steel','none',-1,0,0,'false','false','true','false','basilisk_plasma','none'),
(2753,'Honey Dew','false','quest',0,'stackable','steel','none',-1,0,0,'false','false','true','false','honey_dew','none'),
(2754,'Stakato Ichor','false','quest',0,'stackable','steel','none',-1,0,0,'false','false','true','false','stakato_ichor','none'),
(2755,'Order of Clayton','false','quest',0,'stackable','steel','none',-1,0,0,'false','false','true','false','order_of_clayton','none'),
(2756,'Parasite of Lota','false','quest',0,'stackable','steel','none',-1,0,0,'false','false','true','false','parasite_of_lota','none'),
(2757,'Letter to Manakia','false','quest',0,'stackable','steel','none',-1,0,0,'false','false','true','false','letter_to_manakia','none'),
(2758,'Letter of Manakia','false','quest',0,'stackable','steel','none',-1,0,0,'false','false','true','false','letter_of_manakia','none'),
(2759,'Letter to Nikola','false','quest',0,'stackable','steel','none',-1,0,0,'false','false','true','false','letter_to_nichola','none'),
(2760,'Order of Nikola','false','quest',0,'stackable','steel','none',-1,0,0,'false','false','true','false','order_of_nichola','none'),
(2761,'Heartstone of Porta','false','quest',0,'stackable','steel','none',-1,0,0,'false','false','true','false','heart_of_porta','none'),
(2762,'Mark of Duelist','false','quest',0,'stackable','steel','none',-1,0,0,'false','false','true','false','mark_of_duelist','none'),
(2763,'Order Gludio','false','quest',0,'stackable','steel','none',-1,0,0,'false','false','true','false','order_gludio','none'),
(2764,'Order Dion','false','quest',0,'stackable','steel','none',-1,0,0,'false','false','true','false','order_dion','none'),
(2765,'Order Giran','false','quest',0,'stackable','steel','none',-1,0,0,'false','false','true','false','order_giran','none'),
(2766,'Order Oren','false','quest',0,'stackable','steel','none',-1,0,0,'false','false','true','false','order_oren','none'),
(2767,'Order Aden','false','quest',0,'stackable','steel','none',-1,0,0,'false','false','true','false','order_aden','none'),
(2768,'Puncher\'s Shard','false','quest',0,'stackable','steel','none',-1,0,0,'false','false','true','false','punchers_shard','none'),
(2769,'Noble Ant\'s Feeler','false','quest',0,'stackable','steel','none',-1,0,0,'false','false','true','false','noble_ants_feeler','none'),
(2770,'Drone\'s Chitin','false','quest',0,'stackable','steel','none',-1,0,0,'false','false','true','false','drones_chitin','none'),
(2771,'Dead Seeker Fang','false','quest',0,'stackable','steel','none',-1,0,0,'false','false','true','false','deadseeker_fang','none'),
(2772,'Overlord Necklace','false','quest',0,'stackable','steel','none',-1,0,0,'false','false','true','false','overlord_necklace','none'),
(2773,'Fettered Soul\'s Chain','false','quest',0,'stackable','steel','none',-1,0,0,'false','false','true','false','crimsonbinds_chain','none'),
(2774,'Chief\'s Amulet','false','quest',0,'stackable','steel','none',-1,0,0,'false','false','true','false','chiefs_amulet','none'),
(2775,'Enchanted Eye Meat','false','quest',0,'stackable','steel','none',-1,0,0,'false','false','true','false','tempered_eye_meat','none'),
(2776,'Tamrin Orc\'s Ring','false','quest',0,'stackable','steel','none',-1,0,0,'false','false','true','false','tamrin_orcs_ring','none'),
(2777,'Tamrin Orc\'s Arrow','false','quest',0,'stackable','steel','none',-1,0,0,'false','false','true','false','tamrin_orcs_arrow','none'),
(2778,'Final Order','false','quest',0,'stackable','steel','none',-1,0,0,'false','false','true','false','final_order','none'),
(2779,'Excuro\'s Skin','false','quest',0,'stackable','steel','none',-1,0,0,'false','false','true','false','excuros_skin','none'),
(2780,'Krator\'s Shard','false','quest',0,'stackable','steel','none',-1,0,0,'false','false','true','false','krators_shard','none'),
(2781,'Grandi\'s Skin','false','quest',0,'stackable','steel','none',-1,0,0,'false','false','true','false','grandis_skin','none'),
(2782,'Timak Orc\'s Belt','false','quest',0,'stackable','steel','none',-1,0,0,'false','false','true','false','timak_orcs_belt','none'),
(2783,'Lakin\'s Mace','false','quest',0,'stackable','steel','none',-1,0,0,'false','false','true','false','rakins_mace','none'),
(2784,'Luther\'s Letter','false','quest',0,'stackable','steel','none',-1,0,0,'false','false','true','false','luthers_letter','none'),
(2785,'Alex\'s Warrant','false','quest',0,'stackable','steel','none',-1,0,0,'false','false','true','false','alankells_warrant','none'),
(2786,'Leirynn\'s 1st Order','false','quest',0,'stackable','steel','none',-1,0,0,'false','false','true','false','leirynns_order1','none'),
(2787,'Delu Totem','false','quest',0,'stackable','steel','none',-1,0,0,'false','false','true','false','delu_totem','none'),
(2788,'Leirynn\'s 2nd Order','false','quest',0,'stackable','steel','none',-1,0,0,'false','false','true','false','leirynns_order2','none'),
(2789,'Chief Kalki\'s Fang','false','quest',0,'stackable','steel','none',-1,0,0,'false','false','true','false','chief_kalkis_fang','none'),
(2790,'Leirynn\'s Report','false','quest',0,'stackable','steel','none',-1,0,0,'false','false','true','false','leirynns_report','none'),
(2791,'Strange Map','false','quest',0,'stackable','steel','none',-1,0,0,'false','false','true','false','strange_map','none'),
(2792,'Lambert\'s Map','false','quest',0,'stackable','steel','none',-1,0,0,'false','false','true','false','lamberts_map','none'),
(2793,'Alex\'s Letter','false','quest',0,'stackable','steel','none',-1,0,0,'false','false','true','false','alankells_letter','none'),
(2794,'Alex\'s Order','false','quest',0,'stackable','steel','none',-1,0,0,'false','false','true','false','alankells_order','none'),
(2795,'Wine Catalog','false','quest',0,'stackable','steel','none',-1,0,0,'false','false','true','false','wine_catalog','none'),
(2796,'Tyra\'s Contract','false','quest',0,'stackable','steel','none',-1,0,0,'false','false','true','false','tweetys_contract','none'),
(2797,'Red Spore Dust','false','quest',0,'stackable','steel','none',-1,0,0,'false','false','true','false','red_spore_dust','none'),
(2798,'Malrukian Wine','false','quest',0,'stackable','steel','none',-1,0,0,'false','false','true','false','malrukian_wine','none'),
(2799,'Old Order','false','quest',0,'stackable','steel','none',-1,0,0,'false','false','true','false','old_order','none'),
(2800,'Jax\'s Diary','false','quest',0,'stackable','steel','none',-1,0,0,'false','false','true','false','rexs_diary','none'),
(2801,'1st Torn Map Piece','false','quest',0,'stackable','steel','none',-1,0,0,'false','false','true','false','torn_map_piece1','none'),
(2802,'2nd Torn Map Piece','false','quest',0,'stackable','steel','none',-1,0,0,'false','false','true','false','torn_map_piece2','none'),
(2803,'Solt\'s Map','false','quest',0,'stackable','steel','none',-1,0,0,'false','false','true','false','solts_map','none'),
(2804,'Makel\'s Map','false','quest',0,'stackable','steel','none',-1,0,0,'false','false','true','false','makels_map','none'),
(2805,'Combined Map','false','quest',0,'stackable','steel','none',-1,0,0,'false','false','true','false','combined_map','none'),
(2806,'Rusted Key','false','quest',0,'stackable','steel','none',-1,0,0,'false','false','true','false','rusted_key1','none'),
(2807,'Gold Bar','false','quest',0,'stackable','steel','none',-1,0,0,'false','false','true','false','gold_bar','none'),
(2808,'Alex\'s Recommend','false','quest',0,'stackable','steel','none',-1,0,0,'false','false','true','false','alankells_recommend','none'),
(2809,'Mark of Searcher','false','quest',0,'stackable','steel','none',-1,0,0,'false','false','true','false','mark_of_searcher','none'),
(2810,'Report of Perrin','false','quest',0,'stackable','steel','none',-1,0,0,'false','false','true','false','report_of_perrin','none'),
(2811,'Kristina\'s Letter','false','quest',0,'stackable','steel','none',-1,0,0,'false','false','true','false','cristinas_letter','none'),
(2812,'Picture of Windy','false','quest',0,'stackable','steel','none',-1,0,0,'false','false','true','false','picture_of_windy','none'),
(2813,'Golden Statue','false','quest',0,'stackable','steel','none',-1,0,0,'false','false','true','false','golden_statue','none'),
(2814,'Windy\'s Pebbles','false','quest',0,'stackable','steel','none',-1,0,0,'false','false','true','false','windys_pebbles','none'),
(2815,'Order of Sorius','false','quest',0,'stackable','steel','none',-1,0,0,'false','false','true','false','order_of_sorius','none'),
(2816,'1st Secret Letter','false','quest',0,'stackable','steel','none',-1,0,0,'false','false','true','false','secret_letter1','none'),
(2817,'2nd Secret Letter','false','quest',0,'stackable','steel','none',-1,0,0,'false','false','true','false','secret_letter2','none'),
(2818,'3rd Secret Letter','false','quest',0,'stackable','steel','none',-1,0,0,'false','false','true','false','secret_letter3','none'),
(2819,'4th Secret Letter','false','quest',0,'stackable','steel','none',-1,0,0,'false','false','true','false','secret_letter4','none'),
(2820,'Mark of Healer','false','quest',0,'stackable','steel','none',-1,0,0,'false','false','true','false','mark_of_healer','none'),
(2821,'Mark of Reformer','false','quest',0,'stackable','steel','none',-1,0,0,'false','false','true','false','mark_of_reformer','none'),
(2822,'Book of Reform','false','quest',0,'stackable','steel','none',-1,0,0,'false','false','true','false','book_of_reform','none'),
(2823,'Letter of Introduction','false','quest',0,'stackable','steel','none',-1,0,0,'false','false','true','false','letter_of_introduction','none'),
(2824,'Sla\'s Letter','false','quest',0,'stackable','steel','none',-1,0,0,'false','false','true','false','slas_letter','none'),
(2825,'Greetings','false','quest',0,'stackable','steel','none',-1,0,0,'false','false','true','false','greetings','none'),
(2826,'Ol Mahum\'s Money','false','quest',0,'stackable','steel','none',-1,0,0,'false','false','true','false','olmahums_money','none'),
(2827,'Katari\'s Letter','false','quest',0,'stackable','steel','none',-1,0,0,'false','false','true','false','kataris_letter','none'),
(2828,'Nyakuri\'s Letter','false','quest',0,'stackable','steel','none',-1,0,0,'false','false','true','false','nyakuris_letter','none'),
(2829,'Undead List','false','quest',0,'stackable','steel','none',-1,0,0,'false','false','true','false','undead_list','none'),
(2830,'Ramus\'s Letter','false','quest',0,'stackable','steel','none',-1,0,0,'false','false','true','false','ramuss_letter','none'),
(2831,'Ripped Diary','false','quest',0,'stackable','steel','none',-1,0,0,'false','false','true','false','ripped_diary','none'),
(2832,'Huge Nail','false','quest',0,'stackable','steel','none',-1,0,0,'false','false','true','false','huge_nail','none'),
(2833,'Letter of Betrayer','false','quest',0,'stackable','steel','none',-1,0,0,'false','false','true','false','letter_of_betrayer','none'),
(2834,'Bone Fragment','false','quest',0,'stackable','steel','none',-1,0,0,'false','false','true','false','bone_fragment4','none'),
(2835,'Bone Fragment','false','quest',0,'stackable','steel','none',-1,0,0,'false','false','true','false','bone_fragment5','none'),
(2836,'Bone Fragment','false','quest',0,'stackable','steel','none',-1,0,0,'false','false','true','false','bone_fragment6','none'),
(2837,'Bone Fragment','false','quest',0,'stackable','steel','none',-1,0,0,'false','false','true','false','bone_fragment7','none'),
(2838,'Bone Fragment','false','quest',0,'stackable','steel','none',-1,0,0,'false','false','true','false','bone_fragment8','none'),
(2839,'Bone Fragment','false','quest',0,'stackable','steel','none',-1,0,0,'false','false','true','false','bone_fragment9','none'),
(2840,'Mark of Magus','false','quest',0,'stackable','steel','none',-1,0,0,'false','false','true','false','mark_of_magus','none'),
(2841,'Rukal\'s Letter','false','quest',0,'stackable','steel','none',-1,0,0,'false','false','true','false','rukals_letter','none'),
(2842,'Parina\'s Letter','false','quest',0,'stackable','steel','none',-1,0,0,'false','false','true','false','parinas_letter','none'),
(2843,'Lilac Charm','false','quest',0,'stackable','steel','none',-1,0,0,'false','false','true','false','lilac_charm','none'),
(2844,'1st Golden Seed','false','quest',0,'stackable','steel','none',-1,0,0,'false','false','true','false','golden_seed1','none'),
(2845,'2nd Golden Seed','false','quest',0,'stackable','steel','none',-1,0,0,'false','false','true','false','golden_seed2','none'),
(2846,'3rd Golden Seed','false','quest',0,'stackable','steel','none',-1,0,0,'false','false','true','false','golden_seed3','none'),
(2847,'Score of Elements','false','quest',0,'stackable','steel','none',-1,0,0,'false','false','true','false','score_of_elements','none'),
(2848,'Dazzling Drop','false','quest',0,'stackable','steel','none',-1,0,0,'false','false','true','false','dazzling_drop','none'),
(2849,'Flame Crystal','false','quest',0,'stackable','steel','none',-1,0,0,'false','false','true','false','flame_crystal','none'),
(2850,'Harpy\'s Feather','false','quest',0,'stackable','steel','none',-1,0,0,'false','false','true','false','harpys_feather','none'),
(2851,'Wyrm\'s Wingbone','false','quest',0,'stackable','steel','none',-1,0,0,'false','false','true','false','wyrms_wingbone','none'),
(2852,'Windsus Mane','false','quest',0,'stackable','steel','none',-1,0,0,'false','false','true','false','windsus_mane','none'),
(2853,'Enchanted Monster Eye Shell','false','quest',0,'stackable','steel','none',-1,0,0,'false','false','true','false','en_monstereye_shell','none'),
(2854,'Enchanted Stone Golem Powder','false','quest',0,'stackable','steel','none',-1,0,0,'false','false','true','false','en_stonegolem_powder','none'),
(2855,'Enchanted Iron Golem Scrap','false','quest',0,'stackable','steel','none',-1,0,0,'false','false','true','false','en_irongolem_scrap','none'),
(2856,'Tone of Water','false','quest',0,'stackable','steel','none',-1,0,0,'false','false','true','false','tone_of_water','none'),
(2857,'Tone of Fire','false','quest',0,'stackable','steel','none',-1,0,0,'false','false','true','false','tone_of_fire','none'),
(2858,'Tone of Wind','false','quest',0,'stackable','steel','none',-1,0,0,'false','false','true','false','tone_of_wind','none'),
(2859,'Tone of Earth','false','quest',0,'stackable','steel','none',-1,0,0,'false','false','true','false','tone_of_earth','none'),
(2860,'Salamander Charm','false','quest',0,'stackable','steel','none',-1,0,0,'false','false','true','false','salamander_charm','none'),
(2861,'Sylph Charm','false','quest',0,'stackable','steel','none',-1,0,0,'false','false','true','false','sylph_charm','none'),
(2862,'Undine Charm','false','quest',0,'stackable','steel','none',-1,0,0,'false','false','true','false','undine_charm','none'),
(2863,'Serpent Charm','false','quest',0,'stackable','steel','none',-1,0,0,'false','false','true','false','serpent_charm','none'),
(2864,'Recommendation of Balanki','false','quest',0,'stackable','steel','none',-1,0,0,'false','false','true','false','recommendation_of_balanki','none'),
(2865,'Recommendation of Filaur','false','quest',0,'stackable','steel','none',-1,0,0,'false','false','true','false','recommendation_of_filaur','none'),
(2866,'Recommendation of Arin','false','quest',0,'stackable','steel','none',-1,0,0,'false','false','true','false','recommendation_of_arin','none'),
(2867,'Mark of Maestro','false','quest',0,'stackable','steel','none',-1,0,0,'false','false','true','false','mark_of_maestro','none'),
(2868,'Letter of Solder Detachment','false','quest',0,'stackable','steel','none',-1,0,0,'false','false','true','false','letter_of_solder_detachment','none'),
(2869,'Paint of Kamuru','false','quest',0,'stackable','steel','none',-1,0,0,'false','false','true','false','paint_of_kamuru','none'),
(2870,'Necklace of Kamuru','false','quest',0,'stackable','steel','none',-1,0,0,'false','false','true','false','necklace_of_kamuru','none'),
(2871,'Paint of Teleport Device','false','quest',0,'stackable','steel','none',-1,0,0,'false','false','true','false','paint_of_teleport_device','none'),
(2872,'Teleport Device','false','quest',0,'stackable','steel','none',-1,0,0,'false','false','false','false','teleport_device','none'),
(2873,'Architecture of Cruma','false','quest',0,'stackable','steel','none',-1,0,0,'false','false','true','false','architecture_of_kruma','none'),
(2874,'Report of Cruma','false','quest',0,'stackable','steel','none',-1,0,0,'false','false','true','false','report_of_kruma','none'),
(2875,'Ingredients of Antidote','false','quest',0,'stackable','steel','none',-1,0,0,'false','false','true','false','ingredients_of_antidote','none'),
(2876,'Stinger Wasp Needle','false','quest',0,'stackable','steel','none',-1,0,0,'false','false','true','false','weird_bees_needle','none'),
(2877,'Marsh Spider\'s Web','false','quest',0,'stackable','steel','none',-1,0,0,'false','false','true','false','marsh_spiders_web','none'),
(2878,'Blood of Leech','false','quest',0,'stackable','steel','none',-1,0,0,'false','false','true','false','blood_of_leech','none'),
(2879,'Mark of Warspirit','false','quest',0,'stackable','steel','none',-1,0,0,'false','false','true','false','mark_of_warspirit','none'),
(2880,'Vendetta Totem','false','quest',0,'stackable','steel','none',-1,0,0,'false','false','true','false','vendetta_totem','none'),
(2881,'Tamlin Orc Head','false','quest',0,'stackable','steel','none',-1,0,0,'false','false','true','false','tamlin_orc_head','none'),
(2882,'Warspirit Totem','false','quest',0,'stackable','steel','none',-1,0,0,'false','false','true','false','warspirit_totem','none'),
(2883,'Orim\'s Contract','false','quest',0,'stackable','steel','none',-1,0,0,'false','false','true','false','orims_contract','none'),
(2884,'Porta\'s Eye','false','quest',0,'stackable','steel','none',-1,0,0,'false','false','true','false','portas_eye','none'),
(2885,'Excuro\'s Scale','false','quest',0,'stackable','steel','none',-1,0,0,'false','false','true','false','excuros_scale','none'),
(2886,'Mordeos Talon','false','quest',0,'stackable','steel','none',-1,0,0,'false','false','true','false','mordeos_talon','none'),
(2887,'Braki\'s Remains','false','quest',0,'stackable','steel','none',-1,0,0,'false','false','true','false','brakis_remains1','none'),
(2888,'Pekiron\'s Totem','false','quest',0,'stackable','steel','none',-1,0,0,'false','false','true','false','pekirons_totem','none'),
(2889,'Tonar\'s Skull','false','quest',0,'stackable','steel','none',-1,0,0,'false','false','true','false','tonars_skull','none'),
(2890,'Tonar\'s Rib Bone','false','quest',0,'stackable','steel','none',-1,0,0,'false','false','true','false','tonars_rib_bone','none'),
(2891,'Tonar\'s Spine','false','quest',0,'stackable','steel','none',-1,0,0,'false','false','true','false','tonars_spine','none'),
(2892,'Tonar\'s Arm Bone','false','quest',0,'stackable','steel','none',-1,0,0,'false','false','true','false','tonars_arm_bone','none'),
(2893,'Tonar\'s Thigh Bone','false','quest',0,'stackable','steel','none',-1,0,0,'false','false','true','false','tonars_thigh_bone','none'),
(2894,'Tonar\'s Remains','false','quest',0,'stackable','steel','none',-1,0,0,'false','false','true','false','tonars_remains1','none'),
(2895,'Manakia\'s Totem','false','quest',0,'stackable','steel','none',-1,0,0,'false','false','true','false','manakias_totem','none'),
(2896,'Hermodt\'s Skull','false','quest',0,'stackable','steel','none',-1,0,0,'false','false','true','false','hermodts_skull','none'),
(2897,'Hermodt\'s Rib Bone','false','quest',0,'stackable','steel','none',-1,0,0,'false','false','true','false','hermodts_rib_bone','none'),
(2898,'Hermodt\'s Spine','false','quest',0,'stackable','steel','none',-1,0,0,'false','false','true','false','hermodts_spine','none'),
(2899,'Hermodt\'s Arm Bone','false','quest',0,'stackable','steel','none',-1,0,0,'false','false','true','false','hermodts_arm_bone','none'),
(2900,'Hermodt\'s Thigh Bone','false','quest',0,'stackable','steel','none',-1,0,0,'false','false','true','false','hermodts_thigh_bone','none'),
(2901,'Hermodt\'s Remains','false','quest',0,'stackable','steel','none',-1,0,0,'false','false','true','false','hermodts_remains1','none'),
(2902,'Racoy\'s Totem','false','quest',0,'stackable','steel','none',-1,0,0,'false','false','true','false','racoys_totem','none'),
(2903,'Vivyan\'s Letter','false','quest',0,'stackable','steel','none',-1,0,0,'false','false','true','false','viviantes_letter','none'),
(2904,'Insect Diagram Book','false','quest',0,'stackable','steel','none',-1,0,0,'false','false','true','false','insect_diagram_book','none'),
(2905,'Kiruna\'s Skull','false','quest',0,'stackable','steel','none',-1,0,0,'false','false','true','false','kirunas_skull','none'),
(2906,'Kiruna\'s Rib Bone','false','quest',0,'stackable','steel','none',-1,0,0,'false','false','true','false','kirunas_rib_bone','none'),
(2907,'Kiruna\'s Spine','false','quest',0,'stackable','steel','none',-1,0,0,'false','false','true','false','kirunas_spine','none'),
(2908,'Kiruna\'s Arm Bone','false','quest',0,'stackable','steel','none',-1,0,0,'false','false','true','false','kirunas_arm_bone','none'),
(2909,'Kiruna\'s Thigh Bone','false','quest',0,'stackable','steel','none',-1,0,0,'false','false','true','false','kirunas_thigh_bone','none'),
(2910,'Kiruna\'s Remains','false','quest',0,'stackable','steel','none',-1,0,0,'false','false','true','false','kirunas_remains1','none'),
(2911,'Braki\'s Remains','false','quest',0,'stackable','steel','none',-1,0,0,'false','false','true','false','brakis_remains2','none'),
(2912,'Tonar\'s Remains','false','quest',0,'stackable','steel','none',-1,0,0,'false','false','true','false','tonars_remains2','none'),
(2913,'Hermodt\'s Remains','false','quest',0,'stackable','steel','none',-1,0,0,'false','false','true','false','hermodts_remains2','none'),
(2914,'Kiruna\'s Remains','false','quest',0,'stackable','steel','none',-1,0,0,'false','false','true','false','kirunas_remains2','none'),
(2916,'Broken Teleport Device','false','quest',0,'stackable','steel','none',-1,0,0,'false','false','true','false','broken_teleport_device','none'),
(2917,'Ring of Binding Gemstone','false','material',60,'stackable','liquid','none',-1,3482,0,'true','true','true','true','ring_of_binding_gemstone','material'),
(2918,'Mithril Scale Gaiters Material','false','material',60,'stackable','liquid','none',-1,3371,0,'true','true','true','true','mithril_scale_gaiters_material','material'),
(2919,'Brigandine Gaiters Material','false','material',60,'stackable','liquid','none',-1,3371,0,'true','true','true','true','brigandine_gaiters_material','material'),
(2920,'Elven Mithril Tunic Pattern','false','material',60,'stackable','liquid','none',-1,3921,0,'true','true','true','true','elven_mithril_tunic_pattern','material'),
(2921,'Elven Mithril Stockings Pattern','false','material',60,'stackable','liquid','none',-1,2518,0,'true','true','true','true','elven_mithril_hose_pattern','material'),
(2922,'Brigandine Helmet Design','false','material',60,'stackable','liquid','none',-1,5193,0,'true','true','true','true','brigandine_helmet_design','material'),
(2923,'Manticore Skin Boot Lining','false','material',60,'stackable','liquid','none',-1,1480,0,'true','true','true','true','manticor_skin_boots_lining','material'),
(2924,'Brigandine Boots Design','false','material',60,'stackable','liquid','none',-1,1480,0,'true','true','true','true','brigandine_boots_design','material'),
(2925,'Elven Mithril Boots Design','false','material',60,'stackable','liquid','none',-1,1480,0,'true','true','true','true','elven_mithril_boots_design','material'),
(2926,'Manticore Skin Gloves Lining','false','material',60,'stackable','liquid','none',-1,1480,0,'true','true','true','true','manticor_skin_gloves_linging','material'),
(2927,'Brigandine Gauntlets Pattern','false','material',60,'stackable','liquid','none',-1,1480,0,'true','true','true','true','brigandine_gauntlet_pattern','material'),
(2928,'Elven Mithril Gloves Design','false','material',60,'stackable','liquid','none',-1,1480,0,'true','true','true','true','elven_mithril_gloves_design','material'),
(2929,'Brigandine Shield Fragment','false','material',60,'stackable','liquid','none',-1,1389,0,'true','true','true','true','brigandine_shield_fragment','material'),
(2930,'Plate Helmet Design','false','material',60,'stackable','liquid','none',-1,2481,0,'true','true','true','true','plate_helmet_design','material'),
(2931,'Salamander Skin Boot Lining','false','material',60,'stackable','liquid','none',-1,1792,0,'true','true','true','true','slamander_skin_boots_lining','material'),
(2932,'Plate Boots Design','false','material',60,'stackable','liquid','none',-1,1792,0,'true','true','true','true','plate_boots_design','material'),
(2933,'Sage\'s Worn Gloves Lining','false','material',60,'stackable','liquid','none',-1,1792,0,'true','true','true','true','sage\'s_worn_gloves_lining','material'),
(2934,'Plate Shield Fragment','false','material',60,'stackable','liquid','none',-1,1762,0,'true','true','true','true','plate_shield_fragment','material'),
(2935,'Tempered Mithril Gaiters Fragment','false','material',60,'stackable','liquid','none',-1,3763,0,'true','true','true','true','tempered_mithril_gaiters_fragment','material'),
(2936,'Chain Hood Pattern','false','material',60,'stackable','liquid','none',-1,2725,0,'true','true','true','true','chain_hood_pattern','material'),
(2937,'Chain Boots Part','false','material',60,'stackable','liquid','none',-1,2225,0,'true','true','true','true','chain_boots_part','material'),
(2938,'Karmian Boots Fabric','false','material',60,'stackable','liquid','none',-1,2225,0,'true','true','true','true','karmian_boots_fabric','material'),
(2939,'Plate Leather Boot Lining','false','material',60,'stackable','liquid','none',-1,2225,0,'true','true','true','true','plate_leather_boots_lining','material'),
(2940,'Dwarven Chain Boots Part','false','material',60,'stackable','liquid','none',-1,2225,0,'true','true','true','true','dwarven_chain_boots_part','material'),
(2941,'Boots of Seal Pattern','false','material',60,'stackable','liquid','none',-1,2225,0,'true','true','true','true','boots_of_seal_pattern','material'),
(2942,'Reinforced Mithril Gloves Design','false','material',60,'stackable','liquid','none',-1,2225,0,'true','true','true','true','reinforce_mithril_gloves_design','material'),
(2943,'Chain Gloves Design','false','material',60,'stackable','liquid','none',-1,2225,0,'true','true','true','true','chain_gloves_design','material'),
(2944,'Karmian Gloves Fabric','false','material',60,'stackable','liquid','none',-1,2225,0,'true','true','true','true','karmian_gloves_fabric','material'),
(2945,'Chain Shield Fragment','false','material',60,'stackable','liquid','none',-1,2475,0,'true','true','true','true','chain_shield_fragment','material'),
(2946,'Plate Leather Gloves Design','false','material',60,'stackable','liquid','none',-1,3578,0,'true','true','true','true','plate_leather_gloves_design','material'),
(2947,'Dwarven Chain Shield Fragment','false','material',60,'stackable','liquid','none',-1,2800,0,'true','true','true','true','dwarven_chain_shield_fragment','material'),
(2948,'Rind Leather Boot Lining','false','material',60,'stackable','liquid','none',-1,2378,0,'true','true','true','true','rind_leather_boots_lining','material'),
(2949,'Dwarven Chain Gloves Design','false','material',60,'stackable','liquid','none',-1,2378,0,'true','true','true','true','dwarven_chain_gloves_design','material'),
(2950,'Gloves of Seal Pattern','false','material',60,'stackable','liquid','none',-1,2378,0,'true','true','true','true','gloves_of_seal_pattern','material'),
(2951,'Rind Leather Gloves Design','false','material',60,'stackable','liquid','none',-1,2378,0,'true','true','true','true','rind_leather_gloves_design','material'),
(2952,'Demon\'s Boots Fabric','false','material',60,'stackable','liquid','none',-1,3400,0,'true','true','true','true','demon\'s_boots_fabric','material'),
(2953,'Demon\'s Gloves Fabric','false','material',60,'stackable','liquid','none',-1,3400,0,'true','true','true','true','demon\'s_gloves_fabric','material'),
(2954,'Theca Leather Boots Texture','false','material',60,'stackable','liquid','none',-1,3160,0,'true','true','true','true','theca_leather_boots_texture','material'),
(2955,'Theca Leather Gloves Texture','false','material',60,'stackable','liquid','none',-1,3160,0,'true','true','true','true','theca_leather_gloves_texture','material'),
(2956,'Composite Boots Part','false','material',60,'stackable','liquid','none',-1,3400,0,'true','true','true','true','composite_boots_part','material'),
(2957,'Composite Helmet Design','false','material',60,'stackable','liquid','none',-1,4560,0,'true','true','true','true','composite_helmet_design','material'),
(2958,'Divine Boots Fabric','false','material',60,'stackable','liquid','none',-1,3673,0,'true','true','true','true','divine_boots_fabric','material'),
(2959,'Full Plate Helmet Design','false','material',60,'stackable','liquid','none',-1,5782,0,'true','true','true','true','full_plate_helmet_design','material'),
(2960,'Drake Leather Boots Design','false','material',60,'stackable','liquid','none',-1,3673,0,'true','true','true','true','drake_leather_boots_design','material'),
(2961,'Full Plate Boots Part','false','material',60,'stackable','liquid','none',-1,3673,0,'true','true','true','true','full_plate_boots_part','material'),
(2962,'Drake Leather Gloves Design','false','material',60,'stackable','liquid','none',-1,3673,0,'true','true','true','true','drake_leather_gloves_design','material'),
(2963,'Full Plate Gauntlets Part','false','material',60,'stackable','liquid','none',-1,3673,0,'true','true','true','true','full_plate_gauntlet_part','material'),
(2964,'Divine Gloves Pattern','false','material',60,'stackable','liquid','none',-1,3673,0,'true','true','true','true','blessed_gloves_pattern','material'),
(2965,'Blessed Gloves Design','false','material',60,'stackable','liquid','none',-1,3673,0,'true','true','true','true','divine_gloves_design','material'),
(2966,'Full Plate Shield Fragment','false','material',60,'stackable','liquid','none',-1,3655,0,'true','true','true','true','full_plate_shield_fragment','material'),
(2967,'Elven Long Sword Blade','false','material',60,'stackable','liquid','none',-1,23062,0,'true','true','true','true','elven_long_sword_blade','material'),
(2968,'Dwarven Warhammer Head','false','material',60,'stackable','liquid','none',-1,30067,0,'true','true','true','true','dwarven_warhammer_head','material'),
(2969,'Yaksa Mace Head','false','material',60,'stackable','liquid','none',-1,38364,0,'true','true','true','true','yaksa_mace_head','material'),
(2970,'Recipe: Ring of Binding','false','recipe',30,'stackable','liquid','none',-1,5640,0,'true','true','true','true','rp_ring_of_binding','recipe'),
(2971,'Recipe: Mithril Scale Gaiters','false','recipe',30,'stackable','liquid','none',-1,3740,0,'true','true','true','true','rp_mithril_scale_gaiters','recipe'),
(2972,'Recipe: Brigandine Gaiters','false','recipe',30,'stackable','liquid','none',-1,3740,0,'true','true','true','true','rp_brigandine_gaiters','recipe'),
(2973,'Recipe: Elven Mithril Tunic','false','recipe',30,'stackable','liquid','none',-1,4480,0,'true','true','true','true','rp_elven_mithril_tunic','recipe'),
(2974,'Recipe: Elven Mithril Stockings','false','recipe',30,'stackable','liquid','none',-1,2800,0,'true','true','true','true','rp_elven_mithril_hose','recipe'),
(2975,'Recipe: Brigandine Helmet','false','recipe',30,'stackable','liquid','none',-1,2240,0,'true','true','true','true','rp_brigandine_helmet','recipe'),
(2976,'Recipe: Manticore Skin Boots','false','recipe',30,'stackable','liquid','none',-1,1494,0,'true','true','true','true','rp_manticor_skin_boots','recipe'),
(2977,'Recipe: Brigandine Boots','false','recipe',30,'stackable','liquid','none',-1,1494,0,'true','true','true','true','rp_brigandine_boots','recipe'),
(2978,'Recipe: Elven Mithril Boots','false','recipe',30,'stackable','liquid','none',-1,1494,0,'true','true','true','true','rp_elven_mithril_boots','recipe'),
(2979,'Recipe: Manticore Skin Gloves','false','recipe',30,'stackable','liquid','none',-1,1494,0,'true','true','true','true','rp_manticor_skin_gloves','recipe'),
(2980,'Recipe: Brigandine Gauntlets','false','recipe',30,'stackable','liquid','none',-1,1494,0,'true','true','true','true','rp_brigandine_gauntlet','recipe'),
(2981,'Recipe: Elven Mithril Gloves','false','recipe',30,'stackable','liquid','none',-1,1494,0,'true','true','true','true','rp_elven_mithril_gloves','recipe'),
(2982,'Recipe: Brigandine Shield','false','recipe',30,'stackable','liquid','none',-1,1568,0,'true','true','true','true','rp_brigandine_shield','recipe'),
(2983,'Recipe: Plate Helmet','false','recipe',30,'stackable','liquid','none',-1,2940,0,'true','true','true','true','rp_plate_helmet','recipe'),
(2984,'Recipe: Salamander Skin Boots','false','recipe',30,'stackable','liquid','none',-1,1956,0,'true','true','true','true','rp_slamander_skin_boots','recipe'),
(2985,'Recipe: Plate Boots','false','recipe',30,'stackable','liquid','none',-1,1956,0,'true','true','true','true','rp_plate_boots','recipe'),
(2986,'Recipe: Sage\'s Worn Gloves','false','recipe',30,'stackable','liquid','none',-1,1956,0,'true','true','true','true','rp_sage\'s_worn_gloves','recipe'),
(2987,'Recipe: Plate Shield','false','recipe',30,'stackable','liquid','none',-1,2060,0,'true','true','true','true','rp_plate_shield','recipe'),
(2988,'Recipe: Tempered Mithril Gaiters','false','recipe',30,'stackable','liquid','none',-1,4740,0,'true','true','true','true','rp_tempered_mithril_gaiters','recipe'),
(2989,'Recipe: Chain Hood','false','recipe',30,'stackable','liquid','none',-1,3780,0,'true','true','true','true','rp_chain_hood','recipe'),
(2990,'Recipe: Chain Boots','false','recipe',30,'stackable','liquid','none',-1,2520,0,'true','true','true','true','rp_chain_boots','recipe'),
(2991,'Recipe: Karmian Boots','false','recipe',30,'stackable','liquid','none',-1,2520,0,'true','true','true','true','rp_karmian_boots','recipe'),
(2992,'Recipe: Plated Leather Boots','false','recipe',30,'stackable','liquid','none',-1,2520,0,'true','true','true','true','rp_plate_leather_boots','recipe'),
(2993,'Recipe: Dwarven Chain Boots','false','recipe',30,'stackable','liquid','none',-1,2520,0,'true','true','true','true','rp_dwarven_chain_boots','recipe'),
(2994,'Recipe: Boots of Seal','false','recipe',30,'stackable','liquid','none',-1,2520,0,'true','true','true','true','rp_boots_of_seal','recipe'),
(2995,'Recipe: Reinforced Mithril Gloves','false','recipe',30,'stackable','liquid','none',-1,2520,0,'true','true','true','true','rp_reinforce_mithril_gloves','recipe'),
(2996,'Recipe: Chain Gloves','false','recipe',30,'stackable','liquid','none',-1,2520,0,'true','true','true','true','rp_chain_gloves','recipe'),
(2997,'Recipe: Karmian Gloves','false','recipe',30,'stackable','liquid','none',-1,2520,0,'true','true','true','true','rp_karmian_gloves','recipe'),
(2998,'Recipe: Chain Shield','false','recipe',30,'stackable','liquid','none',-1,2660,0,'true','true','true','true','rp_chain_shield','recipe'),
(2999,'Recipe: Plated Leather Gloves','false','recipe',30,'stackable','liquid','none',-1,2980,0,'true','true','true','true','rp_plate_leather_gloves','recipe'),
(3000,'Recipe: Dwarven Chain Shield','false','recipe',30,'stackable','liquid','none',-1,3120,0,'true','true','true','true','rp_dwarven_chain_shield','recipe'),
(3001,'Recipe: Rind Leather Boots','false','recipe',30,'stackable','liquid','none',-1,3220,0,'true','true','true','true','rp_rind_leather_boots','recipe'),
(3002,'Recipe: Dwarven Chain Gloves','false','recipe',30,'stackable','liquid','none',-1,3220,0,'true','true','true','true','rp_dwarven_chain_gloves','recipe'),
(3003,'Recipe: Gloves of Seal','false','recipe',30,'stackable','liquid','none',-1,3220,0,'true','true','true','true','rp_gloves_of_seal','recipe'),
(3004,'Recipe: Rind Leather Gloves','false','recipe',30,'stackable','liquid','none',-1,3220,0,'true','true','true','true','rp_rind_leather_gloves','recipe'),
(3005,'Recipe: Demon\'s Boots','false','recipe',30,'stackable','liquid','none',-1,4900,0,'true','true','true','true','rp_demon\'s_boots','recipe'),
(3006,'Recipe: Demon\'s Gloves','false','recipe',30,'stackable','liquid','none',-1,4900,0,'true','true','true','true','rp_demon\'s_gloves','recipe'),
(3007,'Recipe: Theca Leather Boots','false','recipe',30,'stackable','liquid','none',-1,5500,0,'true','true','true','true','rp_theca_leather_boots','recipe'),
(3008,'Recipe: Theca Leather Gloves','false','recipe',30,'stackable','liquid','none',-1,5500,0,'true','true','true','true','rp_theca_leather_gloves','recipe'),
(3009,'Recipe: Composite Boots','false','recipe',30,'stackable','liquid','none',-1,4900,0,'true','true','true','true','rp_composite_boots','recipe'),
(3010,'Recipe: Composite Helmet','false','recipe',30,'stackable','liquid','none',-1,7360,0,'true','true','true','true','rp_composite_helmet','recipe'),
(3011,'Recipe: Divine Boots','false','recipe',30,'stackable','liquid','none',-1,7160,0,'true','true','true','true','rp_divine_boots','recipe'),
(3012,'Recipe: Full Plate Helmet','false','recipe',30,'stackable','liquid','none',-1,10720,0,'true','true','true','true','rp_full_plate_helmet','recipe'),
(3013,'Recipe: Drake Leather Boots','false','recipe',30,'stackable','liquid','none',-1,7160,0,'true','true','true','true','rp_drake_leather_boots','recipe'),
(3014,'Recipe: Full Plate Boots','false','recipe',30,'stackable','liquid','none',-1,7160,0,'true','true','true','true','rp_full_plate_boots','recipe'),
(3015,'Recipe: Drake Leather Gloves','false','recipe',30,'stackable','liquid','none',-1,7160,0,'true','true','true','true','rp_drake_leather_gloves','recipe'),
(3016,'Recipe: Full Plate Gauntlets','false','recipe',30,'stackable','liquid','none',-1,7160,0,'true','true','true','true','rp_full_plate_gauntlet','recipe'),
(3017,'Recipe: Divine Gloves','false','recipe',30,'stackable','liquid','none',-1,7160,0,'true','true','true','true','rp_blessed_gloves','recipe'),
(3018,'Recipe: Blessed Gloves','false','recipe',30,'stackable','liquid','none',-1,7160,0,'true','true','true','true','rp_divine_gloves','recipe'),
(3019,'Recipe: Full Plate Shield','false','recipe',30,'stackable','liquid','none',-1,7500,0,'true','true','true','true','rp_full_plate_shield','recipe'),
(3020,'Recipe: Elven Long Sword','false','recipe',30,'stackable','liquid','none',-1,36000,0,'true','true','true','true','rp_elven_long_sword','recipe'),
(3021,'Recipe: Dwarven War Hammer','false','recipe',30,'stackable','liquid','none',-1,57400,0,'true','true','true','true','rp_dwarven_warhammer','recipe'),
(3022,'Recipe: Yaksa Mace','false','recipe',30,'stackable','liquid','none',-1,122600,0,'true','true','true','true','rp_yaksa_mace','recipe'),
(3023,'Recipe: Titan Key','false','recipe',30,'stackable','liquid','none',-1,0,0,'false','false','false','false','rp_titan_key','recipe'),
(3024,'Recipe: Journeyman Ring','false','recipe',30,'stackable','liquid','none',-1,0,0,'false','false','false','false','rp_journeyman_ring','recipe'),
(3025,'Recipe: Amber Bead','false','recipe',30,'stackable','liquid','none',-1,0,0,'false','false','false','false','rp_amber_bead','recipe'),
(3030,'Key of Titan','false','none',10,'stackable','bronze','none',-1,0,0,'true','true','true','true','key_of_titan','none'),
(3031,'Spirit Ore','false','material',5,'stackable','liquid','none',-1,400,0,'true','true','true','true','spirit_ore','material'),
(3032,'Recipe: Spiritshot D','false','recipe',30,'stackable','liquid','none',-1,5000,0,'true','true','true','true','rp_spiritshot_d','recipe'),
(3033,'Recipe: Spiritshot C','false','recipe',30,'stackable','liquid','none',-1,60000,0,'true','true','true','true','rp_spiritshot_c','recipe'),
(3034,'Recipe: Spiritshot B','false','recipe',30,'stackable','liquid','none',-1,100000,0,'true','true','true','true','rp_spiritshot_b','recipe'),
(3035,'Recipe: Spiritshot A','false','recipe',30,'stackable','liquid','none',-1,150000,0,'true','true','true','true','rp_spiritshot_a','recipe'),
(3036,'Recipe: Spiritshot S','false','recipe',30,'stackable','liquid','none',-1,450000,0,'true','true','true','true','rp_spiritshot_s','recipe'),
(3037,'Kakan\'s Letter','false','quest',0,'stackable','steel','none',-1,0,0,'false','false','true','false','kakans_letter','none'),
(3038,'Blueprint: Summon Mechanic Golem','false','spellbook',120,'stackable','paper','none',-1,1550,0,'true','true','true','true','sb_summon_mechanic_golem1','none'),
(3039,'Spellbook: Summon Storm Cubic','false','spellbook',120,'stackable','paper','none',-1,3200,0,'true','true','true','true','sb_summon_storm_cubic1','none'),
(3040,'Spellbook: Summon Vampiric Cubic','false','spellbook',120,'stackable','paper','none',-1,3700,0,'true','true','true','true','sb_summon_vampiric_cubic1','none'),
(3041,'Spellbook: Summon Phantom Cubic','false','spellbook',120,'stackable','paper','none',-1,3200,0,'true','true','true','true','sb_summon_poltergeist_cubic1','none'),
(3042,'Spellbook: Life Scavenge','false','spellbook',120,'stackable','paper','none',-1,3200,0,'true','true','true','true','sb_life_scavenge1','none'),
(3043,'Spellbook: Holy Strike','false','spellbook',120,'stackable','paper','none',-1,4250,0,'true','true','true','true','sb_holy_strike1','none'),
(3044,'Spellbook: Horror','false','spellbook',120,'stackable','paper','none',-1,4250,0,'true','true','true','true','sb_horror1','none'),
(3045,'Spellbook: Summon Life Cubic','false','spellbook',120,'stackable','paper','none',-1,3700,0,'true','true','true','true','sb_summon_life_cubic1','none'),
(3046,'Spellbook: Sacrifice','false','spellbook',120,'stackable','paper','none',-1,5400,0,'true','true','true','true','sb_sacrifice1','none'),
(3047,'Spellbook: Iron Will','false','spellbook',120,'stackable','paper','none',-1,3700,0,'true','true','true','true','sb_iron_will1','none'),
(3048,'Spellbook: Reflect Damage','false','spellbook',120,'stackable','paper','none',-1,3200,0,'true','true','true','true','sb_reflect_damage1','none'),
(3049,'Spellbook: Corpse Plague','false','spellbook',120,'stackable','paper','none',-1,4250,0,'true','true','true','true','sb_corpse_plague1','none'),
(3050,'Spellbook: Hex','false','spellbook',120,'stackable','paper','none',-1,3200,0,'true','true','true','true','sb_hex1','none'),
(3051,'Spellbook: Spirit Barrier','false','spellbook',120,'stackable','paper','none',-1,3200,0,'true','true','true','true','sb_spirit_barrier1','none'),
(3052,'Spellbook: Hamstring','false','spellbook',120,'stackable','paper','none',-1,3700,0,'true','true','true','true','sb_hamstring1','none'),
(3053,'Spellbook: Holy Blessing','false','spellbook',120,'stackable','paper','none',-1,3200,0,'true','true','true','true','sb_holy_blessing11','none'),
(3054,'Spellbook: Summon Viper Cubic','false','spellbook',120,'stackable','paper','none',-1,4800,0,'true','true','true','true','sb_summon_viper_cubic1','none'),
(3055,'Spellbook: Lightning Strike','false','spellbook',120,'stackable','paper','none',-1,6750,0,'true','true','true','true','sb_lightening_strike1','none'),
(3056,'Spellbook: Summon Dark Panther','false','spellbook',120,'stackable','paper','none',-1,3200,0,'true','true','true','true','sb_summon_dark_panther1','none'),
(3057,'Spellbook: Summon Reanimated Man','false','spellbook',120,'stackable','paper','none',-1,3850,0,'true','true','true','true','sb_summon_skeletonwarrior1','none'),
(3058,'Spellbook: Summon Corrupted Man','false','spellbook',120,'stackable','paper','none',-1,3200,0,'true','true','true','true','sb_summon_zombi1','none'),
(3059,'Spellbook: Corpse Burst','false','spellbook',120,'stackable','paper','none',-1,4600,0,'true','true','true','true','sb_corpse_burst1','none'),
(3060,'Spellbook: Forget','false','spellbook',120,'stackable','paper','none',-1,3850,0,'true','true','true','true','sb_forget','none'),
(3061,'Spellbook: Curse Discord','false','spellbook',120,'stackable','paper','none',-1,3200,0,'true','true','true','true','sb_curse_discord1','none'),
(3062,'Spellbook: Curse Fear','false','spellbook',120,'stackable','paper','none',-1,3200,0,'true','true','true','true','sb_curse_fear1','none'),
(3063,'Spellbook: Anchor','false','spellbook',120,'stackable','paper','none',-1,3850,0,'true','true','true','true','sb_anchor1','none'),
(3064,'Spellbook: Silence','false','spellbook',120,'stackable','paper','none',-1,3200,0,'true','true','true','true','sb_silence1','none'),
(3065,'Spellbook: Death Spike','false','spellbook',120,'stackable','paper','none',-1,3850,0,'true','true','true','true','sb_death_spike1','none'),
(3066,'Spellbook: Curse Death Link','false','spellbook',120,'stackable','paper','none',-1,5400,0,'true','true','true','true','sb_curse_death_link1','none'),
(3067,'Spellbook: Vampiric Claw','false','spellbook',120,'stackable','paper','none',-1,3200,0,'true','true','true','true','sb_vampiric_claw11','none'),
(3068,'Spellbook: Vitalize','false','spellbook',120,'stackable','paper','none',-1,4600,0,'true','true','true','true','sb_vitalize1','none'),
(3069,'Spellbook: Repose','false','spellbook',120,'stackable','paper','none',-1,3850,0,'true','true','true','true','sb_repose1','none'),
(3070,'Spellbook: Hold Undead','false','spellbook',120,'stackable','paper','none',-1,4600,0,'true','true','true','true','sb_hold_undead1','none'),
(3071,'Spellbook: Requiem','false','spellbook',120,'stackable','paper','none',-1,3200,0,'true','true','true','true','sb_requiem1','none'),
(3072,'Spellbook: Purify','false','spellbook',120,'stackable','paper','none',-1,3850,0,'true','true','true','true','sb_purify1','none'),
(3073,'Spellbook: Might of Heaven','false','spellbook',120,'stackable','paper','none',-1,3200,0,'true','true','true','true','sb_might_of_heaven11','none'),
(3074,'Spellbook: Surrender to Wind','false','spellbook',120,'stackable','paper','none',-1,3200,0,'true','true','true','true','sb_surrender_to_wind1','none'),
(3075,'Spellbook: Blazing Circle','false','spellbook',120,'stackable','paper','none',-1,3200,0,'true','true','true','true','sb_blazing_circle1','none'),
(3076,'Spellbook: Prominence','false','spellbook',120,'stackable','paper','none',-1,3200,0,'true','true','true','true','sb_prominence11','none'),
(3077,'Spellbook: Blazing Skin','false','spellbook',120,'stackable','paper','none',-1,3200,0,'true','true','true','true','sb_blazing_skin1','none'),
(3078,'Spellbook: Decay','false','spellbook',120,'stackable','paper','none',-1,4600,0,'true','true','true','true','sb_decay1','none'),
(3079,'Spellbook: Cancel','false','spellbook',120,'stackable','paper','none',-1,4600,0,'true','true','true','true','sb_cancel1','none'),
(3080,'Spellbook: Sleeping Cloud','false','spellbook',120,'stackable','paper','none',-1,3850,0,'true','true','true','true','sb_sleeping_cloud1','none'),
(3081,'Spellbook: Aura Flare','false','spellbook',120,'stackable','paper','none',-1,3200,0,'true','true','true','true','sb_aura_flare11','none'),
(3082,'Spellbook: Surrender to Water','false','spellbook',120,'stackable','paper','none',-1,3200,0,'true','true','true','true','sb_surrender_to_water1','none'),
(3083,'Spellbook: Frost Wall','false','spellbook',120,'stackable','paper','none',-1,5400,0,'true','true','true','true','sb_frost_wall1','none'),
(3084,'Spellbook: Freezing Shackle','false','spellbook',120,'stackable','paper','none',-1,3850,0,'true','true','true','true','sb_freezing_shackle1','none'),
(3085,'Spellbook: Hydro Blast','false','spellbook',120,'stackable','paper','none',-1,3200,0,'true','true','true','true','sb_hydro_blast11','none'),
(3086,'Spellbook: Frost Bolt','false','spellbook',120,'stackable','paper','none',-1,3200,0,'true','true','true','true','sb_frost_bolt11','none'),
(3087,'Spellbook: Ice Dagger','false','spellbook',120,'stackable','paper','none',-1,3850,0,'true','true','true','true','sb_ice_dagger1','none'),
(3088,'Spellbook: Freezing Skin','false','spellbook',120,'stackable','paper','none',-1,3200,0,'true','true','true','true','sb_freezing_skin1','none'),
(3089,'Spellbook: Tempest','false','spellbook',120,'stackable','paper','none',-1,4600,0,'true','true','true','true','sb_tempest1','none'),
(3090,'Spellbook: Hurricane','false','spellbook',120,'stackable','paper','none',-1,3200,0,'true','true','true','true','sb_hurricane11','none'),
(3091,'Spellbook: Servitor Magic Shield','false','spellbook',120,'stackable','paper','none',-1,3850,0,'true','true','true','true','sb_servitor_magic_shield1','none'),
(3092,'Spellbook: Servitor Physical Shield','false','spellbook',120,'stackable','paper','none',-1,3200,0,'true','true','true','true','sb_servitor_physical_shield1','none'),
(3093,'Spellbook: Servitor Haste','false','spellbook',120,'stackable','paper','none',-1,3850,0,'true','true','true','true','sb_servitor_haste1','none'),
(3094,'Spellbook: Invigor','false','spellbook',120,'stackable','paper','none',-1,3200,0,'true','true','true','true','sb_invigor1','none'),
(3095,'Spellbook: Magic Barrier','false','spellbook',120,'stackable','paper','none',-1,3850,0,'true','true','true','true','sb_magic_barrier1','none'),
(3096,'Spellbook: Blessed Body','false','spellbook',120,'stackable','paper','none',-1,3850,0,'true','true','true','true','sb_bless_the_body1','none'),
(3097,'Spellbook: Blessed Soul','false','spellbook',120,'stackable','paper','none',-1,3850,0,'true','true','true','true','sb_bless_the_soul1','none'),
(3098,'Spellbook: Return','false','spellbook',120,'stackable','paper','none',-1,3200,0,'true','true','true','true','sb_return1','none'),
(3099,'Spellbook: Haste','false','spellbook',120,'stackable','paper','none',-1,3850,0,'true','true','true','true','sb_haste1','none'),
(3100,'Spellbook: Guidance','false','spellbook',120,'stackable','paper','none',-1,3200,0,'true','true','true','true','sb_guidance1','none'),
(3101,'Spellbook: Death Whisper','false','spellbook',120,'stackable','paper','none',-1,3200,0,'true','true','true','true','sb_death_whisper1','none'),
(3102,'Spellbook: Bless Shield','false','spellbook',120,'stackable','paper','none',-1,3200,0,'true','true','true','true','sb_bless_shield1','none'),
(3103,'Amulet: Pa''agrio\'s Wisdom','false','spellbook',120,'stackable','paper','none',-1,3200,0,'true','true','true','true','sb_wisdom_of_paagrio1','none'),
(3104,'Amulet: Pa''agrio\'s Glory','false','spellbook',120,'stackable','paper','none',-1,3200,0,'true','true','true','true','sb_glory_of_paagrio1','none'),
(3105,'Amulet: Seal of Winter','false','spellbook',120,'stackable','paper','none',-1,3200,0,'true','true','true','true','sb_seal_of_winter1','none'),
(3106,'Amulet: Seal of Flame','false','spellbook',120,'stackable','paper','none',-1,4600,0,'true','true','true','true','sb_seal_of_flame1','none'),
(3107,'Amulet: Seal of Gloom','false','spellbook',120,'stackable','paper','none',-1,3850,0,'true','true','true','true','sb_seal_of_gloom1','none'),
(3108,'Amulet: Seal of Mirage','false','spellbook',120,'stackable','paper','none',-1,3850,0,'true','true','true','true','sb_seal_of_mirage1','none'),
(3109,'Amulet: Seal of Silence','false','spellbook',120,'stackable','paper','none',-1,4600,0,'true','true','true','true','sb_seal_of_silence1','none'),
(3110,'Amulet: Seal of Scourge','false','spellbook',120,'stackable','paper','none',-1,3200,0,'true','true','true','true','sb_seal_of_scourge1','none'),
(3111,'Amulet: Seal of Suspension','false','spellbook',120,'stackable','paper','none',-1,4600,0,'true','true','true','true','sb_seal_of_suspension1','none'),
(3112,'Amulet: Pa''agrio\'s Vision','false','spellbook',120,'stackable','paper','none',-1,3850,0,'true','true','true','true','sb_sight_of_paagrio1','none'),
(3113,'Amulet: Pa''agrio\'s Protection','false','spellbook',120,'stackable','paper','none',-1,3200,0,'true','true','true','true','sb_shield_of_paagrio1','none'),
(3114,'Amulet: Steal Essence','false','spellbook',120,'stackable','paper','none',-1,3200,0,'true','true','true','true','sb_steal_essence1','none'),
(3115,'Amulet: Freezing Flame','false','spellbook',120,'stackable','paper','none',-1,3200,0,'true','true','true','true','sb_freezing_flame1','none'),
(3116,'Amulet: Chant of Fury','false','spellbook',120,'stackable','paper','none',-1,4600,0,'true','true','true','true','sb_chant_of_fury1','none'),
(3117,'Amulet: Chant of Evasion','false','spellbook',120,'stackable','paper','none',-1,3200,0,'true','true','true','true','sb_chant_of_evasion1','none'),
(3118,'Amulet: Chant of Rage','false','spellbook',120,'stackable','paper','none',-1,3850,0,'true','true','true','true','sb_chant_of_rage1','none'),
(3119,'Mark of Guildsman','false','quest',0,'stackable','steel','none',-1,0,0,'false','false','true','false','mark_of_guildsman','none'),
(3120,'Valkon\'s Recommendation','false','quest',0,'stackable','steel','none',-1,0,0,'false','false','true','false','valkons_recommend','none'),
(3121,'Mandragora Berry','false','quest',0,'stackable','steel','none',-1,0,0,'false','false','true','false','mandragora_berry','none'),
(3122,'Altran\'s Instructions','false','quest',0,'stackable','steel','none',-1,0,0,'false','false','true','false','alltrans_instructions','none'),
(3123,'Altran\'s 1st Recommendation','false','quest',0,'stackable','steel','none',-1,0,0,'false','false','true','false','alltrans_recommend1','none'),
(3124,'Altran\'s 2nd Recommendation','false','quest',0,'stackable','steel','none',-1,0,0,'false','false','true','false','alltrans_recommend2','none'),
(3125,'Norman\'s Instructions','false','quest',0,'stackable','steel','none',-1,0,0,'false','false','true','false','normans_instructions','none'),
(3126,'Norman\'s Receipt','false','quest',0,'stackable','steel','none',-1,0,0,'false','false','true','false','normans_receipt','none'),
(3127,'Duning\'s Instructions','false','quest',0,'stackable','steel','none',-1,0,0,'false','false','true','false','dunings_instructions','none'),
(3128,'Duning\'s Key','false','quest',0,'stackable','steel','none',-1,0,0,'false','false','true','false','dunings_key','none'),
(3129,'Norman\'s List','false','quest',0,'stackable','steel','none',-1,0,0,'false','false','true','false','normans_list','none'),
(3130,'Gray Bone Powder','false','quest',0,'stackable','steel','none',-1,0,0,'false','false','true','false','gray_bone_powder','none'),
(3131,'Granite Whetstone','false','quest',0,'stackable','steel','none',-1,0,0,'false','false','true','false','granite_whetstone','none'),
(3132,'Red Pigment','false','quest',0,'stackable','steel','none',-1,0,0,'false','false','true','false','red_pigment','none'),
(3133,'Braided Yarn','false','quest',0,'stackable','steel','none',-1,0,0,'false','false','true','false','braided_yarn','none'),
(3134,'Journeyman Gem','false','quest',0,'stackable','steel','none',-1,0,0,'false','false','true','false','journeyman_gem','none'),
(3135,'Pinter\'s Instructions','false','quest',0,'stackable','steel','none',-1,0,0,'false','false','true','false','pinters_instructions','none'),
(3136,'Amber Bead','false','quest',0,'stackable','steel','none',-1,0,0,'false','false','true','false','amber_bead','none'),
(3137,'Amber Lump','false','quest',0,'stackable','steel','none',-1,0,0,'false','false','true','false','amber_lump','none'),
(3138,'Journeyman Deco Beads','false','quest',0,'stackable','steel','none',-1,0,0,'false','false','true','false','journeyman_deco_beads','none'),
(3139,'Journeyman Ring','false','quest',0,'stackable','steel','none',-1,0,0,'false','false','true','false','journeyman_ring','none'),
(3140,'Mark of Life','false','quest',0,'stackable','steel','none',-1,0,0,'false','false','true','false','mark_of_life','none'),
(3141,'Cardien\'s Letter','false','quest',0,'stackable','steel','none',-1,0,0,'false','false','true','false','cardiens_letter','none'),
(3142,'Camomile Charm','false','quest',0,'stackable','steel','none',-1,0,0,'false','false','true','false','camomile_charm','none'),
(3143,'Hierarch\'s Letter','false','quest',0,'stackable','steel','none',-1,0,0,'false','false','true','false','hierarchs_letter','none'),
(3144,'Moonflower Charm','false','quest',0,'stackable','steel','none',-1,0,0,'false','false','true','false','moonflower_charm','none'),
(3145,'Grail Diagram','false','quest',0,'stackable','steel','none',-1,0,0,'false','false','true','false','grail_diagram','none'),
(3146,'Thalia\'s 1st Letter','false','quest',0,'stackable','steel','none',-1,0,0,'false','false','true','false','thalyas_letter1','none'),
(3147,'Thalia\'s 2nd Letter','false','quest',0,'stackable','steel','none',-1,0,0,'false','false','true','false','thalyas_letter2','none'),
(3148,'Thalia\'s Instructions','false','quest',0,'stackable','steel','none',-1,0,0,'false','false','true','false','thalyas_instructions','none'),
(3149,'Pushkin\'s List','false','quest',0,'stackable','steel','none',-1,0,0,'false','false','true','false','pushkins_list','none'),
(3150,'Pure Mithril Cup','false','quest',0,'stackable','steel','none',-1,0,0,'false','false','true','false','pure_mithril_cup','none'),
(3151,'Arkenia\'s Contract','false','quest',0,'stackable','steel','none',-1,0,0,'false','false','true','false','arkenias_contract','none'),
(3152,'Arkenia\'s Instructions','false','quest',0,'stackable','steel','none',-1,0,0,'false','false','true','false','arkenias_instructions','none'),
(3153,'Adonius\'s list','false','quest',0,'stackable','steel','none',-1,0,0,'false','false','true','false','adonius_list','none'),
(3154,'Andariel Scripture Copy','false','quest',0,'stackable','steel','none',-1,0,0,'false','false','true','false','andariel_scripture_copy','none'),
(3155,'Stardust','false','quest',0,'stackable','steel','none',-1,0,0,'false','false','true','false','stardust','none'),
(3156,'Isael\'s Instructions','false','quest',0,'stackable','steel','none',-1,0,0,'false','false','true','false','isaels_instructions','none'),
(3157,'Isael\'s Letter','false','quest',0,'stackable','steel','none',-1,0,0,'false','false','true','false','isaels_letter','none'),
(3158,'Grail of Purity','false','quest',0,'stackable','steel','none',-1,0,0,'false','false','true','false','grail_of_purity','none'),
(3159,'Tears of Unicorn','false','quest',0,'stackable','steel','none',-1,0,0,'false','false','true','false','tears_of_unicorn','none'),
(3160,'Water of Life','false','quest',0,'stackable','steel','none',-1,0,0,'false','false','true','false','water_of_life','none'),
(3161,'Pure Mithril Ore','false','quest',0,'stackable','steel','none',-1,0,0,'false','false','true','false','pure_mithril_ore','none'),
(3162,'Ant Soldier Acid','false','quest',0,'stackable','steel','none',-1,0,0,'false','false','true','false','ant_soldier_acid','none'),
(3163,'Wyrm\'s Talon','false','quest',0,'stackable','steel','none',-1,0,0,'false','false','true','false','wyrms_talon1','none'),
(3164,'Spider Ichor','false','quest',0,'stackable','steel','none',-1,0,0,'false','false','true','false','spider_ichor','none'),
(3165,'Harpy\'s Down','false','quest',0,'stackable','steel','none',-1,0,0,'false','false','true','false','harpys_down','none'),
(3166,'Talin\'s Spear Blade','false','quest',0,'stackable','steel','none',-1,0,0,'false','false','true','false','talins_spear_blade','none'),
(3167,'Talin\'s Spear Shaft','false','quest',0,'stackable','steel','none',-1,0,0,'false','false','true','false','talins_spear_shaft','none'),
(3168,'Talin\'s Ruby','false','quest',0,'stackable','steel','none',-1,0,0,'false','false','true','false','talins_ruby','none'),
(3169,'Talin\'s Aquamarine','false','quest',0,'stackable','steel','none',-1,0,0,'false','false','true','false','talins_aquamarine','none'),
(3170,'Talin\'s Amethyst','false','quest',0,'stackable','steel','none',-1,0,0,'false','false','true','false','talins_amethyst','none'),
(3171,'Talin\'s Peridot','false','quest',0,'stackable','steel','none',-1,0,0,'false','false','true','false','talins_peridot','none'),
(3172,'Mark of Fate','false','quest',0,'stackable','steel','none',-1,0,0,'false','false','true','false','mark_of_fate','none'),
(3173,'Kaira\'s Letter','false','quest',0,'stackable','steel','none',-1,0,0,'false','false','true','false','kairas_letter1','none'),
(3174,'Metheus\'s Funeral Jar','false','quest',0,'stackable','steel','none',-1,0,0,'false','false','true','false','metheus_funeral_jar','none'),
(3175,'Kasandra\'s Remains','false','quest',0,'stackable','steel','none',-1,0,0,'false','false','true','false','kasandras_remains','none'),
(3176,'Herbalism Textbook','false','quest',0,'stackable','steel','none',-1,0,0,'false','false','true','false','herbalism_textbook','none'),
(3177,'Ixia\'s List','false','quest',0,'stackable','steel','none',-1,0,0,'false','false','true','false','ixias_list','none'),
(3178,'Medusa\'s Ichor','false','quest',0,'stackable','steel','none',-1,0,0,'false','false','true','false','medusa_ichor','none'),
(3179,'Marsh Spider Fluids','false','quest',0,'stackable','steel','none',-1,0,0,'false','false','true','false','m_spider_fluids','none'),
(3180,'Dead Seeker Dung','false','quest',0,'stackable','steel','none',-1,0,0,'false','false','true','false','dead_seeker_dung','none'),
(3181,'Tyrant\'s Blood','false','quest',0,'stackable','steel','none',-1,0,0,'false','false','true','false','tyrants_blood','none'),
(3182,'Nightshade Root','false','quest',0,'stackable','steel','none',-1,0,0,'false','false','true','false','nightshade_root','none'),
(3183,'Belladonna','false','quest',0,'stackable','steel','none',-1,0,0,'false','false','true','false','belladonna','none'),
(3184,'Alder\'s Skull','false','quest',0,'stackable','steel','none',-1,0,0,'false','false','true','false','alders_skull1','none'),
(3185,'Alders Skull','false','quest',0,'stackable','steel','none',-1,0,0,'false','false','true','false','alders_skull2','none'),
(3186,'Alder\'s Receipt','false','quest',0,'stackable','steel','none',-1,0,0,'false','false','true','false','alders_receipt','none'),
(3187,'Revelations Manuscript','false','quest',0,'stackable','steel','none',-1,0,0,'false','false','true','false','revelations_manuscript','none'),
(3188,'Kaira\'s Instructions','false','quest',0,'stackable','steel','none',-1,0,0,'false','false','true','false','kairas_instructions','none'),
(3189,'Kaira\'s Recommendation','false','quest',0,'stackable','steel','none',-1,0,0,'false','false','true','false','kairas_recommend','none'),
(3190,'Palus Charm','false','quest',0,'stackable','steel','none',-1,0,0,'false','false','true','false','palus_charm','none'),
(3191,'Thifiell\'s Letter','false','quest',0,'stackable','steel','none',-1,0,0,'false','false','true','false','thifiels_letter','none'),
(3192,'Arkenia\'s Note','false','quest',0,'stackable','steel','none',-1,0,0,'false','false','true','false','arkenias_note','none'),
(3193,'Pixy Garnet','false','quest',0,'stackable','steel','none',-1,0,0,'false','false','true','false','pixy_garnet','none'),
(3194,'Grandis\'s Skull','false','quest',0,'stackable','steel','none',-1,0,0,'false','false','true','false','grandis_skull','none'),
(3195,'Karul Bugbear Skull','false','quest',0,'stackable','steel','none',-1,0,0,'false','false','true','false','karul_bugbear_skull','none'),
(3196,'Breka Overlord Skull','false','quest',0,'stackable','steel','none',-1,0,0,'false','false','true','false','breka_overlord_skull','none'),
(3197,'Leto Overlord Skull','false','quest',0,'stackable','steel','none',-1,0,0,'false','false','true','false','leto_overlord_skull','none'),
(3198,'Red Fairy Dust','false','quest',0,'stackable','steel','none',-1,0,0,'false','false','true','false','red_fairy_dust','none'),
(3199,'Blight Treant Seed','false','quest',0,'stackable','steel','none',-1,0,0,'false','false','true','false','timiriran_seed','none'),
(3200,'Black Willow Leaf','false','quest',0,'stackable','steel','none',-1,0,0,'false','false','true','false','black_willow_leaf','none'),
(3201,'Blight Treant Sap','false','quest',0,'stackable','steel','none',-1,0,0,'false','false','true','false','timiriran_sap','none'),
(3202,'Arkenia\'s Letter','false','quest',0,'stackable','steel','none',-1,0,0,'false','false','true','false','arkenias_letter1','none'),
(3203,'Mark of Glory','false','quest',0,'stackable','steel','none',-1,0,0,'false','false','true','false','mark_of_glory','none'),
(3204,'Vokian\'s Order','false','quest',0,'stackable','steel','none',-1,0,0,'false','false','true','false','vokiyans_order1','none'),
(3205,'Manashen Shard','false','quest',0,'stackable','steel','none',-1,0,0,'false','false','true','false','manashen_shard','none'),
(3206,'Tyrant Talon','false','quest',0,'stackable','steel','none',-1,0,0,'false','false','true','false','tyrant_talon','none'),
(3207,'Guardian Basilisk Fang','false','quest',0,'stackable','steel','none',-1,0,0,'false','false','true','false','guardian_basilisk_fang','none'),
(3208,'Vokian\'s Order','false','quest',0,'stackable','steel','none',-1,0,0,'false','false','true','false','vokiyans_order2','none'),
(3209,'Necklace of Authority','false','quest',0,'stackable','steel','none',-1,0,0,'false','false','true','false','necklace_of_authority','none'),
(3210,'Chianta\'s 1st Order','false','quest',0,'stackable','steel','none',-1,0,0,'false','false','true','false','chiantas_order1','none'),
(3211,'Scepter of Breka','false','quest',0,'stackable','steel','none',-1,0,0,'false','false','true','false','scepter_of_breka','none'),
(3212,'Scepter of Enku','false','quest',0,'stackable','steel','none',-1,0,0,'false','false','true','false','scepter_of_enku','none'),
(3213,'Scepter of Vuku','false','quest',0,'stackable','steel','none',-1,0,0,'false','false','true','false','scepter_of_vuku','none'),
(3214,'Scepter of Turek','false','quest',0,'stackable','steel','none',-1,0,0,'false','false','true','false','scepter_of_turek','none'),
(3215,'Scepter of Tunath','false','quest',0,'stackable','steel','none',-1,0,0,'false','false','true','false','scepter_of_lennunt','none'),
(3216,'Chianta\'s 2nd Order','false','quest',0,'stackable','steel','none',-1,0,0,'false','false','true','false','chiantas_order2','none'),
(3217,'Chianta\'s 3rd Order','false','quest',0,'stackable','steel','none',-1,0,0,'false','false','true','false','chiantas_order3','none'),
(3218,'Tamlin Orc Skull','false','quest',0,'stackable','steel','none',-1,0,0,'false','false','true','false','tamlin_orc_skull','none'),
(3219,'Timak Orc Head','false','quest',0,'stackable','steel','none',-1,0,0,'false','false','true','false','timak_orc_head','none'),
(3220,'Scepter Box','false','quest',0,'stackable','steel','none',-1,0,0,'false','false','true','false','scepter_box','none'),
(3221,'Pashika\'s Head','false','quest',0,'stackable','steel','none',-1,0,0,'false','false','true','false','pashikas_head','none'),
(3222,'Vultus'' Head','false','quest',0,'stackable','steel','none',-1,0,0,'false','false','true','false','vultus_head','none'),
(3223,'Glove of Voltar','false','quest',0,'stackable','steel','none',-1,0,0,'false','false','true','false','glove_of_voltar','none'),
(3224,'Enku Overlord Head','false','quest',0,'stackable','steel','none',-1,0,0,'false','false','true','false','enku_overlord_head','none'),
(3225,'Glove of Kepra','false','quest',0,'stackable','steel','none',-1,0,0,'false','false','true','false','glove_of_kepra','none'),
(3226,'Makum Bugbear Head','false','quest',0,'stackable','steel','none',-1,0,0,'false','false','true','false','makum_bugbear_head','none'),
(3227,'Glove of Burai','false','quest',0,'stackable','steel','none',-1,0,0,'false','false','true','false','glove_of_burai','none'),
(3228,'Manakia\'s 1st Letter','false','quest',0,'stackable','steel','none',-1,0,0,'false','false','true','false','manakias_letter1','none'),
(3229,'Manakia\'s 2nd Letter','false','quest',0,'stackable','steel','none',-1,0,0,'false','false','true','false','manakias_letter2','none'),
(3230,'Kasman\'s 1st Letter','false','quest',0,'stackable','steel','none',-1,0,0,'false','false','true','false','kasmans_letter1','none'),
(3231,'Kasman\'s 2nd Letter','false','quest',0,'stackable','steel','none',-1,0,0,'false','false','true','false','kasmans_letter2','none'),
(3232,'Kasman\'s 3rd Letter','false','quest',0,'stackable','steel','none',-1,0,0,'false','false','true','false','kasmans_letter3','none'),
(3233,'Driko\'s Contract','false','quest',0,'stackable','steel','none',-1,0,0,'false','false','true','false','drikos_contract','none'),
(3234,'Stakato Drone Husk','false','quest',0,'stackable','steel','none',-1,0,0,'false','false','true','false','stakato_drone_husk1','none'),
(3235,'Tanapi\'s Order','false','quest',0,'stackable','steel','none',-1,0,0,'false','false','true','false','tanapis_order1','none'),
(3236,'Scepter of Tantos','false','quest',0,'stackable','steel','none',-1,0,0,'false','false','true','false','scepter_of_tantos','none'),
(3237,'Ritual Box','false','quest',0,'stackable','steel','none',-1,0,0,'false','false','true','false','ritual_box','none'),
(3238,'Mark of Prosperity','false','quest',0,'stackable','steel','none',-1,0,0,'false','false','true','false','mark_of_prosperity','none'),
(3239,'1st Ring of Testimony','false','quest',0,'stackable','steel','none',-1,0,0,'false','false','true','false','ring_of_testimony1','none'),
(3240,'2nd Ring of Testimony','false','quest',0,'stackable','steel','none',-1,0,0,'false','false','true','false','ring_of_testimony2','none'),
(3241,'Old Account Book','false','quest',0,'stackable','steel','none',-1,0,0,'false','false','true','false','old_account_book','none'),
(3242,'Blessed Seed','false','quest',0,'stackable','steel','none',-1,0,0,'false','false','true','false','blessed_seed','none'),
(3243,'Emily\'s Recipe','false','quest',0,'stackable','steel','none',-1,0,0,'false','false','true','false','recipe_of_emilly','none'),
(3244,'Lilith\'s Elven Wafer','false','quest',0,'stackable','steel','none',-1,0,0,'false','false','true','false','rylith_elven_wafer','none'),
(3245,'Maphr Tablet Fragment','false','quest',0,'stackable','steel','none',-1,0,0,'false','false','true','false','maphr_tablet_fragment','none'),
(3246,'Collection License','false','quest',0,'stackable','steel','none',-1,0,0,'false','false','true','false','collection_license','none'),
(3247,'Lockirin\'s 1st Notice','false','quest',0,'stackable','steel','none',-1,0,0,'false','false','true','false','lockirins_notice1','none'),
(3248,'Lockirin\'s 2nd Notice','false','quest',0,'stackable','steel','none',-1,0,0,'false','false','true','false','lockirins_notice2','none'),
(3249,'Lockirin\'s 3rd Notice','false','quest',0,'stackable','steel','none',-1,0,0,'false','false','true','false','lockirins_notice3','none'),
(3250,'Lockirin\'s 4th Notice','false','quest',0,'stackable','steel','none',-1,0,0,'false','false','true','false','lockirins_notice4','none'),
(3251,'Lockirin\'s 5th Notice','false','quest',0,'stackable','steel','none',-1,0,0,'false','false','true','false','lockirins_notice5','none'),
(3252,'Contribution of Shari','false','quest',0,'stackable','steel','none',-1,0,0,'false','false','true','false','contribution_of_chali','none'),
(3253,'Contribution of Mion','false','quest',0,'stackable','steel','none',-1,0,0,'false','false','true','false','contribution_of_mion','none'),
(3254,'Contribution of Maryse','false','quest',0,'stackable','steel','none',-1,0,0,'false','false','true','false','contribution_of_marife','none'),
(3255,'Maryse\'s Request','false','quest',0,'stackable','steel','none',-1,0,0,'false','false','true','false','marifes_request','none'),
(3256,'Contribution of Toma','false','quest',0,'stackable','steel','none',-1,0,0,'false','false','true','false','contribution_of_toma','none'),
(3257,'Receipt of Bolter','false','quest',0,'stackable','steel','none',-1,0,0,'false','false','true','false','receipt_of_bolter','none'),
(3258,'1st Receipt of Contribution','false','quest',0,'stackable','steel','none',-1,0,0,'false','false','true','false','receipt_of_contribution1','none'),
(3259,'2nd Receipt of Contribution','false','quest',0,'stackable','steel','none',-1,0,0,'false','false','true','false','receipt_of_contribution2','none'),
(3260,'3rd Receipt of Contribution','false','quest',0,'stackable','steel','none',-1,0,0,'false','false','true','false','receipt_of_contribution3','none'),
(3261,'4th Receipt of Contribution','false','quest',0,'stackable','steel','none',-1,0,0,'false','false','true','false','receipt_of_contribution4','none'),
(3262,'5th Receipt of Contribution','false','quest',0,'stackable','steel','none',-1,0,0,'false','false','true','false','receipt_of_contribution5','none'),
(3263,'Procuration of Torocco','false','quest',0,'stackable','steel','none',-1,0,0,'false','false','true','false','procuration_of_torocco','none'),
(3264,'Bright\'s List','false','quest',0,'stackable','steel','none',-1,0,0,'false','false','true','false','brights_list','none'),
(3265,'Mandragora Petal','false','quest',0,'stackable','steel','none',-1,0,0,'false','false','true','false','mandragora_petal','none'),
(3266,'Crimson Moss','false','quest',0,'stackable','steel','none',-1,0,0,'false','false','true','false','crimson_moss','none'),
(3267,'Mandragora Bouquet','false','quest',0,'stackable','steel','none',-1,0,0,'false','false','true','false','mandragora_bouquet','none'),
(3268,'Parman\'s Instructions','false','quest',0,'stackable','steel','none',-1,0,0,'false','false','true','false','parmans_instructions','none'),
(3269,'Parman\'s Letter','false','quest',0,'stackable','steel','none',-1,0,0,'false','false','true','false','parmans_letter','none'),
(3270,'Clay Dough','false','quest',0,'stackable','steel','none',-1,0,0,'false','false','true','false','clay_dough','none'),
(3271,'Pattern of Keyhole','false','quest',0,'stackable','steel','none',-1,0,0,'false','false','true','false','pattern_of_keyhole','none'),
(3272,'Nikolas'' List','false','quest',0,'stackable','steel','none',-1,0,0,'false','false','true','false','nikolas_list','none'),
(3273,'Stakato Shell','false','quest',0,'stackable','steel','none',-1,0,0,'false','false','true','false','stakato_shell','none'),
(3274,'Toad Lord Sac','false','quest',0,'stackable','steel','none',-1,0,0,'false','false','true','false','inpicio_sac','none'),
(3275,'Spider Thorn','false','quest',0,'stackable','steel','none',-1,0,0,'false','false','true','false','spider_thorn','none'),
(3276,'Mark of Champion','false','quest',0,'stackable','steel','none',-1,0,0,'false','false','true','false','mark_of_champion','none'),
(3277,'Ascalon\'s 1st Letter','false','quest',0,'stackable','steel','none',-1,0,0,'false','false','true','false','ascalons_letter1','none'),
(3278,'Mason\'s Letter','false','quest',0,'stackable','steel','none',-1,0,0,'false','false','true','false','masons_letter','none'),
(3279,'Iron Rose Ring','false','quest',0,'stackable','steel','none',-1,0,0,'false','false','true','false','iron_rose_ring','none'),
(3280,'Ascalon\'s 2nd Letter','false','quest',0,'stackable','steel','none',-1,0,0,'false','false','true','false','ascalons_letter2','none'),
(3281,'White Rose Insignia','false','quest',0,'stackable','steel','none',-1,0,0,'false','false','true','false','white_rose_insignia','none'),
(3282,'Groot\'s Letter','false','quest',0,'stackable','steel','none',-1,0,0,'false','false','true','false','groots_letter','none'),
(3283,'Ascalon\'s 3rd Letter','false','quest',0,'stackable','steel','none',-1,0,0,'false','false','true','false','ascalons_letter3','none'),
(3284,'Mouen\'s 1st Order','false','quest',0,'stackable','steel','none',-1,0,0,'false','false','true','false','mouens_order1','none'),
(3285,'Mouen\'s 2nd Order','false','quest',0,'stackable','steel','none',-1,0,0,'false','false','true','false','mouens_order2','none'),
(3286,'Mouen\'s Letter','false','quest',0,'stackable','steel','none',-1,0,0,'false','false','true','false','mouens_letter','none'),
(3287,'Harpy\'s Egg','false','quest',0,'stackable','steel','none',-1,0,0,'false','false','true','false','harpys_egg1','none'),
(3288,'Medusa\'s Venom','false','quest',0,'stackable','steel','none',-1,0,0,'false','false','true','false','medusa_venom1','none'),
(3289,'Windsus Bile','false','quest',0,'stackable','steel','none',-1,0,0,'false','false','true','false','windsus_bile1','none'),
(3290,'Bloody Axe Head','false','quest',0,'stackable','steel','none',-1,0,0,'false','false','true','false','bloody_axe_head','none'),
(3291,'Road Ratman Head','false','quest',0,'stackable','steel','none',-1,0,0,'false','false','true','false','road_ratman_head','none'),
(3292,'Leto Lizardman Fang','false','quest',0,'stackable','steel','none',-1,0,0,'false','false','true','false','leto_lizardman_fang1','none'),
(3293,'Mark of Sagittarius','false','quest',0,'stackable','steel','none',-1,0,0,'false','false','true','false','mark_of_sagittarius','none'),
(3294,'Bernard\'s Introduction','false','quest',0,'stackable','steel','none',-1,0,0,'false','false','true','false','bernards_introduction','none'),
(3295,'Hamil\'s 1st Letter','false','quest',0,'stackable','steel','none',-1,0,0,'false','false','true','false','letter_of_hamil1','none'),
(3296,'Hamil\'s 2nd Letter','false','quest',0,'stackable','steel','none',-1,0,0,'false','false','true','false','letter_of_hamil2','none'),
(3297,'Hamil\'s 3rd Letter','false','quest',0,'stackable','steel','none',-1,0,0,'false','false','true','false','letter_of_hamil3','none'),
(3298,'Hunter\'s 1st Rune','false','quest',0,'stackable','steel','none',-1,0,0,'false','false','true','false','hunters_rune1','none'),
(3299,'Hunter\'s 2nd Rune','false','quest',0,'stackable','steel','none',-1,0,0,'false','false','true','false','hunters_rune2','none'),
(3300,'Talisman of Kadesh','false','quest',0,'stackable','steel','none',-1,0,0,'false','false','true','false','talisman_of_kadesh','none'),
(3301,'Talisman of Snake','false','quest',0,'stackable','steel','none',-1,0,0,'false','false','true','false','talisman_of_snake','none'),
(3302,'Mithril Clip','false','quest',0,'stackable','steel','none',-1,0,0,'false','false','true','false','mithril_clip','none'),
(3303,'Stakato Chitin','false','quest',0,'stackable','steel','none',-1,0,0,'false','false','true','false','stakato_chitin','none'),
(3304,'Reinforced Bowstring','false','quest',0,'stackable','steel','none',-1,0,0,'false','false','true','false','st_bowstring','none'),
(3305,'Manashen\'s Horn','false','quest',0,'stackable','steel','none',-1,0,0,'false','false','true','false','manashens_horn','none'),
(3306,'Blood of Lizardman','false','quest',0,'stackable','steel','none',-1,0,0,'false','false','true','false','blood_of_lizardman','none'),
(3307,'Mark of Witchcraft','false','quest',0,'stackable','steel','none',-1,0,0,'false','false','true','false','mark_of_witchcraft','none'),
(3308,'Orim\'s Diagram','false','quest',0,'stackable','steel','none',-1,0,0,'false','false','true','false','orims_diagram','none'),
(3309,'Alexandria\'s Book','false','quest',0,'stackable','steel','none',-1,0,0,'false','false','true','false','alexandrias_book','none'),
(3310,'Iker\'s List','false','quest',0,'stackable','steel','none',-1,0,0,'false','false','true','false','ikers_list','none'),
(3311,'Dire Wyrm Fang','false','quest',0,'stackable','steel','none',-1,0,0,'false','false','true','false','dire_wyrm_fang','none'),
(3312,'Leto Lizardman Charm','false','quest',0,'stackable','steel','none',-1,0,0,'false','false','true','false','leto_lizardman_charm','none'),
(3313,'Enchanted Golem Heartstone','false','quest',0,'stackable','steel','none',-1,0,0,'false','false','true','false','en_golem_heartstone','none'),
(3314,'Lara\'s Memo','false','quest',0,'stackable','steel','none',-1,0,0,'false','false','true','false','lars_memo1','none'),
(3315,'Nestle\'s Memo','false','quest',0,'stackable','steel','none',-1,0,0,'false','false','true','false','nestle_memo1','none'),
(3316,'Leopold\'s Journal','false','quest',0,'stackable','steel','none',-1,0,0,'false','false','true','false','leopolds_journal1','none'),
(3317,'Aklantoth 1st Gem','false','quest',0,'stackable','steel','none',-1,0,0,'false','false','true','false','aklantos_gem1','none'),
(3318,'Aklantoth 2nd Gem','false','quest',0,'stackable','steel','none',-1,0,0,'false','false','true','false','aklantos_gem2','none'),
(3319,'Aklantoth 3rd Gem','false','quest',0,'stackable','steel','none',-1,0,0,'false','false','true','false','aklantos_gem3','none'),
(3320,'Aklantoth 4th Gem','false','quest',0,'stackable','steel','none',-1,0,0,'false','false','true','false','aklantos_gem4','none'),
(3321,'Aklantoth 5th Gem','false','quest',0,'stackable','steel','none',-1,0,0,'false','false','true','false','aklantos_gem5','none'),
(3322,'Aklantoth 6th Gem','false','quest',0,'stackable','steel','none',-1,0,0,'false','false','true','false','aklantos_gem6','none'),
(3323,'1st Brimstone','false','quest',0,'stackable','steel','none',-1,0,0,'false','false','true','false','brimstone1','none'),
(3324,'Orim\'s Instructions','false','quest',0,'stackable','steel','none',-1,0,0,'false','false','true','false','orims_instructions','none'),
(3325,'Orim\'s 1st Letter','false','quest',0,'stackable','steel','none',-1,0,0,'false','false','true','false','orims_letter1','none'),
(3326,'Orim\'s 2nd Letter','false','quest',0,'stackable','steel','none',-1,0,0,'false','false','true','false','orims_letter2','none'),
(3327,'Sir Vasper\'s Letter','false','quest',0,'stackable','steel','none',-1,0,0,'false','false','true','false','sir_vaspers_letter','none'),
(3328,'Vadin\'s Crucifix','false','quest',0,'stackable','steel','none',-1,0,0,'false','false','true','false','vadins_crucifix','none'),
(3329,'Tamlin Orc Amulet','false','quest',0,'stackable','steel','none',-1,0,0,'false','false','true','false','tamlin_orc_amulet','none'),
(3330,'Vadin\'s Sanctions','false','quest',0,'stackable','steel','none',-1,0,0,'false','false','true','false','vadins_sanctions','none'),
(3331,'Iker\'s Amulet','false','quest',0,'stackable','steel','none',-1,0,0,'false','false','true','false','ikers_amulet','none'),
(3332,'Soultrap Crystal','false','quest',0,'stackable','steel','none',-1,0,0,'false','false','true','false','soultrap_crystal','none'),
(3333,'Purgatory Key','false','quest',0,'stackable','steel','none',-1,0,0,'false','false','true','false','purgatory_key','none'),
(3334,'Zeruel Bind Crystal','false','quest',0,'stackable','steel','none',-1,0,0,'false','false','true','false','zeruel_bind_crystal','none'),
(3335,'2nd Brimstone','false','quest',0,'stackable','steel','none',-1,0,0,'false','false','true','false','brimstone2','none'),
(3336,'Mark of Summoner','false','quest',0,'stackable','steel','none',-1,0,0,'false','false','true','false','mark_of_summoner','none'),
(3337,'Leto Lizardman Amulet','false','quest',0,'stackable','steel','none',-1,0,0,'false','false','true','false','letolizardman_amulet','none'),
(3338,'Sac of Redspores','false','quest',0,'stackable','steel','none',-1,0,0,'false','false','true','false','sac_of_redspores','none'),
(3339,'Karul Bugbear Totem','false','quest',0,'stackable','steel','none',-1,0,0,'false','false','true','false','karulbugbear_totem','none'),
(3340,'Shards of Manashen','false','quest',0,'stackable','steel','none',-1,0,0,'false','false','true','false','shards_of_manashen','none'),
(3341,'Breka Orc Totem','false','quest',0,'stackable','steel','none',-1,0,0,'false','false','true','false','brekaorc_totem','none'),
(3342,'Crimson Bloodstone','false','quest',0,'stackable','steel','none',-1,0,0,'false','false','true','false','crimson_bloodstone','none'),
(3343,'Talons of Tyrant','false','quest',0,'stackable','steel','none',-1,0,0,'false','false','true','false','talons_of_tyrant','none'),
(3344,'Wings of Droneant','false','quest',0,'stackable','steel','none',-1,0,0,'false','false','true','false','wings_of_droneant','none'),
(3345,'Tusk of Windsus','false','quest',0,'stackable','steel','none',-1,0,0,'false','false','true','false','tusk_of_windsus','none'),
(3346,'Fangs of Wyrm','false','quest',0,'stackable','steel','none',-1,0,0,'false','false','true','false','fangs_of_wyrm','none'),
(3347,'Lara\'s 1st List','false','quest',0,'stackable','steel','none',-1,0,0,'false','false','true','false','lars_list1','none'),
(3348,'Lara\'s 2nd List','false','quest',0,'stackable','steel','none',-1,0,0,'false','false','true','false','lars_list2','none'),
(3349,'Lara\'s 3rd List','false','quest',0,'stackable','steel','none',-1,0,0,'false','false','true','false','lars_list3','none'),
(3350,'Lara\'s 4th List','false','quest',0,'stackable','steel','none',-1,0,0,'false','false','true','false','lars_list4','none'),
(3351,'Lara\'s 5th List','false','quest',0,'stackable','steel','none',-1,0,0,'false','false','true','false','lars_list5','none'),
(3352,'Galatea\'s Letter','false','quest',0,'stackable','steel','none',-1,0,0,'false','false','true','false','galateas_letter','none'),
(3353,'Beginner\'s Arcana','false','quest',0,'stackable','steel','none',-1,0,0,'false','false','true','false','beginners_arcana','none'),
(3354,'Almors\'s Arcana','false','quest',0,'stackable','steel','none',-1,0,0,'false','false','true','false','almors_arcana','none'),
(3355,'Camoniell\'s Arcana','false','quest',0,'stackable','steel','none',-1,0,0,'false','false','true','false','camoniell_arcana','none'),
(3356,'Belthus\'s Arcana','false','quest',0,'stackable','steel','none',-1,0,0,'false','false','true','false','belthus_arcana','none'),
(3357,'Basillia\'s Arcana','false','quest',0,'stackable','steel','none',-1,0,0,'false','false','true','false','basillia_arcana','none'),
(3358,'Celestiel\'s Arcana','false','quest',0,'stackable','steel','none',-1,0,0,'false','false','true','false','celestiel_arcana','none'),
(3359,'Brynthea\'s Arcana','false','quest',0,'stackable','steel','none',-1,0,0,'false','false','true','false','brynthea_arcana','none'),
(3360,'1st Crystal of Starting','false','quest',0,'stackable','steel','none',-1,0,0,'false','false','true','false','crystal_of_starting1','none'),
(3361,'1st Crystal of Inprogress','false','quest',0,'stackable','steel','none',-1,0,0,'false','false','true','false','crystal_of_inprogress1','none'),
(3362,'1st Crystal of Foul','false','quest',0,'stackable','steel','none',-1,0,0,'false','false','true','false','crystal_of_foul1','none'),
(3363,'1st Crystal of Defeat','false','quest',0,'stackable','steel','none',-1,0,0,'false','false','true','false','crystal_of_defeat1','none'),
(3364,'1st Crystal of Victory','false','quest',0,'stackable','steel','none',-1,0,0,'false','false','true','false','crystal_of_victory1','none'),
(3365,'2nd Crystal of Starting','false','quest',0,'stackable','steel','none',-1,0,0,'false','false','true','false','crystal_of_starting2','none'),
(3366,'2nd Crystal of Inprogress','false','quest',0,'stackable','steel','none',-1,0,0,'false','false','true','false','crystal_of_inprogress2','none'),
(3367,'2nd Crystal of Foul','false','quest',0,'stackable','steel','none',-1,0,0,'false','false','true','false','crystal_of_foul2','none'),
(3368,'2nd Crystal of Defeat','false','quest',0,'stackable','steel','none',-1,0,0,'false','false','true','false','crystal_of_defeat2','none'),
(3369,'2nd Crystal of Victory','false','quest',0,'stackable','steel','none',-1,0,0,'false','false','true','false','crystal_of_victory2','none'),
(3370,'3rd Crystal of Starting','false','quest',0,'stackable','steel','none',-1,0,0,'false','false','true','false','crystal_of_starting3','none'),
(3371,'3rd Crystal of Inprogress','false','quest',0,'stackable','steel','none',-1,0,0,'false','false','true','false','crystal_of_inprogress3','none'),
(3372,'3rd Crystal of Foul','false','quest',0,'stackable','steel','none',-1,0,0,'false','false','true','false','crystal_of_foul3','none'),
(3373,'3rd Crystal of Defeat','false','quest',0,'stackable','steel','none',-1,0,0,'false','false','true','false','crystal_of_defeat3','none'),
(3374,'3rd Crystal of Victory','false','quest',0,'stackable','steel','none',-1,0,0,'false','false','true','false','crystal_of_victory3','none'),
(3375,'4th Crystal of Starting','false','quest',0,'stackable','steel','none',-1,0,0,'false','false','true','false','crystal_of_starting4','none'),
(3376,'4th Crystal of Inprogress','false','quest',0,'stackable','steel','none',-1,0,0,'false','false','true','false','crystal_of_inprogress4','none'),
(3377,'4th Crystal of Foul','false','quest',0,'stackable','steel','none',-1,0,0,'false','false','true','false','crystal_of_foul4','none'),
(3378,'4th Crystal of Defeat','false','quest',0,'stackable','steel','none',-1,0,0,'false','false','true','false','crystal_of_defeat4','none'),
(3379,'4th Crystal of Victory','false','quest',0,'stackable','steel','none',-1,0,0,'false','false','true','false','crystal_of_victory4','none'),
(3380,'5th Crystal of Starting','false','quest',0,'stackable','steel','none',-1,0,0,'false','false','true','false','crystal_of_starting5','none'),
(3381,'5th Crystal of Inprogress','false','quest',0,'stackable','steel','none',-1,0,0,'false','false','true','false','crystal_of_inprogress5','none'),
(3382,'5th Crystal of Foul','false','quest',0,'stackable','steel','none',-1,0,0,'false','false','true','false','crystal_of_foul5','none'),
(3383,'5th Crystal of Defeat','false','quest',0,'stackable','steel','none',-1,0,0,'false','false','true','false','crystal_of_defeat5','none'),
(3384,'5th Crystal of Victory','false','quest',0,'stackable','steel','none',-1,0,0,'false','false','true','false','crystal_of_victory5','none'),
(3385,'6th Crystal of Starting','false','quest',0,'stackable','steel','none',-1,0,0,'false','false','true','false','crystal_of_starting6','none'),
(3386,'6th Crystal of Inprogress','false','quest',0,'stackable','steel','none',-1,0,0,'false','false','true','false','crystal_of_inprogress6','none'),
(3387,'6th Crystal of Foul','false','quest',0,'stackable','steel','none',-1,0,0,'false','false','true','false','crystal_of_foul6','none'),
(3388,'6th Crystal of Defeat','false','quest',0,'stackable','steel','none',-1,0,0,'false','false','true','false','crystal_of_defeat6','none'),
(3389,'6th Crystal of Victory','false','quest',0,'stackable','steel','none',-1,0,0,'false','false','true','false','crystal_of_victory6','none'),
(3390,'Mark of Lord','false','quest',0,'stackable','steel','none',-1,0,0,'false','false','true','false','mark_of_lord','none'),
(3391,'Ordeal Necklace','false','quest',0,'stackable','steel','none',-1,0,0,'false','false','true','false','ordeal_necklace','none'),
(3392,'Varkee\'s Charm','false','quest',0,'stackable','steel','none',-1,0,0,'false','false','true','false','varkees_charm','none'),
(3393,'Tantus\'s Charm','false','quest',0,'stackable','steel','none',-1,0,0,'false','false','true','false','tantus_charm','none'),
(3394,'Hatos\'s Charm','false','quest',0,'stackable','steel','none',-1,0,0,'false','false','true','false','hatos_charm','none'),
(3395,'Takuna\'s Charm','false','quest',0,'stackable','steel','none',-1,0,0,'false','false','true','false','takuna_charm','none'),
(3396,'Chianta\'s Charm','false','quest',0,'stackable','steel','none',-1,0,0,'false','false','true','false','chianta_charm','none'),
(3397,'Manakia\'s Orders','false','quest',0,'stackable','steel','none',-1,0,0,'false','false','true','false','manakias_orders','none'),
(3398,'Breka Orc Fang','false','quest',0,'stackable','steel','none',-1,0,0,'false','false','true','false','breka_orc_fang','none'),
(3399,'Manakia\'s Amulet','false','quest',0,'stackable','steel','none',-1,0,0,'false','false','true','false','manakias_amulet','none'),
(3400,'Huge Orc Fang','false','quest',0,'stackable','steel','none',-1,0,0,'false','false','true','false','huge_orc_fang','none'),
(3401,'Sumari\'s Letter','false','quest',0,'stackable','steel','none',-1,0,0,'false','false','true','false','sumaris_letter','none'),
(3402,'Urutu Blade','false','quest',0,'stackable','steel','none',-1,0,0,'false','false','true','false','urutu_blade','none'),
(3403,'Timak Orc Skull','false','quest',0,'stackable','steel','none',-1,0,0,'false','false','true','false','timak_orc_skull','none'),
(3404,'Sword Into Skull','false','quest',0,'stackable','steel','none',-1,0,0,'false','false','true','false','sword_into_skull','none'),
(3405,'Neruga Axe Blade','false','quest',0,'stackable','steel','none',-1,0,0,'false','false','true','false','neruga_axe_blade','none'),
(3406,'Axe of Ceremony','false','quest',0,'stackable','steel','none',-1,0,0,'false','false','true','false','axe_of_ceremony','none'),
(3407,'Marsh Spider Feeler','false','quest',0,'stackable','steel','none',-1,0,0,'false','false','true','false','marsh_spider_feeler','none'),
(3408,'Marsh Spider Feet','false','quest',0,'stackable','steel','none',-1,0,0,'false','false','true','false','marsh_spider_feet','none'),
(3409,'Handiwork Spider Brooch','false','quest',0,'stackable','steel','none',-1,0,0,'false','false','true','false','handiwork_spider_brooch','none'),
(3410,'Cornea of Enchanted Monster Eye','false','quest',0,'stackable','steel','none',-1,0,0,'false','false','true','false','cornea_of_en_monstereye','none'),
(3411,'Monster Eye Woodcarving','false','quest',0,'stackable','steel','none',-1,0,0,'false','false','true','false','monstereye_woodcarving','none'),
(3412,'Bear Fang Necklace','false','quest',0,'stackable','steel','none',-1,0,0,'false','false','true','false','bear_fang_necklace','none'),
(3413,'Martankus\'s Charm','false','quest',0,'stackable','steel','none',-1,0,0,'false','false','true','false','martankus_charm','none'),
(3414,'Ragna Orc Head','false','quest',0,'stackable','steel','none',-1,0,0,'false','false','true','false','ragna_orc_head','none'),
(3415,'Ragna Chief Notice','false','quest',0,'stackable','steel','none',-1,0,0,'false','false','true','false','ragna_chief_notice','none'),
(3416,'Immortal Flame','false','quest',0,'stackable','steel','none',-1,0,0,'false','false','true','false','immortal_flame','none'),
(3417,'Animal Lover\'s List','false','quest',0,'stackable','steel','none',-1,0,0,'false','false','true','false','animal_lovers_list','none'),
(3418,'Animal Slayer\'s 1st List','false','quest',0,'stackable','steel','none',-1,0,0,'false','false','true','false','animal_slayer_list1','none'),
(3419,'Animal Slayer\'s 2nd List','false','quest',0,'stackable','steel','none',-1,0,0,'false','false','true','false','animal_slayer_list2','none'),
(3420,'Animal Slayer\'s 3rd List','false','quest',0,'stackable','steel','none',-1,0,0,'false','false','true','false','animal_slayer_list3','none'),
(3421,'Animal Slayer\'s 4th List','false','quest',0,'stackable','steel','none',-1,0,0,'false','false','true','false','animal_slayer_list4','none'),
(3422,'Animal Slayer\'s 5th List','false','quest',0,'stackable','steel','none',-1,0,0,'false','false','true','false','animal_slayer_list5','none'),
(3423,'Bloody Fang','false','quest',0,'stackable','steel','none',-1,0,0,'false','false','true','false','bloody_fang','none'),
(3424,'Bloody Claw','false','quest',0,'stackable','steel','none',-1,0,0,'false','false','true','false','bloody_claw','none'),
(3425,'Bloody Nail','false','quest',0,'stackable','steel','none',-1,0,0,'false','false','true','false','bloody_nail','none'),
(3426,'Bloody Kasha Fang','false','quest',0,'stackable','steel','none',-1,0,0,'false','false','true','false','bloody_kasha_fang','none'),
(3427,'Bloody Tarantula Nail','false','quest',0,'stackable','steel','none',-1,0,0,'false','false','true','false','bloody_tarantula_nail','none'),
(3428,'Crystal Brooch','false','quest',0,'stackable','steel','none',-1,0,0,'false','false','true','false','crystal_brooch','none'),
(3429,'Spellbook: Greater Heal','false','spellbook',120,'stackable','paper','none',-1,3200,0,'true','true','true','true','sb_greater_heal11','none'),
(3430,'Spellbook: Greater Battle Heal','false','spellbook',120,'stackable','paper','none',-1,3200,0,'true','true','true','true','sb_greater_battle_heal11','none'),
(3431,'Spellbook: Greater Group Heal','false','spellbook',120,'stackable','paper','none',-1,3200,0,'true','true','true','true','sb_greater_group_heal11','none'),
(3432,'Spellbook: Remedy','false','spellbook',120,'stackable','paper','none',-1,3200,0,'true','true','true','true','sb_remedy1','none'),
(3433,'Elf Figure','false','none',0,'normal','steel','none',-1,0,0,'false','false','false','false','elf_figure','none'),
(3434,'Coke','false','none',0,'normal','steel','none',-1,0,0,'false','false','false','false','coke','none'),
(3435,'Nvidia','false','none',0,'normal','steel','none',-1,0,0,'false','false','false','false','nvidia','none'),
(3436,'Mouse','false','none',0,'normal','steel','none',-1,0,0,'false','false','false','false','mouse','none'),
(3437,'Trade Book of Merchant','false','none',120,'normal','paper','none',-1,20000,0,'true','true','true','true','trade_book_of_merchant','none'),
(3438,'Trade Book of Great Merchant','false','none',120,'normal','paper','none',-1,20000,0,'true','true','true','true','trade_book_of_great_merchant','none'),
(3440,'Cargo Box','false','none',20,'stackable','steel','none',-1,10,0,'true','true','true','true','q_cargo_box1','none'),
(3441,'Cargo Box','false','none',20,'stackable','steel','none',-1,10,0,'true','true','true','true','q_cargo_box2','none'),
(3442,'Cargo Box','false','none',20,'stackable','steel','none',-1,10,0,'true','true','true','true','q_cargo_box3','none'),
(3443,'Cargo Box','false','none',20,'stackable','steel','none',-1,10,0,'true','true','true','true','q_cargo_box4','none'),
(3444,'Gludio Apples','false','none',20,'stackable','steel','none',-1,1000,0,'true','true','true','true','q_loot_1','none'),
(3445,'Dion Corn Meal','false','none',20,'stackable','steel','none',-1,1000,0,'true','true','true','true','q_loot_2','none'),
(3446,'Dire Wolf Pelts','false','none',20,'stackable','steel','none',-1,1000,0,'true','true','true','true','q_loot_3','none'),
(3447,'Moonstone','false','none',20,'stackable','steel','none',-1,1500,0,'true','true','true','true','q_loot_4','none'),
(3448,'Gludio Wheat Flour','false','none',20,'stackable','steel','none',-1,1500,0,'true','true','true','true','q_loot_5','none'),
(3449,'Spidersilk Rope','false','none',20,'stackable','steel','none',-1,1500,0,'true','true','true','true','q_loot_6','none'),
(3450,'Alexandrite','false','none',20,'stackable','steel','none',-1,2000,0,'true','true','true','true','q_loot_7','none'),
(3451,'Silver Tea Service','false','none',20,'stackable','steel','none',-1,2000,0,'true','true','true','true','q_loot_8','none'),
(3452,'Mechanic Golem Spare Parts','false','none',20,'stackable','steel','none',-1,2000,0,'true','true','true','true','q_loot_9','none'),
(3453,'Fire Emerald','false','none',20,'stackable','steel','none',-1,5000,0,'true','true','true','true','q_loot_10','none'),
(3454,'Avellan Silk Frock','false','none',20,'stackable','steel','none',-1,5000,0,'true','true','true','true','q_loot_11','none'),
(3455,'Feriotic Porcelain Urn','false','none',20,'stackable','steel','none',-1,20000,0,'true','true','true','true','q_loot_12','none'),
(3456,'Imperial Diamond','false','none',20,'stackable','steel','none',-1,20000,0,'true','true','true','true','q_loot_13','none'),
(3457,'Statue of Shilen - Head','false','none',20,'stackable','steel','none',-1,2000,0,'true','true','true','true','q_loot_14','none'),
(3458,'Statue of Shilen - Torso','false','none',20,'stackable','steel','none',-1,2000,0,'true','true','true','true','q_loot_15','none'),
(3459,'Statue of Shilen - Arm','false','none',20,'stackable','steel','none',-1,2000,0,'true','true','true','true','q_loot_16','none'),
(3460,'Statue of Shilen - Leg','false','none',20,'stackable','steel','none',-1,2000,0,'true','true','true','true','q_loot_17','none'),
(3461,'Complete Statue of Shilen','false','none',20,'stackable','steel','none',-1,20000,0,'true','true','true','true','q_loot_18','none'),
(3462,'Fragment of Ancient Tablet - 1st Piece','false','none',20,'stackable','steel','none',-1,2000,0,'true','true','true','true','q_loot_19','none'),
(3463,'Fragment of Ancient Tablet - 2nd Piece','false','none',20,'stackable','steel','none',-1,2000,0,'true','true','true','true','q_loot_20','none'),
(3464,'Fragment of Ancient Tablet - 3rd Piece','false','none',20,'stackable','steel','none',-1,2000,0,'true','true','true','true','q_loot_21','none'),
(3465,'Fragment of Ancient Tablet - 4th Piece','false','none',20,'stackable','steel','none',-1,2000,0,'true','true','true','true','q_loot_22','none'),
(3466,'Complete Ancient Tablet','false','none',20,'stackable','steel','none',-1,20000,0,'true','true','true','true','q_loot_23','none'),
(3467,'Wish Potion','false','none',60,'normal','paper','none',-1,10,0,'true','true','true','true','q_wish_potion','none'),
(3468,'Ancient Crown','false','none',0,'normal','paper','none',-1,1000,0,'true','true','true','true','q_ancient_crown','none'),
(3469,'Certificate of Royalty','false','none',0,'normal','paper','none',-1,10,0,'true','true','true','true','q_certificate_of_royalty','none'),
(3470,'Gold Bar','false','none',0,'stackable','paper','none',-1,10000,0,'true','true','true','true','q_gold_bar','none'),
(3472,'Blood Medusa','false','none',0,'stackable','steel','none',-1,50,0,'true','true','true','true','q_blood_medusa','none'),
(3473,'Blood Werewolf','false','none',0,'stackable','steel','none',-1,100,0,'true','true','true','true','q_blood_werewolf','none'),
(3474,'Blood Basilisk','false','none',0,'stackable','steel','none',-1,150,0,'true','true','true','true','q_blood_basilisk','none'),
(3475,'Blood Drevanul','false','none',0,'stackable','steel','none',-1,100,0,'true','true','true','true','q_blood_drevanul','none'),
(3476,'Blood Succubus','false','none',0,'stackable','steel','none',-1,150,0,'true','true','true','true','q_blood_succubus','none'),
(3477,'Blood Dragon','false','none',0,'stackable','steel','none',-1,200,0,'true','true','true','true','q_blood_dragon','none'),
(3478,'Beleth\'s Blood Dragon','false','none',0,'stackable','steel','none',-1,300,0,'true','true','true','true','q_bereths_blood_dragon','none'),
(3479,'Manak\'s Blood Werewolf','false','none',0,'stackable','steel','none',-1,150,0,'true','true','true','true','q_manaks_blood_werewolf','none'),
(3480,'Nia\'s Blood Medusa','false','none',0,'stackable','steel','none',-1,100,0,'true','true','true','true','q_nias_blood_medusa','none'),
(3481,'Gold Dragon','false','none',0,'stackable','steel','none',-1,200,0,'true','true','true','true','q_gold_dragon','none'),
(3482,'Gold Wyvern','false','none',0,'stackable','steel','none',-1,50,0,'true','true','true','true','q_gold_wyvern','none'),
(3483,'Gold Knight','false','none',0,'stackable','steel','none',-1,100,0,'true','true','true','true','q_gold_knight','none'),
(3484,'Gold Giant','false','none',0,'stackable','steel','none',-1,150,0,'true','true','true','true','q_gold_giant','none'),
(3485,'Gold Drake','false','none',0,'stackable','steel','none',-1,100,0,'true','true','true','true','q_gold_drake','none'),
(3486,'Gold Wyrm','false','none',0,'stackable','steel','none',-1,150,0,'true','true','true','true','q_gold_wyrm','none'),
(3487,'Beleth\'s Gold Dragon','false','none',0,'stackable','steel','none',-1,300,0,'true','true','true','true','q_bereths_gold_dragon','none'),
(3488,'Manak\'s Gold Giant','false','none',0,'stackable','steel','none',-1,150,0,'true','true','true','true','q_manaks_gold_giant','none'),
(3489,'Nia\'s Gold Wyvern','false','none',0,'stackable','steel','none',-1,100,0,'true','true','true','true','q_nias_gold_wyvern','none'),
(3490,'Silver Unicorn','false','none',0,'stackable','steel','none',-1,50,0,'true','true','true','true','q_silver_unicorn','none'),
(3491,'Silver Fairy','false','none',0,'stackable','steel','none',-1,100,0,'true','true','true','true','q_silver_fairy','none'),
(3492,'Silver Dryad','false','none',0,'stackable','steel','none',-1,150,0,'true','true','true','true','q_silver_dryad','none'),
(3493,'Silver Dragon','false','none',0,'stackable','steel','none',-1,200,0,'true','true','true','true','q_silver_dragon','none'),
(3494,'Silver Golem','false','none',0,'stackable','steel','none',-1,100,0,'true','true','true','true','q_silver_golem','none'),
(3495,'Silver Undine','false','none',0,'stackable','steel','none',-1,150,0,'true','true','true','true','q_silver_undine','none'),
(3496,'Beleth\'s Silver Dragon','false','none',0,'stackable','steel','none',-1,300,0,'true','true','true','true','q_bereths_silver_dragon','none'),
(3497,'Manak\'s Silver Dryad','false','none',0,'stackable','steel','none',-1,150,0,'true','true','true','true','q_manaks_silver_dryad','none'),
(3498,'Nia\'s Silver Fairy','false','none',0,'stackable','steel','none',-1,100,0,'true','true','true','true','q_nias_silver_fairy','none'),
(3499,'Fairy Dust','false','none',0,'normal','steel','none',-1,10000,0,'true','false','true','true','q_fairy_dust','none'),
(3500,'Dragonflute of Wind','false','pet_collar',20,'normal','steel','none',-1,1000,0,'true','true','true','true','dragonflute_of_wind','pet_collar'),
(3501,'Dragonflute of Star','false','pet_collar',20,'normal','steel','none',-1,1000,0,'true','true','true','true','dragonflute_of_star','pet_collar'),
(3502,'Dragonflute of Twilight','false','pet_collar',20,'normal','steel','none',-1,1000,0,'true','true','true','true','dragonflute_of_twilight','pet_collar'),
(3503,'Deliverymen Decertificate','false','quest',0,'stackable','steel','none',-1,0,0,'false','false','true','false','q_deliverymen_decertificate','none'),
(3504,'Kirunas Horn','false','quest',0,'stackable','steel','none',-1,0,0,'false','false','true','false','q_kirunas_horn','none'),
(3505,'Mithril Mold','false','quest',0,'stackable','steel','none',-1,0,0,'false','false','true','false','q_mithril_mold','none'),
(3506,'Bloody Letter','false','quest',0,'stackable','steel','none',-1,0,0,'false','false','true','false','q_bloody_letter','none'),
(3507,'Supplies to Alex','false','quest',0,'stackable','steel','none',-1,0,0,'false','false','true','false','q_supplies_to_alankell','none'),
(3508,'Supplies to Endrigo','false','quest',0,'stackable','steel','none',-1,0,0,'false','false','true','false','q_supplies_to_endrigo','none'),
(3509,'Alex\'s Coins','false','quest',0,'stackable','steel','none',-1,0,0,'false','false','true','false','q_alankells_coins','none'),
(3510,'Wardens Appreciation','false','quest',0,'stackable','steel','none',-1,0,0,'false','false','true','false','q_wardens_appreciation','none'),
(3511,'Blackbox to Orim','false','quest',0,'stackable','steel','none',-1,0,0,'false','false','true','false','q_blackbox_to_orim','none'),
(3512,'Deluxe Windsus Ham','false','quest',0,'stackable','steel','none',-1,0,0,'false','false','true','false','q_delux_windsus_ham','none'),
(3513,'Heart of Silenos','false','quest',0,'stackable','steel','none',-1,0,0,'false','false','true','false','q_heart_of_silenos','none'),
(3514,'Request Giran','false','quest',0,'stackable','steel','none',-1,0,0,'false','false','true','false','q_request_giran','none'),
(3515,'Request Gludin','false','quest',0,'stackable','steel','none',-1,0,0,'false','false','true','false','q_request_gludin','none'),
(3516,'Request Hunters','false','quest',0,'stackable','steel','none',-1,0,0,'false','false','true','false','q_request_hunters','none'),
(3517,'Delivery Score Red','false','quest',0,'stackable','steel','none',-1,0,0,'false','false','true','false','q_delivery_score_red','none'),
(3518,'Delivery Score Blue','false','quest',0,'stackable','steel','none',-1,0,0,'false','false','true','false','q_delivery_score_blue','none'),
(3519,'Deliverymen Advanced Certificate Super','false','quest',0,'stackable','steel','none',-1,0,0,'false','false','true','false','q_deliverymen_decertificate_super','none'),
(3520,'1st Confirmation Document','false','quest',0,'stackable','steel','none',-1,0,0,'false','false','true','false','q_confirmation_document_1st','none'),
(3521,'2nd Confirmation Document','false','quest',0,'stackable','steel','none',-1,0,0,'false','false','true','false','q_confirmation_document_2nd','none'),
(3522,'Delivery Goods 01','false','quest',0,'stackable','steel','none',-1,0,0,'false','false','true','false','q_delivery_goods_01','none'),
(3523,'Delivery Goods 02','false','quest',0,'stackable','steel','none',-1,0,0,'false','false','true','false','q_delivery_goods_02','none'),
(3524,'Delivery Goods 03','false','quest',0,'stackable','steel','none',-1,0,0,'false','false','true','false','q_delivery_goods_03','none'),
(3525,'Delivery Goods 04','false','quest',0,'stackable','steel','none',-1,0,0,'false','false','true','false','q_delivery_goods_04','none'),
(3526,'Delivery Goods 05','false','quest',0,'stackable','steel','none',-1,0,0,'false','false','true','false','q_delivery_goods_05','none'),
(3527,'Delivery Goods 06','false','quest',0,'stackable','steel','none',-1,0,0,'false','false','true','false','q_delivery_goods_06','none'),
(3528,'Delivery Goods 07','false','quest',0,'stackable','steel','none',-1,0,0,'false','false','true','false','q_delivery_goods_07','none'),
(3529,'Delivery Goods 08','false','quest',0,'stackable','steel','none',-1,0,0,'false','false','true','false','q_delivery_goods_08','none'),
(3530,'Delivery Goods 09','false','quest',0,'stackable','steel','none',-1,0,0,'false','false','true','false','q_delivery_goods_09','none'),
(3531,'Delivery Goods 10','false','quest',0,'stackable','steel','none',-1,0,0,'false','false','true','false','q_delivery_goods_10','none'),
(3532,'Delivery Goods 11','false','quest',0,'stackable','steel','none',-1,0,0,'false','false','true','false','q_delivery_goods_11','none'),
(3533,'Delivery Goods 12','false','quest',0,'stackable','steel','none',-1,0,0,'false','false','true','false','q_delivery_goods_12','none'),
(3534,'Delivery Goods 13','false','quest',0,'stackable','steel','none',-1,0,0,'false','false','true','false','q_delivery_goods_13','none'),
(3535,'Delivery Goods 14','false','quest',0,'stackable','steel','none',-1,0,0,'false','false','true','false','q_delivery_goods_14','none'),
(3536,'Delivery Goods 15','false','quest',0,'stackable','steel','none',-1,0,0,'false','false','true','false','q_delivery_goods_15','none'),
(3537,'Delivery Goods 16','false','quest',0,'stackable','steel','none',-1,0,0,'false','false','true','false','q_delivery_goods_16','none'),
(3538,'Delivery Goods 17','false','quest',0,'stackable','steel','none',-1,0,0,'false','false','true','false','q_delivery_goods_17','none'),
(3539,'Delivery Goods 18','false','quest',0,'stackable','steel','none',-1,0,0,'false','false','true','false','q_delivery_goods_18','none'),
(3540,'Delivery Goods 19','false','quest',0,'stackable','steel','none',-1,0,0,'false','false','true','false','q_delivery_goods_19','none'),
(3541,'Delivery Goods 20','false','quest',0,'stackable','steel','none',-1,0,0,'false','false','true','false','q_delivery_goods_20','none'),
(3542,'Delivery Goods 21','false','quest',0,'stackable','steel','none',-1,0,0,'false','false','true','false','q_delivery_goods_21','none'),
(3543,'Delivery Goods 22','false','quest',0,'stackable','steel','none',-1,0,0,'false','false','true','false','q_delivery_goods_22','none'),
(3544,'Delivery Goods 23','false','quest',0,'stackable','steel','none',-1,0,0,'false','false','true','false','q_delivery_goods_23','none'),
(3545,'Delivery Goods 24','false','quest',0,'stackable','steel','none',-1,0,0,'false','false','true','false','q_delivery_goods_24','none'),
(3546,'Delivery Goods 25','false','quest',0,'stackable','steel','none',-1,0,0,'false','false','true','false','q_delivery_goods_25','none'),
(3547,'Delivery Goods 26','false','quest',0,'stackable','steel','none',-1,0,0,'false','false','true','false','q_delivery_goods_26','none'),
(3548,'Delivery Goods 27','false','quest',0,'stackable','steel','none',-1,0,0,'false','false','true','false','q_delivery_goods_27','none'),
(3549,'Delivery Goods 28','false','quest',0,'stackable','steel','none',-1,0,0,'false','false','true','false','q_delivery_goods_28','none'),
(3550,'Delivery Goods 29','false','quest',0,'stackable','steel','none',-1,0,0,'false','false','true','false','q_delivery_goods_29','none'),
(3551,'Delivery Goods 30','false','quest',0,'stackable','steel','none',-1,0,0,'false','false','true','false','q_delivery_goods_30','none'),
(3552,'Delivery Goods 31','false','quest',0,'stackable','steel','none',-1,0,0,'false','false','true','false','q_delivery_goods_31','none'),
(3553,'Delivery Goods 32','false','quest',0,'stackable','steel','none',-1,0,0,'false','false','true','false','q_delivery_goods_32','none'),
(3554,'Delivery Goods 33','false','quest',0,'stackable','steel','none',-1,0,0,'false','false','true','false','q_delivery_goods_33','none'),
(3555,'Delivery Goods 34','false','quest',0,'stackable','steel','none',-1,0,0,'false','false','true','false','q_delivery_goods_34','none'),
(3556,'Delivery Goods 35','false','quest',0,'stackable','steel','none',-1,0,0,'false','false','true','false','q_delivery_goods_35','none'),
(3557,'Delivery Goods 36','false','quest',0,'stackable','steel','none',-1,0,0,'false','false','true','false','q_delivery_goods_36','none'),
(3558,'Delivery Goods 37','false','quest',0,'stackable','steel','none',-1,0,0,'false','false','true','false','q_delivery_goods_37','none'),
(3559,'Delivery Goods 38','false','quest',0,'stackable','steel','none',-1,0,0,'false','false','true','false','q_delivery_goods_38','none'),
(3560,'Delivery Goods 39','false','quest',0,'stackable','steel','none',-1,0,0,'false','false','true','false','q_delivery_goods_39','none'),
(3561,'Delivery Goods 40','false','quest',0,'stackable','steel','none',-1,0,0,'false','false','true','false','q_delivery_goods_40','none'),
(3562,'Delivery Goods 41','false','quest',0,'stackable','steel','none',-1,0,0,'false','false','true','false','q_delivery_goods_41','none'),
(3563,'Delivery Goods 42','false','quest',0,'stackable','steel','none',-1,0,0,'false','false','true','false','q_delivery_goods_42','none'),
(3564,'Delivery Goods 43','false','quest',0,'stackable','steel','none',-1,0,0,'false','false','true','false','q_delivery_goods_43','none'),
(3565,'Delivery Goods 44','false','quest',0,'stackable','steel','none',-1,0,0,'false','false','true','false','q_delivery_goods_44','none'),
(3566,'Delivery Goods 45','false','quest',0,'stackable','steel','none',-1,0,0,'false','false','true','false','q_delivery_goods_45','none'),
(3567,'Delivery Goods 46','false','quest',0,'stackable','steel','none',-1,0,0,'false','false','true','false','q_delivery_goods_46','none'),
(3568,'Delivery Goods 47','false','quest',0,'stackable','steel','none',-1,0,0,'false','false','true','false','q_delivery_goods_47','none'),
(3569,'Delivery Goods 48','false','quest',0,'stackable','steel','none',-1,0,0,'false','false','true','false','q_delivery_goods_48','none'),
(3570,'Delivery Goods 49','false','quest',0,'stackable','steel','none',-1,0,0,'false','false','true','false','q_delivery_goods_49','none'),
(3571,'Delivery Goods 50','false','quest',0,'stackable','steel','none',-1,0,0,'false','false','true','false','q_delivery_goods_50','none'),
(3572,'Delivery Goods 51','false','quest',0,'stackable','steel','none',-1,0,0,'false','false','true','false','q_delivery_goods_51','none'),
(3573,'Delivery Goods 52','false','quest',0,'stackable','steel','none',-1,0,0,'false','false','true','false','q_delivery_goods_52','none'),
(3574,'Delivery Goods 53','false','quest',0,'stackable','steel','none',-1,0,0,'false','false','true','false','q_delivery_goods_53','none'),
(3575,'Delivery Goods 54','false','quest',0,'stackable','steel','none',-1,0,0,'false','false','true','false','q_delivery_goods_54','none'),
(3576,'Delivery Goods 55','false','quest',0,'stackable','steel','none',-1,0,0,'false','false','true','false','q_delivery_goods_55','none'),
(3577,'Delivery Goods 56','false','quest',0,'stackable','steel','none',-1,0,0,'false','false','true','false','q_delivery_goods_56','none'),
(3578,'Delivery Goods 57','false','quest',0,'stackable','steel','none',-1,0,0,'false','false','true','false','q_delivery_goods_57','none'),
(3579,'Delivery Goods 58','false','quest',0,'stackable','steel','none',-1,0,0,'false','false','true','false','q_delivery_goods_58','none'),
(3580,'Delivery Goods 59','false','quest',0,'stackable','steel','none',-1,0,0,'false','false','true','false','q_delivery_goods_59','none'),
(3581,'Delivery Goods 60','false','quest',0,'stackable','steel','none',-1,0,0,'false','false','true','false','q_delivery_goods_60','none'),
(3582,'Delivery Goods 61','false','quest',0,'stackable','steel','none',-1,0,0,'false','false','true','false','q_delivery_goods_61','none'),
(3583,'Delivery Goods 62','false','quest',0,'stackable','steel','none',-1,0,0,'false','false','true','false','q_delivery_goods_62','none'),
(3584,'Delivery Goods 63','false','quest',0,'stackable','steel','none',-1,0,0,'false','false','true','false','q_delivery_goods_63','none'),
(3585,'Delivery Goods 64','false','quest',0,'stackable','steel','none',-1,0,0,'false','false','true','false','q_delivery_goods_64','none'),
(3586,'Delivery Goods 65','false','quest',0,'stackable','steel','none',-1,0,0,'false','false','true','false','q_delivery_goods_65','none'),
(3587,'Delivery Goods 66','false','quest',0,'stackable','steel','none',-1,0,0,'false','false','true','false','q_delivery_goods_66','none'),
(3588,'Delivery Goods 67','false','quest',0,'stackable','steel','none',-1,0,0,'false','false','true','false','q_delivery_goods_67','none'),
(3589,'Confirmation Document 01','false','quest',0,'stackable','steel','none',-1,0,0,'false','false','true','false','q_confirmation_document_01','none'),
(3590,'Confirmation Document 02','false','quest',0,'stackable','steel','none',-1,0,0,'false','false','true','false','q_confirmation_document_02','none'),
(3591,'Confirmation Document 03','false','quest',0,'stackable','steel','none',-1,0,0,'false','false','true','false','q_confirmation_document_03','none'),
(3592,'Confirmation Document 04','false','quest',0,'stackable','steel','none',-1,0,0,'false','false','true','false','q_confirmation_document_04','none'),
(3593,'Confirmation Document 05','false','quest',0,'stackable','steel','none',-1,0,0,'false','false','true','false','q_confirmation_document_05','none'),
(3594,'Confirmation Document 06','false','quest',0,'stackable','steel','none',-1,0,0,'false','false','true','false','q_confirmation_document_06','none'),
(3595,'Confirmation Document 07','false','quest',0,'stackable','steel','none',-1,0,0,'false','false','true','false','q_confirmation_document_07','none'),
(3596,'Confirmation Document 08','false','quest',0,'stackable','steel','none',-1,0,0,'false','false','true','false','q_confirmation_document_08','none'),
(3597,'Confirmation Document 09','false','quest',0,'stackable','steel','none',-1,0,0,'false','false','true','false','q_confirmation_document_09','none'),
(3598,'Confirmation Document 10','false','quest',0,'stackable','steel','none',-1,0,0,'false','false','true','false','q_confirmation_document_10','none'),
(3599,'Confirmation Document 11','false','quest',0,'stackable','steel','none',-1,0,0,'false','false','true','false','q_confirmation_document_11','none'),
(3600,'Confirmation Document 12','false','quest',0,'stackable','steel','none',-1,0,0,'false','false','true','false','q_confirmation_document_12','none'),
(3601,'Confirmation Document 13','false','quest',0,'stackable','steel','none',-1,0,0,'false','false','true','false','q_confirmation_document_13','none'),
(3602,'Confirmation Document 14','false','quest',0,'stackable','steel','none',-1,0,0,'false','false','true','false','q_confirmation_document_14','none'),
(3603,'Confirmation Document 15','false','quest',0,'stackable','steel','none',-1,0,0,'false','false','true','false','q_confirmation_document_15','none'),
(3604,'Confirmation Document 16','false','quest',0,'stackable','steel','none',-1,0,0,'false','false','true','false','q_confirmation_document_16','none'),
(3605,'Confirmation Document 17','false','quest',0,'stackable','steel','none',-1,0,0,'false','false','true','false','q_confirmation_document_17','none'),
(3606,'Confirmation Document 18','false','quest',0,'stackable','steel','none',-1,0,0,'false','false','true','false','q_confirmation_document_18','none'),
(3607,'Confirmation Document 19','false','quest',0,'stackable','steel','none',-1,0,0,'false','false','true','false','q_confirmation_document_19','none'),
(3608,'Confirmation Document 20','false','quest',0,'stackable','steel','none',-1,0,0,'false','false','true','false','q_confirmation_document_20','none'),
(3609,'Confirmation Document 21','false','quest',0,'stackable','steel','none',-1,0,0,'false','false','true','false','q_confirmation_document_21','none'),
(3610,'Confirmation Document 22','false','quest',0,'stackable','steel','none',-1,0,0,'false','false','true','false','q_confirmation_document_22','none'),
(3611,'Confirmation Document 23','false','quest',0,'stackable','steel','none',-1,0,0,'false','false','true','false','q_confirmation_document_23','none'),
(3612,'Confirmation Document 24','false','quest',0,'stackable','steel','none',-1,0,0,'false','false','true','false','q_confirmation_document_24','none'),
(3613,'Confirmation Document 25','false','quest',0,'stackable','steel','none',-1,0,0,'false','false','true','false','q_confirmation_document_25','none'),
(3614,'Confirmation Document 26','false','quest',0,'stackable','steel','none',-1,0,0,'false','false','true','false','q_confirmation_document_26','none'),
(3615,'Confirmation Document 27','false','quest',0,'stackable','steel','none',-1,0,0,'false','false','true','false','q_confirmation_document_27','none'),
(3616,'Confirmation Document 28','false','quest',0,'stackable','steel','none',-1,0,0,'false','false','true','false','q_confirmation_document_28','none'),
(3617,'Confirmation Document 29','false','quest',0,'stackable','steel','none',-1,0,0,'false','false','true','false','q_confirmation_document_29','none'),
(3618,'Confirmation Document 30','false','quest',0,'stackable','steel','none',-1,0,0,'false','false','true','false','q_confirmation_document_30','none'),
(3619,'Confirmation Document 31','false','quest',0,'stackable','steel','none',-1,0,0,'false','false','true','false','q_confirmation_document_31','none'),
(3620,'Confirmation Document 32','false','quest',0,'stackable','steel','none',-1,0,0,'false','false','true','false','q_confirmation_document_32','none'),
(3621,'Confirmation Document 33','false','quest',0,'stackable','steel','none',-1,0,0,'false','false','true','false','q_confirmation_document_33','none'),
(3622,'Confirmation Document 34','false','quest',0,'stackable','steel','none',-1,0,0,'false','false','true','false','q_confirmation_document_34','none'),
(3623,'Confirmation Document 35','false','quest',0,'stackable','steel','none',-1,0,0,'false','false','true','false','q_confirmation_document_35','none'),
(3624,'Confirmation Document 36','false','quest',0,'stackable','steel','none',-1,0,0,'false','false','true','false','q_confirmation_document_36','none'),
(3625,'Confirmation Document 37','false','quest',0,'stackable','steel','none',-1,0,0,'false','false','true','false','q_confirmation_document_37','none'),
(3626,'Confirmation Document 38','false','quest',0,'stackable','steel','none',-1,0,0,'false','false','true','false','q_confirmation_document_38','none'),
(3627,'Confirmation Document 39','false','quest',0,'stackable','steel','none',-1,0,0,'false','false','true','false','q_confirmation_document_39','none'),
(3628,'Confirmation Document 40','false','quest',0,'stackable','steel','none',-1,0,0,'false','false','true','false','q_confirmation_document_40','none'),
(3629,'Confirmation Document 41','false','quest',0,'stackable','steel','none',-1,0,0,'false','false','true','false','q_confirmation_document_41','none'),
(3630,'Confirmation Document 42','false','quest',0,'stackable','steel','none',-1,0,0,'false','false','true','false','q_confirmation_document_42','none'),
(3631,'Confirmation Document 43','false','quest',0,'stackable','steel','none',-1,0,0,'false','false','true','false','q_confirmation_document_43','none'),
(3632,'Confirmation Document 44','false','quest',0,'stackable','steel','none',-1,0,0,'false','false','true','false','q_confirmation_document_44','none'),
(3633,'Confirmation Document 45','false','quest',0,'stackable','steel','none',-1,0,0,'false','false','true','false','q_confirmation_document_45','none'),
(3634,'Confirmation Document 46','false','quest',0,'stackable','steel','none',-1,0,0,'false','false','true','false','q_confirmation_document_46','none'),
(3635,'Confirmation Document 47','false','quest',0,'stackable','steel','none',-1,0,0,'false','false','true','false','q_confirmation_document_47','none'),
(3636,'Confirmation Document 48','false','quest',0,'stackable','steel','none',-1,0,0,'false','false','true','false','q_confirmation_document_48','none'),
(3637,'Confirmation Document 49','false','quest',0,'stackable','steel','none',-1,0,0,'false','false','true','false','q_confirmation_document_49','none'),
(3638,'Confirmation Document 50','false','quest',0,'stackable','steel','none',-1,0,0,'false','false','true','false','q_confirmation_document_50','none'),
(3639,'Confirmation Document 51','false','quest',0,'stackable','steel','none',-1,0,0,'false','false','true','false','q_confirmation_document_51','none'),
(3640,'Confirmation Document 52','false','quest',0,'stackable','steel','none',-1,0,0,'false','false','true','false','q_confirmation_document_52','none'),
(3641,'Confirmation Document 53','false','quest',0,'stackable','steel','none',-1,0,0,'false','false','true','false','q_confirmation_document_53','none'),
(3642,'Confirmation Document 54','false','quest',0,'stackable','steel','none',-1,0,0,'false','false','true','false','q_confirmation_document_54','none'),
(3643,'Confirmation Document 55','false','quest',0,'stackable','steel','none',-1,0,0,'false','false','true','false','q_confirmation_document_55','none'),
(3644,'Confirmation Document 56','false','quest',0,'stackable','steel','none',-1,0,0,'false','false','true','false','q_confirmation_document_56','none'),
(3645,'Confirmation Document 57','false','quest',0,'stackable','steel','none',-1,0,0,'false','false','true','false','q_confirmation_document_57','none'),
(3646,'Confirmation Document 58','false','quest',0,'stackable','steel','none',-1,0,0,'false','false','true','false','q_confirmation_document_58','none'),
(3647,'Confirmation Document 59','false','quest',0,'stackable','steel','none',-1,0,0,'false','false','true','false','q_confirmation_document_59','none'),
(3648,'Confirmation Document 60','false','quest',0,'stackable','steel','none',-1,0,0,'false','false','true','false','q_confirmation_document_60','none'),
(3649,'Confirmation Document 61','false','quest',0,'stackable','steel','none',-1,0,0,'false','false','true','false','q_confirmation_document_61','none'),
(3650,'Confirmation Document 62','false','quest',0,'stackable','steel','none',-1,0,0,'false','false','true','false','q_confirmation_document_62','none'),
(3651,'Confirmation Document 63','false','quest',0,'stackable','steel','none',-1,0,0,'false','false','true','false','q_confirmation_document_63','none'),
(3652,'Confirmation Document 64','false','quest',0,'stackable','steel','none',-1,0,0,'false','false','true','false','q_confirmation_document_64','none'),
(3653,'Confirmation Document 65','false','quest',0,'stackable','steel','none',-1,0,0,'false','false','true','false','q_confirmation_document_65','none'),
(3654,'Confirmation Document 66','false','quest',0,'stackable','steel','none',-1,0,0,'false','false','true','false','q_confirmation_document_66','none'),
(3655,'Confirmation Document 67','false','quest',0,'stackable','steel','none',-1,0,0,'false','false','true','false','q_confirmation_document_67','none'),
(3656,'Eye of Seer','false','quest',0,'stackable','steel','none',-1,0,0,'false','false','true','false','q_eye_of_seer','none'),
(3657,'Pincher Claw','false','quest',0,'stackable','steel','none',-1,0,0,'false','false','true','false','q_claw_of_pinrul_roader','none'),
(3658,'Ol Mahum Uniform','false','quest',0,'stackable','steel','none',-1,0,0,'false','false','true','false','q_ol_mahum_uniform','none'),
(3659,'Enku Orc Champion\'s Head','false','quest',0,'stackable','steel','none',-1,0,0,'false','false','true','false','q_enku_orc_champions_head','none'),
(3660,'Bloody Bee Stinger','false','quest',0,'stackable','steel','none',-1,0,0,'false','false','true','false','q_sting_of_bloody_bee','none'),
(3661,'Ignition of Ghost Fire','false','quest',0,'stackable','steel','none',-1,0,0,'false','false','true','false','q_ignition_of_ghost_fire','none'),
(3662,'Ethereal Blood','false','quest',0,'stackable','steel','none',-1,0,0,'false','false','true','false','q_ethereal_blood','none'),
(3663,'Returned Delivery Goods 10','false','quest',0,'stackable','steel','none',-1,0,0,'false','false','true','false','q_returned_delivery_goods_10','none'),
(3664,'Returned Delivery Goods 15','false','quest',0,'stackable','steel','none',-1,0,0,'false','false','true','false','q_returned_delivery_goods_15','none'),
(3665,'Returned Delivery Goods 30','false','quest',0,'stackable','steel','none',-1,0,0,'false','false','true','false','q_returned_delivery_goods_30','none'),
(3666,'Returned Delivery Goods 33','false','quest',0,'stackable','steel','none',-1,0,0,'false','false','true','false','q_returned_delivery_goods_33','none'),
(3667,'Returned Delivery Goods 37','false','quest',0,'stackable','steel','none',-1,0,0,'false','false','true','false','q_returned_delivery_goods_37','none'),
(3668,'Returned Delivery Goods 45','false','quest',0,'stackable','steel','none',-1,0,0,'false','false','true','false','q_returned_delivery_goods_45','none'),
(3669,'Returned Delivery Goods 55','false','quest',0,'stackable','steel','none',-1,0,0,'false','false','true','false','q_returned_delivery_goods_55','none'),
(3670,'Returned Delivery Goods 60','false','quest',0,'stackable','steel','none',-1,0,0,'false','false','true','false','q_returned_delivery_goods_60','none'),
(3671,'Sophya\'s 1st Order','false','quest',0,'stackable','steel','none',-1,0,0,'false','false','true','false','q_sophias_order1','none'),
(3672,'Sophya\'s 2nd Order','false','quest',0,'stackable','steel','none',-1,0,0,'false','false','true','false','q_sophias_order2','none'),
(3673,'Sophya\'s 3rd Order','false','quest',0,'stackable','steel','none',-1,0,0,'false','false','true','false','q_sophias_order3','none'),
(3674,'Sophya\'s 4th Order','false','quest',0,'stackable','steel','none',-1,0,0,'false','false','true','false','q_sophias_order4','none'),
(3675,'Lion\'s Claw','false','quest',0,'stackable','steel','none',-1,0,0,'false','false','true','false','q_lions_claw','none'),
(3676,'Lion\'s Eye','false','quest',0,'stackable','steel','none',-1,0,0,'false','false','true','false','q_lions_eye','none'),
(3677,'Guild Coin','false','quest',0,'stackable','steel','none',-1,0,0,'false','false','true','false','q_guild_coin','none'),
(3678,'Alchemy Text','false','quest',0,'stackable','steel','none',-1,0,0,'false','false','true','false','q_alchemy_text','none'),
(3679,'Secret Book of Potion','false','quest',0,'stackable','steel','none',-1,0,0,'false','false','true','false','q_secret_book_of_potion','none'),
(3680,'1st Potion Recipe','false','quest',0,'stackable','steel','none',-1,0,0,'false','false','true','false','q_potion_recipe_1','none'),
(3681,'2nd Potion Recipe','false','quest',0,'stackable','steel','none',-1,0,0,'false','false','true','false','q_potion_recipe_2','none'),
(3682,'Matild\'s Orb','false','quest',0,'stackable','steel','none',-1,0,0,'false','false','true','false','q_matilds_orb','none'),
(3683,'Forbidden Love Scroll','false','quest',0,'stackable','steel','none',-1,0,0,'false','false','true','false','q_fobbiden_love_scroll','none'),
(3684,'Amber Scale','false','quest',0,'stackable','steel','none',-1,0,0,'false','false','true','false','q_amber_scale','none'),
(3685,'Wind Soulstone','false','quest',0,'stackable','steel','none',-1,0,0,'false','false','true','false','q_wind_soulstone','none'),
(3686,'Glass Eye','false','quest',0,'stackable','steel','none',-1,0,0,'false','false','true','false','q_glass_eye','none'),
(3687,'Horror Ectoplasm','false','quest',0,'stackable','steel','none',-1,0,0,'false','false','true','false','q_horror_ectoplasm','none'),
(3688,'Silenos Horn','false','quest',0,'stackable','steel','none',-1,0,0,'false','false','true','false','q_silenos_horn','none'),
(3689,'Ant Soldier Aphid','false','quest',0,'stackable','steel','none',-1,0,0,'false','false','true','false','q_ant_soldier_aphid','none'),
(3690,'Tyrant\'s Chitin','false','quest',0,'stackable','steel','none',-1,0,0,'false','false','true','false','q_tyrants_chitin','none'),
(3691,'Bugbear Blood','false','quest',0,'stackable','steel','none',-1,0,0,'false','false','true','false','q_bugbear_blood','none'),
(3692,'1st Circle Hunter License','false','quest',0,'stackable','steel','none',-1,0,0,'false','false','true','false','q_hunter_license_1','none'),
(3693,'2nd Circle Hunter License','false','quest',0,'stackable','steel','none',-1,0,0,'false','false','true','false','q_hunter_license_2','none'),
(3694,'Laurel Leaf Pin','false','quest',0,'stackable','steel','none',-1,0,0,'false','false','true','false','q_laurel_leaf_pin','none'),
(3695,'1st Test Instructions','false','quest',0,'stackable','steel','none',-1,0,0,'false','false','true','false','q_test_instructions_1','none'),
(3696,'2nd Test Instructions','false','quest',0,'stackable','steel','none',-1,0,0,'false','false','true','false','q_test_instructions_2','none'),
(3697,'Cybellin\'s Request','false','quest',0,'stackable','steel','none',-1,0,0,'false','false','true','false','q_cybellins_request','none'),
(3698,'Blood Crystal: Purity 1','false','quest',0,'stackable','steel','none',-1,0,0,'false','false','true','false','q_blood_crystal_1','none'),
(3699,'Blood Crystal: Purity 2','false','quest',0,'stackable','steel','none',-1,0,0,'false','false','true','false','q_blood_crystal_2','none'),
(3700,'Blood Crystal: Purity 3','false','quest',0,'stackable','steel','none',-1,0,0,'false','false','true','false','q_blood_crystal_3','none'),
(3701,'Blood Crystal: Purity 4','false','quest',0,'stackable','steel','none',-1,0,0,'false','false','true','false','q_blood_crystal_4','none'),
(3702,'Blood Crystal: Purity 5','false','quest',0,'stackable','steel','none',-1,0,0,'false','false','true','false','q_blood_crystal_5','none'),
(3703,'Blood Crystal: Purity 6','false','quest',0,'stackable','steel','none',-1,0,0,'false','false','true','false','q_blood_crystal_6','none'),
(3704,'Blood Crystal: Purity 7','false','quest',0,'stackable','steel','none',-1,0,0,'false','false','true','false','q_blood_crystal_7','none'),
(3705,'Blood Crystal: Purity 8','false','quest',0,'stackable','steel','none',-1,0,0,'false','false','true','false','q_blood_crystal_8','none'),
(3706,'Blood Crystal: Purity 9','false','quest',0,'stackable','steel','none',-1,0,0,'false','false','true','false','q_blood_crystal_9','none'),
(3707,'Blood Crystal: Purity 10','false','quest',0,'stackable','steel','none',-1,0,0,'false','false','true','false','q_blood_crystal_10','none'),
(3708,'Blood Crystal: Broken','false','quest',0,'stackable','steel','none',-1,0,0,'false','false','true','false','q_blood_crystal_x','none'),
(3709,'Guardian Basilisk Scale','false','quest',0,'stackable','steel','none',-1,0,0,'false','false','true','false','q_g_basil_scale','none'),
(3710,'Karut Weed','false','quest',0,'stackable','steel','none',-1,0,0,'false','false','true','false','q_karut_weed','none'),
(3711,'Haka\'s Head','false','quest',0,'stackable','steel','none',-1,0,0,'false','false','true','false','q_hakas_head','none'),
(3712,'Jakas'' Head','false','quest',0,'stackable','steel','none',-1,0,0,'false','false','true','false','q_jakas_head','none'),
(3713,'Marka\'s Head','false','quest',0,'stackable','steel','none',-1,0,0,'false','false','true','false','q_markas_head','none'),
(3714,'Windsus Aleph Skin','false','quest',0,'stackable','steel','none',-1,0,0,'false','false','true','false','q_windsus_aleph_skin','none'),
(3715,'Indigo Runestone','false','quest',0,'stackable','steel','none',-1,0,0,'false','false','true','false','q_indigo_runestone','none'),
(3716,'Sporesea Seed','false','quest',0,'stackable','steel','none',-1,0,0,'false','false','true','false','q_sporesea_seed','none'),
(3717,'Timak Orc Totem','false','quest',0,'stackable','steel','none',-1,0,0,'false','false','true','false','q_timak_orc_totem','none'),
(3718,'Trisalim Silk','false','quest',0,'stackable','steel','none',-1,0,0,'false','false','true','false','q_trisalim_silk','none'),
(3719,'Ambrosius Fruit','false','quest',0,'stackable','steel','none',-1,0,0,'false','false','true','false','q_ambrosius_fruit','none'),
(3720,'Balefire Crystal','false','quest',0,'stackable','steel','none',-1,0,0,'false','false','true','false','q_balefire_crystal','none'),
(3721,'Imperial Arrowhead','false','quest',0,'stackable','steel','none',-1,0,0,'false','false','true','false','q_imperial_arrowhead','none'),
(3722,'Athu\'s Head','false','quest',0,'stackable','steel','none',-1,0,0,'false','false','true','false','q_athus_head','none'),
(3723,'Lanka\'s Head','false','quest',0,'stackable','steel','none',-1,0,0,'false','false','true','false','q_lankas_head','none'),
(3724,'Triska\'s Head','false','quest',0,'stackable','steel','none',-1,0,0,'false','false','true','false','q_triskas_head','none'),
(3725,'Motura\'s Head','false','quest',0,'stackable','steel','none',-1,0,0,'false','false','true','false','q_moturas_head','none'),
(3726,'Kalath\'s Head','false','quest',0,'stackable','steel','none',-1,0,0,'false','false','true','false','q_kalaths_head','none'),
(3727,'1st Circle Request: 1C','false','quest',0,'stackable','steel','none',-1,0,0,'false','false','true','false','q_request_1c_1','none'),
(3728,'1st Circle Request: 2C','false','quest',0,'stackable','steel','none',-1,0,0,'false','false','true','false','q_request_1c_2','none'),
(3729,'1st Circle Request: 3C','false','quest',0,'stackable','steel','none',-1,0,0,'false','false','true','false','q_request_1c_3','none'),
(3730,'1st Circle Request: 4C','false','quest',0,'stackable','steel','none',-1,0,0,'false','false','true','false','q_request_1c_4','none'),
(3731,'1st Circle Request: 5C','false','quest',0,'stackable','steel','none',-1,0,0,'false','false','true','false','q_request_1c_5','none'),
(3732,'1st Circle Request: 6C','false','quest',0,'stackable','steel','none',-1,0,0,'false','false','true','false','q_request_1c_6','none'),
(3733,'1st Circle Request: 7C','false','quest',0,'stackable','steel','none',-1,0,0,'false','false','true','false','q_request_1c_7','none'),
(3734,'1st Circle Request: 8C','false','quest',0,'stackable','steel','none',-1,0,0,'false','false','true','false','q_request_1c_8','none'),
(3735,'1st Circle Request: 9C','false','quest',0,'stackable','steel','none',-1,0,0,'false','false','true','false','q_request_1c_9','none'),
(3736,'1st Circle Request: 10C','false','quest',0,'stackable','steel','none',-1,0,0,'false','false','true','false','q_request_1c_10','none'),
(3737,'1st Circle Request: 11C','false','quest',0,'stackable','steel','none',-1,0,0,'false','false','true','false','q_request_1c_11','none'),
(3738,'1st Circle Request: 12C','false','quest',0,'stackable','steel','none',-1,0,0,'false','false','true','false','q_request_1c_12','none'),
(3739,'1st Circle Request: 1B','false','quest',0,'stackable','steel','none',-1,0,0,'false','false','true','false','q_request_1u_1','none'),
(3740,'1st Circle Request: 2B','false','quest',0,'stackable','steel','none',-1,0,0,'false','false','true','false','q_request_1u_2','none'),
(3741,'1st Circle Request: 3B','false','quest',0,'stackable','steel','none',-1,0,0,'false','false','true','false','q_request_1u_3','none'),
(3742,'1st Circle Request: 4B','false','quest',0,'stackable','steel','none',-1,0,0,'false','false','true','false','q_request_1u_4','none'),
(3743,'1st Circle Request: 5B','false','quest',0,'stackable','steel','none',-1,0,0,'false','false','true','false','q_request_1u_5','none'),
(3744,'1st Circle Request: 6B','false','quest',0,'stackable','steel','none',-1,0,0,'false','false','true','false','q_request_1u_6','none'),
(3745,'1st Circle Request: 1A','false','quest',0,'stackable','steel','none',-1,0,0,'false','false','true','false','q_request_1r_1','none'),
(3746,'1st Circle Request: 2A','false','quest',0,'stackable','steel','none',-1,0,0,'false','false','true','false','q_request_1r_2','none'),
(3747,'1st Circle Request: 3A','false','quest',0,'stackable','steel','none',-1,0,0,'false','false','true','false','q_request_1r_3','none'),
(3748,'2nd Circle Request: 1C','false','quest',0,'stackable','steel','none',-1,0,0,'false','false','true','false','q_request_2c_1','none'),
(3749,'2nd Circle Request 2C','false','quest',0,'stackable','steel','none',-1,0,0,'false','false','true','false','q_request_2c_2','none'),
(3750,'2nd Circle Request 3C','false','quest',0,'stackable','steel','none',-1,0,0,'false','false','true','false','q_request_2c_3','none'),
(3751,'2nd Circle Request: 4C','false','quest',0,'stackable','steel','none',-1,0,0,'false','false','true','false','q_request_2c_4','none'),
(3752,'2nd Circle Request: 5C','false','quest',0,'stackable','steel','none',-1,0,0,'false','false','true','false','q_request_2c_5','none'),
(3753,'2nd Circle Request: 6C','false','quest',0,'stackable','steel','none',-1,0,0,'false','false','true','false','q_request_2c_6','none'),
(3754,'2nd Circle Request: 7C','false','quest',0,'stackable','steel','none',-1,0,0,'false','false','true','false','q_request_2c_7','none'),
(3755,'2nd Circle Request: 8C','false','quest',0,'stackable','steel','none',-1,0,0,'false','false','true','false','q_request_2c_8','none'),
(3756,'2nd Circle Request: 9C','false','quest',0,'stackable','steel','none',-1,0,0,'false','false','true','false','q_request_2c_9','none'),
(3757,'2nd Circle Request: 10C','false','quest',0,'stackable','steel','none',-1,0,0,'false','false','true','false','q_request_2c_10','none'),
(3758,'2nd Circle Request: 11C','false','quest',0,'stackable','steel','none',-1,0,0,'false','false','true','false','q_request_2c_11','none'),
(3759,'2nd Circle Request: 12C','false','quest',0,'stackable','steel','none',-1,0,0,'false','false','true','false','q_request_2c_12','none'),
(3760,'2nd Circle Request: 1B','false','quest',0,'stackable','steel','none',-1,0,0,'false','false','true','false','q_request_2u_1','none'),
(3761,'2nd Circle Request: 2B','false','quest',0,'stackable','steel','none',-1,0,0,'false','false','true','false','q_request_2u_2','none'),
(3762,'2nd Circle Request: 3B','false','quest',0,'stackable','steel','none',-1,0,0,'false','false','true','false','q_request_2u_3','none'),
(3763,'2nd Circle Request: 4B','false','quest',0,'stackable','steel','none',-1,0,0,'false','false','true','false','q_request_2u_4','none'),
(3764,'2nd Circle Request: 5B','false','quest',0,'stackable','steel','none',-1,0,0,'false','false','true','false','q_request_2u_5','none'),
(3765,'2nd Circle Request: 6B','false','quest',0,'stackable','steel','none',-1,0,0,'false','false','true','false','q_request_2u_6','none'),
(3766,'2nd Circle Request: 1A','false','quest',0,'stackable','steel','none',-1,0,0,'false','false','true','false','q_request_2r_1','none'),
(3767,'2nd Circle Request: 2A','false','quest',0,'stackable','steel','none',-1,0,0,'false','false','true','false','q_request_2r_2','none'),
(3768,'2nd Circle Request: 3A','false','quest',0,'stackable','steel','none',-1,0,0,'false','false','true','false','q_request_2r_3','none'),
(3769,'Charm of Kadesh','false','quest',0,'stackable','steel','none',-1,0,0,'false','false','true','false','q_charm_of_kadesh','none'),
(3770,'Timak Jade Necklace','false','quest',0,'stackable','steel','none',-1,0,0,'false','false','true','false','q_timak_jade_necklace','none'),
(3771,'Enchanted Golem Shard','false','quest',0,'stackable','steel','none',-1,0,0,'false','false','true','false','q_en_golem_shard','none'),
(3772,'Giant Monster Eye Meat','false','quest',0,'stackable','steel','none',-1,0,0,'false','false','true','false','q_g_monstereye_meat','none'),
(3773,'Dire Wyrm Egg','false','quest',0,'stackable','steel','none',-1,0,0,'false','false','true','false','q_dire_wyrm_egg','none'),
(3774,'Grd Basilisk Talon','false','quest',0,'stackable','steel','none',-1,0,0,'false','false','true','false','q_grd_basilisk_talon','none'),
(3775,'Revenant\'s Chains','false','quest',0,'stackable','steel','none',-1,0,0,'false','false','true','false','q_revenants_chains','none'),
(3776,'Windsus Tusk','false','quest',0,'stackable','steel','none',-1,0,0,'false','false','true','false','q_windsus_tusk','none'),
(3777,'Grandis Skull','false','quest',0,'stackable','steel','none',-1,0,0,'false','false','true','false','q_grandis_skull','none'),
(3778,'Taik Obsidian Amulet','false','quest',0,'stackable','steel','none',-1,0,0,'false','false','true','false','q_taik_obsidian_amulet','none'),
(3779,'Karul Bugbear Head','false','quest',0,'stackable','steel','none',-1,0,0,'false','false','true','false','q_karul_bugbear_head','none'),
(3780,'Tamlin Ivory Charm','false','quest',0,'stackable','steel','none',-1,0,0,'false','false','true','false','q_tamlin_ivory_charm','none'),
(3781,'Fang of Narak','false','quest',0,'stackable','steel','none',-1,0,0,'false','false','true','false','q_fang_of_narak','none'),
(3782,'Enchanted Gargoyle Horn','false','quest',0,'stackable','steel','none',-1,0,0,'false','false','true','false','q_en_gargoyle_horn','none'),
(3783,'Coiled Serpent Totem','false','quest',0,'stackable','steel','none',-1,0,0,'false','false','true','false','q_coiled_serpent_totem','none'),
(3784,'Totem of Kadesh','false','quest',0,'stackable','steel','none',-1,0,0,'false','false','true','false','q_totem_of_kadesh','none'),
(3785,'Kaiki\'s Head','false','quest',0,'stackable','steel','none',-1,0,0,'false','false','true','false','q_kaikis_head','none'),
(3786,'Kronbe Venom Sac','false','quest',0,'stackable','steel','none',-1,0,0,'false','false','true','false','q_kronbe_venom_sac','none'),
(3787,'Eva\'s Charm','false','quest',0,'stackable','steel','none',-1,0,0,'false','false','true','false','q_evas_charm','none'),
(3788,'Titan\'s Tablet','false','quest',0,'stackable','steel','none',-1,0,0,'false','false','true','false','q_titans_tablet','none'),
(3789,'Book of Shunaiman','false','quest',0,'stackable','steel','none',-1,0,0,'false','false','true','false','q_book_of_shunaiman','none'),
(3790,'Rotting Tree Spores','false','quest',0,'stackable','steel','none',-1,0,0,'false','false','true','false','q_rot_tree_spores','none'),
(3791,'Trisalim Venom Sac','false','quest',0,'stackable','steel','none',-1,0,0,'false','false','true','false','q_trisalim_venom_sac','none'),
(3792,'Taik Orc Totem','false','quest',0,'stackable','steel','none',-1,0,0,'false','false','true','false','q_taik_orc_totem','none'),
(3793,'Harit Barbed Necklace','false','quest',0,'stackable','steel','none',-1,0,0,'false','false','true','false','q_harit_barbed_necklace','none'),
(3794,'Coin of Old Empire','false','quest',0,'stackable','steel','none',-1,0,0,'false','false','true','false','q_coin_of_old_empire','none'),
(3795,'Skin of Farcran','false','quest',0,'stackable','steel','none',-1,0,0,'false','false','true','false','q_skin_of_farcran','none'),
(3796,'Tempest Shard','false','quest',0,'stackable','steel','none',-1,0,0,'false','false','true','false','q_tempest_shard','none'),
(3797,'Tsunami Shard','false','quest',0,'stackable','steel','none',-1,0,0,'false','false','true','false','q_tsunami_shard','none'),
(3798,'Satyr Mane','false','quest',0,'stackable','steel','none',-1,0,0,'false','false','true','false','q_pan_ruem_mane','none'),
(3799,'Hamadryad Shard','false','quest',0,'stackable','steel','none',-1,0,0,'false','false','true','false','q_hamadryad_shard','none'),
(3800,'Vanor Silenos Mane','false','quest',0,'stackable','steel','none',-1,0,0,'false','false','true','false','q_vanor_silenos_mane','none'),
(3801,'Talk Bugbear Totem','false','quest',0,'stackable','steel','none',-1,0,0,'false','false','true','false','q_talk_bugbear_totem','none'),
(3802,'Okun\'s Head','false','quest',0,'stackable','steel','none',-1,0,0,'false','false','true','false','q_okuns_head','none'),
(3803,'Kakran\'s Head','false','quest',0,'stackable','steel','none',-1,0,0,'false','false','true','false','q_kakrans_head','none'),
(3804,'Narcissus\'s Soulstone','false','quest',0,'stackable','steel','none',-1,0,0,'false','false','true','false','q_narcissus_soulstone','none'),
(3805,'Deprive Eye','false','quest',0,'stackable','steel','none',-1,0,0,'false','false','true','false','q_diprive_eye','none'),
(3806,'Unicorn\'s Horn','false','quest',0,'stackable','steel','none',-1,0,0,'false','false','true','false','q_unicorns_horn','none'),
(3807,'Kerunos\'s Gold Mane','false','quest',0,'stackable','steel','none',-1,0,0,'false','false','true','false','q_kerunos_gold_mane','none'),
(3808,'Skull of Executed','false','quest',0,'stackable','steel','none',-1,0,0,'false','false','true','false','q_skull_of_executed','none'),
(3809,'Bust of Travis','false','quest',0,'stackable','steel','none',-1,0,0,'false','false','true','false','q_bust_of_travis','none'),
(3810,'Sword of Cadmus','false','quest',0,'stackable','steel','none',-1,0,0,'false','false','true','false','q_sword_of_cadmus','none'),
(3811,'Coin Diagram','false','quest',0,'stackable','steel','none',-1,0,0,'false','false','true','false','q_coin_diagram','none'),
(3812,'Kaldis Gold Dragon','false','quest',0,'stackable','steel','none',-1,0,0,'false','false','true','false','q_kaldis_gold_dragon','none'),
(3813,'Coin Collector Membership 1','false','quest',0,'stackable','steel','none',-1,0,0,'false','false','true','false','q_cc_membership_1','none'),
(3814,'Coin Collector Membership 2','false','quest',0,'stackable','steel','none',-1,0,0,'false','false','true','false','q_cc_membership_2','none'),
(3815,'Coin Collector Membership 3','false','quest',0,'stackable','steel','none',-1,0,0,'false','false','true','false','q_cc_membership_3','none'),
(3816,'Fairy Stone','false','quest',0,'stackable','steel','none',-1,0,0,'false','false','true','false','q_fairy_stone','none'),
(3817,'Deluxe Fairy Stone','false','quest',0,'stackable','steel','none',-1,0,0,'false','false','true','false','q_fairy_stone_delux','none'),
(3818,'Fairy Stone List','false','quest',0,'stackable','steel','none',-1,0,0,'false','false','true','false','q_list_of_stuff_for_fs','none'),
(3819,'Deluxe Fairy Stone List','false','quest',0,'stackable','steel','none',-1,0,0,'false','false','true','false','q_list_of_stuff_for_fsd','none'),
(3820,'Toad Lord Back Skin','false','quest',0,'stackable','steel','none',-1,0,0,'false','false','true','false','q_inpicios_back_skin','none'),
(3821,'Juice of Monkshood','false','quest',0,'stackable','steel','none',-1,0,0,'false','false','true','false','q_juice_of_monkshood','none'),
(3822,'Scale of Drake Exarion','false','quest',0,'stackable','steel','none',-1,0,0,'false','false','true','false','q_scale_of_drake_exarion','none'),
(3823,'Egg of Drake Exarion','false','quest',0,'stackable','steel','none',-1,0,0,'false','false','true','false','q_egg_of_drake_exarion','none'),
(3824,'Scale of Drake Zwov','false','quest',0,'stackable','steel','none',-1,0,0,'false','false','true','false','q_scale_of_drake_zwov','none'),
(3825,'Egg of Drake Zwov','false','quest',0,'stackable','steel','none',-1,0,0,'false','false','true','false','q_egg_of_drake_zwov','none'),
(3826,'Scale of Drake Kalibran','false','quest',0,'stackable','steel','none',-1,0,0,'false','false','true','false','q_scale_of_drake_kalibran','none'),
(3827,'Egg of Drake Kalibran','false','quest',0,'stackable','steel','none',-1,0,0,'false','false','true','false','q_egg_of_drake_kalibran','none'),
(3828,'Scale of Wyvern Suzet','false','quest',0,'stackable','steel','none',-1,0,0,'false','false','true','false','q_scale_of_wyrm_suzet','none'),
(3829,'Egg of Wyvern Suzet','false','quest',0,'stackable','steel','none',-1,0,0,'false','false','true','false','q_egg_of_wyrm_suzet','none'),
(3830,'Scale of Wyvern Shamhai','false','quest',0,'stackable','steel','none',-1,0,0,'false','false','true','false','q_scale_of_wyrm_shamhai','none'),
(3831,'Egg of Wyvern Shamhai','false','quest',0,'stackable','steel','none',-1,0,0,'false','false','true','false','q_egg_of_wyrm_shamhai','none'),
(3832,'Herb of Harit','false','none',0,'normal','steel','none',-1,0,0,'true','false','true','true','q_herb_of_breka','none'),
(3833,'Herb of Vanor','false','none',0,'normal','steel','none',-1,0,0,'true','false','true','true','q_herb_of_vanor','none'),
(3834,'Herb of Oel Mahum','false','none',0,'normal','steel','none',-1,0,0,'true','false','true','true','q_herb_of_oel_mahum','none'),
(3835,'Blood of Eva','false','none',0,'normal','steel','none',-1,0,0,'true','false','true','true','q_blood_of_eva','none'),
(3836,'Athrea\'s Coin','false','none',0,'normal','steel','none',-1,0,0,'true','false','true','true','q_athreas_coin','none'),
(3837,'Symbol of Loyalty','false','none',0,'stackable','steel','none',-1,0,0,'true','false','true','true','q_symbol_of_loyalty','none'),
(3838,'Recipe: Titan\'s Powerstone','false','recipe',30,'stackable','liquid','none',-1,0,0,'true','false','true','true','q_rp_titans_powerstone','recipe'),
(3839,'Mist Drake Egg','false','none',0,'stackable','steel','none',-1,0,0,'true','false','true','true','q_mist_drake_egg','none'),
(3840,'Blitz Wyrm Egg','false','none',0,'stackable','steel','none',-1,0,0,'true','false','true','true','q_blitz_wyrm_egg','none'),
(3841,'Drake Egg','false','none',0,'stackable','steel','none',-1,0,0,'true','false','true','true','q_drake_egg','none'),
(3842,'Thunder Wyrm Egg','false','none',0,'stackable','steel','none',-1,0,0,'true','false','true','true','q_thunderwyrm_egg','none'),
(3843,'Brooch of the Magpie','false','none',0,'normal','steel','none',-1,1000,0,'true','false','true','true','q_magipie_brooch','none'),
(3844,'Nebulite Crystals','false','none',0,'stackable','steel','none',-1,0,0,'true','false','true','true','q_nebulite_crystals','none'),
(3845,'Broken Titan\'s Powerstone','false','none',0,'stackable','steel','none',-1,500,0,'true','false','true','true','q_bk_titan_powerstone','none'),
(3846,'Titan\'s Powerstone','false','none',0,'stackable','steel','none',-1,0,0,'true','false','true','true','q_titan_powerstone','none'),
(3847,'Imperial Key','false','none',0,'stackable','steel','none',-1,0,0,'true','false','true','true','q_imperial_key','none'),
(3848,'Undead Ash','false','quest',0,'stackable','steel','none',-1,0,0,'false','false','true','false','q_undead_ash','none'),
(3849,'Bloody Axe Insignia','false','quest',0,'stackable','steel','none',-1,0,0,'false','false','true','false','q_bloodyaxe_insignia','none'),
(3850,'Delu Lizardman Fang','false','quest',0,'stackable','steel','none',-1,0,0,'false','false','true','false','q_delu_lizardman_fang','none'),
(3851,'Stakato Talon','false','quest',0,'stackable','steel','none',-1,0,0,'false','false','true','false','q_stakato_talon','none'),
(3852,'Feather of Gabrielle','false','quest',0,'stackable','steel','none',-1,0,0,'false','false','true','false','q_feather_of_gabrielle','none'),
(3853,'Marsh Stalker Horn','false','quest',0,'stackable','steel','none',-1,0,0,'false','false','true','false','q_marsh_stalker_horn','none'),
(3854,'Marsh Drake Talons','false','quest',0,'stackable','steel','none',-1,0,0,'false','false','true','false','q_marsh_drake_talon','none'),
(3855,'Kranrot Skin','false','quest',0,'stackable','steel','none',-1,0,0,'false','false','true','false','q_kranrot_skin','none'),
(3856,'Hamrut Leg','false','quest',0,'stackable','steel','none',-1,0,0,'false','false','true','false','q_hamrut_leg','none'),
(3857,'Remains of Sacrified','false','quest',0,'stackable','steel','none',-1,0,0,'false','false','true','false','q_remains_of_sacrificed','none'),
(3858,'Totem of Land Dragon','false','quest',0,'stackable','steel','none',-1,0,0,'false','false','true','false','q_totem_of_earthdragon','none'),
(3859,'1st Fragment of Abyss Jewel','false','quest',0,'stackable','steel','none',-1,0,0,'false','false','true','false','q_frag_of_abyss_jewel1','none'),
(3860,'2nd Fragment of Abyss Jewel','false','quest',0,'stackable','steel','none',-1,0,0,'false','false','true','false','q_frag_of_abyss_jewel2','none'),
(3861,'3rd Fragment of Abyss Jewel','false','quest',0,'stackable','steel','none',-1,0,0,'false','false','true','false','q_frag_of_abyss_jewel3','none'),
(3862,'Mara Fang','false','quest',0,'stackable','steel','none',-1,0,0,'false','false','true','false','q_mara_fang','none'),
(3863,'Musfel Fang','false','quest',0,'stackable','steel','none',-1,0,0,'false','false','true','false','q_musfel_fang','none'),
(3864,'Mark of Watchman','false','quest',0,'stackable','steel','none',-1,0,0,'false','false','true','false','q_mark_of_watchers','none'),
(3865,'Portal Stone','false','quest',0,'stackable','steel','none',-1,0,0,'false','false','true','false','q_portal_stone_1','none'),
(3866,'Gustav\'s 1st Letter','false','quest',0,'stackable','steel','none',-1,0,0,'false','false','true','false','q_gustafs_letter1','none'),
(3867,'Gustav\'s 2nd Letter','false','quest',0,'stackable','steel','none',-1,0,0,'false','false','true','false','q_gustafs_letter2','none'),
(3868,'Gustav\'s 3rd Letter','false','quest',0,'stackable','steel','none',-1,0,0,'false','false','true','false','q_gustafs_letter3','none'),
(3869,'Scepter of Judgment','false','quest',0,'stackable','steel','none',-1,0,0,'false','false','true','false','q_scepter_of_judgemnt','none'),
(3870,'Seal of Aspiration','false','quest',0,'stackable','steel','none',-1,0,0,'false','false','false','false','q_proof_of_aspiration','none'),
(3871,'Black Anvil Coin','false','quest',0,'stackable','steel','none',-1,0,0,'false','false','true','false','q_black_anvil_coin','none'),
(3872,'Antidote Recipe List','false','quest',0,'stackable','steel','none',-1,0,0,'false','false','true','false','q_antidote_recipe_list','none'),
(3873,'Voucher of Faith','false','quest',0,'stackable','steel','none',-1,0,0,'false','false','true','false','q_voucher_of_faith','none'),
(3874,'Alliance Manifesto','false','quest',0,'stackable','steel','none',-1,0,0,'false','false','false','false','q_proof_of_alliance','none'),
(3875,'L2Day - A','false','none',0,'stackable','steel','none',-1,0,0,'true','true','true','true','alphabet_a','none'),
(3876,'L2Day - C','false','none',0,'stackable','steel','none',-1,0,0,'true','true','true','true','alphabet_c','none'),
(3877,'L2Day - E','false','none',0,'stackable','steel','none',-1,0,0,'true','true','true','true','alphabet_e','none'),
(3878,'L2Day - F','false','none',0,'stackable','steel','none',-1,0,0,'true','true','true','true','alphabet_f','none'),
(3879,'L2Day - G','false','none',0,'stackable','steel','none',-1,0,0,'true','true','true','true','alphabet_g','none'),
(3880,'L2Day - H','false','none',0,'stackable','steel','none',-1,0,0,'true','true','true','true','alphabet_h','none'),
(3881,'L2Day - I','false','none',0,'stackable','steel','none',-1,0,0,'true','true','true','true','alphabet_i','none'),
(3882,'L2Day - L','false','none',0,'stackable','steel','none',-1,0,0,'true','true','true','true','alphabet_l','none'),
(3883,'L2Day - N','false','none',0,'stackable','steel','none',-1,0,0,'true','true','true','true','alphabet_n','none'),
(3884,'L2Day - O','false','none',0,'stackable','steel','none',-1,0,0,'true','true','true','true','alphabet_o','none'),
(3885,'L2Day - R','false','none',0,'stackable','steel','none',-1,0,0,'true','true','true','true','alphabet_r','none'),
(3886,'L2Day - S','false','none',0,'stackable','steel','none',-1,0,0,'true','true','true','true','alphabet_s','none'),
(3887,'L2Day - T','false','none',0,'stackable','steel','none',-1,0,0,'true','true','true','true','alphabet_t','none'),
(3888,'L2Day - II','false','none',0,'stackable','steel','none',-1,0,0,'true','true','true','true','alphabet_ii','none'),
(3889,'Potion of Recovery','false','potion',180,'stackable','liquid','none',-1,0,0,'true','true','true','true','q_potion_of_recovery','potion'),
(3890,'Herald of Slayer','false','quest',0,'stackable','steel','none',-1,0,0,'false','false','true','false','q_herald_of_slayer','none'),
(3926,'L2Day - Scroll of Guidance','false','scroll',120,'stackable','paper','none',-1,0,0,'true','true','true','true','l2day_scroll_of_guidance','scroll'),
(3927,'L2Day - Scroll of Death Whisper','false','scroll',120,'stackable','paper','none',-1,0,0,'true','true','true','true','l2day_scroll_of_death_whisper','scroll'),
(3928,'L2Day - Scroll of Focus','false','scroll',120,'stackable','paper','none',-1,0,0,'true','true','true','true','l2day_scroll_of_focus','scroll'),
(3929,'L2Day - Scroll of Greater Acumen','false','scroll',120,'stackable','paper','none',-1,0,0,'true','true','true','true','l2day_scroll_of_greater_acumen','scroll'),
(3930,'L2Day - Scroll of Haste','false','scroll',120,'stackable','paper','none',-1,0,0,'true','true','true','true','l2day_scroll_of_haste','scroll'),
(3931,'L2Day - Scroll of Agility','false','scroll',120,'stackable','paper','none',-1,0,0,'true','true','true','true','l2day_scroll_of_agility','scroll'),
(3932,'L2Day - Scroll of Mystic Empower','false','scroll',120,'stackable','paper','none',-1,0,0,'true','true','true','true','l2day_scroll_of_empower','scroll'),
(3933,'L2Day - Scroll of Might','false','scroll',120,'stackable','paper','none',-1,0,0,'true','true','true','true','l2day_scroll_of_might','scroll'),
(3934,'L2Day - Scroll of Windwalk','false','scroll',120,'stackable','paper','none',-1,0,0,'true','true','true','true','l2day_scroll_of_wind_walk','scroll'),
(3935,'L2Day - Scroll of Shield','false','scroll',120,'stackable','paper','none',-1,0,0,'true','true','true','true','l2day_scroll_of_shield','scroll'),
(3936,'Blessed Scroll of Resurrection','false','scroll',120,'stackable','paper','none',-1,400000,0,'true','true','true','true','blessed_scroll_of_resurrection','scroll'),
(3940,'Blueprint: Summon Siege Golem','false','spellbook',120,'stackable','paper','none',-1,4800,0,'true','true','true','true','sb_summon_siege_golem','none'),
(3941,'Spellbook: Mass Resurrection','false','spellbook',120,'stackable','paper','none',-1,4600,0,'true','true','true','true','sb_mass_ressurection1','none'),
(3942,'Spellbook: Party Return','false','spellbook',120,'stackable','paper','none',-1,4600,0,'true','true','true','true','sb_party_recall1','none'),
(3943,'Amulet: Pa''agrio\'s Heart','false','spellbook',120,'stackable','paper','none',-1,3850,0,'true','true','true','true','sb_heart_of_paagrio1','none'),
(3944,'Spellbook: Decrease Weight','false','spellbook',120,'stackable','paper','none',-1,2450,0,'true','true','true','true','sb_decrease_weight1','none'),
(3945,'Boat Ticket: Talking Island to Giran','false','none',20,'stackable','paper','none',-1,8000,0,'true','true','true','true','boat_ticket_talk_kiran','none'),
(3946,'Boat Ticket: Giran to Talking Island','false','none',20,'stackable','paper','none',-1,8000,0,'true','true','true','true','boat_ticket_kiran_talk','none'),
(3947,'Blessed Spiritshot: No Grade','false','shot',5,'stackable','paper','none',-1,35,0,'true','true','true','true','blessed_spiritshot_none','none'),
(3948,'Blessed Spiritshot: D-Grade','false','shot',5,'stackable','paper','d',-1,45,0,'true','true','true','true','blessed_spiritshot_d','none'),
(3949,'Blessed Spiritshot: C-Grade','false','shot',3,'stackable','paper','c',-1,90,0,'true','true','true','true','blessed_spiritshot_c','none'),
(3950,'Blessed Spiritshot: B-Grade','false','shot',3,'stackable','paper','b',-1,245,0,'true','true','true','true','blessed_spiritshot_b','none'),
(3951,'Blessed Spiritshot: A-Grade','false','shot',2,'stackable','paper','a',-1,290,0,'true','true','true','true','blessed_spiritshot_a','none'),
(3952,'Blessed Spiritshot: S Grade','false','shot',2,'stackable','paper','s',-1,350,0,'true','true','true','true','blessed_spiritshot_s','none'),
(3953,'Recipe: Blessed Spiritshot D','false','recipe',30,'stackable','liquid','none',-1,5000,0,'true','true','true','true','rp_blessed_spiritshot_d','recipe'),
(3954,'Recipe: Blessed Spiritshot C','false','recipe',30,'stackable','liquid','none',-1,60000,0,'true','true','true','true','rp_blessed_spiritshot_c','recipe'),
(3955,'Recipe: Blessed Spiritshot B','false','recipe',30,'stackable','liquid','none',-1,100000,0,'true','true','true','true','rp_blessed_spiritshot_b','recipe'),
(3956,'Recipe: Blessed Spiritshot A','false','recipe',30,'stackable','liquid','none',-1,150000,0,'true','true','true','true','rp_blessed_spiritshot_a','recipe'),
(3957,'Recipe: Blessed Spiritshot S','false','recipe',30,'stackable','liquid','none',-1,450000,0,'true','true','true','true','rp_blessed_spiritshot_s','recipe'),
(3958,'L2Day - Blessed Escape Effect','false','scroll',120,'stackable','paper','none',-1,0,0,'true','true','true','true','l2day_scroll_of_escape','scroll'),
(3959,'L2Day - Blessed Resurrection Effect','false','scroll',120,'stackable','paper','none',-1,0,0,'true','true','true','true','l2day_scroll_of_resurrection','scroll'),
(3960,'Mercenary Posting Ticket (Sword/Stationary)','false','castle_guard',0,'stackable','paper','none',-1,30000,0,'true','true','true','true','mticket_gludio_sword_fix','castle_guard'),
(3961,'Mercenary Posting Ticket (Spear/Stationary)','false','castle_guard',0,'stackable','paper','none',-1,40000,0,'true','true','true','true','mticket_gludio_pole_fix','castle_guard'),
(3962,'Mercenary Posting Ticket (Bow/Stationary)','false','castle_guard',0,'stackable','paper','none',-1,50000,0,'true','true','true','true','mticket_gludio_bow_fix','castle_guard'),
(3963,'Mercenary Posting Ticket (Cleric/Stationary)','false','castle_guard',0,'stackable','paper','none',-1,150000,0,'true','true','true','true','mticket_gludio_cleric_fix','castle_guard'),
(3964,'Mercenary Posting Ticket (Wizard/Stationary)','false','castle_guard',0,'stackable','paper','none',-1,150000,0,'true','true','true','true','mticket_gludio_wizard_fix','castle_guard'),
(3965,'Mercenary Posting Ticket (Sword/Mobile)','false','castle_guard',0,'stackable','paper','none',-1,30000,0,'true','true','true','true','mticket_gludio_sword_move','castle_guard'),
(3966,'Mercenary Posting Ticket (Spear/Mobile)','false','castle_guard',0,'stackable','paper','none',-1,40000,0,'true','true','true','true','mticket_gludio_pole_move','castle_guard'),
(3967,'Mercenary Posting Ticket (Bow/Mobile)','false','castle_guard',0,'stackable','paper','none',-1,50000,0,'true','true','true','true','mticket_gludio_bow_move','castle_guard'),
(3968,'Mercenary Posting Ticket (Cleric/Mobile)','false','castle_guard',0,'stackable','paper','none',-1,150000,0,'true','true','true','true','mticket_gludio_cleric_move','castle_guard'),
(3969,'Mercenary Posting Ticket (Wizard/Mobile)','false','castle_guard',0,'stackable','paper','none',-1,150000,0,'true','true','true','true','mticket_gludio_wizard_move','castle_guard'),
(3970,'Mercenary Posting Ticket (Teleporter1)','false','castle_guard',0,'stackable','paper','none',-1,100000,0,'true','true','true','true','mticket_gludio_teleporter1','castle_guard'),
(3971,'Mercenary Posting Ticket (Teleporter2)','false','castle_guard',0,'stackable','paper','none',-1,100000,0,'true','true','true','true','mticket_gludio_teleporter2','castle_guard'),
(3972,'Mercenary Posting Ticket (Teleporter3)','false','castle_guard',0,'stackable','paper','none',-1,100000,0,'true','true','true','true','mticket_gludio_teleporter3','castle_guard'),
(3973,'Mercenary Posting Ticket (Sword/Stationary)','false','castle_guard',0,'stackable','paper','none',-1,30000,0,'true','true','true','true','mticket_dion_sword_fix','castle_guard'),
(3974,'Mercenary Posting Ticket (Spear/Stationary)','false','castle_guard',0,'stackable','paper','none',-1,40000,0,'true','true','true','true','mticket_dion_pole_fix','castle_guard'),
(3975,'Mercenary Posting Ticket (Bow/Stationary)','false','castle_guard',0,'stackable','paper','none',-1,50000,0,'true','true','true','true','mticket_dion_bow_fix','castle_guard'),
(3976,'Mercenary Posting Ticket (Cleric/Stationary)','false','castle_guard',0,'stackable','paper','none',-1,150000,0,'true','true','true','true','mticket_dion_cleric_fix','castle_guard'),
(3977,'Mercenary Posting Ticket (Wizard/Stationary)','false','castle_guard',0,'stackable','paper','none',-1,150000,0,'true','true','true','true','mticket_dion_wizard_fix','castle_guard'),
(3978,'Mercenary Posting Ticket (Sword/Mobile)','false','castle_guard',0,'stackable','paper','none',-1,30000,0,'true','true','true','true','mticket_dion_sword_move','castle_guard'),
(3979,'Mercenary Posting Ticket (Spear/Mobile)','false','castle_guard',0,'stackable','paper','none',-1,40000,0,'true','true','true','true','mticket_dion_pole_move','castle_guard'),
(3980,'Mercenary Posting Ticket (Bow/Mobile)','false','castle_guard',0,'stackable','paper','none',-1,50000,0,'true','true','true','true','mticket_dion_bow_move','castle_guard'),
(3981,'Mercenary Posting Ticket (Cleric/Mobile)','false','castle_guard',0,'stackable','paper','none',-1,150000,0,'true','true','true','true','mticket_dion_cleric_move','castle_guard'),
(3982,'Mercenary Posting Ticket (Wizard/Mobile)','false','castle_guard',0,'stackable','paper','none',-1,150000,0,'true','true','true','true','mticket_dion_wizard_move','castle_guard'),
(3983,'Mercenary Posting Ticket (Teleporter1)','false','castle_guard',0,'stackable','paper','none',-1,100000,0,'true','true','true','true','mticket_dion_teleporter1','castle_guard'),
(3984,'Mercenary Posting Ticket (Teleporter2)','false','castle_guard',0,'stackable','paper','none',-1,100000,0,'true','true','true','true','mticket_dion_teleporter2','castle_guard'),
(3985,'Mercenary Posting Ticket (Teleporter3)','false','castle_guard',0,'stackable','paper','none',-1,100000,0,'true','true','true','true','mticket_dion_teleporter3','castle_guard'),
(3986,'Mercenary Posting Ticket (Sword/Stationary)','false','castle_guard',0,'stackable','paper','none',-1,30000,0,'true','true','true','true','mticket_giran_sword_fix','castle_guard'),
(3987,'Mercenary Posting Ticket (Spear/Stationary)','false','castle_guard',0,'stackable','paper','none',-1,40000,0,'true','true','true','true','mticket_giran_pole_fix','castle_guard'),
(3988,'Mercenary Posting Ticket (Bow/Stationary)','false','castle_guard',0,'stackable','paper','none',-1,50000,0,'true','true','true','true','mticket_giran_bow_fix','castle_guard'),
(3989,'Mercenary Posting Ticket (Cleric/Stationary)','false','castle_guard',0,'stackable','paper','none',-1,150000,0,'true','true','true','true','mticket_giran_cleric_fix','castle_guard'),
(3990,'Mercenary Posting Ticket (Wizard/Stationary)','false','castle_guard',0,'stackable','paper','none',-1,150000,0,'true','true','true','true','mticket_giran_wizard_fix','castle_guard'),
(3991,'Mercenary Posting Ticket (Sword/Mobile)','false','castle_guard',0,'stackable','paper','none',-1,30000,0,'true','true','true','true','mticket_giran_sword_move','castle_guard'),
(3992,'Mercenary Posting Ticket (Spear/Mobile)','false','castle_guard',0,'stackable','paper','none',-1,40000,0,'true','true','true','true','mticket_giran_pole_move','castle_guard'),
(3993,'Mercenary Posting Ticket (Bow/Mobile)','false','castle_guard',0,'stackable','paper','none',-1,50000,0,'true','true','true','true','mticket_giran_bow_move','castle_guard'),
(3994,'Mercenary Posting Ticket (Cleric/Mobile)','false','castle_guard',0,'stackable','paper','none',-1,150000,0,'true','true','true','true','mticket_giran_cleric_move','castle_guard'),
(3995,'Mercenary Posting Ticket (Wizard/Mobile)','false','castle_guard',0,'stackable','paper','none',-1,150000,0,'true','true','true','true','mticket_giran_wizard_move','castle_guard'),
(3996,'Mercenary Posting Ticket (Teleporter1)','false','castle_guard',0,'stackable','paper','none',-1,100000,0,'true','true','true','true','mticket_giran_teleporter1','castle_guard'),
(3997,'Mercenary Posting Ticket (Teleporter2)','false','castle_guard',0,'stackable','paper','none',-1,100000,0,'true','true','true','true','mticket_giran_teleporter2','castle_guard'),
(3998,'Mercenary Posting Ticket (Teleporter3)','false','castle_guard',0,'stackable','paper','none',-1,100000,0,'true','true','true','true','mticket_giran_teleporter3','castle_guard'),
(3999,'Mercenary Posting Ticket (Sword/Stationary)','false','castle_guard',0,'stackable','paper','none',-1,30000,0,'true','true','true','true','mticket_oren_sword_fix','castle_guard'),
(4000,'Mercenary Posting Ticket (Spear/Stationary)','false','castle_guard',0,'stackable','paper','none',-1,40000,0,'true','true','true','true','mticket_oren_pole_fix','castle_guard'),
(4001,'Mercenary Posting Ticket (Bow/Stationary)','false','castle_guard',0,'stackable','paper','none',-1,50000,0,'true','true','true','true','mticket_oren_bow_fix','castle_guard'),
(4002,'Mercenary Posting Ticket (Cleric/Stationary)','false','castle_guard',0,'stackable','paper','none',-1,150000,0,'true','true','true','true','mticket_oren_cleric_fix','castle_guard'),
(4003,'Mercenary Posting Ticket (Wizard/Stationary)','false','castle_guard',0,'stackable','paper','none',-1,150000,0,'true','true','true','true','mticket_oren_wizard_fix','castle_guard'),
(4004,'Mercenary Posting Ticket (Sword/Mobile)','false','castle_guard',0,'stackable','paper','none',-1,30000,0,'true','true','true','true','mticket_oren_sword_move','castle_guard'),
(4005,'Mercenary Posting Ticket (Spear/Mobile)','false','castle_guard',0,'stackable','paper','none',-1,40000,0,'true','true','true','true','mticket_oren_pole_move','castle_guard'),
(4006,'Mercenary Posting Ticket (Bow/Mobile)','false','castle_guard',0,'stackable','paper','none',-1,50000,0,'true','true','true','true','mticket_oren_bow_move','castle_guard'),
(4007,'Mercenary Posting Ticket (Cleric/Mobile)','false','castle_guard',0,'stackable','paper','none',-1,150000,0,'true','true','true','true','mticket_oren_cleric_move','castle_guard'),
(4008,'Mercenary Posting Ticket (Wizard/Mobile)','false','castle_guard',0,'stackable','paper','none',-1,150000,0,'true','true','true','true','mticket_oren_wizard_move','castle_guard'),
(4009,'Mercenary Posting Ticket (Teleporter1)','false','castle_guard',0,'stackable','paper','none',-1,100000,0,'true','true','true','true','mticket_oren_teleporter1','castle_guard'),
(4010,'Mercenary Posting Ticket (Teleporter2)','false','castle_guard',0,'stackable','paper','none',-1,100000,0,'true','true','true','true','mticket_oren_teleporter2','castle_guard'),
(4011,'Mercenary Posting Ticket (Teleporter3)','false','castle_guard',0,'stackable','paper','none',-1,100000,0,'true','true','true','true','mticket_oren_teleporter3','castle_guard'),
(4012,'Mercenary Posting Ticket (Sword/Stationary)','false','castle_guard',0,'stackable','paper','none',-1,30000,0,'true','true','true','true','mticket_aden_sword_fix','castle_guard'),
(4013,'Mercenary Posting Ticket (Spear/Stationary)','false','castle_guard',0,'stackable','paper','none',-1,40000,0,'true','true','true','true','mticket_aden_pole_fix','castle_guard'),
(4014,'Mercenary Posting Ticket (Bow/Stationary)','false','castle_guard',0,'stackable','paper','none',-1,50000,0,'true','true','true','true','mticket_aden_bow_fix','castle_guard'),
(4015,'Mercenary Posting Ticket (Cleric/Stationary)','false','castle_guard',0,'stackable','paper','none',-1,150000,0,'true','true','true','true','mticket_aden_cleric_fix','castle_guard'),
(4016,'Mercenary Posting Ticket (Wizard/Stationary)','false','castle_guard',0,'stackable','paper','none',-1,150000,0,'true','true','true','true','mticket_aden_wizard_fix','castle_guard'),
(4017,'Mercenary Posting Ticket (Sword/Mobile)','false','castle_guard',0,'stackable','paper','none',-1,30000,0,'true','true','true','true','mticket_aden_sword_move','castle_guard'),
(4018,'Mercenary Posting Ticket (Spear/Mobile)','false','castle_guard',0,'stackable','paper','none',-1,40000,0,'true','true','true','true','mticket_aden_pole_move','castle_guard'),
(4019,'Mercenary Posting Ticket (Bow/Mobile)','false','castle_guard',0,'stackable','paper','none',-1,50000,0,'true','true','true','true','mticket_aden_bow_move','castle_guard'),
(4020,'Mercenary Posting Ticket (Cleric/Mobile)','false','castle_guard',0,'stackable','paper','none',-1,150000,0,'true','true','true','true','mticket_aden_cleric_move','castle_guard'),
(4021,'Mercenary Posting Ticket (Wizard/Mobile)','false','castle_guard',0,'stackable','paper','none',-1,150000,0,'true','true','true','true','mticket_aden_wizard_move','castle_guard'),
(4022,'Mercenary Posting Ticket (Teleporter1)','false','castle_guard',0,'stackable','paper','none',-1,100000,0,'true','true','true','true','mticket_aden_teleporter1','castle_guard'),
(4023,'Mercenary Posting Ticket (Teleporter2)','false','castle_guard',0,'stackable','paper','none',-1,100000,0,'true','true','true','true','mticket_aden_teleporter2','castle_guard'),
(4024,'Mercenary Posting Ticket (Teleporter3)','false','castle_guard',0,'stackable','paper','none',-1,100000,0,'true','true','true','true','mticket_aden_teleporter3','castle_guard'),
(4025,'Mercenary Posting Ticket (Teleporter4)','false','castle_guard',0,'stackable','paper','none',-1,100000,0,'true','true','true','true','mticket_aden_teleporter4','castle_guard'),
(4026,'Mercenary Posting Ticket (Teleporter5)','false','castle_guard',0,'stackable','paper','none',-1,100000,0,'true','true','true','true','mticket_aden_teleporter5','castle_guard'),
(4029,'Red Paper','false','none',0,'stackable','paper','none',-1,1,0,'true','true','true','true','paper_red','none'),
(4030,'Orange Paper','false','none',0,'stackable','paper','none',-1,1,0,'true','true','true','true','paper_orange','none'),
(4031,'Yellow Paper','false','none',0,'stackable','paper','none',-1,1,0,'true','true','true','true','paper_yellow','none'),
(4032,'Green Paper','false','none',0,'stackable','paper','none',-1,1,0,'true','true','true','true','paper_green','none'),
(4033,'Blue Paper','false','none',0,'stackable','paper','none',-1,1,0,'true','true','true','true','paper_blue','none'),
(4034,'Purple Paper','false','none',0,'stackable','paper','none',-1,1,0,'true','true','true','true','paper_purple','none'),
(4035,'White Paper','false','none',0,'stackable','paper','none',-1,1,0,'true','true','true','true','paper_white','none'),
(4036,'Black Paper','false','none',0,'stackable','paper','none',-1,1,0,'true','true','true','true','paper_black','none'),
(4037,'Coin of Luck','false','none',0,'stackable','paper','none',-1,1,0,'false','false','true','false','coin_of_luck','none'),
(4038,'Food For Hatchling','false','none',10,'stackable','liquid','none',-1,150,0,'true','true','true','true','food_for_hatchling','none'),
(4039,'Mold Glue','false','material',2,'stackable','liquid','none',-1,6000,0,'true','true','true','true','mold_glue','material'),
(4040,'Mold Lubricant','false','material',2,'stackable','liquid','none',-1,10000,0,'true','true','true','true','mold_lubricant','material'),
(4041,'Mold Hardener','false','material',2,'stackable','liquid','none',-1,23000,0,'true','true','true','true','mold_hardener','material'),
(4042,'Enria','false','material',2,'stackable','liquid','none',-1,12000,0,'true','true','true','true','enria','material'),
(4043,'Asofe','false','material',2,'stackable','liquid','none',-1,6000,0,'true','true','true','true','asofe','material'),
(4044,'Thons','false','material',2,'stackable','liquid','none',-1,6000,0,'true','true','true','true','thons','material'),
(4045,'Maestro Holder','false','material',2,'stackable','liquid','none',-1,411000,0,'true','true','true','true','maestro_holder','material'),
(4046,'Maestro Anvil Lock','false','material',2,'stackable','liquid','none',-1,90400,0,'true','true','true','true','maestro_anvil_lock','material'),
(4047,'Craftsman Mold','false','material',2,'stackable','liquid','none',-1,710000,0,'true','true','true','true','craftsman_mold','material'),
(4048,'Maestro Mold','false','material',2,'stackable','liquid','none',-1,154000,0,'true','true','true','true','maestro_mold','material'),
(4049,'Adamantite Earring Gemstone','false','material',60,'stackable','liquid','none',-1,3813,0,'true','true','true','true','adamantite_earing_gemstone','material'),
(4050,'Adamantite Ring Wire','false','material',60,'stackable','liquid','none',-1,3228,0,'true','true','true','true','adamantite_ring_wire','material'),
(4051,'Adamantite Necklace Chain','false','material',60,'stackable','liquid','none',-1,5157,0,'true','true','true','true','adamantite_necklace_chain','material'),
(4052,'Earring of Black Ore Piece','false','material',60,'stackable','liquid','none',-1,5649,0,'true','true','true','true','earing_of_black_ore_piece','material'),
(4053,'Ring of Black Ore Gemstone','false','material',60,'stackable','liquid','none',-1,4666,0,'true','true','true','true','ring_of_black_ore_gemstone','material'),
(4054,'Necklace of Black Ore Beads','false','material',60,'stackable','liquid','none',-1,10154,0,'true','true','true','true','necklace_of_black_ore_beads','material'),
(4055,'Composite Shield Fragment','false','material',60,'stackable','liquid','none',-1,3120,0,'true','true','true','true','composite_shield_fragment','material'),
(4056,'Zubei\'s Breastplate Part','false','material',60,'stackable','liquid','none',-1,11050,0,'true','true','true','true','shrnoen\'s_breastplate_part','material'),
(4057,'Zubei\'s Gaiter Material','false','material',60,'stackable','liquid','none',-1,7150,0,'true','true','true','true','shrnoen\'s_gaiters_material','material'),
(4058,'Implosion Boots Part','false','material',60,'stackable','liquid','none',-1,4455,0,'true','true','true','true','implosion_boots_part','material'),
(4059,'Boots of Silence Fabric','false','material',60,'stackable','liquid','none',-1,3843,0,'true','true','true','true','silent_boots_fabric','material'),
(4060,'Guardian\'s Boots Fabric','false','material',60,'stackable','liquid','none',-1,3843,0,'true','true','true','true','guardian\'s_boots_fabric','material'),
(4061,'Paradia Boots Pattern','false','material',60,'stackable','liquid','none',-1,4455,0,'true','true','true','true','paradia_boots_pattern','material'),
(4062,'Elemental Boots Lining','false','material',60,'stackable','liquid','none',-1,4455,0,'true','true','true','true','elemental_boots_lining','material'),
(4063,'Boots of Grace Lining','false','material',60,'stackable','liquid','none',-1,4455,0,'true','true','true','true','boots_of_grace_lining','material'),
(4064,'Avadon Breastplate Part','false','material',60,'stackable','liquid','none',-1,11050,0,'true','true','true','true','avadon_breastplate_part','material'),
(4065,'Avadon Gaiters Material','false','material',60,'stackable','liquid','none',-1,7150,0,'true','true','true','true','avadon_gaiters_material','material'),
(4066,'Zubei\'s Leather Shirt Fabric','false','material',60,'stackable','liquid','none',-1,8483,0,'true','true','true','true','shrnoen\'s_leather_shirts_fabric','material'),
(4067,'Zubei\'s Leather Gaiter Texture','false','material',60,'stackable','liquid','none',-1,5587,0,'true','true','true','true','shrnoen\'s_leather_gaiters_texture','material'),
(4068,'Avadon Leather Armor Lining','false','material',60,'stackable','liquid','none',-1,11042,0,'true','true','true','true','avadon_leather_mail_lining','material'),
(4069,'Tunic of Zubei Fabric','false','material',60,'stackable','liquid','none',-1,8483,0,'true','true','true','true','tunic_of_shrnoen_fabric','material'),
(4070,'Stockings of Zubei Fabric','false','material',60,'stackable','liquid','none',-1,5587,0,'true','true','true','true','hose_of_shrnoen_fabric','material'),
(4071,'Avadon Robe Fabric','false','material',60,'stackable','liquid','none',-1,11042,0,'true','true','true','true','avadon_robe_fabric','material'),
(4072,'Avadon Circlet Pattern','false','material',60,'stackable','liquid','none',-1,4453,0,'true','true','true','true','avadon_circlet_pattern','material'),
(4073,'Avadon Gloves Part','false','material',60,'stackable','liquid','none',-1,3843,0,'true','true','true','true','avadon_gloves_part','material'),
(4074,'Chain Gloves of Silence Design','false','material',60,'stackable','liquid','none',-1,3843,0,'true','true','true','true','silent_chain_gloves_design','material'),
(4075,'Guardian\'s Gloves Design','false','material',60,'stackable','liquid','none',-1,3843,0,'true','true','true','true','guardian\'s_gloves_design','material'),
(4076,'Gloves of Blessing Pattern','false','material',60,'stackable','liquid','none',-1,3843,0,'true','true','true','true','gloves_of_blessing_pattern','material'),
(4077,'Doom Shield Fragment','false','material',60,'stackable','liquid','none',-1,4446,0,'true','true','true','true','doom_shield_fragment','material'),
(4078,'Blue Wolf Breastplate Part','false','material',60,'stackable','liquid','none',-1,13692,0,'true','true','true','true','blue_wolve\'s_breastplate_part','material'),
(4079,'Boots of Blessing Design','false','material',60,'stackable','liquid','none',-1,3843,0,'true','true','true','true','boots_of_blessing_design','material'),
(4080,'Blue Wolf Gaiters Material','false','material',60,'stackable','liquid','none',-1,9723,0,'true','true','true','true','blue_wolve\'s_gaiters_material','material'),
(4081,'Doom Plate Armor Temper','false','material',60,'stackable','liquid','none',-1,20292,0,'true','true','true','true','doom_plate_armor_temper','material'),
(4082,'Blue Wolf Leather Armor Texture','false','material',60,'stackable','liquid','none',-1,17700,0,'true','true','true','true','blue_wolve\'s_leather_mail_texture','material'),
(4083,'Leather Armor of Doom Design','false','material',60,'stackable','liquid','none',-1,17700,0,'true','true','true','true','leather_mail_of_doom_design','material'),
(4084,'Blue Wolf Tunic Fabric','false','material',60,'stackable','liquid','none',-1,11508,0,'true','true','true','true','blue_wolve\'s_tunic_fabric','material'),
(4085,'Tunic of Doom Pattern','false','material',60,'stackable','liquid','none',-1,11508,0,'true','true','true','true','tunic_of_doom_pattern','material'),
(4086,'Blue Wolf Stockings Pattern','false','material',60,'stackable','liquid','none',-1,8523,0,'true','true','true','true','blue_wolve\'s_hose_pattern','material'),
(4087,'Stockings of Doom Pattern','false','material',60,'stackable','liquid','none',-1,8523,0,'true','true','true','true','hose_of_doom_pattern','material'),
(4088,'Blue Wolf Helmet Design','false','material',60,'stackable','liquid','none',-1,5292,0,'true','true','true','true','blue_wolve\'s_helmet_design','material'),
(4089,'Doom Helmet Pattern','false','material',60,'stackable','liquid','none',-1,5292,0,'true','true','true','true','doom_helmet_pattern','material'),
(4090,'Blue Wolf Boots Design','false','material',60,'stackable','liquid','none',-1,4455,0,'true','true','true','true','blue_wolve\'s_boots_design','material'),
(4091,'Doom Gloves Part','false','material',60,'stackable','liquid','none',-1,4455,0,'true','true','true','true','doom_gloves_part','material'),
(4092,'Elemental Gloves Lining','false','material',60,'stackable','liquid','none',-1,4455,0,'true','true','true','true','elemental_gloves_lining','material'),
(4093,'Gloves of Grace Lining','false','material',60,'stackable','liquid','none',-1,4455,0,'true','true','true','true','gloves_of_grace_lining','material'),
(4094,'Implosion Gauntlet Fabric','false','material',60,'stackable','liquid','none',-1,4455,0,'true','true','true','true','implosion_gauntlet_fabric','material'),
(4095,'Paradia Gloves Pattern','false','material',60,'stackable','liquid','none',-1,4455,0,'true','true','true','true','paradia_gloves_pattern','material'),
(4096,'Blue Wolf Gloves Fabric','false','material',60,'stackable','liquid','none',-1,4455,0,'true','true','true','true','blue_wolve\'s_gloves_fabric','material'),
(4097,'Zubei\'s Boots Design','false','material',60,'stackable','liquid','none',-1,3843,0,'true','true','true','true','shrnoen\'s_boots_design','material'),
(4098,'Avadon Boots Design','false','material',60,'stackable','liquid','none',-1,3843,0,'true','true','true','true','avadon_boots_design','material'),
(4099,'Doom Boots Part','false','material',60,'stackable','liquid','none',-1,4455,0,'true','true','true','true','doom_boots_part','material'),
(4100,'Zubei\'s Gauntlets Part','false','material',60,'stackable','liquid','none',-1,3843,0,'true','true','true','true','shrnoen\'s_gauntlet_part','material'),
(4101,'Zubei\'s Shield Fragment','false','material',60,'stackable','liquid','none',-1,3450,0,'true','true','true','true','shrnoen\'s_shield_fragment','material'),
(4102,'Zubei\'s Helmet Design','false','material',60,'stackable','liquid','none',-1,4453,0,'true','true','true','true','shrnoen\'s_helmet_design','material'),
(4103,'Pata Blade','false','material',60,'stackable','liquid','none',-1,32950,0,'true','true','true','true','pata_blade','material'),
(4104,'Great Sword Blade','false','material',60,'stackable','liquid','none',-1,34950,0,'true','true','true','true','great_sword_blade','material'),
(4105,'Heavy War Axe Head','false','material',60,'stackable','liquid','none',-1,34950,0,'true','true','true','true','heavy_war_axe_head','material'),
(4106,'Sprite\'s Staff Head','false','material',60,'stackable','liquid','none',-1,35533,0,'true','true','true','true','sprite\'s_staff_head','material'),
(4107,'Keshanberk Blade','false','material',60,'stackable','liquid','none',-1,35500,0,'true','true','true','true','kshanberk_blade','material'),
(4108,'Sword of Valhalla Blade','false','material',60,'stackable','liquid','none',-1,35500,0,'true','true','true','true','sword_of_valhalla_blade','material'),
(4109,'Kris Edge','false','material',60,'stackable','liquid','none',-1,35500,0,'true','true','true','true','kris_edge','material'),
(4110,'Hell Knife Edge','false','material',60,'stackable','liquid','none',-1,35500,0,'true','true','true','true','hell_knife_edge','material'),
(4111,'Arthro Nail Blade','false','material',60,'stackable','liquid','none',-1,34950,0,'true','true','true','true','arthro_nail_blade','material'),
(4112,'Dark Elven Longbow Shaft','false','material',60,'stackable','liquid','none',-1,35325,0,'true','true','true','true','dark_elven_long_bow_shaft','material'),
(4113,'Great Axe Head','false','material',60,'stackable','liquid','none',-1,38867,0,'true','true','true','true','great_axe_head','material'),
(4114,'Sword of Damascus Blade','false','material',60,'stackable','liquid','none',-1,45692,0,'true','true','true','true','sword_of_damascus_blade','material'),
(4115,'Lance Blade','false','material',60,'stackable','liquid','none',-1,45846,0,'true','true','true','true','lancia_blade','material'),
(4116,'Deadman\'s Glory Stone','false','material',60,'stackable','liquid','none',-1,45769,0,'true','true','true','true','deadman\'s_glory_stone','material'),
(4117,'Art of Battle Axe Blade','false','material',60,'stackable','liquid','none',-1,45769,0,'true','true','true','true','art_of_battle_axe_blade','material'),
(4118,'Evil Spirit Head','false','material',60,'stackable','liquid','none',-1,48308,0,'true','true','true','true','staff_of_evil_sprit_head','material'),
(4119,'Demon Dagger Edge','false','material',60,'stackable','liquid','none',-1,45692,0,'true','true','true','true','demon\'s_sword_edge','material'),
(4120,'Bellion Cestus Edge','false','material',60,'stackable','liquid','none',-1,45769,0,'true','true','true','true','bellion_cestus_edge','material'),
(4121,'Bow of Peril Shaft','false','material',60,'stackable','liquid','none',-1,45923,0,'true','true','true','true','hazard_bow_shaft','material'),
(4122,'Recipe: Maestro Holder','false','recipe',30,'stackable','liquid','none',-1,4500,0,'true','true','true','true','rp_maestro_holder','recipe'),
(4123,'Recipe: Maestro Anvil Lock','false','recipe',30,'stackable','liquid','none',-1,4500,0,'true','true','true','true','rp_maestro_anvil_lock','recipe'),
(4124,'Recipe: Craftsman Mold','false','recipe',30,'stackable','liquid','none',-1,4500,0,'true','true','true','true','rp_craftsman_mold','recipe'),
(4125,'Recipe: Maestro Mold','false','recipe',30,'stackable','liquid','none',-1,4500,0,'true','true','true','true','rp_maestro_mold','recipe'),
(4126,'Recipe: Adamantite Earrings','false','recipe',30,'stackable','liquid','none',-1,12120,0,'true','true','true','true','rp_adamantite_earing','recipe'),
(4127,'Recipe: Adamantite Ring','false','recipe',30,'stackable','liquid','none',-1,8080,0,'true','true','true','true','rp_adamantite_ring','recipe'),
(4128,'Recipe: Adamantite Necklace','false','recipe',30,'stackable','liquid','none',-1,16160,0,'true','true','true','true','rp_adamantite_necklace','recipe'),
(4129,'Recipe: Earrings of Black Ore','false','recipe',30,'stackable','liquid','none',-1,18480,0,'true','true','true','true','rp_earing_of_black_ore','recipe'),
(4130,'Recipe: Ring of Black Ore','false','recipe',30,'stackable','liquid','none',-1,12320,0,'true','true','true','true','rp_ring_of_black_ore','recipe'),
(4131,'Recipe: Necklace of Black Ore','false','recipe',30,'stackable','liquid','none',-1,24600,0,'true','true','true','true','rp_necklace_of_black_ore','recipe'),
(4132,'Recipe: Composite Shield','false','recipe',30,'stackable','liquid','none',-1,5160,0,'true','true','true','true','rp_composite_shield','recipe'),
(4133,'Recipe: Zubei\'s Breastplate','false','recipe',30,'stackable','liquid','none',-1,41600,0,'true','true','true','true','rp_shrnoen\'s_breastplate','recipe'),
(4134,'Recipe: Zubei\'s Gaiters','false','recipe',30,'stackable','liquid','none',-1,26000,0,'true','true','true','true','rp_shrnoen\'s_gaiters','recipe'),
(4135,'Recipe: Implosion Boots','false','recipe',30,'stackable','liquid','none',-1,16080,0,'true','true','true','true','rp_implosion_boots','recipe'),
(4136,'Recipe: Boots of Silence','false','recipe',30,'stackable','liquid','none',-1,10380,0,'true','true','true','true','rp_silent_boots','recipe'),
(4137,'Recipe: Guardian\'s Boots','false','recipe',30,'stackable','liquid','none',-1,10380,0,'true','true','true','true','rp_guardian\'s_boots','recipe'),
(4138,'Recipe: Paradia Boots','false','recipe',30,'stackable','liquid','none',-1,16080,0,'true','true','true','true','rp_paradia_boots','recipe');
INSERT INTO `etcitem` VALUES 
(4139,'Recipe: Elemental Boots','false','recipe',30,'stackable','liquid','none',-1,16080,0,'true','true','true','true','rp_elemental_boots','recipe'),
(4140,'Recipe: Boots of Grace','false','recipe',30,'stackable','liquid','none',-1,16080,0,'true','true','true','true','rp_boots_of_grace','recipe'),
(4141,'Recipe: Avadon Breastplate','false','recipe',30,'stackable','liquid','none',-1,41600,0,'true','true','true','true','rp_avadon_breastplate','recipe'),
(4142,'Recipe: Avadon Gaiters','false','recipe',30,'stackable','liquid','none',-1,26000,0,'true','true','true','true','rp_avadon_gaiters','recipe'),
(4143,'Recipe: Zubei\'s Leather Shirt','false','recipe',30,'stackable','liquid','none',-1,31200,0,'true','true','true','true','rp_shrnoen\'s_leather_shirts','recipe'),
(4144,'Recipe: Zubei\'s Leather Gaiters','false','recipe',30,'stackable','liquid','none',-1,19460,0,'true','true','true','true','rp_shrnoen\'s_leather_gaiters','recipe'),
(4145,'Recipe: Avadon Leather Armor','false','recipe',30,'stackable','liquid','none',-1,45600,0,'true','true','true','true','rp_avadon_leather_mail','recipe'),
(4146,'Recipe: Tunic of Zubei','false','recipe',30,'stackable','liquid','none',-1,31200,0,'true','true','true','true','rp_tunic_of_shrnoen','recipe'),
(4147,'Recipe: Stockings of Zubei','false','recipe',30,'stackable','liquid','none',-1,19460,0,'true','true','true','true','rp_hose_of_shrnoen','recipe'),
(4148,'Recipe: Avadon Robe','false','recipe',30,'stackable','liquid','none',-1,45600,0,'true','true','true','true','rp_avadon_robe','recipe'),
(4149,'Recipe: Avadon Circlet','false','recipe',30,'stackable','liquid','none',-1,15560,0,'true','true','true','true','rp_avadon_circlet','recipe'),
(4150,'Recipe: Avadon Gloves','false','recipe',30,'stackable','liquid','none',-1,10380,0,'true','true','true','true','rp_avadon_gloves','recipe'),
(4151,'Recipe: Chain Gloves of Silence','false','recipe',30,'stackable','liquid','none',-1,10380,0,'true','true','true','true','rp_silent_chain_gloves','recipe'),
(4152,'Recipe: Guardian\'s Gloves','false','recipe',30,'stackable','liquid','none',-1,10380,0,'true','true','true','true','rp_guardian\'s_gloves','recipe'),
(4153,'Recipe: Gloves of Blessing','false','recipe',30,'stackable','liquid','none',-1,10380,0,'true','true','true','true','rp_gloves_of_blessing','recipe'),
(4154,'Recipe: Doom Shield','false','recipe',30,'stackable','liquid','none',-1,16900,0,'true','true','true','true','rp_doom_shield','recipe'),
(4155,'Recipe: Blue Wolf Breastplate','false','recipe',30,'stackable','liquid','none',-1,64400,0,'true','true','true','true','rp_blue_wolve\'s_breastplate','recipe'),
(4156,'Recipe: Boots of Blessing','false','recipe',30,'stackable','liquid','none',-1,10380,0,'true','true','true','true','rp_boots_of_blessing','recipe'),
(4157,'Recipe: Blue Wolf Gaiters','false','recipe',30,'stackable','liquid','none',-1,40200,0,'true','true','true','true','rp_blue_wolve\'s_gaiters','recipe'),
(4158,'Recipe: Doom Plate Armor','false','recipe',30,'stackable','liquid','none',-1,94200,0,'true','true','true','true','rp_doom_plate_armor','recipe'),
(4159,'Recipe: Blue Wolf Leather Armor','false','recipe',30,'stackable','liquid','none',-1,70600,0,'true','true','true','true','rp_blue_wolve\'s_leather_mail','recipe'),
(4160,'Recipe: Leather Armor of Doom','false','recipe',30,'stackable','liquid','none',-1,70600,0,'true','true','true','true','rp_leather_mail_of_doom','recipe'),
(4161,'Recipe: Blue Wolf Tunic','false','recipe',30,'stackable','liquid','none',-1,48200,0,'true','true','true','true','rp_blue_wolve\'s_tunic','recipe'),
(4162,'Recipe: Tunic of Doom','false','recipe',30,'stackable','liquid','none',-1,48200,0,'true','true','true','true','rp_tunic_of_doom','recipe'),
(4163,'Recipe: Blue Wolf Stockings','false','recipe',30,'stackable','liquid','none',-1,30200,0,'true','true','true','true','rp_blue_wolve\'s_hose','recipe'),
(4164,'Recipe: Stockings of Doom','false','recipe',30,'stackable','liquid','none',-1,30200,0,'true','true','true','true','rp_hose_of_doom','recipe'),
(4165,'Recipe: Blue Wolf Helmet','false','recipe',30,'stackable','liquid','none',-1,24200,0,'true','true','true','true','rp_blue_wolve\'s_helmet','recipe'),
(4166,'Recipe: Doom Helmet','false','recipe',30,'stackable','liquid','none',-1,24200,0,'true','true','true','true','rp_doom_helmet','recipe'),
(4167,'Recipe: Blue Wolf Boots','false','recipe',30,'stackable','liquid','none',-1,16080,0,'true','true','true','true','rp_blue_wolve\'s_boots','recipe'),
(4168,'Recipe: Doom Gloves','false','recipe',30,'stackable','liquid','none',-1,16080,0,'true','true','true','true','rp_doom_gloves','recipe'),
(4169,'Recipe: Elemental Gloves','false','recipe',30,'stackable','liquid','none',-1,16080,0,'true','true','true','true','rp_elemental_gloves','recipe'),
(4170,'Recipe: Gloves of Grace','false','recipe',30,'stackable','liquid','none',-1,16080,0,'true','true','true','true','rp_gloves_of_grace','recipe'),
(4171,'Recipe: Implosion Gauntlets','false','recipe',30,'stackable','liquid','none',-1,16080,0,'true','true','true','true','rp_implosion_gauntlet','recipe'),
(4172,'Recipe: Paradia Gloves','false','recipe',30,'stackable','liquid','none',-1,16080,0,'true','true','true','true','rp_paradia_gloves','recipe'),
(4173,'Recipe: Blue Wolf Gloves','false','recipe',30,'stackable','liquid','none',-1,16080,0,'true','true','true','true','rp_blue_wolve\'s_gloves','recipe'),
(4174,'Recipe: Zubei\'s Boots','false','recipe',30,'stackable','liquid','none',-1,10380,0,'true','true','true','true','rp_shrnoen\'s_boots','recipe'),
(4175,'Recipe: Avadon Boots','false','recipe',30,'stackable','liquid','none',-1,10380,0,'true','true','true','true','rp_avadon_boots','recipe'),
(4176,'Recipe: Doom Boots','false','recipe',30,'stackable','liquid','none',-1,16080,0,'true','true','true','true','rp_doom_boots','recipe'),
(4177,'Recipe: Zubei\'s Gauntlets','false','recipe',30,'stackable','liquid','none',-1,10380,0,'true','true','true','true','rp_shrnoen\'s_gauntlet','recipe'),
(4178,'Recipe: Zubei\'s Shield (100%)','false','recipe',30,'stackable','liquid','none',-1,10900,0,'true','true','true','true','rp_shrnoen\'s_shield','recipe'),
(4179,'Recipe: Zubei\'s Helmet','false','recipe',30,'stackable','liquid','none',-1,15560,0,'true','true','true','true','rp_shrnoen\'s_helmet','recipe'),
(4180,'Recipe: Silver Arrow','false','recipe',30,'stackable','liquid','none',-1,1800,0,'true','true','true','true','rp_silver_arrow','recipe'),
(4181,'Recipe: Pata','false','recipe',30,'stackable','liquid','none',-1,156600,0,'true','true','true','true','rp_pata','recipe'),
(4182,'Recipe: Great Sword','false','recipe',30,'stackable','liquid','none',-1,173600,0,'true','true','true','true','rp_great_sword','recipe'),
(4183,'Recipe: Heavy War Axe','false','recipe',30,'stackable','liquid','none',-1,173600,0,'true','true','true','true','rp_heavy_war_axe','recipe'),
(4184,'Recipe: Sprite\'s Staff','false','recipe',30,'stackable','liquid','none',-1,173600,0,'true','true','true','true','rp_sprite\'s_staff','recipe'),
(4185,'Recipe: Keshanberk','false','recipe',30,'stackable','liquid','none',-1,173600,0,'true','true','true','true','rp_kshanberk','recipe'),
(4186,'Recipe: Sword of Valhalla','false','recipe',30,'stackable','liquid','none',-1,173600,0,'true','true','true','true','rp_sword_of_valhalla','recipe'),
(4187,'Recipe: Kris','false','recipe',30,'stackable','liquid','none',-1,173600,0,'true','true','true','true','rp_kris','recipe'),
(4188,'Recipe: Hell Knife','false','recipe',30,'stackable','liquid','none',-1,173600,0,'true','true','true','true','rp_hell_knife','recipe'),
(4189,'Recipe: Arthro Nail','false','recipe',30,'stackable','liquid','none',-1,173600,0,'true','true','true','true','rp_arthro_nail','recipe'),
(4190,'Recipe: Dark Elven Long Bow','false','recipe',30,'stackable','liquid','none',-1,173600,0,'true','true','true','true','rp_dark_elven_long_bow','recipe'),
(4191,'Recipe: Great Axe','false','recipe',30,'stackable','liquid','none',-1,173600,0,'true','true','true','true','rp_great_axe','recipe'),
(4192,'Recipe: Sword of Damascus','false','recipe',30,'stackable','liquid','none',-1,262000,0,'true','true','true','true','rp_sword_of_damascus','recipe'),
(4193,'Recipe: Lance','false','recipe',30,'stackable','liquid','none',-1,262000,0,'true','true','true','true','rp_lancia','recipe'),
(4194,'Recipe: Deadman\'s Glory','false','recipe',30,'stackable','liquid','none',-1,262000,0,'true','true','true','true','rp_deadman\'s_glory','recipe'),
(4195,'Recipe: Art of Battle Axe','false','recipe',30,'stackable','liquid','none',-1,262000,0,'true','true','true','true','rp_art_of_battle_axe','recipe'),
(4196,'Recipe: Staff of Evil Spirits','false','recipe',30,'stackable','liquid','none',-1,262000,0,'true','true','true','true','rp_staff_of_evil_sprit','recipe'),
(4197,'Recipe: Demon Dagger','false','recipe',30,'stackable','liquid','none',-1,262000,0,'true','true','true','true','rp_demon\'s_sword','recipe'),
(4198,'Recipe: Bellion Cestus','false','recipe',30,'stackable','liquid','none',-1,262000,0,'true','true','true','true','rp_bellion_cestus','recipe'),
(4199,'Recipe: Bow of Peril','false','recipe',30,'stackable','liquid','none',-1,262000,0,'true','true','true','true','rp_hazard_bow','recipe'),
(4200,'Spellbook: Restore Life','false','spellbook',120,'stackable','paper','none',-1,3850,0,'true','true','true','true','sb_restore_life1','none'),
(4201,'Spellbook: Resist Shock','false','spellbook',120,'stackable','paper','none',-1,3200,0,'true','true','true','true','sb_resist_shock1','none'),
(4203,'Spellbook: Life Leech','false','spellbook',120,'stackable','paper','none',-1,3200,0,'true','true','true','true','sb_life_leech','none'),
(4204,'Amulet: Pa''agrio\'s Tact','false','spellbook',120,'stackable','paper','none',-1,3200,0,'true','true','true','true','sb_tact_of_paagrio','none'),
(4205,'Amulet: Pa''agrio\'s Rage','false','spellbook',120,'stackable','paper','none',-1,3850,0,'true','true','true','true','sb_rage_of_paagrio','none'),
(4206,'Spellbook: Transfer Pain','false','spellbook',120,'stackable','paper','none',-1,3200,0,'true','true','true','true','sb_transfer_pain','none'),
(4207,'Spellbook: Mana Regeneration','false','spellbook',120,'stackable','paper','none',-1,3200,0,'true','true','true','true','sb_mana_regeneration','none'),
(4208,'Spellbook: Curse Gloom','false','spellbook',120,'stackable','paper','none',-1,3850,0,'true','true','true','true','sb_curse_gloom','none'),
(4209,'Change of Heart - Piece 1','false','none',0,'stackable','steel','none',-1,0,0,'true','true','true','true','heart_1','none'),
(4210,'Change of Heart - Piece 2','false','none',0,'stackable','steel','none',-1,0,0,'true','true','true','true','heart_2','none'),
(4211,'Change of Heart - Piece 3','false','none',0,'stackable','steel','none',-1,0,0,'true','true','true','true','heart_3','none'),
(4212,'Change of Heart - Piece 4','false','none',0,'stackable','steel','none',-1,0,0,'true','true','true','true','heart_4','none'),
(4213,'Change of Heart - Piece 5','false','none',0,'stackable','steel','none',-1,0,0,'true','true','true','true','heart_5','none'),
(4214,'Change of Heart - Piece 6','false','none',0,'stackable','steel','none',-1,0,0,'true','true','true','true','heart_6','none'),
(4215,'Change of Heart - Piece 7','false','none',0,'stackable','steel','none',-1,0,0,'true','true','true','true','heart_7','none'),
(4216,'Change of Heart - Piece 8','false','none',0,'stackable','steel','none',-1,0,0,'true','true','true','true','heart_8','none'),
(4217,'Change of Heart - Piece 9','false','none',0,'stackable','steel','none',-1,0,0,'true','true','true','true','heart_9','none'),
(4218,'L2 Day - Scroll of Mana Regeneration','false','scroll',120,'stackable','paper','none',-1,0,0,'true','true','true','true','l2day_scroll_of_mana_regeneration','scroll'),
(4232,'Dice','false','none',0,'normal','steel','none',-1,0,0,'true','true','false','true','dice','none'),
(4239,'Blade Mold','false','quest',0,'stackable','liquid','none',-1,0,0,'false','false','true','false','q_blade_mold','none'),
(4240,'Tyra\'s Bill','false','quest',0,'stackable','paper','none',-1,0,0,'false','false','true','false','q_tweetys_bill','none'),
(4241,'Ranger\'s Report - Part 1','false','quest',0,'stackable','paper','none',-1,0,0,'false','false','true','false','q_rangers_report1','none'),
(4242,'Ranger\'s Report - Part 2','false','quest',0,'stackable','paper','none',-1,0,0,'false','false','true','false','q_rangers_report2','none'),
(4243,'Ranger\'s Report - Part 3','false','quest',0,'stackable','paper','none',-1,0,0,'false','false','true','false','q_rangers_report3','none'),
(4244,'Ranger\'s Report - Part 4','false','quest',0,'stackable','paper','none',-1,0,0,'false','false','true','false','q_rangers_report4','none'),
(4245,'Weapons Trade Contract','false','quest',0,'stackable','paper','none',-1,0,0,'false','false','true','false','q_weaponsdeal_contract','none'),
(4246,'Attack Directives','false','quest',0,'stackable','paper','none',-1,0,0,'false','false','true','false','q_attack_directives','none'),
(4247,'Certificate of the Silver Scale Guild','false','quest',0,'stackable','paper','none',-1,0,0,'false','false','true','false','q_silver_balance_mark','none'),
(4248,'Rolento\'s Cargobox','false','quest',0,'stackable','wood','none',-1,0,0,'false','false','true','false','q_rolentos_cargobox','none'),
(4249,'Ol Mahum Captain\'s Head','false','quest',0,'stackable','leather','none',-1,0,0,'false','false','true','false','q_olmahum_cptn_head','none'),
(4250,'Jade Crystal','false','quest',0,'stackable','crystal','none',-1,0,0,'false','false','true','false','q_jade_crystal','none'),
(4251,'Ancient Statue of Goddess','false','quest',0,'stackable','bone','none',-1,0,0,'false','false','true','false','q_ancient_idol','none'),
(4252,'GalfRedo Romer\'s Bust','false','quest',0,'stackable','bone','none',-1,0,0,'false','false','true','false','q_ancient_portrait','none'),
(4253,'Eye of the Shadow','false','quest',0,'stackable','crystal','none',-1,0,0,'false','false','true','false','q_eye_of_shadow','none'),
(4254,'Certificate of Participation: Battle Royal','false','quest',0,'stackable','paper','none',-1,0,0,'false','false','true','false','q_battle_royal','none'),
(4255,'Trade Cargo','false','quest',0,'stackable','paper','none',-1,0,0,'false','false','true','false','q_merchant_league_cargo','none'),
(4256,'Agnes\'s Holy Symbol','false','quest',0,'stackable','paper','none',-1,0,0,'false','false','true','false','q_agnes_holysymbol','none'),
(4257,'Agnes\'s Rosary','false','quest',0,'stackable','wood','none',-1,0,0,'false','false','true','false','q_agnes_rosary','none'),
(4258,'Sinister Totem','false','quest',0,'stackable','wood','none',-1,0,0,'false','false','true','false','q_sinister_totem','none'),
(4259,'Bear Skin','false','quest',0,'stackable','leather','none',-1,0,0,'false','false','true','false','q_bear_skin','none'),
(4260,'Enku Orc\'s Head','false','quest',0,'stackable','bone','none',-1,0,0,'false','false','true','false','q0342_orks_head','none'),
(4261,'Orc Heads Bouquet -1','false','quest',0,'stackable','paper','none',-1,0,0,'false','false','true','false','q0342_bloody_bouquet_1','none'),
(4262,'Orc Heads Bouquet -2','false','quest',0,'stackable','paper','none',-1,0,0,'false','false','true','false','q0342_bloody_bouquet_2','none'),
(4263,'Orc Heads Bouquet -3','false','quest',0,'stackable','paper','none',-1,0,0,'false','false','true','false','q0342_bloody_bouquet_3','none'),
(4264,'Orc Heads Bouquet -4','false','quest',0,'stackable','paper','none',-1,0,0,'false','false','true','false','q0342_bloody_bouquet_4','none'),
(4265,'Orc Heads Bouquet -5','false','quest',0,'stackable','paper','none',-1,0,0,'false','false','true','false','q0342_bloody_bouquet_5','none'),
(4266,'Orc Heads Bouquet -6','false','quest',0,'stackable','paper','none',-1,0,0,'false','false','true','false','q0342_bloody_bouquet_6','none'),
(4267,'Orc Heads Bouquet -7','false','quest',0,'stackable','paper','none',-1,0,0,'false','false','true','false','q0342_bloody_bouquet_7','none'),
(4268,'Jennifer\'s Box','false','quest',0,'stackable','paper','none',-1,0,0,'false','false','true','false','q0342_box_to_orclady','none'),
(4269,'Articles of Dead Heroes','false','quest',0,'stackable','paper','none',-1,0,0,'false','false','true','false','q0344_left_thing_of_heroes','none'),
(4270,'Old Key','false','quest',0,'stackable','steel','none',-1,0,0,'false','false','true','false','q0344_old_key','none'),
(4271,'Old Hilt','false','quest',0,'stackable','steel','none',-1,0,0,'false','false','true','false','q0344_old_hilt','none'),
(4272,'Totem Necklace','false','quest',0,'stackable','bone','none',-1,0,0,'false','false','true','false','q0344_totem_necklace','none'),
(4273,'Einhasad Crucifix','false','quest',0,'stackable','paper','none',-1,0,0,'false','false','true','false','q0344_holy_symbol_of_light','none'),
(4274,'Victim\'s Arm Bone','false','quest',0,'stackable','bone','none',-1,0,0,'false','false','true','false','q0345_bone_arm','none'),
(4275,'Victim\'s Thigh Bone','false','quest',0,'stackable','bone','none',-1,0,0,'false','false','true','false','q0345_bone_leg','none'),
(4276,'Victim\'s Skull','false','quest',0,'stackable','bone','none',-1,0,0,'false','false','true','false','q0345_bone_skull','none'),
(4277,'Victim\'s Rib Bone','false','quest',0,'stackable','bone','none',-1,0,0,'false','false','true','false','q0345_bone_rib','none'),
(4278,'Victim\'s Spine','false','quest',0,'stackable','bone','none',-1,0,0,'false','false','true','false','q0345_bone_spine','none'),
(4279,'Jar of Bones','false','quest',0,'stackable','bone','none',-1,0,0,'false','false','true','false','q0345_jar_of_bone','none'),
(4280,'Useless Bone Pieces','false','quest',0,'stackable','bone','none',-1,0,0,'false','false','true','false','q0345_bone_useless','none'),
(4281,'Powder to Summon Dead Souls','false','quest',0,'stackable','bone','none',-1,0,0,'false','false','true','false','q0345_calling_spirit_powder','none'),
(4282,'Sack of the Dead','false','quest',0,'stackable','bone','none',-1,0,0,'false','false','true','false','q0345_sack_ot_the_dead','none'),
(4283,'Frog Prince','false','quest',0,'stackable','crystal','none',-1,0,0,'false','false','true','false','q_frogged_prince','none'),
(4284,'Fly Powder','false','quest',0,'stackable','liquid','none',-1,0,0,'false','false','true','false','q_fly_powder','none'),
(4285,'Calculator','false','quest',0,'stackable','crystal','none',-1,0,0,'false','false','true','false','q_calculator','none'),
(4286,'Gemstone Beast\'s Crystal','false','quest',0,'stackable','crystal','none',-1,0,0,'false','false','true','false','q_gemstone','none'),
(4287,'Titan\'s Powerstone','false','quest',0,'stackable','steel','none',-1,0,0,'false','false','true','false','q0348_engine_of_lgiant','none'),
(4288,'Hanellin\'s 1st Letter','false','quest',0,'stackable','paper','none',-1,0,0,'false','false','true','false','q0348_hanellins_letter1','none'),
(4289,'Hanellin\'s 2nd Letter','false','quest',0,'stackable','paper','none',-1,0,0,'false','false','true','false','q0348_hanellins_letter2','none'),
(4290,'Hanellin\'s 3rd Letter','false','quest',0,'stackable','paper','none',-1,0,0,'false','false','true','false','q0348_hanellins_letter3','none'),
(4291,'1st Key of Ark','false','quest',0,'stackable','steel','none',-1,0,0,'false','false','true','false','q0348_key_of_ark1','none'),
(4292,'2nd Key of Ark','false','quest',0,'stackable','steel','none',-1,0,0,'false','false','true','false','q0348_key_of_ark2','none'),
(4293,'3rd Key of Ark','false','quest',0,'stackable','steel','none',-1,0,0,'false','false','true','false','q0348_key_of_ark3','none'),
(4294,'White Fabric','false','quest',0,'stackable','cloth','none',-1,0,0,'false','false','true','false','q0348_white_fabric','none'),
(4295,'Blooded Fabric','false','quest',0,'stackable','cloth','none',-1,0,0,'false','false','true','false','q0348_blooded_fabric','none'),
(4296,'Order of Gosta','false','quest',0,'stackable','paper','none',-1,0,0,'false','false','true','false','q0351_order_of_gosta','none'),
(4297,'Lizard Fang','false','quest',0,'stackable','bone','none',-1,0,0,'false','false','true','false','q0351_lizard_fang','none'),
(4298,'Barrel of League','false','quest',0,'stackable','wood','none',-1,0,0,'false','false','true','false','q0351_barrel_of_league','none'),
(4299,'Operation Document - 1/10','false','quest',0,'stackable','paper','none',-1,0,0,'false','false','true','false','q0351_ope_doc_01','none'),
(4300,'Operation Document - 2/10','false','quest',0,'stackable','paper','none',-1,0,0,'false','false','true','false','q0351_ope_doc_02','none'),
(4301,'Operation Document - 3/10','false','quest',0,'stackable','paper','none',-1,0,0,'false','false','true','false','q0351_ope_doc_03','none'),
(4302,'Operation Document - 4/10','false','quest',0,'stackable','paper','none',-1,0,0,'false','false','true','false','q0351_ope_doc_04','none'),
(4303,'Operation Document - 5/10','false','quest',0,'stackable','paper','none',-1,0,0,'false','false','true','false','q0351_ope_doc_05','none'),
(4304,'Operation Document - 6/10','false','quest',0,'stackable','paper','none',-1,0,0,'false','false','true','false','q0351_ope_doc_06','none'),
(4305,'Operation Document - 7/10','false','quest',0,'stackable','paper','none',-1,0,0,'false','false','true','false','q0351_ope_doc_07','none'),
(4306,'Operation Document - 8/10','false','quest',0,'stackable','paper','none',-1,0,0,'false','false','true','false','q0351_ope_doc_08','none'),
(4307,'Operation Document - 9/10','false','quest',0,'stackable','paper','none',-1,0,0,'false','false','true','false','q0351_ope_doc_09','none'),
(4308,'Operation Document - 10/10','false','quest',0,'stackable','paper','none',-1,0,0,'false','false','true','false','q0351_ope_doc_10','none'),
(4309,'Completed Operation Order','false','quest',0,'stackable','paper','none',-1,0,0,'false','false','true','false','q0351_ope_doc_all','none'),
(4310,'Bill of Iason Heine','false','quest',0,'stackable','paper','none',-1,0,0,'false','false','true','false','q0351_bill_of_iason','none'),
(4311,'Gillian\'s Diary','false','quest',0,'stackable','paper','none',-1,0,0,'false','false','true','false','q_gillians_diary','none'),
(4312,'Gillian\'s Notes','false','quest',0,'stackable','paper','none',-1,0,0,'false','false','true','false','q_gillians_notes','none'),
(4313,'Unfinished Music','false','quest',0,'stackable','paper','none',-1,0,0,'false','false','true','false','q_unfinished_music','none'),
(4314,'Gillian\'s Heart','false','quest',0,'stackable','leather','none',-1,0,0,'false','false','true','false','q_gillians_heart','none'),
(4315,'Gandi Tribe\'s Relic','false','quest',0,'stackable','wood','none',-1,0,0,'false','false','true','false','q_gandi_tribe_relic','none'),
(4316,'Swan\'s Flute','false','quest',0,'stackable','wood','none',-1,0,0,'false','false','true','false','q_swans_flute','none'),
(4317,'Swan\'s Letter','false','quest',0,'stackable','paper','none',-1,0,0,'false','false','true','false','q_letter_of_swan','none'),
(4318,'Event Clothes','false','quest',0,'stackable','cloth','none',-1,0,0,'false','false','true','false','q_event_cloth','none'),
(4319,'Nanarin\'s Flute','false','quest',0,'stackable','wood','none',-1,0,0,'false','false','true','false','q_nanarins_flute','none'),
(4320,'Sabrin\'s Black Beer','false','quest',0,'stackable','liquid','none',-1,0,0,'false','false','true','false','q_sabrin_black_beer','none'),
(4321,'Stolen Black Beer','false','quest',0,'stackable','liquid','none',-1,0,0,'false','false','true','false','q_stolen_black_beer','none'),
(4322,'Stolen Event Clothes','false','quest',0,'stackable','cloth','none',-1,0,0,'false','false','true','false','q_stolen_event_cloth','none'),
(4323,'Clothes Chest Key','false','quest',0,'stackable','steel','none',-1,0,0,'false','false','true','false','q_cloth_chest_key','none'),
(4324,'Beer Chest Key','false','quest',0,'stackable','steel','none',-1,0,0,'false','false','true','false','q_beer_chest_key','none'),
(4325,'Fairy Leaf','false','quest',0,'stackable','wood','none',-1,0,0,'false','false','true','false','q0421_fairy_leaf','none'),
(4326,'Ratman Scavenger\'s Skull','false','quest',0,'stackable','bone','none',-1,0,0,'false','false','true','false','q0422_rats_head','none'),
(4327,'Turek War Hound\'s Tail','false','quest',0,'stackable','bone','none',-1,0,0,'false','false','true','false','q0422_dogs_tail','none'),
(4328,'Tyrant Kingpin\'s Heart','false','quest',0,'stackable','leather','none',-1,0,0,'false','false','true','false','q0422_tyrants_heart','none'),
(4329,'Trisalim Tarantula\'s Venom Sac','false','quest',0,'stackable','cloth','none',-1,0,0,'false','false','true','false','q0422_trisalims_poison','none'),
(4330,'Penitent\'s Manacles','false','quest',0,'stackable','steel','none',-1,0,0,'false','false','true','false','q0422_manacles','none'),
(4331,'Manual of Manacles','false','quest',0,'stackable','paper','none',-1,0,0,'false','false','true','false','q0422_manual_of_manacles','none'),
(4332,'Tarlk Amulet','false','quest',0,'stackable','steel','none',-1,0,0,'false','false','true','false','q_tarlk_amulet','none'),
(4333,'Contest Certificate','false','quest',0,'stackable','paper','none',-1,0,0,'false','false','true','false','q_contest_certificate','none'),
(4334,'Ant\'s Ichor','false','quest',0,'stackable','liquid','none',-1,0,0,'false','false','true','false','q0332_ants_ichor','none'),
(4335,'Noble Ant\'s Nerve Tissue','false','quest',0,'stackable','liquid','none',-1,0,0,'false','false','true','false','q0332_ants_central_nerve','none'),
(4336,'Casian\'s Enzyme','false','quest',0,'stackable','paper','none',-1,0,0,'false','false','true','false','q0332_kasians_enzyme','none'),
(4337,'Alligator Leather','false','quest',0,'stackable','leather','none',-1,0,0,'false','false','true','false','q0338_crocodile_leather','none'),
(4338,'Blue Back Alligator Leather','false','quest',0,'stackable','leather','none',-1,0,0,'false','false','true','false','q0338_crocodile_leather_bb','none'),
(4339,'Jewel Studded Alligator Leather','false','quest',0,'stackable','leather','none',-1,0,0,'false','false','true','false','q0338_crocodile_leather_jw','none'),
(4340,'Certificate of Approval to Create a Belt','false','quest',0,'stackable','paper','none',-1,0,0,'false','false','true','false','q0338_recipe_for_belt','none'),
(4341,'Certificate of Approval to Create a Purse','false','quest',0,'stackable','paper','none',-1,0,0,'false','false','true','false','q0338_recipe_for_handbag','none'),
(4342,'Water Crystal','false','quest',0,'stackable','crystal','none',-1,0,0,'false','false','true','false','q0339_crystal_of_water','none'),
(4343,'Fire Crystal','false','quest',0,'stackable','crystal','none',-1,0,0,'false','false','true','false','q0339_crystal_of_fire','none'),
(4344,'Wind Crystal','false','quest',0,'stackable','crystal','none',-1,0,0,'false','false','true','false','q0339_crystal_of_wind','none'),
(4345,'Earth Crystal','false','quest',0,'stackable','crystal','none',-1,0,0,'false','false','true','false','q0339_crystal_of_earth','none'),
(4346,'Dark Crystal','false','quest',0,'stackable','crystal','none',-1,0,0,'false','false','true','false','q0339_crystal_of_darkness','none'),
(4347,'Crystal of Light','false','quest',0,'stackable','crystal','none',-1,0,0,'false','false','true','false','q0339_crystal_of_light','none'),
(4348,'Jade Crystal','false','none',1,'stackable','crystal','none',-1,0,0,'true','true','true','true','q_jade_crystal','none'),
(4349,'Bust of Ancient Goddess','false','none',5,'stackable','wood','none',-1,0,0,'true','true','true','true','q_beronas_goddess_idol','none'),
(4350,'The Work of the ancient sculptor Berona','false','none',5,'stackable','wood','none',-1,3400,0,'true','true','true','true','q_beronas_sculpture_0','none'),
(4351,'Ancient Statue of Goddess - Prototype','false','none',5,'stackable','wood','none',-1,10000,0,'true','true','true','true','q_beronas_sculpture_s','none'),
(4352,'Ancient Statue of Goddess - Original','false','none',5,'stackable','wood','none',-1,6800,0,'true','true','true','true','q_beronas_sculpture_a','none'),
(4353,'Ancient Statue of Goddess - Replica','false','none',5,'stackable','wood','none',-1,850,0,'true','true','true','true','q_beronas_sculpture_b','none'),
(4354,'Ancient Statue of Goddess - Forgery','false','none',5,'stackable','wood','none',-1,850,0,'true','true','true','true','q_beronas_sculpture_c','none'),
(4355,'Blue Eva','false','none',0,'stackable','steel','none',-1,0,0,'true','true','true','true','q_blue_eva','none'),
(4356,'Gold Einhasad','false','none',0,'stackable','steel','none',-1,0,0,'true','true','true','true','q_gold_einhasad','none'),
(4357,'Silver Shilen','false','none',0,'stackable','steel','none',-1,0,0,'true','true','true','true','q_silver_shilen','none'),
(4358,'Bloody Pa''agrio','false','none',0,'stackable','steel','none',-1,0,0,'true','true','true','true','q_blood_paagrio','none'),
(4359,'Barrel of Liquor','false','none',2000,'normal','wood','none',-1,0,0,'true','true','true','true','barrel_of_liquor','none'),
(4360,'Precious Scarab','false','none',0,'normal','crystal','none',-1,0,0,'true','true','true','true','precious_scarab','none'),
(4361,'Simbelmyne','false','none',0,'normal','wood','none',-1,0,0,'true','true','true','true','simbelmyne','none'),
(4362,'Odd (looking) Doll','false','none',500,'normal','steel','none',-1,0,0,'true','true','true','true','odd_doll','none'),
(4363,'Scarlet Dress','false','none',20,'normal','cloth','none',-1,0,0,'true','true','true','true','scalet_dress','none'),
(4364,'Nebulite Orb','false','none',2,'stackable','crystal','none',-1,10,0,'true','true','true','true','q_nebulite_orb','none'),
(4365,'Ectoplasm Liqueur','false','none',10,'normal','crystal','none',-1,0,0,'true','true','true','true','q_ectoplasm_liqueur','none'),
(4366,'Prince\'s Trophy','false','none',20,'stackable','steel','none',-1,0,0,'true','true','true','true','q_princes_trophy','none'),
(4367,'Prince\'s Autobiography','false','none',10,'stackable','paper','none',-1,0,0,'true','true','true','true','q_princes_autobiography','none'),
(4368,'Prince\'s Bust','false','none',20,'stackable','steel','none',-1,0,0,'true','true','true','true','q_princes_bust','none'),
(4369,'Silk Handkerchief','false','none',5,'stackable','cloth','none',-1,0,0,'true','true','true','true','q_silk_handkerchief','none'),
(4370,'Luxurious Goblet','false','none',10,'stackable','steel','none',-1,0,0,'true','true','true','true','q_luxurious_goblet','none'),
(4371,'Scepter of Darkness','false','none',10,'stackable','steel','none',-1,0,0,'true','true','true','true','q_scepter_of_darkness','none'),
(4372,'Succubus Perfume','false','none',5,'stackable','liquid','none',-1,0,0,'true','true','true','true','q_succubus_perfume','none'),
(4373,'Succubus Mirror','false','none',10,'stackable','liquid','none',-1,0,0,'true','true','true','true','q_succubus_mirror','none'),
(4374,'Heart of Darkness','false','none',30,'stackable','wood','none',-1,0,0,'true','true','true','true','q_heart_of_darkness','none'),
(4375,'Royal Orc Totem','false','none',30,'stackable','wood','none',-1,0,0,'true','true','true','true','q_royal_orc_totem','none'),
(4376,'Pearl Trodden/Trampled By A Wild Hog','false','none',5,'stackable','crystal','none',-1,0,0,'true','true','true','true','q_pearl_from_pigpen','none'),
(4377,'Boar\'s Tusk','false','none',10,'stackable','bone','none',-1,0,0,'true','true','true','true','q_boar_tusk','none'),
(4378,'Sweet Potato','false','none',5,'stackable','bone','none',-1,0,0,'true','true','true','true','q_sweet_potato','none'),
(4379,'Beast\'s Claws','false','none',5,'stackable','bone','none',-1,0,0,'true','true','true','true','q_beasts_claws','none'),
(4380,'Beast\'s Mane','false','none',10,'stackable','leather','none',-1,0,0,'true','true','true','true','q_beasts_mane','none'),
(4381,'Ginseng Root','false','none',5,'stackable','wood','none',-1,0,0,'true','true','true','true','q_ginseng_root','none'),
(4382,'Honey Jar','false','none',10,'stackable','steel','none',-1,0,0,'true','true','true','true','q_honey_jar','none'),
(4383,'Bear\'s Gall','false','none',5,'stackable','liquid','none',-1,0,0,'true','true','true','true','q_bears_gall','none'),
(4384,'Fresh Samon','false','none',5,'stackable','bone','none',-1,0,0,'true','true','true','true','q_fresh_salmon','none'),
(4385,'Sushi Riceball','false','none',5,'stackable','liquid','none',-1,0,0,'true','true','true','true','q_sushi_riceball','none'),
(4386,'Avellan Spice','false','none',5,'stackable','liquid','none',-1,0,0,'true','true','true','true','q_avellan_spice','none'),
(4387,'Lucky Rabbit Weed','false','none',5,'stackable','wood','none',-1,0,0,'true','true','true','true','q_lucky_rabbit_weed','none'),
(4388,'Malcom\'s Check','false','none',10,'stackable','paper','none',-1,0,0,'true','true','true','true','q_malcoms_check','none'),
(4389,'Deposit Box Key','false','none',10,'stackable','steel','none',-1,0,0,'true','true','true','true','q_deposit_key','none'),
(4390,'Dwarven Royal Seal','false','none',20,'stackable','steel','none',-1,0,0,'true','true','true','true','q_dwarven_royal_seal','none'),
(4391,'Dwarven Royal Crown','false','none',20,'stackable','steel','none',-1,0,0,'true','true','true','true','q_dwarven_royal_crown','none'),
(4392,'Dwarven Dance Manual','false','none',20,'stackable','paper','none',-1,0,0,'true','true','true','true','q_dwarven_dance_manual','none'),
(4393,'Calculator','false','none',20,'normal','steel','none',-1,200,0,'true','true','true','true','calculator','none'),
(4394,'Hanellin\'s White Flower','false','none',0,'normal','wood','none',-1,0,0,'true','false','false','true','hanellins_white_flower','none'),
(4395,'Hanellin\'s Red Flower','false','none',0,'normal','wood','none',-1,0,0,'true','false','false','true','hanellins_red_flower','none'),
(4396,'Hanellin\'s Yellow Flower','false','none',0,'normal','wood','none',-1,0,0,'true','false','false','true','hanellins_yellow_flower','none'),
(4397,'Book of Saint','false','none',20,'normal','paper','none',-1,0,0,'true','false','false','true','book_of_saint','none'),
(4398,'Blood of Saint','false','none',20,'normal','liquid','none',-1,0,0,'true','false','false','true','blood_of_saint','none'),
(4399,'Bough of Saint','false','none',20,'normal','wood','none',-1,0,0,'true','false','false','true','bough_of_saint','none'),
(4400,'White Fabric','false','none',0,'stackable','cloth','none',-1,0,0,'true','false','false','true','white_fabric','none'),
(4401,'Green Dimensional Stone','false','none',10,'stackable','crystal','none',-1,100000,0,'true','true','true','true','green_dimension_stone','none'),
(4402,'Blue Dimensional Stone','false','none',10,'stackable','crystal','none',-1,100000,0,'true','true','true','true','blue_dimension_stone','none'),
(4403,'Red Dimensional Stone','false','none',10,'stackable','crystal','none',-1,100000,0,'true','true','true','true','red_dimension_stone','none'),
(4404,'Green Dimensional Stone - Shard','false','none',10,'stackable','crystal','none',-1,0,0,'true','true','true','true','green_d_stone_shard','none'),
(4405,'Blue Dimensional Stone - Shard','false','none',10,'stackable','crystal','none',-1,0,0,'true','true','true','true','blue_d_stone_shard','none'),
(4406,'Red Dimensional Stone - Shard','false','none',10,'stackable','crystal','none',-1,0,0,'true','true','true','true','red_d_stone_shard','none'),
(4407,'Bill of Iason Heine','false','none',0,'stackable','paper','none',-1,0,0,'true','true','true','true','bill_of_iason','none'),
(4408,'Musical Score - Theme of Love','false','none',20,'stackable','paper','none',-1,0,0,'true','true','true','true','q_musicnote_love','none'),
(4409,'Musical Score - Theme of Battle','false','none',20,'stackable','paper','none',-1,0,0,'true','true','true','true','q_musicnote_battle','none'),
(4410,'Musical Score - Theme of Journey','false','none',20,'stackable','paper','none',-1,0,0,'true','true','true','true','q_musicnote_journey','none'),
(4411,'Echo Crystal - Theme of Journey','false','none',10,'stackable','paper','none',-1,0,0,'true','true','true','true','echo_crystal_journey','none'),
(4412,'Echo Crystal - Theme of Battle','false','none',10,'stackable','paper','none',-1,0,0,'true','true','true','true','echo_crystal_battle','none'),
(4413,'Echo Crystal - Theme of Love','false','none',10,'stackable','paper','none',-1,0,0,'true','true','true','true','echo_crystal_love','none'),
(4414,'Echo Crystal - Theme of Solitude','false','none',10,'stackable','paper','none',-1,0,0,'true','true','true','true','echo_crystal_solitude','none'),
(4415,'Echo Crystal - Theme of the Feast','false','none',10,'stackable','paper','none',-1,0,0,'true','true','true','true','echo_crystal_feast','none'),
(4416,'Echo Crystal - Theme of Celebration','false','none',10,'stackable','paper','none',-1,0,0,'true','true','true','true','echo_crystal_celebration','none'),
(4417,'Echo Crystal - Theme of Comedy','false','none',10,'stackable','paper','none',-1,0,0,'true','true','true','true','echo_crystal_comedy','none'),
(4418,'Musical Score - Theme of Celebration','false','none',20,'stackable','paper','none',-1,0,0,'true','true','true','true','q_musicnote_celebration','none'),
(4419,'Musical Score - Theme of Comedy','false','none',20,'stackable','paper','none',-1,0,0,'true','true','true','true','q_musicnote_comedy','none'),
(4420,'Musical Score - Theme of Solitude','false','none',20,'stackable','paper','none',-1,0,0,'true','true','true','true','q_musicnote_solitude','none'),
(4421,'Musical Score - Theme of the Feast','false','none',20,'stackable','paper','none',-1,0,0,'true','true','true','true','q_musicnote_feast','none'),
(4422,'Dragon Bugle of Wind','false','pet_collar',20,'normal','steel','none',-1,0,0,'true','true','true','true','dragon_bugle_wind','pet_collar'),
(4423,'Dragon Bugle of Star','false','pet_collar',20,'normal','steel','none',-1,0,0,'true','true','true','true','dragon_bugle_star','pet_collar'),
(4424,'Dragon Bugle of Dusk','false','pet_collar',20,'normal','steel','none',-1,0,0,'true','true','true','true','dragon_bugle_dusk','pet_collar'),
(4425,'Penitent\'s Manacles','false','pet_collar',800,'normal','steel','none',-1,0,0,'false','false','false','false','manacles_of_redemption','pet_collar'),
(4426,'Manacles of Penitent','false','none',50,'normal','steel','none',-1,22000,0,'true','false','true','true','manacles_of_redeemed','none'),
(4427,'Alligator Leather Belt','false','none',20,'normal','leather','none',-1,0,0,'true','true','true','true','croc_leather_belt','none'),
(4428,'Blue Alligator Leather Belt','false','none',20,'normal','leather','none',-1,0,0,'true','true','true','true','croc_leather_belt_bb','none'),
(4429,'Bejeweled Leather Belt','false','none',20,'normal','leather','none',-1,0,0,'true','true','true','true','croc_leather_belt_jw','none'),
(4430,'Alligator Leather Purse','false','none',20,'normal','leather','none',-1,0,0,'true','true','true','true','croc_leather_bag','none'),
(4431,'Blue Alligator Leather Purse','false','none',20,'normal','leather','none',-1,0,0,'true','true','true','true','croc_leather_bag_bb','none'),
(4432,'Bejeweled Purse','false','none',20,'normal','leather','none',-1,0,0,'true','true','true','true','croc_leather_bag_jw','none'),
(4433,'Elemental Stone Powder','false','none',10,'stackable','crystal','none',-1,0,0,'true','true','true','true','elemental_stone_powder','none'),
(4434,'Elemental Stone Shards','false','none',100,'stackable','crystal','none',-1,0,0,'true','true','true','true','elemental_stone_shards','none'),
(4435,'Elemental Stone Lump','false','none',1000,'stackable','crystal','none',-1,0,0,'true','true','true','true','elemental_stone_lump','none'),
(4436,'Bentley\'s Request','false','quest',0,'stackable','paper','none',-1,0,0,'false','false','true','false','q_bentleys_request','none'),
(4437,'Carson\'s Request','false','quest',0,'stackable','paper','none',-1,0,0,'false','false','true','false','q_carsons_request','none'),
(4438,'Knuckle Duster Edge','false','material',60,'stackable','liquid','none',-1,28044,0,'true','true','true','true','knuckle_dust_edge','material'),
(4439,'Avadon Shield Fragment','false','material',60,'stackable','liquid','none',-1,2900,0,'true','true','true','true','avadon_shield_fragment','material'),
(4440,'Recipe: Knuckle Duster','false','recipe',30,'stackable','liquid','none',-1,57400,0,'true','true','true','true','rp_knuckle_dust','recipe'),
(4441,'Recipe: Avadon Shield','false','recipe',30,'stackable','liquid','none',-1,10900,0,'true','true','true','true','rp_avadon_shield','recipe'),
(4442,'Lottery Ticket','false','lotto',20,'normal','paper','none',-1,0,0,'true','true','true','true','lottery_ticket','lotto'),
(4443,'Monster Race Ticket - Single','false','race_ticket',20,'normal','paper','none',-1,0,0,'false','false','true','false','monster_race_ticket_single','race_ticket'),
(4444,'Monster Race Ticket - Double','false','race_ticket',20,'normal','paper','none',-1,0,0,'false','false','true','false','monster_race_ticket_double','race_ticket'),
(4445,'Dye of STR <Str+1 Con-3>','false','dye',150,'stackable','liquid','none',-1,5100,0,'true','true','true','true','dye_s1c3_d','dye'),
(4446,'Dye of STR <Str+1 Dex-3>','false','dye',150,'stackable','liquid','none',-1,5100,0,'true','true','true','true','dye_s1d3_d','dye'),
(4447,'Dye of CON <Con+1 Str-3>','false','dye',150,'stackable','liquid','none',-1,5100,0,'true','true','true','true','dye_c1s3_d','dye'),
(4448,'Dye of CON <Con+1 Dex-3>','false','dye',150,'stackable','liquid','none',-1,5100,0,'true','true','true','true','dye_c1d3_d','dye'),
(4449,'Dye of DEX <Dex+1 Str-3>','false','dye',150,'stackable','liquid','none',-1,5100,0,'true','true','true','true','dye_d1s3_d','dye'),
(4450,'Dye of DEX <Dex+1 Con-3>','false','dye',150,'stackable','liquid','none',-1,5100,0,'true','true','true','true','dye_d1c3_d','dye'),
(4451,'Dye of INT <Int+1 Men-3>','false','dye',150,'stackable','liquid','none',-1,5100,0,'true','true','true','true','dye_i1m3_d','dye'),
(4452,'Dye of INT <Int+1 Wit-3>','false','dye',150,'stackable','liquid','none',-1,5100,0,'true','true','true','true','dye_i1w3_d','dye'),
(4453,'Dye of MEN <Men+1 Int-3>','false','dye',150,'stackable','liquid','none',-1,5100,0,'true','true','true','true','dye_m1i3_d','dye'),
(4454,'Dye of MEN <Men+1 Wit-3>','false','dye',150,'stackable','liquid','none',-1,5100,0,'true','true','true','true','dye_m1w3_d','dye'),
(4455,'Dye of WIT <Wit+1 Int-3>','false','dye',150,'stackable','liquid','none',-1,5100,0,'true','true','true','true','dye_w1i3_d','dye'),
(4456,'Dye of WIT <Wit+1 Men-3>','false','dye',150,'stackable','liquid','none',-1,5100,0,'true','true','true','true','dye_w1m3_d','dye'),
(4457,'Dye of STR <Str+1 Con-2>','false','dye',150,'stackable','liquid','none',-1,12000,0,'true','true','true','true','dye_s1c2_d','dye'),
(4458,'Dye of STR <Str+1 Dex-2>','false','dye',150,'stackable','liquid','none',-1,12000,0,'true','true','true','true','dye_s1d2_d','dye'),
(4459,'Dye of CON <Con+1 Str-2>','false','dye',150,'stackable','liquid','none',-1,12000,0,'true','true','true','true','dye_c1s2_d','dye'),
(4460,'Dye of CON <Con+1 Dex-2>','false','dye',150,'stackable','liquid','none',-1,12000,0,'true','true','true','true','dye_c1d2_d','dye'),
(4461,'Dye of DEX <Dex+1 Str-2>','false','dye',150,'stackable','liquid','none',-1,12000,0,'true','true','true','true','dye_d1s2_d','dye'),
(4462,'Dye of DEX <Dex+1 Con-2>','false','dye',150,'stackable','liquid','none',-1,12000,0,'true','true','true','true','dye_d1c2_d','dye'),
(4463,'Dye of INT <Int+1 Men-2>','false','dye',150,'stackable','liquid','none',-1,12000,0,'true','true','true','true','dye_i1m2_d','dye'),
(4464,'Dye of INT <Int+1 Wit-2>','false','dye',150,'stackable','liquid','none',-1,12000,0,'true','true','true','true','dye_i1w2_d','dye'),
(4465,'Dye of MEN <Men+1 Int-2>','false','dye',150,'stackable','liquid','none',-1,12000,0,'true','true','true','true','dye_m1i2_d','dye'),
(4466,'Dye of MEN <Men+1 Wit-2>','false','dye',150,'stackable','liquid','none',-1,12000,0,'true','true','true','true','dye_m1w2_d','dye'),
(4467,'Dye of WIT <Wit+1 Int-2>','false','dye',150,'stackable','liquid','none',-1,12000,0,'true','true','true','true','dye_w1i2_d','dye'),
(4468,'Dye of WIT <Wit+1 Men-2>','false','dye',150,'stackable','liquid','none',-1,12000,0,'true','true','true','true','dye_w1m2_d','dye'),
(4469,'Dye of STR <Str+1 Con-1>','false','dye',150,'stackable','liquid','none',-1,42000,0,'true','true','true','true','dye_s1c1_d','dye'),
(4470,'Dye of STR <Str+1 Dex-1>','false','dye',150,'stackable','liquid','none',-1,42000,0,'true','true','true','true','dye_s1d1_d','dye'),
(4471,'Dye of CON <Con+1 Str-1>','false','dye',150,'stackable','liquid','none',-1,42000,0,'true','true','true','true','dye_c1s1_d','dye'),
(4472,'Dye of CON <Con+1 Dex-1>','false','dye',150,'stackable','liquid','none',-1,42000,0,'true','true','true','true','dye_c1d1_d','dye'),
(4473,'Dye of DEX <Dex+1 Str-1>','false','dye',150,'stackable','liquid','none',-1,42000,0,'true','true','true','true','dye_d1s1_d','dye'),
(4474,'Dye of DEX <Dex+1 Con-1>','false','dye',150,'stackable','liquid','none',-1,42000,0,'true','true','true','true','dye_d1c1_d','dye'),
(4475,'Dye of INT <Int+1 Men-1>','false','dye',150,'stackable','liquid','none',-1,42000,0,'true','true','true','true','dye_i1m1_d','dye'),
(4476,'Dye of INT <Int+1 Wit-1>','false','dye',150,'stackable','liquid','none',-1,42000,0,'true','true','true','true','dye_i1w1_d','dye'),
(4477,'Dye of MEN <Men+1 Int-1>','false','dye',150,'stackable','liquid','none',-1,42000,0,'true','true','true','true','dye_m1i1_d','dye'),
(4478,'Dye of MEN <Men+1 Wit-1>','false','dye',150,'stackable','liquid','none',-1,42000,0,'true','true','true','true','dye_m1w1_d','dye'),
(4479,'Dye of WIT <Wit+1 Int-1>','false','dye',150,'stackable','liquid','none',-1,42000,0,'true','true','true','true','dye_w1i1_d','dye'),
(4480,'Dye of WIT <Wit+1 Men-1>','false','dye',150,'stackable','liquid','none',-1,42000,0,'true','true','true','true','dye_w1m1_d','dye'),
(4481,'Greater Dye of STR <Str+1 Con-3>','false','dye',150,'stackable','liquid','none',-1,12000,0,'true','true','true','true','dye_s1c3_c','dye'),
(4482,'Greater Dye of STR <Str+1 Dex-3>','false','dye',150,'stackable','liquid','none',-1,12000,0,'true','true','true','true','dye_s1d3_c','dye'),
(4483,'Greater Dye of CON<Con+1 Str-3>','false','dye',150,'stackable','liquid','none',-1,12000,0,'true','true','true','true','dye_c1s3_c','dye'),
(4484,'Greater Dye of CON<Con+1 Dex-3>','false','dye',150,'stackable','liquid','none',-1,12000,0,'true','true','true','true','dye_c1c3_c','dye'),
(4485,'Greater Dye of DEX <Dex+1 Str-3>','false','dye',150,'stackable','liquid','none',-1,12000,0,'true','true','true','true','dye_d1s3_c','dye'),
(4486,'Greater Dye of DEX <Dex+1 Con-3>','false','dye',150,'stackable','liquid','none',-1,12000,0,'true','true','true','true','dye_d1c3_c','dye'),
(4487,'Greater Dye of INT <Int+1 Men-3>','false','dye',150,'stackable','liquid','none',-1,12000,0,'true','true','true','true','dye_i1m3_c','dye'),
(4488,'Greater Dye of INT <Int+1 Wit-3>','false','dye',150,'stackable','liquid','none',-1,12000,0,'true','true','true','true','dye_i1w3_c','dye'),
(4489,'Greater Dye of MEN <Men+1 Int-3>','false','dye',150,'stackable','liquid','none',-1,12000,0,'true','true','true','true','dye_m1i3_c','dye'),
(4490,'Greater Dye of MEN <Men+1 Wit-3>','false','dye',150,'stackable','liquid','none',-1,12000,0,'true','true','true','true','dye_m1w3_c','dye'),
(4491,'Greater Dye of WIT <Wit+1 Int-3>','false','dye',150,'stackable','liquid','none',-1,12000,0,'true','true','true','true','dye_w1i3_c','dye'),
(4492,'Greater Dye of WIT <Wit+1 Men-3>','false','dye',150,'stackable','liquid','none',-1,12000,0,'true','true','true','true','dye_w1m3_c','dye'),
(4493,'Greater Dye of STR <Str+1 Con-2>','false','dye',150,'stackable','liquid','none',-1,21000,0,'true','true','true','true','dye_s1c2_c','dye'),
(4494,'Greater Dye of STR <Str+1 Dex-2>','false','dye',150,'stackable','liquid','none',-1,21000,0,'true','true','true','true','dye_s1d2_c','dye'),
(4495,'Greater Dye of CON <Con+1 Str-2>','false','dye',150,'stackable','liquid','none',-1,21000,0,'true','true','true','true','dye_c1s2_c','dye'),
(4496,'Greater Dye of CON <Con+1 Dex-2>','false','dye',150,'stackable','liquid','none',-1,21000,0,'true','true','true','true','dye_c1c2_c','dye'),
(4497,'Greater Dye of DEX <Dex+1 Str-2>','false','dye',150,'stackable','liquid','none',-1,21000,0,'true','true','true','true','dye_d1s2_c','dye'),
(4498,'Greater Dye of DEX <Dex+1 Con-2>','false','dye',150,'stackable','liquid','none',-1,21000,0,'true','true','true','true','dye_d1c2_c','dye'),
(4499,'Greater Dye of INT <Int+1 Men-2>','false','dye',150,'stackable','liquid','none',-1,21000,0,'true','true','true','true','dye_i1m2_c','dye'),
(4500,'Greater Dye of INT <Int+1 Wit-2>','false','dye',150,'stackable','liquid','none',-1,21000,0,'true','true','true','true','dye_i1w2_c','dye'),
(4501,'Greater Dye of MEN <Men+1 Int-2>','false','dye',150,'stackable','liquid','none',-1,21000,0,'true','true','true','true','dye_m1i2_c','dye'),
(4502,'Greater Dye of MEN <Men+1 Wit-2>','false','dye',150,'stackable','liquid','none',-1,21000,0,'true','true','true','true','dye_m1w2_c','dye'),
(4503,'Greater Dye of WIT <Wit+1 Int-2>','false','dye',150,'stackable','liquid','none',-1,21000,0,'true','true','true','true','dye_w1i2_c','dye'),
(4504,'Greater Dye of WIT <Wit+1 Men-2>','false','dye',150,'stackable','liquid','none',-1,21000,0,'true','true','true','true','dye_w1m2_c','dye'),
(4505,'Greater Dye of STR <Str+2 Con-4>','false','dye',150,'stackable','liquid','none',-1,24600,0,'true','true','true','true','dye_s2c4_c','dye'),
(4506,'Greater Dye of STR <Str+2 Dex-4>','false','dye',150,'stackable','liquid','none',-1,24600,0,'true','true','true','true','dye_s2d4_c','dye'),
(4507,'Greater Dye of CON <Con+2 Str-4>','false','dye',150,'stackable','liquid','none',-1,24600,0,'true','true','true','true','dye_c2s4_c','dye'),
(4508,'Greater Dye of CON <Con+2 Dex-4>','false','dye',150,'stackable','liquid','none',-1,24600,0,'true','true','true','true','dye_c2c4_c','dye'),
(4509,'Greater Dye of DEX <Dex+2 Str-4>','false','dye',150,'stackable','liquid','none',-1,24600,0,'true','true','true','true','dye_d2s4_c','dye'),
(4510,'Greater Dye of DEX <Dex+2 Con-4>','false','dye',150,'stackable','liquid','none',-1,24600,0,'true','true','true','true','dye_d2c4_c','dye'),
(4511,'Greater Dye of INT <Int+2 Men-4>','false','dye',150,'stackable','liquid','none',-1,24600,0,'true','true','true','true','dye_i2m4_c','dye'),
(4512,'Greater Dye of INT <Int+2 Wit-4>','false','dye',150,'stackable','liquid','none',-1,24600,0,'true','true','true','true','dye_i2w4_c','dye'),
(4513,'Greater Dye of MEN <Men+2 Int-4>','false','dye',150,'stackable','liquid','none',-1,24600,0,'true','true','true','true','dye_m2i4_c','dye'),
(4514,'Greater Dye of MEN <Men+2 Wit-4>','false','dye',150,'stackable','liquid','none',-1,24600,0,'true','true','true','true','dye_m2w4_c','dye'),
(4515,'Greater Dye of WIT <Wit+2 Int-4>','false','dye',150,'stackable','liquid','none',-1,24600,0,'true','true','true','true','dye_w2i4_c','dye'),
(4516,'Greater Dye of WIT <Wit+2 Men-4>','false','dye',150,'stackable','liquid','none',-1,24600,0,'true','true','true','true','dye_w2m4_c','dye'),
(4517,'Greater Dye of STR <Str+2 Con-3>','false','dye',150,'stackable','liquid','none',-1,27000,0,'true','true','true','true','dye_s2c3_c','dye'),
(4518,'Greater Dye of STR <Str+2 Dex-3>','false','dye',150,'stackable','liquid','none',-1,27000,0,'true','true','true','true','dye_s2d3_c','dye'),
(4519,'Greater Dye of CON <Con+2 Str-3>','false','dye',150,'stackable','liquid','none',-1,27000,0,'true','true','true','true','dye_c2s3_c','dye'),
(4520,'Greater Dye of CON <Con+2 Dex-3>','false','dye',150,'stackable','liquid','none',-1,27000,0,'true','true','true','true','dye_c2c3_c','dye'),
(4521,'Greater Dye of DEX <Dex+2 Str-3>','false','dye',150,'stackable','liquid','none',-1,27000,0,'true','true','true','true','dye_d2s3_c','dye'),
(4522,'Greater Dye of DEX <Dex+2 Con-3>','false','dye',150,'stackable','liquid','none',-1,27000,0,'true','true','true','true','dye_d2c3_c','dye'),
(4523,'Greater Dye of INT <Int+2 Men-3>','false','dye',150,'stackable','liquid','none',-1,27000,0,'true','true','true','true','dye_i2m3_c','dye'),
(4524,'Greater Dye of INT <Int+2 Wit-3>','false','dye',150,'stackable','liquid','none',-1,27000,0,'true','true','true','true','dye_i2w3_c','dye'),
(4525,'Greater Dye of MEN <Men+2 Int-3>','false','dye',150,'stackable','liquid','none',-1,27000,0,'true','true','true','true','dye_m2i3_c','dye'),
(4526,'Greater Dye of MEN <Men+2 Wit-3>','false','dye',150,'stackable','liquid','none',-1,27000,0,'true','true','true','true','dye_m2w3_c','dye'),
(4527,'Greater Dye of WIT <Wit+2 Int-3>','false','dye',150,'stackable','liquid','none',-1,27000,0,'true','true','true','true','dye_w2i3_c','dye'),
(4528,'Greater Dye of WIT <Wit+2 Men-3>','false','dye',150,'stackable','liquid','none',-1,27000,0,'true','true','true','true','dye_w2m3_c','dye'),
(4529,'Greater Dye of STR <Str+3 Con-5>','false','dye',150,'stackable','liquid','none',-1,30000,0,'true','true','true','true','dye_s3c5_c','dye'),
(4530,'Greater Dye of STR <Str+3 Dex-5>','false','dye',150,'stackable','liquid','none',-1,30000,0,'true','true','true','true','dye_s3d5_c','dye'),
(4531,'Greater Dye of CON <Con+3 Str-5>','false','dye',150,'stackable','liquid','none',-1,30000,0,'true','true','true','true','dye_c3s5_c','dye'),
(4532,'Greater Dye of CON <Con+3 Dex-5>','false','dye',150,'stackable','liquid','none',-1,30000,0,'true','true','true','true','dye_c3c5_c','dye'),
(4533,'Greater Dye of DEX <Dex+3 Str-5>','false','dye',150,'stackable','liquid','none',-1,30000,0,'true','true','true','true','dye_d3s5_c','dye'),
(4534,'Greater Dye of DEX <Dex+3 Con-5>','false','dye',150,'stackable','liquid','none',-1,30000,0,'true','true','true','true','dye_d3c5_c','dye'),
(4535,'Greater Dye of INT <Int+3 Men-5>','false','dye',150,'stackable','liquid','none',-1,30000,0,'true','true','true','true','dye_i3m5_c','dye'),
(4536,'Greater Dye of INT <Int+3 Wit-5>','false','dye',150,'stackable','liquid','none',-1,30000,0,'true','true','true','true','dye_i3w5_c','dye'),
(4537,'Greater Dye of MEN <Men+3 Int-5>','false','dye',150,'stackable','liquid','none',-1,30000,0,'true','true','true','true','dye_m3i5_c','dye'),
(4538,'Greater Dye of MEN <Men+3 Wit-5>','false','dye',150,'stackable','liquid','none',-1,30000,0,'true','true','true','true','dye_m3w5_c','dye'),
(4539,'Greater Dye of WIT <Wit+3 Int-5>','false','dye',150,'stackable','liquid','none',-1,30000,0,'true','true','true','true','dye_w3i5_c','dye'),
(4540,'Greater Dye of WIT <Wit+3 Men-5>','false','dye',150,'stackable','liquid','none',-1,30000,0,'true','true','true','true','dye_w3m5_c','dye'),
(4541,'Greater Dye of STR <Str+3 Con-4>','false','dye',150,'stackable','liquid','none',-1,30000,0,'true','true','true','true','dye_s3c4_c','dye'),
(4542,'Greater Dye of STR <Str+3 Dex-4>','false','dye',150,'stackable','liquid','none',-1,30000,0,'true','true','true','true','dye_s3d4_c','dye'),
(4543,'Greater Dye of CON <Con+3 Str-4>','false','dye',150,'stackable','liquid','none',-1,30000,0,'true','true','true','true','dye_c3s4_c','dye'),
(4544,'Greater Dye of CON <Con+3 Dex-4>','false','dye',150,'stackable','liquid','none',-1,30000,0,'true','true','true','true','dye_c3c4_c','dye'),
(4545,'Greater Dye of DEX <Dex+3 Str-4>','false','dye',150,'stackable','liquid','none',-1,30000,0,'true','true','true','true','dye_d3s4_c','dye'),
(4546,'Greater Dye of DEX <Dex+3 Con-4>','false','dye',150,'stackable','liquid','none',-1,30000,0,'true','true','true','true','dye_d3c4_c','dye'),
(4547,'Greater Dye of INT <Int+3 Men-4>','false','dye',150,'stackable','liquid','none',-1,30000,0,'true','true','true','true','dye_i3m4_c','dye'),
(4548,'Greater Dye of INT <Int+3 Wit-4>','false','dye',150,'stackable','liquid','none',-1,30000,0,'true','true','true','true','dye_i3w4_c','dye'),
(4549,'Greater Dye of MEN <Men+3 Int-4>','false','dye',150,'stackable','liquid','none',-1,30000,0,'true','true','true','true','dye_m3i4_c','dye'),
(4550,'Greater Dye of MEN <Men+3 Wit-4>','false','dye',150,'stackable','liquid','none',-1,30000,0,'true','true','true','true','dye_m3w4_c','dye'),
(4551,'Greater Dye of WIT <Wit+3 Int-4>','false','dye',150,'stackable','liquid','none',-1,30000,0,'true','true','true','true','dye_w3i4_c','dye'),
(4552,'Greater Dye of WIT <Wit+3 Men-4>','false','dye',150,'stackable','liquid','none',-1,30000,0,'true','true','true','true','dye_w3m4_c','dye'),
(4553,'Greater Dye of STR <Str+1 Con-1>','false','dye',150,'stackable','liquid','none',-1,60000,0,'true','true','true','true','dye_s1c1_c','dye'),
(4554,'Greater Dye of STR <Str+1 Dex-1>','false','dye',150,'stackable','liquid','none',-1,60000,0,'true','true','true','true','dye_s1d1_c','dye'),
(4555,'Greater Dye of CON <Con+1 Str-1>','false','dye',150,'stackable','liquid','none',-1,60000,0,'true','true','true','true','dye_c1s1_c','dye'),
(4556,'Greater Dye of CON <Con+1 Dex-1>','false','dye',150,'stackable','liquid','none',-1,60000,0,'true','true','true','true','dye_c1c1_c','dye'),
(4557,'Greater Dye of DEX <Dex+1 Str-1>','false','dye',150,'stackable','liquid','none',-1,60000,0,'true','true','true','true','dye_d1s1_c','dye'),
(4558,'Greater Dye of DEX <Dex+1 Con-1>','false','dye',150,'stackable','liquid','none',-1,60000,0,'true','true','true','true','dye_d1c1_c','dye'),
(4559,'Greater Dye of INT <Int+1 Men-1>','false','dye',150,'stackable','liquid','none',-1,60000,0,'true','true','true','true','dye_i1m1_c','dye'),
(4560,'Greater Dye of INT <Int+1 Wit-1>','false','dye',150,'stackable','liquid','none',-1,60000,0,'true','true','true','true','dye_i1w1_c','dye'),
(4561,'Greater Dye of MEN <Men+1 Int-1>','false','dye',150,'stackable','liquid','none',-1,60000,0,'true','true','true','true','dye_m1i1_c','dye'),
(4562,'Greater Dye of MEN <Men+1 Wit-1>','false','dye',150,'stackable','liquid','none',-1,60000,0,'true','true','true','true','dye_m1w1_c','dye'),
(4563,'Greater Dye of WIT <Wit+1 Int-1>','false','dye',150,'stackable','liquid','none',-1,60000,0,'true','true','true','true','dye_w1i1_c','dye'),
(4564,'Greater Dye of WIT <Wit+1 Men-1>','false','dye',150,'stackable','liquid','none',-1,60000,0,'true','true','true','true','dye_w1m1_c','dye'),
(4565,'Greater Dye of STR <Str+4 Con-6>','false','dye',150,'stackable','liquid','none',-1,36000,0,'true','true','true','true','dye_s4c6_c','dye'),
(4566,'Greater Dye of STR <Str+4 Dex-6>','false','dye',150,'stackable','liquid','none',-1,36000,0,'true','true','true','true','dye_s4d6_c','dye'),
(4567,'Greater Dye of CON <Con+4 Str-6>','false','dye',150,'stackable','liquid','none',-1,36000,0,'true','true','true','true','dye_c4s6_c','dye'),
(4568,'Greater Dye of CON <Con+4 Dex-6>','false','dye',150,'stackable','liquid','none',-1,36000,0,'true','true','true','true','dye_c4c6_c','dye'),
(4569,'Greater Dye of DEX <Dex+4 Str-6>','false','dye',150,'stackable','liquid','none',-1,36000,0,'true','true','true','true','dye_d4s6_c','dye'),
(4570,'Greater Dye of DEX <Dex+4 Con-6>','false','dye',150,'stackable','liquid','none',-1,36000,0,'true','true','true','true','dye_d4c6_c','dye'),
(4571,'Greater Dye of INT <Int+4 Men-6>','false','dye',150,'stackable','liquid','none',-1,36000,0,'true','true','true','true','dye_i4m6_c','dye'),
(4572,'Greater Dye of INT <Int+4 Wit-6>','false','dye',150,'stackable','liquid','none',-1,36000,0,'true','true','true','true','dye_i4w6_c','dye'),
(4573,'Greater Dye of MEN <Men+4 Int-6>','false','dye',150,'stackable','liquid','none',-1,36000,0,'true','true','true','true','dye_m4i6_c','dye'),
(4574,'Greater Dye of MEN <Men+4 Wit-6>','false','dye',150,'stackable','liquid','none',-1,36000,0,'true','true','true','true','dye_m4w6_c','dye'),
(4575,'Greater Dye of WIT <Wit+4 Int-6>','false','dye',150,'stackable','liquid','none',-1,36000,0,'true','true','true','true','dye_w4i6_c','dye'),
(4576,'Greater Dye of WIT <Wit+4 Men-6>','false','dye',150,'stackable','liquid','none',-1,36000,0,'true','true','true','true','dye_w4m6_c','dye'),
(4577,'Greater Dye of STR <Str+4 Con-5>','false','dye',150,'stackable','liquid','none',-1,36000,0,'true','true','true','true','dye_s4c5_c','dye'),
(4578,'Greater Dye of STR <Str+4 Dex-5>','false','dye',150,'stackable','liquid','none',-1,36000,0,'true','true','true','true','dye_s4d5_c','dye'),
(4579,'Greater Dye of CON <Con+4 Str-5>','false','dye',150,'stackable','liquid','none',-1,36000,0,'true','true','true','true','dye_c4s5_c','dye'),
(4580,'Greater Dye of CON <Con+4 Dex-5>','false','dye',150,'stackable','liquid','none',-1,36000,0,'true','true','true','true','dye_c4c5_c','dye'),
(4581,'Greater Dye of DEX <Dex+4 Str-5>','false','dye',150,'stackable','liquid','none',-1,36000,0,'true','true','true','true','dye_d4s5_c','dye'),
(4582,'Greater Dye of DEX <Dex+4 Con-5>','false','dye',150,'stackable','liquid','none',-1,36000,0,'true','true','true','true','dye_d4c5_c','dye'),
(4583,'Greater Dye of INT <Int+4 Men-5>','false','dye',150,'stackable','liquid','none',-1,36000,0,'true','true','true','true','dye_i4m5_c','dye'),
(4584,'Greater Dye of INT <Int+4 Wit-5>','false','dye',150,'stackable','liquid','none',-1,36000,0,'true','true','true','true','dye_i4w5_c','dye'),
(4585,'Greater Dye of MEN <Men+4 Int-5>','false','dye',150,'stackable','liquid','none',-1,36000,0,'true','true','true','true','dye_m4i5_c','dye'),
(4586,'Greater Dye of MEN <Men+4 Wit-5>','false','dye',150,'stackable','liquid','none',-1,36000,0,'true','true','true','true','dye_m4w5_c','dye'),
(4587,'Greater Dye of WIT <Wit+4 Int-5>','false','dye',150,'stackable','liquid','none',-1,36000,0,'true','true','true','true','dye_w4i5_c','dye'),
(4588,'Greater Dye of WIT <Wit+4 Men-5>','false','dye',150,'stackable','liquid','none',-1,36000,0,'true','true','true','true','dye_w4m5_c','dye'),
(4589,'Greater Dye of STR <Str+2 Con-2>','false','dye',150,'stackable','liquid','none',-1,72000,0,'true','true','true','true','dye_s2c2_c','dye'),
(4590,'Greater Dye of STR <Str+2 Dex-2>','false','dye',150,'stackable','liquid','none',-1,72000,0,'true','true','true','true','dye_s2d2_c','dye'),
(4591,'Greater Dye of CON <Con+2 Str-2>','false','dye',150,'stackable','liquid','none',-1,72000,0,'true','true','true','true','dye_c2s2_c','dye'),
(4592,'Greater Dye of CON <Con+2 Dex-2>','false','dye',150,'stackable','liquid','none',-1,72000,0,'true','true','true','true','dye_c2c2_c','dye'),
(4593,'Greater Dye of DEX <Dex+2 Str-2>','false','dye',150,'stackable','liquid','none',-1,72000,0,'true','true','true','true','dye_d2s2_c','dye'),
(4594,'Greater Dye of DEX <Dex+2 Con-2>','false','dye',150,'stackable','liquid','none',-1,72000,0,'true','true','true','true','dye_d2c2_c','dye'),
(4595,'Greater Dye of INT <Int+2 Men-2>','false','dye',150,'stackable','liquid','none',-1,72000,0,'true','true','true','true','dye_i2m2_c','dye'),
(4596,'Greater Dye of INT <Int+2 Wit-2>','false','dye',150,'stackable','liquid','none',-1,72000,0,'true','true','true','true','dye_i2w2_c','dye'),
(4597,'Greater Dye of MEN <Men+2 Int-2>','false','dye',150,'stackable','liquid','none',-1,72000,0,'true','true','true','true','dye_m2i2_c','dye'),
(4598,'Greater Dye of MEN <Men+2 Wit-2>','false','dye',150,'stackable','liquid','none',-1,72000,0,'true','true','true','true','dye_m2w2_c','dye'),
(4599,'Greater Dye of WIT <Wit+2 Int-2>','false','dye',150,'stackable','liquid','none',-1,72000,0,'true','true','true','true','dye_w2i2_c','dye'),
(4600,'Greater Dye of WIT <Wit+2 Men-2>','false','dye',150,'stackable','liquid','none',-1,72000,0,'true','true','true','true','dye_w2m2_c','dye'),
(4601,'Greater Dye of STR <Str+3 Con-3>','false','dye',150,'stackable','liquid','none',-1,108000,0,'true','true','true','true','dye_s3c3_c','dye'),
(4602,'Greater Dye of STR <Str+3 Dex-3>','false','dye',150,'stackable','liquid','none',-1,108000,0,'true','true','true','true','dye_s3d3_c','dye'),
(4603,'Greater Dye of CON <Con+3 Str-3>','false','dye',150,'stackable','liquid','none',-1,108000,0,'true','true','true','true','dye_c3s3_c','dye'),
(4604,'Greater Dye of CON <Con+3 Dex-3>','false','dye',150,'stackable','liquid','none',-1,108000,0,'true','true','true','true','dye_c3c3_c','dye'),
(4605,'Greater Dye of DEX <Dex+3 Str-3>','false','dye',150,'stackable','liquid','none',-1,108000,0,'true','true','true','true','dye_d3s3_c','dye'),
(4606,'Greater Dye of DEX <Dex+3 Con-3>','false','dye',150,'stackable','liquid','none',-1,108000,0,'true','true','true','true','dye_d3c3_c','dye'),
(4607,'Greater Dye of INT <Int+3 Men-3>','false','dye',150,'stackable','liquid','none',-1,108000,0,'true','true','true','true','dye_i3m3_c','dye'),
(4608,'Greater Dye of INT <Int+3 Wit-3>','false','dye',150,'stackable','liquid','none',-1,108000,0,'true','true','true','true','dye_i3w3_c','dye'),
(4609,'Greater Dye of MEN <Men+3 Int-3>','false','dye',150,'stackable','liquid','none',-1,108000,0,'true','true','true','true','dye_m3i3_c','dye'),
(4610,'Greater Dye of MEN <Men+3 Wit-3>','false','dye',150,'stackable','liquid','none',-1,108000,0,'true','true','true','true','dye_m3w3_c','dye'),
(4611,'Greater Dye of WIT <Wit+3 Int-3>','false','dye',150,'stackable','liquid','none',-1,108000,0,'true','true','true','true','dye_w3i3_c','dye'),
(4612,'Greater Dye of WIT <Wit+3 Men-3>','false','dye',150,'stackable','liquid','none',-1,108000,0,'true','true','true','true','dye_w3m3_c','dye'),
(4613,'Greater Dye of STR <Str+4 Con-4>','false','dye',150,'stackable','liquid','none',-1,174000,0,'true','true','true','true','dye_s4c4_c','dye'),
(4614,'Greater Dye of STR <Str+4 Dex-4>','false','dye',150,'stackable','liquid','none',-1,174000,0,'true','true','true','true','dye_s4d4_c','dye'),
(4615,'Greater Dye of CON <Con+4 Str-4>','false','dye',150,'stackable','liquid','none',-1,174000,0,'true','true','true','true','dye_c4s4_c','dye'),
(4616,'Greater Dye of CON <Con+4 Dex-4>','false','dye',150,'stackable','liquid','none',-1,174000,0,'true','true','true','true','dye_c4c4_c','dye'),
(4617,'Greater Dye of DEX <Dex+4 Str-4>','false','dye',150,'stackable','liquid','none',-1,174000,0,'true','true','true','true','dye_d4s4_c','dye'),
(4618,'Greater Dye of DEX <Dex+4 Con-4>','false','dye',150,'stackable','liquid','none',-1,174000,0,'true','true','true','true','dye_d4c4_c','dye'),
(4619,'Greater Dye of INT <Int+4 Men-4>','false','dye',150,'stackable','liquid','none',-1,174000,0,'true','true','true','true','dye_i4m4_c','dye'),
(4620,'Greater Dye of INT <Int+4 Wit-4>','false','dye',150,'stackable','liquid','none',-1,174000,0,'true','true','true','true','dye_i4w4_c','dye'),
(4621,'Greater Dye of MEN <Men+4 Int-4>','false','dye',150,'stackable','liquid','none',-1,174000,0,'true','true','true','true','dye_m4i4_c','dye'),
(4622,'Greater Dye of MEN <Men+4 Wit-4>','false','dye',150,'stackable','liquid','none',-1,174000,0,'true','true','true','true','dye_m4w4_c','dye'),
(4623,'Greater Dye of WIT <Wit+4 Int-4>','false','dye',150,'stackable','liquid','none',-1,174000,0,'true','true','true','true','dye_w4i4_c','dye'),
(4624,'Greater Dye of WIT <Wit+4 Men-4>','false','dye',150,'stackable','liquid','none',-1,174000,0,'true','true','true','true','dye_w4m4_c','dye'),
(4625,'Dice (Heart)','false','none',0,'normal','steel','none',-1,500,0,'true','false','true','true','dice_heart','none'),
(4626,'Dice (Spade)','false','none',0,'normal','steel','none',-1,500,0,'true','false','true','true','dice_spade','none'),
(4627,'Dice (Clover)','false','none',0,'normal','steel','none',-1,500,0,'true','false','true','true','dice_clover','none'),
(4628,'Dice (Diamond)','false','none',0,'normal','steel','none',-1,500,0,'true','false','true','true','dice_diamond','none'),
(4629,'Red Soul Crystal','false','scroll',20,'normal','crystal','none',-1,0,0,'true','true','true','true','red_soul_crystal_0','scroll'),
(4630,'Red Soul Crystal - Stage 1','false','scroll',20,'normal','crystal','none',-1,0,0,'true','true','true','true','red_soul_crystal_1','scroll'),
(4631,'Red Soul Crystal - Stage 2','false','scroll',20,'normal','crystal','none',-1,0,0,'true','true','true','true','red_soul_crystal_2','scroll'),
(4632,'Red Soul Crystal - Stage 3','false','scroll',20,'normal','crystal','none',-1,0,0,'true','true','true','true','red_soul_crystal_3','scroll'),
(4633,'Red Soul Crystal - Stage 4','false','scroll',20,'normal','crystal','none',-1,0,0,'true','true','true','true','red_soul_crystal_4','scroll'),
(4634,'Red Soul Crystal - Stage 5','false','scroll',20,'normal','crystal','none',-1,0,0,'true','true','true','true','red_soul_crystal_5','scroll'),
(4635,'Red Soul Crystal - Stage 6','false','scroll',20,'normal','crystal','none',-1,0,0,'true','true','true','true','red_soul_crystal_6','scroll'),
(4636,'Red Soul Crystal - Stage 7','false','scroll',20,'normal','crystal','none',-1,0,0,'true','true','true','true','red_soul_crystal_7','scroll'),
(4637,'Red Soul Crystal - Stage 8','false','scroll',20,'normal','crystal','none',-1,0,0,'true','true','true','true','red_soul_crystal_8','scroll'),
(4638,'Red Soul Crystal - Stage 9','false','scroll',20,'normal','crystal','none',-1,0,0,'true','true','true','true','red_soul_crystal_9','scroll'),
(4639,'Red Soul Crystal - Stage 10','false','scroll',20,'normal','crystal','none',-1,0,0,'true','true','true','true','red_soul_crystal_10','scroll'),
(4640,'Green Soul Crystal','false','scroll',20,'normal','crystal','none',-1,0,0,'true','true','true','true','green_soul_crystal_0','scroll'),
(4641,'Green Soul Crystal - Stage 1','false','scroll',20,'normal','crystal','none',-1,0,0,'true','true','true','true','green_soul_crystal_1','scroll'),
(4642,'Green Soul Crystal - Stage 2','false','scroll',20,'normal','crystal','none',-1,0,0,'true','true','true','true','green_soul_crystal_2','scroll'),
(4643,'Green Soul Crystal - Stage 3','false','scroll',20,'normal','crystal','none',-1,0,0,'true','true','true','true','green_soul_crystal_3','scroll'),
(4644,'Green Soul Crystal - Stage 4','false','scroll',20,'normal','crystal','none',-1,0,0,'true','true','true','true','green_soul_crystal_4','scroll'),
(4645,'Green Soul Crystal - Stage 5','false','scroll',20,'normal','crystal','none',-1,0,0,'true','true','true','true','green_soul_crystal_5','scroll'),
(4646,'Green Soul Crystal - Stage 6','false','scroll',20,'normal','crystal','none',-1,0,0,'true','true','true','true','green_soul_crystal_6','scroll'),
(4647,'Green Soul Crystal - Stage 7','false','scroll',20,'normal','crystal','none',-1,0,0,'true','true','true','true','green_soul_crystal_7','scroll'),
(4648,'Green Soul Crystal - Stage 8','false','scroll',20,'normal','crystal','none',-1,0,0,'true','true','true','true','green_soul_crystal_8','scroll'),
(4649,'Green Soul Crystal - Stage 9','false','scroll',20,'normal','crystal','none',-1,0,0,'true','true','true','true','green_soul_crystal_9','scroll'),
(4650,'Green Soul Crystal - Stage 10','false','scroll',20,'normal','crystal','none',-1,0,0,'true','true','true','true','green_soul_crystal_10','scroll'),
(4651,'Blue Soul Crystal','false','scroll',20,'normal','crystal','none',-1,0,0,'true','true','true','true','blue_soul_crystal_0','scroll'),
(4652,'Blue Soul Crystal - Stage 1','false','scroll',20,'normal','crystal','none',-1,0,0,'true','true','true','true','blue_soul_crystal_1','scroll'),
(4653,'Blue Soul Crystal - Stage 2','false','scroll',20,'normal','crystal','none',-1,0,0,'true','true','true','true','blue_soul_crystal_2','scroll'),
(4654,'Blue Soul Crystal - Stage 3','false','scroll',20,'normal','crystal','none',-1,0,0,'true','true','true','true','blue_soul_crystal_3','scroll'),
(4655,'Blue Soul Crystal - Stage 4','false','scroll',20,'normal','crystal','none',-1,0,0,'true','true','true','true','blue_soul_crystal_4','scroll'),
(4656,'Blue Soul Crystal - Stage 5','false','scroll',20,'normal','crystal','none',-1,0,0,'true','true','true','true','blue_soul_crystal_5','scroll'),
(4657,'Blue Soul Crystal - Stage 6','false','scroll',20,'normal','crystal','none',-1,0,0,'true','true','true','true','blue_soul_crystal_6','scroll'),
(4658,'Blue Soul Crystal - Stage 7','false','scroll',20,'normal','crystal','none',-1,0,0,'true','true','true','true','blue_soul_crystal_7','scroll'),
(4659,'Blue Soul Crystal - Stage 8','false','scroll',20,'normal','crystal','none',-1,0,0,'true','true','true','true','blue_soul_crystal_8','scroll'),
(4660,'Blue Soul Crystal - Stage 9','false','scroll',20,'normal','crystal','none',-1,0,0,'true','true','true','true','blue_soul_crystal_9','scroll'),
(4661,'Blue Soul Crystal - Stage 10','false','scroll',20,'normal','crystal','none',-1,0,0,'true','true','true','true','blue_soul_crystal_10','scroll'),
(4662,'Broken Red Soul Crystal','false','scroll',20,'normal','crystal','none',-1,0,0,'true','true','true','true','red_soul_crystal_x','scroll'),
(4663,'Broken Green Soul Crystal','false','scroll',20,'normal','crystal','none',-1,0,0,'true','true','true','true','green_soul_crystal_x','scroll'),
(4664,'Broken Blue Soul Crystal','false','scroll',20,'normal','crystal','none',-1,0,0,'true','true','true','true','blue_soul_crystal_x','scroll'),
(4666,'Reiria\'s Soul Orb','false','quest',0,'stackable','steel','none',-1,0,0,'false','false','true','false','q_reirias_soulorb','none'),
(4667,'Kernon\'s Infernium Scepter','false','quest',0,'stackable','steel','none',-1,0,0,'false','false','true','false','q_infernium_scepter_1','none'),
(4668,'Golkonda\'s Infernium Scepter','false','quest',0,'stackable','steel','none',-1,0,0,'false','false','true','false','q_infernium_scepter_2','none'),
(4669,'Hallate\'s Infernium Scepter','false','quest',0,'stackable','steel','none',-1,0,0,'false','false','true','false','q_infernium_scepter_3','none'),
(4670,'Maestro Reorin\'s Hammer','false','quest',0,'stackable','steel','none',-1,0,0,'false','false','true','false','q_maestro_reorins_hammer','none'),
(4671,'Maestro Reorin\'s Mold','false','quest',0,'stackable','steel','none',-1,0,0,'false','false','true','false','q_maestro_reorins_mold','none'),
(4672,'Infernium Varnish','false','quest',0,'stackable','steel','none',-1,0,0,'false','false','true','false','q_infernium_varnish','none'),
(4673,'Red Pipette Knife','false','quest',0,'stackable','steel','none',-1,0,0,'false','false','true','false','q_red_pipette_knife','none'),
(4674,'Medal of Honor','false','quest',0,'stackable','steel','none',-1,0,0,'false','false','true','false','medal_of_honor','none'),
(4675,'Medal of Friendship','false','quest',0,'stackable','steel','none',-1,0,0,'false','false','true','false','medal_of_friendship','none'),
(4676,'Medal of Victory','false','quest',0,'stackable','steel','none',-1,0,0,'false','false','true','false','medal_of_victory','none'),
(4677,'Potion of Critical Escape','false','potion',120,'stackable','paper','none',-1,0,0,'true','true','true','true','potion_of_critical_escape','potion'),
(4678,'Decrease Haste Potion','false','potion',180,'stackable','liquid','none',-1,0,0,'true','true','true','true','decrease_hate_potion','potion'),
(4679,'Bless of Eva','false','potion',180,'stackable','liquid','none',-1,500,0,'true','true','true','true','bless_of_eva','potion'),
(4680,'Potion of Revenge','false','potion',180,'stackable','liquid','none',-1,0,0,'true','true','true','true','rsk.damage_shield_potion','potion'),
(4906,'Spellbook: Solar Spark','false','spellbook',120,'stackable','paper','none',-1,1250,0,'true','true','true','true','sb_solar_spark1','none'),
(4907,'Spellbook: Solar Flare','false','spellbook',120,'stackable','paper','none',-1,900,0,'true','true','true','true','sb_solar_flare1','none'),
(4908,'Spellbook: Shadow Spark','false','spellbook',120,'stackable','paper','none',-1,1250,0,'true','true','true','true','sb_shadow_spark1','none'),
(4909,'Spellbook: Shadow Flare','false','spellbook',120,'stackable','paper','none',-1,900,0,'true','true','true','true','sb_shadow_flare1','none'),
(4910,'Spellbook: Vampiric Rage','false','spellbook',120,'stackable','paper','none',-1,1800,0,'true','true','true','true','sb_vampiric_rage1','none'),
(4911,'Spellbook: Curse Disease','false','spellbook',120,'stackable','paper','none',-1,6750,0,'true','true','true','true','sb_curse_disease1','none'),
(4912,'Spellbook: Benediction','false','spellbook',120,'stackable','paper','none',-1,8200,0,'true','true','true','true','sb_benediction','none'),
(4913,'Spellbook: Word of Fear','false','spellbook',120,'stackable','paper','none',-1,3850,0,'true','true','true','true','sb_word_of_fear1','none'),
(4914,'Spellbook: Serenade of Eva','false','spellbook',120,'stackable','paper','none',-1,3850,0,'true','true','true','true','sb_serenade_of_eva1','none'),
(4915,'Blueprint: Summon Wild Hog Cannon','false','spellbook',120,'stackable','paper','none',-1,6750,0,'true','true','true','true','sb_summon_wild_hog_cannon','none'),
(4916,'Spellbook: Energy Bolt','false','spellbook',120,'stackable','paper','none',-1,800,0,'true','true','true','true','sb_energy_bolt1','none'),
(4917,'Spellbook: Aura Bolt','false','spellbook',120,'stackable','paper','none',-1,900,0,'true','true','true','true','sb_aura_bolt1','none'),
(4918,'Spellbook: Summon Kai the Cat','false','spellbook',120,'stackable','paper','none',-1,3200,0,'true','true','true','true','sb_summon_kai_the_cat1','none'),
(4919,'Spellbook: Summon Merrow the Unicorn','false','spellbook',120,'stackable','paper','none',-1,3200,0,'true','true','true','true','sb_summon_unicorn_merrow1','none'),
(4920,'Spellbook: Summon Soulless','false','spellbook',120,'stackable','paper','none',-1,3200,0,'true','true','true','true','sb_summon_soulless1','none'),
(4921,'Blueprint: Summon Big Boom','false','spellbook',120,'stackable','paper','none',-1,6750,0,'true','true','true','true','sb_summon_bigboom1','none'),
(4922,'Spellbook: Summon Binding Cubic','false','spellbook',120,'stackable','paper','none',-1,3200,0,'true','true','true','true','sb_summon_binding_cubic1','none'),
(4923,'Spellbook: Summon Aqua Cubic','false','spellbook',120,'stackable','paper','none',-1,3200,0,'true','true','true','true','sb_summon_aqua_cubic1','none'),
(4924,'Spellbook: Summon Spark Cubic','false','spellbook',120,'stackable','paper','none',-1,3200,0,'true','true','true','true','sb_summon_spark_cubic1','none'),
(4925,'Amulet: Pa''agrio\'s Haste','false','spellbook',120,'stackable','paper','none',-1,6750,0,'true','true','true','true','sb_speed_of_paagrio1','none'),
(4926,'Amulet: Soul Guard','false','spellbook',120,'stackable','paper','none',-1,3850,0,'true','true','true','true','sb_soul_guard1','none'),
(4927,'Amulet: Chant of Revenge','false','spellbook',120,'stackable','paper','none',-1,7700,0,'true','true','true','true','sb_chant_of_revenge1','none'),
(4928,'Spellbook: Seed of Fire','false','spellbook',120,'stackable','paper','none',-1,7200,0,'true','true','true','true','sb_seed_of_fire','none'),
(4929,'Spellbook: Seed of Water','false','spellbook',120,'stackable','paper','none',-1,7200,0,'true','true','true','true','sb_seed_of_water','none'),
(4930,'Spellbook: Seed of Wind','false','spellbook',120,'stackable','paper','none',-1,7200,0,'true','true','true','true','sb_seed_of_wind','none'),
(4931,'Spellbook: Aura Symphony','false','spellbook',120,'stackable','paper','none',-1,7200,0,'true','true','true','true','sb_aura_symphony1','none'),
(4932,'Spellbook: Inferno','false','spellbook',120,'stackable','paper','none',-1,7200,0,'true','true','true','true','sb_inferno1','none'),
(4933,'Spellbook: Blizzard','false','spellbook',120,'stackable','paper','none',-1,7200,0,'true','true','true','true','sb_blizzard1','none'),
(4934,'Spellbook: Demon Wind','false','spellbook',120,'stackable','paper','none',-1,7200,0,'true','true','true','true','sb_demon_wind1','none'),
(4935,'Spellbook: Elemental Symphony','false','spellbook',120,'stackable','paper','none',-1,0,0,'true','true','true','true','sb_elemental_symphony','none'),
(4936,'Recipe: Avadon Shield (60%)','false','recipe',30,'stackable','liquid','none',-1,10900,0,'true','true','true','true','rp_avadon_shield_i','recipe'),
(4937,'Recipe: Adamantite Earrings (70%)','false','recipe',30,'stackable','liquid','none',-1,12120,0,'true','true','true','true','rp_adamantite_earing_i','recipe'),
(4938,'Recipe: Adamantite Ring (70%)','false','recipe',30,'stackable','liquid','none',-1,8080,0,'true','true','true','true','rp_adamantite_ring_i','recipe'),
(4939,'Recipe: Adamantite Necklace (70%)','false','recipe',30,'stackable','liquid','none',-1,16160,0,'true','true','true','true','rp_adamantite_necklace_i','recipe'),
(4940,'Recipe: Zubei\'s Breastplate (60%)','false','recipe',30,'stackable','liquid','none',-1,41600,0,'true','true','true','true','rp_shrnoen\'s_breastplate_i','recipe'),
(4941,'Recipe: Zubei\'s Gaiters (60%)','false','recipe',30,'stackable','liquid','none',-1,26000,0,'true','true','true','true','rp_shrnoen\'s_gaiters_i','recipe'),
(4942,'Recipe: Boots of Silence (60%)','false','recipe',30,'stackable','liquid','none',-1,0,0,'true','true','true','true','rp_silent_boots_i','recipe'),
(4943,'Recipe: Guardian\'s Boots (60%)','false','recipe',30,'stackable','liquid','none',-1,0,0,'true','true','true','true','rp_guardian\'s_boots_i','recipe'),
(4944,'Recipe: Avadon Breastplate (60%)','false','recipe',30,'stackable','liquid','none',-1,41600,0,'true','true','true','true','rp_avadon_breastplate_i','recipe'),
(4945,'Recipe: Avadon Gaiters (60%)','false','recipe',30,'stackable','liquid','none',-1,26000,0,'true','true','true','true','rp_avadon_gaiters_i','recipe'),
(4946,'Recipe: Zubei\'s Leather Shirt (60%)','false','recipe',30,'stackable','liquid','none',-1,31200,0,'true','true','true','true','rp_shrnoen\'s_leather_shirts_i','recipe'),
(4947,'Recipe: Zubei\'s Leather Gaiters (60%)','false','recipe',30,'stackable','liquid','none',-1,19460,0,'true','true','true','true','rp_shrnoen\'s_leather_gaiters_i','recipe'),
(4948,'Recipe: Avadon Leather Armor (60%)','false','recipe',30,'stackable','liquid','none',-1,45600,0,'true','true','true','true','rp_avadon_leather_mail_i','recipe'),
(4949,'Recipe: Tunic of Zubei (60%)','false','recipe',30,'stackable','liquid','none',-1,31200,0,'true','true','true','true','rp_tunic_of_shrnoen_i','recipe'),
(4950,'Recipe: Stockings of Zubei (60%)','false','recipe',30,'stackable','liquid','none',-1,19460,0,'true','true','true','true','rp_hose_of_shrnoen_i','recipe'),
(4951,'Recipe: Avadon Robe (60%)','false','recipe',30,'stackable','liquid','none',-1,45600,0,'true','true','true','true','rp_avadon_robe_i','recipe'),
(4952,'Recipe: Avadon Circlet (60%)','false','recipe',30,'stackable','liquid','none',-1,15560,0,'true','true','true','true','rp_avadon_circlet_i','recipe'),
(4953,'Recipe: Avadon Gloves (60%)','false','recipe',30,'stackable','liquid','none',-1,10380,0,'true','true','true','true','rp_avadon_gloves_i','recipe'),
(4954,'Recipe: Chain Gloves of Silence (60%)','false','recipe',30,'stackable','liquid','none',-1,0,0,'true','true','true','true','rp_silent_chain_gloves_i','recipe'),
(4955,'Recipe: Guardian\'s Gloves (60%)','false','recipe',30,'stackable','liquid','none',-1,0,0,'true','true','true','true','rp_guardian\'s_gloves_i','recipe'),
(4956,'Recipe: Gloves of Blessing (60%)','false','recipe',30,'stackable','liquid','none',-1,10380,0,'true','true','true','true','rp_gloves_of_blessing_i','recipe'),
(4957,'Recipe: Boots of Blessing (60%)','false','recipe',30,'stackable','liquid','none',-1,0,0,'true','true','true','true','rp_boots_of_blessing_i','recipe'),
(4958,'Recipe: Zubei\'s Boots (60%)','false','recipe',30,'stackable','liquid','none',-1,10380,0,'true','true','true','true','rp_shrnoen\'s_boots_i','recipe'),
(4959,'Recipe: Avadon Boots (60%)','false','recipe',30,'stackable','liquid','none',-1,10380,0,'true','true','true','true','rp_avadon_boots_i','recipe'),
(4960,'Recipe: Zubei\'s Gauntlets (60%)','false','recipe',30,'stackable','liquid','none',-1,10380,0,'true','true','true','true','rp_shrnoen\'s_gauntlet_i','recipe'),
(4961,'Recipe: Zubei\'s Shield (60%)','false','recipe',30,'stackable','liquid','none',-1,10900,0,'true','true','true','true','rp_shrnoen\'s_shield_i','recipe'),
(4962,'Recipe: Zubei\'s Helmet (60%)','false','recipe',30,'stackable','liquid','none',-1,15560,0,'true','true','true','true','rp_shrnoen\'s_helmet_i','recipe'),
(4963,'Recipe: Great Sword (60%)','false','recipe',30,'stackable','liquid','none',-1,173600,0,'true','true','true','true','rp_great_sword_i','recipe'),
(4964,'Recipe: Heavy War Axe (60%)','false','recipe',30,'stackable','liquid','none',-1,173600,0,'true','true','true','true','rp_heavy_war_axe_i','recipe'),
(4965,'Recipe: Sprite\'s Staff (60%)','false','recipe',30,'stackable','liquid','none',-1,173600,0,'true','true','true','true','rp_sprite\'s_staff_i','recipe'),
(4966,'Recipe: Keshanberk (60%)','false','recipe',30,'stackable','liquid','none',-1,173600,0,'true','true','true','true','rp_kshanberk_i','recipe'),
(4967,'Recipe: Sword of Valhalla (60%)','false','recipe',30,'stackable','liquid','none',-1,173600,0,'true','true','true','true','rp_sword_of_valhalla_i','recipe'),
(4968,'Recipe: Kris (60%)','false','recipe',30,'stackable','liquid','none',-1,173600,0,'true','true','true','true','rp_kris_i','recipe'),
(4969,'Recipe: Hell Knife (60%)','false','recipe',30,'stackable','liquid','none',-1,173600,0,'true','true','true','true','rp_hell_knife_i','recipe'),
(4970,'Recipe: Arthro Nail (60%)','false','recipe',30,'stackable','liquid','none',-1,173600,0,'true','true','true','true','rp_arthro_nail_i','recipe'),
(4971,'Recipe: Dark Elven Long Bow (60%)','false','recipe',30,'stackable','liquid','none',-1,173600,0,'true','true','true','true','rp_dark_elven_long_bow_i','recipe'),
(4972,'Recipe: Great Axe (60%)','false','recipe',30,'stackable','liquid','none',-1,0,0,'true','true','true','true','rp_great_axe_i','recipe'),
(4973,'Recipe: Earring of Black Ore (70%)','false','recipe',30,'stackable','liquid','none',-1,18480,0,'true','true','true','true','rp_earing_of_black_ore_i','recipe'),
(4974,'Recipe: Ring of Black Ore (70%)','false','recipe',30,'stackable','liquid','none',-1,12320,0,'true','true','true','true','rp_ring_of_black_ore_i','recipe'),
(4975,'Recipe: Necklace of Black Ore (70%)','false','recipe',30,'stackable','liquid','none',-1,24600,0,'true','true','true','true','rp_necklace_of_black_ore_i','recipe'),
(4976,'Recipe: Implosion Boots (60%)','false','recipe',30,'stackable','liquid','none',-1,0,0,'true','true','true','true','rp_implosion_boots_i','recipe'),
(4977,'Recipe: Paradia Boots (60%)','false','recipe',30,'stackable','liquid','none',-1,0,0,'true','true','true','true','rp_paradia_boots_i','recipe'),
(4978,'Recipe: Elemental Boots (60%)','false','recipe',30,'stackable','liquid','none',-1,16080,0,'true','true','true','true','rp_elemental_boots_i','recipe'),
(4979,'Recipe: Boots of Grace (60%)','false','recipe',30,'stackable','liquid','none',-1,0,0,'true','true','true','true','rp_boots_of_grace_i','recipe'),
(4980,'Recipe: Doom Shield (60%)','false','recipe',30,'stackable','liquid','none',-1,16900,0,'true','true','true','true','rp_doom_shield_i','recipe'),
(4981,'Recipe: Blue Wolf Breastplate (60%)','false','recipe',30,'stackable','liquid','none',-1,64400,0,'true','true','true','true','rp_blue_wolve\'s_breastplate_i','recipe'),
(4982,'Recipe: Blue Wolf Gaiters (60%)','false','recipe',30,'stackable','liquid','none',-1,40200,0,'true','true','true','true','rp_blue_wolve\'s_gaiters_i','recipe'),
(4983,'Recipe: Doom Plate Armor (60%)','false','recipe',30,'stackable','liquid','none',-1,94200,0,'true','true','true','true','rp_doom_plate_armor_i','recipe'),
(4984,'Recipe: Blue Wolf Leather Armor (60%)','false','recipe',30,'stackable','liquid','none',-1,70600,0,'true','true','true','true','rp_blue_wolve\'s_leather_mail_i','recipe'),
(4985,'Recipe: Leather Armor of Doom (60%)','false','recipe',30,'stackable','liquid','none',-1,70600,0,'true','true','true','true','rp_leather_mail_of_doom_i','recipe'),
(4986,'Recipe: Blue Wolf Tunic (60%)','false','recipe',30,'stackable','liquid','none',-1,48200,0,'true','true','true','true','rp_blue_wolve\'s_tunic_i','recipe'),
(4987,'Recipe: Tunic of Doom (60%)','false','recipe',30,'stackable','liquid','none',-1,48200,0,'true','true','true','true','rp_tunic_of_doom_i','recipe'),
(4988,'Recipe: Blue Wolf Stockings (60%)','false','recipe',30,'stackable','liquid','none',-1,30200,0,'true','true','true','true','rp_blue_wolve\'s_hose_i','recipe'),
(4989,'Recipe: Stockings of Doom (60%)','false','recipe',30,'stackable','liquid','none',-1,30200,0,'true','true','true','true','rp_hose_of_doom_i','recipe'),
(4990,'Recipe: Blue Wolf Helmet (60%)','false','recipe',30,'stackable','liquid','none',-1,24200,0,'true','true','true','true','rp_blue_wolve\'s_helmet_i','recipe'),
(4991,'Recipe: Doom Helmet (60%)','false','recipe',30,'stackable','liquid','none',-1,24200,0,'true','true','true','true','rp_doom_helmet_i','recipe'),
(4992,'Recipe: Blue Wolf Boots (60%)','false','recipe',30,'stackable','liquid','none',-1,16080,0,'true','true','true','true','rp_blue_wolve\'s_boots_i','recipe'),
(4993,'Recipe: Doom Gloves (60%)','false','recipe',30,'stackable','liquid','none',-1,16080,0,'true','true','true','true','rp_doom_gloves_i','recipe'),
(4994,'Recipe: Elemental Gloves (60%)','false','recipe',30,'stackable','liquid','none',-1,0,0,'true','true','true','true','rp_elemental_gloves_i','recipe'),
(4995,'Recipe: Gloves of Grace (60%)','false','recipe',30,'stackable','liquid','none',-1,16080,0,'true','true','true','true','rp_gloves_of_grace_i','recipe'),
(4996,'Recipe: Implosion Gauntlets (60%)','false','recipe',30,'stackable','liquid','none',-1,16080,0,'true','true','true','true','rp_implosion_gauntlet_i','recipe'),
(4997,'Recipe: Paradia Gloves (60%)','false','recipe',30,'stackable','liquid','none',-1,0,0,'true','true','true','true','rp_paradia_gloves_i','recipe'),
(4998,'Recipe: Blue Wolf Gloves (60%)','false','recipe',30,'stackable','liquid','none',-1,16080,0,'true','true','true','true','rp_blue_wolve\'s_gloves_i','recipe'),
(4999,'Recipe: Doom Boots (60%)','false','recipe',30,'stackable','liquid','none',-1,16080,0,'true','true','true','true','rp_doom_boots_i','recipe'),
(5000,'Recipe: Sword of Damascus (60%)','false','recipe',30,'stackable','liquid','none',-1,262000,0,'true','true','true','true','rp_sword_of_damascus_i','recipe'),
(5001,'Recipe: Lance (60%)','false','recipe',30,'stackable','liquid','none',-1,262000,0,'true','true','true','true','rp_lancia_i','recipe'),
(5002,'Recipe: Deadman\'s Glory (60%)','false','recipe',30,'stackable','liquid','none',-1,262000,0,'true','true','true','true','rp_deadman\'s_glory_i','recipe'),
(5003,'Recipe: Art of Battle Axe (60%)','false','recipe',30,'stackable','liquid','none',-1,262000,0,'true','true','true','true','rp_art_of_battle_axe_i','recipe'),
(5004,'Recipe: Staff of Evil Spirits (60%)','false','recipe',30,'stackable','liquid','none',-1,262000,0,'true','true','true','true','rp_staff_of_evil_sprit_i','recipe'),
(5005,'Recipe: Demon Dagger (60%)','false','recipe',30,'stackable','liquid','none',-1,262000,0,'true','true','true','true','rp_demon\'s_sword_i','recipe'),
(5006,'Recipe: Bellion Cestus (60%)','false','recipe',30,'stackable','liquid','none',-1,262000,0,'true','true','true','true','rp_bellion_cestus_i','recipe'),
(5007,'Recipe: Bow of Peril (60%)','false','recipe',30,'stackable','liquid','none',-1,262000,0,'true','true','true','true','rp_hazard_bow_i','recipe'),
(5008,'Recipe: Pata (60%)','false','recipe',30,'stackable','liquid','none',-1,0,0,'true','true','true','true','rp_pata_i','recipe'),
(5009,'Trophy of Alliance','false','none',0,'normal','steel','none',-1,0,0,'false','false','true','false','trophy_of_alliance','none'),
(5010,'Echo Crystal - Theme of Victory','false','none',10,'stackable','paper','none',-1,0,0,'true','true','true','true','echo_crystal_victory','none'),
(5011,'Star of Destiny','false','quest',0,'stackable','steel','none',-1,0,0,'false','false','false','false','q_star_of_destiny','none'),
(5012,'Leikan\'s Letter','false','quest',0,'stackable','paper','none',-1,0,0,'true','true','true','true','leikans_letter','none'),
(5013,'Spellbook: Elemental Assault','false','spellbook',120,'stackable','paper','none',-1,7200,0,'true','true','true','true','sb_elemental_symphony_h1','none'),
(5014,'Spellbook: Elemental Symphony','false','spellbook',120,'stackable','paper','none',-1,7200,0,'true','true','true','true','sb_elemental_symphony_e1','none'),
(5015,'Spellbook: Elemental Storm','false','spellbook',120,'stackable','paper','none',-1,7200,0,'true','true','true','true','sb_elemental_symphony_d1','none'),
(5016,'Seed: Dark Coda','false','seed',1,'stackable','paper','none',-1,5,0,'true','true','true','true','C5Item','none'),
(5017,'Seed: Red Coda','false','seed',1,'stackable','paper','none',-1,5,0,'true','true','true','true','C5Item','none'),
(5018,'Seed: Chilly Coda','false','seed',1,'stackable','paper','none',-1,5,0,'true','true','true','true','C5Item','none'),
(5019,'Seed: Blue Coda','false','seed',1,'stackable','paper','none',-1,10,0,'true','true','true','true','C5Item','none'),
(5020,'Seed: Golden Coda','false','seed',1,'stackable','paper','none',-1,20,0,'true','true','true','true','C5Item','none'),
(5021,'Seed: Lute Coda','false','seed',1,'stackable','paper','none',-1,30,0,'true','true','true','true','C5Item','none'),
(5022,'Seed: Desert Coda','false','seed',1,'stackable','paper','none',-1,20,0,'true','true','true','true','C5Item','none'),
(5023,'Seed: Blue Cobol','false','seed',1,'stackable','paper','none',-1,50,0,'true','true','true','true','C5Item','none'),
(5024,'Seed: Blue Coda','false','seed',1,'stackable','paper','none',-1,10,0,'true','true','true','true','C5Item','none'),
(5025,'Seed: Golden Coda','false','seed',1,'stackable','paper','none',-1,20,0,'true','true','true','true','C5Item','none'),
(5026,'Seed: Lute Coda','false','seed',1,'stackable','paper','none',-1,30,0,'true','true','true','true','C5Item','none'),
(5027,'Seed: Desert Coda','false','seed',1,'stackable','paper','none',-1,20,0,'true','true','true','true','C5Item','none'),
(5028,'Seed: Red Cobol','false','seed',1,'stackable','paper','none',-1,20,0,'true','true','true','true','C5Item','none'),
(5029,'Seed: Chilly Cobol','false','seed',1,'stackable','paper','none',-1,25,0,'true','true','true','true','C5Item','none'),
(5030,'Seed: Thorn Cobol','false','seed',1,'stackable','paper','none',-1,50,0,'true','true','true','true','C5Item','none'),
(5031,'Seed: Golden Cobol','false','seed',1,'stackable','paper','none',-1,50,0,'true','true','true','true','C5Item','none'),
(5032,'Seed: Great Cobol','false','seed',1,'stackable','paper','none',-1,50,0,'true','true','true','true','C5Item','none'),
(5033,'Seed: Red Cobol','false','seed',1,'stackable','paper','none',-1,20,0,'true','true','true','true','C5Item','none'),
(5034,'Seed: Chilly Cobol','false','seed',1,'stackable','paper','none',-1,25,0,'true','true','true','true','C5Item','none'),
(5035,'Seed: Blue Cobol','false','seed',1,'stackable','paper','none',-1,50,0,'true','true','true','true','C5Item','none'),
(5036,'Seed: Thorn Cobol','false','seed',1,'stackable','paper','none',-1,50,0,'true','true','true','true','C5Item','none'),
(5037,'Seed: Golden Cobol','false','seed',1,'stackable','paper','none',-1,50,0,'true','true','true','true','C5Item','none'),
(5038,'Seed: Great Cobol','false','seed',1,'stackable','paper','none',-1,50,0,'true','true','true','true','C5Item','none'),
(5039,'Seed: Red Codran','false','seed',1,'stackable','paper','none',-1,40,0,'true','true','true','true','C5Item','none'),
(5040,'Seed: Twin Codran','false','seed',1,'stackable','paper','none',-1,50,0,'true','true','true','true','C5Item','none'),
(5041,'Seed: Desert Codran','false','seed',1,'stackable','paper','none',-1,100,0,'true','true','true','true','C5Item','none'),
(5042,'Seed: Dark Coda','false','seed',1,'stackable','paper','none',-1,5,0,'true','true','true','true','C5Item','none'),
(5043,'Seed: Red Coda','false','seed',1,'stackable','paper','none',-1,5,0,'true','true','true','true','C5Item','none'),
(5044,'Seed: Blue Coda','false','seed',1,'stackable','paper','none',-1,10,0,'true','true','true','true','C5Item','none'),
(5045,'Seed: Red Cobol','false','seed',1,'stackable','paper','none',-1,20,0,'true','true','true','true','C5Item','none'),
(5046,'Seed: Chilly Cobol','false','seed',1,'stackable','paper','none',-1,25,0,'true','true','true','true','C5Item','none'),
(5047,'Seed: Blue Cobol','false','seed',1,'stackable','paper','none',-1,50,0,'true','true','true','true','C5Item','none'),
(5048,'Seed: Thorn Cobol','false','seed',1,'stackable','paper','none',-1,50,0,'true','true','true','true','C5Item','none'),
(5049,'Seed: Sea Codran','false','seed',1,'stackable','paper','none',-1,50,0,'true','true','true','true','C5Item','none'),
(5050,'Seed: Chilly Codran','false','seed',1,'stackable','paper','none',-1,40,0,'true','true','true','true','C5Item','none'),
(5051,'Seed: Blue Codran','false','seed',1,'stackable','paper','none',-1,50,0,'true','true','true','true','C5Item','none'),
(5052,'Seed: Twin Codran','false','seed',1,'stackable','paper','none',-1,50,0,'true','true','true','true','C5Item','none'),
(5053,'Seed: Thorn Cobol','false','seed',1,'stackable','paper','none',-1,50,0,'true','true','true','true','C5Item','none'),
(5054,'Seed: Golden Cobol','false','seed',1,'stackable','paper','none',-1,50,0,'true','true','true','true','C5Item','none'),
(5055,'Seed: Great Cobol','false','seed',1,'stackable','paper','none',-1,50,0,'true','true','true','true','C5Item','none'),
(5056,'Seed: Red Codran','false','seed',1,'stackable','paper','none',-1,40,0,'true','true','true','true','C5Item','none'),
(5057,'Seed: Chilly Codran','false','seed',1,'stackable','paper','none',-1,40,0,'true','true','true','true','C5Item','none'),
(5058,'Seed: Blue Codran','false','seed',1,'stackable','paper','none',-1,50,0,'true','true','true','true','C5Item','none'),
(5059,'Seed: Twin Codran','false','seed',1,'stackable','paper','none',-1,50,0,'true','true','true','true','C5Item','none'),
(5060,'Seed: Great Codran','false','seed',1,'stackable','paper','none',-1,75,0,'true','true','true','true','C5Item','none'),
(5061,'Seed: Desert Codran','false','seed',1,'stackable','paper','none',-1,100,0,'true','true','true','true','C5Item','none'),
(5062,'Trash','false','none',20,'stackable','paper','none',-1,0,0,'true','true','true','true','__golden_coda_seed_5','seed'),
(5063,'Trash','false','none',20,'stackable','paper','none',-1,0,0,'true','true','true','true','__golden_cobol_seed_5','seed'),
(5064,'Trash','false','none',20,'stackable','paper','none',-1,0,0,'true','true','true','true','__desert_codran_seed_5','seed'),
(5065,'Chilly Coda','false','none',2,'stackable','paper','none',-1,50,0,'true','true','true','true','C5Item','none'),
(5066,'Burning Coda','false','none',2,'stackable','paper','none',-1,0,0,'true','true','true','true','burning_coda','seed'),
(5067,'Blue Coda','false','none',2,'stackable','paper','none',-1,100,0,'true','true','true','true','C5Item','none'),
(5068,'Red Coda','false','none',2,'stackable','paper','none',-1,50,0,'true','true','true','true','C5Item','none'),
(5069,'Golden Coda','false','none',2,'stackable','paper','none',-1,200,0,'true','true','true','true','C5Item','none'),
(5070,'Desert Coda','false','none',2,'stackable','paper','none',-1,200,0,'true','true','true','true','C5Item','none'),
(5071,'Lute Coda','false','none',2,'stackable','paper','none',-1,300,0,'true','true','true','true','C5Item','none'),
(5072,'Twin Coda','false','none',2,'stackable','paper','none',-1,0,0,'true','true','true','true','C5Item','none'),
(5073,'Dark Coda','false','none',2,'stackable','paper','none',-1,50,0,'true','true','true','true','C5Item','none'),
(5074,'Shining Coda','false','none',2,'stackable','paper','none',-1,0,0,'true','true','true','true','shining_coda','seed'),
(5075,'Chilly Cobol','false','none',2,'stackable','paper','none',-1,250,0,'true','true','true','true','C5Item','none'),
(5076,'Burning Cobol','false','none',2,'stackable','paper','none',-1,0,0,'true','true','true','true','burning_cobol','seed'),
(5077,'Blue Cobol','false','none',2,'stackable','paper','none',-1,500,0,'true','true','true','true','C5Item','none'),
(5078,'Red Cobol','false','none',2,'stackable','paper','none',-1,200,0,'true','true','true','true','C5Item','none'),
(5079,'Golden Cobol','false','none',2,'stackable','paper','none',-1,500,0,'true','true','true','true','C5Item','none'),
(5080,'Desert Cobol','false','none',2,'stackable','paper','none',-1,0,0,'true','true','true','true','desert_cobol','seed'),
(5081,'Sea Cobol','false','none',2,'stackable','paper','none',-1,0,0,'true','true','true','true','sea_cobol','seed'),
(5082,'Thorn Cobol','false','none',2,'stackable','paper','none',-1,500,0,'true','true','true','true','C5Item','none'),
(5083,'Dapple Cobol','false','none',2,'stackable','paper','none',-1,0,0,'true','true','true','true','dapple_cobol','seed'),
(5084,'Great Cobol','false','none',2,'stackable','paper','none',-1,500,0,'true','true','true','true','C5Item','none'),
(5085,'Chilly Codran','false','none',2,'stackable','paper','none',-1,400,0,'true','true','true','true','C5Item','none'),
(5086,'Burning Codran','false','none',2,'stackable','paper','none',-1,0,0,'true','true','true','true','burning_codran','seed'),
(5087,'Blue Codran','false','none',2,'stackable','paper','none',-1,500,0,'true','true','true','true','C5Item','none'),
(5088,'Red Codran','false','none',2,'stackable','paper','none',-1,400,0,'true','true','true','true','C5Item','none'),
(5089,'Dapple Codran','false','none',2,'stackable','paper','none',-1,0,0,'true','true','true','true','dapple_codran','seed'),
(5090,'Desert Codran','false','none',2,'stackable','paper','none',-1,1000,0,'true','true','true','true','C5Item','none'),
(5091,'Sea Codran','false','none',2,'stackable','paper','none',-1,500,0,'true','true','true','true','C5Item','none'),
(5092,'Twin Codran','false','none',2,'stackable','paper','none',-1,500,0,'true','true','true','true','C5Item','none'),
(5093,'Thorn Codran','false','none',2,'stackable','paper','none',-1,0,0,'true','true','true','true','bur_codran','seed'),
(5094,'Great Codran','false','none',2,'stackable','paper','none',-1,750,0,'true','true','true','true','C5Item','none'),
(5095,'Mature Chilly Coda','false','none',1,'stackable','paper','none',-1,0,0,'true','true','true','true','C5Item','none'),
(5096,'Mature Burning Coda','false','none',1,'stackable','paper','none',-1,0,0,'true','true','true','true','mature_burning_coda','seed'),
(5097,'Mature Blue Coda','false','none',1,'stackable','paper','none',-1,0,0,'true','true','true','true','C5Item','none'),
(5098,'Mature Red Coda','false','none',1,'stackable','paper','none',-1,0,0,'true','true','true','true','C5Item','none'),
(5099,'Mature Golden Coda','false','none',1,'stackable','paper','none',-1,0,0,'true','true','true','true','C5Item','none'),
(5100,'Mature Desert Coda','false','none',1,'stackable','paper','none',-1,0,0,'true','true','true','true','C5Item','none'),
(5101,'Mature Lute Coda','false','none',1,'stackable','paper','none',-1,0,0,'true','true','true','true','C5Item','none'),
(5102,'Mature Twin Coda','false','none',1,'stackable','paper','none',-1,0,0,'true','true','true','true','mature_twin_coda','seed'),
(5103,'Mature Dark Coda','false','none',1,'stackable','paper','none',-1,0,0,'true','true','true','true','C5Item','none'),
(5104,'Mature Shining Coda','false','none',1,'stackable','paper','none',-1,0,0,'true','true','true','true','mature_shining_coda','seed'),
(5105,'Mature Chilly Cobol','false','none',1,'stackable','paper','none',-1,0,0,'true','true','true','true','C5Item','none'),
(5106,'Mature Burning Cobol','false','none',1,'stackable','paper','none',-1,0,0,'true','true','true','true','mature_burning_cobol','seed'),
(5107,'Mature Blue Cobol','false','none',1,'stackable','paper','none',-1,0,0,'true','true','true','true','C5Item','none'),
(5108,'Mature Red Cobol','false','none',1,'stackable','paper','none',-1,0,0,'true','true','true','true','C5Item','none'),
(5109,'Mature Golden Cobol','false','none',1,'stackable','paper','none',-1,0,0,'true','true','true','true','C5Item','none'),
(5110,'Mature Desert Cobol','false','none',1,'stackable','paper','none',-1,0,0,'true','true','true','true','mature_desert_cobol','seed'),
(5111,'Mature Sea Cobol','false','none',1,'stackable','paper','none',-1,0,0,'true','true','true','true','mature_sea_cobol','seed'),
(5112,'Mature Thorn Cobol','false','none',1,'stackable','paper','none',-1,0,0,'true','true','true','true','C5Item','none'),
(5113,'Mature Dapple Cobol','false','none',1,'stackable','paper','none',-1,0,0,'true','true','true','true','mature_dapple_cobol','seed'),
(5114,'Mature Great Cobol','false','none',1,'stackable','paper','none',-1,0,0,'true','true','true','true','C5Item','none'),
(5115,'Mature Chilly Codran','false','none',1,'stackable','paper','none',-1,0,0,'true','true','true','true','C5Item','none'),
(5116,'Mature Burning Codran','false','none',1,'stackable','paper','none',-1,0,0,'true','true','true','true','mature_burning_codran','seed'),
(5117,'Mature Blue Codran','false','none',1,'stackable','paper','none',-1,0,0,'true','true','true','true','C5Item','none'),
(5118,'Mature Red Codran','false','none',1,'stackable','paper','none',-1,0,0,'true','true','true','true','C5Item','none'),
(5119,'Mature Dapple Codran','false','none',1,'stackable','paper','none',-1,0,0,'true','true','true','true','mature_dapple_codran','seed'),
(5120,'Mature Desert Codran','false','none',1,'stackable','paper','none',-1,0,0,'true','true','true','true','C5Item','none'),
(5121,'Mature Sea Codran','false','none',1,'stackable','paper','none',-1,0,0,'true','true','true','true','C5Item','none'),
(5122,'Mature Twin Codran','false','none',1,'stackable','paper','none',-1,0,0,'true','true','true','true','C5Item','none'),
(5123,'Mature Thorn Codran','false','none',1,'stackable','paper','none',-1,0,0,'true','true','true','true','mature_bur_codran','seed'),
(5124,'Mature Great Codran','false','none',1,'stackable','paper','none',-1,0,0,'true','true','true','true','C5Item','none'),
(5125,'Harvester','false','harvest',20,'normal','steel','none',-1,500,0,'true','true','true','true','reaping_machine','harvest'),
(5126,'Dualsword Craft Stamp','false','none',20,'stackable','paper','none',-1,10000,0,'true','true','true','true','dualsword_craft_stamp','none'),
(5134,'Compressed Package of Soulshots: No Grade','false','shot',600,'normal','steel','none',-1,2300,0,'true','true','true','true','comp_soulshot_none','none'),
(5135,'Compressed Package of Soulshots: D-grade','false','shot',450,'normal','steel','none',-1,3300,0,'true','true','true','true','comp_soulshot_d','none'),
(5136,'Compressed Package of Soulshots: C-grade','false','shot',450,'normal','steel','none',-1,4950,0,'true','true','true','true','comp_soulshot_c','none'),
(5137,'Compressed Package of Soulshots: B-grade','false','shot',300,'normal','steel','none',-1,16500,0,'true','true','true','true','comp_soulshot_b','none'),
(5138,'Compressed Package of Soulshots: A-grade','false','shot',300,'normal','steel','none',-1,26400,0,'true','true','true','true','comp_soulshot_a','none'),
(5139,'Compressed Package of Soulshots: S-grade','false','shot',300,'normal','steel','none',-1,33000,0,'true','true','true','true','comp_soulshot_s','none'),
(5140,'Compressed Package of Spiritshots: No Grade','false','shot',750,'normal','steel','none',-1,4950,0,'true','true','true','true','comp_spiritshot_none','none'),
(5141,'Compressed Package of Spiritshots: D-grade','false','shot',750,'normal','steel','none',-1,5940,0,'true','true','true','true','comp_spiritshot_d','none'),
(5142,'Compressed Package of Spiritshots: C-grade','false','shot',450,'normal','steel','none',-1,11550,0,'true','true','true','true','comp_spiritshot_c','none'),
(5143,'Compressed Package of Spiritshots: B-grade','false','shot',450,'normal','steel','none',-1,33000,0,'true','true','true','true','comp_spiritshot_b','none'),
(5144,'Compressed Package of Spiritshots: A-grade','false','shot',300,'normal','steel','none',-1,39600,0,'true','true','true','true','comp_spiritshot_a','none'),
(5145,'Compressed Package of Spiritshots: S-grade','false','shot',300,'normal','steel','none',-1,49500,0,'true','true','true','true','comp_spiritshot_s','none'),
(5146,'Compressed Package of Blessed Spiritshots: No Grade','false','shot',750,'normal','steel','none',-1,11550,0,'true','true','true','true','comp_bspiritshot_none','none'),
(5147,'Compressed Package of Blessed Spiritshots: D-grade','false','shot',750,'normal','steel','none',-1,14850,0,'true','true','true','true','comp_bspiritshot_d','none'),
(5148,'Compressed Package of Blessed Spiritshots: C-grade','false','shot',450,'normal','steel','none',-1,29700,0,'true','true','true','true','comp_bspiritshot_c','none'),
(5149,'Compressed Package of Blessed Spiritshots: B-grade','false','shot',450,'normal','steel','none',-1,80850,0,'true','true','true','true','comp_bspiritshot_b','none'),
(5150,'Compressed Package of Blessed Spiritshots: A-grade','false','shot',300,'normal','steel','none',-1,95700,0,'true','true','true','true','comp_bspiritshot_a','none'),
(5151,'Compressed Package of Blessed Spiritshots: S-grade','false','shot',300,'normal','steel','none',-1,115500,0,'true','true','true','true','comp_bspiritshot_s','none'),
(5152,'Magic Compressor','false','none',10,'normal','steel','none',-1,0,0,'true','true','true','true','magic_compressor','none'),
(5153,'Recipe: Soulshot (D) Compressed Package (100%)','false','recipe',30,'stackable','liquid','none',-1,5000,0,'true','true','true','true','rp_comp_soulshot_d','recipe'),
(5154,'Recipe: Soulshot (C) Compressed Package (100%)','false','recipe',30,'stackable','liquid','none',-1,25000,0,'true','true','true','true','rp_comp_soulshot_c','recipe'),
(5155,'Recipe: Soulshot (B) Compressed Package (100%)','false','recipe',30,'stackable','liquid','none',-1,100000,0,'true','true','true','true','rp_comp_soulshot_b','recipe'),
(5156,'Recipe: Soulshot (A) Compressed Package (100%)','false','recipe',30,'stackable','liquid','none',-1,150000,0,'true','true','true','true','rp_comp_soulshot_a','recipe'),
(5157,'Recipe: Soulshot (S) Compressed Package (100%)','false','recipe',30,'stackable','liquid','none',-1,250000,0,'true','true','true','true','rp_comp_soulshot_s','recipe'),
(5158,'Recipe: Spiritshot (D) Compressed Package (100%)','false','recipe',30,'stackable','liquid','none',-1,5000,0,'true','true','true','true','rp_comp_spiritshot_d','recipe'),
(5159,'Recipe: Spiritshot (C) Compressed Package (100%)','false','recipe',30,'stackable','liquid','none',-1,25000,0,'true','true','true','true','rp_comp_spiritshot_c','recipe'),
(5160,'Recipe: Spiritshot (B) Compressed Package (100%)','false','recipe',30,'stackable','liquid','none',-1,100000,0,'true','true','true','true','rp_comp_spiritshot_b','recipe'),
(5161,'Recipe: Spiritshot (A) Compressed Package (100%)','false','recipe',30,'stackable','liquid','none',-1,150000,0,'true','true','true','true','rp_comp_spiritshot_a','recipe'),
(5162,'Recipe: Spiritshot (S) Compressed Package (100%)','false','recipe',30,'stackable','liquid','none',-1,250000,0,'true','true','true','true','rp_comp_spiritshot_s','recipe'),
(5163,'Recipe: Blessed Spiritshot (D) Compressed Package (100%)','false','recipe',30,'stackable','liquid','none',-1,30000,0,'true','true','true','true','rp_comp_bspiritshot_d','recipe'),
(5164,'Recipe: Blessed Spiritshot (C) Compressed Package (100%)','false','recipe',30,'stackable','liquid','none',-1,60000,0,'true','true','true','true','rp_comp_bspiritshot_c','recipe'),
(5165,'Recipe: Blessed Spiritshot (B) Compressed Package (100%)','false','recipe',30,'stackable','liquid','none',-1,100000,0,'true','true','true','true','rp_comp_bspiritshot_b','recipe'),
(5166,'Recipe: Blessed Spiritshot (A) Compressed Package (100%)','false','recipe',30,'stackable','liquid','none',-1,180000,0,'true','true','true','true','rp_comp_bspiritshot_a','recipe'),
(5167,'Recipe: Blessed Spiritshot (S) Compressed Package (100%)','false','recipe',30,'stackable','liquid','none',-1,290000,0,'true','true','true','true','rp_comp_bspiritshot_s','recipe'),
(5168,'Food for Strider','false','none',10,'stackable','liquid','none',-1,200,0,'true','true','true','true','food_for_strider','none'),
(5169,'Deluxe Food for Strider','false','none',10,'stackable','liquid','none',-1,300,0,'true','true','true','true','deluxe_food_for_strider','none'),
(5192,'Rope of Magic: D-Grade','false','none',2,'stackable','paper','none',-1,100,0,'true','true','true','true','rope_of_magic_d','none'),
(5193,'Rope of Magic: C-Grade','false','none',2,'stackable','paper','none',-1,150,0,'true','true','true','true','rope_of_magic_c','none'),
(5194,'Rope of Magic: B-Grade','false','none',2,'stackable','paper','none',-1,250,0,'true','true','true','true','rope_of_magic_b','none'),
(5195,'Rope of Magic: A-Grade','false','none',2,'stackable','paper','none',-1,400,0,'true','true','true','true','rope_of_magic_a','none'),
(5196,'Rope of Magic: S Grade','false','none',2,'stackable','paper','none',-1,1500,0,'true','true','true','true','rope_of_magic_s','none'),
(5197,'Chest Key - Grade 8','false','none',10,'stackable','liquid','none',-1,1200,0,'true','true','true','true','key_of_box0','none'),
(5198,'Chest Key - Grade 7','false','none',10,'stackable','liquid','none',-1,1200,0,'true','true','true','true','key_of_box1','none'),
(5199,'Chest Key - Grade 6','false','none',10,'stackable','liquid','none',-1,1200,0,'true','true','true','true','key_of_box2','none'),
(5200,'Chest Key - Grade 5','false','none',10,'stackable','liquid','none',-1,1200,0,'true','true','true','true','key_of_box3','none'),
(5201,'Chest Key - Grade 4','false','none',10,'stackable','liquid','none',-1,1200,0,'true','true','true','true','key_of_box4','none'),
(5202,'Chest Key - Grade 3','false','none',10,'stackable','liquid','none',-1,1200,0,'true','true','true','true','key_of_box5','none'),
(5203,'Chest Key - Grade 2','false','none',10,'stackable','liquid','none',-1,1200,0,'true','true','true','true','key_of_box6','none'),
(5204,'Chest Key - Grade 1','false','none',10,'stackable','liquid','none',-1,1200,0,'true','true','true','true','key_of_box7','none'),
(5205,'Mercenary Posting Ticket (Sword/Stationary)','false','castle_guard',0,'stackable','paper','none',-1,0,0,'true','true','true','true','mticket_innadrile_sword_fix','castle_guard'),
(5206,'Mercenary Posting Ticket (Spear/Stationary)','false','castle_guard',0,'stackable','paper','none',-1,0,0,'true','true','true','true','mticket_innadrile_pole_fix','castle_guard'),
(5207,'Mercenary Posting Ticket (Bow/Stationary)','false','castle_guard',0,'stackable','paper','none',-1,0,0,'true','true','true','true','mticket_innadrile_bow_fix','castle_guard'),
(5208,'Mercenary Posting Ticket (Cleric/Stationary)','false','castle_guard',0,'stackable','paper','none',-1,0,0,'true','true','true','true','mticket_innadrile_cleric_fix','castle_guard'),
(5209,'Mercenary Posting Ticket (Wizard/Stationary)','false','castle_guard',0,'stackable','paper','none',-1,0,0,'true','true','true','true','mticket_innadrile_wizard_fix','castle_guard'),
(5210,'Mercenary Posting Ticket (Sword/Mobile)','false','castle_guard',0,'stackable','paper','none',-1,0,0,'true','true','true','true','mticket_innadrile_sword_move','castle_guard'),
(5211,'Mercenary Posting Ticket (Spear/Mobile)','false','castle_guard',0,'stackable','paper','none',-1,0,0,'true','true','true','true','mticket_innadrile_pole_move','castle_guard'),
(5212,'Mercenary Posting Ticket (Bow/Mobile)','false','castle_guard',0,'stackable','paper','none',-1,0,0,'true','true','true','true','mticket_innadrile_bow_move','castle_guard'),
(5213,'Mercenary Posting Ticket (Cleric/Mobile)','false','castle_guard',0,'stackable','paper','none',-1,0,0,'true','true','true','true','mticket_innadrile_cleric_move','castle_guard'),
(5214,'Mercenary Posting Ticket (Wizard/Mobile)','false','castle_guard',0,'stackable','paper','none',-1,0,0,'true','true','true','true','mticket_innadrile_wizard_move','castle_guard'),
(5215,'Mercenary Posting Ticket (Teleporter1)','false','castle_guard',0,'stackable','paper','none',-1,0,0,'true','true','true','true','mticket_innadrile_teleporter1','castle_guard'),
(5218,'Mercenary Posting Ticket (Teleporter2)','false','castle_guard',0,'stackable','paper','none',-1,0,0,'true','true','true','true','mticket_innadrile_teleporter2','castle_guard'),
(5219,'Mercenary Posting Ticket (Teleporter3)','false','castle_guard',0,'stackable','paper','none',-1,0,0,'true','true','true','true','mticket_innadrile_teleporter3','castle_guard'),
(5220,'Metal Hardener','false','material',2,'stackable','liquid','none',-1,5000,0,'true','true','true','true','metal_hardener','material'),
(5221,'Seed: Chilly Cobol','false','seed',1,'stackable','paper','none',-1,25,0,'true','true','true','true','C5Item','none'),
(5222,'Seed: Blue Cobol','false','seed',1,'stackable','paper','none',-1,50,0,'true','true','true','true','C5Item','none'),
(5223,'Seed: Thorn Cobol','false','seed',1,'stackable','paper','none',-1,50,0,'true','true','true','true','C5Item','none'),
(5224,'Seed: Golden Cobol','false','seed',1,'stackable','paper','none',-1,50,0,'true','true','true','true','C5Item','none'),
(5225,'Seed: Great Cobol','false','seed',1,'stackable','paper','none',-1,50,0,'true','true','true','true','C5Item','none'),
(5226,'Seed: Red Codran','false','seed',1,'stackable','paper','none',-1,40,0,'true','true','true','true','C5Item','none'),
(5227,'Seed: Sea Codran','false','seed',1,'stackable','paper','none',-1,50,0,'true','true','true','true','C5Item','none'),
(5228,'Trash','false','none',20,'stackable','paper','none',-1,0,0,'true','true','true','true','__sea_codran_seed_6','seed'),
(5229,'Trash','false','none',20,'stackable','paper','none',-1,0,0,'true','true','true','true','__desert_codran_seed_6','seed'),
(5230,'Recipe: Mithril Arrow (100%)','false','recipe',30,'stackable','paper','none',-1,80000,0,'true','true','true','true','rp_mithril_arrow','recipe'),
(5231,'Recipe: Metal Hardener (100%)','false','recipe',30,'stackable','paper','none',-1,2800,0,'true','true','true','true','rp_metal_hardener','recipe'),
(5232,'White Fabric','false','quest',0,'stackable','cloth','none',-1,0,0,'false','false','true','false','q0348_white_fabric_a','none'),
(5234,'Mystery Potion','false','potion',50,'stackable','liquid','none',-1,12000,0,'true','true','true','true','Mystery Potion','potion'),
(5235,'Facelifting Potion - A','false','potion',50,'stackable','liquid','none',-1,24000,0,'true','true','true','true','Facelifting Potion - A','potion'),
(5236,'Facelifting Potion - B','false','potion',50,'stackable','liquid','none',-1,24000,0,'true','true','true','true','Facelifting Potion - B','potion'),
(5237,'Facelifting Potion - C','false','potion',50,'stackable','liquid','none',-1,24000,0,'true','true','true','true','Facelifting Potion - C','potion'),
(5238,'Dye Potion - A','false','potion',50,'stackable','liquid','none',-1,24000,0,'true','true','true','true','Dye Potion - A','potion'),
(5239,'Dye Potion - B','false','potion',50,'stackable','liquid','none',-1,24000,0,'true','true','true','true','Dye Potion - B','potion'),
(5240,'Dye Potion - C','false','potion',50,'stackable','liquid','none',-1,24000,0,'true','true','true','true','Dye Potion - C','potion'),
(5241,'Dye Potion - D','false','potion',50,'stackable','liquid','none',-1,24000,0,'true','true','true','true','Dye Potion - D','potion'),
(5242,'Hair Style Change Potion - A','false','potion',50,'stackable','liquid','none',-1,24000,0,'true','true','true','true','Hair Style Change Potion - A','potion'),
(5243,'Hair Style Change Potion - B','false','potion',50,'stackable','liquid','none',-1,24000,0,'true','true','true','true','Hair Style Change Potion - B','potion'),
(5244,'Hair Style Change Potion - C','false','potion',50,'stackable','liquid','none',-1,24000,0,'true','true','true','true','Hair Style Change Potion - C','potion'),
(5245,'Hair Style Change Potion - D','false','potion',50,'stackable','liquid','none',-1,24000,0,'true','true','true','true','Hair Style Change Potion - D','potion'),
(5246,'Hair Style Change Potion - E','false','potion',50,'stackable','liquid','none',-1,24000,0,'true','true','true','true','Hair Style Change Potion - E','potion'),
(5247,'Hair Style Change Potion - F','false','potion',50,'stackable','liquid','none',-1,24000,0,'true','true','true','true','Hair Style Change Potion - F','potion'),
(5248,'Hair Style Change Potion - G','false','potion',50,'stackable','liquid','none',-1,24000,0,'true','true','true','true','Hair Style Change Potion - G','potion'),
(5249,'Commemorative Item: First Anniversary of Lineage II Service','false','pet_collar',0,'normal','cloth','none',-1,0,0,'false','false','false','false','event_the_first_anniversary','none'),
(5250,'Greater Compressed Package of Soulshots: No-grade','false','shot',600,'normal','steel','none',-1,7700,0,'true','true','true','true','adv_comp_soulshot_none','none'),
(5251,'Greater Compressed Package of Soulshots: D-grade','false','shot',450,'normal','steel','none',-1,11000,0,'true','true','true','true','adv_comp_soulshot_d','none'),
(5252,'Greater Compressed Package of Soulshots: C-grade','false','shot',450,'normal','steel','none',-1,16500,0,'true','true','true','true','adv_comp_soulshot_c','none'),
(5253,'Greater Compressed Package of Soulshots: B-grade','false','shot',300,'normal','steel','none',-1,55000,0,'true','true','true','true','adv_comp_soulshot_b','none'),
(5254,'Greater Compressed Package of Soulshots: A-grade','false','shot',300,'normal','steel','none',-1,88000,0,'true','true','true','true','adv_comp_soulshot_a','none'),
(5255,'Greater Compressed Package of Soulshots: S-grade','false','shot',300,'normal','steel','none',-1,120000,0,'true','true','true','true','adv_comp_soulshot_s','none'),
(5256,'Greater Compressed Package of Spiritshots: No-grade','false','shot',750,'normal','steel','none',-1,16500,0,'true','true','true','true','adv_comp_spiritshot_none','none'),
(5257,'Greater Compressed Package of Spiritshots: D-grade','false','shot',750,'normal','steel','none',-1,19800,0,'true','true','true','true','adv_comp_spiritshot_d','none'),
(5258,'Greater Compressed Package of Spiritshots: C-grade','false','shot',450,'normal','steel','none',-1,38500,0,'true','true','true','true','adv_comp_spiritshot_c','none'),
(5259,'Greater Compressed Package of Spiritshots: B-grade','false','shot',450,'normal','steel','none',-1,110000,0,'true','true','true','true','adv_comp_spiritshot_b','none'),
(5260,'Greater Compressed Package of Spiritshots: A-grade','false','shot',300,'normal','steel','none',-1,132000,0,'true','true','true','true','adv_comp_spiritshot_a','none'),
(5261,'Greater Compressed Package of Spiritshots: S-grade','false','shot',300,'normal','steel','none',-1,180000,0,'true','true','true','true','adv_comp_spiritshot_s','none'),
(5262,'Greater Compressed Package of Blessed Spiritshots: No-grade','false','shot',750,'normal','steel','none',-1,38500,0,'true','true','true','true','adv_comp_bspiritshot_none','none'),
(5263,'Greater Compressed Package of Blessed Spiritshots: D-grade','false','shot',750,'normal','steel','none',-1,49500,0,'true','true','true','true','adv_comp_bspiritshot_d','none'),
(5264,'Greater Compressed Package of Blessed Spiritshots: C-grade','false','shot',450,'normal','steel','none',-1,99000,0,'true','true','true','true','adv_comp_bspiritshot_c','none'),
(5265,'Greater Compressed Package of Blessed Spiritshots: B-grade','false','shot',450,'normal','steel','none',-1,269500,0,'true','true','true','true','adv_comp_bspiritshot_b','none'),
(5266,'Greater Compressed Package of Blessed Spiritshots: A-grade','false','shot',300,'normal','steel','none',-1,319000,0,'true','true','true','true','adv_comp_bspiritshot_a','none'),
(5267,'Greater Compressed Package of Blessed Spiritshots: S-grade','false','shot',300,'normal','steel','none',-1,419000,0,'true','true','true','true','adv_comp_bspiritshot_s','none'),
(5268,'Recipe: Greater Soulshot (D) Compressed Package (100%)','false','recipe',30,'stackable','liquid','none',-1,5000,0,'true','true','true','true','rp_adv_comp_soulshot_d','recipe'),
(5269,'Recipe: Greater Soulshot (C) Compressed Package(100%)','false','recipe',30,'stackable','liquid','none',-1,60000,0,'true','true','true','true','rp_adv_comp_soulshot_c','recipe'),
(5270,'Recipe: Greater Soulshot (B) Compressed Package(100%)','false','recipe',30,'stackable','liquid','none',-1,100000,0,'true','true','true','true','rp_adv_comp_soulshot_b','recipe'),
(5271,'Recipe: Greater Soulshot (A) Compressed Package(100%)','false','recipe',30,'stackable','liquid','none',-1,150000,0,'true','true','true','true','rp_adv_comp_soulshot_a','recipe'),
(5272,'Recipe: Greater Soulshot (S) Compressed Package(100%)','false','recipe',30,'stackable','liquid','none',-1,250000,0,'true','true','true','true','rp_adv_comp_soulshot_s','recipe'),
(5273,'Recipe: Greater Spiritshot (D) Compressed Package(100%)','false','recipe',30,'stackable','liquid','none',-1,5000,0,'true','true','true','true','rp_adv_comp_spiritshot_d','recipe'),
(5274,'Recipe: Greater Spiritshot (C) Compressed Package(100%)','false','recipe',30,'stackable','liquid','none',-1,60000,0,'true','true','true','true','rp_adv_comp_spiritshot_c','recipe'),
(5275,'Recipe: Greater Spiritshot (B) Compressed Package(100%)','false','recipe',30,'stackable','liquid','none',-1,100000,0,'true','true','true','true','rp_adv_comp_spiritshot_b','recipe'),
(5276,'Recipe: Greater Spiritshot (A) Compressed Package(100%)','false','recipe',30,'stackable','liquid','none',-1,150000,0,'true','true','true','true','rp_adv_comp_spiritshot_a','recipe'),
(5277,'Recipe: Greater Spiritshot (S) Compressed Package(100%)','false','recipe',30,'stackable','liquid','none',-1,250000,0,'true','true','true','true','rp_adv_comp_spiritshot_s','recipe'),
(5278,'Recipe: Greater Blessed Spiritshot (D) Compressed Package(100%)','false','recipe',30,'stackable','liquid','none',-1,8000,0,'true','true','true','true','rp_adv_comp_bspiritshot_d','recipe'),
(5279,'Recipe: Greater Blessed Spiritshot (C) Compressed Package(100%)','false','recipe',30,'stackable','liquid','none',-1,80000,0,'true','true','true','true','rp_adv_comp_bspiritshot_c','recipe'),
(5280,'Recipe: Greater Blessed Spiritshot (B) Compressed Package(100%)','false','recipe',30,'stackable','liquid','none',-1,130000,0,'true','true','true','true','rp_adv_comp_bspiritshot_b','recipe'),
(5281,'Recipe: Greater Blessed Spiritshot (A) Compressed Package(100%)','false','recipe',30,'stackable','liquid','none',-1,170000,0,'true','true','true','true','rp_adv_comp_bspiritshot_a','recipe'),
(5282,'Recipe: Greater Blessed Spiritshot (S) Compressed Package(100%)','false','recipe',30,'stackable','liquid','none',-1,285000,0,'true','true','true','true','rp_adv_comp_bspiritshot_s','recipe'),
(5283,'Rice Cake','false','potion',0,'stackable','liquid','none',-1,0,0,'true','true','true','true','cake_mochi','potion'),
(5332,'Recipe: Sealed Dark Crystal Leather Armor(60%)','false','recipe',30,'stackable','liquid','none',-1,69400,0,'true','true','true','true','rp_sealed_dark_crystal_leather_mail_i','recipe'),
(5333,'Recipe: Sealed Dark Crystal Leather Armor(100%)','false','recipe',30,'stackable','liquid','none',-1,0,0,'true','true','true','true','rp_sealed_dark_crystal_leather_mail','recipe'),
(5334,'Recipe: Sealed Tallum Leather Armor(60%)','false','recipe',30,'stackable','liquid','none',-1,101600,0,'true','true','true','true','rp_sealed_tallum_leather_mail_i','recipe'),
(5335,'Recipe: Sealed Tallum Leather Armor(100%)','false','recipe',30,'stackable','liquid','none',-1,0,0,'true','true','true','true','rp_sealed_tallum_leather_mail','recipe'),
(5336,'Recipe: Sealed Leather Armor of Nightmare(60%)','false','recipe',30,'stackable','liquid','none',-1,154600,0,'true','true','true','true','rp_sealed_leather_mail_of_nightmare_i','recipe'),
(5337,'Recipe: Sealed Leather Armor of Nightmare(100%)','false','recipe',30,'stackable','liquid','none',-1,0,0,'true','true','true','true','rp_sealed_leather_mail_of_nightmare','recipe'),
(5338,'Recipe: Sealed Majestic Leather Armor(60%)','false','recipe',30,'stackable','liquid','none',-1,154600,0,'true','true','true','true','rp_sealed_majestic_leather_mail_i','recipe'),
(5339,'Recipe: Sealed Majestic Leather Armor(100%)','false','recipe',30,'stackable','liquid','none',-1,0,0,'true','true','true','true','rp_sealed_majestic_leather_mail','recipe'),
(5340,'Recipe: Sealed Dark Crystal Leggings(60%)','false','recipe',30,'stackable','liquid','none',-1,43400,0,'true','true','true','true','rp_sealed_legging_of_dark_crystal_i','recipe'),
(5341,'Recipe: Sealed Dark Crystal Leggings(100%)','false','recipe',30,'stackable','liquid','none',-1,0,0,'true','true','true','true','rp_sealed_legging_of_dark_crystal','recipe'),
(5342,'Recipe: Phoenix Earring(70%)','false','recipe',20,'stackable','paper','none',-1,0,0,'true','true','true','true','rp_phoenix\'s_earing_i','recipe'),
(5343,'Recipe: Phoenix Earring(100%)','false','recipe',20,'stackable','paper','none',-1,0,0,'true','true','true','true','rp_phoenix\'s_earing','recipe'),
(5344,'Recipe: Inferno Earring(70%)','false','recipe',20,'stackable','paper','none',-1,0,0,'true','true','true','true','rp_majestic_earing_i','recipe'),
(5345,'Recipe: Inferno Earring(70%)','false','recipe',20,'stackable','paper','none',-1,0,0,'true','true','true','true','rp_majestic_earing','recipe'),
(5346,'Recipe: Sealed Tallum Tunic(60%)','false','recipe',30,'stackable','liquid','none',-1,69400,0,'true','true','true','true','rp_sealed_tallum_tunic_i','recipe'),
(5347,'Recipe: Sealed Tallum Tunic(100%)','false','recipe',30,'stackable','liquid','none',-1,0,0,'true','true','true','true','rp_sealed_tallum_tunic','recipe'),
(5348,'Recipe: Sealed Dark Crystal Robe(60%)','false','recipe',30,'stackable','liquid','none',-1,101600,0,'true','true','true','true','rp_sealed_dark_crystal_robe_i','recipe'),
(5349,'Recipe: Sealed Dark Crystal Robe(100%)','false','recipe',30,'stackable','liquid','none',-1,0,0,'true','true','true','true','rp_sealed_dark_crystal_robe','recipe'),
(5350,'Recipe: Sealed Nightmare Robe(60%)','false','recipe',30,'stackable','liquid','none',-1,154600,0,'true','true','true','true','rp_sealed_robe_of_nightmare_i','recipe'),
(5351,'Recipe: Sealed Nightmare Robe(100%)','false','recipe',30,'stackable','liquid','none',-1,0,0,'true','true','true','true','rp_sealed_robe_of_nightmare','recipe'),
(5352,'Recipe: Sealed Majestic Robe(60%)','false','recipe',30,'stackable','liquid','none',-1,154600,0,'true','true','true','true','rp_sealed_majestic_robe_i','recipe'),
(5353,'Recipe: Sealed Majestic Robe(100%)','false','recipe',30,'stackable','liquid','none',-1,0,0,'true','true','true','true','rp_sealed_majestic_robe','recipe'),
(5354,'Recipe: Sealed Tallum Stockings(60%)','false','recipe',30,'stackable','liquid','none',-1,43400,0,'true','true','true','true','rp_sealed_tallum_hose_i','recipe'),
(5355,'Recipe: Sealed Tallum Stockings(100%)','false','recipe',30,'stackable','liquid','none',-1,0,0,'true','true','true','true','rp_sealed_tallum_hose','recipe'),
(5356,'Recipe: Phoenix Necklace(70%)','false','recipe',20,'stackable','paper','none',-1,0,0,'true','true','true','true','rp_phoenix\'s_necklace_i','recipe'),
(5357,'Recipe: Phoenix Necklace(100%)','false','recipe',20,'stackable','paper','none',-1,0,0,'true','true','true','true','rp_phoenix\'s_necklace','recipe'),
(5358,'Recipe: Inferno Necklace(70%)','false','recipe',20,'stackable','paper','none',-1,0,0,'true','true','true','true','rp_majestic_necklace_i','recipe'),
(5359,'Recipe: Inferno Necklace(100%)','false','recipe',20,'stackable','paper','none',-1,0,0,'true','true','true','true','rp_majestic_necklace','recipe'),
(5360,'Recipe: Phoenix Ring(70%)','false','recipe',20,'stackable','paper','none',-1,0,0,'true','true','true','true','rp_phoenix\'s_ring_i','recipe'),
(5361,'Recipe: Phoenix Ring(100%)','false','recipe',20,'stackable','paper','none',-1,0,0,'true','true','true','true','rp_phoenix\'s_ring','recipe'),
(5362,'Recipe: Inferno Ring(70%)','false','recipe',20,'stackable','paper','none',-1,0,0,'true','true','true','true','rp_majestic_ring_i','recipe'),
(5363,'Recipe: Inferno Ring(100%)','false','recipe',20,'stackable','paper','none',-1,0,0,'true','true','true','true','rp_majestic_ring','recipe'),
(5364,'Recipe: Sealed Dark Crystal Shield(60%)','false','recipe',30,'stackable','liquid','none',-1,24400,0,'true','true','true','true','rp_sealed_dark_crystal_shield_i','recipe'),
(5365,'Recipe: Sealed Dark Crystal Shield(100%)','false','recipe',30,'stackable','liquid','none',-1,0,0,'true','true','true','true','rp_sealed_dark_crystal_shield','recipe'),
(5366,'Recipe: Sealed Shield of Nightmare(60%)','false','recipe',30,'stackable','liquid','none',-1,37000,0,'true','true','true','true','rp_sealed_shield_of_nightmare_i','recipe'),
(5367,'Recipe: Sealed Shield of Nightmare(100%)','false','recipe',30,'stackable','liquid','none',-1,0,0,'true','true','true','true','rp_sealed_shield_of_nightmare','recipe'),
(5368,'Recipe: Sealed Dark Crystal Boots(60%)','false','recipe',30,'stackable','liquid','none',-1,23200,0,'true','true','true','true','rp_sealed_dark_crystal_boots_i','recipe'),
(5369,'Recipe: Sealed Dark Crystal Boots(100%)','false','recipe',30,'stackable','liquid','none',-1,0,0,'true','true','true','true','rp_sealed_dark_crystal_boots','recipe'),
(5370,'Recipe: Sealed Tallum Boots(60%)','false','recipe',30,'stackable','liquid','none',-1,23200,0,'true','true','true','true','rp_sealed_tallum_boots_i','recipe'),
(5371,'Recipe: Sealed Tallum Boots(100%)','false','recipe',30,'stackable','liquid','none',-1,0,0,'true','true','true','true','rp_sealed_tallum_boots','recipe'),
(5372,'Recipe: Sealed Boots of The Underworld(60%)','false','recipe',30,'stackable','liquid','none',-1,0,0,'true','true','true','true','rp_sealed_boots_of_underworld_i','recipe'),
(5373,'Recipe: Sealed Boots of The Underworld(100%)','false','recipe',30,'stackable','liquid','none',-1,0,0,'true','true','true','true','rp_sealed_boots_of_underworld','recipe'),
(5374,'Recipe: Sealed Gust Boots(60%)','false','recipe',30,'stackable','liquid','none',-1,0,0,'true','true','true','true','rp_sealed_gust_boots_i','recipe'),
(5375,'Recipe: Sealed Gust Boots(100%)','false','recipe',30,'stackable','liquid','none',-1,0,0,'true','true','true','true','rp_sealed_gust_boots','recipe'),
(5376,'Recipe: Sealed Red Flame Boots(60%)','false','recipe',30,'stackable','liquid','none',-1,0,0,'true','true','true','true','rp_sealed_red_flame_boots_i','recipe'),
(5377,'Recipe: Sealed Red Flame Boots(100%)','false','recipe',30,'stackable','liquid','none',-1,0,0,'true','true','true','true','rp_sealed_red_flame_boots','recipe'),
(5378,'Recipe: Sealed Phoenix Boots(60%)','false','recipe',30,'stackable','liquid','none',-1,0,0,'true','true','true','true','rp_sealed_phoenix\'s_boots_i','recipe'),
(5379,'Recipe: Sealed Phoenix Boots(100%)','false','recipe',30,'stackable','liquid','none',-1,0,0,'true','true','true','true','rp_sealed_phoenix\'s_boots','recipe'),
(5380,'Recipe: Sealed Boots of Nightmare(60%)','false','recipe',30,'stackable','liquid','none',-1,35200,0,'true','true','true','true','rp_sealed_boots_of_nightmare_i','recipe'),
(5381,'Recipe: Sealed Boots of Nightmare(100%)','false','recipe',30,'stackable','liquid','none',-1,0,0,'true','true','true','true','rp_sealed_boots_of_nightmare','recipe'),
(5382,'Recipe: Sealed Majestic Boots(60%)','false','recipe',30,'stackable','liquid','none',-1,35200,0,'true','true','true','true','rp_sealed_magestic_boots_i','recipe'),
(5383,'Recipe: Sealed Majestic Boots(100%)','false','recipe',30,'stackable','liquid','none',-1,0,0,'true','true','true','true','rp_sealed_magestic_boots','recipe'),
(5384,'Recipe: Sealed Dark Legion Boots(60%)','false','recipe',30,'stackable','liquid','none',-1,0,0,'true','true','true','true','rp_sealed_dark_legion_boots_i','recipe'),
(5385,'Recipe: Sealed Dark Legion Boots(100%)','false','recipe',30,'stackable','liquid','none',-1,0,0,'true','true','true','true','rp_sealed_dark_legion_boots','recipe'),
(5386,'Recipe: Sealed Boots of Phantom(60%)','false','recipe',30,'stackable','liquid','none',-1,0,0,'true','true','true','true','rp_sealed_boots_of_phantom_i','recipe'),
(5387,'Recipe: Sealed Boots of Phantom(100%)','false','recipe',30,'stackable','liquid','none',-1,0,0,'true','true','true','true','rp_sealed_boots_of_phantom','recipe'),
(5388,'Recipe: Sealed Cerberus Boots(60%)','false','recipe',30,'stackable','liquid','none',-1,0,0,'true','true','true','true','rp_sealed_cerberus\'s_boots_i','recipe'),
(5389,'Recipe: Sealed Cerberus Boots(100%)','false','recipe',30,'stackable','liquid','none',-1,0,0,'true','true','true','true','rp_sealed_cerberus\'s_boots','recipe'),
(5390,'Recipe: Sealed Dasparion\'s Boots Boots(60%)','false','recipe',30,'stackable','liquid','none',-1,0,0,'true','true','true','true','rp_sealed_dasparion\'s_boots_i','recipe'),
(5391,'Recipe: Sealed Dasparion\'s Boots Boots(100%)','false','recipe',30,'stackable','liquid','none',-1,0,0,'true','true','true','true','rp_sealed_dasparion\'s_boots','recipe'),
(5392,'Recipe: Sealed Dark Crystal Gloves(60%)','false','recipe',30,'stackable','liquid','none',-1,23200,0,'true','true','true','true','rp_sealed_dark_crystal_gloves_i','recipe'),
(5393,'Recipe: Sealed Dark Crystal Gloves(100%)','false','recipe',30,'stackable','liquid','none',-1,0,0,'true','true','true','true','rp_sealed_dark_crystal_gloves','recipe'),
(5394,'Recipe: Sealed Tallum Gloves(60%)','false','recipe',30,'stackable','liquid','none',-1,23200,0,'true','true','true','true','rp_sealed_tallum_gloves_i','recipe'),
(5395,'Recipe: Sealed Tallum Gloves(100%)','false','recipe',30,'stackable','liquid','none',-1,0,0,'true','true','true','true','rp_sealed_tallum_gloves','recipe'),
(5396,'Recipe: Sealed Gloves of The Underworld(60%)','false','recipe',30,'stackable','liquid','none',-1,0,0,'true','true','true','true','rp_sealed_gloves_of_underworld_i','recipe'),
(5397,'Recipe: Sealed Gloves of The Underworld(100%)','false','recipe',30,'stackable','liquid','none',-1,0,0,'true','true','true','true','rp_sealed_gloves_of_underworld','recipe'),
(5398,'Recipe: Sealed Gust Bracer(60%)','false','recipe',30,'stackable','liquid','none',-1,0,0,'true','true','true','true','rp_sealed_gust_bracer_i','recipe'),
(5399,'Recipe: Sealed Gust Bracer(100%)','false','recipe',30,'stackable','liquid','none',-1,0,0,'true','true','true','true','rp_sealed_gust_bracer','recipe'),
(5400,'Recipe: Sealed Gloves of Black Ore(60%)','false','recipe',30,'stackable','liquid','none',-1,0,0,'true','true','true','true','rp_sealed_gloves_of_black_ore_i','recipe'),
(5401,'Recipe: Sealed Gloves of Black Ore(100%)','false','recipe',30,'stackable','liquid','none',-1,0,0,'true','true','true','true','rp_sealed_gloves_of_black_ore','recipe'),
(5402,'Recipe: Sealed Phoenix Gloves(60%)','false','recipe',30,'stackable','liquid','none',-1,0,0,'true','true','true','true','rp_sealed_phoenix\'s_gloves_i','recipe'),
(5403,'Recipe: Sealed Phoenix Gloves(100%)','false','recipe',30,'stackable','liquid','none',-1,0,0,'true','true','true','true','rp_sealed_phoenix\'s_gloves','recipe'),
(5404,'Recipe: Sealed Gauntlets of Nightmare(60%)','false','recipe',30,'stackable','liquid','none',-1,35200,0,'true','true','true','true','rp_sealed_gloves_of_nightmare_i','recipe'),
(5405,'Recipe: Sealed Gauntlets of Nightmare(100%)','false','recipe',30,'stackable','liquid','none',-1,0,0,'true','true','true','true','rp_sealed_gloves_of_nightmare','recipe'),
(5406,'Recipe: Sealed Majestic Gauntlets(60%)','false','recipe',30,'stackable','liquid','none',-1,35200,0,'true','true','true','true','rp_sealed_magestic_gloves_i','recipe'),
(5407,'Recipe: Sealed Majestic Gauntlets(100%)','false','recipe',30,'stackable','liquid','none',-1,0,0,'true','true','true','true','rp_sealed_magestic_gloves','recipe'),
(5408,'Recipe: Sealed Dark Legion Gloves(60%)','false','recipe',30,'stackable','liquid','none',-1,0,0,'true','true','true','true','rp_sealed_dark_legion_gloves_i','recipe'),
(5409,'Recipe: Sealed Dark Legion Gloves(100%)','false','recipe',30,'stackable','liquid','none',-1,0,0,'true','true','true','true','rp_sealed_dark_legion_gloves','recipe'),
(5410,'Recipe: Sealed Gloves of Phantom(60%)','false','recipe',30,'stackable','liquid','none',-1,0,0,'true','true','true','true','rp_sealed_gloves_of_phantom_i','recipe'),
(5411,'Recipe: Sealed Gloves of Phantom(100%)','false','recipe',30,'stackable','liquid','none',-1,0,0,'true','true','true','true','rp_sealed_gloves_of_phantom','recipe'),
(5412,'Recipe: Sealed Cerberus Gloves(60%)','false','recipe',30,'stackable','liquid','none',-1,0,0,'true','true','true','true','rp_sealed_cerberus\'s_gloves_i','recipe'),
(5413,'Recipe: Sealed Cerberus Gloves(100%)','false','recipe',30,'stackable','liquid','none',-1,0,0,'true','true','true','true','rp_sealed_cerberus\'s_gloves','recipe'),
(5414,'Recipe: Sealed Dasparion\'s Gloves(60%)','false','recipe',30,'stackable','liquid','none',-1,0,0,'true','true','true','true','rp_sealed_dasparion\'s_gloves_i','recipe'),
(5415,'Recipe: Sealed Dasparion\'s Gloves(100%)','false','recipe',30,'stackable','liquid','none',-1,0,0,'true','true','true','true','rp_sealed_dasparion\'s_gloves','recipe'),
(5416,'Recipe: Sealed Dark Crystal Breastplate(60%)','false','recipe',30,'stackable','liquid','none',-1,92600,0,'true','true','true','true','rp_sealed_dark_crystal_breastplate_i','recipe'),
(5417,'Recipe: Sealed Dark Crystal Breastplate(100%)','false','recipe',30,'stackable','liquid','none',-1,0,0,'true','true','true','true','rp_sealed_dark_crystal_breastplate','recipe'),
(5418,'Recipe: Sealed Tallum Plate Armor(60%)','false','recipe',30,'stackable','liquid','none',-1,135400,0,'true','true','true','true','rp_sealed_tallum_plate_armor_i','recipe'),
(5419,'Recipe: Sealed Tallum Plate Armor(100%)','false','recipe',30,'stackable','liquid','none',-1,0,0,'true','true','true','true','rp_sealed_tallum_plate_armor','recipe'),
(5420,'Recipe: Sealed Armor of Nightmare(60%)','false','recipe',30,'stackable','liquid','none',-1,206000,0,'true','true','true','true','rp_sealed_armor_of_nightmare_i','recipe'),
(5421,'Recipe: Sealed Armor of Nightmare(100%)','false','recipe',30,'stackable','liquid','none',-1,0,0,'true','true','true','true','rp_sealed_armor_of_nightmare','recipe'),
(5422,'Recipe: Sealed Majestic Plate Armor(60%)','false','recipe',30,'stackable','liquid','none',-1,206000,0,'true','true','true','true','rp_sealed_majestic_platte_armor_i','recipe'),
(5423,'Recipe: Sealed Majestic Plate Armor(100%)','false','recipe',30,'stackable','liquid','none',-1,0,0,'true','true','true','true','rp_sealed_majestic_platte_armor','recipe'),
(5424,'Recipe: Sealed Dark Crystal Gaiters(60%)','false','recipe',30,'stackable','liquid','none',-1,57800,0,'true','true','true','true','rp_sealed_dark_crystal_gaiters_i','recipe'),
(5425,'Recipe: Sealed Dark Crystal Gaiters(100%)','false','recipe',30,'stackable','liquid','none',-1,0,0,'true','true','true','true','rp_sealed_dark_crystal_gaiters','recipe'),
(5426,'Recipe: Sealed Dark Crystal Helmet(60%)','false','recipe',30,'stackable','liquid','none',-1,34800,0,'true','true','true','true','rp_sealed_dark_crystal_helmet_i','recipe'),
(5427,'Recipe: Sealed Dark Crystal Helmet(100%)','false','recipe',30,'stackable','liquid','none',-1,0,0,'true','true','true','true','rp_sealed_dark_crystal_helmet','recipe'),
(5428,'Recipe: Sealed Tallum Helmet(60%)','false','recipe',30,'stackable','liquid','none',-1,34800,0,'true','true','true','true','rp_sealed_tallum_bonnet_i','recipe'),
(5429,'Recipe: Sealed Tallum Helmet(100%)','false','recipe',30,'stackable','liquid','none',-1,0,0,'true','true','true','true','rp_sealed_tallum_bonnet','recipe'),
(5430,'Recipe: Sealed Helm of Nightmare(60%)','false','recipe',30,'stackable','liquid','none',-1,52800,0,'true','true','true','true','rp_sealed_helm_of_nightmare_i','recipe'),
(5431,'Recipe: Sealed Helm of Nightmare(100%)','false','recipe',30,'stackable','liquid','none',-1,0,0,'true','true','true','true','rp_sealed_helm_of_nightmare','recipe'),
(5432,'Recipe: Sealed Majestic Circlet (60%)','false','recipe',30,'stackable','liquid','none',-1,52800,0,'true','true','true','true','rp_sealed_magestic_circlet_i','recipe'),
(5433,'Recipe: Sealed Majestic Circlet (100%)','false','recipe',30,'stackable','liquid','none',-1,0,0,'true','true','true','true','rp_sealed_magestic_circlet','recipe'),
(5434,'Recipe: Dragon Slayer(60%)','false','recipe',30,'stackable','liquid','none',-1,540000,0,'true','true','true','true','rp_dragon_slayer_i','recipe'),
(5435,'Recipe: Dragon Slayer(100%)','false','recipe',30,'stackable','liquid','none',-1,0,0,'true','true','true','true','rp_dragon_slayer','recipe'),
(5436,'Recipe: Berserker Blade(100%)','false','recipe',30,'stackable','liquid','none',-1,122600,0,'true','true','true','true','rp_berserker_blade','recipe'),
(5437,'Recipe: Heavy Sword(100%)','false','recipe',30,'stackable','liquid','none',-1,8180,0,'true','true','true','true','rp_heavy_sword','recipe'),
(5438,'Recipe: Meteor Shower(60%)','false','recipe',30,'stackable','liquid','none',-1,366000,0,'true','true','true','true','rp_meteor_shower_i','recipe'),
(5439,'Recipe: Meteor Shower(100%)','false','recipe',30,'stackable','liquid','none',-1,0,0,'true','true','true','true','rp_meteor_shower','recipe'),
(5440,'Recipe: Elysian(60%)','false','recipe',30,'stackable','liquid','none',-1,540000,0,'true','true','true','true','rp_elysian_i','recipe'),
(5441,'Recipe: Elysian(100%)','false','recipe',30,'stackable','liquid','none',-1,0,0,'true','true','true','true','rp_elysian','recipe'),
(5442,'Recipe: Soul Bow(60%)','false','recipe',30,'stackable','liquid','none',-1,540000,0,'true','true','true','true','rp_soul_bow_i','recipe'),
(5443,'Recipe: Soul Bow(100%)','false','recipe',30,'stackable','liquid','none',-1,0,0,'true','true','true','true','rp_soul_bow','recipe'),
(5444,'Recipe: Carnage Bow(60%)','false','recipe',30,'stackable','liquid','none',-1,366000,0,'true','true','true','true','rp_carnium_bow_i','recipe'),
(5445,'Recipe: Carnage Bow(100%)','false','recipe',30,'stackable','liquid','none',-1,0,0,'true','true','true','true','rp_carnium_bow','recipe'),
(5446,'Recipe: Bloody Orchid(60%)','false','recipe',30,'stackable','liquid','none',-1,366000,0,'true','true','true','true','rp_bloody_orchid_i','recipe'),
(5447,'Recipe: Bloody Orchid(100%)','false','recipe',30,'stackable','liquid','none',-1,0,0,'true','true','true','true','rp_bloody_orchid','recipe'),
(5448,'Recipe: Soul Separator(60%)','false','recipe',30,'stackable','liquid','none',-1,540000,0,'true','true','true','true','rp_soul_separator_i','recipe'),
(5449,'Recipe: Soul Separator(100%)','false','recipe',30,'stackable','liquid','none',-1,0,0,'true','true','true','true','rp_soul_separator','recipe'),
(5450,'Recipe: Dragon Grinder(60%)','false','recipe',30,'stackable','liquid','none',-1,540000,0,'true','true','true','true','rp_dragon_grinder_i','recipe'),
(5451,'Recipe: Dragon Grinder(100%)','false','recipe',30,'stackable','liquid','none',-1,0,0,'true','true','true','true','rp_dragon_grinder','recipe'),
(5452,'Recipe: Blood Tornado(60%)','false','recipe',30,'stackable','liquid','none',-1,366000,0,'true','true','true','true','rp_blood_tornado_i','recipe'),
(5453,'Recipe: Blood Tornado(100%)','false','recipe',30,'stackable','liquid','none',-1,0,0,'true','true','true','true','rp_blood_tornado','recipe'),
(5454,'Recipe: Orcish Halberd(60%)','false','recipe',30,'stackable','liquid','none',-1,0,0,'true','true','true','true','rp_orcish_halbard_i','recipe'),
(5455,'Recipe: Orcish Halberd(100%)','false','recipe',30,'stackable','liquid','none',-1,0,0,'true','true','true','true','rp_orcish_halbard','recipe'),
(5456,'Recipe: Tallum Glaive(60%)','false','recipe',30,'stackable','liquid','none',-1,540000,0,'true','true','true','true','rp_tallum_glaive_i','recipe'),
(5457,'Recipe: Tallum Glaive(100%)','false','recipe',30,'stackable','liquid','none',-1,0,0,'true','true','true','true','rp_tallum_glaive','recipe'),
(5458,'Recipe: Halberd(60%)','false','recipe',30,'stackable','liquid','none',-1,366000,0,'true','true','true','true','rp_halbard_i','recipe'),
(5459,'Recipe: Halberd(100%)','false','recipe',30,'stackable','liquid','none',-1,0,0,'true','true','true','true','rp_halbard','recipe'),
(5460,'Recipe: Dasparion\'s Staff(60%)','false','recipe',30,'stackable','liquid','none',-1,366000,0,'true','true','true','true','rp_dasparion\'s_staff_i','recipe'),
(5461,'Recipe: Dasparion\'s Staff(100%)','false','recipe',30,'stackable','liquid','none',-1,0,0,'true','true','true','true','rp_dasparion\'s_staff','recipe'),
(5462,'Recipe: Branch of The Mother Tree(60%)','false','recipe',30,'stackable','liquid','none',-1,540000,0,'true','true','true','true','rp_worldtree\'s_branch_i','recipe'),
(5463,'Recipe: Branch of The Mother Tree(100%)','false','recipe',30,'stackable','liquid','none',-1,0,0,'true','true','true','true','rp_worldtree\'s_branch','recipe'),
(5464,'Recipe: Dark Legion\'s Edge(60%)','false','recipe',30,'stackable','liquid','none',-1,540000,0,'true','true','true','true','rp_dark_legion\'s_edge_i','recipe'),
(5465,'Recipe: Dark Legion\'s Edge(100%)','false','recipe',30,'stackable','liquid','none',-1,0,0,'true','true','true','true','rp_dark_legion\'s_edge','recipe'),
(5466,'Recipe: Sword of Miracles(60%)','false','recipe',30,'stackable','liquid','none',-1,540000,0,'true','true','true','true','rp_sword_of_miracle_i','recipe'),
(5467,'Recipe: Sword of Miracles(100%)','false','recipe',30,'stackable','liquid','none',-1,0,0,'true','true','true','true','rp_sword_of_miracle','recipe'),
(5468,'Recipe: Elemental Sword(60%)','false','recipe',30,'stackable','liquid','none',-1,366000,0,'true','true','true','true','rp_elemental_sword_i','recipe'),
(5469,'Recipe: Elemental Sword(100%)','false','recipe',30,'stackable','liquid','none',-1,0,0,'true','true','true','true','rp_elemental_sword','recipe'),
(5470,'Recipe: Tallum Blade(60%)','false','recipe',30,'stackable','liquid','none',-1,366000,0,'true','true','true','true','rp_tallum_blade_i','recipe'),
(5471,'Recipe: Tallum Blade(100%)','false','recipe',30,'stackable','liquid','none',-1,0,0,'true','true','true','true','rp_tallum_blade','recipe'),
(5472,'Recipe: Metallic Thread(100%)','false','recipe',30,'stackable','liquid','none',-1,2800,0,'true','true','true','true','rp_iron_thread','recipe'),
(5473,'Recipe: Durable Metal Plate(100%)','false','recipe',30,'stackable','liquid','none',-1,2800,0,'true','true','true','true','rp_reinforcing_plate','recipe'),
(5474,'Recipe: Reorin\'s Mold(100%)','false','recipe',30,'stackable','liquid','none',-1,0,0,'true','true','true','true','rp_reorins_mold','recipe'),
(5475,'Recipe: Warsmith\'s Mold(100%)','false','recipe',30,'stackable','liquid','none',-1,0,0,'true','true','true','true','rp_warsmith_mold','recipe'),
(5476,'Recipe: Arcsmith\'s Anvil(100%)','false','recipe',30,'stackable','liquid','none',-1,0,0,'true','true','true','true','rp_arcsmith_anvil','recipe'),
(5477,'Recipe: Warsmith\'s Holder(100%)','false','recipe',30,'stackable','liquid','none',-1,0,0,'true','true','true','true','rp_warsmith_holder','recipe'),
(5478,'Sealed Dark Crystal Leather Armor Pattern','false','material',60,'stackable','liquid','none',-1,23784,0,'true','true','true','true','sealed_dark_crystal_leather_mail_patte','material'),
(5479,'Sealed Tallum Leather Armor Pattern','false','material',60,'stackable','liquid','none',-1,33800,0,'true','true','true','true','sealed_tallum_leather_mail_pattern','material'),
(5480,'Sealed Leather Armor of Nightmare Fabric','false','material',60,'stackable','liquid','none',-1,44571,0,'true','true','true','true','sealed_leather_mail_of_nightmare_fabri','material'),
(5481,'Sealed Majestic Leather Armor Fabric','false','material',60,'stackable','liquid','none',-1,44571,0,'true','true','true','true','sealed_majestic_leather_mail_fabric','material'),
(5482,'Sealed Dark Crystal Leggings Design','false','material',60,'stackable','liquid','none',-1,15153,0,'true','true','true','true','sealed_legging_of_dark_crystal_design','material'),
(5483,'Phoenix Earring Gemstone','false','material',60,'stackable','liquid','none',-1,0,0,'true','true','true','true','phoenix\'s_earing_gemstone','material'),
(5484,'Inferno Earring Gemstone','false','material',60,'stackable','liquid','none',-1,0,0,'true','true','true','true','majestic_earing_gemstone','material'),
(5485,'Sealed Tallum Tunic Texture','false','material',60,'stackable','liquid','none',-1,23784,0,'true','true','true','true','sealed_tallum_tunic_texture','material'),
(5486,'Sealed Dark Crystal Robe Fabric','false','material',60,'stackable','liquid','none',-1,33800,0,'true','true','true','true','sealed_dark_crystal_robe_fabric','material'),
(5487,'Sealed Nightmare Robe Fabric','false','material',60,'stackable','liquid','none',-1,44414,0,'true','true','true','true','sealed_robe_of_nightmare_fabric','material'),
(5488,'Sealed Majestic Robe Fabric','false','material',60,'stackable','liquid','none',-1,44414,0,'true','true','true','true','sealed_majestic_robe_fabric','material'),
(5489,'Sealed Tallum Stockings Fabric','false','material',60,'stackable','liquid','none',-1,15153,0,'true','true','true','true','sealed_tallum_hose_fabric','material'),
(5490,'Phoenix Necklace Beads','false','material',60,'stackable','liquid','none',-1,0,0,'true','true','true','true','phoenix\'s_necklace_beads','material'),
(5491,'Inferno Necklace Beads','false','material',60,'stackable','liquid','none',-1,0,0,'true','true','true','true','majestic_necklace_beads','material'),
(5492,'Phoenix Ring Gemstone','false','material',60,'stackable','liquid','none',-1,0,0,'true','true','true','true','phoenix\'s_ring_gemstone','material'),
(5493,'Inferno Ring Gemstone','false','material',60,'stackable','liquid','none',-1,0,0,'true','true','true','true','majestic_ring_gemstone','material'),
(5494,'Sealed Dark Crystal Shield Fragment','false','material',60,'stackable','liquid','none',-1,9523,0,'true','true','true','true','sealed_dark_crystal_shield_fragment','material'),
(5495,'Sealed Shield of Nightmare Fragment','false','material',60,'stackable','liquid','none',-1,13171,0,'true','true','true','true','sealed_shield_of_nightmare_fragment','material'),
(5496,'Sealed Dark Crystal Boots Lining','false','material',60,'stackable','liquid','none',-1,8530,0,'true','true','true','true','sealed_dark_crystal_boots_lining','material'),
(5497,'Sealed Tallum Boots Lining','false','material',60,'stackable','liquid','none',-1,8530,0,'true','true','true','true','sealed_tallum_boots_lining','material'),
(5498,'Sealed Boots of the Underworld Lining','false','material',60,'stackable','liquid','none',-1,0,0,'true','true','true','true','sealed_boots_of_underworld_lining','material'),
(5499,'Sealed Gust Boots Lining','false','material',60,'stackable','liquid','none',-1,0,0,'true','true','true','true','sealed_gust_boots_lining','material'),
(5500,'Sealed Red Flame Boots Lining','false','material',60,'stackable','liquid','none',-1,0,0,'true','true','true','true','sealed_red_flame_boots_lining','material'),
(5501,'Sealed Phoenix Boots Lining','false','material',60,'stackable','liquid','none',-1,0,0,'true','true','true','true','sealed_phoenix\'s_boots_lining','material'),
(5502,'Sealed Boots of Nightmare Lining','false','material',60,'stackable','liquid','none',-1,11842,0,'true','true','true','true','sealed_boots_of_nightmare_lining','material'),
(5503,'Sealed Majestic Boots Lining','false','material',60,'stackable','liquid','none',-1,11842,0,'true','true','true','true','sealed_magestic_boots_lining','material'),
(5504,'Sealed Dark Legion Boots Lining','false','material',60,'stackable','liquid','none',-1,0,0,'true','true','true','true','sealed_dark_legion_boots_lining','material'),
(5505,'Sealed Boots of Phantom Lining','false','material',60,'stackable','liquid','none',-1,0,0,'true','true','true','true','sealed_boots_of_phantom_lining','material'),
(5506,'Sealed Cerberus Boots Lining','false','material',60,'stackable','liquid','none',-1,0,0,'true','true','true','true','sealed_cerberus\'s_boots_lining','material'),
(5507,'Sealed Dasparion\'s Boots Lining','false','material',60,'stackable','liquid','none',-1,0,0,'true','true','true','true','sealed_dasparion\'s_boots_lining','material'),
(5508,'Sealed Dark Crystal Gloves Design','false','material',60,'stackable','liquid','none',-1,8530,0,'true','true','true','true','sealed_dark_crystal_gloves_design','material'),
(5509,'Sealed Tallum Gloves Design','false','material',60,'stackable','liquid','none',-1,8530,0,'true','true','true','true','sealed_tallum_gloves_design','material'),
(5510,'Sealed Gloves of the Underworld Design','false','material',60,'stackable','liquid','none',-1,0,0,'true','true','true','true','sealed_gloves_of_underworld_design','material'),
(5511,'Sealed Gust Bracer design','false','material',60,'stackable','liquid','none',-1,0,0,'true','true','true','true','sealed_gust_bracer_design','material'),
(5512,'Sealed Gloves of Black Ore Design','false','material',60,'stackable','liquid','none',-1,0,0,'true','true','true','true','sealed_gloves_of_black_ore_design','material'),
(5513,'Sealed Phoenix Gloves Design','false','material',60,'stackable','liquid','none',-1,0,0,'true','true','true','true','sealed_phoenix\'s_gloves_design','material'),
(5514,'Sealed Gauntlets of Nightmare Design','false','material',60,'stackable','liquid','none',-1,11842,0,'true','true','true','true','sealed_gloves_of_nightmare_design','material'),
(5515,'Sealed Majestic Gauntlets Design','false','material',60,'stackable','liquid','none',-1,11842,0,'true','true','true','true','sealed_magestic_gloves_design','material'),
(5516,'Sealed Dark Legion Gloves Design','false','material',60,'stackable','liquid','none',-1,0,0,'true','true','true','true','sealed_dark_legion_gloves_design','material'),
(5517,'Sealed Gloves of Phantom Design','false','material',60,'stackable','liquid','none',-1,0,0,'true','true','true','true','sealed_gloves_of_phantom_design','material'),
(5518,'Sealed Cerberus Gloves Design','false','material',60,'stackable','liquid','none',-1,0,0,'true','true','true','true','sealed_cerberus\'s_gloves_design','material'),
(5519,'Sealed Dasparion\'s Gloves Design','false','material',60,'stackable','liquid','none',-1,0,0,'true','true','true','true','sealed_dasparion\'s_gloves_design','material'),
(5520,'Sealed Dark Crystal Breastplate Pattern','false','material',60,'stackable','liquid','none',-1,31015,0,'true','true','true','true','sealed_dark_crystal_breastplate_patter','material'),
(5521,'Sealed Tallum Plate Armor Pattern','false','material',60,'stackable','liquid','none',-1,43953,0,'true','true','true','true','sealed_tallum_plate_armor_pattern','material'),
(5522,'Sealed Armor of Nightmare Pattern','false','material',60,'stackable','liquid','none',-1,58728,0,'true','true','true','true','sealed_armor_of_nightmare_pattern','material'),
(5523,'Sealed Majestic Plate Armor Pattern','false','material',60,'stackable','liquid','none',-1,58728,0,'true','true','true','true','sealed_majestic_platte_armor_pattern','material'),
(5524,'Sealed Dark Crystal Gaiters Pattern','false','material',60,'stackable','liquid','none',-1,20292,0,'true','true','true','true','sealed_dark_crystal_gaiters_pattern','material'),
(5525,'Sealed Dark Crystal Helmet Design','false','material',60,'stackable','liquid','none',-1,12938,0,'true','true','true','true','sealed_dark_crystal_helmet_design','material'),
(5526,'Sealed Tallum Helm Design','false','material',60,'stackable','liquid','none',-1,12938,0,'true','true','true','true','sealed_tallum_bonnet_design','material'),
(5527,'Sealed Helm of Nightmare Design','false','material',60,'stackable','liquid','none',-1,16728,0,'true','true','true','true','sealed_helm_of_nightmare_design','material'),
(5528,'Sealed Majestic Circlet Design','false','material',60,'stackable','liquid','none',-1,16728,0,'true','true','true','true','sealed_magestic_circlet_design','material'),
(5529,'Dragon Slayer Edge','false','material',60,'stackable','liquid','none',-1,72900,0,'true','true','true','true','dragon_slayer_edge','material'),
(5530,'Berserker Blade Edge','false','material',60,'stackable','liquid','none',-1,43600,0,'true','true','true','true','berserker_blade_edge','material'),
(5531,'Heavy Sword Edge','false','material',60,'stackable','liquid','none',-1,11912,0,'true','true','true','true','heavy_sword_edge','material'),
(5532,'Meteor Shower Head','false','material',60,'stackable','liquid','none',-1,59308,0,'true','true','true','true','meteor_shower_head','material'),
(5533,'Elysian Head','false','material',60,'stackable','liquid','none',-1,72914,0,'true','true','true','true','elysian_head','material'),
(5534,'Soul Bow Stave','false','material',60,'stackable','liquid','none',-1,72850,0,'true','true','true','true','soul_bow_shaft','material'),
(5535,'Carnage Bow Stave','false','material',60,'stackable','liquid','none',-1,58615,0,'true','true','true','true','carnium_bow_shaft','material'),
(5536,'Bloody Orchid Head','false','material',60,'stackable','liquid','none',-1,58785,0,'true','true','true','true','bloody_orchid_head','material'),
(5537,'Soul Separator Head','false','material',60,'stackable','liquid','none',-1,72900,0,'true','true','true','true','soul_separator_head','material'),
(5538,'Dragon Grinder Edge','false','material',60,'stackable','liquid','none',-1,72914,0,'true','true','true','true','dragon_grinder_edge','material'),
(5539,'Blood Tornado Edge','false','material',60,'stackable','liquid','none',-1,59308,0,'true','true','true','true','blood_tornado_edge','material'),
(5540,'Orcish Halberd Edge','false','material',60,'stackable','liquid','none',-1,62500,0,'true','true','true','true','orcish_halbard_edge','material'),
(5541,'Tallum Glaive Edge','false','material',60,'stackable','liquid','none',-1,72929,0,'true','true','true','true','tallum_glaive_edge','material'),
(5542,'Halberd Edge','false','material',60,'stackable','liquid','none',-1,59308,0,'true','true','true','true','halbard_edge','material'),
(5543,'Dasparion\'s Staff Edge','false','material',60,'stackable','liquid','none',-1,58754,0,'true','true','true','true','dasparion\'s_staff_head','material'),
(5544,'Branch of The Mother Tree Head','false','material',60,'stackable','liquid','none',-1,72986,0,'true','true','true','true','worldtree\'s_branch_head','material'),
(5545,'Dark Legion\'s Edge Blade','false','material',60,'stackable','liquid','none',-1,72900,0,'true','true','true','true','dark_legion\'s_edge_edge','material'),
(5546,'Sword of Miracles Edge','false','material',60,'stackable','liquid','none',-1,66369,0,'true','true','true','true','sword_of_miracle_edge','material'),
(5547,'Elemental Sword Edge','false','material',60,'stackable','liquid','none',-1,58785,0,'true','true','true','true','elemental_sword_edge','material'),
(5548,'Tallum Blade Edge','false','material',60,'stackable','liquid','none',-1,58785,0,'true','true','true','true','tallum_blade_edge','material'),
(5549,'Metallic Thread','false','material',2,'stackable','liquid','none',-1,2000,0,'true','true','true','true','iron_thread','material'),
(5550,'Durable Metal Plate','false','material',2,'stackable','liquid','none',-1,15000,0,'true','true','true','true','reinforcing_plate','material'),
(5551,'Leolin\'s Mold','false','material',2,'stackable','liquid','none',-1,238000,0,'true','true','true','true','reorins_mold','material'),
(5552,'Warsmith\'s Mold','false','material',2,'stackable','liquid','none',-1,385000,0,'true','true','true','true','warsmith_mold','material'),
(5553,'Arcsmith\'s Anvil','false','material',2,'stackable','liquid','none',-1,531200,0,'true','true','true','true','arcsmith_anvil','material'),
(5554,'Warsmith\'s Holder','false','material',2,'stackable','liquid','none',-1,884000,0,'true','true','true','true','warsmith_holder','material'),
(5555,'Token of Love','false','none',0,'stackable','paper','none',-1,0,0,'true','true','true','true','x_mas_2004','none'),
(5556,'Star Ornament','false','material',0,'stackable','liquid','none',-1,1,0,'true','true','true','true','deco_star','material'),
(5557,'Bead Ornament','false','material',0,'stackable','liquid','none',-1,1,0,'true','true','true','true','deco_bead','material'),
(5558,'Fir Tree Branch','false','material',0,'stackable','liquid','none',-1,1,0,'true','true','true','true','fir_spring','material'),
(5559,'Flower Pot','false','material',0,'stackable','liquid','none',-1,1,0,'true','true','true','true','flowerpot','material'),
(5560,'Christmas Tree','false','potion',0,'stackable','paper','none',-1,1,0,'true','true','true','true','x_mas_tree1','potion'),
(5561,'Special Christmas Tree','false','potion',0,'stackable','paper','none',-1,1,0,'true','true','true','true','x_mas_tree2','potion'),
(5562,'Echo Crystal - 1st Carol','false','none',10,'stackable','paper','none',-1,0,0,'true','true','true','true','echo_crystal_carol1','none'),
(5563,'Echo Crystal - 2nd Carol','false','none',10,'stackable','paper','none',-1,0,0,'true','true','true','true','echo_crystal_carol2','none'),
(5564,'Echo Crystal - 3rd Carol','false','none',10,'stackable','paper','none',-1,0,0,'true','true','true','true','echo_crystal_carol3','none'),
(5565,'Echo Crystal - 4th Carol','false','none',10,'stackable','paper','none',-1,0,0,'true','true','true','true','echo_crystal_carol4','none'),
(5566,'Echo Crystal - 5th Carol','false','none',10,'stackable','paper','none',-1,0,0,'true','true','true','true','echo_crystal_carol5','none'),
(5567,'Letter of Greetings','false','quest',0,'stackable','steel','none',-1,0,0,'false','false','true','false','greetings1','none'),
(5568,'Letter of Greetings','false','quest',0,'stackable','steel','none',-1,0,0,'false','false','true','false','greetings2','none'),
(5569,'Water Rune','false','none',0,'stackable','gold','none',-1,0,0,'true','true','true','true','rune_of_water','none'),
(5570,'Water Mantra','false','none',0,'stackable','gold','none',-1,0,0,'true','true','true','true','mantra_of_water','none'),
(5571,'Wind Rune','false','none',0,'stackable','gold','none',-1,0,0,'true','true','true','true','rune_of_wind','none'),
(5572,'Wind Mantra','false','none',0,'stackable','gold','none',-1,0,0,'true','true','true','true','mantra_of_wind','none'),
(5573,'Fire Rune','false','none',0,'stackable','gold','none',-1,0,0,'true','true','true','true','rune_of_fire','none'),
(5574,'Fire Mantra','false','none',0,'stackable','gold','none',-1,0,0,'true','true','true','true','mantra_of_fire','none'),
(5575,'Ancient Adena','false','none',0,'asset','gold','none',-1,0,0,'true','true','true','true','adena_of_ancient','none'),
(5577,'Red Soul Crystal - Stage 11','false','scroll',20,'normal','crystal','none',-1,0,0,'true','true','true','true','red_soul_crystal_11','scroll'),
(5578,'Green Soul Crystal - Stage 11','false','scroll',20,'normal','crystal','none',-1,0,0,'true','true','true','true','green_soul_crystal_11','scroll'),
(5579,'Blue Soul Crystal - Stage 11','false','scroll',20,'normal','crystal','none',-1,0,0,'true','true','true','true','blue_soul_crystal_11','scroll'),
(5580,'Red Soul Crystal - Stage 12','false','scroll',20,'normal','crystal','none',-1,0,0,'true','true','true','true','red_soul_crystal_12','scroll'),
(5581,'Green Soul Crystal - Stage 12','false','scroll',20,'normal','crystal','none',-1,0,0,'true','true','true','true','green_soul_crystal_12','scroll'),
(5582,'Blue Soul Crystal - Stage 12','false','scroll',20,'normal','crystal','none',-1,0,0,'true','true','true','true','blue_soul_crystal_12','scroll'),
(5583,'Echo Crystal - 6th Carol','false','none',10,'stackable','paper','none',-1,0,0,'true','true','true','true','echo_crystal_carol6','none'),
(5584,'Echo Crystal - 7th Carol','false','none',10,'stackable','paper','none',-1,0,0,'true','true','true','true','echo_crystal_carol7','none'),
(5585,'Echo Crystal - 8th Carol','false','none',10,'stackable','paper','none',-1,0,0,'true','true','true','true','echo_crystal_carol8','none'),
(5586,'Echo Crystal - 9th Carol','false','none',10,'stackable','paper','none',-1,0,0,'true','true','true','true','echo_crystal_carol9','none'),
(5587,'Echo Crystal - 10th Carol','false','none',10,'stackable','paper','none',-1,0,0,'true','true','true','true','echo_crystal_carol10','none'),
(5588,'Tutorial Guide','false','none',10,'normal','liquid','none',-1,1,0,'true','false','true','true','tutorial_guide','none'),
(5589,'Energy Stone','false','potion',10,'stackable','liquid','none',-1,100,0,'true','true','true','true','energy_stone','potion'),
(5591,'CP Potion','false','potion',25,'stackable','liquid','none',-1,240,0,'true','true','true','true','CP Potion','potion'),
(5592,'Greater CP Potion','false','potion',100,'stackable','liquid','none',-1,600,0,'true','true','true','true','Advanced CP Potion','potion'),
(5593,'SP Scroll: Low Grade','false','scroll',30,'stackable','paper','none',-1,2400,0,'true','true','true','true','sp_scroll1','scroll'),
(5594,'SP Scroll: Medium Grade','false','scroll',30,'stackable','paper','none',-1,24000,0,'true','true','true','true','sp_scroll2','scroll'),
(5595,'SP Scroll: High Grade','false','scroll',30,'stackable','paper','none',-1,480000,0,'true','true','true','true','sp_scroll3','scroll'),
(5650,'Alternative Dark Coda Seed','false','seed',1,'stackable','paper','none',-1,5,0,'true','true','true','true','C5Item','none'),
(5651,'Alternative Red Coda Seed','false','seed',1,'stackable','paper','none',-1,5,0,'true','true','true','true','C5Item','none'),
(5652,'Alternative Chilly Coda Seed','false','seed',1,'stackable','paper','none',-1,5,0,'true','true','true','true','C5Item','none'),
(5653,'Alternative Blue Coda Seed','false','seed',1,'stackable','paper','none',-1,10,0,'true','true','true','true','C5Item','none'),
(5654,'Alternative Golden Coda Seed','false','seed',1,'stackable','paper','none',-1,20,0,'true','true','true','true','C5Item','none'),
(5655,'Alternative Lute Coda Seed','false','seed',1,'stackable','paper','none',-1,30,0,'true','true','true','true','C5Item','none'),
(5656,'Alternative Desert Coda Seed','false','seed',1,'stackable','paper','none',-1,20,0,'true','true','true','true','C5Item','none'),
(5657,'Alternative Blue Cobol Seed','false','seed',1,'stackable','paper','none',-1,50,0,'true','true','true','true','C5Item','none'),
(5658,'Alternative Blue Coda Seed','false','seed',1,'stackable','paper','none',-1,10,0,'true','true','true','true','C5Item','none'),
(5659,'Alternative Golden Coda Seed','false','seed',1,'stackable','paper','none',-1,20,0,'true','true','true','true','C5Item','none'),
(5660,'Alternative Lute Coda Seed','false','seed',1,'stackable','paper','none',-1,30,0,'true','true','true','true','C5Item','none'),
(5661,'Alternative Desert Coda Seed','false','seed',1,'stackable','paper','none',-1,20,0,'true','true','true','true','C5Item','none'),
(5662,'Alternative Red Cobol Seed','false','seed',1,'stackable','paper','none',-1,20,0,'true','true','true','true','C5Item','none'),
(5663,'Alternative Chilly Cobol Seed','false','seed',1,'stackable','paper','none',-1,25,0,'true','true','true','true','C5Item','none'),
(5664,'Alternative Thorn Cobol Seed','false','seed',1,'stackable','paper','none',-1,50,0,'true','true','true','true','C5Item','none'),
(5665,'Alternative Golden Cobol Seed','false','seed',1,'stackable','paper','none',-1,50,0,'true','true','true','true','C5Item','none'),
(5666,'Alternative Great Cobol Seed','false','seed',1,'stackable','paper','none',-1,40,0,'true','true','true','true','C5Item','none'),
(5667,'Alternative Red Cobol Seed','false','seed',1,'stackable','paper','none',-1,20,0,'true','true','true','true','C5Item','none'),
(5668,'Alternative Chilly Cobol Seed','false','seed',1,'stackable','paper','none',-1,25,0,'true','true','true','true','C5Item','none'),
(5669,'Alternative Blue Cobol Seed','false','seed',1,'stackable','paper','none',-1,50,0,'true','true','true','true','C5Item','none'),
(5670,'Alternative Thorn Cobol Seed','false','seed',1,'stackable','paper','none',-1,50,0,'true','true','true','true','C5Item','none'),
(5671,'Alternative Golden Cobol Seed','false','seed',1,'stackable','paper','none',-1,50,0,'true','true','true','true','C5Item','none'),
(5672,'Alternative Great Cobol Seed','false','seed',1,'stackable','paper','none',-1,40,0,'true','true','true','true','C5Item','none'),
(5673,'Alternative Red Codran Seed','false','seed',1,'stackable','paper','none',-1,40,0,'true','true','true','true','C5Item','none'),
(5674,'Alternative Twin Codran Seed','false','seed',1,'stackable','paper','none',-1,50,0,'true','true','true','true','C5Item','none'),
(5675,'Alternative Desert Codran Seed','false','seed',1,'stackable','paper','none',-1,100,0,'true','true','true','true','C5Item','none'),
(5676,'Alternative Dark Coda Seed','false','seed',1,'stackable','paper','none',-1,5,0,'true','true','true','true','C5Item','none'),
(5677,'Alternative Red Coda Seed','false','seed',1,'stackable','paper','none',-1,5,0,'true','true','true','true','C5Item','none'),
(5678,'Alternative Blue Coda Seed','false','seed',1,'stackable','paper','none',-1,10,0,'true','true','true','true','C5Item','none'),
(5679,'Alternative Red Cobol Seed','false','seed',1,'stackable','paper','none',-1,20,0,'true','true','true','true','C5Item','none'),
(5680,'Alternative Chilly Cobol Seed','false','seed',1,'stackable','paper','none',-1,25,0,'true','true','true','true','C5Item','none'),
(5681,'Alternative Blue Cobol Seed','false','seed',1,'stackable','paper','none',-1,50,0,'true','true','true','true','C5Item','none'),
(5682,'Alternative Thorn Cobol Seed','false','seed',1,'stackable','paper','none',-1,50,0,'true','true','true','true','C5Item','none'),
(5683,'Alternative Sea Codran Seed','false','seed',1,'stackable','paper','none',-1,50,0,'true','true','true','true','C5Item','none'),
(5684,'Alternative Chilly Codran Seed','false','seed',1,'stackable','paper','none',-1,40,0,'true','true','true','true','C5Item','none'),
(5685,'Alternative Blue Codran Seed','false','seed',1,'stackable','paper','none',-1,50,0,'true','true','true','true','C5Item','none'),
(5686,'Alternative Twin Codran Seed','false','seed',1,'stackable','paper','none',-1,50,0,'true','true','true','true','C5Item','none'),
(5687,'Alternative Thorn Cobol Seed','false','seed',1,'stackable','paper','none',-1,50,0,'true','true','true','true','C5Item','none'),
(5688,'Alternative Golden Cobol Seed','false','seed',1,'stackable','paper','none',-1,50,0,'true','true','true','true','C5Item','none'),
(5689,'Alternative Great Cobol Seed','false','seed',1,'stackable','paper','none',-1,40,0,'true','true','true','true','C5Item','none'),
(5690,'Alternative Red Codran Seed','false','seed',1,'stackable','paper','none',-1,40,0,'true','true','true','true','C5Item','none'),
(5691,'Alternative Chilly Codran Seed','false','seed',1,'stackable','paper','none',-1,40,0,'true','true','true','true','C5Item','none'),
(5692,'Alternative Blue Codran Seed','false','seed',1,'stackable','paper','none',-1,50,0,'true','true','true','true','C5Item','none'),
(5693,'Alternative Twin Codran Seed','false','seed',1,'stackable','paper','none',-1,50,0,'true','true','true','true','C5Item','none'),
(5694,'Alternative Great Codran Seed','false','seed',1,'stackable','paper','none',-1,75,0,'true','true','true','true','C5Item','none'),
(5695,'Alternative Desert Codran Seed','false','seed',1,'stackable','paper','none',-1,100,0,'true','true','true','true','C5Item','none'),
(5696,'Alternative Chilly Cobol Seed','false','seed',1,'stackable','paper','none',-1,25,0,'true','true','true','true','C5Item','none'),
(5697,'Alternative Blue Cobol Seed','false','seed',1,'stackable','paper','none',-1,50,0,'true','true','true','true','C5Item','none'),
(5698,'Alternative Thorn Cobol Seed','false','seed',1,'stackable','paper','none',-1,50,0,'true','true','true','true','C5Item','none'),
(5699,'Alternative Golden Cobol Seed','false','seed',1,'stackable','paper','none',-1,50,0,'true','true','true','true','C5Item','none'),
(5700,'Alternative Great Cobol Seed','false','seed',1,'stackable','paper','none',-1,40,0,'true','true','true','true','C5Item','none'),
(5701,'Alternative Red Codran Seed','false','seed',1,'stackable','paper','none',-1,40,0,'true','true','true','true','C5Item','none'),
(5702,'Alternative Sea Codran Seed','false','seed',1,'stackable','paper','none',-1,50,0,'true','true','true','true','C5Item','none'),
(5703,'Lucky Charm','false','scroll',10,'stackable','paper','none',-1,100,0,'true','true','true','true','charm_of_luck_none','scroll'),
(5707,'Record of Seven Signs','false','none',0,'normal','liquid','none',-1,600,0,'true','true','true','true','record_of_seven_sign','none'),
(5708,'Lord of the Manor\'s Certificate of Approval','false','ticket_of_lord',0,'normal','liquid','none',-1,0,0,'true','true','true','true','the_lord_of_manor\'s_agreement','ch3type2'),
(5741,'Recipe: Sealed Zubei\'s Gauntlets (100%)','false','recipe',30,'stackable','liquid','none',-1,0,0,'true','true','true','true','rp_sealed_shrnoen\'s_gauntlet','recipe'),
(5742,'Recipe: Zubei\'s Gauntlets (60%)','false','recipe',30,'stackable','liquid','none',-1,0,0,'true','true','true','true','rp_sealed_shrnoen\'s_gauntlet_i','recipe'),
(5743,'Recipe: Sealed Avadon Gloves (100%)','false','recipe',30,'stackable','liquid','none',-1,0,0,'true','true','true','true','rp_sealed_avadon_gloves','recipe'),
(5744,'Recipe: Sealed Avadon Gloves (60%)','false','recipe',30,'stackable','liquid','none',-1,0,0,'true','true','true','true','rp_sealed_avadon_gloves_i','recipe'),
(5745,'Recipe: Sealed Blue Wolf Gloves (100%)','false','recipe',30,'stackable','liquid','none',-1,0,0,'true','true','true','true','rp_sealed_blue_wolve\'s_gloves','recipe'),
(5746,'Recipe: Sealed Blue Wolf Gloves (60%)','false','recipe',30,'stackable','liquid','none',-1,0,0,'true','true','true','true','rp_sealed_blue_wolve\'s_gloves_i','recipe'),
(5747,'Recipe: Sealed Doom Gloves (100%)','false','recipe',30,'stackable','liquid','none',-1,0,0,'true','true','true','true','rp_sealed_doom_gloves','recipe'),
(5748,'Recipe: Sealed Doom Gloves (60%)','false','recipe',30,'stackable','liquid','none',-1,0,0,'true','true','true','true','rp_sealed_doom_gloves_i','recipe'),
(5749,'Recipe: Sealed Zubei\'s Boots (100%)','false','recipe',30,'stackable','liquid','none',-1,0,0,'true','true','true','true','rp_sealed_shrnoen\'s_boots','recipe'),
(5750,'Recipe: Sealed Zubei\'s Boots (60%)','false','recipe',30,'stackable','liquid','none',-1,0,0,'true','true','true','true','rp_sealed_shrnoen\'s_boots_i','recipe'),
(5751,'Recipe: Sealed Avadon Boots (100%)','false','recipe',30,'stackable','liquid','none',-1,0,0,'true','true','true','true','rp_sealed_avadon_boots','recipe'),
(5752,'Recipe: Sealed Avadon Boots (60%)','false','recipe',30,'stackable','liquid','none',-1,0,0,'true','true','true','true','rp_sealed_avadon_boots_i','recipe'),
(5753,'Recipe: Sealed Blue Wolf Boots (100%)','false','recipe',30,'stackable','liquid','none',-1,0,0,'true','true','true','true','rp_sealed_blue_wolve\'s_boots','recipe'),
(5754,'Recipe: Sealed Blue Wolf Boots (60%)','false','recipe',30,'stackable','liquid','none',-1,0,0,'true','true','true','true','rp_sealed_blue_wolve\'s_boots_i','recipe'),
(5755,'Recipe: Sealed Boots of Doom (100%)','false','recipe',30,'stackable','liquid','none',-1,0,0,'true','true','true','true','rp_sealed_doom_boots','recipe'),
(5756,'Recipe: Sealed Boots of Doom (60%)','false','recipe',30,'stackable','liquid','none',-1,0,0,'true','true','true','true','rp_sealed_doom_boots_i','recipe'),
(5757,'Sealed Zubei\'s Gauntlet Part','false','material',60,'stackable','liquid','none',-1,0,0,'true','true','true','true','sealed_shrnoen\'s_gauntlet_part','material'),
(5758,'Sealed Avadon Gloves Part','false','material',60,'stackable','liquid','none',-1,0,0,'true','true','true','true','sealed_avadon_gloves_part','material'),
(5759,'Sealed Blue Wolf Gloves Fabric','false','material',60,'stackable','liquid','none',-1,0,0,'true','true','true','true','sealed_blue_wolve\'s_gloves_fabric','material'),
(5760,'Sealed Doom Gloves Part','false','material',60,'stackable','liquid','none',-1,0,0,'true','true','true','true','sealed_doom_gloves_part','material'),
(5761,'Sealed Zubei\'s Boots Design','false','material',60,'stackable','liquid','none',-1,0,0,'true','true','true','true','sealed_shrnoen\'s_boots_design','material'),
(5762,'Sealed Avadon Boots Design','false','material',60,'stackable','liquid','none',-1,0,0,'true','true','true','true','sealed_avadon_boots_design','material'),
(5763,'Sealed Blue Wolf Boots Design','false','material',60,'stackable','liquid','none',-1,0,0,'true','true','true','true','sealed_blue_wolve\'s_boots_design','material'),
(5764,'Sealed Doom Boots Part','false','material',60,'stackable','liquid','none',-1,0,0,'true','true','true','true','sealed_doom_boots_part','material'),
(5789,'Soulshot: No Grade for Beginners','false','none',1,'stackable','paper','none',-1,0,0,'false','false','true','false','soulshot_for_novices','none'),
(5790,'Spiritshot: No Grade for Beginners','false','none',1,'stackable','paper','none',-1,0,0,'false','false','true','false','spiritshot_for_novices','none'),
(5803,'Lucky Charm: D-Grade','false','scroll',10,'stackable','paper','none',-1,300,0,'true','true','true','true','charm_of_luck_d','scroll'),
(5804,'Lucky Charm: C-Grade','false','scroll',10,'stackable','paper','none',-1,660,0,'true','true','true','true','charm_of_luck_c','scroll'),
(5805,'Lucky Charm: B-Grade','false','scroll',10,'stackable','paper','none',-1,1300,0,'true','true','true','true','charm_of_luck_b','scroll'),
(5806,'Lucky Charm: A-Grade','false','scroll',10,'stackable','paper','none',-1,2700,0,'true','true','true','true','charm_of_luck_a','scroll'),
(5807,'Lucky Charm: S Grade','false','scroll',10,'stackable','paper','none',-1,5000,0,'true','true','true','true','charm_of_luck_s','scroll'),
(5809,'Spellbook: Aqua Splash','false','spellbook',120,'stackable','paper','none',-1,6750,0,'true','true','true','true','sb_aqua_splash1','none'),
(5810,'Spellbook: Rain of Fire','false','spellbook',120,'stackable','paper','none',-1,6750,0,'true','true','true','true','sb_rain_of_fire1','none'),
(5811,'Spellbook: Mass Slow','false','spellbook',120,'stackable','paper','none',-1,7700,0,'true','true','true','true','sb_mass_slow1','none'),
(5812,'Spellbook: Servitor Empowerment','false','spellbook',120,'stackable','paper','none',-1,5400,0,'true','true','true','true','sb_servitor_empower1','none'),
(5813,'Spellbook: Servitor Cure','false','spellbook',120,'stackable','paper','none',-1,3200,0,'true','true','true','true','sb_servitor_cure1','none'),
(5814,'Spellbook: Servitor Blessing','false','spellbook',120,'stackable','paper','none',-1,7700,0,'true','true','true','true','sb_servitor_blessing','none'),
(5815,'Spellbook: Wild Magic','false','spellbook',120,'stackable','paper','none',-1,7700,0,'true','true','true','true','sb_wild_magic1','none'),
(5816,'Spellbook: Advanced Block','false','spellbook',120,'stackable','paper','none',-1,6750,0,'true','true','true','true','sb_advanced_block1','none'),
(5818,'Alternative Dark Coda','false','none',2,'stackable','paper','none',-1,50,0,'true','true','true','true','C5Item','none'),
(5819,'Alternative Red Coda','false','none',2,'stackable','paper','none',-1,50,0,'true','true','true','true','C5Item','none'),
(5820,'Alternative Chilly Coda','false','none',2,'stackable','paper','none',-1,50,0,'true','true','true','true','C5Item','none'),
(5821,'Alternative Blue Coda','false','none',2,'stackable','paper','none',-1,100,0,'true','true','true','true','C5Item','none'),
(5822,'Alternative Golden Coda','false','none',2,'stackable','paper','none',-1,200,0,'true','true','true','true','C5Item','none'),
(5823,'Alternative Lute Coda','false','none',2,'stackable','paper','none',-1,300,0,'true','true','true','true','C5Item','none'),
(5824,'Alternative Desert Coda','false','none',2,'stackable','paper','none',-1,200,0,'true','true','true','true','C5Item','none'),
(5825,'Alternative Red Cobol','false','none',2,'stackable','paper','none',-1,200,0,'true','true','true','true','C5Item','none'),
(5826,'Alternative Chilly Cobol','false','none',2,'stackable','paper','none',-1,250,0,'true','true','true','true','C5Item','none'),
(5827,'Alternative Blue Cobol','false','none',2,'stackable','paper','none',-1,500,0,'true','true','true','true','C5Item','none'),
(5828,'Alternative Thorn Cobol','false','none',2,'stackable','paper','none',-1,500,0,'true','true','true','true','C5Item','none'),
(5829,'Alternative Golden Cobol','false','none',2,'stackable','paper','none',-1,500,0,'true','true','true','true','C5Item','none'),
(5830,'Alternative Great Cobol','false','none',2,'stackable','paper','none',-1,400,0,'true','true','true','true','C5Item','none'),
(5831,'Alternative Red Codran','false','none',2,'stackable','paper','none',-1,400,0,'true','true','true','true','C5Item','none'),
(5832,'Alternative Sea Codran','false','none',2,'stackable','paper','none',-1,500,0,'true','true','true','true','C5Item','none'),
(5833,'Alternative Chilly Codran','false','none',2,'stackable','paper','none',-1,400,0,'true','true','true','true','C5Item','none'),
(5834,'Alternative Blue Codran','false','none',2,'stackable','paper','none',-1,500,0,'true','true','true','true','C5Item','none'),
(5835,'Alternative Twin Codran','false','none',2,'stackable','paper','none',-1,500,0,'true','true','true','true','C5Item','none'),
(5836,'Alternative Great Codran','false','none',2,'stackable','paper','none',-1,750,0,'true','true','true','true','C5Item','none'),
(5837,'Alternative Desert Codran','false','none',2,'stackable','paper','none',-1,1000,0,'true','true','true','true','C5Item','none'),
(5838,'Mature Alternative Dark Coda','false','none',1,'stackable','paper','none',-1,0,0,'true','true','true','true','C5Item','none'),
(5839,'Mature Alternative Red Coda','false','none',1,'stackable','paper','none',-1,0,0,'true','true','true','true','C5Item','none'),
(5840,'Mature Alternative Chilly Coda','false','none',1,'stackable','paper','none',-1,0,0,'true','true','true','true','C5Item','none'),
(5841,'Mature Alternative Blue Coda','false','none',1,'stackable','paper','none',-1,0,0,'true','true','true','true','C5Item','none'),
(5842,'Mature Alternative Golden Coda','false','none',1,'stackable','paper','none',-1,0,0,'true','true','true','true','C5Item','none'),
(5843,'Mature Alternative Lute Coda','false','none',1,'stackable','paper','none',-1,0,0,'true','true','true','true','C5Item','none'),
(5844,'Mature Alternative Desert Coda','false','none',1,'stackable','paper','none',-1,0,0,'true','true','true','true','C5Item','none'),
(5845,'Mature Alternative Red Cobol','false','none',1,'stackable','paper','none',-1,0,0,'true','true','true','true','C5Item','none'),
(5846,'Mature Alternative Chilly Cobol','false','none',1,'stackable','paper','none',-1,0,0,'true','true','true','true','C5Item','none'),
(5847,'Mature Alternative Blue Cobol','false','none',1,'stackable','paper','none',-1,0,0,'true','true','true','true','C5Item','none'),
(5848,'Mature Alternative Thorn Cobol','false','none',1,'stackable','paper','none',-1,0,0,'true','true','true','true','C5Item','none'),
(5849,'Mature Alternative Golden Cobol','false','none',1,'stackable','paper','none',-1,0,0,'true','true','true','true','C5Item','none'),
(5850,'Mature Alternative Great Cobol','false','none',1,'stackable','paper','none',-1,0,0,'true','true','true','true','C5Item','none'),
(5851,'Mature Alternative Red Codran','false','none',1,'stackable','paper','none',-1,0,0,'true','true','true','true','C5Item','none'),
(5852,'Mature Alternative Sea Codran','false','none',1,'stackable','paper','none',-1,0,0,'true','true','true','true','C5Item','none'),
(5853,'Mature Alternative Chilly Codran','false','none',1,'stackable','paper','none',-1,0,0,'true','true','true','true','C5Item','none'),
(5854,'Mature Alternative Blue Codran','false','none',1,'stackable','paper','none',-1,0,0,'true','true','true','true','C5Item','none'),
(5855,'Mature Alternative Twin Codran','false','none',1,'stackable','paper','none',-1,0,0,'true','true','true','true','C5Item','none'),
(5856,'Mature Alternative Great Codran','false','none',1,'stackable','paper','none',-1,0,0,'true','true','true','true','C5Item','none'),
(5857,'Mature Alternative Desert Codran','false','none',1,'stackable','paper','none',-1,0,0,'true','true','true','true','C5Item','none'),
(5858,'Blessed Scroll of Escape: Clan Hall','false','scroll',120,'stackable','paper','none',-1,100000,0,'true','true','true','true','blessed_scroll_of_escape_to_agit','scroll'),
(5859,'Blessed Scroll of Escape: Castle','false','scroll',120,'stackable','paper','none',-1,0,0,'true','true','true','true','blessed_scroll_of_escape_to_castle','scroll'),
(5860,'Lienrik Egg','false','quest',0,'stackable','crystal','none',-1,0,0,'false','false','true','false','lienlik_egg1','none'),
(5861,'Lienrik Egg','false','quest',0,'stackable','crystal','none',-1,0,0,'false','false','true','false','lienlik_egg2','none'),
(5862,'Stone of Contract','false','quest',0,'stackable','crystal','none',-1,0,0,'false','false','true','false','stone_of_contract','none'),
(5863,'Alligator Tooth','false','quest',0,'stackable','crystal','none',-1,0,0,'false','false','true','false','croc_tooth','none'),
(5864,'Mysterious Map Piece','false','quest',0,'stackable','crystal','none',-1,0,0,'false','false','true','false','mysterious_map_piece','none'),
(5865,'Carnivore Spore','false','quest',0,'stackable','crystal','none',-1,0,0,'false','false','true','false','carnivore_spore','none'),
(5866,'Herbivorous Spore','false','quest',0,'stackable','crystal','none',-1,0,0,'false','false','true','false','herbivorous_spore','none'),
(5867,'Jade Crystal','false','quest',0,'stackable','crystal','none',-1,0,0,'false','false','true','false','jade_crystal','none'),
(5868,'Snake Scale','false','quest',0,'stackable','crystal','none',-1,0,0,'false','false','true','false','snake_scale','none'),
(5869,'Remains of Aden Residents','false','quest',0,'stackable','crystal','none',-1,0,0,'false','false','true','false','ash_of_doom_peoples','none'),
(5870,'Receipt of Supply','false','quest',0,'stackable','crystal','none',-1,0,0,'false','false','true','false','receipt_of_supply','none'),
(5871,'Suspicious Document Piece','false','quest',0,'stackable','crystal','none',-1,0,0,'false','false','true','false','piece_of_receipt','none'),
(5872,'Supply Items','false','quest',0,'stackable','crystal','none',-1,0,0,'false','false','true','false','supply','none'),
(5873,'Pirate\'s Treasure Chest','false','quest',0,'stackable','crystal','none',-1,0,0,'false','false','true','false','q_pirates_trbox','none'),
(5874,'Sairon\'s Silver Hair','false','quest',0,'stackable','crystal','none',-1,0,0,'false','false','true','false','q_saitnns_silver_hair','none'),
(5875,'Titan Lamp','false','quest',0,'stackable','crystal','none',-1,0,0,'false','false','true','false','q_giants_lamp1','none'),
(5876,'Titan Lamp','false','quest',0,'stackable','crystal','none',-1,0,0,'false','false','true','false','q_giants_lamp2','none'),
(5877,'Titan Lamp','false','quest',0,'stackable','crystal','none',-1,0,0,'false','false','true','false','q_giants_lamp3','none'),
(5878,'Titan Lamp','false','quest',0,'stackable','crystal','none',-1,0,0,'false','false','true','false','q_giants_lamp4','none'),
(5879,'Titan Lamp','false','quest',0,'stackable','crystal','none',-1,0,0,'false','false','true','false','q_giants_lamp5','none'),
(5880,'Broken Titan Lamp','false','quest',0,'stackable','crystal','none',-1,0,0,'false','false','true','false','q_giants_broken_lamp','none'),
(5881,'Blade Stakato Fang','false','quest',0,'stackable','crystal','none',-1,0,0,'false','false','true','false','q_blade_stakatos_fang','none'),
(5882,'Flare Shard','false','quest',0,'stackable','crystal','none',-1,0,0,'false','false','true','false','flair_shard','none'),
(5883,'Freezing Shard','false','quest',0,'stackable','crystal','none',-1,0,0,'false','false','true','false','freezing_shard','none'),
(5884,'Cave Beast Tooth','false','quest',0,'stackable','crystal','none',-1,0,0,'false','false','true','false','q_cave_beast_tooth','none'),
(5885,'Death Wave Light','false','quest',0,'stackable','crystal','none',-1,0,0,'false','false','true','false','q_death_wave_light','none'),
(5886,'Sealed Mysterious Stone','false','quest',0,'stackable','crystal','none',-1,0,0,'false','false','true','false','q_sealed_mysterius_stone','none'),
(5887,'Mysterious Stone','false','quest',0,'stackable','crystal','none',-1,0,0,'false','false','true','false','q_mysterius_stone','none'),
(5888,'Karik Horn','false','quest',0,'stackable','crystal','none',-1,0,0,'false','false','true','false','q_karik_horn','none'),
(5889,'Cave Howler Skull','false','quest',0,'stackable','crystal','none',-1,0,0,'false','false','true','false','q_cave_howler_skull','none'),
(5890,'Mysterious Book','false','quest',0,'stackable','crystal','none',-1,0,0,'false','false','true','false','q_mysterius_book','none'),
(5891,'Ancient Language Dictionary: Basic Level','false','quest',0,'stackable','crystal','none',-1,0,0,'false','false','true','false','q_ancient_lang_dic1','none'),
(5892,'Ancient Language Dictionary: Intermediate Level','false','quest',0,'stackable','crystal','none',-1,0,0,'false','false','true','false','q_ancient_lang_dic2','none'),
(5893,'Leaf of Eucalyptus','false','quest',0,'stackable','crystal','none',-1,0,0,'false','false','true','false','leaf_of_eucalyptus','none'),
(5894,'Stone of Chill','false','quest',0,'stackable','crystal','none',-1,0,0,'false','false','true','false','stone_of_chill','none'),
(5895,'Ritron\'s Fruit','false','quest',0,'stackable','crystal','none',-1,0,0,'false','false','true','false','ritron','none'),
(5896,'Moon Face Flower','false','quest',0,'stackable','crystal','none',-1,0,0,'false','false','true','false','moon_face_flower','none'),
(5897,'Leech Fluids','false','quest',0,'stackable','crystal','none',-1,0,0,'false','false','true','false','body_fluid_of_leech','none'),
(5898,'Royal Membership','false','quest',0,'stackable','crystal','none',-1,0,0,'false','false','true','false','q_royal_membership','none'),
(5899,'Kail\'s Coin','false','quest',0,'stackable','crystal','none',-1,0,0,'false','false','true','false','q_kails_coin','none'),
(5900,'Coin Collecting Album','false','none',0,'stackable','liquid','none',-1,0,0,'false','false','true','false','q_book_of_coin_collect','none'),
(5901,'Blood Offering','false','quest',0,'stackable','crystal','none',-1,0,0,'false','false','true','false','q_blood_of_offering','none'),
(5902,'Scroll of Ancient Magic','false','quest',0,'stackable','crystal','none',-1,0,0,'false','false','true','false','q_scroll_of_ancient_magic','none'),
(5903,'Ancient Ash Urn','false','quest',0,'stackable','crystal','none',-1,0,0,'false','false','true','false','ancient_funeral_urn','none'),
(5904,'Wesley\'s Mixing Stone','false','quest',0,'stackable','crystal','none',-1,0,0,'false','false','true','false','wesleys_mixing_stone','none'),
(5905,'Magister\'s Mixing Stone','false','quest',0,'stackable','crystal','none',-1,0,0,'false','false','true','false','magisters_mixing_stone','none'),
(5906,'(Not used) Red Soul Crystal: Grade 11','false','scroll',20,'normal','crystal','none',-1,0,0,'true','true','true','true','_red_soul_crystal_11','scroll'),
(5907,'(Not used) Red Soul Crystal: Grade 12','false','scroll',20,'normal','crystal','none',-1,0,0,'true','true','true','true','_red_soul_crystal_12','scroll'),
(5908,'Red Soul Crystal: Grade 13','false','scroll',20,'normal','crystal','none',-1,0,0,'true','true','true','true','red_soul_crystal_13','scroll'),
(5909,'(Not used) Green Soul Crystal: Grade 11','false','scroll',20,'normal','crystal','none',-1,0,0,'true','true','true','true','_green_soul_crystal_11','scroll'),
(5910,'(Not used) Green Soul Crystal: Grade 12','false','scroll',20,'normal','crystal','none',-1,0,0,'true','true','true','true','_green_soul_crystal_12','scroll'),
(5911,'Green Soul Crystal: Grade 13','false','scroll',20,'normal','crystal','none',-1,0,0,'true','true','true','true','green_soul_crystal_13','scroll'),
(5912,'(Not used) Blue Soul Crystal: Grade 11','false','scroll',20,'normal','crystal','none',-1,0,0,'true','true','true','true','_blue_soul_crystal_11','scroll'),
(5913,'(Not used) Blue Soul Crystal: Grade 12','false','scroll',20,'normal','crystal','none',-1,0,0,'true','true','true','true','_blue_soul_crystal_12','scroll'),
(5914,'Blue Soul Crystal: Grade 13','false','scroll',20,'normal','crystal','none',-1,0,0,'true','true','true','true','blue_soul_crystal_13','scroll'),
(5915,'Pirate\'s Treasure Map','false','none',0,'stackable','liquid','none',-1,200,0,'true','true','true','true','pirates_treasure_map','none'),
(5916,'Spellbook Page','false','none',0,'stackable','liquid','none',-1,0,0,'true','true','true','true','page_of_spellbook','none'),
(5917,'Kranvel\'s Spellbook: Chapter of Fire','false','none',0,'stackable','liquid','none',-1,100,0,'true','true','true','true','kranvels_spellbook_chpt_fire','none'),
(5918,'Kranvel\'s Spellbook: Chapter of Water','false','none',0,'stackable','liquid','none',-1,100,0,'true','true','true','true','kranvels_spellbook_chpt_water','none'),
(5919,'Kranvel\'s Spellbook: Chapter of Wind','false','none',0,'stackable','liquid','none',-1,100,0,'true','true','true','true','kranvels_spellbook_chpt_wind','none'),
(5920,'Kranvel\'s Spellbook: Chapter of Earth','false','none',0,'stackable','liquid','none',-1,100,0,'true','true','true','true','kranvels_spellbook_chpt_earth','none'),
(5921,'Worthless Piece of Paper','false','none',0,'stackable','liquid','none',-1,0,0,'true','true','true','true','useless_piece_of_paper','none'),
(5922,'Blueprint: Giants Golem 1','false','none',0,'stackable','liquid','none',-1,100,0,'true','true','true','true','q_giants_plan_of_golem1','none'),
(5923,'Blueprint: Giants Golem 2','false','none',0,'stackable','liquid','none',-1,100,0,'true','true','true','true','q_giants_plan_of_golem2','none'),
(5924,'Blueprint: Giants Golem 3','false','none',0,'stackable','liquid','none',-1,100,0,'true','true','true','true','q_giants_plan_of_golem3','none'),
(5925,'Blueprint: Giants Golem 4','false','none',0,'stackable','liquid','none',-1,100,0,'true','true','true','true','q_giants_plan_of_golem4','none'),
(5926,'Blueprint: Giants Golem 5','false','none',0,'stackable','liquid','none',-1,100,0,'true','true','true','true','q_giants_plan_of_golem5','none'),
(5927,'Book: Basics of Giants Magic,Chapter 1','false','none',0,'stackable','liquid','none',-1,100,0,'true','true','true','true','q_giants_basis_of_magic1','none'),
(5928,'Book: Basics of Giants Magic,Chapter 2','false','none',0,'stackable','liquid','none',-1,100,0,'true','true','true','true','q_giants_basis_of_magic2','none'),
(5929,'Book: Basics of Giants Magic,Chapter 3','false','none',0,'stackable','liquid','none',-1,100,0,'true','true','true','true','q_giants_basis_of_magic3','none'),
(5930,'Book: Basics of Giants Magic,Chapter 4','false','none',0,'stackable','liquid','none',-1,100,0,'true','true','true','true','q_giants_basis_of_magic4','none'),
(5931,'Book: Basics of Giants Magic,Chapter 5','false','none',0,'stackable','liquid','none',-1,100,0,'true','true','true','true','q_giants_basis_of_magic5','none'),
(5932,'Handbook: Giants Architecture,Chapter 1','false','none',0,'stackable','liquid','none',-1,100,0,'true','true','true','true','q_giants_construction_tech1','none'),
(5933,'Handbook: Giants Architecture,Chapter 2','false','none',0,'stackable','liquid','none',-1,100,0,'true','true','true','true','q_giants_construction_tech2','none'),
(5934,'Handbook: Giants Architecture,Chapter 3','false','none',0,'stackable','liquid','none',-1,100,0,'true','true','true','true','q_giants_construction_tech3','none'),
(5935,'Handbook: Giants Architecture,Chapter 4','false','none',0,'stackable','liquid','none',-1,100,0,'true','true','true','true','q_giants_construction_tech4','none'),
(5936,'Handbook: Giants Architecture,Chapter 5','false','none',0,'stackable','liquid','none',-1,100,0,'true','true','true','true','q_giants_construction_tech5','none'),
(5937,'Book: Giants Medical Science,Chapter 1','false','none',0,'stackable','liquid','none',-1,100,0,'true','true','true','true','q_giants_medical_theory1','none'),
(5938,'Book: Giants Medical Science,Chapter 2','false','none',0,'stackable','liquid','none',-1,100,0,'true','true','true','true','q_giants_medical_theory2','none'),
(5939,'Book: Giants Medical Science,Chapter 3','false','none',0,'stackable','liquid','none',-1,100,0,'true','true','true','true','q_giants_medical_theory3','none'),
(5940,'Book: Giants Medical Science,Chapter 4','false','none',0,'stackable','liquid','none',-1,100,0,'true','true','true','true','q_giants_medical_theory4','none'),
(5941,'Book: Giants Medical Science,Chapter 5','false','none',0,'stackable','liquid','none',-1,100,0,'true','true','true','true','q_giants_medical_theory5','none'),
(5942,'Giant\'s Love Letter','false','none',0,'stackable','liquid','none',-1,100,0,'true','true','true','true','q_giants_love_letter','none'),
(5943,'Giants'' Doodle','false','none',0,'stackable','liquid','none',-1,100,0,'true','true','true','true','q_giants_scribble','none'),
(5944,'Ancient Parchment','false','none',0,'stackable','liquid','none',-1,100,0,'true','true','true','true','q_giants_scroll','none'),
(5945,'Book: Giants Science & Technology,Chapter 1','false','none',0,'stackable','liquid','none',-1,100,0,'true','true','true','true','q_giants_science_basis1','none'),
(5946,'Book: Giants Science & Technology,Chapter 2','false','none',0,'stackable','liquid','none',-1,100,0,'true','true','true','true','q_giants_science_basis2','none'),
(5947,'Book: Giants Science & Technology,Chapter 3','false','none',0,'stackable','liquid','none',-1,100,0,'true','true','true','true','q_giants_science_basis3','none'),
(5948,'Book: Giants Science & Technology,Chapter 4','false','none',0,'stackable','liquid','none',-1,100,0,'true','true','true','true','q_giants_science_basis4','none'),
(5949,'Book: Giants Science & Technology,Chapter 5','false','none',0,'stackable','liquid','none',-1,100,0,'true','true','true','true','q_giants_science_basis5','none'),
(5950,'Almanac: Titan Culture,Chapter 1','false','none',0,'stackable','liquid','none',-1,100,0,'true','true','true','true','q_giants_culture1','none'),
(5951,'Almanac: Titan Culture,Chapter 2','false','none',0,'stackable','liquid','none',-1,100,0,'true','true','true','true','q_giants_culture2','none'),
(5952,'Almanac: Titan Culture,Chapter 3','false','none',0,'stackable','liquid','none',-1,100,0,'true','true','true','true','q_giants_culture3','none'),
(5953,'Almanac: Titan Culture,Chapter 4','false','none',0,'stackable','liquid','none',-1,100,0,'true','true','true','true','q_giants_culture4','none'),
(5954,'Almanac: Titan Culture,Chapter 5','false','none',0,'stackable','liquid','none',-1,100,0,'true','true','true','true','q_giants_culture5','none'),
(5955,'Ancient Titan Book','false','none',0,'stackable','liquid','none',-1,100,0,'true','true','true','true','q_giants_book','none'),
(5956,'15 Year Old Wine','false','none',20,'stackable','liquid','none',-1,5000,0,'true','true','true','true','sound_wine1','none'),
(5957,'30 Year Old Wine','false','none',20,'stackable','liquid','none',-1,5000,0,'true','true','true','true','sound_wine2','none'),
(5958,'60 Year Old Wine','false','none',20,'stackable','liquid','none',-1,5000,0,'true','true','true','true','sound_wine3','none'),
(5959,'Ritron\'s Dessert Recipe','false','none',10,'normal','liquid','none',-1,40000,0,'true','true','true','true','recipe_of_ritron','none'),
(5960,'Ritron Jelly','false','none',10,'normal','liquid','none',-1,1920,0,'true','true','true','true','dessert_of_ritron','none'),
(5961,'Kail\'s Silver Basilisk','false','none',0,'stackable','liquid','none',-1,1000,0,'true','true','true','true','q_kails_silver_basilisk','none'),
(5962,'Kail\'s Gold Golem','false','none',0,'stackable','liquid','none',-1,1000,0,'true','true','true','true','q_kails_gold_golem','none'),
(5963,'Kail\'s Blood Dragon','false','none',0,'stackable','liquid','none',-1,1000,0,'true','true','true','true','q_kails_blood_dragon','none'),
(5964,'Warehouse Keeper\'s Medal','false','quest',0,'stackable','liquid','none',-1,100,0,'true','true','true','true','q_irongate_medal','none'),
(5965,'Blank Scroll','false','none',0,'stackable','liquid','none',-1,500,0,'true','true','true','true','q_blank_scrl','none'),
(5966,'Ancient Red Papyrus','false','none',0,'stackable','liquid','none',-1,400,0,'true','true','true','true','ancient_papyrus1','none'),
(5967,'Ancient Blue Papyrus','false','none',0,'stackable','liquid','none',-1,400,0,'true','true','true','true','ancient_papyrus2','none'),
(5968,'Ancient Black Papyrus','false','none',0,'stackable','liquid','none',-1,400,0,'true','true','true','true','ancient_papyrus3','none'),
(5969,'Ancient White Papyrus','false','none',0,'stackable','liquid','none',-1,400,0,'true','true','true','true','ancient_papyrus4','none'),
(5970,'Ancient Chain Letter','false','none',0,'stackable','liquid','none',-1,400,0,'true','true','true','true','ancient_chain_letter','none'),
(5971,'Ancient Joke Book','false','none',0,'stackable','liquid','none',-1,400,0,'true','true','true','true','ancient_joke_book','none'),
(5972,'Revelation of the Seals: Chapter of Avarice','false','none',0,'stackable','liquid','none',-1,400,0,'true','true','true','true','revelation_avarice','none'),
(5973,'Revelation of the Seals: Chapter of Gnosis','false','none',0,'stackable','liquid','none',-1,400,0,'true','true','true','true','revelation_gnosis','none'),
(5974,'Revelation of the Seals: Chapter of Strife','false','none',0,'stackable','liquid','none',-1,400,0,'true','true','true','true','revelation_strife','none'),
(5975,'Revelation of the Seals: Chapter of Vengeance','false','none',0,'stackable','liquid','none',-1,400,0,'true','true','true','true','revelation_vengeance','none'),
(5976,'Revelation of the Seals: Chapter of Awakening','false','none',0,'stackable','liquid','none',-1,400,0,'true','true','true','true','revelation_awakening','none'),
(5977,'Revelation of the Seals: Chapter of Calamity','false','none',0,'stackable','liquid','none',-1,400,0,'true','true','true','true','revelation_calamity','none'),
(5978,'Revelation of the Seals: Chapter of Descent','false','none',0,'stackable','liquid','none',-1,400,0,'true','true','true','true','revelation_descent','none'),
(5979,'Ancient Epic,Chapter 1','false','none',0,'stackable','liquid','none',-1,400,0,'true','true','true','true','ancient_epic_part1','none'),
(5980,'Ancient Epic,Chapter 2','false','none',0,'stackable','liquid','none',-1,400,0,'true','true','true','true','ancient_epic_part2','none'),
(5981,'Ancient Epic,Chapter 3','false','none',0,'stackable','liquid','none',-1,400,0,'true','true','true','true','ancient_epic_part3','none'),
(5982,'Ancient Epic,Chapter 4','false','none',0,'stackable','liquid','none',-1,400,0,'true','true','true','true','ancient_epic_part4','none'),
(5983,'Ancient Epic,Chapter 5','false','none',0,'stackable','liquid','none',-1,400,0,'true','true','true','true','ancient_epic_part5','none'),
(5984,'Imperial Genealogy 1','false','none',0,'stackable','liquid','none',-1,400,0,'true','true','true','true','imperial_genealogy1','none'),
(5985,'Imperial Genealogy 2','false','none',0,'stackable','liquid','none',-1,400,0,'true','true','true','true','imperial_genealogy2','none'),
(5986,'Imperial Genealogy 3','false','none',0,'stackable','liquid','none',-1,400,0,'true','true','true','true','imperial_genealogy3','none'),
(5987,'Imperial Genealogy 4','false','none',0,'stackable','liquid','none',-1,400,0,'true','true','true','true','imperial_genealogy4','none'),
(5988,'Imperial Genealogy 5','false','none',0,'stackable','liquid','none',-1,400,0,'true','true','true','true','imperial_genealogy5','none'),
(5989,'Blueprint: Tower of Insolence,1st Floor','false','none',0,'stackable','liquid','none',-1,400,0,'true','true','true','true','tower_blueprint1','none'),
(5990,'Blueprint: Tower of Insolence,2nd Floor','false','none',0,'stackable','liquid','none',-1,400,0,'true','true','true','true','tower_blueprint2','none'),
(5991,'Blueprint: Tower of Insolence,3rd Floor','false','none',0,'stackable','liquid','none',-1,400,0,'true','true','true','true','tower_blueprint3','none'),
(5992,'Blueprint: Tower of Insolence,4th Floor','false','none',0,'stackable','liquid','none',-1,400,0,'true','true','true','true','tower_blueprint4','none'),
(5993,'Blueprint: Tower of Insolence,5th Floor','false','none',0,'stackable','liquid','none',-1,400,0,'true','true','true','true','tower_blueprint5','none'),
(5994,'Blueprint: Tower of Insolence,6th Floor','false','none',0,'stackable','liquid','none',-1,400,0,'true','true','true','true','tower_blueprint6','none'),
(5995,'Blueprint: Tower of Insolence,7th Floor','false','none',0,'stackable','liquid','none',-1,400,0,'true','true','true','true','tower_blueprint7','none'),
(5996,'Blueprint: Tower of Insolence,8th Floor','false','none',0,'stackable','liquid','none',-1,400,0,'true','true','true','true','tower_blueprint8','none'),
(5997,'Blueprint: Tower of Insolence,9th Floor','false','none',0,'stackable','liquid','none',-1,400,0,'true','true','true','true','tower_blueprint9','none'),
(5998,'Blueprint: Tower of Insolence,10th Floor','false','none',0,'stackable','liquid','none',-1,400,0,'true','true','true','true','tower_blueprint10','none'),
(5999,'Blueprint: Tower of Insolence,11th Floor','false','none',0,'stackable','liquid','none',-1,400,0,'true','true','true','true','tower_blueprint11','none'),
(6000,'Blueprint: Tower of Insolence,12th Floor','false','none',0,'stackable','liquid','none',-1,400,0,'true','true','true','true','tower_blueprint12','none'),
(6001,'Blueprint: Tower of Insolence,13th Floor','false','none',0,'stackable','liquid','none',-1,400,0,'true','true','true','true','tower_blueprint13','none'),
(6002,'Ancient Porcelain','false','none',10,'stackable','liquid','none',-1,8000,0,'true','true','true','true','ancient_porcelain','none'),
(6003,'Ancient Porcelain: Excellent','false','none',10,'stackable','liquid','none',-1,12000,0,'true','true','true','true','ancient_porcelain_s','none'),
(6004,'Ancient Porcelain: High Quality','false','none',10,'stackable','liquid','none',-1,8000,0,'true','true','true','true','ancient_porcelain_a','none'),
(6005,'Ancient Porcelain: Low Quality','false','none',10,'stackable','liquid','none',-1,5000,0,'true','true','true','true','ancient_porcelain_b','none'),
(6006,'Ancient Porcelain: Lowest Quality','false','none',10,'stackable','liquid','none',-1,2000,0,'true','true','true','true','ancient_porcelain_c','none'),
(6007,'Reagent Pouch','false','none',0,'stackable','liquid','none',-1,0,0,'true','true','true','true','ingredient_pouch1','none'),
(6008,'Reagent Pouch','false','none',0,'stackable','liquid','none',-1,0,0,'true','true','true','true','ingredient_pouch2','none'),
(6009,'Reagent Pouch','false','none',0,'stackable','liquid','none',-1,0,0,'true','true','true','true','ingredient_pouch3','none'),
(6010,'Reagent Box','false','none',0,'stackable','liquid','none',-1,0,0,'true','true','true','true','ingredient_box','none'),
(6011,'Wyrm\'s Blood','false','none',0,'stackable','liquid','none',-1,200,0,'true','true','true','true','wyrms_blood','none'),
(6012,'Lava Stone','false','none',0,'stackable','liquid','none',-1,200,0,'true','true','true','true','lava_stone','none'),
(6013,'Moonstone Shard','false','none',0,'stackable','liquid','none',-1,200,0,'true','true','true','true','moonstone_shard','none'),
(6014,'Rotten Bone Piece','false','none',0,'stackable','liquid','none',-1,200,0,'true','true','true','true','decaying_bone','none'),
(6015,'Demon\'s Blood','false','none',0,'stackable','liquid','none',-1,200,0,'true','true','true','true','demons_blood','none'),
(6016,'Infernium Ore','false','none',0,'stackable','liquid','none',-1,200,0,'true','true','true','true','infernium_ore','none'),
(6017,'Blood Root','false','none',0,'stackable','liquid','none',-1,200,0,'true','true','true','true','blood_root','none'),
(6018,'Volcanic Ash','false','none',0,'stackable','liquid','none',-1,100,0,'true','true','true','true','volcanic_ash','none'),
(6019,'Quicksilver','false','none',0,'stackable','liquid','none',-1,200,0,'true','true','true','true','quicksilver','none'),
(6020,'Sulfur','false','none',0,'stackable','liquid','none',-1,200,0,'true','true','true','true','sulfur','none'),
(6021,'Dracoplasm','false','none',0,'stackable','liquid','none',-1,0,0,'true','true','true','true','dracoplasm','none'),
(6022,'Magma Dust','false','none',0,'stackable','liquid','none',-1,0,0,'true','true','true','true','magma_dust','none'),
(6023,'Moon Dust','false','none',0,'stackable','liquid','none',-1,0,0,'true','true','true','true','moon_dust','none'),
(6024,'Necroplasm','false','none',0,'stackable','liquid','none',-1,0,0,'true','true','true','true','necroplasm','none'),
(6025,'Demonplasm','false','none',0,'stackable','liquid','none',-1,2500,0,'true','true','true','true','demonplasm','none'),
(6026,'Inferno Dust','false','none',0,'stackable','liquid','none',-1,0,0,'true','true','true','true','inferno_dust','none'),
(6027,'Draconic Essence','false','none',0,'stackable','liquid','none',-1,0,0,'true','true','true','true','draconic_essence','none'),
(6028,'Fire Essence','false','none',0,'stackable','liquid','none',-1,2500,0,'true','true','true','true','fire_essence','none'),
(6029,'Lunargent','false','none',0,'stackable','liquid','none',-1,2500,0,'true','true','true','true','lunargent','none'),
(6030,'Midnight Oil','false','none',0,'stackable','liquid','none',-1,0,0,'true','true','true','true','midnight_oil','none'),
(6031,'Demonic Essence','false','none',0,'stackable','liquid','none',-1,2500,0,'true','true','true','true','demonic_essence','none'),
(6032,'Abyss Oil','false','none',0,'stackable','liquid','none',-1,0,0,'true','true','true','true','abyss_oil','none'),
(6033,'Hellfire Oil','false','none',0,'stackable','liquid','none',-1,0,0,'true','true','true','true','hellfire_oil','none'),
(6034,'Nightmare Oil','false','none',0,'stackable','liquid','none',-1,5000,0,'true','true','true','true','nightmare_oil','none'),
(6035,'Magic Haste Potion','false','potion',20,'stackable','liquid','none',-1,2400,0,'true','true','true','true','potion_of_acumen2','potion'),
(6036,'Greater Magic Haste Potion','false','potion',20,'stackable','liquid','none',-1,7200,0,'true','true','true','true','potion_of_acumen3','potion'),
(6037,'Waking Scroll','false','scroll',5,'stackable','paper','none',-1,100,0,'true','true','true','true','scroll_of_awake','scroll'),
(6038,'Greater Mercenary Posting Ticket (Sword/Stationary)','false','castle_guard',0,'stackable','paper','none',-1,0,0,'true','true','true','true','adv_mticket_gludio_sword_fix','castle_guard'),
(6039,'Greater Mercenary Posting Ticket (Spear/Stationary)','false','castle_guard',0,'stackable','paper','none',-1,0,0,'true','true','true','true','adv_mticket_gludio_pole_fix','castle_guard'),
(6040,'Greater Mercenary Posting Ticket (Bow/Stationary)','false','castle_guard',0,'stackable','paper','none',-1,0,0,'true','true','true','true','adv_mticket_gludio_bow_fix','castle_guard'),
(6041,'Greater Mercenary Posting Ticket (Cleric/Stationary)','false','castle_guard',0,'stackable','paper','none',-1,0,0,'true','true','true','true','adv_mticket_gludio_cleric_fix','castle_guard'),
(6042,'Greater Mercenary Posting Ticket (Wizard/Stationary)','false','castle_guard',0,'stackable','paper','none',-1,0,0,'true','true','true','true','adv_mticket_gludio_wizard_fix','castle_guard'),
(6043,'Greater Mercenary Posting Ticket (Sword/Mobile)','false','castle_guard',0,'stackable','paper','none',-1,0,0,'true','true','true','true','adv_mticket_gludio_sword_move','castle_guard'),
(6044,'Greater Mercenary Posting Ticket (Spear/Mobile)','false','castle_guard',0,'stackable','paper','none',-1,0,0,'true','true','true','true','adv_mticket_gludio_pole_move','castle_guard'),
(6045,'Greater Mercenary Posting Ticket (Bow/Mobile)','false','castle_guard',0,'stackable','paper','none',-1,0,0,'true','true','true','true','adv_mticket_gludio_bow_move','castle_guard'),
(6046,'Greater Mercenary Posting Ticket (Cleric/Mobile)','false','castle_guard',0,'stackable','paper','none',-1,0,0,'true','true','true','true','adv_mticket_gludio_cleric_move','castle_guard'),
(6047,'Greater Mercenary Posting Ticket (Wizard/Mobile)','false','castle_guard',0,'stackable','paper','none',-1,0,0,'true','true','true','true','adv_mticket_gludio_wizard_move','castle_guard'),
(6048,'Trash - Trash','false','castle_guard',0,'stackable','paper','none',-1,0,0,'true','true','true','true','__golden_coda_seed_5','castle_guard'),
(6049,'Trash - Trash','false','castle_guard',0,'stackable','paper','none',-1,0,0,'true','true','true','true','__golden_coda_seed_5','castle_guard'),
(6050,'Trash - Trash','false','castle_guard',0,'stackable','paper','none',-1,0,0,'true','true','true','true','__golden_coda_seed_5','castle_guard'),
(6051,'Greater Mercenary Posting Ticket (Sword/Stationary)','false','castle_guard',0,'stackable','paper','none',-1,0,0,'true','true','true','true','adv_mticket_dion_sword_fix','castle_guard'),
(6052,'Greater Mercenary Posting Ticket (Spear/Stationary)','false','castle_guard',0,'stackable','paper','none',-1,0,0,'true','true','true','true','adv_mticket_dion_pole_fix','castle_guard'),
(6053,'Greater Mercenary Posting Ticket (Bow/Stationary)','false','castle_guard',0,'stackable','paper','none',-1,0,0,'true','true','true','true','adv_mticket_dion_bow_fix','castle_guard'),
(6054,'Greater Mercenary Posting Ticket (Cleric/Stationary)','false','castle_guard',0,'stackable','paper','none',-1,0,0,'true','true','true','true','adv_mticket_dion_cleric_fix','castle_guard'),
(6055,'Greater Mercenary Posting Ticket (Wizard/Stationary)','false','castle_guard',0,'stackable','paper','none',-1,0,0,'true','true','true','true','adv_mticket_dion_wizard_fix','castle_guard'),
(6056,'Greater Mercenary Posting Ticket (Sword/Mobile)','false','castle_guard',0,'stackable','paper','none',-1,0,0,'true','true','true','true','adv_mticket_dion_sword_move','castle_guard'),
(6057,'Greater Mercenary Posting Ticket (Spear/Mobile)','false','castle_guard',0,'stackable','paper','none',-1,0,0,'true','true','true','true','adv_mticket_dion_pole_move','castle_guard'),
(6058,'Greater Mercenary Posting Ticket (Bow/Mobile)','false','castle_guard',0,'stackable','paper','none',-1,0,0,'true','true','true','true','adv_mticket_dion_bow_move','castle_guard'),
(6059,'Greater Mercenary Posting Ticket (Cleric/Mobile)','false','castle_guard',0,'stackable','paper','none',-1,0,0,'true','true','true','true','adv_mticket_dion_cleric_move','castle_guard'),
(6060,'Greater Mercenary Posting Ticket (Wizard/Mobile)','false','castle_guard',0,'stackable','paper','none',-1,0,0,'true','true','true','true','adv_mticket_dion_wizard_move','castle_guard'),
(6061,'Trash - Trash','false','castle_guard',0,'stackable','paper','none',-1,0,0,'true','true','true','true','__golden_coda_seed_5','castle_guard'),
(6062,'Trash - Trash','false','castle_guard',0,'stackable','paper','none',-1,0,0,'true','true','true','true','__golden_coda_seed_5','castle_guard'),
(6063,'Trash - Trash','false','castle_guard',0,'stackable','paper','none',-1,0,0,'true','true','true','true','__golden_coda_seed_5','castle_guard'),
(6064,'Greater Mercenary Posting Ticket (Sword/Stationary)','false','castle_guard',0,'stackable','paper','none',-1,0,0,'true','true','true','true','adv_mticket_giran_sword_fix','castle_guard'),
(6065,'Greater Mercenary Posting Ticket (Spear/Stationary)','false','castle_guard',0,'stackable','paper','none',-1,0,0,'true','true','true','true','adv_mticket_giran_pole_fix','castle_guard'),
(6066,'Greater Mercenary Posting Ticket (Bow/Stationary)','false','castle_guard',0,'stackable','paper','none',-1,0,0,'true','true','true','true','adv_mticket_giran_bow_fix','castle_guard'),
(6067,'Greater Mercenary Posting Ticket (Cleric/Stationary)','false','castle_guard',0,'stackable','paper','none',-1,0,0,'true','true','true','true','adv_mticket_giran_cleric_fix','castle_guard'),
(6068,'Greater Mercenary Posting Ticket (Wizard/Stationary)','false','castle_guard',0,'stackable','paper','none',-1,0,0,'true','true','true','true','adv_mticket_giran_wizard_fix','castle_guard'),
(6069,'Greater Mercenary Posting Ticket (Sword/Mobile)','false','castle_guard',0,'stackable','paper','none',-1,0,0,'true','true','true','true','adv_mticket_giran_sword_move','castle_guard'),
(6070,'Greater Mercenary Posting Ticket (Spear/Mobile)','false','castle_guard',0,'stackable','paper','none',-1,0,0,'true','true','true','true','adv_mticket_giran_pole_move','castle_guard'),
(6071,'Greater Mercenary Posting Ticket (Bow/Mobile)','false','castle_guard',0,'stackable','paper','none',-1,0,0,'true','true','true','true','adv_mticket_giran_bow_move','castle_guard'),
(6072,'Greater Mercenary Posting Ticket (Cleric/Mobile)','false','castle_guard',0,'stackable','paper','none',-1,0,0,'true','true','true','true','adv_mticket_giran_cleric_move','castle_guard'),
(6073,'Greater Mercenary Posting Ticket (Wizard/Mobile)','false','castle_guard',0,'stackable','paper','none',-1,0,0,'true','true','true','true','adv_mticket_giran_wizard_move','castle_guard'),
(6074,'Trash - Trash','false','castle_guard',0,'stackable','paper','none',-1,0,0,'true','true','true','true','__golden_coda_seed_5','castle_guard'),
(6075,'Trash - Trash','false','castle_guard',0,'stackable','paper','none',-1,0,0,'true','true','true','true','__golden_coda_seed_5','castle_guard'),
(6076,'Trash - Trash','false','castle_guard',0,'stackable','paper','none',-1,0,0,'true','true','true','true','__golden_coda_seed_5','castle_guard'),
(6077,'Greater Mercenary Posting Ticket (Sword/Stationary)','false','castle_guard',0,'stackable','paper','none',-1,0,0,'true','true','true','true','adv_mticket_oren_sword_fix','castle_guard'),
(6078,'Greater Mercenary Posting Ticket (Spear/Stationary)','false','castle_guard',0,'stackable','paper','none',-1,0,0,'true','true','true','true','adv_mticket_oren_pole_fix','castle_guard'),
(6079,'Greater Mercenary Posting Ticket (Bow/Stationary)','false','castle_guard',0,'stackable','paper','none',-1,0,0,'true','true','true','true','adv_mticket_oren_bow_fix','castle_guard'),
(6080,'Greater Mercenary Posting Ticket (Cleric/Stationary)','false','castle_guard',0,'stackable','paper','none',-1,0,0,'true','true','true','true','adv_mticket_oren_cleric_fix','castle_guard'),
(6081,'Greater Mercenary Posting Ticket (Wizard/Stationary)','false','castle_guard',0,'stackable','paper','none',-1,0,0,'true','true','true','true','adv_mticket_oren_wizard_fix','castle_guard'),
(6082,'Greater Mercenary Posting Ticket (Sword/Mobile)','false','castle_guard',0,'stackable','paper','none',-1,0,0,'true','true','true','true','adv_mticket_oren_sword_move','castle_guard'),
(6083,'Greater Mercenary Posting Ticket (Spear/Mobile)','false','castle_guard',0,'stackable','paper','none',-1,0,0,'true','true','true','true','adv_mticket_oren_pole_move','castle_guard'),
(6084,'Greater Mercenary Posting Ticket (Bow/Mobile)','false','castle_guard',0,'stackable','paper','none',-1,0,0,'true','true','true','true','adv_mticket_oren_bow_move','castle_guard'),
(6085,'Greater Mercenary Posting Ticket (Cleric/Mobile)','false','castle_guard',0,'stackable','paper','none',-1,0,0,'true','true','true','true','adv_mticket_oren_cleric_move','castle_guard'),
(6086,'Greater Mercenary Posting Ticket (Wizard/Mobile)','false','castle_guard',0,'stackable','paper','none',-1,0,0,'true','true','true','true','adv_mticket_oren_wizard_move','castle_guard'),
(6087,'Trash - Trash','false','castle_guard',0,'stackable','paper','none',-1,0,0,'true','true','true','true','__golden_coda_seed_5','castle_guard'),
(6088,'Trash - Trash','false','castle_guard',0,'stackable','paper','none',-1,0,0,'true','true','true','true','__golden_coda_seed_5','castle_guard'),
(6089,'Trash - Trash','false','castle_guard',0,'stackable','paper','none',-1,0,0,'true','true','true','true','__golden_coda_seed_5','castle_guard'),
(6090,'Greater Mercenary Posting Ticket (Sword/Stationary)','false','castle_guard',0,'stackable','paper','none',-1,0,0,'true','true','true','true','adv_mticket_aden_sword_fix','castle_guard'),
(6091,'Greater Mercenary Posting Ticket (Spear/Stationary)','false','castle_guard',0,'stackable','paper','none',-1,0,0,'true','true','true','true','adv_mticket_aden_pole_fix','castle_guard'),
(6092,'Greater Mercenary Posting Ticket (Bow/Stationary)','false','castle_guard',0,'stackable','paper','none',-1,0,0,'true','true','true','true','adv_mticket_aden_bow_fix','castle_guard'),
(6093,'Greater Mercenary Posting Ticket (Cleric/Stationary)','false','castle_guard',0,'stackable','paper','none',-1,0,0,'true','true','true','true','adv_mticket_aden_cleric_fix','castle_guard'),
(6094,'Greater Mercenary Posting Ticket (Wizard/Stationary)','false','castle_guard',0,'stackable','paper','none',-1,0,0,'true','true','true','true','adv_mticket_aden_wizard_fix','castle_guard'),
(6095,'Greater Mercenary Posting Ticket (Sword/Mobile)','false','castle_guard',0,'stackable','paper','none',-1,0,0,'true','true','true','true','adv_mticket_aden_sword_move','castle_guard'),
(6096,'Greater Mercenary Posting Ticket (Spear/Mobile)','false','castle_guard',0,'stackable','paper','none',-1,0,0,'true','true','true','true','adv_mticket_aden_pole_move','castle_guard'),
(6097,'Greater Mercenary Posting Ticket (Bow/Mobile)','false','castle_guard',0,'stackable','paper','none',-1,0,0,'true','true','true','true','adv_mticket_aden_bow_move','castle_guard'),
(6098,'Greater Mercenary Posting Ticket (Cleric/Mobile)','false','castle_guard',0,'stackable','paper','none',-1,0,0,'true','true','true','true','adv_mticket_aden_cleric_move','castle_guard'),
(6099,'Greater Mercenary Posting Ticket (Wizard/Mobile)','false','castle_guard',0,'stackable','paper','none',-1,0,0,'true','true','true','true','adv_mticket_aden_wizard_move','castle_guard'),
(6100,'Trash - Trash','false','castle_guard',0,'stackable','paper','none',-1,0,0,'true','true','true','true','__golden_coda_seed_5','castle_guard');
INSERT INTO `etcitem` VALUES 
(6101,'Trash - Trash','false','castle_guard',0,'stackable','paper','none',-1,0,0,'true','true','true','true','__golden_coda_seed_5','castle_guard'),
(6102,'Trash - Trash','false','castle_guard',0,'stackable','paper','none',-1,0,0,'true','true','true','true','__golden_coda_seed_5','castle_guard'),
(6103,'Trash - Trash','false','castle_guard',0,'stackable','paper','none',-1,0,0,'true','true','true','true','__golden_coda_seed_5','castle_guard'),
(6104,'Trash - Trash','false','castle_guard',0,'stackable','paper','none',-1,0,0,'true','true','true','true','__golden_coda_seed_5','castle_guard'),
(6105,'Greater Mercenary Posting Ticket (Sword/Stationary)','false','castle_guard',0,'stackable','paper','none',-1,0,0,'true','true','true','true','adv_mticket_innadrile_sword_fix','castle_guard'),
(6106,'Greater Mercenary Posting Ticket (Spear/Stationary)','false','castle_guard',0,'stackable','paper','none',-1,0,0,'true','true','true','true','adv_mticket_innadrile_pole_fix','castle_guard'),
(6107,'Greater Mercenary Posting Ticket (Bow/Stationary)','false','castle_guard',0,'stackable','paper','none',-1,0,0,'true','true','true','true','adv_mticket_innadrile_bow_fix','castle_guard'),
(6108,'Greater Mercenary Posting Ticket (Cleric/Stationary)','false','castle_guard',0,'stackable','paper','none',-1,0,0,'true','true','true','true','adv_mticket_innadrile_cleric_fix','castle_guard'),
(6109,'Greater Mercenary Posting Ticket (Wizard/Stationary)','false','castle_guard',0,'stackable','paper','none',-1,0,0,'true','true','true','true','adv_mticket_innadrile_wizard_fix','castle_guard'),
(6110,'Greater Mercenary Posting Ticket (Sword/Mobile)','false','castle_guard',0,'stackable','paper','none',-1,0,0,'true','true','true','true','adv_mticket_innadrile_sword_move','castle_guard'),
(6111,'Greater Mercenary Posting Ticket (Spear/Mobile)','false','castle_guard',0,'stackable','paper','none',-1,0,0,'true','true','true','true','adv_mticket_innadrile_pole_move','castle_guard'),
(6112,'Greater Mercenary Posting Ticket (Bow/Mobile)','false','castle_guard',0,'stackable','paper','none',-1,0,0,'true','true','true','true','adv_mticket_innadrile_bow_move','castle_guard'),
(6113,'Greater Mercenary Posting Ticket (Cleric/Mobile)','false','castle_guard',0,'stackable','paper','none',-1,0,0,'true','true','true','true','adv_mticket_innadrile_cleric_move','castle_guard'),
(6114,'Greater Mercenary Posting Ticket (Wizard/Mobile)','false','castle_guard',0,'stackable','paper','none',-1,0,0,'true','true','true','true','adv_mticket_innadrile_wizard_move','castle_guard'),
(6115,'Dawn Mercenary Posting Ticket (Sword/Stationary)','false','castle_guard',0,'stackable','paper','none',-1,0,0,'true','true','true','true','dawn_mticket_gludio_sword_fix','castle_guard'),
(6116,'Dawn Mercenary Posting Ticket (Spear/Stationary)','false','castle_guard',0,'stackable','paper','none',-1,0,0,'true','true','true','true','dawn_mticket_gludio_pole_fix','castle_guard'),
(6117,'Dawn Mercenary Posting Ticket (Bow/Stationary)','false','castle_guard',0,'stackable','paper','none',-1,0,0,'true','true','true','true','dawn_mticket_gludio_bow_fix','castle_guard'),
(6118,'Dawn Mercenary Posting Ticket (Cleric/Stationary)','false','castle_guard',0,'stackable','paper','none',-1,0,0,'true','true','true','true','dawn_mticket_gludio_cleric_fix','castle_guard'),
(6119,'Dawn Mercenary Posting Ticket (Wizard/Stationary)','false','castle_guard',0,'stackable','paper','none',-1,0,0,'true','true','true','true','dawn_mticket_gludio_wizard_fix','castle_guard'),
(6120,'Dawn Mercenary Posting Ticket (Sword/Mobile)','false','castle_guard',0,'stackable','paper','none',-1,0,0,'true','true','true','true','dawn_mticket_gludio_sword_move','castle_guard'),
(6121,'Dawn Mercenary Posting Ticket (Spear/Mobile)','false','castle_guard',0,'stackable','paper','none',-1,0,0,'true','true','true','true','dawn_mticket_gludio_pole_move','castle_guard'),
(6122,'Dawn Mercenary Posting Ticket (Bow/Mobile)','false','castle_guard',0,'stackable','paper','none',-1,0,0,'true','true','true','true','dawn_mticket_gludio_bow_move','castle_guard'),
(6123,'Dawn Mercenary Posting Ticket (Cleric/Mobile)','false','castle_guard',0,'stackable','paper','none',-1,0,0,'true','true','true','true','dawn_mticket_gludio_cleric_move','castle_guard'),
(6124,'Dawn Mercenary Posting Ticket (Wizard/Mobile)','false','castle_guard',0,'stackable','paper','none',-1,0,0,'true','true','true','true','dawn_mticket_gludio_wizard_move','castle_guard'),
(6125,'Dawn Mercenary Posting Ticket (Sword/Stationary)','false','castle_guard',0,'stackable','paper','none',-1,0,0,'true','true','true','true','dawn_mticket_dion_sword_fix','castle_guard'),
(6126,'Dawn Mercenary Posting Ticket (Spear/Stationary)','false','castle_guard',0,'stackable','paper','none',-1,0,0,'true','true','true','true','dawn_mticket_dion_pole_fix','castle_guard'),
(6127,'Dawn Mercenary Posting Ticket (Bow/Stationary)','false','castle_guard',0,'stackable','paper','none',-1,0,0,'true','true','true','true','dawn_mticket_dion_bow_fix','castle_guard'),
(6128,'Dawn Mercenary Posting Ticket (Cleric/Stationary)','false','castle_guard',0,'stackable','paper','none',-1,0,0,'true','true','true','true','dawn_mticket_dion_cleric_fix','castle_guard'),
(6129,'Dawn Mercenary Posting Ticket (Wizard/Stationary)','false','castle_guard',0,'stackable','paper','none',-1,0,0,'true','true','true','true','dawn_mticket_dion_wizard_fix','castle_guard'),
(6130,'Dawn Mercenary Posting Ticket (Sword/Mobile)','false','castle_guard',0,'stackable','paper','none',-1,0,0,'true','true','true','true','dawn_mticket_dion_sword_move','castle_guard'),
(6131,'Dawn Mercenary Posting Ticket (Spear/Mobile)','false','castle_guard',0,'stackable','paper','none',-1,0,0,'true','true','true','true','dawn_mticket_dion_pole_move','castle_guard'),
(6132,'Dawn Mercenary Posting Ticket (Bow/Mobile)','false','castle_guard',0,'stackable','paper','none',-1,0,0,'true','true','true','true','dawn_mticket_dion_bow_move','castle_guard'),
(6133,'Dawn Mercenary Posting Ticket (Cleric/Mobile)','false','castle_guard',0,'stackable','paper','none',-1,0,0,'true','true','true','true','dawn_mticket_dion_cleric_move','castle_guard'),
(6134,'Dawn Mercenary Posting Ticket (Wizard/Mobile)','false','castle_guard',0,'stackable','paper','none',-1,0,0,'true','true','true','true','dawn_mticket_dion_wizard_move','castle_guard'),
(6135,'Dawn Mercenary Posting Ticket (Sword/Stationary)','false','castle_guard',0,'stackable','paper','none',-1,0,0,'true','true','true','true','dawn_mticket_giran_sword_fix','castle_guard'),
(6136,'Dawn Mercenary Posting Ticket (Spear/Stationary)','false','castle_guard',0,'stackable','paper','none',-1,0,0,'true','true','true','true','dawn_mticket_giran_pole_fix','castle_guard'),
(6137,'Dawn Mercenary Posting Ticket (Bow/Stationary)','false','castle_guard',0,'stackable','paper','none',-1,0,0,'true','true','true','true','dawn_mticket_giran_bow_fix','castle_guard'),
(6138,'Dawn Mercenary Posting Ticket (Cleric/Stationary)','false','castle_guard',0,'stackable','paper','none',-1,0,0,'true','true','true','true','dawn_mticket_giran_cleric_fix','castle_guard'),
(6139,'Dawn Mercenary Posting Ticket (Wizard/Stationary)','false','castle_guard',0,'stackable','paper','none',-1,0,0,'true','true','true','true','dawn_mticket_giran_wizard_fix','castle_guard'),
(6140,'Dawn Mercenary Posting Ticket (Sword/Mobile)','false','castle_guard',0,'stackable','paper','none',-1,0,0,'true','true','true','true','dawn_mticket_giran_sword_move','castle_guard'),
(6141,'Dawn Mercenary Posting Ticket (Spear/Mobile)','false','castle_guard',0,'stackable','paper','none',-1,0,0,'true','true','true','true','dawn_mticket_giran_pole_move','castle_guard'),
(6142,'Dawn Mercenary Posting Ticket (Bow/Mobile)','false','castle_guard',0,'stackable','paper','none',-1,0,0,'true','true','true','true','dawn_mticket_giran_bow_move','castle_guard'),
(6143,'Dawn Mercenary Posting Ticket (Cleric/Mobile)','false','castle_guard',0,'stackable','paper','none',-1,0,0,'true','true','true','true','dawn_mticket_giran_cleric_move','castle_guard'),
(6144,'Dawn Mercenary Posting Ticket (Wizard/Mobile)','false','castle_guard',0,'stackable','paper','none',-1,0,0,'true','true','true','true','dawn_mticket_giran_wizard_move','castle_guard'),
(6145,'Dawn Mercenary Posting Ticket (Sword/Stationary)','false','castle_guard',0,'stackable','paper','none',-1,0,0,'true','true','true','true','dawn_mticket_oren_sword_fix','castle_guard'),
(6146,'Dawn Mercenary Posting Ticket (Spear/Stationary)','false','castle_guard',0,'stackable','paper','none',-1,0,0,'true','true','true','true','dawn_mticket_oren_pole_fix','castle_guard'),
(6147,'Dawn Mercenary Posting Ticket (Bow/Stationary)','false','castle_guard',0,'stackable','paper','none',-1,0,0,'true','true','true','true','dawn_mticket_oren_bow_fix','castle_guard'),
(6148,'Dawn Mercenary Posting Ticket (Cleric/Stationary)','false','castle_guard',0,'stackable','paper','none',-1,0,0,'true','true','true','true','dawn_mticket_oren_cleric_fix','castle_guard'),
(6149,'Dawn Mercenary Posting Ticket (Wizard/Stationary)','false','castle_guard',0,'stackable','paper','none',-1,0,0,'true','true','true','true','dawn_mticket_oren_wizard_fix','castle_guard'),
(6150,'Dawn Mercenary Posting Ticket (Sword/Mobile)','false','castle_guard',0,'stackable','paper','none',-1,0,0,'true','true','true','true','dawn_mticket_oren_sword_move','castle_guard'),
(6151,'Dawn Mercenary Posting Ticket (Spear/Mobile)','false','castle_guard',0,'stackable','paper','none',-1,0,0,'true','true','true','true','dawn_mticket_oren_pole_move','castle_guard'),
(6152,'Dawn Mercenary Posting Ticket (Bow/Mobile)','false','castle_guard',0,'stackable','paper','none',-1,0,0,'true','true','true','true','dawn_mticket_oren_bow_move','castle_guard'),
(6153,'Dawn Mercenary Posting Ticket (Cleric/Mobile)','false','castle_guard',0,'stackable','paper','none',-1,0,0,'true','true','true','true','dawn_mticket_oren_cleric_move','castle_guard'),
(6154,'Dawn Mercenary Posting Ticket (Wizard/Mobile)','false','castle_guard',0,'stackable','paper','none',-1,0,0,'true','true','true','true','dawn_mticket_oren_wizard_move','castle_guard'),
(6155,'Dawn Mercenary Posting Ticket (Sword/Stationary)','false','castle_guard',0,'stackable','paper','none',-1,0,0,'true','true','true','true','dawn_mticket_aden_sword_fix','castle_guard'),
(6156,'Dawn Mercenary Posting Ticket (Spear/Stationary)','false','castle_guard',0,'stackable','paper','none',-1,0,0,'true','true','true','true','dawn_mticket_aden_pole_fix','castle_guard'),
(6157,'Dawn Mercenary Posting Ticket (Bow/Stationary)','false','castle_guard',0,'stackable','paper','none',-1,0,0,'true','true','true','true','dawn_mticket_aden_bow_fix','castle_guard'),
(6158,'Dawn Mercenary Posting Ticket (Cleric/Stationary)','false','castle_guard',0,'stackable','paper','none',-1,0,0,'true','true','true','true','dawn_mticket_aden_cleric_fix','castle_guard'),
(6159,'Dawn Mercenary Posting Ticket (Wizard/Stationary)','false','castle_guard',0,'stackable','paper','none',-1,0,0,'true','true','true','true','dawn_mticket_aden_wizard_fix','castle_guard'),
(6160,'Dawn Mercenary Posting Ticket (Sword/Mobile)','false','castle_guard',0,'stackable','paper','none',-1,0,0,'true','true','true','true','dawn_mticket_aden_sword_move','castle_guard'),
(6161,'Dawn Mercenary Posting Ticket (Spear/Mobile)','false','castle_guard',0,'stackable','paper','none',-1,0,0,'true','true','true','true','dawn_mticket_aden_pole_move','castle_guard'),
(6162,'Dawn Mercenary Posting Ticket (Bow/Mobile)','false','castle_guard',0,'stackable','paper','none',-1,0,0,'true','true','true','true','dawn_mticket_aden_bow_move','castle_guard'),
(6163,'Dawn Mercenary Posting Ticket (Cleric/Mobile)','false','castle_guard',0,'stackable','paper','none',-1,0,0,'true','true','true','true','dawn_mticket_aden_cleric_move','castle_guard'),
(6164,'Dawn Mercenary Posting Ticket (Wizard/Mobile)','false','castle_guard',0,'stackable','paper','none',-1,0,0,'true','true','true','true','dawn_mticket_aden_wizard_move','castle_guard'),
(6165,'Dawn Mercenary Posting Ticket (Sword/Stationary)','false','castle_guard',0,'stackable','paper','none',-1,0,0,'true','true','true','true','dawn_mticket_innadrile_sword_fix','castle_guard'),
(6166,'Dawn Mercenary Posting Ticket (Spear/Stationary)','false','castle_guard',0,'stackable','paper','none',-1,0,0,'true','true','true','true','dawn_mticket_innadrile_pole_fix','castle_guard'),
(6167,'Dawn Mercenary Posting Ticket (Bow/Stationary)','false','castle_guard',0,'stackable','paper','none',-1,0,0,'true','true','true','true','dawn_mticket_innadrile_bow_fix','castle_guard'),
(6168,'Dawn Mercenary Posting Ticket (Cleric/Stationary)','false','castle_guard',0,'stackable','paper','none',-1,0,0,'true','true','true','true','dawn_mticket_innadrile_cleric_fix','castle_guard'),
(6169,'Dawn Mercenary Posting Ticket (Wizard/Stationary)','false','castle_guard',0,'stackable','paper','none',-1,0,0,'true','true','true','true','dawn_mticket_innadrile_wizard_fix','castle_guard'),
(6170,'Dawn Mercenary Posting Ticket (Sword/Mobile)','false','castle_guard',0,'stackable','paper','none',-1,0,0,'true','true','true','true','dawn_mticket_innadrile_sword_move','castle_guard'),
(6171,'Dawn Mercenary Posting Ticket (Spear/Mobile)','false','castle_guard',0,'stackable','paper','none',-1,0,0,'true','true','true','true','dawn_mticket_innadrile_pole_move','castle_guard'),
(6172,'Dawn Mercenary Posting Ticket (Bow/Mobile)','false','castle_guard',0,'stackable','paper','none',-1,0,0,'true','true','true','true','dawn_mticket_innadrile_bow_move','castle_guard'),
(6173,'Dawn Mercenary Posting Ticket (Cleric/Mobile)','false','castle_guard',0,'stackable','paper','none',-1,0,0,'true','true','true','true','dawn_mticket_innadrile_cleric_move','castle_guard'),
(6174,'Dawn Mercenary Posting Ticket (Wizard/Mobile)','false','castle_guard',0,'stackable','paper','none',-1,0,0,'true','true','true','true','dawn_mticket_innadrile_wizard_move','castle_guard'),
(6175,'Greater Recruit Posting Ticket (Sword/Stationary)','false','castle_guard',0,'stackable','paper','none',-1,0,0,'true','true','true','true','twilight_mticket_gludio_sword_fix','castle_guard'),
(6176,'Greater Recruit Posting Ticket (Spear/Stationary)','false','castle_guard',0,'stackable','paper','none',-1,0,0,'true','true','true','true','twilight_mticket_gludio_pole_fix','castle_guard'),
(6177,'Greater Recruit Posting Ticket (Bow/Stationary)','false','castle_guard',0,'stackable','paper','none',-1,0,0,'true','true','true','true','twilight_mticket_gludio_bow_fix','castle_guard'),
(6178,'Greater Recruit Posting Ticket (Cleric/Stationary)','false','castle_guard',0,'stackable','paper','none',-1,0,0,'true','true','true','true','twilight_mticket_gludio_cleric_fix','castle_guard'),
(6179,'Greater Recruit Posting Ticket (Wizard/Stationary)','false','castle_guard',0,'stackable','paper','none',-1,0,0,'true','true','true','true','twilight_mticket_gludio_wizard_fix','castle_guard'),
(6180,'Greater Recruit Posting Ticket (Sword/Mobile)','false','castle_guard',0,'stackable','paper','none',-1,0,0,'true','true','true','true','twilight_mticket_gludio_sword_move','castle_guard'),
(6181,'Greater Recruit Posting Ticket (Spear/Mobile)','false','castle_guard',0,'stackable','paper','none',-1,0,0,'true','true','true','true','twilight_mticket_gludio_pole_move','castle_guard'),
(6182,'Greater Recruit Posting Ticket (Bow/Mobile)','false','castle_guard',0,'stackable','paper','none',-1,0,0,'true','true','true','true','twilight_mticket_gludio_bow_move','castle_guard'),
(6183,'Greater Recruit Posting Ticket (Cleric/Mobile)','false','castle_guard',0,'stackable','paper','none',-1,0,0,'true','true','true','true','twilight_mticket_gludio_cleric_move','castle_guard'),
(6184,'Greater Recruit Posting Ticket (Wizard/Mobile)','false','castle_guard',0,'stackable','paper','none',-1,0,0,'true','true','true','true','twilight_mticket_gludio_wizard_move','castle_guard'),
(6185,'Greater Recruit Posting Ticket (Sword/Stationary)','false','castle_guard',0,'stackable','paper','none',-1,0,0,'true','true','true','true','twilight_mticket_dion_sword_fix','castle_guard'),
(6186,'Greater Recruit Posting Ticket (Spear/Stationary)','false','castle_guard',0,'stackable','paper','none',-1,0,0,'true','true','true','true','twilight_mticket_dion_pole_fix','castle_guard'),
(6187,'Greater Recruit Posting Ticket (Bow/Stationary)','false','castle_guard',0,'stackable','paper','none',-1,0,0,'true','true','true','true','twilight_mticket_dion_bow_fix','castle_guard'),
(6188,'Greater Recruit Posting Ticket (Cleric/Stationary)','false','castle_guard',0,'stackable','paper','none',-1,0,0,'true','true','true','true','twilight_mticket_dion_cleric_fix','castle_guard'),
(6189,'Greater Recruit Posting Ticket (Wizard/Stationary)','false','castle_guard',0,'stackable','paper','none',-1,0,0,'true','true','true','true','twilight_mticket_dion_wizard_fix','castle_guard'),
(6190,'Greater Recruit Posting Ticket (Sword/Mobile)','false','castle_guard',0,'stackable','paper','none',-1,0,0,'true','true','true','true','twilight_mticket_dion_sword_move','castle_guard'),
(6191,'Greater Recruit Posting Ticket (Spear/Mobile)','false','castle_guard',0,'stackable','paper','none',-1,0,0,'true','true','true','true','twilight_mticket_dion_pole_move','castle_guard'),
(6192,'Greater Recruit Posting Ticket (Bow/Mobile)','false','castle_guard',0,'stackable','paper','none',-1,0,0,'true','true','true','true','twilight_mticket_dion_bow_move','castle_guard'),
(6193,'Greater Recruit Posting Ticket (Cleric/Mobile)','false','castle_guard',0,'stackable','paper','none',-1,0,0,'true','true','true','true','twilight_mticket_dion_cleric_move','castle_guard'),
(6194,'Greater Recruit Posting Ticket (Wizard/Mobile)','false','castle_guard',0,'stackable','paper','none',-1,0,0,'true','true','true','true','twilight_mticket_dion_wizard_move','castle_guard'),
(6195,'Greater Recruit Posting Ticket (Sword/Stationary)','false','castle_guard',0,'stackable','paper','none',-1,0,0,'true','true','true','true','twilight_mticket_giran_sword_fix','castle_guard'),
(6196,'Greater Recruit Posting Ticket (Spear/Stationary)','false','castle_guard',0,'stackable','paper','none',-1,0,0,'true','true','true','true','twilight_mticket_giran_pole_fix','castle_guard'),
(6197,'Greater Recruit Posting Ticket (Bow/Stationary)','false','castle_guard',0,'stackable','paper','none',-1,0,0,'true','true','true','true','twilight_mticket_giran_bow_fix','castle_guard'),
(6198,'Greater Recruit Posting Ticket (Cleric/Stationary)','false','castle_guard',0,'stackable','paper','none',-1,0,0,'true','true','true','true','twilight_mticket_giran_cleric_fix','castle_guard'),
(6199,'Greater Recruit Posting Ticket (Wizard/Stationary)','false','castle_guard',0,'stackable','paper','none',-1,0,0,'true','true','true','true','twilight_mticket_giran_wizard_fix','castle_guard'),
(6200,'Greater Recruit Posting Ticket (Sword/Mobile)','false','castle_guard',0,'stackable','paper','none',-1,0,0,'true','true','true','true','twilight_mticket_giran_sword_move','castle_guard'),
(6201,'Greater Recruit Posting Ticket (Spear/Mobile)','false','castle_guard',0,'stackable','paper','none',-1,0,0,'true','true','true','true','twilight_mticket_giran_pole_move','castle_guard'),
(6202,'Greater Recruit Posting Ticket (Bow/Mobile)','false','castle_guard',0,'stackable','paper','none',-1,0,0,'true','true','true','true','twilight_mticket_giran_bow_move','castle_guard'),
(6203,'Greater Recruit Posting Ticket (Cleric/Mobile)','false','castle_guard',0,'stackable','paper','none',-1,0,0,'true','true','true','true','twilight_mticket_giran_cleric_move','castle_guard'),
(6204,'Greater Recruit Posting Ticket (Wizard/Mobile)','false','castle_guard',0,'stackable','paper','none',-1,0,0,'true','true','true','true','twilight_mticket_giran_wizard_move','castle_guard'),
(6205,'Greater Recruit Posting Ticket (Sword/Stationary)','false','castle_guard',0,'stackable','paper','none',-1,0,0,'true','true','true','true','twilight_mticket_oren_sword_fix','castle_guard'),
(6206,'Greater Recruit Posting Ticket (Spear/Stationary)','false','castle_guard',0,'stackable','paper','none',-1,0,0,'true','true','true','true','twilight_mticket_oren_pole_fix','castle_guard'),
(6207,'Greater Recruit Posting Ticket (Bow/Stationary)','false','castle_guard',0,'stackable','paper','none',-1,0,0,'true','true','true','true','twilight_mticket_oren_bow_fix','castle_guard'),
(6208,'Greater Recruit Posting Ticket (Cleric/Stationary)','false','castle_guard',0,'stackable','paper','none',-1,0,0,'true','true','true','true','twilight_mticket_oren_cleric_fix','castle_guard'),
(6209,'Greater Recruit Posting Ticket (Wizard/Stationary)','false','castle_guard',0,'stackable','paper','none',-1,0,0,'true','true','true','true','twilight_mticket_oren_wizard_fix','castle_guard'),
(6210,'Greater Recruit Posting Ticket (Sword/Mobile)','false','castle_guard',0,'stackable','paper','none',-1,0,0,'true','true','true','true','twilight_mticket_oren_sword_move','castle_guard'),
(6211,'Greater Recruit Posting Ticket (Spear/Mobile)','false','castle_guard',0,'stackable','paper','none',-1,0,0,'true','true','true','true','twilight_mticket_oren_pole_move','castle_guard'),
(6212,'Greater Recruit Posting Ticket (Bow/Mobile)','false','castle_guard',0,'stackable','paper','none',-1,0,0,'true','true','true','true','twilight_mticket_oren_bow_move','castle_guard'),
(6213,'Greater Recruit Posting Ticket (Cleric/Mobile)','false','castle_guard',0,'stackable','paper','none',-1,0,0,'true','true','true','true','twilight_mticket_oren_cleric_move','castle_guard'),
(6214,'Greater Recruit Posting Ticket (Wizard/Mobile)','false','castle_guard',0,'stackable','paper','none',-1,0,0,'true','true','true','true','twilight_mticket_oren_wizard_move','castle_guard'),
(6215,'Greater Recruit Posting Ticket (Sword/Stationary)','false','castle_guard',0,'stackable','paper','none',-1,0,0,'true','true','true','true','twilight_mticket_aden_sword_fix','castle_guard'),
(6216,'Greater Recruit Posting Ticket (Spear/Stationary)','false','castle_guard',0,'stackable','paper','none',-1,0,0,'true','true','true','true','twilight_mticket_aden_pole_fix','castle_guard'),
(6217,'Greater Recruit Posting Ticket (Bow/Stationary)','false','castle_guard',0,'stackable','paper','none',-1,0,0,'true','true','true','true','twilight_mticket_aden_bow_fix','castle_guard'),
(6218,'Greater Recruit Posting Ticket (Cleric/Stationary)','false','castle_guard',0,'stackable','paper','none',-1,0,0,'true','true','true','true','twilight_mticket_aden_cleric_fix','castle_guard'),
(6219,'Greater Recruit Posting Ticket (Wizard/Stationary)','false','castle_guard',0,'stackable','paper','none',-1,0,0,'true','true','true','true','twilight_mticket_aden_wizard_fix','castle_guard'),
(6220,'Greater Recruit Posting Ticket (Sword/Mobile)','false','castle_guard',0,'stackable','paper','none',-1,0,0,'true','true','true','true','twilight_mticket_aden_sword_move','castle_guard'),
(6221,'Greater Recruit Posting Ticket (Spear/Mobile)','false','castle_guard',0,'stackable','paper','none',-1,0,0,'true','true','true','true','twilight_mticket_aden_pole_move','castle_guard'),
(6222,'Greater Recruit Posting Ticket (Bow/Mobile)','false','castle_guard',0,'stackable','paper','none',-1,0,0,'true','true','true','true','twilight_mticket_aden_bow_move','castle_guard'),
(6223,'Greater Recruit Posting Ticket (Cleric/Mobile)','false','castle_guard',0,'stackable','paper','none',-1,0,0,'true','true','true','true','twilight_mticket_aden_cleric_move','castle_guard'),
(6224,'Greater Recruit Posting Ticket (Wizard/Mobile)','false','castle_guard',0,'stackable','paper','none',-1,0,0,'true','true','true','true','twilight_mticket_aden_wizard_move','castle_guard'),
(6225,'Greater Recruit Posting Ticket (Sword/Stationary)','false','castle_guard',0,'stackable','paper','none',-1,0,0,'true','true','true','true','twilight_mticket_innadrile_sword_fix','castle_guard'),
(6226,'Greater Recruit Posting Ticket (Spear/Stationary)','false','castle_guard',0,'stackable','paper','none',-1,0,0,'true','true','true','true','twilight_mticket_innadrile_pole_fix','castle_guard'),
(6227,'Greater Recruit Posting Ticket (Bow/Stationary)','false','castle_guard',0,'stackable','paper','none',-1,0,0,'true','true','true','true','twilight_mticket_innadrile_bow_fix','castle_guard'),
(6228,'Greater Recruit Posting Ticket (Cleric/Stationary)','false','castle_guard',0,'stackable','paper','none',-1,0,0,'true','true','true','true','twilight_mticket_innadrile_cleric_fix','castle_guard'),
(6229,'Greater Recruit Posting Ticket (Wizard/Stationary)','false','castle_guard',0,'stackable','paper','none',-1,0,0,'true','true','true','true','twilight_mticket_innadrile_wizard_fix','castle_guard'),
(6230,'Greater Recruit Posting Ticket (Sword/Mobile)','false','castle_guard',0,'stackable','paper','none',-1,0,0,'true','true','true','true','twilight_mticket_innadrile_sword_move','castle_guard'),
(6231,'Greater Recruit Posting Ticket (Spear/Mobile)','false','castle_guard',0,'stackable','paper','none',-1,0,0,'true','true','true','true','twilight_mticket_innadrile_pole_move','castle_guard'),
(6232,'Greater Recruit Posting Ticket (Bow/Mobile)','false','castle_guard',0,'stackable','paper','none',-1,0,0,'true','true','true','true','twilight_mticket_innadrile_bow_move','castle_guard'),
(6233,'Greater Recruit Posting Ticket (Cleric/Mobile)','false','castle_guard',0,'stackable','paper','none',-1,0,0,'true','true','true','true','twilight_mticket_innadrile_cleric_move','castle_guard'),
(6234,'Greater Recruit Posting Ticket (Wizard/Mobile)','false','castle_guard',0,'stackable','paper','none',-1,0,0,'true','true','true','true','twilight_mticket_innadrile_wizard_move','castle_guard'),
(6235,'Recruit Posting Ticket (Sword/Stationary)','false','castle_guard',0,'stackable','paper','none',-1,0,0,'true','true','true','true','gloom_mticket_gludio_sword_fix','castle_guard'),
(6236,'Recruit Posting Ticket (Spear/Stationary)','false','castle_guard',0,'stackable','paper','none',-1,0,0,'true','true','true','true','gloom_mticket_gludio_pole_fix','castle_guard'),
(6237,'Recruit Posting Ticket (Bow/Stationary)','false','castle_guard',0,'stackable','paper','none',-1,0,0,'true','true','true','true','gloom_mticket_gludio_bow_fix','castle_guard'),
(6238,'Recruit Posting Ticket (Cleric/Stationary)','false','castle_guard',0,'stackable','paper','none',-1,0,0,'true','true','true','true','gloom_mticket_gludio_cleric_fix','castle_guard'),
(6239,'Recruit Posting Ticket (Wizard/Stationary)','false','castle_guard',0,'stackable','paper','none',-1,0,0,'true','true','true','true','gloom_mticket_gludio_wizard_fix','castle_guard'),
(6240,'Recruit Posting Ticket (Sword/Mobile)','false','castle_guard',0,'stackable','paper','none',-1,0,0,'true','true','true','true','gloom_mticket_gludio_sword_move','castle_guard'),
(6241,'Recruit Posting Ticket (Spear/Mobile)','false','castle_guard',0,'stackable','paper','none',-1,0,0,'true','true','true','true','gloom_mticket_gludio_pole_move','castle_guard'),
(6242,'Recruit Posting Ticket (Bow/Mobile)','false','castle_guard',0,'stackable','paper','none',-1,0,0,'true','true','true','true','gloom_mticket_gludio_bow_move','castle_guard'),
(6243,'Recruit Posting Ticket (Cleric/Mobile)','false','castle_guard',0,'stackable','paper','none',-1,0,0,'true','true','true','true','gloom_mticket_gludio_cleric_move','castle_guard'),
(6244,'Recruit Posting Ticket (Wizard/Mobile)','false','castle_guard',0,'stackable','paper','none',-1,0,0,'true','true','true','true','gloom_mticket_gludio_wizard_move','castle_guard'),
(6245,'Recruit Posting Ticket (Sword/Stationary)','false','castle_guard',0,'stackable','paper','none',-1,0,0,'true','true','true','true','gloom_mticket_dion_sword_fix','castle_guard'),
(6246,'Recruit Posting Ticket (Spear/Stationary)','false','castle_guard',0,'stackable','paper','none',-1,0,0,'true','true','true','true','gloom_mticket_dion_pole_fix','castle_guard'),
(6247,'Recruit Posting Ticket (Bow/Stationary)','false','castle_guard',0,'stackable','paper','none',-1,0,0,'true','true','true','true','gloom_mticket_dion_bow_fix','castle_guard'),
(6248,'Recruit Posting Ticket (Cleric/Stationary)','false','castle_guard',0,'stackable','paper','none',-1,0,0,'true','true','true','true','gloom_mticket_dion_cleric_fix','castle_guard'),
(6249,'Recruit Posting Ticket (Wizard/Stationary)','false','castle_guard',0,'stackable','paper','none',-1,0,0,'true','true','true','true','gloom_mticket_dion_wizard_fix','castle_guard'),
(6250,'Recruit Posting Ticket (Sword/Mobile)','false','castle_guard',0,'stackable','paper','none',-1,0,0,'true','true','true','true','gloom_mticket_dion_sword_move','castle_guard'),
(6251,'Recruit Posting Ticket (Spear/Mobile)','false','castle_guard',0,'stackable','paper','none',-1,0,0,'true','true','true','true','gloom_mticket_dion_pole_move','castle_guard'),
(6252,'Recruit Posting Ticket (Bow/Mobile)','false','castle_guard',0,'stackable','paper','none',-1,0,0,'true','true','true','true','gloom_mticket_dion_bow_move','castle_guard'),
(6253,'Recruit Posting Ticket (Cleric/Mobile)','false','castle_guard',0,'stackable','paper','none',-1,0,0,'true','true','true','true','gloom_mticket_dion_cleric_move','castle_guard'),
(6254,'Recruit Posting Ticket (Wizard/Mobile)','false','castle_guard',0,'stackable','paper','none',-1,0,0,'true','true','true','true','gloom_mticket_dion_wizard_move','castle_guard'),
(6255,'Recruit Posting Ticket (Sword/Stationary)','false','castle_guard',0,'stackable','paper','none',-1,0,0,'true','true','true','true','gloom_mticket_giran_sword_fix','castle_guard'),
(6256,'Recruit Posting Ticket (Spear/Stationary)','false','castle_guard',0,'stackable','paper','none',-1,0,0,'true','true','true','true','gloom_mticket_giran_pole_fix','castle_guard'),
(6257,'Recruit Posting Ticket (Bow/Stationary)','false','castle_guard',0,'stackable','paper','none',-1,0,0,'true','true','true','true','gloom_mticket_giran_bow_fix','castle_guard'),
(6258,'Recruit Posting Ticket (Cleric/Stationary)','false','castle_guard',0,'stackable','paper','none',-1,0,0,'true','true','true','true','gloom_mticket_giran_cleric_fix','castle_guard'),
(6259,'Recruit Posting Ticket (Wizard/Stationary)','false','castle_guard',0,'stackable','paper','none',-1,0,0,'true','true','true','true','gloom_mticket_giran_wizard_fix','castle_guard'),
(6260,'Recruit Posting Ticket (Sword/Mobile)','false','castle_guard',0,'stackable','paper','none',-1,0,0,'true','true','true','true','gloom_mticket_giran_sword_move','castle_guard'),
(6261,'Recruit Posting Ticket (Spear/Mobile)','false','castle_guard',0,'stackable','paper','none',-1,0,0,'true','true','true','true','gloom_mticket_giran_pole_move','castle_guard'),
(6262,'Recruit Posting Ticket (Bow/Mobile)','false','castle_guard',0,'stackable','paper','none',-1,0,0,'true','true','true','true','gloom_mticket_giran_bow_move','castle_guard'),
(6263,'Recruit Posting Ticket (Cleric/Mobile)','false','castle_guard',0,'stackable','paper','none',-1,0,0,'true','true','true','true','gloom_mticket_giran_cleric_move','castle_guard'),
(6264,'Recruit Posting Ticket (Wizard/Mobile)','false','castle_guard',0,'stackable','paper','none',-1,0,0,'true','true','true','true','gloom_mticket_giran_wizard_move','castle_guard'),
(6265,'Recruit Posting Ticket (Sword/Stationary)','false','castle_guard',0,'stackable','paper','none',-1,0,0,'true','true','true','true','gloom_mticket_oren_sword_fix','castle_guard'),
(6266,'Recruit Posting Ticket (Spear/Stationary)','false','castle_guard',0,'stackable','paper','none',-1,0,0,'true','true','true','true','gloom_mticket_oren_pole_fix','castle_guard'),
(6267,'Recruit Posting Ticket (Bow/Stationary)','false','castle_guard',0,'stackable','paper','none',-1,0,0,'true','true','true','true','gloom_mticket_oren_bow_fix','castle_guard'),
(6268,'Recruit Posting Ticket (Cleric/Stationary)','false','castle_guard',0,'stackable','paper','none',-1,0,0,'true','true','true','true','gloom_mticket_oren_cleric_fix','castle_guard'),
(6269,'Recruit Posting Ticket (Wizard/Stationary)','false','castle_guard',0,'stackable','paper','none',-1,0,0,'true','true','true','true','gloom_mticket_oren_wizard_fix','castle_guard'),
(6270,'Recruit Posting Ticket (Sword/Mobile)','false','castle_guard',0,'stackable','paper','none',-1,0,0,'true','true','true','true','gloom_mticket_oren_sword_move','castle_guard'),
(6271,'Recruit Posting Ticket (Spear/Mobile)','false','castle_guard',0,'stackable','paper','none',-1,0,0,'true','true','true','true','gloom_mticket_oren_pole_move','castle_guard'),
(6272,'Recruit Posting Ticket (Bow/Mobile)','false','castle_guard',0,'stackable','paper','none',-1,0,0,'true','true','true','true','gloom_mticket_oren_bow_move','castle_guard'),
(6273,'Recruit Posting Ticket (Cleric/Mobile)','false','castle_guard',0,'stackable','paper','none',-1,0,0,'true','true','true','true','gloom_mticket_oren_cleric_move','castle_guard'),
(6274,'Recruit Posting Ticket (Wizard/Mobile)','false','castle_guard',0,'stackable','paper','none',-1,0,0,'true','true','true','true','gloom_mticket_oren_wizard_move','castle_guard'),
(6275,'Recruit Posting Ticket (Sword/Stationary)','false','castle_guard',0,'stackable','paper','none',-1,0,0,'true','true','true','true','gloom_mticket_aden_sword_fix','castle_guard'),
(6276,'Recruit Posting Ticket (Spear/Stationary)','false','castle_guard',0,'stackable','paper','none',-1,0,0,'true','true','true','true','gloom_mticket_aden_pole_fix','castle_guard'),
(6277,'Recruit Posting Ticket (Bow/Stationary)','false','castle_guard',0,'stackable','paper','none',-1,0,0,'true','true','true','true','gloom_mticket_aden_bow_fix','castle_guard'),
(6278,'Recruit Posting Ticket (Cleric/Stationary)','false','castle_guard',0,'stackable','paper','none',-1,0,0,'true','true','true','true','gloom_mticket_aden_cleric_fix','castle_guard'),
(6279,'Recruit Posting Ticket (Wizard/Stationary)','false','castle_guard',0,'stackable','paper','none',-1,0,0,'true','true','true','true','gloom_mticket_aden_wizard_fix','castle_guard'),
(6280,'Recruit Posting Ticket (Sword/Mobile)','false','castle_guard',0,'stackable','paper','none',-1,0,0,'true','true','true','true','gloom_mticket_aden_sword_move','castle_guard'),
(6281,'Recruit Posting Ticket (Spear/Mobile)','false','castle_guard',0,'stackable','paper','none',-1,0,0,'true','true','true','true','gloom_mticket_aden_pole_move','castle_guard'),
(6282,'Recruit Posting Ticket (Bow/Mobile)','false','castle_guard',0,'stackable','paper','none',-1,0,0,'true','true','true','true','gloom_mticket_aden_bow_move','castle_guard'),
(6283,'Recruit Posting Ticket (Cleric/Mobile)','false','castle_guard',0,'stackable','paper','none',-1,0,0,'true','true','true','true','gloom_mticket_aden_cleric_move','castle_guard'),
(6284,'Recruit Posting Ticket (Wizard/Mobile)','false','castle_guard',0,'stackable','paper','none',-1,0,0,'true','true','true','true','gloom_mticket_aden_wizard_move','castle_guard'),
(6285,'Recruit Posting Ticket (Sword/Stationary)','false','castle_guard',0,'stackable','paper','none',-1,0,0,'true','true','true','true','gloom_mticket_innadrile_sword_fix','castle_guard'),
(6286,'Recruit Posting Ticket (Spear/Stationary)','false','castle_guard',0,'stackable','paper','none',-1,0,0,'true','true','true','true','gloom_mticket_innadrile_pole_fix','castle_guard'),
(6287,'Recruit Posting Ticket (Bow/Stationary)','false','castle_guard',0,'stackable','paper','none',-1,0,0,'true','true','true','true','gloom_mticket_innadrile_bow_fix','castle_guard'),
(6288,'Recruit Posting Ticket (Cleric/Stationary)','false','castle_guard',0,'stackable','paper','none',-1,0,0,'true','true','true','true','gloom_mticket_innadrile_cleric_fix','castle_guard'),
(6289,'Recruit Posting Ticket (Wizard/Stationary)','false','castle_guard',0,'stackable','paper','none',-1,0,0,'true','true','true','true','gloom_mticket_innadrile_wizard_fix','castle_guard'),
(6290,'Recruit Posting Ticket (Sword/Mobile)','false','castle_guard',0,'stackable','paper','none',-1,0,0,'true','true','true','true','gloom_mticket_innadrile_sword_move','castle_guard'),
(6291,'Recruit Posting Ticket (Spear/Mobile)','false','castle_guard',0,'stackable','paper','none',-1,0,0,'true','true','true','true','gloom_mticket_innadrile_pole_move','castle_guard'),
(6292,'Recruit Posting Ticket (Bow/Mobile)','false','castle_guard',0,'stackable','paper','none',-1,0,0,'true','true','true','true','gloom_mticket_innadrile_bow_move','castle_guard'),
(6293,'Recruit Posting Ticket (Cleric/Mobile)','false','castle_guard',0,'stackable','paper','none',-1,0,0,'true','true','true','true','gloom_mticket_innadrile_cleric_move','castle_guard'),
(6294,'Recruit Posting Ticket (Wizard/Mobile)','false','castle_guard',0,'stackable','paper','none',-1,0,0,'true','true','true','true','gloom_mticket_innadrile_wizard_move','castle_guard'),
(6295,'Nephilim Warrior Posting Ticket','false','castle_guard',0,'stackable','paper','none',-1,0,0,'true','true','true','true','nephilim_mticket_gludio_sword_move','castle_guard'),
(6296,'Nephilim Shaman Posting Ticket','false','castle_guard',0,'stackable','paper','none',-1,0,0,'true','true','true','true','nephilim_mticket_gludio_wizard_move','castle_guard'),
(6297,'Nephilim Warrior Posting Ticket','false','castle_guard',0,'stackable','paper','none',-1,0,0,'true','true','true','true','nephilim_mticket_dion_sword_move','castle_guard'),
(6298,'Nephilim Shaman Posting Ticket','false','castle_guard',0,'stackable','paper','none',-1,0,0,'true','true','true','true','nephilim_mticket_dion_wizard_move','castle_guard'),
(6299,'Nephilim Warrior Posting Ticket','false','castle_guard',0,'stackable','paper','none',-1,0,0,'true','true','true','true','nephilim_mticket_giran_sword_move','castle_guard'),
(6300,'Nephilim Shaman Posting Ticket','false','castle_guard',0,'stackable','paper','none',-1,0,0,'true','true','true','true','nephilim_mticket_giran_wizard_move','castle_guard'),
(6301,'Nephilim Warrior Posting Ticket','false','castle_guard',0,'stackable','paper','none',-1,0,0,'true','true','true','true','nephilim_mticket_oren_sword_move','castle_guard'),
(6302,'Nephilim Shaman Posting Ticket','false','castle_guard',0,'stackable','paper','none',-1,0,0,'true','true','true','true','nephilim_mticket_oren_wizard_move','castle_guard'),
(6303,'Nephilim Warrior Posting Ticket','false','castle_guard',0,'stackable','paper','none',-1,0,0,'true','true','true','true','nephilim_mticket_aden_sword_move','castle_guard'),
(6304,'Nephilim Shaman Posting Ticket','false','castle_guard',0,'stackable','paper','none',-1,0,0,'true','true','true','true','nephilim_mticket_aden_wizard_move','castle_guard'),
(6305,'Nephilim Warrior Posting Ticket','false','castle_guard',0,'stackable','paper','none',-1,0,0,'true','true','true','true','nephilim_mticket_innadrile_sword_move','castle_guard'),
(6306,'Nephilim Shaman Posting Ticket','false','castle_guard',0,'stackable','paper','none',-1,0,0,'true','true','true','true','nephilim_mticket_innadrile_wizard_move','castle_guard'),
(6316,'Food for Wyvern','false','none',10,'stackable','liquid','none',-1,300,0,'true','true','true','true','advdeluxe_food_for_strider','none'),
(6317,'Mixing Manual','false','none',20,'normal','liquid','none',-1,0,0,'true','false','true','true','mixing_manual','none'),
(6318,'Blood Fire','false','quest',50,'stackable','liquid','none',-1,0,0,'true','true','true','true','bloodfire','none'),
(6319,'Mimir\'s Elixir','false','quest',0,'stackable','crystal','none',-1,0,0,'false','false','true','false','mimirs_elixir','none'),
(6320,'Pure Silver','false','quest',0,'stackable','liquid','none',-1,0,0,'true','true','true','true','pure_silver','none'),
(6321,'True Gold','false','quest',0,'stackable','crystal','none',-1,0,0,'false','false','true','false','false_gold','none'),
(6322,'Sage\'s Stone','false','quest',0,'stackable','crystal','none',-1,0,0,'false','false','true','false','philosophers_stone','none'),
(6329,'Recipe: Sealed Phoenix Necklace(70%)','false','recipe',30,'stackable','liquid','none',-1,34800,0,'true','true','true','true','rp_sealed_phoenix\'s_necklace_i','recipe'),
(6330,'Recipe: Sealed Phoenix Necklace(100%)','false','recipe',30,'stackable','liquid','none',-1,69600,0,'true','true','true','true','rp_sealed_phoenix\'s_necklace','recipe'),
(6331,'Recipe: Sealed Phoenix Earring(70%)','false','recipe',30,'stackable','liquid','none',-1,26200,0,'true','true','true','true','rp_sealed_phoenix\'s_earing_i','recipe'),
(6332,'Recipe: Sealed Phoenix Earring(100%)','false','recipe',30,'stackable','liquid','none',-1,52400,0,'true','true','true','true','rp_sealed_phoenix\'s_earing','recipe'),
(6333,'Recipe: Sealed Phoenix Ring(70%)','false','recipe',30,'stackable','liquid','none',-1,17420,0,'true','true','true','true','rp_sealed_phoenix\'s_ring_i','recipe'),
(6334,'Recipe: Sealed Phoenix Ring(100%)','false','recipe',30,'stackable','liquid','none',-1,34840,0,'true','true','true','true','rp_sealed_phoenix\'s_ring','recipe'),
(6335,'Recipe: Sealed Majestic Necklace(70%)','false','recipe',30,'stackable','liquid','none',-1,52000,0,'true','true','true','true','rp_sealed_majestic_necklace_i','recipe'),
(6336,'Recipe: Sealed Majestic Necklace(100%)','false','recipe',30,'stackable','liquid','none',-1,104000,0,'true','true','true','true','rp_sealed_majestic_necklace','recipe'),
(6337,'Recipe: Sealed Majestic Earring(70%)','false','recipe',30,'stackable','liquid','none',-1,39000,0,'true','true','true','true','rp_sealed_majestic_earing_i','recipe'),
(6338,'Recipe: Sealed Majestic Earring(100%)','false','recipe',30,'stackable','liquid','none',-1,78000,0,'true','true','true','true','rp_sealed_majestic_earing','recipe'),
(6339,'Recipe: Sealed Majestic Ring(70%)','false','recipe',30,'stackable','liquid','none',-1,26000,0,'true','true','true','true','rp_sealed_majestic_ring_i','recipe'),
(6340,'Recipe: Sealed Majestic Ring(100%)','false','recipe',30,'stackable','liquid','none',-1,52000,0,'true','true','true','true','rp_sealed_majestic_ring','recipe'),
(6341,'Sealed Phoenix Earring Gemstone','false','material',60,'stackable','liquid','none',-1,7231,0,'true','true','true','true','sealed_phoenix\'s_earing_gemstone','material'),
(6342,'Sealed Majestic Earring Gemstone','false','material',60,'stackable','liquid','none',-1,8829,0,'true','true','true','true','sealed_majestic_earing_gemstone','material'),
(6343,'Sealed Phoenix Necklace Beads','false','material',60,'stackable','liquid','none',-1,9354,0,'true','true','true','true','sealed_phoenix\'s_necklace_beads','material'),
(6344,'Sealed Majestic Necklace Beads','false','material',60,'stackable','liquid','none',-1,13643,0,'true','true','true','true','sealed_majestic_necklace_beads','material'),
(6345,'Sealed Phoenix Ring Gemstone','false','material',60,'stackable','liquid','none',-1,5228,0,'true','true','true','true','sealed_phoenix\'s_ring_gemstone','material'),
(6346,'Sealed Majestic Ring Gemstone','false','material',60,'stackable','liquid','none',-1,6143,0,'true','true','true','true','sealed_majestic_ring_gemstrone','material'),
(6350,'Amulet: Pa''agrio\'s Honor','false','spellbook',120,'stackable','paper','none',-1,8700,0,'true','true','true','true','sb_honor_of_paagrio1','none'),
(6351,'Amulet: Ritual of Life','false','spellbook',120,'stackable','paper','none',-1,8200,0,'true','true','true','true','sb_ritual_of_life1','none'),
(6352,'Spellbook: Prayer','false','spellbook',120,'stackable','paper','none',-1,8700,0,'true','true','true','true','sb_prayer1','none'),
(6353,'Blue Gemstone','false','none',0,'stackable','liquid','none',-1,0,0,'true','true','true','true','blue_gem','none'),
(6360,'Blue Seal Stone','false','none',0,'asset','gold','none',-1,3,0,'true','true','true','true','blue_seal_stone','none'),
(6361,'Green Seal Stone','false','none',0,'asset','gold','none',-1,5,0,'true','true','true','true','green_seal_stone','none'),
(6362,'Red Seal Stone','false','none',0,'asset','gold','none',-1,10,0,'true','true','true','true','red_seal_stone','none'),
(6363,'Stolen Infernium Ore','false','none',0,'stackable','steel','none',-1,100,0,'true','true','true','true','stolen_infernium_ore','none'),
(6387,'Blessed Scroll of Resurrection for Pets','false','scroll',120,'stackable','paper','none',-1,6000,0,'true','true','true','true','blessed_scroll_of_resurrection_for_pet','scroll'),
(6388,'Lord of the Manor\'s Certificate of Approval','false','none',0,'stackable','liquid','none',-1,0,0,'true','true','true','true','C4Item','none'),
(6389,'Squash Seed','false','none',0,'stackable','paper','none',-1,0,0,'true','false','true','true','C4Item','none'),
(6390,'Large Squash Seed','false','none',0,'stackable','paper','none',-1,0,0,'true','false','true','true','C4Item','none'),
(6391,'Pollen','false','none',0,'stackable','paper','none',-1,0,0,'true','true','true','true','C4Item','none'),
(6392,'Event - Medal','false','none',0,'stackable','steel','none',-1,0,0,'true','true','true','true','C4Item','none'),
(6393,'Event - Glittering Medal','false','none',0,'stackable','steel','none',-1,0,0,'true','true','true','true','C4Item','none'),
(6395,'Amulet: Chant of Predator','false','spellbook',120,'stackable','paper','none',-1,4600,0,'true','true','true','true','predator_amulet','none'),
(6396,'Amulet: Chant of Eagle','false','spellbook',120,'stackable','paper','none',-1,4600,0,'true','true','true','true','eagle_amulet','none'),
(6397,'Amulet: Chant of Vampire','false','spellbook',120,'stackable','paper','none',-1,3850,0,'true','true','true','true','vampire_amulet','none'),
(6398,'Spellbook: Body of Avatar','false','spellbook',120,'stackable','paper','none',-1,4600,0,'true','true','true','true','avatar_of_spellbook','none'),
(6399,'Badge of Rabbit','false','quest',0,'stackable','crystal','none',-1,0,0,'false','false','true','false','C4Item','none'),
(6400,'Badge of Hyena','false','quest',0,'stackable','crystal','none',-1,0,0,'false','false','true','false','C4Item','none'),
(6401,'Badge of Fox','false','quest',0,'stackable','crystal','none',-1,0,0,'false','false','true','false','C4Item','none'),
(6402,'Badge of Wolf','false','quest',0,'stackable','crystal','none',-1,0,0,'false','false','true','false','C4Item','none'),
(6403,'Star Shard','false','none',0,'stackable','steel','none',-1,0,0,'true','true','true','true','elven_firecracker','none'),
(6404,'Gunpowder','false','none',0,'stackable','steel','none',-1,0,0,'true','true','true','true','gunpowder','none'),
(6405,'Magnesium','false','none',0,'stackable','steel','none',-1,0,0,'true','true','true','true','magnesium','none'),
(6406,'Firework','false','none',0,'stackable','steel','none',-1,0,0,'true','true','true','true','firework','none'),
(6407,'Large Firework','false','none',0,'stackable','steel','none',-1,0,0,'true','true','true','true','large_firework','none'),
(6409,'2006 Battle Tournament - CP Potion','false','potion',500,'stackable','liquid','none',-1,0,0,'true','true','true','true','C4Item','potion'),
(6410,'2006 Battle Tournament - Quick Healing Potion','false','potion',180,'stackable','liquid','none',-1,0,0,'true','true','true','true','C4Item','potion'),
(6411,'Small Nimble Green Fish','false','none',100,'stackable','paper','none',-1,138,0,'true','true','true','true','C4Item','castle_guard'),
(6412,'Small Ugly Green Fish','false','none',100,'stackable','paper','none',-1,141,0,'true','true','true','true','C4Item','castle_guard'),
(6413,'Small Pudgy Green Fish','false','none',100,'stackable','paper','none',-1,153,0,'true','true','true','true','C4Item','castle_guard'),
(6414,'Nimble Green Fish','false','none',100,'stackable','paper','none',-1,167,0,'true','true','true','true','C4Item','castle_guard'),
(6415,'Ugly Green Fish','false','none',100,'stackable','paper','none',-1,187,0,'true','true','true','true','C4Item','castle_guard'),
(6416,'Pudgy Green Fish','false','none',100,'stackable','paper','none',-1,208,0,'true','true','true','true','C4Item','castle_guard'),
(6417,'Large Nimble Green Fish','false','none',100,'stackable','paper','none',-1,0,0,'true','true','true','true','C4Item','castle_guard'),
(6418,'Large Ugly Green Fish','false','none',100,'stackable','paper','none',-1,248,0,'true','true','true','true','C4Item','castle_guard'),
(6419,'Large Pudgy Green Fish','false','none',100,'stackable','paper','none',-1,265,0,'true','true','true','true','C4Item','castle_guard'),
(6420,'Small Jade Nimble Fish','false','none',100,'stackable','paper','none',-1,285,0,'true','true','true','true','C4Item','castle_guard'),
(6421,'Small Jade Ugly Fish','false','none',100,'stackable','paper','none',-1,295,0,'true','true','true','true','C4Item','castle_guard'),
(6422,'Small Jade Fat Fish','false','none',100,'stackable','paper','none',-1,310,0,'true','true','true','true','C4Item','castle_guard'),
(6423,'Jade Nimble Fish','false','none',100,'stackable','paper','none',-1,325,0,'true','true','true','true','C4Item','castle_guard'),
(6424,'Jade Ugly Fish','false','none',100,'stackable','paper','none',-1,340,0,'true','true','true','true','C4Item','castle_guard'),
(6425,'Jade Fat Fish','false','none',100,'stackable','paper','none',-1,355,0,'true','true','true','true','C4Item','castle_guard'),
(6426,'Big Jade Nimble Fish','false','none',100,'stackable','paper','none',-1,365,0,'true','true','true','true','C4Item','castle_guard'),
(6427,'Big Jade Ugly Fish','false','none',100,'stackable','paper','none',-1,375,0,'true','true','true','true','C4Item','castle_guard'),
(6428,'Big Jade Fat Fish','false','none',100,'stackable','paper','none',-1,385,0,'true','true','true','true','C4Item','castle_guard'),
(6429,'Small Blue Nimble Fish','false','none',100,'stackable','paper','none',-1,395,0,'true','true','true','true','C4Item','castle_guard'),
(6430,'Small Blue Ugly Fish','false','none',100,'stackable','paper','none',-1,400,0,'true','true','true','true','C4Item','castle_guard'),
(6431,'Small Blue Fat Fish','false','none',100,'stackable','paper','none',-1,410,0,'true','true','true','true','C4Item','castle_guard'),
(6432,'Blue Nimble Fish','false','none',100,'stackable','paper','none',-1,415,0,'true','true','true','true','C4Item','castle_guard'),
(6433,'Blue Ugly Fish','false','none',100,'stackable','paper','none',-1,418,0,'true','true','true','true','C4Item','castle_guard'),
(6434,'Blue Fat Fish','false','none',100,'stackable','paper','none',-1,420,0,'true','true','true','true','C4Item','castle_guard'),
(6435,'Big Blue Nimble Fish','false','none',100,'stackable','paper','none',-1,425,0,'true','true','true','true','C4Item','castle_guard'),
(6436,'Big Blue Ugly Fish','false','none',100,'stackable','paper','none',-1,431,0,'true','true','true','true','C4Item','castle_guard'),
(6437,'Big Blue Fat Fish','false','none',100,'stackable','paper','none',-1,435,0,'true','true','true','true','C4Item','castle_guard'),
(6438,'Small Yellow Nimble Fish','false','none',100,'stackable','paper','none',-1,442,0,'true','true','true','true','C4Item','castle_guard'),
(6439,'Small Yellow Ugly Fish','false','none',100,'stackable','paper','none',-1,447,0,'true','true','true','true','C4Item','castle_guard'),
(6440,'Small Yellow Fat Fish','false','none',100,'stackable','paper','none',-1,452,0,'true','true','true','true','C4Item','castle_guard'),
(6441,'Yellow Nimble Fish','false','none',100,'stackable','paper','none',-1,540,0,'true','true','true','true','C4Item','castle_guard'),
(6442,'Yellow Ugly Fish','false','none',100,'stackable','paper','none',-1,553,0,'true','true','true','true','C4Item','castle_guard'),
(6443,'Yellow Fat Fish','false','none',100,'stackable','paper','none',-1,568,0,'true','true','true','true','C4Item','castle_guard'),
(6444,'Big Yellow Nimble Fish','false','none',100,'stackable','paper','none',-1,580,0,'true','true','true','true','C4Item','castle_guard'),
(6445,'Big Yellow Ugly Fish','false','none',100,'stackable','paper','none',-1,594,0,'true','true','true','true','C4Item','castle_guard'),
(6446,'Big Yellow Fat Fish','false','none',100,'stackable','paper','none',-1,608,0,'true','true','true','true','C4Item','castle_guard'),
(6447,'Small Orange Nimble Fish','false','none',100,'stackable','paper','none',-1,622,0,'true','true','true','true','C4Item','castle_guard'),
(6448,'Small Orange Ugly Fish','false','none',100,'stackable','paper','none',-1,635,0,'true','true','true','true','C4Item','castle_guard'),
(6449,'Small Orange Fat Fish','false','none',100,'stackable','paper','none',-1,649,0,'true','true','true','true','C4Item','castle_guard'),
(6450,'Orange Nimble Fish','false','none',100,'stackable','paper','none',-1,663,0,'true','true','true','true','C4Item','castle_guard'),
(6451,'Orange Ugly Fish','false','none',100,'stackable','paper','none',-1,776,0,'true','true','true','true','C4Item','castle_guard'),
(6452,'Orange Fat Fish','false','none',100,'stackable','paper','none',-1,0,0,'true','true','true','true','C4Item','castle_guard'),
(6453,'Big Orange Nimble Fish','false','none',100,'stackable','paper','none',-1,816,0,'true','true','true','true','C4Item','castle_guard'),
(6454,'Big Orange Ugly Fish','false','none',100,'stackable','paper','none',-1,840,0,'true','true','true','true','C4Item','castle_guard'),
(6455,'Big Orange Fat Fish','false','none',100,'stackable','paper','none',-1,858,0,'true','true','true','true','C4Item','castle_guard'),
(6456,'Small Purple Nimble Fish','false','none',100,'stackable','paper','none',-1,875,0,'true','true','true','true','C4Item','castle_guard'),
(6457,'Small Purple Ugly Fish','false','none',100,'stackable','paper','none',-1,893,0,'true','true','true','true','C4Item','castle_guard'),
(6458,'Small Purple Fat Fish','false','none',100,'stackable','paper','none',-1,910,0,'true','true','true','true','C4Item','castle_guard'),
(6459,'Purple Nimble Fish','false','none',100,'stackable','paper','none',-1,930,0,'true','true','true','true','C4Item','castle_guard'),
(6460,'Purple Ugly Fish','false','none',100,'stackable','paper','none',-1,948,0,'true','true','true','true','C4Item','castle_guard'),
(6461,'Purple Fat Fish','false','none',100,'stackable','paper','none',-1,1090,0,'true','true','true','true','C4Item','castle_guard'),
(6462,'Big Purple Nimble Fish','false','none',100,'stackable','paper','none',-1,1111,0,'true','true','true','true','C4Item','castle_guard'),
(6463,'Big Purple Ugly Fish','false','none',100,'stackable','paper','none',-1,1133,0,'true','true','true','true','C4Item','castle_guard'),
(6464,'Big Purple Fat Fish','false','none',100,'stackable','paper','none',-1,1157,0,'true','true','true','true','C4Item','castle_guard'),
(6465,'Small Red Nimble Fish','false','none',100,'stackable','paper','none',-1,1277,0,'true','true','true','true','C4Item','castle_guard'),
(6466,'Small Red Ugly Fish','false','none',100,'stackable','paper','none',-1,1301,0,'true','true','true','true','C4Item','castle_guard'),
(6467,'Small Red Fat Fish','false','none',100,'stackable','paper','none',-1,1326,0,'true','true','true','true','C4Item','castle_guard'),
(6468,'Red Nimble Fish','false','none',100,'stackable','paper','none',-1,1351,0,'true','true','true','true','C4Item','castle_guard'),
(6469,'Red Ugly Fish','false','none',100,'stackable','paper','none',-1,1376,0,'true','true','true','true','C4Item','castle_guard'),
(6470,'Red Fat Fish','false','none',100,'stackable','paper','none',-1,1402,0,'true','true','true','true','C4Item','castle_guard'),
(6471,'Big Red Nimble Fish','false','none',100,'stackable','paper','none',-1,1577,0,'true','true','true','true','C4Item','castle_guard'),
(6472,'Big Red Ugly Fish','false','none',100,'stackable','paper','none',-1,1608,0,'true','true','true','true','C4Item','castle_guard'),
(6473,'Big Red Fat Fish','false','none',100,'stackable','paper','none',-1,1715,0,'true','true','true','true','C4Item','castle_guard'),
(6474,'Small White Nimble Fish','false','none',100,'stackable','paper','none',-1,1747,0,'true','true','true','true','C4Item','castle_guard'),
(6475,'Small White Ugly Fish','false','none',100,'stackable','paper','none',-1,1781,0,'true','true','true','true','C4Item','castle_guard'),
(6476,'Small White Fat Fish','false','none',100,'stackable','paper','none',-1,1814,0,'true','true','true','true','C4Item','castle_guard'),
(6477,'White Nimble Fish','false','none',100,'stackable','paper','none',-1,1849,0,'true','true','true','true','C4Item','castle_guard'),
(6478,'White Ugly Fish','false','none',100,'stackable','paper','none',-1,1887,0,'true','true','true','true','C4Item','castle_guard'),
(6479,'White Fat Fish','false','none',100,'stackable','paper','none',-1,1923,0,'true','true','true','true','C4Item','castle_guard'),
(6480,'Big White Nimble Fish','false','none',100,'stackable','paper','none',-1,1961,0,'true','true','true','true','C4Item','castle_guard'),
(6481,'Big White Ugly Fish','false','none',100,'stackable','paper','none',-1,2000,0,'true','true','true','true','C4Item','castle_guard'),
(6482,'Big White Fat Fish','false','none',100,'stackable','paper','none',-1,2039,0,'true','true','true','true','C4Item','castle_guard'),
(6483,'Small Black Nimble Fish','false','none',100,'stackable','paper','none',-1,0,0,'true','true','true','true','C4Item','castle_guard'),
(6484,'Small Black Ugly Fish','false','none',100,'stackable','paper','none',-1,0,0,'true','true','true','true','C4Item','castle_guard'),
(6485,'Small Black Fat Fish','false','none',100,'stackable','paper','none',-1,0,0,'true','true','true','true','C4Item','castle_guard'),
(6486,'Black Nimble Fish','false','none',100,'stackable','paper','none',-1,2309,0,'true','true','true','true','C4Item','castle_guard'),
(6487,'Black Ugly Fish','false','none',100,'stackable','paper','none',-1,2357,0,'true','true','true','true','C4Item','castle_guard'),
(6488,'Black Fat Fish','false','none',100,'stackable','paper','none',-1,0,0,'true','true','true','true','C4Item','castle_guard'),
(6489,'Big Black Nimble Fish','false','none',100,'stackable','paper','none',-1,0,0,'true','true','true','true','C4Item','castle_guard'),
(6490,'Big Black Ugly Fish','false','none',100,'stackable','paper','none',-1,2502,0,'true','true','true','true','C4Item','castle_guard'),
(6491,'Big Black Fat Fish','false','none',100,'stackable','paper','none',-1,0,0,'true','true','true','true','C4Item','castle_guard'),
(6492,'Small Green Treasure Chest','false','none',100,'stackable','paper','none',-1,153,0,'true','true','true','true','C4Item','castle_guard'),
(6493,'Green Treasure Chest','false','none',100,'stackable','paper','none',-1,208,0,'true','true','true','true','C4Item','castle_guard'),
(6494,'Big Green Treasure Chest','false','none',100,'stackable','paper','none',-1,265,0,'true','true','true','true','C4Item','castle_guard'),
(6495,'Small Jade Treasure Chest','false','none',100,'stackable','paper','none',-1,285,0,'true','true','true','true','C4Item','castle_guard'),
(6496,'Jade Treasure Chest','false','none',100,'stackable','paper','none',-1,315,0,'true','true','true','true','C4Item','castle_guard'),
(6497,'Big Jade Treasure Chest','false','none',100,'stackable','paper','none',-1,345,0,'true','true','true','true','C4Item','castle_guard'),
(6498,'Small Blue Treasure Chest','false','none',100,'stackable','paper','none',-1,395,0,'true','true','true','true','C4Item','castle_guard'),
(6499,'Blue Treasure Chest','false','none',100,'stackable','paper','none',-1,419,0,'true','true','true','true','C4Item','castle_guard'),
(6500,'Big Blue Treasure Chest','false','none',100,'stackable','paper','none',-1,435,0,'true','true','true','true','C4Item','castle_guard'),
(6501,'Small Yellow Treasure Chest','false','none',100,'stackable','paper','none',-1,452,0,'true','true','true','true','C4Item','castle_guard'),
(6502,'Yellow Treasure Chest','false','none',100,'stackable','paper','none',-1,568,0,'true','true','true','true','C4Item','castle_guard'),
(6503,'Big Yellow Treasure Chest','false','none',100,'stackable','paper','none',-1,608,0,'true','true','true','true','C4Item','castle_guard'),
(6504,'Small Orange Treasure Chest','false','none',100,'stackable','paper','none',-1,649,0,'true','true','true','true','C4Item','castle_guard'),
(6505,'Orange Treasure Chest','false','none',100,'stackable','paper','none',-1,792,0,'true','true','true','true','C4Item','castle_guard'),
(6506,'Big Orange Treasure Chest','false','none',100,'stackable','paper','none',-1,858,0,'true','true','true','true','C4Item','castle_guard'),
(6507,'Small Purple Treasure Chest','false','none',100,'stackable','paper','none',-1,910,0,'true','true','true','true','C4Item','castle_guard'),
(6508,'Purple Treasure Chest','false','none',100,'stackable','paper','none',-1,1090,0,'true','true','true','true','C4Item','castle_guard'),
(6509,'Big Purple Treasure Chest','false','none',100,'stackable','paper','none',-1,1157,0,'true','true','true','true','C4Item','castle_guard'),
(6510,'Small Red Treasure Chest','false','none',100,'stackable','paper','none',-1,1326,0,'true','true','true','true','C4Item','castle_guard'),
(6511,'Red Treasure Chest','false','none',100,'stackable','paper','none',-1,1402,0,'true','true','true','true','C4Item','castle_guard'),
(6512,'Big Red Treasure Chest','false','none',100,'stackable','paper','none',-1,1715,0,'true','true','true','true','C4Item','castle_guard'),
(6513,'Small White Treasure Chest','false','none',100,'stackable','paper','none',-1,1814,0,'true','true','true','true','C4Item','castle_guard'),
(6514,'White Treasure Chest','false','none',100,'stackable','paper','none',-1,1923,0,'true','true','true','true','C4Item','castle_guard'),
(6515,'Big White Treasure Chest','false','none',100,'stackable','paper','none',-1,2039,0,'true','true','true','true','C4Item','castle_guard'),
(6516,'Small Black Treasure Chest','false','none',100,'stackable','paper','none',-1,2166,0,'true','true','true','true','C4Item','castle_guard'),
(6517,'Black Treasure Chest','false','none',100,'stackable','paper','none',-1,2403,0,'true','true','true','true','C4Item','castle_guard'),
(6518,'Big Black Treasure Chest','false','none',100,'stackable','paper','none',-1,0,0,'true','true','true','true','C4Item','castle_guard'),
(6519,'Green Colored Lure - Low Grade','false','lure',5,'stackable','liquid','none',-1,100,0,'true','true','true','true','C4Item','castle_guard'),
(6520,'Green Colored Lure','false','lure',4,'stackable','liquid','none',-1,120,0,'true','true','true','true','C4Item','castle_guard'),
(6521,'Green Colored Lure - High Grade','false','lure',3,'stackable','liquid','none',-1,150,0,'true','true','true','true','C4Item','castle_guard'),
(6522,'Purple Colored Lure - Low Grade','false','lure',5,'stackable','liquid','none',-1,150,0,'true','true','true','true','C4Item','castle_guard'),
(6523,'Purple Colored Lure','false','lure',4,'stackable','liquid','none',-1,180,0,'true','true','true','true','C4Item','castle_guard'),
(6524,'Purple Colored Lure - High Grade','false','lure',3,'stackable','liquid','none',-1,200,0,'true','true','true','true','C4Item','castle_guard'),
(6525,'Yellow Colored Lure - Low Grade','false','lure',5,'stackable','liquid','none',-1,120,0,'true','true','true','true','C4Item','castle_guard'),
(6526,'Yellow Colored Lure','false','lure',4,'stackable','liquid','none',-1,150,0,'true','true','true','true','C4Item','castle_guard'),
(6527,'Yellow Colored Lure - High Grade','false','lure',3,'stackable','liquid','none',-1,180,0,'true','true','true','true','C4Item','castle_guard'),
(6528,'Event bait','false','lure',3,'stackable','liquid','none',-1,0,0,'true','true','true','true','C4Item','castle_guard'),
(6535,'Fishing Shot: non-grade','false','shot',3,'stackable','paper','none',-1,3,0,'true','true','true','true','Fishing Shot: non-grade','none'),
(6536,'Fishing Shot: D-grade','false','shot',3,'stackable','paper','d',-1,5,0,'true','true','true','true','Fishing Shot: D-grade','none'),
(6537,'Fishing Shot: C-grade','false','shot',3,'stackable','paper','c',-1,7,0,'true','true','true','true','Fishing Shot: C-grade','none'),
(6538,'Fishing Shot: B-grade','false','shot',3,'stackable','paper','b',-1,25,0,'true','true','true','true','Fishing Shot: B-grade','none'),
(6539,'Fishing Shot: A-grade','false','shot',3,'stackable','paper','a',-1,40,0,'true','true','true','true','Fishing Shot: A-grade','none'),
(6540,'Fishing Shot: S-grade','false','shot',3,'stackable','paper','s',-1,50,0,'true','true','true','true','Fishing Shot: S-grade','none'),
(6541,'Blue Coba','false','none',2,'stackable','paper','none',-1,1250,0,'true','true','true','true','C5Item','none'),
(6542,'Red Coba','false','none',2,'stackable','paper','none',-1,1500,0,'true','true','true','true','C5Item','none'),
(6543,'Gold Coba','false','none',2,'stackable','paper','none',-1,1750,0,'true','true','true','true','C5Item','none'),
(6544,'Desert Coba','false','none',2,'stackable','paper','none',-1,2000,0,'true','true','true','true','C5Item','none'),
(6545,'Sea Coba','false','none',2,'stackable','paper','none',-1,2250,0,'true','true','true','true','C5Item','none'),
(6546,'Twin Coba','false','none',2,'stackable','paper','none',-1,2500,0,'true','true','true','true','C5Item','none'),
(6547,'King Coba','false','none',2,'stackable','paper','none',-1,2750,0,'true','true','true','true','C5Item','none'),
(6548,'Alternative Blue Coba','false','none',2,'stackable','paper','none',-1,1250,0,'true','true','true','true','C5Item','none'),
(6549,'Alternative Red Coba','false','none',2,'stackable','paper','none',-1,1500,0,'true','true','true','true','C5Item','none'),
(6550,'Alternative Gold Coba','false','none',2,'stackable','paper','none',-1,1750,0,'true','true','true','true','C5Item','none'),
(6551,'Alternative Desert Coba','false','none',2,'stackable','paper','none',-1,2000,0,'true','true','true','true','C5Item','none'),
(6552,'Alternative Sea Coba','false','none',2,'stackable','paper','none',-1,2250,0,'true','true','true','true','C5Item','none'),
(6553,'Alternative Twin Coba','false','none',2,'stackable','paper','none',-1,2500,0,'true','true','true','true','C5Item','none'),
(6554,'Alternative King Coba','false','none',2,'stackable','paper','none',-1,2750,0,'true','true','true','true','C5Item','none'),
(6555,'Ripe Blue Coba','false','none',1,'stackable','paper','none',-1,0,0,'true','true','true','true','C5Item','none'),
(6556,'Ripe Red Coba','false','none',1,'stackable','paper','none',-1,0,0,'true','true','true','true','C5Item','none'),
(6557,'Ripe Gold Coba','false','none',1,'stackable','paper','none',-1,0,0,'true','true','true','true','C5Item','none'),
(6558,'Ripe Desert Coba','false','none',1,'stackable','paper','none',-1,0,0,'true','true','true','true','C5Item','none'),
(6559,'Ripe Sea Coba','false','none',1,'stackable','paper','none',-1,0,0,'true','true','true','true','C5Item','none'),
(6560,'Ripe Twin Coba','false','none',1,'stackable','paper','none',-1,0,0,'true','true','true','true','C5Item','none'),
(6561,'Ripe King Coba','false','none',1,'stackable','paper','none',-1,0,0,'true','true','true','true','C5Item','none'),
(6562,'Ripe Alternative Blue Coba','false','none',1,'stackable','paper','none',-1,0,0,'true','true','true','true','C5Item','none'),
(6563,'Ripe Alternative Red Coba','false','none',1,'stackable','paper','none',-1,0,0,'true','true','true','true','C5Item','none'),
(6564,'Ripe Alternative Gold Coba','false','none',1,'stackable','paper','none',-1,0,0,'true','true','true','true','C5Item','none'),
(6565,'Ripe Alternative Desert Coba','false','none',1,'stackable','paper','none',-1,0,0,'true','true','true','true','C5Item','none'),
(6566,'Ripe Alternative Sea Coba','false','none',1,'stackable','paper','none',-1,0,0,'true','true','true','true','C5Item','none'),
(6567,'Ripe Alternative Twin Coba','false','none',1,'stackable','paper','none',-1,0,0,'true','true','true','true','C5Item','none'),
(6568,'Ripe Alternative King Coba','false','none',1,'stackable','paper','none',-1,0,0,'true','true','true','true','C5Item','none'),
(6569,'Blessed Scroll: Enchant Weapon (A)','false','scroll',120,'stackable','paper','none',-1,1750000,0,'true','true','true','true','C4Item','castle_guard'),
(6570,'Blessed Scroll: Enchant Armor (A)','false','scroll',120,'stackable','paper','none',-1,750000,0,'true','true','true','true','C4Item','castle_guard'),
(6571,'Blessed Scroll: Enchant Weapon (B)','false','scroll',120,'stackable','paper','none',-1,1250000,0,'true','true','true','true','C4Item','castle_guard'),
(6572,'Blessed Scroll: Enchant Armor (B)','false','scroll',120,'stackable','paper','none',-1,250000,0,'true','true','true','true','C4Item','castle_guard'),
(6573,'Blessed Scroll: Enchant Weapon (C)','false','scroll',120,'stackable','paper','none',-1,250000,0,'true','true','true','true','C4Item','castle_guard'),
(6574,'Blessed Scroll: Enchant Armor (C)','false','scroll',120,'stackable','paper','none',-1,100000,0,'true','true','true','true','C4Item','castle_guard'),
(6575,'Blessed Scroll: Enchant Weapon (D)','false','scroll',120,'stackable','paper','none',-1,150000,0,'true','true','true','true','C4Item','castle_guard'),
(6576,'Blessed Scroll: Enchant Armor (D)','false','scroll',120,'stackable','paper','none',-1,50000,0,'true','true','true','true','C4Item','castle_guard'),
(6577,'Blessed Scroll: Enchant Weapon (S)','false','scroll',120,'stackable','paper','none',-1,2250000,0,'true','true','true','true','C4Item','castle_guard'),
(6578,'Blessed Scroll: Enchant Armor (S)','false','scroll',120,'stackable','paper','none',-1,1250000,0,'true','true','true','true','C4Item','castle_guard'),
(6622,'Secret Book of Giants','false','none',10,'normal','paper','none',-1,500000,0,'true','true','true','true','C4Item','castle_guard'),
(6623,'Dummy - Quest Item 1','false','quest',0,'stackable','steel','none',-1,0,0,'false','false','true','false','C4Item','castle_guard'),
(6624,'Dummy - Quest Item 2','false','quest',0,'stackable','steel','none',-1,0,0,'false','false','true','false','C4Item','castle_guard'),
(6625,'Dummy - Quest Item 3','false','quest',0,'stackable','steel','none',-1,0,0,'false','false','true','false','C4Item','castle_guard'),
(6626,'Dummy - Quest Item 4','false','quest',0,'stackable','steel','none',-1,0,0,'false','false','true','false','C4Item','castle_guard'),
(6627,'Dummy - Quest Item 5','false','quest',0,'stackable','steel','none',-1,0,0,'false','false','true','false','C4Item','castle_guard'),
(6628,'Dummy - Quest Item 6','false','quest',0,'stackable','steel','none',-1,0,0,'false','false','true','false','C4Item','castle_guard'),
(6629,'Dummy - Quest Item 7','false','quest',0,'stackable','steel','none',-1,0,0,'false','false','true','false','C4Item','castle_guard'),
(6630,'Dummy - Quest Item 8','false','quest',0,'stackable','steel','none',-1,0,0,'false','false','true','false','C4Item','castle_guard'),
(6631,'Dummy - Quest Item 9','false','quest',0,'stackable','steel','none',-1,0,0,'false','false','true','false','C4Item','castle_guard'),
(6632,'Dummy - Quest Item 10','false','quest',0,'stackable','steel','none',-1,0,0,'false','false','true','false','C4Item','castle_guard'),
(6633,'Dummy - General Item 1','false','none',0,'stackable','steel','none',-1,0,0,'true','true','true','true','C4Item','castle_guard'),
(6634,'Dummy - General Item 2','false','none',0,'stackable','steel','none',-1,0,0,'true','true','true','true','C4Item','castle_guard'),
(6635,'Dummy - General Item 3','false','none',0,'stackable','steel','none',-1,0,0,'true','true','true','true','C4Item','castle_guard'),
(6636,'Dummy - General Item 4','false','none',0,'stackable','steel','none',-1,0,0,'true','true','true','true','C4Item','castle_guard'),
(6637,'Dummy - General Item 5','false','none',0,'stackable','steel','none',-1,0,0,'true','true','true','true','C4Item','castle_guard'),
(6638,'Dummy - General Item 6','false','none',0,'stackable','steel','none',-1,0,0,'true','true','true','true','C4Item','castle_guard'),
(6639,'Dummy - General Item 7','false','none',0,'stackable','steel','none',-1,0,0,'true','true','true','true','C4Item','castle_guard'),
(6640,'Dummy - General Item 8','false','none',0,'stackable','steel','none',-1,0,0,'true','true','true','true','C4Item','castle_guard'),
(6641,'Dummy - General Item 9','false','none',0,'stackable','steel','none',-1,0,0,'true','true','true','true','C4Item','castle_guard'),
(6642,'Dummy - General Item 10','false','none',0,'stackable','steel','none',-1,0,0,'true','true','true','true','C4Item','castle_guard'),
(6643,'Golden Spice','false','none',40,'stackable','paper','none',-1,50,0,'true','true','true','true','C4Item','castle_guard'),
(6644,'Crystal Spice','false','none',40,'stackable','paper','none',-1,50,0,'true','true','true','true','C4Item','castle_guard'),
(6645,'Beast Soulshot','false','shot',1,'stackable','paper','none',-1,20,0,'true','true','true','true','Beast Soulshot','none'),
(6646,'Beast Spiritshot','false','shot',2,'stackable','paper','none',-1,40,0,'true','true','true','true','Beast Spiritshot','none'),
(6647,'Blessed Beast Spiritshot','false','shot',2,'stackable','paper','none',-1,100,0,'true','true','true','true','Blessed Beast Spiritshot','none'),
(6648,'Baby Buffalo Panpipe','false','pet_collar',20,'normal','leather','none',-1,0,0,'true','true','true','true','C4Item','pet_collar'),
(6649,'Baby Cougar Chime','false','pet_collar',20,'normal','leather','none',-1,0,0,'true','true','true','true','C4Item','pet_collar'),
(6650,'Baby Kookaburra Ocarina','false','pet_collar',20,'normal','leather','none',-1,0,0,'true','true','true','true','C4Item','pet_collar'),
(6651,'Noblesse Gate Pass','false','quest',0,'stackable','paper','none',-1,0,0,'false','false','true','false','C4Item','castle_guard'),
(6652,'Scroll: Protection of Valakas','false','scroll',10,'stackable','paper','none',-1,100000,0,'true','true','true','true','C4Item','castle_guard'),
(6653,'Scroll: Flames of Valakas','false','scroll',10,'stackable','paper','none',-1,0,0,'true','true','true','true','C4Item','castle_guard'),
(6654,'Scroll: Flames of Valakas','false','scroll',10,'stackable','paper','none',-1,40000,0,'true','true','true','true','C4Item','castle_guard'),
(6655,'Scroll: Slay Valakas','false','scroll',10,'stackable','paper','none',-1,0,0,'true','true','true','true','C4Item','castle_guard'),
(6663,'Scroll of Escape: Orc Village','false','scroll',120,'stackable','paper','none',-1,400,0,'true','true','true','true','C4Item','castle_guard'),
(6664,'Scroll of Escape: Silenos Village','false','scroll',120,'stackable','paper','none',-1,400,0,'true','true','true','true','C4Item','castle_guard'),
(6665,'Deluxe Chest Key - Grade 1','false','none',10,'stackable','steel','none',-1,0,0,'true','true','true','true','C4Item','castle_guard'),
(6666,'Deluxe Chest Key - Grade 2','false','none',10,'stackable','steel','none',-1,200,0,'true','true','true','true','C4Item','castle_guard'),
(6667,'Deluxe Chest Key - Grade 3','false','none',10,'stackable','steel','none',-1,320,0,'true','true','true','true','C4Item','castle_guard'),
(6668,'Deluxe Chest Key - Grade 4','false','none',10,'stackable','steel','none',-1,560,0,'true','true','true','true','C4Item','castle_guard'),
(6669,'Deluxe Chest Key - Grade 5','false','none',10,'stackable','steel','none',-1,860,0,'true','true','true','true','C4Item','castle_guard'),
(6670,'Deluxe Chest Key - Grade 6','false','none',10,'stackable','steel','none',-1,1200,0,'true','true','true','true','C4Item','castle_guard'),
(6671,'Deluxe Chest Key - Grade 7','false','none',10,'stackable','steel','none',-1,1800,0,'true','true','true','true','C4Item','castle_guard'),
(6672,'Deluxe Chest Key - Grade 8','false','none',10,'stackable','steel','none',-1,2400,0,'true','true','true','true','C4Item','castle_guard'),
(6673,'Festival Adena','false','none',0,'stackable','steel','none',-1,0,0,'false','false','true','false','C4Item','none'),
(6688,'Forgotten Blade Edge','false','material',60,'stackable','liquid','none',-1,92529,0,'true','true','true','true','C4Item','none'),
(6689,'Basalt Battlehammer Head','false','material',60,'stackable','liquid','none',-1,94306,0,'true','true','true','true','C4Item','none'),
(6690,'Imperial Staff Head','false','material',60,'stackable','liquid','none',-1,92353,0,'true','true','true','true','C4Item','none'),
(6691,'Angel Slayer Blade','false','material',60,'stackable','liquid','none',-1,92529,0,'true','true','true','true','C4Item','none'),
(6692,'Shining Bow Shaft','false','material',60,'stackable','liquid','none',-1,90882,0,'true','true','true','true','C4Item','none'),
(6693,'Dragon Hunter Axe Blade','false','material',60,'stackable','liquid','none',-1,90882,0,'true','true','true','true','C4Item','none'),
(6694,'Saint Spear Blade','false','material',60,'stackable','liquid','none',-1,90882,0,'true','true','true','true','C4Item','none'),
(6695,'Demon Splinter Blade','false','material',60,'stackable','liquid','none',-1,94306,0,'true','true','true','true','C4Item','none'),
(6696,'Heavens Divider Edge','false','material',60,'stackable','liquid','none',-1,91082,0,'true','true','true','true','C4Item','none'),
(6697,'Arcana Mace Head','false','material',60,'stackable','liquid','none',-1,94306,0,'true','true','true','true','C4Item','none'),
(6698,'Sealed Tateossian Earring Part','false','material',60,'stackable','liquid','none',-1,10182,0,'true','true','true','true','C4Item','none'),
(6699,'Sealed Tateossian Ring Gem','false','material',60,'stackable','liquid','none',-1,9176,0,'true','true','true','true','C4Item','none'),
(6700,'Sealed Tateossian Necklace Chain','false','material',60,'stackable','liquid','none',-1,16706,0,'true','true','true','true','C4Item','none'),
(6701,'Sealed Imperial Crusader Breastplate Part','false','material',60,'stackable','liquid','none',-1,37565,0,'true','true','true','true','C4Item','none'),
(6702,'Sealed Imperial Crusader Gaiters Pattern','false','material',60,'stackable','liquid','none',-1,29182,0,'true','true','true','true','C4Item','none'),
(6703,'Sealed Imperial Crusader Gauntlets Design','false','material',60,'stackable','liquid','none',-1,14047,0,'true','true','true','true','C4Item','none'),
(6704,'Sealed Imperial Crusader Boots Design','false','material',60,'stackable','liquid','none',-1,14047,0,'true','true','true','true','C4Item','none'),
(6705,'Sealed Imperial Crusader Shield Part','false','material',60,'stackable','liquid','none',-1,14341,0,'true','true','true','true','C4Item','none'),
(6706,'Sealed Imperial Crusader Helmet Pattern','false','material',60,'stackable','liquid','none',-1,12329,0,'true','true','true','true','C4Item','none'),
(6707,'Sealed Draconic Leather Armor Part','false','material',60,'stackable','liquid','none',-1,40365,0,'true','true','true','true','C4Item','none'),
(6708,'Sealed Draconic Leather Gloves Fabric','false','material',60,'stackable','liquid','none',-1,14047,0,'true','true','true','true','C4Item','none'),
(6709,'Sealed Draconic Leather Boots Design','false','material',60,'stackable','liquid','none',-1,14047,0,'true','true','true','true','C4Item','none'),
(6710,'Sealed Draconic Leather Helmet Pattern','false','material',60,'stackable','liquid','none',-1,12329,0,'true','true','true','true','C4Item','none'),
(6711,'Sealed Major Arcana Robe Part','false','material',60,'stackable','liquid','none',-1,40365,0,'true','true','true','true','C4Item','none'),
(6712,'Sealed Major Arcana Gloves fabric','false','material',60,'stackable','liquid','none',-1,14047,0,'true','true','true','true','C4Item','none'),
(6713,'Sealed Major Arcana Boots Design','false','material',60,'stackable','liquid','none',-1,14047,0,'true','true','true','true','C4Item','none'),
(6714,'Sealed Major Arcana Circlet Pattern','false','material',60,'stackable','liquid','none',-1,12329,0,'true','true','true','true','C4Item','none'),
(6727,'Seed: Alternative Great Coba','false','seed',1,'stackable','paper','none',-1,1200,0,'true','true','true','true','C5Item','none'),
(6728,'Seed: Alternative Sea Coba','false','seed',1,'stackable','paper','none',-1,900,0,'true','true','true','true','C5Item','none'),
(6729,'Seed: Alternative Sea Coba','false','seed',1,'stackable','paper','none',-1,900,0,'true','true','true','true','C5Item','none'),
(6730,'Seed: Alternative Sea Coba','false','seed',1,'stackable','paper','none',-1,900,0,'true','true','true','true','C5Item','none'),
(6731,'Seed: Alternative Red Coba','false','seed',1,'stackable','paper','none',-1,500,0,'true','true','true','true','C5Item','none'),
(6732,'Seed: Alternative Red Coba','false','seed',1,'stackable','paper','none',-1,500,0,'true','true','true','true','C5Item','none'),
(6733,'Seed: Alternative Red Coba','false','seed',1,'stackable','paper','none',-1,500,0,'true','true','true','true','C5Item','none'),
(6734,'Seed: Alternative Red Coba','false','seed',1,'stackable','paper','none',-1,500,0,'true','true','true','true','C5Item','none'),
(6735,'Seed: Alternative Red Coba','false','seed',1,'stackable','paper','none',-1,500,0,'true','true','true','true','C5Item','none'),
(6736,'Seed: Alternative Desert Coba','false','seed',1,'stackable','paper','none',-1,750,0,'true','true','true','true','C5Item','none'),
(6737,'Seed: Alternative Desert Coba','false','seed',1,'stackable','paper','none',-1,750,0,'true','true','true','true','C5Item','none'),
(6738,'Seed: Alternative Desert Coba','false','seed',1,'stackable','paper','none',-1,750,0,'true','true','true','true','C5Item','none'),
(6739,'Seed: Alternative Desert Coba','false','seed',1,'stackable','paper','none',-1,750,0,'true','true','true','true','C5Item','none'),
(6740,'Seed: Alternative Desert Coba','false','seed',1,'stackable','paper','none',-1,750,0,'true','true','true','true','C5Item','none'),
(6741,'Seed: Alternative Twin Coba','false','seed',1,'stackable','paper','none',-1,1000,0,'true','true','true','true','C5Item','none'),
(6742,'Seed: Alternative Blue Coba','false','seed',1,'stackable','paper','none',-1,400,0,'true','true','true','true','C5Item','none'),
(6743,'Seed: Alternative Blue Coba','false','seed',1,'stackable','paper','none',-1,400,0,'true','true','true','true','C5Item','none'),
(6744,'Seed: Alternative Blue Coba','false','seed',1,'stackable','paper','none',-1,400,0,'true','true','true','true','C5Item','none'),
(6745,'Seed: Alternative Blue Coba','false','seed',1,'stackable','paper','none',-1,400,0,'true','true','true','true','C5Item','none'),
(6746,'Seed: Alternative Blue Coba','false','seed',1,'stackable','paper','none',-1,400,0,'true','true','true','true','C5Item','none'),
(6747,'Seed: Alternative Golden Coba','false','seed',1,'stackable','paper','none',-1,650,0,'true','true','true','true','C5Item','none'),
(6748,'Seed: Alternative Golden Coba','false','seed',1,'stackable','paper','none',-1,650,0,'true','true','true','true','C5Item','none'),
(6749,'Seed: Alternative Golden Coba','false','seed',1,'stackable','paper','none',-1,650,0,'true','true','true','true','C5Item','none'),
(6750,'Seed: Alternative Golden Coba','false','seed',1,'stackable','paper','none',-1,650,0,'true','true','true','true','C5Item','none'),
(6751,'Seed: Alternative Golden Coba','false','seed',1,'stackable','paper','none',-1,650,0,'true','true','true','true','C5Item','none'),
(6752,'Seed: Alternative Golden Coba','false','seed',1,'stackable','paper','none',-1,650,0,'true','true','true','true','C5Item','none'),
(6753,'Seed: Great Coba','false','seed',1,'stackable','paper','none',-1,1200,0,'true','true','true','true','C5Item','none'),
(6754,'Seed: Sea Coba','false','seed',1,'stackable','paper','none',-1,900,0,'true','true','true','true','C5Item','none'),
(6755,'Seed: Sea Coba','false','seed',1,'stackable','paper','none',-1,900,0,'true','true','true','true','C5Item','none'),
(6756,'Seed: Sea Coba','false','seed',1,'stackable','paper','none',-1,900,0,'true','true','true','true','C5Item','none'),
(6757,'Seed: Red Coba','false','seed',1,'stackable','paper','none',-1,500,0,'true','true','true','true','C5Item','none'),
(6758,'Seed: Red Coba','false','seed',1,'stackable','paper','none',-1,500,0,'true','true','true','true','C5Item','none'),
(6759,'Seed: Red Coba','false','seed',1,'stackable','paper','none',-1,500,0,'true','true','true','true','C5Item','none'),
(6760,'Seed: Red Coba','false','seed',1,'stackable','paper','none',-1,500,0,'true','true','true','true','C5Item','none'),
(6761,'Seed: Red Coba','false','seed',1,'stackable','paper','none',-1,500,0,'true','true','true','true','C5Item','none'),
(6762,'Seed: Desert Coba','false','seed',1,'stackable','paper','none',-1,750,0,'true','true','true','true','C5Item','none'),
(6763,'Seed: Desert Coba','false','seed',1,'stackable','paper','none',-1,750,0,'true','true','true','true','C5Item','none'),
(6764,'Seed: Desert Coba','false','seed',1,'stackable','paper','none',-1,750,0,'true','true','true','true','C5Item','none'),
(6765,'Seed: Desert Coba','false','seed',1,'stackable','paper','none',-1,750,0,'true','true','true','true','C5Item','none'),
(6766,'Seed: Desert Coba','false','seed',1,'stackable','paper','none',-1,750,0,'true','true','true','true','C5Item','none'),
(6767,'Seed: Twin Coba','false','seed',1,'stackable','paper','none',-1,1000,0,'true','true','true','true','C5Item','none'),
(6768,'Seed: Blue Coba','false','seed',1,'stackable','paper','none',-1,400,0,'true','true','true','true','C5Item','none'),
(6769,'Seed: Blue Coba','false','seed',1,'stackable','paper','none',-1,400,0,'true','true','true','true','C5Item','none'),
(6770,'Seed: Blue Coba','false','seed',1,'stackable','paper','none',-1,400,0,'true','true','true','true','C5Item','none'),
(6771,'Seed: Blue Coba','false','seed',1,'stackable','paper','none',-1,400,0,'true','true','true','true','C5Item','none'),
(6772,'Seed: Blue Coba','false','seed',1,'stackable','paper','none',-1,400,0,'true','true','true','true','C5Item','none'),
(6773,'Seed: Golden Coba','false','seed',1,'stackable','paper','none',-1,650,0,'true','true','true','true','C5Item','none'),
(6774,'Seed: Golden Coba','false','seed',1,'stackable','paper','none',-1,650,0,'true','true','true','true','C5Item','none'),
(6775,'Seed: Golden Coba','false','seed',1,'stackable','paper','none',-1,650,0,'true','true','true','true','C5Item','none'),
(6776,'Seed: Golden Coba','false','seed',1,'stackable','paper','none',-1,650,0,'true','true','true','true','C5Item','none'),
(6777,'Seed: Golden Coba','false','seed',1,'stackable','paper','none',-1,650,0,'true','true','true','true','C5Item','none'),
(6778,'Seed: Golden Coba','false','seed',1,'stackable','paper','none',-1,650,0,'true','true','true','true','C5Item','none'),
(6779,'Mercenary Posting Ticket (Sword/Stationary)','false','castle_guard',0,'stackable','paper','none',-1,0,0,'true','true','true','true','C4Item','none'),
(6780,'Mercenary Posting Ticket (Spear/Stationary)','false','castle_guard',0,'stackable','paper','none',-1,0,0,'true','true','true','true','C4Item','none'),
(6781,'Mercenary Posting Ticket (Bow/Stationary)','false','castle_guard',0,'stackable','paper','none',-1,0,0,'true','true','true','true','C4Item','none'),
(6782,'Mercenary Posting Ticket (Cleric/Stationary)','false','castle_guard',0,'stackable','paper','none',-1,0,0,'true','true','true','true','C4Item','none'),
(6783,'Mercenary Posting Ticket (Wizard/Stationary)','false','castle_guard',0,'stackable','paper','none',-1,0,0,'true','true','true','true','C4Item','none'),
(6784,'Mercenary Posting Ticket (Sword/Mobile)','false','castle_guard',0,'stackable','paper','none',-1,0,0,'true','true','true','true','C4Item','none'),
(6785,'Mercenary Posting Ticket (Spear/Mobile)','false','castle_guard',0,'stackable','paper','none',-1,0,0,'true','true','true','true','C4Item','none'),
(6786,'Mercenary Posting Ticket (Bow/Mobile)','false','castle_guard',0,'stackable','paper','none',-1,0,0,'true','true','true','true','C4Item','none'),
(6787,'Mercenary Posting Ticket (Cleric/Mobile)','false','castle_guard',0,'stackable','paper','none',-1,0,0,'true','true','true','true','C4Item','none'),
(6788,'Mercenary Posting Ticket (Wizard/Mobile)','false','castle_guard',0,'stackable','paper','none',-1,0,0,'true','true','true','true','C4Item','none'),
(6789,'Mercenary Posting Ticket (Teleporter1)','false','castle_guard',0,'stackable','paper','none',-1,0,0,'true','true','true','true','C4Item','none'),
(6790,'Mercenary Posting Ticket (Teleporter2)','false','castle_guard',0,'stackable','paper','none',-1,0,0,'true','true','true','true','C4Item','none'),
(6791,'Mercenary Posting Ticket (Teleporter3)','false','castle_guard',0,'stackable','paper','none',-1,0,0,'true','true','true','true','C4Item','none'),
(6792,'Greater Mercenary Posting Ticket (Sword/Stationary)','false','castle_guard',0,'stackable','paper','none',-1,0,0,'true','true','true','true','C4Item','none'),
(6793,'Greater Mercenary Posting Ticket (Spear/Stationary)','false','castle_guard',0,'stackable','paper','none',-1,0,0,'true','true','true','true','C4Item','none'),
(6794,'Greater Mercenary Posting Ticket (Bow/Stationary)','false','castle_guard',0,'stackable','paper','none',-1,0,0,'true','true','true','true','C4Item','none'),
(6795,'Greater Mercenary Posting Ticket (Cleric/Stationary)','false','castle_guard',0,'stackable','paper','none',-1,0,0,'true','true','true','true','C4Item','none'),
(6796,'Greater Mercenary Posting Ticket (Wizard/Stationary)','false','castle_guard',0,'stackable','paper','none',-1,0,0,'true','true','true','true','C4Item','none'),
(6797,'Greater Mercenary Posting Ticket (Sword/Mobile)','false','castle_guard',0,'stackable','paper','none',-1,0,0,'true','true','true','true','C4Item','none'),
(6798,'Greater Mercenary Posting Ticket (Spear/Mobile)','false','castle_guard',0,'stackable','paper','none',-1,0,0,'true','true','true','true','C4Item','none'),
(6799,'Greater Mercenary Posting Ticket (Bow/Mobile)','false','castle_guard',0,'stackable','paper','none',-1,0,0,'true','true','true','true','C4Item','none'),
(6800,'Greater Mercenary Posting Ticket (Cleric/Mobile)','false','castle_guard',0,'stackable','paper','none',-1,0,0,'true','true','true','true','C4Item','none'),
(6801,'Greater Mercenary Posting Ticket (Wizard/Mobile)','false','castle_guard',0,'stackable','paper','none',-1,0,0,'true','true','true','true','C4Item','none'),
(6802,'Dawn Mercenary Posting Ticket (Sword/Stationary)','false','castle_guard',0,'stackable','paper','none',-1,0,0,'true','true','true','true','C4Item','none'),
(6803,'Dawn Mercenary Posting Ticket (Spear/Stationary)','false','castle_guard',0,'stackable','paper','none',-1,0,0,'true','true','true','true','C4Item','none'),
(6804,'Dawn Mercenary Posting Ticket (Bow/Stationary)','false','castle_guard',0,'stackable','paper','none',-1,0,0,'true','true','true','true','C4Item','none'),
(6805,'Dawn Mercenary Posting Ticket (Cleric/Stationary)','false','castle_guard',0,'stackable','paper','none',-1,0,0,'true','true','true','true','C4Item','none'),
(6806,'Dawn Mercenary Posting Ticket (Wizard/Stationary)','false','castle_guard',0,'stackable','paper','none',-1,0,0,'true','true','true','true','C4Item','none'),
(6807,'Dawn Mercenary Posting Ticket (Sword/Mobile)','false','castle_guard',0,'stackable','paper','none',-1,0,0,'true','true','true','true','C4Item','none'),
(6808,'Dawn Mercenary Posting Ticket (Spear/Mobile)','false','castle_guard',0,'stackable','paper','none',-1,0,0,'true','true','true','true','C4Item','none'),
(6809,'Dawn Mercenary Posting Ticket (Bow/Mobile)','false','castle_guard',0,'stackable','paper','none',-1,0,0,'true','true','true','true','C4Item','none'),
(6810,'Dawn Mercenary Posting Ticket (Cleric/Mobile)','false','castle_guard',0,'stackable','paper','none',-1,0,0,'true','true','true','true','C4Item','none'),
(6811,'Dawn Mercenary Posting Ticket (Wizard/Mobile)','false','castle_guard',0,'stackable','paper','none',-1,0,0,'true','true','true','true','C4Item','none'),
(6812,'Greater Recruit Posting Ticket (Sword/Stationary)','false','castle_guard',0,'stackable','paper','none',-1,0,0,'true','true','true','true','C4Item','none'),
(6813,'Greater Recruit Posting Ticket (Spear/Stationary)','false','castle_guard',0,'stackable','paper','none',-1,0,0,'true','true','true','true','C4Item','none'),
(6814,'Greater Recruit Posting Ticket (Bow/Stationary)','false','castle_guard',0,'stackable','paper','none',-1,0,0,'true','true','true','true','C4Item','none'),
(6815,'Greater Recruit Posting Ticket (Cleric/Stationary)','false','castle_guard',0,'stackable','paper','none',-1,0,0,'true','true','true','true','C4Item','none'),
(6816,'Greater Recruit Posting Ticket (Wizard/Stationary)','false','castle_guard',0,'stackable','paper','none',-1,0,0,'true','true','true','true','C4Item','none'),
(6817,'Greater Recruit Posting Ticket (Sword/Mobile)','false','castle_guard',0,'stackable','paper','none',-1,0,0,'true','true','true','true','C4Item','none'),
(6818,'Greater Recruit Posting Ticket (Spear/Mobile)','false','castle_guard',0,'stackable','paper','none',-1,0,0,'true','true','true','true','C4Item','none'),
(6819,'Greater Recruit Posting Ticket (Bow/Mobile)','false','castle_guard',0,'stackable','paper','none',-1,0,0,'true','true','true','true','C4Item','none'),
(6820,'Greater Recruit Posting Ticket (Cleric/Mobile)','false','castle_guard',0,'stackable','paper','none',-1,0,0,'true','true','true','true','C4Item','none'),
(6821,'Greater Recruit Posting Ticket (Wizard/Mobile)','false','castle_guard',0,'stackable','paper','none',-1,0,0,'true','true','true','true','C4Item','none'),
(6822,'Recruit Posting Ticket (Sword/Stationary)','false','castle_guard',0,'stackable','paper','none',-1,0,0,'true','true','true','true','C4Item','none'),
(6823,'Recruit Posting Ticket (Spear/Stationary)','false','castle_guard',0,'stackable','paper','none',-1,0,0,'true','true','true','true','C4Item','none'),
(6824,'Recruit Posting Ticket (Bow/Stationary)','false','castle_guard',0,'stackable','paper','none',-1,0,0,'true','true','true','true','C4Item','none'),
(6825,'Recruit Posting Ticket (Cleric/Stationary)','false','castle_guard',0,'stackable','paper','none',-1,0,0,'true','true','true','true','C4Item','none'),
(6826,'Recruit Posting Ticket (Wizard/Stationary)','false','castle_guard',0,'stackable','paper','none',-1,0,0,'true','true','true','true','C4Item','none'),
(6827,'Recruit Posting Ticket (Sword/Mobile)','false','castle_guard',0,'stackable','paper','none',-1,0,0,'true','true','true','true','C4Item','none'),
(6828,'Recruit Posting Ticket (Spear/Mobile)','false','castle_guard',0,'stackable','paper','none',-1,0,0,'true','true','true','true','C4Item','none'),
(6829,'Recruit Posting Ticket (Bow/Mobile)','false','castle_guard',0,'stackable','paper','none',-1,0,0,'true','true','true','true','C4Item','none'),
(6830,'Recruit Posting Ticket (Cleric/Mobile)','false','castle_guard',0,'stackable','paper','none',-1,0,0,'true','true','true','true','C4Item','none'),
(6831,'Recruit Posting Ticket (Wizard/Mobile)','false','castle_guard',0,'stackable','paper','none',-1,0,0,'true','true','true','true','C4Item','none'),
(6832,'Nephilim Warrior Posting Ticket (Sword/Mobile)','false','castle_guard',0,'stackable','paper','none',-1,0,0,'true','true','true','true','C4Item','none'),
(6833,'Nephilim Shaman Posting Ticket (Wizard/Mobile)','false','castle_guard',0,'stackable','paper','none',-1,0,0,'true','true','true','true','C4Item','none'),
(6847,'Recipe: Sealed Tateossian Earring (70%)','false','recipe',30,'stackable','paper','none',-1,74000,0,'true','true','true','true','C4Item','none'),
(6848,'Recipe: Sealed Tateossian Earring (100%)','false','recipe',30,'stackable','paper','none',-1,74000,0,'true','true','true','true','C4Item','none'),
(6849,'Recipe: Sealed Tateossian Ring(70%)','false','recipe',30,'stackable','paper','none',-1,49400,0,'true','true','true','true','C4Item','none'),
(6850,'Recipe: Sealed Tateossian Ring(100%)','false','recipe',30,'stackable','paper','none',-1,49400,0,'true','true','true','true','C4Item','none'),
(6851,'Recipe: Sealed Tateossian Necklace(70%)','false','recipe',30,'stackable','paper','none',-1,98800,0,'true','true','true','true','C4Item','none'),
(6852,'Recipe: Sealed Tateossian Necklace(100%)','false','recipe',30,'stackable','paper','none',-1,98800,0,'true','true','true','true','C4Item','none'),
(6853,'Recipe: Sealed Imperial Crusader Breastplate (60%)','false','recipe',30,'stackable','paper','none',-1,286000,0,'true','true','true','true','C4Item','none'),
(6854,'Recipe: Sealed Imperial Crusader Breastplate (100%)','false','recipe',30,'stackable','paper','none',-1,286000,0,'true','true','true','true','C4Item','none'),
(6855,'Recipe: Sealed Imperial Crusader Gaiters (60%)','false','recipe',30,'stackable','paper','none',-1,179200,0,'true','true','true','true','C4Item','none'),
(6856,'Recipe: Sealed Imperial Crusader Gaiters (100%)','false','recipe',30,'stackable','paper','none',-1,179200,0,'true','true','true','true','C4Item','none'),
(6857,'Recipe: Sealed Imperial Crusader Gauntlets (60%)','false','recipe',30,'stackable','paper','none',-1,71600,0,'true','true','true','true','C4Item','none'),
(6858,'Recipe: Sealed Imperial Crusader Gauntlets (100%)','false','recipe',30,'stackable','paper','none',-1,71600,0,'true','true','true','true','C4Item','none'),
(6859,'Recipe: Sealed Imperial Crusader Boots (60%)','false','recipe',30,'stackable','paper','none',-1,71600,0,'true','true','true','true','C4Item','none'),
(6860,'Recipe: Sealed Imperial Crusader Boots (100%)','false','recipe',30,'stackable','paper','none',-1,71600,0,'true','true','true','true','C4Item','none'),
(6861,'Recipe: Sealed Imperial Crusader Shield (60%)','false','recipe',30,'stackable','paper','none',-1,75200,0,'true','true','true','true','C4Item','none'),
(6862,'Recipe: Sealed Imperial Crusader Shield (100%)','false','recipe',30,'stackable','paper','none',-1,75200,0,'true','true','true','true','C4Item','none'),
(6863,'Recipe: Sealed Imperial Crusader Helmet (60%)','false','recipe',30,'stackable','paper','none',-1,107400,0,'true','true','true','true','C4Item','none'),
(6864,'Recipe: Sealed Imperial Crusader Helmet (100%)','false','recipe',30,'stackable','paper','none',-1,107400,0,'true','true','true','true','C4Item','none'),
(6865,'Recipe: Sealed Draconic Leather Armor (60%)','false','recipe',30,'stackable','paper','none',-1,348000,0,'true','true','true','true','C4Item','none'),
(6866,'Recipe: Sealed Draconic Leather Armor (100%)','false','recipe',30,'stackable','paper','none',-1,348000,0,'true','true','true','true','C4Item','none'),
(6867,'Recipe: Sealed Draconic Leather Gloves (60%)','false','recipe',30,'stackable','paper','none',-1,71600,0,'true','true','true','true','C4Item','none'),
(6868,'Recipe: Sealed Draconic Leather Gloves (100%)','false','recipe',30,'stackable','paper','none',-1,71600,0,'true','true','true','true','C4Item','none'),
(6869,'Recipe: Sealed Draconic Leather Boots (60%)','false','recipe',30,'stackable','paper','none',-1,71600,0,'true','true','true','true','C4Item','none'),
(6870,'Recipe: Sealed Draconic Leather Boots (100%)','false','recipe',30,'stackable','paper','none',-1,71600,0,'true','true','true','true','C4Item','none'),
(6871,'Recipe: Sealed Draconic Leather Helmet (60%)','false','recipe',30,'stackable','paper','none',-1,107400,0,'true','true','true','true','C4Item','none'),
(6872,'Recipe: Sealed Draconic Leather Helmet (100%)','false','recipe',30,'stackable','paper','none',-1,107400,0,'true','true','true','true','C4Item','none'),
(6873,'Recipe: Sealed Major Arcana Robe (60%)','false','recipe',30,'stackable','paper','none',-1,348000,0,'true','true','true','true','C4Item','none'),
(6874,'Recipe: Sealed Major Arcana Robe (100%)','false','recipe',30,'stackable','paper','none',-1,348000,0,'true','true','true','true','C4Item','none'),
(6875,'Recipe: Sealed Major Arcana Gloves (60%)','false','recipe',30,'stackable','paper','none',-1,71600,0,'true','true','true','true','C4Item','none'),
(6876,'Recipe: Sealed Major Arcana Gloves (100%)','false','recipe',30,'stackable','paper','none',-1,71600,0,'true','true','true','true','C4Item','none'),
(6877,'Recipe: Sealed Major Arcana Boots (60%)','false','recipe',30,'stackable','paper','none',-1,71600,0,'true','true','true','true','C4Item','none'),
(6878,'Recipe: Sealed Major Arcana Boots (100%)','false','recipe',30,'stackable','paper','none',-1,71600,0,'true','true','true','true','C4Item','none'),
(6879,'Recipe: Sealed Major Arcana Circlet (60%)','false','recipe',30,'stackable','paper','none',-1,107400,0,'true','true','true','true','C4Item','none'),
(6880,'Recipe: Sealed Major Arcana Circlet (100%)','false','recipe',30,'stackable','paper','none',-1,107400,0,'true','true','true','true','C4Item','none'),
(6881,'Recipe: Forgotten Blade (60%)','false','recipe',30,'stackable','paper','none',-1,976000,0,'true','true','true','true','C4Item','none'),
(6882,'Recipe: Forgotten Blade (100%)','false','recipe',30,'stackable','paper','none',-1,976000,0,'true','true','true','true','C4Item','none'),
(6883,'Recipe: Basalt Battlehammer (60%)','false','recipe',30,'stackable','paper','none',-1,976000,0,'true','true','true','true','C4Item','none'),
(6884,'Recipe: Basalt Battlehammer (100%)','false','recipe',30,'stackable','paper','none',-1,976000,0,'true','true','true','true','C4Item','none'),
(6885,'Recipe: Imperial Staff (60%)','false','recipe',30,'stackable','paper','none',-1,976000,0,'true','true','true','true','C4Item','none'),
(6886,'Recipe: Imperial Staff(100%)','false','recipe',30,'stackable','paper','none',-1,976000,0,'true','true','true','true','C4Item','none'),
(6887,'Recipe: Angel Slayer (60%)','false','recipe',30,'stackable','paper','none',-1,976000,0,'true','true','true','true','C4Item','none'),
(6888,'Recipe: Angel Slayer (100%)','false','recipe',30,'stackable','paper','none',-1,976000,0,'true','true','true','true','C4Item','none'),
(6889,'Recipe: Shining Bow (60%)','false','recipe',30,'stackable','paper','none',-1,976000,0,'true','true','true','true','C4Item','none'),
(6890,'Recipe: Shining Bow (100%)','false','recipe',30,'stackable','paper','none',-1,976000,0,'true','true','true','true','C4Item','none'),
(6891,'Recipe: Dragon Hunter Axe (60%)','false','recipe',30,'stackable','paper','none',-1,976000,0,'true','true','true','true','C4Item','none'),
(6892,'Recipe: Dragon Hunter Axe (100%)','false','recipe',30,'stackable','paper','none',-1,976000,0,'true','true','true','true','C4Item','none'),
(6893,'Recipe: Saint Spear (60%)','false','recipe',30,'stackable','paper','none',-1,976000,0,'true','true','true','true','C4Item','none'),
(6894,'Recipe: Saint Spear (100%)','false','recipe',30,'stackable','paper','none',-1,976000,0,'true','true','true','true','C4Item','none'),
(6895,'Recipe: Demon Splinter (60%)','false','recipe',30,'stackable','paper','none',-1,976000,0,'true','true','true','true','C4Item','none'),
(6896,'Recipe: Demon Splinter (100%)','false','recipe',30,'stackable','paper','none',-1,976000,0,'true','true','true','true','C4Item','none'),
(6897,'Recipe: Heavens Divider (60%)','false','recipe',30,'stackable','paper','none',-1,976000,0,'true','true','true','true','C4Item','none'),
(6898,'Recipe: Heavens Divider (100%)','false','recipe',30,'stackable','paper','none',-1,976000,0,'true','true','true','true','C4Item','none'),
(6899,'Recipe: Arcana Mace (60%)','false','recipe',30,'stackable','paper','none',-1,976000,0,'true','true','true','true','C4Item','none'),
(6900,'Recipe: Arcana Mace (100%)','false','recipe',30,'stackable','paper','none',-1,976000,0,'true','true','true','true','C4Item','none'),
(6901,'Recipe: Shining Arrow (100%)','false','recipe',30,'stackable','paper','none',-1,200000,0,'true','true','true','true','C4Item','none'),
(6903,'Music Box M','false','none',10,'stackable','paper','none',-1,0,0,'true','true','true','true','C4Item','none'),
(6904,'Party Mask Fabric','false','material',60,'stackable','liquid','none',-1,5000,0,'true','true','true','true','C4Item','none'),
(6905,'Hair Pin Piece','false','material',60,'stackable','liquid','none',-1,5000,0,'true','true','true','true','C4Item','none'),
(6906,'Pirate\'s Eye Patch Material','false','material',60,'stackable','liquid','none',-1,5000,0,'true','true','true','true','C4Item','none'),
(6907,'Monocle Piece','false','material',60,'stackable','liquid','none',-1,5000,0,'true','true','true','true','C4Item','none'),
(6908,'Fish Oil','false','material',30,'stackable','liquid','none',-1,50,0,'true','true','true','true','C4Item','none'),
(6909,'Greater Fish Oil','false','material',30,'stackable','liquid','none',-1,250,0,'true','true','true','true','C4Item','none'),
(6910,'Premium Fish Oil','false','material',30,'stackable','liquid','none',-1,1250,0,'true','true','true','true','C4Item','none'),
(6911,'Fish Scale','false','material',30,'stackable','liquid','none',-1,200,0,'true','true','true','true','C4Item','none'),
(6912,'Shiny Fish Scale','false','material',30,'stackable','liquid','none',-1,300,0,'true','true','true','true','C4Item','none'),
(6913,'Fish Gem','false','material',30,'stackable','liquid','none',-1,500,0,'true','true','true','true','C4Item','none'),
(6914,'Shiny Fish Gem','false','material',30,'stackable','liquid','none',-1,1000,0,'true','true','true','true','C4Item','none'),
(6915,'Thin Fish Bone','false','material',30,'stackable','liquid','none',-1,300,0,'true','true','true','true','C4Item','none'),
(6916,'Thick Fish Bone','false','material',30,'stackable','liquid','none',-1,450,0,'true','true','true','true','C4Item','none'),
(6920,'Recipe: Greater Fish Oil (100%)','false','recipe',30,'stackable','paper','none',-1,50,0,'true','true','true','true','C4Item','none'),
(6921,'Recipe: Premium Fish Oil(100%)','false','recipe',30,'stackable','paper','none',-1,250,0,'true','true','true','true','C4Item','none'),
(6922,'Recipe: Party Mask (100%)','false','recipe',30,'stackable','paper','none',-1,100000,0,'true','true','true','true','C4Item','none'),
(6923,'Recipe: Lady\'s Hair Pin (100%)','false','recipe',30,'stackable','paper','none',-1,100000,0,'true','true','true','true','C4Item','none'),
(6924,'Recipe: Pirate\'s Eye Patch (100%)','false','recipe',30,'stackable','paper','none',-1,100000,0,'true','true','true','true','C4Item','none'),
(6925,'Recipe: Monocle (100%)','false','recipe',30,'stackable','paper','none',-1,100000,0,'true','true','true','true','C4Item','none'),
(6926,'Recipe: Lesser Healing Potion (100%)','false','recipe',30,'stackable','paper','none',-1,18,0,'true','true','true','true','C4Item','none'),
(6927,'Recipe: Healing Potion (100%)','false','recipe',30,'stackable','paper','none',-1,66,0,'true','true','true','true','C4Item','none'),
(6928,'Recipe: Greater Healing Potion (100%)','false','recipe',30,'stackable','paper','none',-1,180,0,'true','true','true','true','C4Item','none'),
(6929,'Recipe: Antidote (100%)','false','recipe',30,'stackable','paper','none',-1,15,0,'true','true','true','true','C4Item','none'),
(6930,'Recipe: Greater Antidote (100%)','false','recipe',30,'stackable','paper','none',-1,36,0,'true','true','true','true','C4Item','none'),
(6931,'Recipe: Bandage (100%)','false','recipe',30,'stackable','paper','none',-1,15,0,'true','true','true','true','C4Item','none'),
(6932,'Recipe: Emergency Dressing (100%)','false','recipe',30,'stackable','paper','none',-1,36,0,'true','true','true','true','C4Item','none'),
(6933,'Recipe: Haste Potion (100%)','false','recipe',30,'stackable','paper','none',-1,240,0,'true','true','true','true','C4Item','none'),
(6934,'Recipe: Potion of Alacrity (100%)','false','recipe',30,'stackable','paper','none',-1,480,0,'true','true','true','true','C4Item','none'),
(6935,'Recipe: Greater Haste Potion (100%)','false','recipe',30,'stackable','paper','none',-1,600,0,'true','true','true','true','C4Item','none'),
(6936,'Recipe: Greater Swift Attack Potion (100%)','false','recipe',30,'stackable','paper','none',-1,1200,0,'true','true','true','true','C4Item','none'),
(6937,'Recipe: Magic Haste Potion (100%)','false','recipe',30,'stackable','paper','none',-1,480,0,'true','true','true','true','C4Item','none'),
(6938,'Recipe: Greater Magic Haste Potion (100%)','false','recipe',30,'stackable','paper','none',-1,1200,0,'true','true','true','true','C4Item','none'),
(6939,'Recipe: Mystery Potion (100%)','false','recipe',30,'stackable','paper','none',-1,2000,0,'true','true','true','true','C4Item','none'),
(6940,'Recipe: Facelifting Potion - A (100%)','false','recipe',30,'stackable','paper','none',-1,4000,0,'true','true','true','true','C4Item','none'),
(6941,'Recipe: Facelifting Potion - B (100%)','false','recipe',30,'stackable','paper','none',-1,4000,0,'true','true','true','true','C4Item','none'),
(6942,'Recipe: Facelifting Potion - C (100%)','false','recipe',30,'stackable','paper','none',-1,4000,0,'true','true','true','true','C4Item','none'),
(6943,'Recipe: Dye Potion - A (100%)','false','recipe',30,'stackable','paper','none',-1,4000,0,'true','true','true','true','C4Item','none'),
(6944,'Recipe: Dye Potion - B (100%)','false','recipe',30,'stackable','paper','none',-1,4000,0,'true','true','true','true','C4Item','none'),
(6945,'Recipe: Dye Potion - C (100%)','false','recipe',30,'stackable','paper','none',-1,4000,0,'true','true','true','true','C4Item','none'),
(6946,'Recipe: Dye Potion - D (100%)','false','recipe',30,'stackable','paper','none',-1,4000,0,'true','true','true','true','C4Item','none'),
(6947,'Recipe: Hair Style Change Potion - A (100%)','false','recipe',30,'stackable','paper','none',-1,4000,0,'true','true','true','true','C4Item','none'),
(6948,'Recipe: Hair Style Change Potion - B (100%)','false','recipe',30,'stackable','paper','none',-1,4000,0,'true','true','true','true','C4Item','none'),
(6949,'Recipe: Hair Style Change Potion - C (100%)','false','recipe',30,'stackable','paper','none',-1,4000,0,'true','true','true','true','C4Item','none'),
(6950,'Recipe: Hair Style Change Potion - D (100%)','false','recipe',30,'stackable','paper','none',-1,4000,0,'true','true','true','true','C4Item','none'),
(6951,'Recipe: Hair Style Change Potion - E (100%)','false','recipe',30,'stackable','paper','none',-1,4000,0,'true','true','true','true','C4Item','none'),
(6952,'Recipe: Hair Style Change Potion - F (100%)','false','recipe',30,'stackable','paper','none',-1,4000,0,'true','true','true','true','C4Item','none'),
(6953,'Recipe: Hair Style Change Potion - G (100%)','false','recipe',30,'stackable','paper','none',-1,4000,0,'true','true','true','true','C4Item','none'),
(6954,'Recipe: Dye of STR <Str+1 Con-1> (100%)','false','recipe',30,'stackable','paper','none',-1,7000,0,'true','true','true','true','C4Item','none'),
(6955,'Recipe: Dye of STR <Str+1 Dex-1> (100%)','false','recipe',30,'stackable','paper','none',-1,7000,0,'true','true','true','true','C4Item','none'),
(6956,'Recipe: Dye of CON <Con+1 Str-1> (100%)','false','recipe',30,'stackable','paper','none',-1,7000,0,'true','true','true','true','C4Item','none'),
(6957,'Recipe: Dye of CON <Con+1 Dex-1> (100%)','false','recipe',30,'stackable','paper','none',-1,7000,0,'true','true','true','true','C4Item','none'),
(6958,'Recipe: Dye of DEX <Dex+1 Str-1> (100%)','false','recipe',30,'stackable','paper','none',-1,7000,0,'true','true','true','true','C4Item','none'),
(6959,'Recipe: Dye of DEX <Dex+1 Con-1> (100%)','false','recipe',30,'stackable','paper','none',-1,7000,0,'true','true','true','true','C4Item','none'),
(6960,'Recipe: Dye of INT <Int+1 Men-1> (100%)','false','recipe',30,'stackable','paper','none',-1,7000,0,'true','true','true','true','C4Item','none'),
(6961,'Recipe: Dye of INT <Int+1 Wit-1> (100%)','false','recipe',30,'stackable','paper','none',-1,7000,0,'true','true','true','true','C4Item','none'),
(6962,'Recipe: Dye of MEN <Men+1 Int-1> (100%)','false','recipe',30,'stackable','paper','none',-1,7000,0,'true','true','true','true','C4Item','none'),
(6963,'Recipe: Dye of MEN <Men+1 Wit-1> (100%)','false','recipe',30,'stackable','paper','none',-1,7000,0,'true','true','true','true','C4Item','none'),
(6964,'Recipe: Dye of WIT<Wit+1 Int-1> (100%)','false','recipe',30,'stackable','paper','none',-1,7000,0,'true','true','true','true','C4Item','none'),
(6965,'Recipe: Dye of WIT<Wit+1 Men-1> (100%)','false','recipe',30,'stackable','paper','none',-1,7000,0,'true','true','true','true','C4Item','none'),
(6966,'Recipe: Greater Dye of STR <Str+1 Con-1> (100%)','false','recipe',30,'stackable','paper','none',-1,10000,0,'true','true','true','true','C4Item','none'),
(6967,'Recipe: Greater Dye of STR <Str+1 Dex-1> (100%)','false','recipe',30,'stackable','paper','none',-1,10000,0,'true','true','true','true','C4Item','none'),
(6968,'Recipe: Greater Dye of CON <Con+1 Str-1> (100%)','false','recipe',30,'stackable','paper','none',-1,10000,0,'true','true','true','true','C4Item','none'),
(6969,'Recipe: Greater Dye of CON <Con+1 Dex-1> (100%)','false','recipe',30,'stackable','paper','none',-1,10000,0,'true','true','true','true','C4Item','none'),
(6970,'Recipe: Greater Dye of DEX <Dex+1 Str-1> (100%)','false','recipe',30,'stackable','paper','none',-1,10000,0,'true','true','true','true','C4Item','none'),
(6971,'Recipe: Greater Dye of DEX <Dex+1 Con-1> (100%)','false','recipe',30,'stackable','paper','none',-1,10000,0,'true','true','true','true','C4Item','none'),
(6972,'Recipe: Greater Dye of INT <Int+1 Men-1> (100%)','false','recipe',30,'stackable','paper','none',-1,10000,0,'true','true','true','true','C4Item','none'),
(6973,'Recipe: Greater Dye of INT <Int+1 Wit-1> (100%)','false','recipe',30,'stackable','paper','none',-1,10000,0,'true','true','true','true','C4Item','none'),
(6974,'Recipe: Greater Dye of MEN <Men+1 Int-1> (100%)','false','recipe',30,'stackable','paper','none',-1,10000,0,'true','true','true','true','C4Item','none'),
(6975,'Recipe: Greater Dye of MEN <Men+1 Wit-1> (100%)','false','recipe',30,'stackable','paper','none',-1,10000,0,'true','true','true','true','C4Item','none'),
(6976,'Recipe: Greater Dye of WIT<Wit+1 Int-1> (100%)','false','recipe',30,'stackable','paper','none',-1,10000,0,'true','true','true','true','C4Item','none'),
(6977,'Recipe: Greater Dye of WIT<Wit+1 Men-1> (100%)','false','recipe',30,'stackable','paper','none',-1,10000,0,'true','true','true','true','C4Item','none'),
(6978,'Recipe: Greater Dye of STR <Str+2 Con-2> (100%)','false','recipe',30,'stackable','paper','none',-1,12000,0,'true','true','true','true','C4Item','none'),
(6979,'Recipe: Greater Dye of STR <Str+2 Dex-2> (100%)','false','recipe',30,'stackable','paper','none',-1,12000,0,'true','true','true','true','C4Item','none'),
(6980,'Recipe: Greater Dye of CON <Con+2 Str-2> (100%)','false','recipe',30,'stackable','paper','none',-1,12000,0,'true','true','true','true','C4Item','none'),
(6981,'Recipe: Greater Dye of CON <Con+2 Dex-2> (100%)','false','recipe',30,'stackable','paper','none',-1,12000,0,'true','true','true','true','C4Item','none'),
(6982,'Recipe: Greater Dye of DEX <Dex+2 Str-2> (100%)','false','recipe',30,'stackable','paper','none',-1,12000,0,'true','true','true','true','C4Item','none'),
(6983,'Recipe: Greater Dye of DEX <Dex+2 Con-2> (100%)','false','recipe',30,'stackable','paper','none',-1,12000,0,'true','true','true','true','C4Item','none'),
(6984,'Recipe: Greater Dye of INT <Int+2 Men-2> (100%)','false','recipe',30,'stackable','paper','none',-1,12000,0,'true','true','true','true','C4Item','none'),
(6985,'Recipe: Greater Dye of INT <Int+2 Wit-2> (100%)','false','recipe',30,'stackable','paper','none',-1,12000,0,'true','true','true','true','C4Item','none'),
(6986,'Recipe: Greater Dye of MEN <Men+2 Int-2> (100%)','false','recipe',30,'stackable','paper','none',-1,12000,0,'true','true','true','true','C4Item','none'),
(6987,'Recipe: Greater Dye of MEN <Men+2 Wit-2> (100%)','false','recipe',30,'stackable','paper','none',-1,12000,0,'true','true','true','true','C4Item','none'),
(6988,'Recipe: Greater Dye of WIT<Wit+2 Int-2> (100%)','false','recipe',30,'stackable','paper','none',-1,12000,0,'true','true','true','true','C4Item','none'),
(6989,'Recipe: Greater Dye of WIT<Wit+2 Men-2> (100%)','false','recipe',30,'stackable','paper','none',-1,12000,0,'true','true','true','true','C4Item','none'),
(6990,'Recipe: Greater Dye of STR <Str+3 Con-3> (100%)','false','recipe',30,'stackable','paper','none',-1,18000,0,'true','true','true','true','C4Item','none'),
(6991,'Recipe: Greater Dye of STR <Str+3 Dex-3> (100%)','false','recipe',30,'stackable','paper','none',-1,18000,0,'true','true','true','true','C4Item','none'),
(6992,'Recipe: Greater Dye of CON <Con+3 Str-3> (100%)','false','recipe',30,'stackable','paper','none',-1,18000,0,'true','true','true','true','C4Item','none'),
(6993,'Recipe: Greater Dye of CON <Con+3 Dex-3> (100%)','false','recipe',30,'stackable','paper','none',-1,18000,0,'true','true','true','true','C4Item','none'),
(6994,'Recipe: Greater Dye of DEX <Dex+3 Str-3> (100%)','false','recipe',30,'stackable','paper','none',-1,18000,0,'true','true','true','true','C4Item','none'),
(6995,'Recipe: Greater Dye of DEX <Dex+3 Con-3> (100%)','false','recipe',30,'stackable','paper','none',-1,18000,0,'true','true','true','true','C4Item','none'),
(6996,'Recipe: Greater Dye of INT <Int+3 Men-3> (100%)','false','recipe',30,'stackable','paper','none',-1,18000,0,'true','true','true','true','C4Item','none'),
(6997,'Recipe: Greater Dye of INT <Int+3 Wit-3> (100%)','false','recipe',30,'stackable','paper','none',-1,18000,0,'true','true','true','true','C4Item','none'),
(6998,'Recipe: Greater Dye of MEN <Men+3 Int-3> (100%)','false','recipe',30,'stackable','paper','none',-1,18000,0,'true','true','true','true','C4Item','none'),
(6999,'Recipe: Greater Dye of MEN <Men+3 Wit-3> (100%)','false','recipe',30,'stackable','paper','none',-1,18000,0,'true','true','true','true','C4Item','none'),
(7000,'Recipe: Greater Dye of WIT<Wit+3 Int-3> (100%)','false','recipe',30,'stackable','paper','none',-1,18000,0,'true','true','true','true','C4Item','none'),
(7001,'Recipe: Greater Dye of WIT<Wit+3 Men-3> (100%)','false','recipe',30,'stackable','paper','none',-1,18000,0,'true','true','true','true','C4Item','none'),
(7002,'Recipe: Greater Dye of STR <Str+4 Con-4> (100%)','false','recipe',30,'stackable','paper','none',-1,29000,0,'true','true','true','true','C4Item','none'),
(7003,'Recipe: Greater Dye of STR <Str+4 Dex-4> (100%)','false','recipe',30,'stackable','paper','none',-1,29000,0,'true','true','true','true','C4Item','none'),
(7004,'Recipe: Greater Dye of CON <Con+4 Str-4> (100%)','false','recipe',30,'stackable','paper','none',-1,29000,0,'true','true','true','true','C4Item','none'),
(7005,'Recipe: Greater Dye of CON <Con+4 Dex-4> (100%)','false','recipe',30,'stackable','paper','none',-1,29000,0,'true','true','true','true','C4Item','none'),
(7006,'Recipe: Greater Dye of DEX <Dex+4 Str-4> (100%)','false','recipe',30,'stackable','paper','none',-1,29000,0,'true','true','true','true','C4Item','none'),
(7007,'Recipe: Greater Dye of DEX <Dex+4 Con-4> (100%)','false','recipe',30,'stackable','paper','none',-1,29000,0,'true','true','true','true','C4Item','none'),
(7008,'Recipe: Greater Dye of INT <Int+4 Men-4> (100%)','false','recipe',30,'stackable','paper','none',-1,29000,0,'true','true','true','true','C4Item','none'),
(7009,'Recipe: Greater Dye of INT <Int+4 Wit-4> (100%)','false','recipe',30,'stackable','paper','none',-1,29000,0,'true','true','true','true','C4Item','none'),
(7010,'Recipe: Greater Dye of MEN <Men+4 Int-4> (100%)','false','recipe',30,'stackable','paper','none',-1,29000,0,'true','true','true','true','C4Item','none'),
(7011,'Recipe: Greater Dye of MEN <Men+4 Wit-4> (100%)','false','recipe',30,'stackable','paper','none',-1,29000,0,'true','true','true','true','C4Item','none'),
(7012,'Recipe: Greater Dye of WIT<Wit+4 Int-4> (100%)','false','recipe',30,'stackable','paper','none',-1,29000,0,'true','true','true','true','C4Item','none'),
(7013,'Recipe: Greater Dye of WIT<Wit+4 Men-4> (100%)','false','recipe',30,'stackable','paper','none',-1,29000,0,'true','true','true','true','C4Item','none'),
(7016,'Seed: Blue Cobol','false','seed',1,'stackable','paper','none',-1,50,0,'true','true','true','true','C5Item','none'),
(7017,'Seed: Blue Codran','false','seed',1,'stackable','paper','none',-1,50,0,'true','true','true','true','C5Item','none'),
(7018,'Seed: Blue Codran','false','seed',1,'stackable','paper','none',-1,50,0,'true','true','true','true','C5Item','none'),
(7019,'Seed: Chilly Cobol','false','seed',1,'stackable','paper','none',-1,25,0,'true','true','true','true','C5Item','none'),
(7020,'Seed: Chilly Coda','false','seed',1,'stackable','paper','none',-1,5,0,'true','true','true','true','C5Item','none'),
(7021,'Seed: Chilly Codran','false','seed',1,'stackable','paper','none',-1,40,0,'true','true','true','true','C5Item','none'),
(7022,'Seed: Chilly Codran','false','seed',1,'stackable','paper','none',-1,40,0,'true','true','true','true','C5Item','none'),
(7023,'Seed: Desert Codran','false','seed',1,'stackable','paper','none',-1,100,0,'true','true','true','true','C5Item','none'),
(7024,'Seed: Desert Codran','false','seed',1,'stackable','paper','none',-1,100,0,'true','true','true','true','C5Item','none'),
(7025,'Seed: Golden Cobol','false','seed',1,'stackable','paper','none',-1,50,0,'true','true','true','true','C5Item','none'),
(7026,'Seed: Golden Coda','false','seed',1,'stackable','paper','none',-1,20,0,'true','true','true','true','C5Item','none'),
(7027,'Seed: Great Cobol','false','seed',1,'stackable','paper','none',-1,50,0,'true','true','true','true','C5Item','none'),
(7028,'Seed: Great Codran','false','seed',1,'stackable','paper','none',-1,75,0,'true','true','true','true','C5Item','none'),
(7029,'Seed: Great Codran','false','seed',1,'stackable','paper','none',-1,75,0,'true','true','true','true','C5Item','none'),
(7030,'Seed: Alternative Blue Cobol','false','seed',1,'stackable','paper','none',-1,50,0,'true','true','true','true','C5Item','none'),
(7031,'Seed: Alternative Blue Codran','false','seed',1,'stackable','paper','none',-1,50,0,'true','true','true','true','C5Item','none'),
(7032,'Seed: Alternative Blue Codran','false','seed',1,'stackable','paper','none',-1,50,0,'true','true','true','true','C5Item','none'),
(7033,'Seed: Alternative Chilly Cobol','false','seed',1,'stackable','paper','none',-1,25,0,'true','true','true','true','C5Item','none'),
(7034,'Seed: Alternative Chilly Coda','false','seed',1,'stackable','paper','none',-1,5,0,'true','true','true','true','C5Item','none'),
(7035,'Seed: Alternative Chilly Codran','false','seed',1,'stackable','paper','none',-1,40,0,'true','true','true','true','C5Item','none'),
(7036,'Seed: Alternative Chilly Codran','false','seed',1,'stackable','paper','none',-1,40,0,'true','true','true','true','C5Item','none'),
(7037,'Seed: Alternative Desert Codran','false','seed',1,'stackable','paper','none',-1,100,0,'true','true','true','true','C5Item','none'),
(7038,'Seed: Alternative Desert Codran','false','seed',1,'stackable','paper','none',-1,100,0,'true','true','true','true','C5Item','none'),
(7039,'Seed: Alternative Golden Cobol','false','seed',1,'stackable','paper','none',-1,50,0,'true','true','true','true','C5Item','none'),
(7040,'Seed: Alternative Golden Coda','false','seed',1,'stackable','paper','none',-1,20,0,'true','true','true','true','C5Item','none'),
(7041,'Seed: Alternative Great Cobol','false','seed',1,'stackable','paper','none',-1,40,0,'true','true','true','true','C5Item','none'),
(7042,'Seed: Alternative Great Codran','false','seed',1,'stackable','paper','none',-1,75,0,'true','true','true','true','C5Item','none'),
(7043,'Seed: Alternative Great Codran','false','seed',1,'stackable','paper','none',-1,75,0,'true','true','true','true','C5Item','none'),
(7044,'Seed: Alternative Red Cobol','false','seed',1,'stackable','paper','none',-1,20,0,'true','true','true','true','C5Item','none'),
(7045,'Seed: Alternative Red Codran','false','seed',1,'stackable','paper','none',-1,40,0,'true','true','true','true','C5Item','none'),
(7046,'Seed: Alternative Red Codran','false','seed',1,'stackable','paper','none',-1,40,0,'true','true','true','true','C5Item','none'),
(7047,'Seed: Alternative Sea Codran','false','seed',1,'stackable','paper','none',-1,50,0,'true','true','true','true','C5Item','none'),
(7048,'Seed: Alternative Sea Codran','false','seed',1,'stackable','paper','none',-1,50,0,'true','true','true','true','C5Item','none'),
(7049,'Seed: Alternative Sea Codran','false','seed',1,'stackable','paper','none',-1,50,0,'true','true','true','true','C5Item','none'),
(7050,'Seed: Alternative Twin Codran','false','seed',1,'stackable','paper','none',-1,50,0,'true','true','true','true','C5Item','none'),
(7051,'Seed: Red Cobol','false','seed',1,'stackable','paper','none',-1,20,0,'true','true','true','true','C5Item','none'),
(7052,'Seed: Red Codran','false','seed',1,'stackable','paper','none',-1,40,0,'true','true','true','true','C5Item','none'),
(7053,'Seed: Red Codran','false','seed',1,'stackable','paper','none',-1,40,0,'true','true','true','true','C5Item','none'),
(7054,'Seed: Sea Codran','false','seed',1,'stackable','paper','none',-1,50,0,'true','true','true','true','C5Item','none'),
(7055,'Seed: Sea Codran','false','seed',1,'stackable','paper','none',-1,50,0,'true','true','true','true','C5Item','none'),
(7056,'Seed: Sea Codran','false','seed',1,'stackable','paper','none',-1,50,0,'true','true','true','true','C5Item','none'),
(7057,'Seed: Twin Codran','false','seed',1,'stackable','paper','none',-1,50,0,'true','true','true','true','C5Item','none'),
(7061,'Echo Crystal - Theme of Birthday','false','none',10,'stackable','paper','none',-1,0,0,'true','true','true','true','C4Item','none'),
(7062,'Echo Crystal - Theme of Wedding','false','none',10,'stackable','paper','none',-1,0,0,'true','true','true','true','C4Item','none'),
(7063,'Map - Forest of the Dead','false','none',1,'normal','paper','none',-1,0,0,'false','false','false','false','C4Item','none'),
(7064,'Lidia\'s Diary','false','none',1,'normal','paper','none',-1,0,0,'false','false','false','false','C4Item','none'),
(7065,'Lidia\'s Letter','false','none',1,'normal','paper','none',-1,0,0,'false','false','false','false','C4Item','none'),
(7066,'Contract','false','none',1,'normal','paper','none',-1,0,0,'false','false','false','false','C4Item','none'),
(7067,'Special Bait 1','false','lure',1,'stackable','paper','none',-1,0,0,'true','true','true','true','C4Item','none'),
(7068,'Special Bait 2','false','lure',1,'stackable','paper','none',-1,0,0,'true','true','true','true','C4Item','none'),
(7069,'Special Bait 3','false','lure',1,'stackable','paper','none',-1,0,0,'true','true','true','true','C4Item','none'),
(7070,'Special Bait 4','false','lure',1,'stackable','paper','none',-1,0,0,'true','true','true','true','C4Item','none'),
(7071,'Special Fish 1','false','none',1,'stackable','paper','none',-1,0,0,'true','true','true','true','C4Item','none'),
(7072,'Special Fish 2','false','none',1,'stackable','paper','none',-1,0,0,'true','true','true','true','C4Item','none'),
(7073,'Special Fish 3','false','none',1,'stackable','paper','none',-1,0,0,'true','true','true','true','C4Item','none'),
(7074,'Special Fish 4','false','none',1,'stackable','paper','none',-1,0,0,'true','true','true','true','C4Item','none'),
(7075,'Entrance Pass to the Sepulcher','false','none',0,'stackable','paper','none',-1,0,0,'true','true','true','true','C4Item','none'),
(7076,'Mysterious Cloth','false','none',0,'stackable','paper','none',-1,0,0,'true','true','true','true','C4Item','none'),
(7077,'Jewel Box','false','none',0,'stackable','paper','none',-1,0,0,'true','true','true','true','C4Item','none'),
(7078,'Sewing Kit','false','none',0,'stackable','paper','none',-1,0,0,'true','true','true','true','C4Item','none'),
(7079,'Dimensional Fragment','false','none',0,'stackable','paper','none',-1,0,0,'true','true','true','true','C4Item','none'),
(7080,'Ice Crystal','false','none',0,'normal','paper','none',-1,0,0,'false','false','true','false','C4Item','none'),
(7081,'Divine Stone of Wisdom','false','none',10,'normal','paper','none',-1,0,0,'false','false','true','false','C4Item','none'),
(7082,'Guild Report','false','none',0,'stackable','paper','none',-1,0,0,'false','false','false','false','C4Item','none'),
(7083,'Guild Report','false','none',0,'stackable','paper','none',-1,0,0,'false','false','false','false','C4Item','none'),
(7084,'Guild Report','false','none',0,'stackable','paper','none',-1,0,0,'false','false','false','false','C4Item','none'),
(7085,'Guild Report','false','none',0,'stackable','paper','none',-1,0,0,'false','false','false','false','C4Item','none'),
(7086,'Guild Report','false','none',0,'stackable','paper','none',-1,0,0,'false','false','false','false','C4Item','none'),
(7087,'Tattered Book','false','none',0,'stackable','paper','none',-1,0,0,'false','false','false','false','C4Item','none'),
(7088,'Tattered Book','false','none',0,'stackable','paper','none',-1,0,0,'false','false','false','false','C4Item','none'),
(7089,'Tattered Book','false','none',0,'stackable','paper','none',-1,0,0,'false','false','false','false','C4Item','none'),
(7090,'Tattered Book','false','none',0,'stackable','paper','none',-1,0,0,'false','false','false','false','C4Item','none'),
(7091,'Guild Report','false','none',0,'stackable','paper','none',-1,0,0,'false','false','false','false','C4Item','none'),
(7092,'Guild Report','false','none',0,'stackable','paper','none',-1,0,0,'false','false','false','false','C4Item','none'),
(7093,'Sculpture of the Fallen Knight','false','none',0,'normal','paper','none',-1,0,0,'false','false','false','false','C4Item','none'),
(7094,'Record of Mother Tree Guardian','false','none',0,'normal','paper','none',-1,0,0,'false','false','false','false','C4Item','none'),
(7095,'Criticism of Biel\'s Song','false','none',0,'normal','paper','none',-1,0,0,'false','false','false','false','C4Item','none'),
(7096,'The Last Days of Swordsman Iron','false','none',0,'normal','paper','none',-1,0,0,'false','false','false','false','C4Item','none'),
(7097,'Contemplation of White Wing Army','false','none',0,'normal','paper','none',-1,0,0,'false','false','false','false','C4Item','none'),
(7098,'Record of Traitor Muhark','false','none',0,'normal','paper','none',-1,0,0,'false','false','false','false','C4Item','none'),
(7099,'Secret Book of Khavatari','false','none',0,'normal','paper','none',-1,0,0,'false','false','false','false','C4Item','none'),
(7100,'Importance of Strain','false','none',0,'normal','paper','none',-1,0,0,'false','false','false','false','C4Item','none'),
(7101,'Danger of Ice Spirit','false','none',0,'normal','paper','none',-1,0,0,'false','false','false','false','C4Item','none'),
(7102,'Guardian Angel of the Tablet - Vol. 1','false','none',0,'normal','paper','none',-1,0,0,'false','false','false','false','C4Item','none'),
(7103,'Guardian Angel of the Tablet - Vol. 1','false','none',0,'normal','paper','none',-1,0,0,'false','false','false','false','C4Item','none'),
(7104,'Guardian Angel of the Tablet - Vol. 1','false','none',0,'normal','paper','none',-1,0,0,'false','false','false','false','C4Item','none'),
(7105,'Guardian Angel of the Tablet - Vol. 2','false','none',0,'normal','paper','none',-1,0,0,'false','false','false','false','C4Item','none'),
(7106,'Guardian Angel of the Tablet - Vol. 2','false','none',0,'normal','paper','none',-1,0,0,'false','false','false','false','C4Item','none'),
(7107,'Guardian Angel of the Tablet - Vol. 2','false','none',0,'normal','paper','none',-1,0,0,'false','false','false','false','C4Item','none'),
(7108,'Guild\'s Secret Report','false','none',0,'normal','paper','none',-1,0,0,'false','false','false','false','C4Item','none'),
(7109,'Guild\'s Secret Report','false','none',0,'normal','paper','none',-1,0,0,'false','false','false','false','C4Item','none'),
(7110,'Research Report','false','none',0,'normal','paper','none',-1,0,0,'false','false','false','false','C4Item','none'),
(7111,'Research Report','false','none',0,'normal','paper','none',-1,0,0,'false','false','false','false','C4Item','none'),
(7112,'Research Report','false','none',0,'normal','paper','none',-1,0,0,'false','false','false','false','C4Item','none'),
(7113,'Dress Shoe Box','false','none',0,'stackable','paper','none',-1,0,0,'true','true','true','true','C4Item','none'),
(7114,'Voucher - Buffalo','false','none',0,'stackable','paper','none',-1,0,0,'true','true','true','true','C4Item','none'),
(7115,'Voucher - Cougar','false','none',0,'stackable','paper','none',-1,0,0,'true','true','true','true','C4Item','none'),
(7116,'Voucher - Kookaburra','false','none',0,'stackable','paper','none',-1,0,0,'true','true','true','true','C4Item','none'),
(7117,'Scroll of Escape: Talking Island','false','none',30,'stackable','paper','none',-1,35000,0,'true','true','true','true','C4Item','none'),
(7118,'Scroll of Escape: Elven Village','false','none',30,'stackable','paper','none',-1,35000,0,'true','true','true','true','C4Item','none'),
(7119,'Scroll of Escape: Dark Elf Village','false','none',30,'stackable','paper','none',-1,35000,0,'true','true','true','true','C4Item','none'),
(7120,'Scroll of Escape: Orc Village','false','none',30,'stackable','paper','none',-1,35000,0,'true','true','true','true','C4Item','none'),
(7121,'Scroll of Escape: Dwarven Village','false','none',30,'stackable','paper','none',-1,35000,0,'true','true','true','true','C4Item','none'),
(7122,'Scroll of Escape: Gludin Village','false','none',30,'stackable','paper','none',-1,35000,0,'true','true','true','true','C4Item','none'),
(7123,'Scroll of Escape: the Town of Gludio','false','none',30,'stackable','paper','none',-1,35000,0,'true','true','true','true','C4Item','none'),
(7124,'Scroll of Escape: the Town of Dion','false','none',30,'stackable','paper','none',-1,35000,0,'true','true','true','true','C4Item','none'),
(7125,'Scroll of Escape: Floran','false','none',30,'stackable','paper','none',-1,35000,0,'true','true','true','true','C4Item','none'),
(7126,'Scroll of Escape: Giran Castle Town','false','none',30,'stackable','paper','none',-1,35000,0,'true','true','true','true','C4Item','none'),
(7127,'Scroll of Escape: Hardin\'s Private Academy','false','none',30,'stackable','paper','none',-1,35000,0,'true','true','true','true','C4Item','none'),
(7128,'Scroll of Escape: Heine','false','none',30,'stackable','paper','none',-1,35000,0,'true','true','true','true','C4Item','none'),
(7129,'Scroll of Escape: the Town of Oren','false','none',30,'stackable','paper','none',-1,35000,0,'true','true','true','true','C4Item','none'),
(7130,'Scroll of Escape: Ivory Tower','false','none',30,'stackable','paper','none',-1,35000,0,'true','true','true','true','C4Item','none'),
(7131,'Scroll of Escape: Hunters Village','false','none',30,'stackable','paper','none',-1,35000,0,'true','true','true','true','C4Item','none'),
(7132,'Scroll of Escape: Aden Castle Town','false','none',30,'stackable','paper','none',-1,35000,0,'true','true','true','true','C4Item','none'),
(7133,'Scroll of Escape: the Town of Goddard','false','none',30,'stackable','paper','none',-1,35000,0,'true','true','true','true','C4Item','none'),
(7134,'Scroll of Escape: the Rune Township','false','none',30,'stackable','paper','none',-1,35000,0,'true','true','true','true','C4Item','none'),
(7135,'Scroll of Escape: the Town of Schuttgart.','false','none',30,'stackable','paper','none',-1,35000,0,'true','true','true','true','C4Item','none'),
(7136,'Fruit Basket','false','quest',0,'stackable','paper','none',-1,0,0,'false','false','true','false','C4Item','none'),
(7137,'Avellan Spice','false','quest',0,'stackable','paper','none',-1,0,0,'false','false','true','false','C4Item','none'),
(7138,'Honey Pouch','false','quest',0,'stackable','paper','none',-1,0,0,'false','false','true','false','C4Item','none'),
(7139,'Bracelet of Lizardman','false','quest',0,'stackable','paper','none',-1,0,0,'false','false','true','false','C4Item','none'),
(7140,'Cross of Einhasad','false','quest',0,'stackable','paper','none',-1,0,0,'false','false','true','false','C4Item','none'),
(7141,'Cross of Einhasad','false','quest',0,'stackable','paper','none',-1,0,0,'false','false','true','false','C4Item','none'),
(7142,'Lost Skull of Elf','false','quest',0,'stackable','paper','none',-1,0,0,'false','false','true','false','C4Item','none'),
(7143,'Letter of Innocentin','false','quest',0,'stackable','paper','none',-1,0,0,'false','false','true','false','C4Item','none'),
(7144,'Jewel of Adventurer','false','quest',0,'stackable','paper','none',-1,0,0,'false','false','true','false','C4Item','none'),
(7145,'Jewel of Adventurer','false','quest',0,'stackable','paper','none',-1,0,0,'false','false','true','false','C4Item','none'),
(7146,'Sealed Report Box','false','quest',0,'stackable','paper','none',-1,0,0,'false','false','true','false','C4Item','none'),
(7147,'Report Box','false','quest',0,'stackable','paper','none',-1,0,0,'false','false','true','false','C4Item','none'),
(7148,'Lidia\'s Hairpin','false','quest',0,'stackable','paper','none',-1,0,0,'false','false','true','false','C4Item','none'),
(7149,'Silver Key','false','quest',0,'stackable','paper','none',-1,0,0,'false','false','true','false','C4Item','none'),
(7150,'Silver Spear','false','quest',0,'stackable','paper','none',-1,0,0,'false','false','true','false','C4Item','none'),
(7151,'Suspicious Totem Doll','false','quest',0,'stackable','paper','none',-1,0,0,'false','false','true','false','C4Item','none'),
(7152,'Flower Bouquet','false','quest',0,'stackable','paper','none',-1,0,0,'false','false','true','false','C4Item','none'),
(7153,'Silver Cross of Einhasad','false','quest',0,'stackable','paper','none',-1,0,0,'false','false','true','false','C4Item','none'),
(7154,'Broken Silver Cross of Einhasad','false','quest',0,'stackable','paper','none',-1,0,0,'false','false','true','false','C4Item','none'),
(7155,'Lidia\'s Dress','false','quest',0,'stackable','paper','none',-1,0,0,'false','false','true','false','C4Item','none'),
(7156,'Suspicious Totem Doll','false','quest',0,'stackable','paper','none',-1,0,0,'false','false','true','false','C4Item','none'),
(7157,'Gemstone Key','false','quest',0,'stackable','paper','none',-1,0,0,'false','false','true','false','C4Item','none'),
(7158,'Suspicious Totem Doll','false','quest',0,'stackable','paper','none',-1,0,0,'false','false','true','false','C4Item','none'),
(7159,'Box of Cookies','false','quest',0,'stackable','paper','none',-1,0,0,'false','false','true','false','C4Item','none'),
(7160,'Luxury Wine','false','quest',0,'stackable','paper','none',-1,0,0,'false','false','true','false','C4Item','none'),
(7161,'Skein of Yarn','false','quest',0,'stackable','paper','none',-1,0,0,'false','false','true','false','C4Item','none'),
(7162,'Rough Jewel','false','quest',0,'stackable','paper','none',-1,0,0,'false','false','true','false','C4Item','none'),
(7163,'Enchanted Iron','false','quest',0,'stackable','paper','none',-1,0,0,'false','false','true','false','C4Item','none'),
(7164,'Signet Ring','false','quest',0,'stackable','paper','none',-1,0,0,'false','false','true','false','C4Item','none'),
(7165,'Map','false','quest',0,'stackable','paper','none',-1,0,0,'false','false','true','false','C4Item','none'),
(7166,'Medicinal Herb','false','quest',0,'stackable','paper','none',-1,0,0,'false','false','true','false','C4Item','none'),
(7167,'Crystal of Seal','false','quest',0,'stackable','paper','none',-1,0,0,'false','false','true','false','C4Item','none'),
(7168,'Blood of Saint','false','quest',0,'stackable','paper','none',-1,0,0,'false','false','true','false','C4Item','none'),
(7169,'Blood of Saint','false','quest',0,'stackable','paper','none',-1,0,0,'false','false','true','false','C4Item','none'),
(7170,'Seal of Light','false','quest',0,'stackable','paper','none',-1,0,0,'false','false','true','false','C4Item','none'),
(7171,'Bead of Obedience','false','quest',0,'stackable','paper','none',-1,0,0,'false','false','true','false','C4Item','none'),
(7172,'Gem of Saints','false','quest',0,'stackable','paper','none',-1,0,0,'false','false','true','false','C4Item','none'),
(7173,'Feather Ornament','false','quest',0,'stackable','paper','none',-1,0,0,'false','false','true','false','C4Item','none'),
(7174,'Tooth of Totem','false','quest',0,'stackable','paper','none',-1,0,0,'false','false','true','false','C4Item','none'),
(7175,'Tooth of Dragon','false','quest',0,'stackable','paper','none',-1,0,0,'false','false','true','false','C4Item','none'),
(7176,'Letter of Iris','false','quest',0,'stackable','paper','none',-1,0,0,'false','false','true','false','C4Item','none'),
(7177,'Letter of Rohmer','false','quest',0,'stackable','paper','none',-1,0,0,'false','false','true','false','C4Item','none'),
(7178,'Black Bone Necklace','false','quest',0,'stackable','paper','none',-1,0,0,'false','false','true','false','C4Item','none'),
(7179,'Red Bone Necklace','false','quest',0,'stackable','paper','none',-1,0,0,'false','false','true','false','C4Item','none'),
(7180,'Incense Pouch','false','quest',0,'stackable','paper','none',-1,0,0,'false','false','true','false','C4Item','none'),
(7181,'Gem of Maille Lizardman','false','quest',0,'stackable','paper','none',-1,0,0,'false','false','true','false','C4Item','none'),
(7182,'Patrol\'s Report','false','quest',0,'stackable','paper','none',-1,0,0,'false','false','true','false','C4Item','none'),
(7183,'Shining Gem','false','quest',0,'stackable','paper','none',-1,0,0,'false','false','true','false','C4Item','none'),
(7184,'Shining Red Gem','false','quest',0,'stackable','paper','none',-1,0,0,'false','false','true','false','C4Item','none'),
(7185,'Jewel of Innocence','false','quest',0,'stackable','paper','none',-1,0,0,'false','false','true','false','C4Item','none'),
(7186,'Horn of Buffalo','false','quest',0,'stackable','paper','none',-1,0,0,'false','false','true','false','C4Item','none'),
(7187,'Nepenthes Seed','false','quest',0,'stackable','paper','none',-1,0,0,'false','false','true','false','C4Item','none'),
(7188,'Proof of Avenger','false','quest',0,'stackable','paper','none',-1,0,0,'false','false','true','false','C4Item','none'),
(7189,'Eye of Darkness','false','quest',0,'stackable','paper','none',-1,0,0,'false','false','true','false','C4Item','none'),
(7190,'Evil Spirit of Darkness','false','quest',0,'stackable','paper','none',-1,0,0,'false','false','true','false','C4Item','none'),
(7191,'Broken Crystal','false','quest',0,'stackable','paper','none',-1,0,0,'false','false','true','false','C4Item','none'),
(7192,'Unfinished Summon Crystal','false','quest',0,'stackable','paper','none',-1,0,0,'false','false','true','false','C4Item','none'),
(7193,'Summon Crystal','false','quest',0,'stackable','paper','none',-1,0,0,'false','false','true','false','C4Item','none'),
(7194,'Essence of Daimon','false','quest',0,'stackable','paper','none',-1,0,0,'false','false','true','false','C4Item','none'),
(7195,'Boiled Eggs','false','quest',0,'stackable','paper','none',-1,0,0,'false','false','true','false','C4Item','none'),
(7196,'Fee of Boiled Egg','false','quest',0,'stackable','paper','none',-1,0,0,'false','false','true','false','C4Item','none'),
(7197,'Special Drink','false','quest',0,'stackable','paper','none',-1,0,0,'false','false','true','false','C4Item','none'),
(7198,'Fee of Special Drink','false','quest',0,'stackable','paper','none',-1,0,0,'false','false','true','false','C4Item','none'),
(7199,'Leaf of Flava','false','quest',0,'stackable','paper','none',-1,0,0,'false','false','true','false','C4Item','none'),
(7200,'Buffalo Meat','false','quest',0,'stackable','paper','none',-1,0,0,'false','false','true','false','C4Item','none'),
(7201,'Antelope Horn','false','quest',0,'stackable','paper','none',-1,0,0,'false','false','true','false','C4Item','none'),
(7202,'Trunk of Nepenthes','false','quest',0,'stackable','paper','none',-1,0,0,'false','false','true','false','C4Item','none'),
(7203,'Foot of Bandersnatchling','false','quest',0,'stackable','paper','none',-1,0,0,'false','false','true','false','C4Item','none'),
(7204,'Secret Spice','false','quest',0,'stackable','paper','none',-1,0,0,'false','false','true','false','C4Item','none'),
(7205,'Soy Sauce Jar','false','quest',0,'stackable','paper','none',-1,0,0,'false','false','true','false','C4Item','none'),
(7206,'Boiled Eggs for Delivery','false','quest',0,'stackable','paper','none',-1,0,0,'false','false','true','false','C4Item','none'),
(7207,'Special Drink for Delivery','false','quest',0,'stackable','paper','none',-1,0,0,'false','false','true','false','C4Item','none'),
(7208,'Hot Food Box','false','quest',0,'stackable','paper','none',-1,0,0,'false','false','true','false','C4Item','none'),
(7209,'Food for Bumbalump','false','quest',0,'stackable','paper','none',-1,0,0,'false','false','true','false','C4Item','none'),
(7210,'Special Yeti Meat','false','quest',0,'stackable','paper','none',-1,0,0,'false','false','true','false','C4Item','none'),
(7211,'Mark of Ketra\'s Alliance - Level 1','false','quest',0,'stackable','paper','none',-1,0,0,'false','false','true','false','C4Item','none'),
(7212,'Mark of Ketra\'s Alliance - Level 2','false','quest',0,'stackable','paper','none',-1,0,0,'false','false','true','false','C4Item','none'),
(7213,'Mark of Ketra\'s Alliance - Level 3','false','quest',0,'stackable','paper','none',-1,0,0,'false','false','true','false','C4Item','none'),
(7214,'Mark of Ketra\'s Alliance - Level 4','false','quest',0,'stackable','paper','none',-1,0,0,'false','false','true','false','C4Item','none'),
(7215,'Mark of Ketra\'s Alliance - Level 5','false','quest',0,'stackable','paper','none',-1,0,0,'false','false','true','false','C4Item','none'),
(7216,'Varka\'s Badge - Soldier','false','quest',0,'stackable','paper','none',-1,0,0,'false','false','true','false','C4Item','none'),
(7217,'Varka\'s Badge - Captain','false','quest',0,'stackable','paper','none',-1,0,0,'false','false','true','false','C4Item','none'),
(7218,'Varka\'s Badge - General','false','quest',0,'stackable','paper','none',-1,0,0,'false','false','true','false','C4Item','none'),
(7219,'Totem of Valor','false','quest',0,'stackable','paper','none',-1,0,0,'false','false','true','false','C4Item','none'),
(7220,'Totem of Wisdom','false','quest',0,'stackable','paper','none',-1,0,0,'false','false','true','false','C4Item','none'),
(7221,'Mark of Varka\'s Alliance - Level 1','false','quest',0,'stackable','paper','none',-1,0,0,'false','false','true','false','C4Item','none'),
(7222,'Mark of Varka\'s Alliance - Level 2','false','quest',0,'stackable','paper','none',-1,0,0,'false','false','true','false','C4Item','none'),
(7223,'Mark of Varka\'s Alliance - Level 3','false','quest',0,'stackable','paper','none',-1,0,0,'false','false','true','false','C4Item','none'),
(7224,'Mark of Varka\'s Alliance - Level 4','false','quest',0,'stackable','paper','none',-1,0,0,'false','false','true','false','C4Item','none'),
(7225,'Mark of Varka\'s Alliance - Level 5','false','quest',0,'stackable','paper','none',-1,0,0,'false','false','true','false','C4Item','none'),
(7226,'Ketra\'s Badge - Soldier','false','quest',0,'stackable','paper','none',-1,0,0,'false','false','true','false','C4Item','none'),
(7227,'Ketra\'s Badge - Captain','false','quest',0,'stackable','paper','none',-1,0,0,'false','false','true','false','C4Item','none'),
(7228,'Ketra\'s Badge - General','false','quest',0,'stackable','paper','none',-1,0,0,'false','false','true','false','C4Item','none'),
(7229,'Feather of Valor','false','quest',0,'stackable','paper','none',-1,0,0,'false','false','true','false','C4Item','none'),
(7230,'Feather of Wisdom','false','quest',0,'stackable','paper','none',-1,0,0,'false','false','true','false','C4Item','none'),
(7231,'Munitions Box','false','quest',0,'stackable','paper','none',-1,0,0,'false','false','true','false','C4Item','none'),
(7232,'Munitions Box','false','quest',0,'stackable','paper','none',-1,0,0,'false','false','true','false','C4Item','none'),
(7233,'Varka\'s Mane','false','quest',0,'stackable','paper','none',-1,0,0,'false','false','true','false','C4Item','none'),
(7234,'Molar of Ketra Orc','false','quest',0,'stackable','paper','none',-1,0,0,'false','false','true','false','C4Item','none'),
(7235,'Head of Shadith','false','quest',0,'stackable','paper','none',-1,0,0,'false','false','true','false','C4Item','none'),
(7236,'Head of Mos','false','quest',0,'stackable','paper','none',-1,0,0,'false','false','true','false','C4Item','none'),
(7237,'Stolen Green Totem','false','quest',0,'stackable','paper','none',-1,0,0,'false','false','true','false','C4Item','none'),
(7238,'Green Totem','false','quest',0,'stackable','paper','none',-1,0,0,'false','false','true','false','C4Item','none'),
(7239,'Ice Heart of Ashutar','false','quest',0,'stackable','paper','none',-1,0,0,'false','false','true','false','C4Item','none'),
(7240,'Head of Hekaton','false','quest',0,'stackable','paper','none',-1,0,0,'false','false','true','false','C4Item','none'),
(7241,'Head of Tayr','false','quest',0,'stackable','paper','none',-1,0,0,'false','false','true','false','C4Item','none'),
(7242,'Stolen Red Totem','false','quest',0,'stackable','paper','none',-1,0,0,'false','false','true','false','C4Item','none'),
(7243,'Red Totem','false','quest',0,'stackable','paper','none',-1,0,0,'false','false','true','false','C4Item','none'),
(7244,'Fire Heart of Nastron','false','quest',0,'stackable','paper','none',-1,0,0,'false','false','true','false','C4Item','none'),
(7245,'Supply Box','false','quest',0,'stackable','paper','none',-1,0,0,'false','false','true','false','C4Item','none'),
(7246,'Golden Ram Badge - Recruit','false','quest',0,'stackable','paper','none',-1,0,0,'false','false','true','false','C4Item','none'),
(7247,'Golden Ram Badge - Soldier','false','quest',0,'stackable','paper','none',-1,0,0,'false','false','true','false','C4Item','none'),
(7248,'Splinter Stakato Chitin','false','quest',0,'stackable','paper','none',-1,0,0,'false','false','true','false','C4Item','none'),
(7249,'Needle Stakato Chitin','false','quest',0,'stackable','paper','none',-1,0,0,'false','false','true','false','C4Item','none'),
(7250,'Talon of Stakato','false','quest',0,'stackable','paper','none',-1,0,0,'false','false','true','false','C4Item','none'),
(7251,'Golden Ram Coin','false','quest',0,'stackable','paper','none',-1,0,0,'false','false','true','false','C4Item','none'),
(7252,'Krorin\'s Journal','false','quest',0,'stackable','paper','none',-1,0,0,'false','false','true','false','C4Item','none'),
(7253,'Letter to Archaeologist','false','quest',0,'stackable','paper','none',-1,0,0,'false','false','true','false','C4Item','none'),
(7254,'Broken Relic Part','false','quest',0,'stackable','paper','none',-1,0,0,'false','false','true','false','C4Item','none'),
(7255,'Sealed Box','false','quest',0,'stackable','paper','none',-1,0,0,'false','false','true','false','C4Item','none'),
(7256,'Goblet of Alectia','false','quest',0,'stackable','paper','none',-1,0,0,'false','false','true','false','C4Item','none'),
(7257,'Goblet of Tishas','false','quest',0,'stackable','paper','none',-1,0,0,'false','false','true','false','C4Item','none'),
(7258,'Goblet of Mekara','false','quest',0,'stackable','paper','none',-1,0,0,'false','false','true','false','C4Item','none'),
(7259,'Goblet of Morigul','false','quest',0,'stackable','paper','none',-1,0,0,'false','false','true','false','C4Item','none'),
(7260,'Chapel Key','false','quest',0,'stackable','paper','none',-1,0,0,'false','false','true','false','C4Item','none'),
(7261,'Used Grave Pass','false','quest',0,'stackable','paper','none',-1,0,0,'false','false','true','false','C4Item','none'),
(7262,'Antique Brooch','false','quest',0,'stackable','paper','none',-1,0,0,'false','false','true','false','C4Item','none'),
(7263,'Package to Vulcan','false','quest',0,'stackable','paper','none',-1,0,0,'false','false','true','false','C4Item','none'),
(7264,'Torch','false','quest',0,'stackable','paper','none',-1,0,0,'false','false','true','false','C4Item','none'),
(7265,'Vacualite Ore','false','quest',0,'stackable','paper','none',-1,0,0,'false','false','true','false','C4Item','none'),
(7266,'Vacualite','false','quest',0,'stackable','paper','none',-1,0,0,'false','false','true','false','C4Item','none'),
(7267,'Floating Stone','false','quest',0,'stackable','paper','none',-1,0,0,'false','false','true','false','C4Item','none'),
(7268,'Resonance Amulet - 1','false','quest',0,'stackable','paper','none',-1,0,0,'false','false','true','false','C4Item','none'),
(7269,'Resonance Amulet - 1','false','quest',0,'stackable','paper','none',-1,0,0,'false','false','true','false','C4Item','none'),
(7270,'Resonance Amulet - 1','false','quest',0,'stackable','paper','none',-1,0,0,'false','false','true','false','C4Item','none'),
(7271,'Resonance Amulet - 1','false','quest',0,'stackable','paper','none',-1,0,0,'false','false','true','false','C4Item','none'),
(7272,'Resonance Amulet - 1','false','quest',0,'stackable','paper','none',-1,0,0,'false','false','true','false','C4Item','none'),
(7273,'Resonance Amulet - 1','false','quest',0,'stackable','paper','none',-1,0,0,'false','false','true','false','C4Item','none'),
(7274,'Resonance Amulet - 1','false','quest',0,'stackable','paper','none',-1,0,0,'false','false','true','false','C4Item','none'),
(7275,'Resonance Amulet - 1','false','quest',0,'stackable','paper','none',-1,0,0,'false','false','true','false','C4Item','none'),
(7276,'Resonance Amulet - 1','false','quest',0,'stackable','paper','none',-1,0,0,'false','false','true','false','C4Item','none'),
(7277,'Resonance Amulet - 1','false','quest',0,'stackable','paper','none',-1,0,0,'false','false','true','false','C4Item','none'),
(7278,'Resonance Amulet - 1','false','quest',0,'stackable','paper','none',-1,0,0,'false','false','true','false','C4Item','none'),
(7279,'Resonance Amulet - 1','false','quest',0,'stackable','paper','none',-1,0,0,'false','false','true','false','C4Item','none'),
(7280,'Resonance Amulet - 1','false','quest',0,'stackable','paper','none',-1,0,0,'false','false','true','false','C4Item','none'),
(7281,'Resonance Amulet - 1','false','quest',0,'stackable','paper','none',-1,0,0,'false','false','true','false','C4Item','none'),
(7282,'Resonance Amulet - 1','false','quest',0,'stackable','paper','none',-1,0,0,'false','false','true','false','C4Item','none'),
(7283,'Resonance Amulet - 1','false','quest',0,'stackable','paper','none',-1,0,0,'false','false','true','false','C4Item','none'),
(7284,'Resonance Amulet - 1','false','quest',0,'stackable','paper','none',-1,0,0,'false','false','true','false','C4Item','none'),
(7285,'Resonance Amulet - 1','false','quest',0,'stackable','paper','none',-1,0,0,'false','false','true','false','C4Item','none'),
(7286,'Resonance Amulet - 1','false','quest',0,'stackable','paper','none',-1,0,0,'false','false','true','false','C4Item','none'),
(7287,'Resonance Amulet - 1','false','quest',0,'stackable','paper','none',-1,0,0,'false','false','true','false','C4Item','none'),
(7288,'Resonance Amulet - 1','false','quest',0,'stackable','paper','none',-1,0,0,'false','false','true','false','C4Item','none'),
(7289,'Resonance Amulet - 1','false','quest',0,'stackable','paper','none',-1,0,0,'false','false','true','false','C4Item','none'),
(7290,'Resonance Amulet - 1','false','quest',0,'stackable','paper','none',-1,0,0,'false','false','true','false','C4Item','none'),
(7291,'Resonance Amulet - 1','false','quest',0,'stackable','paper','none',-1,0,0,'false','false','true','false','C4Item','none'),
(7292,'Resonance Amulet - 1','false','quest',0,'stackable','paper','none',-1,0,0,'false','false','true','false','C4Item','none'),
(7293,'Resonance Amulet - 1','false','quest',0,'stackable','paper','none',-1,0,0,'false','false','true','false','C4Item','none'),
(7294,'Resonance Amulet - 1','false','quest',0,'stackable','paper','none',-1,0,0,'false','false','true','false','C4Item','none'),
(7295,'Resonance Amulet - 1','false','quest',0,'stackable','paper','none',-1,0,0,'false','false','true','false','C4Item','none'),
(7296,'Resonance Amulet - 1','false','quest',0,'stackable','paper','none',-1,0,0,'false','false','true','false','C4Item','none'),
(7297,'Resonance Amulet - 1','false','quest',0,'stackable','paper','none',-1,0,0,'false','false','true','false','C4Item','none'),
(7298,'Resonance Amulet - 1','false','quest',0,'stackable','paper','none',-1,0,0,'false','false','true','false','C4Item','none'),
(7299,'Resonance Amulet - 2','false','quest',0,'stackable','paper','none',-1,0,0,'false','false','true','false','C4Item','none'),
(7300,'Resonance Amulet - 2','false','quest',0,'stackable','paper','none',-1,0,0,'false','false','true','false','C4Item','none'),
(7301,'Resonance Amulet - 2','false','quest',0,'stackable','paper','none',-1,0,0,'false','false','true','false','C4Item','none'),
(7302,'Resonance Amulet - 2','false','quest',0,'stackable','paper','none',-1,0,0,'false','false','true','false','C4Item','none'),
(7303,'Resonance Amulet - 2','false','quest',0,'stackable','paper','none',-1,0,0,'false','false','true','false','C4Item','none'),
(7304,'Resonance Amulet - 2','false','quest',0,'stackable','paper','none',-1,0,0,'false','false','true','false','C4Item','none'),
(7305,'Resonance Amulet - 2','false','quest',0,'stackable','paper','none',-1,0,0,'false','false','true','false','C4Item','none'),
(7306,'Resonance Amulet - 2','false','quest',0,'stackable','paper','none',-1,0,0,'false','false','true','false','C4Item','none'),
(7307,'Resonance Amulet - 2','false','quest',0,'stackable','paper','none',-1,0,0,'false','false','true','false','C4Item','none'),
(7308,'Resonance Amulet - 2','false','quest',0,'stackable','paper','none',-1,0,0,'false','false','true','false','C4Item','none'),
(7309,'Resonance Amulet - 2','false','quest',0,'stackable','paper','none',-1,0,0,'false','false','true','false','C4Item','none'),
(7310,'Resonance Amulet - 2','false','quest',0,'stackable','paper','none',-1,0,0,'false','false','true','false','C4Item','none'),
(7311,'Resonance Amulet - 2','false','quest',0,'stackable','paper','none',-1,0,0,'false','false','true','false','C4Item','none'),
(7312,'Resonance Amulet - 2','false','quest',0,'stackable','paper','none',-1,0,0,'false','false','true','false','C4Item','none'),
(7313,'Resonance Amulet - 2','false','quest',0,'stackable','paper','none',-1,0,0,'false','false','true','false','C4Item','none'),
(7314,'Resonance Amulet - 2','false','quest',0,'stackable','paper','none',-1,0,0,'false','false','true','false','C4Item','none'),
(7315,'Resonance Amulet - 2','false','quest',0,'stackable','paper','none',-1,0,0,'false','false','true','false','C4Item','none'),
(7316,'Resonance Amulet - 2','false','quest',0,'stackable','paper','none',-1,0,0,'false','false','true','false','C4Item','none'),
(7317,'Resonance Amulet - 2','false','quest',0,'stackable','paper','none',-1,0,0,'false','false','true','false','C4Item','none'),
(7318,'Resonance Amulet - 2','false','quest',0,'stackable','paper','none',-1,0,0,'false','false','true','false','C4Item','none'),
(7319,'Resonance Amulet - 2','false','quest',0,'stackable','paper','none',-1,0,0,'false','false','true','false','C4Item','none'),
(7320,'Resonance Amulet - 2','false','quest',0,'stackable','paper','none',-1,0,0,'false','false','true','false','C4Item','none'),
(7321,'Resonance Amulet - 2','false','quest',0,'stackable','paper','none',-1,0,0,'false','false','true','false','C4Item','none'),
(7322,'Resonance Amulet - 2','false','quest',0,'stackable','paper','none',-1,0,0,'false','false','true','false','C4Item','none'),
(7323,'Resonance Amulet - 2','false','quest',0,'stackable','paper','none',-1,0,0,'false','false','true','false','C4Item','none'),
(7324,'Resonance Amulet - 2','false','quest',0,'stackable','paper','none',-1,0,0,'false','false','true','false','C4Item','none'),
(7325,'Resonance Amulet - 2','false','quest',0,'stackable','paper','none',-1,0,0,'false','false','true','false','C4Item','none'),
(7326,'Resonance Amulet - 2','false','quest',0,'stackable','paper','none',-1,0,0,'false','false','true','false','C4Item','none'),
(7327,'Resonance Amulet - 2','false','quest',0,'stackable','paper','none',-1,0,0,'false','false','true','false','C4Item','none'),
(7328,'Resonance Amulet - 2','false','quest',0,'stackable','paper','none',-1,0,0,'false','false','true','false','C4Item','none'),
(7329,'Resonance Amulet - 2','false','quest',0,'stackable','paper','none',-1,0,0,'false','false','true','false','C4Item','none'),
(7330,'Resonance Amulet - 3','false','quest',0,'stackable','paper','none',-1,0,0,'false','false','true','false','C4Item','none'),
(7331,'Resonance Amulet - 3','false','quest',0,'stackable','paper','none',-1,0,0,'false','false','true','false','C4Item','none'),
(7332,'Resonance Amulet - 3','false','quest',0,'stackable','paper','none',-1,0,0,'false','false','true','false','C4Item','none'),
(7333,'Resonance Amulet - 3','false','quest',0,'stackable','paper','none',-1,0,0,'false','false','true','false','C4Item','none'),
(7334,'Resonance Amulet - 3','false','quest',0,'stackable','paper','none',-1,0,0,'false','false','true','false','C4Item','none'),
(7335,'Resonance Amulet - 3','false','quest',0,'stackable','paper','none',-1,0,0,'false','false','true','false','C4Item','none'),
(7336,'Resonance Amulet - 3','false','quest',0,'stackable','paper','none',-1,0,0,'false','false','true','false','C4Item','none'),
(7337,'Resonance Amulet - 3','false','quest',0,'stackable','paper','none',-1,0,0,'false','false','true','false','C4Item','none'),
(7338,'Resonance Amulet - 3','false','quest',0,'stackable','paper','none',-1,0,0,'false','false','true','false','C4Item','none'),
(7339,'Resonance Amulet - 3','false','quest',0,'stackable','paper','none',-1,0,0,'false','false','true','false','C4Item','none'),
(7340,'Resonance Amulet - 3','false','quest',0,'stackable','paper','none',-1,0,0,'false','false','true','false','C4Item','none'),
(7341,'Resonance Amulet - 3','false','quest',0,'stackable','paper','none',-1,0,0,'false','false','true','false','C4Item','none'),
(7342,'Resonance Amulet - 3','false','quest',0,'stackable','paper','none',-1,0,0,'false','false','true','false','C4Item','none'),
(7343,'Resonance Amulet - 3','false','quest',0,'stackable','paper','none',-1,0,0,'false','false','true','false','C4Item','none'),
(7344,'Resonance Amulet - 3','false','quest',0,'stackable','paper','none',-1,0,0,'false','false','true','false','C4Item','none'),
(7345,'Resonance Amulet - 3','false','quest',0,'stackable','paper','none',-1,0,0,'false','false','true','false','C4Item','none'),
(7346,'Resonance Amulet - 3','false','quest',0,'stackable','paper','none',-1,0,0,'false','false','true','false','C4Item','none'),
(7347,'Resonance Amulet - 3','false','quest',0,'stackable','paper','none',-1,0,0,'false','false','true','false','C4Item','none'),
(7348,'Resonance Amulet - 3','false','quest',0,'stackable','paper','none',-1,0,0,'false','false','true','false','C4Item','none'),
(7349,'Resonance Amulet - 3','false','quest',0,'stackable','paper','none',-1,0,0,'false','false','true','false','C4Item','none'),
(7350,'Resonance Amulet - 3','false','quest',0,'stackable','paper','none',-1,0,0,'false','false','true','false','C4Item','none'),
(7351,'Resonance Amulet - 3','false','quest',0,'stackable','paper','none',-1,0,0,'false','false','true','false','C4Item','none'),
(7352,'Resonance Amulet - 3','false','quest',0,'stackable','paper','none',-1,0,0,'false','false','true','false','C4Item','none'),
(7353,'Resonance Amulet - 3','false','quest',0,'stackable','paper','none',-1,0,0,'false','false','true','false','C4Item','none'),
(7354,'Resonance Amulet - 3','false','quest',0,'stackable','paper','none',-1,0,0,'false','false','true','false','C4Item','none'),
(7355,'Resonance Amulet - 3','false','quest',0,'stackable','paper','none',-1,0,0,'false','false','true','false','C4Item','none'),
(7356,'Resonance Amulet - 3','false','quest',0,'stackable','paper','none',-1,0,0,'false','false','true','false','C4Item','none'),
(7357,'Resonance Amulet - 3','false','quest',0,'stackable','paper','none',-1,0,0,'false','false','true','false','C4Item','none'),
(7358,'Resonance Amulet - 3','false','quest',0,'stackable','paper','none',-1,0,0,'false','false','true','false','C4Item','none'),
(7359,'Resonance Amulet - 3','false','quest',0,'stackable','paper','none',-1,0,0,'false','false','true','false','C4Item','none'),
(7360,'Resonance Amulet - 3','false','quest',0,'stackable','paper','none',-1,0,0,'false','false','true','false','C4Item','none'),
(7361,'Resonance Amulet - 4','false','quest',0,'stackable','paper','none',-1,0,0,'false','false','true','false','C4Item','none'),
(7362,'Resonance Amulet - 4','false','quest',0,'stackable','paper','none',-1,0,0,'false','false','true','false','C4Item','none'),
(7363,'Resonance Amulet - 4','false','quest',0,'stackable','paper','none',-1,0,0,'false','false','true','false','C4Item','none'),
(7364,'Resonance Amulet - 4','false','quest',0,'stackable','paper','none',-1,0,0,'false','false','true','false','C4Item','none'),
(7365,'Resonance Amulet - 4','false','quest',0,'stackable','paper','none',-1,0,0,'false','false','true','false','C4Item','none'),
(7366,'Resonance Amulet - 4','false','quest',0,'stackable','paper','none',-1,0,0,'false','false','true','false','C4Item','none'),
(7367,'Resonance Amulet - 4','false','quest',0,'stackable','paper','none',-1,0,0,'false','false','true','false','C4Item','none'),
(7368,'Resonance Amulet - 4','false','quest',0,'stackable','paper','none',-1,0,0,'false','false','true','false','C4Item','none'),
(7369,'Resonance Amulet - 4','false','quest',0,'stackable','paper','none',-1,0,0,'false','false','true','false','C4Item','none'),
(7370,'Resonance Amulet - 4','false','quest',0,'stackable','paper','none',-1,0,0,'false','false','true','false','C4Item','none'),
(7371,'Resonance Amulet - 4','false','quest',0,'stackable','paper','none',-1,0,0,'false','false','true','false','C4Item','none'),
(7372,'Resonance Amulet - 4','false','quest',0,'stackable','paper','none',-1,0,0,'false','false','true','false','C4Item','none'),
(7373,'Resonance Amulet - 4','false','quest',0,'stackable','paper','none',-1,0,0,'false','false','true','false','C4Item','none'),
(7374,'Resonance Amulet - 4','false','quest',0,'stackable','paper','none',-1,0,0,'false','false','true','false','C4Item','none'),
(7375,'Resonance Amulet - 4','false','quest',0,'stackable','paper','none',-1,0,0,'false','false','true','false','C4Item','none'),
(7376,'Resonance Amulet - 4','false','quest',0,'stackable','paper','none',-1,0,0,'false','false','true','false','C4Item','none'),
(7377,'Resonance Amulet - 4','false','quest',0,'stackable','paper','none',-1,0,0,'false','false','true','false','C4Item','none'),
(7378,'Resonance Amulet - 4','false','quest',0,'stackable','paper','none',-1,0,0,'false','false','true','false','C4Item','none'),
(7379,'Resonance Amulet - 4','false','quest',0,'stackable','paper','none',-1,0,0,'false','false','true','false','C4Item','none'),
(7380,'Resonance Amulet - 4','false','quest',0,'stackable','paper','none',-1,0,0,'false','false','true','false','C4Item','none'),
(7381,'Resonance Amulet - 4','false','quest',0,'stackable','paper','none',-1,0,0,'false','false','true','false','C4Item','none'),
(7382,'Resonance Amulet - 4','false','quest',0,'stackable','paper','none',-1,0,0,'false','false','true','false','C4Item','none'),
(7383,'Resonance Amulet - 4','false','quest',0,'stackable','paper','none',-1,0,0,'false','false','true','false','C4Item','none'),
(7384,'Resonance Amulet - 4','false','quest',0,'stackable','paper','none',-1,0,0,'false','false','true','false','C4Item','none'),
(7385,'Resonance Amulet - 4','false','quest',0,'stackable','paper','none',-1,0,0,'false','false','true','false','C4Item','none'),
(7386,'Resonance Amulet - 4','false','quest',0,'stackable','paper','none',-1,0,0,'false','false','true','false','C4Item','none'),
(7387,'Resonance Amulet - 4','false','quest',0,'stackable','paper','none',-1,0,0,'false','false','true','false','C4Item','none'),
(7388,'Resonance Amulet - 4','false','quest',0,'stackable','paper','none',-1,0,0,'false','false','true','false','C4Item','none'),
(7389,'Resonance Amulet - 4','false','quest',0,'stackable','paper','none',-1,0,0,'false','false','true','false','C4Item','none'),
(7390,'Resonance Amulet - 4','false','quest',0,'stackable','paper','none',-1,0,0,'false','false','true','false','C4Item','none'),
(7391,'Resonance Amulet - 4','false','quest',0,'stackable','paper','none',-1,0,0,'false','false','true','false','C4Item','none'),
(7392,'Resonance Amulet - 5','false','quest',0,'stackable','paper','none',-1,0,0,'false','false','true','false','C4Item','none'),
(7393,'Resonance Amulet - 5','false','quest',0,'stackable','paper','none',-1,0,0,'false','false','true','false','C4Item','none'),
(7394,'Resonance Amulet - 5','false','quest',0,'stackable','paper','none',-1,0,0,'false','false','true','false','C4Item','none'),
(7395,'Resonance Amulet - 5','false','quest',0,'stackable','paper','none',-1,0,0,'false','false','true','false','C4Item','none'),
(7396,'Resonance Amulet - 5','false','quest',0,'stackable','paper','none',-1,0,0,'false','false','true','false','C4Item','none'),
(7397,'Resonance Amulet - 5','false','quest',0,'stackable','paper','none',-1,0,0,'false','false','true','false','C4Item','none'),
(7398,'Resonance Amulet - 5','false','quest',0,'stackable','paper','none',-1,0,0,'false','false','true','false','C4Item','none'),
(7399,'Resonance Amulet - 5','false','quest',0,'stackable','paper','none',-1,0,0,'false','false','true','false','C4Item','none'),
(7400,'Resonance Amulet - 5','false','quest',0,'stackable','paper','none',-1,0,0,'false','false','true','false','C4Item','none'),
(7401,'Resonance Amulet - 5','false','quest',0,'stackable','paper','none',-1,0,0,'false','false','true','false','C4Item','none'),
(7402,'Resonance Amulet - 5','false','quest',0,'stackable','paper','none',-1,0,0,'false','false','true','false','C4Item','none'),
(7403,'Resonance Amulet - 5','false','quest',0,'stackable','paper','none',-1,0,0,'false','false','true','false','C4Item','none'),
(7404,'Resonance Amulet - 5','false','quest',0,'stackable','paper','none',-1,0,0,'false','false','true','false','C4Item','none'),
(7405,'Resonance Amulet - 5','false','quest',0,'stackable','paper','none',-1,0,0,'false','false','true','false','C4Item','none'),
(7406,'Resonance Amulet - 5','false','quest',0,'stackable','paper','none',-1,0,0,'false','false','true','false','C4Item','none'),
(7407,'Resonance Amulet - 5','false','quest',0,'stackable','paper','none',-1,0,0,'false','false','true','false','C4Item','none'),
(7408,'Resonance Amulet - 5','false','quest',0,'stackable','paper','none',-1,0,0,'false','false','true','false','C4Item','none'),
(7409,'Resonance Amulet - 5','false','quest',0,'stackable','paper','none',-1,0,0,'false','false','true','false','C4Item','none'),
(7410,'Resonance Amulet - 5','false','quest',0,'stackable','paper','none',-1,0,0,'false','false','true','false','C4Item','none'),
(7411,'Resonance Amulet - 5','false','quest',0,'stackable','paper','none',-1,0,0,'false','false','true','false','C4Item','none'),
(7412,'Resonance Amulet - 5','false','quest',0,'stackable','paper','none',-1,0,0,'false','false','true','false','C4Item','none'),
(7413,'Resonance Amulet - 5','false','quest',0,'stackable','paper','none',-1,0,0,'false','false','true','false','C4Item','none'),
(7414,'Resonance Amulet - 5','false','quest',0,'stackable','paper','none',-1,0,0,'false','false','true','false','C4Item','none'),
(7415,'Resonance Amulet - 5','false','quest',0,'stackable','paper','none',-1,0,0,'false','false','true','false','C4Item','none'),
(7416,'Resonance Amulet - 5','false','quest',0,'stackable','paper','none',-1,0,0,'false','false','true','false','C4Item','none'),
(7417,'Resonance Amulet - 5','false','quest',0,'stackable','paper','none',-1,0,0,'false','false','true','false','C4Item','none'),
(7418,'Resonance Amulet - 5','false','quest',0,'stackable','paper','none',-1,0,0,'false','false','true','false','C4Item','none'),
(7419,'Resonance Amulet - 5','false','quest',0,'stackable','paper','none',-1,0,0,'false','false','true','false','C4Item','none'),
(7420,'Resonance Amulet - 5','false','quest',0,'stackable','paper','none',-1,0,0,'false','false','true','false','C4Item','none'),
(7421,'Resonance Amulet - 5','false','quest',0,'stackable','paper','none',-1,0,0,'false','false','true','false','C4Item','none'),
(7422,'Resonance Amulet - 5','false','quest',0,'stackable','paper','none',-1,0,0,'false','false','true','false','C4Item','none'),
(7423,'Resonance Amulet - 6','false','quest',0,'stackable','paper','none',-1,0,0,'false','false','true','false','C4Item','none'),
(7424,'Resonance Amulet - 6','false','quest',0,'stackable','paper','none',-1,0,0,'false','false','true','false','C4Item','none'),
(7425,'Resonance Amulet - 6','false','quest',0,'stackable','paper','none',-1,0,0,'false','false','true','false','C4Item','none'),
(7426,'Resonance Amulet - 6','false','quest',0,'stackable','paper','none',-1,0,0,'false','false','true','false','C4Item','none'),
(7427,'Resonance Amulet - 6','false','quest',0,'stackable','paper','none',-1,0,0,'false','false','true','false','C4Item','none'),
(7428,'Resonance Amulet - 6','false','quest',0,'stackable','paper','none',-1,0,0,'false','false','true','false','C4Item','none'),
(7429,'Resonance Amulet - 6','false','quest',0,'stackable','paper','none',-1,0,0,'false','false','true','false','C4Item','none'),
(7430,'Resonance Amulet - 6','false','quest',0,'stackable','paper','none',-1,0,0,'false','false','true','false','C4Item','none'),
(7431,'Resonance Amulet - 6','false','quest',0,'stackable','paper','none',-1,0,0,'false','false','true','false','C4Item','none'),
(7432,'Resonance Amulet - 6','false','quest',0,'stackable','paper','none',-1,0,0,'false','false','true','false','C4Item','none'),
(7433,'Resonance Amulet - 6','false','quest',0,'stackable','paper','none',-1,0,0,'false','false','true','false','C4Item','none'),
(7434,'Resonance Amulet - 6','false','quest',0,'stackable','paper','none',-1,0,0,'false','false','true','false','C4Item','none'),
(7435,'Resonance Amulet - 6','false','quest',0,'stackable','paper','none',-1,0,0,'false','false','true','false','C4Item','none'),
(7436,'Resonance Amulet - 6','false','quest',0,'stackable','paper','none',-1,0,0,'false','false','true','false','C4Item','none'),
(7437,'Resonance Amulet - 6','false','quest',0,'stackable','paper','none',-1,0,0,'false','false','true','false','C4Item','none'),
(7438,'Resonance Amulet - 6','false','quest',0,'stackable','paper','none',-1,0,0,'false','false','true','false','C4Item','none'),
(7439,'Resonance Amulet - 6','false','quest',0,'stackable','paper','none',-1,0,0,'false','false','true','false','C4Item','none'),
(7440,'Resonance Amulet - 6','false','quest',0,'stackable','paper','none',-1,0,0,'false','false','true','false','C4Item','none'),
(7441,'Resonance Amulet - 6','false','quest',0,'stackable','paper','none',-1,0,0,'false','false','true','false','C4Item','none'),
(7442,'Resonance Amulet - 6','false','quest',0,'stackable','paper','none',-1,0,0,'false','false','true','false','C4Item','none'),
(7443,'Resonance Amulet - 6','false','quest',0,'stackable','paper','none',-1,0,0,'false','false','true','false','C4Item','none'),
(7444,'Resonance Amulet - 6','false','quest',0,'stackable','paper','none',-1,0,0,'false','false','true','false','C4Item','none'),
(7445,'Resonance Amulet - 6','false','quest',0,'stackable','paper','none',-1,0,0,'false','false','true','false','C4Item','none'),
(7446,'Resonance Amulet - 6','false','quest',0,'stackable','paper','none',-1,0,0,'false','false','true','false','C4Item','none'),
(7447,'Resonance Amulet - 6','false','quest',0,'stackable','paper','none',-1,0,0,'false','false','true','false','C4Item','none'),
(7448,'Resonance Amulet - 6','false','quest',0,'stackable','paper','none',-1,0,0,'false','false','true','false','C4Item','none'),
(7449,'Resonance Amulet - 6','false','quest',0,'stackable','paper','none',-1,0,0,'false','false','true','false','C4Item','none'),
(7450,'Resonance Amulet - 6','false','quest',0,'stackable','paper','none',-1,0,0,'false','false','true','false','C4Item','none'),
(7451,'Resonance Amulet - 6','false','quest',0,'stackable','paper','none',-1,0,0,'false','false','true','false','C4Item','none'),
(7452,'Resonance Amulet - 6','false','quest',0,'stackable','paper','none',-1,0,0,'false','false','true','false','C4Item','none'),
(7453,'Resonance Amulet - 6','false','quest',0,'stackable','paper','none',-1,0,0,'false','false','true','false','C4Item','none'),
(7454,'Resonance Amulet - 7','false','quest',0,'stackable','paper','none',-1,0,0,'false','false','true','false','C4Item','none'),
(7455,'Resonance Amulet - 7','false','quest',0,'stackable','paper','none',-1,0,0,'false','false','true','false','C4Item','none'),
(7456,'Resonance Amulet - 7','false','quest',0,'stackable','paper','none',-1,0,0,'false','false','true','false','C4Item','none'),
(7457,'Resonance Amulet - 7','false','quest',0,'stackable','paper','none',-1,0,0,'false','false','true','false','C4Item','none'),
(7458,'Resonance Amulet - 7','false','quest',0,'stackable','paper','none',-1,0,0,'false','false','true','false','C4Item','none'),
(7459,'Resonance Amulet - 7','false','quest',0,'stackable','paper','none',-1,0,0,'false','false','true','false','C4Item','none'),
(7460,'Resonance Amulet - 7','false','quest',0,'stackable','paper','none',-1,0,0,'false','false','true','false','C4Item','none'),
(7461,'Resonance Amulet - 7','false','quest',0,'stackable','paper','none',-1,0,0,'false','false','true','false','C4Item','none'),
(7462,'Resonance Amulet - 7','false','quest',0,'stackable','paper','none',-1,0,0,'false','false','true','false','C4Item','none'),
(7463,'Resonance Amulet - 7','false','quest',0,'stackable','paper','none',-1,0,0,'false','false','true','false','C4Item','none'),
(7464,'Resonance Amulet - 7','false','quest',0,'stackable','paper','none',-1,0,0,'false','false','true','false','C4Item','none'),
(7465,'Resonance Amulet - 7','false','quest',0,'stackable','paper','none',-1,0,0,'false','false','true','false','C4Item','none'),
(7466,'Resonance Amulet - 7','false','quest',0,'stackable','paper','none',-1,0,0,'false','false','true','false','C4Item','none'),
(7467,'Resonance Amulet - 7','false','quest',0,'stackable','paper','none',-1,0,0,'false','false','true','false','C4Item','none'),
(7468,'Resonance Amulet - 7','false','quest',0,'stackable','paper','none',-1,0,0,'false','false','true','false','C4Item','none'),
(7469,'Resonance Amulet - 7','false','quest',0,'stackable','paper','none',-1,0,0,'false','false','true','false','C4Item','none'),
(7470,'Resonance Amulet - 7','false','quest',0,'stackable','paper','none',-1,0,0,'false','false','true','false','C4Item','none'),
(7471,'Resonance Amulet - 7','false','quest',0,'stackable','paper','none',-1,0,0,'false','false','true','false','C4Item','none'),
(7472,'Resonance Amulet - 7','false','quest',0,'stackable','paper','none',-1,0,0,'false','false','true','false','C4Item','none'),
(7473,'Resonance Amulet - 7','false','quest',0,'stackable','paper','none',-1,0,0,'false','false','true','false','C4Item','none'),
(7474,'Resonance Amulet - 7','false','quest',0,'stackable','paper','none',-1,0,0,'false','false','true','false','C4Item','none'),
(7475,'Resonance Amulet - 7','false','quest',0,'stackable','paper','none',-1,0,0,'false','false','true','false','C4Item','none'),
(7476,'Resonance Amulet - 7','false','quest',0,'stackable','paper','none',-1,0,0,'false','false','true','false','C4Item','none'),
(7477,'Resonance Amulet - 7','false','quest',0,'stackable','paper','none',-1,0,0,'false','false','true','false','C4Item','none'),
(7478,'Resonance Amulet - 7','false','quest',0,'stackable','paper','none',-1,0,0,'false','false','true','false','C4Item','none'),
(7479,'Resonance Amulet - 7','false','quest',0,'stackable','paper','none',-1,0,0,'false','false','true','false','C4Item','none'),
(7480,'Resonance Amulet - 7','false','quest',0,'stackable','paper','none',-1,0,0,'false','false','true','false','C4Item','none'),
(7481,'Resonance Amulet - 7','false','quest',0,'stackable','paper','none',-1,0,0,'false','false','true','false','C4Item','none'),
(7482,'Resonance Amulet - 7','false','quest',0,'stackable','paper','none',-1,0,0,'false','false','true','false','C4Item','none'),
(7483,'Resonance Amulet - 7','false','quest',0,'stackable','paper','none',-1,0,0,'false','false','true','false','C4Item','none'),
(7484,'Resonance Amulet - 7','false','quest',0,'stackable','paper','none',-1,0,0,'false','false','true','false','C4Item','none'),
(7485,'Halisha\'s Mark','false','quest',0,'stackable','paper','none',-1,0,0,'false','false','true','false','C4Item','none'),
(7486,'Halisha\'s Mark','false','quest',0,'stackable','paper','none',-1,0,0,'false','false','true','false','C4Item','none'),
(7487,'Halisha\'s Mark','false','quest',0,'stackable','paper','none',-1,0,0,'false','false','true','false','C4Item','none'),
(7488,'Halisha\'s Mark','false','quest',0,'stackable','paper','none',-1,0,0,'false','false','true','false','C4Item','none'),
(7489,'Halisha\'s Mark','false','quest',0,'stackable','paper','none',-1,0,0,'false','false','true','false','C4Item','none'),
(7490,'Halisha\'s Mark','false','quest',0,'stackable','paper','none',-1,0,0,'false','false','true','false','C4Item','none'),
(7491,'Halisha\'s Mark','false','quest',0,'stackable','paper','none',-1,0,0,'false','false','true','false','C4Item','none'),
(7492,'Halisha\'s Mark','false','quest',0,'stackable','paper','none',-1,0,0,'false','false','true','false','C4Item','none'),
(7493,'Halisha\'s Mark','false','quest',0,'stackable','paper','none',-1,0,0,'false','false','true','false','C4Item','none'),
(7494,'Halisha\'s Mark','false','quest',0,'stackable','paper','none',-1,0,0,'false','false','true','false','C4Item','none'),
(7495,'Halisha\'s Mark','false','quest',0,'stackable','paper','none',-1,0,0,'false','false','true','false','C4Item','none'),
(7496,'Halisha\'s Mark','false','quest',0,'stackable','paper','none',-1,0,0,'false','false','true','false','C4Item','none'),
(7497,'Halisha\'s Mark','false','quest',0,'stackable','paper','none',-1,0,0,'false','false','true','false','C4Item','none'),
(7498,'Halisha\'s Mark','false','quest',0,'stackable','paper','none',-1,0,0,'false','false','true','false','C4Item','none'),
(7499,'Halisha\'s Mark','false','quest',0,'stackable','paper','none',-1,0,0,'false','false','true','false','C4Item','none'),
(7500,'Halisha\'s Mark','false','quest',0,'stackable','paper','none',-1,0,0,'false','false','true','false','C4Item','none'),
(7501,'Halisha\'s Mark','false','quest',0,'stackable','paper','none',-1,0,0,'false','false','true','false','C4Item','none'),
(7502,'Halisha\'s Mark','false','quest',0,'stackable','paper','none',-1,0,0,'false','false','true','false','C4Item','none'),
(7503,'Halisha\'s Mark','false','quest',0,'stackable','paper','none',-1,0,0,'false','false','true','false','C4Item','none'),
(7504,'Halisha\'s Mark','false','quest',0,'stackable','paper','none',-1,0,0,'false','false','true','false','C4Item','none'),
(7505,'Halisha\'s Mark','false','quest',0,'stackable','paper','none',-1,0,0,'false','false','true','false','C4Item','none'),
(7506,'Halisha\'s Mark','false','quest',0,'stackable','paper','none',-1,0,0,'false','false','true','false','C4Item','none'),
(7507,'Halisha\'s Mark','false','quest',0,'stackable','paper','none',-1,0,0,'false','false','true','false','C4Item','none'),
(7508,'Halisha\'s Mark','false','quest',0,'stackable','paper','none',-1,0,0,'false','false','true','false','C4Item','none'),
(7509,'Halisha\'s Mark','false','quest',0,'stackable','paper','none',-1,0,0,'false','false','true','false','C4Item','none'),
(7510,'Halisha\'s Mark','false','quest',0,'stackable','paper','none',-1,0,0,'false','false','true','false','C4Item','none'),
(7511,'Halisha\'s Mark','false','quest',0,'stackable','paper','none',-1,0,0,'false','false','true','false','C4Item','none'),
(7512,'Halisha\'s Mark','false','quest',0,'stackable','paper','none',-1,0,0,'false','false','true','false','C4Item','none'),
(7513,'Halisha\'s Mark','false','quest',0,'stackable','paper','none',-1,0,0,'false','false','true','false','C4Item','none'),
(7514,'Halisha\'s Mark','false','quest',0,'stackable','paper','none',-1,0,0,'false','false','true','false','C4Item','none'),
(7515,'Halisha\'s Mark','false','quest',0,'stackable','paper','none',-1,0,0,'false','false','true','false','C4Item','none'),
(7516,'Ice Wine','false','quest',0,'stackable','paper','none',-1,0,0,'false','false','true','false','C4Item','none'),
(7517,'Donath\'s'' Dish','false','quest',0,'stackable','paper','none',-1,0,0,'false','false','true','false','C4Item','none'),
(7518,'Donath\'s'' Note - Vol.1','false','quest',0,'stackable','paper','none',-1,0,0,'false','false','true','false','C4Item','none'),
(7519,'Shaved Ice','false','quest',0,'stackable','paper','none',-1,0,0,'false','false','true','false','C4Item','none'),
(7520,'Ice Cream','false','quest',0,'stackable','paper','none',-1,0,0,'false','false','true','false','C4Item','none'),
(7521,'Ice Crystal Gemstone','false','quest',0,'stackable','paper','none',-1,0,0,'false','false','true','false','C4Item','none'),
(7522,'Offering','false','quest',0,'stackable','paper','none',-1,0,0,'false','false','true','false','C4Item','none'),
(7523,'Offering','false','quest',0,'stackable','paper','none',-1,0,0,'false','false','true','false','C4Item','none'),
(7524,'Offering','false','quest',0,'stackable','paper','none',-1,0,0,'false','false','true','false','C4Item','none'),
(7525,'Offering','false','quest',0,'stackable','paper','none',-1,0,0,'false','false','true','false','C4Item','none'),
(7526,'Ancient Language Dictionary','false','quest',0,'stackable','paper','none',-1,0,0,'false','false','true','false','C4Item','none'),
(7527,'Ancient Language Dictionary','false','quest',0,'stackable','paper','none',-1,0,0,'false','false','true','false','C4Item','none'),
(7528,'Spinneret','false','quest',0,'stackable','paper','none',-1,0,0,'false','false','true','false','C4Item','none'),
(7529,'Investigative Report','false','quest',0,'stackable','paper','none',-1,0,0,'false','false','true','false','C4Item','none'),
(7530,'Investigative Report','false','quest',0,'stackable','paper','none',-1,0,0,'false','false','true','false','C4Item','none'),
(7531,'Investigative Report','false','quest',0,'stackable','paper','none',-1,0,0,'false','false','true','false','C4Item','none'),
(7532,'Investigative Report','false','quest',0,'stackable','paper','none',-1,0,0,'false','false','true','false','C4Item','none'),
(7533,'Investigative Report','false','quest',0,'stackable','paper','none',-1,0,0,'false','false','true','false','C4Item','none'),
(7534,'Ice Cold Flower','false','quest',0,'stackable','paper','none',-1,0,0,'false','false','true','false','C4Item','none'),
(7535,'Pure Ice','false','quest',0,'stackable','paper','none',-1,0,0,'false','false','true','false','C4Item','none'),
(7536,'Bitter Cold Beer','false','quest',0,'stackable','paper','none',-1,0,0,'false','false','true','false','C4Item','none'),
(7537,'Multiple Course Meal','false','quest',0,'stackable','paper','none',-1,0,0,'false','false','true','false','C4Item','none'),
(7538,'Dead Souls Fish Soup','false','quest',0,'stackable','paper','none',-1,0,0,'false','false','true','false','C4Item','none'),
(7539,'Bitter Cold Vodka','false','quest',0,'stackable','paper','none',-1,0,0,'false','false','true','false','C4Item','none'),
(7540,'Silver Crystal','false','quest',0,'stackable','paper','none',-1,0,0,'false','false','true','false','C4Item','none'),
(7541,'Red Crystal','false','quest',0,'stackable','paper','none',-1,0,0,'false','false','true','false','C4Item','none'),
(7542,'Vampire\'s Heart','false','quest',0,'stackable','paper','none',-1,0,0,'false','false','true','false','C4Item','none'),
(7543,'Zombie\'s Brain','false','quest',0,'stackable','paper','none',-1,0,0,'false','false','true','false','C4Item','none'),
(7544,'Rib Bone of a Black Magus','false','quest',0,'stackable','paper','none',-1,0,0,'false','false','true','false','C4Item','none'),
(7545,'Zombie\'s Liver','false','quest',0,'stackable','paper','none',-1,0,0,'false','false','true','false','C4Item','none'),
(7546,'Top Quality Meat','false','quest',0,'stackable','paper','none',-1,0,0,'false','false','true','false','C4Item','none'),
(7547,'Young Wild Beast Meat','false','quest',0,'stackable','paper','none',-1,0,0,'false','false','true','false','C4Item','none'),
(7548,'Map Piece','false','quest',0,'stackable','paper','none',-1,0,0,'false','false','true','false','C4Item','none'),
(7549,'Yellow Map','false','quest',0,'stackable','paper','none',-1,0,0,'false','false','true','false','C4Item','none'),
(7550,'Map Piece','false','quest',0,'stackable','paper','none',-1,0,0,'false','false','true','false','C4Item','none'),
(7551,'Ivory Colored Map','false','quest',0,'stackable','paper','none',-1,0,0,'false','false','true','false','C4Item','none'),
(7552,'Broken Gemstone Fragment','false','quest',0,'stackable','paper','none',-1,0,0,'false','false','true','false','C4Item','none'),
(7553,'Gold Colored Gemstone','false','quest',0,'stackable','paper','none',-1,0,0,'false','false','true','false','C4Item','none'),
(7554,'Scroll of Escape: Talking Island','false','none',0,'normal','paper','none',-1,400,0,'false','false','true','false','C4Item','none'),
(7555,'Scroll of Escape: Elven Village','false','none',0,'normal','paper','none',-1,400,0,'false','false','true','false','C4Item','none'),
(7556,'Scroll of Escape: Dark Elf Village','false','none',0,'normal','paper','none',-1,400,0,'false','false','true','false','C4Item','none'),
(7557,'Scroll of Escape: Orc Village','false','none',0,'normal','paper','none',-1,400,0,'false','false','true','false','C4Item','none'),
(7558,'Scroll of Escape: Dwarven Village','false','none',0,'normal','paper','none',-1,400,0,'false','false','true','false','C4Item','none'),
(7559,'Scroll of Escape: Giran Castle Town','false','none',0,'normal','paper','none',-1,400,0,'false','false','true','false','C4Item','none'),
(7561,'Fishing Manual','false','none',0,'normal','paper','none',-1,100,0,'false','false','true','false','C4Item','none'),
(7562,'Dimensional Diamond','false','none',0,'stackable','paper','none',-1,0,0,'true','true','true','true','C4Item','none'),
(7563,'Gwains (Document)','false','quest',0,'stackable','paper','none',-1,0,0,'false','false','true','false','C4Item','none'),
(7564,'Gwains (Document)','false','quest',0,'stackable','paper','none',-1,0,0,'false','false','true','false','C4Item','none'),
(7565,'Gwains (Document)','false','quest',0,'stackable','paper','none',-1,0,0,'false','false','true','false','C4Item','none'),
(7566,'Purified Magic Necklace','false','quest',0,'stackable','paper','none',-1,0,0,'false','false','true','false','C4Item','none'),
(7567,'Gemstone Powder','false','quest',0,'stackable','paper','none',-1,0,0,'false','false','true','false','C4Item','none'),
(7568,'Magic Sword Hilt','false','quest',0,'stackable','paper','none',-1,0,0,'false','false','true','false','C4Item','none'),
(7569,'Four-leaf Golden Clover Coin','false','quest',0,'stackable','paper','none',-1,0,0,'false','false','true','false','C4Item','none'),
(7570,'Mark of Traveler','false','quest',0,'stackable','paper','none',-1,0,0,'false','false','true','false','C4Item','none'),
(7571,'Baulro\'s Letter','false','quest',0,'stackable','paper','none',-1,0,0,'false','false','true','false','C4Item','none'),
(7572,'Ariel\'s Recommendation','false','quest',0,'stackable','paper','none',-1,0,0,'false','false','true','false','C4Item','none'),
(7573,'Roselyn\'s Note','false','quest',0,'stackable','paper','none',-1,0,0,'false','false','true','false','C4Item','none'),
(7574,'Very Expensive Necklace','false','quest',0,'stackable','paper','none',-1,0,0,'false','false','true','false','C4Item','none'),
(7579,'Draconic Bow Shaft','false','material',60,'stackable','liquid','none',-1,91471,0,'true','true','true','true','C4Item','none'),
(7580,'Recipe: Draconic Bow (60%)','false','recipe',30,'stackable','paper','none',-1,976000,0,'true','true','true','true','C4Item','none'),
(7581,'Recipe: Draconic Bow (100%)','false','recipe',30,'stackable','paper','none',-1,976000,0,'true','true','true','true','C4Item','none'),
(7582,'Baby Spice','false','none',10,'stackable','liquid','none',-1,100,0,'true','true','true','true','C4Item','none'),
(7583,'Pet Exchange Ticket: Buffalo','false','none',20,'stackable','paper','none',-1,500000,0,'true','true','true','true','C4Item','none'),
(7584,'Pet Exchange Ticket: Cougar','false','none',20,'stackable','paper','none',-1,500000,0,'true','true','true','true','C4Item','none'),
(7585,'Pet Exchange Ticket: Kookaburra','false','none',20,'stackable','paper','none',-1,500000,0,'true','true','true','true','C4Item','none'),
(7586,'Sweet Fluid','false','quest',0,'stackable','paper','none',-1,0,0,'false','false','true','false','C4Item','none'),
(7587,'Legend of Seventeen','false','quest',0,'stackable','paper','none',-1,0,0,'false','false','true','false','C4Item','none'),
(7588,'Faded Poetry Book','false','quest',0,'stackable','paper','none',-1,0,0,'false','false','true','false','C4Item','none'),
(7589,'Echo Crystal - Forgotten Song','false','quest',0,'stackable','paper','none',-1,0,0,'false','false','true','false','C4Item','none'),
(7590,'Strand of Golden Hair','false','quest',0,'stackable','paper','none',-1,0,0,'false','false','true','false','C4Item','none'),
(7591,'Ring of Goddess: Waterbinder','false','quest',0,'stackable','paper','none',-1,0,0,'false','false','true','false','C4Item','none'),
(7592,'Necklace of Goddess: EverGreen','false','quest',0,'stackable','paper','none',-1,0,0,'false','false','true','false','C4Item','none'),
(7593,'Staff of Goddess: Rain Song','false','quest',0,'stackable','paper','none',-1,0,0,'false','false','true','false','C4Item','none'),
(7594,'Relic Box','false','quest',0,'stackable','paper','none',-1,0,0,'false','false','true','false','C4Item','none'),
(7595,'Orb of Binding','false','quest',0,'stackable','paper','none',-1,0,0,'false','false','true','false','C4Item','none'),
(7596,'Sorcery Ingredient','false','quest',0,'stackable','paper','none',-1,0,0,'false','false','true','false','C4Item','none'),
(7597,'Malruk Succubus Claw','false','quest',0,'stackable','paper','none',-1,0,0,'false','false','true','false','C4Item','none'),
(7598,'Crimson Moss','false','quest',0,'stackable','paper','none',-1,0,0,'false','false','true','false','C4Item','none'),
(7599,'Rahorakti\'s Miraculous Medicine','false','quest',0,'stackable','paper','none',-1,0,0,'false','false','true','false','C4Item','none'),
(7600,'Worn Tarot Card - Wealth','false','quest',0,'stackable','paper','none',-1,0,0,'false','false','true','false','C4Item','none'),
(7601,'Worn Tarot Card - Power','false','quest',0,'stackable','paper','none',-1,0,0,'false','false','true','false','C4Item','none'),
(7602,'Worn Tarot Card - Love','false','quest',0,'stackable','paper','none',-1,0,0,'false','false','true','false','C4Item','none'),
(7603,'Worn Tarot Card - Knowledge','false','quest',0,'stackable','paper','none',-1,0,0,'false','false','true','false','C4Item','none'),
(7604,'Summoner Keats'' Letter','false','quest',0,'stackable','paper','none',-1,0,0,'false','false','true','false','C4Item','none'),
(7605,'Miracle Potion of Transferred Life','false','quest',0,'stackable','paper','none',-1,0,0,'false','false','true','false','C4Item','none'),
(7606,'Kamilen\'s Antidote','false','quest',0,'stackable','paper','none',-1,0,0,'false','false','true','false','C4Item','none'),
(7607,'Coolant of the Repaired Wilma #3','false','quest',0,'stackable','paper','none',-1,0,0,'false','false','true','false','C4Item','none'),
(7608,'Sealed Envelope','false','quest',0,'stackable','paper','none',-1,0,0,'false','false','true','false','C4Item','none'),
(7609,'Proof of Catching a Fish','false','none',0,'stackable','paper','none',-1,500,0,'true','true','true','true','C4Item','none'),
(7610,'Wind Fishing Lure','false','lure',1,'stackable','paper','none',-1,0,0,'true','true','true','true','C4Item','none'),
(7611,'Icy Air Fishing Lure','false','lure',1,'stackable','paper','none',-1,0,0,'true','true','true','true','C4Item','none'),
(7612,'Earth Fishing Lure','false','lure',1,'stackable','paper','none',-1,0,0,'true','true','true','true','C4Item','none'),
(7613,'Flaming Fishing Lure','false','lure',1,'stackable','paper','none',-1,0,0,'true','true','true','true','C4Item','none'),
(7614,'Chest Caught by Wind Fishing Lure','false','none',1,'stackable','paper','none',-1,0,0,'true','true','true','true','C4Item','none'),
(7615,'Chest Caught by Icy Air Fishing Lure','false','none',1,'stackable','paper','none',-1,0,0,'true','true','true','true','C4Item','none'),
(7616,'Chest Caught by Earth Fishing Lure','false','none',1,'stackable','paper','none',-1,0,0,'true','true','true','true','C4Item','none'),
(7617,'Chest Caught by using a Flaming Fishing Lure','false','none',1,'stackable','paper','none',-1,0,0,'true','true','true','true','C4Item','none'),
(7618,'Scroll of Escape: Ketra Orc Village','false','none',30,'stackable','paper','none',-1,400,0,'true','true','true','true','C4Item','none'),
(7619,'Scroll of Escape: Varka Silenos Village','false','none',30,'stackable','paper','none',-1,400,0,'true','true','true','true','C4Item','none'),
(7620,'Trash','false','quest',0,'stackable','paper','none',-1,0,0,'false','false','true','false','C4Item','none'),
(7621,'Essence of Wind','false','quest',0,'stackable','paper','none',-1,0,0,'false','false','true','false','C4Item','none'),
(7622,'Lost Bait Ingredient','false','quest',0,'stackable','paper','none',-1,0,0,'false','false','true','false','C4Item','none'),
(7623,'Eye of Tarlk Basilisk','false','quest',0,'stackable','paper','none',-1,0,0,'false','false','true','false','C4Item','none'),
(7624,'Crimson Drake Heart','false','quest',0,'stackable','paper','none',-1,0,0,'false','false','true','false','C4Item','none'),
(7625,'Strange Golem Blueprint','false','quest',0,'stackable','paper','none',-1,0,0,'false','false','true','false','C4Item','none'),
(7626,'Kiki\'s Letter','false','quest',0,'stackable','paper','none',-1,0,0,'false','false','true','false','C4Item','none'),
(7627,'Small Glass Box','false','quest',0,'stackable','paper','none',-1,0,0,'false','false','true','false','C4Item','none'),
(7628,'Rukal\'s Musical Score','false','quest',0,'stackable','paper','none',-1,0,0,'false','false','true','false','C4Item','none'),
(7629,'Looted Goods - White Cargo box','false','none',1,'stackable','paper','none',-1,0,0,'true','true','true','true','C4Item','none'),
(7630,'Looted Goods - Blue Cargo box','false','none',1,'stackable','paper','none',-1,0,0,'true','true','true','true','C4Item','none'),
(7631,'Looted Goods - Yellow Cargo box','false','none',1,'stackable','paper','none',-1,0,0,'true','true','true','true','C4Item','none'),
(7632,'Looted Goods - Red Filing Cabinet','false','none',1,'stackable','paper','none',-1,0,0,'true','true','true','true','C4Item','none'),
(7633,'Looted Goods - Purple Filing Cabinet','false','none',1,'stackable','paper','none',-1,0,0,'true','true','true','true','C4Item','none'),
(7634,'Looted Goods - Brown Pouch','false','none',1,'stackable','paper','none',-1,0,0,'true','true','true','true','C4Item','none'),
(7635,'Looted Goods - Gray Pouch','false','none',1,'stackable','paper','none',-1,0,0,'true','true','true','true','C4Item','none'),
(7636,'Booty - Yellow Pouch','false','none',1,'stackable','paper','none',-1,0,0,'true','true','true','true','C4Item','none'),
(7637,'Booty - Brown Pouch','false','none',1,'stackable','paper','none',-1,0,0,'true','true','true','true','C4Item','none'),
(7638,'Spellbook - Mass Summon Storm Cubic','false','spellbook',120,'stackable','paper','none',-1,3200,0,'true','true','true','true','C4Item','none'),
(7639,'Spellbook - Mass Summon Aqua Cubic','false','spellbook',120,'stackable','paper','none',-1,3200,0,'true','true','true','true','C4Item','none'),
(7640,'Spellbook - Mass Summon Phantom Cubic','false','spellbook',120,'stackable','paper','none',-1,3200,0,'true','true','true','true','C4Item','none'),
(7641,'Spellbook - Summon Feline Queen','false','spellbook',120,'stackable','paper','none',-1,3200,0,'true','true','true','true','C4Item','none'),
(7642,'Spellbook - Summon Unicorn Seraphim','false','spellbook',120,'stackable','paper','none',-1,3200,0,'true','true','true','true','C4Item','none'),
(7643,'Spellbook - Summon Nightshade','false','spellbook',120,'stackable','paper','none',-1,3200,0,'true','true','true','true','C4Item','none'),
(7644,'Spellbook - Summon Cursed Man','false','spellbook',120,'stackable','paper','none',-1,3200,0,'true','true','true','true','C4Item','none'),
(7645,'Spellbook - Balance Life','false','spellbook',120,'stackable','paper','none',-1,11600,0,'true','true','true','true','C4Item','none'),
(7646,'Spellbook - Curse of Doom','false','spellbook',120,'stackable','paper','none',-1,11600,0,'true','true','true','true','C4Item','none'),
(7647,'Spellbook - Curse of Abyss','false','spellbook',120,'stackable','paper','none',-1,11600,0,'true','true','true','true','C4Item','none'),
(7648,'Spellbook - Arcane Chaos','false','spellbook',120,'stackable','paper','none',-1,11600,0,'true','true','true','true','C4Item','none'),
(7649,'Spellbook - Fire Vortex','false','spellbook',120,'stackable','paper','none',-1,11600,0,'true','true','true','true','C4Item','none'),
(7650,'Spellbook - Ice Vortex','false','spellbook',120,'stackable','paper','none',-1,11600,0,'true','true','true','true','C4Item','none'),
(7651,'Spellbook - Wind Vortex','false','spellbook',120,'stackable','paper','none',-1,11600,0,'true','true','true','true','C4Item','none'),
(7652,'Spellbook - Light Vortex','false','spellbook',120,'stackable','paper','none',-1,11600,0,'true','true','true','true','C4Item','none'),
(7653,'Spellbook - Dark Vortex','false','spellbook',120,'stackable','paper','none',-1,11600,0,'true','true','true','true','C4Item','none'),
(7654,'Spellbook - Mass Warrior Bane','false','spellbook',120,'stackable','paper','none',-1,11600,0,'true','true','true','true','C4Item','none'),
(7655,'Spellbook - Mass Mage Bane','false','spellbook',120,'stackable','paper','none',-1,11600,0,'true','true','true','true','C4Item','none'),
(7656,'Spellbook - Warrior Servitor','false','spellbook',120,'stackable','paper','none',-1,11600,0,'true','true','true','true','C4Item','none'),
(7657,'Spellbook - Wizard Servitor','false','spellbook',120,'stackable','paper','none',-1,11600,0,'true','true','true','true','C4Item','none'),
(7658,'Spellbook - Assassin Servitor','false','spellbook',120,'stackable','paper','none',-1,11600,0,'true','true','true','true','C4Item','none'),
(7659,'Spellbook - Final Servitor','false','spellbook',120,'stackable','paper','none',-1,11600,0,'true','true','true','true','C4Item','none'),
(7660,'Spellbook - Warrior Bane','false','spellbook',120,'stackable','paper','none',-1,11600,0,'true','true','true','true','C4Item','none'),
(7661,'Spellbook - Mage Bane','false','spellbook',120,'stackable','paper','none',-1,11600,0,'true','true','true','true','C4Item','none'),
(7662,'Spellbook - Elemental Protection','false','spellbook',120,'stackable','paper','none',-1,11600,0,'true','true','true','true','C4Item','none'),
(7663,'Spellbook - Divine Protection','false','spellbook',120,'stackable','paper','none',-1,11600,0,'true','true','true','true','C4Item','none'),
(7664,'Spellbook - Arcane Protection','false','spellbook',120,'stackable','paper','none',-1,11600,0,'true','true','true','true','C4Item','none'),
(7665,'Spellbook - Prophecy of Water','false','spellbook',120,'stackable','paper','none',-1,11600,0,'true','true','true','true','C4Item','none'),
(7666,'Spellbook - Prophecy of Fire','false','spellbook',120,'stackable','paper','none',-1,11600,0,'true','true','true','true','C4Item','none'),
(7667,'Spellbook - Prophecy of Wind','false','spellbook',120,'stackable','paper','none',-1,11600,0,'true','true','true','true','C4Item','none'),
(7668,'Spellbook - Block Shield','false','spellbook',120,'stackable','paper','none',-1,11600,0,'true','true','true','true','C4Item','none'),
(7669,'Spellbook - Block Wind Walk','false','spellbook',120,'stackable','paper','none',-1,11600,0,'true','true','true','true','C4Item','none'),
(7670,'Spellbook - Mass Block Shield','false','spellbook',120,'stackable','paper','none',-1,11600,0,'true','true','true','true','C4Item','none'),
(7671,'Spellbook - Mass Block Wind Walk','false','spellbook',120,'stackable','paper','none',-1,11600,0,'true','true','true','true','C4Item','none'),
(7672,'Amulet - Chant of Spirit','false','spellbook',120,'stackable','paper','none',-1,11600,0,'true','true','true','true','C4Item','none'),
(7673,'Amulet - Chant of Victory','false','spellbook',120,'stackable','paper','none',-1,11600,0,'true','true','true','true','C4Item','none'),
(7674,'Amulet - Pa''agrio\'s Eye','false','spellbook',120,'stackable','paper','none',-1,11600,0,'true','true','true','true','C4Item','none'),
(7675,'Amulet - Pa''agrio\'s Soul','false','spellbook',120,'stackable','paper','none',-1,11600,0,'true','true','true','true','C4Item','none'),
(7676,'Amulet - Seal of Despair','false','spellbook',120,'stackable','paper','none',-1,11600,0,'true','true','true','true','C4Item','none'),
(7677,'Virgil\'s Letter','false','quest',0,'stackable','paper','none',-1,0,0,'false','false','false','false','C4Item','none'),
(7678,'Caradine\'s Letter','false','quest',0,'stackable','paper','none',-1,0,0,'false','false','false','false','C4Item','none'),
(7679,'Caradine\'s Letter','false','quest',0,'stackable','paper','none',-1,0,0,'false','false','false','false','C4Item','none'),
(7684,'Raccoon Ears Fabric','false','material',60,'stackable','liquid','none',-1,5000,0,'true','true','true','true','C4Item','none'),
(7685,'Outlaw\'s Eyepatch Strap','false','material',60,'stackable','liquid','none',-1,5000,0,'true','true','true','true','C4Item','none'),
(7686,'Maiden\'s Hairpin Piece','false','material',60,'stackable','liquid','none',-1,5000,0,'true','true','true','true','C4Item','none'),
(7687,'Rabbit Ears Fabric','false','material',60,'stackable','liquid','none',-1,5000,0,'true','true','true','true','C4Item','none'),
(7688,'Cat Ears Fabric','false','material',60,'stackable','liquid','none',-1,5000,0,'true','true','true','true','C4Item','none'),
(7689,'Recipe - Raccoon Ears (100%)','false','recipe',30,'stackable','paper','none',-1,50000,0,'true','true','true','true','C4Item','none'),
(7690,'Recipe - Outlaw\'s Eyepatch (100%)','false','recipe',30,'stackable','paper','none',-1,100000,0,'true','true','true','true','C4Item','none'),
(7691,'Recipe - Maiden\'s Hairpin (100%)','false','recipe',30,'stackable','paper','none',-1,100000,0,'true','true','true','true','C4Item','none'),
(7692,'Recipe - Rabbit Ears (100%)','false','recipe',30,'stackable','paper','none',-1,50000,0,'true','true','true','true','C4Item','none'),
(7693,'Recipe - Cat Ears (100%)','false','recipe',30,'stackable','paper','none',-1,50000,0,'true','true','true','true','C4Item','none'),
(7697,'Piece of Forget-me-not Hairpin','false','material',60,'stackable','liquid','none',-1,5000,0,'true','true','true','true','C4Item','none'),
(7698,'Piece of Daisy Hairpin','false','material',60,'stackable','liquid','none',-1,5000,0,'true','true','true','true','C4Item','none'),
(7699,'Recipe: Forget-me-not Hairpin (100%)','false','recipe',30,'stackable','paper','none',-1,100000,0,'true','true','true','true','C4Item','none'),
(7700,'Recipe: Daisy Hairpin (100%)','false','recipe',30,'stackable','paper','none',-1,100000,0,'true','true','true','true','C4Item','none'),
(7725,'Loot - Gray Pouch','false','none',1,'stackable','paper','none',-1,0,0,'true','true','true','true','C4Item','none'),
(7726,'Small Nimble Green Fish - For Beginners','false','none',100,'stackable','paper','none',-1,69,0,'true','true','true','true','C4Item','none'),
(7727,'Small Ugly Green Fish - For Beginners','false','none',100,'stackable','paper','none',-1,71,0,'true','true','true','true','C4Item','none'),
(7728,'Small Pudgy Green Fish - For Beginners','false','none',100,'stackable','paper','none',-1,77,0,'true','true','true','true','C4Item','none'),
(7729,'Nimble Green Fish - For Beginners','false','none',100,'stackable','paper','none',-1,84,0,'true','true','true','true','C4Item','none'),
(7730,'Ugly Green Fish - For Beginners','false','none',100,'stackable','paper','none',-1,94,0,'true','true','true','true','C4Item','none'),
(7731,'Pudgy Green Fish - For Beginners','false','none',100,'stackable','paper','none',-1,104,0,'true','true','true','true','C4Item','none'),
(7732,'Large Nimble Green Fish - For Beginners','false','none',100,'stackable','paper','none',-1,113,0,'true','true','true','true','C4Item','none'),
(7733,'Large Ugly Green Fish - For Beginners','false','none',100,'stackable','paper','none',-1,124,0,'true','true','true','true','C4Item','none'),
(7734,'Large Pudgy Green Fish - For Beginners','false','none',100,'stackable','paper','none',-1,133,0,'true','true','true','true','C4Item','none'),
(7735,'Small Jade Nimble Fish - For Beginners','false','none',100,'stackable','paper','none',-1,143,0,'true','true','true','true','C4Item','none'),
(7736,'Small Jade Ugly Fish - For Beginners','false','none',100,'stackable','paper','none',-1,0,0,'true','true','true','true','C4Item','none'),
(7737,'Small Jade Fat Fish - For Beginners','false','none',100,'stackable','paper','none',-1,167,0,'true','true','true','true','C4Item','none'),
(7738,'Jade Nimble Fish - For Beginners','false','none',100,'stackable','paper','none',-1,166,0,'true','true','true','true','C4Item','none'),
(7739,'Jade Ugly Fish - For Beginners','false','none',100,'stackable','paper','none',-1,165,0,'true','true','true','true','C4Item','none'),
(7740,'Jade Fat Fish - For Beginners','false','none',100,'stackable','paper','none',-1,165,0,'true','true','true','true','C4Item','none'),
(7741,'Large Jade Nimble Fish - For Beginners','false','none',100,'stackable','paper','none',-1,164,0,'true','true','true','true','C4Item','none'),
(7742,'Large Jade Ugly Fish - For Beginners','false','none',100,'stackable','paper','none',-1,164,0,'true','true','true','true','C4Item','none'),
(7743,'Large Jade Fat Fish - For Beginners','false','none',100,'stackable','paper','none',-1,0,0,'true','true','true','true','C4Item','none'),
(7744,'Small Blue Nimble Fish - For Beginners','false','none',100,'stackable','paper','none',-1,163,0,'true','true','true','true','C4Item','none'),
(7745,'Small Blue Ugly Fish - For Beginners','false','none',100,'stackable','paper','none',-1,0,0,'true','true','true','true','C4Item','none'),
(7746,'Small Blue Fat Fish - For Beginners','false','none',100,'stackable','paper','none',-1,0,0,'true','true','true','true','C4Item','none'),
(7747,'Blue Nimble Fish - For Beginners','false','none',100,'stackable','paper','none',-1,0,0,'true','true','true','true','C4Item','none'),
(7748,'Blue Ugly Fish - For Beginners','false','none',100,'stackable','paper','none',-1,0,0,'true','true','true','true','C4Item','none'),
(7749,'Blue Fat Fish - For Beginners','false','none',100,'stackable','paper','none',-1,0,0,'true','true','true','true','C4Item','none'),
(7750,'Large Blue Nimble Fish - For Beginners','false','none',100,'stackable','paper','none',-1,0,0,'true','true','true','true','C4Item','none'),
(7751,'Large Blue Ugly Fish - For Beginners','false','none',100,'stackable','paper','none',-1,0,0,'true','true','true','true','C4Item','none'),
(7752,'Large Blue Fat Fish - For Beginners','false','none',100,'stackable','paper','none',-1,0,0,'true','true','true','true','C4Item','none'),
(7753,'Small Yellow Nimble Fish - For Beginners','false','none',100,'stackable','paper','none',-1,0,0,'true','true','true','true','C4Item','none'),
(7754,'Small Yellow Ugly Fish - For Beginners','false','none',100,'stackable','paper','none',-1,0,0,'true','true','true','true','C4Item','none'),
(7755,'Small Yellow Fat Fish - For Beginners','false','none',100,'stackable','paper','none',-1,0,0,'true','true','true','true','C4Item','none'),
(7756,'Yellow Nimble Fish - For Beginners','false','none',100,'stackable','paper','none',-1,0,0,'true','true','true','true','C4Item','none'),
(7757,'Yellow Ugly Fish - For Beginners','false','none',100,'stackable','paper','none',-1,277,0,'true','true','true','true','C4Item','none'),
(7758,'Yellow Fat Fish - For Beginners','false','none',100,'stackable','paper','none',-1,0,0,'true','true','true','true','C4Item','none'),
(7759,'Large Yellow Nimble Fish - For Beginners','false','none',100,'stackable','paper','none',-1,0,0,'true','true','true','true','C4Item','none'),
(7760,'Large Yellow Ugly Fish - For Beginners','false','none',100,'stackable','paper','none',-1,0,0,'true','true','true','true','C4Item','none'),
(7761,'Large Yellow Fat Fish - For Beginners','false','none',100,'stackable','paper','none',-1,0,0,'true','true','true','true','C4Item','none'),
(7762,'Small Orange Nimble Fish - For Beginners','false','none',100,'stackable','paper','none',-1,0,0,'true','true','true','true','C4Item','none'),
(7763,'Small Orange Ugly Fish - For Beginners','false','none',100,'stackable','paper','none',-1,0,0,'true','true','true','true','C4Item','none'),
(7764,'Small Orange Fat Fish - For Beginners','false','none',100,'stackable','paper','none',-1,0,0,'true','true','true','true','C4Item','none'),
(7765,'Orange Nimble Fish - For Beginners','false','none',100,'stackable','paper','none',-1,0,0,'true','true','true','true','C4Item','none'),
(7766,'Orange Ugly Fish - For Beginners','false','none',100,'stackable','paper','none',-1,0,0,'true','true','true','true','C4Item','none'),
(7767,'Orange Fat Fish - For Beginners','false','none',100,'stackable','paper','none',-1,0,0,'true','true','true','true','C4Item','none'),
(7768,'Large Orange Nimble Fish - For Beginners','false','none',100,'stackable','paper','none',-1,0,0,'true','true','true','true','C4Item','none'),
(7769,'Large Orange Ugly Fish - For Beginners','false','none',100,'stackable','paper','none',-1,0,0,'true','true','true','true','C4Item','none'),
(7770,'Large Orange Fat Fish - For Beginners','false','none',100,'stackable','paper','none',-1,0,0,'true','true','true','true','C4Item','none'),
(7771,'Small Purple Nimble Fish - For Beginners','false','none',100,'stackable','paper','none',-1,0,0,'true','true','true','true','C4Item','none'),
(7772,'Small Purple Ugly Fish - For Beginners','false','none',100,'stackable','paper','none',-1,0,0,'true','true','true','true','C4Item','none'),
(7773,'Small Purple Fat Fish - For Beginners','false','none',100,'stackable','paper','none',-1,455,0,'true','true','true','true','C4Item','none'),
(7774,'Purple Nimble Fish - For Beginners','false','none',100,'stackable','paper','none',-1,0,0,'true','true','true','true','C4Item','none'),
(7775,'Purple Ugly Fish - For Beginners','false','none',100,'stackable','paper','none',-1,0,0,'true','true','true','true','C4Item','none'),
(7776,'Purple Fat Fish - For Beginners','false','none',100,'stackable','paper','none',-1,0,0,'true','true','true','true','C4Item','none'),
(7777,'Large Purple Nimble Fish - For Beginners','false','none',100,'stackable','paper','none',-1,0,0,'true','true','true','true','C4Item','none'),
(7778,'Large Purple Ugly Fish - For Beginners','false','none',100,'stackable','paper','none',-1,0,0,'true','true','true','true','C4Item','none'),
(7779,'Large Purple Fat Fish - For Beginners','false','none',100,'stackable','paper','none',-1,0,0,'true','true','true','true','C4Item','none'),
(7780,'Small Red Nimble Fish - For Beginners','false','none',100,'stackable','paper','none',-1,0,0,'true','true','true','true','C4Item','none');
INSERT INTO `etcitem` VALUES 
(7781,'Small Red Ugly Fish - For Beginners','false','none',100,'stackable','paper','none',-1,0,0,'true','true','true','true','C4Item','none'),
(7782,'Small Red Fat Fish - For Beginners','false','none',100,'stackable','paper','none',-1,0,0,'true','true','true','true','C4Item','none'),
(7783,'Red Nimble Fish - For Beginners','false','none',100,'stackable','paper','none',-1,0,0,'true','true','true','true','C4Item','none'),
(7784,'Red Ugly Fish - For Beginners','false','none',100,'stackable','paper','none',-1,0,0,'true','true','true','true','C4Item','none'),
(7785,'Red Fat Fish - For Beginners','false','none',100,'stackable','paper','none',-1,0,0,'true','true','true','true','C4Item','none'),
(7786,'Large Red Nimble Fish - For Beginners','false','none',100,'stackable','paper','none',-1,0,0,'true','true','true','true','C4Item','none'),
(7787,'Large Red Ugly Fish - For Beginners','false','none',100,'stackable','paper','none',-1,0,0,'true','true','true','true','C4Item','none'),
(7788,'Large Red Fat Fish - For Beginners','false','none',100,'stackable','paper','none',-1,0,0,'true','true','true','true','C4Item','none'),
(7789,'Small White Nimble Fish - For Beginners','false','none',100,'stackable','paper','none',-1,0,0,'true','true','true','true','C4Item','none'),
(7790,'Small White Ugly Fish - For Beginners','false','none',100,'stackable','paper','none',-1,0,0,'true','true','true','true','C4Item','none'),
(7791,'Small White Fat Fish - For Beginners','false','none',100,'stackable','paper','none',-1,0,0,'true','true','true','true','C4Item','none'),
(7792,'White Nimble Fish - For Beginners','false','none',100,'stackable','paper','none',-1,0,0,'true','true','true','true','C4Item','none'),
(7793,'White Ugly Fish - For Beginners','false','none',100,'stackable','paper','none',-1,0,0,'true','true','true','true','C4Item','none'),
(7794,'White Fat Fish - For Beginners','false','none',100,'stackable','paper','none',-1,0,0,'true','true','true','true','C4Item','none'),
(7795,'Large White Nimble Fish - For Beginners','false','none',100,'stackable','paper','none',-1,0,0,'true','true','true','true','C4Item','none'),
(7796,'Large White Ugly Fish - For Beginners','false','none',100,'stackable','paper','none',-1,0,0,'true','true','true','true','C4Item','none'),
(7797,'Large White Fat Fish - For Beginners','false','none',100,'stackable','paper','none',-1,0,0,'true','true','true','true','C4Item','none'),
(7798,'Small Black Nimble Fish: For Beginners','false','none',100,'stackable','paper','none',-1,0,0,'true','true','true','true','C4Item','none'),
(7799,'Small Black Ugly Fish - For Beginners','false','none',100,'stackable','paper','none',-1,0,0,'true','true','true','true','C4Item','none'),
(7800,'Small Black Fat Fish - For Beginners','false','none',100,'stackable','paper','none',-1,0,0,'true','true','true','true','C4Item','none'),
(7801,'Black Nimble Fish - For Beginners','false','none',100,'stackable','paper','none',-1,0,0,'true','true','true','true','C4Item','none'),
(7802,'Black Ugly Fish - For Beginners','false','none',100,'stackable','paper','none',-1,0,0,'true','true','true','true','C4Item','none'),
(7803,'Black Fat Fish - For Beginners','false','none',100,'stackable','paper','none',-1,0,0,'true','true','true','true','C4Item','none'),
(7804,'Large Black Nimble Fish - For Beginners','false','none',100,'stackable','paper','none',-1,0,0,'true','true','true','true','C4Item','none'),
(7805,'Large Black Ugly Fish - For Beginners','false','none',100,'stackable','paper','none',-1,0,0,'true','true','true','true','C4Item','none'),
(7806,'Large Black Fat Fish - For Beginners','false','none',100,'stackable','paper','none',-1,0,0,'true','true','true','true','C4Item','none'),
(7807,'Green Colored Lure - For Beginners','false','lure',5,'stackable','liquid','none',-1,50,0,'true','true','true','true','C4Item','none'),
(7808,'Purple Colored Lure - For Beginners','false','lure',5,'stackable','liquid','none',-1,70,0,'true','true','true','true','C4Item','none'),
(7809,'Yellow Colored Lure - For Beginners','false','lure',5,'stackable','liquid','none',-1,60,0,'true','true','true','true','C4Item','none'),
(7832,'Apprentice Adventurer\'s Weapon Exchange Coupon','false','none',1,'normal','paper','none',-1,0,0,'false','false','true','false','C4Item','none'),
(7833,'Adventurer\'s Weapon Exchange Coupon','false','none',1,'normal','paper','none',-1,0,0,'false','false','true','false','C4Item','none'),
(7835,'Amulet: Seal of Disease','false','spellbook',120,'stackable','paper','none',-1,11600,0,'true','true','true','true','C4Item','none'),
(7838,'Santa\'s Hat','false','none',10,'normal','paper','none',-1,0,0,'true','false','true','true','C4Item','none'),
(7904,'Boat Ticket: Rune to Gludin','false','none',20,'stackable','paper','none',-1,0,0,'true','true','true','true','C5Item','none'),
(7905,'Boat Ticket: Gludin to Rune','false','none',20,'stackable','paper','none',-1,0,0,'true','true','true','true','C5Item','none'),
(7906,'Blessing of Fire','false','none',20,'stackable','liquid','none',-1,0,0,'true','true','true','true','C5Item','none'),
(7907,'Blessing of Water','false','none',20,'stackable','liquid','none',-1,0,0,'true','true','true','true','C5Item','none'),
(7908,'Blessing of Wind','false','none',20,'stackable','liquid','none',-1,0,0,'true','true','true','true','C5Item','none'),
(7909,'Blessing of Earth','false','none',20,'stackable','liquid','none',-1,0,0,'true','true','true','true','C5Item','none'),
(7910,'Blessing of Darkness','false','none',20,'stackable','liquid','none',-1,5000,0,'true','true','true','true','C5Item','none'),
(7911,'Blessing of Sanctity','false','none',20,'stackable','liquid','none',-1,5000,0,'true','true','true','true','C5Item','none'),
(7912,'Fire Crystal','false','none',20,'stackable','liquid','none',-1,0,0,'true','true','true','true','C5Item','none'),
(7913,'Water Crystal','false','none',20,'stackable','liquid','none',-1,0,0,'true','true','true','true','C5Item','none'),
(7914,'Wind Crystal','false','none',20,'stackable','liquid','none',-1,0,0,'true','true','true','true','C5Item','none'),
(7915,'Earth Crystal','false','none',20,'stackable','liquid','none',-1,0,0,'true','true','true','true','C5Item','none'),
(7916,'Dark Crystal','false','none',20,'stackable','liquid','none',-1,3000,0,'true','true','true','true','C5Item','none'),
(7917,'Sanctity Crystal','false','castle_guard',20,'stackable','liquid','none',-1,3000,0,'true','true','true','true','C5Item','none'),
(7918,'Mercenary Posting Ticket (Sword/Stationary)','false','castle_guard',0,'stackable','paper','none',-1,0,0,'true','true','true','true','C5Item','none'),
(7919,'Mercenary Posting Ticket (Spear/Stationary)','false','castle_guard',0,'stackable','paper','none',-1,0,0,'true','true','true','true','C5Item','none'),
(7920,'Mercenary Posting Ticket (Bow/Stationary)','false','castle_guard',0,'stackable','paper','none',-1,0,0,'true','true','true','true','C5Item','none'),
(7921,'Mercenary Posting Ticket (Cleric/Stationary)','false','castle_guard',0,'stackable','paper','none',-1,0,0,'true','true','true','true','C5Item','none'),
(7922,'Mercenary Posting Ticket (Wizard/Stationary)','false','castle_guard',0,'stackable','paper','none',-1,0,0,'true','true','true','true','C5Item','none'),
(7923,'Mercenary Posting Ticket (Sword/Mobile)','false','castle_guard',0,'stackable','paper','none',-1,0,0,'true','true','true','true','C5Item','none'),
(7924,'Mercenary Posting Ticket (Spear/Mobile)','false','castle_guard',0,'stackable','paper','none',-1,0,0,'true','true','true','true','C5Item','none'),
(7925,'Mercenary Posting Ticket (Bow/Mobile)','false','castle_guard',0,'stackable','paper','none',-1,0,0,'true','true','true','true','C5Item','none'),
(7926,'Mercenary Posting Ticket (Cleric/Mobile)','false','castle_guard',0,'stackable','paper','none',-1,0,0,'true','true','true','true','C5Item','none'),
(7927,'Mercenary Posting Ticket (Wizard/Mobile)','false','castle_guard',0,'stackable','paper','none',-1,0,0,'true','true','true','true','C5Item','none'),
(7928,'Mercenary Posting Ticket (Teleporter1)','false','castle_guard',0,'stackable','paper','none',-1,0,0,'true','true','true','true','C5Item','none'),
(7929,'Mercenary Posting Ticket (Teleporter2)','false','castle_guard',0,'stackable','paper','none',-1,0,0,'true','true','true','true','C5Item','none'),
(7930,'Mercenary Posting Ticket (Teleporter3)','false','castle_guard',0,'stackable','paper','none',-1,0,0,'true','true','true','true','C5Item','none'),
(7931,'Greater Mercenary Posting Ticket (Sword/Stationary)','false','castle_guard',0,'stackable','paper','none',-1,0,0,'true','true','true','true','C5Item','none'),
(7932,'Greater Mercenary Posting Ticket (Spear/Stationary)','false','castle_guard',0,'stackable','paper','none',-1,0,0,'true','true','true','true','C5Item','none'),
(7933,'Greater Mercenary Posting Ticket (Bow/Stationary)','false','castle_guard',0,'stackable','paper','none',-1,0,0,'true','true','true','true','C5Item','none'),
(7934,'Greater Mercenary Posting Ticket (Cleric/Stationary)','false','castle_guard',0,'stackable','paper','none',-1,0,0,'true','true','true','true','C5Item','none'),
(7935,'Greater Mercenary Posting Ticket (Wizard/Stationary)','false','castle_guard',0,'stackable','paper','none',-1,0,0,'true','true','true','true','C5Item','none'),
(7936,'Greater Mercenary Posting Ticket (Sword/Mobile)','false','castle_guard',0,'stackable','paper','none',-1,0,0,'true','true','true','true','C5Item','none'),
(7937,'Greater Mercenary Posting Ticket (Spear/Mobile)','false','castle_guard',0,'stackable','paper','none',-1,0,0,'true','true','true','true','C5Item','none'),
(7938,'Greater Mercenary Posting Ticket (Bow/Mobile)','false','castle_guard',0,'stackable','paper','none',-1,0,0,'true','true','true','true','C5Item','none'),
(7939,'Greater Mercenary Posting Ticket (Cleric/Mobile)','false','castle_guard',0,'stackable','paper','none',-1,0,0,'true','true','true','true','C5Item','none'),
(7940,'Greater Mercenary Posting Ticket (Wizard/Mobile)','false','castle_guard',0,'stackable','paper','none',-1,0,0,'true','true','true','true','C5Item','none'),
(7941,'Dawn Mercenary Posting Ticket (Sword/Stationary)','false','castle_guard',0,'stackable','paper','none',-1,0,0,'true','true','true','true','C5Item','none'),
(7942,'Dawn Mercenary Posting Ticket (Spear/Stationary)','false','castle_guard',0,'stackable','paper','none',-1,0,0,'true','true','true','true','C5Item','none'),
(7943,'Dawn Mercenary Posting Ticket (Bow/Stationary)','false','castle_guard',0,'stackable','paper','none',-1,0,0,'true','true','true','true','C5Item','none'),
(7944,'Dawn Mercenary Posting Ticket (Cleric/Stationary)','false','castle_guard',0,'stackable','paper','none',-1,0,0,'true','true','true','true','C5Item','none'),
(7945,'Dawn Mercenary Posting Ticket (Wizard/Stationary)','false','castle_guard',0,'stackable','paper','none',-1,0,0,'true','true','true','true','C5Item','none'),
(7946,'Dawn Mercenary Posting Ticket (Sword/Mobile)','false','castle_guard',0,'stackable','paper','none',-1,0,0,'true','true','true','true','C5Item','none'),
(7947,'Dawn Mercenary Posting Ticket (Spear/Mobile)','false','castle_guard',0,'stackable','paper','none',-1,0,0,'true','true','true','true','C5Item','none'),
(7948,'Dawn Mercenary Posting Ticket (Bow/Mobile)','false','castle_guard',0,'stackable','paper','none',-1,0,0,'true','true','true','true','C5Item','none'),
(7949,'Dawn Mercenary Posting Ticket (Cleric/Mobile)','false','castle_guard',0,'stackable','paper','none',-1,0,0,'true','true','true','true','C5Item','none'),
(7950,'Dawn Mercenary Posting Ticket (Wizard/Mobile)','false','castle_guard',0,'stackable','paper','none',-1,0,0,'true','true','true','true','C5Item','none'),
(7951,'Greater Recruit Posting Ticket (Sword/Stationary)','false','castle_guard',0,'stackable','paper','none',-1,0,0,'true','true','true','true','C5Item','none'),
(7952,'Greater Recruit Posting Ticket (Spear/Stationary)','false','castle_guard',0,'stackable','paper','none',-1,0,0,'true','true','true','true','C5Item','none'),
(7953,'Greater Recruit Posting Ticket (Bow/Stationary)','false','castle_guard',0,'stackable','paper','none',-1,0,0,'true','true','true','true','C5Item','none'),
(7954,'Greater Recruit Posting Ticket (Cleric/Stationary)','false','castle_guard',0,'stackable','paper','none',-1,0,0,'true','true','true','true','C5Item','none'),
(7955,'Greater Recruit Posting Ticket (Wizard/Stationary)','false','castle_guard',0,'stackable','paper','none',-1,0,0,'true','true','true','true','C5Item','none'),
(7956,'Greater Recruit Posting Ticket (Sword/Mobile)','false','castle_guard',0,'stackable','paper','none',-1,0,0,'true','true','true','true','C5Item','none'),
(7957,'Greater Recruit Posting Ticket (Spear/Mobile)','false','castle_guard',0,'stackable','paper','none',-1,0,0,'true','true','true','true','C5Item','none'),
(7958,'Greater Recruit Posting Ticket (Bow/Mobile)','false','castle_guard',0,'stackable','paper','none',-1,0,0,'true','true','true','true','C5Item','none'),
(7959,'Greater Recruit Posting Ticket (Cleric/Mobile)','false','castle_guard',0,'stackable','paper','none',-1,0,0,'true','true','true','true','C5Item','none'),
(7960,'Greater Recruit Posting Ticket (Wizard/Mobile)','false','castle_guard',0,'stackable','paper','none',-1,0,0,'true','true','true','true','C5Item','none'),
(7961,'Recruit Posting Ticket (Sword/Stationary)','false','castle_guard',0,'stackable','paper','none',-1,0,0,'true','true','true','true','C5Item','none'),
(7962,'Recruit Posting Ticket (Spear/Stationary)','false','castle_guard',0,'stackable','paper','none',-1,0,0,'true','true','true','true','C5Item','none'),
(7963,'Recruit Posting Ticket (Bow/Stationary)','false','castle_guard',0,'stackable','paper','none',-1,0,0,'true','true','true','true','C5Item','none'),
(7964,'Recruit Posting Ticket (Cleric/Stationary)','false','castle_guard',0,'stackable','paper','none',-1,0,0,'true','true','true','true','C5Item','none'),
(7965,'Recruit Posting Ticket (Wizard/Stationary)','false','castle_guard',0,'stackable','paper','none',-1,0,0,'true','true','true','true','C5Item','none'),
(7966,'Recruit Posting Ticket (Sword/Mobile)','false','castle_guard',0,'stackable','paper','none',-1,0,0,'true','true','true','true','C5Item','none'),
(7967,'Recruit Posting Ticket (Spear/Mobile)','false','castle_guard',0,'stackable','paper','none',-1,0,0,'true','true','true','true','C5Item','none'),
(7968,'Recruit Posting Ticket (Bow/Mobile)','false','castle_guard',0,'stackable','paper','none',-1,0,0,'true','true','true','true','C5Item','none'),
(7969,'Recruit Posting Ticket (Cleric/Mobile)','false','castle_guard',0,'stackable','paper','none',-1,0,0,'true','true','true','true','C5Item','none'),
(7970,'Recruit Posting Ticket (Wizard/Mobile)','false','castle_guard',0,'stackable','paper','none',-1,0,0,'true','true','true','true','C5Item','none'),
(7971,'Nephilim Warrior Posting Ticket','false','castle_guard',0,'stackable','paper','none',-1,0,0,'true','true','true','true','C5Item','none'),
(7972,'Nephilim Shaman Posting Ticket','false','castle_guard',0,'stackable','paper','none',-1,0,0,'true','true','true','true','C5Item','none'),
(7973,'Mercenary Posting Ticket (Sword/Stationary)','false','castle_guard',0,'stackable','paper','none',-1,0,0,'true','true','true','true','C5Item','none'),
(7974,'Mercenary Posting Ticket (Spear/Stationary)','false','castle_guard',0,'stackable','paper','none',-1,0,0,'true','true','true','true','C5Item','none'),
(7975,'Mercenary Posting Ticket (Bow/Stationary)','false','castle_guard',0,'stackable','paper','none',-1,0,0,'true','true','true','true','C5Item','none'),
(7976,'Mercenary Posting Ticket (Cleric/Stationary)','false','castle_guard',0,'stackable','paper','none',-1,0,0,'true','true','true','true','C5Item','none'),
(7977,'Mercenary Posting Ticket (Wizard/Stationary)','false','castle_guard',0,'stackable','paper','none',-1,0,0,'true','true','true','true','C5Item','none'),
(7978,'Mercenary Posting Ticket (Sword/Mobile)','false','castle_guard',0,'stackable','paper','none',-1,0,0,'true','true','true','true','C5Item','none'),
(7979,'Mercenary Posting Ticket (Spear/Mobile)','false','castle_guard',0,'stackable','paper','none',-1,0,0,'true','true','true','true','C5Item','none'),
(7980,'Mercenary Posting Ticket (Bow/Mobile)','false','castle_guard',0,'stackable','paper','none',-1,0,0,'true','true','true','true','C5Item','none'),
(7981,'Mercenary Posting Ticket (Cleric/Mobile)','false','castle_guard',0,'stackable','paper','none',-1,0,0,'true','true','true','true','C5Item','none'),
(7982,'Mercenary Posting Ticket (Wizard/Mobile)','false','castle_guard',0,'stackable','paper','none',-1,0,0,'true','true','true','true','C5Item','none'),
(7983,'Mercenary Posting Ticket (Teleporter1)','false','castle_guard',0,'stackable','paper','none',-1,0,0,'true','true','true','true','C5Item','none'),
(7984,'Mercenary Posting Ticket (Teleporter2)','false','castle_guard',0,'stackable','paper','none',-1,0,0,'true','true','true','true','C5Item','none'),
(7985,'Mercenary Posting Ticket (Teleporter3)','false','castle_guard',0,'stackable','paper','none',-1,0,0,'true','true','true','true','C5Item','none'),
(7986,'Mercenary Posting Ticket (Teleporter4)','false','castle_guard',0,'stackable','paper','none',-1,0,0,'true','true','true','true','C5Item','none'),
(7987,'Mercenary Posting Ticket (Teleporter5)','false','castle_guard',0,'stackable','paper','none',-1,0,0,'true','true','true','true','C5Item','none'),
(7988,'Greater Mercenary Posting Ticket (Sword/Stationary)','false','castle_guard',0,'stackable','paper','none',-1,0,0,'true','true','true','true','C5Item','none'),
(7989,'Greater Mercenary Posting Ticket (Spear/Stationary)','false','castle_guard',0,'stackable','paper','none',-1,0,0,'true','true','true','true','C5Item','none'),
(7990,'Greater Mercenary Posting Ticket (Bow/Stationary)','false','castle_guard',0,'stackable','paper','none',-1,0,0,'true','true','true','true','C5Item','none'),
(7991,'Greater Mercenary Posting Ticket (Cleric/Stationary)','false','castle_guard',0,'stackable','paper','none',-1,0,0,'true','true','true','true','C5Item','none'),
(7992,'Greater Mercenary Posting Ticket (Wizard/Stationary)','false','castle_guard',0,'stackable','paper','none',-1,0,0,'true','true','true','true','C5Item','none'),
(7993,'Greater Mercenary Posting Ticket (Sword/Mobile)','false','castle_guard',0,'stackable','paper','none',-1,0,0,'true','true','true','true','C5Item','none'),
(7994,'Greater Mercenary Posting Ticket (Spear/Mobile)','false','castle_guard',0,'stackable','paper','none',-1,0,0,'true','true','true','true','C5Item','none'),
(7995,'Greater Mercenary Posting Ticket (Bow/Mobile)','false','castle_guard',0,'stackable','paper','none',-1,0,0,'true','true','true','true','C5Item','none'),
(7996,'Greater Mercenary Posting Ticket (Cleric/Mobile)','false','castle_guard',0,'stackable','paper','none',-1,0,0,'true','true','true','true','C5Item','none'),
(7997,'Greater Mercenary Posting Ticket (Wizard/Mobile)','false','castle_guard',0,'stackable','paper','none',-1,0,0,'true','true','true','true','C5Item','none'),
(7998,'Dawn Mercenary Posting Ticket (Sword/Stationary)','false','castle_guard',0,'stackable','paper','none',-1,0,0,'true','true','true','true','C5Item','none'),
(7999,'Dawn Mercenary Posting Ticket (Spear/Stationary)','false','castle_guard',0,'stackable','paper','none',-1,0,0,'true','true','true','true','C5Item','none'),
(8000,'Dawn Mercenary Posting Ticket (Bow/Stationary)','false','castle_guard',0,'stackable','paper','none',-1,0,0,'true','true','true','true','C5Item','none'),
(8001,'Dawn Mercenary Posting Ticket (Cleric/Stationary)','false','castle_guard',0,'stackable','paper','none',-1,0,0,'true','true','true','true','C5Item','none'),
(8002,'Dawn Mercenary Posting Ticket (Wizard/Stationary)','false','castle_guard',0,'stackable','paper','none',-1,0,0,'true','true','true','true','C5Item','none'),
(8003,'Dawn Mercenary Posting Ticket (Sword/Mobile)','false','castle_guard',0,'stackable','paper','none',-1,0,0,'true','true','true','true','C5Item','none'),
(8004,'Dawn Mercenary Posting Ticket (Spear/Mobile)','false','castle_guard',0,'stackable','paper','none',-1,0,0,'true','true','true','true','C5Item','none'),
(8005,'Dawn Mercenary Posting Ticket (Bow/Mobile)','false','castle_guard',0,'stackable','paper','none',-1,0,0,'true','true','true','true','C5Item','none'),
(8006,'Dawn Mercenary Posting Ticket (Cleric/Mobile)','false','castle_guard',0,'stackable','paper','none',-1,0,0,'true','true','true','true','C5Item','none'),
(8007,'Dawn Mercenary Posting Ticket (Wizard/Mobile)','false','castle_guard',0,'stackable','paper','none',-1,0,0,'true','true','true','true','C5Item','none'),
(8008,'Greater Recruit Posting Ticket (Sword/Stationary)','false','castle_guard',0,'stackable','paper','none',-1,0,0,'true','true','true','true','C5Item','none'),
(8009,'Greater Recruit Posting Ticket (Spear/Stationary)','false','castle_guard',0,'stackable','paper','none',-1,0,0,'true','true','true','true','C5Item','none'),
(8010,'Greater Recruit Posting Ticket (Bow/Stationary)','false','castle_guard',0,'stackable','paper','none',-1,0,0,'true','true','true','true','C5Item','none'),
(8011,'Greater Recruit Posting Ticket (Cleric/Stationary)','false','castle_guard',0,'stackable','paper','none',-1,0,0,'true','true','true','true','C5Item','none'),
(8012,'Greater Recruit Posting Ticket (Wizard/Stationary)','false','castle_guard',0,'stackable','paper','none',-1,0,0,'true','true','true','true','C5Item','none'),
(8013,'Greater Recruit Posting Ticket (Sword/Mobile)','false','castle_guard',0,'stackable','paper','none',-1,0,0,'true','true','true','true','C5Item','none'),
(8014,'Greater Recruit Posting Ticket (Spear/Mobile)','false','castle_guard',0,'stackable','paper','none',-1,0,0,'true','true','true','true','C5Item','none'),
(8015,'Greater Recruit Posting Ticket (Bow/Mobile)','false','castle_guard',0,'stackable','paper','none',-1,0,0,'true','true','true','true','C5Item','none'),
(8016,'Greater Recruit Posting Ticket (Cleric/Mobile)','false','castle_guard',0,'stackable','paper','none',-1,0,0,'true','true','true','true','C5Item','none'),
(8017,'Greater Recruit Posting Ticket (Wizard/Mobile)','false','castle_guard',0,'stackable','paper','none',-1,0,0,'true','true','true','true','C5Item','none'),
(8018,'Recruit Posting Ticket (Sword/Stationary)','false','castle_guard',0,'stackable','paper','none',-1,0,0,'true','true','true','true','C5Item','none'),
(8019,'Recruit Posting Ticket (Spear/Stationary)','false','castle_guard',0,'stackable','paper','none',-1,0,0,'true','true','true','true','C5Item','none'),
(8020,'Recruit Posting Ticket (Bow/Stationary)','false','castle_guard',0,'stackable','paper','none',-1,0,0,'true','true','true','true','C5Item','none'),
(8021,'Recruit Posting Ticket (Cleric/Stationary)','false','castle_guard',0,'stackable','paper','none',-1,0,0,'true','true','true','true','C5Item','none'),
(8022,'Recruit Posting Ticket (Wizard/Stationary)','false','castle_guard',0,'stackable','paper','none',-1,0,0,'true','true','true','true','C5Item','none'),
(8023,'Recruit Posting Ticket (Sword/Mobile)','false','castle_guard',0,'stackable','paper','none',-1,0,0,'true','true','true','true','C5Item','none'),
(8024,'Recruit Posting Ticket (Spear/Mobile)','false','castle_guard',0,'stackable','paper','none',-1,0,0,'true','true','true','true','C5Item','none'),
(8025,'Recruit Posting Ticket (Bow/Mobile)','false','castle_guard',0,'stackable','paper','none',-1,0,0,'true','true','true','true','C5Item','none'),
(8026,'Recruit Posting Ticket (Cleric/Mobile)','false','castle_guard',0,'stackable','paper','none',-1,0,0,'true','true','true','true','C5Item','none'),
(8027,'Recruit Posting Ticket (Wizard/Mobile)','false','castle_guard',0,'stackable','paper','none',-1,0,0,'true','true','true','true','C5Item','none'),
(8028,'Nephilim Warrior Posting Ticket','false','castle_guard',0,'stackable','paper','none',-1,0,0,'true','true','true','true','C5Item','none'),
(8029,'Nephilim Shaman Posting Ticket','false','none',0,'stackable','paper','none',-1,0,0,'true','true','true','true','C5Item','none'),
(8030,'Hot Spring Nectar','false','quest',0,'stackable','steel','none',-1,0,0,'false','false','true','false','C5Item','none'),
(8031,'Hot Spring Mineral Water','false','none',0,'stackable','steel','none',-1,0,0,'false','false','true','false','C5Item','none'),
(8032,'Hot Spring Water','false','quest',0,'stackable','steel','none',-1,0,0,'false','false','true','false','C5Item','none'),
(8033,'Hot Spring Sulfur','false','quest',0,'stackable','steel','none',-1,0,0,'false','false','true','false','C5Item','none'),
(8034,'Rainbow Springs Clan Hall War Decree','false','none',0,'stackable','steel','none',-1,0,0,'true','true','true','true','C5Item','none'),
(8035,'Hot Spring Letter A','false','none',0,'stackable','steel','none',-1,0,0,'false','false','true','false','C5Item','none'),
(8036,'Hot Spring Letter B','false','none',0,'stackable','steel','none',-1,0,0,'false','false','true','false','C5Item','none'),
(8037,'Hot Spring Letter C','false','none',0,'stackable','steel','none',-1,0,0,'false','false','true','false','C5Item','none'),
(8038,'Hot Spring Letter D','false','none',0,'stackable','steel','none',-1,0,0,'false','false','true','false','C5Item','none'),
(8039,'Hot Spring Letter E','false','none',0,'stackable','steel','none',-1,0,0,'false','false','true','false','C5Item','none'),
(8040,'Hot Spring Letter F','false','none',0,'stackable','steel','none',-1,0,0,'false','false','true','false','C5Item','none'),
(8041,'Hot Spring Letter G','false','none',0,'stackable','steel','none',-1,0,0,'false','false','true','false','C5Item','none'),
(8042,'Hot Spring Letter H','false','none',0,'stackable','steel','none',-1,0,0,'false','false','true','false','C5Item','none'),
(8043,'Hot Spring Letter I','false','none',0,'stackable','steel','none',-1,0,0,'false','false','true','false','C5Item','none'),
(8044,'Hot Spring Letter J','false','none',0,'stackable','steel','none',-1,0,0,'false','false','true','false','C5Item','none'),
(8045,'Hot Spring Letter K','false','none',0,'stackable','steel','none',-1,0,0,'false','false','true','false','C5Item','none'),
(8046,'Hot Spring Letter L','false','none',0,'stackable','steel','none',-1,0,0,'false','false','true','false','C5Item','none'),
(8047,'Hot Spring Letter N','false','none',0,'stackable','steel','none',-1,0,0,'false','false','true','false','C5Item','none'),
(8048,'Hot Spring Letter O','false','none',0,'stackable','steel','none',-1,0,0,'false','false','true','false','C5Item','none'),
(8049,'Hot Spring Letter P','false','none',0,'stackable','steel','none',-1,0,0,'false','false','true','false','C5Item','none'),
(8050,'Hot Spring Letter R','false','none',0,'stackable','steel','none',-1,0,0,'false','false','true','false','C5Item','none'),
(8051,'Hot Spring Letter S','false','none',0,'stackable','steel','none',-1,0,0,'false','false','true','false','C5Item','none'),
(8052,'Hot Spring letter T','false','none',0,'stackable','steel','none',-1,0,0,'false','false','true','false','C5Item','none'),
(8053,'Hot Spring Letter U','false','none',0,'stackable','steel','none',-1,0,0,'false','false','true','false','C5Item','none'),
(8054,'Hot Spring Letter W','false','none',0,'stackable','steel','none',-1,0,0,'false','false','true','false','C5Item','none'),
(8055,'Hot Spring Letter Y','false','none',0,'stackable','steel','none',-1,0,0,'false','false','true','false','C5Item','none'),
(8056,'Key of Splendor Room','false','quest',0,'stackable','steel','none',-1,0,0,'true','true','true','true','C5Item','none'),
(8057,'Silver Hemocyte','false','none',0,'stackable','steel','none',-1,0,0,'true','true','true','true','C5Item','none'),
(8058,'Lockup Research Report','false','quest',0,'stackable','paper','none',-1,0,0,'true','true','true','true','C5Item','none'),
(8059,'Research Report','false','quest',0,'stackable','paper','none',-1,0,0,'true','true','true','true','C5Item','none'),
(8060,'Key of Enigma','false','quest',0,'stackable','paper','none',-1,0,0,'true','true','true','true','C5Item','none'),
(8061,'Scribbled Memo','false','quest',0,'stackable','paper','none',-1,0,0,'true','true','true','true','C5Item','none'),
(8062,'Blood of Maille Lizardman','false','quest',0,'stackable','paper','none',-1,0,0,'true','true','true','true','C5Item','none'),
(8063,'Leg of King Araneid','false','quest',0,'stackable','paper','none',-1,0,0,'true','true','true','true','C5Item','none'),
(8064,'Visitor\'s Mark','false','quest',0,'stackable','paper','none',-1,0,0,'false','false','false','false','C5Item','none'),
(8065,'Faded Visitor\'s Mark','false','quest',0,'stackable','paper','none',-1,0,0,'false','false','false','false','C5Item','none'),
(8066,'Necromancer\'s Heart','false','quest',0,'stackable','paper','none',-1,0,0,'false','false','false','false','C5Item','none'),
(8067,'Pagan\'s Mark','false','quest',0,'stackable','paper','none',-1,0,0,'false','false','false','false','C5Item','none'),
(8068,'Pagan Totem','false','quest',0,'stackable','paper','none',-1,0,0,'false','false','false','false','C5Item','none'),
(8069,'Monk\'s Scripture','false','quest',0,'stackable','paper','none',-1,0,0,'true','true','true','true','C5Item','none'),
(8070,'Water Bottle','false','quest',0,'stackable','paper','none',-1,0,0,'true','true','true','true','C5Item','none'),
(8071,'Bottle of water from the Holy Grail','false','quest',0,'stackable','paper','none',-1,0,0,'true','true','true','true','C5Item','none'),
(8072,'Antelope Skin','false','quest',0,'stackable','paper','none',-1,0,0,'true','true','true','true','C5Item','none'),
(8073,'Frintezza\'s Magic Force Field Removal Scroll','false','quest',0,'stackable','paper','none',-1,0,0,'true','true','true','true','C5Item','none'),
(8074,'Watching Eyes','false','quest',0,'stackable','paper','none',-1,0,0,'true','true','true','true','C5Item','none'),
(8075,'Roughly Hewn Rock Golem Shard','false','quest',0,'stackable','paper','none',-1,0,0,'true','true','true','true','C5Item','none'),
(8076,'Delu Lizardman\'s Scale','false','quest',0,'stackable','paper','none',-1,0,0,'true','true','true','true','C5Item','none'),
(8077,'Silver Ice Crystal','false','quest',0,'stackable','paper','none',-1,0,0,'true','true','true','true','C5Item','none'),
(8078,'Black Ice Crystal','false','quest',0,'stackable','paper','none',-1,0,0,'true','true','true','true','C5Item','none'),
(8079,'Misa\'s Letter','false','quest',0,'stackable','paper','none',-1,0,0,'true','true','true','true','C5Item','none'),
(8080,'Rafforty\'s Letter','false','quest',0,'stackable','paper','none',-1,0,0,'true','true','true','true','C5Item','none'),
(8081,'Piece of Tablet','false','quest',0,'stackable','paper','none',-1,0,0,'true','true','true','true','C5Item','none'),
(8082,'Report Piece','false','quest',0,'stackable','paper','none',-1,0,0,'true','true','true','true','C5Item','none'),
(8083,'Scout\'s Memo','false','quest',0,'stackable','paper','none',-1,0,0,'true','true','true','true','C5Item','none'),
(8084,'Crystal of Purity','false','none',0,'stackable','paper','none',-1,0,0,'true','true','true','true','C5Item','none'),
(8085,'Fang of Stakato','false','none',0,'stackable','paper','none',-1,0,0,'true','true','true','true','C5Item','none'),
(8086,'Box Containing the Fire of Holy Spirit','false','quest',0,'stackable','paper','none',-1,0,0,'true','true','true','true','C5Item','none'),
(8087,'Cursed Doll','false','none',0,'stackable','paper','none',-1,0,0,'true','true','true','true','C5Item','none'),
(8088,'Orc Grave Goods','false','none',0,'stackable','paper','none',-1,0,0,'true','true','true','true','C5Item','none'),
(8089,'Cursed Grave Goods','false','none',0,'stackable','paper','none',-1,0,0,'true','true','true','true','C5Item','none'),
(8090,'Electric Wave Detector','false','none',0,'stackable','paper','none',-1,0,0,'true','true','true','true','C5Item','none'),
(8091,'Electric Wave Detector','false','none',0,'stackable','paper','none',-1,0,0,'true','true','true','true','C5Item','none'),
(8092,'Telescope Golem\'s Corpse','false','none',0,'stackable','paper','none',-1,0,0,'true','true','true','true','C5Item','none'),
(8093,'Golem\'s Dispatcher','false','none',0,'stackable','paper','none',-1,0,0,'true','true','true','true','C5Item','none'),
(8094,'Storage Medium','false','none',0,'stackable','paper','none',-1,0,0,'true','true','true','true','C5Item','none'),
(8095,'Storage Medium','false','none',0,'stackable','paper','none',-1,0,0,'true','true','true','true','C5Item','none'),
(8096,'Ginzu Golem\'s Black Box','false','none',0,'stackable','paper','none',-1,0,0,'true','true','true','true','C5Item','none'),
(8097,'X-688','false','none',0,'stackable','paper','none',-1,0,0,'true','true','true','true','C5Item','none'),
(8098,'Supplying Goods for Railroad Worker','false','none',0,'stackable','paper','none',-1,0,0,'true','true','true','true','C5Item','none'),
(8099,'Thief Guild\'s Mark','false','none',0,'stackable','paper','none',-1,0,0,'true','true','true','true','C5Item','none'),
(8100,'Destroyed Golem Shards','false','quest',0,'stackable','paper','none',-1,0,0,'false','false','true','false','C5Item','none'),
(8101,'Dwarf\'s Favor','false','none',0,'stackable','paper','none',-1,0,0,'true','true','true','true','C5Item','none'),
(8153,'Adventurer\'s Guide Book','false','none',0,'normal','paper','none',-1,2000,0,'true','true','true','true','C5Item','none'),
(8154,'Herb of Life','false','herb',0,'normal','paper','none',-1,0,0,'true','true','true','true','C5Item','none'),
(8155,'Herb of Mana','false','herb',0,'normal','paper','none',-1,0,0,'true','true','true','true','C5Item','none'),
(8156,'Herb of Power','false','herb',0,'normal','paper','none',-1,0,0,'true','true','true','true','C5Item','none'),
(8157,'Herb of Magic','false','herb',0,'normal','paper','none',-1,0,0,'true','true','true','true','C5Item','none'),
(8158,'Memento Mori: C-Grade','false','none',0,'stackable','paper','none',-1,10000,0,'true','true','true','true','C5Item','none'),
(8159,'Memento Mori: B-Grade','false','none',0,'stackable','paper','none',-1,20000,0,'true','true','true','true','C5Item','none'),
(8160,'Memento Mori: A-Grade','false','none',0,'stackable','paper','none',-1,50000,0,'true','true','true','true','C5Item','none'),
(8161,'Dragon Heart: C-Grade','false','none',0,'stackable','paper','none',-1,10000,0,'true','true','true','true','C5Item','none'),
(8162,'Dragon Heart: B-Grade','false','none',0,'stackable','paper','none',-1,20000,0,'true','true','true','true','C5Item','none'),
(8163,'Dragon Heart: A-Grade','false','none',0,'stackable','paper','none',-1,50000,0,'true','true','true','true','C5Item','none'),
(8164,'Earth Egg: C-Grade','false','none',0,'stackable','paper','none',-1,10000,0,'true','true','true','true','C5Item','none'),
(8165,'Earth Egg: B-Grade','false','none',0,'stackable','paper','none',-1,20000,0,'true','true','true','true','C5Item','none'),
(8166,'Earth Egg: A-Grade','false','none',0,'stackable','paper','none',-1,50000,0,'true','true','true','true','C5Item','none'),
(8167,'Nonliving Nucleus: C-Grade','false','none',0,'stackable','paper','none',-1,10000,0,'true','true','true','true','C5Item','none'),
(8168,'Nonliving Nucleus: B-Grade','false','none',0,'stackable','paper','none',-1,20000,0,'true','true','true','true','C5Item','none'),
(8169,'Nonliving Nucleus: A-Grade','false','none',0,'stackable','paper','none',-1,50000,0,'true','true','true','true','C5Item','none'),
(8170,'Angelic Essence: C-Grade','false','none',0,'stackable','paper','none',-1,10000,0,'true','true','true','true','C5Item','none'),
(8171,'Angelic Essence: B-Grade','false','none',0,'stackable','paper','none',-1,20000,0,'true','true','true','true','C5Item','none'),
(8172,'Angelic Essence: A-Grade','false','none',0,'stackable','paper','none',-1,50000,0,'true','true','true','true','C5Item','none'),
(8173,'Cradle of Creation: C-Grade (Not used)','false','none',0,'stackable','paper','none',-1,0,0,'true','true','true','true','C5Item','none'),
(8174,'Cradle of Creation: B-Grade (Not used)','false','none',0,'stackable','paper','none',-1,0,0,'true','true','true','true','C5Item','none'),
(8175,'Cradle of Creation','false','none',0,'stackable','paper','none',-1,50000,0,'true','true','true','true','C5Item','none'),
(8176,'Destruction Tombstone','false','none',0,'stackable','paper','none',-1,10000,0,'true','true','true','true','C5Item','none'),
(8192,'Breaking Arrow','false','none',3,'stackable','gold','none',-1,0,0,'true','true','true','true','C5Item','none'),
(8193,'Fisherman\'s Potion - Green','false','none',100,'stackable','liquid','none',-1,5000,0,'true','true','true','true','C5Item','none'),
(8194,'Fisherman\'s Potion - Jade','false','none',100,'stackable','liquid','none',-1,5000,0,'true','true','true','true','C5Item','none'),
(8195,'Fisherman\'s Potion - Blue','false','none',100,'stackable','liquid','none',-1,5000,0,'true','true','true','true','C5Item','none'),
(8196,'Fisherman\'s Potion - Yellow','false','none',100,'stackable','liquid','none',-1,5000,0,'true','true','true','true','C5Item','none'),
(8197,'Fisherman\'s Potion - Orange','false','none',100,'stackable','liquid','none',-1,5000,0,'true','true','true','true','C5Item','none'),
(8198,'Fisherman\'s Potion - Purple','false','none',100,'stackable','liquid','none',-1,5000,0,'true','true','true','true','C5Item','none'),
(8199,'Fisherman\'s Potion - Red','false','none',100,'stackable','liquid','none',-1,5000,0,'true','true','true','true','C5Item','none'),
(8200,'Fisherman\'s Potion - White','false','none',100,'stackable','liquid','none',-1,5000,0,'true','true','true','true','C5Item','none'),
(8201,'Fisherman\'s Potion - Black','false','none',100,'stackable','liquid','none',-1,0,0,'true','true','true','true','C5Item','none'),
(8202,'Fishing Potion','false','seed',100,'stackable','liquid','none',-1,5000,0,'true','true','true','true','C5Item','none'),
(8223,'Seed: Twin Codran','false','seed',1,'stackable','paper','none',-1,50,0,'true','true','true','true','C5Item','none'),
(8224,'Seed: Great Codran','false','seed',1,'stackable','paper','none',-1,75,0,'true','true','true','true','C5Item','none'),
(8225,'Seed: Desert Codran','false','seed',1,'stackable','paper','none',-1,100,0,'true','true','true','true','C5Item','none'),
(8226,'Seed: Blue Coba','false','seed',1,'stackable','paper','none',-1,400,0,'true','true','true','true','C5Item','none'),
(8227,'Seed: Red Coba','false','seed',1,'stackable','paper','none',-1,500,0,'true','true','true','true','C5Item','none'),
(8228,'Seed: Golden Coba','false','seed',1,'stackable','paper','none',-1,650,0,'true','true','true','true','C5Item','none'),
(8229,'Seed: Desert Coba','false','seed',1,'stackable','paper','none',-1,750,0,'true','true','true','true','C5Item','none'),
(8230,'Seed: Alternative Twin Codran','false','seed',1,'stackable','paper','none',-1,50,0,'true','true','true','true','C5Item','none'),
(8231,'Seed: Alternative Great Codran','false','seed',1,'stackable','paper','none',-1,75,0,'true','true','true','true','C5Item','none'),
(8232,'Seed: Alternative Desert Codran','false','seed',1,'stackable','paper','none',-1,100,0,'true','true','true','true','C5Item','none'),
(8233,'Seed: Alternative Blue Coba','false','seed',1,'stackable','paper','none',-1,400,0,'true','true','true','true','C5Item','none'),
(8234,'Seed: Alternative Red Coba','false','seed',1,'stackable','paper','none',-1,500,0,'true','true','true','true','C5Item','none'),
(8235,'Seed: Alternative Golden Coba','false','seed',1,'stackable','paper','none',-1,650,0,'true','true','true','true','C5Item','none'),
(8236,'Seed: Alternative Desert Coba','false','seed',1,'stackable','paper','none',-1,750,0,'true','true','true','true','C5Item','none'),
(8237,'Seed: Dark Coda','false','seed',1,'stackable','paper','none',-1,5,0,'true','true','true','true','C5Item','none'),
(8238,'Seed: Red Coda','false','seed',1,'stackable','paper','none',-1,5,0,'true','true','true','true','C5Item','none'),
(8239,'Seed: Chilly Coda','false','seed',1,'stackable','paper','none',-1,5,0,'true','true','true','true','C5Item','none'),
(8240,'Seed: Blue Coda','false','seed',1,'stackable','paper','none',-1,10,0,'true','true','true','true','C5Item','none'),
(8241,'Seed: Golden Coda','false','seed',1,'stackable','paper','none',-1,20,0,'true','true','true','true','C5Item','none'),
(8242,'Seed: Lute Coda','false','seed',1,'stackable','paper','none',-1,30,0,'true','true','true','true','C5Item','none'),
(8243,'Seed: Desert Coda','false','seed',1,'stackable','paper','none',-1,20,0,'true','true','true','true','C5Item','none'),
(8244,'Seed: Red Cobol','false','seed',1,'stackable','paper','none',-1,20,0,'true','true','true','true','C5Item','none'),
(8245,'Seed: Chilly Cobol','false','seed',1,'stackable','paper','none',-1,25,0,'true','true','true','true','C5Item','none'),
(8246,'Seed: Blue Cobol','false','seed',1,'stackable','paper','none',-1,50,0,'true','true','true','true','C5Item','none'),
(8247,'Seed: Thorn Cobol','false','seed',1,'stackable','paper','none',-1,50,0,'true','true','true','true','C5Item','none'),
(8248,'Seed: Golden Cobol','false','seed',1,'stackable','paper','none',-1,50,0,'true','true','true','true','C5Item','none'),
(8249,'Seed: Great Cobol','false','seed',1,'stackable','paper','none',-1,50,0,'true','true','true','true','C5Item','none'),
(8250,'Seed: Red Codran','false','seed',1,'stackable','paper','none',-1,40,0,'true','true','true','true','C5Item','none'),
(8251,'Seed: Sea Codran','false','seed',1,'stackable','paper','none',-1,50,0,'true','true','true','true','C5Item','none'),
(8252,'Seed: Chilly Codran','false','seed',1,'stackable','paper','none',-1,40,0,'true','true','true','true','C5Item','none'),
(8253,'Seed: Blue Codran','false','seed',1,'stackable','paper','none',-1,50,0,'true','true','true','true','C5Item','none'),
(8254,'Seed: Twin Codran','false','seed',1,'stackable','paper','none',-1,50,0,'true','true','true','true','C5Item','none'),
(8255,'Alternative Dark Coda Seed','false','seed',1,'stackable','paper','none',-1,5,0,'true','true','true','true','C5Item','none'),
(8256,'Alternative Red Coda Seed','false','seed',1,'stackable','paper','none',-1,5,0,'true','true','true','true','C5Item','none'),
(8257,'Seed: Alternative Chilly Coda','false','seed',1,'stackable','paper','none',-1,5,0,'true','true','true','true','C5Item','none'),
(8258,'Alternative Blue Coda Seed','false','seed',1,'stackable','paper','none',-1,10,0,'true','true','true','true','C5Item','none'),
(8259,'Seed: Alternative Golden Coda','false','seed',1,'stackable','paper','none',-1,20,0,'true','true','true','true','C5Item','none'),
(8260,'Alternative Lute Coda Seed','false','seed',1,'stackable','paper','none',-1,30,0,'true','true','true','true','C5Item','none'),
(8261,'Alternative Desert Coda Seed','false','seed',1,'stackable','paper','none',-1,20,0,'true','true','true','true','C5Item','none'),
(8262,'Seed: Alternative Red Cobol','false','seed',1,'stackable','paper','none',-1,20,0,'true','true','true','true','C5Item','none'),
(8263,'Seed: Alternative Chilly Cobol','false','seed',1,'stackable','paper','none',-1,25,0,'true','true','true','true','C5Item','none'),
(8264,'Seed: Alternative Blue Cobol','false','seed',1,'stackable','paper','none',-1,50,0,'true','true','true','true','C5Item','none'),
(8265,'Alternative Thorn Cobol Seed','false','seed',1,'stackable','paper','none',-1,50,0,'true','true','true','true','C5Item','none'),
(8266,'Seed: Alternative Golden Cobol','false','seed',1,'stackable','paper','none',-1,50,0,'true','true','true','true','C5Item','none'),
(8267,'Seed: Alternative Great Cobol','false','seed',1,'stackable','paper','none',-1,40,0,'true','true','true','true','C5Item','none'),
(8268,'Seed: Alternative Red Codran','false','seed',1,'stackable','paper','none',-1,40,0,'true','true','true','true','C5Item','none'),
(8269,'Seed: Alternative Sea Codran','false','seed',1,'stackable','paper','none',-1,50,0,'true','true','true','true','C5Item','none'),
(8270,'Seed: Alternative Chilly Codran','false','seed',1,'stackable','paper','none',-1,40,0,'true','true','true','true','C5Item','none'),
(8271,'Seed: Alternative Blue Codran','false','seed',1,'stackable','paper','none',-1,50,0,'true','true','true','true','C5Item','none'),
(8272,'Seed: Alternative Twin Codran','false','seed',1,'stackable','paper','none',-1,50,0,'true','true','true','true','C5Item','none'),
(8273,'Anteroom Key','false','none',0,'stackable','steel','none',-1,0,0,'true','true','true','true','C5Item','none'),
(8274,'Chapel Key','false','none',0,'stackable','steel','none',-1,0,0,'true','true','true','true','C5Item','none'),
(8275,'Key of Darkness','false','none',0,'stackable','steel','none',-1,0,0,'true','true','true','true','C5Item','none'),
(8276,'Sekina\'s Scale','false','quest',0,'stackable','paper','none',-1,0,0,'true','true','true','true','C5Item','none'),
(8277,'Themis'' Scale','false','quest',0,'stackable','paper','none',-1,0,0,'true','true','true','true','C5Item','none'),
(8278,'Vermilion Shard','false','quest',0,'stackable','paper','none',-1,0,0,'true','true','true','true','C5Item','none'),
(8279,'Nucleus of Hekaton Prime','false','none',0,'stackable','paper','none',-1,0,0,'true','true','true','true','C5Item','none'),
(8280,'Tiphon Shard','false','quest',0,'stackable','paper','none',-1,0,0,'true','true','true','true','C5Item','none'),
(8281,'Glaki\'s Necleus','false','quest',0,'stackable','paper','none',-1,0,0,'true','true','true','true','C5Item','none'),
(8282,'Rahha\'s Fang','false','quest',0,'stackable','paper','none',-1,0,0,'true','true','true','true','C5Item','none'),
(8283,'Sting of Giant Poison Bee','false','quest',0,'stackable','paper','none',-1,0,0,'true','true','true','true','C5Item','none'),
(8284,'Cloudy Gem','false','quest',0,'stackable','paper','none',-1,0,0,'true','true','true','true','C5Item','none'),
(8285,'Talon of Young Araneid','false','quest',0,'stackable','paper','none',-1,0,0,'true','true','true','true','C5Item','none'),
(8286,'Fairy Breath','false','quest',0,'stackable','paper','none',-1,0,0,'true','true','true','true','C5Item','none'),
(8287,'Starstone','false','quest',0,'stackable','paper','none',-1,0,0,'true','true','true','true','C5Item','none'),
(8288,'Yumi\'s Letter','false','quest',0,'stackable','paper','none',-1,0,0,'true','true','true','true','C5Item','none'),
(8289,'Starstone','false','quest',0,'stackable','paper','none',-1,0,0,'true','true','true','true','C5Item','none'),
(8290,'Flower of Pavel','false','quest',0,'stackable','paper','none',-1,0,0,'true','true','true','true','C5Item','none'),
(8291,'Heart of Atlanta','false','quest',0,'stackable','paper','none',-1,0,0,'true','true','true','true','C5Item','none'),
(8292,'Wendy\'s Necklace','false','quest',0,'stackable','paper','none',-1,0,0,'true','true','true','true','C5Item','none'),
(8293,'Trainer License','false','quest',0,'stackable','paper','none',-1,0,0,'true','true','true','true','C5Item','none'),
(8294,'Recipe: Steel Sword (100%)','false','recipe',30,'stackable','liquid','none',-1,8180,0,'true','true','true','true','C5Item','none'),
(8295,'Recipe: Titan Sword (100%)','false','recipe',30,'stackable','liquid','none',-1,28000,0,'true','true','true','true','C5Item','none'),
(8296,'Recipe: Pa''agrian Sword (100%)','false','recipe',30,'stackable','liquid','none',-1,86000,0,'true','true','true','true','C5Item','none'),
(8297,'Recipe: Guardian\'s Sword (100%)','false','recipe',30,'stackable','liquid','none',-1,262000,0,'true','true','true','true','C5Item','none'),
(8298,'Recipe: Guardian\'s Sword (60%)','false','recipe',30,'stackable','liquid','none',-1,262000,0,'true','true','true','true','C5Item','none'),
(8299,'Recipe: Infernal Master (100%)','false','recipe',30,'stackable','liquid','none',-1,366000,0,'true','true','true','true','C5Item','none'),
(8300,'Recipe: Infernal Master (60%)','false','recipe',30,'stackable','liquid','none',-1,366000,0,'true','true','true','true','C5Item','none'),
(8301,'Recipe: Priest Sword (100%)','false','recipe',30,'stackable','liquid','none',-1,28000,0,'true','true','true','true','C5Item','none'),
(8302,'Recipe: Sword of Magic Fog (100%)','false','recipe',30,'stackable','liquid','none',-1,28000,0,'true','true','true','true','C5Item','none'),
(8303,'Recipe: Mysterious Sword (100%)','false','recipe',30,'stackable','liquid','none',-1,0,0,'true','true','true','true','C5Item','none'),
(8304,'Recipe: Ecliptic Sword (100%)','false','recipe',30,'stackable','liquid','none',-1,0,0,'true','true','true','true','C5Item','none'),
(8305,'Recipe: Wizard\'s Tear (100%)','false','recipe',30,'stackable','liquid','none',-1,262000,0,'true','true','true','true','C5Item','none'),
(8306,'Recipe: Wizard\'s Tear (60%)','false','recipe',30,'stackable','liquid','none',-1,262000,0,'true','true','true','true','C5Item','none'),
(8307,'Recipe: Priest Mace (100%)','false','recipe',30,'stackable','liquid','none',-1,28000,0,'true','true','true','true','C5Item','none'),
(8308,'Recipe: Ecliptic Axe (100%)','false','recipe',30,'stackable','liquid','none',-1,122600,0,'true','true','true','true','C5Item','none'),
(8309,'Recipe: Spell Breaker (100%)','false','recipe',30,'stackable','liquid','none',-1,173600,0,'true','true','true','true','C5Item','none'),
(8310,'Recipe: Spell Breaker (60%)','false','recipe',30,'stackable','liquid','none',-1,173600,0,'true','true','true','true','C5Item','none'),
(8311,'Recipe: Kaim Vanul\'s Bones (100%)','false','recipe',30,'stackable','liquid','none',-1,262000,0,'true','true','true','true','C5Item','none'),
(8312,'Recipe: Kaim Vanul\'s Bones (60%)','false','recipe',30,'stackable','liquid','none',-1,262000,0,'true','true','true','true','C5Item','none'),
(8313,'Recipe: Spiritual Eye (100%)','false','recipe',30,'stackable','liquid','none',-1,366000,0,'true','true','true','true','C5Item','none'),
(8314,'Recipe: Spiritual Eye (60%)','false','recipe',30,'stackable','liquid','none',-1,366000,0,'true','true','true','true','C5Item','none'),
(8315,'Recipe: Flaming Dragon Skull (100%)','false','recipe',30,'stackable','liquid','none',-1,540000,0,'true','true','true','true','C5Item','none'),
(8316,'Recipe: Flaming Dragon Skull (60%)','false','recipe',30,'stackable','liquid','none',-1,540000,0,'true','true','true','true','C5Item','none'),
(8317,'Recipe: Titan Hammer (100%)','false','recipe',30,'stackable','liquid','none',-1,28000,0,'true','true','true','true','C5Item','none'),
(8318,'Recipe: Dwarven Hammer (100%)','false','recipe',30,'stackable','liquid','none',-1,122600,0,'true','true','true','true','C5Item','none'),
(8319,'Recipe: Karik Horn (100%)','false','recipe',30,'stackable','liquid','none',-1,0,0,'true','true','true','true','C5Item','none'),
(8320,'Recipe: Destroyer Hammer (100%)','false','recipe',30,'stackable','liquid','none',-1,366000,0,'true','true','true','true','C5Item','none'),
(8321,'Recipe: Ice Storm Hammer (100%)','false','recipe',30,'stackable','liquid','none',-1,173600,0,'true','true','true','true','C5Item','none'),
(8322,'Recipe: Ice Storm Hammer (60%)','false','recipe',30,'stackable','liquid','none',-1,173600,0,'true','true','true','true','C5Item','none'),
(8323,'Recipe: Star Buster (100%)','false','recipe',30,'stackable','liquid','none',-1,0,0,'true','true','true','true','C5Item','none'),
(8324,'Recipe: Star Buster (60%)','false','recipe',30,'stackable','liquid','none',-1,0,0,'true','true','true','true','C5Item','none'),
(8325,'Recipe: Doom Crusher (100%)','false','recipe',30,'stackable','liquid','none',-1,540000,0,'true','true','true','true','C5Item','none'),
(8326,'Recipe: Doom Crusher (60%)','false','recipe',30,'stackable','liquid','none',-1,540000,0,'true','true','true','true','C5Item','none'),
(8327,'Steel Sword Blade','false','material',60,'stackable','liquid','none',-1,11912,0,'true','true','true','true','C5Item','none'),
(8328,'Titan Sword Blade','false','material',60,'stackable','liquid','none',-1,20950,0,'true','true','true','true','C5Item','none'),
(8329,'Pa''agrian Sword Blade','false','material',60,'stackable','liquid','none',-1,38420,0,'true','true','true','true','C5Item','none'),
(8330,'Guardian Sword Blade','false','material',60,'stackable','liquid','none',-1,45769,0,'true','true','true','true','C5Item','none'),
(8331,'Infernal Master Blade','false','material',60,'stackable','liquid','none',-1,58615,0,'true','true','true','true','C5Item','none'),
(8332,'Priest Sword Blade','false','material',60,'stackable','liquid','none',-1,12037,0,'true','true','true','true','C5Item','none'),
(8333,'Sword of Magic Fog Blade','false','material',60,'stackable','liquid','none',-1,20300,0,'true','true','true','true','C5Item','none'),
(8334,'Mysterious Sword Blade','false','material',60,'stackable','liquid','none',-1,25187,0,'true','true','true','true','C5Item','none'),
(8335,'Ecliptic Sword Blade','false','material',60,'stackable','liquid','none',-1,43890,0,'true','true','true','true','C5Item','none'),
(8336,'Blade of the Wizard\'s Tear','false','material',60,'stackable','liquid','none',-1,45692,0,'true','true','true','true','C5Item','none'),
(8337,'Priest Mace Head','false','material',60,'stackable','liquid','none',-1,0,0,'true','true','true','true','C5Item','none'),
(8338,'Axe of Eclipse Head','false','material',60,'stackable','liquid','none',-1,41636,0,'true','true','true','true','C5Item','none'),
(8339,'Spell Breaker Head','false','material',60,'stackable','liquid','none',-1,34950,0,'true','true','true','true','C5Item','none'),
(8340,'Bones Head of Kaim Vanul','false','material',60,'stackable','liquid','none',-1,45769,0,'true','true','true','true','C5Item','none'),
(8341,'Spiritual Eye Piece','false','material',60,'stackable','liquid','none',-1,59384,0,'true','true','true','true','C5Item','none'),
(8342,'Flaming Dragon Skull Piece','false','material',60,'stackable','liquid','none',-1,72914,0,'true','true','true','true','C5Item','none'),
(8343,'Titan Hammer Piece','false','material',60,'stackable','liquid','none',-1,19757,0,'true','true','true','true','C5Item','none'),
(8344,'Dwarven Hammer Piece','false','material',60,'stackable','liquid','none',-1,0,0,'true','true','true','true','C5Item','none'),
(8345,'Karik Horn Piece','false','material',60,'stackable','liquid','none',-1,0,0,'true','true','true','true','C5Item','none'),
(8346,'Hammer Piece of Destroyer','false','material',60,'stackable','liquid','none',-1,59308,0,'true','true','true','true','C5Item','none'),
(8347,'Ice Storm Hammer Head','false','material',60,'stackable','liquid','none',-1,38867,0,'true','true','true','true','C5Item','none'),
(8348,'Star Buster Head','false','material',60,'stackable','liquid','none',-1,45846,0,'true','true','true','true','C5Item','none'),
(8349,'Doom Crusher Head','false','material',60,'stackable','liquid','none',-1,72929,0,'true','true','true','true','C5Item','none'),
(8351,'Black Colored Fish Scale','false','material',10,'stackable','liquid','none',-1,900,0,'true','true','true','true','C5Item','none'),
(8352,'Red Colored Fish Scale','false','material',10,'stackable','liquid','none',-1,700,0,'true','true','true','true','C5Item','none'),
(8353,'Green Colored Fish Scale','false','material',10,'stackable','liquid','none',-1,100,0,'true','true','true','true','C5Item','none'),
(8354,'Yellow Colored Fish Scale','false','material',10,'stackable','liquid','none',-1,400,0,'true','true','true','true','C5Item','none'),
(8355,'Blue Colored Fish Scale','false','material',10,'stackable','liquid','none',-1,300,0,'true','true','true','true','C5Item','none'),
(8356,'White Colored Fish Scale','false','material',10,'stackable','liquid','none',-1,800,0,'true','true','true','true','C5Item','none'),
(8357,'Orange Colored Fish Scale','false','material',10,'stackable','liquid','none',-1,500,0,'true','true','true','true','C5Item','none'),
(8358,'Purple Colored Fish Scale','false','material',10,'stackable','liquid','none',-1,600,0,'true','true','true','true','C5Item','none'),
(8359,'Jade Colored Fish Scale','false','none',10,'stackable','liquid','none',-1,200,0,'true','true','true','true','C5Item','none'),
(8360,'Adventurer\'s Box - C Accessory','false','none',20,'stackable','steel','none',-1,0,0,'true','true','true','true','C5Item','none'),
(8361,'Adventurer\'s Box - B Accessory','false','none',20,'stackable','steel','none',-1,0,0,'true','true','true','true','C5Item','none'),
(8362,'Adventurer\'s Box - Hair Accessory','false','none',20,'stackable','steel','none',-1,0,0,'true','true','true','true','C5Item','none'),
(8363,'Adventurer\'s Box - Cradle of Creation','false','recipe',20,'stackable','steel','none',-1,0,0,'true','true','true','true','C5Item','none'),
(8364,'Recipe: Party Hat (100%)','false','recipe',30,'stackable','paper','none',-1,400000,0,'true','true','true','true','C5Item','none'),
(8365,'Recipe: Party Hat (70%)','false','recipe',30,'stackable','paper','none',-1,400000,0,'true','true','true','true','C5Item','none'),
(8366,'Recipe: Feathered Hat (100%)','false','recipe',30,'stackable','paper','none',-1,400000,0,'true','true','true','true','C5Item','none'),
(8367,'Recipe: Feathered Hat (70%)','false','recipe',30,'stackable','paper','none',-1,400000,0,'true','true','true','true','C5Item','none'),
(8368,'Recipe: Artisan\'s Goggles (100%)','false','recipe',30,'stackable','paper','none',-1,400000,0,'true','true','true','true','C5Item','none'),
(8369,'Recipe: Artisan\'s Goggles (70%)','false','recipe',30,'stackable','paper','none',-1,400000,0,'true','true','true','true','C5Item','none'),
(8370,'Recipe: Red Horn of Victory (100%)','false','recipe',30,'stackable','paper','none',-1,0,0,'true','true','true','true','C5Item','none'),
(8371,'Recipe: Little Angel Wings (100%)','false','recipe',30,'stackable','paper','none',-1,100000,0,'true','true','true','true','C5Item','none'),
(8372,'Recipe: Fairy Antennae (100%)','false','recipe',30,'stackable','paper','none',-1,100000,0,'true','true','true','true','C5Item','none'),
(8373,'Party Hat Fabric','false','material',60,'stackable','liquid','none',-1,10000,0,'true','true','true','true','C5Item','none'),
(8374,'Feathered Hat Fabric','false','material',60,'stackable','liquid','none',-1,10000,0,'true','true','true','true','C5Item','none'),
(8375,'Artisan\'s Goggles Fabric','false','material',60,'stackable','liquid','none',-1,10000,0,'true','true','true','true','C5Item','none'),
(8376,'Red Horn of Victory Fragment','false','material',60,'stackable','liquid','none',-1,0,0,'true','true','true','true','C5Item','none'),
(8377,'Little Angel Wings Piece','false','material',60,'stackable','liquid','none',-1,5000,0,'true','true','true','true','C5Item','none'),
(8378,'Fairy Antennae Piece','false','material',60,'stackable','liquid','none',-1,5000,0,'true','true','true','true','C5Item','none'),
(8379,'Petrification Scroll','false','material',120,'stackable','paper','none',-1,0,0,'true','true','true','true','C5Item','none'),
(8380,'Spellbook: Betray','false','spellbook',120,'stackable','paper','none',-1,6250,0,'true','true','true','true','C5Item','none'),
(8381,'Spellbook: Mass Curse Fear','false','spellbook',120,'stackable','paper','none',-1,6750,0,'true','true','true','true','C5Item','none'),
(8382,'Spellbook: Mass Curse Gloom','false','spellbook',120,'stackable','paper','none',-1,6750,0,'true','true','true','true','C5Item','none'),
(8383,'Spellbook: Mass Surrender to Fire','false','spellbook',120,'stackable','paper','none',-1,6750,0,'true','true','true','true','C5Item','none'),
(8384,'Spellbook: Mass Surrender to Water','false','spellbook',120,'stackable','paper','none',-1,6750,0,'true','true','true','true','C5Item','none'),
(8385,'Spellbook: Mass Surrender to Wind','false','spellbook',120,'stackable','paper','none',-1,6750,0,'true','true','true','true','C5Item','none'),
(8386,'Spellbook - Arcane Disruption','false','spellbook',120,'stackable','paper','none',-1,6250,0,'true','true','true','true','C5Item','none'),
(8387,'Spellbook - Summon Cursed Bones','false','spellbook',120,'stackable','paper','none',-1,7200,0,'true','true','true','true','C5Item','none'),
(8388,'Spellbook: Greater Might','false','spellbook',120,'stackable','paper','none',-1,6750,0,'true','true','true','true','C5Item','none'),
(8389,'Spellbook: Greater Shield','false','spellbook',120,'stackable','paper','none',-1,6750,0,'true','true','true','true','C5Item','none'),
(8390,'Amulet: War Chant','false','spellbook',120,'stackable','paper','none',-1,6750,0,'true','true','true','true','C5Item','none'),
(8391,'Amulet: Earth Chant','false','spellbook',120,'stackable','paper','none',-1,6750,0,'true','true','true','true','C5Item','none'),
(8392,'Spellbook: Holy Resistance','false','spellbook',120,'stackable','paper','none',-1,6750,0,'true','true','true','true','C5Item','none'),
(8393,'Spellbook: Unholy Resistance','false','spellbook',120,'stackable','paper','none',-1,6750,0,'true','true','true','true','C5Item','none'),
(8394,'Spellbook: Trance','false','spellbook',120,'stackable','paper','none',-1,6250,0,'true','true','true','true','C5Item','none'),
(8395,'Spellbook: Erase','false','spellbook',120,'stackable','paper','none',-1,6250,0,'true','true','true','true','C5Item','none'),
(8396,'Spellbook: Magical Backfire','false','spellbook',120,'stackable','paper','none',-1,6250,0,'true','true','true','true','C5Item','none'),
(8397,'Spellbook: Clarity','false','spellbook',120,'stackable','paper','none',-1,6750,0,'true','true','true','true','C5Item','none'),
(8398,'Spellbook: Mana Burn','false','spellbook',120,'stackable','paper','none',-1,6250,0,'true','true','true','true','C5Item','none'),
(8399,'Spellbook: Mana Storm','false','spellbook',120,'stackable','paper','none',-1,6750,0,'true','true','true','true','C5Item','none'),
(8400,'Spellbook: Turn Undead','false','spellbook',120,'stackable','paper','none',-1,6250,0,'true','true','true','true','C5Item','none'),
(8401,'Spellbook: Major Heal','false','spellbook',120,'stackable','paper','none',-1,6250,0,'true','true','true','true','C5Item','none'),
(8402,'Spellbook: Major Group Heal','false','spellbook',120,'stackable','paper','none',-1,6750,0,'true','true','true','true','C5Item','none'),
(8403,'Small Nimble Green Fish - Upper Grade','false','none',100,'stackable','paper','none',-1,0,0,'true','true','true','true','C5Item','none'),
(8404,'Small Ugly Green Fish - Upper Grade','false','none',100,'stackable','paper','none',-1,0,0,'true','true','true','true','C5Item','none'),
(8405,'Small Pudgy Green Fish - Upper Grade','false','none',100,'stackable','paper','none',-1,0,0,'true','true','true','true','C5Item','none'),
(8406,'Nimble Green Fish - Upper Grade','false','none',100,'stackable','paper','none',-1,0,0,'true','true','true','true','C5Item','none'),
(8407,'Ugly Green Fish - Upper Grade','false','none',100,'stackable','paper','none',-1,0,0,'true','true','true','true','C5Item','none'),
(8408,'Pudgy Green Fish - Upper Grade','false','none',100,'stackable','paper','none',-1,0,0,'true','true','true','true','C5Item','none'),
(8409,'Large Nimble Green Fish - Upper Grade','false','none',100,'stackable','paper','none',-1,0,0,'true','true','true','true','C5Item','none'),
(8410,'Large Ugly Green Fish - Upper Grade','false','none',100,'stackable','paper','none',-1,0,0,'true','true','true','true','C5Item','none'),
(8411,'Large Pudgy Green Fish - Upper Grade','false','none',100,'stackable','paper','none',-1,265,0,'true','true','true','true','C5Item','none'),
(8412,'Small Jade Nimble Fish - Upper Grade','false','none',100,'stackable','paper','none',-1,0,0,'true','true','true','true','C5Item','none'),
(8413,'Small Jade Ugly Fish - Upper Grade','false','none',100,'stackable','paper','none',-1,0,0,'true','true','true','true','C5Item','none'),
(8414,'Small Jade Fat Fish - Upper Grade','false','none',100,'stackable','paper','none',-1,310,0,'true','true','true','true','C5Item','none'),
(8415,'Jade Nimble Fish - Upper Grade','false','none',100,'stackable','paper','none',-1,0,0,'true','true','true','true','C5Item','none'),
(8416,'Jade Ugly Fish - Upper Grade','false','none',100,'stackable','paper','none',-1,0,0,'true','true','true','true','C5Item','none'),
(8417,'Jade Fat Fish - Upper Grade','false','none',100,'stackable','paper','none',-1,0,0,'true','true','true','true','C5Item','none'),
(8418,'Large Jade Nimble Fish - Upper Grade','false','none',100,'stackable','paper','none',-1,365,0,'true','true','true','true','C5Item','none'),
(8419,'Large Jade Ugly Fish - Upper Grade','false','none',100,'stackable','paper','none',-1,0,0,'true','true','true','true','C5Item','none'),
(8420,'Large Jade Fat Fish - Upper Grade','false','none',100,'stackable','paper','none',-1,385,0,'true','true','true','true','C5Item','none'),
(8421,'Small Blue Nimble Fish - Upper Grade','false','none',100,'stackable','paper','none',-1,0,0,'true','true','true','true','C5Item','none'),
(8422,'Small Blue Ugly Fish - Upper Grade','false','none',100,'stackable','paper','none',-1,0,0,'true','true','true','true','C5Item','none'),
(8423,'Small Blue Fat Fish - Upper Grade','false','none',100,'stackable','paper','none',-1,410,0,'true','true','true','true','C5Item','none'),
(8424,'Blue Nimble Fish - Upper Grade','false','none',100,'stackable','paper','none',-1,0,0,'true','true','true','true','C5Item','none'),
(8425,'Blue Ugly Fish - Upper Grade','false','none',100,'stackable','paper','none',-1,418,0,'true','true','true','true','C5Item','none'),
(8426,'Blue Fat Fish - Upper Grade','false','none',100,'stackable','paper','none',-1,0,0,'true','true','true','true','C5Item','none'),
(8427,'Large Blue Nimble Fish - Upper Grade','false','none',100,'stackable','paper','none',-1,0,0,'true','true','true','true','C5Item','none'),
(8428,'Large Blue Ugly Fish - Upper Grade','false','none',100,'stackable','paper','none',-1,0,0,'true','true','true','true','C5Item','none'),
(8429,'Large Blue Fat Fish - Upper Grade','false','none',100,'stackable','paper','none',-1,0,0,'true','true','true','true','C5Item','none'),
(8430,'Small Yellow Nimble Fish - Upper Grade','false','none',100,'stackable','paper','none',-1,442,0,'true','true','true','true','C5Item','none'),
(8431,'Small Yellow Ugly Fish - Upper Grade','false','none',100,'stackable','paper','none',-1,0,0,'true','true','true','true','C5Item','none'),
(8432,'Small Yellow Fat Fish - Upper Grade','false','none',100,'stackable','paper','none',-1,0,0,'true','true','true','true','C5Item','none'),
(8433,'Yellow Nimble Fish - Upper Grade','false','none',100,'stackable','paper','none',-1,0,0,'true','true','true','true','C5Item','none'),
(8434,'Yellow Ugly Fish - Upper Grade','false','none',100,'stackable','paper','none',-1,0,0,'true','true','true','true','C5Item','none'),
(8435,'Yellow Fat Fish - Upper Grade','false','none',100,'stackable','paper','none',-1,0,0,'true','true','true','true','C5Item','none'),
(8436,'Large Yellow Nimble Fish - Upper Grade','false','none',100,'stackable','paper','none',-1,580,0,'true','true','true','true','C5Item','none'),
(8437,'Large Yellow Ugly Fish - Upper Grade','false','none',100,'stackable','paper','none',-1,594,0,'true','true','true','true','C5Item','none'),
(8438,'Large Yellow Fat Fish - Upper Grade','false','none',100,'stackable','paper','none',-1,0,0,'true','true','true','true','C5Item','none'),
(8439,'Small Orange Nimble Fish - Upper Grade','false','none',100,'stackable','paper','none',-1,622,0,'true','true','true','true','C5Item','none'),
(8440,'Small Orange Ugly Fish - Upper Grade','false','none',100,'stackable','paper','none',-1,635,0,'true','true','true','true','C5Item','none'),
(8441,'Small Orange Fat Fish - Upper Grade','false','none',100,'stackable','paper','none',-1,649,0,'true','true','true','true','C5Item','none'),
(8442,'Orange Nimble Fish - Upper Grade','false','none',100,'stackable','paper','none',-1,0,0,'true','true','true','true','C5Item','none'),
(8443,'Orange Ugly Fish - Upper Grade','false','none',100,'stackable','paper','none',-1,0,0,'true','true','true','true','C5Item','none'),
(8444,'Orange Fat Fish - Upper Grade','false','none',100,'stackable','paper','none',-1,0,0,'true','true','true','true','C5Item','none'),
(8445,'Large Orange Nimble Fish - Upper Grade','false','none',100,'stackable','paper','none',-1,0,0,'true','true','true','true','C5Item','none'),
(8446,'Large Orange Ugly Fish - Upper Grade','false','none',100,'stackable','paper','none',-1,0,0,'true','true','true','true','C5Item','none'),
(8447,'Large Orange Fat Fish - Upper Grade','false','none',100,'stackable','paper','none',-1,0,0,'true','true','true','true','C5Item','none'),
(8448,'Small Purple Nimble Fish - Upper Grade','false','none',100,'stackable','paper','none',-1,0,0,'true','true','true','true','C5Item','none'),
(8449,'Small Purple Ugly Fish - Upper Grade','false','none',100,'stackable','paper','none',-1,0,0,'true','true','true','true','C5Item','none'),
(8450,'Small Purple Fat Fish - Upper Grade','false','none',100,'stackable','paper','none',-1,0,0,'true','true','true','true','C5Item','none'),
(8451,'Purple Nimble Fish - Upper Grade','false','none',100,'stackable','paper','none',-1,0,0,'true','true','true','true','C5Item','none'),
(8452,'Purple Ugly Fish - Upper Grade','false','none',100,'stackable','paper','none',-1,0,0,'true','true','true','true','C5Item','none'),
(8453,'Purple Fat Fish - Upper Grade','false','none',100,'stackable','paper','none',-1,0,0,'true','true','true','true','C5Item','none'),
(8454,'Large Purple Nimble Fish - Upper Grade','false','none',100,'stackable','paper','none',-1,0,0,'true','true','true','true','C5Item','none'),
(8455,'Large Purple Ugly Fish - Upper Grade','false','none',100,'stackable','paper','none',-1,0,0,'true','true','true','true','C5Item','none'),
(8456,'Large Purple Fat Fish - Upper Grade','false','none',100,'stackable','paper','none',-1,0,0,'true','true','true','true','C5Item','none'),
(8457,'Small Red Nimble Fish - Upper Grade','false','none',100,'stackable','paper','none',-1,0,0,'true','true','true','true','C5Item','none'),
(8458,'Small Red Ugly Fish - Upper Grade','false','none',100,'stackable','paper','none',-1,0,0,'true','true','true','true','C5Item','none'),
(8459,'Small Red Fat Fish - Upper Grade','false','none',100,'stackable','paper','none',-1,1326,0,'true','true','true','true','C5Item','none'),
(8460,'Red Nimble Fish - Upper Grade','false','none',100,'stackable','paper','none',-1,0,0,'true','true','true','true','C5Item','none'),
(8461,'Red Ugly Fish - Upper Grade','false','none',100,'stackable','paper','none',-1,0,0,'true','true','true','true','C5Item','none'),
(8462,'Red Fat Fish - Upper Grade','false','none',100,'stackable','paper','none',-1,0,0,'true','true','true','true','C5Item','none'),
(8463,'Large Red Nimble Fish - Upper Grade','false','none',100,'stackable','paper','none',-1,0,0,'true','true','true','true','C5Item','none'),
(8464,'Large Red Ugly Fish - Upper Grade','false','none',100,'stackable','paper','none',-1,1608,0,'true','true','true','true','C5Item','none'),
(8465,'Large Red Fat Fish - Upper Grade','false','none',100,'stackable','paper','none',-1,0,0,'true','true','true','true','C5Item','none'),
(8466,'Small White Nimble Fish - Upper Grade','false','none',100,'stackable','paper','none',-1,0,0,'true','true','true','true','C5Item','none'),
(8467,'Small White Ugly Fish - Upper Grade','false','none',100,'stackable','paper','none',-1,0,0,'true','true','true','true','C5Item','none'),
(8468,'Small White Fat Fish - Upper Grade','false','none',100,'stackable','paper','none',-1,0,0,'true','true','true','true','C5Item','none'),
(8469,'White Nimble Fish - Upper Grade','false','none',100,'stackable','paper','none',-1,0,0,'true','true','true','true','C5Item','none'),
(8470,'White Ugly Fish - Upper Grade','false','none',100,'stackable','paper','none',-1,0,0,'true','true','true','true','C5Item','none'),
(8471,'White Fat Fish - Upper Grade','false','none',100,'stackable','paper','none',-1,0,0,'true','true','true','true','C5Item','none'),
(8472,'High Grade - Large White Nimble Fish','false','none',100,'stackable','paper','none',-1,0,0,'true','true','true','true','C5Item','none'),
(8473,'Large White Ugly Fish - Upper Grade','false','none',100,'stackable','paper','none',-1,0,0,'true','true','true','true','C5Item','none'),
(8474,'Large White Fat Fish - Upper Grade','false','none',100,'stackable','paper','none',-1,0,0,'true','true','true','true','C5Item','none'),
(8475,'Small Black Nimble Fish: Upper Grade','false','none',100,'stackable','paper','none',-1,0,0,'true','true','true','true','C5Item','none'),
(8476,'Small Black Ugly Fish - Upper Grade','false','none',100,'stackable','paper','none',-1,0,0,'true','true','true','true','C5Item','none'),
(8477,'Small Black Fat Fish - Upper Grade','false','none',100,'stackable','paper','none',-1,0,0,'true','true','true','true','C5Item','none'),
(8478,'Black Nimble Fish - Upper Grade','false','none',100,'stackable','paper','none',-1,0,0,'true','true','true','true','C5Item','none'),
(8479,'Black Ugly Fish - Upper Grade','false','none',100,'stackable','paper','none',-1,0,0,'true','true','true','true','C5Item','none'),
(8480,'Black Fat Fish - Upper Grade','false','none',100,'stackable','paper','none',-1,0,0,'true','true','true','true','C5Item','none'),
(8481,'Large Black Nimble Fish - Upper Grade','false','none',100,'stackable','paper','none',-1,0,0,'true','true','true','true','C5Item','none'),
(8482,'Large Black Ugly Fish - Upper Grade','false','none',100,'stackable','paper','none',-1,0,0,'true','true','true','true','C5Item','none'),
(8483,'Large Black Fat Fish - Upper Grade','false','none',100,'stackable','paper','none',-1,0,0,'true','true','true','true','C5Item','none'),
(8484,'Prize-Winning Fishing Lure','false','lure',4,'stackable','liquid','none',-1,240,0,'true','true','true','true','C5Item','none'),
(8485,'Prize-Winning Night Fishing Lure','false','lure',4,'stackable','liquid','none',-1,240,0,'true','true','true','true','C5Item','none'),
(8486,'Prize-Winning Novice Fishing Lure','false','lure',5,'stackable','liquid','none',-1,100,0,'true','true','true','true','C5Item','none'),
(8487,'Recipe: Destroyer Hammer (60%)','false','recipe',30,'stackable','liquid','none',-1,366000,0,'true','true','true','true','C5Item','none'),
(8488,'Engraved Hammer','false','quest',0,'stackable','paper','none',-1,0,0,'true','true','true','true','C5Item','none'),
(8489,'Daimon\'s Eyes','false','quest',0,'stackable','paper','none',-1,0,0,'true','true','true','true','C5Item','none'),
(8490,'Hestia\'s Fairy Stone','false','quest',0,'stackable','paper','none',-1,0,0,'true','true','true','true','C5Item','none'),
(8491,'Nucleus of Lesser Golem','false','quest',0,'stackable','paper','none',-1,0,0,'true','true','true','true','C5Item','none'),
(8492,'Falston\'s Fang','false','quest',0,'stackable','paper','none',-1,0,0,'true','true','true','true','C5Item','none'),
(8493,'Shaid\'s Talon','false','quest',0,'stackable','paper','none',-1,0,0,'true','true','true','true','C5Item','none'),
(8494,'Nucleus of Flamestone Giant','false','quest',0,'stackable','paper','none',-1,0,0,'true','true','true','true','C5Item','none'),
(8495,'Book of Grey Star','false','quest',0,'stackable','paper','none',-1,0,0,'true','true','true','true','C5Item','none'),
(8496,'Gludio\'s Luminous Lure','false','lure',5,'stackable','liquid','none',-1,0,0,'true','true','true','true','C5Item','none'),
(8497,'Dion\'s Luminous Lure','false','lure',4,'stackable','liquid','none',-1,0,0,'true','true','true','true','C5Item','none'),
(8498,'Giran\'s Luminous Lure','false','lure',3,'stackable','liquid','none',-1,0,0,'true','true','true','true','C5Item','none'),
(8499,'Oren\'s Luminous Lure','false','lure',5,'stackable','liquid','none',-1,0,0,'true','true','true','true','C5Item','none'),
(8500,'Aden\'s Luminous Lure','false','lure',4,'stackable','liquid','none',-1,0,0,'true','true','true','true','C5Item','none'),
(8501,'Innadril\'s Luminous Lure','false','lure',3,'stackable','liquid','none',-1,0,0,'true','true','true','true','C5Item','none'),
(8502,'Goddard\'s Luminous Lure','false','lure',5,'stackable','liquid','none',-1,0,0,'true','true','true','true','C5Item','none'),
(8503,'Rune\'s Luminous Lure','false','lure',4,'stackable','liquid','none',-1,0,0,'true','true','true','true','C5Item','none'),
(8504,'Schuttgart\'s Luminous Lure','false','lure',3,'stackable','liquid','none',-1,0,0,'true','true','true','true','C5Item','none'),
(8505,'Green Luminous Lure - Low Grade','false','lure',5,'stackable','liquid','none',-1,0,0,'true','true','true','true','C5Item','none'),
(8506,'Green Luminous Lure','false','lure',4,'stackable','liquid','none',-1,120,0,'true','true','true','true','C5Item','none'),
(8507,'Green Colored Lure - High Grade','false','lure',3,'stackable','liquid','none',-1,0,0,'true','true','true','true','C5Item','none'),
(8508,'Purple Luminous Lure - Low Grade','false','lure',5,'stackable','liquid','none',-1,0,0,'true','true','true','true','C5Item','none'),
(8509,'Purple Luminous Lure','false','lure',4,'stackable','liquid','none',-1,180,0,'true','true','true','true','C5Item','none'),
(8510,'Purple Luminous Lure - High Grade','false','lure',3,'stackable','liquid','none',-1,0,0,'true','true','true','true','C5Item','none'),
(8511,'Yellow Luminous Lure - Low Grade','false','lure',5,'stackable','liquid','none',-1,0,0,'true','true','true','true','C5Item','none'),
(8512,'Yellow Luminous Lure','false','lure',4,'stackable','liquid','none',-1,150,0,'true','true','true','true','C5Item','none'),
(8513,'Yellow Luminous Lure - High Grade','false','lure',3,'stackable','liquid','none',-1,0,0,'true','true','true','true','C5Item','none'),
(8514,'Remnants of Old Dwarves'' Dreams','false','quest',0,'stackable','paper','none',-1,0,0,'true','true','true','true','C5Item','none'),
(8515,'Charm of Courage: No Grade','false','scroll',10,'stackable','paper','none',-1,2000,0,'true','true','true','true','C5Item','none'),
(8516,'Charm of Courage: D-Grade','false','scroll',10,'stackable','paper','d',-1,6600,0,'true','true','true','true','C5Item','none'),
(8517,'Charm of Courage: C-Grade','false','scroll',10,'stackable','paper','c',-1,13200,0,'true','true','true','true','C5Item','none'),
(8518,'Charm of Courage: B-Grade','false','scroll',10,'stackable','paper','b',-1,26000,0,'true','true','true','true','C5Item','none'),
(8519,'Charm of Courage: A-Grade','false','scroll',10,'stackable','paper','a',-1,54000,0,'true','true','true','true','C5Item','none'),
(8520,'Charm of Courage: S-Grade','false','scroll',10,'stackable','paper','s',-1,100000,0,'true','true','true','true','C5Item','none'),
(8521,'Seed: Sea Coba','false','seed',1,'stackable','paper','none',-1,900,0,'true','true','true','true','C5Item','none'),
(8522,'Seed: Alternative Sea Coba','false','seed',1,'stackable','paper','none',-1,900,0,'true','true','true','true','C5Item','none'),
(8523,'Seed: Twin Coba','false','seed',1,'stackable','paper','none',-1,1000,0,'true','true','true','true','C5Item','none'),
(8524,'Seed: Alternative Twin Coba','false','seed',1,'stackable','paper','none',-1,1000,0,'true','true','true','true','C5Item','none'),
(8525,'Seed: Great Coba','false','seed',1,'stackable','paper','none',-1,1200,0,'true','true','true','true','C5Item','none'),
(8526,'Seed: Alternative Great Coba','false','seed',1,'stackable','paper','none',-1,1200,0,'true','true','true','true','C5Item','none'),
(8534,'Adventurer\'s Box: C-Grade Accessory (Low Grade)','false','none',20,'stackable','steel','none',-1,0,0,'true','true','true','true','C5Item','none'),
(8535,'Adventurer\'s Box: C-Grade Accessory (Medium Grade)','false','none',20,'stackable','steel','none',-1,0,0,'true','true','true','true','C5Item','none'),
(8536,'Adventurer\'s Box: C-Grade Accessory (High Grade)','false','none',20,'stackable','steel','none',-1,0,0,'true','true','true','true','C5Item','none'),
(8537,'Adventurer\'s Box: B-Grade Accessory (Low Grade)','false','none',20,'stackable','steel','none',-1,0,0,'true','true','true','true','C5Item','none'),
(8538,'Adventurer\'s Box: B-Grade Accessory (High Grade)','false','none',20,'stackable','steel','none',-1,0,0,'true','true','true','true','C5Item','none'),
(8539,'Adventurer\'s Box: Hair Accessory','false','none',20,'stackable','steel','none',-1,0,0,'true','true','true','true','C5Item','none'),
(8540,'Adventurer\'s Box: Cradle of Creation','false','none',20,'stackable','steel','none',-1,0,0,'true','true','true','true','C5Item','none'),
(8542,'Newbie Travel Token','false','none',10,'stackable','liquid','none',-1,0,0,'false','false','true','false','C5Item','none'),
(8543,'Bead Parcel','false','quest',0,'stackable','steel','none',-1,0,0,'true','true','true','true','C5Item','none'),
(8544,'Timora Orc\'s Head','false','quest',0,'stackable','paper','none',-1,0,0,'true','true','true','true','C5Item','none'),
(8545,'Kasha Spider\'s Tooth','false','quest',0,'stackable','paper','none',-1,0,0,'true','true','true','true','C5Item','none'),
(8546,'Horn of Baar Dre Vanul','false','quest',0,'stackable','paper','none',-1,0,0,'true','true','true','true','C5Item','none'),
(8547,'Old Box','false','quest',100,'stackable','paper','none',-1,1500,0,'true','true','true','true','C5Item','none'),
(8548,'Hot Springs Lure','false','lure',3,'stackable','liquid','none',-1,200,0,'true','true','true','true','C5Item','none'),
(8549,'Bruin Lizardman Blood','false','quest',0,'stackable','paper','none',-1,0,0,'true','true','true','true','C5Item','none'),
(8550,'Picot Araneid\'s Leg','false','quest',0,'stackable','paper','none',-1,0,0,'true','true','true','true','C5Item','none'),
(8551,'Box of Cheerleading Gear Used to encourage victory.','false','material',0,'stackable','paper','none',-1,0,0,'true','true','true','true','C5Item','none'),
(8553,'Red Mask of Victory,Fabric','false','recipe',60,'stackable','paper','none',-1,0,0,'true','true','true','true','C5Item','none'),
(8554,'Recipe: Red Mask of Victory (100%)','false','none',30,'stackable','paper','none',-1,0,0,'true','true','true','true','C5Item','none'),
(8555,'Echo Crystal - Viva Victory Korea','false','none',10,'stackable','paper','none',-1,0,0,'true','true','true','true','C5Item','none'),
(8556,'Dewdrop of Destruction','false','none',3,'stackable','gold','none',-1,0,0,'true','true','true','true','C5Item','none'),
(8570,'Event Gift Box','false','none',20,'stackable','steel','none',-1,0,0,'false','false','true','false','C5Item','none'),
(8571,'Event Gift Box','false','none',20,'stackable','steel','none',-1,0,0,'false','false','true','false','C5Item','none'),
(8572,'Event Gift Box','false','none',20,'stackable','steel','none',-1,0,0,'false','false','true','false','C5Item','none'),
(8573,'Event Gift Box','false','none',20,'stackable','steel','none',-1,0,0,'false','false','true','false','C5Item','none'),
(8574,'Event Gift Box','false','none',20,'stackable','steel','none',-1,0,0,'false','false','true','false','C5Item','none'),
(8575,'Event Gift Box','false','none',20,'stackable','steel','none',-1,0,0,'false','false','true','false','C5Item','none'),
(8592,'Weapon Exchange Coupon - No Grade','false','none',1,'normal','paper','none',-1,0,0,'true','true','true','true','C5Item','none'),
(8593,'Weapon Exchange Coupon - D Grade','false','scroll',1,'normal','paper','none',-1,0,0,'true','true','true','true','C5Item','none'),
(8594,'Scroll: Recovery (No Grade)','false','scroll',10,'stackable','paper','none',-1,2000,0,'true','true','true','true','C5Item','none'),
(8595,'Scroll: Recovery (Grade D)','false','scroll',10,'stackable','paper','d',-1,4800,0,'true','true','true','true','C5Item','none'),
(8596,'Scroll: Recovery (Grade C)','false','scroll',10,'stackable','paper','c',-1,14000,0,'true','true','true','true','C5Item','none'),
(8597,'Scroll: Recovery (Grade B)','false','scroll',10,'stackable','paper','b',-1,28000,0,'true','true','true','true','C5Item','none'),
(8598,'Scroll: Recovery (Grade A)','false','scroll',10,'stackable','paper','a',-1,48000,0,'true','true','true','true','C5Item','none'),
(8599,'Scroll: Recovery (Grade S)','false','scroll',10,'stackable','paper','s',-1,80000,0,'true','true','true','true','C5Item','none'),
(8600,'Herb of Life','false','herb',0,'normal','paper','none',-1,0,0,'false','true','true','true','C5Item','none'),
(8601,'Greater Herb of Life','false','herb',0,'normal','paper','none',-1,0,0,'false','true','true','true','C5Item','none'),
(8602,'Superior Herb of Life','false','herb',0,'normal','paper','none',-1,0,0,'false','true','true','true','C5Item','none'),
(8603,'Herb of Mana','false','herb',0,'normal','paper','none',-1,0,0,'false','true','true','true','C5Item','none'),
(8604,'Greater Herb of Mana','false','herb',0,'normal','paper','none',-1,0,0,'false','true','true','true','C5Item','none'),
(8605,'Superior Herb of Mana','false','herb',0,'normal','paper','none',-1,0,0,'false','true','true','true','C5Item','none'),
(8606,'Herb of Power','false','herb',0,'normal','paper','none',-1,0,0,'false','true','true','true','C5Item','none'),
(8607,'Herb of Magic','false','herb',0,'normal','paper','none',-1,0,0,'false','true','true','true','C5Item','none'),
(8608,'Herb of Atk. Spd.','false','herb',0,'normal','paper','none',-1,0,0,'false','true','true','true','C5Item','none'),
(8609,'Herb of Casting Spd.','false','herb',0,'normal','paper','none',-1,0,0,'false','true','true','true','C5Item','none'),
(8610,'Herb of Critical Attack.','false','herb',0,'normal','paper','none',-1,0,0,'false','true','true','true','C5Item','none'),
(8611,'Herb of Speed','false','herb',0,'normal','paper','none',-1,0,0,'false','true','true','true','C5Item','none'),
(8612,'Herb of the Warrior','false','herb',0,'normal','paper','none',-1,0,0,'false','true','true','true','C5Item','none'),
(8613,'Herb of the Mystic','false','herb',0,'normal','paper','none',-1,0,0,'false','true','true','true','C5Item','none'),
(8614,'Herb of Recovery','false','herb',0,'normal','paper','none',-1,0,0,'false','true','true','true','C5Item','none'),
(8615,'Summoning Crystal','false','none',10,'stackable','crystal','none',-1,35000,0,'true','true','true','true','C5Item','none'),
(8616,'Spellbook: Summon Friend','false','spellbook',120,'stackable','paper','none',-1,6250,0,'true','true','true','true','C5Item','none'),
(8617,'Spellbook: Word of Invitation','false','spellbook',120,'stackable','paper','none',-1,0,0,'true','true','true','true','C5Item','none'),
(8618,'Ancient Book - Divine Inspiration (Modern Language Version)','false','none',120,'normal','paper','none',-1,0,0,'true','true','true','true','C5Item','none'),
(8619,'Ancient Book - Divine Inspiration (Original Language Version)','false','none',120,'normal','paper','none',-1,0,0,'true','true','true','true','C5Item','none'),
(8620,'Ancient Book - Divine Inspiration (Manuscript)','false','none',120,'normal','paper','none',-1,0,0,'true','true','true','true','C5Item','none'),
(8621,'Ancient Book - Divine Inspiration (Original Version)','false','none',120,'normal','paper','none',-1,0,0,'false','false','true','false','C5Item','none'),
(8622,'Elixir of Life (No Grade)','false','potion',5,'stackable','liquid','none',-1,1300,0,'true','true','true','true','C5Item','none'),
(8623,'Elixir of Life (D-Grade)','false','potion',5,'stackable','liquid','d',-1,3450,0,'true','true','true','true','C5Item','none'),
(8624,'Elixir of Life (C-Grade)','false','potion',5,'stackable','liquid','c',-1,7200,0,'true','true','true','true','C5Item','none'),
(8625,'Elixir of Life (B-Grade)','false','potion',5,'stackable','liquid','b',-1,10000,0,'true','true','true','true','C5Item','none'),
(8626,'Elixir of Life (A-Grade)','false','potion',5,'stackable','liquid','a',-1,12500,0,'true','true','true','true','C5Item','none'),
(8627,'Elixir of Life (S-Grade)','false','potion',5,'stackable','liquid','s',-1,15000,0,'true','true','true','true','C5Item','none'),
(8628,'Elixir of Mental Strength (No Grade)','false','potion',5,'stackable','liquid','none',-1,1200,0,'true','true','true','true','C5Item','none'),
(8629,'Elixir of Mental Strength (D-Grade)','false','potion',5,'stackable','liquid','d',-1,3400,0,'true','true','true','true','C5Item','none'),
(8630,'Elixir of Mental Strength (C-Grade)','false','potion',5,'stackable','liquid','c',-1,8700,0,'true','true','true','true','C5Item','none'),
(8631,'Elixir of Mental Strength (B-Grade)','false','potion',5,'stackable','liquid','b',-1,11600,0,'true','true','true','true','C5Item','none'),
(8632,'Elixir of Mental Strength (A-Grade)','false','potion',5,'stackable','liquid','a',-1,14400,0,'true','true','true','true','C5Item','none'),
(8633,'Elixir of Mental Strength (S-Grade)','false','potion',5,'stackable','liquid','s',-1,16800,0,'true','true','true','true','C5Item','none'),
(8634,'Elixir of CP (No Grade)','false','potion',5,'stackable','liquid','none',-1,600,0,'true','true','true','true','C5Item','none'),
(8635,'Elixir of CP (D-Grade)','false','potion',5,'stackable','liquid','d',-1,1400,0,'true','true','true','true','C5Item','none'),
(8636,'Elixir of CP (C-Grade)','false','potion',5,'stackable','liquid','c',-1,3000,0,'true','true','true','true','C5Item','none'),
(8637,'Elixir of CP (B-Grade)','false','potion',5,'stackable','liquid','b',-1,4000,0,'true','true','true','true','C5Item','none'),
(8638,'Elixir of CP (A-Grade)','false','potion',5,'stackable','liquid','a',-1,5000,0,'true','true','true','true','C5Item','none'),
(8639,'Elixir of CP (S-Grade)','false','potion',5,'stackable','liquid','s',-1,6000,0,'true','true','true','true','C5Item','none'),
(8640,'Recipe: Elixir of Life (No Grade) (100%)','false','recipe',30,'stackable','paper','none',-1,0,0,'true','true','true','true','C5Item','none'),
(8641,'Recipe: Elixir of Life (D-Grade)','false','recipe',30,'stackable','paper','none',-1,0,0,'true','true','true','true','C5Item','none'),
(8642,'Recipe: Elixir of Life (C-Grade) (100%)','false','recipe',30,'stackable','paper','none',-1,0,0,'true','true','true','true','C5Item','none'),
(8643,'Recipe: Elixir of Life (B-Grade) (100%)','false','recipe',30,'stackable','paper','none',-1,2000,0,'true','true','true','true','C5Item','none'),
(8644,'Recipe: Elixir of Life (A-Grade) (100%)','false','recipe',30,'stackable','paper','none',-1,2500,0,'true','true','true','true','C5Item','none'),
(8645,'Recipe: Elixir of Life (S-Grade) (100%)','false','recipe',30,'stackable','paper','none',-1,3000,0,'true','true','true','true','C5Item','none'),
(8646,'Recipe: Elixir of Mental Strength (No Grade) (100%)','false','recipe',30,'stackable','paper','none',-1,0,0,'true','true','true','true','C5Item','none'),
(8647,'Recipe: Elixir of Mental Strength (D-Grade) (100%)','false','recipe',30,'stackable','paper','none',-1,0,0,'true','true','true','true','C5Item','none'),
(8648,'Recipe: Elixir of Mental Strength (C-Grade) (100%)','false','recipe',30,'stackable','paper','none',-1,1760,0,'true','true','true','true','C5Item','none'),
(8649,'Recipe: Elixir of Mental Strength (B-Grade) (100%)','false','recipe',30,'stackable','paper','none',-1,2320,0,'true','true','true','true','C5Item','none'),
(8650,'Recipe: Elixir of Mental Strength (A-Grade) (100%)','false','recipe',30,'stackable','paper','none',-1,2880,0,'true','true','true','true','C5Item','none'),
(8651,'Recipe: Elixir of Mental Strength (S-Grade) (100%)','false','recipe',30,'stackable','paper','none',-1,3360,0,'true','true','true','true','C5Item','none'),
(8652,'Recipe: Elixir of CP (No Grade) (100%)','false','recipe',30,'stackable','paper','none',-1,0,0,'true','true','true','true','C5Item','none'),
(8653,'Recipe: Elixir of CP (D-Grade) (100%)','false','recipe',30,'stackable','paper','none',-1,0,0,'true','true','true','true','C5Item','none'),
(8654,'Recipe: Elixir of CP (C-Grade) (100%)','false','recipe',30,'stackable','paper','none',-1,0,0,'true','true','true','true','C5Item','none'),
(8655,'Recipe: Elixir of CP (B-Grade) (100%)','false','recipe',30,'stackable','paper','none',-1,0,0,'true','true','true','true','C5Item','none'),
(8656,'Recipe: Elixir of CP (A-Grade) (100%)','false','recipe',30,'stackable','paper','none',-1,0,0,'true','true','true','true','C5Item','none'),
(8657,'Recipe: Elixir of CP (S-Grade) (100%)','false','recipe',30,'stackable','paper','none',-1,0,0,'true','true','true','true','C5Item','none'),
(8658,'Mysterious Solvent','false','none',2,'stackable','liquid','none',-1,100,0,'true','true','true','true','C5Item','none'),
(8659,'Coffer of Shadows','false','potion',0,'stackable','paper','none',-1,0,0,'true','true','true','true','C5Item','none'),
(8663,'Mystery Potion (Event)','false','potion',50,'stackable','liquid','none',-1,0,0,'true','true','true','true','C5Item','none'),
(8664,'Facelifting Potion - A (Event)','false','potion',50,'stackable','liquid','none',-1,0,0,'true','true','true','true','C5Item','none'),
(8665,'Facelifting Potion - B (Event)','false','potion',50,'stackable','liquid','none',-1,0,0,'true','true','true','true','C5Item','none'),
(8666,'Facelifting Potion - C (Event)','false','potion',50,'stackable','liquid','none',-1,0,0,'true','true','true','true','C5Item','none'),
(8667,'Dye Potion - A (Event)','false','potion',50,'stackable','liquid','none',-1,0,0,'true','true','true','true','C5Item','none'),
(8668,'Dye Potion - B (Event)','false','potion',50,'stackable','liquid','none',-1,0,0,'true','true','true','true','C5Item','none'),
(8669,'Dye Potion - C (Event)','false','potion',50,'stackable','liquid','none',-1,0,0,'true','true','true','true','C5Item','none'),
(8670,'Dye Potion - D (Event)','false','potion',50,'stackable','liquid','none',-1,0,0,'true','true','true','true','C5Item','none'),
(8671,'Hair Style Change Potion - A (Event)','false','potion',50,'stackable','liquid','none',-1,0,0,'true','true','true','true','C5Item','none'),
(8672,'Hair Style Change Potion - B (Event)','false','potion',50,'stackable','liquid','none',-1,0,0,'true','true','true','true','C5Item','none'),
(8673,'Hair Style Change Potion - C (Event)','false','potion',50,'stackable','liquid','none',-1,0,0,'true','true','true','true','C5Item','none'),
(8674,'Hair Style Change Potion - D (Event)','false','potion',50,'stackable','liquid','none',-1,0,0,'true','true','true','true','C5Item','none'),
(8675,'Hair Style Change Potion - E (Event)','false','potion',50,'stackable','liquid','none',-1,0,0,'true','true','true','true','C5Item','none'),
(8676,'Hair Style Change Potion - F (Event)','false','potion',50,'stackable','liquid','none',-1,0,0,'true','true','true','true','C5Item','none'),
(8677,'Hair Style Change Potion - G (Event)','false','potion',50,'stackable','liquid','none',-1,0,0,'true','true','true','true','C5Item','none'),
(8690,'Recipe: Sirra\'s Blade (60%)','false','recipe',30,'stackable','paper','none',-1,0,0,'true','true','true','true','InterludeItem','none'),
(8691,'Recipe: Sirra\'s Blade (100%)','false','recipe',30,'stackable','paper','none',-1,0,0,'true','true','true','true','InterludeItem','none'),
(8692,'Recipe: Sword of Ipos (60%)','false','recipe',30,'stackable','paper','none',-1,0,0,'true','true','true','true','InterludeItem','none'),
(8693,'Recipe: Sword of Ipos (100%)','false','recipe',30,'stackable','paper','none',-1,0,0,'true','true','true','true','InterludeItem','none'),
(8694,'Recipe: Barakiel\'s Axe (60%)','false','recipe',30,'stackable','paper','none',-1,0,0,'true','true','true','true','InterludeItem','none'),
(8695,'Recipe: Barakiel\'s Axe (100%)','false','recipe',30,'stackable','paper','none',-1,0,0,'true','true','true','true','InterludeItem','none'),
(8696,'Recipe: Behemoth\'s Tuning Fork (60%)','false','recipe',30,'stackable','paper','none',-1,0,0,'true','true','true','true','InterludeItem','none'),
(8697,'Recipe: Behemoth\'s Tuning Fork (100%)','false','recipe',30,'stackable','paper','none',-1,0,0,'true','true','true','true','InterludeItem','none'),
(8698,'Recipe: Naga Storm (60%)','false','recipe',30,'stackable','paper','none',-1,0,0,'true','true','true','true','InterludeItem','none'),
(8699,'Recipe: Naga Storm (100%)','false','recipe',30,'stackable','paper','none',-1,0,0,'true','true','true','true','InterludeItem','none'),
(8700,'Recipe: Tiphon\'s Spear (60%)','false','recipe',30,'stackable','paper','none',-1,0,0,'true','true','true','true','InterludeItem','none'),
(8701,'Recipe: Tiphon\'s Spear (100%)','false','recipe',30,'stackable','paper','none',-1,0,0,'true','true','true','true','InterludeItem','none'),
(8702,'Recipe: Shyeed\'s Bow (60%)','false','recipe',30,'stackable','paper','none',-1,706000,0,'true','true','true','true','InterludeItem','none'),
(8703,'Recipe: Shyeed\'s Bow (100%)','false','recipe',30,'stackable','paper','none',-1,706000,0,'true','true','true','true','InterludeItem','none'),
(8704,'Recipe: Sobekk\'s Hurricane (60%)','false','recipe',30,'stackable','paper','none',-1,0,0,'true','true','true','true','InterludeItem','none'),
(8705,'Recipe: Sobekk\'s Hurricane (100%)','false','recipe',30,'stackable','paper','none',-1,0,0,'true','true','true','true','InterludeItem','none'),
(8706,'Recipe: Themis'' Tongue (60%)','false','recipe',30,'stackable','paper','none',-1,0,0,'true','true','true','true','InterludeItem','none'),
(8707,'Recipe: Themis'' Tongue (100%)','false','recipe',30,'stackable','paper','none',-1,0,0,'true','true','true','true','InterludeItem','none'),
(8708,'Recipe: Cabrio\'s Hand (60%)','false','recipe',30,'stackable','paper','none',-1,0,0,'true','true','true','true','InterludeItem','none'),
(8709,'Recipe: Cabrio\'s Hand (100%)','false','recipe',30,'stackable','paper','none',-1,0,0,'true','true','true','true','InterludeItem','none'),
(8710,'Recipe: Daimon Crystal (60%)','false','recipe',30,'stackable','paper','none',-1,0,0,'true','true','true','true','InterludeItem','none'),
(8711,'Recipe: Daimon Crystal (100%)','false','recipe',30,'stackable','paper','none',-1,0,0,'true','true','true','true','InterludeItem','none'),
(8712,'Sirra\'s Blade Edge','false','material',60,'stackable','liquid','none',-1,0,0,'true','true','true','true','InterludeItem','none'),
(8713,'Sword of Ipos Blade','false','material',60,'stackable','liquid','none',-1,0,0,'true','true','true','true','InterludeItem','none'),
(8714,'Barakiel\'s Axe Piece','false','material',60,'stackable','liquid','none',-1,0,0,'true','true','true','true','InterludeItem','none'),
(8715,'Behemoth\'s Tuning Fork Piece','false','material',60,'stackable','liquid','none',-1,0,0,'true','true','true','true','InterludeItem','none'),
(8716,'Naga Storm Piece','false','material',60,'stackable','liquid','none',-1,0,0,'true','true','true','true','InterludeItem','none'),
(8717,'Tiphon\'s Spear Edge','false','material',60,'stackable','liquid','none',-1,0,0,'true','true','true','true','InterludeItem','none'),
(8718,'Shyeed\'s Bow Shaft','false','material',60,'stackable','liquid','none',-1,0,0,'true','true','true','true','InterludeItem','none'),
(8719,'Sobekk\'s Hurricane Edge','false','material',60,'stackable','liquid','none',-1,0,0,'true','true','true','true','InterludeItem','none'),
(8720,'Themis'' Tongue Piece','false','material',60,'stackable','liquid','none',-1,0,0,'true','true','true','true','InterludeItem','none'),
(8721,'Cabrio\'s Hand Head','false','material',60,'stackable','liquid','none',-1,0,0,'true','true','true','true','InterludeItem','none'),
(8722,'Daimon Crystal Fragment','false','material',60,'stackable','liquid','none',-1,0,0,'true','true','true','true','InterludeItem','none'),
(8723,'Life Stone: level 46','false','none',2,'stackable','liquid','none',-1,5000,0,'true','true','true','true','InterludeItem','none'),
(8724,'Life Stone: level 49','false','none',2,'stackable','liquid','none',-1,6000,0,'true','true','true','true','InterludeItem','none'),
(8725,'Life Stone: level 52','false','none',2,'stackable','liquid','none',-1,7200,0,'true','true','true','true','InterludeItem','none'),
(8726,'Life Stone: level 55','false','none',2,'stackable','liquid','none',-1,8640,0,'true','true','true','true','InterludeItem','none'),
(8727,'Life Stone: level 58','false','none',2,'stackable','liquid','none',-1,10000,0,'true','true','true','true','InterludeItem','none'),
(8728,'Life Stone: level 61','false','none',2,'stackable','liquid','none',-1,12000,0,'true','true','true','true','InterludeItem','none'),
(8729,'Life Stone: level 64','false','none',2,'stackable','liquid','none',-1,15000,0,'true','true','true','true','InterludeItem','none'),
(8730,'Life Stone: level 67','false','none',2,'stackable','liquid','none',-1,18000,0,'true','true','true','true','InterludeItem','none'),
(8731,'Life Stone: level 70','false','none',2,'stackable','liquid','none',-1,21600,0,'true','true','true','true','InterludeItem','none'),
(8732,'Life Stone: level 76','false','none',2,'stackable','liquid','none',-1,24000,0,'true','true','true','true','InterludeItem','none'),
(8733,'Mid-Grade Life Stone: level 46','false','none',2,'stackable','liquid','none',-1,20000,0,'true','true','true','true','InterludeItem','none'),
(8734,'Mid-Grade Life Stone: level 49','false','none',2,'stackable','liquid','none',-1,24000,0,'true','true','true','true','InterludeItem','none'),
(8735,'Mid-Grade Life Stone: level 52','false','none',2,'stackable','liquid','none',-1,28800,0,'true','true','true','true','InterludeItem','none'),
(8736,'Mid-Grade Life Stone: level 55','false','none',2,'stackable','liquid','none',-1,34560,0,'true','true','true','true','InterludeItem','none'),
(8737,'Mid-Grade Life Stone: level 58','false','none',2,'stackable','liquid','none',-1,40000,0,'true','true','true','true','InterludeItem','none'),
(8738,'Mid-Grade Life Stone: level 61','false','none',2,'stackable','liquid','none',-1,48000,0,'true','true','true','true','InterludeItem','none'),
(8739,'Mid-Grade Life Stone: level 64','false','none',2,'stackable','liquid','none',-1,60000,0,'true','true','true','true','InterludeItem','none'),
(8740,'Mid-Grade Life Stone: level 67','false','none',2,'stackable','liquid','none',-1,72000,0,'true','true','true','true','InterludeItem','none'),
(8741,'Mid-Grade Life Stone: level 70','false','none',2,'stackable','liquid','none',-1,86400,0,'true','true','true','true','InterludeItem','none'),
(8742,'Mid-Grade Life Stone: level 76','false','none',2,'stackable','liquid','none',-1,96000,0,'true','true','true','true','InterludeItem','none'),
(8743,'High-Grade Life Stone: level 46','false','none',2,'stackable','liquid','none',-1,200000,0,'true','true','true','true','InterludeItem','none'),
(8744,'High-Grade Life Stone: level 49','false','none',2,'stackable','liquid','none',-1,240000,0,'true','true','true','true','InterludeItem','none'),
(8745,'High-Grade Life Stone: level 52','false','none',2,'stackable','liquid','none',-1,288000,0,'true','true','true','true','InterludeItem','none'),
(8746,'High-Grade Life Stone: level 55','false','none',2,'stackable','liquid','none',-1,345600,0,'true','true','true','true','InterludeItem','none'),
(8747,'High-Grade Life Stone: level 58','false','none',2,'stackable','liquid','none',-1,400000,0,'true','true','true','true','InterludeItem','none'),
(8748,'High-Grade Life Stone: level 61','false','none',2,'stackable','liquid','none',-1,480000,0,'true','true','true','true','InterludeItem','none'),
(8749,'High-Grade Life Stone: level 64','false','none',2,'stackable','liquid','none',-1,600000,0,'true','true','true','true','InterludeItem','none'),
(8750,'High-Grade Life Stone: level 67','false','none',2,'stackable','liquid','none',-1,720000,0,'true','true','true','true','InterludeItem','none'),
(8751,'High-Grade Life Stone: level 70','false','none',2,'stackable','liquid','none',-1,864000,0,'true','true','true','true','InterludeItem','none'),
(8752,'High-Grade Life Stone: level 76','false','none',2,'stackable','liquid','none',-1,960000,0,'true','true','true','true','InterludeItem','none'),
(8753,'Top-Grade Life Stone: level 46','false','none',2,'stackable','liquid','none',-1,1000000,0,'true','true','true','true','InterludeItem','none'),
(8754,'Top-Grade Life Stone: level 49','false','none',2,'stackable','liquid','none',-1,1200000,0,'true','true','true','true','InterludeItem','none'),
(8755,'Top-Grade Life Stone: level 52','false','none',2,'stackable','liquid','none',-1,1440000,0,'true','true','true','true','InterludeItem','none'),
(8756,'Top-Grade Life Stone: level 55','false','none',2,'stackable','liquid','none',-1,1728000,0,'true','true','true','true','InterludeItem','none'),
(8757,'Top-Grade Life Stone: level 58','false','none',2,'stackable','liquid','none',-1,2000000,0,'true','true','true','true','InterludeItem','none'),
(8758,'Top-Grade Life Stone: level 61','false','none',2,'stackable','liquid','none',-1,2400000,0,'true','true','true','true','InterludeItem','none'),
(8759,'Top-Grade Life Stone: level 64','false','none',2,'stackable','liquid','none',-1,3000000,0,'true','true','true','true','InterludeItem','none'),
(8760,'Top-Grade Life Stone: level 67','false','none',2,'stackable','liquid','none',-1,3600000,0,'true','true','true','true','InterludeItem','none'),
(8761,'Top-Grade Life Stone: level 70','false','none',2,'stackable','liquid','none',-1,4320000,0,'true','true','true','true','InterludeItem','none'),
(8762,'Top-Grade Life Stone: level 76','false','none',2,'stackable','liquid','none',-1,4800000,0,'true','true','true','true','InterludeItem','none'),
(8764,'Trap Stone','false','quest',2,'stackable','liquid','none',-1,500,0,'true','true','true','true','InterludeItem','none'),
(8765,'Red Gem','false','quest',0,'stackable','crystal','none',-1,0,0,'true','true','true','true','InterludeItem','none'),
(8766,'Spirit Bead','false','quest',0,'stackable','crystal','none',-1,0,0,'true','true','true','true','InterludeItem','none'),
(8767,'Tyrannosaurus Claw','false','quest',0,'stackable','steel','none',-1,0,0,'true','true','true','true','InterludeItem','none'),
(8768,'Diary Fragment','false','quest',0,'stackable','steel','none',-1,0,0,'true','true','true','true','InterludeItem','none'),
(8769,'Expedition Member\'s Letter','false','quest',0,'stackable','steel','none',-1,0,0,'true','true','true','true','InterludeItem','none'),
(8770,'Ornithomimus Claw','false','quest',0,'stackable','steel','none',-1,0,0,'true','true','true','true','InterludeItem','none'),
(8771,'Deinonychus Bone','false','quest',0,'stackable','steel','none',-1,0,0,'true','true','true','true','InterludeItem','none'),
(8772,'Pachycephalosaurus Skin','false','quest',0,'stackable','steel','none',-1,0,0,'true','true','true','true','InterludeItem','none'),
(8773,'Practice Elrokian Trap','false','quest',0,'stackable','steel','none',-1,0,0,'true','true','true','true','InterludeItem','none'),
(8774,'Dinosaur Tissue','false','quest',0,'stackable','steel','none',-1,0,0,'true','true','true','true','InterludeItem','none'),
(8775,'Dinosaur Egg','false','quest',0,'stackable','steel','none',-1,0,0,'true','true','true','true','InterludeItem','none'),
(8776,'Bones of a Plains Dinosaur','false','quest',0,'stackable','steel','none',-1,0,0,'true','true','true','true','InterludeItem','none'),
(8777,'Ancient Creatures and How I Long To Be With Them','false','quest',0,'stackable','steel','none',-1,0,0,'true','true','true','true','InterludeItem','none'),
(8778,'Mantarasa Egg','false','quest',0,'stackable','steel','none',-1,0,0,'true','true','true','true','InterludeItem','none'),
(8779,'Ornithomimus Claw','false','quest',0,'stackable','steel','none',-1,0,0,'true','true','true','true','InterludeItem','none'),
(8780,'Deinonychus Bone Fragment','false','quest',0,'stackable','steel','none',-1,0,0,'true','true','true','true','InterludeItem','none'),
(8781,'Epitaph of Wisdom','false','quest',0,'stackable','steel','none',-1,0,0,'true','true','true','true','InterludeItem','none'),
(8782,'Gazkh Fragment','false','quest',0,'stackable','steel','none',-1,0,0,'true','true','true','true','InterludeItem','none'),
(8783,'Bone Powder','false','quest',0,'stackable','steel','none',-1,0,0,'true','true','true','true','InterludeItem','none'),
(8784,'Gazkh','false','quest',0,'stackable','steel','none',-1,0,0,'true','true','true','true','InterludeItem','none'),
(8785,'Dinosaur Fang Necklace','false','quest',0,'stackable','steel','none',-1,0,0,'true','true','true','true','InterludeItem','none'),
(8786,'Primeval Potion','false','none',2,'stackable','liquid','none',-1,5000,0,'true','true','true','true','InterludeItem','none'),
(8787,'Sprigant\'s Fruit','false','none',2,'stackable','liquid','none',-1,0,0,'true','true','true','true','InterludeItem','none'),
(8868,'Ziggo\'s Gemstone','false','none',0,'stackable','crystal','none',-1,100000000,0,'true','true','true','true','InterludeItem','none'),
(8869,'Shadow Item Exchange Coupon: D Grade','false','none',0,'stackable','paper','none',-1,0,0,'false','false','true','false','InterludeItem','none'),
(8870,'Shadow Item Exchange Coupon: C Grade','false','none',0,'stackable','paper','none',-1,0,0,'false','false','true','false','InterludeItem','none'),
(8871,'Strategy Guide','false','none',20,'normal','leather','none',-1,45000,0,'true','true','true','true','InterludeItem','none'),
(8872,'Flash Gunpowder','false','none',20,'stackable','liquid','none',-1,0,0,'true','true','true','true','InterludeItem','none'),
(8873,'Phoenix Blood','false','none',20,'stackable','leather','none',-1,20000,0,'true','true','true','true','InterludeItem','none'),
(8874,'Einhasad\'s Holy Water','false','none',20,'stackable','leather','none',-1,20000,0,'true','true','true','true','InterludeItem','none'),
(8875,'Battle Symbol','false','none',20,'stackable','leather','none',-1,20000,0,'true','true','true','true','InterludeItem','none'),
(8876,'Magic Symbol','false','none',20,'stackable','leather','none',-1,20000,0,'true','true','true','true','InterludeItem','none'),
(8877,'Spellbook: Soul of the Phoenix','false','spellbook',120,'stackable','paper','none',-1,0,0,'true','true','true','true','InterludeItem','none'),
(8878,'Spellbook: Summon Feline King','false','spellbook',120,'stackable','paper','none',-1,0,0,'true','true','true','true','InterludeItem','none'),
(8879,'Spellbook: Summon Magnus the Unicorn','false','spellbook',120,'stackable','paper','none',-1,0,0,'true','true','true','true','InterludeItem','none'),
(8880,'Spellbook: Summon Spectral Knight','false','spellbook',120,'stackable','paper','none',-1,0,0,'true','true','true','true','InterludeItem','none'),
(8881,'Spellbook: Cleanse','false','spellbook',120,'stackable','paper','none',-1,0,0,'true','true','true','true','InterludeItem','none'),
(8882,'Spellbook: Salvation','false','spellbook',120,'stackable','paper','none',-1,110000,0,'true','true','true','true','InterludeItem','none'),
(8883,'Spellbook: Mystic Immunity','false','spellbook',120,'stackable','paper','none',-1,110000,0,'true','true','true','true','InterludeItem','none'),
(8884,'Spellbook: Spell Turning','false','spellbook',120,'stackable','paper','none',-1,0,0,'true','true','true','true','InterludeItem','none'),
(8885,'Amulet: Magnus'' Chant','false','spellbook',120,'stackable','paper','none',-1,0,0,'true','true','true','true','InterludeItem','none'),
(8886,'Amulet: Victories of Pa''agrio','false','spellbook',120,'stackable','paper','none',-1,0,0,'true','true','true','true','InterludeItem','none'),
(8887,'Amulet: Pa''agrio\'s Emblem','false','spellbook',120,'stackable','paper','none',-1,0,0,'true','true','true','true','InterludeItem','none'),
(8888,'Amulet: Pa''agrio\'s Fist','false','spellbook',120,'stackable','paper','none',-1,110000,0,'true','true','true','true','InterludeItem','none'),
(8889,'Amulet: Gate Chant','false','spellbook',120,'stackable','paper','none',-1,0,0,'true','true','true','true','InterludeItem','none'),
(8890,'Spellbook: Summon Attractive Cubic','false','spellbook',120,'stackable','paper','none',-1,7700,0,'true','true','true','true','InterludeItem','none'),
(8891,'Spellbook: Aura Flash','false','spellbook',120,'stackable','paper','none',-1,6750,0,'true','true','true','true','InterludeItem','none'),
(8892,'Ancient Tactical Manual: Symbol of Defense','false','spellbook',120,'stackable','paper','none',-1,0,0,'true','true','true','true','InterludeItem','none'),
(8893,'Ancient Tactical Manual: Symbol of Noise','false','spellbook',120,'stackable','paper','none',-1,0,0,'true','true','true','true','InterludeItem','none'),
(8894,'Ancient Tactical Manual: Symbol of Resistance','false','spellbook',120,'stackable','paper','none',-1,0,0,'true','true','true','true','InterludeItem','none'),
(8895,'Ancient Tactical Manual: Symbol of Honor','false','spellbook',120,'stackable','paper','none',-1,0,0,'true','true','true','true','InterludeItem','none'),
(8896,'Ancient Tactical Manual: Symbol of Energy','false','spellbook',120,'stackable','paper','none',-1,120000,0,'true','true','true','true','InterludeItem','none'),
(8897,'Ancient Tactical Manual: Symbol of the Sniper','false','spellbook',120,'stackable','paper','none',-1,0,0,'true','true','true','true','InterludeItem','none'),
(8898,'Ancient Tactical Manual: Symbol of the Assassin','false','spellbook',120,'stackable','paper','none',-1,0,0,'true','true','true','true','InterludeItem','none'),
(8899,'Ancient Spellbook: Volcano','false','spellbook',120,'stackable','paper','none',-1,0,0,'true','true','true','true','InterludeItem','none'),
(8900,'Ancient Spellbook: Cyclone','false','spellbook',120,'stackable','paper','none',-1,0,0,'true','true','true','true','InterludeItem','none'),
(8901,'Ancient Spellbook: Raging Waves','false','spellbook',120,'stackable','paper','none',-1,0,0,'true','true','true','true','InterludeItem','none'),
(8902,'Ancient Spellbook: Day of Doom','false','spellbook',120,'stackable','paper','none',-1,0,0,'true','true','true','true','InterludeItem','none'),
(8903,'Ancient Spellbook: Gehenna','false','spellbook',120,'stackable','paper','none',-1,0,0,'true','true','true','true','InterludeItem','none'),
(8904,'Ancient Spellbook: Anti-Summoning Field','false','spellbook',120,'stackable','paper','none',-1,0,0,'true','true','true','true','InterludeItem','none'),
(8905,'Ancient Spellbook: Purification Field','false','spellbook',120,'stackable','paper','none',-1,0,0,'true','true','true','true','InterludeItem','none'),
(8906,'Ancient Spellbook: Miracle','false','spellbook',120,'stackable','paper','none',-1,0,0,'true','true','true','true','InterludeItem','none'),
(8907,'Ancient Spellbook: Flames of Invincibility','false','spellbook',120,'stackable','paper','none',-1,0,0,'true','true','true','true','InterludeItem','none'),
(8908,'Ancient Spellbook: Mass Recharge','false','spellbook',120,'stackable','paper','none',-1,0,0,'true','true','true','true','InterludeItem','none'),
(8909,'Blueprint: Summon Swoop Cannon','false','spellbook',120,'stackable','paper','none',-1,9600,0,'true','true','true','true','InterludeItem','none'),
(8924,'Boat Ticket: Primeval Isle to Rune.','false','none',20,'stackable','paper','none',-1,0,0,'true','true','true','true','InterludeItem','none'),
(8925,'Boat Ticket: Rune to Primeval Isle.','false','none',20,'stackable','paper','none',-1,25000,0,'true','true','true','true','InterludeItem','none'),
(8939,'Dominic\'s Mark','false','quest',0,'stackable','steel','none',-1,0,0,'true','true','true','true','InterludeItem','none'),
(8940,'Mark of the Future: Human','false','quest',0,'stackable','steel','none',-1,0,0,'true','true','true','true','InterludeItem','none'),
(8941,'Mark of the Future: Dwarf','false','quest',0,'stackable','steel','none',-1,0,0,'true','true','true','true','InterludeItem','none'),
(8942,'Mark of the Future: Elf','false','quest',0,'stackable','steel','none',-1,0,0,'true','true','true','true','InterludeItem','none'),
(8943,'Mark of the Future: Dark Elf','false','quest',0,'stackable','steel','none',-1,0,0,'true','true','true','true','InterludeItem','none'),
(8944,'Mark of the Future: Orc','false','quest',0,'stackable','steel','none',-1,0,0,'true','true','true','true','InterludeItem','none'),
(8945,'Spellbook: Celestial Shield','false','spellbook',120,'stackable','paper','none',-1,8100,0,'true','true','true','true','InterludeItem','none'),
(8946,'Spellbook: Invocation','false','spellbook',120,'stackable','paper','none',-1,6250,0,'true','true','true','true','InterludeItem','none'),
(8952,'Greater Herb of Life','false','herb',0,'normal','paper','none',-1,0,0,'true','true','true','true','InterludeItem','none'),
(8953,'Greater Herb of Mana','false','herb',0,'normal','paper','none',-1,0,0,'true','true','true','true','InterludeItem','none'),
(8954,'Blue Primeval Crystal','false','scroll',10,'stackable','paper','s',-1,50000,0,'true','true','true','true','InterludeItem','none'),
(8955,'Green Primeval Crystal','false','scroll',10,'stackable','paper','s',-1,100000,0,'true','true','true','true','InterludeItem','none'),
(8956,'Red Primeval Crystal','false','scroll',10,'stackable','paper','s',-1,200000,0,'true','true','true','true','InterludeItem','none'),
(8957,'Attack Orders','false','none',1,'stackable','paper','none',-1,0,0,'true','true','true','true','InterludeItem','none'),
(8958,'Defense Orders','false','none',1,'stackable','paper','none',-1,0,0,'true','true','true','true','InterludeItem','none'),
(8959,'Supply Orders','false','none',1,'stackable','paper','none',-1,0,0,'true','true','true','true','InterludeItem','none'),
(8960,'No Grade Shadow Armor Set Box','false','none',100,'stackable','paper','none',-1,0,0,'true','true','true','true','InterludeItem','none'),
(8961,'D-Grade Shadow Armor Set Box','false','none',100,'stackable','paper','none',-1,0,0,'true','true','true','true','InterludeItem','none'),
(8962,'C-Grade Shadow Armor Set Box','false','none',100,'stackable','paper','none',-1,0,0,'true','true','true','true','InterludeItem','none'),
(8963,'B-Grade Shadow Armor Set Box','false','none',100,'stackable','paper','none',-1,0,0,'true','true','true','true','InterludeItem','none'),
(8964,'A-Grade Shadow Armor Set Box','false','none',100,'stackable','paper','none',-1,0,0,'true','true','true','true','InterludeItem','none'),
(8965,'S-Grade Shadow Armor Set Box','false','none',100,'stackable','paper','none',-1,0,0,'true','true','true','true','InterludeItem','none'),
(8966,'No Grade Item Set Box (Warrior Use)','false','none',100,'stackable','paper','none',-1,0,0,'true','true','true','true','InterludeItem','none'),
(8967,'D Grade Item Set Box (Warrior Use)','false','none',100,'stackable','paper','none',-1,0,0,'true','true','true','true','InterludeItem','none'),
(8968,'C Grade Item Set Box (Warrior Use)','false','none',100,'stackable','paper','none',-1,0,0,'true','true','true','true','InterludeItem','none'),
(8969,'B Grade Item Set Box (Warrior Use)','false','none',100,'stackable','paper','none',-1,0,0,'true','true','true','true','InterludeItem','none'),
(8970,'A Grade Item Set Box (Warrior Use)','false','none',100,'stackable','paper','none',-1,0,0,'true','true','true','true','InterludeItem','none'),
(8971,'A,S Grade Item Set Box (Warrior Use)','false','none',100,'stackable','paper','none',-1,0,0,'true','true','true','true','InterludeItem','none'),
(9104,'Composite Bow and Wooden Arrow','false','none',100,'stackable','paper','none',-1,0,0,'true','true','true','true','InterludeItem','none'),
(9105,'Gastraphetes and Bone Arrow','false','none',100,'stackable','paper','none',-1,0,0,'true','true','true','true','InterludeItem','none'),
(9106,'Akat Long Bow and Steel Arrow','false','none',100,'stackable','paper','none',-1,0,0,'true','true','true','true','InterludeItem','none'),
(9107,'Dark Elven Long Bow and Silver Arrow','false','none',100,'stackable','paper','none',-1,0,0,'true','true','true','true','InterludeItem','none'),
(9108,'Carnage Bow and Mithril Arrow','false','none',100,'stackable','paper','none',-1,0,0,'true','true','true','true','InterludeItem','none'),
(9109,'Soul Bow and Mithril Arrow','false','none',100,'stackable','paper','none',-1,0,0,'true','true','true','true','InterludeItem','none'),
(9110,'No Grade Shadow Armor Set Box (Heavy Armor Use)','false','none',100,'stackable','paper','none',-1,0,0,'true','true','true','true','InterludeItem','none'),
(9111,'D-Grade Shadow Armor Set Box (Heavy Armor Use)','false','none',100,'stackable','paper','none',-1,0,0,'true','true','true','true','InterludeItem','none'),
(9112,'C-Grade Shadow Armor Set Box (Heavy Armor Use)','false','none',100,'stackable','paper','none',-1,0,0,'true','true','true','true','InterludeItem','none'),
(9113,'B-Grade Shadow Armor Set Box (Heavy Armor Use)','false','none',100,'stackable','paper','none',-1,0,0,'true','true','true','true','InterludeItem','none'),
(9114,'Low A-Grade Shadow Armor Set Box (Heavy Armor Use)','false','none',100,'stackable','paper','none',-1,0,0,'true','true','true','true','InterludeItem','none'),
(9115,'High A-Grade Shadow Armor Set Box (Heavy Armor Use)','false','none',100,'stackable','paper','none',-1,0,0,'true','true','true','true','InterludeItem','none'),
(9116,'No Grade Shadow Armor Set Box (Light Armor Use)','false','none',100,'stackable','paper','none',-1,0,0,'true','true','true','true','InterludeItem','none'),
(9117,'D-Grade Shadow Armor Set Box (Light Armor Use)','false','none',100,'stackable','paper','none',-1,0,0,'true','true','true','true','InterludeItem','none'),
(9118,'C-Grade Shadow Armor Set Box (Light Armor Use)','false','none',100,'stackable','paper','none',-1,0,0,'true','true','true','true','InterludeItem','none'),
(9119,'B-Grade Shadow Armor Set Box (Light Armor Use)','false','none',100,'stackable','paper','none',-1,0,0,'true','true','true','true','InterludeItem','none'),
(9120,'Low A-Grade Shadow Armor Set Box (Light Armor Use)','false','none',100,'stackable','paper','none',-1,0,0,'true','true','true','true','InterludeItem','none'),
(9121,'High A-Grade Shadow Armor Set Box (Light Armor Use)','false','none',100,'stackable','paper','none',-1,0,0,'true','true','true','true','InterludeItem','none'),
(9122,'No Grade Shadow Armor Set Box (Robe Use)','false','none',100,'stackable','paper','none',-1,0,0,'true','true','true','true','InterludeItem','none'),
(9123,'D-Grade Shadow Armor Set Box (Robe Use)','false','none',100,'stackable','paper','none',-1,0,0,'true','true','true','true','InterludeItem','none'),
(9124,'C-Grade Shadow Armor Set Box (Robe Use)','false','none',100,'stackable','paper','none',-1,0,0,'true','true','true','true','InterludeItem','none'),
(9125,'B-Grade Shadow Armor Set Box (Robe Use)','false','none',100,'stackable','paper','none',-1,0,0,'true','true','true','true','InterludeItem','none'),
(9126,'Low A-Grade Shadow Armor Set Box (Robe Use)','false','none',100,'stackable','paper','none',-1,0,0,'true','true','true','true','InterludeItem','none'),
(9127,'High A-Grade Shadow Armor Set Box (Robe Use)','false','none',100,'stackable','paper','none',-1,0,0,'true','true','true','true','InterludeItem','none'),
(9130,'No Grade Item Set Box (Magic Use)','false','none',100,'stackable','paper','none',-1,0,0,'true','true','true','true','InterludeItem','none'),
(9131,'D Grade Item Set Box (Magic Use)','false','none',100,'stackable','paper','none',-1,0,0,'true','true','true','true','InterludeItem','none'),
(9132,'C Grade Item Set Box (Magic Use)','false','none',100,'stackable','paper','none',-1,0,0,'true','true','true','true','InterludeItem','none'),
(9133,'B Grade Item Set Box (Magic Use)','false','none',100,'stackable','paper','none',-1,0,0,'true','true','true','true','InterludeItem','none'),
(9134,'A Grade Item Set Box (Magic Use)','false','none',100,'stackable','paper','none',-1,0,0,'true','true','true','true','InterludeItem','none'),
(9135,'A,S Grade Item Set Box (Magic Use)','false','none',100,'stackable','paper','none',-1,0,0,'true','true','true','true','InterludeItem','none'),
(9139,'Santa\'s Hat','false','none',10,'normal','paper','none',-1,0,0,'true','true','true','true','InterludeItem','none'),
(9142,'Apiga','false','none',0,'stackable','paper','none',-1,0,0,'true','true','true','true','InterludeItem','none'),
(9143,'Golden Apiga','false','none',0,'stackable','paper','none',-1,0,0,'false','false','true','false','InterludeItem','none'),
(9144,'Pirate\'s Booty','false','none',100,'stackable','paper','none',-1,0,0,'true','true','true','true','InterludeItem','none'),
(9146,'Scroll of Guidance (Event)','false','scroll',120,'stackable','paper','none',-1,0,0,'true','true','true','true','InterludeItem','none'),
(9147,'Scroll of Death Whisper (Event)','false','scroll',120,'stackable','paper','none',-1,0,0,'true','true','true','true','InterludeItem','none'),
(9148,'Scroll of Focus (Event)','false','scroll',120,'stackable','paper','none',-1,0,0,'true','true','true','true','InterludeItem','none'),
(9149,'Scroll of Acumen (Event)','false','scroll',120,'stackable','paper','none',-1,0,0,'true','true','true','true','InterludeItem','none'),
(9150,'Scroll of Haste (Event)','false','scroll',120,'stackable','paper','none',-1,0,0,'true','true','true','true','InterludeItem','none'),
(9151,'Scroll of Agility (Event)','false','scroll',120,'stackable','paper','none',-1,0,0,'true','true','true','true','InterludeItem','none'),
(9152,'Scroll of Empower (Event)','false','scroll',120,'stackable','paper','none',-1,0,0,'true','true','true','true','InterludeItem','none'),
(9153,'Scroll of Might (Event)','false','scroll',120,'stackable','paper','none',-1,0,0,'true','true','true','true','InterludeItem','none'),
(9154,'Scroll of Wind Walk (Event)','false','scroll',120,'stackable','paper','none',-1,0,0,'true','true','true','true','InterludeItem','none'),
(9155,'Scroll of Shield (Event)','false','scroll',120,'stackable','paper','none',-1,0,0,'true','true','true','true','InterludeItem','none'),
(9156,'Blessed Scroll of Escape (Event)','false','scroll',120,'stackable','paper','none',-1,0,0,'true','true','true','true','InterludeItem','none'),
(9157,'Blessed Scroll of Resurrection (Event)','false','scroll',120,'stackable','paper','none',-1,0,0,'true','true','true','true','InterludeItem','none'),
(9161,'Santa\'s Antlers','false','none',10,'normal','paper','none',-1,0,0,'true','true','true','true','InterludeItem','none'),
(9162,'Red Philosopher\'s Stone Transmutation Circle','false','recipe',10,'stackable','liquid','none',-1,0,0,'true','true','true','true','InterludeItem','none'),
(9163,'Blue Philosopher\'s Stone Transmutation Circle','false','recipe',10,'stackable','liquid','none',-1,0,0,'true','true','true','true','InterludeItem','none'),
(9164,'Orange Philosopher\'s Stone Transmutation Circle','false','recipe',10,'stackable','liquid','none',-1,0,0,'true','true','true','true','InterludeItem','none'),
(9165,'Black Philosopher\'s Stone Transmutation Circle','false','recipe',10,'stackable','liquid','none',-1,0,0,'true','true','true','true','InterludeItem','none'),
(9166,'White Philosopher\'s Stone Transmutation Circle','false','recipe',10,'stackable','liquid','none',-1,0,0,'true','true','true','true','InterludeItem','none'),
(9167,'Green Philosopher\'s Stone Transmutation Circle','false','recipe',10,'stackable','liquid','none',-1,0,0,'true','true','true','true','InterludeItem','none'),
(9168,'Philosopher\'s Stone Ore','false','material',2,'stackable','liquid','none',-1,0,0,'true','true','true','true','InterludeItem','none'),
(9169,'Philosopher\'s Stone Conversion Formula','false','material',2,'stackable','liquid','none',-1,0,0,'true','true','true','true','InterludeItem','none'),
(9170,'Magic Reagents','false','material',2,'stackable','liquid','none',-1,0,0,'true','true','true','true','InterludeItem','none'),
(9171,'Red Philosopher\'s Stone','false','none',20,'stackable','paper','none',-1,0,0,'true','true','true','true','InterludeItem','none'),
(9172,'Blue Philosopher\'s Stone','false','none',20,'stackable','paper','none',-1,0,0,'true','true','true','true','InterludeItem','none'),
(9173,'Orange Philosopher\'s Stone','false','none',20,'stackable','paper','none',-1,0,0,'true','true','true','true','InterludeItem','none'),
(9174,'Black Philosopher\'s Stone','false','none',20,'stackable','paper','none',-1,0,0,'true','true','true','true','InterludeItem','none'),
(9175,'White Philosopher\'s Stone','false','none',20,'stackable','paper','none',-1,0,0,'true','true','true','true','InterludeItem','none'),
(9176,'Green Philosopher\'s Stone','false','none',20,'stackable','paper','none',-1,0,0,'true','true','true','true','InterludeItem','none'),
(9205,'Alchemist\'s Chest Key','false','none',10,'stackable','liquid','none',-1,0,0,'true','true','true','true','InterludeItem','none'),
(9206,'Greater Healing Potion (Event)','false','potion',5,'stackable','liquid','none',-1,0,0,'true','true','true','true','InterludeItem','none'),
(9207,'Quick Healing Potion (Event)','false','potion',5,'stackable','liquid','none',-1,0,0,'true','true','true','true','InterludeItem','none'),
(9451,'Dynastic Essence','false','none',60,'stackable','wood','none',-1,0,NULL,'true','true','true','true','',''),
(9482,'Recipe: Sealed Dynasty Blast Plate (60%)','false','none',30,'stackable','wood','none',-1,0,NULL,'true','true','true','true','',''),
(9483,'Recipe: Sealed Dynasty Gaiter (60%)','false','none',30,'stackable','wood','none',-1,0,NULL,'true','true','true','true','',''),
(9484,'Recipe: Sealed Dynasty Helmet (60%)','false','none',30,'stackable','wood','none',-1,0,NULL,'true','true','true','true','',''),
(9485,'Recipe: Sealed Dynasty Gauntlet (60%)','false','none',30,'stackable','wood','none',-1,0,NULL,'true','true','true','true','',''),
(9486,'Recipe: Sealed Dynasty Boots (60%)','false','none',30,'stackable','wood','none',-1,0,NULL,'true','true','true','true','',''),
(9487,'Recipe: Sealed Dynasty Leather Armor (60%)','false','none',30,'stackable','wood','none',-1,0,NULL,'true','true','true','true','',''),
(9488,'Recipe: Sealed Dynasty Leather Leggings (60%)','false','none',30,'stackable','wood','none',-1,0,NULL,'true','true','true','true','',''),
(9489,'Recipe: Sealed Dynasty Leather Helmet (60%)','false','none',30,'stackable','wood','none',-1,0,NULL,'true','true','true','true','',''),
(9490,'Recipe: Sealed Dynasty Leather Gloves (60%)','false','none',30,'stackable','wood','none',-1,0,NULL,'true','true','true','true','',''),
(9491,'Recipe: Sealed Dynasty Leather Boots (60%)','false','none',30,'stackable','wood','none',-1,0,NULL,'true','true','true','true','',''),
(9492,'Recipe: Sealed Dynasty Tunic (60%)','false','none',30,'stackable','wood','none',-1,0,NULL,'true','true','true','true','',''),
(9493,'Recipe: Sealed Dynasty Stockings (60%)','false','none',30,'stackable','wood','none',-1,0,NULL,'true','true','true','true','',''),
(9494,'Recipe: Sealed Dynasty Circlet (60%)','false','none',30,'stackable','wood','none',-1,0,NULL,'true','true','true','true','',''),
(9495,'Recipe: Sealed Dynasty Gloves (60%)','false','none',30,'stackable','wood','none',-1,0,NULL,'true','true','true','true','',''),
(9496,'Recipe: Sealed Dynasty Shoes (60%)','false','none',30,'stackable','wood','none',-1,0,NULL,'true','true','true','true','',''),
(9497,'Recipe: Sealed Dynasty Shield (60%)','false','none',30,'stackable','wood','none',-1,0,NULL,'true','true','true','true','',''),
(9498,'Recipe: Sealed Dynasty Blast Plate (100%)','false','none',30,'stackable','wood','none',-1,0,NULL,'true','true','true','true','',''),
(9499,'Recipe: Sealed Dynasty Gaiter (100%)','false','none',30,'stackable','wood','none',-1,0,NULL,'true','true','true','true','',''),
(9500,'Recipe: Sealed Dynasty Helmet (100%)','false','none',30,'stackable','wood','none',-1,0,NULL,'true','true','true','true','',''),
(9501,'Recipe: Sealed Dynasty Gauntlet (100%)','false','none',30,'stackable','wood','none',-1,0,NULL,'true','true','true','true','',''),
(9502,'Recipe: Sealed Dynasty Boots (100%)','false','none',30,'stackable','wood','none',-1,0,NULL,'true','true','true','true','',''),
(9503,'Recipe: Sealed Dynasty Leather Armor (100%)','false','none',30,'stackable','wood','none',-1,0,NULL,'true','true','true','true','',''),
(9504,'Recipe: Sealed Dynasty Leather Leggings (100%)','false','none',30,'stackable','wood','none',-1,0,NULL,'true','true','true','true','',''),
(9505,'Recipe: Sealed Dynasty Leather Helmet (100%)','false','none',30,'stackable','wood','none',-1,0,NULL,'true','true','true','true','',''),
(9506,'Recipe: Sealed Dynasty Leather Gloves (100%)','false','none',30,'stackable','wood','none',-1,0,NULL,'true','true','true','true','',''),
(9507,'Recipe: Sealed Dynasty Leather Boots (100%)','false','none',30,'stackable','wood','none',-1,0,NULL,'true','true','true','true','',''),
(9508,'Recipe: Sealed Dynasty Tunic (100%)','false','none',30,'stackable','wood','none',-1,0,NULL,'true','true','true','true','',''),
(9509,'Recipe: Sealed Dynasty Stockings (100%)','false','none',30,'stackable','wood','none',-1,0,NULL,'true','true','true','true','',''),
(9510,'Recipe: Sealed Dynasty Circlet (100%)','false','none',30,'stackable','wood','none',-1,0,NULL,'true','true','true','true','',''),
(9511,'Recipe: Sealed Dynasty Gloves (100%)','false','none',30,'stackable','wood','none',-1,0,NULL,'true','true','true','true','',''),
(9512,'Recipe: Sealed Dynasty Shoes (100%)','false','none',30,'stackable','wood','none',-1,0,NULL,'true','true','true','true','',''),
(9513,'Recipe: Sealed Dynasty Shield (100%)','false','none',30,'stackable','wood','none',-1,0,NULL,'true','true','true','true','',''),
(9530,'Sealed Dynasty Blast Plate Piece','false','none',60,'stackable','wood','none',-1,0,NULL,'true','true','true','true','',''),
(9531,'Sealed Dynasty Gaiter Piece','false','none',60,'stackable','wood','none',-1,0,NULL,'true','true','true','true','',''),
(9532,'Sealed Dynasty Helmet Piece','false','none',60,'stackable','wood','none',-1,0,NULL,'true','true','true','true','',''),
(9533,'Sealed Dynasty Gauntlet Piece','false','none',60,'stackable','wood','none',-1,0,NULL,'true','true','true','true','',''),
(9534,'Sealed Dynasty Boot Piece','false','none',60,'stackable','wood','none',-1,0,NULL,'true','true','true','true','',''),
(9535,'Sealed Dynasty Leather Armor Piece','false','none',60,'stackable','wood','none',-1,0,NULL,'true','true','true','true','',''),
(9536,'Sealed Dynasty Leather L