## Active Perl 5.8.8
use utf8;
use warnings;
use strict;
binmode STDOUT,'encoding(cp932)';

open CSV, '<:utf8', 'temp/castlename-j.txt'  or die $!;
my $mtime = (stat CSV)[9];

open SQL, '>:utf8', 'castlename_ja.sql'  or die $!;
print SQL "--
-- from 'castlename-j.dat'
--
DROP TABLE IF EXISTS castlename_ja;
CREATE TABLE castlename_ja (
	 id INTEGER NOT NULL
	,name VARCHAR(200) DEFAULT ''
	,location VARCHAR(100) DEFAULT ''
	,PRIMARY KEY (id)
) ENGINE=MyISAM DEFAULT CHARSET=utf8;

";

my $count = 0;
my $delim = ' ';
<CSV>; # skip header
while (not eof CSV) {
	my $buf = <CSV>;
	chomp $buf;
	my @field = split /\t/, $buf;
	foreach (@field) {s/^[ua],//; s/\\0//}
	my ($id,$name,$location) = ($field[2],$field[3],$field[4]);
	$name =~ s/^$location //;	#'Af S[f EW''S[f EW'
	$name =~ s/'/''/g;
	$location =~ s/'/''/g;
	print "$id\r";

	if (++$count > 500) {
		print SQL ";\n";
		$count = 1;
	}
	if ($count == 1) {
		print SQL "INSERT INTO castlename_ja (id,name,location) VALUES\n";
		$delim = ' ';
	}
	print SQL $delim,"($id,'$name','$location')\n";
	$delim = ',';
}
print SQL ";\n";
print SQL "
-- Update for Japanese.
-- UPDATE castle,castlename_ja SET
--   castle.name = castlename_ja.name
--  WHERE castle.id = castlename_ja.id;
UPDATE clanhall,castlename_ja SET
  clanhall.name = castlename_ja.name
 ,clanhall.location = castlename_ja.location
 WHERE clanhall.id = castlename_ja.id;

-- DROP TABLE castlename_ja;
";
close SQL;
utime $mtime,$mtime,'castlename_ja.sql';

close CSV;
print "\n";
