## Active Perl 5.8.8
use utf8;
use warnings;
use strict;
binmode STDOUT,'encoding(cp932)';

open CSV, '<:utf8', 'temp/skillname-j.txt'  or die $!;
my $mtime = (stat CSV)[9];

open SQL, '>:utf8', 'skillname_ja.sql'  or die $!;
print SQL "--
-- from 'skillname-j.dat'
--
DROP TABLE IF EXISTS skillname_ja;
CREATE TABLE skillname_ja (
	 id INTEGER NOT NULL
	,level INTEGER NOT NULL
	,name VARCHAR(128) DEFAULT ''
	,PRIMARY KEY (id,level)
) ENGINE=MyISAM DEFAULT CHARSET=utf8;

";

my $count = 0;
my $delim = ' ';
<CSV>; # skip header
while (not eof CSV) {
	my $buf = <CSV>;
	chomp $buf;
	my @field = split /\t/, $buf;
	foreach (@field) {s/^[ua],//; s/\\0//}
	my ($id,$level,$name) = ($field[0],$field[1],$field[2]);
	$name =~ s/'/''/g;
	print "$id\r";

	if (++$count > 500) {
		print SQL ";\n";
		$count = 1;
	}
	if ($count == 1) {
		print SQL "INSERT INTO skillname_ja (id,level,name) VALUES\n";
		$delim = ' ';
	}
	print SQL $delim,"($id,$level,'$name')\n";
	$delim = ',';
}
print SQL ";\n";
print SQL "
-- Update for Japanese.
UPDATE skill_trees,skillname_ja SET
  skill_trees.name = skillname_ja.name
 WHERE skill_trees.skill_id = skillname_ja.id
   AND skill_trees.level = skillname_ja.level;

-- DROP TABLE skillname_ja;
";
close SQL;
utime $mtime,$mtime,'skillname_ja.sql';

close CSV;
print "\n";
