--
-- Table structure for table `npc`
-- 
DROP TABLE IF EXISTS `npc`;
CREATE TABLE `npc`(
  `id` decimal(11,0) NOT NULL default '0',
  `idTemplate` int(11) NOT NULL default '0',
  `name` varchar(200) default NULL,
  `serverSideName` int(1) default '0',
  `title` varchar(45) default '',
  `serverSideTitle` int(1) default '0',
  `class` varchar(200) default NULL,
  `collision_radius` decimal(5,2) default NULL,
  `collision_height` decimal(5,2) default NULL,
  `level` decimal(2,0) default NULL,
  `sex` varchar(6) default NULL,
  `type` varchar(20) default NULL,
  `attackrange` int(11) default NULL,
  `hp` decimal(8,0) default NULL,
  `mp` decimal(6,0) default NULL,
  `hpreg` decimal(8,2) default NULL,
  `mpreg` decimal(5,2) default NULL,
  `str` decimal(7,0) default NULL,
  `con` decimal(7,0) default NULL,
  `dex` decimal(7,0) default NULL,
  `int` decimal(7,0) default NULL,
  `wit` decimal(7,0) default NULL,
  `men` decimal(7,0) default NULL,
  `exp` decimal(9,0) default NULL,
  `sp` decimal(8,0) default NULL,
  `patk` decimal(5,0) default NULL,
  `pdef` decimal(5,0) default NULL,
  `matk` decimal(5,0) default NULL,
  `mdef` decimal(5,0) default NULL,
  `atkspd` decimal(3,0) default NULL,
  `aggro` decimal(6,0) default NULL,
  `matkspd` decimal(4,0) default NULL,
  `rhand` decimal(5,0) default NULL,
  `lhand` decimal(5,0) default NULL,
  `armor` decimal(1,0) default NULL,
  `walkspd` decimal(3,0) default NULL,
  `runspd` decimal(3,0) default NULL,
  `faction_id` varchar(40) default NULL,
  `faction_range` decimal(4,0) default NULL,
  `isUndead` int(11) default 0,
  `absorb_level` decimal(2,0) default 0,
  `absorb_type` enum('FULL_PARTY','LAST_HIT','PARTY_ONE_RANDOM') DEFAULT 'LAST_HIT' NOT NULL,
  `ss` int(4) default 0,
  `bss` int(4) default 0,
  `ss_rate` int(3) default 0,
  `AI` varchar(8) default "fighter",
  PRIMARY KEY (`id`)
) ENGINE=MyISAM DEFAULT CHARSET=utf8;
-- 
-- Dumping data for table `npc`
-- 
INSERT INTO `npc` VALUES
(12077, 12077, "Wolf", 0, "", 0, "Monster.pet_wolf", 13, 11.5, 15, "male", "L2Pet", 40, 195, 164, 3.95, 1.21, 40, 43, 30, 21, 20, 25, 0, 0, 9, 19, 3, 17, 304, 0, 333, 3907, 0, 0, 24, 125, "NULL", 0, 0, 0, "LAST_HIT", 0, 0, 0, "fighter"),
(12311, 12311, "Hatchling of the Wind", 0, "", 0, "Monster.hatchling", 9, 10, 35, "male", "L2Pet", 40, 610, 433, 7.11, 1.84, 40, 43, 30, 21, 20, 25, 0, 0, 48, 42, 22, 39, 278, 0, 333, 0, 0, 0, 80, 140, "NULL", 0, 0, 0, "LAST_HIT", 0, 0, 0, "fighter"),
(12312, 12312, "Hatchling of the Stars", 0, "", 0, "Monster.hatchling", 9, 10, 35, "male", "L2Pet", 40, 610, 433, 7.11, 1.84, 40, 43, 30, 21, 20, 25, 0, 0, 48, 42, 22, 39, 278, 0, 333, 0, 0, 0, 80, 140, "NULL", 0, 0, 0, "LAST_HIT", 0, 0, 0, "fighter"),
(12313, 12313, "Hatchling of Twilight", 0, "", 0, "Monster.hatchling", 9, 10, 35, "male", "L2Pet", 40, 610, 433, 7.11, 1.84, 40, 43, 30, 21, 20, 25, 0, 0, 48, 42, 22, 39, 282, 0, 333, 0, 0, 0, 88, 154, "NULL", 0, 0, 0, "LAST_HIT", 0, 0, 0, "fighter"),
(12526, 12526, "Wind Strider", 0, "", 0, "Monster.strider", 23, 31, 55, "male", "L2Pet", 40, 2728, 1138, 10.27, 2.45, 40, 43, 30, 21, 20, 25, 0, 0, 703, 332, 360, 301, 304, 0, 333, 5178, 0, 0, 80, 170, "NULL", 0, 0, 0, "LAST_HIT", 0, 0, 0, "fighter"),
(12527, 12527, "Star Strider", 0, "", 0, "Monster.strider", 23, 31, 55, "male", "L2Pet", 40, 2728, 1138, 10.27, 2.45, 40, 43, 30, 21, 20, 25, 0, 0, 703, 332, 360, 301, 282, 0, 333, 0, 0, 0, 88, 187, "NULL", 0, 0, 0, "LAST_HIT", 0, 0, 0, "fighter"),
(12528, 12528, "Twilight Strider", 0, "", 0, "Monster.strider", 23, 31, 55, "male", "L2Pet", 40, 2728, 1138, 10.27, 2.45, 40, 43, 30, 21, 20, 25, 0, 0, 703, 332, 360, 301, 278, 0, 333, 0, 0, 0, 80, 170, "NULL", 0, 0, 0, "LAST_HIT", 0, 0, 0, "fighter"),
(12564, 12564, "Sin Eater", 0, "", 0, "Monster.imp", 10, 24, 15, "male", "L2Monster", 40, 195, 164, 1.15, 1.21, 40, 1, 30, 21, 20, 25, 0, 0, 9, 19, 3, 17, 278, 0, 333, 0, 0, 0, 60, 125, "NULL", 0, 0, 0, "LAST_HIT", 0, 0, 0, "fighter"),
(12621, 12621, "Wyvern", 0, "", 0, "Monster.wyvern", 60, 58, 70, "male", "L2Monster", 40, 3862, 1722, 11.85, 2.78, 40, 43, 30, 21, 20, 25, 0, 0, 1335, 470, 780, 440, 282, 0, 333, 0, 0, 0, 88, 187, "NULL", 0, 0, 0, "LAST_HIT", 0, 0, 0, "fighter"),
(12774, 12774, "Young Squash", 0, "", 0, "NPC.drop_gourd_50_sm", 10, 10.5, 1, "etc", "L2Monster", 40, 158, 0, 1.42, 0, 40, 43, 30, 21, 20, 10, 0, 0, 4, 41, 3, 33, 278, 0, 333, 0, 0, 0, 33, 88, "NULL", 0, 1, 0, "LAST_HIT", 0, 0, 0, "balanced"),
(12775, 12775, "High Quality Squash", 0, "", 0, "NPC.drop_gourd", 20, 21, 1, "etc", "L2Monster", 40, 205, 0, 1.42, 0, 40, 43, 30, 21, 20, 10, 0, 0, 4, 41, 3, 33, 278, 0, 333, 0, 0, 0, 33, 88, "NULL", 0, 1, 0, "LAST_HIT", 0, 0, 0, "balanced"),
(12776, 12776, "Low Quality Squash", 0, "", 0, "NPC.drop_gourd_25_sm", 15, 16, 1, "etc", "L2Monster", 40, 205, 0, 1.42, 0, 40, 43, 30, 21, 20, 10, 0, 0, 4, 41, 3, 33, 278, 0, 333, 0, 0, 0, 33, 88, "NULL", 0, 1, 0, "LAST_HIT", 0, 0, 0, "balanced"),
(12777, 12777, "Large Young Squash", 0, "", 0, "NPC.drop_gourd", 20, 21, 1, "etc", "L2Monster", 40, 158, 0, 1.42, 0, 40, 43, 30, 21, 20, 10, 0, 0, 4, 41, 3, 33, 278, 0, 333, 0, 0, 0, 33, 88, "NULL", 0, 1, 0, "LAST_HIT", 0, 0, 0, "balanced"),
(12778, 12778, "High Quality Large Squash", 0, "", 0, "NPC.drop_gourd_50_bi", 30, 31.5, 1, "etc", "L2Monster", 40, 205, 0, 1.42, 0, 40, 43, 30, 21, 20, 10, 0, 0, 4, 41, 3, 33, 278, 0, 333, 0, 0, 0, 33, 88, "NULL", 0, 1, 0, "LAST_HIT", 0, 0, 0, "balanced"),
(12779, 12779, "Low Quality Large Squash", 0, "", 0, "NPC.drop_gourd_25_bi", 25, 26.5, 1, "etc", "L2Monster", 40, 205, 0, 1.42, 0, 40, 43, 30, 21, 20, 10, 0, 0, 4, 41, 3, 33, 278, 0, 333, 0, 0, 0, 33, 88, "NULL", 0, 1, 0, "LAST_HIT", 0, 0, 0, "balanced"),
(12780, 12780, "Baby Buffalo", 0, "", 0, "Monster2.baby_buffalo", 12, 15, 25, "male", "L2BabyPet", 40, 751, 331, 2.37, 1.53, 40, 43, 30, 21, 20, 25, 0, 0, 88, 119, 37, 112, 282, 0, 333, 0, 0, 0, 33, 132, "NULL", 0, 0, 0, "LAST_HIT", 0, 0, 0, "fighter"),
(12781, 12781, "Baby Kookaburra", 0, "", 0, "Monster2.baby_ostrich", 7, 15, 25, "male", "L2BabyPet", 40, 751, 331, 2.37, 1.53, 40, 43, 30, 21, 20, 25, 0, 0, 88, 119, 37, 112, 282, 0, 333, 0, 0, 0, 14, 132, "NULL", 0, 0, 0, "LAST_HIT", 0, 0, 0, "fighter"),
(12782, 12782, "Baby Cougar", 0, "", 0, "Monster2.baby_tiger", 11, 15.7, 25, "male", "L2BabyPet", 40, 751, 331, 2.37, 1.53, 40, 43, 30, 21, 20, 25, 0, 0, 88, 119, 37, 112, 278, 0, 333, 0, 0, 0, 28, 120, "NULL", 0, 0, 0, "LAST_HIT", 0, 0, 0, "fighter"),
(13001, 13001, "Heart of Warding", 0, "", 0, "NPC.heart_of_warding", 17, 75, 70, "etc", "L2Npc", 40, 3862, 1493, 11.85, 2.78, 40, 43, 30, 21, 20, 10, 490, 10, 1314, 470, 780, 382, 282, 0, 333, 0, 0, 0, 55, 132, "NULL", 0, 1, 0, "LAST_HIT", 0, 0, 0, "fighter"),
(13002, 13002, "Life Control Tower", 0, "", 0, "NPC.broadcasting_tower", 13, 54, 20, "etc", "L2ControlTower", 40, 541, 213, 3.95, 1.21, 40, 43, 30, 21, 20, 10, 40, 10, 57, 94, 23, 76, 282, 0, 333, 0, 0, 0, 55, 0, "NULL", 0, 1, 0, "LAST_HIT", 0, 0, 0, "fighter"),
(13003, 13003, "Life Control Tower", 0, "", 0, "NPC.dead_castle_aden_controltower_jewel", 7, 35, 20, "etc", "L2ControlTower", 40, 541, 213, 3.95, 1.21, 40, 43, 30, 21, 20, 10, 40, 10, 57, 94, 23, 76, 282, 0, 333, 0, 0, 0, 55, 0, "NULL", 0, 1, 0, "LAST_HIT", 0, 0, 0, "fighter"),
(13004, 13004, "Flame Control Tower", 0, "", 0, "NPC.broadcasting_tower", 13, 54, 20, "etc", "L2Npc", 40, 541, 213, 3.95, 1.21, 40, 43, 30, 21, 20, 10, 40, 10, 57, 94, 23, 76, 282, 0, 333, 0, 0, 0, 55, 0, "NULL", 0, 1, 0, "LAST_HIT", 0, 0, 0, "fighter"),
(13005, 13005, "Flame Control Tower", 0, "", 0, "NPC.dead_castle_aden_controltower_jewel", 7, 35, 20, "etc", "L2Npc", 40, 541, 213, 3.95, 1.21, 40, 43, 30, 21, 20, 10, 40, 10, 57, 94, 23, 76, 282, 0, 333, 0, 0, 0, 55, 0, "NULL", 0, 1, 0, "LAST_HIT", 0, 0, 0, "fighter"),
(13006, 13006, "Christmas Tree", 0, "", 0, "Deco.x_mas_tree", 0.01, 0.01, 70, "male", "L2Npc", 40, 3862, 1493, 11.85, 2.78, 40, 43, 30, 21, 20, 10, 490, 10, 1335, 470, 780, 382, 278, 0, 333, 0, 0, 0, 30, 120, "NULL", 0, 0, 0, "LAST_HIT", 0, 0, 0, "fighter"),
(13007, 13007, "Special Christmas Tree", 0, "", 0, "Deco.x_mas_tree_50_bi", 0, 0, 70, "male", "L2Npc", 40, 3862, 1493, 11.85, 2.78, 40, 43, 30, 21, 20, 10, 490, 10, 1335, 470, 780, 382, 278, 0, 333, 0, 0, 0, 33, 132, "NULL", 0, 0, 0, "LAST_HIT", 0, 0, 0, "fighter"),
(13014, 13014, " ", 0, "", 0, "NPC.clear_npc", 0.1, 0.1, 70, "male", "L2Npc", 40, 3862, 1493, 11.85, 2.78, 40, 43, 30, 21, 20, 10, 0, 0, 1314, 470, 780, 382, 278, 0, 333, 0, 0, 0, 88, 132, "NULL", 0, 0, 0, "LAST_HIT", 0, 0, 0, "fighter"),
(13015, 13015, "", 0, "", 0, "Monster3.Evilate_weather", 20, 31, 70, "male", "L2Npc", 40, 3862, 1493, 11.85, 2.78, 40, 43, 30, 21, 20, 10, 0, 0, 1314, 470, 780, 382, 278, 0, 333, 0, 0, 0, 88, 132, "NULL", 0, 0, 0, "LAST_HIT", 0, 0, 0, "fighter"),
(13016, 13016, "King Squash", 0, "", 0, "NPC.drop_gourd", 24, 40, 1, "male", "L2Monster", 40, 4608, 1896, 80.58, 3.09, 40, 43, 30, 21, 20, 10, 7133, 810, 2255, 534, 1731, 433, 278, 0, 333, 0, 0, 0, 40, 176, "NULL", 0, 0, 0, "LAST_HIT", 0, 0, 0, "balanced"),
(13017, 13017, "Emperor Squash", 0, "", 0, "NPC.drop_gourd_50_bi", 24, 40, 1, "male", "L2Monster", 40, 4608, 1896, 80.58, 3.09, 40, 43, 30, 21, 20, 10, 7557, 858, 2255, 534, 1731, 433, 278, 0, 333, 0, 0, 0, 40, 176, "NULL", 0, 0, 0, "LAST_HIT", 0, 0, 0, "balanced"),
(13018, 13018, "", 0, "", 0, "NPC2.skill_dummy_00_a", 5, 10, 70, "male", "L2EffectPoint", 40, 3862, 1493, 11.85, 2.78, 40, 43, 30, 21, 20, 10, 0, 0, 1314, 470, 780, 382, 278, 0, 333, 0, 0, 0, 88, 132, "NULL", 0, 0, 0, "LAST_HIT", 0, 0, 0, "fighter"),
(13019, 13019, "", 0, "", 0, "NPC2.skill_dummy_00_a", 5, 10, 70, "male", "L2EffectPoint", 40, 3862, 1493, 11.85, 2.78, 40, 43, 30, 21, 20, 10, 0, 0, 1314, 470, 780, 382, 278, 0, 333, 0, 0, 0, 88, 132, "NULL", 0, 0, 0, "LAST_HIT", 0, 0, 0, "fighter"),
(13020, 13020, "", 0, "", 0, "NPC2.skill_dummy_00_a", 5, 10, 70, "male", "L2EffectPoint", 40, 3862, 1493, 11.85, 2.78, 40, 43, 30, 21, 20, 10, 0, 0, 1314, 470, 780, 382, 278, 0, 333, 0, 0, 0, 88, 132, "NULL", 0, 0, 0, "LAST_HIT", 0, 0, 0, "fighter"),
(13021, 13021, "", 0, "", 0, "NPC2.skill_dummy_00_a", 5, 10, 70, "male", "L2EffectPoint", 40, 3862, 1493, 11.85, 2.78, 40, 43, 30, 21, 20, 10, 0, 0, 1314, 470, 780, 382, 278, 0, 333, 0, 0, 0, 88, 132, "NULL", 0, 0, 0, "LAST_HIT", 0, 0, 0, "fighter"),
(13022, 13022, "", 0, "", 0, "NPC2.skill_dummy_00_a", 5, 10, 70, "male", "L2EffectPoint", 40, 3862, 1493, 11.85, 2.78, 40, 43, 30, 21, 20, 10, 0, 0, 1314, 470, 780, 382, 278, 0, 333, 0, 0, 0, 88, 132, "NULL", 0, 0, 0, "LAST_HIT", 0, 0, 0, "fighter"),
(13023, 13023, "", 0, "", 0, "NPC2.skill_dummy_00_a", 5, 10, 70, "male", "L2EffectPoint", 40, 3862, 1493, 11.85, 2.78, 40, 43, 30, 21, 20, 10, 0, 0, 1314, 470, 780, 382, 278, 0, 333, 0, 0, 0, 88, 132, "NULL", 0, 0, 0, "LAST_HIT", 0, 0, 0, "fighter"),
(13024, 13024, "", 0, "", 0, "NPC2.skill_dummy_00_a", 5, 10, 70, "male", "L2EffectPoint", 40, 3862, 1493, 11.85, 2.78, 40, 43, 30, 21, 20, 10, 0, 0, 1314, 470, 780, 382, 278, 0, 333, 0, 0, 0, 88, 132, "NULL", 0, 0, 0, "LAST_HIT", 0, 0, 0, "fighter"),
(13025, 13025, "", 0, "", 0, "NPC2.skill_dummy_01_a", 5, 10, 70, "male", "L2EffectPoint", 40, 3862, 1493, 11.85, 2.78, 40, 43, 30, 21, 20, 10, 0, 0, 1314, 470, 780, 382, 278, 0, 333, 0, 0, 0, 88, 132, "NULL", 0, 0, 0, "LAST_HIT", 0, 0, 0, "fighter"),
(13026, 13026, "", 0, "", 0, "NPC2.skill_dummy_01_a", 5, 10, 70, "male", "L2EffectPoint", 40, 3862, 1493, 11.85, 2.78, 40, 43, 30, 21, 20, 10, 0, 0, 1314, 470, 780, 382, 278, 0, 333, 0, 0, 0, 88, 132, "NULL", 0, 0, 0, "LAST_HIT", 0, 0, 0, "fighter"),
(13027, 13027, "", 0, "", 0, "NPC2.skill_dummy_01_a", 5, 10, 70, "male", "L2EffectPoint", 40, 3862, 1493, 11.85, 2.78, 40, 43, 30, 21, 20, 10, 0, 0, 1314, 470, 780, 382, 278, 0, 333, 0, 0, 0, 88, 132, "NULL", 0, 0, 0, "LAST_HIT", 0, 0, 0, "fighter"),
(13028, 13028, "", 0, "", 0, "NPC2.skill_dummy_01_a", 5, 10, 70, "male", "L2EffectPoint", 40, 3862, 1493, 11.85, 2.78, 40, 43, 30, 21, 20, 10, 0, 0, 1314, 470, 780, 382, 278, 0, 333, 0, 0, 0, 88, 132, "NULL", 0, 0, 0, "LAST_HIT", 0, 0, 0, "fighter"),
(13029, 13029, "", 0, "", 0, "NPC2.skill_dummy_01_a", 5, 10, 70, "male", "L2EffectPoint", 40, 3862, 1493, 11.85, 2.78, 40, 43, 30, 21, 20, 10, 0, 0, 1314, 470, 780, 382, 278, 0, 333, 0, 0, 0, 88, 132, "NULL", 0, 0, 0, "LAST_HIT", 0, 0, 0, "fighter"),
(13030, 13030, "", 0, "", 0, "NPC2.skill_dummy_01_a", 5, 10, 70, "male", "L2EffectPoint", 40, 3862, 1493, 11.85, 2.78, 40, 43, 30, 21, 20, 10, 0, 0, 1314, 470, 780, 382, 278, 0, 333, 0, 0, 0, 88, 132, "NULL", 0, 0, 0, "LAST_HIT", 0, 0, 0, "fighter"),
(13031, 13031, "Huge Pig", 0, "", 0, "NPC2.E_pig_ball", 5.5, 5.25, 70, "male", "L2Npc", 40, 3862, 1493, 11.85, 2.78, 40, 43, 30, 21, 20, 10, 0, 0, 1314, 470, 780, 382, 278, 0, 333, 0, 0, 0, 88, 132, "NULL", 0, 0, 0, "LAST_HIT", 0, 0, 0, "fighter"),
(13032, 13032, "Huge Pig", 0, "", 0, "NPC2.E_pig_ball", 5.5, 5.25, 70, "male", "L2Npc", 40, 3862, 1493, 11.85, 2.78, 40, 43, 30, 21, 20, 10, 0, 0, 1314, 470, 780, 382, 278, 0, 333, 0, 0, 0, 88, 132, "NULL", 0, 0, 0, "LAST_HIT", 0, 0, 0, "fighter"),
(13033, 13033, "Huge Pig", 0, "", 0, "NPC2.E_pig_ball", 5.5, 5.25, 70, "male", "L2Npc", 40, 3862, 1493, 11.85, 2.78, 40, 43, 30, 21, 20, 10, 0, 0, 1314, 470, 780, 382, 278, 0, 333, 0, 0, 0, 88, 132, "NULL", 0, 0, 0, "LAST_HIT", 0, 0, 0, "fighter"),
(13034, 13034, "Super Huge Pig", 0, "", 0, "NPC2.E_pig_ball_H", 29, 38.7, 70, "male", "L2Npc", 40, 3862, 1493, 11.85, 2.78, 40, 43, 30, 21, 20, 10, 0, 0, 1314, 470, 780, 382, 278, 0, 333, 0, 0, 0, 88, 132, "NULL", 0, 0, 0, "LAST_HIT", 0, 0, 0, "fighter"),
(13035, 13035, "Golden Pig", 0, "", 0, "NPC2.E_pig_ball", 5.5, 5.25, 70, "male", "L2Npc", 40, 3862, 1493, 11.85, 2.78, 40, 43, 30, 21, 20, 10, 0, 0, 1314, 470, 780, 382, 278, 0, 333, 0, 0, 0, 88, 132, "NULL", 0, 0, 0, "LAST_HIT", 0, 0, 0, "fighter"),
(13036, 13036, "Alchemist's Chest", 0, "", 0, "LineageMonster.mimic_even", 8.5, 8.5, 1, "male", "L2Npc", 40, 2444, 2444, 0, 0, 40, 43, 30, 21, 35, 25, 0, 0, 500, 500, 500, 500, 253, 0, 253, 0, 0, NULL, 80, 120, "NULL", 0, 0, 0, "LAST_HIT", 0, 0, 0, "balanced"),
(13037, 13037, "Trap", 0, "", 0, "LineageNpc2.trap_mark", 5, 10, 1, "male", "L2Npc", 40, 2444, 2444, 0, 0, 10, 10, 10, 10, 10, 10, 0, 0, 500, 500, 500, 500, 278, 0, 333, 0, 0, NULL, 50, 1, "", 0, 0, 0, "LAST_HIT", 0, 0, 0, "balanced"),
(13038, 13038, "Trap", 0, "", 0, "LineageNpc2.trap_mark", 5, 10, 1, "male", "L2Npc", 40, 2444, 2444, 0, 0, 10, 10, 10, 10, 10, 10, 0, 0, 500, 500, 500, 500, 253, 0, 253, 0, 0, NULL, 0, 0, "", 0, 0, 0, "LAST_HIT", 0, 0, 0, "balanced"),
(13039, 13039, "Trap", 0, "", 0, "LineageNpc2.trap_mark", 5, 10, 1, "male", "L2Npc", 40, 2444, 2444, 0, 0, 10, 10, 10, 10, 10, 10, 0, 0, 500, 500, 500, 500, 253, 0, 253, 0, 0, NULL, 0, 0, "", 0, 0, 0, "LAST_HIT", 0, 0, 0, "balanced"),
(13040, 13040, "Trap", 0, "", 0, "LineageNpc2.trap_mark", 5, 10, 1, "male", "L2Npc", 40, 2444, 2444, 0, 0, 10, 10, 10, 10, 10, 10, 0, 0, 500, 500, 500, 500, 253, 0, 253, 0, 0, NULL, 0, 0, "", 0, 0, 0, "LAST_HIT", 0, 0, 0, "balanced"),
(13041, 13041, "Trap", 0, "", 0, "LineageNpc2.trap_mark", 5, 10, 1, "male", "L2Npc", 40, 2444, 2444, 0, 0, 10, 10, 10, 10, 10, 10, 0, 0, 500, 500, 500, 500, 253, 0, 253, 0, 0, NULL, 0, 0, "", 0, 0, 0, "LAST_HIT", 0, 0, 0, "balanced"),
(13042, 13042, "Trap", 0, "", 0, "LineageNpc2.trap_mark", 5, 10, 1, "male", "L2Npc", 40, 2444, 2444, 0, 0, 10, 10, 10, 10, 10, 10, 0, 0, 500, 500, 500, 500, 253, 0, 253, 0, 0, NULL, 0, 0, "", 0, 0, 0, "LAST_HIT", 0, 0, 0, "balanced"),
(13043, 13043, "Trap", 0, "", 0, "LineageNpc2.trap_mark", 5, 10, 1, "male", "L2Npc", 40, 2444, 2444, 0, 0, 10, 10, 10, 10, 10, 10, 0, 0, 500, 500, 500, 500, 253, 0, 253, 0, 0, NULL, 0, 0, "", 0, 0, 0, "LAST_HIT", 0, 0, 0, "balanced"),
(13044, 13044, "Trap", 0, "", 0, "LineageNpc2.trap_mark", 5, 10, 1, "male", "L2Npc", 40, 2444, 2444, 0, 0, 10, 10, 10, 10, 10, 10, 0, 0, 500, 500, 500, 500, 253, 0, 253, 0, 0, NULL, 0, 0, "", 0, 0, 0, "LAST_HIT", 0, 0, 0, "balanced"),
(13045, 13045, "Trap", 0, "", 0, "LineageNpc2.trap_mark", 5, 10, 1, "male", "L2Npc", 40, 2444, 2444, 0, 0, 10, 10, 10, 10, 10, 10, 0, 0, 500, 500, 500, 500, 253, 0, 253, 0, 0, NULL, 0, 0, "", 0, 0, 0, "LAST_HIT", 0, 0, 0, "balanced"),
(13046, 13046, "Trap", 0, "", 0, "LineageNpc2.trap_mark", 5, 10, 1, "male", "L2Npc", 40, 2444, 2444, 0, 0, 10, 10, 10, 10, 10, 10, 0, 0, 500, 500, 500, 500, 253, 0, 253, 0, 0, NULL, 0, 0, "", 0, 0, 0, "LAST_HIT", 0, 0, 0, "balanced"),
(13047, 13047, "Trap", 0, "", 0, "LineageNpc2.trap_mark", 5, 10, 1, "male", "L2Npc", 40, 2444, 2444, 0, 0, 10, 10, 10, 10, 10, 10, 0, 0, 500, 500, 500, 500, 253, 0, 253, 0, 0, NULL, 0, 0, "", 0, 0, 0, "LAST_HIT", 0, 0, 0, "balanced"),
(13048, 13048, "Trap", 0, "", 0, "LineageNpc2.trap_mark", 5, 10, 1, "male", "L2Npc", 40, 2444, 2444, 0, 0, 10, 10, 10, 10, 10, 10, 0, 0, 500, 500, 500, 500, 253, 0, 253, 0, 0, NULL, 0, 0, "", 0, 0, 0, "LAST_HIT", 0, 0, 0, "balanced"),
(13049, 13049, "Trap", 0, "", 0, "LineageNpc2.trap_mark", 5, 10, 1, "male", "L2Npc", 40, 2444, 2444, 0, 0, 10, 10, 10, 10, 10, 10, 0, 0, 500, 500, 500, 500, 253, 0, 253, 0, 0, NULL, 0, 0, "", 0, 0, 0, "LAST_HIT", 0, 0, 0, "balanced"),
(13050, 13050, "Trap", 0, "", 0, "LineageNpc2.trap_mark", 5, 10, 1, "male", "L2Npc", 40, 2444, 2444, 0, 0, 10, 10, 10, 10, 10, 10, 0, 0, 500, 500, 500, 500, 253, 0, 253, 0, 0, NULL, 0, 0, "", 0, 0, 0, "LAST_HIT", 0, 0, 0, "balanced"),
(13051, 13051, "Trap", 0, "", 0, "LineageNpc2.trap_mark", 5, 10, 1, "male", "L2Npc", 40, 2444, 2444, 0, 0, 10, 10, 10, 10, 10, 10, 0, 0, 500, 500, 500, 500, 253, 0, 253, 0, 0, NULL, 0, 0, "", 0, 0, 0, "LAST_HIT", 0, 0, 0, "balanced"),
(13052, 13052, "Trap", 0, "", 0, "LineageNpc2.trap_mark", 5, 10, 1, "male", "L2Npc", 40, 2444, 2444, 0, 0, 10, 10, 10, 10, 10, 10, 0, 0, 500, 500, 500, 500, 253, 0, 253, 0, 0, NULL, 0, 0, "", 0, 0, 0, "LAST_HIT", 0, 0, 0, "balanced"),
(13053, 13053, "Trap", 0, "", 0, "LineageNpc2.trap_mark", 5, 10, 1, "male", "L2Npc", 40, 2444, 2444, 0, 0, 10, 10, 10, 10, 10, 10, 0, 0, 500, 500, 500, 500, 253, 0, 253, 0, 0, NULL, 0, 0, "", 0, 0, 0, "LAST_HIT", 0, 0, 0, "balanced"),
(13054, 13054, "Trap", 0, "", 0, "LineageNpc2.trap_mark", 5, 10, 1, "male", "L2Npc", 40, 2444, 2444, 0, 0, 10, 10, 10, 10, 10, 10, 0, 0, 500, 500, 500, 500, 253, 0, 253, 0, 0, NULL, 0, 0, "", 0, 0, 0, "LAST_HIT", 0, 0, 0, "balanced"),
(13055, 13055, "Trap", 0, "", 0, "LineageNpc2.trap_mark", 5, 10, 1, "male", "L2Npc", 40, 2444, 2444, 0, 0, 10, 10, 10, 10, 10, 10, 0, 0, 500, 500, 500, 500, 253, 0, 253, 0, 0, NULL, 0, 0, "", 0, 0, 0, "LAST_HIT", 0, 0, 0, "balanced"),
(13056, 13056, "Trap", 0, "", 0, "LineageNpc2.trap_mark", 5, 10, 1, "male", "L2Npc", 40, 2444, 2444, 0, 0, 10, 10, 10, 10, 10, 10, 0, 0, 500, 500, 500, 500, 253, 0, 253, 0, 0, NULL, 0, 0, "", 0, 0, 0, "LAST_HIT", 0, 0, 0, "balanced"),
(13057, 13057, "Trap", 0, "", 0, "LineageNpc2.trap_mark", 5, 10, 1, "male", "L2Npc", 40, 2444, 2444, 0, 0, 10, 10, 10, 10, 10, 10, 0, 0, 500, 500, 500, 500, 253, 0, 253, 0, 0, NULL, 0, 0, "", 0, 0, 0, "LAST_HIT", 0, 0, 0, "balanced"),
(13058, 13058, "Trap", 0, "", 0, "LineageNpc2.trap_mark", 5, 10, 1, "male", "L2Npc", 40, 2444, 2444, 0, 0, 10, 10, 10, 10, 10, 10, 0, 0, 500, 500, 500, 500, 253, 0, 253, 0, 0, NULL, 0, 0, "", 0, 0, 0, "LAST_HIT", 0, 0, 0, "balanced"),
(13059, 13059, "Trap", 0, "", 0, "LineageNpc2.trap_mark", 5, 10, 1, "male", "L2Npc", 40, 2444, 2444, 0, 0, 10, 10, 10, 10, 10, 10, 0, 0, 500, 500, 500, 500, 253, 0, 253, 0, 0, NULL, 0, 0, "", 0, 0, 0, "LAST_HIT", 0, 0, 0, "balanced"),
(13060, 13060, "Trap", 0, "", 0, "LineageNpc2.trap_mark", 5, 10, 1, "male", "L2Npc", 40, 2444, 2444, 0, 0, 10, 10, 10, 10, 10, 10, 0, 0, 500, 500, 500, 500, 253, 0, 253, 0, 0, NULL, 0, 0, "", 0, 0, 0, "LAST_HIT", 0, 0, 0, "balanced"),
(13061, 13061, "Trap", 0, "", 0, "LineageNpc2.trap_mark", 5, 10, 1, "male", "L2Npc", 40, 2444, 2444, 0, 0, 10, 10, 10, 10, 10, 10, 0, 0, 500, 500, 500, 500, 253, 0, 253, 0, 0, NULL, 0, 0, "", 0, 0, 0, "LAST_HIT", 0, 0, 0, "balanced"),
(13062, 13062, "Trap", 0, "", 0, "LineageNpc2.trap_mark", 5, 10, 1, "male", "L2Npc", 40, 2444, 2444, 0, 0, 10, 10, 10, 10, 10, 10, 0, 0, 500, 500, 500, 500, 253, 0, 253, 0, 0, NULL, 0, 0, "", 0, 0, 0, "LAST_HIT", 0, 0, 0, "balanced"),
(13063, 13063, "Trap", 0, "", 0, "LineageNpc2.trap_mark", 5, 10, 1, "male", "L2Npc", 40, 2444, 2444, 0, 0, 10, 10, 10, 10, 10, 10, 0, 0, 500, 500, 500, 500, 253, 0, 253, 0, 0, NULL, 0, 0, "", 0, 0, 0, "LAST_HIT", 0, 0, 0, "balanced"),
(13064, 13064, "Trap", 0, "", 0, "LineageNpc2.trap_mark", 5, 10, 1, "male", "L2Npc", 40, 2444, 2444, 0, 0, 10, 10, 10, 10, 10, 10, 0, 0, 500, 500, 500, 500, 253, 0, 253, 0, 0, NULL, 0, 0, "", 0, 0, 0, "LAST_HIT", 0, 0, 0, "balanced"),
(13065, 13065, "Trap", 0, "", 0, "LineageNpc2.trap_mark", 5, 10, 1, "male", "L2Npc", 40, 2444, 2444, 0, 0, 10, 10, 10, 10, 10, 10, 0, 0, 500, 500, 500, 500, 253, 0, 253, 0, 0, NULL, 0, 0, "", 0, 0, 0, "LAST_HIT", 0, 0, 0, "balanced"),
(13066, 13066, "Trap", 0, "", 0, "LineageNpc2.trap_mark", 5, 10, 1, "male", "L2Npc", 40, 2444, 2444, 0, 0, 10, 10, 10, 10, 10, 10, 0, 0, 500, 500, 500, 500, 253, 0, 253, 0, 0, NULL, 0, 0, "", 0, 0, 0, "LAST_HIT", 0, 0, 0, "balanced"),
(13067, 13067, "Trap", 0, "", 0, "LineageNpc2.trap_mark", 5, 10, 1, "male", "L2Npc", 40, 2444, 2444, 0, 0, 10, 10, 10, 10, 10, 10, 0, 0, 500, 500, 500, 500, 253, 0, 253, 0, 0, NULL, 0, 0, "", 0, 0, 0, "LAST_HIT", 0, 0, 0, "balanced"),
(13068, 13068, "Trap", 0, "", 0, "LineageNpc2.trap_mark", 5, 10, 1, "male", "L2Npc", 40, 2444, 2444, 0, 0, 10, 10, 10, 10, 10, 10, 0, 0, 500, 500, 500, 500, 253, 0, 253, 0, 0, NULL, 0, 0, "", 0, 0, 0, "LAST_HIT", 0, 0, 0, "balanced"),
(13069, 13069, "Trap", 0, "", 0, "LineageNpc2.trap_mark", 5, 10, 1, "male", "L2Npc", 40, 2444, 2444, 0, 0, 10, 10, 10, 10, 10, 10, 0, 0, 500, 500, 500, 500, 253, 0, 253, 0, 0, NULL, 0, 0, "", 0, 0, 0, "LAST_HIT", 0, 0, 0, "balanced"),
(13070, 13070, "Trap", 0, "", 0, "LineageNpc2.trap_mark", 5, 10, 1, "male", "L2Npc", 40, 2444, 2444, 0, 0, 10, 10, 10, 10, 10, 10, 0, 0, 500, 500, 500, 500, 253, 0, 253, 0, 0, NULL, 0, 0, "", 0, 0, 0, "LAST_HIT", 0, 0, 0, "balanced"),
(13071, 13071, "Virtual Image", 0, "", 0, "LineageNPC2.Decoy_Medium", 8.5, 25, 43, "female", "L2Decoy", 40, 1728, 618, 8.69, 2.14, 40, 43, 30, 21, 20, 10, 0, 0, 291, 252, 163, 181, 278, 0, 333, 0, 0, 0, 0, 0, "NULL", 0, 0, 0, "LAST_HIT", 0, 0, 0, "fighter"),
(13072, 13072, "Virtual Image", 0, "", 0, "LineageNPC2.Decoy_Medium", 8.5, 25, 52, "female", "L2Decoy", 40, 2402, 892, 10.27, 2.45, 40, 43, 30, 21, 20, 10, 0, 0, 518, 324, 300, 239, 278, 0, 333, 0, 0, 0, 0, 0, "NULL", 0, 0, 0, "LAST_HIT", 0, 0, 0, "fighter"),
(13073, 13073, "Virtual Image", 0, "", 0, "LineageNPC2.Decoy_Medium", 8.5, 25, 60, "female", "L2Decoy", 40, 3054, 1150, 10.27, 2.45, 40, 43, 30, 21, 20, 10, 0, 0, 860, 368, 478, 299, 278, 0, 333, 0, 0, 0, 0, 0, "NULL", 0, 0, 0, "LAST_HIT", 0, 0, 0, "fighter"),
(13074, 13074, "Virtual Image", 0, "", 0, "LineageNPC2.Decoy_Medium", 8.5, 25, 66, "female", "L2Decoy", 40, 3546, 1353, 47.4, 2.78, 40, 43, 30, 21, 20, 10, 0, 0, 1020, 427, 649, 348, 278, 0, 333, 0, 0, 0, 0, 0, "NULL", 0, 0, 0, "LAST_HIT", 0, 0, 0, "fighter"),
(13075, 13075, "Virtual Image", 0, "", 0, "LineageNPC2.Decoy_Medium", 8.5, 25, 70, "female", "L2Decoy", 40, 3862, 1493, 59.25, 2.78, 40, 43, 30, 21, 20, 10, 0, 0, 1445, 466, 780, 382, 278, 0, 333, 0, 0, 0, 0, 0, "NULL", 0, 0, 0, "LAST_HIT", 0, 0, 0, "fighter"),
(13076, 13076, "Virtual Image", 0, "", 0, "LineageNPC2.Decoy_Medium", 8.5, 25, 74, "female", "L2Decoy", 40, 4158, 1637, 53.72, 3.09, 40, 43, 30, 21, 20, 10, 0, 0, 2312, 481, 921, 416, 278, 0, 333, 0, 0, 0, 50, 1, "NULL", 0, 0, 0, "LAST_HIT", 0, 0, 0, "fighter"),
(13077, 13077, "Onyx Beast", 0, "", 0, "LineageMonster.onyx_beast", 14, 14.5, 1, "male", "L2Npc", 40, 2444, 2444, 0, 0, 10, 10, 10, 10, 10, 10, 0, 0, 500, 500, 500, 500, 253, 0, 253, 0, 0, NULL, 80, 120, "", 0, 0, 0, "LAST_HIT", 0, 0, 0, "balanced"),
(13078, 13078, "Doom Wraith", 0, "", 0, "LineageMonster.death_blader_tr", 8, 22, 1, "male", "L2Npc", 40, 2444, 2444, 0, 0, 10, 10, 10, 10, 10, 10, 0, 0, 500, 500, 500, 500, 253, 0, 253, 1472, 0, NULL, 80, 120, "", 0, 0, 0, "LAST_HIT", 0, 0, 0, "balanced"),
(13079, 13079, "Grail Apostle", 0, "", 0, "LineageMonster3.apostle_grail_tr", 8, 22, 1, "male", "L2Npc", 40, 2444, 2444, 0, 0, 10, 10, 10, 10, 10, 10, 0, 0, 500, 500, 500, 500, 253, 0, 253, 8221, 0, NULL, 80, 120, "", 0, 0, 0, "LAST_HIT", 0, 0, 0, "balanced"),
(13080, 13080, "Grail Apostle", 0, "", 0, "LineageMonster2.apostle_warrior", 8, 22, 1, "male", "L2Npc", 40, 2444, 2444, 0, 0, 10, 10, 10, 10, 10, 10, 0, 0, 500, 500, 500, 500, 253, 0, 253, 8221, 0, NULL, 80, 120, "", 0, 0, 0, "LAST_HIT", 0, 0, 0, "balanced"),
(13081, 13081, "Unicorn", 0, "", 0, "LineageMonster.Unicorn_tr", 8, 22, 1, "male", "L2Npc", 40, 2444, 2444, 0, 0, 10, 10, 10, 10, 10, 10, 0, 0, 500, 500, 500, 500, 253, 0, 253, 0, 0, NULL, 80, 120, "", 0, 0, 0, "LAST_HIT", 0, 0, 0, "balanced"),
(13082, 13082, "Lilim Knight", 0, "", 0, "LineageMonster4.lilim_knight_tr", 8, 22, 1, "male", "L2Npc", 40, 2444, 2444, 0, 0, 10, 10, 10, 10, 10, 10, 0, 0, 500, 500, 500, 500, 253, 0, 253, 0, 0, NULL, 80, 120, "", 0, 0, 0, "LAST_HIT", 0, 0, 0, "balanced"),
(13083, 13083, "Golem Guardian", 0, "", 0, "LineageMonster3.golem_guardian_tr", 8, 22, 1, "male", "L2Npc", 40, 2444, 2444, 0, 0, 10, 10, 10, 10, 10, 10, 0, 0, 500, 500, 500, 500, 253, 0, 253, 5800, 0, NULL, 80, 120, "", 0, 0, 0, "LAST_HIT", 0, 0, 0, "balanced"),
(13084, 13084, "Inferno Drake", 0, "", 0, "LineageMonster2.inferno_drake_tr", 8, 22, 1, "male", "L2Npc", 40, 2444, 2444, 0, 0, 10, 10, 10, 10, 10, 10, 0, 0, 500, 500, 500, 500, 253, 0, 253, 0, 0, NULL, 80, 120, "", 0, 0, 0, "LAST_HIT", 0, 0, 0, "balanced"),
(13085, 13085, "Dragon Bomber", 0, "", 0, "LineageMonster3.antaras_ex_b_tr", 8, 22, 1, "male", "L2Npc", 40, 2444, 2444, 0, 0, 10, 10, 10, 10, 10, 10, 0, 0, 500, 500, 500, 500, 253, 0, 253, 0, 0, NULL, 80, 120, "", 0, 0, 0, "LAST_HIT", 0, 0, 0, "balanced"),
(13086, 13086, "Zariche", 0, "", 0, "LineageMonster4.Avatar_Z", 12, 31.57, 1, "male", "L2Npc", 40, 2444, 2444, 0, 0, 10, 10, 10, 10, 10, 10, 0, 0, 500, 500, 500, 500, 253, 0, 253, 8190, 0, NULL, 80, 120, "", 0, 0, 0, "LAST_HIT", 0, 0, 0, "balanced"),
(13087, 13087, "Akamanah", 0, "", 0, "LineageMonster4.Avatar_A", 10, 32.73, 1, "male", "L2Npc", 40, 2444, 2444, 0, 0, 10, 10, 10, 10, 10, 10, 0, 0, 500, 500, 500, 500, 253, 0, 253, 8689, 0, NULL, 80, 120, "", 0, 0, 0, "LAST_HIT", 0, 0, 0, "balanced"),
(13088, 13088, "Final Form", 0, "", 0, "LineageMonster4.Specular_Form", 9, 38, 1, "male", "L2Npc", 40, 2444, 2444, 0, 0, 10, 10, 10, 10, 10, 10, 0, 0, 500, 500, 500, 500, 253, 0, 253, 0, 0, NULL, 80, 120, "", 0, 0, 0, "LAST_HIT", 0, 0, 0, "balanced"),
(13089, 13089, "Final Form", 0, "", 0, "LineageMonster4.Specular_Form_F", 10, 32.76, 1, "male", "L2Npc", 40, 2444, 2444, 0, 0, 10, 10, 10, 10, 10, 10, 0, 0, 500, 500, 500, 500, 253, 0, 253, 0, 0, NULL, 80, 120, "", 0, 0, 0, "LAST_HIT", 0, 0, 0, "balanced"),
(13090, 13090, "Native", 0, "", 0, "LineageNPC.a_common_peopleC_Mhuman", 8, 23.5, 1, "male", "L2Npc", 40, 2444, 2444, 0, 0, 10, 10, 10, 10, 10, 10, 0, 0, 500, 500, 500, 500, 253, 0, 253, 0, 0, NULL, 80, 120, "", 0, 0, 0, "LAST_HIT", 0, 0, 0, "balanced"),
(13091, 13091, "Yeti", 0, "", 0, "LineageMonster.yeti", 18, 32, 1, "male", "L2Npc", 40, 2444, 2444, 0, 0, 10, 10, 10, 10, 10, 10, 0, 0, 500, 500, 500, 500, 253, 0, 253, 0, 0, NULL, 80, 120, "", 0, 0, 0, "LAST_HIT", 0, 0, 0, "balanced"),
(13092, 13092, "Buffalo", 0, "", 0, "LineageMonster2.buffalo", 22, 31, 1, "male", "L2Npc", 40, 2444, 2444, 0, 0, 10, 10, 10, 10, 10, 10, 0, 0, 500, 500, 500, 500, 253, 0, 253, 0, 0, NULL, 80, 120, "", 0, 0, 0, "LAST_HIT", 0, 0, 0, "balanced"),
(13093, 13093, "Pig", 0, "", 0, "LineageNPC2.E_pig_ball", 15, 18.3, 1, "male", "L2Npc", 40, 2444, 2444, 0, 0, 10, 10, 10, 10, 10, 10, 0, 0, 500, 500, 500, 500, 253, 0, 253, 0, 0, NULL, 80, 120, "", 0, 0, 0, "LAST_HIT", 0, 0, 0, "balanced"),
(13094, 13094, "Zombie", 0, "", 0, "LineageMonster3.zombie_laborer", 11, 24.6, 1, "male", "L2Npc", 40, 2444, 2444, 0, 0, 10, 10, 10, 10, 10, 10, 0, 0, 500, 500, 500, 500, 253, 0, 253, 0, 0, NULL, 80, 120, "", 0, 0, 0, "LAST_HIT", 0, 0, 0, "balanced"),
(13098, 13098, "Event Treasure Chest", 0, "", 0, "Monster.mimic", 2, 6, 1, "male", "L2Npc", 40, 2444, 2444, 0, 0, 10, 10, 10, 10, 10, 10, 0, 0, 500, 500, 500, 500, 253, 0, 253, 0, 0, NULL, 80, 120, "NULL", 0, 0, 0, "LAST_HIT", 0, 0, 0, "balanced");

INSERT INTO `npc` VALUES
(14001, 14001, "Reanimated Man", 0, "", 0, "Monster.skeleton", 11, 25, 46, "male", "L2Pet", 40, 2914, 816, 8.69, 2.14, 40, 43, 30, 21, 20, 25, 0, 0, 482, 245, 202, 230, 278, 0, 333, 0, 0, 0, 66, 154, "NULL", 0, 1, 0, "LAST_HIT", 0, 0, 0, "fighter"),
(14002, 14002, "Reanimated Man", 0, "", 0, "Monster.skeleton", 11, 25, 54, "male", "L2Pet", 40, 3843, 1102, 10.27, 2.45, 40, 43, 30, 21, 20, 25, 0, 0, 763, 313, 339, 293, 278, 0, 333, 0, 0, 0, 66, 154, "NULL", 0, 1, 0, "LAST_HIT", 0, 0, 0, "fighter"),
(14003, 14003, "Reanimated Man", 0, "", 0, "Monster.skeleton", 11, 25, 62, "male", "L2Pet", 40, 4829, 1404, 11.85, 2.78, 40, 43, 30, 21, 20, 25, 0, 0, 1133, 388, 532, 363, 278, 0, 333, 0, 0, 0, 66, 154, "NULL", 0, 1, 0, "LAST_HIT", 0, 0, 0, "fighter"),
(14004, 14004, "Reanimated Man", 0, "", 0, "Monster.skeleton", 11, 25, 66, "male", "L2Pet", 40, 5319, 1561, 11.85, 2.78, 40, 43, 30, 21, 20, 25, 0, 0, 1347, 428, 649, 401, 278, 0, 333, 0, 0, 0, 66, 154, "NULL", 0, 1, 0, "LAST_HIT", 0, 0, 0, "fighter"),
(14005, 14005, "Reanimated Man", 0, "", 0, "Monster.skeleton", 11, 25, 70, "male", "L2Pet", 40, 5793, 1722, 11.85, 2.78, 40, 43, 30, 21, 20, 25, 0, 0, 1577, 470, 780, 440, 278, 0, 333, 0, 0, 0, 66, 154, "NULL", 0, 1, 0, "LAST_HIT", 0, 0, 0, "fighter"),
(14006, 14006, "Reanimated Man", 0, "", 0, "Monster.skeleton", 11, 25, 74, "male", "L2Pet", 40, 6238, 1888, 13.43, 3.09, 40, 43, 30, 21, 20, 25, 0, 0, 1816, 512, 921, 480, 278, 0, 333, 0, 0, 0, 66, 154, "NULL", 0, 1, 0, "LAST_HIT", 0, 0, 0, "fighter"),
(14007, 14007, "Reanimated Man", 0, "", 0, "Monster.skeleton", 11, 25, 76, "male", "L2Pet", 40, 6446, 1972, 13.43, 3.09, 40, 43, 30, 21, 20, 25, 0, 0, 1937, 534, 994, 500, 278, 0, 333, 0, 0, 0, 66, 154, "NULL", 0, 1, 0, "LAST_HIT", 0, 0, 0, "fighter"),
(14008, 14008, "Reanimated Man", 0, "", 0, "Monster.skeleton", 11, 25, 78, "male", "L2Pet", 40, 7085, 2057, 13.43, 3.09, 40, 43, 30, 21, 20, 25, 0, 0, 2068, 555, 1069, 520, 278, 0, 333, 0, 0, 0, 66, 154, "NULL", 0, 1, 0, "LAST_HIT", 0, 0, 0, "fighter"),
(14009, 14009, "Reanimated Man", 0, "", 0, "Monster.skeleton", 11, 25, 78, "male", "L2Pet", 40, 7085, 2057, 13.43, 3.09, 40, 43, 30, 21, 20, 25, 0, 0, 2078, 555, 1069, 520, 278, 0, 333, 0, 0, 0, 66, 154, "NULL", 0, 1, 0, "LAST_HIT", 0, 0, 0, "fighter"),
(14010, 14010, "Reanimated Man", 0, "", 0, "Monster.skeleton", 11, 25, 78, "male", "L2Pet", 40, 7085, 2057, 13.43, 3.09, 40, 43, 30, 21, 20, 25, 0, 0, 2088, 555, 1069, 520, 278, 0, 333, 0, 0, 0, 66, 154, "NULL", 0, 1, 0, "LAST_HIT", 0, 0, 0, "fighter"),
(14011, 14011, "Reanimated Man", 0, "", 0, "Monster.skeleton", 11, 25, 78, "male", "L2Pet", 40, 7085, 2057, 13.43, 3.09, 40, 43, 30, 21, 20, 25, 0, 0, 2099, 555, 1069, 520, 278, 0, 333, 0, 0, 0, 66, 154, "NULL", 0, 1, 0, "LAST_HIT", 0, 0, 0, "fighter"),
(14012, 14012, "Reanimated Man", 0, "", 0, "Monster.skeleton", 11, 25, 78, "male", "L2Pet", 40, 7085, 2057, 13.43, 3.09, 40, 43, 30, 21, 20, 25, 0, 0, 2109, 555, 1069, 520, 278, 0, 333, 0, 0, 0, 66, 154, "NULL", 0, 1, 0, "LAST_HIT", 0, 0, 0, "fighter"),
(14013, 14013, "Reanimated Man", 0, "", 0, "Monster.skeleton", 11, 25, 78, "male", "L2Pet", 40, 7085, 2057, 13.43, 3.09, 40, 43, 30, 21, 20, 25, 0, 0, 2119, 555, 1069, 520, 278, 0, 333, 0, 0, 0, 66, 154, "NULL", 0, 1, 0, "LAST_HIT", 0, 0, 0, "fighter"),
(14014, 14014, "Reanimated Man", 0, "", 0, "Monster.skeleton", 11, 25, 78, "male", "L2Pet", 40, 7085, 2057, 13.43, 3.09, 40, 43, 30, 21, 20, 25, 0, 0, 2130, 555, 1069, 520, 278, 0, 333, 0, 0, 0, 66, 154, "NULL", 0, 1, 0, "LAST_HIT", 0, 0, 0, "fighter"),
(14015, 14015, "Reanimated Man", 0, "", 0, "Monster.skeleton", 11, 25, 78, "male", "L2Pet", 40, 7085, 2057, 13.43, 3.09, 40, 43, 30, 21, 20, 25, 0, 0, 2140, 555, 1069, 520, 278, 0, 333, 0, 0, 0, 66, 154, "NULL", 0, 1, 0, "LAST_HIT", 0, 0, 0, "fighter"),
(14016, 14016, "Reanimated Man", 0, "", 0, "Monster.skeleton", 11, 25, 78, "male", "L2Pet", 40, 7085, 2057, 13.43, 3.09, 40, 43, 30, 21, 20, 25, 0, 0, 2150, 555, 1069, 520, 278, 0, 333, 0, 0, 0, 66, 154, "NULL", 0, 1, 0, "LAST_HIT", 0, 0, 0, "fighter"),
(14017, 14017, "Reanimated Man", 0, "", 0, "Monster.skeleton", 11, 25, 79, "male", "L2Pet", 40, 7085, 2057, 13.43, 3.09, 40, 43, 30, 21, 20, 25, 0, 0, 2173, 558, 1082, 523, 278, 0, 333, 0, 0, 0, 66, 154, "NULL", 0, 1, 0, "LAST_HIT", 0, 0, 0, "fighter"),
(14018, 14018, "Reanimated Man", 0, "", 0, "Monster.skeleton", 11, 25, 79, "male", "L2Pet", 40, 7085, 2057, 13.43, 3.09, 40, 43, 30, 21, 20, 25, 0, 0, 2184, 558, 1082, 523, 278, 0, 333, 0, 0, 0, 66, 154, "NULL", 0, 1, 0, "LAST_HIT", 0, 0, 0, "fighter"),
(14019, 14019, "Reanimated Man", 0, "", 0, "Monster.skeleton", 11, 25, 79, "male", "L2Pet", 40, 7085, 2057, 13.43, 3.09, 40, 43, 30, 21, 20, 25, 0, 0, 2194, 558, 1082, 523, 278, 0, 333, 0, 0, 0, 66, 154, "NULL", 0, 1, 0, "LAST_HIT", 0, 0, 0, "fighter"),
(14020, 14020, "Reanimated Man", 0, "", 0, "Monster.skeleton", 11, 25, 79, "male", "L2Pet", 40, 7085, 2057, 13.43, 3.09, 40, 43, 30, 21, 20, 25, 0, 0, 2204, 558, 1082, 523, 278, 0, 333, 0, 0, 0, 66, 154, "NULL", 0, 1, 0, "LAST_HIT", 0, 0, 0, "fighter"),
(14021, 14021, "Reanimated Man", 0, "", 0, "Monster.skeleton", 11, 25, 79, "male", "L2Pet", 40, 7085, 2057, 13.43, 3.09, 40, 43, 30, 21, 20, 25, 0, 0, 2215, 558, 1082, 523, 278, 0, 333, 0, 0, 0, 66, 154, "NULL", 0, 1, 0, "LAST_HIT", 0, 0, 0, "fighter"),
(14022, 14022, "Reanimated Man", 0, "", 0, "Monster.skeleton", 11, 25, 79, "male", "L2Pet", 40, 7085, 2057, 13.43, 3.09, 40, 43, 30, 21, 20, 25, 0, 0, 2225, 558, 1082, 523, 278, 0, 333, 0, 0, 0, 66, 154, "NULL", 0, 1, 0, "LAST_HIT", 0, 0, 0, "fighter"),
(14023, 14023, "Reanimated Man", 0, "", 0, "Monster.skeleton", 11, 25, 79, "male", "L2Pet", 40, 7085, 2057, 13.43, 3.09, 40, 43, 30, 21, 20, 25, 0, 0, 2236, 558, 1082, 523, 278, 0, 333, 0, 0, 0, 66, 154, "NULL", 0, 1, 0, "LAST_HIT", 0, 0, 0, "fighter"),
(14024, 14024, "Reanimated Man", 0, "", 0, "Monster.skeleton", 11, 25, 79, "male", "L2Pet", 40, 7085, 2057, 13.43, 3.09, 40, 43, 30, 21, 20, 25, 0, 0, 2246, 558, 1082, 523, 278, 0, 333, 0, 0, 0, 66, 154, "NULL", 0, 1, 0, "LAST_HIT", 0, 0, 0, "fighter"),
(14025, 14025, "Reanimated Man", 0, "", 0, "Monster.skeleton", 11, 25, 79, "male", "L2Pet", 40, 7085, 2057, 13.43, 3.09, 40, 43, 30, 21, 20, 25, 0, 0, 2256, 558, 1082, 523, 278, 0, 333, 0, 0, 0, 66, 154, "NULL", 0, 1, 0, "LAST_HIT", 0, 0, 0, "fighter"),
(14026, 14026, "Reanimated Man", 0, "", 0, "Monster.skeleton", 11, 25, 80, "male", "L2Pet", 40, 7085, 2057, 13.43, 3.09, 40, 43, 30, 21, 20, 25, 0, 0, 2280, 562, 1095, 526, 278, 0, 333, 0, 0, 0, 66, 154, "NULL", 0, 1, 0, "LAST_HIT", 0, 0, 0, "fighter"),
(14027, 14027, "Reanimated Man", 0, "", 0, "Monster.skeleton", 11, 25, 80, "male", "L2Pet", 40, 7085, 2057, 13.43, 3.09, 40, 43, 30, 21, 20, 25, 0, 0, 2290, 562, 1095, 526, 278, 0, 333, 0, 0, 0, 66, 154, "NULL", 0, 1, 0, "LAST_HIT", 0, 0, 0, "fighter"),
(14028, 14028, "Reanimated Man", 0, "", 0, "Monster.skeleton", 11, 25, 80, "male", "L2Pet", 40, 7085, 2057, 13.43, 3.09, 40, 43, 30, 21, 20, 25, 0, 0, 2301, 562, 1095, 526, 278, 0, 333, 0, 0, 0, 66, 154, "NULL", 0, 1, 0, "LAST_HIT", 0, 0, 0, "fighter"),
(14029, 14029, "Reanimated Man", 0, "", 0, "Monster.skeleton", 11, 25, 80, "male", "L2Pet", 40, 7085, 2057, 13.43, 3.09, 40, 43, 30, 21, 20, 25, 0, 0, 2311, 562, 1095, 526, 278, 0, 333, 0, 0, 0, 66, 154, "NULL", 0, 1, 0, "LAST_HIT", 0, 0, 0, "fighter"),
(14030, 14030, "Reanimated Man", 0, "", 0, "Monster.skeleton", 11, 25, 80, "male", "L2Pet", 40, 7085, 2057, 13.43, 3.09, 40, 43, 30, 21, 20, 25, 0, 0, 2322, 562, 1095, 526, 278, 0, 333, 0, 0, 0, 66, 154, "NULL", 0, 1, 0, "LAST_HIT", 0, 0, 0, "fighter"),
(14031, 14031, "Reanimated Man", 0, "", 0, "Monster.skeleton", 11, 25, 80, "male", "L2Pet", 40, 7085, 2057, 13.43, 3.09, 40, 43, 30, 21, 20, 25, 0, 0, 2332, 562, 1095, 526, 278, 0, 333, 0, 0, 0, 66, 154, "NULL", 0, 1, 0, "LAST_HIT", 0, 0, 0, "fighter"),
(14032, 14032, "Reanimated Man", 0, "", 0, "Monster.skeleton", 11, 25, 80, "male", "L2Pet", 40, 7085, 2057, 13.43, 3.09, 40, 43, 30, 21, 20, 25, 0, 0, 2343, 562, 1095, 526, 278, 0, 333, 0, 0, 0, 66, 154, "NULL", 0, 1, 0, "LAST_HIT", 0, 0, 0, "fighter"),
(14033, 14033, "Reanimated Man", 0, "", 0, "Monster.skeleton", 11, 25, 80, "male", "L2Pet", 40, 7085, 2057, 13.43, 3.09, 40, 43, 30, 21, 20, 25, 0, 0, 2353, 562, 1095, 526, 278, 0, 333, 0, 0, 0, 66, 154, "NULL", 0, 1, 0, "LAST_HIT", 0, 0, 0, "fighter"),
(14034, 14034, "Reanimated Man", 0, "", 0, "Monster.skeleton", 11, 25, 80, "male", "L2Pet", 40, 7085, 2057, 13.43, 3.09, 40, 43, 30, 21, 20, 25, 0, 0, 2363, 562, 1095, 526, 278, 0, 333, 0, 0, 0, 66, 154, "NULL", 0, 1, 0, "LAST_HIT", 0, 0, 0, "fighter"),
(14035, 14035, "Reanimated Man", 0, "", 0, "Monster.skeleton", 11, 25, 80, "male", "L2Pet", 40, 7085, 2057, 13.43, 3.09, 40, 43, 30, 21, 20, 25, 0, 0, 2374, 562, 1095, 526, 278, 0, 333, 0, 0, 0, 66, 154, "NULL", 0, 1, 0, "LAST_HIT", 0, 0, 0, "fighter"),
(14036, 14036, "Reanimated Man", 0, "", 0, "Monster.skeleton", 11, 25, 80, "male", "L2Pet", 40, 7085, 2057, 13.43, 3.09, 40, 43, 30, 21, 20, 25, 0, 0, 2384, 562, 1095, 526, 278, 0, 333, 0, 0, 0, 66, 154, "NULL", 0, 1, 0, "LAST_HIT", 0, 0, 0, "fighter"),
(14037, 14037, "Reanimated Man", 0, "", 0, "Monster.skeleton", 11, 25, 80, "male", "L2Pet", 40, 7085, 2057, 13.43, 3.09, 40, 43, 30, 21, 20, 25, 0, 0, 2395, 562, 1095, 526, 278, 0, 333, 0, 0, 0, 66, 154, "NULL", 0, 1, 0, "LAST_HIT", 0, 0, 0, "fighter"),
(14038, 14038, "Corrupted Man", 0, "", 0, "Monster.zombie", 13, 21, 42, "male", "L2Pet", 40, 2490, 1019, 8.69, 2.14, 40, 43, 30, 21, 20, 25, 0, 0, 374, 215, 152, 202, 278, 0, 333, 0, 0, 0, 16, 154, "NULL", 0, 1, 0, "LAST_HIT", 0, 0, 0, "fighter"),
(14039, 14039, "Corrupted Man", 0, "", 0, "Monster.zombie", 13, 21, 50, "male", "L2Pet", 40, 3367, 1435, 8.69, 2.14, 40, 43, 30, 21, 20, 25, 0, 0, 611, 278, 264, 260, 278, 0, 333, 0, 0, 0, 16, 154, "NULL", 0, 1, 0, "LAST_HIT", 0, 0, 0, "fighter"),
(14040, 14040, "Corrupted Man", 0, "", 0, "Monster.zombie", 13, 21, 58, "male", "L2Pet", 40, 4333, 1876, 10.27, 2.45, 40, 43, 30, 21, 20, 25, 0, 0, 937, 349, 428, 327, 278, 0, 333, 0, 0, 0, 16, 154, "NULL", 0, 1, 0, "LAST_HIT", 0, 0, 0, "fighter"),
(14041, 14041, "Corrupted Man", 0, "", 0, "Monster.zombie", 13, 21, 64, "male", "L2Pet", 40, 5076, 2223, 11.85, 2.78, 40, 43, 30, 21, 20, 25, 0, 0, 1238, 408, 589, 382, 278, 0, 333, 0, 0, 0, 16, 154, "NULL", 0, 1, 0, "LAST_HIT", 0, 0, 0, "fighter"),
(14042, 14042, "Corrupted Man", 0, "", 0, "Monster.zombie", 13, 21, 68, "male", "L2Pet", 40, 5559, 2462, 11.85, 2.78, 40, 43, 30, 21, 20, 25, 0, 0, 1460, 449, 713, 421, 278, 0, 333, 0, 0, 0, 16, 154, "NULL", 0, 1, 0, "LAST_HIT", 0, 0, 0, "fighter"),
(14043, 14043, "Corrupted Man", 0, "", 0, "Monster.zombie", 13, 21, 72, "male", "L2Pet", 40, 6020, 2707, 13.43, 3.09, 40, 43, 30, 21, 20, 25, 0, 0, 1695, 491, 849, 460, 278, 0, 333, 0, 0, 0, 15, 140, "NULL", 0, 1, 0, "LAST_HIT", 0, 0, 0, "fighter"),
(14044, 14044, "Corrupted Man", 0, "", 0, "Monster.zombie", 13, 21, 78, "male", "L2Pet", 40, 6642, 3086, 13.43, 3.09, 40, 43, 30, 21, 20, 25, 0, 0, 2068, 555, 1069, 520, 278, 0, 333, 0, 0, 0, 16, 154, "NULL", 0, 1, 0, "LAST_HIT", 0, 0, 0, "fighter"),
(14045, 14045, "Corrupted Man", 0, "", 0, "Monster.zombie", 13, 21, 78, "male", "L2Pet", 40, 6642, 3086, 13.43, 3.09, 40, 43, 30, 21, 20, 25, 0, 0, 2078, 555, 1069, 520, 278, 0, 333, 0, 0, 0, 16, 154, "NULL", 0, 1, 0, "LAST_HIT", 0, 0, 0, "fighter"),
(14046, 14046, "Corrupted Man", 0, "", 0, "Monster.zombie", 13, 21, 78, "male", "L2Pet", 40, 6642, 3086, 13.43, 3.09, 40, 43, 30, 21, 20, 25, 0, 0, 2088, 555, 1069, 520, 278, 0, 333, 0, 0, 0, 16, 154, "NULL", 0, 1, 0, "LAST_HIT", 0, 0, 0, "fighter"),
(14047, 14047, "Corrupted Man", 0, "", 0, "Monster.zombie", 13, 21, 78, "male", "L2Pet", 40, 6642, 3086, 13.43, 3.09, 40, 43, 30, 21, 20, 25, 0, 0, 2099, 555, 1069, 520, 278, 0, 333, 0, 0, 0, 16, 154, "NULL", 0, 1, 0, "LAST_HIT", 0, 0, 0, "fighter"),
(14048, 14048, "Corrupted Man", 0, "", 0, "Monster.zombie", 13, 21, 78, "male", "L2Pet", 40, 6642, 3086, 13.43, 3.09, 40, 43, 30, 21, 20, 25, 0, 0, 2109, 555, 1069, 520, 278, 0, 333, 0, 0, 0, 16, 154, "NULL", 0, 1, 0, "LAST_HIT", 0, 0, 0, "fighter"),
(14049, 14049, "Corrupted Man", 0, "", 0, "Monster.zombie", 13, 21, 78, "male", "L2Pet", 40, 6642, 3086, 13.43, 3.09, 40, 43, 30, 21, 20, 25, 0, 0, 2119, 555, 1069, 520, 278, 0, 333, 0, 0, 0, 16, 154, "NULL", 0, 1, 0, "LAST_HIT", 0, 0, 0, "fighter"),
(14050, 14050, "Corrupted Man", 0, "", 0, "Monster.zombie", 13, 21, 78, "male", "L2Pet", 40, 6642, 3086, 13.43, 3.09, 40, 43, 30, 21, 20, 25, 0, 0, 2130, 555, 1069, 520, 278, 0, 333, 0, 0, 0, 16, 154, "NULL", 0, 1, 0, "LAST_HIT", 0, 0, 0, "fighter"),
(14051, 14051, "Corrupted Man", 0, "", 0, "Monster.zombie", 13, 21, 78, "male", "L2Pet", 40, 6642, 3086, 13.43, 3.09, 40, 43, 30, 21, 20, 25, 0, 0, 2140, 555, 1069, 520, 278, 0, 333, 0, 0, 0, 16, 154, "NULL", 0, 1, 0, "LAST_HIT", 0, 0, 0, "fighter"),
(14052, 14052, "Corrupted Man", 0, "", 0, "Monster.zombie", 13, 21, 78, "male", "L2Pet", 40, 6642, 3086, 13.43, 3.09, 40, 43, 30, 21, 20, 25, 0, 0, 2150, 555, 1069, 520, 278, 0, 333, 0, 0, 0, 16, 154, "NULL", 0, 1, 0, "LAST_HIT", 0, 0, 0, "fighter"),
(14053, 14053, "Corrupted Man", 0, "", 0, "Monster.zombie", 13, 21, 79, "male", "L2Pet", 40, 6642, 3086, 13.43, 3.09, 40, 43, 30, 21, 20, 25, 0, 0, 2173, 558, 1082, 523, 278, 0, 333, 0, 0, 0, 16, 154, "NULL", 0, 1, 0, "LAST_HIT", 0, 0, 0, "fighter"),
(14054, 14054, "Corrupted Man", 0, "", 0, "Monster.zombie", 13, 21, 79, "male", "L2Pet", 40, 6642, 3086, 13.43, 3.09, 40, 43, 30, 21, 20, 25, 0, 0, 2184, 558, 1082, 523, 278, 0, 333, 0, 0, 0, 16, 154, "NULL", 0, 1, 0, "LAST_HIT", 0, 0, 0, "fighter"),
(14055, 14055, "Corrupted Man", 0, "", 0, "Monster.zombie", 13, 21, 79, "male", "L2Pet", 40, 6642, 3086, 13.43, 3.09, 40, 43, 30, 21, 20, 25, 0, 0, 2194, 558, 1082, 523, 278, 0, 333, 0, 0, 0, 16, 154, "NULL", 0, 1, 0, "LAST_HIT", 0, 0, 0, "fighter"),
(14056, 14056, "Corrupted Man", 0, "", 0, "Monster.zombie", 13, 21, 79, "male", "L2Pet", 40, 6642, 3086, 13.43, 3.09, 40, 43, 30, 21, 20, 25, 0, 0, 2204, 558, 1082, 523, 278, 0, 333, 0, 0, 0, 16, 154, "NULL", 0, 1, 0, "LAST_HIT", 0, 0, 0, "fighter"),
(14057, 14057, "Corrupted Man", 0, "", 0, "Monster.zombie", 13, 21, 79, "male", "L2Pet", 40, 6642, 3086, 13.43, 3.09, 40, 43, 30, 21, 20, 25, 0, 0, 2215, 558, 1082, 523, 278, 0, 333, 0, 0, 0, 16, 154, "NULL", 0, 1, 0, "LAST_HIT", 0, 0, 0, "fighter"),
(14058, 14058, "Corrupted Man", 0, "", 0, "Monster.zombie", 13, 21, 79, "male", "L2Pet", 40, 6642, 3086, 13.43, 3.09, 40, 43, 30, 21, 20, 25, 0, 0, 2225, 558, 1082, 523, 278, 0, 333, 0, 0, 0, 16, 154, "NULL", 0, 1, 0, "LAST_HIT", 0, 0, 0, "fighter"),
(14059, 14059, "Corrupted Man", 0, "", 0, "Monster.zombie", 13, 21, 79, "male", "L2Pet", 40, 6642, 3086, 13.43, 3.09, 40, 43, 30, 21, 20, 25, 0, 0, 2236, 558, 1082, 523, 278, 0, 333, 0, 0, 0, 16, 154, "NULL", 0, 1, 0, "LAST_HIT", 0, 0, 0, "fighter"),
(14060, 14060, "Corrupted Man", 0, "", 0, "Monster.zombie", 13, 21, 79, "male", "L2Pet", 40, 6642, 3086, 13.43, 3.09, 40, 43, 30, 21, 20, 25, 0, 0, 2246, 558, 1082, 523, 278, 0, 333, 0, 0, 0, 16, 154, "NULL", 0, 1, 0, "LAST_HIT", 0, 0, 0, "fighter"),
(14061, 14061, "Corrupted Man", 0, "", 0, "Monster.zombie", 13, 21, 79, "male", "L2Pet", 40, 6642, 3086, 13.43, 3.09, 40, 43, 30, 21, 20, 25, 0, 0, 2256, 558, 1082, 523, 278, 0, 333, 0, 0, 0, 16, 154, "NULL", 0, 1, 0, "LAST_HIT", 0, 0, 0, "fighter"),
(14062, 14062, "Corrupted Man", 0, "", 0, "Monster.zombie", 13, 21, 80, "male", "L2Pet", 40, 6642, 3086, 13.43, 3.09, 40, 43, 30, 21, 20, 25, 0, 0, 2280, 562, 1095, 526, 278, 0, 333, 0, 0, 0, 16, 154, "NULL", 0, 1, 0, "LAST_HIT", 0, 0, 0, "fighter"),
(14063, 14063, "Corrupted Man", 0, "", 0, "Monster.zombie", 13, 21, 80, "male", "L2Pet", 40, 6642, 3086, 13.43, 3.09, 40, 43, 30, 21, 20, 25, 0, 0, 2290, 562, 1095, 526, 278, 0, 333, 0, 0, 0, 16, 154, "NULL", 0, 1, 0, "LAST_HIT", 0, 0, 0, "fighter"),
(14064, 14064, "Corrupted Man", 0, "", 0, "Monster.zombie", 13, 21, 80, "male", "L2Pet", 40, 6642, 3086, 13.43, 3.09, 40, 43, 30, 21, 20, 25, 0, 0, 2301, 562, 1095, 526, 278, 0, 333, 0, 0, 0, 16, 154, "NULL", 0, 1, 0, "LAST_HIT", 0, 0, 0, "fighter"),
(14065, 14065, "Corrupted Man", 0, "", 0, "Monster.zombie", 13, 21, 80, "male", "L2Pet", 40, 6642, 3086, 13.43, 3.09, 40, 43, 30, 21, 20, 25, 0, 0, 2311, 562, 1095, 526, 278, 0, 333, 0, 0, 0, 16, 154, "NULL", 0, 1, 0, "LAST_HIT", 0, 0, 0, "fighter"),
(14066, 14066, "Corrupted Man", 0, "", 0, "Monster.zombie", 13, 21, 80, "male", "L2Pet", 40, 6642, 3086, 13.43, 3.09, 40, 43, 30, 21, 20, 25, 0, 0, 2322, 562, 1095, 526, 278, 0, 333, 0, 0, 0, 16, 154, "NULL", 0, 1, 0, "LAST_HIT", 0, 0, 0, "fighter"),
(14067, 14067, "Corrupted Man", 0, "", 0, "Monster.zombie", 13, 21, 80, "male", "L2Pet", 40, 6642, 3086, 13.43, 3.09, 40, 43, 30, 21, 20, 25, 0, 0, 2332, 562, 1095, 526, 278, 0, 333, 0, 0, 0, 16, 154, "NULL", 0, 1, 0, "LAST_HIT", 0, 0, 0, "fighter"),
(14068, 14068, "Corrupted Man", 0, "", 0, "Monster.zombie", 13, 21, 80, "male", "L2Pet", 40, 6642, 3086, 13.43, 3.09, 40, 43, 30, 21, 20, 25, 0, 0, 2343, 562, 1095, 526, 278, 0, 333, 0, 0, 0, 16, 154, "NULL", 0, 1, 0, "LAST_HIT", 0, 0, 0, "fighter"),
(14069, 14069, "Corrupted Man", 0, "", 0, "Monster.zombie", 13, 21, 80, "male", "L2Pet", 40, 6642, 3086, 13.43, 3.09, 40, 43, 30, 21, 20, 25, 0, 0, 2353, 562, 1095, 526, 278, 0, 333, 0, 0, 0, 16, 154, "NULL", 0, 1, 0, "LAST_HIT", 0, 0, 0, "fighter"),
(14070, 14070, "Corrupted Man", 0, "", 0, "Monster.zombie", 13, 21, 80, "male", "L2Pet", 40, 6642, 3086, 13.43, 3.09, 40, 43, 30, 21, 20, 25, 0, 0, 2363, 562, 1095, 526, 278, 0, 333, 0, 0, 0, 16, 154, "NULL", 0, 1, 0, "LAST_HIT", 0, 0, 0, "fighter"),
(14071, 14071, "Corrupted Man", 0, "", 0, "Monster.zombie", 13, 21, 80, "male", "L2Pet", 40, 6642, 3086, 13.43, 3.09, 40, 43, 30, 21, 20, 25, 0, 0, 2374, 562, 1095, 526, 278, 0, 333, 0, 0, 0, 16, 154, "NULL", 0, 1, 0, "LAST_HIT", 0, 0, 0, "fighter"),
(14072, 14072, "Corrupted Man", 0, "", 0, "Monster.zombie", 13, 21, 80, "male", "L2Pet", 40, 6642, 3086, 13.43, 3.09, 40, 43, 30, 21, 20, 25, 0, 0, 2384, 562, 1095, 526, 278, 0, 333, 0, 0, 0, 16, 154, "NULL", 0, 1, 0, "LAST_HIT", 0, 0, 0, "fighter"),
(14073, 14073, "Corrupted Man", 0, "", 0, "Monster.zombie", 13, 21, 80, "male", "L2Pet", 40, 6642, 3086, 13.43, 3.09, 40, 43, 30, 21, 20, 25, 0, 0, 2395, 562, 1095, 526, 278, 0, 333, 0, 0, 0, 16, 154, "NULL", 0, 1, 0, "LAST_HIT", 0, 0, 0, "fighter"),
(14074, 14074, "Cursed Man", 0, "", 0, "Monster.doll_master", 20, 42, 58, "male", "L2Pet", 80, 3467, 1251, 12.32, 2.45, 40, 43, 30, 21, 20, 25, 0, 0, 1015, 349, 428, 327, 278, 0, 333, 0, 0, 0, 88, 176, "NULL", 0, 1, 0, "LAST_HIT", 0, 0, 0, "fighter"),
(14075, 14075, "Cursed Man", 0, "", 0, "Monster.doll_master", 20, 42, 62, "male", "L2Pet", 80, 3863, 1404, 14.22, 2.78, 40, 43, 30, 21, 20, 25, 0, 0, 1227, 388, 532, 363, 278, 0, 333, 0, 0, 0, 88, 176, "NULL", 0, 1, 0, "LAST_HIT", 0, 0, 0, "fighter"),
(14076, 14076, "Cursed Man", 0, "", 0, "Monster.doll_master", 20, 42, 66, "male", "L2Pet", 80, 4255, 1561, 14.22, 2.78, 40, 43, 30, 21, 20, 25, 0, 0, 1459, 428, 649, 401, 278, 0, 333, 0, 0, 0, 80, 160, "NULL", 0, 1, 0, "LAST_HIT", 0, 0, 0, "fighter"),
(14077, 14077, "Cursed Man", 0, "", 0, "Monster.doll_master", 20, 42, 70, "male", "L2Pet", 80, 4634, 1722, 14.22, 2.78, 40, 43, 30, 21, 20, 25, 0, 0, 1708, 470, 780, 440, 278, 0, 333, 0, 0, 0, 80, 160, "NULL", 0, 1, 0, "LAST_HIT", 0, 0, 0, "fighter"),
(14078, 14078, "Cursed Man", 0, "", 0, "Monster.doll_master", 20, 42, 72, "male", "L2Pet", 80, 4816, 1804, 16.12, 3.09, 40, 43, 30, 21, 20, 25, 0, 0, 1837, 491, 849, 460, 278, 0, 333, 0, 0, 0, 88, 176, "NULL", 0, 1, 0, "LAST_HIT", 0, 0, 0, "fighter"),
(14079, 14079, "Cursed Man", 0, "", 0, "Monster.doll_master", 20, 42, 74, "male", "L2Pet", 80, 4990, 1888, 16.12, 3.09, 40, 43, 30, 21, 20, 25, 0, 0, 1967, 512, 921, 480, 278, 0, 333, 0, 0, 0, 88, 176, "NULL", 0, 1, 0, "LAST_HIT", 0, 0, 0, "fighter"),
(14080, 14080, "Cursed Man", 0, "", 0, "Monster.doll_master", 20, 42, 76, "male", "L2Pet", 80, 5157, 1972, 16.12, 3.09, 40, 43, 30, 21, 20, 25, 0, 0, 2098, 534, 994, 500, 278, 0, 333, 0, 0, 0, 80, 160, "NULL", 0, 1, 0, "LAST_HIT", 0, 0, 0, "fighter"),
(14081, 14081, "Cursed Man", 0, "", 0, "Monster.doll_master", 20, 42, 78, "male", "L2Pet", 80, 5314, 2057, 16.12, 3.09, 40, 43, 30, 21, 20, 25, 0, 0, 2229, 555, 1069, 520, 278, 0, 333, 0, 0, 0, 88, 176, "NULL", 0, 1, 0, "LAST_HIT", 0, 0, 0, "fighter"),
(14082, 14082, "Cursed Man", 0, "", 0, "Monster.doll_master", 20, 42, 78, "male", "L2Pet", 80, 5314, 2057, 16.12, 3.09, 40, 43, 30, 21, 20, 25, 0, 0, 2245, 555, 1069, 520, 278, 0, 333, 0, 0, 0, 88, 176, "NULL", 0, 1, 0, "LAST_HIT", 0, 0, 0, "fighter"),
(14083, 14083, "Cursed Man", 0, "", 0, "Monster.doll_master", 20, 42, 78, "male", "L2Pet", 80, 5314, 2057, 16.12, 3.09, 40, 43, 30, 21, 20, 25, 0, 0, 2261, 555, 1069, 520, 278, 0, 333, 0, 0, 0, 88, 176, "NULL", 0, 1, 0, "LAST_HIT", 0, 0, 0, "fighter"),
(14084, 14084, "Cursed Man", 0, "", 0, "Monster.doll_master", 20, 42, 78, "male", "L2Pet", 80, 5314, 2057, 16.12, 3.09, 40, 43, 30, 21, 20, 25, 0, 0, 2277, 555, 1069, 520, 278, 0, 333, 0, 0, 0, 88, 176, "NULL", 0, 1, 0, "LAST_HIT", 0, 0, 0, "fighter"),
(14085, 14085, "Cursed Man", 0, "", 0, "Monster.doll_master", 20, 42, 78, "male", "L2Pet", 80, 5314, 2057, 16.12, 3.09, 40, 43, 30, 21, 20, 25, 0, 0, 2293, 555, 1069, 520, 278, 0, 333, 0, 0, 0, 88, 176, "NULL", 0, 1, 0, "LAST_HIT", 0, 0, 0, "fighter"),
(14086, 14086, "Cursed Man", 0, "", 0, "Monster.doll_master", 20, 42, 78, "male", "L2Pet", 80, 5314, 2057, 16.12, 3.09, 40, 43, 30, 21, 20, 25, 0, 0, 2309, 555, 1069, 520, 278, 0, 333, 0, 0, 0, 88, 176, "NULL", 0, 1, 0, "LAST_HIT", 0, 0, 0, "fighter"),
(14087, 14087, "Cursed Man", 0, "", 0, "Monster.doll_master", 20, 42, 78, "male", "L2Pet", 80, 5314, 2057, 16.12, 3.09, 40, 43, 30, 21, 20, 25, 0, 0, 2325, 555, 1069, 520, 278, 0, 333, 0, 0, 0, 88, 176, "NULL", 0, 1, 0, "LAST_HIT", 0, 0, 0, "fighter"),
(14088, 14088, "Cursed Man", 0, "", 0, "Monster.doll_master", 20, 42, 78, "male", "L2Pet", 80, 5314, 2057, 16.12, 3.09, 40, 43, 30, 21, 20, 25, 0, 0, 2341, 555, 1069, 520, 278, 0, 333, 0, 0, 0, 88, 176, "NULL", 0, 1, 0, "LAST_HIT", 0, 0, 0, "fighter"),
(14089, 14089, "Cursed Man", 0, "", 0, "Monster.doll_master", 20, 42, 78, "male", "L2Pet", 80, 5314, 2057, 16.12, 3.09, 40, 43, 30, 21, 20, 25, 0, 0, 2357, 555, 1069, 520, 278, 0, 333, 0, 0, 0, 88, 176, "NULL", 0, 1, 0, "LAST_HIT", 0, 0, 0, "fighter"),
(14090, 14090, "Cursed Man", 0, "", 0, "Monster.doll_master", 20, 42, 79, "male", "L2Pet", 80, 5314, 2057, 16.12, 3.09, 40, 43, 30, 21, 20, 25, 0, 0, 2388, 558, 1082, 523, 278, 0, 333, 0, 0, 0, 88, 176, "NULL", 0, 1, 0, "LAST_HIT", 0, 0, 0, "fighter"),
(14091, 14091, "Cursed Man", 0, "", 0, "Monster.doll_master", 20, 42, 79, "male", "L2Pet", 80, 5314, 2057, 16.12, 3.09, 40, 43, 30, 21, 20, 25, 0, 0, 2404, 558, 1082, 523, 278, 0, 333, 0, 0, 0, 88, 176, "NULL", 0, 1, 0, "LAST_HIT", 0, 0, 0, "fighter"),
(14092, 14092, "Cursed Man", 0, "", 0, "Monster.doll_master", 20, 42, 79, "male", "L2Pet", 80, 5314, 2057, 16.12, 3.09, 40, 43, 30, 21, 20, 25, 0, 0, 2420, 558, 1082, 523, 278, 0, 333, 0, 0, 0, 88, 176, "NULL", 0, 1, 0, "LAST_HIT", 0, 0, 0, "fighter"),
(14093, 14093, "Cursed Man", 0, "", 0, "Monster.doll_master", 20, 42, 79, "male", "L2Pet", 80, 5314, 2057, 16.12, 3.09, 40, 43, 30, 21, 20, 25, 0, 0, 2436, 558, 1082, 523, 278, 0, 333, 0, 0, 0, 88, 176, "NULL", 0, 1, 0, "LAST_HIT", 0, 0, 0, "fighter"),
(14094, 14094, "Cursed Man", 0, "", 0, "Monster.doll_master", 20, 42, 79, "male", "L2Pet", 80, 5314, 2057, 16.12, 3.09, 40, 43, 30, 21, 20, 25, 0, 0, 2452, 558, 1082, 523, 278, 0, 333, 0, 0, 0, 88, 176, "NULL", 0, 1, 0, "LAST_HIT", 0, 0, 0, "fighter"),
(14095, 14095, "Cursed Man", 0, "", 0, "Monster.doll_master", 20, 42, 79, "male", "L2Pet", 80, 5314, 2057, 16.12, 3.09, 40, 43, 30, 21, 20, 25, 0, 0, 2468, 558, 1082, 523, 278, 0, 333, 0, 0, 0, 88, 176, "NULL", 0, 1, 0, "LAST_HIT", 0, 0, 0, "fighter"),
(14096, 14096, "Cursed Man", 0, "", 0, "Monster.doll_master", 20, 42, 79, "male", "L2Pet", 80, 5314, 2057, 16.12, 3.09, 40, 43, 30, 21, 20, 25, 0, 0, 2484, 558, 1082, 523, 278, 0, 333, 0, 0, 0, 88, 176, "NULL", 0, 1, 0, "LAST_HIT", 0, 0, 0, "fighter"),
(14097, 14097, "Cursed Man", 0, "", 0, "Monster.doll_master", 20, 42, 79, "male", "L2Pet", 80, 5314, 2057, 16.12, 3.09, 40, 43, 30, 21, 20, 25, 0, 0, 2500, 558, 1082, 523, 278, 0, 333, 0, 0, 0, 88, 176, "NULL", 0, 1, 0, "LAST_HIT", 0, 0, 0, "fighter"),
(14098, 14098, "Cursed Man", 0, "", 0, "Monster.doll_master", 20, 42, 79, "male", "L2Pet", 80, 5314, 2057, 16.12, 3.09, 40, 43, 30, 21, 20, 25, 0, 0, 2517, 558, 1082, 523, 278, 0, 333, 0, 0, 0, 88, 176, "NULL", 0, 1, 0, "LAST_HIT", 0, 0, 0, "fighter"),
(14099, 14099, "Cursed Man", 0, "", 0, "Monster.doll_master", 20, 42, 80, "male", "L2Pet", 80, 5314, 2057, 16.12, 3.09, 40, 43, 30, 21, 20, 25, 0, 0, 2548, 562, 1095, 526, 278, 0, 333, 0, 0, 0, 88, 176, "NULL", 0, 1, 0, "LAST_HIT", 0, 0, 0, "fighter"),
(14100, 14100, "Cursed Man", 0, "", 0, "Monster.doll_master", 20, 42, 80, "male", "L2Pet", 80, 5314, 2057, 16.12, 3.09, 40, 43, 30, 21, 20, 25, 0, 0, 2564, 562, 1095, 526, 278, 0, 333, 0, 0, 0, 88, 176, "NULL", 0, 1, 0, "LAST_HIT", 0, 0, 0, "fighter"),
(14101, 14101, "Cursed Man", 0, "", 0, "Monster.doll_master", 20, 42, 80, "male", "L2Pet", 80, 5314, 2057, 16.12, 3.09, 40, 43, 30, 21, 20, 25, 0, 0, 2580, 562, 1095, 526, 278, 0, 333, 0, 0, 0, 88, 176, "NULL", 0, 1, 0, "LAST_HIT", 0, 0, 0, "fighter"),
(14102, 14102, "Cursed Man", 0, "", 0, "Monster.doll_master", 20, 42, 80, "male", "L2Pet", 80, 5314, 2057, 16.12, 3.09, 40, 43, 30, 21, 20, 25, 0, 0, 2596, 562, 1095, 526, 278, 0, 333, 0, 0, 0, 88, 176, "NULL", 0, 1, 0, "LAST_HIT", 0, 0, 0, "fighter"),
(14103, 14103, "Cursed Man", 0, "", 0, "Monster.doll_master", 20, 42, 80, "male", "L2Pet", 80, 5314, 2057, 16.12, 3.09, 40, 43, 30, 21, 20, 25, 0, 0, 2613, 562, 1095, 526, 278, 0, 333, 0, 0, 0, 88, 176, "NULL", 0, 1, 0, "LAST_HIT", 0, 0, 0, "fighter"),
(14104, 14104, "Cursed Man", 0, "", 0, "Monster.doll_master", 20, 42, 80, "male", "L2Pet", 80, 5314, 2057, 16.12, 3.09, 40, 43, 30, 21, 20, 25, 0, 0, 2629, 562, 1095, 526, 278, 0, 333, 0, 0, 0, 88, 176, "NULL", 0, 1, 0, "LAST_HIT", 0, 0, 0, "fighter"),
(14105, 14105, "Cursed Man", 0, "", 0, "Monster.doll_master", 20, 42, 80, "male", "L2Pet", 80, 5314, 2057, 16.12, 3.09, 40, 43, 30, 21, 20, 25, 0, 0, 2645, 562, 1095, 526, 278, 0, 333, 0, 0, 0, 88, 176, "NULL", 0, 1, 0, "LAST_HIT", 0, 0, 0, "fighter"),
(14106, 14106, "Cursed Man", 0, "", 0, "Monster.doll_master", 20, 42, 80, "male", "L2Pet", 80, 5314, 2057, 16.12, 3.09, 40, 43, 30, 21, 20, 25, 0, 0, 2661, 562, 1095, 526, 278, 0, 333, 0, 0, 0, 88, 176, "NULL", 0, 1, 0, "LAST_HIT", 0, 0, 0, "fighter"),
(14107, 14107, "Cursed Man", 0, "", 0, "Monster.doll_master", 20, 42, 80, "male", "L2Pet", 80, 5314, 2057, 16.12, 3.09, 40, 43, 30, 21, 20, 25, 0, 0, 2678, 562, 1095, 526, 278, 0, 333, 0, 0, 0, 88, 176, "NULL", 0, 1, 0, "LAST_HIT", 0, 0, 0, "fighter"),
(14108, 14108, "Cursed Man", 0, "", 0, "Monster.doll_master", 20, 42, 80, "male", "L2Pet", 80, 5314, 2057, 16.12, 3.09, 40, 43, 30, 21, 20, 25, 0, 0, 2694, 562, 1095, 526, 278, 0, 333, 0, 0, 0, 88, 176, "NULL", 0, 1, 0, "LAST_HIT", 0, 0, 0, "fighter"),
(14109, 14109, "Cursed Man", 0, "", 0, "Monster.doll_master", 20, 42, 80, "male", "L2Pet", 80, 5314, 2057, 16.12, 3.09, 40, 43, 30, 21, 20, 25, 0, 0, 2710, 562, 1095, 526, 278, 0, 333, 0, 0, 0, 88, 176, "NULL", 0, 1, 0, "LAST_HIT", 0, 0, 0, "fighter"),
(14110, 14110, "Cursed Man", 0, "", 0, "Monster.doll_master", 20, 42, 80, "male", "L2Pet", 80, 5314, 2057, 16.12, 3.09, 40, 43, 30, 21, 20, 25, 0, 0, 2726, 562, 1095, 526, 278, 0, 333, 0, 0, 0, 88, 176, "NULL", 0, 1, 0, "LAST_HIT", 0, 0, 0, "fighter"),
(14111, 14111, "Kat the Cat", 0, "", 0, "Monster.cat_the_cat", 9, 16, 22, "male", "L2Pet", 40, 978, 279, 5.53, 1.53, 40, 43, 30, 21, 20, 25, 0, 0, 68, 102, 28, 96, 278, 0, 333, 0, 0, 0, 88, 132, "NULL", 0, 0, 0, "LAST_HIT", 0, 0, 0, "fighter"),
(14112, 14112, "Kat the Cat", 0, "", 0, "Monster.cat_the_cat", 9, 16, 32, "male", "L2Pet", 40, 1689, 458, 7.11, 1.84, 40, 43, 30, 21, 20, 25, 0, 0, 154, 151, 69, 142, 278, 0, 333, 0, 0, 0, 80, 120, "NULL", 0, 0, 0, "LAST_HIT", 0, 0, 0, "fighter"),
(14113, 14113, "Kat the Cat", 0, "", 0, "Monster.cat_the_cat", 9, 16, 42, "male", "L2Pet", 40, 2656, 679, 8.69, 2.14, 40, 43, 30, 21, 20, 25, 0, 0, 311, 215, 152, 202, 278, 0, 333, 0, 0, 0, 80, 120, "NULL", 0, 0, 0, "LAST_HIT", 0, 0, 0, "fighter"),
(14114, 14114, "Kat the Cat", 0, "", 0, "Monster.cat_the_cat", 9, 16, 50, "male", "L2Pet", 40, 3592, 957, 8.69, 2.14, 40, 43, 30, 21, 20, 25, 0, 0, 509, 278, 264, 260, 278, 0, 333, 0, 0, 0, 80, 120, "NULL", 0, 0, 0, "LAST_HIT", 0, 0, 0, "fighter"),
(14115, 14115, "Kat the Cat", 0, "", 0, "Monster.cat_the_cat", 9, 16, 58, "male", "L2Pet", 40, 4622, 1251, 10.27, 2.45, 40, 43, 30, 21, 20, 25, 0, 0, 781, 349, 428, 327, 278, 0, 333, 0, 0, 0, 88, 132, "NULL", 0, 0, 0, "LAST_HIT", 0, 0, 0, "fighter"),
(14116, 14116, "Kat the Cat", 0, "", 0, "Monster.cat_the_cat", 9, 16, 27, "male", "L2Pet", 40, 1302, 367, 5.53, 1.53, 40, 43, 30, 21, 20, 25, 0, 0, 104, 125, 45, 117, 278, 0, 333, 0, 0, 0, 80, 120, "NULL", 0, 0, 0, "LAST_HIT", 0, 0, 0, "fighter"),
(14117, 14117, "Kat the Cat", 0, "", 0, "Monster.cat_the_cat", 9, 16, 37, "male", "L2Pet", 40, 2142, 553, 7.11, 1.84, 40, 43, 30, 21, 20, 25, 0, 0, 222, 182, 104, 170, 278, 0, 333, 0, 0, 0, 88, 132, "NULL", 0, 0, 0, "LAST_HIT", 0, 0, 0, "fighter"),
(14118, 14118, "Kat the Cat", 0, "", 0, "Monster.cat_the_cat", 9, 16, 46, "male", "L2Pet", 40, 3108, 816, 8.69, 2.14, 40, 43, 30, 21, 20, 25, 0, 0, 401, 245, 202, 230, 278, 0, 333, 0, 0, 0, 88, 132, "NULL", 0, 0, 0, "LAST_HIT", 0, 0, 0, "fighter"),
(14119, 14119, "Kat the Cat", 0, "", 0, "Monster.cat_the_cat", 9, 16, 54, "male", "L2Pet", 40, 4099, 1102, 10.27, 2.45, 40, 43, 30, 21, 20, 25, 0, 0, 636, 313, 339, 293, 278, 0, 333, 0, 0, 0, 88, 132, "NULL", 0, 0, 0, "LAST_HIT", 0, 0, 0, "fighter"),
(14120, 14120, "Kat the Cat", 0, "", 0, "Monster.cat_the_cat", 9, 16, 60, "male", "L2Pet", 40, 4887, 1327, 10.27, 2.45, 40, 43, 30, 21, 20, 25, 0, 0, 860, 368, 478, 345, 278, 0, 333, 0, 0, 0, 88, 132, "NULL", 0, 0, 0, "LAST_HIT", 0, 0, 0, "fighter"),
(14121, 14121, "Kat the Cat", 0, "", 0, "Monster.cat_the_cat", 9, 16, 62, "male", "L2Pet", 40, 5151, 1404, 11.85, 2.78, 40, 43, 30, 21, 20, 25, 0, 0, 944, 388, 532, 363, 278, 0, 333, 0, 0, 0, 88, 132, "NULL", 0, 0, 0, "LAST_HIT", 0, 0, 0, "fighter"),
(14122, 14122, "Kat the Cat", 0, "", 0, "Monster.cat_the_cat", 9, 16, 64, "male", "L2Pet", 40, 5414, 1482, 11.85, 2.78, 40, 43, 30, 21, 20, 25, 0, 0, 1031, 408, 589, 382, 278, 0, 333, 0, 0, 0, 88, 132, "NULL", 0, 0, 0, "LAST_HIT", 0, 0, 0, "fighter"),
(14123, 14123, "Kat the Cat", 0, "", 0, "Monster.cat_the_cat", 9, 16, 66, "male", "L2Pet", 40, 5674, 1561, 11.85, 2.78, 40, 43, 30, 21, 20, 25, 0, 0, 1123, 428, 649, 401, 278, 0, 333, 0, 0, 0, 88, 132, "NULL", 0, 0, 0, "LAST_HIT", 0, 0, 0, "fighter"),
(14124, 14124, "Kat the Cat", 0, "", 0, "Monster.cat_the_cat", 9, 16, 68, "male", "L2Pet", 40, 5930, 1641, 11.85, 2.78, 40, 43, 30, 21, 20, 25, 0, 0, 1217, 449, 713, 421, 278, 0, 333, 0, 0, 0, 88, 132, "NULL", 0, 0, 0, "LAST_HIT", 0, 0, 0, "fighter"),
(14125, 14125, "Kat the Cat", 0, "", 0, "Monster.cat_the_cat", 9, 16, 70, "male", "L2Pet", 40, 6179, 1722, 11.85, 2.78, 40, 43, 30, 21, 20, 25, 0, 0, 1314, 470, 780, 440, 278, 0, 333, 0, 0, 0, 88, 132, "NULL", 0, 0, 0, "LAST_HIT", 0, 0, 0, "fighter"),
(14126, 14126, "Kat the Cat", 0, "", 0, "Monster.cat_the_cat", 9, 16, 72, "male", "L2Pet", 40, 6421, 1804, 13.43, 3.09, 40, 43, 30, 21, 20, 25, 0, 0, 1413, 491, 849, 460, 278, 0, 333, 0, 0, 0, 88, 132, "NULL", 0, 0, 0, "LAST_HIT", 0, 0, 0, "fighter"),
(14127, 14127, "Kat the Cat", 0, "", 0, "Monster.cat_the_cat", 9, 16, 74, "male", "L2Pet", 40, 6654, 1888, 13.43, 3.09, 40, 43, 30, 21, 20, 25, 0, 0, 1513, 512, 921, 480, 278, 0, 333, 0, 0, 0, 88, 132, "NULL", 0, 0, 0, "LAST_HIT", 0, 0, 0, "fighter"),
(14128, 14128, "Kat the Cat", 0, "", 0, "Monster.cat_the_cat", 9, 16, 76, "male", "L2Pet", 40, 6876, 1972, 13.43, 3.09, 40, 43, 30, 21, 20, 25, 0, 0, 1614, 534, 994, 500, 278, 0, 333, 0, 0, 0, 88, 132, "NULL", 0, 0, 0, "LAST_HIT", 0, 0, 0, "fighter"),
(14129, 14129, "Kat the Cat", 0, "", 0, "Monster.cat_the_cat", 9, 16, 78, "male", "L2Pet", 40, 7085, 2057, 13.43, 3.09, 40, 43, 30, 21, 20, 25, 0, 0, 1715, 555, 1069, 520, 278, 0, 333, 0, 0, 0, 88, 132, "NULL", 0, 0, 0, "LAST_HIT", 0, 0, 0, "fighter"),
(14130, 14130, "Kat the Cat", 0, "", 0, "Monster.cat_the_cat", 9, 16, 78, "male", "L2Pet", 40, 7085, 2057, 13.43, 3.09, 40, 43, 30, 21, 20, 25, 0, 0, 1723, 555, 1081, 520, 278, 0, 333, 0, 0, 0, 88, 132, "NULL", 0, 0, 0, "LAST_HIT", 0, 0, 0, "fighter"),
(14131, 14131, "Kat the Cat", 0, "", 0, "Monster.cat_the_cat", 9, 16, 78, "male", "L2Pet", 40, 7085, 2057, 13.43, 3.09, 40, 43, 30, 21, 20, 25, 0, 0, 1732, 555, 1093, 520, 278, 0, 333, 0, 0, 0, 88, 132, "NULL", 0, 0, 0, "LAST_HIT", 0, 0, 0, "fighter"),
(14132, 14132, "Kat the Cat", 0, "", 0, "Monster.cat_the_cat", 9, 16, 78, "male", "L2Pet", 40, 7085, 2057, 13.43, 3.09, 40, 43, 30, 21, 20, 25, 0, 0, 1740, 555, 1105, 520, 278, 0, 333, 0, 0, 0, 88, 132, "NULL", 0, 0, 0, "LAST_HIT", 0, 0, 0, "fighter"),
(14133, 14133, "Kat the Cat", 0, "", 0, "Monster.cat_the_cat", 9, 16, 78, "male", "L2Pet", 40, 7085, 2057, 13.43, 3.09, 40, 43, 30, 21, 20, 25, 0, 0, 1749, 555, 1117, 520, 278, 0, 333, 0, 0, 0, 88, 132, "NULL", 0, 0, 0, "LAST_HIT", 0, 0, 0, "fighter"),
(14134, 14134, "Kat the Cat", 0, "", 0, "Monster.cat_the_cat", 9, 16, 78, "male", "L2Pet", 40, 7085, 2057, 13.43, 3.09, 40, 43, 30, 21, 20, 25, 0, 0, 1757, 555, 1129, 520, 278, 0, 333, 0, 0, 0, 88, 132, "NULL", 0, 0, 0, "LAST_HIT", 0, 0, 0, "fighter"),
(14135, 14135, "Kat the Cat", 0, "", 0, "Monster.cat_the_cat", 9, 16, 78, "male", "L2Pet", 40, 7085, 2057, 13.43, 3.09, 40, 43, 30, 21, 20, 25, 0, 0, 1766, 555, 1141, 520, 278, 0, 333, 0, 0, 0, 88, 132, "NULL", 0, 0, 0, "LAST_HIT", 0, 0, 0, "fighter"),
(14136, 14136, "Kat the Cat", 0, "", 0, "Monster.cat_the_cat", 9, 16, 78, "male", "L2Pet", 40, 7085, 2057, 13.43, 3.09, 40, 43, 30, 21, 20, 25, 0, 0, 1775, 555, 1153, 520, 278, 0, 333, 0, 0, 0, 88, 132, "NULL", 0, 0, 0, "LAST_HIT", 0, 0, 0, "fighter"),
(14137, 14137, "Kat the Cat", 0, "", 0, "Monster.cat_the_cat", 9, 16, 78, "male", "L2Pet", 40, 7085, 2057, 13.43, 3.09, 40, 43, 30, 21, 20, 25, 0, 0, 1783, 555, 1165, 520, 278, 0, 333, 0, 0, 0, 88, 132, "NULL", 0, 0, 0, "LAST_HIT", 0, 0, 0, "balanced"),
(14138, 14138, "Kat the Cat", 0, "", 0, "Monster.cat_the_cat", 9, 16, 79, "male", "L2Pet", 40, 7085, 2057, 13.43, 3.09, 40, 43, 30, 21, 20, 25, 0, 0, 1802, 558, 1192, 523, 278, 0, 333, 0, 0, 0, 88, 132, "NULL", 0, 0, 0, "LAST_HIT", 0, 0, 0, "balanced"),
(14139, 14139, "Kat the Cat", 0, "", 0, "Monster.cat_the_cat", 9, 16, 79, "male", "L2Pet", 40, 7085, 2057, 13.43, 3.09, 40, 43, 30, 21, 20, 25, 0, 0, 1811, 558, 1204, 523, 278, 0, 333, 0, 0, 0, 88, 132, "NULL", 0, 0, 0, "LAST_HIT", 0, 0, 0, "balanced"),
(14140, 14140, "Kat the Cat", 0, "", 0, "Monster.cat_the_cat", 9, 16, 79, "male", "L2Pet", 40, 7085, 2057, 13.43, 3.09, 40, 43, 30, 21, 20, 25, 0, 0, 1820, 558, 1216, 523, 278, 0, 333, 0, 0, 0, 88, 132, "NULL", 0, 0, 0, "LAST_HIT", 0, 0, 0, "balanced"),
(14141, 14141, "Kat the Cat", 0, "", 0, "Monster.cat_the_cat", 9, 16, 79, "male", "L2Pet", 40, 7085, 2057, 13.43, 3.09, 40, 43, 30, 21, 20, 25, 0, 0, 1828, 558, 1228, 523, 278, 0, 333, 0, 0, 0, 88, 132, "NULL", 0, 0, 0, "LAST_HIT", 0, 0, 0, "balanced"),
(14142, 14142, "Kat the Cat", 0, "", 0, "Monster.cat_the_cat", 9, 16, 79, "male", "L2Pet", 40, 7085, 2057, 13.43, 3.09, 40, 43, 30, 21, 20, 25, 0, 0, 1837, 558, 1240, 523, 278, 0, 333, 0, 0, 0, 88, 132, "NULL", 0, 0, 0, "LAST_HIT", 0, 0, 0, "balanced"),
(14143, 14143, "Kat the Cat", 0, "", 0, "Monster.cat_the_cat", 9, 16, 79, "male", "L2Pet", 40, 7085, 2057, 13.43, 3.09, 40, 43, 30, 21, 20, 25, 0, 0, 1846, 558, 1253, 523, 278, 0, 333, 0, 0, 0, 88, 132, "NULL", 0, 0, 0, "LAST_HIT", 0, 0, 0, "balanced"),
(14144, 14144, "Kat the Cat", 0, "", 0, "Monster.cat_the_cat", 9, 16, 79, "male", "L2Pet", 40, 7085, 2057, 13.43, 3.09, 40, 43, 30, 21, 20, 25, 0, 0, 1854, 558, 1265, 523, 278, 0, 333, 0, 0, 0, 88, 132, "NULL", 0, 0, 0, "LAST_HIT", 0, 0, 0, "balanced"),
(14145, 14145, "Kat the Cat", 0, "", 0, "Monster.cat_the_cat", 9, 16, 79, "male", "L2Pet", 40, 7085, 2057, 13.43, 3.09, 40, 43, 30, 21, 20, 25, 0, 0, 1863, 558, 1277, 523, 278, 0, 333, 0, 0, 0, 88, 132, "NULL", 0, 0, 0, "LAST_HIT", 0, 0, 0, "balanced"),
(14146, 14146, "Kat the Cat", 0, "", 0, "Monster.cat_the_cat", 9, 16, 79, "male", "L2Pet", 40, 7085, 2057, 13.43, 3.09, 40, 43, 30, 21, 20, 25, 0, 0, 1871, 558, 1289, 523, 278, 0, 333, 0, 0, 0, 88, 132, "NULL", 0, 0, 0, "LAST_HIT", 0, 0, 0, "balanced"),
(14147, 14147, "Kat the Cat", 0, "", 0, "Monster.cat_the_cat", 9, 16, 80, "male", "L2Pet", 40, 7085, 2057, 13.43, 3.09, 40, 43, 30, 21, 20, 25, 0, 0, 1891, 562, 1317, 526, 278, 0, 333, 0, 0, 0, 88, 132, "NULL", 0, 0, 0, "LAST_HIT", 0, 0, 0, "balanced"),
(14148, 14148, "Kat the Cat", 0, "", 0, "Monster.cat_the_cat", 9, 16, 80, "male", "L2Pet", 40, 7085, 2057, 13.43, 3.09, 40, 43, 30, 21, 20, 25, 0, 0, 1900, 562, 1329, 526, 278, 0, 333, 0, 0, 0, 88, 132, "NULL", 0, 0, 0, "LAST_HIT", 0, 0, 0, "balanced"),
(14149, 14149, "Kat the Cat", 0, "", 0, "Monster.cat_the_cat", 9, 16, 80, "male", "L2Pet", 40, 7085, 2057, 13.43, 3.09, 40, 43, 30, 21, 20, 25, 0, 0, 1909, 562, 1342, 526, 278, 0, 333, 0, 0, 0, 88, 132, "NULL", 0, 0, 0, "LAST_HIT", 0, 0, 0, "balanced"),
(14150, 14150, "Kat the Cat", 0, "", 0, "Monster.cat_the_cat", 9, 16, 80, "male", "L2Pet", 40, 7085, 2057, 13.43, 3.09, 40, 43, 30, 21, 20, 25, 0, 0, 1917, 562, 1354, 526, 278, 0, 333, 0, 0, 0, 88, 132, "NULL", 0, 0, 0, "LAST_HIT", 0, 0, 0, "balanced"),
(14151, 14151, "Kat the Cat", 0, "", 0, "Monster.cat_the_cat", 9, 16, 80, "male", "L2Pet", 40, 7085, 2057, 13.43, 3.09, 40, 43, 30, 21, 20, 25, 0, 0, 1926, 562, 1366, 526, 278, 0, 333, 0, 0, 0, 88, 132, "NULL", 0, 0, 0, "LAST_HIT", 0, 0, 0, "balanced"),
(14152, 14152, "Kat the Cat", 0, "", 0, "Monster.cat_the_cat", 9, 16, 80, "male", "L2Pet", 40, 7085, 2057, 13.43, 3.09, 40, 43, 30, 21, 20, 25, 0, 0, 1935, 562, 1379, 526, 278, 0, 333, 0, 0, 0, 88, 132, "NULL", 0, 0, 0, "LAST_HIT", 0, 0, 0, "balanced"),
(14153, 14153, "Kat the Cat", 0, "", 0, "Monster.cat_the_cat", 9, 16, 80, "male", "L2Pet", 40, 7085, 2057, 13.43, 3.09, 40, 43, 30, 21, 20, 25, 0, 0, 1943, 562, 1391, 526, 278, 0, 333, 0, 0, 0, 88, 132, "NULL", 0, 0, 0, "LAST_HIT", 0, 0, 0, "balanced"),
(14154, 14154, "Kat the Cat", 0, "", 0, "Monster.cat_the_cat", 9, 16, 80, "male", "L2Pet", 40, 7085, 2057, 13.43, 3.09, 40, 43, 30, 21, 20, 25, 0, 0, 1952, 562, 1403, 526, 278, 0, 333, 0, 0, 0, 88, 132, "NULL", 0, 0, 0, "LAST_HIT", 0, 0, 0, "balanced"),
(14155, 14155, "Kat the Cat", 0, "", 0, "Monster.cat_the_cat", 9, 16, 80, "male", "L2Pet", 40, 7085, 2057, 13.43, 3.09, 40, 43, 30, 21, 20, 25, 0, 0, 1961, 562, 1416, 526, 278, 0, 333, 0, 0, 0, 88, 132, "NULL", 0, 0, 0, "LAST_HIT", 0, 0, 0, "balanced"),
(14156, 14156, "Kat the Cat", 0, "", 0, "Monster.cat_the_cat", 9, 16, 80, "male", "L2Pet", 40, 7085, 2057, 13.43, 3.09, 40, 43, 30, 21, 20, 25, 0, 0, 1969, 562, 1428, 526, 278, 0, 333, 0, 0, 0, 88, 132, "NULL", 0, 0, 0, "LAST_HIT", 0, 0, 0, "balanced"),
(14157, 14157, "Kat the Cat", 0, "", 0, "Monster.cat_the_cat", 9, 16, 80, "male", "L2Pet", 40, 7085, 2057, 13.43, 3.09, 40, 43, 30, 21, 20, 25, 0, 0, 1978, 562, 1440, 526, 278, 0, 333, 0, 0, 0, 88, 132, "NULL", 0, 0, 0, "LAST_HIT", 0, 0, 0, "balanced"),
(14158, 14158, "Kat the Cat", 0, "", 0, "Monster.cat_the_cat", 9, 16, 80, "male", "L2Pet", 40, 7085, 2057, 13.43, 3.09, 40, 43, 30, 21, 20, 25, 0, 0, 1987, 562, 1453, 526, 278, 0, 333, 0, 0, 0, 88, 132, "NULL", 0, 0, 0, "LAST_HIT", 0, 0, 0, "balanced"),
(14159, 14159, "Mew the Cat", 0, "", 0, "Monster.cutie_cat", 8, 15, 27, "female", "L2Pet", 40, 1302, 367, 5.53, 1.53, 40, 43, 30, 21, 20, 25, 0, 0, 104, 125, 45, 117, 278, 0, 333, 0, 0, 0, 52, 154, "NULL", 0, 0, 0, "LAST_HIT", 0, 0, 0, "fighter"),
(14160, 14160, "Mew the Cat", 0, "", 0, "Monster.cutie_cat", 8, 15, 37, "female", "L2Pet", 40, 2142, 553, 7.11, 1.84, 40, 43, 30, 21, 20, 25, 0, 0, 222, 182, 104, 170, 278, 0, 333, 0, 0, 0, 52, 154, "NULL", 0, 0, 0, "LAST_HIT", 0, 0, 0, "fighter"),
(14161, 14161, "Mew the Cat", 0, "", 0, "Monster.cutie_cat", 8, 15, 47, "female", "L2Pet", 40, 3227, 851, 8.69, 2.14, 40, 43, 30, 21, 20, 25, 0, 0, 427, 253, 216, 237, 278, 0, 333, 0, 0, 0, 48, 140, "NULL", 0, 0, 0, "LAST_HIT", 0, 0, 0, "fighter"),
(14162, 14162, "Mew the Cat", 0, "", 0, "Monster.cutie_cat", 8, 15, 54, "female", "L2Pet", 40, 4099, 1102, 10.27, 2.45, 40, 43, 30, 21, 20, 25, 0, 0, 636, 313, 339, 293, 278, 0, 333, 0, 0, 0, 48, 140, "NULL", 0, 0, 0, "LAST_HIT", 0, 0, 0, "fighter"),
(14163, 14163, "Mew the Cat", 0, "", 0, "Monster.cutie_cat", 8, 15, 22, "female", "L2Pet", 40, 978, 279, 5.53, 1.53, 40, 43, 30, 21, 20, 25, 0, 0, 68, 102, 28, 96, 278, 0, 333, 0, 0, 0, 52, 154, "NULL", 0, 0, 0, "LAST_HIT", 0, 0, 0, "fighter"),
(14164, 14164, "Mew the Cat", 0, "", 0, "Monster.cutie_cat", 8, 15, 32, "female", "L2Pet", 40, 1689, 458, 7.11, 1.84, 40, 43, 30, 21, 20, 25, 0, 0, 154, 151, 69, 142, 278, 0, 333, 0, 0, 0, 52, 154, "NULL", 0, 0, 0, "LAST_HIT", 0, 0, 0, "fighter"),
(14165, 14165, "Mew the Cat", 0, "", 0, "Monster.cutie_cat", 8, 15, 42, "female", "L2Pet", 40, 2656, 679, 8.69, 2.14, 40, 43, 30, 21, 20, 25, 0, 0, 311, 215, 152, 202, 278, 0, 333, 0, 0, 0, 52, 154, "NULL", 0, 0, 0, "LAST_HIT", 0, 0, 0, "fighter"),
(14166, 14166, "Mew the Cat", 0, "", 0, "Monster.cutie_cat", 8, 15, 50, "female", "L2Pet", 40, 3592, 957, 8.69, 2.14, 40, 43, 30, 21, 20, 25, 0, 0, 509, 278, 264, 260, 278, 0, 333, 0, 0, 0, 52, 154, "NULL", 0, 0, 0, "LAST_HIT", 0, 0, 0, "fighter"),
(14167, 14167, "Mew the Cat", 0, "", 0, "Monster.cutie_cat", 8, 15, 58, "female", "L2Pet", 40, 4622, 1251, 10.27, 2.45, 40, 43, 30, 21, 20, 25, 0, 0, 781, 349, 428, 327, 278, 0, 333, 0, 0, 0, 52, 154, "NULL", 0, 0, 0, "LAST_HIT", 0, 0, 0, "fighter"),
(14168, 14168, "Mew the Cat", 0, "", 0, "Monster.cutie_cat", 8, 15, 60, "female", "L2Pet", 40, 4887, 1327, 10.27, 2.45, 40, 43, 30, 21, 20, 25, 0, 0, 860, 368, 478, 345, 278, 0, 333, 0, 0, 0, 52, 154, "NULL", 0, 0, 0, "LAST_HIT", 0, 0, 0, "fighter"),
(14169, 14169, "Mew the Cat", 0, "", 0, "Monster.cutie_cat", 8, 15, 62, "female", "L2Pet", 40, 5151, 1404, 11.85, 2.78, 40, 43, 30, 21, 20, 25, 0, 0, 944, 388, 532, 363, 278, 0, 333, 0, 0, 0, 52, 154, "NULL", 0, 0, 0, "LAST_HIT", 0, 0, 0, "fighter"),
(14170, 14170, "Mew the Cat", 0, "", 0, "Monster.cutie_cat", 8, 15, 64, "female", "L2Pet", 40, 5414, 1482, 11.85, 2.78, 40, 43, 30, 21, 20, 25, 0, 0, 1031, 408, 589, 382, 278, 0, 333, 0, 0, 0, 52, 154, "NULL", 0, 0, 0, "LAST_HIT", 0, 0, 0, "fighter"),
(14171, 14171, "Mew the Cat", 0, "", 0, "Monster.cutie_cat", 8, 15, 66, "female", "L2Pet", 40, 5674, 1561, 11.85, 2.78, 40, 43, 30, 21, 20, 25, 0, 0, 1123, 428, 649, 401, 278, 0, 333, 0, 0, 0, 52, 154, "NULL", 0, 0, 0, "LAST_HIT", 0, 0, 0, "fighter"),
(14172, 14172, "Mew the Cat", 0, "", 0, "Monster.cutie_cat", 8, 15, 68, "female", "L2Pet", 40, 5930, 1641, 11.85, 2.78, 40, 43, 30, 21, 20, 25, 0, 0, 1217, 449, 713, 421, 278, 0, 333, 0, 0, 0, 52, 154, "NULL", 0, 0, 0, "LAST_HIT", 0, 0, 0, "fighter"),
(14173, 14173, "Mew the Cat", 0, "", 0, "Monster.cutie_cat", 8, 15, 70, "female", "L2Pet", 40, 6179, 1722, 11.85, 2.78, 40, 43, 30, 21, 20, 25, 0, 0, 1314, 470, 780, 440, 278, 0, 333, 0, 0, 0, 52, 154, "NULL", 0, 0, 0, "LAST_HIT", 0, 0, 0, "fighter"),
(14174, 14174, "Mew the Cat", 0, "", 0, "Monster.cutie_cat", 8, 15, 72, "female", "L2Pet", 40, 6421, 1804, 13.43, 3.09, 40, 43, 30, 21, 20, 25, 0, 0, 1413, 491, 849, 460, 278, 0, 333, 0, 0, 0, 52, 154, "NULL", 0, 0, 0, "LAST_HIT", 0, 0, 0, "fighter"),
(14175, 14175, "Mew the Cat", 0, "", 0, "Monster.cutie_cat", 8, 15, 74, "female", "L2Pet", 40, 6654, 1888, 13.43, 3.09, 40, 43, 30, 21, 20, 25, 0, 0, 1513, 512, 921, 480, 278, 0, 333, 0, 0, 0, 52, 154, "NULL", 0, 0, 0, "LAST_HIT", 0, 0, 0, "fighter"),
(14176, 14176, "Mew the Cat", 0, "", 0, "Monster.cutie_cat", 8, 15, 76, "female", "L2Pet", 40, 6876, 1972, 13.43, 3.09, 40, 43, 30, 21, 20, 25, 0, 0, 1614, 534, 994, 500, 278, 0, 333, 0, 0, 0, 52, 154, "NULL", 0, 0, 0, "LAST_HIT", 0, 0, 0, "fighter"),
(14177, 14177, "Mew the Cat", 0, "", 0, "Monster.cutie_cat", 8, 15, 78, "female", "L2Pet", 40, 7085, 2057, 13.43, 3.09, 40, 43, 30, 21, 20, 25, 0, 0, 1715, 555, 1069, 520, 278, 0, 333, 0, 0, 0, 52, 154, "NULL", 0, 0, 0, "LAST_HIT", 0, 0, 0, "fighter"),
(14178, 14178, "Mew the Cat", 0, "", 0, "Monster.cutie_cat", 8, 15, 78, "female", "L2Pet", 40, 7085, 2057, 13.43, 3.09, 40, 43, 30, 21, 20, 25, 0, 0, 1723, 555, 1081, 520, 278, 0, 333, 0, 0, 0, 52, 154, "NULL", 0, 0, 0, "LAST_HIT", 0, 0, 0, "fighter"),
(14179, 14179, "Mew the Cat", 0, "", 0, "Monster.cutie_cat", 8, 15, 78, "female", "L2Pet", 40, 7085, 2057, 13.43, 3.09, 40, 43, 30, 21, 20, 25, 0, 0, 1732, 555, 1093, 520, 278, 0, 333, 0, 0, 0, 52, 154, "NULL", 0, 0, 0, "LAST_HIT", 0, 0, 0, "fighter"),
(14180, 14180, "Mew the Cat", 0, "", 0, "Monster.cutie_cat", 8, 15, 78, "female", "L2Pet", 40, 7085, 2057, 13.43, 3.09, 40, 43, 30, 21, 20, 25, 0, 0, 1740, 555, 1105, 520, 278, 0, 333, 0, 0, 0, 52, 154, "NULL", 0, 0, 0, "LAST_HIT", 0, 0, 0, "fighter"),
(14181, 14181, "Mew the Cat", 0, "", 0, "Monster.cutie_cat", 8, 15, 78, "female", "L2Pet", 40, 7085, 2057, 13.43, 3.09, 40, 43, 30, 21, 20, 25, 0, 0, 1749, 555, 1117, 520, 278, 0, 333, 0, 0, 0, 52, 154, "NULL", 0, 0, 0, "LAST_HIT", 0, 0, 0, "fighter"),
(14182, 14182, "Mew the Cat", 0, "", 0, "Monster.cutie_cat", 8, 15, 78, "female", "L2Pet", 40, 7085, 2057, 13.43, 3.09, 40, 43, 30, 21, 20, 25, 0, 0, 1757, 555, 1129, 520, 278, 0, 333, 0, 0, 0, 52, 154, "NULL", 0, 0, 0, "LAST_HIT", 0, 0, 0, "fighter"),
(14183, 14183, "Mew the Cat", 0, "", 0, "Monster.cutie_cat", 8, 15, 78, "female", "L2Pet", 40, 7085, 2057, 13.43, 3.09, 40, 43, 30, 21, 20, 25, 0, 0, 1766, 555, 1141, 520, 278, 0, 333, 0, 0, 0, 52, 154, "NULL", 0, 0, 0, "LAST_HIT", 0, 0, 0, "fighter"),
(14184, 14184, "Mew the Cat", 0, "", 0, "Monster.cutie_cat", 8, 15, 78, "female", "L2Pet", 40, 7085, 2057, 13.43, 3.09, 40, 43, 30, 21, 20, 25, 0, 0, 1775, 555, 1153, 520, 278, 0, 333, 0, 0, 0, 52, 154, "NULL", 0, 0, 0, "LAST_HIT", 0, 0, 0, "fighter"),
(14185, 14185, "Mew the Cat", 0, "", 0, "Monster.cutie_cat", 8, 15, 78, "female", "L2Pet", 40, 7085, 2057, 13.43, 3.09, 40, 43, 30, 21, 20, 25, 0, 0, 1783, 555, 1165, 520, 278, 0, 333, 0, 0, 0, 52, 154, "NULL", 0, 0, 0, "LAST_HIT", 0, 0, 0, "balanced"),
(14186, 14186, "Mew the Cat", 0, "", 0, "Monster.cutie_cat", 8, 15, 79, "female", "L2Pet", 40, 7085, 2057, 13.43, 3.09, 40, 43, 30, 21, 20, 25, 0, 0, 1802, 558, 1192, 523, 278, 0, 333, 0, 0, 0, 52, 154, "NULL", 0, 0, 0, "LAST_HIT", 0, 0, 0, "balanced"),
(14187, 14187, "Mew the Cat", 0, "", 0, "Monster.cutie_cat", 8, 15, 79, "female", "L2Pet", 40, 7085, 2057, 13.43, 3.09, 40, 43, 30, 21, 20, 25, 0, 0, 1811, 558, 1204, 523, 278, 0, 333, 0, 0, 0, 52, 154, "NULL", 0, 0, 0, "LAST_HIT", 0, 0, 0, "balanced"),
(14188, 14188, "Mew the Cat", 0, "", 0, "Monster.cutie_cat", 8, 15, 79, "female", "L2Pet", 40, 7085, 2057, 13.43, 3.09, 40, 43, 30, 21, 20, 25, 0, 0, 1820, 558, 1216, 523, 278, 0, 333, 0, 0, 0, 52, 154, "NULL", 0, 0, 0, "LAST_HIT", 0, 0, 0, "balanced"),
(14189, 14189, "Mew the Cat", 0, "", 0, "Monster.cutie_cat", 8, 15, 79, "female", "L2Pet", 40, 7085, 2057, 13.43, 3.09, 40, 43, 30, 21, 20, 25, 0, 0, 1828, 558, 1228, 523, 278, 0, 333, 0, 0, 0, 52, 154, "NULL", 0, 0, 0, "LAST_HIT", 0, 0, 0, "balanced"),
(14190, 14190, "Mew the Cat", 0, "", 0, "Monster.cutie_cat", 8, 15, 79, "female", "L2Pet", 40, 7085, 2057, 13.43, 3.09, 40, 43, 30, 21, 20, 25, 0, 0, 1837, 558, 1240, 523, 278, 0, 333, 0, 0, 0, 52, 154, "NULL", 0, 0, 0, "LAST_HIT", 0, 0, 0, "balanced"),
(14191, 14191, "Mew the Cat", 0, "", 0, "Monster.cutie_cat", 8, 15, 79, "female", "L2Pet", 40, 7085, 2057, 13.43, 3.09, 40, 43, 30, 21, 20, 25, 0, 0, 1846, 558, 1253, 523, 278, 0, 333, 0, 0, 0, 52, 154, "NULL", 0, 0, 0, "LAST_HIT", 0, 0, 0, "balanced"),
(14192, 14192, "Mew the Cat", 0, "", 0, "Monster.cutie_cat", 8, 15, 79, "female", "L2Pet", 40, 7085, 2057, 13.43, 3.09, 40, 43, 30, 21, 20, 25, 0, 0, 1854, 558, 1265, 523, 278, 0, 333, 0, 0, 0, 52, 154, "NULL", 0, 0, 0, "LAST_HIT", 0, 0, 0, "balanced"),
(14193, 14193, "Mew the Cat", 0, "", 0, "Monster.cutie_cat", 8, 15, 79, "female", "L2Pet", 40, 7085, 2057, 13.43, 3.09, 40, 43, 30, 21, 20, 25, 0, 0, 1863, 558, 1277, 523, 278, 0, 333, 0, 0, 0, 52, 154, "NULL", 0, 0, 0, "LAST_HIT", 0, 0, 0, "balanced"),
(14194, 14194, "Mew the Cat", 0, "", 0, "Monster.cutie_cat", 8, 15, 79, "female", "L2Pet", 40, 7085, 2057, 13.43, 3.09, 40, 43, 30, 21, 20, 25, 0, 0, 1871, 558, 1289, 523, 278, 0, 333, 0, 0, 0, 52, 154, "NULL", 0, 0, 0, "LAST_HIT", 0, 0, 0, "balanced"),
(14195, 14195, "Mew the Cat", 0, "", 0, "Monster.cutie_cat", 8, 15, 80, "female", "L2Pet", 40, 7085, 2057, 13.43, 3.09, 40, 43, 30, 21, 20, 25, 0, 0, 1891, 562, 1317, 526, 278, 0, 333, 0, 0, 0, 52, 154, "NULL", 0, 0, 0, "LAST_HIT", 0, 0, 0, "balanced"),
(14196, 14196, "Mew the Cat", 0, "", 0, "Monster.cutie_cat", 8, 15, 80, "female", "L2Pet", 40, 7085, 2057, 13.43, 3.09, 40, 43, 30, 21, 20, 25, 0, 0, 1900, 562, 1329, 526, 278, 0, 333, 0, 0, 0, 52, 154, "NULL", 0, 0, 0, "LAST_HIT", 0, 0, 0, "balanced"),
(14197, 14197, "Mew the Cat", 0, "", 0, "Monster.cutie_cat", 8, 15, 80, "female", "L2Pet", 40, 7085, 2057, 13.43, 3.09, 40, 43, 30, 21, 20, 25, 0, 0, 1909, 562, 1342, 526, 278, 0, 333, 0, 0, 0, 52, 154, "NULL", 0, 0, 0, "LAST_HIT", 0, 0, 0, "balanced"),
(14198, 14198, "Mew the Cat", 0, "", 0, "Monster.cutie_cat", 8, 15, 80, "female", "L2Pet", 40, 7085, 2057, 13.43, 3.09, 40, 43, 30, 21, 20, 25, 0, 0, 1917, 562, 1354, 526, 278, 0, 333, 0, 0, 0, 52, 154, "NULL", 0, 0, 0, "LAST_HIT", 0, 0, 0, "balanced"),
(14199, 14199, "Mew the Cat", 0, "", 0, "Monster.cutie_cat", 8, 15, 80, "female", "L2Pet", 40, 7085, 2057, 13.43, 3.09, 40, 43, 30, 21, 20, 25, 0, 0, 1926, 562, 1366, 526, 278, 0, 333, 0, 0, 0, 52, 154, "NULL", 0, 0, 0, "LAST_HIT", 0, 0, 0, "balanced"),
(14200, 14200, "Mew the Cat", 0, "", 0, "Monster.cutie_cat", 8, 15, 80, "female", "L2Pet", 40, 7085, 2057, 13.43, 3.09, 40, 43, 30, 21, 20, 25, 0, 0, 1935, 562, 1379, 526, 278, 0, 333, 0, 0, 0, 52, 154, "NULL", 0, 0, 0, "LAST_HIT", 0, 0, 0, "balanced"),
(14201, 14201, "Mew the Cat", 0, "", 0, "Monster.cutie_cat", 8, 15, 80, "female", "L2Pet", 40, 7085, 2057, 13.43, 3.09, 40, 43, 30, 21, 20, 25, 0, 0, 1943, 562, 1391, 526, 278, 0, 333, 0, 0, 0, 52, 154, "NULL", 0, 0, 0, "LAST_HIT", 0, 0, 0, "balanced"),
(14202, 14202, "Mew the Cat", 0, "", 0, "Monster.cutie_cat", 8, 15, 80, "female", "L2Pet", 40, 7085, 2057, 13.43, 3.09, 40, 43, 30, 21, 20, 25, 0, 0, 1952, 562, 1403, 526, 278, 0, 333, 0, 0, 0, 52, 154, "NULL", 0, 0, 0, "LAST_HIT", 0, 0, 0, "balanced"),
(14203, 14203, "Mew the Cat", 0, "", 0, "Monster.cutie_cat", 8, 15, 80, "female", "L2Pet", 40, 7085, 2057, 13.43, 3.09, 40, 43, 30, 21, 20, 25, 0, 0, 1961, 562, 1416, 526, 278, 0, 333, 0, 0, 0, 52, 154, "NULL", 0, 0, 0, "LAST_HIT", 0, 0, 0, "balanced"),
(14204, 14204, "Mew the Cat", 0, "", 0, "Monster.cutie_cat", 8, 15, 80, "female", "L2Pet", 40, 7085, 2057, 13.43, 3.09, 40, 43, 30, 21, 20, 25, 0, 0, 1969, 562, 1428, 526, 278, 0, 333, 0, 0, 0, 52, 154, "NULL", 0, 0, 0, "LAST_HIT", 0, 0, 0, "balanced"),
(14205, 14205, "Mew the Cat", 0, "", 0, "Monster.cutie_cat", 8, 15, 80, "female", "L2Pet", 40, 7085, 2057, 13.43, 3.09, 40, 43, 30, 21, 20, 25, 0, 0, 1978, 562, 1440, 526, 278, 0, 333, 0, 0, 0, 52, 154, "NULL", 0, 0, 0, "LAST_HIT", 0, 0, 0, "balanced"),
(14206, 14206, "Mew the Cat", 0, "", 0, "Monster.cutie_cat", 8, 15, 80, "female", "L2Pet", 40, 7085, 2057, 13.43, 3.09, 40, 43, 30, 21, 20, 25, 0, 0, 1987, 562, 1453, 526, 278, 0, 333, 0, 0, 0, 52, 154, "NULL", 0, 0, 0, "LAST_HIT", 0, 0, 0, "balanced"),
(14207, 14207, "Kai the Cat", 0, "", 0, "Monster.silver_cat", 7, 15, 42, "male", "L2Pet", 40, 1992, 679, 8.69, 2.14, 40, 43, 30, 21, 20, 25, 0, 0, 342, 215, 152, 202, 278, 0, 333, 0, 0, 0, 48, 180, "NULL", 0, 0, 0, "LAST_HIT", 0, 0, 0, "fighter"),
(14208, 14208, "Kai the Cat", 0, "", 0, "Monster.silver_cat", 7, 15, 46, "male", "L2Pet", 40, 2331, 816, 8.69, 2.14, 40, 43, 30, 21, 20, 25, 0, 0, 442, 245, 202, 230, 278, 0, 333, 0, 0, 0, 52, 209, "NULL", 0, 0, 0, "LAST_HIT", 0, 0, 0, "fighter"),
(14209, 14209, "Kai the Cat", 0, "", 0, "Monster.silver_cat", 7, 15, 50, "male", "L2Pet", 40, 2694, 957, 8.69, 2.14, 40, 43, 30, 21, 20, 25, 0, 0, 560, 278, 264, 260, 278, 0, 333, 0, 0, 0, 48, 180, "NULL", 0, 0, 0, "LAST_HIT", 0, 0, 0, "fighter"),
(14210, 14210, "Kai the Cat", 0, "", 0, "Monster.silver_cat", 7, 15, 54, "male", "L2Pet", 40, 3074, 1102, 10.27, 2.45, 40, 43, 30, 21, 20, 25, 0, 0, 699, 313, 339, 293, 370, 0, 333, 0, 0, 0, 48, 180, "NULL", 0, 0, 0, "LAST_HIT", 0, 0, 0, "fighter"),
(14211, 14211, "Kai the Cat", 0, "", 0, "Monster.silver_cat", 7, 15, 58, "male", "L2Pet", 40, 3467, 1251, 10.27, 2.45, 40, 43, 30, 21, 20, 25, 0, 0, 859, 349, 428, 327, 278, 0, 333, 0, 0, 0, 48, 180, "NULL", 0, 0, 0, "LAST_HIT", 0, 0, 0, "fighter"),
(14212, 14212, "Kai the Cat", 0, "", 0, "Monster.silver_cat", 7, 15, 60, "male", "L2Pet", 40, 3665, 1327, 10.27, 2.45, 40, 43, 30, 21, 20, 25, 0, 0, 946, 368, 478, 345, 278, 0, 333, 0, 0, 0, 52, 209, "NULL", 0, 0, 0, "LAST_HIT", 0, 0, 0, "fighter"),
(14213, 14213, "Kai the Cat", 0, "", 0, "Monster.silver_cat", 7, 15, 62, "male", "L2Pet", 40, 3863, 1404, 11.85, 2.78, 40, 43, 30, 21, 20, 25, 0, 0, 1038, 388, 532, 363, 278, 0, 333, 0, 0, 0, 52, 209, "NULL", 0, 0, 0, "LAST_HIT", 0, 0, 0, "fighter"),
(14214, 14214, "Kai the Cat", 0, "", 0, "Monster.silver_cat", 7, 15, 64, "male", "L2Pet", 40, 4060, 1482, 11.85, 2.78, 40, 43, 30, 21, 20, 25, 0, 0, 1135, 408, 589, 382, 278, 0, 333, 0, 0, 0, 52, 209, "NULL", 0, 0, 0, "LAST_HIT", 0, 0, 0, "fighter"),
(14215, 14215, "Kai the Cat", 0, "", 0, "Monster.silver_cat", 7, 15, 66, "male", "L2Pet", 40, 4255, 1561, 11.85, 2.78, 40, 43, 30, 21, 20, 25, 0, 0, 1235, 428, 649, 401, 370, 0, 333, 0, 0, 0, 48, 180, "NULL", 0, 0, 0, "LAST_HIT", 0, 0, 0, "fighter"),
(14216, 14216, "Kai the Cat", 0, "", 0, "Monster.silver_cat", 7, 15, 68, "male", "L2Pet", 40, 4447, 1641, 11.85, 2.78, 40, 43, 30, 21, 20, 25, 0, 0, 1339, 449, 713, 421, 278, 0, 333, 0, 0, 0, 52, 209, "NULL", 0, 0, 0, "LAST_HIT", 0, 0, 0, "fighter"),
(14217, 14217, "Kai the Cat", 0, "", 0, "Monster.silver_cat", 7, 15, 70, "male", "L2Pet", 40, 4634, 1722, 11.85, 2.78, 40, 43, 30, 21, 20, 25, 0, 0, 1445, 470, 780, 440, 370, 0, 333, 0, 0, 0, 48, 180, "NULL", 0, 0, 0, "LAST_HIT", 0, 0, 0, "fighter"),
(14218, 14218, "Kai the Cat", 0, "", 0, "Monster.silver_cat", 7, 15, 72, "male", "L2Pet", 40, 4816, 1804, 13.43, 3.09, 40, 43, 30, 21, 20, 25, 0, 0, 1554, 491, 849, 460, 278, 0, 333, 0, 0, 0, 52, 209, "NULL", 0, 0, 0, "LAST_HIT", 0, 0, 0, "fighter"),
(14219, 14219, "Kai the Cat", 0, "", 0, "Monster.silver_cat", 7, 15, 74, "male", "L2Pet", 40, 4990, 1888, 13.43, 3.09, 40, 43, 30, 21, 20, 25, 0, 0, 1664, 512, 921, 480, 278, 0, 333, 0, 0, 0, 52, 209, "NULL", 0, 0, 0, "LAST_HIT", 0, 0, 0, "fighter"),
(14220, 14220, "Kai the Cat", 0, "", 0, "Monster.silver_cat", 7, 15, 76, "male", "L2Pet", 40, 5157, 1972, 8.69, 2.14, 40, 43, 30, 21, 20, 25, 0, 0, 1775, 534, 994, 510, 370, 0, 333, 0, 0, 0, 48, 180, "NULL", 0, 0, 0, "LAST_HIT", 0, 0, 0, "fighter"),
(14221, 14221, "Kai the Cat", 0, "", 0, "Monster.silver_cat", 7, 15, 78, "male", "L2Pet", 40, 5314, 2057, 13.43, 3.09, 40, 43, 30, 21, 20, 25, 0, 0, 1886, 555, 1069, 520, 278, 0, 333, 0, 0, 0, 52, 209, "NULL", 0, 0, 0, "LAST_HIT", 0, 0, 0, "fighter"),
(14222, 14222, "Kai the Cat", 0, "", 0, "Monster.silver_cat", 7, 15, 78, "male", "L2Pet", 40, 5314, 2057, 13.43, 3.09, 40, 43, 30, 21, 20, 25, 0, 0, 1895, 555, 1081, 520, 278, 0, 333, 0, 0, 0, 52, 209, "NULL", 0, 0, 0, "LAST_HIT", 0, 0, 0, "fighter"),
(14223, 14223, "Kai the Cat", 0, "", 0, "Monster.silver_cat", 7, 15, 78, "male", "L2Pet", 40, 5314, 2057, 13.43, 3.09, 40, 43, 30, 21, 20, 25, 0, 0, 1905, 555, 1093, 520, 278, 0, 333, 0, 0, 0, 52, 209, "NULL", 0, 0, 0, "LAST_HIT", 0, 0, 0, "fighter"),
(14224, 14224, "Kai the Cat", 0, "", 0, "Monster.silver_cat", 7, 15, 78, "male", "L2Pet", 40, 5314, 2057, 13.43, 3.09, 40, 43, 30, 21, 20, 25, 0, 0, 1914, 555, 1105, 520, 278, 0, 333, 0, 0, 0, 52, 209, "NULL", 0, 0, 0, "LAST_HIT", 0, 0, 0, "fighter"),
(14225, 14225, "Kai the Cat", 0, "", 0, "Monster.silver_cat", 7, 15, 78, "male", "L2Pet", 40, 5314, 2057, 13.43, 3.09, 40, 43, 30, 21, 20, 25, 0, 0, 1924, 555, 1117, 520, 278, 0, 333, 0, 0, 0, 52, 209, "NULL", 0, 0, 0, "LAST_HIT", 0, 0, 0, "fighter"),
(14226, 14226, "Kai the Cat", 0, "", 0, "Monster.silver_cat", 7, 15, 78, "male", "L2Pet", 40, 5314, 2057, 13.43, 3.09, 40, 43, 30, 21, 20, 25, 0, 0, 1933, 555, 1129, 520, 278, 0, 333, 0, 0, 0, 52, 209, "NULL", 0, 0, 0, "LAST_HIT", 0, 0, 0, "fighter"),
(14227, 14227, "Kai the Cat", 0, "", 0, "Monster.silver_cat", 7, 15, 78, "male", "L2Pet", 40, 5314, 2057, 13.43, 3.09, 40, 43, 30, 21, 20, 25, 0, 0, 1943, 555, 1141, 520, 278, 0, 333, 0, 0, 0, 52, 209, "NULL", 0, 0, 0, "LAST_HIT", 0, 0, 0, "fighter"),
(14228, 14228, "Kai the Cat", 0, "", 0, "Monster.silver_cat", 7, 15, 78, "male", "L2Pet", 40, 5314, 2057, 13.43, 3.09, 40, 43, 30, 21, 20, 25, 0, 0, 1952, 555, 1153, 520, 278, 0, 333, 0, 0, 0, 52, 209, "NULL", 0, 0, 0, "LAST_HIT", 0, 0, 0, "fighter"),
(14229, 14229, "Kai the Cat", 0, "", 0, "Monster.silver_cat", 7, 15, 78, "male", "L2Pet", 40, 5314, 2057, 13.43, 3.09, 40, 43, 30, 21, 20, 25, 0, 0, 1962, 555, 1165, 520, 278, 0, 333, 0, 0, 0, 52, 209, "NULL", 0, 0, 0, "LAST_HIT", 0, 0, 0, "fighter"),
(14230, 14230, "Kai the Cat", 0, "", 0, "Monster.silver_cat", 7, 15, 79, "male", "L2Pet", 40, 5314, 2057, 13.43, 3.09, 40, 43, 30, 21, 20, 25, 0, 0, 1983, 558, 1192, 523, 278, 0, 333, 0, 0, 0, 52, 209, "NULL", 0, 0, 0, "LAST_HIT", 0, 0, 0, "fighter"),
(14231, 14231, "Kai the Cat", 0, "", 0, "Monster.silver_cat", 7, 15, 79, "male", "L2Pet", 40, 5314, 2057, 13.43, 3.09, 40, 43, 30, 21, 20, 25, 0, 0, 1992, 558, 1204, 523, 278, 0, 333, 0, 0, 0, 52, 209, "NULL", 0, 0, 0, "LAST_HIT", 0, 0, 0, "fighter"),
(14232, 14232, "Kai the Cat", 0, "", 0, "Monster.silver_cat", 7, 15, 79, "male", "L2Pet", 40, 5314, 2057, 13.43, 3.09, 40, 43, 30, 21, 20, 25, 0, 0, 2002, 558, 1216, 523, 278, 0, 333, 0, 0, 0, 52, 209, "NULL", 0, 0, 0, "LAST_HIT", 0, 0, 0, "fighter"),
(14233, 14233, "Kai the Cat", 0, "", 0, "Monster.silver_cat", 7, 15, 79, "male", "L2Pet", 40, 5314, 2057, 13.43, 3.09, 40, 43, 30, 21, 20, 25, 0, 0, 2011, 558, 1228, 523, 278, 0, 333, 0, 0, 0, 52, 209, "NULL", 0, 0, 0, "LAST_HIT", 0, 0, 0, "fighter"),
(14234, 14234, "Kai the Cat", 0, "", 0, "Monster.silver_cat", 7, 15, 79, "male", "L2Pet", 40, 5314, 2057, 13.43, 3.09, 40, 43, 30, 21, 20, 25, 0, 0, 2021, 558, 1240, 523, 278, 0, 333, 0, 0, 0, 52, 209, "NULL", 0, 0, 0, "LAST_HIT", 0, 0, 0, "fighter"),
(14235, 14235, "Kai the Cat", 0, "", 0, "Monster.silver_cat", 7, 15, 79, "male", "L2Pet", 40, 5314, 2057, 13.43, 3.09, 40, 43, 30, 21, 20, 25, 0, 0, 2030, 558, 1253, 523, 278, 0, 333, 0, 0, 0, 52, 209, "NULL", 0, 0, 0, "LAST_HIT", 0, 0, 0, "fighter"),
(14236, 14236, "Kai the Cat", 0, "", 0, "Monster.silver_cat", 7, 15, 79, "male", "L2Pet", 40, 5314, 2057, 13.43, 3.09, 40, 43, 30, 21, 20, 25, 0, 0, 2040, 558, 1265, 523, 278, 0, 333, 0, 0, 0, 52, 209, "NULL", 0, 0, 0, "LAST_HIT", 0, 0, 0, "fighter"),
(14237, 14237, "Kai the Cat", 0, "", 0, "Monster.silver_cat", 7, 15, 79, "male", "L2Pet", 40, 5314, 2057, 13.43, 3.09, 40, 43, 30, 21, 20, 25, 0, 0, 2049, 558, 1277, 523, 278, 0, 333, 0, 0, 0, 52, 209, "NULL", 0, 0, 0, "LAST_HIT", 0, 0, 0, "fighter"),
(14238, 14238, "Kai the Cat", 0, "", 0, "Monster.silver_cat", 7, 15, 79, "male", "L2Pet", 40, 5314, 2057, 13.43, 3.09, 40, 43, 30, 21, 20, 25, 0, 0, 2059, 558, 1289, 523, 278, 0, 333, 0, 0, 0, 52, 209, "NULL", 0, 0, 0, "LAST_HIT", 0, 0, 0, "fighter"),
(14239, 14239, "Kai the Cat", 0, "", 0, "Monster.silver_cat", 7, 15, 80, "male", "L2Pet", 40, 5314, 2057, 13.43, 3.09, 40, 43, 30, 21, 20, 25, 0, 0, 2080, 562, 1317, 526, 278, 0, 333, 0, 0, 0, 52, 209, "NULL", 0, 0, 0, "LAST_HIT", 0, 0, 0, "fighter"),
(14240, 14240, "Kai the Cat", 0, "", 0, "Monster.silver_cat", 7, 15, 80, "male", "L2Pet", 40, 5314, 2057, 13.43, 3.09, 40, 43, 30, 21, 20, 25, 0, 0, 2090, 562, 1329, 526, 278, 0, 333, 0, 0, 0, 52, 209, "NULL", 0, 0, 0, "LAST_HIT", 0, 0, 0, "fighter"),
(14241, 14241, "Kai the Cat", 0, "", 0, "Monster.silver_cat", 7, 15, 80, "male", "L2Pet", 40, 5314, 2057, 13.43, 3.09, 40, 43, 30, 21, 20, 25, 0, 0, 2100, 562, 1342, 526, 278, 0, 333, 0, 0, 0, 52, 209, "NULL", 0, 0, 0, "LAST_HIT", 0, 0, 0, "fighter"),
(14242, 14242, "Kai the Cat", 0, "", 0, "Monster.silver_cat", 7, 15, 80, "male", "L2Pet", 40, 5314, 2057, 13.43, 3.09, 40, 43, 30, 21, 20, 25, 0, 0, 2109, 562, 1354, 526, 278, 0, 333, 0, 0, 0, 52, 209, "NULL", 0, 0, 0, "LAST_HIT", 0, 0, 0, "fighter"),
(14243, 14243, "Kai the Cat", 0, "", 0, "Monster.silver_cat", 7, 15, 80, "male", "L2Pet", 40, 5314, 2057, 13.43, 3.09, 40, 43, 30, 21, 20, 25, 0, 0, 2119, 562, 1366, 526, 278, 0, 333, 0, 0, 0, 52, 209, "NULL", 0, 0, 0, "LAST_HIT", 0, 0, 0, "fighter"),
(14244, 14244, "Kai the Cat", 0, "", 0, "Monster.silver_cat", 7, 15, 80, "male", "L2Pet", 40, 5314, 2057, 13.43, 3.09, 40, 43, 30, 21, 20, 25, 0, 0, 2128, 562, 1379, 526, 278, 0, 333, 0, 0, 0, 52, 209, "NULL", 0, 0, 0, "LAST_HIT", 0, 0, 0, "fighter"),
(14245, 14245, "Kai the Cat", 0, "", 0, "Monster.silver_cat", 7, 15, 80, "male", "L2Pet", 40, 5314, 2057, 13.43, 3.09, 40, 43, 30, 21, 20, 25, 0, 0, 2138, 562, 1391, 526, 278, 0, 333, 0, 0, 0, 52, 209, "NULL", 0, 0, 0, "LAST_HIT", 0, 0, 0, "balanced"),
(14246, 14246, "Kai the Cat", 0, "", 0, "Monster.silver_cat", 7, 15, 80, "male", "L2Pet", 40, 5314, 2057, 13.43, 3.09, 40, 43, 30, 21, 20, 25, 0, 0, 2147, 562, 1403, 526, 278, 0, 333, 0, 0, 0, 52, 209, "NULL", 0, 0, 0, "LAST_HIT", 0, 0, 0, "balanced"),
(14247, 14247, "Kai the Cat", 0, "", 0, "Monster.silver_cat", 7, 15, 80, "male", "L2Pet", 40, 5314, 2057, 13.43, 3.09, 40, 43, 30, 21, 20, 25, 0, 0, 2157, 562, 1416, 526, 278, 0, 333, 0, 0, 0, 52, 209, "NULL", 0, 0, 0, "LAST_HIT", 0, 0, 0, "balanced"),
(14248, 14248, "Kai the Cat", 0, "", 0, "Monster.silver_cat", 7, 15, 80, "male", "L2Pet", 40, 5314, 2057, 13.43, 3.09, 40, 43, 30, 21, 20, 25, 0, 0, 2166, 562, 1428, 526, 278, 0, 333, 0, 0, 0, 52, 209, "NULL", 0, 0, 0, "LAST_HIT", 0, 0, 0, "balanced"),
(14249, 14249, "Kai the Cat", 0, "", 0, "Monster.silver_cat", 7, 15, 80, "male", "L2Pet", 40, 5314, 2057, 13.43, 3.09, 40, 43, 30, 21, 20, 25, 0, 0, 2176, 562, 1440, 526, 278, 0, 333, 0, 0, 0, 52, 209, "NULL", 0, 0, 0, "LAST_HIT", 0, 0, 0, "balanced"),
(14250, 14250, "Kai the Cat", 0, "", 0, "Monster.silver_cat", 7, 15, 80, "male", "L2Pet", 40, 5314, 2057, 13.43, 3.09, 40, 43, 30, 21, 20, 25, 0, 0, 2185, 562, 1453, 526, 278, 0, 333, 0, 0, 0, 52, 209, "NULL", 0, 0, 0, "LAST_HIT", 0, 0, 0, "balanced"),
(14251, 14251, "Feline Queen", 0, "", 0, "Monster2.queen_of_cat", 8, 15, 58, "female", "L2Pet", 40, 2889, 1251, 10.27, 2.45, 40, 43, 30, 21, 20, 25, 0, 0, 313, 349, 428, 327, 278, 0, 333, 0, 0, 0, 28, 198, "NULL", 0, 0, 0, "LAST_HIT", 0, 0, 0, "balanced"),
(14252, 14252, "Feline Queen", 0, "", 0, "Monster2.queen_of_cat", 8, 15, 60, "female", "L2Pet", 40, 3054, 1327, 10.27, 2.45, 40, 43, 30, 21, 20, 25, 0, 0, 340, 368, 478, 345, 278, 0, 333, 0, 0, 0, 28, 198, "NULL", 0, 0, 0, "LAST_HIT", 0, 0, 0, "balanced"),
(14253, 14253, "Feline Queen", 0, "", 0, "Monster2.queen_of_cat", 8, 15, 62, "female", "L2Pet", 40, 3219, 1404, 11.85, 2.78, 40, 43, 30, 21, 20, 25, 0, 0, 368, 388, 532, 363, 278, 0, 333, 0, 0, 0, 26, 170, "NULL", 0, 0, 0, "LAST_HIT", 0, 0, 0, "balanced"),
(14254, 14254, "Feline Queen", 0, "", 0, "Monster2.queen_of_cat", 8, 15, 64, "female", "L2Pet", 40, 3384, 1482, 11.85, 2.78, 40, 43, 30, 21, 20, 25, 0, 0, 397, 408, 589, 382, 278, 0, 333, 0, 0, 0, 28, 198, "NULL", 0, 0, 0, "LAST_HIT", 0, 0, 0, "balanced"),
(14255, 14255, "Feline Queen", 0, "", 0, "Monster2.queen_of_cat", 8, 15, 66, "female", "L2Pet", 40, 3546, 1561, 11.85, 2.78, 40, 43, 30, 21, 20, 25, 0, 0, 427, 428, 649, 401, 278, 0, 333, 0, 0, 0, 28, 198, "NULL", 0, 0, 0, "LAST_HIT", 0, 0, 0, "balanced"),
(14256, 14256, "Feline Queen", 0, "", 0, "Monster2.queen_of_cat", 8, 15, 68, "female", "L2Pet", 40, 3706, 1641, 11.85, 2.78, 40, 43, 30, 21, 20, 25, 0, 0, 457, 449, 713, 421, 278, 0, 333, 0, 0, 0, 28, 198, "NULL", 0, 0, 0, "LAST_HIT", 0, 0, 0, "balanced"),
(14257, 14257, "Feline Queen", 0, "", 0, "Monster2.queen_of_cat", 8, 15, 70, "female", "L2Pet", 40, 3862, 1722, 11.85, 2.78, 40, 43, 30, 21, 20, 25, 0, 0, 487, 470, 780, 440, 278, 0, 333, 0, 0, 0, 28, 198, "NULL", 0, 0, 0, "LAST_HIT", 0, 0, 0, "balanced"),
(14258, 14258, "Feline Queen", 0, "", 0, "Monster2.queen_of_cat", 8, 15, 72, "female", "L2Pet", 40, 4013, 1804, 13.43, 3.09, 40, 43, 30, 21, 20, 25, 0, 0, 517, 491, 849, 460, 278, 0, 333, 0, 0, 0, 28, 198, "NULL", 0, 0, 0, "LAST_HIT", 0, 0, 0, "balanced"),
(14259, 14259, "Feline Queen", 0, "", 0, "Monster2.queen_of_cat", 8, 15, 74, "female", "L2Pet", 40, 4158, 1888, 13.43, 3.09, 40, 43, 30, 21, 20, 25, 0, 0, 547, 512, 921, 480, 278, 0, 333, 0, 0, 0, 28, 198, "NULL", 0, 0, 0, "LAST_HIT", 0, 0, 0, "balanced"),
(14260, 14260, "Feline Queen", 0, "", 0, "Monster2.queen_of_cat", 8, 15, 76, "female", "L2Pet", 40, 4297, 1972, 13.43, 3.09, 40, 43, 30, 21, 20, 25, 0, 0, 577, 534, 994, 500, 278, 0, 333, 0, 0, 0, 26, 170, "NULL", 0, 0, 0, "LAST_HIT", 0, 0, 0, "balanced"),
(14265, 14265, "Feline Queen", 0, "", 0, "Monster2.queen_of_cat", 8, 15, 78, "female", "L2Pet", 40, 4428, 2057, 13.43, 3.09, 40, 43, 30, 21, 20, 25, 0, 0, 595, 555, 1069, 520, 370, 0, 432, 0, 0, 0, 26, 170, "NULL", 0, 0, 0, "LAST_HIT", 0, 0, 0, "balanced"),
(14266, 14266, "Feline Queen", 0, "", 0, "Monster2.queen_of_cat", 8, 15, 78, "female", "L2Pet", 40, 4428, 2057, 13.43, 3.09, 40, 43, 30, 21, 20, 25, 0, 0, 595, 555, 1069, 520, 278, 0, 333, 0, 0, 0, 28, 198, "NULL", 0, 0, 0, "LAST_HIT", 0, 0, 0, "balanced"),
(14267, 14267, "Feline Queen", 0, "", 0, "Monster2.queen_of_cat", 8, 15, 78, "female", "L2Pet", 40, 4428, 2057, 13.43, 3.09, 40, 43, 30, 21, 20, 25, 0, 0, 595, 555, 1069, 520, 278, 0, 333, 0, 0, 0, 28, 198, "NULL", 0, 0, 0, "LAST_HIT", 0, 0, 0, "balanced"),
(14268, 14268, "Feline Queen", 0, "", 0, "Monster2.queen_of_cat", 8, 15, 78, "female", "L2Pet", 40, 4428, 2057, 13.43, 3.09, 40, 43, 30, 21, 20, 25, 0, 0, 595, 555, 1069, 520, 278, 0, 333, 0, 0, 0, 28, 198, "NULL", 0, 0, 0, "LAST_HIT", 0, 0, 0, "balanced"),
(14269, 14269, "Feline Queen", 0, "", 0, "Monster2.queen_of_cat", 8, 15, 78, "female", "L2Pet", 40, 4428, 2057, 13.43, 3.09, 40, 43, 30, 21, 20, 25, 0, 0, 595, 555, 1069, 520, 278, 0, 333, 0, 0, 0, 28, 198, "NULL", 0, 0, 0, "LAST_HIT", 0, 0, 0, "balanced"),
(14270, 14270, "Feline Queen", 0, "", 0, "Monster2.queen_of_cat", 8, 15, 78, "female", "L2Pet", 40, 4428, 2057, 13.43, 3.09, 40, 43, 30, 21, 20, 25, 0, 0, 595, 555, 1069, 520, 278, 0, 333, 0, 0, 0, 28, 198, "NULL", 0, 0, 0, "LAST_HIT", 0, 0, 0, "balanced"),
(14271, 14271, "Feline Queen", 0, "", 0, "Monster2.queen_of_cat", 8, 15, 78, "female", "L2Pet", 40, 4428, 2057, 13.43, 3.09, 40, 43, 30, 21, 20, 25, 0, 0, 595, 555, 1069, 520, 278, 0, 333, 0, 0, 0, 28, 198, "NULL", 0, 0, 0, "LAST_HIT", 0, 0, 0, "balanced"),
(14272, 14272, "Feline Queen", 0, "", 0, "Monster2.queen_of_cat", 8, 15, 78, "female", "L2Pet", 40, 4428, 2057, 13.43, 3.09, 40, 43, 30, 21, 20, 25, 0, 0, 595, 555, 1069, 520, 278, 0, 333, 0, 0, 0, 28, 198, "NULL", 0, 0, 0, "LAST_HIT", 0, 0, 0, "balanced"),
(14273, 14273, "Feline Queen", 0, "", 0, "Monster2.queen_of_cat", 8, 15, 78, "female", "L2Pet", 40, 4428, 2057, 13.43, 3.09, 40, 43, 30, 21, 20, 25, 0, 0, 595, 555, 1069, 520, 278, 0, 333, 0, 0, 0, 28, 198, "NULL", 0, 0, 0, "LAST_HIT", 0, 0, 0, "balanced"),
(14274, 14274, "Feline Queen", 0, "", 0, "Monster2.queen_of_cat", 8, 15, 79, "female", "L2Pet", 40, 4428, 2057, 13.43, 3.09, 40, 43, 30, 21, 20, 25, 0, 0, 598, 558, 1082, 523, 278, 0, 333, 0, 0, 0, 28, 198, "NULL", 0, 0, 0, "LAST_HIT", 0, 0, 0, "balanced"),
(14275, 14275, "Feline Queen", 0, "", 0, "Monster2.queen_of_cat", 8, 15, 79, "female", "L2Pet", 40, 4428, 2057, 13.43, 3.09, 40, 43, 30, 21, 20, 25, 0, 0, 598, 558, 1082, 523, 278, 0, 333, 0, 0, 0, 28, 198, "NULL", 0, 0, 0, "LAST_HIT", 0, 0, 0, "balanced"),
(14276, 14276, "Feline Queen", 0, "", 0, "Monster2.queen_of_cat", 8, 15, 79, "female", "L2Pet", 40, 4428, 2057, 13.43, 3.09, 40, 43, 30, 21, 20, 25, 0, 0, 598, 558, 1082, 523, 278, 0, 333, 0, 0, 0, 28, 198, "NULL", 0, 0, 0, "LAST_HIT", 0, 0, 0, "balanced"),
(14277, 14277, "Feline Queen", 0, "", 0, "Monster2.queen_of_cat", 8, 15, 79, "female", "L2Pet", 40, 4428, 2057, 13.43, 3.09, 40, 43, 30, 21, 20, 25, 0, 0, 598, 558, 1082, 523, 278, 0, 333, 0, 0, 0, 28, 198, "NULL", 0, 0, 0, "LAST_HIT", 0, 0, 0, "balanced"),
(14278, 14278, "Feline Queen", 0, "", 0, "Monster2.queen_of_cat", 8, 15, 79, "female", "L2Pet", 40, 4428, 2057, 13.43, 3.09, 40, 43, 30, 21, 20, 25, 0, 0, 598, 558, 1082, 523, 278, 0, 333, 0, 0, 0, 28, 198, "NULL", 0, 0, 0, "LAST_HIT", 0, 0, 0, "balanced"),
(14279, 14279, "Feline Queen", 0, "", 0, "Monster2.queen_of_cat", 8, 15, 79, "female", "L2Pet", 40, 4428, 2057, 13.43, 3.09, 40, 43, 30, 21, 20, 25, 0, 0, 598, 558, 1082, 523, 278, 0, 333, 0, 0, 0, 28, 198, "NULL", 0, 0, 0, "LAST_HIT", 0, 0, 0, "balanced"),
(14280, 14280, "Feline Queen", 0, "", 0, "Monster2.queen_of_cat", 8, 15, 79, "female", "L2Pet", 40, 4428, 2057, 13.43, 3.09, 40, 43, 30, 21, 20, 25, 0, 0, 598, 558, 1082, 523, 278, 0, 333, 0, 0, 0, 28, 198, "NULL", 0, 0, 0, "LAST_HIT", 0, 0, 0, "balanced"),
(14281, 14281, "Feline Queen", 0, "", 0, "Monster2.queen_of_cat", 8, 15, 79, "female", "L2Pet", 40, 4428, 2057, 13.43, 3.09, 40, 43, 30, 21, 20, 25, 0, 0, 598, 558, 1082, 523, 278, 0, 333, 0, 0, 0, 28, 198, "NULL", 0, 0, 0, "LAST_HIT", 0, 0, 0, "balanced"),
(14282, 14282, "Feline Queen", 0, "", 0, "Monster2.queen_of_cat", 8, 15, 79, "female", "L2Pet", 40, 4428, 2057, 13.43, 3.09, 40, 43, 30, 21, 20, 25, 0, 0, 598, 558, 1082, 523, 278, 0, 333, 0, 0, 0, 28, 198, "NULL", 0, 0, 0, "LAST_HIT", 0, 0, 0, "balanced"),
(14283, 14283, "Feline Queen", 0, "", 0, "Monster2.queen_of_cat", 8, 15, 80, "female", "L2Pet", 40, 4428, 2057, 13.43, 3.09, 40, 43, 30, 21, 20, 25, 0, 0, 602, 562, 1095, 526, 278, 0, 333, 0, 0, 0, 28, 198, "NULL", 0, 0, 0, "LAST_HIT", 0, 0, 0, "balanced"),
(14284, 14284, "Feline Queen", 0, "", 0, "Monster2.queen_of_cat", 8, 15, 80, "female", "L2Pet", 40, 4428, 2057, 13.43, 3.09, 40, 43, 30, 21, 20, 25, 0, 0, 602, 562, 1095, 526, 278, 0, 333, 0, 0, 0, 28, 198, "NULL", 0, 0, 0, "LAST_HIT", 0, 0, 0, "balanced"),
(14285, 14285, "Feline Queen", 0, "", 0, "Monster2.queen_of_cat", 8, 15, 80, "female", "L2Pet", 40, 4428, 2057, 13.43, 3.09, 40, 43, 30, 21, 20, 25, 0, 0, 602, 562, 1095, 526, 278, 0, 333, 0, 0, 0, 28, 198, "NULL", 0, 0, 0, "LAST_HIT", 0, 0, 0, "balanced"),
(14286, 14286, "Feline Queen", 0, "", 0, "Monster2.queen_of_cat", 8, 15, 80, "female", "L2Pet", 40, 4428, 2057, 13.43, 3.09, 40, 43, 30, 21, 20, 25, 0, 0, 602, 562, 1095, 526, 278, 0, 333, 0, 0, 0, 28, 198, "NULL", 0, 0, 0, "LAST_HIT", 0, 0, 0, "balanced"),
(14287, 14287, "Feline Queen", 0, "", 0, "Monster2.queen_of_cat", 8, 15, 80, "female", "L2Pet", 40, 4428, 2057, 13.43, 3.09, 40, 43, 30, 21, 20, 25, 0, 0, 602, 562, 1095, 526, 278, 0, 333, 0, 0, 0, 28, 198, "NULL", 0, 0, 0, "LAST_HIT", 0, 0, 0, "balanced"),
(14288, 14288, "Feline Queen", 0, "", 0, "Monster2.queen_of_cat", 8, 15, 80, "female", "L2Pet", 40, 4428, 2057, 13.43, 3.09, 40, 43, 30, 21, 20, 25, 0, 0, 602, 562, 1095, 526, 278, 0, 333, 0, 0, 0, 28, 198, "NULL", 0, 0, 0, "LAST_HIT", 0, 0, 0, "balanced"),
(14289, 14289, "Feline Queen", 0, "", 0, "Monster2.queen_of_cat", 8, 15, 80, "female", "L2Pet", 40, 4428, 2057, 13.43, 3.09, 40, 43, 30, 21, 20, 25, 0, 0, 602, 562, 1095, 526, 278, 0, 333, 0, 0, 0, 28, 198, "NULL", 0, 0, 0, "LAST_HIT", 0, 0, 0, "balanced"),
(14290, 14290, "Feline Queen", 0, "", 0, "Monster2.queen_of_cat", 8, 15, 80, "female", "L2Pet", 40, 4428, 2057, 13.43, 3.09, 40, 43, 30, 21, 20, 25, 0, 0, 602, 562, 1095, 526, 278, 0, 333, 0, 0, 0, 28, 198, "NULL", 0, 0, 0, "LAST_HIT", 0, 0, 0, "balanced"),
(14291, 14291, "Feline Queen", 0, "", 0, "Monster2.queen_of_cat", 8, 15, 80, "female", "L2Pet", 40, 4428, 2057, 13.43, 3.09, 40, 43, 30, 21, 20, 25, 0, 0, 602, 562, 1095, 526, 278, 0, 333, 0, 0, 0, 28, 198, "NULL", 0, 0, 0, "LAST_HIT", 0, 0, 0, "balanced"),
(14292, 14292, "Feline Queen", 0, "", 0, "Monster2.queen_of_cat", 8, 15, 80, "female", "L2Pet", 40, 4428, 2057, 13.43, 3.09, 40, 43, 30, 21, 20, 25, 0, 0, 602, 562, 1095, 526, 278, 0, 333, 0, 0, 0, 28, 198, "NULL", 0, 0, 0, "LAST_HIT", 0, 0, 0, "balanced"),
(14293, 14293, "Feline Queen", 0, "", 0, "Monster2.queen_of_cat", 8, 15, 80, "female", "L2Pet", 40, 4428, 2057, 13.43, 3.09, 40, 43, 30, 21, 20, 25, 0, 0, 602, 562, 1095, 526, 278, 0, 333, 0, 0, 0, 28, 198, "NULL", 0, 0, 0, "LAST_HIT", 0, 0, 0, "balanced"),
(14294, 14294, "Feline Queen", 0, "", 0, "Monster2.queen_of_cat", 8, 15, 80, "female", "L2Pet", 40, 4428, 2057, 13.43, 3.09, 40, 43, 30, 21, 20, 25, 0, 0, 602, 562, 1095, 526, 278, 0, 333, 0, 0, 0, 28, 198, "NULL", 0, 0, 0, "LAST_HIT", 0, 0, 0, "balanced"),
(14295, 14295, "Boxer the Unicorn ", 0, "", 0, "Monster.unicorn_boxer", 11, 18, 22, "male", "L2Pet", 40, 978, 279, 5.53, 1.53, 40, 43, 30, 21, 20, 25, 0, 0, 68, 102, 28, 96, 278, 0, 333, 0, 0, 0, 29, 154, "NULL", 0, 0, 0, "LAST_HIT", 0, 0, 0, "fighter"),
(14296, 14296, "Boxer the Unicorn", 0, "", 0, "Monster.unicorn_boxer", 11, 18, 32, "male", "L2Pet", 40, 1689, 458, 7.11, 1.84, 40, 43, 30, 21, 20, 25, 0, 0, 154, 151, 69, 142, 278, 0, 333, 0, 0, 0, 29, 154, "NULL", 0, 0, 0, "LAST_HIT", 0, 0, 0, "fighter"),
(14297, 14297, "Boxer the Unicorn ", 0, "", 0, "Monster.unicorn_boxer", 11, 18, 42, "male", "L2Pet", 40, 2656, 679, 8.69, 2.14, 40, 43, 30, 21, 20, 25, 0, 0, 311, 215, 152, 202, 278, 0, 333, 0, 0, 0, 29, 154, "NULL", 0, 0, 0, "LAST_HIT", 0, 0, 0, "fighter"),
(14298, 14298, "Boxer the Unicorn", 0, "", 0, "Monster.unicorn_boxer", 11, 18, 50, "male", "L2Pet", 40, 3592, 957, 8.69, 2.14, 40, 43, 30, 21, 20, 25, 0, 0, 509, 278, 264, 260, 278, 0, 333, 0, 0, 0, 29, 154, "NULL", 0, 0, 0, "LAST_HIT", 0, 0, 0, "fighter"),
(14299, 14299, "Boxer the Unicorn ", 0, "", 0, "Monster.unicorn_boxer", 11, 18, 58, "male", "L2Pet", 40, 4622, 1251, 10.27, 2.45, 40, 43, 30, 21, 20, 25, 0, 0, 781, 349, 428, 327, 278, 0, 333, 0, 0, 0, 29, 154, "NULL", 0, 0, 0, "LAST_HIT", 0, 0, 0, "fighter"),
(14300, 14300, "Boxer the Unicorn", 0, "", 0, "Monster.unicorn_boxer", 11, 18, 27, "male", "L2Pet", 40, 1302, 367, 5.53, 1.53, 40, 43, 30, 21, 20, 25, 0, 0, 104, 125, 45, 117, 278, 0, 333, 0, 0, 0, 29, 154, "NULL", 0, 0, 0, "LAST_HIT", 0, 0, 0, "fighter"),
(14301, 14301, "Boxer the Unicorn", 0, "", 0, "Monster.unicorn_boxer", 11, 18, 37, "male", "L2Pet", 40, 2142, 553, 7.11, 1.84, 40, 43, 30, 21, 20, 25, 0, 0, 222, 182, 104, 170, 278, 0, 333, 0, 0, 0, 29, 154, "NULL", 0, 0, 0, "LAST_HIT", 0, 0, 0, "fighter"),
(14302, 14302, "Boxer the Unicorn", 0, "", 0, "Monster.unicorn_boxer", 11, 18, 46, "male", "L2Pet", 40, 3108, 816, 8.69, 2.14, 40, 43, 30, 21, 20, 25, 0, 0, 401, 245, 202, 230, 278, 0, 333, 0, 0, 0, 29, 154, "NULL", 0, 0, 0, "LAST_HIT", 0, 0, 0, "fighter"),
(14303, 14303, "Boxer the Unicorn", 0, "", 0, "Monster.unicorn_boxer", 11, 18, 54, "male", "L2Pet", 40, 4099, 1102, 10.27, 2.45, 40, 43, 30, 21, 20, 25, 0, 0, 636, 313, 339, 293, 278, 0, 333, 0, 0, 0, 29, 154, "NULL", 0, 0, 0, "LAST_HIT", 0, 0, 0, "fighter"),
(14304, 14304, "Boxer the Unicorn", 0, "", 0, "Monster.unicorn_boxer", 11, 18, 60, "male", "L2Pet", 40, 4887, 1327, 10.27, 2.45, 40, 43, 30, 21, 20, 25, 0, 0, 860, 368, 478, 345, 278, 0, 333, 0, 0, 0, 29, 154, "NULL", 0, 0, 0, "LAST_HIT", 0, 0, 0, "fighter"),
(14305, 14305, "Boxer the Unicorn", 0, "", 0, "Monster.unicorn_boxer", 11, 18, 62, "male", "L2Pet", 40, 5151, 1404, 11.85, 2.78, 40, 43, 30, 21, 20, 25, 0, 0, 944, 388, 532, 363, 278, 0, 333, 0, 0, 0, 29, 154, "NULL", 0, 0, 0, "LAST_HIT", 0, 0, 0, "fighter"),
(14306, 14306, "Boxer the Unicorn", 0, "", 0, "Monster.unicorn_boxer", 11, 18, 64, "male", "L2Pet", 40, 5414, 1482, 11.85, 2.78, 40, 43, 30, 21, 20, 25, 0, 0, 1031, 408, 589, 382, 278, 0, 333, 0, 0, 0, 29, 154, "NULL", 0, 0, 0, "LAST_HIT", 0, 0, 0, "fighter"),
(14307, 14307, "Boxer the Unicorn", 0, "", 0, "Monster.unicorn_boxer", 11, 18, 66, "male", "L2Pet", 40, 5674, 1561, 11.85, 2.78, 40, 43, 30, 21, 20, 25, 0, 0, 1123, 428, 649, 401, 278, 0, 333, 0, 0, 0, 29, 154, "NULL", 0, 0, 0, "LAST_HIT", 0, 0, 0, "fighter"),
(14308, 14308, "Boxer the Unicorn", 0, "", 0, "Monster.unicorn_boxer", 11, 18, 68, "male", "L2Pet", 40, 5930, 1641, 11.85, 2.78, 40, 43, 30, 21, 20, 25, 0, 0, 1217, 449, 713, 421, 278, 0, 333, 0, 0, 0, 29, 154, "NULL", 0, 0, 0, "LAST_HIT", 0, 0, 0, "fighter"),
(14309, 14309, "Boxer the Unicorn", 0, "", 0, "Monster.unicorn_boxer", 11, 18, 70, "male", "L2Pet", 40, 6179, 1722, 11.85, 2.78, 40, 43, 30, 21, 20, 25, 0, 0, 1314, 470, 780, 440, 278, 0, 333, 0, 0, 0, 29, 154, "NULL", 0, 0, 0, "LAST_HIT", 0, 0, 0, "fighter"),
(14310, 14310, "Boxer the Unicorn", 0, "", 0, "Monster.unicorn_boxer", 11, 18, 72, "male", "L2Pet", 40, 6421, 1804, 13.43, 3.09, 40, 43, 30, 21, 20, 25, 0, 0, 1413, 491, 849, 460, 278, 0, 333, 0, 0, 0, 29, 154, "NULL", 0, 0, 0, "LAST_HIT", 0, 0, 0, "fighter"),
(14311, 14311, "Boxer the Unicorn", 0, "", 0, "Monster.unicorn_boxer", 11, 18, 74, "male", "L2Pet", 40, 6654, 1888, 13.43, 3.09, 40, 43, 30, 21, 20, 25, 0, 0, 1513, 512, 921, 480, 278, 0, 333, 0, 0, 0, 29, 154, "NULL", 0, 0, 0, "LAST_HIT", 0, 0, 0, "fighter"),
(14312, 14312, "Boxer the Unicorn", 0, "", 0, "Monster.unicorn_boxer", 11, 18, 76, "male", "L2Pet", 40, 6876, 1972, 13.43, 3.09, 40, 43, 30, 21, 20, 25, 0, 0, 1614, 534, 994, 500, 278, 0, 333, 0, 0, 0, 29, 154, "NULL", 0, 0, 0, "LAST_HIT", 0, 0, 0, "fighter"),
(14313, 14313, "Boxer the Unicorn", 0, "", 0, "Monster.unicorn_boxer", 11, 18, 78, "male", "L2Pet", 40, 7085, 2057, 13.43, 3.09, 40, 43, 30, 21, 20, 25, 0, 0, 1715, 555, 1069, 520, 278, 0, 333, 0, 0, 0, 27, 140, "NULL", 0, 0, 0, "LAST_HIT", 0, 0, 0, "fighter"),
(14314, 14314, "Boxer the Unicorn", 0, "", 0, "Monster.unicorn_boxer", 11, 18, 78, "male", "L2Pet", 40, 7085, 2057, 13.43, 3.09, 40, 43, 30, 21, 20, 25, 0, 0, 1723, 555, 1081, 520, 278, 0, 333, 0, 0, 0, 29, 154, "NULL", 0, 0, 0, "LAST_HIT", 0, 0, 0, "fighter"),
(14315, 14315, "Boxer the Unicorn", 0, "", 0, "Monster.unicorn_boxer", 11, 18, 78, "male", "L2Pet", 40, 7085, 2057, 13.43, 3.09, 40, 43, 30, 21, 20, 25, 0, 0, 1732, 555, 1093, 520, 278, 0, 333, 0, 0, 0, 29, 154, "NULL", 0, 0, 0, "LAST_HIT", 0, 0, 0, "fighter"),
(14316, 14316, "Boxer the Unicorn", 0, "", 0, "Monster.unicorn_boxer", 11, 18, 78, "male", "L2Pet", 40, 7085, 2057, 13.43, 3.09, 40, 43, 30, 21, 20, 25, 0, 0, 1740, 555, 1105, 520, 278, 0, 333, 0, 0, 0, 29, 154, "NULL", 0, 0, 0, "LAST_HIT", 0, 0, 0, "fighter"),
(14317, 14317, "Boxer the Unicorn", 0, "", 0, "Monster.unicorn_boxer", 11, 18, 78, "male", "L2Pet", 40, 7085, 2057, 13.43, 3.09, 40, 43, 30, 21, 20, 25, 0, 0, 1749, 555, 1117, 520, 278, 0, 333, 0, 0, 0, 29, 154, "NULL", 0, 0, 0, "LAST_HIT", 0, 0, 0, "fighter"),
(14318, 14318, "Boxer the Unicorn", 0, "", 0, "Monster.unicorn_boxer", 11, 18, 78, "male", "L2Pet", 40, 7085, 2057, 13.43, 3.09, 40, 43, 30, 21, 20, 25, 0, 0, 1757, 555, 1129, 520, 278, 0, 333, 0, 0, 0, 29, 154, "NULL", 0, 0, 0, "LAST_HIT", 0, 0, 0, "fighter"),
(14319, 14319, "Boxer the Unicorn", 0, "", 0, "Monster.unicorn_boxer", 11, 18, 78, "male", "L2Pet", 40, 7085, 2057, 13.43, 3.09, 40, 43, 30, 21, 20, 25, 0, 0, 1766, 555, 1141, 520, 278, 0, 333, 0, 0, 0, 29, 154, "NULL", 0, 0, 0, "LAST_HIT", 0, 0, 0, "fighter"),
(14320, 14320, "Boxer the Unicorn", 0, "", 0, "Monster.unicorn_boxer", 11, 18, 78, "male", "L2Pet", 40, 7085, 2057, 13.43, 3.09, 40, 43, 30, 21, 20, 25, 0, 0, 1775, 555, 1153, 520, 278, 0, 333, 0, 0, 0, 29, 154, "NULL", 0, 0, 0, "LAST_HIT", 0, 0, 0, "fighter"),
(14321, 14321, "Boxer the Unicorn", 0, "", 0, "Monster.unicorn_boxer", 11, 18, 78, "male", "L2Pet", 40, 7085, 2057, 13.43, 3.09, 40, 43, 30, 21, 20, 25, 0, 0, 1783, 555, 1165, 520, 278, 0, 333, 0, 0, 0, 29, 154, "NULL", 0, 0, 0, "LAST_HIT", 0, 0, 0, "balanced"),
(14322, 14322, "Boxer the Unicorn", 0, "", 0, "Monster.unicorn_boxer", 11, 18, 79, "male", "L2Pet", 40, 7085, 2057, 13.43, 3.09, 40, 43, 30, 21, 20, 25, 0, 0, 1802, 558, 1192, 523, 278, 0, 333, 0, 0, 0, 29, 154, "NULL", 0, 0, 0, "LAST_HIT", 0, 0, 0, "balanced"),
(14323, 14323, "Boxer the Unicorn", 0, "", 0, "Monster.unicorn_boxer", 11, 18, 79, "male", "L2Pet", 40, 7085, 2057, 13.43, 3.09, 40, 43, 30, 21, 20, 25, 0, 0, 1811, 558, 1204, 523, 278, 0, 333, 0, 0, 0, 29, 154, "NULL", 0, 0, 0, "LAST_HIT", 0, 0, 0, "balanced"),
(14324, 14324, "Boxer the Unicorn", 0, "", 0, "Monster.unicorn_boxer", 11, 18, 79, "male", "L2Pet", 40, 7085, 2057, 13.43, 3.09, 40, 43, 30, 21, 20, 25, 0, 0, 1820, 558, 1216, 523, 278, 0, 333, 0, 0, 0, 29, 154, "NULL", 0, 0, 0, "LAST_HIT", 0, 0, 0, "balanced"),
(14325, 14325, "Boxer the Unicorn", 0, "", 0, "Monster.unicorn_boxer", 11, 18, 79, "male", "L2Pet", 40, 7085, 2057, 13.43, 3.09, 40, 43, 30, 21, 20, 25, 0, 0, 1828, 558, 1228, 523, 278, 0, 333, 0, 0, 0, 29, 154, "NULL", 0, 0, 0, "LAST_HIT", 0, 0, 0, "balanced"),
(14326, 14326, "Boxer the Unicorn", 0, "", 0, "Monster.unicorn_boxer", 11, 18, 79, "male", "L2Pet", 40, 7085, 2057, 13.43, 3.09, 40, 43, 30, 21, 20, 25, 0, 0, 1837, 558, 1240, 523, 278, 0, 333, 0, 0, 0, 29, 154, "NULL", 0, 0, 0, "LAST_HIT", 0, 0, 0, "balanced"),
(14327, 14327, "Boxer the Unicorn", 0, "", 0, "Monster.unicorn_boxer", 11, 18, 79, "male", "L2Pet", 40, 7085, 2057, 13.43, 3.09, 40, 43, 30, 21, 20, 25, 0, 0, 1846, 558, 1253, 523, 278, 0, 333, 0, 0, 0, 29, 154, "NULL", 0, 0, 0, "LAST_HIT", 0, 0, 0, "balanced"),
(14328, 14328, "Boxer the Unicorn", 0, "", 0, "Monster.unicorn_boxer", 11, 18, 79, "male", "L2Pet", 40, 7085, 2057, 13.43, 3.09, 40, 43, 30, 21, 20, 25, 0, 0, 1854, 558, 1265, 523, 278, 0, 333, 0, 0, 0, 29, 154, "NULL", 0, 0, 0, "LAST_HIT", 0, 0, 0, "balanced"),
(14329, 14329, "Boxer the Unicorn", 0, "", 0, "Monster.unicorn_boxer", 11, 18, 79, "male", "L2Pet", 40, 7085, 2057, 13.43, 3.09, 40, 43, 30, 21, 20, 25, 0, 0, 1863, 558, 1277, 523, 278, 0, 333, 0, 0, 0, 29, 154, "NULL", 0, 0, 0, "LAST_HIT", 0, 0, 0, "balanced"),
(14330, 14330, "Boxer the Unicorn", 0, "", 0, "Monster.unicorn_boxer", 11, 18, 79, "male", "L2Pet", 40, 7085, 2057, 13.43, 3.09, 40, 43, 30, 21, 20, 25, 0, 0, 1871, 558, 1289, 523, 278, 0, 333, 0, 0, 0, 29, 154, "NULL", 0, 0, 0, "LAST_HIT", 0, 0, 0, "balanced"),
(14331, 14331, "Boxer the Unicorn", 0, "", 0, "Monster.unicorn_boxer", 11, 18, 80, "male", "L2Pet", 40, 7085, 2057, 13.43, 3.09, 40, 43, 30, 21, 20, 25, 0, 0, 1891, 562, 1317, 526, 278, 0, 333, 0, 0, 0, 29, 154, "NULL", 0, 0, 0, "LAST_HIT", 0, 0, 0, "balanced"),
(14332, 14332, "Boxer the Unicorn", 0, "", 0, "Monster.unicorn_boxer", 11, 18, 80, "male", "L2Pet", 40, 7085, 2057, 13.43, 3.09, 40, 43, 30, 21, 20, 25, 0, 0, 1900, 562, 1329, 526, 278, 0, 333, 0, 0, 0, 29, 154, "NULL", 0, 0, 0, "LAST_HIT", 0, 0, 0, "balanced"),
(14333, 14333, "Boxer the Unicorn", 0, "", 0, "Monster.unicorn_boxer", 11, 18, 80, "male", "L2Pet", 40, 7085, 2057, 13.43, 3.09, 40, 43, 30, 21, 20, 25, 0, 0, 1909, 562, 1342, 526, 278, 0, 333, 0, 0, 0, 29, 154, "NULL", 0, 0, 0, "LAST_HIT", 0, 0, 0, "balanced"),
(14334, 14334, "Boxer the Unicorn", 0, "", 0, "Monster.unicorn_boxer", 11, 18, 80, "male", "L2Pet", 40, 7085, 2057, 13.43, 3.09, 40, 43, 30, 21, 20, 25, 0, 0, 1917, 562, 1354, 526, 278, 0, 333, 0, 0, 0, 29, 154, "NULL", 0, 0, 0, "LAST_HIT", 0, 0, 0, "balanced"),
(14335, 14335, "Boxer the Unicorn", 0, "", 0, "Monster.unicorn_boxer", 11, 18, 80, "male", "L2Pet", 40, 7085, 2057, 13.43, 3.09, 40, 43, 30, 21, 20, 25, 0, 0, 1926, 562, 1366, 526, 278, 0, 333, 0, 0, 0, 29, 154, "NULL", 0, 0, 0, "LAST_HIT", 0, 0, 0, "balanced"),
(14336, 14336, "Boxer the Unicorn", 0, "", 0, "Monster.unicorn_boxer", 11, 18, 80, "male", "L2Pet", 40, 7085, 2057, 13.43, 3.09, 40, 43, 30, 21, 20, 25, 0, 0, 1935, 562, 1379, 526, 278, 0, 333, 0, 0, 0, 29, 154, "NULL", 0, 0, 0, "LAST_HIT", 0, 0, 0, "balanced"),
(14337, 14337, "Boxer the Unicorn", 0, "", 0, "Monster.unicorn_boxer", 11, 18, 80, "male", "L2Pet", 40, 7085, 2057, 13.43, 3.09, 40, 43, 30, 21, 20, 25, 0, 0, 1943, 562, 1391, 526, 278, 0, 333, 0, 0, 0, 29, 154, "NULL", 0, 0, 0, "LAST_HIT", 0, 0, 0, "balanced"),
(14338, 14338, "Boxer the Unicorn", 0, "", 0, "Monster.unicorn_boxer", 11, 18, 80, "male", "L2Pet", 40, 7085, 2057, 13.43, 3.09, 40, 43, 30, 21, 20, 25, 0, 0, 1952, 562, 1403, 526, 278, 0, 333, 0, 0, 0, 29, 154, "NULL", 0, 0, 0, "LAST_HIT", 0, 0, 0, "balanced"),
(14339, 14339, "Boxer the Unicorn", 0, "", 0, "Monster.unicorn_boxer", 11, 18, 80, "male", "L2Pet", 40, 7085, 2057, 13.43, 3.09, 40, 43, 30, 21, 20, 25, 0, 0, 1961, 562, 1416, 526, 278, 0, 333, 0, 0, 0, 29, 154, "NULL", 0, 0, 0, "LAST_HIT", 0, 0, 0, "balanced"),
(14340, 14340, "Boxer the Unicorn", 0, "", 0, "Monster.unicorn_boxer", 11, 18, 80, "male", "L2Pet", 40, 7085, 2057, 13.43, 3.09, 40, 43, 30, 21, 20, 25, 0, 0, 1969, 562, 1428, 526, 278, 0, 333, 0, 0, 0, 29, 154, "NULL", 0, 0, 0, "LAST_HIT", 0, 0, 0, "balanced"),
(14341, 14341, "Boxer the Unicorn", 0, "", 0, "Monster.unicorn_boxer", 11, 18, 80, "male", "L2Pet", 40, 7085, 2057, 13.43, 3.09, 40, 43, 30, 21, 20, 25, 0, 0, 1978, 562, 1440, 526, 278, 0, 333, 0, 0, 0, 29, 154, "NULL", 0, 0, 0, "LAST_HIT", 0, 0, 0, "balanced"),
(14342, 14342, "Boxer the Unicorn", 0, "", 0, "Monster.unicorn_boxer", 11, 18, 80, "male", "L2Pet", 40, 7085, 2057, 13.43, 3.09, 40, 43, 30, 21, 20, 25, 0, 0, 1987, 562, 1453, 526, 278, 0, 333, 0, 0, 0, 29, 154, "NULL", 0, 0, 0, "LAST_HIT", 0, 0, 0, "balanced"),
(14343, 14343, "Mirage the Unicorn", 0, "", 0, "Monster.unicorn_mirage", 13, 17, 27, "male", "L2Pet", 40, 1302, 367, 5.53, 1.53, 40, 43, 30, 21, 20, 25, 0, 0, 104, 125, 45, 117, 278, 0, 333, 0, 0, 0, 29, 154, "NULL", 0, 0, 0, "LAST_HIT", 0, 0, 0, "fighter"),
(14344, 14344, "Mirage the Unicorn ", 0, "", 0, "Monster.unicorn_mirage", 13, 17, 37, "male", "L2Pet", 40, 2142, 553, 7.11, 1.84, 40, 43, 30, 21, 20, 25, 0, 0, 222, 182, 104, 170, 278, 0, 333, 0, 0, 0, 29, 154, "NULL", 0, 0, 0, "LAST_HIT", 0, 0, 0, "fighter"),
(14345, 14345, "Mirage the Unicorn", 0, "", 0, "Monster.unicorn_mirage", 13, 17, 47, "male", "L2Pet", 40, 3227, 851, 8.69, 2.14, 40, 43, 30, 21, 20, 25, 0, 0, 427, 253, 216, 237, 278, 0, 333, 0, 0, 0, 29, 154, "NULL", 0, 0, 0, "LAST_HIT", 0, 0, 0, "fighter"),
(14346, 14346, "Mirage the Unicorn ", 0, "", 0, "Monster.unicorn_mirage", 13, 17, 54, "male", "L2Pet", 40, 4099, 1102, 10.27, 2.45, 40, 43, 30, 21, 20, 25, 0, 0, 636, 313, 339, 293, 278, 0, 333, 0, 0, 0, 29, 154, "NULL", 0, 0, 0, "LAST_HIT", 0, 0, 0, "fighter"),
(14347, 14347, "Mirage the Unicorn", 0, "", 0, "Monster.unicorn_mirage", 13, 17, 22, "male", "L2Pet", 40, 978, 279, 5.53, 1.53, 40, 43, 30, 21, 20, 25, 0, 0, 68, 102, 28, 96, 278, 0, 333, 0, 0, 0, 27, 140, "NULL", 0, 0, 0, "LAST_HIT", 0, 0, 0, "fighter"),
(14348, 14348, "Mirage the Unicorn ", 0, "", 0, "Monster.unicorn_mirage", 13, 17, 32, "male", "L2Pet", 40, 1689, 458, 7.11, 1.84, 40, 43, 30, 21, 20, 25, 0, 0, 154, 151, 69, 142, 278, 0, 333, 0, 0, 0, 29, 154, "NULL", 0, 0, 0, "LAST_HIT", 0, 0, 0, "fighter"),
(14349, 14349, "Mirage the Unicorn", 0, "", 0, "Monster.unicorn_mirage", 13, 17, 42, "male", "L2Pet", 40, 2656, 679, 8.69, 2.14, 40, 43, 30, 21, 20, 25, 0, 0, 311, 215, 152, 202, 278, 0, 333, 0, 0, 0, 29, 154, "NULL", 0, 0, 0, "LAST_HIT", 0, 0, 0, "fighter"),
(14350, 14350, "Mirage the Unicorn", 0, "", 0, "Monster.unicorn_mirage", 13, 17, 50, "male", "L2Pet", 40, 3592, 957, 8.69, 2.14, 40, 43, 30, 21, 20, 25, 0, 0, 509, 278, 264, 260, 278, 0, 333, 0, 0, 0, 29, 154, "NULL", 0, 0, 0, "LAST_HIT", 0, 0, 0, "fighter"),
(14351, 14351, "Mirage the Unicorn", 0, "", 0, "Monster.unicorn_mirage", 13, 17, 58, "male", "L2Pet", 40, 4622, 1251, 10.27, 2.45, 40, 43, 30, 21, 20, 25, 0, 0, 781, 349, 428, 327, 278, 0, 333, 0, 0, 0, 29, 154, "NULL", 0, 0, 0, "LAST_HIT", 0, 0, 0, "fighter"),
(14352, 14352, "Mirage the Unicorn", 0, "", 0, "Monster.unicorn_mirage", 13, 17, 60, "male", "L2Pet", 40, 4887, 1327, 10.27, 2.45, 40, 43, 30, 21, 20, 25, 0, 0, 860, 368, 478, 345, 278, 0, 333, 0, 0, 0, 29, 154, "NULL", 0, 0, 0, "LAST_HIT", 0, 0, 0, "fighter"),
(14353, 14353, "Mirage the Unicorn", 0, "", 0, "Monster.unicorn_mirage", 13, 17, 62, "male", "L2Pet", 40, 5151, 1404, 11.85, 2.78, 40, 43, 30, 21, 20, 25, 0, 0, 944, 388, 532, 363, 278, 0, 333, 0, 0, 0, 29, 154, "NULL", 0, 0, 0, "LAST_HIT", 0, 0, 0, "fighter"),
(14354, 14354, "Mirage the Unicorn", 0, "", 0, "Monster.unicorn_mirage", 13, 17, 64, "male", "L2Pet", 40, 5414, 1482, 11.85, 2.78, 40, 43, 30, 21, 20, 25, 0, 0, 1031, 408, 589, 382, 278, 0, 333, 0, 0, 0, 29, 154, "NULL", 0, 0, 0, "LAST_HIT", 0, 0, 0, "fighter"),
(14355, 14355, "Mirage the Unicorn", 0, "", 0, "Monster.unicorn_mirage", 13, 17, 66, "male", "L2Pet", 40, 5674, 1561, 11.85, 2.78, 40, 43, 30, 21, 20, 25, 0, 0, 1123, 428, 649, 401, 278, 0, 333, 0, 0, 0, 29, 154, "NULL", 0, 0, 0, "LAST_HIT", 0, 0, 0, "fighter"),
(14356, 14356, "Mirage the Unicorn", 0, "", 0, "Monster.unicorn_mirage", 13, 17, 68, "male", "L2Pet", 40, 5930, 1641, 11.85, 2.78, 40, 43, 30, 21, 20, 25, 0, 0, 1217, 449, 713, 421, 278, 0, 333, 0, 0, 0, 27, 140, "NULL", 0, 0, 0, "LAST_HIT", 0, 0, 0, "fighter"),
(14357, 14357, "Mirage the Unicorn", 0, "", 0, "Monster.unicorn_mirage", 13, 17, 70, "male", "L2Pet", 40, 6179, 1722, 11.85, 2.78, 40, 43, 30, 21, 20, 25, 0, 0, 1314, 470, 780, 440, 278, 0, 333, 0, 0, 0, 29, 154, "NULL", 0, 0, 0, "LAST_HIT", 0, 0, 0, "fighter"),
(14358, 14358, "Mirage the Unicorn", 0, "", 0, "Monster.unicorn_mirage", 13, 17, 72, "male", "L2Pet", 40, 6421, 1804, 13.43, 3.09, 40, 43, 30, 21, 20, 25, 0, 0, 1413, 491, 849, 460, 278, 0, 333, 0, 0, 0, 29, 154, "NULL", 0, 0, 0, "LAST_HIT", 0, 0, 0, "fighter"),
(14359, 14359, "Mirage the Unicorn", 0, "", 0, "Monster.unicorn_mirage", 13, 17, 74, "male", "L2Pet", 40, 6654, 1888, 13.43, 3.09, 40, 43, 30, 21, 20, 25, 0, 0, 1513, 512, 921, 480, 278, 0, 333, 0, 0, 0, 27, 140, "NULL", 0, 0, 0, "LAST_HIT", 0, 0, 0, "fighter"),
(14360, 14360, "Mirage the Unicorn", 0, "", 0, "Monster.unicorn_mirage", 13, 17, 76, "male", "L2Pet", 40, 6876, 1972, 13.43, 3.09, 40, 43, 30, 21, 20, 25, 0, 0, 1614, 534, 994, 500, 278, 0, 333, 0, 0, 0, 29, 154, "NULL", 0, 0, 0, "LAST_HIT", 0, 0, 0, "fighter"),
(14361, 14361, "Mirage the Unicorn ", 0, "", 0, "Monster.unicorn_mirage", 13, 17, 78, "male", "L2Pet", 40, 7085, 2057, 13.43, 3.09, 40, 43, 30, 21, 20, 25, 0, 0, 1715, 555, 1069, 520, 278, 0, 333, 0, 0, 0, 29, 154, "NULL", 0, 0, 0, "LAST_HIT", 0, 0, 0, "fighter"),
(14362, 14362, "Mirage the Unicorn ", 0, "", 0, "Monster.unicorn_mirage", 13, 17, 78, "male", "L2Pet", 40, 7085, 2057, 13.43, 3.09, 40, 43, 30, 21, 20, 25, 0, 0, 1723, 555, 1081, 520, 278, 0, 333, 0, 0, 0, 29, 154, "NULL", 0, 0, 0, "LAST_HIT", 0, 0, 0, "fighter"),
(14363, 14363, "Mirage the Unicorn ", 0, "", 0, "Monster.unicorn_mirage", 13, 17, 78, "male", "L2Pet", 40, 7085, 2057, 13.43, 3.09, 40, 43, 30, 21, 20, 25, 0, 0, 1732, 555, 1093, 520, 278, 0, 333, 0, 0, 0, 29, 154, "NULL", 0, 0, 0, "LAST_HIT", 0, 0, 0, "fighter"),
(14364, 14364, "Mirage the Unicorn ", 0, "", 0, "Monster.unicorn_mirage", 13, 17, 78, "male", "L2Pet", 40, 7085, 2057, 13.43, 3.09, 40, 43, 30, 21, 20, 25, 0, 0, 1740, 555, 1105, 520, 278, 0, 333, 0, 0, 0, 29, 154, "NULL", 0, 0, 0, "LAST_HIT", 0, 0, 0, "fighter"),
(14365, 14365, "Mirage the Unicorn ", 0, "", 0, "Monster.unicorn_mirage", 13, 17, 78, "male", "L2Pet", 40, 7085, 2057, 13.43, 3.09, 40, 43, 30, 21, 20, 25, 0, 0, 1749, 555, 1117, 520, 278, 0, 333, 0, 0, 0, 29, 154, "NULL", 0, 0, 0, "LAST_HIT", 0, 0, 0, "fighter"),
(14366, 14366, "Mirage the Unicorn ", 0, "", 0, "Monster.unicorn_mirage", 13, 17, 78, "male", "L2Pet", 40, 7085, 2057, 13.43, 3.09, 40, 43, 30, 21, 20, 25, 0, 0, 1757, 555, 1129, 520, 278, 0, 333, 0, 0, 0, 29, 154, "NULL", 0, 0, 0, "LAST_HIT", 0, 0, 0, "fighter"),
(14367, 14367, "Mirage the Unicorn ", 0, "", 0, "Monster.unicorn_mirage", 13, 17, 78, "male", "L2Pet", 40, 7085, 2057, 13.43, 3.09, 40, 43, 30, 21, 20, 25, 0, 0, 1766, 555, 1141, 520, 278, 0, 333, 0, 0, 0, 29, 154, "NULL", 0, 0, 0, "LAST_HIT", 0, 0, 0, "fighter"),
(14368, 14368, "Mirage the Unicorn ", 0, "", 0, "Monster.unicorn_mirage", 13, 17, 78, "male", "L2Pet", 40, 7085, 2057, 13.43, 3.09, 40, 43, 30, 21, 20, 25, 0, 0, 1775, 555, 1153, 520, 278, 0, 333, 0, 0, 0, 29, 154, "NULL", 0, 0, 0, "LAST_HIT", 0, 0, 0, "fighter"),
(14369, 14369, "Mirage the Unicorn ", 0, "", 0, "Monster.unicorn_mirage", 13, 17, 78, "male", "L2Pet", 40, 7085, 2057, 13.43, 3.09, 40, 43, 30, 21, 20, 25, 0, 0, 1783, 555, 1165, 520, 278, 0, 333, 0, 0, 0, 29, 154, "NULL", 0, 0, 0, "LAST_HIT", 0, 0, 0, "balanced"),
(14370, 14370, "Mirage the Unicorn ", 0, "", 0, "Monster.unicorn_mirage", 13, 17, 79, "male", "L2Pet", 40, 7085, 2057, 13.43, 3.09, 40, 43, 30, 21, 20, 25, 0, 0, 1802, 558, 1192, 523, 278, 0, 333, 0, 0, 0, 29, 154, "NULL", 0, 0, 0, "LAST_HIT", 0, 0, 0, "balanced"),
(14371, 14371, "Mirage the Unicorn ", 0, "", 0, "Monster.unicorn_mirage", 13, 17, 79, "male", "L2Pet", 40, 7085, 2057, 13.43, 3.09, 40, 43, 30, 21, 20, 25, 0, 0, 1811, 558, 1204, 523, 278, 0, 333, 0, 0, 0, 29, 154, "NULL", 0, 0, 0, "LAST_HIT", 0, 0, 0, "balanced"),
(14372, 14372, "Mirage the Unicorn ", 0, "", 0, "Monster.unicorn_mirage", 13, 17, 79, "male", "L2Pet", 40, 7085, 2057, 13.43, 3.09, 40, 43, 30, 21, 20, 25, 0, 0, 1820, 558, 1216, 523, 278, 0, 333, 0, 0, 0, 29, 154, "NULL", 0, 0, 0, "LAST_HIT", 0, 0, 0, "balanced"),
(14373, 14373, "Mirage the Unicorn ", 0, "", 0, "Monster.unicorn_mirage", 13, 17, 79, "male", "L2Pet", 40, 7085, 2057, 13.43, 3.09, 40, 43, 30, 21, 20, 25, 0, 0, 1828, 558, 1228, 523, 278, 0, 333, 0, 0, 0, 29, 154, "NULL", 0, 0, 0, "LAST_HIT", 0, 0, 0, "balanced"),
(14374, 14374, "Mirage the Unicorn ", 0, "", 0, "Monster.unicorn_mirage", 13, 17, 79, "male", "L2Pet", 40, 7085, 2057, 13.43, 3.09, 40, 43, 30, 21, 20, 25, 0, 0, 1837, 558, 1240, 523, 278, 0, 333, 0, 0, 0, 29, 154, "NULL", 0, 0, 0, "LAST_HIT", 0, 0, 0, "balanced"),
(14375, 14375, "Mirage the Unicorn ", 0, "", 0, "Monster.unicorn_mirage", 13, 17, 79, "male", "L2Pet", 40, 7085, 2057, 13.43, 3.09, 40, 43, 30, 21, 20, 25, 0, 0, 1846, 558, 1253, 523, 278, 0, 333, 0, 0, 0, 29, 154, "NULL", 0, 0, 0, "LAST_HIT", 0, 0, 0, "balanced"),
(14376, 14376, "Mirage the Unicorn ", 0, "", 0, "Monster.unicorn_mirage", 13, 17, 79, "male", "L2Pet", 40, 7085, 2057, 13.43, 3.09, 40, 43, 30, 21, 20, 25, 0, 0, 1854, 558, 1265, 523, 278, 0, 333, 0, 0, 0, 29, 154, "NULL", 0, 0, 0, "LAST_HIT", 0, 0, 0, "balanced"),
(14377, 14377, "Mirage the Unicorn ", 0, "", 0, "Monster.unicorn_mirage", 13, 17, 79, "male", "L2Pet", 40, 7085, 2057, 13.43, 3.09, 40, 43, 30, 21, 20, 25, 0, 0, 1863, 558, 1277, 523, 278, 0, 333, 0, 0, 0, 29, 154, "NULL", 0, 0, 0, "LAST_HIT", 0, 0, 0, "balanced"),
(14378, 14378, "Mirage the Unicorn ", 0, "", 0, "Monster.unicorn_mirage", 13, 17, 79, "male", "L2Pet", 40, 7085, 2057, 13.43, 3.09, 40, 43, 30, 21, 20, 25, 0, 0, 1871, 558, 1289, 523, 278, 0, 333, 0, 0, 0, 29, 154, "NULL", 0, 0, 0, "LAST_HIT", 0, 0, 0, "balanced"),
(14379, 14379, "Mirage the Unicorn ", 0, "", 0, "Monster.unicorn_mirage", 13, 17, 80, "male", "L2Pet", 40, 7085, 2057, 13.43, 3.09, 40, 43, 30, 21, 20, 25, 0, 0, 1891, 562, 1317, 526, 278, 0, 333, 0, 0, 0, 29, 154, "NULL", 0, 0, 0, "LAST_HIT", 0, 0, 0, "balanced"),
(14380, 14380, "Mirage the Unicorn ", 0, "", 0, "Monster.unicorn_mirage", 13, 17, 80, "male", "L2Pet", 40, 7085, 2057, 13.43, 3.09, 40, 43, 30, 21, 20, 25, 0, 0, 1900, 562, 1329, 526, 278, 0, 333, 0, 0, 0, 29, 154, "NULL", 0, 0, 0, "LAST_HIT", 0, 0, 0, "balanced"),
(14381, 14381, "Mirage the Unicorn ", 0, "", 0, "Monster.unicorn_mirage", 13, 17, 80, "male", "L2Pet", 40, 7085, 2057, 13.43, 3.09, 40, 43, 30, 21, 20, 25, 0, 0, 1909, 562, 1342, 526, 278, 0, 333, 0, 0, 0, 29, 154, "NULL", 0, 0, 0, "LAST_HIT", 0, 0, 0, "balanced"),
(14382, 14382, "Mirage the Unicorn ", 0, "", 0, "Monster.unicorn_mirage", 13, 17, 80, "male", "L2Pet", 40, 7085, 2057, 13.43, 3.09, 40, 43, 30, 21, 20, 25, 0, 0, 1917, 562, 1354, 526, 278, 0, 333, 0, 0, 0, 29, 154, "NULL", 0, 0, 0, "LAST_HIT", 0, 0, 0, "balanced"),
(14383, 14383, "Mirage the Unicorn ", 0, "", 0, "Monster.unicorn_mirage", 13, 17, 80, "male", "L2Pet", 40, 7085, 2057, 13.43, 3.09, 40, 43, 30, 21, 20, 25, 0, 0, 1926, 562, 1366, 526, 278, 0, 333, 0, 0, 0, 29, 154, "NULL", 0, 0, 0, "LAST_HIT", 0, 0, 0, "balanced"),
(14384, 14384, "Mirage the Unicorn ", 0, "", 0, "Monster.unicorn_mirage", 13, 17, 80, "male", "L2Pet", 40, 7085, 2057, 13.43, 3.09, 40, 43, 30, 21, 20, 25, 0, 0, 1935, 562, 1379, 526, 278, 0, 333, 0, 0, 0, 29, 154, "NULL", 0, 0, 0, "LAST_HIT", 0, 0, 0, "balanced"),
(14385, 14385, "Mirage the Unicorn ", 0, "", 0, "Monster.unicorn_mirage", 13, 17, 80, "male", "L2Pet", 40, 7085, 2057, 13.43, 3.09, 40, 43, 30, 21, 20, 25, 0, 0, 1943, 562, 1391, 526, 278, 0, 333, 0, 0, 0, 29, 154, "NULL", 0, 0, 0, "LAST_HIT", 0, 0, 0, "balanced"),
(14386, 14386, "Mirage the Unicorn ", 0, "", 0, "Monster.unicorn_mirage", 13, 17, 80, "male", "L2Pet", 40, 7085, 2057, 13.43, 3.09, 40, 43, 30, 21, 20, 25, 0, 0, 1952, 562, 1403, 526, 278, 0, 333, 0, 0, 0, 29, 154, "NULL", 0, 0, 0, "LAST_HIT", 0, 0, 0, "balanced"),
(14387, 14387, "Mirage the Unicorn ", 0, "", 0, "Monster.unicorn_mirage", 13, 17, 80, "male", "L2Pet", 40, 7085, 2057, 13.43, 3.09, 40, 43, 30, 21, 20, 25, 0, 0, 1961, 562, 1416, 526, 278, 0, 333, 0, 0, 0, 29, 154, "NULL", 0, 0, 0, "LAST_HIT", 0, 0, 0, "balanced"),
(14388, 14388, "Mirage the Unicorn ", 0, "", 0, "Monster.unicorn_mirage", 13, 17, 80, "male", "L2Pet", 40, 7085, 2057, 13.43, 3.09, 40, 43, 30, 21, 20, 25, 0, 0, 1969, 562, 1428, 526, 278, 0, 333, 0, 0, 0, 29, 154, "NULL", 0, 0, 0, "LAST_HIT", 0, 0, 0, "balanced"),
(14389, 14389, "Mirage the Unicorn ", 0, "", 0, "Monster.unicorn_mirage", 13, 17, 80, "male", "L2Pet", 40, 7085, 2057, 13.43, 3.09, 40, 43, 30, 21, 20, 25, 0, 0, 1978, 562, 1440, 526, 278, 0, 333, 0, 0, 0, 29, 154, "NULL", 0, 0, 0, "LAST_HIT", 0, 0, 0, "balanced"),
(14390, 14390, "Mirage the Unicorn ", 0, "", 0, "Monster.unicorn_mirage", 13, 17, 80, "male", "L2Pet", 40, 7085, 2057, 13.43, 3.09, 40, 43, 30, 21, 20, 25, 0, 0, 1987, 562, 1453, 526, 278, 0, 333, 0, 0, 0, 29, 154, "NULL", 0, 0, 0, "LAST_HIT", 0, 0, 0, "balanced"),
(14391, 14391, "Merrow the Unicorn", 0, "", 0, "Monster.blue_eye", 11, 16, 42, "male", "L2Pet", 40, 1992, 679, 8.69, 2.14, 40, 43, 30, 21, 20, 25, 0, 0, 342, 215, 152, 202, 278, 0, 333, 0, 0, 0, 52, 209, "NULL", 0, 0, 0, "LAST_HIT", 0, 0, 0, "fighter"),
(14392, 14392, "Merrow the Unicorn", 0, "", 0, "Monster.blue_eye", 11, 16, 46, "male", "L2Pet", 40, 2331, 816, 8.69, 2.14, 40, 43, 30, 21, 20, 25, 0, 0, 442, 245, 202, 230, 399, 0, 467, 0, 0, 0, 48, 180, "NULL", 0, 0, 0, "LAST_HIT", 0, 0, 0, "fighter"),
(14393, 14393, "Merrow the Unicorn", 0, "", 0, "Monster.blue_eye", 11, 16, 50, "male", "L2Pet", 40, 2694, 957, 8.69, 2.14, 40, 43, 30, 21, 20, 25, 0, 0, 560, 278, 264, 260, 278, 0, 333, 0, 0, 0, 52, 209, "NULL", 0, 0, 0, "LAST_HIT", 0, 0, 0, "fighter"),
(14394, 14394, "Merrow the Unicorn", 0, "", 0, "Monster.blue_eye", 11, 16, 54, "male", "L2Pet", 40, 3074, 1102, 10.27, 2.45, 40, 43, 30, 21, 20, 25, 0, 0, 699, 313, 339, 293, 278, 0, 333, 0, 0, 0, 52, 209, "NULL", 0, 0, 0, "LAST_HIT", 0, 0, 0, "fighter"),
(14395, 14395, "Merrow the Unicorn", 0, "", 0, "Monster.blue_eye", 11, 16, 58, "male", "L2Pet", 40, 3467, 1251, 10.27, 2.45, 40, 43, 30, 21, 20, 25, 0, 0, 859, 349, 428, 327, 370, 0, 333, 0, 0, 0, 48, 180, "NULL", 0, 0, 0, "LAST_HIT", 0, 0, 0, "fighter"),
(14396, 14396, "Merrow the Unicorn", 0, "", 0, "Monster.blue_eye", 11, 16, 60, "male", "L2Pet", 40, 3665, 1327, 10.27, 2.45, 40, 43, 30, 21, 20, 25, 0, 0, 946, 368, 478, 345, 278, 0, 333, 0, 0, 0, 52, 209, "NULL", 0, 0, 0, "LAST_HIT", 0, 0, 0, "fighter"),
(14397, 14397, "Merrow the Unicorn", 0, "", 0, "Monster.blue_eye", 11, 16, 62, "male", "L2Pet", 40, 3863, 1404, 11.85, 2.78, 40, 43, 30, 21, 20, 25, 0, 0, 1038, 388, 532, 363, 278, 0, 333, 0, 0, 0, 52, 209, "NULL", 0, 0, 0, "LAST_HIT", 0, 0, 0, "fighter"),
(14398, 14398, "Merrow the Unicorn", 0, "", 0, "Monster.blue_eye", 11, 16, 64, "male", "L2Pet", 40, 4060, 1482, 11.85, 2.78, 40, 43, 30, 21, 20, 25, 0, 0, 1135, 408, 589, 382, 278, 0, 333, 0, 0, 0, 52, 209, "NULL", 0, 0, 0, "LAST_HIT", 0, 0, 0, "fighter"),
(14399, 14399, "Merrow the Unicorn", 0, "", 0, "Monster.blue_eye", 11, 16, 66, "male", "L2Pet", 40, 4255, 1561, 11.85, 2.78, 40, 43, 30, 21, 20, 25, 0, 0, 1235, 428, 649, 401, 278, 0, 333, 0, 0, 0, 52, 209, "NULL", 0, 0, 0, "LAST_HIT", 0, 0, 0, "fighter"),
(14400, 14400, "Merrow the Unicorn", 0, "", 0, "Monster.blue_eye", 11, 16, 68, "male", "L2Pet", 40, 4447, 1641, 11.85, 2.78, 40, 43, 30, 21, 20, 25, 0, 0, 1339, 449, 713, 421, 370, 0, 432, 0, 0, 0, 48, 180, "NULL", 0, 0, 0, "LAST_HIT", 0, 0, 0, "fighter"),
(14401, 14401, "Merrow the Unicorn", 0, "", 0, "Monster.blue_eye", 11, 16, 70, "male", "L2Pet", 40, 4634, 1722, 11.85, 2.78, 40, 43, 30, 21, 20, 25, 0, 0, 1445, 470, 780, 440, 278, 0, 333, 0, 0, 0, 52, 209, "NULL", 0, 0, 0, "LAST_HIT", 0, 0, 0, "fighter"),
(14402, 14402, "Merrow the Unicorn", 0, "", 0, "Monster.blue_eye", 11, 16, 72, "male", "L2Pet", 40, 4816, 1804, 13.43, 3.09, 40, 43, 30, 21, 20, 25, 0, 0, 1554, 491, 849, 460, 278, 0, 333, 0, 0, 0, 52, 209, "NULL", 0, 0, 0, "LAST_HIT", 0, 0, 0, "fighter"),
(14403, 14403, "Merrow the Unicorn", 0, "", 0, "Monster.blue_eye", 11, 16, 74, "male", "L2Pet", 40, 4990, 1888, 13.43, 3.09, 40, 43, 30, 21, 20, 25, 0, 0, 1664, 512, 921, 480, 370, 0, 333, 0, 0, 0, 48, 180, "NULL", 0, 0, 0, "LAST_HIT", 0, 0, 0, "fighter"),
(14404, 14404, "Merrow the Unicorn", 0, "", 0, "Monster.blue_eye", 11, 16, 76, "male", "L2Pet", 40, 5157, 1972, 8.69, 2.14, 40, 43, 30, 21, 20, 25, 0, 0, 1775, 534, 994, 510, 370, 0, 333, 0, 0, 0, 48, 180, "NULL", 0, 0, 0, "LAST_HIT", 0, 0, 0, "fighter"),
(14405, 14405, "Merrow the Unicorn", 0, "", 0, "Monster.blue_eye", 11, 16, 78, "male", "L2Pet", 40, 5314, 2057, 13.43, 3.09, 40, 43, 30, 21, 20, 25, 0, 0, 1886, 555, 1069, 520, 278, 0, 333, 0, 0, 0, 52, 209, "NULL", 0, 0, 0, "LAST_HIT", 0, 0, 0, "fighter"),
(14406, 14406, "Merrow the Unicorn", 0, "", 0, "Monster.blue_eye", 11, 16, 78, "male", "L2Pet", 40, 5314, 2057, 13.43, 3.09, 40, 43, 30, 21, 20, 25, 0, 0, 1895, 555, 1081, 520, 278, 0, 333, 0, 0, 0, 52, 209, "NULL", 0, 0, 0, "LAST_HIT", 0, 0, 0, "fighter"),
(14407, 14407, "Merrow the Unicorn", 0, "", 0, "Monster.blue_eye", 11, 16, 78, "male", "L2Pet", 40, 5314, 2057, 13.43, 3.09, 40, 43, 30, 21, 20, 25, 0, 0, 1905, 555, 1093, 520, 278, 0, 333, 0, 0, 0, 52, 209, "NULL", 0, 0, 0, "LAST_HIT", 0, 0, 0, "fighter"),
(14408, 14408, "Merrow the Unicorn", 0, "", 0, "Monster.blue_eye", 11, 16, 78, "male", "L2Pet", 40, 5314, 2057, 13.43, 3.09, 40, 43, 30, 21, 20, 25, 0, 0, 1914, 555, 1105, 520, 278, 0, 333, 0, 0, 0, 52, 209, "NULL", 0, 0, 0, "LAST_HIT", 0, 0, 0, "fighter"),
(14409, 14409, "Merrow the Unicorn", 0, "", 0, "Monster.blue_eye", 11, 16, 78, "male", "L2Pet", 40, 5314, 2057, 13.43, 3.09, 40, 43, 30, 21, 20, 25, 0, 0, 1924, 555, 1117, 520, 370, 0, 333, 0, 0, 0, 48, 180, "NULL", 0, 0, 0, "LAST_HIT", 0, 0, 0, "fighter"),
(14410, 14410, "Merrow the Unicorn", 0, "", 0, "Monster.blue_eye", 11, 16, 78, "male", "L2Pet", 40, 5314, 2057, 13.43, 3.09, 40, 43, 30, 21, 20, 25, 0, 0, 1933, 555, 1129, 520, 278, 0, 333, 0, 0, 0, 52, 209, "NULL", 0, 0, 0, "LAST_HIT", 0, 0, 0, "fighter"),
(14411, 14411, "Merrow the Unicorn", 0, "", 0, "Monster.blue_eye", 11, 16, 78, "male", "L2Pet", 40, 5314, 2057, 13.43, 3.09, 40, 43, 30, 21, 20, 25, 0, 0, 1943, 555, 1141, 520, 278, 0, 333, 0, 0, 0, 52, 209, "NULL", 0, 0, 0, "LAST_HIT", 0, 0, 0, "fighter"),
(14412, 14412, "Merrow the Unicorn", 0, "", 0, "Monster.blue_eye", 11, 16, 78, "male", "L2Pet", 40, 5314, 2057, 13.43, 3.09, 40, 43, 30, 21, 20, 25, 0, 0, 1952, 555, 1153, 520, 278, 0, 333, 0, 0, 0, 52, 209, "NULL", 0, 0, 0, "LAST_HIT", 0, 0, 0, "fighter"),
(14413, 14413, "Merrow the Unicorn", 0, "", 0, "Monster.blue_eye", 11, 16, 78, "male", "L2Pet", 40, 5314, 2057, 13.43, 3.09, 40, 43, 30, 21, 20, 25, 0, 0, 1962, 555, 1165, 520, 278, 0, 333, 0, 0, 0, 52, 209, "NULL", 0, 0, 0, "LAST_HIT", 0, 0, 0, "fighter"),
(14414, 14414, "Merrow the Unicorn", 0, "", 0, "Monster.blue_eye", 11, 16, 79, "male", "L2Pet", 40, 5314, 2057, 13.43, 3.09, 40, 43, 30, 21, 20, 25, 0, 0, 1983, 558, 1192, 523, 278, 0, 333, 0, 0, 0, 52, 209, "NULL", 0, 0, 0, "LAST_HIT", 0, 0, 0, "fighter"),
(14415, 14415, "Merrow the Unicorn", 0, "", 0, "Monster.blue_eye", 11, 16, 79, "male", "L2Pet", 40, 5314, 2057, 13.43, 3.09, 40, 43, 30, 21, 20, 25, 0, 0, 1992, 558, 1204, 523, 278, 0, 333, 0, 0, 0, 52, 209, "NULL", 0, 0, 0, "LAST_HIT", 0, 0, 0, "fighter"),
(14416, 14416, "Merrow the Unicorn", 0, "", 0, "Monster.blue_eye", 11, 16, 79, "male", "L2Pet", 40, 5314, 2057, 13.43, 3.09, 40, 43, 30, 21, 20, 25, 0, 0, 2002, 558, 1216, 523, 278, 0, 333, 0, 0, 0, 52, 209, "NULL", 0, 0, 0, "LAST_HIT", 0, 0, 0, "fighter"),
(14417, 14417, "Merrow the Unicorn", 0, "", 0, "Monster.blue_eye", 11, 16, 79, "male", "L2Pet", 40, 5314, 2057, 13.43, 3.09, 40, 43, 30, 21, 20, 25, 0, 0, 2011, 558, 1228, 523, 278, 0, 333, 0, 0, 0, 52, 209, "NULL", 0, 0, 0, "LAST_HIT", 0, 0, 0, "fighter"),
(14418, 14418, "Merrow the Unicorn", 0, "", 0, "Monster.blue_eye", 11, 16, 79, "male", "L2Pet", 40, 5314, 2057, 13.43, 3.09, 40, 43, 30, 21, 20, 25, 0, 0, 2021, 558, 1240, 523, 278, 0, 333, 0, 0, 0, 52, 209, "NULL", 0, 0, 0, "LAST_HIT", 0, 0, 0, "fighter"),
(14419, 14419, "Merrow the Unicorn", 0, "", 0, "Monster.blue_eye", 11, 16, 79, "male", "L2Pet", 40, 5314, 2057, 13.43, 3.09, 40, 43, 30, 21, 20, 25, 0, 0, 2030, 558, 1253, 523, 278, 0, 333, 0, 0, 0, 52, 209, "NULL", 0, 0, 0, "LAST_HIT", 0, 0, 0, "fighter"),
(14420, 14420, "Merrow the Unicorn", 0, "", 0, "Monster.blue_eye", 11, 16, 79, "male", "L2Pet", 40, 5314, 2057, 13.43, 3.09, 40, 43, 30, 21, 20, 25, 0, 0, 2040, 558, 1265, 523, 278, 0, 333, 0, 0, 0, 52, 209, "NULL", 0, 0, 0, "LAST_HIT", 0, 0, 0, "fighter"),
(14421, 14421, "Merrow the Unicorn", 0, "", 0, "Monster.blue_eye", 11, 16, 79, "male", "L2Pet", 40, 5314, 2057, 13.43, 3.09, 40, 43, 30, 21, 20, 25, 0, 0, 2049, 558, 1277, 523, 278, 0, 333, 0, 0, 0, 52, 209, "NULL", 0, 0, 0, "LAST_HIT", 0, 0, 0, "fighter"),
(14422, 14422, "Merrow the Unicorn", 0, "", 0, "Monster.blue_eye", 11, 16, 79, "male", "L2Pet", 40, 5314, 2057, 13.43, 3.09, 40, 43, 30, 21, 20, 25, 0, 0, 2059, 558, 1289, 523, 278, 0, 333, 0, 0, 0, 52, 209, "NULL", 0, 0, 0, "LAST_HIT", 0, 0, 0, "fighter"),
(14423, 14423, "Merrow the Unicorn", 0, "", 0, "Monster.blue_eye", 11, 16, 80, "male", "L2Pet", 40, 5314, 2057, 13.43, 3.09, 40, 43, 30, 21, 20, 25, 0, 0, 2080, 562, 1317, 526, 278, 0, 333, 0, 0, 0, 52, 209, "NULL", 0, 0, 0, "LAST_HIT", 0, 0, 0, "fighter"),
(14424, 14424, "Merrow the Unicorn", 0, "", 0, "Monster.blue_eye", 11, 16, 80, "male", "L2Pet", 40, 5314, 2057, 13.43, 3.09, 40, 43, 30, 21, 20, 25, 0, 0, 2090, 562, 1329, 526, 278, 0, 333, 0, 0, 0, 52, 209, "NULL", 0, 0, 0, "LAST_HIT", 0, 0, 0, "fighter"),
(14425, 14425, "Merrow the Unicorn", 0, "", 0, "Monster.blue_eye", 11, 16, 80, "male", "L2Pet", 40, 5314, 2057, 13.43, 3.09, 40, 43, 30, 21, 20, 25, 0, 0, 2100, 562, 1342, 526, 278, 0, 333, 0, 0, 0, 52, 209, "NULL", 0, 0, 0, "LAST_HIT", 0, 0, 0, "fighter"),
(14426, 14426, "Merrow the Unicorn", 0, "", 0, "Monster.blue_eye", 11, 16, 80, "male", "L2Pet", 40, 5314, 2057, 13.43, 3.09, 40, 43, 30, 21, 20, 25, 0, 0, 2109, 562, 1354, 526, 278, 0, 333, 0, 0, 0, 52, 209, "NULL", 0, 0, 0, "LAST_HIT", 0, 0, 0, "fighter"),
(14427, 14427, "Merrow the Unicorn", 0, "", 0, "Monster.blue_eye", 11, 16, 80, "male", "L2Pet", 40, 5314, 2057, 13.43, 3.09, 40, 43, 30, 21, 20, 25, 0, 0, 2119, 562, 1366, 526, 278, 0, 333, 0, 0, 0, 52, 209, "NULL", 0, 0, 0, "LAST_HIT", 0, 0, 0, "fighter"),
(14428, 14428, "Merrow the Unicorn", 0, "", 0, "Monster.blue_eye", 11, 16, 80, "male", "L2Pet", 40, 5314, 2057, 13.43, 3.09, 40, 43, 30, 21, 20, 25, 0, 0, 2128, 562, 1379, 526, 278, 0, 333, 0, 0, 0, 52, 209, "NULL", 0, 0, 0, "LAST_HIT", 0, 0, 0, "fighter"),
(14429, 14429, "Merrow the Unicorn", 0, "", 0, "Monster.blue_eye", 11, 16, 80, "male", "L2Pet", 40, 5314, 2057, 13.43, 3.09, 40, 43, 30, 21, 20, 25, 0, 0, 2138, 562, 1391, 526, 278, 0, 333, 0, 0, 0, 52, 209, "NULL", 0, 0, 0, "LAST_HIT", 0, 0, 0, "balanced"),
(14430, 14430, "Merrow the Unicorn", 0, "", 0, "Monster.blue_eye", 11, 16, 80, "male", "L2Pet", 40, 5314, 2057, 13.43, 3.09, 40, 43, 30, 21, 20, 25, 0, 0, 2147, 562, 1403, 526, 278, 0, 333, 0, 0, 0, 52, 209, "NULL", 0, 0, 0, "LAST_HIT", 0, 0, 0, "balanced"),
(14431, 14431, "Merrow the Unicorn", 0, "", 0, "Monster.blue_eye", 11, 16, 80, "male", "L2Pet", 40, 5314, 2057, 13.43, 3.09, 40, 43, 30, 21, 20, 25, 0, 0, 2157, 562, 1416, 526, 278, 0, 333, 0, 0, 0, 52, 209, "NULL", 0, 0, 0, "LAST_HIT", 0, 0, 0, "balanced"),
(14432, 14432, "Merrow the Unicorn", 0, "", 0, "Monster.blue_eye", 11, 16, 80, "male", "L2Pet", 40, 5314, 2057, 13.43, 3.09, 40, 43, 30, 21, 20, 25, 0, 0, 2166, 562, 1428, 526, 278, 0, 333, 0, 0, 0, 52, 209, "NULL", 0, 0, 0, "LAST_HIT", 0, 0, 0, "balanced"),
(14433, 14433, "Merrow the Unicorn", 0, "", 0, "Monster.blue_eye", 11, 16, 80, "male", "L2Pet", 40, 5314, 2057, 13.43, 3.09, 40, 43, 30, 21, 20, 25, 0, 0, 2176, 562, 1440, 526, 278, 0, 333, 0, 0, 0, 52, 209, "NULL", 0, 0, 0, "LAST_HIT", 0, 0, 0, "balanced"),
(14434, 14434, "Merrow the Unicorn", 0, "", 0, "Monster.blue_eye", 11, 16, 80, "male", "L2Pet", 40, 5314, 2057, 13.43, 3.09, 40, 43, 30, 21, 20, 25, 0, 0, 2185, 562, 1453, 526, 278, 0, 333, 0, 0, 0, 52, 209, "NULL", 0, 0, 0, "LAST_HIT", 0, 0, 0, "balanced"),
(14435, 14435, "Unicorn Seraphim", 0, "", 0, "Monster2.angelic_unicorn", 9, 25.5, 58, "male", "L2Pet", 40, 2889, 1251, 10.27, 2.45, 40, 43, 30, 21, 20, 25, 0, 0, 313, 349, 428, 327, 278, 0, 333, 0, 0, 0, 29, 154, "NULL", 0, 0, 0, "LAST_HIT", 0, 0, 0, "balanced"),
(14436, 14436, "Unicorn Seraphim", 0, "", 0, "Monster2.angelic_unicorn", 9, 25.5, 60, "male", "L2Pet", 40, 3054, 1327, 10.27, 2.45, 40, 43, 30, 21, 20, 25, 0, 0, 340, 368, 478, 345, 278, 0, 333, 0, 0, 0, 29, 154, "NULL", 0, 0, 0, "LAST_HIT", 0, 0, 0, "balanced"),
(14437, 14437, "Unicorn Seraphim", 0, "", 0, "Monster2.angelic_unicorn", 9, 25.5, 62, "male", "L2Pet", 40, 3219, 1404, 11.85, 2.78, 40, 43, 30, 21, 20, 25, 0, 0, 368, 388, 532, 363, 278, 0, 333, 0, 0, 0, 29, 154, "NULL", 0, 0, 0, "LAST_HIT", 0, 0, 0, "balanced"),
(14438, 14438, "Unicorn Seraphim", 0, "", 0, "Monster2.angelic_unicorn", 9, 25.5, 64, "male", "L2Pet", 40, 3384, 1482, 11.85, 2.78, 40, 43, 30, 21, 20, 25, 0, 0, 397, 408, 589, 382, 278, 0, 333, 0, 0, 0, 29, 154, "NULL", 0, 0, 0, "LAST_HIT", 0, 0, 0, "balanced"),
(14439, 14439, "Unicorn Seraphim", 0, "", 0, "Monster2.angelic_unicorn", 9, 25.5, 66, "male", "L2Pet", 40, 3546, 1561, 11.85, 2.78, 40, 43, 30, 21, 20, 25, 0, 0, 427, 428, 649, 401, 278, 0, 333, 0, 0, 0, 29, 154, "NULL", 0, 0, 0, "LAST_HIT", 0, 0, 0, "balanced"),
(14440, 14440, "Unicorn Seraphim", 0, "", 0, "Monster2.angelic_unicorn", 9, 25.5, 68, "male", "L2Pet", 40, 3706, 1641, 11.85, 2.78, 40, 43, 30, 21, 20, 25, 0, 0, 457, 449, 713, 421, 278, 0, 333, 0, 0, 0, 29, 154, "NULL", 0, 0, 0, "LAST_HIT", 0, 0, 0, "balanced"),
(14441, 14441, "Unicorn Seraphim", 0, "", 0, "Monster2.angelic_unicorn", 9, 25.5, 70, "male", "L2Pet", 40, 3862, 1722, 11.85, 2.78, 40, 43, 30, 21, 20, 25, 0, 0, 487, 470, 780, 440, 278, 0, 333, 0, 0, 0, 29, 154, "NULL", 0, 0, 0, "LAST_HIT", 0, 0, 0, "balanced"),
(14442, 14442, "Unicorn Seraphim", 0, "", 0, "Monster2.angelic_unicorn", 9, 25.5, 72, "male", "L2Pet", 40, 4013, 1804, 13.43, 3.09, 40, 43, 30, 21, 20, 25, 0, 0, 517, 491, 849, 460, 278, 0, 333, 0, 0, 0, 29, 154, "NULL", 0, 0, 0, "LAST_HIT", 0, 0, 0, "balanced"),
(14443, 14443, "Unicorn Seraphim", 0, "", 0, "Monster2.angelic_unicorn", 9, 25.5, 74, "male", "L2Pet", 40, 4158, 1888, 13.43, 3.09, 40, 43, 30, 21, 20, 25, 0, 0, 547, 512, 921, 480, 278, 0, 333, 0, 0, 0, 29, 154, "NULL", 0, 0, 0, "LAST_HIT", 0, 0, 0, "balanced"),
(14444, 14444, "Unicorn Seraphim", 0, "", 0, "Monster2.angelic_unicorn", 9, 25.5, 76, "male", "L2Pet", 40, 4297, 1972, 13.43, 3.09, 40, 43, 30, 21, 20, 25, 0, 0, 577, 534, 994, 500, 278, 0, 333, 0, 0, 0, 27, 160, "NULL", 0, 0, 0, "LAST_HIT", 0, 0, 0, "balanced"),
(14449, 14449, "Unicorn Seraphim", 0, "", 0, "Monster2.angelic_unicorn", 9, 25.5, 78, "male", "L2Pet", 40, 4428, 2057, 13.43, 3.09, 40, 43, 30, 21, 20, 25, 0, 0, 595, 555, 1069, 520, 278, 0, 333, 0, 0, 0, 29, 154, "NULL", 0, 0, 0, "LAST_HIT", 0, 0, 0, "balanced"),
(14450, 14450, "Unicorn Seraphim", 0, "", 0, "Monster2.angelic_unicorn", 9, 25.5, 78, "male", "L2Pet", 40, 4428, 2057, 13.43, 3.09, 40, 43, 30, 21, 20, 25, 0, 0, 595, 555, 1069, 520, 278, 0, 333, 0, 0, 0, 29, 154, "NULL", 0, 0, 0, "LAST_HIT", 0, 0, 0, "balanced"),
(14451, 14451, "Unicorn Seraphim", 0, "", 0, "Monster2.angelic_unicorn", 9, 25.5, 78, "male", "L2Pet", 40, 4428, 2057, 13.43, 3.09, 40, 43, 30, 21, 20, 25, 0, 0, 595, 555, 1069, 520, 278, 0, 333, 0, 0, 0, 29, 154, "NULL", 0, 0, 0, "LAST_HIT", 0, 0, 0, "balanced"),
(14452, 14452, "Unicorn Seraphim", 0, "", 0, "Monster2.angelic_unicorn", 9, 25.5, 78, "male", "L2Pet", 40, 4428, 2057, 13.43, 3.09, 40, 43, 30, 21, 20, 25, 0, 0, 595, 555, 1069, 520, 278, 0, 333, 0, 0, 0, 29, 154, "NULL", 0, 0, 0, "LAST_HIT", 0, 0, 0, "balanced"),
(14453, 14453, "Unicorn Seraphim", 0, "", 0, "Monster2.angelic_unicorn", 9, 25.5, 78, "male", "L2Pet", 40, 4428, 2057, 13.43, 3.09, 40, 43, 30, 21, 20, 25, 0, 0, 595, 555, 1069, 520, 278, 0, 333, 0, 0, 0, 29, 154, "NULL", 0, 0, 0, "LAST_HIT", 0, 0, 0, "balanced"),
(14454, 14454, "Unicorn Seraphim", 0, "", 0, "Monster2.angelic_unicorn", 9, 25.5, 78, "male", "L2Pet", 40, 4428, 2057, 13.43, 3.09, 40, 43, 30, 21, 20, 25, 0, 0, 595, 555, 1069, 520, 278, 0, 333, 0, 0, 0, 29, 154, "NULL", 0, 0, 0, "LAST_HIT", 0, 0, 0, "balanced"),
(14455, 14455, "Unicorn Seraphim", 0, "", 0, "Monster2.angelic_unicorn", 9, 25.5, 78, "male", "L2Pet", 40, 4428, 2057, 13.43, 3.09, 40, 43, 30, 21, 20, 25, 0, 0, 595, 555, 1069, 520, 278, 0, 333, 0, 0, 0, 27, 160, "NULL", 0, 0, 0, "LAST_HIT", 0, 0, 0, "balanced"),
(14456, 14456, "Unicorn Seraphim", 0, "", 0, "Monster2.angelic_unicorn", 9, 25.5, 78, "male", "L2Pet", 40, 4428, 2057, 13.43, 3.09, 40, 43, 30, 21, 20, 25, 0, 0, 595, 555, 1069, 520, 278, 0, 333, 0, 0, 0, 29, 154, "NULL", 0, 0, 0, "LAST_HIT", 0, 0, 0, "balanced"),
(14457, 14457, "Unicorn Seraphim", 0, "", 0, "Monster2.angelic_unicorn", 9, 25.5, 78, "male", "L2Pet", 40, 4428, 2057, 13.43, 3.09, 40, 43, 30, 21, 20, 25, 0, 0, 595, 555, 1069, 520, 278, 0, 333, 0, 0, 0, 29, 154, "NULL", 0, 0, 0, "LAST_HIT", 0, 0, 0, "balanced"),
(14458, 14458, "Unicorn Seraphim", 0, "", 0, "Monster2.angelic_unicorn", 9, 25.5, 79, "male", "L2Pet", 40, 4428, 2057, 13.43, 3.09, 40, 43, 30, 21, 20, 25, 0, 0, 598, 558, 1082, 523, 278, 0, 333, 0, 0, 0, 29, 154, "NULL", 0, 0, 0, "LAST_HIT", 0, 0, 0, "balanced"),
(14459, 14459, "Unicorn Seraphim", 0, "", 0, "Monster2.angelic_unicorn", 9, 25.5, 79, "male", "L2Pet", 40, 4428, 2057, 13.43, 3.09, 40, 43, 30, 21, 20, 25, 0, 0, 598, 558, 1082, 523, 278, 0, 333, 0, 0, 0, 29, 154, "NULL", 0, 0, 0, "LAST_HIT", 0, 0, 0, "balanced"),
(14460, 14460, "Unicorn Seraphim", 0, "", 0, "Monster2.angelic_unicorn", 9, 25.5, 79, "male", "L2Pet", 40, 4428, 2057, 13.43, 3.09, 40, 43, 30, 21, 20, 25, 0, 0, 598, 558, 1082, 523, 278, 0, 333, 0, 0, 0, 29, 154, "NULL", 0, 0, 0, "LAST_HIT", 0, 0, 0, "balanced"),
(14461, 14461, "Unicorn Seraphim", 0, "", 0, "Monster2.angelic_unicorn", 9, 25.5, 79, "male", "L2Pet", 40, 4428, 2057, 13.43, 3.09, 40, 43, 30, 21, 20, 25, 0, 0, 598, 558, 1082, 523, 278, 0, 333, 0, 0, 0, 29, 154, "NULL", 0, 0, 0, "LAST_HIT", 0, 0, 0, "balanced"),
(14462, 14462, "Unicorn Seraphim", 0, "", 0, "Monster2.angelic_unicorn", 9, 25.5, 79, "male", "L2Pet", 40, 4428, 2057, 13.43, 3.09, 40, 43, 30, 21, 20, 25, 0, 0, 598, 558, 1082, 523, 278, 0, 333, 0, 0, 0, 29, 154, "NULL", 0, 0, 0, "LAST_HIT", 0, 0, 0, "balanced"),
(14463, 14463, "Unicorn Seraphim", 0, "", 0, "Monster2.angelic_unicorn", 9, 25.5, 79, "male", "L2Pet", 40, 4428, 2057, 13.43, 3.09, 40, 43, 30, 21, 20, 25, 0, 0, 598, 558, 1082, 523, 278, 0, 333, 0, 0, 0, 29, 154, "NULL", 0, 0, 0, "LAST_HIT", 0, 0, 0, "balanced"),
(14464, 14464, "Unicorn Seraphim", 0, "", 0, "Monster2.angelic_unicorn", 9, 25.5, 79, "male", "L2Pet", 40, 4428, 2057, 13.43, 3.09, 40, 43, 30, 21, 20, 25, 0, 0, 598, 558, 1082, 523, 278, 0, 333, 0, 0, 0, 29, 154, "NULL", 0, 0, 0, "LAST_HIT", 0, 0, 0, "balanced"),
(14465, 14465, "Unicorn Seraphim", 0, "", 0, "Monster2.angelic_unicorn", 9, 25.5, 79, "male", "L2Pet", 40, 4428, 2057, 13.43, 3.09, 40, 43, 30, 21, 20, 25, 0, 0, 598, 558, 1082, 523, 278, 0, 333, 0, 0, 0, 29, 154, "NULL", 0, 0, 0, "LAST_HIT", 0, 0, 0, "balanced"),
(14466, 14466, "Unicorn Seraphim", 0, "", 0, "Monster2.angelic_unicorn", 9, 25.5, 79, "male", "L2Pet", 40, 4428, 2057, 13.43, 3.09, 40, 43, 30, 21, 20, 25, 0, 0, 598, 558, 1082, 523, 278, 0, 333, 0, 0, 0, 29, 154, "NULL", 0, 0, 0, "LAST_HIT", 0, 0, 0, "balanced"),
(14467, 14467, "Unicorn Seraphim", 0, "", 0, "Monster2.angelic_unicorn", 9, 25.5, 80, "male", "L2Pet", 40, 4428, 2057, 13.43, 3.09, 40, 43, 30, 21, 20, 25, 0, 0, 602, 562, 1095, 526, 278, 0, 333, 0, 0, 0, 29, 154, "NULL", 0, 0, 0, "LAST_HIT", 0, 0, 0, "balanced"),
(14468, 14468, "Unicorn Seraphim", 0, "", 0, "Monster2.angelic_unicorn", 9, 25.5, 80, "male", "L2Pet", 40, 4428, 2057, 13.43, 3.09, 40, 43, 30, 21, 20, 25, 0, 0, 602, 562, 1095, 526, 278, 0, 333, 0, 0, 0, 29, 154, "NULL", 0, 0, 0, "LAST_HIT", 0, 0, 0, "balanced"),
(14469, 14469, "Unicorn Seraphim", 0, "", 0, "Monster2.angelic_unicorn", 9, 25.5, 80, "male", "L2Pet", 40, 4428, 2057, 13.43, 3.09, 40, 43, 30, 21, 20, 25, 0, 0, 602, 562, 1095, 526, 278, 0, 333, 0, 0, 0, 29, 154, "NULL", 0, 0, 0, "LAST_HIT", 0, 0, 0, "balanced"),
(14470, 14470, "Unicorn Seraphim", 0, "", 0, "Monster2.angelic_unicorn", 9, 25.5, 80, "male", "L2Pet", 40, 4428, 2057, 13.43, 3.09, 40, 43, 30, 21, 20, 25, 0, 0, 602, 562, 1095, 526, 278, 0, 333, 0, 0, 0, 29, 154, "NULL", 0, 0, 0, "LAST_HIT", 0, 0, 0, "balanced"),
(14471, 14471, "Unicorn Seraphim", 0, "", 0, "Monster2.angelic_unicorn", 9, 25.5, 80, "male", "L2Pet", 40, 4428, 2057, 13.43, 3.09, 40, 43, 30, 21, 20, 25, 0, 0, 602, 562, 1095, 526, 278, 0, 333, 0, 0, 0, 29, 154, "NULL", 0, 0, 0, "LAST_HIT", 0, 0, 0, "balanced"),
(14472, 14472, "Unicorn Seraphim", 0, "", 0, "Monster2.angelic_unicorn", 9, 25.5, 80, "male", "L2Pet", 40, 4428, 2057, 13.43, 3.09, 40, 43, 30, 21, 20, 25, 0, 0, 602, 562, 1095, 526, 278, 0, 333, 0, 0, 0, 29, 154, "NULL", 0, 0, 0, "LAST_HIT", 0, 0, 0, "balanced"),
(14473, 14473, "Unicorn Seraphim", 0, "", 0, "Monster2.angelic_unicorn", 9, 25.5, 80, "male", "L2Pet", 40, 4428, 2057, 13.43, 3.09, 40, 43, 30, 21, 20, 25, 0, 0, 602, 562, 1095, 526, 278, 0, 333, 0, 0, 0, 29, 154, "NULL", 0, 0, 0, "LAST_HIT", 0, 0, 0, "balanced"),
(14474, 14474, "Unicorn Seraphim", 0, "", 0, "Monster2.angelic_unicorn", 9, 25.5, 80, "male", "L2Pet", 40, 4428, 2057, 13.43, 3.09, 40, 43, 30, 21, 20, 25, 0, 0, 602, 562, 1095, 526, 278, 0, 333, 0, 0, 0, 29, 154, "NULL", 0, 0, 0, "LAST_HIT", 0, 0, 0, "balanced"),
(14475, 14475, "Unicorn Seraphim", 0, "", 0, "Monster2.angelic_unicorn", 9, 25.5, 80, "male", "L2Pet", 40, 4428, 2057, 13.43, 3.09, 40, 43, 30, 21, 20, 25, 0, 0, 602, 562, 1095, 526, 278, 0, 333, 0, 0, 0, 29, 154, "NULL", 0, 0, 0, "LAST_HIT", 0, 0, 0, "balanced"),
(14476, 14476, "Unicorn Seraphim", 0, "", 0, "Monster2.angelic_unicorn", 9, 25.5, 80, "male", "L2Pet", 40, 4428, 2057, 13.43, 3.09, 40, 43, 30, 21, 20, 25, 0, 0, 602, 562, 1095, 526, 278, 0, 333, 0, 0, 0, 29, 154, "NULL", 0, 0, 0, "LAST_HIT", 0, 0, 0, "balanced"),
(14477, 14477, "Unicorn Seraphim", 0, "", 0, "Monster2.angelic_unicorn", 9, 25.5, 80, "male", "L2Pet", 40, 4428, 2057, 13.43, 3.09, 40, 43, 30, 21, 20, 25, 0, 0, 602, 562, 1095, 526, 278, 0, 333, 0, 0, 0, 29, 154, "NULL", 0, 0, 0, "LAST_HIT", 0, 0, 0, "balanced"),
(14478, 14478, "Unicorn Seraphim", 0, "", 0, "Monster2.angelic_unicorn", 9, 25.5, 80, "male", "L2Pet", 40, 4428, 2057, 13.43, 3.09, 40, 43, 30, 21, 20, 25, 0, 0, 602, 562, 1095, 526, 278, 0, 333, 0, 0, 0, 29, 154, "NULL", 0, 0, 0, "LAST_HIT", 0, 0, 0, "balanced"),
(14479, 14479, "Shadow", 0, "", 0, "Monster.shadow", 10, 30, 22, "male", "L2Pet", 40, 978, 279, 5.53, 1.53, 40, 43, 30, 21, 20, 25, 0, 0, 68, 102, 28, 96, 278, 0, 333, 0, 0, 0, 88, 154, "NULL", 0, 0, 0, "LAST_HIT", 0, 0, 0, "fighter"),
(14480, 14480, "Shadow", 0, "", 0, "Monster.shadow", 10, 30, 32, "male", "L2Pet", 40, 1689, 458, 7.11, 1.84, 40, 43, 30, 21, 20, 25, 0, 0, 154, 151, 69, 142, 278, 0, 333, 0, 0, 0, 80, 140, "NULL", 0, 0, 0, "LAST_HIT", 0, 0, 0, "fighter"),
(14481, 14481, "Shadow", 0, "", 0, "Monster.shadow", 10, 30, 42, "male", "L2Pet", 40, 2656, 679, 8.69, 2.14, 40, 43, 30, 21, 20, 25, 0, 0, 311, 215, 152, 202, 278, 0, 333, 0, 0, 0, 88, 154, "NULL", 0, 0, 0, "LAST_HIT", 0, 0, 0, "fighter"),
(14482, 14482, "Shadow", 0, "", 0, "Monster.shadow", 10, 30, 50, "male", "L2Pet", 40, 3592, 957, 8.69, 2.14, 40, 43, 30, 21, 20, 25, 0, 0, 509, 278, 264, 260, 278, 0, 333, 0, 0, 0, 88, 154, "NULL", 0, 0, 0, "LAST_HIT", 0, 0, 0, "fighter"),
(14483, 14483, "Shadow", 0, "", 0, "Monster.shadow", 10, 30, 58, "male", "L2Pet", 40, 4622, 1251, 10.27, 2.45, 40, 43, 30, 21, 20, 25, 0, 0, 781, 349, 428, 327, 278, 0, 333, 0, 0, 0, 88, 154, "NULL", 0, 0, 0, "LAST_HIT", 0, 0, 0, "fighter"),
(14484, 14484, "Shadow", 0, "", 0, "Monster.shadow", 10, 30, 27, "male", "L2Pet", 40, 1302, 367, 5.53, 1.53, 40, 43, 30, 21, 20, 25, 0, 0, 104, 125, 45, 117, 278, 0, 333, 0, 0, 0, 88, 154, "NULL", 0, 0, 0, "LAST_HIT", 0, 0, 0, "fighter"),
(14485, 14485, "Shadow", 0, "", 0, "Monster.shadow", 10, 30, 37, "male", "L2Pet", 40, 2142, 553, 7.11, 1.84, 40, 43, 30, 21, 20, 25, 0, 0, 222, 182, 104, 170, 320, 0, 333, 0, 0, 0, 80, 140, "NULL", 0, 0, 0, "LAST_HIT", 0, 0, 0, "fighter"),
(14486, 14486, "Shadow", 0, "", 0, "Monster.shadow", 10, 30, 46, "male", "L2Pet", 40, 3108, 816, 8.69, 2.14, 40, 43, 30, 21, 20, 25, 0, 0, 401, 245, 202, 230, 278, 0, 333, 0, 0, 0, 88, 154, "NULL", 0, 0, 0, "LAST_HIT", 0, 0, 0, "fighter"),
(14487, 14487, "Shadow", 0, "", 0, "Monster.shadow", 10, 30, 54, "male", "L2Pet", 40, 4099, 1102, 10.27, 2.45, 40, 43, 30, 21, 20, 25, 0, 0, 636, 313, 339, 293, 278, 0, 333, 0, 0, 0, 88, 154, "NULL", 0, 0, 0, "LAST_HIT", 0, 0, 0, "fighter"),
(14488, 14488, "Shadow", 0, "", 0, "Monster.shadow", 10, 30, 60, "male", "L2Pet", 40, 4887, 1327, 10.27, 2.45, 40, 43, 30, 21, 20, 25, 0, 0, 860, 368, 478, 345, 278, 0, 333, 0, 0, 0, 88, 154, "NULL", 0, 0, 0, "LAST_HIT", 0, 0, 0, "fighter"),
(14489, 14489, "Shadow", 0, "", 0, "Monster.shadow", 10, 30, 62, "male", "L2Pet", 40, 5151, 1404, 11.85, 2.78, 40, 43, 30, 21, 20, 25, 0, 0, 944, 388, 532, 363, 370, 0, 333, 0, 0, 0, 80, 140, "NULL", 0, 0, 0, "LAST_HIT", 0, 0, 0, "fighter"),
(14490, 14490, "Shadow", 0, "", 0, "Monster.shadow", 10, 30, 64, "male", "L2Pet", 40, 5414, 1482, 11.85, 2.78, 40, 43, 30, 21, 20, 25, 0, 0, 1031, 408, 589, 382, 278, 0, 333, 0, 0, 0, 88, 154, "NULL", 0, 0, 0, "LAST_HIT", 0, 0, 0, "fighter"),
(14491, 14491, "Shadow", 0, "", 0, "Monster.shadow", 10, 30, 66, "male", "L2Pet", 40, 5674, 1561, 11.85, 2.78, 40, 43, 30, 21, 20, 25, 0, 0, 1123, 428, 649, 401, 278, 0, 333, 0, 0, 0, 88, 154, "NULL", 0, 0, 0, "LAST_HIT", 0, 0, 0, "fighter"),
(14492, 14492, "Shadow", 0, "", 0, "Monster.shadow", 10, 30, 68, "male", "L2Pet", 40, 5930, 1641, 11.85, 2.78, 40, 43, 30, 21, 20, 25, 0, 0, 1217, 449, 713, 421, 278, 0, 333, 0, 0, 0, 88, 154, "NULL", 0, 0, 0, "LAST_HIT", 0, 0, 0, "fighter"),
(14493, 14493, "Shadow", 0, "", 0, "Monster.shadow", 10, 30, 70, "male", "L2Pet", 40, 6179, 1722, 11.85, 2.78, 40, 43, 30, 21, 20, 25, 0, 0, 1314, 470, 780, 440, 278, 0, 333, 0, 0, 0, 88, 154, "NULL", 0, 0, 0, "LAST_HIT", 0, 0, 0, "fighter"),
(14494, 14494, "Shadow", 0, "", 0, "Monster.shadow", 10, 30, 72, "male", "L2Pet", 40, 6421, 1804, 13.43, 3.09, 40, 43, 30, 21, 20, 25, 0, 0, 1413, 491, 849, 460, 278, 0, 333, 0, 0, 0, 88, 154, "NULL", 0, 0, 0, "LAST_HIT", 0, 0, 0, "fighter"),
(14495, 14495, "Shadow", 0, "", 0, "Monster.shadow", 10, 30, 74, "male", "L2Pet", 40, 6654, 1888, 13.43, 3.09, 40, 43, 30, 21, 20, 25, 0, 0, 1513, 512, 921, 480, 278, 0, 333, 0, 0, 0, 88, 154, "NULL", 0, 0, 0, "LAST_HIT", 0, 0, 0, "fighter"),
(14496, 14496, "Shadow", 0, "", 0, "Monster.shadow", 10, 30, 76, "male", "L2Pet", 40, 6876, 1972, 13.43, 3.09, 40, 43, 30, 21, 20, 25, 0, 0, 1614, 534, 994, 500, 370, 0, 333, 0, 0, 0, 80, 140, "NULL", 0, 0, 0, "LAST_HIT", 0, 0, 0, "fighter"),
(14497, 14497, "Shadow", 0, "", 0, "Monster.shadow", 10, 30, 78, "male", "L2Pet", 40, 7085, 2057, 13.43, 3.09, 40, 43, 30, 21, 20, 25, 0, 0, 1715, 555, 1069, 520, 278, 0, 333, 0, 0, 0, 88, 154, "NULL", 0, 0, 0, "LAST_HIT", 0, 0, 0, "fighter"),
(14498, 14498, "Shadow", 0, "", 0, "Monster.shadow", 10, 30, 78, "male", "L2Pet", 40, 7085, 2057, 13.43, 3.09, 40, 43, 30, 21, 20, 25, 0, 0, 1723, 555, 1081, 520, 278, 0, 333, 0, 0, 0, 88, 154, "NULL", 0, 0, 0, "LAST_HIT", 0, 0, 0, "fighter"),
(14499, 14499, "Shadow", 0, "", 0, "Monster.shadow", 10, 30, 78, "male", "L2Pet", 40, 7085, 2057, 13.43, 3.09, 40, 43, 30, 21, 20, 25, 0, 0, 1732, 555, 1093, 520, 278, 0, 333, 0, 0, 0, 88, 154, "NULL", 0, 0, 0, "LAST_HIT", 0, 0, 0, "fighter"),
(14500, 14500, "Shadow", 0, "", 0, "Monster.shadow", 10, 30, 78, "male", "L2Pet", 40, 7085, 2057, 13.43, 3.09, 40, 43, 30, 21, 20, 25, 0, 0, 1740, 555, 1105, 520, 278, 0, 333, 0, 0, 0, 88, 154, "NULL", 0, 0, 0, "LAST_HIT", 0, 0, 0, "fighter"),
(14501, 14501, "Shadow", 0, "", 0, "Monster.shadow", 10, 30, 78, "male", "L2Pet", 40, 7085, 2057, 13.43, 3.09, 40, 43, 30, 21, 20, 25, 0, 0, 1749, 555, 1117, 520, 278, 0, 333, 0, 0, 0, 88, 154, "NULL", 0, 0, 0, "LAST_HIT", 0, 0, 0, "fighter"),
(14502, 14502, "Shadow", 0, "", 0, "Monster.shadow", 10, 30, 78, "male", "L2Pet", 40, 7085, 2057, 13.43, 3.09, 40, 43, 30, 21, 20, 25, 0, 0, 1757, 555, 1129, 520, 278, 0, 333, 0, 0, 0, 88, 154, "NULL", 0, 0, 0, "LAST_HIT", 0, 0, 0, "fighter"),
(14503, 14503, "Shadow", 0, "", 0, "Monster.shadow", 10, 30, 78, "male", "L2Pet", 40, 7085, 2057, 13.43, 3.09, 40, 43, 30, 21, 20, 25, 0, 0, 1766, 555, 1141, 520, 278, 0, 333, 0, 0, 0, 88, 154, "NULL", 0, 0, 0, "LAST_HIT", 0, 0, 0, "fighter"),
(14504, 14504, "Shadow", 0, "", 0, "Monster.shadow", 10, 30, 78, "male", "L2Pet", 40, 7085, 2057, 13.43, 3.09, 40, 43, 30, 21, 20, 25, 0, 0, 1775, 555, 1153, 520, 278, 0, 333, 0, 0, 0, 88, 154, "NULL", 0, 0, 0, "LAST_HIT", 0, 0, 0, "fighter"),
(14505, 14505, "Shadow", 0, "", 0, "Monster.shadow", 10, 30, 78, "male", "L2Pet", 40, 7085, 2057, 13.43, 3.09, 40, 43, 30, 21, 20, 25, 0, 0, 1783, 555, 1165, 520, 278, 0, 333, 0, 0, 0, 88, 154, "NULL", 0, 0, 0, "LAST_HIT", 0, 0, 0, "balanced"),
(14506, 14506, "Shadow", 0, "", 0, "Monster.shadow", 10, 30, 79, "male", "L2Pet", 40, 7085, 2057, 13.43, 3.09, 40, 43, 30, 21, 20, 25, 0, 0, 1802, 558, 1192, 523, 278, 0, 333, 0, 0, 0, 88, 154, "NULL", 0, 0, 0, "LAST_HIT", 0, 0, 0, "balanced"),
(14507, 14507, "Shadow", 0, "", 0, "Monster.shadow", 10, 30, 79, "male", "L2Pet", 40, 7085, 2057, 13.43, 3.09, 40, 43, 30, 21, 20, 25, 0, 0, 1811, 558, 1204, 523, 278, 0, 333, 0, 0, 0, 88, 154, "NULL", 0, 0, 0, "LAST_HIT", 0, 0, 0, "balanced"),
(14508, 14508, "Shadow", 0, "", 0, "Monster.shadow", 10, 30, 79, "male", "L2Pet", 40, 7085, 2057, 13.43, 3.09, 40, 43, 30, 21, 20, 25, 0, 0, 1820, 558, 1216, 523, 278, 0, 333, 0, 0, 0, 88, 154, "NULL", 0, 0, 0, "LAST_HIT", 0, 0, 0, "balanced"),
(14509, 14509, "Shadow", 0, "", 0, "Monster.shadow", 10, 30, 79, "male", "L2Pet", 40, 7085, 2057, 13.43, 3.09, 40, 43, 30, 21, 20, 25, 0, 0, 1828, 558, 1228, 523, 278, 0, 333, 0, 0, 0, 88, 154, "NULL", 0, 0, 0, "LAST_HIT", 0, 0, 0, "balanced"),
(14510, 14510, "Shadow", 0, "", 0, "Monster.shadow", 10, 30, 79, "male", "L2Pet", 40, 7085, 2057, 13.43, 3.09, 40, 43, 30, 21, 20, 25, 0, 0, 1837, 558, 1240, 523, 278, 0, 333, 0, 0, 0, 88, 154, "NULL", 0, 0, 0, "LAST_HIT", 0, 0, 0, "balanced"),
(14511, 14511, "Shadow", 0, "", 0, "Monster.shadow", 10, 30, 79, "male", "L2Pet", 40, 7085, 2057, 13.43, 3.09, 40, 43, 30, 21, 20, 25, 0, 0, 1846, 558, 1253, 523, 278, 0, 333, 0, 0, 0, 88, 154, "NULL", 0, 0, 0, "LAST_HIT", 0, 0, 0, "balanced"),
(14512, 14512, "Shadow", 0, "", 0, "Monster.shadow", 10, 30, 79, "male", "L2Pet", 40, 7085, 2057, 13.43, 3.09, 40, 43, 30, 21, 20, 25, 0, 0, 1854, 558, 1265, 523, 278, 0, 333, 0, 0, 0, 88, 154, "NULL", 0, 0, 0, "LAST_HIT", 0, 0, 0, "balanced"),
(14513, 14513, "Shadow", 0, "", 0, "Monster.shadow", 10, 30, 79, "male", "L2Pet", 40, 7085, 2057, 13.43, 3.09, 40, 43, 30, 21, 20, 25, 0, 0, 1863, 558, 1277, 523, 278, 0, 333, 0, 0, 0, 88, 154, "NULL", 0, 0, 0, "LAST_HIT", 0, 0, 0, "balanced"),
(14514, 14514, "Shadow", 0, "", 0, "Monster.shadow", 10, 30, 79, "male", "L2Pet", 40, 7085, 2057, 13.43, 3.09, 40, 43, 30, 21, 20, 25, 0, 0, 1871, 558, 1289, 523, 278, 0, 333, 0, 0, 0, 88, 154, "NULL", 0, 0, 0, "LAST_HIT", 0, 0, 0, "balanced"),
(14515, 14515, "Shadow", 0, "", 0, "Monster.shadow", 10, 30, 80, "male", "L2Pet", 40, 7085, 2057, 13.43, 3.09, 40, 43, 30, 21, 20, 25, 0, 0, 1891, 562, 1317, 526, 278, 0, 333, 0, 0, 0, 88, 154, "NULL", 0, 0, 0, "LAST_HIT", 0, 0, 0, "balanced"),
(14516, 14516, "Shadow", 0, "", 0, "Monster.shadow", 10, 30, 80, "male", "L2Pet", 40, 7085, 2057, 13.43, 3.09, 40, 43, 30, 21, 20, 25, 0, 0, 1900, 562, 1329, 526, 278, 0, 333, 0, 0, 0, 88, 154, "NULL", 0, 0, 0, "LAST_HIT", 0, 0, 0, "balanced"),
(14517, 14517, "Shadow", 0, "", 0, "Monster.shadow", 10, 30, 80, "male", "L2Pet", 40, 7085, 2057, 13.43, 3.09, 40, 43, 30, 21, 20, 25, 0, 0, 1909, 562, 1342, 526, 278, 0, 333, 0, 0, 0, 88, 154, "NULL", 0, 0, 0, "LAST_HIT", 0, 0, 0, "balanced"),
(14518, 14518, "Shadow", 0, "", 0, "Monster.shadow", 10, 30, 80, "male", "L2Pet", 40, 7085, 2057, 13.43, 3.09, 40, 43, 30, 21, 20, 25, 0, 0, 1917, 562, 1354, 526, 278, 0, 333, 0, 0, 0, 88, 154, "NULL", 0, 0, 0, "LAST_HIT", 0, 0, 0, "balanced"),
(14519, 14519, "Shadow", 0, "", 0, "Monster.shadow", 10, 30, 80, "male", "L2Pet", 40, 7085, 2057, 13.43, 3.09, 40, 43, 30, 21, 20, 25, 0, 0, 1926, 562, 1366, 526, 278, 0, 333, 0, 0, 0, 88, 154, "NULL", 0, 0, 0, "LAST_HIT", 0, 0, 0, "balanced"),
(14520, 14520, "Shadow", 0, "", 0, "Monster.shadow", 10, 30, 80, "male", "L2Pet", 40, 7085, 2057, 13.43, 3.09, 40, 43, 30, 21, 20, 25, 0, 0, 1935, 562, 1379, 526, 278, 0, 333, 0, 0, 0, 88, 154, "NULL", 0, 0, 0, "LAST_HIT", 0, 0, 0, "balanced"),
(14521, 14521, "Shadow", 0, "", 0, "Monster.shadow", 10, 30, 80, "male", "L2Pet", 40, 7085, 2057, 13.43, 3.09, 40, 43, 30, 21, 20, 25, 0, 0, 1943, 562, 1391, 526, 278, 0, 333, 0, 0, 0, 88, 154, "NULL", 0, 0, 0, "LAST_HIT", 0, 0, 0, "balanced"),
(14522, 14522, "Shadow", 0, "", 0, "Monster.shadow", 10, 30, 80, "male", "L2Pet", 40, 7085, 2057, 13.43, 3.09, 40, 43, 30, 21, 20, 25, 0, 0, 1952, 562, 1403, 526, 278, 0, 333, 0, 0, 0, 88, 154, "NULL", 0, 0, 0, "LAST_HIT", 0, 0, 0, "balanced"),
(14523, 14523, "Shadow", 0, "", 0, "Monster.shadow", 10, 30, 80, "male", "L2Pet", 40, 7085, 2057, 13.43, 3.09, 40, 43, 30, 21, 20, 25, 0, 0, 1961, 562, 1416, 526, 278, 0, 333, 0, 0, 0, 88, 154, "NULL", 0, 0, 0, "LAST_HIT", 0, 0, 0, "balanced"),
(14524, 14524, "Shadow", 0, "", 0, "Monster.shadow", 10, 30, 80, "male", "L2Pet", 40, 7085, 2057, 13.43, 3.09, 40, 43, 30, 21, 20, 25, 0, 0, 1969, 562, 1428, 526, 278, 0, 333, 0, 0, 0, 88, 154, "NULL", 0, 0, 0, "LAST_HIT", 0, 0, 0, "balanced"),
(14525, 14525, "Shadow", 0, "", 0, "Monster.shadow", 10, 30, 80, "male", "L2Pet", 40, 7085, 2057, 13.43, 3.09, 40, 43, 30, 21, 20, 25, 0, 0, 1978, 562, 1440, 526, 278, 0, 333, 0, 0, 0, 88, 154, "NULL", 0, 0, 0, "LAST_HIT", 0, 0, 0, "balanced"),
(14526, 14526, "Shadow", 0, "", 0, "Monster.shadow", 10, 30, 80, "male", "L2Pet", 40, 7085, 2057, 13.43, 3.09, 40, 43, 30, 21, 20, 25, 0, 0, 1987, 562, 1453, 526, 278, 0, 333, 0, 0, 0, 88, 154, "NULL", 0, 0, 0, "LAST_HIT", 0, 0, 0, "balanced"),
(14527, 14527, "Silhouette", 0, "", 0, "Monster.silhouette", 8, 23, 27, "female", "L2Pet", 40, 1302, 367, 5.53, 1.53, 40, 43, 30, 21, 20, 25, 0, 0, 104, 125, 45, 117, 278, 0, 333, 0, 0, 0, 88, 154, "NULL", 0, 0, 0, "LAST_HIT", 0, 0, 0, "fighter"),
(14528, 14528, "Silhouette", 0, "", 0, "Monster.silhouette", 8, 23, 37, "female", "L2Pet", 40, 2142, 553, 7.11, 1.84, 40, 43, 30, 21, 20, 25, 0, 0, 222, 182, 104, 170, 278, 0, 333, 0, 0, 0, 88, 154, "NULL", 0, 0, 0, "LAST_HIT", 0, 0, 0, "fighter"),
(14529, 14529, "Silhouette", 0, "", 0, "Monster.silhouette", 8, 23, 47, "female", "L2Pet", 40, 3227, 851, 8.69, 2.14, 40, 43, 30, 21, 20, 25, 0, 0, 427, 253, 216, 237, 278, 0, 333, 0, 0, 0, 88, 154, "NULL", 0, 0, 0, "LAST_HIT", 0, 0, 0, "fighter"),
(14530, 14530, "Silhouette", 0, "", 0, "Monster.silhouette", 8, 23, 54, "female", "L2Pet", 40, 4099, 1102, 10.27, 2.45, 40, 43, 30, 21, 20, 25, 0, 0, 636, 313, 339, 293, 278, 0, 333, 0, 0, 0, 88, 154, "NULL", 0, 0, 0, "LAST_HIT", 0, 0, 0, "fighter"),
(14531, 14531, "Silhouette", 0, "", 0, "Monster.silhouette", 8, 23, 22, "female", "L2Pet", 40, 978, 279, 5.53, 1.53, 40, 43, 30, 21, 20, 25, 0, 0, 68, 102, 28, 96, 278, 0, 333, 0, 0, 0, 88, 154, "NULL", 0, 0, 0, "LAST_HIT", 0, 0, 0, "fighter"),
(14532, 14532, "Silhouette", 0, "", 0, "Monster.silhouette", 8, 23, 32, "female", "L2Pet", 40, 1689, 458, 7.11, 1.84, 40, 43, 30, 21, 20, 25, 0, 0, 154, 151, 69, 142, 278, 0, 333, 0, 0, 0, 88, 154, "NULL", 0, 0, 0, "LAST_HIT", 0, 0, 0, "fighter"),
(14533, 14533, "Silhouette", 0, "", 0, "Monster.silhouette", 8, 23, 42, "female", "L2Pet", 40, 2656, 679, 8.69, 2.14, 40, 43, 30, 21, 20, 25, 0, 0, 311, 215, 152, 202, 278, 0, 333, 0, 0, 0, 88, 154, "NULL", 0, 0, 0, "LAST_HIT", 0, 0, 0, "fighter"),
(14534, 14534, "Silhouette", 0, "", 0, "Monster.silhouette", 8, 23, 50, "female", "L2Pet", 40, 3592, 957, 8.69, 2.14, 40, 43, 30, 21, 20, 25, 0, 0, 509, 278, 264, 260, 278, 0, 333, 0, 0, 0, 88, 154, "NULL", 0, 0, 0, "LAST_HIT", 0, 0, 0, "fighter"),
(14535, 14535, "Silhouette", 0, "", 0, "Monster.silhouette", 8, 23, 58, "female", "L2Pet", 40, 4622, 1251, 10.27, 2.45, 40, 43, 30, 21, 20, 25, 0, 0, 781, 349, 428, 327, 278, 0, 333, 0, 0, 0, 88, 154, "NULL", 0, 0, 0, "LAST_HIT", 0, 0, 0, "fighter"),
(14536, 14536, "Silhouette", 0, "", 0, "Monster.silhouette", 8, 23, 60, "female", "L2Pet", 40, 4887, 1327, 10.27, 2.45, 40, 43, 30, 21, 20, 25, 0, 0, 860, 368, 478, 345, 278, 0, 333, 0, 0, 0, 88, 154, "NULL", 0, 0, 0, "LAST_HIT", 0, 0, 0, "fighter"),
(14537, 14537, "Silhouette", 0, "", 0, "Monster.silhouette", 8, 23, 62, "female", "L2Pet", 40, 5151, 1404, 11.85, 2.78, 40, 43, 30, 21, 20, 25, 0, 0, 944, 388, 532, 363, 278, 0, 333, 0, 0, 0, 88, 154, "NULL", 0, 0, 0, "LAST_HIT", 0, 0, 0, "fighter"),
(14538, 14538, "Silhouette", 0, "", 0, "Monster.silhouette", 8, 23, 64, "female", "L2Pet", 40, 5414, 1482, 11.85, 2.78, 40, 43, 30, 21, 20, 25, 0, 0, 1031, 408, 589, 382, 278, 0, 333, 0, 0, 0, 88, 154, "NULL", 0, 0, 0, "LAST_HIT", 0, 0, 0, "fighter"),
(14539, 14539, "Silhouette", 0, "", 0, "Monster.silhouette", 8, 23, 66, "female", "L2Pet", 40, 5674, 1561, 11.85, 2.78, 40, 43, 30, 21, 20, 25, 0, 0, 1123, 428, 649, 401, 278, 0, 333, 0, 0, 0, 88, 154, "NULL", 0, 0, 0, "LAST_HIT", 0, 0, 0, "fighter"),
(14540, 14540, "Silhouette", 0, "", 0, "Monster.silhouette", 8, 23, 68, "female", "L2Pet", 40, 5930, 1641, 11.85, 2.78, 40, 43, 30, 21, 20, 25, 0, 0, 1217, 449, 713, 421, 278, 0, 333, 0, 0, 0, 88, 154, "NULL", 0, 0, 0, "LAST_HIT", 0, 0, 0, "fighter"),
(14541, 14541, "Silhouette", 0, "", 0, "Monster.silhouette", 8, 23, 70, "female", "L2Pet", 40, 6179, 1722, 11.85, 2.78, 40, 43, 30, 21, 20, 25, 0, 0, 1314, 470, 780, 440, 278, 0, 333, 0, 0, 0, 88, 154, "NULL", 0, 0, 0, "LAST_HIT", 0, 0, 0, "fighter"),
(14542, 14542, "Silhouette", 0, "", 0, "Monster.silhouette", 8, 23, 72, "female", "L2Pet", 40, 6421, 1804, 13.43, 3.09, 40, 43, 30, 21, 20, 25, 0, 0, 1413, 491, 849, 460, 278, 0, 333, 0, 0, 0, 88, 154, "NULL", 0, 0, 0, "LAST_HIT", 0, 0, 0, "fighter"),
(14543, 14543, "Silhouette", 0, "", 0, "Monster.silhouette", 8, 23, 74, "female", "L2Pet", 40, 6654, 1888, 13.43, 3.09, 40, 43, 30, 21, 20, 25, 0, 0, 1513, 512, 921, 480, 278, 0, 333, 0, 0, 0, 88, 154, "NULL", 0, 0, 0, "LAST_HIT", 0, 0, 0, "fighter"),
(14544, 14544, "Silhouette", 0, "", 0, "Monster.silhouette", 8, 23, 76, "female", "L2Pet", 40, 6876, 1972, 13.43, 3.09, 40, 43, 30, 21, 20, 25, 0, 0, 1614, 534, 994, 500, 278, 0, 333, 0, 0, 0, 88, 154, "NULL", 0, 0, 0, "LAST_HIT", 0, 0, 0, "fighter"),
(14545, 14545, "Silhouette", 0, "", 0, "Monster.silhouette", 8, 23, 78, "female", "L2Pet", 40, 7085, 2057, 13.43, 3.09, 40, 43, 30, 21, 20, 25, 0, 0, 1715, 555, 1069, 520, 278, 0, 333, 0, 0, 0, 88, 154, "NULL", 0, 0, 0, "LAST_HIT", 0, 0, 0, "fighter"),
(14546, 14546, "Silhouette", 0, "", 0, "Monster.silhouette", 8, 23, 78, "female", "L2Pet", 40, 7085, 2057, 13.43, 3.09, 40, 43, 30, 21, 20, 25, 0, 0, 1723, 555, 1081, 520, 278, 0, 333, 0, 0, 0, 88, 154, "NULL", 0, 0, 0, "LAST_HIT", 0, 0, 0, "fighter"),
(14547, 14547, "Silhouette", 0, "", 0, "Monster.silhouette", 8, 23, 78, "female", "L2Pet", 40, 7085, 2057, 13.43, 3.09, 40, 43, 30, 21, 20, 25, 0, 0, 1732, 555, 1093, 520, 278, 0, 333, 0, 0, 0, 88, 154, "NULL", 0, 0, 0, "LAST_HIT", 0, 0, 0, "fighter"),
(14548, 14548, "Silhouette", 0, "", 0, "Monster.silhouette", 8, 23, 78, "female", "L2Pet", 40, 7085, 2057, 13.43, 3.09, 40, 43, 30, 21, 20, 25, 0, 0, 1740, 555, 1105, 520, 278, 0, 333, 0, 0, 0, 88, 154, "NULL", 0, 0, 0, "LAST_HIT", 0, 0, 0, "fighter"),
(14549, 14549, "Silhouette", 0, "", 0, "Monster.silhouette", 8, 23, 78, "female", "L2Pet", 40, 7085, 2057, 13.43, 3.09, 40, 43, 30, 21, 20, 25, 0, 0, 1749, 555, 1117, 520, 278, 0, 333, 0, 0, 0, 88, 154, "NULL", 0, 0, 0, "LAST_HIT", 0, 0, 0, "fighter"),
(14550, 14550, "Silhouette", 0, "", 0, "Monster.silhouette", 8, 23, 78, "female", "L2Pet", 40, 7085, 2057, 13.43, 3.09, 40, 43, 30, 21, 20, 25, 0, 0, 1757, 555, 1129, 520, 278, 0, 333, 0, 0, 0, 88, 154, "NULL", 0, 0, 0, "LAST_HIT", 0, 0, 0, "fighter"),
(14551, 14551, "Silhouette", 0, "", 0, "Monster.silhouette", 8, 23, 78, "female", "L2Pet", 40, 7085, 2057, 13.43, 3.09, 40, 43, 30, 21, 20, 25, 0, 0, 1766, 555, 1141, 520, 278, 0, 333, 0, 0, 0, 88, 154, "NULL", 0, 0, 0, "LAST_HIT", 0, 0, 0, "fighter"),
(14552, 14552, "Silhouette", 0, "", 0, "Monster.silhouette", 8, 23, 78, "female", "L2Pet", 40, 7085, 2057, 13.43, 3.09, 40, 43, 30, 21, 20, 25, 0, 0, 1775, 555, 1153, 520, 278, 0, 333, 0, 0, 0, 88, 154, "NULL", 0, 0, 0, "LAST_HIT", 0, 0, 0, "fighter"),
(14553, 14553, "Silhouette", 0, "", 0, "Monster.silhouette", 8, 23, 78, "female", "L2Pet", 40, 7085, 2057, 13.43, 3.09, 40, 43, 30, 21, 20, 25, 0, 0, 1783, 555, 1165, 520, 278, 0, 333, 0, 0, 0, 88, 154, "NULL", 0, 0, 0, "LAST_HIT", 0, 0, 0, "balanced"),
(14554, 14554, "Silhouette", 0, "", 0, "Monster.silhouette", 8, 23, 79, "female", "L2Pet", 40, 7085, 2057, 13.43, 3.09, 40, 43, 30, 21, 20, 25, 0, 0, 1802, 558, 1192, 523, 278, 0, 333, 0, 0, 0, 88, 154, "NULL", 0, 0, 0, "LAST_HIT", 0, 0, 0, "balanced"),
(14555, 14555, "Silhouette", 0, "", 0, "Monster.silhouette", 8, 23, 79, "female", "L2Pet", 40, 7085, 2057, 13.43, 3.09, 40, 43, 30, 21, 20, 25, 0, 0, 1811, 558, 1204, 523, 278, 0, 333, 0, 0, 0, 88, 154, "NULL", 0, 0, 0, "LAST_HIT", 0, 0, 0, "balanced"),
(14556, 14556, "Silhouette", 0, "", 0, "Monster.silhouette", 8, 23, 79, "female", "L2Pet", 40, 7085, 2057, 13.43, 3.09, 40, 43, 30, 21, 20, 25, 0, 0, 1820, 558, 1216, 523, 278, 0, 333, 0, 0, 0, 88, 154, "NULL", 0, 0, 0, "LAST_HIT", 0, 0, 0, "balanced"),
(14557, 14557, "Silhouette", 0, "", 0, "Monster.silhouette", 8, 23, 79, "female", "L2Pet", 40, 7085, 2057, 13.43, 3.09, 40, 43, 30, 21, 20, 25, 0, 0, 1828, 558, 1228, 523, 278, 0, 333, 0, 0, 0, 88, 154, "NULL", 0, 0, 0, "LAST_HIT", 0, 0, 0, "balanced"),
(14558, 14558, "Silhouette", 0, "", 0, "Monster.silhouette", 8, 23, 79, "female", "L2Pet", 40, 7085, 2057, 13.43, 3.09, 40, 43, 30, 21, 20, 25, 0, 0, 1837, 558, 1240, 523, 278, 0, 333, 0, 0, 0, 88, 154, "NULL", 0, 0, 0, "LAST_HIT", 0, 0, 0, "balanced"),
(14559, 14559, "Silhouette", 0, "", 0, "Monster.silhouette", 8, 23, 79, "female", "L2Pet", 40, 7085, 2057, 13.43, 3.09, 40, 43, 30, 21, 20, 25, 0, 0, 1846, 558, 1253, 523, 278, 0, 333, 0, 0, 0, 88, 154, "NULL", 0, 0, 0, "LAST_HIT", 0, 0, 0, "balanced"),
(14560, 14560, "Silhouette", 0, "", 0, "Monster.silhouette", 8, 23, 79, "female", "L2Pet", 40, 7085, 2057, 13.43, 3.09, 40, 43, 30, 21, 20, 25, 0, 0, 1854, 558, 1265, 523, 278, 0, 333, 0, 0, 0, 88, 154, "NULL", 0, 0, 0, "LAST_HIT", 0, 0, 0, "balanced"),
(14561, 14561, "Silhouette", 0, "", 0, "Monster.silhouette", 8, 23, 79, "female", "L2Pet", 40, 7085, 2057, 13.43, 3.09, 40, 43, 30, 21, 20, 25, 0, 0, 1863, 558, 1277, 523, 278, 0, 333, 0, 0, 0, 88, 154, "NULL", 0, 0, 0, "LAST_HIT", 0, 0, 0, "balanced"),
(14562, 14562, "Silhouette", 0, "", 0, "Monster.silhouette", 8, 23, 79, "female", "L2Pet", 40, 7085, 2057, 13.43, 3.09, 40, 43, 30, 21, 20, 25, 0, 0, 1871, 558, 1289, 523, 278, 0, 333, 0, 0, 0, 88, 154, "NULL", 0, 0, 0, "LAST_HIT", 0, 0, 0, "balanced"),
(14563, 14563, "Silhouette", 0, "", 0, "Monster.silhouette", 8, 23, 80, "female", "L2Pet", 40, 7085, 2057, 13.43, 3.09, 40, 43, 30, 21, 20, 25, 0, 0, 1891, 562, 1317, 526, 278, 0, 333, 0, 0, 0, 88, 154, "NULL", 0, 0, 0, "LAST_HIT", 0, 0, 0, "balanced"),
(14564, 14564, "Silhouette", 0, "", 0, "Monster.silhouette", 8, 23, 80, "female", "L2Pet", 40, 7085, 2057, 13.43, 3.09, 40, 43, 30, 21, 20, 25, 0, 0, 1900, 562, 1329, 526, 278, 0, 333, 0, 0, 0, 88, 154, "NULL", 0, 0, 0, "LAST_HIT", 0, 0, 0, "balanced"),
(14565, 14565, "Silhouette", 0, "", 0, "Monster.silhouette", 8, 23, 80, "female", "L2Pet", 40, 7085, 2057, 13.43, 3.09, 40, 43, 30, 21, 20, 25, 0, 0, 1909, 562, 1342, 526, 278, 0, 333, 0, 0, 0, 88, 154, "NULL", 0, 0, 0, "LAST_HIT", 0, 0, 0, "balanced"),
(14566, 14566, "Silhouette", 0, "", 0, "Monster.silhouette", 8, 23, 80, "female", "L2Pet", 40, 7085, 2057, 13.43, 3.09, 40, 43, 30, 21, 20, 25, 0, 0, 1917, 562, 1354, 526, 278, 0, 333, 0, 0, 0, 88, 154, "NULL", 0, 0, 0, "LAST_HIT", 0, 0, 0, "balanced"),
(14567, 14567, "Silhouette", 0, "", 0, "Monster.silhouette", 8, 23, 80, "female", "L2Pet", 40, 7085, 2057, 13.43, 3.09, 40, 43, 30, 21, 20, 25, 0, 0, 1926, 562, 1366, 526, 278, 0, 333, 0, 0, 0, 88, 154, "NULL", 0, 0, 0, "LAST_HIT", 0, 0, 0, "balanced"),
(14568, 14568, "Silhouette", 0, "", 0, "Monster.silhouette", 8, 23, 80, "female", "L2Pet", 40, 7085, 2057, 13.43, 3.09, 40, 43, 30, 21, 20, 25, 0, 0, 1935, 562, 1379, 526, 278, 0, 333, 0, 0, 0, 88, 154, "NULL", 0, 0, 0, "LAST_HIT", 0, 0, 0, "balanced"),
(14569, 14569, "Silhouette", 0, "", 0, "Monster.silhouette", 8, 23, 80, "female", "L2Pet", 40, 7085, 2057, 13.43, 3.09, 40, 43, 30, 21, 20, 25, 0, 0, 1943, 562, 1391, 526, 278, 0, 333, 0, 0, 0, 88, 154, "NULL", 0, 0, 0, "LAST_HIT", 0, 0, 0, "balanced"),
(14570, 14570, "Silhouette", 0, "", 0, "Monster.silhouette", 8, 23, 80, "female", "L2Pet", 40, 7085, 2057, 13.43, 3.09, 40, 43, 30, 21, 20, 25, 0, 0, 1952, 562, 1403, 526, 278, 0, 333, 0, 0, 0, 88, 154, "NULL", 0, 0, 0, "LAST_HIT", 0, 0, 0, "balanced"),
(14571, 14571, "Silhouette", 0, "", 0, "Monster.silhouette", 8, 23, 80, "female", "L2Pet", 40, 7085, 2057, 13.43, 3.09, 40, 43, 30, 21, 20, 25, 0, 0, 1961, 562, 1416, 526, 278, 0, 333, 0, 0, 0, 88, 154, "NULL", 0, 0, 0, "LAST_HIT", 0, 0, 0, "balanced"),
(14572, 14572, "Silhouette", 0, "", 0, "Monster.silhouette", 8, 23, 80, "female", "L2Pet", 40, 7085, 2057, 13.43, 3.09, 40, 43, 30, 21, 20, 25, 0, 0, 1969, 562, 1428, 526, 278, 0, 333, 0, 0, 0, 88, 154, "NULL", 0, 0, 0, "LAST_HIT", 0, 0, 0, "balanced"),
(14573, 14573, "Silhouette", 0, "", 0, "Monster.silhouette", 8, 23, 80, "female", "L2Pet", 40, 7085, 2057, 13.43, 3.09, 40, 43, 30, 21, 20, 25, 0, 0, 1978, 562, 1440, 526, 278, 0, 333, 0, 0, 0, 88, 154, "NULL", 0, 0, 0, "LAST_HIT", 0, 0, 0, "balanced"),
(14574, 14574, "Silhouette", 0, "", 0, "Monster.silhouette", 8, 23, 80, "female", "L2Pet", 40, 7085, 2057, 13.43, 3.09, 40, 43, 30, 21, 20, 25, 0, 0, 1987, 562, 1453, 526, 278, 0, 333, 0, 0, 0, 88, 154, "NULL", 0, 0, 0, "LAST_HIT", 0, 0, 0, "balanced"),
(14575, 14575, "Soulless", 0, "", 0, "Monster.shadeless", 7, 28, 42, "male", "L2Pet", 40, 1992, 679, 8.69, 2.14, 40, 43, 30, 21, 20, 25, 0, 0, 342, 215, 152, 202, 278, 0, 333, 0, 0, 0, 52, 209, "NULL", 0, 0, 0, "LAST_HIT", 0, 0, 0, "fighter"),
(14576, 14576, "Soulless", 0, "", 0, "Monster.shadeless", 7, 28, 46, "male", "L2Pet", 40, 2331, 816, 8.69, 2.14, 40, 43, 30, 21, 20, 25, 0, 0, 442, 245, 202, 230, 278, 0, 333, 0, 0, 0, 52, 209, "NULL", 0, 0, 0, "LAST_HIT", 0, 0, 0, "fighter"),
(14577, 14577, "Soulless", 0, "", 0, "Monster.shadeless", 7, 28, 50, "male", "L2Pet", 40, 2694, 957, 8.69, 2.14, 40, 43, 30, 21, 20, 25, 0, 0, 560, 278, 264, 260, 278, 0, 333, 0, 0, 0, 48, 180, "NULL", 0, 0, 0, "LAST_HIT", 0, 0, 0, "fighter"),
(14578, 14578, "Soulless", 0, "", 0, "Monster.shadeless", 7, 28, 54, "male", "L2Pet", 40, 3074, 1102, 10.27, 2.45, 40, 43, 30, 21, 20, 25, 0, 0, 699, 313, 339, 293, 278, 0, 333, 0, 0, 0, 52, 209, "NULL", 0, 0, 0, "LAST_HIT", 0, 0, 0, "fighter"),
(14579, 14579, "Soulless", 0, "", 0, "Monster.shadeless", 7, 28, 58, "male", "L2Pet", 40, 3467, 1251, 10.27, 2.45, 40, 43, 30, 21, 20, 25, 0, 0, 859, 349, 428, 327, 278, 0, 333, 0, 0, 0, 52, 209, "NULL", 0, 0, 0, "LAST_HIT", 0, 0, 0, "fighter"),
(14580, 14580, "Soulless", 0, "", 0, "Monster.shadeless", 7, 28, 60, "male", "L2Pet", 40, 3665, 1327, 10.27, 2.45, 40, 43, 30, 21, 20, 25, 0, 0, 946, 368, 478, 345, 278, 0, 333, 0, 0, 0, 52, 209, "NULL", 0, 0, 0, "LAST_HIT", 0, 0, 0, "fighter"),
(14581, 14581, "Soulless", 0, "", 0, "Monster.shadeless", 7, 28, 62, "male", "L2Pet", 40, 3863, 1404, 11.85, 2.78, 40, 43, 30, 21, 20, 25, 0, 0, 1038, 388, 532, 363, 278, 0, 333, 0, 0, 0, 52, 209, "NULL", 0, 0, 0, "LAST_HIT", 0, 0, 0, "fighter"),
(14582, 14582, "Soulless", 0, "", 0, "Monster.shadeless", 7, 28, 64, "male", "L2Pet", 40, 4060, 1482, 11.85, 2.78, 40, 43, 30, 21, 20, 25, 0, 0, 1135, 408, 589, 382, 278, 0, 333, 0, 0, 0, 52, 209, "NULL", 0, 0, 0, "LAST_HIT", 0, 0, 0, "fighter"),
(14583, 14583, "Soulless", 0, "", 0, "Monster.shadeless", 7, 28, 66, "male", "L2Pet", 40, 4255, 1561, 11.85, 2.78, 40, 43, 30, 21, 20, 25, 0, 0, 1235, 428, 649, 401, 278, 0, 333, 0, 0, 0, 52, 209, "NULL", 0, 0, 0, "LAST_HIT", 0, 0, 0, "fighter"),
(14584, 14584, "Soulless", 0, "", 0, "Monster.shadeless", 7, 28, 68, "male", "L2Pet", 40, 4447, 1641, 11.85, 2.78, 40, 43, 30, 21, 20, 25, 0, 0, 1339, 449, 713, 421, 278, 0, 333, 0, 0, 0, 48, 180, "NULL", 0, 0, 0, "LAST_HIT", 0, 0, 0, "fighter"),
(14585, 14585, "Soulless", 0, "", 0, "Monster.shadeless", 7, 28, 70, "male", "L2Pet", 40, 4634, 1722, 11.85, 2.78, 40, 43, 30, 21, 20, 25, 0, 0, 1445, 470, 780, 440, 278, 0, 333, 0, 0, 0, 52, 209, "NULL", 0, 0, 0, "LAST_HIT", 0, 0, 0, "fighter"),
(14586, 14586, "Soulless", 0, "", 0, "Monster.shadeless", 7, 28, 72, "male", "L2Pet", 40, 4816, 1804, 13.43, 3.09, 40, 43, 30, 21, 20, 25, 0, 0, 1554, 491, 849, 460, 278, 0, 333, 0, 0, 0, 52, 209, "NULL", 0, 0, 0, "LAST_HIT", 0, 0, 0, "fighter"),
(14587, 14587, "Soulless", 0, "", 0, "Monster.shadeless", 7, 28, 74, "male", "L2Pet", 40, 4990, 1888, 13.43, 3.09, 40, 43, 30, 21, 20, 25, 0, 0, 1664, 512, 921, 480, 278, 0, 333, 0, 0, 0, 52, 209, "NULL", 0, 0, 0, "LAST_HIT", 0, 0, 0, "fighter"),
(14588, 14588, "Soulless", 0, "", 0, "Monster.shadeless", 7, 28, 76, "male", "L2Pet", 40, 5157, 1972, 8.69, 2.14, 40, 43, 30, 21, 20, 25, 0, 0, 1775, 534, 994, 510, 278, 0, 333, 0, 0, 0, 52, 198, "NULL", 0, 0, 0, "LAST_HIT", 0, 0, 0, "fighter"),
(14589, 14589, "Soulless", 0, "", 0, "Monster.shadeless", 7, 28, 78, "male", "L2Pet", 40, 5314, 2057, 13.43, 3.09, 40, 43, 30, 21, 20, 25, 0, 0, 1886, 555, 1069, 520, 278, 0, 333, 0, 0, 0, 48, 180, "NULL", 0, 0, 0, "LAST_HIT", 0, 0, 0, "fighter"),
(14590, 14590, "Soulless", 0, "", 0, "Monster.shadeless", 7, 28, 78, "male", "L2Pet", 40, 5314, 2057, 13.43, 3.09, 40, 43, 30, 21, 20, 25, 0, 0, 1895, 555, 1081, 520, 278, 0, 333, 0, 0, 0, 52, 209, "NULL", 0, 0, 0, "LAST_HIT", 0, 0, 0, "fighter"),
(14591, 14591, "Soulless", 0, "", 0, "Monster.shadeless", 7, 28, 78, "male", "L2Pet", 40, 5314, 2057, 13.43, 3.09, 40, 43, 30, 21, 20, 25, 0, 0, 1905, 555, 1093, 520, 278, 0, 333, 0, 0, 0, 52, 209, "NULL", 0, 0, 0, "LAST_HIT", 0, 0, 0, "fighter"),
(14592, 14592, "Soulless", 0, "", 0, "Monster.shadeless", 7, 28, 78, "male", "L2Pet", 40, 5314, 2057, 13.43, 3.09, 40, 43, 30, 21, 20, 25, 0, 0, 1914, 555, 1105, 520, 278, 0, 333, 0, 0, 0, 52, 209, "NULL", 0, 0, 0, "LAST_HIT", 0, 0, 0, "fighter"),
(14593, 14593, "Soulless", 0, "", 0, "Monster.shadeless", 7, 28, 78, "male", "L2Pet", 40, 5314, 2057, 13.43, 3.09, 40, 43, 30, 21, 20, 25, 0, 0, 1924, 555, 1117, 520, 278, 0, 333, 0, 0, 0, 52, 209, "NULL", 0, 0, 0, "LAST_HIT", 0, 0, 0, "fighter"),
(14594, 14594, "Soulless", 0, "", 0, "Monster.shadeless", 7, 28, 78, "male", "L2Pet", 40, 5314, 2057, 13.43, 3.09, 40, 43, 30, 21, 20, 25, 0, 0, 1933, 555, 1129, 520, 278, 0, 333, 0, 0, 0, 52, 209, "NULL", 0, 0, 0, "LAST_HIT", 0, 0, 0, "fighter"),
(14595, 14595, "Soulless", 0, "", 0, "Monster.shadeless", 7, 28, 78, "male", "L2Pet", 40, 5314, 2057, 13.43, 3.09, 40, 43, 30, 21, 20, 25, 0, 0, 1943, 555, 1141, 520, 278, 0, 333, 0, 0, 0, 52, 209, "NULL", 0, 0, 0, "LAST_HIT", 0, 0, 0, "fighter"),
(14596, 14596, "Soulless", 0, "", 0, "Monster.shadeless", 7, 28, 78, "male", "L2Pet", 40, 5314, 2057, 13.43, 3.09, 40, 43, 30, 21, 20, 25, 0, 0, 1952, 555, 1153, 520, 278, 0, 333, 0, 0, 0, 52, 209, "NULL", 0, 0, 0, "LAST_HIT", 0, 0, 0, "fighter"),
(14597, 14597, "Soulless", 0, "", 0, "Monster.shadeless", 7, 28, 78, "male", "L2Pet", 40, 5314, 2057, 13.43, 3.09, 40, 43, 30, 21, 20, 25, 0, 0, 1962, 555, 1165, 520, 278, 0, 333, 0, 0, 0, 52, 209, "NULL", 0, 0, 0, "LAST_HIT", 0, 0, 0, "fighter"),
(14598, 14598, "Soulless", 0, "", 0, "Monster.shadeless", 7, 28, 79, "male", "L2Pet", 40, 5314, 2057, 13.43, 3.09, 40, 43, 30, 21, 20, 25, 0, 0, 1983, 558, 1192, 523, 278, 0, 333, 0, 0, 0, 52, 209, "NULL", 0, 0, 0, "LAST_HIT", 0, 0, 0, "fighter"),
(14599, 14599, "Soulless", 0, "", 0, "Monster.shadeless", 7, 28, 79, "male", "L2Pet", 40, 5314, 2057, 13.43, 3.09, 40, 43, 30, 21, 20, 25, 0, 0, 1992, 558, 1204, 523, 278, 0, 333, 0, 0, 0, 52, 209, "NULL", 0, 0, 0, "LAST_HIT", 0, 0, 0, "fighter"),
(14600, 14600, "Soulless", 0, "", 0, "Monster.shadeless", 7, 28, 79, "male", "L2Pet", 40, 5314, 2057, 13.43, 3.09, 40, 43, 30, 21, 20, 25, 0, 0, 2002, 558, 1216, 523, 278, 0, 333, 0, 0, 0, 52, 209, "NULL", 0, 0, 0, "LAST_HIT", 0, 0, 0, "fighter"),
(14601, 14601, "Soulless", 0, "", 0, "Monster.shadeless", 7, 28, 79, "male", "L2Pet", 40, 5314, 2057, 13.43, 3.09, 40, 43, 30, 21, 20, 25, 0, 0, 2011, 558, 1228, 523, 278, 0, 333, 0, 0, 0, 52, 209, "NULL", 0, 0, 0, "LAST_HIT", 0, 0, 0, "fighter"),
(14602, 14602, "Soulless", 0, "", 0, "Monster.shadeless", 7, 28, 79, "male", "L2Pet", 40, 5314, 2057, 13.43, 3.09, 40, 43, 30, 21, 20, 25, 0, 0, 2021, 558, 1240, 523, 278, 0, 333, 0, 0, 0, 52, 209, "NULL", 0, 0, 0, "LAST_HIT", 0, 0, 0, "fighter"),
(14603, 14603, "Soulless", 0, "", 0, "Monster.shadeless", 7, 28, 79, "male", "L2Pet", 40, 5314, 2057, 13.43, 3.09, 40, 43, 30, 21, 20, 25, 0, 0, 2030, 558, 1253, 523, 278, 0, 333, 0, 0, 0, 52, 209, "NULL", 0, 0, 0, "LAST_HIT", 0, 0, 0, "fighter"),
(14604, 14604, "Soulless", 0, "", 0, "Monster.shadeless", 7, 28, 79, "male", "L2Pet", 40, 5314, 2057, 13.43, 3.09, 40, 43, 30, 21, 20, 25, 0, 0, 2040, 558, 1265, 523, 278, 0, 333, 0, 0, 0, 52, 209, "NULL", 0, 0, 0, "LAST_HIT", 0, 0, 0, "fighter"),
(14605, 14605, "Soulless", 0, "", 0, "Monster.shadeless", 7, 28, 79, "male", "L2Pet", 40, 5314, 2057, 13.43, 3.09, 40, 43, 30, 21, 20, 25, 0, 0, 2049, 558, 1277, 523, 278, 0, 333, 0, 0, 0, 52, 209, "NULL", 0, 0, 0, "LAST_HIT", 0, 0, 0, "fighter"),
(14606, 14606, "Soulless", 0, "", 0, "Monster.shadeless", 7, 28, 79, "male", "L2Pet", 40, 5314, 2057, 13.43, 3.09, 40, 43, 30, 21, 20, 25, 0, 0, 2059, 558, 1289, 523, 278, 0, 333, 0, 0, 0, 52, 209, "NULL", 0, 0, 0, "LAST_HIT", 0, 0, 0, "fighter"),
(14607, 14607, "Soulless", 0, "", 0, "Monster.shadeless", 7, 28, 80, "male", "L2Pet", 40, 5314, 2057, 13.43, 3.09, 40, 43, 30, 21, 20, 25, 0, 0, 2080, 562, 1317, 526, 278, 0, 333, 0, 0, 0, 52, 209, "NULL", 0, 0, 0, "LAST_HIT", 0, 0, 0, "fighter"),
(14608, 14608, "Soulless", 0, "", 0, "Monster.shadeless", 7, 28, 80, "male", "L2Pet", 40, 5314, 2057, 13.43, 3.09, 40, 43, 30, 21, 20, 25, 0, 0, 2090, 562, 1329, 526, 278, 0, 333, 0, 0, 0, 52, 209, "NULL", 0, 0, 0, "LAST_HIT", 0, 0, 0, "fighter"),
(14609, 14609, "Soulless", 0, "", 0, "Monster.shadeless", 7, 28, 80, "male", "L2Pet", 40, 5314, 2057, 13.43, 3.09, 40, 43, 30, 21, 20, 25, 0, 0, 2100, 562, 1342, 526, 278, 0, 333, 0, 0, 0, 52, 209, "NULL", 0, 0, 0, "LAST_HIT", 0, 0, 0, "fighter"),
(14610, 14610, "Soulless", 0, "", 0, "Monster.shadeless", 7, 28, 80, "male", "L2Pet", 40, 5314, 2057, 13.43, 3.09, 40, 43, 30, 21, 20, 25, 0, 0, 2109, 562, 1354, 526, 278, 0, 333, 0, 0, 0, 52, 209, "NULL", 0, 0, 0, "LAST_HIT", 0, 0, 0, "fighter"),
(14611, 14611, "Soulless", 0, "", 0, "Monster.shadeless", 7, 28, 80, "male", "L2Pet", 40, 5314, 2057, 13.43, 3.09, 40, 43, 30, 21, 20, 25, 0, 0, 2119, 562, 1366, 526, 278, 0, 333, 0, 0, 0, 52, 209, "NULL", 0, 0, 0, "LAST_HIT", 0, 0, 0, "fighter"),
(14612, 14612, "Soulless", 0, "", 0, "Monster.shadeless", 7, 28, 80, "male", "L2Pet", 40, 5314, 2057, 13.43, 3.09, 40, 43, 30, 21, 20, 25, 0, 0, 2128, 562, 1379, 526, 278, 0, 333, 0, 0, 0, 52, 209, "NULL", 0, 0, 0, "LAST_HIT", 0, 0, 0, "fighter"),
(14613, 14613, "Soulless", 0, "", 0, "Monster.shadeless", 7, 28, 80, "male", "L2Pet", 40, 5314, 2057, 13.43, 3.09, 40, 43, 30, 21, 20, 25, 0, 0, 2138, 562, 1391, 526, 278, 0, 333, 0, 0, 0, 52, 209, "NULL", 0, 0, 0, "LAST_HIT", 0, 0, 0, "balanced"),
(14614, 14614, "Soulless", 0, "", 0, "Monster.shadeless", 7, 28, 80, "male", "L2Pet", 40, 5314, 2057, 13.43, 3.09, 40, 43, 30, 21, 20, 25, 0, 0, 2147, 562, 1403, 526, 278, 0, 333, 0, 0, 0, 52, 209, "NULL", 0, 0, 0, "LAST_HIT", 0, 0, 0, "balanced"),
(14615, 14615, "Soulless", 0, "", 0, "Monster.shadeless", 7, 28, 80, "male", "L2Pet", 40, 5314, 2057, 13.43, 3.09, 40, 43, 30, 21, 20, 25, 0, 0, 2157, 562, 1416, 526, 278, 0, 333, 0, 0, 0, 52, 209, "NULL", 0, 0, 0, "LAST_HIT", 0, 0, 0, "balanced"),
(14616, 14616, "Soulless", 0, "", 0, "Monster.shadeless", 7, 28, 80, "male", "L2Pet", 40, 5314, 2057, 13.43, 3.09, 40, 43, 30, 21, 20, 25, 0, 0, 2166, 562, 1428, 526, 278, 0, 333, 0, 0, 0, 52, 209, "NULL", 0, 0, 0, "LAST_HIT", 0, 0, 0, "balanced"),
(14617, 14617, "Soulless", 0, "", 0, "Monster.shadeless", 7, 28, 80, "male", "L2Pet", 40, 5314, 2057, 13.43, 3.09, 40, 43, 30, 21, 20, 25, 0, 0, 2176, 562, 1440, 526, 278, 0, 333, 0, 0, 0, 52, 209, "NULL", 0, 0, 0, "LAST_HIT", 0, 0, 0, "balanced"),
(14618, 14618, "Soulless", 0, "", 0, "Monster.shadeless", 7, 28, 80, "male", "L2Pet", 40, 5314, 2057, 13.43, 3.09, 40, 43, 30, 21, 20, 25, 0, 0, 2185, 562, 1453, 526, 278, 0, 333, 0, 0, 0, 52, 209, "NULL", 0, 0, 0, "LAST_HIT", 0, 0, 0, "balanced"),
(14619, 14619, "Nightshade", 0, "", 0, "Monster2.knight_of_shadow", 10, 35.5, 58, "male", "L2Pet", 40, 5778, 1251, 8.69, 2.45, 40, 43, 30, 21, 20, 25, 0, 0, 313, 349, 428, 327, 278, 0, 333, 0, 0, 0, 33, 187, "NULL", 0, 0, 0, "LAST_HIT", 0, 0, 0, "balanced"),
(14620, 14620, "Nightshade", 0, "", 0, "Monster2.knight_of_shadow", 10, 35.5, 60, "male", "L2Pet", 40, 6109, 1327, 8.69, 2.45, 40, 43, 30, 21, 20, 25, 0, 0, 340, 368, 478, 345, 278, 0, 333, 0, 0, 0, 33, 187, "NULL", 0, 0, 0, "LAST_HIT", 0, 0, 0, "balanced"),
(14621, 14621, "Nightshade", 0, "", 0, "Monster2.knight_of_shadow", 10, 35.5, 62, "male", "L2Pet", 40, 6439, 1404, 8.69, 2.78, 40, 43, 30, 21, 20, 25, 0, 0, 368, 388, 532, 363, 278, 0, 333, 0, 0, 0, 33, 187, "NULL", 0, 0, 0, "LAST_HIT", 0, 0, 0, "balanced"),
(14622, 14622, "Nightshade", 0, "", 0, "Monster2.knight_of_shadow", 10, 35.5, 64, "male", "L2Pet", 40, 6768, 1482, 10.27, 2.78, 40, 43, 30, 21, 20, 25, 0, 0, 397, 408, 589, 382, 278, 0, 333, 0, 0, 0, 33, 187, "NULL", 0, 0, 0, "LAST_HIT", 0, 0, 0, "balanced"),
(14623, 14623, "Nightshade", 0, "", 0, "Monster2.knight_of_shadow", 10, 35.5, 66, "male", "L2Pet", 40, 7093, 1561, 10.27, 2.78, 40, 43, 30, 21, 20, 25, 0, 0, 427, 428, 649, 401, 278, 0, 333, 0, 0, 0, 33, 187, "NULL", 0, 0, 0, "LAST_HIT", 0, 0, 0, "balanced"),
(14624, 14624, "Nightshade", 0, "", 0, "Monster2.knight_of_shadow", 10, 35.5, 68, "male", "L2Pet", 40, 7412, 1641, 10.27, 2.78, 40, 43, 30, 21, 20, 25, 0, 0, 457, 449, 713, 421, 278, 0, 333, 0, 0, 0, 33, 187, "NULL", 0, 0, 0, "LAST_HIT", 0, 0, 0, "balanced"),
(14625, 14625, "Nightshade", 0, "", 0, "Monster2.knight_of_shadow", 10, 35.5, 70, "male", "L2Pet", 40, 7724, 1722, 11.85, 2.78, 40, 43, 30, 21, 20, 25, 0, 0, 487, 470, 780, 440, 278, 0, 333, 0, 0, 0, 33, 187, "NULL", 0, 0, 0, "LAST_HIT", 0, 0, 0, "balanced"),
(14626, 14626, "Nightshade", 0, "", 0, "Monster2.knight_of_shadow", 10, 35.5, 72, "male", "L2Pet", 40, 8026, 1804, 11.85, 3.09, 40, 43, 30, 21, 20, 25, 0, 0, 517, 491, 849, 460, 278, 0, 333, 0, 0, 0, 33, 187, "NULL", 0, 0, 0, "LAST_HIT", 0, 0, 0, "balanced"),
(14627, 14627, "Nightshade", 0, "", 0, "Monster2.knight_of_shadow", 10, 35.5, 74, "male", "L2Pet", 40, 8317, 1888, 11.85, 3.09, 40, 43, 30, 21, 20, 25, 0, 0, 547, 512, 921, 480, 278, 0, 333, 0, 0, 0, 33, 187, "NULL", 0, 0, 0, "LAST_HIT", 0, 0, 0, "balanced"),
(14628, 14628, "Nightshade", 0, "", 0, "Monster2.knight_of_shadow", 10, 35.5, 76, "male", "L2Pet", 40, 8595, 1972, 11.85, 3.09, 40, 43, 30, 21, 20, 25, 0, 0, 577, 534, 994, 500, 278, 0, 333, 0, 0, 0, 33, 187, "NULL", 0, 0, 0, "LAST_HIT", 0, 0, 0, "balanced"),
(14633, 14633, "Nightshade", 0, "", 0, "Monster2.knight_of_shadow", 10, 35.5, 78, "male", "L2Pet", 40, 8857, 2143, 13.43, 3.09, 40, 43, 30, 21, 20, 25, 0, 0, 595, 555, 1069, 520, 278, 0, 333, 0, 0, 0, 33, 187, "NULL", 0, 0, 0, "LAST_HIT", 0, 0, 0, "balanced"),
(14634, 14634, "Nightshade", 0, "", 0, "Monster2.knight_of_shadow", 10, 35.5, 78, "male", "L2Pet", 40, 8857, 2143, 13.43, 3.09, 40, 43, 30, 21, 20, 25, 0, 0, 595, 555, 1069, 520, 278, 0, 333, 0, 0, 0, 33, 187, "NULL", 0, 0, 0, "LAST_HIT", 0, 0, 0, "balanced"),
(14635, 14635, "Nightshade", 0, "", 0, "Monster2.knight_of_shadow", 10, 35.5, 78, "male", "L2Pet", 40, 8857, 2143, 13.43, 3.09, 40, 43, 30, 21, 20, 25, 0, 0, 595, 555, 1069, 520, 278, 0, 333, 0, 0, 0, 33, 187, "NULL", 0, 0, 0, "LAST_HIT", 0, 0, 0, "balanced"),
(14636, 14636, "Nightshade", 0, "", 0, "Monster2.knight_of_shadow", 10, 35.5, 78, "male", "L2Pet", 40, 8857, 2143, 13.43, 3.09, 40, 43, 30, 21, 20, 25, 0, 0, 595, 555, 1069, 520, 278, 0, 333, 0, 0, 0, 33, 187, "NULL", 0, 0, 0, "LAST_HIT", 0, 0, 0, "balanced"),
(14637, 14637, "Nightshade", 0, "", 0, "Monster2.knight_of_shadow", 10, 35.5, 78, "male", "L2Pet", 40, 8857, 2143, 13.43, 3.09, 40, 43, 30, 21, 20, 25, 0, 0, 595, 555, 1069, 520, 278, 0, 333, 0, 0, 0, 33, 187, "NULL", 0, 0, 0, "LAST_HIT", 0, 0, 0, "balanced"),
(14638, 14638, "Nightshade", 0, "", 0, "Monster2.knight_of_shadow", 10, 35.5, 78, "male", "L2Pet", 40, 8857, 2143, 13.43, 3.09, 40, 43, 30, 21, 20, 25, 0, 0, 595, 555, 1069, 520, 278, 0, 333, 0, 0, 0, 33, 187, "NULL", 0, 0, 0, "LAST_HIT", 0, 0, 0, "balanced"),
(14639, 14639, "Nightshade", 0, "", 0, "Monster2.knight_of_shadow", 10, 35.5, 78, "male", "L2Pet", 40, 8857, 2143, 13.43, 3.09, 40, 43, 30, 21, 20, 25, 0, 0, 595, 555, 1069, 520, 278, 0, 333, 0, 0, 0, 33, 187, "NULL", 0, 0, 0, "LAST_HIT", 0, 0, 0, "balanced"),
(14640, 14640, "Nightshade", 0, "", 0, "Monster2.knight_of_shadow", 10, 35.5, 78, "male", "L2Pet", 40, 8857, 2143, 13.43, 3.09, 40, 43, 30, 21, 20, 25, 0, 0, 595, 555, 1069, 520, 278, 0, 333, 0, 0, 0, 33, 187, "NULL", 0, 0, 0, "LAST_HIT", 0, 0, 0, "balanced"),
(14641, 14641, "Nightshade", 0, "", 0, "Monster2.knight_of_shadow", 10, 35.5, 78, "male", "L2Pet", 40, 8857, 2143, 13.43, 3.09, 40, 43, 30, 21, 20, 25, 0, 0, 595, 555, 1069, 520, 278, 0, 333, 0, 0, 0, 33, 187, "NULL", 0, 0, 0, "LAST_HIT", 0, 0, 0, "balanced"),
(14642, 14642, "Nightshade", 0, "", 0, "Monster2.knight_of_shadow", 10, 35.5, 79, "male", "L2Pet", 40, 8981, 2143, 13.43, 3.09, 40, 43, 30, 21, 20, 25, 0, 0, 598, 558, 1082, 523, 278, 0, 333, 0, 0, 0, 33, 187, "NULL", 0, 0, 0, "LAST_HIT", 0, 0, 0, "balanced"),
(14643, 14643, "Nightshade", 0, "", 0, "Monster2.knight_of_shadow", 10, 35.5, 79, "male", "L2Pet", 40, 8981, 2143, 13.43, 3.09, 40, 43, 30, 21, 20, 25, 0, 0, 598, 558, 1082, 523, 278, 0, 333, 0, 0, 0, 33, 187, "NULL", 0, 0, 0, "LAST_HIT", 0, 0, 0, "balanced"),
(14644, 14644, "Nightshade", 0, "", 0, "Monster2.knight_of_shadow", 10, 35.5, 79, "male", "L2Pet", 40, 8981, 2143, 13.43, 3.09, 40, 43, 30, 21, 20, 25, 0, 0, 598, 558, 1082, 523, 278, 0, 333, 0, 0, 0, 33, 187, "NULL", 0, 0, 0, "LAST_HIT", 0, 0, 0, "balanced"),
(14645, 14645, "Nightshade", 0, "", 0, "Monster2.knight_of_shadow", 10, 35.5, 79, "male", "L2Pet", 40, 8981, 2143, 13.43, 3.09, 40, 43, 30, 21, 20, 25, 0, 0, 598, 558, 1082, 523, 278, 0, 333, 0, 0, 0, 33, 187, "NULL", 0, 0, 0, "LAST_HIT", 0, 0, 0, "balanced"),
(14646, 14646, "Nightshade", 0, "", 0, "Monster2.knight_of_shadow", 10, 35.5, 79, "male", "L2Pet", 40, 8981, 2143, 13.43, 3.09, 40, 43, 30, 21, 20, 25, 0, 0, 598, 558, 1082, 523, 278, 0, 333, 0, 0, 0, 33, 187, "NULL", 0, 0, 0, "LAST_HIT", 0, 0, 0, "balanced"),
(14647, 14647, "Nightshade", 0, "", 0, "Monster2.knight_of_shadow", 10, 35.5, 79, "male", "L2Pet", 40, 8981, 2143, 13.43, 3.09, 40, 43, 30, 21, 20, 25, 0, 0, 598, 558, 1082, 523, 278, 0, 333, 0, 0, 0, 33, 187, "NULL", 0, 0, 0, "LAST_HIT", 0, 0, 0, "balanced"),
(14648, 14648, "Nightshade", 0, "", 0, "Monster2.knight_of_shadow", 10, 35.5, 79, "male", "L2Pet", 40, 8981, 2143, 13.43, 3.09, 40, 43, 30, 21, 20, 25, 0, 0, 598, 558, 1082, 523, 278, 0, 333, 0, 0, 0, 33, 187, "NULL", 0, 0, 0, "LAST_HIT", 0, 0, 0, "balanced"),
(14649, 14649, "Nightshade", 0, "", 0, "Monster2.knight_of_shadow", 10, 35.5, 79, "male", "L2Pet", 40, 8981, 2143, 13.43, 3.09, 40, 43, 30, 21, 20, 25, 0, 0, 598, 558, 1082, 523, 278, 0, 333, 0, 0, 0, 33, 187, "NULL", 0, 0, 0, "LAST_HIT", 0, 0, 0, "balanced"),
(14650, 14650, "Nightshade", 0, "", 0, "Monster2.knight_of_shadow", 10, 35.5, 79, "male", "L2Pet", 40, 8981, 2143, 13.43, 3.09, 40, 43, 30, 21, 20, 25, 0, 0, 598, 558, 1082, 523, 278, 0, 333, 0, 0, 0, 33, 187, "NULL", 0, 0, 0, "LAST_HIT", 0, 0, 0, "balanced"),
(14651, 14651, "Nightshade", 0, "", 0, "Monster2.knight_of_shadow", 10, 35.5, 80, "male", "L2Pet", 40, 9101, 2143, 13.43, 3.09, 40, 43, 30, 21, 20, 25, 0, 0, 602, 562, 1095, 526, 278, 0, 333, 0, 0, 0, 33, 187, "NULL", 0, 0, 0, "LAST_HIT", 0, 0, 0, "balanced"),
(14652, 14652, "Nightshade", 0, "", 0, "Monster2.knight_of_shadow", 10, 35.5, 80, "male", "L2Pet", 40, 9101, 2143, 13.43, 3.09, 40, 43, 30, 21, 20, 25, 0, 0, 602, 562, 1095, 526, 278, 0, 333, 0, 0, 0, 33, 187, "NULL", 0, 0, 0, "LAST_HIT", 0, 0, 0, "balanced"),
(14653, 14653, "Nightshade", 0, "", 0, "Monster2.knight_of_shadow", 10, 35.5, 80, "male", "L2Pet", 40, 9101, 2143, 13.43, 3.09, 40, 43, 30, 21, 20, 25, 0, 0, 602, 562, 1095, 526, 278, 0, 333, 0, 0, 0, 33, 187, "NULL", 0, 0, 0, "LAST_HIT", 0, 0, 0, "balanced"),
(14654, 14654, "Nightshade", 0, "", 0, "Monster2.knight_of_shadow", 10, 35.5, 80, "male", "L2Pet", 40, 9101, 2143, 13.43, 3.09, 40, 43, 30, 21, 20, 25, 0, 0, 602, 562, 1095, 526, 278, 0, 333, 0, 0, 0, 33, 187, "NULL", 0, 0, 0, "LAST_HIT", 0, 0, 0, "balanced"),
(14655, 14655, "Nightshade", 0, "", 0, "Monster2.knight_of_shadow", 10, 35.5, 80, "male", "L2Pet", 40, 9101, 2143, 13.43, 3.09, 40, 43, 30, 21, 20, 25, 0, 0, 602, 562, 1095, 526, 278, 0, 333, 0, 0, 0, 33, 187, "NULL", 0, 0, 0, "LAST_HIT", 0, 0, 0, "balanced"),
(14656, 14656, "Nightshade", 0, "", 0, "Monster2.knight_of_shadow", 10, 35.5, 80, "male", "L2Pet", 40, 9101, 2143, 13.43, 3.09, 40, 43, 30, 21, 20, 25, 0, 0, 602, 562, 1095, 526, 278, 0, 333, 0, 0, 0, 33, 187, "NULL", 0, 0, 0, "LAST_HIT", 0, 0, 0, "balanced"),
(14657, 14657, "Nightshade", 0, "", 0, "Monster2.knight_of_shadow", 10, 35.5, 80, "male", "L2Pet", 40, 9101, 2143, 13.43, 3.09, 40, 43, 30, 21, 20, 25, 0, 0, 602, 562, 1095, 526, 278, 0, 333, 0, 0, 0, 33, 187, "NULL", 0, 0, 0, "LAST_HIT", 0, 0, 0, "balanced"),
(14658, 14658, "Nightshade", 0, "", 0, "Monster2.knight_of_shadow", 10, 35.5, 80, "male", "L2Pet", 40, 9101, 2143, 13.43, 3.09, 40, 43, 30, 21, 20, 25, 0, 0, 602, 562, 1095, 526, 278, 0, 333, 0, 0, 0, 33, 187, "NULL", 0, 0, 0, "LAST_HIT", 0, 0, 0, "balanced"),
(14659, 14659, "Nightshade", 0, "", 0, "Monster2.knight_of_shadow", 10, 35.5, 80, "male", "L2Pet", 40, 9101, 2143, 13.43, 3.09, 40, 43, 30, 21, 20, 25, 0, 0, 602, 562, 1095, 526, 278, 0, 333, 0, 0, 0, 33, 187, "NULL", 0, 0, 0, "LAST_HIT", 0, 0, 0, "balanced"),
(14660, 14660, "Nightshade", 0, "", 0, "Monster2.knight_of_shadow", 10, 35.5, 80, "male", "L2Pet", 40, 9101, 2143, 13.43, 3.09, 40, 43, 30, 21, 20, 25, 0, 0, 602, 562, 1095, 526, 278, 0, 333, 0, 0, 0, 33, 187, "NULL", 0, 0, 0, "LAST_HIT", 0, 0, 0, "balanced"),
(14661, 14661, "Nightshade", 0, "", 0, "Monster2.knight_of_shadow", 10, 35.5, 80, "male", "L2Pet", 40, 9101, 2143, 13.43, 3.09, 40, 43, 30, 21, 20, 25, 0, 0, 602, 562, 1095, 526, 278, 0, 333, 0, 0, 0, 33, 187, "NULL", 0, 0, 0, "LAST_HIT", 0, 0, 0, "balanced"),
(14662, 14662, "Nightshade", 0, "", 0, "Monster2.knight_of_shadow", 10, 35.5, 80, "male", "L2Pet", 40, 9101, 2143, 13.43, 3.09, 40, 43, 30, 21, 20, 25, 0, 0, 602, 562, 1095, 526, 278, 0, 333, 0, 0, 0, 33, 187, "NULL", 0, 0, 0, "LAST_HIT", 0, 0, 0, "balanced"),
(14663, 14663, "Mechanic Golem", 0, "", 0, "Monster.mechanic_golem", 5, 19, 30, "male", "L2Pet", 40, 1049, 421, 5.53, 1.53, 40, 43, 30, 21, 20, 25, 0, 0, 132, 140, 58, 132, 278, 0, 333, 0, 0, 0, 33, 165, "NULL", 0, 0, 0, "LAST_HIT", 0, 0, 0, "fighter"),
(14664, 14664, "Mechanic Golem", 0, "", 0, "Monster.mechanic_golem", 5, 19, 38, "male", "L2Pet", 40, 1540, 573, 7.11, 1.84, 40, 43, 30, 21, 20, 25, 0, 0, 238, 188, 112, 176, 278, 0, 333, 0, 0, 0, 30, 150, "NULL", 0, 0, 0, "LAST_HIT", 0, 0, 0, "fighter"),
(14665, 14665, "Mechanic Golem", 0, "", 0, "Monster.mechanic_golem", 5, 19, 45, "male", "L2Pet", 40, 2057, 781, 8.69, 2.14, 40, 43, 30, 21, 20, 25, 0, 0, 377, 238, 188, 223, 278, 0, 333, 0, 0, 0, 30, 150, "NULL", 0, 0, 0, "LAST_HIT", 0, 0, 0, "fighter"),
(14666, 14666, "Mechanic Golem", 0, "", 0, "Monster.mechanic_golem", 5, 19, 51, "male", "L2Pet", 40, 2555, 993, 10.27, 2.45, 40, 43, 30, 21, 20, 25, 0, 0, 539, 286, 281, 268, 278, 0, 333, 0, 0, 0, 30, 150, "NULL", 0, 0, 0, "LAST_HIT", 0, 0, 0, "fighter"),
(14667, 14667, "Mechanic Golem", 0, "", 0, "Monster.mechanic_golem", 5, 19, 57, "male", "L2Pet", 40, 3087, 1213, 10.27, 2.45, 40, 43, 30, 21, 20, 25, 0, 0, 743, 340, 405, 318, 320, 0, 333, 0, 0, 0, 30, 150, "NULL", 0, 0, 0, "LAST_HIT", 0, 0, 0, "fighter"),
(14668, 14668, "Mechanic Golem", 0, "", 0, "Monster.mechanic_golem", 5, 19, 62, "male", "L2Pet", 40, 3541, 1404, 11.85, 2.78, 40, 43, 30, 21, 20, 25, 0, 0, 944, 388, 532, 363, 278, 0, 333, 0, 0, 0, 30, 150, "NULL", 0, 0, 0, "LAST_HIT", 0, 0, 0, "fighter"),
(14669, 14669, "Mechanic Golem", 0, "", 0, "Monster.mechanic_golem", 5, 19, 66, "male", "L2Pet", 40, 3901, 1561, 11.85, 2.78, 40, 43, 30, 21, 20, 25, 0, 0, 1123, 428, 649, 401, 278, 0, 333, 0, 0, 0, 33, 165, "NULL", 0, 0, 0, "LAST_HIT", 0, 0, 0, "fighter"),
(14670, 14670, "Mechanic Golem", 0, "", 0, "Monster.mechanic_golem", 5, 19, 70, "male", "L2Pet", 40, 4248, 1722, 11.85, 2.78, 40, 43, 30, 21, 20, 25, 0, 0, 1314, 470, 780, 440, 278, 0, 333, 0, 0, 0, 33, 165, "NULL", 0, 0, 0, "LAST_HIT", 0, 0, 0, "fighter"),
(14671, 14671, "Mechanic Golem", 0, "", 0, "Monster.mechanic_golem", 5, 19, 74, "male", "L2Pet", 40, 4574, 1888, 13.43, 3.09, 40, 43, 30, 21, 20, 25, 0, 0, 1513, 512, 921, 480, 278, 0, 333, 0, 0, 0, 30, 150, "NULL", 0, 0, 0, "LAST_HIT", 0, 0, 0, "fighter"),
(14672, 14672, "Mechanic Golem", 0, "", 0, "Monster.mechanic_golem", 5, 19, 78, "male", "L2Pet", 40, 5025, 2143, 13.43, 3.09, 40, 43, 30, 21, 20, 25, 0, 0, 1723, 555, 1069, 520, 278, 0, 333, 0, 0, 0, 30, 150, "NULL", 0, 0, 0, "LAST_HIT", 0, 0, 0, "fighter"),
(14673, 14673, "Mechanic Golem", 0, "", 0, "Monster.mechanic_golem", 5, 19, 78, "male", "L2Pet", 40, 5025, 2143, 13.43, 3.09, 40, 43, 30, 21, 20, 25, 0, 0, 1732, 555, 1069, 520, 278, 0, 333, 0, 0, 0, 33, 165, "NULL", 0, 0, 0, "LAST_HIT", 0, 0, 0, "fighter"),
(14674, 14674, "Mechanic Golem", 0, "", 0, "Monster.mechanic_golem", 5, 19, 78, "male", "L2Pet", 40, 5025, 2143, 13.43, 3.09, 40, 43, 30, 21, 20, 25, 0, 0, 1740, 555, 1069, 520, 278, 0, 333, 0, 0, 0, 33, 165, "NULL", 0, 0, 0, "LAST_HIT", 0, 0, 0, "fighter"),
(14675, 14675, "Mechanic Golem", 0, "", 0, "Monster.mechanic_golem", 5, 19, 78, "male", "L2Pet", 40, 5025, 2143, 13.43, 3.09, 40, 43, 30, 21, 20, 25, 0, 0, 1749, 555, 1069, 520, 278, 0, 333, 0, 0, 0, 33, 165, "NULL", 0, 0, 0, "LAST_HIT", 0, 0, 0, "fighter"),
(14676, 14676, "Mechanic Golem", 0, "", 0, "Monster.mechanic_golem", 5, 19, 78, "male", "L2Pet", 40, 5025, 2143, 13.43, 3.09, 40, 43, 30, 21, 20, 25, 0, 0, 1757, 555, 1069, 520, 278, 0, 333, 0, 0, 0, 33, 165, "NULL", 0, 0, 0, "LAST_HIT", 0, 0, 0, "fighter"),
(14677, 14677, "Mechanic Golem", 0, "", 0, "Monster.mechanic_golem", 5, 19, 78, "male", "L2Pet", 40, 5025, 2143, 13.43, 3.09, 40, 43, 30, 21, 20, 25, 0, 0, 1766, 555, 1069, 520, 278, 0, 333, 0, 0, 0, 33, 165, "NULL", 0, 0, 0, "LAST_HIT", 0, 0, 0, "fighter"),
(14678, 14678, "Mechanic Golem", 0, "", 0, "Monster.mechanic_golem", 5, 19, 78, "male", "L2Pet", 40, 5025, 2143, 13.43, 3.09, 40, 43, 30, 21, 20, 25, 0, 0, 1775, 555, 1069, 520, 278, 0, 333, 0, 0, 0, 33, 165, "NULL", 0, 0, 0, "LAST_HIT", 0, 0, 0, "fighter"),
(14679, 14679, "Mechanic Golem", 0, "", 0, "Monster.mechanic_golem", 5, 19, 78, "male", "L2Pet", 40, 5025, 2143, 13.43, 3.09, 40, 43, 30, 21, 20, 25, 0, 0, 1783, 555, 1069, 520, 278, 0, 333, 0, 0, 0, 33, 165, "NULL", 0, 0, 0, "LAST_HIT", 0, 0, 0, "fighter"),
(14680, 14680, "Mechanic Golem", 0, "", 0, "Monster.mechanic_golem", 5, 19, 78, "male", "L2Pet", 40, 5025, 2143, 13.43, 3.09, 40, 43, 30, 21, 20, 25, 0, 0, 1792, 555, 1069, 520, 278, 0, 333, 0, 0, 0, 33, 165, "NULL", 0, 0, 0, "LAST_HIT", 0, 0, 0, "fighter"),
(14681, 14681, "Mechanic Golem", 0, "", 0, "Monster.mechanic_golem", 5, 19, 79, "male", "L2Pet", 40, 5025, 2143, 13.43, 3.09, 40, 43, 30, 21, 20, 25, 0, 0, 1811, 558, 1082, 523, 278, 0, 333, 0, 0, 0, 33, 165, "NULL", 0, 0, 0, "LAST_HIT", 0, 0, 0, "fighter"),
(14682, 14682, "Mechanic Golem", 0, "", 0, "Monster.mechanic_golem", 5, 19, 79, "male", "L2Pet", 40, 5025, 2143, 13.43, 3.09, 40, 43, 30, 21, 20, 25, 0, 0, 1820, 558, 1082, 523, 278, 0, 333, 0, 0, 0, 33, 165, "NULL", 0, 0, 0, "LAST_HIT", 0, 0, 0, "fighter"),
(14683, 14683, "Mechanic Golem", 0, "", 0, "Monster.mechanic_golem", 5, 19, 79, "male", "L2Pet", 40, 5025, 2143, 13.43, 3.09, 40, 43, 30, 21, 20, 25, 0, 0, 1828, 558, 1082, 523, 278, 0, 333, 0, 0, 0, 33, 165, "NULL", 0, 0, 0, "LAST_HIT", 0, 0, 0, "fighter"),
(14684, 14684, "Mechanic Golem", 0, "", 0, "Monster.mechanic_golem", 5, 19, 79, "male", "L2Pet", 40, 5025, 2143, 13.43, 3.09, 40, 43, 30, 21, 20, 25, 0, 0, 1837, 558, 1082, 523, 278, 0, 333, 0, 0, 0, 33, 165, "NULL", 0, 0, 0, "LAST_HIT", 0, 0, 0, "fighter"),
(14685, 14685, "Mechanic Golem", 0, "", 0, "Monster.mechanic_golem", 5, 19, 79, "male", "L2Pet", 40, 5025, 2143, 13.43, 3.09, 40, 43, 30, 21, 20, 25, 0, 0, 1846, 558, 1082, 523, 278, 0, 333, 0, 0, 0, 33, 165, "NULL", 0, 0, 0, "LAST_HIT", 0, 0, 0, "fighter"),
(14686, 14686, "Mechanic Golem", 0, "", 0, "Monster.mechanic_golem", 5, 19, 79, "male", "L2Pet", 40, 5025, 2143, 13.43, 3.09, 40, 43, 30, 21, 20, 25, 0, 0, 1854, 558, 1082, 523, 278, 0, 333, 0, 0, 0, 33, 165, "NULL", 0, 0, 0, "LAST_HIT", 0, 0, 0, "fighter"),
(14687, 14687, "Mechanic Golem", 0, "", 0, "Monster.mechanic_golem", 5, 19, 79, "male", "L2Pet", 40, 5025, 2143, 13.43, 3.09, 40, 43, 30, 21, 20, 25, 0, 0, 1863, 558, 1082, 523, 278, 0, 333, 0, 0, 0, 33, 165, "NULL", 0, 0, 0, "LAST_HIT", 0, 0, 0, "fighter"),
(14688, 14688, "Mechanic Golem", 0, "", 0, "Monster.mechanic_golem", 5, 19, 79, "male", "L2Pet", 40, 5025, 2143, 13.43, 3.09, 40, 43, 30, 21, 20, 25, 0, 0, 1871, 558, 1082, 523, 278, 0, 333, 0, 0, 0, 33, 165, "NULL", 0, 0, 0, "LAST_HIT", 0, 0, 0, "fighter"),
(14689, 14689, "Mechanic Golem", 0, "", 0, "Monster.mechanic_golem", 5, 19, 79, "male", "L2Pet", 40, 5025, 2143, 13.43, 3.09, 40, 43, 30, 21, 20, 25, 0, 0, 1880, 558, 1082, 523, 278, 0, 333, 0, 0, 0, 33, 165, "NULL", 0, 0, 0, "LAST_HIT", 0, 0, 0, "fighter"),
(14690, 14690, "Mechanic Golem", 0, "", 0, "Monster.mechanic_golem", 5, 19, 80, "male", "L2Pet", 40, 5025, 2143, 13.43, 3.09, 40, 43, 30, 21, 20, 25, 0, 0, 1900, 562, 1095, 526, 278, 0, 333, 0, 0, 0, 33, 165, "NULL", 0, 0, 0, "LAST_HIT", 0, 0, 0, "fighter"),
(14691, 14691, "Mechanic Golem", 0, "", 0, "Monster.mechanic_golem", 5, 19, 80, "male", "L2Pet", 40, 5025, 2143, 13.43, 3.09, 40, 43, 30, 21, 20, 25, 0, 0, 1909, 562, 1095, 526, 278, 0, 333, 0, 0, 0, 33, 165, "NULL", 0, 0, 0, "LAST_HIT", 0, 0, 0, "fighter"),
(14692, 14692, "Mechanic Golem", 0, "", 0, "Monster.mechanic_golem", 5, 19, 80, "male", "L2Pet", 40, 5025, 2143, 13.43, 3.09, 40, 43, 30, 21, 20, 25, 0, 0, 1917, 562, 1095, 526, 278, 0, 333, 0, 0, 0, 33, 165, "NULL", 0, 0, 0, "LAST_HIT", 0, 0, 0, "fighter"),
(14693, 14693, "Mechanic Golem", 0, "", 0, "Monster.mechanic_golem", 5, 19, 80, "male", "L2Pet", 40, 5025, 2143, 13.43, 3.09, 40, 43, 30, 21, 20, 25, 0, 0, 1926, 562, 1095, 526, 278, 0, 333, 0, 0, 0, 33, 165, "NULL", 0, 0, 0, "LAST_HIT", 0, 0, 0, "fighter"),
(14694, 14694, "Mechanic Golem", 0, "", 0, "Monster.mechanic_golem", 5, 19, 80, "male", "L2Pet", 40, 5025, 2143, 13.43, 3.09, 40, 43, 30, 21, 20, 25, 0, 0, 1935, 562, 1095, 526, 278, 0, 333, 0, 0, 0, 33, 165, "NULL", 0, 0, 0, "LAST_HIT", 0, 0, 0, "fighter"),
(14695, 14695, "Mechanic Golem", 0, "", 0, "Monster.mechanic_golem", 5, 19, 80, "male", "L2Pet", 40, 5025, 2143, 13.43, 3.09, 40, 43, 30, 21, 20, 25, 0, 0, 1943, 562, 1095, 526, 278, 0, 333, 0, 0, 0, 33, 165, "NULL", 0, 0, 0, "LAST_HIT", 0, 0, 0, "fighter"),
(14696, 14696, "Mechanic Golem", 0, "", 0, "Monster.mechanic_golem", 5, 19, 80, "male", "L2Pet", 40, 5025, 2143, 13.43, 3.09, 40, 43, 30, 21, 20, 25, 0, 0, 1952, 562, 1095, 526, 278, 0, 333, 0, 0, 0, 33, 165, "NULL", 0, 0, 0, "LAST_HIT", 0, 0, 0, "fighter"),
(14697, 14697, "Mechanic Golem", 0, "", 0, "Monster.mechanic_golem", 5, 19, 80, "male", "L2Pet", 40, 5025, 2143, 13.43, 3.09, 40, 43, 30, 21, 20, 25, 0, 0, 1961, 562, 1095, 526, 278, 0, 333, 0, 0, 0, 33, 165, "NULL", 0, 0, 0, "LAST_HIT", 0, 0, 0, "fighter"),
(14698, 14698, "Mechanic Golem", 0, "", 0, "Monster.mechanic_golem", 5, 19, 80, "male", "L2Pet", 40, 5025, 2143, 13.43, 3.09, 40, 43, 30, 21, 20, 25, 0, 0, 1969, 562, 1095, 526, 278, 0, 333, 0, 0, 0, 33, 165, "NULL", 0, 0, 0, "LAST_HIT", 0, 0, 0, "fighter"),
(14699, 14699, "Mechanic Golem", 0, "", 0, "Monster.mechanic_golem", 5, 19, 80, "male", "L2Pet", 40, 5025, 2143, 13.43, 3.09, 40, 43, 30, 21, 20, 25, 0, 0, 1978, 562, 1095, 526, 278, 0, 333, 0, 0, 0, 33, 165, "NULL", 0, 0, 0, "LAST_HIT", 0, 0, 0, "fighter"),
(14700, 14700, "Mechanic Golem", 0, "", 0, "Monster.mechanic_golem", 5, 19, 80, "male", "L2Pet", 40, 5025, 2143, 13.43, 3.09, 40, 43, 30, 21, 20, 25, 0, 0, 1987, 562, 1095, 526, 278, 0, 333, 0, 0, 0, 33, 165, "NULL", 0, 0, 0, "LAST_HIT", 0, 0, 0, "fighter"),
(14701, 14701, "Mechanic Golem", 0, "", 0, "Monster.mechanic_golem", 5, 19, 80, "male", "L2Pet", 40, 5025, 2143, 13.43, 3.09, 40, 43, 30, 21, 20, 25, 0, 0, 1995, 562, 1095, 526, 278, 0, 333, 0, 0, 0, 33, 165, "NULL", 0, 0, 0, "LAST_HIT", 0, 0, 0, "fighter"),
(14702, 14702, "Big Boom", 0, "", 0, "Monster.big_boom", 6, 13, 60, "male", "L2Pet", 40, 3054, 1327, 10.27, 2.45, 40, 43, 30, 21, 20, 25, 0, 0, 860, 368, 478, 345, 278, 0, 333, 0, 0, 0, 52, 154, "NULL", 0, 0, 0, "LAST_HIT", 0, 0, 0, "fighter"),
(14703, 14703, "Big Boom", 0, "", 0, "Monster.big_boom", 6, 13, 64, "male", "L2Pet", 40, 3054, 1327, 10.27, 2.45, 40, 43, 30, 21, 20, 25, 0, 0, 860, 368, 478, 345, 278, 0, 333, 0, 0, 0, 48, 140, "NULL", 0, 0, 0, "LAST_HIT", 0, 0, 0, "fighter"),
(14704, 14704, "Big Boom", 0, "", 0, "Monster.big_boom", 6, 13, 68, "male", "L2Pet", 40, 3384, 1482, 11.85, 2.78, 40, 43, 30, 21, 20, 25, 0, 0, 1031, 408, 589, 382, 278, 0, 333, 0, 0, 0, 52, 154, "NULL", 0, 0, 0, "LAST_HIT", 0, 0, 0, "fighter"),
(14705, 14705, "Big Boom", 0, "", 0, "Monster.big_boom", 6, 13, 72, "male", "L2Pet", 40, 3706, 1641, 11.85, 2.78, 40, 43, 30, 21, 20, 25, 0, 0, 1217, 449, 713, 421, 278, 0, 333, 0, 0, 0, 52, 154, "NULL", 0, 0, 0, "LAST_HIT", 0, 0, 0, "fighter"),
(14706, 14706, "Big Boom", 0, "", 0, "Monster.big_boom", 6, 13, 76, "male", "L2Pet", 40, 4013, 1804, 13.43, 3.09, 40, 43, 30, 21, 20, 25, 0, 0, 1413, 491, 849, 460, 278, 0, 333, 0, 0, 0, 52, 154, "NULL", 0, 0, 0, "LAST_HIT", 0, 0, 0, "fighter"),
(14707, 14707, "Big Boom", 0, "", 0, "Monster.big_boom", 6, 13, 78, "male", "L2Pet", 40, 4550, 2143, 13.43, 3.09, 40, 43, 30, 21, 20, 25, 0, 0, 1793, 553, 1118, 533, 278, 0, 333, 0, 0, 0, 52, 154, "NULL", 0, 0, 0, "LAST_HIT", 0, 0, 0, "fighter"),
(14708, 14708, "Big Boom", 0, "", 0, "Monster.big_boom", 6, 13, 78, "male", "L2Pet", 40, 4550, 2143, 13.43, 3.09, 40, 43, 30, 21, 20, 25, 0, 0, 1793, 553, 1118, 533, 278, 0, 333, 0, 0, 0, 52, 154, "NULL", 0, 0, 0, "LAST_HIT", 0, 0, 0, "fighter"),
(14709, 14709, "Big Boom", 0, "", 0, "Monster.big_boom", 6, 13, 78, "male", "L2Pet", 40, 4550, 2143, 13.43, 3.09, 40, 43, 30, 21, 20, 25, 0, 0, 1793, 553, 1118, 533, 278, 0, 333, 0, 0, 0, 52, 154, "NULL", 0, 0, 0, "LAST_HIT", 0, 0, 0, "fighter"),
(14710, 14710, "Big Boom", 0, "", 0, "Monster.big_boom", 6, 13, 78, "male", "L2Pet", 40, 4550, 2143, 13.43, 3.09, 40, 43, 30, 21, 20, 25, 0, 0, 1793, 553, 1118, 533, 278, 0, 333, 0, 0, 0, 52, 154, "NULL", 0, 0, 0, "LAST_HIT", 0, 0, 0, "fighter"),
(14711, 14711, "Big Boom", 0, "", 0, "Monster.big_boom", 6, 13, 78, "male", "L2Pet", 40, 4550, 2143, 13.43, 3.09, 40, 43, 30, 21, 20, 25, 0, 0, 1793, 553, 1118, 533, 278, 0, 333, 0, 0, 0, 52, 154, "NULL", 0, 0, 0, "LAST_HIT", 0, 0, 0, "fighter"),
(14712, 14712, "Big Boom", 0, "", 0, "Monster.big_boom", 6, 13, 78, "male", "L2Pet", 40, 4550, 2143, 13.43, 3.09, 40, 43, 30, 21, 20, 25, 0, 0, 1793, 553, 1118, 533, 278, 0, 333, 0, 0, 0, 52, 154, "NULL", 0, 0, 0, "LAST_HIT", 0, 0, 0, "fighter"),
(14713, 14713, "Big Boom", 0, "", 0, "Monster.big_boom", 6, 13, 78, "male", "L2Pet", 40, 4550, 2143, 13.43, 3.09, 40, 43, 30, 21, 20, 25, 0, 0, 1793, 553, 1118, 533, 278, 0, 333, 0, 0, 0, 52, 154, "NULL", 0, 0, 0, "LAST_HIT", 0, 0, 0, "fighter"),
(14714, 14714, "Big Boom", 0, "", 0, "Monster.big_boom", 6, 13, 78, "male", "L2Pet", 40, 4550, 2143, 13.43, 3.09, 40, 43, 30, 21, 20, 25, 0, 0, 1793, 553, 1118, 533, 278, 0, 333, 0, 0, 0, 52, 154, "NULL", 0, 0, 0, "LAST_HIT", 0, 0, 0, "fighter"),
(14715, 14715, "Big Boom", 0, "", 0, "Monster.big_boom", 6, 13, 78, "male", "L2Pet", 40, 4550, 2143, 13.43, 3.09, 40, 43, 30, 21, 20, 25, 0, 0, 1793, 553, 1118, 533, 278, 0, 333, 0, 0, 0, 52, 154, "NULL", 0, 0, 0, "LAST_HIT", 0, 0, 0, "fighter"),
(14716, 14716, "Big Boom", 0, "", 0, "Monster.big_boom", 6, 13, 79, "male", "L2Pet", 40, 4550, 2143, 13.43, 3.09, 40, 43, 30, 21, 20, 25, 0, 0, 1803, 556, 1131, 537, 278, 0, 333, 0, 0, 0, 52, 154, "NULL", 0, 0, 0, "LAST_HIT", 0, 0, 0, "fighter"),
(14717, 14717, "Big Boom", 0, "", 0, "Monster.big_boom", 6, 13, 79, "male", "L2Pet", 40, 4550, 2143, 13.43, 3.09, 40, 43, 30, 21, 20, 25, 0, 0, 1803, 556, 1131, 537, 278, 0, 333, 0, 0, 0, 52, 154, "NULL", 0, 0, 0, "LAST_HIT", 0, 0, 0, "fighter"),
(14718, 14718, "Big Boom", 0, "", 0, "Monster.big_boom", 6, 13, 79, "male", "L2Pet", 40, 4550, 2143, 13.43, 3.09, 40, 43, 30, 21, 20, 25, 0, 0, 1803, 556, 1131, 537, 278, 0, 333, 0, 0, 0, 52, 154, "NULL", 0, 0, 0, "LAST_HIT", 0, 0, 0, "fighter"),
(14719, 14719, "Big Boom", 0, "", 0, "Monster.big_boom", 6, 13, 79, "male", "L2Pet", 40, 4550, 2143, 13.43, 3.09, 40, 43, 30, 21, 20, 25, 0, 0, 1803, 556, 1131, 537, 278, 0, 333, 0, 0, 0, 52, 154, "NULL", 0, 0, 0, "LAST_HIT", 0, 0, 0, "fighter"),
(14720, 14720, "Big Boom", 0, "", 0, "Monster.big_boom", 6, 13, 79, "male", "L2Pet", 40, 4550, 2143, 13.43, 3.09, 40, 43, 30, 21, 20, 25, 0, 0, 1803, 556, 1131, 537, 278, 0, 333, 0, 0, 0, 52, 154, "NULL", 0, 0, 0, "LAST_HIT", 0, 0, 0, "fighter"),
(14721, 14721, "Big Boom", 0, "", 0, "Monster.big_boom", 6, 13, 79, "male", "L2Pet", 40, 4550, 2143, 13.43, 3.09, 40, 43, 30, 21, 20, 25, 0, 0, 1803, 556, 1131, 537, 278, 0, 333, 0, 0, 0, 52, 154, "NULL", 0, 0, 0, "LAST_HIT", 0, 0, 0, "fighter"),
(14722, 14722, "Big Boom", 0, "", 0, "Monster.big_boom", 6, 13, 79, "male", "L2Pet", 40, 4550, 2143, 13.43, 3.09, 40, 43, 30, 21, 20, 25, 0, 0, 1803, 556, 1131, 537, 278, 0, 333, 0, 0, 0, 52, 154, "NULL", 0, 0, 0, "LAST_HIT", 0, 0, 0, "fighter"),
(14723, 14723, "Big Boom", 0, "", 0, "Monster.big_boom", 6, 13, 79, "male", "L2Pet", 40, 4550, 2143, 13.43, 3.09, 40, 43, 30, 21, 20, 25, 0, 0, 1803, 556, 1131, 537, 278, 0, 333, 0, 0, 0, 52, 154, "NULL", 0, 0, 0, "LAST_HIT", 0, 0, 0, "fighter"),
(14724, 14724, "Big Boom", 0, "", 0, "Monster.big_boom", 6, 13, 79, "male", "L2Pet", 40, 4550, 2143, 13.43, 3.09, 40, 43, 30, 21, 20, 25, 0, 0, 1803, 556, 1131, 537, 278, 0, 333, 0, 0, 0, 52, 154, "NULL", 0, 0, 0, "LAST_HIT", 0, 0, 0, "fighter"),
(14725, 14725, "Big Boom", 0, "", 0, "Monster.big_boom", 6, 13, 80, "male", "L2Pet", 40, 4550, 2143, 13.43, 3.09, 40, 43, 30, 21, 20, 25, 0, 0, 1814, 559, 1144, 540, 278, 0, 333, 0, 0, 0, 52, 154, "NULL", 0, 0, 0, "LAST_HIT", 0, 0, 0, "fighter"),
(14726, 14726, "Big Boom", 0, "", 0, "Monster.big_boom", 6, 13, 80, "male", "L2Pet", 40, 4550, 2143, 13.43, 3.09, 40, 43, 30, 21, 20, 25, 0, 0, 1814, 559, 1144, 540, 278, 0, 333, 0, 0, 0, 52, 154, "NULL", 0, 0, 0, "LAST_HIT", 0, 0, 0, "fighter"),
(14727, 14727, "Big Boom", 0, "", 0, "Monster.big_boom", 6, 13, 80, "male", "L2Pet", 40, 4550, 2143, 13.43, 3.09, 40, 43, 30, 21, 20, 25, 0, 0, 1814, 559, 1144, 540, 278, 0, 333, 0, 0, 0, 52, 154, "NULL", 0, 0, 0, "LAST_HIT", 0, 0, 0, "fighter"),
(14728, 14728, "Big Boom", 0, "", 0, "Monster.big_boom", 6, 13, 80, "male", "L2Pet", 40, 4550, 2143, 13.43, 3.09, 40, 43, 30, 21, 20, 25, 0, 0, 1814, 559, 1144, 540, 278, 0, 333, 0, 0, 0, 52, 154, "NULL", 0, 0, 0, "LAST_HIT", 0, 0, 0, "fighter"),
(14729, 14729, "Big Boom", 0, "", 0, "Monster.big_boom", 6, 13, 80, "male", "L2Pet", 40, 4550, 2143, 13.43, 3.09, 40, 43, 30, 21, 20, 25, 0, 0, 1814, 559, 1144, 540, 278, 0, 333, 0, 0, 0, 52, 154, "NULL", 0, 0, 0, "LAST_HIT", 0, 0, 0, "fighter"),
(14730, 14730, "Big Boom", 0, "", 0, "Monster.big_boom", 6, 13, 80, "male", "L2Pet", 40, 4550, 2143, 13.43, 3.09, 40, 43, 30, 21, 20, 25, 0, 0, 1814, 559, 1144, 540, 278, 0, 333, 0, 0, 0, 52, 154, "NULL", 0, 0, 0, "LAST_HIT", 0, 0, 0, "fighter"),
(14731, 14731, "Big Boom", 0, "", 0, "Monster.big_boom", 6, 13, 80, "male", "L2Pet", 40, 4550, 2143, 13.43, 3.09, 40, 43, 30, 21, 20, 25, 0, 0, 1814, 559, 1144, 540, 278, 0, 333, 0, 0, 0, 52, 154, "NULL", 0, 0, 0, "LAST_HIT", 0, 0, 0, "fighter"),
(14732, 14732, "Big Boom", 0, "", 0, "Monster.big_boom", 6, 13, 80, "male", "L2Pet", 40, 4550, 2143, 13.43, 3.09, 40, 43, 30, 21, 20, 25, 0, 0, 1814, 559, 1144, 540, 278, 0, 333, 0, 0, 0, 52, 154, "NULL", 0, 0, 0, "LAST_HIT", 0, 0, 0, "fighter"),
(14733, 14733, "Big Boom", 0, "", 0, "Monster.big_boom", 6, 13, 80, "male", "L2Pet", 40, 4550, 2143, 13.43, 3.09, 40, 43, 30, 21, 20, 25, 0, 0, 1814, 559, 1144, 540, 278, 0, 333, 0, 0, 0, 52, 154, "NULL", 0, 0, 0, "LAST_HIT", 0, 0, 0, "fighter"),
(14734, 14734, "Big Boom", 0, "", 0, "Monster.big_boom", 6, 13, 80, "male", "L2Pet", 40, 4550, 2143, 13.43, 3.09, 40, 43, 30, 21, 20, 25, 0, 0, 1814, 559, 1144, 540, 278, 0, 333, 0, 0, 0, 52, 154, "NULL", 0, 0, 0, "LAST_HIT", 0, 0, 0, "fighter"),
(14735, 14735, "Big Boom", 0, "", 0, "Monster.big_boom", 6, 13, 80, "male", "L2Pet", 40, 4550, 2143, 13.43, 3.09, 40, 43, 30, 21, 20, 25, 0, 0, 1814, 559, 1144, 540, 278, 0, 333, 0, 0, 0, 52, 154, "NULL", 0, 0, 0, "LAST_HIT", 0, 0, 0, "fighter"),
(14736, 14736, "Big Boom", 0, "", 0, "Monster.big_boom", 6, 13, 80, "male", "L2Pet", 40, 4550, 2143, 13.43, 3.09, 40, 43, 30, 21, 20, 25, 0, 0, 1814, 559, 1144, 540, 278, 0, 333, 0, 0, 0, 52, 154, "NULL", 0, 0, 0, "LAST_HIT", 0, 0, 0, "fighter"),
(14737, 14737, "Siege Golem", 0, "", 0, "Monster.siege_golem", 60, 140, 55, "male", "L2SiegeSummon", 80, 790000, 1138, 10.27, 2.45, 40, 43, 30, 21, 20, 25, 0, 0, 2592, 1205, 360, 1242, 165, 0, 333, 0, 0, 0, 44, 44, "NULL", 0, 1, 0, "LAST_HIT", 0, 0, 0, "fighter"),
(14738, 14738, "Siege Golem", 0, "", 0, "Monster.siege_golem", 60, 140, 78, "male", "L2SiegeSummon", 80, 790000, 1138, 10.27, 2.45, 40, 43, 30, 21, 20, 25, 0, 0, 3036, 1397, 484, 1440, 165, 0, 333, 0, 0, 0, 44, 44, "NULL", 0, 1, 0, "LAST_HIT", 0, 0, 0, "fighter"),
(14739, 14739, "Siege Golem", 0, "", 0, "Monster.siege_golem", 60, 140, 78, "male", "L2SiegeSummon", 80, 790000, 1138, 10.27, 2.45, 40, 43, 30, 21, 20, 25, 0, 0, 3066, 1397, 484, 1440, 165, 0, 333, 0, 0, 0, 44, 44, "NULL", 0, 1, 0, "LAST_HIT", 0, 0, 0, "fighter"),
(14740, 14740, "Siege Golem", 0, "", 0, "Monster.siege_golem", 60, 140, 78, "male", "L2SiegeSummon", 80, 790000, 1138, 10.27, 2.45, 40, 43, 30, 21, 20, 25, 0, 0, 3096, 1397, 484, 1440, 165, 0, 333, 0, 0, 0, 44, 44, "NULL", 0, 1, 0, "LAST_HIT", 0, 0, 0, "fighter"),
(14741, 14741, "Siege Golem", 0, "", 0, "Monster.siege_golem", 60, 140, 78, "male", "L2SiegeSummon", 80, 790000, 1138, 10.27, 2.45, 40, 43, 30, 21, 20, 25, 0, 0, 3126, 1397, 484, 1440, 165, 0, 333, 0, 0, 0, 44, 44, "NULL", 0, 1, 0, "LAST_HIT", 0, 0, 0, "fighter"),
(14742, 14742, "Siege Golem", 0, "", 0, "Monster.siege_golem", 60, 140, 78, "male", "L2SiegeSummon", 80, 790000, 1138, 10.27, 2.45, 40, 43, 30, 21, 20, 25, 0, 0, 3156, 1397, 484, 1440, 165, 0, 333, 0, 0, 0, 44, 44, "NULL", 0, 1, 0, "LAST_HIT", 0, 0, 0, "fighter"),
(14743, 14743, "Siege Golem", 0, "", 0, "Monster.siege_golem", 60, 140, 78, "male", "L2SiegeSummon", 80, 790000, 1138, 10.27, 2.45, 40, 43, 30, 21, 20, 25, 0, 0, 3186, 1397, 484, 1440, 165, 0, 333, 0, 0, 0, 44, 44, "NULL", 0, 1, 0, "LAST_HIT", 0, 0, 0, "fighter"),
(14744, 14744, "Siege Golem", 0, "", 0, "Monster.siege_golem", 60, 140, 78, "male", "L2SiegeSummon", 80, 790000, 1138, 10.27, 2.45, 40, 43, 30, 21, 20, 25, 0, 0, 3216, 1397, 484, 1440, 165, 0, 333, 0, 0, 0, 44, 44, "NULL", 0, 1, 0, "LAST_HIT", 0, 0, 0, "fighter"),
(14745, 14745, "Siege Golem", 0, "", 0, "Monster.siege_golem", 60, 140, 78, "male", "L2SiegeSummon", 80, 790000, 1138, 10.27, 2.45, 40, 43, 30, 21, 20, 25, 0, 0, 3246, 1397, 484, 1440, 165, 0, 333, 0, 0, 0, 44, 44, "NULL", 0, 1, 0, "LAST_HIT", 0, 0, 0, "fighter"),
(14746, 14746, "Siege Golem", 0, "", 0, "Monster.siege_golem", 60, 140, 78, "male", "L2SiegeSummon", 80, 790000, 1138, 10.27, 2.45, 40, 43, 30, 21, 20, 25, 0, 0, 3276, 1397, 484, 1440, 165, 0, 333, 0, 0, 0, 44, 44, "NULL", 0, 1, 0, "LAST_HIT", 0, 0, 0, "fighter"),
(14747, 14747, "Siege Golem", 0, "", 0, "Monster.siege_golem", 60, 140, 79, "male", "L2SiegeSummon", 80, 790000, 1138, 10.27, 2.45, 40, 43, 30, 21, 20, 25, 0, 0, 3326, 1406, 490, 1449, 165, 0, 333, 0, 0, 0, 44, 44, "NULL", 0, 1, 0, "LAST_HIT", 0, 0, 0, "fighter"),
(14748, 14748, "Siege Golem", 0, "", 0, "Monster.siege_golem", 60, 140, 79, "male", "L2SiegeSummon", 80, 790000, 1138, 10.27, 2.45, 40, 43, 30, 21, 20, 25, 0, 0, 3356, 1406, 490, 1449, 165, 0, 333, 0, 0, 0, 44, 44, "NULL", 0, 1, 0, "LAST_HIT", 0, 0, 0, "fighter"),
(14749, 14749, "Siege Golem", 0, "", 0, "Monster.siege_golem", 60, 140, 79, "male", "L2SiegeSummon", 80, 790000, 1138, 10.27, 2.45, 40, 43, 30, 21, 20, 25, 0, 0, 3386, 1406, 490, 1449, 165, 0, 333, 0, 0, 0, 44, 44, "NULL", 0, 1, 0, "LAST_HIT", 0, 0, 0, "fighter"),
(14750, 14750, "Siege Golem", 0, "", 0, "Monster.siege_golem", 60, 140, 79, "male", "L2SiegeSummon", 80, 790000, 1138, 10.27, 2.45, 40, 43, 30, 21, 20, 25, 0, 0, 3417, 1406, 490, 1449, 165, 0, 333, 0, 0, 0, 44, 44, "NULL", 0, 1, 0, "LAST_HIT", 0, 0, 0, "fighter"),
(14751, 14751, "Siege Golem", 0, "", 0, "Monster.siege_golem", 60, 140, 79, "male", "L2SiegeSummon", 80, 790000, 1138, 10.27, 2.45, 40, 43, 30, 21, 20, 25, 0, 0, 3447, 1406, 490, 1449, 165, 0, 333, 0, 0, 0, 44, 44, "NULL", 0, 1, 0, "LAST_HIT", 0, 0, 0, "fighter"),
(14752, 14752, "Siege Golem", 0, "", 0, "Monster.siege_golem", 60, 140, 79, "male", "L2SiegeSummon", 80, 790000, 1138, 10.27, 2.45, 40, 43, 30, 21, 20, 25, 0, 0, 3477, 1406, 490, 1449, 165, 0, 333, 0, 0, 0, 44, 44, "NULL", 0, 1, 0, "LAST_HIT", 0, 0, 0, "fighter"),
(14753, 14753, "Siege Golem", 0, "", 0, "Monster.siege_golem", 60, 140, 79, "male", "L2SiegeSummon", 80, 790000, 1138, 10.27, 2.45, 40, 43, 30, 21, 20, 25, 0, 0, 3507, 1406, 490, 1449, 165, 0, 333, 0, 0, 0, 44, 44, "NULL", 0, 1, 0, "LAST_HIT", 0, 0, 0, "fighter"),
(14754, 14754, "Siege Golem", 0, "", 0, "Monster.siege_golem", 60, 140, 79, "male", "L2SiegeSummon", 80, 790000, 1138, 10.27, 2.45, 40, 43, 30, 21, 20, 25, 0, 0, 3538, 1406, 490, 1449, 165, 0, 333, 0, 0, 0, 44, 44, "NULL", 0, 1, 0, "LAST_HIT", 0, 0, 0, "fighter"),
(14755, 14755, "Siege Golem", 0, "", 0, "Monster.siege_golem", 60, 140, 79, "male", "L2SiegeSummon", 80, 790000, 1138, 10.27, 2.45, 40, 43, 30, 21, 20, 25, 0, 0, 3568, 1406, 490, 1449, 165, 0, 333, 0, 0, 0, 44, 44, "NULL", 0, 1, 0, "LAST_HIT", 0, 0, 0, "fighter"),
(14756, 14756, "Siege Golem", 0, "", 0, "Monster.siege_golem", 60, 140, 80, "male", "L2SiegeSummon", 80, 790000, 1138, 10.27, 2.45, 40, 43, 30, 21, 20, 25, 0, 0, 3619, 1414, 496, 1457, 165, 0, 333, 0, 0, 0, 44, 44, "NULL", 0, 1, 0, "LAST_HIT", 0, 0, 0, "fighter"),
(14757, 14757, "Siege Golem", 0, "", 0, "Monster.siege_golem", 60, 140, 80, "male", "L2SiegeSummon", 80, 790000, 1138, 10.27, 2.45, 40, 43, 30, 21, 20, 25, 0, 0, 3650, 1414, 496, 1457, 165, 0, 333, 0, 0, 0, 44, 44, "NULL", 0, 1, 0, "LAST_HIT", 0, 0, 0, "fighter"),
(14758, 14758, "Siege Golem", 0, "", 0, "Monster.siege_golem", 60, 140, 80, "male", "L2SiegeSummon", 80, 790000, 1138, 10.27, 2.45, 40, 43, 30, 21, 20, 25, 0, 0, 3680, 1414, 496, 1457, 165, 0, 333, 0, 0, 0, 44, 44, "NULL", 0, 1, 0, "LAST_HIT", 0, 0, 0, "fighter"),
(14759, 14759, "Siege Golem", 0, "", 0, "Monster.siege_golem", 60, 140, 80, "male", "L2SiegeSummon", 80, 790000, 1138, 10.27, 2.45, 40, 43, 30, 21, 20, 25, 0, 0, 3711, 1414, 496, 1457, 165, 0, 333, 0, 0, 0, 44, 44, "NULL", 0, 1, 0, "LAST_HIT", 0, 0, 0, "fighter"),
(14760, 14760, "Siege Golem", 0, "", 0, "Monster.siege_golem", 60, 140, 80, "male", "L2SiegeSummon", 80, 790000, 1138, 10.27, 2.45, 40, 43, 30, 21, 20, 25, 0, 0, 3741, 1414, 496, 1457, 165, 0, 333, 0, 0, 0, 44, 44, "NULL", 0, 1, 0, "LAST_HIT", 0, 0, 0, "fighter"),
(14761, 14761, "Siege Golem", 0, "", 0, "Monster.siege_golem", 60, 140, 80, "male", "L2SiegeSummon", 80, 790000, 1138, 10.27, 2.45, 40, 43, 30, 21, 20, 25, 0, 0, 3772, 1414, 496, 1457, 165, 0, 333, 0, 0, 0, 44, 44, "NULL", 0, 1, 0, "LAST_HIT", 0, 0, 0, "fighter"),
(14762, 14762, "Siege Golem", 0, "", 0, "Monster.siege_golem", 60, 140, 80, "male", "L2SiegeSummon", 80, 790000, 1138, 10.27, 2.45, 40, 43, 30, 21, 20, 25, 0, 0, 3802, 1414, 496, 1457, 165, 0, 333, 0, 0, 0, 44, 44, "NULL", 0, 1, 0, "LAST_HIT", 0, 0, 0, "fighter"),
(14763, 14763, "Siege Golem", 0, "", 0, "Monster.siege_golem", 60, 140, 80, "male", "L2SiegeSummon", 80, 790000, 1138, 10.27, 2.45, 40, 43, 30, 21, 20, 25, 0, 0, 3832, 1414, 496, 1457, 165, 0, 333, 0, 0, 0, 44, 44, "NULL", 0, 1, 0, "LAST_HIT", 0, 0, 0, "fighter"),
(14764, 14764, "Siege Golem", 0, "", 0, "Monster.siege_golem", 60, 140, 80, "male", "L2SiegeSummon", 80, 790000, 1138, 10.27, 2.45, 40, 43, 30, 21, 20, 25, 0, 0, 3863, 1414, 496, 1457, 165, 0, 333, 0, 0, 0, 44, 44, "NULL", 0, 1, 0, "LAST_HIT", 0, 0, 0, "fighter"),
(14765, 14765, "Siege Golem", 0, "", 0, "Monster.siege_golem", 60, 140, 80, "male", "L2SiegeSummon", 80, 790000, 1138, 10.27, 2.45, 40, 43, 30, 21, 20, 25, 0, 0, 3893, 1414, 496, 1457, 165, 0, 333, 0, 0, 0, 44, 44, "NULL", 0, 1, 0, "LAST_HIT", 0, 0, 0, "fighter"),
(14766, 14766, "Siege Golem", 0, "", 0, "Monster.siege_golem", 60, 140, 80, "male", "L2SiegeSummon", 80, 790000, 1138, 10.27, 2.45, 40, 43, 30, 21, 20, 25, 0, 0, 3924, 1414, 496, 1457, 165, 0, 333, 0, 0, 0, 44, 44, "NULL", 0, 1, 0, "LAST_HIT", 0, 0, 0, "fighter"),
(14767, 14767, "Siege Golem", 0, "", 0, "Monster.siege_golem", 60, 140, 80, "male", "L2SiegeSummon", 80, 790000, 1138, 10.27, 2.45, 40, 43, 30, 21, 20, 25, 0, 0, 3954, 1414, 496, 1457, 165, 0, 333, 0, 0, 0, 44, 44, "NULL", 0, 1, 0, "LAST_HIT", 0, 0, 0, "fighter"),
(14768, 14768, "Wild Hog Cannon", 0, "", 0, "Monster.range_golem", 93, 90, 60, "male", "L2SiegeSummon", 40, 3153, 1327, 10.27, 2.45, 40, 43, 30, 21, 20, 25, 0, 0, 888, 709, 478, 730, 278, 0, 333, 0, 0, 0, 11, 11, "NULL", 0, 1, 0, "LAST_HIT", 0, 0, 0, "fighter"),
(14769, 14769, "Wild Hog Cannon", 0, "", 0, "Monster.range_golem", 93, 90, 78, "male", "L2SiegeSummon", 40, 3153, 1327, 10.27, 2.45, 40, 43, 30, 21, 20, 25, 0, 0, 1012, 794, 601, 818, 278, 0, 333, 0, 0, 0, 11, 11, "NULL", 0, 1, 0, "LAST_HIT", 0, 0, 0, "fighter"),
(14770, 14770, "Wild Hog Cannon", 0, "", 0, "Monster.range_golem", 93, 90, 78, "male", "L2SiegeSummon", 40, 3153, 1327, 10.27, 2.45, 40, 43, 30, 21, 20, 25, 0, 0, 1022, 794, 601, 818, 278, 0, 333, 0, 0, 0, 11, 11, "NULL", 0, 1, 0, "LAST_HIT", 0, 0, 0, "fighter"),
(14771, 14771, "Wild Hog Cannon", 0, "", 0, "Monster.range_golem", 93, 90, 78, "male", "L2SiegeSummon", 40, 3153, 1327, 10.27, 2.45, 40, 43, 30, 21, 20, 25, 0, 0, 1032, 794, 601, 818, 278, 0, 333, 0, 0, 0, 11, 11, "NULL", 0, 1, 0, "LAST_HIT", 0, 0, 0, "fighter"),
(14772, 14772, "Wild Hog Cannon", 0, "", 0, "Monster.range_golem", 93, 90, 78, "male", "L2SiegeSummon", 40, 3153, 1327, 10.27, 2.45, 40, 43, 30, 21, 20, 25, 0, 0, 1042, 794, 601, 818, 278, 0, 333, 0, 0, 0, 11, 11, "NULL", 0, 1, 0, "LAST_HIT", 0, 0, 0, "fighter"),
(14773, 14773, "Wild Hog Cannon", 0, "", 0, "Monster.range_golem", 93, 90, 78, "male", "L2SiegeSummon", 40, 3153, 1327, 10.27, 2.45, 40, 43, 30, 21, 20, 25, 0, 0, 1052, 794, 601, 818, 278, 0, 333, 0, 0, 0, 11, 11, "NULL", 0, 1, 0, "LAST_HIT", 0, 0, 0, "fighter"),
(14774, 14774, "Wild Hog Cannon", 0, "", 0, "Monster.range_golem", 93, 90, 78, "male", "L2SiegeSummon", 40, 3153, 1327, 10.27, 2.45, 40, 43, 30, 21, 20, 25, 0, 0, 1062, 794, 601, 818, 278, 0, 333, 0, 0, 0, 11, 11, "NULL", 0, 1, 0, "LAST_HIT", 0, 0, 0, "fighter"),
(14775, 14775, "Wild Hog Cannon", 0, "", 0, "Monster.range_golem", 93, 90, 78, "male", "L2SiegeSummon", 40, 3153, 1327, 10.27, 2.45, 40, 43, 30, 21, 20, 25, 0, 0, 1072, 794, 601, 818, 278, 0, 333, 0, 0, 0, 11, 11, "NULL", 0, 1, 0, "LAST_HIT", 0, 0, 0, "fighter"),
(14776, 14776, "Wild Hog Cannon", 0, "", 0, "Monster.range_golem", 93, 90, 78, "male", "L2SiegeSummon", 40, 3153, 1327, 10.27, 2.45, 40, 43, 30, 21, 20, 25, 0, 0, 1082, 794, 601, 818, 278, 0, 333, 0, 0, 0, 11, 11, "NULL", 0, 1, 0, "LAST_HIT", 0, 0, 0, "fighter"),
(14777, 14777, "Wild Hog Cannon", 0, "", 0, "Monster.range_golem", 93, 90, 78, "male", "L2SiegeSummon", 40, 3153, 1327, 10.27, 2.45, 40, 43, 30, 21, 20, 25, 0, 0, 1092, 794, 601, 818, 278, 0, 333, 0, 0, 0, 11, 11, "NULL", 0, 1, 0, "LAST_HIT", 0, 0, 0, "fighter"),
(14778, 14778, "Wild Hog Cannon", 0, "", 0, "Monster.range_golem", 93, 90, 79, "male", "L2SiegeSummon", 40, 3153, 1327, 10.27, 2.45, 40, 43, 30, 21, 20, 25, 0, 0, 1108, 799, 608, 823, 278, 0, 333, 0, 0, 0, 11, 11, "NULL", 0, 1, 0, "LAST_HIT", 0, 0, 0, "fighter"),
(14779, 14779, "Wild Hog Cannon", 0, "", 0, "Monster.range_golem", 93, 90, 79, "male", "L2SiegeSummon", 40, 3153, 1327, 10.27, 2.45, 40, 43, 30, 21, 20, 25, 0, 0, 1118, 799, 608, 823, 278, 0, 333, 0, 0, 0, 11, 11, "NULL", 0, 1, 0, "LAST_HIT", 0, 0, 0, "fighter"),
(14780, 14780, "Wild Hog Cannon", 0, "", 0, "Monster.range_golem", 93, 90, 79, "male", "L2SiegeSummon", 40, 3153, 1327, 10.27, 2.45, 40, 43, 30, 21, 20, 25, 0, 0, 1128, 799, 608, 823, 278, 0, 333, 0, 0, 0, 11, 11, "NULL", 0, 1, 0, "LAST_HIT", 0, 0, 0, "fighter"),
(14781, 14781, "Wild Hog Cannon", 0, "", 0, "Monster.range_golem", 93, 90, 79, "male", "L2SiegeSummon", 40, 3153, 1327, 10.27, 2.45, 40, 43, 30, 21, 20, 25, 0, 0, 1139, 799, 608, 823, 278, 0, 333, 0, 0, 0, 11, 11, "NULL", 0, 1, 0, "LAST_HIT", 0, 0, 0, "fighter"),
(14782, 14782, "Wild Hog Cannon", 0, "", 0, "Monster.range_golem", 93, 90, 79, "male", "L2SiegeSummon", 40, 3153, 1327, 10.27, 2.45, 40, 43, 30, 21, 20, 25, 0, 0, 1149, 799, 608, 823, 278, 0, 333, 0, 0, 0, 11, 11, "NULL", 0, 1, 0, "LAST_HIT", 0, 0, 0, "fighter"),
(14783, 14783, "Wild Hog Cannon", 0, "", 0, "Monster.range_golem", 93, 90, 79, "male", "L2SiegeSummon", 40, 3153, 1327, 10.27, 2.45, 40, 43, 30, 21, 20, 25, 0, 0, 1159, 799, 608, 823, 278, 0, 333, 0, 0, 0, 11, 11, "NULL", 0, 1, 0, "LAST_HIT", 0, 0, 0, "fighter"),
(14784, 14784, "Wild Hog Cannon", 0, "", 0, "Monster.range_golem", 93, 90, 79, "male", "L2SiegeSummon", 40, 3153, 1327, 10.27, 2.45, 40, 43, 30, 21, 20, 25, 0, 0, 1169, 799, 608, 823, 278, 0, 333, 0, 0, 0, 11, 11, "NULL", 0, 1, 0, "LAST_HIT", 0, 0, 0, "fighter"),
(14785, 14785, "Wild Hog Cannon", 0, "", 0, "Monster.range_golem", 93, 90, 79, "male", "L2SiegeSummon", 40, 3153, 1327, 10.27, 2.45, 40, 43, 30, 21, 20, 25, 0, 0, 1179, 799, 608, 823, 278, 0, 333, 0, 0, 0, 11, 11, "NULL", 0, 1, 0, "LAST_HIT", 0, 0, 0, "fighter"),
(14786, 14786, "Wild Hog Cannon", 0, "", 0, "Monster.range_golem", 93, 90, 79, "male", "L2SiegeSummon", 40, 3153, 1327, 10.27, 2.45, 40, 43, 30, 21, 20, 25, 0, 0, 1189, 799, 608, 823, 278, 0, 333, 0, 0, 0, 11, 11, "NULL", 0, 1, 0, "LAST_HIT", 0, 0, 0, "fighter"),
(14787, 14787, "Wild Hog Cannon", 0, "", 0, "Monster.range_golem", 93, 90, 80, "male", "L2SiegeSummon", 40, 3153, 1327, 10.27, 2.45, 40, 43, 30, 21, 20, 25, 0, 0, 1206, 804, 615, 828, 278, 0, 333, 0, 0, 0, 11, 11, "NULL", 0, 1, 0, "LAST_HIT", 0, 0, 0, "fighter"),
(14788, 14788, "Wild Hog Cannon", 0, "", 0, "Monster.range_golem", 93, 90, 80, "male", "L2SiegeSummon", 40, 3153, 1327, 10.27, 2.45, 40, 43, 30, 21, 20, 25, 0, 0, 1216, 804, 615, 828, 278, 0, 333, 0, 0, 0, 11, 11, "NULL", 0, 1, 0, "LAST_HIT", 0, 0, 0, "fighter"),
(14789, 14789, "Wild Hog Cannon", 0, "", 0, "Monster.range_golem", 93, 90, 80, "male", "L2SiegeSummon", 40, 3153, 1327, 10.27, 2.45, 40, 43, 30, 21, 20, 25, 0, 0, 1226, 804, 615, 828, 278, 0, 333, 0, 0, 0, 11, 11, "NULL", 0, 1, 0, "LAST_HIT", 0, 0, 0, "fighter"),
(14790, 14790, "Wild Hog Cannon", 0, "", 0, "Monster.range_golem", 93, 90, 80, "male", "L2SiegeSummon", 40, 3153, 1327, 10.27, 2.45, 40, 43, 30, 21, 20, 25, 0, 0, 1237, 804, 615, 828, 278, 0, 333, 0, 0, 0, 11, 11, "NULL", 0, 1, 0, "LAST_HIT", 0, 0, 0, "fighter"),
(14791, 14791, "Wild Hog Cannon", 0, "", 0, "Monster.range_golem", 93, 90, 80, "male", "L2SiegeSummon", 40, 3153, 1327, 10.27, 2.45, 40, 43, 30, 21, 20, 25, 0, 0, 1247, 804, 615, 828, 278, 0, 333, 0, 0, 0, 11, 11, "NULL", 0, 1, 0, "LAST_HIT", 0, 0, 0, "fighter"),
(14792, 14792, "Wild Hog Cannon", 0, "", 0, "Monster.range_golem", 93, 90, 80, "male", "L2SiegeSummon", 40, 3153, 1327, 10.27, 2.45, 40, 43, 30, 21, 20, 25, 0, 0, 1257, 804, 615, 828, 278, 0, 333, 0, 0, 0, 11, 11, "NULL", 0, 1, 0, "LAST_HIT", 0, 0, 0, "fighter"),
(14793, 14793, "Wild Hog Cannon", 0, "", 0, "Monster.range_golem", 93, 90, 80, "male", "L2SiegeSummon", 40, 3153, 1327, 10.27, 2.45, 40, 43, 30, 21, 20, 25, 0, 0, 1267, 804, 615, 828, 278, 0, 333, 0, 0, 0, 11, 11, "NULL", 0, 1, 0, "LAST_HIT", 0, 0, 0, "fighter"),
(14794, 14794, "Wild Hog Cannon", 0, "", 0, "Monster.range_golem", 93, 90, 80, "male", "L2SiegeSummon", 40, 3153, 1327, 10.27, 2.45, 40, 43, 30, 21, 20, 25, 0, 0, 1277, 804, 615, 828, 278, 0, 333, 0, 0, 0, 11, 11, "NULL", 0, 1, 0, "LAST_HIT", 0, 0, 0, "fighter"),
(14795, 14795, "Wild Hog Cannon", 0, "", 0, "Monster.range_golem", 93, 90, 80, "male", "L2SiegeSummon", 40, 3153, 1327, 10.27, 2.45, 40, 43, 30, 21, 20, 25, 0, 0, 1287, 804, 615, 828, 278, 0, 333, 0, 0, 0, 11, 11, "NULL", 0, 1, 0, "LAST_HIT", 0, 0, 0, "fighter"),
(14796, 14796, "Wild Hog Cannon", 0, "", 0, "Monster.range_golem", 93, 90, 80, "male", "L2SiegeSummon", 40, 3153, 1327, 10.27, 2.45, 40, 43, 30, 21, 20, 25, 0, 0, 1297, 804, 615, 828, 278, 0, 333, 0, 0, 0, 11, 11, "NULL", 0, 1, 0, "LAST_HIT", 0, 0, 0, "fighter"),
(14797, 14797, "Wild Hog Cannon", 0, "", 0, "Monster.range_golem", 93, 90, 80, "male", "L2SiegeSummon", 40, 3153, 1327, 10.27, 2.45, 40, 43, 30, 21, 20, 25, 0, 0, 1308, 804, 615, 828, 278, 0, 333, 0, 0, 0, 11, 11, "NULL", 0, 1, 0, "LAST_HIT", 0, 0, 0, "fighter"),
(14798, 14798, "Wild Hog Cannon", 0, "", 0, "Monster.range_golem", 93, 90, 80, "male", "L2SiegeSummon", 40, 3153, 1327, 10.27, 2.45, 40, 43, 30, 21, 20, 25, 0, 0, 1318, 804, 615, 828, 278, 0, 333, 0, 0, 0, 11, 11, "NULL", 0, 1, 0, "LAST_HIT", 0, 0, 0, "fighter"),
(14799, 14799, "Dark Panther", 0, "", 0, "Monster.dark_fencer", 7, 13, 42, "male", "L2Pet", 40, 1826, 679, 8.69, 2.14, 40, 43, 30, 21, 20, 25, 0, 0, 311, 215, 152, 202, 278, 0, 333, 0, 0, 0, 25, 150, "NULL", 0, 0, 0, "LAST_HIT", 0, 0, 0, "fighter"),
(14800, 14800, "Dark Panther", 0, "", 0, "Monster.dark_fencer", 7, 13, 51, "male", "L2Pet", 40, 2555, 993, 10.27, 2.45, 40, 43, 30, 21, 20, 25, 0, 0, 539, 286, 281, 268, 278, 0, 333, 0, 0, 0, 25, 150, "NULL", 0, 0, 0, "LAST_HIT", 0, 0, 0, "fighter"),
(14801, 14801, "Dark Panther", 0, "", 0, "Monster.dark_fencer", 7, 13, 60, "male", "L2Pet", 40, 3359, 1327, 10.27, 2.45, 40, 43, 30, 21, 20, 25, 0, 0, 860, 368, 478, 345, 278, 0, 333, 0, 0, 0, 25, 150, "NULL", 0, 0, 0, "LAST_HIT", 0, 0, 0, "fighter"),
(14802, 14802, "Dark Panther", 0, "", 0, "Monster.dark_fencer", 7, 13, 64, "male", "L2Pet", 40, 3722, 1482, 11.85, 2.78, 40, 43, 30, 21, 20, 25, 0, 0, 1031, 408, 589, 382, 278, 0, 333, 0, 0, 0, 27, 165, "NULL", 0, 0, 0, "LAST_HIT", 0, 0, 0, "fighter"),
(14803, 14803, "Dark Panther", 0, "", 0, "Monster.dark_fencer", 7, 13, 68, "male", "L2Pet", 40, 4076, 1641, 11.85, 2.78, 40, 43, 30, 21, 20, 25, 0, 0, 1217, 449, 713, 421, 278, 0, 333, 0, 0, 0, 25, 150, "NULL", 0, 0, 0, "LAST_HIT", 0, 0, 0, "fighter"),
(14804, 14804, "Dark Panther", 0, "", 0, "Monster.dark_fencer", 7, 13, 72, "male", "L2Pet", 40, 4414, 1804, 13.43, 3.09, 40, 43, 30, 21, 20, 25, 0, 0, 1413, 491, 849, 460, 278, 0, 333, 0, 0, 0, 27, 165, "NULL", 0, 0, 0, "LAST_HIT", 0, 0, 0, "fighter"),
(14805, 14805, "Dark Panther", 0, "", 0, "Monster.dark_fencer", 7, 13, 76, "male", "L2Pet", 40, 4727, 1972, 13.43, 3.09, 40, 43, 30, 21, 20, 25, 0, 0, 1614, 534, 994, 500, 278, 0, 333, 0, 0, 0, 25, 150, "NULL", 0, 0, 0, "LAST_HIT", 0, 0, 0, "fighter"),
(14806, 14806, "Dark Panther", 0, "", 0, "Monster.dark_fencer", 7, 13, 78, "male", "L2Pet", 40, 5025, 2143, 13.43, 3.09, 40, 43, 30, 21, 20, 25, 0, 0, 1723, 555, 1069, 520, 278, 0, 333, 0, 0, 0, 25, 150, "NULL", 0, 0, 0, "LAST_HIT", 0, 0, 0, "fighter"),
(14807, 14807, "Dark Panther", 0, "", 0, "Monster.dark_fencer", 7, 13, 78, "male", "L2Pet", 40, 5025, 2143, 13.43, 3.09, 40, 43, 30, 21, 20, 25, 0, 0, 1732, 555, 1069, 520, 278, 0, 333, 0, 0, 0, 27, 165, "NULL", 0, 0, 0, "LAST_HIT", 0, 0, 0, "fighter"),
(14808, 14808, "Dark Panther", 0, "", 0, "Monster.dark_fencer", 7, 13, 78, "male", "L2Pet", 40, 5025, 2143, 13.43, 3.09, 40, 43, 30, 21, 20, 25, 0, 0, 1740, 555, 1069, 520, 278, 0, 333, 0, 0, 0, 27, 165, "NULL", 0, 0, 0, "LAST_HIT", 0, 0, 0, "fighter"),
(14809, 14809, "Dark Panther", 0, "", 0, "Monster.dark_fencer", 7, 13, 78, "male", "L2Pet", 40, 5025, 2143, 13.43, 3.09, 40, 43, 30, 21, 20, 25, 0, 0, 1749, 555, 1069, 520, 278, 0, 333, 0, 0, 0, 27, 165, "NULL", 0, 0, 0, "LAST_HIT", 0, 0, 0, "fighter"),
(14810, 14810, "Dark Panther", 0, "", 0, "Monster.dark_fencer", 7, 13, 78, "male", "L2Pet", 40, 5025, 2143, 13.43, 3.09, 40, 43, 30, 21, 20, 25, 0, 0, 1757, 555, 1069, 520, 278, 0, 333, 0, 0, 0, 27, 165, "NULL", 0, 0, 0, "LAST_HIT", 0, 0, 0, "fighter"),
(14811, 14811, "Dark Panther", 0, "", 0, "Monster.dark_fencer", 7, 13, 78, "male", "L2Pet", 40, 5025, 2143, 13.43, 3.09, 40, 43, 30, 21, 20, 25, 0, 0, 1766, 555, 1069, 520, 370, 0, 333, 0, 0, 0, 25, 150, "NULL", 0, 0, 0, "LAST_HIT", 0, 0, 0, "fighter"),
(14812, 14812, "Dark Panther", 0, "", 0, "Monster.dark_fencer", 7, 13, 78, "male", "L2Pet", 40, 5025, 2143, 13.43, 3.09, 40, 43, 30, 21, 20, 25, 0, 0, 1775, 555, 1069, 520, 278, 0, 333, 0, 0, 0, 27, 165, "NULL", 0, 0, 0, "LAST_HIT", 0, 0, 0, "fighter"),
(14813, 14813, "Dark Panther", 0, "", 0, "Monster.dark_fencer", 7, 13, 78, "male", "L2Pet", 40, 5025, 2143, 13.43, 3.09, 40, 43, 30, 21, 20, 25, 0, 0, 1783, 555, 1069, 520, 278, 0, 333, 0, 0, 0, 27, 165, "NULL", 0, 0, 0, "LAST_HIT", 0, 0, 0, "fighter"),
(14814, 14814, "Dark Panther", 0, "", 0, "Monster.dark_fencer", 7, 13, 78, "male", "L2Pet", 40, 5025, 2143, 13.43, 3.09, 40, 43, 30, 21, 20, 25, 0, 0, 1792, 555, 1069, 520, 278, 0, 333, 0, 0, 0, 25, 150, "NULL", 0, 0, 0, "LAST_HIT", 0, 0, 0, "fighter"),
(14815, 14815, "Dark Panther", 0, "", 0, "Monster.dark_fencer", 7, 13, 79, "male", "L2Pet", 40, 5025, 2143, 13.43, 3.09, 40, 43, 30, 21, 20, 25, 0, 0, 1811, 558, 1082, 523, 278, 0, 333, 0, 0, 0, 25, 150, "NULL", 0, 0, 0, "LAST_HIT", 0, 0, 0, "fighter"),
(14816, 14816, "Dark Panther", 0, "", 0, "Monster.dark_fencer", 7, 13, 79, "male", "L2Pet", 40, 5025, 2143, 13.43, 3.09, 40, 43, 30, 21, 20, 25, 0, 0, 1820, 558, 1082, 523, 278, 0, 333, 0, 0, 0, 27, 165, "NULL", 0, 0, 0, "LAST_HIT", 0, 0, 0, "fighter"),
(14817, 14817, "Dark Panther", 0, "", 0, "Monster.dark_fencer", 7, 13, 79, "male", "L2Pet", 40, 5025, 2143, 13.43, 3.09, 40, 43, 30, 21, 20, 25, 0, 0, 1828, 558, 1082, 523, 278, 0, 333, 0, 0, 0, 27, 165, "NULL", 0, 0, 0, "LAST_HIT", 0, 0, 0, "fighter"),
(14818, 14818, "Dark Panther", 0, "", 0, "Monster.dark_fencer", 7, 13, 79, "male", "L2Pet", 40, 5025, 2143, 13.43, 3.09, 40, 43, 30, 21, 20, 25, 0, 0, 1837, 558, 1082, 523, 278, 0, 333, 0, 0, 0, 27, 165, "NULL", 0, 0, 0, "LAST_HIT", 0, 0, 0, "fighter"),
(14819, 14819, "Dark Panther", 0, "", 0, "Monster.dark_fencer", 7, 13, 79, "male", "L2Pet", 40, 5025, 2143, 13.43, 3.09, 40, 43, 30, 21, 20, 25, 0, 0, 1846, 558, 1082, 523, 278, 0, 333, 0, 0, 0, 27, 165, "NULL", 0, 0, 0, "LAST_HIT", 0, 0, 0, "fighter"),
(14820, 14820, "Dark Panther", 0, "", 0, "Monster.dark_fencer", 7, 13, 79, "male", "L2Pet", 40, 5025, 2143, 13.43, 3.09, 40, 43, 30, 21, 20, 25, 0, 0, 1854, 558, 1082, 523, 278, 0, 333, 0, 0, 0, 27, 165, "NULL", 0, 0, 0, "LAST_HIT", 0, 0, 0, "fighter"),
(14821, 14821, "Dark Panther", 0, "", 0, "Monster.dark_fencer", 7, 13, 79, "male", "L2Pet", 40, 5025, 2143, 13.43, 3.09, 40, 43, 30, 21, 20, 25, 0, 0, 1863, 558, 1082, 523, 278, 0, 333, 0, 0, 0, 27, 165, "NULL", 0, 0, 0, "LAST_HIT", 0, 0, 0, "fighter"),
(14822, 14822, "Dark Panther", 0, "", 0, "Monster.dark_fencer", 7, 13, 79, "male", "L2Pet", 40, 5025, 2143, 13.43, 3.09, 40, 43, 30, 21, 20, 25, 0, 0, 1871, 558, 1082, 523, 278, 0, 333, 0, 0, 0, 27, 165, "NULL", 0, 0, 0, "LAST_HIT", 0, 0, 0, "fighter"),
(14823, 14823, "Dark Panther", 0, "", 0, "Monster.dark_fencer", 7, 13, 79, "male", "L2Pet", 40, 5025, 2143, 13.43, 3.09, 40, 43, 30, 21, 20, 25, 0, 0, 1880, 558, 1082, 523, 278, 0, 333, 0, 0, 0, 27, 165, "NULL", 0, 0, 0, "LAST_HIT", 0, 0, 0, "fighter"),
(14824, 14824, "Dark Panther", 0, "", 0, "Monster.dark_fencer", 7, 13, 80, "male", "L2Pet", 40, 5025, 2143, 13.43, 3.09, 40, 43, 30, 21, 20, 25, 0, 0, 1900, 562, 1095, 526, 278, 0, 333, 0, 0, 0, 27, 165, "NULL", 0, 0, 0, "LAST_HIT", 0, 0, 0, "fighter"),
(14825, 14825, "Dark Panther", 0, "", 0, "Monster.dark_fencer", 7, 13, 80, "male", "L2Pet", 40, 5025, 2143, 13.43, 3.09, 40, 43, 30, 21, 20, 25, 0, 0, 1909, 562, 1095, 526, 278, 0, 333, 0, 0, 0, 27, 165, "NULL", 0, 0, 0, "LAST_HIT", 0, 0, 0, "fighter"),
(14826, 14826, "Dark Panther", 0, "", 0, "Monster.dark_fencer", 7, 13, 80, "male", "L2Pet", 40, 5025, 2143, 13.43, 3.09, 40, 43, 30, 21, 20, 25, 0, 0, 1917, 562, 1095, 526, 278, 0, 333, 0, 0, 0, 27, 165, "NULL", 0, 0, 0, "LAST_HIT", 0, 0, 0, "fighter"),
(14827, 14827, "Dark Panther", 0, "", 0, "Monster.dark_fencer", 7, 13, 80, "male", "L2Pet", 40, 5025, 2143, 13.43, 3.09, 40, 43, 30, 21, 20, 25, 0, 0, 1926, 562, 1095, 526, 278, 0, 333, 0, 0, 0, 27, 165, "NULL", 0, 0, 0, "LAST_HIT", 0, 0, 0, "fighter"),
(14828, 14828, "Dark Panther", 0, "", 0, "Monster.dark_fencer", 7, 13, 80, "male", "L2Pet", 40, 5025, 2143, 13.43, 3.09, 40, 43, 30, 21, 20, 25, 0, 0, 1935, 562, 1095, 526, 278, 0, 333, 0, 0, 0, 27, 165, "NULL", 0, 0, 0, "LAST_HIT", 0, 0, 0, "fighter"),
(14829, 14829, "Dark Panther", 0, "", 0, "Monster.dark_fencer", 7, 13, 80, "male", "L2Pet", 40, 5025, 2143, 13.43, 3.09, 40, 43, 30, 21, 20, 25, 0, 0, 1943, 562, 1095, 526, 278, 0, 333, 0, 0, 0, 27, 165, "NULL", 0, 0, 0, "LAST_HIT", 0, 0, 0, "fighter"),
(14830, 14830, "Dark Panther", 0, "", 0, "Monster.dark_fencer", 7, 13, 80, "male", "L2Pet", 40, 5025, 2143, 13.43, 3.09, 40, 43, 30, 21, 20, 25, 0, 0, 1952, 562, 1095, 526, 278, 0, 333, 0, 0, 0, 27, 165, "NULL", 0, 0, 0, "LAST_HIT", 0, 0, 0, "fighter"),
(14831, 14831, "Dark Panther", 0, "", 0, "Monster.dark_fencer", 7, 13, 80, "male", "L2Pet", 40, 5025, 2143, 13.43, 3.09, 40, 43, 30, 21, 20, 25, 0, 0, 1961, 562, 1095, 526, 278, 0, 333, 0, 0, 0, 27, 165, "NULL", 0, 0, 0, "LAST_HIT", 0, 0, 0, "fighter"),
(14832, 14832, "Dark Panther", 0, "", 0, "Monster.dark_fencer", 7, 13, 80, "male", "L2Pet", 40, 5025, 2143, 13.43, 3.09, 40, 43, 30, 21, 20, 25, 0, 0, 1969, 562, 1095, 526, 278, 0, 333, 0, 0, 0, 27, 165, "NULL", 0, 0, 0, "LAST_HIT", 0, 0, 0, "fighter"),
(14833, 14833, "Dark Panther", 0, "", 0, "Monster.dark_fencer", 7, 13, 80, "male", "L2Pet", 40, 5025, 2143, 13.43, 3.09, 40, 43, 30, 21, 20, 25, 0, 0, 1978, 562, 1095, 526, 278, 0, 333, 0, 0, 0, 27, 165, "NULL", 0, 0, 0, "LAST_HIT", 0, 0, 0, "fighter"),
(14834, 14834, "Dark Panther", 0, "", 0, "Monster.dark_fencer", 7, 13, 80, "male", "L2Pet", 40, 5025, 2143, 13.43, 3.09, 40, 43, 30, 21, 20, 25, 0, 0, 1987, 562, 1095, 526, 278, 0, 333, 0, 0, 0, 27, 165, "NULL", 0, 0, 0, "LAST_HIT", 0, 0, 0, "fighter"),
(14835, 14835, "Dark Panther", 0, "", 0, "Monster.dark_fencer", 7, 13, 80, "male", "L2Pet", 40, 5025, 2143, 13.43, 3.09, 40, 43, 30, 21, 20, 25, 0, 0, 1995, 562, 1095, 526, 278, 0, 333, 0, 0, 0, 27, 165, "NULL", 0, 0, 0, "LAST_HIT", 0, 0, 0, "fighter"),
(14836, 14836, "Feline King", 0, "", 0, "Monster3.king_of_cat", 6, 16.01, 80, "male", "L2Pet", 40, 5461, 2143, 13.43, 3.09, 40, 43, 30, 21, 20, 25, 0, 0, 2606, 795, 1662, 840, 278, 0, 333, 0, 0, 0, 160, 180, "NULL", 0, 0, 0, "LAST_HIT", 0, 0, 0, "fighter"),
(14837, 14837, "Magnus the Unicorn", 0, "", 0, "Monster3.unicorn_magnus", 13.5, 17, 80, "male", "L2Pet", 40, 5461, 2143, 13.43, 3.09, 40, 43, 30, 21, 20, 25, 0, 0, 2369, 795, 3510, 840, 278, 0, 333, 0, 0, 0, 160, 180, "NULL", 0, 0, 0, "LAST_HIT", 0, 0, 0, "balanced"),
(14838, 14838, "Spectral Lord", 0, "", 0, "Monster3.spectral_knight", 12.5, 33.5, 80, "male", "L2Pet", 40, 4550, 2143, 13.43, 3.09, 40, 43, 30, 21, 20, 25, 0, 0, 2647, 437, 1671, 490, 278, 0, 333, 0, 0, 0, 160, 180, "NULL", 0, 0, 0, "LAST_HIT", 0, 0, 0, "fighter"),
(14839, 14839, "Swoop Cannon", 0, "", 0, "Monster3.toad_cannon", 45, 47.5, 68, "male", "L2SiegeSummon", 40, 79000, 1138, 11.85, 2.78, 40, 43, 30, 21, 20, 25, 0, 0, 22, 1314, 428, 1354, 165, 0, 333, 0, 0, 0, 44, 44, "NULL", 0, 0, 0, "LAST_HIT", 0, 0, 0, "balanced"),
(14840, 14840, "Swoop Cannon", 0, "", 0, "Monster3.toad_cannon", 45, 47.5, 69, "male", "L2SiegeSummon", 40, 79000, 1138, 11.85, 2.78, 40, 43, 30, 21, 20, 25, 0, 0, 22, 1314, 428, 1354, 165, 0, 333, 0, 0, 0, 44, 44, "NULL", 0, 0, 0, "LAST_HIT", 0, 0, 0, "balanced"),
(14841, 14841, "Swoop Cannon", 0, "", 0, "Monster3.toad_cannon", 45, 47.5, 70, "male", "L2SiegeSummon", 40, 79000, 1138, 11.85, 2.78, 40, 43, 30, 21, 20, 25, 0, 0, 22, 1314, 428, 1354, 165, 0, 333, 0, 0, 0, 44, 44, "NULL", 0, 0, 0, "LAST_HIT", 0, 0, 0, "balanced"),
(14842, 14842, "Swoop Cannon", 0, "", 0, "Monster3.toad_cannon", 45, 47.5, 71, "male", "L2SiegeSummon", 40, 79000, 1138, 11.85, 2.78, 40, 43, 30, 21, 20, 25, 0, 0, 22, 1314, 428, 1354, 165, 0, 333, 0, 0, 0, 44, 44, "NULL", 0, 0, 0, "LAST_HIT", 0, 0, 0, "balanced"),
(14843, 14843, "Swoop Cannon", 0, "", 0, "Monster3.toad_cannon", 45, 47.5, 72, "male", "L2SiegeSummon", 40, 79000, 1138, 11.85, 2.78, 40, 43, 30, 21, 20, 25, 0, 0, 22, 1314, 428, 1354, 165, 0, 333, 0, 0, 0, 44, 44, "NULL", 0, 0, 0, "LAST_HIT", 0, 0, 0, "balanced"),
(14844, 14844, "Swoop Cannon", 0, "", 0, "Monster3.toad_cannon", 45, 47.5, 73, "male", "L2SiegeSummon", 40, 79000, 1138, 11.85, 2.78, 40, 43, 30, 21, 20, 25, 0, 0, 22, 1314, 428, 1354, 165, 0, 333, 0, 0, 0, 44, 44, "NULL", 0, 0, 0, "LAST_HIT", 0, 0, 0, "balanced"),
(14845, 14845, "Swoop Cannon", 0, "", 0, "Monster3.toad_cannon", 45, 47.5, 74, "male", "L2SiegeSummon", 40, 79000, 1138, 11.85, 2.78, 40, 43, 30, 21, 20, 25, 0, 0, 22, 1314, 428, 1354, 165, 0, 333, 0, 0, 0, 44, 44, "NULL", 0, 0, 0, "LAST_HIT", 0, 0, 0, "balanced"),
(14846, 14846, "Swoop Cannon", 0, "", 0, "Monster3.toad_cannon", 45, 47.5, 75, "male", "L2SiegeSummon", 40, 79000, 1138, 11.85, 2.78, 40, 43, 30, 21, 20, 25, 0, 0, 22, 1314, 428, 1354, 165, 0, 333, 0, 0, 0, 44, 44, "NULL", 0, 0, 0, "LAST_HIT", 0, 0, 0, "balanced"),
(14847, 14847, "Swoop Cannon", 0, "", 0, "Monster3.toad_cannon", 45, 47.5, 76, "male", "L2SiegeSummon", 40, 79000, 1138, 11.85, 2.78, 40, 43, 30, 21, 20, 25, 0, 0, 22, 1314, 428, 1354, 165, 0, 333, 0, 0, 0, 44, 44, "NULL", 0, 0, 0, "LAST_HIT", 0, 0, 0, "balanced"),
(14848, 14848, "Swoop Cannon", 0, "", 0, "Monster3.toad_cannon", 45, 47.5, 77, "male", "L2SiegeSummon", 40, 79000, 1138, 11.85, 2.78, 40, 43, 30, 21, 20, 25, 0, 0, 22, 1314, 428, 1354, 165, 0, 333, 0, 0, 0, 44, 44, "NULL", 0, 0, 0, "LAST_HIT", 0, 0, 0, "balanced"),
(14849, 14849, "Swoop Cannon", 0, "", 0, "Monster3.toad_cannon", 45, 47.5, 78, "male", "L2SiegeSummon", 40, 79000, 1138, 11.85, 2.78, 40, 43, 30, 21, 20, 25, 0, 0, 22, 1314, 428, 1354, 165, 0, 333, 0, 0, 0, 44, 44, "NULL", 0, 0, 0, "LAST_HIT", 0, 0, 0, "balanced"),
(14850, 14850, "Swoop Cannon", 0, "", 0, "Monster3.toad_cannon", 45, 47.5, 79, "male", "L2SiegeSummon", 40, 79000, 1138, 11.85, 2.78, 40, 43, 30, 21, 20, 25, 0, 0, 22, 1314, 428, 1354, 165, 0, 333, 0, 0, 0, 44, 44, "NULL", 0, 0, 0, "LAST_HIT", 0, 0, 0, "balanced"),
(14851, 14851, "Swoop Cannon", 0, "", 0, "Monster3.toad_cannon", 45, 47.5, 80, "male", "L2SiegeSummon", 40, 79000, 1138, 11.85, 2.78, 40, 43, 30, 21, 20, 25, 0, 0, 22, 1314, 428, 1354, 165, 0, 333, 0, 0, 0, 44, 44, "NULL", 0, 0, 0, "LAST_HIT", 0, 0, 0, "balanced"),
(14852, 14852, "Swoop Cannon", 0, "", 0, "Monster3.toad_cannon", 45, 47.5, 81, "male", "L2SiegeSummon", 40, 79000, 1138, 11.85, 2.78, 40, 43, 30, 21, 20, 25, 0, 0, 22, 1314, 428, 1354, 165, 0, 333, 0, 0, 0, 44, 44, "NULL", 0, 0, 0, "LAST_HIT", 0, 0, 0, "balanced"),
(14853, 14853, "Swoop Cannon", 0, "", 0, "Monster3.toad_cannon", 45, 47.5, 82, "male", "L2SiegeSummon", 40, 79000, 1138, 11.85, 2.78, 40, 43, 30, 21, 20, 25, 0, 0, 22, 1314, 428, 1354, 165, 0, 333, 0, 0, 0, 44, 44, "NULL", 0, 0, 0, "LAST_HIT", 0, 0, 0, "balanced"),
(14854, 14854, "Swoop Cannon", 0, "", 0, "Monster3.toad_cannon", 45, 47.5, 83, "male", "L2SiegeSummon", 40, 79000, 1138, 11.85, 2.78, 40, 43, 30, 21, 20, 25, 0, 0, 22, 1314, 428, 1354, 165, 0, 333, 0, 0, 0, 44, 44, "NULL", 0, 0, 0, "LAST_HIT", 0, 0, 0, "balanced"),
(14855, 14855, "Swoop Cannon", 0, "", 0, "Monster3.toad_cannon", 45, 47.5, 84, "male", "L2SiegeSummon", 40, 79000, 1138, 11.85, 2.78, 40, 43, 30, 21, 20, 25, 0, 0, 22, 1314, 428, 1354, 165, 0, 333, 0, 0, 0, 44, 44, "NULL", 0, 0, 0, "LAST_HIT", 0, 0, 0, "balanced"),
(14856, 14856, "Swoop Cannon", 0, "", 0, "Monster3.toad_cannon", 45, 47.5, 85, "male", "L2SiegeSummon", 40, 79000, 1138, 11.85, 2.78, 40, 43, 30, 21, 20, 25, 0, 0, 22, 1314, 428, 1354, 165, 0, 333, 0, 0, 0, 44, 44, "NULL", 0, 0, 0, "LAST_HIT", 0, 0, 0, "balanced"),
(14857, 14857, "Swoop Cannon", 0, "", 0, "Monster3.toad_cannon", 45, 47.5, 86, "male", "L2SiegeSummon", 40, 79000, 1138, 11.85, 2.78, 40, 43, 30, 21, 20, 25, 0, 0, 22, 1314, 428, 1354, 165, 0, 333, 0, 0, 0, 44, 44, "NULL", 0, 0, 0, "LAST_HIT", 0, 0, 0, "balanced"),
(14858, 14858, "Swoop Cannon", 0, "", 0, "Monster3.toad_cannon", 45, 47.5, 87, "male", "L2SiegeSummon", 40, 79000, 1138, 11.85, 2.78, 40, 43, 30, 21, 20, 25, 0, 0, 22, 1314, 428, 1354, 165, 0, 333, 0, 0, 0, 44, 44, "NULL", 0, 0, 0, "LAST_HIT", 0, 0, 0, "balanced"),
(14859, 14859, "Swoop Cannon", 0, "", 0, "Monster3.toad_cannon", 45, 47.5, 88, "male", "L2SiegeSummon", 40, 79000, 1138, 11.85, 2.78, 40, 43, 30, 21, 20, 25, 0, 0, 22, 1314, 428, 1354, 165, 0, 333, 0, 0, 0, 44, 44, "NULL", 0, 0, 0, "LAST_HIT", 0, 0, 0, "balanced"),
(14860, 14860, "Swoop Cannon", 0, "", 0, "Monster3.toad_cannon", 45, 47.5, 89, "male", "L2SiegeSummon", 40, 79000, 1138, 11.85, 2.78, 40, 43, 30, 21, 20, 25, 0, 0, 22, 1314, 428, 1354, 165, 0, 333, 0, 0, 0, 44, 44, "NULL", 0, 0, 0, "LAST_HIT", 0, 0, 0, "balanced"),
(14861, 14861, "Swoop Cannon", 0, "", 0, "Monster3.toad_cannon", 45, 47.5, 90, "male", "L2SiegeSummon", 40, 79000, 1138, 11.85, 2.78, 40, 43, 30, 21, 20, 25, 0, 0, 22, 1314, 428, 1354, 165, 0, 333, 0, 0, 0, 44, 44, "NULL", 0, 0, 0, "LAST_HIT", 0, 0, 0, "balanced"),
(14862, 14862, "Swoop Cannon", 0, "", 0, "Monster3.toad_cannon", 45, 47.5, 91, "male", "L2SiegeSummon", 40, 79000, 1138, 11.85, 2.78, 40, 43, 30, 21, 20, 25, 0, 0, 22, 1314, 428, 1354, 165, 0, 333, 0, 0, 0, 44, 44, "NULL", 0, 0, 0, "LAST_HIT", 0, 0, 0, "balanced"),
(14863, 14863, "Swoop Cannon", 0, "", 0, "Monster3.toad_cannon", 45, 47.5, 92, "male", "L2SiegeSummon", 40, 79000, 1138, 11.85, 2.78, 40, 43, 30, 21, 20, 25, 0, 0, 22, 1314, 428, 1354, 165, 0, 333, 0, 0, 0, 44, 44, "NULL", 0, 0, 0, "LAST_HIT", 0, 0, 0, "balanced"),
(14864, 14864, "Swoop Cannon", 0, "", 0, "Monster3.toad_cannon", 45, 47.5, 93, "male", "L2SiegeSummon", 40, 79000, 1138, 11.85, 2.78, 40, 43, 30, 21, 20, 25, 0, 0, 22, 1314, 428, 1354, 165, 0, 333, 0, 0, 0, 44, 44, "NULL", 0, 0, 0, "LAST_HIT", 0, 0, 0, "balanced"),
(14865, 14865, "Swoop Cannon", 0, "", 0, "Monster3.toad_cannon", 45, 47.5, 94, "male", "L2SiegeSummon", 40, 79000, 1138, 11.85, 2.78, 40, 43, 30, 21, 20, 25, 0, 0, 22, 1314, 428, 1354, 165, 0, 333, 0, 0, 0, 44, 44, "NULL", 0, 0, 0, "LAST_HIT", 0, 0, 0, "balanced"),
(14866, 14866, "Swoop Cannon", 0, "", 0, "Monster3.toad_cannon", 45, 47.5, 95, "male", "L2SiegeSummon", 40, 79000, 1138, 11.85, 2.78, 40, 43, 30, 21, 20, 25, 0, 0, 22, 1314, 428, 1354, 165, 0, 333, 0, 0, 0, 44, 44, "NULL", 0, 0, 0, "LAST_HIT", 0, 0, 0, "balanced"),
(14867, 14867, "Swoop Cannon", 0, "", 0, "Monster3.toad_cannon", 45, 47.5, 96, "male", "L2SiegeSummon", 40, 79000, 1138, 11.85, 2.78, 40, 43, 30, 21, 20, 25, 0, 0, 22, 1314, 428, 1354, 165, 0, 333, 0, 0, 0, 44, 44, "NULL", 0, 0, 0, "LAST_HIT", 0, 0, 0, "balanced"),
(14868, 14868, "Swoop Cannon", 0, "", 0, "Monster3.toad_cannon", 45, 47.5, 97, "male", "L2SiegeSummon", 40, 79000, 1138, 11.85, 2.78, 40, 43, 30, 21, 20, 25, 0, 0, 22, 1314, 428, 1354, 165, 0, 333, 0, 0, 0, 44, 44, "NULL", 0, 0, 0, "LAST_HIT", 0, 0, 0, "balanced"),
(14869, 14869, "Swoop Cannon", 0, "", 0, "Monster3.toad_cannon", 45, 47.5, 98, "male", "L2SiegeSummon", 40, 79000, 1138, 11.85, 2.78, 40, 43, 30, 21, 20, 25, 0, 0, 22, 1314, 428, 1354, 165, 0, 333, 0, 0, 0, 44, 44, "NULL", 0, 0, 0, "LAST_HIT", 0, 0, 0, "balanced");

INSERT INTO `npc` VALUES
(16013, 16013, "Trained Buffalo", 0, "", 0, "Monster2.buffalo", 22, 31, 67, "male", "L2TamedBeast", 40, 3626, 1388, 23.7, 2.78, 40, 43, 30, 21, 20, 10, 0, 0, 1169, 439, 681, 356, 278, 0, 333, 0, 0, 0, 22, 187, "pet_clan", 400, 0, 0, "LAST_HIT", 0, 0, 0, "fighter"),
(16014, 16014, "Trained Buffalo", 0, "", 0, "Monster2.buffalo", 22, 31, 67, "male", "L2TamedBeast", 40, 3626, 1388, 23.7, 2.78, 40, 43, 30, 21, 20, 10, 0, 0, 1169, 439, 681, 356, 278, 0, 333, 0, 0, 0, 22, 187, "pet_clan", 400, 0, 0, "LAST_HIT", 0, 0, 0, "fighter"),
(16015, 16015, "Trained Cougar", 0, "", 0, "Monster.saber_toothed_tiger", 34, 28, 69, "male", "L2TamedBeast", 40, 3784, 1458, 23.7, 2.78, 40, 43, 30, 21, 20, 10, 0, 0, 1265, 460, 746, 373, 278, 0, 333, 0, 0, 0, 66, 192, "pet_clan", 400, 0, 0, "LAST_HIT", 0, 0, 0, "fighter"),
(16016, 16016, "Trained Cougar", 0, "", 0, "Monster.saber_toothed_tiger", 34, 28, 69, "male", "L2TamedBeast", 40, 3784, 1458, 23.7, 2.78, 40, 43, 30, 21, 20, 10, 0, 0, 1265, 460, 746, 373, 278, 0, 333, 0, 0, 0, 66, 192, "pet_clan", 400, 0, 0, "LAST_HIT", 0, 0, 0, "fighter"),
(16017, 16017, "Trained Kookaburra", 0, "", 0, "Monster2.pet_ostrich", 10, 33, 65, "male", "L2TamedBeast", 40, 3465, 1319, 23.7, 2.78, 40, 43, 30, 21, 20, 10, 0, 0, 1077, 418, 619, 340, 278, 0, 333, 0, 0, 0, 25, 209, "pet_clan", 400, 0, 0, "LAST_HIT", 0, 0, 0, "fighter"),
(16018, 16018, "Trained Kookaburra", 0, "", 0, "Monster2.pet_ostrich", 10, 33, 65, "male", "L2TamedBeast", 40, 3465, 1319, 23.7, 2.78, 40, 43, 30, 21, 20, 10, 0, 0, 1077, 418, 619, 340, 278, 0, 333, 0, 0, 0, 25, 209, "pet_clan", 400, 0, 0, "LAST_HIT", 0, 0, 0, "fighter"),
(16019, 16019, "Tiny Baby Buffalo", 0, "", 0, "Monster2.baby_buffalo", 20, 31, 99, "male", "L2Monster", 40, 400000, 9999, 13.43, 3.09, 40, 43, 30, 21, 20, 10, 0, 0, 9000, 5000, 6000, 6000, 300, 0, 333, 0, 0, 0, 88, 132, "NULL", 0, 0, 0, "LAST_HIT", 0, 0, 0, "balanced"),
(16020, 16020, "Tame Tiny Baby Buffalo", 0, "", 0, "Monster2.baby_buffalo", 20, 31, 99, "male", "L2Monster", 40, 400000, 9999, 13.43, 3.09, 40, 43, 30, 21, 20, 10, 0, 0, 9000, 5000, 6000, 6000, 300, 0, 333, 0, 0, 0, 88, 132, "NULL", 0, 0, 0, "LAST_HIT", 0, 0, 0, "balanced"),
(16021, 16021, "Tiny Baby Cougar", 0, "", 0, "Monster2.baby_tiger", 20, 31, 99, "male", "L2Monster", 40, 400000, 9999, 13.43, 3.09, 40, 43, 30, 21, 20, 10, 0, 0, 9000, 5000, 6000, 6000, 300, 0, 333, 0, 0, 0, 88, 132, "NULL", 0, 0, 0, "LAST_HIT", 0, 0, 0, "balanced"),
(16022, 16022, "Tame Tiny Baby Cougar", 0, "", 0, "Monster2.baby_tiger", 20, 31, 99, "male", "L2Monster", 40, 400000, 9999, 13.43, 3.09, 40, 43, 30, 21, 20, 10, 0, 0, 9000, 5000, 6000, 6000, 300, 0, 333, 0, 0, 0, 88, 132, "NULL", 0, 0, 0, "LAST_HIT", 0, 0, 0, "balanced"),
(16023, 16023, "Tiny Baby Kookaburra", 0, "", 0, "Monster2.baby_ostrich", 20, 31, 99, "male", "L2Monster", 40, 400000, 9999, 13.43, 3.09, 40, 43, 30, 21, 20, 10, 0, 0, 9000, 5000, 6000, 6000, 300, 0, 333, 0, 0, 0, 88, 132, "NULL", 0, 0, 0, "LAST_HIT", 0, 0, 0, "balanced"),
(16024, 16024, "Tame Tiny Baby Kookaburra", 0, "", 0, "Monster2.baby_ostrich", 20, 31, 99, "male", "L2Monster", 40, 400000, 9999, 13.43, 3.09, 40, 43, 30, 21, 20, 10, 0, 0, 9000, 5000, 6000, 6000, 300, 0, 333, 0, 0, 0, 88, 132, "NULL", 0, 0, 0, "LAST_HIT", 0, 0, 0, "balanced"),
(16025, 16025, "Great Wolf", 0, "", 0, "LineageMonster4.Pet_Wolf_B", 32, 21.41, 70, "male", "L2Npc", 40, 2444, 2444, 0, 0, 10, 10, 10, 10, 10, 10, 0, 0, 500, 500, 500, 500, 304, 0, 333, 9661, 0, NULL, 45, 170, "NULL", 0, 0, 0, "LAST_HIT", 0, 0, 0, "balanced"),
(16026, 16026, "Beastly Agathion", 0, "", 0, "LineageNPC2.Agathion_BF", 32, 23.56, 70, "male", "L2Npc", 40, 2444, 2444, 0, 0, 10, 10, 10, 10, 10, 10, 0, 0, 500, 500, 500, 500, 253, 0, 253, 0, 0, NULL, 80, 120, "NULL", 0, 0, 0, "LAST_HIT", 0, 0, 0, "balanced"),
(16027, 16027, "Rainbow Agathion", 0, "", 0, "LineageNPC2.Agathion_RA", 32, 23.56, 70, "male", "L2Npc", 40, 2444, 2444, 0, 0, 10, 10, 10, 10, 10, 10, 0, 0, 500, 500, 500, 500, 253, 0, 253, 0, 0, NULL, 80, 120, "NULL", 0, 0, 0, "LAST_HIT", 0, 0, 0, "balanced"),
(16028, 16028, "Lord Agathion", 0, "", 0, "LineageNPC2.Agathion_CL", 32, 23.56, 70, "male", "L2Npc", 40, 2444, 2444, 0, 0, 10, 10, 10, 10, 10, 10, 0, 0, 500, 500, 500, 500, 253, 0, 253, 0, 0, NULL, 80, 120, "NULL", 0, 0, 0, "LAST_HIT", 0, 0, 0, "balanced"),
(16029, 16029, "Fortress Agathion", 0, "", 0, "LineageNPC2.Agathion_FT", 32, 23.56, 70, "male", "L2Npc", 40, 2444, 2444, 0, 0, 10, 10, 10, 10, 10, 10, 0, 0, 500, 500, 500, 500, 253, 0, 253, 0, 0, NULL, 80, 120, "NULL", 0, 0, 0, "LAST_HIT", 0, 0, 0, "balanced"),
(16030, 16030, "Great Wolf", 0, "", 0, "LineageMonster4.Pet_Wolf_Ba", 32, 23.56, 70, "male", "L2Pet", 40, 2444, 2444, 0, 0, 10, 10, 10, 10, 10, 10, 0, 0, 500, 500, 500, 500, 253, 0, 253, 0, 0, NULL, 80, 120, "NULL", 0, 0, 0, "LAST_HIT", 0, 0, 0, "balanced"),
(16031, 16031, "Little Angel Agathion", 0, "", 0, "LineageNpc2.Agathion_ag", 32, 23.56, 70, "male", "L2Npc", 40, 2444, 2444, 0, 0, 10, 10, 10, 10, 10, 10, 0, 0, 500, 500, 500, 500, 253, 0, 253, 0, 0, NULL, 80, 120, "NULL", 0, 0, 0, "LAST_HIT", 0, 0, 0, "balanced"),
(16032, 16032, "Little Devil Agathion", 0, "", 0, "LineageNpc2.Agathion_st", 32, 23.56, 70, "male", "L2Npc", 40, 2444, 2444, 0, 0, 10, 10, 10, 10, 10, 10, 0, 0, 500, 500, 500, 500, 253, 0, 253, 0, 0, NULL, 80, 120, "NULL", 0, 0, 0, "LAST_HIT", 0, 0, 0, "balanced"),
(16033, 16033, "Rudolph Agathion", 0, "", 0, "LineageNpc2.Agathion_rd", 32, 23.56, 70, "male", "L2Npc", 40, 2444, 2444, 0, 0, 10, 10, 10, 10, 10, 10, 0, 0, 500, 500, 500, 500, 253, 0, 253, 0, 0, NULL, 80, 120, "NULL", 0, 0, 0, "LAST_HIT", 0, 0, 0, "balanced"),
(18001, 18001, "Blood Queen", 0, "", 0, "Monster.bloody_queen", 14, 40, 60, "female", "L2Monster", 40, 3054, 1150, 10.27, 2.45, 40, 43, 30, 21, 20, 10, 4536, 394, 860, 368, 478, 299, 278, 500, 333, 0, 0, 0, 80, 160, "cave_servant_clan", 400, 0, 0, "LAST_HIT", 0, 0, 0, "fighter"),
(18002, 18002, "Blood Queen", 0, "", 0, "Monster.bloody_queen", 14, 40, 60, "female", "L2Monster", 40, 3054, 1150, 10.27, 2.45, 40, 43, 30, 21, 20, 10, 4320, 375, 946, 368, 478, 299, 282, 500, 333, 0, 0, 0, 88, 176, "cave_servant_clan", 300, 0, 0, "LAST_HIT", 0, 0, 0, "fighter"),
(18003, 18003, "Bearded Keltir", 0, "", 0, "Monster.keltir", 9.5, 10, 1, "male", "L2Monster", 40, 62, 44, 3.16, 0.91, 40, 43, 30, 21, 20, 10, 29, 2, 4, 39, 3, 32, 278, 0, 333, 0, 0, 0, 25, 121, "NULL", 0, 0, 0, "LAST_HIT", 0, 0, 0, "balanced"),
(18004, 18004, "Susceptor Prime", 0, "", 0, "Monster.susceptor_prime", 45, 72, 49, "male", "L2Monster", 50, 2168, 799, 8.69, 2.14, 40, 43, 30, 21, 20, 10, 0, 1, 480, 270, 247, 219, 282, 0, 333, 0, 0, 0, 85, 187, "NULL", 0, 0, 0, "LAST_HIT", 0, 0, 0, "fighter"),
(18005, 18005, "Mimic", 0, "", 0, "Monster.mimic", 8.5, 8.5, 52, "male", "L2Monster", 40, 2479, 892, 10.27, 2.45, 40, 43, 30, 21, 20, 10, 3244, 251, 588, 304, 300, 239, 278, 0, 333, 0, 0, 0, 88, 171, "NULL", 0, 0, 0, "LAST_HIT", 0, 0, 0, "fighter"),
(18006, 18006, "Maruk Lord", 0, "", 0, "Monster.death_blader", 15, 45, 68, "male", "L2Monster", 40, 3825, 1423, 11.85, 2.78, 40, 43, 30, 21, 20, 10, 6057, 586, 1256, 464, 713, 365, 278, 500, 333, 1472, 0, 0, 110, 187, "malruk_clan", 300, 1, 0, "LAST_HIT", 0, 0, 0, "fighter"),
(18007, 18007, "Limal Karinness", 0, "", 0, "Monster.bloody_queen", 14, 40, 69, "female", "L2Monster", 40, 3784, 1458, 11.85, 2.78, 40, 43, 30, 21, 20, 10, 5951, 582, 1392, 460, 821, 373, 278, 500, 333, 0, 0, 0, 88, 154, "malruk_clan", 300, 0, 0, "LAST_HIT", 0, 0, 0, "fighter"),
(18008, 18008, "Karik", 0, "", 0, "Monster.karik", 25, 90, 70, "male", "L2Monster", 40, 3862, 1493, 11.85, 2.78, 40, 43, 30, 21, 20, 10, 6370, 632, 1445, 470, 858, 382, 278, 500, 333, 0, 0, 0, 40, 220, "NULL", 0, 0, 0, "LAST_HIT", 0, 0, 0, "fighter"),
(18009, 18009, "Offering of Branded Elder", 0, "", 0, "Monster.orc_fighter_bi", 12, 26.4, 34, "male", "L2FestivalMonster", 40, 1164, 430, 7.11, 1.84, 40, 43, 30, 21, 20, 10, 1754, 102, 178, 163, 82, 132, 278, 0, 333, 127, 0, 0, 49, 33, "mercenary_siege_clan", 500, 0, 0, "LAST_HIT", 0, 0, 0, "fighter"),
(18010, 18010, "Offering of the Branded", 0, "", 0, "Monster.orc", 10, 21, 32, "male", "L2FestivalMonster", 40, 1056, 397, 7.11, 1.84, 40, 43, 30, 21, 20, 10, 1523, 86, 134, 129, 69, 123, 237, 0, 333, 218, 0, 0, 49, 33, "NULL", 0, 0, 0, "LAST_HIT", 0, 0, 0, "fighter"),
(18011, 18011, "Offering of Branded Archer", 0, "", 0, "Monster.orc_archer", 14, 25, 28, "male", "L2FestivalMonster", 500, 859, 334, 5.53, 1.53, 40, 43, 30, 21, 20, 10, 1001, 53, 251, 110, 49, 106, 249, 0, 333, 14, 0, 0, 49, 66, "NULL", 0, 0, 0, "LAST_HIT", 0, 0, 0, "archer"),
(18012, 18012, "Offering of Branded Warrior", 0, "", 0, "Monster.orc_champion", 10, 23, 29, "male", "L2FestivalMonster", 40, 906, 349, 5.53, 1.53, 40, 43, 30, 21, 20, 10, 1026, 55, 122, 135, 53, 110, 278, 0, 333, 125, 0, 0, 49, 121, "NULL", 0, 0, 0, "LAST_HIT", 0, 0, 0, "fighter"),
(18013, 18013, "Offering of Branded Follower", 0, "", 0, "Monster.orc_shaman", 9, 22, 29, "male", "L2FestivalMonster", 40, 906, 349, 5.53, 1.53, 40, 43, 30, 21, 20, 10, 1227, 66, 107, 115, 53, 110, 237, 0, 333, 316, 0, 0, 49, 165, "NULL", 0, 0, 0, "LAST_HIT", 0, 0, 0, "balanced"),
(18014, 18014, "Offering of Branded Berserker", 0, "", 0, "Monster.virud_lizardman", 10, 23, 37, "male", "L2FestivalMonster", 40, 1338, 480, 7.11, 1.84, 40, 43, 30, 21, 20, 10, 2276, 140, 222, 182, 104, 147, 278, 0, 333, 292, 0, 0, 47, 126, "NULL", 0, 0, 0, "LAST_HIT", 0, 0, 0, "fighter"),
(18015, 18015, "Offering of Branded Zealot", 0, "", 0, "Monster.orc_fighter_bi", 12, 26.4, 34, "male", "L2FestivalMonster", 40, 1164, 430, 7.11, 1.84, 40, 43, 30, 21, 20, 10, 1650, 96, 156, 138, 82, 132, 237, 0, 333, 158, 0, 0, 49, 170, "NULL", 0, 0, 0, "LAST_HIT", 0, 0, 0, "fighter"),
(18016, 18016, "Offering of Branded Marksman", 0, "", 0, "Monster.orc_archer_20_bi", 16, 30, 32, "male", "L2FestivalMonster", 500, 1056, 397, 7.11, 1.84, 40, 43, 30, 21, 20, 10, 1265, 71, 342, 129, 69, 123, 249, 0, 333, 273, 0, 0, 49, 143, "NULL", 0, 0, 0, "LAST_HIT", 0, 0, 0, "archer"),
(18017, 18017, "Offering of Branded Disciple", 0, "", 0, "Monster.batur_orc", 9, 21.5, 34, "male", "L2FestivalMonster", 40, 1164, 430, 7.11, 1.84, 40, 43, 30, 21, 20, 10, 1650, 96, 178, 163, 82, 132, 278, 0, 333, 129, 0, 0, 88, 181, "NULL", 0, 0, 0, "LAST_HIT", 0, 0, 0, "fighter"),
(18018, 18018, "Offering of Branded Saint", 0, "", 0, "Monster.batur_orc_20_bi", 10, 25.3, 39, "male", "L2FestivalMonster", 40, 1462, 514, 7.11, 1.84, 40, 43, 30, 21, 20, 10, 2171, 138, 255, 195, 121, 158, 278, 0, 333, 72, 0, 0, 88, 181, "NULL", 0, 0, 0, "LAST_HIT", 0, 0, 0, "fighter"),
(18019, 18019, "Apostate's Offering Elder", 0, "", 0, "Monster.orc_champion_20_bi", 12, 27.6, 45, "male", "L2FestivalMonster", 40, 1870, 677, 8.69, 2.14, 40, 43, 30, 21, 20, 10, 3013, 210, 377, 238, 188, 193, 278, 0, 333, 72, 0, 0, 49, 33, "NULL", 0, 0, 0, "LAST_HIT", 0, 0, 0, "fighter"),
(18020, 18020, "Apostate's Offering ", 0, "", 0, "Monster.orc_fighter", 12, 22, 43, "male", "L2FestivalMonster", 40, 1728, 618, 8.69, 2.14, 40, 43, 30, 21, 20, 10, 2751, 186, 291, 189, 163, 181, 237, 0, 333, 223, 0, 0, 49, 33, "NULL", 0, 0, 0, "LAST_HIT", 0, 0, 0, "fighter"),
(18021, 18021, "Apostate's Offering Archer", 0, "", 0, "Monster.batur_orc_archer", 11, 21.5, 39, "male", "L2FestivalMonster", 500, 1462, 514, 7.11, 1.84, 40, 43, 30, 21, 20, 10, 1879, 119, 566, 165, 121, 158, 249, 0, 333, 275, 0, 0, 49, 66, "NULL", 0, 0, 0, "LAST_HIT", 0, 0, 0, "archer"),
(18022, 18022, "Apostate's Offering Warrior", 0, "", 0, "Monster.batur_orc_warrior", 10, 20, 40, "male", "L2FestivalMonster", 40, 1527, 531, 7.11, 1.84, 40, 43, 30, 21, 20, 10, 1920, 124, 273, 201, 131, 164, 278, 0, 333, 127, 0, 0, 88, 126, "NULL", 0, 0, 0, "LAST_HIT", 0, 0, 0, "fighter"),
(18023, 18023, "Apostate's Offering Follower", 0, "", 0, "Monster.batur_orc_shaman", 11, 16, 40, "male", "L2FestivalMonster", 40, 1527, 531, 7.11, 1.84, 40, 43, 30, 21, 20, 10, 2296, 148, 238, 171, 131, 164, 237, 0, 333, 316, 0, 0, 55, 170, "NULL", 0, 0, 0, "LAST_HIT", 0, 0, 0, "balanced"),
(18024, 18024, "Apostate's Offering Berserker", 0, "", 0, "Monster.zenta_lizardman", 11, 32, 48, "male", "L2FestivalMonster", 40, 2091, 768, 8.69, 2.14, 40, 43, 30, 21, 20, 10, 3832, 280, 453, 261, 231, 212, 278, 0, 333, 297, 0, 0, 40, 132, "NULL", 0, 0, 0, "LAST_HIT", 0, 0, 0, "fighter"),
(18025, 18025, "Apostate's Offering Zealot", 0, "", 0, "Monster.batur_orc_20_bi", 10, 25.3, 45, "male", "L2FestivalMonster", 40, 1870, 677, 8.69, 2.14, 40, 43, 30, 21, 20, 10, 2891, 201, 330, 202, 188, 193, 237, 0, 333, 172, 0, 0, 88, 176, "NULL", 0, 0, 0, "LAST_HIT", 0, 0, 0, "fighter"),
(18026, 18026, "Apostate's Offering Marksman", 0, "", 0, "Monster.batur_orc_archer_20_bi", 13, 25.3, 43, "male", "L2FestivalMonster", 500, 1728, 618, 8.69, 2.14, 40, 43, 30, 21, 20, 10, 2285, 154, 739, 189, 163, 181, 249, 0, 333, 277, 0, 0, 49, 148, "NULL", 0, 0, 0, "LAST_HIT", 0, 0, 0, "archer"),
(18027, 18027, "Apostate's Offering Disciple", 0, "", 0, "Monster.batur_orc_overlord", 12, 24, 45, "male", "L2FestivalMonster", 40, 1870, 677, 8.69, 2.14, 40, 43, 30, 21, 20, 10, 2891, 201, 377, 238, 188, 193, 278, 0, 333, 74, 0, 0, 88, 187, "NULL", 0, 0, 0, "LAST_HIT", 0, 0, 0, "fighter"),
(18028, 18028, "Apostate's Offering Saint", 0, "", 0, "Monster.batur_orc_overlord_20_bi", 14, 28.8, 50, "male", "L2FestivalMonster", 40, 2245, 830, 8.69, 2.14, 40, 43, 30, 21, 20, 10, 3570, 269, 509, 278, 264, 226, 278, 0, 333, 133, 0, 0, 88, 187, "NULL", 0, 0, 0, "LAST_HIT", 0, 0, 0, "fighter"),
(18029, 18029, "Witch's Offering Elder", 0, "", 0, "Monster.batur_orc_warrior_20_bi", 12, 24, 56, "male", "L2FestivalMonster", 40, 2724, 1019, 10.27, 2.45, 40, 43, 30, 21, 20, 10, 4666, 383, 706, 331, 382, 269, 278, 0, 333, 133, 0, 0, 88, 33, "NULL", 0, 0, 0, "LAST_HIT", 0, 0, 0, "fighter"),
(18030, 18030, "Witch's Offering", 0, "", 0, "Monster.batur_orc", 9, 21.5, 54, "male", "L2FestivalMonster", 40, 2562, 955, 10.27, 2.45, 40, 43, 30, 21, 20, 10, 4339, 346, 556, 266, 339, 254, 237, 0, 333, 226, 0, 0, 88, 33, "NULL", 0, 0, 0, "LAST_HIT", 0, 0, 0, "fighter"),
(18031, 18031, "Witch's Offering Archer", 0, "", 0, "Monster.batur_orc_archer", 11, 21.5, 50, "male", "L2FestivalMonster", 500, 2245, 830, 8.69, 2.14, 40, 43, 30, 21, 20, 10, 3090, 233, 1132, 236, 264, 226, 249, 0, 333, 278, 0, 0, 49, 77, "NULL", 0, 0, 0, "LAST_HIT", 0, 0, 0, "archer"),
(18032, 18032, "Witch's Offering Warrior", 0, "", 0, "Monster.batur_orc_warrior", 10, 20, 51, "male", "L2FestivalMonster", 40, 2323, 861, 10.27, 2.45, 40, 43, 30, 21, 20, 10, 3121, 238, 539, 286, 281, 232, 278, 0, 333, 72, 0, 0, 88, 132, "NULL", 0, 0, 0, "LAST_HIT", 0, 0, 0, "fighter"),
(18033, 18033, "Witch's Offering Follower", 0, "", 0, "Monster.batur_orc_shaman", 11, 16, 51, "male", "L2FestivalMonster", 40, 2323, 861, 10.27, 2.45, 40, 43, 30, 21, 20, 10, 3732, 285, 472, 243, 281, 232, 237, 0, 333, 316, 0, 0, 55, 176, "NULL", 0, 0, 0, "LAST_HIT", 0, 0, 0, "balanced"),
(18034, 18034, "Witch's Offering Berserker", 0, "", 0, "Monster.virud_lizardman_warrior", 12, 30, 59, "male", "L2FestivalMonster", 40, 2971, 1117, 10.27, 2.45, 40, 43, 30, 21, 20, 10, 5789, 495, 820, 359, 453, 291, 278, 0, 333, 301, 0, 0, 57, 137, "NULL", 0, 0, 0, "LAST_HIT", 0, 0, 0, "fighter"),
(18035, 18035, "Witch's Offering Zealot", 0, "", 0, "Monster.batur_orc_20_bi", 10, 25.3, 56, "male", "L2FestivalMonster", 40, 2724, 1019, 10.27, 2.45, 40, 43, 30, 21, 20, 10, 4478, 368, 618, 281, 382, 269, 237, 0, 333, 91, 0, 0, 88, 181, "NULL", 0, 0, 0, "LAST_HIT", 0, 0, 0, "fighter"),
(18036, 18036, "Witch's Offering Marksman", 0, "", 0, "Monster.batur_orc_archer_20_bi", 13, 25.3, 54, "male", "L2FestivalMonster", 500, 2562, 955, 10.27, 2.45, 40, 43, 30, 21, 20, 10, 3604, 287, 1413, 266, 339, 254, 249, 0, 333, 282, 0, 0, 49, 154, "NULL", 0, 0, 0, "LAST_HIT", 0, 0, 0, "archer"),
(18037, 18037, "Witch's Offering Disciple", 0, "", 0, "Monster.batur_orc_overlord", 12, 24, 56, "male", "L2FestivalMonster", 40, 2724, 1019, 10.27, 2.45, 40, 43, 30, 21, 20, 10, 4478, 368, 706, 331, 382, 269, 278, 0, 333, 135, 0, 0, 88, 192, "NULL", 0, 0, 0, "LAST_HIT", 0, 0, 0, "fighter"),
(18038, 18038, "Witch's Offering Saint", 0, "", 0, "Monster.batur_orc_overlord_20_bi", 14, 28.8, 61, "male", "L2FestivalMonster", 40, 3137, 1184, 11.85, 2.78, 40, 43, 30, 21, 20, 10, 5313, 468, 901, 378, 505, 307, 278, 0, 333, 79, 0, 0, 88, 192, "NULL", 0, 0, 0, "LAST_HIT", 0, 0, 0, "fighter"),
(18039, 18039, "Dark Omen Offering Elder", 0, "", 0, "Monster.batur_orc_warrior_20_bi", 12, 24, 67, "male", "L2FestivalMonster", 40, 3626, 1388, 11.85, 2.78, 40, 43, 30, 21, 20, 10, 6679, 636, 1169, 439, 681, 356, 278, 0, 333, 79, 0, 0, 88, 33, "NULL", 0, 0, 0, "LAST_HIT", 0, 0, 0, "fighter"),
(18040, 18040, "Dark Omen Offering", 0, "", 0, "Monster.batur_orc", 9, 21.5, 65, "male", "L2FestivalMonster", 40, 3465, 1319, 11.85, 2.78, 40, 43, 30, 21, 20, 10, 6286, 584, 942, 355, 619, 340, 237, 0, 333, 234, 0, 0, 88, 33, "NULL", 0, 0, 0, "LAST_HIT", 0, 0, 0, "balanced"),
(18041, 18041, "Dark Omen Offering Archer", 0, "", 0, "Monster.batur_orc_archer", 11, 21.5, 61, "male", "L2FestivalMonster", 500, 3137, 1184, 11.85, 2.78, 40, 43, 30, 21, 20, 10, 4599, 405, 2004, 321, 505, 307, 249, 0, 333, 283, 0, 0, 49, 77, "NULL", 0, 0, 0, "LAST_HIT", 0, 0, 0, "archer"),
(18042, 18042, "Dark Omen Offering Warrior", 0, "", 0, "Monster.batur_orc_warrior", 10, 20, 62, "male", "L2FestivalMonster", 40, 3219, 1217, 11.85, 2.78, 40, 43, 30, 21, 20, 10, 4612, 411, 944, 388, 532, 315, 278, 0, 333, 133, 0, 0, 88, 137, "NULL", 0, 0, 0, "LAST_HIT", 0, 0, 0, "fighter"),
(18043, 18043, "Dark Omen Offering Follower", 0, "", 0, "Monster.batur_orc_shaman", 11, 16, 62, "male", "L2FestivalMonster", 40, 3219, 1217, 11.85, 2.78, 40, 43, 30, 21, 20, 10, 5516, 492, 826, 330, 532, 315, 237, 0, 333, 316, 0, 0, 55, 181, "NULL", 0, 0, 0, "LAST_HIT", 0, 0, 0, "balanced"),
(18044, 18044, "Dark Omen Offering Berserker", 0, "", 0, "Monster.virud_lizardman_warrior", 12, 30, 70, "male", "L2FestivalMonster", 40, 3862, 1493, 11.85, 2.78, 40, 43, 30, 21, 20, 10, 8149, 808, 1314, 470, 780, 382, 278, 0, 333, 97, 0, 0, 57, 143, "NULL", 0, 0, 0, "LAST_HIT", 0, 0, 0, "fighter"),
(18045, 18045, "Dark Omen Offering Zealot", 0, "", 0, "Monster.batur_orc_20_bi", 10, 25.3, 67, "male", "L2FestivalMonster", 40, 3626, 1388, 11.85, 2.78, 40, 43, 30, 21, 20, 10, 6410, 610, 1023, 373, 681, 356, 237, 0, 333, 2503, 0, 0, 88, 187, "NULL", 0, 0, 0, "LAST_HIT", 0, 0, 0, "balanced"),
(18046, 18046, "Dark Omen Offering Marksman", 0, "", 0, "Monster.batur_orc_archer_20_bi", 13, 25.3, 65, "male", "L2FestivalMonster", 500, 3465, 1319, 11.85, 2.78, 40, 43, 30, 21, 20, 10, 5222, 485, 2393, 355, 619, 340, 249, 0, 333, 286, 0, 0, 49, 159, "NULL", 0, 0, 0, "LAST_HIT", 0, 0, 0, "archer"),
(18047, 18047, "Dark Omen Offering Disciple", 0, "", 0, "Monster.batur_orc_overlord", 12, 24, 67, "male", "L2FestivalMonster", 40, 3626, 1388, 11.85, 2.78, 40, 43, 30, 21, 20, 10, 6410, 610, 1169, 439, 681, 356, 278, 0, 333, 142, 0, 0, 88, 198, "NULL", 0, 0, 0, "LAST_HIT", 0, 0, 0, "fighter"),
(18048, 18048, "Dark Omen Offering Saint", 0, "", 0, "Monster.batur_orc_overlord_20_bi", 14, 28.8, 72, "male", "L2FestivalMonster", 40, 4013, 1565, 13.43, 3.09, 40, 43, 30, 21, 20, 10, 7402, 752, 1413, 491, 849, 399, 278, 0, 333, 2500, 0, 0, 88, 198, "NULL", 0, 0, 0, "LAST_HIT", 0, 0, 0, "fighter"),
(18049, 18049, "Offering of Forbidden Path Elder", 0, "", 0, "Monster.batur_orc_overlord_20_bi", 14, 28.8, 78, "male", "L2FestivalMonster", 40, 4428, 1784, 13.43, 3.09, 40, 43, 30, 21, 20, 10, 9052, 991, 1715, 555, 1069, 451, 278, 0, 333, 2500, 0, 0, 88, 33, "NULL", 0, 0, 0, "LAST_HIT", 0, 0, 0, "fighter"),
(18050, 18050, "Offering of Forbidden Path", 0, "", 0, "Monster.batur_orc_warrior", 10, 20, 76, "male", "L2FestivalMonster", 40, 4297, 1710, 13.43, 3.09, 40, 43, 30, 21, 20, 10, 8594, 919, 1412, 454, 994, 433, 237, 0, 333, 236, 0, 0, 88, 33, "NULL", 0, 0, 0, "LAST_HIT", 0, 0, 0, "balanced"),
(18051, 18051, "Offering of Forbidden Path Archer", 0, "", 0, "Monster.ketra_orc_archer", 12, 27, 80, "male", "L2FestivalMonster", 500, 4663, 1934, 13.43, 3.09, 40, 43, 30, 21, 20, 10, 8310, 955, 4248, 508, 1220, 485, 249, 0, 333, 287, 0, 0, 49, 77, "NULL", 0, 0, 0, "LAST_HIT", 0, 0, 0, "archer"),
(18052, 18052, "Offering of Forbidden Path Warrior", 0, "", 0, "Monster.ketra_orc_warrior", 12, 24, 80, "male", "L2FestivalMonster", 40, 4550, 1859, 13.43, 3.09, 40, 43, 30, 21, 20, 10, 7680, 862, 1814, 576, 1144, 468, 278, 0, 333, 79, 0, 0, 39, 143, "NULL", 0, 0, 0, "LAST_HIT", 0, 0, 0, "fighter"),
(18053, 18053, "Offering of Forbidden Path Follower", 0, "", 0, "Monster.ketra_orc_shaman", 10, 23, 80, "male", "L2FestivalMonster", 40, 4550, 1859, 13.43, 3.09, 40, 43, 30, 21, 20, 10, 9185, 1031, 1587, 490, 1144, 468, 237, 0, 333, 316, 0, 0, 11, 198, "NULL", 0, 0, 0, "LAST_HIT", 0, 0, 0, "balanced"),
(18054, 18054, "Offering of Forbidden Path Berserker", 0, "", 0, "Monster.zenta_lizardman_warrior", 13, 35, 81, "male", "L2FestivalMonster", 40, 4608, 1896, 13.43, 3.09, 40, 43, 30, 21, 20, 10, 10912, 1239, 1863, 587, 1182, 477, 278, 0, 333, 305, 0, 0, 44, 148, "NULL", 0, 0, 0, "LAST_HIT", 0, 0, 0, "fighter"),
(18055, 18055, "Offering of Forbidden Path Zealot", 0, "", 0, "Monster.ketra_orc_20_bi", 14, 34.8, 78, "male", "L2FestivalMonster", 40, 4428, 1784, 13.43, 3.09, 40, 43, 30, 21, 20, 10, 8687, 951, 1500, 472, 1069, 451, 237, 0, 333, 175, 0, 0, 49, 214, "NULL", 0, 0, 0, "LAST_HIT", 0, 0, 0, "balanced"),
(18056, 18056, "Offering of Forbidden Path Marksman", 0, "", 0, "Monster.ketra_orc_archer_20_bi", 14, 32.4, 76, "male", "L2FestivalMonster", 500, 4297, 1710, 13.43, 3.09, 40, 43, 30, 21, 20, 10, 7139, 763, 3587, 454, 994, 433, 249, 0, 333, 289, 0, 0, 49, 165, "NULL", 0, 0, 0, "LAST_HIT", 0, 0, 0, "archer"),
(18057, 18057, "Offering of Forbidden Path Disciple", 0, "", 0, "Monster.ketra_orc_overload", 12, 24, 78, "male", "L2FestivalMonster", 40, 4428, 1784, 13.43, 3.09, 40, 43, 30, 21, 20, 10, 8687, 951, 1715, 555, 1069, 451, 278, 0, 333, 151, 0, 0, 36, 214, "NULL", 0, 0, 0, "LAST_HIT", 0, 0, 0, "fighter"),
(18058, 18058, "Offering of Forbidden Path Saint", 0, "", 0, "Monster.ketra_orc_overload_20_bi", 14, 28.8, 80, "male", "L2FestivalMonster", 40, 4716, 1972, 13.43, 3.09, 40, 43, 30, 21, 20, 10, 9837, 1144, 1959, 608, 1258, 494, 278, 0, 333, 2500, 0, 0, 36, 214, "NULL", 0, 0, 0, "LAST_HIT", 0, 0, 0, "fighter"),
(18059, 18059, "Offering of Branded Elder", 0, "", 0, "Monster.orc_fighter_bi", 12, 26.4, 34, "male", "L2FestivalMonster", 40, 1164, 430, 7.11, 1.84, 40, 43, 30, 21, 20, 10, 1720, 100, 178, 163, 82, 132, 278, 0, 333, 127, 0, 0, 49, 33, "NULL", 0, 0, 0, "LAST_HIT", 0, 0, 0, "fighter"),
(18060, 18060, "Offering of the Branded", 0, "", 0, "Monster.orc", 10, 21, 32, "male", "L2FestivalMonster", 40, 1056, 397, 7.11, 1.84, 40, 43, 30, 21, 20, 10, 1523, 86, 134, 129, 69, 123, 237, 0, 333, 218, 0, 0, 49, 33, "NULL", 0, 0, 0, "LAST_HIT", 0, 0, 0, "fighter"),
(18061, 18061, "Offering of Branded Archer", 0, "", 0, "Monster.orc_archer", 14, 25, 28, "male", "L2FestivalMonster", 500, 859, 334, 5.53, 1.53, 40, 43, 30, 21, 20, 10, 1001, 53, 251, 110, 49, 106, 249, 0, 333, 14, 0, 0, 49, 66, "NULL", 0, 0, 0, "LAST_HIT", 0, 0, 0, "archer"),
(18062, 18062, "Offering of Branded Warrior", 0, "", 0, "Monster.orc_champion", 10, 23, 29, "male", "L2FestivalMonster", 40, 906, 349, 5.53, 1.53, 40, 43, 30, 21, 20, 10, 1026, 55, 122, 135, 53, 110, 278, 0, 333, 125, 0, 0, 49, 121, "NULL", 0, 0, 0, "LAST_HIT", 0, 0, 0, "fighter"),
(18063, 18063, "Offering of Branded Follower", 0, "", 0, "Monster.orc_shaman", 9, 22, 29, "male", "L2FestivalMonster", 40, 906, 349, 5.53, 1.53, 40, 43, 30, 21, 20, 10, 1227, 66, 107, 115, 53, 110, 237, 0, 333, 316, 0, 0, 49, 165, "NULL", 0, 0, 0, "LAST_HIT", 0, 0, 0, "balanced"),
(18064, 18064, "Offering of Branded Berserker", 0, "", 0, "Monster.virud_lizardman", 10, 23, 37, "male", "L2FestivalMonster", 40, 1338, 480, 7.11, 1.84, 40, 43, 30, 21, 20, 10, 2276, 140, 222, 182, 104, 147, 278, 0, 333, 292, 0, 0, 47, 126, "NULL", 0, 0, 0, "LAST_HIT", 0, 0, 0, "fighter"),
(18065, 18065, "Offering of Branded Zealot", 0, "", 0, "Monster.orc_fighter_bi", 12, 26.4, 34, "male", "L2FestivalMonster", 40, 1164, 430, 7.11, 1.84, 40, 43, 30, 21, 20, 10, 1650, 96, 156, 138, 82, 132, 237, 0, 333, 158, 0, 0, 49, 170, "NULL", 0, 0, 0, "LAST_HIT", 0, 0, 0, "fighter"),
(18066, 18066, "Offering of Branded Marksman", 0, "", 0, "Monster.orc_archer_20_bi", 16, 30, 32, "male", "L2FestivalMonster", 500, 1056, 397, 7.11, 1.84, 40, 43, 30, 21, 20, 10, 1265, 71, 342, 129, 69, 123, 249, 0, 333, 273, 0, 0, 49, 143, "NULL", 0, 0, 0, "LAST_HIT", 0, 0, 0, "archer"),
(18067, 18067, "Offering of Branded Disciple", 0, "", 0, "Monster.batur_orc", 9, 21.5, 34, "male", "L2FestivalMonster", 40, 1164, 430, 7.11, 1.84, 40, 43, 30, 21, 20, 10, 1650, 96, 178, 163, 82, 132, 278, 0, 333, 129, 0, 0, 88, 181, "NULL", 0, 0, 0, "LAST_HIT", 0, 0, 0, "fighter"),
(18068, 18068, "Offering of Branded Saint", 0, "", 0, "Monster.batur_orc_20_bi", 10, 25.3, 39, "male", "L2FestivalMonster", 40, 1462, 514, 7.11, 1.84, 40, 43, 30, 21, 20, 10, 2171, 138, 255, 195, 121, 158, 278, 0, 333, 72, 0, 0, 88, 181, "NULL", 0, 0, 0, "LAST_HIT", 0, 0, 0, "fighter"),
(18069, 18069, "Apostate's Offering Elder", 0, "", 0, "Monster.orc_champion_20_bi", 12, 27.6, 45, "male", "L2FestivalMonster", 40, 1870, 677, 8.69, 2.14, 40, 43, 30, 21, 20, 10, 3013, 210, 377, 238, 188, 193, 278, 0, 333, 72, 0, 0, 49, 33, "NULL", 0, 0, 0, "LAST_HIT", 0, 0, 0, "fighter"),
(18070, 18070, "Apostate's Offering ", 0, "", 0, "Monster.orc_fighter", 12, 22, 43, "male", "L2FestivalMonster", 40, 1728, 618, 8.69, 2.14, 40, 43, 30, 21, 20, 10, 2751, 186, 291, 189, 163, 181, 237, 0, 333, 223, 0, 0, 49, 33, "NULL", 0, 0, 0, "LAST_HIT", 0, 0, 0, "fighter"),
(18071, 18071, "Apostate's Offering Archer", 0, "", 0, "Monster.batur_orc_archer", 11, 21.5, 39, "male", "L2FestivalMonster", 500, 1462, 514, 7.11, 1.84, 40, 43, 30, 21, 20, 10, 1879, 119, 566, 165, 121, 158, 249, 0, 333, 275, 0, 0, 49, 66, "NULL", 0, 0, 0, "LAST_HIT", 0, 0, 0, "archer"),
(18072, 18072, "Apostate's Offering Warrior", 0, "", 0, "Monster.batur_orc_warrior", 10, 20, 40, "male", "L2FestivalMonster", 40, 1527, 531, 7.11, 1.84, 40, 43, 30, 21, 20, 10, 1920, 124, 273, 201, 131, 164, 278, 0, 333, 127, 0, 0, 88, 126, "NULL", 0, 0, 0, "LAST_HIT", 0, 0, 0, "fighter"),
(18073, 18073, "Apostate's Offering Follower", 0, "", 0, "Monster.batur_orc_shaman", 11, 16, 40, "male", "L2FestivalMonster", 40, 1527, 531, 7.11, 1.84, 40, 43, 30, 21, 20, 10, 2296, 148, 238, 171, 131, 164, 237, 0, 333, 316, 0, 0, 55, 170, "NULL", 0, 0, 0, "LAST_HIT", 0, 0, 0, "balanced"),
(18074, 18074, "Apostate's Offering Berserker", 0, "", 0, "Monster.zenta_lizardman", 11, 32, 48, "male", "L2FestivalMonster", 40, 2091, 768, 8.69, 2.14, 40, 43, 30, 21, 20, 10, 3832, 280, 453, 261, 231, 212, 278, 0, 333, 297, 0, 0, 40, 132, "NULL", 0, 0, 0, "LAST_HIT", 0, 0, 0, "fighter"),
(18075, 18075, "Apostate's Offering Zealot", 0, "", 0, "Monster.batur_orc_20_bi", 10, 25.3, 45, "male", "L2FestivalMonster", 40, 1870, 677, 8.69, 2.14, 40, 43, 30, 21, 20, 10, 2891, 201, 330, 202, 188, 193, 237, 0, 333, 172, 0, 0, 88, 176, "NULL", 0, 0, 0, "LAST_HIT", 0, 0, 0, "fighter"),
(18076, 18076, "Apostate's Offering Marksman", 0, "", 0, "Monster.batur_orc_archer_20_bi", 13, 25.3, 43, "male", "L2FestivalMonster", 500, 1728, 618, 8.69, 2.14, 40, 43, 30, 21, 20, 10, 2285, 154, 739, 189, 163, 181, 249, 0, 333, 277, 0, 0, 49, 148, "NULL", 0, 0, 0, "LAST_HIT", 0, 0, 0, "archer"),
(18077, 18077, "Apostate's Offering Disciple", 0, "", 0, "Monster.batur_orc_overlord", 12, 24, 45, "male", "L2FestivalMonster", 40, 1870, 677, 8.69, 2.14, 40, 43, 30, 21, 20, 10, 2891, 201, 377, 238, 188, 193, 278, 0, 333, 74, 0, 0, 88, 187, "NULL", 0, 0, 0, "LAST_HIT", 0, 0, 0, "fighter"),
(18078, 18078, "Apostate's Offering Saint", 0, "", 0, "Monster.batur_orc_overlord_20_bi", 14, 28.8, 50, "male", "L2FestivalMonster", 40, 2245, 830, 8.69, 2.14, 40, 43, 30, 21, 20, 10, 3570, 269, 509, 278, 264, 226, 278, 0, 333, 133, 0, 0, 88, 187, "NULL", 0, 0, 0, "LAST_HIT", 0, 0, 0, "fighter"),
(18079, 18079, "Witch's Offering Elder", 0, "", 0, "Monster.batur_orc_warrior_20_bi", 12, 24, 56, "male", "L2FestivalMonster", 40, 2724, 1019, 10.27, 2.45, 40, 43, 30, 21, 20, 10, 4666, 383, 706, 331, 382, 269, 278, 0, 333, 133, 0, 0, 88, 33, "NULL", 0, 0, 0, "LAST_HIT", 0, 0, 0, "fighter"),
(18080, 18080, "Witch's Offering", 0, "", 0, "Monster.batur_orc", 9, 21.5, 54, "male", "L2FestivalMonster", 40, 2562, 955, 10.27, 2.45, 40, 43, 30, 21, 20, 10, 4339, 346, 556, 266, 339, 254, 237, 0, 333, 226, 0, 0, 88, 33, "NULL", 0, 0, 0, "LAST_HIT", 0, 0, 0, "fighter"),
(18081, 18081, "Witch's Offering Archer", 0, "", 0, "Monster.batur_orc_archer", 11, 21.5, 50, "male", "L2FestivalMonster", 500, 2245, 830, 8.69, 2.14, 40, 43, 30, 21, 20, 10, 3090, 233, 1132, 236, 264, 226, 249, 0, 333, 278, 0, 0, 49, 77, "NULL", 0, 0, 0, "LAST_HIT", 0, 0, 0, "archer"),
(18082, 18082, "Witch's Offering Warrior", 0, "", 0, "Monster.batur_orc_warrior", 10, 20, 51, "male", "L2FestivalMonster", 40, 2323, 861, 10.27, 2.45, 40, 43, 30, 21, 20, 10, 3121, 238, 539, 286, 281, 232, 278, 0, 333, 72, 0, 0, 88, 132, "NULL", 0, 0, 0, "LAST_HIT", 0, 0, 0, "fighter"),
(18083, 18083, "Witch's Offering Follower", 0, "", 0, "Monster.batur_orc_shaman", 11, 16, 51, "male", "L2FestivalMonster", 40, 2323, 861, 10.27, 2.45, 40, 43, 30, 21, 20, 10, 3732, 285, 472, 243, 281, 232, 237, 0, 333, 316, 0, 0, 55, 176, "NULL", 0, 0, 0, "LAST_HIT", 0, 0, 0, "balanced"),
(18084, 18084, "Witch's Offering Berserker", 0, "", 0, "Monster.virud_lizardman_warrior", 12, 30, 59, "male", "L2FestivalMonster", 40, 2971, 1117, 10.27, 2.45, 40, 43, 30, 21, 20, 10, 5789, 495, 820, 359, 453, 291, 278, 0, 333, 301, 0, 0, 57, 137, "NULL", 0, 0, 0, "LAST_HIT", 0, 0, 0, "fighter"),
(18085, 18085, "Witch's Offering Zealot", 0, "", 0, "Monster.batur_orc_20_bi", 10, 25.3, 56, "male", "L2FestivalMonster", 40, 2724, 1019, 10.27, 2.45, 40, 43, 30, 21, 20, 10, 4478, 368, 618, 281, 382, 269, 237, 0, 333, 91, 0, 0, 88, 181, "NULL", 0, 0, 0, "LAST_HIT", 0, 0, 0, "fighter"),
(18086, 18086, "Witch's Offering Marksman", 0, "", 0, "Monster.batur_orc_archer_20_bi", 13, 25.3, 54, "male", "L2FestivalMonster", 500, 2562, 955, 10.27, 2.45, 40, 43, 30, 21, 20, 10, 3604, 287, 1413, 266, 339, 254, 249, 0, 333, 282, 0, 0, 49, 154, "NULL", 0, 0, 0, "LAST_HIT", 0, 0, 0, "archer"),
(18087, 18087, "Witch's Offering Disciple", 0, "", 0, "Monster.batur_orc_overlord", 12, 24, 56, "male", "L2FestivalMonster", 40, 2724, 1019, 10.27, 2.45, 40, 43, 30, 21, 20, 10, 4478, 368, 706, 331, 382, 269, 278, 0, 333, 135, 0, 0, 88, 192, "NULL", 0, 0, 0, "LAST_HIT", 0, 0, 0, "fighter"),
(18088, 18088, "Witch's Offering Saint", 0, "", 0, "Monster.batur_orc_overlord_20_bi", 14, 28.8, 61, "male", "L2FestivalMonster", 40, 3137, 1184, 11.85, 2.78, 40, 43, 30, 21, 20, 10, 5313, 468, 901, 378, 505, 307, 278, 0, 333, 79, 0, 0, 88, 192, "NULL", 0, 0, 0, "LAST_HIT", 0, 0, 0, "fighter"),
(18089, 18089, "Dark Omen Offering Elder", 0, "", 0, "Monster.batur_orc_warrior_20_bi", 12, 24, 67, "male", "L2FestivalMonster", 40, 3626, 1388, 11.85, 2.78, 40, 43, 30, 21, 20, 10, 6679, 636, 1169, 439, 681, 356, 278, 0, 333, 79, 0, 0, 88, 33, "NULL", 0, 0, 0, "LAST_HIT", 0, 0, 0, "fighter"),
(18090, 18090, "Dark Omen Offering", 0, "", 0, "Monster.batur_orc", 9, 21.5, 65, "male", "L2FestivalMonster", 40, 3465, 1319, 11.85, 2.78, 40, 43, 30, 21, 20, 10, 6286, 584, 942, 355, 619, 340, 237, 0, 333, 234, 0, 0, 88, 33, "NULL", 0, 0, 0, "LAST_HIT", 0, 0, 0, "balanced"),
(18091, 18091, "Dark Omen Offering Archer", 0, "", 0, "Monster.batur_orc_archer", 11, 21.5, 61, "male", "L2FestivalMonster", 500, 3137, 1184, 11.85, 2.78, 40, 43, 30, 21, 20, 10, 4599, 405, 2004, 321, 505, 307, 249, 0, 333, 283, 0, 0, 49, 77, "NULL", 0, 0, 0, "LAST_HIT", 0, 0, 0, "archer"),
(18092, 18092, "Dark Omen Offering Warrior", 0, "", 0, "Monster.batur_orc_warrior", 10, 20, 62, "male", "L2FestivalMonster", 40, 3219, 1217, 11.85, 2.78, 40, 43, 30, 21, 20, 10, 4612, 411, 944, 388, 532, 315, 278, 0, 333, 133, 0, 0, 88, 137, "NULL", 0, 0, 0, "LAST_HIT", 0, 0, 0, "fighter"),
(18093, 18093, "Dark Omen Offering Follower", 0, "", 0, "Monster.batur_orc_shaman", 11, 16, 62, "male", "L2FestivalMonster", 40, 3219, 1217, 11.85, 2.78, 40, 43, 30, 21, 20, 10, 5516, 492, 826, 330, 532, 315, 237, 0, 333, 316, 0, 0, 55, 181, "NULL", 0, 0, 0, "LAST_HIT", 0, 0, 0, "balanced"),
(18094, 18094, "Dark Omen Offering Berserker", 0, "", 0, "Monster.virud_lizardman_warrior", 12, 30, 70, "male", "L2FestivalMonster", 40, 3862, 1493, 11.85, 2.78, 40, 43, 30, 21, 20, 10, 8149, 808, 1314, 470, 780, 382, 278, 0, 333, 97, 0, 0, 57, 143, "NULL", 0, 0, 0, "LAST_HIT", 0, 0, 0, "fighter"),
(18095, 18095, "Dark Omen Offering Zealot", 0, "", 0, "Monster.batur_orc_20_bi", 10, 25.3, 67, "male", "L2FestivalMonster", 40, 3626, 1388, 11.85, 2.78, 40, 43, 30, 21, 20, 10, 6410, 610, 1023, 373, 681, 356, 237, 0, 333, 2503, 0, 0, 88, 187, "NULL", 0, 0, 0, "LAST_HIT", 0, 0, 0, "balanced"),
(18096, 18096, "Dark Omen Offering Marksman", 0, "", 0, "Monster.batur_orc_archer_20_bi", 13, 25.3, 65, "male", "L2FestivalMonster", 500, 3465, 1319, 11.85, 2.78, 40, 43, 30, 21, 20, 10, 5222, 485, 2393, 355, 619, 340, 249, 0, 333, 286, 0, 0, 49, 159, "NULL", 0, 0, 0, "LAST_HIT", 0, 0, 0, "archer"),
(18097, 18097, "Dark Omen Offering Disciple", 0, "", 0, "Monster.batur_orc_overlord", 12, 24, 67, "male", "L2FestivalMonster", 40, 3626, 1388, 11.85, 2.78, 40, 43, 30, 21, 20, 10, 6410, 610, 1169, 439, 681, 356, 278, 0, 333, 142, 0, 0, 88, 198, "NULL", 0, 0, 0, "LAST_HIT", 0, 0, 0, "fighter"),
(18098, 18098, "Dark Omen Offering Saint", 0, "", 0, "Monster.batur_orc_overlord_20_bi", 14, 28.8, 72, "male", "L2FestivalMonster", 40, 4013, 1565, 13.43, 3.09, 40, 43, 30, 21, 20, 10, 7402, 752, 1413, 491, 849, 399, 278, 0, 333, 2500, 0, 0, 88, 198, "NULL", 0, 0, 0, "LAST_HIT", 0, 0, 0, "fighter"),
(18099, 18099, "Offering of Forbidden Path Elder", 0, "", 0, "Monster.batur_orc_overlord_20_bi", 14, 28.8, 78, "male", "L2FestivalMonster", 40, 4428, 1784, 13.43, 3.09, 40, 43, 30, 21, 20, 10, 9052, 991, 1715, 555, 1069, 451, 278, 0, 333, 2500, 0, 0, 88, 33, "NULL", 0, 0, 0, "LAST_HIT", 0, 0, 0, "fighter"),
(18100, 18100, "Offering of Forbidden Path", 0, "", 0, "Monster.batur_orc_warrior", 10, 20, 76, "male", "L2FestivalMonster", 40, 4297, 1710, 13.43, 3.09, 40, 43, 30, 21, 20, 10, 8594, 919, 1412, 454, 994, 433, 237, 0, 333, 236, 0, 0, 88, 33, "NULL", 0, 0, 0, "LAST_HIT", 0, 0, 0, "balanced"),
(18101, 18101, "Offering of Forbidden Path Archer", 0, "", 0, "Monster.ketra_orc_archer", 12, 27, 80, "male", "L2FestivalMonster", 500, 4663, 1934, 13.43, 3.09, 40, 43, 30, 21, 20, 10, 8310, 955, 4248, 508, 1220, 485, 249, 0, 333, 287, 0, 0, 49, 77, "NULL", 0, 0, 0, "LAST_HIT", 0, 0, 0, "archer"),
(18102, 18102, "Offering of Forbidden Path Warrior", 0, "", 0, "Monster.ketra_orc_warrior", 12, 24, 80, "male", "L2FestivalMonster", 40, 4550, 1859, 13.43, 3.09, 40, 43, 30, 21, 20, 10, 7680, 862, 1814, 576, 1144, 468, 278, 0, 333, 79, 0, 0, 39, 143, "NULL", 0, 0, 0, "LAST_HIT", 0, 0, 0, "fighter"),
(18103, 18103, "Offering of Forbidden Path Follower", 0, "", 0, "Monster.ketra_orc_shaman", 10, 23, 80, "male", "L2FestivalMonster", 40, 4550, 1859, 13.43, 3.09, 40, 43, 30, 21, 20, 10, 9185, 1031, 1587, 490, 1144, 468, 237, 0, 333, 316, 0, 0, 11, 198, "NULL", 0, 0, 0, "LAST_HIT", 0, 0, 0, "balanced"),
(18104, 18104, "Offering of Forbidden Path Berserker", 0, "", 0, "Monster.zenta_lizardman_warrior", 13, 35, 80, "male", "L2FestivalMonster", 40, 4608, 1896, 13.43, 3.09, 40, 43, 30, 21, 20, 10, 10912, 1239, 1863, 587, 1182, 477, 278, 0, 333, 305, 0, 0, 44, 148, "NULL", 0, 0, 0, "LAST_HIT", 0, 0, 0, "fighter"),
(18105, 18105, "Offering of Forbidden Path Zealot", 0, "", 0, "Monster.ketra_orc_20_bi", 14, 34.8, 78, "male", "L2FestivalMonster", 40, 4428, 1784, 13.43, 3.09, 40, 43, 30, 21, 20, 10, 8687, 951, 1500, 472, 1069, 451, 237, 0, 333, 175, 0, 0, 49, 214, "NULL", 0, 0, 0, "LAST_HIT", 0, 0, 0, "balanced"),
(18106, 18106, "Offering of Forbidden Path Marksman", 0, "", 0, "Monster.ketra_orc_archer_20_bi", 14, 32.4, 76, "male", "L2FestivalMonster", 500, 4297, 1710, 13.43, 3.09, 40, 43, 30, 21, 20, 10, 7139, 763, 3587, 454, 994, 433, 249, 0, 333, 289, 0, 0, 49, 165, "NULL", 0, 0, 0, "LAST_HIT", 0, 0, 0, "archer"),
(18107, 18107, "Offering of Forbidden Path Disciple", 0, "", 0, "Monster.ketra_orc_overload", 12, 24, 78, "male", "L2FestivalMonster", 40, 4428, 1784, 13.43, 3.09, 40, 43, 30, 21, 20, 10, 8687, 951, 1715, 555, 1069, 451, 278, 0, 333, 151, 0, 0, 36, 214, "NULL", 0, 0, 0, "LAST_HIT", 0, 0, 0, "fighter"),
(18108, 18108, "Offering of Forbidden Path Saint", 0, "", 0, "Monster.ketra_orc_overload_20_bi", 14, 28.8, 83, "male", "L2FestivalMonster", 40, 4716, 1972, 13.43, 3.09, 40, 43, 30, 21, 20, 10, 9837, 1144, 1959, 608, 1258, 494, 278, 0, 333, 2500, 0, 0, 36, 214, "NULL", 0, 0, 0, "LAST_HIT", 0, 0, 0, "fighter"),
(18109, 18109, "Treasures of the Festival", 0, "", 0, "Monster.mimic", 8.5, 8.5, 30, "male", "L2FestivalMonster", 0, 999, 365, 5.53, 1.53, 40, 43, 30, 21, 20, 10, 90, 0, 0, 140, 0, 114, 0, 0, 0, 0, 0, 0, 88, 214, "NULL", 0, 0, 0, "LAST_HIT", 0, 0, 0, "fighter"),
(18110, 18110, "Treasures of the Festival", 0, "", 0, "Monster.mimic", 8.5, 8.5, 41, "male", "L2FestivalMonster", 0, 1488, 560, 8.69, 2.14, 40, 43, 30, 21, 20, 10, 168, 0, 0, 208, 0, 169, 0, 0, 0, 0, 0, 0, 88, 214, "NULL", 0, 0, 0, "LAST_HIT", 0, 0, 0, "fighter"),
(18111, 18111, "Treasures of the Festival", 0, "", 0, "Monster.mimic", 8.5, 8.5, 52, "male", "L2FestivalMonster", 0, 2058, 892, 10.27, 2.45, 40, 43, 30, 21, 20, 10, 270, 0, 0, 295, 0, 239, 0, 0, 0, 0, 0, 0, 88, 214, "NULL", 0, 0, 0, "LAST_HIT", 0, 0, 0, "fighter"),
(18112, 18112, "Treasures of the Festival", 0, "", 0, "Monster.mimic", 8.5, 8.5, 63, "male", "L2FestivalMonster", 0, 2640, 1251, 11.85, 2.78, 40, 43, 30, 21, 20, 10, 396, 0, 0, 398, 0, 323, 0, 0, 0, 0, 0, 0, 88, 214, "NULL", 0, 0, 0, "LAST_HIT", 0, 0, 0, "fighter"),
(18113, 18113, "Treasures of the Festival", 0, "", 0, "Monster.mimic", 8.5, 8.5, 72, "male", "L2FestivalMonster", 0, 3063, 1565, 13.43, 3.09, 40, 43, 30, 21, 20, 10, 518, 0, 0, 491, 0, 399, 0, 0, 0, 0, 0, 0, 88, 214, "NULL", 0, 0, 0, "LAST_HIT", 0, 0, 0, "fighter"),
(18114, 18114, "Treasures of the Festival", 0, "", 0, "Monster.mimic", 8.5, 8.5, 30, "male", "L2FestivalMonster", 0, 999, 365, 5.53, 1.53, 40, 43, 30, 21, 20, 10, 90, 0, 0, 140, 0, 114, 0, 0, 0, 0, 0, 0, 88, 214, "NULL", 0, 0, 0, "LAST_HIT", 0, 0, 0, "fighter"),
(18115, 18115, "Treasures of the Festival", 0, "", 0, "Monster.mimic", 8.5, 8.5, 41, "male", "L2FestivalMonster", 0, 1488, 560, 8.69, 2.14, 40, 43, 30, 21, 20, 10, 168, 0, 0, 208, 0, 169, 0, 0, 0, 0, 0, 0, 88, 214, "NULL", 0, 0, 0, "LAST_HIT", 0, 0, 0, "fighter"),
(18116, 18116, "Treasures of the Festival", 0, "", 0, "Monster.mimic", 8.5, 8.5, 52, "male", "L2FestivalMonster", 0, 2058, 892, 10.27, 2.45, 40, 43, 30, 21, 20, 10, 270, 0, 0, 295, 0, 239, 0, 0, 0, 0, 0, 0, 88, 214, "NULL", 0, 0, 0, "LAST_HIT", 0, 0, 0, "fighter"),
(18117, 18117, "Treasures of the Festival", 0, "", 0, "Monster.mimic", 8.5, 8.5, 63, "male", "L2FestivalMonster", 0, 2640, 1251, 11.85, 2.78, 40, 43, 30, 21, 20, 10, 396, 0, 0, 398, 0, 323, 0, 0, 0, 0, 0, 0, 88, 214, "NULL", 0, 0, 0, "LAST_HIT", 0, 0, 0, "fighter"),
(18118, 18118, "Treasures of the Festival", 0, "", 0, "Monster.mimic", 8.5, 8.5, 72, "male", "L2FestivalMonster", 0, 3063, 1565, 13.43, 3.09, 40, 43, 30, 21, 20, 10, 518, 0, 0, 491, 0, 399, 0, 0, 0, 0, 0, 0, 88, 214, "NULL", 0, 0, 0, "LAST_HIT", 0, 0, 0, "fighter"),
(18119, 18119, "Corpse of Deadman", 0, "", 0, "Monster.zombie_corpse", 13, 21, 63, "male", "L2Monster", 40, 3302, 1251, 11.85, 2.78, 40, 43, 30, 21, 20, 10, 0, 0, 987, 398, 560, 323, 278, 0, 333, 0, 0, 0, 15, 1, "NULL", 0, 1, 0, "LAST_HIT", 0, 0, 0, "fighter"),
(18120, 18120, "Halisha's Officer", 0, "", 0, "Monster2.imperial_warlord_zombie_20_bi", 9, 36, 81, "male", "L2Monster", 40, 4608, 1896, 80.58, 3.09, 40, 43, 30, 21, 20, 10, 9764, 1108, 2255, 534, 1731, 433, 278, 0, 333, 134, 6721, 0, 42, 165, "tomb1_clan", 600, 1, 0, "LAST_HIT", 0, 0, 0, "balanced"),
(18121, 18121, "Halisha's Officer", 0, "", 0, "Monster2.imperial_warlord_zombie_20_bi", 9, 36, 81, "male", "L2Monster", 40, 4608, 1896, 80.58, 3.09, 40, 43, 30, 21, 20, 10, 9260, 1051, 1694, 710, 977, 577, 278, 0, 333, 134, 6721, 0, 42, 165, "tomb1_clan", 600, 1, 0, "LAST_HIT", 0, 0, 0, "fighter"),
(18122, 18122, "Halisha's Officer", 0, "", 0, "Monster2.imperial_warlord_zombie_20_bi", 9, 36, 81, "male", "L2Monster", 40, 4608, 1896, 80.58, 3.09, 40, 43, 30, 21, 20, 10, 7072, 803, 1863, 587, 1182, 477, 278, 0, 333, 134, 6721, 0, 42, 165, "tomb1_clan", 600, 1, 0, "LAST_HIT", 0, 0, 0, "fighter"),
(18123, 18123, "Halisha's Officer", 0, "", 0, "Monster2.imperial_warlord_zombie_20_bi", 9, 36, 81, "male", "L2Monster", 40, 4608, 1896, 80.58, 3.09, 40, 43, 30, 21, 20, 10, 9764, 1108, 2255, 534, 1731, 433, 278, 0, 333, 134, 6721, 0, 42, 165, "tomb1_clan", 600, 1, 0, "LAST_HIT", 0, 0, 0, "balanced"),
(18124, 18124, "Halisha's Officer", 0, "", 0, "Monster2.imperial_warlord_zombie_20_bi", 9, 36, 81, "male", "L2Monster", 40, 4608, 1896, 80.58, 3.09, 40, 43, 30, 21, 20, 10, 9260, 1051, 1694, 710, 977, 577, 278, 0, 333, 134, 6721, 0, 42, 165, "tomb1_clan", 600, 1, 0, "LAST_HIT", 0, 0, 0, "fighter"),
(18125, 18125, "Halisha's Officer", 0, "", 0, "Monster2.imperial_warlord_zombie_20_bi", 9, 36, 81, "male", "L2Monster", 40, 4608, 1896, 80.58, 3.09, 40, 43, 30, 21, 20, 10, 7072, 803, 1863, 587, 1182, 477, 278, 0, 333, 134, 6721, 0, 42, 165, "tomb1_clan", 600, 1, 0, "LAST_HIT", 0, 0, 0, "fighter"),
(18126, 18126, "Halisha's Officer", 0, "", 0, "Monster2.imperial_warlord_zombie_20_bi", 9, 36, 81, "male", "L2Monster", 40, 4608, 1896, 80.58, 3.09, 40, 43, 30, 21, 20, 10, 9764, 1108, 2255, 534, 1731, 433, 278, 0, 333, 134, 6721, 0, 42, 165, "tomb1_clan", 600, 1, 0, "LAST_HIT", 0, 0, 0, "balanced"),
(18127, 18127, "Halisha's Officer", 0, "", 0, "Monster2.imperial_warlord_zombie_20_bi", 9, 36, 81, "male", "L2Monster", 40, 4608, 1896, 80.58, 3.09, 40, 43, 30, 21, 20, 10, 9260, 1051, 1694, 710, 977, 577, 278, 0, 333, 134, 6721, 0, 42, 165, "tomb1_clan", 600, 1, 0, "LAST_HIT", 0, 0, 0, "fighter"),
(18128, 18128, "Halisha's Officer", 0, "", 0, "Monster2.imperial_warlord_zombie_20_bi", 9, 36, 81, "male", "L2Monster", 40, 4608, 1896, 80.58, 3.09, 40, 43, 30, 21, 20, 10, 7072, 803, 1863, 587, 1182, 477, 278, 0, 333, 134, 6721, 0, 42, 165, "tomb1_clan", 600, 1, 0, "LAST_HIT", 0, 0, 0, "fighter"),
(18129, 18129, "Halisha's Officer", 0, "", 0, "Monster2.imperial_warlord_zombie_20_bi", 9, 36, 81, "male", "L2Monster", 40, 4608, 1896, 80.58, 3.09, 40, 43, 30, 21, 20, 10, 9764, 1108, 2255, 534, 1731, 433, 278, 0, 333, 134, 6721, 0, 42, 165, "tomb1_clan", 600, 1, 0, "LAST_HIT", 0, 0, 0, "balanced"),
(18130, 18130, "Halisha's Officer", 0, "", 0, "Monster2.imperial_warlord_zombie_20_bi", 9, 36, 81, "male", "L2Monster", 40, 4608, 1896, 80.58, 3.09, 40, 43, 30, 21, 20, 10, 9260, 1051, 1694, 710, 977, 577, 278, 0, 333, 134, 6721, 0, 42, 165, "tomb1_clan", 600, 1, 0, "LAST_HIT", 0, 0, 0, "fighter"),
(18131, 18131, "Halisha's Officer", 0, "", 0, "Monster2.imperial_warlord_zombie_20_bi", 9, 36, 81, "male", "L2Monster", 40, 4608, 1896, 80.58, 3.09, 40, 43, 30, 21, 20, 10, 7072, 803, 1863, 587, 1182, 477, 278, 0, 333, 134, 6721, 0, 42, 165, "tomb1_clan", 600, 1, 0, "LAST_HIT", 0, 0, 0, "fighter"),
(18132, 18132, "Imperial Healer", 0, "", 0, "Monster2.tera_beetle", 19, 54.5, 81, "male", "L2Monster", 40, 4608, 1896, 80.58, 3.09, 40, 43, 30, 21, 20, 10, 9949, 1129, 1540, 782, 807, 635, 278, 0, 333, 0, 0, 0, 49, 187, "tomb1_clan", 600, 0, 0, "LAST_HIT", 0, 0, 0, "fighter"),
(18133, 18133, "Imperial Mosaic", 0, "", 0, "Monster2.scorpion", 28, 66, 81, "male", "L2Monster", 40, 4608, 1896, 80.58, 3.09, 40, 43, 30, 21, 20, 10, 9190, 1043, 1630, 587, 1182, 477, 237, 0, 333, 0, 0, 0, 40, 187, "tomb1_clan", 600, 0, 0, "LAST_HIT", 0, 0, 0, "balanced"),
(18134, 18134, "Imperial Mosaic", 0, "", 0, "Monster2.scorpion", 28, 66, 81, "male", "L2Monster", 40, 4608, 1896, 80.58, 3.09, 40, 43, 30, 21, 20, 10, 6906, 784, 1630, 587, 1182, 477, 237, 0, 333, 0, 0, 0, 40, 187, "tomb1_clan", 600, 0, 0, "LAST_HIT", 0, 0, 0, "balanced"),
(18135, 18135, "Imperial Mosaic", 0, "", 0, "Monster2.scorpion", 28, 66, 81, "male", "L2Monster", 40, 4608, 1896, 80.58, 3.09, 40, 43, 30, 21, 20, 10, 9149, 1039, 1630, 587, 1182, 477, 237, 0, 333, 0, 0, 0, 40, 187, "tomb1_clan", 600, 0, 0, "LAST_HIT", 0, 0, 0, "balanced"),
(18136, 18136, "Imperial Mosaic", 0, "", 0, "Monster2.scorpion", 28, 66, 81, "male", "L2Monster", 40, 4608, 1896, 80.58, 3.09, 40, 43, 30, 21, 20, 10, 9190, 1043, 1482, 710, 977, 577, 237, 0, 333, 0, 0, 0, 40, 187, "tomb1_clan", 600, 0, 0, "LAST_HIT", 0, 0, 0, "balanced"),
(18137, 18137, "Imperial Mosaic", 0, "", 0, "Monster2.scarab", 14, 22, 81, "male", "L2Monster", 40, 4608, 1896, 80.58, 3.09, 40, 43, 30, 21, 20, 10, 6812, 773, 1863, 587, 1182, 477, 278, 0, 333, 0, 0, 0, 49, 198, "tomb1_clan", 600, 0, 0, "LAST_HIT", 0, 0, 0, "fighter"),
(18138, 18138, "Imperial Mosaic", 0, "", 0, "Monster2.scarab", 14, 22, 81, "male", "L2Monster", 40, 4608, 1896, 80.58, 3.09, 40, 43, 30, 21, 20, 10, 9069, 1029, 1863, 587, 1182, 477, 278, 0, 333, 0, 0, 0, 49, 198, "tomb1_clan", 600, 0, 0, "LAST_HIT", 0, 0, 0, "fighter"),
(18139, 18139, "Imperial Mosaic", 0, "", 0, "Monster2.scarab", 14, 22, 81, "male", "L2Monster", 40, 4608, 1896, 80.58, 3.09, 40, 43, 30, 21, 20, 10, 8935, 1014, 1863, 587, 1182, 477, 278, 0, 333, 0, 0, 0, 49, 198, "tomb1_clan", 600, 0, 0, "LAST_HIT", 0, 0, 0, "fighter"),
(18140, 18140, "Imperial Mosaic", 0, "", 0, "Monster2.scarab", 14, 22, 81, "male", "L2Monster", 40, 4608, 1896, 80.58, 3.09, 40, 43, 30, 21, 20, 10, 9065, 1029, 1694, 710, 977, 577, 278, 0, 333, 0, 0, 0, 49, 198, "tomb1_clan", 600, 0, 0, "LAST_HIT", 0, 0, 0, "fighter"),
(18141, 18141, "Beetle of Grave", 0, "", 0, "Monster2.scarab", 14, 22, 81, "male", "L2Monster", 40, 4608, 1896, 53.72, 3.09, 40, 43, 30, 21, 20, 10, 8745, 993, 3001, 401, 3068, 325, 278, 0, 333, 0, 0, 0, 49, 198, "tomb2_clan", 600, 0, 0, "LAST_HIT", 0, 0, 0, "balanced"),
(18142, 18142, "Beetle of Grave", 0, "", 0, "Monster2.scarab", 14, 22, 81, "male", "L2Monster", 40, 4608, 1896, 53.72, 3.09, 40, 43, 30, 21, 20, 10, 8745, 993, 3001, 401, 3068, 325, 278, 0, 333, 0, 0, 0, 49, 198, "tomb2_clan", 600, 0, 0, "LAST_HIT", 0, 0, 0, "balanced"),
(18143, 18143, "Beetle of Grave", 0, "", 0, "Monster2.scarab", 14, 22, 81, "male", "L2Monster", 40, 4608, 1896, 53.72, 3.09, 40, 43, 30, 21, 20, 10, 8745, 993, 3001, 401, 3068, 325, 278, 0, 333, 0, 0, 0, 49, 198, "tomb2_clan", 600, 0, 0, "LAST_HIT", 0, 0, 0, "balanced"),
(18144, 18144, "Beetle of Grave", 0, "", 0, "Monster2.scarab", 14, 22, 81, "male", "L2Monster", 40, 4608, 1896, 53.72, 3.09, 40, 43, 30, 21, 20, 10, 8745, 993, 3001, 401, 3068, 325, 278, 0, 333, 0, 0, 0, 49, 198, "tomb2_clan", 600, 0, 0, "LAST_HIT", 0, 0, 0, "balanced"),
(18145, 18145, "Beetle of Grave", 0, "", 0, "Monster2.scarab", 14, 22, 81, "male", "L2Monster", 40, 4608, 1896, 53.72, 3.09, 40, 43, 30, 21, 20, 10, 7399, 840, 2480, 485, 2095, 394, 278, 0, 333, 0, 0, 0, 49, 198, "tomb2_clan", 600, 0, 0, "LAST_HIT", 0, 0, 0, "balanced"),
(18146, 18146, "Beetle of Grave", 0, "", 0, "Monster2.scarab", 14, 22, 81, "male", "L2Monster", 40, 4608, 1896, 53.72, 3.09, 40, 43, 30, 21, 20, 10, 7568, 859, 2480, 485, 2095, 394, 278, 0, 333, 0, 0, 0, 49, 198, "tomb2_clan", 600, 0, 0, "LAST_HIT", 0, 0, 0, "balanced"),
(18147, 18147, "Beetle of Grave", 0, "", 0, "Monster2.scarab", 14, 22, 81, "male", "L2Monster", 40, 4608, 1896, 53.72, 3.09, 40, 43, 30, 21, 20, 10, 7046, 800, 2480, 485, 2095, 394, 278, 0, 333, 0, 0, 0, 49, 198, "tomb2_clan", 600, 0, 0, "LAST_HIT", 0, 0, 0, "balanced"),
(18148, 18148, "Beetle of Grave", 0, "", 0, "Monster2.scarab", 14, 22, 81, "male", "L2Monster", 40, 4608, 1896, 53.72, 3.09, 40, 43, 30, 21, 20, 10, 8203, 931, 2480, 485, 2095, 394, 278, 0, 333, 0, 0, 0, 49, 198, "tomb2_clan", 600, 0, 0, "LAST_HIT", 0, 0, 0, "balanced"),
(18149, 18149, "Beetle of Grave", 0, "", 0, "Monster2.scarab", 14, 22, 81, "male", "L2Monster", 40, 4608, 1896, 53.72, 3.09, 40, 43, 30, 21, 20, 10, 7247, 823, 2480, 485, 2095, 394, 278, 0, 333, 0, 0, 0, 49, 198, "tomb2_clan", 600, 0, 0, "LAST_HIT", 0, 0, 0, "balanced"),
(18150, 18150, "Victim", 0, "", 0, "NPC.a_tombkeeperA", 8, 23, 81, "female", "L2Monster", 40, 4608, 1896, 13.43, 3.09, 40, 43, 30, 21, 20, 10, 0, 0, 1863, 587, 1182, 477, 278, 0, 333, 0, 0, 0, 55, 110, "tomb3_clan", 600, 1, 0, "LAST_HIT", 0, 0, 0, "fighter"),
(18151, 18151, "Victim", 0, "", 0, "NPC.a_tombkeeperA", 8, 23, 81, "female", "L2Monster", 40, 4608, 1896, 13.43, 3.09, 40, 43, 30, 21, 20, 10, 0, 0, 1863, 587, 1182, 477, 278, 0, 333, 0, 0, 0, 55, 110, "tomb3_clan", 600, 1, 0, "LAST_HIT", 0, 0, 0, "fighter"),
(18152, 18152, "Victim", 0, "", 0, "NPC.a_tombkeeperA", 8, 23, 81, "female", "L2Monster", 40, 4608, 1896, 13.43, 3.09, 40, 43, 30, 21, 20, 10, 0, 0, 1863, 587, 1182, 477, 278, 0, 333, 0, 0, 0, 55, 110, "tomb3_clan", 600, 1, 0, "LAST_HIT", 0, 0, 0, "fighter"),
(18153, 18153, "Victim", 0, "", 0, "NPC.a_tombkeeperA", 8, 23, 81, "female", "L2Monster", 40, 4608, 1896, 13.43, 3.09, 40, 43, 30, 21, 20, 10, 0, 0, 1863, 587, 1182, 477, 278, 0, 333, 0, 0, 0, 55, 110, "tomb3_clan", 600, 1, 0, "LAST_HIT", 0, 0, 0, "fighter"),
(18154, 18154, "Victim", 0, "", 0, "NPC.a_tombkeeperA", 8, 23, 81, "female", "L2Monster", 40, 4608, 1896, 13.43, 3.09, 40, 43, 30, 21, 20, 10, 0, 0, 1863, 587, 1182, 477, 278, 0, 333, 0, 0, 0, 55, 110, "tomb3_clan", 600, 1, 0, "LAST_HIT", 0, 0, 0, "fighter"),
(18155, 18155, "Victim", 0, "", 0, "NPC.a_tombkeeperA", 8, 23, 81, "female", "L2Monster", 40, 4608, 1896, 13.43, 3.09, 40, 43, 30, 21, 20, 10, 0, 0, 1863, 587, 1182, 477, 278, 0, 333, 0, 0, 0, 55, 110, "tomb3_clan", 600, 1, 0, "LAST_HIT", 0, 0, 0, "fighter"),
(18156, 18156, "Victim", 0, "", 0, "NPC.a_tombkeeperA", 8, 23, 81, "female", "L2Monster", 40, 4608, 1896, 13.43, 3.09, 40, 43, 30, 21, 20, 10, 0, 0, 1863, 587, 1182, 477, 278, 0, 333, 0, 0, 0, 55, 110, "tomb3_clan", 600, 1, 0, "LAST_HIT", 0, 0, 0, "fighter"),
(18157, 18157, "Victim", 0, "", 0, "NPC.a_tombkeeperA", 8, 23, 81, "female", "L2Monster", 40, 4608, 1896, 13.43, 3.09, 40, 43, 30, 21, 20, 10, 0, 0, 1863, 587, 1182, 477, 278, 0, 333, 0, 0, 0, 55, 110, "tomb3_clan", 600, 1, 0, "LAST_HIT", 0, 0, 0, "fighter"),
(18158, 18158, "Executioner of Halisha", 0, "", 0, "Monster2.erinyes", 21, 50, 81, "male", "L2Monster", 40, 4608, 1896, 80.58, 3.09, 40, 43, 30, 21, 20, 10, 0, 0, 2255, 534, 1731, 433, 278, 0, 333, 0, 0, 0, 34, 165, "tomb3_clan", 600, 0, 0, "LAST_HIT", 0, 0, 0, "balanced"),
(18159, 18159, "Executioner of Halisha", 0, "", 0, "Monster2.erinyes", 21, 50, 81, "male", "L2Monster", 40, 4608, 1896, 80.58, 3.09, 40, 43, 30, 21, 20, 10, 0, 0, 2255, 534, 1731, 433, 278, 0, 333, 0, 0, 0, 34, 165, "tomb3_clan", 600, 0, 0, "LAST_HIT", 0, 0, 0, "balanced"),
(18160, 18160, "Executioner of Halisha", 0, "", 0, "Monster2.erinyes", 21, 50, 81, "male", "L2Monster", 40, 4608, 1896, 80.58, 3.09, 40, 43, 30, 21, 20, 10, 0, 0, 2255, 534, 1731, 433, 278, 0, 333, 0, 0, 0, 34, 165, "tomb3_clan", 600, 0, 0, "LAST_HIT", 0, 0, 0, "balanced"),
(18161, 18161, "Executioner of Halisha", 0, "", 0, "Monster2.erinyes", 21, 50, 81, "male", "L2Monster", 40, 4608, 1896, 80.58, 3.09, 40, 43, 30, 21, 20, 10, 0, 0, 2255, 534, 1731, 433, 278, 0, 333, 0, 0, 0, 34, 165, "tomb3_clan", 600, 0, 0, "LAST_HIT", 0, 0, 0, "balanced"),
(18162, 18162, "Executioner of Halisha", 0, "", 0, "Monster2.erinyes", 21, 50, 81, "male", "L2Monster", 40, 4608, 1896, 80.58, 3.09, 40, 43, 30, 21, 20, 10, 0, 0, 2255, 534, 1731, 433, 278, 0, 333, 0, 0, 0, 34, 165, "tomb3_clan", 600, 0, 0, "LAST_HIT", 0, 0, 0, "balanced"),
(18163, 18163, "Executioner of Halisha", 0, "", 0, "Monster2.erinyes", 21, 50, 81, "male", "L2Monster", 40, 4608, 1896, 80.58, 3.09, 40, 43, 30, 21, 20, 10, 0, 0, 2255, 534, 1731, 433, 278, 0, 333, 0, 0, 0, 34, 165, "tomb3_clan", 600, 0, 0, "LAST_HIT", 0, 0, 0, "balanced"),
(18164, 18164, "Executioner of Halisha", 0, "", 0, "Monster2.erinyes", 21, 50, 81, "male", "L2Monster", 40, 4608, 1896, 80.58, 3.09, 40, 43, 30, 21, 20, 10, 0, 0, 2255, 534, 1731, 433, 278, 0, 333, 0, 0, 0, 34, 165, "tomb3_clan", 600, 0, 0, "LAST_HIT", 0, 0, 0, "balanced"),
(18165, 18165, "Executioner of Halisha", 0, "", 0, "Monster2.erinyes", 21, 50, 81, "male", "L2Monster", 40, 4608, 1896, 80.58, 3.09, 40, 43, 30, 21, 20, 10, 0, 0, 2255, 534, 1731, 433, 278, 0, 333, 0, 0, 0, 34, 165, "tomb3_clan", 600, 0, 0, "LAST_HIT", 0, 0, 0, "balanced"),
(18166, 18166, "Imperial Guard", 0, "", 0, "Monster.death_knight", 12, 31, 81, "male", "L2Monster", 40, 4608, 1896, 80.58, 3.09, 40, 43, 30, 21, 20, 10, 7005, 795, 2255, 534, 1731, 433, 278, 0, 333, 142, 0, 0, 29, 121, "tomb3_clan", 600, 1, 0, "LAST_HIT", 0, 0, 0, "balanced"),
(18167, 18167, "Imperial Guard", 0, "", 0, "Monster.death_knight", 12, 31, 81, "male", "L2Monster", 40, 4608, 1896, 80.58, 3.09, 40, 43, 30, 21, 20, 10, 6906, 784, 1694, 710, 977, 577, 278, 0, 333, 142, 0, 0, 29, 121, "tomb3_clan", 600, 1, 0, "LAST_HIT", 0, 0, 0, "fighter"),
(18168, 18168, "Imperial Guard", 0, "", 0, "Monster.death_knight", 12, 31, 81, "male", "L2Monster", 40, 4608, 1896, 80.58, 3.09, 40, 43, 30, 21, 20, 10, 7099, 806, 1863, 587, 1182, 477, 278, 0, 333, 142, 0, 0, 29, 121, "tomb3_clan", 600, 1, 0, "LAST_HIT", 0, 0, 0, "fighter"),
(18169, 18169, "Imperial Guard", 0, "", 0, "Monster.death_knight", 12, 31, 81, "male", "L2Monster", 40, 4608, 1896, 80.58, 3.09, 40, 43, 30, 21, 20, 10, 6872, 780, 1694, 710, 977, 577, 278, 0, 333, 142, 0, 0, 29, 121, "tomb3_clan", 600, 1, 0, "LAST_HIT", 0, 0, 0, "fighter"),
(18170, 18170, "Imperial Guard", 0, "", 0, "Monster.doll_master", 20, 42, 81, "male", "L2Monster", 40, 4608, 1896, 80.58, 3.09, 40, 43, 30, 21, 20, 10, 6879, 781, 2170, 485, 2095, 394, 237, 0, 333, 0, 0, 0, 88, 176, "tomb3_clan", 600, 1, 0, "LAST_HIT", 0, 0, 0, "balanced"),
(18171, 18171, "Imperial Guard", 0, "", 0, "Monster.doll_master", 20, 42, 81, "male", "L2Monster", 40, 4608, 1896, 80.58, 3.09, 40, 43, 30, 21, 20, 10, 7147, 811, 1347, 782, 807, 635, 237, 0, 333, 0, 0, 0, 88, 176, "tomb3_clan", 600, 1, 0, "LAST_HIT", 0, 0, 0, "fighter"),
(18172, 18172, "Imperial Guard", 0, "", 0, "Monster.doll_master", 20, 42, 81, "male", "L2Monster", 40, 4608, 1896, 80.58, 3.09, 40, 43, 30, 21, 20, 10, 6812, 773, 1630, 587, 1182, 477, 237, 0, 333, 0, 0, 0, 88, 176, "tomb3_clan", 600, 1, 0, "LAST_HIT", 0, 0, 0, "balanced"),
(18173, 18173, "Halisha's Foreman", 0, "", 0, "Monster.kaim_vanul", 24, 40, 81, "male", "L2Monster", 40, 4608, 1896, 80.58, 3.09, 40, 43, 30, 21, 20, 10, 9321, 1058, 2255, 534, 1731, 433, 278, 0, 333, 0, 0, 0, 40, 176, "tomb4_clan", 600, 0, 0, "LAST_HIT", 0, 0, 0, "balanced"),
(18174, 18174, "Halisha's Foreman", 0, "", 0, "Monster.kaim_vanul", 24, 40, 81, "male", "L2Monster", 40, 4608, 1896, 80.58, 3.09, 40, 43, 30, 21, 20, 10, 9321, 1058, 2255, 534, 1731, 433, 278, 0, 333, 0, 0, 0, 40, 176, "tomb4_clan", 600, 0, 0, "LAST_HIT", 0, 0, 0, "balanced"),
(18175, 18175, "Halisha's Foreman", 0, "", 0, "Monster.kaim_vanul", 24, 40, 81, "male", "L2Monster", 40, 4608, 1896, 80.58, 3.09, 40, 43, 30, 21, 20, 10, 9321, 1058, 2255, 534, 1731, 433, 278, 0, 333, 0, 0, 0, 40, 176, "tomb4_clan", 600, 0, 0, "LAST_HIT", 0, 0, 0, "balanced"),
(18176, 18176, "Halisha's Foreman", 0, "", 0, "Monster.kaim_vanul", 24, 40, 81, "male", "L2Monster", 40, 4608, 1896, 80.58, 3.09, 40, 43, 30, 21, 20, 10, 9321, 1058, 2255, 534, 1731, 433, 278, 0, 333, 0, 0, 0, 40, 176, "tomb4_clan", 600, 0, 0, "LAST_HIT", 0, 0, 0, "balanced"),
(18177, 18177, "Halisha's Foreman", 0, "", 0, "Monster.kaim_vanul", 24, 40, 81, "male", "L2Monster", 40, 4608, 1896, 80.58, 3.09, 40, 43, 30, 21, 20, 10, 9321, 1058, 2255, 534, 1731, 433, 278, 0, 333, 0, 0, 0, 40, 176, "tomb4_clan", 600, 0, 0, "LAST_HIT", 0, 0, 0, "balanced"),
(18178, 18178, "Halisha's Foreman", 0, "", 0, "Monster.kaim_vanul", 24, 40, 81, "male", "L2Monster", 40, 4608, 1896, 80.58, 3.09, 40, 43, 30, 21, 20, 10, 9321, 1058, 2255, 534, 1731, 433, 278, 0, 333, 0, 0, 0, 40, 176, "tomb4_clan", 600, 0, 0, "LAST_HIT", 0, 0, 0, "balanced"),
(18179, 18179, "Halisha's Foreman", 0, "", 0, "Monster.kaim_vanul", 24, 40, 81, "male", "L2Monster", 40, 4608, 1896, 80.58, 3.09, 40, 43, 30, 21, 20, 10, 9321, 1058, 2255, 534, 1731, 433, 278, 0, 333, 0, 0, 0, 40, 176, "tomb4_clan", 600, 0, 0, "LAST_HIT", 0, 0, 0, "balanced"),
(18180, 18180, "Halisha's Foreman", 0, "", 0, "Monster.kaim_vanul", 24, 40, 81, "male", "L2Monster", 40, 4608, 1896, 80.58, 3.09, 40, 43, 30, 21, 20, 10, 9321, 1058, 2255, 534, 1731, 433, 278, 0, 333, 0, 0, 0, 40, 176, "tomb4_clan", 600, 0, 0, "LAST_HIT", 0, 0, 0, "balanced"),
(18181, 18181, "Halisha's Foreman", 0, "", 0, "Monster.kaim_vanul", 24, 40, 81, "male", "L2Monster", 40, 4608, 1896, 80.58, 3.09, 40, 43, 30, 21, 20, 10, 9321, 1058, 2255, 534, 1731, 433, 278, 0, 333, 0, 0, 0, 40, 176, "tomb4_clan", 600, 0, 0, "LAST_HIT", 0, 0, 0, "balanced"),
(18182, 18182, "Halisha's Foreman", 0, "", 0, "Monster.kaim_vanul", 24, 40, 81, "male", "L2Monster", 40, 4608, 1896, 80.58, 3.09, 40, 43, 30, 21, 20, 10, 9321, 1058, 2255, 534, 1731, 433, 278, 0, 333, 0, 0, 0, 40, 176, "tomb4_clan", 600, 0, 0, "LAST_HIT", 0, 0, 0, "balanced"),
(18183, 18183, "Halisha's Foreman", 0, "", 0, "Monster.kaim_vanul", 24, 40, 81, "male", "L2Monster", 40, 4608, 1896, 80.58, 3.09, 40, 43, 30, 21, 20, 10, 9321, 1058, 2255, 534, 1731, 433, 278, 0, 333, 0, 0, 0, 40, 176, "tomb4_clan", 600, 0, 0, "LAST_HIT", 0, 0, 0, "balanced"),
(18184, 18184, "Halisha's Foreman", 0, "", 0, "Monster.kaim_vanul", 24, 40, 81, "male", "L2Monster", 40, 4608, 1896, 80.58, 3.09, 40, 43, 30, 21, 20, 10, 7133, 810, 2255, 534, 1731, 433, 278, 0, 333, 0, 0, 0, 40, 176, "tomb4_clan", 600, 0, 0, "LAST_HIT", 0, 0, 0, "balanced"),
(18185, 18185, "Evil Astrologer", 0, "", 0, "Monster.doll_blader", 6, 12, 81, "male", "L2Monster", 40, 4608, 1896, 80.58, 3.09, 40, 43, 30, 21, 20, 10, 9413, 1069, 1694, 710, 977, 577, 278, 0, 333, 5129, 5129, 0, 24, 165, "tomb4_clan", 600, 0, 0, "LAST_HIT", 0, 0, 0, "fighter"),
(18186, 18186, "Evil Astrologer", 0, "", 0, "Monster.doll_blader", 6, 12, 81, "male", "L2Monster", 40, 4608, 1896, 80.58, 3.09, 40, 43, 30, 21, 20, 10, 9467, 1075, 1694, 710, 977, 577, 278, 0, 333, 5129, 5129, 0, 24, 165, "tomb4_clan", 600, 0, 0, "LAST_HIT", 0, 0, 0, "fighter"),
(18187, 18187, "Knight of Darkness", 0, "", 0, "Monster.death_lord", 21, 40, 81, "male", "L2Monster", 40, 4608, 1896, 80.58, 3.09, 40, 43, 30, 21, 20, 10, 9190, 1043, 2255, 534, 1731, 433, 278, 0, 333, 78, 0, 0, 44, 176, "tomb4_clan", 600, 1, 0, "LAST_HIT", 0, 0, 0, "balanced"),
(18188, 18188, "Knight of Darkness", 0, "", 0, "Monster.death_lord", 21, 40, 81, "male", "L2Monster", 40, 4608, 1896, 80.58, 3.09, 40, 43, 30, 21, 20, 10, 6906, 784, 2255, 534, 1731, 433, 278, 0, 333, 78, 0, 0, 44, 176, "tomb4_clan", 600, 1, 0, "LAST_HIT", 0, 0, 0, "balanced"),
(18189, 18189, "Knight of Darkness", 0, "", 0, "Monster.death_lord", 21, 40, 81, "male", "L2Monster", 40, 4608, 1896, 80.58, 3.09, 40, 43, 30, 21, 20, 10, 9149, 1039, 2255, 534, 1731, 433, 278, 0, 333, 78, 0, 0, 44, 176, "tomb4_clan", 600, 1, 0, "LAST_HIT", 0, 0, 0, "balanced"),
(18190, 18190, "Knight of Darkness", 0, "", 0, "Monster.death_lord", 21, 40, 81, "male", "L2Monster", 40, 4608, 1896, 80.58, 3.09, 40, 43, 30, 21, 20, 10, 9190, 1043, 2255, 534, 1731, 433, 278, 0, 333, 78, 0, 0, 44, 176, "tomb4_clan", 600, 1, 0, "LAST_HIT", 0, 0, 0, "balanced"),
(18191, 18191, "Witch of dust", 0, "", 0, "Monster.banshee", 9, 23, 81, "female", "L2Monster", 40, 4608, 1896, 80.58, 3.09, 40, 43, 30, 21, 20, 10, 6812, 773, 2255, 534, 1731, 433, 278, 0, 333, 3939, 0, 0, 88, 176, "tomb4_clan", 600, 0, 0, "LAST_HIT", 0, 0, 0, "mage"),
(18192, 18192, "Witch of dust", 0, "", 0, "Monster.banshee", 9, 23, 81, "female", "L2Monster", 40, 4608, 1896, 80.58, 3.09, 40, 43, 30, 21, 20, 10, 9069, 1029, 2255, 534, 1731, 433, 278, 0, 333, 3939, 0, 0, 88, 176, "tomb4_clan", 600, 0, 0, "LAST_HIT", 0, 0, 0, "mage"),
(18193, 18193, "Witch of dust", 0, "", 0, "Monster.banshee", 9, 23, 81, "female", "L2Monster", 40, 4608, 1896, 80.58, 3.09, 40, 43, 30, 21, 20, 10, 8935, 1014, 2255, 534, 1731, 433, 278, 0, 333, 3939, 0, 0, 88, 176, "tomb4_clan", 600, 0, 0, "LAST_HIT", 0, 0, 0, "mage"),
(18194, 18194, "Witch of dust", 0, "", 0, "Monster.banshee", 9, 23, 81, "female", "L2Monster", 40, 4608, 1896, 80.58, 3.09, 40, 43, 30, 21, 20, 10, 9065, 1029, 2255, 534, 1731, 433, 278, 0, 333, 3939, 0, 0, 88, 176, "tomb4_clan", 600, 0, 0, "LAST_HIT", 0, 0, 0, "mage"),
(18195, 18195, "Signet of Emperor", 0, "", 0, "Monster.ant_larva", 12, 8, 81, "male", "L2Monster", 40, 4608, 1896, 80.58, 3.09, 40, 43, 30, 21, 20, 10, 6946, 788, 3001, 401, 3068, 325, 278, 0, 333, 0, 0, 0, 44, 66, "tomb4_clan", 600, 0, 0, "LAST_HIT", 0, 0, 0, "balanced"),
(18196, 18196, "Charm of Corner", 0, "", 0, "Monster2.magmagoil_lad", 15, 75, 81, "male", "L2Monster", 40, 4608, 1896, 80.58, 3.09, 40, 43, 30, 21, 20, 10, 22690, 2576, 1272, 946, 551, 768, 278, 0, 333, 0, 0, 0, 1, 1, "tomb4_clan", 600, 0, 0, "LAST_HIT", 0, 0, 0, "fighter"),
(18197, 18197, "Charm of Corner", 0, "", 0, "Monster2.magmagoil_lad", 15, 75, 81, "male", "L2Monster", 40, 4608, 1896, 80.58, 3.09, 40, 43, 30, 21, 20, 10, 22690, 2576, 1272, 946, 551, 768, 278, 0, 333, 0, 0, 0, 1, 1, "tomb4_clan", 600, 0, 0, "LAST_HIT", 0, 0, 0, "fighter"),
(18198, 18198, "Charm of Corner", 0, "", 0, "Monster2.magmagoil_lad", 15, 75, 81, "male", "L2Monster", 40, 4608, 1896, 80.58, 3.09, 40, 43, 30, 21, 20, 10, 22690, 2576, 1272, 946, 551, 768, 278, 0, 333, 0, 0, 0, 1, 1, "tomb4_clan", 600, 0, 0, "LAST_HIT", 0, 0, 0, "fighter"),
(18199, 18199, "Charm of Corner", 0, "", 0, "Monster2.magmagoil_lad", 15, 75, 81, "male", "L2Monster", 40, 4608, 1896, 80.58, 3.09, 40, 43, 30, 21, 20, 10, 22690, 2576, 1272, 946, 551, 768, 278, 0, 333, 0, 0, 0, 1, 1, "tomb4_clan", 600, 0, 0, "LAST_HIT", 0, 0, 0, "fighter"),
(18200, 18200, "Charm of Corner", 0, "", 0, "Monster2.magmagoil_lad", 15, 75, 81, "male", "L2Monster", 40, 4608, 1896, 80.58, 3.09, 40, 43, 30, 21, 20, 10, 22690, 2576, 1272, 946, 551, 768, 278, 0, 333, 0, 0, 0, 1, 1, "tomb4_clan", 600, 0, 0, "LAST_HIT", 0, 0, 0, "fighter"),
(18201, 18201, "Charm of Corner", 0, "", 0, "Monster2.magmagoil_lad", 15, 75, 81, "male", "L2Monster", 40, 4608, 1896, 80.58, 3.09, 40, 43, 30, 21, 20, 10, 22690, 2576, 1272, 946, 551, 768, 278, 0, 333, 0, 0, 0, 1, 1, "tomb4_clan", 600, 0, 0, "LAST_HIT", 0, 0, 0, "fighter"),
(18202, 18202, "Charm of Corner", 0, "", 0, "Monster2.magmagoil_lad", 15, 75, 81, "male", "L2Monster", 40, 4608, 1896, 80.58, 3.09, 40, 43, 30, 21, 20, 10, 22690, 2576, 1272, 946, 551, 768, 278, 0, 333, 0, 0, 0, 1, 1, "tomb4_clan", 600, 0, 0, "LAST_HIT", 0, 0, 0, "fighter"),
(18203, 18203, "Charm of Corner", 0, "", 0, "Monster2.magmagoil_lad", 15, 75, 81, "male", "L2Monster", 40, 4608, 1896, 80.58, 3.09, 40, 43, 30, 21, 20, 10, 22690, 2576, 1272, 946, 551, 768, 278, 0, 333, 0, 0, 0, 1, 1, "tomb4_clan", 600, 0, 0, "LAST_HIT", 0, 0, 0, "fighter"),
(18204, 18204, "Charm of Corner", 0, "", 0, "Monster2.magmagoil_lad", 15, 75, 81, "male", "L2Monster", 40, 4608, 1896, 80.58, 3.09, 40, 43, 30, 21, 20, 10, 22690, 2576, 1272, 946, 551, 768, 278, 0, 333, 0, 0, 0, 1, 1, "tomb4_clan", 600, 0, 0, "LAST_HIT", 0, 0, 0, "fighter"),
(18205, 18205, "Charm of Corner", 0, "", 0, "Monster2.magmagoil_lad", 15, 75, 81, "male", "L2Monster", 40, 4608, 1896, 80.58, 3.09, 40, 43, 30, 21, 20, 10, 22690, 2576, 1272, 946, 551, 768, 278, 0, 333, 0, 0, 0, 1, 1, "tomb4_clan", 600, 0, 0, "LAST_HIT", 0, 0, 0, "fighter"),
(18206, 18206, "Charm of Corner", 0, "", 0, "Monster2.magmagoil_lad", 15, 75, 81, "male", "L2Monster", 40, 4608, 1896, 80.58, 3.09, 40, 43, 30, 21, 20, 10, 22690, 2576, 1272, 946, 551, 768, 278, 0, 333, 0, 0, 0, 1, 1, "tomb4_clan", 600, 0, 0, "LAST_HIT", 0, 0, 0, "fighter"),
(18207, 18207, "Charm of Corner", 0, "", 0, "Monster2.magmagoil_lad", 15, 75, 81, "male", "L2Monster", 40, 4608, 1896, 80.58, 3.09, 40, 43, 30, 21, 20, 10, 22690, 2576, 1272, 946, 551, 768, 278, 0, 333, 0, 0, 0, 1, 1, "tomb4_clan", 600, 0, 0, "LAST_HIT", 0, 0, 0, "fighter"),
(18208, 18208, "Charm of Corner", 0, "", 0, "Monster2.magmagoil_lad", 15, 75, 81, "male", "L2Monster", 40, 4608, 1896, 80.58, 3.09, 40, 43, 30, 21, 20, 10, 22690, 2576, 1272, 946, 551, 768, 278, 0, 333, 0, 0, 0, 1, 1, "tomb4_clan", 600, 0, 0, "LAST_HIT", 0, 0, 0, "fighter"),
(18209, 18209, "Charm of Corner", 0, "", 0, "Monster2.magmagoil_lad", 15, 75, 81, "male", "L2Monster", 40, 4608, 1896, 80.58, 3.09, 40, 43, 30, 21, 20, 10, 22690, 2576, 1272, 946, 551, 768, 278, 0, 333, 0, 0, 0, 1, 1, "tomb4_clan", 600, 0, 0, "LAST_HIT", 0, 0, 0, "fighter"),
(18210, 18210, "Charm of Corner", 0, "", 0, "Monster2.magmagoil_lad", 15, 75, 81, "male", "L2Monster", 40, 4608, 1896, 80.58, 3.09, 40, 43, 30, 21, 20, 10, 22690, 2576, 1272, 946, 551, 768, 278, 0, 333, 0, 0, 0, 1, 1, "tomb4_clan", 600, 0, 0, "LAST_HIT", 0, 0, 0, "fighter"),
(18211, 18211, "Charm of Corner", 0, "", 0, "Monster2.magmagoil_lad", 15, 75, 81, "male", "L2Monster", 40, 4608, 1896, 80.58, 3.09, 40, 43, 30, 21, 20, 10, 22690, 2576, 1272, 946, 551, 768, 278, 0, 333, 0, 0, 0, 1, 1, "tomb4_clan", 600, 0, 0, "LAST_HIT", 0, 0, 0, "fighter"),
(18212, 18212, "Archon of Halisha", 0, "", 0, "Monster2.ahrimanes", 14, 57.75, 81, "male", "L2Monster", 40, 4608, 1896, 80.58, 3.09, 40, 43, 30, 21, 20, 10, 28935, 3285, 1540, 782, 807, 635, 278, 0, 333, 6722, 0, 0, 38, 203, "tomb5_clan", 600, 0, 0, "LAST_HIT", 0, 0, 0, "fighter"),
(18213, 18213, "Archon of Halisha", 0, "", 0, "Monster2.ahrimanes", 14, 57.75, 81, "male", "L2Monster", 40, 4608, 1896, 80.58, 3.09, 40, 43, 30, 21, 20, 10, 28935, 3285, 1540, 782, 807, 635, 278, 0, 333, 6722, 0, 0, 38, 203, "tomb5_clan", 600, 0, 0, "LAST_HIT", 0, 0, 0, "fighter"),
(18214, 18214, "Archon of Halisha", 0, "", 0, "Monster2.ahrimanes", 14, 57.75, 81, "male", "L2Monster", 40, 4608, 1896, 80.58, 3.09, 40, 43, 30, 21, 20, 10, 28935, 3285, 1540, 782, 807, 635, 278, 0, 333, 6722, 0, 0, 38, 203, "tomb5_clan", 600, 0, 0, "LAST_HIT", 0, 0, 0, "fighter"),
(18215, 18215, "Archon of Halisha", 0, "", 0, "Monster2.ahrimanes", 14, 57.75, 81, "male", "L2Monster", 40, 4608, 1896, 80.58, 3.09, 40, 43, 30, 21, 20, 10, 28935, 3285, 1540, 782, 807, 635, 278, 0, 333, 6722, 0, 0, 38, 203, "tomb5_clan", 600, 0, 0, "LAST_HIT", 0, 0, 0, "fighter"),
(18216, 18216, "Archon of Halisha", 0, "", 0, "Monster2.ahrimanes", 14, 57.75, 81, "male", "L2Monster", 40, 4608, 1896, 80.58, 3.09, 40, 43, 30, 21, 20, 10, 28935, 3285, 1540, 782, 807, 635, 278, 0, 333, 6722, 0, 0, 38, 203, "tomb5_clan", 600, 0, 0, "LAST_HIT", 0, 0, 0, "fighter"),
(18217, 18217, "Archon of Halisha", 0, "", 0, "Monster2.ahrimanes", 14, 57.75, 81, "male", "L2Monster", 40, 4608, 1896, 80.58, 3.09, 40, 43, 30, 21, 20, 10, 28935, 3285, 1540, 782, 807, 635, 278, 0, 333, 6722, 0, 0, 38, 203, "tomb5_clan", 600, 0, 0, "LAST_HIT", 0, 0, 0, "fighter"),
(18218, 18218, "Archon of Halisha", 0, "", 0, "Monster2.ahrimanes", 14, 57.75, 81, "male", "L2Monster", 40, 4608, 1896, 80.58, 3.09, 40, 43, 30, 21, 20, 10, 28935, 3285, 1540, 782, 807, 635, 278, 0, 333, 6722, 0, 0, 38, 203, "tomb5_clan", 600, 0, 0, "LAST_HIT", 0, 0, 0, "fighter"),
(18219, 18219, "Archon of Halisha", 0, "", 0, "Monster2.ahrimanes", 14, 57.75, 81, "male", "L2Monster", 40, 4608, 1896, 80.58, 3.09, 40, 43, 30, 21, 20, 10, 28935, 3285, 1540, 782, 807, 635, 278, 0, 333, 6722, 0, 0, 38, 203, "tomb5_clan", 600, 0, 0, "LAST_HIT", 0, 0, 0, "fighter"),
(18220, 18220, "Shaman of Darkness", 0, "", 0, "Monster.banshee", 9, 23, 81, "female", "L2Monster", 40, 4608, 1896, 80.58, 3.09, 40, 43, 30, 21, 20, 10, 9467, 1075, 2050, 587, 1431, 477, 278, 0, 333, 3939, 0, 0, 88, 176, "tomb5_clan", 600, 0, 0, "LAST_HIT", 0, 0, 0, "balanced"),
(18221, 18221, "Shaman of Darkness", 0, "", 0, "Monster.banshee", 9, 23, 81, "female", "L2Monster", 40, 4608, 1896, 80.58, 3.09, 40, 43, 30, 21, 20, 10, 9721, 1103, 2050, 587, 1431, 477, 278, 0, 333, 3939, 0, 0, 88, 176, "tomb5_clan", 600, 0, 0, "LAST_HIT", 0, 0, 0, "balanced"),
(18222, 18222, "Assassin of Darkness", 0, "", 0, "Monster2.ashuras", 13, 37.5, 81, "male", "L2Monster", 40, 4608, 1896, 80.58, 3.09, 40, 43, 30, 21, 20, 10, 9210, 1045, 2480, 485, 2095, 394, 278, 0, 333, 0, 0, 0, 45, 209, "tomb5_clan", 600, 0, 0, "LAST_HIT", 0, 0, 0, "balanced"),
(18223, 18223, "Assassin of Darkness", 0, "", 0, "Monster2.ashuras", 13, 37.5, 81, "male", "L2Monster", 40, 4608, 1896, 80.58, 3.09, 40, 43, 30, 21, 20, 10, 6906, 784, 1863, 587, 1182, 477, 278, 0, 333, 0, 0, 0, 45, 209, "tomb5_clan", 600, 0, 0, "LAST_HIT", 0, 0, 0, "fighter"),
(18224, 18224, "Assassin of Darkness", 0, "", 0, "Monster2.ashuras", 13, 37.5, 81, "male", "L2Monster", 40, 4608, 1896, 80.58, 3.09, 40, 43, 30, 21, 20, 10, 9303, 1056, 2480, 485, 2095, 394, 278, 0, 333, 0, 0, 0, 45, 209, "tomb5_clan", 600, 0, 0, "LAST_HIT", 0, 0, 0, "balanced"),
(18225, 18225, "Assassin of Darkness", 0, "", 0, "Monster2.ashuras", 13, 37.5, 81, "male", "L2Monster", 40, 4608, 1896, 80.58, 3.09, 40, 43, 30, 21, 20, 10, 9210, 1045, 1863, 587, 1182, 477, 278, 0, 333, 0, 0, 0, 45, 209, "tomb5_clan", 600, 0, 0, "LAST_HIT", 0, 0, 0, "fighter"),
(18226, 18226, "Caster of Darkness", 0, "", 0, "Monster.vale_master", 12, 40, 81, "male", "L2Monster", 40, 4608, 1896, 80.58, 3.09, 40, 43, 30, 21, 20, 10, 6812, 773, 2480, 485, 2095, 394, 278, 0, 333, 0, 0, 0, 77, 170, "tomb5_clan", 600, 0, 0, "LAST_HIT", 0, 0, 0, "balanced"),
(18227, 18227, "Caster of Darkness", 0, "", 0, "Monster.vale_master", 12, 40, 81, "male", "L2Monster", 40, 4608, 1896, 80.58, 3.09, 40, 43, 30, 21, 20, 10, 11706, 1329, 1863, 587, 1182, 477, 278, 0, 333, 0, 0, 0, 77, 170, "tomb5_clan", 600, 0, 0, "LAST_HIT", 0, 0, 0, "fighter"),
(18228, 18228, "Caster of Darkness", 0, "", 0, "Monster.vale_master", 12, 40, 81, "male", "L2Monster", 40, 4608, 1896, 80.58, 3.09, 40, 43, 30, 21, 20, 10, 8801, 999, 2480, 485, 2095, 394, 278, 0, 333, 0, 0, 0, 77, 170, "tomb5_clan", 600, 0, 0, "LAST_HIT", 0, 0, 0, "balanced"),
(18229, 18229, "Caster of Darkness", 0, "", 0, "Monster.vale_master", 12, 40, 81, "male", "L2Monster", 40, 4608, 1896, 80.58, 3.09, 40, 43, 30, 21, 20, 10, 9065, 1029, 1863, 587, 1182, 477, 278, 0, 333, 0, 0, 0, 77, 170, "tomb5_clan", 600, 0, 0, "LAST_HIT", 0, 0, 0, "fighter"),
(18230, 18230, "Signet of Emperor", 0, "", 0, "Monster.ant_larva", 12, 8, 81, "male", "L2Monster", 40, 4608, 1896, 40.29, 3.09, 40, 43, 30, 21, 20, 10, 7495, 851, 3001, 401, 3068, 325, 278, 0, 333, 0, 0, 0, 44, 66, "tomb5_clan", 600, 0, 0, "LAST_HIT", 0, 0, 0, "balanced"),
(18231, 18231, "Statue of Protection", 0, "", 0, "Monster2.temple_guard_a", 15, 42, 81, "male", "L2Monster", 40, 4608, 1896, 80.58, 3.09, 40, 43, 30, 21, 20, 10, 11149, 1266, 1694, 710, 977, 577, 278, 0, 333, 5795, 0, 0, 58, 154, "NULL", 0, 0, 0, "LAST_HIT", 0, 0, 0, "fighter"),
(18232, 18232, "Statue of Protection", 0, "", 0, "Monster2.temple_guard_a", 15, 42, 81, "male", "L2Monster", 40, 4608, 1896, 80.58, 3.09, 40, 43, 30, 21, 20, 10, 11149, 1266, 1694, 710, 977, 577, 278, 0, 333, 5795, 0, 0, 58, 154, "NULL", 0, 0, 0, "LAST_HIT", 0, 0, 0, "fighter"),
(18233, 18233, "Statue of Protection", 0, "", 0, "Monster2.temple_guard_a", 15, 42, 81, "male", "L2Monster", 40, 4608, 1896, 80.58, 3.09, 40, 43, 30, 21, 20, 10, 11149, 1266, 1694, 710, 977, 577, 278, 0, 333, 5795, 0, 0, 58, 154, "NULL", 0, 0, 0, "LAST_HIT", 0, 0, 0, "fighter"),
(18234, 18234, "Statue of Protection", 0, "", 0, "Monster2.temple_guard_a", 15, 42, 81, "male", "L2Monster", 40, 4608, 1896, 80.58, 3.09, 40, 43, 30, 21, 20, 10, 11149, 1266, 1694, 710, 977, 577, 278, 0, 333, 5795, 0, 0, 58, 154, "NULL", 0, 0, 0, "LAST_HIT", 0, 0, 0, "fighter"),
(18235, 18235, "Statue of Protection", 0, "", 0, "Monster2.temple_guard_a", 15, 42, 81, "male", "L2Monster", 40, 4608, 1896, 80.58, 3.09, 40, 43, 30, 21, 20, 10, 11149, 1266, 1694, 710, 977, 577, 278, 0, 333, 5795, 0, 0, 58, 154, "NULL", 0, 0, 0, "LAST_HIT", 0, 0, 0, "fighter"),
(18236, 18236, "Statue of Protection", 0, "", 0, "Monster2.temple_guard_a", 15, 42, 81, "male", "L2Monster", 40, 4608, 1896, 80.58, 3.09, 40, 43, 30, 21, 20, 10, 11149, 1266, 1694, 710, 977, 577, 278, 0, 333, 5795, 0, 0, 58, 154, "NULL", 0, 0, 0, "LAST_HIT", 0, 0, 0, "fighter"),
(18237, 18237, "Statue of Protection", 0, "", 0, "Monster2.temple_guard_a", 15, 42, 81, "male", "L2Monster", 40, 4608, 1896, 80.58, 3.09, 40, 43, 30, 21, 20, 10, 11149, 1266, 1694, 710, 977, 577, 278, 0, 333, 5795, 0, 0, 58, 154, "NULL", 0, 0, 0, "LAST_HIT", 0, 0, 0, "fighter"),
(18238, 18238, "Statue of Protection", 0, "", 0, "Monster2.temple_guard_a", 15, 42, 81, "male", "L2Monster", 40, 4608, 1896, 80.58, 3.09, 40, 43, 30, 21, 20, 10, 11149, 1266, 1694, 710, 977, 577, 278, 0, 333, 5795, 0, 0, 58, 154, "NULL", 0, 0, 0, "LAST_HIT", 0, 0, 0, "fighter"),
(18239, 18239, "Statue of Protection", 0, "", 0, "Monster2.temple_guard_a", 15, 42, 81, "male", "L2Monster", 40, 4608, 1896, 80.58, 3.09, 40, 43, 30, 21, 20, 10, 11149, 1266, 1694, 710, 977, 577, 278, 0, 333, 5795, 0, 0, 58, 154, "NULL", 0, 0, 0, "LAST_HIT", 0, 0, 0, "fighter"),
(18240, 18240, "Statue of Protection", 0, "", 0, "Monster2.temple_guard_a", 15, 42, 81, "male", "L2Monster", 40, 4608, 1896, 80.58, 3.09, 40, 43, 30, 21, 20, 10, 11149, 1266, 1694, 710, 977, 577, 278, 0, 333, 5795, 0, 0, 58, 154, "NULL", 0, 0, 0, "LAST_HIT", 0, 0, 0, "fighter"),
(18241, 18241, "Statue of Protection", 0, "", 0, "Monster2.temple_guard_a", 15, 42, 81, "male", "L2Monster", 40, 4608, 1896, 80.58, 3.09, 40, 43, 30, 21, 20, 10, 11149, 1266, 1694, 710, 977, 577, 278, 0, 333, 5795, 0, 0, 58, 154, "NULL", 0, 0, 0, "LAST_HIT", 0, 0, 0, "fighter"),
(18242, 18242, "Statue of Protection", 0, "", 0, "Monster2.temple_guard_a", 15, 42, 81, "male", "L2Monster", 40, 4608, 1896, 80.58, 3.09, 40, 43, 30, 21, 20, 10, 11149, 1266, 1694, 710, 977, 577, 278, 0, 333, 5795, 0, 0, 58, 154, "NULL", 0, 0, 0, "LAST_HIT", 0, 0, 0, "fighter"),
(18243, 18243, "Statue of Protection", 0, "", 0, "Monster2.temple_guard_a", 15, 42, 81, "male", "L2Monster", 40, 4608, 1896, 80.58, 3.09, 40, 43, 30, 21, 20, 10, 11149, 1266, 1694, 710, 977, 577, 278, 0, 333, 5795, 0, 0, 58, 154, "NULL", 0, 0, 0, "LAST_HIT", 0, 0, 0, "fighter"),
(18244, 18244, "Watchman of Grave", 0, "", 0, "Monster.mana_vampire", 11, 20, 81, "male", "L2Monster", 40, 3456, 1896, 40.29, 3.09, 40, 43, 30, 21, 20, 10, 0, 0, 2480, 485, 2095, 394, 278, 0, 333, 0, 0, 0, 99, 1, "tomb1_clan", 600, 0, 0, "LAST_HIT", 0, 0, 0, "balanced"),
(18245, 18245, "Watchman of Grave", 0, "", 0, "Monster.mana_vampire", 11, 20, 81, "male", "L2Monster", 40, 3456, 1896, 40.29, 3.09, 40, 43, 30, 21, 20, 10, 0, 0, 1694, 710, 977, 577, 278, 0, 333, 0, 0, 0, 99, 1, "tomb1_clan", 600, 0, 0, "LAST_HIT", 0, 0, 0, "fighter"),
(18246, 18246, "Watchman of Grave", 0, "", 0, "Monster.mana_vampire", 11, 20, 81, "male", "L2Monster", 40, 3456, 1896, 40.29, 3.09, 40, 43, 30, 21, 20, 10, 0, 0, 1863, 587, 1182, 477, 278, 0, 333, 0, 0, 0, 99, 1, "tomb1_clan", 600, 0, 0, "LAST_HIT", 0, 0, 0, "fighter"),
(18247, 18247, "Watchman of Grave", 0, "", 0, "Monster.mana_vampire", 11, 20, 81, "male", "L2Monster", 40, 3456, 1896, 40.29, 3.09, 40, 43, 30, 21, 20, 10, 0, 0, 2480, 485, 2095, 394, 278, 0, 333, 0, 0, 0, 99, 1, "tomb2_clan", 600, 0, 0, "LAST_HIT", 0, 0, 0, "balanced"),
(18248, 18248, "Watchman of Grave", 0, "", 0, "Monster.mana_vampire", 11, 20, 81, "male", "L2Monster", 40, 3456, 1896, 40.29, 3.09, 40, 43, 30, 21, 20, 10, 0, 0, 1694, 710, 977, 577, 278, 0, 333, 0, 0, 0, 99, 1, "tomb2_clan", 600, 0, 0, "LAST_HIT", 0, 0, 0, "fighter"),
(18249, 18249, "Watchman of Grave", 0, "", 0, "Monster.mana_vampire", 11, 20, 81, "male", "L2Monster", 40, 3456, 1896, 40.29, 3.09, 40, 43, 30, 21, 20, 10, 0, 0, 1863, 587, 1182, 477, 278, 0, 333, 0, 0, 0, 99, 1, "tomb2_clan", 600, 0, 0, "LAST_HIT", 0, 0, 0, "fighter"),
(18250, 18250, "Watchman of Grave", 0, "", 0, "Monster.mana_vampire", 11, 20, 81, "male", "L2Monster", 40, 3456, 1896, 40.29, 3.09, 40, 43, 30, 21, 20, 10, 0, 0, 2480, 485, 2095, 394, 278, 0, 333, 0, 0, 0, 99, 1, "tomb3_clan", 600, 0, 0, "LAST_HIT", 0, 0, 0, "balanced"),
(18251, 18251, "Watchman of Grave", 0, "", 0, "Monster.mana_vampire", 11, 20, 81, "male", "L2Monster", 40, 3456, 1896, 40.29, 3.09, 40, 43, 30, 21, 20, 10, 0, 0, 1694, 710, 977, 577, 278, 0, 333, 0, 0, 0, 99, 1, "tomb3_clan", 600, 0, 0, "LAST_HIT", 0, 0, 0, "fighter"),
(18252, 18252, "Watchman of Grave", 0, "", 0, "Monster.mana_vampire", 11, 20, 81, "male", "L2Monster", 40, 3456, 1896, 40.29, 3.09, 40, 43, 30, 21, 20, 10, 0, 0, 1863, 587, 1182, 477, 278, 0, 333, 0, 0, 0, 99, 1, "tomb3_clan", 600, 0, 0, "LAST_HIT", 0, 0, 0, "fighter"),
(18253, 18253, "Watchman of Grave", 0, "", 0, "Monster.mana_vampire", 11, 20, 81, "male", "L2Monster", 40, 3456, 1896, 40.29, 3.09, 40, 43, 30, 21, 20, 10, 0, 0, 2480, 485, 2095, 394, 278, 0, 333, 0, 0, 0, 99, 1, "tomb4_clan", 600, 0, 0, "LAST_HIT", 0, 0, 0, "balanced"),
(18254, 18254, "Watchman of Grave", 0, "", 0, "Monster.mana_vampire", 11, 20, 81, "male", "L2Monster", 40, 3456, 1896, 40.29, 3.09, 40, 43, 30, 21, 20, 10, 0, 0, 1694, 710, 977, 577, 278, 0, 333, 0, 0, 0, 99, 1, "tomb4_clan", 600, 0, 0, "LAST_HIT", 0, 0, 0, "fighter"),
(18255, 18255, "Watchman of Grave", 0, "", 0, "Monster.mana_vampire", 11, 20, 81, "male", "L2Monster", 40, 3456, 1896, 40.29, 3.09, 40, 43, 30, 21, 20, 10, 0, 0, 1863, 587, 1182, 477, 278, 0, 333, 0, 0, 0, 99, 1, "tomb4_clan", 600, 0, 0, "LAST_HIT", 0, 0, 0, "fighter"),
(18256, 18256, "Halisha's Treasure Box", 0, "", 0, "Monster.mimic", 8.5, 8.5, 85, "male", "L2Monster", 40, 1, 1, 0, 0, 40, 43, 30, 21, 20, 10, 0, 0, 2, 1, 1, 1, 1, 0, 333, 0, 0, 0, 88, 181, "NULL", 0, 0, 0, "LAST_HIT", 0, 0, 0, "fighter"),
(18257, 18257, "Treasure Chest", 0, "", 0, "Monster.mechanic_golem", 8.5, 8.5, 52, "male", "L2Monster", 40, 2402, 892, 10.27, 2.45, 40, 43, 30, 21, 20, 10, 0, 0, 518, 324, 300, 239, 278, 0, 333, 0, 0, 0, 88, 181, "NULL", 0, 0, 0, "LAST_HIT", 0, 0, 0, "fighter"),
(18258, 18258, "Treasure Chest", 0, "", 0, "Monster.mechanic_golem", 8.5, 8.5, 52, "male", "L2Monster", 40, 2402, 892, 10.27, 2.45, 40, 43, 30, 21, 20, 10, 0, 0, 518, 324, 300, 239, 278, 0, 333, 0, 0, 0, 88, 181, "NULL", 0, 0, 0, "LAST_HIT", 0, 0, 0, "fighter"),
(18259, 18259, "Treasure Chest", 0, "", 0, "Monster.mechanic_golem", 8.5, 8.5, 52, "male", "L2Monster", 40, 2402, 892, 10.27, 2.45, 40, 43, 30, 21, 20, 10, 0, 0, 518, 324, 300, 239, 278, 0, 333, 0, 0, 0, 88, 181, "NULL", 0, 0, 0, "LAST_HIT", 0, 0, 0, "fighter"),
(18260, 18260, "Treasure Chest", 0, "", 0, "Monster.mechanic_golem", 8.5, 8.5, 52, "male", "L2Monster", 40, 2402, 892, 10.27, 2.45, 40, 43, 30, 21, 20, 10, 0, 0, 518, 324, 300, 239, 278, 0, 333, 0, 0, 0, 88, 181, "NULL", 0, 0, 0, "LAST_HIT", 0, 0, 0, "fighter"),
(18261, 18261, "Treasure Chest", 0, "", 0, "Monster.mechanic_golem", 8.5, 8.5, 52, "male", "L2Monster", 40, 2402, 892, 10.27, 2.45, 40, 43, 30, 21, 20, 10, 0, 0, 518, 324, 300, 239, 278, 0, 333, 0, 0, 0, 88, 181, "NULL", 0, 0, 0, "LAST_HIT", 0, 0, 0, "fighter"),
(18262, 18262, "Treasure Chest", 0, "", 0, "Monster.mechanic_golem", 8.5, 8.5, 52, "male", "L2Monster", 40, 2402, 892, 10.27, 2.45, 40, 43, 30, 21, 20, 10, 0, 0, 518, 324, 300, 239, 278, 0, 333, 0, 0, 0, 88, 181, "NULL", 0, 0, 0, "LAST_HIT", 0, 0, 0, "fighter"),
(18263, 18263, "Treasure Chest", 0, "", 0, "Monster.mechanic_golem", 8.5, 8.5, 52, "male", "L2Monster", 40, 2402, 892, 10.27, 2.45, 40, 43, 30, 21, 20, 10, 0, 0, 518, 324, 300, 239, 278, 0, 333, 0, 0, 0, 88, 181, "NULL", 0, 0, 0, "LAST_HIT", 0, 0, 0, "fighter"),
(18264, 18264, "Treasure Chest", 0, "", 0, "Monster.mechanic_golem", 8.5, 8.5, 52, "male", "L2Monster", 40, 2402, 892, 10.27, 2.45, 40, 43, 30, 21, 20, 10, 0, 0, 518, 324, 300, 239, 278, 0, 333, 0, 0, 0, 88, 181, "NULL", 0, 0, 0, "LAST_HIT", 0, 0, 0, "fighter"),
(18265, 18265, "Treasure Chest", 0, "", 0, "Monster.mimic", 8.5, 8.5, 21, "male", "L2Chest", 40, 575, 227, 5.53, 1.53, 40, 43, 30, 21, 20, 10, 630, 29, 63, 98, 25, 80, 278, 0, 333, 0, 0, 0, 80, 1, "NULL", 0, 0, 0, "LAST_HIT", 0, 0, 0, "fighter"),
(18266, 18266, "Treasure Chest", 0, "", 0, "Monster.mimic", 8.5, 8.5, 24, "male", "L2Chest", 40, 687, 272, 5.53, 1.53, 40, 43, 30, 21, 20, 10, 771, 38, 81, 111, 34, 90, 278, 0, 333, 0, 0, 0, 80, 1, "NULL", 0, 0, 0, "LAST_HIT", 0, 0, 0, "fighter"),
(18267, 18267, "Treasure Chest", 0, "", 0, "Monster.mimic", 8.5, 8.5, 27, "male", "L2Chest", 40, 813, 318, 5.53, 1.53, 40, 43, 30, 21, 20, 10, 918, 47, 104, 125, 45, 102, 278, 0, 333, 0, 0, 0, 80, 1, "NULL", 0, 0, 0, "LAST_HIT", 0, 0, 0, "fighter"),
(18268, 18268, "Treasure Chest", 0, "", 0, "Monster.mimic", 8.5, 8.5, 30, "male", "L2Chest", 40, 954, 365, 5.53, 1.53, 40, 43, 30, 21, 20, 10, 1080, 59, 132, 140, 58, 114, 278, 0, 333, 0, 0, 0, 80, 1, "NULL", 0, 0, 0, "LAST_HIT", 0, 0, 0, "fighter"),
(18269, 18269, "Treasure Chest", 0, "", 0, "Monster.mimic", 8.5, 8.5, 33, "male", "L2Chest", 40, 1109, 413, 7.11, 1.84, 40, 43, 30, 21, 20, 10, 1306, 75, 166, 157, 75, 128, 278, 0, 333, 0, 0, 0, 80, 1, "NULL", 0, 0, 0, "LAST_HIT", 0, 0, 0, "fighter"),
(18270, 18270, "Treasure Chest", 0, "", 0, "Monster.mimic", 8.5, 8.5, 36, "male", "L2Chest", 40, 1279, 463, 7.11, 1.84, 40, 43, 30, 21, 20, 10, 1555, 94, 206, 175, 96, 142, 278, 0, 333, 0, 0, 0, 80, 1, "NULL", 0, 0, 0, "LAST_HIT", 0, 0, 0, "fighter"),
(18271, 18271, "Treasure Chest", 0, "", 0, "Monster.mimic", 8.5, 8.5, 39, "male", "L2Chest", 40, 1462, 514, 7.11, 1.84, 40, 43, 30, 21, 20, 10, 1825, 116, 255, 195, 121, 158, 278, 0, 333, 0, 0, 0, 80, 1, "NULL", 0, 0, 0, "LAST_HIT", 0, 0, 0, "fighter"),
(18272, 18272, "Treasure Chest", 0, "", 0, "Monster.mimic", 8.5, 8.5, 42, "male", "L2Chest", 40, 1660, 589, 8.69, 2.14, 40, 43, 30, 21, 20, 10, 2116, 141, 311, 215, 152, 175, 278, 0, 333, 0, 0, 0, 80, 1, "NULL", 0, 0, 0, "LAST_HIT", 0, 0, 0, "fighter"),
(18273, 18273, "Treasure Chest", 0, "", 0, "Monster.mimic", 8.5, 8.5, 45, "male", "L2Chest", 40, 1870, 677, 8.69, 2.14, 40, 43, 30, 21, 20, 10, 2430, 169, 377, 238, 188, 193, 278, 0, 333, 0, 0, 0, 80, 1, "NULL", 0, 0, 0, "LAST_HIT", 0, 0, 0, "fighter"),
(18274, 18274, "Treasure Chest", 0, "", 0, "Monster.mimic", 8.5, 8.5, 48, "male", "L2Chest", 40, 2091, 768, 8.69, 2.14, 40, 43, 30, 21, 20, 10, 2764, 202, 453, 261, 231, 212, 278, 0, 333, 0, 0, 0, 80, 1, "NULL", 0, 0, 0, "LAST_HIT", 0, 0, 0, "fighter"),
(18275, 18275, "Treasure Chest", 0, "", 0, "Monster.mimic", 8.5, 8.5, 51, "male", "L2Chest", 40, 2323, 861, 10.27, 2.45, 40, 43, 30, 21, 20, 10, 3121, 238, 539, 286, 281, 232, 278, 0, 333, 0, 0, 0, 80, 1, "NULL", 0, 0, 0, "LAST_HIT", 0, 0, 0, "fighter"),
(18276, 18276, "Treasure Chest", 0, "", 0, "Monster.mimic", 8.5, 8.5, 54, "male", "L2Chest", 40, 2562, 955, 10.27, 2.45, 40, 43, 30, 21, 20, 10, 3499, 279, 636, 313, 339, 254, 278, 0, 333, 0, 0, 0, 80, 1, "NULL", 0, 0, 0, "LAST_HIT", 0, 0, 0, "fighter"),
(18277, 18277, "Treasure Chest", 0, "", 0, "Monster.mimic", 8.5, 8.5, 57, "male", "L2Chest", 40, 2806, 1052, 10.27, 2.45, 40, 43, 30, 21, 20, 10, 3898, 324, 743, 340, 405, 276, 278, 0, 333, 0, 0, 0, 80, 1, "NULL", 0, 0, 0, "LAST_HIT", 0, 0, 0, "fighter"),
(18278, 18278, "Treasure Chest", 0, "", 0, "Monster.mimic", 8.5, 8.5, 60, "male", "L2Chest", 40, 3054, 1150, 10.27, 2.45, 40, 43, 30, 21, 20, 10, 4320, 375, 860, 368, 478, 299, 278, 0, 333, 0, 0, 0, 80, 1, "NULL", 0, 0, 0, "LAST_HIT", 0, 0, 0, "fighter"),
(18279, 18279, "Treasure Chest", 0, "", 0, "Monster.mimic", 8.5, 8.5, 63, "male", "L2Chest", 40, 3302, 1251, 11.85, 2.78, 40, 43, 30, 21, 20, 10, 4762, 430, 987, 398, 560, 323, 278, 0, 333, 0, 0, 0, 80, 1, "NULL", 0, 0, 0, "LAST_HIT", 0, 0, 0, "fighter"),
(18280, 18280, "Treasure Chest", 0, "", 0, "Monster.mimic", 8.5, 8.5, 66, "male", "L2Chest", 40, 3546, 1353, 11.85, 2.78, 40, 43, 30, 21, 20, 10, 5227, 492, 1123, 428, 649, 348, 278, 0, 333, 0, 0, 0, 80, 1, "NULL", 0, 0, 0, "LAST_HIT", 0, 0, 0, "fighter"),
(18281, 18281, "Treasure Chest", 0, "", 0, "Monster.mimic", 8.5, 8.5, 69, "male", "L2Chest", 40, 3784, 1458, 11.85, 2.78, 40, 43, 30, 21, 20, 10, 5713, 559, 1265, 460, 746, 373, 278, 0, 333, 0, 0, 0, 80, 1, "NULL", 0, 0, 0, "LAST_HIT", 0, 0, 0, "fighter"),
(18282, 18282, "Treasure Chest", 0, "", 0, "Monster.mimic", 8.5, 8.5, 72, "male", "L2Chest", 40, 4013, 1565, 13.43, 3.09, 40, 43, 30, 21, 20, 10, 6220, 632, 1413, 491, 849, 399, 278, 0, 333, 0, 0, 0, 80, 1, "NULL", 0, 0, 0, "LAST_HIT", 0, 0, 0, "fighter"),
(18283, 18283, "Treasure Chest", 0, "", 0, "Monster.mimic", 8.5, 8.5, 75, "male", "L2Chest", 40, 4229, 1673, 13.43, 3.09, 40, 43, 30, 21, 20, 10, 6750, 712, 1563, 523, 957, 425, 278, 0, 333, 0, 0, 0, 88, 181, "NULL", 0, 0, 0, "LAST_HIT", 0, 0, 0, "fighter"),
(18284, 18284, "Treasure Chest", 0, "", 0, "Monster.mimic", 8.5, 8.5, 78, "male", "L2Chest", 40, 4428, 1784, 13.43, 3.09, 40, 43, 30, 21, 20, 10, 7300, 799, 1715, 555, 1069, 451, 278, 0, 333, 0, 0, 0, 80, 1, "NULL", 0, 0, 0, "LAST_HIT", 0, 0, 0, "fighter"),
(18285, 18285, "Treasure Chest", 0, "", 0, "Monster.mimic", 8.5, 8.5, 81, "male", "L2Chest", 40, 4608, 1896, 13.43, 3.09, 40, 43, 30, 21, 20, 10, 7873, 894, 1863, 587, 1182, 477, 278, 0, 333, 0, 0, 0, 88, 181, "NULL", 0, 0, 0, "LAST_HIT", 0, 0, 0, "fighter"),
(18286, 18286, "Treasure Chest", 0, "", 0, "Monster.mimic", 8.5, 8.5, 84, "male", "L2Chest", 40, 4766, 2011, 13.43, 3.09, 40, 43, 30, 21, 20, 10, 8467, 996, 2006, 619, 1296, 502, 278, 0, 333, 0, 0, 0, 88, 181, "NULL", 0, 0, 0, "LAST_HIT", 0, 0, 0, "fighter"),
(18287, 18287, "Otherworldly Invader Food", 0, "", 0, "Monster.mimic", 8.5, 8.5, 33, "male", "L2Chest", 40, 1109, 413, 7.11, 1.84, 40, 43, 30, 21, 20, 10, 0, 0, 166, 157, 75, 128, 278, 0, 333, 0, 0, 0, 88, 181, "ssq_clan", 300, 0, 0, "LAST_HIT", 0, 0, 0, "fighter"),
(18288, 18288, "Otherworldly Invader Food", 0, "", 0, "Monster.mimic", 8.5, 8.5, 35, "male", "L2Chest", 40, 1220, 446, 7.11, 1.84, 40, 43, 30, 21, 20, 10, 0, 0, 192, 169, 89, 137, 278, 0, 333, 0, 0, 0, 88, 181, "ssq_clan", 300, 0, 0, "LAST_HIT", 0, 0, 0, "fighter"),
(18289, 18289, "Dimension Invader Food", 0, "", 0, "Monster.mimic", 8.5, 8.5, 43, "male", "L2Chest", 40, 1728, 618, 8.69, 2.14, 40, 43, 30, 21, 20, 10, 0, 0, 332, 223, 163, 181, 278, 0, 333, 0, 0, 0, 88, 181, "ssq_clan", 300, 0, 0, "LAST_HIT", 0, 0, 0, "fighter"),
(18290, 18290, "Dimension Invader Food", 0, "", 0, "Monster.mimic", 8.5, 8.5, 45, "male", "L2Chest", 40, 1870, 677, 8.69, 2.14, 40, 43, 30, 21, 20, 10, 0, 0, 377, 238, 188, 193, 278, 0, 333, 0, 0, 0, 88, 181, "ssq_clan", 300, 0, 0, "LAST_HIT", 0, 0, 0, "fighter"),
(18291, 18291, "Purgatory Invader Food", 0, "", 0, "Monster.mimic", 8.5, 8.5, 53, "male", "L2Chest", 40, 2481, 923, 10.27, 2.45, 40, 43, 30, 21, 20, 10, 0, 0, 602, 304, 319, 247, 278, 0, 333, 0, 0, 0, 88, 181, "ssq_clan", 300, 0, 0, "LAST_HIT", 0, 0, 0, "fighter"),
(18292, 18292, "Purgatory Invader Food", 0, "", 0, "Monster.mimic", 8.5, 8.5, 55, "male", "L2Chest", 40, 2643, 987, 10.27, 2.45, 40, 43, 30, 21, 20, 10, 0, 0, 670, 322, 360, 261, 278, 0, 333, 0, 0, 0, 88, 181, "ssq_clan", 300, 0, 0, "LAST_HIT", 0, 0, 0, "fighter"),
(18293, 18293, "Forbidden Path Invader Food", 0, "", 0, "Monster.mimic", 8.5, 8.5, 63, "male", "L2Chest", 40, 3302, 1251, 11.85, 2.78, 40, 43, 30, 21, 20, 10, 0, 0, 987, 398, 560, 323, 278, 0, 333, 0, 0, 0, 80, 165, "ssq_clan", 300, 0, 0, "LAST_HIT", 0, 0, 0, "fighter"),
(18294, 18294, "Forbidden Path Invader Food", 0, "", 0, "Monster.mimic", 8.5, 8.5, 65, "male", "L2Chest", 40, 3465, 1319, 11.85, 2.78, 40, 43, 30, 21, 20, 10, 0, 0, 1077, 418, 619, 340, 278, 0, 333, 0, 0, 0, 88, 181, "ssq_clan", 300, 0, 0, "LAST_HIT", 0, 0, 0, "fighter"),
(18295, 18295, "Dark Omen Invader Food", 0, "", 0, "Monster.mimic", 8.5, 8.5, 73, "male", "L2Chest", 40, 4086, 1601, 13.43, 3.09, 40, 43, 30, 21, 20, 10, 0, 0, 1463, 502, 885, 407, 278, 0, 333, 0, 0, 0, 88, 181, "ssq_clan", 300, 0, 0, "LAST_HIT", 0, 0, 0, "fighter"),
(18296, 18296, "Dark Omen Invader Food", 0, "", 0, "Monster.mimic", 8.5, 8.5, 75, "male", "L2Chest", 40, 4229, 1673, 13.43, 3.09, 40, 43, 30, 21, 20, 10, 0, 0, 1563, 523, 957, 425, 278, 0, 333, 0, 0, 0, 88, 181, "ssq_clan", 300, 0, 0, "LAST_HIT", 0, 0, 0, "fighter"),
(18297, 18297, "Messenger Invader Food", 0, "", 0, "Monster.mimic", 8.5, 8.5, 83, "male", "L2Chest", 40, 4716, 1972, 13.43, 3.09, 40, 43, 30, 21, 20, 10, 0, 0, 1959, 608, 1258, 494, 278, 0, 333, 0, 0, 0, 80, 165, "ssq_clan", 300, 0, 0, "LAST_HIT", 0, 0, 0, "fighter"),
(18298, 18298, "Messenger Invader Food", 0, "", 0, "Monster.mimic", 8.5, 8.5, 85, "male", "L2Chest", 40, 4813, 2049, 13.43, 3.09, 40, 43, 30, 21, 20, 10, 0, 0, 2052, 629, 1333, 511, 278, 0, 333, 0, 0, 0, 88, 181, "ssq_clan", 300, 0, 0, "LAST_HIT", 0, 0, 0, "fighter"),
(18299, 18299, "Flame of the Branded", 0, "", 0, "Monster.big_boom", 6, 13, 35, "male", "L2Npc", 40, 1220, 446, 21.33, 1.84, 40, 43, 30, 21, 20, 10, 1631, 96, 192, 169, 89, 137, 278, 0, 333, 0, 0, 0, 52, 33, "NULL", 0, 0, 0, "LAST_HIT", 0, 0, 0, "fighter"),
(18300, 18300, "Offering of the Branded, Evoked Spirit", 0, "", 0, "Monster.orc", 10, 21, 33, "male", "L2Npc", 40, 1109, 413, 7.11, 1.84, 40, 43, 30, 21, 20, 10, 1751, 100, 166, 157, 75, 128, 278, 0, 333, 158, 0, 0, 49, 170, "NULL", 0, 0, 0, "LAST_HIT", 0, 0, 0, "fighter"),
(18301, 18301, "Flame of Apostates", 0, "", 0, "Monster.big_boom", 6, 13, 46, "male", "L2Npc", 40, 1943, 707, 26.07, 2.14, 40, 43, 30, 21, 20, 10, 2817, 199, 401, 245, 202, 199, 278, 0, 333, 0, 0, 0, 52, 33, "NULL", 0, 0, 0, "LAST_HIT", 0, 0, 0, "fighter"),
(18302, 18302, "Offering of Apostates, Evoked Spirit", 0, "", 0, "Monster.orc_fighter", 12, 22, 44, "male", "L2Npc", 40, 1799, 648, 8.69, 2.14, 40, 43, 30, 21, 20, 10, 3113, 213, 354, 230, 176, 187, 278, 0, 333, 172, 0, 0, 49, 176, "NULL", 0, 0, 0, "LAST_HIT", 0, 0, 0, "fighter"),
(18303, 18303, "Flame of the Witch", 0, "", 0, "Monster.big_boom", 6, 13, 57, "male", "L2Npc", 40, 2806, 1052, 30.81, 2.45, 40, 43, 30, 21, 20, 10, 4326, 359, 743, 340, 405, 276, 278, 0, 333, 0, 0, 0, 52, 33, "NULL", 0, 0, 0, "LAST_HIT", 0, 0, 0, "fighter"),
(18304, 18304, "Offering of the Witch, Evoked Spirit", 0, "", 0, "Monster.batur_orc", 9, 21.5, 55, "male", "L2Npc", 40, 2643, 987, 10.27, 2.45, 40, 43, 30, 21, 20, 10, 4864, 393, 670, 322, 360, 261, 278, 0, 333, 91, 0, 0, 88, 181, "NULL", 0, 0, 0, "LAST_HIT", 0, 0, 0, "fighter"),
(18305, 18305, "Flame of Dark Omen", 0, "", 0, "Monster.big_boom", 6, 13, 68, "male", "L2Npc", 40, 3706, 1423, 35.55, 2.78, 40, 43, 30, 21, 20, 10, 6157, 594, 1217, 449, 713, 365, 278, 0, 333, 0, 0, 0, 52, 33, "NULL", 0, 0, 0, "LAST_HIT", 0, 0, 0, "fighter"),
(18306, 18306, "Offering of Dark Omen, Evoked Spirit", 0, "", 0, "Monster.batur_orc", 9, 21.5, 66, "male", "L2Npc", 40, 3546, 1353, 11.85, 2.78, 40, 43, 30, 21, 20, 10, 7004, 659, 1123, 428, 649, 348, 278, 0, 333, 2503, 0, 0, 88, 187, "NULL", 0, 0, 0, "LAST_HIT", 0, 0, 0, "fighter"),
(18307, 18307, "Flame of Forbidden Path", 0, "", 0, "Monster.big_boom", 6, 13, 79, "male", "L2Npc", 40, 4490, 1821, 40.29, 3.09, 40, 43, 30, 21, 20, 10, 8311, 921, 1765, 566, 1107, 459, 278, 0, 333, 0, 0, 0, 52, 33, "NULL", 0, 0, 0, "LAST_HIT", 0, 0, 0, "fighter"),
(18308, 18308, "Offering of /Forbidden Path, Evoked Spirit", 0, "", 0, "Monster.batur_orc_warrior", 10, 20, 77, "male", "L2Npc", 40, 4364, 1747, 13.43, 3.09, 40, 43, 30, 21, 20, 10, 9533, 1032, 1664, 544, 1031, 442, 278, 0, 333, 175, 0, 0, 88, 192, "NULL", 0, 0, 0, "LAST_HIT", 0, 0, 0, "fighter"),
(18309, 18309, "Flame of the Branded", 0, "", 0, "Monster.big_boom", 6, 13, 35, "male", "L2Npc", 40, 1220, 446, 21.33, 1.84, 40, 43, 30, 21, 20, 10, 1631, 96, 192, 169, 89, 137, 278, 0, 333, 0, 0, 0, 52, 33, "NULL", 0, 0, 0, "LAST_HIT", 0, 0, 0, "fighter"),
(18310, 18310, "Offering of the Branded, Evoked Spirit", 0, "", 0, "Monster.orc", 10, 21, 33, "male", "L2Npc", 40, 1109, 413, 7.11, 1.84, 40, 43, 30, 21, 20, 10, 1751, 100, 166, 157, 75, 128, 278, 0, 333, 158, 0, 0, 49, 170, "NULL", 0, 0, 0, "LAST_HIT", 0, 0, 0, "fighter"),
(18311, 18311, "Flame of Apostates", 0, "", 0, "Monster.big_boom", 6, 13, 46, "male", "L2Npc", 40, 1943, 707, 26.07, 2.14, 40, 43, 30, 21, 20, 10, 2817, 199, 401, 245, 202, 199, 278, 0, 333, 0, 0, 0, 52, 33, "NULL", 0, 0, 0, "LAST_HIT", 0, 0, 0, "fighter"),
(18312, 18312, "Offering of Apostates, Evoked Spirit", 0, "", 0, "Monster.orc_fighter", 12, 22, 44, "male", "L2Npc", 40, 1799, 648, 8.69, 2.14, 40, 43, 30, 21, 20, 10, 3113, 213, 354, 230, 176, 187, 278, 0, 333, 172, 0, 0, 49, 176, "NULL", 0, 0, 0, "LAST_HIT", 0, 0, 0, "fighter"),
(18313, 18313, "Flame of the Witch", 0, "", 0, "Monster.big_boom", 6, 13, 57, "male", "L2Npc", 40, 2806, 1052, 30.81, 2.45, 40, 43, 30, 21, 20, 10, 4326, 359, 743, 340, 405, 276, 278, 0, 333, 0, 0, 0, 52, 33, "NULL", 0, 0, 0, "LAST_HIT", 0, 0, 0, "fighter"),
(18314, 18314, "Offering of the Witch, Evoked Spirit", 0, "", 0, "Monster.batur_orc", 9, 21.5, 55, "male", "L2Npc", 40, 2643, 987, 10.27, 2.45, 40, 43, 30, 21, 20, 10, 4864, 393, 670, 322, 360, 261, 278, 0, 333, 91, 0, 0, 88, 181, "NULL", 0, 0, 0, "LAST_HIT", 0, 0, 0, "fighter"),
(18315, 18315, "Flame of Dark Omen", 0, "", 0, "Monster.big_boom", 6, 13, 68, "male", "L2Npc", 40, 3706, 1423, 35.55, 2.78, 40, 43, 30, 21, 20, 10, 6157, 594, 1217, 449, 713, 365, 278, 0, 333, 0, 0, 0, 52, 33, "NULL", 0, 0, 0, "LAST_HIT", 0, 0, 0, "fighter"),
(18316, 18316, "Offering of Dark Omen, Evoked Spirit", 0, "", 0, "Monster.batur_orc", 9, 21.5, 66, "male", "L2Npc", 40, 3546, 1353, 11.85, 2.78, 40, 43, 30, 21, 20, 10, 7004, 659, 1123, 428, 649, 348, 278, 0, 333, 2503, 0, 0, 88, 187, "NULL", 0, 0, 0, "LAST_HIT", 0, 0, 0, "fighter"),
(18317, 18317, "Flame of Forbidden Path", 0, "", 0, "Monster.big_boom", 6, 13, 79, "male", "L2Npc", 40, 4490, 1821, 40.29, 3.09, 40, 43, 30, 21, 20, 10, 8311, 921, 1765, 566, 1107, 459, 278, 0, 333, 0, 0, 0, 52, 33, "NULL", 0, 0, 0, "LAST_HIT", 0, 0, 0, "fighter"),
(18318, 18318, "Offering of Forbidden Path, Evoked Spirit", 0, "", 0, "Monster.batur_orc_warrior", 10, 20, 77, "male", "L2Npc", 40, 4364, 1747, 13.43, 3.09, 40, 43, 30, 21, 20, 10, 9533, 1032, 1664, 544, 1031, 442, 278, 0, 333, 175, 0, 0, 88, 192, "NULL", 0, 0, 0, "LAST_HIT", 0, 0, 0, "fighter"),
(18319, 18319, "Caught Frog", 0, "", 0, "Monster.poison_toad", 20, 10, 10, "male", "L2PenaltyMonster", 40, 257, 120, 3.16, 0.91, 40, 43, 30, 21, 20, 10, 421, 14, 22, 52, 8, 49, 278, 0, 333, 0, 0, 0, 55, 121, "NULL", 0, 0, 0, "LAST_HIT", 0, 0, 0, "fighter"),
(18320, 18320, "Caught Undine", 0, "", 0, "Monster.undine", 12, 27, 20, "female", "L2PenaltyMonster", 40, 541, 213, 3.95, 1.21, 40, 43, 30, 21, 20, 10, 843, 37, 57, 80, 23, 76, 278, 0, 333, 0, 0, 0, 66, 132, "NULL", 0, 0, 0, "LAST_HIT", 0, 0, 0, "fighter"),
(18321, 18321, "Caught Rakul", 0, "", 0, "Monster.rakul", 30, 39, 30, "male", "L2PenaltyMonster", 40, 954, 365, 5.53, 1.53, 40, 43, 30, 21, 20, 10, 1550, 85, 132, 119, 58, 114, 278, 0, 333, 156, 0, 0, 66, 143, "NULL", 0, 1, 0, "LAST_HIT", 0, 0, 0, "fighter"),
(18322, 18322, "Caught Sea Giant", 0, "", 0, "Monster.water_giant", 13, 44, 40, "male", "L2PenaltyMonster", 40, 1527, 531, 7.11, 1.84, 40, 43, 30, 21, 20, 10, 2755, 178, 273, 171, 131, 164, 278, 0, 333, 131, 0, 0, 38, 154, "NULL", 0, 0, 0, "LAST_HIT", 0, 0, 0, "fighter"),
(18323, 18323, "Caught Sea Horse Soldier", 0, "", 0, "Monster.theeder", 9, 32, 50, "male", "L2PenaltyMonster", 80, 2245, 830, 8.69, 2.14, 40, 43, 30, 21, 20, 10, 4305, 324, 509, 236, 264, 226, 278, 0, 333, 291, 0, 0, 80, 150, "NULL", 0, 0, 0, "LAST_HIT", 0, 0, 0, "fighter"),
(18324, 18324, "Caught Homunculus", 0, "", 0, "Monster2.homunculus", 12, 32.5, 60, "male", "L2PenaltyMonster", 40, 3054, 1150, 10.27, 2.45, 40, 43, 30, 21, 20, 10, 6200, 538, 860, 313, 478, 299, 278, 0, 333, 0, 0, 0, 30, 160, "NULL", 0, 0, 0, "LAST_HIT", 0, 0, 0, "fighter"),
(18325, 18325, "Caught Flava", 0, "", 0, "Monster2.flava", 18, 34, 70, "male", "L2PenaltyMonster", 40, 3862, 1493, 11.85, 2.78, 40, 43, 30, 21, 20, 10, 8438, 837, 1314, 399, 780, 382, 278, 0, 333, 0, 0, 0, 30, 170, "NULL", 0, 0, 0, "LAST_HIT", 0, 0, 0, "fighter"),
(18326, 18326, "Caught Gigantic Eye", 0, "", 0, "Monster2.hundred_eye", 21, 55, 80, "male", "L2PenaltyMonster", 40, 4550, 1859, 13.43, 3.09, 40, 43, 30, 21, 20, 10, 11022, 1237, 1814, 490, 1144, 468, 278, 0, 333, 0, 0, 0, 33, 198, "NULL", 0, 0, 0, "LAST_HIT", 0, 0, 0, "fighter"),
(18327, 18327, "Freya's Servant", 0, "", 0, "Monster.gargoyle_02te", 11, 20, 58, "male", "L2Monster", 80, 400000, 9999, 13.43, 3.09, 40, 43, 30, 21, 20, 10, 440000, 40000, 9000, 5000, 6000, 6000, 300, 500, 333, 0, 0, 0, 88, 132, "NULL", 0, 0, 0, "LAST_HIT", 0, 0, 0, "balanced"),
(18328, 18328, "Hall Alarm Device", 0, "", 0, "NPC.grave_keeper_key", 11, 20, 80, "male", "L2Monster", 80, 400000, 9999, 13.43, 3.09, 40, 43, 30, 21, 20, 10, 440000, 40000, 9000, 5000, 6000, 6000, 300, 500, 333, 0, 0, 0, 88, 132, "NULL", 0, 0, 0, "LAST_HIT", 0, 0, 0, "balanced"),
(18329, 18329, "Hall Keeper Captain", 0, "", 0, "Monster.death_lord", 11, 20, 80, "male", "L2Monster", 80, 400000, 9999, 13.43, 3.09, 40, 43, 30, 21, 20, 10, 440000, 40000, 9000, 5000, 6000, 6000, 300, 500, 333, 0, 0, 0, 88, 132, "NULL", 0, 0, 0, "LAST_HIT", 0, 0, 0, "balanced"),
(18330, 18330, "Hall Keeper Wizard", 0, "", 0, "Monster.vale_master", 11, 20, 80, "male", "L2Monster", 80, 400000, 9999, 13.43, 3.09, 40, 43, 30, 21, 20, 10, 440000, 40000, 9000, 5000, 6000, 6000, 300, 500, 333, 0, 0, 0, 88, 132, "NULL", 0, 0, 0, "LAST_HIT", 0, 0, 0, "balanced"),
(18331, 18331, "Hall Keeper Guard", 0, "", 0, "Monster.death_knight", 11, 20, 80, "male", "L2Monster", 80, 400000, 9999, 13.43, 3.09, 40, 43, 30, 21, 20, 10, 440000, 40000, 9000, 5000, 6000, 6000, 300, 500, 333, 0, 0, 0, 88, 132, "NULL", 0, 0, 0, "LAST_HIT", 0, 0, 0, "balanced"),
(18332, 18332, "Hall Keeper Patrol", 0, "", 0, "Monster.headless_knight", 11, 20, 80, "male", "L2Monster", 80, 400000, 9999, 13.43, 3.09, 40, 43, 30, 21, 20, 10, 440000, 40000, 9000, 5000, 6000, 6000, 300, 500, 333, 0, 0, 0, 88, 132, "NULL", 0, 0, 0, "LAST_HIT", 0, 0, 0, "balanced"),
(18333, 18333, "Hall Keeper Suicidal Soldier", 0, "", 0, "Monster3.self_blaster", 11, 20, 80, "male", "L2Monster", 80, 400000, 9999, 13.43, 3.09, 40, 43, 30, 21, 20, 10, 440000, 40000, 9000, 5000, 6000, 6000, 300, 500, 333, 0, 0, 0, 88, 132, "NULL", 0, 0, 0, "LAST_HIT", 0, 0, 0, "balanced"),
(18334, 18334, "Dark Choir Captain", 0, "", 0, "Monster2.erinyes_cmd", 11, 20, 85, "male", "L2Monster", 80, 400000, 9999, 13.43, 3.09, 40, 43, 30, 21, 20, 10, 440000, 40000, 9000, 5000, 6000, 6000, 300, 500, 333, 0, 0, 0, 88, 132, "NULL", 0, 0, 0, "LAST_HIT", 0, 0, 0, "balanced"),
(18335, 18335, "Dark Choir Prima Donna", 0, "", 0, "Monster3.portrait_spirit", 11, 20, 80, "male", "L2Monster", 80, 400000, 9999, 13.43, 3.09, 40, 43, 30, 21, 20, 10, 440000, 40000, 9000, 5000, 6000, 6000, 300, 500, 333, 0, 0, 0, 88, 132, "NULL", 0, 0, 0, "LAST_HIT", 0, 0, 0, "balanced"),
(18336, 18336, "Dark Choir Lancer", 0, "", 0, "Monster.death_blader", 11, 20, 80, "male", "L2Monster", 80, 400000, 9999, 13.43, 3.09, 40, 43, 30, 21, 20, 10, 440000, 40000, 9000, 5000, 6000, 6000, 300, 500, 333, 0, 0, 0, 88, 132, "NULL", 0, 0, 0, "LAST_HIT", 0, 0, 0, "balanced"),
(18337, 18337, "Dark Choir Archer", 0, "", 0, "Monster.skeleton_archer_20_bi", 11, 20, 80, "male", "L2Monster", 80, 400000, 9999, 13.43, 3.09, 40, 43, 30, 21, 20, 10, 440000, 40000, 9000, 5000, 6000, 6000, 300, 500, 333, 0, 0, 0, 88, 132, "NULL", 0, 0, 0, "LAST_HIT", 0, 0, 0, "archer"),
(18338, 18338, "Dark Choir Witch Doctor", 0, "", 0, "Monster3.portrait_spirit_winged", 11, 20, 80, "male", "L2Monster", 80, 400000, 9999, 13.43, 3.09, 40, 43, 30, 21, 20, 10, 440000, 40000, 9000, 5000, 6000, 6000, 300, 500, 333, 0, 0, 0, 88, 132, "NULL", 0, 0, 0, "LAST_HIT", 0, 0, 0, "balanced"),
(18339, 18339, "Dark Choir Player", 0, "", 0, "Monster.skeleton", 11, 20, 80, "male", "L2Monster", 80, 400000, 9999, 13.43, 3.09, 40, 43, 30, 21, 20, 10, 440000, 40000, 9000, 5000, 6000, 6000, 300, 500, 333, 0, 0, 0, 88, 132, "NULL", 0, 0, 0, "LAST_HIT", 0, 0, 0, "balanced"),
(18340, 18340, "Hall Keeper Suicidal Soldier", 0, "", 0, "Monster3.self_blaster", 11, 20, 80, "male", "L2Monster", 80, 400000, 9999, 13.43, 3.09, 40, 43, 30, 21, 20, 10, 440000, 40000, 9000, 5000, 6000, 6000, 300, 500, 333, 0, 0, 0, 88, 132, "NULL", 0, 0, 0, "LAST_HIT", 0, 0, 0, "balanced"),
(18341, 18341, "Hall Keeper Suicidal Soldier", 0, "", 0, "Monster3.self_blaster", 11, 20, 80, "male", "L2Monster", 80, 400000, 9999, 13.43, 3.09, 40, 43, 30, 21, 20, 10, 440000, 40000, 9000, 5000, 6000, 6000, 300, 500, 333, 0, 0, 0, 88, 132, "NULL", 0, 0, 0, "LAST_HIT", 0, 0, 0, "balanced"),
(18342, 18342, "Gremlin", 0, "", 0, "Monster.gremlin", 10, 15, 1, "male", "L2Monster", 40, 62, 44, 3.16, 0.91, 40, 43, 30, 21, 20, 10, 29, 2, 9, 39, 3, 32, 278, 0, 333, 0, 0, 0, 20, 50, "NULL", 0, 0, 0, "LAST_HIT", 0, 0, 0, "fighter"),
(18343, 18343, "Gatekeeper Zombie", 0, "", 0, "Monster3.zombie_gateguard", 17, 30.5, 78, "male", "L2Monster", 80, 400000, 9999, 13.43, 3.09, 40, 43, 30, 21, 20, 10, 440000, 40000, 9000, 5000, 6000, 6000, 278, 500, 333, 8217, 0, 0, 33, 120, "NULL", 0, 0, 0, "LAST_HIT", 0, 0, 0, "balanced"),
(18344, 18344, "Ancient Egg", 0, "", 0, "NpcEV.dinosaur_nest", 43, 33.5, 78, "male", "L2Monster", 0, 3, 3, 4.74, 3.09, 40, 43, 30, 21, 20, 10, 0, 0, 1, 606, 1, 1182, 278, 0, 333, 0, 0, 0, 50, 100, "NULL", 0, 0, 0, "LAST_HIT", 0, 0, 0, "balanced"),
(18345, 18345, "Sprigant", 0, "", 0, "Monster3.Arachnoid", 45, 67, 78, "male", "L2Monster", 40, 1179, 2057, 13.43, 3.09, 40, 43, 30, 21, 20, 10, 0, 0, 2129, 615, 2129, 511, 278, 500, 333, 0, 0, 0, 60, 165, "NULL", 0, 0, 0, "LAST_HIT", 0, 0, 0, "balanced"),
(18346, 18346, "Sprigant", 0, "", 0, "Monster3.Arachnoid", 45, 67, 78, "male", "L2Monster", 40, 1179, 2057, 13.43, 3.09, 40, 43, 30, 21, 20, 10, 0, 0, 2129, 615, 2129, 511, 300, 500, 333, 0, 0, 0, 0, 0, "NULL", 0, 0, 0, "LAST_HIT", 0, 0, 0, "balanced"),
(18347, 18347, "Garden Guard", 0, "", 0, "LineageMonster4.Mostro_Fighter", 15.5, 22.5, 1, "male", "L2Npc", 40, 2444, 2444, 0, 0, 10, 10, 10, 10, 10, 10, 0, 0, 500, 500, 500, 500, 253, 0, 253, 0, 0, NULL, 80, 120, "", 0, 0, 0, "LAST_HIT", 0, 0, 0, "balanced"),
(18348, 18348, "Garden Guard", 0, "", 0, "LineageMonster4.Mostro_Fighter", 15.5, 22.5, 1, "male", "L2Npc", 40, 2444, 2444, 0, 0, 10, 10, 10, 10, 10, 10, 0, 0, 500, 500, 500, 500, 253, 0, 253, 0, 0, NULL, 80, 120, "", 0, 0, 0, "LAST_HIT", 0, 0, 0, "balanced"),
(18349, 18349, "Garden Guard", 0, "", 0, "LineageMonster4.Mostro_Gunner", 15, 24.5, 1, "male", "L2Npc", 40, 2444, 2444, 0, 0, 10, 10, 10, 10, 10, 10, 0, 0, 500, 500, 500, 500, 253, 0, 253, 0, 0, NULL, 80, 120, "", 0, 0, 0, "LAST_HIT", 0, 0, 0, "balanced"),
(18350, 18350, "Garden Guard", 0, "", 0, "LineageMonster4.Mostro_Fighter", 15.5, 22.5, 1, "male", "L2Npc", 40, 2444, 2444, 0, 0, 10, 10, 10, 10, 10, 10, 0, 0, 500, 500, 500, 500, 253, 0, 253, 0, 0, NULL, 80, 120, "", 0, 0, 0, "LAST_HIT", 0, 0, 0, "balanced"),
(18351, 18351, "Garden Guard", 0, "", 0, "LineageMonster4.Mostro_Fighter", 15.5, 22.5, 1, "male", "L2Npc", 40, 2444, 2444, 0, 0, 10, 10, 10, 10, 10, 10, 0, 0, 500, 500, 500, 500, 253, 0, 253, 0, 0, NULL, 80, 120, "", 0, 0, 0, "LAST_HIT", 0, 0, 0, "balanced"),
(18352, 18352, "Kamael Guard", 0, "", 0, "LineageMonster4.Mostro_Fighter", 15.5, 22.5, 1, "male", "L2Npc", 40, 2444, 2444, 0, 0, 10, 10, 10, 10, 10, 10, 0, 0, 500, 500, 500, 500, 253, 0, 253, 0, 0, NULL, 80, 120, "", 0, 0, 0, "LAST_HIT", 0, 0, 0, "balanced"),
(18353, 18353, "Guardian of Records", 0, "", 0, "LineageMonster4.Mostro_Fighter", 15.5, 22.5, 1, "male", "L2Npc", 40, 2444, 2444, 0, 0, 10, 10, 10, 10, 10, 10, 0, 0, 500, 500, 500, 500, 253, 0, 253, 0, 0, NULL, 80, 120, "", 0, 0, 0, "LAST_HIT", 0, 0, 0, "balanced"),
(18354, 18354, "Guardian of Observation", 0, "", 0, "LineageMonster4.Mostro_Fighter", 15.5, 22.5, 1, "male", "L2Npc", 40, 2444, 2444, 0, 0, 10, 10, 10, 10, 10, 10, 0, 0, 500, 500, 500, 500, 253, 0, 253, 0, 0, NULL, 80, 120, "", 0, 0, 0, "LAST_HIT", 0, 0, 0, "balanced"),
(18355, 18355, "Spicula's Guard", 0, "", 0, "LineageMonster4.Mostro_Fighter", 15.5, 22.5, 1, "male", "L2Npc", 40, 2444, 2444, 0, 0, 10, 10, 10, 10, 10, 10, 0, 0, 500, 500, 500, 500, 253, 0, 253, 0, 0, NULL, 80, 120, "", 0, 0, 0, "LAST_HIT", 0, 0, 0, "balanced"),
(18356, 18356, "Harkilgamed's Gatekeeper", 0, "", 0, "LineageMonster4.Mostro_Gunner", 15, 24.5, 1, "male", "L2Npc", 40, 2444, 2444, 0, 0, 10, 10, 10, 10, 10, 10, 0, 0, 500, 500, 500, 500, 253, 0, 253, 0, 0, NULL, 80, 120, "", 0, 0, 0, "LAST_HIT", 0, 0, 0, "balanced"),
(18357, 18357, "Rodenpicula's Gatekeeper", 0, "", 0, "LineageMonster4.Mostro_Fighter", 15.5, 22.5, 1, "male", "L2Npc", 40, 2444, 2444, 0, 0, 10, 10, 10, 10, 10, 10, 0, 0, 500, 500, 500, 500, 253, 0, 253, 0, 0, NULL, 80, 120, "", 0, 0, 0, "LAST_HIT", 0, 0, 0, "balanced"),
(18358, 18358, "Guardian of Secrets", 0, "", 0, "LineageMonster4.Mostro_Fighter", 15.5, 22.5, 1, "male", "L2Npc", 40, 2444, 2444, 0, 0, 10, 10, 10, 10, 10, 10, 0, 0, 500, 500, 500, 500, 253, 0, 253, 0, 0, NULL, 80, 120, "", 0, 0, 0, "LAST_HIT", 0, 0, 0, "balanced"),
(18359, 18359, "Arviterre's Guardian", 0, "", 0, "LineageMonster4.Mostro_Fighter", 15.5, 22.5, 1, "male", "L2Npc", 40, 2444, 2444, 0, 0, 10, 10, 10, 10, 10, 10, 0, 0, 500, 500, 500, 500, 253, 0, 253, 0, 0, NULL, 80, 120, "", 0, 0, 0, "LAST_HIT", 0, 0, 0, "balanced"),
(18360, 18360, "Katenar's Gatekeeper", 0, "", 0, "LineageMonster4.Mostro_Fighter", 15.5, 22.5, 1, "male", "L2Npc", 40, 2444, 2444, 0, 0, 10, 10, 10, 10, 10, 10, 0, 0, 500, 500, 500, 500, 253, 0, 253, 0, 0, NULL, 80, 120, "", 0, 0, 0, "LAST_HIT", 0, 0, 0, "balanced"),
(18361, 18361, "Guardian of Prediction", 0, "", 0, "LineageMonster4.Mostro_Fighter", 15.5, 22.5, 1, "male", "L2Npc", 40, 2444, 2444, 0, 0, 10, 10, 10, 10, 10, 10, 0, 0, 500, 500, 500, 500, 253, 0, 253, 0, 0, NULL, 80, 120, "", 0, 0, 0, "LAST_HIT", 0, 0, 0, "balanced"),
(18362, 18362, "Garden Guard", 0, "", 0, "LineageMonster4.Mostro_Fighter", 15.5, 22.5, 1, "male", "L2Npc", 40, 2444, 2444, 0, 0, 10, 10, 10, 10, 10, 10, 0, 0, 500, 500, 500, 500, 253, 0, 253, 0, 0, NULL, 80, 120, "", 0, 0, 0, "LAST_HIT", 0, 0, 0, "balanced"),
(18363, 18363, "Garden Guard", 0, "", 0, "LineageMonster4.Mostro_Gunner", 15, 24.5, 1, "male", "L2Npc", 40, 2444, 2444, 0, 0, 10, 10, 10, 10, 10, 10, 0, 0, 500, 500, 500, 500, 253, 0, 253, 0, 0, NULL, 80, 120, "", 0, 0, 0, "LAST_HIT", 0, 0, 0, "balanced"),
(18364, 18364, "Witch Warder", 0, "", 0, "LineageMonster.onyx_beast", 14, 14.5, 79, "male", "L2Monster", 40, 22454, 1821, 26.86, 3.09, 40, 43, 30, 21, 20, 10, 9955, 1103, 1765, 481, 1107, 459, 278, 0, 333, 92, 0, 0, 11, 165, "NULL", 0, 0, 0, "LAST_HIT", 0, 0, 0, "fighter"),
(18365, 18365, "Witch Warder", 0, "", 0, "LineageMonster.onyx_beast", 14, 14.5, 80, "male", "L2Monster", 40, 22754, 1859, 26.86, 3.09, 40, 43, 30, 21, 20, 10, 9304, 1044, 1996, 524, 1144, 468, 278, 0, 333, 79, 0, 0, 39, 192, "NULL", 0, 0, 0, "LAST_HIT", 0, 0, 0, "fighter"),
(18366, 18366, "Witch Warder", 0, "", 0, "LineageMonster.onyx_beast", 14, 14.5, 82, "male", "L2Monster", 40, 23319, 1934, 26.86, 3.09, 40, 43, 30, 21, 20, 10, 9625, 1106, 1912, 598, 1220, 485, 278, 0, 333, 79, 0, 0, 49, 192, "NULL", 0, 0, 0, "LAST_HIT", 0, 0, 0, "fighter"),
(18367, 18367, "Prison Guard", 0, "", 0, "LineageMonster3.zombie_gateguard", 17, 30.5, 80, "male", "L2Monster", 40, 4550, 1859, 26.86, 3.09, 40, 43, 30, 21, 20, 10, 9304, 1044, 1996, 524, 1144, 468, 278, 0, 333, 79, 0, 0, 39, 192, "NULL", 0, 0, 0, "LAST_HIT", 0, 0, 0, "fighter"),
(18368, 18368, "Prison Guard", 0, "", 0, "LineageMonster3.zombie_gateguard", 17, 30.5, 80, "male", "L2Monster", 40, 4550, 1859, 26.86, 3.09, 40, 43, 30, 21, 20, 10, 9304, 1044, 1996, 524, 1144, 468, 278, 0, 333, 79, 0, 0, 39, 192, "NULL", 0, 0, 0, "LAST_HIT", 0, 0, 0, "fighter"),
(18369, 18369, "Chromatic Crystaline Golem", 0, "", 0, "LineageMonster4.Crystal_Golem", 40, 47, 1, "male", "L2Npc", 40, 2444, 2444, 0, 0, 10, 10, 10, 10, 10, 10, 0, 0, 500, 500, 500, 500, 253, 0, 253, 0, 0, NULL, 80, 120, "", 0, 0, 0, "LAST_HIT", 0, 0, 0, "balanced"),
(18370, 18370, "Chromatic Crystaline Golem", 0, "", 0, "LineageMonster4.Crystal_Golem", 40, 47, 1, "male", "L2Npc", 40, 2444, 2444, 0, 0, 10, 10, 10, 10, 10, 10, 0, 0, 500, 500, 500, 500, 253, 0, 253, 0, 0, NULL, 80, 120, "", 0, 0, 0, "LAST_HIT", 0, 0, 0, "balanced"),
(18371, 18371, "Beleth Sample", 0, "", 0, "LineageMonster3.zombie_gateguard", 17, 30.5, 1, "male", "L2Npc", 40, 2444, 2444, 0, 0, 10, 10, 10, 10, 10, 10, 0, 0, 500, 500, 500, 500, 253, 0, 253, 0, 0, NULL, 80, 120, "", 0, 0, 0, "LAST_HIT", 0, 0, 0, "balanced"),
(18372, 18372, "Beleth Sample", 0, "", 0, "LineageMonster3.zombie_laborer", 11, 24.6, 1, "male", "L2Npc", 40, 2444, 2444, 0, 0, 10, 10, 10, 10, 10, 10, 0, 0, 500, 500, 500, 500, 253, 0, 253, 0, 0, NULL, 80, 120, "", 0, 0, 0, "LAST_HIT", 0, 0, 0, "balanced"),
(18373, 18373, "Beleth Sample", 0, "", 0, "LineageMonster3.zombie_enlisted_man", 17, 22.3, 1, "male", "L2Npc", 40, 2444, 2444, 0, 0, 10, 10, 10, 10, 10, 10, 0, 0, 500, 500, 500, 500, 253, 0, 253, 0, 0, NULL, 80, 120, "", 0, 0, 0, "LAST_HIT", 0, 0, 0, "balanced"),
(18374, 18374, "Beleth Sample", 0, "", 0, "LineageMonster3.zombie_em_knight", 17, 22.3, 1, "male", "L2Npc", 40, 2444, 2444, 0, 0, 10, 10, 10, 10, 10, 10, 0, 0, 500, 500, 500, 500, 253, 0, 253, 0, 0, NULL, 80, 120, "", 0, 0, 0, "LAST_HIT", 0, 0, 0, "balanced"),
(18375, 18375, "Beleth Sample", 0, "", 0, "LineageMonster.skeleton_royal_guard", 11, 28.5, 1, "male", "L2Npc", 40, 2444, 2444, 0, 0, 10, 10, 10, 10, 10, 10, 0, 0, 500, 500, 500, 500, 253, 0, 253, 0, 0, NULL, 80, 120, "", 0, 0, 0, "LAST_HIT", 0, 0, 0, "balanced"),
(18376, 18376, "Beleth Sample", 0, "", 0, "LineageMonster.vale_master", 16, 47, 1, "male", "L2Npc", 40, 2444, 2444, 0, 0, 10, 10, 10, 10, 10, 10, 0, 0, 500, 500, 500, 500, 253, 0, 253, 0, 0, NULL, 80, 120, "", 0, 0, 0, "LAST_HIT", 0, 0, 0, "balanced"),
(18377, 18377, "Beleth Sample", 0, "", 0, "LineageMonster.skeleton_knight", 10, 25, 1, "male", "L2Npc", 40, 2444, 2444, 0, 0, 10, 10, 10, 10, 10, 10, 0, 0, 500, 500, 500, 500, 253, 0, 253, 0, 0, NULL, 80, 120, "", 0, 0, 0, "LAST_HIT", 0, 0, 0, "balanced"),
(18378, 18378, "Trap", 0, "", 0, "LineageNpcEV.Trap_device_bottom_switch", 20, 13.5, 1, "male", "L2Npc", 40, 2444, 2444, 0, 0, 10, 10, 10, 10, 10, 10, 0, 0, 500, 500, 500, 500, 253, 0, 253, 0, 0, NULL, 80, 120, "", 0, 0, 0, "LAST_HIT", 0, 0, 0, "mage"),
(18379, 18379, "Trap", 0, "", 0, "LineageNpcEV.Trap_device_bottom_staff", 30, 13, 1, "male", "L2Npc", 40, 2444, 2444, 0, 0, 10, 10, 10, 10, 10, 10, 0, 0, 500, 500, 500, 500, 253, 0, 253, 0, 0, NULL, 80, 120, "", 0, 0, 0, "LAST_HIT", 0, 0, 0, "balanced"),
(18380, 18380, "Trap", 0, "", 0, "LineageNpcEV.Trap_device_bottom_staff", 30, 13, 1, "male", "L2Npc", 40, 2444, 2444, 0, 0, 10, 10, 10, 10, 10, 10, 0, 0, 500, 500, 500, 500, 253, 0, 253, 0, 0, NULL, 80, 120, "", 0, 0, 0, "LAST_HIT", 0, 0, 0, "balanced"),
(18381, 18381, "Trap", 0, "", 0, "LineageNpcEV.Trap_device_bottom_staff", 30, 13, 1, "male", "L2Npc", 40, 2444, 2444, 0, 0, 10, 10, 10, 10, 10, 10, 0, 0, 500, 500, 500, 500, 253, 0, 253, 0, 0, NULL, 80, 120, "", 0, 0, 0, "LAST_HIT", 0, 0, 0, "balanced"),
(18382, 18382, "Trap", 0, "", 0, "LineageNpcEV.Trap_device_bottom_staff", 30, 13, 1, "male", "L2Npc", 40, 2444, 2444, 0, 0, 10, 10, 10, 10, 10, 10, 0, 0, 500, 500, 500, 500, 253, 0, 253, 0, 0, NULL, 80, 120, "", 0, 0, 0, "LAST_HIT", 0, 0, 0, "balanced"),
(18383, 18383, "Trap", 0, "", 0, "LineageNpcEV.Trap_device_bottom_staff", 30, 13, 1, "male", "L2Npc", 40, 2444, 2444, 0, 0, 10, 10, 10, 10, 10, 10, 0, 0, 500, 500, 500, 500, 253, 0, 253, 0, 0, NULL, 80, 120, "", 0, 0, 0, "LAST_HIT", 0, 0, 0, "balanced"),
(18384, 18384, "Trap", 0, "", 0, "LineageNpcEV.Trap_device_bottom_staff", 30, 13, 1, "male", "L2Npc", 40, 2444, 2444, 0, 0, 10, 10, 10, 10, 10, 10, 0, 0, 500, 500, 500, 500, 253, 0, 253, 0, 0, NULL, 80, 120, "", 0, 0, 0, "LAST_HIT", 0, 0, 0, "balanced"),
(18385, 18385, "Trap", 0, "", 0, "LineageNpcEV.Trap_device_bottom_staff", 30, 13, 1, "male", "L2Npc", 40, 2444, 2444, 0, 0, 10, 10, 10, 10, 10, 10, 0, 0, 500, 500, 500, 500, 253, 0, 253, 0, 0, NULL, 80, 120, "", 0, 0, 0, "LAST_HIT", 0, 0, 0, "balanced"),
(18386, 18386, "Trap", 0, "", 0, "LineageNpcEV.Trap_device_bottom_staff", 30, 13, 1, "male", "L2Npc", 40, 2444, 2444, 0, 0, 10, 10, 10, 10, 10, 10, 0, 0, 500, 500, 500, 500, 253, 0, 253, 0, 0, NULL, 80, 120, "", 0, 0, 0, "LAST_HIT", 0, 0, 0, "balanced"),
(18387, 18387, "Trap", 0, "", 0, "LineageNpcEV.Trap_device_bottom_staff", 30, 13, 1, "male", "L2Npc", 40, 2444, 2444, 0, 0, 10, 10, 10, 10, 10, 10, 0, 0, 500, 500, 500, 500, 253, 0, 253, 0, 0, NULL, 80, 120, "", 0, 0, 0, "LAST_HIT", 0, 0, 0, "balanced"),
(18388, 18388, "Trap", 0, "", 0, "LineageNpcEV.Trap_device_bottom_staff", 30, 13, 1, "male", "L2Npc", 40, 2444, 2444, 0, 0, 10, 10, 10, 10, 10, 10, 0, 0, 500, 500, 500, 500, 253, 0, 253, 0, 0, NULL, 80, 120, "", 0, 0, 0, "LAST_HIT", 0, 0, 0, "balanced"),
(18389, 18389, "Trap", 0, "", 0, "LineageNpcEV.Trap_device_bottom_staff", 30, 13, 1, "male", "L2Npc", 40, 2444, 2444, 0, 0, 10, 10, 10, 10, 10, 10, 0, 0, 500, 500, 500, 500, 253, 0, 253, 0, 0, NULL, 80, 120, "", 0, 0, 0, "LAST_HIT", 0, 0, 0, "balanced"),
(18390, 18390, "Trap", 0, "", 0, "LineageNpcEV.Trap_device_bottom_staff", 30, 13, 1, "male", "L2Npc", 40, 2444, 2444, 0, 0, 10, 10, 10, 10, 10, 10, 0, 0, 500, 500, 500, 500, 253, 0, 253, 0, 0, NULL, 80, 120, "", 0, 0, 0, "LAST_HIT", 0, 0, 0, "balanced"),
(18391, 18391, "Trap", 0, "", 0, "LineageNpcEV.Trap_device_bottom_staff", 30, 13, 1, "male", "L2Npc", 40, 2444, 2444, 0, 0, 10, 10, 10, 10, 10, 10, 0, 0, 500, 500, 500, 500, 253, 0, 253, 0, 0, NULL, 80, 120, "", 0, 0, 0, "LAST_HIT", 0, 0, 0, "balanced"),
(18392, 18392, "Trap", 0, "", 0, "LineageNpcEV.Trap_device_bottom_staff", 30, 13, 1, "male", "L2Npc", 40, 2444, 2444, 0, 0, 10, 10, 10, 10, 10, 10, 0, 0, 500, 500, 500, 500, 253, 0, 253, 0, 0, NULL, 80, 120, "", 0, 0, 0, "LAST_HIT", 0, 0, 0, "balanced"),
(18393, 18393, "Trap", 0, "", 0, "LineageNpcEV.Trap_device_bottom_staff", 30, 13, 1, "male", "L2Npc", 40, 2444, 2444, 0, 0, 10, 10, 10, 10, 10, 10, 0, 0, 500, 500, 500, 500, 253, 0, 253, 0, 0, NULL, 80, 120, "", 0, 0, 0, "LAST_HIT", 0, 0, 0, "balanced"),
(18394, 18394, "Trap", 0, "", 0, "LineageNpcEV.Trap_device_bottom_staff", 30, 13, 1, "male", "L2Npc", 40, 2444, 2444, 0, 0, 10, 10, 10, 10, 10, 10, 0, 0, 500, 500, 500, 500, 253, 0, 253, 0, 0, NULL, 80, 120, "", 0, 0, 0, "LAST_HIT", 0, 0, 0, "balanced"),
(18395, 18395, "Trap", 0, "", 0, "LineageNpcEV.Trap_device_bottom_staff", 30, 13, 1, "male", "L2Npc", 40, 2444, 2444, 0, 0, 10, 10, 10, 10, 10, 10, 0, 0, 500, 500, 500, 500, 253, 0, 253, 0, 0, NULL, 80, 120, "", 0, 0, 0, "LAST_HIT", 0, 0, 0, "balanced"),
(18396, 18396, "Trap", 0, "", 0, "LineageNpcEV.Trap_device_bottom_staff", 30, 13, 1, "male", "L2Npc", 40, 2444, 2444, 0, 0, 10, 10, 10, 10, 10, 10, 0, 0, 500, 500, 500, 500, 253, 0, 253, 0, 0, NULL, 80, 120, "", 0, 0, 0, "LAST_HIT", 0, 0, 0, "balanced"),
(18397, 18397, "Trap", 0, "", 0, "LineageNpcEV.Trap_device_bottom_staff", 30, 13, 1, "male", "L2Npc", 40, 2444, 2444, 0, 0, 10, 10, 10, 10, 10, 10, 0, 0, 500, 500, 500, 500, 253, 0, 253, 0, 0, NULL, 80, 120, "", 0, 0, 0, "LAST_HIT", 0, 0, 0, "balanced"),
(18398, 18398, "Trap", 0, "", 0, "LineageNpcEV.Trap_device_bottom_staff", 30, 13, 1, "male", "L2Npc", 40, 2444, 2444, 0, 0, 10, 10, 10, 10, 10, 10, 0, 0, 500, 500, 500, 500, 253, 0, 253, 0, 0, NULL, 80, 120, "", 0, 0, 0, "LAST_HIT", 0, 0, 0, "balanced"),
(18399, 18399, "Trap", 0, "", 0, "LineageNpcEV.Trap_device_bottom_staff", 30, 13, 1, "male", "L2Npc", 40, 2444, 2444, 0, 0, 10, 10, 10, 10, 10, 10, 0, 0, 500, 500, 500, 500, 253, 0, 253, 0, 0, NULL, 80, 120, "", 0, 0, 0, "LAST_HIT", 0, 0, 0, "balanced"),
(18400, 18400, "Trap", 0, "", 0, "LineageNpcEV.Trap_device_bottom_staff", 30, 13, 1, "male", "L2Npc", 40, 2444, 2444, 0, 0, 10, 10, 10, 10, 10, 10, 0, 0, 500, 500, 500, 500, 253, 0, 253, 0, 0, NULL, 80, 120, "", 0, 0, 0, "LAST_HIT", 0, 0, 0, "balanced"),
(18401, 18401, "Trap", 0, "", 0, "LineageNpcEV.Trap_device_bottom_staff", 30, 13, 1, "male", "L2Npc", 40, 2444, 2444, 0, 0, 10, 10, 10, 10, 10, 10, 0, 0, 500, 500, 500, 500, 253, 0, 253, 0, 0, NULL, 80, 120, "", 0, 0, 0, "LAST_HIT", 0, 0, 0, "balanced"),
(18402, 18402, "Trap", 0, "", 0, "LineageNpcEV.Trap_device_bottom_staff", 30, 13, 1, "male", "L2Npc", 40, 2444, 2444, 0, 0, 10, 10, 10, 10, 10, 10, 0, 0, 500, 500, 500, 500, 253, 0, 253, 0, 0, NULL, 80, 120, "", 0, 0, 0, "LAST_HIT", 0, 0, 0, "balanced"),
(18403, 18403, "Trap", 0, "", 0, "LineageNpcEV.Trap_device_bottom_staff", 30, 13, 1, "male", "L2Npc", 40, 2444, 2444, 0, 0, 10, 10, 10, 10, 10, 10, 0, 0, 500, 500, 500, 500, 253, 0, 253, 0, 0, NULL, 80, 120, "", 0, 0, 0, "LAST_HIT", 0, 0, 0, "balanced"),
(18404, 18404, "Trap", 0, "", 0, "LineageNpcEV.Trap_device_bottom_staff", 30, 13, 1, "male", "L2Npc", 40, 2444, 2444, 0, 0, 10, 10, 10, 10, 10, 10, 0, 0, 500, 500, 500, 500, 253, 0, 253, 0, 0, NULL, 80, 120, "", 0, 0, 0, "LAST_HIT", 0, 0, 0, "balanced"),
(18405, 18405, "Trap", 0, "", 0, "LineageNpcEV.Trap_device_bottom_staff", 30, 13, 1, "male", "L2Npc", 40, 2444, 2444, 0, 0, 10, 10, 10, 10, 10, 10, 0, 0, 500, 500, 500, 500, 253, 0, 253, 0, 0, NULL, 80, 120, "", 0, 0, 0, "LAST_HIT", 0, 0, 0, "balanced"),
(18406, 18406, "Trap", 0, "", 0, "LineageNpcEV.Trap_device_bottom_staff", 30, 13, 1, "male", "L2Npc", 40, 2444, 2444, 0, 0, 10, 10, 10, 10, 10, 10, 0, 0, 500, 500, 500, 500, 253, 0, 253, 0, 0, NULL, 80, 120, "", 0, 0, 0, "LAST_HIT", 0, 0, 0, "balanced"),
(18407, 18407, "Trap", 0, "", 0, "LineageNpcEV.Trap_device_bottom_staff", 30, 13, 1, "male", "L2Npc", 40, 2444, 2444, 0, 0, 10, 10, 10, 10, 10, 10, 0, 0, 500, 500, 500, 500, 253, 0, 253, 0, 0, NULL, 80, 120, "", 0, 0, 0, "LAST_HIT", 0, 0, 0, "balanced"),
(18408, 18408, "Trap", 0, "", 0, "LineageNpcEV.Trap_device_bottom_staff", 30, 13, 1, "male", "L2Npc", 40, 2444, 2444, 0, 0, 10, 10, 10, 10, 10, 10, 0, 0, 500, 500, 500, 500, 253, 0, 253, 0, 0, NULL, 80, 120, "", 0, 0, 0, "LAST_HIT", 0, 0, 0, "balanced"),
(18409, 18409, "Trap", 0, "", 0, "LineageNpcEV.Trap_device_bottom_staff", 30, 13, 1, "male", "L2Npc", 40, 2444, 2444, 0, 0, 10, 10, 10, 10, 10, 10, 0, 0, 500, 500, 500, 500, 253, 0, 253, 0, 0, NULL, 80, 120, "", 0, 0, 0, "LAST_HIT", 0, 0, 0, "balanced"),
(18410, 18410, "Trap", 0, "", 0, "LineageNpcEV.Trap_device_bottom_staff", 30, 13, 1, "male", "L2Npc", 40, 2444, 2444, 0, 0, 10, 10, 10, 10, 10, 10, 0, 0, 500, 500, 500, 500, 253, 0, 253, 0, 0, NULL, 80, 120, "", 0, 0, 0, "LAST_HIT", 0, 0, 0, "balanced"),
(18411, 18411, "Trap", 0, "", 0, "LineageNpcEV.Trap_device_bottom_staff", 30, 13, 1, "male", "L2Npc", 40, 2444, 2444, 0, 0, 10, 10, 10, 10, 10, 10, 0, 0, 500, 500, 500, 500, 253, 0, 253, 0, 0, NULL, 80, 120, "", 0, 0, 0, "LAST_HIT", 0, 0, 0, "balanced"),
(18412, 18412, "Trap", 0, "", 0, "LineageNpcEV.Trap_device_bottom_staff", 30, 13, 1, "male", "L2Npc", 40, 2444, 2444, 0, 0, 10, 10, 10, 10, 10, 10, 0, 0, 500, 500, 500, 500, 253, 0, 253, 0, 0, NULL, 80, 120, "", 0, 0, 0, "LAST_HIT", 0, 0, 0, "balanced"),
(18413, 18413, "Trap", 0, "", 0, "LineageNpcEV.Trap_device_bottom_staff", 30, 13, 1, "male", "L2Npc", 40, 2444, 2444, 0, 0, 10, 10, 10, 10, 10, 10, 0, 0, 500, 500, 500, 500, 253, 0, 253, 0, 0, NULL, 80, 120, "", 0, 0, 0, "LAST_HIT", 0, 0, 0, "balanced"),
(18414, 18414, "Warrior's Gatekeeper", 0, "", 0, "LineageNpcEV.trioll_altar", 9, 33.5, 1, "male", "L2Npc", 40, 2444, 2444, 0, 0, 10, 10, 10, 10, 10, 10, 0, 0, 500, 500, 500, 500, 253, 0, 253, 0, 0, NULL, 80, 120, "", 0, 0, 0, "LAST_HIT", 0, 0, 0, "balanced"),
(18415, 18415, "Midway Gatekeeper", 0, "", 0, "LineageNpcEV.trioll_altar", 9, 33.5, 1, "male", "L2Npc", 40, 2444, 2444, 0, 0, 10, 10, 10, 10, 10, 10, 0, 0, 500, 500, 500, 500, 253, 0, 253, 0, 0, NULL, 80, 120, "", 0, 0, 0, "LAST_HIT", 0, 0, 0, "balanced"),
(18416, 18416, "Doorman", 0, "", 0, "LineageNpcEV.trioll_altar", 9, 33.5, 1, "male", "L2Npc", 40, 2444, 2444, 0, 0, 10, 10, 10, 10, 10, 10, 0, 0, 500, 500, 500, 500, 253, 0, 253, 0, 0, NULL, 80, 120, "", 0, 0, 0, "LAST_HIT", 0, 0, 0, "balanced"),
(18417, 18417, "Bridge Keeper", 0, "", 0, "LineageNpcEV.trioll_altar", 9, 33.5, 1, "male", "L2Npc", 40, 2444, 2444, 0, 0, 10, 10, 10, 10, 10, 10, 0, 0, 500, 500, 500, 500, 253, 0, 253, 0, 0, NULL, 80, 120, "", 0, 0, 0, "LAST_HIT", 0, 0, 0, "balanced"),
(18418, 18418, "Bridge Keeper", 0, "", 0, "LineageNpcEV.trioll_altar", 9, 33.5, 1, "male", "L2Npc", 40, 2444, 2444, 0, 0, 10, 10, 10, 10, 10, 10, 0, 0, 500, 500, 500, 500, 253, 0, 253, 0, 0, NULL, 80, 120, "", 0, 0, 0, "LAST_HIT", 0, 0, 0, "balanced"),
(18419, 18419, "Bridge Keeper", 0, "", 0, "LineageNpcEV.trioll_altar", 9, 33.5, 1, "male", "L2Npc", 40, 2444, 2444, 0, 0, 10, 10, 10, 10, 10, 10, 0, 0, 500, 500, 500, 500, 253, 0, 253, 0, 0, NULL, 80, 120, "", 0, 0, 0, "LAST_HIT", 0, 0, 0, "balanced"),
(18420, 18420, "Trap", 0, "", 0, "LineageNpcEV.trioll_altar", 9, 33.5, 1, "male", "L2Npc", 40, 2444, 2444, 0, 0, 10, 10, 10, 10, 10, 10, 0, 0, 500, 500, 500, 500, 253, 0, 253, 0, 0, NULL, 80, 120, "", 0, 0, 0, "LAST_HIT", 0, 0, 0, "balanced"),
(18421, 18421, "Trap", 0, "", 0, "LineageNpcEV.Trap_device_bottom_staff", 30, 13, 1, "male", "L2Npc", 40, 2444, 2444, 0, 0, 10, 10, 10, 10, 10, 10, 0, 0, 500, 500, 500, 500, 253, 0, 253, 0, 0, NULL, 80, 120, "", 0, 0, 0, "LAST_HIT", 0, 0, 0, "balanced"),
(18422, 18422, "Trap", 0, "", 0, "LineageNpcEV.Trap_device_bottom_staff", 30, 13, 1, "male", "L2Npc", 40, 2444, 2444, 0, 0, 10, 10, 10, 10, 10, 10, 0, 0, 500, 500, 500, 500, 253, 0, 253, 0, 0, NULL, 80, 120, "", 0, 0, 0, "LAST_HIT", 0, 0, 0, "balanced"),
(18423, 18423, "Trap", 0, "", 0, "LineageNpcEV.Trap_device_bottom_staff", 30, 13, 1, "male", "L2Npc", 40, 2444, 2444, 0, 0, 10, 10, 10, 10, 10, 10, 0, 0, 500, 500, 500, 500, 253, 0, 253, 0, 0, NULL, 80, 120, "", 0, 0, 0, "LAST_HIT", 0, 0, 0, "balanced"),
(18424, 18424, "Trap", 0, "", 0, "LineageNpcEV.Trap_device_bottom_staff", 30, 13, 1, "male", "L2Npc", 40, 2444, 2444, 0, 0, 10, 10, 10, 10, 10, 10, 0, 0, 500, 500, 500, 500, 253, 0, 253, 0, 0, NULL, 80, 120, "", 0, 0, 0, "LAST_HIT", 0, 0, 0, "balanced"),
(18425, 18425, "Trap", 0, "", 0, "LineageNpcEV.Trap_device_bottom_staff", 30, 13, 1, "male", "L2Npc", 40, 2444, 2444, 0, 0, 10, 10, 10, 10, 10, 10, 0, 0, 500, 500, 500, 500, 253, 0, 253, 0, 0, NULL, 80, 120, "", 0, 0, 0, "LAST_HIT", 0, 0, 0, "balanced"),
(18426, 18426, "Trap", 0, "", 0, "LineageNpcEV.Trap_device_bottom_staff", 30, 13, 1, "male", "L2Npc", 40, 2444, 2444, 0, 0, 10, 10, 10, 10, 10, 10, 0, 0, 500, 500, 500, 500, 253, 0, 253, 0, 0, NULL, 80, 120, "", 0, 0, 0, "LAST_HIT", 0, 0, 0, "balanced"),
(18427, 18427, "Trap", 0, "", 0, "LineageNpcEV.Trap_device_bottom_staff", 30, 13, 1, "male", "L2Npc", 40, 2444, 2444, 0, 0, 10, 10, 10, 10, 10, 10, 0, 0, 500, 500, 500, 500, 253, 0, 253, 0, 0, NULL, 80, 120, "", 0, 0, 0, "LAST_HIT", 0, 0, 0, "balanced"),
(18428, 18428, "Trap", 0, "", 0, "LineageNpcEV.Trap_device_bottom_staff", 30, 13, 1, "male", "L2Npc", 40, 2444, 2444, 0, 0, 10, 10, 10, 10, 10, 10, 0, 0, 500, 500, 500, 500, 253, 0, 253, 0, 0, NULL, 80, 120, "", 0, 0, 0, "LAST_HIT", 0, 0, 0, "balanced"),
(18429, 18429, "Trap", 0, "", 0, "LineageNpcEV.Trap_device_bottom_staff", 30, 13, 1, "male", "L2Npc", 40, 2444, 2444, 0, 0, 10, 10, 10, 10, 10, 10, 0, 0, 500, 500, 500, 500, 253, 0, 253, 0, 0, NULL, 80, 120, "", 0, 0, 0, "LAST_HIT", 0, 0, 0, "balanced"),
(18430, 18430, "Trap", 0, "", 0, "LineageNpcEV.Trap_device_bottom_staff", 30, 13, 1, "male", "L2Npc", 40, 2444, 2444, 0, 0, 10, 10, 10, 10, 10, 10, 0, 0, 500, 500, 500, 500, 253, 0, 253, 0, 0, NULL, 80, 120, "", 0, 0, 0, "LAST_HIT", 0, 0, 0, "balanced"),
(18431, 18431, "Trap", 0, "", 0, "LineageNpcEV.Trap_device_bottom_staff", 30, 13, 1, "male", "L2Npc", 40, 2444, 2444, 0, 0, 10, 10, 10, 10, 10, 10, 0, 0, 500, 500, 500, 500, 253, 0, 253, 0, 0, NULL, 80, 120, "", 0, 0, 0, "LAST_HIT", 0, 0, 0, "balanced"),
(18432, 18432, "Trap", 0, "", 0, "LineageNpcEV.Trap_device_wall_switch", 13.6, 38, 1, "male", "L2Npc", 40, 2444, 2444, 0, 0, 10, 10, 10, 10, 10, 10, 0, 0, 500, 500, 500, 500, 253, 0, 253, 0, 0, NULL, 80, 120, "", 0, 0, 0, "LAST_HIT", 0, 0, 0, "mage"),
(18433, 18433, "Trap", 0, "", 0, "LineageNpcEV.Trap_device_bottom_staff", 30, 13, 1, "male", "L2Npc", 40, 2444, 2444, 0, 0, 10, 10, 10, 10, 10, 10, 0, 0, 500, 500, 500, 500, 253, 0, 253, 0, 0, NULL, 80, 120, "", 0, 0, 0, "LAST_HIT", 0, 0, 0, "balanced"),
(18434, 18434, "Trap", 0, "", 0, "LineageNpcEV.Trap_device_bottom_staff", 30, 13, 1, "male", "L2Npc", 40, 2444, 2444, 0, 0, 10, 10, 10, 10, 10, 10, 0, 0, 500, 500, 500, 500, 253, 0, 253, 0, 0, NULL, 80, 120, "", 0, 0, 0, "LAST_HIT", 0, 0, 0, "balanced"),
(18435, 18435, "Trap", 0, "", 0, "LineageNpcEV.Trap_device_bottom_staff", 30, 13, 1, "male", "L2Npc", 40, 2444, 2444, 0, 0, 10, 10, 10, 10, 10, 10, 0, 0, 500, 500, 500, 500, 253, 0, 253, 0, 0, NULL, 80, 120, "", 0, 0, 0, "LAST_HIT", 0, 0, 0, "balanced"),
(18436, 18436, "Trap", 0, "", 0, "LineageNpcEV.Trap_device_bottom_staff", 30, 13, 1, "male", "L2Npc", 40, 2444, 2444, 0, 0, 10, 10, 10, 10, 10, 10, 0, 0, 500, 500, 500, 500, 253, 0, 253, 0, 0, NULL, 80, 120, "", 0, 0, 0, "LAST_HIT", 0, 0, 0, "balanced"),
(18437, 18437, "Trap", 0, "", 0, "LineageNPC.clear_npc", 0.1, 0.1, 1, "male", "L2Npc", 40, 2444, 2444, 0, 0, 10, 10, 10, 10, 10, 10, 0, 0, 500, 500, 500, 500, 253, 0, 253, 0, 0, NULL, 80, 120, "", 0, 0, 0, "LAST_HIT", 0, 0, 0, "balanced"),
(18438, 18438, "Trap", 0, "", 0, "LineageNpcEV.trioll_altar", 9, 33.5, 1, "male", "L2Npc", 40, 2444, 2444, 0, 0, 10, 10, 10, 10, 10, 10, 0, 0, 500, 500, 500, 500, 253, 0, 253, 0, 0, NULL, 80, 120, "", 0, 0, 0, "LAST_HIT", 0, 0, 0, "balanced"),
(18439, 18439, "Trap", 0, "", 0, "LineageNpcEV.Trap_device_bottom_staff", 30, 13, 1, "male", "L2Npc", 40, 2444, 2444, 0, 0, 10, 10, 10, 10, 10, 10, 0, 0, 500, 500, 500, 500, 253, 0, 253, 0, 0, NULL, 80, 120, "", 0, 0, 0, "LAST_HIT", 0, 0, 0, "balanced"),
(18440, 18440, "Trap", 0, "", 0, "LineageNpcEV.Trap_device_bottom_staff", 30, 13, 1, "male", "L2Npc", 40, 2444, 2444, 0, 0, 10, 10, 10, 10, 10, 10, 0, 0, 500, 500, 500, 500, 253, 0, 253, 0, 0, NULL, 80, 120, "", 0, 0, 0, "LAST_HIT", 0, 0, 0, "balanced"),
(18441, 18441, "Kamael Gatekeeper", 0, "", 0, "LineageNpcEV.trioll_altar", 9, 33.5, 1, "male", "L2Npc", 40, 2444, 2444, 0, 0, 10, 10, 10, 10, 10, 10, 0, 0, 500, 500, 500, 500, 253, 0, 253, 0, 0, NULL, 80, 120, "", 0, 0, 0, "LAST_HIT", 0, 0, 0, "balanced"),
(18442, 18442, "Trap", 0, "", 0, "LineageNpcEV.trioll_altar", 9, 33.5, 1, "male", "L2Npc", 40, 2444, 2444, 0, 0, 10, 10, 10, 10, 10, 10, 0, 0, 500, 500, 500, 500, 253, 0, 253, 0, 0, NULL, 80, 120, "", 0, 0, 0, "LAST_HIT", 0, 0, 0, "balanced"),
(18443, 18443, "Trap", 0, "", 0, "LineageNpcEV.Trap_device_bottom_staff", 30, 13, 1, "male", "L2Npc", 40, 2444, 2444, 0, 0, 10, 10, 10, 10, 10, 10, 0, 0, 500, 500, 500, 500, 253, 0, 253, 0, 0, NULL, 80, 120, "", 0, 0, 0, "LAST_HIT", 0, 0, 0, "balanced"),
(18444, 18444, "Garden Guard", 0, "", 0, "LineageMonster4.Mostro_Fighter", 15.5, 22.5, 1, "male", "L2Npc", 40, 2444, 2444, 0, 0, 10, 10, 10, 10, 10, 10, 0, 0, 500, 500, 500, 500, 253, 0, 253, 0, 0, NULL, 80, 120, "", 0, 0, 0, "LAST_HIT", 0, 0, 0, "balanced"),
(18445, 18445, "Doorman", 0, "", 0, "LineageNpcEV.trioll_altar", 9, 33.5, 1, "male", "L2Npc", 40, 2444, 2444, 0, 0, 10, 10, 10, 10, 10, 10, 0, 0, 500, 500, 500, 500, 253, 0, 253, 0, 0, NULL, 80, 120, "", 0, 0, 0, "LAST_HIT", 0, 0, 0, "balanced"),
(18446, 18446, "Doorman", 0, "", 0, "LineageNpcEV.trioll_altar", 9, 33.5, 1, "male", "L2Npc", 40, 2444, 2444, 0, 0, 10, 10, 10, 10, 10, 10, 0, 0, 500, 500, 500, 500, 253, 0, 253, 0, 0, NULL, 80, 120, "", 0, 0, 0, "LAST_HIT", 0, 0, 0, "balanced"),
(18447, 18447, "Doorman", 0, "", 0, "LineageNpcEV.trioll_altar", 9, 33.5, 1, "male", "L2Npc", 40, 2444, 2444, 0, 0, 10, 10, 10, 10, 10, 10, 0, 0, 500, 500, 500, 500, 253, 0, 253, 0, 0, NULL, 80, 120, "", 0, 0, 0, "LAST_HIT", 0, 0, 0, "balanced"),
(18448, 18448, "Doorman", 0, "", 0, "LineageNpcEV.trioll_altar", 9, 33.5, 1, "male", "L2Npc", 40, 2444, 2444, 0, 0, 10, 10, 10, 10, 10, 10, 0, 0, 500, 500, 500, 500, 253, 0, 253, 0, 0, NULL, 80, 120, "", 0, 0, 0, "LAST_HIT", 0, 0, 0, "balanced"),
(18449, 18449, "Doorman", 0, "", 0, "LineageNpcEV.trioll_altar", 9, 33.5, 1, "male", "L2Npc", 40, 2444, 2444, 0, 0, 10, 10, 10, 10, 10, 10, 0, 0, 500, 500, 500, 500, 253, 0, 253, 0, 0, NULL, 80, 120, "", 0, 0, 0, "LAST_HIT", 0, 0, 0, "balanced"),
(18450, 18450, "Doorman", 0, "", 0, "LineageNpcEV.trioll_altar", 9, 33.5, 1, "male", "L2Npc", 40, 2444, 2444, 0, 0, 10, 10, 10, 10, 10, 10, 0, 0, 500, 500, 500, 500, 253, 0, 253, 0, 0, NULL, 80, 120, "", 0, 0, 0, "LAST_HIT", 0, 0, 0, "balanced"),
(18451, 18451, "Doorman", 0, "", 0, "LineageNpcEV.trioll_altar", 9, 33.5, 1, "male", "L2Npc", 40, 2444, 2444, 0, 0, 10, 10, 10, 10, 10, 10, 0, 0, 500, 500, 500, 500, 253, 0, 253, 0, 0, NULL, 80, 120, "", 0, 0, 0, "LAST_HIT", 0, 0, 0, "balanced"),
(18452, 18452, "Doorman", 0, "", 0, "LineageNpcEV.trioll_altar", 9, 33.5, 1, "male", "L2Npc", 40, 2444, 2444, 0, 0, 10, 10, 10, 10, 10, 10, 0, 0, 500, 500, 500, 500, 253, 0, 253, 0, 0, NULL, 80, 120, "", 0, 0, 0, "LAST_HIT", 0, 0, 0, "balanced"),
(18453, 18453, "Doorman", 0, "", 0, "LineageNpcEV.trioll_altar", 9, 33.5, 1, "male", "L2Npc", 40, 2444, 2444, 0, 0, 10, 10, 10, 10, 10, 10, 0, 0, 500, 500, 500, 500, 253, 0, 253, 0, 0, NULL, 80, 120, "", 0, 0, 0, "LAST_HIT", 0, 0, 0, "balanced"),
(18454, 18454, "Doorman", 0, "", 0, "LineageNpcEV.trioll_altar", 9, 33.5, 1, "male", "L2Npc", 40, 2444, 2444, 0, 0, 10, 10, 10, 10, 10, 10, 0, 0, 500, 500, 500, 500, 253, 0, 253, 0, 0, NULL, 80, 120, "", 0, 0, 0, "LAST_HIT", 0, 0, 0, "balanced"),
(18455, 18455, "Doorman", 0, "", 0, "LineageNpcEV.trioll_altar", 9, 33.5, 1, "male", "L2Npc", 40, 2444, 2444, 0, 0, 10, 10, 10, 10, 10, 10, 0, 0, 500, 500, 500, 500, 253, 0, 253, 0, 0, NULL, 80, 120, "", 0, 0, 0, "LAST_HIT", 0, 0, 0, "balanced"),
(18456, 18456, "Doorman", 0, "", 0, "LineageNpcEV.trioll_altar", 9, 33.5, 1, "male", "L2Npc", 40, 2444, 2444, 0, 0, 10, 10, 10, 10, 10, 10, 0, 0, 500, 500, 500, 500, 253, 0, 253, 0, 0, NULL, 80, 120, "", 0, 0, 0, "LAST_HIT", 0, 0, 0, "balanced"),
(18457, 18457, "Doorman", 0, "", 0, "LineageNpcEV.trioll_altar", 9, 33.5, 1, "male", "L2Npc", 40, 2444, 2444, 0, 0, 10, 10, 10, 10, 10, 10, 0, 0, 500, 500, 500, 500, 253, 0, 253, 0, 0, NULL, 80, 120, "", 0, 0, 0, "LAST_HIT", 0, 0, 0, "balanced"),
(18458, 18458, "Doorman", 0, "", 0, "LineageNpcEV.trioll_altar", 9, 33.5, 1, "male", "L2Npc", 40, 2444, 2444, 0, 0, 10, 10, 10, 10, 10, 10, 0, 0, 500, 500, 500, 500, 253, 0, 253, 0, 0, NULL, 80, 120, "", 0, 0, 0, "LAST_HIT", 0, 0, 0, "balanced"),
(18459, 18459, "Doorman", 0, "", 0, "LineageNpcEV.trioll_altar", 9, 33.5, 1, "male", "L2Npc", 40, 2444, 2444, 0, 0, 10, 10, 10, 10, 10, 10, 0, 0, 500, 500, 500, 500, 253, 0, 253, 0, 0, NULL, 80, 120, "", 0, 0, 0, "LAST_HIT", 0, 0, 0, "balanced"),
(18460, 18460, "Doorman", 0, "", 0, "LineageNpcEV.trioll_altar", 9, 33.5, 1, "male", "L2Npc", 40, 2444, 2444, 0, 0, 10, 10, 10, 10, 10, 10, 0, 0, 500, 500, 500, 500, 253, 0, 253, 0, 0, NULL, 80, 120, "", 0, 0, 0, "LAST_HIT", 0, 0, 0, "balanced"),
(18461, 18461, "Doorman", 0, "", 0, "LineageNpcEV.trioll_altar", 9, 33.5, 1, "male", "L2Npc", 40, 2444, 2444, 0, 0, 10, 10, 10, 10, 10, 10, 0, 0, 500, 500, 500, 500, 253, 0, 253, 0, 0, NULL, 80, 120, "", 0, 0, 0, "LAST_HIT", 0, 0, 0, "balanced"),
(18462, 18462, "Remnant Wraith", 0, "", 0, "LineageMonster3.solina_brother", 11, 28.5, 1, "male", "L2Npc", 40, 2444, 2444, 0, 0, 10, 10, 10, 10, 10, 10, 0, 0, 500, 500, 500, 500, 253, 0, 253, 0, 0, NULL, 80, 120, "", 0, 0, 0, "LAST_HIT", 0, 0, 0, "balanced"),
(18463, 18463, "Remnant Diabolist", 0, "", 0, "LineageNPC.e_traderB_Fdwarf_mon_120p", 7.7, 28.4, 1, "male", "L2Npc", 40, 2444, 2444, 0, 0, 10, 10, 10, 10, 10, 10, 0, 0, 500, 500, 500, 500, 253, 0, 253, 0, 0, NULL, 80, 120, "", 0, 0, 0, "LAST_HIT", 0, 0, 0, "balanced"),
(18464, 18464, "Remnant Diviner", 0, "", 0, "LineageNPC.a_mageguild_teacher_Mhuman_mon", 11, 25.4, 1, "male", "L2Npc", 40, 2444, 2444, 0, 0, 10, 10, 10, 10, 10, 10, 0, 0, 500, 500, 500, 500, 253, 0, 253, 0, 0, NULL, 80, 120, "", 0, 0, 0, "LAST_HIT", 0, 0, 0, "mage"),
(18465, 18465, "Derek", 0, "First Generation Seer", 0, "LineageNPC.a_mageguild_teacher_Mhuman_mon_120p", 12.5, 33.5, 1, "male", "L2Npc", 40, 2444, 2444, 0, 0, 10, 10, 10, 10, 10, 10, 0, 0, 500, 500, 500, 500, 253, 0, 253, 0, 0, NULL, 80, 120, "", 0, 0, 0, "LAST_HIT", 0, 0, 0, "mage"),
(18466, 18466, "Outpost Captain", 0, "", 0, "LineageMonster3.benom", 20, 56, 1, "male", "L2Npc", 40, 2444, 2444, 0, 0, 10, 10, 10, 10, 10, 10, 0, 0, 500, 500, 500, 500, 253, 0, 253, 0, 0, NULL, 80, 120, "", 0, 0, 0, "LAST_HIT", 0, 0, 0, "balanced"),
(18467, 18467, "Wounded Land Guard", 0, "", 0, "LineageMonster4.eyeless", 36, 43.5, 1, "male", "L2Npc", 40, 2444, 2444, 0, 0, 10, 10, 10, 10, 10, 10, 0, 0, 500, 500, 500, 500, 278, 0, 333, 0, 0, NULL, 60, 210, "", 0, 0, 0, "LAST_HIT", 0, 0, 0, "balanced"),
(18468, 18468, "Doorman", 0, "", 0, "LineageNpcEV.trioll_altar", 9, 33.5, 1, "male", "L2Npc", 40, 2444, 2444, 0, 0, 10, 10, 10, 10, 10, 10, 0, 0, 500, 500, 500, 500, 253, 0, 253, 0, 0, NULL, 80, 120, "", 0, 0, 0, "LAST_HIT", 0, 0, 0, "balanced"),
(18469, 18469, "Hall Guard", 0, "", 0, "LineageMonster.blade_stakato_120p", 20, 41, 1, "male", "L2Npc", 40, 2444, 2444, 0, 0, 10, 10, 10, 10, 10, 10, 0, 0, 500, 500, 500, 500, 253, 0, 253, 0, 0, NULL, 80, 120, "", 0, 0, 0, "LAST_HIT", 0, 0, 0, "balanced"),
(18470, 18470, "Hall Guard", 0, "", 0, "LineageMonster.blade_stakato_soldier_120p", 20, 41, 1, "male", "L2Npc", 40, 2444, 2444, 0, 0, 10, 10, 10, 10, 10, 10, 0, 0, 500, 500, 500, 500, 253, 0, 253, 0, 0, NULL, 80, 120, "", 0, 0, 0, "LAST_HIT", 0, 0, 0, "balanced"),
(18471, 18471, "Hall Guard", 0, "", 0, "LineageMonster4.Anthias", 20, 41, 1, "male", "L2Npc", 40, 2444, 2444, 0, 0, 10, 10, 10, 10, 10, 10, 0, 0, 500, 500, 500, 500, 253, 0, 253, 0, 0, NULL, 80, 120, "", 0, 0, 0, "LAST_HIT", 0, 0, 0, "balanced"),
(18472, 18472, "Hall Guard", 0, "", 0, "LineageMonster4.Anthias", 20, 41, 1, "male", "L2Npc", 40, 2444, 2444, 0, 0, 10, 10, 10, 10, 10, 10, 0, 0, 500, 500, 500, 500, 253, 0, 253, 0, 0, NULL, 80, 120, "", 0, 0, 0, "LAST_HIT", 0, 0, 0, "balanced"),
(18473, 18473, "Hall Captain", 0, "", 0, "LineageMonster3.cannibal_stakato_leader_120p", 20, 27, 1, "male", "L2Npc", 40, 2444, 2444, 0, 0, 10, 10, 10, 10, 10, 10, 0, 0, 500, 500, 500, 500, 253, 0, 253, 0, 0, NULL, 80, 120, "", 0, 0, 0, "LAST_HIT", 0, 0, 0, "balanced"),
(18474, 18474, "Alarm", 0, "", 0, "LineageNpcEV.trioll_altar", 9, 33.5, 1, "male", "L2Npc", 40, 2444, 2444, 0, 0, 10, 10, 10, 10, 10, 10, 0, 0, 500, 500, 500, 500, 253, 0, 253, 0, 0, NULL, 80, 120, "", 0, 0, 0, "LAST_HIT", 0, 0, 0, "balanced"),
(18475, 18475, "Hall Guard", 0, "", 0, "LineageMonster.undine", 20, 41, 1, "male", "L2Npc", 40, 2444, 2444, 0, 0, 10, 10, 10, 10, 10, 10, 0, 0, 500, 500, 500, 500, 253, 0, 253, 0, 0, NULL, 80, 120, "", 0, 0, 0, "LAST_HIT", 0, 0, 0, "balanced"),
(18476, 18476, "Hall Guard", 0, "", 0, "LineageMonster.lienrik_210p", 20, 41, 1, "male", "L2Npc", 40, 2444, 2444, 0, 0, 10, 10, 10, 10, 10, 10, 0, 0, 500, 500, 500, 500, 253, 0, 253, 0, 0, NULL, 80, 120, "", 0, 0, 0, "LAST_HIT", 0, 0, 0, "balanced"),
(18477, 18477, "Coral Treasure Chest", 0, "", 0, "LineageMonster.mimic_even", 8.5, 8.5, 1, "male", "L2Npc", 40, 2444, 2444, 0, 0, 10, 10, 10, 10, 10, 10, 0, 0, 500, 500, 500, 500, 253, 0, 253, 0, 0, NULL, 80, 120, "", 0, 0, 0, "LAST_HIT", 0, 0, 0, "balanced"),
(18478, 18478, "Herb Jar", 0, "", 0, "LineageNpcEV.herb_pot", 8, 21.5, 1, "male", "L2Npc", 40, 2444, 2444, 0, 0, 10, 10, 10, 10, 10, 10, 0, 0, 500, 500, 500, 500, 253, 0, 253, 0, 0, NULL, 80, 120, "", 0, 0, 0, "LAST_HIT", 0, 0, 0, "balanced"),
(18479, 18479, "Inner Castle Sentry", 0, "", 0, "LineageMonster.kel_mahum", 36, 43.5, 1, "male", "L2Npc", 40, 2444, 2444, 0, 0, 10, 10, 10, 10, 10, 10, 0, 0, 500, 500, 500, 500, 253, 0, 253, 0, 0, NULL, 80, 120, "", 0, 0, 0, "LAST_HIT", 0, 0, 0, "balanced"),
(18480, 18480, "Inner Castle Guard", 0, "", 0, "LineageMonster4.eyeless", 36, 43.5, 1, "male", "L2Npc", 40, 2444, 2444, 0, 0, 10, 10, 10, 10, 10, 10, 0, 0, 500, 500, 500, 500, 253, 0, 253, 0, 0, NULL, 80, 120, "", 0, 0, 0, "LAST_HIT", 0, 0, 0, "balanced"),
(18481, 18481, "Inner Castle Seer", 0, "", 0, "LineageMonster4.eyeless", 36, 43.5, 1, "male", "L2Npc", 40, 2444, 2444, 0, 0, 10, 10, 10, 10, 10, 10, 0, 0, 500, 500, 500, 500, 253, 0, 253, 0, 0, NULL, 80, 120, "", 0, 0, 0, "LAST_HIT", 0, 0, 0, "balanced"),
(18482, 18482, "Fafurion Kindred", 0, "", 0, "LineageMonster3.Water_Drake", 35, 58, 1, "male", "L2Npc", 40, 2444, 2444, 0, 0, 10, 10, 10, 10, 10, 10, 0, 0, 500, 500, 500, 500, 253, 0, 253, 0, 0, NULL, 80, 120, "", 0, 0, 0, "LAST_HIT", 0, 0, 0, "balanced"),
(18483, 18483, "Garden Guard", 0, "", 0, "LineageMonster4.Mostro_Fighter", 15.5, 22.5, 1, "male", "L2Npc", 40, 2444, 2444, 0, 0, 10, 10, 10, 10, 10, 10, 0, 0, 500, 500, 500, 500, 253, 0, 253, 0, 0, NULL, 80, 120, "", 0, 0, 0, "LAST_HIT", 0, 0, 0, "balanced"),
(18484, 18484, "Naia Failan", 0, "", 0, "LineageNPC.heart_of_warding", 15.5, 22.5, 1, "male", "L2Npc", 40, 2444, 2444, 0, 0, 10, 10, 10, 10, 10, 10, 0, 0, 500, 500, 500, 500, 253, 0, 253, 0, 0, NULL, 80, 120, "", 0, 0, 0, "LAST_HIT", 0, 0, 0, "balanced"),
(18485, 18485, "", 0, "", 0, "LineageNPC.clear_npc", 0.1, 0.1, 1, "male", "L2Npc", 40, 2444, 2444, 0, 0, 10, 10, 10, 10, 10, 10, 0, 0, 500, 500, 500, 500, 278, 0, 333, 0, 0, NULL, 1, 1, "", 0, 0, 0, "LAST_HIT", 0, 0, 0, "balanced"),
(18486, 18486, "", 0, "", 0, "LineageNPC.clear_npc", 15.5, 22.5, 1, "male", "L2Npc", 40, 2444, 2444, 0, 0, 10, 10, 10, 10, 10, 10, 0, 0, 500, 500, 500, 500, 253, 0, 253, 0, 0, NULL, 80, 120, "", 0, 0, 0, "LAST_HIT", 0, 0, 0, "balanced"),
(18487, 18487, "", 0, "", 0, "LineageNPC.clear_npc", 0.1, 0.1, 1, "male", "L2Npc", 40, 2444, 2444, 0, 0, 10, 10, 10, 10, 10, 10, 0, 0, 500, 500, 500, 500, 278, 0, 333, 0, 0, NULL, 1, 1, "", 0, 0, 0, "LAST_HIT", 0, 0, 0, "balanced"),
(18488, 18488, "", 0, "", 0, "LineageNPC.clear_npc", 15.5, 22.5, 1, "male", "L2Npc", 40, 2444, 2444, 0, 0, 10, 10, 10, 10, 10, 10, 0, 0, 500, 500, 500, 500, 253, 0, 253, 0, 0, NULL, 80, 120, "", 0, 0, 0, "LAST_HIT", 0, 0, 0, "balanced"),
(18489, 18489, "", 0, "", 0, "LineageNPC.clear_npc", 15.5, 22.5, 1, "male", "L2Npc", 40, 2444, 2444, 0, 0, 10, 10, 10, 10, 10, 10, 0, 0, 500, 500, 500, 500, 253, 0, 253, 0, 0, NULL, 80, 120, "", 0, 0, 0, "LAST_HIT", 0, 0, 0, "balanced");

INSERT INTO `npc` VALUES
(20001, 20001, "Gremlin", 0, "", 0, "Monster.gremlin", 10, 15, 1, "male", "L2Monster", 40, 62, 44, 3.16, 0.91, 40, 43, 30, 21, 20, 10, 29, 2, 9, 39, 3, 32, 278, 0, 333, 0, 0, 0, 22, 55, "NULL", 0, 0, 0, "LAST_HIT", 0, 0, 0, "fighter"),
(20002, 20002, "Rabbit", 0, "", 0, "Monster.rabbit", 5, 4.5, 1, "male", "L2Monster", 40, 62, 44, 3.16, 0.91, 40, 43, 30, 21, 20, 10, 29, 2, 9, 39, 3, 32, 278, 0, 333, 0, 0, 0, 55, 88, "NULL", 0, 0, 0, "LAST_HIT", 0, 0, 0, "fighter"),
(20003, 20003, "Goblin", 0, "", 0, "Monster.goblin", 10, 16.5, 5, "male", "L2Monster", 40, 126, 77, 3.16, 0.91, 40, 43, 30, 21, 20, 10, 178, 5, 13, 48, 4, 39, 278, 0, 333, 4, 0, 0, 40, 110, "goblin_clan", 300, 0, 0, "LAST_HIT", 0, 0, 0, "fighter"),
(20004, 20004, "Imp", 0, "", 0, "Monster.imp", 10, 24, 6, "male", "L2Monster", 40, 147, 85, 3.16, 0.91, 40, 43, 30, 21, 20, 10, 213, 6, 15, 50, 5, 41, 278, 0, 333, 0, 0, 0, 60, 80, "demonic_clan", 300, 0, 0, "LAST_HIT", 0, 0, 0, "fighter"),
(20005, 20005, "Imp Elder", 0, "", 0, "Monster.imp", 10, 24, 7, "male", "L2Monster", 40, 171, 94, 3.16, 0.91, 40, 43, 30, 21, 20, 10, 249, 8, 18, 48, 6, 43, 278, 0, 333, 0, 0, 0, 60, 80, "demonic_clan", 300, 0, 0, "LAST_HIT", 0, 0, 0, "fighter"),
(20006, 20006, "Orc Archer", 0, "", 0, "Monster.orc_archer", 14, 25, 8, "male", "L2Monster", 500, 197, 102, 3.16, 0.91, 40, 43, 30, 21, 20, 10, 293, 10, 41, 55, 6, 45, 249, 0, 333, 14, 0, 0, 49, 121, "orc_clan", 300, 0, 0, "LAST_HIT", 0, 0, 0, "archer"),
(20007, 20007, "Green Fungus", 0, "", 0, "Monster.walking_fungus", 15, 22.5, 9, "male", "L2Monster", 40, 226, 111, 3.16, 0.91, 40, 43, 30, 21, 20, 10, 321, 11, 22, 53, 7, 47, 278, 0, 333, 0, 0, 0, 70, 110, "NULL", 0, 0, 0, "LAST_HIT", 0, 0, 0, "fighter"),
(20008, 20008, "Felim Lizardman", 0, "", 0, "Monster.virud_lizardman", 10, 23, 14, "male", "L2Monster", 40, 364, 156, 3.95, 1.21, 40, 43, 30, 21, 20, 10, 498, 19, 30, 80, 12, 59, 278, 0, 333, 1, 0, 0, 47, 143, "lizardman_clan", 300, 0, 0, "LAST_HIT", 0, 0, 0, "fighter"),
(20009, 20009, "Vuku Orc", 0, "", 0, "Monster.orc", 10, 21, 14, "male", "L2Monster", 40, 364, 156, 3.95, 1.21, 40, 43, 30, 21, 20, 10, 498, 19, 33, 73, 12, 59, 278, 0, 333, 156, 0, 0, 49, 121, "orc_clan", 300, 0, 0, "LAST_HIT", 0, 0, 0, "fighter"),
(20010, 20010, "Felim Lizardman Scout", 0, "", 0, "Monster.virud_lizardman", 10, 23, 15, "male", "L2Monster", 40, 390, 165, 3.95, 1.21, 40, 43, 30, 21, 20, 10, 534, 22, 40, 69, 14, 62, 278, 0, 333, 16, 0, 0, 47, 143, "lizardman_clan", 300, 0, 0, "LAST_HIT", 0, 0, 0, "fighter"),
(20011, 20011, "Vuku Orc Archer", 0, "", 0, "Monster.orc_archer", 14, 25, 15, "male", "L2Monster", 500, 390, 165, 3.95, 1.21, 40, 43, 30, 21, 20, 10, 550, 22, 82, 76, 14, 62, 249, 0, 333, 14, 0, 0, 49, 121, "orc_clan", 300, 0, 0, "LAST_HIT", 0, 0, 0, "archer"),
(20012, 20012, "Gora Werewolf", 0, "", 0, "Monster.werewolf", 10, 26, 16, "male", "L2Monster", 40, 417, 174, 3.95, 1.21, 40, 43, 30, 21, 20, 10, 582, 23, 44, 72, 15, 64, 278, 500, 333, 0, 0, 0, 55, 132, "werewolf_clan", 300, 0, 0, "LAST_HIT", 0, 0, 0, "fighter"),
(20013, 20013, "Dryad", 0, "", 0, "Monster.dryad", 9, 20, 13, "female", "L2Monster", 40, 339, 147, 3.95, 1.21, 40, 43, 30, 21, 20, 10, 462, 18, 27, 77, 11, 56, 278, 0, 333, 0, 0, 0, 44, 121, "elemental1_clan", 300, 0, 0, "LAST_HIT", 0, 0, 0, "fighter"),
(20014, 20014, "Felim Lizardman Warrior", 0, "", 0, "Monster.virud_lizardman_warrior", 12, 30, 17, "male", "L2Monster", 40, 446, 184, 3.95, 1.21, 40, 43, 30, 21, 20, 10, 605, 25, 48, 75, 17, 67, 278, 0, 333, 16, 0, 0, 57, 143, "lizardman_clan", 300, 0, 0, "LAST_HIT", 0, 0, 0, "fighter"),
(20015, 20015, "Marsh Zombie", 0, "", 0, "Monster.zombie", 13, 21, 13, "male", "L2Monster", 40, 339, 147, 3.95, 1.21, 40, 43, 30, 21, 20, 10, 654, 26, 33, 63, 11, 56, 278, 0, 333, 0, 0, 0, 15, 15, "NULL", 0, 1, 0, "LAST_HIT", 0, 0, 0, "fighter"),
(20016, 20016, "Stone Golem", 0, "", 0, "Monster.stone_golem", 20, 31, 13, "male", "L2Monster", 40, 339, 147, 3.95, 1.21, 40, 43, 30, 21, 20, 10, 654, 26, 30, 70, 11, 56, 278, 0, 333, 0, 0, 0, 25, 25, "NULL", 0, 0, 0, "LAST_HIT", 0, 0, 0, "fighter"),
(20017, 20017, "Vuku Orc Fighter", 0, "", 0, "Monster.orc_fighter", 12, 22, 17, "male", "L2Monster", 40, 446, 184, 3.95, 1.21, 40, 43, 30, 21, 20, 10, 618, 26, 48, 75, 17, 67, 278, 500, 333, 2, 0, 0, 45, 110, "orc_clan", 300, 0, 0, "LAST_HIT", 0, 0, 0, "fighter"),
(20018, 20018, "Carnivorous Fungus", 0, "", 0, "Monster.walking_fungus", 15, 22.5, 14, "male", "L2Monster", 40, 364, 156, 3.95, 1.21, 40, 43, 30, 21, 20, 10, 424, 16, 37, 66, 12, 59, 278, 500, 333, 0, 0, 0, 77, 121, "NULL", 0, 0, 0, "LAST_HIT", 0, 0, 0, "fighter"),
(20019, 20019, "Dryad Elder", 0, "", 0, "Monster.dryad", 9, 20, 14, "female", "L2Monster", 40, 364, 156, 3.95, 1.21, 40, 43, 30, 21, 20, 10, 498, 19, 30, 80, 12, 59, 278, 0, 333, 0, 0, 0, 44, 121, "elemental1_clan", 300, 0, 0, "LAST_HIT", 0, 0, 0, "fighter"),
(20020, 20020, "Marsh Zombie Lord", 0, "", 0, "Monster.zombie", 13, 21, 14, "male", "L2Monster", 40, 364, 156, 3.95, 1.21, 40, 43, 30, 21, 20, 10, 705, 27, 30, 80, 12, 59, 278, 0, 333, 0, 0, 0, 15, 15, "NULL", 0, 1, 0, "LAST_HIT", 0, 0, 0, "fighter"),
(20021, 20021, "Red Bear", 0, "", 0, "Monster.grizzly", 21, 40, 14, "male", "L2Monster", 40, 364, 156, 3.95, 1.21, 40, 43, 30, 21, 20, 10, 498, 19, 37, 66, 12, 59, 278, 0, 333, 0, 0, 0, 44, 121, "NULL", 0, 0, 0, "LAST_HIT", 0, 0, 0, "fighter"),
(20022, 20022, "Misery Skeleton", 0, "", 0, "Monster.skeleton", 11, 25, 14, "male", "L2Monster", 40, 364, 156, 3.95, 1.21, 40, 43, 30, 21, 20, 10, 424, 16, 32, 66, 12, 59, 317, 500, 333, 946, 945, 0, 60, 140, "skeleton_clan", 300, 1, 0, "LAST_HIT", 0, 0, 0, "fighter"),
(20023, 20023, "Shadow Beast", 0, "", 0, "Monster.onyx_beast", 14, 14.5, 15, "male", "L2Monster", 40, 390, 165, 3.95, 1.21, 40, 43, 30, 21, 20, 10, 534, 22, 40, 69, 14, 62, 278, 0, 333, 0, 0, 0, 33, 132, "NULL", 0, 0, 0, "LAST_HIT", 0, 0, 0, "fighter"),
(20024, 20024, "Langk Lizardman Warrior", 0, "", 0, "Monster.virud_lizardman_warrior", 12, 30, 17, "male", "L2Monster", 40, 446, 184, 3.95, 1.21, 40, 43, 30, 21, 20, 10, 618, 26, 48, 75, 17, 67, 278, 500, 333, 16, 0, 0, 57, 143, "NULL", 0, 0, 0, "LAST_HIT", 0, 0, 0, "fighter"),
(20025, 20025, "Lesser Dark Horror", 0, "", 0, "Monster.dark_horror", 20, 35, 15, "male", "L2Monster", 40, 390, 165, 3.95, 1.21, 40, 43, 30, 21, 20, 10, 545, 22, 36, 76, 14, 62, 278, 500, 333, 0, 0, 0, 100, 100, "NULL", 0, 1, 0, "LAST_HIT", 0, 0, 0, "fighter"),
(20026, 20026, "Ruin Zombie", 0, "", 0, "Monster.zombie", 13, 21, 15, "male", "L2Monster", 40, 390, 165, 3.95, 1.21, 40, 43, 30, 21, 20, 10, 755, 31, 40, 69, 14, 62, 278, 0, 333, 0, 0, 0, 16, 16, "NULL", 0, 1, 0, "LAST_HIT", 0, 0, 0, "fighter"),
(20027, 20027, "Langk Lizardman Scout", 0, "", 0, "Monster.virud_lizardman", 10, 23, 16, "male", "L2Monster", 40, 417, 174, 3.95, 1.21, 40, 43, 30, 21, 20, 10, 570, 23, 44, 72, 15, 64, 278, 0, 333, 16, 0, 0, 47, 143, "lizardman_clan", 300, 0, 0, "LAST_HIT", 0, 0, 0, "fighter"),
(20028, 20028, "Pincher", 0, "", 0, "Monster.giant_spider", 26, 25.5, 16, "male", "L2Monster", 40, 417, 174, 3.95, 1.21, 40, 43, 30, 21, 20, 10, 570, 23, 44, 72, 15, 64, 278, 0, 333, 0, 0, 0, 79, 143, "NULL", 0, 0, 0, "LAST_HIT", 0, 0, 0, "fighter"),
(20029, 20029, "Ruin Zombie Leader", 0, "", 0, "Monster.zombie", 13, 21, 16, "male", "L2Monster", 40, 417, 174, 3.95, 1.21, 40, 43, 30, 21, 20, 10, 807, 33, 36, 87, 15, 64, 278, 0, 333, 0, 0, 0, 15, 15, "NULL", 0, 1, 0, "LAST_HIT", 0, 0, 0, "fighter"),
(20030, 20030, "Langk Lizardman", 0, "", 0, "Monster.virud_lizardman", 10, 23, 15, "male", "L2Monster", 40, 390, 165, 3.95, 1.21, 40, 43, 30, 21, 20, 10, 534, 22, 36, 76, 14, 62, 278, 0, 333, 1, 0, 0, 43, 130, "lizardman_clan", 300, 0, 0, "LAST_HIT", 0, 0, 0, "fighter"),
(20031, 20031, "Omen Beast", 0, "", 0, "Monster.onyx_beast", 14, 14.5, 17, "male", "L2Monster", 40, 446, 184, 3.95, 1.21, 40, 43, 30, 21, 20, 10, 504, 21, 48, 75, 17, 67, 278, 0, 333, 0, 0, 0, 30, 120, "NULL", 0, 0, 0, "LAST_HIT", 0, 0, 0, "fighter"),
(20032, 20032, "Pinrul", 0, "", 0, "Monster.giant_spider", 26, 25.5, 17, "male", "L2Monster", 40, 446, 184, 3.95, 1.21, 40, 43, 30, 21, 20, 10, 605, 25, 48, 75, 17, 67, 278, 0, 333, 0, 0, 0, 79, 143, "NULL", 0, 0, 0, "LAST_HIT", 0, 0, 0, "fighter"),
(20033, 20033, "Shade Horror", 0, "", 0, "Monster.dark_horror", 20, 35, 17, "male", "L2Monster", 40, 446, 184, 3.95, 1.21, 40, 43, 30, 21, 20, 10, 504, 21, 48, 75, 17, 67, 278, 0, 333, 0, 0, 0, 110, 110, "NULL", 0, 1, 0, "LAST_HIT", 0, 0, 0, "fighter"),
(20034, 20034, "Prowler", 0, "", 0, "Monster.giant_spider", 26, 25.5, 17, "male", "L2Monster", 40, 446, 184, 3.95, 1.21, 40, 43, 30, 21, 20, 10, 618, 26, 48, 75, 17, 67, 278, 500, 333, 0, 0, 0, 79, 143, "NULL", 0, 0, 0, "LAST_HIT", 0, 0, 0, "fighter"),
(20035, 20035, "Tracker Skeleton", 0, "", 0, "Monster.skeleton", 11, 25, 17, "male", "L2Monster", 40, 446, 184, 3.95, 1.21, 40, 43, 30, 21, 20, 10, 605, 25, 42, 75, 17, 67, 317, 0, 333, 946, 945, 0, 60, 140, "skeleton_clan", 300, 1, 0, "LAST_HIT", 0, 0, 0, "fighter"),
(20036, 20036, "Lirein", 0, "", 0, "Monster.sylph", 11, 35, 18, "female", "L2Monster", 40, 476, 193, 3.95, 1.21, 40, 43, 30, 21, 20, 10, 652, 28, 53, 79, 19, 70, 278, 500, 333, 0, 0, 0, 66, 66, "elemental2_clan", 300, 0, 0, "LAST_HIT", 0, 0, 0, "fighter"),
(20037, 20037, "Mana Seeker", 0, "", 0, "Monster.mana_vampire", 11, 20, 18, "male", "L2Monster", 40, 476, 193, 7.9, 1.21, 40, 43, 30, 21, 20, 10, 496, 21, 44, 95, 19, 70, 278, 0, 333, 0, 0, 0, 99, 99, "NULL", 0, 0, 0, "LAST_HIT", 0, 0, 0, "fighter"),
(20038, 20038, "Venomous Spider", 0, "", 0, "Monster.poison_spider", 27, 25.5, 18, "male", "L2Monster", 40, 476, 193, 3.95, 1.21, 40, 43, 30, 21, 20, 10, 704, 31, 53, 79, 19, 70, 278, 0, 333, 0, 0, 0, 60, 140, "NULL", 0, 0, 0, "LAST_HIT", 0, 0, 0, "fighter"),
(20039, 20039, "Scavenger Wererat", 0, "", 0, "Monster.wererat", 14, 25, 18, "male", "L2Monster", 40, 476, 193, 3.95, 1.21, 40, 43, 30, 21, 20, 10, 640, 28, 46, 79, 19, 70, 317, 0, 333, 12, 0, 0, 88, 132, "wererat_clan", 300, 0, 0, "LAST_HIT", 0, 0, 0, "fighter"),
(20040, 20040, "Sukar Wererat", 0, "", 0, "Monster.wererat", 14, 25, 18, "male", "L2Monster", 40, 476, 193, 3.95, 1.21, 40, 43, 30, 21, 20, 10, 533, 23, 46, 79, 19, 70, 317, 0, 333, 216, 0, 0, 88, 132, "wererat_clan", 300, 0, 0, "LAST_HIT", 0, 0, 0, "fighter"),
(20041, 20041, "Tainted Zombie", 0, "", 0, "Monster.zombie", 13, 21, 18, "male", "L2Monster", 40, 476, 193, 3.95, 1.21, 40, 43, 30, 21, 20, 10, 754, 33, 44, 95, 19, 70, 278, 0, 333, 0, 0, 0, 15, 15, "NULL", 0, 1, 0, "LAST_HIT", 0, 0, 0, "fighter"),
(20042, 20042, "Tracker Skeleton Leader", 0, "", 0, "Monster.skeleton", 11, 25, 18, "male", "L2Monster", 40, 476, 193, 3.95, 1.21, 40, 43, 30, 21, 20, 10, 652, 28, 46, 79, 19, 70, 317, 500, 333, 946, 945, 0, 60, 140, "skeleton_clan", 300, 1, 0, "LAST_HIT", 0, 0, 0, "fighter"),
(20043, 20043, "Arachnid Tracker", 0, "", 0, "Monster.poison_spider", 27, 25.5, 19, "male", "L2Monster", 40, 508, 203, 3.95, 1.21, 40, 43, 30, 21, 20, 10, 760, 34, 48, 99, 21, 73, 278, 500, 333, 0, 0, 0, 60, 140, "NULL", 0, 0, 0, "LAST_HIT", 0, 0, 0, "fighter"),
(20044, 20044, "Lirein Elder", 0, "", 0, "Monster.sylph", 11, 35, 19, "female", "L2Monster", 40, 508, 203, 3.95, 1.21, 40, 43, 30, 21, 20, 10, 691, 31, 58, 82, 21, 73, 278, 500, 333, 0, 0, 0, 66, 66, "elemental1_clan", 300, 0, 0, "LAST_HIT", 0, 0, 0, "fighter"),
(20045, 20045, "Skeleton Scout", 0, "", 0, "Monster.skeleton_archer", 11, 27, 19, "male", "L2Monster", 500, 508, 203, 3.95, 1.21, 40, 43, 30, 21, 20, 10, 698, 31, 107, 99, 21, 73, 247, 0, 333, 275, 0, 0, 40, 140, "skeleton_clan", 300, 1, 0, "LAST_HIT", 0, 0, 0, "archer"),
(20046, 20046, "Stink Zombie", 0, "", 0, "Monster.zombie", 13, 21, 19, "male", "L2Monster", 40, 508, 203, 3.95, 1.21, 40, 43, 30, 21, 20, 10, 799, 36, 48, 99, 21, 73, 278, 0, 333, 0, 0, 0, 15, 15, "NULL", 0, 1, 0, "LAST_HIT", 0, 0, 0, "fighter"),
(20047, 20047, "Sukar Wererat Leader", 0, "", 0, "Monster.wererat", 14, 25, 19, "male", "L2Monster", 40, 508, 203, 3.95, 1.21, 40, 43, 30, 21, 20, 10, 576, 26, 42, 99, 21, 73, 317, 500, 333, 216, 0, 0, 88, 132, "wererat_clan", 300, 0, 0, "LAST_HIT", 0, 0, 0, "fighter"),
(20048, 20048, "Lesser Succubus", 0, "", 0, "Monster.succubus", 10, 36, 20, "female", "L2Monster", 40, 541, 213, 3.95, 1.21, 40, 43, 30, 21, 20, 10, 605, 27, 57, 94, 23, 76, 278, 500, 333, 0, 0, 0, 60, 100, "demonic_clan", 300, 0, 0, "LAST_HIT", 0, 0, 0, "fighter"),
(20049, 20049, "Lycanthrope", 0, "", 0, "Monster.werewolf", 10, 26, 20, "male", "L2Monster", 40, 541, 213, 3.95, 1.21, 40, 43, 30, 21, 20, 10, 726, 32, 63, 86, 23, 76, 278, 500, 333, 0, 0, 0, 55, 132, "werewolf_clan", 300, 0, 0, "LAST_HIT", 0, 0, 0, "fighter"),
(20050, 20050, "Arachnid Predator", 0, "", 0, "Monster.poison_spider", 27, 25.5, 20, "male", "L2Monster", 40, 541, 213, 3.95, 1.21, 40, 43, 30, 21, 20, 10, 799, 35, 63, 86, 23, 76, 278, 500, 333, 0, 0, 0, 66, 154, "NULL", 0, 0, 0, "LAST_HIT", 0, 0, 0, "fighter"),
(20051, 20051, "Skeleton Bowman", 0, "", 0, "Monster.skeleton_archer", 11, 27, 20, "male", "L2Monster", 500, 541, 213, 3.95, 1.21, 40, 43, 30, 21, 20, 10, 734, 32, 117, 104, 23, 76, 247, 0, 333, 275, 0, 0, 40, 140, "skeleton_clan", 300, 1, 0, "LAST_HIT", 0, 0, 0, "archer"),
(20052, 20052, "Lesser Succubus Turen", 0, "", 0, "Monster.succubus", 10, 36, 21, "female", "L2Monster", 40, 575, 227, 5.53, 1.53, 40, 43, 30, 21, 20, 10, 649, 30, 69, 89, 25, 80, 278, 500, 333, 0, 0, 0, 60, 100, "demonic_clan", 300, 0, 0, "LAST_HIT", 0, 0, 0, "fighter"),
(20053, 20053, "Ol Mahum Patrol", 0, "", 0, "Monster.ol_mahum_archer", 14, 25, 21, "male", "L2Monster", 500, 575, 227, 5.53, 1.53, 40, 43, 30, 21, 20, 10, 787, 36, 140, 98, 25, 80, 247, 0, 333, 14, 0, 0, 50, 110, "ol_mahum_clan", 300, 0, 0, "LAST_HIT", 0, 0, 0, "archer"),
(20054, 20054, "Ruin Spartoi", 0, "", 0, "Monster.spartoi", 11, 27, 21, "male", "L2Monster", 40, 575, 227, 5.53, 1.53, 40, 43, 30, 21, 20, 10, 764, 35, 57, 108, 25, 80, 278, 0, 333, 73, 0, 0, 60, 140, "skeleton_clan", 300, 1, 0, "LAST_HIT", 0, 0, 0, "fighter"),
(20055, 20055, "Wandering Eye", 0, "", 0, "Monster.monster_eye", 21, 43, 21, "male", "L2Monster", 40, 575, 227, 5.53, 1.53, 40, 43, 30, 21, 20, 10, 764, 35, 57, 108, 25, 80, 278, 0, 333, 0, 0, 0, 90, 159, "NULL", 0, 0, 0, "LAST_HIT", 0, 0, 0, "fighter"),
(20056, 20056, "Dre Vanul Disposer", 0, "", 0, "Monster.dre_vanul", 14, 36, 22, "male", "L2Monster", 40, 611, 242, 5.53, 1.53, 40, 43, 30, 21, 20, 10, 767, 36, 75, 93, 28, 83, 278, 500, 333, 0, 0, 0, 88, 88, "demonic_clan", 300, 0, 0, "LAST_HIT", 0, 0, 0, "fighter"),
(20057, 20057, "Lesser Succubus Tilfo", 0, "", 0, "Monster.succubus", 10, 36, 22, "female", "L2Monster", 40, 611, 242, 5.53, 1.53, 40, 43, 30, 21, 20, 10, 698, 33, 75, 93, 28, 83, 278, 500, 333, 0, 0, 0, 66, 110, "demonic_clan", 300, 0, 0, "LAST_HIT", 0, 0, 0, "fighter"),
(20058, 20058, "Ol Mahum Guard", 0, "", 0, "Monster.ol_mahum", 13.5, 25, 22, "male", "L2Monster", 40, 611, 242, 5.53, 1.53, 40, 43, 30, 21, 20, 10, 821, 39, 75, 93, 28, 83, 278, 0, 333, 2, 0, 0, 50, 110, "ol_mahum_clan", 300, 0, 0, "LAST_HIT", 0, 0, 0, "fighter"),
(20059, 20059, "Hungry Eye", 0, "", 0, "Monster.monster_eye", 21, 43, 22, "male", "L2Monster", 40, 611, 242, 5.53, 1.53, 40, 43, 30, 21, 20, 10, 821, 39, 75, 93, 28, 83, 278, 0, 333, 0, 0, 0, 90, 159, "NULL", 0, 0, 0, "LAST_HIT", 0, 0, 0, "fighter"),
(20060, 20060, "Raging Spartoi", 0, "", 0, "Monster.spartoi", 11, 27, 22, "male", "L2Monster", 40, 611, 242, 5.53, 1.53, 40, 43, 30, 21, 20, 10, 837, 40, 54, 113, 28, 83, 317, 500, 333, 946, 945, 0, 66, 154, "skeleton_clan", 300, 1, 0, "LAST_HIT", 0, 0, 0, "fighter"),
(20061, 20061, "Ol Mahum Straggler", 0, "", 0, "Monster.ol_mahum", 13.5, 25, 23, "male", "L2Monster", 40, 648, 257, 5.53, 1.53, 40, 43, 30, 21, 20, 10, 895, 43, 75, 107, 31, 87, 278, 500, 333, 2, 0, 0, 50, 110, "ol_mahum_clan", 300, 0, 0, "LAST_HIT", 0, 0, 0, "fighter"),
(20062, 20062, "Tumran Bugbear", 0, "", 0, "Monster.bugbear", 17, 35, 23, "male", "L2Monster", 40, 648, 257, 5.53, 1.53, 40, 43, 30, 21, 20, 10, 878, 42, 68, 117, 31, 87, 278, 0, 333, 156, 0, 0, 55, 130, "bugbear_clan", 300, 0, 0, "LAST_HIT", 0, 0, 0, "fighter"),
(20063, 20063, "Ol Mahum Shooter", 0, "", 0, "Monster.ol_mahum_archer", 14, 25, 24, "male", "L2Monster", 500, 687, 272, 5.53, 1.53, 40, 43, 30, 21, 20, 10, 963, 47, 181, 111, 34, 90, 247, 0, 333, 14, 0, 0, 50, 110, "ol_mahum_clan", 300, 0, 0, "LAST_HIT", 0, 0, 0, "archer"),
(20064, 20064, "Tumran Bugbear Warrior", 0, "", 0, "Monster.bugbear", 17, 35, 24, "male", "L2Monster", 40, 687, 272, 5.53, 1.53, 40, 43, 30, 21, 20, 10, 954, 47, 89, 101, 34, 90, 278, 500, 333, 88, 0, 0, 60, 143, "bugbear_clan", 300, 0, 0, "LAST_HIT", 0, 0, 0, "fighter"),
(20065, 20065, "Ol Mahum Patrolman", 0, "", 0, "Monster.ol_mahum", 13.5, 25, 25, "male", "L2Monster", 40, 728, 287, 5.53, 1.53, 40, 43, 30, 21, 20, 10, 826, 41, 80, 127, 37, 94, 278, 0, 333, 2, 0, 0, 55, 121, "ol_mahum_clan", 300, 0, 0, "LAST_HIT", 0, 0, 0, "fighter"),
(20066, 20066, "Ol Mahum Captain", 0, "", 0, "Monster.ol_mahum_champion", 14, 27, 25, "male", "L2Monster", 40, 728, 287, 5.53, 1.53, 40, 43, 30, 21, 20, 10, 1052, 53, 97, 105, 37, 94, 278, 500, 333, 69, 0, 0, 50, 110, "ol_mahum_clan", 300, 0, 0, "LAST_HIT", 0, 0, 0, "fighter"),
(20067, 20067, "Monster Eye Watcher", 0, "", 0, "Monster.monster_eye", 21, 43, 25, "male", "L2Monster", 40, 728, 287, 5.53, 1.53, 40, 43, 30, 21, 20, 10, 992, 50, 80, 127, 37, 94, 278, 0, 333, 0, 0, 0, 90, 159, "NULL", 0, 0, 0, "LAST_HIT", 0, 0, 0, "fighter"),
(20068, 20068, "Monster Eye Destroyer", 0, "", 0, "Monster.monster_eye", 21, 43, 26, "male", "L2Monster", 40, 770, 303, 5.53, 1.53, 40, 43, 30, 21, 20, 10, 1078, 54, 87, 132, 41, 98, 278, 500, 333, 0, 0, 0, 90, 159, "NULL", 0, 0, 0, "LAST_HIT", 0, 0, 0, "fighter"),
(20069, 20069, "Selu Lizardman Scout", 0, "", 0, "Monster.virud_lizardman", 10, 23, 26, "male", "L2Monster", 40, 770, 303, 5.53, 1.53, 40, 43, 30, 21, 20, 10, 880, 44, 87, 132, 41, 98, 278, 0, 333, 16, 0, 0, 47, 143, "lizardman_clan", 300, 0, 0, "LAST_HIT", 0, 0, 0, "fighter"),
(20070, 20070, "Lesser Basilisk", 0, "", 0, "Monster.lesser_basilisk", 34, 25, 27, "male", "L2Monster", 40, 813, 318, 5.53, 1.53, 40, 43, 30, 21, 20, 10, 1124, 58, 114, 114, 45, 102, 278, 500, 333, 0, 0, 0, 35, 131, "NULL", 0, 0, 0, "LAST_HIT", 0, 0, 0, "fighter"),
(20071, 20071, "Selu Lizardman Warrior", 0, "", 0, "Monster.virud_lizardman_warrior", 12, 30, 27, "male", "L2Monster", 40, 813, 318, 5.53, 1.53, 40, 43, 30, 21, 20, 10, 946, 48, 114, 114, 45, 102, 278, 500, 333, 16, 0, 0, 57, 143, "lizardman_clan", 300, 0, 0, "LAST_HIT", 0, 0, 0, "fighter"),
(20072, 20072, "Basilisk", 0, "", 0, "Monster.lesser_basilisk", 34, 25, 28, "male", "L2Monster", 40, 859, 334, 5.53, 1.53, 40, 43, 30, 21, 20, 10, 1189, 62, 102, 143, 49, 106, 278, 500, 333, 0, 0, 0, 35, 131, "NULL", 0, 0, 0, "LAST_HIT", 0, 0, 0, "fighter"),
(20073, 20073, "Ol Mahum Legionnaire", 0, "", 0, "Monster.ol_mahum", 13.5, 25, 28, "male", "L2Monster", 40, 859, 334, 5.53, 1.53, 40, 43, 30, 21, 20, 10, 981, 52, 113, 130, 49, 106, 278, 0, 333, 2, 0, 0, 55, 121, "ol_mahum_clan", 300, 0, 0, "LAST_HIT", 0, 0, 0, "fighter"),
(20074, 20074, "Androscorpio", 0, "", 0, "Monster.onyx_beast", 14, 14.5, 29, "male", "L2Monster", 40, 906, 349, 5.53, 1.53, 40, 43, 30, 21, 20, 10, 1243, 67, 122, 135, 53, 110, 278, 0, 333, 0, 0, 0, 33, 132, "scropio_clan", 300, 0, 0, "LAST_HIT", 0, 0, 0, "fighter"),
(20075, 20075, "Ant Larva", 0, "", 0, "Monster.ant_larva", 12, 8, 29, "male", "L2Monster", 40, 906, 349, 5.53, 1.53, 40, 43, 30, 21, 20, 10, 1139, 61, 111, 149, 53, 110, 278, 0, 333, 0, 0, 0, 40, 60, "ant_clan", 300, 0, 0, "LAST_HIT", 0, 0, 0, "fighter"),
(20076, 20076, "Ol Mahum Commander", 0, "", 0, "Monster.ol_mahum_champion", 14, 27, 29, "male", "L2Monster", 40, 906, 349, 5.53, 1.53, 40, 43, 30, 21, 20, 10, 1319, 71, 134, 123, 53, 110, 278, 500, 333, 69, 0, 0, 50, 110, "ol_mahum_clan", 300, 0, 0, "LAST_HIT", 0, 0, 0, "fighter"),
(20077, 20077, "Androscorpio Hunter", 0, "", 0, "Monster.onyx_beast", 14, 14.5, 30, "male", "L2Monster", 40, 954, 365, 5.53, 1.53, 40, 43, 30, 21, 20, 10, 1308, 72, 145, 128, 58, 114, 278, 0, 333, 0, 0, 0, 33, 132, "scropio_clan", 300, 0, 0, "LAST_HIT", 0, 0, 0, "fighter"),
(20078, 20078, "Whispering Wind", 0, "", 0, "Monster.sylph_100_bi", 20, 70, 30, "female", "L2Monster", 40, 954, 365, 5.53, 1.53, 40, 43, 30, 21, 20, 10, 1308, 72, 120, 155, 58, 114, 278, 0, 333, 0, 0, 0, 66, 66, "elemental2_clan", 300, 0, 0, "LAST_HIT", 0, 0, 0, "fighter"),
(20079, 20079, "Ant", 0, "", 0, "Monster.ant", 26, 15, 30, "male", "L2Monster", 40, 954, 365, 5.53, 1.53, 40, 43, 30, 21, 20, 10, 1308, 72, 145, 128, 58, 114, 278, 0, 333, 0, 0, 0, 40, 130, "ant_clan", 300, 0, 0, "LAST_HIT", 0, 0, 0, "fighter"),
(20080, 20080, "Ant Captain", 0, "", 0, "Monster.ant", 26, 15, 31, "male", "L2Monster", 40, 1004, 381, 7.11, 1.84, 40, 43, 30, 21, 20, 10, 1425, 79, 157, 133, 64, 118, 278, 500, 333, 0, 0, 0, 40, 130, "ant_clan", 300, 0, 0, "LAST_HIT", 0, 0, 0, "fighter"),
(20081, 20081, "Ant Overseer", 0, "", 0, "Monster.ant", 26, 15, 32, "male", "L2Monster", 40, 1056, 397, 14.22, 1.84, 40, 43, 30, 21, 20, 10, 1200, 67, 169, 138, 69, 123, 278, 0, 333, 0, 0, 0, 40, 130, "ant_clan", 300, 0, 0, "LAST_HIT", 0, 0, 0, "fighter"),
(20082, 20082, "Ant Recruit", 0, "", 0, "Monster.ant_soldier", 35, 17, 33, "male", "L2Monster", 40, 1109, 413, 7.11, 1.84, 40, 43, 30, 21, 20, 10, 1451, 83, 151, 173, 75, 128, 278, 0, 333, 0, 0, 0, 80, 130, "ant_clan", 300, 0, 0, "LAST_HIT", 0, 0, 0, "fighter"),
(20083, 20083, "Granite Golem", 0, "", 0, "Monster.stone_golem", 20, 31, 33, "male", "L2Monster", 40, 1109, 413, 7.11, 1.84, 40, 43, 30, 21, 20, 10, 2239, 129, 151, 173, 75, 128, 278, 0, 333, 0, 0, 0, 23, 23, "NULL", 0, 0, 0, "LAST_HIT", 0, 0, 0, "fighter"),
(20084, 20084, "Ant Patrol", 0, "", 0, "Monster.ant_soldier", 35, 17, 34, "male", "L2Monster", 40, 1164, 430, 7.11, 1.84, 40, 43, 30, 21, 20, 10, 1667, 97, 196, 148, 82, 132, 278, 0, 333, 0, 0, 0, 80, 130, "ant_clan", 300, 0, 0, "LAST_HIT", 0, 0, 0, "fighter"),
(20085, 20085, "Puncher", 0, "", 0, "Monster.stone_golem", 20, 31, 34, "male", "L2Monster", 40, 1164, 430, 7.11, 1.84, 40, 43, 30, 21, 20, 10, 2424, 142, 196, 148, 82, 132, 278, 500, 333, 0, 0, 0, 23, 23, "NULL", 0, 0, 0, "LAST_HIT", 0, 0, 0, "fighter"),
(20086, 20086, "Ant Guard", 0, "", 0, "Monster.ant_soldier", 35, 17, 35, "male", "L2Monster", 40, 1220, 446, 7.11, 1.84, 40, 43, 30, 21, 20, 10, 1484, 88, 192, 169, 89, 137, 278, 0, 333, 0, 0, 0, 80, 174, "ant_clan", 300, 0, 0, "LAST_HIT", 0, 0, 0, "fighter"),
(20087, 20087, "Ant Soldier", 0, "", 0, "Monster.ant_soldier", 35, 17, 35, "male", "L2Monster", 40, 1220, 446, 14.22, 1.84, 40, 43, 30, 21, 20, 10, 1780, 105, 192, 169, 89, 137, 278, 500, 333, 0, 0, 0, 80, 174, "ant_clan", 300, 0, 0, "LAST_HIT", 0, 0, 0, "fighter"),
(20088, 20088, "Ant Warrior Captain", 0, "", 0, "Monster.ant_soldier", 35, 17, 36, "male", "L2Monster", 40, 1279, 463, 14.22, 1.84, 40, 43, 30, 21, 20, 10, 1984, 120, 227, 159, 96, 142, 278, 500, 333, 0, 0, 0, 80, 174, "ant_clan", 300, 0, 0, "LAST_HIT", 0, 0, 0, "fighter"),
(20089, 20089, "Noble Ant", 0, "", 0, "Monster.noble_ant", 20, 48, 37, "male", "L2Monster", 40, 1338, 480, 7.11, 1.84, 40, 43, 30, 21, 20, 10, 1659, 102, 222, 182, 104, 147, 278, 0, 333, 0, 0, 0, 88, 191, "ant_clan", 300, 0, 0, "LAST_HIT", 0, 0, 0, "fighter"),
(20090, 20090, "Noble Ant Leader", 0, "", 0, "Monster.noble_ant", 20, 48, 38, "male", "L2Monster", 40, 1400, 497, 14.22, 1.84, 40, 43, 30, 21, 20, 10, 1829, 114, 261, 171, 112, 153, 278, 500, 333, 0, 0, 0, 88, 191, "ant_clan", 300, 0, 0, "LAST_HIT", 0, 0, 0, "fighter"),
(20091, 20091, "Young Fox", 0, "", 0, "Monster.fox", 9.5, 10, 1, "male", "L2Monster", 40, 62, 44, 3.16, 0.91, 40, 43, 30, 21, 20, 10, 29, 2, 9, 39, 3, 32, 278, 0, 333, 0, 0, 0, 25, 121, "NULL", 0, 0, 0, "LAST_HIT", 0, 0, 0, "fighter"),
(20092, 20092, "Monster Eye", 0, "", 0, "Monster.monster_eye", 21, 43, 10, "male", "L2Monster", 40, 257, 120, 3.16, 0.91, 40, 43, 30, 21, 20, 10, 294, 10, 22, 61, 8, 49, 278, 0, 333, 0, 0, 0, 99, 147, "NULL", 0, 0, 0, "LAST_HIT", 0, 0, 0, "fighter"),
(20093, 20093, "Orc Fighter", 0, "", 0, "Monster.orc_fighter", 12, 22, 10, "male", "L2Monster", 40, 257, 120, 3.16, 0.91, 40, 43, 30, 21, 20, 10, 363, 12, 22, 61, 8, 49, 278, 500, 333, 1, 0, 0, 49, 121, "orc_clan", 300, 0, 0, "LAST_HIT", 0, 0, 0, "fighter"),
(20094, 20094, "Orc Marksman", 0, "", 0, "Monster.orc_archer", 14, 25, 10, "male", "L2Monster", 500, 257, 120, 3.16, 0.91, 40, 43, 30, 21, 20, 10, 305, 10, 56, 55, 8, 49, 249, 0, 333, 14, 0, 0, 49, 121, "orc_clan", 300, 0, 0, "LAST_HIT", 0, 0, 0, "archer"),
(20095, 20095, "Vampire Bat", 0, "", 0, "Monster.vampire_bat", 10, 33.5, 10, "male", "L2Monster", 40, 257, 120, 3.16, 0.91, 40, 43, 30, 21, 20, 10, 296, 10, 22, 61, 8, 49, 278, 0, 333, 0, 0, 0, 66, 88, "NULL", 0, 0, 0, "LAST_HIT", 0, 0, 0, "fighter"),
(20096, 20096, "Orc Lieutenant", 0, "", 0, "Monster.orc_fighter", 12, 22, 11, "male", "L2Monster", 40, 292, 129, 3.95, 1.21, 40, 43, 30, 21, 20, 10, 391, 15, 23, 70, 9, 52, 278, 0, 333, 2, 0, 0, 49, 121, "orc_clan", 300, 0, 0, "LAST_HIT", 0, 0, 0, "fighter"),
(20097, 20097, "Drill Bat", 0, "", 0, "Monster.vampire_bat", 10, 33.5, 11, "male", "L2Monster", 40, 292, 129, 3.95, 1.21, 40, 43, 30, 21, 20, 10, 326, 12, 27, 58, 9, 52, 278, 0, 333, 0, 0, 0, 66, 88, "NULL", 0, 0, 0, "LAST_HIT", 0, 0, 0, "fighter"),
(20098, 20098, "Orc Fighter Leader", 0, "", 0, "Monster.orc_fighter", 12, 22, 12, "male", "L2Monster", 40, 315, 138, 3.95, 1.21, 40, 43, 30, 21, 20, 10, 447, 17, 30, 60, 10, 54, 278, 500, 333, 2, 0, 0, 49, 121, "orc_clan", 300, 0, 0, "LAST_HIT", 0, 0, 0, "fighter"),
(20099, 20099, "Skeleton", 0, "", 0, "Monster.skeleton", 11, 25, 12, "male", "L2Monster", 40, 315, 138, 3.95, 1.21, 40, 43, 30, 21, 20, 10, 363, 13, 26, 60, 10, 54, 317, 500, 333, 946, 945, 0, 66, 154, "skeleton_clan", 300, 1, 0, "LAST_HIT", 0, 0, 0, "fighter"),
(20100, 20100, "Skeleton Archer", 0, "", 0, "Monster.skeleton_archer", 11, 27, 13, "male", "L2Monster", 500, 339, 147, 3.95, 1.21, 40, 43, 30, 21, 20, 10, 405, 16, 74, 63, 11, 56, 249, 500, 333, 14, 0, 0, 44, 154, "skeleton_clan", 300, 1, 0, "LAST_HIT", 0, 0, 0, "archer"),
(20101, 20101, "Crasher", 0, "", 0, "Monster.stone_golem", 20, 31, 14, "male", "L2Monster", 40, 364, 156, 3.95, 1.21, 40, 43, 30, 21, 20, 10, 705, 27, 30, 80, 12, 59, 278, 0, 333, 0, 0, 0, 25, 25, "NULL", 0, 0, 0, "LAST_HIT", 0, 0, 0, "fighter"),
(20102, 20102, "Skeleton Marksman", 0, "", 0, "Monster.skeleton_archer", 11, 27, 14, "male", "L2Monster", 500, 364, 156, 3.95, 1.21, 40, 43, 30, 21, 20, 10, 428, 17, 82, 66, 12, 59, 249, 0, 333, 14, 0, 0, 44, 154, "skeleton_clan", 300, 1, 0, "LAST_HIT", 0, 0, 0, "archer"),
(20103, 20103, "Giant Spider", 0, "", 0, "Monster.giant_spider", 26, 25.5, 15, "male", "L2Monster", 40, 390, 165, 3.95, 1.21, 40, 43, 30, 21, 20, 10, 545, 22, 40, 69, 14, 62, 278, 500, 333, 0, 0, 0, 79, 143, "NULL", 0, 0, 0, "LAST_HIT", 0, 0, 0, "fighter"),
(20104, 20104, "Skeleton Lord", 0, "", 0, "Monster.skeleton", 11, 25, 15, "male", "L2Monster", 40, 390, 165, 3.95, 1.21, 40, 43, 30, 21, 20, 10, 445, 18, 29, 84, 14, 62, 317, 0, 333, 946, 945, 0, 66, 154, "skeleton_clan", 300, 1, 0, "LAST_HIT", 0, 0, 0, "fighter"),
(20105, 20105, "Dark Horror", 0, "", 0, "Monster.dark_horror", 20, 35, 16, "male", "L2Monster", 40, 417, 174, 3.95, 1.21, 40, 43, 30, 21, 20, 10, 576, 23, 44, 72, 15, 64, 278, 500, 333, 0, 0, 0, 100, 100, "NULL", 0, 1, 0, "LAST_HIT", 0, 0, 0, "fighter"),
(20106, 20106, "Talon Spider", 0, "", 0, "Monster.giant_spider", 26, 25.5, 16, "male", "L2Monster", 40, 417, 174, 3.95, 1.21, 40, 43, 30, 21, 20, 10, 570, 23, 44, 72, 15, 64, 278, 0, 333, 0, 0, 0, 79, 143, "NULL", 0, 0, 0, "LAST_HIT", 0, 0, 0, "fighter"),
(20107, 20107, "Wererat", 0, "", 0, "Monster.wererat", 14, 25, 16, "male", "L2Monster", 40, 417, 174, 3.95, 1.21, 40, 43, 30, 21, 20, 10, 475, 19, 40, 79, 15, 64, 278, 0, 333, 0, 0, 0, 88, 132, "wererat_clan", 300, 0, 0, "LAST_HIT", 0, 0, 0, "fighter"),
(20108, 20108, "Blade Spider", 0, "", 0, "Monster.giant_spider", 26, 25.5, 17, "male", "L2Monster", 40, 446, 184, 3.95, 1.21, 40, 43, 30, 21, 20, 10, 618, 26, 48, 75, 17, 67, 278, 500, 333, 0, 0, 0, 79, 143, "NULL", 0, 0, 0, "LAST_HIT", 0, 0, 0, "fighter"),
(20109, 20109, "Salamander", 0, "", 0, "Monster.salamander", 16, 6.8, 17, "male", "L2Monster", 40, 446, 184, 7.9, 1.21, 40, 43, 30, 21, 20, 10, 494, 21, 44, 83, 17, 67, 278, 0, 333, 0, 0, 0, 70, 105, "elemental3_clan", 300, 0, 0, "LAST_HIT", 0, 0, 0, "fighter"),
(20110, 20110, "Undine", 0, "", 0, "Monster.undine", 12, 27, 17, "female", "L2Monster", 40, 446, 184, 7.9, 1.21, 40, 43, 30, 21, 20, 10, 479, 20, 44, 83, 17, 67, 278, 500, 333, 0, 0, 0, 66, 66, "elemental4_clan", 300, 0, 0, "LAST_HIT", 0, 0, 0, "fighter"),
(20111, 20111, "Wererat Leader", 0, "", 0, "Monster.wererat", 14, 25, 17, "male", "L2Monster", 40, 446, 184, 7.9, 1.21, 40, 43, 30, 21, 20, 10, 479, 20, 40, 91, 17, 67, 278, 500, 333, 1, 0, 0, 88, 132, "wererat_clan", 300, 0, 0, "LAST_HIT", 0, 0, 0, "fighter"),
(20112, 20112, "Salamander Elder", 0, "", 0, "Monster.salamander", 16, 6.8, 18, "male", "L2Monster", 40, 476, 193, 7.9, 1.21, 40, 43, 30, 21, 20, 10, 496, 21, 53, 79, 19, 70, 278, 0, 333, 0, 0, 0, 70, 105, "elemental3_clan", 300, 0, 0, "LAST_HIT", 0, 0, 0, "fighter"),
(20113, 20113, "Undine Elder", 0, "", 0, "Monster.undine", 12, 27, 18, "female", "L2Monster", 40, 476, 193, 7.9, 1.21, 40, 43, 30, 21, 20, 10, 505, 22, 44, 95, 19, 70, 278, 500, 333, 0, 0, 0, 66, 66, "elemental4_clan", 300, 0, 0, "LAST_HIT", 0, 0, 0, "fighter"),
(20114, 20114, "Salamander Noble", 0, "", 0, "Monster.salamander", 16, 6.8, 19, "male", "L2Monster", 40, 508, 203, 7.9, 1.21, 40, 43, 30, 21, 20, 10, 525, 23, 58, 82, 21, 73, 278, 0, 333, 0, 0, 0, 70, 105, "elemental3_clan", 300, 0, 0, "LAST_HIT", 0, 0, 0, "fighter"),
(20115, 20115, "Undine Noble", 0, "", 0, "Monster.undine", 12, 27, 19, "female", "L2Monster", 40, 508, 203, 7.9, 1.21, 40, 43, 30, 21, 20, 10, 536, 24, 58, 82, 21, 73, 278, 500, 333, 0, 0, 0, 66, 66, "elemental4_clan", 300, 0, 0, "LAST_HIT", 0, 0, 0, "fighter"),
(20116, 20116, "Fox", 0, "", 0, "Monster.fox", 9.5, 10, 2, "male", "L2Monster", 40, 75, 52, 3.16, 0.91, 40, 43, 30, 21, 20, 10, 58, 2, 10, 42, 3, 34, 278, 0, 333, 0, 0, 0, 25, 121, "NULL", 0, 0, 0, "LAST_HIT", 0, 0, 0, "fighter"),
(20117, 20117, "Dre Vanul", 0, "", 0, "Monster.dre_vanul", 14, 36, 20, "male", "L2Monster", 40, 541, 213, 3.95, 1.21, 40, 43, 30, 21, 20, 10, 666, 29, 63, 86, 23, 76, 278, 500, 333, 0, 0, 0, 88, 88, "demonic_clan", 300, 0, 0, "LAST_HIT", 0, 0, 0, "fighter"),
(20118, 20118, "Dre Vanul Scout", 0, "", 0, "Monster.dre_vanul", 14, 36, 21, "male", "L2Minion", 40, 575, 227, 5.53, 1.53, 40, 43, 30, 21, 20, 10, 649, 30, 69, 89, 25, 80, 278, 500, 333, 0, 0, 0, 88, 88, "demonic_clan", 300, 0, 0, "LAST_HIT", 0, 0, 0, "fighter"),
(20119, 20119, "Elder Fox", 0, "", 0, "Monster.fox", 9.5, 10, 3, "male", "L2Monster", 40, 90, 60, 3.16, 0.91, 40, 43, 30, 21, 20, 10, 88, 2, 12, 40, 3, 35, 278, 0, 333, 0, 0, 0, 25, 121, "NULL", 0, 0, 0, "LAST_HIT", 0, 0, 0, "fighter"),
(20120, 20120, "Wolf", 0, "", 0, "Monster.wolf", 13, 9, 4, "male", "L2Monster", 40, 107, 68, 3.16, 0.91, 40, 43, 30, 21, 20, 10, 141, 4, 12, 46, 4, 37, 278, 0, 333, 0, 0, 0, 24, 110, "NULL", 0, 0, 0, "LAST_HIT", 0, 0, 0, "fighter"),
(20121, 20121, "Giant Toad", 0, "", 0, "Monster.poison_toad", 20, 10, 5, "male", "L2Monster", 40, 126, 77, 3.16, 0.91, 40, 43, 30, 21, 20, 10, 178, 5, 13, 48, 4, 39, 278, 0, 333, 0, 0, 0, 50, 100, "NULL", 0, 0, 0, "LAST_HIT", 0, 0, 0, "fighter"),
(20130, 20130, "Orc", 0, "", 0, "Monster.orc", 10, 21, 6, "male", "L2Monster", 40, 147, 85, 3.16, 0.91, 40, 43, 30, 21, 20, 10, 213, 6, 15, 50, 5, 41, 278, 0, 333, 156, 0, 0, 49, 121, "orc_clan", 300, 0, 0, "LAST_HIT", 0, 0, 0, "fighter"),
(20131, 20131, "Orc Grunt", 0, "", 0, "Monster.orc", 10, 21, 7, "male", "L2Monster", 40, 171, 94, 3.16, 0.91, 40, 43, 30, 21, 20, 10, 249, 8, 17, 53, 6, 43, 278, 0, 333, 4, 0, 0, 49, 121, "orc_clan", 300, 0, 0, "LAST_HIT", 0, 0, 0, "fighter"),
(20132, 20132, "Werewolf", 0, "", 0, "Monster.werewolf", 10, 26, 9, "male", "L2Monster", 40, 226, 111, 3.16, 0.91, 40, 43, 30, 21, 20, 10, 321, 11, 20, 58, 7, 47, 278, 0, 333, 0, 0, 0, 55, 132, "werewolf_clan", 300, 0, 0, "LAST_HIT", 0, 0, 0, "fighter"),
(20133, 20133, "Bugbear", 0, "", 0, "Monster.bugbear", 17, 35, 21, "male", "L2Monster", 40, 575, 227, 5.53, 1.53, 40, 43, 30, 21, 20, 10, 649, 30, 63, 98, 25, 80, 278, 500, 333, 4, 0, 0, 60, 143, "bugbear_clan", 300, 0, 0, "LAST_HIT", 0, 0, 0, "fighter"),
(20134, 20134, "Cave Maiden", 0, "", 0, "Monster.cave_maiden", 25, 65, 59, "female", "L2Monster", 40, 2971, 1117, 10.27, 2.45, 40, 43, 30, 21, 20, 10, 5112, 437, 902, 326, 453, 291, 278, 500, 333, 68, 0, 0, 70, 174, "NULL", 0, 0, 0, "LAST_HIT", 0, 0, 0, "fighter"),
(20135, 20135, "Alligator", 0, "", 0, "Monster.crocodile", 28, 11.5, 40, "male", "L2Monster", 40, 1527, 531, 7.11, 1.84, 40, 43, 30, 21, 20, 10, 2373, 153, 300, 183, 131, 164, 278, 500, 333, 0, 0, 0, 70, 174, "croc_clan2", 300, 0, 0, "LAST_HIT", 0, 0, 0, "fighter"),
(20136, 20136, "Death Knight", 0, "", 0, "Monster.death_knight", 14.5, 36, 50, "male", "L2Monster", 40, 2245, 830, 17.38, 2.14, 40, 43, 30, 21, 20, 10, 4651, 350, 616, 230, 264, 226, 278, 500, 333, 75, 0, 0, 27, 174, "undead_clan", 300, 1, 0, "LAST_HIT", 0, 0, 0, "fighter"),
(20137, 20137, "Drake", 0, "", 0, "Monster.drake", 30, 100, 57, "male", "L2Monster", 40, 2806, 1052, 10.27, 2.45, 40, 43, 30, 21, 20, 10, 4819, 401, 817, 309, 405, 276, 278, 500, 333, 0, 0, 0, 77, 191, "dragon_clan", 300, 0, 0, "LAST_HIT", 0, 0, 0, "fighter"),
(20138, 20138, "Gargoyle", 0, "", 0, "Monster.gargoyle", 16, 50, 27, "male", "L2Monster", 40, 813, 318, 5.53, 1.53, 40, 43, 30, 21, 20, 10, 946, 48, 104, 125, 45, 102, 278, 500, 333, 0, 0, 0, 154, 154, "NULL", 0, 0, 0, "LAST_HIT", 0, 0, 0, "fighter"),
(20139, 20139, "Giant Bee", 0, "", 0, "Monster.giant_bee", 8, 24.5, 16, "male", "L2Monster", 40, 417, 174, 3.95, 1.21, 40, 43, 30, 21, 20, 10, 471, 19, 40, 79, 15, 64, 278, 0, 333, 0, 0, 0, 99, 99, "NULL", 0, 0, 0, "LAST_HIT", 0, 0, 0, "fighter"),
(20140, 20140, "Giant Leech", 0, "", 0, "Monster.giant_leech", 70, 29, 24, "male", "L2Monster", 40, 687, 272, 5.53, 1.53, 40, 43, 30, 21, 20, 10, 795, 39, 81, 111, 34, 90, 278, 500, 333, 0, 0, 0, 55, 121, "NULL", 0, 0, 0, "LAST_HIT", 0, 0, 0, "fighter"),
(20141, 20141, "Giant Wild Hog", 0, "", 0, "Monster.giant_wild_hog", 35, 27, 47, "male", "L2Monster", 40, 2016, 738, 8.69, 2.14, 40, 43, 30, 21, 20, 10, 2730, 196, 427, 253, 216, 206, 278, 500, 333, 0, 0, 0, 38, 132, "NULL", 0, 0, 0, "LAST_HIT", 0, 0, 0, "fighter"),
(20142, 20142, "Griffon", 0, "", 0, "Monster.griffin", 20, 44, 20, "male", "L2Monster", 40, 541, 213, 3.95, 1.21, 40, 43, 30, 21, 20, 10, 593, 26, 57, 94, 23, 76, 278, 0, 333, 0, 0, 0, 99, 99, "NULL", 0, 0, 0, "LAST_HIT", 0, 0, 0, "fighter"),
(20143, 20143, "Grizzly", 0, "", 0, "Monster.grizzly", 21, 40, 12, "male", "L2Monster", 40, 315, 138, 3.95, 1.21, 40, 43, 30, 21, 20, 10, 436, 16, 27, 66, 10, 54, 278, 500, 333, 0, 0, 0, 40, 110, "NULL", 0, 0, 0, "LAST_HIT", 0, 0, 0, "fighter"),
(20144, 20144, "Hangman Tree", 0, "", 0, "Monster.hanged_man_ripper", 35, 80, 35, "male", "L2Monster", 40, 1220, 446, 7.11, 1.84, 40, 43, 30, 21, 20, 10, 1817, 108, 192, 169, 89, 137, 278, 500, 333, 0, 0, 0, 55, 174, "NULL", 0, 0, 0, "LAST_HIT", 0, 0, 0, "fighter"),
(20145, 20145, "Harpy", 0, "", 0, "Monster.harpy", 10, 42, 32, "female", "L2Monster", 40, 1056, 397, 7.11, 1.84, 40, 43, 30, 21, 20, 10, 1504, 84, 154, 151, 69, 123, 278, 500, 333, 0, 0, 0, 60, 100, "NULL", 0, 0, 0, "LAST_HIT", 0, 0, 0, "fighter"),
(20146, 20146, "Headless Knight", 0, "", 0, "Monster.headless_knight", 21, 31, 50, "male", "L2Monster", 40, 2245, 830, 8.69, 2.14, 40, 43, 30, 21, 20, 10, 3708, 279, 463, 306, 264, 226, 278, 500, 333, 124, 0, 0, 77, 191, "NULL", 0, 1, 0, "LAST_HIT", 0, 0, 0, "fighter"),
(20147, 20147, "Hobgoblin", 0, "", 0, "Monster.hobgoblin", 12, 24, 21, "male", "L2Monster", 40, 575, 227, 5.53, 1.53, 40, 43, 30, 21, 20, 10, 764, 35, 63, 98, 25, 80, 278, 0, 333, 4, 0, 0, 45, 110, "goblin_clan", 300, 0, 0, "LAST_HIT", 0, 0, 0, "fighter"),
(20148, 20148, "Hungry Spirit", 0, "", 0, "Monster.hungry_spirit", 30, 40, 40, "male", "L2Monster", 40, 1527, 531, 7.11, 1.84, 40, 43, 30, 21, 20, 10, 1958, 126, 300, 183, 131, 164, 278, 500, 333, 0, 0, 0, 16, 132, "NULL", 0, 1, 0, "LAST_HIT", 0, 0, 0, "fighter"),
(20149, 20149, "Iron Golem", 0, "", 0, "Monster.iron_golem", 18, 34, 38, "male", "L2Monster", 40, 1400, 497, 7.11, 1.84, 40, 43, 30, 21, 20, 10, 2524, 157, 216, 207, 112, 153, 278, 500, 333, 0, 0, 0, 22, 22, "NULL", 0, 0, 0, "LAST_HIT", 0, 0, 0, "fighter"),
(20150, 20150, "King Bugbear", 0, "", 0, "Monster.king_bugbear", 15, 40, 32, "male", "L2Monster", 40, 1056, 397, 7.11, 1.84, 40, 43, 30, 21, 20, 10, 1265, 71, 169, 138, 69, 123, 278, 500, 333, 88, 0, 0, 60, 143, "bugbear_clan", 300, 0, 0, "LAST_HIT", 0, 0, 0, "fighter"),
(20151, 20151, "Kobold", 0, "", 0, "Monster.kobold", 10, 15, 4, "male", "L2Monster", 40, 107, 68, 3.16, 0.91, 40, 43, 30, 21, 20, 10, 118, 3, 12, 46, 4, 37, 278, 0, 333, 4, 0, 0, 51, 121, "goblin_clan", 300, 0, 0, "LAST_HIT", 0, 0, 0, "fighter"),
(20152, 20152, "Lizardman", 0, "", 0, "Monster.virud_lizardman", 10, 23, 19, "male", "L2Monster", 40, 508, 203, 3.95, 1.21, 40, 43, 30, 21, 20, 10, 565, 25, 53, 90, 21, 73, 278, 0, 333, 291, 0, 0, 47, 143, "lizardman_clan", 300, 0, 0, "LAST_HIT", 0, 0, 0, "fighter"),
(20153, 20153, "Magical Weaver", 0, "", 0, "Monster.magical_weaver", 11, 20, 11, "male", "L2Monster", 40, 292, 129, 3.95, 1.21, 40, 43, 30, 21, 20, 10, 391, 15, 27, 58, 9, 52, 278, 0, 333, 0, 0, 0, 99, 99, "NULL", 0, 0, 0, "LAST_HIT", 0, 0, 0, "fighter"),
(20154, 20154, "Mandragora Sprout", 0, "", 0, "Monster.manadragora", 14, 17.8, 21, "female", "L2Monster", 40, 575, 227, 5.53, 1.53, 40, 43, 30, 21, 20, 10, 764, 35, 63, 98, 25, 80, 278, 0, 333, 0, 0, 0, 80, 80, "mandragora_clan", 300, 0, 0, "LAST_HIT", 0, 0, 0, "fighter"),
(20155, 20155, "Mandragora Sapling", 0, "", 0, "Monster.mandragora_a", 15, 26, 23, "female", "L2Monster", 40, 648, 257, 5.53, 1.53, 40, 43, 30, 21, 20, 10, 895, 43, 82, 97, 31, 87, 278, 500, 333, 0, 0, 0, 80, 120, "mandragora_clan", 300, 0, 0, "LAST_HIT", 0, 0, 0, "fighter"),
(20156, 20156, "Mandragora Blossom", 0, "", 0, "Monster.mandragora_b", 12, 25.5, 25, "female", "L2Monster", 40, 728, 287, 5.53, 1.53, 40, 43, 30, 21, 20, 10, 1012, 51, 97, 105, 37, 94, 278, 500, 333, 0, 0, 0, 80, 120, "mandragora_clan", 300, 0, 0, "LAST_HIT", 0, 0, 0, "fighter"),
(20157, 20157, "Marsh Stakato", 0, "", 0, "Monster.marsh_stakato", 10, 20, 29, "male", "L2Monster", 40, 906, 349, 5.53, 1.53, 40, 43, 30, 21, 20, 10, 1509, 81, 117, 123, 53, 110, 317, 500, 333, 223, 0, 0, 21, 120, "stakato_clan", 300, 0, 0, "LAST_HIT", 0, 0, 0, "fighter"),
(20158, 20158, "Medusa", 0, "", 0, "Monster.medusa", 10, 25, 34, "female", "L2Monster", 40, 1164, 430, 7.11, 1.84, 40, 43, 30, 21, 20, 10, 1714, 100, 178, 163, 82, 132, 278, 500, 333, 0, 0, 0, 50, 110, "NULL", 0, 0, 0, "LAST_HIT", 0, 0, 0, "fighter"),
(20159, 20159, "Minotaur", 0, "", 0, "Monster.minotaur", 21, 45.5, 43, "male", "L2Monster", 40, 1728, 618, 8.69, 2.14, 40, 43, 30, 21, 20, 10, 2263, 153, 365, 202, 163, 181, 278, 500, 333, 300, 0, 0, 44, 132, "NULL", 0, 0, 0, "LAST_HIT", 0, 0, 0, "fighter"),
(20160, 20160, "Neer Crawler", 0, "", 0, "Monster.neer_crawler", 14, 22, 28, "male", "L2Monster", 40, 859, 334, 5.53, 1.53, 40, 43, 30, 21, 20, 10, 1201, 63, 124, 118, 49, 106, 278, 500, 333, 0, 0, 0, 50, 90, "neer_crawler_clan", 300, 1, 0, "LAST_HIT", 0, 0, 0, "fighter"),
(20161, 20161, "Oel Mahum", 0, "", 0, "Monster.oel_mahum", 20, 37, 53, "male", "L2Monster", 40, 2481, 923, 10.27, 2.45, 40, 43, 30, 21, 20, 10, 4167, 328, 602, 304, 319, 247, 278, 500, 333, 0, 0, 0, 70, 174, "oel_mahum_clan", 300, 0, 0, "LAST_HIT", 0, 0, 0, "fighter"),
(20162, 20162, "Ogre", 0, "", 0, "Monster.ogre", 21, 44, 41, "male", "L2Monster", 40, 1593, 560, 8.69, 2.14, 40, 43, 30, 21, 20, 10, 2057, 135, 446, 189, 141, 169, 200, 500, 333, 98, 0, 0, 24, 88, "NULL", 0, 0, 0, "LAST_HIT", 0, 0, 0, "fighter"),
(20163, 20163, "Ol Mahum", 0, "", 0, "Monster.ol_mahum", 13.5, 25, 23, "male", "L2Monster", 40, 648, 257, 5.53, 1.53, 40, 43, 30, 21, 20, 10, 731, 35, 82, 97, 31, 87, 278, 0, 333, 2, 0, 0, 55, 121, "ol_mahum_clan", 300, 0, 0, "LAST_HIT", 0, 0, 0, "fighter"),
(20164, 20164, "Ol Mahum Archer", 0, "", 0, "Monster.ol_mahum_archer", 14, 25, 25, "male", "L2Monster", 500, 728, 287, 5.53, 1.53, 40, 43, 30, 21, 20, 10, 868, 44, 216, 105, 37, 94, 249, 500, 333, 14, 0, 0, 55, 121, "ol_mahum_clan", 300, 0, 0, "LAST_HIT", 0, 0, 0, "archer"),
(20165, 20165, "Ol Mahum Champion", 0, "", 0, "Monster.ol_mahum_champion", 14, 27, 29, "male", "L2Monster", 40, 906, 349, 5.53, 1.53, 40, 43, 30, 21, 20, 10, 1257, 67, 134, 123, 53, 110, 278, 500, 333, 69, 0, 0, 55, 121, "ol_mahum_clan", 300, 0, 0, "LAST_HIT", 0, 0, 0, "fighter"),
(20166, 20166, "Succubus", 0, "", 0, "Monster.succubus", 10, 36, 32, "female", "L2Monster", 40, 1056, 397, 7.11, 1.84, 40, 43, 30, 21, 20, 10, 1265, 71, 154, 151, 69, 123, 278, 500, 333, 0, 0, 0, 66, 110, "demonic_clan", 300, 0, 0, "LAST_HIT", 0, 0, 0, "fighter"),
(20167, 20167, "Serpent Slave", 0, "", 0, "Monster.serpent_slave", 17, 46, 40, "male", "L2Monster", 40, 1527, 531, 7.11, 1.84, 40, 43, 30, 21, 20, 10, 1977, 128, 273, 201, 131, 164, 278, 500, 333, 73, 0, 0, 77, 121, "serpent_clan", 300, 0, 0, "LAST_HIT", 0, 0, 0, "fighter"),
(20168, 20168, "Silenos", 0, "", 0, "Monster.silenos", 14, 32.5, 30, "male", "L2Monster", 40, 954, 365, 5.53, 1.53, 40, 43, 30, 21, 20, 10, 1308, 72, 132, 140, 58, 114, 278, 0, 333, 88, 0, 0, 70, 110, "silenos_clan", 300, 0, 0, "LAST_HIT", 0, 0, 0, "fighter"),
(20169, 20169, "Skeleton Royal Guard", 0, "", 0, "Monster.skeleton_royal_guard", 11, 28.5, 26, "male", "L2Monster", 40, 770, 303, 5.53, 1.53, 40, 43, 30, 21, 20, 10, 898, 45, 92, 109, 41, 98, 317, 500, 333, 946, 945, 0, 88, 132, "skeleton_clan", 300, 1, 0, "LAST_HIT", 0, 0, 0, "fighter"),
(20170, 20170, "Spartoi", 0, "", 0, "Monster.spartoi", 11, 27, 15, "male", "L2Monster", 40, 390, 165, 3.95, 1.21, 40, 43, 30, 21, 20, 10, 454, 19, 35, 69, 14, 62, 317, 500, 333, 946, 945, 0, 66, 154, "skeleton_clan", 300, 1, 0, "LAST_HIT", 0, 0, 0, "fighter"),
(20171, 20171, "Specter", 0, "", 0, "Monster.dark_horror", 20, 35, 26, "male", "L2Monster", 40, 770, 303, 5.53, 1.53, 40, 43, 30, 21, 20, 10, 1078, 54, 96, 120, 41, 98, 278, 500, 333, 0, 0, 0, 110, 110, "NULL", 0, 1, 0, "LAST_HIT", 0, 0, 0, "fighter"),
(20172, 20172, "Sylph", 0, "", 0, "Monster.sylph", 11, 35, 10, "female", "L2Monster", 40, 257, 120, 3.16, 0.91, 40, 43, 30, 21, 20, 10, 296, 10, 25, 55, 8, 49, 278, 0, 333, 0, 0, 0, 66, 66, "elemental2_clan", 300, 0, 0, "LAST_HIT", 0, 0, 0, "fighter"),
(20173, 20173, "Troll", 0, "", 0, "Monster.troll", 21, 35, 33, "male", "L2Monster", 40, 1109, 413, 7.11, 1.84, 40, 43, 30, 21, 20, 10, 1332, 76, 182, 143, 75, 128, 278, 500, 333, 0, 0, 0, 60, 121, "NULL", 0, 0, 0, "LAST_HIT", 0, 0, 0, "fighter"),
(20174, 20174, "Two-Headed Giant", 0, "", 0, "Monster.twin_headed_giant", 17, 39, 35, "male", "L2Monster", 40, 1220, 446, 7.11, 1.84, 40, 43, 30, 21, 20, 10, 1499, 89, 174, 186, 89, 137, 278, 500, 333, 4, 0, 0, 49, 110, "NULL", 0, 0, 0, "LAST_HIT", 0, 0, 0, "fighter"),
(20175, 20175, "Walking Fungus", 0, "", 0, "Monster.walking_fungus", 15, 22.5, 8, "male", "L2Monster", 40, 197, 102, 3.16, 0.91, 40, 43, 30, 21, 20, 10, 237, 8, 18, 55, 6, 45, 278, 0, 333, 0, 0, 0, 77, 121, "NULL", 0, 0, 0, "LAST_HIT", 0, 0, 0, "fighter"),
(20176, 20176, "Wyrm", 0, "", 0, "Monster.wyrm", 29, 72, 35, "male", "L2Monster", 40, 1220, 446, 7.11, 1.84, 40, 43, 30, 21, 20, 10, 1817, 108, 211, 154, 89, 137, 278, 500, 333, 0, 0, 0, 70, 174, "NULL", 0, 0, 0, "LAST_HIT", 0, 0, 0, "fighter"),
(20177, 20177, "Zombie", 0, "", 0, "Monster.zombie", 13, 21, 6, "male", "L2Monster", 40, 147, 85, 3.16, 0.91, 40, 43, 30, 21, 20, 10, 178, 5, 15, 50, 5, 41, 278, 0, 333, 0, 0, 0, 16, 16, "NULL", 0, 1, 0, "LAST_HIT", 0, 0, 0, "fighter"),
(20189, 20189, "Puma", 0, "", 0, "Monster.onyx_beast", 14, 14.5, 15, "male", "L2Monster", 40, 390, 165, 3.95, 1.21, 40, 43, 30, 21, 20, 10, 441, 18, 40, 69, 14, 62, 278, 0, 333, 0, 0, 0, 33, 132, "NULL", 0, 0, 0, "LAST_HIT", 0, 0, 0, "fighter"),
(20190, 20190, "Skeleton Marauder", 0, "", 0, "Monster.skeleton_archer", 11, 27, 29, "male", "L2Monster", 500, 906, 349, 5.53, 1.53, 40, 43, 30, 21, 20, 10, 1306, 70, 299, 123, 53, 110, 247, 500, 333, 14, 0, 0, 40, 140, "skeleton_clan", 300, 1, 0, "LAST_HIT", 0, 0, 0, "archer"),
(20191, 20191, "Skeleton Raider", 0, "", 0, "Monster.skeleton", 11, 25, 30, "male", "L2Monster", 40, 954, 365, 5.53, 1.53, 40, 43, 30, 21, 20, 10, 1335, 73, 127, 128, 58, 114, 317, 500, 333, 946, 945, 0, 60, 140, "skeleton_clan", 300, 1, 0, "LAST_HIT", 0, 0, 0, "fighter"),
(20192, 20192, "Tyrant", 0, "", 0, "Monster.grave", 15, 29, 35, "male", "L2Monster", 40, 1220, 446, 7.11, 1.84, 40, 43, 30, 21, 20, 10, 1781, 105, 211, 154, 89, 137, 278, 0, 333, 0, 0, 0, 70, 174, "tyrant_clan", 300, 0, 0, "LAST_HIT", 0, 0, 0, "fighter"),
(20193, 20193, "Tyrant Kingpin", 0, "", 0, "Monster.grave", 15, 29, 36, "male", "L2Monster", 40, 1279, 463, 7.11, 1.84, 40, 43, 30, 21, 20, 10, 1922, 116, 227, 159, 96, 142, 278, 500, 333, 0, 0, 0, 77, 191, "tyrant_clan", 300, 0, 0, "LAST_HIT", 0, 0, 0, "fighter"),
(20194, 20194, "Queen Undine", 0, "", 0, "Monster.undine", 12, 27, 50, "female", "L2Monster", 40, 2245, 830, 8.69, 2.14, 40, 43, 30, 21, 20, 10, 3090, 233, 560, 253, 264, 226, 278, 500, 333, 0, 0, 0, 66, 66, "NULL", 0, 0, 0, "LAST_HIT", 0, 0, 0, "fighter"),
(20197, 20197, "Sorrow Maiden", 0, "", 0, "Monster.sylph", 11, 35, 27, "female", "L2Monster", 40, 813, 318, 5.53, 1.53, 40, 43, 30, 21, 20, 10, 1102, 56, 104, 125, 45, 102, 278, 0, 333, 0, 0, 0, 66, 66, "NULL", 0, 0, 0, "LAST_HIT", 0, 0, 0, "fighter"),
(20198, 20198, "Neer Ghoul Berserker", 0, "", 0, "Monster.neer_crawler", 14, 22, 29, "male", "L2Monster", 40, 906, 349, 5.53, 1.53, 40, 43, 30, 21, 20, 10, 1268, 68, 134, 123, 53, 110, 278, 500, 333, 0, 0, 0, 50, 90, "neer_crawler_clan", 300, 1, 0, "LAST_HIT", 0, 0, 0, "fighter"),
(20199, 20199, "Amber Basilisk", 0, "", 0, "Monster.lesser_basilisk", 34, 25, 30, "male", "L2Monster", 40, 954, 365, 5.53, 1.53, 40, 43, 30, 21, 20, 10, 1557, 85, 120, 155, 58, 114, 278, 0, 333, 0, 0, 0, 35, 131, "NULL", 0, 0, 0, "LAST_HIT", 0, 0, 0, "fighter"),
(20200, 20200, "Strain", 0, "", 0, "Monster.hungry_spirit", 30, 40, 31, "male", "L2Monster", 40, 1004, 381, 7.11, 1.84, 40, 43, 30, 21, 20, 10, 1383, 77, 157, 133, 64, 118, 278, 0, 333, 0, 0, 0, 15, 120, "NULL", 0, 1, 0, "LAST_HIT", 0, 0, 0, "fighter"),
(20201, 20201, "Ghoul", 0, "", 0, "Monster.zombie", 13, 21, 32, "male", "L2Monster", 40, 1056, 397, 7.11, 1.84, 40, 43, 30, 21, 20, 10, 2085, 117, 169, 138, 69, 123, 278, 0, 333, 0, 0, 0, 15, 15, "NULL", 0, 1, 0, "LAST_HIT", 0, 0, 0, "fighter"),
(20202, 20202, "Dead Seeker", 0, "", 0, "Monster.vampire_bat", 10, 33.5, 34, "male", "L2Monster", 40, 1164, 430, 7.11, 1.84, 40, 43, 30, 21, 20, 10, 1664, 97, 178, 163, 82, 132, 278, 0, 333, 0, 0, 0, 60, 80, "NULL", 0, 0, 0, "LAST_HIT", 0, 0, 0, "fighter"),
(20203, 20203, "Dion Grizzly", 0, "", 0, "Monster.grizzly", 21, 40, 20, "male", "L2Monster", 40, 541, 213, 3.95, 1.21, 40, 43, 30, 21, 20, 10, 705, 31, 52, 104, 23, 76, 278, 0, 333, 0, 0, 0, 40, 110, "NULL", 0, 0, 0, "LAST_HIT", 0, 0, 0, "fighter"),
(20204, 20204, "Bloody Bee", 0, "", 0, "Monster.giant_bee", 8, 24.5, 23, "male", "L2Monster", 40, 648, 257, 5.53, 1.53, 40, 43, 30, 21, 20, 10, 956, 46, 82, 97, 31, 87, 278, 0, 333, 0, 0, 0, 90, 90, "NULL", 0, 0, 0, "LAST_HIT", 0, 0, 0, "fighter"),
(20205, 20205, "Dire Wolf", 0, "", 0, "Monster.dire_wolf", 13, 11, 24, "male", "L2Monster", 40, 687, 272, 5.53, 1.53, 40, 43, 30, 21, 20, 10, 954, 47, 89, 101, 34, 90, 278, 500, 333, 0, 0, 0, 24, 110, "wolf_clan", 300, 0, 0, "LAST_HIT", 0, 0, 0, "fighter"),
(20206, 20206, "Kadif Werewolf", 0, "", 0, "Monster.werewolf", 10, 26, 25, "male", "L2Monster", 40, 728, 287, 5.53, 1.53, 40, 43, 30, 21, 20, 10, 982, 49, 97, 105, 37, 94, 278, 0, 333, 0, 0, 0, 50, 120, "NULL", 0, 0, 0, "LAST_HIT", 0, 0, 0, "fighter"),
(20207, 20207, "Ol Mahum Guerilla", 0, "", 0, "Monster.ol_mahum", 13.5, 25, 26, "male", "L2Monster", 40, 770, 303, 11.06, 1.53, 40, 43, 30, 21, 20, 10, 982, 49, 87, 132, 41, 98, 278, 0, 333, 2, 19, 0, 50, 110, "ol_mahum_clan", 300, 0, 0, "LAST_HIT", 0, 0, 0, "fighter"),
(20208, 20208, "Ol Mahum Raider", 0, "", 0, "Monster.ol_mahum", 13.5, 25, 27, "male", "L2Monster", 40, 813, 318, 11.06, 1.53, 40, 43, 30, 21, 20, 10, 1035, 53, 83, 138, 45, 102, 317, 0, 333, 10, 0, 0, 50, 110, "ol_mahum_clan", 300, 0, 0, "LAST_HIT", 0, 0, 0, "fighter"),
(20209, 20209, "Ol Mahum Marksman", 0, "", 0, "Monster.ol_mahum_archer", 14, 25, 28, "male", "L2Monster", 500, 859, 334, 11.06, 1.53, 40, 43, 30, 21, 20, 10, 1128, 59, 276, 118, 49, 106, 247, 0, 333, 275, 0, 0, 50, 110, "ol_mahum_clan", 300, 0, 0, "LAST_HIT", 0, 0, 0, "archer"),
(20210, 20210, "Ol Mahum Sergeant", 0, "", 0, "Monster.ol_mahum", 13.5, 25, 29, "male", "L2Monster", 40, 906, 349, 11.06, 1.53, 40, 43, 30, 21, 20, 10, 1156, 62, 111, 149, 53, 110, 278, 0, 333, 68, 19, 0, 50, 110, "ol_mahum_clan", 300, 0, 0, "LAST_HIT", 0, 0, 0, "fighter"),
(20211, 20211, "Ol Mahum Captain", 0, "", 0, "Monster.ol_mahum_champion", 14, 27, 30, "male", "L2Monster", 40, 954, 365, 11.06, 1.53, 40, 43, 30, 21, 20, 10, 1241, 68, 145, 128, 58, 114, 278, 500, 333, 123, 19, 0, 50, 110, "ol_mahum_clan", 300, 0, 0, "LAST_HIT", 0, 0, 0, "fighter"),
(20212, 20212, "Bloody Axe Turmak", 0, "Ol Mahum Lord", 0, "Monster.ol_mahum_champion", 14, 27, 34, "male", "L2Monster", 40, 1164, 430, 14.22, 1.84, 40, 43, 30, 21, 20, 10, 1469, 86, 196, 148, 82, 132, 278, 500, 333, 69, 19, 0, 55, 121, "ol_mahum_clan", 300, 0, 0, "LAST_HIT", 0, 0, 0, "fighter"),
(20213, 20213, "Porta", 0, "", 0, "Monster.stone_golem", 20, 31, 40, "male", "L2Monster", 40, 1527, 531, 14.22, 1.84, 40, 43, 30, 21, 20, 10, 2364, 152, 248, 222, 131, 164, 278, 0, 333, 0, 0, 0, 23, 23, "porta_clan", 400, 0, 0, "LAST_HIT", 0, 0, 0, "fighter"),
(20214, 20214, "Excuro", 0, "", 0, "Monster.mana_vampire", 11, 20, 41, "male", "L2Monster", 40, 1593, 560, 17.38, 2.14, 40, 43, 30, 21, 20, 10, 2028, 132, 265, 229, 141, 169, 278, 0, 333, 0, 0, 0, 90, 174, "porta_clan", 400, 0, 0, "LAST_HIT", 0, 0, 0, "fighter"),
(20215, 20215, "Mordeo", 0, "", 0, "Monster.onyx_beast", 14, 14.5, 42, "male", "L2Monster", 40, 1660, 589, 17.38, 2.14, 40, 43, 30, 21, 20, 10, 2625, 175, 342, 196, 152, 175, 278, 500, 333, 0, 0, 0, 30, 174, "beast_clan", 400, 0, 0, "LAST_HIT", 0, 0, 0, "fighter"),
(20216, 20216, "Ricenseo", 0, "", 0, "Monster.monster_eye", 21, 43, 43, "male", "L2Monster", 40, 1728, 618, 17.38, 2.14, 40, 43, 30, 21, 20, 10, 2104, 142, 332, 223, 163, 181, 278, 0, 333, 0, 0, 0, 90, 174, "porta_clan", 400, 0, 0, "LAST_HIT", 0, 0, 0, "fighter"),
(20217, 20217, "Krator", 0, "", 0, "Monster.stone_golem", 20, 31, 44, "male", "L2Monster", 40, 1799, 648, 17.38, 2.14, 40, 43, 30, 21, 20, 10, 2688, 184, 322, 253, 176, 187, 278, 500, 333, 0, 0, 0, 23, 23, "porta_clan", 400, 0, 0, "LAST_HIT", 0, 0, 0, "fighter"),
(20218, 20218, "Premo", 0, "", 0, "Monster.troll", 21, 35, 45, "male", "L2Monster", 40, 1870, 677, 17.38, 2.14, 40, 43, 30, 21, 20, 10, 2812, 195, 415, 216, 188, 193, 278, 0, 333, 0, 0, 0, 55, 174, "porta_clan", 400, 0, 0, "LAST_HIT", 0, 0, 0, "fighter"),
(20219, 20219, "Validus", 0, "", 0, "Monster.grave", 15, 29, 46, "male", "L2Monster", 40, 1943, 707, 17.38, 2.14, 40, 43, 30, 21, 20, 10, 2408, 170, 365, 270, 202, 199, 278, 0, 333, 0, 0, 0, 70, 174, "torfe_clan", 400, 0, 0, "LAST_HIT", 0, 0, 0, "fighter"),
(20220, 20220, "Dicor", 0, "", 0, "Monster.mandragora_b", 12, 25.5, 47, "female", "L2Monster", 40, 2016, 738, 17.38, 2.14, 40, 43, 30, 21, 20, 10, 2867, 205, 469, 230, 216, 206, 278, 500, 333, 0, 0, 0, 80, 174, "torfe_clan", 400, 0, 0, "LAST_HIT", 0, 0, 0, "fighter"),
(20221, 20221, "Perum", 0, "", 0, "Monster.iron_golem", 18, 34, 48, "male", "L2Monster", 40, 2091, 768, 17.38, 2.14, 40, 43, 30, 21, 20, 10, 3438, 251, 412, 288, 231, 212, 278, 500, 333, 0, 0, 0, 20, 20, "torfe_clan", 300, 0, 0, "LAST_HIT", 0, 0, 0, "fighter"),
(20222, 20222, "Torfe", 0, "", 0, "Monster.grave", 15, 29, 49, "male", "L2Monster", 40, 2168, 799, 17.38, 2.14, 40, 43, 30, 21, 20, 10, 3025, 223, 529, 245, 247, 219, 278, 0, 333, 0, 0, 0, 70, 174, "torfe_clan", 300, 0, 0, "LAST_HIT", 0, 0, 0, "fighter"),
(20223, 20223, "Mandragora Sprout", 0, "", 0, "Monster.manadragora", 14, 17.8, 20, "female", "L2Monster", 40, 541, 213, 3.95, 1.21, 40, 43, 30, 21, 20, 10, 783, 35, 63, 86, 23, 76, 278, 0, 333, 0, 0, 0, 80, 80, "mandragora_clan", 300, 0, 0, "LAST_HIT", 0, 0, 0, "fighter"),
(20224, 20224, "Ol Mahum Ranger", 0, "", 0, "Monster.ol_mahum_archer", 14, 25, 22, "male", "L2Monster", 500, 611, 242, 5.53, 1.53, 40, 43, 30, 21, 20, 10, 1059, 50, 139, 113, 28, 83, 247, 0, 333, 13, 0, 0, 50, 110, "ol_mahum_clan", 300, 0, 0, "LAST_HIT", 0, 0, 0, "archer"),
(20225, 20225, "Giant Mist Leech", 0, "", 0, "Monster.giant_leech", 70, 29, 25, "male", "L2Monster", 40, 728, 287, 5.53, 1.53, 40, 43, 30, 21, 20, 10, 992, 50, 88, 116, 37, 94, 278, 0, 333, 0, 0, 0, 50, 110, "giant_leech_clan", 300, 0, 0, "LAST_HIT", 0, 0, 0, "fighter"),
(20226, 20226, "Gray Ant", 0, "", 0, "Monster.ant", 26, 15, 26, "male", "L2Monster", 40, 770, 303, 5.53, 1.53, 40, 43, 30, 21, 20, 10, 1056, 53, 87, 132, 41, 98, 278, 0, 333, 0, 0, 0, 40, 130, "ant_clan", 300, 0, 0, "LAST_HIT", 0, 0, 0, "fighter"),
(20227, 20227, "Horror Mist Ripper", 0, "", 0, "Monster.dark_horror", 20, 35, 27, "male", "L2Monster", 40, 813, 318, 5.53, 1.53, 40, 43, 30, 21, 20, 10, 1124, 58, 114, 114, 45, 102, 278, 500, 333, 0, 0, 0, 100, 100, "NULL", 0, 1, 0, "LAST_HIT", 0, 0, 0, "fighter"),
(20228, 20228, "Giant Crimson Ant", 0, "", 0, "Monster.ant_soldier", 35, 17, 28, "male", "L2Monster", 40, 859, 334, 5.53, 1.53, 40, 43, 30, 21, 20, 10, 1296, 68, 124, 118, 49, 106, 278, 0, 333, 0, 0, 0, 80, 130, "ant_clan", 300, 0, 0, "LAST_HIT", 0, 0, 0, "fighter"),
(20229, 20229, "Stinger Wasp", 0, "", 0, "Monster.giant_bee", 8, 24.5, 30, "male", "L2Monster", 40, 954, 365, 5.53, 1.53, 40, 43, 30, 21, 20, 10, 1454, 79, 120, 155, 58, 114, 278, 500, 333, 0, 0, 0, 90, 90, "NULL", 0, 0, 0, "LAST_HIT", 0, 0, 0, "fighter"),
(20230, 20230, "Marsh Stakato Worker", 0, "", 0, "Monster.marsh_stakato_worker", 9, 21, 31, "male", "L2Monster", 40, 1004, 381, 7.11, 1.84, 40, 43, 30, 21, 20, 10, 1663, 92, 142, 146, 64, 118, 278, 0, 333, 153, 0, 0, 20, 140, "stakato_clan", 300, 0, 0, "LAST_HIT", 0, 0, 0, "fighter"),
(20231, 20231, "Toad Lord", 0, "", 0, "Monster.poison_toad", 20, 10, 32, "male", "L2Monster", 40, 1056, 397, 7.11, 1.84, 40, 43, 30, 21, 20, 10, 1622, 91, 140, 167, 69, 123, 278, 0, 333, 0, 0, 0, 50, 100, "NULL", 0, 0, 0, "LAST_HIT", 0, 0, 0, "fighter"),
(20232, 20232, "Marsh Stakato Soldier", 0, "", 0, "Monster.marsh_stakato_soldier", 10, 25, 33, "male", "L2Monster", 40, 1109, 413, 7.11, 1.84, 40, 43, 30, 21, 20, 10, 1583, 91, 132, 173, 75, 128, 317, 0, 333, 217, 0, 0, 30, 155, "stakato_clan", 300, 0, 0, "LAST_HIT", 0, 0, 0, "fighter"),
(20233, 20233, "Marsh Spider", 0, "", 0, "Monster.poison_spider", 27, 25.5, 34, "male", "L2Monster", 40, 1164, 430, 7.11, 1.84, 40, 43, 30, 21, 20, 10, 1867, 109, 178, 163, 82, 132, 278, 500, 333, 0, 0, 0, 60, 140, "NULL", 0, 0, 0, "LAST_HIT", 0, 0, 0, "fighter"),
(20234, 20234, "Marsh Stakato Drone", 0, "", 0, "Monster.marsh_stakato_drone", 9, 24, 35, "male", "L2Monster", 40, 1220, 446, 7.11, 1.84, 40, 43, 30, 21, 20, 10, 1889, 112, 185, 154, 89, 137, 317, 500, 333, 219, 0, 0, 80, 174, "stakato_clan", 300, 0, 0, "LAST_HIT", 0, 0, 0, "fighter"),
(20235, 20235, "Shackle", 0, "", 0, "Monster.hungry_spirit", 30, 40, 45, "male", "L2Monster", 40, 1870, 677, 8.69, 2.14, 40, 43, 30, 21, 20, 10, 2974, 207, 343, 262, 188, 193, 278, 500, 333, 0, 0, 0, 15, 174, "NULL", 0, 1, 0, "LAST_HIT", 0, 0, 0, "fighter"),
(20236, 20236, "Cave Servant", 0, "", 0, "Monster.skeleton", 11, 25, 46, "male", "L2Monster", 40, 1943, 707, 8.69, 2.14, 40, 43, 30, 21, 20, 10, 3077, 218, 365, 270, 202, 199, 278, 0, 333, 79, 945, 0, 66, 191, "cave_servant_clan", 300, 1, 0, "LAST_HIT", 0, 0, 0, "fighter"),
(20237, 20237, "Cave Servant Archer", 0, "", 0, "Monster.skeleton_archer", 11, 27, 47, "male", "L2Monster", 500, 2016, 738, 8.69, 2.14, 40, 43, 30, 21, 20, 10, 4143, 297, 1043, 230, 216, 206, 249, 0, 333, 14, 0, 0, 44, 191, "cave_servant_clan", 300, 1, 0, "LAST_HIT", 0, 0, 0, "archer"),
(20238, 20238, "Cave Servant Warrior", 0, "", 0, "Monster.skeleton", 11, 25, 48, "male", "L2Monster", 40, 2091, 768, 8.69, 2.14, 40, 43, 30, 21, 20, 10, 3987, 291, 498, 238, 231, 212, 278, 0, 333, 77, 2495, 0, 66, 191, "cave_servant_clan", 300, 1, 0, "LAST_HIT", 0, 0, 0, "fighter"),
(20239, 20239, "Cave Servant Captain", 0, "", 0, "Monster.spartoi", 11, 27, 49, "male", "L2Monster", 40, 2168, 799, 8.69, 2.14, 40, 43, 30, 21, 20, 10, 4238, 313, 437, 297, 247, 219, 278, 500, 333, 73, 2495, 0, 66, 191, "cave_servant_clan", 300, 1, 0, "LAST_HIT", 0, 0, 0, "fighter"),
(20240, 20240, "Royal Cave Servant", 0, "", 0, "Monster.skeleton_royal_guard", 11, 28.5, 51, "male", "L2Monster", 40, 2323, 861, 10.27, 2.45, 40, 43, 30, 21, 20, 10, 4546, 347, 429, 315, 281, 232, 317, 0, 333, 946, 945, 0, 88, 191, "cave_servant_clan", 400, 1, 0, "LAST_HIT", 0, 0, 0, "balanced"),
(20241, 20241, "Hunter Gargoyle", 0, "", 0, "Monster.hunter_gargoyle", 25, 65, 52, "male", "L2Monster", 40, 2402, 892, 10.27, 2.45, 40, 43, 30, 21, 20, 10, 4633, 358, 627, 268, 300, 239, 278, 0, 333, 0, 0, 0, 100, 174, "NULL", 0, 0, 0, "LAST_HIT", 0, 0, 0, "fighter"),
(20242, 20242, "Dustwind Gargoyle", 0, "", 0, "Monster.hunter_gargoyle", 25, 65, 53, "male", "L2Monster", 40, 2481, 923, 10.27, 2.45, 40, 43, 30, 21, 20, 10, 4813, 378, 547, 334, 319, 247, 278, 0, 333, 0, 0, 0, 100, 174, "NULL", 0, 0, 0, "LAST_HIT", 0, 0, 0, "fighter"),
(20243, 20243, "Thunder Wyrm", 0, "", 0, "Monster.wyrm", 29, 72, 54, "male", "L2Monster", 40, 2562, 955, 10.27, 2.45, 40, 43, 30, 21, 20, 10, 4283, 341, 699, 284, 339, 254, 278, 500, 333, 0, 0, 0, 70, 174, "NULL", 0, 0, 0, "LAST_HIT", 0, 0, 0, "fighter"),
(20244, 20244, "Malruk Succubus", 0, "", 0, "Monster.succubus", 10, 36, 55, "female", "L2Monster", 40, 2643, 987, 10.27, 2.45, 40, 43, 30, 21, 20, 10, 4399, 355, 737, 292, 360, 261, 278, 0, 333, 0, 0, 0, 60, 174, "succubus_clan", 300, 0, 0, "LAST_HIT", 0, 0, 0, "fighter"),
(20245, 20245, "Malruk Succubus Turen", 0, "", 0, "Monster.succubus", 10, 36, 56, "female", "L2Monster", 40, 2724, 1019, 10.27, 2.45, 40, 43, 30, 21, 20, 10, 4560, 375, 777, 301, 382, 269, 278, 0, 333, 0, 0, 0, 60, 174, "succubus_clan", 300, 0, 0, "LAST_HIT", 0, 0, 0, "fighter"),
(20246, 20246, "Cave Keeper", 0, "", 0, "Monster.serpent_slave", 17, 46, 58, "male", "L2Monster", 40, 2889, 1084, 10.27, 2.45, 40, 43, 30, 21, 20, 10, 5822, 492, 751, 318, 428, 284, 317, 0, 333, 223, 0, 0, 70, 174, "cave_servant_clan", 300, 0, 0, "LAST_HIT", 0, 0, 0, "fighter"),
(20248, 20248, "Turak Bugbear", 0, "", 0, "Monster.bugbear", 17, 35, 31, "male", "L2Monster", 40, 1004, 381, 7.11, 1.84, 40, 43, 30, 21, 20, 10, 1397, 78, 129, 161, 64, 118, 278, 0, 333, 88, 0, 0, 55, 130, "bugbear_clan", 300, 0, 0, "LAST_HIT", 0, 0, 0, "fighter"),
(20249, 20249, "Turak Bugbear Warrior", 0, "", 0, "Monster.bugbear", 17, 35, 33, "male", "L2Monster", 40, 1109, 413, 14.22, 1.84, 40, 43, 30, 21, 20, 10, 1502, 86, 151, 173, 75, 128, 278, 500, 333, 73, 0, 0, 55, 130, "bugbear_clan", 300, 0, 0, "LAST_HIT", 0, 0, 0, "fighter"),
(20250, 20250, "Glass Jaguar", 0, "", 0, "Monster.onyx_beast", 14, 14.5, 27, "male", "L2Monster", 40, 813, 318, 5.53, 1.53, 40, 43, 30, 21, 20, 10, 1102, 56, 114, 114, 45, 102, 278, 0, 333, 0, 0, 0, 30, 120, "NULL", 0, 0, 0, "LAST_HIT", 0, 0, 0, "fighter"),
(20251, 20251, "Delu Lizardman", 0, "", 0, "Monster.virud_lizardman", 10, 23, 28, "male", "L2Monster", 40, 859, 334, 5.53, 1.53, 40, 43, 30, 21, 20, 10, 1166, 61, 102, 143, 49, 106, 278, 0, 333, 1, 19, 0, 43, 130, "NULL", 0, 0, 0, "LAST_HIT", 0, 0, 0, "fighter"),
(20252, 20252, "Delu Lizardman Scout", 0, "", 0, "Monster.virud_lizardman", 10, 23, 29, "male", "L2Monster", 40, 906, 349, 5.53, 1.53, 40, 43, 30, 21, 20, 10, 1231, 66, 134, 123, 53, 110, 278, 0, 333, 123, 0, 0, 43, 130, "NULL", 0, 0, 0, "LAST_HIT", 0, 0, 0, "fighter"),
(20253, 20253, "Delu Lizardman Warrior", 0, "", 0, "Monster.virud_lizardman_warrior", 12, 30, 30, "male", "L2Monster", 40, 954, 365, 5.53, 1.53, 40, 43, 30, 21, 20, 10, 1321, 72, 120, 155, 58, 114, 278, 500, 333, 16, 0, 0, 52, 130, "NULL", 0, 0, 0, "LAST_HIT", 0, 0, 0, "fighter"),
(20254, 20254, "Skeleton Axeman", 0, "", 0, "Monster.skeleton", 11, 25, 28, "male", "L2Monster", 40, 859, 334, 5.53, 1.53, 40, 43, 30, 21, 20, 10, 1201, 63, 113, 130, 49, 106, 278, 500, 333, 86, 0, 0, 60, 140, "skeleton_clan", 300, 1, 0, "LAST_HIT", 0, 0, 0, "fighter"),
(20255, 20255, "Batur Orc", 0, "", 0, "Monster.batur_orc", 9, 21.5, 31, "male", "L2Monster", 40, 1004, 381, 7.11, 1.84, 40, 43, 30, 21, 20, 10, 1164, 65, 129, 161, 64, 118, 278, 0, 333, 123, 0, 0, 88, 143, "orc_clan", 300, 0, 0, "LAST_HIT", 0, 0, 0, "fighter"),
(20256, 20256, "Batur Orc Archer", 0, "", 0, "Monster.batur_orc_archer", 11, 21.5, 32, "male", "L2Monster", 500, 1056, 397, 7.11, 1.84, 40, 43, 30, 21, 20, 10, 1600, 90, 311, 167, 69, 123, 249, 0, 333, 13, 0, 0, 49, 143, "orc_clan", 300, 0, 0, "LAST_HIT", 0, 0, 0, "archer"),
(20257, 20257, "Batur Orc Warrior", 0, "", 0, "Monster.batur_orc_warrior", 10, 20, 33, "male", "L2Monster", 40, 1109, 413, 7.11, 1.84, 40, 43, 30, 21, 20, 10, 1602, 92, 182, 143, 75, 128, 278, 500, 333, 123, 19, 0, 88, 132, "orc_clan", 300, 0, 0, "LAST_HIT", 0, 0, 0, "fighter"),
(20258, 20258, "Batur Orc Shaman", 0, "", 0, "Monster.batur_orc_shaman", 11, 16, 34, "male", "L2Monster", 40, 1164, 430, 7.11, 1.84, 40, 43, 30, 21, 20, 10, 1401, 82, 196, 148, 82, 132, 278, 0, 333, 7, 0, 0, 55, 132, "orc_clan", 300, 0, 0, "LAST_HIT", 0, 0, 0, "balanced"),
(20259, 20259, "Batur Orc Overlord", 0, "", 0, "Monster.batur_orc_overlord", 12, 24, 35, "male", "L2Monster", 40, 1220, 446, 7.11, 1.84, 40, 43, 30, 21, 20, 10, 1802, 107, 211, 154, 89, 137, 278, 500, 333, 79, 0, 0, 88, 154, "orc_clan", 300, 0, 0, "LAST_HIT", 0, 0, 0, "fighter"),
(20260, 20260, "Orc Champion", 0, "", 0, "Monster.orc_champion", 10, 23, 14, "male", "L2Monster", 40, 364, 156, 3.95, 1.21, 40, 43, 30, 21, 20, 10, 435, 17, 30, 80, 12, 59, 278, 500, 333, 2, 0, 0, 49, 143, "orc_clan", 300, 0, 0, "LAST_HIT", 0, 0, 0, "fighter"),
(20261, 20261, "Orc Shaman", 0, "", 0, "Monster.orc_shaman", 9, 22, 17, "male", "L2Monster", 40, 446, 184, 3.95, 1.21, 40, 43, 30, 21, 20, 10, 504, 21, 40, 91, 17, 67, 278, 0, 333, 7, 0, 0, 49, 132, "orc_clan", 300, 0, 0, "LAST_HIT", 0, 0, 0, "balanced"),
(20265, 20265, "Monster Eye Searcher", 0, "", 0, "Monster.monster_eye", 21, 43, 22, "male", "L2Monster", 40, 611, 242, 11.06, 1.53, 40, 43, 30, 21, 20, 10, 763, 36, 75, 93, 28, 83, 278, 0, 333, 0, 0, 0, 90, 159, "NULL", 0, 0, 0, "LAST_HIT", 0, 0, 0, "fighter"),
(20266, 20266, "Monster Eye Gazer", 0, "", 0, "Monster.monster_eye", 21, 43, 25, "male", "L2Monster", 40, 728, 287, 5.53, 1.53, 40, 43, 30, 21, 20, 10, 992, 50, 80, 127, 37, 94, 278, 0, 333, 0, 0, 0, 90, 159, "NULL", 0, 0, 0, "LAST_HIT", 0, 0, 0, "fighter"),
(20267, 20267, "Breka Orc", 0, "", 0, "Monster.batur_orc", 9, 21.5, 31, "male", "L2Monster", 40, 1004, 381, 7.11, 1.84, 40, 43, 30, 21, 20, 10, 1397, 78, 113, 161, 64, 118, 317, 0, 333, 215, 0, 0, 80, 130, "orc_clan", 300, 0, 0, "LAST_HIT", 0, 0, 0, "fighter"),
(20268, 20268, "Breka Orc Archer", 0, "", 0, "Monster.batur_orc_archer", 11, 21.5, 32, "male", "L2Monster", 500, 1056, 397, 7.11, 1.84, 40, 43, 30, 21, 20, 10, 1920, 108, 311, 167, 69, 123, 247, 0, 333, 275, 0, 0, 45, 130, "orc_clan", 300, 0, 0, "LAST_HIT", 0, 0, 0, "archer"),
(20269, 20269, "Breka Orc Shaman", 0, "", 0, "Monster.batur_orc_shaman", 11, 16, 34, "male", "L2Monster", 40, 1164, 430, 7.11, 1.84, 40, 43, 30, 21, 20, 10, 1681, 98, 162, 179, 82, 132, 278, 0, 333, 7, 0, 0, 55, 132, "orc_clan", 300, 0, 0, "LAST_HIT", 0, 0, 0, "balanced"),
(20270, 20270, "Breka Orc Overlord", 0, "", 0, "Monster.batur_orc_overlord", 12, 24, 35, "male", "L2Monster", 40, 1220, 446, 7.11, 1.84, 40, 43, 30, 21, 20, 10, 2380, 141, 211, 154, 89, 137, 278, 500, 333, 79, 0, 0, 88, 191, "orc_clan", 300, 0, 0, "LAST_HIT", 0, 0, 0, "fighter"),
(20271, 20271, "Breka Orc Warrior", 0, "", 0, "Monster.batur_orc_warrior", 10, 20, 33, "male", "L2Monster", 40, 1109, 413, 7.11, 1.84, 40, 43, 30, 21, 20, 10, 1922, 110, 182, 143, 75, 128, 278, 500, 333, 123, 20, 0, 88, 132, "orc_clan", 300, 0, 0, "LAST_HIT", 0, 0, 0, "fighter"),
(20272, 20272, "Cave Servant", 0, "", 0, "Monster.skeleton", 11, 25, 46, "male", "L2Monster", 40, 1943, 707, 8.69, 2.14, 40, 43, 30, 21, 20, 10, 2564, 182, 365, 270, 202, 199, 278, 0, 333, 79, 945, 0, 66, 154, "cave_servant_clan", 300, 1, 0, "LAST_HIT", 0, 0, 0, "fighter"),
(20273, 20273, "Cave Servant Archer", 0, "", 0, "Monster.skeleton_archer", 11, 27, 47, "male", "L2Monster", 500, 2016, 738, 8.69, 2.14, 40, 43, 30, 21, 20, 10, 2757, 198, 1043, 230, 216, 206, 249, 0, 333, 275, 0, 0, 44, 154, "cave_servant_clan", 300, 1, 0, "LAST_HIT", 0, 0, 0, "archer"),
(20274, 20274, "Cave Servant Warrior", 0, "", 0, "Monster.skeleton", 11, 25, 48, "male", "L2Monster", 40, 2091, 768, 8.69, 2.14, 40, 43, 30, 21, 20, 10, 2792, 204, 498, 238, 231, 212, 278, 0, 333, 77, 0, 0, 66, 154, "cave_servant_clan", 300, 1, 0, "LAST_HIT", 0, 0, 0, "fighter"),
(20275, 20275, "Cave Servant Captain", 0, "", 0, "Monster.spartoi", 11, 27, 49, "male", "L2Monster", 40, 2168, 799, 8.69, 2.14, 40, 43, 30, 21, 20, 10, 2968, 219, 437, 297, 247, 219, 278, 500, 333, 73, 0, 0, 66, 154, "cave_servant_clan", 300, 1, 0, "LAST_HIT", 0, 0, 0, "fighter"),
(20276, 20276, "Royal Cave Servant", 0, "", 0, "Monster.skeleton_royal_guard", 11, 28.5, 51, "male", "L2Monster", 40, 2323, 861, 10.27, 2.45, 40, 43, 30, 21, 20, 10, 3152, 240, 429, 315, 281, 232, 317, 0, 333, 946, 945, 0, 88, 132, "cave_servant_clan", 300, 1, 0, "LAST_HIT", 0, 0, 0, "balanced"),
(20277, 20277, "Cave Keeper", 0, "", 0, "Monster.serpent_slave", 17, 46, 58, "male", "L2Monster", 40, 2889, 1084, 10.27, 2.45, 40, 43, 30, 21, 20, 10, 4077, 344, 751, 318, 428, 284, 317, 0, 333, 223, 0, 0, 77, 121, "cave_servant_clan", 300, 0, 0, "LAST_HIT", 0, 0, 0, "fighter"),
(20279, 20279, "Shackle", 0, "", 0, "Monster.hungry_spirit", 30, 40, 45, "male", "L2Monster", 40, 1870, 677, 8.69, 2.14, 40, 43, 30, 21, 20, 10, 2478, 172, 343, 262, 188, 193, 278, 500, 333, 0, 0, 0, 16, 132, "NULL", 0, 1, 0, "LAST_HIT", 0, 0, 0, "fighter"),
(20280, 20280, "Headless Knight", 0, "", 0, "Monster.headless_knight", 21, 31, 50, "male", "L2Monster", 40, 2245, 830, 8.69, 2.14, 40, 43, 30, 21, 20, 10, 3090, 233, 463, 306, 264, 226, 278, 500, 333, 124, 0, 0, 77, 121, "NULL", 0, 1, 0, "LAST_HIT", 0, 0, 0, "fighter"),
(20281, 20281, "Dustwind Gargoyle", 0, "", 0, "Monster.hunter_gargoyle", 25, 65, 53, "male", "L2Monster", 40, 2481, 923, 10.27, 2.45, 40, 43, 30, 21, 20, 10, 3370, 265, 547, 334, 319, 247, 278, 0, 333, 0, 0, 0, 110, 110, "NULL", 0, 0, 0, "LAST_HIT", 0, 0, 0, "fighter"),
(20282, 20282, "Thunder Wyrm", 0, "", 0, "Monster.wyrm", 29, 72, 54, "male", "L2Monster", 40, 2562, 955, 10.27, 2.45, 40, 43, 30, 21, 20, 10, 3569, 285, 699, 284, 339, 254, 278, 500, 333, 0, 0, 0, 77, 77, "NULL", 0, 0, 0, "LAST_HIT", 0, 0, 0, "fighter"),
(20283, 20283, "Malruk Succubus", 0, "", 0, "Monster.succubus", 10, 36, 55, "female", "L2Monster", 40, 2643, 987, 10.27, 2.45, 40, 43, 30, 21, 20, 10, 3666, 296, 737, 292, 360, 261, 278, 0, 333, 0, 0, 0, 66, 110, "succubus_clan", 300, 0, 0, "LAST_HIT", 0, 0, 0, "fighter"),
(20284, 20284, "Malruk Succubus Turen", 0, "", 0, "Monster.succubus", 10, 36, 56, "female", "L2Monster", 40, 2724, 1019, 10.27, 2.45, 40, 43, 30, 21, 20, 10, 3800, 312, 777, 301, 382, 269, 278, 0, 333, 0, 0, 0, 66, 110, "succubus_clan", 300, 0, 0, "LAST_HIT", 0, 0, 0, "fighter"),
(20285, 20285, "Drake", 0, "", 0, "Monster.drake", 30, 100, 57, "male", "L2Monster", 40, 2806, 1052, 10.27, 2.45, 40, 43, 30, 21, 20, 10, 4016, 334, 817, 309, 405, 276, 278, 500, 333, 0, 0, 0, 77, 77, "dragon_clan", 300, 0, 0, "LAST_HIT", 0, 0, 0, "fighter"),
(20286, 20286, "Hunter Gargoyle", 0, "", 0, "Monster.hunter_gargoyle", 25, 65, 52, "male", "L2Monster", 40, 2402, 892, 10.27, 2.45, 40, 43, 30, 21, 20, 10, 3244, 251, 627, 268, 300, 239, 278, 0, 333, 0, 0, 0, 110, 110, "NULL", 0, 0, 0, "LAST_HIT", 0, 0, 0, "fighter"),
(20287, 20287, "Cave Maiden", 0, "", 0, "Monster.cave_maiden", 25, 65, 59, "female", "L2Monster", 40, 2971, 1117, 10.27, 2.45, 40, 43, 30, 21, 20, 10, 4260, 364, 902, 326, 453, 291, 278, 500, 333, 68, 0, 0, 77, 132, "NULL", 0, 0, 0, "LAST_HIT", 0, 0, 0, "fighter"),
(20291, 20291, "Enku Orc Champion", 0, "", 0, "Monster.orc_champion", 10, 23, 21, "male", "L2Monster", 40, 575, 227, 5.53, 1.53, 40, 43, 30, 21, 20, 10, 927, 43, 57, 108, 25, 80, 278, 500, 333, 2, 0, 0, 45, 130, "orc_clan", 300, 0, 0, "LAST_HIT", 0, 0, 0, "fighter"),
(20292, 20292, "Enku Orc Shaman", 0, "", 0, "Monster.orc_shaman", 9, 22, 20, "male", "L2Monster", 40, 541, 213, 3.95, 1.21, 40, 43, 30, 21, 20, 10, 813, 36, 52, 104, 23, 76, 278, 0, 333, 7, 0, 0, 45, 120, "orc_clan", 300, 0, 0, "LAST_HIT", 0, 0, 0, "balanced"),
(20293, 20293, "Virud Lizardman", 0, "", 0, "Monster.virud_lizardman", 10, 23, 20, "male", "L2Monster", 40, 541, 213, 3.95, 1.21, 40, 43, 30, 21, 20, 10, 593, 26, 52, 104, 23, 76, 278, 0, 333, 291, 0, 0, 47, 143, "lizardman_clan", 300, 0, 0, "LAST_HIT", 0, 0, 0, "fighter"),
(20294, 20294, "Virud Lizardman Matriarch", 0, "", 0, "Monster.virud_lizardman_matriarch", 13, 37, 24, "male", "L2Monster", 40, 687, 272, 5.53, 1.53, 40, 43, 30, 21, 20, 10, 951, 47, 89, 101, 34, 90, 278, 500, 333, 2, 19, 0, 61, 143, "lizardman_clan", 300, 0, 0, "LAST_HIT", 0, 0, 0, "fighter"),
(20295, 20295, "Virud Lizardman Warrior", 0, "", 0, "Monster.virud_lizardman_warrior", 12, 30, 22, "male", "L2Monster", 40, 611, 242, 5.53, 1.53, 40, 43, 30, 21, 20, 10, 698, 33, 75, 93, 28, 83, 278, 500, 333, 16, 0, 0, 57, 143, "lizardman_clan", 300, 0, 0, "LAST_HIT", 0, 0, 0, "fighter"),
(20296, 20296, "Virud Lizardman Scout", 0, "", 0, "Monster.virud_lizardman_scout", 10, 22, 21, "male", "L2Monster", 500, 575, 227, 5.53, 1.53, 40, 43, 30, 21, 20, 10, 656, 30, 127, 108, 25, 80, 249, 0, 333, 2507, 0, 0, 47, 143, "lizardman_clan", 300, 0, 0, "LAST_HIT", 0, 0, 0, "fighter"),
(20297, 20297, "Virud Lizardman Shaman ", 0, "", 0, "Monster.virud_lizardman_shaman", 10, 29, 23, "male", "L2Monster", 40, 648, 257, 5.53, 1.53, 40, 43, 30, 21, 20, 10, 731, 35, 68, 117, 31, 87, 278, 0, 333, 7, 0, 0, 47, 132, "lizardman_clan", 300, 0, 0, "LAST_HIT", 0, 0, 0, "balanced"),
(20298, 20298, "Virud Lizardman Shaman ", 0, "", 0, "Monster.virud_lizardman_shaman", 10, 29, 23, "male", "L2Monster", 40, 648, 257, 5.53, 1.53, 40, 43, 30, 21, 20, 10, 731, 35, 68, 117, 31, 87, 278, 0, 333, 7, 0, 0, 47, 132, "lizardman_clan", 300, 0, 0, "LAST_HIT", 0, 0, 0, "balanced"),
(20299, 20299, "Zenta Lizardman", 0, "", 0, "Monster.zenta_lizardman", 11, 32, 40, "male", "L2Monster", 40, 1527, 531, 7.11, 1.84, 40, 43, 30, 21, 20, 10, 1939, 125, 248, 222, 131, 164, 278, 0, 333, 68, 0, 0, 40, 154, "lizardman_clan", 300, 0, 0, "LAST_HIT", 0, 0, 0, "fighter"),
(20300, 20300, "Zenta Lizardman Matriarch", 0, "", 0, "Monster.zenta_lizardman_matriarch", 20, 40, 44, "male", "L2Monster", 40, 1799, 648, 8.69, 2.14, 40, 43, 30, 21, 20, 10, 2848, 195, 341, 209, 176, 187, 317, 500, 333, 221, 0, 0, 58, 154, "lizardman_clan", 300, 0, 0, "LAST_HIT", 0, 0, 0, "fighter"),
(20301, 20301, "Zenta Lizardman Scout", 0, "", 0, "Monster.zenta_lizardman_scout", 11, 30, 41, "male", "L2Monster", 500, 1593, 560, 8.69, 2.14, 40, 43, 30, 21, 20, 10, 2098, 137, 589, 229, 141, 169, 249, 0, 333, 14, 0, 0, 40, 165, "lizardman_clan", 300, 0, 0, "LAST_HIT", 0, 0, 0, "fighter"),
(20302, 20302, "Zenta Lizardman Warrior", 0, "", 0, "Monster.zenta_lizardman_warrior", 13, 35, 42, "male", "L2Monster", 40, 1660, 589, 8.69, 2.14, 40, 43, 30, 21, 20, 10, 2180, 145, 342, 196, 152, 175, 278, 500, 333, 16, 0, 0, 44, 154, "lizardman_clan", 300, 0, 0, "LAST_HIT", 0, 0, 0, "fighter"),
(20303, 20303, "Zenta Lizardman Shaman", 0, "", 0, "Monster.zenta_lizardman_shaman", 13, 35, 43, "male", "L2Monster", 40, 1728, 618, 8.69, 2.14, 40, 43, 30, 21, 20, 10, 2240, 152, 302, 245, 163, 181, 278, 0, 333, 7, 0, 0, 47, 143, "lizardman_clan", 300, 0, 0, "LAST_HIT", 0, 0, 0, "balanced"),
(20304, 20304, "Marsh Stakato Queen", 0, "", 0, "Monster.marsh_stakato_queen", 15, 37, 36, "female", "L2Monster", 40, 1279, 463, 7.11, 1.84, 40, 43, 30, 21, 20, 10, 1906, 115, 227, 159, 96, 142, 278, 500, 333, 74, 0, 0, 143, 143, "stakato_clan", 300, 0, 0, "LAST_HIT", 0, 0, 0, "fighter"),
(20305, 20305, "Grave", 0, "", 0, "Monster.grave", 15, 29, 40, "male", "L2Monster", 40, 1527, 531, 7.11, 1.84, 40, 43, 30, 21, 20, 10, 1958, 126, 300, 183, 131, 164, 278, 500, 333, 0, 0, 0, 77, 121, "NULL", 0, 0, 0, "LAST_HIT", 0, 0, 0, "fighter"),
(20307, 20307, "Garum Werewolf", 0, "", 0, "Monster.werewolf", 10, 26, 9, "male", "L2Monster", 40, 226, 111, 3.16, 0.91, 40, 43, 30, 21, 20, 10, 321, 11, 22, 53, 7, 47, 278, 0, 333, 5, 0, 0, 55, 132, "werewolf_clan", 300, 0, 0, "LAST_HIT", 0, 0, 0, "fighter"),
(20308, 20308, "Hook Spider", 0, "", 0, "Monster.giant_spider", 26, 25.5, 16, "male", "L2Monster", 40, 417, 174, 3.95, 1.21, 40, 43, 30, 21, 20, 10, 570, 23, 44, 72, 15, 64, 278, 0, 333, 0, 0, 0, 79, 143, "NULL", 0, 0, 0, "LAST_HIT", 0, 0, 0, "fighter"),
(20309, 20309, "Brown Fox", 0, "", 0, "Monster.fox", 9.5, 10, 2, "male", "L2Monster", 40, 75, 52, 3.16, 0.91, 40, 43, 30, 21, 20, 10, 58, 2, 10, 42, 3, 34, 278, 0, 333, 0, 0, 0, 25, 121, "NULL", 0, 0, 0, "LAST_HIT", 0, 0, 0, "fighter"),
(20310, 20310, "Brown Bear", 0, "", 0, "Monster.grizzly_bi", 21, 50, 16, "male", "L2Monster", 40, 417, 174, 3.95, 1.21, 40, 43, 30, 21, 20, 10, 576, 23, 36, 87, 15, 64, 278, 500, 333, 0, 0, 0, 40, 110, "NULL", 0, 0, 0, "LAST_HIT", 0, 0, 0, "fighter"),
(20311, 20311, "Rakeclaw Imp", 0, "", 0, "Monster.imp", 10, 24, 6, "male", "L2Monster", 40, 147, 85, 3.16, 0.91, 40, 43, 30, 21, 20, 10, 213, 6, 16, 46, 5, 41, 278, 0, 333, 0, 0, 0, 60, 80, "demonic_clan", 300, 0, 0, "LAST_HIT", 0, 0, 0, "fighter"),
(20312, 20312, "Rakeclaw Imp Hunter", 0, "", 0, "Monster.imp", 10, 24, 7, "male", "L2Monster", 40, 171, 94, 3.16, 0.91, 40, 43, 30, 21, 20, 10, 249, 8, 18, 48, 6, 43, 278, 0, 333, 0, 0, 0, 60, 80, "demonic_clan", 300, 0, 0, "LAST_HIT", 0, 0, 0, "fighter"),
(20313, 20313, "Rakeclaw Imp Chieftain", 0, "", 0, "Monster.imp_bi", 10, 30, 10, "male", "L2Monster", 40, 257, 120, 3.16, 0.91, 40, 43, 30, 21, 20, 10, 363, 12, 25, 55, 8, 49, 278, 500, 333, 0, 0, 0, 66, 88, "demonic_clan", 300, 0, 0, "LAST_HIT", 0, 0, 0, "fighter"),
(20314, 20314, "Great White Shark", 0, "", 0, "Monster.great_white_shark", 20, 7, 42, "male", "L2Monster", 40, 1660, 589, 8.69, 2.14, 40, 43, 30, 21, 20, 10, 2180, 145, 342, 196, 152, 175, 278, 500, 333, 0, 0, 0, 88, 191, "NULL", 0, 0, 0, "LAST_HIT", 0, 0, 0, "fighter"),
(20316, 20316, "Darkwing Bat", 0, "", 0, "Monster.vampire_bat", 10, 33.5, 11, "male", "L2Monster", 40, 292, 129, 3.95, 1.21, 40, 43, 30, 21, 20, 10, 391, 15, 27, 58, 9, 52, 278, 0, 333, 0, 0, 0, 60, 80, "NULL", 0, 0, 0, "LAST_HIT", 0, 0, 0, "fighter"),
(20317, 20317, "Black Wolf", 0, "", 0, "Monster.wolf", 13, 9, 4, "male", "L2Monster", 40, 107, 68, 3.16, 0.91, 40, 43, 30, 21, 20, 10, 141, 4, 12, 46, 4, 37, 278, 0, 333, 0, 0, 0, 24, 110, "NULL", 0, 0, 0, "LAST_HIT", 0, 0, 0, "fighter"),
(20318, 20318, "Black Timber Wolf", 0, "", 0, "Monster.wolf_bi", 13, 10.8, 6, "male", "L2Monster", 40, 147, 85, 3.16, 0.91, 40, 43, 30, 21, 20, 10, 211, 6, 15, 50, 5, 41, 278, 0, 333, 0, 0, 0, 26, 121, "NULL", 0, 0, 0, "LAST_HIT", 0, 0, 0, "fighter"),
(20319, 20319, "Goblin Grave Robber", 0, "", 0, "Monster.goblin", 10, 16.5, 5, "male", "L2Monster", 40, 126, 77, 3.16, 0.91, 40, 43, 30, 21, 20, 10, 178, 5, 13, 48, 4, 39, 278, 0, 333, 4, 0, 0, 40, 110, "goblin_clan", 300, 0, 0, "LAST_HIT", 0, 0, 0, "fighter"),
(20320, 20320, "Goblin Tomb Raider Leader", 0, "", 0, "Monster.goblin_bi", 10, 21.4, 12, "male", "L2Monster", 40, 315, 138, 3.95, 1.21, 40, 43, 30, 21, 20, 10, 427, 16, 24, 66, 10, 54, 317, 0, 333, 12, 0, 0, 40, 110, "goblin_clan", 300, 0, 0, "LAST_HIT", 0, 0, 0, "fighter"),
(20321, 20321, "Goblin Thief", 0, "", 0, "Monster.goblin_bi", 10, 21.4, 10, "male", "L2Monster", 40, 257, 120, 3.16, 0.91, 40, 43, 30, 21, 20, 10, 356, 12, 20, 61, 8, 49, 317, 0, 333, 217, 0, 0, 40, 110, "goblin_clan", 300, 0, 0, "LAST_HIT", 0, 0, 0, "fighter"),
(20322, 20322, "Goblin Brigand", 0, "", 0, "Monster.goblin", 10, 16.5, 8, "male", "L2Monster", 40, 197, 102, 3.16, 0.91, 40, 43, 30, 21, 20, 10, 284, 10, 18, 55, 6, 45, 278, 0, 333, 4, 0, 0, 44, 121, "goblin_clan", 300, 0, 0, "LAST_HIT", 0, 0, 0, "fighter"),
(20323, 20323, "Goblin Brigand Leader", 0, "", 0, "Monster.goblin_bi", 10, 21.4, 14, "male", "L2Monster", 40, 364, 156, 3.95, 1.21, 40, 43, 30, 21, 20, 10, 508, 20, 29, 73, 12, 59, 317, 500, 333, 217, 0, 0, 44, 121, "goblin_clan", 300, 0, 0, "LAST_HIT", 0, 0, 0, "fighter"),
(20324, 20324, "Goblin Brigand Lieutenant", 0, "", 0, "Monster.goblin", 10, 16.5, 10, "male", "L2Monster", 40, 257, 120, 3.16, 0.91, 40, 43, 30, 21, 20, 10, 363, 12, 20, 61, 8, 49, 317, 500, 333, 10, 0, 0, 44, 121, "goblin_clan", 300, 0, 0, "LAST_HIT", 0, 0, 0, "fighter"),
(20325, 20325, "Goblin Raider", 0, "", 0, "Monster.goblin", 10, 16.5, 5, "male", "L2Monster", 40, 126, 77, 3.16, 0.91, 40, 43, 30, 21, 20, 10, 178, 5, 13, 48, 4, 39, 278, 0, 333, 4, 0, 0, 40, 110, "goblin_clan", 300, 0, 0, "LAST_HIT", 0, 0, 0, "fighter"),
(20326, 20326, "Goblin Scout", 0, "", 0, "Monster.goblin", 10, 16.5, 8, "male", "L2Monster", 40, 197, 102, 3.16, 0.91, 40, 43, 30, 21, 20, 10, 284, 10, 18, 55, 6, 45, 278, 0, 333, 4, 0, 0, 40, 110, "goblin_clan", 300, 0, 0, "LAST_HIT", 0, 0, 0, "fighter"),
(20327, 20327, "Goblin Snooper", 0, "", 0, "Monster.goblin", 10, 16.5, 5, "male", "L2Monster", 40, 126, 77, 3.16, 0.91, 40, 43, 30, 21, 20, 10, 178, 5, 13, 48, 4, 39, 278, 0, 333, 4, 0, 0, 44, 121, "goblin_clan", 300, 0, 0, "LAST_HIT", 0, 0, 0, "fighter"),
(20328, 20328, "Goblin Lookout", 0, "", 0, "Monster.goblin", 10, 16.5, 8, "male", "L2Monster", 40, 197, 102, 3.16, 0.91, 40, 43, 30, 21, 20, 10, 284, 10, 16, 55, 6, 45, 317, 0, 333, 12, 0, 0, 40, 110, "goblin_clan", 300, 0, 0, "LAST_HIT", 0, 0, 0, "fighter"),
(20329, 20329, "Ghost Guardian", 0, "", 0, "Monster.human_ghost", 8, 22, 21, "male", "L2Monster", 40, 575, 227, 5.53, 1.53, 40, 43, 30, 21, 20, 10, 643, 30, 63, 98, 25, 80, 278, 500, 333, 0, 0, 0, 88, 154, "NULL", 0, 1, 0, "LAST_HIT", 0, 0, 0, "fighter"),
(20330, 20330, "Mineshaft Bat", 0, "", 0, "Monster.vampire_bat", 10, 33.5, 11, "male", "L2Monster", 40, 292, 129, 3.95, 1.21, 40, 43, 30, 21, 20, 10, 326, 12, 27, 58, 9, 52, 278, 0, 333, 0, 0, 0, 66, 88, "NULL", 0, 0, 0, "LAST_HIT", 0, 0, 0, "fighter"),
(20331, 20331, "Monster Eye Tracker", 0, "", 0, "Monster.monster_eye", 21, 43, 10, "male", "L2Monster", 40, 257, 120, 3.16, 0.91, 40, 43, 30, 21, 20, 10, 296, 10, 20, 67, 8, 49, 278, 0, 333, 0, 0, 0, 99, 147, "NULL", 0, 0, 0, "LAST_HIT", 0, 0, 0, "fighter"),
(20333, 20333, "Greystone Golem", 0, "", 0, "Monster.stone_golem", 20, 31, 13, "male", "L2Monster", 40, 339, 147, 3.95, 1.21, 40, 43, 30, 21, 20, 10, 654, 26, 27, 77, 11, 56, 278, 0, 333, 0, 0, 0, 25, 25, "NULL", 0, 0, 0, "LAST_HIT", 0, 0, 0, "fighter"),
(20334, 20334, "Gremlin Scavenger", 0, "", 0, "Monster.gremlin", 10, 15, 1, "male", "L2Monster", 40, 62, 44, 3.16, 0.91, 40, 43, 30, 21, 20, 10, 29, 2, 9, 39, 3, 32, 278, 0, 333, 0, 0, 0, 22, 55, "NULL", 0, 0, 0, "LAST_HIT", 0, 0, 0, "fighter"),
(20335, 20335, "Grizzly Bear", 0, "", 0, "Monster.grizzly_bi", 21, 50, 17, "male", "L2Monster", 40, 446, 184, 3.95, 1.21, 40, 43, 30, 21, 20, 10, 599, 25, 40, 91, 17, 67, 278, 0, 333, 0, 0, 0, 44, 121, "NULL", 0, 0, 0, "LAST_HIT", 0, 0, 0, "fighter"),
(20336, 20336, "Green Dryad", 0, "", 0, "Monster.dryad_sm", 6, 15, 8, "female", "L2Monster", 40, 197, 102, 3.16, 0.91, 40, 43, 30, 21, 20, 10, 284, 10, 18, 55, 6, 45, 278, 0, 333, 0, 0, 0, 44, 121, "NULL", 0, 0, 0, "LAST_HIT", 0, 0, 0, "fighter"),
(20337, 20337, "Longtail Fox", 0, "", 0, "Monster.fox", 9.5, 10, 2, "male", "L2Monster", 40, 75, 52, 3.16, 0.91, 40, 43, 30, 21, 20, 10, 58, 2, 10, 42, 3, 34, 278, 0, 333, 0, 0, 0, 25, 121, "NULL", 0, 0, 0, "LAST_HIT", 0, 0, 0, "fighter"),
(20338, 20338, "Nightmare Weaver", 0, "", 0, "Monster.magical_weaver", 11, 20, 21, "male", "L2Monster", 40, 575, 227, 5.53, 1.53, 40, 43, 30, 21, 20, 10, 707, 33, 69, 89, 25, 80, 278, 500, 333, 0, 0, 0, 99, 99, "NULL", 0, 0, 0, "LAST_HIT", 0, 0, 0, "fighter"),
(20340, 20340, "Slave Skeleton", 0, "", 0, "Monster.skeleton", 11, 25, 12, "male", "L2Monster", 40, 315, 138, 3.95, 1.21, 40, 43, 30, 21, 20, 10, 363, 13, 26, 60, 10, 54, 317, 500, 333, 946, 0, 0, 66, 154, "skeleton_clan", 300, 1, 0, "LAST_HIT", 0, 0, 0, "fighter"),
(20341, 20341, "Undead Slave", 0, "", 0, "Monster.zombie", 13, 21, 19, "male", "L2Monster", 40, 508, 203, 3.95, 1.21, 40, 43, 30, 21, 20, 10, 799, 36, 58, 82, 21, 73, 278, 0, 333, 0, 0, 0, 16, 16, "NULL", 0, 1, 0, "LAST_HIT", 0, 0, 0, "fighter"),
(20342, 20342, "Werewolf Chieftain", 0, "", 0, "Monster.werewolf_bi", 11, 29.7, 12, "male", "L2Monster", 40, 315, 138, 3.95, 1.21, 40, 43, 30, 21, 20, 10, 436, 16, 30, 60, 10, 54, 278, 500, 333, 5, 0, 0, 55, 132, "werewolf_clan", 300, 0, 0, "LAST_HIT", 0, 0, 0, "fighter"),
(20343, 20343, "Werewolf Hunter", 0, "", 0, "Monster.werewolf", 10, 26, 10, "male", "L2Monster", 40, 257, 120, 3.16, 0.91, 40, 43, 30, 21, 20, 10, 363, 12, 25, 55, 8, 49, 278, 500, 333, 5, 0, 0, 55, 132, "werewolf_clan", 300, 0, 0, "LAST_HIT", 0, 0, 0, "fighter"),
(20345, 20345, "Dark Terror", 0, "", 0, "Monster.dark_horror", 20, 35, 16, "male", "L2Monster", 40, 417, 174, 3.95, 1.21, 40, 43, 30, 21, 20, 10, 533, 22, 44, 72, 15, 64, 278, 500, 333, 0, 0, 0, 110, 110, "NULL", 0, 1, 0, "LAST_HIT", 0, 0, 0, "fighter"),
(20346, 20346, "Darkstone Golem", 0, "", 0, "Monster.stone_golem", 20, 31, 13, "male", "L2Monster", 40, 339, 147, 3.95, 1.21, 40, 43, 30, 21, 20, 10, 545, 21, 27, 77, 11, 56, 278, 0, 333, 0, 0, 0, 25, 25, "NULL", 0, 0, 0, "LAST_HIT", 0, 0, 0, "fighter"),
(20347, 20347, "Doom Wraith", 0, "", 0, "Monster.death_blader", 15, 45, 55, "male", "L2Monster", 40, 2643, 987, 10.27, 2.45, 40, 43, 30, 21, 20, 10, 3739, 302, 737, 292, 360, 261, 278, 500, 333, 1472, 0, 0, 110, 191, "undead_clan", 300, 1, 0, "LAST_HIT", 0, 0, 0, "fighter"),
(20348, 20348, "Cave Spider", 0, "", 0, "Monster.giant_spider", 26, 25.5, 15, "male", "L2Monster", 40, 390, 165, 3.95, 1.21, 40, 43, 30, 21, 20, 10, 445, 18, 40, 69, 14, 62, 278, 0, 333, 0, 0, 0, 72, 130, "NULL", 0, 0, 0, "LAST_HIT", 0, 0, 0, "fighter"),
(20349, 20349, "Cave Bat", 0, "", 0, "Monster.vampire_bat", 10, 33.5, 13, "male", "L2Monster", 40, 339, 147, 3.95, 1.21, 40, 43, 30, 21, 20, 10, 385, 15, 33, 63, 11, 56, 278, 0, 333, 0, 0, 0, 66, 88, "NULL", 0, 0, 0, "LAST_HIT", 0, 0, 0, "fighter"),
(20350, 20350, "Cave Fang Spider", 0, "", 0, "Monster.giant_spider", 26, 25.5, 16, "male", "L2Monster", 40, 417, 174, 3.95, 1.21, 40, 43, 30, 21, 20, 10, 485, 20, 44, 72, 15, 64, 278, 500, 333, 0, 0, 0, 72, 130, "NULL", 0, 0, 0, "LAST_HIT", 0, 0, 0, "fighter"),
(20351, 20351, "Dre Vanul Tracker", 0, "", 0, "Monster.dre_vanul", 14, 36, 20, "male", "L2Monster", 40, 541, 213, 3.95, 1.21, 40, 43, 30, 21, 20, 10, 605, 27, 63, 86, 23, 76, 278, 500, 333, 0, 0, 0, 88, 88, "demonic_clan", 300, 0, 0, "LAST_HIT", 0, 0, 0, "fighter"),
(20352, 20352, "Dre Vanul Slayer", 0, "", 0, "Monster.dre_vanul", 14, 36, 22, "male", "L2Monster", 40, 611, 242, 5.53, 1.53, 40, 43, 30, 21, 20, 10, 767, 36, 75, 93, 28, 83, 278, 500, 333, 0, 0, 0, 88, 88, "demonic_clan", 300, 0, 0, "LAST_HIT", 0, 0, 0, "fighter"),
(20353, 20353, "Dre Vanul Beholder", 0, "", 0, "Monster.dre_vanul", 14, 36, 21, "male", "L2Monster", 40, 575, 227, 5.53, 1.53, 40, 43, 30, 21, 20, 10, 649, 30, 69, 89, 25, 80, 278, 500, 333, 0, 0, 0, 88, 88, "demonic_clan", 300, 0, 0, "LAST_HIT", 0, 0, 0, "fighter"),
(20354, 20354, "Dwarf Ghost", 0, "", 0, "Monster.dwarf_ghost", 9, 16.5, 20, "male", "L2Monster", 40, 541, 213, 3.95, 1.21, 40, 43, 30, 21, 20, 10, 605, 27, 63, 86, 23, 76, 278, 500, 333, 0, 0, 0, 88, 154, "ghost_clan", 300, 1, 0, "LAST_HIT", 0, 0, 0, "fighter"),
(20356, 20356, "Langk Lizardman Leader", 0, "", 0, "Monster.virud_lizardman_warrior_bi", 12, 34.5, 25, "male", "L2Monster", 40, 728, 287, 5.53, 1.53, 40, 43, 30, 21, 20, 10, 1012, 51, 80, 127, 37, 94, 278, 500, 333, 16, 0, 0, 57, 143, "lizardman_clan", 300, 0, 0, "LAST_HIT", 0, 0, 0, "fighter"),
(20357, 20357, "Langk Lizardman Lieutenant", 0, "", 0, "Monster.virud_lizardman_warrior", 12, 30, 22, "male", "L2Monster", 40, 611, 242, 5.53, 1.53, 40, 43, 30, 21, 20, 10, 821, 39, 62, 113, 28, 83, 278, 0, 333, 16, 0, 0, 57, 143, "lizardman_clan", 300, 0, 0, "LAST_HIT", 0, 0, 0, "fighter"),
(20358, 20358, "Ratman Hunter", 0, "", 0, "Monster.wererat", 14, 25, 18, "male", "L2Monster", 40, 476, 193, 3.95, 1.21, 40, 43, 30, 21, 20, 10, 640, 28, 38, 95, 19, 70, 317, 0, 333, 11, 0, 0, 88, 132, "wererat_clan", 300, 0, 0, "LAST_HIT", 0, 0, 0, "fighter"),
(20359, 20359, "Ratman Warrior", 0, "", 0, "Monster.wererat", 14, 25, 19, "male", "L2Monster", 40, 508, 203, 3.95, 1.21, 40, 43, 30, 21, 20, 10, 678, 30, 58, 82, 21, 73, 278, 0, 333, 2, 0, 0, 88, 132, "wererat_clan", 300, 0, 0, "LAST_HIT", 0, 0, 0, "fighter"),
(20360, 20360, "Ratman Spy", 0, "", 0, "Monster.wererat_sm", 12, 18.7, 16, "male", "L2Monster", 40, 417, 174, 3.95, 1.21, 40, 43, 30, 21, 20, 10, 570, 23, 39, 72, 15, 64, 317, 0, 333, 12, 0, 0, 88, 132, "wererat_clan", 300, 0, 0, "LAST_HIT", 0, 0, 0, "fighter"),
(20361, 20361, "Tunath Orc Marksman", 0, "", 0, "Monster.orc_archer", 14, 25, 10, "male", "L2Monster", 500, 257, 120, 3.16, 0.91, 40, 43, 30, 21, 20, 10, 305, 10, 51, 61, 8, 49, 249, 0, 333, 14, 0, 0, 49, 121, "orc_clan", 300, 0, 0, "LAST_HIT", 0, 0, 0, "archer"),
(20362, 20362, "Tunath Orc Warrior", 0, "", 0, "Monster.orc_fighter", 12, 22, 12, "male", "L2Monster", 40, 315, 138, 3.95, 1.21, 40, 43, 30, 21, 20, 10, 363, 13, 25, 73, 10, 54, 278, 500, 333, 2, 0, 0, 49, 121, "orc_clan", 300, 0, 0, "LAST_HIT", 0, 0, 0, "fighter"),
(20363, 20363, "Maraku Werewolf", 0, "", 0, "Monster.werewolf", 10, 26, 9, "male", "L2Monster", 40, 226, 111, 3.16, 0.91, 40, 43, 30, 21, 20, 10, 321, 11, 22, 53, 7, 47, 278, 0, 333, 0, 0, 0, 50, 120, "werewolf_clan", 300, 0, 0, "LAST_HIT", 0, 0, 0, "fighter"),
(20364, 20364, "Maraku Werewolf Chieftain", 0, "", 0, "Monster.werewolf_bi", 11, 29.7, 14, "male", "L2Monster", 40, 364, 156, 3.95, 1.21, 40, 43, 30, 21, 20, 10, 508, 20, 32, 66, 12, 59, 317, 500, 333, 217, 0, 0, 55, 132, "werewolf_clan", 300, 0, 0, "LAST_HIT", 0, 0, 0, "fighter"),
(20365, 20365, "Mountain Fungus", 0, "", 0, "Monster.walking_fungus", 15, 22.5, 8, "male", "L2Monster", 40, 197, 102, 3.16, 0.91, 40, 43, 30, 21, 20, 10, 284, 10, 20, 50, 6, 45, 278, 0, 333, 0, 0, 0, 70, 110, "NULL", 0, 0, 0, "LAST_HIT", 0, 0, 0, "fighter"),
(20367, 20367, "Merkenis Escort", 0, "", 0, "Monster.spartoi", 11, 27, 20, "male", "L2Minion", 40, 541, 213, 3.95, 1.21, 40, 43, 30, 21, 20, 10, 605, 27, 52, 104, 23, 76, 278, 500, 333, 68, 0, 0, 60, 140, "skeleton_clan", 300, 1, 0, "LAST_HIT", 0, 0, 0, "fighter"),
(20368, 20368, "Grave Keeper", 0, "", 0, "Monster.stone_golem", 20, 31, 13, "male", "L2Monster", 40, 339, 147, 3.95, 1.21, 40, 43, 30, 21, 20, 10, 545, 21, 27, 77, 11, 56, 278, 0, 333, 0, 0, 0, 25, 25, "NULL", 0, 0, 0, "LAST_HIT", 0, 0, 0, "fighter"),
(20369, 20369, "Moonstone Beast", 0, "", 0, "Monster.onyx_beast", 14, 14.5, 17, "male", "L2Monster", 40, 446, 184, 3.95, 1.21, 40, 43, 30, 21, 20, 10, 599, 25, 48, 75, 17, 67, 278, 0, 333, 0, 0, 0, 33, 132, "NULL", 0, 0, 0, "LAST_HIT", 0, 0, 0, "fighter"),
(20370, 20370, "Barbed Bat", 0, "", 0, "Monster.vampire_bat", 10, 33.5, 12, "male", "L2Monster", 40, 315, 138, 3.95, 1.21, 40, 43, 30, 21, 20, 10, 427, 16, 30, 60, 10, 54, 278, 0, 333, 0, 0, 0, 66, 88, "NULL", 0, 0, 0, "LAST_HIT", 0, 0, 0, "fighter"),
(20371, 20371, "Mist Terror", 0, "", 0, "Monster.dark_horror", 20, 35, 15, "male", "L2Monster", 40, 390, 165, 3.95, 1.21, 40, 43, 30, 21, 20, 10, 454, 19, 40, 69, 14, 62, 278, 500, 333, 0, 0, 0, 110, 110, "NULL", 0, 1, 0, "LAST_HIT", 0, 0, 0, "fighter"),
(20372, 20372, "Baraq Orc Fighter", 0, "", 0, "Monster.orc_fighter", 12, 22, 10, "male", "L2Monster", 40, 257, 120, 3.16, 0.91, 40, 43, 30, 21, 20, 10, 302, 10, 25, 55, 8, 49, 278, 500, 333, 2, 0, 0, 49, 121, "orc_clan", 300, 0, 0, "LAST_HIT", 0, 0, 0, "fighter"),
(20373, 20373, "Baraq Orc Warrior Leader", 0, "", 0, "Monster.orc_fighter", 12, 22, 11, "male", "L2Monster", 40, 292, 129, 3.95, 1.21, 40, 43, 30, 21, 20, 10, 326, 12, 27, 58, 9, 52, 278, 0, 333, 2, 0, 0, 49, 121, "orc_clan", 300, 0, 0, "LAST_HIT", 0, 0, 0, "fighter"),
(20374, 20374, "Baranka's Guard", 0, "", 0, "Monster.spartoi", 11, 27, 22, "male", "L2Monster", 40, 611, 242, 5.53, 1.53, 40, 43, 30, 21, 20, 10, 910, 43, 62, 113, 28, 83, 278, 500, 333, 68, 0, 0, 66, 154, "skeleton_clan", 300, 1, 0, "LAST_HIT", 0, 0, 0, "fighter"),
(20375, 20375, "Baranka's Escort", 0, "", 0, "Monster.spartoi", 11, 27, 21, "male", "L2Monster", 40, 575, 227, 5.53, 1.53, 40, 43, 30, 21, 20, 10, 649, 30, 50, 108, 25, 80, 317, 500, 333, 946, 0, 0, 66, 154, "skeleton_clan", 300, 1, 0, "LAST_HIT", 0, 0, 0, "fighter"),
(20376, 20376, "Varikan Brigand Leader", 0, "", 0, "Monster.goblin_bi", 10, 21.4, 10, "male", "L2Monster", 40, 257, 120, 6.32, 0.91, 40, 43, 30, 21, 20, 10, 503, 17, 22, 61, 8, 49, 278, 500, 333, 12, 0, 0, 44, 121, "goblin_clan", 300, 0, 0, "LAST_HIT", 0, 0, 0, "fighter"),
(20377, 20377, "Varika's Bandit", 0, "", 0, "Monster.goblin", 10, 16.5, 7, "male", "L2Minion", 40, 171, 94, 1.58, 0.91, 40, 43, 30, 21, 20, 10, 334, 12, 20, 44, 6, 43, 278, 0, 333, 0, 0, 0, 44, 121, "goblin_clan", 300, 0, 0, "LAST_HIT", 0, 0, 0, "fighter"),
(20378, 20378, "Stone Giant", 0, "", 0, "Monster.stone_golem", 20, 31, 13, "male", "L2Monster", 40, 339, 147, 3.95, 1.21, 40, 43, 30, 21, 20, 10, 545, 21, 27, 77, 11, 56, 278, 0, 333, 0, 0, 0, 25, 25, "NULL", 0, 0, 0, "LAST_HIT", 0, 0, 0, "fighter"),
(20379, 20379, "Stone Soldier", 0, "", 0, "Monster.stone_golem", 20, 31, 14, "male", "L2Monster", 40, 364, 156, 3.95, 1.21, 40, 43, 30, 21, 20, 10, 705, 27, 30, 80, 12, 59, 278, 0, 333, 0, 0, 0, 23, 23, "NULL", 0, 0, 0, "LAST_HIT", 0, 0, 0, "fighter"),
(20380, 20380, "Stone Guardian", 0, "", 0, "Monster.stone_golem", 20, 31, 16, "male", "L2Monster", 40, 417, 174, 3.95, 1.21, 40, 43, 30, 21, 20, 10, 807, 33, 36, 87, 15, 64, 278, 0, 333, 0, 0, 0, 25, 25, "NULL", 0, 0, 0, "LAST_HIT", 0, 0, 0, "fighter"),
(20381, 20381, "Vaiss Orc", 0, "", 0, "Monster.orc", 10, 21, 10, "male", "L2Monster", 40, 257, 120, 3.16, 0.91, 40, 43, 30, 21, 20, 10, 296, 10, 22, 61, 8, 49, 278, 0, 333, 156, 0, 0, 49, 121, "orc_clan", 300, 0, 0, "LAST_HIT", 0, 0, 0, "fighter"),
(20382, 20382, "Vaiss Orc Warrior Leader", 0, "", 0, "Monster.orc_fighter", 12, 22, 11, "male", "L2Monster", 40, 292, 129, 3.95, 1.21, 40, 43, 30, 21, 20, 10, 326, 12, 27, 58, 9, 52, 278, 0, 333, 2, 0, 0, 49, 121, "orc_clan", 300, 0, 0, "LAST_HIT", 0, 0, 0, "fighter"),
(20383, 20383, "Arachnid Hunter", 0, "", 0, "Monster.binding", 12, 21, 30, "male", "L2Monster", 40, 954, 365, 5.53, 1.53, 40, 43, 30, 21, 20, 10, 1223, 67, 120, 155, 58, 114, 278, 500, 333, 0, 0, 0, 11, 154, "undead_clan", 300, 1, 0, "LAST_HIT", 0, 0, 0, "fighter"),
(20385, 20385, "Balor Orc Archer", 0, "", 0, "Monster.orc_archer", 14, 25, 8, "male", "L2Monster", 500, 197, 102, 3.16, 0.91, 40, 43, 30, 21, 20, 10, 293, 10, 41, 55, 6, 45, 247, 0, 333, 14, 0, 0, 45, 110, "orc_clan", 300, 0, 0, "LAST_HIT", 0, 0, 0, "archer"),
(20386, 20386, "Balor Orc Fighter", 0, "", 0, "Monster.orc_fighter", 12, 22, 10, "male", "L2Monster", 40, 257, 120, 3.16, 0.91, 40, 43, 30, 21, 20, 10, 363, 12, 25, 55, 8, 49, 278, 500, 333, 2, 0, 0, 45, 110, "orc_clan", 300, 0, 0, "LAST_HIT", 0, 0, 0, "fighter"),
(20387, 20387, "Balor Orc Fighter Leader", 0, "", 0, "Monster.orc_fighter", 12, 22, 12, "male", "L2Monster", 40, 315, 138, 3.95, 1.21, 40, 43, 30, 21, 20, 10, 436, 16, 30, 60, 10, 54, 278, 500, 333, 2, 0, 0, 45, 110, "orc_clan", 300, 0, 0, "LAST_HIT", 0, 0, 0, "fighter"),
(20388, 20388, "Balor Orc Lieutenant", 0, "", 0, "Monster.orc_fighter", 12, 22, 11, "male", "L2Monster", 40, 292, 129, 3.95, 1.21, 40, 43, 30, 21, 20, 10, 391, 15, 27, 58, 9, 52, 278, 0, 333, 2, 0, 0, 45, 110, "orc_clan", 300, 0, 0, "LAST_HIT", 0, 0, 0, "fighter"),
(20389, 20389, "Boogle Ratman", 0, "", 0, "Monster.wererat", 14, 25, 16, "male", "L2Monster", 40, 417, 174, 3.95, 1.21, 40, 43, 30, 21, 20, 10, 475, 19, 39, 72, 15, 64, 317, 0, 333, 12, 0, 0, 88, 132, "wererat_clan", 300, 0, 0, "LAST_HIT", 0, 0, 0, "fighter"),
(20390, 20390, "Boogle Ratman Leader", 0, "", 0, "Monster.wererat", 14, 25, 18, "male", "L2Monster", 40, 476, 193, 3.95, 1.21, 40, 43, 30, 21, 20, 10, 533, 23, 46, 79, 19, 70, 317, 0, 333, 12, 0, 0, 88, 132, "wererat_clan", 300, 0, 0, "LAST_HIT", 0, 0, 0, "fighter"),
(20391, 20391, "Red Fox", 0, "", 0, "Monster.fox", 9.5, 10, 2, "male", "L2Monster", 40, 75, 52, 3.16, 0.91, 40, 43, 30, 21, 20, 10, 58, 2, 10, 42, 3, 34, 278, 0, 333, 0, 0, 0, 25, 121, "NULL", 0, 0, 0, "LAST_HIT", 0, 0, 0, "fighter"),
(20392, 20392, "Redeye Bat", 0, "", 0, "Monster.vampire_bat_bi", 10, 42, 15, "male", "L2Monster", 40, 390, 165, 3.95, 1.21, 40, 43, 30, 21, 20, 10, 534, 22, 40, 69, 14, 62, 278, 0, 333, 0, 0, 0, 66, 88, "NULL", 0, 0, 0, "LAST_HIT", 0, 0, 0, "fighter"),
(20393, 20393, "Red Scavenger Spider", 0, "", 0, "Monster.giant_spider", 26, 25.5, 16, "male", "L2Monster", 40, 417, 174, 3.95, 1.21, 40, 43, 30, 21, 20, 10, 570, 23, 44, 72, 15, 64, 278, 0, 333, 0, 0, 0, 79, 143, "NULL", 0, 0, 0, "LAST_HIT", 0, 0, 0, "fighter"),
(20394, 20394, "Crimson Tarantula", 0, "", 0, "Monster.giant_spider", 26, 25.5, 15, "male", "L2Monster", 40, 390, 165, 3.95, 1.21, 40, 43, 30, 21, 20, 10, 449, 18, 40, 69, 14, 62, 278, 500, 333, 0, 0, 0, 79, 143, "NULL", 0, 0, 0, "LAST_HIT", 0, 0, 0, "fighter"),
(20398, 20398, "Vrykolakas", 0, "", 0, "Monster.werewolf_bi", 11, 29.7, 15, "male", "L2Monster", 40, 390, 165, 7.9, 1.21, 40, 43, 30, 21, 20, 10, 692, 28, 40, 69, 14, 62, 278, 500, 333, 0, 0, 0, 55, 132, "werewolf_clan", 300, 0, 0, "LAST_HIT", 0, 0, 0, "fighter"),
(20399, 20399, "Vrykolakas Wolfkin", 0, "", 0, "Monster.wolf_bi", 13, 10.8, 9, "male", "L2Minion", 40, 226, 111, 1.58, 0.91, 40, 43, 30, 21, 20, 10, 354, 12, 25, 48, 7, 47, 278, 0, 333, 0, 0, 0, 26, 121, "NULL", 0, 0, 0, "LAST_HIT", 0, 0, 0, "fighter"),
(20400, 20400, "Blood Fungus", 0, "", 0, "Monster.walking_fungus", 15, 22.5, 12, "male", "L2Monster", 40, 315, 138, 3.95, 1.21, 40, 43, 30, 21, 20, 10, 427, 16, 30, 60, 10, 54, 278, 0, 333, 0, 0, 0, 70, 110, "NULL", 0, 0, 0, "LAST_HIT", 0, 0, 0, "fighter"),
(20401, 20401, "Veelan Bugbear", 0, "", 0, "Monster.bugbear", 17, 35, 23, "male", "L2Monster", 40, 648, 257, 5.53, 1.53, 40, 43, 30, 21, 20, 10, 878, 42, 68, 117, 31, 87, 278, 0, 333, 156, 0, 0, 60, 143, "bugbear_clan", 300, 0, 0, "LAST_HIT", 0, 0, 0, "fighter"),
(20402, 20402, "Veelan Bugbear Warrior", 0, "", 0, "Monster.bugbear", 17, 35, 24, "male", "L2Monster", 40, 687, 272, 5.53, 1.53, 40, 43, 30, 21, 20, 10, 954, 47, 89, 101, 34, 90, 278, 500, 333, 88, 0, 0, 60, 143, "bugbear_clan", 300, 0, 0, "LAST_HIT", 0, 0, 0, "fighter"),
(20403, 20403, "Hunter Tarantula", 0, "", 0, "Monster.giant_spider", 26, 25.5, 16, "male", "L2Monster", 40, 417, 174, 3.95, 1.21, 40, 43, 30, 21, 20, 10, 570, 23, 44, 72, 15, 64, 278, 0, 333, 0, 0, 0, 79, 143, "NULL", 0, 0, 0, "LAST_HIT", 0, 0, 0, "fighter"),
(20404, 20404, "Silent Horror", 0, "", 0, "Monster.dark_horror", 20, 35, 16, "male", "L2Monster", 40, 417, 174, 3.95, 1.21, 40, 43, 30, 21, 20, 10, 485, 20, 44, 72, 15, 64, 278, 500, 333, 0, 0, 0, 110, 110, "NULL", 0, 1, 0, "LAST_HIT", 0, 0, 0, "fighter"),
(20405, 20405, "Young Brown Fox", 0, "", 0, "Monster.fox", 9.5, 10, 1, "male", "L2Monster", 40, 62, 44, 3.16, 0.91, 40, 43, 30, 21, 20, 10, 29, 2, 10, 36, 3, 32, 278, 0, 333, 0, 0, 0, 25, 121, "NULL", 0, 0, 0, "LAST_HIT", 0, 0, 0, "fighter"),
(20406, 20406, "Young Red Fox", 0, "", 0, "Monster.fox", 9.5, 10, 1, "male", "L2Monster", 40, 62, 44, 3.16, 0.91, 40, 43, 30, 21, 20, 10, 29, 2, 10, 36, 3, 32, 278, 0, 333, 0, 0, 0, 25, 121, "NULL", 0, 0, 0, "LAST_HIT", 0, 0, 0, "fighter"),
(20407, 20407, "Young Crimson Fox", 0, "", 0, "Monster.fox", 9.5, 10, 1, "male", "L2Monster", 40, 62, 44, 3.16, 0.91, 40, 43, 30, 21, 20, 10, 29, 2, 10, 36, 3, 32, 278, 0, 333, 0, 0, 0, 25, 121, "NULL", 0, 0, 0, "LAST_HIT", 0, 0, 0, "fighter"),
(20410, 20410, "Scavenger Spider", 0, "", 0, "Monster.giant_spider", 26, 25.5, 15, "male", "L2Monster", 40, 390, 165, 3.95, 1.21, 40, 43, 30, 21, 20, 10, 545, 22, 40, 69, 14, 62, 278, 500, 333, 0, 0, 0, 79, 143, "NULL", 0, 0, 0, "LAST_HIT", 0, 0, 0, "fighter"),
(20411, 20411, "Scavenger Bat", 0, "", 0, "Monster.vampire_bat", 10, 33.5, 18, "male", "L2Monster", 40, 476, 193, 3.95, 1.21, 40, 43, 30, 21, 20, 10, 640, 28, 53, 79, 19, 70, 278, 0, 333, 0, 0, 0, 66, 88, "NULL", 0, 0, 0, "LAST_HIT", 0, 0, 0, "fighter"),
(20412, 20412, "Susceptor", 0, "", 0, "Monster.susceptor", 20, 35, 49, "male", "L2Monster", 40, 2168, 799, 8.69, 2.14, 40, 43, 30, 21, 20, 10, 2910, 215, 437, 297, 247, 219, 278, 500, 333, 0, 0, 0, 29, 191, "NULL", 0, 0, 0, "LAST_HIT", 0, 0, 0, "fighter"),
(20415, 20415, "Scarlet Salamander", 0, "", 0, "Monster.salamander", 16, 6.8, 17, "male", "L2Monster", 40, 446, 184, 3.95, 1.21, 40, 43, 30, 21, 20, 10, 555, 23, 48, 75, 17, 67, 278, 0, 333, 0, 0, 0, 70, 105, "elemental3_clan", 300, 0, 0, "LAST_HIT", 0, 0, 0, "fighter"),
(20416, 20416, "Scarlet Salamander Elder", 0, "", 0, "Monster.salamander", 16, 6.8, 18, "male", "L2Monster", 40, 476, 193, 3.95, 1.21, 40, 43, 30, 21, 20, 10, 586, 26, 53, 79, 19, 70, 278, 0, 333, 0, 0, 0, 70, 105, "elemental3_clan", 300, 0, 0, "LAST_HIT", 0, 0, 0, "fighter"),
(20418, 20418, "Crystalline Beast", 0, "", 0, "Monster.onyx_beast", 14, 14.5, 18, "male", "L2Monster", 40, 476, 193, 3.95, 1.21, 40, 43, 30, 21, 20, 10, 633, 28, 53, 79, 19, 70, 278, 0, 333, 0, 0, 0, 33, 132, "NULL", 0, 0, 0, "LAST_HIT", 0, 0, 0, "fighter"),
(20419, 20419, "Akaste Succubus", 0, "", 0, "Monster.succubus", 10, 36, 20, "female", "L2Monster", 40, 541, 213, 3.95, 1.21, 40, 43, 30, 21, 20, 10, 605, 27, 63, 86, 23, 76, 278, 500, 333, 0, 0, 0, 66, 110, "succubus_clan", 300, 0, 0, "LAST_HIT", 0, 0, 0, "fighter"),
(20420, 20420, "Akaste Succubus Turen", 0, "", 0, "Monster.succubus", 10, 36, 21, "female", "L2Monster", 40, 575, 227, 5.53, 1.53, 40, 43, 30, 21, 20, 10, 649, 30, 69, 89, 25, 80, 278, 500, 333, 0, 0, 0, 66, 110, "succubus_clan", 300, 0, 0, "LAST_HIT", 0, 0, 0, "fighter"),
(20421, 20421, "Akaste Succubus Tilfo", 0, "", 0, "Monster.succubus_bi", 10, 43.2, 22, "female", "L2Monster", 40, 611, 242, 5.53, 1.53, 40, 43, 30, 21, 20, 10, 698, 33, 75, 93, 28, 83, 278, 500, 333, 0, 0, 0, 66, 110, "succubus_clan", 300, 0, 0, "LAST_HIT", 0, 0, 0, "fighter"),
(20422, 20422, "Akaste Bone Warlord", 0, "", 0, "Monster.skeleton", 11, 25, 17, "male", "L2Monster", 40, 446, 184, 3.95, 1.21, 40, 43, 30, 21, 20, 10, 612, 26, 48, 75, 17, 67, 278, 500, 333, 2, 18, 0, 66, 154, "skeleton_clan", 300, 1, 0, "LAST_HIT", 0, 0, 0, "fighter"),
(20423, 20423, "Akaste Bone Archer", 0, "", 0, "Monster.skeleton_archer", 11, 27, 14, "male", "L2Monster", 500, 364, 156, 3.95, 1.21, 40, 43, 30, 21, 20, 10, 428, 17, 68, 80, 12, 59, 249, 0, 333, 275, 0, 0, 44, 154, "skeleton_clan", 300, 1, 0, "LAST_HIT", 0, 0, 0, "archer"),
(20424, 20424, "Akaste Bone Lord", 0, "", 0, "Monster.skeleton", 11, 25, 19, "male", "L2Monster", 40, 508, 203, 3.95, 1.21, 40, 43, 30, 21, 20, 10, 592, 26, 58, 82, 21, 73, 278, 500, 333, 68, 19, 0, 66, 154, "skeleton_clan", 300, 1, 0, "LAST_HIT", 0, 0, 0, "fighter"),
(20425, 20425, "Akaste Bone Soldier", 0, "", 0, "Monster.skeleton", 11, 25, 12, "male", "L2Monster", 40, 315, 138, 3.95, 1.21, 40, 43, 30, 21, 20, 10, 363, 13, 26, 60, 10, 54, 317, 500, 333, 946, 0, 0, 66, 154, "skeleton_clan", 300, 1, 0, "LAST_HIT", 0, 0, 0, "fighter"),
(20426, 20426, "Evil Eye", 0, "", 0, "Monster.monster_eye", 21, 43, 10, "male", "L2Monster", 40, 257, 120, 3.16, 0.91, 40, 43, 30, 21, 20, 10, 356, 12, 20, 67, 8, 49, 278, 0, 333, 0, 0, 0, 90, 134, "NULL", 0, 0, 0, "LAST_HIT", 0, 0, 0, "fighter"),
(20427, 20427, "Evil Eye Watcher", 0, "", 0, "Monster.monster_eye", 21, 43, 10, "male", "L2Monster", 40, 257, 120, 3.16, 0.91, 40, 43, 30, 21, 20, 10, 296, 10, 20, 67, 8, 49, 278, 0, 333, 0, 0, 0, 99, 147, "NULL", 0, 0, 0, "LAST_HIT", 0, 0, 0, "fighter"),
(20428, 20428, "Evil Eye Patroller", 0, "", 0, "Monster.monster_eye", 21, 43, 14, "male", "L2Monster", 40, 364, 156, 3.95, 1.21, 40, 43, 30, 21, 20, 10, 498, 19, 30, 80, 12, 59, 278, 0, 333, 0, 0, 0, 99, 147, "NULL", 0, 0, 0, "LAST_HIT", 0, 0, 0, "fighter"),
(20429, 20429, "Evil Eye Lookout", 0, "", 0, "Monster.monster_eye", 21, 43, 14, "male", "L2Monster", 40, 364, 156, 3.95, 1.21, 40, 43, 30, 21, 20, 10, 415, 16, 30, 80, 12, 59, 278, 0, 333, 0, 0, 0, 99, 147, "NULL", 0, 0, 0, "LAST_HIT", 0, 0, 0, "fighter"),
(20431, 20431, "Elf Ghost", 0, "", 0, "Monster.elf_ghost", 7, 21, 20, "male", "L2Monster", 40, 541, 213, 3.95, 1.21, 40, 43, 30, 21, 20, 10, 605, 27, 52, 104, 23, 76, 278, 500, 333, 0, 0, 0, 88, 154, "NULL", 0, 1, 0, "LAST_HIT", 0, 0, 0, "fighter"),
(20432, 20432, "Elpy", 0, "", 0, "Monster.elpy", 5, 4, 1, "male", "L2Monster", 40, 62, 44, 3.16, 0.91, 40, 43, 30, 21, 20, 10, 35, 2, 9, 39, 3, 32, 278, 0, 333, 0, 0, 0, 55, 88, "NULL", 0, 0, 0, "LAST_HIT", 0, 0, 0, "fighter"),
(20433, 20433, "Festering Bat", 0, "", 0, "Monster.vampire_bat", 10, 33.5, 13, "male", "L2Monster", 40, 339, 147, 3.95, 1.21, 40, 43, 30, 21, 20, 10, 462, 18, 33, 63, 11, 56, 278, 0, 333, 0, 0, 0, 60, 80, "NULL", 0, 0, 0, "LAST_HIT", 0, 0, 0, "fighter"),
(20435, 20435, "Opal Beast", 0, "", 0, "Monster.onyx_beast", 14, 14.5, 15, "male", "L2Monster", 40, 390, 165, 3.95, 1.21, 40, 43, 30, 21, 20, 10, 449, 18, 40, 69, 14, 62, 278, 500, 333, 0, 0, 0, 33, 132, "NULL", 0, 0, 0, "LAST_HIT", 0, 0, 0, "fighter"),
(20436, 20436, "Ol Mahum Supplier", 0, "", 0, "Monster.ol_mahum_bi", 14, 29.2, 23, "male", "L2Monster", 40, 648, 257, 5.53, 1.53, 40, 43, 30, 21, 20, 10, 878, 42, 68, 117, 31, 87, 278, 0, 333, 2, 19, 0, 50, 110, "ol_mahum_clan", 300, 0, 0, "LAST_HIT", 0, 0, 0, "fighter"),
(20437, 20437, "Ol Mahum Recruit", 0, "", 0, "Monster.ol_mahum", 13.5, 25, 21, "male", "L2Monster", 40, 575, 227, 5.53, 1.53, 40, 43, 30, 21, 20, 10, 764, 35, 57, 108, 25, 80, 278, 0, 333, 68, 19, 0, 50, 110, "ol_mahum_clan", 300, 0, 0, "LAST_HIT", 0, 0, 0, "fighter"),
(20438, 20438, "Ol Mahum General", 0, "", 0, "Monster.ol_mahum_champion", 14, 27, 26, "male", "L2Monster", 40, 770, 303, 5.53, 1.53, 40, 43, 30, 21, 20, 10, 1078, 54, 105, 109, 41, 98, 278, 500, 333, 67, 102, 0, 50, 110, "ol_mahum_clan", 300, 0, 0, "LAST_HIT", 0, 0, 0, "fighter"),
(20439, 20439, "Ol Mahum Officer", 0, "", 0, "Monster.ol_mahum", 13.5, 25, 24, "male", "L2Monster", 40, 687, 272, 5.53, 1.53, 40, 43, 30, 21, 20, 10, 935, 46, 74, 122, 34, 90, 278, 0, 333, 66, 0, 0, 50, 110, "ol_mahum_clan", 300, 0, 0, "LAST_HIT", 0, 0, 0, "fighter"),
(20440, 20440, "Elder Brown Fox", 0, "", 0, "Monster.fox", 9.5, 10, 3, "male", "L2Monster", 40, 90, 60, 3.16, 0.91, 40, 43, 30, 21, 20, 10, 88, 2, 12, 40, 3, 35, 278, 0, 333, 0, 0, 0, 25, 121, "NULL", 0, 0, 0, "LAST_HIT", 0, 0, 0, "fighter"),
(20441, 20441, "Elder Longtail Fox", 0, "", 0, "Monster.fox", 9.5, 10, 3, "male", "L2Monster", 40, 90, 60, 3.16, 0.91, 40, 43, 30, 21, 20, 10, 88, 2, 12, 40, 3, 35, 278, 0, 333, 0, 0, 0, 25, 121, "NULL", 0, 0, 0, "LAST_HIT", 0, 0, 0, "fighter"),
(20442, 20442, "Elder Wolf", 0, "", 0, "Monster.wolf", 13, 9, 5, "male", "L2Monster", 40, 126, 77, 3.16, 0.91, 40, 43, 30, 21, 20, 10, 176, 5, 13, 48, 4, 39, 278, 0, 333, 0, 0, 0, 24, 110, "NULL", 0, 0, 0, "LAST_HIT", 0, 0, 0, "fighter"),
(20443, 20443, "Elder Red Fox", 0, "", 0, "Monster.fox", 9.5, 10, 3, "male", "L2Monster", 40, 90, 60, 3.16, 0.91, 40, 43, 30, 21, 20, 10, 88, 2, 12, 40, 3, 35, 278, 0, 333, 0, 0, 0, 25, 121, "NULL", 0, 0, 0, "LAST_HIT", 0, 0, 0, "fighter"),
(20444, 20444, "Elder Prairie Fox", 0, "", 0, "Monster.fox", 9.5, 10, 3, "male", "L2Monster", 40, 90, 60, 3.16, 0.91, 40, 43, 30, 21, 20, 10, 88, 2, 12, 40, 3, 35, 278, 0, 333, 0, 0, 0, 25, 121, "NULL", 0, 0, 0, "LAST_HIT", 0, 0, 0, "fighter"),
(20445, 20445, "Uthanka Pirate", 0, "", 0, "Monster.orc", 10, 21, 7, "male", "L2Minion", 40, 171, 94, 1.58, 0.91, 40, 43, 30, 21, 20, 10, 307, 10, 20, 44, 6, 43, 278, 0, 333, 3, 0, 0, 49, 121, "orc_clan", 300, 0, 0, "LAST_HIT", 0, 0, 0, "fighter"),
(20446, 20446, "Utuku Orc", 0, "", 0, "Monster.orc", 10, 21, 6, "male", "L2Monster", 40, 147, 85, 3.16, 0.91, 40, 43, 30, 21, 20, 10, 213, 6, 15, 50, 5, 41, 278, 0, 333, 156, 0, 0, 49, 121, "orc_clan", 300, 0, 0, "LAST_HIT", 0, 0, 0, "fighter"),
(20447, 20447, "Utuku Orc Archer", 0, "", 0, "Monster.orc_archer", 14, 25, 8, "male", "L2Monster", 500, 197, 102, 3.16, 0.91, 40, 43, 30, 21, 20, 10, 293, 10, 41, 55, 6, 45, 249, 0, 333, 14, 0, 0, 49, 121, "orc_clan", 300, 0, 0, "LAST_HIT", 0, 0, 0, "archer"),
(20448, 20448, "Utuku Orc Grunt", 0, "", 0, "Monster.orc", 10, 21, 7, "male", "L2Monster", 40, 171, 94, 3.16, 0.91, 40, 43, 30, 21, 20, 10, 249, 8, 17, 53, 6, 43, 278, 0, 333, 3, 0, 0, 49, 121, "orc_clan", 300, 0, 0, "LAST_HIT", 0, 0, 0, "fighter"),
(20449, 20449, "Will-O-Wisp", 0, "", 0, "Monster.will_o_wisp", 13, 22, 15, "male", "L2Monster", 40, 390, 165, 3.95, 1.21, 40, 43, 30, 21, 20, 10, 533, 22, 40, 69, 14, 62, 278, 0, 333, 0, 0, 0, 88, 154, "NULL", 0, 0, 0, "LAST_HIT", 0, 0, 0, "fighter"),
(20450, 20450, "Relic Werewolf", 0, "", 0, "Monster.werewolf", 10, 26, 9, "male", "L2Monster", 40, 226, 111, 3.16, 0.91, 40, 43, 30, 21, 20, 10, 267, 9, 22, 53, 7, 47, 278, 0, 333, 0, 0, 0, 55, 132, "werewolf_clan", 300, 0, 0, "LAST_HIT", 0, 0, 0, "fighter"),
(20451, 20451, "Relic Spartoi", 0, "", 0, "Monster.spartoi", 11, 27, 21, "male", "L2Monster", 40, 575, 227, 11.06, 1.53, 40, 43, 30, 21, 20, 10, 592, 27, 57, 108, 25, 80, 278, 0, 333, 68, 0, 0, 66, 154, "skeleton_clan", 300, 1, 0, "LAST_HIT", 0, 0, 0, "fighter"),
(20453, 20453, "Human Ghost", 0, "", 0, "Monster.human_ghost", 8, 22, 20, "male", "L2Monster", 40, 541, 213, 3.95, 1.21, 40, 43, 30, 21, 20, 10, 605, 27, 52, 104, 23, 76, 278, 500, 333, 0, 0, 0, 88, 154, "ghost_clan", 300, 1, 0, "LAST_HIT", 0, 0, 0, "fighter"),
(20454, 20454, "Oblivion Watcher", 0, "", 0, "Monster.monster_eye", 21, 43, 17, "male", "L2Minion", 40, 446, 184, 1.98, 1.21, 40, 43, 30, 21, 20, 10, 454, 20, 53, 68, 17, 67, 278, 0, 333, 0, 0, 0, 99, 99, "NULL", 0, 0, 0, "LAST_HIT", 0, 0, 0, "fighter"),
(20455, 20455, "Doom Soldier", 0, "", 0, "Monster.skeleton", 11, 25, 14, "male", "L2Monster", 40, 364, 156, 3.95, 1.21, 40, 43, 30, 21, 20, 10, 424, 16, 32, 66, 12, 59, 317, 500, 333, 946, 0, 0, 60, 140, "skeleton_clan", 300, 1, 0, "LAST_HIT", 0, 0, 0, "fighter"),
(20456, 20456, "Ashen Wolf", 0, "", 0, "Monster.wolf", 13, 9, 4, "male", "L2Monster", 40, 107, 68, 3.16, 0.91, 40, 43, 30, 21, 20, 10, 141, 4, 12, 46, 4, 37, 278, 0, 333, 0, 0, 0, 24, 110, "NULL", 0, 0, 0, "LAST_HIT", 0, 0, 0, "fighter"),
(20457, 20457, "Zombie Soldier", 0, "", 0, "Monster.zombie", 13, 21, 19, "male", "L2Monster", 40, 508, 203, 3.95, 1.21, 40, 43, 30, 21, 20, 10, 958, 43, 58, 82, 21, 73, 278, 0, 333, 0, 0, 0, 16, 16, "NULL", 0, 1, 0, "LAST_HIT", 0, 0, 0, "fighter"),
(20458, 20458, "Zombie Warrior", 0, "", 0, "Monster.zombie_bi", 12, 27.5, 22, "male", "L2Monster", 40, 611, 242, 5.53, 1.53, 40, 43, 30, 21, 20, 10, 1184, 56, 75, 93, 28, 83, 278, 500, 333, 0, 0, 0, 16, 16, "NULL", 0, 1, 0, "LAST_HIT", 0, 0, 0, "fighter"),
(20460, 20460, "Crimson Spider", 0, "", 0, "Monster.giant_spider", 26, 25.5, 15, "male", "L2Monster", 40, 390, 165, 3.95, 1.21, 40, 43, 30, 21, 20, 10, 545, 22, 40, 69, 14, 62, 278, 500, 333, 0, 0, 0, 79, 143, "NULL", 0, 0, 0, "LAST_HIT", 0, 0, 0, "fighter"),
(20461, 20461, "Dungeon Spider", 0, "", 0, "Monster.giant_spider", 26, 25.5, 15, "male", "L2Monster", 40, 390, 165, 3.95, 1.21, 40, 43, 30, 21, 20, 10, 454, 19, 40, 69, 14, 62, 278, 500, 333, 0, 0, 0, 79, 143, "NULL", 0, 0, 0, "LAST_HIT", 0, 0, 0, "fighter"),
(20462, 20462, "Cave Blade Spider", 0, "", 0, "Monster.giant_spider", 26, 25.5, 17, "male", "L2Monster", 40, 446, 184, 3.95, 1.21, 40, 43, 30, 21, 20, 10, 515, 22, 48, 75, 17, 67, 278, 500, 333, 0, 0, 0, 79, 143, "NULL", 0, 0, 0, "LAST_HIT", 0, 0, 0, "fighter"),
(20463, 20463, "Dungeon Skeleton Archer", 0, "", 0, "Monster.skeleton_archer", 11, 27, 13, "male", "L2Monster", 500, 339, 147, 3.95, 1.21, 40, 43, 30, 21, 20, 10, 397, 16, 61, 77, 11, 56, 249, 0, 333, 275, 0, 0, 44, 154, "skeleton_clan", 300, 1, 0, "LAST_HIT", 0, 0, 0, "archer"),
(20464, 20464, "Dungeon Skeleton", 0, "", 0, "Monster.skeleton", 11, 25, 12, "male", "L2Monster", 40, 315, 138, 3.95, 1.21, 40, 43, 30, 21, 20, 10, 363, 13, 26, 60, 10, 54, 317, 500, 333, 946, 0, 0, 66, 154, "skeleton_clan", 300, 1, 0, "LAST_HIT", 0, 0, 0, "fighter"),
(20465, 20465, "Prairie Fox", 0, "", 0, "Monster.fox", 9.5, 10, 2, "male", "L2Monster", 40, 75, 52, 3.16, 0.91, 40, 43, 30, 21, 20, 10, 58, 2, 11, 38, 3, 34, 278, 0, 333, 0, 0, 0, 25, 121, "NULL", 0, 0, 0, "LAST_HIT", 0, 0, 0, "fighter"),
(20466, 20466, "Pincer Spider", 0, "", 0, "Monster.giant_spider", 26, 25.5, 17, "male", "L2Monster", 40, 446, 184, 3.95, 1.21, 40, 43, 30, 21, 20, 10, 618, 26, 48, 75, 17, 67, 278, 500, 333, 0, 0, 0, 79, 143, "NULL", 0, 0, 0, "LAST_HIT", 0, 0, 0, "fighter"),
(20468, 20468, "Kaboo Orc", 0, "", 0, "Monster.orc", 10, 21, 6, "male", "L2Monster", 40, 147, 85, 3.16, 0.91, 40, 43, 30, 21, 20, 10, 213, 6, 15, 50, 5, 41, 278, 0, 333, 156, 0, 0, 49, 121, "orc_clan", 300, 0, 0, "LAST_HIT", 0, 0, 0, "fighter"),
(20469, 20469, "Kaboo Orc Archer", 0, "", 0, "Monster.orc_archer", 14, 25, 8, "male", "L2Monster", 500, 197, 102, 3.16, 0.91, 40, 43, 30, 21, 20, 10, 293, 10, 41, 55, 6, 45, 247, 0, 333, 14, 0, 0, 45, 110, "orc_clan", 300, 0, 0, "LAST_HIT", 0, 0, 0, "archer"),
(20470, 20470, "Kaboo Orc Grunt", 0, "", 0, "Monster.orc", 10, 21, 7, "male", "L2Monster", 40, 171, 94, 3.16, 0.91, 40, 43, 30, 21, 20, 10, 249, 8, 17, 53, 6, 43, 278, 0, 333, 3, 0, 0, 45, 110, "orc_clan", 300, 0, 0, "LAST_HIT", 0, 0, 0, "fighter"),
(20471, 20471, "Kaboo Orc Fighter", 0, "", 0, "Monster.orc_fighter", 12, 22, 10, "male", "L2Monster", 40, 257, 120, 3.16, 0.91, 40, 43, 30, 21, 20, 10, 363, 12, 20, 67, 8, 49, 278, 500, 333, 2, 0, 0, 49, 121, "orc_clan", 300, 0, 0, "LAST_HIT", 0, 0, 0, "fighter"),
(20472, 20472, "Kaboo Orc Fighter Leader", 0, "", 0, "Monster.orc_fighter", 12, 22, 12, "male", "L2Monster", 40, 315, 138, 3.95, 1.21, 40, 43, 30, 21, 20, 10, 436, 16, 25, 73, 10, 54, 278, 500, 333, 2, 0, 0, 49, 121, "orc_clan", 300, 0, 0, "LAST_HIT", 0, 0, 0, "fighter"),
(20473, 20473, "Kaboo Orc Fighter Lieutenant", 0, "", 0, "Monster.orc_fighter", 12, 22, 11, "male", "L2Monster", 40, 292, 129, 3.95, 1.21, 40, 43, 30, 21, 20, 10, 391, 15, 23, 70, 9, 52, 278, 0, 333, 2, 0, 0, 49, 121, "orc_clan", 300, 0, 0, "LAST_HIT", 0, 0, 0, "fighter"),
(20474, 20474, "Kasha Spider", 0, "", 0, "Monster.giant_spider", 26, 25.5, 15, "male", "L2Monster", 40, 390, 165, 3.95, 1.21, 40, 43, 30, 21, 20, 10, 534, 22, 40, 69, 14, 62, 278, 0, 333, 0, 0, 0, 79, 143, "NULL", 0, 0, 0, "LAST_HIT", 0, 0, 0, "fighter"),
(20475, 20475, "Kasha Wolf", 0, "", 0, "Monster.wolf", 13, 9, 4, "male", "L2Monster", 40, 107, 68, 3.16, 0.91, 40, 43, 30, 21, 20, 10, 141, 4, 12, 46, 4, 37, 278, 0, 333, 0, 0, 0, 24, 110, "NULL", 0, 0, 0, "LAST_HIT", 0, 0, 0, "fighter"),
(20476, 20476, "Kasha Fang Spider", 0, "", 0, "Monster.giant_spider", 26, 25.5, 16, "male", "L2Monster", 40, 417, 174, 3.95, 1.21, 40, 43, 30, 21, 20, 10, 570, 23, 44, 72, 15, 64, 278, 0, 333, 0, 0, 0, 79, 143, "NULL", 0, 0, 0, "LAST_HIT", 0, 0, 0, "fighter"),
(20477, 20477, "Kasha Timber Wolf", 0, "", 0, "Monster.wolf_bi", 13, 10.8, 6, "male", "L2Monster", 40, 147, 85, 3.16, 0.91, 40, 43, 30, 21, 20, 10, 211, 6, 15, 50, 5, 41, 278, 0, 333, 0, 0, 0, 24, 110, "NULL", 0, 0, 0, "LAST_HIT", 0, 0, 0, "fighter"),
(20478, 20478, "Kasha Blade Spider", 0, "", 0, "Monster.giant_spider", 26, 25.5, 17, "male", "L2Monster", 40, 446, 184, 3.95, 1.21, 40, 43, 30, 21, 20, 10, 666, 28, 48, 75, 17, 67, 278, 0, 333, 0, 0, 0, 79, 143, "NULL", 0, 0, 0, "LAST_HIT", 0, 0, 0, "fighter"),
(20479, 20479, "Kasha Bear", 0, "", 0, "Monster.grizzly_bi", 21, 50, 15, "male", "L2Monster", 40, 390, 165, 3.95, 1.21, 40, 43, 30, 21, 20, 10, 539, 22, 33, 84, 14, 62, 278, 500, 333, 0, 0, 0, 44, 121, "NULL", 0, 0, 0, "LAST_HIT", 0, 0, 0, "fighter"),
(20480, 20480, "Blade Bat", 0, "", 0, "Monster.vampire_bat", 10, 33.5, 10, "male", "L2Monster", 40, 257, 120, 3.16, 0.91, 40, 43, 30, 21, 20, 10, 356, 12, 25, 55, 8, 49, 278, 0, 333, 0, 0, 0, 66, 88, "NULL", 0, 0, 0, "LAST_HIT", 0, 0, 0, "fighter"),
(20481, 20481, "Bearded Keltir", 0, "", 0, "Monster.keltir", 9.5, 10, 1, "male", "L2Monster", 40, 62, 44, 3.16, 0.91, 40, 43, 30, 21, 20, 10, 35, 2, 9, 39, 3, 32, 278, 0, 333, 0, 0, 0, 23, 110, "NULL", 0, 0, 0, "LAST_HIT", 0, 0, 0, "fighter"),
(20483, 20483, "Corpse Candle", 0, "", 0, "Monster.will_o_wisp", 13, 22, 17, "male", "L2Monster", 40, 446, 184, 3.95, 1.21, 40, 43, 30, 21, 20, 10, 604, 25, 40, 91, 17, 67, 278, 0, 333, 0, 0, 0, 88, 154, "NULL", 0, 0, 0, "LAST_HIT", 0, 0, 0, "fighter"),
(20487, 20487, "Kuruka Ratman", 0, "", 0, "Monster.wererat", 14, 25, 16, "male", "L2Monster", 40, 417, 174, 3.95, 1.21, 40, 43, 30, 21, 20, 10, 475, 19, 32, 87, 15, 64, 317, 0, 333, 216, 0, 0, 88, 132, "wererat_clan", 300, 0, 0, "LAST_HIT", 0, 0, 0, "fighter"),
(20488, 20488, "Kuruka Ratman Hunter", 0, "", 0, "Monster.wererat", 14, 25, 17, "male", "L2Monster", 40, 446, 184, 3.95, 1.21, 40, 43, 30, 21, 20, 10, 504, 21, 40, 91, 17, 67, 278, 0, 333, 3, 0, 0, 88, 132, "wererat_clan", 300, 0, 0, "LAST_HIT", 0, 0, 0, "fighter"),
(20489, 20489, "Quicksilver Beast", 0, "", 0, "Monster.onyx_beast", 14, 14.5, 15, "male", "L2Monster", 40, 390, 165, 3.95, 1.21, 40, 43, 30, 21, 20, 10, 449, 18, 40, 69, 14, 62, 278, 500, 333, 0, 0, 0, 33, 132, "NULL", 0, 0, 0, "LAST_HIT", 0, 0, 0, "fighter"),
(20490, 20490, "Death Doll", 0, "", 0, "Monster.crimson_doll", 15, 38, 40, "male", "L2Monster", 40, 1527, 531, 7.11, 1.84, 40, 43, 30, 21, 20, 10, 2175, 141, 300, 183, 131, 164, 278, 500, 333, 0, 0, 0, 66, 165, "undead_clan", 300, 1, 0, "LAST_HIT", 0, 0, 0, "fighter"),
(20491, 20491, "Crypt Horror", 0, "", 0, "Monster.dark_horror", 20, 35, 15, "male", "L2Monster", 40, 390, 165, 3.95, 1.21, 40, 43, 30, 21, 20, 10, 454, 19, 40, 69, 14, 62, 278, 500, 333, 0, 0, 0, 110, 110, "NULL", 0, 1, 0, "LAST_HIT", 0, 0, 0, "fighter"),
(20492, 20492, "Kirunak's Guards", 0, "", 0, "Monster.spartoi", 11, 27, 21, "male", "L2Minion", 40, 575, 227, 5.53, 1.53, 40, 43, 30, 21, 20, 10, 636, 29, 57, 108, 25, 80, 278, 0, 333, 68, 0, 0, 66, 154, "kirunak_clan", 300, 1, 0, "LAST_HIT", 0, 0, 0, "fighter"),
(20494, 20494, "Turek War Hound", 0, "", 0, "Monster.dire_wolf", 13, 11, 24, "male", "L2Monster", 40, 687, 272, 11.06, 1.53, 40, 43, 30, 21, 20, 10, 869, 43, 89, 101, 34, 90, 278, 0, 333, 0, 0, 0, 26, 121, "orc_clan", 300, 0, 0, "LAST_HIT", 0, 0, 0, "fighter"),
(20495, 20495, "Turek Orc Warlord", 0, "", 0, "Monster.orc_champion", 10, 23, 30, "male", "L2Monster", 40, 954, 365, 11.06, 1.53, 40, 43, 30, 21, 20, 10, 1390, 76, 120, 155, 58, 114, 278, 500, 333, 127, 0, 0, 49, 143, "orc_clan", 300, 0, 0, "LAST_HIT", 0, 0, 0, "fighter"),
(20496, 20496, "Turek Orc Archer", 0, "", 0, "Monster.orc_archer", 14, 25, 27, "male", "L2Monster", 500, 813, 318, 11.06, 1.53, 40, 43, 30, 21, 20, 10, 1076, 55, 231, 125, 45, 102, 249, 0, 333, 14, 0, 0, 49, 121, "orc_clan", 400, 0, 0, "LAST_HIT", 0, 0, 0, "archer"),
(20497, 20497, "Turek Orc Skirmisher", 0, "", 0, "Monster.orc_fighter", 12, 22, 28, "male", "L2Monster", 40, 859, 334, 11.06, 1.53, 40, 43, 30, 21, 20, 10, 1117, 58, 102, 143, 49, 106, 278, 500, 333, 121, 0, 0, 49, 121, "orc_clan", 300, 0, 0, "LAST_HIT", 0, 0, 0, "fighter"),
(20498, 20498, "Turek Orc Supplier", 0, "", 0, "Monster.orc_fighter", 12, 22, 27, "male", "L2Monster", 40, 813, 318, 11.06, 1.53, 40, 43, 30, 21, 20, 10, 1035, 53, 83, 138, 45, 102, 317, 0, 333, 11, 0, 0, 49, 121, "orc_clan", 300, 0, 0, "LAST_HIT", 0, 0, 0, "fighter"),
(20499, 20499, "Turek Orc Footman", 0, "", 0, "Monster.orc", 10, 21, 26, "male", "L2Monster", 40, 770, 303, 11.06, 1.53, 40, 43, 30, 21, 20, 10, 982, 49, 96, 120, 41, 98, 278, 0, 333, 2, 0, 0, 49, 121, "orc_clan", 300, 0, 0, "LAST_HIT", 0, 0, 0, "fighter"),
(20500, 20500, "Turek Orc Sentinel", 0, "", 0, "Monster.orc", 10, 21, 25, "male", "L2Monster", 40, 728, 287, 11.06, 1.53, 40, 43, 30, 21, 20, 10, 922, 46, 88, 116, 37, 94, 278, 0, 333, 3, 0, 0, 49, 121, "orc_clan", 300, 0, 0, "LAST_HIT", 0, 0, 0, "fighter"),
(20501, 20501, "Turek Orc Shaman", 0, "", 0, "Monster.orc_shaman", 9, 22, 29, "male", "L2Monster", 40, 906, 349, 11.06, 1.53, 40, 43, 30, 21, 20, 10, 1156, 62, 111, 149, 53, 110, 278, 0, 333, 7, 0, 0, 49, 132, "orc_clan", 300, 0, 0, "LAST_HIT", 0, 0, 0, "balanced"),
(20502, 20502, "Twink Puma", 0, "", 0, "Monster.onyx_beast", 14, 14.5, 15, "male", "L2Monster", 40, 390, 165, 3.95, 1.21, 40, 43, 30, 21, 20, 10, 539, 22, 40, 69, 14, 62, 278, 500, 333, 0, 0, 0, 33, 132, "NULL", 0, 0, 0, "LAST_HIT", 0, 0, 0, "fighter"),
(20504, 20504, "Dread Soldier", 0, "", 0, "Monster.skeleton", 11, 25, 14, "male", "L2Monster", 40, 364, 156, 3.95, 1.21, 40, 43, 30, 21, 20, 10, 424, 16, 32, 66, 12, 59, 317, 500, 333, 946, 0, 0, 66, 154, "skeleton_clan", 300, 1, 0, "LAST_HIT", 0, 0, 0, "fighter"),
(20505, 20505, "Ruin Bat", 0, "", 0, "Monster.vampire_bat_bi", 10, 42, 20, "male", "L2Monster", 40, 541, 213, 3.95, 1.21, 40, 43, 30, 21, 20, 10, 712, 32, 63, 86, 23, 76, 278, 0, 333, 0, 0, 0, 66, 88, "NULL", 0, 0, 0, "LAST_HIT", 0, 0, 0, "fighter"),
(20506, 20506, "Ruin Imp", 0, "", 0, "Monster.imp_bi", 10, 30, 17, "male", "L2Monster", 40, 446, 184, 3.95, 1.21, 40, 43, 30, 21, 20, 10, 605, 25, 48, 75, 17, 67, 278, 0, 333, 0, 0, 0, 66, 88, "demonic_clan", 300, 0, 0, "LAST_HIT", 0, 0, 0, "fighter"),
(20507, 20507, "Ruin Imp Elder", 0, "", 0, "Monster.imp_bi", 10, 30, 21, "male", "L2Monster", 40, 575, 227, 5.53, 1.53, 40, 43, 30, 21, 20, 10, 779, 36, 69, 89, 25, 80, 278, 500, 333, 0, 0, 0, 66, 88, "demonic_clan", 300, 0, 0, "LAST_HIT", 0, 0, 0, "fighter"),
(20508, 20508, "Plunder Tarantula", 0, "", 0, "Monster.giant_spider", 26, 25.5, 17, "male", "L2Monster", 40, 446, 184, 3.95, 1.21, 40, 43, 30, 21, 20, 10, 618, 26, 48, 75, 17, 67, 278, 500, 333, 0, 0, 0, 79, 143, "NULL", 0, 0, 0, "LAST_HIT", 0, 0, 0, "fighter"),
(20509, 20509, "Spore Fungus", 0, "", 0, "Monster.walking_fungus", 15, 22.5, 9, "male", "L2Monster", 40, 226, 111, 3.16, 0.91, 40, 43, 30, 21, 20, 10, 321, 11, 22, 53, 7, 47, 278, 0, 333, 0, 0, 0, 77, 121, "NULL", 0, 0, 0, "LAST_HIT", 0, 0, 0, "fighter"),
(20510, 20510, "Puma", 0, "", 0, "Monster.onyx_beast", 14, 14.5, 12, "male", "L2Monster", 40, 315, 138, 3.95, 1.21, 40, 43, 30, 21, 20, 10, 423, 16, 30, 60, 10, 54, 278, 0, 333, 0, 0, 0, 33, 132, "NULL", 0, 0, 0, "LAST_HIT", 0, 0, 0, "fighter"),
(20511, 20511, "Pitchstone Golem", 0, "", 0, "Monster.stone_golem", 20, 31, 19, "male", "L2Monster", 40, 508, 203, 3.95, 1.21, 40, 43, 30, 21, 20, 10, 799, 36, 48, 99, 21, 73, 278, 0, 333, 0, 0, 0, 25, 25, "NULL", 0, 0, 0, "LAST_HIT", 0, 0, 0, "fighter"),
(20512, 20512, "Field Stalker", 0, "", 0, "Monster.field_stalker", 15, 30, 35, "male", "L2Monster", 40, 1220, 446, 7.11, 1.84, 40, 43, 30, 21, 20, 10, 1812, 107, 211, 154, 89, 137, 278, 500, 333, 0, 0, 0, 77, 121, "monster_eye_clan", 300, 0, 0, "LAST_HIT", 0, 0, 0, "fighter"),
(20513, 20513, "Skeleton Knight", 0, "", 0, "Monster.skeleton_knight", 10, 25, 32, "male", "L2Monster", 40, 1056, 397, 7.11, 1.84, 40, 43, 30, 21, 20, 10, 1265, 71, 140, 167, 69, 123, 278, 500, 333, 150, 0, 0, 44, 176, "skeleton_clan", 300, 1, 0, "LAST_HIT", 0, 0, 0, "fighter"),
(20514, 20514, "Shield Skeleton", 0, "", 0, "Monster.skeleton", 11, 25, 15, "male", "L2Monster", 40, 390, 165, 3.95, 1.21, 40, 43, 30, 21, 20, 10, 534, 22, 40, 69, 14, 62, 278, 0, 333, 157, 103, 0, 66, 154, "skeleton_clan", 300, 1, 0, "LAST_HIT", 0, 0, 0, "fighter"),
(20515, 20515, "Skeleton Infantryman", 0, "", 0, "Monster.skeleton", 11, 25, 16, "male", "L2Monster", 40, 417, 174, 3.95, 1.21, 40, 43, 30, 21, 20, 10, 570, 23, 44, 72, 15, 64, 278, 0, 333, 157, 18, 0, 66, 154, "skeleton_clan", 300, 1, 0, "LAST_HIT", 0, 0, 0, "fighter"),
(20516, 20516, "Skeleton Sentinel", 0, "", 0, "Monster.skeleton_bi", 11, 31, 14, "male", "L2Monster", 40, 364, 156, 3.95, 1.21, 40, 43, 30, 21, 20, 10, 424, 16, 32, 66, 12, 59, 317, 500, 333, 946, 0, 0, 66, 154, "skeleton_clan", 300, 1, 0, "LAST_HIT", 0, 0, 0, "fighter"),
(20517, 20517, "Skeleton Hunter", 0, "", 0, "Monster.skeleton", 11, 25, 12, "male", "L2Monster", 40, 315, 138, 3.95, 1.21, 40, 43, 30, 21, 20, 10, 363, 13, 26, 60, 10, 54, 317, 500, 333, 946, 0, 0, 66, 154, "skeleton_clan", 300, 1, 0, "LAST_HIT", 0, 0, 0, "fighter"),
(20518, 20518, "Skeleton Hunter Archer", 0, "", 0, "Monster.skeleton_archer", 11, 27, 13, "male", "L2Monster", 500, 339, 147, 3.95, 1.21, 40, 43, 30, 21, 20, 10, 397, 16, 61, 77, 11, 56, 249, 0, 333, 275, 0, 0, 44, 154, "skeleton_clan", 300, 1, 0, "LAST_HIT", 0, 0, 0, "archer"),
(20519, 20519, "Skeleton Pikeman", 0, "", 0, "Monster.skeleton_pikeman", 10, 28, 27, "male", "L2Monster", 40, 813, 318, 5.53, 1.53, 40, 43, 30, 21, 20, 10, 946, 48, 114, 114, 45, 102, 278, 500, 333, 299, 0, 0, 55, 170, "skeleton_clan", 300, 1, 0, "LAST_HIT", 0, 0, 0, "fighter"),
(20520, 20520, "Pirate Captain Uthanka", 0, "", 0, "Monster.orc_fighter_bi", 12, 26.4, 10, "male", "L2Monster", 40, 257, 120, 6.32, 0.91, 40, 43, 30, 21, 20, 10, 463, 16, 20, 67, 8, 49, 278, 500, 333, 2, 0, 0, 49, 121, "orc_clan", 300, 0, 0, "LAST_HIT", 0, 0, 0, "fighter"),
(20521, 20521, "Whinstone Golem", 0, "", 0, "Monster.stone_golem", 20, 31, 14, "male", "L2Monster", 40, 364, 156, 3.95, 1.21, 40, 43, 30, 21, 20, 10, 705, 27, 30, 80, 12, 59, 278, 0, 333, 0, 0, 0, 25, 25, "NULL", 0, 0, 0, "LAST_HIT", 0, 0, 0, "fighter"),
(20522, 20522, "White Fang", 0, "", 0, "Monster.wolf_bi", 13, 10.8, 10, "male", "L2Monster", 40, 257, 120, 6.32, 0.91, 40, 43, 30, 21, 20, 10, 458, 15, 22, 61, 8, 49, 278, 500, 333, 0, 0, 0, 26, 121, "NULL", 0, 0, 0, "LAST_HIT", 0, 0, 0, "fighter"),
(20524, 20524, "Grey Wolf Elder", 0, "", 0, "Monster.wolf", 13, 9, 7, "male", "L2Minion", 40, 171, 94, 1.58, 0.91, 40, 43, 30, 21, 20, 10, 304, 10, 20, 44, 6, 43, 278, 0, 333, 0, 0, 0, 26, 121, "NULL", 0, 0, 0, "LAST_HIT", 0, 0, 0, "fighter"),
(20525, 20525, "Gray Wolf", 0, "", 0, "Monster.wolf", 13, 9, 4, "male", "L2Monster", 40, 107, 68, 3.16, 0.91, 40, 43, 30, 21, 20, 10, 141, 4, 12, 46, 4, 37, 278, 0, 333, 0, 0, 0, 26, 121, "NULL", 0, 0, 0, "LAST_HIT", 0, 0, 0, "fighter"),
(20526, 20526, "Obsidian Golem", 0, "", 0, "Monster.stone_golem", 20, 31, 15, "male", "L2Monster", 40, 390, 165, 3.95, 1.21, 40, 43, 30, 21, 20, 10, 755, 31, 33, 84, 14, 62, 278, 0, 333, 0, 0, 0, 25, 25, "NULL", 0, 0, 0, "LAST_HIT", 0, 0, 0, "fighter"),
(20527, 20527, "White Wolf", 0, "", 0, "Monster.dire_wolf", 13, 11, 4, "male", "L2Monster", 40, 107, 68, 3.16, 0.91, 40, 43, 30, 21, 20, 10, 121, 3, 13, 42, 4, 37, 278, 500, 333, 0, 0, 0, 26, 121, "wolf_clan", 300, 0, 0, "LAST_HIT", 0, 0, 0, "fighter"),
(20528, 20528, "Goblin Lord", 0, "", 0, "Monster.goblin", 10, 16.5, 13, "male", "L2Monster", 40, 339, 147, 3.95, 1.21, 40, 43, 30, 21, 20, 10, 458, 18, 29, 63, 11, 56, 317, 0, 333, 217, 0, 0, 44, 121, "NULL", 0, 0, 0, "LAST_HIT", 0, 0, 0, "fighter"),
(20529, 20529, "Young Brown Keltir", 0, "", 0, "Monster.keltir", 9.5, 10, 1, "male", "L2Monster", 40, 62, 44, 3.16, 0.91, 40, 43, 30, 21, 20, 10, 35, 2, 9, 39, 3, 32, 278, 0, 333, 0, 0, 0, 23, 110, "NULL", 0, 0, 0, "LAST_HIT", 0, 0, 0, "fighter"),
(20530, 20530, "Young Red Keltir", 0, "", 0, "Monster.keltir", 9.5, 10, 1, "male", "L2Monster", 40, 62, 44, 3.16, 0.91, 40, 43, 30, 21, 20, 10, 35, 2, 9, 39, 3, 32, 278, 0, 333, 0, 0, 0, 23, 110, "NULL", 0, 0, 0, "LAST_HIT", 0, 0, 0, "fighter"),
(20531, 20531, "Young Prairie Keltir", 0, "", 0, "Monster.keltir", 9.5, 10, 1, "male", "L2Monster", 40, 62, 44, 3.16, 0.91, 40, 43, 30, 21, 20, 10, 35, 2, 9, 39, 3, 32, 278, 0, 333, 0, 0, 0, 23, 110, "NULL", 0, 0, 0, "LAST_HIT", 0, 0, 0, "fighter"),
(20532, 20532, "Brown Keltir", 0, "", 0, "Monster.keltir", 9.5, 10, 2, "male", "L2Monster", 40, 75, 52, 3.16, 0.91, 40, 43, 30, 21, 20, 10, 70, 2, 10, 42, 3, 34, 278, 0, 333, 0, 0, 0, 23, 110, "NULL", 0, 0, 0, "LAST_HIT", 0, 0, 0, "fighter"),
(20533, 20533, "Longtail Keltir", 0, "", 0, "Monster.keltir", 9.5, 10, 2, "male", "L2Monster", 40, 75, 52, 3.16, 0.91, 40, 43, 30, 21, 20, 10, 70, 2, 10, 42, 3, 34, 278, 0, 333, 0, 0, 0, 23, 110, "NULL", 0, 0, 0, "LAST_HIT", 0, 0, 0, "fighter"),
(20534, 20534, "Red Keltir", 0, "", 0, "Monster.keltir", 9.5, 10, 2, "male", "L2Monster", 40, 75, 52, 3.16, 0.91, 40, 43, 30, 21, 20, 10, 70, 2, 10, 42, 3, 34, 278, 0, 333, 0, 0, 0, 23, 110, "NULL", 0, 0, 0, "LAST_HIT", 0, 0, 0, "fighter"),
(20535, 20535, "Prairie Keltir", 0, "", 0, "Monster.keltir", 9.5, 10, 2, "male", "L2Monster", 40, 75, 52, 3.16, 0.91, 40, 43, 30, 21, 20, 10, 70, 2, 10, 42, 3, 34, 278, 0, 333, 0, 0, 0, 23, 110, "NULL", 0, 0, 0, "LAST_HIT", 0, 0, 0, "fighter"),
(20536, 20536, "Elder Brown Keltir", 0, "", 0, "Monster.keltir", 9.5, 10, 3, "male", "L2Monster", 40, 90, 60, 3.16, 0.91, 40, 43, 30, 21, 20, 10, 105, 2, 11, 44, 3, 35, 278, 0, 333, 0, 0, 0, 23, 110, "NULL", 0, 0, 0, "LAST_HIT", 0, 0, 0, "fighter"),
(20537, 20537, "Elder Red Keltir", 0, "", 0, "Monster.keltir", 9.5, 10, 3, "male", "L2Monster", 40, 90, 60, 3.16, 0.91, 40, 43, 30, 21, 20, 10, 105, 2, 11, 44, 3, 35, 278, 0, 333, 0, 0, 0, 23, 110, "NULL", 0, 0, 0, "LAST_HIT", 0, 0, 0, "fighter"),
(20538, 20538, "Elder Prairie Keltir", 0, "", 0, "Monster.keltir", 9.5, 10, 3, "male", "L2Monster", 40, 90, 60, 3.16, 0.91, 40, 43, 30, 21, 20, 10, 105, 2, 11, 44, 3, 35, 278, 0, 333, 0, 0, 0, 23, 110, "NULL", 0, 0, 0, "LAST_HIT", 0, 0, 0, "fighter"),
(20539, 20539, "Elder Longtail Keltir", 0, "", 0, "Monster.keltir", 9.5, 10, 3, "male", "L2Monster", 40, 90, 60, 3.16, 0.91, 40, 43, 30, 21, 20, 10, 105, 2, 11, 44, 3, 35, 278, 0, 333, 0, 0, 0, 23, 110, "NULL", 0, 0, 0, "LAST_HIT", 0, 0, 0, "fighter"),
(20540, 20540, "Gemstone Beast", 0, "", 0, "Monster.onyx_beast", 14, 14.5, 12, "male", "L2Monster", 40, 315, 138, 3.95, 1.21, 40, 43, 30, 21, 20, 10, 352, 13, 25, 73, 10, 54, 278, 0, 333, 0, 0, 0, 33, 132, "NULL", 0, 0, 0, "LAST_HIT", 0, 0, 0, "fighter"),
(20541, 20541, "Ore Bat", 0, "", 0, "Monster.vampire_bat", 10, 33.5, 17, "male", "L2Monster", 40, 446, 184, 3.95, 1.21, 40, 43, 30, 21, 20, 10, 499, 21, 48, 75, 17, 67, 278, 0, 333, 0, 0, 0, 66, 88, "NULL", 0, 0, 0, "LAST_HIT", 0, 0, 0, "fighter"),
(20542, 20542, "Skeleton Longbowman", 0, "", 0, "Monster.skeleton_archer", 11, 27, 19, "male", "L2Monster", 500, 508, 203, 3.95, 1.21, 40, 43, 30, 21, 20, 10, 587, 26, 129, 82, 21, 73, 249, 500, 333, 275, 0, 0, 44, 154, "NULL", 0, 1, 0, "LAST_HIT", 0, 0, 0, "archer"),
(20543, 20543, "Ghost", 0, "", 0, "Monster.human_ghost", 8, 22, 20, "male", "L2Monster", 40, 541, 213, 3.95, 1.21, 40, 43, 30, 21, 20, 10, 599, 27, 63, 86, 23, 76, 278, 500, 333, 0, 0, 0, 88, 154, "NULL", 0, 1, 0, "LAST_HIT", 0, 0, 0, "fighter"),
(20544, 20544, "Elder Keltir", 0, "", 0, "Monster.keltir", 9.5, 10, 3, "male", "L2Monster", 40, 90, 60, 3.16, 0.91, 40, 43, 30, 21, 20, 10, 105, 2, 12, 40, 3, 35, 278, 0, 333, 0, 0, 0, 23, 110, "NULL", 0, 0, 0, "LAST_HIT", 0, 0, 0, "fighter"),
(20545, 20545, "Young Keltir", 0, "", 0, "Monster.keltir", 9.5, 10, 1, "male", "L2Monster", 40, 62, 44, 3.16, 0.91, 40, 43, 30, 21, 20, 10, 35, 2, 9, 39, 3, 32, 278, 0, 333, 0, 0, 0, 23, 110, "NULL", 0, 0, 0, "LAST_HIT", 0, 0, 0, "fighter"),
(20546, 20546, "Turek Orc Elder", 0, "", 0, "Monster.orc_shaman", 9, 22, 34, "male", "L2Monster", 40, 1164, 430, 7.11, 1.84, 40, 43, 30, 21, 20, 10, 1714, 100, 162, 179, 82, 132, 278, 500, 333, 7, 0, 0, 49, 132, "orc_clan", 300, 0, 0, "LAST_HIT", 0, 0, 0, "balanced"),
(20547, 20547, "Ol Mahum Reserve", 0, "", 0, "Monster.ol_mahum_bi", 14, 29.2, 23, "male", "L2Monster", 40, 648, 257, 5.53, 1.53, 40, 43, 30, 21, 20, 10, 878, 42, 68, 117, 31, 87, 278, 0, 333, 2, 19, 0, 55, 121, "ol_mahum_clan", 300, 0, 0, "LAST_HIT", 0, 0, 0, "fighter"),
(20548, 20548, "Ol Mahum Deserter", 0, "", 0, "Monster.ol_mahum", 13.5, 25, 23, "male", "L2Monster", 40, 648, 257, 5.53, 1.53, 40, 43, 30, 21, 20, 10, 895, 43, 75, 107, 31, 87, 278, 500, 333, 2, 0, 0, 55, 121, "ol_mahum_clan", 300, 0, 0, "LAST_HIT", 0, 0, 0, "fighter"),
(20549, 20549, "Ol Mahum Lord", 0, "", 0, "Monster.ol_mahum_champion", 14, 27, 34, "male", "L2Monster", 40, 1164, 430, 14.22, 1.84, 40, 43, 30, 21, 20, 10, 1763, 103, 196, 148, 82, 132, 278, 500, 333, 69, 19, 0, 55, 121, "ol_mahum_clan", 300, 0, 0, "LAST_HIT", 0, 0, 0, "fighter"),
(20550, 20550, "Guardian Basilisk", 0, "", 0, "Monster.lesser_basilisk", 34, 25, 36, "male", "L2Monster", 40, 1279, 463, 7.11, 1.84, 40, 43, 30, 21, 20, 10, 1960, 118, 206, 175, 96, 142, 278, 0, 333, 0, 0, 0, 35, 174, "NULL", 0, 0, 0, "LAST_HIT", 0, 0, 0, "fighter"),
(20551, 20551, "Road Scavenger", 0, "", 0, "Monster.wererat", 14, 25, 37, "male", "L2Monster", 40, 1338, 480, 7.11, 1.84, 40, 43, 30, 21, 20, 10, 1991, 122, 194, 154, 104, 147, 317, 0, 333, 221, 0, 0, 80, 174, "NULL", 0, 0, 0, "LAST_HIT", 0, 0, 0, "fighter"),
(20552, 20552, "Fettered Soul", 0, "", 0, "Monster.binding", 12, 21, 38, "male", "L2Monster", 40, 1400, 497, 14.22, 1.84, 40, 43, 30, 21, 20, 10, 2146, 134, 238, 188, 112, 153, 278, 0, 333, 0, 0, 0, 11, 191, "NULL", 0, 1, 0, "LAST_HIT", 0, 0, 0, "fighter"),
(20553, 20553, "Windsus", 0, "", 0, "Monster.giant_wild_hog", 35, 27, 39, "male", "L2Monster", 40, 1462, 514, 7.11, 1.84, 40, 43, 30, 21, 20, 10, 2212, 141, 255, 195, 121, 158, 278, 0, 333, 0, 0, 0, 38, 191, "NULL", 0, 0, 0, "LAST_HIT", 0, 0, 0, "fighter"),
(20554, 20554, "Grandis", 0, "", 0, "Monster.twin_headed_giant", 17, 39, 40, "male", "L2Monster", 40, 1527, 531, 7.11, 1.84, 40, 43, 30, 21, 20, 10, 2585, 167, 273, 201, 131, 164, 278, 500, 333, 0, 0, 0, 49, 191, "NULL", 0, 0, 0, "LAST_HIT", 0, 0, 0, "fighter"),
(20555, 20555, "Giant Fungus", 0, "", 0, "Monster.walking_fungus_bi", 15, 31.3, 40, "male", "L2Monster", 40, 1527, 531, 7.11, 1.84, 40, 43, 30, 21, 20, 10, 2327, 150, 273, 201, 131, 164, 278, 0, 333, 0, 0, 0, 70, 174, "NULL", 0, 0, 0, "LAST_HIT", 0, 0, 0, "fighter"),
(20556, 20556, "Giant Monstereye", 0, "", 0, "Monster.monster_eye_bi", 29, 60, 41, "male", "L2Monster", 40, 1593, 560, 8.69, 2.14, 40, 43, 30, 21, 20, 10, 2444, 160, 321, 189, 141, 169, 278, 0, 333, 0, 0, 0, 90, 174, "NULL", 0, 0, 0, "LAST_HIT", 0, 0, 0, "fighter"),
(20557, 20557, "Dire Wyrm", 0, "", 0, "Monster.wyrm", 29, 72, 42, "male", "L2Monster", 40, 1660, 589, 8.69, 2.14, 40, 43, 30, 21, 20, 10, 2590, 173, 283, 237, 152, 175, 278, 500, 333, 0, 0, 0, 70, 174, "NULL", 0, 0, 0, "LAST_HIT", 0, 0, 0, "fighter"),
(20558, 20558, "Rotting tree", 0, "", 0, "Monster.hanged_man_ripper", 35, 80, 43, "male", "L2Monster", 40, 1728, 618, 8.69, 2.14, 40, 43, 30, 21, 20, 10, 2662, 180, 302, 245, 163, 181, 278, 0, 333, 0, 0, 0, 60, 191, "NULL", 0, 0, 0, "LAST_HIT", 0, 0, 0, "fighter"),
(20559, 20559, "Rotting Golem", 0, "", 0, "Monster.stone_golem_bi_one", 22, 43.4, 44, "male", "L2Monster", 40, 1799, 648, 8.69, 2.14, 40, 43, 30, 21, 20, 10, 3942, 270, 322, 253, 176, 187, 278, 0, 333, 0, 0, 0, 25, 25, "NULL", 0, 0, 0, "LAST_HIT", 0, 0, 0, "fighter"),
(20560, 20560, "Trisalim Spider", 0, "", 0, "Monster.giant_spider", 26, 25.5, 45, "male", "L2Monster", 40, 1870, 677, 8.69, 2.14, 40, 43, 30, 21, 20, 10, 2916, 203, 415, 216, 188, 193, 278, 0, 333, 0, 0, 0, 79, 191, "NULL", 0, 0, 0, "LAST_HIT", 0, 0, 0, "fighter"),
(20561, 20561, "Trisalim Tarantula", 0, "", 0, "Monster.poison_spider", 27, 25.5, 46, "male", "L2Monster", 40, 1943, 707, 8.69, 2.14, 40, 43, 30, 21, 20, 10, 3452, 245, 365, 270, 202, 199, 278, 500, 333, 0, 0, 0, 66, 191, "NULL", 0, 0, 0, "LAST_HIT", 0, 0, 0, "fighter"),
(20562, 20562, "Spore Zombie", 0, "", 0, "Monster.zombie_bi", 12, 27.5, 47, "male", "L2Monster", 40, 2016, 738, 8.69, 2.14, 40, 43, 30, 21, 20, 10, 3591, 257, 469, 230, 216, 206, 278, 0, 333, 0, 0, 0, 16, 16, "NULL", 0, 1, 0, "LAST_HIT", 0, 0, 0, "fighter"),
(20563, 20563, "Manashen Gargoyle", 0, "", 0, "Monster.gargoyle", 16, 50, 40, "male", "L2Monster", 40, 1527, 531, 7.11, 1.84, 40, 43, 30, 21, 20, 10, 2769, 179, 300, 183, 131, 164, 278, 0, 333, 0, 0, 0, 140, 174, "NULL", 0, 0, 0, "LAST_HIT", 0, 0, 0, "fighter"),
(20564, 20564, "Enchanted Monstereye", 0, "", 0, "Monster.monster_eye", 21, 43, 41, "male", "L2Monster", 40, 1593, 560, 8.69, 2.14, 40, 43, 30, 21, 20, 10, 2493, 163, 321, 189, 141, 169, 278, 500, 333, 0, 0, 0, 90, 174, "NULL", 0, 0, 0, "LAST_HIT", 0, 0, 0, "fighter"),
(20565, 20565, "Enchanted Stone Golem", 0, "", 0, "Monster.stone_golem_bi", 20, 40.3, 42, "male", "L2Monster", 40, 1660, 589, 8.69, 2.14, 40, 43, 30, 21, 20, 10, 3627, 242, 342, 196, 152, 175, 278, 0, 333, 0, 0, 0, 23, 23, "NULL", 0, 0, 0, "LAST_HIT", 0, 0, 0, "fighter"),
(20566, 20566, "Enchanted Iron Golem", 0, "", 0, "Monster.iron_golem", 18, 34, 43, "male", "L2Monster", 40, 1728, 618, 8.69, 2.14, 40, 43, 30, 21, 20, 10, 3802, 257, 302, 245, 163, 181, 278, 0, 333, 0, 0, 0, 20, 20, "NULL", 0, 0, 0, "LAST_HIT", 0, 0, 0, "fighter"),
(20567, 20567, "Enchanted Gargoyle", 0, "", 0, "Monster.gargoyle", 16, 50, 44, "male", "L2Monster", 40, 1799, 648, 8.69, 2.14, 40, 43, 30, 21, 20, 10, 3350, 229, 390, 209, 176, 187, 278, 0, 333, 0, 0, 0, 140, 174, "NULL", 0, 0, 0, "LAST_HIT", 0, 0, 0, "fighter"),
(20568, 20568, "Formor", 0, "", 0, "Monster.troll", 21, 35, 45, "male", "L2Monster", 40, 1870, 677, 8.69, 2.14, 40, 43, 30, 21, 20, 10, 2945, 205, 377, 238, 188, 193, 278, 0, 333, 0, 0, 0, 60, 191, "beast_clan", 300, 0, 0, "LAST_HIT", 0, 0, 0, "fighter"),
(20569, 20569, "Formor Elder", 0, "", 0, "Monster.troll", 21, 35, 46, "male", "L2Monster", 40, 1943, 707, 8.69, 2.14, 40, 43, 30, 21, 20, 10, 3200, 227, 401, 245, 202, 199, 278, 0, 333, 0, 0, 0, 55, 174, "beast_clan", 300, 0, 0, "LAST_HIT", 0, 0, 0, "fighter"),
(20570, 20570, "Tarlk Bugbear", 0, "", 0, "Monster.bugbear", 17, 35, 47, "male", "L2Monster", 40, 2016, 738, 8.69, 2.14, 40, 43, 30, 21, 20, 10, 3212, 230, 427, 253, 216, 206, 278, 0, 333, 88, 0, 0, 55, 174, "bugbear_clan", 300, 0, 0, "LAST_HIT", 0, 0, 0, "fighter"),
(20571, 20571, "Tarlk Bugbear Warrior", 0, "", 0, "Monster.bugbear", 17, 35, 48, "male", "L2Monster", 40, 2091, 768, 8.69, 2.14, 40, 43, 30, 21, 20, 10, 3793, 277, 453, 261, 231, 212, 278, 500, 333, 169, 0, 0, 60, 191, "bugbear_clan", 300, 0, 0, "LAST_HIT", 0, 0, 0, "fighter"),
(20572, 20572, "Tarlk Bugbear High Warrior", 0, "", 0, "Monster.king_bugbear", 15, 40, 49, "male", "L2Monster", 40, 2168, 799, 8.69, 2.14, 40, 43, 30, 21, 20, 10, 4155, 307, 529, 245, 247, 219, 278, 0, 333, 160, 0, 0, 55, 174, "bugbear_clan", 300, 0, 0, "LAST_HIT", 0, 0, 0, "fighter"),
(20573, 20573, "Tarlk Basilisk", 0, "", 0, "Monster.lesser_basilisk", 34, 25, 50, "male", "L2Monster", 40, 2245, 830, 8.69, 2.14, 40, 43, 30, 21, 20, 10, 3600, 271, 463, 306, 264, 226, 278, 0, 333, 0, 0, 0, 35, 174, "NULL", 0, 0, 0, "LAST_HIT", 0, 0, 0, "fighter"),
(20574, 20574, "Elder Tarlk Basilisk", 0, "", 0, "Monster.lesser_basilisk", 34, 25, 51, "male", "L2Monster", 40, 2323, 861, 10.27, 2.45, 40, 43, 30, 21, 20, 10, 3820, 291, 593, 260, 281, 232, 278, 500, 333, 0, 0, 0, 35, 174, "NULL", 0, 0, 0, "LAST_HIT", 0, 0, 0, "fighter"),
(20575, 20575, "Oel Mahum Warrior", 0, "", 0, "Monster.oel_mahum_warrior", 20, 38, 54, "male", "L2Monster", 40, 2562, 955, 10.27, 2.45, 40, 43, 30, 21, 20, 10, 4241, 338, 699, 284, 339, 254, 278, 0, 333, 72, 0, 0, 70, 174, "oel_mahum_clan", 300, 0, 0, "LAST_HIT", 0, 0, 0, "fighter"),
(20576, 20576, "Oel Mahum Witch Doctor", 0, "", 0, "Monster.oel_mahum_witch_doctor", 15, 34, 55, "male", "L2Monster", 40, 2643, 987, 20.54, 2.45, 40, 43, 30, 21, 20, 10, 4401, 355, 609, 354, 360, 261, 278, 0, 333, 201, 0, 0, 77, 191, "oel_mahum_clan", 300, 0, 0, "LAST_HIT", 0, 0, 0, "mage"),
(20577, 20577, "Leto Lizardman", 0, "", 0, "Monster.zenta_lizardman", 11, 32, 35, "male", "L2Monster", 40, 1220, 446, 7.11, 1.84, 40, 43, 30, 21, 20, 10, 1781, 105, 192, 169, 89, 137, 278, 0, 333, 66, 0, 0, 37, 174, "lizardman_clan", 300, 0, 0, "LAST_HIT", 0, 0, 0, "fighter"),
(20578, 20578, "Leto Lizardman Archer", 0, "", 0, "Monster.zenta_lizardman_scout", 11, 30, 36, "male", "L2Monster", 500, 1279, 463, 7.11, 1.84, 40, 43, 30, 21, 20, 10, 1941, 117, 417, 193, 96, 142, 247, 0, 333, 14, 0, 0, 37, 174, "lizardman_clan", 300, 0, 0, "LAST_HIT", 0, 0, 0, "fighter"),
(20579, 20579, "Leto Lizardman Soldier", 0, "", 0, "Monster.zenta_lizardman", 11, 32, 37, "male", "L2Monster", 40, 1338, 480, 7.11, 1.84, 40, 43, 30, 21, 20, 10, 2030, 125, 222, 182, 104, 147, 278, 500, 333, 68, 0, 0, 37, 174, "lizardman_clan", 300, 0, 0, "LAST_HIT", 0, 0, 0, "fighter"),
(20580, 20580, "Leto Lizardman Warrior", 0, "", 0, "Monster.zenta_lizardman_warrior", 13, 35, 38, "male", "L2Monster", 40, 1400, 497, 14.22, 1.84, 40, 43, 30, 21, 20, 10, 1953, 121, 261, 171, 112, 153, 278, 0, 333, 93, 0, 0, 40, 174, "lizardman_clan", 300, 0, 0, "LAST_HIT", 0, 0, 0, "fighter"),
(20581, 20581, "Leto Lizardman Shaman", 0, "", 0, "Monster.zenta_lizardman_shaman", 13, 35, 39, "male", "L2Monster", 40, 1462, 514, 7.11, 1.84, 40, 43, 30, 21, 20, 10, 2212, 141, 280, 177, 121, 158, 278, 0, 333, 159, 0, 0, 43, 174, "lizardman_clan", 300, 0, 0, "LAST_HIT", 0, 0, 0, "balanced"),
(20582, 20582, "Leto Lizardman Overlord", 0, "", 0, "Monster.zenta_lizardman_matriarch", 20, 40, 40, "male", "L2Monster", 40, 1527, 531, 14.22, 1.84, 40, 43, 30, 21, 20, 10, 2207, 142, 217, 222, 131, 164, 317, 500, 333, 221, 0, 0, 53, 174, "lizardman_clan", 300, 0, 0, "LAST_HIT", 0, 0, 0, "fighter"),
(20583, 20583, "Timak Orc", 0, "", 0, "Monster.batur_orc", 9, 21.5, 40, "male", "L2Monster", 40, 1527, 531, 7.11, 1.84, 40, 43, 30, 21, 20, 10, 2327, 150, 300, 183, 131, 164, 278, 0, 333, 2, 0, 0, 88, 191, "orc_clan", 300, 0, 2, "LAST_HIT", 0, 0, 0, "fighter"),
(20584, 20584, "Timak Orc Archer", 0, "", 0, "Monster.batur_orc_archer", 11, 21.5, 41, "male", "L2Monster", 500, 1593, 560, 8.69, 2.14, 40, 43, 30, 21, 20, 10, 3152, 206, 589, 229, 141, 169, 249, 0, 333, 14, 0, 0, 49, 191, "orc_clan", 300, 0, 2, "LAST_HIT", 0, 0, 0, "archer"),
(20585, 20585, "Timak Orc Soldier", 0, "", 0, "Monster.batur_orc", 9, 21.5, 42, "male", "L2Monster", 40, 1660, 589, 8.69, 2.14, 40, 43, 30, 21, 20, 10, 3114, 207, 311, 215, 152, 175, 278, 500, 333, 66, 0, 0, 88, 191, "orc_clan", 300, 0, 2, "LAST_HIT", 0, 0, 0, "fighter"),
(20586, 20586, "Timak Orc Warrior", 0, "", 0, "Monster.batur_orc_warrior", 10, 20, 43, "male", "L2Monster", 40, 1728, 618, 8.69, 2.14, 40, 43, 30, 21, 20, 10, 2984, 202, 332, 223, 163, 181, 278, 0, 333, 68, 0, 0, 80, 174, "orc_clan", 300, 0, 2, "LAST_HIT", 0, 0, 0, "fighter"),
(20587, 20587, "Timak Orc Shaman", 0, "", 0, "Monster.batur_orc_shaman", 11, 16, 44, "male", "L2Monster", 40, 1799, 648, 8.69, 2.14, 40, 43, 30, 21, 20, 10, 2815, 193, 390, 209, 176, 187, 278, 0, 333, 179, 0, 0, 50, 174, "orc_clan", 300, 0, 3, "LAST_HIT", 0, 0, 0, "balanced"),
(20588, 20588, "Timak Orc Overlord", 0, "", 0, "Monster.batur_orc_overlord", 14.5, 28.8, 45, "male", "L2Monster", 40, 1870, 677, 8.69, 2.14, 40, 43, 30, 21, 20, 10, 3701, 257, 415, 216, 188, 193, 278, 500, 333, 127, 0, 0, 80, 174, "orc_clan", 300, 0, 3, "LAST_HIT", 0, 0, 0, "fighter"),
(20589, 20589, "Fline", 0, "", 0, "Monster.sylph", 11, 35, 45, "female", "L2Monster", 40, 1870, 677, 17.38, 2.14, 40, 43, 30, 21, 20, 10, 2766, 192, 343, 262, 188, 193, 278, 0, 333, 0, 0, 0, 60, 174, "elemental_clan", 400, 0, 0, "LAST_HIT", 0, 0, 0, "fighter"),
(20590, 20590, "Liele", 0, "", 0, "Monster.undine", 12, 27, 46, "female", "L2Monster", 40, 1943, 707, 17.38, 2.14, 40, 43, 30, 21, 20, 10, 2862, 203, 365, 270, 202, 199, 278, 0, 333, 0, 0, 0, 60, 174, "elemental_clan", 300, 0, 0, "LAST_HIT", 0, 0, 0, "fighter"),
(20591, 20591, "Valley Treant", 0, "", 0, "Monster.ti_mi_tran", 23, 90, 47, "male", "L2Monster", 40, 2016, 738, 17.38, 2.14, 40, 43, 30, 21, 20, 10, 4224, 303, 388, 279, 216, 206, 278, 0, 333, 0, 0, 0, 13, 13, "elemental_clan", 300, 0, 0, "LAST_HIT", 0, 0, 0, "fighter"),
(20592, 20592, "Satyr", 0, "", 0, "Monster.pan", 14, 35, 48, "male", "L2Monster", 40, 2091, 768, 26.07, 2.14, 40, 43, 30, 21, 20, 10, 3076, 224, 412, 288, 231, 212, 278, 500, 333, 291, 0, 0, 45, 174, "elemental_clan", 300, 0, 0, "LAST_HIT", 0, 0, 0, "fighter"),
(20593, 20593, "Unicorn", 0, "", 0, "Monster.unicorn", 14, 30, 49, "male", "L2Monster", 40, 2168, 799, 26.07, 2.14, 40, 43, 30, 21, 20, 10, 3299, 244, 437, 297, 247, 219, 278, 0, 333, 0, 0, 0, 46, 174, "elemental_clan", 300, 0, 0, "LAST_HIT", 0, 0, 0, "fighter"),
(20594, 20594, "Forest Runner", 0, "", 0, "Monster.mandragora_b", 12, 25.5, 50, "female", "L2Monster", 40, 2245, 830, 17.38, 2.14, 40, 43, 30, 21, 20, 10, 3381, 254, 463, 306, 264, 226, 278, 0, 333, 0, 0, 0, 80, 174, "elemental_clan", 300, 0, 0, "LAST_HIT", 0, 0, 0, "fighter"),
(20595, 20595, "Fline Elder", 0, "", 0, "Monster.sylph", 11, 35, 51, "female", "L2Monster", 40, 2323, 861, 20.54, 2.45, 40, 43, 30, 21, 20, 10, 3518, 268, 593, 260, 281, 232, 278, 0, 333, 0, 0, 0, 60, 174, "elemental_clan", 300, 0, 0, "LAST_HIT", 0, 0, 0, "fighter"),
(20596, 20596, "Liele Elder", 0, "", 0, "Monster.undine", 12, 27, 52, "female", "L2Monster", 40, 2402, 892, 20.54, 2.45, 40, 43, 30, 21, 20, 10, 3730, 288, 627, 268, 300, 239, 278, 500, 333, 0, 0, 0, 60, 174, "elemental_clan", 300, 0, 0, "LAST_HIT", 0, 0, 0, "fighter"),
(20597, 20597, "Valley Treant Elder", 0, "", 0, "Monster.ti_mi_tran", 23, 90, 53, "male", "L2Monster", 40, 2481, 923, 30.81, 2.45, 40, 43, 30, 21, 20, 10, 5199, 408, 662, 276, 319, 247, 278, 0, 333, 0, 0, 0, 12, 12, "elemental_clan", 300, 0, 0, "LAST_HIT", 0, 0, 0, "fighter"),
(20598, 20598, "Satyr Elder", 0, "", 0, "Monster.pan", 14, 35, 54, "male", "L2Monster", 40, 2562, 955, 30.81, 2.45, 40, 43, 30, 21, 20, 10, 3816, 304, 699, 284, 339, 254, 278, 0, 333, 297, 0, 0, 45, 174, "elemental_clan", 300, 0, 0, "LAST_HIT", 0, 0, 0, "fighter"),
(20599, 20599, "Unicorn Elder", 0, "", 0, "Monster.unicorn", 14, 30, 55, "male", "L2Monster", 40, 2643, 987, 30.81, 2.45, 40, 43, 30, 21, 20, 10, 3959, 319, 737, 292, 360, 261, 278, 0, 333, 0, 0, 0, 46, 174, "elemental_clan", 300, 0, 0, "LAST_HIT", 0, 0, 0, "fighter"),
(20600, 20600, "Karul Bugbear", 0, "", 0, "Monster.bugbear", 17, 35, 40, "male", "L2Monster", 40, 1527, 531, 7.11, 1.84, 40, 43, 30, 21, 20, 10, 2741, 177, 300, 183, 131, 164, 278, 0, 333, 88, 0, 0, 55, 174, "NULL", 0, 0, 0, "LAST_HIT", 0, 0, 0, "fighter"),
(20601, 20601, "Tamlin Orc", 0, "", 0, "Monster.batur_orc", 9, 21.5, 41, "male", "L2Monster", 40, 1593, 560, 8.69, 2.14, 40, 43, 30, 21, 20, 10, 2444, 160, 291, 208, 141, 169, 278, 0, 333, 2, 0, 0, 80, 174, "orc_clan", 300, 0, 0, "LAST_HIT", 0, 0, 0, "fighter"),
(20602, 20602, "Tamlin Orc Archer", 0, "", 0, "Monster.batur_orc_archer", 11, 21.5, 42, "male", "L2Monster", 500, 1660, 589, 8.69, 2.14, 40, 43, 30, 21, 20, 10, 3308, 220, 692, 215, 152, 175, 247, 0, 333, 14, 0, 0, 45, 174, "orc_clan", 300, 0, 0, "LAST_HIT", 0, 0, 0, "archer"),
(20603, 20603, "Kronbe Spider", 0, "", 0, "Monster.giant_spider", 26, 25.5, 43, "male", "L2Monster", 40, 1728, 618, 8.69, 2.14, 40, 43, 30, 21, 20, 10, 2715, 184, 302, 245, 163, 181, 278, 500, 333, 0, 0, 0, 72, 174, "NULL", 0, 0, 0, "LAST_HIT", 0, 0, 0, "fighter"),
(20604, 20604, "Lakin", 0, "", 0, "Monster.twin_headed_giant", 17, 39, 44, "male", "L2Monster", 40, 1799, 648, 8.69, 2.14, 40, 43, 30, 21, 20, 10, 3317, 227, 390, 209, 176, 187, 278, 0, 333, 89, 0, 0, 45, 174, "NULL", 0, 0, 0, "LAST_HIT", 0, 0, 0, "fighter"),
(20605, 20605, "Weird Drake", 0, "", 0, "Monster.drake", 30, 100, 45, "male", "L2Monster", 40, 1870, 677, 8.69, 2.14, 40, 43, 30, 21, 20, 10, 3004, 209, 377, 238, 188, 193, 278, 500, 333, 0, 0, 0, 70, 174, "NULL", 0, 0, 0, "LAST_HIT", 0, 0, 0, "fighter"),
(20606, 20606, "Kuran Kobold", 0, "", 0, "Monster.kobold", 10, 15, 27, "male", "L2Monster", 40, 813, 318, 11.06, 1.53, 40, 43, 30, 21, 20, 10, 950, 48, 94, 138, 45, 102, 278, 0, 333, 0, 0, 0, 51, 121, "kobold_clan", 300, 0, 0, "LAST_HIT", 0, 0, 0, "fighter"),
(20607, 20607, "Kuran Kobold Warrior", 0, "", 0, "Monster.kobold", 10, 15, 28, "male", "L2Monster", 40, 859, 334, 11.06, 1.53, 40, 43, 30, 21, 20, 10, 1006, 53, 124, 118, 49, 106, 278, 0, 333, 0, 0, 0, 51, 121, "kobold_clan", 300, 0, 0, "LAST_HIT", 0, 0, 0, "fighter"),
(20608, 20608, "Patin Archer", 0, "", 0, "Monster.skeleton_archer", 11, 27, 29, "male", "L2Monster", 500, 906, 349, 11.06, 1.53, 40, 43, 30, 21, 20, 10, 1022, 55, 271, 135, 53, 110, 249, 500, 333, 14, 0, 0, 44, 154, "NULL", 0, 1, 0, "LAST_HIT", 0, 0, 0, "archer"),
(20609, 20609, "Lakin Salamander", 0, "", 0, "Monster.salamander", 16, 6.8, 30, "male", "L2Monster", 40, 954, 365, 11.06, 1.53, 40, 43, 30, 21, 20, 10, 1068, 58, 120, 155, 58, 114, 278, 0, 333, 0, 0, 0, 70, 105, "elemental_clan", 300, 0, 0, "LAST_HIT", 0, 0, 0, "fighter"),
(20610, 20610, "Sentinel Of Water", 0, "", 0, "Monster.monster_eye", 21, 43, 31, "male", "L2Monster", 40, 1004, 381, 14.22, 1.84, 40, 43, 30, 21, 20, 10, 1083, 60, 157, 133, 64, 118, 278, 0, 333, 0, 0, 0, 99, 99, "elemental_clan", 300, 0, 0, "LAST_HIT", 0, 0, 0, "fighter"),
(20611, 20611, "Dre Vanul Warrior", 0, "", 0, "Monster.dre_vanul", 14, 36, 32, "male", "L2Monster", 40, 1056, 397, 14.22, 1.84, 40, 43, 30, 21, 20, 10, 1154, 65, 169, 138, 69, 123, 278, 0, 333, 0, 0, 0, 88, 88, "demonic_clan", 300, 0, 0, "LAST_HIT", 0, 0, 0, "fighter"),
(20612, 20612, "Salamander Rowin", 0, "", 0, "Monster.salamander", 16, 6.8, 33, "male", "L2Monster", 40, 1109, 413, 14.22, 1.84, 40, 43, 30, 21, 20, 10, 1319, 75, 151, 173, 75, 128, 278, 500, 333, 0, 0, 0, 70, 105, "elemental_clan", 300, 0, 0, "LAST_HIT", 0, 0, 0, "fighter"),
(20613, 20613, "Lafi Lizardman", 0, "", 0, "Monster.virud_lizardman", 10, 23, 27, "male", "L2Monster", 40, 813, 318, 11.06, 1.53, 40, 43, 30, 21, 20, 10, 950, 48, 104, 125, 45, 102, 278, 0, 333, 291, 0, 0, 47, 143, "lizardman_clan", 300, 0, 0, "LAST_HIT", 0, 0, 0, "fighter"),
(20614, 20614, "Lafi Lizardman Scout", 0, "", 0, "Monster.virud_lizardman_scout", 10, 22, 28, "male", "L2Monster", 500, 859, 334, 11.06, 1.53, 40, 43, 30, 21, 20, 10, 940, 49, 228, 143, 49, 106, 249, 0, 333, 2507, 0, 0, 47, 143, "lizardman_clan", 300, 0, 0, "LAST_HIT", 0, 0, 0, "fighter"),
(20615, 20615, "Ritmal Swordsman", 0, "", 0, "Monster.spartoi", 11, 27, 29, "male", "L2Monster", 40, 906, 349, 11.06, 1.53, 40, 43, 30, 21, 20, 10, 1094, 58, 122, 135, 53, 110, 278, 500, 333, 73, 0, 0, 66, 154, "NULL", 0, 1, 0, "LAST_HIT", 0, 0, 0, "fighter"),
(20616, 20616, "Lakin Undine", 0, "", 0, "Monster.undine", 12, 27, 30, "female", "L2Monster", 40, 954, 365, 11.06, 1.53, 40, 43, 30, 21, 20, 10, 1434, 78, 145, 128, 58, 114, 278, 0, 333, 0, 0, 0, 66, 66, "elemental_clan", 300, 0, 0, "LAST_HIT", 0, 0, 0, "fighter"),
(20617, 20617, "Sentinel Of Water", 0, "", 0, "Monster.magical_weaver", 11, 20, 31, "male", "L2Monster", 40, 1004, 381, 14.22, 1.84, 40, 43, 30, 21, 20, 10, 1093, 60, 129, 161, 64, 118, 278, 0, 333, 0, 0, 0, 99, 99, "NULL", 0, 0, 0, "LAST_HIT", 0, 0, 0, "fighter"),
(20618, 20618, "Kanil Succubus", 0, "", 0, "Monster.succubus", 10, 36, 32, "female", "L2Monster", 40, 1056, 397, 14.22, 1.84, 40, 43, 30, 21, 20, 10, 1216, 68, 169, 138, 69, 123, 278, 0, 333, 0, 0, 0, 66, 110, "demonic_clan", 300, 0, 0, "LAST_HIT", 0, 0, 0, "fighter"),
(20619, 20619, "Rowin Undine", 0, "", 0, "Monster.undine", 12, 27, 33, "female", "L2Monster", 40, 1109, 413, 14.22, 1.84, 40, 43, 30, 21, 20, 10, 1252, 72, 151, 173, 75, 128, 278, 500, 333, 0, 0, 0, 66, 66, "elemental_clan", 300, 0, 0, "LAST_HIT", 0, 0, 0, "fighter"),
(20620, 20620, "Cave Beast", 0, "", 0, "Monster.troll", 21, 35, 61, "male", "L2Monster", 40, 3137, 1184, 35.55, 2.78, 40, 43, 30, 21, 20, 10, 4304, 378, 992, 344, 505, 307, 278, 500, 333, 0, 0, 0, 55, 174, "NULL", 0, 0, 0, "LAST_HIT", 0, 0, 0, "fighter"),
(20621, 20621, "Death Wave", 0, "", 0, "Monster.will_o_wisp", 13, 22, 62, "male", "L2Monster", 40, 3219, 1217, 35.55, 2.78, 40, 43, 30, 21, 20, 10, 4639, 413, 1038, 353, 532, 315, 278, 500, 333, 0, 0, 0, 80, 174, "NULL", 0, 0, 0, "LAST_HIT", 0, 0, 0, "fighter"),
(20622, 20622, "Malruk Soldier", 0, "", 0, "Monster.skeleton_royal_guard", 11, 28.5, 63, "male", "L2Monster", 40, 3302, 1251, 35.55, 2.78, 40, 43, 30, 21, 20, 10, 4953, 447, 950, 362, 560, 323, 317, 500, 333, 221, 0, 0, 88, 191, "malruk_clan", 500, 1, 0, "LAST_HIT", 0, 0, 0, "fighter"),
(20623, 20623, "Plando", 0, "", 0, "Monster.virud_lizardman_scout", 10, 22, 64, "male", "L2Monster", 500, 3384, 1285, 47.4, 2.78, 40, 43, 30, 21, 20, 10, 4953, 453, 2084, 449, 589, 331, 249, 500, 333, 2507, 0, 0, 47, 191, "NULL", 0, 0, 0, "LAST_HIT", 0, 0, 0, "fighter"),
(20624, 20624, "Cave Howler", 0, "", 0, "Monster.twin_headed_giant", 17, 39, 65, "male", "L2Monster", 40, 3465, 1319, 47.4, 2.78, 40, 43, 30, 21, 20, 10, 5037, 468, 979, 460, 619, 340, 278, 500, 333, 0, 0, 0, 49, 191, "NULL", 0, 0, 0, "LAST_HIT", 0, 0, 0, "fighter"),
(20625, 20625, "Malruk Knight", 0, "", 0, "Monster.skeleton_knight", 10, 25, 66, "male", "L2Monster", 40, 3546, 1353, 47.4, 2.78, 40, 43, 30, 21, 20, 10, 5030, 473, 1020, 471, 649, 348, 278, 500, 333, 78, 0, 0, 44, 191, "malruk_clan", 500, 1, 10, "LAST_HIT", 0, 0, 0, "fighter"),
(20626, 20626, "Malruk Berserker", 0, "", 0, "Monster.death_knight", 12, 31, 67, "male", "L2Monster", 40, 3626, 1388, 47.4, 2.78, 40, 43, 30, 21, 20, 10, 7220, 687, 1415, 362, 681, 356, 278, 500, 333, 77, 0, 0, 29, 191, "malruk_clan", 500, 1, 10, "LAST_HIT", 0, 0, 0, "fighter"),
(20627, 20627, "Malruk Lord", 0, "", 0, "Monster.death_blader", 15, 45, 68, "male", "L2Monster", 40, 3706, 1423, 59.25, 2.78, 40, 43, 30, 21, 20, 10, 4964, 479, 1217, 449, 713, 365, 278, 500, 333, 1472, 0, 0, 110, 191, "malruk_clan", 500, 1, 10, "LAST_HIT", 0, 0, 0, "fighter"),
(20628, 20628, "Limal Karinness", 0, "", 0, "Monster.bloody_queen", 14, 40, 69, "female", "L2Monster", 40, 3784, 1458, 59.25, 2.78, 40, 43, 30, 21, 20, 10, 5349, 523, 1392, 418, 746, 373, 278, 500, 333, 0, 0, 0, 88, 191, "malruk_clan", 500, 0, 10, "LAST_HIT", 0, 0, 0, "fighter"),
(20629, 20629, "Karik", 0, "", 0, "Monster.karik", 25, 90, 70, "male", "L2Monster", 40, 3862, 1493, 59.25, 2.78, 40, 43, 30, 21, 20, 10, 6584, 652, 1445, 427, 780, 382, 278, 500, 333, 0, 0, 0, 40, 191, "NULL", 0, 0, 10, "LAST_HIT", 0, 0, 0, "fighter"),
(20630, 20630, "Taik Orc", 0, "", 0, "Monster.ketra_orc", 12, 29, 40, "male", "L2Monster", 40, 1527, 531, 7.11, 1.84, 40, 43, 30, 21, 20, 10, 2327, 150, 273, 201, 131, 164, 278, 0, 333, 127, 0, 0, 49, 191, "NULL", 0, 0, 0, "LAST_HIT", 0, 0, 0, "fighter"),
(20631, 20631, "Taik Orc Archer", 0, "", 0, "Monster.ketra_orc_archer", 12, 27, 41, "male", "L2Monster", 500, 1593, 560, 8.69, 2.14, 40, 43, 30, 21, 20, 10, 3152, 206, 589, 195, 141, 169, 247, 0, 333, 14, 0, 0, 45, 174, "orc_clan", 300, 0, 0, "LAST_HIT", 0, 0, 0, "archer"),
(20632, 20632, "Taik Orc Warrior", 0, "", 0, "Monster.ketra_orc_warrior", 12, 24, 42, "male", "L2Monster", 40, 1660, 589, 8.69, 2.14, 40, 43, 30, 21, 20, 10, 3144, 209, 342, 196, 152, 175, 278, 500, 333, 75, 0, 0, 39, 191, "orc_clan", 400, 0, 0, "LAST_HIT", 0, 0, 0, "fighter"),
(20633, 20633, "Taik Orc Shaman", 0, "", 0, "Monster.ketra_orc_shaman", 10, 23, 43, "male", "L2Monster", 40, 1728, 618, 8.69, 2.14, 40, 43, 30, 21, 20, 10, 3068, 207, 302, 245, 163, 181, 278, 0, 333, 9, 0, 0, 10, 174, "orc_clan", 300, 0, 0, "LAST_HIT", 0, 0, 0, "balanced"),
(20634, 20634, "Taik Orc Captain", 0, "", 0, "Monster.ketra_orc_warrior", 12, 24, 44, "male", "L2Monster", 40, 1799, 648, 17.38, 2.14, 40, 43, 30, 21, 20, 10, 2943, 201, 322, 253, 176, 187, 278, 500, 333, 75, 104, 0, 36, 174, "orc_clan", 300, 0, 0, "LAST_HIT", 0, 0, 0, "fighter"),
(20635, 20635, "Carinkain", 0, "", 0, "Monster.mana_vampire", 11, 20, 45, "male", "L2Monster", 40, 1870, 677, 8.69, 2.14, 40, 43, 30, 21, 20, 10, 2974, 207, 415, 216, 188, 193, 278, 500, 333, 0, 0, 0, 90, 174, "NULL", 0, 0, 0, "LAST_HIT", 0, 0, 0, "fighter"),
(20636, 20636, "Forest of Mirrors Ghost", 0, "", 0, "Monster.dwarf_ghost", 9, 16.5, 46, "male", "L2Monster", 40, 1943, 707, 8.69, 2.14, 40, 43, 30, 21, 20, 10, 3310, 235, 442, 223, 202, 199, 278, 500, 333, 0, 0, 0, 80, 174, "mirrorforest_clan", 200, 1, 3, "LAST_HIT", 0, 0, 0, "fighter"),
(20637, 20637, "Forest of Mirrors Ghost", 0, "", 0, "Monster.elf_ghost", 7, 21, 47, "male", "L2Monster", 40, 2016, 738, 8.69, 2.14, 40, 43, 30, 21, 20, 10, 3456, 248, 469, 230, 216, 206, 278, 500, 333, 0, 0, 0, 80, 174, "mirrorforest_clan", 200, 1, 4, "LAST_HIT", 0, 0, 0, "fighter"),
(20638, 20638, "Forest of Mirrors Ghost", 0, "", 0, "Monster.human_ghost", 8, 22, 48, "male", "L2Monster", 40, 2091, 768, 8.69, 2.14, 40, 43, 30, 21, 20, 10, 3605, 263, 498, 238, 231, 212, 278, 500, 333, 0, 0, 0, 80, 174, "mirrorforest_clan", 200, 1, 4, "LAST_HIT", 0, 0, 0, "fighter"),
(20639, 20639, "Mirror", 0, "", 0, "Monster.mirror", 26, 52, 49, "male", "L2Monster", 40, 2168, 799, 17.38, 2.14, 40, 43, 30, 21, 20, 10, 4254, 314, 437, 297, 247, 219, 278, 0, 333, 0, 0, 0, 80, 174, "NULL", 0, 0, 4, "LAST_HIT", 0, 0, 0, "fighter"),
(20640, 20640, "Harit Lizardman", 0, "", 0, "Monster.zenta_lizardman", 11, 32, 50, "male", "L2Monster", 40, 2245, 830, 8.69, 2.14, 40, 43, 30, 21, 20, 10, 3636, 274, 509, 278, 264, 226, 278, 0, 333, 88, 945, 0, 37, 174, "lizardman_clan", 300, 0, 5, "LAST_HIT", 0, 0, 0, "fighter"),
(20641, 20641, "Harit Lizardman Grunt", 0, "", 0, "Monster.zenta_lizardman", 11, 32, 51, "male", "L2Monster", 40, 2323, 861, 10.27, 2.45, 40, 43, 30, 21, 20, 10, 4501, 343, 539, 286, 281, 232, 278, 0, 333, 70, 0, 0, 37, 174, "lizardman_clan", 300, 0, 5, "LAST_HIT", 0, 0, 0, "fighter"),
(20642, 20642, "Harit Lizardman Archer", 0, "", 0, "Monster.zenta_lizardman_scout", 11, 30, 52, "male", "L2Monster", 500, 2402, 892, 10.27, 2.45, 40, 43, 30, 21, 20, 10, 4214, 326, 1152, 324, 300, 239, 247, 500, 333, 14, 0, 0, 37, 174, "lizardman_clan", 300, 0, 5, "LAST_HIT", 0, 0, 0, "fighter"),
(20643, 20643, "Harit Lizardman Warrior", 0, "", 0, "Monster.zenta_lizardman_warrior", 13, 35, 53, "male", "L2Monster", 40, 2481, 923, 10.27, 2.45, 40, 43, 30, 21, 20, 10, 4332, 341, 662, 276, 319, 247, 278, 0, 333, 291, 0, 0, 40, 174, "lizardman_clan", 400, 0, 0, "LAST_HIT", 0, 0, 0, "fighter"),
(20644, 20644, "Harit Lizardman Shaman", 0, "", 0, "Monster.zenta_lizardman_shaman", 13, 35, 54, "male", "L2Monster", 40, 2562, 955, 10.27, 2.45, 40, 43, 30, 21, 20, 10, 4241, 338, 699, 284, 339, 254, 278, 0, 333, 9, 0, 0, 43, 174, "lizardman_clan", 300, 0, 0, "LAST_HIT", 0, 0, 0, "balanced"),
(20645, 20645, "Harit Lizardman Matriarch", 0, "", 0, "Monster.zenta_lizardman_matriarch", 20, 40, 55, "male", "L2Monster", 40, 2643, 987, 20.54, 2.45, 40, 43, 30, 21, 20, 10, 4768, 385, 609, 354, 360, 261, 278, 500, 333, 221, 0, 0, 53, 174, "lizardman_clan", 300, 0, 0, "LAST_HIT", 0, 0, 0, "fighter"),
(20646, 20646, "Halingka", 0, "", 0, "Monster.saber_toothed_tiger", 34, 28, 55, "male", "L2Monster", 40, 2643, 987, 20.54, 2.45, 40, 43, 30, 21, 20, 10, 3592, 290, 737, 292, 360, 261, 278, 0, 333, 0, 0, 0, 66, 187, "beast_clan", 300, 0, 6, "LAST_HIT", 0, 0, 0, "fighter"),
(20647, 20647, "Yintzu", 0, "", 0, "Monster.field_stalker", 15, 30, 56, "male", "L2Monster", 40, 2724, 1019, 20.54, 2.45, 40, 43, 30, 21, 20, 10, 3605, 296, 777, 301, 382, 269, 278, 500, 333, 0, 0, 0, 77, 121, "beast_clan", 300, 0, 6, "LAST_HIT", 0, 0, 0, "fighter"),
(20648, 20648, "Paliote", 0, "", 0, "Monster.will_o_wisp", 13, 22, 57, "male", "L2Monster", 40, 2806, 1052, 20.54, 2.45, 40, 43, 30, 21, 20, 10, 4094, 340, 817, 309, 405, 276, 278, 0, 333, 0, 0, 0, 88, 154, "beast_clan", 300, 0, 7, "LAST_HIT", 0, 0, 0, "fighter"),
(20649, 20649, "Hamrut", 0, "", 0, "Monster.poison_spider", 27, 25.5, 58, "male", "L2Monster", 40, 2889, 1084, 20.54, 2.45, 40, 43, 30, 21, 20, 10, 4075, 344, 859, 318, 428, 284, 278, 500, 333, 0, 0, 0, 66, 154, "beast_clan", 300, 0, 7, "LAST_HIT", 0, 0, 0, "fighter"),
(20650, 20650, "Kranrot", 0, "", 0, "Monster.crimson_bear", 19, 36, 59, "male", "L2Monster", 40, 2971, 1117, 20.54, 2.45, 40, 43, 30, 21, 20, 10, 4410, 377, 902, 326, 453, 291, 278, 500, 333, 0, 0, 0, 40, 187, "beast_clan", 300, 0, 8, "LAST_HIT", 0, 0, 0, "fighter"),
(20651, 20651, "Gamlin", 0, "", 0, "Monster.gamlin", 11, 32, 60, "male", "L2Monster", 40, 3054, 1150, 20.54, 2.45, 40, 43, 30, 21, 20, 10, 4097, 355, 782, 405, 478, 299, 278, 0, 333, 0, 0, 0, 88, 187, "giant_clan", 400, 0, 0, "LAST_HIT", 0, 0, 0, "fighter"),
(20652, 20652, "Leogul", 0, "", 0, "Monster.leogul", 15, 35, 61, "male", "L2Monster", 40, 3137, 1184, 23.7, 2.78, 40, 43, 30, 21, 20, 10, 4320, 380, 819, 416, 505, 307, 278, 500, 333, 0, 0, 0, 88, 187, "giant_clan", 400, 0, 0, "LAST_HIT", 0, 0, 0, "fighter"),
(20653, 20653, "Lesser Giant", 0, "", 0, "Monster.lesser_giant", 21, 44, 61, "male", "L2Monster", 40, 3137, 1184, 35.55, 2.78, 40, 43, 30, 21, 20, 10, 4058, 357, 901, 378, 505, 307, 278, 0, 333, 3937, 0, 0, 16, 198, "giant_clan", 300, 0, 0, "LAST_HIT", 0, 0, 0, "fighter"),
(20654, 20654, "Lesser Giant Soldier", 0, "", 0, "Monster.lesser_giant", 21, 44, 62, "male", "L2Monster", 40, 3219, 1217, 35.55, 2.78, 40, 43, 30, 21, 20, 10, 6224, 554, 1142, 321, 532, 315, 278, 0, 333, 3937, 0, 0, 16, 198, "giant_clan", 300, 0, 0, "LAST_HIT", 0, 0, 0, "fighter"),
(20655, 20655, "Lesser Giant Shooter", 0, "", 0, "Monster.lesser_giant_shooter", 21, 44, 63, "male", "L2Monster", 500, 3302, 1251, 35.55, 2.78, 40, 43, 30, 21, 20, 10, 5085, 459, 2194, 398, 560, 323, 249, 500, 333, 4028, 0, 0, 88, 198, "giant_clan", 300, 0, 0, "LAST_HIT", 0, 0, 0, "fighter"),
(20656, 20656, "Lesser Giant Scout", 0, "", 0, "Monster.lesser_giant_shooter", 21, 44, 63, "male", "L2Monster", 500, 3302, 1251, 35.55, 2.78, 40, 43, 30, 21, 20, 10, 4639, 419, 2194, 338, 560, 323, 249, 500, 333, 4028, 0, 0, 88, 198, "giant_clan", 300, 0, 0, "LAST_HIT", 0, 0, 0, "fighter"),
(20657, 20657, "Lesser Giant Mage", 0, "", 0, "Monster.lesser_giant_mage", 21, 44, 64, "male", "L2Monster", 40, 3384, 1285, 23.7, 2.78, 40, 43, 30, 21, 20, 10, 5511, 504, 1135, 371, 589, 331, 278, 0, 333, 3938, 0, 0, 16, 198, "giant_clan", 300, 0, 0, "LAST_HIT", 0, 0, 0, "mage"),
(20658, 20658, "Lesser Giant Elder", 0, "", 0, "Monster.lesser_giant_mage", 21, 44, 65, "male", "L2Monster", 40, 3465, 1319, 23.7, 2.78, 40, 43, 30, 21, 20, 10, 5324, 494, 1184, 380, 619, 340, 278, 0, 333, 3938, 0, 0, 16, 198, "giant_clan", 300, 0, 0, "LAST_HIT", 0, 0, 0, "mage"),
(20659, 20659, "Grave Wanderer", 0, "", 0, "Monster.zombie", 13, 21, 45, "male", "L2Monster", 40, 1870, 677, 8.69, 2.14, 40, 43, 30, 21, 20, 10, 4123, 287, 377, 238, 188, 193, 278, 0, 333, 0, 0, 0, 16, 16, "NULL", 0, 1, 0, "LAST_HIT", 0, 0, 0, "fighter"),
(20660, 20660, "Archer of Greed", 0, "", 0, "Monster.skeleton_archer", 11, 27, 46, "male", "L2Monster", 500, 1943, 707, 8.69, 2.14, 40, 43, 30, 21, 20, 10, 4048, 287, 982, 190, 202, 199, 249, 500, 333, 14, 0, 0, 44, 191, "NULL", 0, 1, 0, "LAST_HIT", 0, 0, 0, "archer"),
(20661, 20661, "Hatar Ratman Thief", 0, "", 0, "Monster.wererat", 14, 25, 47, "male", "L2Monster", 40, 2016, 738, 8.69, 2.14, 40, 43, 30, 21, 20, 10, 3823, 274, 373, 253, 216, 206, 317, 0, 333, 946, 0, 0, 88, 191, "hatar_clan", 300, 0, 0, "LAST_HIT", 0, 0, 0, "fighter"),
(20662, 20662, "Hatar Ratman Boss", 0, "", 0, "Monster.wererat", 14, 25, 48, "male", "L2Monster", 40, 2091, 768, 8.69, 2.14, 40, 43, 30, 21, 20, 10, 3987, 291, 396, 261, 231, 212, 317, 0, 333, 221, 0, 0, 88, 191, "hatar_clan", 300, 0, 0, "LAST_HIT", 0, 0, 0, "fighter"),
(20663, 20663, "Hatar Hanishee", 0, "", 0, "Monster.medusa", 10, 25, 49, "female", "L2Monster", 40, 2168, 799, 8.69, 2.14, 40, 43, 30, 21, 20, 10, 3492, 258, 529, 245, 247, 219, 278, 0, 333, 0, 0, 0, 55, 191, "hatar_clan", 300, 0, 0, "LAST_HIT", 0, 0, 0, "fighter"),
(20664, 20664, "Deprive", 0, "", 0, "Monster.field_stalker", 15, 30, 50, "male", "L2Monster", 40, 2245, 830, 8.69, 2.14, 40, 43, 30, 21, 20, 10, 3672, 277, 560, 253, 264, 226, 278, 500, 333, 0, 0, 0, 77, 191, "NULL", 0, 0, 0, "LAST_HIT", 0, 0, 0, "fighter"),
(20665, 20665, "Taik Orc Supply", 0, "", 0, "Monster.ketra_orc", 12, 29, 51, "male", "L2Monster", 40, 2323, 861, 10.27, 2.45, 40, 43, 30, 21, 20, 10, 4501, 343, 490, 315, 281, 232, 278, 0, 333, 69, 0, 0, 49, 191, "orc_clan", 300, 0, 0, "LAST_HIT", 0, 0, 0, "fighter"),
(20666, 20666, "Taik Orc Seeker", 0, "", 0, "Monster.ketra_orc", 12, 29, 52, "male", "L2Monster", 40, 2402, 892, 10.27, 2.45, 40, 43, 30, 21, 20, 10, 4679, 362, 627, 268, 300, 239, 278, 0, 333, 72, 0, 0, 49, 191, "orc_clan", 300, 0, 0, "LAST_HIT", 0, 0, 0, "fighter"),
(20667, 20667, "Farcran", 0, "", 0, "Monster.crimson_bear", 19, 36, 53, "male", "L2Monster", 40, 2481, 923, 10.27, 2.45, 40, 43, 30, 21, 20, 10, 4813, 378, 602, 304, 319, 247, 278, 0, 333, 0, 0, 0, 40, 191, "NULL", 0, 0, 0, "LAST_HIT", 0, 0, 0, "fighter"),
(20668, 20668, "Grave Guard", 0, "", 0, "Monster.gargoyle", 16, 50, 54, "male", "L2Monster", 40, 2562, 955, 10.27, 2.45, 40, 43, 30, 21, 20, 10, 4283, 341, 578, 344, 339, 254, 278, 500, 333, 0, 0, 0, 140, 174, "NULL", 0, 0, 0, "LAST_HIT", 0, 0, 0, "fighter"),
(20669, 20669, "Taik Orc Supply Leader", 0, "", 0, "Monster.ketra_orc_warrior", 12, 24, 55, "male", "L2Monster", 40, 2643, 987, 10.27, 2.45, 40, 43, 30, 21, 20, 10, 5340, 431, 737, 292, 360, 261, 278, 500, 333, 75, 0, 0, 36, 174, "orc_clan", 300, 0, 0, "LAST_HIT", 0, 0, 0, "fighter"),
(20670, 20670, "Crimson Drake", 0, "", 0, "Monster.drake", 30, 100, 61, "male", "L2Monster", 40, 3137, 1184, 11.85, 2.78, 40, 43, 30, 21, 20, 10, 5465, 481, 992, 344, 505, 307, 278, 500, 333, 0, 0, 0, 70, 174, "NULL", 0, 0, 0, "LAST_HIT", 0, 0, 0, "fighter"),
(20671, 20671, "Kadios", 0, "", 0, "Monster.devastator", 35, 35, 62, "male", "L2Monster", 40, 3219, 1217, 11.85, 2.78, 40, 43, 30, 21, 20, 10, 5702, 508, 1038, 353, 532, 315, 278, 500, 333, 0, 0, 0, 25, 174, "NULL", 0, 0, 0, "LAST_HIT", 0, 0, 0, "fighter"),
(20672, 20672, "Trives", 0, "", 0, "Monster.serpent_slave", 17, 46, 63, "male", "L2Monster", 40, 3302, 1251, 11.85, 2.78, 40, 43, 30, 21, 20, 10, 5772, 521, 897, 438, 560, 323, 278, 0, 333, 127, 0, 0, 70, 174, "NULL", 0, 0, 0, "LAST_HIT", 0, 0, 0, "fighter"),
(20673, 20673, "Falibati", 0, "", 0, "Monster.cave_maiden", 25, 65, 64, "female", "L2Monster", 40, 3384, 1285, 11.85, 2.78, 40, 43, 30, 21, 20, 10, 6016, 551, 938, 449, 589, 331, 278, 500, 333, 73, 0, 0, 70, 174, "NULL", 0, 0, 0, "LAST_HIT", 0, 0, 0, "fighter"),
(20674, 20674, "Doom Knight", 0, "", 0, "Monster.death_blader", 15, 45, 65, "male", "L2Monster", 40, 3465, 1319, 11.85, 2.78, 40, 43, 30, 21, 20, 10, 8649, 804, 1184, 380, 619, 340, 278, 500, 333, 1472, 0, 0, 100, 174, "doom_clan", 300, 1, 10, "LAST_HIT", 0, 0, 0, "fighter"),
(20675, 20675, "Tairim", 0, "", 0, "Monster.will_o_wisp", 13, 22, 50, "male", "L2Monster", 40, 2245, 830, 8.69, 2.14, 40, 43, 30, 21, 20, 10, 3817, 288, 463, 306, 264, 226, 278, 0, 333, 0, 0, 0, 88, 191, "NULL", 0, 0, 0, "LAST_HIT", 0, 0, 0, "fighter"),
(20676, 20676, "Judge of Marsh", 0, "", 0, "Monster.hanged_man_ripper", 35, 80, 65, "male", "L2Monster", 40, 3465, 1319, 11.85, 2.78, 40, 43, 30, 21, 20, 10, 6205, 577, 1184, 380, 619, 340, 278, 500, 333, 0, 0, 0, 60, 191, "NULL", 0, 0, 0, "LAST_HIT", 0, 0, 0, "fighter"),
(20677, 20677, "Tulben", 0, "", 0, "Monster.vampire_bat", 10, 33.5, 66, "male", "L2Monster", 40, 3546, 1353, 11.85, 2.78, 40, 43, 30, 21, 20, 10, 6968, 656, 1123, 428, 649, 348, 278, 0, 333, 0, 0, 0, 66, 191, "NULL", 0, 0, 0, "LAST_HIT", 0, 0, 0, "fighter"),
(20678, 20678, "Tortured Undead", 0, "", 0, "Monster.hungry_spirit", 30, 40, 53, "male", "L2Monster", 40, 2481, 923, 10.27, 2.45, 40, 43, 30, 21, 20, 10, 4085, 321, 662, 276, 319, 247, 278, 0, 333, 0, 0, 0, 15, 174, "NULL", 0, 1, 0, "LAST_HIT", 0, 0, 0, "fighter"),
(20679, 20679, "Marsh Stalker", 0, "", 0, "Monster.gargoyle", 16, 50, 54, "male", "L2Monster", 40, 2562, 955, 10.27, 2.45, 40, 43, 30, 21, 20, 10, 4199, 335, 636, 313, 339, 254, 278, 0, 333, 0, 0, 0, 140, 174, "NULL", 0, 0, 0, "LAST_HIT", 0, 0, 0, "fighter"),
(20680, 20680, "Marsh Drake", 0, "", 0, "Monster.drake", 30, 100, 55, "male", "L2Monster", 40, 2643, 987, 10.27, 2.45, 40, 43, 30, 21, 20, 10, 4443, 359, 737, 292, 360, 261, 278, 500, 333, 0, 0, 0, 70, 174, "NULL", 0, 0, 0, "LAST_HIT", 0, 0, 0, "fighter"),
(20681, 20681, "Vanor Silenos", 0, "", 0, "Monster.heltor_silenos", 13, 29, 45, "male", "L2Monster", 40, 1870, 677, 8.69, 2.14, 40, 43, 30, 21, 20, 10, 3092, 215, 377, 238, 188, 193, 278, 0, 333, 88, 0, 0, 37, 191, "silenos_clan", 300, 0, 0, "LAST_HIT", 0, 0, 0, "fighter"),
(20682, 20682, "Vanor Silenos Grunt", 0, "", 0, "Monster.heltor_silenos", 13, 29, 46, "male", "L2Monster", 40, 1943, 707, 8.69, 2.14, 40, 43, 30, 21, 20, 10, 3077, 218, 401, 245, 202, 199, 278, 0, 333, 158, 18, 0, 37, 191, "silenos_clan", 300, 0, 0, "LAST_HIT", 0, 0, 0, "fighter"),
(20683, 20683, "Vanor Silenos Scout", 0, "", 0, "Monster.heltor_silenos", 13, 29, 47, "male", "L2Monster", 40, 2016, 738, 8.69, 2.14, 40, 43, 30, 21, 20, 10, 4004, 287, 388, 279, 216, 206, 278, 500, 333, 5, 0, 0, 37, 191, "silenos_clan", 400, 0, 0, "LAST_HIT", 0, 0, 0, "fighter"),
(20684, 20684, "Vanor Silenos Warrior", 0, "", 0, "Monster.heltor_silenos_warrior", 13, 31, 48, "male", "L2Monster", 40, 2091, 768, 8.69, 2.14, 40, 43, 30, 21, 20, 10, 4188, 306, 498, 238, 231, 212, 278, 0, 333, 160, 0, 0, 39, 191, "silenos_clan", 300, 0, 0, "LAST_HIT", 0, 0, 0, "fighter"),
(20685, 20685, "Vanor Silenos Shaman", 0, "", 0, "Monster.heltor_silenos_shaman", 13, 32, 49, "male", "L2Monster", 40, 2168, 799, 8.69, 2.14, 40, 43, 30, 21, 20, 10, 3492, 258, 529, 245, 247, 219, 278, 0, 333, 9, 0, 0, 31, 191, "silenos_clan", 300, 0, 0, "LAST_HIT", 0, 0, 0, "balanced"),
(20686, 20686, "Vanor Silenos Chieftain", 0, "", 0, "Monster.heltor_silenos_chieftain", 13, 31.5, 50, "male", "L2Monster", 40, 2245, 830, 17.38, 2.14, 40, 43, 30, 21, 20, 10, 3637, 274, 463, 306, 264, 226, 278, 0, 333, 75, 0, 0, 29, 191, "silenos_clan", 300, 0, 0, "LAST_HIT", 0, 0, 0, "fighter"),
(20738, 20738, "Kobold Looter Bepook", 0, "", 0, "Monster.kobold_bi", 15, 24, 13, "male", "L2Monster", 40, 339, 147, 7.9, 1.21, 40, 43, 30, 21, 20, 10, 663, 26, 33, 63, 11, 56, 278, 500, 333, 4, 0, 0, 51, 121, "partisan_clan", 300, 0, 0, "LAST_HIT", 0, 0, 0, "fighter"),
(20739, 20739, "Bepook's Pet", 0, "", 0, "Monster.wolf", 13, 9, 10, "male", "L2Minion", 40, 257, 120, 1.58, 0.91, 40, 43, 30, 21, 20, 10, 439, 14, 27, 50, 8, 49, 278, 0, 333, 0, 0, 0, 26, 121, "partisan_clan", 300, 0, 0, "LAST_HIT", 0, 0, 0, "fighter"),
(20742, 20742, "Mystical Weaver", 0, "", 0, "Monster.magical_weaver", 11, 20, 22, "male", "L2Monster", 40, 611, 242, 5.53, 1.53, 40, 43, 30, 21, 20, 10, 684, 32, 62, 113, 28, 83, 278, 0, 333, 0, 0, 0, 99, 99, "partisan_clan", 300, 0, 0, "LAST_HIT", 0, 0, 0, "fighter"),
(20743, 20743, "Howler", 0, "", 0, "Monster.werewolf", 10, 26, 25, "male", "L2Monster", 40, 728, 287, 5.53, 1.53, 40, 43, 30, 21, 20, 10, 843, 42, 80, 127, 37, 94, 278, 500, 333, 0, 0, 0, 55, 132, "partisan_clan", 300, 0, 0, "LAST_HIT", 0, 0, 0, "fighter"),
(20744, 20744, "Red Eye Vampire Bat", 0, "", 0, "Monster.vampire_bat", 10, 33.5, 22, "male", "L2Monster", 40, 611, 242, 5.53, 1.53, 40, 43, 30, 21, 20, 10, 684, 32, 75, 93, 28, 83, 278, 0, 333, 0, 0, 0, 66, 88, "partisan_clan", 300, 0, 0, "LAST_HIT", 0, 0, 0, "fighter"),
(20745, 20745, "Gigantiops", 0, "", 0, "Monster.ant_soldier", 35, 17, 35, "male", "L2Monster", 40, 1220, 446, 7.11, 1.84, 40, 43, 30, 21, 20, 10, 2681, 159, 174, 186, 89, 137, 278, 500, 333, 0, 0, 0, 80, 174, "ant_clan", 300, 0, 0, "LAST_HIT", 0, 0, 0, "fighter"),
(20746, 20746, "Young Gigantiops", 0, "", 0, "Monster.ant", 26, 15, 31, "male", "L2Minion", 40, 1004, 381, 7.11, 1.84, 40, 43, 30, 21, 20, 10, 2062, 114, 157, 133, 64, 118, 278, 0, 333, 0, 0, 0, 40, 139, "ant_clan", 300, 0, 0, "LAST_HIT", 0, 0, 0, "fighter"),
(20747, 20747, "Roxide", 0, "", 0, "Monster.succubus", 10, 36, 32, "female", "L2Monster", 40, 1056, 397, 14.22, 1.84, 40, 43, 30, 21, 20, 10, 1459, 82, 169, 138, 69, 123, 278, 500, 333, 0, 0, 0, 66, 174, "demonic_clan", 300, 0, 0, "LAST_HIT", 0, 0, 0, "fighter"),
(20748, 20748, "Roxide Cohort", 0, "", 0, "Monster.spartoi", 11, 27, 29, "male", "L2Minion", 40, 906, 349, 11.06, 1.53, 40, 43, 30, 21, 20, 10, 1349, 72, 111, 149, 53, 110, 278, 0, 333, 73, 0, 0, 66, 174, "demonic_clan", 300, 1, 0, "LAST_HIT", 0, 0, 0, "fighter"),
(20749, 20749, "Death Fire", 0, "", 0, "Monster.dre_vanul", 14, 36, 32, "male", "L2Monster", 40, 1056, 397, 14.22, 1.84, 40, 43, 30, 21, 20, 10, 1459, 82, 169, 138, 69, 123, 278, 500, 333, 0, 0, 0, 88, 174, "demonic_clan", 300, 0, 0, "LAST_HIT", 0, 0, 0, "fighter"),
(20750, 20750, "Fire Archer", 0, "", 0, "Monster.skeleton_archer", 11, 27, 29, "male", "L2Minion", 500, 906, 349, 11.06, 1.53, 40, 43, 30, 21, 20, 10, 1397, 75, 247, 149, 53, 110, 249, 0, 333, 14, 0, 0, 44, 174, "demonic_clan", 300, 1, 0, "LAST_HIT", 0, 0, 0, "archer"),
(20751, 20751, "Snipe", 0, "", 0, "Monster.onyx_beast", 14, 14.5, 44, "male", "L2Monster", 40, 1799, 648, 17.38, 2.14, 40, 43, 30, 21, 20, 10, 3387, 232, 390, 209, 176, 187, 278, 500, 333, 0, 0, 0, 30, 174, "NULL", 0, 0, 0, "LAST_HIT", 0, 0, 0, "fighter"),
(20752, 20752, "Snipe Cohort", 0, "", 0, "Monster.onyx_beast", 14, 14.5, 42, "male", "L2Minion", 40, 1660, 589, 17.38, 2.14, 40, 43, 30, 21, 20, 10, 3290, 219, 283, 237, 152, 175, 278, 0, 333, 0, 0, 0, 30, 174, "NULL", 0, 0, 0, "LAST_HIT", 0, 0, 0, "fighter"),
(20753, 20753, "Dark Lord", 0, "", 0, "Monster.death_blader", 15, 45, 50, "male", "L2Monster", 40, 2245, 830, 17.38, 2.14, 40, 43, 30, 21, 20, 10, 4282, 322, 463, 306, 264, 226, 278, 500, 333, 1472, 0, 0, 100, 174, "undead_clan", 300, 1, 0, "LAST_HIT", 0, 0, 0, "fighter"),
(20754, 20754, "Dark Knight", 0, "", 0, "Monster.death_knight", 12, 31, 48, "male", "L2Monster", 40, 2091, 768, 17.38, 2.14, 40, 43, 30, 21, 20, 10, 4960, 362, 498, 238, 231, 212, 278, 0, 333, 127, 0, 0, 27, 174, "undead_clan", 300, 1, 0, "LAST_HIT", 0, 0, 0, "fighter"),
(20755, 20755, "Talakin", 0, "", 0, "Monster.ol_mahum_champion", 14, 27, 30, "male", "L2Monster", 40, 954, 365, 5.53, 1.53, 40, 43, 30, 21, 20, 10, 1970, 108, 120, 155, 58, 114, 278, 500, 333, 2, 0, 0, 50, 133, "ol_mahum_clan", 300, 0, 0, "LAST_HIT", 0, 0, 0, "fighter"),
(20756, 20756, "Talakin Archer", 0, "", 0, "Monster.ol_mahum_archer", 14, 25, 28, "male", "L2Minion", 500, 859, 334, 5.53, 1.53, 40, 43, 30, 21, 20, 10, 1884, 99, 228, 143, 49, 106, 247, 0, 333, 14, 0, 0, 50, 133, "ol_mahum_clan", 300, 0, 0, "LAST_HIT", 0, 0, 0, "archer"),
(20757, 20757, "Talakin Raider", 0, "", 0, "Monster.ol_mahum", 13.5, 25, 27, "male", "L2Minion", 40, 813, 318, 5.53, 1.53, 40, 43, 30, 21, 20, 10, 1380, 71, 114, 114, 45, 102, 278, 0, 333, 3, 0, 0, 50, 133, "ol_mahum_clan", 300, 0, 0, "LAST_HIT", 0, 0, 0, "fighter"),
(20758, 20758, "Dragon Bearer Chief", 0, "", 0, "Monster.spartoi", 11, 27, 49, "male", "L2Monster", 40, 2168, 799, 8.69, 2.14, 40, 43, 30, 21, 20, 10, 5255, 389, 437, 297, 247, 219, 278, 500, 333, 123, 945, 0, 60, 174, "cave_servant_clan", 300, 1, 0, "LAST_HIT", 0, 0, 0, "fighter"),
(20759, 20759, "Dragon Bearer Warrior", 0, "", 0, "Monster.skeleton", 11, 25, 48, "male", "L2Minion", 40, 2091, 768, 8.69, 2.14, 40, 43, 30, 21, 20, 10, 4944, 361, 498, 238, 231, 212, 278, 0, 333, 2, 945, 0, 60, 174, "cave_servant_clan", 300, 1, 0, "LAST_HIT", 0, 0, 0, "fighter"),
(20760, 20760, "Dragon Bearer Archer", 0, "", 0, "Monster.skeleton_archer", 11, 27, 47, "male", "L2Minion", 500, 2016, 738, 8.69, 2.14, 40, 43, 30, 21, 20, 10, 5137, 368, 862, 279, 216, 206, 247, 0, 333, 14, 0, 0, 40, 174, "cave_servant_clan", 300, 1, 0, "LAST_HIT", 0, 0, 0, "archer"),
(20761, 20761, "Pytan", 0, "", 0, "Monster.bloody_queen", 14, 40, 69, "female", "L2Monster", 40, 3784, 1458, 35.55, 2.78, 40, 43, 30, 21, 20, 10, 6633, 649, 1392, 418, 746, 373, 278, 500, 333, 0, 0, 0, 88, 191, "malruk_clan", 500, 0, 10, "LAST_HIT", 0, 0, 0, "fighter"),
(20762, 20762, "Pytan Knight", 0, "", 0, "Monster.death_blader", 15, 45, 68, "male", "L2Minion", 40, 3706, 1423, 23.7, 2.78, 40, 43, 30, 21, 20, 10, 7021, 678, 1106, 494, 713, 365, 278, 0, 333, 1472, 0, 0, 110, 191, "malruk_clan", 500, 1, 10, "LAST_HIT", 0, 0, 0, "fighter"),
(20763, 20763, "Lord of the Plains", 0, "", 0, "Monster.zenta_lizardman_matriarch", 20, 40, 40, "male", "L2Monster", 40, 1527, 531, 7.11, 1.84, 40, 43, 30, 21, 20, 10, 3869, 250, 217, 222, 131, 164, 317, 500, 333, 221, 0, 0, 53, 174, "lizardman_clan", 300, 0, 0, "LAST_HIT", 0, 0, 0, "fighter"),
(20764, 20764, "Shaman of the Plains", 0, "", 0, "Monster.zenta_lizardman_shaman", 13, 35, 39, "male", "L2Minion", 40, 1462, 514, 7.11, 1.84, 40, 43, 30, 21, 20, 10, 3457, 220, 231, 214, 121, 158, 278, 0, 333, 179, 0, 0, 43, 174, "lizardman_clan", 300, 0, 0, "LAST_HIT", 0, 0, 0, "balanced"),
(20765, 20765, "Warrior of the Plains", 0, "", 0, "Monster.zenta_lizardman_warrior", 13, 35, 38, "male", "L2Minion", 40, 1400, 497, 7.11, 1.84, 40, 43, 30, 21, 20, 10, 2992, 187, 261, 171, 112, 153, 278, 0, 333, 16, 0, 0, 40, 174, "lizardman_clan", 300, 0, 0, "LAST_HIT", 0, 0, 0, "fighter"),
(20766, 20766, "Scout of the Plains", 0, "", 0, "Monster.zenta_lizardman_scout", 11, 30, 36, "male", "L2Minion", 500, 1279, 463, 7.11, 1.84, 40, 43, 30, 21, 20, 10, 2659, 161, 417, 193, 96, 142, 247, 0, 333, 14, 0, 0, 37, 174, "lizardman_clan", 300, 0, 0, "LAST_HIT", 0, 0, 0, "fighter"),
(20767, 20767, "Timak Orc Troop Leader", 0, "", 0, "Monster.batur_orc_overlord", 12, 24, 45, "male", "L2Monster", 40, 1870, 677, 8.69, 2.14, 40, 43, 30, 21, 20, 10, 4801, 334, 415, 216, 188, 193, 278, 0, 333, 79, 0, 0, 80, 174, "orc_clan", 300, 0, 3, "LAST_HIT", 0, 0, 0, "fighter"),
(20768, 20768, "Timak Orc Troop Shaman", 0, "", 0, "Monster.batur_orc_shaman", 11, 16, 44, "male", "L2Minion", 40, 1799, 648, 8.69, 2.14, 40, 43, 30, 21, 20, 10, 4632, 317, 390, 209, 176, 187, 278, 0, 333, 7, 0, 0, 50, 174, "orc_clan", 300, 0, 3, "LAST_HIT", 0, 0, 0, "balanced"),
(20769, 20769, "Timak Orc Troop Warrior", 0, "", 0, "Monster.batur_orc_warrior", 10, 20, 43, "male", "L2Minion", 40, 1728, 618, 8.69, 2.14, 40, 43, 30, 21, 20, 10, 3684, 249, 365, 202, 163, 181, 278, 0, 333, 123, 19, 0, 80, 174, "orc_clan", 300, 0, 2, "LAST_HIT", 0, 0, 0, "fighter"),
(20770, 20770, "Timak Orc Troop Archer", 0, "", 0, "Monster.batur_orc_archer", 11, 21.5, 41, "male", "L2Minion", 500, 1593, 560, 8.69, 2.14, 40, 43, 30, 21, 20, 10, 4319, 283, 713, 189, 141, 169, 247, 0, 333, 13, 0, 0, 45, 174, "orc_clan", 300, 0, 2, "LAST_HIT", 0, 0, 0, "archer"),
(20771, 20771, "Barif", 0, "", 0, "Monster.lesser_giant_mage", 21, 44, 64, "male", "L2Monster", 40, 3384, 1285, 23.7, 2.78, 40, 43, 30, 21, 20, 10, 6515, 596, 938, 449, 589, 331, 278, 500, 333, 3938, 0, 0, 16, 198, "giant_clan", 400, 0, 0, "LAST_HIT", 0, 0, 0, "mage"),
(20772, 20772, "Barif's Pet", 0, "", 0, "Monster.leogul", 15, 35, 61, "male", "L2Minion", 40, 3137, 1184, 23.7, 2.78, 40, 43, 30, 21, 20, 10, 6332, 557, 992, 344, 505, 307, 278, 0, 333, 0, 0, 0, 88, 187, "giant_clan", 300, 0, 0, "LAST_HIT", 0, 0, 0, "fighter"),
(20773, 20773, "Conjurer Bat Lord", 0, "", 0, "Monster.vampire_bat", 10, 33.5, 72, "male", "L2Monster", 40, 4013, 1565, 13.43, 3.09, 40, 43, 30, 21, 20, 10, 10535, 1070, 1284, 540, 849, 399, 278, 500, 333, 0, 0, 0, 60, 174, "giant_clan", 300, 0, 0, "LAST_HIT", 0, 0, 0, "balanced"),
(20774, 20774, "Conjurer Bat ", 0, "", 0, "Monster.vampire_bat", 10, 33.5, 70, "male", "L2Minion", 40, 3862, 1493, 11.85, 2.78, 40, 43, 30, 21, 20, 10, 11140, 1105, 1194, 517, 780, 382, 278, 0, 333, 0, 0, 0, 60, 174, "giant_clan", 300, 0, 0, "LAST_HIT", 0, 0, 0, "balanced"),
(20775, 20775, "Bugbear Raider", 0, "", 0, "Monster.bugbear", 17, 35, 17, "male", "L2Monster", 40, 446, 184, 3.95, 1.21, 40, 43, 30, 21, 20, 10, 599, 25, 48, 75, 17, 67, 278, 0, 333, 0, 0, 0, 60, 143, "NULL", 0, 0, 0, "LAST_HIT", 0, 0, 0, "fighter"),
(20776, 20776, "Dark Succubus", 0, "", 0, "Monster.succubus", 10, 36, 20, "female", "L2Monster", 40, 541, 213, 3.95, 1.21, 40, 43, 30, 21, 20, 10, 783, 35, 57, 94, 23, 76, 278, 0, 333, 0, 0, 0, 66, 110, "NULL", 0, 0, 0, "LAST_HIT", 0, 0, 0, "fighter"),
(20777, 20777, "Hunter Bear", 0, "", 0, "Monster.grizzly", 21, 40, 14, "male", "L2Monster", 40, 364, 156, 3.95, 1.21, 40, 43, 30, 21, 20, 10, 498, 19, 37, 66, 12, 59, 278, 0, 333, 0, 0, 0, 44, 121, "NULL", 0, 0, 0, "LAST_HIT", 0, 0, 0, "fighter"),
(20778, 20778, "Ragna Orc Overlord", 0, "", 0, "Monster.orc_champion", 10, 23, 39, "male", "L2Monster", 40, 1462, 514, 7.11, 1.84, 40, 43, 30, 21, 20, 10, 2477, 157, 231, 214, 121, 158, 278, 0, 333, 2, 0, 0, 49, 191, "orc_clan", 300, 0, 0, "LAST_HIT", 0, 0, 0, "fighter"),
(20779, 20779, "Ragna Orc Seer", 0, "", 0, "Monster.orc_shaman", 9, 22, 39, "male", "L2Monster", 40, 1462, 514, 7.11, 1.84, 40, 43, 30, 21, 20, 10, 2212, 141, 231, 214, 121, 158, 278, 0, 333, 7, 0, 0, 49, 191, "orc_clan", 300, 0, 0, "LAST_HIT", 0, 0, 0, "balanced"),
(20780, 20780, "Bloody Axe Elite", 0, "", 0, "Monster.ol_mahum_champion", 14, 27, 35, "male", "L2Monster", 40, 1220, 446, 7.11, 1.84, 40, 43, 30, 21, 20, 10, 1799, 106, 174, 186, 89, 137, 278, 500, 333, 2, 0, 0, 50, 174, "NULL", 0, 0, 0, "LAST_HIT", 0, 0, 0, "fighter"),
(20781, 20781, "Delu Lizardman Shaman", 0, "", 0, "Monster.virud_lizardman_shaman", 10, 29, 35, "male", "L2Monster", 40, 1220, 446, 7.11, 1.84, 40, 43, 30, 21, 20, 10, 1781, 105, 211, 154, 89, 137, 278, 0, 333, 7, 0, 0, 43, 174, "lizardman_clan", 300, 0, 0, "LAST_HIT", 0, 0, 0, "balanced"),
(20782, 20782, "Ol Mahum Novice", 0, "", 0, "Monster.ol_mahum", 13.5, 25, 17, "male", "L2Monster", 40, 446, 184, 3.95, 1.21, 40, 43, 30, 21, 20, 10, 618, 26, 44, 83, 17, 67, 278, 500, 333, 1, 0, 0, 50, 110, "ol_mahum_clan", 300, 0, 0, "LAST_HIT", 0, 0, 0, "fighter"),
(20783, 20783, "Dread Wolf", 0, "", 0, "Monster.dire_wolf", 13, 11, 35, "male", "L2Monster", 40, 1220, 446, 3.56, 1.84, 40, 43, 30, 21, 20, 10, 1635, 96, 256, 127, 89, 137, 278, 500, 333, 0, 0, 0, 24, 140, "NULL", 0, 0, 0, "LAST_HIT", 0, 0, 0, "fighter"),
(20784, 20784, "Tasaba Lizardman", 0, "", 0, "Monster.virud_lizardman_scout", 10, 22, 36, "male", "L2Monster", 500, 1279, 463, 3.56, 1.84, 40, 43, 30, 21, 20, 10, 1852, 112, 505, 159, 96, 142, 247, 0, 333, 2507, 0, 0, 43, 140, "lizardman_clan1", 300, 0, 0, "LAST_HIT", 0, 0, 0, "fighter"),
(20785, 20785, "Tasaba Lizardman Shaman", 0, "", 0, "Monster.virud_lizardman_shaman", 10, 29, 37, "male", "L2Monster", 40, 1338, 480, 3.56, 1.84, 40, 43, 30, 21, 20, 10, 1791, 110, 244, 140, 104, 147, 278, 0, 333, 7, 0, 0, 43, 140, "lizardman_clan1", 300, 0, 0, "LAST_HIT", 0, 0, 0, "balanced"),
(20786, 20786, "Lienrik", 0, "", 0, "Monster.lienrik", 12, 50, 39, "male", "L2Monster", 40, 1462, 514, 3.56, 1.84, 40, 43, 30, 21, 20, 10, 1990, 126, 297, 146, 121, 158, 317, 0, 333, 0, 0, 0, 100, 150, "lienrik_clan", 300, 0, 0, "LAST_HIT", 0, 0, 0, "fighter"),
(20787, 20787, "Lienrik Lad", 0, "", 0, "Monster.lienrik", 12, 50, 40, "male", "L2Monster", 40, 1527, 531, 3.56, 1.84, 40, 43, 30, 21, 20, 10, 2421, 156, 317, 151, 131, 164, 317, 500, 333, 0, 0, 0, 110, 191, "lienrik_clan", 300, 0, 0, "LAST_HIT", 0, 0, 0, "fighter"),
(20788, 20788, "Rakul", 0, "", 0, "Monster.rakul", 30, 39, 35, "male", "L2Monster", 40, 1220, 446, 7.11, 1.84, 40, 43, 30, 21, 20, 10, 2120, 125, 192, 169, 89, 137, 278, 0, 333, 3, 0, 0, 60, 174, "NULL", 0, 1, 0, "LAST_HIT", 0, 0, 0, "fighter"),
(20789, 20789, "Crokian", 0, "", 0, "Monster.crokian", 18, 29, 36, "male", "L2Monster", 40, 1279, 463, 7.11, 1.84, 40, 43, 30, 21, 20, 10, 1999, 121, 187, 193, 96, 142, 278, 500, 333, 5128, 0, 0, 18, 174, "croc_clan", 300, 0, 0, "LAST_HIT", 0, 0, 0, "fighter"),
(20790, 20790, "Dailaon", 0, "", 0, "Monster.dailaon", 20, 28, 37, "male", "L2Monster", 500, 1338, 480, 7.11, 1.84, 40, 43, 30, 21, 20, 10, 2567, 158, 448, 200, 104, 147, 247, 0, 333, 5127, 0, 0, 18, 174, "croc_clan", 300, 0, 0, "LAST_HIT", 0, 0, 0, "fighter"),
(20791, 20791, "Crokian Warrior", 0, "", 0, "Monster.crokian", 18, 29, 38, "male", "L2Monster", 40, 1400, 497, 14.22, 1.84, 40, 43, 30, 21, 20, 10, 2211, 138, 261, 171, 112, 153, 278, 500, 333, 5128, 0, 0, 18, 174, "croc_clan", 300, 0, 0, "LAST_HIT", 0, 0, 0, "fighter"),
(20792, 20792, "Farhite", 0, "", 0, "Monster.farhite", 16, 31, 39, "male", "L2Monster", 40, 1462, 514, 14.22, 1.84, 40, 43, 30, 21, 20, 10, 2057, 131, 280, 150, 121, 158, 278, 0, 333, 5131, 0, 0, 15, 174, "croc_clan", 300, 0, 0, "LAST_HIT", 0, 0, 0, "fighter"),
(20793, 20793, "Nos", 0, "", 0, "Monster.nos", 26, 42, 40, "male", "L2Monster", 40, 1527, 531, 14.22, 1.84, 40, 43, 30, 21, 20, 10, 2251, 145, 300, 183, 131, 164, 278, 500, 333, 5130, 0, 0, 18, 174, "croc_clan", 300, 0, 2, "LAST_HIT", 0, 0, 0, "fighter"),
(20794, 20794, "Blade Stakato", 0, "", 0, "Monster.blade_stakato", 15, 36, 41, "male", "L2Monster", 40, 1593, 560, 17.38, 2.14, 40, 43, 30, 21, 20, 10, 2103, 137, 265, 229, 141, 169, 278, 0, 333, 223, 0, 0, 27, 191, "stakato_clan", 300, 0, 2, "LAST_HIT", 0, 0, 0, "fighter"),
(20795, 20795, "Blade Stakato Worker", 0, "", 0, "Monster.blade_stakato_worker", 13, 40, 42, "male", "L2Monster", 40, 1660, 589, 17.38, 2.14, 40, 43, 30, 21, 20, 10, 1988, 132, 272, 215, 152, 175, 317, 0, 333, 226, 0, 0, 27, 191, "stakato_clan", 300, 0, 2, "LAST_HIT", 0, 0, 0, "fighter"),
(20796, 20796, "Blade Stakato Warrior", 0, "", 0, "Monster.blade_stakato_soldier", 15, 38, 43, "male", "L2Monster", 40, 1728, 618, 17.38, 2.14, 40, 43, 30, 21, 20, 10, 2125, 143, 365, 202, 163, 181, 278, 500, 333, 232, 0, 0, 27, 191, "stakato_clan", 300, 0, 2, "LAST_HIT", 0, 0, 0, "fighter"),
(20797, 20797, "Blade Stakato Drone", 0, "", 0, "Monster.blade_stakato_drone", 15, 39, 44, "male", "L2Monster", 40, 1799, 648, 26.07, 2.14, 40, 43, 30, 21, 20, 10, 2154, 147, 390, 178, 176, 187, 278, 0, 333, 74, 0, 0, 27, 191, "stakato_clan", 300, 0, 3, "LAST_HIT", 0, 0, 0, "fighter"),
(20798, 20798, "Water Giant", 0, "", 0, "Monster.water_giant", 13, 44, 45, "male", "L2Monster", 40, 1870, 677, 17.38, 2.14, 40, 43, 30, 21, 20, 10, 2612, 181, 343, 262, 188, 193, 278, 500, 333, 5132, 0, 0, 38, 191, "NULL", 0, 0, 3, "LAST_HIT", 0, 0, 0, "fighter"),
(20799, 20799, "Queen Undine Lad", 0, "", 0, "Monster.undine", 12, 27, 46, "female", "L2Monster", 40, 1943, 707, 17.38, 2.14, 40, 43, 30, 21, 20, 10, 2630, 186, 442, 190, 202, 199, 278, 0, 333, 0, 0, 0, 66, 191, "NULL", 0, 0, 3, "LAST_HIT", 0, 0, 0, "fighter"),
(20800, 20800, "Eva's Seeker", 0, "", 0, "Monster.field_stalker", 15, 30, 47, "male", "L2Monster", 40, 2016, 738, 17.38, 2.14, 40, 43, 30, 21, 20, 10, 2465, 176, 388, 279, 216, 206, 278, 0, 333, 0, 0, 0, 77, 191, "NULL", 0, 0, 4, "LAST_HIT", 0, 0, 0, "fighter"),
(20801, 20801, "Theeder Piker", 0, "", 0, "Monster.theeder", 9, 32, 48, "male", "L2Monster", 80, 2091, 768, 17.38, 2.14, 40, 43, 30, 21, 20, 10, 2972, 217, 481, 288, 231, 212, 237, 500, 333, 302, 0, 0, 88, 191, "theeder_clan", 300, 0, 4, "LAST_HIT", 0, 0, 0, "fighter"),
(20802, 20802, "Theeder Mage", 0, "", 0, "Monster.theeder", 9, 32, 49, "male", "L2Monster", 40, 2168, 799, 17.38, 2.14, 40, 43, 30, 21, 20, 10, 3025, 223, 529, 208, 247, 219, 278, 0, 333, 192, 0, 0, 88, 191, "theeder_clan", 300, 0, 4, "LAST_HIT", 0, 0, 0, "fighter"),
(20803, 20803, "Doll Master", 0, "", 0, "Monster.doll_master", 20, 42, 50, "male", "L2Monster", 40, 2245, 830, 26.07, 2.14, 40, 43, 30, 21, 20, 10, 3949, 297, 616, 230, 264, 226, 278, 500, 333, 0, 0, 0, 88, 191, "NULL", 0, 1, 5, "LAST_HIT", 0, 0, 0, "fighter"),
(20804, 20804, "Crokian Lad", 0, "", 0, "Monster.crokian_100_bi", 36, 61, 41, "male", "L2Monster", 40, 1593, 560, 17.38, 2.14, 40, 43, 30, 21, 20, 10, 2574, 168, 291, 208, 141, 169, 278, 500, 333, 5128, 0, 0, 18, 174, "croc_clan2", 300, 0, 0, "LAST_HIT", 0, 0, 0, "fighter"),
(20805, 20805, "Dailaon Lad", 0, "", 0, "Monster.dailaon_100_bi", 40, 58, 42, "male", "L2Monster", 500, 1660, 589, 17.38, 2.14, 40, 43, 30, 21, 20, 10, 2790, 186, 762, 196, 152, 175, 247, 0, 333, 5127, 0, 0, 18, 174, "croc_clan2", 300, 0, 0, "LAST_HIT", 0, 0, 0, "fighter"),
(20806, 20806, "Crokian Lad Warrior", 0, "", 0, "Monster.crokian_100_bi", 36, 61, 43, "male", "L2Monster", 40, 1728, 618, 17.38, 2.14, 40, 43, 30, 21, 20, 10, 2678, 181, 365, 202, 163, 181, 278, 500, 333, 5128, 0, 0, 18, 174, "croc_clan2", 300, 0, 0, "LAST_HIT", 0, 0, 0, "fighter"),
(20807, 20807, "Farhite Lad", 0, "", 0, "Monster.farhite_50_bi", 24, 48, 44, "male", "L2Monster", 40, 1799, 648, 17.38, 2.14, 40, 43, 30, 21, 20, 10, 2817, 193, 390, 178, 176, 187, 278, 0, 333, 5131, 0, 0, 15, 174, "croc_clan2", 300, 0, 0, "LAST_HIT", 0, 0, 0, "fighter"),
(20808, 20808, "Nos Lad", 0, "", 0, "Monster.nos_100_bi", 52, 86, 45, "male", "L2Monster", 40, 1870, 677, 17.38, 2.14, 40, 43, 30, 21, 20, 10, 3487, 242, 343, 262, 188, 193, 278, 500, 333, 128, 0, 0, 18, 174, "croc_clan2", 300, 0, 0, "LAST_HIT", 0, 0, 0, "fighter"),
(20809, 20809, "Ghost of the Tower", 0, "", 0, "Monster.human_ghost", 8, 22, 60, "male", "L2Monster", 40, 3054, 1150, 30.81, 2.45, 40, 43, 30, 21, 20, 10, 4045, 351, 860, 368, 478, 299, 278, 500, 333, 0, 0, 0, 80, 143, "tower_ghost_clan", 400, 1, 0, "LAST_HIT", 0, 0, 0, "fighter"),
(20810, 20810, "Seer of Hallate", 0, "", 0, "Monster.field_stalker", 15, 30, 60, "male", "L2Monster", 40, 3054, 1150, 30.81, 2.45, 40, 43, 30, 21, 20, 10, 4045, 351, 946, 335, 478, 299, 278, 500, 333, 0, 0, 0, 70, 170, "hallate_clan", 400, 0, 0, "LAST_HIT", 0, 0, 0, "fighter"),
(20811, 20811, "Ghastly Warrior", 0, "", 0, "Monster.unpleasant_humming", 12, 26, 61, "male", "L2Monster", 40, 3137, 1184, 35.55, 2.78, 40, 43, 30, 21, 20, 10, 4769, 419, 717, 416, 505, 307, 412, 500, 333, 0, 0, 0, 21, 150, "tower_ghost_clan", 400, 1, 0, "LAST_HIT", 0, 0, 0, "balanced"),
(20812, 20812, "Archer of Despair", 0, "", 0, "Monster.skeleton_archer", 11, 27, 61, "male", "L2Monster", 500, 3137, 1184, 35.55, 2.78, 40, 43, 30, 21, 20, 10, 4708, 414, 2204, 292, 505, 307, 247, 500, 333, 284, 0, 0, 40, 160, "tower_ghost_clan", 400, 1, 0, "LAST_HIT", 0, 0, 0, "archer"),
(20813, 20813, "Crendion", 0, "", 0, "Monster.liviona", 15, 28, 62, "male", "L2Monster", 40, 3219, 1217, 35.55, 2.78, 40, 43, 30, 21, 20, 10, 4276, 381, 944, 388, 532, 315, 278, 500, 333, 0, 0, 0, 80, 160, "tower_ghost_clan", 300, 0, 0, "LAST_HIT", 0, 0, 0, "fighter"),
(20814, 20814, "Blader of Despair", 0, "", 0, "Monster.spartoi", 11, 27, 62, "male", "L2Monster", 80, 3219, 1217, 35.55, 2.78, 40, 43, 30, 21, 20, 10, 4938, 440, 1212, 353, 532, 315, 236, 500, 333, 79, 0, 0, 60, 143, "tower_ghost_clan", 400, 1, 0, "LAST_HIT", 0, 0, 0, "fighter"),
(20815, 20815, "Hound Dog of Hallate", 0, "", 0, "Monster.dire_wolf", 13, 11, 63, "male", "L2Monster", 40, 3302, 1251, 47.4, 2.78, 40, 43, 30, 21, 20, 10, 4583, 413, 897, 438, 560, 323, 278, 500, 333, 0, 0, 0, 24, 165, "hallate_clan", 400, 0, 0, "LAST_HIT", 0, 0, 0, "fighter"),
(20816, 20816, "Hallate's Royal Guard", 0, "", 0, "Monster.skeleton_royal_guard", 11, 28.5, 63, "male", "L2Monster", 40, 3302, 1251, 35.55, 2.78, 40, 43, 30, 21, 20, 10, 5098, 460, 785, 438, 560, 323, 317, 500, 333, 946, 945, 0, 80, 164, "hallate_clan", 400, 1, 0, "LAST_HIT", 0, 0, 0, "balanced"),
(20817, 20817, "Corrupt Sage", 0, "", 0, "Monster.vale_master", 12, 40, 64, "male", "L2Monster", 40, 3384, 1285, 35.55, 2.78, 40, 43, 30, 21, 20, 10, 5315, 486, 1135, 315, 589, 331, 278, 500, 333, 210, 0, 0, 77, 176, "tower_ghost_clan", 400, 0, 0, "LAST_HIT", 0, 0, 0, "fighter"),
(20818, 20818, "Hallate's Warrior", 0, "", 0, "Monster.skeleton_knight", 10, 25, 64, "male", "L2Monster", 40, 3384, 1285, 35.55, 2.78, 40, 43, 30, 21, 20, 10, 4926, 451, 1135, 371, 589, 331, 278, 500, 333, 78, 0, 0, 44, 176, "hallate_clan", 400, 1, 0, "LAST_HIT", 0, 0, 0, "fighter"),
(20819, 20819, "Archer of Abyss", 0, "", 0, "Monster.fiend_archer", 17, 55, 65, "male", "L2Monster", 500, 3465, 1319, 35.55, 2.78, 40, 43, 30, 21, 20, 10, 4889, 454, 2632, 380, 619, 340, 249, 500, 333, 0, 0, 0, 77, 181, "tower_ghost_clan", 400, 0, 0, "LAST_HIT", 0, 0, 0, "archer"),
(20820, 20820, "Hallate's Knight", 0, "", 0, "Monster.death_knight", 12, 31, 65, "male", "L2Monster", 40, 3465, 1319, 47.4, 2.78, 40, 43, 30, 21, 20, 10, 7310, 679, 979, 460, 619, 340, 278, 500, 333, 80, 0, 0, 29, 176, "hallate_clan", 400, 1, 0, "LAST_HIT", 0, 0, 0, "fighter"),
(20821, 20821, "Erin Ediunce", 0, "", 0, "Monster.banshee", 9, 23, 66, "female", "L2Monster", 40, 3546, 1353, 47.4, 2.78, 40, 43, 30, 21, 20, 10, 5335, 502, 1020, 401, 649, 348, 278, 500, 333, 3939, 0, 0, 88, 181, "tower_guard_clan", 400, 0, 10, "LAST_HIT", 0, 0, 0, "fighter"),
(20822, 20822, "Hallate's Maid", 0, "", 0, "Monster.bloody_queen", 14, 40, 66, "female", "L2Monster", 40, 3546, 1353, 47.4, 2.78, 40, 43, 30, 21, 20, 10, 4964, 467, 893, 471, 649, 348, 317, 500, 333, 0, 0, 0, 88, 176, "hallate_clan", 400, 0, 0, "LAST_HIT", 0, 0, 0, "balanced"),
(20823, 20823, "Platinum Tribe Soldier", 0, "", 0, "Monster.kel_mahum", 13, 26, 67, "male", "L2Monster", 40, 3626, 1388, 47.4, 2.78, 40, 43, 30, 21, 20, 10, 5764, 549, 1126, 399, 681, 356, 317, 500, 333, 242, 0, 0, 55, 176, "tower_guard_clan", 400, 0, 10, "LAST_HIT", 0, 0, 0, "fighter"),
(20824, 20824, "Hallate's Commander", 0, "", 0, "Monster.death_blader", 15, 45, 67, "male", "L2Monster", 40, 3626, 1388, 47.4, 2.78, 40, 43, 30, 21, 20, 10, 5184, 493, 1286, 399, 681, 356, 278, 500, 333, 1472, 0, 0, 110, 187, "hallate_clan", 400, 1, 0, "LAST_HIT", 0, 0, 0, "fighter"),
(20825, 20825, "Hallate's Inspector", 0, "", 0, "Monster.karik_25_bi", 31, 110, 68, "male", "L2Monster", 40, 3706, 1423, 47.4, 2.78, 40, 43, 30, 21, 20, 10, 5414, 523, 1339, 408, 713, 365, 278, 500, 333, 0, 0, 0, 40, 187, "hallate_clan", 400, 0, 0, "LAST_HIT", 0, 0, 0, "fighter"),
(20826, 20826, "Platinum Tribe Archer", 0, "", 0, "Monster.kel_mahum_archer", 13, 27, 68, "male", "L2Monster", 500, 3706, 1423, 35.55, 2.78, 40, 43, 30, 21, 20, 10, 7650, 739, 2975, 347, 713, 365, 249, 500, 333, 288, 0, 0, 55, 176, "tower_guard_clan", 400, 0, 10, "LAST_HIT", 0, 0, 0, "archer"),
(20827, 20827, "Platinum Tribe Warrior", 0, "", 0, "Monster.kel_mahum_warrior", 13, 28, 69, "male", "L2Monster", 40, 3784, 1458, 47.4, 2.78, 40, 43, 30, 21, 20, 10, 5991, 586, 1150, 506, 746, 373, 278, 500, 333, 148, 0, 0, 55, 176, "tower_guard_clan", 400, 0, 10, "LAST_HIT", 0, 0, 0, "fighter"),
(20828, 20828, "Platinum Tribe Shaman", 0, "", 0, "Monster.kel_mahum_witch_doctor", 13, 25, 70, "male", "L2Monster", 40, 3862, 1493, 59.25, 2.78, 40, 43, 30, 21, 20, 10, 5881, 583, 1445, 427, 780, 382, 278, 500, 333, 202, 0, 0, 55, 176, "tower_guard_clan", 400, 0, 10, "LAST_HIT", 0, 0, 0, "mage"),
(20829, 20829, "Platinum Tribe Overlord", 0, "", 0, "Monster.kel_mahum_champion", 13, 32, 71, "male", "L2Monster", 40, 3938, 1529, 67.15, 3.09, 40, 43, 30, 21, 20, 10, 8449, 847, 1239, 529, 814, 390, 278, 500, 333, 147, 0, 0, 55, 187, "tower_guard_clan", 400, 0, 10, "LAST_HIT", 0, 0, 0, "balanced"),
(20830, 20830, "Guardian Angel", 0, "", 0, "Monster.angel", 13.5, 36.5, 72, "male", "L2Monster", 40, 4013, 1565, 53.72, 3.09, 40, 43, 30, 21, 20, 10, 0, 0, 1710, 406, 849, 399, 278, 500, 333, 148, 0, 0, 33, 187, "tower_guard_clan", 400, 0, 10, "LAST_HIT", 0, 0, 0, "fighter"),
(20831, 20831, "Seal Angel", 0, "", 0, "Monster.angel", 13.5, 36.5, 73, "male", "L2Monster", 40, 4086, 1601, 67.15, 3.09, 40, 43, 30, 21, 20, 10, 0, 0, 1770, 415, 885, 407, 278, 500, 333, 148, 0, 0, 30, 170, "tower_guard_clan", 400, 0, 10, "LAST_HIT", 0, 0, 0, "fighter"),
(20832, 20832, "Zaken's Pikeman", 0, "", 0, "Monster.skeleton_pikeman", 10, 28, 43, "male", "L2Monster", 40, 1728, 618, 8.69, 2.14, 40, 43, 30, 21, 20, 10, 2720, 184, 249, 252, 163, 181, 278, 500, 333, 292, 0, 0, 50, 174, "undead_clan1", 300, 1, 0, "LAST_HIT", 0, 0, 0, "balanced"),
(20833, 20833, "Zaken's Archer", 0, "", 0, "Monster.skeleton_archer", 11, 27, 44, "male", "L2Monster", 500, 1799, 648, 8.69, 2.14, 40, 43, 30, 21, 20, 10, 3025, 207, 592, 260, 176, 187, 247, 0, 333, 279, 0, 0, 40, 174, "undead_clan1", 300, 1, 0, "LAST_HIT", 0, 0, 0, "archer"),
(20834, 20834, "Mardian", 0, "", 0, "Monster.giant_spider", 26, 25.5, 42, "male", "L2Monster", 40, 1660, 589, 17.38, 2.14, 40, 43, 30, 21, 20, 10, 2251, 150, 342, 196, 152, 175, 278, 500, 333, 0, 0, 0, 79, 191, "NULL", 0, 0, 0, "LAST_HIT", 0, 0, 0, "fighter"),
(20835, 20835, "Zaken's Seer", 0, "", 0, "Monster.liviona", 15, 28, 45, "male", "L2Monster", 40, 1870, 677, 8.69, 2.14, 40, 43, 30, 21, 20, 10, 2478, 172, 283, 269, 188, 193, 278, 500, 333, 0, 0, 0, 80, 174, "NULL", 0, 0, 0, "LAST_HIT", 0, 0, 0, "balanced"),
(20836, 20836, "Pirate Zombie", 0, "", 0, "Monster.pirates_zombie", 10, 23, 44, "male", "L2Monster", 40, 1799, 648, 17.38, 2.14, 40, 43, 30, 21, 20, 10, 2832, 194, 341, 209, 176, 187, 317, 0, 333, 225, 0, 0, 11, 174, "undead_clan1", 300, 1, 0, "LAST_HIT", 0, 0, 0, "fighter"),
(20837, 20837, "Tainted Ogre", 0, "", 0, "Monster.ogre", 21, 44, 45, "male", "L2Monster", 40, 1870, 677, 17.38, 2.14, 40, 43, 30, 21, 20, 10, 2565, 178, 577, 216, 188, 193, 200, 500, 333, 194, 0, 0, 24, 191, "undead_clan1", 300, 0, 0, "LAST_HIT", 0, 0, 0, "fighter"),
(20838, 20838, "Bloody Bat", 0, "", 0, "Monster.vampire_bat", 10, 33.5, 45, "male", "L2Monster", 40, 1870, 677, 17.38, 2.14, 40, 43, 30, 21, 20, 10, 2405, 167, 300, 262, 188, 193, 317, 0, 333, 0, 0, 0, 66, 191, "NULL", 0, 0, 0, "LAST_HIT", 0, 0, 0, "fighter"),
(20839, 20839, "Unpleasant Humming", 0, "", 0, "Monster.unpleasant_humming", 12, 26, 46, "male", "L2Monster", 40, 1943, 707, 8.69, 2.14, 40, 43, 30, 21, 20, 10, 2877, 204, 301, 327, 202, 199, 278, 500, 333, 0, 0, 0, 21, 174, "undead_clan", 300, 1, 3, "LAST_HIT", 0, 0, 0, "balanced"),
(20840, 20840, "Death Flyer", 0, "", 0, "Monster.dark_horror", 20, 35, 47, "male", "L2Monster", 40, 2016, 738, 8.69, 2.14, 40, 43, 30, 21, 20, 10, 2971, 213, 320, 287, 216, 206, 278, 0, 333, 0, 0, 0, 100, 174, "undead_clan", 300, 1, 4, "LAST_HIT", 0, 0, 0, "balanced"),
(20841, 20841, "Fiend Archer", 0, "", 0, "Monster.fiend_archer", 17, 55, 48, "male", "L2Monster", 500, 2091, 768, 8.69, 2.14, 40, 43, 30, 21, 20, 10, 3052, 223, 757, 296, 231, 212, 247, 500, 333, 0, 0, 0, 70, 174, "demonic_clan", 300, 0, 4, "LAST_HIT", 0, 0, 0, "archer"),
(20842, 20842, "Musveren", 0, "", 0, "Monster.field_stalker", 15, 30, 49, "male", "L2Monster", 40, 2168, 799, 8.69, 2.14, 40, 43, 30, 21, 20, 10, 2910, 215, 361, 359, 247, 219, 278, 0, 333, 0, 0, 0, 70, 174, "undead_clan", 300, 0, 4, "LAST_HIT", 0, 0, 0, "balanced"),
(20843, 20843, "Zaken's Royal Guard", 0, "", 0, "Monster.skeleton_royal_guard", 11, 28.5, 50, "male", "L2Monster", 40, 2245, 830, 8.69, 2.14, 40, 43, 30, 21, 20, 10, 3677, 277, 335, 370, 264, 226, 317, 500, 333, 225, 945, 0, 80, 174, "undead_clan", 300, 1, 5, "LAST_HIT", 0, 0, 0, "balanced"),
(20844, 20844, "Kaim Vanul", 0, "", 0, "Monster.kaim_vanul", 24, 40, 51, "male", "L2Monster", 40, 2323, 861, 10.27, 2.45, 40, 43, 30, 21, 20, 10, 3279, 250, 405, 381, 281, 232, 278, 0, 333, 0, 0, 0, 37, 174, "demonic_clan", 300, 0, 5, "LAST_HIT", 0, 0, 0, "balanced"),
(20845, 20845, "Pirate's Zombie Captain", 0, "", 0, "Monster.pirates_zombie_captain", 17, 28, 52, "male", "L2Monster", 40, 2402, 892, 10.27, 2.45, 40, 43, 30, 21, 20, 10, 4954, 383, 375, 393, 300, 239, 317, 500, 333, 232, 0, 0, 14, 174, "zaken_clan", 300, 1, 5, "LAST_HIT", 0, 0, 0, "balanced"),
(20846, 20846, "Doll Blader", 0, "", 0, "Monster.doll_blader", 6, 12, 53, "male", "L2Monster", 40, 2481, 923, 10.27, 2.45, 40, 43, 30, 21, 20, 10, 3931, 309, 396, 344, 319, 247, 317, 0, 333, 5129, 5129, 0, 22, 174, "zaken_clan", 300, 0, 6, "LAST_HIT", 0, 0, 0, "balanced"),
(20847, 20847, "Vale Master", 0, "", 0, "Monster.vale_master", 12, 40, 54, "male", "L2Monster", 40, 2562, 955, 10.27, 2.45, 40, 43, 30, 21, 20, 10, 3750, 299, 477, 354, 339, 254, 278, 500, 333, 0, 0, 0, 70, 174, "zaken_clan", 300, 0, 6, "LAST_HIT", 0, 0, 0, "balanced"),
(20848, 20848, "Light Bringer", 0, "", 0, "Monster.light_bringer", 10, 23, 46, "male", "L2Monster", 40, 1943, 707, 17.38, 2.14, 40, 43, 30, 21, 20, 10, 2432, 172, 401, 245, 202, 199, 278, 500, 333, 0, 0, 0, 60, 174, "NULL", 0, 0, 3, "LAST_HIT", 0, 0, 0, "fighter"),
(20849, 20849, "Light Worm", 0, "", 0, "Monster.light_worm", 5, 16, 41, "male", "L2Monster", 40, 1593, 560, 17.38, 2.14, 40, 43, 30, 21, 20, 10, 1932, 126, 265, 229, 141, 169, 278, 500, 333, 0, 0, 0, 66, 191, "NULL", 0, 0, 2, "LAST_HIT", 0, 0, 0, "fighter"),
(20850, 20850, "Golden Stag Lord", 0, "", 0, "Monster.golden_stag_lord", 25, 30, 50, "male", "L2Monster", 40, 2245, 830, 8.69, 2.14, 40, 43, 30, 21, 20, 10, 3152, 237, 509, 278, 264, 226, 278, 0, 333, 0, 0, 0, 38, 191, "NULL", 0, 0, 0, "LAST_HIT", 0, 0, 0, "fighter"),
(20851, 20851, "Theeder", 0, "", 0, "Monster.theeder", 9, 32, 47, "male", "L2Monster", 40, 2016, 738, 8.69, 2.14, 40, 43, 30, 21, 20, 10, 2841, 204, 498, 253, 216, 206, 237, 500, 333, 0, 0, 0, 88, 191, "NULL", 0, 0, 0, "LAST_HIT", 0, 0, 0, "fighter"),
(20852, 20852, "Banshee", 0, "", 0, "Monster.banshee", 9, 23, 60, "female", "L2Monster", 40, 3054, 1150, 10.27, 2.45, 40, 43, 30, 21, 20, 10, 4450, 386, 828, 335, 478, 299, 317, 500, 333, 3939, 0, 0, 88, 191, "NULL", 0, 0, 0, "LAST_HIT", 0, 0, 0, "fighter"),
(20853, 20853, "Kel Mahum", 0, "", 0, "Monster.kel_mahum", 13, 26, 65, "male", "L2Monster", 40, 3465, 1319, 11.85, 2.78, 40, 43, 30, 21, 20, 10, 7824, 727, 942, 418, 619, 340, 317, 500, 333, 242, 0, 0, 55, 191, "kel_mahum_clan", 300, 0, 0, "LAST_HIT", 0, 0, 0, "balanced"),
(20854, 20854, "Kel Mahum Warrior", 0, "", 0, "Monster.kel_mahum_warrior", 13, 28, 66, "male", "L2Monster", 40, 3546, 1353, 11.85, 2.78, 40, 43, 30, 21, 20, 10, 7686, 723, 1235, 389, 649, 348, 278, 500, 333, 148, 0, 0, 55, 191, "kel_mahum_clan", 300, 0, 0, "LAST_HIT", 0, 0, 0, "fighter"),
(20855, 20855, "Kel Mahum Archer", 0, "", 0, "Monster.kel_mahum_archer", 13, 27, 67, "male", "L2Monster", 500, 3626, 1388, 11.85, 2.78, 40, 43, 30, 21, 20, 10, 8900, 848, 2859, 339, 681, 356, 249, 0, 333, 288, 0, 0, 55, 191, "kel_mahum_clan", 300, 0, 0, "LAST_HIT", 0, 0, 0, "archer"),
(20856, 20856, "Kel Mahum Shaman", 0, "", 0, "Monster.kel_mahum_witch_doctor", 13, 25, 68, "male", "L2Monster", 40, 3706, 1423, 11.85, 2.78, 40, 43, 30, 21, 20, 10, 6390, 617, 1339, 347, 713, 365, 278, 500, 333, 202, 0, 0, 55, 191, "kel_mahum_clan", 300, 0, 0, "LAST_HIT", 0, 0, 0, "mage"),
(20857, 20857, "Kel Mahum Champion", 0, "", 0, "Monster.kel_mahum_champion", 13, 32, 70, "male", "L2Monster", 40, 3862, 1493, 11.85, 2.78, 40, 43, 30, 21, 20, 10, 8149, 808, 1445, 427, 780, 382, 278, 500, 333, 147, 0, 0, 55, 191, "kel_mahum_clan", 300, 0, 0, "LAST_HIT", 0, 0, 0, "fighter"),
(20858, 20858, "Angel", 0, "", 0, "Monster.angel", 13.5, 36.5, 72, "male", "L2Monster", 40, 4013, 1565, 13.43, 3.09, 40, 43, 30, 21, 20, 10, 9102, 925, 1554, 446, 849, 399, 278, 500, 333, 148, 0, 0, 33, 191, "tower_guard_clan", 300, 0, 0, "LAST_HIT", 0, 0, 0, "fighter"),
(20859, 20859, "Guardian Angel", 0, "", 0, "Monster.angel", 13.5, 36.5, 72, "male", "L2Monster", 40, 4013, 1565, 53.72, 3.09, 40, 43, 30, 21, 20, 10, 12443, 1264, 1554, 446, 849, 399, 278, 500, 333, 148, 0, 0, 33, 187, "tower_guard_clan", 400, 0, 0, "LAST_HIT", 0, 0, 0, "fighter"),
(20860, 20860, "Seal Angel", 0, "", 0, "Monster.angel", 13.5, 36.5, 73, "male", "L2Monster", 40, 4086, 1601, 67.15, 3.09, 40, 43, 30, 21, 20, 10, 13949, 1435, 1330, 552, 885, 407, 278, 500, 333, 148, 0, 0, 33, 187, "tower_guard_clan", 400, 0, 10, "LAST_HIT", 0, 0, 0, "balanced"),
(20861, 20861, "Oel Mahum Champion", 0, "", 0, "Monster.oel_mahum_champion", 23, 61, 56, "male", "L2Monster", 40, 2724, 1019, 10.27, 2.45, 40, 43, 30, 21, 20, 10, 5533, 454, 777, 301, 382, 269, 278, 500, 333, 127, 0, 0, 73, 191, "oel_mahum_clan", 300, 0, 0, "LAST_HIT", 0, 0, 0, "fighter"),
(20862, 20862, "Death Lord", 0, "", 0, "Monster.death_lord", 21, 40, 75, "male", "L2Monster", 40, 4229, 1673, 13.43, 3.09, 40, 43, 30, 21, 20, 10, 7774, 820, 1720, 475, 957, 425, 278, 0, 333, 78, 0, 0, 44, 191, "demonic_clan", 300, 1, 0, "LAST_HIT", 0, 0, 0, "fighter"),
(20919, 20919, "Maille Lizardman", 0, "", 0, "Monster.virud_lizardman", 10, 23, 20, "male", "L2Monster", 40, 541, 213, 1.98, 1.21, 40, 43, 30, 21, 20, 10, 641, 28, 57, 94, 23, 76, 278, 0, 333, 291, 0, 0, 43, 130, "lizardman_clan", 300, 0, 0, "LAST_HIT", 0, 0, 0, "fighter"),
(20920, 20920, "Maille Lizardman Scout", 0, "", 0, "Monster.virud_lizardman_scout", 10, 22, 22, "male", "L2Monster", 500, 611, 242, 2.77, 1.53, 40, 43, 30, 21, 20, 10, 1187, 56, 153, 102, 28, 83, 247, 0, 333, 2507, 0, 0, 43, 130, "lizardman_clan", 300, 0, 0, "LAST_HIT", 0, 0, 0, "fighter"),
(20921, 20921, "Maille Lizardman Guard", 0, "", 0, "Monster.virud_lizardman", 10, 23, 24, "male", "L2Monster", 40, 687, 272, 2.77, 1.53, 40, 43, 30, 21, 20, 10, 858, 42, 81, 111, 34, 90, 278, 500, 333, 291, 0, 0, 43, 130, "lizardman_clan", 300, 0, 0, "LAST_HIT", 0, 0, 0, "fighter"),
(20922, 20922, "Maille Lizardman Warrior", 0, "", 0, "Monster.virud_lizardman_warrior", 12, 30, 26, "male", "L2Monster", 40, 770, 303, 2.77, 1.53, 40, 43, 30, 21, 20, 10, 951, 48, 96, 120, 41, 98, 278, 0, 333, 16, 0, 0, 52, 130, "lizardman_clan", 300, 0, 0, "LAST_HIT", 0, 0, 0, "fighter"),
(20923, 20923, "Maille Lizardman Shaman", 0, "", 0, "Monster.virud_lizardman_shaman", 10, 29, 28, "male", "L2Monster", 40, 859, 334, 2.77, 1.53, 40, 43, 30, 21, 20, 10, 1392, 74, 113, 130, 49, 106, 278, 0, 333, 7, 0, 0, 47, 132, "lizardman_clan", 300, 0, 0, "LAST_HIT", 0, 0, 0, "balanced"),
(20924, 20924, "Maille Lizardman Matriarch", 0, "", 0, "Monster.virud_lizardman_matriarch", 13, 37, 30, "male", "L2Monster", 40, 954, 365, 2.77, 1.53, 40, 43, 30, 21, 20, 10, 1708, 94, 132, 140, 58, 114, 278, 500, 333, 69, 627, 0, 61, 143, "lizardman_clan", 300, 0, 0, "LAST_HIT", 0, 0, 0, "fighter"),
(20925, 20925, "Giant Araneid", 0, "", 0, "Monster.giant_spider", 26, 25.5, 24, "male", "L2Monster", 40, 687, 272, 2.77, 1.53, 40, 43, 30, 21, 20, 10, 875, 44, 81, 94, 34, 90, 278, 0, 333, 0, 0, 0, 72, 130, "lizardman_clan", 300, 0, 0, "LAST_HIT", 0, 0, 0, "fighter"),
(20926, 20926, "Poison Araneid", 0, "", 0, "Monster.poison_spider", 27, 25.5, 25, "male", "L2Monster", 40, 728, 287, 2.77, 1.53, 40, 43, 30, 21, 20, 10, 1012, 50, 88, 98, 37, 94, 278, 0, 333, 0, 0, 0, 60, 140, "lizardman_clan", 300, 0, 0, "LAST_HIT", 0, 0, 0, "fighter"),
(20927, 20927, "King of the Araneid", 0, "", 0, "Monster.giant_spider_50_bi", 39, 38, 27, "male", "L2Monster", 40, 813, 318, 2.77, 1.53, 40, 43, 30, 21, 20, 10, 1453, 74, 104, 106, 45, 102, 278, 500, 333, 0, 0, 0, 72, 130, "lizardman_clan", 300, 0, 0, "LAST_HIT", 0, 0, 0, "fighter"),
(20928, 20928, "Hatu Weird Bee", 0, "", 0, "Monster.giant_bee", 8, 24.5, 30, "male", "L2Minion", 40, 954, 365, 2.77, 1.53, 40, 43, 30, 21, 20, 10, 1468, 80, 132, 140, 58, 114, 278, 500, 333, 0, 0, 0, 99, 132, "hatu_clan", 300, 0, 0, "LAST_HIT", 0, 0, 0, "fighter"),
(20929, 20929, "Hatu Dire Wolf", 0, "", 0, "Monster.dire_wolf", 13, 11, 32, "male", "L2Minion", 40, 1056, 397, 3.56, 1.84, 40, 43, 30, 21, 20, 10, 1393, 78, 154, 151, 69, 123, 278, 0, 333, 0, 0, 0, 26, 121, "hatu_clan", 300, 0, 0, "LAST_HIT", 0, 0, 0, "fighter"),
(20930, 20930, "Hatu Brown Bear", 0, "", 0, "Monster.grizzly", 21, 40, 34, "male", "L2Monster", 40, 1164, 430, 3.56, 1.84, 40, 43, 30, 21, 20, 10, 2195, 128, 178, 163, 82, 132, 278, 500, 333, 0, 0, 0, 44, 157, "hatu_clan", 300, 0, 0, "LAST_HIT", 0, 0, 0, "fighter"),
(20931, 20931, "Hatu Onyx Beast", 0, "", 0, "Monster.onyx_beast", 14, 14.5, 36, "male", "L2Minion", 40, 1279, 463, 3.56, 1.84, 40, 43, 30, 21, 20, 10, 2035, 124, 206, 175, 96, 142, 278, 0, 333, 0, 0, 0, 30, 174, "hatu_clan", 300, 0, 0, "LAST_HIT", 0, 0, 0, "fighter"),
(20932, 20932, "Hatu Crimson Bear", 0, "", 0, "Monster.crimson_bear", 19, 36, 38, "male", "L2Minion", 40, 1400, 497, 3.56, 1.84, 40, 43, 30, 21, 20, 10, 2688, 168, 238, 188, 112, 153, 278, 0, 333, 0, 0, 0, 37, 174, "hatu_clan", 300, 0, 0, "LAST_HIT", 0, 0, 0, "fighter"),
(20933, 20933, "Hatu Windsus", 0, "", 0, "Monster.giant_wild_hog", 35, 27, 40, "male", "L2Monster", 40, 1527, 531, 3.56, 1.84, 40, 43, 30, 21, 20, 10, 3080, 198, 273, 201, 131, 164, 278, 500, 333, 0, 0, 0, 35, 174, "hatu_clan", 300, 0, 0, "LAST_HIT", 0, 0, 0, "fighter"),
(20934, 20934, "Wasp Worker", 0, "", 0, "Monster.giant_bee_bi", 8, 32, 35, "male", "L2Minion", 40, 1220, 446, 3.56, 1.84, 40, 43, 30, 21, 20, 10, 1651, 98, 192, 144, 89, 137, 278, 0, 333, 0, 0, 0, 99, 191, "NULL", 0, 0, 0, "LAST_HIT", 0, 0, 0, "fighter"),
(20935, 20935, "Wasp Leader", 0, "", 0, "Monster.giant_bee_100_bi", 16, 49, 37, "male", "L2Monster", 40, 1338, 480, 3.56, 1.84, 40, 43, 30, 21, 20, 10, 1809, 112, 222, 154, 104, 147, 278, 500, 333, 0, 0, 0, 90, 174, "NULL", 0, 0, 0, "LAST_HIT", 0, 0, 0, "fighter"),
(20936, 20936, "Tanor Silenos", 0, "", 0, "Monster.heltor_silenos", 13, 29, 40, "male", "L2Monster", 40, 1527, 531, 3.56, 1.84, 40, 43, 30, 21, 20, 10, 3443, 222, 273, 201, 131, 164, 278, 0, 333, 88, 0, 0, 34, 174, "silenos_clan", 300, 0, 0, "LAST_HIT", 0, 0, 0, "fighter"),
(20937, 20937, "Tanor Silenos Grunt", 0, "", 0, "Monster.heltor_silenos", 13, 29, 42, "male", "L2Minion", 40, 1660, 589, 4.35, 2.14, 40, 43, 30, 21, 20, 10, 4498, 300, 311, 215, 152, 175, 278, 0, 333, 158, 18, 0, 34, 174, "silenos_clan", 300, 0, 0, "LAST_HIT", 0, 0, 0, "fighter"),
(20938, 20938, "Tanor Silenos Scout", 0, "", 0, "Monster.heltor_silenos", 13, 29, 44, "male", "L2Minion", 40, 1799, 648, 4.35, 2.14, 40, 43, 30, 21, 20, 10, 4937, 338, 354, 230, 176, 187, 278, 0, 333, 5, 0, 0, 34, 174, "silenos_clan", 300, 0, 0, "LAST_HIT", 0, 0, 0, "fighter"),
(20939, 20939, "Tanor Silenos Warrior", 0, "", 0, "Monster.heltor_silenos_warrior", 13, 31, 46, "male", "L2Minion", 40, 1943, 707, 4.35, 2.14, 40, 43, 30, 21, 20, 10, 5504, 390, 401, 245, 202, 199, 278, 500, 333, 160, 0, 0, 36, 174, "silenos_clan", 300, 0, 0, "LAST_HIT", 0, 0, 0, "fighter"),
(20940, 20940, "Tanor Silenos Shaman", 0, "", 0, "Monster.heltor_silenos_shaman", 13, 32, 48, "male", "L2Minion", 40, 2091, 768, 4.35, 2.14, 40, 43, 30, 21, 20, 10, 6707, 490, 453, 261, 231, 212, 278, 0, 333, 9, 0, 0, 29, 174, "silenos_clan", 300, 0, 0, "LAST_HIT", 0, 0, 0, "balanced"),
(20941, 20941, "Tanor Silenos Chieftain", 0, "", 0, "Monster.heltor_silenos_chieftain", 13, 31.5, 50, "male", "L2Monster", 40, 2245, 830, 4.35, 2.14, 40, 43, 30, 21, 20, 10, 6503, 490, 509, 278, 264, 226, 278, 500, 333, 75, 0, 0, 27, 174, "silenos_clan", 300, 0, 0, "LAST_HIT", 0, 0, 0, "fighter"),
(20942, 20942, "Nightmare Guide", 0, "", 0, "Monster.harpy", 10, 42, 43, "female", "L2Minion", 40, 1728, 618, 4.35, 2.14, 40, 43, 30, 21, 20, 10, 3282, 222, 332, 189, 163, 181, 278, 0, 333, 0, 0, 0, 60, 174, "NULL", 0, 0, 0, "LAST_HIT", 0, 0, 0, "fighter"),
(20943, 20943, "Nightmare Keeper", 0, "", 0, "Monster.harpy", 10, 42, 45, "female", "L2Minion", 40, 1870, 677, 4.35, 2.14, 40, 43, 30, 21, 20, 10, 4721, 328, 377, 202, 188, 193, 278, 0, 333, 0, 0, 0, 60, 174, "NULL", 0, 0, 0, "LAST_HIT", 0, 0, 0, "fighter"),
(20944, 20944, "Nightmare Lord", 0, "", 0, "Monster.succubus_100_bi", 20, 75, 47, "female", "L2Monster", 40, 2016, 738, 4.35, 2.14, 40, 43, 30, 21, 20, 10, 4000, 286, 427, 215, 216, 206, 300, 500, 359, 0, 0, 0, 60, 174, "NULL", 0, 0, 0, "LAST_HIT", 0, 0, 0, "fighter"),
(20945, 20945, "Cadeine", 0, "", 0, "Monster.hobgoblin", 12, 24, 50, "male", "L2Minion", 40, 2245, 830, 4.35, 2.14, 40, 43, 30, 21, 20, 10, 4483, 338, 509, 278, 264, 226, 278, 0, 333, 127, 625, 0, 45, 174, "green_clan", 300, 0, 0, "LAST_HIT", 0, 0, 0, "fighter"),
(20946, 20946, "Sanhidro", 0, "", 0, "Monster.troll", 21, 35, 52, "male", "L2Minion", 40, 2402, 892, 5.14, 2.45, 40, 43, 30, 21, 20, 10, 6896, 534, 570, 295, 300, 239, 278, 0, 333, 0, 0, 0, 55, 174, "green_clan", 300, 0, 0, "LAST_HIT", 0, 0, 0, "fighter"),
(20947, 20947, "Connabi", 0, "", 0, "Monster.bugbear", 17, 35, 54, "male", "L2Monster", 40, 2562, 955, 5.14, 2.45, 40, 43, 30, 21, 20, 10, 7437, 592, 636, 313, 339, 254, 300, 0, 359, 88, 0, 0, 55, 174, "green_clan", 300, 0, 0, "LAST_HIT", 0, 0, 0, "fighter"),
(20948, 20948, "Bartal", 0, "", 0, "Monster.liviona", 15, 28, 56, "male", "L2Minion", 40, 2724, 1019, 5.14, 2.45, 40, 43, 30, 21, 20, 10, 7385, 606, 706, 331, 382, 269, 278, 0, 333, 0, 0, 0, 88, 191, "green_clan", 300, 0, 0, "LAST_HIT", 0, 0, 0, "fighter"),
(20949, 20949, "Luminun", 0, "", 0, "Monster.twin_headed_giant", 17, 39, 58, "male", "L2Minion", 40, 2889, 1084, 5.14, 2.45, 40, 43, 30, 21, 20, 10, 8700, 734, 781, 349, 428, 284, 278, 0, 333, 157, 0, 0, 49, 191, "green_clan", 300, 0, 0, "LAST_HIT", 0, 0, 0, "fighter"),
(20950, 20950, "Innersen", 0, "", 0, "Monster.king_bugbear", 15, 40, 60, "male", "L2Monster", 40, 3054, 1150, 5.14, 2.45, 40, 43, 30, 21, 20, 10, 9365, 812, 860, 368, 478, 299, 278, 500, 333, 160, 0, 0, 60, 191, "green_clan", 300, 0, 0, "LAST_HIT", 0, 0, 0, "fighter"),
(20951, 20951, "Pobby's Maid", 0, "", 0, "Monster.manadragora", 14, 17.8, 53, "female", "L2Minion", 40, 2481, 923, 5.14, 2.45, 40, 43, 30, 21, 20, 10, 5037, 396, 602, 258, 319, 247, 278, 0, 333, 0, 0, 0, 80, 174, "green_clan", 300, 0, 0, "LAST_HIT", 0, 0, 0, "fighter"),
(20952, 20952, "Pobby Escort", 0, "", 0, "Monster.mandragora_b", 12, 25.5, 55, "female", "L2Minion", 40, 2643, 987, 5.14, 2.45, 40, 43, 30, 21, 20, 10, 9101, 734, 670, 273, 360, 261, 278, 0, 333, 0, 0, 0, 80, 174, "green_clan", 300, 0, 0, "LAST_HIT", 0, 0, 0, "fighter"),
(20953, 20953, "Pobby", 0, "", 0, "Monster.mandragora_a", 15, 26, 57, "female", "L2Monster", 40, 2806, 1052, 5.14, 2.45, 40, 43, 30, 21, 20, 10, 8452, 702, 743, 289, 405, 276, 278, 500, 333, 0, 0, 0, 80, 174, "green_clan", 300, 0, 0, "LAST_HIT", 0, 0, 0, "fighter"),
(20954, 20954, "Hungered Corpse", 0, "", 0, "Monster.skeleton", 11, 25, 60, "male", "L2Minion", 40, 3054, 1150, 5.14, 2.45, 40, 43, 30, 21, 20, 10, 9985, 866, 860, 368, 478, 299, 278, 0, 333, 123, 945, 0, 60, 180, "bloody_clan", 300, 1, 0, "LAST_HIT", 0, 0, 0, "fighter"),
(20955, 20955, "Ghostly Warrior", 0, "", 0, "Monster.skeleton_pikeman", 10, 28, 62, "male", "L2Minion", 40, 3219, 1217, 5.93, 2.78, 40, 43, 30, 21, 20, 10, 10662, 950, 944, 388, 532, 315, 278, 0, 333, 299, 0, 0, 50, 180, "bloody_clan", 300, 1, 0, "LAST_HIT", 0, 0, 0, "fighter"),
(20956, 20956, "Past Knight", 0, "", 0, "Monster.skeleton_knight", 10, 25, 64, "male", "L2Monster", 40, 3384, 1285, 5.93, 2.78, 40, 43, 30, 21, 20, 10, 11588, 1060, 1031, 408, 589, 331, 278, 500, 333, 150, 103, 0, 40, 174, "bloody_clan", 300, 1, 0, "LAST_HIT", 0, 0, 0, "fighter"),
(20957, 20957, "Nihil Invader", 0, "", 0, "Monster.skeleton_royal_guard", 11, 28.5, 66, "male", "L2Minion", 40, 3546, 1353, 5.93, 2.78, 40, 43, 30, 21, 20, 10, 12082, 1138, 1123, 428, 649, 348, 278, 0, 333, 946, 945, 0, 88, 203, "bloody_clan", 300, 1, 0, "LAST_HIT", 0, 0, 0, "fighter"),
(20958, 20958, "Death Agent", 0, "", 0, "Monster.death_blader", 15, 45, 68, "male", "L2Minion", 40, 3706, 1423, 5.93, 2.78, 40, 43, 30, 21, 20, 10, 9018, 872, 1217, 449, 713, 365, 278, 0, 333, 1472, 0, 0, 110, 214, "bloody_clan", 300, 1, 0, "LAST_HIT", 0, 0, 0, "fighter"),
(20959, 20959, "Dark Guard", 0, "", 0, "Monster.headless_knight", 21, 31, 70, "male", "L2Monster", 40, 3862, 1493, 5.93, 2.78, 40, 43, 30, 21, 20, 10, 13863, 1374, 1314, 470, 780, 382, 278, 500, 333, 124, 0, 0, 77, 187, "bloody_clan", 300, 1, 0, "LAST_HIT", 0, 0, 0, "fighter"),
(20960, 20960, "Bloody Ghost", 0, "", 0, "Monster.succubus", 10, 36, 64, "female", "L2Minion", 40, 3384, 1285, 5.93, 2.78, 40, 43, 30, 21, 20, 10, 7988, 732, 1031, 347, 589, 331, 278, 0, 333, 0, 0, 0, 66, 192, "bloody_clan", 300, 0, 0, "LAST_HIT", 0, 0, 0, "fighter"),
(20961, 20961, "Bloody Knight", 0, "", 0, "Monster.doll_blader", 6, 12, 65, "male", "L2Minion", 40, 3465, 1319, 5.93, 2.78, 40, 43, 30, 21, 20, 10, 11719, 1088, 1077, 355, 619, 340, 278, 0, 333, 5129, 5129, 0, 24, 192, "bloody_clan", 300, 0, 0, "LAST_HIT", 0, 0, 0, "fighter"),
(20962, 20962, "Bloody Priest", 0, "", 0, "Monster.bloody_queen", 14, 40, 66, "female", "L2Minion", 40, 3546, 1353, 5.93, 2.78, 40, 43, 30, 21, 20, 10, 13045, 1228, 1123, 364, 649, 348, 278, 0, 333, 0, 0, 0, 88, 203, "bloody_clan", 300, 0, 0, "LAST_HIT", 0, 100, 30, "balanced"),
(20963, 20963, "Bloody Lord", 0, "", 0, "Monster.banshee", 9, 23, 68, "female", "L2Monster", 40, 3706, 1423, 5.93, 2.78, 40, 43, 30, 21, 20, 10, 9382, 906, 1217, 382, 713, 365, 278, 500, 333, 3939, 0, 0, 88, 198, "bloody_clan", 300, 0, 0, "LAST_HIT", 0, 0, 0, "fighter"),
(20964, 20964, "Huge Footmark", 0, "", 0, "Monster.stone_golem", 20, 31, 70, "male", "L2Minion", 40, 3862, 1493, 5.93, 2.78, 40, 43, 30, 21, 20, 10, 13513, 1340, 1314, 470, 780, 382, 278, 0, 333, 0, 0, 0, 25, 25, "giant_clan", 300, 0, 0, "LAST_HIT", 0, 0, 0, "fighter"),
(20965, 20965, "Chimera Piece", 0, "", 0, "Monster.saber_toothed_tiger", 34, 28, 72, "male", "L2Minion", 40, 4013, 1565, 6.72, 3.09, 40, 43, 30, 21, 20, 10, 14379, 1460, 1413, 491, 849, 399, 278, 0, 333, 0, 0, 0, 66, 191, "giant_clan", 300, 0, 0, "LAST_HIT", 0, 0, 0, "fighter"),
(20966, 20966, "Black Shadow", 0, "", 0, "Monster.drake", 30, 100, 74, "male", "L2Monster", 40, 4158, 1637, 6.72, 3.09, 40, 43, 30, 21, 20, 10, 15493, 1616, 1513, 512, 921, 416, 278, 500, 333, 0, 0, 0, 77, 203, "giant_clan", 300, 0, 0, "LAST_HIT", 0, 0, 0, "fighter"),
(20967, 20967, "Past Creature", 0, "", 0, "Monster.gamlin", 11, 32, 76, "male", "L2Minion", 40, 4297, 1710, 6.72, 3.09, 40, 43, 30, 21, 20, 10, 16021, 1712, 1614, 534, 994, 433, 278, 0, 333, 0, 0, 0, 88, 187, "giant_clan", 300, 0, 0, "LAST_HIT", 0, 0, 0, "fighter"),
(20968, 20968, "Nonexistent Man", 0, "", 0, "Monster.susceptor", 20, 35, 78, "male", "L2Minion", 40, 4428, 1784, 6.72, 3.09, 40, 43, 30, 21, 20, 10, 15583, 1706, 1715, 555, 1069, 451, 278, 0, 333, 0, 0, 0, 29, 165, "giant_clan", 300, 0, 0, "LAST_HIT", 0, 0, 0, "fighter"),
(20969, 20969, "Giant's Shadow", 0, "", 0, "Monster.lesser_giant_shooter", 21, 44, 79, "male", "L2Monster", 500, 4490, 1821, 6.72, 3.09, 40, 43, 30, 21, 20, 10, 13043, 1446, 3921, 566, 1107, 459, 249, 500, 333, 4028, 0, 0, 88, 209, "giant_clan", 300, 0, 0, "LAST_HIT", 0, 0, 0, "fighter"),
(20970, 20970, "Soldier of Ancient Times", 0, "", 0, "Monster.lesser_giant", 21, 44, 73, "male", "L2Minion", 40, 4086, 1601, 6.72, 3.09, 40, 43, 30, 21, 20, 10, 10913, 1122, 1463, 426, 885, 407, 278, 0, 333, 3937, 0, 0, 16, 209, "giant_clan", 300, 0, 0, "LAST_HIT", 0, 0, 0, "fighter"),
(20971, 20971, "Warrior of Ancient Times", 0, "", 0, "Monster.lesser_giant", 21, 44, 75, "male", "L2Minion", 40, 4229, 1673, 6.72, 3.09, 40, 43, 30, 21, 20, 10, 15602, 1646, 1563, 445, 957, 425, 278, 0, 333, 3937, 0, 0, 16, 203, "giant_clan", 300, 0, 0, "LAST_HIT", 0, 0, 0, "fighter"),
(20972, 20972, "Shaman of Ancient Times", 0, "", 0, "Monster.lesser_giant_mage", 21, 44, 75, "male", "L2Minion", 40, 4229, 1673, 6.72, 3.09, 40, 43, 30, 21, 20, 10, 10970, 1158, 1563, 445, 957, 425, 278, 0, 333, 3938, 0, 0, 16, 214, "giant_clan", 300, 0, 0, "LAST_HIT", 0, 0, 0, "mage"),
(20973, 20973, "Forgotten Ancient People", 0, "", 0, "Monster.lesser_giant_mage", 21, 44, 77, "male", "L2Monster", 40, 4364, 1747, 6.72, 3.09, 40, 43, 30, 21, 20, 10, 16958, 1836, 1664, 463, 1031, 442, 278, 500, 333, 3938, 0, 0, 16, 203, "giant_clan", 300, 0, 0, "LAST_HIT", 0, 0, 0, "mage"),
(20974, 20974, "Spiteful Soul Leader", 0, "", 0, "Monster.skeleton_royal_guard_bi", 16, 44, 65, "male", "L2Monster", 40, 3465, 1319, 11.85, 2.78, 40, 43, 30, 21, 20, 10, 11772, 1094, 1077, 418, 619, 340, 278, 0, 333, 946, 945, 0, 88, 191, "undead_clan", 300, 1, 0, "LAST_HIT", 0, 0, 0, "fighter"),
(20975, 20975, "Spiteful Soul Wizard", 0, "", 0, "Monster.elf_ghost_50_bi", 10, 32, 63, "male", "L2Minion", 40, 3302, 1251, 11.85, 2.78, 40, 43, 30, 21, 20, 10, 10499, 948, 987, 398, 560, 323, 278, 0, 333, 0, 0, 0, 88, 191, "NULL", 0, 1, 0, "LAST_HIT", 0, 0, 0, "fighter"),
(20976, 20976, "Spiteful Soul Fighter", 0, "", 0, "Monster.human_ghost_50_bi", 12, 33, 62, "male", "L2Minion", 40, 3219, 1217, 11.85, 2.78, 40, 43, 30, 21, 20, 10, 8911, 794, 944, 388, 532, 315, 278, 0, 333, 0, 0, 0, 88, 191, "NULL", 0, 1, 0, "LAST_HIT", 0, 0, 0, "fighter"),
(20977, 20977, "Elmoradan's Lady", 0, "", 0, "Monster.banshee_50_bi", 13.5, 38, 65, "female", "L2Monster", 40, 3465, 1319, 23.7, 2.78, 40, 43, 30, 21, 20, 10, 7513, 698, 979, 460, 619, 340, 278, 500, 333, 3939, 0, 0, 88, 176, "tower_ghost_clan", 400, 0, 0, "LAST_HIT", 0, 0, 0, "fighter"),
(20978, 20978, "Elmoradan's Archer Escort", 0, "", 0, "Monster.skeleton_archer", 11, 27, 64, "male", "L2Minion", 500, 3384, 1285, 23.7, 2.78, 40, 43, 30, 21, 20, 10, 7470, 684, 2522, 315, 589, 331, 249, 0, 333, 284, 0, 0, 44, 154, "tower_ghost_clan", 400, 1, 0, "LAST_HIT", 0, 0, 0, "archer"),
(20979, 20979, "Elmoradan's Maid", 0, "", 0, "Monster.doll_blader", 6, 12, 64, "male", "L2Minion", 40, 3384, 1285, 23.7, 2.78, 40, 43, 30, 21, 20, 10, 7141, 654, 1135, 371, 589, 331, 278, 0, 333, 5129, 5129, 0, 24, 187, "tower_ghost_clan", 400, 0, 0, "LAST_HIT", 0, 0, 0, "fighter"),
(20980, 20980, "Hallate's Follower Mul", 0, "", 0, "Monster.vale_master", 12, 40, 68, "male", "L2Monster", 40, 3706, 1423, 23.7, 2.78, 40, 43, 30, 21, 20, 10, 7606, 735, 1339, 408, 713, 365, 278, 500, 333, 210, 0, 0, 77, 187, "hallate_clan", 400, 0, 0, "LAST_HIT", 0, 0, 0, "fighter"),
(20981, 20981, "Mul's Wizard", 0, "", 0, "Monster.kaim_vanul_50_bi", 36, 60, 67, "male", "L2Minion", 40, 3626, 1388, 23.7, 2.78, 40, 43, 30, 21, 20, 10, 7564, 720, 1063, 483, 681, 356, 278, 0, 333, 0, 0, 0, 40, 176, "hallate_clan", 400, 0, 0, "LAST_HIT", 0, 0, 0, "fighter"),
(20982, 20982, "Mul's Knight", 0, "", 0, "Monster.dre_vanul_100_bi", 28, 75, 67, "male", "L2Minion", 40, 3626, 1388, 23.7, 2.78, 40, 43, 30, 21, 20, 10, 6676, 636, 1126, 399, 681, 356, 317, 0, 333, 0, 0, 0, 88, 157, "hallate_clan", 400, 0, 0, "LAST_HIT", 0, 0, 0, "fighter"),
(20983, 20983, "Binder", 0, "", 0, "Monster.kel_mahum_champion_50_bi", 19, 48, 73, "male", "L2Monster", 40, 4086, 1601, 26.86, 3.09, 40, 43, 30, 21, 20, 10, 10342, 1064, 1609, 456, 885, 407, 278, 500, 333, 147, 0, 0, 55, 187, "tower_guard_clan", 400, 0, 0, "LAST_HIT", 0, 0, 0, "fighter"),
(20984, 20984, "Bound Warrior", 0, "", 0, "Monster.kel_mahum_warrior", 13, 28, 72, "male", "L2Monster", 40, 4013, 1565, 26.86, 3.09, 40, 43, 30, 21, 20, 10, 9719, 987, 1554, 446, 849, 399, 278, 0, 333, 148, 0, 0, 55, 176, "tower_guard_clan", 50, 0, 0, "LAST_HIT", 0, 0, 0, "fighter"),
(20985, 20985, "Bound Archer", 0, "", 0, "Monster.kel_mahum_archer", 13, 27, 72, "male", "L2Monster", 500, 4013, 1565, 26.86, 3.09, 40, 43, 30, 21, 20, 10, 9647, 980, 3454, 379, 849, 399, 249, 0, 333, 288, 0, 0, 55, 187, "tower_guard_clan", 50, 0, 0, "LAST_HIT", 0, 0, 0, "archer"),
(20986, 20986, "Sairon", 0, "", 0, "Monster.doll_blader_50_bi", 9, 20.5, 54, "male", "L2Monster", 40, 2562, 955, 20.54, 2.45, 40, 43, 30, 21, 20, 10, 5524, 440, 636, 313, 339, 254, 278, 500, 333, 5129, 5129, 0, 22, 174, "demonic_clan", 300, 0, 6, "LAST_HIT", 0, 0, 0, "fighter"),
(20987, 20987, "Sairon's Doll", 0, "", 0, "Monster.doll_blader", 6, 12, 53, "male", "L2Minion", 40, 2481, 923, 20.54, 2.45, 40, 43, 30, 21, 20, 10, 5025, 395, 602, 304, 319, 247, 278, 0, 333, 5129, 5129, 0, 22, 174, "NULL", 0, 0, 6, "LAST_HIT", 0, 0, 0, "fighter"),
(20988, 20988, "Sairon's Puppet", 0, "", 0, "Monster.doll_blader", 6, 12, 53, "male", "L2Minion", 40, 2481, 923, 20.54, 2.45, 40, 43, 30, 21, 20, 10, 5527, 434, 602, 304, 319, 247, 278, 0, 333, 5129, 5129, 0, 22, 174, "NULL", 0, 0, 6, "LAST_HIT", 0, 0, 0, "fighter"),
(20989, 20989, "Lageos", 0, "", 0, "Monster.marsh_stakato_drone_50_bi", 13, 37, 38, "male", "L2Monster", 40, 1400, 497, 7.11, 1.84, 40, 43, 30, 21, 20, 10, 2749, 171, 238, 188, 112, 153, 278, 0, 333, 182, 0, 0, 80, 174, "NULL", 0, 0, 0, "LAST_HIT", 0, 0, 0, "fighter"),
(20990, 20990, "Pageos", 0, "", 0, "Monster.marsh_stakato_soldier", 10, 25, 38, "male", "L2Minion", 40, 1400, 497, 7.11, 1.84, 40, 43, 30, 21, 20, 10, 2609, 163, 238, 188, 112, 153, 278, 0, 333, 128, 0, 0, 30, 174, "NULL", 0, 0, 0, "LAST_HIT", 0, 0, 0, "fighter"),
(20991, 20991, "Swamp Tribe", 0, "", 0, "Monster.farhite_50_bi", 24, 48, 45, "male", "L2Monster", 40, 1870, 677, 17.38, 2.14, 40, 43, 30, 21, 20, 10, 5139, 357, 377, 238, 188, 193, 278, 500, 333, 5131, 0, 0, 15, 174, "croc_clan", 300, 0, 0, "LAST_HIT", 0, 0, 0, "fighter"),
(20992, 20992, "Swamp Alligator", 0, "", 0, "Monster.crokian", 18, 29, 44, "male", "L2Minion", 40, 1799, 648, 17.38, 2.14, 40, 43, 30, 21, 20, 10, 4600, 315, 354, 230, 176, 187, 278, 0, 333, 5128, 0, 0, 18, 174, "NULL", 0, 0, 0, "LAST_HIT", 0, 0, 0, "fighter"),
(20993, 20993, "Swamp Warrior", 0, "", 0, "Monster.dailaon", 20, 28, 44, "male", "L2Minion", 500, 1799, 648, 17.38, 2.14, 40, 43, 30, 21, 20, 10, 4881, 334, 788, 230, 176, 187, 247, 0, 333, 5127, 0, 0, 18, 174, "NULL", 0, 0, 0, "LAST_HIT", 0, 0, 0, "fighter"),
(20994, 20994, "Garden Guard Leader", 0, "", 0, "Monster.doll_master_50_bi", 30, 63, 50, "male", "L2Monster", 40, 2245, 830, 17.38, 2.14, 40, 43, 30, 21, 20, 10, 6194, 466, 560, 253, 264, 226, 278, 500, 333, 0, 0, 0, 88, 191, "theeder_clan", 300, 1, 5, "LAST_HIT", 0, 0, 0, "fighter"),
(20995, 20995, "Garden Guard", 0, "", 0, "Monster.theeder", 9, 32, 48, "male", "L2Minion", 40, 2091, 768, 17.38, 2.14, 40, 43, 30, 21, 20, 10, 4222, 308, 453, 261, 231, 212, 278, 0, 333, 94, 0, 0, 88, 191, "NULL", 0, 0, 4, "LAST_HIT", 0, 0, 0, "fighter"),
(20996, 20996, "Spiteful Ghost of Ruins", 0, "", 0, "Monster.zombie", 13, 21, 50, "male", "L2Monster", 40, 2245, 830, 8.69, 2.14, 40, 43, 30, 21, 20, 10, 5349, 403, 560, 253, 264, 226, 278, 500, 333, 0, 0, 0, 16, 16, "undead_clan", 300, 1, 0, "LAST_HIT", 0, 0, 0, "fighter"),
(20997, 20997, "Soldier of Grief", 0, "", 0, "Monster.unpleasant_humming", 12, 26, 51, "male", "L2Monster", 40, 2323, 861, 10.27, 2.45, 40, 43, 30, 21, 20, 10, 3782, 288, 593, 260, 281, 232, 278, 0, 333, 0, 0, 0, 23, 165, "undead_clan", 300, 1, 0, "LAST_HIT", 0, 0, 0, "fighter"),
(20998, 20998, "Cruel Punisher", 0, "", 0, "Monster.hungry_spirit", 30, 40, 52, "male", "L2Monster", 40, 2402, 892, 10.27, 2.45, 40, 43, 30, 21, 20, 10, 4168, 322, 518, 324, 300, 239, 278, 0, 333, 0, 0, 0, 16, 132, "undead_clan", 300, 1, 0, "LAST_HIT", 0, 0, 0, "fighter"),
(20999, 20999, "Roving Soul", 0, "", 0, "Monster.skeleton", 11, 25, 53, "male", "L2Monster", 40, 2481, 923, 10.27, 2.45, 40, 43, 30, 21, 20, 10, 4943, 389, 527, 304, 319, 247, 317, 0, 333, 75, 0, 0, 66, 176, "undead_clan", 300, 1, 0, "LAST_HIT", 0, 0, 0, "fighter");

INSERT INTO `npc` VALUES
(21000, 21000, "Soul of Ruins", 0, "", 0, "Monster.human_ghost", 8, 22, 54, "male", "L2Monster", 40, 2562, 955, 10.27, 2.45, 40, 43, 30, 21, 20, 10, 4325, 345, 578, 344, 339, 254, 278, 500, 333, 0, 0, 0, 80, 174, "undead_clan", 300, 1, 0, "LAST_HIT", 0, 0, 0, "fighter"),
(21001, 21001, "Wretched Archer", 0, "", 0, "Monster.skeleton_archer", 11, 27, 55, "male", "L2Monster", 500, 2643, 987, 10.27, 2.45, 40, 43, 30, 21, 20, 10, 5856, 473, 1639, 292, 360, 261, 247, 0, 333, 282, 0, 0, 40, 174, "undead_clan", 300, 1, 0, "LAST_HIT", 0, 0, 0, "archer"),
(21002, 21002, "Doom Scout", 0, "", 0, "Monster.skeleton_royal_guard", 11, 28.5, 56, "male", "L2Monster", 40, 2724, 1019, 10.27, 2.45, 40, 43, 30, 21, 20, 10, 5163, 424, 679, 301, 382, 269, 317, 500, 333, 242, 2496, 0, 80, 174, "doom_clan", 300, 1, 0, "LAST_HIT", 0, 0, 0, "fighter"),
(21003, 21003, "Grave Lich", 0, "", 0, "Monster.liviona", 15, 28, 57, "male", "L2Monster", 40, 2806, 1052, 10.27, 2.45, 40, 43, 30, 21, 20, 10, 4725, 393, 675, 374, 405, 276, 278, 0, 333, 0, 0, 0, 80, 174, "undead_clan", 300, 0, 0, "LAST_HIT", 0, 0, 0, "fighter"),
(21004, 21004, "Dismal Pole", 0, "", 0, "Monster.hanged_man_ripper", 35, 80, 58, "male", "L2Monster", 80, 2889, 1084, 10.27, 2.45, 40, 43, 30, 21, 20, 10, 5239, 443, 828, 384, 428, 284, 236, 500, 333, 0, 0, 0, 55, 174, "undead_clan", 300, 0, 0, "LAST_HIT", 0, 0, 0, "fighter"),
(21005, 21005, "Grave Predator", 0, "", 0, "Monster.devastator", 35, 35, 59, "male", "L2Monster", 40, 2971, 1117, 10.27, 2.45, 40, 43, 30, 21, 20, 10, 5732, 490, 902, 326, 453, 291, 278, 500, 333, 0, 0, 0, 25, 174, "NULL", 0, 0, 0, "LAST_HIT", 0, 0, 0, "fighter"),
(21006, 21006, "Doom Servant", 0, "", 0, "Monster.hungry_spirit", 30, 40, 60, "male", "L2Monster", 40, 3054, 1150, 10.27, 2.45, 40, 43, 30, 21, 20, 10, 5447, 473, 946, 335, 478, 299, 278, 500, 333, 0, 0, 0, 16, 191, "doom_clan", 300, 1, 8, "LAST_HIT", 0, 0, 0, "fighter"),
(21007, 21007, "Doom Guard", 0, "", 0, "Monster.hungry_spirit", 30, 40, 61, "male", "L2Monster", 40, 3137, 1184, 11.85, 2.78, 40, 43, 30, 21, 20, 10, 5844, 514, 992, 344, 505, 307, 278, 0, 333, 0, 0, 0, 16, 191, "doom_clan", 300, 1, 9, "LAST_HIT", 0, 0, 0, "fighter"),
(21008, 21008, "Doom Archer", 0, "", 0, "Monster.skeleton_archer", 11, 27, 62, "male", "L2Monster", 500, 3219, 1217, 11.85, 2.78, 40, 43, 30, 21, 20, 10, 7471, 666, 2308, 353, 532, 315, 249, 500, 333, 286, 0, 0, 44, 191, "doom_clan", 300, 1, 9, "LAST_HIT", 0, 0, 0, "archer"),
(21009, 21009, "Doom Trooper", 0, "", 0, "Monster.skeleton_pikeman", 12, 33, 63, "male", "L2Monster", 80, 3302, 1251, 11.85, 2.78, 40, 43, 30, 21, 20, 10, 7966, 719, 1267, 362, 560, 323, 236, 0, 333, 301, 0, 0, 50, 174, "doom_clan", 300, 1, 10, "LAST_HIT", 0, 0, 0, "fighter"),
(21010, 21010, "Doom Warrior", 0, "", 0, "Monster.skeleton_knight", 10, 25, 64, "male", "L2Monster", 40, 3384, 1285, 11.85, 2.78, 40, 43, 30, 21, 20, 10, 6380, 584, 993, 371, 589, 331, 317, 0, 333, 71, 0, 0, 40, 174, "doom_clan", 300, 1, 10, "LAST_HIT", 0, 0, 0, "fighter"),
(21011, 21011, "Ol Mahum Van Grunt", 0, "", 0, "Monster.ol_mahum", 13.5, 25, 30, "male", "L2Monster", 40, 954, 365, 5.53, 1.53, 40, 43, 30, 21, 20, 10, 1308, 72, 132, 140, 58, 114, 278, 0, 333, 5, 0, 0, 55, 165, "wererat_clan", 300, 0, 0, "LAST_HIT", 0, 0, 0, "fighter"),
(21012, 21012, "Magical Eye", 0, "", 0, "Monster.magical_weaver", 11, 20, 31, "male", "L2Monster", 40, 1004, 381, 7.11, 1.84, 40, 43, 30, 21, 20, 10, 1736, 96, 129, 161, 64, 118, 278, 500, 333, 0, 0, 0, 99, 165, "NULL", 0, 0, 0, "LAST_HIT", 0, 0, 0, "fighter"),
(21013, 21013, "Ol Mahum Van Archer", 0, "", 0, "Monster.ol_mahum_archer", 14, 25, 32, "male", "L2Monster", 500, 1056, 397, 7.11, 1.84, 40, 43, 30, 21, 20, 10, 1920, 108, 376, 138, 69, 123, 249, 0, 333, 273, 0, 0, 55, 165, "wererat_clan", 300, 0, 0, "LAST_HIT", 0, 0, 0, "archer"),
(21014, 21014, "Lesser Warlike Tyrant", 0, "", 0, "Monster.grave", 15, 29, 33, "male", "L2Monster", 40, 1109, 413, 7.11, 1.84, 40, 43, 30, 21, 20, 10, 1987, 114, 151, 173, 75, 128, 278, 500, 333, 0, 0, 0, 77, 165, "kinpin_clan", 300, 0, 0, "LAST_HIT", 0, 0, 0, "fighter"),
(21015, 21015, "Ol Mahum Van Leader", 0, "", 0, "Monster.ol_mahum_champion", 14, 27, 34, "male", "L2Monster", 40, 1164, 430, 7.11, 1.84, 40, 43, 30, 21, 20, 10, 2040, 119, 196, 148, 82, 132, 278, 500, 333, 67, 0, 0, 55, 165, "wererat_clan", 300, 0, 0, "LAST_HIT", 0, 0, 0, "fighter"),
(21016, 21016, "Warlike Tyrant", 0, "", 0, "Monster.grave", 15, 29, 35, "male", "L2Monster", 40, 1220, 446, 7.11, 1.84, 40, 43, 30, 21, 20, 10, 2192, 130, 211, 154, 89, 137, 278, 0, 333, 0, 0, 0, 77, 191, "kinpin_clan", 300, 0, 0, "LAST_HIT", 0, 0, 0, "fighter"),
(21017, 21017, "Fallen Orc", 0, "", 0, "Monster.ketra_orc", 12, 29, 55, "male", "L2Monster", 40, 2643, 987, 10.27, 2.45, 40, 43, 30, 21, 20, 10, 4399, 355, 737, 292, 360, 261, 278, 0, 333, 127, 0, 0, 45, 174, "orc_clan", 300, 0, 0, "LAST_HIT", 0, 0, 0, "fighter"),
(21018, 21018, "Ancient Gargoyle", 0, "", 0, "Monster.hunter_gargoyle", 25, 65, 56, "male", "L2Monster", 40, 2724, 1019, 10.27, 2.45, 40, 43, 30, 21, 20, 10, 5536, 455, 642, 364, 382, 269, 278, 500, 333, 0, 0, 0, 100, 174, "NULL", 0, 0, 0, "LAST_HIT", 0, 0, 0, "fighter"),
(21019, 21019, "Fallen Orc Archer", 0, "", 0, "Monster.ketra_orc_archer", 12, 27, 57, "male", "L2Monster", 500, 2806, 1052, 10.27, 2.45, 40, 43, 30, 21, 20, 10, 6093, 506, 1501, 374, 405, 276, 247, 0, 333, 279, 0, 0, 45, 174, "orc_clan", 300, 0, 0, "LAST_HIT", 0, 0, 0, "archer"),
(21020, 21020, "Fallen Orc Shaman", 0, "", 0, "Monster.ketra_orc_shaman", 10, 23, 58, "male", "L2Monster", 40, 2889, 1084, 10.27, 2.45, 40, 43, 30, 21, 20, 10, 6898, 583, 710, 384, 428, 284, 278, 0, 333, 9, 0, 0, 10, 174, "orc_clan", 300, 0, 0, "LAST_HIT", 0, 0, 0, "balanced"),
(21021, 21021, "Sharp Talon Tiger", 0, "", 0, "Monster.saber_toothed_tiger", 34, 28, 59, "male", "L2Monster", 40, 2971, 1117, 10.27, 2.45, 40, 43, 30, 21, 20, 10, 6353, 543, 902, 277, 453, 291, 278, 500, 333, 0, 0, 0, 60, 174, "beast_clan", 300, 0, 0, "LAST_HIT", 0, 0, 0, "fighter"),
(21022, 21022, "Fallen Orc Captain", 0, "", 0, "Monster.ketra_orc_warrior", 12, 24, 60, "male", "L2Monster", 40, 3054, 1150, 10.27, 2.45, 40, 43, 30, 21, 20, 10, 6462, 561, 946, 285, 478, 299, 278, 500, 333, 160, 0, 0, 36, 174, "orc_clan", 300, 0, 0, "LAST_HIT", 0, 0, 0, "fighter"),
(21023, 21023, "Sobbing Wind", 0, "", 0, "Monster.sylph", 11, 35, 26, "female", "L2Monster", 40, 770, 303, 5.53, 1.53, 40, 43, 30, 21, 20, 10, 1056, 53, 87, 132, 41, 98, 278, 0, 333, 0, 0, 0, 66, 165, "elemental2_clan", 300, 0, 0, "LAST_HIT", 0, 0, 0, "fighter"),
(21024, 21024, "Babbling Wind", 0, "", 0, "Monster.sylph", 11, 35, 27, "female", "L2Monster", 40, 813, 318, 5.53, 1.53, 40, 43, 30, 21, 20, 10, 1113, 57, 94, 138, 45, 102, 278, 0, 333, 0, 0, 0, 66, 165, "elemental2_clan", 300, 0, 0, "LAST_HIT", 0, 0, 0, "fighter"),
(21025, 21025, "Giggling Wind", 0, "", 0, "Monster.sylph", 11, 35, 28, "female", "L2Monster", 40, 859, 334, 5.53, 1.53, 40, 43, 30, 21, 20, 10, 1178, 62, 102, 143, 49, 106, 278, 0, 333, 0, 0, 0, 66, 165, "elemental2_clan", 300, 0, 0, "LAST_HIT", 0, 0, 0, "fighter"),
(21026, 21026, "Singing Wind", 0, "", 0, "Monster.sylph", 11, 35, 29, "female", "L2Monster", 40, 906, 349, 5.53, 1.53, 40, 43, 30, 21, 20, 10, 1268, 68, 111, 149, 53, 110, 278, 500, 333, 0, 0, 0, 66, 165, "elemental2_clan", 300, 0, 0, "LAST_HIT", 0, 0, 0, "fighter"),
(21034, 21034, "Ogre", 0, "", 0, "Monster.ogre", 25, 52.5, 38, "male", "L2Monster", 40, 1400, 497, 3.56, 1.84, 40, 43, 30, 21, 20, 10, 3594, 224, 440, 141, 112, 153, 197, 500, 333, 98, 0, 0, 22, 174, "lizardman_clan1", 300, 0, 0, "LAST_HIT", 0, 0, 0, "fighter"),
(21035, 21035, "Catherok", 0, "", 0, "Monster.marsh_stakato_soldier", 10, 25, 42, "male", "L2Monster", 40, 1660, 589, 17.38, 2.14, 40, 43, 30, 21, 20, 10, 2275, 151, 342, 196, 152, 175, 278, 500, 333, 127, 0, 0, 30, 174, "beast_clan", 300, 0, 0, "LAST_HIT", 0, 0, 0, "fighter"),
(21036, 21036, "Shindebarn", 0, "", 0, "Monster.magical_weaver", 13, 24, 44, "male", "L2Monster", 40, 1799, 648, 17.38, 2.14, 40, 43, 30, 21, 20, 10, 2869, 196, 390, 209, 176, 187, 278, 500, 333, 0, 0, 0, 90, 174, "porta_clan", 300, 0, 0, "LAST_HIT", 0, 0, 0, "fighter"),
(21037, 21037, "Ossiud", 0, "", 0, "Monster.field_stalker", 15, 30, 47, "male", "L2Monster", 40, 2016, 738, 17.38, 2.14, 40, 43, 30, 21, 20, 10, 3326, 238, 469, 230, 216, 206, 278, 500, 333, 0, 0, 0, 70, 174, "torfe_clan", 300, 0, 0, "LAST_HIT", 0, 0, 0, "fighter"),
(21038, 21038, "Liangma", 0, "", 0, "Monster.will_o_wisp", 13, 22, 49, "male", "L2Monster", 40, 2168, 799, 17.38, 2.14, 40, 43, 30, 21, 20, 10, 2926, 216, 529, 245, 247, 219, 278, 500, 333, 0, 0, 0, 80, 174, "undead_clan", 300, 0, 0, "LAST_HIT", 0, 0, 0, "fighter"),
(21039, 21039, "Snipe Cohort", 0, "", 0, "Monster.onyx_beast", 14, 14.5, 43, "male", "L2Monster", 40, 1728, 618, 17.38, 2.14, 40, 43, 30, 21, 20, 10, 3041, 205, 302, 245, 163, 181, 278, 0, 333, 0, 0, 0, 30, 174, "NULL", 0, 0, 0, "LAST_HIT", 0, 0, 0, "fighter"),
(21040, 21040, "Soldier of Darkness", 0, "", 0, "Monster.death_knight", 12, 31, 49, "male", "L2Minion", 40, 2168, 799, 17.38, 2.14, 40, 43, 30, 21, 20, 10, 5077, 375, 581, 223, 247, 219, 278, 0, 333, 127, 0, 0, 27, 174, "NULL", 0, 1, 0, "LAST_HIT", 0, 0, 0, "fighter"),
(21058, 21058, "Beast Lord", 0, "", 0, "Monster.saber_toothed_tiger", 34, 28, 60, "male", "L2Monster", 40, 3054, 1150, 20.54, 2.45, 40, 43, 30, 21, 20, 10, 7880, 684, 946, 335, 478, 299, 278, 500, 333, 0, 0, 0, 66, 191, "beast_clan", 400, 0, 0, "LAST_HIT", 0, 0, 0, "fighter"),
(21059, 21059, "Beast Guardian", 0, "", 0, "Monster.onyx_beast", 14, 14.5, 59, "male", "L2Minion", 40, 2971, 1117, 20.54, 2.45, 40, 43, 30, 21, 20, 10, 6289, 537, 902, 326, 453, 291, 278, 0, 333, 0, 0, 0, 33, 191, "beast_clan", 300, 0, 0, "LAST_HIT", 0, 0, 0, "fighter"),
(21060, 21060, "Beast Seer", 0, "", 0, "Monster.field_stalker", 15, 30, 59, "male", "L2Minion", 40, 2971, 1117, 20.54, 2.45, 40, 43, 30, 21, 20, 10, 6289, 537, 745, 395, 453, 291, 278, 0, 333, 0, 0, 0, 77, 191, "beast_clan", 300, 0, 0, "LAST_HIT", 0, 0, 0, "fighter"),
(21061, 21061, "Hallate's Guardian", 0, "", 0, "Monster.kaim_vanul", 24, 40, 69, "male", "L2Monster", 40, 3784, 1458, 47.4, 2.78, 40, 43, 30, 21, 20, 10, 6396, 625, 1392, 418, 746, 373, 278, 500, 333, 0, 0, 0, 37, 174, "hallate_clan", 400, 0, 0, "LAST_HIT", 0, 0, 0, "fighter"),
(21062, 21062, "Messenger Angel", 0, "", 0, "Monster.angel", 13.5, 36.5, 70, "male", "L2Monster", 40, 3862, 1493, 47.4, 2.78, 40, 43, 30, 21, 20, 10, 0, 0, 1590, 388, 780, 382, 278, 500, 333, 148, 0, 0, 33, 191, "tower_guard_clan", 400, 0, 10, "LAST_HIT", 0, 0, 0, "fighter"),
(21063, 21063, "Messenger Angel", 0, "", 0, "Monster.angel", 13.5, 36.5, 70, "male", "L2Monster", 40, 3862, 1493, 47.4, 2.78, 40, 43, 30, 21, 20, 10, 13079, 1297, 1194, 517, 780, 382, 278, 500, 333, 148, 0, 0, 33, 191, "tower_guard_clan", 400, 0, 10, "LAST_HIT", 0, 0, 0, "balanced"),
(21064, 21064, "Platinum Guardian Archer", 0, "", 0, "Monster.kel_mahum_archer", 13, 27, 71, "male", "L2Monster", 500, 3938, 1529, 53.72, 3.09, 40, 43, 30, 21, 20, 10, 8009, 803, 3332, 371, 814, 390, 249, 500, 333, 288, 0, 0, 55, 191, "tower_guard_clan", 400, 0, 10, "LAST_HIT", 0, 0, 0, "archer"),
(21065, 21065, "Platinum Guardian Warrior", 0, "", 0, "Monster.kel_mahum_warrior", 13, 28, 72, "male", "L2Monster", 40, 4013, 1565, 67.15, 3.09, 40, 43, 30, 21, 20, 10, 6036, 613, 1284, 540, 849, 399, 278, 500, 333, 148, 0, 0, 55, 191, "tower_guard_clan", 400, 0, 10, "LAST_HIT", 0, 0, 0, "balanced"),
(21066, 21066, "Platinum Guardian Shaman", 0, "", 0, "Monster.kel_mahum_witch_doctor", 13, 25, 73, "male", "L2Monster", 40, 4086, 1601, 67.15, 3.09, 40, 43, 30, 21, 20, 10, 6529, 672, 1609, 456, 885, 407, 278, 500, 333, 202, 0, 0, 55, 191, "tower_guard_clan", 400, 0, 10, "LAST_HIT", 0, 0, 0, "mage"),
(21067, 21067, "Guardian Archangel", 0, "", 0, "Monster.angel", 13.5, 36.5, 74, "male", "L2Monster", 40, 4158, 1637, 67.15, 3.09, 40, 43, 30, 21, 20, 10, 0, 0, 1831, 423, 921, 416, 278, 500, 333, 148, 0, 0, 30, 174, "tower_guard_clan", 400, 0, 10, "LAST_HIT", 0, 0, 0, "fighter"),
(21068, 21068, "Guardian Archangel", 0, "", 0, "Monster.angel", 13.5, 36.5, 74, "male", "L2Monster", 40, 4158, 1637, 67.15, 3.09, 40, 43, 30, 21, 20, 10, 14206, 1481, 1664, 466, 921, 416, 278, 500, 333, 148, 0, 0, 33, 191, "tower_guard_clan", 400, 0, 10, "LAST_HIT", 0, 0, 0, "fighter"),
(21069, 21069, "Platinum Guardian Prefect", 0, "", 0, "Monster.kel_mahum_champion", 13, 32, 74, "male", "L2Monster", 40, 4158, 1637, 67.15, 3.09, 40, 43, 30, 21, 20, 10, 8909, 928, 1831, 423, 921, 416, 278, 500, 333, 147, 0, 0, 50, 174, "tower_guard_clan", 400, 0, 10, "LAST_HIT", 0, 0, 0, "fighter"),
(21070, 21070, "Seal Archangel", 0, "", 0, "Monster.angel", 13.5, 36.5, 75, "male", "L2Monster", 40, 4229, 1673, 67.15, 3.09, 40, 43, 30, 21, 20, 10, 0, 0, 1892, 432, 957, 425, 278, 500, 333, 148, 0, 0, 33, 191, "tower_guard_clan", 400, 0, 10, "LAST_HIT", 0, 0, 0, "fighter"),
(21071, 21071, "Seal Archangel", 0, "", 0, "Monster.angel", 13.5, 36.5, 75, "male", "L2Monster", 40, 4229, 1673, 67.15, 3.09, 40, 43, 30, 21, 20, 10, 14733, 1554, 1421, 575, 957, 425, 278, 500, 333, 148, 0, 0, 33, 191, "tower_guard_clan", 400, 0, 10, "LAST_HIT", 0, 0, 0, "balanced"),
(21072, 21072, "Platinum Guardian Chief", 0, "", 0, "Monster.kel_mahum_witch_doctor", 13, 25, 75, "male", "L2Monster", 40, 4229, 1673, 67.15, 3.09, 40, 43, 30, 21, 20, 10, 6752, 712, 1720, 475, 957, 425, 278, 500, 333, 202, 0, 0, 55, 191, "tower_guard_clan", 400, 0, 10, "LAST_HIT", 0, 0, 0, "mage"),
(21073, 21073, "Guardian Warrior of Elmoreden", 0, "", 0, "Monster.skeleton_knight", 10, 25, 64, "male", "L2Monster", 40, 3384, 1285, 23.7, 2.78, 40, 43, 30, 21, 20, 10, 7040, 644, 1135, 371, 589, 331, 278, 0, 333, 84, 0, 0, 44, 191, "tower_ghost_clan", 400, 1, 0, "LAST_HIT", 0, 0, 0, "fighter"),
(21074, 21074, "Bound Shaman", 0, "", 0, "Monster.kel_mahum_witch_doctor", 13, 25, 72, "male", "L2Monster", 40, 4013, 1565, 26.86, 3.09, 40, 43, 30, 21, 20, 10, 9651, 980, 1284, 540, 849, 399, 278, 0, 333, 202, 0, 0, 55, 191, "tower_guard_clan", 400, 0, 0, "LAST_HIT", 0, 0, 0, "mage"),
(21075, 21075, "Slaughter Bathin", 0, "", 0, "Monster.death_knight", 12, 31, 63, "male", "L2Monster", 40, 3302, 1251, 23.7, 2.78, 40, 43, 30, 21, 20, 10, 6995, 631, 1086, 362, 560, 323, 278, 500, 333, 84, 0, 0, 29, 191, "hallate_clan", 200, 1, 0, "LAST_HIT", 0, 0, 0, "fighter"),
(21076, 21076, "Bathin's Knight", 0, "", 0, "Monster.skeleton_knight", 10, 25, 62, "male", "L2Minion", 40, 3219, 1217, 23.7, 2.78, 40, 43, 30, 21, 20, 10, 6881, 613, 1038, 353, 532, 315, 278, 0, 333, 78, 0, 0, 44, 191, "hallate_clan", 200, 1, 0, "LAST_HIT", 0, 0, 0, "fighter"),
(21077, 21077, "Bathin's Wizard", 0, "", 0, "Monster.banshee", 9, 23, 62, "female", "L2Minion", 40, 3219, 1217, 23.7, 2.78, 40, 43, 30, 21, 20, 10, 6669, 594, 1038, 353, 532, 315, 278, 0, 333, 3939, 0, 0, 88, 191, "hallate_clan", 200, 0, 0, "LAST_HIT", 0, 0, 0, "fighter"),
(21078, 21078, "Magus Valac", 0, "", 0, "Monster.vale_master", 12, 40, 70, "male", "L2Monster", 40, 3862, 1493, 23.7, 2.78, 40, 43, 30, 21, 20, 10, 8481, 841, 1445, 427, 780, 382, 278, 500, 333, 198, 0, 0, 77, 191, "hallate_clan", 200, 0, 0, "LAST_HIT", 0, 0, 0, "fighter"),
(21079, 21079, "Valac's Creature", 0, "", 0, "Monster.serpent_slave", 17, 46, 69, "male", "L2Minion", 40, 3784, 1458, 23.7, 2.78, 40, 43, 30, 21, 20, 10, 7707, 754, 1392, 418, 746, 373, 278, 0, 333, 150, 0, 0, 77, 191, "hallate_clan", 200, 0, 0, "LAST_HIT", 0, 0, 0, "fighter"),
(21080, 21080, "Valac's Guardian Spirit", 0, "", 0, "Monster.shadow", 10, 30, 69, "male", "L2Minion", 40, 3784, 1458, 23.7, 2.78, 40, 43, 30, 21, 20, 10, 7123, 697, 1006, 506, 746, 373, 317, 0, 333, 0, 0, 0, 88, 191, "hallate_clan", 200, 0, 0, "LAST_HIT", 0, 0, 0, "balanced"),
(21081, 21081, "Power Angel Amon", 0, "", 0, "Monster.angel", 13.5, 36.5, 75, "male", "L2Monster", 40, 4229, 1673, 26.86, 3.09, 40, 43, 30, 21, 20, 10, 8887, 937, 1720, 475, 957, 425, 278, 500, 333, 4700, 0, 0, 33, 191, "tower_guard_clan", 200, 0, 0, "LAST_HIT", 0, 0, 0, "fighter"),
(21082, 21082, "Amon's Captain of the Guards", 0, "", 0, "Monster.kel_mahum_champion", 13, 32, 74, "male", "L2Minion", 40, 4158, 1637, 26.86, 3.09, 40, 43, 30, 21, 20, 10, 8546, 891, 1664, 466, 921, 416, 278, 0, 333, 150, 0, 0, 55, 191, "tower_guard_clan", 200, 0, 0, "LAST_HIT", 0, 0, 0, "fighter"),
(21083, 21083, "Amon's Spirits", 0, "", 0, "Monster.pixy", 5, 25, 74, "female", "L2Minion", 40, 4158, 1637, 26.86, 3.09, 40, 43, 30, 21, 20, 10, 10096, 1052, 1664, 466, 921, 416, 278, 0, 333, 0, 0, 0, 88, 191, "tower_guard_clan", 200, 0, 0, "LAST_HIT", 0, 0, 0, "fighter"),
(21084, 21084, "Bloody Lady", 0, "", 0, "Monster.bloody_queen", 14, 40, 60, "female", "L2Monster", 40, 3054, 1150, 30.81, 2.45, 40, 43, 30, 21, 20, 10, 4536, 394, 860, 368, 478, 299, 278, 500, 333, 0, 0, 0, 80, 174, "cave_servant_clan", 400, 0, 0, "LAST_HIT", 0, 0, 0, "fighter"),
(21085, 21085, "Bloody Sniper", 0, "", 0, "Monster.fiend_archer", 17, 55, 71, "male", "L2Monster", 500, 3938, 1529, 67.15, 3.09, 40, 43, 30, 21, 20, 10, 5574, 559, 3332, 437, 814, 390, 249, 500, 333, 0, 0, 0, 77, 191, "bloody_clan", 400, 0, 0, "LAST_HIT", 0, 0, 0, "archer"),
(21086, 21086, "Bloody Liviona", 0, "", 0, "Monster.liviona", 15, 28, 72, "male", "L2Monster", 40, 4013, 1565, 67.15, 3.09, 40, 43, 30, 21, 20, 10, 5566, 565, 1413, 491, 849, 399, 278, 500, 333, 0, 0, 0, 88, 191, "bloody_clan", 400, 0, 0, "LAST_HIT", 0, 0, 0, "fighter"),
(21087, 21087, "Bloody Knight", 0, "", 0, "Monster.death_knight", 12, 31, 73, "male", "L2Monster", 40, 4086, 1601, 67.15, 3.09, 40, 43, 30, 21, 20, 10, 8932, 919, 1770, 415, 885, 407, 278, 500, 333, 137, 0, 0, 29, 191, "bloody_clan", 400, 1, 0, "LAST_HIT", 0, 0, 0, "fighter"),
(21088, 21088, "Bloody Banshee", 0, "", 0, "Monster.banshee", 9, 23, 74, "female", "L2Monster", 40, 4158, 1637, 67.15, 3.09, 40, 43, 30, 21, 20, 10, 5879, 612, 1513, 512, 921, 416, 278, 500, 333, 3939, 0, 0, 88, 191, "bloody_clan", 400, 0, 0, "LAST_HIT", 0, 0, 0, "fighter"),
(21089, 21089, "Bloody Lord", 0, "", 0, "Monster.karik", 25, 90, 75, "male", "L2Monster", 40, 4229, 1673, 67.15, 3.09, 40, 43, 30, 21, 20, 10, 6817, 719, 1720, 475, 957, 425, 278, 500, 333, 0, 0, 0, 40, 191, "bloody_clan", 400, 0, 0, "LAST_HIT", 0, 0, 0, "fighter"),
(21090, 21090, "Bloody Guardian", 0, "", 0, "Monster.death_blader", 15, 45, 75, "male", "L2Monster", 40, 4229, 1673, 40.29, 3.09, 40, 43, 30, 21, 20, 10, 8734, 921, 1720, 475, 957, 425, 278, 500, 333, 1472, 0, 0, 110, 191, "bloody_clan", 400, 1, 0, "LAST_HIT", 0, 0, 0, "fighter"),
(21091, 21091, "Bloody Keeper", 0, "", 0, "Monster.kaim_vanul", 24, 40, 74, "male", "L2Monster", 40, 4158, 1637, 26.86, 3.09, 40, 43, 30, 21, 20, 10, 8831, 920, 1513, 512, 921, 416, 278, 0, 333, 0, 0, 0, 40, 191, "bloody_clan", 400, 0, 0, "LAST_HIT", 0, 0, 0, "fighter"),
(21092, 21092, "Bloody Mystic", 0, "", 0, "Monster.banshee", 9, 23, 74, "female", "L2Monster", 40, 4158, 1637, 26.86, 3.09, 40, 43, 30, 21, 20, 10, 8627, 899, 1513, 512, 921, 416, 278, 0, 333, 3939, 0, 0, 88, 191, "bloody_clan", 400, 0, 0, "LAST_HIT", 0, 0, 0, "fighter"),
(21093, 21093, "Ratman Sub Chieftain", 0, "", 0, "Monster.wererat", 14, 25, 19, "male", "L2Monster", 40, 508, 203, 3.95, 1.21, 40, 43, 30, 21, 20, 10, 691, 31, 58, 70, 21, 73, 278, 400, 333, 216, 0, 0, 88, 165, "wererat_clan", 300, 0, 0, "LAST_HIT", 0, 0, 0, "fighter"),
(21094, 21094, "Ratman Chieftain", 0, "", 0, "Monster.wererat", 14, 25, 20, "male", "L2Monster", 40, 541, 213, 3.95, 1.21, 40, 43, 30, 21, 20, 10, 712, 32, 52, 104, 23, 76, 278, 0, 333, 3, 0, 0, 88, 170, "wererat_clan", 300, 0, 0, "LAST_HIT", 0, 0, 0, "fighter"),
(21095, 21095, "Giant Poison Bee", 0, "", 0, "Monster.giant_bee", 8, 24.5, 21, "male", "L2Monster", 40, 575, 227, 5.53, 1.53, 40, 43, 30, 21, 20, 10, 840, 39, 55, 83, 25, 80, 317, 0, 333, 0, 0, 0, 99, 99, "NULL", 0, 0, 0, "LAST_HIT", 0, 0, 0, "fighter"),
(21096, 21096, "Cloudy Beast", 0, "", 0, "Monster.onyx_beast", 14, 14.5, 22, "male", "L2Monster", 40, 611, 242, 5.53, 1.53, 40, 43, 30, 21, 20, 10, 837, 40, 68, 87, 28, 83, 278, 400, 333, 0, 0, 0, 33, 154, "beast_clan", 300, 0, 0, "LAST_HIT", 0, 0, 0, "fighter"),
(21097, 21097, "Young Araneid", 0, "", 0, "Monster.poison_spider", 27, 25.5, 23, "male", "L2Monster", 40, 648, 257, 5.53, 1.53, 40, 43, 30, 21, 20, 10, 985, 48, 75, 107, 31, 87, 278, 400, 333, 0, 0, 0, 66, 143, "NULL", 0, 0, 0, "LAST_HIT", 0, 0, 0, "fighter"),
(21098, 21098, "Plain Grizzly", 0, "", 0, "Monster.grizzly", 21, 40, 24, "male", "L2Monster", 40, 687, 272, 5.53, 1.53, 40, 43, 30, 21, 20, 10, 935, 46, 81, 111, 34, 90, 278, 0, 333, 0, 0, 0, 44, 126, "NULL", 0, 0, 0, "LAST_HIT", 0, 0, 0, "fighter"),
(21099, 21099, "Cloudy Beast Turen", 0, "", 0, "Monster.onyx_beast", 14, 14.5, 25, "male", "L2Monster", 40, 728, 287, 5.53, 1.53, 40, 43, 30, 21, 20, 10, 1012, 51, 88, 98, 37, 94, 278, 400, 333, 0, 0, 0, 33, 159, "beast_clan", 300, 0, 0, "LAST_HIT", 0, 0, 0, "fighter"),
(21100, 21100, "Langk Lizardman Sentinel", 0, "", 0, "Monster.virud_lizardman", 10, 23, 19, "male", "L2Monster", 40, 508, 203, 3.95, 1.21, 40, 43, 30, 21, 20, 10, 691, 31, 53, 90, 21, 73, 278, 500, 333, 2, 0, 0, 47, 143, "lizardman_clan", 300, 0, 0, "LAST_HIT", 0, 0, 0, "fighter"),
(21101, 21101, "Langk Lizardman Shaman", 0, "", 0, "Monster.virud_lizardman_shaman", 10, 29, 24, "male", "L2Monster", 40, 687, 272, 5.53, 1.53, 40, 43, 30, 21, 20, 10, 935, 46, 81, 94, 34, 90, 278, 0, 333, 6, 0, 0, 47, 143, "lizardman_clan", 300, 0, 0, "LAST_HIT", 0, 0, 0, "balanced"),
(21102, 21102, "Watchman of the Plains", 0, "", 0, "Monster.magical_weaver", 11, 20, 30, "male", "L2Monster", 40, 954, 365, 5.53, 1.53, 40, 43, 30, 21, 20, 10, 1335, 73, 132, 119, 58, 114, 278, 500, 333, 0, 0, 0, 90, 160, "monster_eye_clan", 300, 0, 0, "LAST_HIT", 0, 0, 0, "fighter"),
(21103, 21103, "Roughly Hewn Rock Golem", 0, "", 0, "Monster.stone_golem_bi", 20, 40.3, 31, "male", "L2Monster", 40, 1004, 381, 7.11, 1.84, 40, 43, 30, 21, 20, 10, 1397, 78, 142, 146, 64, 118, 278, 0, 333, 0, 0, 0, 23, 23, "NULL", 0, 0, 0, "LAST_HIT", 0, 0, 0, "fighter"),
(21104, 21104, "Delu Lizardman Supplier", 0, "", 0, "Monster.virud_lizardman", 10, 23, 32, "male", "L2Monster", 40, 1056, 397, 7.11, 1.84, 40, 43, 30, 21, 20, 10, 1754, 99, 134, 151, 69, 123, 317, 0, 333, 223, 0, 0, 43, 135, "NULL", 0, 0, 0, "LAST_HIT", 0, 0, 0, "fighter"),
(21105, 21105, "Delu Lizardman Special Agent", 0, "", 0, "Monster.virud_lizardman_scout", 10, 22, 33, "male", "L2Monster", 500, 1109, 413, 7.11, 1.84, 40, 43, 30, 21, 20, 10, 2022, 116, 406, 143, 75, 128, 247, 0, 333, 2507, 0, 0, 43, 135, "NULL", 0, 0, 0, "LAST_HIT", 0, 0, 0, "fighter"),
(21106, 21106, "Cursed Seer", 0, "", 0, "Monster.magical_weaver", 11, 20, 34, "male", "L2Monster", 40, 1164, 430, 7.11, 1.84, 40, 43, 30, 21, 20, 10, 1714, 100, 178, 138, 82, 132, 278, 500, 333, 0, 0, 0, 90, 160, "monster_eye_clan", 300, 0, 0, "LAST_HIT", 0, 0, 0, "fighter"),
(21107, 21107, "Delu Lizardman Commander", 0, "", 0, "Monster.virud_lizardman_warrior", 12, 30, 35, "male", "L2Monster", 40, 1220, 446, 14.22, 1.84, 40, 43, 30, 21, 20, 10, 1814, 107, 192, 169, 89, 137, 278, 0, 333, 93, 0, 0, 52, 135, "NULL", 0, 0, 0, "LAST_HIT", 0, 0, 0, "fighter"),
(21108, 21108, "Glow Wisp", 0, "", 0, "Monster.will_o_wisp", 13, 22, 67, "male", "L2Monster", 40, 3626, 1388, 11.85, 2.78, 40, 43, 30, 21, 20, 10, 6528, 622, 1169, 439, 681, 356, 278, 0, 333, 0, 0, 0, 88, 176, "NULL", 0, 0, 0, "LAST_HIT", 0, 0, 0, "fighter"),
(21109, 21109, "Hames Orc Scout", 0, "", 0, "Monster.ketra_orc", 12, 29, 68, "male", "L2Monster", 40, 3706, 1423, 11.85, 2.78, 40, 43, 30, 21, 20, 10, 8082, 781, 1065, 382, 713, 365, 317, 0, 333, 229, 0, 0, 49, 203, "orc_clan", 400, 0, 0, "LAST_HIT", 0, 0, 0, "balanced"),
(21110, 21110, "Marsh Predator", 0, "", 0, "Monster.devastator", 35, 35, 69, "male", "L2Monster", 40, 3784, 1458, 11.85, 2.78, 40, 43, 30, 21, 20, 10, 6890, 674, 1265, 460, 746, 373, 278, 0, 333, 0, 0, 0, 27, 192, "NULL", 0, 0, 0, "LAST_HIT", 0, 0, 0, "fighter"),
(21111, 21111, "Lava Wyrm", 0, "", 0, "Monster.wyrm", 29, 72, 70, "male", "L2Monster", 40, 3862, 1493, 11.85, 2.78, 40, 43, 30, 21, 20, 10, 7197, 714, 1314, 470, 780, 382, 278, 500, 333, 0, 0, 0, 70, 175, "NULL", 0, 0, 0, "LAST_HIT", 0, 0, 0, "fighter"),
(21112, 21112, "Hames Orc Footman", 0, "", 0, "Monster.ketra_orc", 12, 29, 71, "male", "L2Monster", 40, 3938, 1529, 13.43, 3.09, 40, 43, 30, 21, 20, 10, 8724, 875, 1363, 481, 814, 390, 278, 0, 333, 233, 110, 0, 45, 180, "orc_clan", 300, 0, 0, "LAST_HIT", 0, 0, 0, "fighter"),
(21113, 21113, "Hames Orc Sniper", 0, "", 0, "Monster.ketra_orc_archer", 12, 27, 72, "male", "L2Monster", 500, 4013, 1565, 13.43, 3.09, 40, 43, 30, 21, 20, 10, 9722, 988, 3140, 417, 849, 399, 247, 0, 333, 287, 0, 0, 45, 160, "orc_clan", 300, 0, 0, "LAST_HIT", 0, 0, 0, "archer"),
(21114, 21114, "Cursed Guardian", 0, "", 0, "Monster.death_blader", 15, 45, 73, "male", "L2Monster", 40, 4086, 1601, 13.43, 3.09, 40, 43, 30, 21, 20, 10, 9231, 950, 1463, 426, 885, 407, 278, 0, 333, 1472, 0, 0, 110, 192, "NULL", 0, 1, 0, "LAST_HIT", 0, 0, 0, "fighter"),
(21115, 21115, "Hames Orc Shaman", 0, "", 0, "Monster.ketra_orc_shaman", 10, 23, 74, "male", "L2Monster", 40, 4158, 1637, 13.43, 3.09, 40, 43, 30, 21, 20, 10, 8043, 838, 1513, 435, 921, 416, 278, 0, 333, 186, 0, 0, 10, 145, "orc_clan", 400, 0, 0, "LAST_HIT", 0, 0, 0, "balanced"),
(21116, 21116, "Hames Orc Overlord", 0, "", 0, "Monster.ketra_orc_warrior", 14, 28.8, 75, "male", "L2Monster", 40, 4229, 1673, 13.43, 3.09, 40, 43, 30, 21, 20, 10, 12699, 1340, 1720, 475, 957, 425, 278, 500, 333, 75, 103, 0, 36, 175, "orc_clan", 500, 0, 0, "LAST_HIT", 0, 0, 0, "fighter"),
(21117, 21117, "Kasha Imp", 0, "", 0, "Monster.imp_bi", 10, 30, 19, "male", "L2Monster", 40, 508, 203, 3.95, 1.21, 40, 43, 30, 21, 20, 10, 678, 30, 53, 77, 21, 73, 278, 0, 333, 0, 0, 0, 66, 93, "NULL", 0, 0, 0, "LAST_HIT", 0, 0, 0, "fighter"),
(21118, 21118, "Baar Dre Vanul", 0, "", 0, "Monster.dre_vanul", 14, 36, 20, "male", "L2Monster", 40, 541, 213, 3.95, 1.21, 40, 43, 30, 21, 20, 10, 726, 32, 57, 94, 23, 76, 278, 400, 333, 0, 0, 0, 88, 93, "demonic_clan", 300, 0, 0, "LAST_HIT", 0, 0, 0, "fighter"),
(21119, 21119, "Hobgoblin", 0, "", 0, "Monster.hobgoblin", 12, 24, 21, "male", "L2Monster", 40, 575, 227, 5.53, 1.53, 40, 43, 30, 21, 20, 10, 764, 35, 63, 98, 25, 80, 278, 0, 333, 4, 0, 0, 49, 121, "goblin_clan", 300, 0, 0, "LAST_HIT", 0, 0, 0, "fighter"),
(21120, 21120, "Kasha Imp Turen", 0, "", 0, "Monster.imp_bi", 10, 30, 22, "male", "L2Monster", 40, 611, 242, 5.53, 1.53, 40, 43, 30, 21, 20, 10, 996, 47, 75, 79, 28, 83, 278, 400, 333, 0, 0, 0, 66, 93, "NULL", 0, 0, 0, "LAST_HIT", 0, 0, 0, "fighter"),
(21121, 21121, "Kasha Dire Wolf", 0, "", 0, "Monster.dire_wolf", 13, 11, 23, "male", "L2Monster", 40, 648, 257, 5.53, 1.53, 40, 43, 30, 21, 20, 10, 895, 43, 75, 91, 31, 87, 278, 400, 333, 0, 0, 0, 26, 148, "NULL", 0, 0, 0, "LAST_HIT", 0, 0, 0, "fighter"),
(21122, 21122, "Kasha Bugbear", 0, "", 0, "Monster.bugbear", 17, 35, 24, "male", "L2Monster", 40, 687, 272, 5.53, 1.53, 40, 43, 30, 21, 20, 10, 954, 47, 81, 111, 34, 90, 278, 400, 333, 169, 0, 0, 60, 143, "NULL", 0, 0, 0, "LAST_HIT", 0, 0, 0, "fighter"),
(21123, 21123, "Baar Dre Vanul Destroyer", 0, "", 0, "Monster.dre_vanul", 14, 36, 25, "male", "L2Monster", 40, 728, 287, 5.53, 1.53, 40, 43, 30, 21, 20, 10, 1267, 63, 97, 105, 37, 94, 278, 400, 333, 0, 0, 0, 88, 93, "demonic_clan", 300, 0, 0, "LAST_HIT", 0, 0, 0, "fighter"),
(21124, 21124, "Red Eye Barbed Bat", 0, "", 0, "Monster.vampire_bat", 10, 33.5, 18, "male", "L2Monster", 40, 476, 193, 3.95, 1.21, 40, 43, 30, 21, 20, 10, 640, 28, 48, 73, 19, 70, 278, 0, 333, 0, 0, 0, 66, 99, "NULL", 0, 0, 0, "LAST_HIT", 0, 0, 0, "fighter"),
(21125, 21125, "Northern Trimden", 0, "", 0, "Monster.poison_spider", 27, 25.5, 19, "male", "L2Monster", 40, 508, 203, 3.95, 1.21, 40, 43, 30, 21, 20, 10, 684, 31, 53, 90, 21, 73, 278, 400, 333, 0, 0, 0, 66, 154, "NULL", 0, 0, 0, "LAST_HIT", 0, 0, 0, "fighter"),
(21126, 21126, "Kerope Werewolf", 0, "", 0, "Monster.werewolf_bi", 11, 29.7, 20, "male", "L2Monster", 40, 541, 213, 3.95, 1.21, 40, 43, 30, 21, 20, 10, 712, 32, 57, 80, 23, 76, 278, 0, 333, 0, 0, 0, 55, 137, "werewolf_clan", 300, 0, 0, "LAST_HIT", 0, 0, 0, "fighter"),
(21127, 21127, "Northern Goblin", 0, "", 0, "Monster2.northern_goblin", 4, 15, 21, "male", "L2Monster", 40, 575, 227, 5.53, 1.53, 40, 43, 30, 21, 20, 10, 764, 35, 63, 98, 25, 80, 278, 0, 333, 152, 0, 0, 33, 132, "goblin_clan", 300, 0, 0, "LAST_HIT", 0, 0, 0, "fighter"),
(21128, 21128, "Spine Golem", 0, "", 0, "Monster.stone_golem_bi", 20, 40.3, 22, "male", "L2Monster", 40, 611, 242, 5.53, 1.53, 40, 43, 30, 21, 20, 10, 821, 39, 68, 102, 28, 83, 278, 0, 333, 0, 0, 0, 25, 25, "NULL", 0, 0, 0, "LAST_HIT", 0, 0, 0, "fighter"),
(21129, 21129, "Kerope Werewolf Chief", 0, "", 0, "Monster.werewolf_bi", 11, 29.7, 23, "male", "L2Monster", 40, 648, 257, 5.53, 1.53, 40, 43, 30, 21, 20, 10, 895, 43, 82, 82, 31, 87, 278, 400, 333, 0, 0, 0, 55, 154, "werewolf_clan", 300, 0, 0, "LAST_HIT", 0, 0, 0, "fighter"),
(21130, 21130, "Northern Goblin Leader", 0, "", 0, "Monster2.northern_goblin", 4, 15, 24, "male", "L2Monster", 40, 687, 272, 5.53, 1.53, 40, 43, 30, 21, 20, 10, 954, 47, 81, 111, 34, 90, 278, 400, 333, 66, 102, 0, 33, 137, "goblin_clan", 300, 0, 0, "LAST_HIT", 0, 0, 0, "fighter"),
(21131, 21131, "Enchanted Spine Golem", 0, "", 0, "Monster.stone_golem_bi", 20, 40.3, 25, "male", "L2Monster", 40, 728, 287, 5.53, 1.53, 40, 43, 30, 21, 20, 10, 992, 50, 97, 105, 37, 94, 278, 0, 333, 0, 0, 0, 25, 31, "NULL", 0, 0, 0, "LAST_HIT", 0, 0, 0, "fighter"),
(21132, 21132, "Underground Kobold", 0, "", 0, "Monster.kobold", 10, 15, 24, "male", "L2Monster", 40, 687, 272, 5.53, 1.53, 40, 43, 30, 21, 20, 10, 779, 38, 81, 94, 34, 90, 278, 0, 333, 0, 0, 0, 51, 121, "kobold_clan", 300, 0, 0, "LAST_HIT", 0, 0, 0, "fighter"),
(21133, 21133, "Dead Pit Skeleton Archer", 0, "", 0, "Monster.skeleton_archer", 11, 27, 25, "male", "L2Monster", 500, 728, 287, 5.53, 1.53, 40, 43, 30, 21, 20, 10, 851, 43, 197, 98, 37, 94, 249, 0, 333, 274, 0, 0, 44, 143, "undead_clan", 300, 1, 0, "LAST_HIT", 0, 0, 0, "archer"),
(21134, 21134, "Dead Pit Spartoi", 0, "", 0, "Monster.spartoi", 11, 27, 26, "male", "L2Monster", 40, 770, 303, 5.53, 1.53, 40, 43, 30, 21, 20, 10, 898, 45, 96, 102, 41, 98, 278, 400, 333, 219, 0, 0, 66, 159, "undead_clan", 300, 1, 0, "LAST_HIT", 0, 0, 0, "fighter"),
(21135, 21135, "Underground Kobold Warrior", 0, "", 0, "Monster.kobold", 10, 15, 27, "male", "L2Monster", 40, 813, 318, 5.53, 1.53, 40, 43, 30, 21, 20, 10, 1103, 56, 114, 114, 45, 102, 278, 0, 333, 0, 0, 0, 51, 126, "kobold_clan", 300, 0, 0, "LAST_HIT", 0, 0, 0, "fighter"),
(21136, 21136, "Dead Pit Horror", 0, "", 0, "Monster.dark_horror", 20, 35, 28, "male", "L2Monster", 40, 859, 334, 5.53, 1.53, 40, 43, 30, 21, 20, 10, 981, 52, 113, 110, 49, 106, 278, 0, 333, 0, 0, 0, 110, 110, "undead_clan", 300, 1, 0, "LAST_HIT", 0, 0, 0, "fighter"),
(21137, 21137, "Iron Ore Golem", 0, "", 0, "Monster.iron_golem", 18, 34, 29, "male", "L2Monster", 40, 906, 349, 5.53, 1.53, 40, 43, 30, 21, 20, 10, 1057, 57, 111, 149, 53, 110, 278, 400, 333, 0, 0, 0, 22, 23, "NULL", 0, 0, 0, "LAST_HIT", 0, 0, 0, "fighter"),
(21138, 21138, "Greedy Geist", 0, "", 0, "Monster.hungry_spirit", 30, 40, 30, "male", "L2Monster", 40, 954, 365, 5.53, 1.53, 40, 43, 30, 21, 20, 10, 1134, 62, 132, 119, 58, 114, 278, 0, 333, 0, 0, 0, 16, 165, "undead_clan", 300, 1, 0, "LAST_HIT", 0, 0, 0, "fighter"),
(21139, 21139, "Catacomb Barbed Bat", 0, "", 0, "Monster.vampire_bat", 10, 33.5, 23, "male", "L2Monster", 40, 648, 257, 22.12, 1.53, 40, 43, 30, 21, 20, 10, 655, 31, 75, 91, 31, 87, 278, 500, 333, 0, 0, 0, 66, 143, "c_dungeon_clan", 300, 0, 0, "LAST_HIT", 0, 0, 0, "fighter"),
(21140, 21140, "Catacomb Wisp", 0, "", 0, "Monster.will_o_wisp", 13, 22, 26, "male", "L2Monster", 40, 770, 303, 22.12, 1.53, 40, 43, 30, 21, 20, 10, 788, 39, 96, 102, 41, 98, 278, 500, 333, 0, 0, 0, 88, 132, "c_dungeon_clan", 300, 0, 0, "LAST_HIT", 0, 0, 0, "fighter"),
(21141, 21141, "Catacomb Serpent", 0, "", 0, "Monster.serpent_slave", 17, 46, 28, "male", "L2Monster", 40, 859, 334, 22.12, 1.53, 40, 43, 30, 21, 20, 10, 926, 48, 113, 110, 49, 106, 278, 500, 333, 73, 0, 0, 77, 143, "c_dungeon_clan", 300, 0, 0, "LAST_HIT", 0, 0, 0, "fighter"),
(21142, 21142, "Grave Keeper Spartoi", 0, "", 0, "Monster.spartoi", 11, 27, 29, "male", "L2Monster", 40, 906, 349, 22.12, 1.53, 40, 43, 30, 21, 20, 10, 927, 49, 111, 149, 53, 110, 278, 500, 333, 221, 0, 0, 66, 154, "c_dungeon_clan", 300, 1, 0, "LAST_HIT", 0, 0, 0, "fighter"),
(21143, 21143, "Catacomb Scavenger Bat", 0, "", 0, "Monster.vampire_bat", 10, 33.5, 31, "male", "L2Monster", 40, 1004, 381, 28.44, 1.84, 40, 43, 30, 21, 20, 10, 1042, 57, 142, 124, 64, 118, 278, 500, 333, 0, 0, 0, 60, 140, "c_dungeon_clan", 300, 0, 0, "LAST_HIT", 0, 0, 0, "fighter"),
(21144, 21144, "Catacomb Shadow", 0, "", 0, "Monster.shadow", 10, 30, 34, "male", "L2Monster", 40, 1164, 430, 28.44, 1.84, 40, 43, 30, 21, 20, 10, 1254, 73, 178, 138, 82, 132, 278, 500, 333, 0, 0, 0, 80, 130, "c_dungeon_clan", 300, 0, 0, "LAST_HIT", 0, 0, 0, "fighter"),
(21145, 21145, "Catacomb Stakato Soldier", 0, "", 0, "Monster.blade_stakato_soldier", 15, 38, 38, "male", "L2Monster", 40, 1400, 497, 28.44, 1.84, 40, 43, 30, 21, 20, 10, 1611, 100, 238, 160, 112, 153, 278, 500, 333, 232, 0, 0, 25, 150, "c_dungeon_clan", 300, 0, 0, "LAST_HIT", 0, 0, 0, "fighter"),
(21146, 21146, "Grave Keeper Dark Horror", 0, "", 0, "Monster.dark_horror", 20, 35, 40, "male", "L2Monster", 40, 1527, 531, 28.44, 1.84, 40, 43, 30, 21, 20, 10, 1735, 112, 248, 222, 131, 164, 278, 500, 333, 0, 0, 0, 100, 160, "c_dungeon_clan", 300, 1, 0, "LAST_HIT", 0, 0, 0, "fighter"),
(21147, 21147, "Catacomb Gargoyle", 0, "", 0, "Monster.gargoyle", 16, 50, 43, "male", "L2Monster", 40, 1728, 618, 34.76, 2.14, 40, 43, 30, 21, 20, 10, 2114, 143, 332, 223, 163, 181, 278, 500, 333, 0, 0, 0, 140, 170, "c_dungeon_clan", 300, 0, 0, "LAST_HIT", 0, 0, 0, "fighter"),
(21148, 21148, "Catacomb Liviona", 0, "", 0, "Monster.liviona", 15, 28, 44, "male", "L2Monster", 40, 1799, 648, 34.76, 2.14, 40, 43, 30, 21, 20, 10, 2100, 143, 354, 196, 176, 187, 278, 500, 333, 0, 0, 0, 80, 140, "c_dungeon_clan", 300, 0, 0, "LAST_HIT", 0, 0, 0, "fighter"),
(21149, 21149, "Decayed Ancient Pikeman", 0, "", 0, "Monster.skeleton_pikeman", 10, 28, 46, "male", "L2Monster", 40, 1943, 707, 34.76, 2.14, 40, 43, 30, 21, 20, 10, 2419, 171, 401, 245, 202, 199, 278, 500, 333, 96, 0, 0, 50, 170, "c_dungeon_clan", 300, 1, 0, "LAST_HIT", 0, 0, 0, "fighter"),
(21150, 21150, "Decayed Ancient Soldier", 0, "", 0, "Monster.skeleton_knight", 10, 25, 49, "male", "L2Monster", 40, 2168, 799, 34.76, 2.14, 40, 43, 30, 21, 20, 10, 2745, 203, 480, 270, 247, 219, 278, 500, 333, 125, 0, 0, 44, 176, "c_dungeon_clan", 300, 1, 0, "LAST_HIT", 0, 0, 0, "fighter"),
(21151, 21151, "Decayed Ancient Knight", 0, "", 0, "Monster.skeleton_royal_guard", 11, 28.5, 50, "male", "L2Monster", 40, 2245, 830, 34.76, 2.14, 40, 43, 30, 21, 20, 10, 2858, 215, 509, 278, 264, 226, 278, 500, 333, 227, 0, 0, 88, 187, "c_dungeon_clan", 300, 1, 0, "LAST_HIT", 0, 0, 0, "fighter"),
(21152, 21152, "Purgatory Wisp", 0, "", 0, "Monster.will_o_wisp", 13, 22, 53, "male", "L2Monster", 40, 2481, 923, 41.08, 2.45, 40, 43, 30, 21, 20, 10, 3047, 239, 602, 258, 319, 247, 278, 500, 333, 0, 0, 0, 88, 165, "c_dungeon_clan", 300, 0, 0, "LAST_HIT", 0, 0, 0, "fighter"),
(21153, 21153, "Purgatory Serpent", 0, "", 0, "Monster.serpent_slave", 17, 46, 56, "male", "L2Monster", 40, 2724, 1019, 41.08, 2.45, 40, 43, 30, 21, 20, 10, 3586, 294, 706, 281, 382, 269, 278, 500, 333, 73, 0, 0, 77, 192, "c_dungeon_clan", 300, 0, 0, "LAST_HIT", 0, 0, 0, "fighter"),
(21154, 21154, "Hell Keeper Medusa", 0, "", 0, "Monster.medusa", 10, 25, 58, "female", "L2Monster", 40, 2889, 1084, 41.08, 2.45, 40, 43, 30, 21, 20, 10, 3753, 317, 710, 384, 428, 284, 278, 500, 333, 0, 0, 0, 55, 181, "c_dungeon_clan", 300, 0, 0, "LAST_HIT", 0, 0, 0, "fighter"),
(21155, 21155, "Purgatory Conjurer", 0, "", 0, "Monster.vampire_bat", 10, 33.5, 59, "male", "L2Monster", 40, 2971, 1117, 41.08, 2.45, 40, 43, 30, 21, 20, 10, 3776, 322, 820, 305, 453, 291, 278, 500, 333, 0, 0, 0, 66, 192, "c_dungeon_clan", 300, 0, 0, "LAST_HIT", 0, 0, 0, "fighter"),
(21156, 21156, "Purgatory Shadow", 0, "", 0, "Monster.shadow", 10, 30, 61, "male", "L2Monster", 40, 3137, 1184, 47.4, 2.78, 40, 43, 30, 21, 20, 10, 4036, 355, 901, 321, 505, 307, 278, 500, 333, 0, 0, 0, 80, 155, "c_dungeon_clan", 300, 0, 0, "LAST_HIT", 0, 0, 0, "fighter"),
(21157, 21157, "Purgatory Tarantula", 0, "", 0, "Monster.poison_spider", 27, 25.5, 64, "male", "L2Monster", 40, 3384, 1285, 47.4, 2.78, 40, 43, 30, 21, 20, 10, 4569, 418, 1031, 347, 589, 331, 278, 500, 333, 0, 0, 0, 60, 175, "c_dungeon_clan", 300, 0, 0, "LAST_HIT", 0, 0, 0, "fighter"),
(21158, 21158, "Hell Keeper Crimson Doll", 0, "", 0, "Monster.crimson_doll", 15, 38, 67, "male", "L2Monster", 40, 3626, 1388, 47.4, 2.78, 40, 43, 30, 21, 20, 10, 5133, 488, 1063, 483, 681, 356, 278, 500, 333, 0, 0, 0, 60, 180, "c_dungeon_clan", 300, 1, 0, "LAST_HIT", 0, 0, 0, "fighter"),
(21159, 21159, "Purgatory Gargoyle", 0, "", 0, "Monster.gargoyle", 16, 50, 68, "male", "L2Monster", 40, 3706, 1423, 47.4, 2.78, 40, 43, 30, 21, 20, 10, 5287, 510, 1217, 449, 713, 365, 278, 500, 333, 0, 0, 0, 140, 175, "c_dungeon_clan", 300, 0, 0, "LAST_HIT", 0, 0, 0, "fighter"),
(21160, 21160, "Purgatory Liviona", 0, "", 0, "Monster.liviona", 15, 28, 71, "male", "L2Monster", 40, 3938, 1529, 53.72, 3.09, 40, 43, 30, 21, 20, 10, 5468, 548, 1363, 408, 814, 390, 278, 500, 333, 0, 0, 0, 88, 176, "c_dungeon_clan", 300, 0, 0, "LAST_HIT", 0, 0, 0, "fighter"),
(21161, 21161, "Lesser Ancient Soldier", 0, "", 0, "Monster.medusa", 10, 25, 73, "female", "L2Monster", 40, 4086, 1601, 53.72, 3.09, 40, 43, 30, 21, 20, 10, 5945, 611, 1463, 502, 885, 407, 278, 500, 333, 0, 0, 0, 50, 180, "c_dungeon_clan", 300, 0, 0, "LAST_HIT", 0, 0, 0, "fighter"),
(21162, 21162, "Lesser Ancient Scout", 0, "", 0, "Monster.blade_stakato_drone", 15, 39, 74, "male", "L2Monster", 40, 4158, 1637, 53.72, 3.09, 40, 43, 30, 21, 20, 10, 5940, 619, 1513, 512, 921, 416, 278, 500, 333, 135, 0, 0, 25, 160, "c_dungeon_clan", 300, 0, 0, "LAST_HIT", 0, 0, 0, "fighter"),
(21163, 21163, "Lesser Ancient Shaman", 0, "", 0, "Monster.silhouette", 8, 23, 76, "female", "L2Monster", 40, 4297, 1710, 53.72, 3.09, 40, 43, 30, 21, 20, 10, 6265, 669, 1614, 454, 994, 433, 278, 500, 333, 0, 0, 0, 80, 200, "c_dungeon_clan", 300, 0, 0, "LAST_HIT", 0, 0, 0, "fighter"),
(21164, 21164, "Guardian Spirit of Ancient Holy Ground", 0, "", 0, "Monster.death_lord", 21, 40, 79, "male", "L2Monster", 40, 4490, 1821, 53.72, 3.09, 40, 43, 30, 21, 20, 10, 7136, 791, 1765, 566, 1107, 459, 278, 500, 333, 78, 0, 0, 44, 209, "c_dungeon_clan", 300, 1, 0, "LAST_HIT", 0, 0, 0, "fighter"),
(21165, 21165, "Lesser Ancient Warrior", 0, "", 0, "Monster.shadeless", 7, 28, 80, "male", "L2Monster", 40, 4550, 1859, 53.72, 3.09, 40, 43, 30, 21, 20, 10, 7761, 871, 2195, 476, 1144, 468, 278, 500, 333, 0, 0, 0, 48, 200, "c_dungeon_clan", 300, 0, 0, "LAST_HIT", 0, 0, 0, "fighter"),
(21166, 21166, "Lith Scout", 0, "", 0, "Monster2.temple_guard_a_20_sm", 12, 33.6, 21, "male", "L2Monster", 40, 575, 227, 22.12, 1.53, 40, 43, 30, 21, 20, 10, 594, 27, 66, 69, 25, 80, 317, 0, 333, 5795, 0, 0, 58, 143, "c_dungeon_clan", 400, 0, 0, "LAST_HIT", 0, 0, 0, "fighter"),
(21167, 21167, "Lith Witch", 0, "", 0, "Monster2.temple_savant_a_20_sm", 8, 32, 24, "male", "L2Monster", 40, 687, 272, 22.12, 1.53, 40, 43, 30, 21, 20, 10, 690, 34, 98, 92, 34, 90, 278, 0, 333, 5797, 0, 0, 27, 121, "c_dungeon_clan", 400, 0, 0, "LAST_HIT", 0, 0, 0, "fighter"),
(21168, 21168, "Lith Warrior", 0, "", 0, "Monster2.temple_guard_b_20_sm", 12, 33.6, 27, "male", "L2Monster", 40, 813, 318, 22.12, 1.53, 40, 43, 30, 21, 20, 10, 855, 43, 126, 103, 45, 102, 278, 0, 333, 5796, 0, 0, 58, 143, "c_dungeon_clan", 400, 0, 0, "LAST_HIT", 0, 0, 0, "fighter"),
(21169, 21169, "Lith Guard", 0, "", 0, "Monster2.temple_guard_a", 15, 42, 30, "male", "L2Monster", 40, 954, 365, 22.12, 1.53, 40, 43, 30, 21, 20, 10, 1133, 62, 140, 99, 58, 114, 317, 0, 333, 5795, 0, 0, 53, 140, "c_dungeon_clan", 400, 0, 0, "LAST_HIT", 0, 0, 0, "fighter"),
(21170, 21170, "Lith Medium", 0, "", 0, "Monster2.temple_savant_a", 10, 40, 33, "male", "L2Monster", 40, 1109, 413, 28.44, 1.84, 40, 43, 30, 21, 20, 10, 1307, 75, 201, 130, 75, 128, 278, 0, 333, 5797, 0, 0, 25, 120, "c_dungeon_clan", 400, 0, 0, "LAST_HIT", 0, 0, 0, "fighter"),
(21171, 21171, "Lith Overlord", 0, "", 0, "Monster2.temple_guard_b", 15, 42, 36, "male", "L2Monster", 40, 1279, 463, 28.44, 1.84, 40, 43, 30, 21, 20, 10, 1669, 101, 250, 145, 96, 142, 278, 0, 333, 5796, 0, 0, 53, 140, "c_dungeon_clan", 400, 0, 0, "LAST_HIT", 0, 0, 0, "fighter"),
(21172, 21172, "Lith Patrolman", 0, "", 0, "Monster2.temple_guard_a", 15, 42, 39, "male", "L2Monster", 40, 1462, 514, 28.44, 1.84, 40, 43, 30, 21, 20, 10, 1972, 125, 270, 137, 121, 158, 317, 0, 333, 5795, 0, 0, 53, 150, "c_dungeon_clan", 400, 0, 0, "LAST_HIT", 0, 0, 0, "fighter"),
(21173, 21173, "Lith Shaman", 0, "", 0, "Monster2.temple_savant_a", 10, 40, 42, "male", "L2Monster", 40, 1660, 589, 34.76, 2.14, 40, 43, 30, 21, 20, 10, 2118, 141, 377, 178, 152, 175, 278, 0, 333, 5798, 0, 0, 27, 143, "c_dungeon_clan", 400, 0, 0, "LAST_HIT", 0, 0, 0, "fighter"),
(21174, 21174, "Lith Commander", 0, "", 0, "Monster2.temple_guard_b", 15, 42, 45, "male", "L2Monster", 40, 1870, 677, 34.76, 2.14, 40, 43, 30, 21, 20, 10, 2731, 190, 457, 196, 188, 193, 278, 0, 333, 5796, 0, 0, 53, 150, "c_dungeon_clan", 400, 0, 0, "LAST_HIT", 0, 0, 0, "fighter"),
(21175, 21175, "Lilim Butcher", 0, "", 0, "Monster2.lilim_assassin_10_sm", 11, 36, 48, "male", "L2Monster", 40, 2091, 768, 34.76, 2.14, 40, 43, 30, 21, 20, 10, 3093, 226, 480, 183, 231, 212, 317, 0, 333, 232, 232, 0, 36, 170, "c_dungeon_clan", 400, 0, 0, "LAST_HIT", 0, 0, 0, "fighter"),
(21176, 21176, "Lilim Magus", 0, "", 0, "Monster2.lilim_wizard_10_sm", 8, 30.6, 51, "female", "L2Monster", 40, 2323, 861, 41.08, 2.45, 40, 43, 30, 21, 20, 10, 3123, 238, 652, 237, 281, 232, 278, 0, 333, 0, 0, 0, 50, 140, "c_dungeon_clan", 400, 0, 0, "LAST_HIT", 0, 0, 0, "mage"),
(21177, 21177, "Lilim Knight Errant", 0, "", 0, "Monster2.lilim_knight_10_sm", 11, 45, 54, "male", "L2Monster", 40, 2562, 955, 41.08, 2.45, 40, 43, 30, 21, 20, 10, 4385, 349, 769, 258, 339, 254, 278, 0, 333, 5800, 5799, 0, 61, 187, "c_dungeon_clan", 400, 0, 0, "LAST_HIT", 0, 0, 0, "fighter"),
(21178, 21178, "Lilim Marauder", 0, "", 0, "Monster2.lilim_assassin_10_sm", 11, 36, 57, "male", "L2Monster", 40, 2806, 1052, 41.08, 2.45, 40, 43, 30, 21, 20, 10, 4697, 390, 786, 239, 405, 276, 317, 0, 333, 229, 229, 0, 39, 198, "c_dungeon_clan", 400, 0, 0, "LAST_HIT", 0, 0, 0, "fighter"),
(21179, 21179, "Lilim Priest", 0, "", 0, "Monster2.lilim_wizard_10_sm", 8, 30.6, 60, "female", "L2Monster", 40, 3054, 1150, 41.08, 2.45, 40, 43, 30, 21, 20, 10, 4322, 375, 1041, 304, 478, 299, 278, 0, 333, 0, 0, 0, 50, 160, "c_dungeon_clan", 400, 0, 0, "LAST_HIT", 0, 0, 0, "balanced"),
(21180, 21180, "Lilim Knight", 0, "", 0, "Monster2.lilim_knight_10_sm", 11, 45, 63, "male", "L2Monster", 40, 3302, 1251, 47.4, 2.78, 40, 43, 30, 21, 20, 10, 6489, 586, 1194, 329, 560, 323, 361, 0, 333, 5800, 5799, 0, 56, 180, "c_dungeon_clan", 400, 0, 0, "LAST_HIT", 0, 0, 0, "fighter"),
(21181, 21181, "Lilim Assassin", 0, "", 0, "Monster2.lilim_assassin_10_bi", 13, 44, 66, "male", "L2Monster", 40, 3546, 1353, 47.4, 2.78, 40, 43, 30, 21, 20, 10, 6868, 646, 1189, 301, 649, 348, 317, 0, 333, 234, 234, 0, 36, 190, "c_dungeon_clan", 400, 0, 0, "LAST_HIT", 0, 0, 0, "fighter"),
(21182, 21182, "Lilim Soldier", 0, "", 0, "Monster2.lilim_wizard_10_bi", 10, 37.5, 69, "female", "L2Monster", 40, 3784, 1458, 47.4, 2.78, 40, 43, 30, 21, 20, 10, 5717, 559, 1531, 380, 746, 373, 278, 0, 333, 0, 0, 0, 50, 170, "c_dungeon_clan", 400, 0, 0, "LAST_HIT", 0, 0, 0, "balanced"),
(21183, 21183, "Lilim Knight Banneret", 0, "", 0, "Monster2.lilim_knight_10_bi", 13, 55, 72, "male", "L2Monster", 40, 4013, 1565, 53.72, 3.09, 40, 43, 30, 21, 20, 10, 8475, 861, 1710, 406, 849, 399, 361, 0, 333, 5800, 5799, 0, 56, 190, "c_dungeon_clan", 400, 0, 0, "LAST_HIT", 0, 0, 0, "fighter"),
(21184, 21184, "Lilim Slayer", 0, "", 0, "Monster2.lilim_assassin_10_bi", 13, 44, 75, "male", "L2Monster", 40, 4229, 1673, 53.72, 3.09, 40, 43, 30, 21, 20, 10, 8869, 935, 1655, 367, 957, 425, 317, 0, 333, 236, 236, 0, 36, 200, "c_dungeon_clan", 400, 0, 0, "LAST_HIT", 0, 0, 0, "fighter"),
(21185, 21185, "Lilim Great Mystic", 0, "", 0, "Monster2.lilim_wizard_10_bi", 10, 37.5, 78, "female", "L2Monster", 40, 4428, 1784, 53.72, 3.09, 40, 43, 30, 21, 20, 10, 7305, 799, 2075, 459, 1069, 451, 278, 0, 333, 0, 0, 0, 50, 180, "c_dungeon_clan", 400, 0, 0, "LAST_HIT", 0, 0, 0, "mage"),
(21186, 21186, "Lilim Court Knight", 0, "", 0, "Monster2.lilim_knight_10_bi", 13, 55, 80, "male", "L2Monster", 40, 4550, 1859, 53.72, 3.09, 40, 43, 30, 21, 20, 10, 10464, 1174, 2195, 476, 1144, 468, 361, 0, 333, 5800, 5799, 0, 56, 200, "c_dungeon_clan", 400, 0, 0, "LAST_HIT", 0, 0, 0, "fighter"),
(21187, 21187, "Gigant Slave", 0, "", 0, "Monster2.tomb_guard_a_20_sm", 8, 32, 21, "male", "L2Monster", 40, 575, 227, 22.12, 1.53, 40, 43, 30, 21, 20, 10, 594, 27, 76, 69, 25, 80, 278, 0, 333, 5791, 0, 0, 53, 143, "c_dungeon_clan", 400, 0, 0, "LAST_HIT", 0, 0, 0, "fighter"),
(21188, 21188, "Gigant Acolyte", 0, "", 0, "Monster2.tomb_savant_a_20_sm", 8, 32, 24, "male", "L2Monster", 40, 687, 272, 22.12, 1.53, 40, 43, 30, 21, 20, 10, 690, 34, 98, 92, 34, 90, 278, 0, 333, 5793, 0, 0, 53, 121, "c_dungeon_clan", 400, 0, 0, "LAST_HIT", 0, 0, 0, "fighter"),
(21189, 21189, "Gigant Overseer", 0, "", 0, "Monster2.tomb_guard_b_20_sm", 12, 34, 27, "male", "L2Monster", 40, 813, 318, 22.12, 1.53, 40, 43, 30, 21, 20, 10, 855, 43, 126, 103, 45, 102, 278, 0, 333, 5792, 0, 0, 53, 143, "c_dungeon_clan", 400, 0, 0, "LAST_HIT", 0, 0, 0, "fighter"),
(21190, 21190, "Gigant Footman", 0, "", 0, "Monster2.tomb_guard_a", 10, 40, 30, "male", "L2Monster", 40, 954, 365, 22.12, 1.53, 40, 43, 30, 21, 20, 10, 1133, 62, 160, 99, 58, 114, 278, 0, 333, 5791, 0, 0, 49, 140, "c_dungeon_clan", 400, 0, 0, "LAST_HIT", 0, 0, 0, "fighter"),
(21191, 21191, "Gigant Cleric", 0, "", 0, "Monster2.tomb_savant_a", 10, 40, 33, "male", "L2Monster", 40, 1109, 413, 28.44, 1.84, 40, 43, 30, 21, 20, 10, 1307, 75, 201, 130, 75, 128, 278, 0, 333, 5793, 0, 0, 49, 120, "c_dungeon_clan", 400, 0, 0, "LAST_HIT", 0, 0, 0, "fighter"),
(21192, 21192, "Gigant Officer", 0, "", 0, "Monster2.tomb_guard_b", 15, 42.5, 36, "male", "L2Monster", 40, 1279, 463, 28.44, 1.84, 40, 43, 30, 21, 20, 10, 1669, 101, 250, 145, 96, 142, 278, 0, 333, 5792, 0, 0, 49, 140, "c_dungeon_clan", 400, 0, 0, "LAST_HIT", 0, 0, 0, "fighter"),
(21193, 21193, "Gigant Raider", 0, "", 0, "Monster2.tomb_guard_a", 10, 40, 39, "male", "L2Monster", 40, 1462, 514, 28.44, 1.84, 40, 43, 30, 21, 20, 10, 1972, 125, 308, 137, 121, 158, 278, 0, 333, 5791, 0, 0, 49, 150, "c_dungeon_clan", 400, 0, 0, "LAST_HIT", 0, 0, 0, "fighter"),
(21194, 21194, "Gigant Confessor", 0, "", 0, "Monster2.tomb_savant_a", 10, 40, 42, "male", "L2Monster", 40, 1660, 589, 34.76, 2.14, 40, 43, 30, 21, 20, 10, 2118, 141, 377, 178, 152, 175, 278, 0, 333, 5794, 0, 0, 53, 143, "c_dungeon_clan", 400, 0, 0, "LAST_HIT", 0, 0, 0, "fighter"),
(21195, 21195, "Gigant Commander", 0, "", 0, "Monster2.tomb_guard_b", 15, 42.5, 45, "male", "L2Monster", 40, 1870, 677, 34.76, 2.14, 40, 43, 30, 21, 20, 10, 2731, 190, 457, 196, 188, 193, 278, 0, 333, 5792, 0, 0, 49, 150, "c_dungeon_clan", 400, 0, 0, "LAST_HIT", 0, 0, 0, "fighter"),
(21196, 21196, "Nephilim Sentinel", 0, "", 0, "Monster2.nephilim_slayer_10_sm", 11, 32.4, 48, "male", "L2Monster", 40, 2091, 768, 34.76, 2.14, 40, 43, 30, 21, 20, 10, 3093, 226, 548, 183, 231, 212, 278, 0, 333, 0, 0, 0, 65, 170, "c_dungeon_clan", 400, 0, 0, "LAST_HIT", 0, 0, 0, "fighter"),
(21197, 21197, "Nephilim Priest", 0, "", 0, "Monster2.nephilim_priest_10_sm", 21, 36.5, 51, "male", "L2Monster", 40, 2323, 861, 41.08, 2.45, 40, 43, 30, 21, 20, 10, 3391, 258, 652, 237, 281, 232, 278, 0, 333, 0, 0, 0, 50, 140, "c_dungeon_clan", 400, 0, 0, "LAST_HIT", 0, 0, 0, "fighter"),
(21198, 21198, "Nephilim Swordsman", 0, "", 0, "Monster2.nephilim_lord_10_sm", 9, 37.4, 54, "male", "L2Monster", 40, 2562, 955, 41.08, 2.45, 40, 43, 30, 21, 20, 10, 4385, 349, 769, 258, 339, 254, 278, 0, 333, 0, 0, 0, 71, 187, "c_dungeon_clan", 400, 0, 0, "LAST_HIT", 0, 0, 0, "fighter"),
(21199, 21199, "Nephilim Guard", 0, "", 0, "Monster2.nephilim_slayer_10_sm", 11, 32.4, 57, "male", "L2Monster", 40, 2806, 1052, 41.08, 2.45, 40, 43, 30, 21, 20, 10, 4697, 390, 899, 239, 405, 276, 278, 0, 333, 0, 0, 0, 71, 198, "c_dungeon_clan", 400, 0, 0, "LAST_HIT", 0, 0, 0, "fighter"),
(21200, 21200, "Nephilim Bishop", 0, "", 0, "Monster2.nephilim_priest_10_sm", 21, 36.5, 60, "male", "L2Monster", 40, 3054, 1150, 41.08, 2.45, 40, 43, 30, 21, 20, 10, 4694, 407, 1041, 304, 478, 299, 278, 0, 333, 0, 0, 0, 55, 176, "c_dungeon_clan", 400, 0, 0, "LAST_HIT", 0, 0, 0, "fighter"),
(21201, 21201, "Nephilim Centurion", 0, "", 0, "Monster2.nephilim_lord_10_sm", 9, 37.4, 63, "male", "L2Monster", 40, 3302, 1251, 47.4, 2.78, 40, 43, 30, 21, 20, 10, 6489, 586, 1194, 329, 560, 323, 278, 0, 333, 0, 0, 0, 71, 198, "c_dungeon_clan", 400, 0, 0, "LAST_HIT", 0, 0, 0, "fighter"),
(21202, 21202, "Nephilim Scout", 0, "", 0, "Monster2.nephilim_slayer_10_bi", 13, 39.6, 66, "male", "L2Monster", 40, 3546, 1353, 47.4, 2.78, 40, 43, 30, 21, 20, 10, 6868, 646, 1358, 301, 649, 348, 278, 0, 333, 0, 0, 0, 65, 190, "c_dungeon_clan", 400, 0, 0, "LAST_HIT", 0, 0, 0, "fighter"),
(21203, 21203, "Nephilim Archbishop", 0, "", 0, "Monster2.nephilim_priest_10_bi", 21, 44, 69, "male", "L2Monster", 40, 3784, 1458, 47.4, 2.78, 40, 43, 30, 21, 20, 10, 6208, 607, 1531, 380, 746, 373, 278, 0, 333, 0, 0, 0, 55, 187, "c_dungeon_clan", 400, 0, 0, "LAST_HIT", 0, 0, 0, "fighter"),
(21204, 21204, "Nephilim Praetorian", 0, "", 0, "Monster2.nephilim_lord_10_bi", 13, 48, 72, "male", "L2Monster", 40, 4013, 1565, 53.72, 3.09, 40, 43, 30, 21, 20, 10, 8475, 861, 1710, 406, 849, 399, 278, 0, 333, 0, 0, 0, 65, 190, "c_dungeon_clan", 400, 0, 0, "LAST_HIT", 0, 0, 0, "fighter"),
(21205, 21205, "Nephilim Royal Guard", 0, "", 0, "Monster2.nephilim_slayer_10_bi", 13, 39.6, 75, "male", "L2Monster", 40, 4229, 1673, 53.72, 3.09, 40, 43, 30, 21, 20, 10, 8869, 935, 1892, 367, 957, 425, 278, 0, 333, 0, 0, 0, 65, 200, "c_dungeon_clan", 400, 0, 0, "LAST_HIT", 0, 0, 0, "fighter"),
(21206, 21206, "Nephilim Cardinal", 0, "", 0, "Monster2.nephilim_priest_10_bi", 21, 44, 78, "male", "L2Monster", 40, 4428, 1784, 53.72, 3.09, 40, 43, 30, 21, 20, 10, 7933, 868, 2075, 459, 1069, 451, 278, 0, 333, 0, 0, 0, 50, 180, "c_dungeon_clan", 400, 0, 0, "LAST_HIT", 0, 0, 0, "fighter"),
(21207, 21207, "Nephilim Commander", 0, "", 0, "Monster2.nephilim_lord_10_bi", 11, 45.3, 80, "male", "L2Monster", 40, 4550, 1859, 53.72, 3.09, 40, 43, 30, 21, 20, 10, 10464, 1174, 2195, 476, 1144, 468, 278, 0, 333, 0, 0, 0, 71, 220, "c_dungeon_clan", 400, 0, 0, "LAST_HIT", 0, 0, 0, "fighter"),
(21208, 21208, "Hallowed Watchman", 0, "", 0, "Monster.skeleton", 11, 25, 20, "male", "L2Monster", 40, 541, 213, 15.8, 1.21, 40, 43, 30, 21, 20, 10, 521, 23, 57, 94, 23, 76, 278, 0, 333, 216, 111, 0, 66, 143, "c_dungeon_clan", 300, 1, 0, "LAST_HIT", 0, 0, 0, "fighter"),
(21209, 21209, "Hallowed Seer", 0, "", 0, "Monster.binding", 12, 21, 22, "male", "L2Monster", 40, 611, 242, 22.12, 1.53, 40, 43, 30, 21, 20, 10, 612, 29, 68, 87, 28, 83, 278, 500, 333, 0, 0, 0, 11, 121, "c_dungeon_clan", 300, 1, 0, "LAST_HIT", 0, 0, 0, "fighter"),
(21210, 21210, "Vault Guardian", 0, "", 0, "Monster.imp", 10, 24, 25, "male", "L2Monster", 40, 728, 287, 22.12, 1.53, 40, 43, 30, 21, 20, 10, 780, 39, 88, 116, 37, 94, 278, 500, 333, 0, 0, 0, 66, 143, "c_dungeon_clan", 300, 0, 0, "LAST_HIT", 0, 0, 0, "fighter"),
(21211, 21211, "Vault Seer", 0, "", 0, "Monster.succubus", 10, 36, 27, "female", "L2Monster", 40, 813, 318, 22.12, 1.53, 40, 43, 30, 21, 20, 10, 830, 42, 104, 106, 45, 102, 278, 500, 333, 0, 0, 0, 66, 121, "c_dungeon_clan", 300, 0, 0, "LAST_HIT", 0, 0, 0, "fighter"),
(21212, 21212, "Hallowed Sentinel", 0, "", 0, "Monster.skeleton_bi", 11, 31, 30, "male", "L2Monster", 40, 954, 365, 22.12, 1.53, 40, 43, 30, 21, 20, 10, 957, 52, 132, 140, 58, 114, 278, 0, 333, 69, 646, 0, 66, 154, "c_dungeon_clan", 300, 1, 0, "LAST_HIT", 0, 0, 0, "fighter"),
(21213, 21213, "Hallowed Monk", 0, "", 0, "Monster.binding_20_bi", 14, 25.3, 32, "male", "L2Monster", 40, 1056, 397, 28.44, 1.84, 40, 43, 30, 21, 20, 10, 1110, 62, 154, 129, 69, 123, 278, 500, 333, 0, 0, 0, 11, 121, "c_dungeon_clan", 300, 1, 0, "LAST_HIT", 0, 0, 0, "fighter"),
(21214, 21214, "Vault Sentinel", 0, "", 0, "Monster.imp_bi", 10, 30, 35, "male", "L2Monster", 40, 1220, 446, 28.44, 1.84, 40, 43, 30, 21, 20, 10, 1400, 83, 192, 169, 89, 137, 278, 500, 333, 0, 0, 0, 66, 154, "c_dungeon_clan", 300, 0, 0, "LAST_HIT", 0, 0, 0, "fighter"),
(21215, 21215, "Vault Monk", 0, "", 0, "Monster.succubus_bi", 10, 43.2, 37, "female", "L2Monster", 40, 1338, 480, 28.44, 1.84, 40, 43, 30, 21, 20, 10, 1485, 91, 222, 154, 104, 147, 278, 500, 333, 0, 0, 0, 66, 132, "c_dungeon_clan", 300, 0, 0, "LAST_HIT", 0, 0, 0, "fighter"),
(21216, 21216, "Overlord of the Holy Lands", 0, "", 0, "Monster.skeleton_knight_20_bi", 12, 30.5, 40, "male", "L2Monster", 40, 1527, 531, 28.44, 1.84, 40, 43, 30, 21, 20, 10, 1701, 110, 300, 183, 131, 164, 278, 0, 333, 129, 646, 0, 44, 176, "c_dungeon_clan", 300, 1, 0, "LAST_HIT", 0, 0, 0, "fighter"),
(21217, 21217, "Hallowed Priest", 0, "", 0, "Monster.banshee_20_bi", 10, 27.5, 42, "female", "L2Monster", 40, 1660, 589, 34.76, 2.14, 40, 43, 30, 21, 20, 10, 1913, 127, 311, 183, 152, 175, 278, 500, 333, 0, 0, 0, 80, 135, "c_dungeon_clan", 300, 0, 0, "LAST_HIT", 0, 0, 0, "fighter"),
(21218, 21218, "Vault Overlord", 0, "", 0, "Monster.death_blader_10_sm", 14, 40.5, 45, "male", "L2Monster", 40, 1870, 677, 34.76, 2.14, 40, 43, 30, 21, 20, 10, 2315, 161, 415, 216, 188, 193, 278, 500, 333, 297, 0, 0, 100, 160, "c_dungeon_clan", 300, 1, 0, "LAST_HIT", 0, 0, 0, "fighter"),
(21219, 21219, "Vault Priest", 0, "", 0, "Monster.bloody_queen_10_sm", 13, 38, 47, "female", "L2Monster", 40, 2016, 738, 34.76, 2.14, 40, 43, 30, 21, 20, 10, 2396, 171, 427, 215, 216, 206, 278, 500, 333, 0, 0, 0, 80, 135, "c_dungeon_clan", 300, 0, 0, "LAST_HIT", 0, 0, 0, "fighter"),
(21220, 21220, "Sepulcher Archon", 0, "", 0, "Monster.skeleton_knight_30_bi", 13, 33, 50, "male", "L2Monster", 40, 2245, 830, 34.76, 2.14, 40, 43, 30, 21, 20, 10, 2658, 200, 560, 253, 264, 226, 278, 0, 333, 131, 107, 0, 44, 187, "c_dungeon_clan", 300, 1, 0, "LAST_HIT", 0, 0, 0, "fighter"),
(21221, 21221, "Sepulcher Inquisitor", 0, "", 0, "Monster.banshee_30_bi", 11, 30, 52, "female", "L2Monster", 40, 2402, 892, 41.08, 2.45, 40, 43, 30, 21, 20, 10, 2933, 227, 570, 251, 300, 239, 278, 500, 333, 0, 0, 0, 88, 159, "c_dungeon_clan", 300, 0, 0, "LAST_HIT", 0, 0, 0, "fighter"),
(21222, 21222, "Sepulcher Archon", 0, "", 0, "Monster.death_blader_10_bi", 16, 49.5, 55, "male", "L2Monster", 40, 2643, 987, 41.08, 2.45, 40, 43, 30, 21, 20, 10, 3459, 279, 737, 292, 360, 261, 278, 500, 333, 298, 0, 0, 110, 187, "c_dungeon_clan", 300, 1, 0, "LAST_HIT", 0, 0, 0, "fighter"),
(21223, 21223, "Sepulcher Inquisitor", 0, "", 0, "Monster.bloody_queen_10_bi", 15, 46, 57, "female", "L2Monster", 40, 2806, 1052, 41.08, 2.45, 40, 43, 30, 21, 20, 10, 3524, 293, 743, 289, 405, 276, 278, 500, 333, 0, 0, 0, 88, 159, "c_dungeon_clan", 300, 0, 0, "LAST_HIT", 0, 0, 0, "fighter"),
(21224, 21224, "Sepulcher Guardian", 0, "", 0, "Monster.skeleton_royal_guard_20_bi", 13, 34.5, 60, "male", "L2Monster", 40, 3054, 1150, 41.08, 2.45, 40, 43, 30, 21, 20, 10, 3828, 332, 828, 335, 478, 299, 317, 0, 333, 233, 0, 0, 88, 209, "c_dungeon_clan", 300, 1, 0, "LAST_HIT", 0, 0, 0, "fighter"),
(21225, 21225, "Sepulcher Sage", 0, "", 0, "Monster.vale_master_10_bi", 13, 44, 62, "male", "L2Monster", 40, 3219, 1217, 47.4, 2.78, 40, 43, 30, 21, 20, 10, 4169, 371, 944, 330, 532, 315, 278, 500, 333, 311, 0, 0, 77, 176, "c_dungeon_clan", 300, 0, 0, "LAST_HIT", 0, 0, 0, "fighter"),
(21226, 21226, "Sepulcher Guardian", 0, "", 0, "Monster.death_knight", 12, 31, 65, "male", "L2Monster", 40, 3465, 1319, 47.4, 2.78, 40, 43, 30, 21, 20, 10, 4831, 448, 1184, 380, 619, 340, 278, 500, 333, 0, 0, 0, 27, 190, "c_dungeon_clan", 300, 1, 0, "LAST_HIT", 0, 0, 0, "fighter"),
(21227, 21227, "Sepulcher Sage", 0, "", 0, "Monster.doll_master", 20, 42, 67, "male", "L2Monster", 40, 3626, 1388, 47.4, 2.78, 40, 43, 30, 21, 20, 10, 5444, 518, 1169, 373, 681, 356, 278, 500, 333, 0, 0, 0, 88, 176, "c_dungeon_clan", 300, 1, 0, "LAST_HIT", 0, 0, 0, "fighter"),
(21228, 21228, "Sepulcher Guard ", 0, "", 0, "Monster.skeleton_royal_guard_30_bi", 14, 37.5, 70, "male", "L2Monster", 40, 3862, 1493, 47.4, 2.78, 40, 43, 30, 21, 20, 10, 5211, 516, 1265, 427, 780, 382, 317, 0, 333, 236, 0, 0, 80, 200, "c_dungeon_clan", 300, 1, 0, "LAST_HIT", 0, 0, 0, "fighter"),
(21229, 21229, "Sepulcher Preacher", 0, "", 0, "Monster.vale_master_30_bi", 15, 52, 72, "male", "L2Monster", 40, 4013, 1565, 53.72, 3.09, 40, 43, 30, 21, 20, 10, 5623, 571, 1413, 417, 849, 399, 278, 500, 333, 326, 0, 0, 70, 165, "c_dungeon_clan", 300, 0, 0, "LAST_HIT", 0, 0, 0, "fighter"),
(21230, 21230, "Sepulcher Guard", 0, "", 0, "Monster.death_knight", 12, 31, 75, "male", "L2Monster", 40, 4229, 1673, 53.72, 3.09, 40, 43, 30, 21, 20, 10, 6432, 678, 1720, 475, 957, 425, 278, 500, 333, 0, 0, 0, 27, 200, "c_dungeon_clan", 300, 1, 0, "LAST_HIT", 0, 0, 0, "fighter"),
(21231, 21231, "Sepulcher Preacher", 0, "", 0, "Monster.doll_master_20_bi", 24, 50.4, 77, "male", "L2Monster", 40, 4364, 1747, 53.72, 3.09, 40, 43, 30, 21, 20, 10, 6431, 696, 1664, 463, 1031, 442, 278, 500, 333, 0, 0, 0, 80, 165, "c_dungeon_clan", 300, 1, 0, "LAST_HIT", 0, 0, 0, "fighter"),
(21232, 21232, "Barrow Guardian", 0, "", 0, "Monster.skeleton", 11, 25, 20, "male", "L2Monster", 40, 541, 213, 15.8, 1.21, 40, 43, 30, 21, 20, 10, 521, 23, 57, 94, 23, 76, 278, 0, 333, 216, 0, 0, 66, 143, "c_dungeon_clan", 300, 1, 0, "LAST_HIT", 0, 0, 0, "fighter"),
(21233, 21233, "Barrow Seer", 0, "", 0, "Monster.binding", 12, 21, 22, "male", "L2Monster", 40, 611, 242, 22.12, 1.53, 40, 43, 30, 21, 20, 10, 612, 29, 68, 87, 28, 83, 278, 500, 333, 0, 0, 0, 11, 121, "c_dungeon_clan", 300, 1, 0, "LAST_HIT", 0, 0, 0, "fighter"),
(21234, 21234, "Grave Guardian", 0, "", 0, "Monster.imp", 10, 24, 25, "male", "L2Monster", 40, 728, 287, 22.12, 1.53, 40, 43, 30, 21, 20, 10, 780, 39, 88, 116, 37, 94, 278, 500, 333, 0, 0, 0, 66, 143, "c_dungeon_clan", 300, 0, 0, "LAST_HIT", 0, 0, 0, "fighter"),
(21235, 21235, "Grave Seer", 0, "", 0, "Monster.succubus", 10, 36, 27, "female", "L2Monster", 40, 813, 318, 22.12, 1.53, 40, 43, 30, 21, 20, 10, 830, 42, 104, 106, 45, 102, 278, 500, 333, 0, 0, 0, 66, 121, "c_dungeon_clan", 300, 0, 0, "LAST_HIT", 0, 0, 0, "fighter"),
(21236, 21236, "Barrow Sentinel", 0, "", 0, "Monster.skeleton_bi", 11, 31, 30, "male", "L2Monster", 40, 954, 365, 22.12, 1.53, 40, 43, 30, 21, 20, 10, 957, 52, 132, 140, 58, 114, 278, 0, 333, 69, 0, 0, 60, 140, "c_dungeon_clan", 300, 1, 0, "LAST_HIT", 0, 0, 0, "fighter"),
(21237, 21237, "Barrow Monk", 0, "", 0, "Monster.binding_20_bi", 14, 25.3, 32, "male", "L2Monster", 40, 1056, 397, 28.44, 1.84, 40, 43, 30, 21, 20, 10, 1110, 62, 154, 129, 69, 123, 278, 500, 333, 0, 0, 0, 10, 110, "c_dungeon_clan", 300, 1, 0, "LAST_HIT", 0, 0, 0, "fighter"),
(21238, 21238, "Grave Sentinel", 0, "", 0, "Monster.imp_bi", 10, 30, 35, "male", "L2Monster", 40, 1220, 446, 28.44, 1.84, 40, 43, 30, 21, 20, 10, 1400, 83, 192, 169, 89, 137, 278, 500, 333, 0, 0, 0, 60, 140, "c_dungeon_clan", 300, 0, 0, "LAST_HIT", 0, 0, 0, "fighter"),
(21239, 21239, "Grave Monk", 0, "", 0, "Monster.succubus_bi", 10, 43.2, 37, "female", "L2Monster", 40, 1338, 480, 28.44, 1.84, 40, 43, 30, 21, 20, 10, 1485, 91, 222, 154, 104, 147, 278, 500, 333, 0, 0, 0, 60, 120, "c_dungeon_clan", 300, 0, 0, "LAST_HIT", 0, 0, 0, "fighter"),
(21240, 21240, "Barrow Overlord", 0, "", 0, "Monster.skeleton_knight_20_bi", 12, 30.5, 40, "male", "L2Monster", 40, 1527, 531, 28.44, 1.84, 40, 43, 30, 21, 20, 10, 1701, 110, 300, 183, 131, 164, 278, 0, 333, 129, 0, 0, 44, 176, "c_dungeon_clan", 300, 1, 0, "LAST_HIT", 0, 0, 0, "fighter"),
(21241, 21241, "Barrow Priest", 0, "", 0, "Monster.banshee_20_bi", 10, 27.5, 42, "female", "L2Monster", 40, 1660, 589, 34.76, 2.14, 40, 43, 30, 21, 20, 10, 1913, 127, 311, 183, 152, 175, 278, 500, 333, 0, 0, 0, 88, 148, "c_dungeon_clan", 300, 0, 0, "LAST_HIT", 0, 0, 0, "fighter"),
(21242, 21242, "Grave Overlord", 0, "", 0, "Monster.death_blader_10_sm", 14, 40.5, 45, "male", "L2Monster", 40, 1870, 677, 34.76, 2.14, 40, 43, 30, 21, 20, 10, 2315, 161, 415, 216, 188, 193, 278, 500, 333, 297, 0, 0, 100, 160, "c_dungeon_clan", 300, 1, 0, "LAST_HIT", 0, 0, 0, "fighter"),
(21243, 21243, "Grave Priest", 0, "", 0, "Monster.bloody_queen_10_sm", 13, 38, 47, "female", "L2Monster", 40, 2016, 738, 34.76, 2.14, 40, 43, 30, 21, 20, 10, 2396, 171, 427, 215, 216, 206, 278, 500, 333, 0, 0, 0, 80, 135, "c_dungeon_clan", 300, 0, 0, "LAST_HIT", 0, 0, 0, "fighter"),
(21244, 21244, "Crypt Archon", 0, "", 0, "Monster.skeleton_knight_30_bi", 13, 33, 50, "male", "L2Monster", 40, 2245, 830, 34.76, 2.14, 40, 43, 30, 21, 20, 10, 2658, 200, 560, 253, 264, 226, 278, 0, 333, 131, 0, 0, 44, 187, "c_dungeon_clan", 300, 1, 0, "LAST_HIT", 0, 0, 0, "fighter"),
(21245, 21245, "Crypt Inquisitor", 0, "", 0, "Monster.banshee_30_bi", 11, 30, 52, "female", "L2Monster", 40, 2402, 892, 41.08, 2.45, 40, 43, 30, 21, 20, 10, 2933, 227, 570, 251, 300, 239, 278, 500, 333, 0, 0, 0, 88, 159, "c_dungeon_clan", 300, 0, 0, "LAST_HIT", 0, 0, 0, "fighter"),
(21246, 21246, "Tomb Archon", 0, "", 0, "Monster.death_blader_10_bi", 16, 49.5, 55, "male", "L2Monster", 40, 2643, 987, 41.08, 2.45, 40, 43, 30, 21, 20, 10, 3459, 279, 737, 292, 360, 261, 278, 500, 333, 298, 0, 0, 110, 187, "c_dungeon_clan", 300, 1, 0, "LAST_HIT", 0, 0, 0, "fighter"),
(21247, 21247, "Tomb Inquisitor", 0, "", 0, "Monster.bloody_queen_10_bi", 15, 46, 57, "female", "L2Monster", 40, 2806, 1052, 41.08, 2.45, 40, 43, 30, 21, 20, 10, 3524, 293, 743, 289, 405, 276, 278, 500, 333, 0, 0, 0, 88, 159, "c_dungeon_clan", 300, 0, 0, "LAST_HIT", 0, 0, 0, "fighter"),
(21248, 21248, "Crypt Guardian", 0, "", 0, "Monster.skeleton_royal_guard_20_bi", 13, 34.5, 60, "male", "L2Monster", 40, 3054, 1150, 41.08, 2.45, 40, 43, 30, 21, 20, 10, 3828, 332, 828, 335, 478, 299, 317, 0, 333, 233, 0, 0, 80, 190, "c_dungeon_clan", 300, 1, 0, "LAST_HIT", 0, 0, 0, "fighter"),
(21249, 21249, "Crypt Sage", 0, "", 0, "Monster.vale_master_10_bi", 13, 44, 62, "male", "L2Monster", 40, 3219, 1217, 47.4, 2.78, 40, 43, 30, 21, 20, 10, 4169, 371, 944, 330, 532, 315, 278, 500, 333, 311, 0, 0, 70, 160, "c_dungeon_clan", 300, 0, 0, "LAST_HIT", 0, 0, 0, "fighter"),
(21250, 21250, "Tomb Guardian", 0, "", 0, "Monster.death_knight", 12, 31, 65, "male", "L2Monster", 40, 3465, 1319, 47.4, 2.78, 40, 43, 30, 21, 20, 10, 4831, 448, 1184, 380, 619, 340, 278, 500, 333, 0, 0, 0, 27, 190, "c_dungeon_clan", 300, 1, 0, "LAST_HIT", 0, 0, 0, "fighter"),
(21251, 21251, "Tomb Sage", 0, "", 0, "Monster.doll_master", 20, 42, 67, "male", "L2Monster", 40, 3626, 1388, 47.4, 2.78, 40, 43, 30, 21, 20, 10, 5444, 518, 1169, 373, 681, 356, 278, 500, 333, 0, 0, 0, 80, 160, "c_dungeon_clan", 300, 1, 0, "LAST_HIT", 0, 0, 0, "fighter"),
(21252, 21252, "Crypt Guard ", 0, "", 0, "Monster.skeleton_royal_guard_30_bi", 14, 37.5, 70, "male", "L2Monster", 40, 3862, 1493, 47.4, 2.78, 40, 43, 30, 21, 20, 10, 5211, 516, 1265, 427, 780, 382, 317, 0, 333, 236, 0, 0, 88, 220, "c_dungeon_clan", 300, 1, 0, "LAST_HIT", 0, 0, 0, "fighter"),
(21253, 21253, "Crypt Preacher", 0, "", 0, "Monster.vale_master_30_bi", 15, 52, 72, "male", "L2Monster", 40, 4013, 1565, 53.72, 3.09, 40, 43, 30, 21, 20, 10, 5623, 571, 1413, 417, 849, 399, 278, 500, 333, 326, 0, 0, 77, 181, "c_dungeon_clan", 300, 0, 0, "LAST_HIT", 0, 0, 0, "fighter"),
(21254, 21254, "Tomb Guard", 0, "", 0, "Monster.death_knight", 12, 31, 75, "male", "L2Monster", 40, 4229, 1673, 53.72, 3.09, 40, 43, 30, 21, 20, 10, 6432, 678, 1720, 475, 957, 425, 278, 500, 333, 78, 0, 0, 29, 220, "c_dungeon_clan", 300, 1, 0, "LAST_HIT", 0, 0, 0, "fighter"),
(21255, 21255, "Tomb Preacher", 0, "", 0, "Monster.doll_master_20_bi", 24, 50.4, 77, "male", "L2Monster", 40, 4364, 1747, 53.72, 3.09, 40, 43, 30, 21, 20, 10, 7190, 778, 1664, 463, 1031, 442, 278, 500, 333, 0, 0, 0, 80, 165, "c_dungeon_clan", 300, 1, 0, "LAST_HIT", 0, 0, 0, "fighter"),
(21256, 21256, "Underground Werewolf", 0, "", 0, "Monster.werewolf_bi", 11, 29.7, 23, "male", "L2Monster", 40, 648, 257, 5.53, 1.53, 40, 43, 30, 21, 20, 10, 754, 36, 75, 91, 31, 87, 278, 400, 333, 0, 0, 0, 55, 148, "NULL", 0, 0, 0, "LAST_HIT", 0, 0, 0, "fighter"),
(21257, 21257, "Evil Eye Seer", 0, "", 0, "Monster.monster_eye", 21, 43, 18, "male", "L2Monster", 40, 476, 193, 3.95, 1.21, 40, 43, 30, 21, 20, 10, 646, 28, 48, 73, 19, 70, 278, 0, 333, 0, 0, 0, 99, 170, "NULL", 0, 0, 0, "LAST_HIT", 0, 0, 0, "fighter"),
(21258, 21258, "Fallen Orc Shaman", 0, "", 0, "Monster.ketra_orc_shaman", 10, 23, 58, "male", "L2Monster", 40, 2889, 1084, 10.27, 2.45, 40, 43, 30, 21, 20, 10, 0, 0, 781, 297, 428, 284, 278, 0, 333, 9, 0, 0, 10, 130, "NULL", 0, 0, 0, "LAST_HIT", 0, 0, 0, "balanced"),
(21259, 21259, "Fallen Orc Shaman", 0, "", 0, "Monster.saber_toothed_tiger", 34, 28, 59, "male", "L2Monster", 40, 2971, 1117, 10.27, 2.45, 40, 43, 30, 21, 20, 10, 12983, 1110, 820, 305, 453, 291, 278, 500, 333, 0, 0, 0, 60, 180, "beast_clan", 1000, 0, 0, "LAST_HIT", 0, 0, 0, "fighter"),
(21260, 21260, "Betrayer Orc Hero", 0, "", 0, "Monster.ketra_orc_warrior", 12, 24, 50, "male", "L2Monster", 40, 2245, 830, 8.69, 2.14, 40, 43, 30, 21, 20, 10, 3691, 278, 509, 278, 264, 226, 278, 0, 333, 74, 0, 0, 39, 187, "NULL", 0, 0, 0, "LAST_HIT", 0, 0, 0, "fighter"),
(21261, 21261, "Ol Mahum Transcender", 0, "", 0, "Monster.ol_mahum", 13.5, 25, 50, "male", "L2Monster", 40, 2245, 830, 8.69, 2.14, 40, 43, 30, 21, 20, 10, 4284, 323, 509, 236, 264, 226, 278, 0, 333, 127, 0, 0, 50, 130, "NULL", 0, 0, 0, "LAST_HIT", 0, 0, 0, "fighter"),
(21262, 21262, "Ol Mahum Transcender", 0, "", 0, "Monster.ol_mahum_champion", 14, 27, 53, "male", "L2Monster", 40, 2481, 923, 10.27, 2.45, 40, 43, 30, 21, 20, 10, 7732, 608, 602, 304, 319, 247, 278, 500, 333, 127, 0, 0, 55, 154, "NULL", 0, 0, 0, "LAST_HIT", 0, 0, 0, "fighter"),
(21263, 21263, "Ol Mahum Transcender", 0, "", 0, "Monster.oel_mahum", 20, 37, 55, "male", "L2Monster", 40, 2643, 987, 10.27, 2.45, 40, 43, 30, 21, 20, 10, 11790, 952, 670, 322, 360, 261, 278, 500, 333, 127, 0, 0, 77, 165, "NULL", 0, 0, 0, "LAST_HIT", 0, 0, 0, "fighter"),
(21264, 21264, "Ol Mahum Transcender", 0, "", 0, "Monster.kel_mahum", 13, 26, 58, "male", "L2Monster", 40, 2889, 1084, 10.27, 2.45, 40, 43, 30, 21, 20, 10, 19082, 1612, 781, 349, 428, 284, 278, 500, 333, 127, 0, 0, 55, 176, "NULL", 0, 0, 0, "LAST_HIT", 0, 0, 0, "fighter"),
(21265, 21265, "Cave Ant Larva", 0, "", 0, "Monster.ant_larva", 12, 8, 36, "male", "L2Monster", 40, 1279, 463, 7.11, 1.84, 40, 43, 30, 21, 20, 10, 1586, 96, 206, 175, 96, 142, 278, 0, 333, 0, 0, 0, 44, 66, "ant_clan", 500, 0, 0, "LAST_HIT", 0, 0, 0, "fighter"),
(21266, 21266, "Cave Ant Larva", 0, "", 0, "Monster.ant_larva", 12, 8, 36, "male", "L2Monster", 40, 1279, 463, 7.11, 1.84, 40, 43, 30, 21, 20, 10, 0, 0, 206, 175, 96, 142, 278, 0, 333, 0, 0, 0, 44, 66, "ant_clan", 500, 0, 0, "LAST_HIT", 0, 0, 0, "fighter"),
(21267, 21267, "Cave Ant Larva", 0, "", 0, "Monster.ant_larva", 12, 8, 36, "male", "L2Monster", 40, 1279, 463, 7.11, 1.84, 40, 43, 30, 21, 20, 10, 0, 0, 206, 175, 96, 142, 278, 0, 333, 0, 0, 0, 44, 66, "ant_clan", 500, 0, 0, "LAST_HIT", 0, 0, 0, "fighter"),
(21268, 21268, "Cave Ant Larva", 0, "", 0, "Monster.ant_larva", 12, 8, 36, "male", "L2Monster", 40, 1279, 463, 14.22, 1.84, 40, 43, 30, 21, 20, 10, 1475, 89, 187, 193, 96, 142, 278, 0, 333, 0, 0, 0, 44, 66, "ant_clan", 500, 0, 0, "LAST_HIT", 0, 0, 0, "fighter"),
(21269, 21269, "Cave Ant", 0, "", 0, "Monster.ant", 26, 15, 37, "male", "L2Monster", 40, 1338, 480, 7.11, 1.84, 40, 43, 30, 21, 20, 10, 3368, 207, 222, 154, 104, 147, 278, 500, 333, 0, 0, 0, 44, 143, "ant_clan", 300, 0, 0, "LAST_HIT", 0, 0, 0, "fighter"),
(21270, 21270, "Cave Ant Soldier", 0, "", 0, "Monster.ant_soldier", 35, 17, 38, "male", "L2Monster", 40, 1400, 497, 7.11, 1.84, 40, 43, 30, 21, 20, 10, 3891, 243, 238, 188, 112, 153, 278, 500, 333, 0, 0, 0, 88, 143, "ant_clan", 300, 0, 0, "LAST_HIT", 0, 0, 0, "fighter"),
(21271, 21271, "Cave Ant", 0, "", 0, "Monster.ant", 26, 15, 37, "male", "L2Monster", 40, 1338, 480, 7.11, 1.84, 40, 43, 30, 21, 20, 10, 2298, 141, 222, 154, 104, 147, 278, 500, 333, 0, 0, 0, 44, 143, "ant_clan", 300, 0, 0, "LAST_HIT", 0, 0, 0, "fighter"),
(21272, 21272, "Cave Ant Soldier", 0, "", 0, "Monster.ant_soldier", 35, 17, 38, "male", "L2Monster", 40, 1400, 497, 7.11, 1.84, 40, 43, 30, 21, 20, 10, 4085, 255, 238, 188, 112, 153, 278, 500, 333, 0, 0, 0, 88, 143, "ant_clan", 300, 0, 0, "LAST_HIT", 0, 0, 0, "fighter"),
(21273, 21273, "Cave Noble Ant", 0, "", 0, "Monster.noble_ant", 20, 48, 39, "male", "L2Monster", 40, 1462, 514, 14.22, 1.84, 40, 43, 30, 21, 20, 10, 5918, 376, 280, 177, 121, 158, 278, 500, 333, 0, 0, 0, 88, 191, "ant_clan", 300, 0, 0, "LAST_HIT", 0, 0, 0, "fighter"),
(21274, 21274, "Kookaburra", 0, "", 0, "Monster2.youth_ostrich", 8, 26.4, 67, "male", "L2Monster", 40, 3626, 1388, 5.93, 2.78, 40, 43, 30, 21, 20, 10, 8356, 796, 1169, 373, 681, 356, 278, 0, 333, 0, 0, 0, 25, 209, "animal_clan", 300, 0, 0, "LAST_HIT", 0, 0, 0, "fighter"),
(21275, 21275, "Kookaburra", 0, "", 0, "Monster2.youth_ostrich", 8, 26.4, 67, "male", "L2Monster", 40, 3626, 1388, 5.93, 2.78, 40, 43, 30, 21, 20, 10, 8356, 796, 1415, 308, 681, 356, 278, 0, 333, 0, 0, 0, 25, 209, "animal_clan", 300, 0, 0, "LAST_HIT", 0, 0, 0, "fighter"),
(21276, 21276, "Kookaburra", 0, "", 0, "Monster2.youth_ostrich", 8, 26.4, 67, "male", "L2Monster", 40, 3626, 1388, 5.93, 2.78, 40, 43, 30, 21, 20, 10, 8356, 796, 1063, 410, 681, 356, 278, 0, 333, 0, 0, 0, 25, 209, "animal_clan", 300, 0, 0, "LAST_HIT", 0, 0, 0, "fighter"),
(21277, 21277, "Kookaburra", 0, "", 0, "Monster2.youth_ostrich", 8, 26.4, 67, "male", "L2Monster", 40, 3626, 1388, 5.93, 2.78, 40, 43, 30, 21, 20, 10, 5875, 560, 1169, 373, 681, 356, 278, 0, 333, 0, 0, 0, 25, 209, "animal_clan", 300, 0, 0, "LAST_HIT", 0, 0, 0, "fighter"),
(21278, 21278, "Antelope", 0, "", 0, "Monster2.antelope", 17, 34, 68, "male", "L2Monster", 40, 3706, 1423, 5.93, 2.78, 40, 43, 30, 21, 20, 10, 8608, 832, 1217, 449, 713, 365, 278, 0, 333, 0, 0, 0, 49, 203, "animal_clan", 300, 0, 0, "LAST_HIT", 0, 0, 0, "fighter"),
(21279, 21279, "Antelope", 0, "", 0, "Monster2.antelope", 17, 34, 68, "male", "L2Monster", 40, 3706, 1423, 5.93, 2.78, 40, 43, 30, 21, 20, 10, 8608, 832, 1106, 494, 713, 365, 278, 0, 333, 0, 0, 0, 49, 181, "animal_clan", 300, 0, 0, "LAST_HIT", 0, 0, 0, "fighter"),
(21280, 21280, "Antelope", 0, "", 0, "Monster2.antelope", 17, 34, 68, "male", "L2Monster", 40, 3706, 1423, 5.93, 2.78, 40, 43, 30, 21, 20, 10, 8608, 832, 1473, 371, 713, 365, 278, 0, 333, 0, 0, 0, 49, 181, "animal_clan", 300, 0, 0, "LAST_HIT", 0, 0, 0, "fighter"),
(21281, 21281, "Antelope", 0, "", 0, "Monster2.antelope", 17, 34, 68, "male", "L2Monster", 40, 3706, 1423, 5.93, 2.78, 40, 43, 30, 21, 20, 10, 6052, 584, 1217, 449, 713, 365, 278, 0, 333, 0, 0, 0, 49, 181, "animal_clan", 300, 0, 0, "LAST_HIT", 0, 0, 0, "fighter"),
(21282, 21282, "Bandersnatch", 0, "", 0, "Monster2.bandersnatch", 18, 25, 69, "male", "L2Monster", 40, 3784, 1458, 5.93, 2.78, 40, 43, 30, 21, 20, 10, 9040, 884, 1757, 460, 746, 373, 200, 150, 333, 0, 0, 0, 33, 187, "animal_clan", 300, 0, 0, "LAST_HIT", 0, 0, 0, "fighter"),
(21283, 21283, "Bandersnatch", 0, "", 0, "Monster2.bandersnatch", 18, 25, 69, "male", "L2Monster", 40, 3784, 1458, 5.93, 2.78, 40, 43, 30, 21, 20, 10, 9040, 884, 2127, 380, 746, 373, 200, 150, 333, 0, 0, 0, 33, 187, "animal_clan", 300, 0, 0, "LAST_HIT", 0, 0, 0, "fighter"),
(21284, 21284, "Bandersnatch", 0, "", 0, "Monster2.bandersnatch", 18, 25, 69, "male", "L2Monster", 40, 3784, 1458, 5.93, 2.78, 40, 43, 30, 21, 20, 10, 9040, 884, 1598, 506, 746, 373, 197, 150, 333, 0, 0, 0, 30, 170, "animal_clan", 300, 0, 0, "LAST_HIT", 0, 0, 0, "fighter"),
(21285, 21285, "Bandersnatch", 0, "", 0, "Monster2.bandersnatch", 18, 25, 69, "male", "L2Monster", 40, 3784, 1458, 5.93, 2.78, 40, 43, 30, 21, 20, 10, 6356, 622, 1757, 460, 746, 373, 200, 150, 333, 0, 0, 0, 33, 187, "animal_clan", 300, 0, 0, "LAST_HIT", 0, 0, 0, "fighter"),
(21286, 21286, "Buffalo", 0, "", 0, "Monster2.buffalo", 22, 31, 70, "male", "L2Monster", 40, 3862, 1493, 5.93, 2.78, 40, 43, 30, 21, 20, 10, 9121, 904, 1825, 470, 780, 382, 200, 0, 333, 0, 0, 0, 22, 187, "animal_clan", 300, 0, 0, "LAST_HIT", 0, 0, 0, "fighter"),
(21287, 21287, "Buffalo", 0, "", 0, "Monster2.buffalo", 22, 31, 70, "male", "L2Monster", 40, 3862, 1493, 5.93, 2.78, 40, 43, 30, 21, 20, 10, 9121, 904, 1659, 517, 780, 382, 200, 0, 333, 0, 0, 0, 22, 187, "animal_clan", 300, 0, 0, "LAST_HIT", 0, 0, 0, "fighter"),
(21288, 21288, "Buffalo", 0, "", 0, "Monster2.buffalo", 22, 31, 70, "male", "L2Monster", 40, 3862, 1493, 5.93, 2.78, 40, 43, 30, 21, 20, 10, 9121, 904, 2209, 388, 780, 382, 200, 0, 333, 0, 0, 0, 22, 187, "animal_clan", 300, 0, 0, "LAST_HIT", 0, 0, 0, "fighter"),
(21289, 21289, "Buffalo", 0, "", 0, "Monster2.buffalo", 22, 31, 70, "male", "L2Monster", 40, 3862, 1493, 5.93, 2.78, 40, 43, 30, 21, 20, 10, 6413, 636, 1825, 470, 780, 382, 200, 0, 333, 0, 0, 0, 22, 187, "animal_clan", 300, 0, 0, "LAST_HIT", 0, 0, 0, "fighter"),
(21290, 21290, "Grendel", 0, "", 0, "Monster2.bionic_bear", 15, 39, 71, "male", "L2Monster", 40, 3938, 1529, 6.72, 3.09, 40, 43, 30, 21, 20, 10, 9572, 960, 1894, 481, 814, 390, 200, 150, 333, 0, 0, 0, 39, 176, "animal_clan", 300, 0, 0, "LAST_HIT", 0, 0, 0, "fighter"),
(21291, 21291, "Grendel", 0, "", 0, "Monster2.bionic_bear", 15, 39, 71, "male", "L2Monster", 40, 3938, 1529, 6.72, 3.09, 40, 43, 30, 21, 20, 10, 9572, 960, 1721, 529, 814, 390, 200, 150, 333, 0, 0, 0, 39, 176, "animal_clan", 300, 0, 0, "LAST_HIT", 0, 0, 0, "fighter"),
(21292, 21292, "Grendel", 0, "", 0, "Monster2.bionic_bear", 15, 39, 71, "male", "L2Monster", 40, 3938, 1529, 6.72, 3.09, 40, 43, 30, 21, 20, 10, 9572, 960, 2291, 397, 814, 390, 200, 150, 333, 0, 0, 0, 39, 176, "animal_clan", 300, 0, 0, "LAST_HIT", 0, 0, 0, "fighter"),
(21293, 21293, "Grendel", 0, "", 0, "Monster2.bionic_bear", 15, 39, 71, "male", "L2Monster", 40, 3938, 1529, 6.72, 3.09, 40, 43, 30, 21, 20, 10, 6730, 676, 1894, 481, 814, 390, 200, 150, 333, 0, 0, 0, 39, 176, "animal_clan", 300, 0, 0, "LAST_HIT", 0, 0, 0, "fighter"),
(21294, 21294, "Canyon Antelope ", 0, "", 0, "Monster2.antelope", 17, 34, 68, "male", "L2Monster", 40, 3706, 1423, 23.7, 2.78, 40, 43, 30, 21, 20, 10, 6893, 666, 1217, 449, 713, 365, 278, 0, 333, 0, 0, 0, 45, 185, "NULL", 0, 0, 0, "LAST_HIT", 0, 0, 0, "fighter"),
(21295, 21295, "Canyon Antelope Slave", 0, "", 0, "Monster2.antelope", 17, 34, 69, "male", "L2Monster", 40, 3784, 1458, 23.7, 2.78, 40, 43, 30, 21, 20, 10, 7311, 715, 1265, 460, 746, 373, 361, 150, 333, 0, 0, 0, 45, 165, "eye_clan", 400, 0, 0, "LAST_HIT", 0, 0, 0, "fighter"),
(21296, 21296, "Canyon Bandersnatch ", 0, "", 0, "Monster2.bandersnatch", 18, 25, 70, "male", "L2Monster", 40, 3862, 1493, 35.55, 2.78, 40, 43, 30, 21, 20, 10, 7244, 718, 2429, 353, 780, 382, 200, 150, 333, 0, 0, 0, 33, 198, "NULL", 0, 0, 0, "LAST_HIT", 0, 0, 0, "fighter"),
(21297, 21297, "Canyon Bandersnatch Slave", 0, "", 0, "Monster2.bandersnatch", 18, 25, 71, "male", "L2Monster", 40, 3938, 1529, 40.29, 3.09, 40, 43, 30, 21, 20, 10, 7275, 730, 1721, 529, 814, 390, 200, 150, 333, 0, 0, 0, 33, 187, "eye_clan", 400, 0, 0, "LAST_HIT", 0, 0, 0, "fighter"),
(21298, 21298, "Eye of Restrainer ", 0, "", 0, "Monster.monster_eye", 21, 43, 71, "male", "L2Monster", 40, 3938, 1529, 26.86, 3.09, 40, 43, 30, 21, 20, 10, 7023, 705, 1239, 449, 814, 390, 278, 150, 333, 0, 0, 0, 99, 154, "eye_clan", 400, 0, 0, "LAST_HIT", 0, 0, 0, "balanced"),
(21299, 21299, "Buffalo Slave", 0, "", 0, "Monster2.buffalo_ec", 22, 31, 72, "male", "L2Monster", 40, 4013, 1565, 40.29, 3.09, 40, 43, 30, 21, 20, 10, 7481, 760, 2159, 446, 849, 399, 200, 150, 333, 0, 0, 0, 22, 176, "eye_clan", 400, 0, 0, "LAST_HIT", 0, 0, 0, "fighter"),
(21300, 21300, "Eye of Guide", 0, "", 0, "Monster2.parasitic_eye_20_sm", 20, 50.5, 72, "male", "L2Monster", 40, 4013, 1565, 40.29, 3.09, 40, 43, 30, 21, 20, 10, 7360, 747, 1168, 505, 849, 399, 278, 0, 333, 0, 0, 0, 33, 170, "eye_clan", 400, 0, 0, "LAST_HIT", 0, 0, 0, "balanced"),
(21301, 21301, "Gaze of Nightmare", 0, "", 0, "Monster.field_stalker", 15, 30, 72, "male", "L2Monster", 40, 4013, 1565, 53.72, 3.09, 40, 43, 30, 21, 20, 10, 6624, 673, 1061, 654, 849, 399, 278, 0, 333, 0, 0, 0, 77, 214, "eye_clan", 400, 0, 0, "LAST_HIT", 0, 0, 0, "balanced"),
(21302, 21302, "Eye of Watchman", 0, "", 0, "Monster2.parasitic_eye", 25, 63, 73, "male", "L2Monster", 40, 4086, 1601, 40.29, 3.09, 40, 43, 30, 21, 20, 10, 7105, 731, 1770, 352, 885, 407, 278, 150, 333, 0, 0, 0, 33, 176, "eye_clan", 400, 0, 0, "LAST_HIT", 0, 0, 0, "fighter"),
(21303, 21303, "Homunculus", 0, "", 0, "Monster2.homunculus_20_sm", 10, 26, 73, "male", "L2Monster", 40, 4086, 1601, 40.29, 3.09, 40, 43, 30, 21, 20, 10, 7185, 739, 1947, 320, 885, 407, 278, 150, 333, 0, 0, 0, 33, 203, "eye_clan", 400, 0, 0, "LAST_HIT", 0, 0, 0, "fighter"),
(21304, 21304, "Grendel Slave", 0, "", 0, "Monster2.bionic_bear", 15, 39, 74, "male", "L2Monster", 40, 4158, 1637, 53.72, 3.09, 40, 43, 30, 21, 20, 10, 7918, 825, 2312, 466, 921, 416, 200, 150, 333, 0, 0, 0, 39, 154, "eye_clan", 400, 0, 0, "LAST_HIT", 0, 0, 0, "fighter"),
(21305, 21305, "Eye of Pilgrim", 0, "", 0, "Monster2.parasitic_eye_20_sm", 20, 50.5, 74, "male", "L2Monster", 40, 4158, 1637, 40.29, 3.09, 40, 43, 30, 21, 20, 10, 7775, 810, 1375, 479, 921, 416, 278, 0, 333, 0, 0, 0, 33, 181, "eye_clan", 400, 0, 0, "LAST_HIT", 0, 0, 0, "balanced"),
(21306, 21306, "Disciples of Protection", 0, "", 0, "Monster2.apostle_warrior", 8, 30, 74, "female", "L2Monster", 40, 4158, 1637, 67.15, 3.09, 40, 43, 30, 21, 20, 10, 8441, 880, 1579, 682, 921, 416, 200, 150, 333, 6717, 0, 0, 55, 176, "divine_clan", 600, 0, 0, "LAST_HIT", 200, 0, 30, "fighter"),
(21307, 21307, "Elder Homunculus", 0, "", 0, "Monster2.homunculus", 12, 32.5, 75, "male", "L2Monster", 40, 4229, 1673, 53.72, 3.09, 40, 43, 30, 21, 20, 10, 7394, 780, 1892, 367, 957, 425, 278, 150, 333, 0, 0, 0, 33, 220, "eye_clan", 400, 0, 0, "LAST_HIT", 0, 0, 0, "fighter"),
(21308, 21308, "Disciples of Punishment", 0, "", 0, "Monster2.apostle_warrior", 8, 30, 75, "female", "L2Monster", 40, 4229, 1673, 67.15, 3.09, 40, 43, 30, 21, 20, 10, 7860, 829, 2389, 475, 957, 425, 200, 150, 333, 6717, 0, 0, 55, 209, "divine_clan", 600, 0, 0, "LAST_HIT", 200, 0, 30, "fighter"),
(21309, 21309, "Disciples of Punishment", 0, "", 0, "Monster2.apostle_warrior", 8, 30, 75, "female", "L2Monster", 40, 4229, 1673, 67.15, 3.09, 40, 43, 30, 21, 20, 10, 8192, 864, 1795, 633, 957, 425, 200, 150, 333, 6717, 0, 0, 55, 209, "divine_clan", 600, 0, 0, "LAST_HIT", 100, 0, 30, "fighter"),
(21310, 21310, "Disciples of Authority", 0, "", 0, "Monster2.apostle_mage", 11, 38.5, 76, "male", "L2Monster", 40, 4297, 1710, 67.15, 3.09, 40, 43, 30, 21, 20, 10, 8071, 863, 1775, 412, 994, 433, 278, 150, 333, 6718, 0, 0, 55, 170, "divine_clan", 600, 0, 0, "LAST_HIT", 0, 100, 30, "mage"),
(21311, 21311, "Disciples of Authority", 0, "", 0, "Monster2.apostle_mage", 11, 38.5, 76, "male", "L2Monster", 40, 4297, 1710, 67.15, 3.09, 40, 43, 30, 21, 20, 10, 7441, 795, 1334, 549, 994, 433, 278, 150, 333, 6718, 0, 0, 55, 170, "divine_clan", 600, 0, 0, "LAST_HIT", 0, 100, 30, "mage"),
(21312, 21312, "Eye of Ruler", 0, "", 0, "Monster2.parasitic_eye", 25, 63, 74, "male", "L2Monster", 40, 4158, 1637, 40.29, 3.09, 40, 43, 30, 21, 20, 10, 10752, 1121, 1375, 479, 921, 416, 278, 150, 333, 0, 0, 0, 33, 176, "eye_clan", 400, 0, 0, "LAST_HIT", 0, 0, 0, "balanced"),
(21313, 21313, "Sly Hound Dog", 0, "", 0, "Monster2.bandersnatch", 18, 25, 72, "male", "L2Monster", 40, 4013, 1565, 40.29, 3.09, 40, 43, 30, 21, 20, 10, 10294, 1046, 2375, 406, 849, 399, 200, 0, 333, 0, 0, 0, 33, 203, "NULL", 0, 0, 0, "LAST_HIT", 0, 0, 0, "fighter"),
(21314, 21314, "Hot Springs Bandersnatchling", 0, "", 0, "Monster2.bandersnatch", 18, 25, 73, "male", "L2Monster", 40, 4086, 1601, 26.86, 3.09, 40, 43, 30, 21, 20, 10, 8609, 886, 2032, 502, 885, 407, 197, 150, 333, 0, 0, 0, 30, 170, "NULL", 0, 0, 0, "LAST_HIT", 0, 0, 0, "fighter"),
(21315, 21315, "Hot Springs Buffalo", 0, "", 0, "Monster2.buffalo", 22, 31, 73, "male", "L2Monster", 40, 4086, 1601, 26.86, 3.09, 40, 43, 30, 21, 20, 10, 8971, 923, 2032, 502, 885, 407, 200, 0, 333, 0, 0, 0, 22, 187, "NULL", 0, 0, 0, "LAST_HIT", 0, 0, 0, "fighter"),
(21316, 21316, "Hot Springs Flava", 0, "", 0, "Monster2.flava", 18, 34, 74, "male", "L2Monster", 40, 4158, 1637, 26.86, 3.09, 40, 43, 30, 21, 20, 10, 10556, 1100, 1513, 512, 921, 416, 278, 150, 333, 0, 0, 0, 30, 165, "NULL", 0, 0, 0, "LAST_HIT", 0, 0, 0, "fighter"),
(21317, 21317, "Hot Springs Atroxspawn", 0, "", 0, "Monster2.kailiharim", 45, 39, 74, "male", "L2Monster", 40, 4158, 1637, 26.86, 3.09, 40, 43, 30, 21, 20, 10, 8846, 922, 2102, 512, 921, 416, 197, 150, 333, 0, 0, 0, 105, 175, "NULL", 0, 0, 0, "LAST_HIT", 0, 0, 0, "fighter"),
(21318, 21318, "Hot Springs Antelope", 0, "", 0, "Monster2.antelope", 17, 34, 74, "male", "L2Monster", 40, 4158, 1637, 26.86, 3.09, 40, 43, 30, 21, 20, 10, 9247, 964, 1513, 512, 921, 416, 278, 0, 333, 0, 0, 0, 49, 203, "NULL", 0, 0, 0, "LAST_HIT", 0, 0, 0, "fighter"),
(21319, 21319, "Hot Springs Nepenthes", 0, "", 0, "Monster2.nephenthes", 28, 43.5, 75, "male", "L2Monster", 40, 4229, 1673, 26.86, 3.09, 40, 43, 30, 21, 20, 10, 11636, 1227, 2172, 523, 957, 425, 197, 150, 333, 0, 0, 0, 48, 170, "NULL", 0, 0, 0, "LAST_HIT", 0, 0, 0, "fighter"),
(21320, 21320, "Hot Springs Yeti", 0, "", 0, "Monster.yeti_20_bi", 18, 32, 75, "male", "L2Monster", 40, 4229, 1673, 26.86, 3.09, 40, 43, 30, 21, 20, 10, 9470, 999, 1563, 523, 957, 425, 278, 0, 333, 0, 0, 0, 17, 187, "NULL", 0, 0, 0, "LAST_HIT", 0, 0, 0, "fighter"),
(21321, 21321, "Hot Springs Atrox", 0, "", 0, "Monster2.kailiharim", 45, 39, 76, "male", "L2Monster", 40, 4297, 1710, 26.86, 3.09, 40, 43, 30, 21, 20, 10, 11135, 1190, 2242, 534, 994, 433, 200, 150, 333, 0, 0, 0, 115, 192, "NULL", 0, 0, 0, "LAST_HIT", 0, 0, 0, "fighter"),
(21322, 21322, "Hot Springs Bandersnatch", 0, "", 0, "Monster2.bandersnatch", 18, 25, 76, "male", "L2Monster", 40, 4297, 1710, 26.86, 3.09, 40, 43, 30, 21, 20, 10, 11135, 1190, 2242, 534, 994, 433, 197, 150, 333, 0, 0, 0, 30, 170, "NULL", 0, 0, 0, "LAST_HIT", 0, 0, 0, "fighter"),
(21323, 21323, "Hot Springs Grendel", 0, "", 0, "Monster2.bionic_bear", 15, 39, 76, "male", "L2Monster", 40, 4297, 1710, 26.86, 3.09, 40, 43, 30, 21, 20, 10, 9753, 1042, 2242, 534, 994, 433, 256, 0, 333, 0, 0, 0, 36, 165, "NULL", 0, 0, 0, "LAST_HIT", 0, 0, 0, "fighter"),
(21324, 21324, "Ketra Orc Footman", 0, "", 0, "Monster.ketra_orc", 12, 29, 77, "male", "L2Monster", 40, 4364, 1747, 26.86, 3.09, 40, 43, 30, 21, 20, 10, 9323, 1009, 1664, 544, 1031, 442, 278, 150, 333, 79, 0, 0, 49, 192, "ketra", 300, 0, 0, "LAST_HIT", 100, 0, 30, "fighter"),
(21325, 21325, "Ketra's War Hound", 0, "", 0, "Monster2.bandersnatch", 18, 25, 77, "male", "L2Monster", 40, 4364, 1747, 26.86, 3.09, 40, 43, 30, 21, 20, 10, 9015, 975, 2543, 495, 1031, 442, 200, 150, 333, 0, 0, 0, 33, 203, "ketra", 300, 0, 0, "LAST_HIT", 0, 0, 0, "fighter"),
(21326, 21326, "Grazing Kookaburra", 0, "", 0, "Monster2.youth_ostrich", 8, 26.4, 77, "male", "L2Monster", 40, 4364, 1747, 26.86, 3.09, 40, 43, 30, 21, 20, 10, 9015, 975, 1375, 560, 1031, 442, 278, 150, 333, 0, 0, 0, 25, 209, "ketra", 0, 0, 0, "LAST_HIT", 0, 0, 0, "balanced"),
(21327, 21327, "Ketra Orc Raider", 0, "", 0, "Monster.ketra_orc_warrior", 12, 24, 78, "male", "L2Monster", 40, 4428, 1784, 26.86, 3.09, 40, 43, 30, 21, 20, 10, 10240, 1120, 2075, 459, 1069, 451, 278, 150, 333, 79, 6919, 0, 39, 192, "ketra", 300, 0, 0, "LAST_HIT", 100, 0, 30, "fighter"),
(21328, 21328, "Ketra Orc Scout", 0, "", 0, "Monster.ketra_orc_archer", 12, 27, 78, "male", "L2Monster", 500, 4428, 1784, 26.86, 3.09, 40, 43, 30, 21, 20, 10, 9816, 1074, 3464, 611, 1069, 451, 249, 150, 333, 288, 0, 0, 49, 192, "ketra", 300, 0, 0, "LAST_HIT", 100, 0, 30, "archer"),
(21329, 21329, "Ketra Orc Shaman", 0, "", 0, "Monster.ketra_orc_shaman", 10, 23, 78, "male", "L2Monster", 40, 4490, 1821, 26.86, 3.09, 40, 43, 30, 21, 20, 10, 9955, 1103, 1765, 481, 1107, 459, 278, 150, 333, 92, 0, 0, 11, 165, "ketra", 300, 0, 0, "LAST_HIT", 0, 100, 30, "balanced"),
(21330, 21330, "Grazing Buffalo", 0, "", 0, "Monster2.buffalo", 22, 31, 78, "male", "L2Monster", 40, 4490, 1821, 26.86, 3.09, 40, 43, 30, 21, 20, 10, 9489, 1051, 2026, 685, 1107, 459, 200, 150, 333, 0, 0, 0, 22, 181, "ketra", 0, 0, 0, "LAST_HIT", 0, 0, 0, "fighter"),
(21331, 21331, "Ketra Orc Warrior", 0, "", 0, "Monster.ketra_orc_warrior", 12, 24, 78, "male", "L2Monster", 40, 4550, 1859, 26.86, 3.09, 40, 43, 30, 21, 20, 10, 9304, 1044, 1996, 524, 1144, 468, 278, 150, 333, 79, 6919, 0, 39, 192, "ketra", 300, 0, 0, "LAST_HIT", 100, 0, 30, "fighter"),
(21332, 21332, "Ketra Orc Lieutenant", 0, "", 0, "Monster2.ketra_orc_chieftain", 11, 38.5, 78, "male", "L2Monster", 40, 4550, 1859, 26.86, 3.09, 40, 43, 30, 21, 20, 10, 10420, 1169, 2291, 634, 1144, 468, 200, 150, 333, 6719, 0, 0, 26, 192, "ketra", 300, 0, 0, "LAST_HIT", 100, 0, 50, "fighter"),
(21333, 21333, "Grazing Windsus", 0, "", 0, "Monster.giant_wild_hog", 35, 27, 78, "male", "L2Monster", 40, 4608, 1896, 26.86, 3.09, 40, 43, 30, 21, 20, 10, 9976, 1133, 1540, 710, 1182, 477, 278, 150, 333, 0, 0, 0, 38, 187, "ketra", 0, 0, 0, "LAST_HIT", 0, 0, 0, "balanced"),
(21334, 21334, "Ketra Orc Medium", 0, "", 0, "Monster.ketra_orc_shaman", 10, 23, 78, "male", "L2Monster", 40, 4608, 1896, 26.86, 3.09, 40, 43, 30, 21, 20, 10, 14933, 1695, 1863, 499, 1182, 477, 278, 150, 333, 92, 0, 0, 11, 165, "ketra", 300, 0, 0, "LAST_HIT", 0, 100, 30, "balanced"),
(21335, 21335, "Ketra Orc Elite Soldier", 0, "", 0, "Monster.ketra_orc", 12, 29, 78, "male", "L2Monster", 40, 4663, 1934, 26.86, 3.09, 40, 43, 30, 21, 20, 10, 9625, 1106, 1912, 598, 1220, 485, 278, 150, 333, 79, 0, 0, 49, 192, "ketra", 300, 0, 0, "LAST_HIT", 100, 0, 30, "fighter"),
(21336, 21336, "Ketra Orc White Captain", 0, "", 0, "Monster.ketra_orc_overload_20_bi", 14, 28.8, 78, "male", "L2Monster", 40, 4663, 1934, 26.86, 3.09, 40, 43, 30, 21, 20, 10, 11317, 1300, 1738, 657, 1220, 485, 278, 150, 333, 80, 0, 0, 36, 192, "ketra", 300, 0, 0, "LAST_HIT", 100, 0, 50, "balanced"),
(21337, 21337, "Grazing Elder Buffalo", 0, "", 0, "Monster2.buffalo", 22, 31, 78, "male", "L2Monster", 40, 4716, 1972, 26.86, 3.09, 40, 43, 30, 21, 20, 10, 10475, 1217, 2249, 736, 1258, 494, 200, 150, 333, 0, 0, 0, 22, 181, "ketra", 0, 0, 0, "LAST_HIT", 0, 0, 0, "fighter"),
(21338, 21338, "Ketra Orc Seer", 0, "", 0, "Monster.ketra_orc_shaman", 10, 23, 78, "male", "L2Monster", 40, 4716, 1972, 26.86, 3.09, 40, 43, 30, 21, 20, 10, 13783, 1602, 2155, 470, 1258, 494, 278, 150, 333, 213, 0, 0, 11, 176, "ketra", 300, 0, 0, "LAST_HIT", 0, 100, 30, "balanced"),
(21339, 21339, "Ketra Orc General", 0, "", 0, "Monster2.ketra_orc_chieftain_20_bi", 17, 46.2, 78, "male", "L2Monster", 40, 4766, 2011, 26.86, 3.09, 40, 43, 30, 21, 20, 10, 10494, 1234, 3372, 511, 1296, 502, 200, 150, 333, 6719, 0, 0, 26, 192, "ketra", 300, 0, 0, "LAST_HIT", 100, 0, 50, "fighter"),
(21340, 21340, "Ketra Orc Battalion Commander", 0, "", 0, "Monster2.ketra_orc_warlord", 12, 30, 78, "male", "L2Monster", 40, 4766, 2011, 26.86, 3.09, 40, 43, 30, 21, 20, 10, 10494, 1234, 2006, 619, 1296, 502, 278, 150, 333, 80, 6919, 0, 29, 192, "ketra", 300, 0, 0, "LAST_HIT", 100, 0, 60, "fighter"),
(21341, 21341, "Grazing Elder Kookaburra", 0, "", 0, "Monster2.youth_ostrich", 8, 26.4, 78, "male", "L2Monster", 40, 4813, 2049, 26.86, 3.09, 40, 43, 30, 21, 20, 10, 10986, 1307, 1696, 647, 1333, 511, 278, 150, 333, 0, 0, 0, 25, 209, "ketra", 0, 0, 0, "LAST_HIT", 0, 0, 0, "balanced"),
(21342, 21342, "Ketra Orc Grand Seer", 0, "", 0, "Monster.ketra_orc_shaman", 10, 23, 78, "male", "L2Monster", 40, 4813, 2049, 26.86, 3.09, 40, 43, 30, 21, 20, 10, 14456, 1720, 2052, 629, 1333, 511, 278, 150, 333, 213, 0, 0, 11, 176, "ketra", 300, 0, 0, "LAST_HIT", 0, 100, 50, "balanced"),
(21343, 21343, "Ketra Commander", 0, "", 0, "Monster2.ketra_orc_warlord_20_bi", 15, 36, 78, "male", "L2Monster", 40, 4608, 1896, 26.86, 3.09, 40, 43, 30, 21, 20, 10, 16400, 1862, 1630, 587, 1182, 477, 317, 150, 333, 80, 6919, 0, 29, 192, "ketra", 300, 0, 0, "LAST_HIT", 100, 0, 50, "balanced"),
(21344, 21344, "Ketra Elite Guard", 0, "", 0, "Monster.ketra_orc_overload", 12, 24, 78, "male", "L2Minion", 40, 4550, 1859, 26.86, 3.09, 40, 43, 30, 21, 20, 10, 11138, 1250, 2195, 476, 1144, 468, 278, 0, 333, 80, 0, 0, 36, 198, "ketra", 300, 0, 0, "LAST_HIT", 100, 0, 30, "fighter"),
(21345, 21345, "Ketra's Head Shaman", 0, "", 0, "Monster.ketra_orc_shaman", 10, 23, 78, "male", "L2Monster", 40, 4813, 2049, 26.86, 3.09, 40, 43, 30, 21, 20, 10, 12360, 1471, 2257, 572, 1333, 511, 278, 150, 333, 210, 0, 0, 11, 192, "ketra", 300, 0, 0, "LAST_HIT", 0, 100, 30, "balanced"),
(21346, 21346, "Ketra's Head Guard", 0, "", 0, "Monster2.ketra_orc_chieftain", 11, 38.5, 78, "male", "L2Minion", 40, 4766, 2011, 26.86, 3.09, 40, 43, 30, 21, 20, 10, 12279, 1444, 2303, 749, 1296, 502, 200, 0, 333, 6719, 0, 0, 26, 192, "ketra", 300, 0, 0, "LAST_HIT", 100, 0, 30, "fighter"),
(21347, 21347, "Ketra Prophet", 0, "", 0, "Monster.ketra_orc_shaman", 10, 23, 78, "male", "L2Monster", 40, 4899, 2127, 26.86, 3.09, 40, 43, 30, 21, 20, 10, 18779, 2289, 2141, 650, 1406, 528, 278, 150, 333, 213, 0, 0, 11, 192, "ketra", 300, 0, 0, "LAST_HIT", 0, 100, 50, "balanced"),
(21348, 21348, "Prophet's Guard", 0, "", 0, "Monster2.ketra_orc_chieftain", 11, 38.5, 78, "male", "L2Minion", 40, 4858, 2088, 26.86, 3.09, 40, 43, 30, 21, 20, 10, 12871, 1550, 2913, 639, 1370, 519, 200, 0, 333, 6719, 0, 0, 26, 198, "ketra", 300, 0, 0, "LAST_HIT", 100, 0, 30, "fighter"),
(21349, 21349, "Prophet's Aide", 0, "", 0, "Monster.ketra_orc_shaman", 10, 23, 78, "male", "L2Minion", 40, 4858, 2088, 26.86, 3.09, 40, 43, 30, 21, 20, 10, 13071, 1574, 2097, 639, 1370, 519, 278, 0, 333, 210, 0, 0, 11, 198, "ketra", 300, 0, 0, "LAST_HIT", 0, 100, 30, "balanced"),
(21350, 21350, "Varka Silenos Recruit", 0, "", 0, "Monster2.barka_silenos_hunter", 16, 38, 77, "male", "L2Monster", 40, 4364, 1747, 26.86, 3.09, 40, 43, 30, 21, 20, 10, 9851, 1066, 1664, 544, 1031, 442, 361, 150, 333, 2504, 0, 0, 44, 175, "varka", 300, 0, 0, "LAST_HIT", 100, 0, 30, "fighter"),
(21351, 21351, "Varka Silenos Footman", 0, "", 0, "Monster2.barka_silenos_warrior", 16, 41, 77, "male", "L2Monster", 40, 4364, 1747, 26.86, 3.09, 40, 43, 30, 21, 20, 10, 8487, 918, 1831, 495, 1031, 442, 278, 150, 333, 2504, 0, 0, 34, 185, "varka", 300, 0, 0, "LAST_HIT", 100, 0, 30, "fighter"),
(21352, 21352, "Grazing Antelope", 0, "", 0, "Monster2.antelope", 17, 34, 77, "male", "L2Monster", 40, 4364, 1747, 26.86, 3.09, 40, 43, 30, 21, 20, 10, 9015, 975, 1375, 560, 1031, 442, 278, 150, 333, 0, 0, 0, 45, 185, "varka", 0, 0, 0, "LAST_HIT", 0, 0, 0, "balanced"),
(21353, 21353, "Varka Silenos Scout", 0, "", 0, "Monster2.barka_silenos_hunter", 16, 38, 78, "male", "L2Monster", 40, 4428, 1784, 26.86, 3.09, 40, 43, 30, 21, 20, 10, 9906, 1084, 2075, 459, 1069, 451, 278, 150, 333, 142, 6918, 0, 48, 192, "varka", 300, 0, 0, "LAST_HIT", 100, 0, 30, "fighter"),
(21354, 21354, "Varka Silenos Hunter", 0, "", 0, "Monster2.barka_silenos_archer", 8, 37.5, 78, "male", "L2Monster", 500, 4428, 1784, 26.86, 3.09, 40, 43, 30, 21, 20, 10, 9816, 1074, 3464, 611, 1069, 451, 247, 150, 333, 6917, 0, 0, 30, 175, "varka", 300, 0, 0, "LAST_HIT", 100, 0, 30, "archer"),
(21355, 21355, "Varka Silenos Shaman", 0, "", 0, "Monster2.barka_silenos_shaman", 14, 39.5, 78, "male", "L2Monster", 40, 4490, 1821, 26.86, 3.09, 40, 43, 30, 21, 20, 10, 9492, 1052, 2451, 481, 1107, 459, 200, 150, 333, 6716, 0, 0, 39, 165, "varka", 300, 0, 0, "LAST_HIT", 0, 100, 30, "balanced"),
(21356, 21356, "Grazing Nepenthes", 0, "", 0, "Monster2.nephenthes", 28, 43.5, 78, "male", "L2Monster", 40, 4490, 1821, 26.86, 3.09, 40, 43, 30, 21, 20, 10, 9489, 1051, 2026, 685, 1107, 459, 200, 150, 333, 0, 0, 0, 52, 187, "varka", 0, 0, 0, "LAST_HIT", 0, 0, 0, "fighter"),
(21357, 21357, "Varka Silenos Priest", 0, "", 0, "Monster2.barka_silenos_priest", 9, 41.5, 78, "male", "L2Monster", 40, 4550, 1859, 26.86, 3.09, 40, 43, 30, 21, 20, 10, 10277, 1153, 1996, 524, 1144, 468, 278, 150, 333, 6716, 0, 0, 39, 192, "varka", 300, 0, 0, "LAST_HIT", 0, 100, 30, "balanced"),
(21358, 21358, "Varka Silenos Warrior", 0, "", 0, "Monster2.barka_silenos_warrior", 16, 41, 78, "male", "L2Monster", 40, 4550, 1859, 26.86, 3.09, 40, 43, 30, 21, 20, 10, 10771, 1209, 1649, 634, 1144, 468, 278, 150, 333, 142, 6918, 0, 37, 192, "varka", 300, 0, 0, "LAST_HIT", 100, 0, 50, "balanced"),
(21359, 21359, "Grazing Bandersnatch", 0, "", 0, "Monster2.bandersnatch", 18, 25, 78, "male", "L2Monster", 40, 4608, 1896, 26.86, 3.09, 40, 43, 30, 21, 20, 10, 9976, 1133, 2139, 710, 1182, 477, 200, 150, 333, 0, 0, 0, 33, 192, "varka", 0, 0, 0, "LAST_HIT", 0, 0, 0, "fighter"),
(21360, 21360, "Varka Silenos Medium", 0, "", 0, "Monster2.barka_silenos_shaman", 14, 39.5, 78, "male", "L2Monster", 40, 4608, 1896, 26.86, 3.09, 40, 43, 30, 21, 20, 10, 15892, 1804, 2588, 499, 1182, 477, 200, 150, 333, 6716, 0, 0, 39, 165, "varka", 300, 0, 0, "LAST_HIT", 0, 100, 30, "balanced"),
(21361, 21361, "Varka Silenos Magus", 0, "", 0, "Monster2.barka_silenos_mage_20_bi", 11, 55.2, 78, "male", "L2Monster", 40, 4663, 1934, 26.86, 3.09, 40, 43, 30, 21, 20, 10, 9625, 1106, 1912, 598, 1220, 485, 278, 150, 333, 6716, 0, 0, 39, 192, "varka", 300, 0, 0, "LAST_HIT", 0, 100, 30, "mage"),
(21362, 21362, "Varka Silenos Officer", 0, "", 0, "Monster2.barka_silenos_chieftain", 18, 42.5, 78, "male", "L2Monster", 40, 4663, 1934, 26.86, 3.09, 40, 43, 30, 21, 20, 10, 11317, 1300, 2414, 657, 1220, 485, 200, 150, 333, 2504, 0, 0, 27, 192, "varka", 300, 0, 0, "LAST_HIT", 100, 0, 50, "fighter"),
(21363, 21363, "Grazing Flava", 0, "", 0, "Monster2.flava", 18, 34, 78, "male", "L2Monster", 40, 4716, 1972, 26.86, 3.09, 40, 43, 30, 21, 20, 10, 10475, 1217, 1619, 736, 1258, 494, 278, 150, 333, 0, 0, 0, 33, 181, "varka", 0, 0, 0, "LAST_HIT", 0, 0, 0, "balanced"),
(21364, 21364, "Varka Silenos Seer", 0, "", 0, "Monster2.barka_silenos_shaman", 14, 39.5, 78, "male", "L2Monster", 40, 4716, 1972, 26.86, 3.09, 40, 43, 30, 21, 20, 10, 13272, 1543, 2994, 470, 1258, 494, 200, 150, 333, 6716, 0, 0, 39, 176, "varka", 300, 0, 0, "LAST_HIT", 0, 100, 30, "balanced"),
(21365, 21365, "Varka Silenos Great Magus", 0, "", 0, "Monster2.barka_silenos_warrior_20_bi", 20, 49.2, 78, "male", "L2Monster", 40, 4766, 2011, 26.86, 3.09, 40, 43, 30, 21, 20, 10, 11525, 1355, 2428, 511, 1296, 502, 278, 150, 333, 2500, 0, 0, 37, 192, "varka", 300, 0, 0, "LAST_HIT", 0, 100, 50, "balanced"),
(21366, 21366, "Varka Silenos General", 0, "", 0, "Monster2.barka_silenos_chieftain", 18, 42.5, 78, "male", "L2Monster", 40, 4766, 2011, 26.86, 3.09, 40, 43, 30, 21, 20, 10, 12718, 1496, 2787, 619, 1296, 502, 200, 150, 333, 2500, 0, 0, 27, 192, "varka", 300, 0, 0, "LAST_HIT", 100, 0, 60, "fighter"),
(21367, 21367, "Grazing Elder Antelope", 0, "", 0, "Monster2.antelope", 17, 34, 78, "male", "L2Monster", 40, 4813, 2049, 26.86, 3.09, 40, 43, 30, 21, 20, 10, 10986, 1307, 1696, 647, 1333, 511, 278, 150, 333, 0, 0, 0, 49, 203, "varka", 0, 0, 0, "LAST_HIT", 0, 0, 0, "balanced"),
(21368, 21368, "Varka Silenos Great Seer", 0, "", 0, "Monster2.barka_silenos_shaman", 14, 39.5, 78, "male", "L2Monster", 40, 4813, 2049, 26.86, 3.09, 40, 43, 30, 21, 20, 10, 16964, 2019, 2851, 629, 1333, 511, 200, 150, 333, 6716, 0, 0, 39, 176, "varka", 300, 0, 0, "LAST_HIT", 0, 100, 50, "balanced"),
(21369, 21369, "Varka's Commander", 0, "", 0, "Monster2.barka_silenos_chieftain_20_bi", 22, 51, 78, "male", "L2Monster", 40, 4608, 1896, 26.86, 3.09, 40, 43, 30, 21, 20, 10, 15953, 1811, 2588, 587, 1182, 477, 197, 150, 333, 2500, 0, 0, 25, 175, "varka", 300, 0, 0, "LAST_HIT", 100, 0, 50, "fighter"),
(21370, 21370, "Varka's Elite Guard", 0, "", 0, "Monster2.barka_silenos_warrior", 16, 41, 78, "male", "L2Minion", 40, 4550, 1859, 26.86, 3.09, 40, 43, 30, 21, 20, 10, 11565, 1298, 2195, 476, 1144, 468, 278, 0, 333, 2500, 0, 0, 34, 180, "varka", 300, 0, 0, "LAST_HIT", 100, 0, 30, "fighter"),
(21371, 21371, "Varka's Head Magus", 0, "", 0, "Monster2.barka_silenos_shaman", 14, 39.5, 78, "male", "L2Monster", 40, 4813, 2049, 26.86, 3.09, 40, 43, 30, 21, 20, 10, 12360, 1471, 3136, 572, 1333, 511, 200, 150, 333, 6716, 0, 0, 39, 192, "varka", 300, 0, 0, "LAST_HIT", 0, 100, 50, "balanced"),
(21372, 21372, "Varka's Head Guard", 0, "", 0, "Monster2.barka_silenos_hunter", 16, 38, 78, "male", "L2Minion", 40, 4766, 2011, 26.86, 3.09, 40, 43, 30, 21, 20, 10, 12279, 1444, 1658, 749, 1296, 502, 278, 0, 333, 2500, 6918, 0, 48, 192, "varka", 300, 0, 0, "LAST_HIT", 100, 0, 30, "balanced"),
(21373, 21373, "Varka's Prophet", 0, "", 0, "Monster2.barka_silenos_shaman_20_bi", 17, 47.5, 78, "male", "L2Monster", 40, 4899, 2127, 26.86, 3.09, 40, 43, 30, 21, 20, 10, 18082, 2204, 2973, 650, 1406, 528, 200, 150, 333, 6716, 0, 0, 39, 192, "varka", 300, 0, 0, "LAST_HIT", 0, 100, 50, "balanced"),
(21374, 21374, "Prophet Guard", 0, "", 0, "Monster2.barka_silenos_warrior", 16, 41, 78, "male", "L2Minion", 40, 4858, 2088, 26.86, 3.09, 40, 43, 30, 21, 20, 10, 12871, 1550, 2097, 639, 1370, 519, 278, 0, 333, 2500, 6918, 0, 37, 198, "varka", 300, 0, 0, "LAST_HIT", 100, 0, 30, "balanced"),
(21375, 21375, "Disciple of Prophet", 0, "", 0, "Monster2.barka_silenos_priest", 9, 41.5, 78, "male", "L2Minion", 40, 4858, 2088, 26.86, 3.09, 40, 43, 30, 21, 20, 10, 12404, 1494, 2097, 639, 1370, 519, 278, 0, 333, 6716, 0, 0, 39, 198, "varka", 300, 0, 0, "LAST_HIT", 0, 100, 30, "balanced"),
(21376, 21376, "Scarlet Stakato Walker", 0, "", 0, "Monster.blade_stakato_worker", 13, 40, 78, "male", "L2Monster", 40, 4428, 1784, 67.15, 3.09, 40, 43, 30, 21, 20, 10, 7054, 772, 1886, 505, 1069, 451, 278, 150, 333, 235, 0, 0, 27, 143, "fire_clan", 300, 0, 0, "LAST_HIT", 0, 0, 0, "fighter"),
(21377, 21377, "Scarlet Stakato Soldier", 0, "", 0, "Monster.blade_stakato_soldier", 15, 38, 78, "male", "L2Monster", 40, 4428, 1784, 67.15, 3.09, 40, 43, 30, 21, 20, 10, 6904, 755, 1886, 429, 1069, 451, 278, 150, 333, 148, 0, 0, 27, 198, "fire_clan", 300, 0, 0, "LAST_HIT", 0, 0, 0, "fighter"),
(21378, 21378, "Scarlet Stakato Noble", 0, "", 0, "Monster.blade_stakato_drone", 15, 39, 78, "male", "L2Monster", 40, 4490, 1821, 67.15, 3.09, 40, 43, 30, 21, 20, 10, 9829, 1089, 1941, 514, 1107, 459, 278, 150, 333, 235, 0, 0, 27, 198, "fire_clan", 300, 0, 0, "LAST_HIT", 100, 0, 30, "fighter"),
(21379, 21379, "Tepra Scorpion", 0, "", 0, "Monster2.scorpion_20_sm", 24, 52.8, 78, "male", "L2Monster", 40, 4490, 1821, 67.15, 3.09, 40, 43, 30, 21, 20, 10, 7098, 786, 1698, 514, 1107, 459, 317, 150, 333, 0, 0, 0, 40, 137, "fire_clan", 300, 0, 0, "LAST_HIT", 0, 0, 0, "balanced"),
(21380, 21380, "Tepra Scarab", 0, "", 0, "Monster2.scarab", 14, 22, 78, "male", "L2Monster", 40, 4490, 1821, 67.15, 3.09, 40, 43, 30, 21, 20, 10, 7237, 802, 1941, 514, 1107, 459, 278, 150, 333, 0, 0, 0, 49, 192, "fire_clan", 300, 0, 0, "LAST_HIT", 0, 0, 0, "fighter"),
(21381, 21381, "Assassin Beetle", 0, "", 0, "Monster2.tera_beetle", 19, 54.5, 78, "male", "L2Monster", 40, 4550, 1859, 67.15, 3.09, 40, 43, 30, 21, 20, 10, 8414, 944, 1996, 524, 1144, 468, 278, 150, 333, 0, 0, 0, 49, 159, "fire_clan", 300, 0, 0, "LAST_HIT", 100, 0, 30, "fighter"),
(21382, 21382, "Mercenary of Destruction", 0, "", 0, "Monster.skeleton_knight", 10, 25, 78, "male", "L2Monster", 40, 4550, 1859, 67.15, 3.09, 40, 43, 30, 21, 20, 10, 10380, 1165, 1996, 524, 1144, 468, 278, 150, 333, 150, 103, 0, 44, 181, "fire_clan", 300, 1, 0, "LAST_HIT", 0, 0, 0, "fighter"),
(21383, 21383, "Knight of Destruction", 0, "", 0, "Monster.skeleton_royal_guard", 11, 28.5, 78, "male", "L2Monster", 40, 4550, 1859, 67.15, 3.09, 40, 43, 30, 21, 20, 10, 10396, 1167, 1996, 524, 1144, 468, 278, 150, 333, 946, 945, 0, 88, 203, "fire_clan", 300, 1, 0, "LAST_HIT", 100, 0, 30, "fighter"),
(21384, 21384, "Necromancer of Destruction", 0, "", 0, "Monster.vale_master_20_bi", 14.5, 48, 78, "male", "L2Monster", 40, 4608, 1896, 67.15, 3.09, 40, 43, 30, 21, 20, 10, 8915, 1012, 2050, 454, 1182, 477, 278, 150, 333, 0, 0, 0, 77, 159, "fire_clan", 300, 0, 0, "LAST_HIT", 0, 0, 0, "fighter"),
(21385, 21385, "Lavastone Golem", 0, "", 0, "Monster.stone_golem", 20, 31, 78, "male", "L2Monster", 40, 4608, 1896, 67.15, 3.09, 40, 43, 30, 21, 20, 10, 8585, 975, 2050, 534, 1182, 477, 278, 150, 333, 0, 0, 0, 25, 44, "fire_clan", 300, 0, 0, "LAST_HIT", 0, 0, 0, "fighter"),
(21386, 21386, "Magma Golem", 0, "", 0, "Monster2.lava_golem", 22, 45, 78, "male", "L2Monster", 40, 4608, 1896, 67.15, 3.09, 40, 43, 30, 21, 20, 10, 9174, 1041, 2847, 534, 1182, 477, 200, 150, 333, 0, 0, 0, 14, 66, "fire_clan", 300, 0, 0, "LAST_HIT", 0, 100, 30, "balanced"),
(21387, 21387, "Arimanes of Destruction", 0, "", 0, "Monster2.ahrimanes", 14, 57.75, 78, "male", "L2Monster", 40, 4663, 1934, 67.15, 3.09, 40, 43, 30, 21, 20, 10, 7314, 840, 2921, 543, 1220, 485, 200, 150, 333, 6722, 0, 0, 38, 203, "fire_clan", 300, 0, 0, "LAST_HIT", 100, 0, 40, "fighter"),
(21388, 21388, "Iblis of Destruction", 0, "", 0, "Monster.fiend_archer", 17, 55, 78, "male", "L2Monster", 40, 4663, 1934, 80.58, 3.09, 40, 43, 30, 21, 20, 10, 9221, 1059, 2103, 543, 1220, 485, 278, 150, 333, 0, 0, 0, 77, 165, "fire_clan", 300, 0, 0, "LAST_HIT", 0, 0, 0, "archer"),
(21389, 21389, "Balrog of Destruction", 0, "", 0, "Monster.kaim_vanul", 24, 40, 78, "male", "L2Monster", 40, 4716, 1972, 80.58, 3.09, 40, 43, 30, 21, 20, 10, 9888, 1149, 2155, 553, 1258, 494, 278, 150, 333, 0, 0, 0, 40, 170, "fire_clan", 300, 0, 0, "LAST_HIT", 100, 0, 20, "fighter"),
(21390, 21390, "Ashuras of Destruction", 0, "", 0, "Monster2.ashuras_30_bi", 17, 49, 78, "male", "L2Monster", 40, 4766, 2011, 80.58, 3.09, 40, 43, 30, 21, 20, 10, 11408, 1342, 2207, 562, 1296, 502, 278, 150, 333, 0, 0, 0, 45, 209, "fire_clan", 300, 0, 0, "LAST_HIT", 100, 0, 30, "fighter"),
(21391, 21391, "Lavasillisk", 0, "", 0, "Monster.lesser_basilisk", 34, 25, 78, "male", "L2Monster", 40, 4716, 1972, 80.58, 3.09, 40, 43, 30, 21, 20, 10, 7886, 916, 2155, 553, 1258, 494, 278, 150, 333, 0, 0, 0, 38, 154, "fire_clan", 300, 0, 0, "LAST_HIT", 0, 0, 0, "fighter"),
(21392, 21392, "Blazing Ifrit", 0, "", 0, "Monster2.ifrit_30_bi", 13, 55, 78, "male", "L2Monster", 40, 4766, 2011, 80.58, 3.09, 40, 43, 30, 21, 20, 10, 11251, 1323, 2207, 562, 1296, 502, 278, 150, 333, 0, 0, 0, 41, 165, "fire_clan", 300, 0, 0, "LAST_HIT", 0, 100, 30, "balanced"),
(21393, 21393, "Magma Drake", 0, "", 0, "Monster2.inferno_drake_20_bi", 29, 42, 78, "male", "L2Monster", 40, 4813, 2049, 80.58, 3.09, 40, 43, 30, 21, 20, 10, 9494, 1130, 2257, 572, 1333, 511, 278, 150, 333, 0, 0, 0, 62, 214, "fire_clan", 300, 0, 0, "LAST_HIT", 0, 100, 30, "balanced"),
(21394, 21394, "Lavasaurus", 0, "", 0, "Monster2.magmagoil", 15, 75, 78, "male", "L2Monster", 500, 4490, 1821, 67.15, 3.09, 40, 43, 30, 21, 20, 10, 8988, 996, 5991, 437, 1107, 459, 179, 150, 333, 0, 0, 0, 1, 1, "fire_clan", 300, 0, 0, "LAST_HIT", 100, 0, 20, "fighter"),
(21395, 21395, "Elder Lavasaurus", 0, "", 0, "Monster2.magmagoil_lad", 15, 75, 78, "male", "L2Monster", 500, 4716, 1972, 80.58, 3.09, 40, 43, 30, 21, 20, 10, 9760, 1134, 6652, 470, 1258, 494, 179, 150, 333, 0, 0, 0, 1, 1, "fire_clan", 300, 0, 0, "LAST_HIT", 0, 100, 30, "balanced"),
(21396, 21396, "Carrion Scarab", 0, "", 0, "Monster2.scarab", 14, 22, 78, "male", "L2Monster", 40, 4428, 1784, 40.29, 3.09, 40, 43, 30, 21, 20, 10, 8182, 895, 1417, 672, 1069, 451, 278, 0, 333, 0, 0, 0, 49, 143, "tomb_clan", 300, 0, 0, "LAST_HIT", 100, 0, 20, "balanced"),
(21397, 21397, "Carrion Scarab", 0, "", 0, "Monster2.scarab", 14, 22, 78, "male", "L2Monster", 40, 4428, 1784, 40.29, 3.09, 40, 43, 30, 21, 20, 10, 7103, 777, 2282, 417, 1069, 451, 278, 0, 333, 0, 0, 0, 49, 143, "tomb_clan", 300, 0, 0, "LAST_HIT", 0, 0, 0, "fighter"),
(21398, 21398, "Soldier Scarab", 0, "", 0, "Monster2.scarab", 14, 22, 78, "male", "L2Monster", 40, 4428, 1784, 80.58, 3.09, 40, 43, 30, 21, 20, 10, 6744, 738, 1715, 555, 1069, 451, 278, 150, 333, 0, 0, 0, 49, 198, "tomb_clan", 300, 0, 0, "LAST_HIT", 0, 0, 0, "fighter"),
(21399, 21399, "Soldier Scarab", 0, "", 0, "Monster2.scarab", 14, 22, 78, "male", "L2Monster", 40, 4428, 1784, 67.15, 3.09, 40, 43, 30, 21, 20, 10, 7736, 846, 1715, 555, 1069, 451, 278, 150, 333, 0, 0, 0, 49, 198, "tomb_clan", 300, 0, 0, "LAST_HIT", 0, 0, 0, "fighter"),
(21400, 21400, "Hexa Beetle", 0, "", 0, "Monster2.tera_beetle", 25, 54.5, 78, "male", "L2Monster", 40, 4490, 1821, 67.15, 3.09, 40, 43, 30, 21, 20, 10, 6611, 732, 1765, 566, 1107, 459, 278, 0, 333, 0, 0, 0, 49, 159, "tomb_clan", 300, 0, 0, "LAST_HIT", 0, 0, 0, "fighter"),
(21401, 21401, "Hexa Beetle", 0, "", 0, "Monster2.tera_beetle", 25, 54.5, 78, "male", "L2Monster", 40, 4490, 1821, 53.72, 3.09, 40, 43, 30, 21, 20, 10, 7271, 806, 1941, 514, 1107, 459, 278, 150, 333, 0, 0, 0, 45, 145, "tomb_clan", 300, 0, 0, "LAST_HIT", 0, 0, 0, "fighter"),
(21402, 21402, "Katraxis", 0, "", 0, "Monster2.scorpion_20_sm", 24, 52.8, 78, "male", "L2Monster", 40, 4490, 1821, 53.72, 3.09, 40, 43, 30, 21, 20, 10, 7503, 831, 1544, 566, 1107, 459, 317, 150, 333, 0, 0, 0, 37, 165, "tomb_clan", 300, 0, 0, "LAST_HIT", 0, 0, 0, "balanced"),
(21403, 21403, "Katraxis", 0, "", 0, "Monster2.scorpion_20_sm", 24, 52.8, 78, "male", "L2Monster", 40, 4490, 1821, 67.15, 3.09, 40, 43, 30, 21, 20, 10, 6928, 767, 1544, 566, 1107, 459, 317, 150, 333, 0, 0, 0, 40, 181, "tomb_clan", 300, 0, 0, "LAST_HIT", 0, 0, 0, "balanced"),
(21404, 21404, "Tera Beetle", 0, "", 0, "Monster2.tera_beetle", 25, 54.5, 78, "male", "L2Monster", 40, 4550, 1859, 53.72, 3.09, 40, 43, 30, 21, 20, 10, 14906, 1673, 1649, 634, 1144, 468, 278, 0, 333, 0, 0, 0, 49, 203, "tomb_clan", 300, 0, 0, "LAST_HIT", 0, 0, 0, "balanced"),
(21405, 21405, "Tera Beetle", 0, "", 0, "Monster2.tera_beetle", 25, 54.5, 78, "male", "L2Monster", 40, 4550, 1859, 53.72, 3.09, 40, 43, 30, 21, 20, 10, 7146, 802, 1814, 576, 1144, 468, 278, 0, 333, 0, 0, 0, 45, 185, "tomb_clan", 300, 0, 0, "LAST_HIT", 0, 0, 0, "fighter"),
(21406, 21406, "Knight of Empire", 0, "", 0, "Monster.skeleton_knight", 10, 25, 78, "male", "L2Monster", 40, 4550, 1859, 67.15, 3.09, 40, 43, 30, 21, 20, 10, 8454, 949, 1814, 576, 1144, 468, 278, 150, 333, 150, 103, 0, 40, 145, "tomb_clan", 300, 1, 0, "LAST_HIT", 0, 100, 30, "balanced"),
(21407, 21407, "Knight of Empire", 0, "", 0, "Monster.skeleton_knight", 10, 25, 78, "male", "L2Monster", 40, 4550, 1859, 40.29, 3.09, 40, 43, 30, 21, 20, 10, 9017, 1012, 1814, 576, 1144, 468, 278, 150, 333, 150, 103, 0, 40, 145, "tomb_clan", 300, 1, 0, "LAST_HIT", 0, 0, 0, "fighter"),
(21408, 21408, "Royal Guard of Empire", 0, "", 0, "Monster.skeleton_pikeman", 10, 28, 78, "male", "L2Monster", 40, 4550, 1859, 67.15, 3.09, 40, 43, 30, 21, 20, 10, 7358, 825, 1996, 524, 1144, 468, 278, 150, 333, 304, 0, 0, 55, 209, "tomb_clan", 300, 1, 0, "LAST_HIT", 0, 0, 0, "fighter"),
(21409, 21409, "Royal Guard of Empire", 0, "", 0, "Monster.skeleton_pikeman", 10, 28, 78, "male", "L2Monster", 40, 4550, 1859, 80.58, 3.09, 40, 43, 30, 21, 20, 10, 6857, 769, 1499, 698, 1144, 468, 278, 150, 333, 304, 0, 0, 55, 209, "tomb_clan", 300, 1, 0, "LAST_HIT", 0, 100, 30, "balanced"),
(21410, 21410, "Guardian Scarab", 0, "", 0, "Monster2.scarab_20_bi", 17, 26.5, 78, "male", "L2Monster", 40, 4608, 1896, 67.15, 3.09, 40, 43, 30, 21, 20, 10, 7602, 863, 1863, 587, 1182, 477, 278, 0, 333, 0, 0, 0, 45, 195, "tomb_clan", 300, 0, 0, "LAST_HIT", 100, 0, 30, "fighter"),
(21411, 21411, "Guardian Scarab", 0, "", 0, "Monster2.scarab_20_bi", 17, 26.5, 78, "male", "L2Monster", 40, 4608, 1896, 53.72, 3.09, 40, 43, 30, 21, 20, 10, 7584, 861, 1863, 587, 1182, 477, 278, 0, 333, 0, 0, 0, 45, 195, "tomb_clan", 300, 0, 0, "LAST_HIT", 0, 0, 0, "fighter"),
(21412, 21412, "Ustralith", 0, "", 0, "Monster2.scorpion", 28, 66, 78, "male", "L2Monster", 40, 4608, 1896, 67.15, 3.09, 40, 43, 30, 21, 20, 10, 9682, 1099, 1347, 710, 1182, 477, 317, 150, 333, 0, 0, 0, 37, 130, "tomb_clan", 300, 0, 0, "LAST_HIT", 0, 0, 0, "balanced"),
(21413, 21413, "Ustralith", 0, "", 0, "Monster2.scorpion", 28, 66, 78, "male", "L2Monster", 40, 4608, 1896, 67.15, 3.09, 40, 43, 30, 21, 20, 10, 7445, 845, 1793, 534, 1182, 477, 317, 150, 333, 0, 0, 0, 40, 143, "tomb_clan", 300, 0, 0, "LAST_HIT", 100, 0, 30, "balanced"),
(21414, 21414, "Assassin of Empire", 0, "", 0, "Monster.skeleton_royal_guard", 11, 28.5, 78, "male", "L2Monster", 40, 4608, 1896, 67.15, 3.09, 40, 43, 30, 21, 20, 10, 7236, 821, 1973, 485, 1182, 477, 317, 0, 333, 946, 945, 0, 88, 192, "tomb_clan", 300, 1, 0, "LAST_HIT", 0, 0, 0, "fighter"),
(21415, 21415, "Assassin of Empire", 0, "", 0, "Monster.skeleton_royal_guard", 11, 28.5, 78, "male", "L2Monster", 40, 4608, 1896, 67.15, 3.09, 40, 43, 30, 21, 20, 10, 7299, 828, 1482, 646, 1182, 477, 317, 0, 333, 946, 945, 0, 88, 192, "tomb_clan", 300, 1, 0, "LAST_HIT", 0, 100, 30, "balanced"),
(21416, 21416, "Imperial Commander", 0, "", 0, "Monster2.imperial_warlord_zombie", 7, 30, 78, "male", "L2Monster", 40, 4608, 1896, 67.15, 3.09, 40, 43, 30, 21, 20, 10, 8637, 980, 1863, 587, 1182, 477, 278, 150, 333, 134, 6721, 0, 39, 140, "tomb_clan", 300, 1, 0, "LAST_HIT", 0, 0, 0, "fighter"),
(21417, 21417, "Imperial Commander", 0, "", 0, "Monster2.imperial_warlord_zombie", 7, 30, 78, "male", "L2Monster", 40, 4608, 1896, 80.58, 3.09, 40, 43, 30, 21, 20, 10, 12557, 1425, 2255, 485, 1182, 477, 278, 150, 333, 134, 6721, 0, 39, 140, "tomb_clan", 300, 1, 0, "LAST_HIT", 0, 0, 0, "fighter"),
(21418, 21418, "Imperial Royal Guard", 0, "", 0, "Monster.death_knight", 12, 31, 78, "male", "L2Monster", 40, 4663, 1934, 53.72, 3.09, 40, 43, 30, 21, 20, 10, 8030, 922, 1912, 598, 1220, 485, 278, 0, 333, 142, 0, 0, 29, 176, "tomb_clan", 300, 1, 0, "LAST_HIT", 0, 0, 0, "fighter"),
(21419, 21419, "Imperial Royal Guard", 0, "", 0, "Monster.death_knight", 12, 31, 78, "male", "L2Monster", 40, 4663, 1934, 53.72, 3.09, 40, 43, 30, 21, 20, 10, 8173, 939, 1912, 598, 1220, 485, 278, 0, 333, 142, 0, 0, 29, 176, "tomb_clan", 300, 1, 0, "LAST_HIT", 0, 0, 0, "fighter"),
(21420, 21420, "Ashuras", 0, "", 0, "Monster2.ashuras", 13, 37.5, 78, "male", "L2Monster", 40, 4663, 1934, 67.15, 3.09, 40, 43, 30, 21, 20, 10, 7704, 885, 1912, 598, 1220, 485, 278, 150, 333, 0, 0, 0, 45, 220, "tomb_clan", 300, 0, 0, "LAST_HIT", 0, 100, 30, "balanced"),
(21421, 21421, "Ashuras", 0, "", 0, "Monster2.ashuras", 13, 37.5, 78, "male", "L2Monster", 40, 4663, 1934, 67.15, 3.09, 40, 43, 30, 21, 20, 10, 7231, 830, 1912, 598, 1220, 485, 278, 150, 333, 0, 0, 0, 45, 220, "tomb_clan", 300, 0, 0, "LAST_HIT", 0, 0, 0, "fighter"),
(21422, 21422, "Dancer of Empire", 0, "", 0, "Monster.banshee", 9, 23, 78, "female", "L2Monster", 40, 4663, 1934, 80.58, 3.09, 40, 43, 30, 21, 20, 10, 6913, 794, 2103, 543, 1220, 485, 278, 0, 333, 0, 0, 0, 88, 132, "tomb_clan", 300, 0, 0, "LAST_HIT", 100, 0, 30, "fighter"),
(21423, 21423, "Dancer of Empire", 0, "", 0, "Monster.banshee", 9, 23, 78, "female", "L2Monster", 40, 4663, 1934, 80.58, 3.09, 40, 43, 30, 21, 20, 10, 7328, 842, 2103, 543, 1220, 485, 278, 150, 333, 0, 0, 0, 88, 132, "tomb_clan", 300, 0, 0, "LAST_HIT", 0, 0, 0, "fighter"),
(21424, 21424, "Ashkenas", 0, "", 0, "Monster2.ashuras", 13, 37.5, 78, "male", "L2Monster", 40, 4663, 1934, 80.58, 3.09, 40, 43, 30, 21, 20, 10, 9288, 1067, 2544, 449, 1220, 485, 278, 0, 333, 0, 0, 0, 45, 209, "tomb_clan", 300, 0, 0, "LAST_HIT", 0, 100, 30, "balanced"),
(21425, 21425, "Ashkenas", 0, "", 0, "Monster2.ashuras", 13, 37.5, 78, "male", "L2Monster", 40, 4663, 1934, 80.58, 3.09, 40, 43, 30, 21, 20, 10, 9444, 1085, 2544, 449, 1220, 485, 278, 150, 333, 0, 0, 0, 45, 209, "tomb_clan", 300, 0, 0, "LAST_HIT", 0, 100, 30, "balanced"),
(21426, 21426, "Abraxion", 0, "", 0, "Monster2.erinyes", 21, 50, 78, "male", "L2Monster", 40, 4716, 1972, 53.72, 3.09, 40, 43, 30, 21, 20, 10, 16312, 1896, 2722, 608, 1258, 494, 200, 150, 333, 0, 0, 0, 34, 143, "tomb_clan", 300, 0, 0, "LAST_HIT", 0, 0, 0, "fighter"),
(21427, 21427, "Abraxion", 0, "", 0, "Monster2.erinyes", 21, 50, 78, "male", "L2Monster", 40, 4716, 1972, 53.72, 3.09, 40, 43, 30, 21, 20, 10, 9587, 1114, 2722, 608, 1258, 494, 200, 150, 333, 0, 0, 0, 34, 143, "tomb_clan", 300, 0, 0, "LAST_HIT", 0, 0, 0, "fighter"),
(21428, 21428, "Hasturan", 0, "", 0, "Monster2.erinyes", 21, 50, 78, "male", "L2Monster", 40, 4716, 1972, 67.15, 3.09, 40, 43, 30, 21, 20, 10, 7324, 851, 2994, 553, 1258, 494, 200, 150, 333, 0, 0, 0, 34, 165, "tomb_clan", 300, 0, 0, "LAST_HIT", 0, 0, 0, "fighter"),
(21429, 21429, "Hasturan", 0, "", 0, "Monster2.erinyes", 21, 50, 78, "male", "L2Monster", 40, 4716, 1972, 67.15, 3.09, 40, 43, 30, 21, 20, 10, 7647, 889, 2474, 669, 1258, 494, 200, 150, 333, 0, 0, 0, 34, 165, "tomb_clan", 300, 0, 0, "LAST_HIT", 0, 0, 0, "fighter"),
(21430, 21430, "Arimanes", 0, "", 0, "Monster2.ahrimanes", 14, 57.75, 78, "male", "L2Monster", 40, 4716, 1972, 80.58, 3.09, 40, 43, 30, 21, 20, 10, 8801, 1023, 3293, 503, 1258, 494, 200, 0, 333, 6722, 0, 0, 38, 231, "tomb_clan", 300, 0, 0, "LAST_HIT", 0, 100, 30, "balanced"),
(21431, 21431, "Arimanes", 0, "", 0, "Monster2.ahrimanes", 14, 57.75, 78, "male", "L2Monster", 40, 4716, 1972, 80.58, 3.09, 40, 43, 30, 21, 20, 10, 7507, 872, 2249, 736, 1258, 494, 200, 0, 333, 6722, 0, 0, 38, 231, "tomb_clan", 300, 0, 0, "LAST_HIT", 0, 100, 30, "balanced"),
(21432, 21432, "Chakram Beetle", 0, "", 0, "Monster2.tera_beetle", 19, 54.5, 80, "male", "L2Monster", 40, 4550, 1859, 80.58, 3.09, 40, 43, 30, 21, 20, 10, 12155, 1364, 1814, 576, 1144, 468, 278, 0, 333, 0, 0, 0, 49, 187, "tomb_clan", 300, 0, 0, "LAST_HIT", 0, 0, 0, "fighter"),
(21433, 21433, "Jamadar Beetle", 0, "", 0, "Monster2.tera_beetle_20_sm", 20, 43.6, 79, "male", "L2Monster", 40, 4490, 1821, 80.58, 3.09, 40, 43, 30, 21, 20, 10, 11788, 1306, 1765, 566, 1107, 459, 278, 0, 333, 0, 0, 0, 49, 192, "NULL", 0, 0, 0, "LAST_HIT", 0, 0, 0, "fighter"),
(21434, 21434, "Seer of Blood", 0, "", 0, "Monster2.erinyes", 21, 50, 82, "male", "L2Monster", 40, 4663, 1934, 80.58, 3.09, 40, 43, 30, 21, 20, 10, 23561, 2707, 2655, 598, 1220, 485, 200, 0, 333, 0, 0, 0, 34, 165, "tomb_clan", 300, 0, 0, "LAST_HIT", 0, 0, 0, "fighter"),
(21435, 21435, "Guide of Offering", 0, "", 0, "Monster2.imperial_warlord_zombie", 7, 30, 80, "male", "L2Monster", 40, 4550, 1859, 80.58, 3.09, 40, 43, 30, 21, 20, 10, 11922, 1338, 1814, 576, 1144, 468, 278, 0, 333, 134, 6721, 0, 42, 165, "NULL", 0, 1, 0, "LAST_HIT", 0, 0, 0, "fighter"),
(21436, 21436, "Leader of Offering", 0, "", 0, "Monster2.imperial_warlord_zombie", 7, 30, 80, "male", "L2Monster", 40, 4550, 1859, 80.58, 3.09, 40, 43, 30, 21, 20, 10, 12367, 1388, 1814, 576, 1144, 468, 278, 0, 333, 134, 6721, 0, 42, 165, "NULL", 0, 1, 0, "LAST_HIT", 0, 0, 0, "fighter"),
(21437, 21437, "Offering Bug", 0, "", 0, "Monster2.scarab", 14, 22, 79, "male", "L2Monster", 40, 4490, 1821, 53.72, 3.09, 40, 43, 30, 21, 20, 10, 7489, 830, 1765, 566, 1107, 459, 278, 0, 333, 0, 0, 0, 49, 198, "NULL", 0, 0, 0, "LAST_HIT", 0, 0, 0, "fighter"),
(21438, 21438, "Heathen Warrior", 0, "", 0, "Monster.skeleton_royal_guard", 11, 28.5, 65, "male", "L2Monster", 40, 3465, 1319, 2.96, 2.78, 40, 43, 30, 21, 20, 10, 5966, 556, 1140, 346, 619, 340, 317, 150, 333, 946, 945, 0, 88, 192, "undead_clan", 300, 1, 0, "LAST_HIT", 100, 0, 30, "fighter"),
(21439, 21439, "Heathen Executed ", 0, "", 0, "Monster.hungry_spirit", 30, 40, 66, "male", "L2Monster", 40, 3546, 1353, 2.96, 2.78, 40, 43, 30, 21, 20, 10, 6151, 580, 1358, 301, 649, 348, 278, 150, 333, 0, 0, 0, 16, 192, "undead_clan", 300, 1, 0, "LAST_HIT", 100, 0, 30, "fighter"),
(21440, 21440, "Heathen Archer", 0, "", 0, "Monster.skeleton_archer", 11, 27, 67, "male", "L2Monster", 500, 3626, 1388, 2.96, 2.78, 40, 43, 30, 21, 20, 10, 6735, 640, 3145, 308, 681, 356, 249, 0, 333, 284, 0, 0, 44, 170, "undead_clan", 300, 1, 0, "LAST_HIT", 100, 0, 30, "archer"),
(21441, 21441, "Heathen Grunt", 0, "", 0, "Monster.skeleton_pikeman", 10, 28, 68, "male", "L2Monster", 40, 3706, 1423, 2.96, 2.78, 40, 43, 30, 21, 20, 10, 6530, 632, 1473, 371, 713, 365, 278, 150, 333, 96, 0, 0, 55, 187, "undead_clan", 300, 1, 0, "LAST_HIT", 100, 0, 30, "fighter"),
(21442, 21442, "Heathen Knight", 0, "", 0, "Monster.skeleton_knight", 10, 25, 69, "male", "L2Monster", 40, 3784, 1458, 2.96, 2.78, 40, 43, 30, 21, 20, 10, 6723, 656, 1531, 380, 746, 373, 278, 150, 333, 150, 103, 0, 44, 181, "undead_clan", 300, 1, 0, "LAST_HIT", 100, 0, 30, "fighter"),
(21443, 21443, "Raider of Pastureland", 0, "", 0, "Monster.dark_mahum", 13, 26, 63, "male", "L2Monster", 40, 3302, 1251, 11.85, 2.78, 40, 43, 30, 21, 20, 10, 7006, 633, 649, 530, 560, 323, 317, 150, 333, 153, 0, 0, 55, 181, "nonpet_clan", 300, 0, 0, "LAST_HIT", 0, 0, 0, "balanced"),
(21444, 21444, "Raider of Pastureland", 0, "", 0, "Monster.dark_mahum", 13, 26, 63, "male", "L2Monster", 40, 3302, 1251, 11.85, 2.78, 40, 43, 30, 21, 20, 10, 5887, 532, 741, 530, 560, 323, 278, 150, 333, 153, 0, 0, 55, 181, "nonpet_clan", 300, 0, 0, "LAST_HIT", 100, 0, 30, "balanced"),
(21445, 21445, "Alpen Bandersnatch", 0, "", 0, "Monster2.bandersnatch", 18, 25, 64, "male", "L2Monster", 40, 3384, 1285, 11.85, 2.78, 40, 43, 30, 21, 20, 10, 6076, 556, 1302, 449, 589, 331, 200, 150, 333, 0, 0, 0, 33, 187, "nonpet_clan", 300, 0, 0, "LAST_HIT", 0, 0, 0, "fighter"),
(21446, 21446, "Raider of Pastureland", 0, "", 0, "Monster.dark_mahum", 13, 26, 64, "male", "L2Monster", 40, 3384, 1285, 11.85, 2.78, 40, 43, 30, 21, 20, 10, 7476, 684, 678, 543, 589, 331, 317, 150, 333, 160, 0, 0, 55, 181, "nonpet_clan", 300, 0, 0, "LAST_HIT", 0, 0, 0, "balanced"),
(21447, 21447, "Raider of Pastureland", 0, "", 0, "Monster.dark_mahum", 13, 26, 66, "male", "L2Monster", 40, 3546, 1353, 11.85, 2.78, 40, 43, 30, 21, 20, 10, 7689, 724, 738, 570, 649, 348, 317, 150, 333, 229, 0, 0, 55, 181, "nonpet_clan", 300, 0, 0, "LAST_HIT", 0, 0, 0, "balanced"),
(21448, 21448, "Raider of Pastureland", 0, "", 0, "Monster.dark_mahum", 13, 26, 66, "male", "L2Monster", 40, 3546, 1353, 11.85, 2.78, 40, 43, 30, 21, 20, 10, 6462, 608, 843, 570, 649, 348, 278, 150, 333, 229, 0, 0, 55, 181, "nonpet_clan", 300, 0, 0, "LAST_HIT", 100, 0, 30, "balanced"),
(21449, 21449, "Raider of Pastureland", 0, "", 0, "Monster.dark_mahum", 13, 26, 68, "male", "L2Monster", 40, 3706, 1423, 11.85, 2.78, 40, 43, 30, 21, 20, 10, 8440, 815, 800, 598, 713, 365, 317, 150, 333, 234, 0, 0, 55, 181, "nonpet_clan", 300, 0, 0, "LAST_HIT", 0, 0, 0, "balanced"),
(21450, 21450, "Alpen Grendel", 0, "", 0, "Monster2.bionic_bear", 15, 39, 68, "male", "L2Monster", 40, 3706, 1423, 11.85, 2.78, 40, 43, 30, 21, 20, 10, 8162, 789, 1690, 449, 713, 365, 200, 150, 333, 0, 0, 0, 39, 170, "nonpet_clan", 300, 0, 0, "LAST_HIT", 0, 0, 0, "fighter"),
(21451, 21451, "Alpen Kookaburra", 0, "", 0, "Monster2.baby_ostrich", 7, 15, 65, "male", "L2FeedableBeast", 40, 3465, 1319, 5.93, 2.78, 40, 43, 30, 21, 20, 10, 5530, 514, 1077, 418, 619, 340, 278, 0, 333, 0, 0, 0, 14, 121, "pet_clan", 300, 0, 0, "LAST_HIT", 0, 0, 0, "fighter"),
(21452, 21452, "Alpen Kookaburra", 0, "", 0, "Monster2.baby_ostrich", 7, 15, 65, "male", "L2FeedableBeast", 40, 3465, 1319, 11.85, 2.78, 40, 43, 30, 21, 20, 10, 7312, 679, 890, 506, 619, 340, 278, 0, 333, 0, 0, 0, 14, 154, "pet_clan", 300, 0, 0, "LAST_HIT", 0, 0, 0, "balanced"),
(21453, 21453, "Alpen Kookaburra", 0, "", 0, "Monster2.baby_ostrich", 7, 15, 65, "male", "L2FeedableBeast", 40, 3465, 1319, 11.85, 2.78, 40, 43, 30, 21, 20, 10, 6144, 571, 890, 506, 619, 340, 278, 0, 333, 0, 0, 0, 14, 154, "pet_clan", 300, 0, 0, "LAST_HIT", 0, 0, 0, "balanced"),
(21454, 21454, "Alpen Kookaburra", 0, "", 0, "Monster2.baby_ostrich", 7, 15, 65, "male", "L2FeedableBeast", 40, 3465, 1319, 11.85, 2.78, 40, 43, 30, 21, 20, 10, 7312, 679, 890, 506, 619, 340, 278, 0, 333, 0, 0, 0, 14, 154, "pet_clan", 300, 0, 0, "LAST_HIT", 0, 0, 0, "balanced"),
(21455, 21455, "Alpen Kookaburra", 0, "", 0, "Monster2.baby_ostrich", 7, 15, 65, "male", "L2FeedableBeast", 40, 3465, 1319, 11.85, 2.78, 40, 43, 30, 21, 20, 10, 6144, 571, 890, 506, 619, 340, 278, 0, 333, 0, 0, 0, 14, 154, "pet_clan", 300, 0, 0, "LAST_HIT", 0, 0, 0, "balanced"),
(21456, 21456, "Alpen Kookaburra", 0, "", 0, "Monster2.baby_ostrich", 7, 15, 65, "male", "L2FeedableBeast", 40, 3465, 1319, 11.85, 2.78, 40, 43, 30, 21, 20, 10, 7312, 679, 890, 506, 619, 340, 278, 0, 333, 0, 0, 0, 14, 154, "pet_clan", 300, 0, 0, "LAST_HIT", 0, 0, 0, "balanced"),
(21457, 21457, "Alpen Kookaburra", 0, "", 0, "Monster2.baby_ostrich", 7, 15, 65, "male", "L2FeedableBeast", 40, 3465, 1319, 11.85, 2.78, 40, 43, 30, 21, 20, 10, 6144, 571, 890, 506, 619, 340, 278, 0, 333, 0, 0, 0, 14, 154, "pet_clan", 300, 0, 0, "LAST_HIT", 0, 0, 0, "balanced"),
(21458, 21458, "Alpen Kookaburra", 0, "", 0, "Monster2.baby_ostrich", 7, 15, 65, "male", "L2FeedableBeast", 40, 3465, 1319, 11.85, 2.78, 40, 43, 30, 21, 20, 10, 7312, 679, 890, 506, 619, 340, 278, 0, 333, 0, 0, 0, 14, 154, "pet_clan", 300, 0, 0, "LAST_HIT", 0, 0, 0, "balanced"),
(21459, 21459, "Alpen Kookaburra", 0, "", 0, "Monster2.baby_ostrich", 7, 15, 65, "male", "L2FeedableBeast", 40, 3465, 1319, 11.85, 2.78, 40, 43, 30, 21, 20, 10, 6144, 571, 890, 506, 619, 340, 278, 0, 333, 0, 0, 0, 14, 154, "pet_clan", 300, 0, 0, "LAST_HIT", 0, 0, 0, "balanced"),
(21460, 21460, "Alpen Kookaburra", 0, "", 0, "Monster2.youth_ostrich", 8, 26.4, 65, "male", "L2FeedableBeast", 40, 3465, 1319, 23.7, 2.78, 40, 43, 30, 21, 20, 10, 7661, 711, 1077, 418, 619, 340, 278, 150, 333, 0, 0, 0, 25, 209, "pet_clan", 300, 0, 0, "LAST_HIT", 0, 0, 0, "fighter"),
(21461, 21461, "Alpen Kookaburra", 0, "", 0, "Monster2.youth_ostrich", 8, 26.4, 65, "male", "L2FeedableBeast", 40, 3465, 1319, 23.7, 2.78, 40, 43, 30, 21, 20, 10, 7963, 740, 1077, 418, 619, 340, 278, 150, 333, 0, 0, 0, 25, 209, "pet_clan", 300, 0, 0, "LAST_HIT", 0, 0, 0, "fighter"),
(21462, 21462, "Alpen Kookaburra", 0, "", 0, "Monster2.youth_ostrich", 8, 26.4, 65, "male", "L2FeedableBeast", 40, 3465, 1319, 23.7, 2.78, 40, 43, 30, 21, 20, 10, 7661, 711, 1077, 418, 619, 340, 278, 150, 333, 0, 0, 0, 25, 209, "pet_clan", 300, 0, 0, "LAST_HIT", 0, 0, 0, "fighter"),
(21463, 21463, "Alpen Kookaburra", 0, "", 0, "Monster2.youth_ostrich", 8, 26.4, 65, "male", "L2FeedableBeast", 40, 3465, 1319, 23.7, 2.78, 40, 43, 30, 21, 20, 10, 7367, 684, 1077, 418, 619, 340, 278, 150, 333, 0, 0, 0, 25, 209, "pet_clan", 300, 0, 0, "LAST_HIT", 0, 0, 0, "fighter"),
(21464, 21464, "Alpen Kookaburra", 0, "", 0, "Monster2.youth_ostrich", 8, 26.4, 65, "male", "L2FeedableBeast", 40, 3465, 1319, 23.7, 2.78, 40, 43, 30, 21, 20, 10, 7661, 711, 1077, 418, 619, 340, 278, 150, 333, 0, 0, 0, 25, 209, "pet_clan", 300, 0, 0, "LAST_HIT", 0, 0, 0, "fighter"),
(21465, 21465, "Alpen Kookaburra", 0, "", 0, "Monster2.youth_ostrich", 8, 26.4, 65, "male", "L2FeedableBeast", 40, 3465, 1319, 23.7, 2.78, 40, 43, 30, 21, 20, 10, 7963, 740, 1077, 418, 619, 340, 278, 150, 333, 0, 0, 0, 25, 209, "pet_clan", 300, 0, 0, "LAST_HIT", 0, 0, 0, "fighter"),
(21466, 21466, "Alpen Kookaburra", 0, "", 0, "Monster2.youth_ostrich", 8, 26.4, 65, "male", "L2FeedableBeast", 40, 3465, 1319, 23.7, 2.78, 40, 43, 30, 21, 20, 10, 7661, 711, 1077, 418, 619, 340, 278, 150, 333, 0, 0, 0, 25, 209, "pet_clan", 300, 0, 0, "LAST_HIT", 0, 0, 0, "fighter"),
(21467, 21467, "Alpen Kookaburra", 0, "", 0, "Monster2.youth_ostrich", 8, 26.4, 65, "male", "L2FeedableBeast", 40, 3465, 1319, 23.7, 2.78, 40, 43, 30, 21, 20, 10, 7367, 684, 1077, 418, 619, 340, 278, 150, 333, 0, 0, 0, 25, 209, "pet_clan", 300, 0, 0, "LAST_HIT", 0, 0, 0, "fighter"),
(21468, 21468, "Alpen Kookaburra", 0, "", 0, "Monster2.rough_ostrich", 10, 33, 65, "male", "L2FeedableBeast", 40, 3465, 1319, 47.4, 2.78, 40, 43, 30, 21, 20, 10, 6457, 600, 1433, 314, 619, 340, 278, 150, 333, 0, 0, 0, 25, 231, "pet_clan", 300, 0, 0, "LAST_HIT", 0, 0, 0, "fighter"),
(21469, 21469, "Alpen Kookaburra", 0, "", 0, "Monster2.rough_ostrich", 10, 33, 65, "male", "L2FeedableBeast", 40, 3465, 1319, 47.4, 2.78, 40, 43, 30, 21, 20, 10, 6159, 572, 1433, 314, 619, 340, 278, 150, 333, 0, 0, 0, 25, 231, "pet_clan", 300, 0, 0, "LAST_HIT", 0, 0, 0, "fighter"),
(21470, 21470, "Alpen Buffalo", 0, "", 0, "Monster2.baby_buffalo", 12, 15, 67, "male", "L2FeedableBeast", 40, 3626, 1388, 5.93, 2.78, 40, 43, 30, 21, 20, 10, 5875, 560, 1169, 439, 681, 356, 278, 0, 333, 0, 0, 0, 33, 121, "pet_clan", 300, 0, 0, "LAST_HIT", 0, 0, 0, "fighter"),
(21471, 21471, "Alpen Buffalo", 0, "", 0, "Monster2.baby_buffalo", 12, 15, 67, "male", "L2FeedableBeast", 40, 3626, 1388, 11.85, 2.78, 40, 43, 30, 21, 20, 10, 7769, 740, 966, 531, 681, 356, 278, 0, 333, 0, 0, 0, 33, 143, "pet_clan", 300, 0, 0, "LAST_HIT", 0, 0, 0, "balanced"),
(21472, 21472, "Alpen Buffalo", 0, "", 0, "Monster2.baby_buffalo", 12, 15, 67, "male", "L2FeedableBeast", 40, 3626, 1388, 11.85, 2.78, 40, 43, 30, 21, 20, 10, 6528, 622, 966, 531, 681, 356, 278, 0, 333, 0, 0, 0, 33, 143, "pet_clan", 300, 0, 0, "LAST_HIT", 0, 0, 0, "balanced"),
(21473, 21473, "Alpen Buffalo", 0, "", 0, "Monster2.baby_buffalo", 12, 15, 67, "male", "L2FeedableBeast", 40, 3626, 1388, 11.85, 2.78, 40, 43, 30, 21, 20, 10, 7769, 740, 966, 531, 681, 356, 278, 0, 333, 0, 0, 0, 33, 143, "pet_clan", 300, 0, 0, "LAST_HIT", 0, 0, 0, "balanced"),
(21474, 21474, "Alpen Buffalo", 0, "", 0, "Monster2.baby_buffalo", 12, 15, 67, "male", "L2FeedableBeast", 40, 3626, 1388, 11.85, 2.78, 40, 43, 30, 21, 20, 10, 6528, 622, 966, 531, 681, 356, 278, 0, 333, 0, 0, 0, 33, 143, "pet_clan", 300, 0, 0, "LAST_HIT", 0, 0, 0, "balanced"),
(21475, 21475, "Alpen Buffalo", 0, "", 0, "Monster2.baby_buffalo", 12, 15, 67, "male", "L2FeedableBeast", 40, 3626, 1388, 11.85, 2.78, 40, 43, 30, 21, 20, 10, 7769, 740, 966, 531, 681, 356, 278, 0, 333, 0, 0, 0, 33, 143, "pet_clan", 300, 0, 0, "LAST_HIT", 0, 0, 0, "balanced"),
(21476, 21476, "Alpen Buffalo", 0, "", 0, "Monster2.baby_buffalo", 12, 15, 67, "male", "L2FeedableBeast", 40, 3626, 1388, 11.85, 2.78, 40, 43, 30, 21, 20, 10, 6528, 622, 966, 531, 681, 356, 278, 0, 333, 0, 0, 0, 33, 143, "pet_clan", 300, 0, 0, "LAST_HIT", 0, 0, 0, "balanced"),
(21477, 21477, "Alpen Buffalo", 0, "", 0, "Monster2.baby_buffalo", 12, 15, 67, "male", "L2FeedableBeast", 40, 3626, 1388, 11.85, 2.78, 40, 43, 30, 21, 20, 10, 7769, 740, 966, 531, 681, 356, 278, 0, 333, 0, 0, 0, 33, 143, "pet_clan", 300, 0, 0, "LAST_HIT", 0, 0, 0, "balanced"),
(21478, 21478, "Alpen Buffalo", 0, "", 0, "Monster2.baby_buffalo", 12, 15, 67, "male", "L2FeedableBeast", 40, 3626, 1388, 11.85, 2.78, 40, 43, 30, 21, 20, 10, 6528, 622, 966, 531, 681, 356, 278, 0, 333, 0, 0, 0, 33, 143, "pet_clan", 300, 0, 0, "LAST_HIT", 0, 0, 0, "balanced"),
(21479, 21479, "Alpen Buffalo", 0, "", 0, "Monster2.youth_buffalo", 16, 25.2, 67, "male", "L2FeedableBeast", 40, 3626, 1388, 23.7, 2.78, 40, 43, 30, 21, 20, 10, 8139, 775, 1624, 439, 681, 356, 200, 150, 333, 0, 0, 0, 22, 187, "pet_clan", 300, 0, 0, "LAST_HIT", 0, 0, 0, "fighter"),
(21480, 21480, "Alpen Buffalo", 0, "", 0, "Monster2.youth_buffalo", 16, 25.2, 67, "male", "L2FeedableBeast", 40, 3626, 1388, 23.7, 2.78, 40, 43, 30, 21, 20, 10, 8460, 806, 1624, 439, 681, 356, 200, 150, 333, 0, 0, 0, 22, 187, "pet_clan", 300, 0, 0, "LAST_HIT", 0, 0, 0, "fighter"),
(21481, 21481, "Alpen Buffalo", 0, "", 0, "Monster2.youth_buffalo", 16, 25.2, 67, "male", "L2FeedableBeast", 40, 3626, 1388, 23.7, 2.78, 40, 43, 30, 21, 20, 10, 8139, 775, 1624, 439, 681, 356, 200, 150, 333, 0, 0, 0, 22, 187, "pet_clan", 300, 0, 0, "LAST_HIT", 0, 0, 0, "fighter"),
(21482, 21482, "Alpen Buffalo", 0, "", 0, "Monster2.youth_buffalo", 16, 25.2, 67, "male", "L2FeedableBeast", 40, 3626, 1388, 23.7, 2.78, 40, 43, 30, 21, 20, 10, 7828, 745, 1624, 439, 681, 356, 200, 150, 333, 0, 0, 0, 22, 187, "pet_clan", 300, 0, 0, "LAST_HIT", 0, 0, 0, "fighter"),
(21483, 21483, "Alpen Buffalo", 0, "", 0, "Monster2.youth_buffalo", 16, 25.2, 67, "male", "L2FeedableBeast", 40, 3626, 1388, 23.7, 2.78, 40, 43, 30, 21, 20, 10, 8139, 775, 1624, 439, 681, 356, 200, 150, 333, 0, 0, 0, 22, 187, "pet_clan", 300, 0, 0, "LAST_HIT", 0, 0, 0, "fighter"),
(21484, 21484, "Alpen Buffalo", 0, "", 0, "Monster2.youth_buffalo", 16, 25.2, 67, "male", "L2FeedableBeast", 40, 3626, 1388, 23.7, 2.78, 40, 43, 30, 21, 20, 10, 8460, 806, 1624, 439, 681, 356, 200, 150, 333, 0, 0, 0, 22, 187, "pet_clan", 300, 0, 0, "LAST_HIT", 0, 0, 0, "fighter"),
(21485, 21485, "Alpen Buffalo", 0, "", 0, "Monster2.youth_buffalo", 16, 25.2, 67, "male", "L2FeedableBeast", 40, 3626, 1388, 23.7, 2.78, 40, 43, 30, 21, 20, 10, 8139, 775, 1624, 439, 681, 356, 200, 150, 333, 0, 0, 0, 22, 187, "pet_clan", 300, 0, 0, "LAST_HIT", 0, 0, 0, "fighter"),
(21486, 21486, "Alpen Buffalo", 0, "", 0, "Monster2.youth_buffalo", 16, 25.2, 67, "male", "L2FeedableBeast", 40, 3626, 1388, 23.7, 2.78, 40, 43, 30, 21, 20, 10, 7828, 745, 1624, 439, 681, 356, 200, 150, 333, 0, 0, 0, 22, 187, "pet_clan", 300, 0, 0, "LAST_HIT", 0, 0, 0, "fighter"),
(21487, 21487, "Alpen Buffalo", 0, "", 0, "Monster2.buffalo", 22, 31, 67, "male", "L2FeedableBeast", 40, 3626, 1388, 47.4, 2.78, 40, 43, 30, 21, 20, 10, 6861, 653, 2162, 329, 681, 356, 200, 150, 333, 0, 0, 0, 22, 187, "pet_clan", 300, 0, 0, "LAST_HIT", 0, 0, 0, "fighter"),
(21488, 21488, "Alpen Buffalo", 0, "", 0, "Monster2.buffalo", 22, 31, 67, "male", "L2FeedableBeast", 40, 3626, 1388, 47.4, 2.78, 40, 43, 30, 21, 20, 10, 6544, 623, 2162, 329, 681, 356, 200, 150, 333, 0, 0, 0, 22, 187, "pet_clan", 300, 0, 0, "LAST_HIT", 0, 0, 0, "fighter"),
(21489, 21489, "Alpen Cougar", 0, "", 0, "Monster2.baby_tiger", 11, 15.7, 69, "male", "L2FeedableBeast", 40, 3784, 1458, 5.93, 2.78, 40, 43, 30, 21, 20, 10, 6231, 610, 1265, 460, 746, 373, 278, 0, 333, 0, 0, 0, 30, 121, "pet_clan", 300, 0, 0, "LAST_HIT", 0, 0, 0, "fighter"),
(21490, 21490, "Alpen Cougar", 0, "", 0, "Monster2.baby_tiger", 11, 15.7, 69, "male", "L2FeedableBeast", 40, 3784, 1458, 11.85, 2.78, 40, 43, 30, 21, 20, 10, 8240, 806, 1045, 556, 746, 373, 278, 0, 333, 0, 0, 0, 30, 143, "pet_clan", 300, 0, 0, "LAST_HIT", 0, 0, 0, "balanced"),
(21491, 21491, "Alpen Cougar", 0, "", 0, "Monster2.baby_tiger", 11, 15.7, 69, "male", "L2FeedableBeast", 40, 3784, 1458, 11.85, 2.78, 40, 43, 30, 21, 20, 10, 6924, 678, 1045, 556, 746, 373, 278, 0, 333, 0, 0, 0, 30, 143, "pet_clan", 300, 0, 0, "LAST_HIT", 0, 0, 0, "balanced"),
(21492, 21492, "Alpen Cougar", 0, "", 0, "Monster2.baby_tiger", 11, 15.7, 69, "male", "L2FeedableBeast", 40, 3784, 1458, 11.85, 2.78, 40, 43, 30, 21, 20, 10, 8240, 806, 1045, 556, 746, 373, 278, 0, 333, 0, 0, 0, 30, 143, "pet_clan", 300, 0, 0, "LAST_HIT", 0, 0, 0, "balanced"),
(21493, 21493, "Alpen Cougar", 0, "", 0, "Monster2.baby_tiger", 11, 15.7, 69, "male", "L2FeedableBeast", 40, 3784, 1458, 11.85, 2.78, 40, 43, 30, 21, 20, 10, 6924, 678, 1045, 556, 746, 373, 278, 0, 333, 0, 0, 0, 30, 143, "pet_clan", 300, 0, 0, "LAST_HIT", 0, 0, 0, "balanced"),
(21494, 21494, "Alpen Cougar", 0, "", 0, "Monster2.baby_tiger", 11, 15.7, 69, "male", "L2FeedableBeast", 40, 3784, 1458, 11.85, 2.78, 40, 43, 30, 21, 20, 10, 8240, 806, 1045, 556, 746, 373, 278, 0, 333, 0, 0, 0, 30, 143, "pet_clan", 300, 0, 0, "LAST_HIT", 0, 0, 0, "balanced"),
(21495, 21495, "Alpen Cougar", 0, "", 0, "Monster2.baby_tiger", 11, 15.7, 69, "male", "L2FeedableBeast", 40, 3784, 1458, 11.85, 2.78, 40, 43, 30, 21, 20, 10, 6924, 678, 1045, 556, 746, 373, 278, 0, 333, 0, 0, 0, 30, 143, "pet_clan", 300, 0, 0, "LAST_HIT", 0, 0, 0, "balanced"),
(21496, 21496, "Alpen Cougar", 0, "", 0, "Monster2.baby_tiger", 11, 15.7, 69, "male", "L2FeedableBeast", 40, 3784, 1458, 11.85, 2.78, 40, 43, 30, 21, 20, 10, 8240, 806, 1045, 556, 746, 373, 278, 0, 333, 0, 0, 0, 30, 143, "pet_clan", 300, 0, 0, "LAST_HIT", 0, 0, 0, "balanced"),
(21497, 21497, "Alpen Cougar", 0, "", 0, "Monster2.baby_tiger", 11, 15.7, 69, "male", "L2FeedableBeast", 40, 3784, 1458, 11.85, 2.78, 40, 43, 30, 21, 20, 10, 6924, 678, 1045, 556, 746, 373, 278, 0, 333, 0, 0, 0, 30, 143, "pet_clan", 300, 0, 0, "LAST_HIT", 0, 0, 0, "balanced"),
(21498, 21498, "Alpen Cougar", 0, "", 0, "Monster2.youth_tiger", 16, 17.2, 69, "male", "L2FeedableBeast", 40, 3784, 1458, 23.7, 2.78, 40, 43, 30, 21, 20, 10, 8632, 844, 1265, 460, 746, 373, 278, 150, 333, 0, 0, 0, 66, 192, "pet_clan", 300, 0, 0, "LAST_HIT", 0, 0, 0, "fighter"),
(21499, 21499, "Alpen Cougar", 0, "", 0, "Monster2.youth_tiger", 16, 17.2, 69, "male", "L2FeedableBeast", 40, 3784, 1458, 23.7, 2.78, 40, 43, 30, 21, 20, 10, 8973, 878, 1265, 460, 746, 373, 278, 150, 333, 0, 0, 0, 66, 192, "pet_clan", 300, 0, 0, "LAST_HIT", 0, 0, 0, "fighter"),
(21500, 21500, "Alpen Cougar", 0, "", 0, "Monster2.youth_tiger", 16, 17.2, 69, "male", "L2FeedableBeast", 40, 3784, 1458, 23.7, 2.78, 40, 43, 30, 21, 20, 10, 8632, 844, 1265, 460, 746, 373, 278, 150, 333, 0, 0, 0, 66, 192, "pet_clan", 300, 0, 0, "LAST_HIT", 0, 0, 0, "fighter"),
(21501, 21501, "Alpen Cougar", 0, "", 0, "Monster2.youth_tiger", 16, 17.2, 69, "male", "L2FeedableBeast", 40, 3784, 1458, 23.7, 2.78, 40, 43, 30, 21, 20, 10, 8302, 812, 1265, 460, 746, 373, 278, 150, 333, 0, 0, 0, 66, 192, "pet_clan", 300, 0, 0, "LAST_HIT", 0, 0, 0, "fighter"),
(21502, 21502, "Alpen Cougar", 0, "", 0, "Monster2.youth_tiger", 16, 17.2, 69, "male", "L2FeedableBeast", 40, 3784, 1458, 23.7, 2.78, 40, 43, 30, 21, 20, 10, 8632, 844, 1265, 460, 746, 373, 278, 150, 333, 0, 0, 0, 66, 192, "pet_clan", 300, 0, 0, "LAST_HIT", 0, 0, 0, "fighter"),
(21503, 21503, "Alpen Cougar", 0, "", 0, "Monster2.youth_tiger", 16, 17.2, 69, "male", "L2FeedableBeast", 40, 3784, 1458, 23.7, 2.78, 40, 43, 30, 21, 20, 10, 8973, 878, 1265, 460, 746, 373, 278, 150, 333, 0, 0, 0, 66, 192, "pet_clan", 300, 0, 0, "LAST_HIT", 0, 0, 0, "fighter"),
(21504, 21504, "Alpen Cougar", 0, "", 0, "Monster2.youth_tiger", 16, 17.2, 69, "male", "L2FeedableBeast", 40, 3784, 1458, 23.7, 2.78, 40, 43, 30, 21, 20, 10, 8632, 844, 1265, 460, 746, 373, 278, 150, 333, 0, 0, 0, 66, 192, "pet_clan", 300, 0, 0, "LAST_HIT", 0, 0, 0, "fighter"),
(21505, 21505, "Alpen Cougar", 0, "", 0, "Monster2.youth_tiger", 16, 17.2, 69, "male", "L2FeedableBeast", 40, 3784, 1458, 23.7, 2.78, 40, 43, 30, 21, 20, 10, 8302, 812, 1265, 460, 746, 373, 278, 150, 333, 0, 0, 0, 66, 192, "pet_clan", 300, 0, 0, "LAST_HIT", 0, 0, 0, "fighter"),
(21506, 21506, "Alpen Cougar", 0, "", 0, "Monster.saber_toothed_tiger", 34, 28, 69, "male", "L2FeedableBeast", 40, 3784, 1458, 47.4, 2.78, 40, 43, 30, 21, 20, 10, 7276, 712, 1684, 345, 746, 373, 278, 150, 333, 0, 0, 0, 66, 220, "pet_clan", 300, 0, 0, "LAST_HIT", 0, 0, 0, "fighter"),
(21507, 21507, "Alpen Cougar", 0, "", 0, "Monster.saber_toothed_tiger", 34, 28, 69, "male", "L2FeedableBeast", 40, 3784, 1458, 47.4, 2.78, 40, 43, 30, 21, 20, 10, 6941, 679, 1684, 345, 746, 373, 278, 150, 333, 0, 0, 0, 66, 220, "pet_clan", 300, 0, 0, "LAST_HIT", 0, 0, 0, "fighter"),
(21508, 21508, "Splinter Stakato", 0, "", 0, "Monster.blade_stakato", 15, 36, 66, "male", "L2Monster", 40, 3546, 1353, 11.85, 2.78, 40, 43, 30, 21, 20, 10, 8452, 796, 1123, 364, 649, 348, 278, 150, 333, 235, 0, 0, 27, 192, "stakato_clan", 300, 0, 0, "LAST_HIT", 100, 0, 20, "fighter"),
(21509, 21509, "Splinter Stakato Walker", 0, "", 0, "Monster.blade_stakato_worker", 13, 40, 67, "male", "L2Monster", 40, 3626, 1388, 11.85, 2.78, 40, 43, 30, 21, 20, 10, 7445, 709, 1286, 339, 681, 356, 278, 150, 333, 0, 0, 0, 27, 198, "stakato_clan", 300, 0, 0, "LAST_HIT", 100, 0, 20, "fighter"),
(21510, 21510, "Splinter Stakato Soldier", 0, "", 0, "Monster.blade_stakato_soldier", 15, 38, 68, "male", "L2Monster", 40, 3706, 1423, 11.85, 2.78, 40, 43, 30, 21, 20, 10, 8972, 867, 1473, 371, 713, 365, 278, 150, 333, 148, 0, 0, 27, 198, "stakato_clan", 300, 0, 0, "LAST_HIT", 100, 0, 30, "fighter"),
(21511, 21511, "Splinter Stakato Drone", 0, "", 0, "Monster.blade_stakato_drone", 15, 39, 69, "male", "L2Monster", 40, 3784, 1458, 11.85, 2.78, 40, 43, 30, 21, 20, 10, 9944, 973, 1265, 460, 746, 373, 278, 150, 333, 132, 0, 0, 27, 203, "stakato_clan", 300, 0, 0, "LAST_HIT", 300, 0, 30, "fighter"),
(21512, 21512, "Splinter Stakato Drone", 0, "", 0, "Monster.blade_stakato_drone", 15, 39, 70, "male", "L2Monster", 40, 3862, 1493, 11.85, 2.78, 40, 43, 30, 21, 20, 10, 12636, 1253, 1086, 569, 780, 382, 278, 0, 333, 132, 0, 0, 27, 203, "stakato_clan", 300, 0, 0, "LAST_HIT", 0, 0, 0, "balanced"),
(21513, 21513, "Needle Stakato", 0, "", 0, "Monster.blade_stakato", 15, 36, 70, "male", "L2Monster", 40, 3862, 1493, 11.85, 2.78, 40, 43, 30, 21, 20, 10, 9507, 943, 1314, 399, 780, 382, 278, 150, 333, 235, 0, 0, 27, 203, "stakato_clan", 300, 0, 0, "LAST_HIT", 200, 0, 30, "fighter"),
(21514, 21514, "Needle Stakato Walker", 0, "", 0, "Monster.blade_stakato_worker", 13, 40, 71, "male", "L2Monster", 40, 3938, 1529, 13.43, 3.09, 40, 43, 30, 21, 20, 10, 8360, 839, 1499, 371, 814, 390, 278, 150, 333, 0, 0, 0, 27, 209, "stakato_clan", 300, 0, 0, "LAST_HIT", 200, 0, 30, "fighter"),
(21515, 21515, "Needle Stakato Soldier", 0, "", 0, "Monster.blade_stakato_soldier", 15, 38, 72, "male", "L2Monster", 40, 4013, 1565, 13.43, 3.09, 40, 43, 30, 21, 20, 10, 10059, 1022, 1710, 406, 849, 399, 278, 150, 333, 148, 0, 0, 27, 209, "stakato_clan", 300, 0, 0, "LAST_HIT", 100, 0, 30, "fighter"),
(21516, 21516, "Needle Stakato Drone", 0, "", 0, "Monster.blade_stakato_drone", 15, 39, 73, "male", "L2Monster", 40, 4086, 1601, 13.43, 3.09, 40, 43, 30, 21, 20, 10, 10340, 1064, 1463, 502, 885, 407, 278, 150, 333, 132, 0, 0, 27, 214, "stakato_clan", 300, 0, 0, "LAST_HIT", 300, 0, 30, "fighter"),
(21517, 21517, "Needle Stakato Drone", 0, "", 0, "Monster.blade_stakato_drone", 15, 39, 74, "male", "L2Monster", 40, 4158, 1637, 13.43, 3.09, 40, 43, 30, 21, 20, 10, 14121, 1472, 1250, 620, 921, 416, 278, 0, 333, 132, 0, 0, 27, 214, "stakato_clan", 300, 0, 0, "LAST_HIT", 0, 0, 0, "balanced"),
(21518, 21518, "Frenzy Stakato Soldier", 0, "", 0, "Monster.blade_stakato_soldier", 15, 38, 68, "male", "L2Monster", 40, 3706, 1423, 11.85, 2.78, 40, 43, 30, 21, 20, 10, 8002, 773, 1417, 337, 713, 365, 317, 0, 333, 235, 0, 0, 27, 203, "stakato_clan", 300, 0, 0, "LAST_HIT", 200, 0, 30, "fighter"),
(21519, 21519, "Frenzy Stakato Drone", 0, "", 0, "Monster.blade_stakato_drone", 15, 39, 72, "male", "L2Monster", 40, 4013, 1565, 13.43, 3.09, 40, 43, 30, 21, 20, 10, 8972, 912, 1645, 369, 849, 399, 317, 0, 333, 235, 0, 0, 27, 214, "stakato_clan", 300, 0, 0, "LAST_HIT", 200, 0, 30, "fighter"),
(21520, 21520, "Eye of Splendor", 0, "", 0, "Monster.kel_mahum", 13, 26, 60, "male", "L2Monster", 40, 3054, 1150, 10.27, 2.45, 40, 43, 30, 21, 20, 10, 7466, 648, 860, 368, 478, 299, 278, 0, 366, 326, 0, 0, 50, 160, "saint_clan", 300, 0, 0, "LAST_HIT", 0, 0, 0, "fighter"),
(21521, 21521, "Claws of Splendor", 0, "", 0, "Monster.kel_mahum_warrior", 13, 28, 60, "male", "L2Monster", 40, 3054, 1150, 10.27, 2.45, 40, 43, 30, 21, 20, 10, 7340, 637, 711, 446, 478, 299, 278, 0, 366, 326, 0, 0, 50, 160, "saint_clan", 300, 0, 0, "LAST_HIT", 0, 0, 0, "balanced"),
(21522, 21522, "Claws of Splendor", 0, "", 0, "Monster.dark_fencer", 7, 13, 60, "male", "L2Monster", 40, 3054, 1150, 10.27, 2.45, 40, 43, 30, 21, 20, 10, 8748, 759, 1041, 259, 478, 299, 278, 0, 333, 0, 0, 0, 27, 170, "saint_clan", 300, 0, 0, "LAST_HIT", 0, 0, 0, "fighter"),
(21523, 21523, "Flash of Splendor", 0, "", 0, "Monster.kel_mahum_witch_doctor", 13, 25, 61, "male", "L2Monster", 40, 3137, 1184, 11.85, 2.78, 40, 43, 30, 21, 20, 10, 7529, 663, 901, 378, 505, 307, 278, 150, 366, 326, 0, 0, 50, 150, "saint_clan", 300, 0, 0, "LAST_HIT", 0, 0, 0, "mage"),
(21524, 21524, "Blade of Splendor", 0, "", 0, "Monster.kel_mahum", 13, 26, 61, "male", "L2Monster", 40, 3137, 1184, 11.85, 2.78, 40, 43, 30, 21, 20, 10, 8028, 707, 1200, 284, 505, 307, 278, 0, 333, 242, 0, 0, 50, 165, "saint_clan", 300, 0, 0, "LAST_HIT", 0, 0, 0, "fighter"),
(21525, 21525, "Blade of Splendor", 0, "", 0, "Monster.kel_mahum", 13, 26, 61, "male", "L2Monster", 40, 3137, 1184, 11.85, 2.78, 40, 43, 30, 21, 20, 10, 8028, 707, 901, 378, 505, 307, 278, 0, 333, 242, 0, 0, 50, 165, "saint_clan", 300, 0, 0, "LAST_HIT", 0, 0, 0, "fighter"),
(21526, 21526, "Wisdom of Splendor", 0, "", 0, "Monster.kel_mahum_warrior", 13, 28, 62, "male", "L2Monster", 40, 3219, 1217, 11.85, 2.78, 40, 43, 30, 21, 20, 10, 9220, 822, 944, 388, 532, 315, 278, 150, 366, 193, 0, 0, 50, 160, "saint_clan", 300, 0, 0, "LAST_HIT", 0, 0, 0, "fighter"),
(21527, 21527, "Anger of Splendor", 0, "", 0, "Monster.kel_mahum_champion", 13, 32, 63, "male", "L2Monster", 40, 3302, 1251, 11.85, 2.78, 40, 43, 30, 21, 20, 10, 8132, 734, 987, 398, 560, 323, 278, 0, 476, 193, 0, 0, 50, 150, "saint_clan", 300, 0, 0, "LAST_HIT", 0, 0, 0, "fighter"),
(21528, 21528, "Anger of Splendor", 0, "", 0, "Monster.dark_fencer", 7, 13, 63, "male", "L2Monster", 40, 3302, 1251, 11.85, 2.78, 40, 43, 30, 21, 20, 10, 9645, 871, 987, 398, 560, 323, 278, 0, 333, 0, 0, 0, 27, 170, "saint_clan", 300, 0, 0, "LAST_HIT", 0, 0, 0, "fighter"),
(21529, 21529, "Soul of Splendor", 0, "", 0, "Monster.kel_mahum_witch_doctor", 13, 25, 63, "male", "L2Monster", 40, 3302, 1251, 11.85, 2.78, 40, 43, 30, 21, 20, 10, 7377, 666, 987, 398, 560, 323, 278, 150, 366, 193, 0, 0, 50, 160, "saint_clan", 300, 0, 0, "LAST_HIT", 0, 0, 0, "mage"),
(21530, 21530, "Victory of Splendor", 0, "", 0, "Monster.kel_mahum", 13, 26, 64, "male", "L2Monster", 40, 3384, 1285, 11.85, 2.78, 40, 43, 30, 21, 20, 10, 8006, 733, 1031, 408, 589, 331, 278, 0, 366, 196, 0, 0, 50, 160, "saint_clan", 300, 0, 0, "LAST_HIT", 0, 0, 0, "fighter"),
(21531, 21531, "Punishment of Splendor", 0, "", 0, "Monster.kel_mahum_warrior", 13, 28, 64, "male", "L2Monster", 40, 3384, 1285, 11.85, 2.78, 40, 43, 30, 21, 20, 10, 8837, 809, 1373, 306, 589, 331, 278, 0, 333, 242, 0, 0, 50, 165, "saint_clan", 300, 0, 0, "LAST_HIT", 0, 0, 0, "fighter"),
(21532, 21532, "Shout of Splendor", 0, "", 0, "Monster.kel_mahum_champion", 13, 32, 65, "male", "L2Monster", 40, 3465, 1319, 11.85, 2.78, 40, 43, 30, 21, 20, 10, 9456, 879, 1077, 418, 619, 340, 278, 150, 476, 196, 0, 0, 50, 150, "saint_clan", 300, 0, 0, "LAST_HIT", 0, 0, 0, "fighter"),
(21533, 21533, "Alliance of Splendor", 0, "", 0, "Monster.kel_mahum_witch_doctor", 13, 25, 65, "male", "L2Monster", 40, 3465, 1319, 11.85, 2.78, 40, 43, 30, 21, 20, 10, 7767, 722, 890, 430, 619, 340, 278, 0, 366, 196, 0, 0, 50, 160, "saint_clan", 300, 0, 0, "LAST_HIT", 0, 0, 0, "mage"),
(21534, 21534, "Alliance of Splendor", 0, "", 0, "Monster.dark_fencer", 7, 13, 65, "male", "L2Monster", 40, 3465, 1319, 11.85, 2.78, 40, 43, 30, 21, 20, 10, 10267, 954, 1303, 346, 619, 340, 278, 0, 333, 0, 0, 0, 25, 155, "saint_clan", 300, 0, 0, "LAST_HIT", 0, 0, 0, "fighter"),
(21535, 21535, "Signet of Splendor", 0, "", 0, "Monster.kel_mahum_warrior", 13, 28, 66, "male", "L2Monster", 40, 3546, 1353, 11.85, 2.78, 40, 43, 30, 21, 20, 10, 9331, 878, 1123, 428, 649, 348, 278, 150, 333, 189, 0, 0, 55, 176, "saint_clan", 300, 0, 0, "LAST_HIT", 0, 0, 0, "fighter"),
(21536, 21536, "Crown of Splendor", 0, "", 0, "Monster.kel_mahum_champion", 13, 32, 66, "male", "L2Monster", 40, 3546, 1353, 11.85, 2.78, 40, 43, 30, 21, 20, 10, 9487, 893, 1123, 428, 649, 348, 278, 0, 333, 189, 0, 0, 55, 181, "saint_clan", 300, 0, 0, "LAST_HIT", 0, 0, 0, "fighter"),
(21537, 21537, "Fang of Splendor", 0, "", 0, "Monster.kel_mahum_witch_doctor", 13, 25, 67, "male", "L2Monster", 40, 3626, 1388, 11.85, 2.78, 40, 43, 30, 21, 20, 10, 8905, 848, 966, 451, 681, 356, 278, 0, 333, 189, 0, 0, 55, 170, "saint_clan", 300, 0, 0, "LAST_HIT", 0, 0, 0, "mage"),
(21538, 21538, "Fang of Splendor", 0, "", 0, "Monster.dark_fencer", 7, 13, 67, "male", "L2Monster", 40, 3626, 1388, 11.85, 2.78, 40, 43, 30, 21, 20, 10, 10908, 1039, 1415, 362, 681, 356, 278, 0, 333, 0, 0, 0, 27, 170, "saint_clan", 300, 0, 0, "LAST_HIT", 0, 0, 0, "fighter"),
(21539, 21539, "Wailing of Splendor", 0, "", 0, "Monster.kel_mahum", 13, 26, 67, "male", "L2Monster", 40, 3626, 1388, 11.85, 2.78, 40, 43, 30, 21, 20, 10, 9685, 922, 1557, 329, 681, 356, 278, 0, 333, 242, 0, 0, 55, 187, "saint_clan", 300, 0, 0, "LAST_HIT", 0, 0, 0, "fighter"),
(21540, 21540, "Wailing of Splendor", 0, "", 0, "Monster.kel_mahum", 13, 26, 67, "male", "L2Monster", 40, 3626, 1388, 11.85, 2.78, 40, 43, 30, 21, 20, 10, 9685, 922, 1169, 439, 681, 356, 278, 0, 333, 242, 0, 0, 55, 187, "saint_clan", 300, 0, 0, "LAST_HIT", 0, 0, 0, "fighter"),
(21541, 21541, "Pilgrim of Splendor", 0, "", 0, "Monster.kel_mahum_witch_doctor", 13, 25, 63, "male", "L2Monster", 40, 3302, 1251, 11.85, 2.78, 40, 43, 30, 21, 20, 10, 9944, 898, 987, 338, 560, 323, 278, 150, 476, 315, 0, 0, 50, 165, "saint_clan", 300, 0, 0, "LAST_HIT", 0, 0, 0, "mage"),
(21542, 21542, "Disciple of Pilgrim", 0, "", 0, "Monster.kel_mahum_warrior", 13, 28, 62, "male", "L2Monster", 40, 3219, 1217, 11.85, 2.78, 40, 43, 30, 21, 20, 10, 6932, 618, 1038, 353, 532, 315, 278, 0, 476, 193, 0, 0, 50, 165, "saint_clan", 300, 0, 0, "LAST_HIT", 0, 0, 0, "fighter"),
(21543, 21543, "Page of Pilgrim", 0, "", 0, "Monster.kel_mahum", 13, 26, 62, "male", "L2Monster", 40, 3219, 1217, 11.85, 2.78, 40, 43, 30, 21, 20, 10, 7909, 705, 858, 427, 532, 315, 278, 0, 476, 326, 0, 0, 50, 165, "saint_clan", 300, 0, 0, "LAST_HIT", 0, 0, 0, "fighter"),
(21544, 21544, "Judge of Splendor", 0, "", 0, "Monster.kel_mahum_champion", 13, 32, 67, "male", "L2Monster", 40, 3626, 1388, 11.85, 2.78, 40, 43, 30, 21, 20, 10, 11331, 1079, 1169, 439, 681, 356, 300, 150, 512, 150, 0, 0, 50, 160, "saint_clan", 300, 0, 0, "LAST_HIT", 0, 0, 0, "fighter"),
(21545, 21545, "Judge of Fire", 0, "", 0, "Monster.kel_mahum_witch_doctor", 13, 25, 66, "male", "L2Monster", 40, 3546, 1353, 11.85, 2.78, 40, 43, 30, 21, 20, 10, 7855, 739, 1235, 331, 649, 348, 278, 0, 476, 189, 0, 0, 50, 165, "saint_clan", 300, 0, 0, "LAST_HIT", 0, 0, 0, "mage"),
(21546, 21546, "Judge of Light", 0, "", 0, "Monster.kel_mahum", 13, 26, 66, "male", "L2Monster", 40, 3546, 1353, 11.85, 2.78, 40, 43, 30, 21, 20, 10, 8963, 844, 1020, 471, 649, 348, 278, 0, 476, 196, 0, 0, 50, 165, "saint_clan", 300, 0, 0, "LAST_HIT", 0, 0, 0, "fighter"),
(21547, 21547, "Corrupted Knight", 0, "", 0, "Monster.skeleton_knight", 10, 25, 63, "male", "L2Monster", 40, 3302, 1251, 11.85, 2.78, 40, 43, 30, 21, 20, 10, 8116, 733, 987, 398, 560, 323, 278, 0, 333, 150, 103, 0, 40, 165, "necro_clan", 300, 1, 0, "LAST_HIT", 0, 0, 0, "fighter"),
(21548, 21548, "Resurrected Knight", 0, "", 0, "Monster.skeleton_knight", 10, 25, 63, "male", "L2Monster", 40, 3302, 1251, 11.85, 2.78, 40, 43, 30, 21, 20, 10, 7019, 634, 987, 398, 560, 323, 278, 0, 333, 150, 103, 0, 40, 165, "necro_clan", 300, 1, 0, "LAST_HIT", 0, 0, 0, "fighter"),
(21549, 21549, "Corrupted Guard", 0, "", 0, "Monster.skeleton_royal_guard", 11, 28.5, 64, "male", "L2Monster", 40, 3384, 1285, 11.85, 2.78, 40, 43, 30, 21, 20, 10, 8375, 767, 902, 408, 589, 331, 317, 0, 333, 946, 0, 0, 80, 175, "necro_clan", 300, 1, 0, "LAST_HIT", 0, 0, 0, "balanced"),
(21550, 21550, "Corrupted Guard", 0, "", 0, "Monster.skeleton_royal_guard", 11, 28.5, 64, "male", "L2Monster", 40, 3384, 1285, 11.85, 2.78, 40, 43, 30, 21, 20, 10, 8543, 782, 1201, 306, 589, 331, 317, 150, 333, 946, 945, 0, 80, 175, "necro_clan", 300, 1, 0, "LAST_HIT", 0, 0, 0, "fighter"),
(21551, 21551, "Resurrected Guard", 0, "", 0, "Monster.skeleton_royal_guard", 11, 28.5, 66, "male", "L2Monster", 40, 3546, 1353, 11.85, 2.78, 40, 43, 30, 21, 20, 10, 9541, 898, 982, 428, 649, 348, 317, 0, 333, 221, 0, 0, 80, 175, "necro_clan", 300, 1, 0, "LAST_HIT", 0, 0, 0, "balanced"),
(21552, 21552, "Resurrected Guard", 0, "", 0, "Monster.skeleton_royal_guard", 11, 28.5, 66, "male", "L2Monster", 40, 3546, 1353, 11.85, 2.78, 40, 43, 30, 21, 20, 10, 9085, 855, 1307, 322, 649, 348, 317, 150, 333, 221, 945, 0, 80, 175, "necro_clan", 300, 1, 0, "LAST_HIT", 0, 0, 0, "fighter"),
(21553, 21553, "Trampled Man", 0, "", 0, "Monster.zombie", 13, 21, 65, "male", "L2Monster", 40, 3465, 1319, 11.85, 2.78, 40, 43, 30, 21, 20, 10, 6267, 582, 1077, 355, 619, 340, 278, 0, 333, 0, 0, 0, 15, 40, "necro_clan", 300, 1, 0, "LAST_HIT", 0, 0, 0, "fighter"),
(21554, 21554, "Trampled Man", 0, "", 0, "Monster.zombie", 13, 21, 65, "male", "L2Monster", 40, 3465, 1319, 11.85, 2.78, 40, 43, 30, 21, 20, 10, 6267, 582, 1303, 294, 619, 340, 278, 0, 333, 0, 0, 0, 15, 40, "necro_clan", 300, 1, 0, "LAST_HIT", 0, 0, 0, "fighter"),
(21555, 21555, "Slaughter Executioner", 0, "", 0, "Monster.dark_horror", 20, 42, 65, "male", "L2Monster", 40, 3465, 1319, 11.85, 2.78, 40, 43, 30, 21, 20, 10, 7619, 708, 979, 391, 619, 340, 278, 0, 333, 0, 0, 0, 100, 160, "necro_clan", 300, 1, 0, "LAST_HIT", 0, 0, 0, "fighter"),
(21556, 21556, "Slaughter Executioner", 0, "", 0, "Monster.dark_horror", 20, 35, 65, "male", "L2Monster", 40, 3465, 1319, 11.85, 2.78, 40, 43, 30, 21, 20, 10, 7435, 691, 1077, 355, 619, 340, 278, 0, 333, 0, 0, 0, 110, 176, "necro_clan", 300, 1, 0, "LAST_HIT", 0, 0, 0, "fighter"),
(21557, 21557, "Bone Snatcher", 0, "", 0, "Monster2.black_magician", 8, 30, 66, "male", "L2Monster", 40, 3546, 1353, 11.85, 2.78, 40, 43, 30, 21, 20, 10, 8774, 826, 1123, 428, 649, 348, 278, 0, 333, 178, 0, 0, 19, 180, "necro_clan", 300, 0, 0, "LAST_HIT", 0, 0, 0, "fighter"),
(21558, 21558, "Bone Snatcher", 0, "", 0, "Monster2.black_magician", 8, 30, 66, "male", "L2Monster", 40, 3546, 1353, 11.85, 2.78, 40, 43, 30, 21, 20, 10, 8774, 826, 1123, 428, 649, 348, 278, 0, 333, 178, 0, 0, 19, 180, "necro_clan", 300, 0, 0, "LAST_HIT", 0, 0, 0, "fighter"),
(21559, 21559, "Bone Maker", 0, "", 0, "Monster2.black_magician", 8, 30, 66, "male", "L2Monster", 40, 3546, 1353, 11.85, 2.78, 40, 43, 30, 21, 20, 10, 9596, 903, 1020, 471, 649, 348, 278, 150, 333, 178, 0, 0, 19, 180, "necro_clan", 300, 0, 0, "LAST_HIT", 0, 0, 0, "fighter"),
(21560, 21560, "Bone Shaper", 0, "", 0, "Monster2.black_magician", 8, 30, 66, "male", "L2Monster", 40, 3546, 1353, 11.85, 2.78, 40, 43, 30, 21, 20, 10, 9596, 903, 1020, 471, 649, 348, 278, 150, 333, 178, 0, 0, 19, 180, "necro_clan", 300, 0, 0, "LAST_HIT", 0, 0, 0, "fighter"),
(21561, 21561, "Sacrificed Man", 0, "", 0, "Monster.zombie", 13, 21, 67, "male", "L2Monster", 40, 3626, 1388, 11.85, 2.78, 40, 43, 30, 21, 20, 10, 8057, 767, 1063, 410, 681, 356, 278, 150, 333, 0, 0, 0, 15, 40, "necro_clan", 300, 1, 0, "LAST_HIT", 0, 0, 0, "fighter"),
(21562, 21562, "Guillotine's Ghost", 0, "", 0, "Monster.liviona", 15, 28, 67, "male", "L2Monster", 40, 3626, 1388, 11.85, 2.78, 40, 43, 30, 21, 20, 10, 8344, 795, 1169, 373, 681, 356, 278, 150, 333, 0, 0, 0, 88, 165, "necro_clan", 300, 0, 0, "LAST_HIT", 0, 0, 0, "fighter"),
(21563, 21563, "Bone Collector", 0, "", 0, "Monster2.black_magician", 8, 30, 67, "male", "L2Monster", 40, 3626, 1388, 11.85, 2.78, 40, 43, 30, 21, 20, 10, 9695, 923, 1286, 399, 681, 356, 278, 0, 333, 178, 0, 0, 19, 180, "necro_clan", 300, 0, 0, "LAST_HIT", 0, 0, 0, "fighter"),
(21564, 21564, "Skull Collector", 0, "", 0, "Monster2.black_magician", 8, 30, 67, "male", "L2Monster", 40, 3626, 1388, 11.85, 2.78, 40, 43, 30, 21, 20, 10, 9223, 878, 1286, 399, 681, 356, 278, 150, 333, 178, 0, 0, 19, 180, "necro_clan", 300, 0, 0, "LAST_HIT", 0, 0, 0, "fighter"),
(21565, 21565, "Bone Animator", 0, "", 0, "Monster2.black_magician", 8, 30, 68, "male", "L2Monster", 40, 3706, 1423, 11.85, 2.78, 40, 43, 30, 21, 20, 10, 9314, 900, 1339, 408, 713, 365, 278, 0, 333, 178, 0, 0, 19, 180, "necro_clan", 300, 0, 0, "LAST_HIT", 0, 0, 0, "fighter"),
(21566, 21566, "Skull Animator", 0, "", 0, "Monster2.black_magician", 8, 30, 68, "male", "L2Monster", 40, 3706, 1423, 11.85, 2.78, 40, 43, 30, 21, 20, 10, 10186, 984, 1339, 408, 713, 365, 278, 150, 333, 178, 0, 0, 19, 180, "necro_clan", 300, 0, 0, "LAST_HIT", 0, 0, 0, "fighter"),
(21567, 21567, "Bone Slayer", 0, "", 0, "Monster2.black_magician", 8, 30, 68, "male", "L2Monster", 40, 3706, 1423, 11.85, 2.78, 40, 43, 30, 21, 20, 10, 12175, 1176, 1106, 494, 713, 365, 278, 150, 333, 178, 0, 0, 19, 180, "necro_clan", 300, 0, 0, "LAST_HIT", 0, 0, 0, "fighter"),
(21568, 21568, "Devil Bat", 0, "", 0, "Monster.vampire_bat", 10, 33.5, 68, "male", "L2Monster", 40, 3706, 1423, 11.85, 2.78, 40, 43, 30, 21, 20, 10, 10440, 1009, 1473, 315, 713, 365, 278, 150, 333, 0, 0, 0, 60, 170, "vampire_clan", 300, 0, 0, "LAST_HIT", 0, 0, 0, "fighter"),
(21569, 21569, "Devil Bat", 0, "", 0, "Monster.vampire_bat", 10, 33.5, 68, "male", "L2Monster", 40, 3706, 1423, 11.85, 2.78, 40, 43, 30, 21, 20, 10, 8108, 783, 1217, 382, 713, 365, 278, 150, 333, 0, 0, 0, 60, 170, "vampire_clan", 300, 0, 0, "LAST_HIT", 0, 0, 0, "fighter"),
(21570, 21570, "Ghost of Betrayer", 0, "", 0, "Monster.binding", 12, 21, 69, "male", "L2Monster", 40, 3784, 1458, 11.85, 2.78, 40, 43, 30, 21, 20, 10, 7557, 739, 1150, 506, 746, 373, 278, 150, 333, 0, 0, 0, 10, 174, "necro_clan", 300, 1, 0, "LAST_HIT", 0, 0, 0, "fighter"),
(21571, 21571, "Ghost of Rebellion Soldier", 0, "", 0, "Monster.skeleton_knight", 10, 25, 69, "male", "L2Monster", 40, 3784, 1458, 11.85, 2.78, 40, 43, 30, 21, 20, 10, 10718, 1049, 1265, 460, 746, 373, 278, 150, 333, 150, 103, 0, 40, 165, "necro_clan", 300, 1, 0, "LAST_HIT", 0, 0, 0, "fighter"),
(21572, 21572, "Bone Sweeper", 0, "", 0, "Monster2.black_magician", 8, 30, 69, "male", "L2Monster", 40, 3784, 1458, 11.85, 2.78, 40, 43, 30, 21, 20, 10, 10282, 1006, 1392, 418, 746, 373, 278, 0, 333, 178, 0, 0, 19, 185, "necro_clan", 300, 0, 0, "LAST_HIT", 0, 0, 0, "fighter"),
(21573, 21573, "Atrox", 0, "", 0, "Monster2.kailiharim", 45, 39, 69, "male", "L2Monster", 40, 3784, 1458, 11.85, 2.78, 40, 43, 30, 21, 20, 10, 11456, 1121, 2127, 380, 746, 373, 197, 150, 333, 0, 0, 0, 105, 185, "vampire_clan", 300, 0, 0, "LAST_HIT", 0, 0, 0, "fighter"),
(21574, 21574, "Bone Grinder", 0, "", 0, "Monster2.black_magician", 8, 30, 70, "male", "L2Monster", 40, 3862, 1493, 11.85, 2.78, 40, 43, 30, 21, 20, 10, 12902, 1279, 1194, 517, 780, 382, 278, 150, 333, 178, 0, 0, 19, 185, "necro_clan", 300, 0, 0, "LAST_HIT", 0, 0, 0, "balanced"),
(21575, 21575, "Bone Grinder", 0, "", 0, "Monster2.black_magician", 8, 30, 70, "male", "L2Monster", 40, 3862, 1493, 11.85, 2.78, 40, 43, 30, 21, 20, 10, 7269, 721, 1314, 470, 780, 382, 278, 150, 333, 178, 0, 0, 19, 185, "necro_clan", 300, 0, 0, "LAST_HIT", 0, 0, 0, "fighter"),
(21576, 21576, "Ghost of Guillotine ", 0, "", 0, "Monster.liviona", 15, 28, 70, "male", "L2Monster", 40, 3862, 1493, 11.85, 2.78, 40, 43, 30, 21, 20, 10, 9350, 927, 1590, 330, 780, 382, 278, 0, 333, 0, 0, 0, 80, 150, "vampire_clan", 300, 0, 0, "LAST_HIT", 0, 0, 0, "fighter"),
(21577, 21577, "Ghost of Guillotine ", 0, "", 0, "Monster.liviona", 15, 28, 70, "male", "L2Monster", 40, 3862, 1493, 11.85, 2.78, 40, 43, 30, 21, 20, 10, 8195, 813, 1314, 399, 780, 382, 278, 0, 333, 0, 0, 0, 80, 150, "vampire_clan", 300, 0, 0, "LAST_HIT", 0, 0, 0, "fighter"),
(21578, 21578, "Behemoth Zombie", 0, "", 0, "Monster2.giant_zombie", 13, 40, 71, "male", "L2Monster", 40, 3938, 1529, 13.43, 3.09, 40, 43, 30, 21, 20, 10, 10308, 1034, 1239, 529, 814, 390, 278, 0, 333, 0, 0, 0, 20, 90, "necro_clan", 300, 1, 0, "LAST_HIT", 0, 0, 0, "balanced"),
(21579, 21579, "Ghost of Rebellion Leader", 0, "", 0, "Monster.skeleton_royal_guard", 11, 28.5, 71, "male", "L2Monster", 40, 3938, 1529, 13.43, 3.09, 40, 43, 30, 21, 20, 10, 10843, 1088, 1193, 481, 814, 390, 317, 0, 333, 221, 945, 0, 80, 175, "necro_clan", 300, 1, 0, "LAST_HIT", 0, 0, 0, "balanced"),
(21580, 21580, "Bone Caster", 0, "", 0, "Monster2.black_magician", 8, 30, 71, "male", "L2Monster", 40, 3938, 1529, 13.43, 3.09, 40, 43, 30, 21, 20, 10, 10154, 1019, 1499, 437, 814, 390, 278, 0, 333, 178, 0, 0, 19, 185, "necro_clan", 300, 0, 0, "LAST_HIT", 0, 0, 0, "fighter"),
(21581, 21581, "Bone Puppeteer", 0, "", 0, "Monster2.black_magician", 8, 30, 71, "male", "L2Monster", 40, 3938, 1529, 13.43, 3.09, 40, 43, 30, 21, 20, 10, 11105, 1114, 1499, 437, 814, 390, 278, 150, 333, 178, 0, 0, 19, 185, "necro_clan", 300, 0, 0, "LAST_HIT", 0, 0, 0, "fighter"),
(21582, 21582, "Vampire Soldier", 0, "", 0, "Monster2.vampire_soldier", 8, 23.5, 71, "male", "L2Monster", 40, 3938, 1529, 13.43, 3.09, 40, 43, 30, 21, 20, 10, 11891, 1193, 1649, 397, 814, 390, 278, 0, 333, 234, 0, 0, 60, 190, "vampire_clan", 300, 0, 0, "LAST_HIT", 0, 0, 0, "fighter"),
(21583, 21583, "Bone Scavenger", 0, "", 0, "Monster2.black_magician", 8, 30, 72, "male", "L2Monster", 40, 4013, 1565, 13.43, 3.09, 40, 43, 30, 21, 20, 10, 11196, 1137, 1554, 446, 849, 399, 278, 0, 333, 178, 0, 0, 19, 185, "necro_clan", 300, 0, 0, "LAST_HIT", 0, 0, 0, "fighter"),
(21584, 21584, "Bone Scavenger", 0, "", 0, "Monster2.black_magician", 8, 30, 72, "male", "L2Monster", 40, 4013, 1565, 13.43, 3.09, 40, 43, 30, 21, 20, 10, 10442, 1061, 1284, 540, 849, 399, 278, 0, 333, 178, 0, 0, 19, 185, "necro_clan", 300, 0, 0, "LAST_HIT", 0, 0, 0, "balanced"),
(21585, 21585, "Vampire Magician", 0, "", 0, "Monster2.vampire_witch", 6, 21.5, 72, "female", "L2Monster", 40, 4013, 1565, 13.43, 3.09, 40, 43, 30, 21, 20, 10, 9628, 978, 1710, 406, 849, 399, 278, 150, 333, 946, 0, 0, 64, 180, "vampire_clan", 300, 0, 0, "LAST_HIT", 0, 0, 0, "mage"),
(21586, 21586, "Vampire Adept", 0, "", 0, "Monster2.vampire_wizard", 5.5, 28, 72, "female", "L2Monster", 40, 4013, 1565, 13.43, 3.09, 40, 43, 30, 21, 20, 10, 11374, 1156, 1710, 406, 849, 399, 278, 150, 333, 99, 0, 0, 46, 180, "vampire_clan", 300, 0, 0, "LAST_HIT", 0, 0, 0, "balanced"),
(21587, 21587, "Vampire Warrior", 0, "", 0, "Monster2.vampire_soldier_20_bi", 10, 29, 72, "male", "L2Monster", 40, 4013, 1565, 13.43, 3.09, 40, 43, 30, 21, 20, 10, 11852, 1204, 1710, 406, 849, 399, 278, 0, 333, 234, 0, 0, 60, 190, "vampire_clan", 300, 0, 0, "LAST_HIT", 0, 0, 0, "fighter"),
(21588, 21588, "Vampire Wizard", 0, "", 0, "Monster2.vampire_witch", 6, 21.5, 73, "female", "L2Monster", 40, 4086, 1601, 13.43, 3.09, 40, 43, 30, 21, 20, 10, 9936, 1022, 1947, 377, 885, 407, 278, 0, 333, 946, 0, 0, 64, 180, "vampire_clan", 300, 0, 0, "LAST_HIT", 0, 0, 0, "mage"),
(21589, 21589, "Vampire Wizard", 0, "", 0, "Monster2.vampire_witch", 6, 21.5, 73, "female", "L2Monster", 40, 4086, 1601, 13.43, 3.09, 40, 43, 30, 21, 20, 10, 10168, 1046, 1099, 668, 885, 407, 278, 0, 333, 946, 0, 0, 64, 180, "vampire_clan", 300, 0, 0, "LAST_HIT", 0, 0, 0, "mage"),
(21590, 21590, "Vampire Magister", 0, "", 0, "Monster2.vampire_wizard", 5.5, 28, 73, "female", "L2Monster", 40, 4086, 1601, 13.43, 3.09, 40, 43, 30, 21, 20, 10, 9936, 1022, 1770, 415, 885, 407, 278, 0, 333, 99, 0, 0, 46, 180, "vampire_clan", 300, 0, 0, "LAST_HIT", 0, 0, 0, "mage"),
(21591, 21591, "Vampire Magister", 0, "", 0, "Monster2.vampire_wizard", 5.5, 28, 73, "female", "L2Monster", 40, 4086, 1601, 13.43, 3.09, 40, 43, 30, 21, 20, 10, 11462, 1179, 1770, 415, 885, 407, 278, 0, 333, 99, 0, 0, 46, 180, "vampire_clan", 300, 0, 0, "LAST_HIT", 0, 0, 0, "mage"),
(21592, 21592, "Vampire Magister", 0, "", 0, "Monster2.vampire_wizard", 5.5, 28, 73, "female", "L2Monster", 40, 4086, 1601, 13.43, 3.09, 40, 43, 30, 21, 20, 10, 7750, 797, 1330, 552, 885, 407, 278, 0, 333, 99, 0, 0, 46, 180, "vampire_clan", 300, 0, 0, "LAST_HIT", 0, 0, 0, "mage"),
(21593, 21593, "Vampire Warlord", 0, "", 0, "Monster2.vampire_warrior", 9, 31.5, 73, "male", "L2Monster", 40, 4086, 1601, 13.43, 3.09, 40, 43, 30, 21, 20, 10, 13346, 1373, 2459, 415, 885, 407, 197, 0, 333, 6723, 0, 0, 43, 190, "vampire_clan", 300, 0, 0, "LAST_HIT", 0, 0, 0, "fighter"),
(21594, 21594, "Vampire Warlord", 0, "", 0, "Monster2.vampire_warrior", 9, 31.5, 73, "male", "L2Monster", 40, 4086, 1601, 13.43, 3.09, 40, 43, 30, 21, 20, 10, 12571, 1294, 2459, 415, 885, 407, 197, 0, 333, 6723, 0, 0, 43, 190, "vampire_clan", 300, 0, 0, "LAST_HIT", 0, 0, 0, "fighter"),
(21595, 21595, "Vampire Warlord", 0, "", 0, "Monster2.vampire_warrior", 9, 31.5, 73, "male", "L2Monster", 40, 4086, 1601, 13.43, 3.09, 40, 43, 30, 21, 20, 10, 9161, 943, 1847, 552, 885, 407, 197, 0, 333, 6723, 0, 0, 43, 190, "vampire_clan", 300, 0, 0, "LAST_HIT", 0, 0, 0, "fighter"),
(21596, 21596, "Requiem Lord", 0, "", 0, "Monster2.black_magician", 8, 30, 68, "male", "L2Monster", 40, 3706, 1423, 11.85, 2.78, 40, 43, 30, 21, 20, 10, 12038, 1163, 1106, 494, 713, 365, 278, 150, 333, 178, 0, 0, 19, 185, "necro_clan", 300, 0, 0, "LAST_HIT", 0, 0, 0, "fighter"),
(21597, 21597, "Requiem Behemoth", 0, "", 0, "Monster2.giant_zombie", 13, 40, 67, "male", "L2Monster", 40, 3626, 1388, 11.85, 2.78, 40, 43, 30, 21, 20, 10, 8265, 787, 1286, 399, 681, 356, 278, 0, 333, 0, 0, 0, 20, 100, "necro_clan", 300, 1, 0, "LAST_HIT", 0, 0, 0, "fighter"),
(21598, 21598, "Requiem Behemoth", 0, "", 0, "Monster2.giant_zombie", 13, 40, 67, "male", "L2Monster", 40, 3626, 1388, 11.85, 2.78, 40, 43, 30, 21, 20, 10, 9179, 874, 1286, 399, 681, 356, 278, 0, 333, 0, 0, 0, 20, 100, "necro_clan", 300, 1, 0, "LAST_HIT", 0, 0, 0, "fighter"),
(21599, 21599, "Requiem Priest", 0, "", 0, "Monster2.black_magician", 8, 30, 71, "male", "L2Monster", 40, 3938, 1529, 13.43, 3.09, 40, 43, 30, 21, 20, 10, 12750, 1279, 1239, 529, 814, 390, 278, 150, 333, 178, 0, 0, 19, 185, "necro_clan", 300, 0, 0, "LAST_HIT", 0, 0, 0, "balanced"),
(21600, 21600, "Requiem Behemoth", 0, "", 0, "Monster2.giant_zombie", 13, 40, 70, "male", "L2Monster", 40, 3862, 1493, 11.85, 2.78, 40, 43, 30, 21, 20, 10, 9022, 895, 1445, 427, 780, 382, 278, 0, 333, 0, 0, 0, 20, 100, "necro_clan", 300, 1, 0, "LAST_HIT", 0, 0, 0, "fighter"),
(21601, 21601, "Requiem Behemoth", 0, "", 0, "Monster2.giant_zombie", 13, 40, 70, "male", "L2Monster", 40, 3862, 1493, 11.85, 2.78, 40, 43, 30, 21, 20, 10, 10732, 1064, 1445, 427, 780, 382, 278, 0, 333, 0, 0, 0, 20, 100, "necro_clan", 300, 1, 0, "LAST_HIT", 0, 0, 0, "fighter"),
(21602, 21602, "Zaken's Pikeman", 0, "", 0, "Monster.skeleton_pikeman", 10, 28, 43, "male", "L2Monster", 40, 1728, 618, 8.69, 2.14, 40, 43, 30, 21, 20, 10, 3693, 250, 332, 223, 163, 181, 278, 150, 333, 292, 0, 0, 50, 174, "undead_clan1", 300, 1, 0, "LAST_HIT", 0, 0, 0, "fighter"),
(21603, 21603, "Zaken's Pikeman", 0, "", 0, "Monster.skeleton_pikeman", 10, 28, 43, "male", "L2Monster", 40, 1728, 618, 8.69, 2.14, 40, 43, 30, 21, 20, 10, 5230, 354, 442, 167, 163, 181, 278, 150, 333, 292, 0, 0, 50, 174, "undead_clan1", 300, 1, 0, "LAST_HIT", 0, 0, 0, "fighter"),
(21604, 21604, "Zaken's Elite Pikeman", 0, "", 0, "Monster.skeleton_pikeman_20_bi", 12, 33.6, 43, "male", "L2Monster", 40, 1728, 618, 34.76, 2.14, 40, 43, 30, 21, 20, 10, 2114, 143, 332, 223, 163, 181, 278, 150, 333, 292, 0, 0, 50, 174, "undead_clan1", 300, 1, 0, "LAST_HIT", 0, 0, 0, "fighter"),
(21605, 21605, "Zaken's Archer", 0, "", 0, "Monster.skeleton_archer", 11, 27, 44, "male", "L2Monster", 500, 1799, 648, 8.69, 2.14, 40, 43, 30, 21, 20, 10, 4109, 281, 788, 230, 176, 187, 249, 0, 333, 279, 0, 0, 44, 191, "undead_clan1", 300, 1, 0, "LAST_HIT", 0, 0, 0, "archer"),
(21606, 21606, "Zaken's Archer", 0, "", 0, "Monster.skeleton_archer", 11, 27, 44, "male", "L2Monster", 500, 1799, 648, 8.69, 2.14, 40, 43, 30, 21, 20, 10, 5818, 398, 1048, 173, 176, 187, 249, 0, 333, 279, 0, 0, 44, 191, "undead_clan1", 300, 1, 0, "LAST_HIT", 0, 0, 0, "archer"),
(21607, 21607, "Zaken's Elite Archer", 0, "", 0, "Monster.skeleton_archer_20_bi", 13, 32.5, 44, "male", "L2Monster", 500, 1799, 648, 34.76, 2.14, 40, 43, 30, 21, 20, 10, 2273, 155, 788, 230, 176, 187, 247, 0, 333, 279, 0, 0, 40, 174, "undead_clan1", 300, 1, 0, "LAST_HIT", 0, 0, 0, "archer"),
(21608, 21608, "Zaken's Watchman", 0, "", 0, "Monster.liviona", 15, 28, 45, "male", "L2Monster", 40, 1870, 677, 8.69, 2.14, 40, 43, 30, 21, 20, 10, 3365, 234, 377, 202, 188, 193, 278, 150, 333, 0, 0, 0, 88, 191, "NULL", 0, 0, 0, "LAST_HIT", 0, 0, 0, "fighter"),
(21609, 21609, "Zaken's Watchman", 0, "", 0, "Monster.liviona", 15, 28, 45, "male", "L2Monster", 40, 1870, 677, 8.69, 2.14, 40, 43, 30, 21, 20, 10, 4766, 331, 502, 152, 188, 193, 278, 150, 333, 0, 0, 0, 88, 191, "NULL", 0, 0, 0, "LAST_HIT", 0, 0, 0, "fighter"),
(21610, 21610, "Zaken's High Grade Watchman", 0, "", 0, "Monster.liviona_20_bi", 18, 33.6, 45, "male", "L2Monster", 40, 1870, 677, 34.76, 2.14, 40, 43, 30, 21, 20, 10, 2174, 151, 377, 202, 188, 193, 278, 150, 333, 0, 0, 0, 80, 174, "NULL", 0, 0, 0, "LAST_HIT", 0, 0, 0, "fighter"),
(21611, 21611, "Unpleasant Humming", 0, "", 0, "Monster.unpleasant_humming", 12, 26, 46, "male", "L2Monster", 40, 1943, 707, 8.69, 2.14, 40, 43, 30, 21, 20, 10, 3907, 277, 401, 245, 202, 199, 278, 150, 333, 0, 0, 0, 23, 191, "undead_clan", 300, 1, 3, "LAST_HIT", 0, 0, 0, "fighter"),
(21612, 21612, "Unpleasant Humming", 0, "", 0, "Monster.unpleasant_humming", 12, 26, 46, "male", "L2Monster", 40, 1943, 707, 8.69, 2.14, 40, 43, 30, 21, 20, 10, 5533, 392, 534, 184, 202, 199, 278, 150, 333, 0, 0, 0, 23, 191, "undead_clan", 300, 1, 3, "LAST_HIT", 0, 0, 0, "fighter"),
(21613, 21613, "Unpleasant Shout", 0, "", 0, "Monster.unpleasant_humming_20_bi", 13.5, 31.2, 46, "male", "L2Monster", 40, 1943, 707, 34.76, 2.14, 40, 43, 30, 21, 20, 10, 2360, 167, 401, 245, 202, 199, 278, 150, 333, 0, 0, 0, 21, 174, "undead_clan", 300, 1, 0, "LAST_HIT", 0, 0, 0, "fighter"),
(21614, 21614, "Death Flyer", 0, "", 0, "Monster.dark_horror", 20, 35, 47, "male", "L2Monster", 40, 2016, 738, 8.69, 2.14, 40, 43, 30, 21, 20, 10, 4035, 289, 427, 253, 216, 206, 278, 0, 333, 0, 0, 0, 110, 191, "undead_clan", 300, 1, 4, "LAST_HIT", 0, 0, 0, "fighter"),
(21615, 21615, "Death Flyer", 0, "", 0, "Monster.dark_horror", 20, 35, 47, "male", "L2Monster", 40, 2016, 738, 8.69, 2.14, 40, 43, 30, 21, 20, 10, 5714, 410, 568, 190, 216, 206, 278, 0, 333, 0, 0, 0, 110, 191, "undead_clan", 300, 1, 4, "LAST_HIT", 0, 0, 0, "fighter"),
(21616, 21616, "Gigantic Flyer", 0, "", 0, "Monster.dark_horror_bi", 20, 42, 47, "male", "L2Monster", 40, 2016, 738, 34.76, 2.14, 40, 43, 30, 21, 20, 10, 2607, 187, 427, 253, 216, 206, 278, 0, 333, 0, 0, 0, 100, 174, "undead_clan", 300, 1, 0, "LAST_HIT", 0, 0, 0, "fighter"),
(21617, 21617, "Fiend Archer", 0, "", 0, "Monster.fiend_archer", 17, 55, 48, "male", "L2Monster", 500, 2091, 768, 8.69, 2.14, 40, 43, 30, 21, 20, 10, 4103, 300, 1007, 222, 231, 212, 247, 150, 333, 0, 0, 0, 70, 174, "NULL", 0, 0, 4, "LAST_HIT", 0, 0, 0, "archer"),
(21618, 21618, "Fiend Archer", 0, "", 0, "Monster.fiend_archer", 17, 55, 48, "male", "L2Monster", 500, 2091, 768, 8.69, 2.14, 40, 43, 30, 21, 20, 10, 5811, 425, 1341, 167, 231, 212, 247, 150, 333, 0, 0, 0, 70, 174, "NULL", 0, 0, 0, "LAST_HIT", 0, 0, 0, "archer"),
(21619, 21619, "Pit Archer", 0, "", 0, "Monster.fiend_archer_20_bi", 20, 66, 48, "male", "L2Monster", 500, 2091, 768, 34.76, 2.14, 40, 43, 30, 21, 20, 10, 2651, 193, 1007, 222, 231, 212, 247, 150, 333, 0, 0, 0, 70, 174, "NULL", 0, 0, 0, "LAST_HIT", 0, 0, 0, "archer"),
(21620, 21620, "Musveren", 0, "", 0, "Monster.field_stalker", 15, 30, 49, "male", "L2Monster", 40, 2168, 799, 8.69, 2.14, 40, 43, 30, 21, 20, 10, 3951, 292, 480, 270, 247, 219, 278, 0, 333, 0, 0, 0, 77, 191, "NULL", 0, 0, 4, "LAST_HIT", 0, 0, 0, "fighter"),
(21621, 21621, "Musveren", 0, "", 0, "Monster.field_stalker", 15, 30, 49, "male", "L2Monster", 40, 2168, 799, 8.69, 2.14, 40, 43, 30, 21, 20, 10, 5595, 414, 640, 202, 247, 219, 278, 0, 333, 0, 0, 0, 77, 191, "NULL", 0, 0, 4, "LAST_HIT", 0, 0, 0, "fighter"),
(21622, 21622, "Greater Musveren", 0, "", 0, "Monster.field_stalker_20_bi", 18, 36, 49, "male", "L2Monster", 40, 2168, 799, 34.76, 2.14, 40, 43, 30, 21, 20, 10, 2553, 188, 480, 270, 247, 219, 278, 0, 333, 0, 0, 0, 70, 174, "NULL", 0, 0, 0, "LAST_HIT", 0, 0, 0, "fighter"),
(21623, 21623, "Zaken's Guard", 0, "", 0, "Monster.skeleton_royal_guard", 11, 28.5, 50, "male", "L2Monster", 40, 2245, 830, 8.69, 2.14, 40, 43, 30, 21, 20, 10, 4994, 376, 445, 278, 264, 226, 317, 150, 333, 225, 945, 0, 80, 174, "undead_clan", 300, 1, 5, "LAST_HIT", 0, 0, 0, "fighter"),
(21624, 21624, "Zaken's Guard", 0, "", 0, "Monster.skeleton_royal_guard", 11, 28.5, 50, "male", "L2Monster", 40, 2245, 830, 8.69, 2.14, 40, 43, 30, 21, 20, 10, 7072, 533, 593, 209, 264, 226, 317, 150, 333, 225, 945, 0, 88, 191, "undead_clan", 300, 1, 5, "LAST_HIT", 0, 0, 0, "fighter"),
(21625, 21625, "Zaken's Elite Guard", 0, "", 0, "Monster.skeleton_royal_guard_20_bi", 13, 34.5, 50, "male", "L2Monster", 40, 2245, 830, 34.76, 2.14, 40, 43, 30, 21, 20, 10, 2858, 215, 445, 278, 264, 226, 317, 150, 333, 225, 945, 0, 80, 174, "undead_clan", 300, 1, 0, "LAST_HIT", 0, 0, 0, "fighter"),
(21626, 21626, "Kaim Vanul", 0, "", 0, "Monster.kaim_vanul", 24, 40, 51, "male", "L2Monster", 40, 2323, 861, 10.27, 2.45, 40, 43, 30, 21, 20, 10, 4453, 340, 539, 286, 281, 232, 278, 0, 333, 0, 0, 0, 37, 174, "demonic_clan", 300, 0, 5, "LAST_HIT", 0, 0, 0, "fighter"),
(21627, 21627, "Kaim Vanul", 0, "", 0, "Monster.kaim_vanul", 24, 40, 51, "male", "L2Monster", 40, 2323, 861, 10.27, 2.45, 40, 43, 30, 21, 20, 10, 6306, 481, 718, 215, 281, 232, 278, 0, 333, 0, 0, 0, 40, 191, "demonic_clan", 300, 0, 5, "LAST_HIT", 0, 0, 0, "fighter"),
(21628, 21628, "Kaim Vanul Lad", 0, "", 0, "Monster.kaim_vanul_20_bi", 28, 48, 51, "male", "L2Monster", 40, 2323, 861, 41.08, 2.45, 40, 43, 30, 21, 20, 10, 2877, 219, 539, 286, 281, 232, 278, 0, 333, 0, 0, 0, 37, 174, "demonic_clan", 300, 0, 0, "LAST_HIT", 0, 0, 0, "fighter"),
(21629, 21629, "Pirate Zombie Captain", 0, "", 0, "Monster.pirates_zombie_captain", 17, 28, 52, "male", "L2Monster", 40, 2402, 892, 10.27, 2.45, 40, 43, 30, 21, 20, 10, 6727, 520, 499, 295, 300, 239, 317, 150, 333, 232, 0, 0, 14, 174, "zaken_clan", 300, 1, 5, "LAST_HIT", 0, 0, 0, "fighter"),
(21630, 21630, "Pirate Zombie Captain", 0, "", 0, "Monster.pirates_zombie_captain", 17, 28, 52, "male", "L2Monster", 40, 2402, 892, 10.27, 2.45, 40, 43, 30, 21, 20, 10, 9526, 737, 664, 221, 300, 239, 317, 150, 333, 232, 0, 0, 14, 174, "zaken_clan", 300, 1, 5, "LAST_HIT", 0, 0, 0, "fighter"),
(21631, 21631, "Zombie Captain's Spiritual Body", 0, "", 0, "Monster.pirates_zombie_captain_20_bi", 20, 33.6, 52, "male", "L2Monster", 40, 2402, 892, 41.08, 2.45, 40, 43, 30, 21, 20, 10, 3948, 305, 499, 295, 300, 239, 317, 150, 333, 232, 0, 0, 14, 174, "zaken_clan", 300, 1, 0, "LAST_HIT", 0, 0, 0, "fighter"),
(21632, 21632, "Doll Blader", 0, "", 0, "Monster.doll_blader", 6, 12, 53, "male", "L2Monster", 40, 2481, 923, 10.27, 2.45, 40, 43, 30, 21, 20, 10, 5339, 420, 527, 258, 319, 247, 317, 0, 333, 5129, 5129, 0, 24, 191, "zaken_clan", 300, 0, 6, "LAST_HIT", 0, 0, 0, "fighter"),
(21633, 21633, "Doll Blader", 0, "", 0, "Monster.doll_blader", 6, 12, 53, "male", "L2Monster", 40, 2481, 923, 10.27, 2.45, 40, 43, 30, 21, 20, 10, 7560, 594, 701, 194, 319, 247, 317, 0, 333, 5129, 5129, 0, 24, 191, "zaken_clan", 300, 0, 6, "LAST_HIT", 0, 0, 0, "fighter"),
(21634, 21634, "Crimson Doll Blader", 0, "", 0, "Monster.doll_blader_20_bi", 7, 15, 53, "male", "L2Monster", 40, 2481, 923, 41.08, 2.45, 40, 43, 30, 21, 20, 10, 3450, 271, 527, 258, 319, 247, 317, 0, 333, 5129, 5129, 0, 22, 174, "zaken_clan", 300, 0, 0, "LAST_HIT", 0, 0, 0, "fighter"),
(21635, 21635, "Vale Master", 0, "", 0, "Monster.vale_master", 12, 40, 54, "male", "L2Monster", 40, 2562, 955, 10.27, 2.45, 40, 43, 30, 21, 20, 10, 5093, 406, 636, 266, 339, 254, 278, 150, 333, 0, 0, 0, 70, 174, "zaken_clan", 300, 0, 6, "LAST_HIT", 0, 0, 0, "fighter"),
(21636, 21636, "Vale Master", 0, "", 0, "Monster.vale_master", 12, 40, 54, "male", "L2Monster", 40, 2562, 955, 10.27, 2.45, 40, 43, 30, 21, 20, 10, 7212, 575, 846, 199, 339, 254, 278, 150, 333, 0, 0, 0, 77, 191, "zaken_clan", 300, 0, 6, "LAST_HIT", 0, 0, 0, "fighter"),
(21637, 21637, "Crimson Vale Master", 0, "", 0, "Monster.vale_master_20_bi", 14.5, 48, 54, "male", "L2Monster", 40, 2562, 955, 41.08, 2.45, 40, 43, 30, 21, 20, 10, 3291, 262, 636, 266, 339, 254, 278, 150, 333, 0, 0, 0, 70, 174, "zaken_clan", 300, 0, 0, "LAST_HIT", 0, 0, 0, "fighter"),
(21638, 21638, "Dread Wolf", 0, "", 0, "Monster.dire_wolf", 13, 11, 35, "male", "L2Monster", 40, 1220, 446, 3.56, 1.84, 40, 43, 30, 21, 20, 10, 2303, 136, 211, 154, 89, 137, 278, 150, 333, 0, 0, 0, 24, 140, "NULL", 0, 0, 0, "LAST_HIT", 0, 0, 0, "fighter"),
(21639, 21639, "Tasaba Lizardman", 0, "", 0, "Monster.virud_lizardman_scout", 10, 22, 36, "male", "L2Monster", 500, 1279, 463, 3.56, 1.84, 40, 43, 30, 21, 20, 10, 2725, 164, 417, 193, 96, 142, 247, 0, 333, 2507, 0, 0, 43, 140, "lizardman_clan", 300, 0, 0, "LAST_HIT", 0, 0, 0, "fighter"),
(21640, 21640, "Tasaba Lizardman Shaman ", 0, "", 0, "Monster.virud_lizardman_shaman", 10, 29, 37, "male", "L2Monster", 40, 1338, 480, 3.56, 1.84, 40, 43, 30, 21, 20, 10, 2003, 124, 295, 116, 104, 147, 278, 0, 333, 7, 0, 0, 43, 140, "lizardman_clan", 300, 0, 0, "LAST_HIT", 0, 0, 0, "balanced"),
(21641, 21641, "Ogre", 0, "", 0, "Monster.ogre", 21, 44, 38, "male", "L2Monster", 40, 1400, 497, 3.56, 1.84, 40, 43, 30, 21, 20, 10, 3555, 222, 300, 207, 112, 153, 256, 150, 333, 98, 0, 0, 22, 174, "lizardman_clan", 300, 0, 0, "LAST_HIT", 0, 0, 0, "fighter"),
(21642, 21642, "Tasaba Lizardman Sniper", 0, "", 0, "Monster.virud_lizardman_scout", 10, 22, 39, "male", "L2Monster", 500, 1462, 514, 3.56, 1.84, 40, 43, 30, 21, 20, 10, 3263, 208, 566, 165, 121, 158, 247, 150, 333, 2507, 0, 0, 43, 140, "lizardman_clan", 300, 0, 0, "LAST_HIT", 0, 0, 0, "fighter"),
(21643, 21643, "Tasaba Lizardman Sniper", 0, "", 0, "Monster.virud_lizardman_scout", 10, 22, 39, "male", "L2Monster", 500, 1462, 514, 3.56, 1.84, 40, 43, 30, 21, 20, 10, 4146, 264, 685, 137, 121, 158, 247, 150, 333, 2507, 0, 0, 43, 140, "lizardman_clan", 300, 0, 0, "LAST_HIT", 0, 0, 0, "fighter"),
(21644, 21644, "Lienrik", 0, "", 0, "Monster.lienrik", 12, 50, 39, "male", "L2Monster", 40, 1462, 514, 3.56, 1.84, 40, 43, 30, 21, 20, 10, 1990, 126, 297, 146, 121, 158, 317, 0, 333, 0, 0, 0, 100, 150, "lienrik_clan", 300, 0, 0, "LAST_HIT", 0, 0, 0, "fighter"),
(21645, 21645, "Lienrik Lad", 0, "", 0, "Monster.lienrik", 12, 50, 40, "male", "L2Monster", 40, 1527, 531, 3.56, 1.84, 40, 43, 30, 21, 20, 10, 3836, 248, 317, 151, 131, 164, 317, 150, 333, 0, 0, 0, 110, 191, "lienrik_clan", 300, 0, 0, "LAST_HIT", 0, 0, 0, "fighter"),
(21646, 21646, "Grave Scarab", 0, "", 0, "Monster2.scarab", 14, 22, 73, "male", "L2Monster", 40, 4086, 1601, 13.43, 3.09, 40, 43, 30, 21, 20, 10, 10206, 1050, 1463, 502, 885, 407, 278, 0, 333, 0, 0, 0, 49, 198, "NULL", 0, 0, 0, "LAST_HIT", 0, 0, 0, "fighter"),
(21647, 21647, "Scavenger Scarab", 0, "", 0, "Monster2.scarab", 14, 22, 73, "male", "L2Monster", 40, 4086, 1601, 13.43, 3.09, 40, 43, 30, 21, 20, 10, 8609, 886, 1463, 502, 885, 407, 278, 150, 333, 0, 0, 0, 49, 198, "NULL", 0, 0, 0, "LAST_HIT", 0, 0, 0, "fighter"),
(21648, 21648, "Grave Ant", 0, "", 0, "Monster.ant_soldier", 35, 17, 74, "male", "L2Monster", 40, 4158, 1637, 13.43, 3.09, 40, 43, 30, 21, 20, 10, 9383, 978, 1513, 512, 921, 416, 278, 0, 333, 0, 0, 0, 88, 165, "NULL", 0, 0, 0, "LAST_HIT", 0, 0, 0, "fighter"),
(21649, 21649, "Scavenger Ant", 0, "", 0, "Monster.ant_soldier", 35, 17, 74, "male", "L2Monster", 40, 4158, 1637, 13.43, 3.09, 40, 43, 30, 21, 20, 10, 11099, 1157, 1513, 512, 921, 416, 278, 150, 333, 0, 0, 0, 88, 165, "NULL", 0, 0, 0, "LAST_HIT", 0, 0, 0, "fighter"),
(21650, 21650, "Shrine Knight", 0, "", 0, "Monster.skeleton_knight", 10, 25, 75, "male", "L2Monster", 40, 4229, 1673, 13.43, 3.09, 40, 43, 30, 21, 20, 10, 10149, 1071, 1563, 523, 957, 425, 278, 0, 333, 150, 103, 0, 44, 181, "NULL", 0, 1, 0, "LAST_HIT", 0, 0, 0, "fighter"),
(21651, 21651, "Shrine Guard", 0, "", 0, "Monster.skeleton_pikeman", 10, 28, 75, "male", "L2Monster", 40, 4229, 1673, 13.43, 3.09, 40, 43, 30, 21, 20, 10, 9695, 1023, 1563, 523, 957, 425, 278, 0, 333, 98, 0, 0, 55, 187, "NULL", 0, 1, 0, "LAST_HIT", 0, 0, 0, "fighter"),
(21652, 21652, "Scarlet Stakato Noble", 0, "", 0, "Monster.blade_stakato_drone", 15, 39, 79, "male", "L2Monster", 40, 4490, 1821, 67.15, 3.09, 40, 43, 30, 21, 20, 10, 9382, 1039, 1544, 566, 1107, 459, 317, 150, 333, 235, 0, 0, 27, 181, "fire_clan", 300, 0, 0, "LAST_HIT", 0, 0, 0, "balanced"),
(21653, 21653, "Assassin Beetle", 0, "", 0, "Monster2.tera_beetle", 19, 54.5, 80, "male", "L2Monster", 40, 4550, 1859, 67.15, 3.09, 40, 43, 30, 21, 20, 10, 6804, 763, 1814, 576, 1144, 468, 278, 150, 333, 0, 0, 0, 49, 181, "fire_clan", 300, 0, 0, "LAST_HIT", 0, 0, 0, "fighter"),
(21654, 21654, "Necromancer of Destruction", 0, "", 0, "Monster.vale_master_20_bi", 14.5, 48, 80, "male", "L2Monster", 40, 4608, 1896, 67.15, 3.09, 40, 43, 30, 21, 20, 10, 8042, 913, 1863, 587, 1182, 477, 278, 150, 333, 0, 0, 0, 77, 154, "fire_clan", 300, 0, 0, "LAST_HIT", 0, 0, 0, "fighter"),
(21655, 21655, "Arimanes of Destruction", 0, "", 0, "Monster2.ahrimanes", 14, 57.75, 80, "male", "L2Monster", 40, 4663, 1934, 67.15, 3.09, 40, 43, 30, 21, 20, 10, 7148, 821, 2655, 598, 1220, 485, 200, 150, 333, 6722, 0, 0, 38, 203, "fire_clan", 300, 0, 0, "LAST_HIT", 0, 0, 0, "fighter"),
(21656, 21656, "Ashuras of Destruction", 0, "", 0, "Monster2.ashuras_30_bi", 17, 49, 80, "male", "L2Monster", 40, 4766, 2011, 80.58, 3.09, 40, 43, 30, 21, 20, 10, 10463, 1230, 2006, 619, 1296, 502, 278, 150, 333, 0, 0, 0, 45, 209, "fire_clan", 300, 0, 0, "LAST_HIT", 0, 0, 0, "fighter"),
(21657, 21657, "Magma Drake", 0, "", 0, "Monster2.inferno_drake_20_bi", 29, 42, 80, "male", "L2Monster", 40, 4813, 2049, 80.58, 3.09, 40, 43, 30, 21, 20, 10, 9062, 1078, 2052, 629, 1333, 511, 278, 150, 333, 0, 0, 0, 62, 203, "fire_clan", 300, 0, 0, "LAST_HIT", 0, 0, 0, "fighter"),
(21658, 21658, "Punishment of Splendor", 0, "", 0, "Monster.kel_mahum_warrior", 13, 28, 64, "male", "L2Monster", 40, 3384, 1285, 11.85, 2.78, 40, 43, 30, 21, 20, 10, 8837, 809, 1031, 408, 589, 331, 278, 0, 333, 242, 0, 0, 50, 165, "saint_clan", 300, 0, 0, "LAST_HIT", 0, 0, 0, "fighter"),
(21659, 21659, "Otherworldly Invader Soldier", 0, "", 0, "Monster.neer_crawler", 14, 22, 30, "male", "L2RiftInvader", 40, 954, 365, 16.59, 1.53, 40, 43, 30, 21, 20, 10, 1457, 79, 115, 119, 58, 114, 317, 0, 333, 0, 0, 0, 55, 181, "ssq_clan", 300, 1, 0, "LAST_HIT", 0, 0, 0, "fighter"),
(21660, 21660, "Otherworldly Invader Soldier", 0, "", 0, "Monster.neer_crawler", 14, 22, 35, "male", "L2RiftInvader", 40, 1220, 446, 21.33, 1.84, 40, 43, 30, 21, 20, 10, 2073, 122, 126, 191, 89, 137, 317, 150, 333, 0, 0, 0, 55, 181, "ssq_clan", 300, 1, 0, "LAST_HIT", 0, 0, 0, "balanced"),
(21661, 21661, "Otherworldly Invader Archer", 0, "", 0, "Monster.skeleton_archer", 11, 27, 33, "male", "L2RiftInvader", 500, 1109, 413, 21.33, 1.84, 40, 43, 30, 21, 20, 10, 1492, 85, 491, 100, 75, 128, 249, 150, 333, 275, 0, 0, 44, 181, "ssq_clan", 300, 1, 0, "LAST_HIT", 100, 0, 30, "archer"),
(21662, 21662, "Otherworldly Invader Elite Soldier", 0, "", 0, "Monster.dark_horror", 20, 35, 35, "male", "L2RiftInvader", 40, 1220, 446, 21.33, 1.84, 40, 43, 30, 21, 20, 10, 1726, 102, 192, 144, 89, 137, 278, 150, 333, 0, 0, 0, 110, 181, "ssq_clan", 300, 1, 0, "LAST_HIT", 0, 0, 0, "fighter"),
(21663, 21663, "Otherworldly Invader Shaman", 0, "", 0, "Monster.dark_horror", 20, 35, 33, "male", "L2RiftInvader", 40, 1109, 413, 21.33, 1.84, 40, 43, 30, 21, 20, 10, 1884, 108, 166, 134, 75, 128, 278, 150, 333, 0, 0, 0, 110, 181, "ssq_clan", 300, 1, 0, "LAST_HIT", 0, 0, 0, "fighter"),
(21664, 21664, "Otherworldly Invader Priest", 0, "", 0, "Monster.dark_horror", 20, 35, 30, "male", "L2RiftInvader", 40, 954, 365, 11.06, 1.53, 40, 43, 30, 21, 20, 10, 1511, 82, 132, 119, 58, 114, 278, 0, 333, 0, 0, 0, 110, 181, "ssq_clan", 300, 1, 0, "LAST_HIT", 0, 0, 0, "fighter"),
(21665, 21665, "Otherworldly Invader Magus", 0, "", 0, "Monster.dark_horror", 20, 35, 35, "male", "L2RiftInvader", 40, 1220, 446, 21.33, 1.84, 40, 43, 30, 21, 20, 10, 1362, 80, 256, 108, 89, 137, 278, 150, 333, 0, 0, 0, 110, 181, "ssq_clan", 300, 1, 0, "LAST_HIT", 0, 0, 0, "fighter"),
(21666, 21666, "Otherworldly Invader Martyrs", 0, "", 0, "Monster.dark_horror", 20, 35, 30, "male", "L2RiftInvader", 40, 954, 365, 16.59, 1.53, 40, 43, 30, 21, 20, 10, 1018, 55, 132, 119, 58, 114, 278, 0, 333, 0, 0, 0, 110, 181, "ssq_clan", 300, 1, 0, "LAST_HIT", 0, 0, 0, "fighter"),
(21667, 21667, "Otherworldly Invader Warrior", 0, "", 0, "Monster.skeleton", 11, 25, 33, "male", "L2RiftInvader", 40, 1109, 413, 21.33, 1.84, 40, 43, 30, 21, 20, 10, 1211, 69, 145, 157, 75, 128, 317, 150, 333, 220, 0, 0, 66, 181, "ssq_clan", 300, 1, 0, "LAST_HIT", 100, 0, 30, "fighter"),
(21668, 21668, "Otherworldly Invader Soldier", 0, "", 0, "Monster.neer_crawler", 14, 22, 30, "male", "L2RiftInvader", 40, 954, 365, 16.59, 1.53, 40, 43, 30, 21, 20, 10, 1071, 58, 115, 119, 58, 114, 317, 150, 333, 0, 0, 0, 55, 181, "ssq_clan", 300, 1, 0, "LAST_HIT", 0, 0, 0, "fighter"),
(21669, 21669, "Otherworldly Invader Discipline", 0, "", 0, "Monster.skeleton", 11, 25, 33, "male", "L2RiftInvader", 40, 1109, 413, 21.33, 1.84, 40, 43, 30, 21, 20, 10, 1275, 73, 145, 157, 75, 128, 317, 0, 333, 220, 0, 0, 66, 181, "ssq_clan", 300, 1, 0, "LAST_HIT", 100, 0, 50, "fighter"),
(21670, 21670, "Otherworldly Invader Berserker", 0, "", 0, "Monster.skeleton", 11, 25, 35, "male", "L2RiftInvader", 40, 1220, 446, 21.33, 1.84, 40, 43, 30, 21, 20, 10, 1785, 105, 139, 205, 89, 137, 317, 150, 333, 220, 0, 0, 66, 181, "ssq_clan", 300, 1, 0, "LAST_HIT", 100, 0, 50, "fighter"),
(21671, 21671, "Otherworldly Invader Food", 0, "", 0, "Monster.mimic", 8.5, 8.5, 30, "male", "L2Chest", 40, 954, 365, 5.53, 1.53, 40, 43, 30, 21, 20, 10, 1308, 72, 132, 140, 58, 114, 278, 0, 333, 0, 0, 0, 88, 181, "ssq_clan", 300, 0, 0, "LAST_HIT", 0, 0, 0, "fighter"),
(21672, 21672, "Otherworldly Invader Elite Soldier", 0, "", 0, "Monster.skeleton_pikeman", 10, 28, 35, "male", "L2RiftInvader", 40, 1220, 446, 42.66, 1.84, 40, 43, 30, 21, 20, 10, 1599, 94, 192, 169, 89, 137, 278, 150, 333, 96, 0, 0, 55, 181, "ssq_clan", 300, 1, 0, "LAST_HIT", 100, 0, 50, "fighter"),
(21673, 21673, "Otherworldly Invader Elite Soldier", 0, "", 0, "Monster.skeleton_pikeman", 10, 28, 35, "male", "L2RiftInvader", 40, 1220, 446, 42.66, 1.84, 40, 43, 30, 21, 20, 10, 1629, 96, 192, 169, 89, 137, 278, 150, 333, 96, 0, 0, 55, 181, "ssq_clan", 300, 1, 0, "LAST_HIT", 100, 0, 50, "fighter"),
(21674, 21674, "Otherworldly Invader Elite Soldier", 0, "", 0, "Monster.skeleton_pikeman", 10, 28, 35, "male", "L2RiftInvader", 40, 1220, 446, 1.78, 1.84, 40, 43, 30, 21, 20, 10, 1525, 92, 192, 169, 89, 137, 278, 0, 333, 96, 0, 0, 55, 181, "ssq_clan", 300, 1, 0, "LAST_HIT", 100, 0, 50, "fighter"),
(21675, 21675, "Otherworldly Invader Elite Soldier", 0, "", 0, "Monster.skeleton_pikeman", 10, 28, 30, "male", "L2RiftInvader", 40, 954, 365, 2.77, 1.53, 40, 43, 30, 21, 20, 10, 1555, 84, 132, 140, 58, 114, 278, 0, 333, 96, 0, 0, 55, 181, "ssq_clan", 300, 1, 0, "LAST_HIT", 100, 0, 50, "fighter"),
(21676, 21676, "Otherworldly Invader Warrior", 0, "", 0, "Monster.skeleton", 11, 25, 33, "male", "L2RiftInvader", 40, 1109, 413, 42.66, 1.84, 40, 43, 30, 21, 20, 10, 1452, 83, 145, 157, 75, 128, 317, 150, 333, 220, 0, 0, 66, 181, "ssq_clan", 300, 1, 0, "LAST_HIT", 100, 0, 50, "fighter"),
(21677, 21677, "Otherworldly Invader Elite Soldier", 0, "", 0, "Monster.skeleton_pikeman", 10, 28, 30, "male", "L2RiftInvader", 40, 954, 365, 33.18, 1.53, 40, 43, 30, 21, 20, 10, 1164, 63, 109, 170, 58, 114, 278, 150, 333, 96, 0, 0, 55, 181, "ssq_clan", 300, 1, 0, "LAST_HIT", 100, 0, 50, "fighter"),
(21678, 21678, "Otherworldly Invader Elite Soldier", 0, "", 0, "Monster.skeleton_pikeman", 10, 28, 33, "male", "L2RiftInvader", 40, 1109, 413, 42.66, 1.84, 40, 43, 30, 21, 20, 10, 1409, 80, 201, 130, 75, 128, 278, 150, 333, 96, 0, 0, 55, 181, "ssq_clan", 300, 1, 0, "LAST_HIT", 100, 0, 50, "fighter"),
(21679, 21679, "Otherworldly Invader Elite Soldier", 0, "", 0, "Monster.skeleton_pikeman", 10, 28, 30, "male", "L2RiftInvader", 40, 954, 365, 33.18, 1.53, 40, 43, 30, 21, 20, 10, 1148, 62, 109, 170, 58, 114, 278, 150, 333, 96, 0, 0, 55, 181, "ssq_clan", 300, 1, 0, "LAST_HIT", 100, 0, 50, "fighter"),
(21680, 21680, "Otherworldly Invader Elite Soldier", 0, "", 0, "Monster.skeleton_pikeman", 10, 28, 35, "male", "L2RiftInvader", 40, 1220, 446, 42.66, 1.84, 40, 43, 30, 21, 20, 10, 1562, 92, 232, 140, 89, 137, 278, 150, 333, 96, 0, 0, 55, 181, "ssq_clan", 300, 1, 0, "LAST_HIT", 100, 0, 50, "fighter"),
(21681, 21681, "Otherworldly Invader Magus", 0, "", 0, "Monster.dark_horror", 20, 35, 33, "male", "L2RiftInvader", 40, 1109, 413, 42.66, 1.84, 40, 43, 30, 21, 20, 10, 1343, 77, 166, 157, 75, 128, 278, 0, 333, 0, 0, 0, 110, 181, "ssq_clan", 300, 1, 0, "LAST_HIT", 0, 0, 0, "fighter"),
(21682, 21682, "Dimension Invader Soldier", 0, "", 0, "Monster.neer_crawler", 14, 22, 40, "male", "L2RiftInvader", 40, 1527, 531, 21.33, 1.84, 40, 43, 30, 21, 20, 10, 2590, 167, 238, 171, 131, 164, 317, 0, 333, 0, 0, 0, 55, 181, "ssq_clan", 300, 1, 0, "LAST_HIT", 0, 0, 0, "fighter"),
(21683, 21683, "Dimension Invader Soldier", 0, "", 0, "Monster.neer_crawler", 14, 22, 45, "male", "L2RiftInvader", 40, 1870, 677, 26.07, 2.14, 40, 43, 30, 21, 20, 10, 3427, 238, 248, 269, 188, 193, 317, 150, 333, 0, 0, 0, 55, 181, "ssq_clan", 300, 1, 0, "LAST_HIT", 0, 0, 0, "balanced"),
(21684, 21684, "Dimension Invader Archer", 0, "", 0, "Monster.skeleton_archer", 11, 27, 43, "male", "L2RiftInvader", 500, 1728, 618, 26.07, 2.14, 40, 43, 30, 21, 20, 10, 2534, 171, 984, 142, 163, 181, 249, 150, 333, 279, 0, 0, 44, 181, "ssq_clan", 300, 1, 0, "LAST_HIT", 100, 0, 50, "archer"),
(21685, 21685, "Dimension Invader Elite Soldier", 0, "", 0, "Monster.crimson_doll", 15, 38, 45, "male", "L2RiftInvader", 40, 1870, 677, 26.07, 2.14, 40, 43, 30, 21, 20, 10, 2853, 198, 377, 202, 188, 193, 278, 150, 333, 0, 0, 0, 66, 181, "ssq_clan", 300, 1, 0, "LAST_HIT", 0, 0, 0, "fighter"),
(21686, 21686, "Dimension Invader Shaman", 0, "", 0, "Monster.crimson_doll", 15, 38, 43, "male", "L2RiftInvader", 40, 1728, 618, 26.07, 2.14, 40, 43, 30, 21, 20, 10, 3199, 216, 332, 189, 163, 181, 278, 150, 333, 0, 0, 0, 66, 181, "ssq_clan", 300, 1, 0, "LAST_HIT", 0, 0, 0, "fighter"),
(21687, 21687, "Dimension Invader Priest", 0, "", 0, "Monster.crimson_doll", 15, 38, 40, "male", "L2RiftInvader", 40, 1527, 531, 14.22, 1.84, 40, 43, 30, 21, 20, 10, 2686, 173, 273, 171, 131, 164, 278, 0, 333, 0, 0, 0, 66, 181, "ssq_clan", 300, 1, 0, "LAST_HIT", 0, 0, 0, "fighter"),
(21688, 21688, "Dimension Invader Magus", 0, "", 0, "Monster.crimson_doll", 15, 38, 45, "male", "L2RiftInvader", 40, 1870, 677, 26.07, 2.14, 40, 43, 30, 21, 20, 10, 2253, 156, 502, 152, 188, 193, 278, 150, 333, 0, 0, 0, 66, 181, "ssq_clan", 300, 1, 0, "LAST_HIT", 0, 0, 0, "fighter"),
(21689, 21689, "Dimension Invader Martyrs", 0, "", 0, "Monster.crimson_doll", 15, 38, 40, "male", "L2RiftInvader", 40, 1527, 531, 21.33, 1.84, 40, 43, 30, 21, 20, 10, 1809, 117, 273, 171, 131, 164, 278, 0, 333, 0, 0, 0, 66, 181, "ssq_clan", 300, 1, 0, "LAST_HIT", 0, 0, 0, "fighter"),
(21690, 21690, "Dimension Invader Warrior", 0, "", 0, "Monster.skeleton_knight", 10, 25, 43, "male", "L2RiftInvader", 40, 1728, 618, 26.07, 2.14, 40, 43, 30, 21, 20, 10, 2057, 139, 332, 223, 163, 181, 278, 150, 333, 70, 0, 0, 44, 181, "ssq_clan", 300, 1, 0, "LAST_HIT", 100, 0, 50, "fighter"),
(21691, 21691, "Dimension Invader Soldier", 0, "", 0, "Monster.neer_crawler", 14, 22, 40, "male", "L2RiftInvader", 40, 1527, 531, 21.33, 1.84, 40, 43, 30, 21, 20, 10, 1905, 123, 238, 171, 131, 164, 317, 150, 333, 0, 0, 0, 55, 181, "ssq_clan", 300, 1, 0, "LAST_HIT", 0, 0, 0, "fighter"),
(21692, 21692, "Dimension Invader Discipline", 0, "", 0, "Monster.skeleton_knight", 10, 25, 43, "male", "L2RiftInvader", 40, 1728, 618, 26.07, 2.14, 40, 43, 30, 21, 20, 10, 2166, 146, 332, 223, 163, 181, 278, 0, 333, 70, 0, 0, 44, 181, "ssq_clan", 300, 1, 0, "LAST_HIT", 100, 0, 50, "fighter"),
(21693, 21693, "Dimension Invader Berserker ", 0, "", 0, "Monster.skeleton_knight", 10, 25, 45, "male", "L2RiftInvader", 40, 1870, 677, 26.07, 2.14, 40, 43, 30, 21, 20, 10, 2951, 205, 312, 288, 188, 193, 278, 150, 333, 70, 0, 0, 44, 181, "ssq_clan", 300, 1, 0, "LAST_HIT", 100, 0, 50, "fighter"),
(21694, 21694, "Dimension Invader Food", 0, "", 0, "Monster.mimic", 8.5, 8.5, 40, "male", "L2Chest", 40, 1527, 531, 7.11, 1.84, 40, 43, 30, 21, 20, 10, 2327, 150, 273, 201, 131, 164, 278, 0, 333, 0, 0, 0, 88, 181, "ssq_clan", 300, 0, 0, "LAST_HIT", 0, 0, 0, "fighter"),
(21695, 21695, "Dimension Invader Elite Soldier", 0, "", 0, "Monster.headless_knight", 21, 31, 45, "male", "L2RiftInvader", 40, 1870, 677, 52.14, 2.14, 40, 43, 30, 21, 20, 10, 2643, 183, 377, 238, 188, 193, 278, 150, 333, 135, 0, 0, 77, 181, "ssq_clan", 300, 1, 0, "LAST_HIT", 100, 0, 50, "fighter"),
(21696, 21696, "Dimension Invader Elite Soldier", 0, "", 0, "Monster.headless_knight", 21, 31, 45, "male", "L2RiftInvader", 40, 1870, 677, 52.14, 2.14, 40, 43, 30, 21, 20, 10, 2693, 187, 377, 238, 188, 193, 278, 150, 333, 135, 0, 0, 77, 181, "ssq_clan", 300, 1, 0, "LAST_HIT", 100, 0, 50, "fighter"),
(21697, 21697, "Dimension Invader Elite Soldier", 0, "", 0, "Monster.headless_knight", 21, 31, 45, "male", "L2RiftInvader", 40, 1870, 677, 2.17, 2.14, 40, 43, 30, 21, 20, 10, 2521, 176, 377, 238, 188, 193, 278, 0, 333, 135, 0, 0, 77, 181, "ssq_clan", 300, 1, 0, "LAST_HIT", 100, 0, 50, "fighter"),
(21698, 21698, "Dimension Invader Elite Soldier", 0, "", 0, "Monster.headless_knight", 21, 31, 40, "male", "L2RiftInvader", 40, 1527, 531, 3.56, 1.84, 40, 43, 30, 21, 20, 10, 2764, 178, 273, 201, 131, 164, 278, 0, 333, 135, 0, 0, 77, 181, "ssq_clan", 300, 1, 0, "LAST_HIT", 100, 0, 50, "fighter"),
(21699, 21699, "Dimension Invader Warrior", 0, "", 0, "Monster.skeleton_knight", 10, 25, 43, "male", "L2RiftInvader", 40, 1728, 618, 52.14, 2.14, 40, 43, 30, 21, 20, 10, 2466, 166, 332, 223, 163, 181, 278, 150, 333, 70, 0, 0, 44, 181, "ssq_clan", 300, 1, 0, "LAST_HIT", 100, 0, 50, "fighter"),
(21700, 21700, "Dimension Invader Elite Soldier", 0, "", 0, "Monster.headless_knight", 21, 31, 40, "male", "L2RiftInvader", 40, 1527, 531, 42.66, 1.84, 40, 43, 30, 21, 20, 10, 2070, 133, 225, 244, 131, 164, 278, 150, 333, 135, 0, 0, 77, 181, "ssq_clan", 300, 1, 0, "LAST_HIT", 100, 0, 50, "fighter"),
(21701, 21701, "Dimension Invader Elite Soldier", 0, "", 0, "Monster.headless_knight", 21, 31, 43, "male", "L2RiftInvader", 40, 1728, 618, 52.14, 2.14, 40, 43, 30, 21, 20, 10, 2392, 161, 402, 184, 163, 181, 278, 150, 333, 135, 0, 0, 77, 181, "ssq_clan", 300, 1, 0, "LAST_HIT", 100, 0, 50, "fighter"),
(21702, 21702, "Dimension Invader Elite Soldier", 0, "", 0, "Monster.headless_knight", 21, 31, 40, "male", "L2RiftInvader", 40, 1527, 531, 42.66, 1.84, 40, 43, 30, 21, 20, 10, 2041, 131, 225, 244, 131, 164, 278, 150, 333, 135, 0, 0, 77, 181, "ssq_clan", 300, 1, 0, "LAST_HIT", 100, 0, 50, "fighter"),
(21703, 21703, "Dimension Invader Elite Soldier", 0, "", 0, "Monster.headless_knight", 21, 31, 45, "male", "L2RiftInvader", 40, 1870, 677, 52.14, 2.14, 40, 43, 30, 21, 20, 10, 2583, 179, 457, 196, 188, 193, 278, 150, 333, 135, 0, 0, 77, 181, "ssq_clan", 300, 1, 0, "LAST_HIT", 100, 0, 50, "fighter"),
(21704, 21704, "Dimension Invader Magus", 0, "", 0, "Monster.crimson_doll", 15, 38, 43, "male", "L2RiftInvader", 40, 1728, 618, 52.14, 2.14, 40, 43, 30, 21, 20, 10, 2281, 154, 332, 223, 163, 181, 278, 0, 333, 0, 0, 0, 66, 181, "ssq_clan", 300, 1, 0, "LAST_HIT", 0, 0, 0, "fighter"),
(21705, 21705, "Purgatory Invader Soldier", 0, "", 0, "Monster.doll_blader", 6, 12, 50, "male", "L2RiftInvader", 40, 2245, 830, 26.07, 2.14, 40, 43, 30, 21, 20, 10, 4047, 305, 445, 236, 264, 226, 317, 0, 333, 5129, 5129, 0, 24, 181, "ssq_clan", 300, 0, 0, "LAST_HIT", 0, 0, 0, "fighter"),
(21706, 21706, "Purgatory Invader Soldier", 0, "", 0, "Monster.doll_blader", 6, 12, 55, "male", "L2RiftInvader", 40, 2643, 987, 30.81, 2.45, 40, 43, 30, 21, 20, 10, 5120, 413, 440, 364, 360, 261, 317, 150, 333, 5129, 5129, 0, 24, 181, "ssq_clan", 300, 0, 0, "LAST_HIT", 0, 0, 0, "balanced"),
(21707, 21707, "Purgatory Invader Archer", 0, "", 0, "Monster.skeleton_archer", 11, 27, 53, "male", "L2RiftInvader", 500, 2481, 923, 30.81, 2.45, 40, 43, 30, 21, 20, 10, 3850, 302, 1782, 194, 319, 247, 249, 150, 333, 282, 0, 0, 44, 181, "ssq_clan", 300, 1, 0, "LAST_HIT", 100, 0, 50, "archer"),
(21708, 21708, "Purgatory Invader Elite Soldier", 0, "", 0, "Monster.banshee", 9, 23, 55, "female", "L2RiftInvader", 40, 2643, 987, 30.81, 2.45, 40, 43, 30, 21, 20, 10, 4262, 344, 670, 273, 360, 261, 278, 150, 333, 3939, 0, 0, 88, 181, "ssq_clan", 300, 0, 0, "LAST_HIT", 0, 0, 0, "fighter"),
(21709, 21709, "Purgatory Invader Shaman", 0, "", 0, "Monster.banshee", 9, 23, 53, "female", "L2RiftInvader", 40, 2481, 923, 30.81, 2.45, 40, 43, 30, 21, 20, 10, 4861, 382, 602, 258, 319, 247, 278, 150, 333, 3939, 0, 0, 88, 181, "ssq_clan", 300, 0, 0, "LAST_HIT", 0, 0, 0, "fighter"),
(21710, 21710, "Purgatory Invader Priest", 0, "", 0, "Monster.banshee", 9, 23, 50, "female", "L2RiftInvader", 40, 2245, 830, 17.38, 2.14, 40, 43, 30, 21, 20, 10, 4198, 316, 509, 236, 264, 226, 278, 0, 333, 3939, 0, 0, 88, 181, "ssq_clan", 300, 0, 0, "LAST_HIT", 0, 0, 0, "fighter"),
(21711, 21711, "Purgatory Invader Magus", 0, "", 0, "Monster.banshee", 9, 23, 55, "female", "L2RiftInvader", 40, 2643, 987, 30.81, 2.45, 40, 43, 30, 21, 20, 10, 3365, 271, 892, 205, 360, 261, 278, 150, 333, 3939, 0, 0, 88, 181, "ssq_clan", 300, 0, 0, "LAST_HIT", 0, 0, 0, "mage"),
(21712, 21712, "Purgatory Invader Martyrs", 0, "", 0, "Monster.banshee", 9, 23, 50, "female", "L2RiftInvader", 40, 2245, 830, 26.07, 2.14, 40, 43, 30, 21, 20, 10, 2828, 213, 509, 236, 264, 226, 278, 0, 333, 3939, 0, 0, 88, 181, "ssq_clan", 300, 0, 0, "LAST_HIT", 0, 0, 0, "fighter"),
(21713, 21713, "Purgatory Invader Warrior", 0, "", 0, "Monster.skeleton_royal_guard", 11, 28.5, 53, "male", "L2RiftInvader", 40, 2481, 923, 30.81, 2.45, 40, 43, 30, 21, 20, 10, 3125, 245, 527, 304, 319, 247, 317, 150, 333, 946, 946, 0, 88, 181, "ssq_clan", 300, 1, 0, "LAST_HIT", 100, 0, 50, "fighter"),
(21714, 21714, "Purgatory Invader Soldier", 0, "", 0, "Monster.doll_blader", 6, 12, 50, "male", "L2RiftInvader", 40, 2245, 830, 26.07, 2.14, 40, 43, 30, 21, 20, 10, 2977, 224, 445, 236, 264, 226, 317, 150, 333, 5129, 5129, 0, 24, 181, "ssq_clan", 300, 0, 0, "LAST_HIT", 0, 0, 0, "fighter"),
(21715, 21715, "Purgatory Invader Disciples", 0, "", 0, "Monster.skeleton_royal_guard", 11, 28.5, 53, "male", "L2RiftInvader", 40, 2481, 923, 30.81, 2.45, 40, 43, 30, 21, 20, 10, 3291, 258, 527, 304, 319, 247, 317, 0, 333, 946, 946, 0, 88, 181, "ssq_clan", 300, 1, 0, "LAST_HIT", 100, 0, 50, "fighter"),
(21716, 21716, "Purgatory Invader Berserker", 0, "", 0, "Monster.skeleton_royal_guard", 11, 28.5, 55, "male", "L2RiftInvader", 40, 2643, 987, 30.81, 2.45, 40, 43, 30, 21, 20, 10, 4409, 356, 484, 389, 360, 261, 317, 150, 333, 946, 946, 0, 88, 181, "ssq_clan", 300, 1, 0, "LAST_HIT", 100, 0, 50, "balanced"),
(21717, 21717, "Purgatory Invader Food", 0, "", 0, "Monster.mimic", 8.5, 8.5, 50, "male", "L2Chest", 40, 2245, 830, 8.69, 2.14, 40, 43, 30, 21, 20, 10, 3636, 274, 509, 278, 264, 226, 278, 0, 333, 0, 0, 0, 88, 181, "ssq_clan", 300, 0, 0, "LAST_HIT", 0, 0, 0, "fighter"),
(21718, 21718, "Purgatory Invader Elite Soldier", 0, "", 0, "Monster.bloody_queen", 14, 40, 55, "female", "L2RiftInvader", 40, 2643, 987, 61.62, 2.45, 40, 43, 30, 21, 20, 10, 3949, 318, 670, 322, 360, 261, 278, 150, 333, 0, 0, 0, 88, 181, "ssq_clan", 300, 0, 0, "LAST_HIT", 100, 0, 50, "fighter"),
(21719, 21719, "Purgatory Invader Elite Soldier", 0, "", 0, "Monster.bloody_queen", 14, 40, 55, "female", "L2RiftInvader", 40, 2643, 987, 61.62, 2.45, 40, 43, 30, 21, 20, 10, 4023, 324, 670, 322, 360, 261, 278, 150, 333, 0, 0, 0, 88, 181, "ssq_clan", 300, 0, 0, "LAST_HIT", 100, 0, 50, "fighter"),
(21720, 21720, "Purgatory Invader Elite Soldier", 0, "", 0, "Monster.bloody_queen", 14, 40, 55, "female", "L2RiftInvader", 40, 2643, 987, 2.57, 2.45, 40, 43, 30, 21, 20, 10, 3766, 304, 670, 322, 360, 261, 278, 0, 333, 0, 0, 0, 88, 181, "ssq_clan", 300, 0, 0, "LAST_HIT", 100, 0, 50, "fighter"),
(21721, 21721, "Purgatory Invader Elite Soldier", 0, "", 0, "Monster.bloody_queen", 14, 40, 50, "female", "L2RiftInvader", 40, 2245, 830, 4.35, 2.14, 40, 43, 30, 21, 20, 10, 4319, 326, 509, 278, 264, 226, 278, 0, 333, 0, 0, 0, 88, 181, "ssq_clan", 300, 0, 0, "LAST_HIT", 100, 0, 50, "fighter"),
(21722, 21722, "Purgatory Invader Warrior", 0, "", 0, "Monster.skeleton_royal_guard", 11, 28.5, 53, "male", "L2RiftInvader", 40, 2481, 923, 61.62, 2.45, 40, 43, 30, 21, 20, 10, 3746, 294, 527, 304, 319, 247, 317, 150, 333, 946, 946, 0, 88, 181, "ssq_clan", 300, 1, 0, "LAST_HIT", 100, 0, 50, "fighter"),
(21723, 21723, "Purgatory Invader Elite Soldier", 0, "", 0, "Monster.bloody_queen", 14, 40, 50, "female", "L2RiftInvader", 40, 2245, 830, 52.14, 2.14, 40, 43, 30, 21, 20, 10, 3235, 243, 421, 336, 264, 226, 278, 150, 333, 0, 0, 0, 88, 181, "ssq_clan", 300, 0, 0, "LAST_HIT", 100, 0, 50, "fighter"),
(21724, 21724, "Purgatory Invader Elite Soldier", 0, "", 0, "Monster.bloody_queen", 14, 40, 53, "female", "L2RiftInvader", 40, 2481, 923, 61.62, 2.45, 40, 43, 30, 21, 20, 10, 3635, 285, 729, 251, 319, 247, 278, 150, 333, 0, 0, 0, 88, 181, "ssq_clan", 300, 0, 0, "LAST_HIT", 100, 0, 50, "fighter"),
(21725, 21725, "Purgatory Invader Elite Soldier", 0, "", 0, "Monster.bloody_queen", 14, 40, 50, "female", "L2RiftInvader", 40, 2245, 830, 52.14, 2.14, 40, 43, 30, 21, 20, 10, 3189, 240, 421, 336, 264, 226, 278, 150, 333, 0, 0, 0, 88, 181, "ssq_clan", 300, 0, 0, "LAST_HIT", 100, 0, 50, "fighter"),
(21726, 21726, "Purgatory Invader Elite Soldier", 0, "", 0, "Monster.bloody_queen", 14, 40, 55, "female", "L2RiftInvader", 40, 2643, 987, 61.62, 2.45, 40, 43, 30, 21, 20, 10, 3859, 311, 811, 266, 360, 261, 278, 150, 333, 0, 0, 0, 88, 181, "ssq_clan", 300, 0, 0, "LAST_HIT", 100, 0, 50, "fighter"),
(21727, 21727, "Purgatory Invader Magus", 0, "", 0, "Monster.banshee", 9, 23, 53, "female", "L2RiftInvader", 40, 2481, 923, 61.62, 2.45, 40, 43, 30, 21, 20, 10, 3465, 272, 602, 258, 319, 247, 278, 0, 333, 3939, 0, 0, 88, 181, "ssq_clan", 300, 0, 0, "LAST_HIT", 0, 0, 0, "mage"),
(21728, 21728, "Forbidden Path Invader Elite Soldier", 0, "", 0, "Monster.doll_blader", 6, 12, 60, "male", "L2RiftInvader", 40, 3054, 1150, 30.81, 2.45, 40, 43, 30, 21, 20, 10, 5828, 506, 753, 313, 478, 299, 317, 0, 333, 5129, 5129, 0, 24, 181, "ssq_clan", 300, 0, 0, "LAST_HIT", 0, 0, 0, "fighter"),
(21729, 21729, "Forbidden Path Invader Elite Soldier", 0, "", 0, "Monster.doll_blader", 6, 12, 65, "male", "L2RiftInvader", 40, 3465, 1319, 35.55, 2.78, 40, 43, 30, 21, 20, 10, 7151, 664, 708, 473, 619, 340, 317, 150, 333, 5129, 5129, 0, 24, 181, "ssq_clan", 300, 0, 0, "LAST_HIT", 0, 0, 0, "balanced"),
(21730, 21730, "Forbidden Path Invader Archer", 0, "", 0, "Monster.skeleton_archer", 11, 27, 63, "male", "L2RiftInvader", 500, 3302, 1251, 35.55, 2.78, 40, 43, 30, 21, 20, 10, 5439, 491, 2920, 254, 560, 323, 249, 150, 333, 284, 0, 0, 44, 181, "ssq_clan", 300, 1, 0, "LAST_HIT", 100, 0, 50, "archer"),
(21731, 21731, "Forbidden Path Invader Elite Soldier", 0, "", 0, "Monster.banshee", 9, 23, 65, "female", "L2RiftInvader", 40, 3465, 1319, 35.55, 2.78, 40, 43, 30, 21, 20, 10, 5952, 553, 1077, 355, 619, 340, 278, 150, 333, 3939, 0, 0, 88, 181, "ssq_clan", 300, 0, 0, "LAST_HIT", 0, 0, 0, "fighter"),
(21732, 21732, "Forbidden Path Invader Shaman", 0, "", 0, "Monster.banshee", 9, 23, 63, "female", "L2RiftInvader", 40, 3302, 1251, 35.55, 2.78, 40, 43, 30, 21, 20, 10, 6868, 620, 987, 338, 560, 323, 278, 150, 333, 3939, 0, 0, 88, 181, "ssq_clan", 300, 0, 0, "LAST_HIT", 0, 0, 0, "fighter"),
(21733, 21733, "Forbidden Path Invader Priest", 0, "", 0, "Monster.banshee", 9, 23, 60, "female", "L2RiftInvader", 40, 3054, 1150, 20.54, 2.45, 40, 43, 30, 21, 20, 10, 6045, 525, 860, 313, 478, 299, 278, 0, 333, 3939, 0, 0, 88, 181, "ssq_clan", 300, 0, 0, "LAST_HIT", 0, 0, 0, "fighter"),
(21734, 21734, "Forbidden Path Invader Magus", 0, "", 0, "Monster.banshee", 9, 23, 65, "female", "L2RiftInvader", 40, 3465, 1319, 35.55, 2.78, 40, 43, 30, 21, 20, 10, 4700, 436, 1433, 267, 619, 340, 278, 150, 333, 3939, 0, 0, 88, 181, "ssq_clan", 300, 0, 0, "LAST_HIT", 0, 0, 0, "mage"),
(21735, 21735, "Forbidden Path Invader Martyrs", 0, "", 0, "Monster.banshee", 9, 23, 60, "female", "L2RiftInvader", 40, 3054, 1150, 30.81, 2.45, 40, 43, 30, 21, 20, 10, 4072, 353, 860, 313, 478, 299, 278, 0, 333, 3939, 0, 0, 88, 181, "ssq_clan", 300, 0, 0, "LAST_HIT", 0, 0, 0, "fighter"),
(21736, 21736, "Forbidden Path Invader Warrior", 0, "", 0, "Monster.skeleton_royal_guard", 11, 28.5, 63, "male", "L2RiftInvader", 40, 3302, 1251, 35.55, 2.78, 40, 43, 30, 21, 20, 10, 4415, 398, 864, 398, 560, 323, 317, 150, 333, 946, 946, 0, 88, 181, "ssq_clan", 300, 1, 0, "LAST_HIT", 100, 0, 50, "fighter"),
(21737, 21737, "Forbidden Path Invader Soldier", 0, "", 0, "Monster.doll_blader", 6, 12, 60, "male", "L2RiftInvader", 40, 3054, 1150, 30.81, 2.45, 40, 43, 30, 21, 20, 10, 4287, 372, 753, 313, 478, 299, 317, 150, 333, 5129, 5129, 0, 24, 181, "ssq_clan", 300, 0, 0, "LAST_HIT", 0, 0, 0, "fighter"),
(21738, 21738, "Forbidden Path Invader Disciple", 0, "", 0, "Monster.skeleton_royal_guard", 11, 28.5, 63, "male", "L2RiftInvader", 40, 3302, 1251, 35.55, 2.78, 40, 43, 30, 21, 20, 10, 4650, 419, 864, 398, 560, 323, 317, 0, 333, 946, 946, 0, 88, 181, "ssq_clan", 300, 1, 0, "LAST_HIT", 100, 0, 50, "fighter"),
(21739, 21739, "Forbidden Path Invader Berserker", 0, "", 0, "Monster.skeleton_royal_guard", 11, 28.5, 65, "male", "L2RiftInvader", 40, 3465, 1319, 35.55, 2.78, 40, 43, 30, 21, 20, 10, 6158, 572, 778, 506, 619, 340, 317, 150, 333, 946, 946, 0, 88, 181, "ssq_clan", 300, 1, 0, "LAST_HIT", 100, 0, 50, "balanced"),
(21740, 21740, "Forbidden Path Invader Food", 0, "", 0, "Monster.mimic", 8.5, 8.5, 60, "male", "L2Chest", 40, 3054, 1150, 10.27, 2.45, 40, 43, 30, 21, 20, 10, 5235, 454, 860, 368, 478, 299, 278, 0, 333, 0, 0, 0, 80, 165, "ssq_clan", 300, 0, 0, "LAST_HIT", 0, 0, 0, "fighter"),
(21741, 21741, "Forbidden Path Invader Elite Soldier", 0, "", 0, "Monster.bloody_queen", 14, 40, 65, "female", "L2RiftInvader", 40, 3465, 1319, 71.1, 2.78, 40, 43, 30, 21, 20, 10, 5515, 512, 1077, 418, 619, 340, 278, 150, 333, 0, 0, 0, 80, 165, "ssq_clan", 300, 0, 0, "LAST_HIT", 100, 0, 50, "fighter"),
(21742, 21742, "Forbidden Path Invader Elite Soldier", 0, "", 0, "Monster.bloody_queen", 14, 40, 65, "female", "L2RiftInvader", 40, 3465, 1319, 71.1, 2.78, 40, 43, 30, 21, 20, 10, 5620, 522, 1077, 418, 619, 340, 278, 150, 333, 0, 0, 0, 80, 165, "ssq_clan", 300, 0, 0, "LAST_HIT", 100, 0, 50, "fighter"),
(21743, 21743, "Forbidden Path Invader Elite Soldier", 0, "", 0, "Monster.bloody_queen", 14, 40, 65, "female", "L2RiftInvader", 40, 3465, 1319, 2.96, 2.78, 40, 43, 30, 21, 20, 10, 5259, 488, 1077, 418, 619, 340, 278, 0, 333, 0, 0, 0, 88, 181, "ssq_clan", 300, 0, 0, "LAST_HIT", 100, 0, 50, "fighter"),
(21744, 21744, "Forbidden Path Invader Elite Soldier", 0, "", 0, "Monster.bloody_queen", 14, 40, 60, "female", "L2RiftInvader", 40, 3054, 1150, 5.14, 2.45, 40, 43, 30, 21, 20, 10, 6220, 540, 860, 368, 478, 299, 278, 0, 333, 0, 0, 0, 88, 181, "ssq_clan", 300, 0, 0, "LAST_HIT", 100, 0, 50, "fighter"),
(21745, 21745, "Forbidden Path Invader Warrior", 0, "", 0, "Monster.skeleton_royal_guard", 11, 28.5, 63, "male", "L2RiftInvader", 40, 3302, 1251, 71.1, 2.78, 40, 43, 30, 21, 20, 10, 5294, 478, 864, 398, 560, 323, 317, 150, 333, 946, 946, 0, 88, 181, "ssq_clan", 300, 1, 0, "LAST_HIT", 100, 0, 50, "fighter"),
(21746, 21746, "Forbidden Path Invader Elite Soldier", 0, "", 0, "Monster.bloody_queen", 14, 40, 60, "female", "L2RiftInvader", 40, 3054, 1150, 61.62, 2.45, 40, 43, 30, 21, 20, 10, 4658, 404, 711, 446, 478, 299, 278, 150, 333, 0, 0, 0, 88, 181, "ssq_clan", 300, 0, 0, "LAST_HIT", 100, 0, 50, "balanced"),
(21747, 21747, "Forbidden Path Invader Elite Soldier", 0, "", 0, "Monster.bloody_queen", 14, 40, 63, "female", "L2RiftInvader", 40, 3302, 1251, 71.1, 2.78, 40, 43, 30, 21, 20, 10, 5136, 463, 1194, 329, 560, 323, 278, 150, 333, 0, 0, 0, 88, 181, "ssq_clan", 300, 0, 0, "LAST_HIT", 100, 0, 50, "fighter"),
(21748, 21748, "Forbidden Path Invader Elite Soldier", 0, "", 0, "Monster.bloody_queen", 14, 40, 60, "female", "L2RiftInvader", 40, 3054, 1150, 61.62, 2.45, 40, 43, 30, 21, 20, 10, 4592, 398, 711, 446, 478, 299, 278, 150, 333, 0, 0, 0, 88, 181, "ssq_clan", 300, 0, 0, "LAST_HIT", 100, 0, 50, "balanced"),
(21749, 21749, "Forbidden Path Invader Elite Soldier", 0, "", 0, "Monster.bloody_queen", 14, 40, 65, "female", "L2RiftInvader", 40, 3465, 1319, 71.1, 2.78, 40, 43, 30, 21, 20, 10, 5390, 500, 1303, 346, 619, 340, 278, 150, 333, 0, 0, 0, 88, 181, "ssq_clan", 300, 0, 0, "LAST_HIT", 100, 0, 50, "fighter"),
(21750, 21750, "Forbidden Path Invader Magus", 0, "", 0, "Monster.banshee", 9, 23, 63, "female", "L2RiftInvader", 40, 3302, 1251, 71.1, 2.78, 40, 43, 30, 21, 20, 10, 4897, 442, 987, 338, 560, 323, 278, 0, 333, 3939, 0, 0, 88, 181, "ssq_clan", 300, 0, 0, "LAST_HIT", 0, 0, 0, "mage"),
(21751, 21751, "Dark Omen Invader Soldier", 0, "", 0, "Monster2.giant_zombie", 13, 40, 70, "male", "L2RiftInvader", 40, 3862, 1493, 35.55, 2.78, 40, 43, 30, 21, 20, 10, 7933, 786, 1314, 470, 780, 382, 278, 0, 333, 0, 0, 0, 22, 181, "ssq_clan", 300, 1, 0, "LAST_HIT", 0, 0, 0, "fighter"),
(21752, 21752, "Dark Omen Invader Soldier", 0, "", 0, "Monster2.giant_zombie", 13, 40, 75, "male", "L2RiftInvader", 40, 4229, 1673, 40.29, 3.09, 40, 43, 30, 21, 20, 10, 9521, 1004, 1175, 696, 957, 425, 278, 150, 333, 0, 0, 0, 22, 181, "ssq_clan", 300, 1, 0, "LAST_HIT", 0, 0, 0, "balanced"),
(21753, 21753, "Dark Omen Invader Archer", 0, "", 0, "Monster.skeleton_archer", 11, 27, 73, "male", "L2RiftInvader", 500, 4086, 1601, 40.29, 3.09, 40, 43, 30, 21, 20, 10, 7303, 751, 4327, 320, 885, 407, 249, 150, 333, 288, 0, 0, 44, 181, "ssq_clan", 300, 1, 0, "LAST_HIT", 100, 0, 50, "archer"),
(21754, 21754, "Dark Omen Invader Elite Soldier", 0, "", 0, "Monster.doll_master", 20, 42, 75, "male", "L2RiftInvader", 40, 4229, 1673, 40.29, 3.09, 40, 43, 30, 21, 20, 10, 7925, 836, 1368, 445, 957, 425, 317, 150, 333, 0, 0, 0, 88, 181, "ssq_clan", 300, 1, 0, "LAST_HIT", 0, 0, 0, "balanced"),
(21755, 21755, "Dark Omen Invader Shaman", 0, "", 0, "Monster.doll_master", 20, 42, 73, "male", "L2RiftInvader", 40, 4086, 1601, 40.29, 3.09, 40, 43, 30, 21, 20, 10, 9222, 949, 1280, 426, 885, 407, 317, 150, 333, 0, 0, 0, 88, 181, "ssq_clan", 300, 1, 0, "LAST_HIT", 0, 0, 0, "balanced"),
(21756, 21756, "Dark Omen Invader Priest", 0, "", 0, "Monster.doll_master", 20, 42, 70, "male", "L2RiftInvader", 40, 3862, 1493, 23.7, 2.78, 40, 43, 30, 21, 20, 10, 8228, 816, 1150, 399, 780, 382, 317, 0, 333, 0, 0, 0, 88, 181, "ssq_clan", 300, 1, 0, "LAST_HIT", 0, 0, 0, "balanced"),
(21757, 21757, "Dark Omen Invader Magus", 0, "", 0, "Monster.doll_master", 20, 42, 75, "male", "L2RiftInvader", 40, 4229, 1673, 40.29, 3.09, 40, 43, 30, 21, 20, 10, 6258, 660, 1821, 334, 957, 425, 317, 150, 333, 0, 0, 0, 88, 181, "ssq_clan", 300, 1, 0, "LAST_HIT", 0, 0, 0, "fighter"),
(21758, 21758, "Dark Omen Invader Martyrs", 0, "", 0, "Monster.doll_master", 20, 42, 70, "male", "L2RiftInvader", 40, 3862, 1493, 35.55, 2.78, 40, 43, 30, 21, 20, 10, 5542, 549, 1150, 399, 780, 382, 317, 0, 333, 0, 0, 0, 88, 181, "ssq_clan", 300, 1, 0, "LAST_HIT", 0, 0, 0, "balanced"),
(21759, 21759, "Dark Omen Invader Warrior", 0, "", 0, "Monster2.imperial_warlord_zombie", 7, 30, 73, "male", "L2RiftInvader", 40, 4086, 1601, 40.29, 3.09, 40, 43, 30, 21, 20, 10, 5929, 610, 1463, 502, 885, 407, 278, 150, 333, 134, 6721, 0, 42, 181, "ssq_clan", 300, 1, 0, "LAST_HIT", 100, 0, 50, "fighter"),
(21760, 21760, "Dark Omen Invader Soldier", 0, "", 0, "Monster2.giant_zombie", 13, 40, 70, "male", "L2RiftInvader", 40, 3862, 1493, 35.55, 2.78, 40, 43, 30, 21, 20, 10, 5835, 578, 1314, 470, 780, 382, 278, 150, 333, 0, 0, 0, 22, 181, "ssq_clan", 300, 1, 0, "LAST_HIT", 0, 0, 0, "fighter"),
(21761, 21761, "Dark Omen Invader Disciple", 0, "", 0, "Monster2.imperial_warlord_zombie", 7, 30, 73, "male", "L2RiftInvader", 40, 4086, 1601, 40.29, 3.09, 40, 43, 30, 21, 20, 10, 6243, 642, 1463, 502, 885, 407, 278, 0, 333, 134, 6721, 0, 42, 181, "ssq_clan", 300, 1, 0, "LAST_HIT", 100, 0, 50, "fighter"),
(21762, 21762, "Dark Omen Invader Berserker", 0, "", 0, "Monster2.imperial_warlord_zombie", 7, 30, 75, "male", "L2RiftInvader", 40, 4229, 1673, 40.29, 3.09, 40, 43, 30, 21, 20, 10, 8198, 864, 1292, 633, 957, 425, 278, 150, 333, 134, 6721, 0, 42, 181, "ssq_clan", 300, 1, 0, "LAST_HIT", 100, 0, 50, "balanced"),
(21763, 21763, "Dark Omen Invader Food", 0, "", 0, "Monster.mimic", 8.5, 8.5, 70, "male", "L2Chest", 40, 3862, 1493, 11.85, 2.78, 40, 43, 30, 21, 20, 10, 7126, 707, 1314, 470, 780, 382, 278, 0, 333, 0, 0, 0, 88, 181, "ssq_clan", 300, 0, 0, "LAST_HIT", 0, 0, 0, "fighter"),
(21764, 21764, "Dark Omen Invader Elite Soldier", 0, "", 0, "Monster.death_blader", 15, 45, 75, "male", "L2RiftInvader", 40, 4229, 1673, 80.58, 3.09, 40, 43, 30, 21, 20, 10, 7343, 774, 1563, 523, 957, 425, 278, 150, 333, 1472, 0, 0, 110, 181, "ssq_clan", 300, 1, 0, "LAST_HIT", 100, 0, 50, "fighter"),
(21765, 21765, "Dark Omen Invader Elite Soldier", 0, "", 0, "Monster.death_blader", 15, 45, 75, "male", "L2RiftInvader", 40, 4229, 1673, 80.58, 3.09, 40, 43, 30, 21, 20, 10, 7482, 789, 1563, 523, 957, 425, 278, 150, 333, 1472, 0, 0, 110, 181, "ssq_clan", 300, 1, 0, "LAST_HIT", 100, 0, 50, "fighter"),
(21766, 21766, "Dark Omen Invader Elite Soldier", 0, "", 0, "Monster.death_blader", 15, 45, 75, "male", "L2RiftInvader", 40, 4229, 1673, 3.36, 3.09, 40, 43, 30, 21, 20, 10, 7002, 740, 1563, 523, 957, 425, 278, 0, 333, 1472, 0, 0, 110, 181, "ssq_clan", 300, 1, 0, "LAST_HIT", 100, 0, 50, "fighter"),
(21767, 21767, "Dark Omen Invader Elite Soldier", 0, "", 0, "Monster.death_blader", 15, 45, 70, "male", "L2RiftInvader", 40, 3862, 1493, 5.93, 2.78, 40, 43, 30, 21, 20, 10, 8466, 840, 1314, 470, 780, 382, 278, 0, 333, 1472, 0, 0, 110, 181, "ssq_clan", 300, 1, 0, "LAST_HIT", 100, 0, 50, "fighter"),
(21768, 21768, "Dark Omen Invader Warrior", 0, "", 0, "Monster2.imperial_warlord_zombie", 7, 30, 73, "male", "L2RiftInvader", 40, 4086, 1601, 80.58, 3.09, 40, 43, 30, 21, 20, 10, 7108, 731, 1463, 502, 885, 407, 278, 150, 333, 134, 6721, 0, 42, 181, "ssq_clan", 300, 1, 0, "LAST_HIT", 100, 0, 50, "fighter"),
(21769, 21769, "Dark Omen Invader Elite Soldier", 0, "", 0, "Monster.death_blader", 15, 45, 70, "male", "L2RiftInvader", 40, 3862, 1493, 71.1, 2.78, 40, 43, 30, 21, 20, 10, 6341, 628, 1086, 569, 780, 382, 278, 150, 333, 1472, 0, 0, 110, 181, "ssq_clan", 300, 1, 0, "LAST_HIT", 100, 0, 50, "balanced"),
(21770, 21770, "Dark Omen Invader Elite Soldier", 0, "", 0, "Monster.death_blader", 15, 45, 73, "male", "L2RiftInvader", 40, 4086, 1601, 80.58, 3.09, 40, 43, 30, 21, 20, 10, 6896, 709, 1770, 415, 885, 407, 278, 150, 333, 1472, 0, 0, 110, 181, "ssq_clan", 300, 1, 0, "LAST_HIT", 100, 0, 50, "fighter"),
(21771, 21771, "Dark Omen Invader Elite Soldier", 0, "", 0, "Monster.death_blader", 15, 45, 70, "male", "L2RiftInvader", 40, 3862, 1493, 71.1, 2.78, 40, 43, 30, 21, 20, 10, 6251, 619, 1086, 569, 780, 382, 278, 150, 333, 1472, 0, 0, 110, 181, "ssq_clan", 300, 1, 0, "LAST_HIT", 100, 0, 50, "balanced"),
(21772, 21772, "Dark Omen Invader Elite Soldier", 0, "", 0, "Monster.death_blader", 15, 45, 75, "male", "L2RiftInvader", 40, 4229, 1673, 80.58, 3.09, 40, 43, 30, 21, 20, 10, 7176, 757, 1892, 432, 957, 425, 278, 150, 333, 1472, 0, 0, 110, 181, "ssq_clan", 300, 1, 0, "LAST_HIT", 100, 0, 50, "fighter"),
(21773, 21773, "Dark Omen Invader Magus", 0, "", 0, "Monster.doll_master", 20, 42, 73, "male", "L2RiftInvader", 40, 4086, 1601, 80.58, 3.09, 40, 43, 30, 21, 20, 10, 6575, 676, 1280, 426, 885, 407, 317, 0, 333, 0, 0, 0, 88, 181, "ssq_clan", 300, 1, 0, "LAST_HIT", 0, 0, 0, "balanced"),
(21774, 21774, "Messenger Invader Soldier", 0, "", 0, "Monster2.giant_zombie", 13, 40, 80, "male", "L2RiftInvader", 40, 4550, 1859, 40.29, 3.09, 40, 43, 30, 21, 20, 10, 10362, 1163, 1814, 576, 1144, 468, 278, 0, 333, 0, 0, 0, 22, 181, "ssq_clan", 300, 1, 0, "LAST_HIT", 0, 0, 0, "fighter"),
(21775, 21775, "Messenger Invader Soldier", 0, "", 0, "Monster2.giant_zombie", 13, 40, 80, "male", "L2RiftInvader", 40, 4813, 2049, 40.29, 3.09, 40, 43, 30, 21, 20, 10, 12230, 1455, 1542, 837, 1333, 511, 278, 150, 333, 0, 0, 0, 22, 181, "ssq_clan", 300, 1, 0, "LAST_HIT", 0, 0, 0, "balanced"),
(21776, 21776, "Messenger Invader Archer", 0, "", 0, "Monster.skeleton_archer", 11, 27, 80, "male", "L2RiftInvader", 500, 4716, 1972, 40.29, 3.09, 40, 43, 30, 21, 20, 10, 9442, 1097, 5796, 388, 1258, 494, 249, 150, 333, 289, 0, 0, 44, 181, "ssq_clan", 300, 1, 0, "LAST_HIT", 100, 0, 50, "archer"),
(21777, 21777, "Messenger Invader Elite Soldier", 0, "", 0, "Monster.doll_master", 20, 42, 80, "male", "L2RiftInvader", 40, 4813, 2049, 40.29, 3.09, 40, 43, 30, 21, 20, 10, 10179, 1211, 1796, 535, 1333, 511, 317, 150, 333, 0, 0, 0, 88, 181, "ssq_clan", 300, 1, 0, "LAST_HIT", 0, 0, 0, "balanced"),
(21778, 21778, "Messenger Invader Shaman", 0, "", 0, "Monster.doll_master", 20, 42, 80, "male", "L2RiftInvader", 40, 4716, 1972, 40.29, 3.09, 40, 43, 30, 21, 20, 10, 11921, 1386, 1714, 517, 1258, 494, 317, 150, 333, 0, 0, 0, 88, 181, "ssq_clan", 300, 1, 0, "LAST_HIT", 0, 0, 0, "balanced"),
(21779, 21779, "Messenger Invader Priest", 0, "", 0, "Monster.doll_master", 20, 42, 80, "male", "L2RiftInvader", 40, 4550, 1859, 26.86, 3.09, 40, 43, 30, 21, 20, 10, 10747, 1206, 1587, 490, 1144, 468, 317, 0, 333, 0, 0, 0, 88, 181, "ssq_clan", 300, 1, 0, "LAST_HIT", 0, 0, 0, "balanced"),
(21780, 21780, "Messenger Invader Magus", 0, "", 0, "Monster.doll_master", 20, 42, 80, "male", "L2RiftInvader", 40, 4813, 2049, 40.29, 3.09, 40, 43, 30, 21, 20, 10, 8038, 957, 2390, 402, 1333, 511, 317, 150, 333, 0, 0, 0, 88, 181, "ssq_clan", 300, 1, 0, "LAST_HIT", 0, 0, 0, "fighter"),
(21781, 21781, "Messenger Invader Martyrs", 0, "", 0, "Monster.doll_master", 20, 42, 80, "male", "L2RiftInvader", 40, 4550, 1859, 40.29, 3.09, 40, 43, 30, 21, 20, 10, 7239, 812, 1587, 490, 1144, 468, 317, 0, 333, 0, 0, 0, 88, 181, "ssq_clan", 300, 1, 0, "LAST_HIT", 0, 0, 0, "balanced"),
(21782, 21782, "Messenger Invader Warrior", 0, "", 0, "Monster2.imperial_warlord_zombie", 7, 30, 80, "male", "L2RiftInvader", 40, 4716, 1972, 40.29, 3.09, 40, 43, 30, 21, 20, 10, 7664, 891, 1959, 608, 1258, 494, 278, 150, 333, 134, 6721, 0, 42, 181, "ssq_clan", 300, 1, 0, "LAST_HIT", 100, 0, 50, "fighter"),
(21783, 21783, "Messenger Invader Soldier", 0, "", 0, "Monster2.giant_zombie", 13, 40, 80, "male", "L2RiftInvader", 40, 4550, 1859, 40.29, 3.09, 40, 43, 30, 21, 20, 10, 7621, 855, 1814, 576, 1144, 468, 278, 150, 333, 0, 0, 0, 22, 181, "ssq_clan", 300, 1, 0, "LAST_HIT", 0, 0, 0, "fighter"),
(21784, 21784, "Messenger Invader Disciple", 0, "", 0, "Monster2.imperial_warlord_zombie", 7, 30, 80, "male", "L2RiftInvader", 40, 4716, 1972, 40.29, 3.09, 40, 43, 30, 21, 20, 10, 8071, 938, 1959, 608, 1258, 494, 278, 0, 333, 134, 6721, 0, 42, 181, "ssq_clan", 300, 1, 0, "LAST_HIT", 100, 0, 50, "fighter"),
(21785, 21785, "Messenger Invader Berserker", 0, "", 0, "Monster2.imperial_warlord_zombie", 7, 30, 80, "male", "L2RiftInvader", 40, 4813, 2049, 40.29, 3.09, 40, 43, 30, 21, 20, 10, 10530, 1253, 1696, 761, 1333, 511, 278, 150, 333, 134, 6721, 0, 42, 181, "ssq_clan", 300, 1, 0, "LAST_HIT", 100, 0, 50, "balanced"),
(21786, 21786, "Messenger Invader Food", 0, "", 0, "Monster.mimic", 8.5, 8.5, 80, "male", "L2Chest", 40, 4550, 1859, 13.43, 3.09, 40, 43, 30, 21, 20, 10, 9308, 1045, 1814, 576, 1144, 468, 278, 0, 333, 0, 0, 0, 80, 165, "ssq_clan", 300, 0, 0, "LAST_HIT", 0, 0, 0, "fighter"),
(21787, 21787, "Messenger Invader Elite Soldier", 0, "", 0, "Monster.death_lord", 21, 40, 80, "male", "L2RiftInvader", 40, 4813, 2049, 80.58, 3.09, 40, 43, 30, 21, 20, 10, 9432, 1122, 2052, 629, 1333, 511, 278, 150, 333, 78, 0, 0, 40, 165, "ssq_clan", 300, 1, 0, "LAST_HIT", 100, 0, 50, "fighter"),
(21788, 21788, "Messenger Invader Elite Soldier", 0, "", 0, "Monster.death_lord", 21, 40, 80, "male", "L2RiftInvader", 40, 4813, 2049, 80.58, 3.09, 40, 43, 30, 21, 20, 10, 9610, 1144, 2052, 629, 1333, 511, 278, 150, 333, 78, 0, 0, 40, 165, "ssq_clan", 300, 1, 0, "LAST_HIT", 100, 0, 50, "fighter"),
(21789, 21789, "Messenger Invader Elite Soldier", 0, "", 0, "Monster.death_lord", 21, 40, 80, "male", "L2RiftInvader", 40, 4813, 2049, 3.36, 3.09, 40, 43, 30, 21, 20, 10, 8994, 1072, 2052, 629, 1333, 511, 278, 0, 333, 78, 0, 0, 44, 181, "ssq_clan", 300, 1, 0, "LAST_HIT", 100, 0, 50, "fighter"),
(21790, 21790, "Messenger Invader Elite Soldier", 0, "", 0, "Monster.death_lord", 21, 40, 80, "male", "L2RiftInvader", 40, 4550, 1859, 6.72, 3.09, 40, 43, 30, 21, 20, 10, 11058, 1242, 1814, 576, 1144, 468, 278, 0, 333, 78, 0, 0, 44, 181, "ssq_clan", 300, 1, 0, "LAST_HIT", 100, 0, 50, "fighter"),
(21791, 21791, "Messenger Invader Warrior", 0, "", 0, "Monster2.imperial_warlord_zombie", 7, 30, 80, "male", "L2RiftInvader", 40, 4716, 1972, 80.58, 3.09, 40, 43, 30, 21, 20, 10, 9189, 1068, 1959, 608, 1258, 494, 278, 150, 333, 134, 6721, 0, 42, 181, "ssq_clan", 300, 1, 0, "LAST_HIT", 100, 0, 50, "fighter"),
(21792, 21792, "Messenger Invader Elite Soldier", 0, "", 0, "Monster.death_lord", 21, 40, 80, "male", "L2RiftInvader", 40, 4550, 1859, 80.58, 3.09, 40, 43, 30, 21, 20, 10, 8282, 929, 1499, 698, 1144, 468, 278, 150, 333, 78, 0, 0, 44, 181, "ssq_clan", 300, 1, 0, "LAST_HIT", 100, 0, 50, "balanced"),
(21793, 21793, "Messenger Invader Elite Soldier", 0, "", 0, "Monster.death_lord", 21, 40, 80, "male", "L2RiftInvader", 40, 4716, 1972, 80.58, 3.09, 40, 43, 30, 21, 20, 10, 8915, 1036, 2371, 503, 1258, 494, 278, 150, 333, 78, 0, 0, 44, 181, "ssq_clan", 300, 1, 0, "LAST_HIT", 100, 0, 50, "fighter"),
(21794, 21794, "Messenger Invader Elite Soldier", 0, "", 0, "Monster.death_lord", 21, 40, 80, "male", "L2RiftInvader", 40, 4550, 1859, 80.58, 3.09, 40, 43, 30, 21, 20, 10, 8165, 916, 1499, 698, 1144, 468, 278, 150, 333, 78, 0, 0, 44, 181, "ssq_clan", 300, 1, 0, "LAST_HIT", 100, 0, 50, "balanced"),
(21795, 21795, "Messenger Invader Elite Soldier", 0, "", 0, "Monster.death_lord", 21, 40, 80, "male", "L2RiftInvader", 40, 4813, 2049, 80.58, 3.09, 40, 43, 30, 21, 20, 10, 9217, 1097, 2483, 520, 1333, 511, 278, 150, 333, 78, 0, 0, 44, 181, "ssq_clan", 300, 1, 0, "LAST_HIT", 100, 0, 50, "fighter"),
(21796, 21796, "Messenger Invader Magus", 0, "", 0, "Monster.doll_master", 20, 42, 80, "male", "L2RiftInvader", 40, 4716, 1972, 80.58, 3.09, 40, 43, 30, 21, 20, 10, 8499, 988, 1714, 517, 1258, 494, 317, 0, 333, 0, 0, 0, 88, 181, "ssq_clan", 300, 1, 0, "LAST_HIT", 0, 0, 0, "mage"),
(21797, 21797, "Spirit of Timiniel", 0, "", 0, "Monster.pixy", 5, 25, 55, "female", "L2Monster", 40, 2643, 987, 5.14, 2.45, 40, 43, 30, 21, 20, 10, 3959, 320, 554, 331, 360, 261, 278, 0, 333, 0, 0, 0, 88, 181, "timiniel__mob_clan", 300, 0, 0, "LAST_HIT", 0, 0, 0, "fighter"),
(21798, 21798, "Ghost of a Gatekeeper", 0, "", 0, "Monster.skeleton_knight", 10, 25, 76, "male", "L2Monster", 40, 4297, 1710, 26.86, 3.09, 40, 43, 30, 21, 20, 10, 7104, 759, 1614, 534, 994, 433, 278, 0, 333, 150, 103, 0, 40, 165, "NULL", 0, 1, 0, "LAST_HIT", 0, 0, 0, "fighter"),
(21799, 21799, "Ghost of a Gatekeeper", 0, "", 0, "Monster.skeleton_knight", 10, 25, 76, "male", "L2Monster", 40, 4297, 1710, 40.29, 3.09, 40, 43, 30, 21, 20, 10, 8710, 931, 1614, 534, 994, 433, 278, 0, 432, 150, 103, 0, 40, 165, "NULL", 0, 1, 0, "LAST_HIT", 0, 0, 0, "fighter"),
(21800, 21800, "Vassal Ghost", 0, "", 0, "Monster.zombie", 13, 21, 77, "male", "L2Monster", 40, 4364, 1747, 26.86, 3.09, 40, 43, 30, 21, 20, 10, 6616, 716, 1664, 544, 1031, 442, 278, 0, 333, 0, 0, 0, 15, 15, "NULL", 0, 1, 0, "LAST_HIT", 0, 0, 0, "fighter"),
(21801, 21801, "Treasure Chest", 0, "", 0, "Monster.mimic", 8.5, 8.5, 21, "male", "L2Chest", 40, 575, 227, 5.53, 1.53, 40, 43, 30, 21, 20, 10, 630, 29, 63, 98, 25, 80, 278, 0, 333, 0, 0, 0, 80, 165, "NULL", 0, 0, 0, "LAST_HIT", 0, 0, 0, "fighter"),
(21802, 21802, "Treasure Chest", 0, "", 0, "Monster.mimic", 8.5, 8.5, 24, "male", "L2Chest", 40, 687, 272, 5.53, 1.53, 40, 43, 30, 21, 20, 10, 771, 38, 81, 111, 34, 90, 278, 0, 333, 0, 0, 0, 80, 165, "NULL", 0, 0, 0, "LAST_HIT", 0, 0, 0, "fighter"),
(21803, 21803, "Treasure Chest", 0, "", 0, "Monster.mimic", 8.5, 8.5, 27, "male", "L2Chest", 40, 813, 318, 5.53, 1.53, 40, 43, 30, 21, 20, 10, 918, 47, 104, 125, 45, 102, 278, 0, 333, 0, 0, 0, 80, 165, "NULL", 0, 0, 0, "LAST_HIT", 0, 0, 0, "fighter"),
(21804, 21804, "Treasure Chest", 0, "", 0, "Monster.mimic", 8.5, 8.5, 30, "male", "L2Chest", 40, 954, 365, 5.53, 1.53, 40, 43, 30, 21, 20, 10, 1080, 59, 132, 140, 58, 114, 278, 0, 333, 0, 0, 0, 80, 165, "NULL", 0, 0, 0, "LAST_HIT", 0, 0, 0, "fighter"),
(21805, 21805, "Treasure Chest", 0, "", 0, "Monster.mimic", 8.5, 8.5, 33, "male", "L2Chest", 40, 1109, 413, 7.11, 1.84, 40, 43, 30, 21, 20, 10, 1306, 75, 166, 157, 75, 128, 278, 0, 333, 0, 0, 0, 80, 165, "NULL", 0, 0, 0, "LAST_HIT", 0, 0, 0, "fighter"),
(21806, 21806, "Treasure Chest", 0, "", 0, "Monster.mimic", 8.5, 8.5, 36, "male", "L2Chest", 40, 1279, 463, 7.11, 1.84, 40, 43, 30, 21, 20, 10, 1555, 94, 206, 175, 96, 142, 278, 0, 333, 0, 0, 0, 80, 165, "NULL", 0, 0, 0, "LAST_HIT", 0, 0, 0, "fighter"),
(21807, 21807, "Treasure Chest", 0, "", 0, "Monster.mimic", 8.5, 8.5, 39, "male", "L2Chest", 40, 1462, 514, 7.11, 1.84, 40, 43, 30, 21, 20, 10, 1825, 116, 255, 195, 121, 158, 278, 0, 333, 0, 0, 0, 80, 165, "NULL", 0, 0, 0, "LAST_HIT", 0, 0, 0, "fighter"),
(21808, 21808, "Treasure Chest", 0, "", 0, "Monster.mimic", 8.5, 8.5, 42, "male", "L2Chest", 40, 1660, 589, 8.69, 2.14, 40, 43, 30, 21, 20, 10, 2116, 141, 311, 215, 152, 175, 278, 0, 333, 0, 0, 0, 80, 165, "NULL", 0, 0, 0, "LAST_HIT", 0, 0, 0, "fighter"),
(21809, 21809, "Treasure Chest", 0, "", 0, "Monster.mimic", 8.5, 8.5, 45, "male", "L2Chest", 40, 1870, 677, 8.69, 2.14, 40, 43, 30, 21, 20, 10, 2430, 169, 377, 238, 188, 193, 278, 0, 333, 0, 0, 0, 80, 165, "NULL", 0, 0, 0, "LAST_HIT", 0, 0, 0, "fighter"),
(21810, 21810, "Treasure Chest", 0, "", 0, "Monster.mimic", 8.5, 8.5, 48, "male", "L2Chest", 40, 2091, 768, 8.69, 2.14, 40, 43, 30, 21, 20, 10, 2764, 202, 453, 261, 231, 212, 278, 0, 333, 0, 0, 0, 80, 165, "NULL", 0, 0, 0, "LAST_HIT", 0, 0, 0, "fighter"),
(21811, 21811, "Treasure Chest", 0, "", 0, "Monster.mimic", 8.5, 8.5, 51, "male", "L2Chest", 40, 2323, 861, 10.27, 2.45, 40, 43, 30, 21, 20, 10, 3121, 238, 539, 286, 281, 232, 278, 0, 333, 0, 0, 0, 80, 165, "NULL", 0, 0, 0, "LAST_HIT", 0, 0, 0, "fighter"),
(21812, 21812, "Treasure Chest", 0, "", 0, "Monster.mimic", 8.5, 8.5, 54, "male", "L2Chest", 40, 2562, 955, 10.27, 2.45, 40, 43, 30, 21, 20, 10, 3499, 279, 636, 313, 339, 254, 278, 0, 333, 0, 0, 0, 80, 165, "NULL", 0, 0, 0, "LAST_HIT", 0, 0, 0, "fighter"),
(21813, 21813, "Treasure Chest", 0, "", 0, "Monster.mimic", 8.5, 8.5, 57, "male", "L2Chest", 40, 2806, 1052, 10.27, 2.45, 40, 43, 30, 21, 20, 10, 3898, 324, 743, 340, 405, 276, 278, 0, 333, 0, 0, 0, 80, 165, "NULL", 0, 0, 0, "LAST_HIT", 0, 0, 0, "fighter"),
(21814, 21814, "Treasure Chest", 0, "", 0, "Monster.mimic", 8.5, 8.5, 60, "male", "L2Chest", 40, 3054, 1150, 10.27, 2.45, 40, 43, 30, 21, 20, 10, 4320, 375, 860, 368, 478, 299, 278, 0, 333, 0, 0, 0, 80, 165, "NULL", 0, 0, 0, "LAST_HIT", 0, 0, 0, "fighter"),
(21815, 21815, "Treasure Chest", 0, "", 0, "Monster.mimic", 8.5, 8.5, 63, "male", "L2Chest", 40, 3302, 1251, 11.85, 2.78, 40, 43, 30, 21, 20, 10, 4762, 430, 987, 398, 560, 323, 278, 0, 333, 0, 0, 0, 80, 165, "NULL", 0, 0, 0, "LAST_HIT", 0, 0, 0, "fighter"),
(21816, 21816, "Treasure Chest", 0, "", 0, "Monster.mimic", 8.5, 8.5, 66, "male", "L2Chest", 40, 3546, 1353, 11.85, 2.78, 40, 43, 30, 21, 20, 10, 5227, 492, 1123, 428, 649, 348, 278, 0, 333, 0, 0, 0, 80, 165, "NULL", 0, 0, 0, "LAST_HIT", 0, 0, 0, "fighter"),
(21817, 21817, "Treasure Chest", 0, "", 0, "Monster.mimic", 8.5, 8.5, 69, "male", "L2Chest", 40, 3784, 1458, 11.85, 2.78, 40, 43, 30, 21, 20, 10, 5713, 559, 1265, 460, 746, 373, 278, 0, 333, 0, 0, 0, 80, 165, "NULL", 0, 0, 0, "LAST_HIT", 0, 0, 0, "fighter"),
(21818, 21818, "Treasure Chest", 0, "", 0, "Monster.mimic", 8.5, 8.5, 72, "male", "L2Chest", 40, 4013, 1565, 13.43, 3.09, 40, 43, 30, 21, 20, 10, 6220, 632, 1413, 491, 849, 399, 278, 0, 333, 0, 0, 0, 80, 165, "NULL", 0, 0, 0, "LAST_HIT", 0, 0, 0, "fighter"),
(21819, 21819, "Treasure Chest", 0, "", 0, "Monster.mimic", 8.5, 8.5, 75, "male", "L2Chest", 40, 4229, 1673, 13.43, 3.09, 40, 43, 30, 21, 20, 10, 6750, 712, 1563, 523, 957, 425, 278, 0, 333, 0, 0, 0, 88, 181, "NULL", 0, 0, 0, "LAST_HIT", 0, 0, 0, "fighter"),
(21820, 21820, "Treasure Chest", 0, "", 0, "Monster.mimic", 8.5, 8.5, 78, "male", "L2Chest", 40, 4428, 1784, 13.43, 3.09, 40, 43, 30, 21, 20, 10, 7300, 799, 1715, 555, 1069, 451, 278, 0, 333, 0, 0, 0, 80, 165, "NULL", 0, 0, 0, "LAST_HIT", 0, 0, 0, "fighter"),
(21821, 21821, "Treasure Chest", 0, "", 0, "Monster.mimic", 8.5, 8.5, 81, "male", "L2Chest", 40, 4608, 1896, 13.43, 3.09, 40, 43, 30, 21, 20, 10, 7873, 894, 1863, 587, 1182, 477, 278, 0, 333, 0, 0, 0, 80, 165, "NULL", 0, 0, 0, "LAST_HIT", 0, 0, 0, "fighter"),
(21822, 21822, "Treasure Chest", 0, "", 0, "Monster.mimic", 8.5, 8.5, 84, "male", "L2Chest", 40, 4766, 2011, 13.43, 3.09, 40, 43, 30, 21, 20, 10, 8467, 996, 2006, 619, 1296, 502, 278, 0, 333, 0, 0, 0, 80, 165, "NULL", 0, 0, 0, "LAST_HIT", 0, 0, 0, "fighter"),
(21823, 21823, "Executor of Sacrificial Offerings", 0, "", 0, "Monster2.imperial_warlord_zombie", 7, 30, 80, "male", "L2Monster", 40, 4550, 1859, 80.58, 3.09, 40, 43, 30, 21, 20, 10, 12042, 1351, 1814, 576, 1144, 468, 278, 0, 333, 134, 6721, 0, 42, 209, "tomb_clan", 300, 1, 0, "LAST_HIT", 0, 0, 0, "fighter"),
(21824, 21824, "Alpen Kookaburra", 0, "", 0, "Monster2.rough_ostrich", 20, 31, 65, "male", "L2FeedableBeast", 80, 13862, 9999, 13.43, 3.09, 40, 43, 30, 21, 20, 10, 0, 0, 1392, 5000, 746, 6000, 300, 0, 333, 0, 0, 0, 88, 132, "NULL", 0, 0, 0, "LAST_HIT", 0, 0, 0, "fighter"),
(21825, 21825, "Alpen Kookaburra", 0, "", 0, "Monster2.rough_ostrich", 20, 31, 65, "male", "L2FeedableBeast", 80, 13862, 9999, 13.43, 3.09, 40, 43, 30, 21, 20, 10, 0, 0, 1392, 5000, 746, 6000, 300, 0, 333, 0, 0, 0, 88, 132, "NULL", 0, 0, 0, "LAST_HIT", 0, 0, 0, "fighter"),
(21826, 21826, "Alpen Buffalo", 0, "", 0, "Monster2.buffalo", 20, 31, 67, "male", "L2FeedableBeast", 80, 14507, 9999, 13.43, 3.09, 40, 43, 30, 21, 20, 10, 0, 0, 1392, 5000, 746, 6000, 300, 0, 333, 0, 0, 0, 88, 132, "NULL", 0, 0, 0, "LAST_HIT", 0, 0, 0, "fighter"),
(21827, 21827, "Alpen Buffalo", 0, "", 0, "Monster2.buffalo", 20, 31, 67, "male", "L2FeedableBeast", 80, 14507, 9999, 13.43, 3.09, 40, 43, 30, 21, 20, 10, 0, 0, 1392, 5000, 746, 6000, 300, 0, 333, 0, 0, 0, 88, 132, "NULL", 0, 0, 0, "LAST_HIT", 0, 0, 0, "fighter"),
(21828, 21828, "Alpen Cougar", 0, "", 0, "Monster.saber_toothed_tiger", 20, 31, 69, "male", "L2FeedableBeast", 80, 15139, 9999, 13.43, 3.09, 40, 43, 30, 21, 20, 10, 0, 0, 1392, 5000, 746, 6000, 300, 0, 333, 0, 0, 0, 88, 132, "NULL", 0, 0, 0, "LAST_HIT", 0, 0, 0, "fighter"),
(21829, 21829, "Alpen Cougar", 0, "", 0, "Monster.saber_toothed_tiger", 20, 31, 69, "male", "L2FeedableBeast", 80, 15139, 9999, 13.43, 3.09, 40, 43, 30, 21, 20, 10, 0, 0, 1392, 5000, 746, 6000, 300, 0, 333, 0, 0, 0, 88, 132, "NULL", 0, 0, 0, "LAST_HIT", 0, 0, 0, "fighter");

INSERT INTO `npc` VALUES
(22001, 22001, "Grim Wolf", 0, "", 0, "Monster.dire_wolf", 13, 11, 25, "male", "L2Monster", 80, 728, 316, 5.53, 1.53, 40, 43, 30, 21, 20, 10, 1199, 60, 99, 112, 37, 94, 278, 0, 333, 0, 0, 0, 24, 130, "NULL", 0, 0, 0, "LAST_HIT", 0, 0, 0, "fighter"),
(22002, 22002, "Grim Grizzly", 0, "", 0, "Monster.grizzly", 21, 40, 26, "male", "L2Monster", 80, 770, 333, 5.53, 1.53, 40, 43, 30, 21, 20, 10, 879, 44, 115, 114, 41, 98, 278, 0, 333, 0, 0, 0, 40, 110, "NULL", 0, 0, 0, "LAST_HIT", 0, 0, 0, "fighter"),
(22003, 22003, "Grave Robber Scout", 0, "", 0, "NPC.e_traderB_Fdwarf_mon", 7, 18, 27, "male", "L2Monster", 80, 814, 350, 5.53, 1.53, 40, 43, 30, 21, 20, 10, 1032, 53, 113, 119, 45, 102, 247, 0, 333, 8527, 0, 0, 49, 110, "NULL", 0, 0, 0, "LAST_HIT", 0, 0, 0, "fighter"),
(22004, 22004, "Grave Robber Lookout", 0, "", 0, "Monster.dwarf_ghost", 9, 16.5, 27, "male", "L2Monster", 80, 814, 350, 5.53, 1.53, 40, 43, 30, 21, 20, 10, 1032, 53, 113, 119, 45, 102, 278, 0, 333, 0, 0, 0, 80, 120, "NULL", 0, 0, 0, "LAST_HIT", 0, 0, 0, "fighter"),
(22005, 22005, "Grave Robber Ranger", 0, "", 0, "NPC.e_collector_teacher_Fdwarf_mon", 8, 17.5, 28, "male", "L2Monster", 80, 859, 367, 5.53, 1.53, 40, 43, 30, 21, 20, 10, 1664, 87, 133, 130, 49, 106, 317, 0, 333, 8529, 0, 0, 45, 110, "NULL", 0, 0, 0, "LAST_HIT", 0, 0, 0, "fighter"),
(22006, 22006, "Grave Robber Guard", 0, "", 0, "NPC.e_collector_teacher_Mdwarf_mon", 8, 17.5, 29, "male", "L2Monster", 80, 906, 384, 5.53, 1.53, 40, 43, 30, 21, 20, 10, 1340, 72, 146, 137, 53, 110, 278, 500, 333, 8528, 0, 0, 36, 110, "NULL", 0, 0, 0, "LAST_HIT", 0, 0, 0, "fighter"),
(22007, 22007, "Ghost of a Soldier", 0, "", 0, "Monster.orc", 10, 21, 29, "male", "L2Monster", 80, 906, 384, 5.53, 1.53, 40, 43, 30, 21, 20, 10, 1340, 72, 146, 137, 53, 110, 278, 0, 333, 8530, 0, 0, 45, 120, "NULL", 0, 0, 0, "LAST_HIT", 0, 0, 0, "fighter"),
(22008, 22008, "Grave Robber Fighter", 0, "", 0, "NPC.e_collector_teacher_Mdwarf_mon", 8, 17.5, 30, "male", "L2Monster", 80, 954, 402, 5.53, 1.53, 40, 43, 30, 21, 20, 10, 1281, 70, 130, 137, 58, 114, 278, 0, 333, 8528, 0, 0, 36, 110, "NULL", 0, 0, 0, "LAST_HIT", 0, 0, 0, "fighter"),
(22009, 22009, "Ghost of a Loyal Vassal", 0, "", 0, "Monster.orc_shaman", 9, 22, 31, "male", "L2Monster", 80, 1005, 419, 7.11, 1.84, 40, 43, 30, 21, 20, 10, 1404, 78, 140, 146, 64, 118, 278, 0, 333, 8532, 0, 0, 45, 120, "NULL", 0, 0, 0, "LAST_HIT", 0, 0, 0, "balanced"),
(22010, 22010, "Ghost of a General", 0, "", 0, "Monster.orc_fighter", 12, 22, 32, "male", "L2Monster", 80, 1056, 437, 7.11, 1.84, 40, 43, 30, 21, 20, 10, 1449, 81, 185, 147, 69, 123, 278, 500, 333, 8532, 0, 0, 45, 120, "NULL", 0, 0, 0, "LAST_HIT", 0, 0, 0, "fighter"),
(22011, 22011, "Ghost of a Batur Chief", 0, "", 0, "Monster.orc_champion", 10, 23, 33, "male", "L2Monster", 80, 1109, 455, 7.11, 1.84, 40, 43, 30, 21, 20, 10, 1515, 87, 191, 149, 75, 128, 278, 500, 333, 8533, 0, 0, 45, 130, "NULL", 0, 0, 0, "LAST_HIT", 0, 0, 0, "fighter"),
(22012, 22012, "Ghost of a Batur Chief", 0, "", 0, "Monster.orc_champion", 10, 23, 33, "male", "L2Monster", 80, 1109, 455, 7.11, 1.84, 40, 43, 30, 21, 20, 10, 1515, 87, 191, 149, 75, 128, 278, 500, 333, 8533, 0, 0, 45, 130, "NULL", 0, 0, 0, "LAST_HIT", 0, 0, 0, "fighter"),
(22013, 22013, "Ghost of a Morek Chief", 0, "", 0, "Monster.orc_champion", 10, 23, 33, "male", "L2Monster", 80, 1109, 455, 7.11, 1.84, 40, 43, 30, 21, 20, 10, 1515, 87, 191, 149, 75, 128, 278, 500, 333, 8533, 0, 0, 45, 130, "NULL", 0, 0, 0, "LAST_HIT", 0, 0, 0, "fighter"),
(22014, 22014, "Ghost of a Morek Chief", 0, "", 0, "Monster.orc_champion", 10, 23, 33, "male", "L2Monster", 80, 1109, 455, 7.11, 1.84, 40, 43, 30, 21, 20, 10, 1515, 87, 191, 149, 75, 128, 278, 500, 333, 8533, 0, 0, 45, 130, "NULL", 0, 0, 0, "LAST_HIT", 0, 0, 0, "fighter"),
(22015, 22015, "Ghost of a Turka Chief", 0, "", 0, "Monster.orc_champion", 10, 23, 33, "male", "L2Monster", 80, 1109, 455, 7.11, 1.84, 40, 43, 30, 21, 20, 10, 1515, 87, 191, 149, 75, 128, 278, 500, 333, 8533, 0, 0, 45, 130, "NULL", 0, 0, 0, "LAST_HIT", 0, 0, 0, "fighter"),
(22016, 22016, "Ghost of a Turka Chief", 0, "", 0, "Monster.orc_champion", 10, 23, 33, "male", "L2Monster", 80, 1109, 455, 7.11, 1.84, 40, 43, 30, 21, 20, 10, 1515, 87, 191, 149, 75, 128, 278, 500, 333, 8533, 0, 0, 45, 130, "NULL", 0, 0, 0, "LAST_HIT", 0, 0, 0, "fighter"),
(22017, 22017, "Bandit Sweeper", 0, "", 0, "Monster2.northern_goblin", 4, 15, 30, "male", "L2Monster", 80, 954, 402, 5.53, 1.53, 40, 43, 30, 21, 20, 10, 1281, 70, 130, 137, 58, 114, 278, 500, 333, 0, 0, 0, 88, 132, "NULL", 0, 0, 0, "LAST_HIT", 0, 0, 0, "fighter"),
(22018, 22018, "Bandit Hound", 0, "", 0, "Monster.dire_wolf", 13, 11, 31, "male", "L2Monster", 80, 1005, 419, 7.11, 1.84, 40, 43, 30, 21, 20, 10, 1404, 78, 140, 146, 64, 118, 278, 500, 333, 0, 0, 0, 88, 132, "NULL", 0, 0, 0, "LAST_HIT", 0, 0, 0, "fighter"),
(22019, 22019, "Bandit Watchman", 0, "", 0, "Monster.ol_mahum_archer_04te", 20, 23, 32, "male", "L2Monster", 80, 1056, 437, 7.11, 1.84, 40, 43, 30, 21, 20, 10, 1449, 81, 185, 147, 69, 123, 278, 0, 333, 0, 0, 0, 88, 132, "NULL", 0, 0, 0, "LAST_HIT", 0, 0, 0, "archer"),
(22020, 22020, "Snow Lynx", 0, "", 0, "Monster.onyx_beast", 14, 14.5, 33, "male", "L2Monster", 80, 1109, 455, 7.11, 1.84, 40, 43, 30, 21, 20, 10, 1515, 87, 191, 149, 75, 128, 278, 0, 333, 0, 0, 0, 88, 132, "NULL", 0, 0, 0, "LAST_HIT", 0, 0, 0, "fighter"),
(22021, 22021, "Bandit Undertaker", 0, "", 0, "Monster2.northern_goblin_110p", 20, 23, 34, "male", "L2Monster", 80, 1164, 473, 7.11, 1.84, 40, 43, 30, 21, 20, 10, 1593, 93, 203, 150, 82, 132, 278, 0, 333, 0, 0, 0, 88, 132, "NULL", 0, 0, 0, "LAST_HIT", 0, 0, 0, "fighter"),
(22022, 22022, "Bandit Assassin", 0, "", 0, "Monster.wererat_01te", 20, 23, 35, "male", "L2Monster", 80, 1221, 491, 7.11, 1.84, 40, 43, 30, 21, 20, 10, 1735, 103, 199, 161, 89, 137, 278, 500, 333, 0, 0, 0, 88, 132, "NULL", 0, 0, 0, "LAST_HIT", 0, 0, 0, "fighter"),
(22023, 22023, "Bandit Warrior", 0, "", 0, "Monster.ol_mahum_04te", 20, 23, 36, "male", "L2Monster", 80, 1279, 509, 7.11, 1.84, 40, 43, 30, 21, 20, 10, 1899, 115, 262, 172, 96, 142, 278, 500, 333, 0, 0, 0, 88, 132, "NULL", 0, 0, 0, "LAST_HIT", 0, 0, 0, "fighter"),
(22024, 22024, "Bandit Inspector", 0, "", 0, "Monster2.northern_goblin_120p", 4, 15, 37, "male", "L2Monster", 80, 1339, 528, 7.11, 1.84, 40, 43, 30, 21, 20, 10, 1855, 114, 251, 158, 104, 147, 278, 500, 333, 0, 0, 0, 88, 132, "NULL", 0, 0, 0, "LAST_HIT", 0, 0, 0, "fighter"),
(22025, 22025, "Frozen Wasteland Werewolf", 0, "", 0, "Monster.werewolf", 10, 26, 38, "male", "L2Monster", 80, 1400, 547, 7.11, 1.84, 40, 43, 30, 21, 20, 10, 3048, 190, 258, 177, 112, 153, 278, 0, 333, 0, 0, 0, 88, 132, "NULL", 0, 0, 0, "LAST_HIT", 0, 0, 0, "fighter"),
(22026, 22026, "Bandit Captain", 0, "", 0, "Monster.ol_mahum_champion_04te", 20, 23, 40, "male", "L2Monster", 80, 1527, 584, 7.11, 1.84, 40, 43, 30, 21, 20, 10, 2537, 164, 273, 195, 131, 164, 278, 500, 333, 69, 19, 0, 88, 132, "NULL", 0, 0, 0, "LAST_HIT", 0, 0, 0, "fighter"),
(22027, 22027, "Forgotten Crewman", 0, "", 0, "Monster.dwarf_ghost", 9, 16.5, 39, "male", "L2Minion", 80, 1463, 565, 7.11, 1.84, 40, 43, 30, 21, 20, 10, 2639, 168, 313, 175, 121, 158, 278, 0, 333, 0, 0, 0, 88, 132, "NULL", 0, 0, 0, "LAST_HIT", 0, 0, 0, "fighter"),
(22028, 22028, "Vagabond of the Ruins", 0, "", 0, "NPC.a_mageguild_teacher_Mhuman_mon", 20, 23, 40, "male", "L2Monster", 80, 1527, 584, 7.11, 1.84, 40, 43, 30, 21, 20, 10, 2537, 164, 273, 195, 131, 164, 278, 500, 333, 0, 0, 0, 88, 132, "NULL", 0, 0, 0, "LAST_HIT", 0, 0, 0, "mage"),
(22029, 22029, "Ragna Orc", 0, "", 0, "Monster.batur_orc_03te", 9, 21.5, 40, "male", "L2Monster", 80, 1527, 584, 7.11, 1.84, 40, 43, 30, 21, 20, 10, 2537, 164, 273, 195, 131, 164, 278, 0, 333, 2, 0, 0, 80, 140, "NULL", 0, 0, 0, "LAST_HIT", 0, 0, 0, "fighter"),
(22030, 22030, "Ragna Orc Shaman", 0, "", 0, "Monster.batur_orc_shaman_a_03te", 11, 16, 42, "male", "L2Monster", 80, 1660, 648, 8.69, 2.14, 40, 43, 30, 21, 20, 10, 2615, 174, 367, 202, 152, 175, 278, 0, 333, 159, 0, 0, 50, 140, "NULL", 0, 0, 0, "LAST_HIT", 0, 0, 0, "balanced"),
(22031, 22031, "Ragna Orc Archer", 0, "", 0, "Monster.batur_orc_archer_03te", 11, 21.5, 43, "male", "L2Monster", 80, 1729, 680, 8.69, 2.14, 40, 43, 30, 21, 20, 10, 2660, 180, 363, 214, 163, 181, 247, 0, 333, 13, 0, 0, 45, 130, "NULL", 0, 0, 0, "LAST_HIT", 0, 0, 0, "archer"),
(22032, 22032, "Ragna Orc Warrior", 0, "", 0, "Monster.batur_orc_warrior_03te", 10, 20, 44, "male", "L2Monster", 40, 1799, 712, 8.69, 2.14, 40, 43, 30, 21, 20, 10, 3395, 232, 465, 217, 176, 187, 278, 500, 333, 68, 0, 0, 80, 140, "NULL", 0, 0, 0, "LAST_HIT", 0, 0, 0, "fighter"),
(22033, 22033, "Ragna Orc Mage", 0, "", 0, "Monster.batur_orc_shaman_a_01te", 11, 16, 45, "male", "L2Monster", 80, 1870, 745, 8.69, 2.14, 40, 43, 30, 21, 20, 10, 2943, 205, 391, 227, 188, 193, 278, 0, 333, 179, 0, 0, 50, 140, "NULL", 0, 0, 0, "LAST_HIT", 0, 0, 0, "balanced"),
(22034, 22034, "Ragna Orc Mage", 0, "", 0, "Monster.batur_orc_shaman_a_01te", 17, 17, 45, "male", "L2Monster", 80, 1870, 745, 8.69, 2.14, 40, 43, 30, 21, 20, 10, 2943, 205, 391, 227, 188, 193, 278, 0, 333, 0, 0, 0, 88, 132, "NULL", 0, 0, 0, "LAST_HIT", 0, 0, 0, "balanced"),
(22035, 22035, "Ragna Orc Mage", 0, "", 0, "Monster.batur_orc_shaman_a_01te", 17, 17, 45, "male", "L2Monster", 80, 1870, 745, 8.69, 2.14, 40, 43, 30, 21, 20, 10, 2943, 205, 391, 227, 188, 193, 278, 0, 333, 0, 0, 0, 88, 132, "NULL", 0, 0, 0, "LAST_HIT", 0, 0, 0, "balanced"),
(22036, 22036, "Ragna Orc Mage", 0, "", 0, "Monster.batur_orc_shaman_a_01te", 17, 17, 45, "male", "L2Monster", 80, 1870, 745, 8.69, 2.14, 40, 43, 30, 21, 20, 10, 2943, 205, 391, 227, 188, 193, 278, 0, 333, 0, 0, 0, 88, 132, "NULL", 0, 0, 0, "LAST_HIT", 0, 0, 0, "balanced"),
(22037, 22037, "Ragna Orc Healer", 0, "", 0, "Monster.batur_orc_shaman_a_03te", 20, 23, 45, "male", "L2Monster", 80, 1870, 745, 8.69, 2.14, 40, 43, 30, 21, 20, 10, 2943, 205, 391, 227, 188, 193, 278, 0, 333, 0, 0, 0, 88, 132, "NULL", 0, 0, 0, "LAST_HIT", 0, 0, 0, "balanced"),
(22038, 22038, "Ragna Orc Hero", 0, "", 0, "Monster.batur_orc_overlord_03te", 12, 24, 48, "male", "L2Monster", 80, 2092, 845, 8.69, 2.14, 40, 43, 30, 21, 20, 10, 3423, 250, 575, 238, 231, 212, 278, 500, 333, 74, 0, 0, 80, 140, "NULL", 0, 0, 0, "LAST_HIT", 0, 0, 0, "fighter"),
(22039, 22039, "Ragna Orc Commander", 0, "", 0, "Monster.batur_orc_overlord_01te", 12, 24, 49, "male", "L2Monster", 80, 2168, 878, 8.69, 2.14, 40, 43, 30, 21, 20, 10, 3659, 270, 490, 267, 247, 219, 278, 500, 333, 135, 0, 0, 80, 140, "NULL", 0, 0, 0, "LAST_HIT", 0, 0, 0, "fighter"),
(22040, 22040, "Ragna Orc Sniper", 0, "", 0, "Monster.batur_orc_archer_01te", 11, 21.5, 47, "male", "L2Monster", 500, 2017, 811, 8.69, 2.14, 40, 43, 30, 21, 20, 10, 3311, 237, 512, 241, 216, 206, 247, 0, 333, 275, 0, 0, 45, 140, "NULL", 0, 0, 0, "LAST_HIT", 0, 0, 0, "archer"),
(22041, 22041, "Ragna Orc Sorcerer", 0, "", 0, "Monster.batur_orc_shaman_a_01te", 11, 16, 50, "male", "L2Monster", 80, 2245, 912, 8.69, 2.14, 40, 43, 30, 21, 20, 10, 3629, 273, 509, 273, 264, 226, 278, 0, 333, 7, 0, 0, 50, 140, "NULL", 0, 0, 0, "LAST_HIT", 0, 0, 0, "balanced"),
(22042, 22042, "Ragna Orc Sorcerer", 0, "", 0, "Monster.batur_orc_shaman_a_01te", 11, 16, 50, "male", "L2Monster", 80, 2245, 912, 8.69, 2.14, 40, 43, 30, 21, 20, 10, 3629, 273, 509, 273, 264, 226, 278, 0, 333, 7, 0, 0, 50, 140, "NULL", 0, 0, 0, "LAST_HIT", 0, 0, 0, "balanced"),
(22043, 22043, "Ragna Orc Sorcerer", 0, "", 0, "Monster.batur_orc_shaman_a_01te", 11, 16, 50, "male", "L2Monster", 80, 2245, 912, 8.69, 2.14, 40, 43, 30, 21, 20, 10, 3629, 273, 509, 273, 264, 226, 278, 0, 333, 7, 0, 0, 50, 140, "NULL", 0, 0, 0, "LAST_HIT", 0, 0, 0, "balanced"),
(22044, 22044, "Ragna Orc Sorcerer", 0, "", 0, "Monster.batur_orc_shaman_a_01te", 11, 16, 50, "male", "L2Monster", 80, 2245, 912, 8.69, 2.14, 40, 43, 30, 21, 20, 10, 3629, 273, 509, 273, 264, 226, 278, 0, 333, 7, 0, 0, 50, 140, "NULL", 0, 0, 0, "LAST_HIT", 0, 0, 0, "balanced"),
(22045, 22045, "Dark Corpse", 0, "", 0, "Monster.zombie_02te", 20, 22, 40, "male", "L2Monster", 80, 1528, 584, 7.11, 1.84, 40, 43, 30, 21, 20, 10, 2537, 164, 273, 195, 131, 164, 278, 0, 333, 0, 0, 0, 88, 132, "NULL", 0, 1, 0, "LAST_HIT", 0, 0, 0, "fighter"),
(22046, 22046, "Varangka's Dre Vanul", 0, "", 0, "Monster.dre_vanul", 14, 36, 46, "male", "L2Monster", 80, 1944, 778, 8.69, 2.14, 40, 43, 30, 21, 20, 10, 3274, 232, 431, 246, 202, 199, 317, 0, 333, 0, 0, 0, 80, 100, "NULL", 0, 0, 0, "LAST_HIT", 0, 0, 0, "fighter"),
(22047, 22047, "Guardian of the Ghost Town", 0, "", 0, "Monster.monster_eye_05te", 21, 43, 44, "male", "L2Monster", 80, 1800, 712, 8.69, 2.14, 40, 43, 30, 21, 20, 10, 3395, 232, 465, 217, 176, 187, 278, 0, 333, 0, 0, 0, 90, 100, "NULL", 0, 0, 0, "LAST_HIT", 0, 0, 0, "fighter"),
(22048, 22048, "Dark Spider", 0, "", 0, "Monster.giant_spider_04te", 26, 25.5, 42, "male", "L2Monster", 80, 1660, 648, 8.69, 2.14, 40, 43, 30, 21, 20, 10, 2615, 174, 367, 202, 152, 175, 317, 0, 333, 0, 0, 0, 72, 150, "NULL", 0, 0, 0, "LAST_HIT", 0, 0, 0, "fighter"),
(22049, 22049, "Varangka's Succubus", 0, "", 0, "Monster.succubus_05te", 10, 36, 49, "male", "L2Monster", 80, 2168, 878, 8.69, 2.14, 40, 43, 30, 21, 20, 10, 3659, 270, 490, 267, 247, 219, 317, 0, 333, 0, 0, 0, 60, 120, "NULL", 0, 0, 0, "LAST_HIT", 0, 0, 0, "fighter"),
(22050, 22050, "Probe Golem Prodigy IV", 0, "", 0, "Monster3.golem_microscout", 12, 43.5, 46, "male", "L2Monster", 80, 1943, 778, 8.69, 2.14, 40, 43, 30, 21, 20, 10, 3274, 232, 431, 246, 202, 199, 197, 500, 333, 0, 0, 0, 30, 190, "NULL", 0, 0, 0, "LAST_HIT", 0, 0, 0, "fighter"),
(22051, 22051, "Spelunking Spider", 0, "", 0, "Monster.giant_spider_05te", 26, 25.5, 47, "male", "L2Monster", 80, 2017, 811, 8.69, 2.14, 40, 43, 30, 21, 20, 10, 3311, 237, 512, 241, 216, 206, 278, 0, 333, 0, 0, 0, 72, 150, "NULL", 0, 0, 0, "LAST_HIT", 0, 0, 0, "fighter"),
(22052, 22052, "Menacing Jackhammer Golem", 0, "", 0, "Monster3.golem_prop", 23, 32.8, 47, "male", "L2Monster", 80, 2017, 811, 8.69, 2.14, 40, 43, 30, 21, 20, 10, 3311, 237, 512, 241, 216, 206, 197, 500, 333, 0, 0, 0, 72, 180, "NULL", 0, 0, 0, "LAST_HIT", 0, 0, 0, "fighter"),
(22053, 22053, "Horrifying Cannon Golem I", 0, "", 0, "Monster3.golem_cannon_catapult", 23.5, 34.7, 48, "male", "L2Monster", 80, 2092, 845, 8.69, 2.14, 40, 43, 30, 21, 20, 10, 3423, 250, 575, 238, 231, 212, 197, 500, 333, 0, 0, 0, 130, 180, "NULL", 0, 0, 0, "LAST_HIT", 0, 0, 0, "fighter"),
(22054, 22054, "Horrifying Cannon Golem IV", 0, "", 0, "Monster3.golem_cannon_catapult", 23.5, 34.7, 48, "male", "L2Monster", 80, 2092, 845, 8.69, 2.14, 40, 43, 30, 21, 20, 10, 3423, 250, 575, 238, 231, 212, 197, 500, 333, 0, 0, 0, 130, 180, "NULL", 0, 0, 0, "LAST_HIT", 0, 0, 0, "fighter"),
(22055, 22055, "Cruel Vice Golem", 0, "", 0, "Monster3.golem_repair", 23, 32.8, 49, "male", "L2Monster", 80, 2168, 878, 8.69, 2.14, 40, 43, 30, 21, 20, 10, 3659, 270, 490, 267, 247, 219, 197, 500, 333, 0, 0, 0, 72, 140, "NULL", 0, 0, 0, "LAST_HIT", 0, 0, 0, "fighter"),
(22056, 22056, "Probe Golem Champion I", 0, "", 0, "Monster3.golem_microscout", 12, 43.5, 49, "male", "L2Monster", 80, 2168, 878, 8.69, 2.14, 40, 43, 30, 21, 20, 10, 3659, 270, 490, 267, 247, 219, 197, 500, 333, 0, 0, 0, 30, 140, "NULL", 0, 0, 0, "LAST_HIT", 0, 0, 0, "fighter"),
(22057, 22057, "Spelunking Ant", 0, "", 0, "Monster.ant_soldier", 35, 17, 50, "male", "L2Monster", 80, 2245, 912, 8.69, 2.14, 40, 43, 30, 21, 20, 10, 3629, 273, 509, 273, 264, 226, 278, 500, 333, 0, 0, 0, 80, 150, "NULL", 0, 0, 0, "LAST_HIT", 0, 0, 0, "fighter"),
(22058, 22058, "Horrifying Excavator Golem III", 0, "", 0, "Monster3.golem_carrier", 23, 32.8, 51, "male", "L2Monster", 80, 2323, 946, 10.27, 2.45, 40, 43, 30, 21, 20, 10, 3841, 293, 602, 280, 281, 232, 197, 500, 333, 0, 0, 0, 72, 150, "NULL", 0, 0, 0, "LAST_HIT", 0, 0, 0, "fighter"),
(22059, 22059, "Bloodthirsty Ginzu Golem VII", 0, "", 0, "Monster3.golem_guardian_090p", 16, 37.2, 51, "male", "L2Monster", 80, 2323, 946, 10.27, 2.45, 40, 43, 30, 21, 20, 10, 3841, 293, 602, 280, 281, 232, 197, 500, 333, 0, 0, 0, 50, 150, "NULL", 0, 0, 0, "LAST_HIT", 0, 0, 0, "fighter"),
(22060, 22060, "Horrifying Cannon Golem", 0, "", 0, "Monster3.golem_cannon_catapult_a", 23.5, 34.7, 52, "male", "L2Monster", 80, 2402, 981, 10.27, 2.45, 40, 43, 30, 21, 20, 10, 2198, 170, 561, 306, 300, 239, 197, 500, 333, 0, 0, 0, 130, 180, "NULL", 0, 0, 0, "LAST_HIT", 0, 0, 0, "fighter"),
(22061, 22061, "Horrifying Cannon Golem III", 0, "", 0, "Monster3.golem_microscout_a", 20, 40, 51, "male", "L2Monster", 80, 2323, 946, 10.27, 2.45, 40, 43, 30, 21, 20, 10, 3841, 293, 602, 280, 281, 232, 278, 0, 333, 0, 0, 0, 88, 132, "NULL", 0, 0, 0, "LAST_HIT", 0, 0, 0, "fighter"),
(22062, 22062, "Horrifying Jackhammer Golem", 0, "", 0, "Monster3.golem_prop", 23, 32.8, 52, "male", "L2Monster", 80, 2402, 981, 10.27, 2.45, 40, 43, 30, 21, 20, 10, 2198, 170, 561, 306, 300, 239, 197, 500, 333, 0, 0, 0, 72, 140, "NULL", 0, 0, 0, "LAST_HIT", 0, 0, 0, "fighter"),
(22063, 22063, "Ginzu Golem Prodigy X", 0, "", 0, "Monster3.golem_guardian_090p", 16, 37.2, 52, "male", "L2Monster", 80, 2402, 981, 10.27, 2.45, 40, 43, 30, 21, 20, 10, 2198, 170, 561, 306, 300, 239, 197, 500, 333, 0, 0, 0, 50, 150, "NULL", 0, 0, 0, "LAST_HIT", 0, 0, 0, "fighter"),
(22064, 22064, "Bloodthirsty Ginzu Golem II", 0, "", 0, "Monster3.golem_guardian_a_090p", 16, 37.2, 52, "male", "L2Monster", 80, 2402, 981, 10.27, 2.45, 40, 43, 30, 21, 20, 10, 2198, 170, 561, 306, 300, 239, 197, 500, 333, 0, 0, 0, 50, 150, "NULL", 0, 0, 0, "LAST_HIT", 0, 0, 0, "fighter"),
(22065, 22065, "Horrifying Ginzu Golem V", 0, "", 0, "Monster3.golem_guardian", 18, 41.5, 53, "male", "L2Monster", 80, 2482, 1016, 10.27, 2.45, 40, 43, 30, 21, 20, 10, 4398, 346, 636, 283, 319, 247, 197, 500, 333, 0, 0, 0, 53, 150, "NULL", 0, 0, 0, "LAST_HIT", 0, 0, 0, "fighter"),
(22066, 22066, "Horrifying Cannon Golem VI", 0, "", 0, "Monster3.golem_cannon_catapult_a_090p", 21, 30, 53, "male", "L2Monster", 80, 2482, 1016, 10.27, 2.45, 40, 43, 30, 21, 20, 10, 4398, 346, 636, 283, 319, 247, 197, 0, 333, 0, 0, 0, 130, 180, "NULL", 0, 0, 0, "LAST_HIT", 0, 0, 0, "fighter"),
(22067, 22067, "Horrifying Cannon Golem VI", 0, "", 0, "Monster3.golem_cannon_catapult_a_090p", 21, 30, 53, "male", "L2Monster", 80, 2482, 1016, 10.27, 2.45, 40, 43, 30, 21, 20, 10, 4398, 346, 636, 283, 319, 247, 197, 0, 333, 0, 0, 0, 130, 180, "NULL", 0, 0, 0, "LAST_HIT", 0, 0, 0, "fighter"),
(22068, 22068, "Horrifying Cannon Golem VI", 0, "", 0, "Monster3.golem_cannon_catapult_a_090p", 21, 30, 53, "male", "L2Monster", 80, 2482, 1016, 10.27, 2.45, 40, 43, 30, 21, 20, 10, 4398, 346, 636, 283, 319, 247, 197, 0, 333, 0, 0, 0, 130, 180, "NULL", 0, 0, 0, "LAST_HIT", 0, 0, 0, "fighter"),
(22069, 22069, "Horrifying Cannon Golem VI", 0, "", 0, "Monster3.golem_cannon_catapult_a_090p", 21, 30, 53, "male", "L2Monster", 80, 2482, 1016, 10.27, 2.45, 40, 43, 30, 21, 20, 10, 4398, 346, 636, 283, 319, 247, 197, 0, 333, 0, 0, 0, 130, 180, "NULL", 0, 0, 0, "LAST_HIT", 0, 0, 0, "fighter"),
(22070, 22070, "Horrifying Cannon Golem VI", 0, "", 0, "Monster3.golem_cannon_catapult_a_090p", 21, 30, 53, "male", "L2Monster", 80, 2482, 1016, 10.27, 2.45, 40, 43, 30, 21, 20, 10, 4398, 346, 636, 283, 319, 247, 197, 0, 333, 0, 0, 0, 130, 180, "NULL", 0, 0, 0, "LAST_HIT", 0, 0, 0, "fighter"),
(22071, 22071, "Horrifying Cannon Golem VI", 0, "", 0, "Monster3.golem_cannon_catapult_a_090p", 21, 30, 53, "male", "L2Monster", 80, 2482, 1016, 10.27, 2.45, 40, 43, 30, 21, 20, 10, 4398, 346, 636, 283, 319, 247, 197, 0, 333, 0, 0, 0, 130, 180, "NULL", 0, 0, 0, "LAST_HIT", 0, 0, 0, "fighter"),
(22072, 22072, "Horrifying Cannon Golem VI", 0, "", 0, "Monster3.golem_cannon_catapult_a_090p", 21, 30, 53, "male", "L2Monster", 80, 2482, 1016, 10.27, 2.45, 40, 43, 30, 21, 20, 10, 4398, 346, 636, 283, 319, 247, 197, 0, 333, 0, 0, 0, 130, 180, "NULL", 0, 0, 0, "LAST_HIT", 0, 0, 0, "fighter"),
(22073, 22073, "Horrifying Cannon Golem VI", 0, "", 0, "Monster3.golem_cannon_catapult_a_090p", 20, 40, 53, "male", "L2Monster", 80, 2482, 1016, 10.27, 2.45, 40, 43, 30, 21, 20, 10, 4398, 346, 636, 283, 319, 247, 278, 0, 333, 0, 0, 0, 88, 132, "NULL", 0, 0, 0, "LAST_HIT", 0, 0, 0, "fighter"),
(22074, 22074, "Epic Cannon Golem", 0, "", 0, "Monster3.golem_cannon_catapult_a_090p", 21, 30, 53, "male", "L2Monster", 80, 2482, 1016, 10.27, 2.45, 40, 43, 30, 21, 20, 10, 4398, 346, 636, 283, 319, 247, 197, 500, 333, 0, 0, 0, 130, 180, "NULL", 0, 0, 0, "LAST_HIT", 0, 0, 0, "fighter"),
(22075, 22075, "Epic Cannon Golem Adjunct", 0, "", 0, "Monster3.golem_microscout_a", 12, 43.5, 52, "male", "L2Monster", 80, 2402, 981, 10.27, 2.45, 40, 43, 30, 21, 20, 10, 2198, 170, 561, 306, 300, 239, 197, 0, 333, 0, 0, 0, 30, 200, "NULL", 0, 0, 0, "LAST_HIT", 0, 0, 0, "fighter"),
(22076, 22076, "Deadly Ginzu Golem V", 0, "", 0, "Monster3.golem_guardian", 18, 41.5, 53, "male", "L2Monster", 80, 2482, 1016, 10.27, 2.45, 40, 43, 30, 21, 20, 10, 4398, 346, 636, 283, 319, 247, 197, 500, 333, 0, 0, 0, 53, 150, "NULL", 0, 0, 0, "LAST_HIT", 0, 0, 0, "fighter"),
(22077, 22077, "Horrifying Ginzu Golem VIII", 0, "", 0, "Monster3.golem_guardian_a", 18, 41.5, 54, "male", "L2Monster", 80, 2562, 1050, 10.27, 2.45, 40, 43, 30, 21, 20, 10, 4370, 348, 667, 293, 339, 254, 197, 500, 333, 0, 0, 0, 53, 150, "NULL", 0, 0, 0, "LAST_HIT", 0, 0, 0, "fighter"),
(22078, 22078, "Deadly Ginzu Golem VIII", 0, "", 0, "Monster3.golem_guardian_a", 18, 41.5, 54, "male", "L2Monster", 80, 2562, 1050, 10.27, 2.45, 40, 43, 30, 21, 20, 10, 4370, 348, 667, 293, 339, 254, 197, 500, 333, 0, 0, 0, 53, 150, "NULL", 0, 0, 0, "LAST_HIT", 0, 0, 0, "fighter"),
(22079, 22079, "Lost Bandersnatch", 0, "", 0, "Monster2.bandersnatch_c", 18, 25, 53, "male", "L2Minion", 40, 2482, 1016, 10.27, 2.45, 40, 43, 30, 21, 20, 10, 4398, 346, 636, 283, 319, 247, 278, 0, 333, 0, 0, 0, 30, 170, "NULL", 0, 0, 0, "LAST_HIT", 0, 0, 0, "fighter"),
(22080, 22080, "Massive Maze Bandersnatch", 0, "", 0, "Monster2.bandersnatch", 18, 25, 54, "male", "L2Monster", 40, 2562, 1050, 10.27, 2.45, 40, 43, 30, 21, 20, 10, 4370, 348, 667, 293, 339, 254, 278, 0, 333, 0, 0, 0, 30, 170, "NULL", 0, 0, 0, "LAST_HIT", 0, 0, 0, "fighter"),
(22081, 22081, "Lost Watcher", 0, "", 0, "Monster.field_stalker", 15, 30, 53, "male", "L2Monster", 40, 2482, 1016, 10.27, 2.45, 40, 43, 30, 21, 20, 10, 4398, 346, 636, 283, 319, 247, 278, 0, 333, 0, 0, 0, 70, 130, "NULL", 0, 0, 0, "LAST_HIT", 0, 0, 0, "fighter"),
(22082, 22082, "Elder Lost Watcher", 0, "", 0, "Monster.field_stalker_110p", 16, 36, 54, "male", "L2Monster", 40, 2562, 1050, 10.27, 2.45, 40, 43, 30, 21, 20, 10, 4370, 348, 667, 293, 339, 254, 278, 0, 333, 0, 0, 0, 70, 170, "NULL", 0, 0, 0, "LAST_HIT", 0, 0, 0, "fighter"),
(22083, 22083, "Baby Panthera", 0, "", 0, "Monster.saber_toothed_tiger_080p", 29, 22.7, 55, "male", "L2Minion", 40, 2644, 1086, 10.27, 2.45, 40, 43, 30, 21, 20, 10, 4519, 365, 733, 302, 360, 261, 278, 0, 333, 0, 0, 0, 60, 170, "NULL", 0, 0, 0, "LAST_HIT", 0, 0, 0, "fighter"),
(22084, 22084, "Panthera", 0, "", 0, "Monster.saber_toothed_tiger", 34, 28, 56, "male", "L2Monster", 40, 2724, 1121, 10.27, 2.45, 40, 43, 30, 21, 20, 10, 4896, 402, 730, 310, 382, 269, 278, 500, 333, 0, 0, 0, 60, 170, "NULL", 0, 0, 0, "LAST_HIT", 0, 0, 0, "fighter"),
(22085, 22085, "Lost Gargoyle", 0, "", 0, "Monster.gargoyle_02te", 16, 50, 55, "male", "L2Monster", 40, 2643, 1086, 10.27, 2.45, 40, 43, 30, 21, 20, 10, 4519, 365, 733, 302, 360, 261, 278, 0, 333, 0, 0, 0, 140, 140, "NULL", 0, 0, 0, "LAST_HIT", 0, 0, 0, "fighter"),
(22086, 22086, "Lost Gargoyle Youngling", 0, "", 0, "Monster.gargoyle_02te_110p", 17.5, 56, 56, "male", "L2Monster", 40, 2725, 1121, 10.27, 2.45, 40, 43, 30, 21, 20, 10, 4896, 402, 730, 310, 382, 269, 278, 500, 333, 0, 0, 0, 140, 140, "NULL", 0, 0, 0, "LAST_HIT", 0, 0, 0, "fighter"),
(22087, 22087, "Pronghorn Spirit", 0, "", 0, "Monster2.antelope", 17, 34, 56, "male", "L2Minion", 40, 2725, 1121, 10.27, 2.45, 40, 43, 30, 21, 20, 10, 4896, 402, 730, 310, 382, 269, 278, 0, 333, 0, 0, 0, 45, 185, "NULL", 0, 0, 0, "LAST_HIT", 0, 0, 0, "fighter"),
(22088, 22088, "Pronghorn", 0, "", 0, "Monster2.antelope_110p", 19, 37.8, 57, "male", "L2Monster", 40, 2807, 1157, 10.27, 2.45, 40, 43, 30, 21, 20, 10, 4087, 340, 861, 298, 405, 276, 278, 0, 333, 0, 0, 0, 45, 185, "NULL", 0, 0, 0, "LAST_HIT", 0, 0, 0, "fighter"),
(22089, 22089, "Ice Tarantula", 0, "", 0, "Monster.giant_spider", 26, 25.5, 57, "male", "L2Monster", 40, 2807, 1157, 10.27, 2.45, 40, 43, 30, 21, 20, 10, 4087, 340, 861, 298, 405, 276, 278, 0, 333, 0, 0, 0, 72, 120, "NULL", 0, 0, 0, "LAST_HIT", 0, 0, 0, "fighter"),
(22090, 22090, "Frost Tarantula", 0, "", 0, "Monster.giant_spider_110p", 32, 28, 58, "male", "L2Monster", 40, 2889, 1192, 10.27, 2.45, 40, 43, 30, 21, 20, 10, 5053, 427, 834, 325, 428, 284, 278, 0, 333, 0, 0, 0, 72, 120, "NULL", 0, 0, 0, "LAST_HIT", 0, 0, 0, "fighter"),
(22091, 22091, "Lost Iron Golem", 0, "", 0, "Monster.iron_golem_120p", 22, 42.5, 58, "male", "L2Minion", 40, 2890, 1192, 10.27, 2.45, 40, 43, 30, 21, 20, 10, 5053, 427, 834, 325, 428, 284, 278, 0, 333, 0, 0, 0, 20, 20, "NULL", 0, 0, 0, "LAST_HIT", 0, 0, 0, "fighter"),
(22092, 22092, "Frost Iron Golem", 0, "", 0, "Monster.iron_golem_130p", 24, 46.4, 59, "male", "L2Monster", 40, 2972, 1229, 10.27, 2.45, 40, 43, 30, 21, 20, 10, 6134, 524, 866, 324, 453, 291, 278, 500, 333, 0, 0, 0, 20, 20, "NULL", 0, 0, 0, "LAST_HIT", 0, 0, 0, "fighter"),
(22093, 22093, "Lost Buffalo", 0, "", 0, "Monster2.buffalo", 22, 31, 60, "male", "L2Minion", 40, 3055, 1265, 10.27, 2.45, 40, 43, 30, 21, 20, 10, 5522, 479, 868, 349, 478, 299, 278, 0, 333, 0, 0, 0, 20, 170, "NULL", 0, 0, 0, "LAST_HIT", 0, 0, 0, "fighter"),
(22094, 22094, "Frost Buffalo", 0, "", 0, "Monster2.buffalo_a_110p", 24, 34.7, 61, "male", "L2Monster", 40, 3137, 1301, 11.85, 2.78, 40, 43, 30, 21, 20, 10, 5254, 462, 1050, 348, 505, 307, 278, 500, 333, 0, 0, 0, 20, 170, "NULL", 0, 0, 0, "LAST_HIT", 0, 0, 0, "fighter"),
(22095, 22095, "Ursus Cub", 0, "", 0, "Monster.grizzly", 21, 40, 61, "male", "L2Minion", 40, 3138, 1301, 11.85, 2.78, 40, 43, 30, 21, 20, 10, 5254, 462, 1050, 348, 505, 307, 278, 0, 333, 0, 0, 0, 40, 120, "NULL", 0, 0, 0, "LAST_HIT", 0, 0, 0, "fighter"),
(22096, 22096, "Ursus", 0, "", 0, "Monster.grizzly_120p", 21, 40, 62, "male", "L2Monster", 40, 3220, 1338, 11.85, 2.78, 40, 43, 30, 21, 20, 10, 6303, 562, 1095, 360, 532, 315, 278, 0, 333, 0, 0, 0, 40, 120, "NULL", 0, 0, 0, "LAST_HIT", 0, 0, 0, "fighter"),
(22097, 22097, "Lost Yeti", 0, "", 0, "Monster.yeti", 15, 27.5, 62, "male", "L2Monster", 40, 3220, 1338, 11.85, 2.78, 40, 43, 30, 21, 20, 10, 6303, 562, 1095, 360, 532, 315, 278, 0, 333, 0, 0, 0, 16, 170, "NULL", 0, 0, 0, "LAST_HIT", 0, 0, 0, "fighter"),
(22098, 22098, "Frost Yeti", 0, "", 0, "Monster.yeti_110p", 20, 29.8, 63, "male", "L2Monster", 40, 3302, 1375, 11.85, 2.78, 40, 43, 30, 21, 20, 10, 6277, 567, 1136, 384, 560, 323, 278, 0, 333, 0, 0, 0, 16, 170, "NULL", 0, 0, 0, "LAST_HIT", 0, 0, 0, "fighter"),
(22099, 22099, "Freya's Buffalo", 0, "", 0, "Monster2.buffalo", 22, 31, 57, "male", "L2Minion", 80, 2807, 1157, 10.27, 2.45, 40, 43, 30, 21, 20, 10, 4087, 340, 861, 298, 405, 276, 278, 500, 333, 0, 0, 0, 20, 170, "NULL", 0, 0, 0, "LAST_HIT", 0, 0, 0, "fighter"),
(22100, 22100, "Freya's Gardener", 0, "", 0, "Monster.field_stalker", 15, 30, 58, "male", "L2Monster", 80, 2889, 1192, 10.27, 2.45, 40, 43, 30, 21, 20, 10, 5053, 427, 834, 325, 428, 284, 278, 500, 333, 0, 0, 0, 70, 130, "NULL", 0, 0, 0, "LAST_HIT", 0, 0, 0, "fighter"),
(22101, 22101, "Freya's Servant", 0, "", 0, "Monster.gargoyle_02te", 16, 50, 58, "male", "L2Minion", 80, 2889, 1192, 10.27, 2.45, 40, 43, 30, 21, 20, 10, 5053, 427, 834, 325, 428, 284, 317, 500, 333, 0, 0, 0, 140, 168, "NULL", 0, 0, 0, "LAST_HIT", 0, 0, 0, "fighter"),
(22102, 22102, "Freya's Servant", 0, "", 0, "Monster.gargoyle_02te", 16, 50, 58, "male", "L2Monster", 80, 2889, 1192, 10.27, 2.45, 40, 43, 30, 21, 20, 10, 5053, 427, 834, 325, 428, 284, 197, 500, 333, 0, 0, 0, 140, 140, "NULL", 0, 0, 0, "LAST_HIT", 0, 0, 0, "fighter"),
(22103, 22103, "Freya's White Bear", 0, "", 0, "Monster.grizzly", 21, 40, 57, "male", "L2Minion", 80, 2807, 1157, 10.27, 2.45, 40, 43, 30, 21, 20, 10, 4087, 340, 861, 298, 405, 276, 278, 500, 333, 0, 0, 0, 40, 165, "NULL", 0, 0, 0, "LAST_HIT", 0, 0, 0, "fighter"),
(22104, 22104, "Freya's Dog", 0, "", 0, "Monster2.bandersnatch", 18, 25, 58, "male", "L2Monster", 80, 2889, 1192, 10.27, 2.45, 40, 43, 30, 21, 20, 10, 5053, 427, 834, 325, 428, 284, 278, 500, 333, 0, 0, 0, 30, 170, "NULL", 0, 0, 0, "LAST_HIT", 0, 0, 0, "fighter"),
(22105, 22105, "Spiked Stakato", 0, "", 0, "Monster.blade_stakato_120p", 20, 44, 72, "male", "L2Monster", 80, 4014, 1720, 13.43, 3.09, 40, 43, 30, 21, 20, 10, 8759, 890, 1681, 454, 849, 399, 278, 500, 333, 0, 0, 0, 88, 132, "NULL", 0, 0, 0, "LAST_HIT", 0, 0, 0, "fighter"),
(22106, 22106, "Spiked Stakato Worker", 0, "", 0, "Monster.blade_stakato_worker_120p", 20, 48, 73, "male", "L2Monster", 80, 4087, 1760, 13.43, 3.09, 40, 43, 30, 21, 20, 10, 8561, 881, 1747, 456, 885, 407, 278, 500, 333, 0, 0, 0, 88, 132, "NULL", 0, 0, 0, "LAST_HIT", 0, 0, 0, "fighter"),
(22107, 22107, "Spiked Stakato Guard", 0, "", 0, "Monster.spike_stakato", 20, 26, 74, "male", "L2Monster", 80, 4159, 1800, 13.43, 3.09, 40, 43, 30, 21, 20, 10, 9177, 956, 1608, 501, 921, 416, 278, 500, 333, 0, 0, 0, 88, 132, "NULL", 0, 0, 0, "LAST_HIT", 0, 0, 0, "fighter"),
(22108, 22108, "Female Spiked Stakato", 0, "", 0, "Monster.spike_stakato_soldier", 20, 29, 74, "male", "L2Monster", 80, 4159, 1800, 13.43, 3.09, 40, 43, 30, 21, 20, 10, 9177, 956, 1608, 501, 921, 416, 278, 500, 333, 0, 0, 0, 88, 132, "NULL", 0, 0, 0, "LAST_HIT", 0, 0, 0, "fighter"),
(22109, 22109, "Male Spiked Stakato", 0, "", 0, "Monster.marsh_stakato_soldier_120p", 20, 31, 74, "male", "L2Monster", 80, 4159, 1800, 13.43, 3.09, 40, 43, 30, 21, 20, 10, 9177, 956, 1608, 501, 921, 416, 278, 500, 333, 0, 0, 0, 88, 132, "NULL", 0, 0, 0, "LAST_HIT", 0, 0, 0, "fighter"),
(22110, 22110, "Male Spiked Stakato", 0, "", 0, "Monster3.marsh_stakato_soldier_tran", 20, 28, 74, "male", "L2Monster", 80, 4159, 1800, 13.43, 3.09, 40, 43, 30, 21, 20, 10, 9177, 956, 1608, 501, 921, 416, 278, 0, 333, 0, 0, 0, 88, 132, "NULL", 0, 0, 0, "LAST_HIT", 0, 0, 0, "fighter"),
(22111, 22111, "Spiked Stakato Sorcerer", 0, "", 0, "Monster.blade_stakato_queen_120p", 20, 44, 75, "male", "L2Monster", 80, 4229, 1840, 13.43, 3.09, 40, 43, 30, 21, 20, 10, 8521, 899, 1683, 488, 957, 425, 278, 500, 333, 0, 0, 0, 88, 132, "NULL", 0, 0, 0, "LAST_HIT", 0, 0, 0, "fighter"),
(22112, 22112, "Cannibalistic Stakato Follower", 0, "", 0, "Monster.spike_stakato_worker", 20, 24, 74, "male", "L2Monster", 80, 4159, 1800, 13.43, 3.09, 40, 43, 30, 21, 20, 10, 9177, 956, 1608, 501, 921, 416, 278, 500, 333, 0, 0, 0, 88, 132, "NULL", 0, 0, 0, "LAST_HIT", 0, 0, 0, "fighter"),
(22113, 22113, "Cannibalistic Stakato Leader", 0, "", 0, "Monster3.cannibal_stakato_leader_120p", 20, 48, 75, "male", "L2Monster", 80, 4229, 1840, 13.43, 3.09, 40, 43, 30, 21, 20, 10, 8521, 899, 1683, 488, 957, 425, 278, 500, 333, 0, 0, 0, 88, 132, "NULL", 0, 0, 0, "LAST_HIT", 0, 0, 0, "fighter"),
(22114, 22114, "Cannibalistic Stakato Leader", 0, "", 0, "Monster3.cannibal_stakato_leader_tran", 20, 48, 75, "male", "L2Monster", 80, 4229, 1840, 13.43, 3.09, 40, 43, 30, 21, 20, 10, 8521, 899, 1683, 488, 957, 425, 278, 0, 333, 0, 0, 0, 88, 132, "NULL", 0, 0, 0, "LAST_HIT", 0, 0, 0, "fighter"),
(22115, 22115, "Spiked Stakato Soldier", 0, "", 0, "Monster.blade_stakato_120p", 20, 44, 76, "male", "L2Monster", 80, 4298, 1880, 13.43, 3.09, 40, 43, 30, 21, 20, 10, 8875, 948, 1824, 506, 994, 433, 278, 500, 333, 0, 0, 0, 88, 132, "NULL", 0, 0, 0, "LAST_HIT", 0, 0, 0, "fighter"),
(22116, 22116, "Spiked Stakato Drone", 0, "", 0, "Monster.blade_stakato_drone_120p", 20, 47, 77, "male", "L2Monster", 80, 4364, 1920, 13.43, 3.09, 40, 43, 30, 21, 20, 10, 9190, 994, 1711, 513, 1031, 442, 278, 500, 333, 0, 0, 0, 88, 132, "NULL", 0, 0, 0, "LAST_HIT", 0, 0, 0, "fighter"),
(22117, 22117, "Spiked Stakato Captain", 0, "", 0, "Monster.marsh_stakato_drone_120p", 20, 29, 78, "male", "L2Monster", 80, 4429, 1961, 13.43, 3.09, 40, 43, 30, 21, 20, 10, 8687, 951, 2111, 522, 1069, 451, 278, 500, 333, 0, 0, 0, 88, 132, "NULL", 0, 0, 0, "LAST_HIT", 0, 0, 0, "fighter"),
(22118, 22118, "Spiked Stakato Nurse", 0, "", 0, "Monster.marsh_stakato_queen_120p", 20, 44, 79, "male", "L2Monster", 80, 4491, 2002, 13.43, 3.09, 40, 43, 30, 21, 20, 10, 8749, 969, 2200, 550, 1107, 459, 278, 500, 333, 0, 0, 0, 88, 132, "NULL", 0, 0, 0, "LAST_HIT", 0, 0, 0, "fighter"),
(22119, 22119, "Spiked Stakato Nurse", 0, "", 0, "Monster3.marsh_stakato_queen_tran", 20, 36, 79, "male", "L2Monster", 80, 4491, 2002, 13.43, 3.09, 40, 43, 30, 21, 20, 10, 8749, 969, 2200, 550, 1107, 459, 278, 0, 333, 0, 0, 0, 88, 132, "NULL", 0, 0, 0, "LAST_HIT", 0, 0, 0, "fighter"),
(22120, 22120, "Spiked Stakato Baby", 0, "", 0, "Monster.spike_stakato_drone", 20, 29, 79, "male", "L2Monster", 80, 4491, 2002, 13.43, 3.09, 40, 43, 30, 21, 20, 10, 8749, 969, 2200, 550, 1107, 459, 278, 500, 333, 0, 0, 0, 88, 132, "NULL", 0, 0, 0, "LAST_HIT", 0, 0, 0, "fighter"),
(22121, 22121, "Spiked Stakato Shaman", 0, "", 0, "Monster.blade_stakato_queen_120p", 20, 44, 80, "male", "L2Monster", 80, 4551, 2043, 13.43, 3.09, 40, 43, 30, 21, 20, 10, 9431, 1058, 1890, 556, 1144, 468, 278, 500, 333, 0, 0, 0, 88, 132, "NULL", 0, 0, 0, "LAST_HIT", 0, 0, 0, "fighter"),
(22122, 22122, "Monastic Pilgrim", 0, "", 0, "Monster.angel_080p", 13, 28, 78, "male", "L2Minion", 80, 4551, 2043, 13.43, 3.09, 40, 43, 30, 21, 20, 10, 9431, 1058, 1890, 556, 1144, 468, 278, 0, 333, 148, 0, 0, 88, 132, "NULL", 0, 0, 0, "LAST_HIT", 0, 0, 0, "fighter"),
(22123, 22123, "Monastic Crusader", 0, "", 0, "Monster.archangel_050p", 20, 40, 78, "male", "L2Monster", 80, 4609, 2085, 13.43, 3.09, 40, 43, 30, 21, 20, 10, 10198, 1158, 1972, 574, 1182, 477, 278, 500, 333, 1303, 0, 0, 88, 132, "NULL", 0, 0, 0, "LAST_HIT", 0, 0, 0, "fighter"),
(22124, 22124, "Solina Brother", 0, "", 0, "Monster3.solina_brother", 20, 25, 78, "male", "L2Monster", 80, 4609, 2085, 13.43, 3.09, 40, 43, 30, 21, 20, 10, 10198, 1158, 1972, 574, 1182, 477, 278, 0, 333, 8212, 0, 0, 88, 132, "NULL", 0, 0, 0, "LAST_HIT", 0, 0, 0, "fighter"),
(22125, 22125, "Solina Lay Brother", 0, "", 0, "Monster3.solina_brother", 20, 25, 78, "male", "L2Monster", 80, 4664, 2126, 13.43, 3.09, 40, 43, 30, 21, 20, 10, 9577, 1100, 2203, 573, 1220, 485, 278, 0, 333, 8212, 0, 0, 88, 132, "NULL", 0, 0, 0, "LAST_HIT", 0, 0, 0, "fighter"),
(22126, 22126, "Silent Seeker", 0, "", 0, "Monster3.solina_father", 20, 25, 78, "male", "L2Monster", 80, 4664, 2126, 13.43, 3.09, 40, 43, 30, 21, 20, 10, 9577, 1100, 2203, 573, 1220, 485, 278, 0, 333, 8213, 0, 0, 88, 132, "NULL", 0, 0, 0, "LAST_HIT", 0, 0, 0, "fighter"),
(22127, 22127, "Silent Brother", 0, "", 0, "Monster3.solina_father", 20, 25, 78, "male", "L2Monster", 80, 4717, 2168, 13.43, 3.09, 40, 43, 30, 21, 20, 10, 9821, 1141, 2695, 571, 1258, 494, 278, 0, 333, 8212, 0, 0, 88, 132, "NULL", 0, 0, 0, "LAST_HIT", 0, 0, 0, "fighter"),
(22128, 22128, "Monastery Guardian", 0, "", 0, "Monster3.grail_protection", 20, 15, 78, "male", "L2Monster", 80, 4717, 2168, 13.43, 3.09, 40, 43, 30, 21, 20, 10, 9821, 1141, 2695, 571, 1258, 494, 278, 500, 333, 0, 0, 0, 88, 132, "NULL", 0, 0, 0, "LAST_HIT", 0, 0, 0, "fighter"),
(22129, 22129, "Warrior Monk", 0, "", 0, "Monster3.monk_warrior", 20, 28, 78, "male", "L2Monster", 80, 4767, 2211, 13.43, 3.09, 40, 43, 30, 21, 20, 10, 11138, 1310, 2298, 612, 1296, 502, 278, 0, 333, 8211, 8210, 0, 88, 132, "NULL", 0, 0, 0, "LAST_HIT", 0, 0, 0, "fighter"),
(22130, 22130, "Divine Advocate", 0, "", 0, "Monster2.apostle_warrior", 8, 30, 78, "male", "L2Minion", 80, 4814, 2253, 13.43, 3.09, 40, 43, 30, 21, 20, 10, 10931, 1301, 2129, 615, 1333, 511, 278, 0, 333, 6717, 0, 0, 50, 180, "NULL", 0, 0, 0, "LAST_HIT", 0, 0, 0, "fighter"),
(22131, 22131, "Pilgrim of Light", 0, "", 0, "Monster2.apostle_mage", 11, 38.5, 78, "male", "L2Minion", 80, 4814, 2253, 13.43, 3.09, 40, 43, 30, 21, 20, 10, 10931, 1301, 2129, 615, 1333, 511, 278, 0, 333, 6718, 0, 0, 50, 165, "NULL", 0, 0, 0, "LAST_HIT", 0, 0, 0, "mage"),
(22132, 22132, "Judge of Light", 0, "", 0, "Monster3.apostle_grail_a", 20, 43, 78, "male", "L2Monster", 500, 4858, 2296, 13.43, 3.09, 40, 43, 30, 21, 20, 10, 11031, 1351, 2199, 625, 1373, 521, 278, 500, 333, 8220, 0, 0, 88, 132, "NULL", 0, 0, 0, "LAST_HIT", 0, 0, 0, "fighter"),
(22133, 22133, "Guardian of the Grail", 0, "", 0, "Monster.will_o_wisp", 13, 22, 78, "male", "L2Monster", 80, 4858, 2296, 13.43, 3.09, 40, 43, 30, 21, 20, 10, 11031, 1351, 2199, 625, 1373, 521, 278, 500, 333, 0, 0, 0, 88, 132, "NULL", 0, 0, 0, "LAST_HIT", 0, 0, 0, "fighter"),
(22134, 22134, "Guardian of the Holy Land", 0, "", 0, "Monster3.solina_priest", 20, 35, 78, "male", "L2Monster", 80, 4900, 2339, 13.43, 3.09, 40, 43, 30, 21, 20, 10, 11131, 1401, 2269, 635, 1413, 531, 278, 0, 333, 8214, 0, 0, 88, 132, "NULL", 0, 0, 0, "LAST_HIT", 0, 0, 0, "fighter"),
(22135, 22135, "Beholder of Light", 0, "", 0, "Monster3.apostle_grail", 20, 43, 78, "male", "L2Monster", 80, 4900, 2339, 13.43, 3.09, 40, 43, 30, 21, 20, 10, 11131, 1401, 2269, 635, 1413, 531, 278, 500, 333, 8221, 0, 0, 88, 132, "NULL", 0, 0, 0, "LAST_HIT", 0, 0, 0, "fighter"),
(22136, 22136, "Gatekeeper Zombie", 0, "", 0, "Monster3.zombie_gateguard", 20, 30, 78, "male", "L2Monster", 80, 4717, 2168, 13.43, 3.09, 40, 43, 30, 21, 20, 10, 250, 25, 1719, 4500, 2288, 780, 300, 300, 555, 8217, 0, 0, 0, 0, "NULL", 0, 0, 0, "LAST_HIT", 0, 0, 0, "balanced"),
(22137, 22137, "Penance Guard", 0, "", 0, "Monster3.zombie_gateguard_brd", 40, 30.5, 78, "male", "L2Monster", 80, 4608, 1567, 13.43, 3.09, 40, 43, 30, 21, 20, 10, 13824, 658, 2475, 1127, 1544, 780, 278, 300, 333, 8217, 0, 0, 33, 120, "NULL", 0, 1, 0, "LAST_HIT", 0, 0, 0, "fighter"),
(22138, 22138, "Chapel Guard", 0, "", 0, "Monster3.zombie_gateguard_brd", 40, 30.5, 78, "male", "L2Monster", 80, 4812, 2439, 13.43, 3.09, 40, 43, 30, 21, 20, 10, 14436, 688, 2475, 793, 1144, 780, 278, 300, 333, 8217, 0, 0, 33, 120, "NULL", 0, 1, 0, "LAST_HIT", 0, 0, 0, "fighter"),
(22139, 22139, "Old Aristocrat's Soldier", 0, "", 0, "Monster3.zombie_enlisted_man", 17, 22.3, 78, "male", "L2Monster", 80, 4609, 2439, 13.43, 3.09, 40, 43, 26, 21, 20, 10, 13826, 658, 1719, 1108, 1144, 780, 278, 0, 333, 0, 0, 0, 38, 200, "NULL", 0, 1, 0, "LAST_HIT", 0, 0, 0, "balanced"),
(22140, 22140, "Zombie Worker", 0, "", 0, "Monster3.zombie_laborer", 11, 24.6, 78, "male", "L2Monster", 80, 4551, 2439, 13.43, 3.09, 40, 43, 25, 21, 20, 10, 13652, 650, 1886, 1108, 1144, 780, 278, 0, 333, 123, 0, 0, 36, 120, "NULL", 0, 1, 0, "LAST_HIT", 0, 0, 0, "fighter"),
(22141, 22141, "Forgotten Victim", 0, "", 0, "Monster3.zombie_laborer", 11, 24.6, 78, "male", "L2Monster", 80, 4551, 2439, 13.43, 3.09, 40, 43, 25, 21, 20, 10, 13652, 650, 1886, 1108, 1144, 780, 278, 0, 333, 123, 0, 0, 36, 120, "NULL", 0, 1, 0, "LAST_HIT", 0, 0, 0, "fighter"),
(22142, 22142, "Triol's Layperson", 0, "", 0, "Monster3.heretic_privates_a", 7.7, 28.4, 78, "male", "L2Monster", 80, 4609, 3566, 13.43, 3.09, 40, 43, 30, 21, 20, 10, 13826, 658, 1652, 793, 1144, 780, 278, 300, 333, 8207, 8207, 0, 58, 200, "NULL", 0, 0, 0, "LAST_HIT", 0, 0, 0, "balanced"),
(22143, 22143, "Triol's Believer", 0, "", 0, "Monster3.heretic_privates", 20, 28, 78, "male", "L2Monster", 80, 3731, 2439, 13.43, 3.09, 40, 43, 30, 21, 20, 10, 11193, 533, 1652, 793, 1211, 780, 300, 0, 555, 8208, 0, 0, 61, 180, "NULL", 0, 0, 0, "LAST_HIT", 0, 0, 0, "balanced"),
(22144, 22144, "Resurrected Temple Knight", 0, "", 0, "Monster3.zombie_enlisted_man", 20, 23, 78, "male", "L2Monster", 80, 4664, 4599, 13.43, 3.09, 40, 43, 26, 21, 20, 10, 13991, 666, 1698, 1108, 1144, 780, 550, 300, 555, 0, 0, 0, 61, 180, "NULL", 0, 1, 0, "LAST_HIT", 0, 0, 0, "balanced"),
(22145, 22145, "Ritual Sacrifice", 0, "", 0, "Monster3.self_blaster", 20, 23, 78, "male", "L2Monster", 80, 4609, 2499, 13.43, 3.09, 40, 43, 30, 21, 20, 10, 13826, 658, 1719, 793, 1144, 780, 300, 0, 555, 0, 0, 0, 61, 180, "NULL", 0, 1, 0, "LAST_HIT", 0, 0, 0, "balanced"),
(22146, 22146, "Triol's Priest", 0, "", 0, "Monster3.heretic_privates", 7.7, 28.4, 78, "male", "L2Monster", 80, 4766, 4599, 13.43, 3.09, 40, 43, 30, 21, 20, 10, 14299, 681, 1719, 793, 1211, 780, 278, 300, 333, 8205, 0, 0, 60, 200, "NULL", 0, 0, 0, "LAST_HIT", 0, 0, 0, "balanced"),
(22147, 22147, "Ritual Offering", 0, "", 0, "Monster3.zombie_enlisted_man", 17, 22.3, 78, "male", "L2Monster", 80, 4717, 4599, 13.43, 3.09, 40, 43, 30, 21, 20, 10, 14150, 674, 1517, 793, 1144, 780, 278, 0, 333, 0, 0, 0, 38, 180, "NULL", 0, 1, 0, "LAST_HIT", 0, 0, 0, "balanced"),
(22148, 22148, "Triol's Believer", 0, "", 0, "Monster3.heretic_privates", 7.7, 28.4, 78, "male", "L2Monster", 80, 5830, 4599, 13.43, 3.09, 40, 43, 30, 21, 20, 10, 17489, 830, 1719, 793, 1144, 780, 278, 300, 333, 8205, 0, 0, 60, 180, "NULL", 0, 0, 0, "LAST_HIT", 0, 0, 0, "balanced"),
(22149, 22149, "Ritual Offering", 0, "", 0, "Monster3.zombie_enlisted_man", 17, 22.3, 78, "male", "L2Monster", 80, 4664, 4599, 13.43, 3.09, 40, 43, 30, 21, 20, 10, 13991, 666, 1517, 793, 1144, 780, 278, 0, 333, 0, 0, 0, 38, 180, "NULL", 0, 1, 0, "LAST_HIT", 0, 0, 0, "balanced"),
(22150, 22150, "Triol's Believer", 0, "", 0, "Monster3.heretic_privates", 7.7, 28.4, 78, "male", "L2Monster", 80, 4717, 4599, 13.43, 3.09, 40, 43, 30, 21, 20, 10, 14150, 674, 1719, 793, 1144, 780, 278, 300, 333, 8205, 0, 0, 60, 180, "NULL", 0, 0, 0, "LAST_HIT", 0, 0, 0, "balanced"),
(22151, 22151, "Triol's Priest", 0, "", 0, "Monster3.heretic_privates", 7.7, 28.4, 78, "male", "L2Monster", 80, 4814, 4599, 13.43, 3.09, 40, 43, 30, 21, 20, 10, 14441, 688, 1719, 793, 1144, 780, 278, 300, 333, 8205, 0, 0, 60, 180, "NULL", 0, 0, 0, "LAST_HIT", 0, 0, 0, "balanced"),
(22152, 22152, "Temple Guard", 0, "", 0, "Monster3.zombie_em_knight", 17, 22.3, 78, "male", "L2Monster", 80, 4767, 2699, 13.43, 3.09, 40, 43, 30, 21, 20, 10, 14300, 681, 1869, 793, 1144, 780, 236, 300, 333, 8215, 0, 0, 38, 180, "NULL", 0, 1, 0, "LAST_HIT", 0, 0, 0, "fighter"),
(22153, 22153, "Temple Guard Captain", 0, "", 0, "Monster3.zombie_em_knight", 17, 22.3, 78, "male", "L2Monster", 80, 4767, 3201, 13.43, 3.09, 40, 43, 30, 21, 20, 10, 14300, 681, 1899, 793, 1144, 780, 236, 300, 333, 8215, 0, 0, 38, 180, "NULL", 0, 1, 0, "LAST_HIT", 0, 0, 0, "fighter"),
(22154, 22154, "Ritual Sacrifice", 0, "", 0, "Monster3.self_blaster", 9, 25.8, 78, "male", "L2Monster", 80, 4814, 3201, 13.43, 3.09, 40, 43, 31, 21, 20, 10, 14441, 688, 1719, 677, 1144, 780, 278, 0, 333, 0, 0, 0, 30, 200, "NULL", 0, 1, 0, "LAST_HIT", 0, 0, 0, "balanced"),
(22155, 22155, "Triol's High Priest", 0, "", 0, "Monster3.heretic_priest_a", 8, 19.1, 78, "male", "L2Monster", 80, 4814, 5505, 13.43, 3.09, 40, 43, 30, 21, 20, 10, 14441, 688, 1883, 793, 1244, 780, 278, 300, 333, 8206, 8206, 0, 30, 180, "NULL", 0, 0, 0, "LAST_HIT", 0, 0, 0, "balanced"),
(22156, 22156, "Triol's Priest", 0, "", 0, "Monster3.heretic_privates", 7.7, 28.4, 78, "male", "L2Monster", 80, 4858, 4599, 13.43, 3.09, 40, 43, 30, 21, 20, 10, 14574, 694, 1719, 793, 1144, 780, 278, 300, 333, 8205, 0, 0, 60, 180, "NULL", 0, 0, 0, "LAST_HIT", 0, 0, 0, "balanced"),
(22157, 22157, "Triol's Priest", 0, "", 0, "Monster3.heretic_privates", 7.7, 28.4, 78, "male", "L2Monster", 80, 4814, 4599, 13.43, 3.09, 40, 43, 30, 21, 20, 10, 14441, 688, 1719, 793, 1144, 780, 278, 300, 333, 8205, 0, 0, 60, 180, "NULL", 0, 0, 0, "LAST_HIT", 0, 0, 0, "balanced"),
(22158, 22158, "Triol's Believer", 0, "", 0, "Monster3.heretic_privates_a", 7.7, 28.4, 78, "male", "L2Monster", 80, 4814, 4599, 13.43, 3.09, 40, 43, 30, 21, 20, 10, 14441, 688, 1650, 793, 1214, 780, 278, 300, 333, 8207, 8207, 0, 58, 180, "NULL", 0, 0, 0, "LAST_HIT", 0, 0, 0, "balanced"),
(22159, 22159, "Triol's High Priest", 0, "", 0, "Monster3.heretic_priest_a", 8, 19.1, 78, "male", "L2Monster", 80, 4858, 5505, 13.43, 3.09, 40, 43, 30, 21, 20, 10, 14574, 694, 1883, 793, 1144, 780, 278, 300, 333, 8206, 8206, 0, 30, 180, "NULL", 0, 0, 0, "LAST_HIT", 0, 0, 0, "fighter"),
(22160, 22160, "Triol's Priest", 0, "", 0, "Monster3.heretic_privates", 7.7, 28.4, 78, "male", "L2Monster", 80, 4858, 4599, 13.43, 3.09, 40, 43, 30, 21, 20, 10, 14574, 694, 1719, 793, 1144, 780, 278, 300, 333, 8205, 0, 0, 60, 180, "NULL", 0, 0, 0, "LAST_HIT", 0, 0, 0, "balanced"),
(22161, 22161, "Ritual Sacrifice", 0, "", 0, "Monster3.self_blaster", 9, 25.8, 78, "male", "L2Monster", 80, 4814, 2439, 13.43, 3.09, 40, 43, 30, 21, 20, 10, 14441, 688, 1719, 793, 1144, 780, 278, 0, 333, 0, 0, 0, 30, 200, "NULL", 0, 1, 0, "LAST_HIT", 0, 0, 0, "balanced"),
(22162, 22162, "Triol's Believer", 0, "", 0, "Monster3.heretic_privates_a", 7.7, 28.4, 78, "male", "L2Monster", 80, 4814, 4599, 13.43, 3.09, 40, 43, 30, 21, 20, 10, 14441, 688, 1883, 793, 1214, 780, 278, 300, 333, 8207, 8207, 0, 58, 180, "NULL", 0, 0, 0, "LAST_HIT", 0, 0, 0, "fighter"),
(22163, 22163, "Triol's High Priest", 0, "", 0, "Monster3.heretic_priest", 8, 19.1, 78, "male", "L2Monster", 80, 4858, 5605, 13.43, 3.09, 40, 43, 30, 21, 20, 10, 14574, 694, 1719, 793, 1144, 780, 278, 300, 333, 8208, 0, 0, 30, 180, "NULL", 0, 0, 0, "LAST_HIT", 0, 0, 0, "balanced"),
(22164, 22164, "Triol's Believer", 0, "", 0, "Monster3.heretic_privates_a", 7.7, 28.4, 78, "male", "L2Monster", 80, 4858, 4599, 13.43, 3.09, 40, 43, 30, 21, 20, 10, 14574, 694, 1916, 793, 1301, 780, 278, 300, 333, 8207, 8207, 0, 58, 180, "NULL", 0, 0, 0, "LAST_HIT", 0, 0, 0, "balanced"),
(22165, 22165, "Triol's Priest", 0, "", 0, "Monster3.heretic_privates", 7.7, 28.4, 78, "male", "L2Monster", 80, 4814, 4599, 13.43, 3.09, 40, 43, 30, 21, 20, 10, 14441, 688, 1719, 793, 1144, 780, 278, 300, 333, 8205, 0, 0, 60, 180, "NULL", 0, 0, 0, "LAST_HIT", 0, 0, 0, "balanced"),
(22166, 22166, "Triol's Believer", 0, "", 0, "Monster3.heretic_privates", 7.7, 28.4, 78, "male", "L2Monster", 80, 4814, 4599, 13.43, 3.09, 40, 43, 30, 21, 20, 10, 14441, 688, 1916, 793, 1301, 780, 278, 300, 333, 8205, 0, 0, 60, 180, "NULL", 0, 0, 0, "LAST_HIT", 0, 0, 0, "balanced"),
(22167, 22167, "Triol's High Priest", 0, "", 0, "Monster3.heretic_priest_a", 8, 19.1, 78, "male", "L2Monster", 80, 4900, 6505, 13.43, 3.09, 40, 43, 30, 21, 20, 10, 14699, 700, 1883, 793, 1144, 780, 278, 300, 333, 8206, 8206, 0, 30, 180, "NULL", 0, 0, 0, "LAST_HIT", 0, 0, 0, "fighter"),
(22168, 22168, "Triol's Priest", 0, "", 0, "Monster3.heretic_privates", 7.7, 28.4, 78, "male", "L2Monster", 80, 4900, 4599, 13.43, 3.09, 40, 43, 30, 21, 20, 10, 14699, 700, 1719, 793, 1144, 780, 278, 300, 333, 8205, 0, 0, 60, 180, "NULL", 0, 0, 0, "LAST_HIT", 0, 0, 0, "balanced"),
(22169, 22169, "Ritual Sacrifice", 0, "", 0, "Monster3.self_blaster", 9, 25.8, 78, "male", "L2Monster", 80, 4858, 2439, 13.43, 3.09, 40, 43, 30, 21, 20, 10, 14574, 694, 1719, 793, 1144, 780, 278, 0, 333, 0, 0, 0, 30, 200, "NULL", 0, 1, 0, "LAST_HIT", 0, 0, 0, "balanced"),
(22170, 22170, "Triol's Believer", 0, "", 0, "Monster3.heretic_privates_a", 7.7, 28.4, 78, "male", "L2Monster", 80, 4858, 4599, 13.43, 3.09, 40, 43, 30, 21, 20, 10, 14574, 694, 2033, 793, 1301, 780, 278, 300, 333, 8207, 8207, 0, 58, 180, "NULL", 0, 0, 0, "LAST_HIT", 0, 0, 0, "fighter"),
(22171, 22171, "Triol's High Priest", 0, "", 0, "Monster3.heretic_priest", 8, 19.1, 78, "male", "L2Monster", 80, 4900, 5605, 13.43, 3.09, 40, 43, 30, 21, 20, 10, 14699, 700, 1719, 793, 1144, 780, 278, 300, 333, 8208, 0, 0, 30, 180, "NULL", 0, 0, 0, "LAST_HIT", 0, 0, 0, "balanced"),
(22172, 22172, "Ritual Sacrifice", 0, "", 0, "Monster3.self_blaster", 9, 25.8, 78, "male", "L2Monster", 80, 4858, 2439, 13.43, 3.09, 40, 43, 30, 21, 20, 10, 14574, 694, 1719, 793, 1144, 780, 278, 0, 333, 0, 0, 0, 30, 200, "NULL", 0, 1, 0, "LAST_HIT", 0, 0, 0, "balanced"),
(22173, 22173, "Triol's Priest", 0, "", 0, "Monster3.heretic_privates", 7.7, 28.4, 78, "male", "L2Monster", 80, 4858, 4599, 13.43, 3.09, 40, 43, 30, 21, 20, 10, 14574, 694, 1719, 793, 1144, 780, 278, 300, 333, 8205, 0, 0, 60, 180, "NULL", 0, 0, 0, "LAST_HIT", 0, 0, 0, "balanced"),
(22174, 22174, "Triol's Priest", 0, "", 0, "Monster3.heretic_privates", 7.7, 28.4, 78, "male", "L2Monster", 80, 4814, 4325, 13.43, 3.09, 40, 43, 30, 21, 20, 10, 14441, 688, 1719, 793, 1144, 780, 278, 300, 333, 8205, 0, 0, 60, 180, "NULL", 0, 0, 0, "LAST_HIT", 0, 0, 0, "balanced"),
(22175, 22175, "Andreas' Captain of the Royal Guard", 0, "", 0, "Monster3.zombie_em_knight", 20, 22, 78, "male", "L2Monster", 80, 4812, 430, 13.43, 3.09, 40, 43, 30, 21, 20, 10, 14436, 688, 1719, 793, 1144, 780, 500, 500, 555, 8218, 0, 0, 61, 180, "NULL", 0, 1, 0, "LAST_HIT", 0, 0, 0, "balanced"),
(22176, 22176, "Andreas' Royal Guards", 0, "", 0, "Monster3.zombie_em_knight", 20, 23, 78, "male", "L2Monster", 80, 4812, 430, 13.43, 3.09, 40, 43, 25, 21, 20, 10, 14436, 688, 2475, 1108, 1144, 780, 300, 500, 555, 8207, 0, 0, 61, 180, "NULL", 0, 1, 0, "LAST_HIT", 0, 0, 0, "fighter"),
(22188, 22188, "Andreas' Captain of the Royal Guard", 0, "", 0, "Monster3.heretic_priest_120p", 20, 23, 78, "male", "L2Monster", 80, 4899, 4599, 13.43, 3.09, 40, 43, 31, 21, 20, 10, 14698, 700, 2682, 960, 1566, 780, 300, 500, 555, 8206, 0, 0, 61, 180, "NULL", 0, 0, 0, "LAST_HIT", 0, 0, 0, "fighter"),
(22189, 22189, "Andreas' Royal Guards", 0, "", 0, "Monster3.heretic_privates_120p", 22, 34, 78, "male", "L2Monster", 80, 4858, 2439, 13.43, 3.09, 40, 43, 32, 21, 20, 10, 14574, 694, 2682, 960, 1566, 780, 460, 500, 555, 8208, 0, 0, 61, 180, "NULL", 0, 0, 0, "LAST_HIT", 0, 0, 0, "fighter"),
(22190, 22190, "Ritual Sacrifice", 0, "", 0, "Monster3.self_blaster", 20, 23, 78, "male", "L2Monster", 80, 4858, 2439, 13.43, 3.09, 40, 43, 30, 21, 20, 10, 14574, 694, 1883, 793, 1144, 780, 300, 0, 555, 0, 0, 0, 61, 180, "NULL", 0, 1, 0, "LAST_HIT", 0, 0, 0, "fighter"),
(22191, 22191, "Andreas' Captain of the Royal Guard", 0, "", 0, "Monster3.heretic_priest_120p", 20, 23, 78, "male", "L2Monster", 80, 7350, 4560, 13.43, 3.09, 40, 43, 30, 21, 20, 10, 22049, 1050, 1719, 793, 1144, 780, 300, 300, 555, 8206, 0, 0, 61, 180, "NULL", 0, 0, 0, "LAST_HIT", 0, 0, 0, "balanced"),
(22192, 22192, "Andreas' Royal Guards", 0, "", 0, "Monster3.heretic_privates_120p", 20, 23, 78, "male", "L2Monster", 80, 9716, 2439, 13.43, 3.09, 40, 43, 30, 21, 20, 10, 29148, 1388, 1719, 793, 1144, 780, 300, 500, 555, 8206, 0, 0, 61, 180, "NULL", 0, 0, 0, "LAST_HIT", 0, 0, 0, "balanced"),
(22193, 22193, "Andreas' Royal Guards", 0, "", 0, "Monster3.heretic_privates_120p", 20, 23, 78, "male", "L2Monster", 80, 9716, 2439, 13.43, 3.09, 40, 43, 30, 21, 20, 10, 29148, 1388, 1719, 793, 1144, 780, 600, 500, 555, 8206, 0, 0, 61, 180, "NULL", 0, 0, 0, "LAST_HIT", 0, 0, 0, "balanced"),
(22194, 22194, "Penance Guard", 0, "", 0, "Monster3.zombie_gateguard_slp", 40, 22, 78, "male", "L2Monster", 80, 4608, 1566, 13.43, 3.09, 40, 43, 30, 21, 20, 10, 13824, 658, 2475, 1108, 1544, 780, 278, 300, 333, 8217, 0, 0, 33, 120, "NULL", 0, 1, 0, "LAST_HIT", 0, 0, 0, "fighter"),
(22195, 22195, "Ritual Sacrifice", 0, "", 0, "Monster3.self_blaster", 20, 31, 78, "male", "L2Monster", 80, 100000, 9999, 13.43, 3.09, 40, 43, 30, 21, 20, 10, 3083, 500, 3109, 755, 1893, 651, 278, 0, 333, 0, 0, 0, 88, 132, "NULL", 0, 0, 0, "LAST_HIT", 0, 0, 0, "fighter"),
(22196, 22196, "Velociraptor", 0, "", 0, "Monster3.velociraptor", 20, 47.2, 80, "male", "L2Monster", 80, 26612, 2296, 13.43, 3.09, 40, 43, 30, 21, 20, 10, 11031, 1351, 2199, 625, 1373, 521, 278, 1000, 333, 0, 0, 0, 33, 180, "dino", 500, 0, 0, "LAST_HIT", 0, 0, 0, "fighter"),
(22197, 22197, "Velociraptor", 0, "", 0, "Monster3.velociraptor", 20, 47.2, 80, "male", "L2Monster", 80, 14019, 2296, 13.43, 3.09, 40, 43, 30, 21, 20, 10, 35331, 3824, 2199, 625, 1373, 521, 278, 1000, 333, 0, 0, 0, 33, 210, "dino", 500, 0, 0, "LAST_HIT", 0, 0, 0, "fighter"),
(22198, 22198, "Velociraptor", 0, "", 0, "Monster3.velociraptor", 20, 47.2, 80, "male", "L2Monster", 80, 28039, 2296, 13.43, 3.09, 40, 43, 30, 21, 20, 10, 77389, 8410, 2199, 625, 1373, 521, 278, 1000, 333, 0, 0, 0, 33, 170, "dino", 500, 0, 0, "LAST_HIT", 0, 0, 0, "fighter"),
(22199, 22199, "Pterosaur", 0, "", 0, "Monster3.rhamphorhynchus", 36, 43.7, 80, "male", "L2Monster", 80, 112798, 2339, 13.43, 3.09, 40, 43, 30, 21, 20, 10, 11131, 1401, 2269, 635, 1413, 531, 278, 1000, 333, 0, 0, 0, 88, 188, "dino", 500, 0, 0, "LAST_HIT", 0, 0, 0, "fighter"),
(22200, 22200, "Ornithomimus", 0, "", 0, "Monster3.ornithomimus", 15, 37.2, 80, "male", "L2Monster", 80, 13858, 2211, 13.43, 3.09, 40, 43, 30, 21, 20, 10, 35183, 3716, 2298, 612, 1296, 502, 278, 1000, 333, 0, 0, 0, 36, 170, "dino", 500, 0, 0, "LAST_HIT", 0, 0, 0, "fighter"),
(22201, 22201, "Ornithomimus", 0, "", 0, "Monster3.ornithomimus", 15, 37.2, 80, "male", "L2Monster", 80, 13858, 2211, 13.43, 3.09, 40, 43, 30, 21, 20, 10, 35183, 3698, 2298, 612, 1296, 502, 278, 1000, 333, 0, 0, 0, 36, 200, "dino", 500, 0, 0, "LAST_HIT", 0, 0, 0, "fighter"),
(22202, 22202, "Ornithomimus", 0, "", 0, "Monster3.ornithomimus", 15, 37.2, 80, "male", "L2Monster", 80, 13858, 2211, 13.43, 3.09, 40, 43, 30, 21, 20, 10, 35183, 3716, 2298, 612, 1296, 502, 278, 1000, 333, 0, 0, 0, 36, 160, "dino", 500, 0, 0, "LAST_HIT", 0, 0, 0, "fighter"),
(22203, 22203, "Deinonychus", 0, "", 0, "Monster3.deinonychus", 14, 14.3, 80, "male", "L2Monster", 80, 13763, 2168, 13.43, 3.09, 40, 43, 30, 21, 20, 10, 33592, 3508, 2695, 571, 1258, 494, 278, 1000, 333, 0, 0, 0, 24, 160, "dino", 500, 0, 0, "LAST_HIT", 0, 0, 0, "fighter"),
(22204, 22204, "Deinonychus", 0, "", 0, "Monster3.deinonychus", 14, 14.3, 80, "male", "L2Monster", 80, 13763, 2168, 13.43, 3.09, 40, 43, 30, 21, 20, 10, 32759, 3422, 2695, 571, 1258, 494, 278, 1000, 333, 0, 0, 0, 24, 190, "dino", 500, 0, 0, "LAST_HIT", 0, 0, 0, "fighter"),
(22205, 22205, "Deinonychus", 0, "", 0, "Monster3.deinonychus", 14, 14.3, 80, "male", "L2Monster", 80, 13763, 2168, 13.43, 3.09, 40, 43, 30, 21, 20, 10, 33591, 3508, 2695, 571, 1258, 494, 278, 1000, 333, 0, 0, 0, 24, 160, "dino", 500, 0, 0, "LAST_HIT", 0, 0, 0, "fighter"),
(22208, 22208, "Pachycephalosaurus", 0, "", 0, "Monster3.pachycephalosaurus", 22, 40, 80, "male", "L2Monster", 80, 13953, 2253, 13.43, 3.09, 40, 43, 30, 21, 20, 10, 39261, 4198, 2129, 615, 1333, 511, 278, 1000, 333, 0, 0, 0, 33, 150, "dino", 500, 0, 0, "LAST_HIT", 0, 0, 0, "fighter"),
(22209, 22209, "Pachycephalosaurus", 0, "", 0, "Monster3.pachycephalosaurus", 22, 40, 80, "male", "L2Monster", 80, 13953, 2253, 13.43, 3.09, 40, 43, 30, 21, 20, 10, 35898, 3839, 2129, 615, 1333, 511, 278, 1000, 333, 0, 0, 0, 33, 170, "dino", 500, 0, 0, "LAST_HIT", 0, 0, 0, "fighter"),
(22210, 22210, "Pachycephalosaurus", 0, "", 0, "Monster3.pachycephalosaurus", 22, 40, 80, "male", "L2Monster", 80, 13953, 2253, 13.43, 3.09, 40, 43, 30, 21, 20, 10, 39031, 4176, 2129, 615, 1333, 511, 278, 1000, 333, 0, 0, 0, 33, 150, "dino", 500, 0, 0, "LAST_HIT", 0, 0, 0, "fighter"),
(22211, 22211, "Wild Strider", 0, "", 0, "Monster3.wild_giant_strider", 32, 44.2, 80, "male", "L2Monster", 80, 13953, 2253, 13.43, 3.09, 40, 43, 30, 21, 20, 10, 36753, 3952, 2129, 615, 1333, 511, 278, 1000, 333, 0, 0, 0, 50, 150, "dino", 500, 0, 0, "LAST_HIT", 0, 0, 0, "fighter"),
(22212, 22212, "Wild Strider", 0, "", 0, "Monster3.wild_giant_strider", 32, 44.2, 80, "male", "L2Monster", 80, 13953, 2253, 13.43, 3.09, 40, 43, 30, 21, 20, 10, 35263, 3771, 2129, 615, 1333, 511, 278, 1000, 333, 0, 0, 0, 50, 170, "dino", 500, 0, 0, "LAST_HIT", 0, 0, 0, "fighter"),
(22213, 22213, "Wild Strider", 0, "", 0, "Monster3.wild_giant_strider", 32, 44.2, 80, "male", "L2Monster", 80, 13953, 2253, 13.43, 3.09, 40, 43, 30, 21, 20, 10, 36753, 3952, 2129, 615, 1333, 511, 278, 1000, 333, 0, 0, 0, 50, 150, "dino", 500, 0, 0, "LAST_HIT", 0, 0, 0, "fighter"),
(22214, 22214, "Elroki", 0, "", 0, "Monster3.Crokian_Officer", 25, 33, 80, "male", "L2Monster", 80, 27907, 2253, 13.43, 3.09, 40, 43, 30, 21, 20, 10, 34669, 3723, 2129, 615, 1333, 511, 278, 1000, 333, 0, 0, 0, 60, 180, "dino", 500, 0, 0, "LAST_HIT", 0, 0, 0, "fighter"),
(22215, 22215, "Tyrannosaurus", 0, "", 0, "Monster3.tyranosaurus", 60, 89.7, 80, "male", "L2GrandBoss", 80, 327855, 2339, 13.43, 3.09, 40, 43, 30, 21, 20, 10, 11131, 1401, 2269, 635, 1413, 531, 278, 1000, 333, 0, 0, 0, 88, 188, "dino", 500, 0, 12, "LAST_HIT", 0, 0, 0, "balanced"),
(22216, 22216, "Tyrannosaurus", 0, "", 0, "Monster3.tyranosaurus", 60, 89.7, 80, "male", "L2GrandBoss", 80, 327855, 2339, 13.43, 3.09, 40, 43, 30, 21, 20, 10, 11131, 1401, 2269, 635, 1413, 531, 278, 1000, 333, 0, 0, 0, 88, 188, "dino", 500, 0, 12, "LAST_HIT", 0, 0, 0, "balanced"),
(22217, 22217, "Tyrannosaurus", 0, "", 0, "Monster3.tyranosaurus", 60, 89.7, 80, "male", "L2GrandBoss", 80, 327855, 2339, 13.43, 3.09, 40, 43, 30, 21, 20, 10, 11131, 1401, 2269, 635, 1413, 531, 278, 1000, 333, 0, 0, 0, 88, 188, "dino", 500, 0, 12, "LAST_HIT", 0, 0, 0, "balanced"),
(22218, 22218, "Velociraptor", 0, "", 0, "Monster3.velociraptor", 20, 47.2, 80, "male", "L2Monster", 80, 14019, 2296, 13.43, 3.09, 40, 43, 30, 21, 20, 10, 33439, 3595, 2199, 625, 1373, 521, 278, 1000, 333, 0, 0, 0, 33, 200, "dino", 500, 0, 0, "LAST_HIT", 0, 0, 0, "fighter"),
(22219, 22219, "Ornithomimus", 0, "", 0, "Monster3.ornithomimus", 15, 37.2, 80, "male", "L2Monster", 80, 13858, 2211, 13.43, 3.09, 40, 43, 30, 21, 20, 10, 31854, 3365, 2298, 612, 1296, 502, 278, 1000, 333, 0, 0, 0, 36, 190, "dino", 500, 0, 0, "LAST_HIT", 0, 0, 0, "fighter"),
(22220, 22220, "Deinonychus", 0, "", 0, "Monster3.deinonychus", 14, 14.3, 80, "male", "L2Monster", 80, 13763, 2168, 13.43, 3.09, 40, 43, 30, 21, 20, 10, 27724, 2891, 2695, 571, 1258, 494, 278, 1000, 333, 0, 0, 0, 24, 180, "dino", 500, 0, 0, "LAST_HIT", 0, 0, 0, "fighter"),
(22221, 22221, "Pachycephalosaurus", 0, "", 0, "Monster3.pachycephalosaurus", 22, 40, 80, "male", "L2Monster", 80, 13953, 2211, 13.43, 3.09, 40, 43, 30, 21, 20, 10, 30806, 3254, 2298, 612, 1296, 502, 278, 1000, 333, 0, 0, 0, 33, 150, "dino", 500, 0, 0, "LAST_HIT", 0, 0, 0, "fighter"),
(22222, 22222, "Wild Strider", 0, "", 0, "Monster3.wild_giant_strider", 32, 44.2, 80, "male", "L2Monster", 80, 13953, 2253, 13.43, 3.09, 40, 43, 30, 21, 20, 10, 30637, 3274, 2129, 615, 1333, 511, 278, 1000, 333, 0, 0, 0, 50, 150, "dino", 500, 0, 0, "LAST_HIT", 0, 0, 0, "fighter"),
(22223, 22223, "Velociraptor", 0, "", 0, "Monster3.velociraptor", 19, 47.2, 80, "male", "L2Monster", 80, 14019, 2296, 13.43, 3.09, 40, 43, 30, 21, 20, 10, 34684, 3755, 2199, 625, 1373, 521, 278, 1000, 333, 0, 0, 0, 88, 188, "dino", 500, 0, 0, "LAST_HIT", 0, 0, 0, "fighter"),
(22224, 22224, "Ornithomimus", 0, "", 0, "Monster3.ornithomimus", 15, 37.2, 80, "male", "L2Monster", 80, 13858, 2211, 13.43, 3.09, 40, 43, 30, 21, 20, 10, 32698, 3456, 2298, 612, 1296, 502, 278, 1000, 333, 0, 0, 0, 36, 170, "dino", 500, 0, 0, "LAST_HIT", 0, 0, 0, "fighter"),
(22225, 22225, "Deinonychus", 0, "", 0, "Monster3.deinonychus", 14, 14.3, 80, "male", "L2Monster", 80, 13763, 2168, 13.43, 3.09, 40, 43, 30, 21, 20, 10, 30343, 3187, 2695, 571, 1258, 494, 278, 1000, 333, 0, 0, 0, 24, 160, "dino", 500, 0, 0, "LAST_HIT", 0, 0, 0, "fighter"),
(22226, 22226, "Pachycephalosaurus", 0, "", 0, "Monster3.pachycephalosaurus", 22, 40, 80, "male", "L2Monster", 80, 13953, 2253, 13.43, 3.09, 40, 43, 30, 21, 20, 10, 35125, 3733, 2129, 615, 1333, 511, 278, 1000, 333, 0, 0, 0, 33, 140, "dino", 500, 0, 0, "LAST_HIT", 0, 0, 0, "fighter"),
(22227, 22227, "Wild Strider", 0, "", 0, "Monster3.wild_giant_strider", 32, 44.2, 80, "male", "L2Monster", 80, 13953, 2253, 13.43, 3.09, 40, 43, 30, 21, 20, 10, 34440, 3682, 2129, 615, 1333, 511, 278, 1000, 333, 0, 0, 0, 50, 140, "dino", 500, 0, 0, "LAST_HIT", 0, 0, 0, "fighter"),
(22228, 22228, "Grey Elpy", 0, "", 0, "LineageMonster.elpy", 5, 4.5, 1, "male", "L2Monster", 40, 62, 44, 3.16, 0.91, 40, 43, 30, 21, 20, 10, 35, 2, 9, 39, 3, 32, 278, 0, 333, 0, 0, 0, 50, 80, "NULL", 0, 0, 0, "LAST_HIT", 0, 0, 0, "fighter"),
(22229, 22229, "Young Grey Keltir", 0, "", 0, "LineageMonster.keltir", 9.5, 10, 1, "male", "L2Monster", 40, 62, 44, 3.16, 0.91, 40, 43, 30, 21, 20, 10, 29, 2, 4, 39, 3, 32, 278, 0, 333, 0, 0, 0, 23, 110, "NULL", 0, 0, 0, "LAST_HIT", 0, 0, 0, "balanced"),
(22230, 22230, "Grey Keltir", 0, "", 0, "LineageMonster.keltir", 9.5, 10, 2, "male", "L2Monster", 40, 75, 52, 3.16, 0.91, 40, 43, 30, 21, 20, 10, 70, 2, 10, 42, 3, 34, 278, 0, 333, 0, 0, 0, 23, 110, "NULL", 0, 0, 0, "LAST_HIT", 0, 0, 0, "fighter"),
(22231, 22231, "Dominant Grey Keltir", 0, "", 0, "LineageMonster.keltir", 9.5, 10, 3, "male", "L2Monster", 40, 90, 60, 3.16, 0.91, 40, 43, 30, 21, 20, 10, 105, 2, 11, 44, 3, 35, 278, 0, 333, 0, 0, 0, 23, 110, "NULL", 0, 0, 0, "LAST_HIT", 0, 0, 0, "fighter"),
(22232, 22232, "Black Wolf", 0, "", 0, "LineageMonster.wolf", 13, 9, 4, "male", "L2Monster", 40, 107, 68, 3.16, 0.91, 40, 43, 30, 21, 20, 10, 121, 3, 13, 42, 4, 37, 278, 0, 333, 0, 0, 0, 24, 110, "NULL", 0, 0, 0, "LAST_HIT", 0, 0, 0, "fighter"),
(22233, 22233, "Dominant Black Wolf", 0, "", 0, "LineageMonster.wolf_bi", 13, 10.8, 5, "male", "L2Monster", 40, 126, 77, 3.16, 0.91, 40, 43, 30, 21, 20, 10, 178, 5, 13, 48, 4, 39, 278, 0, 333, 0, 0, 0, 24, 110, "NULL", 0, 0, 0, "LAST_HIT", 0, 0, 0, "fighter"),
(22234, 22234, "Green Goblin", 0, "", 0, "LineageMonster.goblin", 10, 16.5, 6, "male", "L2Monster", 40, 147, 85, 3.16, 0.91, 40, 43, 30, 21, 20, 10, 211, 6, 15, 50, 5, 41, 278, 0, 333, 4, 0, 0, 40, 110, "NULL", 0, 0, 0, "LAST_HIT", 0, 0, 0, "fighter"),
(22235, 22235, "Mountain Werewolf", 0, "", 0, "LineageMonster.werewolf", 10, 26, 7, "male", "L2Monster", 40, 171, 94, 1.58, 0.91, 40, 43, 30, 21, 20, 10, 334, 12, 20, 44, 6, 43, 278, 0, 333, 5, 0, 0, 50, 120, "NULL", 0, 0, 0, "LAST_HIT", 0, 0, 0, "fighter"),
(22236, 22236, "Muertos Archer", 0, "", 0, "LineageMonster4.Mostro_Gunner", 15, 24.5, 8, "male", "L2Monster", 40, 197, 102, 3.16, 0.91, 40, 43, 30, 21, 20, 10, 293, 10, 41, 55, 6, 45, 278, 0, 333, 10128, 0, 0, 36, 110, "NULL", 0, 0, 0, "LAST_HIT", 0, 0, 0, "fighter"),
(22237, 22237, "Mountain Fungus", 0, "", 0, "LineageMonster.walking_fungus", 15, 22.5, 9, "male", "L2Monster", 40, 226, 111, 3.16, 0.91, 40, 43, 30, 21, 20, 10, 321, 11, 22, 53, 7, 47, 278, 0, 333, 0, 0, 0, 70, 110, "NULL", 0, 0, 0, "LAST_HIT", 0, 0, 0, "fighter"),
(22238, 22238, "Mountain Werewolf Chief", 0, "", 0, "LineageMonster.werewolf_bi", 11, 29.7, 10, "male", "L2Monster", 40, 257, 120, 3.16, 0.91, 40, 43, 30, 21, 20, 10, 356, 12, 20, 67, 8, 49, 278, 0, 333, 5, 0, 0, 50, 120, "NULL", 0, 0, 0, "LAST_HIT", 0, 0, 0, "fighter"),
(22239, 22239, "Muertos Guard", 0, "", 0, "LineageMonster4.Mostro_Fighter", 15.5, 22.5, 11, "male", "L2Monster", 40, 292, 129, 3.95, 1.21, 40, 43, 30, 21, 20, 10, 391, 15, 27, 58, 9, 52, 278, 0, 333, 0, 0, 0, 36, 120, "NULL", 0, 0, 0, "LAST_HIT", 0, 0, 0, "fighter"),
(22240, 22240, "Muertos Scout", 0, "", 0, "LineageMonster4.Mostro_Fighter", 15.5, 22.5, 12, "male", "L2Monster", 40, 315, 138, 3.95, 1.21, 40, 43, 30, 21, 20, 10, 436, 16, 27, 66, 10, 54, 278, 0, 333, 0, 0, 0, 36, 120, "NULL", 0, 0, 0, "LAST_HIT", 0, 0, 0, "fighter"),
(22241, 22241, "Colossus", 0, "", 0, "LineageMonster.stone_golem", 20, 31, 13, "male", "L2Monster", 40, 339, 147, 3.95, 1.21, 40, 43, 30, 21, 20, 10, 458, 18, 29, 63, 11, 56, 278, 0, 333, 0, 0, 0, 23, 23, "NULL", 0, 0, 0, "LAST_HIT", 0, 0, 0, "fighter"),
(22242, 22242, "Muertos Warrior", 0, "", 0, "LineageMonster4.Mostro_Fighter", 15.5, 22.5, 14, "male", "L2Monster", 40, 364, 156, 3.95, 1.21, 40, 43, 30, 21, 20, 10, 424, 16, 32, 66, 12, 59, 278, 500, 333, 0, 0, 0, 36, 110, "NULL", 0, 0, 0, "LAST_HIT", 0, 0, 0, "fighter"),
(22243, 22243, "Muertos Captain", 0, "", 0, "LineageMonster4.Mostro_Fighter", 15.5, 22.5, 15, "male", "L2Monster", 40, 390, 165, 3.95, 1.21, 40, 43, 30, 21, 20, 10, 449, 18, 40, 69, 14, 62, 278, 0, 333, 0, 0, 0, 36, 110, "NULL", 0, 0, 0, "LAST_HIT", 0, 0, 0, "fighter"),
(22244, 22244, "Crimson Spider", 0, "", 0, "LineageMonster.giant_spider_05te", 26, 25.5, 16, "male", "L2Monster", 40, 417, 174, 3.95, 1.21, 40, 43, 30, 21, 20, 10, 570, 23, 44, 72, 15, 64, 278, 0, 333, 0, 0, 0, 72, 130, "NULL", 0, 0, 0, "LAST_HIT", 0, 0, 0, "fighter"),
(22245, 22245, "Muertos Lieutenant", 0, "", 0, "LineageMonster4.Mostro_Fighter", 15.5, 22.5, 17, "male", "L2Monster", 40, 446, 184, 3.95, 1.21, 40, 43, 30, 21, 20, 10, 612, 26, 48, 75, 17, 67, 278, 0, 333, 0, 0, 0, 36, 120, "NULL", 0, 0, 0, "LAST_HIT", 0, 0, 0, "fighter"),
(22246, 22246, "Muertos Commander", 0, "", 0, "LineageMonster4.Mostro_Fighter", 15.5, 22.5, 18, "male", "L2Monster", 40, 476, 193, 3.95, 1.21, 40, 43, 30, 21, 20, 10, 633, 28, 53, 79, 19, 70, 278, 500, 333, 0, 0, 0, 33, 132, "NULL", 0, 0, 0, "LAST_HIT", 0, 0, 0, "fighter"),
(22247, 22247, "Grotto Golem", 0, "", 0, "LineageMonster.stone_golem", 20, 31, 15, "male", "L2Monster", 40, 390, 165, 3.95, 1.21, 40, 43, 30, 21, 20, 10, 449, 18, 40, 69, 14, 62, 278, 500, 333, 0, 0, 0, 23, 23, "NULL", 0, 0, 0, "LAST_HIT", 0, 0, 0, "fighter"),
(22248, 22248, "Shady Muertos", 0, "", 0, "LineageMonster4.Mostro_Fighter", 15.5, 22.5, 17, "male", "L2Monster", 40, 446, 184, 3.95, 1.21, 40, 43, 30, 21, 20, 10, 555, 23, 48, 75, 17, 67, 278, 0, 333, 0, 0, 0, 70, 105, "NULL", 0, 0, 0, "LAST_HIT", 0, 0, 0, "fighter"),
(22249, 22249, "Shady Muertos Guard", 0, "", 0, "LineageMonster4.Mostro_Gunner", 15, 24.5, 16, "male", "L2Monster", 40, 417, 174, 3.95, 1.21, 40, 43, 30, 21, 20, 10, 570, 23, 44, 72, 15, 64, 278, 0, 333, 10128, 0, 0, 36, 110, "NULL", 0, 0, 0, "LAST_HIT", 0, 0, 0, "fighter"),
(22250, 22250, "Grotto Leopard", 0, "", 0, "LineageMonster.onyx_beast", 14, 14.5, 16, "male", "L2Monster", 40, 417, 174, 3.95, 1.21, 40, 43, 30, 21, 20, 10, 570, 23, 44, 72, 15, 64, 278, 0, 333, 0, 0, 0, 30, 120, "NULL", 0, 0, 0, "LAST_HIT", 0, 0, 0, "fighter"),
(22251, 22251, "Shady Muertos Captain", 0, "", 0, "LineageMonster4.Mostro_Fighter", 15.5, 22.5, 17, "male", "L2Monster", 40, 446, 184, 3.95, 1.21, 40, 43, 30, 21, 20, 10, 555, 23, 48, 75, 17, 67, 278, 0, 333, 0, 0, 0, 36, 110, "NULL", 0, 0, 0, "LAST_HIT", 0, 0, 0, "fighter"),
(22252, 22252, "Grotto Grizzly", 0, "", 0, "LineageMonster.grizzly", 21, 40, 17, "male", "L2Monster", 40, 446, 184, 3.95, 1.21, 40, 43, 30, 21, 20, 10, 555, 23, 48, 75, 17, 67, 278, 0, 333, 0, 0, 0, 40, 110, "NULL", 0, 0, 0, "LAST_HIT", 0, 0, 0, "fighter"),
(22253, 22253, "Shady Muertos Warrior", 0, "", 0, "LineageMonster4.Mostro_Fighter", 15.5, 22.5, 18, "male", "L2Monster", 40, 476, 193, 3.95, 1.21, 40, 43, 30, 21, 20, 10, 633, 28, 53, 79, 19, 70, 278, 0, 333, 0, 0, 0, 36, 110, "NULL", 0, 0, 0, "LAST_HIT", 0, 0, 0, "fighter"),
(22254, 22254, "Shady Muertos Archer", 0, "", 0, "LineageMonster4.Mostro_Gunner", 15, 24.5, 18, "male", "L2Monster", 500, 476, 193, 3.95, 1.21, 40, 43, 30, 21, 20, 10, 633, 28, 53, 79, 19, 70, 278, 0, 333, 10128, 0, 0, 36, 110, "NULL", 0, 0, 0, "LAST_HIT", 0, 0, 0, "fighter"),
(22255, 22255, "Shady Muertos Commander", 0, "", 0, "LineageMonster4.Mostro_Fighter", 15.5, 22.5, 19, "male", "L2Monster", 40, 508, 203, 3.95, 1.21, 40, 43, 30, 21, 20, 10, 592, 26, 58, 82, 21, 73, 278, 0, 333, 0, 0, 0, 36, 110, "NULL", 0, 0, 0, "LAST_HIT", 0, 0, 0, "fighter"),
(22256, 22256, "Shady Muertos Wizard", 0, "", 0, "LineageMonster4.Mostro_Fighter", 15.5, 22.5, 19, "male", "L2Monster", 40, 508, 203, 3.95, 1.21, 40, 43, 30, 21, 20, 10, 592, 26, 58, 82, 21, 73, 278, 0, 333, 0, 0, 0, 36, 110, "NULL", 0, 0, 0, "LAST_HIT", 0, 0, 0, "fighter"),
(22257, 22257, "Island Guardian", 0, "", 0, "LineageMonster.light_worm_250p", 40, 47, 78, "male", "L2Monster", 40, 4428, 1784, 26.86, 3.09, 40, 43, 30, 21, 20, 10, 10240, 1120, 2075, 459, 1069, 451, 278, 0, 333, 0, 0, 0, 39, 192, "NULL", 0, 0, 0, "LAST_HIT", 0, 0, 0, "fighter"),
(22258, 22258, "White Sand Mirage", 0, "", 0, "LineageMonster.undine", 40, 28, 79, "male", "L2Monster", 40, 4490, 1821, 26.86, 3.09, 40, 43, 30, 21, 20, 10, 9955, 1103, 1765, 481, 1107, 459, 278, 0, 333, 0, 0, 0, 50, 165, "NULL", 0, 0, 0, "LAST_HIT", 0, 0, 0, "fighter"),
(22259, 22259, "Muddy Coral", 0, "", 0, "LineageMonster.theeder_120p", 40, 39, 80, "male", "L2Monster", 40, 4550, 1859, 26.86, 3.09, 40, 43, 30, 21, 20, 10, 9304, 1044, 1996, 524, 1144, 468, 278, 0, 333, 0, 0, 0, 39, 192, "NULL", 0, 0, 0, "LAST_HIT", 0, 0, 0, "fighter"),
(22260, 22260, "Kleopora", 0, "", 0, "LineageMonster.gargoyle_02te", 35, 50, 80, "male", "L2Monster", 40, 4550, 1859, 26.86, 3.09, 40, 43, 30, 21, 20, 10, 9304, 1044, 1996, 524, 1144, 468, 278, 0, 333, 0, 0, 0, 39, 192, "NULL", 0, 0, 0, "LAST_HIT", 0, 0, 0, "fighter"),
(22261, 22261, "Seychelles", 0, "", 0, "LineageMonster.water_giant_120p", 40, 52, 81, "male", "L2Monster", 40, 4608, 1896, 26.86, 3.09, 40, 43, 30, 21, 20, 10, 14933, 1695, 1863, 499, 1182, 477, 278, 0, 333, 0, 0, 0, 50, 165, "NULL", 0, 0, 0, "LAST_HIT", 0, 0, 0, "fighter"),
(22262, 22262, "Naiad", 0, "", 0, "LineageMonster4.tears", 20, 28, 81, "male", "L2Monster", 40, 4608, 1896, 26.86, 3.09, 40, 43, 30, 21, 20, 10, 14933, 1695, 1863, 499, 1182, 477, 278, 0, 333, 0, 0, 0, 50, 165, "NULL", 0, 0, 0, "LAST_HIT", 0, 0, 0, "fighter"),
(22263, 22263, "Sonneratia", 0, "", 0, "LineageMonster.onyx_beast_bi", 14, 18.7, 82, "male", "L2Monster", 40, 4663, 1934, 26.86, 3.09, 40, 43, 30, 21, 20, 10, 9625, 1106, 1912, 598, 1220, 485, 278, 0, 333, 0, 0, 0, 30, 180, "NULL", 0, 0, 0, "LAST_HIT", 0, 0, 0, "fighter"),
(22264, 22264, "Castalia", 0, "", 0, "LineageMonster4.tears_d", 20, 27.5, 82, "male", "L2Monster", 40, 4663, 1934, 26.86, 3.09, 40, 43, 30, 21, 20, 10, 9625, 1106, 1912, 598, 1220, 485, 278, 0, 333, 9638, 9638, 0, 60, 180, "NULL", 0, 0, 0, "LAST_HIT", 0, 0, 0, "fighter"),
(22265, 22265, "Chrysocolla", 0, "", 0, "LineageMonster4.Crystal_Golem", 34, 47, 83, "male", "L2Monster", 40, 4716, 1972, 26.86, 3.09, 40, 43, 30, 21, 20, 10, 10475, 1217, 2249, 736, 1258, 494, 278, 0, 333, 0, 0, 0, 54, 170, "NULL", 0, 0, 0, "LAST_HIT", 0, 0, 0, "fighter"),
(22266, 22266, "Pythia", 0, "", 0, "LineageMonster4.tears", 20, 27.5, 83, "male", "L2Monster", 40, 4716, 1972, 26.86, 3.09, 40, 43, 30, 21, 20, 10, 10475, 1217, 2249, 736, 1258, 494, 278, 0, 333, 9638, 9638, 0, 60, 180, "NULL", 0, 0, 0, "LAST_HIT", 0, 0, 0, "fighter"),
(22267, 22267, "Dark Water Dragon", 0, "", 0, "LineageMonster3.antaras_ex_b", 42, 34.5, 83, "male", "L2Monster", 40, 4716, 1972, 26.86, 3.09, 40, 43, 30, 21, 20, 10, 10475, 1217, 2249, 736, 1258, 494, 278, 0, 333, 0, 0, 0, 200, 200, "NULL", 0, 0, 0, "LAST_HIT", 0, 0, 0, "fighter"),
(22268, 22268, "Shade", 0, "", 0, "LineageMonster4.eyeless", 36, 43.5, 82, "male", "L2Monster", 40, 4663, 1934, 26.86, 3.09, 40, 43, 30, 21, 20, 10, 9625, 1106, 1912, 598, 1220, 485, 278, 0, 333, 0, 0, 0, 49, 192, "NULL", 0, 0, 0, "LAST_HIT", 0, 0, 0, "fighter"),
(22269, 22269, "Shade", 0, "", 0, "LineageMonster4.eyeless", 36, 43.5, 82, "male", "L2Monster", 40, 4663, 1934, 26.86, 3.09, 40, 43, 30, 21, 20, 10, 9625, 1106, 1912, 598, 1220, 485, 278, 0, 333, 0, 0, 0, 49, 192, "NULL", 0, 0, 0, "LAST_HIT", 0, 0, 0, "fighter"),
(22270, 22270, "Water Dragon Detractor", 0, "", 0, "LineageMonster4.eyeless", 36, 43.5, 82, "male", "L2Monster", 40, 4663, 1934, 26.86, 3.09, 40, 43, 30, 21, 20, 10, 9625, 1106, 1912, 598, 1220, 485, 278, 0, 333, 0, 0, 0, 49, 192, "NULL", 0, 0, 0, "LAST_HIT", 0, 0, 0, "fighter"),
(22271, 22271, "Water Dragon Detractor", 0, "", 0, "LineageMonster4.eyeless", 36, 43.5, 82, "male", "L2Monster", 40, 4663, 1934, 26.86, 3.09, 40, 43, 30, 21, 20, 10, 9625, 1106, 1912, 598, 1220, 485, 278, 0, 333, 0, 0, 0, 49, 192, "NULL", 0, 0, 0, "LAST_HIT", 0, 0, 0, "fighter"),
(22272, 22272, "Beleth's Minion", 0, "", 0, "LineageMonster.vale_master", 32, 35, 82, "male", "L2Monster", 40, 4663, 1934, 26.86, 3.09, 40, 43, 30, 21, 20, 10, 9625, 1106, 1912, 598, 1220, 485, 278, 0, 333, 0, 0, 0, 49, 192, "NULL", 0, 0, 0, "LAST_HIT", 0, 0, 0, "fighter"),
(22273, 22273, "Beleth's Minion", 0, "", 0, "LineageMonster.silhouette", 15, 20, 82, "male", "L2Monster", 40, 4663, 1934, 26.86, 3.09, 40, 43, 30, 21, 20, 10, 9625, 1106, 1912, 598, 1220, 485, 278, 0, 333, 0, 0, 0, 49, 192, "NULL", 0, 0, 0, "LAST_HIT", 0, 0, 0, "fighter"),
(22274, 22274, "Beleth's Minion", 0, "", 0, "LineageMonster.shadeless", 25, 28, 82, "male", "L2Monster", 40, 4663, 1934, 26.86, 3.09, 40, 43, 30, 21, 20, 10, 9625, 1106, 1912, 598, 1220, 485, 278, 0, 333, 0, 0, 0, 49, 192, "NULL", 0, 0, 0, "LAST_HIT", 0, 0, 0, "fighter"),
(22275, 22275, "Gatekeeper Lohan", 0, "", 0, "LineageMonster3.Jungle_Bleeze", 40, 47, 81, "male", "L2Monster", 40, 4608, 1896, 26.86, 3.09, 40, 43, 30, 21, 20, 10, 14933, 1695, 1863, 499, 1182, 477, 278, 0, 333, 0, 0, 0, 50, 165, "NULL", 0, 0, 0, "LAST_HIT", 0, 0, 0, "fighter"),
(22276, 22276, "Gatekeeper of the Square", 0, "", 0, "LineageMonster4.Crystal_Golem", 40, 47, 81, "male", "L2Monster", 40, 4608, 1896, 26.86, 3.09, 40, 43, 30, 21, 20, 10, 14933, 1695, 1863, 499, 1182, 477, 278, 0, 333, 92, 0, 0, 50, 165, "NULL", 0, 0, 0, "LAST_HIT", 0, 0, 0, "fighter"),
(22277, 22277, "Gatekeeper Provo", 0, "", 0, "LineageMonster2.lava_golem", 40, 47, 81, "male", "L2Monster", 40, 4608, 1896, 26.86, 3.09, 40, 43, 30, 21, 20, 10, 14933, 1695, 1863, 499, 1182, 477, 278, 0, 333, 92, 0, 0, 50, 165, "NULL", 0, 0, 0, "LAST_HIT", 0, 0, 0, "fighter"),
(22278, 22278, "Gatekeeper of Fire", 0, "", 0, "LineageMonster4.Crystal_Golem", 40, 47, 81, "male", "L2Monster", 40, 4608, 1896, 26.86, 3.09, 40, 43, 30, 21, 20, 10, 14933, 1695, 1863, 499, 1182, 477, 278, 0, 333, 92, 0, 0, 50, 165, "NULL", 0, 0, 0, "LAST_HIT", 0, 0, 0, "fighter"),
(22279, 22279, "Chromatic Detainee", 0, "", 0, "LineageMonster3.Crokian_Officer", 32, 35, 81, "male", "L2Monster", 40, 4608, 1896, 26.86, 3.09, 40, 43, 30, 21, 20, 10, 14933, 1695, 1863, 499, 1182, 477, 278, 0, 333, 92, 0, 0, 50, 165, "NULL", 0, 0, 0, "LAST_HIT", 0, 0, 0, "fighter"),
(22280, 22280, "Rodo Knight", 0, "", 0, "LineageMonster4.Crystal_Golem", 40, 47, 82, "male", "L2Monster", 40, 4663, 1934, 26.86, 3.09, 40, 43, 30, 21, 20, 10, 9625, 1106, 1912, 598, 1220, 485, 278, 0, 333, 79, 0, 0, 49, 192, "NULL", 0, 0, 0, "LAST_HIT", 0, 0, 0, "fighter"),
(22281, 22281, "Plaza Caiman", 0, "", 0, "LineageMonster3.Crokian_Officer", 40, 47, 1, "male", "L2Monster", 40, 2444, 2444, 0, 0, 10, 10, 10, 10, 10, 10, 0, 0, 500, 500, 500, 500, 253, 0, 253, 0, 0, NULL, 80, 120, "", 0, 0, 0, "LAST_HIT", 0, 0, 0, "balanced"),
(22282, 22282, "Chromatic Detainee", 0, "", 0, "LineageMonster3.Crokian_Officer", 32, 35, 81, "male", "L2Monster", 40, 4608, 1896, 26.86, 3.09, 40, 43, 30, 21, 20, 10, 14933, 1695, 1863, 499, 1182, 477, 278, 0, 333, 92, 0, 0, 50, 165, "NULL", 0, 0, 0, "LAST_HIT", 0, 0, 0, "fighter"),
(22283, 22283, "Plaza Alligot", 0, "", 0, "LineageMonster3.Crokian_Officer", 40, 47, 1, "male", "L2Monster", 40, 2444, 2444, 0, 0, 10, 10, 10, 10, 10, 10, 0, 0, 500, 500, 500, 500, 253, 0, 253, 0, 0, NULL, 80, 120, "", 0, 0, 0, "LAST_HIT", 0, 0, 0, "balanced"),
(22284, 22284, "Chromatic Detainee", 0, "", 0, "LineageMonster.blade_stakato", 32, 35, 81, "male", "L2Monster", 40, 4608, 1896, 26.86, 3.09, 40, 43, 30, 21, 20, 10, 14933, 1695, 1863, 499, 1182, 477, 278, 0, 333, 92, 0, 0, 50, 165, "NULL", 0, 0, 0, "LAST_HIT", 0, 0, 0, "fighter"),
(22285, 22285, "Chromatic Detainee", 0, "", 0, "LineageMonster.blade_stakato", 32, 35, 81, "male", "L2Monster", 40, 4608, 1896, 26.86, 3.09, 40, 43, 30, 21, 20, 10, 14933, 1695, 1863, 499, 1182, 477, 278, 0, 333, 92, 0, 0, 50, 165, "NULL", 0, 0, 0, "LAST_HIT", 0, 0, 0, "fighter"),
(22286, 22286, "Plaza Gaviel", 0, "", 0, "LineageMonster3.Crokian_Officer", 40, 47, 82, "male", "L2Monster", 40, 4663, 1934, 26.86, 3.09, 40, 43, 30, 21, 20, 10, 9625, 1106, 1912, 598, 1220, 485, 278, 0, 333, 79, 0, 0, 49, 192, "NULL", 0, 0, 0, "LAST_HIT", 0, 0, 0, "fighter"),
(22287, 22287, "Crystaline Unicorn", 0, "", 0, "LineageMonster.unicorn", 40, 47, 82, "male", "L2Monster", 40, 4663, 1934, 26.86, 3.09, 40, 43, 30, 21, 20, 10, 9625, 1106, 1912, 598, 1220, 485, 278, 0, 333, 79, 0, 0, 49, 192, "NULL", 0, 0, 0, "LAST_HIT", 0, 0, 0, "fighter"),
(22288, 22288, "Emerald Boar", 0, "", 0, "LineageMonster.giant_wild_hog", 40, 26.82, 82, "male", "L2Monster", 40, 4663, 1934, 26.86, 3.09, 40, 43, 30, 21, 20, 10, 9625, 1106, 1912, 598, 1220, 485, 278, 0, 333, 0, 0, 0, 49, 192, "NULL", 0, 0, 0, "LAST_HIT", 0, 0, 0, "fighter"),
(22289, 22289, "Plaza Helm", 0, "", 0, "LineageMonster2.ketra_warbeast", 40, 47, 1, "male", "L2Monster", 40, 2444, 2444, 0, 0, 10, 10, 10, 10, 10, 10, 0, 0, 500, 500, 500, 500, 253, 0, 253, 0, 0, NULL, 80, 120, "", 0, 0, 0, "LAST_HIT", 0, 0, 0, "balanced"),
(22290, 22290, "Terod's Minion", 0, "", 0, "LineageMonster4.eyeless_080p", 20, 27.5, 82, "male", "L2Monster", 40, 4663, 1934, 26.86, 3.09, 40, 43, 30, 21, 20, 10, 9625, 1106, 1912, 598, 1220, 485, 278, 0, 333, 79, 0, 0, 49, 192, "NULL", 0, 0, 0, "LAST_HIT", 0, 0, 0, "fighter"),
(22291, 22291, "Weylin's Minion", 0, "", 0, "LineageMonster4.eyeless_080p", 20, 27.5, 1, "male", "L2Monster", 40, 2444, 2444, 0, 0, 10, 10, 10, 10, 10, 10, 0, 0, 500, 500, 500, 500, 253, 0, 253, 0, 0, NULL, 80, 120, "", 0, 0, 0, "LAST_HIT", 0, 0, 0, "balanced"),
(22292, 22292, "Tourmaline", 0, "", 0, "LineageMonster4.Crystal_Golem", 40, 47, 82, "male", "L2Monster", 40, 4663, 1934, 26.86, 3.09, 40, 43, 30, 21, 20, 10, 9625, 1106, 1912, 598, 1220, 485, 278, 0, 333, 0, 0, 0, 49, 192, "NULL", 0, 0, 0, "LAST_HIT", 0, 0, 0, "fighter"),
(22293, 22293, "Spinel", 0, "", 0, "LineageMonster.stone_golem", 18, 34, 82, "male", "L2Monster", 40, 4663, 1934, 26.86, 3.09, 40, 43, 30, 21, 20, 10, 9625, 1106, 1912, 598, 1220, 485, 278, 0, 333, 0, 0, 0, 49, 22, "NULL", 0, 0, 0, "LAST_HIT", 0, 0, 0, "fighter"),
(22294, 22294, "Fire Opal", 0, "", 0, "LineageMonster4.Crystal_Golem", 40, 47, 82, "male", "L2Monster", 40, 4663, 1934, 26.86, 3.09, 40, 43, 30, 21, 20, 10, 9625, 1106, 1912, 598, 1220, 485, 278, 0, 333, 0, 0, 0, 49, 192, "NULL", 0, 0, 0, "LAST_HIT", 0, 0, 0, "fighter"),
(22295, 22295, "Reef Golem", 0, "", 0, "LineageMonster4.Crystal_Golem", 40, 47, 1, "male", "L2Monster", 40, 2444, 2444, 0, 0, 10, 10, 10, 10, 10, 10, 0, 0, 500, 500, 500, 500, 253, 0, 253, 0, 0, NULL, 80, 120, "", 0, 0, 0, "LAST_HIT", 0, 0, 0, "balanced"),
(22296, 22296, "Reef Golem", 0, "", 0, "LineageMonster4.Crystal_Golem", 40, 47, 1, "male", "L2Monster", 40, 2444, 2444, 0, 0, 10, 10, 10, 10, 10, 10, 0, 0, 500, 500, 500, 500, 253, 0, 253, 0, 0, NULL, 80, 120, "", 0, 0, 0, "LAST_HIT", 0, 0, 0, "balanced"),
(22297, 22297, "Reef Golem", 0, "", 0, "LineageMonster4.Crystal_Golem", 40, 47, 1, "male", "L2Monster", 40, 2444, 2444, 0, 0, 10, 10, 10, 10, 10, 10, 0, 0, 500, 500, 500, 500, 253, 0, 253, 0, 0, NULL, 80, 120, "", 0, 0, 0, "LAST_HIT", 0, 0, 0, "balanced"),
(22298, 22298, "Weylin", 0, "", 0, "LineageMonster.banshee_30_bi", 20, 27.5, 1, "male", "L2Monster", 40, 2444, 2444, 0, 0, 10, 10, 10, 10, 10, 10, 0, 0, 500, 500, 500, 500, 253, 0, 253, 0, 0, NULL, 80, 120, "", 0, 0, 0, "LAST_HIT", 0, 0, 0, "balanced"),
(22299, 22299, "Dolph", 0, "", 0, "LineageMonster.pan_100_bi", 20, 27.5, 1, "male", "L2Monster", 40, 2444, 2444, 0, 0, 10, 10, 10, 10, 10, 10, 0, 0, 500, 500, 500, 500, 253, 0, 253, 0, 0, NULL, 80, 120, "", 0, 0, 0, "LAST_HIT", 0, 0, 0, "balanced"),
(22300, 22300, "Dolph's Minion", 0, "", 0, "LineageMonster4.eyeless_080p", 20, 27.5, 1, "male", "L2Monster", 40, 2444, 2444, 0, 0, 10, 10, 10, 10, 10, 10, 0, 0, 500, 500, 500, 500, 253, 0, 253, 0, 0, NULL, 80, 120, "", 0, 0, 0, "LAST_HIT", 0, 0, 0, "balanced"),
(22301, 22301, "Ted", 0, "", 0, "LineageMonster.doll_master_20_bi", 20, 27.5, 1, "male", "L2Monster", 40, 2444, 2444, 0, 0, 10, 10, 10, 10, 10, 10, 0, 0, 500, 500, 500, 500, 253, 0, 253, 0, 0, NULL, 80, 120, "", 0, 0, 0, "LAST_HIT", 0, 0, 0, "balanced"),
(22302, 22302, "Darnel's Guardian", 0, "", 0, "LineageMonster.pixy_bi", 20, 27, 1, "male", "L2Monster", 40, 2444, 2444, 0, 0, 10, 10, 10, 10, 10, 10, 0, 0, 500, 500, 500, 500, 253, 0, 253, 0, 0, NULL, 80, 120, "", 0, 0, 0, "LAST_HIT", 0, 0, 0, "balanced"),
(22303, 22303, "Guardian of the Square", 0, "", 0, "LineageMonster3.ice_fairy", 20, 27, 1, "male", "L2Monster", 40, 2444, 2444, 0, 0, 10, 10, 10, 10, 10, 10, 0, 0, 500, 500, 500, 500, 253, 0, 253, 0, 0, NULL, 80, 120, "", 0, 0, 0, "LAST_HIT", 0, 0, 0, "balanced"),
(22304, 22304, "Guardian of the Emerald", 0, "", 0, "LineageMonster.blue_eye_150p", 20, 27, 82, "male", "L2Monster", 40, 4663, 1934, 26.86, 3.09, 40, 43, 30, 21, 20, 10, 9625, 1106, 1912, 598, 1220, 485, 278, 0, 333, 0, 0, 0, 49, 192, "NULL", 0, 0, 0, "LAST_HIT", 0, 0, 0, "fighter"),
(22305, 22305, "Kechi's Captain", 0, "", 0, "LineageMonster.field_stalker_110p", 36, 43.5, 82, "male", "L2Monster", 40, 4663, 1934, 26.86, 3.09, 40, 43, 30, 21, 20, 10, 9625, 1106, 1912, 598, 1220, 485, 278, 0, 333, 0, 0, 0, 49, 192, "NULL", 0, 0, 0, "LAST_HIT", 0, 0, 0, "fighter"),
(22306, 22306, "Kechi's Captain", 0, "", 0, "LineageMonster2.lava_golem", 36, 43.5, 82, "male", "L2Monster", 40, 4663, 1934, 26.86, 3.09, 40, 43, 30, 21, 20, 10, 9625, 1106, 1912, 598, 1220, 485, 278, 0, 333, 0, 0, 0, 49, 192, "NULL", 0, 0, 0, "LAST_HIT", 0, 0, 0, "fighter"),
(22307, 22307, "Kechi's Captain", 0, "", 0, "LineageMonster3.Steel_Trapper", 36, 43.5, 82, "male", "L2Monster", 40, 4663, 1934, 26.86, 3.09, 40, 43, 30, 21, 20, 10, 9625, 1106, 1912, 598, 1220, 485, 278, 0, 333, 0, 0, 0, 49, 192, "NULL", 0, 0, 0, "LAST_HIT", 0, 0, 0, "fighter"),
(22308, 22308, "Kechi's Guard", 0, "", 0, "LineageMonster.mana_vampire_120p", 32, 35, 82, "male", "L2Monster", 40, 4663, 1934, 26.86, 3.09, 40, 43, 30, 21, 20, 10, 9625, 1106, 1912, 598, 1220, 485, 278, 0, 333, 0, 0, 0, 49, 192, "NULL", 0, 0, 0, "LAST_HIT", 0, 0, 0, "fighter"),
(22309, 22309, "Kechi's Guard", 0, "", 0, "LineageMonster.blade_stakato_soldier", 32, 35, 82, "male", "L2Monster", 40, 4663, 1934, 26.86, 3.09, 40, 43, 30, 21, 20, 10, 9625, 1106, 1912, 598, 1220, 485, 278, 0, 333, 0, 0, 0, 49, 192, "NULL", 0, 0, 0, "LAST_HIT", 0, 0, 0, "fighter"),
(22310, 22310, "Kechi's Guard", 0, "", 0, "LineageMonster3.portrait_spirit_150p", 32, 35, 82, "male", "L2Monster", 40, 4663, 1934, 26.86, 3.09, 40, 43, 30, 21, 20, 10, 9625, 1106, 1912, 598, 1220, 485, 278, 0, 333, 0, 0, 0, 49, 192, "NULL", 0, 0, 0, "LAST_HIT", 0, 0, 0, "fighter"),
(22311, 22311, "Parme's Guardian", 0, "", 0, "LineageMonster.riba", 20, 27, 83, "male", "L2Monster", 40, 4716, 1972, 26.86, 3.09, 40, 43, 30, 21, 20, 10, 10475, 1217, 2249, 736, 1258, 494, 200, 0, 333, 0, 0, 0, 22, 181, "NULL", 0, 0, 0, "LAST_HIT", 0, 0, 0, "fighter"),
(22312, 22312, "Fafurion's Henchman", 0, "", 0, "LineageMonster.raikel", 20, 27, 83, "male", "L2Monster", 40, 51870, 1972, 26.86, 3.09, 40, 43, 30, 21, 20, 10, 10475, 1217, 2249, 736, 1258, 494, 200, 0, 333, 0, 0, 0, 22, 181, "NULL", 0, 0, 0, "LAST_HIT", 0, 0, 0, "fighter"),
(22313, 22313, "Garden Stakato", 0, "", 0, "LineageMonster.blade_stakato_drone", 20, 27, 83, "male", "L2Monster", 40, 34580, 1972, 26.86, 3.09, 40, 43, 30, 21, 20, 10, 10475, 1217, 2249, 736, 1258, 494, 200, 0, 333, 0, 0, 0, 22, 181, "NULL", 0, 0, 0, "LAST_HIT", 0, 0, 0, "fighter"),
(22314, 22314, "Garden Poison Moth", 0, "", 0, "LineageMonster4.Anthias", 20, 27, 83, "male", "L2Monster", 40, 4716, 1972, 26.86, 3.09, 40, 43, 30, 21, 20, 10, 10475, 1217, 2249, 736, 1258, 494, 200, 0, 333, 0, 0, 0, 22, 181, "NULL", 0, 0, 0, "LAST_HIT", 0, 0, 0, "fighter"),
(22315, 22315, "Garden Guard ", 0, "", 0, "LineageMonster.water_giant", 20, 27, 83, "male", "L2Monster", 40, 4716, 1972, 26.86, 3.09, 40, 43, 30, 21, 20, 10, 10475, 1217, 2249, 736, 1258, 494, 200, 0, 333, 0, 0, 0, 22, 181, "NULL", 0, 0, 0, "LAST_HIT", 0, 0, 0, "fighter"),
(22316, 22316, "Garden Guardian Tree", 0, "", 0, "LineageMonster3.Jungle_Bleeze", 20, 27, 83, "male", "L2Monster", 40, 4716, 1972, 26.86, 3.09, 40, 43, 30, 21, 20, 10, 10475, 1217, 2249, 736, 1258, 494, 200, 0, 333, 0, 0, 0, 22, 181, "NULL", 0, 0, 0, "LAST_HIT", 0, 0, 0, "fighter"),
(22317, 22317, "Garden Castalia", 0, "", 0, "LineageMonster4.tears_d", 20, 27, 1, "male", "L2Monster", 40, 2444, 2444, 0, 0, 10, 10, 10, 10, 10, 10, 0, 0, 500, 500, 500, 500, 253, 0, 253, 0, 0, NULL, 80, 120, "", 0, 0, 0, "LAST_HIT", 0, 0, 0, "balanced"),
(22318, 22318, "Hall Guard", 0, "", 0, "LineageMonster4.tears_d", 20, 27.5, 1, "male", "L2Monster", 40, 2444, 2444, 0, 0, 10, 10, 10, 10, 10, 10, 0, 0, 500, 500, 500, 500, 253, 0, 253, 0, 0, NULL, 80, 120, "", 0, 0, 0, "LAST_HIT", 0, 0, 0, "balanced"),
(22319, 22319, "Hall Guard", 0, "", 0, "LineageMonster4.tears_d", 20, 27.5, 1, "male", "L2Monster", 40, 2444, 2444, 0, 0, 10, 10, 10, 10, 10, 10, 0, 0, 500, 500, 500, 500, 253, 0, 253, 0, 0, NULL, 80, 120, "", 0, 0, 0, "LAST_HIT", 0, 0, 0, "balanced"),
(22320, 22320, "Junior Watchman", 0, "", 0, "LineageMonster4.eyeless", 36, 43.5, 1, "male", "L2Monster", 40, 2444, 2444, 0, 0, 10, 10, 10, 10, 10, 10, 0, 0, 500, 500, 500, 500, 278, 0, 333, 0, 0, NULL, 60, 180, "", 0, 0, 0, "LAST_HIT", 0, 0, 0, "balanced"),
(22321, 22321, "Junior Summoner", 0, "", 0, "LineageMonster2.vampire_witch", 6, 21.5, 1, "male", "L2Monster", 40, 2444, 2444, 0, 0, 10, 10, 10, 10, 10, 10, 0, 0, 500, 500, 500, 500, 278, 0, 333, 946, 0, NULL, 64, 180, "", 0, 0, 0, "LAST_HIT", 0, 0, 0, "mage"),
(22322, 22322, "Subjugated Native", 0, "", 0, "LineageNPC.a_common_peopleC_Mhuman", 10, 24, 1, "male", "L2Monster", 40, 2444, 2444, 0, 0, 10, 10, 10, 10, 10, 10, 0, 0, 500, 500, 500, 500, 278, 0, 333, 8219, 0, NULL, 50, 100, "", 0, 0, 0, "LAST_HIT", 0, 0, 0, "balanced"),
(22323, 22323, "Charmed Native", 0, "", 0, "LineageNPC.a_common_peopleC_Mhuman", 10, 24, 1, "male", "L2Monster", 40, 2444, 2444, 0, 0, 10, 10, 10, 10, 10, 10, 0, 0, 500, 500, 500, 500, 278, 0, 333, 8528, 0, NULL, 50, 100, "", 0, 0, 0, "LAST_HIT", 0, 0, 0, "balanced"),
(22324, 22324, "Blind Huntsman", 0, "", 0, "LineageMonster4.eyeless_080p", 34, 35, 83, "male", "L2Monster", 40, 12120, 2011, 80.58, 3.09, 40, 43, 30, 21, 20, 10, 11251, 1323, 2207, 562, 1296, 502, 278, 0, 333, 0, 0, 0, 60, 200, "NULL", 0, 0, 0, "LAST_HIT", 0, 0, 0, "fighter"),
(22325, 22325, "Blind Watchman", 0, "", 0, "LineageMonster4.eyeless_080p", 34, 35, 83, "male", "L2Monster", 40, 12120, 2011, 80.58, 3.09, 40, 43, 30, 21, 20, 10, 11251, 1323, 2207, 562, 1296, 502, 278, 0, 333, 0, 0, 0, 60, 200, "NULL", 0, 0, 0, "LAST_HIT", 0, 0, 0, "fighter"),
(22326, 22326, "Hellinark", 0, "Naia's Guardian", 0, "LineageMonster.karik", 19, 35, 1, "male", "L2Monster", 40, 2444, 2444, 0, 0, 10, 10, 10, 10, 10, 10, 0, 0, 500, 500, 500, 500, 253, 0, 253, 0, 0, NULL, 80, 120, "", 0, 0, 0, "LAST_HIT", 0, 0, 0, "balanced"),
(22327, 22327, "Arcane Scout", 0, "", 0, "LineageMonster.dark_mahum", 13, 26, 1, "male", "L2Monster", 40, 2444, 2444, 0, 0, 10, 10, 10, 10, 10, 10, 0, 0, 500, 500, 500, 500, 278, 0, 333, 234, 0, NULL, 50, 160, "", 0, 0, 0, "LAST_HIT", 0, 0, 0, "balanced"),
(22328, 22328, "Arcane Guardian", 0, "", 0, "LineageMonster3.Succubus_Raid", 12, 30.7, 1, "male", "L2Monster", 40, 2444, 2444, 0, 0, 10, 10, 10, 10, 10, 10, 0, 0, 500, 500, 500, 500, 278, 0, 333, 0, 0, NULL, 60, 170, "", 0, 0, 0, "LAST_HIT", 0, 0, 0, "balanced"),
(22329, 22329, "Arcane Watchman", 0, "", 0, "LineageMonster3.Death_Blader_Raid", 15, 32.5, 1, "male", "L2Monster", 40, 2444, 2444, 0, 0, 10, 10, 10, 10, 10, 10, 0, 0, 500, 500, 500, 500, 278, 0, 333, 0, 0, NULL, 60, 170, "", 0, 0, 0, "LAST_HIT", 0, 0, 0, "balanced"),
(22330, 22330, "Remnant Wraith", 0, "", 0, "LineageMonster3.zombie_laborer", 11, 28.5, 1, "male", "L2Monster", 40, 2444, 2444, 0, 0, 10, 10, 10, 10, 10, 10, 0, 0, 500, 500, 500, 500, 253, 0, 253, 0, 0, NULL, 80, 120, "", 0, 0, 0, "LAST_HIT", 0, 0, 0, "balanced"),
(22331, 22331, "Remnant Diabolist", 0, "", 0, "LineageMonster3.spectral_knight", 12.5, 33.5, 1, "male", "L2Monster", 40, 2444, 2444, 0, 0, 10, 10, 10, 10, 10, 10, 0, 0, 500, 500, 500, 500, 253, 0, 253, 0, 0, NULL, 80, 120, "", 0, 0, 0, "LAST_HIT", 0, 0, 0, "balanced"),
(22332, 22332, "Remnant Diviner", 0, "", 0, "LineageMonster3.spectral_knight", 12.5, 33.5, 1, "male", "L2Monster", 40, 2444, 2444, 0, 0, 10, 10, 10, 10, 10, 10, 0, 0, 500, 500, 500, 500, 253, 0, 253, 0, 0, NULL, 80, 120, "", 0, 0, 0, "LAST_HIT", 0, 0, 0, "balanced"),
(22333, 22333, "Derek", 0, "First Generation Seer", 0, "LineageMonster.skeleton_royal_guard", 11, 28.5, 1, "male", "L2Monster", 40, 2444, 2444, 0, 0, 10, 10, 10, 10, 10, 10, 0, 0, 500, 500, 500, 500, 253, 0, 253, 0, 0, NULL, 80, 120, "", 0, 0, 0, "LAST_HIT", 0, 0, 0, "balanced"),
(22334, 22334, "Sand Scorpion", 0, "", 0, "LineageMonster2.sandScorpion", 28, 66, 1, "male", "L2Monster", 40, 2444, 2444, 0, 0, 10, 10, 10, 10, 10, 10, 0, 0, 500, 500, 500, 500, 278, 0, 333, 0, 0, NULL, 37, 170, "", 0, 0, 0, "LAST_HIT", 0, 0, 0, "balanced"),
(22335, 22335, "Desert Scorpion", 0, "", 0, "LineageMonster2.sandScorpion", 28, 66, 1, "male", "L2Monster", 40, 2444, 2444, 0, 0, 10, 10, 10, 10, 10, 10, 0, 0, 500, 500, 500, 500, 278, 0, 333, 0, 0, NULL, 37, 170, "", 0, 0, 0, "LAST_HIT", 0, 0, 0, "balanced"),
(22336, 22336, "Sand Devil", 0, "", 0, "LineageMonster2.imperial_warlord_zombie_sand", 7, 30, 1, "male", "L2Monster", 40, 2444, 2444, 0, 0, 10, 10, 10, 10, 10, 10, 0, 0, 500, 500, 500, 500, 278, 0, 333, 0, 0, NULL, 39, 150, "", 0, 0, 0, "LAST_HIT", 0, 0, 0, "balanced"),
(22337, 22337, "Desiccator", 0, "", 0, "LineageMonster.skeleton_knight_sand", 10, 25, 1, "male", "L2Monster", 40, 2444, 2444, 0, 0, 10, 10, 10, 10, 10, 10, 0, 0, 500, 500, 500, 500, 278, 0, 333, 0, 0, NULL, 40, 160, "", 0, 0, 0, "LAST_HIT", 0, 0, 0, "balanced"),
(22338, 22338, "Desert Rose", 0, "Sand Worm", 0, "LineageMonster4.sandrose", 110, 22.5, 1, "male", "L2Monster", 40, 2444, 2444, 0, 0, 10, 10, 10, 10, 10, 10, 0, 0, 500, 500, 500, 500, 253, 0, 253, 0, 0, NULL, 80, 120, "", 0, 0, 0, "LAST_HIT", 0, 0, 0, "balanced"),
(22339, 22339, "Wandering Caravan", 0, "", 0, "LineageMonster4.Caravan", 33, 58.5, 1, "male", "L2Monster", 40, 2444, 2444, 0, 0, 10, 10, 10, 10, 10, 10, 0, 0, 500, 500, 500, 500, 278, 0, 333, 0, 0, NULL, 56, 160, "", 0, 0, 0, "LAST_HIT", 0, 0, 0, "balanced"),
(22340, 22340, "Sandstorm", 0, "", 0, "LineageMonster4.SandTourbillon", 10, 28, 1, "male", "L2Monster", 40, 2444, 2444, 0, 0, 10, 10, 10, 10, 10, 10, 0, 0, 500, 500, 500, 500, 278, 0, 333, 0, 0, NULL, 180, 250, "", 0, 0, 0, "LAST_HIT", 0, 0, 0, "balanced"),
(22341, 22341, "Keltas", 0, "", 0, "LineageMonster3.Vampire_Troop_Leader", 19, 35, 1, "male", "L2Monster", 40, 2444, 2444, 0, 0, 10, 10, 10, 10, 10, 10, 0, 0, 500, 500, 500, 500, 253, 0, 253, 0, 0, NULL, 80, 120, "", 0, 0, 0, "LAST_HIT", 0, 0, 0, "balanced"),
(22342, 22342, "Darion's Enforcer", 0, "", 0, "LineageMonster.silhouette", 32, 35, 1, "male", "L2Monster", 40, 2444, 2444, 0, 0, 10, 10, 10, 10, 10, 10, 0, 0, 500, 500, 500, 500, 253, 0, 253, 0, 0, NULL, 80, 120, "", 0, 0, 0, "LAST_HIT", 0, 0, 0, "balanced"),
(22343, 22343, "Darion's Executioner", 0, "", 0, "LineageMonster.shadeless", 32, 35, 1, "male", "L2Monster", 40, 2444, 2444, 0, 0, 10, 10, 10, 10, 10, 10, 0, 0, 500, 500, 500, 500, 253, 0, 253, 0, 0, NULL, 80, 120, "", 0, 0, 0, "LAST_HIT", 0, 0, 0, "balanced"),
(22344, 22344, "Quarry Supervior", 0, "", 0, "LineageMonster2.vampire_warrior", 9, 31.5, 1, "male", "L2Monster", 40, 2444, 2444, 0, 0, 10, 10, 10, 10, 10, 10, 0, 0, 500, 500, 500, 500, 278, 0, 333, 6723, 0, NULL, 43, 165, "", 0, 0, 0, "LAST_HIT", 0, 0, 0, "balanced"),
(22345, 22345, "Quarry Supervior", 0, "", 0, "LineageMonster2.vampire_wizard", 5.5, 28, 1, "male", "L2Monster", 40, 2444, 2444, 0, 0, 10, 10, 10, 10, 10, 10, 0, 0, 500, 500, 500, 500, 278, 0, 333, 99, 0, NULL, 46, 165, "", 0, 0, 0, "LAST_HIT", 0, 0, 0, "mage"),
(22346, 22346, "Quarry Foreman", 0, "", 0, "LineageMonster3.Vampire_Troop_Leader_120p", 22, 43, 1, "male", "L2Monster", 40, 2444, 2444, 0, 0, 10, 10, 10, 10, 10, 10, 0, 0, 500, 500, 500, 500, 278, 0, 333, 8686, 0, NULL, 60, 165, "", 0, 0, 0, "LAST_HIT", 0, 0, 0, "balanced"),
(22347, 22347, "Quarry Patrolman", 0, "", 0, "LineageMonster4.eyeless_080p", 34, 35, 1, "male", "L2Monster", 40, 2444, 2444, 0, 0, 10, 10, 10, 10, 10, 10, 0, 0, 500, 500, 500, 500, 278, 0, 333, 0, 0, NULL, 60, 210, "", 0, 0, 0, "LAST_HIT", 0, 0, 0, "balanced"),
(22348, 22348, "Laboratory Guard", 0, "", 0, "LineageMonster4.eyeless", 36, 43.5, 1, "male", "L2Monster", 40, 2444, 2444, 0, 0, 10, 10, 10, 10, 10, 10, 0, 0, 500, 500, 500, 500, 253, 0, 253, 0, 0, NULL, 80, 120, "", 0, 0, 0, "LAST_HIT", 0, 0, 0, "balanced"),
(22349, 22349, "Chimera of Earth", 0, "", 0, "LineageMonster4.Chimera", 35, 36, 1, "male", "L2Monster", 40, 2444, 2444, 0, 0, 10, 10, 10, 10, 10, 10, 0, 0, 500, 500, 500, 500, 253, 0, 253, 0, 0, NULL, 80, 120, "", 0, 0, 0, "LAST_HIT", 0, 0, 0, "balanced"),
(22350, 22350, "Chimera of Darkness", 0, "", 0, "LineageMonster4.Chimera", 35, 36, 1, "male", "L2Monster", 40, 2444, 2444, 0, 0, 10, 10, 10, 10, 10, 10, 0, 0, 500, 500, 500, 500, 253, 0, 253, 0, 0, NULL, 80, 120, "", 0, 0, 0, "LAST_HIT", 0, 0, 0, "balanced"),
(22351, 22351, "Chimera of Wind", 0, "", 0, "LineageMonster4.Chimera", 35, 36, 1, "male", "L2Monster", 40, 2444, 2444, 0, 0, 10, 10, 10, 10, 10, 10, 0, 0, 500, 500, 500, 500, 253, 0, 253, 0, 0, NULL, 80, 120, "", 0, 0, 0, "LAST_HIT", 0, 0, 0, "balanced"),
(22352, 22352, "Chimera of Fire", 0, "", 0, "LineageMonster4.Chimera", 35, 36, 1, "male", "L2Monster", 40, 2444, 2444, 0, 0, 10, 10, 10, 10, 10, 10, 0, 0, 500, 500, 500, 500, 253, 0, 253, 0, 0, NULL, 80, 120, "", 0, 0, 0, "LAST_HIT", 0, 0, 0, "balanced"),
(22353, 22353, "Celtus", 0, "Chimera", 0, "LineageMonster4.Chimera", 35, 36, 1, "male", "L2Monster", 40, 2444, 2444, 0, 0, 10, 10, 10, 10, 10, 10, 0, 0, 500, 500, 500, 500, 253, 0, 253, 0, 0, NULL, 80, 120, "", 0, 0, 0, "LAST_HIT", 0, 0, 0, "balanced"),
(22354, 22354, "Outpost Captain", 0, "", 0, "LineageMonster.kaim_vanul", 24, 40, 1, "male", "L2Monster", 40, 2444, 2444, 0, 0, 10, 10, 10, 10, 10, 10, 0, 0, 500, 500, 500, 500, 253, 0, 253, 0, 0, NULL, 80, 120, "", 0, 0, 0, "LAST_HIT", 0, 0, 0, "balanced"),
(22355, 22355, "Enceinte Defender", 0, "", 0, "LineageMonster4.eyeless", 36, 43.5, 1, "male", "L2Monster", 40, 2444, 2444, 0, 0, 10, 10, 10, 10, 10, 10, 0, 0, 500, 500, 500, 500, 253, 0, 253, 0, 0, NULL, 80, 120, "", 0, 0, 0, "LAST_HIT", 0, 0, 0, "balanced"),
(22356, 22356, "Enceinte Defender", 0, "", 0, "LineageMonster4.eyeless", 36, 43.5, 1, "male", "L2Monster", 40, 2444, 2444, 0, 0, 10, 10, 10, 10, 10, 10, 0, 0, 500, 500, 500, 500, 253, 0, 253, 0, 0, NULL, 80, 120, "", 0, 0, 0, "LAST_HIT", 0, 0, 0, "balanced"),
(22357, 22357, "Enceinte Defender", 0, "", 0, "LineageMonster4.eyeless", 36, 43.5, 1, "male", "L2Monster", 40, 2444, 2444, 0, 0, 10, 10, 10, 10, 10, 10, 0, 0, 500, 500, 500, 500, 253, 0, 253, 0, 0, NULL, 80, 120, "", 0, 0, 0, "LAST_HIT", 0, 0, 0, "balanced"),
(22358, 22358, "Enceinte Defender", 0, "", 0, "LineageMonster4.eyeless", 36, 43.5, 1, "male", "L2Monster", 40, 2444, 2444, 0, 0, 10, 10, 10, 10, 10, 10, 0, 0, 500, 500, 500, 500, 253, 0, 253, 0, 0, NULL, 80, 120, "", 0, 0, 0, "LAST_HIT", 0, 0, 0, "balanced"),
(22359, 22359, "Town Guard", 0, "", 0, "LineageMonster4.eyeless", 36, 43.5, 1, "male", "L2Monster", 40, 2444, 2444, 0, 0, 10, 10, 10, 10, 10, 10, 0, 0, 500, 500, 500, 500, 253, 0, 253, 0, 0, NULL, 80, 120, "", 0, 0, 0, "LAST_HIT", 0, 0, 0, "balanced"),
(22360, 22360, "Town Patrolman", 0, "", 0, "LineageMonster.kel_mahum", 36, 43.5, 1, "male", "L2Monster", 40, 2444, 2444, 0, 0, 10, 10, 10, 10, 10, 10, 0, 0, 500, 500, 500, 500, 253, 0, 253, 0, 0, NULL, 80, 120, "", 0, 0, 0, "LAST_HIT", 0, 0, 0, "balanced"),
(22361, 22361, "Iron Castle Keymaster", 0, "", 0, "LineageMonster4.eyeless", 36, 43.5, 1, "male", "L2Monster", 40, 2444, 2444, 0, 0, 10, 10, 10, 10, 10, 10, 0, 0, 500, 500, 500, 500, 253, 0, 253, 0, 0, NULL, 80, 120, "", 0, 0, 0, "LAST_HIT", 0, 0, 0, "balanced"),
(22362, 22362, "Guzen", 0, "", 0, "LineageMonster4.rah", 36, 43.5, 1, "male", "L2Monster", 40, 2444, 2444, 0, 0, 10, 10, 10, 10, 10, 10, 0, 0, 500, 500, 500, 500, 253, 0, 253, 0, 0, NULL, 80, 120, "", 0, 0, 0, "LAST_HIT", 0, 0, 0, "balanced"),
(22363, 22363, "Sand Devil", 0, "", 0, "LineageMonster.kaim_vanul", 24, 40, 1, "male", "L2Monster", 40, 2444, 2444, 0, 0, 10, 10, 10, 10, 10, 10, 0, 0, 500, 500, 500, 500, 253, 0, 253, 0, 0, NULL, 80, 120, "", 0, 0, 0, "LAST_HIT", 0, 0, 0, "balanced"),
(22364, 22364, "Dominator", 0, "", 0, "LineageMonster.kaim_vanul", 24, 40, 1, "male", "L2Monster", 40, 2444, 2444, 0, 0, 10, 10, 10, 10, 10, 10, 0, 0, 500, 500, 500, 500, 253, 0, 253, 0, 0, NULL, 80, 120, "", 0, 0, 0, "LAST_HIT", 0, 0, 0, "balanced"),
(22365, 22365, "Labyrinth Predator", 0, "", 0, "LineageMonster4.eyeless", 24, 40, 1, "male", "L2Monster", 40, 2444, 2444, 0, 0, 10, 10, 10, 10, 10, 10, 0, 0, 500, 500, 500, 500, 253, 0, 253, 0, 0, NULL, 80, 120, "", 0, 0, 0, "LAST_HIT", 0, 0, 0, "balanced"),
(22366, 22366, "Labyrinth Watchman", 0, "", 0, "LineageMonster3.zombie_gateguard", 36, 43.5, 1, "male", "L2Monster", 40, 2444, 2444, 0, 0, 10, 10, 10, 10, 10, 10, 0, 0, 500, 500, 500, 500, 253, 0, 253, 0, 0, NULL, 80, 120, "", 0, 0, 0, "LAST_HIT", 0, 0, 0, "balanced"),
(22367, 22367, "Labyrinth Magician", 0, "", 0, "LineageMonster2.vampire_wizard", 8, 22, 1, "male", "L2Monster", 40, 2444, 2444, 0, 0, 10, 10, 10, 10, 10, 10, 0, 0, 500, 500, 500, 500, 253, 0, 253, 0, 0, NULL, 80, 120, "", 0, 0, 0, "LAST_HIT", 0, 0, 0, "mage"),
(22368, 22368, "Labyrinth Enchanter", 0, "", 0, "LineageMonster2.vampire_witch", 8, 22, 1, "male", "L2Monster", 40, 2444, 2444, 0, 0, 10, 10, 10, 10, 10, 10, 0, 0, 500, 500, 500, 500, 253, 0, 253, 0, 0, NULL, 80, 120, "", 0, 0, 0, "LAST_HIT", 0, 0, 0, "mage"),
(22369, 22369, "Mysterious Diviner", 0, "", 0, "LineageMonster.skeleton_royal_guard", 11, 28.5, 1, "male", "L2Monster", 40, 2444, 2444, 0, 0, 10, 10, 10, 10, 10, 10, 0, 0, 500, 500, 500, 500, 253, 0, 253, 0, 0, NULL, 80, 120, "", 0, 0, 0, "LAST_HIT", 0, 0, 0, "balanced"),
(22370, 22370, "Mysterious Vampire", 0, "", 0, "LineageMonster2.vampire_soldier_20_bi", 11, 28.5, 1, "male", "L2Npc", 40, 2444, 2444, 0, 0, 10, 10, 10, 10, 10, 10, 0, 0, 500, 500, 500, 500, 253, 0, 253, 0, 0, NULL, 80, 120, "", 0, 0, 0, "LAST_HIT", 0, 0, 0, "balanced"),
(22371, 22371, "Mysterious Vanquisher", 0, "", 0, "LineageMonster.skeleton_royal_guard", 11, 28.5, 1, "male", "L2Npc", 40, 2444, 2444, 0, 0, 10, 10, 10, 10, 10, 10, 0, 0, 500, 500, 500, 500, 253, 0, 253, 0, 0, NULL, 80, 120, "", 0, 0, 0, "LAST_HIT", 0, 0, 0, "balanced"),
(22372, 22372, "Tower Captain", 0, "", 0, "LineageMonster.kaim_vanul", 24, 40, 1, "male", "L2Npc", 40, 2444, 2444, 0, 0, 10, 10, 10, 10, 10, 10, 0, 0, 500, 500, 500, 500, 253, 0, 253, 0, 0, NULL, 80, 120, "", 0, 0, 0, "LAST_HIT", 0, 0, 0, "balanced"),
(22373, 22373, "Tower Captain", 0, "", 0, "LineageMonster4.rahuu", 33, 49, 1, "male", "L2Npc", 40, 2444, 2444, 0, 0, 10, 10, 10, 10, 10, 10, 0, 0, 500, 500, 500, 500, 253, 0, 253, 0, 0, NULL, 80, 120, "", 0, 0, 0, "LAST_HIT", 0, 0, 0, "balanced"),
(22374, 22374, "Tower Captain", 0, "", 0, "LineageMonster4.rah", 20, 40.6, 1, "male", "L2Npc", 40, 2444, 2444, 0, 0, 10, 10, 10, 10, 10, 10, 0, 0, 500, 500, 500, 500, 253, 0, 253, 0, 0, NULL, 80, 120, "", 0, 0, 0, "LAST_HIT", 0, 0, 0, "balanced"),
(22375, 22375, "Tower Guard", 0, "", 0, "LineageMonster4.eyeless", 36, 43.5, 1, "male", "L2Npc", 40, 2444, 2444, 0, 0, 10, 10, 10, 10, 10, 10, 0, 0, 500, 500, 500, 500, 253, 0, 253, 0, 0, NULL, 80, 120, "", 0, 0, 0, "LAST_HIT", 0, 0, 0, "balanced"),
(22376, 22376, "Tower Guard", 0, "", 0, "LineageMonster4.eyeless", 36, 43.5, 1, "male", "L2Npc", 40, 2444, 2444, 0, 0, 10, 10, 10, 10, 10, 10, 0, 0, 500, 500, 500, 500, 253, 0, 253, 0, 0, NULL, 80, 120, "", 0, 0, 0, "LAST_HIT", 0, 0, 0, "balanced"),
(22377, 22377, "Tower Guard", 0, "", 0, "LineageMonster4.eyeless", 36, 43.5, 1, "male", "L2Npc", 40, 2444, 2444, 0, 0, 10, 10, 10, 10, 10, 10, 0, 0, 500, 500, 500, 500, 253, 0, 253, 0, 0, NULL, 80, 120, "", 0, 0, 0, "LAST_HIT", 0, 0, 0, "balanced"),
(22378, 22378, "Tower Guard", 0, "", 0, "LineageMonster4.eyeless", 36, 43.5, 1, "male", "L2Npc", 40, 2444, 2444, 0, 0, 10, 10, 10, 10, 10, 10, 0, 0, 500, 500, 500, 500, 253, 0, 253, 0, 0, NULL, 80, 120, "", 0, 0, 0, "LAST_HIT", 0, 0, 0, "balanced"),
(22379, 22379, "Cosmic Lord", 0, "", 0, "LineageMonster4.eyeless", 36, 43.5, 1, "male", "L2Npc", 40, 2444, 2444, 0, 0, 10, 10, 10, 10, 10, 10, 0, 0, 500, 500, 500, 500, 253, 0, 253, 0, 0, NULL, 80, 120, "", 0, 0, 0, "LAST_HIT", 0, 0, 0, "balanced"),
(22380, 22380, "Cosmic Wizard", 0, "", 0, "LineageMonster4.eyeless", 36, 43.5, 1, "male", "L2Npc", 40, 2444, 2444, 0, 0, 10, 10, 10, 10, 10, 10, 0, 0, 500, 500, 500, 500, 253, 0, 253, 0, 0, NULL, 80, 120, "", 0, 0, 0, "LAST_HIT", 0, 0, 0, "balanced"),
(22381, 22381, "Cosmic Spellsword", 0, "", 0, "LineageMonster4.eyeless", 36, 43.5, 1, "male", "L2Npc", 40, 2444, 2444, 0, 0, 10, 10, 10, 10, 10, 10, 0, 0, 500, 500, 500, 500, 253, 0, 253, 0, 0, NULL, 80, 120, "", 0, 0, 0, "LAST_HIT", 0, 0, 0, "balanced"),
(22382, 22382, "Cosmic Denizen", 0, "", 0, "LineageMonster4.eyeless", 36, 43.5, 1, "male", "L2Npc", 40, 2444, 2444, 0, 0, 10, 10, 10, 10, 10, 10, 0, 0, 500, 500, 500, 500, 253, 0, 253, 0, 0, NULL, 80, 120, "", 0, 0, 0, "LAST_HIT", 0, 0, 0, "balanced"),
(22383, 22383, "Cosmic Rogue", 0, "", 0, "LineageMonster4.eyeless", 36, 43.5, 1, "male", "L2Npc", 40, 2444, 2444, 0, 0, 10, 10, 10, 10, 10, 10, 0, 0, 500, 500, 500, 500, 253, 0, 253, 0, 0, NULL, 80, 120, "", 0, 0, 0, "LAST_HIT", 0, 0, 0, "balanced"),
(22384, 22384, "Cosmic Annihilator", 0, "", 0, "LineageMonster4.eyeless", 36, 43.5, 1, "male", "L2Npc", 40, 2444, 2444, 0, 0, 10, 10, 10, 10, 10, 10, 0, 0, 500, 500, 500, 500, 253, 0, 253, 0, 0, NULL, 80, 120, "", 0, 0, 0, "LAST_HIT", 0, 0, 0, "balanced"),
(22385, 22385, "Cosmic Walker", 0, "", 0, "LineageMonster4.eyeless", 36, 43.5, 1, "male", "L2Npc", 40, 2444, 2444, 0, 0, 10, 10, 10, 10, 10, 10, 0, 0, 500, 500, 500, 500, 253, 0, 253, 0, 0, NULL, 80, 120, "", 0, 0, 0, "LAST_HIT", 0, 0, 0, "balanced"),
(22386, 22386, "Shadow Seer", 0, "", 0, "LineageMonster4.rahuu", 33, 49, 1, "male", "L2Npc", 40, 2444, 2444, 0, 0, 10, 10, 10, 10, 10, 10, 0, 0, 500, 500, 500, 500, 253, 0, 253, 0, 0, NULL, 80, 120, "", 0, 0, 0, "LAST_HIT", 0, 0, 0, "balanced"),
(22387, 22387, "Shadow Stalker", 0, "", 0, "LineageMonster4.eyeless", 36, 43.5, 1, "male", "L2Npc", 40, 2444, 2444, 0, 0, 10, 10, 10, 10, 10, 10, 0, 0, 500, 500, 500, 500, 253, 0, 253, 0, 0, NULL, 80, 120, "", 0, 0, 0, "LAST_HIT", 0, 0, 0, "balanced"),
(22388, 22388, "Tully's Apostle", 0, "", 0, "LineageMonster3.Kernon_Raid_050p", 45, 42, 1, "male", "L2Npc", 40, 2444, 2444, 0, 0, 10, 10, 10, 10, 10, 10, 0, 0, 500, 500, 500, 500, 253, 0, 253, 0, 0, NULL, 80, 120, "", 0, 0, 0, "LAST_HIT", 0, 0, 0, "balanced"),
(22389, 22389, "Foundry Inspector", 0, "", 0, "LineageMonster4.rahuu", 33, 49, 1, "male", "L2Npc", 40, 2444, 2444, 0, 0, 10, 10, 10, 10, 10, 10, 0, 0, 500, 500, 500, 500, 253, 0, 253, 0, 0, NULL, 80, 120, "", 0, 0, 0, "LAST_HIT", 0, 0, 0, "balanced"),
(22390, 22390, "Shadow Hypnotist", 0, "", 0, "LineageMonster3.zombie_gateguard", 17, 30.5, 1, "male", "L2Npc", 40, 2444, 2444, 0, 0, 10, 10, 10, 10, 10, 10, 0, 0, 500, 500, 500, 500, 253, 0, 253, 0, 0, NULL, 80, 120, "", 0, 0, 0, "LAST_HIT", 0, 0, 0, "balanced"),
(22391, 22391, "Tully Devotee", 0, "", 0, "LineageMonster4.rahuu", 33, 49, 1, "male", "L2Npc", 40, 2444, 2444, 0, 0, 10, 10, 10, 10, 10, 10, 0, 0, 500, 500, 500, 500, 253, 0, 253, 0, 0, NULL, 80, 120, "", 0, 0, 0, "LAST_HIT", 0, 0, 0, "balanced"),
(22392, 22392, "Foundry Foreman", 0, "", 0, "LineageMonster4.eyeless", 36, 43.5, 1, "male", "L2Npc", 40, 2444, 2444, 0, 0, 10, 10, 10, 10, 10, 10, 0, 0, 500, 500, 500, 500, 253, 0, 253, 0, 0, NULL, 80, 120, "", 0, 0, 0, "LAST_HIT", 0, 0, 0, "balanced"),
(22393, 22393, "Servile Henchman", 0, "", 0, "LineageMonster4.eyeless", 36, 43.5, 1, "male", "L2Npc", 40, 2444, 2444, 0, 0, 10, 10, 10, 10, 10, 10, 0, 0, 500, 500, 500, 500, 253, 0, 253, 0, 0, NULL, 80, 120, "", 0, 0, 0, "LAST_HIT", 0, 0, 0, "balanced"),
(22394, 22394, "Anomic Demon", 0, "", 0, "LineageMonster3.zombie_gateguard", 17, 30.5, 1, "male", "L2Npc", 40, 2444, 2444, 0, 0, 10, 10, 10, 10, 10, 10, 0, 0, 500, 500, 500, 500, 253, 0, 253, 0, 0, NULL, 80, 120, "", 0, 0, 0, "LAST_HIT", 0, 0, 0, "balanced"),
(22395, 22395, "Taskmaster", 0, "", 0, "LineageMonster4.eyeless", 36, 43.5, 1, "male", "L2Npc", 40, 2444, 2444, 0, 0, 10, 10, 10, 10, 10, 10, 0, 0, 500, 500, 500, 500, 253, 0, 253, 0, 0, NULL, 80, 120, "", 0, 0, 0, "LAST_HIT", 0, 0, 0, "balanced"),
(22396, 22396, "Foundry Laborer", 0, "", 0, "LineageMonster4.eyeless", 36, 43.5, 1, "male", "L2Npc", 40, 2444, 2444, 0, 0, 10, 10, 10, 10, 10, 10, 0, 0, 500, 500, 500, 500, 253, 0, 253, 0, 0, NULL, 80, 120, "", 0, 0, 0, "LAST_HIT", 0, 0, 0, "balanced"),
(22397, 22397, "Foundry Foreman  ", 0, "", 0, "LineageMonster.succubus_20_bi", 8, 22, 1, "male", "L2Npc", 40, 2444, 2444, 0, 0, 10, 10, 10, 10, 10, 10, 0, 0, 500, 500, 500, 500, 253, 0, 253, 0, 0, NULL, 80, 120, "", 0, 0, 0, "LAST_HIT", 0, 0, 0, "balanced"),
(22398, 22398, "Lesser Evil", 0, "", 0, "LineageMonster3.zombie_gateguard", 17, 30.5, 1, "male", "L2Npc", 40, 2444, 2444, 0, 0, 10, 10, 10, 10, 10, 10, 0, 0, 500, 500, 500, 500, 253, 0, 253, 0, 0, NULL, 80, 120, "", 0, 0, 0, "LAST_HIT", 0, 0, 0, "balanced"),
(22399, 22399, "Greater Evil", 0, "", 0, "LineageMonster3.zombie_gateguard", 17, 30.5, 1, "male", "L2Npc", 40, 2444, 2444, 0, 0, 10, 10, 10, 10, 10, 10, 0, 0, 500, 500, 500, 500, 253, 0, 253, 0, 0, NULL, 80, 120, "", 0, 0, 0, "LAST_HIT", 0, 0, 0, "balanced"),
(22400, 22400, "Parme's Healer", 0, "", 0, "LineageMonster4.tears_d", 20, 27, 1, "male", "L2Npc", 40, 2444, 2444, 0, 0, 10, 10, 10, 10, 10, 10, 0, 0, 500, 500, 500, 500, 253, 0, 253, 0, 0, NULL, 80, 120, "", 0, 0, 0, "LAST_HIT", 0, 0, 0, "balanced"),
(22401, 22401, "Parme's Healer", 0, "", 0, "LineageMonster4.tears_d", 20, 27, 1, "male", "L2Npc", 40, 2444, 2444, 0, 0, 10, 10, 10, 10, 10, 10, 0, 0, 500, 500, 500, 500, 253, 0, 253, 0, 0, NULL, 80, 120, "", 0, 0, 0, "LAST_HIT", 0, 0, 0, "balanced"),
(22402, 22402, "Shadow Column", 0, "", 0, "LineageNpcEV.dark_clouds_chessman", 80, 79, 1, "male", "L2Npc", 40, 2444, 2444, 0, 0, 10, 10, 10, 10, 10, 10, 0, 0, 500, 500, 500, 500, 253, 0, 253, 0, 0, NULL, 80, 120, "", 0, 0, 0, "LAST_HIT", 0, 0, 0, "balanced"),
(22403, 22403, "Foundry Foreman  ", 0, "", 0, "LineageMonster4.rahuu", 33, 49, 1, "male", "L2Npc", 40, 2444, 2444, 0, 0, 10, 10, 10, 10, 10, 10, 0, 0, 500, 500, 500, 500, 253, 0, 253, 0, 0, NULL, 80, 120, "", 0, 0, 0, "LAST_HIT", 0, 0, 0, "balanced"),
(22404, 22404, "Arcane Captain", 0, "", 0, "LineageMonster.kaim_vanul", 24, 40, 1, "male", "L2Npc", 40, 2444, 2444, 0, 0, 10, 10, 10, 10, 10, 10, 0, 0, 500, 500, 500, 500, 253, 0, 253, 0, 0, NULL, 80, 120, "", 0, 0, 0, "LAST_HIT", 0, 0, 0, "balanced"),
(22405, 22405, "Cosmic Architect", 0, "", 0, "LineageMonster4.eyeless", 36, 43.5, 1, "male", "L2Npc", 40, 2444, 2444, 0, 0, 10, 10, 10, 10, 10, 10, 0, 0, 500, 500, 500, 500, 253, 0, 253, 0, 0, NULL, 80, 120, "", 0, 0, 0, "LAST_HIT", 0, 0, 0, "balanced"),
(22406, 22406, "Tower Mover", 0, "", 0, "LineageMonster4.eyeless", 36, 43.5, 1, "male", "L2Npc", 40, 2444, 2444, 0, 0, 10, 10, 10, 10, 10, 10, 0, 0, 500, 500, 500, 500, 253, 0, 253, 0, 0, NULL, 80, 120, "", 0, 0, 0, "LAST_HIT", 0, 0, 0, "balanced"),
(22407, 22407, "Cosmic Conjurer", 0, "", 0, "LineageMonster4.eyeless", 36, 43.5, 1, "male", "L2Npc", 40, 2444, 2444, 0, 0, 10, 10, 10, 10, 10, 10, 0, 0, 500, 500, 500, 500, 253, 0, 253, 0, 0, NULL, 80, 120, "", 0, 0, 0, "LAST_HIT", 0, 0, 0, "balanced"),
(22408, 22408, "Cosmic Fighter", 0, "", 0, "LineageMonster4.eyeless", 36, 43.5, 1, "male", "L2Npc", 40, 2444, 2444, 0, 0, 10, 10, 10, 10, 10, 10, 0, 0, 500, 500, 500, 500, 253, 0, 253, 0, 0, NULL, 80, 120, "", 0, 0, 0, "LAST_HIT", 0, 0, 0, "balanced"),
(22409, 22409, "Cosmic Warrior", 0, "", 0, "LineageMonster4.eyeless", 36, 43.5, 1, "male", "L2Npc", 40, 2444, 2444, 0, 0, 10, 10, 10, 10, 10, 10, 0, 0, 500, 500, 500, 500, 253, 0, 253, 0, 0, NULL, 80, 120, "", 0, 0, 0, "LAST_HIT", 0, 0, 0, "balanced"),
(22410, 22410, "Cosmic Wizard", 0, "", 0, "LineageMonster4.eyeless", 36, 43.5, 1, "male", "L2Npc", 40, 2444, 2444, 0, 0, 10, 10, 10, 10, 10, 10, 0, 0, 500, 500, 500, 500, 253, 0, 253, 0, 0, NULL, 80, 120, "", 0, 0, 0, "LAST_HIT", 0, 0, 0, "balanced"),
(22411, 22411, "Cosmic Chanter", 0, "", 0, "LineageMonster4.eyeless", 36, 43.5, 1, "male", "L2Npc", 40, 2444, 2444, 0, 0, 10, 10, 10, 10, 10, 10, 0, 0, 500, 500, 500, 500, 253, 0, 253, 0, 0, NULL, 80, 120, "", 0, 0, 0, "LAST_HIT", 0, 0, 0, "balanced"),
(22412, 22412, "Anomic Demon", 0, "", 0, "LineageMonster4.eyeless", 36, 43.5, 1, "male", "L2Npc", 40, 2444, 2444, 0, 0, 10, 10, 10, 10, 10, 10, 0, 0, 500, 500, 500, 500, 253, 0, 253, 0, 0, NULL, 80, 120, "", 0, 0, 0, "LAST_HIT", 0, 0, 0, "balanced"),
(22413, 22413, "Shadow Vassal", 0, "", 0, "LineageMonster4.eyeless", 36, 43.5, 1, "male", "L2Npc", 40, 2444, 2444, 0, 0, 10, 10, 10, 10, 10, 10, 0, 0, 500, 500, 500, 500, 253, 0, 253, 0, 0, NULL, 80, 120, "", 0, 0, 0, "LAST_HIT", 0, 0, 0, "balanced"),
(22414, 22414, "Foundry Slave", 0, "", 0, "LineageMonster3.zombie_gateguard", 17, 30.5, 1, "male", "L2Npc", 40, 2444, 2444, 0, 0, 10, 10, 10, 10, 10, 10, 0, 0, 500, 500, 500, 500, 253, 0, 253, 0, 0, NULL, 80, 120, "", 0, 0, 0, "LAST_HIT", 0, 0, 0, "balanced"),
(22415, 22415, "Foundry Underling", 0, "", 0, "LineageMonster4.eyeless", 36, 43.5, 1, "male", "L2Npc", 40, 2444, 2444, 0, 0, 10, 10, 10, 10, 10, 10, 0, 0, 500, 500, 500, 500, 253, 0, 253, 0, 0, NULL, 80, 120, "", 0, 0, 0, "LAST_HIT", 0, 0, 0, "balanced"),
(22416, 22416, "Kechi's Captain", 0, "", 0, "LineageMonster2.ifrit_30_bi", 36, 43.5, 1, "male", "L2Npc", 40, 2444, 2444, 0, 0, 10, 10, 10, 10, 10, 10, 0, 0, 500, 500, 500, 500, 253, 0, 253, 0, 0, NULL, 80, 120, "", 0, 0, 0, "LAST_HIT", 0, 0, 0, "balanced"),
(22417, 22417, "Kechi's Guard", 0, "", 0, "LineageMonster3.portrait_spirit_winged_150p", 36, 43.5, 1, "male", "L2Npc", 40, 2444, 2444, 0, 0, 10, 10, 10, 10, 10, 10, 0, 0, 500, 500, 500, 500, 253, 0, 253, 0, 0, NULL, 80, 120, "", 0, 0, 0, "LAST_HIT", 0, 0, 0, "balanced"),
(22418, 22418, "Burning Iris", 0, "", 0, "LineageMonster4.eyeless_080p", 32, 35, 1, "male", "L2Npc", 40, 2444, 2444, 0, 0, 10, 10, 10, 10, 10, 10, 0, 0, 500, 500, 500, 500, 253, 0, 253, 0, 0, NULL, 80, 120, "", 0, 0, 0, "LAST_HIT", 0, 0, 0, "balanced"),
(22419, 22419, "Flame Iris", 0, "", 0, "LineageMonster4.eyeless_080p", 32, 35, 1, "male", "L2Npc", 40, 2444, 2444, 0, 0, 10, 10, 10, 10, 10, 10, 0, 0, 500, 500, 500, 500, 253, 0, 253, 0, 0, NULL, 80, 120, "", 0, 0, 0, "LAST_HIT", 0, 0, 0, "balanced"),
(22420, 22420, "Brimstone Iris", 0, "", 0, "LineageMonster4.eyeless_080p", 32, 35, 1, "male", "L2Npc", 40, 2444, 2444, 0, 0, 10, 10, 10, 10, 10, 10, 0, 0, 500, 500, 500, 500, 253, 0, 253, 0, 0, NULL, 80, 120, "", 0, 0, 0, "LAST_HIT", 0, 0, 0, "balanced"),
(22421, 22421, "Hellios Native", 0, "", 0, "LineageNPC.a_common_peopleC_Mhuman", 8, 23.5, 1, "male", "L2Npc", 40, 2444, 2444, 0, 0, 10, 10, 10, 10, 10, 10, 0, 0, 500, 500, 500, 500, 253, 0, 253, 0, 0, NULL, 80, 120, "", 0, 0, 0, "LAST_HIT", 0, 0, 0, "balanced"),
(22422, 22422, "Failan's Guard", 0, "", 0, "LineageMonster3.Death_Blader_Raid", 8, 23.5, 1, "male", "L2Npc", 40, 2444, 2444, 0, 0, 10, 10, 10, 10, 10, 10, 0, 0, 500, 500, 500, 500, 253, 0, 253, 0, 0, NULL, 80, 120, "", 0, 0, 0, "LAST_HIT", 0, 0, 0, "balanced");

INSERT INTO `npc` VALUES
(25001, 25001, "Greyclaw Kutus", 0, "Raid Boss", 0, "Monster.ol_mahum_champion_50_bi", 21, 43.5, 23, "male", "L2RaidBoss", 40, 95986, 545, 117.62, 4.73, 60, 57, 73, 76, 70, 80, 714843, 67170, 61, 857, 6, 348, 409, 0, 3819, 67, 633, 0, 50, 170, "NULL", 0, 0, 0, "LAST_HIT", 0, 0, 0, "balanced"),
(25002, 25002, "Guard of Kutus", 0, "Raid Fighter", 0, "Monster.ol_mahum", 13.5, 25, 22, "male", "L2Minion", 40, 6613, 257, 29.94, 4.73, 40, 43, 30, 41, 20, 10, 0, 0, 74, 411, 9, 167, 278, 0, 333, 7, 0, 0, 50, 170, "NULL", 0, 0, 0, "LAST_HIT", 0, 0, 0, "fighter"),
(25003, 25003, "Pawn of Kutus", 0, "Raid Fighter", 0, "Monster.ol_mahum", 13.5, 25, 22, "male", "L2Minion", 40, 9870, 257, 29.94, 4.73, 40, 43, 30, 41, 20, 10, 0, 0, 111, 411, 22, 167, 278, 0, 333, 123, 0, 0, 50, 170, "NULL", 0, 0, 0, "LAST_HIT", 0, 0, 0, "fighter"),
(25004, 25004, "Turek Mercenary Captain", 0, "Raid Boss", 0, "Monster.orc_champion_50_bi", 15, 35, 30, "male", "L2RaidBoss", 40, 168366, 763, 310.14, 5.72, 60, 57, 73, 76, 70, 80, 1424160, 129276, 226, 1127, 70, 458, 278, 0, 3819, 124, 0, 0, 72, 275, "NULL", 0, 0, 0, "LAST_HIT", 0, 0, 0, "balanced"),
(25005, 25005, "Turek Mercenary Archer", 0, "Raid Fighter", 0, "Monster.orc_archer", 14, 25, 29, "male", "L2Minion", 500, 11414, 365, 79.32, 4.73, 40, 43, 30, 41, 20, 10, 0, 0, 604, 542, 111, 220, 249, 0, 333, 271, 0, 0, 49, 187, "NULL", 0, 0, 0, "LAST_HIT", 0, 0, 0, "archer"),
(25006, 25006, "Turek Mercenary Warrior", 0, "Raid Fighter", 0, "Monster.orc_fighter", 12, 22, 29, "male", "L2Minion", 40, 8518, 365, 79.32, 4.73, 40, 43, 30, 41, 20, 10, 0, 0, 203, 542, 62, 220, 278, 0, 333, 2, 0, 0, 49, 187, "NULL", 0, 0, 0, "LAST_HIT", 0, 0, 0, "fighter"),
(25007, 25007, "Retreat Spider Cletu", 0, "Raid Boss", 0, "Monster.poison_spider", 27, 25.5, 42, "male", "L2RaidBoss", 40, 331522, 1062, 428.19, 5.72, 60, 57, 73, 76, 70, 80, 2299956, 251972, 746, 1728, 324, 701, 409, 0, 3819, 0, 0, 0, 60, 170, "NULL", 0, 0, 0, "LAST_HIT", 0, 0, 0, "balanced"),
(25008, 25008, "Cletu's Retainer", 0, "Raid Fighter", 0, "Monster.giant_spider", 26, 25.5, 41, "male", "L2Minion", 40, 33216, 514, 110.41, 5.72, 40, 43, 30, 41, 20, 10, 0, 0, 662, 835, 278, 339, 278, 0, 333, 0, 0, 0, 72, 170, "NULL", 0, 0, 0, "LAST_HIT", 0, 0, 0, "fighter"),
(25009, 25009, "Cletu's Pawn", 0, "Raid Fighter", 0, "Monster.giant_spider", 26, 25.5, 41, "male", "L2Minion", 40, 16608, 514, 110.41, 5.72, 40, 43, 30, 41, 20, 10, 0, 0, 662, 835, 278, 339, 278, 0, 333, 0, 0, 0, 72, 170, "NULL", 0, 0, 0, "LAST_HIT", 0, 0, 0, "fighter"),
(25010, 25010, "Furious Thieles", 0, "Raid Boss", 0, "Monster.ti_mi_tran", 23, 90, 55, "male", "L2RaidBoss", 40, 624464, 2039, 592.29, 7.7, 60, 57, 73, 76, 70, 80, 2988757, 448385, 2471, 2576, 1817, 1046, 278, 0, 3819, 0, 0, 0, 19, 81, "NULL", 0, 0, 0, "LAST_HIT", 0, 0, 0, "balanced"),
(25011, 25011, "Guard of Thieles", 0, "Raid Fighter", 0, "Monster.zenta_lizardman_scout", 11, 30, 54, "male", "L2Minion", 500, 42806, 987, 153.99, 7.7, 40, 43, 30, 41, 20, 10, 0, 0, 6746, 1252, 2944, 508, 249, 0, 333, 279, 0, 0, 40, 187, "NULL", 0, 0, 0, "LAST_HIT", 0, 0, 0, "fighter"),
(25012, 25012, "Follower of Thieles", 0, "Raid Fighter", 0, "Monster.dryad", 9, 20, 54, "female", "L2Minion", 40, 31945, 987, 153.99, 7.7, 40, 43, 30, 41, 20, 10, 0, 0, 2277, 1252, 1656, 508, 278, 0, 333, 0, 0, 0, 44, 187, "NULL", 0, 0, 0, "LAST_HIT", 0, 0, 0, "balanced"),
(25013, 25013, "Ghost of Peasant Leader", 0, "Raid Boss", 0, "Monster.skeleton_knight_50_bi", 15, 39, 50, "male", "L2RaidBoss", 40, 507285, 1722, 529.53, 7.7, 60, 57, 73, 76, 70, 80, 2494222, 346727, 1510, 2226, 862, 904, 278, 0, 3819, 145, 0, 0, 64, 275, "NULL", 0, 1, 0, "LAST_HIT", 0, 0, 0, "balanced"),
(25014, 25014, "Ghost of Peasant", 0, "Raid Fighter", 0, "Monster.skeleton", 11, 25, 49, "male", "L2Minion", 40, 51380, 830, 137.24, 6.74, 40, 43, 30, 41, 20, 10, 0, 0, 2751, 1079, 3086, 438, 278, 0, 333, 68, 0, 0, 66, 187, "NULL", 0, 1, 0, "LAST_HIT", 0, 0, 0, "balanced"),
(25015, 25015, "Ghost of Peasant", 0, "Raid Fighter", 0, "Monster.skeleton_archer", 11, 27, 49, "male", "L2Minion", 500, 25690, 830, 137.24, 6.74, 40, 43, 30, 41, 20, 10, 0, 0, 1375, 1079, 771, 438, 278, 0, 333, 14, 0, 0, 44, 187, "NULL", 0, 1, 0, "LAST_HIT", 0, 0, 0, "archer"),
(25016, 25016, "The 3rd Underwater Guardian", 0, "Raid Boss", 0, "Monster.susceptor_100_bi", 40, 73, 60, "male", "L2RaidBoss", 40, 188376, 2368, 702.39, 8.75, 60, 57, 73, 76, 70, 80, 3346092, 522780, 3860, 2951, 3932, 1198, 278, 0, 3819, 0, 0, 0, 43, 243, "NULL", 0, 0, 0, "LAST_HIT", 0, 0, 0, "balanced"),
(25017, 25017, "Escort of the 3rd Guardian", 0, "Raid Fighter", 0, "Monster.will_o_wisp", 13, 22, 59, "male", "L2Minion", 40, 24399, 1150, 183.19, 7.7, 40, 43, 30, 41, 20, 10, 0, 0, 3509, 1437, 3472, 583, 278, 0, 333, 0, 0, 0, 88, 187, "NULL", 0, 0, 0, "LAST_HIT", 0, 0, 0, "balanced"),
(25018, 25018, "Support of the 3rd Guardian", 0, "Raid Fighter", 0, "Monster.will_o_wisp", 13, 22, 59, "male", "L2Minion", 40, 12199, 1150, 183.19, 7.7, 40, 43, 30, 41, 20, 10, 0, 0, 3509, 1437, 3472, 583, 278, 0, 333, 0, 0, 0, 88, 187, "NULL", 0, 0, 0, "LAST_HIT", 0, 0, 0, "balanced"),
(25019, 25019, "Pan Dryad", 0, "Raid Boss", 0, "Monster.pan_100_bi", 42, 73, 25, "male", "L2RaidBoss", 40, 206185, 606, 127.71, 4.73, 60, 57, 73, 76, 70, 80, 730469, 69595, 146, 928, 30, 377, 614, 0, 3819, 291, 0, 0, 45, 170, "NULL", 0, 0, 0, "LAST_HIT", 0, 0, 0, "balanced"),
(25020, 25020, "Breka Warlock Pastu", 0, "Raid Boss", 0, "Monster.batur_orc_shaman_100_bi", 22, 35, 34, "male", "L2RaidBoss", 40, 156584, 893, 178.88, 5.72, 60, 57, 73, 76, 70, 80, 1174184, 135023, 280, 1308, 55, 531, 278, 0, 3819, 8, 0, 0, 81, 275, "NULL", 0, 0, 0, "LAST_HIT", 0, 0, 0, "balanced"),
(25021, 25021, "Pastu's Silhouette", 0, "Raid Fighter", 0, "Monster.silhouette", 8, 23, 33, "female", "L2Minion", 40, 15774, 430, 45.88, 5.72, 40, 43, 30, 41, 20, 10, 0, 0, 258, 630, 51, 256, 278, 0, 333, 0, 0, 0, 88, 187, "NULL", 0, 0, 0, "LAST_HIT", 0, 0, 0, "fighter"),
(25022, 25022, "Pastu's Shadow", 0, "Raid Fighter", 0, "Monster.shadow", 10, 30, 33, "male", "L2Minion", 40, 7887, 430, 45.88, 5.72, 40, 43, 30, 41, 20, 10, 0, 0, 258, 630, 51, 256, 278, 0, 333, 0, 0, 0, 88, 187, "NULL", 0, 0, 0, "LAST_HIT", 0, 0, 0, "fighter"),
(25023, 25023, "Stakato Queen Zyrnna", 0, "Raid Boss", 0, "Monster.marsh_stakato_queen_100_bi", 30, 76, 34, "female", "L2RaidBoss", 40, 208019, 1415, 332.2, 6.74, 60, 57, 73, 76, 70, 80, 1753455, 156895, 340, 1308, 110, 531, 278, 0, 3819, 150, 0, 0, 81, 275, "NULL", 0, 0, 0, "LAST_HIT", 0, 0, 0, "balanced"),
(25024, 25024, "Jeruna's Guard Captain", 0, "Raid Fighter", 0, "Monster.marsh_stakato_drone", 9, 24, 33, "male", "L2Minion", 40, 20909, 677, 85.21, 6.74, 40, 43, 30, 41, 20, 10, 0, 0, 626, 630, 408, 256, 278, 0, 333, 238, 0, 0, 88, 187, "NULL", 0, 0, 0, "LAST_HIT", 0, 0, 0, "balanced"),
(25025, 25025, "Jeruna's Guard", 0, "Raid Fighter", 0, "Monster.marsh_stakato_soldier", 10, 25, 33, "male", "L2Minion", 40, 10454, 677, 85.21, 6.74, 40, 43, 30, 41, 20, 10, 0, 0, 313, 630, 102, 256, 278, 0, 333, 257, 0, 0, 33, 187, "NULL", 0, 0, 0, "LAST_HIT", 0, 0, 0, "fighter"),
(25026, 25026, "Katu Van Leader Atui", 0, "Raid Boss", 0, "Monster.ketra_orc_overload", 12, 24, 49, "male", "L2RaidBoss", 40, 352421, 1660, 278.27, 6.74, 60, 57, 73, 76, 70, 80, 1655129, 248433, 1147, 2160, 383, 877, 278, 0, 3819, 84, 0, 0, 53, 275, "NULL", 0, 0, 0, "LAST_HIT", 0, 0, 0, "balanced"),
(25027, 25027, "Katu Van Marksman", 0, "Raid Fighter", 0, "Monster.ketra_orc_archer", 12, 27, 48, "male", "L2Minion", 500, 23911, 799, 72.08, 6.74, 40, 43, 30, 41, 20, 10, 0, 0, 3102, 1047, 613, 425, 249, 0, 333, 279, 0, 0, 49, 187, "NULL", 0, 0, 0, "LAST_HIT", 0, 0, 0, "archer"),
(25028, 25028, "Katu Van Raider", 0, "Raid Fighter", 0, "Monster.ketra_orc_warrior", 12, 24, 48, "male", "L2Minion", 40, 17844, 799, 72.08, 6.74, 40, 43, 30, 41, 20, 10, 0, 0, 1047, 1047, 345, 425, 278, 0, 333, 128, 0, 0, 39, 187, "NULL", 0, 0, 0, "LAST_HIT", 0, 0, 0, "fighter"),
(25029, 25029, "Atraiban", 0, "Raid Boss", 0, "Monster.field_stalker_200_bi", 45, 96, 53, "male", "L2RaidBoss", 40, 156190, 1911, 611.07, 7.7, 60, 57, 73, 76, 70, 80, 3145490, 461913, 2344, 2433, 1974, 988, 278, 0, 3819, 0, 0, 0, 113, 275, "NULL", 0, 0, 0, "LAST_HIT", 0, 0, 0, "balanced"),
(25030, 25030, "Atraiban's Top Disciple", 0, "Raid Fighter", 0, "Monster.will_o_wisp", 13, 22, 52, "male", "L2Minion", 40, 20135, 923, 158.68, 7.7, 40, 43, 30, 41, 20, 10, 0, 0, 2114, 1181, 1727, 479, 278, 0, 333, 0, 0, 0, 88, 187, "NULL", 0, 0, 0, "LAST_HIT", 0, 0, 0, "balanced"),
(25031, 25031, "Atraiban's Disciple", 0, "Raid Fighter", 0, "Monster.liviona", 15, 28, 52, "male", "L2Minion", 40, 10067, 923, 158.68, 7.7, 40, 43, 30, 41, 20, 10, 0, 0, 2114, 1181, 1727, 479, 278, 0, 333, 0, 0, 0, 88, 187, "NULL", 0, 0, 0, "LAST_HIT", 0, 0, 0, "balanced"),
(25032, 25032, "Eva's Guardian Millenu", 0, "Raid Boss", 0, "Monster.banshee_50_bi", 13.5, 38, 58, "female", "L2RaidBoss", 40, 229722, 2707, 828.24, 8.75, 60, 57, 73, 76, 70, 80, 1820975, 806823, 5880, 3349, 7541, 1360, 278, 0, 3819, 3939, 0, 0, 129, 275, "NULL", 0, 0, 0, "LAST_HIT", 0, 0, 0, "balanced"),
(25033, 25033, "Millenu Guard Shaman", 0, "Raid Fighter", 0, "Monster.heltor_silenos_shaman", 13, 32, 57, "male", "L2Minion", 40, 20074, 1319, 218.67, 8.75, 40, 43, 30, 41, 20, 10, 0, 0, 7473, 1634, 12940, 663, 278, 0, 333, 5131, 0, 0, 31, 187, "NULL", 0, 0, 0, "LAST_HIT", 0, 0, 0, "balanced"),
(25034, 25034, "Mellenu Guard Warrior", 0, "Raid Fighter", 0, "Monster.skeleton_royal_guard", 11, 28.5, 57, "male", "L2Minion", 40, 30142, 1319, 218.67, 8.75, 40, 43, 30, 41, 20, 10, 0, 0, 11210, 1634, 29118, 663, 278, 0, 333, 946, 945, 0, 88, 187, "NULL", 0, 1, 0, "LAST_HIT", 0, 0, 0, "balanced"),
(25035, 25035, "Shilen's Messenger Cabrio", 0, "Raid Boss", 0, "Monster.vale_master_50_bi", 18, 63, 70, "male", "L2RaidBoss", 40, 888658, 3058, 844.9, 9.81, 60, 57, 73, 76, 70, 80, 1915900, 918808, 6981, 3764, 8986, 1528, 278, 0, 3819, 189, 0, 0, 113, 275, "NULL", 0, 0, 0, "LAST_HIT", 0, 0, 0, "balanced"),
(25036, 25036, "Cabrio Captor", 0, "Raid Fighter", 0, "Monster.skeleton_archer", 11, 27, 69, "male", "L2Minion", 500, 62338, 1493, 223.73, 8.75, 40, 43, 30, 41, 20, 10, 0, 0, 19755, 1840, 15424, 747, 249, 0, 333, 279, 0, 0, 44, 187, "NULL", 0, 1, 0, "LAST_HIT", 0, 0, 0, "archer"),
(25037, 25037, "Cabrio Blader", 0, "Raid Fighter", 0, "Monster.doll_blader", 6, 12, 69, "male", "L2Minion", 40, 46520, 1493, 223.73, 8.75, 40, 43, 30, 41, 20, 10, 0, 0, 6668, 1840, 8676, 747, 278, 0, 333, 5129, 5129, 0, 24, 187, "NULL", 0, 0, 0, "LAST_HIT", 0, 0, 0, "balanced"),
(25038, 25038, "Tirak", 0, "Raid Boss", 0, "Monster.dre_vanul_100_bi", 28, 75, 28, "male", "L2RaidBoss", 40, 116581, 699, 143.8, 4.73, 60, 57, 73, 76, 70, 80, 750326, 74683, 96, 1044, 10, 424, 278, 0, 3819, 0, 0, 0, 129, 275, "NULL", 0, 0, 0, "LAST_HIT", 0, 0, 0, "balanced"),
(25039, 25039, "Tirak's Guard", 0, "Raid Fighter", 0, "Monster.spartoi", 11, 27, 27, "male", "L2Minion", 40, 11861, 334, 36.74, 4.73, 40, 43, 30, 41, 20, 10, 0, 0, 175, 502, 38, 204, 278, 0, 333, 68, 0, 0, 66, 187, "NULL", 0, 1, 0, "LAST_HIT", 0, 0, 0, "fighter"),
(25040, 25040, "Tirak's Knight", 0, "Raid Fighter", 0, "Monster.skeleton", 11, 25, 27, "male", "L2Minion", 40, 5930, 334, 36.74, 4.73, 40, 43, 30, 41, 20, 10, 0, 0, 87, 502, 9, 204, 278, 0, 333, 2, 945, 0, 66, 187, "NULL", 0, 1, 0, "LAST_HIT", 0, 0, 0, "fighter"),
(25041, 25041, "Remmel", 0, "Raid Boss", 0, "Monster.marsh_stakato_queen_100_bi", 30, 76, 35, "female", "L2RaidBoss", 40, 165289, 927, 185.07, 5.72, 60, 57, 73, 76, 70, 80, 1018607, 103175, 200, 1356, 28, 550, 467, 0, 3819, 221, 109, 0, 50, 170, "NULL", 0, 0, 0, "LAST_HIT", 0, 0, 0, "balanced"),
(25042, 25042, "Remmel's Archer", 0, "Raid Fighter", 0, "Monster.batur_orc_archer", 11, 21.5, 34, "male", "L2Minion", 500, 11143, 446, 47.49, 5.72, 40, 43, 30, 41, 20, 10, 0, 0, 547, 654, 46, 265, 247, 0, 333, 275, 0, 0, 45, 170, "NULL", 0, 0, 0, "LAST_HIT", 0, 0, 0, "archer"),
(25043, 25043, "Remmel's Guard", 0, "Raid Fighter", 0, "Monster.marsh_stakato", 10, 20, 34, "male", "L2Minion", 40, 8316, 446, 47.49, 5.72, 40, 43, 30, 41, 20, 10, 0, 0, 184, 654, 26, 265, 278, 0, 333, 127, 0, 0, 21, 170, "NULL", 0, 0, 0, "LAST_HIT", 0, 0, 0, "fighter"),
(25044, 25044, "Barion", 0, "Raid Boss", 0, "Monster.skeleton_knight_50_bi", 15, 39, 47, "male", "L2RaidBoss", 40, 319791, 1296, 264.56, 6.74, 60, 57, 73, 76, 70, 80, 1624139, 238098, 956, 2030, 296, 824, 278, 0, 3819, 70, 0, 0, 64, 275, "NULL", 0, 1, 0, "LAST_HIT", 0, 0, 0, "balanced"),
(25045, 25045, "Dark Mage's of Barion", 0, "Raid Fighter", 0, "Monster.batur_orc_shaman", 11, 16, 46, "male", "L2Minion", 40, 32280, 618, 68.43, 6.74, 40, 43, 30, 41, 20, 10, 0, 0, 861, 983, 260, 399, 278, 0, 333, 159, 0, 0, 55, 132, "NULL", 0, 0, 0, "LAST_HIT", 0, 0, 0, "balanced"),
(25046, 25046, "Barion's Grunt", 0, "Raid Fighter", 0, "Monster.spartoi", 11, 27, 46, "male", "L2Minion", 40, 16140, 618, 68.43, 6.74, 40, 43, 30, 41, 20, 10, 0, 0, 861, 983, 260, 399, 278, 0, 333, 129, 0, 0, 66, 187, "NULL", 0, 1, 0, "LAST_HIT", 0, 0, 0, "fighter"),
(25047, 25047, "Karte", 0, "Raid Boss", 0, "Monster.death_knight_50_bi", 18, 47.5, 49, "male", "L2RaidBoss", 40, 352421, 1660, 278.27, 6.74, 60, 57, 73, 76, 70, 80, 1412364, 185123, 769, 2160, 184, 877, 278, 0, 3819, 131, 0, 0, 43, 275, "NULL", 0, 1, 0, "LAST_HIT", 0, 0, 0, "balanced"),
(25048, 25048, "Karte's Chief Knight", 0, "Raid Fighter", 0, "Monster.skeleton_knight", 10, 25, 48, "male", "L2Minion", 40, 35688, 799, 72.08, 6.74, 40, 43, 30, 41, 20, 10, 0, 0, 1403, 1047, 664, 425, 278, 0, 333, 71, 0, 0, 44, 187, "NULL", 0, 1, 0, "LAST_HIT", 0, 0, 0, "fighter"),
(25049, 25049, "Karte's Royal Guard", 0, "Raid Fighter", 0, "Monster.spartoi", 11, 27, 48, "male", "L2Minion", 40, 17844, 799, 72.08, 6.74, 40, 43, 30, 41, 20, 10, 0, 0, 701, 1047, 166, 425, 278, 0, 333, 74, 0, 0, 66, 187, "NULL", 0, 1, 0, "LAST_HIT", 0, 0, 0, "fighter"),
(25050, 25050, "Verfa", 0, "Raid Boss", 0, "Monster.death_blader_200_bi", 45, 141, 51, "male", "L2RaidBoss", 40, 771340, 2039, 250.26, 7.7, 60, 57, 73, 76, 70, 80, 1381165, 185853, 1700, 2294, 879, 931, 278, 0, 3819, 1472, 0, 0, 162, 275, "NULL", 0, 1, 0, "LAST_HIT", 0, 0, 0, "balanced"),
(25051, 25051, "Rahha", 0, "Raid Boss", 0, "Monster3.Bloody_Queen_Raid", 28, 36, 65, "female", "L2RaidBoss", 40, 818959, 2707, 673.33, 8.75, 60, 57, 73, 76, 70, 80, 3674504, 679343, 4656, 3349, 4297, 1360, 278, 0, 3819, 0, 0, 0, 129, 275, "NULL", 0, 0, 0, "LAST_HIT", 0, 0, 0, "balanced"),
(25052, 25052, "Priestess of Rahha", 0, "Raid Fighter", 0, "Monster.medusa", 10, 25, 64, "female", "L2Minion", 40, 85286, 1319, 177.86, 8.75, 40, 43, 30, 41, 20, 10, 0, 0, 4442, 1634, 4159, 663, 278, 0, 333, 0, 0, 0, 55, 187, "NULL", 0, 0, 0, "LAST_HIT", 0, 0, 0, "balanced"),
(25053, 25053, "Fanatics of Rahha", 0, "Raid Fighter", 0, "Monster.harpy", 10, 42, 64, "female", "L2Minion", 40, 42643, 1319, 177.86, 8.75, 40, 43, 30, 41, 20, 10, 0, 0, 4442, 1634, 4159, 663, 278, 0, 333, 0, 0, 0, 66, 187, "NULL", 0, 0, 0, "LAST_HIT", 0, 0, 0, "balanced"),
(25054, 25054, "Kernon", 0, "Raid Boss", 0, "Monster.kaim_vanul", 24, 40, 75, "male", "L2RaidBoss", 40, 945900, 3420, 849.66, 9.81, 60, 57, 73, 76, 70, 80, 2238750, 1054472, 8986, 4188, 12912, 1701, 278, 0, 3819, 0, 0, 0, 59, 275, "NULL", 0, 0, 0, "LAST_HIT", 0, 0, 0, "balanced"),
(25055, 25055, "Taliadon", 0, "Raid Fighter", 0, "Monster.death_blader", 15, 45, 74, "male", "L2Minion", 40, 99324, 1673, 225.62, 9.81, 40, 43, 30, 41, 20, 10, 0, 0, 17216, 2051, 49884, 833, 278, 0, 333, 1472, 0, 0, 110, 187, "NULL", 0, 1, 0, "LAST_HIT", 0, 0, 0, "balanced"),
(25056, 25056, "Vemsk", 0, "Raid Fighter", 0, "Monster.death_knight", 12, 31, 74, "male", "L2Minion", 40, 49662, 1673, 225.62, 9.81, 40, 43, 30, 41, 20, 10, 0, 0, 8608, 2051, 12471, 833, 278, 0, 333, 142, 0, 0, 29, 187, "NULL", 0, 1, 0, "LAST_HIT", 0, 0, 0, "balanced"),
(25057, 25057, "Biconne of Blue Sky", 0, "Raid Boss", 0, "Monster.lienrik", 12, 50, 45, "male", "L2RaidBoss", 40, 288415, 2235, 250.9, 7.7, 60, 57, 73, 76, 70, 80, 1358394, 171282, 538, 1905, 112, 774, 278, 0, 3819, 0, 0, 0, 162, 275, "NULL", 0, 0, 0, "LAST_HIT", 0, 0, 0, "balanced"),
(25058, 25058, "Biconne's Shooter", 0, "Raid Fighter", 0, "Monster.skeleton_archer", 11, 27, 44, "male", "L2Minion", 500, 19455, 1084, 64.81, 7.7, 40, 43, 30, 41, 20, 10, 0, 0, 1444, 922, 176, 374, 249, 0, 333, 279, 0, 0, 44, 187, "NULL", 0, 1, 0, "LAST_HIT", 0, 0, 0, "archer"),
(25059, 25059, "Biconne's Warrior", 0, "Raid Fighter", 0, "Monster.skeleton_knight", 10, 25, 44, "male", "L2Minion", 40, 14518, 1084, 64.81, 7.7, 40, 43, 30, 41, 20, 10, 0, 0, 487, 922, 99, 374, 278, 0, 333, 150, 0, 0, 44, 176, "NULL", 0, 1, 0, "LAST_HIT", 0, 0, 0, "fighter"),
(25060, 25060, "Unrequited Kael", 0, "Raid Boss", 0, "Monster.succubus_100_bi", 20, 75, 24, "female", "L2RaidBoss", 40, 99367, 575, 105.08, 4.73, 60, 57, 73, 76, 70, 80, 606920, 51383, 57, 892, 5, 362, 278, 0, 3819, 0, 0, 0, 97, 275, "NULL", 0, 0, 0, "LAST_HIT", 0, 0, 0, "balanced"),
(25061, 25061, "Kael's Bead", 0, "Raid Fighter", 0, "Monster.will_o_wisp", 13, 22, 23, "male", "L2Minion", 40, 6830, 272, 26.77, 4.73, 40, 43, 30, 41, 20, 10, 0, 0, 69, 428, 8, 174, 278, 0, 333, 0, 0, 0, 88, 187, "NULL", 0, 0, 0, "LAST_HIT", 0, 0, 0, "fighter"),
(25062, 25062, "Kael's Escort", 0, "Raid Fighter", 0, "Monster.harpy", 10, 42, 23, "female", "L2Minion", 40, 10195, 272, 26.77, 4.73, 40, 43, 30, 41, 20, 10, 0, 0, 103, 428, 19, 174, 278, 0, 333, 0, 0, 0, 66, 187, "NULL", 0, 0, 0, "LAST_HIT", 0, 0, 0, "fighter"),
(25063, 25063, "Chertuba of Great Soul", 0, "Raid Boss", 0, "Monster.ketra_orc_warrior_100_bi", 24, 51, 35, "male", "L2RaidBoss", 40, 330579, 927, 185.07, 5.72, 60, 57, 73, 76, 70, 80, 1018607, 103175, 401, 1356, 113, 550, 278, 0, 3819, 78, 0, 0, 58, 275, "NULL", 0, 0, 0, "LAST_HIT", 0, 0, 0, "balanced"),
(25064, 25064, "Wizard of Storm Teruk", 0, "Raid Boss", 0, "Monster.zenta_lizardman_shaman_50_bi", 19, 55, 40, "male", "L2RaidBoss", 40, 218810, 1120, 217.25, 6.74, 60, 57, 73, 76, 70, 80, 1091654, 139773, 287, 1615, 42, 656, 409, 0, 3819, 90, 0, 0, 43, 170, "NULL", 0, 0, 0, "LAST_HIT", 0, 0, 0, "balanced"),
(25065, 25065, "Teruk's Escort", 0, "Raid Fighter", 0, "Monster.zenta_lizardman", 11, 32, 39, "male", "L2Minion", 40, 21961, 531, 55.95, 5.72, 40, 43, 30, 41, 20, 10, 0, 0, 530, 780, 157, 317, 278, 0, 333, 123, 0, 0, 37, 170, "NULL", 0, 0, 0, "LAST_HIT", 0, 0, 0, "fighter"),
(25066, 25066, "Teruk's Knight", 0, "Raid Fighter", 0, "Monster.zenta_lizardman_warrior", 13, 35, 39, "male", "L2Minion", 40, 10980, 531, 55.95, 5.72, 40, 43, 30, 41, 20, 10, 0, 0, 265, 780, 39, 317, 278, 0, 333, 291, 0, 0, 40, 170, "NULL", 0, 0, 0, "LAST_HIT", 0, 0, 0, "fighter"),
(25067, 25067, "Captain of Red Flag Shaka", 0, "Raid Boss", 0, "Monster.oel_mahum_warrior_50_bi", 30, 60, 52, "male", "L2RaidBoss", 40, 554640, 1598, 554.85, 6.74, 60, 57, 73, 76, 70, 80, 2909180, 424683, 1951, 2363, 1304, 959, 278, 0, 3819, 71, 0, 0, 113, 275, "NULL", 0, 0, 0, "LAST_HIT", 0, 0, 0, "balanced"),
(25068, 25068, "Shaka's Shooter", 0, "Raid Fighter", 0, "Monster.ol_mahum_archer", 14, 25, 51, "male", "L2Minion", 500, 37786, 768, 143.99, 6.74, 40, 43, 30, 41, 20, 10, 0, 0, 5307, 1147, 2104, 465, 249, 0, 333, 277, 0, 0, 55, 187, "NULL", 0, 0, 0, "LAST_HIT", 0, 0, 0, "archer"),
(25069, 25069, "Shaka's Follower", 0, "Raid Fighter", 0, "Monster.oel_mahum_champion", 23, 61, 51, "male", "L2Minion", 40, 28199, 768, 143.99, 6.74, 40, 43, 30, 41, 20, 10, 0, 0, 1791, 1147, 1183, 465, 278, 0, 333, 128, 633, 0, 73, 187, "NULL", 0, 0, 0, "LAST_HIT", 0, 0, 0, "balanced"),
(25070, 25070, "Enchanted Forest Watcher Ruell", 0, "Raid Boss", 0, "Monster.ti_mi_tran", 23, 90, 55, "male", "L2RaidBoss", 40, 451391, 2039, 318.92, 7.7, 60, 57, 73, 76, 70, 80, 1707842, 285150, 1364, 2576, 435, 1046, 278, 0, 3819, 0, 0, 0, 19, 81, "NULL", 0, 0, 0, "LAST_HIT", 0, 0, 0, "balanced"),
(25071, 25071, "Ruell's Wind", 0, "Raid Fighter", 0, "Monster.sylph", 11, 35, 54, "female", "L2Minion", 40, 30975, 987, 82.92, 7.7, 40, 43, 30, 41, 20, 10, 0, 0, 1676, 1252, 705, 508, 278, 0, 333, 0, 0, 0, 66, 187, "NULL", 0, 0, 0, "LAST_HIT", 0, 0, 0, "fighter"),
(25072, 25072, "Ruell's Unicorn", 0, "Raid Fighter", 0, "Monster.unicorn", 14, 30, 54, "male", "L2Minion", 40, 46232, 987, 82.92, 7.7, 40, 43, 30, 41, 20, 10, 0, 0, 2514, 1252, 1586, 508, 278, 0, 333, 0, 0, 0, 50, 187, "NULL", 0, 0, 0, "LAST_HIT", 0, 0, 0, "fighter"),
(25073, 25073, "Bloody Priest Rudelto", 0, "Raid Boss", 0, "Monster.karik_100_bi", 50, 180, 69, "male", "L2RaidBoss", 40, 875948, 2987, 842.52, 8.75, 60, 57, 73, 76, 70, 80, 1894878, 895518, 6751, 3680, 8676, 1494, 278, 0, 3819, 0, 0, 0, 59, 275, "NULL", 0, 0, 0, "LAST_HIT", 0, 0, 0, "balanced"),
(25074, 25074, "Rudelto's Banshee", 0, "Raid Fighter", 0, "Monster.banshee", 9, 23, 68, "female", "L2Minion", 40, 91632, 1458, 223.1, 8.75, 40, 43, 30, 41, 20, 10, 0, 0, 6447, 1798, 8379, 730, 278, 0, 333, 0, 0, 0, 88, 187, "NULL", 0, 0, 0, "LAST_HIT", 0, 0, 0, "balanced"),
(25075, 25075, "Rudelto's Dre Vanul", 0, "Raid Fighter", 0, "Monster.dre_vanul", 14, 36, 68, "male", "L2Minion", 40, 45816, 1458, 223.1, 8.75, 40, 43, 30, 41, 20, 10, 0, 0, 6447, 1798, 8379, 730, 278, 0, 333, 0, 0, 0, 88, 187, "NULL", 0, 0, 0, "LAST_HIT", 0, 0, 0, "balanced"),
(25076, 25076, "Princess Molrang", 0, "Raid Boss", 0, "Monster.poison_toad_100_bi", 40, 20, 25, "male", "L2RaidBoss", 40, 103092, 606, 127.71, 4.73, 60, 57, 73, 76, 70, 80, 730469, 69595, 73, 928, 7, 377, 278, 0, 3819, 0, 0, 0, 81, 275, "NULL", 0, 0, 0, "LAST_HIT", 0, 0, 0, "balanced"),
(25077, 25077, "Captain Dogun", 0, "Raid Fighter", 0, "Monster.grizzly", 21, 40, 24, "male", "L2Minion", 40, 10554, 287, 32.55, 4.73, 40, 43, 30, 41, 20, 10, 0, 0, 132, 446, 27, 181, 278, 0, 333, 0, 0, 0, 44, 187, "NULL", 0, 0, 0, "LAST_HIT", 0, 0, 0, "fighter"),
(25078, 25078, "Princess' Guard", 0, "Raid Fighter", 0, "Monster.grizzly", 21, 40, 24, "male", "L2Minion", 40, 5277, 287, 32.55, 4.73, 40, 43, 30, 41, 20, 10, 0, 0, 66, 446, 6, 181, 278, 0, 333, 0, 0, 0, 44, 187, "NULL", 0, 0, 0, "LAST_HIT", 0, 0, 0, "fighter"),
(25079, 25079, "Cat's Eye Bandit", 0, "Raid Boss", 0, "Monster3.Ol_Mahum_Raid", 21, 27.5, 30, "male", "L2RaidBoss", 40, 168366, 763, 288, 5.72, 60, 57, 73, 76, 70, 80, 1329219, 122342, 206, 1127, 53, 458, 278, 0, 3819, 0, 0, 0, 81, 275, "NULL", 0, 0, 0, "LAST_HIT", 0, 0, 0, "balanced"),
(25080, 25080, "Mercenary", 0, "Raid Fighter", 0, "Monster.orc_shaman", 9, 22, 29, "male", "L2Minion", 40, 17036, 365, 73.66, 4.73, 40, 43, 30, 41, 20, 10, 0, 0, 185, 542, 47, 220, 278, 0, 333, 179, 0, 0, 49, 187, "NULL", 0, 0, 0, "LAST_HIT", 0, 0, 0, "balanced"),
(25081, 25081, "Cat's Eye Bandit", 0, "Raid Fighter", 0, "Monster.ol_mahum", 13.5, 25, 29, "male", "L2Minion", 40, 8518, 365, 73.66, 4.73, 40, 43, 30, 41, 20, 10, 0, 0, 185, 542, 47, 220, 278, 0, 333, 218, 0, 0, 55, 187, "NULL", 0, 0, 0, "LAST_HIT", 0, 0, 0, "fighter"),
(25082, 25082, "Leader of Cat Gang", 0, "Raid Boss", 0, "Monster.cat_the_cat_50_bi", 13.5, 26, 39, "male", "L2RaidBoss", 40, 206753, 1062, 210.68, 5.72, 60, 57, 73, 76, 70, 80, 1078255, 134578, 268, 1561, 39, 634, 409, 0, 3819, 0, 0, 0, 80, 170, "NULL", 0, 0, 0, "LAST_HIT", 0, 0, 0, "balanced"),
(25083, 25083, "Cat Gang", 0, "Raid Fighter", 0, "Monster.cutie_cat", 8, 15, 38, "female", "L2Minion", 40, 13903, 514, 54.21, 5.72, 40, 43, 30, 41, 20, 10, 0, 0, 330, 754, 65, 306, 278, 0, 333, 0, 0, 0, 48, 170, "NULL", 0, 0, 0, "LAST_HIT", 0, 0, 0, "fighter"),
(25084, 25084, "Cat Gang", 0, "Raid Fighter", 0, "Monster.cat_the_cat", 9, 16, 38, "male", "L2Minion", 40, 20752, 514, 54.21, 5.72, 40, 43, 30, 41, 20, 10, 0, 0, 495, 754, 146, 306, 278, 0, 333, 0, 0, 0, 80, 170, "NULL", 0, 0, 0, "LAST_HIT", 0, 0, 0, "fighter"),
(25085, 25085, "Timak Orc Chief Ranger", 0, "Raid Boss", 0, "Monster.ketra_orc_warrior_100_bi", 24, 51, 44, "male", "L2RaidBoss", 40, 371721, 1355, 453.27, 6.74, 60, 57, 73, 76, 70, 80, 2352182, 262175, 893, 1845, 414, 749, 278, 0, 3819, 157, 0, 0, 58, 275, "NULL", 0, 0, 0, "LAST_HIT", 0, 0, 0, "balanced"),
(25086, 25086, "Timak Orc Ranger", 0, "Raid Fighter", 0, "Monster.ketra_orc_archer", 12, 27, 43, "male", "L2Minion", 500, 24994, 648, 117.03, 6.74, 40, 43, 30, 41, 20, 10, 0, 0, 2392, 892, 653, 362, 249, 0, 333, 14, 0, 0, 49, 187, "NULL", 0, 0, 0, "LAST_HIT", 0, 0, 0, "archer"),
(25087, 25087, "Timak Orc Ranger", 0, "Raid Fighter", 0, "Monster.ketra_orc", 12, 29, 43, "male", "L2Minion", 40, 18652, 648, 117.03, 6.74, 40, 43, 30, 41, 20, 10, 0, 0, 807, 892, 367, 362, 278, 0, 333, 68, 0, 0, 49, 187, "NULL", 0, 0, 0, "LAST_HIT", 0, 0, 0, "fighter"),
(25088, 25088, "Crazy Mechanic Golem", 0, "Raid Boss", 0, "Monster.mechanic_golem_200_bi", 15, 63, 43, "male", "L2RaidBoss", 40, 702418, 2039, 474.62, 7.7, 60, 57, 73, 76, 70, 80, 2492637, 273103, 1794, 1785, 1948, 725, 278, 0, 3819, 0, 0, 0, 48, 243, "NULL", 0, 0, 0, "LAST_HIT", 0, 0, 0, "balanced"),
(25089, 25089, "Soulless Wild Boar", 0, "Raid Boss", 0, "Monster.giant_wild_hog", 35, 27, 59, "male", "L2RaidBoss", 40, 512194, 2301, 344.91, 7.7, 60, 57, 73, 76, 70, 80, 2072981, 415763, 2664, 2875, 1302, 1167, 409, 0, 3819, 0, 0, 0, 35, 170, "NULL", 0, 0, 0, "LAST_HIT", 0, 0, 0, "balanced"),
(25090, 25090, "Soulless Wolf", 0, "Raid Fighter", 0, "Monster.dire_wolf", 13, 11, 58, "male", "L2Minion", 40, 35416, 1117, 89.9, 7.7, 40, 43, 30, 41, 20, 10, 0, 0, 3291, 1399, 2123, 568, 278, 0, 333, 0, 0, 0, 24, 170, "NULL", 0, 0, 0, "LAST_HIT", 0, 0, 0, "fighter"),
(25091, 25091, "Soulless Bear", 0, "Raid Fighter", 0, "Monster.crimson_bear", 19, 36, 58, "male", "L2Minion", 40, 52860, 1117, 89.9, 7.7, 40, 43, 30, 41, 20, 10, 0, 0, 4936, 1399, 4777, 568, 278, 0, 333, 0, 0, 0, 37, 170, "NULL", 0, 0, 0, "LAST_HIT", 0, 0, 0, "balanced"),
(25092, 25092, "Korim", 0, "Raid Boss", 0, "Monster.heltor_silenos_shaman_50_bi", 19.5, 51, 70, "male", "L2RaidBoss", 40, 888658, 3058, 685.96, 9.81, 60, 57, 73, 76, 70, 80, 3859833, 738431, 5659, 3764, 5371, 1528, 278, 0, 3819, 201, 0, 0, 46, 275, "NULL", 0, 0, 0, "LAST_HIT", 0, 0, 0, "balanced"),
(25093, 25093, "Korim Chief Guard Kaywon", 0, "Raid Fighter", 0, "Monster.heltor_silenos_warrior", 13, 31, 69, "male", "L2Minion", 40, 93041, 1493, 181.67, 8.75, 40, 43, 30, 41, 20, 10, 0, 0, 10724, 1840, 20400, 747, 278, 0, 333, 162, 0, 0, 39, 187, "NULL", 0, 0, 0, "LAST_HIT", 0, 0, 0, "balanced"),
(25094, 25094, "Korim Guards", 0, "Raid Fighter", 0, "Monster.heltor_silenos", 13, 29, 69, "male", "L2Minion", 40, 46520, 1493, 181.67, 8.75, 40, 43, 30, 41, 20, 10, 0, 0, 5362, 1840, 5100, 747, 278, 0, 333, 86, 0, 0, 37, 187, "NULL", 0, 0, 0, "LAST_HIT", 0, 0, 0, "balanced"),
(25095, 25095, "Elf Renoa", 0, "Raid Boss", 0, "Monster.elf_ghost", 7, 21, 29, "male", "L2RaidBoss", 40, 121941, 731, 149.37, 4.73, 60, 57, 73, 76, 70, 80, 755659, 76955, 104, 1085, 11, 440, 278, 0, 3819, 0, 0, 0, 129, 275, "NULL", 0, 1, 0, "LAST_HIT", 0, 0, 0, "balanced"),
(25096, 25096, "Renoa's Elpy", 0, "Raid Fighter", 0, "Monster.elpy", 5, 4.5, 28, "male", "L2Minion", 40, 8296, 349, 38.19, 4.73, 40, 43, 30, 41, 20, 10, 0, 0, 126, 522, 18, 212, 278, 0, 333, 0, 0, 0, 55, 187, "NULL", 0, 0, 0, "LAST_HIT", 0, 0, 0, "fighter"),
(25097, 25097, "Renoa's Hog", 0, "Raid Fighter", 0, "Monster.giant_wild_hog", 35, 27, 28, "male", "L2Minion", 40, 12383, 349, 38.19, 4.73, 40, 43, 30, 41, 20, 10, 0, 0, 190, 522, 41, 212, 278, 0, 333, 0, 0, 0, 38, 187, "NULL", 0, 0, 0, "LAST_HIT", 0, 0, 0, "fighter"),
(25098, 25098, "Sejarr's Servitor", 0, "Raid Boss", 0, "Monster.dark_fencer_200_bi", 30, 43, 35, "male", "L2RaidBoss", 40, 330579, 927, 185.07, 5.72, 60, 57, 73, 76, 70, 80, 1018607, 103175, 401, 1356, 113, 550, 278, 0, 3819, 0, 0, 0, 40, 275, "NULL", 0, 0, 0, "LAST_HIT", 0, 0, 0, "balanced"),
(25099, 25099, "Rotten Tree Repiro", 0, "Raid Boss", 0, "Monster.hanged_man_ripper", 35, 80, 44, "male", "L2RaidBoss", 40, 273375, 1355, 244.07, 6.74, 60, 57, 73, 76, 70, 80, 1344111, 167614, 493, 1845, 99, 749, 278, 0, 3819, 0, 0, 0, 89, 89, "NULL", 0, 0, 0, "LAST_HIT", 0, 0, 0, "balanced"),
(25100, 25100, "Spirit of Sea of Spores", 0, "Raid Fighter", 0, "Monster.pixy", 5, 25, 43, "female", "L2Minion", 40, 27494, 648, 63.01, 6.74, 40, 43, 30, 41, 20, 10, 0, 0, 318, 892, 88, 362, 278, 0, 333, 0, 0, 0, 88, 187, "NULL", 0, 0, 0, "LAST_HIT", 0, 0, 0, "fighter"),
(25101, 25101, "Fighter of Sea of Spores", 0, "Raid Fighter", 0, "Monster.troll", 21, 35, 43, "male", "L2Minion", 40, 13747, 648, 63.01, 6.74, 40, 43, 30, 41, 20, 10, 0, 0, 318, 892, 88, 362, 278, 0, 333, 0, 0, 0, 60, 187, "NULL", 0, 0, 0, "LAST_HIT", 0, 0, 0, "fighter"),
(25102, 25102, "Shacram", 0, "Raid Boss", 0, "Monster.minotaur_100_bi", 42, 94, 45, "male", "L2RaidBoss", 40, 576831, 1722, 250.9, 7.7, 60, 57, 73, 76, 70, 80, 1591877, 230991, 1603, 1905, 927, 774, 278, 0, 3819, 300, 0, 0, 64, 275, "NULL", 0, 0, 0, "LAST_HIT", 0, 0, 0, "balanced"),
(25103, 25103, "Sorcerer Isirr", 0, "Raid Boss", 0, "Monster.zenta_lizardman_matriarch_50_bi", 30, 63, 55, "male", "L2RaidBoss", 40, 451391, 2039, 318.92, 7.7, 60, 57, 73, 76, 70, 80, 1707842, 285150, 1364, 2576, 435, 1046, 278, 0, 3819, 195, 0, 0, 85, 275, "NULL", 0, 0, 0, "LAST_HIT", 0, 0, 0, "balanced"),
(25104, 25104, "Isirr's Guard", 0, "Raid Fighter", 0, "Monster.zenta_lizardman_warrior", 13, 35, 54, "male", "L2Minion", 40, 46232, 987, 82.92, 7.7, 40, 43, 30, 41, 20, 10, 0, 0, 2514, 1252, 1586, 508, 278, 0, 333, 221, 0, 0, 44, 187, "NULL", 0, 0, 0, "LAST_HIT", 0, 0, 0, "fighter"),
(25105, 25105, "Isirr's Guards", 0, "Raid Fighter", 0, "Monster.zenta_lizardman", 11, 32, 54, "male", "L2Minion", 40, 23116, 987, 82.92, 7.7, 40, 43, 30, 41, 20, 10, 0, 0, 1257, 1252, 396, 508, 278, 0, 333, 16, 0, 0, 40, 187, "NULL", 0, 0, 0, "LAST_HIT", 0, 0, 0, "fighter"),
(25106, 25106, "Ghost of the Well Lidia", 0, "Raid Boss", 0, "Monster.bloody_queen_100_bi", 28, 85, 60, "female", "L2RaidBoss", 40, 526218, 2570, 358.55, 8.75, 60, 57, 73, 76, 70, 80, 2414839, 561233, 3581, 3188, 2006, 1294, 278, 0, 3819, 0, 0, 0, 129, 275, "NULL", 0, 0, 0, "LAST_HIT", 0, 0, 0, "balanced"),
(25107, 25107, "Lidia's Archer", 0, "Raid Fighter", 0, "Monster.skeleton_archer", 11, 27, 59, "male", "L2Minion", 500, 36451, 1251, 94.61, 8.75, 40, 43, 30, 41, 20, 10, 0, 0, 9897, 1554, 3306, 631, 249, 0, 333, 279, 0, 0, 44, 187, "NULL", 0, 1, 0, "LAST_HIT", 0, 0, 0, "archer"),
(25108, 25108, "Lidia's Fighter", 0, "Raid Fighter", 0, "Monster.death_blader", 15, 45, 59, "male", "L2Minion", 40, 27202, 1251, 94.61, 8.75, 40, 43, 30, 41, 20, 10, 0, 0, 3340, 1554, 1859, 631, 278, 0, 333, 1472, 0, 0, 110, 187, "NULL", 0, 1, 0, "LAST_HIT", 0, 0, 0, "fighter"),
(25109, 25109, "Antharas Priest Cloe", 0, "Raid Boss", 0, "Monster.succubus_100_bi", 20, 75, 74, "female", "L2RaidBoss", 40, 935092, 3347, 849.66, 9.81, 60, 57, 73, 76, 70, 80, 2212304, 1028870, 8715, 4103, 12471, 1666, 278, 0, 3819, 0, 0, 0, 97, 275, "NULL", 0, 0, 12, "PARTY_ONE_RANDOM", 0, 0, 0, "balanced"),
(25110, 25110, "Cloe's Servitor", 0, "Raid Fighter", 0, "Monster.silhouette", 8, 23, 73, "female", "L2Minion", 40, 65759, 1637, 224.99, 9.81, 40, 43, 30, 41, 20, 10, 0, 0, 11127, 2008, 21420, 815, 278, 0, 333, 0, 0, 0, 88, 187, "NULL", 0, 0, 0, "LAST_HIT", 0, 0, 0, "balanced"),
(25111, 25111, "Cloe's Servitor", 0, "Raid Fighter", 0, "Monster.shadow", 10, 30, 73, "male", "L2Minion", 40, 98148, 1637, 224.99, 9.81, 40, 43, 30, 41, 20, 10, 0, 0, 16691, 2008, 48198, 815, 278, 0, 333, 0, 0, 0, 88, 187, "NULL", 0, 0, 0, "LAST_HIT", 0, 0, 0, "balanced"),
(25112, 25112, "Agent of Beres, Meana", 0, "Raid Boss", 0, "Monster.medusa_100_bi", 20, 53, 30, "female", "L2RaidBoss", 40, 127782, 763, 155.08, 5.72, 60, 57, 73, 76, 70, 80, 890100, 105037, 169, 1127, 26, 458, 409, 0, 3819, 0, 0, 0, 50, 170, "NULL", 0, 0, 0, "LAST_HIT", 0, 0, 0, "balanced"),
(25113, 25113, "Meana's Maid", 0, "Raid Fighter", 0, "Monster.succubus", 10, 36, 29, "female", "L2Minion", 40, 8678, 365, 39.66, 4.73, 40, 43, 30, 41, 20, 10, 0, 0, 203, 542, 41, 220, 278, 0, 333, 0, 0, 0, 60, 170, "NULL", 0, 0, 0, "LAST_HIT", 0, 0, 0, "fighter"),
(25114, 25114, "Meana's Guard Doll", 0, "Raid Fighter", 0, "Monster.crimson_doll", 15, 38, 29, "male", "L2Minion", 40, 12952, 365, 39.66, 4.73, 40, 43, 30, 41, 20, 10, 0, 0, 305, 542, 94, 220, 278, 0, 333, 0, 0, 0, 60, 170, "NULL", 0, 1, 0, "LAST_HIT", 0, 0, 0, "fighter"),
(25115, 25115, "Icarus Sample 1", 0, "Raid Boss", 0, "Monster3.Kernon_Raid", 33, 51, 40, "male", "L2RaidBoss", 40, 294846, 1120, 403.46, 6.74, 60, 57, 73, 76, 70, 80, 1910416, 217891, 520, 1615, 177, 656, 278, 0, 3819, 0, 0, 0, 145, 275, "NULL", 0, 0, 0, "LAST_HIT", 0, 0, 0, "balanced"),
(25116, 25116, "Icarus Sample 2", 0, "Raid Fighter", 0, "Monster.skeleton_archer", 11, 27, 39, "male", "L2Minion", 500, 19779, 531, 103.89, 5.72, 40, 43, 30, 41, 20, 10, 0, 0, 1417, 780, 290, 317, 249, 0, 333, 273, 0, 0, 44, 187, "NULL", 0, 1, 0, "LAST_HIT", 0, 0, 0, "archer"),
(25117, 25117, "Icarus Sample 3", 0, "Raid Fighter", 0, "Monster.magical_weaver", 11, 20, 39, "male", "L2Minion", 40, 14760, 531, 103.89, 5.72, 40, 43, 30, 41, 20, 10, 0, 0, 478, 780, 163, 317, 278, 0, 333, 0, 0, 0, 99, 187, "NULL", 0, 0, 0, "LAST_HIT", 0, 0, 0, "fighter"),
(25118, 25118, "Guilotine, Warden of the Execution Grounds", 0, "Raid Boss", 0, "Monster.skeleton_pikeman_100_bi", 20, 58, 35, "male", "L2RaidBoss", 40, 330579, 1415, 185.07, 6.74, 60, 57, 73, 76, 70, 80, 1193687, 138419, 601, 1356, 236, 550, 278, 0, 3819, 96, 0, 0, 81, 275, "NULL", 0, 1, 0, "LAST_HIT", 0, 0, 0, "balanced"),
(25119, 25119, "Messenger of Fairy Queen Berun", 0, "Raid Boss", 0, "Monster.pan_100_bi", 42, 73, 50, "male", "L2RaidBoss", 40, 507285, 1722, 652.12, 7.7, 60, 57, 73, 76, 70, 80, 1237500, 455390, 1918, 2226, 1530, 904, 409, 0, 3819, 213, 0, 0, 45, 170, "NULL", 0, 0, 0, "LAST_HIT", 0, 0, 0, "balanced"),
(25120, 25120, "Berun's Officer", 0, "Raid Fighter", 0, "Monster.pan", 14, 35, 49, "male", "L2Minion", 40, 34424, 830, 168.74, 6.74, 40, 43, 30, 41, 20, 10, 0, 0, 2336, 1079, 2443, 438, 278, 0, 333, 90, 0, 0, 45, 110, "NULL", 0, 0, 0, "LAST_HIT", 0, 0, 0, "balanced"),
(25121, 25121, "Berun's Prattler", 0, "Raid Fighter", 0, "Monster.pixy", 5, 25, 49, "female", "L2Minion", 40, 51380, 830, 168.74, 6.74, 40, 43, 30, 41, 20, 10, 0, 0, 3504, 1079, 5498, 438, 278, 0, 333, 0, 0, 0, 80, 120, "NULL", 0, 0, 0, "LAST_HIT", 0, 0, 0, "balanced"),
(25122, 25122, "Refugee Hopeful Leo", 0, "Raid Boss", 0, "Monster.oel_mahum_witch_doctor_50_bi", 22.5, 54, 56, "male", "L2RaidBoss", 40, 467209, 2235, 325.56, 7.7, 60, 57, 73, 76, 70, 80, 1722981, 291015, 1459, 2649, 476, 1075, 409, 0, 3819, 201, 0, 0, 70, 170, "NULL", 0, 0, 0, "LAST_HIT", 0, 0, 0, "balanced"),
(25123, 25123, "Leo's Servant", 0, "Raid Fighter", 0, "Monster.lesser_giant", 21, 44, 55, "male", "L2Minion", 40, 47946, 1084, 84.69, 7.7, 40, 43, 30, 41, 20, 10, 0, 0, 2694, 1288, 1740, 523, 278, 0, 333, 3937, 0, 0, 15, 180, "NULL", 0, 0, 0, "LAST_HIT", 0, 0, 0, "fighter"),
(25124, 25124, "Leo's Steward", 0, "Raid Fighter", 0, "Monster.lesser_giant_mage", 21, 44, 55, "male", "L2Minion", 40, 23973, 1084, 84.69, 7.7, 40, 43, 30, 41, 20, 10, 0, 0, 1347, 1288, 435, 523, 278, 0, 333, 3938, 0, 0, 15, 180, "NULL", 0, 0, 0, "LAST_HIT", 0, 0, 0, "mage"),
(25125, 25125, "Fierce Tiger King Angel", 0, "Raid Boss", 0, "Monster.saber_toothed_tiger_200_bi", 72, 87, 65, "male", "L2RaidBoss", 40, 1637918, 2707, 828.24, 8.75, 60, 57, 73, 76, 70, 80, 1820975, 806823, 11761, 3349, 30166, 1360, 278, 0, 3819, 0, 0, 0, 97, 275, "NULL", 0, 0, 0, "LAST_HIT", 0, 0, 0, "balanced"),
(25126, 25126, "Longhorn Golkonda", 0, "Raid Boss", 0, "Monster.minotaur_100_bi", 42, 94, 79, "male", "L2RaidBoss", 40, 1974940, 3718, 844.9, 9.81, 60, 57, 73, 76, 70, 80, 2346616, 1166150, 20224, 4530, 59372, 1839, 278, 0, 3819, 91, 0, 0, 64, 275, "NULL", 0, 0, 0, "LAST_HIT", 0, 0, 0, "balanced"),
(25127, 25127, "Langk Matriarch Rashkos", 0, "Raid Boss", 0, "Monster.virud_lizardman_matriarch_50_bi", 19, 57, 24, "male", "L2RaidBoss", 40, 198734, 763, 122.59, 5.72, 60, 57, 73, 76, 70, 80, 723779, 67853, 134, 892, 27, 362, 278, 0, 3819, 124, 0, 0, 90, 275, "NULL", 0, 0, 0, "LAST_HIT", 0, 0, 0, "balanced"),
(25128, 25128, "Vuku Grand Seer Gharmash", 0, "Raid Boss", 0, "Monster.batur_orc_shaman_100_bi", 22, 35, 33, "male", "L2RaidBoss", 40, 148507, 860, 172.79, 5.72, 60, 57, 73, 76, 70, 80, 984556, 97626, 174, 1261, 24, 512, 278, 0, 3819, 195, 0, 0, 81, 275, "NULL", 0, 0, 0, "LAST_HIT", 0, 0, 0, "balanced"),
(25129, 25129, "Vuku Shaman", 0, "Raid Fighter", 0, "Monster.orc_shaman", 9, 22, 32, "male", "L2Minion", 40, 10036, 414, 44.29, 5.72, 40, 43, 30, 41, 20, 10, 0, 0, 213, 607, 39, 246, 278, 0, 333, 7, 0, 0, 49, 187, "NULL", 0, 0, 0, "LAST_HIT", 0, 0, 0, "balanced"),
(25130, 25130, "Gharmash's Pet Trimden", 0, "Raid Fighter", 0, "Monster.poison_spider", 27, 25.5, 32, "male", "L2Minion", 40, 14980, 414, 44.29, 5.72, 40, 43, 30, 41, 20, 10, 0, 0, 320, 607, 89, 246, 278, 0, 333, 0, 0, 0, 66, 187, "NULL", 0, 0, 0, "LAST_HIT", 0, 0, 0, "fighter"),
(25131, 25131, "Carnage Lord Gato", 0, "Raid Boss", 0, "Monster.oel_mahum_50_bi", 30, 57, 50, "male", "L2RaidBoss", 40, 369009, 1415, 285.12, 6.74, 60, 57, 73, 76, 70, 80, 1670250, 297042, 1243, 2226, 429, 904, 278, 0, 3819, 71, 0, 0, 113, 275, "NULL", 0, 0, 0, "LAST_HIT", 0, 0, 0, "balanced"),
(25132, 25132, "Gato's Marksman", 0, "Raid Fighter", 0, "Monster.ol_mahum_archer", 14, 25, 49, "male", "L2Minion", 500, 25080, 677, 73.9, 6.74, 40, 43, 30, 41, 20, 10, 0, 0, 3356, 1079, 682, 438, 249, 0, 333, 273, 0, 0, 55, 187, "NULL", 0, 0, 0, "LAST_HIT", 0, 0, 0, "archer"),
(25133, 25133, "Gato's Troop Leader", 0, "Raid Fighter", 0, "Monster.ol_mahum_champion", 14, 27, 49, "male", "L2Minion", 40, 18716, 677, 73.9, 6.74, 40, 43, 30, 41, 20, 10, 0, 0, 1132, 1079, 383, 438, 278, 0, 333, 69, 0, 0, 55, 187, "NULL", 0, 0, 0, "LAST_HIT", 0, 0, 0, "fighter"),
(25134, 25134, "Leto Chief Talkin", 0, "Raid Boss", 0, "Monster3.Zenta_Lizardman_Raid", 37.5, 30, 40, "male", "L2RaidBoss", 40, 218810, 1722, 217.25, 7.7, 60, 57, 73, 76, 70, 80, 1279280, 187517, 427, 1615, 87, 656, 409, 0, 3819, 0, 0, 0, 60, 170, "NULL", 0, 0, 0, "LAST_HIT", 0, 0, 0, "balanced"),
(25135, 25135, "Talkin's Seer", 0, "Raid Fighter", 0, "Monster.virud_lizardman_shaman", 10, 29, 39, "male", "L2Minion", 40, 21961, 830, 55.95, 6.74, 40, 43, 30, 41, 20, 10, 0, 0, 393, 780, 80, 317, 278, 0, 333, 7, 0, 0, 43, 170, "NULL", 0, 0, 0, "LAST_HIT", 0, 0, 0, "balanced"),
(25136, 25136, "Talkin's Bodyguard", 0, "Raid Fighter", 0, "Monster.zenta_lizardman_warrior", 13, 35, 39, "male", "L2Minion", 40, 10980, 830, 55.95, 6.74, 40, 43, 30, 41, 20, 10, 0, 0, 393, 780, 80, 317, 278, 0, 333, 16, 0, 0, 40, 170, "NULL", 0, 0, 0, "LAST_HIT", 0, 0, 0, "fighter"),
(25137, 25137, "Beleth's Seer Sephia", 0, "Raid Boss", 0, "Monster.bloody_queen_100_bi", 28, 85, 55, "female", "L2RaidBoss", 40, 451391, 2039, 318.92, 7.7, 60, 57, 73, 76, 70, 80, 2001376, 387789, 2034, 2576, 903, 1046, 278, 0, 3819, 0, 0, 0, 129, 275, "NULL", 0, 0, 0, "LAST_HIT", 0, 0, 0, "balanced"),
(25138, 25138, "Soul Drinker", 0, "Raid Fighter", 0, "Monster.mana_vampire", 11, 20, 54, "male", "L2Minion", 40, 30975, 987, 82.92, 7.7, 40, 43, 30, 41, 20, 10, 0, 0, 2500, 1252, 1464, 508, 278, 0, 333, 0, 0, 0, 99, 187, "NULL", 0, 0, 0, "LAST_HIT", 0, 0, 0, "fighter"),
(25139, 25139, "Sephia's Salve", 0, "Raid Fighter", 0, "Monster.kaim_vanul", 24, 40, 54, "male", "L2Minion", 40, 46232, 987, 82.92, 7.7, 40, 43, 30, 41, 20, 10, 0, 0, 3750, 1252, 3295, 508, 278, 0, 333, 0, 0, 0, 40, 187, "NULL", 0, 0, 0, "LAST_HIT", 0, 0, 0, "balanced"),
(25140, 25140, "Hekaton Prime", 0, "Raid Boss", 0, "Monster.susceptor", 20, 35, 65, "male", "L2RaidBoss", 40, 818959, 2707, 673.33, 8.75, 60, 57, 73, 76, 70, 80, 3674504, 679343, 4656, 3349, 4297, 1360, 278, 0, 3819, 0, 0, 0, 43, 275, "NULL", 0, 0, 0, "LAST_HIT", 0, 0, 0, "balanced"),
(25141, 25141, "Hekaton Cottus", 0, "Raid Fighter", 0, "Monster.gamlin", 11, 32, 64, "male", "L2Minion", 40, 85286, 1319, 177.86, 8.75, 40, 43, 30, 41, 20, 10, 0, 0, 8885, 1634, 16636, 663, 278, 0, 333, 0, 0, 0, 88, 187, "NULL", 0, 0, 0, "LAST_HIT", 0, 0, 0, "balanced"),
(25142, 25142, "Hekaton Chires", 0, "Raid Fighter", 0, "Monster.lesser_giant", 21, 44, 64, "male", "L2Minion", 40, 42643, 1319, 177.86, 8.75, 40, 43, 30, 41, 20, 10, 0, 0, 4442, 1634, 4159, 663, 278, 0, 333, 3937, 0, 0, 16, 198, "NULL", 0, 0, 0, "LAST_HIT", 0, 0, 0, "balanced"),
(25143, 25143, "Fire of Wrath Shuriel", 0, "Raid Boss", 0, "Monster.angel", 13.5, 36.5, 78, "male", "L2RaidBoss", 40, 977229, 3718, 844.9, 9.81, 60, 57, 73, 76, 70, 80, 2287584, 1166150, 10051, 4503, 14666, 1828, 278, 0, 3819, 2500, 0, 0, 48, 275, "NULL", 0, 0, 0, "LAST_HIT", 0, 0, 0, "balanced"),
(25144, 25144, "Shuriel's Oracle", 0, "Raid Fighter", 0, "Monster.oel_mahum_witch_doctor", 15, 34, 78, "male", "L2Minion", 40, 103799, 1859, 224.36, 9.81, 40, 43, 30, 41, 20, 10, 0, 0, 9703, 2222, 14332, 902, 278, 0, 333, 201, 0, 0, 77, 187, "NULL", 0, 0, 0, "LAST_HIT", 0, 0, 0, "mage"),
(25145, 25145, "Shuriel's Paladin", 0, "Raid Fighter", 0, "Monster.kel_mahum_champion", 13, 32, 78, "male", "L2Minion", 40, 51899, 1859, 224.36, 9.81, 40, 43, 30, 41, 20, 10, 0, 0, 9703, 2222, 14332, 902, 278, 0, 333, 147, 0, 0, 55, 187, "NULL", 0, 0, 0, "LAST_HIT", 0, 0, 0, "balanced"),
(25146, 25146, "Serpent Demon Bifrons", 0, "Raid Boss", 0, "Monster.serpent_slave_50_bi", 25, 72, 21, "male", "L2RaidBoss", 40, 90169, 485, 92.58, 4.73, 60, 57, 73, 76, 70, 80, 578451, 45688, 42, 789, 3, 320, 278, 0, 3819, 73, 0, 0, 113, 275, "NULL", 0, 0, 0, "LAST_HIT", 0, 0, 0, "balanced"),
(25147, 25147, "Assassin of Bifrons", 0, "Raid Fighter", 0, "Monster.virud_lizardman_scout", 10, 22, 20, "male", "L2Minion", 500, 6241, 227, 23.53, 4.73, 40, 43, 30, 41, 20, 10, 0, 0, 90, 378, 3, 153, 249, 0, 333, 2507, 0, 0, 47, 187, "NULL", 0, 0, 0, "LAST_HIT", 0, 0, 0, "fighter"),
(25148, 25148, "Butcher of Bifrons", 0, "Raid Fighter", 0, "Monster.virud_lizardman_warrior", 12, 30, 20, "male", "L2Minion", 40, 4657, 227, 23.53, 4.73, 40, 43, 30, 41, 20, 10, 0, 0, 30, 378, 2, 153, 278, 0, 333, 16, 0, 0, 57, 187, "NULL", 0, 0, 0, "LAST_HIT", 0, 0, 0, "fighter"),
(25149, 25149, "Zombie Lord Crowl", 0, "Raid Boss", 0, "Monster3.Zombie_Raid", 26, 22, 25, "male", "L2RaidBoss", 40, 103092, 606, 127.71, 4.73, 60, 57, 73, 76, 70, 80, 856025, 92883, 110, 928, 15, 377, 278, 0, 3819, 0, 0, 0, 24, 24, "NULL", 0, 1, 0, "LAST_HIT", 0, 0, 0, "balanced"),
(25150, 25150, "Evil Spirit Archer", 0, "Raid Fighter", 0, "Monster.skeleton_archer", 11, 27, 24, "male", "L2Minion", 500, 7071, 287, 32.55, 4.73, 40, 43, 30, 41, 20, 10, 0, 0, 296, 446, 25, 181, 249, 0, 333, 14, 0, 0, 44, 187, "NULL", 0, 1, 0, "LAST_HIT", 0, 0, 0, "archer"),
(25151, 25151, "Evil Spirit Warrior", 0, "Raid Fighter", 0, "Monster.skeleton", 11, 25, 24, "male", "L2Minion", 40, 5277, 287, 32.55, 4.73, 40, 43, 30, 41, 20, 10, 0, 0, 100, 446, 14, 181, 278, 0, 333, 946, 0, 0, 66, 187, "NULL", 0, 1, 0, "LAST_HIT", 0, 0, 0, "fighter"),
(25152, 25152, "Flame Lord Shadar", 0, "Raid Boss", 0, "Monster.dre_vanul_100_bi", 28, 75, 35, "male", "L2RaidBoss", 40, 165289, 927, 185.07, 5.72, 60, 57, 73, 76, 70, 80, 1193687, 138419, 300, 1356, 59, 550, 278, 0, 3819, 0, 0, 0, 129, 275, "NULL", 0, 0, 0, "LAST_HIT", 0, 0, 0, "balanced"),
(25153, 25153, "Claws of Shadar", 0, "Raid Fighter", 0, "Monster.imp", 10, 24, 34, "male", "L2Minion", 40, 16632, 446, 47.49, 5.72, 40, 43, 30, 41, 20, 10, 0, 0, 554, 654, 220, 265, 278, 0, 333, 0, 0, 0, 66, 187, "NULL", 0, 0, 0, "LAST_HIT", 0, 0, 0, "fighter"),
(25154, 25154, "Whip of Shadar", 0, "Raid Fighter", 0, "Monster.succubus", 10, 36, 34, "female", "L2Minion", 40, 8316, 446, 47.49, 5.72, 40, 43, 30, 41, 20, 10, 0, 0, 277, 654, 55, 265, 278, 0, 333, 0, 0, 0, 66, 187, "NULL", 0, 0, 0, "LAST_HIT", 0, 0, 0, "fighter"),
(25155, 25155, "Shaman King Selu", 0, "Raid Boss", 0, "Monster.batur_orc_overlord_100_bi", 24, 52, 40, "male", "L2RaidBoss", 40, 294846, 1120, 434.49, 6.74, 60, 57, 73, 76, 70, 80, 2046864, 230791, 570, 1615, 234, 656, 278, 0, 3819, 79, 0, 0, 129, 275, "NULL", 0, 0, 0, "LAST_HIT", 0, 0, 0, "balanced"),
(25156, 25156, "Fanatic Shaman", 0, "Raid Fighter", 0, "Monster.batur_orc_shaman", 11, 16, 39, "male", "L2Minion", 40, 19779, 531, 111.88, 5.72, 40, 43, 30, 41, 20, 10, 0, 0, 699, 780, 383, 317, 278, 0, 333, 123, 19, 0, 55, 187, "NULL", 0, 0, 0, "LAST_HIT", 0, 0, 0, "balanced"),
(25157, 25157, "Fanatic Soldier", 0, "Raid Fighter", 0, "Monster.batur_orc_warrior", 10, 20, 39, "male", "L2Minion", 40, 29521, 531, 111.88, 5.72, 40, 43, 30, 41, 20, 10, 0, 0, 1048, 780, 862, 317, 278, 0, 333, 7, 0, 0, 88, 187, "NULL", 0, 0, 0, "LAST_HIT", 0, 0, 0, "balanced"),
(25158, 25158, "King Tarlk", 0, "Raid Boss", 0, "Monster.king_bugbear_200_bi", 45, 126, 48, "male", "L2RaidBoss", 40, 920790, 1722, 504.06, 7.7, 60, 57, 73, 76, 70, 80, 2448691, 283783, 2574, 2094, 2776, 850, 278, 0, 3819, 160, 0, 0, 89, 275, "NULL", 0, 0, 0, "LAST_HIT", 0, 0, 0, "balanced"),
(25159, 25159, "Paniel the Unicorn", 0, "Raid Boss", 0, "Monster.unicorn", 14, 30, 54, "male", "L2RaidBoss", 40, 435256, 1975, 312.26, 7.7, 60, 57, 73, 76, 70, 80, 1983647, 381736, 1898, 2504, 823, 1017, 278, 0, 3819, 0, 0, 0, 74, 275, "NULL", 0, 0, 0, "LAST_HIT", 0, 0, 0, "balanced"),
(25160, 25160, "Rapini the Unicorn", 0, "Raid Fighter", 0, "Monster.unicorn_boxer", 11, 18, 53, "male", "L2Minion", 40, 44492, 955, 81.13, 7.7, 40, 43, 30, 41, 20, 10, 0, 0, 1736, 1216, 740, 494, 278, 0, 333, 0, 0, 0, 29, 187, "NULL", 0, 0, 0, "LAST_HIT", 0, 0, 0, "fighter"),
(25161, 25161, "Ririf the Unicorn", 0, "Raid Fighter", 0, "Monster.unicorn_mirage", 13, 17, 53, "male", "L2Minion", 40, 22246, 955, 81.13, 7.7, 40, 43, 30, 41, 20, 10, 0, 0, 1736, 1216, 740, 494, 278, 0, 333, 0, 0, 0, 29, 187, "NULL", 0, 0, 0, "LAST_HIT", 0, 0, 0, "fighter"),
(25162, 25162, "Giant Marpanak", 0, "Raid Boss", 0, "Monster.lesser_giant_100_bi", 42, 91, 60, "male", "L2RaidBoss", 40, 1461912, 2368, 652.22, 8.75, 60, 57, 73, 76, 70, 80, 3123036, 491139, 7025, 2951, 11841, 1198, 278, 0, 3819, 3937, 0, 0, 24, 291, "NULL", 0, 0, 0, "LAST_HIT", 0, 0, 0, "balanced"),
(25163, 25163, "Roaring Skylancer", 0, "Raid Boss", 0, "Monster3.Drake_Raid", 30, 50, 70, "male", "L2RaidBoss", 40, 888658, 3058, 844.9, 9.81, 60, 57, 73, 76, 70, 80, 1915900, 918808, 6981, 3764, 8986, 1528, 278, 0, 3819, 0, 0, 0, 113, 275, "NULL", 0, 0, 12, "LAST_HIT", 0, 0, 0, "balanced"),
(25166, 25166, "Ikuntai", 0, "Raid Boss", 0, "Monster.skeleton_knight_50_bi", 15, 39, 25, "male", "L2RaidBoss", 40, 134813, 606, 237.19, 4.73, 60, 57, 73, 76, 70, 80, 1278325, 108133, 133, 928, 31, 377, 278, 0, 3819, 150, 0, 0, 64, 275, "NULL", 0, 1, 0, "LAST_HIT", 0, 0, 0, "balanced"),
(25167, 25167, "Ikuntai's Servitor", 0, "Raid Fighter", 0, "Monster.silhouette", 8, 23, 24, "female", "L2Minion", 40, 13786, 287, 60.47, 4.73, 40, 43, 30, 41, 20, 10, 0, 0, 121, 446, 28, 181, 278, 0, 333, 0, 0, 0, 88, 187, "NULL", 0, 0, 0, "LAST_HIT", 0, 0, 0, "fighter"),
(25168, 25168, "Pawn of Ikuntai", 0, "Raid Fighter", 0, "Monster.skeleton_pikeman", 10, 28, 24, "male", "L2Minion", 40, 6893, 287, 60.47, 4.73, 40, 43, 30, 41, 20, 10, 0, 0, 121, 446, 28, 181, 278, 0, 333, 299, 0, 0, 55, 187, "NULL", 0, 1, 0, "LAST_HIT", 0, 0, 0, "fighter"),
(25169, 25169, "Ragraman", 0, "Raid Boss", 0, "Monster.batur_orc_overlord_100_bi", 24, 52, 30, "male", "L2RaidBoss", 40, 336732, 763, 288, 5.72, 60, 57, 73, 76, 70, 80, 1329219, 122342, 412, 1127, 212, 458, 278, 0, 3819, 72, 0, 0, 129, 275, "NULL", 0, 0, 0, "LAST_HIT", 0, 0, 0, "balanced"),
(25170, 25170, "Lizardmen Leader Hellion", 0, "Raid Boss", 0, "Monster.zenta_lizardman_matriarch_50_bi", 30, 63, 38, "male", "L2RaidBoss", 40, 195371, 1028, 204.16, 5.72, 60, 57, 73, 76, 70, 80, 1064286, 131051, 251, 1508, 36, 612, 278, 0, 3819, 223, 0, 0, 85, 275, "NULL", 0, 0, 0, "LAST_HIT", 0, 0, 0, "balanced"),
(25171, 25171, "Hellion's Archers", 0, "Raid Fighter", 0, "Monster.zenta_lizardman_scout", 11, 30, 37, "male", "L2Minion", 500, 13142, 497, 52.5, 5.72, 40, 43, 30, 41, 20, 10, 0, 0, 686, 728, 60, 295, 249, 0, 333, 278, 0, 0, 40, 187, "NULL", 0, 0, 0, "LAST_HIT", 0, 0, 0, "fighter"),
(25172, 25172, "Hellion's Guards", 0, "Raid Fighter", 0, "Monster.zenta_lizardman_warrior", 13, 35, 37, "male", "L2Minion", 40, 9807, 497, 52.5, 5.72, 40, 43, 30, 41, 20, 10, 0, 0, 231, 728, 34, 295, 278, 0, 333, 291, 0, 0, 44, 187, "NULL", 0, 0, 0, "LAST_HIT", 0, 0, 0, "fighter"),
(25173, 25173, "Tiger King Karuta", 0, "Raid Boss", 0, "Monster.saber_toothed_tiger_200_bi", 72, 87, 45, "male", "L2RaidBoss", 40, 288415, 1415, 250.9, 6.74, 60, 57, 73, 76, 70, 80, 1591877, 230991, 801, 1905, 231, 774, 278, 0, 3819, 0, 0, 0, 97, 275, "NULL", 0, 0, 0, "LAST_HIT", 0, 0, 0, "balanced"),
(25174, 25174, "Karuta's Follower", 0, "Raid Fighter", 0, "Monster.heltor_silenos_chieftain", 13, 31.5, 44, "male", "L2Minion", 40, 29037, 677, 64.81, 6.74, 40, 43, 30, 41, 20, 10, 0, 0, 725, 922, 205, 374, 278, 0, 333, 127, 0, 0, 29, 187, "NULL", 0, 0, 0, "LAST_HIT", 0, 0, 0, "fighter"),
(25175, 25175, "Karuta's Inferiors", 0, "Raid Fighter", 0, "Monster.crimson_bear", 19, 36, 44, "male", "L2Minion", 40, 14518, 677, 64.81, 6.74, 40, 43, 30, 41, 20, 10, 0, 0, 725, 922, 205, 374, 278, 0, 333, 0, 0, 0, 40, 187, "NULL", 0, 0, 0, "LAST_HIT", 0, 0, 0, "fighter"),
(25176, 25176, "Black Lily", 0, "Raid Boss", 0, "Monster3.Succubus_Raid", 28, 34, 55, "female", "L2RaidBoss", 40, 451391, 2039, 318.92, 7.7, 60, 57, 73, 76, 70, 80, 1707842, 285150, 1364, 2576, 435, 1046, 278, 0, 3819, 0, 0, 0, 129, 275, "NULL", 0, 0, 0, "LAST_HIT", 0, 0, 0, "balanced"),
(25177, 25177, "Guardian Knight of Black Lily", 0, "Raid Fighter", 0, "Monster.death_knight", 12, 31, 54, "male", "L2Minion", 40, 46232, 987, 82.92, 7.7, 40, 43, 30, 41, 20, 10, 0, 0, 2514, 1252, 1586, 508, 278, 0, 333, 75, 0, 0, 29, 187, "NULL", 0, 1, 0, "LAST_HIT", 0, 0, 0, "fighter"),
(25178, 25178, "Servitor of Black Lily", 0, "Raid Fighter", 0, "Monster.silhouette", 8, 23, 54, "female", "L2Minion", 40, 23116, 987, 82.92, 7.7, 40, 43, 30, 41, 20, 10, 0, 0, 1257, 1252, 396, 508, 278, 0, 333, 0, 0, 0, 88, 187, "NULL", 0, 0, 0, "LAST_HIT", 0, 0, 0, "fighter"),
(25179, 25179, "Guardian of the Statue of Giant Karum", 0, "Raid Boss", 0, "Monster.lesser_giant_shooter_50_bi", 31.5, 69, 60, "male", "L2RaidBoss", 40, 526218, 2368, 351.19, 8.75, 60, 57, 73, 76, 70, 80, 2091330, 424759, 2895, 2951, 1474, 1198, 278, 0, 3819, 3937, 0, 0, 24, 291, "NULL", 0, 0, 0, "LAST_HIT", 0, 0, 0, "balanced"),
(25180, 25180, "Karum's Guard", 0, "Raid Fighter", 0, "Monster.lesser_giant_mage", 21, 44, 59, "male", "L2Minion", 40, 36451, 1150, 91.59, 7.7, 40, 43, 30, 41, 20, 10, 0, 0, 3509, 1437, 2314, 583, 278, 0, 333, 3938, 0, 0, 16, 198, "NULL", 0, 0, 0, "LAST_HIT", 0, 0, 0, "mage"),
(25181, 25181, "Karum's Warrior", 0, "Raid Fighter", 0, "Monster.susceptor", 20, 35, 59, "male", "L2Minion", 40, 54404, 1150, 91.59, 7.7, 40, 43, 30, 41, 20, 10, 0, 0, 5263, 1437, 5208, 583, 278, 0, 333, 0, 0, 0, 29, 187, "NULL", 0, 0, 0, "LAST_HIT", 0, 0, 0, "balanced"),
(25182, 25182, "Demon Kurikups", 0, "Raid Boss", 0, "Monster.karik_100_bi", 50, 180, 59, "male", "L2RaidBoss", 40, 512194, 2707, 362.57, 8.75, 60, 57, 73, 76, 70, 80, 2460640, 581209, 3838, 3349, 2140, 1360, 278, 0, 3819, 0, 0, 0, 59, 324, "NULL", 0, 0, 0, "LAST_HIT", 0, 0, 0, "balanced"),
(25183, 25183, "Kurikups' Wife", 0, "Raid Fighter", 0, "Monster.bloody_queen", 14, 40, 58, "female", "L2Minion", 40, 13187, 1319, 95.76, 8.75, 40, 43, 30, 41, 20, 10, 0, 0, 3661, 1634, 2071, 663, 278, 0, 333, 0, 0, 0, 88, 187, "NULL", 0, 0, 0, "LAST_HIT", 0, 0, 0, "fighter"),
(25184, 25184, "Devil Blader of Chaos", 0, "Raid Fighter", 0, "Monster.death_blader", 15, 45, 58, "male", "L2Minion", 40, 6593, 1319, 95.76, 8.75, 40, 43, 30, 41, 20, 10, 0, 0, 3661, 1634, 2071, 663, 278, 0, 333, 1472, 0, 0, 110, 187, "NULL", 0, 1, 0, "LAST_HIT", 0, 0, 0, "fighter"),
(25185, 25185, "Tasaba Patriarch Hellena", 0, "Raid Boss", 0, "Monster.zenta_lizardman_matriarch", 20, 40, 35, "male", "L2RaidBoss", 40, 165289, 927, 185.07, 5.72, 60, 57, 73, 76, 70, 80, 1193687, 138419, 300, 1356, 59, 550, 278, 0, 3819, 225, 0, 0, 85, 275, "NULL", 0, 0, 0, "LAST_HIT", 0, 0, 0, "balanced"),
(25186, 25186, "Hellena's Marksman", 0, "Raid Fighter", 0, "Monster.zenta_lizardman_scout", 11, 30, 34, "male", "L2Minion", 500, 11143, 446, 47.49, 5.72, 40, 43, 30, 41, 20, 10, 0, 0, 821, 654, 97, 265, 249, 0, 333, 272, 0, 0, 40, 187, "NULL", 0, 0, 0, "LAST_HIT", 0, 0, 0, "fighter"),
(25187, 25187, "Helena's Soldier", 0, "Raid Fighter", 0, "Monster.zenta_lizardman_warrior", 13, 35, 34, "male", "L2Minion", 40, 8316, 446, 47.49, 5.72, 40, 43, 30, 41, 20, 10, 0, 0, 277, 654, 55, 265, 278, 0, 333, 16, 0, 0, 44, 187, "NULL", 0, 0, 0, "LAST_HIT", 0, 0, 0, "fighter"),
(25188, 25188, "Apepi", 0, "Raid Boss", 0, "Mo