-- --------------------------
-- Table structure for weapon
-- --------------------------
DROP TABLE IF EXISTS `weapon`;
CREATE TABLE `weapon` (
  `item_id` decimal(11,0) NOT NULL default '0',
  `name` varchar(70) default NULL,
  `bodypart` varchar(15) default NULL,
  `crystallizable` varchar(5) default NULL,
  `weight` decimal(4,0) default NULL,
  `soulshots` decimal(2,0) default NULL,
  `spiritshots` decimal(1,0) default NULL,
  `material` varchar(11) default NULL,
  `crystal_type` varchar(4) default NULL,
  `p_dam` decimal(5,0) default NULL,
  `rnd_dam` decimal(2,0) default NULL,
  `weaponType` varchar(8) default NULL,
  `critical` decimal(2,0) default NULL,
  `hit_modify` decimal(6,5) default NULL,
  `avoid_modify` decimal(2,0) default NULL,
  `shield_def` decimal(3,0) default NULL,
  `shield_def_rate` decimal(2,0) default NULL,
  `atk_speed` decimal(3,0) default NULL,
  `mp_consume` decimal(2,0) default NULL,
  `m_dam` decimal(3,0) default NULL,
  `duration` decimal(3,0) default NULL,
  `price` decimal(11,0) default NULL,
  `crystal_count` int(4) default NULL,
  `sellable` varchar(5) NOT NULL default 'true',
  `dropable` varchar(5) NOT NULL default 'true',
  `destroyable` varchar(5) NOT NULL default 'true',
  `tradeable` varchar(5) NOT NULL default 'true',
  `enchant4_skill_id` decimal(11,0) NOT NULL default '0',
  `enchant4_skill_lvl` decimal(11,0) NOT NULL default '0',
  `onCast_skill_id` decimal(11,0) NOT NULL default '0',
  `onCast_skill_lvl` decimal(11,0) NOT NULL default '0',
  `onCast_skill_chance` decimal(11,0) NOT NULL default '0',
  `onCrit_skill_id` decimal(11,0) NOT NULL default '0',
  `onCrit_skill_lvl` decimal(11,0) NOT NULL default '0',
  `onCrit_skill_chance` decimal(11,0) NOT NULL default '0',
  `change_weaponId` decimal(11,0) NOT NULL default '0',
  `skill` varchar(70) default '0-0;',
  PRIMARY KEY (`item_id`)
) DEFAULT CHARSET=utf8;
-- ------------------------
-- Records for table weapon
-- ------------------------

INSERT INTO `weapon` VALUES
(1,'Short Sword','rhand','false',1600,1,1,'steel','none',8,10,'sword',8,0.00000,0,0,0,379,0,6,-1,768,0,'true','true','true','true',0,0,0,0,0,0,0,0,0,'0-0;'),
(2,'Long Sword','rhand','false',1560,2,2,'fine_steel','none',24,10,'sword',8,0.00000,0,0,0,379,0,17,-1,136000,0,'true','true','true','true',0,0,0,0,0,0,0,0,0,'0-0;'),
(3,'Broadsword','rhand','false',1590,1,1,'steel','none',11,10,'sword',8,0.00000,0,0,0,379,0,9,-1,12500,0,'true','true','true','true',0,0,0,0,0,0,0,0,0,'0-0;'),
(4,'Club','rhand','false',1870,1,1,'wood','none',8,20,'blunt',4,4.00000,0,0,0,379,0,6,-1,768,0,'true','true','true','true',0,0,0,0,0,0,0,0,0,'0-0;'),
(5,'Mace','rhand','false',1880,1,1,'steel','none',11,20,'blunt',4,4.00000,0,0,0,379,0,9,-1,12500,0,'true','true','true','true',0,0,0,0,0,0,0,0,0,'0-0;'),
(6,'Apprentice''s Wand','rhand','false',1350,1,1,'steel','none',5,20,'blunt',4,4.00000,0,0,0,379,0,7,-1,138,0,'false','false','true','false',0,0,0,0,0,0,0,0,0,'0-0;'),
(7,'Apprentice''s Rod','rhand','false',1330,1,1,'wood','none',6,20,'blunt',4,4.00000,0,0,0,379,0,8,-1,768,0,'true','true','true','true',0,0,0,0,0,0,0,0,0,'0-0;'),
(8,'Willow Staff','lrhand','false',1080,1,1,'wood','none',11,20,'bigblunt',4,4.00000,0,0,0,325,0,12,-1,12500,0,'true','true','true','true',0,0,0,0,0,0,0,0,0,'0-0;'),
(9,'Cedar Staff','lrhand','false',1090,2,2,'wood','none',16,20,'bigblunt',4,4.00000,0,0,0,325,0,16,-1,54100,0,'true','true','true','true',0,0,0,0,0,0,0,0,0,'0-0;'),
(10,'Dagger','rhand','false',1160,1,1,'steel','none',5,5,'dagger',12,-3.00000,0,0,0,433,0,5,-1,138,0,'false','false','true','false',0,0,0,0,0,0,0,0,0,'0-0;'),
(11,'Bone Dagger','rhand','false',1150,1,1,'bone','none',7,5,'dagger',12,-3.00000,0,0,0,433,0,6,-1,768,0,'true','true','true','true',0,0,0,0,0,0,0,0,0,'0-0;'),
(12,'Knife','rhand','false',1140,1,1,'bronze','none',10,5,'dagger',12,-3.00000,0,0,0,433,0,9,-1,12500,0,'true','true','true','true',0,0,0,0,0,0,0,0,0,'0-0;'),
(13,'Short Bow','lrhand','false',1950,1,1,'wood','none',16,5,'bow',12,-3.00000,0,0,0,293,1,6,-1,768,0,'true','true','true','true',0,0,0,0,0,0,0,0,0,'0-0;'),
(14,'Bow','lrhand','false',1930,1,1,'wood','none',23,5,'bow',12,-3.00000,0,0,0,293,1,9,-1,12500,0,'true','true','true','true',0,0,0,0,0,0,0,0,0,'0-0;'),
(15,'Short Spear','lrhand','false',2140,2,2,'steel','none',24,10,'pole',8,-3.00000,0,0,0,325,0,17,-1,136000,0,'true','true','true','true',0,0,0,0,0,0,0,0,0,'0-0;'),
(16,'Great Spear','lrhand','false',2120,2,2,'bronze','none',31,10,'pole',8,-3.00000,0,0,0,325,0,21,-1,244000,0,'true','true','true','true',0,0,0,0,0,0,0,0,0,'0-0;'),
(18,'Leather Shield','lhand','false',1430,0,0,'leather','none',0,0,'none',0,0.00000,-8,47,20,0,0,0,-1,39,0,'true','true','true','true',0,0,0,0,0,0,0,0,0,'0-0;'),
(19,'Small Shield','lhand','false',1420,0,0,'steel','none',0,0,'none',0,0.00000,-8,56,20,0,0,0,-1,638,0,'true','true','true','true',0,0,0,0,0,0,0,0,0,'0-0;'),
(20,'Buckler','lhand','false',1410,0,0,'wood','none',0,0,'none',0,0.00000,-8,67,20,0,0,0,-1,2780,0,'true','true','true','true',0,0,0,0,0,0,0,0,0,'0-0;'),
(66,'Gladius','rhand','false',1570,2,2,'steel','none',17,10,'sword',8,0.00000,0,0,0,379,0,12,-1,54100,0,'true','true','true','true',0,0,0,0,0,0,0,0,0,'0-0;'),
(67,'Orcish Sword','rhand','false',1570,2,2,'steel','none',17,10,'sword',8,0.00000,0,0,0,379,0,12,-1,54100,0,'true','true','true','true',0,0,0,0,0,0,0,0,0,'0-0;'),
(68,'Falchion','rhand','false',1530,2,2,'bronze','none',31,10,'sword',8,0.00000,0,0,0,379,0,21,-1,244000,0,'true','true','true','true',0,0,0,0,0,0,0,0,0,'0-0;'),
(69,'Bastard Sword','rhand','true',1510,2,2,'fine_steel','d',51,10,'sword',8,0.00000,0,0,0,379,0,32,-1,644000,1170,'true','true','true','true',0,0,0,0,0,0,0,0,9213,'0-0;'),
(70,'Claymore','lrhand','true',2090,3,3,'fine_steel','d',112,10,'bigsword',8,0.00000,0,0,0,325,0,54,-1,1800000,3272,'true','true','true','true',0,0,0,0,0,0,0,0,9226,'0-0;'),
(71,'Flamberge','lrhand','true',2010,2,2,'bronze','c',130,10,'bigsword',8,0.00000,0,0,0,325,0,61,-1,2290000,916,'true','true','true','true',0,0,0,0,0,0,0,0,9232,'0-0;'),
(72,'Stormbringer','rhand','true',1430,2,2,'fine_steel','c',107,10,'sword',8,0.00000,0,0,0,379,0,61,-1,2290000,916,'true','true','true','true',0,0,0,0,0,0,0,0,9228,'0-0;'),
(73,'Shamshir','rhand','true',1420,2,2,'fine_steel','c',122,10,'sword',8,0.00000,0,0,0,379,0,68,-1,2870000,1148,'true','true','true','true',0,0,0,0,0,0,0,0,9240,'0-0;'),
(74,'Katana','rhand','true',1420,2,2,'fine_steel','c',122,10,'sword',8,0.00000,0,0,0,379,0,68,-1,2870000,1148,'true','true','true','true',0,0,0,0,0,0,0,0,9244,'0-0;'),
(75,'Caliburs','rhand','true',1400,3,3,'oriharukon','c',139,10,'sword',8,0.00000,0,0,0,379,0,76,-1,4300000,1720,'true','true','true','true',0,0,0,0,0,0,0,0,9264,'0-0;'),
(76,'Sword of Delusion','rhand','true',1400,3,3,'mithril','c',139,10,'sword',8,0.00000,0,0,0,379,0,76,-1,4300000,1720,'true','true','true','true',0,0,0,0,0,0,0,0,9268,'0-0;'),
(77,'Tsurugi','rhand','true',1400,3,3,'fine_steel','c',139,10,'sword',8,0.00000,0,0,0,379,0,76,-1,4300000,1720,'true','true','true','true',0,0,0,0,0,0,0,0,9272,'0-0;'),
(78,'Great Sword','lrhand','true',1930,1,1,'steel','b',213,10,'bigsword',8,0.00000,0,0,0,325,0,91,-1,8680000,1157,'true','true','true','true',0,0,0,0,0,0,0,0,9308,'0-0;'),
(79,'Sword of Damascus','rhand','true',1350,1,1,'damascus','b',194,10,'sword',8,0.00000,0,0,0,379,0,99,-1,13100000,1746,'true','true','true','true',0,0,0,0,0,0,0,0,9316,'0-0;'),
(80,'Tallum Blade','rhand','true',1330,1,1,'adamantaite','a',213,10,'sword',8,0.00000,0,0,0,379,0,107,-1,18300000,1464,'true','true','true','true',0,0,0,0,0,0,0,0,9328,'0-0;'),
(81,'Dragon Slayer','lrhand','true',1840,1,1,'bone','a',282,10,'bigsword',8,0.00000,0,0,0,325,0,114,-1,27000000,2160,'true','true','true','true',0,0,0,0,0,0,0,0,9344,'0-0;'),
(82,'God''s Blade','rhand','true',1300,1,1,'adamantaite','s',257,10,'sword',8,0.00000,0,0,0,379,0,124,-1,38000000,1900,'false','false','true','false',0,0,0,0,0,0,0,0,0,'0-0;'),
(83,'Sword of Magic','rhand','true',970,2,2,'bronze','d',43,10,'sword',8,0.00000,0,0,0,379,0,45,-1,716000,1301,'true','true','true','true',0,0,0,0,0,0,0,0,0,'0-0;'),
(84,'Homunkulus''s Sword','rhand','true',950,3,3,'blood_steel','c',111,10,'sword',8,0.00000,0,0,0,379,0,101,-1,4300000,1720,'true','true','true','true',0,0,0,0,0,0,0,0,0,'0-0;'),
(85,'Phantom Sword','rhand','true',860,1,1,'oriharukon','a',170,10,'sword',8,0.00000,0,0,0,379,0,143,-1,18300000,1464,'true','true','true','true',0,0,0,0,0,0,0,0,0,'0-0;'),
(86,'Tomahawk','rhand','true',1780,2,2,'bronze','d',51,20,'blunt',4,4.00000,0,0,0,379,0,32,-1,644000,1170,'true','true','true','true',0,0,0,0,0,0,0,0,0,'0-0;'),
(87,'Iron Hammer','rhand','false',1850,2,2,'steel','none',31,20,'blunt',4,4.00000,0,0,0,379,0,21,-1,244000,0,'true','true','true','true',0,0,0,0,0,0,0,0,0,'0-0;'),
(88,'Morning Star','rhand','true',1720,3,3,'steel','d',79,20,'blunt',4,4.00000,0,0,0,379,0,47,-1,1400000,2545,'true','true','true','true',0,0,0,0,0,0,0,0,0,'0-0;'),
(89,'Big Hammer','rhand','true',1710,2,2,'fine_steel','c',107,20,'blunt',4,4.00000,0,0,0,379,0,61,-1,2290000,916,'true','true','true','true',0,0,0,0,0,0,0,0,0,'0-0;'),
(90,'Goat Head Staff','lrhand','true',1000,3,3,'wood','d',77,20,'bigblunt',4,4.00000,0,0,0,325,0,63,-1,1400000,2545,'true','true','true','true',0,0,0,0,0,0,0,0,0,'0-0;'),
(91,'Heavy War Axe','rhand','true',1620,1,1,'fine_steel','b',175,20,'blunt',4,4.00000,0,0,0,379,0,91,-1,8680000,1157,'true','true','true','true',0,0,0,0,0,0,0,0,0,'0-0;'),
(92,'Sprite''s Staff','lrhand','true',960,1,1,'wood','b',170,20,'bigblunt',4,4.00000,0,0,0,325,0,122,-1,8680000,1157,'true','true','true','true',0,0,0,0,0,0,0,0,0,'0-0;'),
(93,'Winged Spear','lrhand','true',2060,3,3,'fine_steel','d',79,10,'pole',8,-3.00000,0,0,0,325,0,47,-1,1400000,2545,'true','true','true','true',0,0,0,0,0,0,0,0,0,'0-0;'),
(94,'Bec de Corbin','lrhand','true',2020,2,2,'fine_steel','c',122,10,'pole',8,-3.00000,0,0,0,325,0,68,-1,2870000,1148,'true','true','true','true',0,0,0,0,0,0,0,0,0,'0-0;'),
(95,'Poleaxe','lrhand','true',2010,3,3,'bronze','c',139,10,'pole',8,-3.00000,0,0,0,325,0,76,-1,4300000,1720,'true','true','true','true',0,0,0,0,0,0,0,0,0,'0-0;'),
(96,'Scythe','lrhand','true',2040,2,2,'fine_steel','c',107,10,'pole',8,-3.00000,0,0,0,325,0,61,-1,2290000,916,'true','true','true','true',0,0,0,0,0,0,0,0,0,'0-0;'),
(97,'Lance','lrhand','true',1920,1,1,'blood_steel','b',194,10,'pole',8,-3.00000,0,0,0,325,0,99,-1,13100000,1746,'true','true','true','true',0,0,0,0,0,0,0,0,0,'0-0;'),
(98,'Halberd','lrhand','true',1900,1,1,'oriharukon','a',213,10,'pole',8,-3.00000,0,0,0,325,0,107,-1,18300000,1464,'true','true','true','true',0,0,0,0,0,0,0,0,0,'0-0;'),
(99,'Apprentice''s Spellbook','rhand','false',650,1,1,'paper','none',9,10,'etc',8,0.00000,0,0,0,379,0,12,-1,12500,0,'true','true','true','true',0,0,0,0,0,0,0,0,0,'0-0;'),
(100,'Voodoo Doll','rhand','false',630,2,2,'wood','none',25,10,'etc',8,0.00000,0,0,0,379,0,28,-1,244000,0,'true','true','true','true',0,0,0,0,0,0,0,0,0,'0-0;'),
(101,'Scroll of Wisdom','rhand','true',610,2,2,'paper','d',32,10,'etc',8,0.00000,0,0,0,379,0,35,-1,409000,743,'true','true','true','true',0,0,0,0,0,0,0,0,0,'0-0;'),
(102,'Round Shield','lhand','false',1390,0,0,'steel','none',0,0,'none',0,0.00000,-8,79,20,0,0,0,-1,7110,0,'true','true','true','true',0,0,0,0,0,0,0,0,0,'0-0;'),
(103,'Tower Shield','lhand','true',1240,0,0,'fine_steel','c',0,0,'none',0,0.00000,-8,190,20,0,0,0,-1,258000,103,'true','true','true','true',0,0,0,0,0,0,0,0,0,'0-0;'),
(104,'Shield of Victory','lhand','true',6400,0,0,'oriharukon','b',0,0,'none',0,0.00000,-8,216,20,0,0,0,-1,545000,72,'true','true','true','true',0,0,0,0,0,0,0,0,0,'0-0;'),
(105,'Implosion Shield','lhand','true',4800,0,0,'damascus','b',0,0,'none',0,0.00000,-8,216,20,0,0,0,-1,545000,72,'true','true','true','true',0,0,0,0,0,0,0,0,0,'0-0;'),
(106,'Dark Dragon Shield','lhand','true',4800,0,0,'damascus','b',0,0,'none',0,0.00000,-8,230,20,0,0,0,-1,845000,112,'true','true','true','true',0,0,0,0,0,0,0,0,0,'0-0;'),
(107,'Composite Shield','lhand','true',1230,0,0,'fine_steel','c',0,0,'none',0,0.00000,-8,190,20,0,0,0,-1,258000,103,'true','true','true','true',0,0,0,0,0,0,0,0,0,'0-0;'),
(108,'Masterpiece Shield','lhand','true',5600,0,0,'oriharukon','b',0,0,'none',0,0.00000,-8,230,20,0,0,0,-1,845000,112,'true','true','true','true',0,0,0,0,0,0,0,0,0,'0-0;'),
(109,'Shield of Solar Eclipse','lhand','true',4800,0,0,'blood_steel','b',0,0,'none',0,0.00000,-8,216,20,0,0,0,-1,545000,72,'true','true','true','true',0,0,0,0,0,0,0,0,0,'0-0;'),
(110,'Doom Shield','lhand','true',1200,0,0,'fine_steel','b',0,0,'none',0,0.00000,-8,230,20,0,0,0,-1,845000,112,'true','true','true','true',0,0,0,0,0,0,0,0,0,'0-0;'),
(111,'Shield of Pledge','lhand','true',4800,0,0,'fine_steel','b',0,0,'none',0,0.00000,-8,216,20,0,0,0,-1,545000,72,'true','true','true','true',0,0,0,0,0,0,0,0,0,'0-0;'),
(120,'Sword of Reflection','rhand','false',1550,2,2,'bronze','none',24,10,'sword',8,0.00000,0,0,0,379,0,17,-1,136000,0,'true','true','true','true',0,0,0,0,0,0,0,0,0,'0-0;'),
(121,'Sword of Watershadow','rhand','false',1540,2,2,'bronze','none',24,10,'sword',8,0.00000,0,0,0,379,0,17,-1,136000,0,'true','true','true','true',0,0,0,0,0,0,0,0,0,'0-0;'),
(122,'Handmade Sword','rhand','false',1570,2,2,'bronze','none',17,10,'sword',8,0.00000,0,0,0,379,0,12,-1,54100,0,'true','true','true','true',0,0,0,0,0,0,0,0,0,'0-0;'),
(123,'Saber','rhand','true',1520,2,2,'steel','d',40,10,'sword',8,0.00000,0,0,0,379,0,26,-1,409000,743,'true','true','true','true',0,0,0,0,0,0,0,0,9216,'0-0;'),
(124,'Two-Handed Sword','lrhand','true',2180,2,2,'fine_steel','d',78,10,'bigsword',8,0.00000,0,0,0,325,0,39,-1,967000,1758,'true','true','true','true',0,0,0,0,0,0,0,0,9220,'0-0;'),
(125,'Spinebone Sword','rhand','true',1510,2,2,'bone','d',51,10,'sword',8,0.00000,0,0,0,379,0,32,-1,644000,1170,'true','true','true','true',0,0,0,0,0,0,0,0,9214,'0-0;'),
(126,'Artisan''s Sword','rhand','true',1500,2,2,'steel','d',51,10,'sword',8,0.00000,0,0,0,379,0,32,-1,644000,1170,'true','true','true','true',0,0,0,0,0,0,0,0,9215,'0-0;'),
(127,'Crimson Sword','rhand','true',1490,2,2,'fine_steel','d',64,10,'sword',8,0.00000,0,0,0,379,0,39,-1,967000,1758,'true','true','true','true',0,0,0,0,0,0,0,0,9218,'0-0;'),
(128,'Knight''s Sword','rhand','true',1500,2,2,'steel','d',51,10,'sword',8,0.00000,0,0,0,379,0,32,-1,644000,1170,'true','true','true','true',0,0,0,0,0,0,0,0,0,'0-0;'),
(129,'Sword of Revolution','rhand','true',1450,3,3,'fine_steel','d',79,10,'sword',8,0.00000,0,0,0,379,0,47,-1,1400000,2545,'true','true','true','true',0,0,0,0,0,0,0,0,9222,'0-0;'),
(130,'Elven Sword','rhand','true',1470,2,2,'mithril','d',64,10,'sword',8,0.00000,0,0,0,379,0,39,-1,967000,1758,'true','true','true','true',0,0,0,0,0,0,0,0,9219,'0-0;'),
(131,'Spirit Sword','rhand','true',1420,2,2,'fine_steel','c',122,10,'sword',8,0.00000,0,0,0,379,0,68,-1,2870000,1148,'true','true','true','true',0,0,0,0,0,0,0,0,9248,'0-0;'),
(132,'Sword of Limit','rhand','true',1400,3,3,'fine_steel','c',139,10,'sword',8,0.00000,0,0,0,379,0,76,-1,4300000,1720,'true','true','true','true',0,0,0,0,0,0,0,0,9280,'0-0;'),
(133,'Raid Sword','rhand','true',1420,2,2,'fine_steel','c',122,10,'sword',8,0.00000,0,0,0,379,0,68,-1,2870000,1148,'true','true','true','true',0,0,0,0,0,0,0,0,9252,'0-0;'),
(134,'Sword of Nightmare','rhand','true',1400,3,3,'blood_steel','c',139,10,'sword',8,0.00000,0,0,0,379,0,76,-1,4300000,1720,'true','true','true','true',0,0,0,0,0,0,0,0,9276,'0-0;'),
(135,'Samurai Longsword','rhand','true',1380,3,3,'oriharukon','c',156,10,'sword',8,0.00000,0,0,0,379,0,83,-1,6130000,2452,'true','true','true','true',0,0,0,0,0,0,0,0,9292,'0-0;'),
(136,'Blade of Serenity','rhand','true',1370,1,1,'mithril','b',175,10,'sword',8,0.00000,0,0,0,379,0,91,-1,8680000,1157,'true','true','true','true',0,0,0,0,0,0,0,0,0,'0-0;'),
(137,'Mist Sword','rhand','true',1370,1,1,'mithril','b',175,10,'sword',8,0.00000,0,0,0,379,0,91,-1,8680000,1157,'true','true','true','true',0,0,0,0,0,0,0,0,0,'0-0;'),
(138,'Sword of Desert','rhand','true',1370,1,1,'blood_steel','b',175,10,'sword',8,0.00000,0,0,0,379,0,91,-1,8680000,1157,'true','true','true','true',0,0,0,0,0,0,0,0,0,'0-0;'),
(139,'Dusk Sword','rhand','true',1370,1,1,'blood_steel','b',175,10,'sword',8,0.00000,0,0,0,379,0,91,-1,8680000,1157,'true','true','true','true',0,0,0,0,0,0,0,0,0,'0-0;'),
(140,'Eminence Sword','rhand','true',1370,1,1,'chrysolite','b',175,10,'sword',8,0.00000,0,0,0,379,0,91,-1,8680000,1157,'true','true','true','true',0,0,0,0,0,0,0,0,0,'0-0;'),
(141,'Hazard Sword','rhand','true',1370,1,1,'blood_steel','b',175,10,'sword',8,0.00000,0,0,0,379,0,91,-1,8680000,1157,'true','true','true','true',0,0,0,0,0,0,0,0,0,'0-0;'),
(142,'Keshanberk','rhand','true',1370,1,1,'oriharukon','b',175,10,'sword',8,0.00000,0,0,0,379,0,91,-1,8680000,1157,'true','true','true','true',0,0,0,0,0,0,0,0,9304,'0-0;'),
(143,'Sword of Mystic','rhand','true',980,2,2,'fine_steel','d',43,10,'sword',8,0.00000,0,0,0,379,0,45,-1,716000,1301,'true','true','true','true',0,0,0,0,0,0,0,0,0,'0-0;'),
(144,'Sword of Occult','rhand','true',970,2,2,'fine_steel','d',43,10,'sword',8,0.00000,0,0,0,379,0,45,-1,716000,1301,'true','true','true','true',0,0,0,0,0,0,0,0,0,'0-0;'),
(145,'Sword of Whispering Death','rhand','true',920,3,3,'fine_steel','c',111,10,'sword',8,0.00000,0,0,0,379,0,101,-1,4300000,1720,'true','true','true','true',0,0,0,0,0,0,0,0,0,'0-0;'),
(146,'Ghoulbane','rhand','true',910,1,1,'damascus','b',140,10,'sword',8,0.00000,0,0,0,379,0,122,-1,8680000,1157,'true','true','true','true',0,0,0,0,0,0,0,0,0,'0-0;'),
(147,'Tear of Darkness','rhand','true',830,1,1,'blood_steel','a',170,10,'sword',8,0.00000,0,0,0,379,0,143,-1,18300000,1464,'true','true','true','true',0,0,0,0,0,0,0,0,0,'0-0;'),
(148,'Sword of Valhalla','rhand','true',900,1,1,'oriharukon','b',140,10,'sword',8,0.00000,0,0,0,379,0,122,-1,8680000,1157,'true','true','true','true',0,0,0,0,0,0,0,0,0,'0-0;'),
(149,'Sword of Life','rhand','true',840,1,1,'mithril','a',170,10,'sword',8,0.00000,0,0,0,379,0,143,-1,18300000,1464,'true','true','true','true',0,0,0,0,0,0,0,0,0,'0-0;'),
(150,'Elemental Sword','rhand','true',830,1,1,'mithril','a',170,10,'sword',8,0.00000,0,0,0,379,0,143,-1,18300000,1464,'true','true','true','true',0,0,0,0,0,0,0,0,0,'0-0;'),
(151,'Sword of Miracles','rhand','true',840,1,1,'adamantaite','a',186,10,'sword',8,0.00000,0,0,0,379,0,152,-1,27000000,2160,'true','true','true','true',0,0,0,0,0,0,0,0,0,'0-0;'),
(152,'Heavy Chisel','rhand','false',1890,1,1,'steel','none',10,20,'blunt',4,4.00000,0,0,0,379,0,8,-1,8070,0,'true','true','true','true',0,0,0,0,0,0,0,0,0,'0-0;'),
(153,'Sickle','rhand','false',1850,1,1,'steel','none',12,20,'blunt',4,4.00000,0,0,0,379,0,9,-1,18500,0,'true','true','true','true',0,0,0,0,0,0,0,0,0,'0-0;'),
(154,'Dwarven Mace','rhand','false',1860,2,2,'bronze','none',17,20,'blunt',4,4.00000,0,0,0,379,0,12,-1,54100,0,'true','true','true','true',0,0,0,0,0,0,0,0,0,'0-0;'),
(155,'Flanged Mace','rhand','false',1800,2,2,'steel','none',31,20,'blunt',4,4.00000,0,0,0,379,0,21,-1,244000,0,'true','true','true','true',0,0,0,0,0,0,0,0,0,'0-0;'),
(156,'Hand Axe','rhand','true',1820,2,2,'steel','d',40,20,'blunt',4,4.00000,0,0,0,379,0,26,-1,409000,743,'true','true','true','true',0,0,0,0,0,0,0,0,0,'0-0;'),
(157,'Spiked Club','rhand','true',1750,2,2,'steel','d',64,20,'blunt',4,4.00000,0,0,0,379,0,39,-1,967000,1758,'true','true','true','true',0,0,0,0,0,0,0,0,0,'0-0;'),
(158,'Tarbar','rhand','true',1730,3,3,'fine_steel','d',79,20,'blunt',4,4.00000,0,0,0,379,0,47,-1,1400000,2545,'true','true','true','true',0,0,0,0,0,0,0,0,0,'0-0;'),
(159,'Bonebreaker','rhand','true',1720,3,3,'fine_steel','d',92,20,'blunt',4,4.00000,0,0,0,379,0,54,-1,1800000,3272,'true','true','true','true',0,0,0,0,0,0,0,0,0,'0-0;'),
(160,'Battle Axe','rhand','true',1720,2,2,'fine_steel','c',107,20,'blunt',4,4.00000,0,0,0,379,0,61,-1,2290000,916,'true','true','true','true',0,0,0,0,0,0,0,0,0,'0-0;'),
(161,'Silver Axe','rhand','true',1690,2,2,'fine_steel','c',107,20,'blunt',4,4.00000,0,0,0,379,0,61,-1,2290000,916,'true','true','true','true',0,0,0,0,0,0,0,0,0,'0-0;'),
(162,'War Axe','rhand','true',1660,3,3,'fine_steel','c',139,20,'blunt',4,4.00000,0,0,0,379,0,76,-1,4300000,1720,'true','true','true','true',0,0,0,0,0,0,0,0,0,'0-0;'),
(163,'NO ITEM NAME','rhand','true',4000,1,1,'mithril','b',175,20,'blunt',4,4.00000,0,0,0,379,0,91,-1,8680000,1157,'true','true','true','true',0,0,0,0,0,0,0,0,0,'0-0;'),
(164,'Elysian','rhand','true',1580,1,1,'oriharukon','a',232,20,'blunt',4,4.00000,0,0,0,379,0,114,-1,27000000,2160,'true','true','true','true',0,0,0,0,0,0,0,0,0,'0-0;'),
(165,'Yablonski''s Hammer','rhand','true',1570,1,1,'adamantaite','s',251,20,'blunt',4,4.00000,0,0,0,379,0,121,-1,35300000,1765,'true','true','true','true',0,0,0,0,0,0,0,0,0,'0-0;'),
(166,'Heavy Mace','rhand','true',1800,2,2,'steel','d',40,20,'blunt',4,4.00000,0,0,0,379,0,26,-1,409000,743,'true','true','true','true',0,0,0,0,0,0,0,0,0,'0-0;'),
(167,'Scalpel','rhand','true',1810,2,2,'steel','d',40,20,'blunt',4,4.00000,0,0,0,379,0,26,-1,409000,743,'true','true','true','true',0,0,0,0,0,0,0,0,0,'0-0;'),
(168,'Work Hammer','rhand','true',1790,2,2,'steel','d',40,20,'blunt',4,4.00000,0,0,0,379,0,26,-1,409000,743,'true','true','true','true',0,0,0,0,0,0,0,0,0,'0-0;'),
(169,'Skull Breaker','rhand','true',1740,3,3,'fine_steel','d',79,20,'blunt',4,4.00000,0,0,0,379,0,47,-1,1400000,2545,'true','true','true','true',0,0,0,0,0,0,0,0,0,'0-0;'),
(170,'NO ITEM NAME','rhand','true',6400,1,1,'fine_steel','a',258,20,'blunt',4,4.00000,0,0,0,379,0,86,-1,16600000,7,'true','true','true','true',0,0,0,0,0,0,0,0,0,'0-0;'),
(171,'Deadman''s Glory','rhand','true',1600,1,1,'bone','b',194,20,'blunt',4,4.00000,0,0,0,379,0,99,-1,13100000,1746,'true','true','true','true',0,0,0,0,0,0,0,0,0,'0-0;'),
(172,'Heavy Bone Club','rhand','true',1730,3,3,'bone','d',79,20,'blunt',4,4.00000,0,0,0,379,0,47,-1,1400000,2545,'true','true','true','true',0,0,0,0,0,0,0,0,0,'0-0;'),
(173,'Skull Graver','rhand','true',1640,2,2,'fine_steel','c',107,20,'blunt',4,4.00000,0,0,0,379,0,61,-1,2290000,916,'true','true','true','true',0,0,0,0,0,0,0,0,0,'0-0;'),
(174,'Nirvana Axe','rhand','true',1150,3,3,'fine_steel','c',111,20,'blunt',4,4.00000,0,0,0,379,0,101,-1,4300000,1720,'true','true','true','true',0,0,0,0,0,0,0,0,0,'0-0;'),
(175,'Art of Battle Axe','rhand','true',1570,1,1,'chrysolite','b',194,20,'blunt',4,4.00000,0,0,0,379,0,99,-1,13100000,1746,'true','true','true','true',0,0,0,0,0,0,0,0,0,'0-0;'),
(176,'Journeyman''s Staff','lrhand','false',1070,2,2,'wood','none',23,20,'bigblunt',4,4.00000,0,0,0,325,0,22,-1,136000,0,'true','true','true','true',0,0,0,0,0,0,0,0,0,'0-0;'),
(177,'Mage Staff','lrhand','false',1050,2,2,'wood','none',30,20,'bigblunt',4,4.00000,0,0,0,325,0,28,-1,244000,0,'true','true','true','true',0,0,0,0,0,0,0,0,0,'0-0;'),
(178,'Bone Staff','lrhand','true',1060,2,2,'bone','d',39,20,'bigblunt',4,4.00000,0,0,0,325,0,35,-1,409000,743,'true','true','true','true',0,0,0,0,0,0,0,0,0,'0-0;'),
(179,'Mace of Prayer','rhand','true',1300,2,2,'steel','d',41,20,'blunt',4,4.00000,0,0,0,379,0,43,-1,644000,1170,'true','true','true','true',0,0,0,0,0,0,0,0,0,'0-0;'),
(180,'Mace of Judgment','rhand','true',1280,2,2,'steel','d',41,20,'blunt',4,4.00000,0,0,0,379,0,43,-1,644000,1170,'true','true','true','true',0,0,0,0,0,0,0,0,0,'0-0;'),
(181,'Mace of Miracle','rhand','true',1250,2,2,'steel','d',41,20,'blunt',4,4.00000,0,0,0,379,0,43,-1,644000,1170,'true','true','true','true',0,0,0,0,0,0,0,0,0,'0-0;'),
(182,'Doom Hammer','rhand','true',1200,2,2,'steel','d',41,20,'blunt',4,4.00000,0,0,0,379,0,43,-1,644000,1170,'true','true','true','true',0,0,0,0,0,0,0,0,0,'0-0;'),
(183,'Mystic Staff','lrhand','true',1040,2,2,'wood','d',50,20,'bigblunt',4,4.00000,0,0,0,325,0,43,-1,644000,1170,'true','true','true','true',0,0,0,0,0,0,0,0,0,'0-0;'),
(184,'Conjuror''s Staff','lrhand','true',1030,2,2,'oriharukon','d',50,20,'bigblunt',4,4.00000,0,0,0,325,0,43,-1,644000,1170,'true','true','true','true',0,0,0,0,0,0,0,0,0,'0-0;'),
(185,'Staff of Mana','lrhand','true',1040,2,2,'wood','d',50,20,'bigblunt',4,4.00000,0,0,0,325,0,43,-1,644000,1170,'true','true','true','true',0,0,0,0,0,0,0,0,0,'0-0;'),
(186,'Staff of Magic','lrhand','true',1020,2,2,'wood','d',62,20,'bigblunt',4,4.00000,0,0,0,325,0,52,-1,967000,1758,'true','true','true','true',0,0,0,0,0,0,0,0,0,'0-0;'),
(187,'Atuba Hammer','lrhand','true',1010,3,3,'fine_steel','d',90,20,'bigblunt',4,4.00000,0,0,0,325,0,72,-1,1800000,3272,'true','true','true','true',0,0,0,0,0,0,0,0,0,'0-0;'),
(188,'Ghost Staff','lrhand','true',1000,3,3,'wood','d',90,20,'bigblunt',4,4.00000,0,0,0,325,0,72,-1,1800000,3272,'true','true','true','true',0,0,0,0,0,0,0,0,0,'0-0;'),
(189,'Staff of Life','rhand','true',1180,3,3,'wood','d',74,20,'blunt',4,4.00000,0,0,0,379,0,72,-1,1800000,3272,'true','true','true','true',0,0,0,0,0,0,0,0,0,'0-0;'),
(190,'Atuba Mace','lrhand','true',1010,3,3,'fine_steel','d',90,20,'bigblunt',4,4.00000,0,0,0,325,0,72,-1,1800000,3272,'true','true','true','true',0,0,0,0,0,0,0,0,0,'0-0;'),
(191,'Heavy Doom Hammer','lrhand','true',1020,2,2,'fine_steel','c',103,20,'bigblunt',4,4.00000,0,0,0,325,0,81,-1,2290000,916,'true','true','true','true',0,0,0,0,0,0,0,0,0,'0-0;'),
(192,'Crystal Staff','lrhand','true',1020,2,2,'crystal','c',103,20,'bigblunt',4,4.00000,0,0,0,325,0,81,-1,2290000,916,'true','true','true','true',0,0,0,0,0,0,0,0,0,'0-0;'),
(193,'Stick of Faith','rhand','true',1160,2,2,'wood','c',85,20,'blunt',4,4.00000,0,0,0,379,0,81,-1,2290000,916,'true','true','true','true',0,0,0,0,0,0,0,0,0,'0-0;'),
(194,'Heavy Doom Axe','lrhand','true',1010,2,2,'fine_steel','c',103,20,'bigblunt',4,4.00000,0,0,0,325,0,81,-1,2290000,916,'true','true','true','true',0,0,0,0,0,0,0,0,0,'0-0;'),
(195,'Cursed Staff','lrhand','true',1000,2,2,'wood','c',119,20,'bigblunt',4,4.00000,0,0,0,325,0,91,-1,2870000,1148,'true','true','true','true',0,0,0,0,0,0,0,0,0,'0-0;'),
(196,'Stick of Eternity','rhand','true',1130,3,3,'wood','c',111,20,'blunt',4,4.00000,0,0,0,379,0,101,-1,4300000,1720,'true','true','true','true',0,0,0,0,0,0,0,0,0,'0-0;'),
(197,'Paradia Staff','lrhand','true',1010,3,3,'wood','c',135,20,'bigblunt',4,4.00000,0,0,0,325,0,101,-1,4300000,1720,'true','true','true','true',0,0,0,0,0,0,0,0,0,'0-0;'),
(198,'Inferno Staff','lrhand','true',1000,3,3,'wood','c',135,20,'bigblunt',4,4.00000,0,0,0,325,0,101,-1,4300000,1720,'true','true','true','true',0,0,0,0,0,0,0,0,0,'0-0;'),
(199,'Pa''agrian Hammer','lrhand','true',1010,3,3,'blood_steel','c',135,20,'bigblunt',4,4.00000,0,0,0,325,0,101,-1,4300000,1720,'true','true','true','true',0,0,0,0,0,0,0,0,0,'0-0;'),
(200,'Sage''s Staff','lrhand','true',1000,3,3,'wood','c',135,20,'bigblunt',4,4.00000,0,0,0,325,0,101,-1,4300000,1720,'true','true','true','true',0,0,0,0,0,0,0,0,0,'0-0;'),
(201,'Club of Nature','rhand','true',1100,3,3,'wood','c',111,20,'blunt',4,4.00000,0,0,0,379,0,101,-1,4300000,1720,'true','true','true','true',0,0,0,0,0,0,0,0,0,'0-0;'),
(202,'Mace of The Underworld','rhand','true',1090,3,3,'fine_steel','c',111,20,'blunt',4,4.00000,0,0,0,379,0,101,-1,4300000,1720,'true','true','true','true',0,0,0,0,0,0,0,0,0,'0-0;'),
(203,'Pa''agrian Axe','lrhand','true',990,3,3,'blood_steel','c',141,20,'bigblunt',4,4.00000,0,0,0,325,0,104,-1,4780000,1912,'true','true','true','true',0,0,0,0,0,0,0,0,0,'0-0;'),
(204,'Deadman''s Staff','lrhand','true',1010,3,3,'bone','c',152,20,'bigblunt',4,4.00000,0,0,0,325,0,111,-1,6130000,2452,'true','true','true','true',0,0,0,0,0,0,0,0,0,'0-0;'),
(205,'Ghoul''s Staff','lrhand','true',1000,3,3,'bone','c',152,20,'bigblunt',4,4.00000,0,0,0,325,0,111,-1,6130000,2452,'true','true','true','true',0,0,0,0,0,0,0,0,0,'0-0;'),
(206,'Demon''s Staff','lrhand','true',990,3,3,'wood','c',152,20,'bigblunt',4,4.00000,0,0,0,325,0,111,-1,6130000,2452,'true','true','true','true',0,0,0,0,0,0,0,0,0,'0-0;'),
(207,'Staff of Phantom','lrhand','true',980,1,1,'oriharukon','b',170,20,'bigblunt',4,4.00000,0,0,0,325,0,122,-1,8680000,1157,'true','true','true','true',0,0,0,0,0,0,0,0,0,'0-0;'),
(208,'Staff of Seal','lrhand','true',970,1,1,'wood','b',170,20,'bigblunt',4,4.00000,0,0,0,325,0,122,-1,8680000,1157,'true','true','true','true',0,0,0,0,0,0,0,0,0,'0-0;'),
(209,'Divine Staff','lrhand','true',960,1,1,'wood','b',189,20,'bigblunt',4,4.00000,0,0,0,325,0,132,-1,13100000,1746,'true','true','true','true',0,0,0,0,0,0,0,0,0,'0-0;'),
(210,'Staff of Evil Spirits','lrhand','true',930,1,1,'wood','b',189,20,'bigblunt',4,4.00000,0,0,0,325,0,132,-1,13100000,1746,'true','true','true','true',0,0,0,0,0,0,0,0,0,'0-0;'),
(211,'Staff of Nobility','lrhand','true',910,1,1,'wood','b',189,20,'bigblunt',4,4.00000,0,0,0,325,0,132,-1,13100000,1746,'true','true','true','true',0,0,0,0,0,0,0,0,0,'0-0;'),
(212,'Dasparion''s Staff','lrhand','true',920,1,1,'adamantaite','a',207,20,'bigblunt',4,4.00000,0,0,0,325,0,143,-1,18300000,1464,'true','true','true','true',0,0,0,0,0,0,0,0,0,'0-0;'),
(213,'Branch of The Mother Tree','lrhand','true',900,1,1,'wood','a',226,20,'bigblunt',4,4.00000,0,0,0,325,0,152,-1,27000000,2160,'true','true','true','true',0,0,0,0,0,0,0,0,0,'0-0;'),
(214,'The Staff','lrhand','true',910,1,1,'wood','s',245,20,'bigblunt',4,4.00000,0,0,0,325,0,162,-1,35300000,1765,'true','true','true','true',0,0,0,0,0,0,0,0,0,'0-0;'),
(215,'Doom Dagger','rhand','false',1130,1,1,'steel','none',10,5,'dagger',12,-3.00000,0,0,0,433,0,9,-1,12500,0,'true','true','true','true',0,0,0,0,0,0,0,0,0,'0-0;'),
(216,'Dirk','rhand','false',1130,2,2,'steel','none',15,5,'dagger',12,-3.00000,0,0,0,433,0,12,-1,54100,0,'true','true','true','true',0,0,0,0,0,0,0,0,0,'0-0;'),
(217,'Shining Knife','rhand','false',1120,2,2,'mithril','none',21,5,'dagger',12,-3.00000,0,0,0,433,0,17,-1,136000,0,'true','true','true','true',0,0,0,0,0,0,0,0,0,'0-0;'),
(218,'Throwing Knife','rhand','false',1120,2,2,'fine_steel','none',21,5,'dagger',12,-3.00000,0,0,0,433,0,17,-1,136000,0,'true','true','true','true',0,0,0,0,0,0,0,0,0,'0-0;'),
(219,'Sword Breaker','rhand','false',1110,2,2,'steel','none',27,5,'dagger',12,-3.00000,0,0,0,433,0,21,-1,244000,0,'true','true','true','true',0,0,0,0,0,0,0,0,0,'0-0;'),
(220,'Crafted Dagger','rhand','true',1100,2,2,'chrysolite','d',35,5,'dagger',12,-3.00000,0,0,0,433,0,26,-1,409000,743,'true','true','true','true',0,0,0,0,0,0,0,0,0,'0-0;'),
(221,'Assassin Knife','rhand','true',1100,2,2,'steel','d',35,5,'dagger',12,-3.00000,0,0,0,433,0,26,-1,409000,743,'true','true','true','true',0,0,0,0,0,0,0,0,0,'0-0;'),
(222,'Poniard Dagger','rhand','true',1090,2,2,'steel','d',45,5,'dagger',12,-3.00000,0,0,0,433,0,32,-1,644000,1170,'true','true','true','true',0,0,0,0,0,0,0,0,0,'0-0;'),
(223,'Kukuri','rhand','true',1080,2,2,'fine_steel','d',56,5,'dagger',12,-3.00000,0,0,0,433,0,39,-1,967000,1758,'true','true','true','true',0,0,0,0,0,0,0,0,0,'0-0;'),
(224,'Maingauche','rhand','true',1070,3,3,'fine_steel','d',69,5,'dagger',12,-3.00000,0,0,0,433,0,47,-1,1400000,2545,'true','true','true','true',0,0,0,0,0,0,0,0,0,'0-0;'),
(225,'Mithril Dagger','rhand','true',1060,3,3,'mithril','d',80,5,'dagger',12,-3.00000,0,0,0,433,0,54,-1,1800000,3272,'true','true','true','true',0,0,0,0,0,0,0,0,0,'0-0;'),
(226,'Cursed Dagger','rhand','true',1040,2,2,'mithril','c',94,5,'dagger',12,-3.00000,0,0,0,433,0,61,-1,2290000,916,'true','true','true','true',0,0,0,0,0,0,0,0,0,'0-0;'),
(227,'Stiletto','rhand','true',1030,2,2,'fine_steel','c',107,5,'dagger',12,-3.00000,0,0,0,433,0,68,-1,2870000,1148,'true','true','true','true',0,0,0,0,0,0,0,0,0,'0-0;'),
(228,'Crystal Dagger','rhand','true',1000,3,3,'crystal','c',136,5,'dagger',12,-3.00000,0,0,0,433,0,83,-1,6130000,2452,'true','true','true','true',0,0,0,0,0,0,0,0,0,'0-0;'),
(229,'Kris','rhand','true',980,1,1,'mithril','b',153,5,'dagger',12,-3.00000,0,0,0,433,0,91,-1,8680000,1157,'true','true','true','true',0,0,0,0,0,0,0,0,0,'0-0;'),
(230,'Wolverine Needle','rhand','true',1040,2,2,'fine_steel','c',94,5,'dagger',12,-3.00000,0,0,0,433,0,61,-1,2290000,916,'true','true','true','true',0,0,0,0,0,0,0,0,0,'0-0;'),
(231,'Grace Dagger','rhand','true',1020,3,3,'fine_steel','c',122,5,'dagger',12,-3.00000,0,0,0,433,0,76,-1,4300000,1720,'true','true','true','true',0,0,0,0,0,0,0,0,0,'0-0;'),
(232,'Dark Elven Dagger','rhand','true',1050,2,2,'fine_steel','c',94,5,'dagger',12,-3.00000,0,0,0,433,0,61,-1,2290000,916,'true','true','true','true',0,0,0,0,0,0,0,0,0,'0-0;'),
(233,'Dark Screamer','rhand','true',1010,3,3,'fine_steel','c',122,5,'dagger',12,-3.00000,0,0,0,433,0,76,-1,4300000,1720,'true','true','true','true',0,0,0,0,0,0,0,0,0,'0-0;'),
(234,'Demon Dagger','rhand','true',970,1,1,'blood_steel','b',170,5,'dagger',12,-3.00000,0,0,0,433,0,99,-1,13100000,1746,'true','true','true','true',0,0,0,0,0,0,0,0,0,'0-0;'),
(235,'Bloody Orchid','rhand','true',960,1,1,'blood_steel','a',186,5,'dagger',12,-3.00000,0,0,0,433,0,107,-1,18300000,1464,'true','true','true','true',0,0,0,0,0,0,0,0,0,'0-0;'),
(236,'Soul Separator','rhand','true',950,1,1,'oriharukon','a',203,5,'dagger',12,-3.00000,0,0,0,433,0,114,-1,27000000,2160,'true','true','true','true',0,0,0,0,0,0,0,0,0,'0-0;'),
(237,'Dragon''s Tooth','rhand','true',950,1,1,'bone','s',220,5,'dagger',12,-3.00000,0,0,0,433,0,121,-1,35300000,1765,'true','true','true','true',0,0,0,0,0,0,0,0,0,'0-0;'),
(238,'Dagger of Mana','rhand','true',750,2,2,'fine_steel','d',45,5,'dagger',12,-3.00000,0,0,0,433,0,52,-1,967000,1758,'true','true','true','true',0,0,0,0,0,0,0,0,0,'0-0;'),
(239,'Mystic Knife','rhand','true',760,2,2,'fine_steel','d',45,5,'dagger',12,-3.00000,0,0,0,433,0,52,-1,967000,1758,'true','true','true','true',0,0,0,0,0,0,0,0,0,'0-0;'),
(240,'Conjurer''s Knife','rhand','true',750,2,2,'fine_steel','d',45,5,'dagger',12,-3.00000,0,0,0,433,0,52,-1,967000,1758,'true','true','true','true',0,0,0,0,0,0,0,0,0,'0-0;'),
(241,'Shilen Knife','rhand','true',750,2,2,'bronze','d',45,5,'dagger',12,-3.00000,0,0,0,433,0,52,-1,967000,1758,'true','true','true','true',0,0,0,0,0,0,0,0,0,'0-0;'),
(242,'Soulfire Dirk','rhand','true',750,2,2,'fine_steel','c',86,5,'dagger',12,-3.00000,0,0,0,433,0,91,-1,2870000,1148,'true','true','true','true',0,0,0,0,0,0,0,0,0,'0-0;'),
(243,'Hell Knife','rhand','true',740,1,1,'blood_steel','b',122,5,'dagger',12,-3.00000,0,0,0,433,0,122,-1,8680000,1157,'true','true','true','true',0,0,0,0,0,0,0,0,0,'0-0;'),
(244,'Elven Fighter Fist','rhand','false',0,0,0,'leather','none',0,5,'fist',4,4.00000,0,0,0,325,0,0,-1,22,0,'true','true','true','true',0,0,0,0,0,0,0,0,0,'0-0;'),
(245,'Dark Fighter Fist','rhand','false',0,0,0,'leather','none',0,5,'fist',4,4.00000,0,0,0,325,0,0,-1,33,0,'true','true','true','true',0,0,0,0,0,0,0,0,0,'0-0;'),
(246,'Human Fighter Fist','rhand','false',0,0,0,'leather','none',0,5,'fist',4,4.00000,0,0,0,325,0,0,-1,44,0,'true','true','true','true',0,0,0,0,0,0,0,0,0,'0-0;'),
(247,'Dwarven Fighter Fist','rhand','false',0,0,0,'leather','none',0,5,'fist',4,4.00000,0,0,0,325,0,0,-1,56,0,'true','true','true','true',0,0,0,0,0,0,0,0,0,'0-0;'),
(248,'Orc Fighter Fist','rhand','false',0,0,0,'leather','none',0,5,'fist',4,4.00000,0,0,0,325,0,0,-1,67,0,'true','true','true','true',0,0,0,0,0,0,0,0,0,'0-0;'),
(249,'Elven Mystic Fist','rhand','false',0,0,0,'leather','none',0,5,'fist',4,4.00000,0,0,0,325,0,0,-1,11,0,'true','true','true','true',0,0,0,0,0,0,0,0,0,'0-0;'),
(250,'Dark Mystic Fist','rhand','false',0,0,0,'leather','none',0,5,'fist',4,4.00000,0,0,0,325,0,0,-1,22,0,'true','true','true','true',0,0,0,0,0,0,0,0,0,'0-0;'),
(251,'Human Mystic Fist','rhand','false',0,0,0,'leather','none',0,5,'fist',4,4.00000,0,0,0,325,0,0,-1,33,0,'true','true','true','true',0,0,0,0,0,0,0,0,0,'0-0;'),
(252,'Orc Shaman Fist','rhand','false',0,0,0,'leather','none',0,10,'fist',8,0.00000,0,0,0,379,0,0,-1,44,0,'true','true','true','true',0,0,0,0,0,0,0,0,0,'0-0;'),
(253,'Spiked Gloves','lrhand','false',1590,1,1,'leather','none',10,5,'dualfist',4,4.00000,0,0,0,325,0,6,-1,768,0,'true','true','true','true',0,0,0,0,0,0,0,0,0,'0-0;'),
(254,'Iron Gloves','lrhand','false',1580,1,1,'steel','none',13,5,'dualfist',4,4.00000,0,0,0,325,0,9,-1,12500,0,'true','true','true','true',0,0,0,0,0,0,0,0,0,'0-0;'),
(255,'Fox Claw Gloves','lrhand','false',1560,2,2,'steel','none',21,5,'dualfist',4,4.00000,0,0,0,325,0,12,-1,54100,0,'true','true','true','true',0,0,0,0,0,0,0,0,0,'0-0;'),
(256,'Cestus','lrhand','false',1570,2,2,'steel','none',29,5,'dualfist',4,4.00000,0,0,0,325,0,17,-1,136000,0,'true','true','true','true',0,0,0,0,0,0,0,0,0,'0-0;'),
(257,'Viper Fang','lrhand','false',1560,2,2,'steel','none',38,5,'dualfist',4,4.00000,0,0,0,325,0,21,-1,244000,0,'true','true','true','true',0,0,0,0,0,0,0,0,0,'0-0;'),
(258,'Bagh-Nakh','lrhand','true',1540,2,2,'steel','d',49,5,'dualfist',4,4.00000,0,0,0,325,0,26,-1,409000,743,'true','true','true','true',0,0,0,0,0,0,0,0,0,'0-0;'),
(259,'Single-Edged Jamadhr','lrhand','true',1550,2,2,'steel','d',62,5,'dualfist',4,4.00000,0,0,0,325,0,32,-1,644000,1170,'true','true','true','true',0,0,0,0,0,0,0,0,0,'0-0;'),
(260,'Triple-Edged Jamadhr','lrhand','true',1540,2,2,'fine_steel','d',78,5,'dualfist',4,4.00000,0,0,0,325,0,39,-1,967000,1758,'true','true','true','true',0,0,0,0,0,0,0,0,0,'0-0;'),
(261,'Bich''Hwa','lrhand','true',1510,3,3,'fine_steel','d',96,5,'dualfist',4,4.00000,0,0,0,325,0,47,-1,1400000,2545,'true','true','true','true',0,0,0,0,0,0,0,0,0,'0-0;'),
(262,'Scallop Jamadhr','lrhand','true',1520,3,3,'fine_steel','d',112,5,'dualfist',4,4.00000,0,0,0,325,0,54,-1,1800000,3272,'true','true','true','true',0,0,0,0,0,0,0,0,0,'0-0;'),
(263,'Chakram','lrhand','true',1490,2,2,'fine_steel','c',130,5,'dualfist',4,4.00000,0,0,0,325,0,61,-1,2290000,916,'true','true','true','true',0,0,0,0,0,0,0,0,0,'0-0;'),
(264,'Pata','lrhand','true',1440,1,1,'fine_steel','b',204,5,'dualfist',4,4.00000,0,0,0,325,0,89,-1,7830000,1044,'true','true','true','true',0,0,0,0,0,0,0,0,0,'0-0;'),
(265,'Fisted Blade','lrhand','true',1480,3,3,'fine_steel','c',169,5,'dualfist',4,4.00000,0,0,0,325,0,76,-1,4300000,1720,'true','true','true','true',0,0,0,0,0,0,0,0,0,'0-0;'),
(266,'Great Pata','lrhand','true',1460,3,3,'chrysolite','c',190,5,'dualfist',4,4.00000,0,0,0,325,0,83,-1,6130000,2452,'true','true','true','true',0,0,0,0,0,0,0,0,0,'0-0;'),
(267,'Arthro Nail','lrhand','true',1420,1,1,'blood_steel','b',213,5,'dualfist',4,4.00000,0,0,0,325,0,91,-1,8680000,1157,'true','true','true','true',0,0,0,0,0,0,0,0,0,'0-0;'),
(268,'Bellion Cestus','lrhand','true',1390,1,1,'mithril','b',236,5,'dualfist',4,4.00000,0,0,0,325,0,99,-1,13100000,1746,'true','true','true','true',0,0,0,0,0,0,0,0,0,'0-0;'),
(269,'Blood Tornado','lrhand','true',1370,1,1,'blood_steel','a',259,5,'dualfist',4,4.00000,0,0,0,325,0,107,-1,18300000,1464,'true','true','true','true',0,0,0,0,0,0,0,0,0,'0-0;'),
(270,'Dragon Grinder','lrhand','true',1350,1,1,'adamantaite','a',282,5,'dualfist',4,4.00000,0,0,0,325,0,114,-1,27000000,2160,'true','true','true','true',0,0,0,0,0,0,0,0,0,'0-0;'),
(271,'Hunting Bow','lrhand','false',1910,6,2,'wood','none',34,5,'bow',12,-3.00000,0,0,0,293,2,12,-1,54100,0,'true','true','true','true',0,0,0,0,0,0,0,0,0,'0-0;'),
(272,'Forest Bow','lrhand','false',1900,7,2,'wood','none',49,5,'bow',12,-3.00000,0,0,0,293,3,17,-1,136000,0,'true','true','true','true',0,0,0,0,0,0,0,0,0,'0-0;'),
(273,'Composite Bow','lrhand','false',1880,7,2,'steel','none',64,5,'bow',12,-3.00000,0,0,0,293,3,21,-1,244000,0,'true','true','true','true',0,0,0,0,0,0,0,0,0,'0-0;'),
(274,'Strengthened Bow','lrhand','true',1870,6,2,'steel','d',82,5,'bow',12,-3.00000,0,0,0,293,3,26,-1,409000,743,'true','true','true','true',0,0,0,0,0,0,0,0,9212,'0-0;'),
(275,'Long Bow','lrhand','true',1830,6,2,'steel','d',114,5,'bow',12,-3.00000,0,0,0,227,4,35,-1,644000,1170,'true','true','true','true',0,0,0,0,0,0,0,0,9217,'0-0;'),
(276,'Elven Bow','lrhand','true',1850,6,2,'mithril','d',105,5,'bow',12,-3.00000,0,0,0,293,4,32,-1,644000,1170,'true','true','true','true',0,0,0,0,0,0,0,0,0,'0-0;'),
(277,'Dark Elven Bow','lrhand','true',1830,6,2,'steel','d',105,5,'bow',12,-3.00000,0,0,0,293,4,32,-1,644000,1170,'true','true','true','true',0,0,0,0,0,0,0,0,0,'0-0;'),
(278,'Gastraphetes','lrhand','true',1840,8,2,'fine_steel','d',132,5,'bow',12,-3.00000,0,0,0,293,4,39,-1,967000,1758,'true','true','true','true',0,0,0,0,0,0,0,0,9221,'0-0;'),
(279,'Strengthened Long Bow','lrhand','true',1820,10,3,'fine_steel','d',179,5,'bow',12,-3.00000,0,0,0,227,5,51,-1,1400000,2545,'true','true','true','true',0,0,0,0,0,0,0,0,9224,'0-0;'),
(280,'Light Crossbow','lrhand','true',1810,10,3,'fine_steel','d',191,5,'bow',12,-3.00000,0,0,0,293,6,54,-1,1800000,3272,'true','true','true','true',0,0,0,0,0,0,0,0,9227,'0-0;'),
(281,'Crystallized Ice Bow','lrhand','true',1790,8,2,'crystal','c',220,5,'bow',12,-3.00000,0,0,0,293,6,61,-1,2290000,916,'true','true','true','true',0,0,0,0,0,0,0,0,9236,'0-0;'),
(282,'Elemental Bow','lrhand','true',1770,8,2,'fine_steel','c',277,5,'bow',12,-3.00000,0,0,0,227,7,75,-1,2870000,1148,'true','true','true','true',0,0,0,0,0,0,0,0,9256,'0-0;'),
(283,'Akat Long Bow','lrhand','true',1740,9,3,'horn','c',316,5,'bow',12,-3.00000,0,0,0,227,7,84,-1,4300000,1720,'true','true','true','true',0,0,0,0,0,0,0,0,9288,'0-0;'),
(284,'Dark Elven Long Bow','lrhand','true',1720,3,1,'oriharukon','b',397,5,'bow',12,-3.00000,0,0,0,227,8,100,-1,8680000,1157,'true','true','true','true',0,0,0,0,0,0,0,0,9312,'0-0;'),
(285,'Noble Elven Bow','lrhand','true',1760,8,2,'mithril','c',252,5,'bow',12,-3.00000,0,0,0,293,7,68,-1,2870000,1148,'true','true','true','true',0,0,0,0,0,0,0,0,9260,'0-0;'),
(286,'Eminence Bow','lrhand','true',1720,10,3,'chrysolite','c',323,5,'bow',12,-3.00000,0,0,0,293,8,83,-1,6130000,2452,'true','true','true','true',0,0,0,0,0,0,0,0,9300,'0-0;'),
(287,'Bow of Peril','lrhand','true',1700,3,1,'blood_steel','b',400,5,'bow',12,-3.00000,0,0,0,293,9,99,-1,13100000,1746,'true','true','true','true',0,0,0,0,0,0,0,0,9324,'0-0;'),
(288,'Carnage Bow','lrhand','true',1670,2,1,'damascus','a',440,5,'bow',12,-3.00000,0,0,0,293,9,107,-1,18300000,1464,'true','true','true','true',0,0,0,0,0,0,0,0,9336,'0-0;'),
(289,'Soul Bow','lrhand','true',1660,2,1,'oriharukon','a',528,5,'bow',12,-3.00000,0,0,0,227,10,125,-1,27000000,2160,'true','true','true','true',0,0,0,0,0,0,0,0,9348,'0-0;'),
(290,'The Bow','lrhand','true',1650,1,1,'adamantaite','s',519,5,'bow',12,-3.00000,0,0,0,293,10,121,-1,35300000,1765,'true','true','true','true',0,0,0,0,0,0,0,0,0,'0-0;'),
(291,'Trident','lrhand','true',2100,2,2,'bronze','d',40,10,'pole',8,-3.00000,0,0,0,325,0,26,-1,409000,743,'true','true','true','true',0,0,0,0,0,0,0,0,0,'0-0;'),
(292,'Pike','lrhand','true',2090,2,2,'steel','d',51,10,'pole',8,-3.00000,0,0,0,325,0,32,-1,644000,1170,'true','true','true','true',0,0,0,0,0,0,0,0,0,'0-0;'),
(293,'War Hammer','lrhand','true',2080,2,2,'fine_steel','d',64,10,'pole',8,-3.00000,0,0,0,325,0,39,-1,967000,1758,'true','true','true','true',0,0,0,0,0,0,0,0,0,'0-0;'),
(294,'War Pick','lrhand','true',2050,3,3,'fine_steel','d',79,10,'pole',8,-3.00000,0,0,0,325,0,47,-1,1400000,2545,'true','true','true','true',0,0,0,0,0,0,0,0,0,'0-0;'),
(295,'Dwarven Trident','lrhand','true',2090,2,2,'steel','d',51,10,'pole',8,-3.00000,0,0,0,325,0,32,-1,644000,1170,'true','true','true','true',0,0,0,0,0,0,0,0,0,'0-0;'),
(296,'Dwarven Pike','lrhand','true',2070,2,2,'fine_steel','d',64,10,'pole',8,-3.00000,0,0,0,325,0,39,-1,967000,1758,'true','true','true','true',0,0,0,0,0,0,0,0,0,'0-0;'),
(297,'Glaive','lrhand','true',2050,3,3,'fine_steel','d',92,10,'pole',8,-3.00000,0,0,0,325,0,54,-1,1800000,3272,'true','true','true','true',0,0,0,0,0,0,0,0,0,'0-0;'),
(298,'Orcish Glaive','lrhand','true',2030,2,2,'fine_steel','c',107,10,'pole',8,-3.00000,0,0,0,325,0,61,-1,2290000,916,'true','true','true','true',0,0,0,0,0,0,0,0,0,'0-0;'),
(299,'Orcish Poleaxe','lrhand','true',1950,3,3,'blood_steel','c',156,10,'pole',8,-3.00000,0,0,0,325,0,83,-1,6130000,2452,'true','true','true','true',0,0,0,0,0,0,0,0,0,'0-0;'),
(300,'Great Axe','lrhand','true',1940,1,1,'damascus','b',175,10,'pole',8,-3.00000,0,0,0,325,0,91,-1,8680000,1157,'true','true','true','true',0,0,0,0,0,0,0,0,0,'0-0;'),
(301,'Scorpion','lrhand','true',1990,3,3,'fine_steel','c',144,10,'pole',8,-3.00000,0,0,0,325,0,78,-1,4780000,1912,'true','true','true','true',0,0,0,0,0,0,0,0,0,'0-0;'),
(302,'Body Slasher','lrhand','true',2030,2,2,'fine_steel','c',107,10,'pole',8,-3.00000,0,0,0,325,0,61,-1,2290000,916,'true','true','true','true',0,0,0,0,0,0,0,0,0,'0-0;'),
(303,'Widow Maker','lrhand','true',1980,3,3,'fine_steel','c',144,10,'pole',8,-3.00000,0,0,0,325,0,78,-1,4780000,1912,'true','true','true','true',0,0,0,0,0,0,0,0,0,'0-0;'),
(304,'Orcish Halberd','lrhand','true',1880,1,1,'blood_steel','a',219,10,'pole',8,-3.00000,0,0,0,325,0,109,-1,21300000,1704,'true','true','true','true',0,0,0,0,0,0,0,0,0,'0-0;'),
(305,'Tallum Glaive','lrhand','true',1840,1,1,'chrysolite','a',232,10,'pole',8,-3.00000,0,0,0,325,0,114,-1,27000000,2160,'true','true','true','true',0,0,0,0,0,0,0,0,0,'0-0;'),
(306,'Dragon Claw Axe','lrhand','true',1820,1,1,'bone','s',251,10,'pole',8,-3.00000,0,0,0,325,0,121,-1,35300000,1765,'true','true','true','true',0,0,0,0,0,0,0,0,0,'0-0;'),
(307,'Aurakyria Lance','lrhand','true',1800,1,1,'adamantaite','s',269,10,'pole',8,-3.00000,0,0,0,325,0,128,-1,0,0,'false','false','true','false',0,0,0,0,0,0,0,0,0,'0-0;'),
(308,'Buffalo''s Horn','rhand','false',660,1,1,'steel','none',6,10,'etc',8,0.00000,0,0,0,379,0,8,-1,768,0,'true','true','true','true',0,0,0,0,0,0,0,0,0,'0-0;'),
(309,'Tears of Eva','rhand','false',630,2,2,'steel','none',19,10,'etc',8,0.00000,0,0,0,379,0,22,-1,136000,0,'true','true','true','true',0,0,0,0,0,0,0,0,0,'0-0;'),
(310,'Relic of The Saints','rhand','false',610,2,2,'steel','none',19,10,'etc',8,0.00000,0,0,0,379,0,22,-1,136000,0,'true','true','true','true',0,0,0,0,0,0,0,0,0,'0-0;'),
(311,'Crucifix of Blessing','rhand','false',620,2,2,'steel','none',25,10,'etc',8,0.00000,0,0,0,379,0,28,-1,244000,0,'true','true','true','true',0,0,0,0,0,0,0,0,0,'0-0;'),
(312,'Branch of Life','rhand','true',620,2,2,'steel','d',32,10,'etc',8,0.00000,0,0,0,379,0,35,-1,409000,743,'true','true','true','true',0,0,0,0,0,0,0,0,0,'0-0;'),
(313,'Temptation of Abyss','rhand','true',610,2,2,'steel','d',32,10,'etc',8,0.00000,0,0,0,379,0,35,-1,409000,743,'true','true','true','true',0,0,0,0,0,0,0,0,0,'0-0;'),
(314,'Proof of Revenge','rhand','true',600,2,2,'steel','d',32,10,'etc',8,0.00000,0,0,0,379,0,35,-1,409000,743,'true','true','true','true',0,0,0,0,0,0,0,0,0,'0-0;'),
(315,'Divine Tome','rhand','true',570,2,2,'steel','d',41,10,'etc',8,0.00000,0,0,0,379,0,43,-1,644000,1170,'true','true','true','true',0,0,0,0,0,0,0,0,0,'0-0;'),
(316,'Blood of Saints','rhand','true',580,2,2,'steel','d',51,10,'etc',8,0.00000,0,0,0,379,0,52,-1,967000,1758,'true','true','true','true',0,0,0,0,0,0,0,0,0,'0-0;'),
(317,'Tome of Blood','rhand','true',570,2,2,'steel','d',51,10,'etc',8,0.00000,0,0,0,379,0,52,-1,967000,1758,'true','true','true','true',0,0,0,0,0,0,0,0,0,'0-0;'),
(318,'Crucifix of Blood','rhand','true',540,3,3,'steel','d',63,10,'etc',8,0.00000,0,0,0,379,0,63,-1,1400000,2545,'true','true','true','true',0,0,0,0,0,0,0,0,0,'0-0;'),
(319,'Eye of Infinity','rhand','true',1600,3,3,'steel','d',63,10,'etc',8,0.00000,0,0,0,379,0,63,-1,1400000,2545,'true','true','true','true',0,0,0,0,0,0,0,0,0,'0-0;'),
(320,'Blue Crystal Skull','rhand','true',1600,3,3,'steel','d',67,10,'etc',8,0.00000,0,0,0,379,0,66,-1,1520000,2763,'true','true','true','true',0,0,0,0,0,0,0,0,0,'0-0;'),
(321,'Demon Fangs','rhand','true',1600,3,3,'steel','d',67,10,'etc',8,0.00000,0,0,0,379,0,66,-1,1520000,2763,'true','true','true','true',0,0,0,0,0,0,0,0,0,'0-0;'),
(322,'Vajra Wands','rhand','true',1600,3,3,'steel','d',74,10,'etc',8,0.00000,0,0,0,379,0,72,-1,1800000,3272,'true','true','true','true',0,0,0,0,0,0,0,0,0,'0-0;'),
(323,'Ancient Reagent','rhand','true',1600,3,3,'steel','d',74,10,'etc',8,0.00000,0,0,0,379,0,72,-1,1800000,3272,'true','true','true','true',0,0,0,0,0,0,0,0,0,'0-0;'),
(324,'Tears of Fairy','rhand','true',1600,2,2,'steel','c',98,10,'etc',8,0.00000,0,0,0,379,0,91,-1,2870000,1148,'true','true','true','true',0,0,0,0,0,0,0,0,0,'0-0;'),
(325,'Horn of Glory','rhand','true',540,2,2,'steel','c',98,10,'etc',8,0.00000,0,0,0,379,0,91,-1,2870000,1148,'true','true','true','true',0,0,0,0,0,0,0,0,0,'0-0;'),
(326,'Heathen''s Book','rhand','true',560,3,3,'steel','c',111,10,'etc',8,0.00000,0,0,0,379,0,101,-1,4300000,1720,'true','true','true','true',0,0,0,0,0,0,0,0,0,'0-0;'),
(327,'Hex Doll','rhand','true',1600,3,3,'steel','c',111,10,'etc',8,0.00000,0,0,0,379,0,101,-1,4300000,1720,'true','true','true','true',0,0,0,0,0,0,0,0,0,'0-0;'),
(328,'Candle of Wisdom','rhand','true',1600,3,3,'steel','c',125,10,'etc',8,0.00000,0,0,0,379,0,111,-1,6130000,2452,'true','true','true','true',0,0,0,0,0,0,0,0,0,'0-0;'),
(329,'Blessed Branch','rhand','true',800,3,3,'steel','c',125,10,'etc',8,0.00000,0,0,0,379,0,111,-1,6130000,2452,'true','true','true','true',0,0,0,0,0,0,0,0,0,'0-0;'),
(330,'Phoenix Feather','rhand','true',800,3,3,'steel','c',125,10,'etc',8,0.00000,0,0,0,379,0,111,-1,6130000,2452,'true','true','true','true',0,0,0,0,0,0,0,0,0,'0-0;'),
(331,'Cerberus Eye','rhand','true',1600,3,3,'steel','c',125,10,'etc',8,0.00000,0,0,0,379,0,111,-1,6130000,2452,'true','true','true','true',0,0,0,0,0,0,0,0,0,'0-0;'),
(332,'Scroll of Destruction','rhand','true',1600,3,3,'steel','c',125,10,'etc',8,0.00000,0,0,0,379,0,111,-1,6130000,2452,'true','true','true','true',0,0,0,0,0,0,0,0,0,'0-0;'),
(333,'Claws of Black Dragon','rhand','true',1600,3,3,'steel','c',125,10,'etc',8,0.00000,0,0,0,379,0,111,-1,6130000,2452,'true','true','true','true',0,0,0,0,0,0,0,0,0,'0-0;'),
(334,'Three Eyed Crow''s Feather','rhand','true',1600,3,3,'steel','c',125,10,'etc',8,0.00000,0,0,0,379,0,111,-1,6130000,2452,'true','true','true','true',0,0,0,0,0,0,0,0,0,'0-0;'),
(335,'Soul Crystal','rhand','true',1600,1,1,'steel','b',155,10,'etc',8,0.00000,0,0,0,379,0,132,-1,13100000,1746,'true','true','true','true',0,0,0,0,0,0,0,0,0,'0-0;'),
(336,'Scroll of Mana','rhand','true',1600,1,1,'steel','b',170,10,'etc',8,0.00000,0,0,0,379,0,143,-1,18300000,2440,'true','true','true','true',0,0,0,0,0,0,0,0,0,'0-0;'),
(337,'Scroll of Massacre','rhand','true',1600,1,1,'steel','b',170,10,'etc',8,0.00000,0,0,0,379,0,143,-1,18300000,2440,'true','true','true','true',0,0,0,0,0,0,0,0,0,'0-0;'),
(338,'Wyvern''s Skull','rhand','true',4800,1,1,'steel','b',170,10,'etc',8,0.00000,0,0,0,379,0,143,-1,18300000,2440,'true','true','true','true',0,0,0,0,0,0,0,0,0,'0-0;'),
(339,'Blood Crystal','rhand','true',1600,1,1,'steel','b',170,10,'etc',8,0.00000,0,0,0,379,0,143,-1,18300000,2440,'true','true','true','true',0,0,0,0,0,0,0,0,0,'0-0;'),
(340,'Unicorn''s Horn','rhand','true',1600,1,1,'steel','b',170,10,'etc',8,0.00000,0,0,0,379,0,143,-1,18300000,2440,'true','true','true','true',0,0,0,0,0,0,0,0,0,'0-0;'),
(341,'Forgotten Tome','rhand','true',1600,1,1,'steel','a',186,10,'etc',8,0.00000,0,0,0,379,0,152,-1,27000000,2160,'true','true','true','true',0,0,0,0,0,0,0,0,0,'0-0;'),
(342,'Enchanted Flute','rhand','true',1600,1,1,'steel','a',186,10,'etc',8,0.00000,0,0,0,379,0,152,-1,27000000,2160,'true','true','true','true',0,0,0,0,0,0,0,0,0,'0-0;'),
(343,'Headless Arrow','rhand','true',1600,1,1,'steel','a',186,10,'etc',8,0.00000,0,0,0,379,0,152,-1,27000000,2160,'true','true','true','true',0,0,0,0,0,0,0,0,0,'0-0;'),
(344,'Proof of Overlord','rhand','true',1600,1,1,'steel','a',186,10,'etc',8,0.00000,0,0,0,379,0,152,-1,27000000,2160,'true','true','true','true',0,0,0,0,0,0,0,0,0,'0-0;'),
(345,'Deathbringer Sword','rhand','true',4800,1,1,'steel','a',186,10,'etc',8,0.00000,0,0,0,379,0,152,-1,27000000,2160,'true','true','true','true',0,0,0,0,0,0,0,0,0,'0-0;'),
(346,'Tears of Fallen Angel','rhand','true',1600,1,1,'steel','s',201,10,'etc',8,0.00000,0,0,0,379,0,162,-1,35300000,1765,'true','true','true','true',0,0,0,0,0,0,0,0,0,'0-0;'),
(625,'Bone Shield','lhand','false',1380,0,0,'bone','none',0,0,'none',0,0.00000,-8,90,20,0,0,0,-1,12900,0,'true','true','true','true',0,0,0,0,0,0,0,0,0,'0-0;'),
(626,'Bronze Shield','lhand','true',1370,0,0,'bronze','d',0,0,'none',0,0.00000,-8,101,20,0,0,0,-1,21900,39,'true','true','true','true',0,0,0,0,0,0,0,0,0,'0-0;'),
(627,'Aspis','lhand','true',1350,0,0,'steel','d',0,0,'none',0,0.00000,-8,114,20,0,0,0,-1,35000,63,'true','true','true','true',0,0,0,0,0,0,0,0,0,'0-0;'),
(628,'Hoplon','lhand','true',1340,0,0,'fine_steel','d',0,0,'none',0,0.00000,-8,128,20,0,0,0,-1,53300,96,'true','true','true','true',0,0,0,0,0,0,0,0,0,'0-0;'),
(629,'Kite Shield','lhand','true',1320,0,0,'fine_steel','d',0,0,'none',0,0.00000,-8,142,20,0,0,0,-1,78400,142,'true','true','true','true',0,0,0,0,0,0,0,0,0,'0-0;'),
(630,'Square Shield','lhand','true',1310,0,0,'fine_steel','d',0,0,'none',0,0.00000,-8,154,20,0,0,0,-1,103000,187,'true','true','true','true',0,0,0,0,0,0,0,0,0,'0-0;'),
(631,'Eldarake','lhand','true',1290,0,0,'fine_steel','c',0,0,'none',0,0.00000,-8,166,20,0,0,0,-1,133000,53,'true','true','true','true',0,0,0,0,0,0,0,0,0,'0-0;'),
(632,'Knight''s Shield','lhand','true',1260,0,0,'fine_steel','c',0,0,'none',0,0.00000,-8,178,20,0,0,0,-1,169000,67,'true','true','true','true',0,0,0,0,0,0,0,0,0,'0-0;'),
(633,'Zubei''s Shield','lhand','true',1210,0,0,'mithril','b',0,0,'none',0,0.00000,-8,216,20,0,0,0,-1,545000,72,'true','true','true','true',0,0,0,0,0,0,0,0,0,'0-0;'),
(634,'Dragon Shield','lhand','true',1170,0,0,'bone','s',0,0,'none',0,0.00000,-8,269,20,0,0,0,-1,2510000,125,'true','false','true','true',0,0,0,0,0,0,0,0,0,'0-0;'),
(635,'Wolf Shield','lhand','true',640,0,0,'oriharukon','b',0,0,'none',0,0.00000,-8,216,20,0,0,0,-1,545000,72,'true','true','true','true',0,0,0,0,0,0,0,0,0,'0-0;'),
(636,'Shining Dragon Shield','lhand','true',720,0,0,'mithril','b',0,0,'none',0,0.00000,-8,230,20,0,0,0,-1,845000,112,'true','true','true','true',0,0,0,0,0,0,0,0,0,'0-0;'),
(637,'Shield of Valor','lhand','true',720,0,0,'blood_steel','b',0,0,'none',0,0.00000,-8,230,20,0,0,0,-1,845000,112,'true','true','true','true',0,0,0,0,0,0,0,0,0,'0-0;'),
(638,'Glorious Shield','lhand','true',800,0,0,'fine_steel','b',0,0,'none',0,0.00000,-8,216,20,0,0,0,-1,545000,72,'true','true','true','true',0,0,0,0,0,0,0,0,0,'0-0;'),
(639,'Red Flame Shield','lhand','true',960,0,0,'blood_steel','b',0,0,'none',0,0.00000,-8,230,20,0,0,0,-1,845000,112,'true','true','true','true',0,0,0,0,0,0,0,0,0,'0-0;'),
(640,'Elven Crystal Shield','lhand','true',720,0,0,'crystal','b',0,0,'none',0,0.00000,-8,216,20,0,0,0,-1,545000,72,'true','true','true','true',0,0,0,0,0,0,0,0,0,'0-0;'),
(641,'Dark Crystal Shield','lhand','true',1190,0,0,'crystal','a',0,0,'none',0,0.00000,-8,243,20,0,0,0,-1,1220000,97,'true','true','true','true',0,0,0,0,0,0,0,0,0,'0-0;'),
(642,'Elven Vagian Shield','lhand','true',560,0,0,'mithril','b',0,0,'none',0,0.00000,-8,216,20,0,0,0,-1,545000,72,'true','true','true','true',0,0,0,0,0,0,0,0,0,'0-0;'),
(643,'Dark Vagian Shield','lhand','true',560,0,0,'mithril','b',0,0,'none',0,0.00000,-8,230,20,0,0,0,-1,845000,112,'true','true','true','true',0,0,0,0,0,0,0,0,0,'0-0;'),
(644,'Hell Shield','lhand','true',640,0,0,'blood_steel','b',0,0,'none',0,0.00000,-8,230,20,0,0,0,-1,845000,112,'true','true','true','true',0,0,0,0,0,0,0,0,0,'0-0;'),
(645,'Art of Shield','lhand','true',560,0,0,'chrysolite','b',0,0,'none',0,0.00000,-8,216,20,0,0,0,-1,545000,72,'true','true','true','true',0,0,0,0,0,0,0,0,0,'0-0;'),
(646,'Shield of Silence','lhand','true',640,0,0,'damascus','b',0,0,'none',0,0.00000,-8,216,20,0,0,0,-1,545000,72,'true','true','true','true',0,0,0,0,0,0,0,0,0,'0-0;'),
(647,'Gust Shield','lhand','true',720,0,0,'blood_steel','b',0,0,'none',0,0.00000,-8,230,20,0,0,0,-1,845000,112,'true','true','true','true',0,0,0,0,0,0,0,0,0,'0-0;'),
(648,'Prairie Shield','lhand','true',800,0,0,'chrysolite','b',0,0,'none',0,0.00000,-8,216,20,0,0,0,-1,545000,72,'true','true','true','true',0,0,0,0,0,0,0,0,0,'0-0;'),
(649,'Shield of The Underworld','lhand','true',880,0,0,'damascus','b',0,0,'none',0,0.00000,-8,230,20,0,0,0,-1,845000,112,'true','true','true','true',0,0,0,0,0,0,0,0,0,'0-0;'),
(650,'Shield of Concentration','lhand','true',960,0,0,'oriharukon','b',0,0,'none',0,0.00000,-8,216,20,0,0,0,-1,545000,72,'true','true','true','true',0,0,0,0,0,0,0,0,0,'0-0;'),
(651,'Ace''s Shield','lhand','true',1040,0,0,'oriharukon','b',0,0,'none',0,0.00000,-8,230,20,0,0,0,-1,845000,112,'true','true','true','true',0,0,0,0,0,0,0,0,0,'0-0;'),
(652,'Guardian''s Shield','lhand','true',1120,0,0,'mithril','b',0,0,'none',0,0.00000,-8,216,20,0,0,0,-1,545000,72,'true','true','true','true',0,0,0,0,0,0,0,0,0,'0-0;'),
(653,'Marksman Shield','lhand','true',1200,0,0,'leather','b',0,0,'none',0,0.00000,-8,230,20,0,0,0,-1,845000,112,'true','true','true','true',0,0,0,0,0,0,0,0,0,'0-0;'),
(654,'Shield of Mana','lhand','true',480,0,0,'mithril','b',0,0,'none',0,0.00000,-8,216,20,0,0,0,-1,545000,72,'true','true','true','true',0,0,0,0,0,0,0,0,0,'0-0;'),
(655,'Sage''s Shield','lhand','true',560,0,0,'steel','b',0,0,'none',0,0.00000,-8,230,20,0,0,0,-1,845000,112,'true','true','true','true',0,0,0,0,0,0,0,0,0,'0-0;'),
(656,'Paradia Shield','lhand','true',480,0,0,'chrysolite','b',0,0,'none',0,0.00000,-8,216,20,0,0,0,-1,545000,72,'true','true','true','true',0,0,0,0,0,0,0,0,0,'0-0;'),
(657,'Inferno Shield','lhand','true',560,0,0,'blood_steel','b',0,0,'none',0,0.00000,-8,230,20,0,0,0,-1,845000,112,'true','true','true','true',0,0,0,0,0,0,0,0,0,'0-0;'),
(658,'Shield of Black Ore','lhand','true',560,0,0,'damascus','b',0,0,'none',0,0.00000,-8,230,20,0,0,0,-1,845000,112,'true','true','true','true',0,0,0,0,0,0,0,0,0,'0-0;'),
(659,'Shield of Summoning','lhand','true',480,0,0,'leather','b',0,0,'none',0,0.00000,-8,216,20,0,0,0,-1,545000,72,'true','true','true','true',0,0,0,0,0,0,0,0,0,'0-0;'),
(660,'Otherworldly Shield','lhand','true',560,0,0,'adamantaite','b',0,0,'none',0,0.00000,-8,230,20,0,0,0,-1,845000,112,'true','true','true','true',0,0,0,0,0,0,0,0,0,'0-0;'),
(661,'Elemental Shield','lhand','true',480,0,0,'mithril','b',0,0,'none',0,0.00000,-8,216,20,0,0,0,-1,545000,72,'true','true','true','true',0,0,0,0,0,0,0,0,0,'0-0;'),
(662,'Shield of Phantom','lhand','true',560,0,0,'oriharukon','b',0,0,'none',0,0.00000,-8,230,20,0,0,0,-1,845000,112,'true','true','true','true',0,0,0,0,0,0,0,0,0,'0-0;'),
(663,'Shield of Grace','lhand','true',480,0,0,'mithril','b',0,0,'none',0,0.00000,-8,216,20,0,0,0,-1,545000,72,'true','true','true','true',0,0,0,0,0,0,0,0,0,'0-0;'),
(664,'Shield of Holy Spirit','lhand','true',560,0,0,'chrysolite','b',0,0,'none',0,0.00000,-8,230,20,0,0,0,-1,845000,112,'true','true','true','true',0,0,0,0,0,0,0,0,0,'0-0;'),
(665,'Phoenix Shield','lhand','true',480,0,0,'blood_steel','b',0,0,'none',0,0.00000,-8,216,20,0,0,0,-1,545000,72,'true','true','true','true',0,0,0,0,0,0,0,0,0,'0-0;'),
(666,'Cerberus Shield','lhand','true',560,0,0,'damascus','b',0,0,'none',0,0.00000,-8,230,20,0,0,0,-1,845000,112,'true','true','true','true',0,0,0,0,0,0,0,0,0,'0-0;'),
(667,'Shield of Aid','lhand','true',480,0,0,'fine_steel','b',0,0,'none',0,0.00000,-8,216,20,0,0,0,-1,545000,72,'true','true','true','true',0,0,0,0,0,0,0,0,0,'0-0;'),
(668,'Shield of Blessing','lhand','true',560,0,0,'adamantaite','b',0,0,'none',0,0.00000,-8,230,20,0,0,0,-1,845000,112,'true','true','true','true',0,0,0,0,0,0,0,0,0,'0-0;'),
(669,'Flame Shield','lhand','true',480,0,0,'blood_steel','b',0,0,'none',0,0.00000,-8,216,20,0,0,0,-1,545000,72,'true','true','true','true',0,0,0,0,0,0,0,0,0,'0-0;'),
(670,'Shield of Bravery','lhand','true',560,0,0,'chrysolite','b',0,0,'none',0,0.00000,-8,230,20,0,0,0,-1,845000,112,'true','true','true','true',0,0,0,0,0,0,0,0,0,'0-0;'),
(671,'Blood Shield','lhand','true',480,0,0,'blood_steel','b',0,0,'none',0,0.00000,-8,216,20,0,0,0,-1,545000,72,'true','true','true','true',0,0,0,0,0,0,0,0,0,'0-0;'),
(672,'Absolute Shield','lhand','true',560,0,0,'mithril','b',0,0,'none',0,0.00000,-8,230,20,0,0,0,-1,845000,112,'true','true','true','true',0,0,0,0,0,0,0,0,0,'0-0;'),
(673,'Avadon Shield','lhand','true',1210,0,0,'damascus','b',0,0,'none',0,0.00000,-8,216,20,0,0,0,-1,545000,72,'true','true','true','true',0,0,0,0,0,0,0,0,0,'0-0;'),
(674,'Divine Shield','lhand','true',560,0,0,'adamantaite','b',0,0,'none',0,0.00000,-8,230,20,0,0,0,-1,845000,112,'true','true','true','true',0,0,0,0,0,0,0,0,0,'0-0;'),
(738,'Sword of Solidarity','rhand','false',1300,1,1,'bronze','none',12,10,'sword',8,0.00000,0,0,0,379,0,9,-1,18500,0,'true','true','true','true',0,0,0,0,0,0,0,0,0,'0-0;'),
(743,'Sword of Sentinel','rhand','false',1300,1,1,'steel','none',14,10,'sword',8,0.00000,0,0,0,379,0,11,-1,33600,0,'true','true','true','true',0,0,0,0,0,0,0,0,0,'0-0;'),
(744,'Staff of Sentinel','lrhand','false',1800,1,1,'wood','none',13,20,'bigblunt',4,4.00000,0,0,0,325,0,14,-1,33600,0,'true','true','true','true',0,0,0,0,0,0,0,0,0,'0-0;'),
(747,'Wand of Adept','rhand','false',1300,1,1,'wood','none',11,20,'blunt',4,4.00000,0,0,0,379,0,13,-1,25500,0,'true','true','true','true',0,0,0,0,0,0,0,0,0,'0-0;'),
(748,'Gallint''s Oak Wand','rhand','false',1350,1,1,'wood','none',10,20,'blunt',4,4.00000,0,0,0,325,0,10,-1,0,0,'false','false','true','false',0,0,0,0,0,0,0,0,0,'0-0;'),
(749,'0','lrhand','true',100,0,0,'wood','d',21,20,'bigblunt',4,4.00000,0,0,0,325,0,32,-1,35800,5,'true','false','true','true',0,0,0,0,0,0,0,0,0,'0-0;'),
(754,'Red Sunset Staff','lrhand','false',1700,1,1,'wood','none',13,20,'bigblunt',4,4.00000,0,0,0,325,0,13,-1,25500,0,'true','true','true','true',0,0,0,0,0,0,0,0,0,'0-0;'),
(945,'Skeleton Buckler','lhand','false',1400,0,0,'wood','none',0,0,'none',0,0.00000,-8,69,20,0,0,0,-1,3440,0,'true','true','true','true',0,0,0,0,0,0,0,0,0,'0-0;'),
(946,'Skeleton Dagger','rhand','false',1100,2,2,'steel','none',16,5,'dagger',12,-3.00000,0,0,0,433,0,13,-1,66600,0,'true','true','true','true',0,0,0,0,0,0,0,0,0,'0-0;'),
(975,'Blood Saber','rhand','false',1450,1,1,'oriharukon','none',14,10,'sword',8,0.00000,0,0,0,379,0,11,-1,33600,0,'true','true','true','true',0,0,0,0,0,0,0,0,0,'0-0;'),
(981,'Red Sunset Sword','lrhand','false',1300,1,1,'steel','none',16,10,'bigsword',8,0.00000,0,0,0,325,0,10,-1,25500,0,'true','true','true','true',0,0,0,0,0,0,0,0,0,'0-0;'),
(989,'Eldritch Dagger','rhand','false',1130,1,1,'steel','none',11,5,'dagger',12,-3.00000,0,0,0,433,0,10,-1,25500,0,'true','true','true','true',0,0,0,0,0,0,0,0,0,'0-0;'),
(1142,'Rusted Bronze Sword','rhand','false',1400,2,2,'steel','none',18,10,'sword',8,0.00000,0,0,0,379,0,21,-1,0,0,'false','false','true','false',0,0,0,0,0,0,0,0,0,'0-0;'),
(1181,'Neti''s Bow','lrhand','false',1850,7,2,'wood','none',45,5,'bow',12,-3.00000,0,0,0,293,2,16,-1,0,0,'false','false','true','false',0,0,0,0,0,0,0,0,0,'0-0;'),
(1182,'Neti''s Dagger','rhand','false',1000,2,2,'steel','none',19,5,'dagger',12,-3.00000,0,0,0,433,0,16,-1,0,0,'false','false','true','false',0,0,0,0,0,0,0,0,0,'0-0;'),
(1213,'Guard''s Bow','lrhand','false',1800,7,2,'steel','none',49,5,'bow',12,-3.00000,0,0,0,293,3,17,-1,136000,0,'false','false','true','false',0,0,0,0,0,0,0,0,0,'0-0;'),
(1295,'Long Sword','rhand','false',200,2,2,'fine_steel','none',22,10,'sword',8,0.00000,0,0,0,379,0,6,-1,66600,0,'false','true','true','false',0,0,0,0,0,0,0,0,0,'0-0;'),
(1296,'Gladius','rhand','false',300,2,2,'steel','none',22,10,'sword',8,0.00000,0,0,0,379,0,6,-1,66600,0,'false','true','true','false',0,0,0,0,0,0,0,0,0,'0-0;'),
(1297,'Bastard Sword','rhand','false',400,2,2,'fine_steel','none',22,10,'sword',8,0.00000,0,0,0,379,0,6,-1,66600,0,'false','true','true','false',0,0,0,0,0,0,0,0,0,'0-0;'),
(1298,'Caliburs','rhand','false',500,2,2,'oriharukon','none',22,10,'sword',8,0.00000,0,0,0,379,0,6,-1,66600,0,'false','true','true','false',0,0,0,0,0,0,0,0,0,'0-0;'),
(1299,'Great Sword','lrhand','false',500,3,3,'steel','none',200,10,'dual',8,0.00000,0,0,0,325,0,6,-1,3340000,0,'false','true','true','false',0,0,0,0,0,0,0,0,0,'0-0;'),
(1300,'Apprentice''s Rod','rhand','false',80,2,2,'wood','none',22,20,'blunt',4,4.00000,0,0,0,379,0,6,-1,66600,0,'false','true','true','false',0,0,0,0,0,0,0,0,0,'0-0;'),
(1301,'Big Hammer','rhand','false',300,2,2,'fine_steel','none',22,20,'blunt',4,4.00000,0,0,0,379,0,6,-1,66600,0,'false','true','true','false',0,0,0,0,0,0,0,0,0,'0-0;'),
(1302,'Bec de Corbin','lrhand','false',750,2,2,'fine_steel','none',22,10,'pole',8,-3.00000,0,0,0,325,0,6,-1,66600,0,'false','true','true','false',0,0,0,0,0,0,0,0,0,'0-0;'),
(1303,'Lance','lrhand','false',750,2,2,'fine_steel','none',1,10,'pole',8,-3.00000,0,0,0,325,0,6,-1,66600,0,'false','true','true','false',0,0,0,0,0,0,0,0,0,'0-0;'),
(1304,'Conjuror''s Staff','lrhand','false',150,2,2,'oriharukon','none',15,20,'bigblunt',4,4.00000,0,0,0,325,0,17,-1,66600,0,'false','true','true','false',0,0,0,0,0,0,0,0,0,'0-0;'),
(1305,'Knife','rhand','false',120,2,2,'bronze','none',1,5,'dagger',12,-3.00000,0,0,0,433,0,6,-1,66600,0,'false','true','true','false',0,0,0,0,0,0,0,0,0,'0-0;'),
(1306,'Crafted Dagger','rhand','false',100,2,2,'chrysolite','none',22,5,'dagger',12,-3.00000,0,0,0,433,0,6,-1,66600,0,'false','true','true','false',0,0,0,0,0,0,0,0,0,'0-0;'),
(1307,'Bow','lrhand','false',150,9,3,'wood','none',120,5,'bow',12,-3.00000,0,0,0,293,7,6,-1,3340000,0,'false','true','true','false',0,0,0,0,0,0,0,0,0,'0-0;'),
(1328,'Shield of Grace','lhand','false',300,0,0,'mithril','none',0,0,'none',0,0.00000,-8,71,20,0,0,0,-1,1090000,0,'false','true','true','false',0,0,0,0,0,0,0,0,0,'0-0;'),
(1329,'Shield of Victory','lhand','false',350,0,0,'adamantaite','none',0,0,'none',0,0.00000,-8,71,20,0,0,0,-1,1430000,0,'false','true','true','false',0,0,0,0,0,0,0,0,0,'0-0;'),
(1330,'Zubei''s Shield','lhand','false',500,0,0,'mithril','none',0,0,'none',0,0.00000,-8,71,20,0,0,0,-1,1850000,0,'false','true','true','false',0,0,0,0,0,0,0,0,0,'0-0;'),
(1331,'Otherworldly Shield','lhand','false',350,0,0,'adamantaite','none',0,0,'none',0,0.00000,-8,71,20,0,0,0,-1,1430000,0,'false','true','true','false',0,0,0,0,0,0,0,0,0,'0-0;'),
(1332,'Knight''s Shield','lhand','false',500,0,0,'fine_steel','none',0,0,'none',0,0.00000,-8,71,20,0,0,0,-1,321000,0,'false','true','true','false',0,0,0,0,0,0,0,0,0,'0-0;'),
(1333,'Brandish','lrhand','false',2250,2,2,'steel','none',21,10,'bigsword',8,0.00000,0,0,0,325,0,12,-1,54100,0,'true','true','true','true',0,0,0,0,0,0,0,0,0,'0-0;'),
(1376,'Guard Spear','lrhand','true',300,2,2,'bronze','d',50,10,'pole',8,-3.00000,0,0,0,325,0,26,-1,409000,743,'true','true','true','true',0,0,0,0,0,0,0,0,0,'0-0;'),
(1471,'Silenos Blowgun','rhand','true',300,2,2,'steel','d',5,5,'dagger',12,-3.00000,0,0,0,433,0,5,-1,409000,743,'true','true','true','true',0,0,0,0,0,0,0,0,0,'0-0;'),
(1472,'Dreadbane','lrhand','true',300,2,2,'bronze','d',50,10,'pole',8,-3.00000,0,0,0,325,0,26,-1,409000,743,'true','true','true','true',0,0,0,0,0,0,0,0,0,'0-0;'),
(1510,'Butcher''s Sword','rhand','false',1450,1,1,'steel','none',13,10,'sword',8,0.00000,0,0,0,379,0,10,-1,25500,0,'true','true','true','true',0,0,0,0,0,0,0,0,0,'0-0;'),
(1511,'Silversmith Hammer','rhand','false',1860,1,1,'steel','none',13,20,'blunt',4,4.00000,0,0,0,379,0,10,-1,25500,0,'true','true','true','true',0,0,0,0,0,0,0,0,0,'0-0;'),
(1660,'Cursed Maingauche','rhand','true',1070,3,3,'fine_steel','d',62,5,'dagger',12,-3.00000,0,0,0,433,0,42,-1,1400000,2545,'true','true','true','true',0,0,0,0,0,0,0,0,0,'0-0;'),
(2368,'Training Gloves','lrhand','false',1580,1,1,'cloth','none',7,5,'dualfist',4,4.00000,0,0,0,325,0,5,-1,138,0,'false','false','true','false',0,0,0,0,0,0,0,0,0,'0-0;'),
(2369,'Squire''s Sword','rhand','false',1600,1,1,'steel','none',6,10,'sword',8,0.00000,0,0,0,379,0,5,-1,138,0,'false','false','true','false',0,0,0,0,0,0,0,0,0,'0-0;'),
(2370,'Guild Member''s Club','rhand','false',1910,1,1,'wood','none',6,20,'blunt',4,4.00000,0,0,0,379,0,5,-1,138,0,'false','false','true','false',0,0,0,0,0,0,0,0,0,'0-0;'),
(2371,'Fist of Butcher','lrhand','false',1400,1,1,'steel','none',16,5,'dualfist',4,4.00000,0,0,0,325,0,10,-1,25500,0,'true','true','true','true',0,0,0,0,0,0,0,0,0,'0-0;'),
(2372,'Dagger of Adept','rhand','false',1050,1,1,'steel','none',11,5,'dagger',12,-3.00000,0,0,0,433,0,10,-1,25500,0,'true','true','true','true',0,0,0,0,0,0,0,0,0,'0-0;'),
(2373,'Eldritch Staff','lrhand','false',1050,1,1,'wood','none',13,20,'bigblunt',4,4.00000,0,0,0,325,0,13,-1,25500,0,'true','true','true','true',0,0,0,0,0,0,0,0,0,'0-0;'),
(2374,'Red Sunset Dagger','rhand','false',1100,1,1,'steel','none',11,5,'dagger',12,-3.00000,0,0,0,433,0,10,-1,25500,0,'true','true','true','true',0,0,0,0,0,0,0,0,0,'0-0;'),
(2493,'Brigandine Shield','lhand','true',1320,0,0,'leather','d',0,0,'none',0,0.00000,-8,142,20,0,0,0,-1,78400,142,'true','true','true','true',0,0,0,0,0,0,0,0,0,'0-0;'),
(2494,'Plate Shield','lhand','true',1310,0,0,'leather','d',0,0,'none',0,0.00000,-8,154,20,0,0,0,-1,103000,187,'true','true','true','true',0,0,0,0,0,0,0,0,0,'0-0;'),
(2495,'Chain Shield','lhand','true',1280,0,0,'leather','c',0,0,'none',0,0.00000,-8,166,20,0,0,0,-1,133000,53,'true','true','true','true',0,0,0,0,0,0,0,0,0,'0-0;'),
(2496,'Dwarven Chain Shield','lhand','true',1280,0,0,'leather','c',0,0,'none',0,0.00000,-8,174,20,0,0,0,-1,156000,62,'true','true','true','true',0,0,0,0,0,0,0,0,0,'0-0;'),
(2497,'Full Plate Shield','lhand','true',1220,0,0,'leather','c',0,0,'none',0,0.00000,-8,203,20,0,0,0,-1,375000,150,'true','true','true','true',0,0,0,0,0,0,0,0,0,'0-0;'),
(2498,'Shield of Nightmare','lhand','true',1180,0,0,'leather','a',0,0,'none',0,0.00000,-8,256,20,0,0,0,-1,1850000,148,'true','true','true','true',0,0,0,0,0,0,0,0,0,'0-0;'),
(2499,'Elven Long Sword','rhand','true',1440,3,3,'fine_steel','d',92,10,'sword',8,0.00000,0,0,0,379,0,54,-1,1800000,3272,'true','true','true','true',0,0,0,0,0,0,0,0,9225,'0-0;'),
(2500,'Dark Legion''s Edge','rhand','true',1320,1,1,'fine_steel','a',232,10,'sword',8,0.00000,0,0,0,379,0,114,-1,27000000,2160,'true','true','true','true',0,0,0,0,0,0,0,0,9340,'0-0;'),
(2501,'Bone Club','rhand','false',1850,2,2,'fine_steel','none',24,20,'blunt',4,4.00000,0,0,0,379,0,17,-1,136000,0,'true','true','true','true',0,0,0,0,0,0,0,0,0,'0-0;'),
(2502,'Dwarven War Hammer','rhand','true',1670,2,2,'fine_steel','c',122,20,'blunt',4,4.00000,0,0,0,379,0,68,-1,2870000,1148,'true','true','true','true',0,0,0,0,0,0,0,0,0,'0-0;'),
(2503,'Yaksa Mace','rhand','true',1640,3,3,'fine_steel','c',156,20,'blunt',4,4.00000,0,0,0,379,0,83,-1,6130000,2452,'true','true','true','true',0,0,0,0,0,0,0,0,0,'0-0;'),
(2504,'Meteor Shower','rhand','true',1600,1,1,'fine_steel','a',213,20,'blunt',4,4.00000,0,0,0,379,0,107,-1,18300000,1464,'true','true','true','true',0,0,0,0,0,0,0,0,0,'0-0;'),
(2505,'Iron Canine','wolf','false',100,1,1,'steel','none',4,10,'pet',8,0.00000,0,0,0,277,0,5,-1,14000,0,'true','true','true','true',0,0,0,0,0,0,0,0,0,'0-0;'),
(2507,'Lizardspear','rhand','false',300,2,2,'steel','d',5,5,'dagger',12,-3.00000,0,0,0,433,0,5,-1,409000,743,'true','true','true','true',0,0,0,0,0,0,0,0,0,'0-0;'),
(2516,'Saber*Saber','lrhand','true',2530,2,2,'fine_steel','d',73,10,'dual',8,0.00000,0,0,0,325,0,37,-1,877000,1594,'true','true','true','true',0,0,0,0,0,0,0,0,0,'0-0;'),
(2517,'Saber*Bastard Sword','lrhand','true',2520,3,3,'fine_steel','d',83,10,'dual',8,0.00000,0,0,0,325,0,41,-1,1060000,1927,'true','true','true','true',0,0,0,0,0,0,0,0,0,'0-0;'),
(2518,'Saber*Spinebone Sword','lrhand','true',2530,3,3,'fine_steel','d',83,10,'dual',8,0.00000,0,0,0,325,0,41,-1,1060000,1927,'true','true','true','true',0,0,0,0,0,0,0,0,0,'0-0;'),
(2519,'Saber*Artisan''s Sword','lrhand','true',2520,3,3,'fine_steel','d',83,10,'dual',8,0.00000,0,0,0,325,0,41,-1,1060000,1927,'true','true','true','true',0,0,0,0,0,0,0,0,0,'0-0;'),
(2520,'Saber*Knight''s Sword','lrhand','true',2510,3,3,'fine_steel','d',83,10,'dual',8,0.00000,0,0,0,325,0,41,-1,1060000,1927,'true','true','true','true',0,0,0,0,0,0,0,0,0,'0-0;'),
(2521,'Saber*Crimson Sword','lrhand','true',2530,3,3,'fine_steel','d',96,10,'dual',8,0.00000,0,0,0,325,0,47,-1,1400000,2545,'true','true','true','true',0,0,0,0,0,0,0,0,0,'0-0;'),
(2522,'Saber*Elven Sword','lrhand','true',2510,3,3,'fine_steel','d',96,10,'dual',8,0.00000,0,0,0,325,0,47,-1,1400000,2545,'true','true','true','true',0,0,0,0,0,0,0,0,0,'0-0;'),
(2523,'Saber*Sword of Revolution','lrhand','true',2420,2,2,'fine_steel','c',118,10,'dual',8,0.00000,0,0,0,325,0,56,-1,1960000,784,'true','true','true','true',0,0,0,0,0,0,0,0,0,'0-0;'),
(2524,'Saber*Elven Long Sword','lrhand','true',2420,2,2,'fine_steel','c',130,10,'dual',8,0.00000,0,0,0,325,0,61,-1,2290000,916,'true','true','true','true',0,0,0,0,0,0,0,0,0,'0-0;'),
(2525,'Bastard Sword*Bastard Sword','lrhand','true',2470,3,3,'fine_steel','d',96,10,'dual',8,0.00000,0,0,0,325,0,47,-1,1400000,2545,'true','true','true','true',0,0,0,0,0,0,0,0,0,'0-0;'),
(2526,'Bastard Sword*Spinebone Sword','lrhand','true',2470,3,3,'fine_steel','d',96,10,'dual',8,0.00000,0,0,0,325,0,47,-1,1400000,2545,'true','true','true','true',0,0,0,0,0,0,0,0,0,'0-0;'),
(2527,'Bastard Sword*Artisan''s Sword','lrhand','true',2480,3,3,'fine_steel','d',96,10,'dual',8,0.00000,0,0,0,325,0,47,-1,1400000,2545,'true','true','true','true',0,0,0,0,0,0,0,0,0,'0-0;'),
(2528,'Bastard Sword*Knight''s Sword','lrhand','true',2500,3,3,'fine_steel','d',96,10,'dual',8,0.00000,0,0,0,325,0,47,-1,1400000,2545,'true','true','true','true',0,0,0,0,0,0,0,0,0,'0-0;'),
(2529,'Bastard Sword*Crimson Sword','lrhand','true',2470,3,3,'fine_steel','d',107,10,'dual',8,0.00000,0,0,0,325,0,51,-1,1660000,3018,'true','true','true','true',0,0,0,0,0,0,0,0,0,'0-0;'),
(2530,'Bastard Sword*Elven Sword','lrhand','true',2460,3,3,'fine_steel','d',107,10,'dual',8,0.00000,0,0,0,325,0,51,-1,1660000,3018,'true','true','true','true',0,0,0,0,0,0,0,0,0,'0-0;'),
(2531,'Bastard Sword*Sword of Revolution','lrhand','true',2450,2,2,'fine_steel','c',124,10,'dual',8,0.00000,0,0,0,325,0,58,-1,2120000,848,'true','true','true','true',0,0,0,0,0,0,0,0,0,'0-0;'),
(2532,'Bastard Sword*Elven Long Sword','lrhand','true',2430,2,2,'fine_steel','c',136,10,'dual',8,0.00000,0,0,0,325,0,63,-1,2470000,988,'true','true','true','true',0,0,0,0,0,0,0,0,0,'0-0;'),
(2533,'Spinebone Sword*Spinebone Sword','lrhand','true',2520,3,3,'fine_steel','d',96,10,'dual',8,0.00000,0,0,0,325,0,47,-1,1400000,2545,'true','true','true','true',0,0,0,0,0,0,0,0,0,'0-0;'),
(2534,'Spinebone Sword*Artisan''s Sword','lrhand','true',2460,3,3,'fine_steel','d',96,10,'dual',8,0.00000,0,0,0,325,0,47,-1,1400000,2545,'true','true','true','true',0,0,0,0,0,0,0,0,0,'0-0;'),
(2535,'Spinebone Sword*Knight''s Sword','lrhand','true',2470,3,3,'fine_steel','d',96,10,'dual',8,0.00000,0,0,0,325,0,47,-1,1400000,2545,'true','true','true','true',0,0,0,0,0,0,0,0,0,'0-0;'),
(2536,'Spinebone Sword*Crimson Sword','lrhand','true',2520,3,3,'fine_steel','d',107,10,'dual',8,0.00000,0,0,0,325,0,51,-1,1660000,3018,'true','true','true','true',0,0,0,0,0,0,0,0,0,'0-0;'),
(2537,'Spinebone Sword*Elven Sword','lrhand','true',2460,3,3,'fine_steel','d',107,10,'dual',8,0.00000,0,0,0,325,0,51,-1,1660000,3018,'true','true','true','true',0,0,0,0,0,0,0,0,0,'0-0;'),
(2538,'Spinebone Sword*Sword of Revolution','lrhand','true',2460,2,2,'fine_steel','c',124,10,'dual',8,0.00000,0,0,0,325,0,58,-1,2120000,848,'true','true','true','true',0,0,0,0,0,0,0,0,0,'0-0;'),
(2539,'Spinebone Sword*Elven Long Sword','lrhand','true',2390,2,2,'fine_steel','c',136,10,'dual',8,0.00000,0,0,0,325,0,63,-1,2470000,988,'true','true','true','true',0,0,0,0,0,0,0,0,0,'0-0;'),
(2540,'Artisan''s Sword*Artisan''s Sword','lrhand','true',2480,3,3,'fine_steel','d',96,10,'dual',8,0.00000,0,0,0,325,0,47,-1,1400000,2545,'true','true','true','true',0,0,0,0,0,0,0,0,0,'0-0;'),
(2541,'Artisan''s Sword*Knight''s Sword','lrhand','true',2470,3,3,'fine_steel','d',96,10,'dual',8,0.00000,0,0,0,325,0,47,-1,1400000,2545,'true','true','true','true',0,0,0,0,0,0,0,0,0,'0-0;'),
(2542,'Artisan''s Sword*Crimson Sword','lrhand','true',2450,3,3,'fine_steel','d',107,10,'dual',8,0.00000,0,0,0,325,0,51,-1,1660000,3018,'true','true','true','true',0,0,0,0,0,0,0,0,0,'0-0;'),
(2543,'Artisan''s Sword*Elven Sword','lrhand','true',2470,3,3,'fine_steel','d',107,10,'dual',8,0.00000,0,0,0,325,0,51,-1,1660000,3018,'true','true','true','true',0,0,0,0,0,0,0,0,0,'0-0;'),
(2544,'Artisan''s Sword*Sword of Revolution','lrhand','true',2420,2,2,'fine_steel','c',124,10,'dual',8,0.00000,0,0,0,325,0,58,-1,2120000,848,'true','true','true','true',0,0,0,0,0,0,0,0,0,'0-0;'),
(2545,'Artisan''s Sword*Elven Long Sword','lrhand','true',2410,2,2,'fine_steel','c',136,10,'dual',8,0.00000,0,0,0,325,0,63,-1,2470000,988,'true','true','true','true',0,0,0,0,0,0,0,0,0,'0-0;'),
(2546,'Knight''s Sword*Knight''s Sword','lrhand','true',2460,3,3,'fine_steel','d',96,10,'dual',8,0.00000,0,0,0,325,0,47,-1,1400000,2545,'true','true','true','true',0,0,0,0,0,0,0,0,0,'0-0;'),
(2547,'Knight''s Sword*Crimson Sword','lrhand','true',2460,3,3,'fine_steel','d',107,10,'dual',8,0.00000,0,0,0,325,0,51,-1,1660000,3018,'true','true','true','true',0,0,0,0,0,0,0,0,0,'0-0;'),
(2548,'Knight''s Sword*Elven Sword','lrhand','true',2450,3,3,'fine_steel','d',107,10,'dual',8,0.00000,0,0,0,325,0,51,-1,1660000,3018,'true','true','true','true',0,0,0,0,0,0,0,0,0,'0-0;'),
(2549,'Knight''s Sword*Sword of Revolution','lrhand','true',2430,2,2,'fine_steel','c',124,10,'dual',8,0.00000,0,0,0,325,0,58,-1,2120000,848,'true','true','true','true',0,0,0,0,0,0,0,0,0,'0-0;'),
(2550,'Knight''s Sword*Elven Long Sword','lrhand','true',2370,2,2,'fine_steel','c',136,10,'dual',8,0.00000,0,0,0,325,0,63,-1,2470000,988,'true','true','true','true',0,0,0,0,0,0,0,0,0,'0-0;'),
(2551,'Crimson Sword*Crimson Sword','lrhand','true',2440,2,2,'fine_steel','c',118,10,'dual',8,0.00000,0,0,0,325,0,56,-1,1960000,784,'true','true','true','true',0,0,0,0,0,0,0,0,0,'0-0;'),
(2552,'Crimson Sword*Elven Sword','lrhand','true',2450,2,2,'fine_steel','c',118,10,'dual',8,0.00000,0,0,0,325,0,56,-1,1960000,784,'true','true','true','true',0,0,0,0,0,0,0,0,0,'0-0;'),
(2553,'Crimson Sword*Sword of Revolution','lrhand','true',2390,2,2,'fine_steel','c',136,10,'dual',8,0.00000,0,0,0,325,0,63,-1,2470000,988,'true','true','true','true',0,0,0,0,0,0,0,0,0,'0-0;'),
(2554,'Crimson Sword*Elven Long Sword','lrhand','true',2360,2,2,'fine_steel','c',148,10,'dual',8,0.00000,0,0,0,325,0,68,-1,2870000,1148,'true','true','true','true',0,0,0,0,0,0,0,0,0,'0-0;'),
(2555,'Elven Sword*Elven Sword','lrhand','true',2440,2,2,'fine_steel','c',118,10,'dual',8,0.00000,0,0,0,325,0,56,-1,1960000,784,'true','true','true','true',0,0,0,0,0,0,0,0,0,'0-0;'),
(2556,'Elven Sword*Sword of Revolution','lrhand','true',2410,2,2,'fine_steel','c',136,10,'dual',8,0.00000,0,0,0,325,0,63,-1,2470000,988,'true','true','true','true',0,0,0,0,0,0,0,0,0,'0-0;'),
(2557,'Elven Sword*Elven Long Sword','lrhand','true',2410,2,2,'fine_steel','c',148,10,'dual',8,0.00000,0,0,0,325,0,68,-1,2870000,1148,'true','true','true','true',0,0,0,0,0,0,0,0,0,'0-0;'),
(2558,'Sword of Revolution*Sword of Revolution','lrhand','true',2360,2,2,'fine_steel','c',148,10,'dual',8,0.00000,0,0,0,325,0,68,-1,2870000,1148,'true','true','true','true',0,0,0,0,0,0,0,0,0,'0-0;'),
(2559,'Sword of Revolution*Elven Long Sword','lrhand','true',2340,3,3,'fine_steel','c',155,10,'dual',8,0.00000,0,0,0,325,0,70,-1,3340000,1336,'true','true','true','true',0,0,0,0,0,0,0,0,0,'0-0;'),
(2560,'Elven Long Sword*Elven Long Sword','lrhand','true',2340,3,3,'fine_steel','c',162,10,'dual',8,0.00000,0,0,0,325,0,73,-1,3820000,1528,'true','true','true','true',0,0,0,0,0,0,0,0,0,'0-0;'),
(2561,'Stormbringer*Stormbringer','lrhand','true',2330,3,3,'fine_steel','c',175,10,'dual',8,0.00000,0,0,0,325,0,78,-1,4780000,1912,'true','true','true','true',0,0,0,0,0,0,0,0,0,'0-0;'),
(2562,'Stormbringer*Shamshir','lrhand','true',2300,3,3,'fine_steel','c',183,10,'dual',8,0.00000,0,0,0,325,0,81,-1,5280000,2112,'true','true','true','true',0,0,0,0,0,0,0,0,0,'0-0;'),
(2563,'Stormbringer*Katana','lrhand','true',2320,3,3,'fine_steel','c',183,10,'dual',8,0.00000,0,0,0,325,0,81,-1,5280000,2112,'true','true','true','true',0,0,0,0,0,0,0,0,0,'0-0;'),
(2564,'Stormbringer*Spirit Sword','lrhand','true',2310,3,3,'fine_steel','c',183,10,'dual',8,0.00000,0,0,0,325,0,81,-1,5280000,2112,'true','true','true','true',0,0,0,0,0,0,0,0,0,'0-0;'),
(2565,'Stormbringer*Raid Sword','lrhand','true',2340,3,3,'fine_steel','c',183,10,'dual',8,0.00000,0,0,0,325,0,81,-1,5280000,2112,'true','true','true','true',0,0,0,0,0,0,0,0,0,'0-0;'),
(2566,'Stormbringer*Caliburs','lrhand','true',2260,1,1,'fine_steel','b',197,10,'dual',8,0.00000,0,0,0,325,0,86,-1,6980000,930,'true','true','true','true',0,0,0,0,0,0,0,0,0,'0-0;'),
(2567,'Stormbringer*Sword of Limit','lrhand','true',2240,1,1,'fine_steel','b',197,10,'dual',8,0.00000,0,0,0,325,0,86,-1,6980000,930,'true','true','true','true',0,0,0,0,0,0,0,0,0,'0-0;'),
(2568,'Stormbringer*Sword of Delusion','lrhand','true',2230,1,1,'fine_steel','b',197,10,'dual',8,0.00000,0,0,0,325,0,86,-1,6980000,930,'true','true','true','true',0,0,0,0,0,0,0,0,0,'0-0;'),
(2569,'Stormbringer*Sword of Nightmare','lrhand','true',2250,1,1,'fine_steel','b',197,10,'dual',8,0.00000,0,0,0,325,0,86,-1,6980000,930,'true','true','true','true',0,0,0,0,0,0,0,0,0,'0-0;'),
(2570,'Stormbringer*Tsurugi','lrhand','true',2220,1,1,'fine_steel','b',197,10,'dual',8,0.00000,0,0,0,325,0,86,-1,6980000,930,'true','true','true','true',0,0,0,0,0,0,0,0,0,'0-0;'),
(2571,'Stormbringer*Samurai Long sword','lrhand','true',2150,1,1,'fine_steel','b',213,10,'dual',8,0.00000,0,0,0,325,0,91,-1,8680000,1157,'true','true','true','true',0,0,0,0,0,0,0,0,0,'0-0;'),
(2572,'Shamshir*Shamshir','lrhand','true',2330,3,3,'fine_steel','c',190,10,'dual',8,0.00000,0,0,0,325,0,83,-1,6130000,2452,'true','true','true','true',0,0,0,0,0,0,0,0,0,'0-0;'),
(2573,'Shamshir*Katana','lrhand','true',2310,3,3,'fine_steel','c',190,10,'dual',8,0.00000,0,0,0,325,0,83,-1,6130000,2452,'true','true','true','true',0,0,0,0,0,0,0,0,0,'0-0;'),
(2574,'Shamshir*Spirit Sword','lrhand','true',2280,3,3,'fine_steel','c',190,10,'dual',8,0.00000,0,0,0,325,0,83,-1,6130000,2452,'true','true','true','true',0,0,0,0,0,0,0,0,0,'0-0;'),
(2575,'Shamshir*Raid Sword','lrhand','true',2280,3,3,'fine_steel','c',190,10,'dual',8,0.00000,0,0,0,325,0,83,-1,6130000,2452,'true','true','true','true',0,0,0,0,0,0,0,0,0,'0-0;'),
(2576,'Shamshir*Caliburs','lrhand','true',2230,1,1,'fine_steel','b',204,10,'dual',8,0.00000,0,0,0,325,0,89,-1,7830000,1044,'true','true','true','true',0,0,0,0,0,0,0,0,0,'0-0;'),
(2577,'Shamshir*Sword of Limit','lrhand','true',2240,1,1,'fine_steel','b',204,10,'dual',8,0.00000,0,0,0,325,0,89,-1,7830000,1044,'true','true','true','true',0,0,0,0,0,0,0,0,0,'0-0;'),
(2578,'Shamshir*Sword of Delusion','lrhand','true',2200,1,1,'fine_steel','b',204,10,'dual',8,0.00000,0,0,0,325,0,89,-1,7830000,1044,'true','true','true','true',0,0,0,0,0,0,0,0,0,'0-0;'),
(2579,'Shamshir*Sword of Nightmare','lrhand','true',2210,1,1,'fine_steel','b',204,10,'dual',8,0.00000,0,0,0,325,0,89,-1,7830000,1044,'true','true','true','true',0,0,0,0,0,0,0,0,0,'0-0;'),
(2580,'Shamshir*Tsurugi','lrhand','true',2220,1,1,'fine_steel','b',204,10,'dual',8,0.00000,0,0,0,325,0,89,-1,7830000,1044,'true','true','true','true',0,0,0,0,0,0,0,0,0,'0-0;'),
(2581,'Shamshir*Samurai Long Sword','lrhand','true',2110,1,1,'fine_steel','b',220,10,'dual',8,0.00000,0,0,0,325,0,94,-1,9550000,1273,'true','true','true','true',0,0,0,0,0,0,0,0,0,'0-0;'),
(2582,'Katana*Katana','lrhand','true',2270,3,3,'fine_steel','c',190,10,'dual',8,0.00000,0,0,0,325,0,83,-1,6130000,2452,'true','true','true','true',0,0,0,0,0,0,0,0,0,'0-0;'),
(2583,'Katana*Spirit Sword','lrhand','true',2250,3,3,'fine_steel','c',190,10,'dual',8,0.00000,0,0,0,325,0,83,-1,6130000,2452,'true','true','true','true',0,0,0,0,0,0,0,0,0,'0-0;'),
(2584,'Katana*Raid Sword','lrhand','true',2270,3,3,'fine_steel','c',190,10,'dual',8,0.00000,0,0,0,325,0,83,-1,6130000,2452,'true','true','true','true',0,0,0,0,0,0,0,0,0,'0-0;'),
(2585,'Katana*Caliburs','lrhand','true',2220,1,1,'fine_steel','b',204,10,'dual',8,0.00000,0,0,0,325,0,89,-1,7830000,1044,'true','true','true','true',0,0,0,0,0,0,0,0,0,'0-0;'),
(2586,'Katana*Sword of Limit','lrhand','true',2180,1,1,'fine_steel','b',204,10,'dual',8,0.00000,0,0,0,325,0,89,-1,7830000,1044,'true','true','true','true',0,0,0,0,0,0,0,0,0,'0-0;'),
(2587,'Katana*Sword of Delusion','lrhand','true',2190,1,1,'fine_steel','b',204,10,'dual',8,0.00000,0,0,0,325,0,89,-1,7830000,1044,'true','true','true','true',0,0,0,0,0,0,0,0,0,'0-0;'),
(2588,'Katana*Sword of Nightmare','lrhand','true',2170,1,1,'fine_steel','b',204,10,'dual',8,0.00000,0,0,0,325,0,89,-1,7830000,1044,'true','true','true','true',0,0,0,0,0,0,0,0,0,'0-0;'),
(2589,'Katana*Tsurugi','lrhand','true',2210,1,1,'fine_steel','b',204,10,'dual',8,0.00000,0,0,0,325,0,89,-1,7830000,1044,'true','true','true','true',0,0,0,0,0,0,0,0,0,'0-0;'),
(2590,'Katana*Samurai Long Sword','lrhand','true',2130,1,1,'fine_steel','b',220,10,'dual',8,0.00000,0,0,0,325,0,94,-1,9550000,1273,'true','true','true','true',0,0,0,0,0,0,0,0,0,'0-0;'),
(2591,'Spirit Sword*Spirit Sword','lrhand','true',2240,3,3,'fine_steel','c',190,10,'dual',8,0.00000,0,0,0,325,0,83,-1,6130000,2452,'true','true','true','true',0,0,0,0,0,0,0,0,0,'0-0;'),
(2592,'Spirit Sword*Raid Sword','lrhand','true',2260,3,3,'fine_steel','c',190,10,'dual',8,0.00000,0,0,0,325,0,83,-1,6130000,2452,'true','true','true','true',0,0,0,0,0,0,0,0,0,'0-0;'),
(2593,'Spirit Sword*Caliburs','lrhand','true',2240,1,1,'fine_steel','b',204,10,'dual',8,0.00000,0,0,0,325,0,89,-1,7830000,1044,'true','true','true','true',0,0,0,0,0,0,0,0,0,'0-0;'),
(2594,'Spirit Sword*Sword of Limit','lrhand','true',2240,1,1,'fine_steel','b',204,10,'dual',8,0.00000,0,0,0,325,0,89,-1,7830000,1044,'true','true','true','true',0,0,0,0,0,0,0,0,0,'0-0;'),
(2595,'Spirit Sword*Sword of Delusion','lrhand','true',2250,1,1,'fine_steel','b',204,10,'dual',8,0.00000,0,0,0,325,0,89,-1,7830000,1044,'true','true','true','true',0,0,0,0,0,0,0,0,0,'0-0;'),
(2596,'Spirit Sword*Sword of Nightmare','lrhand','true',2250,1,1,'fine_steel','b',204,10,'dual',8,0.00000,0,0,0,325,0,89,-1,7830000,1044,'true','true','true','true',0,0,0,0,0,0,0,0,0,'0-0;'),
(2597,'Spirit Sword*Tsurugi','lrhand','true',2220,1,1,'fine_steel','b',204,10,'dual',8,0.00000,0,0,0,325,0,89,-1,7830000,1044,'true','true','true','true',0,0,0,0,0,0,0,0,0,'0-0;'),
(2598,'Spirit Sword*Samurai Long Sword','lrhand','true',2110,1,1,'fine_steel','b',220,10,'dual',8,0.00000,0,0,0,325,0,94,-1,9550000,1273,'true','true','true','true',0,0,0,0,0,0,0,0,0,'0-0;'),
(2599,'Raid Sword*Raid Sword','lrhand','true',2250,3,3,'fine_steel','c',190,10,'dual',8,0.00000,0,0,0,325,0,83,-1,6130000,2452,'true','true','true','true',0,0,0,0,0,0,0,0,0,'0-0;'),
(2600,'Raid Sword*Caliburs','lrhand','true',2190,1,1,'fine_steel','b',204,10,'dual',8,0.00000,0,0,0,325,0,89,-1,7830000,1044,'true','true','true','true',0,0,0,0,0,0,0,0,0,'0-0;'),
(2601,'Raid Sword*Sword of Limit','lrhand','true',2170,1,1,'fine_steel','b',204,10,'dual',8,0.00000,0,0,0,325,0,89,-1,7830000,1044,'true','true','true','true',0,0,0,0,0,0,0,0,0,'0-0;'),
(2602,'Raid Sword*Sword of Delusion','lrhand','true',2180,1,1,'fine_steel','b',204,10,'dual',8,0.00000,0,0,0,325,0,89,-1,7830000,1044,'true','true','true','true',0,0,0,0,0,0,0,0,0,'0-0;'),
(2603,'Raid Sword*Sword of Nightmare','lrhand','true',2170,1,1,'fine_steel','b',204,10,'dual',8,0.00000,0,0,0,325,0,89,-1,7830000,1044,'true','true','true','true',0,0,0,0,0,0,0,0,0,'0-0;'),
(2604,'Raid Sword*Tsurugi','lrhand','true',2170,1,1,'fine_steel','b',204,10,'dual',8,0.00000,0,0,0,325,0,89,-1,7830000,1044,'true','true','true','true',0,0,0,0,0,0,0,0,0,'0-0;'),
(2605,'Raid Sword*Samurai Long Sword','lrhand','true',2130,1,1,'fine_steel','b',220,10,'dual',8,0.00000,0,0,0,325,0,94,-1,9550000,1273,'true','true','true','true',0,0,0,0,0,0,0,0,0,'0-0;'),
(2606,'Caliburs*Caliburs','lrhand','true',2140,1,1,'fine_steel','b',213,10,'dual',8,0.00000,0,0,0,325,0,91,-1,8680000,1157,'true','true','true','true',0,0,0,0,0,0,0,0,0,'0-0;'),
(2607,'Caliburs*Sword of Limit','lrhand','true',2150,1,1,'fine_steel','b',213,10,'dual',8,0.00000,0,0,0,325,0,91,-1,8680000,1157,'true','true','true','true',0,0,0,0,0,0,0,0,0,'0-0;'),
(2608,'Caliburs*Sword of Delusion','lrhand','true',2140,1,1,'fine_steel','b',213,10,'dual',8,0.00000,0,0,0,325,0,91,-1,8680000,1157,'true','true','true','true',0,0,0,0,0,0,0,0,0,'0-0;'),
(2609,'Caliburs*Sword of Nightmare','lrhand','true',2170,1,1,'fine_steel','b',213,10,'dual',8,0.00000,0,0,0,325,0,91,-1,8680000,1157,'true','true','true','true',0,0,0,0,0,0,0,0,0,'0-0;'),
(2610,'Caliburs*Tsurugi','lrhand','true',2150,1,1,'fine_steel','b',213,10,'dual',8,0.00000,0,0,0,325,0,91,-1,8680000,1157,'true','true','true','true',0,0,0,0,0,0,0,0,0,'0-0;'),
(2611,'Caliburs*Samurai Long Sword','lrhand','true',2120,1,1,'fine_steel','b',228,10,'dual',8,0.00000,0,0,0,325,0,97,-1,11300000,1506,'true','true','true','true',0,0,0,0,0,0,0,0,0,'0-0;'),
(2612,'Sword of Limit*Sword of Limit','lrhand','true',2140,1,1,'fine_steel','b',213,10,'dual',8,0.00000,0,0,0,325,0,91,-1,8680000,1157,'true','true','true','true',0,0,0,0,0,0,0,0,0,'0-0;'),
(2613,'Sword of Limit*Sword of Delusion','lrhand','true',2140,1,1,'fine_steel','b',213,10,'dual',8,0.00000,0,0,0,325,0,91,-1,8680000,1157,'true','true','true','true',0,0,0,0,0,0,0,0,0,'0-0;'),
(2614,'Sword of Limit*Sword of Nightmare','lrhand','true',2130,1,1,'fine_steel','b',213,10,'dual',8,0.00000,0,0,0,325,0,91,-1,8680000,1157,'true','true','true','true',0,0,0,0,0,0,0,0,0,'0-0;'),
(2615,'Sword of Limit*Tsurugi','lrhand','true',2120,1,1,'fine_steel','b',213,10,'dual',8,0.00000,0,0,0,325,0,91,-1,8680000,1157,'true','true','true','true',0,0,0,0,0,0,0,0,0,'0-0;'),
(2616,'Sword of Limit*Samurai Long Sword','lrhand','true',2100,1,1,'fine_steel','b',228,10,'dual',8,0.00000,0,0,0,325,0,97,-1,11300000,1506,'true','true','true','true',0,0,0,0,0,0,0,0,0,'0-0;'),
(2617,'Sword of Delusion*Sword of Delusion','lrhand','true',2150,1,1,'fine_steel','b',213,10,'dual',8,0.00000,0,0,0,325,0,91,-1,8680000,1157,'true','true','true','true',0,0,0,0,0,0,0,0,0,'0-0;'),
(2618,'Sword of Delusion*Sword of Nightmare','lrhand','true',2130,1,1,'fine_steel','b',213,10,'dual',8,0.00000,0,0,0,325,0,91,-1,8680000,1157,'true','true','true','true',0,0,0,0,0,0,0,0,0,'0-0;'),
(2619,'Sword of Delusion*Tsurugi','lrhand','true',2140,1,1,'fine_steel','b',213,10,'dual',8,0.00000,0,0,0,325,0,91,-1,8680000,1157,'true','true','true','true',0,0,0,0,0,0,0,0,0,'0-0;'),
(2620,'Sword of Delusion*Samurai Long Sword','lrhand','true',2110,1,1,'fine_steel','b',228,10,'dual',8,0.00000,0,0,0,325,0,97,-1,11300000,1506,'true','true','true','true',0,0,0,0,0,0,0,0,0,'0-0;'),
(2621,'Sword of Nightmare*Sword of Nightmare','lrhand','true',2130,1,1,'fine_steel','b',213,10,'dual',8,0.00000,0,0,0,325,0,91,-1,8680000,1157,'true','true','true','true',0,0,0,0,0,0,0,0,0,'0-0;'),
(2622,'Sword of Nightmare*Tsurugi','lrhand','true',2140,1,1,'fine_steel','b',213,10,'dual',8,0.00000,0,0,0,325,0,91,-1,8680000,1157,'true','true','true','true',0,0,0,0,0,0,0,0,0,'0-0;'),
(2623,'Sword of Nightmare*Samurai Long Sword','lrhand','true',2080,1,1,'fine_steel','b',228,10,'dual',8,0.00000,0,0,0,325,0,97,-1,11300000,1506,'true','true','true','true',0,0,0,0,0,0,0,0,0,'0-0;'),
(2624,'Tsurugi*Tsurugi','lrhand','true',2120,1,1,'fine_steel','b',213,10,'dual',8,0.00000,0,0,0,325,0,91,-1,8680000,1157,'true','true','true','true',0,0,0,0,0,0,0,0,0,'0-0;'),
(2625,'Tsurugi*Samurai Long Sword','lrhand','true',2090,1,1,'fine_steel','b',228,10,'dual',8,0.00000,0,0,0,325,0,97,-1,11300000,1506,'true','true','true','true',0,0,0,0,0,0,0,0,0,'0-0;'),
(2626,'Samurai Long Sword*Samurai Long Sword','lrhand','true',2080,1,1,'fine_steel','b',236,10,'dual',8,0.00000,0,0,0,325,0,99,-1,13100000,1746,'true','true','true','true',0,0,0,0,0,0,0,0,0,'0-0;'),
(2915,'Old Knight Sword','rhand','false',3200,2,2,'fine_steel','none',24,10,'sword',8,0.00000,0,0,0,379,0,17,-1,136000,0,'false','false','false','false',0,0,0,0,0,0,0,0,0,'0-0;'),
(3026,'Talins Spear','lrhand','false',800,2,2,'steel','none',24,10,'pole',8,-3.00000,0,0,0,325,0,17,-1,0,0,'false','false','true','false',0,0,0,0,0,0,0,0,0,'0-0;'),
(3027,'Old Knight''s Sword','lrhand','false',2100,2,2,'steel','none',29,10,'bigsword',8,0.00000,0,0,0,325,0,17,-1,0,0,'false','false','true','false',0,0,0,0,0,0,0,0,0,'0-0;'),
(3028,'Crescent Moon Bow','lrhand','false',600,6,2,'wood','none',34,5,'bow',12,-3.00000,0,0,0,293,2,12,-1,0,0,'false','false','true','false',0,0,0,0,0,0,0,0,0,'0-0;'),
(3029,'Sword of Binding','rhand','false',1200,2,2,'steel','none',17,10,'sword',8,0.00000,0,0,0,379,0,12,-1,0,0,'false','false','true','false',0,0,0,0,0,0,0,0,0,'0-0;'),
(3439,'Shining Canine','wolf','false',100,1,1,'steel','none',7,10,'pet',8,0.00000,0,0,0,277,0,8,-1,34000,0,'true','true','true','true',0,0,0,0,0,0,0,0,0,'0-0;'),
(3471,'Cybellin''s Dagger','rhand','false',400,1,1,'steel','none',10,5,'dagger',12,-3.00000,0,0,0,433,0,9,-1,0,0,'false','false','false','false',0,0,0,0,0,0,0,0,0,'0-0;'),
(3902,'Ghost Canine','wolf','false',100,1,1,'steel','none',11,10,'pet',8,0.00000,0,0,0,277,0,10,-1,61000,0,'true','true','true','true',0,0,0,0,0,0,0,0,0,'0-0;'),
(3903,'Mithril Canine','wolf','false',100,1,1,'steel','none',16,10,'pet',8,0.00000,0,0,0,277,0,14,-1,100000,0,'true','true','true','true',0,0,0,0,0,0,0,0,0,'0-0;'),
(3904,'Sylvan Canine','wolf','false',100,1,1,'steel','none',23,10,'pet',8,0.00000,0,0,0,277,0,18,-1,160000,0,'true','true','true','true',0,0,0,0,0,0,0,0,0,'0-0;'),
(3905,'Orikarukon Canine','wolf','false',100,1,1,'steel','none',31,10,'pet',8,0.00000,0,0,0,277,0,24,-1,240000,0,'true','true','true','true',0,0,0,0,0,0,0,0,0,'0-0;'),
(3906,'Fang of Saltydog','wolf','false',100,1,1,'steel','none',40,10,'pet',8,0.00000,0,0,0,277,0,30,-1,350000,0,'true','true','true','true',0,0,0,0,0,0,0,0,0,'0-0;'),
(3907,'Fang of Cerberus','wolf','false',100,1,1,'steel','none',49,10,'pet',8,0.00000,0,0,0,277,0,36,-1,450000,0,'true','true','true','true',0,0,0,0,0,0,0,0,0,'0-0;'),
(3908,'Fang of Coyote','wolf','false',100,1,1,'steel','none',58,10,'pet',8,0.00000,0,0,0,277,0,42,-1,570000,0,'true','true','true','true',0,0,0,0,0,0,0,0,0,'0-0;'),
(3909,'Crystalized Ice Canine','wolf','false',100,1,1,'steel','none',69,10,'pet',8,0.00000,0,0,0,277,0,50,-1,720000,0,'true','true','true','true',0,0,0,0,0,0,0,0,0,'0-0;'),
(3910,'Fang of The Blue Wolf','wolf','false',100,1,1,'steel','none',80,10,'pet',8,0.00000,0,0,0,277,0,58,-1,1100000,0,'true','true','true','true',0,0,0,0,0,0,0,0,0,'0-0;'),
(3911,'Fang of Fenril','wolf','false',100,1,1,'steel','none',93,10,'pet',8,0.00000,0,0,0,277,0,66,-1,1500000,0,'true','true','true','true',0,0,0,0,0,0,0,0,0,'0-0;'),
(3919,'Serpent Fang','hatchling','false',100,1,1,'steel','none',8,10,'pet',8,0.00000,0,0,0,277,0,7,-1,200000,0,'true','true','true','true',0,0,0,0,0,0,0,0,0,'0-0;'),
(3920,'Viperbite','hatchling','false',100,1,1,'steel','none',9,10,'pet',8,0.00000,0,0,0,277,0,10,-1,310000,0,'true','true','true','true',0,0,0,0,0,0,0,0,0,'0-0;'),
(3921,'Shadow Fang','hatchling','false',100,1,1,'steel','none',10,10,'pet',8,0.00000,0,0,0,277,0,11,-1,420000,0,'true','true','true','true',0,0,0,0,0,0,0,0,0,'0-0;'),
(3922,'Alya Fang','hatchling','false',100,1,1,'steel','none',12,10,'pet',8,0.00000,0,0,0,277,0,13,-1,570000,0,'true','true','true','true',0,0,0,0,0,0,0,0,0,'0-0;'),
(3923,'Torturer','hatchling','false',100,1,1,'steel','none',13,10,'pet',8,0.00000,0,0,0,277,0,16,-1,760000,0,'true','true','true','true',0,0,0,0,0,0,0,0,0,'0-0;'),
(3924,'Unuk Alhay Fang','hatchling','false',100,1,1,'steel','none',15,10,'pet',8,0.00000,0,0,0,277,0,18,-1,1100000,0,'true','true','true','true',0,0,0,0,0,0,0,0,0,'0-0;'),
(3925,'Antiplague','hatchling','false',100,1,1,'steel','none',17,10,'pet',8,0.00000,0,0,0,277,0,21,-1,1600000,0,'true','true','true','true',0,0,0,0,0,0,0,0,0,'0-0;'),
(3937,'Giant Bar','lrhand','true',300,2,2,'bronze','d',50,10,'pole',8,-3.00000,0,0,0,325,0,26,-1,409000,743,'true','true','true','true',0,0,0,0,0,0,0,0,0,'0-0;'),
(3938,'Giant Rod','lrhand','true',300,2,2,'bronze','d',50,10,'pole',8,-3.00000,0,0,0,325,0,26,-1,409000,743,'true','true','true','true',0,0,0,0,0,0,0,0,0,'0-0;'),
(3939,'Lady''s Fan','lrhand','true',300,2,2,'bronze','d',50,10,'pole',8,-3.00000,0,0,0,325,0,26,-1,409000,743,'true','true','true','true',0,0,0,0,0,0,0,0,0,'0-0;'),
(4027,'Bouquet','rhand','false',0,0,0,'paper','none',8,10,'sword',8,0.00000,0,0,0,379,0,6,-1,0,0,'true','true','true','true',0,0,0,0,0,0,0,0,0,'0-0;'),
(4028,'Giant Cannon','rhand','true',300,2,2,'steel','d',5,5,'dagger',12,-3.00000,0,0,0,433,0,5,-1,409000,743,'true','true','true','true',0,0,0,0,0,0,0,0,0,'0-0;'),
(4202,'Chrono Cithara','rhand','false',0,0,0,'steel','none',1,10,'sword',8,0.00000,0,0,0,379,0,1,-1,0,0,'true','false','true','true',0,0,0,0,0,0,0,0,0,'0-0;'),
(4219,'Dream Sword','rhand','true',1530,2,2,'bronze','none',31,10,'sword',8,0.00000,0,0,0,379,0,21,-1,244000,0,'false','false','false','false',0,0,0,0,0,0,0,0,0,'0-0;'),
(4220,'Dream Knife','rhand','true',1110,2,2,'steel','none',27,5,'dagger',12,-3.00000,0,0,0,433,0,21,-1,244000,0,'false','false','false','false',0,0,0,0,0,0,0,0,0,'0-0;'),
(4221,'Ubiquitous Axe','rhand','true',1850,2,2,'steel','none',31,20,'blunt',4,4.00000,0,0,0,379,0,21,-1,244000,0,'false','false','false','false',0,0,0,0,0,0,0,0,0,'0-0;'),
(4222,'Dream Shield','lhand','true',1380,0,0,'bone','none',0,0,'none',0,0.00000,-8,90,20,0,0,0,-1,12900,0,'false','false','false','false',0,0,0,0,0,0,0,0,0,'0-0;'),
(4223,'Ubiquitous Shield','lhand','true',1380,0,0,'bone','none',0,0,'none',0,0.00000,-8,90,20,0,0,0,-1,12900,0,'false','false','false','false',0,0,0,0,0,0,0,0,0,'0-0;'),
(4233,'Knuckle Duster','lrhand','true',1490,2,2,'fine_steel','c',148,5,'dualfist',4,4.00000,0,0,0,325,0,68,-1,2870000,1148,'true','true','true','true',0,0,0,0,0,0,0,0,0,'0-0;'),
(4237,'Hatchling''s Level 65 Weapon','hatchling','false',100,1,1,'steel','none',24,10,'pet',8,0.00000,0,0,0,277,0,32,-1,0,0,'true','true','true','true',0,0,0,0,0,0,0,0,0,'0-0;'),
(4238,'Hatchling''s Level 75 Weapon','hatchling','false',100,1,1,'steel','none',31,10,'pet',8,0.00000,0,0,0,277,0,43,-1,0,0,'true','true','true','true',0,0,0,0,0,0,0,0,0,'0-0;'),
(4665,'Pipette Knife','rhand','false',1140,1,1,'bronze','none',10,5,'dagger',12,-3.00000,0,0,0,433,0,9,-1,0,0,'false','false','false','false',0,0,0,0,0,0,0,0,0,'0-0;'),
(4681,'Stormbringer - Critical Anger','rhand','true',1430,2,2,'fine_steel','c',107,10,'sword',8,0.00000,0,0,0,379,0,61,-1,2290000,916,'true','true','true','true',0,0,0,0,0,0,0,0,9229,'3026-1;'),
(4682,'Stormbringer - Focus','rhand','true',1430,2,2,'fine_steel','c',107,10,'sword',8,0.00000,0,0,0,379,0,61,-1,2290000,916,'true','true','true','true',0,0,0,0,0,0,0,0,9230,'3044-15;'),
(4683,'Stormbringer - Light','rhand','true',430,2,2,'fine_steel','c',107,10,'sword',8,0.00000,0,0,0,379,0,61,-1,2290000,916,'true','true','true','true',0,0,0,0,0,0,0,0,9231,'3498-1;'),
(4684,'Shamshir - Guidance','rhand','true',1420,2,2,'fine_steel','c',122,10,'sword',8,0.00000,0,0,0,379,0,68,-1,2870000,1148,'true','true','true','true',0,0,0,0,0,0,0,0,9241,'3007-2;'),
(4685,'Shamshir - Back Blow','rhand','true',1420,2,2,'fine_steel','c',122,10,'sword',8,0.00000,0,0,0,379,0,68,-1,2870000,1148,'true','true','true','true',0,0,0,0,0,0,0,0,9242,'3018-2;'),
(4686,'Shamshir - Rsk. Evasion','rhand','true',1420,2,2,'fine_steel','c',122,10,'sword',8,0.00000,0,0,0,379,0,68,-1,2870000,1148,'true','true','true','true',0,0,0,0,0,0,0,0,9243,'3028-2;'),
(4687,'Katana - Focus','rhand','true',1420,2,2,'fine_steel','c',122,10,'sword',8,0.00000,0,0,0,379,0,68,-1,2870000,1148,'true','true','true','true',0,0,0,0,0,0,0,0,9245,'3044-13;'),
(4688,'Katana - Critical Damage','rhand','true',1420,2,2,'fine_steel','c',122,10,'sword',8,0.00000,0,0,0,379,0,68,-1,2870000,1148,'true','true','true','true',0,0,0,0,0,0,0,0,9246,'3023-2;'),
(4689,'Katana - Haste','rhand','true',1420,2,2,'fine_steel','c',122,10,'sword',8,0.00000,0,0,0,379,0,68,-1,2870000,1148,'true','true','true','true',0,0,0,0,0,0,0,0,9247,'3037-2;'),
(4690,'Spirit Sword - Critical Damage','rhand','true',1420,2,2,'fine_steel','c',122,10,'sword',8,0.00000,0,0,0,379,0,68,-1,2870000,1148,'true','true','true','true',0,0,0,0,0,0,0,0,9249,'3023-2;'),
(4691,'Spirit Sword - Critical Poison','rhand','true',1420,2,2,'fine_steel','c',122,10,'sword',8,0.00000,0,0,0,379,0,68,-1,2870000,1148,'true','true','true','true',0,0,0,0,0,3024,4,15,9250,'0-0;'),
(4692,'Spirit Sword - Haste','rhand','true',1420,2,2,'fine_steel','c',122,10,'sword',8,0.00000,0,0,0,379,0,68,-1,2870000,1148,'true','true','true','true',0,0,0,0,0,0,0,0,9251,'3037-2;'),
(4693,'Raid Sword - Focus','rhand','true',1420,2,2,'fine_steel','c',122,10,'sword',8,0.00000,0,0,0,379,0,68,-1,2870000,1148,'true','true','true','true',0,0,0,0,0,0,0,0,9253,'3044-13;'),
(4694,'Raid Sword - Critical Drain','rhand','true',1420,2,2,'fine_steel','c',122,10,'sword',8,0.00000,0,0,0,379,0,68,-1,2870000,1148,'true','true','true','true',0,0,0,0,0,3022,2,15,9254,'0-0;'),
(4695,'Raid Sword - Critical Poison','rhand','true',1420,2,2,'fine_steel','c',122,10,'sword',8,0.00000,0,0,0,379,0,68,-1,2870000,1148,'true','true','true','true',0,0,0,0,0,3024,4,15,9255,'0-0;'),
(4696,'Caliburs - Guidance','rhand','true',1400,3,3,'oriharukon','c',139,10,'sword',8,0.00000,0,0,0,379,0,76,-1,4300000,1720,'true','true','true','true',0,0,0,0,0,0,0,0,9265,'3007-3;'),
(4697,'Caliburs - Focus','rhand','true',1400,3,3,'oriharukon','c',139,10,'sword',8,0.00000,0,0,0,379,0,76,-1,4300000,1720,'true','true','true','true',0,0,0,0,0,0,0,0,9266,'3044-10;'),
(4698,'Caliburs - Critical Damage','rhand','true',1400,3,3,'oriharukon','c',139,10,'sword',8,0.00000,0,0,0,379,0,76,-1,4300000,1720,'true','true','true','true',0,0,0,0,0,0,0,0,9267,'3023-3;'),
(4699,'Sword of Delusion - Focus','rhand','true',1400,3,3,'mithril','c',139,10,'sword',8,0.00000,0,0,0,379,0,76,-1,4300000,1720,'true','true','true','true',0,0,0,0,0,0,0,0,9269,'3044-10;'),
(4700,'Sword of Delusion - Health','rhand','true',1400,3,3,'mithril','c',139,10,'sword',8,0.00000,0,0,0,379,0,76,-1,4300000,1720,'true','true','true','true',0,0,0,0,0,0,0,0,9270,'3013-1;'),
(4701,'Sword of Delusion - Rsk. Haste','rhand','true',1400,3,3,'mithril','c',139,10,'sword',8,0.00000,0,0,0,379,0,76,-1,4300000,1720,'true','true','true','true',0,0,0,0,0,0,0,0,9271,'3032-3;'),
(4702,'Tsurugi - Focus','rhand','true',1400,3,3,'fine_steel','c',139,10,'sword',8,0.00000,0,0,0,379,0,76,-1,4300000,1720,'true','true','true','true',0,0,0,0,0,0,0,0,9273,'3044-10;'),
(4703,'Tsurugi - Critical Damage','rhand','true',1400,3,3,'fine_steel','c',139,10,'sword',8,0.00000,0,0,0,379,0,76,-1,4300000,1720,'true','true','true','true',0,0,0,0,0,0,0,0,9274,'3023-3;'),
(4704,'Tsurugi - Haste','rhand','true',1400,3,3,'fine_steel','c',139,10,'sword',8,0.00000,0,0,0,379,0,76,-1,4300000,1720,'true','true','true','true',0,0,0,0,0,0,0,0,9275,'3037-3;'),
(4705,'Sword of Nightmare - Health','rhand','true',1400,3,3,'blood_steel','c',139,10,'sword',8,0.00000,0,0,0,379,0,76,-1,4300000,1720,'true','true','true','true',0,0,0,0,0,0,0,0,9277,'3013-1;'),
(4706,'Sword of Nightmare - Focus','rhand','true',1400,3,3,'blood_steel','c',139,10,'sword',8,0.00000,0,0,0,379,0,76,-1,4300000,1720,'true','true','true','true',0,0,0,0,0,0,0,0,9278,'3044-10;'),
(4707,'Sword of Nightmare - Light','rhand','true',420,3,3,'blood_steel','c',139,10,'sword',8,0.00000,0,0,0,379,0,76,-1,4300000,1720,'true','true','true','true',0,0,0,0,0,0,0,0,9279,'3498-1;'),
(4708,'Samurai Longsword - Focus','rhand','true',1380,3,3,'oriharukon','c',156,10,'sword',8,0.00000,0,0,0,379,0,83,-1,6130000,2452,'true','true','true','true',0,0,0,0,0,0,0,0,9293,'3044-8;'),
(4709,'Samurai Longsword - Critical Damage','rhand','true',1380,3,3,'oriharukon','c',156,10,'sword',8,0.00000,0,0,0,379,0,83,-1,6130000,2452,'true','true','true','true',0,0,0,0,0,0,0,0,9294,'3023-4;'),
(4710,'Samurai Longsword - Haste','rhand','true',1380,3,3,'oriharukon','c',156,10,'sword',8,0.00000,0,0,0,379,0,83,-1,6130000,2452,'true','true','true','true',0,0,0,0,0,0,0,0,9295,'3037-4;'),
(4711,'Flamberge - Critical Damage','lrhand','true',2010,2,2,'bronze','c',130,10,'bigsword',8,0.00000,0,0,0,325,0,61,-1,2290000,916,'true','true','true','true',0,0,0,0,0,0,0,0,9233,'3023-1;'),
(4712,'Flamberge - Focus','lrhand','true',2010,2,2,'bronze','c',130,10,'bigsword',8,0.00000,0,0,0,325,0,61,-1,2290000,916,'true','true','true','true',0,0,0,0,0,0,0,0,9234,'3044-15;'),
(4713,'Flamberge - Light','lrhand','true',600,2,2,'bronze','c',130,10,'bigsword',8,0.00000,0,0,0,325,0,61,-1,2290000,916,'true','true','true','true',0,0,0,0,0,0,0,0,9235,'3498-1;'),
(4714,'Keshanberk - Guidance','rhand','true',1370,1,1,'oriharukon','b',175,10,'sword',8,0.00000,0,0,0,379,0,91,-1,8680000,1157,'true','true','true','true',0,0,0,0,0,0,0,0,9305,'3007-5;'),
(4715,'Keshanberk - Focus','rhand','true',1370,1,1,'oriharukon','b',175,10,'sword',8,0.00000,0,0,0,379,0,91,-1,8680000,1157,'true','true','true','true',0,0,0,0,0,0,0,0,9306,'3044-6;'),
(4716,'Keshanberk - Back Blow','rhand','true',1370,1,1,'oriharukon','b',175,10,'sword',8,0.00000,0,0,0,379,0,91,-1,8680000,1157,'true','true','true','true',0,0,0,0,0,0,0,0,9307,'3018-5;'),
(4717,'Sword of Damascus - Focus','rhand','true',1350,1,1,'damascus','b',194,10,'sword',8,0.00000,0,0,0,379,0,99,-1,13100000,1746,'true','true','true','true',0,0,0,0,0,0,0,0,9317,'3044-3;'),
(4718,'Sword of Damascus - Critical Damage','rhand','true',1350,1,1,'damascus','b',194,10,'sword',8,0.00000,0,0,0,379,0,99,-1,13100000,1746,'true','true','true','true',0,0,0,0,0,0,0,0,9318,'3023-3;'),
(4719,'Sword of Damascus - Haste','rhand','true',1350,1,1,'damascus','b',194,10,'sword',8,0.00000,0,0,0,379,0,99,-1,13100000,1746,'true','true','true','true',0,0,0,0,0,0,0,0,9319,'3037-6;'),
(4720,'Tallum Blade - Health','rhand','true',1330,1,1,'adamantaite','a',213,10,'sword',8,0.00000,0,0,0,379,0,107,-1,18300000,1464,'true','true','true','true',0,0,0,0,0,0,0,0,0,'3013-1;'),
(4721,'Tallum Blade - Rsk. Evasion','rhand','true',1330,1,1,'adamantaite','a',213,10,'sword',8,0.00000,0,0,0,379,0,107,-1,18300000,1464,'true','true','true','true',0,0,0,0,0,0,0,0,0,'3028-1;'),
(4722,'Tallum Blade - Rsk. Haste','rhand','true',1330,1,1,'adamantaite','a',213,10,'sword',8,0.00000,0,0,0,379,0,107,-1,18300000,1464,'true','true','true','true',0,0,0,0,0,0,0,0,0,'3032-2;'),
(4723,'Great Sword - Health','lrhand','true',1930,1,1,'steel','b',213,10,'bigsword',8,0.00000,0,0,0,325,0,91,-1,8680000,1157,'true','true','true','true',0,0,0,0,0,0,0,0,9309,'3013-1;'),
(4724,'Great Sword - Critical Damage','lrhand','true',1930,1,1,'steel','b',213,10,'bigsword',8,0.00000,0,0,0,325,0,91,-1,8680000,1157,'true','true','true','true',0,0,0,0,0,0,0,0,9310,'3023-5;'),
(4725,'Great Sword - Focus','lrhand','true',1930,1,1,'steel','b',213,10,'bigsword',8,0.00000,0,0,0,325,0,91,-1,8680000,1157,'true','true','true','true',0,0,0,0,0,0,0,0,9311,'3044-6;'),
(4726,'Big Hammer - Health','rhand','true',1710,2,2,'fine_steel','c',107,20,'blunt',4,4.00000,0,0,0,379,0,61,-1,2290000,916,'true','true','true','true',0,0,0,0,0,0,0,0,0,'3013-1;'),
(4727,'Big Hammer - Rsk.Focus','rhand','true',1710,2,2,'fine_steel','c',107,20,'blunt',4,4.00000,0,0,0,379,0,61,-1,2290000,916,'true','true','true','true',0,0,0,0,0,0,0,0,0,'3027-1;'),
(4728,'Big Hammer - Haste','rhand','true',1710,2,2,'fine_steel','c',107,20,'blunt',4,4.00000,0,0,0,379,0,61,-1,2290000,916,'true','true','true','true',0,0,0,0,0,0,0,0,0,'3037-1;'),
(4729,'Battle Axe - Anger','rhand','true',1720,2,2,'fine_steel','c',107,20,'blunt',4,4.00000,0,0,0,379,0,61,-1,2290000,916,'true','true','true','true',0,0,0,0,0,0,0,0,0,'3012-1;'),
(4730,'Battle Axe - Rsk.Focus','rhand','true',1720,2,2,'fine_steel','c',107,20,'blunt',4,4.00000,0,0,0,379,0,61,-1,2290000,916,'true','true','true','true',0,0,0,0,0,0,0,0,0,'3027-1;'),
(4731,'Battle Axe - Haste','rhand','true',1720,2,2,'fine_steel','c',107,20,'blunt',4,4.00000,0,0,0,379,0,61,-1,2290000,916,'true','true','true','true',0,0,0,0,0,0,0,0,0,'3037-1;'),
(4732,'Silver Axe - Anger','rhand','true',1690,2,2,'fine_steel','c',107,20,'blunt',4,4.00000,0,0,0,379,0,61,-1,2290000,916,'true','true','true','true',0,0,0,0,0,0,0,0,0,'3012-1;'),
(4733,'Silver Axe - Rsk.Focus','rhand','true',1690,2,2,'fine_steel','c',107,20,'blunt',4,4.00000,0,0,0,379,0,61,-1,2290000,916,'true','true','true','true',0,0,0,0,0,0,0,0,0,'3027-1;'),
(4734,'Silver Axe - Haste','rhand','true',1690,2,2,'fine_steel','c',107,20,'blunt',4,4.00000,0,0,0,379,0,61,-1,2290000,916,'true','true','true','true',0,0,0,0,0,0,0,0,0,'3037-1;'),
(4735,'Skull Graver - Anger','rhand','true',1640,2,2,'fine_steel','c',107,20,'blunt',4,4.00000,0,0,0,379,0,61,-1,2290000,916,'true','true','true','true',0,0,0,0,0,0,0,0,0,'3012-1;'),
(4736,'Skull Graver - Health','rhand','true',1640,2,2,'fine_steel','c',107,20,'blunt',4,4.00000,0,0,0,379,0,61,-1,2290000,916,'true','true','true','true',0,0,0,0,0,0,0,0,0,'3013-1;'),
(4737,'Skull Graver - Rsk.Focus','rhand','true',1640,2,2,'fine_steel','c',107,20,'blunt',4,4.00000,0,0,0,379,0,61,-1,2290000,916,'true','true','true','true',0,0,0,0,0,0,0,0,0,'3027-1;'),
(4738,'Dwarven War Hammer - Anger','rhand','true',1670,2,2,'fine_steel','c',122,20,'blunt',4,4.00000,0,0,0,379,0,68,-1,2870000,1148,'true','true','true','true',0,0,0,0,0,0,0,0,0,'3012-2;'),
(4739,'Dwarven War Hammer - Health','rhand','true',1670,2,2,'fine_steel','c',122,20,'blunt',4,4.00000,0,0,0,379,0,68,-1,2870000,1148,'true','true','true','true',0,0,0,0,0,0,0,0,0,'3013-1;'),
(4740,'Dwarven War Hammer - Haste','rhand','true',1670,2,2,'fine_steel','c',122,20,'blunt',4,4.00000,0,0,0,379,0,68,-1,2870000,1148,'true','true','true','true',0,0,0,0,0,0,0,0,0,'3037-2;'),
(4741,'War Axe - Anger','rhand','true',1660,3,3,'fine_steel','c',139,20,'blunt',4,4.00000,0,0,0,379,0,76,-1,4300000,1720,'true','true','true','true',0,0,0,0,0,0,0,0,0,'3012-3;'),
(4742,'War Axe - Health','rhand','true',1660,3,3,'fine_steel','c',139,20,'blunt',4,4.00000,0,0,0,379,0,76,-1,4300000,1720,'true','true','true','true',0,0,0,0,0,0,0,0,0,'3013-1;'),
(4743,'War Axe - Haste','rhand','true',1660,3,3,'fine_steel','c',139,20,'blunt',4,4.00000,0,0,0,379,0,76,-1,4300000,1720,'true','true','true','true',0,0,0,0,0,0,0,0,0,'3037-3;'),
(4744,'Yaksa Mace - Anger','rhand','true',1640,3,3,'fine_steel','c',156,20,'blunt',4,4.00000,0,0,0,379,0,83,-1,6130000,2452,'true','true','true','true',0,0,0,0,0,0,0,0,0,'3012-4;'),
(4745,'Yaksa Mace - Health','rhand','true',1640,3,3,'fine_steel','c',156,20,'blunt',4,4.00000,0,0,0,379,0,83,-1,6130000,2452,'true','true','true','true',0,0,0,0,0,0,0,0,0,'3013-1;'),
(4746,'Yaksa Mace - Rsk. Focus','rhand','true',1640,3,3,'fine_steel','c',156,20,'blunt',4,4.00000,0,0,0,379,0,83,-1,6130000,2452,'true','true','true','true',0,0,0,0,0,0,0,0,0,'3027-4;'),
(4747,'Heavy War Axe - Anger','rhand','true',1620,1,1,'fine_steel','b',175,20,'blunt',4,4.00000,0,0,0,379,0,91,-1,8680000,1157,'true','true','true','true',0,0,0,0,0,0,0,0,0,'3012-5;'),
(4748,'Heavy War Axe - Health','rhand','true',1620,1,1,'fine_steel','b',175,20,'blunt',4,4.00000,0,0,0,379,0,91,-1,8680000,1157,'true','true','true','true',0,0,0,0,0,0,0,0,0,'3013-1;'),
(4749,'Heavy War Axe - Rsk. Focus','rhand','true',1620,1,1,'fine_steel','b',175,20,'blunt',4,4.00000,0,0,0,379,0,91,-1,8680000,1157,'true','true','true','true',0,0,0,0,0,0,0,0,0,'3027-5;'),
(4750,'Deadman''s Glory - Anger','rhand','true',1600,1,1,'bone','b',194,20,'blunt',4,4.00000,0,0,0,379,0,99,-1,13100000,1746,'true','true','true','true',0,0,0,0,0,0,0,0,0,'3012-6;'),
(4751,'Deadman''s Glory - Health','rhand','true',1600,1,1,'bone','b',194,20,'blunt',4,4.00000,0,0,0,379,0,99,-1,13100000,1746,'true','true','true','true',0,0,0,0,0,0,0,0,0,'3013-1;'),
(4752,'Deadman''s Glory - Haste','rhand','true',1600,1,1,'bone','b',194,20,'blunt',4,4.00000,0,0,0,379,0,99,-1,13100000,1746,'true','true','true','true',0,0,0,0,0,0,0,0,0,'3037-6;'),
(4753,'Art of Battle Axe - Health','rhand','true',1570,1,1,'chrysolite','b',194,20,'blunt',4,4.00000,0,0,0,379,0,99,-1,13100000,1746,'true','true','true','true',0,0,0,0,0,0,0,0,0,'3013-1;'),
(4754,'Art of Battle Axe - Rsk. Focus','rhand','true',1570,1,1,'chrysolite','b',194,20,'blunt',4,4.00000,0,0,0,379,0,99,-1,13100000,1746,'true','true','true','true',0,0,0,0,0,0,0,0,0,'3027-6;'),
(4755,'Art of Battle Axe - Haste','rhand','true',1570,1,1,'chrysolite','b',194,20,'blunt',4,4.00000,0,0,0,379,0,99,-1,13100000,1746,'true','true','true','true',0,0,0,0,0,0,0,0,0,'3037-6;'),
(4756,'Meteor Shower - Health','rhand','true',1600,1,1,'fine_steel','a',213,20,'blunt',4,4.00000,0,0,0,379,0,107,-1,18300000,1464,'true','true','true','true',0,0,0,0,0,0,0,0,0,'3013-1;'),
(4757,'Meteor Shower - Focus','rhand','true',1600,1,1,'fine_steel','a',213,20,'blunt',4,4.00000,0,0,0,379,0,107,-1,18300000,1464,'true','true','true','true',0,0,0,0,0,0,0,0,0,'3010-1;'),
(4758,'Meteor Shower - P.Focus','rhand','true',1600,1,1,'fine_steel','a',213,20,'blunt',4,4.00000,0,0,0,379,0,107,-1,18300000,1464,'true','true','true','true',0,0,0,0,0,0,0,0,0,'3010-1;'),
(4759,'Cursed Dagger - Critical Bleed','rhand','true',1040,2,2,'mithril','c',94,5,'dagger',12,-3.00000,0,0,0,433,0,61,-1,2290000,916,'true','true','true','true',0,0,0,0,0,3021,3,12,0,'0-0;'),
(4760,'Cursed Dagger - Critical Poison','rhand','true',1040,2,2,'mithril','c',94,5,'dagger',12,-3.00000,0,0,0,433,0,61,-1,2290000,916,'true','true','true','true',0,0,0,0,0,3024,4,4,0,'0-0;'),
(4761,'Cursed Dagger - Rsk. Haste','rhand','true',1040,2,2,'mithril','c',94,5,'dagger',12,-3.00000,0,0,0,433,0,61,-1,2290000,916,'true','true','true','true',0,0,0,0,0,0,0,0,0,'3033-1;'),
(4762,'Dark Elven Dagger - Focus','rhand','true',1050,2,2,'fine_steel','c',94,5,'dagger',12,-3.00000,0,0,0,433,0,61,-1,2290000,916,'true','true','true','true',0,0,0,0,0,0,0,0,0,'3044-16;'),
(4763,'Dark Elven Dagger - Back Blow','rhand','true',1050,2,2,'fine_steel','c',94,5,'dagger',12,-3.00000,0,0,0,433,0,61,-1,2290000,916,'true','true','true','true',0,0,0,0,0,0,0,0,0,'3019-1;'),
(4764,'Dark Elven Dagger - Mortal Strike','rhand','true',1050,2,2,'fine_steel','c',94,5,'dagger',12,-3.00000,0,0,0,433,0,61,-1,2290000,916,'true','true','true','true',0,0,0,0,0,0,0,0,0,'3035-1;'),
(4765,'Stiletto - Critical Bleed','rhand','true',1030,2,2,'fine_steel','c',107,5,'dagger',12,-3.00000,0,0,0,433,0,68,-1,2870000,1148,'true','true','true','true',0,0,0,0,0,3021,3,12,0,'0-0;'),
(4766,'Stiletto - Critical Poison','rhand','true',1030,2,2,'fine_steel','c',107,5,'dagger',12,-3.00000,0,0,0,433,0,68,-1,2870000,1148,'true','true','true','true',0,0,0,0,0,3024,4,4,0,'0-0;'),
(4767,'Stiletto - Mortal Strike','rhand','true',1030,2,2,'fine_steel','c',107,5,'dagger',12,-3.00000,0,0,0,433,0,68,-1,2870000,1148,'true','true','true','true',0,0,0,0,0,0,0,0,0,'3035-2;'),
(4768,'Grace Dagger - Evasion','rhand','true',1020,3,3,'fine_steel','c',122,5,'dagger',12,-3.00000,0,0,0,433,0,76,-1,4300000,1720,'true','true','true','true',0,0,0,0,0,0,0,0,0,'3009-3;'),
(4769,'Grace Dagger - Focus','rhand','true',1020,3,3,'fine_steel','c',122,5,'dagger',12,-3.00000,0,0,0,433,0,76,-1,4300000,1720,'true','true','true','true',0,0,0,0,0,0,0,0,0,'3044-12;'),
(4770,'Grace Dagger - Back Blow','rhand','true',1020,3,3,'fine_steel','c',122,5,'dagger',12,-3.00000,0,0,0,433,0,76,-1,4300000,1720,'true','true','true','true',0,0,0,0,0,0,0,0,0,'3019-3;'),
(4771,'Dark Screamer - Evasion','rhand','true',1010,3,3,'fine_steel','c',122,5,'dagger',12,-3.00000,0,0,0,433,0,76,-1,4300000,1720,'true','true','true','true',0,0,0,0,0,0,0,0,0,'3009-3;'),
(4772,'Dark Screamer - Focus','rhand','true',1010,3,3,'fine_steel','c',122,5,'dagger',12,-3.00000,0,0,0,433,0,76,-1,4300000,1720,'true','true','true','true',0,0,0,0,0,0,0,0,0,'3044-12;'),
(4773,'Dark Screamer - Critical Bleed','rhand','true',1010,3,3,'fine_steel','c',122,5,'dagger',12,-3.00000,0,0,0,433,0,76,-1,4300000,1720,'true','true','true','true',0,0,0,0,0,3021,4,10,0,'0-0;'),
(4774,'Crystal Dagger - Critical Bleed','rhand','true',1000,3,3,'crystal','c',136,5,'dagger',12,-3.00000,0,0,0,433,0,83,-1,6130000,2452,'true','true','true','true',0,0,0,0,0,3021,4,10,0,'0-0;'),
(4775,'Crystal Dagger - Critical Poison','rhand','true',1000,3,3,'crystal','c',136,5,'dagger',12,-3.00000,0,0,0,433,0,83,-1,6130000,2452,'true','true','true','true',0,0,0,0,0,3024,5,3,0,'0-0;'),
(4776,'Crystal Dagger - Mortal Strike','rhand','true',1000,3,3,'crystal','c',136,5,'dagger',12,-3.00000,0,0,0,433,0,83,-1,6130000,2452,'true','true','true','true',0,0,0,0,0,0,0,0,0,'3035-4;'),
(4777,'Kris - Evasion','rhand','true',980,1,1,'mithril','b',153,5,'dagger',12,-3.00000,0,0,0,433,0,91,-1,8680000,1157,'true','true','true','true',0,0,0,0,0,0,0,0,0,'3009-5;'),
(4778,'Kris - Focus','rhand','true',980,1,1,'mithril','b',153,5,'dagger',12,-3.00000,0,0,0,433,0,91,-1,8680000,1157,'true','true','true','true',0,0,0,0,0,0,0,0,0,'3044-7;'),
(4779,'Kris - Back Blow','rhand','true',980,1,1,'mithril','b',153,5,'dagger',12,-3.00000,0,0,0,433,0,91,-1,8680000,1157,'true','true','true','true',0,0,0,0,0,0,0,0,0,'3019-5;'),
(4780,'Demon Dagger - Critical Bleed','rhand','true',970,1,1,'blood_steel','b',170,5,'dagger',12,-3.00000,0,0,0,433,0,99,-1,13100000,1746,'true','true','true','true',0,0,0,0,0,3021,4,10,0,'0-0;'),
(4781,'Demon Dagger - Critical Poison','rhand','true',970,1,1,'blood_steel','b',170,5,'dagger',12,-3.00000,0,0,0,433,0,99,-1,13100000,1746,'true','true','true','true',0,0,0,0,0,3024,5,3,0,'0-0;'),
(4782,'Demon Dagger - Mortal Strike','rhand','true',970,1,1,'blood_steel','b',170,5,'dagger',12,-3.00000,0,0,0,433,0,99,-1,13100000,1746,'true','true','true','true',0,0,0,0,0,0,0,0,0,'3035-6;'),
(4783,'Bloody Orchid - Evasion','rhand','true',960,1,1,'blood_steel','a',186,5,'dagger',12,-3.00000,0,0,0,433,0,107,-1,18300000,1464,'true','true','true','true',0,0,0,0,0,0,0,0,0,'3009-6;'),
(4784,'Bloody Orchid - Focus','rhand','true',960,1,1,'blood_steel','a',186,5,'dagger',12,-3.00000,0,0,0,433,0,107,-1,18300000,1464,'true','true','true','true',0,0,0,0,0,0,0,0,0,'3011-2;'),
(4785,'Bloody Orchid - Back Blow','rhand','true',960,1,1,'blood_steel','a',186,5,'dagger',12,-3.00000,0,0,0,433,0,107,-1,18300000,1464,'true','true','true','true',0,0,0,0,0,0,0,0,0,'3019-6;'),
(4786,'Hell Knife - Focus','rhand','true',740,1,1,'blood_steel','b',122,5,'dagger',12,-3.00000,0,0,0,433,0,122,-1,8680000,1157,'true','true','true','true',0,0,0,0,0,0,0,0,0,'3044-7;'),
(4787,'Hell Knife - Back Blow','rhand','true',740,1,1,'blood_steel','b',122,5,'dagger',12,-3.00000,0,0,0,433,0,122,-1,8680000,1157,'true','true','true','true',0,0,0,0,0,0,0,0,0,'3018-5;'),
(4788,'Hell Knife - Mortal Strike','rhand','true',740,1,1,'blood_steel','b',122,5,'dagger',12,-3.00000,0,0,0,433,0,122,-1,8680000,1157,'true','true','true','true',0,0,0,0,0,0,0,0,0,'3035-5;'),
(4789,'Chakram - Critical Drain','lrhand','true',1490,2,2,'fine_steel','c',130,5,'dualfist',4,4.00000,0,0,0,325,0,61,-1,2290000,916,'true','true','true','true',0,0,0,0,0,3022,1,10,0,'0-0;'),
(4790,'Chakram - Critical Poison','lrhand','true',1490,2,2,'fine_steel','c',130,5,'dualfist',4,4.00000,0,0,0,325,0,61,-1,2290000,916,'true','true','true','true',0,0,0,0,0,3024,4,8,0,'0-0;'),
(4791,'Chakram - Rsk. Haste','lrhand','true',1490,2,2,'fine_steel','c',130,5,'dualfist',4,4.00000,0,0,0,325,0,61,-1,2290000,916,'true','true','true','true',0,0,0,0,0,0,0,0,0,'3034-1;'),
(4792,'Fisted Blade - Rsk. Evasion','lrhand','true',1480,3,3,'fine_steel','c',169,5,'dualfist',4,4.00000,0,0,0,325,0,76,-1,4300000,1720,'true','true','true','true',0,0,0,0,0,0,0,0,0,'3030-3;'),
(4793,'Fisted Blade - Rsk. Haste','lrhand','true',1480,3,3,'fine_steel','c',169,5,'dualfist',4,4.00000,0,0,0,325,0,76,-1,4300000,1720,'true','true','true','true',0,0,0,0,0,0,0,0,0,'3034-3;'),
(4794,'Fisted Blade - Haste','lrhand','true',1480,3,3,'fine_steel','c',169,5,'dualfist',4,4.00000,0,0,0,325,0,76,-1,4300000,1720,'true','true','true','true',0,0,0,0,0,0,0,0,0,'3037-3;'),
(4795,'Great Pata - Critical Drain','lrhand','true',1460,3,3,'chrysolite','c',190,5,'dualfist',4,4.00000,0,0,0,325,0,83,-1,6130000,2452,'true','true','true','true',0,0,0,0,0,3022,3,10,0,'0-0;'),
(4796,'Great Pata - Critical Poison','lrhand','true',1460,3,3,'chrysolite','c',190,5,'dualfist',4,4.00000,0,0,0,325,0,83,-1,6130000,2452,'true','true','true','true',0,0,0,0,0,3024,5,7,0,'0-0;'),
(4797,'Great Pata - Rsk. Haste','lrhand','true',1460,3,3,'chrysolite','c',190,5,'dualfist',4,4.00000,0,0,0,325,0,83,-1,6130000,2452,'true','true','true','true',0,0,0,0,0,0,0,0,0,'3034-4;'),
(4798,'Knuckle Duster - Rsk. Evasion','lrhand','true',1490,2,2,'fine_steel','c',148,5,'dualfist',4,4.00000,0,0,0,325,0,68,-1,2870000,1148,'true','true','true','true',0,0,0,0,0,0,0,0,0,'3030-2;'),
(4799,'Knuckle Duster - Rsk. Haste','lrhand','true',1490,2,2,'fine_steel','c',148,5,'dualfist',4,4.00000,0,0,0,325,0,68,-1,2870000,1148,'true','true','true','true',0,0,0,0,0,0,0,0,0,'3034-2;'),
(4800,'Knuckle Duster - Haste','lrhand','true',1490,2,2,'fine_steel','c',148,5,'dualfist',4,4.00000,0,0,0,325,0,68,-1,2870000,1148,'true','true','true','true',0,0,0,0,0,0,0,0,0,'3037-2;'),
(4801,'Arthro Nail - Critical Poison','lrhand','true',1420,1,1,'blood_steel','b',213,5,'dualfist',4,4.00000,0,0,0,325,0,91,-1,8680000,1157,'true','true','true','true',0,0,0,0,0,3024,5,7,0,'0-0;'),
(4802,'Arthro Nail - Rsk. Evasion','lrhand','true',1420,1,1,'blood_steel','b',213,5,'dualfist',4,4.00000,0,0,0,325,0,91,-1,8680000,1157,'true','true','true','true',0,0,0,0,0,0,0,0,0,'3030-5;'),
(4803,'Arthro Nail - Rsk. Haste','lrhand','true',1420,1,1,'blood_steel','b',213,5,'dualfist',4,4.00000,0,0,0,325,0,91,-1,8680000,1157,'true','true','true','true',0,0,0,0,0,0,0,0,0,'3034-5;'),
(4804,'Bellion Cestus - Critical Drain','lrhand','true',1390,1,1,'mithril','b',236,5,'dualfist',4,4.00000,0,0,0,325,0,99,-1,13100000,1746,'true','true','true','true',0,0,0,0,0,3022,5,10,0,'0-0;'),
(4805,'Bellion Cestus - Critical Poison','lrhand','true',1390,1,1,'mithril','b',236,5,'dualfist',4,4.00000,0,0,0,325,0,99,-1,13100000,1746,'true','true','true','true',0,0,0,0,0,3024,6,6,0,'0-0;'),
(4806,'Bellion Cestus - Rsk. Haste','lrhand','true',1390,1,1,'mithril','b',236,5,'dualfist',4,4.00000,0,0,0,325,0,99,-1,13100000,1746,'true','true','true','true',0,0,0,0,0,0,0,0,0,'3034-6;'),
(4807,'Blood Tornado - Critical Drain','lrhand','true',1370,1,1,'blood_steel','a',259,5,'dualfist',4,4.00000,0,0,0,325,0,107,-1,18300000,1464,'true','true','true','true',0,0,0,0,0,3022,6,10,0,'0-0;'),
(4808,'Blood Tornado - Rsk. Evasion','lrhand','true',1370,1,1,'blood_steel','a',259,5,'dualfist',4,4.00000,0,0,0,325,0,107,-1,18300000,1464,'true','true','true','true',0,0,0,0,0,0,0,0,0,'3030-6;'),
(4809,'Blood Tornado - Haste','lrhand','true',1370,1,1,'blood_steel','a',259,5,'dualfist',4,4.00000,0,0,0,325,0,107,-1,18300000,1464,'true','true','true','true',0,0,0,0,0,0,0,0,0,'3037-6;'),
(4810,'Crystallized Ice Bow - Guidance','lrhand','true',1790,8,2,'crystal','c',220,5,'bow',12,-3.00000,0,0,0,293,6,61,-1,2290000,916,'true','true','true','true',0,0,0,0,0,0,0,0,9237,'3008-1;'),
(4811,'Crystallized Ice Bow - Evasion','lrhand','true',1790,8,2,'crystal','c',220,5,'bow',12,-3.00000,0,0,0,293,6,61,-1,2290000,916,'true','true','true','true',0,0,0,0,0,0,0,0,9238,'3009-1;'),
(4812,'Crystallized Ice Bow - Quick Recovery','lrhand','true',1790,8,2,'crystal','c',220,5,'bow',12,-3.00000,0,0,0,293,6,61,-1,2290000,916,'true','true','true','true',0,0,0,0,0,0,0,0,9239,'0-0;'),
(4813,'Elemental Bow - Guidance','lrhand','true',1770,8,2,'fine_steel','c',277,5,'bow',12,-3.00000,0,0,0,227,7,75,-1,2870000,1148,'true','true','true','true',0,0,0,0,0,0,0,0,9257,'3008-2;'),
(4814,'Elemental Bow - Miser','lrhand','true',1770,8,2,'fine_steel','c',277,5,'bow',12,-3.00000,0,0,0,227,7,75,-1,2870000,1148,'true','true','true','true',0,0,0,0,0,0,0,0,9258,'0-0;'),
(4815,'Elemental Bow - Quick Recovery','lrhand','true',1770,8,2,'fine_steel','c',277,5,'bow',12,-3.00000,0,0,0,227,7,75,-1,2870000,1148,'true','true','true','true',0,0,0,0,0,0,0,0,9259,'0-0;'),
(4816,'Elven Bow of Nobility - Evasion','lrhand','true',1760,8,2,'mithril','c',252,5,'bow',12,-3.00000,0,0,0,293,7,68,-1,2870000,1148,'true','true','true','true',0,0,0,0,0,0,0,0,9261,'3009-2;'),
(4817,'Elven Bow of Nobility - Miser','lrhand','true',1760,8,2,'mithril','c',252,5,'bow',12,-3.00000,0,0,0,293,7,68,-1,2870000,1148,'true','true','true','true',0,0,0,0,0,0,0,0,9262,'0-0;'),
(4818,'Elven Bow of Nobility - Cheap Shot','lrhand','true',1760,8,2,'mithril','c',252,5,'bow',12,-3.00000,0,0,0,293,7,68,-1,2870000,1148,'true','true','true','true',0,0,0,0,0,0,0,0,9263,'0-0;'),
(4819,'Akat Long Bow - Guidance','lrhand','true',1740,9,3,'horn','c',316,5,'bow',12,-3.00000,0,0,0,227,7,84,-1,4300000,1720,'true','true','true','true',0,0,0,0,0,0,0,0,9289,'3008-3;'),
(4820,'Akat Long Bow - Evasion','lrhand','true',1740,9,3,'horn','c',316,5,'bow',12,-3.00000,0,0,0,227,7,84,-1,4300000,1720,'true','true','true','true',0,0,0,0,0,0,0,0,9290,'3009-3;'),
(4821,'Akat Long Bow - Miser','lrhand','true',1740,9,3,'horn','c',316,5,'bow',12,-3.00000,0,0,0,227,7,84,-1,4300000,1720,'true','true','true','true',0,0,0,0,0,0,0,0,9291,'0-0;'),
(4822,'Eminence Bow - Guidance','lrhand','true',1720,10,3,'chrysolite','c',323,5,'bow',12,-3.00000,0,0,0,293,8,83,-1,6130000,2452,'true','true','true','true',0,0,0,0,0,0,0,0,9301,'3008-4;'),
(4823,'Eminence Bow - Miser','lrhand','true',1720,10,3,'chrysolite','c',323,5,'bow',12,-3.00000,0,0,0,293,8,83,-1,6130000,2452,'true','true','true','true',0,0,0,0,0,0,0,0,9302,'0-0;'),
(4824,'Eminence Bow - Cheap Shot','lrhand','true',1720,10,3,'chrysolite','c',323,5,'bow',12,-3.00000,0,0,0,293,8,83,-1,6130000,2452,'true','true','true','true',0,0,0,0,0,0,0,0,9303,'0-0;'),
(4825,'Dark Elven Long Bow - Evasion','lrhand','true',1720,3,1,'oriharukon','b',397,5,'bow',12,-3.00000,0,0,0,227,8,100,-1,8680000,1157,'true','true','true','true',0,0,0,0,0,0,0,0,9313,'3009-5;'),
(4826,'Dark Elven Long Bow - Critical Bleed','lrhand','true',1720,3,1,'oriharukon','b',397,5,'bow',12,-3.00000,0,0,0,227,8,100,-1,8680000,1157,'true','true','true','true',0,0,0,0,0,3021,4,30,9314,'0-0;'),
(4827,'Dark Elven Long Bow - Miser','lrhand','true',1720,3,1,'oriharukon','b',397,5,'bow',12,-3.00000,0,0,0,227,8,100,-1,8680000,1157,'true','true','true','true',0,0,0,0,0,0,0,0,9315,'0-0;'),
(4828,'Bow of Peril - Guidance','lrhand','true',1700,3,1,'blood_steel','b',400,5,'bow',12,-3.00000,0,0,0,293,9,99,-1,13100000,1746,'true','true','true','true',0,0,0,0,0,0,0,0,9325,'3008-6;'),
(4829,'Bow of Peril - Quick Recovery','lrhand','true',1700,3,1,'blood_steel','b',400,5,'bow',12,-3.00000,0,0,0,293,9,99,-1,13100000,1746,'true','true','true','true',0,0,0,0,0,0,0,0,9326,'0-0;'),
(4830,'Bow of Peril - Cheap Shot','lrhand','true',1700,3,1,'blood_steel','b',400,5,'bow',12,-3.00000,0,0,0,293,9,99,-1,13100000,1746,'true','true','true','true',0,0,0,0,0,0,0,0,9327,'0-0;'),
(4831,'Carnage Bow - Critical Bleed','lrhand','true',1670,2,1,'damascus','a',440,5,'bow',12,-3.00000,0,0,0,293,9,107,-1,18300000,1464,'true','true','true','true',0,0,0,0,0,3021,4,30,0,'0-0;'),
(4832,'Carnage Bow - Mana Up','lrhand','true',1670,2,1,'damascus','a',440,5,'bow',12,-3.00000,0,0,0,293,9,107,-1,18300000,1464,'true','true','true','true',0,0,0,0,0,0,0,0,0,'3014-1;'),
(4833,'Carnage Bow - Quick Recovery','lrhand','true',1670,2,1,'damascus','a',440,5,'bow',12,-3.00000,0,0,0,293,9,107,-1,18300000,1464,'true','true','true','true',0,0,0,0,0,0,0,0,0,'0-0;'),
(4834,'Scythe - Anger','lrhand','true',2040,2,2,'fine_steel','c',107,10,'pole',8,-3.00000,0,0,0,325,0,61,-1,2290000,916,'true','true','true','true',0,0,0,0,0,0,0,0,0,'3600-1;'),
(4835,'Scythe - Critical Stun','lrhand','true',2040,2,2,'fine_steel','c',107,10,'pole',8,-3.00000,0,0,0,325,0,61,-1,2290000,916,'true','true','true','true',0,0,0,0,0,3571,1,18,0,'0-0;'),
(4836,'Scythe - Light','lrhand','true',610,2,2,'fine_steel','c',107,10,'pole',8,-3.00000,0,0,0,325,0,61,-1,2290000,916,'true','true','true','true',0,0,0,0,0,0,0,0,0,'3498-1;'),
(4837,'Orcish Glaive - Anger','lrhand','true',2030,2,2,'fine_steel','c',107,10,'pole',8,-3.00000,0,0,0,325,0,61,-1,2290000,916,'true','true','true','true',0,0,0,0,0,0,0,0,0,'3600-1;'),
(4838,'Orcish Glaive - Critical Stun','lrhand','true',2030,2,2,'fine_steel','c',107,10,'pole',8,-3.00000,0,0,0,325,0,61,-1,2290000,916,'true','true','true','true',0,0,0,0,0,3571,1,18,0,'0-0;'),
(4839,'Orcish Glaive - Towering Blow','lrhand','true',2030,2,2,'fine_steel','c',107,10,'pole',8,-3.00000,0,0,0,325,0,61,-1,2290000,916,'true','true','true','true',0,0,0,0,0,0,0,0,0,'3599-1;'),
(4840,'Body Slasher - Critical Stun','lrhand','true',2030,2,2,'fine_steel','c',107,10,'pole',8,-3.00000,0,0,0,325,0,61,-1,2290000,916,'true','true','true','true',0,0,0,0,0,3571,1,18,0,'0-0;'),
(4841,'Body Slasher - Towering Blow','lrhand','true',2030,2,2,'fine_steel','c',107,10,'pole',8,-3.00000,0,0,0,325,0,61,-1,2290000,916,'true','true','true','true',0,0,0,0,0,0,0,0,0,'3599-1;'),
(4842,'Body Slasher - Wide Blow','lrhand','true',2030,2,2,'fine_steel','c',107,10,'pole',8,-3.00000,0,0,0,325,0,61,-1,2290000,916,'true','true','true','true',0,0,0,0,0,0,0,0,0,'3599-1;'),
(4843,'Bec de Corbin - Critical Stun','lrhand','true',2020,2,2,'fine_steel','c',122,10,'pole',8,-3.00000,0,0,0,325,0,68,-1,2870000,1148,'true','true','true','true',0,0,0,0,0,3571,1,17,0,'0-0;'),
(4844,'Bec de Corbin - Towering Blow','lrhand','true',2020,2,2,'fine_steel','c',122,10,'pole',8,-3.00000,0,0,0,325,0,68,-1,2870000,1148,'true','true','true','true',0,0,0,0,0,0,0,0,0,'3599-1;'),
(4845,'Bec de Corbin - Light','lrhand','true',600,2,2,'fine_steel','c',122,10,'pole',8,-3.00000,0,0,0,325,0,68,-1,2870000,1148,'true','true','true','true',0,0,0,0,0,0,0,0,0,'3498-1;'),
(4846,'Scorpion - Anger','lrhand','true',1990,3,3,'fine_steel','c',144,10,'pole',8,-3.00000,0,0,0,325,0,78,-1,4780000,1912,'true','true','true','true',0,0,0,0,0,0,0,0,0,'3600-3;'),
(4847,'Scorpion - Critical Stun','lrhand','true',1990,3,3,'fine_steel','c',144,10,'pole',8,-3.00000,0,0,0,325,0,78,-1,4780000,1912,'true','true','true','true',0,0,0,0,0,3571,1,16,0,'0-0;'),
(4848,'Scorpion - Towering Blow','lrhand','true',1990,3,3,'fine_steel','c',144,10,'pole',8,-3.00000,0,0,0,325,0,78,-1,4780000,1912,'true','true','true','true',0,0,0,0,0,0,0,0,0,'3599-1;'),
(4849,'Widow Maker - Critical Stun','lrhand','true',1980,3,3,'fine_steel','c',144,10,'pole',8,-3.00000,0,0,0,325,0,78,-1,4780000,1912,'true','true','true','true',0,0,0,0,0,3571,1,16,0,'0-0;'),
(4850,'Widow Maker - Towering Blow','lrhand','true',1980,3,3,'fine_steel','c',144,10,'pole',8,-3.00000,0,0,0,325,0,78,-1,4780000,1912,'true','true','true','true',0,0,0,0,0,0,0,0,0,'3599-1;'),
(4851,'Widow Maker - Wide Blow','lrhand','true',1980,3,3,'fine_steel','c',144,10,'pole',8,-3.00000,0,0,0,325,0,78,-1,4780000,1912,'true','true','true','true',0,0,0,0,0,0,0,0,0,'3599-1;'),
(4852,'Orcish Poleaxe - Critical Stun','lrhand','true',1950,3,3,'blood_steel','c',156,10,'pole',8,-3.00000,0,0,0,325,0,83,-1,6130000,2452,'true','true','true','true',0,0,0,0,0,3571,1,15,0,'0-0;'),
(4853,'Orcish Poleaxe - Towering Blow','lrhand','true',1950,3,3,'blood_steel','c',156,10,'pole',8,-3.00000,0,0,0,325,0,83,-1,6130000,2452,'true','true','true','true',0,0,0,0,0,0,0,0,0,'3599-1;'),
(4854,'Orcish Poleaxe - Wide Blow','lrhand','true',1950,3,3,'blood_steel','c',156,10,'pole',8,-3.00000,0,0,0,325,0,83,-1,6130000,2452,'true','true','true','true',0,0,0,0,0,0,0,0,0,'3599-1;'),
(4855,'Great Axe - Anger','lrhand','true',1940,1,1,'damascus','b',175,10,'pole',8,-3.00000,0,0,0,325,0,91,-1,8680000,1157,'true','true','true','true',0,0,0,0,0,0,0,0,0,'3600-5;'),
(4856,'Great Axe - Critical Stun','lrhand','true',1940,1,1,'damascus','b',175,10,'pole',8,-3.00000,0,0,0,325,0,91,-1,8680000,1157,'true','true','true','true',0,0,0,0,0,3571,1,14,0,'0-0;'),
(4857,'Great Axe - Light','lrhand','true',580,1,1,'damascus','b',175,10,'pole',8,-3.00000,0,0,0,325,0,91,-1,8680000,1157,'true','true','true','true',0,0,0,0,0,0,0,0,0,'3498-1;'),
(4858,'Lance - Anger','lrhand','true',1920,1,1,'blood_steel','b',194,10,'pole',8,-3.00000,0,0,0,325,0,99,-1,13100000,1746,'true','true','true','true',0,0,0,0,0,0,0,0,0,'3600-6;'),
(4859,'Lance - Critical Stun','lrhand','true',1920,1,1,'blood_steel','b',194,10,'pole',8,-3.00000,0,0,0,325,0,99,-1,13100000,1746,'true','true','true','true',0,0,0,0,0,3571,1,13,0,'0-0;'),
(4860,'Lance - Towering Blow','lrhand','true',1920,1,1,'blood_steel','b',194,10,'pole',8,-3.00000,0,0,0,325,0,99,-1,13100000,1746,'true','true','true','true',0,0,0,0,0,0,0,0,0,'3599-1;'),
(4861,'Halberd - Critical Stun','lrhand','true',1900,1,1,'oriharukon','a',213,10,'pole',8,-3.00000,0,0,0,325,0,107,-1,18300000,1464,'true','true','true','true',0,0,0,0,0,3571,1,15,0,'0-0;'),
(4862,'Halberd - Towering Blow','lrhand','true',1900,1,1,'oriharukon','a',213,10,'pole',8,-3.00000,0,0,0,325,0,107,-1,18300000,1464,'true','true','true','true',0,0,0,0,0,0,0,0,0,'3599-1;'),
(4863,'Halberd - Wide Blow','lrhand','true',1900,1,1,'oriharukon','a',213,10,'pole',8,-3.00000,0,0,0,325,0,107,-1,18300000,1464,'true','true','true','true',0,0,0,0,0,0,0,0,0,'3599-1;'),
(4864,'Heavy Doom Hammer - Magic Regeneration','lrhand','true',1020,2,2,'fine_steel','c',103,20,'bigblunt',4,4.00000,0,0,0,325,0,81,-1,2290000,916,'true','true','true','true',0,0,1044,1,30,0,0,0,0,'0-0;'),
(4865,'Heavy Doom Hammer - Mental Shield','lrhand','true',1020,2,2,'fine_steel','c',103,20,'bigblunt',4,4.00000,0,0,0,325,0,81,-1,2290000,916,'true','true','true','true',0,0,1035,2,30,0,0,0,0,'0-0;'),
(4866,'Heavy Doom Hammer - Magic Hold','lrhand','true',1020,2,2,'fine_steel','c',103,20,'bigblunt',4,4.00000,0,0,0,325,0,81,-1,2290000,916,'true','true','true','true',0,0,3577,1,10,0,0,0,0,'0-0;'),
(4867,'Crystal Staff - Rsk. Evasion','lrhand','true',1020,2,2,'crystal','c',103,20,'bigblunt',4,4.00000,0,0,0,325,0,81,-1,2290000,916,'true','true','true','true',0,0,0,0,0,0,0,0,0,'3031-1;'),
(4868,'Crystal Staff - Mana Up','lrhand','true',1020,2,2,'crystal','c',103,20,'bigblunt',4,4.00000,0,0,0,325,0,81,-1,2290000,916,'true','true','true','true',0,0,0,0,0,0,0,0,0,'3014-1;'),
(4869,'Crystal Staff - Bodily Blessing','lrhand','true',1020,2,2,'crystal','c',103,20,'bigblunt',4,4.00000,0,0,0,325,0,81,-1,2290000,916,'true','true','true','true',0,0,1045,2,20,0,0,0,0,'0-0;'),
(4870,'Heavy Doom Axe - Magic Poison','lrhand','true',1010,2,2,'fine_steel','c',103,20,'bigblunt',4,4.00000,0,0,0,325,0,81,-1,2290000,916,'true','true','true','true',0,0,1168,6,8,0,0,0,0,'0-0;'),
(4871,'Heavy Doom Axe - Magic Weakness','lrhand','true',1010,2,2,'fine_steel','c',103,20,'bigblunt',4,4.00000,0,0,0,325,0,81,-1,2290000,916,'true','true','true','true',0,0,1164,6,8,0,0,0,0,'0-0;'),
(4872,'Heavy Doom Axe - Magic Chaos','lrhand','true',1010,2,2,'fine_steel','c',103,20,'bigblunt',4,4.00000,0,0,0,325,0,81,-1,2290000,916,'true','true','true','true',0,0,1222,2,8,0,0,0,0,'0-0;'),
(4873,'Cursed Staff - Magic Hold','lrhand','true',1000,2,2,'wood','c',119,20,'bigblunt',4,4.00000,0,0,0,325,0,91,-1,2870000,1148,'true','true','true','true',0,0,3577,1,10,0,0,0,0,'0-0;'),
(4874,'Cursed Staff - Magic Poison','lrhand','true',1000,2,2,'wood','c',119,20,'bigblunt',4,4.00000,0,0,0,325,0,91,-1,2870000,1148,'true','true','true','true',0,0,1168,6,8,0,0,0,0,'0-0;'),
(4875,'Cursed Staff - Magic Weakness','lrhand','true',1000,2,2,'wood','c',119,20,'bigblunt',4,4.00000,0,0,0,325,0,91,-1,2870000,1148,'true','true','true','true',0,0,1164,6,8,0,0,0,0,'0-0;'),
(4876,'Paradia Staff - Magic Regeneration','lrhand','true',1010,3,3,'wood','c',135,20,'bigblunt',4,4.00000,0,0,0,325,0,101,-1,4300000,1720,'true','true','true','true',0,0,1044,2,30,0,0,0,0,'0-0;'),
(4877,'Paradia Staff - Mental Shield','lrhand','true',1010,3,3,'wood','c',135,20,'bigblunt',4,4.00000,0,0,0,325,0,101,-1,4300000,1720,'true','true','true','true',0,0,1035,3,30,0,0,0,0,'0-0;'),
(4878,'Paradia Staff - Magic Hold','lrhand','true',1010,3,3,'wood','c',135,20,'bigblunt',4,4.00000,0,0,0,325,0,101,-1,4300000,1720,'true','true','true','true',0,0,0,0,0,0,0,0,0,'0-0;'),
(4879,'Pa''agrian Hammer - Rsk. Evasion','lrhand','true',1010,3,3,'blood_steel','c',135,20,'bigblunt',4,4.00000,0,0,0,325,0,101,-1,4300000,1720,'true','true','true','true',0,0,0,0,0,0,0,0,0,'3031-3;'),
(4880,'Pa''agrian Hammer - Magic Poison','lrhand','true',1010,3,3,'blood_steel','c',135,20,'bigblunt',4,4.00000,0,0,0,325,0,101,-1,4300000,1720,'true','true','true','true',0,0,1168,6,7,0,0,0,0,'0-0;'),
(4881,'Pa''agrian Hammer - Magic Weakness','lrhand','true',1010,3,3,'blood_steel','c',135,20,'bigblunt',4,4.00000,0,0,0,325,0,101,-1,4300000,1720,'true','true','true','true',0,0,1164,6,7,0,0,0,0,'0-0;'),
(4882,'Sage''s Staff - Magic Hold','lrhand','true',1000,3,3,'wood','c',135,20,'bigblunt',4,4.00000,0,0,0,325,0,101,-1,4300000,1720,'true','true','true','true',0,0,3577,1,10,0,0,0,0,'0-0;'),
(4883,'Sage''s Staff - Magic Poison','lrhand','true',1000,3,3,'wood','c',135,20,'bigblunt',4,4.00000,0,0,0,325,0,101,-1,4300000,1720,'true','true','true','true',0,0,1168,6,7,0,0,0,0,'0-0;'),
(4884,'Sage''s Staff - Magic Weakness','lrhand','true',1000,3,3,'wood','c',135,20,'bigblunt',4,4.00000,0,0,0,325,0,101,-1,4300000,1720,'true','true','true','true',0,0,1164,6,7,0,0,0,0,'0-0;'),
(4885,'Pa''agrian Axe - Mana Up','lrhand','true',990,3,3,'blood_steel','c',141,20,'bigblunt',4,4.00000,0,0,0,325,0,104,-1,4780000,1912,'true','true','true','true',0,0,0,0,0,0,0,0,0,'3014-1;'),
(4886,'Pa''agrian Axe - Magic Weakness','lrhand','true',990,3,3,'blood_steel','c',141,20,'bigblunt',4,4.00000,0,0,0,325,0,104,-1,4780000,1912,'true','true','true','true',0,0,1164,6,7,0,0,0,0,'0-0;'),
(4887,'Pa''agrian Axe - Magic Chaos','lrhand','true',990,3,3,'blood_steel','c',141,20,'bigblunt',4,4.00000,0,0,0,325,0,104,-1,4780000,1912,'true','true','true','true',0,0,1222,2,7,0,0,0,0,'0-0;'),
(4888,'Deadman''s Staff - Magic Regeneration','lrhand','true',1010,3,3,'bone','c',152,20,'bigblunt',4,4.00000,0,0,0,325,0,111,-1,6130000,2452,'true','true','true','true',0,0,1044,2,30,0,0,0,0,'0-0;'),
(4889,'Deadman''s Staff - Mental Shield','lrhand','true',1010,3,3,'bone','c',152,20,'bigblunt',4,4.00000,0,0,0,325,0,111,-1,6130000,2452,'true','true','true','true',0,0,1035,3,30,0,0,0,0,'0-0;'),
(4890,'Deadman''s Staff - Magic Hold','lrhand','true',1010,3,3,'bone','c',152,20,'bigblunt',4,4.00000,0,0,0,325,0,111,-1,6130000,2452,'true','true','true','true',0,0,3577,1,10,0,0,0,0,'0-0;'),
(4891,'Ghoul''s Staff - Rsk. Evasion','lrhand','true',1000,3,3,'bone','c',152,20,'bigblunt',4,4.00000,0,0,0,325,0,111,-1,6130000,2452,'true','true','true','true',0,0,0,0,0,0,0,0,0,'3031-4;'),
(4892,'Ghoul''s Staff - Mana Up','lrhand','true',1000,3,3,'bone','c',152,20,'bigblunt',4,4.00000,0,0,0,325,0,111,-1,6130000,2452,'true','true','true','true',0,0,0,0,0,0,0,0,0,'3014-1;'),
(4893,'Ghoul''s Staff - Bodily Blessing','lrhand','true',1000,3,3,'bone','c',152,20,'bigblunt',4,4.00000,0,0,0,325,0,111,-1,6130000,2452,'true','true','true','true',0,0,1045,4,20,0,0,0,0,'0-0;'),
(4894,'Demon''s Staff - Magic Poison','lrhand','true',990,3,3,'wood','c',152,20,'bigblunt',4,4.00000,0,0,0,325,0,111,-1,6130000,2452,'true','true','true','true',0,0,1168,6,7,0,0,0,0,'0-0;'),
(4895,'Demon''s Staff - Magic Weakness','lrhand','true',990,3,3,'wood','c',152,20,'bigblunt',4,4.00000,0,0,0,325,0,111,-1,6130000,2452,'true','true','true','true',0,0,1164,6,7,0,0,0,0,'0-0;'),
(4896,'Demon''s Staff - Magic Chaos','lrhand','true',990,3,3,'wood','c',152,20,'bigblunt',4,4.00000,0,0,0,325,0,111,-1,6130000,2452,'true','true','true','true',0,0,1222,2,7,0,0,0,0,'0-0;'),
(4897,'Sprite''s Staff - Magic Regeneration','lrhand','true',960,1,1,'wood','b',170,20,'bigblunt',4,4.00000,0,0,0,325,0,122,-1,8680000,1157,'true','true','true','true',0,0,1044,3,30,0,0,0,0,'0-0;'),
(4898,'Sprite''s Staff - Mental Shield','lrhand','true',960,1,1,'wood','b',170,20,'bigblunt',4,4.00000,0,0,0,325,0,122,-1,8680000,1157,'true','true','true','true',0,0,1035,4,30,0,0,0,0,'0-0;'),
(4899,'Sprite''s Staff - Magic Hold','lrhand','true',960,1,1,'wood','b',170,20,'bigblunt',4,4.00000,0,0,0,325,0,122,-1,8680000,1157,'true','true','true','true',0,0,3577,1,10,0,0,0,0,'0-0;'),
(4900,'Staff of Evil Spirits - Magic Focus','lrhand','true',930,1,1,'wood','b',189,20,'bigblunt',4,4.00000,0,0,0,325,0,132,-1,13100000,1746,'true','true','true','true',0,0,1077,3,20,0,0,0,0,'0-0;'),
(4901,'Staff of Evil Spirits - Bodily Blessing','lrhand','true',930,1,1,'wood','b',189,20,'bigblunt',4,4.00000,0,0,0,325,0,132,-1,13100000,1746,'true','true','true','true',0,0,1045,5,20,0,0,0,0,'0-0;'),
(4902,'Staff of Evil Spirits - Magic Poison','lrhand','true',930,1,1,'wood','b',189,20,'bigblunt',4,4.00000,0,0,0,325,0,132,-1,13100000,1746,'true','true','true','true',0,0,1168,6,6,0,0,0,0,'0-0;'),
(4903,'Dasparion''s Staff','lrhand','true',920,1,1,'adamantaite','a',207,20,'bigblunt',4,4.00000,0,0,0,325,0,143,-1,18300000,1464,'true','true','true','true',0,0,0,0,0,0,0,0,0,'0-0;'),
(4904,'Dasparion''s Staff','lrhand','true',920,1,1,'adamantaite','a',207,20,'bigblunt',4,4.00000,0,0,0,325,0,143,-1,18300000,1464,'true','true','true','true',0,0,0,0,0,0,0,0,0,'0-0;'),
(4905,'Dasparion''s Staff','lrhand','true',920,1,1,'adamantaite','a',207,20,'bigblunt',4,4.00000,0,0,0,325,0,143,-1,18300000,1464,'true','true','true','true',0,0,0,0,0,0,0,0,0,'0-0;'),
(5127,'Dailaon Knife','rhand','false',300,2,2,'steel','d',5,5,'dagger',12,-3.00000,0,0,0,433,0,5,-1,409000,743,'true','true','true','true',0,0,0,0,0,0,0,0,0,'0-0;'),
(5128,'Crokian Blade','rhand','true',300,2,2,'steel','d',5,5,'dagger',12,-3.00000,0,0,0,433,0,5,-1,409000,743,'true','true','true','true',0,0,0,0,0,0,0,0,0,'0-0;'),
(5129,'Doll Knife','lrhand','false',300,2,2,'steel','d',200,10,'dual',8,0.00000,0,0,0,325,0,6,-1,409000,743,'true','true','true','true',0,0,0,0,0,0,0,0,0,'0-0;'),
(5130,'Nos Sword','rhand','true',300,2,2,'steel','d',5,5,'dagger',12,-3.00000,0,0,0,433,0,5,-1,409000,743,'true','true','true','true',0,0,0,0,0,0,0,0,0,'0-0;'),
(5131,'Parhit Staff','rhand','true',300,2,2,'steel','d',5,5,'dagger',12,-3.00000,0,0,0,433,0,5,-1,409000,743,'true','true','true','true',0,0,0,0,0,0,0,0,0,'0-0;'),
(5132,'Giant Trident','rhand','true',300,2,2,'steel','d',5,5,'dagger',12,-3.00000,0,0,0,433,0,5,-1,409000,743,'true','true','true','true',0,0,0,0,0,0,0,0,0,'0-0;'),
(5133,'Chrono Unitus','lrhand','false',0,0,0,'steel','none',1,5,'dualfist',4,4.00000,0,0,0,325,0,1,-1,0,0,'true','false','true','true',0,0,0,0,0,0,0,0,0,'0-0;'),
(5176,'Serpentine Spike','strider','false',100,1,1,'steel','none',17,10,'pet',8,0.00000,0,0,0,277,0,21,-1,1600000,0,'true','true','true','true',0,0,0,0,0,0,0,0,0,'0-0;'),
(5177,'Drake Horn','strider','false',100,1,1,'steel','none',19,10,'pet',8,0.00000,0,0,0,277,0,24,-1,2300000,0,'true','true','true','true',0,0,0,0,0,0,0,0,0,'0-0;'),
(5178,'Assult Alicorn','strider','false',100,1,1,'steel','none',21,10,'pet',8,0.00000,0,0,0,277,0,27,-1,3400000,0,'true','true','true','true',0,0,0,0,0,0,0,0,0,'0-0;'),
(5179,'Draconic Slicer','strider','false',100,1,1,'steel','none',23,10,'pet',8,0.00000,0,0,0,277,0,30,-1,4900000,0,'true','true','true','true',0,0,0,0,0,0,0,0,0,'0-0;'),
(5180,'Ohpdian Lance','strider','false',100,1,1,'steel','none',25,10,'pet',8,0.00000,0,0,0,277,0,34,-1,7300000,0,'true','true','true','true',0,0,0,0,0,0,0,0,0,'0-0;'),
(5181,'Diamond Drill','strider','false',100,1,1,'steel','none',27,10,'pet',8,0.00000,0,0,0,277,0,37,-1,10000000,0,'true','true','true','true',0,0,0,0,0,0,0,0,0,'0-0;'),
(5187,'Serpentine Grinder','hatchling','false',100,1,1,'steel','none',19,10,'pet',8,0.00000,0,0,0,277,0,24,-1,2300000,0,'true','true','true','true',0,0,0,0,0,0,0,0,0,'0-0;'),
(5188,'Fang of Dahak','hatchling','false',100,1,1,'steel','none',21,10,'pet',8,0.00000,0,0,0,277,0,27,-1,3400000,0,'true','true','true','true',0,0,0,0,0,0,0,0,0,'0-0;'),
(5189,'Crimson Blood Fang','hatchling','false',100,1,1,'steel','none',23,10,'pet',8,0.00000,0,0,0,277,0,30,-1,4900000,0,'true','true','true','true',0,0,0,0,0,0,0,0,0,'0-0;'),
(5190,'Draconic Chopper','hatchling','false',100,1,1,'steel','none',25,10,'pet',8,0.00000,0,0,0,277,0,34,-1,7300000,0,'true','true','true','true',0,0,0,0,0,0,0,0,0,'0-0;'),
(5191,'Diabolic Grinder','hatchling','false',100,1,1,'steel','none',27,10,'pet',8,0.00000,0,0,0,277,0,37,-1,10000000,0,'true','true','true','true',0,0,0,0,0,0,0,0,0,'0-0;'),
(5217,'Wolf Level 75 Weapon','wolf','false',100,1,1,'steel','none',194,10,'pet',8,0.00000,0,0,0,277,0,136,-1,61084,0,'true','true','true','true',0,0,0,0,0,0,0,0,0,'0-0;'),
(5233,'Keshanberk*Keshanberk','lrhand','true',2080,1,1,'fine_steel','a',259,10,'dual',8,0.00000,0,0,0,325,0,107,-1,18300000,1464,'true','true','true','true',0,0,0,0,0,0,0,0,0,'0-0;'),
(5284,'Zweihander','lrhand','false',1530,2,2,'bronze','none',38,10,'bigsword',8,0.00000,0,0,0,325,0,21,-1,244000,0,'true','true','true','true',0,0,0,0,0,0,0,0,0,'0-0;'),
(5285,'Heavy Sword','lrhand','true',1520,2,2,'steel','d',49,10,'bigsword',8,0.00000,0,0,0,325,0,26,-1,409000,743,'true','true','true','true',0,0,0,0,0,0,0,0,9210,'0-0;'),
(5286,'Berserker Blade','lrhand','true',1380,3,3,'oriharukon','c',190,10,'bigsword',8,0.00000,0,0,0,325,0,83,-1,6130000,2452,'true','true','true','true',0,0,0,0,0,0,0,0,9296,'0-0;'),
(5292,'Sealed Dark Crystal Shield','lhand','true',1190,0,0,'crystal','a',0,0,'none',0,0.00000,-8,243,20,0,0,0,-1,1220000,97,'true','true','true','true',0,0,0,0,0,0,0,0,0,'0-0;'),
(5315,'Sealed Shield of Nightmare','lhand','true',1180,0,0,'leather','a',0,0,'none',0,0.00000,-8,256,20,0,0,0,-1,1850000,148,'true','true','true','true',0,0,0,0,0,0,0,0,0,'0-0;'),
(5596,'Dasparion''s Staff - Mana Up','lrhand','true',920,1,1,'adamantaite','a',207,20,'bigblunt',4,4.00000,0,0,0,325,0,143,-1,18300000,1464,'true','true','true','true',0,0,0,0,0,0,0,0,0,'3014-2;'),
(5597,'Dasparion''s Staff - Conversion','lrhand','true',920,1,1,'adamantaite','a',207,20,'bigblunt',4,4.00000,0,0,0,325,0,143,-1,18300000,1464,'true','true','true','true',0,0,0,0,0,0,0,0,0,'3048-2;'),
(5598,'Dasparion''s Staff - Acumen','lrhand','true',920,1,1,'adamantaite','a',207,20,'bigblunt',4,4.00000,0,0,0,325,0,143,-1,18300000,1464,'true','true','true','true',0,0,0,0,0,0,0,0,0,'3047-2;'),
(5599,'Meteor Shower - Focus','rhand','true',1600,1,1,'fine_steel','a',213,20,'blunt',4,4.00000,0,0,0,379,0,107,-1,18300000,1464,'true','true','true','true',0,0,0,0,0,0,0,0,0,'3044-1;'),
(5600,'Meteor Shower - Critical Bleed','rhand','true',1600,1,1,'fine_steel','a',213,20,'blunt',4,4.00000,0,0,0,379,0,107,-1,18300000,1464,'true','true','true','true',0,0,0,0,0,0,0,0,0,'0-0;'),
(5601,'Meteor Shower - Rsk. Haste','rhand','true',1600,1,1,'fine_steel','a',213,20,'blunt',4,4.00000,0,0,0,379,0,107,-1,18300000,1464,'true','true','true','true',0,0,0,0,0,0,0,0,0,'3056-1;'),
(5602,'Elysian - Health','rhand','true',1580,1,1,'oriharukon','a',232,20,'blunt',4,4.00000,0,0,0,379,0,114,-1,27000000,2160,'true','true','true','true',0,0,0,0,0,3021,5,42,0,'3013-3;'),
(5603,'Elysian - Anger','rhand','true',1580,1,1,'oriharukon','a',232,20,'blunt',4,4.00000,0,0,0,379,0,114,-1,27000000,2160,'true','true','true','true',0,0,0,0,0,0,0,0,0,'3057-2;'),
(5604,'Elysian - Critical Drain','rhand','true',1580,1,1,'oriharukon','a',232,20,'blunt',4,4.00000,0,0,0,379,0,114,-1,27000000,2160,'true','true','true','true',0,0,0,0,0,0,0,0,0,'3072-1;'),
(5605,'Branch of The Mother Tree - Conversion','lrhand','true',900,1,1,'wood','a',226,20,'bigblunt',4,4.00000,0,0,0,325,0,152,-1,27000000,2160,'true','true','true','true',0,0,0,0,0,0,0,0,0,'3048-2;'),
(5606,'Branch of The Mother Tree - Magic Damage','lrhand','true',900,1,1,'wood','a',226,20,'bigblunt',4,4.00000,0,0,0,325,0,152,-1,27000000,2160,'true','true','true','true',0,0,0,0,0,0,0,0,0,'3552-1;'),
(5607,'Branch of The Mother Tree - Acumen','lrhand','true',900,1,1,'wood','a',226,20,'bigblunt',4,4.00000,0,0,0,325,0,152,-1,27000000,2160,'true','true','true','true',0,0,0,0,0,0,0,0,0,'3047-2;'),
(5608,'Carnage Bow - Light','lrhand','true',500,2,1,'damascus','a',440,5,'bow',12,-3.00000,0,0,0,293,9,107,-1,18300000,1464,'true','true','true','true',0,0,0,0,0,0,0,0,9337,'3498-1;'),
(5609,'Carnage Bow - Critical Bleed','lrhand','true',1670,2,1,'damascus','a',440,5,'bow',12,-3.00000,0,0,0,293,9,107,-1,18300000,1464,'true','true','true','true',0,0,0,0,0,0,0,0,9338,'0-0;'),
(5610,'Carnage Bow - Mana Up','lrhand','true',1670,2,1,'damascus','a',440,5,'bow',12,-3.00000,0,0,0,293,9,107,-1,18300000,1464,'true','true','true','true',0,0,0,0,0,0,0,0,9339,'3014-2;'),
(5611,'Soul Bow - Cheap Shot','lrhand','true',1660,2,1,'oriharukon','a',528,5,'bow',12,-3.00000,0,0,0,227,10,125,-1,27000000,2160,'true','true','true','true',0,0,0,0,0,0,0,0,9349,'0-0;'),
(5612,'Soul Bow - Quick Recovery','lrhand','true',1660,2,1,'oriharukon','a',528,5,'bow',12,-3.00000,0,0,0,227,10,125,-1,27000000,2160,'true','true','true','true',0,0,0,0,0,0,0,0,9350,'0-0;'),
(5613,'Soul Bow - Critical Poison','lrhand','true',1660,2,1,'oriharukon','a',528,5,'bow',12,-3.00000,0,0,0,227,10,125,-1,27000000,2160,'true','true','true','true',0,0,0,0,0,0,0,0,9351,'0-0;'),
(5614,'Bloody Orchid - Focus','rhand','true',960,1,1,'blood_steel','a',186,5,'dagger',12,-3.00000,0,0,0,433,0,107,-1,18300000,1464,'true','true','true','true',0,0,0,0,0,0,0,0,0,'3044-5;'),
(5615,'Bloody Orchid - Back Blow','rhand','true',960,1,1,'blood_steel','a',186,5,'dagger',12,-3.00000,0,0,0,433,0,107,-1,18300000,1464,'true','true','true','true',0,0,0,0,0,0,0,0,0,'0-0;'),
(5616,'Bloody Orchid - Critical Bleed','rhand','true',960,1,1,'blood_steel','a',186,5,'dagger',12,-3.00000,0,0,0,433,0,107,-1,18300000,1464,'true','true','true','true',0,0,0,0,0,3021,5,35,0,'0-0;'),
(5617,'Soul Separator - Guidance','rhand','true',950,1,1,'oriharukon','a',203,5,'dagger',12,-3.00000,0,0,0,433,0,114,-1,27000000,2160,'true','true','true','true',0,0,0,0,0,0,0,0,0,'3064-1;'),
(5618,'Soul Separator - Critical Damage','rhand','true',950,1,1,'oriharukon','a',203,5,'dagger',12,-3.00000,0,0,0,433,0,114,-1,27000000,2160,'true','true','true','true',0,0,0,0,0,0,0,0,0,'3066-1;'),
(5619,'Soul Separator - Rsk. Haste','rhand','true',950,1,1,'oriharukon','a',203,5,'dagger',12,-3.00000,0,0,0,433,0,114,-1,27000000,2160,'true','true','true','true',0,0,0,0,0,0,0,0,0,'3056-1;'),
(5620,'Blood Tornado - Haste','lrhand','true',1370,1,1,'blood_steel','a',259,5,'dualfist',4,4.00000,0,0,0,325,0,107,-1,18300000,1464,'true','true','true','true',0,0,0,0,0,0,0,0,0,'3068-1;'),
(5621,'Blood Tornado - Focus','lrhand','true',1370,1,1,'blood_steel','a',259,5,'dualfist',4,4.00000,0,0,0,325,0,107,-1,18300000,1464,'true','true','true','true',0,0,0,0,0,0,0,0,0,'3044-1;'),
(5622,'Blood Tornado - Anger','lrhand','true',1370,1,1,'blood_steel','a',259,5,'dualfist',4,4.00000,0,0,0,325,0,107,-1,18300000,1464,'true','true','true','true',0,0,0,0,0,0,0,0,0,'3058-1;'),
(5623,'Dragon Grinder - Rsk. Evasion','lrhand','true',1350,1,1,'adamantaite','a',282,5,'dualfist',4,4.00000,0,0,0,325,0,114,-1,27000000,2160,'true','true','true','true',0,0,0,0,0,0,0,0,0,'3069-1;'),
(5624,'Dragon Grinder - Guidance','lrhand','true',1350,1,1,'adamantaite','a',282,5,'dualfist',4,4.00000,0,0,0,325,0,114,-1,27000000,2160,'true','true','true','true',0,0,0,0,0,0,0,0,0,'3065-1;'),
(5625,'Dragon Grinder - Health','lrhand','true',1350,1,1,'adamantaite','a',282,5,'dualfist',4,4.00000,0,0,0,325,0,114,-1,27000000,2160,'true','true','true','true',0,0,0,0,0,0,0,0,0,'3013-3;'),
(5626,'Halberd - Haste','lrhand','true',1900,1,1,'oriharukon','a',213,10,'pole',8,-3.00000,0,0,0,325,0,107,-1,18300000,1464,'true','true','true','true',0,0,0,0,0,0,0,0,0,'3601-7;'),
(5627,'Halberd - Critical Stun','lrhand','true',1900,1,1,'oriharukon','a',213,10,'pole',8,-3.00000,0,0,0,325,0,107,-1,18300000,1464,'true','true','true','true',0,0,0,0,0,3070,1,25,0,'0-0;'),
(5628,'Halberd - Wide Blow','lrhand','true',1900,1,1,'oriharukon','a',213,10,'pole',8,-3.00000,0,0,0,325,0,107,-1,18300000,1464,'true','true','true','true',0,0,0,0,0,0,0,0,0,'0-0;'),
(5629,'Orcish Halberd','lrhand','true',1880,1,1,'blood_steel','a',219,10,'pole',8,-3.00000,0,0,0,325,0,109,-1,21300000,1704,'true','true','true','true',0,0,0,0,0,0,0,0,0,'0-0;'),
(5630,'Orcish Halberd','lrhand','true',1880,1,1,'blood_steel','a',219,10,'pole',8,-3.00000,0,0,0,325,0,109,-1,21300000,1704,'true','true','true','true',0,0,0,0,0,0,0,0,0,'0-0;'),
(5631,'Orcish Halberd','lrhand','true',1880,1,1,'blood_steel','a',219,10,'pole',8,-3.00000,0,0,0,325,0,109,-1,21300000,1704,'true','true','true','true',0,0,0,0,0,0,0,0,0,'0-0;'),
(5632,'Tallum Glaive - Guidance','lrhand','true',1840,1,1,'chrysolite','a',232,10,'pole',8,-3.00000,0,0,0,325,0,114,-1,27000000,2160,'true','true','true','true',0,0,0,0,0,0,0,0,0,'3602-8;'),
(5633,'Tallum Glaive - Health','lrhand','true',1840,1,1,'chrysolite','a',232,10,'pole',8,-3.00000,0,0,0,325,0,114,-1,27000000,2160,'true','true','true','true',0,0,0,0,0,0,0,0,0,'3013-4;'),
(5634,'Tallum Glaive - Wide Blow','lrhand','true',1840,1,1,'chrysolite','a',232,10,'pole',8,-3.00000,0,0,0,325,0,114,-1,27000000,2160,'true','true','true','true',0,0,0,0,0,0,0,0,0,'0-0;'),
(5635,'Tallum Blade - Critical Poison','rhand','true',1330,1,1,'adamantaite','a',213,10,'sword',8,0.00000,0,0,0,379,0,107,-1,18300000,1464,'true','true','true','true',0,0,0,0,0,3024,5,10,9329,'0-0;'),
(5636,'Tallum Blade - Haste','rhand','true',1330,1,1,'adamantaite','a',213,10,'sword',8,0.00000,0,0,0,379,0,107,-1,18300000,1464,'true','true','true','true',0,0,0,0,0,0,0,0,9330,'3068-1;'),
(5637,'Tallum Blade - Anger','rhand','true',1330,1,1,'adamantaite','a',213,10,'sword',8,0.00000,0,0,0,379,0,107,-1,18300000,1464,'true','true','true','true',0,0,0,0,0,0,0,0,9331,'3057-1;'),
(5638,'Elemental Sword - Magic Power','rhand','true',830,1,1,'mithril','a',170,10,'sword',8,0.00000,0,0,0,379,0,143,-1,18300000,1464,'true','true','true','true',0,0,0,0,0,0,0,0,0,'3073-1;'),
(5639,'Elemental Sword - Magic Paralyze','rhand','true',830,1,1,'mithril','a',170,10,'sword',8,0.00000,0,0,0,379,0,143,-1,18300000,1464,'true','true','true','true',0,0,3075,1,10,0,0,0,0,'0-0;'),
(5640,'Elemental Sword - Empower','rhand','true',830,1,1,'mithril','a',170,10,'sword',8,0.00000,0,0,0,379,0,143,-1,18300000,1464,'true','true','true','true',0,0,0,0,0,0,0,0,0,'0-0;'),
(5641,'Sword of Miracles - Magic Power','rhand','true',840,1,1,'adamantaite','a',186,10,'sword',8,0.00000,0,0,0,379,0,152,-1,27000000,2160,'true','true','true','true',0,0,0,0,0,0,0,0,0,'3073-2;'),
(5642,'Sword of Miracles - Magic Silence','rhand','true',840,1,1,'adamantaite','a',186,10,'sword',8,0.00000,0,0,0,379,0,152,-1,27000000,2160,'true','true','true','true',0,0,3074,1,10,0,0,0,0,'0-0;'),
(5643,'Sword of Miracles - Acumen','rhand','true',840,1,1,'adamantaite','a',186,10,'sword',8,0.00000,0,0,0,379,0,152,-1,27000000,2160,'true','true','true','true',0,0,0,0,0,0,0,0,0,'3047-2;'),
(5644,'Dragon Slayer - Health','lrhand','true',1840,1,1,'bone','a',282,10,'bigsword',8,0.00000,0,0,0,325,0,114,-1,27000000,2160,'true','true','true','true',0,0,0,0,0,0,0,0,9345,'3013-3;'),
(5645,'Dragon Slayer - Critical Bleed','lrhand','true',1840,1,1,'bone','a',282,10,'bigsword',8,0.00000,0,0,0,325,0,114,-1,27000000,2160,'true','true','true','true',0,0,0,0,0,3021,5,24,9346,'0-0;'),
(5646,'Dragon Slayer - Critical Drain','lrhand','true',1840,1,1,'bone','a',282,10,'bigsword',8,0.00000,0,0,0,325,0,114,-1,27000000,2160,'true','true','true','true',0,0,0,0,0,3022,4,20,9347,'0-0;'),
(5647,'Dark Legion''s Edge - Critical Damage','rhand','true',1320,1,1,'fine_steel','a',232,10,'sword',8,0.00000,0,0,0,379,0,114,-1,27000000,2160,'true','true','true','true',0,0,0,0,0,0,0,0,9341,'3067-2;'),
(5648,'Dark Legion''s Edge - Health','rhand','true',1320,1,1,'fine_steel','a',232,10,'sword',8,0.00000,0,0,0,379,0,114,-1,27000000,2160,'true','true','true','true',0,0,0,0,0,0,0,0,9342,'3013-3;'),
(5649,'Dark Legion''s Edge - Rsk. Focus','rhand','true',1320,1,1,'fine_steel','a',232,10,'sword',8,0.00000,0,0,0,379,0,114,-1,27000000,2160,'true','true','true','true',0,0,0,0,0,0,0,0,9343,'3071-2;'),
(5704,'Keshanberk*Keshanberk','lrhand','true',2080,1,1,'fine_steel','a',259,10,'dual',8,0.00000,0,0,0,325,0,107,-1,18300000,1464,'true','true','true','true',0,0,0,0,0,0,0,0,0,'0-0;'),
(5705,'Keshanberk*Damascus','lrhand','true',2080,1,1,'fine_steel','a',275,10,'dual',8,0.00000,0,0,0,325,0,112,-1,24100000,1928,'true','true','true','true',0,0,0,0,0,0,0,0,0,'0-0;'),
(5706,'Damascus*Damascus','lrhand','true',2080,1,1,'fine_steel','a',282,10,'dual',8,0.00000,0,0,0,325,0,114,-1,27000000,2160,'true','true','true','true',0,0,0,0,0,0,0,0,0,'0-0;'),
(5791,'Tomb Guard A','lrhand','true',2180,2,2,'fine_steel','d',78,10,'bigsword',8,0.00000,0,0,0,325,0,39,-1,967000,0,'true','true','true','true',0,0,0,0,0,0,0,0,0,'0-0;'),
(5792,'Tomb Guard B','lrhand','true',2180,2,2,'fine_steel','d',78,10,'bigsword',8,0.00000,0,0,0,325,0,39,-1,967000,0,'true','true','true','true',0,0,0,0,0,0,0,0,0,'0-0;'),
(5793,'Tomb Savant A','rhand','true',1380,3,3,'oriharukon','c',156,10,'sword',8,0.00000,0,0,0,379,0,83,-1,6130000,0,'true','true','true','true',0,0,0,0,0,0,0,0,0,'0-0;'),
(5794,'Tomb Savant B','rhand','true',1380,3,3,'oriharukon','c',156,10,'sword',8,0.00000,0,0,0,379,0,83,-1,6130000,0,'true','true','true','true',0,0,0,0,0,0,0,0,0,'0-0;'),
(5795,'Tomb Guard A','lrhand','true',2180,2,2,'fine_steel','d',78,10,'bigsword',8,0.00000,0,0,0,325,0,39,-1,967000,0,'true','true','true','true',0,0,0,0,0,0,0,0,0,'0-0;'),
(5796,'Tomb Guard B','lrhand','true',2180,2,2,'fine_steel','d',78,10,'bigsword',8,0.00000,0,0,0,325,0,39,-1,967000,0,'true','true','true','true',0,0,0,0,0,0,0,0,0,'0-0;'),
(5797,'Tomb Savant A','rhand','true',1380,3,3,'oriharukon','c',156,10,'sword',8,0.00000,0,0,0,379,0,83,-1,6130000,0,'true','true','true','true',0,0,0,0,0,0,0,0,0,'0-0;'),
(5798,'Tomb Savant B','rhand','true',1380,3,3,'oriharukon','c',156,10,'sword',8,0.00000,0,0,0,379,0,83,-1,6130000,0,'true','true','true','true',0,0,0,0,0,0,0,0,0,'0-0;'),
(5799,'Nephilim Lord','lhand','true',1320,0,0,'leather','d',0,0,'none',0,0.00000,-8,142,20,0,0,0,-1,78400,0,'true','true','true','true',0,0,0,0,0,0,0,0,0,'0-0;'),
(5800,'Nephilim Lord','rhand','true',1380,3,3,'oriharukon','c',156,10,'sword',8,0.00000,0,0,0,379,0,83,-1,6130000,0,'true','true','true','true',0,0,0,0,0,0,0,0,0,'0-0;'),
(5801,'Dusk','rhand','true',1380,3,3,'oriharukon','c',156,10,'sword',8,0.00000,0,0,0,379,0,83,-1,6130000,0,'true','true','true','true',0,0,0,0,0,0,0,0,0,'0-0;'),
(5802,'Dawn','lhand','true',1380,3,3,'oriharukon','c',156,10,'sword',8,0.00000,0,0,0,379,0,83,-1,6130000,0,'true','true','true','true',0,0,0,0,0,0,0,0,0,'0-0;'),
(5817,'Chrono Campana','lrhand','false',0,0,0,'steel','none',1,10,'pole',8,-3.00000,0,0,0,325,0,1,-1,0,0,'true','false','true','true',0,0,0,0,0,0,0,0,0,'0-0;'),
(6307,'Sword of Limit - Guidance','rhand','true',1400,3,3,'fine_steel','c',139,10,'sword',8,0.00000,0,0,0,379,0,76,-1,4300000,1720,'true','true','true','true',0,0,0,0,0,0,0,0,9281,'3573-1;'),
(6308,'Sword of Limit - Critical Drain','rhand','true',1400,3,3,'fine_steel','c',139,10,'sword',8,0.00000,0,0,0,379,0,76,-1,4300000,1720,'true','true','true','true',0,0,0,0,0,3022,2,10,9282,'0-0;'),
(6309,'Sword of Limit - Health','rhand','true',1400,3,3,'fine_steel','c',139,10,'sword',8,0.00000,0,0,0,379,0,76,-1,4300000,1720,'true','true','true','true',0,0,0,0,0,0,0,0,9283,'3013-1;'),
(6310,'Sword of Whispering Death - Empower','rhand','true',920,3,3,'fine_steel','c',111,10,'sword',8,0.00000,0,0,0,379,0,101,-1,4300000,1720,'true','true','true','true',0,0,0,0,0,0,0,0,0,'3072-1;'),
(6311,'Sword of Whispering Death - Magic Power','rhand','true',920,3,3,'fine_steel','c',111,10,'sword',8,0.00000,0,0,0,379,0,101,-1,4300000,1720,'true','true','true','true',0,0,0,0,0,0,0,0,0,'3077-1;'),
(6312,'Sword of Whispering Death - Magic Silence','rhand','true',920,3,3,'fine_steel','c',111,10,'sword',8,0.00000,0,0,0,379,0,101,-1,4300000,1720,'true','true','true','true',0,0,3078,2,10,0,0,0,0,'0-0;'),
(6313,'Homunkulus''s Sword - Acumen','rhand','true',950,3,3,'blood_steel','c',111,10,'sword',8,0.00000,0,0,0,379,0,101,-1,4300000,1720,'true','true','true','true',0,0,0,0,0,0,0,0,0,'3047-1;'),
(6314,'Homunkulus''s Sword - Conversion','rhand','true',950,3,3,'blood_steel','c',111,10,'sword',8,0.00000,0,0,0,379,0,101,-1,4300000,1720,'true','true','true','true',0,0,0,0,0,0,0,0,0,'3048-1;'),
(6315,'Homunkulus''s Sword - Magic Paralyze','rhand','true',950,3,3,'blood_steel','c',111,10,'sword',8,0.00000,0,0,0,379,0,101,-1,4300000,1720,'true','true','true','true',0,0,3079,1,5,0,0,0,0,'0-0;'),
(6347,'Berserker Blade - Focus','lrhand','true',1380,3,3,'oriharukon','c',190,10,'bigsword',8,0.00000,0,0,0,325,0,83,-1,6130000,2452,'true','true','true','true',0,0,0,0,0,0,0,0,9297,'3044-8;'),
(6348,'Berserker Blade - Critical Damage','lrhand','true',1380,3,3,'oriharukon','c',190,10,'bigsword',8,0.00000,0,0,0,325,0,83,-1,6130000,2452,'true','true','true','true',0,0,0,0,0,0,0,0,9298,'0-0;'),
(6349,'Berserker Blade - Haste','lrhand','true',1380,3,3,'oriharukon','c',190,10,'bigsword',8,0.00000,0,0,0,325,0,83,-1,6130000,2452,'true','true','true','true',0,0,0,0,0,0,0,0,9299,'0-0;'),
(6354,'Falchion - for Beginners','rhand','false',1530,2,2,'bronze','none',31,10,'sword',8,0.00000,0,0,0,379,0,21,-1,0,0,'false','false','false','false',0,0,0,0,0,0,0,0,0,'0-0;'),
(6355,'Mage Staff - for Beginners','lrhand','false',1050,2,2,'wood','none',30,20,'bigblunt',4,4.00000,0,0,0,325,0,28,-1,0,0,'false','false','false','false',0,0,0,0,0,0,0,0,0,'0-0;'),
(6356,'Dark Elven Dagger - Rsk. Haste','rhand','true',1050,2,2,'fine_steel','c',94,5,'dagger',12,-3.00000,0,0,0,433,0,61,-1,2290000,916,'true','true','true','true',0,0,0,0,0,0,0,0,0,'3056-2;'),
(6357,'Stiletto - Rsk. Haste','rhand','true',1030,2,2,'fine_steel','c',107,5,'dagger',12,-3.00000,0,0,0,433,0,68,-1,2870000,1148,'true','true','true','true',0,0,0,0,0,0,0,0,0,'3056-2;'),
(6358,'Crystal Dagger - Critical Damage','rhand','true',1000,3,3,'crystal','c',136,5,'dagger',12,-3.00000,0,0,0,433,0,83,-1,6130000,2452,'true','true','true','true',0,0,0,0,0,0,0,0,0,'3043-1;'),
(6359,'Demon Dagger - Critical Damage','rhand','true',970,1,1,'blood_steel','b',170,5,'dagger',12,-3.00000,0,0,0,433,0,99,-1,13100000,1746,'true','true','true','true',0,0,0,0,0,0,0,0,0,'3043-2;'),
(6364,'Forgotten Blade','rhand','true',1300,1,1,'adamantaite','s',281,10,'sword',8,0.00000,0,0,0,379,0,132,-1,48800000,2440,'true','true','true','true',0,0,0,0,0,0,0,0,9364,'0-0;'),
(6365,'Basalt Battlehammer','rhand','true',1570,1,1,'adamantaite','s',281,20,'blunt',4,4.00000,0,0,0,379,0,132,-1,48800000,2440,'true','true','true','true',0,0,0,0,0,0,0,0,0,'0-0;'),
(6366,'Imperial Staff','lrhand','true',910,1,1,'adamantaite','s',274,20,'bigblunt',4,4.00000,0,0,0,325,0,175,-1,48800000,2440,'true','true','true','true',0,0,0,0,0,0,0,0,0,'0-0;'),
(6367,'Angel Slayer','rhand','true',950,1,1,'adamantaite','s',246,5,'dagger',12,-3.00000,0,0,0,433,0,132,-1,48800000,2440,'true','true','true','true',0,0,0,0,0,0,0,0,0,'0-0;'),
(6368,'Shining Bow','lrhand','true',1650,1,1,'adamantaite','s',581,5,'bow',12,-3.00000,0,0,0,293,11,132,-1,48800000,2440,'true','true','true','true',0,0,0,0,0,0,0,0,0,'0-0;'),
(6369,'Dragon Hunter Axe','lrhand','true',1820,1,1,'adamantaite','s',342,20,'bigblunt',4,4.00000,0,0,0,325,0,132,-1,48800000,2440,'true','true','true','true',0,0,0,0,0,0,0,0,0,'0-0;'),
(6370,'Saint Spear','lrhand','true',1800,1,1,'adamantaite','s',281,10,'pole',8,-3.00000,0,0,0,325,0,132,-1,48800000,2440,'true','true','true','true',0,0,0,0,0,0,0,0,0,'0-0;'),
(6371,'Demon Splinter','lrhand','true',1350,1,1,'adamantaite','s',342,5,'dualfist',4,4.00000,0,0,0,325,0,132,-1,48800000,2440,'true','true','true','true',0,0,0,0,0,0,0,0,0,'0-0;'),
(6372,'Heaven''s Divider','lrhand','true',1380,1,1,'adamantaite','s',342,10,'bigsword',8,0.00000,0,0,0,325,0,132,-1,48800000,2440,'true','true','true','true',0,0,0,0,0,0,0,0,9368,'0-0;'),
(6377,'Imperial Crusader Shield','lhand','true',1170,0,0,'bone','s',0,0,'none',0,0.00000,-8,290,20,0,0,0,-1,3760000,188,'true','true','true','true',0,0,0,0,0,0,0,0,0,'0-0;'),
(6529,'Baby Duck Rod','lrhand','false',1000,0,0,'bone','none',1,1,'rod',0,-3.00000,0,0,0,325,0,1,-1,30000,0,'true','true','true','true',0,0,0,0,0,0,0,0,0,'0-0;'),
(6530,'Albatross Rod','lrhand','false',1000,0,0,'bone','d',1,1,'rod',0,-3.00000,0,0,0,325,0,1,-1,100000,0,'true','true','true','true',0,0,0,0,0,0,0,0,0,'0-0;'),
(6531,'Pelican Rod','lrhand','false',1000,0,0,'bone','c',1,1,'rod',0,-3.00000,0,0,0,325,0,1,-1,400000,0,'true','true','true','true',0,0,0,0,0,0,0,0,0,'0-0;'),
(6532,'KingFisher Rod','lrhand','false',1000,0,0,'bone','b',1,1,'rod',0,-3.00000,0,0,0,325,0,1,-1,1200000,0,'true','true','true','true',0,0,0,0,0,0,0,0,0,'0-0;'),
(6533,'Cygnus Pole','lrhand','false',1000,0,0,'bone','a',1,1,'rod',0,-3.00000,0,0,0,325,0,1,-1,4000000,0,'true','true','true','true',0,0,0,0,0,0,0,0,0,'0-0;'),
(6534,'Triton Pole','lrhand','false',1000,0,0,'bone','s',1,1,'rod',0,-3.00000,0,0,0,325,0,1,-1,10000000,0,'true','true','true','true',0,0,0,0,0,0,0,0,0,'0-0;'),
(6579,'Arcana Mace','rhand','true',1300,1,1,'adamantaite','s',225,20,'blunt',4,4.00000,0,0,0,379,0,175,-1,48800000,2440,'true','true','true','true',0,0,0,0,0,0,0,0,0,'0-0;'),
(6580,'Tallum Blade*Dark Legion''s Edge','lrhand','true',2080,1,1,'adamantaite','s',342,10,'dual',8,0.00000,0,0,0,325,0,132,-1,48800000,2440,'true','true','true','true',0,0,0,0,0,0,0,0,0,'0-0;'),
(6581,'Forgotten Blade - Haste','rhand','true',1300,1,1,'adamantaite','s',281,10,'sword',8,0.00000,0,0,0,379,0,132,-1,48800000,2440,'true','true','true','true',0,0,0,0,0,0,0,0,9365,'3037-2;'),
(6582,'Forgotten Blade - Health','rhand','true',1300,1,1,'adamantaite','s',281,10,'sword',8,0.00000,0,0,0,379,0,132,-1,48800000,2440,'true','true','true','true',0,0,0,0,0,0,0,0,9366,'3013-4;'),
(6583,'Forgotten Blade - Focus','rhand','true',1300,1,1,'adamantaite','s',281,10,'sword',8,0.00000,0,0,0,379,0,132,-1,48800000,2440,'true','true','true','true',0,0,0,0,0,0,0,0,9367,'3566-1;'),
(6584,'Basalt Battlehammer - HP Drain','rhand','true',1570,1,1,'adamantaite','s',281,20,'blunt',4,4.00000,0,0,0,379,0,132,-1,48800000,2440,'true','true','true','true',0,0,0,0,0,3022,7,20,0,'0-0;'),
(6585,'Basalt Battlehammer - Health','rhand','true',1570,1,1,'adamantaite','s',281,20,'blunt',4,4.00000,0,0,0,379,0,132,-1,48800000,2440,'true','true','true','true',0,0,0,0,0,0,0,0,0,'3013-1;'),
(6586,'Basalt Battlehammer - HP Regeneration','rhand','true',1570,1,1,'adamantaite','s',281,20,'blunt',4,4.00000,0,0,0,379,0,132,-1,48800000,2440,'true','true','true','true',0,0,0,0,0,0,0,0,0,'3569-1;'),
(6587,'Imperial Staff - Empower','lrhand','true',910,1,1,'adamantaite','s',274,20,'bigblunt',4,4.00000,0,0,0,325,0,175,-1,48800000,2440,'true','true','true','true',0,0,0,0,0,0,0,0,0,'3076-1;'),
(6588,'Imperial Staff - MP Regeneration','lrhand','true',910,1,1,'adamantaite','s',274,20,'bigblunt',4,4.00000,0,0,0,325,0,175,-1,48800000,2440,'true','true','true','true',0,0,0,0,0,0,0,0,0,'3576-1;'),
(6589,'Imperial Staff - Magic Hold','lrhand','true',910,1,1,'adamantaite','s',274,20,'bigblunt',4,4.00000,0,0,0,325,0,175,-1,48800000,2440,'true','true','true','true',0,0,3577,1,30,0,0,0,0,'0-0;'),
(6590,'Angel Slayer - Crt. Damage','rhand','true',950,1,1,'adamantaite','s',246,5,'dagger',12,-3.00000,0,0,0,433,0,132,-1,48800000,2440,'true','true','true','true',0,0,0,0,0,0,0,0,0,'3572-1;'),
(6591,'Angel Slayer - HP Drain','rhand','true',950,1,1,'adamantaite','s',246,5,'dagger',12,-3.00000,0,0,0,433,0,132,-1,48800000,2440,'true','true','true','true',0,0,0,0,0,3022,7,20,0,'0-0;'),
(6592,'Angel Slayer - Haste','rhand','true',950,1,1,'adamantaite','s',246,5,'dagger',12,-3.00000,0,0,0,433,0,132,-1,48800000,2440,'true','true','true','true',0,0,0,0,0,0,0,0,0,'3037-4;'),
(6593,'Shining Bow - Cheap Shot','lrhand','true',1650,1,1,'adamantaite','s',581,5,'bow',12,-3.00000,0,0,0,293,11,132,-1,48800000,2440,'true','true','true','true',0,0,0,0,0,0,0,0,0,'0-0;'),
(6594,'Shining Bow - Focus','lrhand','true',1650,1,1,'adamantaite','s',581,5,'bow',12,-3.00000,0,0,0,293,11,132,-1,48800000,2440,'true','true','true','true',0,0,0,0,0,0,0,0,0,'3567-2;'),
(6595,'Shining Bow - Crt. Slow','lrhand','true',1650,1,1,'adamantaite','s',581,5,'bow',12,-3.00000,0,0,0,293,11,132,-1,48800000,2440,'true','true','true','true',0,0,0,0,0,3574,1,10,0,'0-0;'),
(6596,'Dragon Hunter Axe - HP Regeneration','lrhand','true',1820,1,1,'adamantaite','s',342,20,'bigblunt',4,4.00000,0,0,0,325,0,132,-1,48800000,2440,'true','true','true','true',0,0,0,0,0,0,0,0,0,'3569-1;'),
(6597,'Dragon Hunter Axe - Health','lrhand','true',1820,1,1,'adamantaite','s',342,20,'bigblunt',4,4.00000,0,0,0,325,0,132,-1,48800000,2440,'true','true','true','true',0,0,0,0,0,0,0,0,0,'3013-1;'),
(6598,'Dragon Hunter Axe - HP Drain','lrhand','true',1820,1,1,'adamantaite','s',342,20,'bigblunt',4,4.00000,0,0,0,325,0,132,-1,48800000,2440,'true','true','true','true',0,0,0,0,0,3022,7,20,0,'0-0;'),
(6599,'Saint Spear - Health','lrhand','true',1800,1,1,'adamantaite','s',281,10,'pole',8,-3.00000,0,0,0,325,0,132,-1,48800000,2440,'true','true','true','true',0,0,0,0,0,0,0,0,0,'3013-4;'),
(6600,'Saint Spear - Guidance','lrhand','true',1800,1,1,'adamantaite','s',281,10,'pole',8,-3.00000,0,0,0,325,0,132,-1,48800000,2440,'true','true','true','true',0,0,0,0,0,0,0,0,0,'3602-5;'),
(6601,'Saint Spear - Haste','lrhand','true',1800,1,1,'adamantaite','s',281,10,'pole',8,-3.00000,0,0,0,325,0,132,-1,48800000,2440,'true','true','true','true',0,0,0,0,0,0,0,0,0,'3068-2;'),
(6602,'Demon Splinter - Focus','lrhand','true',1350,1,1,'adamantaite','s',342,5,'dualfist',4,4.00000,0,0,0,325,0,132,-1,48800000,2440,'true','true','true','true',0,0,0,0,0,0,0,0,0,'3565-1;'),
(6603,'Demon Splinter - Health','lrhand','true',1350,1,1,'adamantaite','s',342,5,'dualfist',4,4.00000,0,0,0,325,0,132,-1,48800000,2440,'true','true','true','true',0,0,0,0,0,0,0,0,0,'3013-4;'),
(6604,'Demon Splinter - Crt. Stun','lrhand','true',1350,1,1,'adamantaite','s',342,5,'dualfist',4,4.00000,0,0,0,325,0,132,-1,48800000,2440,'true','true','true','true',0,0,0,0,0,3070,1,16,0,'0-0;'),
(6605,'Heavens Divider - Haste','lrhand','true',1380,1,1,'adamantaite','s',342,10,'bigsword',8,0.00000,0,0,0,325,0,132,-1,48800000,2440,'true','true','true','true',0,0,0,0,0,0,0,0,9369,'3601-9;'),
(6606,'Heavens Divider - Health','lrhand','true',1380,1,1,'adamantaite','s',342,10,'bigsword',8,0.00000,0,0,0,325,0,132,-1,48800000,2440,'true','true','true','true',0,0,0,0,0,0,0,0,9370,'3013-4;'),
(6607,'Heavens Divider - Focus','lrhand','true',1380,1,1,'adamantaite','s',342,10,'bigsword',8,0.00000,0,0,0,325,0,132,-1,48800000,2440,'true','true','true','true',0,0,0,0,0,0,0,0,9371,'3566-1;'),
(6608,'Arcana Mace - Acumen','rhand','true',1300,1,1,'adamantaite','s',225,20,'blunt',4,4.00000,0,0,0,379,0,175,-1,48800000,2440,'true','true','true','true',0,0,0,0,0,0,0,0,0,'3047-2;'),
(6609,'Arcana Mace - MP Regeneration','rhand','true',1300,1,1,'adamantaite','s',225,20,'blunt',4,4.00000,0,0,0,379,0,175,-1,48800000,2440,'true','true','true','true',0,0,0,0,0,0,0,0,0,'3576-1;'),
(6610,'Arcana Mace - Mana Up','rhand','true',1300,1,1,'adamantaite','s',225,20,'blunt',4,4.00000,0,0,0,379,0,175,-1,48800000,2440,'true','true','true','true',0,0,0,0,0,0,0,0,0,'3014-2;'),
(6611,'Infinity Blade','rhand','false',1300,1,1,'adamantaite','s',379,10,'sword',8,0.00000,0,0,0,379,0,169,-1,57000000,2850,'false','false','false','false',0,0,0,0,0,3579,1,4,0,'3578-1;'),
(6612,'Infinity Cleaver','lrhand','false',1300,1,1,'adamantaite','s',461,10,'bigsword',8,0.00000,0,0,0,325,0,169,-1,57000000,2850,'false','false','false','false',0,0,0,0,0,0,0,0,0,'3582-1;'),
(6613,'Infinity Axe','rhand','false',1300,1,1,'adamantaite','s',379,20,'blunt',4,4.00000,0,0,0,379,0,169,-1,57000000,2850,'false','false','false','false',0,0,0,0,0,3581,1,4,0,'3580-1;'),
(6614,'Infinity Rod','rhand','false',1300,1,1,'adamantaite','s',303,20,'blunt',4,4.00000,0,0,0,379,0,226,-1,57000000,2850,'false','false','false','false',0,0,3598,1,15,0,0,0,0,'3597-1;'),
(6615,'Infinity Crusher','lrhand','false',1300,1,1,'adamantaite','s',461,20,'bigblunt',4,4.00000,0,0,0,325,0,169,-1,57000000,2850,'false','false','false','false',0,0,0,0,0,3584,1,5,0,'3583-1;'),
(6616,'Infinity Scepter','lrhand','false',1300,1,1,'adamantaite','s',369,20,'bigblunt',4,4.00000,0,0,0,325,0,226,-1,57000000,2850,'false','false','false','false',0,0,3596,1,15,0,0,0,0,'3595-1;'),
(6617,'Infinity Stinger','rhand','false',1300,1,1,'adamantaite','s',332,5,'dagger',12,-3.00000,0,0,0,433,0,169,-1,57000000,2850,'false','false','false','false',0,0,0,0,0,3590,1,5,0,'3589-1;'),
(6618,'Infinity Fang','lrhand','false',1300,1,1,'adamantaite','s',461,5,'dualfist',4,4.00000,0,0,0,325,0,169,-1,57000000,2850,'false','false','false','false',0,0,0,0,0,3588,1,25,0,'3587-1;'),
(6619,'Infinity Bow','lrhand','false',1300,1,1,'adamantaite','s',707,5,'bow',12,-3.00000,0,0,0,293,11,169,-1,57000000,2850,'false','false','false','false',0,0,0,0,0,3594,1,7,0,'3593-1;'),
(6620,'Infinity Wing','lrhand','false',1300,1,1,'adamantaite','s',461,10,'dual',8,0.00000,0,0,0,325,0,169,-1,57000000,2850,'false','false','false','false',0,0,0,0,0,3586,1,7,0,'3585-1;'),
(6621,'Infinity Spear','lrhand','false',1300,1,1,'adamantaite','s',379,10,'pole',8,-3.00000,0,0,0,325,0,169,-1,57000000,2850,'false','false','false','false',0,0,0,0,0,3592,1,5,0,'3591-1;'),
(6678,'Sealed Imperial Crusader Shield','lhand','true',1170,0,0,'bone','s',0,0,'none',0,0.00000,-8,276,20,0,0,0,-1,3760000,188,'true','true','true','true',0,0,0,0,0,0,0,0,0,'0-0;'),
(6715,'Monster Only(Silenos Archer)','lrhand','false',1950,1,1,'wood','none',16,5,'bow',12,-3.00000,0,0,0,293,1,6,-1,768,0,'true','true','true','true',0,0,0,0,0,0,0,0,0,'0-0;'),
(6716,'Monster Only(Silenos Shaman)','lrhand','false',1080,1,1,'wood','none',11,20,'bigblunt',4,4.00000,0,0,0,325,0,12,-1,12500,0,'true','true','true','true',0,0,0,0,0,0,0,0,0,'0-0;'),
(6717,'Monster Only(Einhasad Warrior)','rhand','false',1560,2,2,'fine_steel','none',24,10,'sword',8,0.00000,0,0,0,379,0,17,-1,136000,0,'true','true','true','true',0,0,0,0,0,0,0,0,0,'0-0;'),
(6718,'Monster Only(Einhasad Shaman)','lrhand','false',1560,2,2,'adamantaite','none',24,20,'bigblunt',4,4.00000,0,0,0,325,0,17,-1,136000,0,'true','true','true','true',0,0,0,0,0,0,0,0,0,'0-0;'),
(6719,'Monster Only(Ketra Orc Chieftain)','lrhand','false',990,3,3,'blood_steel','c',141,20,'bigblunt',4,4.00000,0,0,0,325,0,104,-1,4780000,1912,'true','true','true','true',0,0,0,0,0,0,0,0,0,'0-0;'),
(6720,'Monster Only(Shadow of Halisha)','lrhand','false',1950,1,1,'wood','none',16,5,'bow',12,-3.00000,0,0,0,293,1,6,-1,768,0,'true','true','true','true',0,0,0,0,0,0,0,0,0,'0-0;'),
(6721,'Monster Only(Shield of Imperial Warlord Zombie)','lhand','false',1430,0,0,'leather','none',0,0,'none',0,0.00000,-8,47,20,0,0,0,-1,39,0,'true','true','true','true',0,0,0,0,0,0,0,0,0,'0-0;'),
(6722,'Monster Only(Ahrimanes)','lrhand','false',2080,1,1,'fine_steel','b',236,10,'dual',8,0.00000,0,0,0,325,0,99,-1,13100000,1746,'true','true','true','true',0,0,0,0,0,0,0,0,0,'0-0;'),
(6723,'Monster Only(Vampire Warrior)','lrhand','false',2090,3,3,'fine_steel','d',112,10,'bigsword',8,0.00000,0,0,0,325,0,54,-1,1800000,3272,'true','true','true','true',0,0,0,0,0,0,0,0,0,'0-0;'),
(6902,'Pledge Shield','lhand','true',1380,0,0,'bone','none',0,0,'none',0,0.00000,-8,90,20,0,0,0,-1,12900,0,'true','true','true','true',0,0,0,0,0,0,0,0,0,'0-0;'),
(6917,'Monster Only (Poison Sting)','rhand','false',6,0,0,'wood','none',0,0,'fist',0,0.00000,0,0,0,0,0,0,-1,2,0,'true','true','true','true',0,0,0,0,0,0,0,0,0,'0-0;'),
(6918,'Monster Only (Shield of Silenos)','lhand','false',1380,0,0,'bone','none',0,0,'none',0,0.00000,-8,90,20,0,0,0,-1,12900,0,'true','true','true','true',0,0,0,0,0,0,0,0,0,'0-0;'),
(6919,'Monster Only (Shield of Ketra Orc)','lhand','false',1320,0,0,'fine_steel','none',0,0,'none',0,0.00000,-8,142,20,0,0,0,-1,78400,142,'true','true','true','true',0,0,0,0,0,0,0,0,0,'0-0;'),
(7014,'Monster Only (Shield of Dark Dragon)','lhand','false',4800,0,0,'damascus','none',0,0,'none',0,0.00000,-8,230,20,0,0,0,-1,845000,0,'true','true','true','true',0,0,0,0,0,0,0,0,0,'0-0;'),
(7015,'Shield of Castle Pledge','lhand','true',1380,0,0,'bone','none',0,0,'none',0,0.00000,-8,90,20,0,0,0,-1,12900,0,'true','true','true','true',0,0,0,0,0,0,0,0,0,'0-0;'),
(7058,'Chrono Darbuka','lrhand','false',0,0,0,'steel','none',1,20,'bigblunt',4,4.00000,0,0,0,325,0,1,-1,0,0,'true','false','true','true',0,0,0,0,0,0,0,0,0,'0-0;'),
(7560,'Monster Only (Fishing Rod)','lrhand','false',1000,0,0,'bone','none',1,1,'rod',0,-3.00000,0,0,0,325,0,1,-1,30000,0,'false','false','true','false',0,0,0,0,0,0,0,0,0,'0-0;'),
(7575,'Draconic Bow','lrhand','true',1650,1,1,'adamantaite','s',581,5,'bow',12,-3.00000,0,0,0,293,11,132,-1,48800000,2440,'true','true','true','true',0,0,0,0,0,0,0,0,9372,'0-0;'),
(7576,'Draconic Bow - Cheap Shot','lrhand','true',1650,1,1,'adamantaite','s',581,5,'bow',12,-3.00000,0,0,0,293,11,132,-1,48800000,2440,'true','true','true','true',0,0,0,0,0,0,0,0,9373,'0-0;'),
(7577,'Draconic Bow - Focus','lrhand','true',1650,1,1,'adamantaite','s',581,5,'bow',12,-3.00000,0,0,0,293,11,132,-1,48800000,2440,'true','true','true','true',0,0,0,0,0,0,0,0,9374,'3044-17;'),
(7578,'Draconic Bow - Critical Slow','lrhand','true',1650,1,1,'adamantaite','s',581,5,'bow',12,-3.00000,0,0,0,293,11,132,-1,48800000,2440,'true','true','true','true',0,0,0,0,0,3574,1,10,9375,'0-0;'),
(7701,'Stick of Faith - Mana Up','rhand','true',1160,2,2,'wood','c',85,20,'blunt',4,4.00000,0,0,0,379,0,81,-1,2290000,916,'true','true','true','true',0,0,0,0,0,0,0,0,0,'3014-1;'),
(7702,'Stick of Faith - Magic Hold','rhand','true',1160,2,2,'wood','c',85,20,'blunt',4,4.00000,0,0,0,379,0,81,-1,2290000,916,'true','true','true','true',0,0,0,0,0,0,0,0,0,'0-0;'),
(7703,'Stick of Faith - Magic Shield','rhand','true',1160,2,2,'wood','c',85,20,'blunt',4,4.00000,0,0,0,379,0,81,-1,2290000,916,'true','true','true','true',0,0,0,0,0,0,0,0,0,'0-0;'),
(7704,'Stick of Eternity - Empower','rhand','true',1130,3,3,'wood','c',111,20,'blunt',4,4.00000,0,0,0,379,0,101,-1,4300000,1720,'true','true','true','true',0,0,0,0,0,0,0,0,0,'0-0;'),
(7705,'Stick of Eternity - Rsk.,Evasion','rhand','true',1130,3,3,'wood','c',111,20,'blunt',4,4.00000,0,0,0,379,0,101,-1,4300000,1720,'true','true','true','true',0,0,0,0,0,0,0,0,0,'0-0;'),
(7706,'Stick of Eternity - Blessed Body','rhand','true',1130,3,3,'wood','c',111,20,'blunt',4,4.00000,0,0,0,379,0,101,-1,4300000,1720,'true','true','true','true',0,0,0,0,0,0,0,0,0,'0-0;'),
(7707,'Nirvana Axe - Magic Power','rhand','true',1150,3,3,'fine_steel','c',111,20,'blunt',4,4.00000,0,0,0,379,0,101,-1,4300000,1720,'true','true','true','true',0,0,0,0,0,0,0,0,0,'0-0;'),
(7708,'Nirvana Axe - Magic Poison','rhand','true',1150,3,3,'fine_steel','c',111,20,'blunt',4,4.00000,0,0,0,379,0,101,-1,4300000,1720,'true','true','true','true',0,0,1168,6,7,0,0,0,0,'0-0;'),
(7709,'Nirvana Axe - Magic Weakness','rhand','true',1150,3,3,'fine_steel','c',111,20,'blunt',4,4.00000,0,0,0,379,0,101,-1,4300000,1720,'true','true','true','true',0,0,1164,6,7,0,0,0,0,'0-0;'),
(7710,'Club of Nature - Acumen','rhand','true',1100,3,3,'wood','c',111,20,'blunt',4,4.00000,0,0,0,379,0,101,-1,4300000,1720,'true','true','true','true',0,0,0,0,0,0,0,0,0,'3047-1;'),
(7711,'Club of Nature - Magic Mental Shield','rhand','true',1100,3,3,'wood','c',111,20,'blunt',4,4.00000,0,0,0,379,0,101,-1,4300000,1720,'true','true','true','true',0,0,0,0,0,0,0,0,0,'0-0;'),
(7712,'Club of Nature - Magic Hold','rhand','true',1100,3,3,'wood','c',111,20,'blunt',4,4.00000,0,0,0,379,0,101,-1,4300000,1720,'true','true','true','true',0,0,0,0,0,0,0,0,0,'0-0;'),
(7713,'Mace of The Underworld - Mana Up','rhand','true',1090,3,3,'fine_steel','c',111,20,'blunt',4,4.00000,0,0,0,379,0,101,-1,4300000,1720,'true','true','true','true',0,0,0,0,0,0,0,0,0,'3014-1;'),
(7714,'Mace of The Underworld - Magic Silence','rhand','true',1090,3,3,'fine_steel','c',111,20,'blunt',4,4.00000,0,0,0,379,0,101,-1,4300000,1720,'true','true','true','true',0,0,0,0,0,0,0,0,0,'0-0;'),
(7715,'Mace of The Underworld - Conversion','rhand','true',1090,3,3,'fine_steel','c',111,20,'blunt',4,4.00000,0,0,0,379,0,101,-1,4300000,1720,'true','true','true','true',0,0,0,0,0,0,0,0,0,'3048-1;'),
(7716,'Inferno Staff - Acumen','lrhand','true',1000,3,3,'wood','c',135,20,'bigblunt',4,4.00000,0,0,0,325,0,101,-1,4300000,1720,'true','true','true','true',0,0,0,0,0,0,0,0,0,'3047-1;'),
(7717,'Inferno Staff - Magic Silence','lrhand','true',1000,3,3,'wood','c',135,20,'bigblunt',4,4.00000,0,0,0,325,0,101,-1,4300000,1720,'true','true','true','true',0,0,0,0,0,0,0,0,0,'0-0;'),
(7718,'Inferno Staff - Magic Paralyze','lrhand','true',1000,3,3,'wood','c',135,20,'bigblunt',4,4.00000,0,0,0,325,0,101,-1,4300000,1720,'true','true','true','true',0,0,0,0,0,0,0,0,0,'0-0;'),
(7719,'Poleaxe - Critical Stun','lrhand','true',2010,3,3,'bronze','c',139,10,'pole',8,-3.00000,0,0,0,325,0,76,-1,4300000,1720,'true','true','true','true',0,0,0,0,0,0,0,0,0,'0-0;'),
(7720,'Poleaxe - Towering Blow','lrhand','true',2010,3,3,'bronze','c',139,10,'pole',8,-3.00000,0,0,0,325,0,76,-1,4300000,1720,'true','true','true','true',0,0,0,0,0,0,0,0,0,'0-0;'),
(7721,'Poleaxe - Wide Blow','lrhand','true',2010,3,3,'bronze','c',139,10,'pole',8,-3.00000,0,0,0,325,0,76,-1,4300000,1720,'true','true','true','true',0,0,0,0,0,0,0,0,0,'0-0;'),
(7722,'Sword of Valhalla - Acumen','rhand','true',900,1,1,'oriharukon','b',140,10,'sword',8,0.00000,0,0,0,379,0,122,-1,8680000,1157,'true','true','true','true',0,0,0,0,0,0,0,0,0,'3047-1;'),
(7723,'Sword of Valhalla - Magic Weakness','rhand','true',900,1,1,'oriharukon','b',140,10,'sword',8,0.00000,0,0,0,379,0,122,-1,8680000,1157,'true','true','true','true',0,0,1164,6,7,0,0,0,0,'0-0;'),
(7724,'Sword of Valhalla - Magic Regeneration','rhand','true',900,1,1,'oriharukon','b',140,10,'sword',8,0.00000,0,0,0,379,0,122,-1,8680000,1157,'true','true','true','true',0,0,1044,3,30,0,0,0,0,'0-0;'),
(7810,'Soulfire Dirk - Mana Up','rhand','true',750,2,2,'fine_steel','c',86,5,'dagger',12,-3.00000,0,0,0,433,0,91,-1,2870000,1148,'true','true','true','true',0,0,0,0,0,0,0,0,0,'3014-1;'),
(7811,'Soulfire Dirk - Magic Hold','rhand','true',750,2,2,'fine_steel','c',86,5,'dagger',12,-3.00000,0,0,0,433,0,91,-1,2870000,1148,'true','true','true','true',0,0,0,0,0,0,0,0,0,'0-0;'),
(7812,'Soulfire Dirk - Magic Silence','rhand','true',750,2,2,'fine_steel','c',86,5,'dagger',12,-3.00000,0,0,0,433,0,91,-1,2870000,1148,'true','true','true','true',0,0,0,0,0,0,0,0,0,'0-0;'),
(7813,'Hell Knife - Magic Regeneration','rhand','true',740,1,1,'blood_steel','b',122,5,'dagger',12,-3.00000,0,0,0,433,0,122,-1,8680000,1157,'true','true','true','true',0,0,0,0,0,0,0,0,0,'0-0;'),
(7814,'Hell Knife - Mental Shield','rhand','true',740,1,1,'blood_steel','b',122,5,'dagger',12,-3.00000,0,0,0,433,0,122,-1,8680000,1157,'true','true','true','true',0,0,0,0,0,0,0,0,0,'0-0;'),
(7815,'Hell Knife - Magic Weakness','rhand','true',740,1,1,'blood_steel','b',122,5,'dagger',12,-3.00000,0,0,0,433,0,122,-1,8680000,1157,'true','true','true','true',0,0,1164,3,7,0,0,0,0,'0-0;'),
(7816,'Apprentice Adventurer''s Staff','lrhand','false',1070,2,2,'wood','none',23,20,'bigblunt',4,4.00000,0,0,0,325,0,22,-1,0,0,'false','false','true','false',0,0,0,0,0,0,0,0,0,'0-0;'),
(7817,'Apprentice Adventurer''s Bone Club','rhand','false',1850,2,2,'fine_steel','none',24,20,'blunt',4,4.00000,0,0,0,379,0,17,-1,0,0,'false','false','true','false',0,0,0,0,0,0,0,0,0,'0-0;'),
(7818,'Apprentice Adventurer''s Knife','rhand','false',1120,2,2,'mithril','none',21,5,'dagger',12,-3.00000,0,0,0,433,0,17,-1,0,0,'false','false','true','false',0,0,0,0,0,0,0,0,0,'0-0;'),
(7819,'Apprentice Adventurer''s Cestus','lrhand','false',1570,2,2,'steel','none',29,5,'dualfist',4,4.00000,0,0,0,325,0,17,-1,0,0,'false','false','true','false',0,0,0,0,0,0,0,0,0,'0-0;'),
(7820,'Apprentice Adventurer''s Bow','lrhand','false',1900,7,2,'wood','none',49,5,'bow',12,-3.00000,0,0,0,293,3,17,-1,0,0,'false','false','true','false',0,0,0,0,0,0,0,0,0,'0-0;'),
(7821,'Apprentice Adventurer''s Long Sword','rhand','false',1560,2,2,'fine_steel','none',24,10,'sword',8,0.00000,0,0,0,379,0,17,-1,0,0,'false','false','true','false',0,0,0,0,0,0,0,0,0,'0-0;'),
(7822,'Traveler''s Mace','rhand','false',1300,2,2,'steel','d',41,20,'blunt',4,4.00000,0,0,0,379,0,43,-1,0,0,'false','false','true','false',0,0,0,0,0,0,0,0,0,'0-0;'),
(7823,'Traveler''s Dark Elven Bow','lrhand','false',1830,6,2,'steel','d',105,5,'bow',12,-3.00000,0,0,0,293,4,32,-1,0,0,'false','false','true','false',0,0,0,0,0,0,0,0,0,'0-0;'),
(7824,'Traveler''s Long Bow','lrhand','false',1830,6,2,'steel','d',105,5,'bow',12,-3.00000,0,0,0,293,4,32,-1,0,0,'false','false','true','false',0,0,0,0,0,0,0,0,0,'0-0;'),
(7825,'Traveler''s Staff','lrhand','false',1040,2,2,'wood','d',50,20,'bigblunt',4,4.00000,0,0,0,325,0,43,-1,0,0,'false','false','true','false',0,0,0,0,0,0,0,0,0,'0-0;'),
(7826,'Traveler''s Bastard Sword','rhand','false',1510,2,2,'fine_steel','d',51,10,'sword',8,0.00000,0,0,0,379,0,32,-1,0,0,'false','false','true','false',0,0,0,0,0,0,0,0,0,'0-0;'),
(7827,'Traveler''s Wand','rhand','false',570,2,2,'steel','d',41,10,'etc',8,0.00000,0,0,0,379,0,43,-1,0,0,'false','false','true','false',0,0,0,0,0,0,0,0,0,'0-0;'),
(7828,'Traveler''s Jamadhr','lrhand','false',1550,2,2,'steel','d',62,5,'dualfist',4,4.00000,0,0,0,325,0,32,-1,0,0,'false','false','true','false',0,0,0,0,0,0,0,0,0,'0-0;'),
(7829,'Traveler''s Tomahawk','rhand','false',1780,2,2,'bronze','d',51,20,'blunt',4,4.00000,0,0,0,379,0,32,-1,0,0,'false','false','true','false',0,0,0,0,0,0,0,0,0,'0-0;'),
(7830,'Traveler''s Poniard Dagger','rhand','false',1090,2,2,'steel','d',45,5,'dagger',12,-3.00000,0,0,0,433,0,32,-1,0,0,'false','false','true','false',0,0,0,0,0,0,0,0,0,'0-0;'),
(7831,'Traveler''s Pike','lrhand','false',2090,2,2,'steel','d',51,10,'pole',8,-3.00000,0,0,0,325,0,32,-1,0,0,'false','false','true','false',0,0,0,0,0,0,0,0,0,'0-0;'),
(7834,'Art of Battle Axe','rhand','true',1570,1,1,'chrysolite','b',194,20,'blunt',4,4.00000,0,0,0,379,0,99,-1,13100000,1746,'true','true','true','true',0,0,0,0,0,0,0,0,0,'0-0;'),
(7880,'Steel Sword','lrhand','true',2100,2,2,'fine_steel','d',49,10,'bigsword',8,0.00000,0,0,0,325,0,26,-1,409000,743,'true','true','true','true',0,0,0,0,0,0,0,0,9211,'0-0;'),
(7881,'Titan Sword','lrhand','true',2020,3,3,'fine_steel','d',96,10,'bigsword',8,0.00000,0,0,0,325,0,47,-1,1400000,2545,'true','true','true','true',0,0,0,0,0,0,0,0,9223,'0-0;'),
(7882,'Pa''agrian Sword','lrhand','true',1980,3,3,'steel','c',169,10,'bigsword',8,0.00000,0,0,0,325,0,76,-1,4300000,1720,'true','true','true','true',0,0,0,0,0,0,0,0,9284,'0-0;'),
(7883,'Guardian Sword','lrhand','true',1930,1,1,'steel','b',236,10,'bigsword',8,0.00000,0,0,0,325,0,99,-1,13100000,1746,'true','true','true','true',0,0,0,0,0,0,0,0,9320,'0-0;'),
(7884,'Infernal Master','lrhand','true',1900,1,1,'fine_steel','a',259,10,'bigsword',8,0.00000,0,0,0,325,0,107,-1,18300000,1464,'true','true','true','true',0,0,0,0,0,0,0,0,9332,'0-0;'),
(7885,'Priest Sword','rhand','true',1520,2,2,'fine_steel','d',32,10,'sword',8,0.00000,0,0,0,379,0,35,-1,409000,743,'true','true','true','true',0,0,0,0,0,0,0,0,0,'0-0;'),
(7886,'Sword of Magic Fog','rhand','true',1450,3,3,'fine_steel','d',63,10,'sword',8,0.00000,0,0,0,379,0,63,-1,1400000,2545,'true','true','true','true',0,0,0,0,0,0,0,0,0,'0-0;'),
(7887,'Mysterious Sword','rhand','true',1430,2,2,'fine_steel','c',85,10,'sword',8,0.00000,0,0,0,379,0,81,-1,2290000,916,'true','true','true','true',0,0,0,0,0,0,0,0,0,'0-0;'),
(7888,'Ecliptic Sword','rhand','true',1380,3,3,'oriharukon','c',125,10,'sword',8,0.00000,0,0,0,379,0,111,-1,6130000,2452,'true','true','true','true',0,0,0,0,0,0,0,0,0,'0-0;'),
(7889,'Wizard''s Tear','rhand','true',1350,1,1,'oriharukon','b',155,10,'sword',8,0.00000,0,0,0,379,0,132,-1,13100000,1746,'true','true','true','true',0,0,0,0,0,0,0,0,0,'0-0;'),
(7890,'Priest Mace','rhand','true',1720,3,3,'steel','d',63,20,'blunt',4,4.00000,0,0,0,379,0,63,-1,1400000,2545,'true','true','true','true',0,0,0,0,0,0,0,0,0,'0-0;'),
(7891,'Ecliptic Axe','rhand','true',1640,3,3,'fine_steel','c',125,20,'blunt',4,4.00000,0,0,0,379,0,111,-1,6130000,2452,'true','true','true','true',0,0,0,0,0,0,0,0,0,'0-0;'),
(7892,'Spell Breaker','rhand','true',1620,1,1,'fine_steel','b',140,20,'blunt',4,4.00000,0,0,0,379,0,122,-1,8680000,1157,'true','true','true','true',0,0,0,0,0,0,0,0,0,'0-0;'),
(7893,'Kaim Vanul''s Bones','rhand','true',1570,1,1,'bone','b',155,20,'blunt',4,4.00000,0,0,0,379,0,132,-1,13100000,1746,'true','true','true','true',0,0,0,0,0,0,0,0,0,'0-0;'),
(7894,'Spiritual Eye','rhand','true',1550,1,1,'bone','a',170,20,'blunt',4,4.00000,0,0,0,379,0,143,-1,18300000,1464,'true','true','true','true',0,0,0,0,0,0,0,0,0,'0-0;'),
(7895,'Flaming Dragon Skull','rhand','true',1530,1,1,'fine_steel','a',186,20,'blunt',4,4.00000,0,0,0,379,0,152,-1,27000000,2160,'true','true','true','true',0,0,0,0,0,0,0,0,0,'0-0;'),
(7896,'Titan Hammer','lrhand','true',2100,3,3,'steel','d',96,20,'bigblunt',4,4.00000,0,0,0,325,0,47,-1,1400000,2545,'true','true','true','true',0,0,0,0,0,0,0,0,0,'0-0;'),
(7897,'Dwarven Hammer','lrhand','true',2010,3,3,'steel','c',190,20,'bigblunt',4,4.00000,0,0,0,325,0,83,-1,6130000,2452,'true','true','true','true',0,0,0,0,0,0,0,0,0,'0-0;'),
(7898,'Karik Horn','lrhand','true',2020,3,3,'oriharukon','c',169,20,'bigblunt',4,4.00000,0,0,0,325,0,76,-1,4300000,1720,'true','true','true','true',0,0,0,0,0,0,0,0,0,'0-0;'),
(7899,'Destroyer Hammer','lrhand','true',1910,1,1,'fine_steel','a',259,20,'bigblunt',4,4.00000,0,0,0,325,0,107,-1,18300000,1464,'true','true','true','true',0,0,0,0,0,0,0,0,0,'0-0;'),
(7900,'Ice Storm Hammer','lrhand','true',1950,1,1,'fine_steel','b',213,20,'bigblunt',4,4.00000,0,0,0,325,0,91,-1,8680000,1157,'true','true','true','true',0,0,0,0,0,0,0,0,0,'0-0;'),
(7901,'Star Buster','lrhand','true',1930,1,1,'fine_steel','b',236,20,'bigblunt',4,4.00000,0,0,0,325,0,99,-1,13100000,1746,'true','true','true','true',0,0,0,0,0,0,0,0,0,'0-0;'),
(7902,'Doom Crusher','lrhand','true',1900,1,1,'fine_steel','a',282,20,'bigblunt',4,4.00000,0,0,0,325,0,114,-1,27000000,2160,'true','true','true','true',0,0,0,0,0,0,0,0,0,'0-0;'),
(7903,'Frintezza''s Sword','lrhand','true',2180,2,2,'fine_steel','none',78,10,'bigsword',8,0.00000,0,0,0,325,0,39,-1,0,0,'true','true','true','true',0,0,0,0,0,0,0,0,0,'0-0;'),
(8102,'Pa''agrian Sword - Focus','lrhand','true',1980,3,3,'steel','c',169,10,'bigsword',8,0.00000,0,0,0,325,0,76,-1,4300000,1720,'true','true','true','true',0,0,0,0,0,0,0,0,9285,'3010-3;'),
(8103,'Pa''agrian Sword - Health','lrhand','true',1980,3,3,'steel','c',169,10,'bigsword',8,0.00000,0,0,0,325,0,76,-1,4300000,1720,'true','true','true','true',0,0,0,0,0,0,0,0,9286,'0-0;'),
(8104,'Pa''agrian Sword - Critical Drain','lrhand','true',1980,3,3,'steel','c',169,10,'bigsword',8,0.00000,0,0,0,325,0,76,-1,4300000,1720,'true','true','true','true',0,0,0,0,0,0,0,0,9287,'0-0;'),
(8105,'Guardian Sword - Critical Drain','lrhand','true',1930,1,1,'steel','b',236,10,'bigsword',8,0.00000,0,0,0,325,0,99,-1,13100000,1746,'true','true','true','true',0,0,0,0,0,0,0,0,9321,'0-0;'),
(8106,'Guardian Sword - Health','lrhand','true',1930,1,1,'steel','b',236,10,'bigsword',8,0.00000,0,0,0,325,0,99,-1,13100000,1746,'true','true','true','true',0,0,0,0,0,0,0,0,9322,'0-0;'),
(8107,'Guardian Sword - Critical Bleed','lrhand','true',1930,1,1,'steel','b',236,10,'bigsword',8,0.00000,0,0,0,325,0,99,-1,13100000,1746,'true','true','true','true',0,0,0,0,0,0,0,0,9323,'0-0;'),
(8108,'Infernal Master - Haste','lrhand','true',1900,1,1,'fine_steel','a',259,10,'bigsword',8,0.00000,0,0,0,325,0,107,-1,18300000,1464,'true','true','true','true',0,0,0,0,0,0,0,0,9333,'0-0;'),
(8109,'Infernal Master - Critical Damage','lrhand','true',1900,1,1,'fine_steel','a',259,10,'bigsword',8,0.00000,0,0,0,325,0,107,-1,18300000,1464,'true','true','true','true',0,0,0,0,0,0,0,0,9334,'0-0;'),
(8110,'Infernal Master - Focus','lrhand','true',1900,1,1,'fine_steel','a',259,10,'bigsword',8,0.00000,0,0,0,325,0,107,-1,18300000,1464,'true','true','true','true',0,0,0,0,0,0,0,0,9335,'3050-2;'),
(8111,'Mysterious Sword - Acumen','rhand','true',1430,2,2,'fine_steel','c',85,10,'sword',8,0.00000,0,0,0,379,0,81,-1,2290000,916,'true','true','true','true',0,0,0,0,0,0,0,0,0,'3047-1;'),
(8112,'Mysterious Sword - Magic Power','rhand','true',1430,2,2,'fine_steel','c',85,10,'sword',8,0.00000,0,0,0,379,0,81,-1,2290000,916,'true','true','true','true',0,0,0,0,0,0,0,0,0,'0-0;'),
(8113,'Mysterious Sword - Magic Weakness','rhand','true',1430,2,2,'fine_steel','c',85,10,'sword',8,0.00000,0,0,0,379,0,81,-1,2290000,916,'true','true','true','true',0,0,1164,6,8,0,0,0,0,'0-0;'),
(8114,'Ecliptic Sword - Empower','rhand','true',1380,3,3,'oriharukon','c',125,10,'sword',8,0.00000,0,0,0,379,0,111,-1,6130000,2452,'true','true','true','true',0,0,0,0,0,0,0,0,0,'0-0;'),
(8115,'Ecliptic Sword - Magic Power','rhand','true',1380,3,3,'oriharukon','c',125,10,'sword',8,0.00000,0,0,0,379,0,111,-1,6130000,2452,'true','true','true','true',0,0,0,0,0,0,0,0,0,'0-0;'),
(8116,'Ecliptic Sword - Magic Silence','rhand','true',1380,3,3,'oriharukon','c',125,10,'sword',8,0.00000,0,0,0,379,0,111,-1,6130000,2452,'true','true','true','true',0,0,0,0,0,0,0,0,0,'0-0;'),
(8117,'Wizard''s Tear - Acumen','rhand','true',1350,1,1,'oriharukon','b',155,10,'sword',8,0.00000,0,0,0,379,0,132,-1,13100000,1746,'true','true','true','true',0,0,0,0,0,0,0,0,0,'3047-1;'),
(8118,'Wizard''s Tear - Magic Power','rhand','true',1350,1,1,'oriharukon','b',155,10,'sword',8,0.00000,0,0,0,379,0,132,-1,13100000,1746,'true','true','true','true',0,0,0,0,0,0,0,0,0,'0-0;'),
(8119,'Wizard''s Tear - Conversion','rhand','true',1350,1,1,'oriharukon','b',155,10,'sword',8,0.00000,0,0,0,379,0,132,-1,13100000,1746,'true','true','true','true',0,0,0,0,0,0,0,0,0,'3048-1;'),
(8120,'Dwarven Hammer - Health','lrhand','true',2010,3,3,'steel','c',190,20,'bigblunt',4,4.00000,0,0,0,325,0,83,-1,6130000,2452,'true','true','true','true',0,0,0,0,0,0,0,0,0,'0-0;'),
(8121,'Dwarven Hammer - Anger','lrhand','true',2010,3,3,'steel','c',190,20,'bigblunt',4,4.00000,0,0,0,325,0,83,-1,6130000,2452,'true','true','true','true',0,0,0,0,0,0,0,0,0,'0-0;'),
(8122,'Dwarven Hammer - Critical Bleed','lrhand','true',2010,3,3,'steel','c',190,20,'bigblunt',4,4.00000,0,0,0,325,0,83,-1,6130000,2452,'true','true','true','true',0,0,0,0,0,0,0,0,0,'0-0;'),
(8123,'Karik Horn - Focus','lrhand','true',2020,3,3,'oriharukon','c',169,20,'bigblunt',4,4.00000,0,0,0,325,0,76,-1,4300000,1720,'true','true','true','true',0,0,0,0,0,0,0,0,0,'3010-3;'),
(8124,'Karik Horn - Haste','lrhand','true',2020,3,3,'oriharukon','c',169,20,'bigblunt',4,4.00000,0,0,0,325,0,76,-1,4300000,1720,'true','true','true','true',0,0,0,0,0,0,0,0,0,'0-0;'),
(8125,'Karik Horn - Critical Drain','lrhand','true',2020,3,3,'oriharukon','c',169,20,'bigblunt',4,4.00000,0,0,0,325,0,76,-1,4300000,1720,'true','true','true','true',0,0,0,0,0,0,0,0,0,'0-0;'),
(8126,'Destroyer Hammer - Health','lrhand','true',1910,1,1,'fine_steel','a',259,20,'bigblunt',4,4.00000,0,0,0,325,0,107,-1,18300000,1464,'true','true','true','true',0,0,0,0,0,0,0,0,0,'0-0;'),
(8127,'Destroyer Hammer - Haste','lrhand','true',1910,1,1,'fine_steel','a',259,20,'bigblunt',4,4.00000,0,0,0,325,0,107,-1,18300000,1464,'true','true','true','true',0,0,0,0,0,0,0,0,0,'0-0;'),
(8128,'Destroyer Hammer - Critical Drain','lrhand','true',1910,1,1,'fine_steel','a',259,20,'bigblunt',4,4.00000,0,0,0,325,0,107,-1,18300000,1464,'true','true','true','true',0,0,0,0,0,0,0,0,0,'0-0;'),
(8129,'Ice Storm Hammer - Focus','lrhand','true',1950,1,1,'fine_steel','b',213,20,'bigblunt',4,4.00000,0,0,0,325,0,91,-1,8680000,1157,'true','true','true','true',0,0,0,0,0,0,0,0,0,'3010-5;'),
(8130,'Ice Storm Hammer - Anger','lrhand','true',1950,1,1,'fine_steel','b',213,20,'bigblunt',4,4.00000,0,0,0,325,0,91,-1,8680000,1157,'true','true','true','true',0,0,0,0,0,0,0,0,0,'0-0;'),
(8131,'Ice Storm Hammer - Critical Bleed','lrhand','true',1950,1,1,'fine_steel','b',213,20,'bigblunt',4,4.00000,0,0,0,325,0,91,-1,8680000,1157,'true','true','true','true',0,0,0,0,0,0,0,0,0,'0-0;'),
(8132,'Star Buster - Health','lrhand','true',1930,1,1,'fine_steel','b',236,20,'bigblunt',4,4.00000,0,0,0,325,0,99,-1,13100000,1746,'true','true','true','true',0,0,0,0,0,0,0,0,0,'0-0;'),
(8133,'Star Buster - Haste','lrhand','true',1930,1,1,'fine_steel','b',236,20,'bigblunt',4,4.00000,0,0,0,325,0,99,-1,13100000,1746,'true','true','true','true',0,0,0,0,0,0,0,0,0,'0-0;'),
(8134,'Star Buster - Rsk. Focus','lrhand','true',1930,1,1,'fine_steel','b',236,20,'bigblunt',4,4.00000,0,0,0,325,0,99,-1,13100000,1746,'true','true','true','true',0,0,0,0,0,0,0,0,0,'3027-6;'),
(8135,'Doom Crusher - Health','lrhand','true',1900,1,1,'fine_steel','a',282,20,'bigblunt',4,4.00000,0,0,0,325,0,114,-1,27000000,2160,'true','true','true','true',0,0,0,0,0,0,0,0,0,'0-0;'),
(8136,'Doom Crusher - Anger','lrhand','true',1900,1,1,'fine_steel','a',282,20,'bigblunt',4,4.00000,0,0,0,325,0,114,-1,27000000,2160,'true','true','true','true',0,0,0,0,0,0,0,0,0,'0-0;'),
(8137,'Doom Crusher - Rsk. Haste','lrhand','true',1900,1,1,'fine_steel','a',282,20,'bigblunt',4,4.00000,0,0,0,325,0,114,-1,27000000,2160,'true','true','true','true',0,0,0,0,0,0,0,0,0,'0-0;'),
(8138,'Ecliptic Axe - Conversion','rhand','true',1640,3,3,'fine_steel','c',125,20,'blunt',4,4.00000,0,0,0,379,0,111,-1,6130000,2452,'true','true','true','true',0,0,0,0,0,0,0,0,0,'3048-1;'),
(8139,'Ecliptic Axe - Magic Power','rhand','true',1640,3,3,'fine_steel','c',125,20,'blunt',4,4.00000,0,0,0,379,0,111,-1,6130000,2452,'true','true','true','true',0,0,0,0,0,0,0,0,0,'0-0;'),
(8140,'Ecliptic Axe - Magic Hold','rhand','true',1640,3,3,'fine_steel','c',125,20,'blunt',4,4.00000,0,0,0,379,0,111,-1,6130000,2452,'true','true','true','true',0,0,0,0,0,0,0,0,0,'0-0;'),
(8141,'Spell Breaker - Acumen','rhand','true',1620,1,1,'fine_steel','b',140,20,'blunt',4,4.00000,0,0,0,379,0,122,-1,8680000,1157,'true','true','true','true',0,0,0,0,0,0,0,0,0,'3047-1;'),
(8142,'Spell Breaker - Magic Mental Shield','rhand','true',1620,1,1,'fine_steel','b',140,20,'blunt',4,4.00000,0,0,0,379,0,122,-1,8680000,1157,'true','true','true','true',0,0,0,0,50,0,0,0,0,'1035-4;'),
(8143,'Spell Breaker - Magic Hold','rhand','true',1620,1,1,'fine_steel','b',140,20,'blunt',4,4.00000,0,0,0,379,0,122,-1,8680000,1157,'true','true','true','true',0,0,0,0,10,0,0,0,0,'3577-1;'),
(8144,'Kaim Vanul''s Bones - Mana Up','rhand','true',1570,1,1,'bone','b',155,20,'blunt',4,4.00000,0,0,0,379,0,132,-1,13100000,1746,'true','true','true','true',0,0,0,0,0,0,0,0,0,'3014-1;'),
(8145,'Kaim Vanul''s Bones - Magic Silence','rhand','true',1570,1,1,'bone','b',155,20,'blunt',4,4.00000,0,0,0,379,0,132,-1,13100000,1746,'true','true','true','true',0,0,0,0,0,0,0,0,0,'0-0;'),
(8146,'Kaim Vanul''s Bones - Conversion','rhand','true',1570,1,1,'bone','b',155,20,'blunt',4,4.00000,0,0,0,379,0,132,-1,13100000,1746,'true','true','true','true',0,0,0,0,0,0,0,0,0,'3048-1;'),
(8147,'Spiritual Eye - Mana Up','rhand','true',1550,1,1,'bone','a',170,20,'blunt',4,4.00000,0,0,0,379,0,143,-1,18300000,1464,'true','true','true','true',0,0,0,0,0,0,0,0,0,'3014-2;'),
(8148,'Spiritual Eye - Magic Poison','rhand','true',1550,1,1,'bone','a',170,20,'blunt',4,4.00000,0,0,0,379,0,143,-1,18300000,1464,'true','true','true','true',0,0,1168,6,10,0,0,0,0,'0-0;'),
(8149,'Spiritual Eye - Acumen','rhand','true',1550,1,1,'bone','a',170,20,'blunt',4,4.00000,0,0,0,379,0,143,-1,18300000,1464,'true','true','true','true',0,0,0,0,0,0,0,0,0,'3047-2;'),
(8150,'Flaming Dragon Skull - Acumen','rhand','true',1530,1,1,'fine_steel','a',186,20,'blunt',4,4.00000,0,0,0,379,0,152,-1,27000000,2160,'true','true','true','true',0,0,0,0,0,0,0,0,0,'3047-2;'),
(8151,'Flaming Dragon Skull - Magic Power','rhand','true',1530,1,1,'fine_steel','a',186,20,'blunt',4,4.00000,0,0,0,379,0,152,-1,27000000,2160,'true','true','true','true',0,0,0,0,0,0,0,0,0,'0-0;'),
(8152,'Flaming Dragon Skull - Magic Silence','rhand','true',1530,1,1,'fine_steel','a',186,20,'blunt',4,4.00000,0,0,0,379,0,152,-1,27000000,2160,'true','true','true','true',0,0,0,0,0,0,0,0,0,'0-0;'),
(8190,'Demonic Sword Zariche','lrhand','true',1840,0,0,'bone','none',361,10,'bigsword',8,0.00000,0,0,0,325,0,137,-1,0,0,'false','false','false','false',0,0,0,0,0,0,0,0,0,'0-0;'),
(8203,'Monster Only (Venom Sword)','lrhand','true',1560,1,1,'fine_steel','none',0,10,'dual',8,0.00000,0,0,0,325,0,0,-1,0,0,'true','true','true','true',0,0,0,0,0,0,0,0,0,'0-0;'),
(8204,'Monster Only (Follower of Frintezza Calibur)','rhand','false',1560,2,2,'fine_steel','none',0,10,'sword',8,0.00000,0,0,0,379,0,0,-1,0,0,'true','true','true','true',0,0,0,0,0,0,0,0,0,'0-0;'),
(8205,'Monster Only (Heretic Priest Sickle)','lrhand','true',1920,1,1,'blood_steel','none',0,10,'pole',8,-3.00000,0,0,0,325,0,0,-1,0,0,'true','true','true','true',0,0,0,0,0,0,0,0,0,'0-0;'),
(8206,'Monster Only (Heretic Priest Sword)','lrhand','true',2080,1,1,'fine_steel','none',0,10,'dual',8,0.00000,0,0,0,325,0,0,-1,0,0,'true','true','true','true',0,0,0,0,0,0,0,0,0,'0-0;'),
(8207,'Monster Only (Heretic Private Axe)','lrhand','true',1560,1,1,'fine_steel','none',0,10,'dual',8,0.00000,0,0,0,325,0,0,-1,0,0,'true','true','true','true',0,0,0,0,0,0,0,0,0,'0-0;'),
(8208,'Monster Only (Heretic Private Staff)','lrhand','true',1560,1,1,'fine_steel','none',0,10,'pole',8,-3.00000,0,0,0,325,0,0,-1,0,0,'true','true','true','true',0,0,0,0,0,0,0,0,0,'0-0;'),
(8209,'Monster Only (Lidia Von Helmann Sword)','rhand','false',1560,2,2,'fine_steel','none',0,10,'sword',8,0.00000,0,0,0,379,0,0,-1,0,0,'true','true','true','true',0,0,0,0,0,0,0,0,0,'0-0;'),
(8210,'Monster Only (Monk Warrior Shield)','lhand','false',4800,0,0,'damascus','none',0,0,'none',0,0.00000,-8,230,20,0,0,0,-1,0,0,'true','true','true','true',0,0,0,0,0,0,0,0,0,'0-0;'),
(8211,'Monster Only (Monk Warrior Sword)','rhand','false',1560,2,2,'fine_steel','none',0,10,'sword',8,0.00000,0,0,0,379,0,0,-1,0,0,'true','true','true','true',0,0,0,0,0,0,0,0,0,'0-0;'),
(8212,'Monster Only (Solina Brother Mace)','rhand','true',1570,1,1,'chrysolite','none',0,20,'blunt',4,4.00000,0,0,0,379,0,0,-1,0,0,'true','true','true','true',0,0,0,0,0,0,0,0,0,'0-0;'),
(8213,'Monster Only (Solina Father Mace)','rhand','true',1570,1,1,'chrysolite','none',0,20,'blunt',4,4.00000,0,0,0,379,0,0,-1,0,0,'true','true','true','true',0,0,0,0,0,0,0,0,0,'0-0;'),
(8214,'Monster Only (Solina Priest Pole)','lrhand','false',1920,1,1,'blood_steel','none',0,10,'pole',8,-3.00000,0,0,0,325,0,0,-1,0,0,'true','true','true','true',0,0,0,0,0,0,0,0,0,'0-0;'),
(8215,'Monster Only (Zombie Enlisted Man Sword)','lrhand','true',2090,3,3,'fine_steel','none',0,10,'bigsword',8,0.00000,0,0,0,325,0,0,-1,0,0,'true','true','true','true',0,0,0,0,0,0,0,0,0,'0-0;'),
(8216,'Monster Only (Zombie Enlisted Man Claw)','lrhand','false',1350,1,1,'adamantaite','none',0,5,'dualfist',4,4.00000,0,0,0,325,0,0,-1,0,0,'true','true','true','true',0,0,0,0,0,0,0,0,0,'0-0;'),
(8217,'Monster Only (Zombie Gateguard Spear)','rhand','true',1560,2,2,'fine_steel','none',0,10,'sword',8,0.00000,0,0,0,379,0,0,-1,0,0,'true','true','true','true',0,0,0,0,0,0,0,0,0,'0-0;'),
(8218,'Monster Only (Zombie Laborer Axe)','rhand','true',1570,1,1,'chrysolite','none',0,20,'blunt',4,4.00000,0,0,0,379,0,0,-1,0,0,'true','true','true','true',0,0,0,0,0,0,0,0,0,'0-0;'),
(8219,'Monster Only (Zombie Laborer Sword)','rhand','true',1560,2,2,'fine_steel','none',0,10,'sword',8,0.00000,0,0,0,379,0,0,-1,0,0,'true','true','true','true',0,0,0,0,0,0,0,0,0,'0-0;'),
(8220,'Monster Only (Grail Apostle Bow)','lrhand','true',1950,1,1,'wood','none',0,5,'bow',12,-3.00000,0,0,0,293,1,0,-1,0,0,'true','true','true','true',0,0,0,0,0,0,0,0,0,'0-0;'),
(8221,'Monster Only (Grail Apostle Spear)','lrhand','false',1920,1,1,'blood_steel','none',0,10,'pole',8,-3.00000,0,0,0,325,0,0,-1,0,0,'true','true','true','true',0,0,0,0,0,0,0,0,0,'0-0;'),
(8222,'Monster Only (Follower of Frintezza Tran Calibur)','rhand','true',1560,2,2,'fine_steel','none',0,10,'sword',8,0.00000,0,0,0,379,0,0,-1,0,0,'true','true','true','true',0,0,0,0,0,0,0,0,0,'0-0;'),
(8350,'Chrono Maracas','lrhand','true',0,0,0,'fine_steel','none',1,5,'dual',8,0.00000,0,0,0,325,0,1,-1,0,0,'true','false','true','true',0,0,0,0,0,0,0,0,0,'0-0;'),
(8527,'For Monsters Only (Strengthened Bow)','lrhand','true',1870,6,2,'steel','d',82,5,'bow',12,-3.00000,0,0,0,293,3,26,-1,0,0,'true','true','true','true',0,0,0,0,0,0,0,0,0,'0-0;'),
(8528,'For Monsters Only (Doom Hammer)','rhand','true',1200,2,2,'steel','d',41,20,'blunt',4,4.00000,0,0,0,379,0,43,-1,0,0,'true','true','true','true',0,0,0,0,0,0,0,0,0,'0-0;'),
(8529,'For Monsters Only (Knife)','rhand','false',1140,1,1,'bronze','none',10,5,'dagger',12,-3.00000,0,0,0,433,0,9,-1,0,0,'true','true','true','true',0,0,0,0,0,0,0,0,0,'0-0;'),
(8530,'For Monsters Only (Squire''s Sword)','rhand','false',1600,1,1,'steel','none',6,10,'sword',8,0.00000,0,0,0,379,0,5,-1,0,0,'true','true','true','true',0,0,0,0,0,0,0,0,0,'0-0;'),
(8531,'For Monsters Only (Bone Staff)','lrhand','true',1060,2,2,'bone','d',39,20,'bigblunt',4,4.00000,0,0,0,325,0,35,-1,0,0,'true','true','true','true',0,0,0,0,0,0,0,0,0,'0-0;'),
(8532,'For Monsters Only (Spinebone Sword)','rhand','true',1510,2,2,'bone','d',51,10,'sword',8,0.00000,0,0,0,379,0,32,-1,0,0,'true','true','true','true',0,0,0,0,0,0,0,0,0,'0-0;'),
(8533,'For Monsters Only (Crimson Sword)','rhand','true',1490,2,2,'fine_steel','d',64,10,'sword',8,0.00000,0,0,0,379,0,39,-1,0,0,'true','true','true','true',0,0,0,0,0,0,0,0,0,'0-0;'),
(8576,'Apprentice''s Staff (Event)','lrhand','false',1070,2,2,'wood','none',23,20,'bigblunt',4,4.00000,0,0,0,325,0,22,-1,0,0,'false','false','false','false',0,0,0,0,0,0,0,0,0,'0-0;'),
(8577,'Bone Club (Event)','rhand','false',1850,2,2,'fine_steel','none',24,20,'blunt',4,4.00000,0,0,0,379,0,17,-1,0,0,'false','false','false','false',0,0,0,0,0,0,0,0,0,'0-0;'),
(8578,'Shining Knife (Event)','rhand','false',1120,2,2,'mithril','none',21,5,'dagger',12,-3.00000,0,0,0,433,0,17,-1,0,0,'false','false','false','false',0,0,0,0,0,0,0,0,0,'0-0;'),
(8579,'Cestus (Event)','lrhand','false',1570,2,2,'steel','none',29,5,'dualfist',4,4.00000,0,0,0,325,0,17,-1,0,0,'false','false','false','false',0,0,0,0,0,0,0,0,0,'0-0;'),
(8580,'Forest Bow (Event)','lrhand','false',1900,7,2,'wood','none',49,5,'bow',12,-3.00000,0,0,0,293,3,17,-1,0,0,'false','false','false','false',0,0,0,0,0,0,0,0,0,'0-0;'),
(8581,'Long Sword (Event)','rhand','false',1560,2,2,'fine_steel','none',24,10,'sword',8,0.00000,0,0,0,379,0,17,-1,0,0,'false','false','false','false',0,0,0,0,0,0,0,0,0,'0-0;'),
(8582,'Mace of Prayer (Event)','rhand','false',1300,2,2,'steel','d',41,20,'blunt',4,4.00000,0,0,0,379,0,43,-1,0,0,'false','false','false','false',0,0,0,0,0,0,0,0,0,'0-0;'),
(8583,'Dark Elven Bow (Event)','lrhand','false',1830,6,2,'steel','d',105,5,'bow',12,-3.00000,0,0,0,293,4,32,-1,0,0,'false','false','false','false',0,0,0,0,0,0,0,0,0,'0-0;'),
(8584,'Long Bow (Event)','lrhand','false',1830,6,2,'steel','d',114,5,'bow',12,-3.00000,0,0,0,227,4,35,-1,0,0,'false','false','false','false',0,0,0,0,0,0,0,0,0,'0-0;'),
(8585,'Staff of Mana (Event)','lrhand','false',1040,2,2,'wood','d',50,20,'bigblunt',4,4.00000,0,0,0,325,0,43,-1,0,0,'false','false','false','false',0,0,0,0,0,0,0,0,0,'0-0;'),
(8586,'Bastard Sword (Event)','rhand','false',1510,2,2,'fine_steel','d',51,10,'sword',8,0.00000,0,0,0,379,0,32,-1,0,0,'false','false','false','false',0,0,0,0,0,0,0,0,0,'0-0;'),
(8587,'Divine Tomb (Event)','rhand','false',570,2,2,'steel','d',41,10,'etc',8,0.00000,0,0,0,379,0,43,-1,0,0,'false','false','false','false',0,0,0,0,0,0,0,0,0,'0-0;'),
(8588,'Single-Edged Jamadhr (Event)','lrhand','false',1550,2,2,'steel','d',62,5,'dualfist',4,4.00000,0,0,0,325,0,32,-1,0,0,'false','false','false','false',0,0,0,0,0,0,0,0,0,'0-0;'),
(8589,'Tomahawk (Event)','rhand','false',1780,2,2,'bronze','d',51,20,'blunt',4,4.00000,0,0,0,379,0,32,-1,0,0,'false','false','false','false',0,0,0,0,0,0,0,0,0,'0-0;'),
(8590,'Poniard Daggar (Event)','rhand','false',1090,2,2,'steel','d',45,5,'dagger',12,-3.00000,0,0,0,433,0,32,-1,0,0,'false','false','false','false',0,0,0,0,0,0,0,0,0,'0-0;'),
(8591,'Pike (Event)','lrhand','false',2090,2,2,'steel','d',51,10,'pole',8,-3.00000,0,0,0,325,0,32,-1,0,0,'false','false','false','false',0,0,0,0,0,0,0,0,0,'0-0;'),
(8678,'Sirra''s Blade','rhand','true',1300,1,1,'fine_steel','a',251,10,'sword',8,0.00000,0,0,0,379,0,121,-1,0,2824,'true','true','true','true',0,0,0,0,0,0,0,0,9352,'0-0;'),
(8679,'Sword of Ipos','lrhand','true',1820,1,1,'bone','a',305,10,'bigsword',8,0.00000,0,0,0,325,0,121,-1,0,2824,'true','true','true','true',0,0,0,0,0,0,0,0,9356,'0-0;'),
(8680,'Barakiel''s Axe','rhand','true',1550,1,1,'oriharukon','a',251,20,'blunt',4,4.00000,0,0,0,379,0,121,-1,0,2824,'true','true','true','true',0,0,0,0,0,0,0,0,0,'0-0;'),
(8681,'Behemoth''s Tuning Fork','lrhand','true',1890,1,1,'fine_steel','a',305,20,'bigblunt',4,4.00000,0,0,0,325,0,121,-1,0,2824,'true','true','true','true',0,0,0,0,0,0,0,0,0,'0-0;'),
(8682,'Naga Storm','rhand','true',930,1,1,'oriharukon','a',220,5,'dagger',12,-3.00000,0,0,0,433,0,121,-1,0,2824,'true','true','true','true',0,0,0,0,0,0,0,0,0,'0-0;'),
(8683,'Tiphon''s Spear','lrhand','true',1820,1,1,'chrysolite','a',251,10,'pole',8,-3.00000,0,0,0,325,0,121,-1,0,2824,'true','true','true','true',0,0,0,0,0,0,0,0,0,'0-0;'),
(8684,'Shyeed''s Bow','lrhand','true',1640,2,1,'oriharukon','a',570,5,'bow',12,-3.00000,0,0,0,227,10,133,-1,0,2824,'true','true','true','true',0,0,0,0,0,0,0,0,9360,'0-0;'),
(8685,'Sobekk''s Hurricane','lrhand','true',1330,1,1,'adamantaite','a',305,5,'dualfist',4,4.00000,0,0,0,325,0,121,-1,0,2824,'true','true','true','true',0,0,0,0,0,0,0,0,0,'0-0;'),
(8686,'Themis'' Tongue','rhand','true',820,1,1,'adamantaite','a',202,10,'sword',8,0.00000,0,0,0,379,0,161,-1,0,2824,'true','true','true','true',0,0,0,0,0,0,0,0,0,'0-0;'),
(8687,'Cabrio''s Hand','rhand','true',1510,1,1,'fine_steel','a',202,20,'blunt',4,4.00000,0,0,0,379,0,161,-1,0,2824,'true','true','true','true',0,0,0,0,0,0,0,0,0,'0-0;'),
(8688,'Daimon Crystal','lrhand','true',880,1,1,'wood','a',245,20,'bigblunt',4,4.00000,0,0,0,325,0,161,-1,0,2824,'true','true','true','true',0,0,0,0,0,0,0,0,0,'0-0;'),
(8689,'Blood Sword Akamanah','lrhand','true',1840,0,0,'bone','none',361,10,'dual',8,0.00000,0,0,0,325,0,137,-1,0,0,'false','false','false','false',0,0,0,0,0,0,0,0,0,'0-0;'),
(8763,'Elrokian Trap','rhand','false',500,0,0,'oriharukon','a',0,0,'blunt',0,0.00000,0,0,0,379,0,0,-1,0,0,'true','true','true','true',0,0,0,0,0,0,0,0,0,'0-0;'),
(8788,'Sirra''s Blade - Haste','rhand','true',1300,1,1,'fine_steel','a',251,10,'sword',8,0.00000,0,0,0,379,0,121,-1,0,2824,'true','true','true','true',0,0,0,0,0,0,0,0,9353,'3037-6;'),
(8789,'Sirra''s Blade - Health','rhand','true',1300,1,1,'fine_steel','a',251,10,'sword',8,0.00000,0,0,0,379,0,121,-1,0,2824,'true','true','true','true',0,0,0,0,0,0,0,0,9354,'3013-4;'),
(8790,'Sirra''s Blade - Critical Poison','rhand','true',1300,1,1,'fine_steel','a',251,10,'sword',8,0.00000,0,0,0,379,0,121,-1,0,2824,'true','true','true','true',0,0,0,0,0,3024,6,15,9355,'0-0;'),
(8791,'Sword of Ipos - Focus','lrhand','true',1820,1,1,'bone','a',305,10,'bigsword',8,0.00000,0,0,0,325,0,121,-1,0,2824,'true','true','true','true',0,0,0,0,0,0,0,0,9357,'3050-2;'),
(8792,'Sword of Ipos - Haste','lrhand','true',1820,1,1,'bone','a',305,10,'bigsword',8,0.00000,0,0,0,325,0,121,-1,0,2824,'true','true','true','true',0,0,0,0,0,0,0,0,9358,'3037-6;'),
(8793,'Sword of Ipos - Health','lrhand','true',1820,1,1,'bone','a',305,10,'bigsword',8,0.00000,0,0,0,325,0,121,-1,0,2824,'true','true','true','true',0,0,0,0,0,0,0,0,9359,'3013-4;'),
(8794,'Barakiel''s Axe - Health','rhand','true',1550,1,1,'oriharukon','a',251,20,'blunt',4,4.00000,0,0,0,379,0,121,-1,0,2824,'true','true','true','true',0,0,0,0,0,0,0,0,0,'3013-4;'),
(8795,'Barakiel''s Axe - Haste','rhand','true',1550,1,1,'oriharukon','a',251,20,'blunt',4,4.00000,0,0,0,379,0,121,-1,0,2824,'true','true','true','true',0,0,0,0,0,0,0,0,0,'3037-6;'),
(8796,'Barakiel''s Axe - Focus','rhand','true',1550,1,1,'oriharukon','a',251,20,'blunt',4,4.00000,0,0,0,379,0,121,-1,0,2824,'true','true','true','true',0,0,0,0,0,0,0,0,0,'3050-2;'),
(8797,'Behemoth''s Tuning Fork - Focus','lrhand','true',1890,1,1,'fine_steel','a',305,20,'bigblunt',4,4.00000,0,0,0,325,0,121,-1,0,2824,'true','true','true','true',0,0,0,0,0,0,0,0,0,'3050-2;'),
(8798,'Behemoth''s Tuning Fork - Health','lrhand','true',1890,1,1,'fine_steel','a',305,20,'bigblunt',4,4.00000,0,0,0,325,0,121,-1,0,2824,'true','true','true','true',0,0,0,0,0,0,0,0,0,'3013-4;'),
(8799,'Behemoth''s Tuning Fork - Anger','lrhand','true',1890,1,1,'fine_steel','a',305,20,'bigblunt',4,4.00000,0,0,0,325,0,121,-1,0,2824,'true','true','true','true',0,0,0,0,0,0,0,0,0,'3057-1;'),
(8800,'Naga Storm - Focus','rhand','true',930,1,1,'oriharukon','a',220,5,'dagger',12,-3.00000,0,0,0,433,0,121,-1,0,2824,'true','true','true','true',0,0,0,0,0,0,0,0,0,'3051-1;'),
(8801,'Naga Storm - Critical Damage','rhand','true',930,1,1,'oriharukon','a',220,5,'dagger',12,-3.00000,0,0,0,433,0,121,-1,0,2824,'true','true','true','true',0,0,0,0,0,0,0,0,0,'3066-1;'),
(8802,'Naga Storm - Back Blow','rhand','true',930,1,1,'oriharukon','a',220,5,'dagger',12,-3.00000,0,0,0,433,0,121,-1,0,2824,'true','true','true','true',0,0,0,0,0,0,0,0,0,'3018-5;'),
(8803,'Tiphon''s Spear - Critical Stun','lrhand','true',1820,1,1,'chrysolite','a',251,10,'pole',8,-3.00000,0,0,0,325,0,121,-1,0,2824,'true','true','true','true',0,0,0,0,0,3070,1,25,0,'0-0;'),
(8804,'Tiphon''s Spear - Towering Blow','lrhand','true',1820,1,1,'chrysolite','a',251,10,'pole',8,-3.00000,0,0,0,325,0,121,-1,0,2824,'true','true','true','true',0,0,0,0,0,0,0,0,0,'0-0;'),
(8805,'Tiphon''s Spear - Wild Blow','lrhand','true',1820,1,1,'chrysolite','a',251,10,'pole',8,-3.00000,0,0,0,325,0,121,-1,0,2824,'true','true','true','true',0,0,0,0,0,0,0,0,0,'0-0;'),
(8806,'Shyeed''s Bow - Cheap Shot','lrhand','true',1640,2,1,'oriharukon','a',570,5,'bow',12,-3.00000,0,0,0,227,10,133,-1,0,2824,'true','true','true','true',0,0,0,0,0,0,0,0,9361,'0-0;'),
(8807,'Shyeed''s Bow - Focus','lrhand','true',1640,2,1,'oriharukon','a',570,5,'bow',12,-3.00000,0,0,0,227,10,133,-1,0,2824,'true','true','true','true',0,0,0,0,0,0,0,0,9362,'3050-2;'),
(8808,'Shyeed''s Bow - Quick Recovery','lrhand','true',1640,2,1,'oriharukon','a',570,5,'bow',12,-3.00000,0,0,0,227,10,133,-1,0,2824,'true','true','true','true',0,0,0,0,0,0,0,0,9363,'0-0;'),
(8809,'Sobekk''s Hurricane - Rsk. Haste','lrhand','true',1330,1,1,'adamantaite','a',305,5,'dualfist',4,4.00000,0,0,0,325,0,121,-1,0,2824,'true','true','true','true',0,0,0,0,0,0,0,0,0,'3032-4;'),
(8810,'Sobekk''s Hurricane - Haste','lrhand','true',1330,1,1,'adamantaite','a',305,5,'dualfist',4,4.00000,0,0,0,325,0,121,-1,0,2824,'true','true','true','true',0,0,0,0,0,0,0,0,0,'3037-6;'),
(8811,'Sobekk''s Hurricane - Critical Drain','lrhand','true',1330,1,1,'adamantaite','a',305,5,'dualfist',4,4.00000,0,0,0,325,0,121,-1,0,2824,'true','true','true','true',0,0,0,0,0,3022,5,10,0,'0-0;'),
(8812,'Themis'' Tongue - Mana Up','rhand','true',820,1,1,'adamantaite','a',202,10,'sword',8,0.00000,0,0,0,379,0,161,-1,0,2824,'true','true','true','true',0,0,0,0,0,0,0,0,0,'3014-2;'),
(8813,'Themis'' Tongue - Magic Mental Shield','rhand','true',820,1,1,'adamantaite','a',202,10,'sword',8,0.00000,0,0,0,379,0,161,-1,0,2824,'true','true','true','true',0,0,1035,2,50,0,0,0,0,'0-0;'),
(8814,'Themis'' Tongue - Magic Focus','rhand','true',820,1,1,'adamantaite','a',202,10,'sword',8,0.00000,0,0,0,379,0,161,-1,0,2824,'true','true','true','true',0,0,1077,3,20,0,0,0,0,'0-0;'),
(8815,'Cabrio''s Hand - Conversion','rhand','true',1510,1,1,'fine_steel','a',202,20,'blunt',4,4.00000,0,0,0,379,0,161,-1,0,2824,'true','true','true','true',0,0,0,0,0,0,0,0,0,'3048-2;'),
(8816,'Cabrio''s Hand - Mana Up','rhand','true',1510,1,1,'fine_steel','a',202,20,'blunt',4,4.00000,0,0,0,379,0,161,-1,0,2824,'true','true','true','true',0,0,0,0,0,0,0,0,0,'3014-3;'),
(8817,'Cabrio''s Hand - Magic Silence','rhand','true',1510,1,1,'fine_steel','a',202,20,'blunt',4,4.00000,0,0,0,379,0,161,-1,0,2824,'true','true','true','true',0,0,3078,2,10,0,0,0,0,'0-0;'),
(8818,'Daimon Crystal - Mana Up','lrhand','true',880,1,1,'wood','a',245,20,'bigblunt',4,4.00000,0,0,0,325,0,161,-1,0,2824,'true','true','true','true',0,0,0,0,0,0,0,0,0,'3014-2;'),
(8819,'Daimon Crystal - Acumen','lrhand','true',880,1,1,'wood','a',245,20,'bigblunt',4,4.00000,0,0,0,325,0,161,-1,0,2824,'true','true','true','true',0,0,0,0,0,0,0,0,0,'3047-3;'),
(8820,'Daimon Crystal - Magic Mental Shield','lrhand','true',880,1,1,'wood','a',245,20,'bigblunt',4,4.00000,0,0,0,325,0,161,-1,0,2824,'true','true','true','true',0,0,1035,2,50,0,0,0,0,'0-0;'),
(8821,'Shadow Item: Two Handed Sword','lrhand','true',730,2,2,'fine_steel','d',78,10,'bigsword',8,0.00000,0,0,0,325,0,39,90,0,0,'false','false','true','false',0,0,0,0,0,0,0,0,0,'0-0;'),
(8822,'Shadow Item: Crimson Sword','rhand','true',500,2,2,'fine_steel','d',64,10,'sword',8,0.00000,0,0,0,379,0,39,90,0,0,'false','false','true','false',0,0,0,0,0,0,0,0,0,'0-0;'),
(8823,'Shadow Item: Spiked Club','rhand','true',590,2,2,'steel','d',64,20,'blunt',4,4.00000,0,0,0,379,0,39,90,0,0,'false','false','true','false',0,0,0,0,0,0,0,0,0,'0-0;'),
(8824,'Shadow Item: Staff of Magic','lrhand','true',340,2,2,'wood','d',62,20,'bigblunt',4,4.00000,0,0,0,325,0,52,90,0,0,'false','false','true','false',0,0,0,0,0,0,0,0,0,'0-0;'),
(8825,'Shadow Item: Kukuri','rhand','true',360,2,2,'fine_steel','d',56,5,'dagger',12,-3.00000,0,0,0,433,0,39,90,0,0,'false','false','true','false',0,0,0,0,0,0,0,0,0,'0-0;'),
(8826,'Shadow Item: Dagger of Mana','rhand','true',250,2,2,'fine_steel','d',45,5,'dagger',12,-3.00000,0,0,0,433,0,52,90,0,0,'false','false','true','false',0,0,0,0,0,0,0,0,0,'0-0;'),
(8827,'Shadow Item: Triple-Edged Jamadhr','lrhand','true',520,2,2,'fine_steel','d',78,5,'dualfist',4,4.00000,0,0,0,325,0,39,90,0,0,'false','false','true','false',0,0,0,0,0,0,0,0,0,'0-0;'),
(8828,'Shadow Item: Gastraphetes','lrhand','true',620,8,2,'fine_steel','d',132,5,'bow',12,-3.00000,0,0,0,293,4,39,90,0,0,'false','false','true','false',0,0,0,0,0,0,0,0,0,'0-0;'),
(8829,'Shadow Item: War Hammer','lrhand','true',700,2,2,'fine_steel','d',64,10,'pole',8,-3.00000,0,0,0,325,0,39,90,0,0,'false','false','true','false',0,0,0,0,0,0,0,0,0,'0-0;'),
(8830,'Shadow Item: Katana','rhand','true',480,2,2,'fine_steel','c',122,10,'sword',8,0.00000,0,0,0,379,0,68,300,0,0,'false','false','true','false',0,0,0,0,0,0,0,0,0,'0-0;'),
(8831,'Shadow Item: Bec de Corbin','lrhand','true',680,2,2,'fine_steel','c',122,10,'pole',8,-3.00000,0,0,0,325,0,68,300,0,0,'false','false','true','false',0,0,0,0,0,0,0,0,0,'0-0;'),
(8832,'Shadow Item: Cursed Staff','lrhand','true',340,2,2,'wood','c',119,20,'bigblunt',4,4.00000,0,0,0,325,0,91,300,0,0,'false','false','true','false',0,0,0,0,0,0,0,0,0,'0-0;'),
(8833,'Shadow Item: Stiletto','rhand','true',350,2,2,'fine_steel','c',107,5,'dagger',12,-3.00000,0,0,0,433,0,68,300,0,0,'false','false','true','false',0,0,0,0,0,0,0,0,0,'0-0;'),
(8834,'Shadow Item: Soulfire Dirk','rhand','true',250,2,2,'fine_steel','c',86,5,'dagger',12,-3.00000,0,0,0,433,0,91,300,0,0,'false','false','true','false',0,0,0,0,0,0,0,0,0,'0-0;'),
(8835,'Shadow Item: Elemental Bow','lrhand','true',590,8,2,'fine_steel','c',277,5,'bow',12,-3.00000,0,0,0,227,7,75,300,0,0,'false','false','true','false',0,0,0,0,0,0,0,0,0,'0-0;'),
(8836,'Shadow Item: Dwarven War Hammer','rhand','true',560,2,2,'fine_steel','c',122,20,'blunt',4,4.00000,0,0,0,379,0,68,300,0,0,'false','false','true','false',0,0,0,0,0,0,0,0,0,'0-0;'),
(8837,'Shadow Item: Sword of Revolution','lrhand','true',790,2,2,'fine_steel','c',148,10,'dual',8,0.00000,0,0,0,325,0,68,300,0,0,'false','false','true','false',0,0,0,0,0,0,0,0,0,'0-0;'),
(8838,'Shadow Item: Knuckle Duster','lrhand','true',500,2,2,'fine_steel','c',148,5,'dualfist',4,4.00000,0,0,0,325,0,68,300,0,0,'false','false','true','false',0,0,0,0,0,0,0,0,0,'0-0;'),
(8839,'Shadow Item: Sword of Delusion','rhand','true',470,3,3,'mithril','c',139,10,'sword',8,0.00000,0,0,0,379,0,76,300,0,0,'false','false','true','false',0,0,0,0,0,0,0,0,0,'0-0;'),
(8840,'Shadow Item: Poleaxe','lrhand','true',670,3,3,'bronze','c',139,10,'pole',8,-3.00000,0,0,0,325,0,76,300,0,0,'false','false','true','false',0,0,0,0,0,0,0,0,0,'0-0;'),
(8841,'Shadow Item: Stick of Eternity','rhand','true',380,3,3,'wood','c',111,20,'blunt',4,4.00000,0,0,0,379,0,101,300,0,0,'false','false','true','false',0,0,0,0,0,0,0,0,0,'0-0;'),
(8842,'Shadow Item: Inferno Staff','lrhand','true',340,3,3,'wood','c',135,20,'bigblunt',4,4.00000,0,0,0,325,0,101,300,0,0,'false','false','true','false',0,0,0,0,0,0,0,0,0,'0-0;'),
(8843,'Shadow Item: Pa''agrian Hammer','lrhand','true',340,3,3,'blood_steel','c',135,20,'bigblunt',4,4.00000,0,0,0,325,0,101,300,0,0,'false','false','true','false',0,0,0,0,0,0,0,0,0,'0-0;'),
(8844,'Shadow Item: Dark Screamer','rhand','true',340,3,3,'fine_steel','c',122,5,'dagger',12,-3.00000,0,0,0,433,0,76,300,0,0,'false','false','true','false',0,0,0,0,0,0,0,0,0,'0-0;'),
(8845,'Shadow Item: Akat Long Bow','lrhand','true',580,9,3,'horn','c',316,5,'bow',12,-3.00000,0,0,0,227,7,84,300,0,0,'false','false','true','false',0,0,0,0,0,0,0,0,0,'0-0;'),
(8846,'Shadow Item: Pa''agrian Sword','lrhand','true',660,3,3,'steel','c',169,10,'bigsword',8,0.00000,0,0,0,325,0,76,300,0,0,'false','false','true','false',0,0,0,0,0,0,0,0,0,'0-0;'),
(8847,'Shadow Item: Fisted Blade','lrhand','true',500,3,3,'fine_steel','c',169,5,'dualfist',4,4.00000,0,0,0,325,0,76,300,0,0,'false','false','true','false',0,0,0,0,0,0,0,0,0,'0-0;'),
(8848,'Shadow Item: Stormbringer','lrhand','true',780,3,3,'fine_steel','c',175,10,'dual',8,0.00000,0,0,0,325,0,78,300,0,0,'false','false','true','false',0,0,0,0,0,0,0,0,0,'0-0;'),
(8849,'Shadow Item: Great Sword','lrhand','true',650,1,1,'steel','b',213,10,'bigsword',8,0.00000,0,0,0,325,0,91,300,0,0,'false','false','true','false',0,0,0,0,0,0,0,0,0,'0-0;'),
(8850,'Shadow Item: Heavy War Axe','rhand','true',540,1,1,'fine_steel','b',175,20,'blunt',4,4.00000,0,0,0,379,0,91,300,0,0,'false','false','true','false',0,0,0,0,0,0,0,0,0,'0-0;'),
(8851,'Shadow Item: Sprite''s Staff','lrhand','true',320,1,1,'wood','b',170,20,'bigblunt',4,4.00000,0,0,0,325,0,122,300,0,0,'false','false','true','false',0,0,0,0,0,0,0,0,0,'0-0;'),
(8852,'Shadow Item: Keshanberk','rhand','true',460,1,1,'oriharukon','b',175,10,'sword',8,0.00000,0,0,0,379,0,91,300,0,0,'false','false','true','false',0,0,0,0,0,0,0,0,0,'0-0;'),
(8853,'Shadow Item: Sword of Valhalla','rhand','true',300,1,1,'oriharukon','b',140,10,'sword',8,0.00000,0,0,0,379,0,122,300,0,0,'false','false','true','false',0,0,0,0,0,0,0,0,0,'0-0;'),
(8854,'Shadow Item: Kris','rhand','true',330,1,1,'mithril','b',153,5,'dagger',12,-3.00000,0,0,0,433,0,91,300,0,0,'false','false','true','false',0,0,0,0,0,0,0,0,0,'0-0;'),
(8855,'Shadow Item: Arthro Nail','lrhand','true',480,1,1,'blood_steel','b',213,5,'dualfist',4,4.00000,0,0,0,325,0,91,300,0,0,'false','false','true','false',0,0,0,0,0,0,0,0,0,'0-0;'),
(8856,'Shadow Item: Dark Elven Long Bow','lrhand','true',580,3,1,'oriharukon','b',397,5,'bow',12,-3.00000,0,0,0,227,8,100,300,0,0,'false','false','true','false',0,0,0,0,0,0,0,0,0,'0-0;'),
(8857,'Shadow Item: Swords of Delusion','lrhand','true',720,1,1,'fine_steel','b',213,10,'dual',8,0.00000,0,0,0,325,0,91,300,0,0,'false','false','true','false',0,0,0,0,0,0,0,0,0,'0-0;'),
(8858,'Shadow Item: Great Axe','lrhand','true',650,1,1,'damascus','b',175,10,'pole',8,-3.00000,0,0,0,325,0,91,300,0,0,'false','false','true','false',0,0,0,0,0,0,0,0,0,'0-0;'),
(8859,'Shadow Item: Tallum Blade','rhand','true',450,1,1,'adamantaite','a',213,10,'sword',8,0.00000,0,0,0,379,0,107,300,0,0,'false','false','true','false',0,0,0,0,0,0,0,0,0,'0-0;'),
(8860,'Shadow Item: Halberd','lrhand','true',640,1,1,'oriharukon','a',213,10,'pole',8,-3.00000,0,0,0,325,0,107,300,0,0,'false','false','true','false',0,0,0,0,0,0,0,0,0,'0-0;'),
(8861,'Shadow Item: Dasparion''s Staff','lrhand','true',310,1,1,'adamantaite','a',207,20,'bigblunt',4,4.00000,0,0,0,325,0,143,300,0,0,'false','false','true','false',0,0,0,0,0,0,0,0,0,'0-0;'),
(8862,'Shadow Item: Bloody Orchid','rhand','true',320,1,1,'blood_steel','a',186,5,'dagger',12,-3.00000,0,0,0,433,0,107,300,0,0,'false','false','true','false',0,0,0,0,0,0,0,0,0,'0-0;'),
(8863,'Shadow Item: Blood Tornado','lrhand','true',460,1,1,'blood_steel','a',259,5,'dualfist',4,4.00000,0,0,0,325,0,107,300,0,0,'false','false','true','false',0,0,0,0,0,0,0,0,0,'0-0;'),
(8864,'Shadow Item: Carnage Bow','lrhand','true',560,2,1,'damascus','a',440,5,'bow',12,-3.00000,0,0,0,293,9,107,300,0,0,'false','false','true','false',0,0,0,0,0,0,0,0,0,'0-0;'),
(8865,'Shadow Item: Dual Keshanberk','lrhand','true',700,1,1,'fine_steel','a',259,10,'dual',8,0.00000,0,0,0,325,0,107,300,0,0,'false','false','true','false',0,0,0,0,0,0,0,0,0,'0-0;'),
(8866,'Shadow Item: Meteor Shower','rhand','true',540,1,1,'fine_steel','a',213,20,'blunt',4,4.00000,0,0,0,379,0,107,300,0,0,'false','false','true','false',0,0,0,0,0,0,0,0,0,'0-0;'),
(8867,'Shadow Item: Inferno Master','lrhand','true',640,1,1,'fine_steel','a',259,10,'bigsword',8,0.00000,0,0,0,325,0,107,300,0,0,'false','false','true','false',0,0,0,0,0,0,0,0,0,'0-0;'),
(8926,'Shadow Item: Sword of Delusion','rhand','true',470,3,3,'mithril','c',139,10,'sword',8,0.00000,0,0,0,379,0,76,120,0,0,'false','false','true','false',0,0,0,0,0,0,0,0,0,'0-0;'),
(8927,'Shadow Item: Poleaxe','lrhand','true',670,3,3,'bronze','c',139,10,'pole',8,-3.00000,0,0,0,325,0,76,120,0,0,'false','false','true','false',0,0,0,0,0,0,0,0,0,'0-0;'),
(8928,'Shadow Item: Stick of Eternity','rhand','true',380,3,3,'wood','c',111,20,'blunt',4,4.00000,0,0,0,379,0,101,120,0,0,'false','false','true','false',0,0,0,0,0,0,0,0,0,'0-0;'),
(8929,'Shadow Item: Inferno Staff','lrhand','true',340,3,3,'wood','c',135,20,'bigblunt',4,4.00000,0,0,0,325,0,101,120,0,0,'false','false','true','false',0,0,0,0,0,0,0,0,0,'0-0;'),
(8930,'Shadow Item: Pa''agrian Hammer','lrhand','true',340,3,3,'blood_steel','c',135,20,'bigblunt',4,4.00000,0,0,0,325,0,101,120,0,0,'false','false','true','false',0,0,0,0,0,0,0,0,0,'0-0;'),
(8931,'Shadow Item: Dark Screamer','rhand','true',340,3,3,'fine_steel','c',122,5,'dagger',12,-3.00000,0,0,0,433,0,76,120,0,0,'false','false','true','false',0,0,0,0,0,0,0,0,0,'0-0;'),
(8932,'Shadow Item: Akat Long Bow','lrhand','true',580,9,3,'horn','c',316,5,'bow',12,-3.00000,0,0,0,227,7,84,120,0,0,'false','false','true','false',0,0,0,0,0,0,0,0,0,'0-0;'),
(8933,'Shadow Item: Pa''agrian Sword','lrhand','true',660,3,3,'steel','c',169,10,'bigsword',8,0.00000,0,0,0,325,0,76,120,0,0,'false','false','true','false',0,0,0,0,0,0,0,0,0,'0-0;'),
(8934,'Shadow Item: Fisted Blade','lrhand','true',500,3,3,'fine_steel','c',169,5,'dualfist',4,4.00000,0,0,0,325,0,76,120,0,0,'false','false','true','false',0,0,0,0,0,0,0,0,0,'0-0;'),
(8935,'Test Rapier','rhand','true',1380,3,3,'oriharukon','c',156,10,'sword',8,0.00000,0,0,0,379,0,83,120,0,0,'true','true','true','true',0,0,0,0,0,0,0,0,0,'0-0;'),
(8937,'Shadow Item: Stormbringer','lrhand','true',780,3,3,'fine_steel','c',175,10,'dual',8,0.00000,0,0,0,325,0,78,120,0,0,'false','false','true','false',0,0,0,0,0,0,0,0,0,'0-0;'),
(8938,'Damascus * Tallum Blade','lrhand','true',1890,1,1,'fine_steel','a',305,10,'dual',8,0.00000,0,0,0,325,0,121,-1,0,2824,'true','true','true','true',0,0,0,0,0,0,0,0,0,'0-0;'),
(8972,'Shadow Item: Great Spear','lrhand','false',707,2,2,'bronze','none',31,10,'pole',8,-3.00000,0,0,0,325,0,21,600,0,0,'false','false','true','false',0,0,0,0,0,0,0,0,0,'0-0;'),
(8973,'Shadow Item: Falchion','rhand','false',510,2,2,'bronze','none',31,10,'sword',8,0.00000,0,0,0,379,0,21,600,0,0,'false','false','true','false',0,0,0,0,0,0,0,0,0,'0-0;'),
(8974,'Shadow Item: Iron Hammer','rhand','false',617,2,2,'steel','none',31,20,'blunt',4,4.00000,0,0,0,379,0,21,600,0,0,'false','false','true','false',0,0,0,0,0,0,0,0,0,'0-0;'),
(8975,'Shadow Item: Voodoo Doll','rhand','false',210,2,2,'wood','none',25,10,'etc',8,0.00000,0,0,0,379,0,28,600,0,0,'false','false','true','false',0,0,0,0,0,0,0,0,0,'0-0;'),
(8976,'Shadow Item: Flanged Mace','rhand','false',600,2,2,'steel','none',31,20,'blunt',4,4.00000,0,0,0,379,0,21,600,0,0,'false','false','true','false',0,0,0,0,0,0,0,0,0,'0-0;'),
(8977,'Shadow Item: Mage Staff','lrhand','false',350,2,2,'wood','none',30,20,'bigblunt',4,4.00000,0,0,0,325,0,28,600,0,0,'false','false','true','false',0,0,0,0,0,0,0,0,0,'0-0;'),
(8978,'Shadow Item: Sword Breaker','rhand','false',370,2,2,'steel','none',27,5,'dagger',12,-3.00000,0,0,0,433,0,21,600,0,0,'false','false','true','false',0,0,0,0,0,0,0,0,0,'0-0;'),
(8979,'Shadow Item: Viper Fang','lrhand','false',520,2,2,'steel','none',38,5,'dualfist',4,4.00000,0,0,0,325,0,21,600,0,0,'false','false','true','false',0,0,0,0,0,0,0,0,0,'0-0;'),
(8980,'Shadow Item: Composite Bow','lrhand','false',627,7,2,'steel','none',64,5,'bow',12,-3.00000,0,0,0,293,3,21,600,0,0,'false','false','true','false',0,0,0,0,0,0,0,0,0,'0-0;'),
(8981,'Shadow Item: Crucifix of Blessing','rhand','false',207,2,2,'steel','none',25,10,'etc',8,0.00000,0,0,0,379,0,28,600,0,0,'false','false','true','false',0,0,0,0,0,0,0,0,0,'0-0;'),
(8982,'Shadow Item: Two Handed Sword','lrhand','true',730,2,2,'fine_steel','d',78,10,'bigsword',8,0.00000,0,0,0,325,0,39,600,0,0,'false','false','true','false',0,0,0,0,0,0,0,0,0,'0-0;'),
(8983,'Shadow Item: Crimson Sword','rhand','true',500,2,2,'fine_steel','d',64,10,'sword',8,0.00000,0,0,0,379,0,39,600,0,0,'false','false','true','false',0,0,0,0,0,0,0,0,0,'0-0;'),
(8984,'Shadow Item: Spiked Club','rhand','true',590,2,2,'steel','d',64,20,'blunt',4,4.00000,0,0,0,379,0,39,600,0,0,'false','false','true','false',0,0,0,0,0,0,0,0,0,'0-0;'),
(8985,'Shadow Item: Staff of Magic','lrhand','true',340,2,2,'wood','d',62,20,'bigblunt',4,4.00000,0,0,0,325,0,52,600,0,0,'false','false','true','false',0,0,0,0,0,0,0,0,0,'0-0;'),
(8986,'Shadow Item: Kukuri','rhand','true',360,2,2,'fine_steel','d',56,5,'dagger',12,-3.00000,0,0,0,433,0,39,600,0,0,'false','false','true','false',0,0,0,0,0,0,0,0,0,'0-0;'),
(8987,'Shadow Item: Dagger of Mana','rhand','true',250,2,2,'fine_steel','d',45,5,'dagger',12,-3.00000,0,0,0,433,0,52,600,0,0,'false','false','true','false',0,0,0,0,0,0,0,0,0,'0-0;'),
(8988,'Shadow Item: Triple-Edged Jamadhr','lrhand','true',520,2,2,'fine_steel','d',78,5,'dualfist',4,4.00000,0,0,0,325,0,39,600,0,0,'false','false','true','false',0,0,0,0,0,0,0,0,0,'0-0;'),
(8989,'Shadow Item: Gastraphetes','lrhand','true',620,8,2,'fine_steel','d',132,5,'bow',12,-3.00000,0,0,0,293,4,39,600,0,0,'false','false','true','false',0,0,0,0,0,0,0,0,0,'0-0;'),
(8990,'Shadow Item: War Hammer','lrhand','true',700,2,2,'fine_steel','d',64,10,'pole',8,-3.00000,0,0,0,325,0,39,600,0,0,'false','false','true','false',0,0,0,0,0,0,0,0,0,'0-0;'),
(8991,'Shadow Item: Sword of Delusion','rhand','true',470,3,3,'mithril','c',139,10,'sword',8,0.00000,0,0,0,379,0,76,600,0,0,'false','false','true','false',0,0,0,0,0,0,0,0,0,'0-0;'),
(8992,'Shadow Item: Poleaxe','lrhand','true',670,3,3,'bronze','c',139,10,'pole',8,-3.00000,0,0,0,325,0,76,600,0,0,'false','false','true','false',0,0,0,0,0,0,0,0,0,'0-0;'),
(8993,'Shadow Item: Stick of Eternity','rhand','true',380,3,3,'wood','c',111,20,'blunt',4,4.00000,0,0,0,379,0,101,600,0,0,'false','false','true','false',0,0,0,0,0,0,0,0,0,'0-0;'),
(8994,'Shadow Item: Inferno Staff','lrhand','true',340,3,3,'wood','c',135,20,'bigblunt',4,4.00000,0,0,0,325,0,101,600,0,0,'false','false','true','false',0,0,0,0,0,0,0,0,0,'0-0;'),
(8995,'Shadow Item: Pa''agrian Hammer','lrhand','true',340,3,3,'blood_steel','c',135,20,'bigblunt',4,4.00000,0,0,0,325,0,101,600,0,0,'false','false','true','false',0,0,0,0,0,0,0,0,0,'0-0;'),
(8996,'Shadow Item: Dark Screamer','rhand','true',340,3,3,'fine_steel','c',122,5,'dagger',12,-3.00000,0,0,0,433,0,76,600,0,0,'false','false','true','false',0,0,0,0,0,0,0,0,0,'0-0;'),
(8997,'Shadow Item: Akat Long Bow','lrhand','true',580,9,3,'horn','c',316,5,'bow',12,-3.00000,0,0,0,227,7,84,600,0,0,'false','false','true','false',0,0,0,0,0,0,0,0,0,'0-0;'),
(8998,'Shadow Item: Pa''agrian Sword','lrhand','true',660,3,3,'steel','c',169,10,'bigsword',8,0.00000,0,0,0,325,0,76,600,0,0,'false','false','true','false',0,0,0,0,0,0,0,0,0,'0-0;'),
(8999,'Shadow Item: Fisted Blade','lrhand','true',500,3,3,'fine_steel','c',169,5,'dualfist',4,4.00000,0,0,0,325,0,76,600,0,0,'false','false','true','false',0,0,0,0,0,0,0,0,0,'0-0;'),
(9000,'Shadow Item: Stormbringer*Stormbringer','lrhand','true',780,3,3,'fine_steel','c',175,10,'dual',8,0.00000,0,0,0,325,0,78,600,0,0,'false','false','true','false',0,0,0,0,0,0,0,0,0,'0-0;'),
(9001,'Shadow Item: Great Sword','lrhand','true',650,1,1,'steel','b',213,10,'bigsword',8,0.00000,0,0,0,325,0,91,600,0,0,'false','false','true','false',0,0,0,0,0,0,0,0,0,'0-0;'),
(9002,'Shadow Item: Heavy War Axe','rhand','true',540,1,1,'fine_steel','b',175,20,'blunt',4,4.00000,0,0,0,379,0,91,600,0,0,'false','false','true','false',0,0,0,0,0,0,0,0,0,'0-0;'),
(9003,'Shadow Item: Sprite''s Staff','lrhand','true',320,1,1,'wood','b',170,20,'bigblunt',4,4.00000,0,0,0,325,0,122,600,0,0,'false','false','true','false',0,0,0,0,0,0,0,0,0,'0-0;'),
(9004,'Shadow Item: Keshanberk','rhand','true',460,1,1,'oriharukon','b',175,10,'sword',8,0.00000,0,0,0,379,0,91,600,0,0,'false','false','true','false',0,0,0,0,0,0,0,0,0,'0-0;'),
(9005,'Shadow Item: Sword of Valhalla','rhand','true',300,1,1,'oriharukon','b',140,10,'sword',8,0.00000,0,0,0,379,0,122,600,0,0,'false','false','true','false',0,0,0,0,0,0,0,0,0,'0-0;'),
(9006,'Shadow Item: Kris','rhand','true',330,1,1,'mithril','b',153,5,'dagger',12,-3.00000,0,0,0,433,0,91,600,0,0,'false','false','true','false',0,0,0,0,0,0,0,0,0,'0-0;'),
(9007,'Shadow Item: Arthro Nail','lrhand','true',480,1,1,'blood_steel','b',213,5,'dualfist',4,4.00000,0,0,0,325,0,91,600,0,0,'false','false','true','false',0,0,0,0,0,0,0,0,0,'0-0;'),
(9008,'Shadow Item: Dark Elven Long Bow','lrhand','true',580,3,1,'oriharukon','b',397,5,'bow',12,-3.00000,0,0,0,227,8,100,600,0,0,'false','false','true','false',0,0,0,0,0,0,0,0,0,'0-0;'),
(9009,'Shadow Item: Sword of Delusion*Sword of Delusion','lrhand','true',720,1,1,'fine_steel','b',213,10,'dual',8,0.00000,0,0,0,325,0,91,600,0,0,'false','false','true','false',0,0,0,0,0,0,0,0,0,'0-0;'),
(9010,'Shadow Item: Great Axe','lrhand','true',650,1,1,'damascus','b',175,10,'pole',8,-3.00000,0,0,0,325,0,91,600,0,0,'false','false','true','false',0,0,0,0,0,0,0,0,0,'0-0;'),
(9011,'Shadow Item: Tallum Blade','rhand','true',450,1,1,'adamantaite','a',213,10,'sword',8,0.00000,0,0,0,379,0,107,600,0,0,'false','false','true','false',0,0,0,0,0,0,0,0,0,'0-0;'),
(9012,'Shadow Item: Halberd','lrhand','true',640,1,1,'oriharukon','a',213,10,'pole',8,-3.00000,0,0,0,325,0,107,600,0,0,'false','false','true','false',0,0,0,0,0,0,0,0,0,'0-0;'),
(9013,'Shadow Item: Dasparion''s Staff','lrhand','true',310,1,1,'adamantaite','a',207,20,'bigblunt',4,4.00000,0,0,0,325,0,143,600,0,0,'false','false','true','false',0,0,0,0,0,0,0,0,0,'0-0;'),
(9014,'Shadow Item: Bloody Orchid','rhand','true',320,1,1,'blood_steel','a',186,5,'dagger',12,-3.00000,0,0,0,433,0,107,600,0,0,'false','false','true','false',0,0,0,0,0,0,0,0,0,'0-0;'),
(9015,'Shadow Item: Blood Tornado','lrhand','true',460,1,1,'blood_steel','a',259,5,'dualfist',4,4.00000,0,0,0,325,0,107,600,0,0,'false','false','true','false',0,0,0,0,0,0,0,0,0,'0-0;'),
(9016,'Shadow Item: Carnage Bow','lrhand','true',560,2,1,'damascus','a',440,5,'bow',12,-3.00000,0,0,0,293,9,107,600,0,0,'false','false','true','false',0,0,0,0,0,0,0,0,0,'0-0;'),
(9017,'Shadow Item: Keshanberk*Keshanberk','lrhand','true',700,1,1,'fine_steel','a',259,10,'dual',8,0.00000,0,0,0,325,0,107,600,0,0,'false','false','true','false',0,0,0,0,0,0,0,0,0,'0-0;'),
(9018,'Shadow Item: Meteor Shower','rhand','true',540,1,1,'fine_steel','a',213,20,'blunt',4,4.00000,0,0,0,379,0,107,600,0,0,'false','false','true','false',0,0,0,0,0,0,0,0,0,'0-0;'),
(9019,'Shadow Item: Inferno Master','lrhand','true',640,1,1,'fine_steel','a',259,10,'bigsword',8,0.00000,0,0,0,325,0,107,600,0,0,'false','false','true','false',0,0,0,0,0,0,0,0,0,'0-0;'),
(9020,'Shadow Item: Keshanberk*Damascus','lrhand','true',693,1,1,'fine_steel','a',275,10,'dual',8,0.00000,0,0,0,325,0,112,600,0,0,'false','false','true','false',0,0,0,0,0,0,0,0,0,'0-0;'),
(9021,'Shadow Item: Dragon Slayer','lrhand','true',613,1,1,'bone','a',282,10,'bigsword',8,0.00000,0,0,0,325,0,114,600,0,0,'false','false','true','false',0,0,0,0,0,0,0,0,0,'0-0;'),
(9022,'Shadow Item: Sword of Miracles','rhand','true',280,1,1,'adamantaite','a',186,10,'sword',8,0.00000,0,0,0,379,0,152,600,0,0,'false','false','true','false',0,0,0,0,0,0,0,0,0,'0-0;'),
(9023,'Shadow Item: Elysian','rhand','true',527,1,1,'oriharukon','a',232,20,'blunt',4,4.00000,0,0,0,379,0,114,600,0,0,'false','false','true','false',0,0,0,0,0,0,0,0,0,'0-0;'),
(9024,'Shadow Item: Branch of the Mother Tree','lrhand','true',300,1,1,'wood','a',226,20,'bigblunt',4,4.00000,0,0,0,325,0,152,600,0,0,'false','false','true','false',0,0,0,0,0,0,0,0,0,'0-0;'),
(9025,'Shadow Item: Soul Separator','rhand','true',317,1,1,'oriharukon','a',203,5,'dagger',12,-3.00000,0,0,0,433,0,114,600,0,0,'false','false','true','false',0,0,0,0,0,0,0,0,0,'0-0;'),
(9026,'Shadow Item: Dragon Grinder','lrhand','true',450,1,1,'adamantaite','a',282,5,'dualfist',4,4.00000,0,0,0,325,0,114,600,0,0,'false','false','true','false',0,0,0,0,0,0,0,0,0,'0-0;'),
(9027,'Shadow Item: Soul Bow','lrhand','true',553,2,1,'oriharukon','a',528,5,'bow',12,-3.00000,0,0,0,227,10,125,600,0,0,'false','false','true','false',0,0,0,0,0,0,0,0,0,'0-0;'),
(9028,'Shadow Item: Tallum Glaive','lrhand','true',613,1,1,'chrysolite','a',232,10,'pole',8,-3.00000,0,0,0,325,0,114,600,0,0,'false','false','true','false',0,0,0,0,0,0,0,0,0,'0-0;'),
(9029,'Shadow Item: Dark Legion','rhand','true',440,1,1,'fine_steel','a',232,10,'sword',8,0.00000,0,0,0,379,0,114,600,0,0,'false','false','true','false',0,0,0,0,0,0,0,0,0,'0-0;'),
(9036,'Shadow Item: Bone Shield','lhand','false',460,0,0,'bone','none',0,0,'none',0,0.00000,-8,90,20,0,0,0,600,0,0,'false','false','true','false',0,0,0,0,0,0,0,0,0,'0-0;'),
(9044,'Shadow Item: Hoplon','lhand','true',447,0,0,'fine_steel','d',0,0,'none',0,0.00000,-8,128,20,0,0,0,600,0,0,'false','false','true','false',0,0,0,0,0,0,0,0,0,'0-0;'),
(9056,'Shadow Item: Composite Shield','lhand','true',410,0,0,'fine_steel','c',0,0,'none',0,0.00000,-8,190,20,0,0,0,600,0,0,'false','false','true','false',0,0,0,0,0,0,0,0,0,'0-0;'),
(9070,'Shadow Item: Zubei''s Shield','lhand','true',403,0,0,'mithril','b',0,0,'none',0,0.00000,-8,216,20,0,0,0,600,0,0,'false','false','true','false',0,0,0,0,0,0,0,0,0,'0-0;'),
(9084,'Shadow Item: Dark Crystal Shield','lhand','true',397,0,0,'crystal','a',0,0,'none',0,0.00000,-8,243,20,0,0,0,600,0,0,'false','false','true','false',0,0,0,0,0,0,0,0,0,'0-0;'),
(9129,'Shadow Item: Shield of Nightmare','lhand','true',400,0,0,'leather','a',0,0,'none',0,0.00000,-8,256,20,0,0,0,600,0,0,'false','false','true','false',0,0,0,0,0,0,0,0,0,'0-0;'),
(9136,'Sword of Valakas (1-Handed)','rhand','true',1380,3,3,'oriharukon','c',156,10,'sword',8,0.00000,0,0,0,379,0,83,-1,0,0,'true','true','true','true',0,0,0,0,0,0,0,0,0,'0-0;'),
(9137,'Sword of Valakas (2-Handed)','lrhand','true',2180,2,2,'fine_steel','d',78,10,'bigsword',8,0.00000,0,0,0,325,0,39,-1,0,0,'true','true','true','true',0,0,0,0,0,0,0,0,0,'0-0;'),
(9140,'Salvation Bow','lrhand','false',900,1,1,'wood','none',1,1,'bow',12,-3.00000,0,0,0,293,1,1,-1,0,0,'false','false','false','false',0,0,0,0,0,0,0,0,0,'0-0;'),
(9141,'Redemption Bow - Event Use','lrhand','false',300,1,1,'wood','none',1,1,'bow',12,-3.00000,0,0,0,293,1,1,60,0,0,'false','false','false','false',0,0,0,0,0,0,0,0,0,'0-0;'),
(9209,'Rapier','rhand','true',1520,2,2,'wood','d',36,0,'rapier',10,-1.00000,0,0,0,406,0,26,-1,0,0,'true','true','true','true',0,0,0,0,0,0,0,0,0,'0-0;'),
(9210,'Talwar','lrhand','true',2100,2,2,'wood','d',43,0,'ancient',6,2.00000,0,0,0,350,0,26,-1,0,0,'true','true','true','true',0,0,0,0,0,0,0,0,5285,'0-0;'),
(9211,'Talwar','lrhand','true',2100,2,2,'wood','d',43,0,'ancient',6,2.00000,0,0,0,350,0,26,-1,0,0,'true','true','true','true',0,0,0,0,0,0,0,0,7880,'0-0;'),
(9212,'Field Gun','lrhand','true',1870,3,2,'wood','d',51,0,'crossbow',10,-1.00000,0,0,0,303,1,26,-1,0,0,'true','true','true','true',0,0,0,0,0,0,0,0,274,'0-0;'),
(9213,'Fleuret','rhand','true',1500,2,2,'wood','d',46,0,'rapier',10,-1.00000,0,0,0,406,0,32,-1,0,0,'true','true','true','true',0,0,0,0,0,0,0,0,69,'0-0;'),
(9214,'Fleuret','rhand','true',1500,2,2,'wood','d',46,0,'rapier',10,-1.00000,0,0,0,406,0,32,-1,0,0,'true','true','true','true',0,0,0,0,0,0,0,0,125,'0-0;'),
(9215,'Fleuret','rhand','true',1500,2,2,'wood','d',46,0,'rapier',10,-1.00000,0,0,0,406,0,32,-1,0,0,'true','true','true','true',0,0,0,0,0,0,0,0,126,'0-0;'),
(9216,'Military Talwar','lrhand','true',2080,2,2,'wood','d',55,0,'ancient',6,2.00000,0,0,0,350,0,32,-1,0,0,'true','true','true','true',0,0,0,0,0,0,0,0,123,'0-0;'),
(9217,'Hand Crossbow','lrhand','true',1850,4,2,'wood','d',64,0,'crossbow',10,-1.00000,0,0,0,303,1,32,-1,0,0,'true','true','true','true',0,0,0,0,0,0,0,0,275,'0-0;'),
(9218,'Estoc','rhand','true',1470,2,2,'wood','d',58,0,'rapier',10,-1.00000,0,0,0,406,0,39,-1,0,0,'true','true','true','true',0,0,0,0,0,0,0,0,127,'0-0;'),
(9219,'Estoc','rhand','true',1470,2,2,'wood','d',58,0,'rapier',10,-1.00000,0,0,0,406,0,39,-1,0,0,'true','true','true','true',0,0,0,0,0,0,0,0,130,'0-0;'),
(9220,'Field Sword','lrhand','true',2060,2,2,'wood','d',69,0,'ancient',6,2.00000,0,0,0,350,0,39,-1,0,0,'true','true','true','true',0,0,0,0,0,0,0,0,124,'0-0;'),
(9221,'Crossbow','lrhand','true',1840,4,2,'wood','d',81,0,'crossbow',10,-1.00000,0,0,0,303,1,39,-1,0,0,'true','true','true','true',0,0,0,0,0,0,0,0,278,'0-0;'),
(9222,'wrong__','rhand','true',1450,3,3,'wood','d',72,0,'rapier',10,-1.00000,0,0,0,406,0,47,-1,0,0,'true','true','true','true',0,0,0,0,0,0,0,0,129,'0-0;'),
(9223,'Katzbalger','lrhand','true',2020,3,3,'wood','d',86,0,'ancient',6,2.00000,0,0,0,350,0,47,-1,0,0,'true','true','true','true',0,0,0,0,0,0,0,0,7881,'0-0;'),
(9224,'Arm Breaker','lrhand','true',1820,6,3,'wood','d',100,0,'crossbow',10,-1.00000,0,0,0,303,1,47,-1,0,0,'true','true','true','true',0,0,0,0,0,0,0,0,279,'0-0;'),
(9225,'Grand wrong__','rhand','true',1440,3,3,'wood','d',83,0,'rapier',10,-1.00000,0,0,0,406,0,54,-1,0,0,'true','true','true','true',0,0,0,0,0,0,0,0,2499,'0-0;'),
(9226,'General''s Katzbalger','lrhand','true',2010,3,3,'wood','d',100,0,'ancient',6,2.00000,0,0,0,350,0,54,-1,0,0,'true','true','true','true',0,0,0,0,0,0,0,0,70,'0-0;'),
(9227,'Cranequin','lrhand','true',1810,6,3,'wood','d',117,0,'crossbow',10,-1.00000,0,0,0,303,1,54,-1,0,0,'true','true','true','true',0,0,0,0,0,0,0,0,280,'0-0;'),
(9228,'Soldat Estoc','rhand','true',1430,3,3,'wood','c',97,0,'rapier',10,-1.00000,0,0,0,406,0,61,-1,0,0,'true','true','true','true',0,0,0,0,0,0,0,0,72,'0-0;'),
(9229,'Soldat Estoc - Critical Anger','rhand','true',1430,3,3,'wood','c',97,0,'rapier',10,-1.00000,0,0,0,406,0,61,-1,0,0,'true','true','true','true',0,0,0,0,0,0,0,0,4681,'3026-1;'),
(9230,'Soldat Estoc - Focus','rhand','true',1430,3,3,'wood','c',97,0,'rapier',10,-1.00000,0,0,0,406,0,61,-1,0,0,'true','true','true','true',0,0,0,0,0,0,0,0,4682,'3010-1;'),
(9231,'Soldat Estoc - Light','rhand','true',429,3,3,'wood','c',97,0,'rapier',10,-1.00000,0,0,0,406,0,61,-1,0,0,'true','true','true','true',0,0,0,0,0,0,0,0,4683,'3498-1;'),
(9232,'Schlager','lrhand','true',1980,2,2,'wood','c',116,0,'ancient',6,2.00000,0,0,0,350,0,61,-1,0,0,'true','true','true','true',0,0,0,0,0,0,0,0,71,'0-0;'),
(9233,'Schlager - Critical Damage','lrhand','true',1980,2,2,'wood','c',116,0,'ancient',6,2.00000,0,0,0,350,0,61,-1,0,0,'true','true','true','true',0,0,0,0,0,0,0,0,4711,'3023-1;'),
(9234,'Schlager - Focus','lrhand','true',1980,2,2,'wood','c',116,0,'ancient',6,2.00000,0,0,0,350,0,61,-1,0,0,'true','true','true','true',0,0,0,0,0,0,0,0,4712,'3044-15;'),
(9235,'Schlager - Light','lrhand','true',594,2,2,'wood','c',116,0,'ancient',6,2.00000,0,0,0,350,0,61,-1,0,0,'true','true','true','true',0,0,0,0,0,0,0,0,4713,'3498-1;'),
(9236,'Arbalest','lrhand','true',1790,5,2,'wood','c',135,0,'crossbow',10,-1.00000,0,0,0,303,1,61,-1,0,0,'true','true','true','true',0,0,0,0,0,0,0,0,281,'0-0;'),
(9237,'Arbalest - Guidance','lrhand','true',1790,5,2,'wood','c',135,0,'crossbow',10,-1.00000,0,0,0,303,1,61,-1,0,0,'true','true','true','true',0,0,0,0,0,0,0,0,4810,'3008-1;'),
(9238,'Arbalest - Evasion','lrhand','true',1790,5,2,'wood','c',135,0,'crossbow',10,-1.00000,0,0,0,303,1,61,-1,0,0,'true','true','true','true',0,0,0,0,0,0,0,0,4811,'3009-1;'),
(9239,'Arbalest - Quick Recovery','lrhand','true',1790,5,2,'wood','c',135,0,'crossbow',10,-1.00000,0,0,0,303,3,61,-1,0,0,'true','true','true','true',0,0,0,0,0,0,0,0,4812,'0-0;'),
(9240,'Chevalier Rapier','lrhand','true',1420,3,3,'wood','c',111,0,'rapier',10,-1.00000,0,0,0,406,0,68,-1,0,0,'true','true','true','true',0,0,0,0,0,0,0,0,73,'0-0;'),
(9241,'Chevalier Rapier - Guidance','lrhand','true',1420,3,3,'wood','c',111,0,'rapier',10,-1.00000,0,0,0,406,0,68,-1,0,0,'true','true','true','true',0,0,0,0,0,0,0,0,4684,'3007-2;'),
(9242,'Chevalier Rapier - Back Blow','lrhand','true',1420,3,3,'wood','c',111,0,'rapier',10,-1.00000,0,0,0,406,0,68,-1,0,0,'true','true','true','true',0,0,0,0,0,0,0,0,4685,'3018-2;'),
(9243,'Chevalier Rapier - Rsk. Evasion','lrhand','true',1420,3,3,'wood','c',111,0,'rapier',10,-1.00000,0,0,0,406,0,68,-1,0,0,'true','true','true','true',0,0,0,0,0,0,0,0,4686,'3028-2;'),
(9244,'Chevalier Rapier','lrhand','true',1420,3,3,'wood','c',111,0,'rapier',10,-1.00000,0,0,0,406,0,68,-1,0,0,'true','true','true','true',0,0,0,0,0,0,0,0,74,'0-0;'),
(9245,'Chevalier Rapier - Focus','lrhand','true',1420,3,3,'wood','c',111,0,'rapier',10,-1.00000,0,0,0,406,0,68,-1,0,0,'true','true','true','true',0,0,0,0,0,0,0,0,4687,'3010-2;'),
(9246,'Chevalier Rapier - Critical Damage','lrhand','true',1420,3,3,'wood','c',111,0,'rapier',10,-1.00000,0,0,0,406,0,68,-1,0,0,'true','true','true','true',0,0,0,0,0,0,0,0,4688,'3023-2;'),
(9247,'Chevalier Rapier - Haste','lrhand','true',1420,3,3,'wood','c',111,0,'rapier',10,-1.00000,0,0,0,406,0,68,-1,0,0,'true','true','true','true',0,0,0,0,0,0,0,0,4689,'3037-2;'),
(9248,'Chevalier Rapier','lrhand','true',1420,3,3,'wood','c',111,0,'rapier',10,-1.00000,0,0,0,406,0,68,-1,0,0,'true','true','true','true',0,0,0,0,0,0,0,0,131,'0-0;'),
(9249,'Chevalier Rapier - Critical Damage','lrhand','true',1420,3,3,'wood','c',111,0,'rapier',10,-1.00000,0,0,0,406,0,68,-1,0,0,'true','true','true','true',0,0,0,0,0,0,0,0,4690,'3023-2;'),
(9250,'Chevalier Rapier - Critical Poison','lrhand','true',1420,3,3,'wood','c',111,0,'rapier',10,-1.00000,0,0,0,406,0,68,-1,0,0,'true','true','true','true',0,0,0,0,0,3024,4,15,4691,'0-0;'),
(9251,'Chevalier Rapier - Haste','lrhand','true',1420,3,3,'wood','c',111,0,'rapier',10,-1.00000,0,0,0,406,0,68,-1,0,0,'true','true','true','true',0,0,0,0,0,0,0,0,4692,'3037-2;'),
(9252,'Chevalier Rapier','lrhand','true',1420,3,3,'wood','c',111,0,'rapier',10,-1.00000,0,0,0,406,0,68,-1,0,0,'true','true','true','true',0,0,0,0,0,0,0,0,133,'0-0;'),
(9253,'Chevalier Rapier - Focus','lrhand','true',1420,3,3,'wood','c',111,0,'rapier',10,-1.00000,0,0,0,406,0,68,-1,0,0,'true','true','true','true',0,0,0,0,0,0,0,0,4693,'3010-2;'),
(9254,'Chevalier Rapier - Critical Drain','lrhand','true',1420,3,3,'wood','c',111,0,'rapier',10,-1.00000,0,0,0,406,0,68,-1,0,0,'true','true','true','true',0,0,0,0,0,3022,2,15,4694,'0-0;'),
(9255,'Chevalier Rapier - Critical Poison','lrhand','true',1420,3,3,'wood','c',111,0,'rapier',10,-1.00000,0,0,0,406,0,68,-1,0,0,'true','true','true','true',0,0,0,0,0,3024,4,15,4695,'0-0;'),
(9256,'Ballista','lrhand','true',1770,5,2,'wood','c',155,0,'crossbow',10,-1.00000,0,0,0,303,3,68,-1,0,0,'true','true','true','true',0,0,0,0,0,0,0,0,282,'0-0;'),
(9257,'Ballista - Guidance','lrhand','true',1770,5,2,'wood','c',155,0,'crossbow',10,-1.00000,0,0,0,303,3,68,-1,0,0,'true','true','true','true',0,0,0,0,0,0,0,0,4813,'3008-2;'),
(9258,'Ballista - Miser','lrhand','true',1770,5,2,'wood','c',155,0,'crossbow',10,-1.00000,0,0,0,303,5,68,-1,0,0,'true','true','true','true',0,0,0,0,0,0,0,0,4814,'0-0;'),
(9259,'Ballista - Quick Recovery','lrhand','true',1770,5,2,'wood','c',155,0,'crossbow',10,-1.00000,0,0,0,303,7,68,-1,0,0,'true','true','true','true',0,0,0,0,0,0,0,0,4815,'0-0;'),
(9260,'Ballista','lrhand','true',1770,5,2,'wood','c',155,0,'crossbow',10,-1.00000,0,0,0,303,8,68,-1,0,0,'true','true','true','true',0,0,0,0,0,0,0,0,285,'0-0;'),
(9261,'Ballista - Evasion','lrhand','true',1770,5,2,'wood','c',155,0,'crossbow',10,-1.00000,0,0,0,303,8,68,-1,0,0,'true','true','true','true',0,0,0,0,0,0,0,0,4816,'3009-2;'),
(9262,'Ballista - Miser','lrhand','true',1770,5,2,'wood','c',155,0,'crossbow',10,-1.00000,0,0,0,303,8,68,-1,0,0,'true','true','true','true',0,0,0,0,0,0,0,0,4817,'0-0;'),
(9263,'Ballista - Cheap Shot','lrhand','true',1770,5,2,'wood','c',155,0,'crossbow',10,-1.00000,0,0,0,303,8,68,-1,0,0,'true','true','true','true',0,0,0,0,0,0,0,0,4818,'0-0;'),
(9264,'Blinzlasher','rhand','true',1400,3,3,'wood','c',126,0,'rapier',10,-1.00000,0,0,0,406,0,76,-1,0,0,'true','true','true','true',0,0,0,0,0,0,0,0,75,'0-0;'),
(9265,'Blinzlasher - Guidance','rhand','true',1400,3,3,'wood','c',126,0,'rapier',10,-1.00000,0,0,0,406,0,76,-1,0,0,'true','true','true','true',0,0,0,0,0,0,0,0,4696,'3007-3;'),
(9266,'Blinzlasher - Focus','rhand','true',1400,3,3,'wood','c',126,0,'rapier',10,-1.00000,0,0,0,406,0,76,-1,0,0,'true','true','true','true',0,0,0,0,0,0,0,0,4697,'3010-3;'),
(9267,'Blinzlasher - Critical Damage','rhand','true',1400,3,3,'wood','c',126,0,'rapier',10,-1.00000,0,0,0,406,0,76,-1,0,0,'true','true','true','true',0,0,0,0,0,0,0,0,4698,'3023-3;'),
(9268,'Blinzlasher','rhand','true',1400,3,3,'wood','c',126,0,'rapier',10,-1.00000,0,0,0,406,0,76,-1,0,0,'true','true','true','true',0,0,0,0,0,0,0,0,76,'0-0;'),
(9269,'Blinzlasher - Focus','rhand','true',1400,3,3,'wood','c',126,0,'rapier',10,-1.00000,0,0,0,406,0,76,-1,0,0,'true','true','true','true',0,0,0,0,0,0,0,0,4699,'3010-3;'),
(9270,'Blinzlasher - Health','rhand','true',1400,3,3,'wood','c',126,0,'rapier',10,-1.00000,0,0,0,406,0,76,-1,0,0,'true','true','true','true',0,0,0,0,0,0,0,0,4700,'3013-1;'),
(9271,'Blinzlasher - Rsk. Haste','rhand','true',1400,3,3,'wood','c',126,0,'rapier',10,-1.00000,0,0,0,406,0,76,-1,0,0,'true','true','true','true',0,0,0,0,0,0,0,0,4701,'3032-3;'),
(9272,'Blinzlasher','rhand','true',1400,3,3,'wood','c',126,0,'rapier',10,-1.00000,0,0,0,406,0,76,-1,0,0,'true','true','true','true',0,0,0,0,0,0,0,0,77,'0-0;'),
(9273,'Blinzlasher - Focus','rhand','true',1400,3,3,'wood','c',126,0,'rapier',10,-1.00000,0,0,0,406,0,76,-1,0,0,'true','true','true','true',0,0,0,0,0,0,0,0,4702,'3010-3;'),
(9274,'Blinzlasher - Critical Damage','rhand','true',1400,3,3,'wood','c',126,0,'rapier',10,-1.00000,0,0,0,406,0,76,-1,0,0,'true','true','true','true',0,0,0,0,0,0,0,0,4703,'3023-3;'),
(9275,'Blinzlasheri - Haste','rhand','true',1400,3,3,'wood','c',126,0,'rapier',10,-1.00000,0,0,0,406,0,76,-1,0,0,'true','true','true','true',0,0,0,0,0,0,0,0,4704,'3037-3;'),
(9276,'Blinzlasher','rhand','true',1400,3,3,'wood','c',126,0,'rapier',10,-1.00000,0,0,0,406,0,76,-1,0,0,'true','true','true','true',0,0,0,0,0,0,0,0,134,'0-0;'),
(9277,'Blinzlasher - Health','rhand','true',1400,3,3,'wood','c',126,0,'rapier',10,-1.00000,0,0,0,406,0,76,-1,0,0,'true','true','true','true',0,0,0,0,0,0,0,0,4705,'3013-1;'),
(9278,'Blinzlasher - Focus','rhand','true',1400,3,3,'wood','c',126,0,'rapier',10,-1.00000,0,0,0,406,0,76,-1,0,0,'true','true','true','true',0,0,0,0,0,0,0,0,4706,'3010-3;'),
(9279,'Blinzlasher - Light','rhand','true',420,3,3,'wood','c',126,0,'rapier',10,-1.00000,0,0,0,406,0,76,-1,0,0,'true','true','true','true',0,0,0,0,0,0,0,0,4707,'3498-1;'),
(9280,'Blinzlasher','rhand','true',1400,3,3,'wood','c',126,0,'rapier',10,-1.00000,0,0,0,406,0,76,-1,0,0,'true','true','true','true',0,0,0,0,0,0,0,0,132,'0-0;'),
(9281,'Blinzlasher - Guidance','rhand','true',1400,3,3,'wood','c',126,0,'rapier',10,-1.00000,0,0,0,406,0,76,-1,0,0,'true','true','true','true',0,0,0,0,0,0,0,0,6307,'3573-1;'),
(9282,'Blinzlasher - Critical Drain','rhand','true',1400,3,3,'wood','c',126,0,'rapier',10,-1.00000,0,0,0,406,0,76,-1,0,0,'true','true','true','true',0,0,0,0,0,3022,2,10,6308,'0-0;'),
(9283,'Blinzlasher - Health','rhand','true',1400,3,3,'wood','c',126,0,'rapier',10,-1.00000,0,0,0,406,0,76,-1,0,0,'true','true','true','true',0,0,0,0,0,0,0,0,6309,'3013-1;'),
(9284,'Immortal Edge','lrhand','true',1980,3,3,'wood','c',151,0,'ancient',6,2.00000,0,0,0,350,0,76,-1,0,0,'true','true','true','true',0,0,0,0,0,0,0,0,7882,'0-0;'),
(9285,'Immortal Edge - Focus','lrhand','true',1980,3,3,'wood','c',151,0,'ancient',6,2.00000,0,0,0,350,0,76,-1,0,0,'true','true','true','true',0,0,0,0,0,0,0,0,8102,'3044-10;'),
(9286,'Immortal Edge - Health','lrhand','true',1980,3,3,'wood','c',151,0,'ancient',6,2.00000,0,0,0,350,0,76,-1,0,0,'true','true','true','true',0,0,0,0,0,0,0,0,8103,'0-0;'),
(9287,'Immortal Edge - Critical Drain','lrhand','true',1980,3,3,'wood','c',151,0,'ancient',6,2.00000,0,0,0,350,0,76,-1,0,0,'true','true','true','true',0,0,0,0,0,0,0,0,8104,'0-0;'),
(9288,'Tathlum','lrhand','true',1760,5,3,'wood','c',176,0,'crossbow',10,-1.00000,0,0,0,303,8,76,-1,0,0,'true','true','true','true',0,0,0,0,0,0,0,0,283,'0-0;'),
(9289,'Tathlum - Guidance','lrhand','true',1760,5,3,'wood','c',176,0,'crossbow',10,-1.00000,0,0,0,303,8,76,-1,0,0,'true','true','true','true',0,0,0,0,0,0,0,0,4819,'3008-3;'),
(9290,'Tathlum - Evasion','lrhand','true',1760,5,3,'wood','c',176,0,'crossbow',10,-1.00000,0,0,0,303,8,76,-1,0,0,'true','true','true','true',0,0,0,0,0,0,0,0,4820,'3009-3;'),
(9291,'Tathlum - Miser','lrhand','true',1760,5,3,'wood','c',176,0,'crossbow',10,-1.00000,0,0,0,303,8,76,-1,0,0,'true','true','true','true',0,0,0,0,0,0,0,0,4821,'0-0;'),
(9292,'Admiral''s Estoc','rhand','true',1380,3,3,'wood','c',141,0,'rapier',10,-1.00000,0,0,0,406,0,83,-1,0,0,'true','true','true','true',0,0,0,0,0,0,0,0,135,'0-0;'),
(9293,'Admiral''s Estoc - Focus','rhand','true',1380,3,3,'wood','c',141,0,'rapier',10,-1.00000,0,0,0,406,0,83,-1,0,0,'true','true','true','true',0,0,0,0,0,0,0,0,4708,'3010-4;'),
(9294,'Admiral''s Estoc - Critical Damage','rhand','true',1380,3,3,'wood','c',141,0,'rapier',10,-1.00000,0,0,0,406,0,83,-1,0,0,'true','true','true','true',0,0,0,0,0,0,0,0,4709,'3023-4;'),
(9295,'Admiral''s Estoc - Haste','rhand','true',1380,3,3,'wood','c',141,0,'rapier',10,-1.00000,0,0,0,406,0,83,-1,0,0,'true','true','true','true',0,0,0,0,0,0,0,0,4710,'3037-4;'),
(9296,'Saber Tooth','lrhand','true',1950,3,3,'wood','c',169,0,'ancient',6,2.00000,0,0,0,350,0,83,-1,0,0,'true','true','true','true',0,0,0,0,0,0,0,0,5286,'0-0;'),
(9297,'Saber Tooth - Focus','lrhand','true',1950,3,3,'wood','c',169,0,'ancient',6,2.00000,0,0,0,350,0,83,-1,0,0,'true','true','true','true',0,0,0,0,0,0,0,0,6347,'3044-8;'),
(9298,'Saber Tooth - Critical Damage','lrhand','true',1950,3,3,'wood','c',169,0,'ancient',6,2.00000,0,0,0,350,0,83,-1,0,0,'true','true','true','true',0,0,0,0,0,0,0,0,6348,'0-0;'),
(9299,'Saber Tooth - Haste','lrhand','true',1950,3,3,'wood','c',169,0,'ancient',6,2.00000,0,0,0,350,0,83,-1,0,0,'true','true','true','true',0,0,0,0,0,0,0,0,6349,'0-0;'),
(9300,'Sharpshooter','lrhand','true',1740,6,3,'wood','c',198,0,'crossbow',10,-1.00000,0,0,0,303,8,83,-1,0,0,'true','true','true','true',0,0,0,0,0,0,0,0,286,'0-0;'),
(9301,'Sharpshooter - Guidance','lrhand','true',1740,6,3,'wood','c',198,0,'crossbow',10,-1.00000,0,0,0,303,8,83,-1,0,0,'true','true','true','true',0,0,0,0,0,0,0,0,4822,'3008-4;'),
(9302,'Sharpshooter - Miser','lrhand','true',1740,6,3,'wood','c',198,0,'crossbow',10,-1.00000,0,0,0,303,8,83,-1,0,0,'true','true','true','true',0,0,0,0,0,0,0,0,4823,'0-0;'),
(9303,'Sharpshooter - Cheap Shot','lrhand','true',1740,6,3,'wood','c',198,0,'crossbow',10,-1.00000,0,0,0,303,8,83,-1,0,0,'true','true','true','true',0,0,0,0,0,0,0,0,4824,'0-0;'),
(9304,'Military Fleuret','rhand','true',1370,1,1,'wood','b',159,0,'rapier',10,-1.00000,0,0,0,406,0,91,-1,0,0,'true','true','true','true',0,0,0,0,0,0,0,0,142,'0-0;'),
(9305,'Military Fleuret - Guidance','rhand','true',1370,1,1,'wood','b',159,0,'rapier',10,-1.00000,0,0,0,406,0,91,-1,0,0,'true','true','true','true',0,0,0,0,0,0,0,0,4714,'3007-5;'),
(9306,'Military Fleuret - Focus','rhand','true',1370,1,1,'wood','b',159,0,'rapier',10,-1.00000,0,0,0,406,0,91,-1,0,0,'true','true','true','true',0,0,0,0,0,0,0,0,4715,'3010-5;'),
(9307,'Military Fleuret - Back Blow','rhand','true',1370,1,1,'wood','b',159,0,'rapier',10,-1.00000,0,0,0,406,0,91,-1,0,0,'true','true','true','true',0,0,0,0,0,0,0,0,4716,'3018-5;'),
(9308,'Innominate Victory','lrhand','true',1930,1,1,'wood','b',190,0,'ancient',6,2.00000,0,0,0,350,0,91,-1,0,0,'true','true','true','true',0,0,0,0,0,0,0,0,78,'0-0;'),
(9309,'Innominate Victory - Health','lrhand','true',1930,1,1,'wood','b',190,0,'ancient',6,2.00000,0,0,0,350,0,91,-1,0,0,'true','true','true','true',0,0,0,0,0,0,0,0,4723,'3013-1;'),
(9310,'Innominate Victory - Critical Damage','lrhand','true',1930,1,1,'wood','b',190,0,'ancient',6,2.00000,0,0,0,350,0,91,-1,0,0,'true','true','true','true',0,0,0,0,0,0,0,0,4724,'3023-5;'),
(9311,'Innominate Victory - Focus','lrhand','true',1930,1,1,'wood','b',190,0,'ancient',6,2.00000,0,0,0,350,0,91,-1,0,0,'true','true','true','true',0,0,0,0,0,0,0,0,4725,'3044-6;'),
(9312,'Peacemaker','lrhand','true',1720,2,1,'wood','b',221,0,'crossbow',10,-1.00000,0,0,0,303,9,91,-1,0,0,'true','true','true','true',0,0,0,0,0,0,0,0,284,'0-0;'),
(9313,'Peacemaker - Evasion','lrhand','true',1720,2,1,'wood','b',221,0,'crossbow',10,-1.00000,0,0,0,303,9,91,-1,0,0,'true','true','true','true',0,0,0,0,0,0,0,0,4825,'3009-5;'),
(9314,'Peacemaker - Critical Bleed','lrhand','true',1720,2,1,'wood','b',221,0,'crossbow',10,-1.00000,0,0,0,303,9,91,-1,0,0,'true','true','true','true',0,0,0,0,0,3021,4,30,4826,'0-0;'),
(9315,'Peacemaker - Miser','lrhand','true',1720,2,1,'wood','b',221,0,'crossbow',10,-1.00000,0,0,0,303,9,91,-1,0,0,'true','true','true','true',0,0,0,0,0,0,0,0,4827,'0-0;'),
(9316,'Colichemarde','rhand','true',1350,1,1,'wood','b',176,0,'rapier',10,-1.00000,0,0,0,406,0,99,-1,0,0,'true','true','true','true',0,0,0,0,0,0,0,0,79,'0-0;'),
(9317,'Colichemarde - Focus','rhand','true',1350,1,1,'wood','b',176,0,'rapier',10,-1.00000,0,0,0,406,0,99,-1,0,0,'true','true','true','true',0,0,0,0,0,0,0,0,4717,'3010-6;'),
(9318,'Colichemarde - Critical Damage','rhand','true',1350,1,1,'wood','b',176,0,'rapier',10,-1.00000,0,0,0,406,0,99,-1,0,0,'true','true','true','true',0,0,0,0,0,0,0,0,4718,'3023-3;'),
(9319,'Colichemarde - Haste','rhand','true',1350,1,1,'wood','b',176,0,'rapier',10,-1.00000,0,0,0,406,0,99,-1,0,0,'true','true','true','true',0,0,0,0,0,0,0,0,4719,'3037-6;'),
(9320,'Dismantler','lrhand','true',1930,1,1,'wood','b',210,0,'ancient',6,2.00000,0,0,0,350,0,99,-1,0,0,'true','true','true','true',0,0,0,0,0,0,0,0,7883,'0-0;'),
(9321,'Dismantler - Critical Drain','lrhand','true',1930,1,1,'wood','b',210,0,'ancient',6,2.00000,0,0,0,350,0,99,-1,0,0,'true','true','true','true',0,0,0,0,0,0,0,0,8105,'0-0;'),
(9322,'Dismantler - Health','lrhand','true',1930,1,1,'wood','b',210,0,'ancient',6,2.00000,0,0,0,350,0,99,-1,0,0,'true','true','true','true',0,0,0,0,0,0,0,0,8106,'0-0;'),
(9323,'Dismantler - Critical Bleed','lrhand','true',1930,1,1,'wood','b',210,0,'ancient',6,2.00000,0,0,0,350,0,99,-1,0,0,'true','true','true','true',0,0,0,0,0,0,0,0,8107,'0-0;'),
(9324,'Hell Hound','lrhand','true',1700,2,1,'wood','b',245,0,'crossbow',10,-1.00000,0,0,0,303,9,99,-1,0,0,'true','true','true','true',0,0,0,0,0,0,0,0,287,'0-0;'),
(9325,'Hell Hound - Guidance','lrhand','true',1700,2,1,'wood','b',245,0,'crossbow',10,-1.00000,0,0,0,303,9,99,-1,0,0,'true','true','true','true',0,0,0,0,0,0,0,0,4828,'3008-6;'),
(9326,'Hell Hound - Quick Recovery','lrhand','true',1700,2,1,'wood','b',245,0,'crossbow',10,-1.00000,0,0,0,303,9,99,-1,0,0,'true','true','true','true',0,0,0,0,0,0,0,0,4829,'0-0;'),
(9327,'Hell Hound - Cheap Shot','lrhand','true',1700,2,1,'wood','b',245,0,'crossbow',10,-1.00000,0,0,0,303,9,99,-1,0,0,'true','true','true','true',0,0,0,0,0,0,0,0,4830,'0-0;'),
(9328,'White Lightning','rhand','true',1330,1,1,'wood','a',193,0,'rapier',10,-1.00000,0,0,0,406,0,107,-1,22000000,0,'true','true','true','true',0,0,0,0,0,0,0,0,80,'0-0;'),
(9329,'White Lightning - Critical Poison','rhand','true',1330,1,1,'wood','a',193,0,'rapier',10,-1.00000,0,0,0,406,0,107,-1,0,0,'true','true','true','true',0,0,0,0,0,0,0,0,5635,'3013-1;'),
(9330,'White Lightning - Haste','rhand','true',1330,1,1,'wood','a',193,0,'rapier',10,-1.00000,0,0,0,406,0,107,-1,0,0,'true','true','true','true',0,0,0,0,0,0,0,0,5636,'3028-1;'),
(9331,'White Lightning - Anger','rhand','true',1330,1,1,'wood','a',193,0,'rapier',10,-1.00000,0,0,0,406,0,107,-1,0,0,'true','true','true','true',0,0,0,0,0,0,0,0,5637,'3032-2;'),
(9332,'Divine Pain','lrhand','true',1900,1,1,'wood','a',231,0,'ancient',6,2.00000,0,0,0,350,0,107,-1,22000000,0,'true','true','true','true',0,0,0,0,0,0,0,0,7884,'0-0;'),
(9333,'Divine Pain - Haste','lrhand','true',1900,1,1,'wood','a',231,0,'ancient',6,2.00000,0,0,0,350,0,107,-1,0,0,'true','true','true','true',0,0,0,0,0,0,0,0,8108,'0-0;'),
(9334,'Divine Pain - Critical Damage','lrhand','true',1900,1,1,'wood','a',231,0,'ancient',6,2.00000,0,0,0,350,0,107,-1,0,0,'true','true','true','true',0,0,0,0,0,0,0,0,8109,'0-0;'),
(9335,'Divine Pain - Focus','lrhand','true',1900,1,1,'wood','a',231,0,'ancient',6,2.00000,0,0,0,350,0,107,-1,0,0,'true','true','true','true',0,0,0,0,0,0,0,0,8110,'3044-1;'),
(9336,'Doomchanter','lrhand','true',1670,1,1,'wood','a',270,0,'crossbow',10,-1.00000,0,0,0,303,9,107,-1,22000000,0,'true','true','true','true',0,0,0,0,0,0,0,0,288,'0-0;'),
(9337,'Doomchanter - Light','lrhand','true',501,1,1,'wood','a',270,0,'crossbow',10,-1.00000,0,0,0,303,9,107,-1,0,0,'true','true','true','true',0,0,0,0,0,0,0,0,5608,'3498-1;'),
(9338,'Doomchanter - Critical Bleed','lrhand','true',1670,1,1,'wood','a',270,0,'crossbow',10,-1.00000,0,0,0,303,9,107,-1,0,0,'true','true','true','true',0,0,0,0,0,0,0,0,5609,'0-0;'),
(9339,'Doomchanter - Mana Up','lrhand','true',1670,1,1,'wood','a',270,0,'crossbow',10,-1.00000,0,0,0,303,9,107,-1,0,0,'true','true','true','true',0,0,0,0,0,0,0,0,5610,'3014-2;'),
(9340,'Lacerator','rhand','true',1320,1,1,'wood','a',210,0,'rapier',10,-1.00000,0,0,0,406,0,114,-1,27000000,0,'true','true','true','true',0,0,0,0,0,0,0,0,2500,'0-0;'),
(9341,'Lacerator - Critical Damage','rhand','true',1320,1,1,'wood','a',210,0,'rapier',10,-1.00000,0,0,0,406,0,114,-1,0,0,'true','true','true','true',0,0,0,0,0,0,0,0,5647,'3067-2;'),
(9342,'Lacerator - Health','rhand','true',1320,1,1,'wood','a',210,0,'rapier',10,-1.00000,0,0,0,406,0,114,-1,0,0,'true','true','true','true',0,0,0,0,0,0,0,0,5648,'3013-3;'),
(9343,'Lacerator - Rsk. Focus','rhand','true',1320,1,1,'wood','a',210,0,'rapier',10,-1.00000,0,0,0,406,0,114,-1,0,0,'true','true','true','true',0,0,0,0,0,0,0,0,5649,'3071-2;'),
(9344,'Undertaker','lrhand','true',1840,1,1,'wood','a',251,0,'ancient',6,2.00000,0,0,0,350,0,114,-1,27000000,0,'true','true','true','true',0,0,0,0,0,0,0,0,81,'0-0;'),
(9345,'Undertaker - Health','lrhand','true',1840,1,1,'wood','a',251,0,'ancient',6,2.00000,0,0,0,350,0,114,-1,0,0,'true','true','true','true',0,0,0,0,0,0,0,0,5644,'3013-3;'),
(9346,'Undertaker - Critical Bleed','lrhand','true',1840,1,1,'wood','a',251,0,'ancient',6,2.00000,0,0,0,350,0,114,-1,0,0,'true','true','true','true',0,0,0,0,0,3021,5,24,5645,'0-0;'),
(9347,'Undertaker - Critical Drain','lrhand','true',1840,1,1,'wood','a',251,0,'ancient',6,2.00000,0,0,0,350,0,114,-1,0,0,'true','true','true','true',0,0,0,0,0,3022,4,20,5646,'0-0;'),
(9348,'Reaper','lrhand','true',1660,1,1,'wood','a',294,0,'crossbow',10,-1.00000,0,0,0,303,9,114,-1,27000000,0,'true','true','true','true',0,0,0,0,0,0,0,0,289,'0-0;'),
(9349,'Reaper - Cheap Shot','lrhand','true',1660,1,1,'wood','a',294,0,'crossbow',10,-1.00000,0,0,0,303,9,114,-1,0,0,'true','true','true','true',0,0,0,0,0,0,0,0,5611,'0-0;'),
(9350,'Reaper - Quick Recovery','lrhand','true',1660,1,1,'wood','a',294,0,'crossbow',10,-1.00000,0,0,0,303,9,114,-1,0,0,'true','true','true','true',0,0,0,0,0,0,0,0,5612,'0-0;'),
(9351,'Reaper - Critical Poison','lrhand','true',1660,1,1,'wood','a',294,0,'crossbow',10,-1.00000,0,0,0,303,9,114,-1,0,0,'true','true','true','true',0,0,0,0,0,0,0,0,5613,'0-0;'),
(9352,'Eclair Bijou','rhand','true',1300,1,1,'wood','a',228,0,'rapier',10,-1.00000,0,0,0,406,0,121,-1,32000000,0,'true','true','true','true',0,0,0,0,0,0,0,0,8678,'0-0;'),
(9353,'Eclair Bijou - Haste','rhand','true',1300,1,1,'wood','a',228,0,'rapier',10,-1.00000,0,0,0,406,0,121,-1,0,0,'true','true','true','true',0,0,0,0,0,0,0,0,8788,'3037-6;'),
(9354,'Eclair Bijou - Health','rhand','true',1300,1,1,'wood','a',228,0,'rapier',10,-1.00000,0,0,0,406,0,121,-1,0,0,'true','true','true','true',0,0,0,0,0,0,0,0,8789,'3013-4;'),
(9355,'Eclair Bijou - Critical Poison','rhand','true',1300,1,1,'wood','a',228,0,'rapier',10,-1.00000,0,0,0,406,0,121,-1,0,0,'true','true','true','true',0,0,0,0,0,3024,6,15,8790,'0-0;'),
(9356,'Durendal','lrhand','true',1820,1,1,'wood','a',272,0,'ancient',6,2.00000,0,0,0,350,0,121,-1,32000000,0,'true','true','true','true',0,0,0,0,0,0,0,0,8679,'0-0;'),
(9357,'Durendal - Focus','lrhand','true',1820,1,1,'wood','a',272,0,'ancient',6,2.00000,0,0,0,350,0,121,-1,0,0,'true','true','true','true',0,0,0,0,0,0,0,0,8791,'3044-1;'),
(9358,'Durendal - Haste','lrhand','true',1820,1,1,'wood','a',272,0,'ancient',6,2.00000,0,0,0,350,0,121,-1,0,0,'true','true','true','true',0,0,0,0,0,0,0,0,8792,'3037-6;'),
(9359,'Durendal - Health','lrhand','true',1820,1,1,'wood','a',272,0,'ancient',6,2.00000,0,0,0,350,0,121,-1,0,0,'true','true','true','true',0,0,0,0,0,0,0,0,8793,'3013-4;'),
(9360,'Screaming Vengeance','lrhand','true',1640,1,1,'wood','a',318,0,'crossbow',10,-1.00000,0,0,0,303,9,121,-1,32000000,0,'true','true','true','true',0,0,0,0,0,0,0,0,8684,'0-0;'),
(9361,'Screaming Vengeance - Cheap Shot','lrhand','true',1640,1,1,'wood','a',318,0,'crossbow',10,-1.00000,0,0,0,303,9,121,-1,0,0,'true','true','true','true',0,0,0,0,0,0,0,0,8806,'0-0;'),
(9362,'Screaming Vengeance - Focus','lrhand','true',1640,1,1,'wood','a',318,0,'crossbow',10,-1.00000,0,0,0,303,9,121,-1,0,0,'true','true','true','true',0,0,0,0,0,0,0,0,8807,'3044-1;'),
(9363,'Screaming Vengeance - Quick Recovery','lrhand','true',1640,1,1,'wood','a',318,0,'crossbow',10,-1.00000,0,0,0,303,9,121,-1,0,0,'true','true','true','true',0,0,0,0,0,0,0,0,8808,'0-0;'),
(9364,'Laevateinn','rhand','true',1300,1,1,'wood','s',255,0,'rapier',10,-1.00000,0,0,0,406,0,132,-1,0,0,'true','true','true','true',0,0,0,0,0,0,0,0,6364,'0-0;'),
(9365,'Laevateinn - Haste','rhand','true',1300,1,1,'wood','s',255,0,'rapier',10,-1.00000,0,0,0,406,0,132,-1,0,0,'true','true','true','true',0,0,0,0,0,0,0,0,6581,'3037-2;'),
(9366,'Laevateinn - Health','rhand','true',1300,1,1,'wood','s',255,0,'rapier',10,-1.00000,0,0,0,406,0,132,-1,0,0,'true','true','true','true',0,0,0,0,0,0,0,0,6582,'3013-4;'),
(9367,'Laevateinn - Focus','rhand','true',1300,1,1,'wood','s',255,0,'rapier',10,-1.00000,0,0,0,406,0,132,-1,0,0,'true','true','true','true',0,0,0,0,0,0,0,0,6583,'3566-1;'),
(9368,'Gram','lrhand','true',1800,1,1,'wood','s',304,0,'ancient',6,2.00000,0,0,0,350,0,132,-1,0,0,'true','true','true','true',0,0,0,0,0,0,0,0,6372,'0-0;'),
(9369,'Gram - Haste','lrhand','true',1800,1,1,'wood','s',304,0,'ancient',6,2.00000,0,0,0,350,0,132,-1,0,0,'true','true','true','true',0,0,0,0,0,0,0,0,6605,'3601-9;'),
(9370,'Gram - Health','lrhand','true',1800,1,1,'wood','s',304,0,'ancient',6,2.00000,0,0,0,350,0,132,-1,0,0,'true','true','true','true',0,0,0,0,0,0,0,0,6606,'3013-4;'),
(9371,'Gram - Focus','lrhand','true',1800,1,1,'wood','s',304,0,'ancient',6,2.00000,0,0,0,350,0,132,-1,0,0,'true','true','true','true',0,0,0,0,0,0,0,0,6607,'3044-14;'),
(9372,'Sarnga','lrhand','true',1600,1,1,'wood','s',356,0,'crossbow',10,-1.00000,0,0,0,303,9,132,-1,0,0,'true','true','true','true',0,0,0,0,0,0,0,0,7575,'0-0;'),
(9373,'Sarnga - Cheap Shot','lrhand','true',1600,1,1,'wood','s',356,0,'crossbow',10,-1.00000,0,0,0,303,9,132,-1,0,0,'true','true','true','true',0,0,0,0,0,0,0,0,7576,'0-0;'),
(9374,'Sarnga - Focus','lrhand','true',1600,1,1,'wood','s',356,0,'crossbow',10,-1.00000,0,0,0,303,9,132,-1,0,0,'true','true','true','true',0,0,0,0,0,0,0,0,7577,'3044-17;'),
(9375,'Sarnga - Critical Slow','lrhand','true',1600,1,1,'wood','s',356,0,'crossbow',10,-1.00000,0,0,0,303,9,132,-1,0,0,'true','true','true','true',0,0,0,0,0,3574,1,10,7578,'0-0;'),
(9376,'Dynasty Rapier','rhand','true',1280,1,1,'wood','s80',278,0,'rapier',10,-1.00000,0,0,0,406,0,140,-1,0,0,'true','true','true','true',0,0,0,0,0,0,0,0,9442,'0-0;'),
(9377,'Dynasty Rapier - Focus','rhand','true',1280,1,1,'wood','s80',278,0,'rapier',10,-1.00000,0,0,0,406,0,140,-1,0,0,'true','true','true','true',0,0,0,0,0,0,0,0,9854,'3044-19;'),
(9378,'Dynasty Rapier - Health','rhand','true',1280,1,1,'wood','s80',278,0,'rapier',10,-1.00000,0,0,0,406,0,140,-1,0,0,'true','true','true','true',0,0,0,0,0,0,0,0,9855,'3013-4;'),
(9379,'Dynasty Rapier - Light','rhand','true',384,1,1,'wood','s80',278,0,'rapier',10,-1.00000,0,0,0,406,0,140,-1,0,0,'true','true','true','true',0,0,0,0,0,0,0,0,9856,'3498-1;'),
(9380,'Dynasty Ancient Sword','lrhand','true',1800,1,1,'wood','s80',332,0,'ancient',6,2.00000,0,0,0,350,0,140,-1,0,0,'true','true','true','true',0,0,0,0,0,0,0,0,9443,'0-0;'),
(9381,'Dynasty Ancient Sword - Focus','lrhand','true',1800,1,1,'wood','s80',332,0,'ancient',6,2.00000,0,0,0,350,0,140,-1,0,0,'true','true','true','true',0,0,0,0,0,0,0,0,9857,'3044-19;'),
(9382,'Dynasty Ancient Sword - Health','lrhand','true',1800,1,1,'wood','s80',332,0,'ancient',6,2.00000,0,0,0,350,0,140,-1,0,0,'true','true','true','true',0,0,0,0,0,0,0,0,9858,'3013-4;'),
(9383,'Dynasty Ancient Sword - Light','lrhand','true',540,1,1,'wood','s80',332,0,'ancient',6,2.00000,0,0,0,350,0,140,-1,0,0,'true','true','true','true',0,0,0,0,0,0,0,0,9859,'3498-1;'),
(9384,'Dynasty Crossbow','lrhand','true',1580,1,1,'wood','s80',389,0,'crossbow',10,-1.00000,0,0,0,303,9,140,-1,0,0,'true','true','true','true',0,0,0,0,0,0,0,0,9445,'0-0;'),
(9385,'Dynasty Crossbow - Cheap Shot','lrhand','true',1580,1,1,'wood','s80',389,0,'crossbow',10,-1.00000,0,0,0,303,9,140,-1,0,0,'true','true','true','true',0,0,0,0,0,0,0,0,9863,'0-0;'),
(9386,'Dynasty Crossbow - Guidance','lrhand','true',1580,1,1,'wood','s80',389,0,'crossbow',10,-1.00000,0,0,0,303,9,140,-1,0,0,'true','true','true','true',0,0,0,0,0,0,0,0,9864,'3008-6;'),
(9387,'Dynasty Crossbow - Focus','lrhand','true',1580,1,1,'wood','s80',389,0,'crossbow',10,-1.00000,0,0,0,303,9,140,-1,0,0,'true','true','true','true',0,0,0,0,0,0,0,0,9865,'3044-20;'),
(9388,'Infinity Rapier','rhand','true',1280,1,1,'wood','s',287,0,'rapier',10,-1.00000,0,0,0,406,0,142,-1,0,0,'false','false','false','false',0,0,0,0,0,0,0,0,0,'0-0;'),
(9389,'Infinity Sword','lrhand','true',1800,1,1,'wood','s',342,0,'ancient',6,2.00000,0,0,0,350,0,142,-1,0,0,'false','false','false','false',0,0,0,0,0,0,0,0,0,'0-0;'),
(9390,'Infinity Shooter','lrhand','true',1580,1,1,'wood','s',400,0,'crossbow',10,-1.00000,0,0,0,303,9,142,-1,0,0,'false','false','false','false',0,0,0,0,0,0,0,0,0,'0-0;'),
(9441,'Dynasty Shield','lhand','true',1390,0,0,'wood','s80',0,0,'none',0,0.00000,-8,321,20,0,0,0,-1,0,0,'true','true','true','true',0,0,0,0,0,0,0,0,0,'0-0;'),
(9442,'Dynasty Sword','rhand','true',1520,1,1,'wood','s80',307,0,'sword',8,0.00000,0,0,0,379,0,140,-1,0,0,'true','true','true','true',0,0,0,0,0,0,0,0,9376,'0-0;'),
(9443,'Dynasty Blade','lrhand','true',1740,1,1,'wood','s80',374,0,'bigsword',8,0.00000,0,0,0,325,0,140,-1,0,0,'true','true','true','true',0,0,0,0,0,0,0,0,9380,'0-0;'),
(9444,'Dynasty Phantom','rhand','true',1520,1,1,'wood','s80',246,0,'sword',8,0.00000,0,0,0,379,0,186,-1,0,0,'true','true','true','true',0,0,0,0,0,0,0,0,0,'0-0;'),
(9445,'Dynasty Bow','lrhand','true',1520,1,1,'wood','s80',634,0,'bow',12,-3.00000,0,0,0,293,9,140,-1,0,0,'true','true','true','true',0,0,0,0,0,0,0,0,9384,'0-0;'),
(9446,'Dynasty Knife','rhand','true',1520,1,1,'wood','s80',269,0,'dagger',12,-3.00000,0,0,0,433,0,140,-1,0,0,'true','true','true','true',0,0,0,0,0,0,0,0,0,'0-0;'),
(9447,'Dynasty Halberd','lrhand','true',2010,1,1,'wood','s80',307,0,'pole',8,-3.00000,0,0,0,325,0,140,-1,0,0,'true','true','true','true',0,0,0,0,0,0,0,0,0,'0-0;'),
(9448,'Dynasty Cudgel','rhand','true',1740,1,1,'wood','s80',307,0,'blunt',4,4.00000,0,0,0,379,0,140,-1,0,0,'true','true','true','true',0,0,0,0,0,0,0,0,0,'0-0;'),
(9449,'Dynasty Mace','lrhand','true',1080,1,1,'wood','s80',246,0,'bigblunt',4,4.00000,0,0,0,379,0,186,-1,0,0,'true','true','true','true',0,0,0,0,0,0,0,0,0,'0-0;'),
(9450,'Dynasty Bagh-Nakh','lrhand','true',1550,1,1,'wood','s80',374,0,'dualfist',4,4.00000,0,0,0,325,0,140,-1,0,0,'true','true','true','true',0,0,0,0,0,0,0,0,0,'0-0;'),
(9529,'Sealed Dynasty Shield','lhand','true',1370,0,0,'wood','s80',0,0,'none',0,0.00000,-8,305,20,0,0,0,-1,0,0,'true','true','true','true',0,0,0,0,0,0,0,0,0,'0-0;'),
(9638,'Tears r1','rhand','true',300,0,0,'wood','none',5,0,'none',12,-3.00000,0,0,0,433,0,5,-1,0,0,'true','true','true','true',0,0,0,0,0,0,0,0,0,'0-0;'),
(9639,'Tears r2','rhand','true',300,0,0,'wood','none',5,0,'none',12,-3.00000,0,0,0,433,0,5,-1,0,0,'true','true','true','true',0,0,0,0,0,0,0,0,0,'0-0;'),
(9640,'Tears r3','rhand','true',300,0,0,'wood','none',5,0,'none',12,-3.00000,0,0,0,433,0,5,-1,0,0,'true','true','true','true',0,0,0,0,0,0,0,0,0,'0-0;'),
(9641,'Tears l1','rhand','true',300,0,0,'wood','none',5,0,'none',12,-3.00000,0,0,0,433,0,5,-1,0,0,'true','true','true','true',0,0,0,0,0,0,0,0,0,'0-0;'),
(9642,'Tears l2','rhand','true',300,0,0,'wood','none',5,0,'none',12,-3.00000,0,0,0,433,0,5,-1,0,0,'true','true','true','true',0,0,0,0,0,0,0,0,0,'0-0;'),
(9643,'Tears l3','rhand','true',300,0,0,'wood','none',5,0,'none',12,-3.00000,0,0,0,433,0,5,-1,0,0,'true','true','true','true',0,0,0,0,0,0,0,0,0,'0-0;'),
(9644,'npc Only (Crossbow)','rhand','true',1530,0,0,'wood','none',31,0,'crossbow',8,0.00000,0,0,0,379,0,21,-1,0,0,'true','true','true','true',0,0,0,0,0,0,0,0,0,'0-0;'),
(9645,'npc Only (Sword)','rhand','true',1530,0,0,'wood','none',31,0,'ancient',8,0.00000,0,0,0,379,0,21,-1,0,0,'true','true','true','true',0,0,0,0,0,0,0,0,0,'0-0;'),
(9646,'npc Only (Rapier)','rhand','true',1530,0,0,'wood','none',31,0,'rapier',8,0.00000,0,0,0,379,0,21,-1,0,0,'true','true','true','true',0,0,0,0,0,0,0,0,0,'0-0;'),
(9656,'Enchanted Wolf Fang','rhand','true',100,0,0,'wood','none',233,0,'dualfist',8,0.00000,0,0,0,277,0,5,-1,3676000,0,'true','true','true','true',0,0,0,0,0,0,0,0,0,'0-0;'),
(9657,'Enchanted Coyote Fang','rhand','true',100,0,0,'wood','none',289,0,'dualfist',8,0.00000,0,0,0,277,0,5,-1,6809000,0,'true','true','true','true',0,0,0,0,0,0,0,0,0,'0-0;'),
(9658,'Enchanted Saltydog Fang','rhand','true',100,0,0,'wood','none',350,0,'dualfist',8,0.00000,0,0,0,277,0,5,-1,12758000,0,'true','true','true','true',0,0,0,0,0,0,0,0,0,'0-0;'),
(9659,'Enchanted Cerberus Fang','rhand','true',100,0,0,'wood','none',413,0,'dualfist',8,0.00000,0,0,0,277,0,5,-1,21159000,0,'true','true','true','true',0,0,0,0,0,0,0,0,0,'0-0;'),
(9660,'Orichalcum Fang','rhand','true',100,0,0,'wood','none',477,0,'dualfist',8,0.00000,0,0,0,277,0,5,-1,37752000,0,'true','true','true','true',0,0,0,0,0,0,0,0,0,'0-0;'),
(9661,'Enchanted Fenril Fang','rhand','true',100,0,0,'wood','none',537,0,'dualfist',8,0.00000,0,0,0,277,0,5,-1,68638000,0,'true','true','true','true',0,0,0,0,0,0,0,0,0,'0-0;'),
(9720,'Warrior''s Sword','rhand','true',1300,1,1,'wood','none',12,0,'rapier',10,-1.00000,0,0,0,406,0,10,-1,0,0,'true','true','true','true',0,0,0,0,0,0,0,0,0,'0-0;'),
(9813,'Orc Officer','lrhand','true',2150,1,1,'wood','none',213,0,'dual',8,0.00000,0,0,0,325,0,91,-1,0,0,'true','true','true','true',0,0,0,0,0,0,0,0,0,'0-0;'),
(9819,'Combat flag','lrhand','true',500,1,1,'wood','none',0,0,'none',0,0.00000,0,0,0,325,0,0,-1,0,0,'false','false','false','false',0,0,0,0,0,0,0,0,0,'0-0;'),
(9840,'Shadow Item: Chevalier Rapier','rhand','false',473,2,2,'wood','d',111,0,'rapier',10,-1.00000,0,0,0,406,0,68,300,0,0,'false','false','true','false',0,0,0,0,0,0,0,0,0,'0-0;'),
(9841,'Shadow Item: Riter Schlager','lrhand','false',667,2,2,'wood','c',132,0,'ancient',6,2.00000,0,0,0,350,0,68,300,0,0,'false','false','true','false',0,0,0,0,0,0,0,0,0,'0-0;'),
(9842,'Shadow Item: Ballista','lrhand','false',590,2,2,'wood','d',155,0,'crossbow',10,-1.00000,0,0,0,303,9,68,300,0,0,'false','false','true','false',0,0,0,0,0,0,0,0,0,'0-0;'),
(9843,'Shadow Item: Blinzlasher','rhand','false',467,3,3,'wood','c',126,0,'rapier',10,-1.00000,0,0,0,406,0,76,300,0,0,'false','false','true','false',0,0,0,0,0,0,0,0,0,'0-0;'),
(9844,'Shadow Item: Immortal Edge','lrhand','false',660,3,3,'wood','c',151,0,'ancient',6,2.00000,0,0,0,350,0,76,300,0,0,'false','false','true','false',0,0,0,0,0,0,0,0,0,'0-0;'),
(9845,'Shadow Item: Tathlum','lrhand','false',587,3,3,'wood','c',176,0,'crossbow',10,-1.00000,0,0,0,303,9,76,300,0,0,'false','false','true','false',0,0,0,0,0,0,0,0,0,'0-0;'),
(9846,'Shadow Item: Military Fleuret','rhand','false',457,1,1,'wood','b',159,0,'rapier',10,-1.00000,0,0,0,406,0,91,300,0,0,'false','false','true','false',0,0,0,0,0,0,0,0,0,'0-0;'),
(9847,'Shadow Item: Innominate Victory','lrhand','false',643,1,1,'wood','b',190,0,'ancient',6,2.00000,0,0,0,350,0,91,300,0,0,'false','false','true','false',0,0,0,0,0,0,0,0,0,'0-0;'),
(9848,'Shadow Item: Peacemaker','lrhand','false',573,1,1,'wood','b',221,0,'crossbow',10,-1.00000,0,0,0,303,9,91,300,0,0,'false','false','true','false',0,0,0,0,0,0,0,0,0,'0-0;'),
(9854,'Dynasty Sword - Focus','rhand','true',1520,1,1,'wood','s80',307,0,'sword',8,0.00000,0,0,0,379,0,140,-1,0,0,'true','true','true','true',0,0,0,0,0,0,0,0,9377,'3044-19;'),
(9855,'Dynasty Sword - Health','rhand','true',1520,1,1,'wood','s80',307,0,'sword',8,0.00000,0,0,0,379,0,140,-1,0,0,'true','true','true','true',0,0,0,0,0,0,0,0,9378,'3013-4;'),
(9856,'Dynasty Sword - Light','rhand','true',456,1,1,'wood','s80',307,0,'sword',8,0.00000,0,0,0,379,0,140,-1,0,0,'true','true','true','true',0,0,0,0,0,0,0,0,9379,'3498-1;'),
(9857,'Dynasty Blade - Focus','lrhand','true',1740,1,1,'wood','s80',374,0,'bigsword',8,0.00000,0,0,0,325,0,140,-1,0,0,'true','true','true','true',0,0,0,0,0,0,0,0,9381,'3044-19;'),
(9858,'Dynasty Blade - Health','lrhand','true',1740,1,1,'wood','s80',374,0,'bigsword',8,0.00000,0,0,0,325,0,140,-1,0,0,'true','true','true','true',0,0,0,0,0,0,0,0,9382,'3013-4;'),
(9859,'Dynasty Blade - Light','lrhand','true',522,1,1,'wood','s80',374,0,'bigsword',8,0.00000,0,0,0,325,0,140,-1,0,0,'true','true','true','true',0,0,0,0,0,0,0,0,9383,'3498-1;'),
(9860,'Dynasty Phantom - Acumen','rhand','true',1520,1,1,'wood','s80',246,0,'sword',8,0.00000,0,0,0,379,0,186,-1,0,0,'true','true','true','true',0,0,0,0,0,0,0,0,0,'3047-3;'),
(9861,'Dynasty Phantom - Mana Up','rhand','true',1520,1,1,'wood','s80',246,0,'sword',8,0.00000,0,0,0,379,0,186,-1,0,0,'true','true','true','true',0,0,0,0,0,0,0,0,0,'3014-2;'),
(9862,'Dynasty Phantom - Conversion','rhand','true',1520,1,1,'wood','s80',246,0,'sword',8,0.00000,0,0,0,379,0,186,-1,0,0,'true','true','true','true',0,0,0,0,0,0,0,0,0,'3048-2;'),
(9863,'Dynasty Bow - Cheap Shot','lrhand','true',1520,1,1,'wood','s80',634,0,'bow',12,-3.00000,0,0,0,293,9,140,-1,0,0,'true','true','true','true',0,0,0,0,0,0,0,0,9385,'0-0;'),
(9864,'Dynasty Bow - Guidance','lrhand','true',1520,1,1,'wood','s80',634,0,'bow',12,-3.00000,0,0,0,293,9,140,-1,0,0,'true','true','true','true',0,0,0,0,0,0,0,0,9386,'3008-6;'),
(9865,'Dynasty Bow - Focus','lrhand','true',1520,1,1,'wood','s80',634,0,'bow',12,-3.00000,0,0,0,293,9,140,-1,0,0,'true','true','true','true',0,0,0,0,0,0,0,0,9387,'3044-20;'),
(9866,'Dynasty Knife - Focus','rhand','true',1520,1,1,'wood','s80',269,0,'dagger',12,-3.00000,0,0,0,433,0,140,-1,0,0,'true','true','true','true',0,0,0,0,0,0,0,0,0,'3044-20;'),
(9867,'Dynasty Knife - Evasion','rhand','true',1520,1,1,'wood','s80',269,0,'dagger',12,-3.00000,0,0,0,433,0,140,-1,0,0,'true','true','true','true',0,0,0,0,0,0,0,0,0,'3009-5;'),
(9868,'Dynasty Knife - Critical Damage','rhand','true',1520,1,1,'wood','s80',269,0,'dagger',12,-3.00000,0,0,0,433,0,140,-1,0,0,'true','true','true','true',0,0,0,0,0,0,0,0,0,'0-0;'),
(9869,'Dynasty Halberd - Anger','lrhand','true',2010,1,1,'wood','s80',307,0,'pole',8,-3.00000,0,0,0,325,0,140,-1,0,0,'true','true','true','true',0,0,0,0,0,0,0,0,0,'3600-1;'),
(9870,'Dynasty Halberd - Critical Stun','lrhand','true',2010,1,1,'wood','s80',307,0,'pole',8,-3.00000,0,0,0,325,0,140,-1,0,0,'true','true','true','true',0,0,0,0,0,3571,1,18,0,'0-0;'),
(9871,'Dynasty Halberd - Light','lrhand','true',603,1,1,'wood','s80',307,0,'pole',8,-3.00000,0,0,0,325,0,140,-1,0,0,'true','true','true','true',0,0,0,0,0,0,0,0,0,'3498-1;'),
(9872,'Dynasty Cudgel - Anger','rhand','true',1740,1,1,'wood','s80',307,0,'blunt',4,4.00000,0,0,0,379,0,140,-1,0,0,'true','true','true','true',0,0,0,0,0,0,0,0,0,'3600-1;'),
(9873,'Dynasty Cudgel - Health','rhand','true',1740,1,1,'wood','s80',307,0,'blunt',4,4.00000,0,0,0,379,0,140,-1,0,0,'true','true','true','true',0,0,0,0,0,0,0,0,0,'3013-4;'),
(9874,'Dynasty Cudgel - Rsk. Focus','rhand','true',1740,1,1,'wood','s80',307,0,'blunt',4,4.00000,0,0,0,379,0,140,-1,0,0,'true','true','true','true',0,0,0,0,0,0,0,0,0,'3071-2;'),
(9875,'Dynasty Mace - Mana Up','lrhand','true',1080,1,1,'wood','s80',246,0,'bigblunt',4,4.00000,0,0,0,379,0,186,-1,0,0,'true','true','true','true',0,0,0,0,0,0,0,0,0,'3014-2;'),
(9876,'Dynasty Mace - Conversion','lrhand','true',1080,1,1,'wood','s80',246,0,'bigblunt',4,4.00000,0,0,0,379,0,186,-1,0,0,'true','true','true','true',0,0,0,0,0,0,0,0,0,'3048-2;'),
(9877,'Dynasty Mace - Acumen','lrhand','true',1080,1,1,'wood','s80',246,0,'bigblunt',4,4.00000,0,0,0,379,0,186,-1,0,0,'true','true','true','true',0,0,0,0,0,0,0,0,0,'3047-3;'),
(9878,'Dynasty Bagh-Nakh - Rsk. Evasion','lrhand','true',1550,1,1,'wood','s80',374,0,'dualfist',4,4.00000,0,0,0,325,0,140,-1,0,0,'true','true','true','true',0,0,0,0,0,0,0,0,0,'3031-6;'),
(9879,'Dynasty Bagh-Nakh - Focus','lrhand','true',1550,1,1,'wood','s80',374,0,'dualfist',4,4.00000,0,0,0,325,0,140,-1,0,0,'true','true','true','true',0,0,0,0,0,0,0,0,0,'3044-18;'),
(9880,'Dynasty Bagh-Nakh - Haste','lrhand','true',1550,1,1,'wood','s80',374,0,'dualfist',4,4.00000,0,0,0,325,0,140,-1,0,0,'true','true','true','true',0,0,0,0,0,0,0,0,0,'3037-2;'),
(9901,'Improved Falchion','rhand','true',1530,2,2,'wood','none',31,0,'sword',8,0.00000,0,0,0,379,0,21,-1,0,0,'true','true','true','true',0,0,0,0,0,0,0,0,0,'0-0;'),
(9902,'Improved Great Spear','lrhand','true',2120,2,2,'wood','none',31,0,'pole',8,-3.00000,0,0,0,325,0,21,-1,0,0,'true','true','true','true',0,0,0,0,0,0,0,0,0,'0-0;'),
(9903,'Improved Iron Hammer','rhand','true',1850,2,2,'wood','none',31,0,'blunt',4,4.00000,0,0,0,379,0,21,-1,0,0,'true','true','true','true',0,0,0,0,0,0,0,0,0,'0-0;'),
(9904,'Improved Sword Breaker','rhand','true',1110,2,2,'wood','none',27,0,'dagger',12,-3.00000,0,0,0,433,0,21,-1,0,0,'true','true','true','true',0,0,0,0,0,0,0,0,0,'0-0;'),
(9905,'Improved Viper Fang','lrhand','true',1560,2,2,'wood','none',38,0,'dualfist',4,4.00000,0,0,0,325,0,21,-1,0,0,'true','true','true','true',0,0,0,0,0,0,0,0,0,'0-0;'),
(9906,'Improved Composite Bow','lrhand','true',1880,2,2,'wood','none',64,0,'bow',12,-3.00000,0,0,0,293,9,21,-1,0,0,'true','true','true','true',0,0,0,0,0,0,0,0,0,'0-0;'),
(9907,'Improved Flanged Mace','rhand','true',1800,2,2,'wood','none',31,0,'blunt',4,4.00000,0,0,0,379,0,21,-1,0,0,'true','true','true','true',0,0,0,0,0,0,0,0,0,'0-0;'),
(9908,'Improved Mage Staff','lrhand','true',1050,2,2,'wood','none',30,0,'bigblunt',4,4.00000,0,0,0,325,0,28,-1,0,0,'true','true','true','true',0,0,0,0,0,0,0,0,0,'0-0;'),
(9995,'Hand Crossbow','lrhand','true',1850,2,2,'wood','d',64,0,'crossbow',10,-1.00000,0,0,0,303,9,32,-1,0,0,'true','true','true','true',0,0,0,0,0,0,0,0,0,'0-0;'),
(9996,'Hand Crossbow','lrhand','true',1850,2,2,'wood','d',64,0,'crossbow',10,-1.00000,0,0,0,303,9,32,-1,0,0,'true','true','true','true',0,0,0,0,0,0,0,0,0,'0-0;'),
(10003,'Fleuret','rhand','true',1500,2,2,'wood','d',46,0,'rapier',10,-1.00000,0,0,0,406,0,32,-1,0,0,'true','true','true','true',0,0,0,0,0,0,0,0,0,'0-0;'),
(10004,'Dynasty Dual Sword','lrhand','true',1520,1,1,'wood','s80',374,0,'dual',8,0.00000,0,0,0,325,0,140,-1,0,0,'true','true','true','true',0,0,0,0,0,0,0,0,0,'0-0;'),
(10005,'Shadow Item: Fleuret','rhand','false',500,2,2,'wood','d',46,0,'rapier',10,-1.00000,0,0,0,406,0,32,90,0,0,'false','false','true','false',0,0,0,0,0,0,0,0,0,'0-0;'),
(10006,'Shadow Item: Military Talwar','lrhand','false',693,2,2,'wood','d',55,0,'ancient',6,2.00000,0,0,0,350,0,32,90,0,0,'false','false','true','false',0,0,0,0,0,0,0,0,0,'0-0;'),
(10007,'Shadow Item: Hand Crossbow','lrhand','false',693,3,2,'wood','d',64,0,'crossbow',10,-1.00000,0,0,0,303,9,32,90,0,0,'false','false','true','false',0,0,0,0,0,0,0,0,0,'0-0;'),
(10008,'Shadow Item: Blinzlasher','rhand','false',467,2,2,'wood','c',126,0,'rapier',10,-1.00000,0,0,0,406,0,76,120,0,0,'false','false','true','false',0,0,0,0,0,0,0,0,0,'0-0;'),
(10009,'Shadow Item: Immortal Edge','lrhand','false',660,2,2,'wood','c',151,0,'ancient',6,2.00000,0,0,0,350,0,76,120,0,0,'false','false','true','false',0,0,0,0,0,0,0,0,0,'0-0;'),
(10010,'Shadow Item: Tathlum','lrhand','false',587,5,3,'wood','c',176,0,'crossbow',10,-1.00000,0,0,0,303,9,76,120,0,0,'false','false','true','false',0,0,0,0,0,0,0,0,0,'0-0;'),
(10011,'Shadow Item - War Axe','rhand','false',533,3,3,'wood','c',139,0,'blunt',4,4.00000,0,0,0,379,0,76,120,0,0,'false','false','true','false',0,0,0,0,0,0,0,0,0,'0-0;'),
(10125,'Shadow Item - War Axe','rhand','false',533,3,3,'wood','c',139,0,'blunt',4,4.00000,0,0,0,379,0,76,300,0,0,'false','false','true','false',0,0,0,0,0,0,0,0,0,'0-0;'),
(10128,'For Monster only (Crossbow)','rhand','true',1530,2,2,'wood','none',31,0,'crossbow',8,0.00000,0,0,0,379,0,21,-1,0,0,'true','true','true','true',0,0,0,0,0,0,0,0,0,'0-0;'),
(10167,'Pig Lollipop','rhand','true',0,1,1,'steel','none',1,0,'sword',8,0.00000,0,0,0,379,0,1,-1,0,0,'true','true','true','true',0,0,0,0,0,0,0,0,0,'0-0;'),
(10212,'npc Only (Bow)','rhand','true',0,0,0,'steel','none',0,15,'bow',10,0.00000,0,0,0,325,0,0,-1,0,0,'true','true','true','true',0,0,0,0,0,0,0,0,0,'0-0;'),
(10215,'Icarus Sawsword','rhand','true',1520,1,1,'steel','s80',363,15,'sword',10,0.00000,0,0,0,325,0,163,-1,0,0,'true','true','true','true',0,0,0,0,0,0,0,0,0,'0-0;'),
(10216,'Icarus Disperser','rhand','true',1520,1,1,'steel','s80',318,15,'dagger',10,0.00000,0,0,0,325,0,163,-1,0,0,'true','true','true','true',0,0,0,0,0,0,0,0,0,'0-0;'),
(10217,'Icarus Spirit','rhand','true',1520,1,1,'steel','s80',290,15,'sword',10,0.00000,0,0,0,325,0,217,-1,0,0,'true','true','true','true',0,0,0,0,0,0,0,0,0,'0-0;'),
(10218,'Icarus Heavy Arms','lrhand','true',1740,1,1,'steel','s80',442,15,'bigsword',10,0.00000,0,0,0,325,0,163,-1,0,0,'true','true','true','true',0,0,0,0,0,0,0,0,0,'0-0;'),
(10219,'Icarus Trident','lrhand','true',2010,1,1,'bronze','s80',363,15,'pole',10,0.00000,0,0,0,325,0,163,-1,0,0,'true','true','true','true',0,0,0,0,0,0,0,0,0,'0-0;'),
(10220,'Icarus Hammer','rhand','true',1740,1,1,'fine_steel','s80',363,15,'blunt',10,0.00000,0,0,0,325,0,163,-1,0,0,'true','true','true','true',0,0,0,0,0,0,0,0,0,'0-0;'),
(10221,'Icarus Hand','lrhand','true',1550,1,1,'steel','s80',442,15,'dualfist',10,0.00000,0,0,0,325,0,163,-1,0,0,'true','true','true','true',0,0,0,0,0,0,0,0,0,'0-0;'),
(10222,'Icarus Hall','rhand','true',1080,1,1,'wood','s80',290,15,'blunt',10,0.00000,0,0,0,325,0,217,-1,0,0,'true','true','true','true',0,0,0,0,0,0,0,0,0,'0-0;'),
(10223,'Icarus Spitter','lrhand','true',1520,1,1,'steel','s80',689,15,'bow',10,0.00000,0,0,0,325,0,163,-1,0,0,'true','true','true','true',0,0,0,0,0,0,0,0,0,'0-0;'),
(10224,'Icarus Stinger','rhand','true',1280,1,1,'steel','s80',329,15,'rapier',10,0.00000,0,0,0,325,0,163,-1,0,0,'true','true','true','true',0,0,0,0,0,0,0,0,0,'0-0;'),
(10225,'Icarus Wingblade','lrhand','true',1800,1,1,'steel','s80',393,15,'ancient',10,0.00000,0,0,0,325,0,163,-1,0,0,'true','true','true','true',0,0,0,0,0,0,0,0,0,'0-0;'),
(10226,'Icarus Shooter','lrhand','true',1580,1,1,'steel','s80',400,15,'crossbow',10,0.00000,0,0,0,325,0,163,-1,0,0,'true','true','true','true',0,0,0,0,0,0,0,0,0,'0-0;'),
(10252,'Dynasty Staff','rhand','true',1080,1,1,'wood','s80',307,0,'blunt',4,4.00000,0,0,0,379,0,140,-1,0,0,'true','true','true','true',0,0,0,0,0,0,0,0,0,'0-0;'),
(10253,'Dynasty Crusher','rhand','true',1740,1,1,'fine_steel','s80',307,0,'blunt',4,4.00000,0,0,0,379,0,140,-1,0,0,'true','true','true','true',0,0,0,0,0,0,0,0,0,'0-0;'),
(10277,'Monster Only (Behamah Pole)','rhand','true',2140,0,0,'steel','none',24,0,'sword',8,-3.00000,0,0,0,325,0,17,-1,0,0,'true','true','true','true',0,0,0,0,0,0,0,0,0,'0-0;'),
(10278,'Monster Only (Behamah Dual)','rhand','true',2530,0,0,'fine_steel','none',73,0,'sword',8,0.00000,0,0,0,325,0,37,-1,0,0,'true','true','true','true',0,0,0,0,0,0,0,0,0,'0-0;'),
(10434,'Icarus Sawsword Focus','rhand','true',1520,1,1,'steel','s80',363,15,'sword',10,0.00000,0,0,0,325,0,163,-1,0,0,'true','true','true','true',0,0,0,0,0,0,0,0,0,'3044-19;'),
(10435,'Icarus Sawsword Health','rhand','true',1520,1,1,'steel','s80',363,15,'sword',10,0.00000,0,0,0,325,0,163,-1,0,0,'true','true','true','true',0,0,0,0,0,0,0,0,0,'0-0;'),
(10436,'Icarus Sawsword Light','rhand','true',1520,1,1,'steel','s80',363,15,'sword',10,0.00000,0,0,0,325,0,163,-1,0,0,'true','true','true','true',0,0,0,0,0,0,0,0,0,'3498-1;'),
(10437,'Icarus Heavy Arms - Focus','lrhand','true',1740,1,1,'steel','s80',442,15,'bigsword',4,0.00000,0,0,0,325,0,163,-1,0,0,'true','true','true','true',0,0,0,0,0,0,0,0,0,'3044-19;'),
(10438,'Icarus Heavy Arms - Health','lrhand','true',1740,1,1,'steel','s80',442,15,'bigsword',4,0.00000,0,0,0,325,0,163,-1,0,0,'true','true','true','true',0,0,0,0,0,0,0,0,0,'0-0;'),
(10439,'Icarus Heavy Arms - Light','lrhand','true',1740,1,1,'steel','s80',442,15,'bigsword',4,0.00000,0,0,0,325,0,163,-1,0,0,'true','true','true','true',0,0,0,0,0,0,0,0,0,'3498-1;'),
(10440,'Icarus Spirit - Acumen','rhand','true',1520,1,1,'steel','s80',290,15,'sword',8,0.00000,0,0,0,379,0,217,-1,0,0,'true','true','true','true',0,0,0,0,0,0,0,0,0,'0-0;'),
(10441,'Icarus Spirit - Mana Up','rhand','true',1520,1,1,'steel','s80',290,15,'sword',8,0.00000,0,0,0,379,0,217,-1,0,0,'true','true','true','true',0,0,0,0,0,0,0,0,0,'0-0;'),
(10442,'Icarus Spirit - Conversion','rhand','true',1520,1,1,'steel','s80',290,15,'sword',8,0.00000,0,0,0,379,0,217,-1,0,0,'true','true','true','true',0,0,0,0,0,0,0,0,0,'0-0;'),
(10443,'Icarus Spitter - Cheap Shot','lrhand','true',1520,1,1,'steel','s80',689,15,'bow',12,0.00000,0,0,0,325,0,163,-1,0,0,'true','true','true','true',0,0,0,0,0,0,0,0,0,'0-0;'),
(10444,'Icarus Spitter - Guidance','lrhand','true',1520,1,1,'steel','s80',689,15,'bow',12,0.00000,0,0,0,325,0,163,-1,0,0,'true','true','true','true',0,0,0,0,0,0,0,0,0,'0-0;'),
(10445,'Icarus Spitter - Focus','lrhand','true',1520,1,1,'steel','s80',689,15,'bow',12,0.00000,0,0,0,325,0,163,-1,0,0,'true','true','true','true',0,0,0,0,0,0,0,0,0,'3044-20;'),
(10446,'Icarus Disperser - Focus','rhand','true',1520,1,1,'steel','s80',318,15,'dagger',8,0.00000,0,0,0,433,0,163,-1,0,0,'true','true','true','true',0,0,0,0,0,0,0,0,0,'3044-20;'),
(10447,'Icarus Disperser - Evasion','rhand','true',1520,1,1,'steel','s80',318,15,'dagger',8,0.00000,0,0,0,433,0,163,-1,0,0,'true','true','true','true',0,0,0,0,0,0,0,0,0,'0-0;'),
(10448,'Icarus Disperser - Critical Damage','rhand','true',1520,1,1,'steel','s80',318,15,'dagger',8,0.00000,0,0,0,433,0,163,-1,0,0,'true','true','true','true',0,0,0,0,0,0,0,0,0,'0-0;'),
(10449,'Icarus Trident - Anger','lrhand','true',2010,1,1,'bronze','s80',363,15,'pole',4,0.00000,0,0,0,325,0,163,-1,0,0,'true','true','true','true',0,0,0,0,0,0,0,0,0,'0-0;'),
(10450,'Icarus Trident - Critical Stun','lrhand','true',2010,1,1,'bronze','s80',363,15,'pole',4,0.00000,0,0,0,325,0,163,-1,0,0,'true','true','true','true',0,0,0,0,0,0,0,0,0,'0-0;'),
(10451,'Icarus Trident - Light','lrhand','true',2010,1,1,'bronze','s80',363,15,'pole',4,0.00000,0,0,0,325,0,163,-1,0,0,'true','true','true','true',0,0,0,0,0,0,0,0,0,'3498-1;'),
(10452,'Icarus Hammer - Anger','rhand','true',1740,1,1,'fine_steel','s80',363,15,'blunt',10,0.00000,0,0,0,379,0,163,-1,0,0,'true','true','true','true',0,0,0,0,0,0,0,0,0,'0-0;'),
(10453,'Icarus Hammer - Health','rhand','true',1740,1,1,'fine_steel','s80',363,15,'blunt',10,0.00000,0,0,0,379,0,163,-1,0,0,'true','true','true','true',0,0,0,0,0,0,0,0,0,'0-0;'),
(10454,'Icarus Hammer - Rsk. Focus','rhand','true',1740,1,1,'fine_steel','s80',363,15,'blunt',10,0.00000,0,0,0,379,0,163,-1,0,0,'true','true','true','true',0,0,0,0,0,0,0,0,0,'0-0;'),
(10455,'Icarus Hall - Mana Up','rhand','true',1080,1,1,'wood','s80',290,15,'blunt',10,0.00000,0,0,0,325,0,217,-1,0,0,'true','true','true','true',0,0,0,0,0,0,0,0,0,'0-0;'),
(10456,'Icarus Hall - Conversion','rhand','true',1080,1,1,'wood','s80',290,15,'blunt',10,0.00000,0,0,0,325,0,217,-1,0,0,'true','true','true','true',0,0,0,0,0,0,0,0,0,'0-0;'),
(10457,'Icarus Hall - Acumen','rhand','true',1080,1,1,'wood','s80',290,15,'blunt',10,0.00000,0,0,0,325,0,217,-1,0,0,'true','true','true','true',0,0,0,0,0,0,0,0,0,'0-0;'),
(10458,'Icarus Hand - Rsk. Evasion','lrhand','true',1550,1,1,'steel','s80',442,15,'dualfist',10,0.00000,0,0,0,325,0,163,-1,0,0,'true','true','true','true',0,0,0,0,0,0,0,0,0,'0-0;'),
(10459,'Icarus Hand - Focus','lrhand','true',1550,1,1,'steel','s80',442,15,'dualfist',10,0.00000,0,0,0,325,0,163,-1,0,0,'true','true','true','true',0,0,0,0,0,0,0,0,0,'3044-18;'),
(10460,'Icarus Hand - Haste','lrhand','true',1550,1,1,'steel','s80',442,15,'dualfist',10,0.00000,0,0,0,325,0,163,-1,0,0,'true','true','true','true',0,0,0,0,0,0,0,0,0,'0-0;'),
(10461,'Icarus Stinger - Focus','rhand','true',1280,1,1,'steel','s80',329,15,'rapier',10,0.00000,0,0,0,406,0,163,-1,0,0,'true','true','true','true',0,0,0,0,0,0,0,0,0,'0-0;'),
(10462,'Icarus Stinger - Health','rhand','true',1280,1,1,'steel','s80',329,15,'rapier',10,0.00000,0,0,0,406,0,163,-1,0,0,'true','true','true','true',0,0,0,0,0,0,0,0,0,'0-0;'),
(10463,'Icarus Stinger - Light','rhand','true',1280,1,1,'steel','s80',329,15,'rapier',10,0.00000,0,0,0,406,0,163,-1,0,0,'true','true','true','true',0,0,0,0,0,0,0,0,0,'3498-1;'),
(10464,'Icarus Wingblade - Focus','lrhand','true',1800,1,1,'steel','s80',393,15,'ancient',10,0.00000,0,0,0,350,0,163,-1,0,0,'true','true','true','true',0,0,0,0,0,0,0,0,0,'0-0;'),
(10465,'Icarus Wingblade - Health','lrhand','true',1800,1,1,'steel','s80',393,15,'ancient',10,0.00000,0,0,0,350,0,163,-1,0,0,'true','true','true','true',0,0,0,0,0,0,0,0,0,'0-0;'),
(10466,'Icarus Wingblade - Light','lrhand','true',1800,1,1,'steel','s80',393,15,'ancient',10,0.00000,0,0,0,350,0,163,-1,0,0,'true','true','true','true',0,0,0,0,0,0,0,0,0,'3498-1;'),
(10467,'Icarus Shooter - Cheap Shot','lrhand','true',1580,1,1,'steel','s80',400,15,'crossbow',10,0.00000,0,0,0,303,0,163,-1,0,0,'true','true','true','true',0,0,0,0,0,0,0,0,0,'0-0;'),
(10468,'Icarus Shooter - Guidance','lrhand','true',1580,1,1,'steel','s80',400,15,'crossbow',10,0.00000,0,0,0,303,0,163,-1,0,0,'true','true','true','true',0,0,0,0,0,0,0,0,0,'0-0;'),
(10469,'Icarus Shooter - Focus','lrhand','true',1580,1,1,'steel','s80',400,15,'crossbow',10,0.00000,0,0,0,303,0,163,-1,0,0,'true','true','true','true',0,0,0,0,0,0,0,0,0,'0-0;'),
(10474,'Shadow Item - Apprentice''s Staff','lrhand','false',1070,2,2,'wood','none',23,20,'bigblunt',4,4.00000,0,0,0,325,0,22,180,0,0,'false','false','true','false',0,0,0,0,0,0,0,0,0,'0-0;'),
(10475,'Shadow Item - Bone Club','rhand','false',1730,3,3,'bone','d',79,20,'blunt',4,4.00000,0,0,0,379,0,47,180,0,0,'false','false','true','false',0,0,0,0,0,0,0,0,0,'0-0;'),
(10476,'Shadow Item - Shining Knife','rhand','false',1120,2,2,'mithril','none',21,5,'dagger',12,-3.00000,0,0,0,433,0,17,180,0,0,'false','false','true','false',0,0,0,0,0,0,0,0,0,'0-0;'),
(10477,'Shadow Item - Cestus','lrhand','false',1570,2,2,'steel','none',29,5,'dualfist',4,4.00000,0,0,0,325,0,17,180,0,0,'false','false','true','false',0,0,0,0,0,0,0,0,0,'0-0;'),
(10478,'Shadow Item - Forest Bow','lrhand','false',1900,7,2,'wood','none',49,5,'bow',12,-3.00000,0,0,0,293,3,17,180,0,0,'false','false','true','false',0,0,0,0,0,0,0,0,0,'0-0;'),
(10479,'Shadow Item - Long Sword','rhand','false',1560,2,2,'fine_steel','none',24,10,'sword',8,0.00000,0,0,0,379,0,17,180,0,0,'false','false','true','false',0,0,0,0,0,0,0,0,0,'0-0;'),
(10527,'Dynasty Staff - Mana Up','rhand','true',1080,1,1,'wood','s80',307,0,'blunt',4,4.00000,0,0,0,379,0,140,-1,0,0,'true','true','true','true',0,0,0,0,0,0,0,0,0,'0-0;'),
(10528,'Dynasty Staff - Conversion','rhand','true',1080,1,1,'wood','s80',307,0,'blunt',4,4.00000,0,0,0,379,0,140,-1,0,0,'true','true','true','true',0,0,0,0,0,0,0,0,0,'0-0;'),
(10529,'Dynasty Staff - Acumen','rhand','true',1080,1,1,'wood','s80',307,0,'blunt',4,4.00000,0,0,0,379,0,140,-1,0,0,'true','true','true','true',0,0,0,0,0,0,0,0,0,'0-0;'),
(10530,'Dynasty Crusher - Anger','rhand','true',1740,1,1,'fine_steel','s80',307,20,'blunt',4,4.00000,0,0,0,379,0,140,-1,0,0,'true','true','true','true',0,0,0,0,0,0,0,0,0,'0-0;'),
(10531,'Dynasty Crusher - Health','rhand','true',1740,1,1,'fine_steel','s80',307,20,'blunt',4,4.00000,0,0,0,379,0,140,-1,0,0,'true','true','true','true',0,0,0,0,0,0,0,0,0,'0-0;'),
(10532,'Dynasty Crusher - Rsk. Focus','rhand','true',1740,1,1,'fine_steel','s80',307,20,'blunt',4,4.00000,0,0,0,379,0,140,-1,0,0,'true','true','true','true',0,0,0,0,0,0,0,0,0,'0-0;'),
(10548,'Monster Only (Transparent Shield)','lhand','false',1430,1,1,'steel','none',0,15,'none',10,0.00000,0,0,0,NULL,0,0,-1,0,0,'true','true','true','true',0,0,0,0,0,0,0,0,0,'0-0;');
