/*
 * This program is free software: you can redistribute it and/or modify it under
 * the terms of the GNU General Public License as published by the Free Software
 * Foundation, either version 3 of the License, or (at your option) any later
 * version.
 * 
 * This program is distributed in the hope that it will be useful, but WITHOUT
 * ANY WARRANTY; without even the implied warranty of MERCHANTABILITY or FITNESS
 * FOR A PARTICULAR PURPOSE. See the GNU General Public License for more
 * details.
 * 
 * You should have received a copy of the GNU General Public License along with
 * this program. If not, see <http://www.gnu.org/licenses/>.
 */
package net.sf.l2j.gameserver.instancemanager.grandbosses;
/*package com.l2jfree.gameserver.instancemanager.grandbosses;*/

import java.util.List;
import java.util.concurrent.ScheduledFuture;

import javolution.lang.MathLib;
import javolution.util.FastList;
import net.sf.l2j.Config;
import net.sf.l2j.gameserver.ThreadPoolManager;
import net.sf.l2j.gameserver.ai.CtrlIntention;
import net.sf.l2j.gameserver.datatables.DoorTable;
import net.sf.l2j.gameserver.datatables.NpcTable;
import net.sf.l2j.gameserver.datatables.SkillTable;
import net.sf.l2j.gameserver.instancemanager.GrandBossManager;
import net.sf.l2j.gameserver.instancemanager.lastimperialtomb.LastImperialTombManager;
import net.sf.l2j.gameserver.model.L2CharPosition;
import net.sf.l2j.gameserver.model.L2Effect;
import net.sf.l2j.gameserver.model.L2ItemInstance;
import net.sf.l2j.gameserver.model.L2Object;
import net.sf.l2j.gameserver.model.L2Skill;
import net.sf.l2j.gameserver.model.L2Spawn;
import net.sf.l2j.gameserver.model.L2World;
import net.sf.l2j.gameserver.model.SpawnListener;
import net.sf.l2j.gameserver.model.actor.L2Character;
import net.sf.l2j.gameserver.model.actor.L2Npc;
import net.sf.l2j.gameserver.model.actor.instance.L2GrandBossInstance;
import net.sf.l2j.gameserver.model.actor.instance.L2MonsterInstance;
import net.sf.l2j.gameserver.model.actor.instance.L2PcInstance;
import net.sf.l2j.gameserver.model.actor.instance.L2PcInstance.PunishLevel;
import net.sf.l2j.gameserver.model.entity.GrandBossState;
import net.sf.l2j.gameserver.model.zone.type.L2BossZone;
import net.sf.l2j.gameserver.network.SystemChatChannelId;
import net.sf.l2j.gameserver.network.SystemMessageId;
import net.sf.l2j.gameserver.network.serverpackets.CreatureSay;
import net.sf.l2j.gameserver.network.serverpackets.Earthquake;
import net.sf.l2j.gameserver.network.serverpackets.ExShowScreenMessage;
import net.sf.l2j.gameserver.network.serverpackets.FlyToLocation;
import net.sf.l2j.gameserver.network.serverpackets.MagicSkillCanceld;
import net.sf.l2j.gameserver.network.serverpackets.MagicSkillUse;
import net.sf.l2j.gameserver.network.serverpackets.PlaySound;
import net.sf.l2j.gameserver.network.serverpackets.SocialAction;
import net.sf.l2j.gameserver.network.serverpackets.StatusUpdate;
import net.sf.l2j.gameserver.network.serverpackets.SystemMessage;
import net.sf.l2j.gameserver.network.serverpackets.ValidateLocation;
import net.sf.l2j.gameserver.network.serverpackets.AbstractNpcInfo.NpcInfo;
import net.sf.l2j.gameserver.network.serverpackets.FlyToLocation.FlyType;
import net.sf.l2j.gameserver.skills.AbnormalEffect;
import net.sf.l2j.gameserver.skills.funcs.Func;
import net.sf.l2j.gameserver.templates.chars.L2NpcTemplate;
import net.sf.l2j.gameserver.util.Broadcast;
import net.sf.l2j.gameserver.util.Util;
import net.sf.l2j.util.Rnd;

/** *************************- main class + global class values -*********************************** */

/**
 * control for sequence of Frintezza and Scarlet Van Halisha and their minions.
 * 
 * @version 1.00.002
 * @author Darki699
 * @author SANDMAN L2J_JP(modified)
 * NOTE:
 * The class is divided from an original source file for making to L2J_LP.
 * Work has not been completed yet. now
 * Therefore, a lot of incomplete operation exists.
 * 
 * @author JOJO Sync: l2jfree-core rev4897, timestamp 2008/12/12 21:01
 * @author JOJO Sync: l2jfree-core rev6389, timestamp 2009/06/27 09:04
 * @author JOJO Sync: l2jfree-core rev7164, timestamp 2009/09/20 04:37
 * @author JOJO Frintezza final battle ꕔƂ肱
 *   http://www.l2jserver.com/forum/viewtopic.php?f=69&t=13999
 */

public final class FrintezzaManager extends BossLair
		implements SpawnListener
{
	@Deprecated static final boolean TEST = false;
	@Deprecated static final boolean DEBUG = false;

	@SuppressWarnings("synthetic-access")
	private static final class SingletonHolder
	{
		protected static final FrintezzaManager INSTANCE = new FrintezzaManager();
	}
	
	public static FrintezzaManager getInstance()
	{
		return SingletonHolder.INSTANCE;
	}

	L2GrandBossInstance		frintezza, weakScarlet, strongScarlet;	//tebT, f[1E2, 3
	L2MonsterInstance		portrait1, portrait2, portrait3, portrait4;	//Evil Spirit GBCg
	L2MonsterInstance		ghost1, ghost2, ghost3, ghost4;	//Breath of Halisha nV uX(GH)
	L2Npc					teleCube;
	Music					music;

	// Interval time of Monsters.
	int								_intervalOfBoss, _intervalOfGhosts, _intervalOfRetarget, _intervalOfFrintezzaSongs, _callForHelpInterval;

	// Delay of appearance time of Boss.
	private int						_appTimeOfBoss;

	// Activity time of Boss.
	int								_activityTimeOfBoss;

	// state of Scarlet Van Halisha.
	int								_scarletType;	// 1:Weak 2:Weak(2nd Morph) 3:Strong

	ScheduledFuture<?>				_monsterSpawnTask		= null;
	ScheduledFuture<?>				_activityTimeEndTask	= null;
	ScheduledFuture<?>				_intervalEndTask		= null;

	private Func					_DecreaseRegHp		= null;
	private int						_debuffPeriod		= 0;

	// Actually questname should be "Last Imperial Prince" or "Journey to a Settlement"
	// status in lair.
	L2BossZone						_zone;	// Last Imperial Tomb
	L2BossZone						_hall;	// Hall of Frintezza
	static final int				_bossId	= 29045;

	//coordinates at center of the hall
	static final int
			  CENTER_X = 174232
			, CENTER_Y = -88020
			, CENTER_Z = -5116;
	//camera home position
	static final int
			  CAMERA_X = CENTER_X
			, CAMERA_Y = CENTER_Y + 130 //-87890
			, CAMERA_Z = CENTER_Z
			, CAMERA_R = 1650;
	//frintezza position
	static final int
			  FRINTEZZA_X = 174240
			, FRINTEZZA_Y = -89805
			, FRINTEZZA_Z = -5022;
	//scarlet home position
	static final int
			  SCARLET_X = CENTER_X
			, SCARLET_Y = CENTER_Y
//			, SCARLET_Y = CENTER_Y - 600 //-88620
			, SCARLET_Z = CENTER_Z;

	// Music title
	static final String[] MUSIC_TITLE = {
			null					//0
			, "ǓƂ̃h"		//1 Healing Rhapsody
			, "̃t[K"		//2 Rampaging Opus
			, "̃gbJ[^"	//3 Power Concerto
			, "̃NCG"	//4 Plagued Concerto
			, "f̃}YJ"		//5 Psycho Symphony
		};

	static final int	// skills/5000-5099.xml "hitTime"
			  SKILL_TIME_5006_1 = 34000
			, SKILL_TIME_5007_1 = 32000
			, SKILL_TIME_5007_2 = 32000
			, SKILL_TIME_5007_3 = 32000
			, SKILL_TIME_5007_4 = 31000
			, SKILL_TIME_5007_5 = 35000;
	
	static final int
			  SKILL_TIME_5008 = 30000
			, HIT_TIME_5008 = 10000
			, EFFECT_PERIOD_5008 = 15000;	// skills/5000-5099.xml <effect time=***>

	/** ************************************ Initial Functions ************************************* */

	/**
	 * Empty constructor Does nothing
	 */
	private FrintezzaManager()
	{
	//	_questName = "frintezza";
		_state = new GrandBossState(_bossId);

//		if (registerZone(/*this,*/ *****,*****,****) == null)		//[JOJO]
//			_log.warning("FrintezzaManager : Failed to load zone 'Last Imperial Tomb'");
	}

	/**
	 * initialize <b>this</b> Frintezza Manager
	 */
	@Override
	public void init()
	{
		_callForHelpInterval = 2000;

		_intervalOfRetarget = 10000;

		_intervalOfFrintezzaSongs = SKILL_TIME_5008;
	//	_intervalOfFrintezzaSongs = 30000;

		_intervalOfGhosts	=	60; 										//= Config.FWF_INTERVALOFNEXTMONSTER;
		_intervalOfBoss		=	Config.LIT_FIXINTERVALOFFRINTEZZA;			//= Config.FWF_INTERVALOFFRINTEZZA;
		_appTimeOfBoss		=	Config.LIT_APPTIMEOFFRINTEZZA;				//= Config.FWF_INTERVALOFNEXTMONSTER;
		_activityTimeOfBoss	=	Config.LIT_ACTIVITYTIMEOFFRINTEZZA;			//= Config.FWF_ACTIVITYTIMEOFFRINTEZZA;

		// memo: Ō̍c̕][ƃtebT][͏dȂĂB
		if ((_zone = LastImperialTombManager.getInstance().getZone()) == null)
		{
			_log.warning("FrintezzaManager: Failed to load zone 'Last Imperial Tomb'");
		}
		if ((_hall = GrandBossManager.getInstance().getZoneByBossId(_bossId)) == null || _hall == _zone)
		{
			_log.warning("FrintezzaManager: Failed to load zone. bossId=29045");
			throw new AssertionError();
		}
		_hall.registerEntity(this);	// Override onEnter()

		// When state of Frintezza is not "NOTSPAWN", it begins interval.
		_log.info("FrintezzaManager : State of Frintezza is " + _state.getStateName() + ".");
		if (_state.getState() != GrandBossState.StateEnum.NOTSPAWN)
			setIntervalEndTask();

		_log.info("FrintezzaManager : Next spawn date of Frintezza is " + _state.respawnTimeFormat() + ".");
		_log.info("FrintezzaManager : Init FrintezzaManager.");
	}

	/**
	 * Creates a single spawn from the parameter values and returns the L2Spawn created
	 * 
	 * @param templateId
	 *            int value of the monster template id number
	 * @param x
	 *            int value of the X position
	 * @param y
	 *            int value of the Y position
	 * @param z
	 *            int value of the Z position
	 * @param heading
	 *            int value of where is the monster facing to...
	 * @param respawnDelay
	 *            int value of the respawn of this L2Spawn. [JOJO]not respawn if 0
	 * @return L2Spawn created
	 */
	/*private*/ L2Spawn createNewSpawn(int templateId, int x, int y, int z, int heading, int respawnDelay)
	{
		L2Spawn tempSpawn = null;

		L2NpcTemplate template1;

		try
		{
			template1 = NpcTable.getInstance().getTemplate(templateId);
			tempSpawn = new L2Spawn(template1);

			tempSpawn.setLocx(x);
			tempSpawn.setLocy(y);
			tempSpawn.setLocz(z);
			tempSpawn.setHeading(heading);
			tempSpawn.setAmount(1);
			tempSpawn.setRespawnDelay(respawnDelay);
			if (respawnDelay == 0) tempSpawn.stopRespawn();		//[JOJO] ghostȊOׂ
			else                   tempSpawn.startRespawn();	//[JOJO] ghost̂
		}
		catch (Exception e)
		{
			_log.warning(e.getMessage());
		}
		return tempSpawn;
	}

	/** ************************ Starting the battle with Frintezza + co. ***************************** */

	/**
	 * setting Scarlet Van Halisha spawn task which also starts the whole Frintezza battle.
	 */
	private/*public*/ void setScarletSpawnTask()
	{
		// When no one invaded the lair, nothing is done.
		if (LastImperialTombManager.getInstance().getPlayersInside().size() >= 1 && _state.getState() == GrandBossState.StateEnum.NOTSPAWN && _monsterSpawnTask == null
				/*[JOJO]*/&& teleCube == null)
		{
			if (_appTimeOfBoss < 180000) _appTimeOfBoss = 180000;
			_monsterSpawnTask = ThreadPoolManager.getInstance().scheduleGeneral(new ScarletWeakSpawn(), _appTimeOfBoss - 180000);
			_zone.broadcastPacket(new CreatureSay(0, SystemChatChannelId.Chat_Shout,
					"tebT e|[^[", (_appTimeOfBoss / 60000) + "ɃtebTloꂵ܂B"));
		}
	}

	/**
	 * Shows a movie to the players in the lair.
	 * 
	 * @param target -
	 *            L2Npc target is the center of this movie
	 * @param dist -
	 *            int distance from target
	 * @param yaw -
	 *            angle of movie (north = 90, south = 270, east = 0 , west = 180)
	 * @param pitch -
	 *            pitch > 0 looks up / pitch < 0 looks down
	 * @param time -
	 *            fast ++ or slow -- depends on the value
	 * @param duration -
	 *            How long to watch the movie
	 * @param socialAction -
	 *            1,2,3 social actions / other values do nothing
	 */

	void showSocialActionMovie(L2Npc target, int dist, int yaw, int pitch, int time, int duration, int socialAction)
	{
		showSocialActionMovie(target, dist, yaw, pitch, time, duration, socialAction, true);
	}
	void showSocialActionMovie(L2Npc target, int dist, int yaw, int pitch, int time, int duration, int socialAction, boolean closestBoss)
	{
		duration = 60000;	//(^_^)
		if (target == null)
			return;

		if ( target.getX() != target.getSpawn().getLocx()
		  || target.getY() != target.getSpawn().getLocy() )
		{
			if (horizontalDistance(CAMERA_X, CAMERA_Y, target.getX(), target.getY()) >= CAMERA_R)
				yaw = calcCameraYaw(CAMERA_X, CAMERA_Y, target.getX(), target.getY());
			else
				for (;;)
				{
					double a = Math.toRadians((180 + 360 - yaw) % 360);
					double d = (256 + dist) * Math.cos(Math.toRadians(pitch));
					int x = target.getX() + (int) Math.round(d * Math.cos(a));
					int y = target.getY() + (int) Math.round(d * Math.sin(a));
					int r = horizontalDistance(CAMERA_X, CAMERA_Y, x, y);
					if (r < CAMERA_R)
						break;
					if ((pitch += 10) > 89)
					{
						pitch = 89;
						break;
					}
				}
		}

		// set camera.
		for (L2Character ch : _hall.getCharactersInside().values())
		{
			if (ch instanceof L2PcInstance)
			{
				L2PcInstance pc = (L2PcInstance)ch;
				if (pc.isOnline() == 1)
				{
					L2Object tt = null; //temporary target
					if (! isIdle(pc))
					{
						setIdle(pc);
						pc.setTarget(null);
					}
					if (pc.getPlanDistanceSq(target) <= 6502500)
					{
						pc.enterMovieMode();
						pc.specialCamera(target, dist, yaw, pitch, time, duration);
					}
					else if (closestBoss && (tt = chooseClosest(pc, 6502500, frintezza, weakScarlet, strongScarlet)) != null)
					{
						pc.enterMovieMode();
						int yaw2 = calcCameraYaw(CAMERA_X, CAMERA_Y, tt.getX(), tt.getY());
						int pitch2 = calcCameraPitch(CAMERA_X, CAMERA_Y, CAMERA_Z, tt.getX(), tt.getY(), tt.getZ());
						pc.specialCamera(tt, 0, yaw2, pitch2, 0, duration);
					}
					else
					{
						pc.enterMovieMode();
						int yaw2 = calcCameraYaw(pc.getX(), pc.getY(), target.getX(), target.getY());
						int pitch2 = calcCameraPitch(pc.getX(), pc.getY(), pc.getZ(), target.getX(), target.getY(), target.getZ());
						pc.specialCamera(pc, 0, yaw2, pitch2, 0, duration);
					}
				}
			}
		}

		// do social.
		if (socialAction > 0 && socialAction < 5)
		{
			_hall.broadcastPacket(new SocialAction(target.getObjectId(), socialAction));
	//		target.broadcastPacket(new SocialAction(target.getObjectId(), socialAction));
		}
	}

	L2Object chooseClosest(L2PcInstance pc, long max, L2Object ... targets)
	{
		if (targets == null)
			return null;
		L2Object result = null;
		for (L2Object ch : targets)
		{
			if (ch == null)
				continue;
			long ll;
			if ((ll = horizontalDistance(pc.getX(), pc.getY(), ch.getX(), ch.getY())) < max)
			{
				max = ll;
				result = ch;
			}
		}
		return result;
	}

	/**
	 * +tebT̊ÕvC[Iɕֈړ.
	 * +S[r[[hɂ.
	 * -I noticed that if the players do not stand at a certain position, they can not watch the entire movie, so I set them to the center during the entire
	 * -movie.
	 */

	void teleportToStart()
	{
		teleportToStart(FRINTEZZA_X, FRINTEZZA_Y, FRINTEZZA_Z);
	}
	void teleportToStart(int tx, int ty, int tz)
	{
		for (L2PcInstance pc : getPlayersInside())
		{
			if (! _hall.isInsideZone(pc))
			{
				double r = Rnd.get(500, 1000);
				double a = MathLib.TWO_PI * Rnd.nextDouble();
				int x = SCARLET_X + (int)(r * Math.cos(a));
				int y = SCARLET_Y + (int)(r * Math.sin(a));
				int z = SCARLET_Z;
				_zone.setZoneDisable();
				pc.teleToLocation(x, y, z);
			}
			pc.enterMovieMode();
			int yaw2 = calcCameraYaw(pc.getX(), pc.getY(), tx, ty);
			int pitch2 = calcCameraPitch(pc.getX(), pc.getY(), pc.getZ(), tx, ty, tz);
//			int pitch2 = calcCameraPitch(CAMERA_X, CAMERA_Y, CAMERA_Z, tx, ty, tz);
			pc.specialCamera(pc, 0, yaw2, pitch2, 0, 60000);
		}
		ThreadPoolManager.getInstance().scheduleGeneral(new Runnable(){
			public void run() { _zone.setZoneEnable(); }
		}, 30000);
	}

	/** ************************** Initialize a movie and spawn the monsters *********************** */

	/**
	 * Spawns Frintezza, the weak version of Scarlet Van Halisha, the minions, and all that is shown in a movie to the observing players.
	 */

	class ScarletWeakSpawn implements Runnable
	{
		private int	_taskId = 0;
		private L2MonsterInstance _frintezzaDummy, _overheadDummy, _portraitDummy1, _portraitDummy3, _scarletDummy;	//Jp_~[

		private void next(int taskId, long delay)
		{
			_taskId = taskId;
			ThreadPoolManager.getInstance().scheduleGeneral(this, delay);
		}

		public void run()
		{
		 L2Skill skill;
		 try {
			switch (_taskId)
			{
			case 0:
			case -180:
				_scarletType = 1;
				next(-120, 60000);
				_zone.broadcastPacket(new ExShowScreenMessage("RO", 10000));
				break;
			case -120:
				next(-60, 60000);
				_zone.broadcastPacket(new ExShowScreenMessage("QO", 10000));
				break;
			case -60:
				next(-12, 48000);
				_zone.broadcastPacket(new ExShowScreenMessage("PO", 10000));
				break;
			case -12:
				next(1, 12000);
				_zone.broadcastPacket(new Earthquake(CENTER_X, CENTER_Y, CENTER_Z, 45, 15));
				break;
			case 1:
				frintezza = (L2GrandBossInstance) createNewSpawn(29045, FRINTEZZA_X, FRINTEZZA_Y, FRINTEZZA_Z, 16048, 0).doSpawn();
				frintezza.setIsInSocialAction(true);	//L2J_JP
				frintezza.setIsOverloaded(true);		//[JOJO] +dʃI[o[ŕȂ
				
				portrait1 = (L2MonsterInstance) createNewSpawn(29048, 175833, -87165, -4972, 35048, 0).doSpawn();
				portrait2 = (L2MonsterInstance) createNewSpawn(29049, 175876, -88713, -4972, 28205, 0).doSpawn();
				portrait3 = (L2MonsterInstance) createNewSpawn(29048, 172608, -88702, -4972, 64817, 0).doSpawn();
				portrait4 = (L2MonsterInstance) createNewSpawn(29049, 172634, -87165, -4972, 57730, 0).doSpawn();
				portrait1.setIsImmobilized(true);
				portrait2.setIsImmobilized(true);
				portrait3.setIsImmobilized(true);
				portrait4.setIsImmobilized(true);
				
				_frintezzaDummy = (L2MonsterInstance) createNewSpawn(29052, FRINTEZZA_X, FRINTEZZA_Y, FRINTEZZA_Z, 16384, 0).doSpawn();	//tebTp(z[x[X)
				_frintezzaDummy.setIsImmobilized(true);
				_frintezzaDummy.setIsInvul(true);
				_frintezzaDummy.setCollisionHeight(frintezza.getCollisionHeight());
				_hall.broadcastPacket(new NpcInfo(_frintezzaDummy, null));
				
				_overheadDummy = (L2MonsterInstance) createNewSpawn(29052, SCARLET_X, SCARLET_Y, SCARLET_Z, 16048, 0).doSpawn();	//VBep(600)
				_overheadDummy.setIsImmobilized(true);
				_overheadDummy.setIsInvul(true);
				_overheadDummy.setCollisionHeight(600);	//(^_^)v
				_hall.broadcastPacket(new NpcInfo(_overheadDummy, null));
				
				_portraitDummy1 = (L2MonsterInstance) createNewSpawn(29052, 172450, -87890, -5089, 16048, 0).doSpawn(); //GBep(Pۑ)
				_portraitDummy1.setIsImmobilized(true);
				_portraitDummy1.setIsInvul(true);
				
				_portraitDummy3 = (L2MonsterInstance) createNewSpawn(29052, 176012, -87890, -5089, 16048, 0).doSpawn(); //GBep(Rۑ)
				_portraitDummy3.setIsImmobilized(true);
				_portraitDummy3.setIsInvul(true);
				
				_scarletDummy = (L2MonsterInstance) createNewSpawn(29053, SCARLET_X, SCARLET_Y, SCARLET_Z, 16384, 0).doSpawn(); //̃VbNp(sb`[}Eh)
				_scarletDummy.setIsImmobilized(true);
				_scarletDummy.setIsInvul(true);
				
				LastImperialTombManager.getInstance().cleanUpMobs();
				DoorTable.getInstance().getDoor(25150046).closeMe();
				teleportToStart(CENTER_X, CENTER_Y, -2500/*_overheadDummy*/);
				
				updateKnownList(frintezza);
				updateKnownList(_frintezzaDummy);
				updateKnownList(_scarletDummy);
				updateKnownList(_overheadDummy);
				updateKnownList(_portraitDummy1);
				updateKnownList(_portraitDummy3);
				
				next(2, 1000);
				
				_state.setRespawnDate(_intervalOfBoss);
				_state.setState(GrandBossState.StateEnum.ALIVE);
				_state.update();
				_log.info("FrintezzaManager : Spawn Frintezza.");
				
				break;
			case 2:
				showSocialActionMovie(_overheadDummy, 0, 75, -89, 0, 10000, 0, false);
				next(3, 100);
				break;
			case 3:
				showSocialActionMovie(_overheadDummy, 300, 90, -10, 7000, 10000, 0);
				next(4, 6500);
				break;
			case 4:
				showSocialActionMovie(_frintezzaDummy, 1800, 90, 8, 7000, 10000, 0);
				next(5, 2500);
				break;
			case 5:
				showSocialActionMovie(_frintezzaDummy, 140, 90, 10, /*Ȃ*/7000, 10000, 0);
				next(6, 2500);
				break;
			case 6:
				showSocialActionMovie(frintezza, 40, 75, -10, 0, 10000, 0);
				next(7, 100);
				break;
			case 7:
				// do social.
				_hall.broadcastPacket(new SocialAction(frintezza.getObjectId(), /*΂*/2));
				next(8, 7400);
				break;
			case 8:
				for (L2PcInstance pc : getPlayersInside())
				{
					if (pc.getX() < CENTER_X)
						pc.specialCamera(_portraitDummy1, 1000, 118, 0, 0, 10000);	//Pۑ
					else
						pc.specialCamera(_portraitDummy3, 1000, 62, 0, 0, 10000);	//Rۑ
				}
				_frintezzaDummy.deleteMe(); _frintezzaDummy = null;
				ghost2 = (L2MonsterInstance) createNewSpawn(29051, 175876, -88713, -4972, 28205, _intervalOfGhosts).doSpawn();
				ghost3 = (L2MonsterInstance) createNewSpawn(29051, 172608, -88702, -4972, 64817, _intervalOfGhosts).doSpawn();
				ghost2.setIsImmobilized(true);
				ghost3.setIsImmobilized(true);
				next(9, 1800);
				break;
			case 9:
				ghost1 = (L2MonsterInstance) createNewSpawn(29050, 175833, -87165, -4972, 35048, _intervalOfGhosts).doSpawn();
				ghost4 = (L2MonsterInstance) createNewSpawn(29050, 172634, -87165, -4972, 57730, _intervalOfGhosts).doSpawn();
				ghost1.setIsImmobilized(true);
				ghost4.setIsImmobilized(true);
				next(9001, 700);
				break;
			case 9001:
				// do social.
				_hall.broadcastPacket(new SocialAction(ghost2.getObjectId(), 1));
				_hall.broadcastPacket(new SocialAction(ghost3.getObjectId(), 1));
				next(9002, 700);
				break;
			case 9002:
				_hall.broadcastPacket(new SocialAction(ghost1.getObjectId(), 1));
				_hall.broadcastPacket(new SocialAction(ghost4.getObjectId(), 1));
				next(10, 2300);
				break;
			case 10:
				showSocialActionMovie(frintezza, 240, 90, 0, 0, 10000, 0);
				next(11, 10);
				break;
			case 11:
				showSocialActionMovie(frintezza,240, 90, 25, 5500, 10000, /**/3); //social time:6900, (5000+200+1000=6200)
				next(12, 5000);
				weakScarlet = (L2GrandBossInstance) createNewSpawn(29046, SCARLET_X, SCARLET_Y, SCARLET_Z, 16384, 0).doSpawn(true);	//(*1)̂܂Ȃ
				break;
			case 12:
				showSocialActionMovie(frintezza, 100, 195, 35, 0, 10000, 0);
				next(13, 200);
				break;
			case 13:
				showSocialActionMovie(frintezza, 100, 195, 35, 0, 10000, 0);
				next(14, 1000);
				break;
			case 14:
				_hall.broadcastPacket(new MagicSkillUse(frintezza, frintezza, 5006, 1, 34000, 0));
				showSocialActionMovie(frintezza, 120, 180, 45, 1500, 10000, 0);
				next(16, 1500);
				weakScarlet.deleteMe();	//(*1)
				break;
			case 16:
				showSocialActionMovie(frintezza, 520, 135, 45, 8000, 10000, 0);
				next(17, 7500);
				break;
			case 17:
				showSocialActionMovie(frintezza, 1500, 110, 25, 10000, 15000, 0);
				next(18, 9500);
				break;
			case 18:
				skill = SkillTable.getInstance().getInfo(/*̃VbN*/5004, 1);
				_hall.broadcastPacket(new MagicSkillUse(_scarletDummy, _scarletDummy, skill.getDisplayId(), skill.getLevel(), skill.getHitTime(), skill.getReuseDelay()));
				skill = null;
				showSocialActionMovie(_overheadDummy, 930, 160, -20, 1, 10000, 0);
				next(19, 4000);
				break;
			case 19:
				weakScarlet = (L2GrandBossInstance) createNewSpawn(29046, SCARLET_X, SCARLET_Y, SCARLET_Z, 16384, 0).doSpawn(true);
				weakScarlet.setIsImmobilized(true);
				weakScarlet.setIsInSocialAction(true);
				weakScarlet.disableSkill(/*f[1 ϐg*/5017);
				weakScarlet.disableSkill(/*f[* @w*/5018);
				next(1901, 2000);
				break;
			case 1901:
				showSocialActionMovie(_scarletDummy, 800, 160, 5, 500, 10000, 0);
				next(1902, 1200);
				break;
			case 1902:
				flickPlayers(weakScarlet, 300);
				next(20, 6000);
				break;
			case 20:
				for (L2PcInstance pc : getPlayersInside())
				{
					L2Object target = weakScarlet;
					int yaw = calcCameraYaw(pc.getX(), pc.getY(), target.getX(), target.getY());
					pc.specialCamera(target, 800, yaw, 10, 300, 4000);
				}
				next(21, 3000);
				break;
			case 21:
				// reset camera.
				for (L2PcInstance pc : getPlayersInside())
				{
					L2Object target = weakScarlet;
					int yaw = calcCameraYaw(pc.getX(), pc.getY(), target.getX(), target.getY());
					pc.specialCamera(pc, 0, yaw, 10, 0, 100);
					pc.leaveMovieMode();
					pc.enableAllSkills();
				}
				
				next(99, 500);
				break;
			case 99:
				ghost1.setIsImmobilized(false);
				ghost2.setIsImmobilized(false);
				ghost3.setIsImmobilized(false);
				ghost4.setIsImmobilized(false);
				npcSpawned(ghost1);
				npcSpawned(ghost2);
				npcSpawned(ghost3);
				npcSpawned(ghost4);
				
				L2Spawn.addSpawnListener(FrintezzaManager.getInstance());	//+[JOJO] call npcSpawned(...) if monstr spawned.
				
				weakScarlet.setShowSummonAnimation(false);
				weakScarlet.abortCast();
				frintezza.abortCast();
				new SetMobilisedBoss(weakScarlet).run();
				new SetMobilisedBoss(frintezza).run();
				
				// Start random attacks on players for Frintezza
				ThreadPoolManager.getInstance().scheduleGeneral(new ReTarget(frintezza), _intervalOfRetarget);
				
				// Start random attacks on players for Scarlet
				ThreadPoolManager.getInstance().scheduleGeneral(new ReTarget(weakScarlet), _intervalOfRetarget + 16);
				weakScarlet.setRunning();
				
				ThreadPoolManager.getInstance().scheduleGeneral(music = new Music(), Rnd.get(_intervalOfFrintezzaSongs));
				
				startAttackListeners();
				
				// set delete task.
				_activityTimeEndTask = ThreadPoolManager.getInstance().scheduleGeneral(new ActivityTimeEnd(), _activityTimeOfBoss);
				
				if (_frintezzaDummy != null) { _frintezzaDummy.deleteMe(); _frintezzaDummy = null; }
				if (_overheadDummy  != null) { _overheadDummy.deleteMe();  _overheadDummy  = null; }
				if (_portraitDummy1 != null) { _portraitDummy1.deleteMe(); _portraitDummy1 = null; }
				if (_portraitDummy3 != null) { _portraitDummy3.deleteMe(); _portraitDummy3 = null; }
				if (_scarletDummy   != null) { _scarletDummy.deleteMe();   _scarletDummy   = null; }
				break;
			
			default:
				TRACE("__BASENAME__:__LINE__: 'case " + _taskId + ":' invalid");
				throw new AssertionError("'case " + _taskId + ":' invalid");
			} //~switch
		 }
		 catch (Exception e) { e.printStackTrace(); }
		} //~run
	}

	/** ******************************************************************************************** */

	/*************************************************************************************************/
	/** Frintezza's songs, needed special implementation since core doesn't support 3 stage skills   */
	/*************************************************************************************************/

	/**
	 * @author Darki699
	 *  Three stages of casts:
	 *      1. Song, cast on Frintezza, for the music to play (skill 5007, levels 1-5) Each level is a different tune =)
	 *      2. Visual Effect, cast on targets, to show the effect (skill 5008, levels 1-5) Each level has a different animation effect and different targets and purpose
	 *      3. Actual skill, which is different since NCSoft has a different skill system.
	 *  I used other skill Ids to implement these effects: song effects:
	 *      1. skill 1217 - Greater Heal (5007,1 -> 5008,1 -> 1217,33)
	 *      2. skill 1204 - Wind Walk (5007,2 -> 5008,2 -> 1204,2)
	 *      3. skill 1086 - Haste Buff (5007,3 -> 5008,3 -> 1086,2)
	 *      4. skill 406 - Angelic Icon (5007,4 -> 5008,4 -> 406,3 only gainHp*0.2 func added)
	 *      5. no skill only immobilize (5007,5 -> 5008,5 -> dance+stun animation + Immobilizes)
	 */

	/*private*/ class Music implements Runnable
	{
		private int _song = 0;
		private long _pauseTime = 0;	//+[JOJO]
		private SongEffectLaunched _songEffectLaunched;	//+[JOJO]
		
		public void run()
		{
			if (frintezza == null)
				return;
			
			if (_pauseTime > 0)	//[JOJO]
			{
				long time = _pauseTime;	//save _pauseTime
				pause(0);				//set _pauseTime=0
				ThreadPoolManager.getInstance().scheduleGeneral(this, time);
				return;
			}

			if (frintezza.IsInSocialAction())	//[JOJO] wait until social finish.
			{
				_song = 0;
				ThreadPoolManager.getInstance().scheduleGeneral(this, _intervalOfFrintezzaSongs);
				return;
			}

			int song = getSong();

			double mpConsume = (song - 1) * 10;
			if (frintezza.getStatus().getCurrentMp() < mpConsume)
			{
				_song = 0;
				ThreadPoolManager.getInstance().scheduleGeneral(this, _intervalOfFrintezzaSongs);
				return;
			}
			frintezza.getStatus().reduceMp(mpConsume);

			_hall.broadcastPacket(new MagicSkillUse(frintezza, frintezza, 5007, song, _intervalOfFrintezzaSongs, 0));
		//	frintezza.broadcastPacket(new MagicSkillUse(frintezza, frintezza, 5007, song, _intervalOfFrintezzaSongs, 0), 10000);

			int currentHp = (int) frintezza.getStatus().getCurrentHp();
			long effectEndTime = System.currentTimeMillis() + _intervalOfFrintezzaSongs;	//[JOJO]

			// Launch the song's effects (they start about 10 seconds after he starts to play)
			ThreadPoolManager.getInstance().scheduleGeneral(_songEffectLaunched = new SongEffectLaunched(getSongTargets(song), song, currentHp, effectEndTime), HIT_TIME_5008/*10000*/);

			// Schedule a new song to be played in 30-40 seconds...
			ThreadPoolManager.getInstance().scheduleGeneral(this, _intervalOfFrintezzaSongs + Rnd.get(10000));
		//	ThreadPoolManager.getInstance().scheduleGeneral(new Music(), _intervalOfFrintezzaSongs + Rnd.get(10000));
			if (song != _song) {
				_song = song;
				_hall.broadcastPacket(new ExShowScreenMessage(MUSIC_TITLE[song], /*time=>*/10000));
			}
		}

		/**
		 * Depending on the song, returns the song's targets (either mobs or players)
		 * 
		 * @param songId
		 *            (1-5 songs)
		 * @return L2Object[] targets
		 */
		private L2Object[] getSongTargets(int songId)
		{

			List<L2Object> targets = new FastList<L2Object>();

			if (songId < 4) // Target is the minions
			{

				if (weakScarlet != null && !weakScarlet.isDead())
					targets.add(weakScarlet);

				if (strongScarlet != null && !strongScarlet.isDead())
					targets.add(strongScarlet);

				if (portrait1 != null && !portrait1.isDead())
					targets.add(portrait1);

				if (portrait2 != null && !portrait2.isDead())
					targets.add(portrait2);

				if (portrait3 != null && !portrait3.isDead())
					targets.add(portrait3);

				if (portrait4 != null && !portrait4.isDead())
					targets.add(portrait4);

				if (ghost1 != null && !ghost1.isDead())
					targets.add(ghost1);

				if (ghost2 != null && !ghost2.isDead())
					targets.add(ghost2);

				if (ghost3 != null && !ghost3.isDead())
					targets.add(ghost3);

				if (ghost4 != null && !ghost4.isDead())
					targets.add(ghost4);

				targets.add(frintezza);
			}

			else
			// Target is the players
			{

				for (L2PcInstance pc : getPlayersInside())
				{
					if (!pc.isDead())
						targets.add(pc);
				}
			}

			return targets.toArray(new L2Object[targets.size()]);
		}

		/**
		 * returns the chosen symphony for Frintezza to play If the minions are injured he has 40% to play a healing song If they are all dead, he will only
		 * play harmful player symphonies
		 * 
		 * @return
		 */

		private int getSong()
		{
			if (minionsNeedHeal())
				return 1;
		//	else if (minionsAreDead())
		//		return Rnd.get(4, 6);
			int n = _scarletType == 3 ? 5
			      : _scarletType == 2 ? 7
			      :                    11;
			if (_song == 5) n *= 2;
			if (Rnd.get(n) == 0) return 5; //f̃}YJ
			return Rnd.get(2, 4);
		}

		/**
		 * Checks if Frintezza's minions need heal (only major minions are checked) Return a "need heal" = true only 40% of the time
		 * 
		 * @return boolean value true if need to play a healing minion song
		 */
		private boolean minionsNeedHeal()
		{
			boolean returnValue = false;

			if (weakScarlet != null && !weakScarlet.isAlikeDead() && weakScarlet.getStatus().getCurrentHp() < weakScarlet.getMaxHp() * 2 / 3)

				returnValue = true;

			else if (strongScarlet != null && !strongScarlet.isAlikeDead() && strongScarlet.getStatus().getCurrentHp() < strongScarlet.getMaxHp() * 2 / 3)

				returnValue = true;

			else if ((portrait1 != null && !portrait1.isAlikeDead() && portrait1.getStatus().getCurrentHp() < portrait1.getMaxHp() / 3)
					|| (portrait2 != null && !portrait2.isAlikeDead() && portrait2.getStatus().getCurrentHp() < portrait2.getMaxHp() / 3)
					|| (portrait3 != null && !portrait3.isAlikeDead() && portrait3.getStatus().getCurrentHp() < portrait3.getMaxHp() / 3)
					|| (portrait4 != null && !portrait4.isAlikeDead() && portrait4.getStatus().getCurrentHp() < portrait4.getMaxHp() / 3))

				returnValue = true;

			if (returnValue && Rnd.get(100) > 40) // 40% to heal minions when needed.
				return false;

			return returnValue;
		}

		public void pause(long time)	//+[JOJO]
		{
			_pauseTime = time;
			_song = 0;
			if (_songEffectLaunched != null)
			{
				_songEffectLaunched.cancel();
				long delay = 0L;
				for (L2Character ch : _hall.getCharactersInside().values())
				{
					if (ch instanceof L2PcInstance)
					{
						L2PcInstance pc = (L2PcInstance)ch;
						Func func = getDecreaseRegHpFunc();
						if (isDecreaseRegHp(pc, func))
							ThreadPoolManager.getInstance().scheduleGeneral(new exitDecreaseRegHp(pc, func), delay += 333);
						if (isStunDanceEffect(pc))
							ThreadPoolManager.getInstance().scheduleGeneral(new exitStunDanceEffect(pc), delay += 333);
					}
				}
			}
		}
	}

	/**
	 * The song was played, this class checks it's affects (if any)
	 * 
	 * @author Darki699
	 */
	private class SongEffectLaunched implements Runnable
	{
		private final L2Object[]	_targets;

		private final int		_song;
		private /*final*/ long		_endTime;
		private int				_currentHp;

		/**
		 * Constructor
		 * 
		 * @param targets -
		 *            song's targets L2Object[]
		 * @param song -
		 *            song id 1-5
		 * @param previousHp -
		 *            Frintezza's HP when he started to play
		 * @param currentTimeOfSong -
		 *            skills during music play are consecutive, repeating
		 */
		public SongEffectLaunched(L2Object[] targets, int song, int currentHp, long endTime)
		{
			_targets = targets;
			_song = song;
			_currentHp = currentHp;
			_endTime = endTime;
		}

		public void run()
		{
			if (frintezza == null)
				return;

			// If the song time is over stop this loop
			if (System.currentTimeMillis() > _endTime)
				return;

			// Skills are consecutive, so call them again
			ThreadPoolManager.getInstance().scheduleGeneral(this, _intervalOfFrintezzaSongs / 10);

			// If Frintezza got injured harder than his regen rate, do not launch the song.
			int previousHp = _currentHp;
			_currentHp = (int) frintezza.getStatus().getCurrentHp();
			if (_currentHp < previousHp)
			{
				L2Object frintezzaTarget = frintezza.getTarget();

				if (frintezzaTarget != null && frintezzaTarget instanceof L2Character)
					callMinionsToAssist((L2Character) frintezzaTarget, 200);

				return;
			}

			for (L2Object target : _targets)
			{
				if (target == null || !(target instanceof L2Character))
					continue;

				L2Character cha = (L2Character) target;

				if (cha.isDead() || cha.isInvul())
					continue;

				// show the magic effect on the target - visual effect
				cha.broadcastPacket(new MagicSkillUse(frintezza, cha, 5008, _song, 0, 0), 10000);
			//	cha.broadcastPacket(new MagicSkillUse(frintezza, cha, 5008, _song, 2000, 0), 10000);

				// calculate the song's damage
				calculateSongEffects(cha);
			}
		}

		/**
		 * Calculates the music damage according to the current song played
		 * 
		 * @param target -
		 *            L2Character affected by the music
		 */
		private void calculateSongEffects(L2Character target)
		{
			if (target == null)
				return;
			try
			{
				L2Skill skill;

				switch (_song)
				{
				case 1: // Consecutive Heal : Greater Heal - on the monsters
					    // <q[t> : (1217,33O[^[ q[)  [monster]
					skill = SkillTable.getInstance().getInfo(1217, 33);
					frintezza.callSkill(skill, target);
					break;

				case 2: // Consecutive Dash : Wind Walk - monsters run faster
					    // <oF_bV+ёĐt> : (1204,2EBh EH[N)  [monster]
					skill = SkillTable.getInstance().getInfo(1204, 2);
					frintezza.callSkill(skill, target);
					break;

				case 3: // Affecting Atk Spd : Haste Buff - monsters attack faster
					    // <U/xt> : (1086,2wCXg)  [monster]
					skill = SkillTable.getInstance().getInfo(1086, 2);
					frintezza.callSkill(skill, target);
					break;

				case 4: // Offensive Skill: Decreases the effect of HP reg. on the players
					    // <uɎ󂯂HP񕜖@̌͂啝ɒቺ> : (ߒQ̃R[)+(mul order="0x30" stat="gainHp" val="0.2"/)  [player]
					if (Rnd.get(100) < 80) // 80% success not considering m.def + p.def ???
					{
						// Launch the skill on the target to decrease it's HP
						decreaseEffectOfHpReg(target);
					}
					break;

				case 5: // Offensive Skill: Immoblizes - dance+stun. Player is immoblized
					    // <uɎ̈ӎuƊ֌WȂxAȂ> : (f̃}YJ)+(ABNORMAL_EFFECT_DANCE_STUNNED)  [player]
					if (Rnd.get(100) < 80) // 80% success not considering m.def + p.def ???
					{
						startStunDanceEffect(target);
					}
					break;
				}
			}
			catch (RuntimeException e)
			{
				_log.warning(e.getMessage());
				e.printStackTrace();
			}
		}
		
		protected void cancel()	//+[JOJO]
		{
			_endTime = 0;
			frintezza.broadcastPacket(new MagicSkillCanceld(frintezza.getObjectId()));  // broadcast packet to stop animations client-side
		}
	}

	/**
	 * Decreases the HP Regeneration of the <b>target</b>
	 * 
	 * @param target
	 *            L2Character who's HP Regeneration is decreased.
	 */
	void decreaseEffectOfHpReg(L2Character target)
	{
		L2Skill skill = SkillTable.getInstance().getInfo(/*ߒQ̃R[*/5008, 4);

		if (target.getFirstEffect(skill) != null)	//[JOJO]
			return;

		frintezza.callSkill(skill, target);

		// send target the message, the skill was launched
		if (target instanceof L2PcInstance)
			target.getActingPlayer().sendPacket(new SystemMessage(SystemMessageId.YOU_FEEL_S1_EFFECT).addSkillName(skill));

		// Add stat funcs to the target
		target.addStatFunc(getDecreaseRegHpFunc());

		// Set exit timer for these stats
		ThreadPoolManager.getInstance().scheduleGeneral(new exitDecreaseRegHp(target, getDecreaseRegHpFunc()), getDebuffPeriod(skill, target));
	}

	/**
	 * Returns the duration of the <b>skill</b> on the <b>target</b>.
	 * 
	 * @param skill
	 *            L2Skill to calculate it's duration
	 * @param target
	 *            L2Character to calculate the duration on it
	 * @return int value of skill duration before exit
	 */
	private int getDebuffPeriod(L2Skill skill, L2Character target)
	{
		if (true) return EFFECT_PERIOD_5008;

		// This is usually returned, unless _debuffPeriod needs initialization
		if (_debuffPeriod != 0)
			return _debuffPeriod;

		// Initialize _debuffPeriod
		if (skill == null || target == null)
		{
			_debuffPeriod = 15000;

			return _debuffPeriod;
		}

//		for (L2Effect effect : skill.getEffects(frintezza, target))
//		{
//			if (effect == null)
//				continue;
//
//			_debuffPeriod = effect.getPeriod() * 1000;
//		}

		if (_debuffPeriod == 0)
			_debuffPeriod = 15000;

		// return _debuffPeriod which is now initialized
		return _debuffPeriod;
	}

	/**
	 * This function simulates the functions of "Angelic Icon". Takes the 5th function which is gainHp*0.2 and adds it to the skill id 5007, level 4 to decrease
	 * gainHP
	 * 
	 * @return <b>Func</b> the functions needed to decrease the Hp Regeneration from the targets
	 */
	protected/*private*/ Func getDecreaseRegHpFunc()
	{
//[]----------------------------------------
//		if (_DecreaseRegHp == null)
//			_DecreaseRegHp = new FuncMul(Stats.REGENERATE_HP_RATE, 0x30, FUNC_OWNER, 0.2, null);
//		return _DecreaseRegHp;
//--------------------------------------------
		// If the Func[] _DecreaseRegHp is null we initialize it.
		if (_DecreaseRegHp == null)
		{
			L2Skill skill = SkillTable.getInstance().getInfo(/*GWFbN A[R*/406, 3);

			for (L2Effect effect : skill.getEffects(frintezza, frintezza))
			{
				if (effect == null)
					continue;

				Func[] func = effect.getStatFuncs();

				if (func.length > 5)
					_DecreaseRegHp = func[5];	//<mul order="0x30" stat="gainHp" val="0.2"/> ̌vẐݎo

				effect.exit(); // We don't want to leave the effect on frintezza
			}
		}
		// Func _DecreaseRegHp is not null, so just return it ;]
		return _DecreaseRegHp;
	}
	
//[]----------------------------------------
//	private final FuncOwner FUNC_OWNER = new FuncOwner() {
//		@Override
//		public String getFuncOwnerName()
//		{
//			return null;
//		}
//		
//		@Override
//		public L2Skill getFuncOwnerSkill()
//		{
//			return null;
//		}
//	};
//--------------------------------------------

	/**
	 * Class made to exit the debuff effect of the DecreaseRegHp symphony
	 * 
	 * @author Darki699
	 */
	private class exitDecreaseRegHp implements Runnable
	{
		private final Func		_func;

		private final L2Character _char;

//		public exitDecreaseRegHp(L2Character character)	//[]
		public exitDecreaseRegHp(L2Character character, Func func)
		{
			_func = func;
			_char = character;
		}

		public void run()
		{
			if (_func != null && _char != null)
			{
				_char.removeStatFunc(_func);
			}
		}
	}
	
	protected boolean isDecreaseRegHp(L2Character target, Func func)	//+[JOJO]
	{
		L2Skill skill = SkillTable.getInstance().getInfo(/*ߒQ̃R[*/5008, 4);
		return target.getFirstEffect(skill) != null;
	}

	/**
	 * Further implementation into the core is needed. But this will do for now ;] Class needed to implement the start Frintezza dance+stun effect on a target.
	 * 
	 * @author Darki699
	 */

	void startStunDanceEffect(L2Character _effected)
	{
				//stun dance can be cast on L2PcInstance only
				if (!(_effected instanceof L2PcInstance))
					return;

				final L2Skill _skill = SkillTable.getInstance().getInfo(/*f̃}YJ*/5008, 5);

				if (_effected.getFirstEffect(_skill) != null)
					return;

				L2PcInstance effected = (L2PcInstance) _effected;
				if (effected.isInvul() || effected.getAppearance().getInvisible())
					return;

				// stop all actions
				setIdle(_effected);
				_effected.disableAllSkills();	//[JOJO]

				_effected.setTarget(null);

				// start the animation
				_effected.startAbnormalEffect(AbnormalEffect.DANCE_STUNNED);

				// add the effect icon
				_effected.callSkill(_skill, _effected);

				// send target the message
				if (_effected instanceof L2PcInstance)
					_effected.getActingPlayer().sendPacket(new SystemMessage(SystemMessageId.YOU_FEEL_S1_EFFECT).addSkillName(_skill));

				// set the cancel task for this effect
				ThreadPoolManager.getInstance().scheduleGeneral(new exitStunDanceEffect(_effected), getDebuffPeriod(_skill, _effected));
	}

	/**
	 * Ends the dance+stun effect on the target
	 * 
	 * @author Darki699
	 */
	private class exitStunDanceEffect implements Runnable
	{
		private final L2Character	_effected;

		public exitStunDanceEffect(L2Character target)
		{
			_effected = target;
		}

		public void run()
		{
			if (_effected == null)
				return;

			setActive(_effected);
			_effected.enableAllSkills();
		//	_effected.setIsImmobilized(false);

			_effected.stopAbnormalEffect(AbnormalEffect.DANCE_STUNNED);
		}
	}

	protected boolean isStunDanceEffect(L2Character target)	//+[JOJO]
	{
		return (target.getAbnormalEffects() & AbnormalEffect.DANCE_STUNNED.getMask()) != 0;
	}

	/** ************************** End of Frintezza's Musical effects ******************************** */

	/***********************************************************************************************************************************************************
	 * ****** M M PPPPPPP TTTTTTTTT Y Y /* MM MM P P T Y Y /* M M M M P P T Y Y /******* M M M M P P T Y /* M M M PPPPPPP T Y /* M M P T Y /* M M P T Y
	 * /******** M M P T Y /************************ Minion Control Attack + Respawn + Polymorph
	 **********************************************************************************************************************************************************/

	/**
	 * Initializes the Attack Listeners for <b>all</b> monsters in this zone. Sends a thread loop (tasks canceled ofcourse) with the mob to be listened to, and
	 * the amount of hate it sends to all other mobs regarding it's attacker.
	 */

	/*private*/ void startAttackListeners()
	{
		// Set listeners for the Ghosts.
		ThreadPoolManager.getInstance().scheduleGeneral(new attackerListener(ghost1, 1), Rnd.get(2000));

		ThreadPoolManager.getInstance().scheduleGeneral(new attackerListener(ghost2, 1), Rnd.get(2000));

		ThreadPoolManager.getInstance().scheduleGeneral(new attackerListener(ghost3, 1), Rnd.get(2000));

		ThreadPoolManager.getInstance().scheduleGeneral(new attackerListener(ghost4, 1), Rnd.get(2000));

		// Set listeners for the Portraits.
		ThreadPoolManager.getInstance().scheduleGeneral(new attackerListener(portrait1, 50), Rnd.get(2000));

		ThreadPoolManager.getInstance().scheduleGeneral(new attackerListener(portrait2, 50), Rnd.get(2000));

		ThreadPoolManager.getInstance().scheduleGeneral(new attackerListener(portrait3, 50), Rnd.get(2000));

		ThreadPoolManager.getInstance().scheduleGeneral(new attackerListener(portrait4, 50), Rnd.get(2000));

		// Set a listener for Frintezza.
		ThreadPoolManager.getInstance().scheduleGeneral(new attackerListener(frintezza, 200), Rnd.get(2000));

		// Set a listener for the weaker version of Scarlet Van Halisha.
		ThreadPoolManager.getInstance().scheduleGeneral(new attackerListener(weakScarlet, 100), Rnd.get(2000));

		// Note that Scarlet's strong version isn't spawned yet. An attack listener for it will
		// be added when and if he's spawned.
	}

	/**
	 * Class is recalled at an interval for a monster's life time. Once the monster is <b>deleted</b> (null), this class is not called anymore If the monster
	 * is <b>dead</b>, this class is still called at the interval, but it does nothing until next respawn. If the monster is <b>alive</b> and is being
	 * attacked, it "tells" the other monsters that it's attacked.
	 * 
	 * @author Darki699
	 */
	private class attackerListener implements Runnable
	{
		private final L2MonsterInstance	_mob;

		private final int			_aggroDamage;

		public attackerListener(L2MonsterInstance controller, int hate)
		{
			_mob = controller;
			_aggroDamage = hate;
		}

		public void run()
		{
			// If the monster is deleted, return.
			if (_mob == null)
				return;
			if (_mob.isDead() || ! _mob.isVisible())
			{
				if (_mob.getSpawn().isRespawnable())
				{
					// If the ghost is dead, we do nothing until next respawn
					ThreadPoolManager.getInstance().scheduleGeneral(this, _callForHelpInterval + _mob.getSpawn().getRespawnDelay());
					return;
				}
				else
				{
					// If the boss is dead, exit listener.
					portraitDeadCheck(_mob);
					/*_mob = null;*/
					return;
				}
			}
			
			if (_mob == weakScarlet)
				weakScarletHpListener();
			
			// Set next listener.
			ThreadPoolManager.getInstance().scheduleGeneral(this, _callForHelpInterval + Rnd.get(500));
			
			// If the monster is morphing or socialing, sleep until next listener
			if (isIdle(_mob))
				return;
			
			// Tell the other mobs "I'm attacked"
			L2Object target = _mob.getTarget();
			
			if (target != null && target instanceof L2Character && !((L2Character) target).isDead())
				callMinionsToAssist((L2Character) target, _aggroDamage + _aggroDamage * (_mob.getMaxHp() - (int)_mob.getCurrentHp()) / _mob.getMaxHp());
			
			// Now set the mob's Target to the most hated:
			L2Character mostHated = _mob.getMostHated();
			
			if (mostHated != null)
			{
				_mob.setTarget(mostHated);
			}
		}
	}

	/**
	 * + [JOJO] G悪SnV uX߂B
	 * - If the dead boss is a Portrait, we delete it from the world, and it's ghost as well If the dead boss is Scarlet or Frintezza, we do a bossesAreDead()
	 * - check to see if both Frintezza and Scarlet are dead.
	 * 
	 * @param mob -
	 *          + L2MonsterInstance that is (or is set as) dead. [JOJO]
	 *          - L2BossInstance that is (or is set as) dead.
	 */

	/*public*/ void portraitDeadCheck(L2MonsterInstance mob)
	{
		if (mob == null)
			return;

		L2MonsterInstance ghost = null;

		if (mob == portrait1)
		{
			portrait1 = null;
			ghost = ghost1;
			ghost1 = null;
		}
		else if (mob == portrait2)
		{
			portrait2 = null;
			ghost = ghost2;
			ghost2 = null;
		}
		else if (mob == portrait3)
		{
			portrait3 = null;
			ghost = ghost3;
			ghost3 = null;
		}
		else if (mob == portrait4)
		{
			portrait4 = null;
			ghost = ghost4;
			ghost4 = null;
		}
		else
			throw new AssertionError("mob is not portrait"); /*return;*/	//+[JOJO] GȊO͖

		// Try to delete the portrait.
		try
		{
			/*mob.decayMe();*/
			mob.deleteMe();
			mob = null;
		}
		catch (RuntimeException e)
		{
			_log.warning(e.getMessage());
			if (DEBUG) e.printStackTrace();
		}

		// Try to delete the portraits ghost.
		if (ghost != null)
		{
			try
			{
				ghost.getSpawn().stopRespawn();	//+[JOJO]
				/*ghost.decayMe();*/
				ghost.deleteMe();
				ghost = null;
			}
			catch (RuntimeException e)
			{
				_log.warning(e.getMessage());
				if (DEBUG) e.printStackTrace();
			}
		}
	}

	/**
	 * controls the assistance for all 3 bosses: 1. if Frintezza needs help, all (including Scarlet van Halisha) help him 2. if Scarlet needs help, all
	 * (including Frintezza) come to his help 3. if Strong Scarlet is already spawned, then he teleports to help Frintezza
	 * 
	 * @param L2Character
	 *            attacker - The player that attacked the boss
	 * @param int
	 *            hate - Damage hate to add to the attacker 1. Frintezza adds 200 hate 2. Weak Scarlet adds 100 hate 3. Stronger Scarlet adds 125 hate 4.
	 *            Strongest Scarlet adds 150 hate 5. Portraits adds 50 hate 6. Ghosts adds 1 hate
	 */
	/*public*/ void callMinionsToAssist(L2Character attacker, int hate)
	{
		if (attacker == null)
			return;

		if (ghost1 != null && !ghost1.isDead())
			ghost1.addDamageHate(attacker, 0, hate);

		if (ghost2 != null && !ghost2.isDead())
			ghost2.addDamageHate(attacker, 0, hate);

		if (ghost3 != null && !ghost3.isDead())
			ghost3.addDamageHate(attacker, 0, hate);

		if (ghost4 != null && !ghost4.isDead())
			ghost4.addDamageHate(attacker, 0, hate);

		if (weakScarlet != null && !weakScarlet.isDead())
	//	{
	//		weakScarletHpListener();
	//		if (weakScarlet != null && !weakScarlet.isDead())
				weakScarlet.addDamageHate(attacker, 0, hate);
	//	}

		if (strongScarlet != null && !strongScarlet.isDead())
			strongScarlet.addDamageHate(attacker, 0, hate);
	}

	@Override //implements SpawnListener
	public void npcSpawned(L2Npc npc)	//[JOJO] <<== L2Spawn.addSpawnListener(...)
	{
		if (npc == null)
			return;
		
		int npcId = npc.getNpcId();
		
		if (npcId == 29050 || npcId == 29051)	// ghost1..4
		{
			final L2MonsterInstance ghost = (L2MonsterInstance)npc;
			L2Skill skill = SkillTable.getInstance().getInfo(/*wCXg(Ux)*/1086, 1);
			ThreadPoolManager.getInstance().scheduleGeneral(new doSkill(ghost, skill, _intervalOfFrintezzaSongs, 1000), 4000);

			ThreadPoolManager.getInstance().scheduleGeneral(new Runnable() {
				public void run()
				{
					if (ghost.isDead() || ! ghost.isVisible()) return;
					L2Character target = getRandomPlayer();
					ghost.setTarget(target);
					if (target == null) return;
					L2CharPosition pos = new L2CharPosition(target.getX(), target.getY(), target.getZ(), 0);
					ghost.getAI().setIntention(CtrlIntention.AI_INTENTION_MOVE_TO, pos);
				//	new MoveToPos(_ghost, pos);
				}
			}, 10000 + Rnd.get(5000));
		}
	}

	/**
	 * Listens to the weaker Scarlet Van Halisha HP status. If it's weakened enough, we spawn the Stronger version of Scarlet and delete the weaker one.
	 */

	/*public*/ void weakScarletHpListener()
	{
		if (weakScarlet == null || weakScarlet.isDead())
			return;

		double curHp = weakScarlet.getStatus().getCurrentHp(), maxHp = weakScarlet.getMaxHp();

		if (_scarletType == 1)
		{
			if (curHp < maxHp * (2.0 / 3))
			{
				// Morph Scarlet Van Halisha into a Stronger one ;]
				_scarletType = 2;
				new SecondMorph().run();
			}
		}
		else if (_scarletType == 2)
		{
			if (curHp < maxHp * (1.0 / 3))
			{
				// Do 3rd Morph, Scarlet Van Halisha now changes templates
				_scarletType = 3;
				new ThirdMorph().run();
			}
		}
	}

	/**
	 * Does the 3rd and last polymorph for Scarlet Van Halisha. Now he looks entirely different... (he is different)
	 */
	class ThirdMorph implements Runnable
	{
		int _taskId = 0;
		L2GrandBossInstance _weakScarlet;
		
		ThirdMorph()
		{
			_weakScarlet = weakScarlet;
			weakScarlet = null;
		}
		private void next(int taskId, long delay)
		{
			_taskId = taskId;
			ThreadPoolManager.getInstance().scheduleGeneral(this, delay);
		}
		
		public void run()
		{
		 try {
			switch (_taskId)
			{
			case 0:
				onEnterMorph(frintezza, _weakScarlet);	//pause frintezza,daemon and ghosts
				_hall.broadcastPacket(new MagicSkillCanceld(frintezza.getObjectId()));

				updateKnownList(frintezza);
				showSocialActionMovie(frintezza, 250, 60, 15, 0, 10000, 0);
				next(2, 100);
				break;
			
			case 2:
				_hall.broadcastPacket(new SocialAction(frintezza.getObjectId(), /*{*/4));
				next(3, 4900);
				break;
			
			case 3:
				_hall.broadcastPacket(new MagicSkillUse(frintezza, frintezza, 5006, 1, SKILL_TIME_5006_1, 0));
				showSocialActionMovie(frintezza, 500, 60, 15, 4000, 10000, 0);
				next(4, 3000);
				break;
			
			case 4:
				showSocialActionMovie(frintezza, 2500, 90, 12, 4000, 10000, 0);
				next(5, 3000);
				break;
			
			case 5:
				updateKnownList(_weakScarlet);
				showSocialActionMovie(_weakScarlet, 400, /*Util.*/calcCameraYaw(_weakScarlet), 5, 0, 30000, 0);
				next(6, 100);
				break;
			
			case 6:
				_hall.broadcastPacket(new SocialAction(_weakScarlet.getObjectId(), /*剻E*/2));
				next(601, 3500);
				break;
			case 601:
				flickPlayers(_weakScarlet, 300);
				next(7, 3000);
				break;
			
			case 7:
				//////////////////////////////////////////////////////
				// spawn strong scarlet								//

				// set Strong Scarlet's position and heading
				// spawn Strong Scarlet and set his HP to the weaker version:
				strongScarlet = (L2GrandBossInstance) createNewSpawn(29047, _weakScarlet.getX(), _weakScarlet.getY(), _weakScarlet.getZ(), _weakScarlet.getHeading(), 0).doSpawn();
				double newHp = _weakScarlet.getStatus().getCurrentHp() / _weakScarlet.getMaxHp() * strongScarlet.getStatus().getCurrentHp(); // HP*1/3
			//	double newHp = _weakScarlet.getStatus().getCurrentHp();
				strongScarlet.getStatus().setCurrentHp(newHp);

				// Immobilize Strong Scarlet
				setIdle(strongScarlet);
				strongScarlet.setIsInSocialAction(true);

				// update his target
				strongScarlet.setTarget(_weakScarlet.getTarget());

				// get weakScarlet's list of attackers (or players that targeted it).
				boolean[] targeted = getTargeted(_weakScarlet);

				// set the list of players to target strongScarlet
				setTargeted(strongScarlet, targeted);

				// stealth WeakScarlet.
				_weakScarlet.startAbnormalEffect(AbnormalEffect.STEALTH.getMask()
						| AbnormalEffect.HOLD_2.getMask());
				//													//
				//////////////////////////////////////////////////////

				next(8, 3000);
				break;
			
			case 8:
				updateKnownList(strongScarlet);
				showSocialActionMovie(strongScarlet, 300, calcCameraYaw(strongScarlet), 12, 2000, 3000, 0);
				next(9, 2000);
				break;
			
			case 9:
				//////////////////////////////////////////////////////
				// delete the weakScarlet from the world			//
				/*weakScarlet.decayMe();*/
				_weakScarlet.deleteMe();
				_weakScarlet = null;
				//													//
				//////////////////////////////////////////////////////
				
				// do a social action "hello" ;]
				showSocialActionMovie(strongScarlet, 200, calcCameraYaw(strongScarlet), 20, 8000, 10000, 2);
				next(10, 4000);
				break;
			
			case 10:
				// reset camera.
				for (L2PcInstance pc : getPlayersInside())
				{
					L2Object target = strongScarlet;
					int yaw = calcCameraYaw(pc.getX(), pc.getY(), target.getX(), target.getY());
					pc.specialCamera(pc, 0, yaw, 10, 0, 100);
					pc.leaveMovieMode();
					pc.enableAllSkills();
				}
				next(99, 5000);
				break;
			
			case 99:
				// add Attack Listener
				ThreadPoolManager.getInstance().scheduleGeneral(new attackerListener(strongScarlet, 150), Rnd.get(4000) + 1000);

				// add retarget Listener
				ThreadPoolManager.getInstance().scheduleGeneral(new ReTarget(strongScarlet), _intervalOfRetarget);

				// mobilize Strong Scarlet
				ThreadPoolManager.getInstance().scheduleGeneral(new SetMobilisedBoss(strongScarlet), 4000);
				strongScarlet.setRunning();

				// set teleport speed
				L2Skill skill = SkillTable.getInstance().getInfo(/*wCXg(Ux)*/1086, 1);
				ThreadPoolManager.getInstance().scheduleGeneral(new doSkill(strongScarlet, skill, _intervalOfRetarget, 300), 4016);

				//
				onLeaveMorph();
				break;
				
			default:
				TRACE("__BASENAME__:__LINE__: 'case " + _taskId + ":' invalid");
				throw new AssertionError("'case " + _taskId + ":' invalid");
			}
		 } catch (Exception e) { e.printStackTrace(); }
		}
	}

	/**
	 * Receives a target and a list of players in _playersInLair that should target this target
	 * 
	 * @param target
	 *            L2Character
	 * @param targeted
	 *            boolean[]
	 * @return void
	 */

	/*private*/ void setTargeted(L2Character target, boolean[] targeted)
	{
		int count = 0;

		// Server->Client packet StatusUpdate of the L2Npc to the L2PcInstance to update its HP bar
		StatusUpdate su = new StatusUpdate(target.getObjectId());
		su.addAttribute(StatusUpdate.CUR_HP, (int) target.getStatus().getCurrentHp());
		su.addAttribute(StatusUpdate.MAX_HP, target.getMaxHp());

		// set the target again on the players that targeted this _caster
		for (L2PcInstance pc : getPlayersInside())
		{
			if (pc != null && targeted[count])
			{
				pc.setTarget(target);
				// Send a Server->Client packet StatusUpdate of the L2Npc to the L2PcInstance to update its HP bar
				pc.sendPacket(su);
			}
			count++;
		}
	}

	/**
	 * Receives a target and returns the _playersInLair that target this target
	 * 
	 * @param target
	 *            L2Object
	 * @return boolean[] targeted players (true = target , false = not target)
	 */

	/*private*/ boolean[] getTargeted(L2Object target)
	{
		List<L2PcInstance> lst = getPlayersInside();
		boolean[] targeted = new boolean[lst.size()];
		int count = 0;

		// get the players that targeted this _caster
		for (L2PcInstance pc : lst)
			targeted[count++] = (pc != null && pc.getTarget() == target);
		return targeted;
	}

	/**
	 * Sets a L2Character to idle state. Disables all skills, aborts attack and cast, immoblizies
	 * setIdle <---> setActive
	 * 
	 * @param target
	 *            L2Character
	 */
	void setIdle(L2Character target)
	{
		target.getAI().setIntention(CtrlIntention.AI_INTENTION_IDLE);
		target.abortAttack();
		target.abortCast();
		target.setIsImmobilized(true);
	}
	void setActive(L2Character target)
	{
		target.setIsImmobilized(false);
		target.getAI().setIntention(CtrlIntention.AI_INTENTION_ACTIVE);
	}
	
	boolean isIdle(L2Character target)	//JOJO
	{
		return target.getAI().getIntention() == CtrlIntention.AI_INTENTION_IDLE;
	}
	
	void onEnterMorph(L2GrandBossInstance ... boss)	//[JOJO] XJ[bg̕ϐg[r[́AtebTƃS[Xg̍Uꎞ~
	{
		if (ghost1 != null) { setIdle(ghost1); ghost1.startParalyze(); }
		if (ghost2 != null) { setIdle(ghost2); ghost2.startParalyze(); }
		if (ghost3 != null) { setIdle(ghost3); ghost3.startParalyze(); }
		if (ghost4 != null) { setIdle(ghost4); ghost4.startParalyze(); }
		for (L2GrandBossInstance b : boss)
		{
			setIdle(b);
			b.setIsInSocialAction(true);
		}
	}
	void onLeaveMorph()	//[JOJO] ĊJ
	{
		new SetMobilisedBoss(frintezza).run();
		if (ghost1 != null) { ThreadPoolManager.getInstance().scheduleGeneral(new SetMobilisedGhost(ghost1), 6000); }
		if (ghost2 != null) { ThreadPoolManager.getInstance().scheduleGeneral(new SetMobilisedGhost(ghost2), 9000); }
		if (ghost3 != null) { ThreadPoolManager.getInstance().scheduleGeneral(new SetMobilisedGhost(ghost3), 12000); }
		if (ghost4 != null) { ThreadPoolManager.getInstance().scheduleGeneral(new SetMobilisedGhost(ghost4), 15000); }
	}
	
	private class SetMobilisedBoss implements Runnable	//[JOJO] frintezza & scarlet
	{
		private final L2GrandBossInstance	_npc;
		
		public SetMobilisedBoss(L2GrandBossInstance boss)
		{
			_npc = boss;
			boss.setIsInSocialAction(false);
			setActive(boss);
			boss.startImmobileUntilAttacked();
		}
		public void run()
		{
			_npc.stopImmobileUntilAttacked(null);
		}
	}
	private class SetMobilisedGhost implements Runnable	//[JOJO] ghosts
	{
		private final L2Npc	_npc;
		
		public SetMobilisedGhost(L2MonsterInstance ghost)
		{
			_npc = ghost;
			ghost.stopParalyze(null);
			setActive(ghost);
			ghost.startImmobileUntilAttacked();
		}
		public void run()
		{
			_npc.stopImmobileUntilAttacked(null);
		}
	}

	/**
	 * Does the 2nd Morph for Scarlet Van Halisha. Now he's bigger and he teleports to his targets
	 */

	class SecondMorph implements Runnable
	{
		int _taskId = 0;
		final double _currentHp = weakScarlet.getStatus().getCurrentHp();
		
		private void next(int taskId, long delay)
		{
			_taskId = taskId;
			ThreadPoolManager.getInstance().scheduleGeneral(this, delay);
		}
		
		public void run()
		{
		 L2Skill skill;
		 try {
		  switch (_taskId)
		  {
			case 0:
				//pause frintezza and daemon
				setIdle(frintezza);
				frintezza.setIsInSocialAction(true);

				weakScarlet.disableCoreAI(true);
				setIdle(weakScarlet);
				weakScarlet.setIsInSocialAction(true);

				next(1, 500);
				break;

			case 1:
				weakScarlet.enableSkill(/*f[* @w*/5018);
				_hall.broadcastPacket(new MagicSkillUse(weakScarlet, weakScarlet, /*Frintessa Daemon Field*/5018, 1, 0, 0));
				next(2, 2000);
				break;
			case 2:
				weakScarlet.enableSkill(/*f[1 ϐg*/5017);
				weakScarlet.setRHandId(7903);
				_hall.broadcastPacket(new NpcInfo(weakScarlet, null));
				next(3, 2000);
				break;
			case 3:
//				flickPlayers(weakScarlet, 300);
				next(99, 4000);
				break;
			
			case 99:
				weakScarlet.disableSkill(/*f[1 ϐg*/5017);

				skill = SkillTable.getInstance().getInfo(/*}Cg*/1068, 3);
				weakScarlet.callSkill(skill, weakScarlet);
				skill = null;

				weakScarlet.getStatus().setCurrentHp(_currentHp * 1.15);

				weakScarlet.setIsInSocialAction(false);
				setActive(weakScarlet);
				weakScarlet.disableCoreAI(false);

				frintezza.setIsInSocialAction(false);
				setActive(frintezza);

				// start teleporting fast
				skill = SkillTable.getInstance().getInfo(/*wCXg(Ux)*/1086, 1);
				ThreadPoolManager.getInstance().scheduleGeneral(new doSkill(weakScarlet, skill, _intervalOfRetarget, 200), _intervalOfRetarget);
				skill = null;

				break;
				
			default:
				TRACE("__BASENAME__:__LINE__: 'case " + _taskId + ":' invalid");
				throw new AssertionError("'case " + _taskId + ":' invalid");
		  } //~switch
		 } catch (Exception e) { e.printStackTrace(); }
		} //~run
	}

	/**
	 * Starts the skill effects for Scarlet Van Halisha. He moves like the wind ;] Continuous skills cast at _intervalOfRetarget
	 * 
	 * @author Darki699
	 */

	private class doSkill implements Runnable
	{
		private final L2Character	_caster;
		private final L2Skill		_skill;
		private final int			_interval, _range;

		/**
		 * Shows skill animation effect and teleports to the target if it's out of range
		 * 
		 * @param caster -
		 *            the monster
		 * @param skill -
		 *            the skill to animate
		 * @param interval -
		 *            the time between leaps
		 * @param range -
		 *            the range minimum to teleport
		 */

		public doSkill(L2Character caster, L2Skill skill, int interval, int range)
		{
			_caster = caster;
			_skill = skill;
			_interval = interval;
			_range = range;
		}

		public void run()
		{
			if (_caster == null || _caster.isDead() /*JOJO*/|| ! _caster.isVisible())
				return;

			if (_caster.isImmobilized())	//[JOJO]
			{
				ThreadPoolManager.getInstance().scheduleGeneral(this, _interval);
				return;
			}

			try
			{
				L2Object tempTarget = _caster.getTarget();
				if (tempTarget instanceof L2PcInstance && checkIfInZone((L2PcInstance) tempTarget))
				{
					int x = tempTarget.getX() + Rnd.get(_range) - _range / 2;
					int y = tempTarget.getY() + Rnd.get(_range) - _range / 2;
					int z = tempTarget.getZ();

					if (!_caster.isInsideRadius(x, y, _range, false))
					{

						// Returns a list of the players that targeted the _caster
						boolean[] targeted = getTargeted(_caster);

						_caster.broadcastPacket(new MagicSkillUse(_caster, ((L2Character) tempTarget), _skill.getId(), _skill.getLevel(), 0, 0), 10000);
						_caster.broadcastPacket(new FlyToLocation(_caster, x, y, z, FlyType.CHARGE));
						_caster.getPosition().setXYZ(x, y, z);
						_caster.broadcastPacket(new ValidateLocation(_caster));
						_caster.setTarget(tempTarget);

						// retarget all the players that targeted this _caster
						setTargeted(_caster, targeted);
					}
				}
			}
			catch (RuntimeException e)
			{
				_log.warning(e.getMessage());
			}

			ThreadPoolManager.getInstance().scheduleGeneral(this, _interval + Rnd.get(500));
		}
	}

	/** * Re-Target Class to update a monster's known list and to re-target it again at an interval ** */

	private class ReTarget implements Runnable
	{
		//mob - [29045 tebT]
		//      [29046 XJ[bg @ nV]
		//      [29047 XJ[bg @ nV]
		private final L2Npc	_mob;

		public ReTarget(L2Npc mob)
		{
			_mob = mob;
		}

		public void run()
		{
			if (getPlayersInside().isEmpty())	//+[JOJO] H
			{
			//	doUnspawn();
				if (_activityTimeEndTask != null) _activityTimeEndTask.cancel(false);
				_activityTimeEndTask = ThreadPoolManager.getInstance().scheduleGeneral(new ActivityTimeEnd(), 10000);
				return;
			}
			if (_mob.isDead() || ! _mob.isVisible())	//+[JOJO] [v
			{
				return;
			}
			_mob.setTarget(getRandomPlayer());

			if (_mob.getTarget() == null)
				ThreadPoolManager.getInstance().scheduleGeneral(this, 1000);
			else
				ThreadPoolManager.getInstance().scheduleGeneral(this, _intervalOfRetarget + Rnd.get(_intervalOfRetarget));
		//	ThreadPoolManager.getInstance().scheduleGeneral(new ReTarget(_mob), _intervalOfRetarget);
		}
	}

	/** *********************************** End of re-target class *************************************** */

	/**
	 * Class ends the activity of the Bosses after a interval of time Exits the battle field in any way ...
	 * 
	 * @author Darki699
	 * @author SANDMAN L2J_JP(modified)
	 */
	/*private*/ class ActivityTimeEnd implements Runnable
	{
		public void run()
		{
			if (_monsterSpawnTask == null) return;	//[JOJO]
			setUnspawn();
			decayItemsOnGround();
			LastImperialTombManager.getInstance().cleanUpTomb();	//[JOJO]
		}
	}

	/**
	 * Clean Frintezza's lair.
	 * @author Darki699
	 * @author SANDMAN L2J_JP(modified)
	 * @author JOJO -- vC[͔rȂ悤ɕύX.
	 */
	@Override
	public void setUnspawn()	//<<== LastImperialTombManager
	{
	 try {
	//	// eliminate players.	//-[JOJO] !!Don't!!
	//	banishForeigners();		//-[JOJO] !!Don't!!

		L2Spawn.removeSpawnListener(FrintezzaManager.getInstance());	//+[JOJO]

		// delete monsters.
		portraitDeadCheck(portrait1); // Deletes portrait and ghost

		portraitDeadCheck(portrait2); // Deletes portrait and ghost

		portraitDeadCheck(portrait3); // Deletes portrait and ghost

		portraitDeadCheck(portrait4); // Deletes portrait and ghost

		if (frintezza != null)
		{
			frintezza.deleteMe();
			frintezza = null;
		}

		if (strongScarlet != null)
		{
			strongScarlet.deleteMe();
			strongScarlet = null;
		}

		if (weakScarlet != null)
		{
			weakScarlet.deleteMe();
			weakScarlet = null;
		}

	//	_state.setState(GrandBossState.StateEnum.DEAD);	//-[JOJO] "S""Ԑ؂"͕

		music = null;

		// not executed tasks are canceled.
		if (_monsterSpawnTask != null)
		{
			_monsterSpawnTask.cancel(true);
			_monsterSpawnTask = null;
		}
		if (_intervalEndTask != null)
		{
			_intervalEndTask.cancel(true);
			_intervalEndTask = null;
		}
		if (_activityTimeEndTask != null)
		{
			_activityTimeEndTask.cancel(true);
			_activityTimeEndTask = null;
		}

		// interval begin.... Count until Frintezza is ready to respawn again.
		setIntervalEndTask();

		_log.info("FrintezzaManager : Next spawn date of Frintezza is " + _state.respawnTimeFormat() + ".");
	 } catch (Exception e) { e.printStackTrace(); }
	}
	
	/**
	 * Creates a thread to initialize Frintezza again... until this loops ends, no one can enter the lair.
	 * ֎~Ԃݒ肷
	 * 
	 * @author Darki699
	 * @author SANDMAN L2J_JP(modified)
	 * @author JOJO(modified)
	 */
	private/*public*/ void setIntervalEndTask()
	{
		// init state of Frintezza's lair.
		switch (_state.getState())
		{
		case GrandBossState.StateEnum.NOTSPAWN:
			break;
		case GrandBossState.StateEnum.ALIVE:
			_state.setState(GrandBossState.StateEnum.NOTSPAWN);
			break;
		case GrandBossState.StateEnum.DEAD:
			_state.setRespawnDate(Config.LIT_FIXINTERVALOFFRINTEZZA + Rnd.get(Config.LIT_RANDOMINTERVALOFFRINTEZZA));
			_state.setState(GrandBossState.StateEnum.INTERVAL);
			_state.update();
			// don't "break" //
		case GrandBossState.StateEnum.INTERVAL:
if (TEST) _intervalEndTask =ThreadPoolManager.getInstance().scheduleGeneral(new IntervalEnd(), 300000); else
			_intervalEndTask =ThreadPoolManager.getInstance().scheduleGeneral(new IntervalEnd(), _state.getInterval());
			_log.info("FrintezzaManager : Interval START.");
			break;
		default:
			throw new AssertionError();
		}
	}

	/**
	 * Calls for a re-initialization when time comes, only then can players enter the lair.
	 * ֎~Ԃ̏Iiւj
	 * 
	 * @author Darki699
	 */

	/*private*/ class IntervalEnd implements Runnable
	{
		public void run()
		{
			_state.setState(GrandBossState.StateEnum.NOTSPAWN);
			_state.update();
			_log.info("FrintezzaManager : Interval END.");
		}
	}

	////////////////////////////////////////////////////////////////////
	//
	/**
	 * Dead Frintezza (NPC ID:29045)
	 * tebTXJ[bgɎł܂Ƃp
	 */
	public void onKillFrintezza(final L2PcInstance player)	//<<== lastimperialtomb.py:onKill()
	{
		if (frintezza == null)
			return;
		else if (strongScarlet != null)
			ThreadPoolManager.getInstance().executeTask(new Runnable() {
				public void run() { strongScarlet.doDie(player); }
			});
		else if (weakScarlet != null)
			ThreadPoolManager.getInstance().executeTask(new Runnable() {
				public void run() { weakScarlet.doDie(player); }
			});
	}

	/**
	 * Dead Scarlet Van Halisha (NPC ID:29046 weak & ID:29047 strong). [JOJO]
	 */
	public void onKillScarlet(L2PcInstance player)	//<<== lastimperialtomb.py:onKill()
	{
		_scarletType = 0;
		new ScarletStrongKilled(player).run();
	}
	private class ScarletStrongKilled implements Runnable
	{
		private int _taskId = 1;
		private final L2PcInstance _player;
		private L2GrandBossInstance _frintezza, _strongScarlet, _weakScarlet, _activeScarlet;
		private long _timeLimit;
		
		public ScarletStrongKilled(L2PcInstance player)
		{
			_player = player;
			
			// Ƃ肠 attackerListener, ReTarget ȂǂMOBĎ^XN~߂邽߂ null B
			// tebT{̂ƃXJ[bg̓\[VANVpɐĂB
			_frintezza = frintezza; frintezza = null;				//stop Frintezza's task
			_activeScarlet = strongScarlet != null ? strongScarlet : weakScarlet;
			_weakScarlet = weakScarlet; weakScarlet = null;			//stop Weak Scarlet's task
			_strongScarlet = strongScarlet; strongScarlet = null;	//stop Strong Scarlet's task
		}
		private void next(int taskId, long delay)
		{
			_taskId = taskId;
			ThreadPoolManager.getInstance().scheduleGeneral(this, delay);
		}
		
		public void run()
		{
		 try {
			switch (_taskId)
			{
			case 1:
				if (_activityTimeEndTask != null) _activityTimeEndTask.cancel(false);
				_activityTimeEndTask = null;
				
				_hall.broadcastPacket(new MagicSkillCanceld(_frintezza.getObjectId()));
				
				if (ghost4 != null) { ghost4.getSpawn().stopRespawn(); ghost4.deleteMe(); ghost4 = null; }
				if (ghost3 != null) { ghost3.getSpawn().stopRespawn(); ghost3.deleteMe(); ghost3 = null; }
				if (ghost2 != null) { ghost2.getSpawn().stopRespawn(); ghost2.deleteMe(); ghost2 = null; }
				if (ghost1 != null) { ghost1.getSpawn().stopRespawn(); ghost1.deleteMe(); ghost1 = null; }
				if (portrait4 != null) { portrait4.deleteMe(); portrait4 = null; }
				if (portrait3 != null) { portrait3.deleteMe(); portrait3 = null; }
				if (portrait2 != null) { portrait2.deleteMe(); portrait2 = null; }
				if (portrait1 != null) { portrait1.deleteMe(); portrait1 = null; }
				
				_state.setState(GrandBossState.StateEnum.DEAD);
				_state.update();
				
				updateKnownList(_activeScarlet);
				showSocialActionMovie(_activeScarlet, 300, calcCameraYaw(_activeScarlet, 180) , 5, 0, 7000, 0);
				next(2, 500);
				break;
				
			case 2:
				showSocialActionMovie(_activeScarlet, 150, calcCameraYaw(_activeScarlet), 85, 4000, 20000, 0);
				next(3, 7000);
				break;
				
			case 3:
				updateKnownList(_frintezza);
				showSocialActionMovie(_frintezza, 150, 120, 5, 0, 7000, 0);
				next(4, 500);
				break;
				
			case 4:
				//////////////////////////////////////////
				// self distruct frintezza				//
				_frintezza.doDie(_player);
				_hall.broadcastPacket(new PlaySound(1, "BS01_D", 1, _frintezza.getObjectId(), CENTER_X, CENTER_Y, CENTER_Z));
				//										//
				//////////////////////////////////////////
				
				showSocialActionMovie(_frintezza, 150, 90, 5, 3000, 15000, 0);
				next(5, 7000);
				break;
				
			case 5:
				// spawn teleportation cubeic.
				//TODO: UPDATE npc SET collision_height=80.0 WHERE id=29061;
				teleCube = createNewSpawn(29061, CENTER_X, CENTER_Y, CENTER_Z, 0, 0).doSpawn();
				
				showSocialActionMovie(_frintezza, 1200, 90, 25, 8000, 10000, 0);
				next(90, 8000);
				break;
				
			case 90:
				//////////////////////////////////////////////////////////////////////////////////
				// despawn scarlet.																//
				if (_weakScarlet != null) { _weakScarlet.deleteMe(); _weakScarlet = null; }
				if (_strongScarlet != null) { _strongScarlet.deleteMe(); _strongScarlet = null; }
				//																				//
				//////////////////////////////////////////////////////////////////////////////////

				// reset camera.
				for (L2PcInstance pc : getPlayersInside())
				{
					pc.specialCamera(pc, 0, calcCameraYaw(pc, 180), 0, 0, 100);
					pc.leaveMovieMode();
					pc.enableAllSkills();
				}
				Broadcast.announceToOnlinePlayers("Ō̍c̃̕tebTS܂B");
				next(91, 20000);
				break;
				
			case 91:
				// eliminate mobs.
				if (_frintezza != null) { _frintezza.deleteMe(); _frintezza = null; }
				setUnspawn();
				
				_hall.broadcastPacket(new CreatureSay(0, SystemChatChannelId.Chat_Party,
						"tebT e|[^[", "߂łƂ܂B͊댯łB15ȓɒEoĂB"));
				
				_timeLimit = System.currentTimeMillis() + 900000; // +15 min.
				next(99, 60000);
				break;
				
			case 99:
				List<L2PcInstance> players;
				if (System.currentTimeMillis() < _timeLimit
						&& (players = getPlayersInside()).size() > 0)
				{
					for (L2PcInstance pc : players/*=getPlayersInside()*/)
						if (! pc.isDead())
						{
							double progress = (double)(_timeLimit - System.currentTimeMillis()) / 900000;
							double hp = 1 + pc.getMaxHp() * progress;
							double mp = 1 + pc.getMaxMp() * progress;
							if (hp < pc.getCurrentHp() || mp < pc.getCurrentMp())
								pc.setCurrentHpMp(hp, mp);
						}
					next(99, Rnd.get(1000, 10000));
				}
				else
				{
					if (teleCube != null) { teleCube.deleteMe(); teleCube = null; }
					// eliminate players.
				//	banishForeigners();
					decayItemsOnGround();
					LastImperialTombManager.getInstance().cleanUpTomb();
				}
				break;
				
			default:
				TRACE("__BASENAME__:__LINE__: 'case " + _taskId + ":' invalid");
				throw new AssertionError("'case " + _taskId + ":' invalid");
			}
		 } catch (Exception e) {e.printStackTrace();}
		}
	}

	public void onSoulBreakingArrow(final L2Npc npc, final L2PcInstance player)	//<<== lastimperialtomb.py:onSkillSee
	{
		if (npc != frintezza) throw new AssertionError();
		if (music != null)
			music.pause(60000);
	}

	////////////////////////////////////////////////////////////////////
	//
	
	void updateKnownList(L2Npc npc)
	{
		_hall.updateKnownList(npc);
	}
	
	int calcCameraYaw(L2Character ch)
	{
		return Util.calcCameraAngle(ch);
	}
	int calcCameraYaw(L2Character ch, int alpha)
	{
		return (alpha + 360 + Util.calcCameraAngle(ch)) % 360;
	}
	int calcCameraYaw(int x0, int y0, int x1, int y1)
	{
		return (360 - (int)Math.round(Math.toDegrees(Math.atan2(y1 - y0, x1 - x0)))) % 360;
	}
	int calcCameraPitch(int x0, int y0, int z0, int x1, int y1, int z1)
	{
		return (int) Math.round(Math.toDegrees(Math.atan2(
			  z0 - z1/**/
			, horizontalDistance(x0, y0, x1, y1)/**/)));
	}
	
	int horizontalDistance(int x0, int y0, int x1, int y1)
	{
		long rx = x1 - x0, ry = y1 - y0;
		return (int)Math.round(Math.sqrt(rx * rx + ry * ry));
	}
	
	void flickPlayers(final L2Object o, final double range) //+[JOJO]
	{
		flickPlayers(o.getX(), o.getY(), range);
	}
	void flickPlayers(final int mx, final int my, final double range) //+[JOJO]
	{
		for (L2Character cha : _hall.getCharactersInside().values())
		{
			if (! (cha instanceof L2PcInstance)) continue;
			L2PcInstance pc = (L2PcInstance) cha;
			double dx = pc.getX() - mx;
			double dy = pc.getY() - my;
			if (dx == 0 && dy == 0) dx = dy = range / 2;
			double aa = range / Math.sqrt(dx * dx + dy * dy);
			if (aa > 1.0) {
				int x = mx + (int)(dx * aa);
				int y = my + (int)(dy * aa);
				int z = pc.getZ();
				if (horizontalDistance(CAMERA_X, CAMERA_Y, x, y) >= CAMERA_R)
				{
					x = mx - (int)(dx * aa);
					y = my - (int)(dy * aa);
				}

				pc.getAI().setIntention(CtrlIntention.AI_INTENTION_IDLE);
				pc.abortAttack();
				pc.abortCast();

				pc.broadcastPacket(new FlyToLocation(pc, x, y, z, FlyType.THROW_UP));
				pc.setXYZ(x, y, z);
				pc.setHeading(Util.calculateHeadingFrom(x, y, mx, my));
				pc.broadcastPacket(new ValidateLocation(pc));
				pc.sendPacket(new SystemMessage(SystemMessageId.YOU_FEEL_S1_EFFECT).addSkillName(5004, 1));
			}
		}
	}
	
	/////////////////////////////////////////////////////////////////////
	//
	public void decayItemsOnGround() //[JOJO]
	{
//		decayItemsOnGround(122,45);	// invade loc
//		decayItemsOnGround(122,44);
//		decayItemsOnGround(122,43);
		decayItemsOnGround(122,42);	// frintezza hall
	}
	private void decayItemsOnGround(int x, int y) //[JOJO]
	{
		for (L2Object o : L2World.getInstance().getAllWorldRegions()[x][y].getVisibleObjects().values())
		{
			if (o instanceof L2ItemInstance)
			{
				L2ItemInstance item = (L2ItemInstance) o;
				if (_hall.isInsideZone(item))
					item.decayMe();
			}
		}
	}

	/////////////////////////////////////////////////////////////////////////////////////////////////////
	// Override [class Entity]

	/**
	 * enter Frintezza zone
	 */
	@Override public void onEnter(L2PcInstance player) //<<== L2BossZone#onEnter
	{
		if (! _zone.isPlayerAllowed(player))
		{
			if (! player.isGM()) player.setPunishLevel(PunishLevel.JAIL, 1440);	// Jail 1Day.
		//	if (! player.isGM()) escapeForeigner(player);
			return;
		}
		
		LastImperialTombManager.getInstance().setReachToHall();
		setScarletSpawnTask();
	}

	@Override public List<L2PcInstance> getPlayersInside()
	{
		// Ō̍c̕][ƃtebT][p
		return LastImperialTombManager.getInstance().getPlayersInside();
	}
	
	@Override public boolean checkIfInZone(L2Character cha)
	{
		// tebT̂
		return _hall.isInsideZone(cha);	
	}

	@Deprecated @Override public L2BossZone getZone()
	{
		throw new AssertionError();	//_zone  _hall dȂĂĕ킵̂Ŏgp֎~
	}

	@Override public void banishForeigners()
	{
		// Ō̍c̕][ƃtebT][p
		LastImperialTombManager.getInstance().banishForeigners();
	}

	////////////////////////////////////////////////////////////////////
	// DEBUG
	@Deprecated String getMonsterName(L2Npc mob)
	{
		if (DEBUG) {
			if (mob == null) return "(null)";
			if (mob == frintezza) return mob.getName();
			if (mob == strongScarlet) return ""+mob.getName();
			if (mob == weakScarlet) return ""+mob.getName();
			if (mob == portrait1) return mob.getName()+"#1";
			if (mob == portrait2) return mob.getName()+"#2";
			if (mob == portrait3) return mob.getName()+"#3";
			if (mob == portrait4) return mob.getName()+"#4";
			if (mob == ghost1) return mob.getName()+"#1";
			if (mob == ghost2) return mob.getName()+"#2";
			if (mob == ghost3) return mob.getName()+"#3";
			if (mob == ghost4) return mob.getName()+"#4";
			return "H"+mob.getName();
		}
		else
			return null;
	}
	////////////////////////////////////////////////////////////////////
}
