/*
 * This program is free software: you can redistribute it and/or modify it under
 * the terms of the GNU General Public License as published by the Free Software
 * Foundation, either version 3 of the License, or (at your option) any later
 * version.
 * 
 * This program is distributed in the hope that it will be useful, but WITHOUT
 * ANY WARRANTY; without even the implied warranty of MERCHANTABILITY or FITNESS
 * FOR A PARTICULAR PURPOSE. See the GNU General Public License for more
 * details.
 * 
 * You should have received a copy of the GNU General Public License along with
 * this program. If not, see <http://www.gnu.org/licenses/>.
 */
package net.sf.l2j.gameserver.instancemanager.lastimperialtomb;
/*package com.l2jfree.gameserver.instancemanager.lastimperialtomb;*/

import java.util.List;
import java.util.concurrent.ScheduledFuture;

import javolution.util.FastList;

import net.sf.l2j.Config;
import net.sf.l2j.gameserver.ThreadPoolManager;
import net.sf.l2j.gameserver.datatables.DoorTable;
import net.sf.l2j.gameserver.datatables.MapRegionTable;
import net.sf.l2j.gameserver.instancemanager.ZoneManager;
import net.sf.l2j.gameserver.instancemanager.grandbosses.BossLair;
import net.sf.l2j.gameserver.instancemanager.grandbosses.FrintezzaManager;
import net.sf.l2j.gameserver.instancemanager.lastimperialtomb.LastImperialTombSpawnlist;
import net.sf.l2j.gameserver.model.L2ItemInstance;
import net.sf.l2j.gameserver.model.L2Spawn;
import net.sf.l2j.gameserver.model.L2Party;
import net.sf.l2j.gameserver.model.actor.instance.L2DoorInstance;
import net.sf.l2j.gameserver.model.actor.L2Npc;
import net.sf.l2j.gameserver.model.actor.instance.L2PcInstance;
import net.sf.l2j.gameserver.model.zone.L2ZoneType;
import net.sf.l2j.gameserver.network.SystemChatChannelId;
import net.sf.l2j.gameserver.network.SystemMessageId;
import net.sf.l2j.gameserver.network.serverpackets.CreatureSay;
import net.sf.l2j.gameserver.network.serverpackets.ExShowScreenMessage;
import net.sf.l2j.gameserver.network.serverpackets.SystemMessage;
import net.sf.l2j.util.Rnd;

/**
 * 
 * @author L2J_JP SANDMAN
 * @author JOJO Sync: l2jfree-core rev4936, timestamp 2008/12/23 00:43
 * @author JOJO Sync: l2jfree-core rev6405, timestamp 2009/06/27 22:40
 * @author JOJO Sync: l2jfree-core rev6689, timestamp 2009/07/22 23:45
 */
public final class LastImperialTombManager extends BossLair
{
//	@Deprecated static final boolean TEST = false;
//	@Deprecated static final boolean DEBUG = false;

	private static boolean					_isInvaded					= false;

	// Instance list of monsters.
	protected static List<L2Npc>	_hallAlarmDevices			= new FastList<L2Npc>();
	protected static List<L2Npc>	_darkChoirPlayers			= new FastList<L2Npc>();
	protected static List<L2Npc>	_darkChoirCaptains			= new FastList<L2Npc>();
	protected static List<L2Npc>	_room1Monsters				= new FastList<L2Npc>();
	protected static List<L2Npc>	_room2InsideMonsters		= new FastList<L2Npc>();
	protected static List<L2Npc>	_room2OutsideMonsters		= new FastList<L2Npc>();

	// Instance list of doors.
	protected static List<L2DoorInstance>	_room1Doors					= new FastList<L2DoorInstance>();
	protected static List<L2DoorInstance>	_room2InsideDoors			= new FastList<L2DoorInstance>();
	protected static List<L2DoorInstance>	_room2OutsideDoors			= new FastList<L2DoorInstance>();
	protected static L2DoorInstance			_room3Door					= null;

	// Instance list of players.
	protected static List<L2PcInstance>		_partyLeaders				= new FastList<L2PcInstance>();
	protected static List<L2PcInstance>		_registedPlayers			= new FastList<L2PcInstance>();
	protected static L2PcInstance			_commander					= null;

	// Frintezza's Magic Force Field Removal Scroll.
	private static final int				SCROLL						= 8073;

	// Items
	public static final int					SOUL_BREAKING_ARROW			= 8192;	//+[JOJO] j̖
	public static final int					DEWDROP_OF_DESTRUCTION		= 8556;	//+[JOJO] j̘I

	// Player does reach to HallofFrintezza
	private boolean							_isReachToHall				= false;

	// Location of invade.
	private final int[][]					_invadeLoc					=
																		{
																		{ 173235, -76884, -5107 },
																		{ 175003, -76933, -5107 },
																		{ 174196, -76190, -5107 },
																		{ 174013, -76120, -5107 },
																		{ 173263, -75161, -5107 } };

	// Task
	protected ScheduledFuture<?>			_InvadeTask					= null;
	protected ScheduledFuture<?>			_RegistrationTimeInfoTask	= null;
	protected ScheduledFuture<?>			_Room1SpawnTask				= null;
	protected ScheduledFuture<?>			_Room2InsideDoorOpenTask	= null;
	protected ScheduledFuture<?>			_Room2OutsideSpawnTask		= null;
	protected ScheduledFuture<?>			_CheckTimeUpTask			= null;

	// Constructor
	private LastImperialTombManager()
	{
	}

	// Instance.
	public static LastImperialTombManager getInstance()
	{
		return SingletonHolder._instance;
	}

 //	public int getRandomRespawnDate()
 //	{
 //		return 0;
 //	}
 //
	@Override
	public void setUnspawn()
	{
	}

	// Load monsters and close doors.
	@Override
	public void init()
	{
		if (registerZone(_invadeLoc[0][0], _invadeLoc[0][1], _invadeLoc[0][2]) == null)		//[JOJO]
			_log.warning("LastImperialTombManager : Failed to load zone 'Last Imperial Tomb'");

		LastImperialTombSpawnlist.getInstance().clear();
		LastImperialTombSpawnlist.getInstance().fill();
		initDoors();

		_log.info("LastImperialTombManager: Init The Last Imperial Tomb.");
	}

	// Setting list of doors and close doors.
	private void initDoors()
	{
		_room1Doors.clear();
		_room1Doors.add(DoorTable.getInstance().getDoor(25150042));

		for (int i = 25150051; i <= 25150058; i++)
		{
			_room1Doors.add(DoorTable.getInstance().getDoor(i));
		}

		_room2InsideDoors.clear();
		for (int i = 25150061; i <= 25150070; i++)
		{
			_room2InsideDoors.add(DoorTable.getInstance().getDoor(i));
		}
		_room2OutsideDoors.clear();
		_room2OutsideDoors.add(DoorTable.getInstance().getDoor(25150043));
		_room2OutsideDoors.add(DoorTable.getInstance().getDoor(25150045));

		_room3Door = DoorTable.getInstance().getDoor(25150046);

		for (L2DoorInstance door : _room1Doors)
		{
			door.closeMe();
		}

		for (L2DoorInstance door : _room2InsideDoors)
		{
			door.closeMe();
		}

		for (L2DoorInstance door : _room2OutsideDoors)
		{
			door.closeMe();
		}

		_room3Door.closeMe();
	}

	// Return true,tomb was already invaded by players.
	public boolean isInvaded()
	{
		return _isInvaded;
	}

 //	public boolean isReachToHall()
 //	{
 //		return _isReachToHall;
 //	}

	// RegistrationMode = command channel.
	private/*public*/ boolean tryRegistrationCc(L2PcInstance pc)
	{
	//	if (isInvaded())
	//	{
	//		pc.sendMessage("̃O[vgpłB");
	//	//	pc.sendMessage("Another group is already fighting inside the imperial tomb.");
	//		return false;
	//	}
	//
	//	if (!FrintezzaManager.getInstance().isEnableEnterToLair())
	//	{
	//		pc.sendMessage("݁A󂯕tĂ܂B");
	//	//	pc.sendMessage("Currently no entry possible.");
	//		return false;
	//	}

		if (_commander == null)
		{
			if (pc.getParty() != null)
			{
				if (pc.getParty().getCommandChannel() != null)
				{
					if (pc.getParty().getCommandChannel().getChannelLeader() == pc
							&& pc.getParty().getCommandChannel().getPartys().size() >= Config.LIT_MIN_PARTY_CNT
							&& pc.getParty().getCommandChannel().getPartys().size() <= Config.LIT_MAX_PARTY_CNT
							&& pc.getInventory().getInventoryItemCount(SCROLL, -1) >= 1)
						return true;
				}
			}
		}

		pc.sendMessage("p[eB[𗦂A`l̃[_[utebŤEXN[vĂ΁AtebTľEɓ܂B");
	//	pc.sendMessage("You must be the commander of a party channel and possess a \"Frintezza's Magic Force Field Removal Scroll\".");
		return false;
	}

	// RegistrationMode = party.
	private/*public*/ boolean tryRegistrationPt(L2PcInstance pc)
	{
	//	if (isInvaded())
	//	{
	//		pc.sendMessage("̃O[vgpłB");
	//	//	pc.sendMessage("Another group is already fighting inside the imperial tomb.");
	//		return false;
	//	}
	//
	//	if (!FrintezzaManager.getInstance().isEnableEnterToLair())
	//	{
	//		pc.sendMessage("݁A󂯕tĂ܂B");
	//	//	pc.sendMessage("Currently no entry possible.");
	//		return false;
	//	}

		if (_partyLeaders.size() < Config.LIT_MAX_PARTY_CNT)
		{
			if (pc.getParty() != null)
			{
				if (pc.getParty().getLeader() == pc && pc.getInventory().getInventoryItemCount(SCROLL, -1) >= 1)
					return true;
			}
		}

		pc.sendMessage("p[eB[𗦂郊[_[utebŤEXN[vĂ΁AtebTľEɓ܂B");
	//	pc.sendMessage("You must be the leader of a party and possess a \"Frintezza's Magic Force Field Removal Scroll\".");
		return false;
	}

 //	public void unregisterPt(L2Party pt)
 //	{
 //		if (_partyLeaders.contains(pt.getLeader()))
 //		{
 //			_partyLeaders.remove(pt.getLeader());
 //			pt.getLeader().sendMessage("Warning: Unregistered from last imperial tomb invasion.");
 //		}
 //	}
 //
 //	public void unregisterPc(L2PcInstance pc)
 //	{
 //		if (_registedPlayers.contains(pc))
 //		{
 //			_registedPlayers.remove(pc);
 //			pc.sendMessage("Warning: Unregistered from last imperial tomb invasion.");
 //		}
 //	}

	// RegistrationMode = single.
	private/*public*/ boolean tryRegistrationPc(L2PcInstance pc)
	{
	//	if (isInvaded())
	//	{
	//		pc.sendMessage("̃O[vgpłB");
	//	//	pc.sendMessage("Another group is already fighting inside the imperial tomb.");
	//		return false;
	//	}
	//
	//	if (! FrintezzaManager.getInstance().isEnableEnterToLair())
	//	{
	//		pc.sendMessage("݁A󂯕tĂ܂B");
	//	//	pc.sendMessage("Currently no entry possible.");
	//		return false;
	//	}

		if (_registedPlayers.contains(pc))
		{
			pc.sendMessage("o^ςłB");
		//	pc.sendMessage("You are already registered.");
			return false;
		}

		if (_registedPlayers.size() < Config.LIT_MAX_PLAYER_CNT)
			if (pc.getInventory().getInventoryItemCount(SCROLL, -1) >= 1)
				return true;

		pc.sendMessage("utebŤEXN[vĂ΁AtebTľEɓ܂B");
	//	pc.sendMessage("You have to possess a \"Frintezza's Magic Force Field Removal Scroll\".");
		return false;
	}

	private L2Npc _npc32011;
	private boolean isTooFarTeleporter(L2PcInstance pc)	//[JOJO]
	{
		if (false) {
			return pc.getPlanDistanceSq(181376, -81008) > 6000 * 6000;
		} else {
			MapRegionTable m = MapRegionTable.getInstance();
			if (m.getMapRegionX(_npc32011.getX()) != m.getMapRegionX(pc.getX())
			 || m.getMapRegionY(_npc32011.getY()) != m.getMapRegionY(pc.getY()))
				return true;
			for (L2ZoneType z : ZoneManager.getInstance().getZones(pc))
				if (! z.isInsideZone(_npc32011))
					return true;
			return false;
		}
	}

	// Registration to enter to tomb.
	public synchronized String registration(int event, L2Npc npc, L2PcInstance pc) //<<== lastimperialtomb.py
	{
		_npc32011 = npc;
		String html = null;
		
		if (isInvaded())
		{
			npc.broadcastPacket(new CreatureSay(npc.getObjectId(), SystemChatChannelId.Chat_Normal, npc.getName(), "̃O[vgpłB"));
		//	pc.sendMessage("Another group is already fighting inside the imperial tomb.");
			return html;
		}
		
		if (!FrintezzaManager.getInstance().isEnableEnterToLair())
		{
			npc.broadcastPacket(new CreatureSay(npc.getObjectId(), SystemChatChannelId.Chat_Normal, npc.getName(), "݁A󂯕tĂ܂B"));
		//	pc.sendMessage("Currently no entry possible.");
			return html;
		}
		
		if (_commander == null && _partyLeaders.size() == 0 && _registedPlayers.size() == 0)
		{
			if (event == -1)	// 32011.htm
				return "<html><body>tebT e|[^[:<br>"
				+ "1lŌEɓ̂͂ƂĂ댯łB<br>"
				+ "<a action=\"bypass -h Quest lastimperialtomb 0\">A`lœ</a><br>"
				+ "<a action=\"bypass -h Quest lastimperialtomb 1\">p[eB[œ</a><br>"
				+ "<a action=\"bypass -h Quest lastimperialtomb 2\">t[œ</a>"
				+ "</body></html>";
			else
				Config.LIT_REGISTRATION_MODE = event;
		}
		else
		{
			if (event != -1)
				return html;
		}
		
		switch (Config.LIT_REGISTRATION_MODE)
		{
		case 0:
			if (! tryRegistrationCc(pc))
				return html;
		//	if (_commander != null)
		//		return;
			_commander = pc;
			if (_InvadeTask != null)
				_InvadeTask.cancel(true);
			_InvadeTask = ThreadPoolManager.getInstance().scheduleGeneral(new Invade(), 10000);
			npc.broadcastPacket(new CreatureSay(npc.getObjectId(), SystemChatChannelId.Chat_Normal, npc.getName()
					, "A`lo^܂B"));
			break;
		case 1:
			if (! tryRegistrationPt(pc))
				return html;
		//	if (_partyLeaders.contains(pc))
		//		return;
			_partyLeaders.add(pc);

			if (_partyLeaders.size() == 1)
				_RegistrationTimeInfoTask = ThreadPoolManager.getInstance().scheduleGeneral(
						new AnnouncementRegstrationInfo(npc, Config.LIT_REGISTRATION_TIME), 1000);
			npc.broadcastPacket(new CreatureSay(npc.getObjectId(), SystemChatChannelId.Chat_Party, npc.getName()
					, "p[eB[o^܂B"));
			break;
		case 2:
			if (! tryRegistrationPc(pc))
				return html;
		//	if (_registedPlayers.contains(pc))
		//		return;
			_registedPlayers.add(pc);
			if (_registedPlayers.size() == 1)
				_RegistrationTimeInfoTask = ThreadPoolManager.getInstance().scheduleGeneral(
						new AnnouncementRegstrationInfo(npc, Config.LIT_REGISTRATION_TIME), 1000);
			pc.sendMessage("t[œo^܂B");
			break;
		default:
			_log.warning("LastImperialTombManager: Invalid Registration Mode!");
			return html;
		}
		return html;
	}

	// Announcement of remaining time of registration to players.
	protected void doAnnouncementRegstrationInfo(L2Npc npc, int remaining)
	{
		CreatureSay cs = null;

		if (remaining == Config.LIT_REGISTRATION_TIME)
		{
			cs = new CreatureSay(npc.getObjectId(), SystemChatChannelId.Chat_Shout, npc.getName(), "tebTľEւ̓tJn܂B");
		//	cs = new CreatureSay(npc.getObjectId(), SystemChatChannelId.Chat_Shout, npc.getName(), "Entrance is now possible.");
			npc.broadcastPacket(cs);
		}

		if (remaining > 60000)
		{
				cs = new CreatureSay(npc.getObjectId(), SystemChatChannelId.Chat_Shout, npc.getName(), "tebTľEtI܂ŁA " + remaining / 60000 + "łB");
			//	cs = new CreatureSay(npc.getObjectId(), SystemChatChannelId.Chat_Shout, npc.getName(), (remaining / 60000) + " minute(s) left for entrance.");
				npc.broadcastPacket(cs);
				remaining = remaining - 60000;

				switch (Config.LIT_REGISTRATION_MODE)
				{
				case 1:
					cs = new CreatureSay(npc.getObjectId(), SystemChatChannelId.Chat_Shout, npc.getName(), "Œp[eB " + Config.LIT_MIN_PARTY_CNT);
				//	cs = new CreatureSay(npc.getObjectId(), SystemChatChannelId.Chat_Shout, npc.getName(), "For entrance, at least " + Config.LIT_MIN_PARTY_CNT + " parties are needed.");
					npc.broadcastPacket(cs);
					cs = new CreatureSay(npc.getObjectId(), SystemChatChannelId.Chat_Shout, npc.getName(), "őp[eB " + Config.LIT_MAX_PARTY_CNT);
				//	cs = new CreatureSay(npc.getObjectId(), SystemChatChannelId.Chat_Shout, npc.getName(), Config.LIT_MAX_PARTY_CNT + " is the maximum party count.");
					npc.broadcastPacket(cs);
					cs = new CreatureSay(npc.getObjectId(), SystemChatChannelId.Chat_Shout, npc.getName(), " " + _partyLeaders.size() + " g̃p[eBo^ς݂łB");
				//	cs = new CreatureSay(npc.getObjectId(), SystemChatChannelId.Chat_Shout, npc.getName(), "The current number of registered parties is " + _partyLeaders.size() + ".");
					npc.broadcastPacket(cs);
					break;
				case 2:
					cs = new CreatureSay(npc.getObjectId(), SystemChatChannelId.Chat_Shout, npc.getName(), "ŒҐ " + Config.LIT_MIN_PLAYER_CNT);
				//	cs = new CreatureSay(npc.getObjectId(), SystemChatChannelId.Chat_Shout, npc.getName(), "For entrance, at least " + Config.LIT_MIN_PLAYER_CNT + " people are needed.");
					npc.broadcastPacket(cs);
					cs = new CreatureSay(npc.getObjectId(), SystemChatChannelId.Chat_Shout, npc.getName(), "őҐ " + Config.LIT_MAX_PLAYER_CNT);
				//	cs = new CreatureSay(npc.getObjectId(), SystemChatChannelId.Chat_Shout, npc.getName(), Config.LIT_MAX_PLAYER_CNT + " is the capacity.");
					npc.broadcastPacket(cs);
					cs = new CreatureSay(npc.getObjectId(), SystemChatChannelId.Chat_Shout, npc.getName(), " " + _registedPlayers.size() + " o^ς݂łB");
				//	cs = new CreatureSay(npc.getObjectId(), SystemChatChannelId.Chat_Shout, npc.getName(), _registedPlayers.size() + " people are currently registered.");
					npc.broadcastPacket(cs);
					break;
				}

				if (_RegistrationTimeInfoTask != null)
					_RegistrationTimeInfoTask.cancel(true);
				_RegistrationTimeInfoTask = ThreadPoolManager.getInstance().scheduleGeneral(new AnnouncementRegstrationInfo(npc, remaining), 60000);
		}
		else if (remaining >= 10000)
		{
				cs = new CreatureSay(npc.getObjectId(), SystemChatChannelId.Chat_Shout, npc.getName(), "tebTľEtI܂ŁA " + remaining / 1000 + "błB");
			//	cs = new CreatureSay(npc.getObjectId(), SystemChatChannelId.Chat_Shout, npc.getName(), (remaining / 60000) + " minute(s) left for entrance.");
				npc.broadcastPacket(cs);
				remaining = remaining - 10000;

				switch (Config.LIT_REGISTRATION_MODE)
				{
				case 1:
					cs = new CreatureSay(npc.getObjectId(), SystemChatChannelId.Chat_Shout, npc.getName(), "Œp[eB " + Config.LIT_MIN_PARTY_CNT);
				//	cs = new CreatureSay(npc.getObjectId(), SystemChatChannelId.Chat_Shout, npc.getName(), "For entrance, at least " + Config.LIT_MIN_PARTY_CNT + " parties are needed.");
					npc.broadcastPacket(cs);
					cs = new CreatureSay(npc.getObjectId(), SystemChatChannelId.Chat_Shout, npc.getName(), "őp[eB " + Config.LIT_MAX_PARTY_CNT);
				//	cs = new CreatureSay(npc.getObjectId(), SystemChatChannelId.Chat_Shout, npc.getName(), Config.LIT_MAX_PARTY_CNT + " is the maximum party count.");
					npc.broadcastPacket(cs);
					cs = new CreatureSay(npc.getObjectId(), SystemChatChannelId.Chat_Shout, npc.getName(), " " + _partyLeaders.size() + " g̃p[eBo^ς݂łB");
				//	cs = new CreatureSay(npc.getObjectId(), SystemChatChannelId.Chat_Shout, npc.getName(), "The current number of registered parties is " + _partyLeaders.size() + ".");
					npc.broadcastPacket(cs);
					break;
				case 2:
					cs = new CreatureSay(npc.getObjectId(), SystemChatChannelId.Chat_Shout, npc.getName(), " " + _registedPlayers.size() + " o^ς݂łB");
				//	cs = new CreatureSay(npc.getObjectId(), SystemChatChannelId.Chat_Shout, npc.getName(), "For entrance, at least " + Config.LIT_MIN_PLAYER_CNT + " people are needed.");
					npc.broadcastPacket(cs);
					cs = new CreatureSay(npc.getObjectId(), SystemChatChannelId.Chat_Shout, npc.getName(), "őҐ " + Config.LIT_MAX_PLAYER_CNT);
				//	cs = new CreatureSay(npc.getObjectId(), SystemChatChannelId.Chat_Shout, npc.getName(), "Config.LIT_MAX_PLAYER_CNT + " is the capacity.");
					npc.broadcastPacket(cs);
					cs = new CreatureSay(npc.getObjectId(), SystemChatChannelId.Chat_Shout, npc.getName(), "ŒҐ " + Config.LIT_MIN_PLAYER_CNT);
				//	cs = new CreatureSay(npc.getObjectId(), SystemChatChannelId.Chat_Shout, npc.getName(), _registedPlayers.size() + " people are currently registered.");
					npc.broadcastPacket(cs);
					break;
				}

				if (_RegistrationTimeInfoTask != null)
					_RegistrationTimeInfoTask.cancel(true);
				_RegistrationTimeInfoTask = ThreadPoolManager.getInstance().scheduleGeneral(new AnnouncementRegstrationInfo(npc, remaining), 10000);
		}
		else
		{
			cs = new CreatureSay(npc.getObjectId(), SystemChatChannelId.Chat_Shout, npc.getName(), "tebTľEւ̓tI܂B");
		//	cs = new CreatureSay(npc.getObjectId(), SystemChatChannelId.Chat_Shout, npc.getName(), "Entrance period ended.");
			npc.broadcastPacket(cs);

			switch (Config.LIT_REGISTRATION_MODE)
			{
			case 1:
				if ((_partyLeaders.size() < Config.LIT_MIN_PARTY_CNT) || (_partyLeaders.size() > Config.LIT_MAX_PARTY_CNT))
				{
					cs = new CreatureSay(npc.getObjectId(), SystemChatChannelId.Chat_Shout, npc.getName(), "g̏𖞂Ȃ߁AꂪLZ܂B");
				//	cs = new CreatureSay(npc.getObjectId(), SystemChatChannelId.Chat_Shout, npc.getName(), "Since the conditions were not met, the entrance was refused.");
					npc.broadcastPacket(cs);
					cleanUpTomb();	//[JOJO]
					return;
				}
				break;
			case 2:
				if ((_registedPlayers.size() < Config.LIT_MIN_PLAYER_CNT) || (_registedPlayers.size() > Config.LIT_MAX_PLAYER_CNT))
				{
					cs = new CreatureSay(npc.getObjectId(), SystemChatChannelId.Chat_Shout, npc.getName(), "Ґ̏𖞂Ȃ߁AꂪLZ܂B");
				//	cs = new CreatureSay(npc.getObjectId(), SystemChatChannelId.Chat_Shout, npc.getName(), "Since the conditions were not met, the entrance was refused.");
					npc.broadcastPacket(cs);
					cleanUpTomb();	//[JOJO]
					return;
				}
				break;
			}

			if (_RegistrationTimeInfoTask != null)
				_RegistrationTimeInfoTask.cancel(true);
			_RegistrationTimeInfoTask = null;

			if (_InvadeTask != null)
				_InvadeTask.cancel(true);
			_InvadeTask = ThreadPoolManager.getInstance().scheduleGeneral(new Invade(), 10000);
		}
	}

	// Invade to tomb.
	public void doInvade()
	{
		initDoors();
//		if (TEST) { DoorTable.getInstance().getDoor(25150046).openMe(); _invadeLoc[0] = new int[]{174234, -85615, -5112}; }	//tebT̔̊O

		switch (Config.LIT_REGISTRATION_MODE)
		{
		case 0:
			doInvadeCc();
			break;
		case 1:
			doInvadePt();
			break;
		case 2:
			doInvadePc();
			break;
		default:
			_log.warning("LastImperialTombManager: Invalid Registration Mode!");
			return;
		}

		_commander = null;						//[JOJO]
		_partyLeaders.clear();					//[JOJO]
		_registedPlayers.clear();				//[JOJO]
		if (getZone().getAllowedPlayers().isEmpty()) return;	//[JOJO]
		if (Config.GEODATA == 0)
		{
			//[JOJO] ǃf[^̂Ƃ́Ao̔zMOB@ōUĂ̂
			// o͔̔JĂƂɂB
			DoorTable.getInstance().getDoor(25150052).openMe();
			DoorTable.getInstance().getDoor(25150054).openMe();
			DoorTable.getInstance().getDoor(25150058).openMe();
		}

		_isInvaded = true;

		if (_Room1SpawnTask != null)
			_Room1SpawnTask.cancel(true);
		_Room1SpawnTask = ThreadPoolManager.getInstance().scheduleGeneral(new SpawnRoom1Mobs1st(), 15000);

		if (_CheckTimeUpTask != null)
			_CheckTimeUpTask.cancel(true);
		_CheckTimeUpTask = ThreadPoolManager.getInstance().scheduleGeneral(new CheckTimeUp(Config.LIT_TIME_LIMIT), 15000);
	}

	private void destroyItem(L2PcInstance pc, int itemId)
	{
		L2ItemInstance i = pc.getInventory().getItemByItemId(itemId);
		if (i != null)
			pc.destroyItemByItemId("Quest", itemId, i.getCount(), pc, true);
	}

	// Invade to tomb. when registration mode is command channel.
	private void doInvadeCc()
	{
		int locId = 0;

		if (_commander.getInventory().getInventoryItemCount(SCROLL, -1) < 1 || isTooFarTeleporter(_commander))
		{
			_commander.sendPacket(new SystemMessage(SystemMessageId.NOT_ENOUGH_REQUIRED_ITEMS));

			_commander.sendMessage("𖞂ĂȂ߁Aꂪۂ܂B");
		//	_commander.sendMessage("Since the conditions were not met, the entrance was refused.");

			return;
		}

		_commander.destroyItemByItemId("Quest", SCROLL, 1, _commander, true);

		for (L2Party pt : _commander.getParty().getCommandChannel().getPartys())
		{
			if (locId >= 5)
				locId = 0;

			for (L2PcInstance pc : pt.getPartyMembers())
			{
				if (isTooFarTeleporter(pc)) continue;
				getZone().allowPlayerEntry(pc, 30);
				pc.teleToLocation(_invadeLoc[locId][0] + Rnd.get(50), _invadeLoc[locId][1] + Rnd.get(50), _invadeLoc[locId][2]);
				destroyItem(pc, SOUL_BREAKING_ARROW);
				destroyItem(pc, DEWDROP_OF_DESTRUCTION);
			}

			locId++;
		}
	}

	// Invade to tomb. when registration mode is party.
	private void doInvadePt()
	{
		int locId = 0;
		boolean isReadyToInvade = true;

		for (L2PcInstance ptl : _partyLeaders)
		{
			if (ptl.getInventory().getInventoryItemCount(SCROLL, -1) < 1 || isTooFarTeleporter(ptl))
			{
				ptl.sendPacket(new SystemMessage(SystemMessageId.NOT_ENOUGH_REQUIRED_ITEMS));
				ptl.sendMessage("𖞂ĂȂ߁Aꂪۂ܂B");
				isReadyToInvade = false;
			}
		}

		if (!isReadyToInvade)
		{
			for (L2PcInstance ptl : _partyLeaders)
			{
				ptl.sendMessage("𖞂ĂȂp[eB邽߁Aꂪۂ܂B");
			}
			return;
		}

	//	for (L2PcInstance ptl : _partyLeaders)
	//	{
	//		ptl.destroyItemByItemId("Quest", SCROLL, 1, _commander, true);
	//	}

		for (L2PcInstance ptl : _partyLeaders)
		{
			ptl.destroyItemByItemId("Quest", SCROLL, 1, _commander, true);
			if (locId >= 5)
				locId = 0;

			for (L2PcInstance pc : ptl.getParty().getPartyMembers())
			{
				if (isTooFarTeleporter(pc)) continue;
				getZone().allowPlayerEntry(pc, 30);
				pc.teleToLocation(_invadeLoc[locId][0] + Rnd.get(50), _invadeLoc[locId][1] + Rnd.get(50), _invadeLoc[locId][2]);
				destroyItem(pc, SOUL_BREAKING_ARROW);
				destroyItem(pc, DEWDROP_OF_DESTRUCTION);
			}

			locId++;
		}
	}

	// Invade to tomb. when registration mode is single.
	private void doInvadePc()
	{
		int locId = 0;
		boolean isReadyToInvade = true;

		for (L2PcInstance pc : _registedPlayers)
		{
			if (pc.getInventory().getInventoryItemCount(SCROLL, -1) < 1)
			{
				SystemMessage sm = new SystemMessage(SystemMessageId.NOT_ENOUGH_REQUIRED_ITEMS);
				pc.sendPacket(sm);
				pc.sendMessage("𖞂ĂȂ߁Aꂪۂ܂B");
			//	pc.sendMessage("Since the conditions were not met, the entrance was refused.");
				isReadyToInvade = false;
			}
		}

		if (!isReadyToInvade)
		{
			for (L2PcInstance pc : _registedPlayers)
			{
				pc.sendMessage("𖞂ĂȂvC[邽߁Aꂪۂ܂B");
			//	pc.sendMessage("Since the conditions were not met, the entrance was refused.");
			}
			return;
		}

	//	for (L2PcInstance pc : _registedPlayers)
	//	{
	//		pc.destroyItemByItemId("Quest", SCROLL, 1, _commander, true);
	//	}

		for (L2PcInstance pc : _registedPlayers)
		{
			if (isTooFarTeleporter(pc)) continue;
			pc.destroyItemByItemId("Quest", SCROLL, 1, _commander, true);
			
			if (locId >= 5)
				locId = 0;

			getZone().allowPlayerEntry(pc, 30);
			pc.teleToLocation(_invadeLoc[locId][0] + Rnd.get(50), _invadeLoc[locId][1] + Rnd.get(50), _invadeLoc[locId][2]);
			destroyItem(pc, SOUL_BREAKING_ARROW);
			destroyItem(pc, DEWDROP_OF_DESTRUCTION);

			locId++;
		}
	}

	// Is the door of room1 in confirmation to open.
	public void onKillHallAlarmDevice() //<<== lastimperialtomb.py
	{
		int killCnt = 0;

		for (L2Npc HallAlarmDevice : _hallAlarmDevices)
		{
			if (HallAlarmDevice.isDead())
				killCnt++;
		}

		switch (killCnt)
		{
		case 1:
			if (Rnd.get(100) < 10)
			{
				openRoom1Doors();
				openRoom2OutsideDoors();
				spawnRoom2InsideMob();
			}
			else
			{
				if (_Room1SpawnTask != null)
					_Room1SpawnTask.cancel(true);

				_Room1SpawnTask = ThreadPoolManager.getInstance().scheduleGeneral(new SpawnRoom1Mobs2nd(), 3000);
			}
			break;
		case 2:
			if (Rnd.get(100) < 20)
			{
				openRoom1Doors();
				openRoom2OutsideDoors();
				spawnRoom2InsideMob();
			}
			else
			{
				if (_Room1SpawnTask != null)
					_Room1SpawnTask.cancel(true);

				_Room1SpawnTask = ThreadPoolManager.getInstance().scheduleGeneral(new SpawnRoom1Mobs3rd(), 3000);
			}
			break;
		case 3:
			if (Rnd.get(100) < 30)
			{
				openRoom1Doors();
				openRoom2OutsideDoors();
				spawnRoom2InsideMob();
			}
			else
			{
				if (_Room1SpawnTask != null)
					_Room1SpawnTask.cancel(true);

				_Room1SpawnTask = ThreadPoolManager.getInstance().scheduleGeneral(new SpawnRoom1Mobs4th(), 3000);
			}
			break;
		case 4:
			openRoom1Doors();
			openRoom2OutsideDoors();
			spawnRoom2InsideMob();
		}
	}

	// Is the door of inside of room2 in confirmation to open.
	public void onKillDarkChoirPlayer() //<<== lastimperialtomb.py
	{
		int killCnt = 0;

		for (L2Npc DarkChoirPlayer : _room2InsideMonsters)
		{
			if (DarkChoirPlayer.isDead())
				killCnt++;
		}

		if (_room2InsideMonsters.size() <= killCnt)
		{
			if (_Room2InsideDoorOpenTask != null)
				_Room2InsideDoorOpenTask.cancel(true);
			if (_Room2OutsideSpawnTask != null)
				_Room2OutsideSpawnTask.cancel(true);

			_Room2InsideDoorOpenTask = ThreadPoolManager.getInstance().scheduleGeneral(new OpenRoom2InsideDoors(), 3000);
			_Room2OutsideSpawnTask = ThreadPoolManager.getInstance().scheduleGeneral(new SpawnRoom2OutsideMobs(), 4000);
		}
	}

	// Is the door of outside of room2 in confirmation to open.
	public void onKillDarkChoirCaptain() //<<== lastimperialtomb.py
	{
		L2Npc alive = null;
	//	int killCnt = 0;

		for (L2Npc DarkChoirCaptain : _darkChoirCaptains)
		{
			if (! DarkChoirCaptain.isDead())
				{ alive = DarkChoirCaptain; break; }
			//	killCnt++;
		}

		if (alive == null)
	//	if (_darkChoirCaptains.size() <= killCnt)
		{
			openRoom2OutsideDoors();

			for (L2Npc mob : _room2OutsideMonsters)
			{
				mob.deleteMe();
				mob.getSpawn().stopRespawn();
			}

			for (L2Npc DarkChoirCaptain : _darkChoirCaptains)
			{
				DarkChoirCaptain.deleteMe();
				DarkChoirCaptain.getSpawn().stopRespawn();
			}
		}
		else	//[JOJO]
		{
			alive.broadcastPacket(new CreatureSay(0, SystemChatChannelId.Chat_Shout,
					"̒c", "̒c̉tWז҂I"));
		}
	}

	private void openRoom1Doors()
	{
		for (L2Npc npc : _hallAlarmDevices)
		{
			npc.deleteMe();
			npc.getSpawn().stopRespawn();
		}

		for (L2Npc npc : _room1Monsters)
		{
			npc.deleteMe();
			npc.getSpawn().stopRespawn();
		}

		for (L2DoorInstance door : _room1Doors)
		{
			door.openMe();
		}
	}

	protected void openRoom2InsideDoors()
	{
		for (L2DoorInstance door : _room2InsideDoors)
		{
			door.openMe();
		}
	}

	protected void openRoom2OutsideDoors()
	{
		for (L2DoorInstance door : _room2OutsideDoors)
		{
			door.openMe();
		}
		_room3Door.openMe();
	}

	protected void closeRoom2OutsideDoors()
	{
		for (L2DoorInstance door : _room2OutsideDoors)
		{
			door.closeMe();
		}
		_room3Door.closeMe();
	}

	private void spawnRoom2InsideMob()
	{
		L2Npc mob;
		for (L2Spawn spawn : LastImperialTombSpawnlist.getInstance().getRoom2InsideSpawnList())
		{
			mob = spawn.doSpawn();
			mob.getSpawn().stopRespawn();
			_room2InsideMonsters.add(mob);
		}
	}

 	public void setReachToHall()
 	{
 		_isReachToHall = true;
		if (_CheckTimeUpTask != null)	//[JOJO]
			_CheckTimeUpTask.cancel(false);
		_CheckTimeUpTask = null;
	}

	protected void doCheckTimeUp(int remaining)
	{
		if (_isReachToHall)
			return;

		ExShowScreenMessage cs = null;
	//	CreatureSay cs = null;
		int timeLeft;
		int interval;

		if (remaining > 300000)
		{
			timeLeft = remaining / 60000;
			interval = 300000;
			cs = new ExShowScreenMessage("c" + timeLeft + "łB", 7000);
		//	cs = new CreatureSay(0, SystemChatChannelId.Chat_Alliance, "Notice", timeLeft + " minutes left.");
			remaining -= interval;
		}
		else if (remaining > 60000)
		{
			timeLeft = remaining / 60000;
			interval = 60000;
			cs = new ExShowScreenMessage("c" + timeLeft + "łB", 7000);
		//	cs = new CreatureSay(0, SystemChatChannelId.Chat_Alliance, "Notice", timeLeft + " minutes left.");
			remaining -= interval;
		}
		else if (remaining > 30000)
		{
			timeLeft = remaining / 1000;
			interval = 30000;
			cs = new ExShowScreenMessage("c" + timeLeft + "błB", 7000);
		//	cs = new CreatureSay(0, SystemChatChannelId.Chat_Alliance, "Notice", timeLeft + " seconds left.");
			remaining -= interval;
		}
		else
		{
			timeLeft = remaining / 1000;
			interval = 10000;
			cs = new ExShowScreenMessage("c" + timeLeft + "błB", 7000);
		//	cs = new CreatureSay(0, SystemChatChannelId.Chat_Alliance, "Notice", timeLeft + " seconds left.");
			remaining -= interval;
		}

		for (L2PcInstance pc : getPlayersInside())
		{
			pc.sendPacket(cs);
		}

		if (_CheckTimeUpTask != null)
			_CheckTimeUpTask.cancel(true);
		if (remaining >= 10000)
			_CheckTimeUpTask = ThreadPoolManager.getInstance().scheduleGeneral(new CheckTimeUp(remaining), interval);
		else
			_CheckTimeUpTask = ThreadPoolManager.getInstance().scheduleGeneral(new TimeUp(), interval);
	}

	public/*protected*/ void cleanUpTomb()
	{
		initDoors();
		cleanUpMobs();
		banishForeigners();
		cleanUpRegister();
		_isInvaded = false;
		_isReachToHall = false;

		if (_InvadeTask != null)
			_InvadeTask.cancel(true);
		_InvadeTask = null;

		if (_RegistrationTimeInfoTask != null)
			_RegistrationTimeInfoTask.cancel(true);
		_RegistrationTimeInfoTask = null;

		if (_Room1SpawnTask != null)
			_Room1SpawnTask.cancel(true);
		_Room1SpawnTask = null;

		if (_Room2InsideDoorOpenTask != null)
			_Room2InsideDoorOpenTask.cancel(true);
		_Room2InsideDoorOpenTask = null;

		if (_Room2OutsideSpawnTask != null)
			_Room2OutsideSpawnTask.cancel(true);
		_Room2OutsideSpawnTask = null;

		if (_CheckTimeUpTask != null)
			_CheckTimeUpTask.cancel(true);
		_CheckTimeUpTask = null;
	}

	// Delete all mobs from tomb.
	public/*private*/ void cleanUpMobs()
	{
		for (L2Npc mob : _hallAlarmDevices)
		{
			mob.getSpawn().stopRespawn();
			mob.deleteMe();
		}
		_hallAlarmDevices.clear();

		for (L2Npc mob : _darkChoirPlayers)
		{
			mob.getSpawn().stopRespawn();
			mob.deleteMe();
		}
		_darkChoirPlayers.clear();

		for (L2Npc mob : _darkChoirCaptains)
		{
			mob.getSpawn().stopRespawn();
			mob.deleteMe();
		}
		_darkChoirCaptains.clear();

		for (L2Npc mob : _room1Monsters)
		{
			mob.getSpawn().stopRespawn();
			mob.deleteMe();
		}
		_room1Monsters.clear();

		for (L2Npc mob : _room2InsideMonsters)
		{
			mob.getSpawn().stopRespawn();
			mob.deleteMe();
		}
		_room2InsideMonsters.clear();

		for (L2Npc mob : _room2OutsideMonsters)
		{
			mob.getSpawn().stopRespawn();
			mob.deleteMe();
		}
		_room2OutsideMonsters.clear();
	}

	private void cleanUpRegister()
	{
		_commander = null;
		_partyLeaders.clear();
		_registedPlayers.clear();
	}

	/*private*/ class SpawnRoom1Mobs1st implements Runnable
	{
		public void run()
		{
			L2Npc mob;
			for (L2Spawn spawn : LastImperialTombSpawnlist.getInstance().getRoom1SpawnList1st())
			{
				if (spawn.getNpcid() == 18328)
				{
					mob = spawn.doSpawn();
					mob.getSpawn().stopRespawn();
					_hallAlarmDevices.add(mob);
				}
				else
				{
					mob = spawn.doSpawn();
					mob.getSpawn().stopRespawn();
					_room1Monsters.add(mob);
				}
			}
		}
	}

	/*private*/ class SpawnRoom1Mobs2nd implements Runnable
	{
		public void run()
		{
			L2Npc mob;
			for (L2Spawn spawn : LastImperialTombSpawnlist.getInstance().getRoom1SpawnList2nd())
			{
				mob = spawn.doSpawn();
				mob.getSpawn().stopRespawn();
				_room1Monsters.add(mob);
			}
		}
	}

	/*private*/ class SpawnRoom1Mobs3rd implements Runnable
	{
		public void run()
		{
			L2Npc mob;
			for (L2Spawn spawn : LastImperialTombSpawnlist.getInstance().getRoom1SpawnList3rd())
			{
				mob = spawn.doSpawn();
				mob.getSpawn().stopRespawn();
				_room1Monsters.add(mob);
			}
		}
	}

	/*private*/ class SpawnRoom1Mobs4th implements Runnable
	{
		public void run()
		{
			L2Npc mob;
			for (L2Spawn spawn : LastImperialTombSpawnlist.getInstance().getRoom1SpawnList4th())
			{
				mob = spawn.doSpawn();
				mob.getSpawn().stopRespawn();
				_room1Monsters.add(mob);
			}
		}
	}

	/*private*/ class OpenRoom2InsideDoors implements Runnable
	{
		public void run()
		{
			closeRoom2OutsideDoors();
			openRoom2InsideDoors();
		}
	}

	/*private*/ class SpawnRoom2OutsideMobs implements Runnable
	{
		public void run()
		{
			for (L2Spawn spawn : LastImperialTombSpawnlist.getInstance().getRoom2OutsideSpawnList())
			{
				if (spawn.getNpcid() == 18334)	//̒c
				{
					L2Npc mob = spawn.doSpawn();
					mob.getSpawn().stopRespawn();
					_darkChoirCaptains.add(mob);
				}
				else	//̒c v}AT[AA[`[AEBU[h
				{
					L2Npc mob = spawn.doSpawn();
					mob.getSpawn().startRespawn();
					_room2OutsideMonsters.add(mob);
				}
			}
			_darkChoirCaptains.get(0).broadcastPacket(new CreatureSay(0, SystemChatChannelId.Chat_Shout,
					"̒c", "̒c̃Xe[WԂ󂷂Ƃ́DDDʁI"));	//[JOJO]
		}
	}

	private class AnnouncementRegstrationInfo implements Runnable
	{
		private final L2Npc	_npc;
		private final int				_remaining;

		public AnnouncementRegstrationInfo(L2Npc npc, int remaining)
		{
			_npc = npc;
			_remaining = remaining;
		}

		public void run()
		{
			doAnnouncementRegstrationInfo(_npc, _remaining);
		}
	}

	/*private*/ class Invade implements Runnable
	{
		public void run()
		{
			doInvade();
		}
	}

	private class CheckTimeUp implements Runnable
	{
		private final int	_remaining;

		public CheckTimeUp(int remaining)
		{
			_remaining = remaining;
		}

		public void run()
		{
			doCheckTimeUp(_remaining);
		}
	}

	/*private*/ class TimeUp implements Runnable
	{
		public void run()
		{
			cleanUpTomb();
		}
	}

	// When the party is annihilated, they are banished.
	@Override
	public void checkAnnihilated()
	{
		if (isPlayersAnnihilated())
		{
			ThreadPoolManager.getInstance().scheduleGeneral(new Runnable()
			{
				public void run()
				{
					FrintezzaManager.getInstance().setUnspawn();
					cleanUpTomb();
				}
			}, 10000);
		}
	}

	////////////////////////////////////////////////////////////////////
	// [class BossLair]

	// location of escae.
	private final int[][] _escapeLocations = {
		//{   x1      y1      z1      x2      y2  (z2) }
		  { 146690, -56270, -2785, 147190, -55770 }
		, { 146190, -56470, -2785, 146690, -55970 }
		, { 148240, -55770, -2785, 148740, -56270 }
		, { 147100, -58560, -2965, 148300, -58060 }
		};

	public void escapeForeigner(L2PcInstance pc)	//<<== NPC 29061 Teleportation Cubic
	{
		int[] loc = _escapeLocations[Rnd.get(_escapeLocations.length)];
		int x = Rnd.get(loc[0], loc[3]);
		int y = Rnd.get(loc[1], loc[4]);
		int z = loc[2];
//		if (TEST) { x = 181372; y = -80930; z = -2785; }	//tebT e|[^[̑O
		pc.teleToLocation(x, y, z);
	}

	@Override public void banishForeigners()
	{
		for (L2PcInstance pc : getPlayersInside())
			escapeForeigner(pc);

		super.banishForeigners();
	}

	/////////////////////////////////////////////////////////////////////

	@SuppressWarnings("synthetic-access")
	private static class SingletonHolder
	{
		protected static final LastImperialTombManager _instance = new LastImperialTombManager();
	}
}
