/*
 * This program is free software: you can redistribute it and/or modify it under
 * the terms of the GNU General Public License as published by the Free Software
 * Foundation, either version 3 of the License, or (at your option) any later
 * version.
 * 
 * This program is distributed in the hope that it will be useful, but WITHOUT
 * ANY WARRANTY; without even the implied warranty of MERCHANTABILITY or FITNESS
 * FOR A PARTICULAR PURPOSE. See the GNU General Public License for more
 * details.
 * 
 * You should have received a copy of the GNU General Public License along with
 * this program. If not, see <http://www.gnu.org/licenses/>.
 */
package net.sf.l2j.gameserver.model.actor.instance;

import java.util.Collection;
import java.util.concurrent.ScheduledFuture;

import net.sf.l2j.gameserver.ThreadPoolManager;
import net.sf.l2j.gameserver.datatables.SkillTable;
import net.sf.l2j.gameserver.model.L2Object;
import net.sf.l2j.gameserver.model.L2Skill;
import net.sf.l2j.gameserver.model.actor.L2Character;
import net.sf.l2j.gameserver.model.actor.L2Npc;
import net.sf.l2j.gameserver.network.serverpackets.MagicSkillUse;
import net.sf.l2j.gameserver.network.serverpackets.AbstractNpcInfo.NpcInfo;
import net.sf.l2j.gameserver.templates.chars.L2NpcTemplate;

/**
 * @author Drunkard Zabb0x
 * Lets drink2code!
 * 
 * @author JOJO
 *  TODO: UPDATE npc SET type='L2XmassTree' WHERE id in (13006, 13007);
 *  See also: SummonItems#useItem(), summon_items.csv
 */
public class L2XmassTreeInstance extends L2Npc
{
	private static final long DESPAWN_DELAY_REGULAR = 21600000;	//6H
	private static final long DESPAWN_DELAY_SPECIAL = 43200000;	//12H

	static final int[][] _buffs = {
		 { 4262, 2 }	// NX}X EBh EH[N^莞ԁAړxサԁB2B
		,{ 4263, 1 }	// NX}X wCXg^ꎞIɍUxコB1B
		,{ 4264, 1 }	// NX}X Gp[^ꎞIɖ͂サԁB1B
		,{ 4265, 3 }	// NX}X }Cg^ꎞIɍU͂サԁB3B
		,{ 4266, 3 }	// NX}X V[h^ꎞIɖh͂サԁB3B
	};

    private ScheduledFuture<?> _aiTask;

    private class XmassAI implements Runnable
    {
        private L2XmassTreeInstance _caster;
        private long _despawnTime;
        private int _buffIndex = 0;

        protected XmassAI(L2XmassTreeInstance caster)
        {
            _caster = caster;
            _despawnTime = System.currentTimeMillis() + DESPAWN_DELAY_SPECIAL;
        }

        public void run()
        {
        	if (System.currentTimeMillis() > _despawnTime)
        	{
        		deleteMe();
        		return;
        	}
        	Collection<L2PcInstance> plrs = getKnownList().getKnownPlayers().values();
        	//synchronized (getKnownList().getKnownPlayers())
			{
				for (L2PcInstance player : plrs)
				{
					if (player.isMovementDisabled())
						continue;
					if (player.getPkKills() > 5)
						continue;
					if (! isInsideRadius(player, getDistanceToWatchObject(player)))
						continue;
					boolean done = false;
					if (player.getCurrentMp() < player.getMaxMp() * 9 / 10) {
						player.setCurrentMp(player.getCurrentMp() + player.getMaxMp() / player.getLevel());
						done = true;
					}
					if (player.getCurrentHp() < player.getMaxHp() * 9 / 10) {
						player.setCurrentHp(player.getCurrentHp() + player.getMaxHp() / player.getLevel());
						done = true;
					}
					if (! done && ! player.isInvul())
					{
						_buffIndex %= _buffs.length;
						int[] b = _buffs[_buffIndex++];
						handleCast(player, b[0], b[1]);
					}
				}
			}
        }

        private boolean handleCast(L2PcInstance player, int skillId, int skillLevel)
        {
            L2Skill skill = SkillTable.getInstance().getInfo(skillId, skillLevel);

            if (player.getFirstEffect(skill) == null)
            {
                setTarget(player);
                doCast(skill);

                MagicSkillUse msu = new MagicSkillUse(_caster, player, skillId, skillLevel, skill.getHitTime(), 0);
                broadcastPacket(msu);

                return true;
            }

            return false;
        }

    }

    public L2XmassTreeInstance(int objectId, L2NpcTemplate template)
    {
        super(objectId, template);
    // _aiTask = ThreadPoolManager.getInstance().scheduleGeneralAtFixedRate(new XmassAI(this), 3000, 3000);
    }

	public void startRegularAI(String title)
	{
		setTitle(title);
		broadcastPacket(new NpcInfo(this, null));
		
		_aiTask = ThreadPoolManager.getInstance().scheduleGeneral(
				new Despawn()
				, DESPAWN_DELAY_REGULAR);
	}
	
	public void startSpecialAI(String title)
	{
		setTitle(title);
		broadcastPacket(new NpcInfo(this, null));
		
		if (getIsInTown())
			_aiTask = ThreadPoolManager.getInstance().scheduleGeneral(
					new Despawn()
					, DESPAWN_DELAY_REGULAR);
		else
			_aiTask = ThreadPoolManager.getInstance().scheduleGeneralAtFixedRate(
					new XmassAI(this)
					, 3000, 3000);
	}
	class Despawn implements Runnable
	{
		public void run() { deleteMe(); }
	}
	
	public static boolean canSpawn(int npcId/*=>13007*/, L2PcInstance owner)
	{
		final int instanceId = owner.getInstanceId();
		for (L2Object o : owner.getKnownList().getKnownObjects().values())
		{
			if (o instanceof L2XmassTreeInstance)
			{
				L2XmassTreeInstance tree = (L2XmassTreeInstance)o;
				if (tree.getNpcId() == npcId
						&& tree.getInstanceId() == instanceId
						&& tree.isInsideRadius(owner, tree.getDistanceToWatchObject(owner) * 2))
					return false;
			}
		}
		return true;
	}
	
	boolean isInsideRadius(L2Object object, int radius)
	{
		long dx = object.getX() - getX();
		long dy = object.getY() - getY();
		return (dx * dx + dy * dy) <= radius * radius;
	}

    @Override
	public void deleteMe()
    {
        if (_aiTask != null) _aiTask.cancel(true);
        _aiTask = null;

        super.deleteMe();
    }

    @Override
	public int getDistanceToWatchObject(L2Object object)
    {
        return 900;
    }

    /* (non-Javadoc)
     * @see net.sf.l2j.gameserver.model.L2Object#isAttackable()
     */
    @Override
	public boolean isAutoAttackable(L2Character attacker)
    {
        return false;
    }

}
