﻿## Active Perl 5.8.8

# NPCのhtmをまとめて書き換える

use utf8;
use strict;
use warnings;

binmode STDOUT, ':encoding(cp932)';
sub   FS {Encode::encode('cp932',shift)}
sub UTF8 {Encode::decode('cp932',shift)}

# 冒険家組合員(すべて)
&start('gameserver/data/html/adventurer_guildsman/');
## 31863 見習いサンタ
#&start('gameserver/data/html/default/31863.htm');
exit 0;

sub start {
	my ($arg1) = @_;
	my @files;
	if (-d $arg1) {
		opendir DIR, $arg1 or die $arg1;
		@files = grep /^\d+\.htm$/, readdir DIR;
		closedir DIR;
		$_ = $arg1 . UTF8($_) foreach @files;
	} elsif (-e $arg1) {
		@files = ($arg1);
	} else {
		print $arg1," - not found.\007\n";
		return;
	}

	foreach my $filePath (@files) {
		# ファイル読み込み
		open FILE,'<:utf8',FS($filePath)  or die $filePath;
		        my $mtime = (stat FILE)[9];
		read FILE, my $htm, (stat FILE)[7];
		close FILE;
		my $original = $htm;

		## 条件
		## next unless $htm =~ m/冒険家組合員:|Adventure Guildsman:/s;

		# 一旦削除してから
		$htm =~ s|<!--NPCBUFF-->.*?<!--/NPCBUFF-->\n||s;

		# 追加する
		my ($npcid) = ($filePath =~ m|(\d+)\.htm$|);
		if ($npcid % 2) {
			# 奇数NPC
			$htm =~ s|</body>|<!--NPCBUFF--><br>
<font color="00ff00">補助魔法</font><br1>
[<a action="bypass -h npc_%objectId%_Link custom/npcbuff-Basic.htm">基本</a>]
[<a action="bypass -h npc_%objectId%_Link custom/npcbuff-ProphetMage.htm">プロフィットＭ</a>]
[<a action="bypass -h npc_%objectId%_Link custom/npcbuff-DanceMage.htm">ダンスＭ</a>]
[<a action="bypass -h npc_%objectId%_Link custom/npcbuff-SongMage.htm">ソングＭ</a>]<br1>
[<a action="bypass -h npc_%objectId%_Link custom/npcbuff-OrcShaman.htm">シャーマン</a>]
[<a action="bypass -h npc_%objectId%_Link custom/npcbuff-OrcOverlord.htm">オーバーロード</a>]
[<a action="bypass -h npc_%objectId%_Link custom/npcbuff-OrcWarcryer.htm">ウォークライヤー</a>]<br1>
[<a action="bypass -h npc_%objectId%_Link custom/npcbuff-HeroNoble.htm">英雄</a>]
[<a action="bypass -h npc_%objectId%_Link custom/npcbuff-SupportMagic.htm">初心者</a>]
<!--/NPCBUFF-->\n$&|s;
	} else {
			# 偶数NPC
			$htm =~ s|</body>|<!--NPCBUFF--><br>
<font color="00ffff">補助魔法</font><br1>
[<a action="bypass -h npc_%objectId%_Link custom/npcbuff-Basic.htm">基本</a>]
[<a action="bypass -h npc_%objectId%_Link custom/npcbuff-ProphetFighter.htm">プロフィットＦ</a>]
[<a action="bypass -h npc_%objectId%_Link custom/npcbuff-DanceFighter.htm">ダンスＦ</a>]
[<a action="bypass -h npc_%objectId%_Link custom/npcbuff-SongFighter.htm">ソングＦ</a>]<br1>
[<a action="bypass -h npc_%objectId%_Link custom/npcbuff-OrcShaman.htm">シャーマン</a>]
[<a action="bypass -h npc_%objectId%_Link custom/npcbuff-OrcOverlord.htm">オーバーロード</a>]
[<a action="bypass -h npc_%objectId%_Link custom/npcbuff-OrcWarcryer.htm">ウォークライヤー</a>]<br1>
[<a action="bypass -h npc_%objectId%_Link custom/npcbuff-HeroNoble.htm">英雄</a>]
[<a action="bypass -h npc_%objectId%_Link custom/npcbuff-SupportMagic.htm">初心者</a>]
<!--/NPCBUFF-->\n$&|s;
	}
# 未使用 #
#[<a action="bypass -h npc_%objectId%_Link custom/npcbuff-Prophet.htm">プロフィット</a>]
#[<a action="bypass -h npc_%objectId%_Link custom/npcbuff-Dance.htm">ダンス</a>]
#[<a action="bypass -h npc_%objectId%_Link custom/npcbuff-Song.htm">ソング</a>]
#[<a action="bypass -h npc_%objectId%_Link custom/npcbuff-Noble.htm">ノーブレス</a>]
# 未使用 #

		# ファイル上書き
		if ($htm ne $original) {
			print $filePath,"\n";

			my $backupPath = $filePath.'.BAK';
			rename FS($filePath), FS($backupPath);

			open FILE,'>:utf8',FS($filePath)  or die;
			print FILE $htm;
			close FILE;
			utime $mtime,$mtime,FS($filePath);
		}
	}
}
