-- ----------------------------------
-- Table structure for npc_buffer_list
-- ----------------------------------
SET NAMES UTF8;
DROP TABLE IF EXISTS `npc_buffer_list`; 
CREATE TABLE `npc_buffer_list` (
  `id` int(11) unsigned NOT NULL,
  `name` varchar(35) NOT NULL default '',
  `skill_id` int(10) unsigned NOT NULL,
  `skill_name` varchar(35) default NULL,
  `skill_level` int(10) unsigned NOT NULL default '1',
  `skill_force` int(1) NOT NULL default '1',
  `skill_order` int(10) unsigned NOT NULL,
  `char_min_level` int(10) unsigned NOT NULL default '0',
  `char_max_level` int(10) unsigned NOT NULL default '0',
  `char_race` int(1) unsigned NOT NULL default '0',
  `char_class` int(1) NOT NULL default '0',
  `char_faction` int(10) unsigned NOT NULL default '0',
  `price_adena` int(10) unsigned NOT NULL default '0',
  `price_points` int(10) unsigned NOT NULL default '0',
  PRIMARY KEY  (`id`,`name`,`skill_order`)
) DEFAULT CHARSET=utf8;
-- --------------------------------
-- Records for table npc_buffer_list
-- --------------------------------

--
-- id - template id, not zero value
-- name - template name, for easer access thru html links
-- Note: 'SupportMagic' is reserved name for Newbie Helper buff template
--
-- skill_id, skill_level - skill for buff
-- skill_force - force skill cast, eve if same skill effect present
-- skill_order - order of skill in template, not zero value
-- skill_name - name of skill
--
-- player condtitions for buff: 
-- 
-- char_min_level 
-- char_max_level - minimum and maximum level of character
--
-- char_race - race mask of character
-- 16 - human
-- 8  - elf
-- 4  - dark elf
-- 2  - orc
-- 1  - dwarf
-- example: if set 16+8+1, this mean 25, 
-- then buff can land only on humans,elfs and dwarves
-- set 0 or 31 for all races
--
-- char_class
-- 2 - magus
-- 1 - fighter
-- 0 or 3 - all classes
--
-- char_faction - faction id, 0 - for all or no faction
--
-- price_adena - amount of adena for buff
-- price_points - amount of faction poins for buff

insert into npc_buffer_list values 

-- Reserved for Helper Buffer.
(1, 'SupportMagic', 4322, '初心者用 ウィンド ウォーク', 1, 1, 1, 8, 39, 0, 0, 0, 0, 0), 
(1, 'SupportMagic', 4323, '初心者用 シールド', 1, 1, 2, 11, 38, 0, 0, 0, 0, 0), 
(1, 'SupportMagic', 4338, '初心者用 ライフ キュービック', 1, 1, 3, 16, 34, 0, 0, 0, 0, 0), 
(1, 'SupportMagic', 4324, '初心者用 ブレス ザ ボディ', 1, 1, 4, 12, 37, 0, 1, 0, 0, 0), 
(1, 'SupportMagic', 4325, '初心者用 ヴァンパイアリック レイジ', 1, 1, 5, 13, 36, 0, 1, 0, 0, 0), 
(1, 'SupportMagic', 4326, '初心者用 リジェネレーション', 1, 1, 6, 14, 35, 0, 1, 0, 0, 0), 
(1, 'SupportMagic', 4327, '初心者用 へイスト', 1, 1, 7, 15, 34, 0, 1, 0, 0, 0), 
(1, 'SupportMagic', 4328, '初心者用 ブレス ザ ソウル', 1, 1, 8, 12, 37, 0, 2, 0, 0, 0), 
(1, 'SupportMagic', 4329, '初心者用 アキュメン', 1, 1, 9, 13, 36, 0, 2, 0, 0, 0), 
(1, 'SupportMagic', 4330, '初心者用 コンセントレーション', 1, 1, 10, 14, 35, 0, 2, 0, 0, 0), 
(1, 'SupportMagic', 4331, '初心者用 エンパワー', 1, 1, 11, 15, 34, 0, 2, 0, 0, 0), 

-- Prophet Buffs
(2, 'Greater Empower', 1059, 'エンパワー', 3, 1, 13, 40, 85, 0, 0, 0, 0, 0), 
(3, 'Acumen', 1085, 'アキュメン', 3, 1, 12, 40, 85, 0, 0, 0, 0, 0), 
(4, 'Focus', 1077, 'フォーカス', 3, 1, 14, 40, 85, 0, 0, 0, 0, 0), 
(5, 'Greater Might', 1388, 'グレーター マイト', 3, 1, 15, 40, 85, 0, 0, 0, 0, 0), 
(6, 'Berserker Spirit', 1062, 'バーサーカー スピリッツ', 2, 1, 17, 40, 85, 0, 0, 0, 0, 0), 
(7, 'Greater Shield', 1389, 'グレーター シールド', 3, 1, 16, 40, 85, 0, 0, 0, 0, 0), 
(8, 'Invigor', 1032, 'インビガー', 3, 1, 18, 40, 85, 0, 0, 0, 0, 0), 
(9, 'Mental Shield', 1035, 'メンタル シールド', 4, 1, 19, 40, 85, 0, 0, 0, 0, 0), 
(10, 'Magic Barrier', 1036, 'マジック バリア', 2, 1, 20, 40, 85, 0, 0, 0, 0, 0), 
(11, 'Regeneration', 1044, 'リジェネレーション', 3, 1, 21, 40, 85, 0, 0, 0, 0, 0), 
(12, 'Blessed Body', 1045, 'ブレス ザ ボディ', 6, 1, 22, 40, 85, 0, 0, 0, 0, 0), 
(13, 'Blessed Soul', 1048, 'ブレス ザ ソウル', 6, 1, 23, 40, 85, 0, 0, 0, 0, 0), 
(14, 'Greater Concentration', 1078, 'コンセントレーション', 6, 1, 24, 40, 85, 0, 0, 0, 0, 0), 
(15, 'Haste', 1086, 'ヘイスト', 2, 1, 25, 40, 85, 0, 0, 0, 0, 0), 
(16, 'Agility', 1087, 'アジリティー', 3, 1, 26, 40, 85, 0, 0, 0, 0, 0), 
(17, 'Wind Walk', 1204, 'ウィンド ウォーク', 2, 1, 27, 40, 85, 0, 0, 0, 0, 0), 
(18, 'Guidance', 1240, 'ガイダンス', 3, 1, 28, 40, 85, 0, 0, 0, 0, 0), 
(19, 'Death Whisper', 1242, 'デス ウィスパー', 3, 1, 29, 40, 85, 0, 0, 0, 0, 0), 
(20, 'Vampiric Rage', 1268, 'ヴァンパイアリック レイジ', 4, 1, 30, 40, 85, 0, 0, 0, 0, 0), 
(21, 'Bless Shield', 1243, 'ブレス シールド', 6, 1, 31, 40, 85, 0, 0, 0, 0, 0), 

-- Dances
(22, 'Dance of Warrior', 271, 'ダンス オブ ウォーリア', 1, 1, 32, 1, 85, 0, 0, 0, 0, 0), 
(23, 'Dance of Inspiration', 272, 'ダンス オブ インスピレーション', 1, 1, 33, 1, 85, 0, 0, 0, 0, 0), 
(24, 'Dance of Mystic', 273, 'ダンス オブ ミスティック', 1, 1, 34, 1, 85, 0, 0, 0, 0, 0), 
(25, 'Dance of Fire', 274, 'ダンス オブ ファイア', 1, 1, 35, 1, 85, 0, 0, 0, 0, 0), 
(26, 'Dance of Concentration', 276, 'ダンス オブ コンセントレーション', 1, 1, 36, 1, 85, 0, 0, 0, 0, 0), 
(27, 'Dance of Fury', 275, 'ダンス オブ フューリー', 1, 1, 37, 1, 85, 0, 0, 0, 0, 0), 
(28, 'Dance of Light', 277, 'ダンス オブ ライト', 1, 1, 38, 1, 85, 0, 0, 0, 0, 0), 
(29, 'Dance of Aqua Guard', 307, 'ダンス オブ アクア ガード', 1, 1, 39, 1, 85, 0, 0, 0, 0, 0), 
(30, 'Dance of Earth Guard', 309, 'ダンス オブ アース ガード', 1, 1, 40, 1, 85, 0, 0, 0, 0, 0), 
(31, 'Dance of Vampire', 310, 'ダンス オブ ヴァンパイア', 1, 1, 41, 1, 85, 0, 0, 0, 0, 0), 
(32, 'Dance of Protection', 311, 'ダンス オブ プロテクション', 1, 1, 42, 1, 85, 0, 0, 0, 0, 0), 
(33, 'Dance of Siren', 365, 'ダンス オブ サイレン', 1, 1, 43, 1, 85, 0, 0, 0, 0, 0), 
(34, 'Dance of Shadow', 366, 'ダンス オブ シャドー', 1, 1, 44, 1, 85, 0, 0, 0, 0, 0),

-- Songs  
(35, 'Song of Earth', 264, 'ソング オブ アース', 1, 1, 45, 1, 85, 0, 0, 0, 0, 0), 
(36, 'Song of Life', 265, 'ソング オブ ライフ', 1, 1, 46, 1, 85, 0, 0, 0, 0, 0), 
(37, 'Song of Water', 266, 'ソング オブ ウォーター', 1, 1, 47, 1, 85, 0, 0, 0, 0, 0), 
(38, 'Song of Warding', 267, 'ソング オブ ウォーディング', 1, 1, 48, 1, 85, 0, 0, 0, 0, 0), 
(39, 'Song of Wind', 268, 'ソング オブ ウィンド', 1, 1, 49, 1, 85, 0, 0, 0, 0, 0), 
(40, 'Song of Hunter', 269, 'ソング オブ ハンター', 1, 1, 50, 1, 85, 0, 0, 0, 0, 0), 
(41, 'Song of Invocation', 270, 'ソング オブ インボケイション', 1, 1, 51, 1, 85, 0, 0, 0, 0, 0), 
(42, 'Song of Vitality', 304, 'ソング オブ バイタリティー', 1, 1, 52, 1, 85, 0, 0, 0, 0, 0), 
(43, 'Song of Vengeance', 305, 'ソング オブ ヴェンジェンス', 1, 1, 53, 1, 85, 0, 0, 0, 0, 0), 
(44, 'Song of Flame Guard', 306, 'ソング オブ フレイム ガード', 1, 1, 54, 1, 85, 0, 0, 0, 0, 0), 
(45, 'Song of Storm Guard', 308, 'ソング オブ ストーム ガード', 1, 1, 55, 1, 85, 0, 0, 0, 0, 0), 
(46, 'Song of Renewal', 349, 'ソング オブ リニューアル', 1, 1, 56, 1, 85, 0, 0, 0, 0, 0), 
(47, 'Song of Meditation', 363, 'ソング オブ メディテーション', 1, 1, 57, 1, 85, 0, 0, 0, 0, 0), 
(48, 'Song of Champion', 364, 'ソング オブ チャンピオン', 1, 1, 58, 1, 85, 0, 0, 0, 0, 0), 

-- Reserved for cast all Dances in a Row.
(49, 'DanceSupport', 271, 'ダンス オブ ウォーリア', 1, 1, 32, 1, 85, 0, 0, 0, 0, 0), 
(49, 'DanceSupport', 272, 'ダンス オブ インスピレーション', 1, 1, 33, 1, 85, 0, 0, 0, 0, 0), 
(49, 'DanceSupport', 273, 'ダンス オブ ミスティック', 1, 1, 34, 1, 85, 0, 0, 0, 0, 0), 
(49, 'DanceSupport', 274, 'ダンス オブ ファイア', 1, 1, 35, 1, 85, 0, 0, 0, 0, 0), 
(49, 'DanceSupport', 276, 'ダンス オブ コンセントレーション', 1, 1, 36, 1, 85, 0, 0, 0, 0, 0), 
(49, 'DanceSupport', 275, 'ダンス オブ フューリー', 1, 1, 37, 1, 85, 0, 0, 0, 0, 0), 
(49, 'DanceSupport', 277, 'ダンス オブ ライト', 1, 1, 38, 1, 85, 0, 0, 0, 0, 0), 
(49, 'DanceSupport', 307, 'ダンス オブ アクア ガード', 1, 1, 39, 1, 85, 0, 0, 0, 0, 0), 
(49, 'DanceSupport', 309, 'ダンス オブ アース ガード', 1, 1, 40, 1, 85, 0, 0, 0, 0, 0), 
(49, 'DanceSupport', 310, 'ダンス オブ ヴァンパイア', 1, 1, 41, 1, 85, 0, 0, 0, 0, 0), 
(49, 'DanceSupport', 311, 'ダンス オブ プロテクション', 1, 1, 42, 1, 85, 0, 0, 0, 0, 0), 
(49, 'DanceSupport', 365, 'ダンス オブ サイレン', 1, 1, 43, 1, 85, 0, 0, 0, 0, 0), 
(49, 'DanceSupport', 366, 'ダンス オブ シャドー', 1, 1, 44, 1, 85, 0, 0, 0, 0, 0),

-- Reserved for cast all Songs in a row. 
(50, 'SongSupport', 264, 'ソング オブ アース', 1, 1, 45, 1, 85, 0, 0, 0, 0, 0), 
(50, 'SongSupport', 265, 'ソング オブ ライフ', 1, 1, 46, 1, 85, 0, 0, 0, 0, 0), 
(50, 'SongSupport', 266, 'ソング オブ ウォーター', 1, 1, 47, 1, 85, 0, 0, 0, 0, 0), 
(50, 'SongSupport', 267, 'ソング オブ ウォーディング', 1, 1, 48, 1, 85, 0, 0, 0, 0, 0), 
(50, 'SongSupport', 268, 'ソング オブ ウィンド', 1, 1, 49, 1, 85, 0, 0, 0, 0, 0), 
(50, 'SongSupport', 269, 'ソング オブ ハンター', 1, 1, 50, 1, 85, 0, 0, 0, 0, 0), 
(50, 'SongSupport', 270, 'ソング オブ インボケイション', 1, 1, 51, 1, 85, 0, 0, 0, 0, 0), 
(50, 'SongSupport', 304, 'ソング オブ バイタリティー', 1, 1, 52, 1, 85, 0, 0, 0, 0, 0), 
(50, 'SongSupport', 305, 'ソング オブ ヴェンジェンス', 1, 1, 53, 1, 85, 0, 0, 0, 0, 0), 
(50, 'SongSupport', 306, 'ソング オブ フレイム ガード', 1, 1, 54, 1, 85, 0, 0, 0, 0, 0), 
(50, 'SongSupport', 308, 'ソング オブ ストーム ガード', 1, 1, 55, 1, 85, 0, 0, 0, 0, 0), 
(50, 'SongSupport', 349, 'ソング オブ リニューアル', 1, 1, 56, 1, 85, 0, 0, 0, 0, 0), 
(50, 'SongSupport', 363, 'ソング オブ メディテーション', 1, 1, 57, 1, 85, 0, 0, 0, 0, 0), 
(50, 'SongSupport', 364, 'ソング オブ チャンピオン', 1, 1, 58, 1, 85, 0, 0, 0, 0, 0), 

-- Reserved to cast all Prophet buffs in a row
(51, 'ProphetSupport', 1085, 'アキュメン', 3, 1, 12, 40, 85, 0, 0, 0, 0, 0), 
(51, 'ProphetSupport', 1059, 'エンパワー', 3, 1, 13, 40, 85, 0, 0, 0, 0, 0), 
(51, 'ProphetSupport', 1077, 'フォーカス', 3, 1, 14, 40, 85, 0, 0, 0, 0, 0), 
(51, 'ProphetSupport', 1388, 'グレーター マイト', 3, 1, 15, 40, 85, 0, 0, 0, 0, 0), 
(51, 'ProphetSupport', 1389, 'グレーター シールド', 3, 1, 16, 40, 85, 0, 0, 0, 0, 0), 
(51, 'ProphetSupport', 1062, 'バーサーカー スピリッツ', 2, 1, 17, 40, 85, 0, 0, 0, 0, 0), 
(51, 'ProphetSupport', 1032, 'インビガー', 3, 1, 18, 40, 85, 0, 0, 0, 0, 0), 
(51, 'ProphetSupport', 1035, 'メンタル シールド', 4, 1, 19, 40, 85, 0, 0, 0, 0, 0), 
(51, 'ProphetSupport', 1036, 'マジック バリア', 2, 1, 20, 40, 85, 0, 0, 0, 0, 0), 
(51, 'ProphetSupport', 1044, 'リジェネレーション', 3, 1, 21, 40, 85, 0, 0, 0, 0, 0), 
(51, 'ProphetSupport', 1045, 'ブレス ザ ボディ', 6, 1, 22, 40, 85, 0, 0, 0, 0, 0), 
(51, 'ProphetSupport', 1048, 'ブレス ザ ソウル', 6, 1, 23, 40, 85, 0, 0, 0, 0, 0), 
(51, 'ProphetSupport', 1078, 'コンセントレーション', 6, 1, 24, 40, 85, 0, 0, 0, 0, 0), 
(51, 'ProphetSupport', 1086, 'ヘイスト', 2, 1, 25, 40, 85, 0, 0, 0, 0, 0), 
(51, 'ProphetSupport', 1087, 'アジリティー', 3, 1, 26, 40, 85, 0, 0, 0, 0, 0), 
(51, 'ProphetSupport', 1204, 'ウィンド ウォーク', 2, 1, 27, 40, 85, 0, 0, 0, 0, 0), 
(51, 'ProphetSupport', 1240, 'ガイダンス', 3, 1, 28, 40, 85, 0, 0, 0, 0, 0), 
(51, 'ProphetSupport', 1242, 'デス ウィスパー', 3, 1, 29, 40, 85, 0, 0, 0, 0, 0), 
(51, 'ProphetSupport', 1268, 'ヴァンパイアリック レイジ', 4, 1, 30, 40, 85, 0, 0, 0, 0, 0), 
(51, 'ProphetSupport', 1243, 'ブレス シールド', 6, 1, 31, 40, 85, 0, 0, 0, 0, 0),

-- Shaman Buffs
(52, 'Flame Chant', 1002, 'チャント オブ フレイム', 1, 1, 32, 20, 85, 0, 0, 0, 0, 0),
(53, 'Pa''agrian Gift', 1003, 'パワー オブ パアグリオ', 3, 1, 33, 20, 85, 0, 0, 0, 0, 0),
(54, 'Blessings of Pa''agrio', 1005, 'ブレッシング オブ パアグリオ', 1, 1, 34, 20, 85, 0, 0, 0, 0, 0),
(55, 'Chant of Fire', 1006, 'チャント オブ ファイア', 3, 1, 35, 20, 85, 0, 0, 0, 0, 0),
(56, 'Chant of Battle', 1007, 'チャント オブ バトル', 2, 1, 36, 20, 85, 0, 0, 0, 0, 0),
(57, 'Chant of Shielding', 1009, 'チャント オブ シールディング', 3, 1, 37, 20, 85, 0, 0, 0, 0, 0),
(58, 'Soul Shield', 1010, 'ソウル シールド', 3, 1, 38, 20, 85, 0, 0, 0, 0, 0),

-- Reserved to cast all shaman buffs in a row
(59, 'OrcShamanSupport', 1002, 'チャント オブ フレイム', 1, 1, 39, 20, 85, 0, 0, 0, 0, 0),
(59, 'OrcShamanSupport', 1003, 'パワー オブ パアグリオ', 3, 1, 40, 20, 85, 0, 0, 0, 0, 0),
(59, 'OrcShamanSupport', 1005, 'ブレッシング オブ パアグリオ', 1, 1, 41, 20, 85, 0, 0, 0, 0, 0),
(59, 'OrcShamanSupport', 1006, 'チャント オブ ファイア', 3, 1, 42, 20, 85, 0, 0, 0, 0, 0),
(59, 'OrcShamanSupport', 1007, 'チャント オブ バトル', 2, 1, 43, 20, 85, 0, 0, 0, 0, 0),
(59, 'OrcShamanSupport', 1009, 'チャント オブ シールディング', 3, 1, 44, 20, 85, 0, 0, 0, 0, 0),
(59, 'OrcShamanSupport', 1010, 'ソウル シールド', 3, 1, 45, 20, 85, 0, 0, 0, 0, 0),

-- Overlord Buffs
(60, 'The Wisdom of Pa''agrio', 1004, 'ウィズダム オブ パアグリオ', 3, 1, 46, 40, 85, 0, 0, 0, 0, 0),
(61, 'The Glory of Pa''agrio', 1008, 'グローリー オブ パアグリオ', 3, 1, 47, 40, 85, 0, 0, 0, 0, 0),
(62, 'The Vision of Pa''agrio', 1249, 'サイト オブ パアグリオ', 3, 1, 48, 40, 85, 0, 0, 0, 0, 0),
(63, 'Under the Protection of Pa''agrio', 1250, 'シールド オブ パアグリオ', 3, 1, 49, 40, 85, 0, 0, 0, 0, 0),
(64, 'The Tact of Pa''agrio', 1260, 'タクト オブ パアグリオ', 3, 1, 50, 40, 85, 0, 0, 0, 0, 0),
(65, 'The Rage of Pa''agrio', 1261, 'レイジ オブ パアグリオ', 2, 1, 51, 40, 85, 0, 0, 0, 0, 0),
(66, 'The Honor of Pa''agrio', 1305, 'オナー オブ パアグリオ', 5, 1, 52, 40, 85, 0, 0, 0, 0, 0),
(67, 'The Eye of Pa''agrio', 1364, 'アイ オブ パアグリオ', 1, 1, 30, 40, 85, 0, 0, 0, 0, 0),
(68, 'The Soul of Pa''agrio', 1365, 'ソウル オブ パアグリオ', 1, 1, 30, 40, 85, 0, 0, 0, 0, 0),
(69, 'The Heart of Pa''agrio', 1256, 'ハート オブ パアグリオ', 1, 1, 600, 40, 85, 0, 0, 0, 0, 0),

-- Reserved to cast all overlord buffs in a row
(70, 'OrcOverlordSupport', 1004, 'ウィズダム オブ パアグリオ', 3, 1, 55, 40, 85, 0, 0, 0, 0, 0),
(70, 'OrcOverlordSupport', 1008, 'グローリー オブ パアグリオ', 3, 1, 56, 40, 85, 0, 0, 0, 0, 0),
(70, 'OrcOverlordSupport', 1249, 'サイト オブ パアグリオ', 3, 1, 57, 40, 85, 0, 0, 0, 0, 0),
(70, 'OrcOverlordSupport', 1250, 'シールド オブ パアグリオ', 3, 1, 58, 40, 85, 0, 0, 0, 0, 0),
(70, 'OrcOverlordSupport', 1260, 'タクト オブ パアグリオ', 3, 1, 59, 40, 85, 0, 0, 0, 0, 0),
(70, 'OrcOverlordSupport', 1261, 'レイジ オブ パアグリオ', 2, 1, 60, 40, 85, 0, 0, 0, 0, 0),
(70, 'OrcOverlordSupport', 1305, 'オナー オブ パアグリオ', 5, 1, 61, 40, 85, 0, 0, 0, 0, 0),
(70, 'OrcOverlordSupport', 1364, 'アイ オブ パアグリオ', 1, 1, 62, 40, 85, 0, 0, 0, 0, 0),
(70, 'OrcOverlordSupport', 1365, 'ソウル オブ パアグリオ', 1, 1, 63, 40, 85, 0, 0, 0, 0, 0),
(70, 'OrcOverlordSupport', 1256, 'ハート オブ パアグリオ', 1, 1, 601, 40, 85, 0, 0, 0, 0, 0),

-- Warcryer Buffs 
(71, 'Chant of Fury', 1251, 'チャント オブ フューリー', 2, 1, 64, 40, 85, 0, 0, 0, 0, 0),
(72, 'Chant of Evasion', 1252, 'チャント オブ イベイジョン',3, 1, 65, 40, 85, 0, 0, 0, 0, 0),
(73, 'Chant of Rage', 1253, 'チャント オブ レイジ', 3, 1, 66, 40, 85, 0, 0, 0, 0, 0),
(74, 'Chant of Revenge', 1284, 'チャント オブ リベンジ', 3, 1, 67, 40, 85, 0, 0, 0, 0, 0),
(75, 'Chant of Predator', 1308, 'チャント オブ プレデター', 3, 1, 68, 40, 85, 0, 0, 0, 0, 0),
(76, 'Chant of Eagle',1309, 'チャント オブ イーグル', 3, 1, 69, 40, 85, 0, 0, 0, 0, 0),
(77, 'Chant of Vampire', 1310, 'チャント オブ ヴァンパイア', 4, 1, 70, 40, 85, 0, 0, 0, 0, 0),
(78, 'Chant of Spirit', 1362, 'チャント オブ スピリッツ', 1, 1, 30, 40, 85, 0, 0, 0, 0, 0),
(79, 'Chant of Victory', 1363, 'チャント オブ ヴィクトリー', 1, 1, 72, 40, 85, 0, 0, 0, 0, 0),
(80, 'War Chant', 1390, 'チャント オブ ウォー', 3, 1, 73, 40, 85, 0, 0, 0, 0, 0),
(81, 'Earth Chant', 1391, 'チャント オブ アース', 3, 1, 74, 40, 85, 0, 0, 0, 0, 0),

-- Reserved to cast all warcryer buffs in a row 
(82, 'OrcWarcryerSupport', 1251, 'チャント オブ フューリー', 2, 1, 76, 40, 85, 0, 0, 0, 0, 0),
(82, 'OrcWarcryerSupport', 1252, 'チャント オブ イベイジョン',3, 1, 77, 40, 85, 0, 0, 0, 0, 0),
(82, 'OrcWarcryerSupport', 1253, 'チャント オブ レイジ', 3, 1, 78, 40, 85, 0, 0, 0, 0, 0),
(82, 'OrcWarcryerSupport', 1284, 'チャント オブ リベンジ', 3, 1, 79, 40, 85, 0, 0, 0, 0, 0),
(82, 'OrcWarcryerSupport', 1308, 'チャント オブ プレデター', 3, 1, 80, 40, 85, 0, 0, 0, 0, 0),
(82, 'OrcWarcryerSupport', 1309, 'チャント オブ イーグル', 3, 1, 81, 40, 85, 0, 0, 0, 0, 0),
(82, 'OrcWarcryerSupport', 1310, 'チャント オブ ヴァンパイア', 4, 1, 82, 40, 85, 0, 0, 0, 0, 0),
(82, 'OrcWarcryerSupport', 1362, 'チャント オブ スピリッツ', 1, 1, 83, 40, 85, 0, 0, 0, 0, 0),
(82, 'OrcWarcryerSupport', 1363, 'チャント オブ ヴィクトリー', 1, 1, 84, 40, 85, 0, 0, 0, 0, 0),
(82, 'OrcWarcryerSupport', 1390, 'チャント オブ ウォー', 3, 40, 85, 40, 85, 0, 0, 0, 0, 0),
(82, 'OrcWarcryerSupport', 1391, 'チャント オブ アース', 3, 1, 86, 40, 85, 0, 0, 0, 0, 0),

-- Cubics
(83, 'Summon Storm Cubic', 10, 'サモン ストーム キュービック', 8, 1, 87, 1, 85, 0, 0, 0, 0, 0),
(84, 'Summon Phantom Cubic', 33, 'サモン ポルターガイスト キュービック', 8, 1, 88, 1, 85, 0, 0, 0, 0, 0),
(85, 'Summon Vampiric Cubic', 22, 'サモン ヴァンパイアリック キュービック', 7, 1, 89, 1, 85, 0, 0, 0, 0, 0),
(86, 'Summon Life Cubic', 67, 'サモン ライフ キュービック', 7, 1, 90, 1, 85, 0, 0, 0, 0, 0),
(87, 'Summon Viper Cubic', 278, 'サモン ヴァイパー キュービック', 6, 1, 91, 1, 85, 0, 0, 0, 0, 0),
(88, 'Summon Binding Cubic', 1279, 'サモン バインディング キュービック', 9, 1, 92, 1, 85, 0, 0, 0, 0, 0),
(89, 'Summon Aqua Cubic', 1280, 'サモン アクア キュービック', 9, 1, 93, 1, 85, 0, 0, 0, 0, 0),
(90, 'Summon Spark Cubic', 1281, 'サモン スパーク キュービック', 9, 1, 94, 1, 85, 0, 0, 0, 0, 0),

-- Hero Buffs
(91, 'Heroic Miracle', 395, 'ヒロイック ミラクル', 1, 1, 30, 1, 85, 0, 0, 0, 1000000, 0),
(92, 'Heroic Berserker', 396, 'ヒロイック バーサーカー', 1, 1, 96, 1, 85, 0, 0, 0, 1000000, 0),
(93, 'Heroic Valor', 1374, 'ヒロイック ヴァロー', 1, 1, 30, 1, 85, 0, 0, 0, 1000000, 0),

-- Noble Buffs
(94, 'Blessing of Noblesse', 1323, 'ブレッシング オブ ノーブレス', 1, 1, 101, 1, 85, 0, 0, 0, 1000000, 0),
(95, 'Fortune of Noblesse', 1325, 'フォーチュン オブ ノーブレス', 1, 1, 102, 1, 85, 0, 0, 0, 1000000, 0),

-- Reserved to cast all noble buffs in a row
(96, 'NobleSupport', 1323, 'ブレッシング オブ ノーブレス', 1, 1, 103, 1, 85, 0, 0, 0, 900000, 0),   
(96, 'NobleSupport', 1325, 'フォーチュン オブ ノーブレス', 1, 1, 104, 1, 85, 0, 0, 0, 900000, 0),

-- Summons Buffs
(97, 'Blessing of Queen', 4699, 'ブレッシング オブ クイーン', 13, 1, 111, 1, 85, 0, 0, 0, 0, 0),
(98, 'Gift of Queen', 4700, 'ギフト オブ クイーン', 13, 1, 112, 1, 85, 0, 0, 0, 0, 0),
(99, 'Cure of Queen', 4701, 'キュア オブ クイーン', 13, 1, 113, 1, 85, 0, 0, 0, 0, 0),
(100, 'Blessing of Seraphim', 4702, 'ブレッシング オブ セラフィム', 13, 1, 114, 1, 85, 0, 0, 0, 0, 0),
(101, 'Gift of Seraphim', 4703, 'ギフト オブ セラフィム', 13, 1, 115, 1, 85, 0, 0, 0, 0, 0),
(102, 'Cure of Seraphim', 4704, 'キュア オブ セラフィム', 13, 1, 116, 1, 85, 0, 0, 0, 0, 0),

-- Other Buffs
(103, 'Prophecy of Water', 1355, 'プロフェシー オブ ウォーター', 1, 1, 117, 1, 85, 0, 0, 0, 0, 0),
(104, 'Prophecy of Fire', 1356, 'プロフェシー オブ ファイア', 1, 1, 118, 1, 85, 0, 0, 0, 0, 0),
(105, 'Prophecy of Wind', 1357, 'プロフェシー オブ ウィンド', 1, 1, 119, 1, 85, 0, 0, 0, 0, 0),
(106, 'Wild Magic', 1303, 'ワイルド マジック', 2, 1, 120, 1, 85, 0, 0, 0, 0, 0),
(107, 'Might', 1068, 'マイト', 3, 1, 121, 1, 85, 0, 0, 0, 0, 0),
(108, 'Shield', 1040, 'シールド', 3, 1, 122, 1, 85, 0, 0, 0, 0, 0),
(109, 'Unholy Resistance', 1393, 'レジスト アンホーリー', 3, 1, 123, 1, 85, 0, 0, 0, 0, 0),
(110, 'Holy Resistance', 1392, 'レジスト ホーリー', 1, 3, 124, 1, 85, 0, 0, 0, 0, 0),
(111, 'Elemental Protection', 1352, 'エレメンタル プロテクション', 1, 1, 125, 1, 85, 0, 0, 0, 0, 0),
(112, 'Divine Protection', 1353, 'ディヴァイン プロテクション', 1, 1, 126, 1, 85, 0, 0, 0, 0, 0),
(113, 'Resist Shock', 1259, 'レジスト ショック', 4, 1, 127, 1, 85, 0, 0, 0, 0, 0),
(114, 'Arcane Protection', 1354, 'アルケイン プロテクション', 1, 1, 128, 1, 85, 0, 0, 0, 0, 0),
(115, 'Body of Avatar', 1311, 'ボディ オブ アバター', 6, 1, 129, 1, 85, 0, 0, 0, 0, 0),
(116, 'Magnus Chant', 1413, 'チャント オブ マグナス', 1, 1, 130, 1, 85, 0, 0, 0, 0, 0),

-- Full buffs support saperated in class (Mage/Fighter)
-- Reserved to cast all Prophet buffs from mages in a row
(117, 'ProphetMageSupport', 1085, 'アキュメン', 3, 1, 12, 40, 85, 0, 2, 0, 0, 0),
(117, 'ProphetMageSupport', 1059, 'エンパワー', 3, 1, 13, 40, 85, 0, 2, 0, 0, 0),
(117, 'ProphetMageSupport', 1389, 'グレーター シールド', 3, 1, 16, 40, 85, 0, 2, 0, 0, 0), 
(117, 'ProphetMageSupport', 1062, 'バーサーカー スピリッツ', 2, 1, 17, 40, 85, 0, 2, 0, 0, 0),
(117, 'ProphetMageSupport', 1035, 'メンタル シールド', 4, 1, 19, 40, 85, 0, 2, 0, 0, 0), 
(117, 'ProphetMageSupport', 1036, 'マジック バリア', 2, 1, 20, 40, 85, 0, 2, 0, 0, 0),
(117, 'ProphetMageSupport', 1045, 'ブレス ザ ボディ', 6, 1, 22, 40, 85, 0, 2, 0, 0, 0), 
(117, 'ProphetMageSupport', 1048, 'ブレス ザ ソウル', 6, 1, 23, 40, 85, 0, 2, 0, 0, 0), 
(117, 'ProphetMageSupport', 1078, 'コンセントレーション', 6, 1, 24, 40, 85, 0, 2, 0, 0, 0),
(117, 'ProphetMageSupport', 1204, 'ウィンド ウォーク', 2, 1, 27, 40, 85, 0, 2, 0, 0, 0),

-- Reserved to cast all Prophet buffs for mages in a row
(118, 'ProphetFighterSupport', 1077, 'フォーカス', 3, 1, 14, 40, 85, 0, 1, 0, 0, 0), 
(118, 'ProphetFighterSupport', 1388, 'グレーター マイト', 3, 1, 15, 40, 85, 0, 1, 0, 0, 0),
(118, 'ProphetFighterSupport', 1062, 'バーサーカー スピリッツ', 2, 1, 17, 40, 85, 0, 1, 0, 0, 0),
(118, 'ProphetFighterSupport', 1035, 'メンタル シールド', 4, 1, 19, 40, 85, 0, 1, 0, 0, 0), 
(118, 'ProphetFighterSupport', 1036, 'マジック バリア', 2, 1, 20, 40, 85, 0, 1, 0, 0, 0), 
(118, 'ProphetFighterSupport', 1044, 'リジェネレーション', 3, 1, 21, 40, 85, 0, 1, 0, 0, 0), 
(118, 'ProphetFighterSupport', 1045, 'ブレス ザ ボディ', 6, 1, 22, 40, 85, 0, 1, 0, 0, 0), 
(118, 'ProphetFighterSupport', 1086, 'ヘイスト', 2, 1, 25, 40, 85, 0, 1, 0, 0, 0), 
(118, 'ProphetFighterSupport', 1087, 'アジリティー', 3, 1, 26, 40, 85, 0, 1, 0, 0, 0), 
(118, 'ProphetFighterSupport', 1204, 'ウィンド ウォーク', 2, 1, 27, 40, 85, 0, 1, 0, 0, 0), 
(118, 'ProphetFighterSupport', 1240, 'ガイダンス', 3, 1, 28, 40, 85, 0, 1, 0, 0, 0), 
(118, 'ProphetFighterSupport', 1242, 'デス ウィスパー', 3, 1, 29, 40, 85, 0, 1, 0, 0, 0), 
(118, 'ProphetFighterSupport', 1268, 'ヴァンパイアリック レイジ', 4, 1, 30, 40, 85, 0, 1, 0, 0, 0), 

-- Reserved to casr all Dances buffs for mages in a row
(119, 'DanceMageSupport', 273, 'ダンス オブ ミスティック', 1, 1, 34, 1, 85, 0, 2, 0, 0, 0),
(119, 'DanceMageSupport', 276, 'ダンス オブ コンセントレーション', 1, 1, 36, 1, 85, 0, 2, 0, 0, 0),
(119, 'DanceMageSupport', 365, 'ダンス オブ サイレン', 1, 1, 43, 1, 85, 0, 2, 0, 0, 0),

-- Reserved to casr all Dances buffs for fighters in a row
(120, 'DanceFighterSupport', 271, 'ダンス オブ ウォーリア', 1, 1, 32, 1, 85, 0, 1, 0, 0, 0),
(120, 'DanceFighterSupport', 274, 'ダンス オブ ファイア', 1, 1, 35, 1, 85, 0, 1, 0, 0, 0),
(120, 'DanceFighterSupport', 275, 'ダンス オブ フューリー', 1, 1, 37, 1, 85, 0, 1, 0, 0, 0),

-- Reserved to casr all Songs buffs for mages 2n a row
(121, 'SongMageSupport', 264, 'ソング オブ アース', 1, 1, 45, 1, 85, 0, 2, 0, 0, 0),
(121, 'SongMageSupport', 267, 'ソング オブ ウォーディング', 1, 1, 48, 1, 85, 0, 2, 0, 0, 0), 
(121, 'SongMageSupport', 268, 'ソング オブ ウィンド', 1, 1, 49, 1, 85, 0, 2, 0, 0, 0), 
(121, 'SongMageSupport', 304, 'ソング オブ バイタリティー', 1, 1, 52, 1, 85, 0, 2, 0, 0, 0),
(121, 'SongMageSupport', 349, 'ソング オブ リニューアル', 1, 1, 56, 1, 85, 0, 2, 0, 0, 0),

-- Reserved to casr all Songs buffs for fighters in a row
(122, 'SongFighterSupport', 264, 'ソング オブ アース', 1, 1, 45, 1, 85, 0, 1, 0, 0, 0),
(122, 'SongFighterSupport', 267, 'ソング オブ ウォーディング', 1, 1, 48, 1, 85, 0, 1, 0, 0, 0), 
(122, 'SongFighterSupport', 268, 'ソング オブ ウィンド', 1, 1, 49, 1, 85, 0, 1, 0, 0, 0), 
(122, 'SongFighterSupport', 269, 'ソング オブ ハンター', 1, 1, 50, 1, 85, 0, 1, 0, 0, 0),
(122, 'SongFighterSupport', 304, 'ソング オブ バイタリティー', 1, 1, 52, 1, 85, 0, 1, 0, 0, 0),
(122, 'SongFighterSupport', 349, 'ソング オブ リニューアル', 1, 1, 56, 1, 85, 0, 1, 0, 0, 0);

-- L2Emu Project