﻿## Active Perl 5.8.8

# datapack_development language tool for Japanese.
# part 3 - *.htm、*.py 中の基本単語を強引に日本語化する.

# "*.ja" や "!build_ja.cgi" に漏れたものの処理。
# 全ファイルを舐め回す、かなり重たい処理なので、できるだけ減らそう。

use utf8;
use warnings;
use strict;
use Encode;

binmode STDOUT,':encoding(cp932)'; $|=1;
sub   FS {Encode::encode('cp932',shift)}
sub UTF8 {Encode::decode('cp932',shift)}

my $DEBUG = 0; # 1 or 0
my @CC;

my $LogFile = UTF8(__FILE__);
   $LogFile =~ s!\.[^.\/\\]*$!.log!;
open LOG, '>:utf8', FS($LogFile) or die "'$LogFile' $!";

my $ERROR_HEADER;

$SIG{__WARN__} = sub {
	print STDERR $ERROR_HEADER,' ' if $ERROR_HEADER;
	foreach my $m (@_) {
		my $a = $m;
		$a =~ s!build[/\\]dist[/\\]gameserver[/\\](data[/\\])!$1!;
		$a =~ s!build[/\\]dist[/\\]!!;
		if ($a =~ m/^Malformed UTF-8 character \(/) {
			print STDERR $a;
			exit 1;
		}
		print STDERR $a;
		print LOG    $a;
	}
};

$SIG{__DIE__} = sub {
	print STDERR $ERROR_HEADER,' ' if $ERROR_HEADER;
	foreach my $m (@_) {
		my $a = $m;
		$a =~ s!build[/\\]dist[/\\]gameserver[/\\](data[/\\])!$1!;
		$a =~ s!build[/\\]dist[/\\]!!;
		print STDERR $a;
	}
	exit 1;
};

&start('build/dist/');

print LOG "\n";
for (my $i=0; $i <= $#CC; ++$i) {
	if ($CC[$i]) {print LOG __FILE__,"($i)\t",$CC[$i],"\n"}
}

close LOG;
exit 0;

sub start {
	my ($subDir) = @_;

	print ' [',$subDir,"]\n";
	opendir DIR, FS($subDir) or die "'$subDir' $!";
	my @files = readdir DIR; $_ = UTF8($_) foreach (@files);
	closedir DIR;

	foreach my $fileName (@files) {
		next if $fileName =~ m/^\./;
		next if $fileName =~ m/ /;
		my $filePath = $subDir.$fileName;
		my $outPath = $filePath;
		   $outPath .= '.text' if $DEBUG;

		if (-d FS($filePath)) {
			$filePath =~ s!^\.\/!!;
			&start($filePath.'/');
			next;
		}

		my ($ext, $encode);
		if    ($fileName =~ /\.htm$/) {$ext = 'htm'; $encode = ':utf8'}
		elsif ($fileName =~ /\.py$/ ) {$ext = 'py' ; $encode = ':encoding(cp932)'}
		else {next}

		print "  $filePath\n" if $DEBUG;
		open FILE, '<'.$encode, FS($filePath) or die "'$filePath' $!";
		read FILE,my $text,-s FILE;
		my $mtime = (stat FILE)[9];
		close FILE;

		my $original = $text;
		$_           = $text;
		$ERROR_HEADER = "'$filePath'";
#
s/\bl2ui_ch3\.smallbutton2_down\b/L2UI_ct1.button_df_down/gi;
s/\bl2ui_ch3\.smallbutton2\b/L2UI_ct1.button_df/gi;
#
## .py 用 ##
if ($ext eq 'py') {
s{\Q<body>You are either not on a quest that involves this NPC, or you don't meet this NPC's minimum quest requirements.</body>\E}
 {<body>クエストを遂行していないか条件が合いません。</body>}g;	#2008.08.25
s{\Q<body>I have nothing to say you</body>\E}
 {<body>クエストを遂行していないか条件が合いません。</body>}g;

	s{\bYou are either not carrying out your quest or don't meet the criteria\b}
	 {クエストを遂行していないか条件が合いません。}gi	&&die;	#2007.10.01
	s{\bI have nothing to say you\b}
	 {クエストを遂行していないか条件が合いません。}gi	&&die;

s/\bThis quest have already been completed\b/すでに遂行したクエストです。/gsi;
s/\bThis quest has already been completed\b/すでに遂行したクエストです。/gsi;
s/\bThis quest have already been State\.COMPLETED\./すでに遂行したクエストです。/gsi;	#カマ
s/\bThis quest has already been State\.COMPLETED\./すでに遂行したクエストです。/gsi;	#カマ
s/\bQuest for characters level ([0-9]*) and above\b/レベル$1以上のキャラクターのみ遂行できるクエストです。/gsi;
s/\bQuest for characters level ([0-9]*) or above\b/レベル$1以上のキャラクターのみ遂行できるクエストです。/gsi;
s/\bQuest for characters level ([0-9]*) above\b/レベル$1以上のキャラクターのみ遂行できるクエストです。/gsi;

# 余分な句読点を除去
s/。\.+/。/g;	#2009.09.30
# 全角文字の後の"."を"。"に #
s/([\x{3000}-\x{EFFF}])\./$1。/g;	#2007.10.01
}

## .htm 用 ##
if ($ext eq 'htm') {

# <a ation="***">～</a>系 #

s!<A ACTION!<a action!gi;
s!</A>!</a>!gi;
s!(<a .+?>)[\r\n]*(.+?)[\r\n]*(?=</a>)!$1$2!gs;	#テスト中

s!(?<=[\x{0100}-\x{FFFF}])[\r\n]+(?=[\x{0100}-\x{FFFF}])!!gs;	#仮
s!(?<=[\x{0100}-\x{FFFF}])[\r\n]+(?=[^<])!!gs;					#仮

s!(?<=<a action="bypass -h npc_%objectId%_exc_multisell 003">)[^\x{0100}-\x{FFFF}]+?(?=</a>)!装備を交換する!s;
s!(?<=<a action="bypass -h npc_%objectId%_exc_multisell 1000">)[^\x{0100}-\x{FFFF}]+?(?=</a>)!ペット装備アップグレード!s;
s!(?<=<a action="bypass -h npc_%objectId%_exc_multisell 1002">)[^\x{0100}-\x{FFFF}]+?(?=</a>)!Bグレード グローブ、ブーツの封印を解除する!s;
s!(?<=<a action="bypass -h npc_%objectId%_exc_multisell 1003">)[^\x{0100}-\x{FFFF}]+?(?=</a>)!封印を解除したBグレード グローブ、ブーツをもう一度封印する!s;
s!(?<=<a action="bypass -h npc_%objectId%_FishSkillList">)[^\x{0100}-\x{FFFF}]+?(?=</a>)!釣りのスキルを習う!s;
s!(?<=<a action="bypass -h npc_%objectId%_multisell 002">)[^\x{0100}-\x{FFFF}]+?(?=</a>)!ディメンション ダイアモンドを交換する!s;
s!(?<=<a action="bypass -h npc_%objectId%_multisell 009">)[^\x{0100}-\x{FFFF}]+?(?=</a>)!材料を漁獲の証と交換する!s;
s!(?<=<a action="bypass -h npc_%objectId%_Quest 1104_NewbieTravelToken">)[^\x{0100}-\x{FFFF}]+?(?=</a>)!トラベラーズトークンでテレポートする!s;
s!(?<=<a action="bypass -h npc_%objectId%_Quest 2000_NoblesseTeleport">)[^\x{0100}-\x{FFFF}]+?(?=</a>)!\[ノーブレス専用\] テレポートする!s;
s!(?<=<a action="bypass -h npc_%objectId%_Quest 4000_ShadowWeapons">)[^\x{0100}-\x{FFFF}]+?(?=</a>)!幻影兵器交換券を使う!s;
s!(?<=<a action="bypass -h npc_%objectId%_Quest 8000_RaidbossInfo">)[^\x{0100}-\x{FFFF}]+?(?=</a>)!レイド モンスター情報!s;
s!(?<=<a action="bypass -h npc_%objectId%_Quest 8001_NpcLocationInfo">)[^\x{0100}-\x{FFFF}]+?(?=</a>)!NPCの位置案内!s;
s!(?<=<a action="bypass -h npc_%objectId%_Quest 9000_clan">)[^\x{0100}-\x{FFFF}]+?(?=</a>)!血盟!s;
s!(?<=<a action="bypass -h npc_%objectId%_Quest 9001_alliance">)[^\x{0100}-\x{FFFF}]+?(?=</a>)!同盟!s;
s!(?<=<a action="bypass -h npc_%objectId%_questlist">)[^\x{0100}-\x{FFFF}]+?(?=</a>)!クエスト情報!s;
s!(?<=<a action="bypass -h npc_%objectId%_Sell">)[^\x{0100}-\x{FFFF}]+?(?=</a>)!品物を売る!s;
s!(?<=<a action="bypass -h npc_%objectId%_SkillList">)[^\x{0100}-\x{FFFF}]+?(?=</a>)!スキルを習う!s;
s!(?<=<a action="bypass -h npc_%objectId%_TerritoryStatus">)[^\x{0100}-\x{FFFF}]+?(?=</a>)!領主及び税率情報を見る!s;
s!(?<=<a action="bypass -h npc_%objectId%_Buy 4[012][0-9]">)[^\x{0100}-\x{FFFF}]+?(?=</a>)!釣り用品を買う!s;
s!(?<=<a action="bypass -h npc_%objectId%_Link common/augmentation_01.htm">)[^\x{0100}-\x{FFFF}]+?(?=</a>)!装備を精錬する!s;	#[13]
s!(?<=<a action="bypass -h npc_%objectId%_Link common/augmentation_02.htm">)[^\x{0100}-\x{FFFF}]+?(?=</a>)!精錬を解除する!s;	#[13]
s!(?<=<a action="bypass -h npc_%objectId%_Link common/crafting_01.htm">)[^\x{0100}-\x{FFFF}]+?(?=</a>)!アイテム製作!s;	#[21]
s!(?<=<a action="bypass -h npc_%objectId%_Link common/duals_01.htm">)[^\x{0100}-\x{FFFF}]+?(?=</a>)!二刀流の製作!s;	#[18]
s!(?<=<a action="bypass -h npc_%objectId%_Link common/shadow_01.htm">)[^\x{0100}-\x{FFFF}]+?(?=</a>)!幻影兵器を買う!s;	#[12]〓〓
s!(?<=<a action="bypass -h npc_%objectId%_Link common/skill_enchant.htm">)[^\x{0100}-\x{FFFF}]+?(?=</a>)!スキルを強化する!s;	#[26]
s!(?<=<a action="bypass -h npc_%objectId%_Link common/skill_enchant_help.htm">)[^\x{0100}-\x{FFFF}]+?(?=</a>)!スキルの強化について聞く!s;	#[5]
s!(?<=<a action="bypass -h npc_%objectId%_Link common/weapon_sa_01.htm">)[^\x{0100}-\x{FFFF}]+?(?=</a>)!武器に特殊能力付与!s;	#[11]
s!(?<=<a action="bypass -h npc_%objectId%_Link fisherman/fishing_championship.htm">)[^\x{0100}-\x{FFFF}]+?(?=</a>)!釣り王選抜大会!s;	#[69]

s!(?<=<a action="bypass -h player_help 7561.htm">)[^\x{0100}-\x{FFFF}]+?(?=</a>)!釣りの説明を聞く!s;
s!(?<=<a action="bypass -h player_help 7561.htm#7561">)[^\x{0100}-\x{FFFF}]+?(?=</a>)!目次に戻る!s;

s!(?<=<a action="bypass -h npc_%objectId%_Chat 0">)[^a-z<]*go back[^a-z<]*(?=<)!戻る!si;
s!(?<=<a action="bypass -h npc_%objectId%_Chat 0">)[^a-z<]*back[^a-z<]*(?=<)!戻る!si;
s!(?<=<a action="bypass -h npc_%objectId%_Chat 0">)[^a-z<]*return[^a-z<]*(?=<)!戻る!si;
## s!(?<=<a action="bypass -h npc_%objectId%_Chat 0">)[^a-z]*(?:go back|back|return)[^a-z<]*!戻る!si;	#2009.09.30 Active Perl 5.10.1 で不具合

# ボタン #

s!<button value="Main"!<button value="メイン"!g;
s!<button value="Back"!<button value="戻る"!g;
s!<button value="Next"!<button value="次へ"!g;
s!<button value="Return"!<button value="戻る"!g;
s!<button value="Go Back"!<button value="戻る"!g;
s!<button value="Cancel"!<button value="ｷｬﾝｾﾙ"!;
s!<button value="Yes"!<button value="はい"!;
s!<button value="No"!<button value="いいえ"!;
s!<button value="Close"!<button value="閉じる"!;
s!<button value="Submit"!<button value="送信"!;	#〓〓 "OK" の方がよさそう...
s!<button value="Enter"!<button value="確定"!;	#〓〓 "OK" の方がよさそう...

s!(<button value="ｷｬﾝｾﾙ" .*?) width=\d+!$1 width=50!;	#〓〓仮

# 頻出文・基本単語 #

s/\(Quest for characters level ([0-9]*) and above\.?\)/(レベル$1以上のキャラクターのみ遂行できるクエストです。)/i;	#[47]
s/\(Quest for characters level ([0-9]*) or above\.?\)/(レベル$1以上のキャラクターのみ遂行できるクエストです。)/i;	#[3]

s/\bGet information on changing occupations?\.?/転職に関する情報を聞く/i;	#[ ]
s/\bAsk about changing occupations?\.?/転職について尋ねる/i;	#[ ]
s/\bHear about changing occupations?\.?/転職について/i;	#[ ]
s/\bGet information on 2nd occupational change\.?/２次転職に関する情報を聞く/i;	#[ ]
s/\bListen to information about 2nd occupational change\.?/２次転職についての情報を聞く/i;	#[ ]
s/\bHear information on 2nd occupational change\.?/２次転職について/i;	#[ ]

s/(?<=[>"])Say you will take the task\.?(?=["<])/手伝うと言う/si;	#[9]
s/(?<=[>"])I will help you\.?(?=["<])/手伝うと言う/si;	#[11]
s/(?<=[>"])I will help\.?(?=["<])/手伝うと言う/si;	#[4]

s!(?<=>)Back\.?(?=</a>)!戻る!gi;	#[56]
s!(?<=>)Quit\.?(?=</a>)!閉じる!gi;	#[24]
s!(?<=>)Quest\.?(?=</a>)!クエスト!gi;	#[853]
s!(?<=>)Return\.?(?=</a>)!戻る!gi;	#[494]

s!(?<=>)Buy\.?(?=</a>)!買う!gi;	#[6]
s!(?<=>)Teleport\.?(?=</a>)!テレポートする!gi;	#[41]

# 全角文字の前の"The"を消す。 #
s/\bThe ([\x{3000}-\x{EFFF}])/$1/gsi;

} # htm用
#
		$ERROR_HEADER = undef;
		$text = $_;
		next if $text eq $original;

		open FILE, '>'.$encode, FS($outPath) or die "'$outPath' $!";
		print FILE $text;
		close FILE;
		utime $mtime, $mtime, FS($outPath);

		my $i = &minidiff($text, $original);
		print '●',$outPath,"($i)\n";
		print LOG  $outPath,"($i)\n";
	}
}

sub minidiff {
	my ($textA, $textB) = @_;

	$textA =~ s/^\x{FEFF}//;
	$textB =~ s/^\x{FEFF}//;
	my @A = split /\n/,$textA;
	my @B = split /\n/,$textB;
	my $min = $#A <= $#B ? $#A : $#B;
	for (my $i=0; $i <=$min; ++$i) {
		return $i+1 if $A[$i] ne $B[$i];
	}
	return 0;
}
