## Active Perl 5.8.8
# 注意>DBD-mysql を 4.005 以上にアップデートしてください。
# 注意>やりかた: ppm install http://theoryx5.uwinnipeg.ca/ppms/DBD-mysql.ppd
#-注意>やりかた: ppm install Jcode

## skills/*.xml 中のスキル名を一括して日本語化する

use utf8;
use strict;
use warnings;
use Encode;
use DBI;

binmode STDOUT,':encoding(cp932)'; $|=1;
sub   FS {Encode::encode('cp932',shift)}
sub UTF8 {Encode::decode('cp932',shift)}

my $vars_txt = 'tools/vars.txt';
open FILE,'<',$vars_txt  or do {warn "'$vars_txt' $!";exit 0};
read FILE,my $vars,-s FILE;
close FILE;
my $gsuser = ($vars =~ m/^\@*set gsuser=(.+)$/m)[0];
my $gspass = ($vars =~ m/^@*set gspass=(.+)$/m)[0];
my $gsdb   = ($vars =~ m/^@*set gsdb=(.+)$/m)[0];
my $gshost = ($vars =~ m/^@*set gshost=(.+)$/m)[0];

my $DEBUG = 0; # 1 or 0

my $LogFile = UTF8(__FILE__);
   $LogFile =~ s!\.[^.\/\\]*$!.log!;
open LOG, '>:utf8', FS($LogFile)  or die "'$LogFile' $!";

my $db = DBI->connect("DBI:mysql:$gsdb:$gshost", $gsuser, $gspass, {mysql_enable_utf8=>1}) or do{warn DBI::errstr;exit 0};
   $db->do('SET NAMES UTF8');

my %array_name_jp = ();
&loadSkillNameAll();

&start('build/dist/gameserver/data/stats/skills/');

close LOG;
exit 0;

sub start {
	my ($subDir) = @_;

	opendir DIR, FS($subDir) or die "'$subDir' $!";
	my @files = readdir DIR;
	closedir DIR;

	foreach my $fileName (@files) {
		next if $fileName =~ m/^\./;
		next if $fileName =~ m/ /;

		my $filePath = $subDir.$fileName;

		if (-d FS($filePath)) {
#			&start($filePath.'/');
			next;
		}

		next unless $fileName =~ m/\.xml$/;

		my $outPath = $filePath;
		   $outPath .= '.text' if $DEBUG;

		print "  $filePath\n" if $DEBUG;
		open FILE, '<:utf8', FS($filePath) or die "'$filePath' $!";
		my $mtime = (stat FILE)[9];
		read FILE,my $text,-s FILE;
		close FILE;

		my $original = $text;

		my $UPDATE = 0;

		# <skill id="1" levels="37" name="Triple Slash"
		#                 $1           $2   $3              $4     $5
		while ($text =~ m!(<skill id=")(\d+)("[^>]* name=")([^"]+)("[^>]*>)!gs) {

			my $S1      = $1;
			my $id      = $2;
			my $S3      = $3;
			my $name_en = $4;
			my $S5      = $5;
			die unless $id;
			die unless $name_en;

			my $name_jp = $array_name_jp{$id};
		#	my $name_jp = &getName($id,undef);
			next unless $name_jp;
			$name_jp =~ s/&/&amp;/g;
			$name_jp =~ s/。$//;
			next if $name_jp eq $name_en;

			$text =~ s!\Q$S1$id$S3$name_en$S5\E!$S1$id$S3$name_jp$S5!;

			my $i = &minidiff($text, $original) unless $UPDATE;
			print '●',$outPath,"(",$i,")\n" unless $UPDATE;
			print     "\t$id\t[",$name_en,"]\n";
			print        "\t\t[",$name_jp,"]\n";
			print LOG  $outPath,"(",$i,")\n" unless $UPDATE;
			print LOG "\t$id\t[",$name_en,"]\n";
			print LOG    "\t\t[",$name_jp,"]\n";

			$UPDATE = 1;
		}

		if ($UPDATE) {
			open FILE, '>:utf8', FS($outPath) or die "'$outPath' $!";
			print FILE $text;
			close FILE;
			utime $mtime, $mtime, FS($outPath);
		}
	}
}

sub loadSkillNameAll {
	my $sth;

	$sth = $db->prepare('SELECT id,level,name FROM skillname_ja');
	$sth->execute or die DBI::errstr;
	$sth->bind_columns(undef, \(my($N_id,$N_level,$N_name))) or die DBI::errstr;
	while (my $rc = $sth->fetch) {
		next unless $N_name;
#		$N_name = Encode::decode_utf8(Jcode->new($N_name, 'utf8')->z2h->utf8);
		if (not defined $array_name_jp{$N_id})
			{$array_name_jp{$N_id} = $N_name}
		elsif ($array_name_jp{$N_id} ne $N_name)
			{$array_name_jp{$N_id} = undef}		#レベルごとに名称の違うものは除外
#		else
#			{}
	}
}

sub minidiff {
	my ($textA, $textB) = @_;

	$textA =~ s/^\x{FEFF}//;
	$textB =~ s/^\x{FEFF}//;
	my @A = split /\n/,$textA;
	my @B = split /\n/,$textB;
	my $min = $#A <= $#B ? $#A : $#B;
	for (my $i=0; $i <=$min; ++$i) {
		return $i+1 if $A[$i] ne $B[$i];
	}
	return 0;
}
