﻿## Active Perl 5.8.8

use utf8;
use warnings;
use strict;
use Encode;

binmode STDOUT, ':encoding(cp932)'; $|=1;
sub   FS {Encode::encode('cp932',shift)}
sub UTF8 {Encode::decode('cp932',shift)}

my $DEBUG = 0;
my @CC;	#@IF DEBUG@#

&start('./');

if (@CC) {
	my $LogFile = UTF8(__FILE__);	#@IF DEBUG@#
	   $LogFile =~ s!\.[^.\/\\]*$!.log!;	#@IF DEBUG@#
	open LOG, '>:utf8', FS($LogFile) or die "'$LogFile' $!";	#@IF DEBUG@#
	my $i = 0; ++$i until $CC[$i];
	for (; $i <= $#CC; ++$i) {	#@IF DEBUG@#
		if ($CC[$i]) {print LOG __FILE__,"($i)\t",$CC[$i],"\n"}	#@IF DEBUG@#
		else         {print LOG __FILE__,"($i)\t",0,"\n"}	#@IF DEBUG@#
	}	#@IF DEBUG@#
	close LOG;	#@IF DEBUG@#
}

exit 0;

sub start {
	my ($subDir) = @_;

	opendir DIR,$subDir  or die $!;
	my @files = readdir DIR;
	closedir DIR;

	foreach my $fileName (@files) {
		next if $fileName =~ m/^\./;
		next if $fileName =~ m/ /;
		next unless $fileName =~ m!\.htm$!;

		my $filePath = $subDir.$fileName;
		open FILE, '<:utf8', $filePath  or die "'$filePath' $!";
		read FILE, my $htm, -s FILE;
		my $mtime = (stat FILE)[9];
		close FILE;

		my $original = $htm;
		$_           = $htm;
#----------------------------------------------------------------------------
# 買う ファイター＆メイジ（単数形・複数形入り混じり）
s/(>\s*)Buy Common Items For Fighters?\.?(\s*<)/$1ファイター用の量産アイテムを買う$2/si	&&++$CC[__LINE__];
s/(>\s*)Buy Common Items For Warriors?\.?(\s*<)/$1ファイター用の量産アイテムを買う$2/si	&&++$CC[__LINE__];
s/(>\s*)Buy Common Items For Mystics?\.?(\s*<)/$1メイジ用の量産アイテムを買う$2/si	&&++$CC[__LINE__];
s/(>\s*)Buy Common Items For Wizards?\.?(\s*<)/$1メイジ用の量産アイテムを買う$2/si	&&++$CC[__LINE__];
s/(>\s*)Buy Standard Items for Warriors?\.?(\s*<)/$1ファイター用の量産アイテムを買う$2/si	&&++$CC[__LINE__];
s/(>\s*)Buy Standard Items for Wizards?\.?(\s*<)/$1メイジ用の量産アイテムを買う$2/si	&&++$CC[__LINE__];
s/(>\s*)Buy Equipment for a Fighters?\.?(\s*<)/$1ファイター用の装備を買う$2/si	&&++$CC[__LINE__];
s/(>\s*)Buy Equipment for a Warriors?\.?(\s*<)/$1ファイター用の装備を買う$2/si	&&++$CC[__LINE__];
s/(>\s*)Buy Equipment for a Mystics?\.?(\s*<)/$1メイジ用の装備を買う$2/si	&&++$CC[__LINE__];
s/(>\s*)Buy Fighters?\'? Equipments?\.?(\s*<)/$1ファイター用の装備を買う$2/si	&&++$CC[__LINE__];
s/(>\s*)Buy Warriors?\'? Equipments?\.?(\s*<)/$1ファイター用の装備を買う$2/si	&&++$CC[__LINE__];
s/(>\s*)Buy Mystics?\'? Equipments?\.?(\s*<)/$1メイジ用の装備を買う$2/si	&&++$CC[__LINE__];
s/(>\s*)Buy Fighters?\'? Weapons?\.?(\s*<)/$1ファイター用の武器を買う$2/si	&&++$CC[__LINE__];
s/(>\s*)Buy Warriors?\'? Weapons?\.?(\s*<)/$1ファイター用の武器を買う$2/si	&&++$CC[__LINE__];
s/(>\s*)Buy Mystics?\'? Weapons?\.?(\s*<)/$1メイジ用の武器を買う$2/si	&&++$CC[__LINE__];
s/(>\s*)Buy magicians?\'? equipments?\.?(\s*<)/$1メイジ用の装備を買う$2/si	&&++$CC[__LINE__];
s/(>\s*)Buy Wizards?\'? Equipments?\.?(\s*<)/$1メイジ用の装備を買う$2/si	&&++$CC[__LINE__];
s/(>\s*)Buy Weapons?\.?(\s*<)/$1武器を買う$2/si	&&++$CC[__LINE__];
s/(>\s*)Buy Armors?\.?(\s*<)/$1防具を買う$2/si	&&++$CC[__LINE__];

# 試着 ファイター＆メイジ（単数形・複数形入り混じり）
s/(>\s*)Wear Fighters?\'? Equipments?\.?(\s*<)/$1ファイター用の装備を試着してみる$2/si	&&++$CC[__LINE__];
s/(>\s*)Wear Warriors?\'? Equipments?\.?(\s*<)/$1ファイター用の装備を試着してみる$2/si	&&++$CC[__LINE__];
s/(>\s*)Wear Mystics?\'? Equipments?\.?(\s*<)/$1メイジ用の装備を試着してみる$2/si	&&++$CC[__LINE__];
s/(>\s*)Wear Fighters?\'? Weapons?\.?(\s*<)/$1ファイター用の武器を試着してみる$2/si	&&++$CC[__LINE__];
s/(>\s*)Wear Warriors?\'? Weapons?\.?(\s*<)/$1ファイター用の武器を試着してみる$2/si	&&++$CC[__LINE__];
s/(>\s*)Wear Mystics?\'? Weapons?\.?(\s*<)/$1メイジ用の武器を試着してみる$2/si	&&++$CC[__LINE__];
s/(>\s*)Try on Fighters?\'? Equipments?\.?(\s*<)/$1ファイター用の装備を試着してみる$2/si	&&++$CC[__LINE__];
s/(>\s*)Try on Warriors?\'? Equipments?\.?(\s*<)/$1ファイター用の装備を試着してみる$2/si	&&++$CC[__LINE__];
s/(>\s*)Try on Mystics?\'? Equipments?\.?(\s*<)/$1メイジ用の装備を試着してみる$2/si	&&++$CC[__LINE__];
s/(>\s*)Try on Fighters?\'? Weapons?\.?(\s*<)/$1ファイター用の武器を試着してみる$2/si	&&++$CC[__LINE__];
s/(>\s*)Try on Warriors?\'? Weapons?\.?(\s*<)/$1ファイター用の武器を試着してみる$2/si	&&++$CC[__LINE__];
s/(>\s*)Try on Mystics?\'? Weapons?\.?(\s*<)/$1メイジ用の武器を試着してみる$2/si	&&++$CC[__LINE__];
s/(>\s*)Try on Fighter Equip\.?(\s*<)/$1ファイター用の装備を試着してみる$2/si	&&++$CC[__LINE__];
s/(>\s*)Try on Warrior Equip\.?(\s*<)/$1ファイター用の装備を試着してみる$2/si	&&++$CC[__LINE__];
s/(>\s*)Try on Magician Equip\.?(\s*<)/$1メイジ用の装備を試着してみる$2/si	&&++$CC[__LINE__];
s/(>\s*)Try the warriors?\'? equipment on\.?(\s*<)/$1ファイター用の武器を試着してみる$2/si	&&++$CC[__LINE__];
s/(>\s*)Try the magicians?\'? equipment on\.?(\s*<)/$1メイジ用の武器を試着してみる$2/si	&&++$CC[__LINE__];
s/(>\s*)Try the warriors?\'? equip on\.?(\s*<)/$1ファイター用の武器を試着してみる$2/si	&&++$CC[__LINE__];
s/(>\s*)Try the magicians?\'? equip on\.?(\s*<)/$1メイジ用の武器を試着してみる$2/si	&&++$CC[__LINE__];

# そのた雑貨
s/(>\s*)Buy Spellbooks, Amulets and Blueprints\.?(\s*<)/$1魔法書、お守り、設計図を買う$2/si	&&++$CC[__LINE__];
s/(>\s*)Buy Spellbooks, Charms and Blueprints\.?(\s*<)/$1魔法書、お守り、設計図を買う$2/si	&&++$CC[__LINE__];
s/(>\s*)Buy Spellbooks?\.?(\s*<)/$1魔法書を買う$2/si	&&++$CC[__LINE__];
s/(>\s*)Buy Consumables? and Minerals?\.?(\s*<)/$1消耗品や鉱物を買う$2/si	&&++$CC[__LINE__];
s/(>\s*)Buy Bracelets? and Talismans?\.?(\s*<)/$1ブレスレットやタリスマンを交換する$2/si	&&++$CC[__LINE__];
s/(>\s*)Buy supplies? and minerals?\.?(\s*<)/$1消耗品や鉱物を買う$2/si	&&++$CC[__LINE__];
s/(>\s*)Buy Common Items\.?(\s*<)/$1量産アイテムを買う$2/si	&&++$CC[__LINE__];
s/(>\s*)Buy a Common accessory\.?(\s*<)/$1量産アクセサリーを買う$2/si	&&++$CC[__LINE__];
s/(>\s*)Buy Consumables?\.?(\s*<)/$1消耗品を買う$2/si	&&++$CC[__LINE__];
s/(>\s*)Buy Accessories?\.?(\s*<)/$1アクセサリーを買う$2/si	&&++$CC[__LINE__];
s/(>\s*)Buy an accessory\.?(\s*<)/$1アクセサリーを買う$2/si	&&++$CC[__LINE__];
s/(>\s*)Buy Equipments?\.?(\s*<)/$1装備を買う$2/si	&&++$CC[__LINE__];
s/(>\s*)Buy groceries?\.?(\s*<)/$1雑貨品を買う$2/si	&&++$CC[__LINE__];
s/(>\s*)Buy Dye\.?(\s*<)/$1染料を買う$2/si	&&++$CC[__LINE__];
s/(>\s*)Buy the amulets?\.?(\s*<)/$1お守りを買う$2/si	&&++$CC[__LINE__];
s/(>\s*)Buy an Amulets?\.?(\s*<)/$1お守りを買う$2/si	&&++$CC[__LINE__];
s/(>\s*)Purchase a bracelet or talisman\.?(\s*<)/$1ブレスレットやタリスマンを交換する$2/si	&&++$CC[__LINE__];
s/(>\s*)Purchase jewelry\.?(\s*<)/$1アクセサリーを買う$2/si	&&++$CC[__LINE__];
s/(>\s*)Purchase Dye\.?(\s*<)/$1染料を買う$2/si	&&++$CC[__LINE__];
s/(>\s*)Purchase every type of blueprint.?(\s*<)/$1設計図を買う$2/si	&&++$CC[__LINE__];
s/(>\s*)Buy Talismans?\.?(\s*<)/$1タリスマンを交換する$2/si	&&++$CC[__LINE__];

# 乗船券
s/(>\s*)Buy the ticket of the ferry\.?(\s*<)/$1定期船の乗船券を買う$2/si	&&++$CC[__LINE__];
s/(>\s*)Buy a ticket for the boat\.?(\s*<)/$1定期船の乗船券を買う$2/si	&&++$CC[__LINE__];
s/(>\s*)Buy a ferry ticket\.?(\s*<)/$1定期船の乗船券を買う$2/si	&&++$CC[__LINE__];
s/(>\s*)Buy a liner ticket\.?(\s*<)/$1定期船の乗船券を買う$2/si	&&++$CC[__LINE__];
s/(>\s*)Buy ferry ticket\.?(\s*<)/$1定期船の乗船券を買う$2/si	&&++$CC[__LINE__];
s/"I Will buy a ticket for the ferry."/定期船の乗船券を買う/si	&&++$CC[__LINE__];

#----------------------------------------------------------------------------
# 買う ファイター＆メイジ（単数形・複数形入り混じり）
s/"I want to buy a weapon used by Mystics?\.?"/メイジの武器を買う/i	&&++$CC[__LINE__];
s/"I want to buy Armors? used by Mystics?\.?"/メイジの防具を買う/i	&&++$CC[__LINE__];
s/"I want to buy Warriors? equipments?\.?"/ファイターの装備を買う/i	&&++$CC[__LINE__];
s/"I want to buy Wizards? equipments?\.?"/メイジの装備を買う/i	&&++$CC[__LINE__];
s/"I want to buy Mystics? equipments?\.?"/メイジの装備を買う/i	&&++$CC[__LINE__];

# 試着 ファイター＆メイジ（単数形・複数形入り混じり）
s/"I want to try on a weapon designed for Mystics?\.?"/メイジの武器を試着してみる/i	&&++$CC[__LINE__];
s/"I want to try on Armors? used by Mystics?\.?"/メイジの防具を試着してみる/i	&&++$CC[__LINE__];
s/"I want to try on Warriors? equipments?\.?"/ファイターの装備を試着してみる/i	&&++$CC[__LINE__];
s/"I want to try on Wizards? equipments?\.?"/メイジの装備を試着してみる/i	&&++$CC[__LINE__];
s/"I want to try on Mystics? equipments?\.?"/メイジの装備を試着してみる/i	&&++$CC[__LINE__];

# そのた雑貨
s/"I want to buy consumables? and minerals?\.?"/消耗品や鉱物を買う/i	&&++$CC[__LINE__];
s/"I want to buy supplies? and minerals?\.?"/消耗品や鉱物を買う/i	&&++$CC[__LINE__];
s/"I want to buy an accessory\.?"/アクセサリーを買う/i	&&++$CC[__LINE__];
s/"I want to buy an acessory\.?"/アクセサリーを買う/i	&&++$CC[__LINE__];
s/"I want to buy an amulets?\.?"/お守りを買う/i	&&++$CC[__LINE__];
s/"I want to buy supplies?\.?"/物資を買う/i	&&++$CC[__LINE__];
s/"I want to buy dye\.?"/染料を買う/i	&&++$CC[__LINE__];

# ****-1.htm
s/What would you like to purchase\?<br>/何をお求めですか？<br>/	&&++$CC[__LINE__];
#----------------------------------------------------------------------------
s/(>\s*)Sell\.?(\s*<)/$1売る$2/si	&&++$CC[__LINE__];
s/(>\s*)Buy\.?(\s*<)/$1買う$2/si	&&++$CC[__LINE__];
s/"I want to exchange equipment."/装備を交換する/;
s!(?<=<a action="bypass -h npc_%objectId%_exc_multisell 003">)[^\x{0100}-\x{FFFF}]+?(?=</a>)!装備を交換する!;
s!(?<=<a action="bypass -h npc_%objectId%_Link common/shadow_01.htm">)[^\x{0100}-\x{FFFF}]+?(?=</a>)!幻影兵器を買う!;
## s!(?<=<a action="bypass -h npc_%objectId%_Sell">).+?(?=</a>)!売る!	&&++$CC[__LINE__];
#----------------------------------------------------------------------------
		$htm = $_;

		if ($htm ne $original) {
			print $filePath,"\n";
			my $output = $filePath;
			   $output = $filePath.'.text' if $DEBUG;
			open FILE, '>:utf8', $output  or die "'$output' $!";
			$htm = "\x{feff}".$htm unless $htm =~ m/^\x{feff}/;  #BOM
			print FILE $htm;
			close FILE;
			utime $mtime,$mtime,$output;
		}
	}
}
