﻿## Active Perl 5.8.8

use utf8;
use warnings;
use strict;
use Encode;
binmode STDOUT, ':encoding(cp932)'; $|=1;

my $DEBUG = 0;

opendir DIR,'.'  or die $!;
my @files = readdir DIR;
closedir DIR;

foreach my $fileName (@files) {
	next if $fileName =~ m!^\.!;
	next unless $fileName =~ m!\.htm$!;

	open FILE, '<:utf8', $fileName  or die "'$fileName' $!";
	read FILE, my $htm, -s FILE;
	my $mtime = (stat FILE)[9];
	close FILE;

	my $original = $htm;
	$_           = $htm;
#----------------------------------------------------------------------------
s!\[ *Clan Warehouse *\]![ 血盟倉庫 ]!;
s!\[ *Private Warehouse *\]![ 個人倉庫 ]!;

s!(<a action="bypass -h npc_%objectId%_Chat \d">)(?:Use )*(?:a )*Private Warehouse\.?(?=</a>)!$1個人倉庫!i;
s!(<a action="bypass -h npc_%objectId%_Chat \d">)(?:Use )*(?:a )*Clan Warehouse\.?(?=</a>)!$1血盟倉庫!i;
s!(?:<font color="LEVEL">)*(<a action="bypass -h npc_%objectId%_Chat \d">).*freight service.*</a>(?:</font>)*!$1<font color="LEVEL">貨物サービスを利用する</font></a>!i;

s!(<a action="bypass -h npc_%objectId%_DepositP">).+?(?=</a>)!$1荷物を預ける(個人倉庫)!s;
s!(<a action="bypass -h npc_%objectId%_WithdrawP">).+?(?=</a>)!$1荷物を受け取る(個人倉庫)!s;
# msg 1039…血盟倉庫に預けたアイテムは血盟主のみ取り出しが可能です。それでもよろしいですか？
s!(<a action="bypass -h npc_%objectId%_DepositC"[^>]*>).+?(?=</a>)!$1荷物を預ける(血盟倉庫)!s;
s!(<a action="bypass -h npc_%objectId%_WithdrawC">).+?(?=</a>)!$1荷物を受け取る(血盟倉庫)!s;
# msg 1040…発送される貨物は全地域の貨物倉庫番から取り出しが可能です。よろしいですか？
s!(?:<font color="LEVEL">)*(<a action="bypass -h npc_%objectId%_DepositF"[^>]*>).+?</a>(?:</font>)*!$1<font color="LEVEL">貨物を預ける</font></a>!s;
s!(?:<font color="LEVEL">)*(<a action="bypass -h npc_%objectId%_WithdrawF">).+?</a>(?:</font>)*!$1<font color="LEVEL">貨物を受け取る</font></a>!s;

s!(?<=<a action="bypass -h npc_%objectId%_multisell 631">).+?(?=</a>)!キューブの欠片でアイテムを購入する!;	# Purchase an item with a Cube piece

s!(?<=_SkillList">).+?(?=</a>)!スキルを習う!;
s!(?<=_Link common/skill_enchant.htm">).+?(?=</a>)!スキルを強化する!;
s!(?<=_Link common/skill_enchant_help.htm">).+?(?=</a>)!スキルの強化について聞く!;
s!(?<=_Quest">).+?(?=</a>)!クエスト!;
s!(?<=_Chat 0">).+?(?=</a>)!戻る!;
#----------------------------------------------------------------------------
	$htm = $_;

	if ($htm ne $original) {
		print $fileName,"\n";
		my $output = $fileName;
		   $output = "$fileName.text" if $DEBUG;
		open FILE, '>:utf8', $output  or die "'$output' $!";
		$htm = "\x{feff}".$htm unless $htm =~ m/^\x{feff}/;  #BOM
		print FILE $htm;
		close FILE;
		utime $mtime,$mtime,$output;
	}
}
