/*
 * This program is free software: you can redistribute it and/or modify it under
 * the terms of the GNU General Public License as published by the Free Software
 * Foundation, either version 3 of the License, or (at your option) any later
 * version.
 * 
 * This program is distributed in the hope that it will be useful, but WITHOUT
 * ANY WARRANTY; without even the implied warranty of MERCHANTABILITY or FITNESS
 * FOR A PARTICULAR PURPOSE. See the GNU General Public License for more
 * details.
 * 
 * You should have received a copy of the GNU General Public License along with
 * this program. If not, see <http://www.gnu.org/licenses/>.
 */
package ai.fantasy_isle;

import java.text.SimpleDateFormat;
import java.util.Map;

import javolution.util.FastMap;
import net.sf.l2j.Config;
import net.sf.l2j.gameserver.GameTimeController;
import net.sf.l2j.gameserver.ThreadPoolManager;
import net.sf.l2j.gameserver.ai.CtrlIntention;
import net.sf.l2j.gameserver.model.L2CharPosition;
import net.sf.l2j.gameserver.model.actor.L2Npc;
import net.sf.l2j.gameserver.model.actor.instance.L2PcInstance;
import net.sf.l2j.gameserver.model.quest.Quest;
import net.sf.l2j.gameserver.network.serverpackets.NpcSay;
import net.sf.l2j.gameserver.network.serverpackets.PlaySound;
import net.sf.l2j.gameserver.network.serverpackets.SocialAction;


/**
 * MC show script
 * @author Kerberos
 */
public class MC_Show extends Quest
{
	private static final int MC = 32433;
	private static int[] singers = {32431,32432};
	private static int[] circus = {32442,32443,32444,32445,32446};
	private static int[] individuals = {32439,32440,32441};
	private static int[] showstuff = {32424,32425,32426,32427,32428};
	private static boolean isStarted = false;
	private static String[] text = {
/*0*/	"ȂŒNW܂ĂȂ́DDDCxgn܂̂ɁDDDB",
	//	"How come people are not here... We are about to start the show.. Hmm",
/*1*/	"AْDDDoԂȂ̂ɂǂ悤DDDB",
	//	"Ugh, I have butterflies in my stomach.. The show starts soon...",
/*2*/	"{͓ʃCxgɂW܂肢A܂Ƃɂ肤Ƃ܂B","̂悤ȃCxgJÂłƂv܂B",
	//	"Thank you all for coming here tonight.","It is an honor to have the special show today.",
/*4*/	"̌z̓ł́AFlɂy݂悤Aɐ^SsĂ܂B",
	//	"Our Fantasy Isle is fully committed to your happiness.",
/*5*/	"ł́ÃCxgɉ؂YAf񂾍ō̔l̎AC~Љ܂I",
	//	"Now I'd like to introduce the most beautiful singer in Aden. Please welcome Leyla Mira!",
/*6*/	"ǂ`B","C~A肪Ƃ܂B́DDD",
	//	"Here she comes!","Thank you very much, Leyla. Next is",
/*8*/	"͂B̓Afւ閼l|y݂܂傤B܂A[h cA[IȀɋ삯tĂz̓̋Ȍ|c̊FłI",
	//	"It was very difficult to invite this first group that just came back from their world tour. Let's welcome the Fantasy Isle Circus!",
/*9*/	"Ȍ|c̊F`A͂肫ĂǂI","łBf炵łˁB",
	//	"Come on ~ everyone","Did you like it? That was so amazing.",
/*11*/	"A͊enW܂˔\̕łB","ł́Igbvob^[肢܂I",
	//	"Now we also invited individuals with special talents.","Let's welcome the first person here!",
/*13*/	"GGGG`B","͂Bł͎̕肢܂B",
	//	";;;;;;Oh","Okay, now here comes the next person. Come on up please.",
/*15*/	"AȂ肷ł˂B", "nbGGGG",
	//	"Oh, it looks like something great is going to happen, right?", "Oh, my ;;;;",
/*17*/	"A΂炵Ił͍Ō̕A肢܂I","ɂĊlElV[JƂĂ܂B",
	//	"That's g- .. great. Now, here comes the last person.","Now this is the end of today's show.",
/*19*/	"FǂłHył܂B",
	//	"How was it? I am not sure if you really enjoyed it.",
/*20*/	"ǂz̓ł́AFlɊł悤lXȃCxgpӂĂ܂Bǂ҂B",
	//	"Please remember that Fantasy Isle is always planning a lot of great shows for you.",
/*21*/	"cɂłAɂĕƂĂ܂B"
	//	"Well, I wish I could continue all night long, but this is it for today. Thank you."
	};
	
	private static Map<String, Object[]> talks = new FastMap<String, Object[]>();
	private static Map<String, Object[]> walks = new FastMap<String, Object[]>();
	
	private void load()
	{
		talks.put("1", new Object[]{text[1],"2",1000});
        talks.put("2", new Object[]{text[2],"3",6000});
        talks.put("3", new Object[]{text[3],"4",4000});
        talks.put("4", new Object[]{text[4],"5",5000});
        talks.put("5", new Object[]{text[5],"6",3000});
        talks.put("8", new Object[]{text[8],"9",5000});
        talks.put("9", new Object[]{text[9],"10",5000});
        talks.put("12", new Object[]{text[11],"13",5000});
        talks.put("13", new Object[]{text[12],"14",5000});
        talks.put("15", new Object[]{text[13],"16",5000});
        talks.put("16", new Object[]{text[14],"17",5000});
        talks.put("18", new Object[]{text[16],"19",5000});
        talks.put("19", new Object[]{text[17],"20",5000});
        talks.put("21", new Object[]{text[18],"22",5000});
        talks.put("22", new Object[]{text[19],"23",400});
        talks.put("25", new Object[]{text[20],"26",5000});
        talks.put("26", new Object[]{text[21],"27",5400});
        
        walks.put("npc1_1" , new Object[]{-56546,-56384,-2008,"npc1_2",1200});
        walks.put("npc1_2" , new Object[]{-56597,-56384,-2008,"npc1_3",1200});
     	walks.put("npc1_3" , new Object[]{-56596,-56428,-2008,"npc1_4",1200});
     	walks.put("npc1_4" , new Object[]{-56593,-56474,-2008,"npc1_5",1000});
     	walks.put("npc1_5" , new Object[]{-56542,-56474,-2008,"npc1_6",1000});
     	walks.put("npc1_6" , new Object[]{-56493,-56473,-2008,"npc1_7",2000});
     	walks.put("npc1_7" , new Object[]{-56495,-56425,-2008,"npc1_1",4000});
     	walks.put("npc2_1" , new Object[]{-56550,-56291,-2008,"npc2_2",1200});
     	walks.put("npc2_2" , new Object[]{-56601,-56293,-2008,"npc2_3",1200});
     	walks.put("npc2_3" , new Object[]{-56603,-56247,-2008,"npc2_4",1200});
     	walks.put("npc2_4" , new Object[]{-56605,-56203,-2008,"npc2_5",1000});
     	walks.put("npc2_5" , new Object[]{-56553,-56202,-2008,"npc2_6",1100});
     	walks.put("npc2_6" , new Object[]{-56504,-56200,-2008,"npc2_7",2000});
     	walks.put("npc2_7" , new Object[]{-56503,-56243,-2008,"npc2_1",4000});
     	walks.put("npc3_1" , new Object[]{-56500,-56290,-2008,"npc3_2",1200});
     	walks.put("npc3_2" , new Object[]{-56551,-56313,-2008,"npc3_3",1200});
     	walks.put("npc3_3" , new Object[]{-56601,-56293,-2008,"npc3_4",1200});
     	walks.put("npc3_4" , new Object[]{-56651,-56294,-2008,"npc3_5",1200});
     	walks.put("npc3_5" , new Object[]{-56653,-56250,-2008,"npc3_6",1200});
     	walks.put("npc3_6" , new Object[]{-56654,-56204,-2008,"npc3_7",1200});
     	walks.put("npc3_7" , new Object[]{-56605,-56203,-2008,"npc3_8",1200});
     	walks.put("npc3_8" , new Object[]{-56554,-56202,-2008,"npc3_9",1200});
     	walks.put("npc3_9" , new Object[]{-56503,-56200,-2008,"npc3_10",1200});
     	walks.put("npc3_10", new Object[]{-56502,-56244,-2008,"npc3_1",900});
     	walks.put("npc4_1" , new Object[]{-56495,-56381,-2008,"npc4_2",1200});
     	walks.put("npc4_2" , new Object[]{-56548,-56383,-2008,"npc4_3",1200});
     	walks.put("npc4_3" , new Object[]{-56597,-56383,-2008,"npc4_4",1200});
     	walks.put("npc4_4" , new Object[]{-56643,-56385,-2008,"npc4_5",1200});
     	walks.put("npc4_5" , new Object[]{-56639,-56436,-2008,"npc4_6",1200});
     	walks.put("npc4_6" , new Object[]{-56639,-56473,-2008,"npc4_7",1200});
     	walks.put("npc4_7" , new Object[]{-56589,-56473,-2008,"npc4_8",1200});
     	walks.put("npc4_8" , new Object[]{-56541,-56473,-2008,"npc4_9",1200});
     	walks.put("npc4_9" , new Object[]{-56496,-56473,-2008,"npc4_10",1200});
     	walks.put("npc4_10", new Object[]{-56496,-56429,-2008,"npc4_1",900});
     	walks.put("npc5_1" , new Object[]{-56549,-56335,-2008,"npc5_2",1000});
     	walks.put("npc5_2" , new Object[]{-56599,-56337,-2008,"npc5_3",2000});
     	walks.put("npc5_3" , new Object[]{-56649,-56341,-2008,"npc5_4",26000});
     	walks.put("npc5_4" , new Object[]{-56600,-56341,-2008,"npc5_5",1000});
     	walks.put("npc5_5" , new Object[]{-56553,-56341,-2008,"npc5_6",1000});
     	walks.put("npc5_6" , new Object[]{-56508,-56331,-2008,"npc5_2",8000});
     	walks.put("npc6_1" , new Object[]{-56595,-56428,-2008,"npc6_2",1000});
     	walks.put("npc6_2" , new Object[]{-56596,-56383,-2008,"npc6_3",1000});
     	walks.put("npc6_3" , new Object[]{-56648,-56384,-2008,"npc6_4",1000});
     	walks.put("npc6_4" , new Object[]{-56645,-56429,-2008,"npc6_5",1000});
     	walks.put("npc6_5" , new Object[]{-56644,-56475,-2008,"npc6_6",1000});
     	walks.put("npc6_6" , new Object[]{-56595,-56473,-2008,"npc6_7",1000});
     	walks.put("npc6_7" , new Object[]{-56542,-56473,-2008,"npc6_8",1000});
     	walks.put("npc6_8" , new Object[]{-56492,-56472,-2008,"npc6_9",1200});
     	walks.put("npc6_9" , new Object[]{-56495,-56426,-2008,"npc6_10",2000});
     	walks.put("npc6_10", new Object[]{-56540,-56426,-2008,"npc6_1",3000});
     	walks.put("npc7_1" , new Object[]{-56603,-56249,-2008,"npc7_2",1000});
     	walks.put("npc7_2" , new Object[]{-56601,-56294,-2008,"npc7_3",1000});
     	walks.put("npc7_3" , new Object[]{-56651,-56295,-2008,"npc7_4",1000});
     	walks.put("npc7_4" , new Object[]{-56653,-56248,-2008,"npc7_5",1000});
     	walks.put("npc7_5" , new Object[]{-56605,-56203,-2008,"npc7_6",1000});
     	walks.put("npc7_6" , new Object[]{-56554,-56202,-2008,"npc7_7",1000});
     	walks.put("npc7_7" , new Object[]{-56504,-56201,-2008,"npc7_8",1000});
     	walks.put("npc7_8" , new Object[]{-56502,-56247,-2008,"npc7_9",1200});
     	walks.put("npc7_9" , new Object[]{-56549,-56248,-2008,"npc7_10",2000});
     	walks.put("npc7_10", new Object[]{-56549,-56248,-2008,"npc7_1",3000});
     	walks.put("npc8_1" , new Object[]{-56493,-56426,-2008,"npc8_2",1000});
     	walks.put("npc8_2" , new Object[]{-56497,-56381,-2008,"npc8_3",1200});
     	walks.put("npc8_3" , new Object[]{-56544,-56381,-2008,"npc8_4",1200});
     	walks.put("npc8_4" , new Object[]{-56596,-56383,-2008,"npc8_5",1200});
     	walks.put("npc8_5" , new Object[]{-56594,-56428,-2008,"npc8_6",900});
     	walks.put("npc8_6" , new Object[]{-56645,-56429,-2008,"npc8_7",1200});
     	walks.put("npc8_7" , new Object[]{-56647,-56384,-2008,"npc8_8",1200});
     	walks.put("npc8_8" , new Object[]{-56649,-56362,-2008,"npc8_9",9200});
     	walks.put("npc8_9" , new Object[]{-56654,-56429,-2008,"npc8_10",1200});
     	walks.put("npc8_10", new Object[]{-56644,-56474,-2008,"npc8_11",900});
     	walks.put("npc8_11", new Object[]{-56593,-56473,-2008,"npc8_12",1100});
     	walks.put("npc8_12", new Object[]{-56543,-56472,-2008,"npc8_13",1200});
     	walks.put("npc8_13", new Object[]{-56491,-56471,-2008,"npc8_1",1200});
     	walks.put("npc9_1" , new Object[]{-56505,-56246,-2008,"npc9_2",1000});
     	walks.put("npc9_2" , new Object[]{-56504,-56291,-2008,"npc9_3",1200});
     	walks.put("npc9_3" , new Object[]{-56550,-56291,-2008,"npc9_4",1200});
     	walks.put("npc9_4" , new Object[]{-56600,-56292,-2008,"npc9_5",1200});
     	walks.put("npc9_5" , new Object[]{-56603,-56248,-2008,"npc9_6",900});
     	walks.put("npc9_6" , new Object[]{-56653,-56249,-2008,"npc9_7",1200});
     	walks.put("npc9_7" , new Object[]{-56651,-56294,-2008,"npc9_8",1200});
     	walks.put("npc9_8" , new Object[]{-56650,-56316,-2008,"npc9_9",9200});
     	walks.put("npc9_9" , new Object[]{-56660,-56250,-2008,"npc9_10",1200});
     	walks.put("npc9_10", new Object[]{-56656,-56205,-2008,"npc9_11",900});
     	walks.put("npc9_11", new Object[]{-56606,-56204,-2008,"npc9_12",1100});
     	walks.put("npc9_12", new Object[]{-56554,-56203,-2008,"npc9_13",1200});
     	walks.put("npc9_13", new Object[]{-56506,-56203,-2008,"npc9_1",1200});
     	walks.put("24"     , new Object[]{-56730,-56340,-2008,"25",1800});
     	walks.put("27"     , new Object[]{-56702,-56340,-2008,"29",1800});
	}
	
	public MC_Show(int id,String name,String descr)
	{
        super(id,name,descr);
        addEventId(MC, Quest.QuestEventType.ON_SPAWN);
        addEventId(32431, Quest.QuestEventType.ON_SPAWN);
        addEventId(32432, Quest.QuestEventType.ON_SPAWN);
        addEventId(32442, Quest.QuestEventType.ON_SPAWN);
        addEventId(32443, Quest.QuestEventType.ON_SPAWN);
        addEventId(32444, Quest.QuestEventType.ON_SPAWN);
        addEventId(32445, Quest.QuestEventType.ON_SPAWN);
        addEventId(32446, Quest.QuestEventType.ON_SPAWN);
        addEventId(32424, Quest.QuestEventType.ON_SPAWN);
        addEventId(32425, Quest.QuestEventType.ON_SPAWN);
        addEventId(32426, Quest.QuestEventType.ON_SPAWN);
        addEventId(32427, Quest.QuestEventType.ON_SPAWN);
        addEventId(32428, Quest.QuestEventType.ON_SPAWN);
        load();
        scheduleTimer();
	}
	
	private long timeLeftMilli(int hh, int mm, int ss)
	{
		int now = GameTimeController.getGameTicks() * 60 / 100;
		int dd = (hh * 3600 + mm * 60 + ss) - (now % 86400);
		if (dd < 0) dd += 86400;

		return dd * 1000L / 6L;
	}
	
	private void scheduleTimer()
	{
		final long diff = timeLeftMilli(8,0,0), cycle = 3600000L;		//(lԂ800JnA6ԂƌJԂ)
//		final long diff = timeLeftMilli(20,30,0), cycle = 14400000L;	//{Idl(lԂ2130JnA24ԂƌJԂ)
		if (Config.DEBUG)
		{
			SimpleDateFormat format = new SimpleDateFormat("yyyy/MM/dd HH:mm");
			_log.info("Fantasy Isle: MC show script starting at " + format.format(System.currentTimeMillis()+diff)+ " and is scheduled each next "+(cycle/3600000)+" hours.");
		}
		ThreadPoolManager.getInstance().scheduleGeneralAtFixedRate(new StartMCShow(), diff, cycle);
		
	}
	
	private void autoChat(L2Npc npc, String text_, int type)
	{
		npc.broadcastPacket(new NpcSay(npc.getObjectId(), type, npc.getNpcId(), text_));
	}
	
	public String onSpawn(L2Npc npc)
	{
		if (isStarted)
		{
			switch (npc.getNpcId())
			{
				case MC:
					autoChat(npc,text[0],1);
					startQuestTimer("1",30000, npc, null);
					break;
				case 32431:
					npc.getAI().setIntention(CtrlIntention.AI_INTENTION_MOVE_TO,new L2CharPosition(-56657,-56338,-2008,33102));
					startQuestTimer("social1",6000, npc, null, true);
					startQuestTimer("7",215000, npc, null);
					break;
				case 32432:
					startQuestTimer("social1",6000, npc, null, true);
					startQuestTimer("7",215000, npc, null);
					break;
				case 32442:
				case 32443:
				case 32444:
				case 32445:
				case 32446:
					startQuestTimer("11",100000, npc, null);
					break;
				case 32424:
				case 32425:
				case 32426:
				case 32427:
				case 32428:
					startQuestTimer("social1",5500, npc, null);
					startQuestTimer("social1",12500, npc, null);
					startQuestTimer("28",19700, npc, null);
					break;
			}
		}
		return super.onSpawn(npc);
	}
	public String onAdvEvent (String event, L2Npc npc, L2PcInstance player)
	{
		if (event.equals/*IgnoreCase*/("Start"))
		{
			isStarted = true;
			net.sf.l2j.gameserver.Announcements.getInstance().announceToAll("݂Ȃ`Az̓̃Xe[WőfGȃVEn܂\u2764");  //[JOJO]
			addSpawn(MC,-56698,-56430,-2008,32768,false,0);
		}
		else if (npc != null && ! npc.isDecayed())	//+[JOJO]
	//	else if (npc != null && isStarted)			//-[JOJO]
		{
			if (event == "6")	//C~Jn (215b)
			{
				autoChat(npc,text[6],1);
				npc.getAI().setIntention(CtrlIntention.AI_INTENTION_MOVE_TO, new L2CharPosition(-56511,-56647,-2008,36863));
				npc.broadcastPacket(new PlaySound(1, "NS22_F", 0, 0, 0, 0, 0));
				addSpawn(singers[0],-56344,-56328,-2008,32768,false,224000);
				addSpawn(singers[1],-56552,-56245,-2008,36863,false,224000);
				addSpawn(singers[1],-56546,-56426,-2008,28672,false,224000);
				addSpawn(singers[1],-56570,-56473,-2008,28672,false,224000);
				addSpawn(singers[1],-56594,-56516,-2008,28672,false,224000);
				addSpawn(singers[1],-56580,-56203,-2008,36863,false,224000);
				addSpawn(singers[1],-56606,-56157,-2008,36863,false,224000);
				startQuestTimer("7",215000, npc, null);
			}
			else if (event == "7")	//C~I
			{
				switch (npc.getNpcId())
				{
					case MC:
						autoChat(npc,text[7],1);
						npc.getAI().setIntention(CtrlIntention.AI_INTENTION_MOVE_TO,new L2CharPosition(-56698,-56430,-2008,32768));
						startQuestTimer("8",12000, npc, null);
						break;
					default:
						cancelQuestTimer("social1", npc, null);
						npc.getAI().setIntention(CtrlIntention.AI_INTENTION_MOVE_TO,new L2CharPosition(-56594,-56064,-2008,32768));
						break;
				}
			}
			else if (event == "10")	//T[JXJn (100b)
			{
				npc.getAI().setIntention(CtrlIntention.AI_INTENTION_MOVE_TO,new L2CharPosition(-56483,-56665,-2034,32768));
				npc.broadcastPacket(new PlaySound(1, "TP05_F", 0, 0, 0, 0, 0));
				startQuestTimer("npc1_1",3000, addSpawn(circus[0],-56495,-56375,-2008,32768,false,101000), null);
				startQuestTimer("npc2_1",3000, addSpawn(circus[0],-56491,-56289,-2008,32768,false,101000), null);
				startQuestTimer("npc3_1",3000, addSpawn(circus[1],-56502,-56246,-2008,32768,false,101000), null);
				startQuestTimer("npc4_1",3000, addSpawn(circus[1],-56496,-56429,-2008,32768,false,101000), null);
				startQuestTimer("npc5_1",3500, addSpawn(circus[2],-56505,-56334,-2008,32768,false,101000), null);
				startQuestTimer("npc6_1",4000, addSpawn(circus[3],-56545,-56427,-2008,32768,false,101000), null);
				startQuestTimer("npc7_1",4000, addSpawn(circus[3],-56552,-56248,-2008,32768,false,101000), null);
				startQuestTimer("npc8_1",3000, addSpawn(circus[4],-56493,-56473,-2008,32768,false,101000), null);
				startQuestTimer("npc9_1",3000, addSpawn(circus[4],-56504,-56201,-2008,32768,false,101000), null);
				startQuestTimer("11",100000, npc, null);
			}
			else if (event == "11")	//T[JXI
			{
				switch (npc.getNpcId())
				{
					case MC:
						autoChat(npc,text[10],1);
						npc.getAI().setIntention(CtrlIntention.AI_INTENTION_MOVE_TO,new L2CharPosition(-56698,-56430,-2008,32768));
						startQuestTimer("12",5000, npc, null);
						break;
					default:
						npc.getAI().setIntention(CtrlIntention.AI_INTENTION_MOVE_TO,new L2CharPosition(-56343,-56330,-2008,32768));
						break;
				}
			}
			else if (event == "14")
			{
				startQuestTimer("social1",2000, addSpawn(individuals[0],-56700,-56385,-2008,32768,false,49000), null);
				startQuestTimer("15",7000, npc, null);
			}
			else if (event == "17")
			{
				autoChat(npc,text[15],1);
				startQuestTimer("social1",2000,addSpawn(individuals[1],-56700,-56340,-2008,32768,false,32000), null);
				startQuestTimer("18",9000, npc, null);
			}
			else if (event == "20")
			{
				startQuestTimer("social1",2000, addSpawn(individuals[2],-56703,-56296,-2008,32768,false,13000), null);
				startQuestTimer("21",8000, npc, null);
			}
			else if (event == "23")	//X^bt
			{
				npc.getAI().setIntention(CtrlIntention.AI_INTENTION_MOVE_TO,new  L2CharPosition(-56702,-56340,-2008,32768));
				startQuestTimer("24",2800, npc, null);
				addSpawn(showstuff[0],-56672,-56406,-2000,32768,false,20900);
			    addSpawn(showstuff[1],-56648,-56368,-2000,32768,false,20900);
			    addSpawn(showstuff[2],-56608,-56338,-2000,32768,false,20900);
			    addSpawn(showstuff[3],-56652,-56307,-2000,32768,false,20900);
			    addSpawn(showstuff[4],-56672,-56272,-2000,32768,false,20900);
			}
			else if (event == "28")
			{
				autoChat(npc,"ł͊Fl悤B",0);
			//	autoChat(npc,"We love you.",0);
				startQuestTimer("social1",1, npc, null);
			}
			else if (event == "29")
			{
				npc.getAI().setIntention(CtrlIntention.AI_INTENTION_MOVE_TO,new  L2CharPosition(-56730,-56340,-2008,32768));
				startQuestTimer("clean_npc",4100, npc, null);
			/*	startQuestTimer("timer_check",60000, null, null, true);	*/	//-[JOJO]
			}
			else if (event == "social1")
				npc.broadcastPacket(new SocialAction(npc.getObjectId(),1));
			else if (event == "clean_npc")
			{
				isStarted = false;
				npc.deleteMe();
			}
			else
			{
				Object[] action;
				if ((action = talks.get(event)) != null)
				{
					String text_ = (String) action[0];
					String nextEvent = (String) action[1];
					int time = (Integer) action[2];
					autoChat(npc,text_,1);
					startQuestTimer(nextEvent,time, npc, null);
				}
				else if ((action = walks.get(event)) != null)
				{
					int x = (Integer) action[0];
					int y = (Integer) action[1];
					int z = (Integer) action[2];
					String nextEvent = (String) action[3];
					int time = (Integer) action[4];
					npc.getAI().setIntention(CtrlIntention.AI_INTENTION_MOVE_TO,new L2CharPosition(x,y,z,0));
					startQuestTimer(nextEvent,time, npc, null);
				}
				else							//+[JOJO]
					throw new AssertionError();	//+[JOJO]
			}
		}
		return null;
	}
	
    public static void main(String[] args)
    {
    	// now call the constructor (starts up the ai)
    	new MC_Show(-1,"MC_Show","fantasy_isle");
    }
}

/**
  F
    Q[Ԃł"24"́AłSԁB܂U{B
    T[oN "6"ɐݒ肳B
    Xe[W͂܂"2030"́AT[oNĂ"1430"Ȃ̂ŁA
    ɊZ(UŊ)QԂQTB

    p[h̓Q[Ԃ
      2:00A8:00A14:00A20:00 ̂PSAUԂƂɂȂB
    Xe[W
      20:30 ̂P̂݁B
*/
