/*
 * This program is free software: you can redistribute it and/or modify it under
 * the terms of the GNU General Public License as published by the Free Software
 * Foundation, either version 3 of the License, or (at your option) any later
 * version.
 * 
 * This program is distributed in the hope that it will be useful, but WITHOUT
 * ANY WARRANTY; without even the implied warranty of MERCHANTABILITY or FITNESS
 * FOR A PARTICULAR PURPOSE. See the GNU General Public License for more
 * details.
 * 
 * You should have received a copy of the GNU General Public License along with
 * this program. If not, see <http://www.gnu.org/licenses/>.
 */
package ai.individual;

import java.util.ArrayList;
import java.util.List;

import net.sf.l2j.Config;
import net.sf.l2j.gameserver.ai.CtrlIntention;
import net.sf.l2j.gameserver.instancemanager.GrandBossManager;
import net.sf.l2j.gameserver.model.L2CharPosition;
import net.sf.l2j.gameserver.model.L2ItemInstance;
import net.sf.l2j.gameserver.model.L2Party;
import net.sf.l2j.gameserver.model.actor.L2Npc;
import net.sf.l2j.gameserver.model.actor.instance.L2GrandBossInstance;
import net.sf.l2j.gameserver.model.actor.instance.L2PcInstance;
import net.sf.l2j.gameserver.model.itemcontainer.PcInventory;
import net.sf.l2j.gameserver.model.zone.type.L2BossZone;
import net.sf.l2j.gameserver.network.SystemMessageId;
import net.sf.l2j.gameserver.network.serverpackets.CreatureSay;
import net.sf.l2j.gameserver.network.serverpackets.Earthquake;
import net.sf.l2j.gameserver.network.serverpackets.ExShowScreenMessage;
import net.sf.l2j.gameserver.network.serverpackets.PlaySound;
import net.sf.l2j.gameserver.network.serverpackets.SocialAction;
import net.sf.l2j.gameserver.network.serverpackets.SystemMessage;
import net.sf.l2j.gameserver.templates.StatsSet;
import net.sf.l2j.gameserver.util.Broadcast;
import net.sf.l2j.gameserver.util.Util;
import net.sf.l2j.util.Rnd;
import ai.group_template.L2AttackableAIScript;

/**
 * Antharas AI
 * @author Emperorc
 */
public class Antharas extends L2AttackableAIScript
{
	
	private static final int ANTHARAS = 29019;
	private static final int BEHEMOTH_DRAGON = 29069;
	private static final int DRAGON_BOMBER = 29076;
	private static final int ANTHARAS_CIRCLET = 8568;

	//Antharas Status Tracking :
	private static final byte DORMANT = 0;     	//Antharas is spawned and no one has entered yet. Entry is unlocked
	private static final byte WAITING = 1;     	//Antharas is spawend and someone has entered, triggering a 30 minute window for additional people to enter
	                							//before he unleashes his attack. Entry is unlocked
	private static final byte FIGHTING = 2;    	//Antharas is engaged in battle, annihilating his foes. Entry is locked
	private static final byte DEAD = 3;        	//Antharas has been killed. Entry is locked
    
	private static long _LastAction = 0;
	
	private static L2BossZone _Zone;
	private static L2Npc[] _minions;

	//[JOJO]-------------------------------------------------
	private class SpecialCamera extends net.sf.l2j.gameserver.network.serverpackets.SpecialCamera
	{
		public SpecialCamera(int id, int dist, int yaw, int pitch, int time, int duration)
		{
			super(id, dist, yaw, pitch, time, duration, 0, 0, 1, 0);
		}
	}
	//-------------------------------------------------------
	
	// Boss: Antharas
	public Antharas(int id,String name,String descr)
	{
        super(id,name,descr);
        int[] mob = {ANTHARAS};
        this.registerMobs(mob);
        _Zone = GrandBossManager.getInstance().getZone(179700,113800,-7709);
        StatsSet info = GrandBossManager.getInstance().getStatsSet(ANTHARAS);
        int status = GrandBossManager.getInstance().getBossStatus(ANTHARAS);
        if (info.getInteger("loc_x") == 0 && info.getInteger("loc_y") == 0) status = DEAD;	//[JOJO]
        if (status == DEAD)
        {
            // load the unlock date and time for antharas from DB
            long temp = (info.getLong("respawn_time") - System.currentTimeMillis());
            // if antharas is locked until a certain time, mark it so and start the unlock timer
            // the unlock time has not yet expired.  Mark Antharas as currently locked.  Setup a timer
            // to fire at the correct time (calculate the time between now and the unlock time,
            // setup a timer to fire after that many msec)
            if (temp > 0)
            {
                this.startQuestTimer("antharas_unlock", temp, null, null);
                _log.info("AI script: Next spawn date of Anthras is " + GrandBossManager.respawnTimeFormat(info) + ".");
            }
            else
            {
                // the time has already expired while the server was offline. Immediately spawn antharas in his cave.
                // also, the status needs to be changed to DORMANT
                L2GrandBossInstance antharas = (L2GrandBossInstance) addSpawn(ANTHARAS,185708,114298,-8221,32768,false,0);
                GrandBossManager.getInstance().setBossStatus(ANTHARAS,DORMANT);
                _Zone.broadcastPacket(new Earthquake(185708,114298,-8221,20,10));
                GrandBossManager.getInstance().addBoss(antharas);
            }
        }
        else
        {
            int loc_x = info.getInteger("loc_x");
            int loc_y = info.getInteger("loc_y");
            int loc_z = info.getInteger("loc_z") - 20;
            int heading = info.getInteger("heading");
            int hp = info.getInteger("currentHP");
            int mp = info.getInteger("currentMP");
            L2GrandBossInstance antharas = (L2GrandBossInstance) addSpawn(ANTHARAS,loc_x,loc_y,loc_z,heading,false,0);
            GrandBossManager.getInstance().addBoss(antharas);
            antharas.setCurrentHpMp(hp,mp);
            if (status == WAITING)
            {
                // Start timer to lock entry after 30 minutes
                this.startQuestTimer("waiting_3",Config.FWA_APPTIMEOFANTHARAS, antharas, null);	//[JOJO]
            }
            else if (status == FIGHTING)
            {
                _LastAction = System.currentTimeMillis();
                // Start repeating timer to check for inactivity
                this.startQuestTimer("antharas_despawn",60000, antharas, null, true);
            }
        }
	}

	public String onAdvEvent (String event, L2Npc npc, L2PcInstance player)
	{
        if (npc != null)
        {
            if (event.equals("waiting_3")) // <- scripts/teleports/6000_GrandBossTeleporters/__init__.py
            {
                this.startQuestTimer("waiting_2",60000, npc, null);
                this.screenMessage("3O");
              //this.announce("A^Xoꃀ[r[̓Xe[Wɋ߂ÂĂB");
            }
            else if (event == "waiting_2")
            {
                this.startQuestTimer("waiting_1",60000, npc, null);
                this.screenMessage("2O");
            }
            else if (event == "waiting_1")
            {
                this.startQuestTimer("waiting",60000, npc, null);
                this.screenMessage("1O");
                _Zone.broadcastPacket(new Earthquake(179700,113800,-7709,40,15));
            }
            else if (event == "waiting")
            {
                _Zone.updateKnownList(npc);
                npc.teleToLocation(185452,114835,-8221);
                ((L2GrandBossInstance)npc).setIsInSocialAction(true);
                npc.getAI().setIntention(CtrlIntention.AI_INTENTION_MOVE_TO, new L2CharPosition(181911,114835,-7678,0));
                this.startQuestTimer("antharas_has_arrived",2000, npc, null, true);
                _Zone.broadcastPacket(new PlaySound(1, "BS02_A", 1, npc.getObjectId(), 185452, 114835, -8221));
                GrandBossManager.getInstance().setBossStatus(ANTHARAS,FIGHTING);
                this.screenMessage("o");
            }
            else if (event == "camera_1")
            {
                this.startQuestTimer("camera_2",3000, npc, null);
                _Zone.broadcastPacket(new SpecialCamera(npc.getObjectId(),700,13,-19,0,20000));
            }
            else if (event == "camera_2")
            {
                this.startQuestTimer("camera_3",10000, npc, null);
                _Zone.broadcastPacket(new SpecialCamera(npc.getObjectId(),700,13,0,6000,20000));
            }
            else if (event == "camera_3")
            {
                this.startQuestTimer("camera_4",200, npc, null);
                _Zone.broadcastPacket(new SpecialCamera(npc.getObjectId(),3700,0,-3,0,10000));
            }
            else if (event == "camera_4")
            {
                this.startQuestTimer("camera_5",10800, npc, null);
                _Zone.broadcastPacket(new SpecialCamera(npc.getObjectId(),1100,0,-3,22000,30000));
            }
            else if (event == "camera_5")
            {
                this.startQuestTimer("minion_spawn", 30000, npc, null, false);
                this.startQuestTimer("antharas_despawn",60000, npc, null, true);
				((L2GrandBossInstance)npc).setIsInSocialAction(false);
                _Zone.broadcastPacket(new SpecialCamera(npc.getObjectId(),1100,0,-3,300,7000));
                _LastAction = System.currentTimeMillis();
                Broadcast.announceToOnlinePlayers("nA^Xoꂵ܂B");
                this.announce("A^X15ԍUȂłƁAɖ߂Ă܂܂B");
            }
            else if (event == "antharas_despawn")
            {
                CtrlIntention aiInt;
                long temp = (System.currentTimeMillis() - _LastAction);
                if (temp > 900000)
                {
                    this.cancelQuestTimer("antharas_despawn", npc, null);
    				despawnMinions();	//+[JOJO]
                    npc.teleToLocation(185708,114298,-8221);
                    GrandBossManager.getInstance().setBossStatus(ANTHARAS,DORMANT);
                    npc.setCurrentHpMp(npc.getMaxHp(),npc.getMaxMp());
                    _Zone.oustAllPlayers();
                }
                else if (Config.FWV_MOVEATRANDOM && temp >= 60000 && (
                        (aiInt = npc.getAI().getIntention()) == CtrlIntention.AI_INTENTION_ACTIVE
                                                    || aiInt == CtrlIntention.AI_INTENTION_IDLE) ) //move at random.
                {
                    double radius, angle;
                    if (Rnd.get(4) == 0)
                        _Zone.broadcastPacket(new SocialAction(npc.getObjectId(), Rnd.get(1, 3)));
                    else if ((radius = Util.calculateDistance(npc.getX(), npc.getY(), npc.getZ(), 177915, 114941, -7707, true) - 2300) > 0)
                    {
                        _Zone.updateKnownList(npc);
                        radius += 100 + Rnd.get(500);
                        angle = Math.atan2(114941 - npc.getY(), 177915 - npc.getX());
                        int x = npc.getX() + (int)(radius * Math.cos(angle));
                        int y = npc.getY() + (int)(radius * Math.sin(angle));
                        npc.getAI().setIntention(CtrlIntention.AI_INTENTION_MOVE_TO, new L2CharPosition(x, y, -7707, 0));
                    }
                    else
                    {
                        _Zone.updateKnownList(npc);
                        radius = Rnd.get(2300);
                        angle = Rnd.get() * 6.283185307179586476925286766559D;
                        int x = 177915 + (int)(radius * Math.cos(angle));
                        int y = 114941 + (int)(radius * Math.sin(angle));
                        npc.getAI().setIntention(CtrlIntention.AI_INTENTION_MOVE_TO, new L2CharPosition(x, y, -7707, 0));
                    }
                }
            }
            else if (event == "antharas_has_arrived")
            {
               int dx = Math.abs(npc.getX() - 181911);
               int dy = Math.abs(npc.getY() - 114835);
               if (dx <= 50 && dy <= 50)
               {
                   this.cancelQuestTimer("antharas_has_arrived", npc, null);
                   this.startQuestTimer("camera_1",2000, npc, null);
                   npc.getSpawn().setLocx(181911);
                   npc.getSpawn().setLocy(114835);
                   npc.getSpawn().setLocz(-7678);
                   npc.getAI().setIntention(CtrlIntention.AI_INTENTION_IDLE);
               }
               else
               {
                   npc.getAI().setIntention(CtrlIntention.AI_INTENTION_MOVE_TO,new L2CharPosition(181911,114835,-7678,0));
               }
            }
			else if (event == "minion_spawn")
				spawnMinions(npc);
            else if (event == "spawn_cubes")
            {
                addSpawn(31859,177615,114941,-7709,0,false,900000);
                int radius = 1500;
                for (int i=0; i < /*JOJO*/19; i++)
                {
                    int x = (int) (radius*Math.cos(i*0.330693963)); //.331~2pi/19
                    int y = (int) (radius*Math.sin(i*0.330693963));
                    addSpawn(31859,177615+x,114941+y,-7709,0,false,900000);
                }
 //             this.cancelQuestTimer("antharas_despawn", npc, null);	//-[JOJO]
                this.startQuestTimer("remove_players",900000, null, null);
                this.screenMessage("");
                this.announce("15ȓɃA^X̐ދĂB");
            }
        }
        else
        {
            if (event == "antharas_unlock")
            {
                L2GrandBossInstance antharas = (L2GrandBossInstance) addSpawn(ANTHARAS,185708,114298,-8221,32768,false,0);
                GrandBossManager.getInstance().addBoss(antharas);
                GrandBossManager.getInstance().setBossStatus(ANTHARAS,DORMANT);
                _Zone.broadcastPacket(new Earthquake(185708,114298,-8221,20,10));
            }
            else if (event == "remove_players")
            {
                _Zone.oustAllPlayers();
            }
        }
        return super.onAdvEvent(event, npc, player);
	}

	public String onAttack (L2Npc npc, L2PcInstance attacker, int damage, boolean isPet)
	{	
        _LastAction = System.currentTimeMillis();
        if (GrandBossManager.getInstance().getBossStatus(ANTHARAS) != FIGHTING)
        {
            _Zone.oustAllPlayers();
        }
        return super.onAttack(npc, attacker, damage, isPet);
	}

    public String onKill (L2Npc npc, L2PcInstance killer, boolean isPet) 
    { 
        this.cancelQuestTimer("antharas_despawn", npc, null);
        _Zone.broadcastPacket(new PlaySound(1, "BS01_D", 1, npc.getObjectId(), npc.getX(), npc.getY(), npc.getZ()));
		despawnMinions();	//+[JOJO]
        this.startQuestTimer("spawn_cubes", 10000, npc, null);
        GrandBossManager.getInstance().setBossStatus(ANTHARAS,DEAD);
        long respawnTime = Config.FWA_FIXINTERVALOFANTHARAS + Rnd.get(Config.FWA_RANDOMINTERVALOFANTHARAS);	//[JOJO]
		long respawnDateTime = System.currentTimeMillis() + respawnTime;	//[JOJO]
        this.startQuestTimer("antharas_unlock", respawnTime, null, null);
        // also save the respawn time so that the info is maintained past reboots
        StatsSet info = GrandBossManager.getInstance().getStatsSet(ANTHARAS);
        info.set("respawn_time", respawnDateTime);	//[JOJO]
        GrandBossManager.getInstance().setStatsSet(ANTHARAS,info);
		Broadcast.announceToOnlinePlayers("nA^XS܂B̕ "+GrandBossManager.respawnTimeFormat(info)+" łB");	//[JOJO]
		giveItemParty(ANTHARAS_CIRCLET, killer, npc);	//+[JOJO]
        return super.onKill(npc,killer,isPet);
    }

	private synchronized void spawnMinions(L2Npc boss)
	{
		if (_minions != null) return;
		_minions = new L2Npc[6];
		
		for (int i = 0; i < 6; i++)
		{
			double angle = i * 1.0471975511965977461542144610932D + 0.5; // 2*Math.PI/6
			int x = 177915 + (int)(2000.0 * Math.cos(angle));
			int y = 114941 + (int)(2000.0 * Math.sin(angle));
			int npcId = i % 2 == 0 ? BEHEMOTH_DRAGON : DRAGON_BOMBER;
			_minions[i] = addSpawn(npcId, x, y, -7710, 0, false, 0);
		}
	}
	private void despawnMinions()
	{
		if (_minions == null) return;
		for (L2Npc mob : _minions)
			mob.deleteMe();
		_minions = null;
	}

	private void giveItemParty(int itemId, L2PcInstance player, L2Npc npc) //+[JOJO]
	{
		if (player != null)
		{
			for (L2PcInstance pc : this.getPartyMembers(player))
			{
				PcInventory inven = pc.getInventory();
				L2ItemInstance item;
				if ((item = inven.getItemByItemId(itemId)) == null || item.getCount() < 1)
				{
					pc.addItem("Quest", itemId, 1, npc, true);
					pc.broadcastPacket(new SystemMessage(SystemMessageId.ANNOUNCEMENT_C1_PICKED_UP_S2).addCharName(pc).addItemName(itemId));
				}
			}
		}
	}
	List<L2PcInstance> getPartyMembers(L2PcInstance player)	//[JOJO]
	{
		L2Party party;
		if ((party = player.getParty()) != null)
			return party.getPartyMembers();
		else
		{
			List<L2PcInstance> m = new ArrayList<L2PcInstance>(1);
			m.add(player);
			return m;
		}
	}

    private void screenMessage(String text) //+[JOJO]
    {
        _Zone.broadcastPacket(new ExShowScreenMessage(text,/*time=>*/10000));
    }
    private void announce(String text) //+[JOJO]
    {
        _Zone.broadcastPacket(new CreatureSay(0, 10, "", text));
    }

    public static void main(String[] args)
    {
    	// now call the constructor (starts up the ai)
    	new Antharas(-1,"antharas","ai");
    }
}