/*
 * This program is free software: you can redistribute it and/or modify it under
 * the terms of the GNU General Public License as published by the Free Software
 * Foundation, either version 3 of the License, or (at your option) any later
 * version.
 * 
 * This program is distributed in the hope that it will be useful, but WITHOUT
 * ANY WARRANTY; without even the implied warranty of MERCHANTABILITY or FITNESS
 * FOR A PARTICULAR PURPOSE. See the GNU General Public License for more
 * details.
 * 
 * You should have received a copy of the GNU General Public License along with
 * this program. If not, see <http://www.gnu.org/licenses/>.
 */
package handlers.admincommandhandlers;

import java.util.StringTokenizer;

import javolution.lang.MathLib;
import net.sf.l2j.Config;
import net.sf.l2j.gameserver.GmListTable;
import net.sf.l2j.gameserver.cache.HtmCache;
import net.sf.l2j.gameserver.datatables.AccessLevels;
import net.sf.l2j.gameserver.datatables.AdminCommandAccessRights;
import net.sf.l2j.gameserver.datatables.ItemTable;
import net.sf.l2j.gameserver.datatables.NpcTable;
import net.sf.l2j.gameserver.datatables.NpcWalkerRoutesTable;
import net.sf.l2j.gameserver.datatables.SkillTable;
import net.sf.l2j.gameserver.datatables.TeleportLocationTable;
import net.sf.l2j.gameserver.handler.IAdminCommandHandler;
import net.sf.l2j.gameserver.idfactory.IdFactory;
import net.sf.l2j.gameserver.instancemanager.Manager;
import net.sf.l2j.gameserver.instancemanager.QuestManager;
import net.sf.l2j.gameserver.model.L2ItemInstance;
import net.sf.l2j.gameserver.model.L2Multisell;
import net.sf.l2j.gameserver.model.L2Object;
import net.sf.l2j.gameserver.model.L2World;
import net.sf.l2j.gameserver.model.actor.instance.L2PcInstance;
import net.sf.l2j.gameserver.model.actor.instance.L2SummonInstance;
import net.sf.l2j.gameserver.model.base.Experience;
import net.sf.l2j.gameserver.model.olympiad.Olympiad;
import net.sf.l2j.gameserver.network.SystemMessageId;
import net.sf.l2j.gameserver.network.serverpackets.PetInfo;
import net.sf.l2j.gameserver.network.serverpackets.SocialAction;
import net.sf.l2j.gameserver.network.serverpackets.SystemMessage;
import net.sf.l2j.gameserver.templates.chars.L2NpcTemplate;

/**
 * This class handles following admin commands:
 * - admin|admin1/admin2/admin3/admin4/admin5 = slots for the 5 starting admin menus
 * - gmliston/gmlistoff = includes/excludes active character from /gmlist results
 * - silence = toggles private messages acceptance mode
 * - diet = toggles weight penalty mode
 * - tradeoff = toggles trade acceptance mode
 * - reload = reloads specified component from multisell|skill|npc|htm|item|instancemanager
 * - set/set_menu/set_mod = alters specified server setting
 * - saveolymp = saves olympiad state manually
 * - manualhero = cycles olympiad and calculate new heroes.
 * @version $Revision: 1.3.2.1.2.4 $ $Date: 2007/07/28 10:06:06 $
 */
public class AdminAdmin implements IAdminCommandHandler
{
	
	private static final String[] ADMIN_COMMANDS =
	{
		"admin_camera",			//[L2J_JP_ADD]
		"admin_summon",			//[L2J_JP_ADD]
		"admin_unsummon",		//[L2J_JP_ADD]
	//	"admin_bvb",			//[JOJO]
		"admin_item_circle",	//[JOJO]
		"admin_/",				//[JOJO]
		"admin_admin",
		"admin_admin1",
		"admin_admin2",
		"admin_admin3",
		"admin_admin4",
		"admin_admin5",
		"admin_gmliston",
		"admin_gmlistoff",
		"admin_silence",
		"admin_diet",
		"admin_tradeoff",
		"admin_reload",
		"admin_set",
		"admin_set_menu",
		"admin_set_mod",
		"admin_saveolymp",
		"admin_manualhero",
		"admin_sethero",
		"admin_endolympiad"
	};
	
	public boolean useAdminCommand(String command, L2PcInstance activeChar)
	{
		
		if (command.startsWith("admin_admin"))
		{
			showMainPage(activeChar, command);
		}
		else if (command.startsWith("admin_gmliston"))
		{
			GmListTable.getInstance().showGm(activeChar);
			activeChar.sendMessage("Registered into gm list");
		}
		else if (command.startsWith("admin_gmlistoff"))
		{
			GmListTable.getInstance().hideGm(activeChar);
			activeChar.sendMessage("Removed from gm list");
		}
		else if (command.startsWith("admin_silence"))
		{
			if (activeChar.getMessageRefusal()) // already in message refusal mode
			{
				activeChar.setMessageRefusal(false);
				activeChar.sendPacket(new SystemMessage(SystemMessageId.MESSAGE_ACCEPTANCE_MODE));
			}
			else
			{
				activeChar.setMessageRefusal(true);
				activeChar.sendPacket(new SystemMessage(SystemMessageId.MESSAGE_REFUSAL_MODE));
			}
		}
		else if (command.startsWith("admin_saveolymp"))
		{
			Olympiad.getInstance().saveOlympiadStatus();
			activeChar.sendMessage("olympiad system saved.");
		}
		else if (command.startsWith("admin_endolympiad"))
		{
			try
			{
				Olympiad.getInstance().manualSelectHeroes();
			}
			catch (Exception e)
			{
				e.printStackTrace();
			}
			activeChar.sendMessage("Heroes formed");
		}
		else if (command.startsWith("admin_manualhero") || command.startsWith("admin_sethero"))
		{
			L2PcInstance target = null;
			
			if (activeChar.getTarget() instanceof L2PcInstance)
			{
				target = (L2PcInstance) activeChar.getTarget();
				target.setHero(target.isHero() ? false : true);
			}
			else
			{
				target = activeChar;
				target.setHero(target.isHero() ? false : true);
			}
			target.broadcastUserInfo();
		}
		else if (command.startsWith("admin_diet"))
		{
			try
			{
				StringTokenizer st = new StringTokenizer(command);
				st.nextToken();
				if (st.nextToken().equalsIgnoreCase("on"))
				{
					activeChar.setDietMode(true);
					activeChar.sendMessage("Diet mode on");
				}
				else if (st.nextToken().equalsIgnoreCase("off"))
				{
					activeChar.setDietMode(false);
					activeChar.sendMessage("Diet mode off");
				}
			}
			catch (Exception ex)
			{
				if (activeChar.getDietMode())
				{
					activeChar.setDietMode(false);
					activeChar.sendMessage("Diet mode off");
				}
				else
				{
					activeChar.setDietMode(true);
					activeChar.sendMessage("Diet mode on");
				}
			}
			finally
			{
				activeChar.refreshOverloaded();
			}
		}
		else if (command.startsWith("admin_tradeoff"))
		{
			try
			{
				String mode = command.substring(15);
				if (mode.equalsIgnoreCase("on"))
				{
					activeChar.setTradeRefusal(true);
					activeChar.sendMessage("Trade refusal enabled");
				}
				else if (mode.equalsIgnoreCase("off"))
				{
					activeChar.setTradeRefusal(false);
					activeChar.sendMessage("Trade refusal disabled");
				}
			}
			catch (Exception ex)
			{
				if (activeChar.getTradeRefusal())
				{
					activeChar.setTradeRefusal(false);
					activeChar.sendMessage("Trade refusal disabled");
				}
				else
				{
					activeChar.setTradeRefusal(true);
					activeChar.sendMessage("Trade refusal enabled");
				}
			}
		}
		else if (command.startsWith("admin_reload"))
		{
			StringTokenizer st = new StringTokenizer(command);
			st.nextToken();
			try
			{
				String type = st.nextToken();
				if (type.equals("multisell"))
				{
					L2Multisell.getInstance().reload();
					activeChar.sendMessage("multisell reloaded");
				}
				else if (type.startsWith("teleport"))
				{
					TeleportLocationTable.getInstance().reloadAll();
					activeChar.sendMessage("teleport location table reloaded");
				}
				else if (type.startsWith("skill"))
				{
					SkillTable.getInstance().reload();
					activeChar.sendMessage("skills reloaded");
				}
				else if (type.equals("npc"))
				{
					NpcTable.getInstance().reloadAllNpc();
					QuestManager.getInstance().reloadAllQuests();
					activeChar.sendMessage("npcs reloaded");
				}
				else if (type.startsWith("htm"))
				{
					HtmCache.getInstance().reload();
					activeChar.sendMessage("Cache[HTML]: " + HtmCache.getInstance().getMemoryUsage() + " megabytes on " + HtmCache.getInstance().getLoadedFiles() + " files loaded");
				}
				else if (type.startsWith("item"))
				{
					ItemTable.getInstance().reload();
					activeChar.sendMessage("Item templates reloaded");
				}
				else if (type.startsWith("config"))
				{
					Config.load();
					activeChar.sendMessage("All config settings have been reload");
				}
				else if (type.startsWith("instancemanager"))
				{
					Manager.reloadAll();
					activeChar.sendMessage("All instance manager has been reloaded");
				}
				else if (type.startsWith("npcwalkers"))
				{
					NpcWalkerRoutesTable.getInstance().load();
					activeChar.sendMessage("All NPC walker routes have been reloaded");
				}
				else if (type.startsWith("access"))
				{
					AccessLevels.getInstance().reloadAccessLevels();
					AdminCommandAccessRights.getInstance().reloadAdminCommandAccessRights();
					activeChar.sendMessage("Access Rights have been reloaded");
				}
//-				else if (type.startsWith("config"))	// [L2J_JP ADD]
//-				{
//-					Config.load();
//-					activeChar.sendMessage("All GameServer Config have been reloaded");
//-				}
				else if (type.startsWith("quests"))
				{
					QuestManager.getInstance().reloadAllQuests();
					activeChar.sendMessage("All Quests have been reloaded");
				}
				
			}
			catch (Exception e)
			{
				activeChar.sendMessage("Usage:  //reload <multisell|skill|npc|htm|item|instancemanager>");
			}
		}
		
		else if (command.startsWith("admin_set"))
		{
			StringTokenizer st = new StringTokenizer(command);
			String[] cmd = st.nextToken().split("_");
			try
			{
				String[] parameter = st.nextToken().split("=");
				String pName = parameter[0].trim();
				String pValue = parameter[1].trim();
				if (Config.setParameterValue(pName, pValue))
					activeChar.sendMessage("parameter " + pName + " succesfully set to " + pValue);
				else
					activeChar.sendMessage("Invalid parameter!");
			}
			catch (Exception e)
			{
				if (cmd.length == 2)
					activeChar.sendMessage("Usage: //set parameter=value");
			}
			finally
			{
				if (cmd.length == 3)
				{
					if (cmd[2].equalsIgnoreCase("menu"))
						AdminHelpPage.showHelpPage(activeChar, "settings.htm");
					else if (cmd[2].equalsIgnoreCase("mod"))
						AdminHelpPage.showHelpPage(activeChar, "mods_menu.htm");
				}
			}
		}
		
		// [L2J_JP_ADD SANDMAN] GMpJړeXg
		else if (command.startsWith("admin_camera"))
		{
			if (activeChar.getTarget() == null)
			{
				activeChar.sendMessage("Target incorrect.");
				activeChar.sendMessage("Usage:  //camera dist yaw pitch time duration [social]");
			}
			else
			{
				StringTokenizer st = new StringTokenizer(command);
				st.nextToken();
				
				L2Object target = null;	//[JOJO]
				try
				{
					/*L2Object */target = activeChar.getTarget();
					int scDist = Integer.parseInt(st.nextToken());
					int scYaw = Integer.parseInt(st.nextToken());
					int scPitch = Integer.parseInt(st.nextToken());
					int scTime = Integer.parseInt(st.nextToken());
					int scDuration = Integer.parseInt(st.nextToken());
					int social = 0; if (st.hasMoreTokens()) social = Integer.parseInt(st.nextToken());	//[JOJO]
					activeChar.sendMessage("camera " + scDist + " " + scYaw + " " + scPitch + " " + scTime + " " + scDuration + " " + social);
					activeChar.enterMovieMode();
					activeChar.specialCamera(target, scDist, scYaw, scPitch, scTime, scDuration);
					if (social > 0)
						activeChar.sendPacket(new SocialAction(target.getObjectId(), social));	//[JOJO]
				}
				catch (Exception e)
				{
					activeChar.sendMessage("Usage:  //camera dist yaw pitch time duration [social]");
				}
				finally
				{
					activeChar.leaveMovieMode();
					activeChar.setTarget(target);	//[JOJO]
				}
				
			}
			
		}
		
		// [L2J_JP_ADD] GMpT
		else if (command.startsWith("admin_summon"))
		{
			StringTokenizer st = new StringTokenizer(command);
			st.nextToken();
			try
			{
				// NPCID̐؂o
				int npcId = Integer.parseInt(st.nextToken());
				if (npcId != 0)
					adminSummon(activeChar, npcId);
			}
			catch (Exception e)
			{
				// NPCID͂ĂȂꍇ̎g\
				activeChar.sendMessage("Usage:  //summon npcid");
			}
		}
		// [L2J_JP_ADD] GMpT()
		else if (command.startsWith("admin_unsummon"))
		{
			// T΁A
			if (activeChar.getPet() != null)
				activeChar.getPet().unSummon(activeChar);
		}
	//	// [L2J_JP ADD] Boss vs Boss
	//	else if (command.startsWith("admin_bvb"))
	//	{
	//		StringTokenizer st = new StringTokenizer(command);
	//		st.nextToken();
	//		try
	//		{
	//			String cmd = st.nextToken();
	//			if (cmd.equalsIgnoreCase("start"))
	//			{
	//				BvBManager.getInstance().start();
	//			}
	//			else if (cmd.equalsIgnoreCase("end"))
	//			{
	//				BvBManager.getInstance().end();
	//			}
	//			else
	//			{
	//				throw new java.util.NoSuchElementException();
	//			}
	//		}
	//		catch (java.util.NoSuchElementException e)
	//		{
	//			activeChar.sendMessage("Usage://bvb start or //bvb end");
	//		}
	//	}
		else if (command.startsWith("admin_item_circle"))	//[JOJO] VсFAfiŒnʂɁ`
		{
			StringTokenizer st = new StringTokenizer(command);
			st.nextToken();
			try {
				int x0 = activeChar.getX();
				int y0 = activeChar.getY();
				int z0 = activeChar.getZ();
				double radius = Integer.parseInt(st.nextToken());
				double count = 0;
				int itemId = 57;
				if (st.hasMoreTokens()) count = Integer.parseInt(st.nextToken());
				if (st.hasMoreTokens()) itemId = Integer.parseInt(st.nextToken());
				int limit = (int)Math.round(MathLib.TWO_PI / 10 * radius);
				if (limit < 8) limit = 8;
				if (limit > 300) limit = 300;
				if (count == 0)
					count = limit;
				else if (count > limit)
				{
					count = limit;
					activeChar.sendMessage("Warning: too many count");
				}
				
				double alpha = MathLib.TWO_PI / count;
				while (--count >= 0)
				{
					double angle = alpha * count;
					int x = x0 + (int) Math.round(Math.cos(angle) * radius);
					int y = y0 + (int) Math.round(Math.sin(angle) * radius);
					int z = z0;
					L2ItemInstance item = new L2ItemInstance(IdFactory.getInstance().getNextId(), itemId);
					item.setOwnerId(activeChar.getObjectId());
					item.new doItemDropTask(item, activeChar, x, y, z).run();
					item.setProtected(false);
					L2World.getInstance().storeObject(item);
				}
			}
			catch (Exception e)
			{
				activeChar.sendMessage("Usage://item_circle radius [count] [item]");
			}
		}
		else if (command.startsWith("admin_/"))
		{
			HtmCache.getInstance().reload();
//			AdminHelpPage.showHelpPage(activeChar, "tele/j/raid_60.htm");
		}

		return true;
	}
	
	public String[] getAdminCommandList()
	{
		return ADMIN_COMMANDS;
	}
	
	private void showMainPage(L2PcInstance activeChar, String command)
	{
		int mode = 0;
		String filename = null;
		try
		{
			mode = Integer.parseInt(command.substring(11));
		}
		catch (Exception e)
		{
		}
		switch (mode)
		{
			case 1:
				filename = "main";
				break;
			case 2:
				filename = "game";
				break;
			case 3:
				filename = "effects";
				break;
			case 4:
				filename = "server";
				break;
			case 5:
				filename = "mods";
				break;
			default:
				if (Config.GM_ADMIN_MENU_STYLE.equals("modern"))
					filename = "main";
				else
					filename = "classic";
				break;
		}
		AdminHelpPage.showHelpPage(activeChar, filename + "_menu.htm");
	}

	// [L2J_JP_ADD] GMTs\bh
	public void adminSummon(L2PcInstance activeChar, int npcId)
	{
		// Ƀybgꍇ̓ybg߂B
        if (activeChar.getPet() != null)
		{
			SystemMessage sm = new SystemMessage(SystemMessageId.YOU_ALREADY_HAVE_A_PET);
			activeChar.sendPacket(sm);
			activeChar.getPet().unSummon(activeChar);
		}
        
        // ͂ǂ(L2SkillSummon.java)̏ێʂłB
        L2NpcTemplate summonTemplate = NpcTable.getInstance().getTemplate(npcId);
		L2SummonInstance summon = new L2SummonInstance(IdFactory.getInstance().getNextId(), summonTemplate, activeChar, null);
		
        summon.setTitle(activeChar.getName());
		summon.setExpPenalty(0);
		if (summon.getLevel() >= Experience.LEVEL.length)
		{
			summon.getStat().setExp(Experience.LEVEL[Experience.LEVEL.length - 1]);
		}
		else
		{
			summon.getStat().setExp(Experience.LEVEL[(summon.getLevel() % Experience.LEVEL.length)]);
		}
        summon.getStat().setExp(0);
		summon.setCurrentHp(summon.getMaxHp());
		summon.setCurrentMp(summon.getMaxMp());
		summon.setHeading(activeChar.getHeading());
		summon.setRunning();
		activeChar.setPet(summon);
		
        L2World.getInstance().storeObject(summon);
		summon.spawnMe(activeChar.getX() + 50, activeChar.getY() + 100, activeChar.getZ());
		
		summon.setFollowStatus(true);
		summon.setShowSummonAnimation(false);	// addVisibleObject created the info packets with summon animation
												// if someone comes into range now, the animation shouldnt show any more
		activeChar.sendPacket(new PetInfo(summon, /*TODO:Check!*/0));
    }
}
