/*
 * This program is free software: you can redistribute it and/or modify it under
 * the terms of the GNU General Public License as published by the Free Software
 * Foundation, either version 3 of the License, or (at your option) any later
 * version.
 * 
 * This program is distributed in the hope that it will be useful, but WITHOUT
 * ANY WARRANTY; without even the implied warranty of MERCHANTABILITY or FITNESS
 * FOR A PARTICULAR PURPOSE. See the GNU General Public License for more
 * details.
 * 
 * You should have received a copy of the GNU General Public License along with
 * this program. If not, see <http://www.gnu.org/licenses/>.
 */
package handlers.admincommandhandlers;

import net.sf.l2j.gameserver.handler.IAdminCommandHandler;
import net.sf.l2j.gameserver.instancemanager.TransformationManager;
import net.sf.l2j.gameserver.model.actor.instance.L2PcInstance;
import net.sf.l2j.gameserver.network.SystemMessageId;
import net.sf.l2j.gameserver.network.serverpackets.SystemMessage;

/**
 * @author 
 */
public class AdminRide implements IAdminCommandHandler
{
	private static final String[] ADMIN_COMMANDS =
	{
		"admin_ride_horse",
		"admin_ride_lion",		//+[JOJO]
		"admin_ride_beatle",	//+[JOJO]
		"admin_ride_wyvern",
		"admin_ride_strider",
		"admin_unride_wyvern",
		"admin_unride_strider",
		"admin_unride",
		"admin_ride_wolf",
		"admin_unride_wolf",
	};
	private int _petRideId;
	
	public static final int PURPLE_MANED_HORSE_TRANSFORMATION_ID = 106;	// LightPurpleManedHorse.java
	public static final int TAWNY_MANED_LION_TRANSFORMATION_ID = 109;		// TawnyManedLion.java	//+[JOJO]
	public static final int STEAM_BEATLE_TRANSFORMATION_ID = 110;		// SteamBeatle.java			//+[JOJO]
	
	public boolean useAdminCommand(String command, L2PcInstance activeChar)
	{
		
		int id = 0;
		if (command.startsWith("admin_ride"))
		{
			if (activeChar.isMounted() || activeChar.getPet() != null)
			{
				activeChar.sendMessage("You already have a pet.");
				return false;
			}
			if (command.startsWith("admin_ride_wyvern"))
			{
				_petRideId = 12621;
			}
			else if (command.startsWith("admin_ride_strider"))
			{
				_petRideId = 12526;
			}
			else if (command.startsWith("admin_ride_wolf"))
			{
				_petRideId = 16041;
			}
			else if (command.startsWith("admin_ride_horse") && (id = PURPLE_MANED_HORSE_TRANSFORMATION_ID) != 0 // handled using transformation
				  || command.startsWith("admin_ride_lion")   && (id = TAWNY_MANED_LION_TRANSFORMATION_ID) != 0	//+[JOJO]
				  || command.startsWith("admin_ride_beatle") && (id = STEAM_BEATLE_TRANSFORMATION_ID) != 0)	//+[JOJO]
			{
				if (activeChar.isTransformed() || activeChar.isInStance())
					activeChar.sendPacket(new SystemMessage(SystemMessageId.YOU_CANNOT_MOUNT_A_STEED_WHILE_TRANSFORMED));
				else
					TransformationManager.getInstance().transformPlayer(id, activeChar);
				
				return true;
			}
			else
			{
				activeChar.sendMessage("Command '" + command + "' not recognized");
				return false;
			}
			
			activeChar.mount(_petRideId, 0, false);
			
			return false;
		}
		else if (command.startsWith("admin_unride"))
		{
			if ((id = activeChar.getTransformationId()) == PURPLE_MANED_HORSE_TRANSFORMATION_ID
			  || id                                     == TAWNY_MANED_LION_TRANSFORMATION_ID	//+[JOJO]
			  || id                                     == STEAM_BEATLE_TRANSFORMATION_ID)		//+[JOJO]
				activeChar.untransform();
			else
				activeChar.dismount();
		}
		return true;
	}
	
	public String[] getAdminCommandList()
	{
		return ADMIN_COMMANDS;
	}
	
}
