/*
 * $Header: AdminTest.java, 25/07/2005 17:15:21 luisantonioa Exp $
 *
 * $Author: luisantonioa $
 * $Date: 25/07/2005 17:15:21 $
 * $Revision: 1 $
 * $Log: AdminTest.java,v $
 * Revision 1  25/07/2005 17:15:21  luisantonioa
 * Added copyright notice
 *
 *
* This program is free software: you can redistribute it and/or modify it under
 * the terms of the GNU General Public License as published by the Free Software
 * Foundation, either version 3 of the License, or (at your option) any later
 * version.
 * 
 * This program is distributed in the hope that it will be useful, but WITHOUT
 * ANY WARRANTY; without even the implied warranty of MERCHANTABILITY or FITNESS
 * FOR A PARTICULAR PURPOSE. See the GNU General Public License for more
 * details.
 * 
 * You should have received a copy of the GNU General Public License along with
 * this program. If not, see <http://www.gnu.org/licenses/>.
 */
package handlers.admincommandhandlers;

import java.util.StringTokenizer;

import net.sf.l2j.gameserver.datatables.MapRegionTable;
import net.sf.l2j.gameserver.handler.IAdminCommandHandler;
import net.sf.l2j.gameserver.instancemanager.CustomZoneManager;
import net.sf.l2j.gameserver.instancemanager.ZoneManager;
import net.sf.l2j.gameserver.model.L2World;
import net.sf.l2j.gameserver.model.Location;
import net.sf.l2j.gameserver.model.actor.L2Character;
import net.sf.l2j.gameserver.model.actor.instance.L2PcInstance;
import net.sf.l2j.gameserver.model.zone.L2ZoneType;
import net.sf.l2j.gameserver.model.zone.type.L2ArenaZone;
import net.sf.l2j.gameserver.model.zone.type.L2BossZone;
import net.sf.l2j.gameserver.model.zone.type.L2TownZone;
import net.sf.l2j.gameserver.network.SystemMessageId;
import net.sf.l2j.gameserver.network.serverpackets.SystemMessage;

public class AdminZone implements IAdminCommandHandler
{
	private static final String[] ADMIN_COMMANDS =
	{
		"admin_zone_check",
		"admin_zone_reload"
	};
	
	/**
	 * 
	 * @see net.sf.l2j.gameserver.handler.IAdminCommandHandler#useAdminCommand(java.lang.String, net.sf.l2j.gameserver.model.actor.instance.L2PcInstance)
	 */
	@SuppressWarnings("deprecation")
    public boolean useAdminCommand(String command, L2PcInstance activeChar)
	{
		if (activeChar == null)
			return false;
		
		StringTokenizer st = new StringTokenizer(command, " ");
		String actualCommand = st.nextToken(); // Get actual command
		
		//String val = "";
		//if (st.countTokens() >= 1) {val = st.nextToken();}
		
		if (actualCommand.equalsIgnoreCase("admin_zone_check"))
		{
			// [L2J_JP ADD SANDMAN START][JOJO]
			activeChar.sendPacket(new SystemMessage(SystemMessageId.S2_S1)
				.addZoneName(activeChar.getX(), activeChar.getY(), activeChar.getZ())
				.addString("݈ʒuF") );
			for (L2ZoneType z : ZoneManager.getInstance().getAllZones())	//[JOJO]
				if (z.isInsideZone(activeChar)) {
					StringBuilder sb = new StringBuilder("Type: ").append(z.getClass().getSimpleName()).append(' ').append(z.getId());
					if (z instanceof L2ArenaZone)
						sb.append(' ').append('\'').append(((L2ArenaZone)z).getName()).append('\'');
					else if (z instanceof L2TownZone)
						sb.append(' ').append('\'').append(((L2TownZone)z).getName()).append('\'');
					else if (z instanceof L2BossZone)
						sb.append(' ').append('\'').append(((L2BossZone)z).getZoneName()).append('\'');
					activeChar.sendMessage(sb.toString());
				}
			if (CustomZoneManager.getInstance().isInsideSunlightRoomZone(activeChar))
				activeChar.sendMessage("This is a SunlightRoom zone.");
			// [L2J_JP ADD SANDMAN END]

			if (activeChar.isInsideZone(L2Character.ZONE_PVP))
				activeChar.sendMessage("This is a PvP zone.");
			else
				activeChar.sendMessage("This is NOT a PvP zone.");
			
			if (activeChar.isInsideZone(L2Character.ZONE_NOLANDING))
				activeChar.sendMessage("This is a no landing zone.");
			else
				activeChar.sendMessage("This is NOT a no landing zone.");
			
			if (activeChar.isInsideZone(L2Character.ZONE_PEACE))
				activeChar.sendMessage("This is a peaceful zone.");
			else
				activeChar.sendMessage("This is NOT a peaceful zone.");
			
			activeChar.sendMessage("WorldRegion: " + L2World.getInstance().getRegion(activeChar.getX(), activeChar.getY()).getName());	//[JOJO]
			
			activeChar.sendMessage("MapRegion: x:" + MapRegionTable.getInstance().getMapRegionX(activeChar.getX()) + " y:" + MapRegionTable.getInstance().getMapRegionX(activeChar.getY()));
			
			activeChar.sendMessage("Closest Town: " + MapRegionTable.getInstance().getClosestTownName(activeChar));
			
			Location loc;
			
			loc = MapRegionTable.getInstance().getTeleToLocation(activeChar, MapRegionTable.TeleportWhereType.Castle);
			activeChar.sendMessage("TeleToLocation (Castle): x:" + loc.getX() + " y:" + loc.getY() + " z:" + loc.getZ());
			
			loc = MapRegionTable.getInstance().getTeleToLocation(activeChar, MapRegionTable.TeleportWhereType.ClanHall);
			activeChar.sendMessage("TeleToLocation (ClanHall): x:" + loc.getX() + " y:" + loc.getY() + " z:" + loc.getZ());
			
			loc = MapRegionTable.getInstance().getTeleToLocation(activeChar, MapRegionTable.TeleportWhereType.SiegeFlag);
			activeChar.sendMessage("TeleToLocation (SiegeFlag): x:" + loc.getX() + " y:" + loc.getY() + " z:" + loc.getZ());
			
			loc = MapRegionTable.getInstance().getTeleToLocation(activeChar, MapRegionTable.TeleportWhereType.Town);
			activeChar.sendMessage("TeleToLocation (Town): x:" + loc.getX() + " y:" + loc.getY() + " z:" + loc.getZ());
		}
		else if (actualCommand.equalsIgnoreCase("admin_zone_reload"))
		{
			ZoneManager.getInstance().reload();
			activeChar.sendMessage("Reloading zones...");
		}
		return true;
	}
	
	/**
	 * 
	 * @see net.sf.l2j.gameserver.handler.IAdminCommandHandler#getAdminCommandList()
	 */
	public String[] getAdminCommandList()
	{
		return ADMIN_COMMANDS;
	}
	
}
