/*
 * This program is free software: you can redistribute it and/or modify it under
 * the terms of the GNU General Public License as published by the Free Software
 * Foundation, either version 3 of the License, or (at your option) any later
 * version.
 * 
 * This program is distributed in the hope that it will be useful, but WITHOUT
 * ANY WARRANTY; without even the implied warranty of MERCHANTABILITY or FITNESS
 * FOR A PARTICULAR PURPOSE. See the GNU General Public License for more
 * details.
 * 
 * You should have received a copy of the GNU General Public License along with
 * this program. If not, see <http://www.gnu.org/licenses/>.
 */
package instances.Kamaloka;

// Kamaloka Script by Psychokiller1888
// Psycho / L2jFree
// [JOJO] L2JFREE q
//   http://svn.l2jfree.com/svn/l2j-free/trunk/l2jfree-datapack/data/scripts/instances/Kamaloka/__init__.py
//   r7019	timestamp 2009/09/06 21:55:45
// [JOJO] python -> java

import gnu.trove.TIntHashSet;

import java.util.Arrays;

import javolution.util.FastMap;
import javolution.util.FastSet;
import net.sf.l2j.gameserver.instancemanager.InstanceManager;
import net.sf.l2j.gameserver.instancemanager.InstanceManager.InstanceWorld;
import net.sf.l2j.gameserver.model.L2Party;
import net.sf.l2j.gameserver.model.L2Skill;
import net.sf.l2j.gameserver.model.L2Spawn;
import net.sf.l2j.gameserver.model.L2World;
import net.sf.l2j.gameserver.model.actor.L2Npc;
import net.sf.l2j.gameserver.model.actor.L2Summon;
import net.sf.l2j.gameserver.model.actor.instance.L2MinionInstance;
import net.sf.l2j.gameserver.model.actor.instance.L2MonsterInstance;
import net.sf.l2j.gameserver.model.actor.instance.L2PcInstance;
import net.sf.l2j.gameserver.model.entity.Instance;
import net.sf.l2j.gameserver.model.quest.Quest;
import net.sf.l2j.gameserver.model.quest.QuestState;
import net.sf.l2j.gameserver.network.SystemMessageId;
import net.sf.l2j.gameserver.network.serverpackets.SystemMessage;
import net.sf.l2j.gameserver.util.Util;
import net.sf.l2j.util.Rnd;

public class Kamaloka extends Quest
{
	static final boolean DEBUG = true;
	static final boolean TEST = true;

	static final String qn = "Kamaloka";

	//NPC
	static final int BATHIS    = 30332;	//Gludio
	static final int LUCAS     = 30071;	//Dion
	static final int GOSTA     = 30916;	//Heine
	static final int MOUEN     = 30196;	//Oren
	static final int VISHOTSKY = 31981;	//Schuttgart
	static final int MATHIAS   = 31340;	//Rune

	static final int MAX_DISTANCE = 500;

	static final int[] GUARDS = {BATHIS, LUCAS, GOSTA, MOUEN, VISHOTSKY, MATHIAS};
	static final int[] BOSSES = {18554,18555,18558,18559,18562,18564,18566,18568,18571,18573,18577,29129,29132,29135,29138,29141,29144,29147};
	static final int[] MOBS = {22485,22486,22487,22488,22489,22490,22491,22492,22493,22494,22495,22496,22497,22498,22499,22500,22501,22502,22503,22504,22505,25616,25617,25618,25619,25620,25621,25622};

	//KAMALOKA = LEVEL: [FILE, Reuse Delay, Boss, LvlMin, LvlMax, MaxPlayer, X, Y, Z, Usable]
	private class KamalokaInfo
	{
		final String templateName;
		final int templateId;
		final long timeDelay;
		final int bossId;
		final int levelMin, levelMax, maxPlayer, x, y, z;
		final boolean enable;

		KamalokaInfo(String templateName, int templateId, int timeDelay
			, int bossId
			, int levelMin, int levelMax, int maxPlayer, int x, int y, int z
			, boolean enable)
		{
			this.templateName = templateName;
			this.templateId = templateId;
			this.timeDelay = timeDelay;
			this.bossId = bossId;
			this.levelMin = levelMin;
			this.levelMax = levelMax;
			this.maxPlayer = maxPlayer;
			this.x = x;
			this.y = y;
			this.z = z;
			this.enable = enable;
		}
	}
	final FastMap<Integer, KamalokaInfo> KAMALOKA;

	final FastMap<Integer, int[][]> LABYRINTHMOBS;

	private Kamaloka(int questId, String name, String descr)
	{
		super(questId, name, descr);

//		Arrays.sort(GUARDS);
		Arrays.sort(BOSSES);
//		Arrays.sort(MOBS);

		KAMALOKA = new FastMap<Integer, KamalokaInfo>();

		KAMALOKA.put(23, new KamalokaInfo("Kamaloka-23.xml",57,86400000,18554,18,28,6,-57109,-219871,-8117, true));
		KAMALOKA.put(26, new KamalokaInfo("Kamaloka-26.xml",58,86400000,18555,21,31,6,-55556,-206144,-8117, true));
		KAMALOKA.put(29, new KamalokaInfo("Kamaloka-29.xml",73,86400000,29129,24,34,9,-10864,-174897,-10947, true));
		KAMALOKA.put(33, new KamalokaInfo("Kamaloka-33.xml",60,86400000,18558,28,38,6,-55492,-206143,-8117, true));
		KAMALOKA.put(36, new KamalokaInfo("Kamaloka-36.xml",61,86400000,18559,31,41,6,-41257,-213143,-8117, true));
		KAMALOKA.put(39, new KamalokaInfo("Kamaloka-39.xml",74,86400000,29132,34,44,9,-10864,-174897,-10947, true));
		KAMALOKA.put(43, new KamalokaInfo("Kamaloka-43.xml",63,86400000,18562,38,48,6,-49802,-206141,-8117, true));
		KAMALOKA.put(46, new KamalokaInfo("Kamaloka-46.xml",64,86400000,18564,41,51,6,-41184,-213144,-8117, true));
		KAMALOKA.put(49, new KamalokaInfo("Kamaloka-49.xml",75,86400000,29135,44,54,9,-10864,-174897,-10947, true));
		KAMALOKA.put(53, new KamalokaInfo("Kamaloka-53.xml",66,86400000,18566,48,58,6,-41201,-219859,-8117, true));
		KAMALOKA.put(56, new KamalokaInfo("Kamaloka-56.xml",67,86400000,18568,51,61,6,-57102,-206143,-8117, true));
		KAMALOKA.put(59, new KamalokaInfo("Kamaloka-59.xml",76,86400000,29138,54,64,9,-10864,-174897,-10947, true));
		KAMALOKA.put(63, new KamalokaInfo("Kamaloka-63.xml",69,86400000,18571,58,68,6,-57116,-219857,-8117, true));
		KAMALOKA.put(66, new KamalokaInfo("Kamaloka-66.xml",70,86400000,18573,61,71,6,-41228,-219860,-8117, true));
		KAMALOKA.put(69, new KamalokaInfo("Kamaloka-69.xml",77,86400000,29141,64,74,9,-10864,-174897,-10947, true));
		KAMALOKA.put(73, new KamalokaInfo("Kamaloka-73.xml",72,86400000,18577,68,78,6,-55823,-212935,-8071, true));
		KAMALOKA.put(78, new KamalokaInfo("Kamaloka-78.xml",78,86400000,29144,73,85,9,-10864,-174897,-10947, true));
		KAMALOKA.put(81, new KamalokaInfo("Kamaloka-81.xml",79,86400000,29147,76,86,9,-10864,-174897,-10947, true));

		LABYRINTHMOBS = new FastMap<Integer, int[][]>();

		//LABYRINTHMOBS = LEVEL: [[],[ROOM1],[ROOM2],[ROOM3],[ROOM4]]
		LABYRINTHMOBS.put(29, new int[][]{null,{22485,1,22486,8},{22487,5},{25616,1},{29129,1/*,29130,2,29131,2*/}});
		LABYRINTHMOBS.put(39, new int[][]{null,{22488,1,22489,8},{22490,5},{25617,1},{29132,1/*,29133,2,29134,2*/}});
		LABYRINTHMOBS.put(49, new int[][]{null,{22491,1,22492,8},{22493,5},{25618,1},{29135,1/*,29136,2,29137,2*/}});
		LABYRINTHMOBS.put(59, new int[][]{null,{22494,1,22495,8},{22496,5},{25619,1},{29138,1/*,29139,2,29140,2*/}});
		LABYRINTHMOBS.put(69, new int[][]{null,{22497,1,22498,8},{22499,5},{25620,1},{29141,1/*,29142,2,29143,2*/}});
		LABYRINTHMOBS.put(78, new int[][]{null,{22500,1,22501,8},{22502,5},{25621,1},{29144,1/*,29145,2,29146,2*/}});
		LABYRINTHMOBS.put(81, new int[][]{null,{22503,1,22504,8},{22505,5},{25622,1},{29147,1/*,29148,2,29149,2*/}});

		for (int npc : GUARDS)
		{
			addStartNpc(npc);
			addTalkId(npc);
		}
		for (int boss : BOSSES)
			addKillId(boss);
		for (int mob : MOBS)
			addKillId(mob);
	}

	private class KamalokaWorld extends InstanceWorld
	{
		final int level;
		final KamalokaInfo kamaInfo;
		FastSet<L2Npc> room1, room2, room3, room4;
		KamalokaWorld(int instanceId, int level, KamalokaInfo kamaInfo)
		{
			InstanceManager.getInstance().super();
			this.instanceId = instanceId;
			this.templateId = kamaInfo.templateId;
			this.level = level;
			this.kamaInfo = kamaInfo;
		}
	}
	private KamalokaWorld getWorld(int instanceId)
	{
		InstanceWorld world = InstanceManager.getInstance().getWorld(instanceId);
		if (world != null && world instanceof KamalokaWorld)
			return (KamalokaWorld)world;
		return null;
	}

	private void spawnMobList(FastSet<L2Npc>room, int[] MOBLIST, int x, int y, int z, int h, int instanceId)
	{
		for (int i = 0; i < MOBLIST.length; i += 2)
		{
			int npcId = MOBLIST[i + 0];
			int amount = MOBLIST[i + 1];
			L2Npc monster;
			while (--amount >= 0)
			{
				int mx = x, my = y;
				if (room.size() > 0)
				{
					mx += Rnd.sign() * Rnd.get(100, 300);
					my += Rnd.sign() * Rnd.get(100, 300);
				}
				monster = addSpawn(npcId, mx, my, z, h, false, 0, false, instanceId);
				room.add(monster);
			}
		}
	}

	private void startFirstRoom(KamalokaWorld world)
	{
		world.status = 1;
		world.room1 = new FastSet<L2Npc>();
		spawnMobList(world.room1, LABYRINTHMOBS.get(world.level)[1], -12200, -174900, -10951, 0, world.instanceId);
	}

	private void startSecondRoom(KamalokaWorld world)
	{
		world.status = 2;
		world.room2 = new FastSet<L2Npc>();
		spawnMobList(world.room2, LABYRINTHMOBS.get(world.level)[2], -14540, -174900, -10688, 0, world.instanceId);
	}

	private void startThirdRoom(KamalokaWorld world)
	{
		world.status = 3;
		world.room3 = new FastSet<L2Npc>();
		spawnMobList(world.room3, LABYRINTHMOBS.get(world.level)[3], -16880, -174900, -10425, 0, world.instanceId);
	}

	private void startFourthRoom(KamalokaWorld world)
	{
		world.status = 4;
		world.room4 = new FastSet<L2Npc>();
		spawnMobList(world.room4, LABYRINTHMOBS.get(world.level)[4], -20650, -174900, -9981, 0, world.instanceId);
	}

	boolean checkKillProgress(L2Npc npc, FastSet<L2Npc> room)
	{
		synchronized (room)
		{
			room.remove(npc);
			return room.isEmpty();
		}
	}

	boolean checkCondition(L2PcInstance player, KamalokaInfo kamaInfo)
	{
		L2Party party = player.getParty();
		if (party == null)
		{
			player.sendPacket(new SystemMessage(SystemMessageId.NOT_IN_PARTY_CANT_ENTER));
			return false;
		}
		if (party.getLeader() != player)
		{
			party.broadcastToPartyMembers(new SystemMessage(SystemMessageId.ONLY_PARTY_LEADER_CAN_ENTER));
			return false;
		}
		// Check size of the party, max 6 for entering Kamaloka Hall of Abyss, 9 for Labyrinth
		if (party.getMemberCount() > kamaInfo.maxPlayer)
		{
			party.broadcastToPartyMembers(new SystemMessage(SystemMessageId.PARTY_EXCEEDED_THE_LIMIT_CANT_ENTER));
			return false;
		}
		for (L2PcInstance partyMember : party.getPartyMembers()/*.toArray()*/)
		{
			// Check for existing instances of party members
			if (partyMember.getInstanceId() != 0)
			{
				party.broadcastToPartyMembers(new SystemMessage(SystemMessageId.ALREADY_ENTERED_ANOTHER_INSTANCE_CANT_ENTER));
				return false;
			}
			if (partyMember.getLevel() < kamaInfo.levelMin || partyMember.getLevel() > kamaInfo.levelMax)
			{
				party.broadcastToPartyMembers(new SystemMessage(SystemMessageId.C1_LEVEL_REQUIREMENT_NOT_SUFFICIENT).addPcName(partyMember));
				return false;
			}
			if (!Util.checkIfInRange(MAX_DISTANCE, player, partyMember, true))
			{
				party.broadcastToPartyMembers(new SystemMessage(SystemMessageId.C1_IS_IN_LOCATION_THAT_CANNOT_BE_ENTERED).addPcName(partyMember));
				return false;
			}
			long reEnterTime = InstanceManager.getInstance().getInstanceTime(partyMember.getObjectId(), kamaInfo.templateId);
			if (System.currentTimeMillis() < reEnterTime)
			{
				party.broadcastToPartyMembers(new SystemMessage(SystemMessageId.C1_MAY_NOT_REENTER_YET).addPcName(partyMember));
				return false;
			}
		}
		return true;
	}

	private void clearBuffs(L2PcInstance player)
	{
		player.stopAllEffects();
		player.clearSouls();
		player.clearCharges();
	}

	void teleportplayer(L2PcInstance player, KamalokaInfo kamaInfo, int instanceId)
	{
		player.setInstanceId(instanceId);
		player.teleToLocation(kamaInfo.x, kamaInfo.y, kamaInfo.z);
		L2Summon pet;
		if ((pet = player.getPet()) != null)
		{
			pet.setInstanceId(instanceId);
			pet.teleToLocation(kamaInfo.x, kamaInfo.y, kamaInfo.z);
		}
	}

	int enterInstance(L2PcInstance player, KamalokaInfo kamaInfo, int level)
	{
		InstanceWorld world;
		//check for existing instances for this player
		if ((world = InstanceManager.getInstance().getPlayerWorld(player)) != null)
		{
			//existing instance
			if (world instanceof KamalokaWorld
					&& world.templateId == kamaInfo.templateId)
			{
				if (DEBUG) if (player.getInstanceId() != 0 && player.getInstanceId() != world.instanceId) throw new AssertionError();
				if (world.status < 0)
				{
					player.sendMessage("Ȃߍēł܂B");
					return 0;
				}
				player.sendMessage("ēꂵ܂B");
				int instanceId = world.instanceId;
				clearBuffs(player);
				teleportplayer(player, kamaInfo, instanceId);
				world.allowed.add(player.getObjectId());
				return instanceId;
			}
			player.sendPacket(new SystemMessage(SystemMessageId.ALREADY_ENTERED_ANOTHER_INSTANCE_CANT_ENTER));
			return 0;
		}

		if (! checkCondition(player, kamaInfo))
			return 0;

		// New instance
		int instanceId = InstanceManager.getInstance().createDynamicInstance(kamaInfo.templateName);
		if (DEBUG) if (getWorld(instanceId) != null) throw new AssertionError();
		world = new KamalokaWorld(instanceId, level, kamaInfo);
		InstanceManager.getInstance().addWorld(world);
		switch (level) {
		case 29: case 39: case 49: case 59: case 69: case 78: case 81:
			startFirstRoom((KamalokaWorld)world);
			break;
		default:
			/* kamaloka-**.xml <spawn ... /> */
			world.status = 4;
		}
		_log.info("Kamaloka: started " + kamaInfo.templateName + " Instance: " + instanceId + " created by player: " + player.getName());
		// Teleport players
		for (L2PcInstance partyMember : player.getParty().getPartyMembers()/*.toArray()*/)
		{
			clearBuffs(partyMember);
			teleportplayer(partyMember, kamaInfo, instanceId);
			world.allowed.add(partyMember.getObjectId());
		}
		return instanceId;
	}

	@Override
	public String onTalk(L2Npc npc, L2PcInstance player)
	{
		// if npc in GUARDS then
		return "data/html/default/"+npc.getNpcId()+"-3.htm";
	}

	@Override
	public String onAdvEvent(String event, L2Npc npc, L2PcInstance player)
	{
		if (event.startsWith("lvl") && event.length() >= 5)
		{
			// <a action="bypass -h Quest Kamaloka lvl23">
			QuestState st = player.getQuestState(qn);
			if (st == null)
				st = newQuestState(player);
			int level = Integer.parseInt(event.substring(3));
			KamalokaInfo kamaInfo = KAMALOKA.get(level);
			if (! kamaInfo.enable)
			{
				player.sendMessage("̃J}J͍HłB");
	//			player.sendMessage("This Kamaloka has been disabled by an Admin");
				return null;
			}
			enterInstance(player, kamaInfo, level);
		}
		return "";
	}

	@Override
	public String onKill(L2Npc npc, L2PcInstance player, boolean isPet)
	{
		KamalokaWorld world;
		if ((world = getWorld(npc.getInstanceId())) == null)
			return null;
		int npcId = npc.getNpcId();
		if (Arrays.binarySearch(BOSSES, npcId) >= 0)
		{
			world.status = -1;
			TIntHashSet playerList = InstanceManager.getInstance().getInstance(player.getInstanceId()).getPlayers();
			for (int memberId : playerList.toArray())
			{
				L2PcInstance member = (L2PcInstance)L2World.getInstance().findObject(memberId);
				InstanceManager.getInstance().setInstanceTime(member.getObjectId()
						, world.templateId
						, System.currentTimeMillis() + world.kamaInfo.timeDelay);
				member.sendPacket(new SystemMessage(SystemMessageId.INSTANCE_ZONE_TERMINATES_IN_S1_MINUTES).addNumber(5));
			}
			Instance instance = InstanceManager.getInstance().getInstance(player.getInstanceId());
			if (instance != null)
				instance.setDuration(300000);
		}
		else
		{
			switch (world.status)
			{
			case 1:
				if (checkKillProgress(npc, world.room1))
					startSecondRoom(world);
				break;
			case 2:
				if (checkKillProgress(npc, world.room2))
					startThirdRoom(world);
				break;
			case 3:
				if (checkKillProgress(npc, world.room3))
					startFourthRoom(world);
				break;
			}
		}
		return "";
	}


	public static void main(String[] args)
	{
		// now call the constructor (starts up the ai)
		new Kamaloka(-1, qn, "instances");
	}
}
