DROP TABLE IF EXISTS `skill_trees`;
CREATE TABLE `skill_trees` (
  `class_id` int(10) unsigned NOT NULL default '0',
  `skill_id` int(10) unsigned NOT NULL default '0',
  `level` int(10) unsigned NOT NULL default '0',
  `name` varchar(40) NOT NULL default '',
  `sp` int(10) unsigned NOT NULL default '0',
  `min_level` int(10) unsigned NOT NULL default '0',
  PRIMARY KEY (`class_id`,`skill_id`,`level`)
) DEFAULT CHARSET=utf8;

-- GLOSSARY FOR CLASS ID'S (Created by Mr_Pleb_Mgoo), Updated by DJ MELERIX

-- HUMANS
-- 0=Human Fighter        | 1=Warrior       | 2=Gladiator        | 3=Warlord  | 4=Human Knight   | 5=Paladin
-- 6=Dark Avenger         | 7=Rogue         | 8=Treasure Hunter  | 9=Hawkeye  | 10=Human Mystic  | 11=Wizard
-- 12=Sorcerer/ss         | 13=Necromancer  | 14=Warlock         | 15=Cleric  | 16=Bishop        | 17=Prophet

-- ELVES
-- 18=Elven Fighter       | 19=Elven Knight   | 20=Temple Knight  | 21=Swordsinger   | 22=Elven Scout
-- 23=Plains Walker       | 24=Silver Ranger  | 25=Elven Mystic   | 26=Elven Wizard  | 27=SpellSinger
-- 28=Elemental Summoner  | 29=Elven Oracle   | 30=Elven Elder

-- DARK ELVES
-- 31=Dark Fighter        | 32=Palus Knight     | 33=Shillien Knight  | 34=BladeDancer  | 35=Assassin
-- 36=Abyss Walker        | 37=Phantom Ranger   | 38=Dark Mystic      | 39=Dark Wizard  | 40=SpellHowler
-- 41=Phantom Summoner    | 42=Shillien Oracle  | 43=Shillien Elder

-- ORCS
-- 44=Orc Fighter         | 45=Orc Raider  | 46=Destroyer  | 47=Monk  | 48=Tyrant  | 49=Orc Mystic  | 50=Orc Shaman
-- 51=Overlord            | 52=Warcryer

-- DWARVES
-- 53=Dwarven Fighter     | 54=Scavenger  | 55=Bounty Hunter  | 56=Artisan  | 57=Warsmith

-- HUMANS 3rd Professions
-- 88=Duelist             | 89=DreadNought  | 90=Phoenix Knight  | 91=Hell Knight  | 92=Sagittarius  | 93=Adventurer
-- 94=ArchMage            | 95=Soultaker    | 96=Arcana Lord     | 97=Cardinal     | 98=HieroPhant

-- ELVES 3rd Professions
-- 99=Evas Templar        | 100=Sword Muse  | 101=Wind Rider  | 102=Moonlight Sentinel  | 103=Mystic Muse
-- 104=Elemental Master   | 105=Evas Saint

-- DARK ELVES 3rd Professions
-- 106=Shillien Templar   | 107=Spectral Dancer  | 108=Ghost Hunter  | 109=Ghost Sentinel  | 110=Storm Screamer
-- 111=Spectral Master    | 112=Shillien Saint

-- ORCS 3rd Professions
-- 113=Titan              | 114=Grand Khavatari  | 115=Dominator  | 116=Doomcryer

-- DWARVES 3rd Professions
-- 117=Fortune Seeker     | 118=Maestro

-- KAMAELS
-- 123=Male Soldier       | 124=Female Soldier       | 125=Trooper     | 126=Warder       | 127=Berserker
-- 128=Male Soul Breaker  | 129=Female Soul Breaker  | 130=Arbalester  | 131=Doombringer  | 132=Male Soul Hound
-- 133=Female Soul Hound  | 134=Trickster            | 135=Inspector   | 136=Judicator

INSERT INTO `skill_trees` VALUES
(0,141,1,'Weapon Mastery',160,5),
(0,226,1,'Relax',160,5),
(0,142,1,'Armor Mastery',160,5),
(0,56,1,'Power Shot',50,5),
(0,56,2,'Power Shot',50,5),
(0,56,3,'Power Shot',50,5),
(0,3,1,'Power Strike',50,5),
(0,3,2,'Power Strike',50,5),
(0,3,3,'Power Strike',50,5),
(0,16,1,'Mortal Blow',50,5),
(0,16,2,'Mortal Blow',50,5),
(0,16,3,'Mortal Blow',50,5),
(0,16,4,'Mortal Blow',370,10),
(0,16,5,'Mortal Blow',370,10),
(0,16,6,'Mortal Blow',370,10),
(0,3,4,'Power Strike',370,10),
(0,3,5,'Power Strike',370,10),
(0,3,6,'Power Strike',370,10),
(0,56,4,'Power Shot',370,10),
(0,56,5,'Power Shot',370,10),
(0,56,6,'Power Shot',370,10),
(0,142,2,'Armor Mastery',550,10),
(0,142,3,'Armor Mastery',550,10),
(0,141,2,'Weapon Mastery',1100,10),
(0,141,3,'Weapon Mastery',4000,15),
(0,142,4,'Armor Mastery',2000,15),
(0,142,5,'Armor Mastery',2000,15),
(0,56,7,'Power Shot',1300,15),
(0,56,8,'Power Shot',1300,15),
(0,56,9,'Power Shot',1300,15),
(0,3,7,'Power Strike',1300,15),
(0,3,8,'Power Strike',1300,15),
(0,3,9,'Power Strike',1300,15),
(0,16,7,'Mortal Blow',1300,15),
(0,16,8,'Mortal Blow',1300,15),
(0,16,9,'Mortal Blow',1300,15),
(1,78,1,'War Cry',3700,20),
(1,100,1,'Stun Attack',1200,20),
(1,100,2,'Stun Attack',1200,20),
(1,100,3,'Stun Attack',1200,20),
(1,211,1,'Boost HP',3700,20),
(1,216,1,'Polearm Mastery',3700,20),
(1,227,1,'Light Armor Mastery',1900,20),
(1,227,2,'Light Armor Mastery',1900,20),
(1,231,1,'Heavy Armor Mastery',1900,20),
(1,231,2,'Heavy Armor Mastery',1900,20),
(1,245,1,'Wild Sweep',1200,20),
(1,245,2,'Wild Sweep',1200,20),
(1,245,3,'Wild Sweep',1200,20),
(1,255,1,'Power Smash',1200,20),
(1,255,2,'Power Smash',1200,20),
(1,255,3,'Power Smash',1200,20),
(1,257,1,'Sword/Blunt Weapon Mastery',3700,20),
(1,312,1,'Vicious Stance',3700,20),
(1,312,2,'Vicious Stance',6400,24),
(1,256,1,'Accuracy',6400,24),
(1,257,2,'Sword/Blunt Weapon Mastery',6400,24),
(1,255,4,'Power Smash',2100,24),
(1,255,5,'Power Smash',2100,24),
(1,255,6,'Power Smash',2100,24),
(1,245,4,'Wild Sweep',2100,24),
(1,245,5,'Wild Sweep',2100,24),
(1,245,6,'Wild Sweep',2100,24),
(1,231,3,'Heavy Armor Mastery',3200,24),
(1,231,4,'Heavy Armor Mastery',3200,24),
(1,227,3,'Light Armor Mastery',3200,24),
(1,227,4,'Light Armor Mastery',3200,24),
(1,216,2,'Polearm Mastery',6400,24),
(1,212,1,'Fast HP Recovery',6400,24),
(1,148,1,'Vital Force',6400,24),
(1,100,4,'Stun Attack',2100,24),
(1,100,5,'Stun Attack',2100,24),
(1,100,6,'Stun Attack',2100,24),
(1,100,7,'Stun Attack',4000,28),
(1,100,8,'Stun Attack',4000,28),
(1,100,9,'Stun Attack',4000,28),
(1,121,1,'Battle Roar',12000,28),
(1,211,2,'Boost HP',12000,28),
(1,216,3,'Polearm Mastery',6000,28),
(1,216,4,'Polearm Mastery',6000,28),
(1,227,5,'Light Armor Mastery',4000,28),
(1,227,6,'Light Armor Mastery',4000,28),
(1,227,7,'Light Armor Mastery',4000,28),
(1,231,5,'Heavy Armor Mastery',4000,28),
(1,231,6,'Heavy Armor Mastery',4000,28),
(1,231,7,'Heavy Armor Mastery',4000,28),
(1,245,7,'Wild Sweep',4000,28),
(1,245,8,'Wild Sweep',4000,28),
(1,245,9,'Wild Sweep',4000,28),
(1,255,7,'Power Smash',4000,28),
(1,255,8,'Power Smash',4000,28),
(1,255,9,'Power Smash',4000,28),
(1,257,3,'Sword/Blunt Weapon Mastery',6000,28),
(1,257,4,'Sword/Blunt Weapon Mastery',6000,28),
(1,312,3,'Vicious Stance',12000,28),
(1,312,4,'Vicious Stance',18000,32),
(1,257,5,'Sword/Blunt Weapon Mastery',9100,32),
(1,257,6,'Sword/Blunt Weapon Mastery',9100,32),
(1,255,10,'Power Smash',6100,32),
(1,255,11,'Power Smash',6100,32),
(1,255,12,'Power Smash',6100,32),
(1,245,10,'Wild Sweep',6100,32),
(1,245,11,'Wild Sweep',6100,32),
(1,245,12,'Wild Sweep',6100,32),
(1,231,8,'Heavy Armor Mastery',6100,32),
(1,231,9,'Heavy Armor Mastery',6100,32),
(1,231,10,'Heavy Armor Mastery',6100,32),
(1,227,8,'Light Armor Mastery',6100,32),
(1,227,9,'Light Armor Mastery',6100,32),
(1,227,10,'Light Armor Mastery',6100,32),
(1,216,5,'Polearm Mastery',9100,32),
(1,216,6,'Polearm Mastery',9100,32),
(1,212,2,'Fast HP Recovery',18000,32),
(1,75,1,'Detect Insect Weakness',18000,32),
(1,148,2,'Vital Force',18000,32),
(1,100,10,'Stun Attack',6100,32),
(1,100,11,'Stun Attack',6100,32),
(1,100,12,'Stun Attack',6100,32),
(1,100,13,'Stun Attack',10000,36),
(1,100,14,'Stun Attack',10000,36),
(1,100,15,'Stun Attack',10000,36),
(1,211,3,'Boost HP',31000,36),
(1,216,7,'Polearm Mastery',16000,36),
(1,216,8,'Polearm Mastery',16000,36),
(1,227,11,'Light Armor Mastery',10000,36),
(1,227,12,'Light Armor Mastery',10000,36),
(1,227,13,'Light Armor Mastery',10000,36),
(1,231,11,'Heavy Armor Mastery',10000,36),
(1,231,12,'Heavy Armor Mastery',10000,36),
(1,231,13,'Heavy Armor Mastery',10000,36),
(1,245,13,'Wild Sweep',10000,36),
(1,245,14,'Wild Sweep',10000,36),
(1,245,15,'Wild Sweep',10000,36),
(1,255,13,'Power Smash',10000,36),
(1,255,14,'Power Smash',10000,36),
(1,255,15,'Power Smash',10000,36),
(1,257,7,'Sword/Blunt Weapon Mastery',16000,36),
(1,257,8,'Sword/Blunt Weapon Mastery',16000,36),
(1,287,1,'Lionheart',31000,36),
(1,312,5,'Vicious Stance',31000,36),
(2,1,1,'Triple Slash',11000,40),
(2,1,2,'Triple Slash',11000,40),
(2,1,3,'Triple Slash',11000,40),
(2,144,1,'Dual Weapon Mastery',11000,40),
(2,144,2,'Dual Weapon Mastery',11000,40),
(2,144,3,'Dual Weapon Mastery',11000,40),
(2,190,1,'Fatal Strike',11000,40),
(2,190,2,'Fatal Strike',11000,40),
(2,190,3,'Fatal Strike',11000,40),
(2,227,14,'Light Armor Mastery',11000,40),
(2,227,15,'Light Armor Mastery',11000,40),
(2,227,16,'Light Armor Mastery',11000,40),
(2,231,14,'Heavy Armor Mastery',11000,40),
(2,231,15,'Heavy Armor Mastery',11000,40),
(2,231,16,'Heavy Armor Mastery',11000,40),
(2,257,9,'Sword/Blunt Weapon Mastery',11000,40),
(2,257,10,'Sword/Blunt Weapon Mastery',11000,40),
(2,257,11,'Sword/Blunt Weapon Mastery',11000,40),
(2,260,1,'Hammer Crush',11000,40),
(2,260,2,'Hammer Crush',11000,40),
(2,260,3,'Hammer Crush',11000,40),
(2,8,1,'Sonic Focus',33000,40),
(2,87,1,'Detect Animal Weakness',33000,40),
(2,212,3,'Fast HP Recovery',33000,40),
(2,312,6,'Vicious Stance',33000,40),
(2,312,7,'Vicious Stance',35000,43),
(2,78,2,'War Cry',35000,43),
(2,8,2,'Sonic Focus',35000,43),
(2,290,1,'Final Frenzy',35000,43),
(2,260,4,'Hammer Crush',12000,43),
(2,260,5,'Hammer Crush',12000,43),
(2,260,6,'Hammer Crush',12000,43),
(2,257,12,'Sword/Blunt Weapon Mastery',12000,43),
(2,257,13,'Sword/Blunt Weapon Mastery',12000,43),
(2,257,14,'Sword/Blunt Weapon Mastery',12000,43),
(2,231,17,'Heavy Armor Mastery',12000,43),
(2,231,18,'Heavy Armor Mastery',12000,43),
(2,231,19,'Heavy Armor Mastery',12000,43),
(2,227,17,'Light Armor Mastery',12000,43),
(2,227,18,'Light Armor Mastery',12000,43),
(2,227,19,'Light Armor Mastery',12000,43),
(2,190,4,'Fatal Strike',12000,43),
(2,190,5,'Fatal Strike',12000,43),
(2,190,6,'Fatal Strike',12000,43),
(2,144,4,'Dual Weapon Mastery',12000,43),
(2,144,5,'Dual Weapon Mastery',12000,43),
(2,144,6,'Dual Weapon Mastery',12000,43),
(2,1,4,'Triple Slash',12000,43),
(2,1,5,'Triple Slash',12000,43),
(2,1,6,'Triple Slash',12000,43),
(2,6,1,'Sonic Blaster',11000,43),
(2,6,2,'Sonic Blaster',11000,43),
(2,6,3,'Sonic Blaster',11000,43),
(2,6,4,'Sonic Blaster',12000,43),
(2,6,5,'Sonic Blaster',12000,43),
(2,6,6,'Sonic Blaster',12000,43),
(2,9,1,'Sonic Buster',12000,43),
(2,9,2,'Sonic Buster',12000,43),
(2,9,3,'Sonic Buster',12000,43),
(2,9,4,'Sonic Buster',14000,46),
(2,9,5,'Sonic Buster',14000,46),
(2,9,6,'Sonic Buster',14000,46),
(2,6,7,'Sonic Blaster',14000,46),
(2,6,8,'Sonic Blaster',14000,46),
(2,6,9,'Sonic Blaster',14000,46),
(2,1,7,'Triple Slash',14000,46),
(2,1,8,'Triple Slash',14000,46),
(2,1,9,'Triple Slash',14000,46),
(2,144,7,'Dual Weapon Mastery',14000,46),
(2,144,8,'Dual Weapon Mastery',14000,46),
(2,144,9,'Dual Weapon Mastery',14000,46),
(2,190,7,'Fatal Strike',14000,46),
(2,190,8,'Fatal Strike',14000,46),
(2,190,9,'Fatal Strike',14000,46),
(2,227,20,'Light Armor Mastery',14000,46),
(2,227,21,'Light Armor Mastery',14000,46),
(2,227,22,'Light Armor Mastery',14000,46),
(2,231,20,'Heavy Armor Mastery',14000,46),
(2,231,21,'Heavy Armor Mastery',14000,46),
(2,231,22,'Heavy Armor Mastery',14000,46),
(2,257,15,'Sword/Blunt Weapon Mastery',14000,46),
(2,257,16,'Sword/Blunt Weapon Mastery',14000,46),
(2,257,17,'Sword/Blunt Weapon Mastery',14000,46),
(2,260,7,'Hammer Crush',14000,46),
(2,260,8,'Hammer Crush',14000,46),
(2,260,9,'Hammer Crush',14000,46),
(2,290,2,'Final Frenzy',43000,46),
(2,312,8,'Vicious Stance',43000,46),
(2,212,4,'Fast HP Recovery',43000,46),
(2,104,1,'Detect Plant Weakness',43000,46),
(2,287,2,'Lionheart',65000,49),
(2,312,9,'Vicious Stance',65000,49),
(2,290,3,'Final Frenzy',65000,49),
(2,8,3,'Sonic Focus',65000,49),
(2,260,10,'Hammer Crush',22000,49),
(2,260,11,'Hammer Crush',22000,49),
(2,260,12,'Hammer Crush',22000,49),
(2,257,18,'Sword/Blunt Weapon Mastery',22000,49),
(2,257,19,'Sword/Blunt Weapon Mastery',22000,49),
(2,257,20,'Sword/Blunt Weapon Mastery',22000,49),
(2,231,23,'Heavy Armor Mastery',22000,49),
(2,231,24,'Heavy Armor Mastery',22000,49),
(2,231,25,'Heavy Armor Mastery',22000,49),
(2,227,23,'Light Armor Mastery',22000,49),
(2,227,24,'Light Armor Mastery',22000,49),
(2,227,25,'Light Armor Mastery',22000,49),
(2,190,10,'Fatal Strike',22000,49),
(2,190,11,'Fatal Strike',22000,49),
(2,190,12,'Fatal Strike',22000,49),
(2,144,10,'Dual Weapon Mastery',22000,49),
(2,144,11,'Dual Weapon Mastery',22000,49),
(2,144,12,'Dual Weapon Mastery',22000,49),
(2,1,10,'Triple Slash',22000,49),
(2,1,11,'Triple Slash',22000,49),
(2,1,12,'Triple Slash',22000,49),
(2,6,10,'Sonic Blaster',22000,49),
(2,6,11,'Sonic Blaster',22000,49),
(2,6,12,'Sonic Blaster',22000,49),
(2,9,7,'Sonic Buster',22000,49),
(2,9,8,'Sonic Buster',22000,49),
(2,9,9,'Sonic Buster',22000,49),
(2,5,1,'Double Sonic Slash',14000,49),
(2,5,2,'Double Sonic Slash',14000,49),
(2,5,3,'Double Sonic Slash',14000,49),
(2,5,4,'Double Sonic Slash',22000,49),
(2,5,5,'Double Sonic Slash',22000,49),
(2,5,6,'Double Sonic Slash',22000,49),
(2,7,1,'Sonic Storm',22000,49),
(2,7,2,'Sonic Storm',22000,49),
(2,7,3,'Sonic Storm',22000,49),
(2,7,4,'Sonic Storm',33000,52),
(2,7,5,'Sonic Storm',33000,52),
(2,7,6,'Sonic Storm',33000,52),
(2,5,7,'Double Sonic Slash',33000,52),
(2,5,8,'Double Sonic Slash',33000,52),
(2,5,9,'Double Sonic Slash',33000,52),
(2,9,10,'Sonic Buster',33000,52),
(2,9,11,'Sonic Buster',33000,52),
(2,9,12,'Sonic Buster',33000,52),
(2,6,13,'Sonic Blaster',33000,52),
(2,6,14,'Sonic Blaster',33000,52),
(2,6,15,'Sonic Blaster',33000,52),
(2,1,13,'Triple Slash',33000,52),
(2,1,14,'Triple Slash',33000,52),
(2,1,15,'Triple Slash',33000,52),
(2,144,13,'Dual Weapon Mastery',33000,52),
(2,144,14,'Dual Weapon Mastery',33000,52),
(2,144,15,'Dual Weapon Mastery',33000,52),
(2,190,13,'Fatal Strike',33000,52),
(2,190,14,'Fatal Strike',33000,52),
(2,190,15,'Fatal Strike',33000,52),
(2,227,26,'Light Armor Mastery',33000,52),
(2,227,27,'Light Armor Mastery',33000,52),
(2,227,28,'Light Armor Mastery',33000,52),
(2,231,26,'Heavy Armor Mastery',33000,52),
(2,231,27,'Heavy Armor Mastery',33000,52),
(2,231,28,'Heavy Armor Mastery',33000,52),
(2,257,21,'Sword/Blunt Weapon Mastery',33000,52),
(2,257,22,'Sword/Blunt Weapon Mastery',33000,52),
(2,257,23,'Sword/Blunt Weapon Mastery',33000,52),
(2,260,13,'Hammer Crush',33000,52),
(2,260,14,'Hammer Crush',33000,52),
(2,260,15,'Hammer Crush',33000,52),
(2,80,1,'Detect Beast Weakness',100000,52),
(2,290,4,'Final Frenzy',100000,52),
(2,312,10,'Vicious Stance',100000,52),
(2,212,5,'Fast HP Recovery',100000,52),
(2,312,11,'Vicious Stance',133000,55),
(2,290,5,'Final Frenzy',133000,55),
(2,8,4,'Sonic Focus',133000,55),
(2,261,1,'Triple Sonic Slash',44000,55),
(2,261,2,'Triple Sonic Slash',44000,55),
(2,261,3,'Triple Sonic Slash',44000,55),
(2,260,16,'Hammer Crush',44000,55),
(2,260,17,'Hammer Crush',44000,55),
(2,260,18,'Hammer Crush',44000,55),
(2,257,24,'Sword/Blunt Weapon Mastery',44000,55),
(2,257,25,'Sword/Blunt Weapon Mastery',44000,55),
(2,257,26,'Sword/Blunt Weapon Mastery',44000,55),
(2,231,29,'Heavy Armor Mastery',44000,55),
(2,231,30,'Heavy Armor Mastery',44000,55),
(2,231,31,'Heavy Armor Mastery',44000,55),
(2,227,29,'Light Armor Mastery',44000,55),
(2,227,30,'Light Armor Mastery',44000,55),
(2,227,31,'Light Armor Mastery',44000,55),
(2,190,16,'Fatal Strike',44000,55),
(2,190,17,'Fatal Strike',44000,55),
(2,190,18,'Fatal Strike',44000,55),
(2,144,16,'Dual Weapon Mastery',44000,55),
(2,144,17,'Dual Weapon Mastery',44000,55),
(2,144,18,'Dual Weapon Mastery',44000,55),
(2,1,16,'Triple Slash',44000,55),
(2,1,17,'Triple Slash',44000,55),
(2,1,18,'Triple Slash',44000,55),
(2,6,16,'Sonic Blaster',44000,55),
(2,6,17,'Sonic Blaster',44000,55),
(2,6,18,'Sonic Blaster',44000,55),
(2,9,13,'Sonic Buster',44000,55),
(2,9,14,'Sonic Buster',44000,55),
(2,9,15,'Sonic Buster',44000,55),
(2,5,10,'Double Sonic Slash',44000,55),
(2,5,11,'Double Sonic Slash',44000,55),
(2,5,12,'Double Sonic Slash',44000,55),
(2,7,7,'Sonic Storm',44000,55),
(2,7,8,'Sonic Storm',44000,55),
(2,7,9,'Sonic Storm',44000,55),
(2,7,10,'Sonic Storm',51000,58),
(2,7,11,'Sonic Storm',51000,58),
(2,7,12,'Sonic Storm',51000,58),
(2,5,13,'Double Sonic Slash',51000,58),
(2,5,14,'Double Sonic Slash',51000,58),
(2,5,15,'Double Sonic Slash',51000,58),
(2,9,16,'Sonic Buster',51000,58),
(2,9,17,'Sonic Buster',51000,58),
(2,9,18,'Sonic Buster',51000,58),
(2,6,19,'Sonic Blaster',51000,58),
(2,6,20,'Sonic Blaster',51000,58),
(2,6,21,'Sonic Blaster',51000,58),
(2,1,19,'Triple Slash',51000,58),
(2,1,20,'Triple Slash',51000,58),
(2,1,21,'Triple Slash',51000,58),
(2,144,19,'Dual Weapon Mastery',51000,58),
(2,144,20,'Dual Weapon Mastery',51000,58),
(2,144,21,'Dual Weapon Mastery',51000,58),
(2,190,19,'Fatal Strike',51000,58),
(2,190,20,'Fatal Strike',51000,58),
(2,190,21,'Fatal Strike',51000,58),
(2,227,32,'Light Armor Mastery',51000,58),
(2,227,33,'Light Armor Mastery',51000,58),
(2,227,34,'Light Armor Mastery',51000,58),
(2,231,32,'Heavy Armor Mastery',51000,58),
(2,231,33,'Heavy Armor Mastery',51000,58),
(2,231,34,'Heavy Armor Mastery',51000,58),
(2,257,27,'Sword/Blunt Weapon Mastery',51000,58),
(2,257,28,'Sword/Blunt Weapon Mastery',51000,58),
(2,257,29,'Sword/Blunt Weapon Mastery',51000,58),
(2,260,19,'Hammer Crush',51000,58),
(2,260,20,'Hammer Crush',51000,58),
(2,260,21,'Hammer Crush',51000,58),
(2,261,4,'Triple Sonic Slash',51000,58),
(2,261,5,'Triple Sonic Slash',51000,58),
(2,261,6,'Triple Sonic Slash',51000,58),
(2,88,1,'Detect Dragon Weakness',153000,58),
(2,290,6,'Final Frenzy',153000,58),
(2,312,12,'Vicious Stance',153000,58),
(2,212,6,'Fast HP Recovery',153000,58),
(2,424,1,'War Frenzy',153000,58),
(2,312,13,'Vicious Stance',190000,60),
(2,290,7,'Final Frenzy',190000,60),
(2,8,5,'Sonic Focus',190000,60),
(2,261,7,'Triple Sonic Slash',97000,60),
(2,261,8,'Triple Sonic Slash',97000,60),
(2,260,22,'Hammer Crush',97000,60),
(2,260,23,'Hammer Crush',97000,60),
(2,257,30,'Sword/Blunt Weapon Mastery',97000,60),
(2,257,31,'Sword/Blunt Weapon Mastery',97000,60),
(2,231,35,'Heavy Armor Mastery',97000,60),
(2,231,36,'Heavy Armor Mastery',97000,60),
(2,227,35,'Light Armor Mastery',97000,60),
(2,227,36,'Light Armor Mastery',97000,60),
(2,190,22,'Fatal Strike',97000,60),
(2,190,23,'Fatal Strike',97000,60),
(2,144,22,'Dual Weapon Mastery',97000,60),
(2,144,23,'Dual Weapon Mastery',97000,60),
(2,1,22,'Triple Slash',97000,60),
(2,1,23,'Triple Slash',97000,60),
(2,6,22,'Sonic Blaster',97000,60),
(2,6,23,'Sonic Blaster',97000,60),
(2,9,19,'Sonic Buster',97000,60),
(2,9,20,'Sonic Buster',97000,60),
(2,5,16,'Double Sonic Slash',97000,60),
(2,5,17,'Double Sonic Slash',97000,60),
(2,7,13,'Sonic Storm',97000,60),
(2,7,14,'Sonic Storm',97000,60),
(2,7,15,'Sonic Storm',130000,62),
(2,7,16,'Sonic Storm',130000,62),
(2,5,18,'Double Sonic Slash',130000,62),
(2,5,19,'Double Sonic Slash',130000,62),
(2,9,21,'Sonic Buster',130000,62),
(2,9,22,'Sonic Buster',130000,62),
(2,6,24,'Sonic Blaster',130000,62),
(2,6,25,'Sonic Blaster',130000,62),
(2,1,24,'Triple Slash',130000,62),
(2,1,25,'Triple Slash',130000,62),
(2,144,24,'Dual Weapon Mastery',130000,62),
(2,144,25,'Dual Weapon Mastery',130000,62),
(2,190,24,'Fatal Strike',130000,62),
(2,190,25,'Fatal Strike',130000,62),
(2,227,37,'Light Armor Mastery',130000,62),
(2,227,38,'Light Armor Mastery',130000,62),
(2,231,37,'Heavy Armor Mastery',130000,62),
(2,231,38,'Heavy Armor Mastery',130000,62),
(2,257,32,'Sword/Blunt Weapon Mastery',130000,62),
(2,257,33,'Sword/Blunt Weapon Mastery',130000,62),
(2,260,24,'Hammer Crush',130000,62),
(2,260,25,'Hammer Crush',130000,62),
(2,261,9,'Triple Sonic Slash',130000,62),
(2,261,10,'Triple Sonic Slash',130000,62),
(2,290,8,'Final Frenzy',250000,62),
(2,312,14,'Vicious Stance',250000,62),
(2,287,3,'Lionheart',250000,62),
(2,451,1,'Sonic Move',250000,62),
(2,297,1,'Duelist Spirit',320000,64),
(2,312,15,'Vicious Stance',320000,64),
(2,290,9,'Final Frenzy',320000,64),
(2,261,11,'Triple Sonic Slash',160000,64),
(2,261,12,'Triple Sonic Slash',160000,64),
(2,260,26,'Hammer Crush',160000,64),
(2,260,27,'Hammer Crush',160000,64),
(2,257,34,'Sword/Blunt Weapon Mastery',160000,64),
(2,257,35,'Sword/Blunt Weapon Mastery',160000,64),
(2,231,39,'Heavy Armor Mastery',160000,64),
(2,231,40,'Heavy Armor Mastery',160000,64),
(2,227,39,'Light Armor Mastery',160000,64),
(2,227,40,'Light Armor Mastery',160000,64),
(2,190,26,'Fatal Strike',160000,64),
(2,190,27,'Fatal Strike',160000,64),
(2,144,26,'Dual Weapon Mastery',160000,64),
(2,144,27,'Dual Weapon Mastery',160000,64),
(2,1,26,'Triple Slash',160000,64),
(2,1,27,'Triple Slash',160000,64),
(2,6,26,'Sonic Blaster',160000,64),
(2,6,27,'Sonic Blaster',160000,64),
(2,9,23,'Sonic Buster',160000,64),
(2,9,24,'Sonic Buster',160000,64),
(2,5,20,'Double Sonic Slash',160000,64),
(2,5,21,'Double Sonic Slash',160000,64),
(2,7,17,'Sonic Storm',160000,64),
(2,7,18,'Sonic Storm',160000,64),
(2,7,19,'Sonic Storm',220000,66),
(2,7,20,'Sonic Storm',220000,66),
(2,5,22,'Double Sonic Slash',220000,66),
(2,5,23,'Double Sonic Slash',220000,66),
(2,9,25,'Sonic Buster',220000,66),
(2,9,26,'Sonic Buster',220000,66),
(2,6,28,'Sonic Blaster',220000,66),
(2,6,29,'Sonic Blaster',220000,66),
(2,1,28,'Triple Slash',220000,66),
(2,1,29,'Triple Slash',220000,66),
(2,144,28,'Dual Weapon Mastery',220000,66),
(2,144,29,'Dual Weapon Mastery',220000,66),
(2,190,28,'Fatal Strike',220000,66),
(2,190,29,'Fatal Strike',220000,66),
(2,227,41,'Light Armor Mastery',220000,66),
(2,227,42,'Light Armor Mastery',220000,66),
(2,231,41,'Heavy Armor Mastery',220000,66),
(2,231,42,'Heavy Armor Mastery',220000,66),
(2,257,36,'Sword/Blunt Weapon Mastery',220000,66),
(2,257,37,'Sword/Blunt Weapon Mastery',220000,66),
(2,260,28,'Hammer Crush',220000,66),
(2,260,29,'Hammer Crush',220000,66),
(2,261,13,'Triple Sonic Slash',220000,66),
(2,261,14,'Triple Sonic Slash',220000,66),
(2,290,10,'Final Frenzy',440000,66),
(2,8,6,'Sonic Focus',440000,66),
(2,312,16,'Vicious Stance',440000,66),
(2,424,2,'War Frenzy',440000,66),
(2,451,2,'Sonic Move',490000,68),
(2,312,17,'Vicious Stance',490000,68),
(2,212,7,'Fast HP Recovery',490000,68),
(2,290,11,'Final Frenzy',490000,68),
(2,261,15,'Triple Sonic Slash',240000,68),
(2,261,16,'Triple Sonic Slash',240000,68),
(2,260,30,'Hammer Crush',240000,68),
(2,260,31,'Hammer Crush',240000,68),
(2,257,38,'Sword/Blunt Weapon Mastery',240000,68),
(2,257,39,'Sword/Blunt Weapon Mastery',240000,68),
(2,231,43,'Heavy Armor Mastery',240000,68),
(2,231,44,'Heavy Armor Mastery',240000,68),
(2,227,43,'Light Armor Mastery',240000,68),
(2,227,44,'Light Armor Mastery',240000,68),
(2,190,30,'Fatal Strike',240000,68),
(2,190,31,'Fatal Strike',240000,68),
(2,144,30,'Dual Weapon Mastery',240000,68),
(2,144,31,'Dual Weapon Mastery',240000,68),
(2,1,30,'Triple Slash',240000,68),
(2,1,31,'Triple Slash',240000,68),
(2,6,30,'Sonic Blaster',240000,68),
(2,6,31,'Sonic Blaster',240000,68),
(2,9,27,'Sonic Buster',240000,68),
(2,9,28,'Sonic Buster',240000,68),
(2,5,24,'Double Sonic Slash',240000,68),
(2,5,25,'Double Sonic Slash',240000,68),
(2,7,21,'Sonic Storm',240000,68),
(2,7,22,'Sonic Storm',240000,68),
(2,7,23,'Sonic Storm',310000,70),
(2,7,24,'Sonic Storm',310000,70),
(2,5,26,'Double Sonic Slash',310000,70),
(2,5,27,'Double Sonic Slash',310000,70),
(2,9,29,'Sonic Buster',310000,70),
(2,9,30,'Sonic Buster',310000,70),
(2,6,32,'Sonic Blaster',310000,70),
(2,6,33,'Sonic Blaster',310000,70),
(2,1,32,'Triple Slash',310000,70),
(2,1,33,'Triple Slash',310000,70),
(2,144,32,'Dual Weapon Mastery',310000,70),
(2,144,33,'Dual Weapon Mastery',310000,70),
(2,190,32,'Fatal Strike',310000,70),
(2,190,33,'Fatal Strike',310000,70),
(2,227,45,'Light Armor Mastery',310000,70),
(2,227,46,'Light Armor Mastery',310000,70),
(2,231,45,'Heavy Armor Mastery',310000,70),
(2,231,46,'Heavy Armor Mastery',310000,70),
(2,257,40,'Sword/Blunt Weapon Mastery',310000,70),
(2,257,41,'Sword/Blunt Weapon Mastery',310000,70),
(2,260,32,'Hammer Crush',310000,70),
(2,260,33,'Hammer Crush',310000,70),
(2,261,17,'Triple Sonic Slash',310000,70),
(2,261,18,'Triple Sonic Slash',310000,70),
(2,290,12,'Final Frenzy',620000,70),
(2,8,7,'Sonic Focus',620000,70),
(2,312,18,'Vicious Stance',620000,70),
(2,312,19,'Vicious Stance',800000,72),
(2,297,2,'Duelist Spirit',800000,72),
(2,290,13,'Final Frenzy',800000,72),
(2,261,19,'Triple Sonic Slash',400000,72),
(2,261,20,'Triple Sonic Slash',400000,72),
(2,260,34,'Hammer Crush',400000,72),
(2,260,35,'Hammer Crush',400000,72),
(2,257,42,'Sword/Blunt Weapon Mastery',400000,72),
(2,257,43,'Sword/Blunt Weapon Mastery',400000,72),
(2,231,47,'Heavy Armor Mastery',400000,72),
(2,231,48,'Heavy Armor Mastery',400000,72),
(2,227,47,'Light Armor Mastery',400000,72),
(2,227,48,'Light Armor Mastery',400000,72),
(2,190,34,'Fatal Strike',400000,72),
(2,190,35,'Fatal Strike',400000,72),
(2,144,34,'Dual Weapon Mastery',400000,72),
(2,144,35,'Dual Weapon Mastery',400000,72),
(2,1,34,'Triple Slash',400000,72),
(2,1,35,'Triple Slash',400000,72),
(2,6,34,'Sonic Blaster',400000,72),
(2,6,35,'Sonic Blaster',400000,72),
(2,9,31,'Sonic Buster',400000,72),
(2,9,32,'Sonic Buster',400000,72),
(2,5,28,'Double Sonic Slash',400000,72),
(2,5,29,'Double Sonic Slash',400000,72),
(2,7,25,'Sonic Storm',400000,72),
(2,7,26,'Sonic Storm',400000,72),
(2,7,27,'Sonic Storm',810000,74),
(2,7,28,'Sonic Storm',810000,74),
(2,5,30,'Double Sonic Slash',810000,74),
(2,5,31,'Double Sonic Slash',810000,74),
(2,9,33,'Sonic Buster',810000,74),
(2,9,34,'Sonic Buster',810000,74),
(2,6,36,'Sonic Blaster',810000,74),
(2,6,37,'Sonic Blaster',810000,74),
(2,1,36,'Triple Slash',810000,74),
(2,1,37,'Triple Slash',810000,74),
(2,144,36,'Dual Weapon Mastery',810000,74),
(2,144,37,'Dual Weapon Mastery',810000,74),
(2,190,36,'Fatal Strike',810000,74),
(2,190,37,'Fatal Strike',810000,74),
(2,227,49,'Light Armor Mastery',810000,74),
(2,227,50,'Light Armor Mastery',810000,74),
(2,231,49,'Heavy Armor Mastery',810000,74),
(2,231,50,'Heavy Armor Mastery',810000,74),
(2,257,44,'Sword/Blunt Weapon Mastery',810000,74),
(2,257,45,'Sword/Blunt Weapon Mastery',810000,74),
(2,260,36,'Hammer Crush',810000,74),
(2,260,37,'Hammer Crush',810000,74),
(2,261,21,'Triple Sonic Slash',810000,74),
(2,261,22,'Triple Sonic Slash',810000,74),
(2,290,14,'Final Frenzy',1630000,74),
(2,212,8,'Fast HP Recovery',1630000,74),
(2,312,20,'Vicious Stance',1630000,74),
(2,424,3,'War Frenzy',1630000,74),
(3,920,1,'Power Crush',12000,40),
(3,920,2,'Power Crush',12000,40),
(3,920,3,'Power Crush',12000,40),
(3,36,1,'Whirlwind',13000,40),
(3,36,2,'Whirlwind',13000,40),
(3,36,3,'Whirlwind',13000,40),
(3,48,1,'Thunder Storm',13000,40),
(3,48,2,'Thunder Storm',13000,40),
(3,48,3,'Thunder Storm',13000,40),
(3,216,9,'Polearm Mastery',13000,40),
(3,216,10,'Polearm Mastery',13000,40),
(3,216,11,'Polearm Mastery',13000,40),
(3,227,14,'Light Armor Mastery',13000,40),
(3,227,15,'Light Armor Mastery',13000,40),
(3,227,16,'Light Armor Mastery',13000,40),
(3,231,14,'Heavy Armor Mastery',13000,40),
(3,231,15,'Heavy Armor Mastery',13000,40),
(3,231,16,'Heavy Armor Mastery',13000,40),
(3,87,1,'Detect Animal Weakness',39000,40),
(3,121,2,'Battle Roar',39000,40),
(3,212,3,'Fast HP Recovery',39000,40),
(3,312,6,'Vicious Stance',39000,40),
(3,317,1,'Focus Attack',39000,40),
(3,920,4,'Power Crush',14000,43),
(3,920,5,'Power Crush',14000,43),
(3,920,6,'Power Crush',14000,43),
(3,286,1,'Provoke',46000,43),
(3,312,7,'Vicious Stance',46000,43),
(3,211,4,'Boost HP',46000,43),
(3,290,1,'Final Frenzy',46000,43),
(3,116,1,'Howl',46000,43),
(3,231,17,'Heavy Armor Mastery',15000,43),
(3,231,18,'Heavy Armor Mastery',15000,43),
(3,231,19,'Heavy Armor Mastery',15000,43),
(3,227,17,'Light Armor Mastery',15000,43),
(3,227,18,'Light Armor Mastery',15000,43),
(3,227,19,'Light Armor Mastery',15000,43),
(3,216,12,'Polearm Mastery',15000,43),
(3,216,13,'Polearm Mastery',15000,43),
(3,216,14,'Polearm Mastery',15000,43),
(3,48,4,'Thunder Storm',15000,43),
(3,48,5,'Thunder Storm',15000,43),
(3,48,6,'Thunder Storm',15000,43),
(3,36,4,'Whirlwind',15000,43),
(3,36,5,'Whirlwind',15000,43),
(3,36,6,'Whirlwind',15000,43),
(3,920,7,'Power Crush',17000,46),
(3,920,8,'Power Crush',17000,46),
(3,920,9,'Power Crush',17000,46),
(3,36,7,'Whirlwind',18000,46),
(3,36,8,'Whirlwind',18000,46),
(3,36,9,'Whirlwind',18000,46),
(3,48,7,'Thunder Storm',18000,46),
(3,48,8,'Thunder Storm',18000,46),
(3,48,9,'Thunder Storm',18000,46),
(3,216,15,'Polearm Mastery',18000,46),
(3,216,16,'Polearm Mastery',18000,46),
(3,216,17,'Polearm Mastery',18000,46),
(3,227,20,'Light Armor Mastery',18000,46),
(3,227,21,'Light Armor Mastery',18000,46),
(3,227,22,'Light Armor Mastery',18000,46),
(3,231,20,'Heavy Armor Mastery',18000,46),
(3,231,21,'Heavy Armor Mastery',18000,46),
(3,231,22,'Heavy Armor Mastery',18000,46),
(3,116,2,'Howl',55000,46),
(3,104,1,'Detect Plant Weakness',55000,46),
(3,290,2,'Final Frenzy',55000,46),
(3,212,4,'Fast HP Recovery',55000,46),
(3,312,8,'Vicious Stance',55000,46),
(3,130,1,'Thrill Fight',55000,46),
(3,920,10,'Power Crush',25000,49),
(3,920,11,'Power Crush',25000,49),
(3,920,12,'Power Crush',25000,49),
(3,317,2,'Focus Attack',82000,49),
(3,312,9,'Vicious Stance',82000,49),
(3,287,2,'Lionheart',82000,49),
(3,211,5,'Boost HP',82000,49),
(3,290,3,'Final Frenzy',82000,49),
(3,121,3,'Battle Roar',82000,49),
(3,116,3,'Howl',82000,49),
(3,231,23,'Heavy Armor Mastery',27000,49),
(3,231,24,'Heavy Armor Mastery',27000,49),
(3,231,25,'Heavy Armor Mastery',27000,49),
(3,227,23,'Light Armor Mastery',27000,49),
(3,227,24,'Light Armor Mastery',27000,49),
(3,227,25,'Light Armor Mastery',27000,49),
(3,216,18,'Polearm Mastery',27000,49),
(3,216,19,'Polearm Mastery',27000,49),
(3,216,20,'Polearm Mastery',27000,49),
(3,48,10,'Thunder Storm',27000,49),
(3,48,11,'Thunder Storm',27000,49),
(3,48,12,'Thunder Storm',27000,49),
(3,36,10,'Whirlwind',27000,49),
(3,36,11,'Whirlwind',27000,49),
(3,36,12,'Whirlwind',27000,49),
(3,920,13,'Power Crush',45000,52),
(3,920,14,'Power Crush',45000,52),
(3,920,15,'Power Crush',45000,52),
(3,36,13,'Whirlwind',50000,52),
(3,36,14,'Whirlwind',50000,52),
(3,36,15,'Whirlwind',50000,52),
(3,48,13,'Thunder Storm',50000,52),
(3,48,14,'Thunder Storm',50000,52),
(3,48,15,'Thunder Storm',50000,52),
(3,216,21,'Polearm Mastery',50000,52),
(3,216,22,'Polearm Mastery',50000,52),
(3,216,23,'Polearm Mastery',50000,52),
(3,227,26,'Light Armor Mastery',50000,52),
(3,227,27,'Light Armor Mastery',50000,52),
(3,227,28,'Light Armor Mastery',50000,52),
(3,231,26,'Heavy Armor Mastery',50000,52),
(3,231,27,'Heavy Armor Mastery',50000,52),
(3,231,28,'Heavy Armor Mastery',50000,52),
(3,116,4,'Howl',150000,52),
(3,80,1,'Detect Beast Weakness',150000,52),
(3,290,4,'Final Frenzy',150000,52),
(3,212,5,'Fast HP Recovery',150000,52),
(3,312,10,'Vicious Stance',150000,52),
(3,920,16,'Power Crush',50000,55),
(3,920,17,'Power Crush',50000,55),
(3,920,18,'Power Crush',50000,55),
(3,312,11,'Vicious Stance',154000,55),
(3,130,2,'Thrill Fight',154000,55),
(3,181,1,'Revival',154000,55),
(3,286,2,'Provoke',154000,55),
(3,452,1,'Shock Stomp',154000,55),
(3,211,6,'Boost HP',154000,55),
(3,290,5,'Final Frenzy',154000,55),
(3,116,5,'Howl',154000,55),
(3,231,29,'Heavy Armor Mastery',51000,55),
(3,231,30,'Heavy Armor Mastery',51000,55),
(3,231,31,'Heavy Armor Mastery',51000,55),
(3,227,29,'Light Armor Mastery',51000,55),
(3,227,30,'Light Armor Mastery',51000,55),
(3,227,31,'Light Armor Mastery',51000,55),
(3,216,24,'Polearm Mastery',51000,55),
(3,216,25,'Polearm Mastery',51000,55),
(3,216,26,'Polearm Mastery',51000,55),
(3,48,16,'Thunder Storm',51000,55),
(3,48,17,'Thunder Storm',51000,55),
(3,48,18,'Thunder Storm',51000,55),
(3,36,16,'Whirlwind',51000,55),
(3,36,17,'Whirlwind',51000,55),
(3,36,18,'Whirlwind',51000,55),
(3,920,19,'Power Crush',52000,58),
(3,920,20,'Power Crush',52000,58),
(3,920,21,'Power Crush',52000,58),
(3,36,19,'Whirlwind',58000,58),
(3,36,20,'Whirlwind',58000,58),
(3,36,21,'Whirlwind',58000,58),
(3,48,19,'Thunder Storm',58000,58),
(3,48,20,'Thunder Storm',58000,58),
(3,48,21,'Thunder Storm',58000,58),
(3,216,27,'Polearm Mastery',58000,58),
(3,216,28,'Polearm Mastery',58000,58),
(3,216,29,'Polearm Mastery',58000,58),
(3,227,32,'Light Armor Mastery',58000,58),
(3,227,33,'Light Armor Mastery',58000,58),
(3,227,34,'Light Armor Mastery',58000,58),
(3,231,32,'Heavy Armor Mastery',58000,58),
(3,231,33,'Heavy Armor Mastery',58000,58),
(3,231,34,'Heavy Armor Mastery',58000,58),
(3,116,6,'Howl',173000,58),
(3,88,1,'Detect Dragon Weakness',173000,58),
(3,121,4,'Battle Roar',173000,58),
(3,290,6,'Final Frenzy',173000,58),
(3,212,6,'Fast HP Recovery',173000,58),
(3,424,1,'War Frenzy',173000,58),
(3,317,3,'Focus Attack',173000,58),
(3,312,12,'Vicious Stance',173000,58),
(3,422,1,'Polearm Accuracy',173000,58),
(3,421,1,'Fell Swoop',173000,58),
(3,920,22,'Power Crush',132000,60),
(3,920,23,'Power Crush',132000,60),
(3,312,13,'Vicious Stance',290000,60),
(3,286,3,'Provoke',290000,60),
(3,452,2,'Shock Stomp',290000,60),
(3,290,7,'Final Frenzy',290000,60),
(3,116,7,'Howl',290000,60),
(3,231,35,'Heavy Armor Mastery',145000,60),
(3,231,36,'Heavy Armor Mastery',145000,60),
(3,227,35,'Light Armor Mastery',145000,60),
(3,227,36,'Light Armor Mastery',145000,60),
(3,216,30,'Polearm Mastery',145000,60),
(3,216,31,'Polearm Mastery',145000,60),
(3,48,22,'Thunder Storm',145000,60),
(3,48,23,'Thunder Storm',145000,60),
(3,36,22,'Whirlwind',145000,60),
(3,36,23,'Whirlwind',145000,60),
(3,920,24,'Power Crush',170000,62),
(3,920,25,'Power Crush',170000,62),
(3,36,24,'Whirlwind',180000,62),
(3,36,25,'Whirlwind',180000,62),
(3,48,24,'Thunder Storm',180000,62),
(3,48,25,'Thunder Storm',180000,62),
(3,216,32,'Polearm Mastery',180000,62),
(3,216,33,'Polearm Mastery',180000,62),
(3,227,37,'Light Armor Mastery',180000,62),
(3,227,38,'Light Armor Mastery',180000,62),
(3,231,37,'Heavy Armor Mastery',180000,62),
(3,231,38,'Heavy Armor Mastery',180000,62),
(3,116,8,'Howl',360000,62),
(3,290,8,'Final Frenzy',360000,62),
(3,211,7,'Boost HP',360000,62),
(3,312,14,'Vicious Stance',360000,62),
(3,421,2,'Fell Swoop',360000,62),
(3,287,3,'Lionheart',360000,62),
(3,920,26,'Power Crush',220000,64),
(3,920,27,'Power Crush',220000,64),
(3,312,15,'Vicious Stance',480000,64),
(3,452,3,'Shock Stomp',480000,64),
(3,290,9,'Final Frenzy',480000,64),
(3,116,9,'Howl',480000,64),
(3,121,5,'Battle Roar',480000,64),
(3,231,39,'Heavy Armor Mastery',240000,64),
(3,231,40,'Heavy Armor Mastery',240000,64),
(3,227,39,'Light Armor Mastery',240000,64),
(3,227,40,'Light Armor Mastery',240000,64),
(3,216,34,'Polearm Mastery',240000,64),
(3,216,35,'Polearm Mastery',240000,64),
(3,48,26,'Thunder Storm',240000,64),
(3,48,27,'Thunder Storm',240000,64),
(3,36,26,'Whirlwind',240000,64),
(3,36,27,'Whirlwind',240000,64),
(3,920,28,'Power Crush',230000,66),
(3,920,29,'Power Crush',230000,66),
(3,36,28,'Whirlwind',250000,66),
(3,36,29,'Whirlwind',250000,66),
(3,48,28,'Thunder Storm',250000,66),
(3,48,29,'Thunder Storm',250000,66),
(3,216,36,'Polearm Mastery',250000,66),
(3,216,37,'Polearm Mastery',250000,66),
(3,227,41,'Light Armor Mastery',250000,66),
(3,227,42,'Light Armor Mastery',250000,66),
(3,231,41,'Heavy Armor Mastery',250000,66),
(3,231,42,'Heavy Armor Mastery',250000,66),
(3,116,10,'Howl',500000,66),
(3,290,10,'Final Frenzy',500000,66),
(3,211,8,'Boost HP',500000,66),
(3,424,2,'War Frenzy',500000,66),
(3,312,16,'Vicious Stance',500000,66),
(3,317,4,'Focus Attack',500000,66),
(3,422,2,'Polearm Accuracy',500000,66),
(3,421,3,'Fell Swoop',500000,66),
(3,320,1,'Wrath',250000,66),
(3,320,2,'Wrath',250000,66),
(3,920,30,'Power Crush',330000,68),
(3,920,31,'Power Crush',330000,68),
(3,320,3,'Wrath',350000,68),
(3,320,4,'Wrath',350000,68),
(3,312,17,'Vicious Stance',710000,68),
(3,452,4,'Shock Stomp',710000,68),
(3,212,7,'Fast HP Recovery',710000,68),
(3,290,11,'Final Frenzy',710000,68),
(3,116,11,'Howl',710000,68),
(3,231,43,'Heavy Armor Mastery',350000,68),
(3,231,44,'Heavy Armor Mastery',350000,68),
(3,227,43,'Light Armor Mastery',350000,68),
(3,227,44,'Light Armor Mastery',350000,68),
(3,216,38,'Polearm Mastery',350000,68),
(3,216,39,'Polearm Mastery',350000,68),
(3,48,30,'Thunder Storm',350000,68),
(3,48,31,'Thunder Storm',350000,68),
(3,36,30,'Whirlwind',350000,68),
(3,36,31,'Whirlwind',350000,68),
(3,920,32,'Power Crush',360000,70),
(3,920,33,'Power Crush',360000,70),
(3,36,32,'Whirlwind',390000,70),
(3,36,33,'Whirlwind',390000,70),
(3,48,32,'Thunder Storm',390000,70),
(3,48,33,'Thunder Storm',390000,70),
(3,216,40,'Polearm Mastery',390000,70),
(3,216,41,'Polearm Mastery',390000,70),
(3,227,45,'Light Armor Mastery',390000,70),
(3,227,46,'Light Armor Mastery',390000,70),
(3,231,45,'Heavy Armor Mastery',390000,70),
(3,231,46,'Heavy Armor Mastery',390000,70),
(3,116,12,'Howl',780000,70),
(3,121,6,'Battle Roar',780000,70),
(3,290,12,'Final Frenzy',780000,70),
(3,211,9,'Boost HP',780000,70),
(3,312,18,'Vicious Stance',780000,70),
(3,320,5,'Wrath',390000,70),
(3,320,6,'Wrath',390000,70),
(3,421,4,'Fell Swoop',780000,70),
(3,920,34,'Power Crush',550000,72),
(3,920,35,'Power Crush',550000,72),
(3,320,7,'Wrath',600000,72),
(3,320,8,'Wrath',600000,72),
(3,312,19,'Vicious Stance',1200000,72),
(3,452,5,'Shock Stomp',1200000,72),
(3,290,13,'Final Frenzy',1200000,72),
(3,116,13,'Howl',1200000,72),
(3,231,47,'Heavy Armor Mastery',600000,72),
(3,231,48,'Heavy Armor Mastery',600000,72),
(3,227,47,'Light Armor Mastery',600000,72),
(3,227,48,'Light Armor Mastery',600000,72),
(3,216,42,'Polearm Mastery',600000,72),
(3,216,43,'Polearm Mastery',600000,72),
(3,48,34,'Thunder Storm',600000,72),
(3,48,35,'Thunder Storm',600000,72),
(3,36,34,'Whirlwind',600000,72),
(3,36,35,'Whirlwind',600000,72),
(3,920,36,'Power Crush',810000,74),
(3,920,37,'Power Crush',810000,74),
(3,36,36,'Whirlwind',870000,74),
(3,36,37,'Whirlwind',870000,74),
(3,48,36,'Thunder Storm',870000,74),
(3,48,37,'Thunder Storm',870000,74),
(3,216,44,'Polearm Mastery',870000,74),
(3,216,45,'Polearm Mastery',870000,74),
(3,227,49,'Light Armor Mastery',870000,74),
(3,227,50,'Light Armor Mastery',870000,74),
(3,231,49,'Heavy Armor Mastery',870000,74),
(3,231,50,'Heavy Armor Mastery',870000,74),
(3,116,14,'Howl',1700000,74),
(3,290,14,'Final Frenzy',1700000,74),
(3,211,10,'Boost HP',1700000,74),
(3,212,8,'Fast HP Recovery',1700000,74),
(3,424,3,'War Frenzy',1700000,74),
(3,312,20,'Vicious Stance',1700000,74),
(3,317,5,'Focus Attack',1700000,74),
(3,320,9,'Wrath',870000,74),
(3,320,10,'Wrath',870000,74),
(3,421,5,'Fell Swoop',1700000,74),
(3,422,3,'Polearm Accuracy',1700000,74),
(4,82,1,'Majesty',4700,20),
(4,92,1,'Shield Stun',1500,20),
(4,92,2,'Shield Stun',1500,20),
(4,92,3,'Shield Stun',1500,20),
(4,70,1,'Drain Health',2300,20),
(4,70,2,'Drain Health',2300,20),
(4,147,1,'Magic Resistance',2300,20),
(4,147,2,'Magic Resistance',2300,20),
(4,217,1,'Sword/Blunt Weapon Mastery',4700,20),
(4,232,1,'Heavy Armor Mastery',1500,20),
(4,232,2,'Heavy Armor Mastery',1500,20),
(4,232,3,'Heavy Armor Mastery',1500,20),
(4,110,1,'Ultimate Defense',4700,20),
(4,153,1,'Shield Mastery',4700,20),
(4,112,1,'Deflect Arrow',10000,24),
(4,232,4,'Heavy Armor Mastery',3300,24),
(4,232,5,'Heavy Armor Mastery',3300,24),
(4,232,6,'Heavy Armor Mastery',3300,24),
(4,217,2,'Sword/Blunt Weapon Mastery',10000,24),
(4,147,3,'Magic Resistance',3300,24),
(4,147,4,'Magic Resistance',3300,24),
(4,147,5,'Magic Resistance',3300,24),
(4,70,3,'Drain Health',5000,24),
(4,70,4,'Drain Health',5000,24),
(4,92,4,'Shield Stun',3300,24),
(4,92,5,'Shield Stun',3300,24),
(4,92,6,'Shield Stun',3300,24),
(4,28,1,'Aggression',3300,24),
(4,28,2,'Aggression',3300,24),
(4,28,3,'Aggression',3300,24),
(4,28,4,'Aggression',4000,28),
(4,28,5,'Aggression',4000,28),
(4,28,6,'Aggression',4000,28),
(4,45,1,'Divine Heal',4000,28),
(4,45,2,'Divine Heal',4000,28),
(4,45,3,'Divine Heal',4000,28),
(4,92,7,'Shield Stun',4000,28),
(4,92,8,'Shield Stun',4000,28),
(4,92,9,'Shield Stun',4000,28),
(4,70,5,'Drain Health',4000,28),
(4,70,6,'Drain Health',4000,28),
(4,70,7,'Drain Health',4000,28),
(4,147,6,'Magic Resistance',4000,28),
(4,147,7,'Magic Resistance',4000,28),
(4,147,8,'Magic Resistance',4000,28),
(4,217,3,'Sword/Blunt Weapon Mastery',6000,28),
(4,217,4,'Sword/Blunt Weapon Mastery',6000,28),
(4,232,7,'Heavy Armor Mastery',4000,28),
(4,232,8,'Heavy Armor Mastery',4000,28),
(4,232,9,'Heavy Armor Mastery',4000,28),
(4,153,2,'Shield Mastery',12000,28),
(4,112,2,'Deflect Arrow',25000,32),
(4,232,10,'Heavy Armor Mastery',8300,32),
(4,232,11,'Heavy Armor Mastery',8300,32),
(4,232,12,'Heavy Armor Mastery',8300,32),
(4,217,5,'Sword/Blunt Weapon Mastery',13000,32),
(4,217,6,'Sword/Blunt Weapon Mastery',13000,32),
(4,147,9,'Magic Resistance',8300,32),
(4,147,10,'Magic Resistance',8300,32),
(4,147,11,'Magic Resistance',8300,32),
(4,70,8,'Drain Health',8300,32),
(4,70,9,'Drain Health',8300,32),
(4,70,10,'Drain Health',8300,32),
(4,92,10,'Shield Stun',8300,32),
(4,92,11,'Shield Stun',8300,32),
(4,92,12,'Shield Stun',8300,32),
(4,45,4,'Divine Heal',8300,32),
(4,45,5,'Divine Heal',8300,32),
(4,45,6,'Divine Heal',8300,32),
(4,28,7,'Aggression',8300,32),
(4,28,8,'Aggression',8300,32),
(4,28,9,'Aggression',8300,32),
(4,28,10,'Aggression',13000,36),
(4,28,11,'Aggression',13000,36),
(4,28,12,'Aggression',13000,36),
(4,45,7,'Divine Heal',13000,36),
(4,45,8,'Divine Heal',13000,36),
(4,45,9,'Divine Heal',13000,36),
(4,92,13,'Shield Stun',13000,36),
(4,92,14,'Shield Stun',13000,36),
(4,92,15,'Shield Stun',13000,36),
(4,70,11,'Drain Health',13000,36),
(4,70,12,'Drain Health',13000,36),
(4,70,13,'Drain Health',13000,36),
(4,147,12,'Magic Resistance',13000,36),
(4,147,13,'Magic Resistance',13000,36),
(4,147,14,'Magic Resistance',13000,36),
(4,217,7,'Sword/Blunt Weapon Mastery',19000,36),
(4,217,8,'Sword/Blunt Weapon Mastery',19000,36),
(4,232,13,'Heavy Armor Mastery',13000,36),
(4,232,14,'Heavy Armor Mastery',13000,36),
(4,232,15,'Heavy Armor Mastery',13000,36),
(4,191,1,'Focus Mind',39000,36),
(5,18,1,'Aura of Hate',12000,40),
(5,18,2,'Aura of Hate',12000,40),
(5,18,3,'Aura of Hate',12000,40),
(5,28,13,'Aggression',12000,40),
(5,28,14,'Aggression',12000,40),
(5,28,15,'Aggression',12000,40),
(5,92,16,'Shield Stun',12000,40),
(5,92,17,'Shield Stun',12000,40),
(5,92,18,'Shield Stun',12000,40),
(5,147,15,'Magic Resistance',12000,40),
(5,147,16,'Magic Resistance',12000,40),
(5,147,17,'Magic Resistance',12000,40),
(5,217,9,'Sword/Blunt Weapon Mastery',12000,40),
(5,217,10,'Sword/Blunt Weapon Mastery',12000,40),
(5,217,11,'Sword/Blunt Weapon Mastery',12000,40),
(5,232,16,'Heavy Armor Mastery',12000,40),
(5,232,17,'Heavy Armor Mastery',12000,40),
(5,232,18,'Heavy Armor Mastery',12000,40),
(5,262,1,'Holy Blessing',12000,40),
(5,262,2,'Holy Blessing',12000,40),
(5,262,3,'Holy Blessing',12000,40),
(5,44,1,'Remedy',35000,40),
(5,82,2,'Majesty',35000,40),
(5,153,3,'Shield Mastery',35000,40),
(5,197,1,'Holy Armor',35000,40),
(5,196,1,'Holy Blade',38000,43),
(5,191,2,'Focus Mind',38000,43),
(5,112,3,'Deflect Arrow',38000,43),
(5,72,1,'Iron Will',38000,43),
(5,262,4,'Holy Blessing',13000,43),
(5,262,5,'Holy Blessing',13000,43),
(5,262,6,'Holy Blessing',13000,43),
(5,232,19,'Heavy Armor Mastery',13000,43),
(5,232,20,'Heavy Armor Mastery',13000,43),
(5,232,21,'Heavy Armor Mastery',13000,43),
(5,217,12,'Sword/Blunt Weapon Mastery',13000,43),
(5,217,13,'Sword/Blunt Weapon Mastery',13000,43),
(5,217,14,'Sword/Blunt Weapon Mastery',13000,43),
(5,147,18,'Magic Resistance',13000,43),
(5,147,19,'Magic Resistance',13000,43),
(5,147,20,'Magic Resistance',13000,43),
(5,92,19,'Shield Stun',13000,43),
(5,92,20,'Shield Stun',13000,43),
(5,92,21,'Shield Stun',13000,43),
(5,28,16,'Aggression',13000,43),
(5,28,17,'Aggression',13000,43),
(5,28,18,'Aggression',13000,43),
(5,810,1,'Vanguard',114000,43),
(5,18,4,'Aura of Hate',13000,43),
(5,18,5,'Aura of Hate',13000,43),
(5,18,6,'Aura of Hate',13000,43),
(5,18,7,'Aura of Hate',18000,46),
(5,18,8,'Aura of Hate',18000,46),
(5,18,9,'Aura of Hate',18000,46),
(5,28,19,'Aggression',18000,46),
(5,28,20,'Aggression',18000,46),
(5,28,21,'Aggression',18000,46),
(5,92,22,'Shield Stun',18000,46),
(5,92,23,'Shield Stun',18000,46),
(5,92,24,'Shield Stun',18000,46),
(5,49,1,'Holy Strike',27000,46),
(5,49,2,'Holy Strike',27000,46),
(5,147,21,'Magic Resistance',18000,46),
(5,147,22,'Magic Resistance',18000,46),
(5,147,23,'Magic Resistance',18000,46),
(5,217,15,'Sword/Blunt Weapon Mastery',18000,46),
(5,217,16,'Sword/Blunt Weapon Mastery',18000,46),
(5,217,17,'Sword/Blunt Weapon Mastery',18000,46),
(5,232,22,'Heavy Armor Mastery',18000,46),
(5,232,23,'Heavy Armor Mastery',18000,46),
(5,232,24,'Heavy Armor Mastery',18000,46),
(5,262,7,'Holy Blessing',18000,46),
(5,262,8,'Holy Blessing',18000,46),
(5,262,9,'Holy Blessing',18000,46),
(5,110,2,'Ultimate Defense',55000,46),
(5,318,1,'Aegis Stance',55000,46),
(5,197,2,'Holy Armor',55000,46),
(5,191,3,'Focus Mind',82000,49),
(5,72,2,'Iron Will',82000,49),
(5,44,2,'Remedy',82000,49),
(5,112,4,'Deflect Arrow',82000,49),
(5,262,10,'Holy Blessing',27000,49),
(5,262,11,'Holy Blessing',27000,49),
(5,262,12,'Holy Blessing',27000,49),
(5,232,25,'Heavy Armor Mastery',27000,49),
(5,232,26,'Heavy Armor Mastery',27000,49),
(5,232,27,'Heavy Armor Mastery',27000,49),
(5,217,18,'Sword/Blunt Weapon Mastery',27000,49),
(5,217,19,'Sword/Blunt Weapon Mastery',27000,49),
(5,217,20,'Sword/Blunt Weapon Mastery',27000,49),
(5,147,24,'Magic Resistance',27000,49),
(5,147,25,'Magic Resistance',27000,49),
(5,147,26,'Magic Resistance',27000,49),
(5,49,3,'Holy Strike',41000,49),
(5,49,4,'Holy Strike',41000,49),
(5,92,25,'Shield Stun',27000,49),
(5,92,26,'Shield Stun',27000,49),
(5,92,27,'Shield Stun',27000,49),
(5,28,22,'Aggression',27000,49),
(5,28,23,'Aggression',27000,49),
(5,28,24,'Aggression',27000,49),
(5,18,10,'Aura of Hate',27000,49),
(5,18,11,'Aura of Hate',27000,49),
(5,18,12,'Aura of Hate',27000,49),
(5,18,13,'Aura of Hate',42000,52),
(5,18,14,'Aura of Hate',42000,52),
(5,18,15,'Aura of Hate',42000,52),
(5,28,25,'Aggression',42000,52),
(5,28,26,'Aggression',42000,52),
(5,28,27,'Aggression',42000,52),
(5,92,28,'Shield Stun',42000,52),
(5,92,29,'Shield Stun',42000,52),
(5,92,30,'Shield Stun',42000,52),
(5,49,5,'Holy Strike',63000,52),
(5,49,6,'Holy Strike',63000,52),
(5,69,1,'Sacrifice',42000,52),
(5,69,2,'Sacrifice',42000,52),
(5,69,3,'Sacrifice',42000,52),
(5,147,27,'Magic Resistance',42000,52),
(5,147,28,'Magic Resistance',42000,52),
(5,147,29,'Magic Resistance',42000,52),
(5,217,21,'Sword/Blunt Weapon Mastery',42000,52),
(5,217,22,'Sword/Blunt Weapon Mastery',42000,52),
(5,217,23,'Sword/Blunt Weapon Mastery',42000,52),
(5,232,28,'Heavy Armor Mastery',42000,52),
(5,232,29,'Heavy Armor Mastery',42000,52),
(5,232,30,'Heavy Armor Mastery',42000,52),
(5,262,13,'Holy Blessing',42000,52),
(5,262,14,'Holy Blessing',42000,52),
(5,262,15,'Holy Blessing',42000,52),
(5,97,1,'Sanctuary',125000,52),
(5,153,4,'Shield Mastery',125000,52),
(5,291,1,'Final Fortress',125000,52),
(5,291,2,'Final Fortress',138000,55),
(5,191,4,'Focus Mind',138000,55),
(5,97,2,'Sanctuary',138000,55),
(5,72,3,'Iron Will',138000,55),
(5,405,1,'Banish Undead',138000,55),
(5,400,1,'Tribunal',138000,55),
(5,403,1,'Shackle',138000,55),
(5,262,16,'Holy Blessing',46000,55),
(5,262,17,'Holy Blessing',46000,55),
(5,262,18,'Holy Blessing',46000,55),
(5,232,31,'Heavy Armor Mastery',46000,55),
(5,232,32,'Heavy Armor Mastery',46000,55),
(5,232,33,'Heavy Armor Mastery',46000,55),
(5,217,24,'Sword/Blunt Weapon Mastery',46000,55),
(5,217,25,'Sword/Blunt Weapon Mastery',46000,55),
(5,217,26,'Sword/Blunt Weapon Mastery',46000,55),
(5,147,30,'Magic Resistance',46000,55),
(5,147,31,'Magic Resistance',46000,55),
(5,147,32,'Magic Resistance',46000,55),
(5,69,4,'Sacrifice',46000,55),
(5,69,5,'Sacrifice',46000,55),
(5,69,6,'Sacrifice',46000,55),
(5,49,7,'Holy Strike',69000,55),
(5,49,8,'Holy Strike',69000,55),
(5,92,31,'Shield Stun',46000,55),
(5,92,32,'Shield Stun',46000,55),
(5,92,33,'Shield Stun',46000,55),
(5,28,28,'Aggression',46000,55),
(5,28,29,'Aggression',46000,55),
(5,28,30,'Aggression',46000,55),
(5,18,16,'Aura of Hate',46000,55),
(5,18,17,'Aura of Hate',46000,55),
(5,18,18,'Aura of Hate',46000,55),
(5,18,19,'Aura of Hate',67000,58),
(5,18,20,'Aura of Hate',67000,58),
(5,18,21,'Aura of Hate',67000,58),
(5,28,31,'Aggression',67000,58),
(5,28,32,'Aggression',67000,58),
(5,28,33,'Aggression',67000,58),
(5,92,34,'Shield Stun',67000,58),
(5,92,35,'Shield Stun',67000,58),
(5,92,36,'Shield Stun',67000,58),
(5,49,9,'Holy Strike',71000,58),
(5,49,10,'Holy Strike',71000,58),
(5,69,7,'Sacrifice',67000,58),
(5,69,8,'Sacrifice',67000,58),
(5,69,9,'Sacrifice',67000,58),
(5,147,33,'Magic Resistance',67000,58),
(5,147,34,'Magic Resistance',67000,58),
(5,147,35,'Magic Resistance',67000,58),
(5,217,27,'Sword/Blunt Weapon Mastery',47000,58),
(5,217,28,'Sword/Blunt Weapon Mastery',67000,58),
(5,217,29,'Sword/Blunt Weapon Mastery',67000,58),
(5,232,34,'Heavy Armor Mastery',67000,58),
(5,232,35,'Heavy Armor Mastery',67000,58),
(5,232,36,'Heavy Armor Mastery',67000,58),
(5,262,19,'Holy Blessing',67000,58),
(5,262,20,'Holy Blessing',67000,58),
(5,262,21,'Holy Blessing',67000,58),
(5,403,2,'Shackle',141000,58),
(5,400,2,'Tribunal',141000,58),
(5,405,2,'Banish Undead',141000,58),
(5,404,1,'Mass Shackling',141000,58),
(5,82,3,'Majesty',141000,58),
(5,97,3,'Sanctuary',141000,58),
(5,291,3,'Final Fortress',141000,58),
(5,406,1,'Angelic Icon',141000,58),
(5,916,1,'Shield Deflect Magic',193000,60),
(5,291,4,'Final Fortress',207000,60),
(5,97,4,'Sanctuary',207000,60),
(5,405,3,'Banish Undead',207000,60),
(5,400,3,'Tribunal',207000,60),
(5,403,3,'Shackle',207000,60),
(5,262,22,'Holy Blessing',104000,60),
(5,262,23,'Holy Blessing',104000,60),
(5,232,37,'Heavy Armor Mastery',104000,60),
(5,232,38,'Heavy Armor Mastery',104000,60),
(5,217,30,'Sword/Blunt Weapon Mastery',104000,60),
(5,217,31,'Sword/Blunt Weapon Mastery',104000,60),
(5,147,36,'Magic Resistance',104000,60),
(5,147,37,'Magic Resistance',104000,60),
(5,69,10,'Sacrifice',104000,60),
(5,69,11,'Sacrifice',104000,60),
(5,49,11,'Holy Strike',104000,60),
(5,49,12,'Holy Strike',104000,60),
(5,92,37,'Shield Stun',104000,60),
(5,92,38,'Shield Stun',104000,60),
(5,28,34,'Aggression',104000,60),
(5,28,35,'Aggression',104000,60),
(5,18,22,'Aura of Hate',104000,60),
(5,18,23,'Aura of Hate',104000,60),
(5,18,24,'Aura of Hate',130000,62),
(5,18,25,'Aura of Hate',130000,62),
(5,28,36,'Aggression',130000,62),
(5,28,37,'Aggression',130000,62),
(5,92,39,'Shield Stun',130000,62),
(5,92,40,'Shield Stun',130000,62),
(5,49,13,'Holy Strike',130000,62),
(5,49,14,'Holy Strike',130000,62),
(5,69,12,'Sacrifice',130000,62),
(5,69,13,'Sacrifice',130000,62),
(5,147,38,'Magic Resistance',130000,62),
(5,147,39,'Magic Resistance',130000,62),
(5,217,32,'Sword/Blunt Weapon Mastery',130000,62),
(5,217,33,'Sword/Blunt Weapon Mastery',130000,62),
(5,232,39,'Heavy Armor Mastery',130000,62),
(5,232,40,'Heavy Armor Mastery',130000,62),
(5,262,24,'Holy Blessing',130000,62),
(5,262,25,'Holy Blessing',130000,62),
(5,403,4,'Shackle',250000,62),
(5,400,4,'Tribunal',250000,62),
(5,405,4,'Banish Undead',250000,62),
(5,404,2,'Mass Shackling',250000,62),
(5,97,5,'Sanctuary',250000,62),
(5,44,3,'Remedy',250000,62),
(5,291,5,'Final Fortress',250000,62),
(5,916,2,'Shield Deflect Magic',280000,64),
(5,291,6,'Final Fortress',300000,64),
(5,191,5,'Focus Mind',300000,64),
(5,97,6,'Sanctuary',300000,64),
(5,322,1,'Shield Fortress',300000,64),
(5,405,5,'Banish Undead',300000,64),
(5,400,5,'Tribunal',300000,64),
(5,403,5,'Shackle',300000,64),
(5,262,26,'Holy Blessing',150000,64),
(5,262,27,'Holy Blessing',150000,64),
(5,232,41,'Heavy Armor Mastery',150000,64),
(5,232,42,'Heavy Armor Mastery',150000,64),
(5,217,34,'Sword/Blunt Weapon Mastery',150000,64),
(5,217,35,'Sword/Blunt Weapon Mastery',150000,64),
(5,147,40,'Magic Resistance',150000,64),
(5,147,41,'Magic Resistance',150000,64),
(5,69,14,'Sacrifice',150000,64),
(5,69,15,'Sacrifice',150000,64),
(5,49,15,'Holy Strike',150000,64),
(5,49,16,'Holy Strike',150000,64),
(5,92,41,'Shield Stun',150000,64),
(5,92,42,'Shield Stun',150000,64),
(5,28,38,'Aggression',150000,64),
(5,28,39,'Aggression',150000,64),
(5,18,26,'Aura of Hate',150000,64),
(5,18,27,'Aura of Hate',150000,64),
(5,18,28,'Aura of Hate',210000,66),
(5,18,29,'Aura of Hate',210000,66),
(5,28,40,'Aggression',210000,66),
(5,28,41,'Aggression',210000,66),
(5,92,43,'Shield Stun',210000,66),
(5,92,44,'Shield Stun',210000,66),
(5,49,17,'Holy Strike',210000,66),
(5,49,18,'Holy Strike',210000,66),
(5,69,16,'Sacrifice',210000,66),
(5,69,17,'Sacrifice',210000,66),
(5,147,42,'Magic Resistance',210000,66),
(5,147,43,'Magic Resistance',210000,66),
(5,217,36,'Sword/Blunt Weapon Mastery',210000,66),
(5,217,37,'Sword/Blunt Weapon Mastery',210000,66),
(5,232,43,'Heavy Armor Mastery',210000,66),
(5,232,44,'Heavy Armor Mastery',210000,66),
(5,262,28,'Holy Blessing',210000,66),
(5,262,29,'Holy Blessing',210000,66),
(5,403,6,'Shackle',410000,66),
(5,400,6,'Tribunal',410000,66),
(5,405,6,'Banish Undead',410000,66),
(5,322,2,'Shield Fortress',410000,66),
(5,404,3,'Mass Shackling',410000,66),
(5,97,7,'Sanctuary',410000,66),
(5,291,7,'Final Fortress',410000,66),
(5,406,2,'Angelic Icon',410000,66),
(5,916,3,'Shield Deflect Magic',490000,68),
(5,291,8,'Final Fortress',520000,68),
(5,97,8,'Sanctuary',520000,68),
(5,322,3,'Shield Fortress',520000,68),
(5,405,7,'Banish Undead',520000,68),
(5,400,7,'Tribunal',520000,68),
(5,403,7,'Shackle',520000,68),
(5,262,30,'Holy Blessing',260000,68),
(5,262,31,'Holy Blessing',260000,68),
(5,232,45,'Heavy Armor Mastery',260000,68),
(5,232,46,'Heavy Armor Mastery',260000,68),
(5,217,38,'Sword/Blunt Weapon Mastery',260000,68),
(5,217,39,'Sword/Blunt Weapon Mastery',260000,68),
(5,147,44,'Magic Resistance',260000,68),
(5,147,45,'Magic Resistance',260000,68),
(5,69,18,'Sacrifice',260000,68),
(5,69,19,'Sacrifice',260000,68),
(5,49,19,'Holy Strike',260000,68),
(5,49,20,'Holy Strike',260000,68),
(5,92,45,'Shield Stun',260000,68),
(5,92,46,'Shield Stun',260000,68),
(5,28,42,'Aggression',260000,68),
(5,28,43,'Aggression',260000,68),
(5,18,30,'Aura of Hate',260000,68),
(5,18,31,'Aura of Hate',260000,68),
(5,18,32,'Aura of Hate',290000,70),
(5,18,33,'Aura of Hate',290000,70),
(5,28,44,'Aggression',290000,70),
(5,28,45,'Aggression',290000,70),
(5,92,47,'Shield Stun',290000,70),
(5,92,48,'Shield Stun',290000,70),
(5,49,21,'Holy Strike',290000,70),
(5,49,22,'Holy Strike',290000,70),
(5,69,20,'Sacrifice',290000,70),
(5,69,21,'Sacrifice',290000,70),
(5,147,46,'Magic Resistance',290000,70),
(5,147,47,'Magic Resistance',290000,70),
(5,217,40,'Sword/Blunt Weapon Mastery',290000,70),
(5,217,41,'Sword/Blunt Weapon Mastery',290000,70),
(5,232,47,'Heavy Armor Mastery',290000,70),
(5,232,48,'Heavy Armor Mastery',290000,70),
(5,262,32,'Holy Blessing',290000,70),
(5,262,33,'Holy Blessing',290000,70),
(5,403,8,'Shackle',580000,70),
(5,400,8,'Tribunal',580000,70),
(5,405,8,'Banish Undead',580000,70),
(5,322,4,'Shield Fortress',580000,70),
(5,404,4,'Mass Shackling',580000,70),
(5,97,9,'Sanctuary',580000,70),
(5,291,9,'Final Fortress',580000,70),
(5,916,4,'Shield Deflect Magic',720000,72),
(5,291,10,'Final Fortress',750000,72),
(5,191,6,'Focus Mind',750000,72),
(5,97,10,'Sanctuary',750000,72),
(5,322,5,'Shield Fortress',750000,72),
(5,405,9,'Banish Undead',750000,72),
(5,400,9,'Tribunal',750000,72),
(5,403,9,'Shackle',750000,72),
(5,262,34,'Holy Blessing',380000,72),
(5,262,35,'Holy Blessing',380000,72),
(5,232,49,'Heavy Armor Mastery',380000,72),
(5,232,50,'Heavy Armor Mastery',380000,72),
(5,217,42,'Sword/Blunt Weapon Mastery',380000,72),
(5,217,43,'Sword/Blunt Weapon Mastery',380000,72),
(5,147,48,'Magic Resistance',380000,72),
(5,147,49,'Magic Resistance',380000,72),
(5,69,22,'Sacrifice',380000,72),
(5,69,23,'Sacrifice',380000,72),
(5,49,23,'Holy Strike',380000,72),
(5,49,24,'Holy Strike',380000,72),
(5,92,49,'Shield Stun',380000,72),
(5,92,50,'Shield Stun',380000,72),
(5,28,46,'Aggression',380000,72),
(5,28,47,'Aggression',380000,72),
(5,18,34,'Aura of Hate',380000,72),
(5,18,35,'Aura of Hate',380000,72),
(5,18,36,'Aura of Hate',760000,74),
(5,18,37,'Aura of Hate',760000,74),
(5,28,48,'Aggression',760000,74),
(5,28,49,'Aggression',760000,74),
(5,92,51,'Shield Stun',760000,74),
(5,92,52,'Shield Stun',760000,74),
(5,49,25,'Holy Strike',760000,74),
(5,49,26,'Holy Strike',760000,74),
(5,69,24,'Sacrifice',760000,74),
(5,69,25,'Sacrifice',760000,74),
(5,147,50,'Magic Resistance',760000,74),
(5,147,51,'Magic Resistance',760000,74),
(5,217,44,'Sword/Blunt Weapon Mastery',760000,74),
(5,217,45,'Sword/Blunt Weapon Mastery',760000,74),
(5,232,51,'Heavy Armor Mastery',760000,74),
(5,232,52,'Heavy Armor Mastery',760000,74),
(5,262,36,'Holy Blessing',760000,74),
(5,262,37,'Holy Blessing',760000,74),
(5,403,10,'Shackle',1530000,74),
(5,400,10,'Tribunal',1530000,74),
(5,405,10,'Banish Undead',1530000,74),
(5,322,6,'Shield Fortress',1530000,74),
(5,404,5,'Mass Shackling',1530000,74),
(5,97,11,'Sanctuary',1530000,74),
(5,291,11,'Final Fortress',1530000,74),
(5,406,3,'Angelic Icon',1530000,74),
(6,18,1,'Aura of Hate',10000,40),
(6,18,2,'Aura of Hate',10000,40),
(6,18,3,'Aura of Hate',10000,40),
(6,28,13,'Aggression',10000,40),
(6,28,14,'Aggression',10000,40),
(6,28,15,'Aggression',10000,40),
(6,70,14,'Drain Health',10000,40),
(6,70,15,'Drain Health',10000,40),
(6,70,16,'Drain Health',10000,40),
(6,70,17,'Drain Health',10000,40),
(6,70,18,'Drain Health',10000,40),
(6,70,19,'Drain Health',10000,40),
(6,92,16,'Shield Stun',10000,40),
(6,92,17,'Shield Stun',10000,40),
(6,92,18,'Shield Stun',10000,40),
(6,46,1,'Life Scavenge',30000,40),
(6,82,2,'Majesty',30000,40),
(6,147,15,'Magic Resistance',10000,40),
(6,147,16,'Magic Resistance',10000,40),
(6,147,17,'Magic Resistance',10000,40),
(6,217,9,'Sword/Blunt Weapon Mastery',10000,40),
(6,217,10,'Sword/Blunt Weapon Mastery',10000,40),
(6,217,11,'Sword/Blunt Weapon Mastery',10000,40),
(6,232,16,'Heavy Armor Mastery',10000,40),
(6,232,17,'Heavy Armor Mastery',10000,40),
(6,232,18,'Heavy Armor Mastery',10000,40),
(6,86,1,'Reflect Damage',30000,40),
(6,283,1,'Summon Dark Panther',30000,40),
(6,153,3,'Shield Mastery',30000,40),
(6,112,3,'Deflect Arrow',35000,43),
(6,191,2,'Focus Mind',35000,43),
(6,232,19,'Heavy Armor Mastery',12000,43),
(6,232,20,'Heavy Armor Mastery',12000,43),
(6,232,21,'Heavy Armor Mastery',12000,43),
(6,217,12,'Sword/Blunt Weapon Mastery',12000,43),
(6,217,13,'Sword/Blunt Weapon Mastery',12000,43),
(6,217,14,'Sword/Blunt Weapon Mastery',12000,43),
(6,147,18,'Magic Resistance',12000,43),
(6,147,19,'Magic Resistance',12000,43),
(6,147,20,'Magic Resistance',12000,43),
(6,72,1,'Iron Will',35000,43),
(6,127,1,'Hamstring',35000,43),
(6,46,2,'Life Scavenge',35000,43),
(6,92,19,'Shield Stun',12000,43),
(6,92,20,'Shield Stun',12000,43),
(6,92,21,'Shield Stun',12000,43),
(6,70,20,'Drain Health',12000,43),
(6,70,21,'Drain Health',12000,43),
(6,70,22,'Drain Health',12000,43),
(6,28,16,'Aggression',12000,43),
(6,28,17,'Aggression',12000,43),
(6,28,18,'Aggression',12000,43),
(6,811,1,'Vanguard',105000,43),
(6,18,4,'Aura of Hate',12000,43),
(6,18,5,'Aura of Hate',12000,43),
(6,18,6,'Aura of Hate',12000,43),
(6,18,7,'Aura of Hate',15000,46),
(6,18,8,'Aura of Hate',15000,46),
(6,18,9,'Aura of Hate',15000,46),
(6,28,19,'Aggression',15000,46),
(6,28,20,'Aggression',15000,46),
(6,28,21,'Aggression',15000,46),
(6,70,23,'Drain Health',15000,46),
(6,70,24,'Drain Health',15000,46),
(6,70,25,'Drain Health',15000,46),
(6,92,22,'Shield Stun',15000,46),
(6,92,23,'Shield Stun',15000,46),
(6,92,24,'Shield Stun',15000,46),
(6,46,3,'Life Scavenge',46000,46),
(6,65,1,'Horror',46000,46),
(6,127,2,'Hamstring',46000,46),
(6,103,1,'Corpse Plague',46000,46),
(6,147,21,'Magic Resistance',15000,46),
(6,147,22,'Magic Resistance',15000,46),
(6,147,23,'Magic Resistance',15000,46),
(6,217,15,'Sword/Blunt Weapon Mastery',15000,46),
(6,217,16,'Sword/Blunt Weapon Mastery',15000,46),
(6,217,17,'Sword/Blunt Weapon Mastery',15000,46),
(6,232,22,'Heavy Armor Mastery',15000,46),
(6,232,23,'Heavy Armor Mastery',15000,46),
(6,232,24,'Heavy Armor Mastery',15000,46),
(6,86,2,'Reflect Damage',46000,46),
(6,110,2,'Ultimate Defense',46000,46),
(6,112,4,'Deflect Arrow',70000,49),
(6,191,3,'Focus Mind',70000,49),
(6,283,2,'Summon Dark Panther',70000,49),
(6,232,25,'Heavy Armor Mastery',23000,49),
(6,232,26,'Heavy Armor Mastery',23000,49),
(6,232,27,'Heavy Armor Mastery',23000,49),
(6,217,18,'Sword/Blunt Weapon Mastery',23000,49),
(6,217,19,'Sword/Blunt Weapon Mastery',23000,49),
(6,217,20,'Sword/Blunt Weapon Mastery',23000,49),
(6,147,24,'Magic Resistance',23000,49),
(6,147,25,'Magic Resistance',23000,49),
(6,147,26,'Magic Resistance',23000,49),
(6,72,2,'Iron Will',70000,49),
(6,127,3,'Hamstring',70000,49),
(6,65,2,'Horror',70000,49),
(6,46,4,'Life Scavenge',70000,49),
(6,92,25,'Shield Stun',23000,49),
(6,92,26,'Shield Stun',23000,49),
(6,92,27,'Shield Stun',23000,49),
(6,70,26,'Drain Health',23000,49),
(6,70,27,'Drain Health',23000,49),
(6,70,28,'Drain Health',23000,49),
(6,28,22,'Aggression',23000,49),
(6,28,23,'Aggression',23000,49),
(6,28,24,'Aggression',23000,49),
(6,18,10,'Aura of Hate',23000,49),
(6,18,11,'Aura of Hate',23000,49),
(6,18,12,'Aura of Hate',23000,49),
(6,18,13,'Aura of Hate',38000,52),
(6,18,14,'Aura of Hate',38000,52),
(6,18,15,'Aura of Hate',38000,52),
(6,28,25,'Aggression',38000,52),
(6,28,26,'Aggression',38000,52),
(6,28,27,'Aggression',38000,52),
(6,70,29,'Drain Health',38000,52),
(6,70,30,'Drain Health',38000,52),
(6,70,31,'Drain Health',38000,52),
(6,92,28,'Shield Stun',38000,52),
(6,92,29,'Shield Stun',38000,52),
(6,92,30,'Shield Stun',38000,52),
(6,46,5,'Life Scavenge',115000,52),
(6,65,3,'Horror',115000,52),
(6,127,4,'Hamstring',115000,52),
(6,147,27,'Magic Resistance',38000,52),
(6,147,28,'Magic Resistance',38000,52),
(6,147,29,'Magic Resistance',38000,52),
(6,217,21,'Sword/Blunt Weapon Mastery',38000,52),
(6,217,22,'Sword/Blunt Weapon Mastery',38000,52),
(6,217,23,'Sword/Blunt Weapon Mastery',38000,52),
(6,232,28,'Heavy Armor Mastery',38000,52),
(6,232,29,'Heavy Armor Mastery',38000,52),
(6,232,30,'Heavy Armor Mastery',38000,52),
(6,86,3,'Reflect Damage',115000,52),
(6,291,1,'Final Fortress',115000,52),
(6,153,4,'Shield Mastery',115000,52),
(6,403,1,'Shackle',138000,55),
(6,450,1,'Banish Seraph',138000,55),
(6,291,2,'Final Fortress',138000,55),
(6,191,4,'Focus Mind',138000,55),
(6,401,1,'Judgment',138000,55),
(6,232,31,'Heavy Armor Mastery',46000,55),
(6,232,32,'Heavy Armor Mastery',46000,55),
(6,232,33,'Heavy Armor Mastery',46000,55),
(6,217,24,'Sword/Blunt Weapon Mastery',46000,55),
(6,217,25,'Sword/Blunt Weapon Mastery',46000,55),
(6,217,26,'Sword/Blunt Weapon Mastery',46000,55),
(6,147,30,'Magic Resistance',46000,55),
(6,147,31,'Magic Resistance',46000,55),
(6,147,32,'Magic Resistance',46000,55),
(6,127,5,'Hamstring',138000,55),
(6,72,3,'Iron Will',138000,55),
(6,65,4,'Horror',138000,55),
(6,46,6,'Life Scavenge',138000,55),
(6,92,31,'Shield Stun',46000,55),
(6,92,32,'Shield Stun',46000,55),
(6,92,33,'Shield Stun',46000,55),
(6,70,32,'Drain Health',46000,55),
(6,70,33,'Drain Health',46000,55),
(6,70,34,'Drain Health',46000,55),
(6,28,28,'Aggression',46000,55),
(6,28,29,'Aggression',46000,55),
(6,28,30,'Aggression',46000,55),
(6,18,16,'Aura of Hate',46000,55),
(6,18,17,'Aura of Hate',46000,55),
(6,18,18,'Aura of Hate',46000,55),
(6,18,19,'Aura of Hate',47000,58),
(6,18,20,'Aura of Hate',47000,58),
(6,18,21,'Aura of Hate',47000,58),
(6,28,31,'Aggression',47000,58),
(6,28,32,'Aggression',47000,58),
(6,28,33,'Aggression',47000,58),
(6,70,35,'Drain Health',47000,58),
(6,70,36,'Drain Health',47000,58),
(6,70,37,'Drain Health',47000,58),
(6,92,34,'Shield Stun',47000,58),
(6,92,35,'Shield Stun',47000,58),
(6,92,36,'Shield Stun',47000,58),
(6,46,7,'Life Scavenge',141000,58),
(6,65,5,'Horror',141000,58),
(6,82,3,'Majesty',141000,58),
(6,103,2,'Corpse Plague',141000,58),
(6,127,6,'Hamstring',141000,58),
(6,147,33,'Magic Resistance',47000,58),
(6,147,34,'Magic Resistance',47000,58),
(6,147,35,'Magic Resistance',47000,58),
(6,217,27,'Sword/Blunt Weapon Mastery',47000,58),
(6,217,28,'Sword/Blunt Weapon Mastery',47000,58),
(6,217,29,'Sword/Blunt Weapon Mastery',47000,58),
(6,232,34,'Heavy Armor Mastery',47000,58),
(6,232,35,'Heavy Armor Mastery',47000,58),
(6,232,36,'Heavy Armor Mastery',47000,58),
(6,401,2,'Judgment',141000,58),
(6,283,3,'Summon Dark Panther',141000,58),
(6,291,3,'Final Fortress',141000,58),
(6,450,2,'Banish Seraph',141000,58),
(6,403,2,'Shackle',141000,58),
(6,916,1,'Shield Deflect Magic',193000,60),
(6,403,3,'Shackle',208000,60),
(6,450,3,'Banish Seraph',208000,60),
(6,291,4,'Final Fortress',208000,60),
(6,401,3,'Judgment',208000,60),
(6,232,37,'Heavy Armor Mastery',104000,60),
(6,232,38,'Heavy Armor Mastery',104000,60),
(6,217,30,'Sword/Blunt Weapon Mastery',104000,60),
(6,217,31,'Sword/Blunt Weapon Mastery',104000,60),
(6,147,36,'Magic Resistance',104000,60),
(6,147,37,'Magic Resistance',104000,60),
(6,127,7,'Hamstring',208000,60),
(6,65,6,'Horror',208000,60),
(6,46,8,'Life Scavenge',208000,60),
(6,92,37,'Shield Stun',104000,60),
(6,92,38,'Shield Stun',104000,60),
(6,70,38,'Drain Health',104000,60),
(6,70,39,'Drain Health',104000,60),
(6,28,34,'Aggression',104000,60),
(6,28,35,'Aggression',104000,60),
(6,18,22,'Aura of Hate',104000,60),
(6,18,23,'Aura of Hate',104000,60),
(6,18,24,'Aura of Hate',130000,62),
(6,18,25,'Aura of Hate',130000,62),
(6,28,36,'Aggression',130000,62),
(6,28,37,'Aggression',130000,62),
(6,70,40,'Drain Health',130000,62),
(6,70,41,'Drain Health',130000,62),
(6,92,39,'Shield Stun',130000,62),
(6,92,40,'Shield Stun',130000,62),
(6,46,9,'Life Scavenge',250000,62),
(6,65,7,'Horror',250000,62),
(6,127,8,'Hamstring',250000,62),
(6,103,3,'Corpse Plague',250000,62),
(6,147,38,'Magic Resistance',130000,62),
(6,147,39,'Magic Resistance',130000,62),
(6,217,32,'Sword/Blunt Weapon Mastery',130000,62),
(6,217,33,'Sword/Blunt Weapon Mastery',130000,62),
(6,232,39,'Heavy Armor Mastery',130000,62),
(6,232,40,'Heavy Armor Mastery',130000,62),
(6,401,4,'Judgment',250000,62),
(6,283,4,'Summon Dark Panther',250000,62),
(6,291,5,'Final Fortress',250000,62),
(6,450,4,'Banish Seraph',250000,62),
(6,403,4,'Shackle',250000,62),
(6,916,2,'Shield Deflect Magic',280000,64),
(6,403,5,'Shackle',300000,64),
(6,450,5,'Banish Seraph',300000,64),
(6,291,6,'Final Fortress',300000,64),
(6,191,5,'Focus Mind',300000,64),
(6,322,1,'Shield Fortress',300000,64),
(6,401,5,'Judgment',300000,64),
(6,232,41,'Heavy Armor Mastery',150000,64),
(6,232,42,'Heavy Armor Mastery',150000,64),
(6,217,34,'Sword/Blunt Weapon Mastery',150000,64),
(6,217,35,'Sword/Blunt Weapon Mastery',150000,64),
(6,147,40,'Magic Resistance',150000,64),
(6,147,41,'Magic Resistance',150000,64),
(6,127,9,'Hamstring',300000,64),
(6,65,8,'Horror',300000,64),
(6,46,10,'Life Scavenge',300000,64),
(6,92,41,'Shield Stun',150000,64),
(6,92,42,'Shield Stun',150000,64),
(6,70,42,'Drain Health',150000,64),
(6,70,43,'Drain Health',150000,64),
(6,28,38,'Aggression',150000,64),
(6,28,39,'Aggression',150000,64),
(6,18,26,'Aura of Hate',150000,64),
(6,18,27,'Aura of Hate',150000,64),
(6,18,28,'Aura of Hate',220000,66),
(6,18,29,'Aura of Hate',220000,66),
(6,28,40,'Aggression',220000,66),
(6,28,41,'Aggression',220000,66),
(6,70,44,'Drain Health',220000,66),
(6,70,45,'Drain Health',220000,66),
(6,92,43,'Shield Stun',220000,66),
(6,92,44,'Shield Stun',220000,66),
(6,46,11,'Life Scavenge',440000,66),
(6,65,9,'Horror',440000,66),
(6,127,10,'Hamstring',440000,66),
(6,147,42,'Magic Resistance',220000,66),
(6,147,43,'Magic Resistance',220000,66),
(6,217,36,'Sword/Blunt Weapon Mastery',220000,66),
(6,217,37,'Sword/Blunt Weapon Mastery',220000,66),
(6,232,43,'Heavy Armor Mastery',220000,66),
(6,232,44,'Heavy Armor Mastery',220000,66),
(6,401,6,'Judgment',440000,66),
(6,322,2,'Shield Fortress',440000,66),
(6,283,5,'Summon Dark Panther',440000,66),
(6,291,7,'Final Fortress',440000,66),
(6,450,6,'Banish Seraph',440000,66),
(6,403,6,'Shackle',440000,66),
(6,916,3,'Shield Deflect Magic',490000,68),
(6,403,7,'Shackle',520000,68),
(6,450,7,'Banish Seraph',520000,68),
(6,291,8,'Final Fortress',520000,68),
(6,322,3,'Shield Fortress',520000,68),
(6,401,7,'Judgment',520000,68),
(6,232,45,'Heavy Armor Mastery',260000,68),
(6,232,46,'Heavy Armor Mastery',260000,68),
(6,217,38,'Sword/Blunt Weapon Mastery',260000,68),
(6,217,39,'Sword/Blunt Weapon Mastery',260000,68),
(6,147,44,'Magic Resistance',260000,68),
(6,147,45,'Magic Resistance',260000,68),
(6,127,11,'Hamstring',520000,68),
(6,65,10,'Horror',520000,68),
(6,46,12,'Life Scavenge',520000,68),
(6,92,45,'Shield Stun',260000,68),
(6,92,46,'Shield Stun',260000,68),
(6,70,46,'Drain Health',260000,68),
(6,70,47,'Drain Health',260000,68),
(6,28,42,'Aggression',260000,68),
(6,28,43,'Aggression',260000,68),
(6,18,30,'Aura of Hate',260000,68),
(6,18,31,'Aura of Hate',260000,68),
(6,18,32,'Aura of Hate',270000,70),
(6,18,33,'Aura of Hate',270000,70),
(6,28,44,'Aggression',270000,70),
(6,28,45,'Aggression',270000,70),
(6,70,48,'Drain Health',270000,70),
(6,70,49,'Drain Health',270000,70),
(6,92,47,'Shield Stun',270000,70),
(6,92,48,'Shield Stun',270000,70),
(6,46,13,'Life Scavenge',550000,70),
(6,65,11,'Horror',550000,70),
(6,127,12,'Hamstring',550000,70),
(6,103,4,'Corpse Plague',550000,70),
(6,147,46,'Magic Resistance',270000,70),
(6,147,47,'Magic Resistance',270000,70),
(6,217,40,'Sword/Blunt Weapon Mastery',270000,70),
(6,217,41,'Sword/Blunt Weapon Mastery',270000,70),
(6,232,47,'Heavy Armor Mastery',270000,70),
(6,232,48,'Heavy Armor Mastery',270000,70),
(6,401,8,'Judgment',550000,70),
(6,322,4,'Shield Fortress',550000,70),
(6,283,6,'Summon Dark Panther',550000,70),
(6,291,9,'Final Fortress',550000,70),
(6,450,8,'Banish Seraph',550000,70),
(6,403,8,'Shackle',550000,70),
(6,916,4,'Shield Deflect Magic',720000,72),
(6,403,9,'Shackle',750000,72),
(6,450,9,'Banish Seraph',750000,72),
(6,291,10,'Final Fortress',750000,72),
(6,191,6,'Focus Mind',750000,72),
(6,322,5,'Shield Fortress',750000,72),
(6,401,9,'Judgment',750000,72),
(6,232,49,'Heavy Armor Mastery',380000,72),
(6,232,50,'Heavy Armor Mastery',380000,72),
(6,217,42,'Sword/Blunt Weapon Mastery',380000,72),
(6,217,43,'Sword/Blunt Weapon Mastery',380000,72),
(6,147,48,'Magic Resistance',380000,72),
(6,147,49,'Magic Resistance',380000,72),
(6,127,13,'Hamstring',750000,72),
(6,65,12,'Horror',750000,72),
(6,46,14,'Life Scavenge',750000,72),
(6,92,49,'Shield Stun',380000,72),
(6,92,50,'Shield Stun',380000,72),
(6,70,50,'Drain Health',380000,72),
(6,70,51,'Drain Health',380000,72),
(6,28,46,'Aggression',380000,72),
(6,28,47,'Aggression',380000,72),
(6,18,34,'Aura of Hate',380000,72),
(6,18,35,'Aura of Hate',380000,72),
(6,18,36,'Aura of Hate',810000,74),
(6,18,37,'Aura of Hate',810000,74),
(6,28,48,'Aggression',810000,74),
(6,28,49,'Aggression',810000,74),
(6,70,52,'Drain Health',810000,74),
(6,70,53,'Drain Health',810000,74),
(6,92,51,'Shield Stun',810000,74),
(6,92,52,'Shield Stun',810000,74),
(6,46,15,'Life Scavenge',1630000,74),
(6,65,13,'Horror',1630000,74),
(6,127,14,'Hamstring',1630000,74),
(6,147,50,'Magic Resistance',810000,74),
(6,147,51,'Magic Resistance',810000,74),
(6,217,44,'Sword/Blunt Weapon Mastery',810000,74),
(6,217,45,'Sword/Blunt Weapon Mastery',810000,74),
(6,232,51,'Heavy Armor Mastery',810000,74),
(6,232,52,'Heavy Armor Mastery',810000,74),
(6,401,10,'Judgment',1630000,74),
(6,322,6,'Shield Fortress',1630000,74),
(6,283,7,'Summon Dark Panther',1630000,74),
(6,291,11,'Final Fortress',1630000,74),
(6,450,10,'Banish Seraph',1630000,74),
(6,403,10,'Shackle',1630000,74),
(7,4,1,'Dash',3400,20),
(7,16,10,'Mortal Blow',1400,20),
(7,16,11,'Mortal Blow',1400,20),
(7,16,12,'Mortal Blow',1400,20),
(7,56,10,'Power Shot',1400,20),
(7,56,11,'Power Shot',1400,20),
(7,56,12,'Power Shot',1400,20),
(7,27,1,'Unlock',3400,20),
(7,113,1,'Long Shot',3400,20),
(7,173,1,'Acrobatics',3400,20),
(7,208,1,'Bow Mastery',1100,20),
(7,208,2,'Bow Mastery',1100,20),
(7,208,3,'Bow Mastery',1100,20),
(7,209,1,'Dagger Mastery',3400,20),
(7,233,1,'Light Armor Mastery',1700,20),
(7,233,2,'Light Armor Mastery',1700,20),
(7,195,1,'Breath Boost',3400,20),
(7,312,1,'Vicious Stance',3400,20),
(7,312,2,'Vicious Stance',5900,24),
(7,198,1,'Boost Evasion',5900,24),
(7,256,1,'Accuracy',5900,24),
(7,233,3,'Light Armor Mastery',2900,24),
(7,233,4,'Light Armor Mastery',2900,24),
(7,209,2,'Dagger Mastery',5900,24),
(7,208,4,'Bow Mastery',1900,24),
(7,208,5,'Bow Mastery',1900,24),
(7,208,6,'Bow Mastery',1900,24),
(7,193,1,'Critical Power',5900,24),
(7,148,1,'Vital Force',5900,24),
(7,27,2,'Unlock',5900,24),
(7,96,1,'Bleed',5900,24),
(7,56,13,'Power Shot',1900,24),
(7,56,14,'Power Shot',1900,24),
(7,56,15,'Power Shot',1900,24),
(7,16,13,'Mortal Blow',1900,24),
(7,16,14,'Mortal Blow',1900,24),
(7,16,15,'Mortal Blow',1900,24),
(7,16,16,'Mortal Blow',3600,28),
(7,16,17,'Mortal Blow',3600,28),
(7,16,18,'Mortal Blow',3600,28),
(7,56,16,'Power Shot',3600,28),
(7,56,17,'Power Shot',3600,28),
(7,56,18,'Power Shot',3600,28),
(7,27,3,'Unlock',11000,28),
(7,137,1,'Critical Chance',11000,28),
(7,169,1,'Quick Step',11000,28),
(7,208,7,'Bow Mastery',3600,28),
(7,208,8,'Bow Mastery',3600,28),
(7,208,9,'Bow Mastery',3600,28),
(7,209,3,'Dagger Mastery',5500,28),
(7,209,4,'Dagger Mastery',5500,28),
(7,233,5,'Light Armor Mastery',5500,28),
(7,233,6,'Light Armor Mastery',5500,28),
(7,111,1,'Ultimate Evasion',11000,28),
(7,225,1,'Acrobatic Move',11000,28),
(7,312,3,'Vicious Stance',11000,28),
(7,312,4,'Vicious Stance',18000,32),
(7,233,7,'Light Armor Mastery',9100,32),
(7,233,8,'Light Armor Mastery',9100,32),
(7,209,5,'Dagger Mastery',9100,32),
(7,209,6,'Dagger Mastery',9100,32),
(7,208,10,'Bow Mastery',6100,32),
(7,208,11,'Bow Mastery',6100,32),
(7,208,12,'Bow Mastery',6100,32),
(7,193,2,'Critical Power',18000,32),
(7,148,2,'Vital Force',18000,32),
(7,27,4,'Unlock',18000,32),
(7,96,2,'Bleed',18000,32),
(7,99,1,'Rapid Shot',18000,32),
(7,56,19,'Power Shot',6100,32),
(7,56,20,'Power Shot',6100,32),
(7,56,21,'Power Shot',6100,32),
(7,16,19,'Mortal Blow',6100,32),
(7,16,20,'Mortal Blow',6100,32),
(7,16,21,'Mortal Blow',6100,32),
(7,16,22,'Mortal Blow',10000,36),
(7,16,23,'Mortal Blow',10000,36),
(7,16,24,'Mortal Blow',10000,36),
(7,56,22,'Power Shot',10000,36),
(7,56,23,'Power Shot',10000,36),
(7,56,24,'Power Shot',10000,36),
(7,101,1,'Stunning Shot',10000,36),
(7,101,2,'Stunning Shot',10000,36),
(7,101,3,'Stunning Shot',10000,36),
(7,27,5,'Unlock',31000,36),
(7,168,1,'Boost Attack Speed',31000,36),
(7,171,1,'Esprit',31000,36),
(7,208,13,'Bow Mastery',10000,36),
(7,208,14,'Bow Mastery',10000,36),
(7,208,15,'Bow Mastery',10000,36),
(7,209,7,'Dagger Mastery',16000,36),
(7,209,8,'Dagger Mastery',16000,36),
(7,233,9,'Light Armor Mastery',16000,36),
(7,233,10,'Light Armor Mastery',16000,36),
(7,312,5,'Vicious Stance',31000,36),
(8,30,1,'Backstab',12000,40),
(8,30,2,'Backstab',12000,40),
(8,30,3,'Backstab',12000,40),
(8,27,6,'Unlock',35000,40),
(8,209,9,'Dagger Mastery',12000,40),
(8,209,10,'Dagger Mastery',12000,40),
(8,209,11,'Dagger Mastery',12000,40),
(8,60,1,'Fake Death',35000,40),
(8,137,2,'Critical Chance',35000,40),
(8,148,3,'Vital Force',35000,40),
(8,193,3,'Critical Power',35000,40),
(8,221,1,'Silent Move',35000,40),
(8,233,11,'Light Armor Mastery',12000,40),
(8,233,12,'Light Armor Mastery',12000,40),
(8,233,13,'Light Armor Mastery',12000,40),
(8,263,1,'Deadly Blow',12000,40),
(8,263,2,'Deadly Blow',12000,40),
(8,263,3,'Deadly Blow',12000,40),
(8,312,6,'Vicious Stance',35000,40),
(8,312,7,'Vicious Stance',42000,43),
(8,263,4,'Deadly Blow',14000,43),
(8,263,5,'Deadly Blow',14000,43),
(8,263,6,'Deadly Blow',14000,43),
(8,233,14,'Light Armor Mastery',14000,43),
(8,233,15,'Light Armor Mastery',14000,43),
(8,233,16,'Light Armor Mastery',14000,43),
(8,225,2,'Acrobatic Move',42000,43),
(8,169,2,'Quick Step',42000,43),
(8,171,2,'Esprit',42000,43),
(8,209,12,'Dagger Mastery',14000,43),
(8,209,13,'Dagger Mastery',14000,43),
(8,209,14,'Dagger Mastery',14000,43),
(8,27,7,'Unlock',42000,43),
(8,106,1,'Veil',42000,43),
(8,12,1,'Switch',42000,43),
(8,30,4,'Backstab',14000,43),
(8,30,5,'Backstab',14000,43),
(8,30,6,'Backstab',14000,43),
(8,30,7,'Backstab',14000,46),
(8,30,8,'Backstab',14000,46),
(8,30,9,'Backstab',14000,46),
(8,12,2,'Switch',43000,46),
(8,4,2,'Dash',43000,46),
(8,106,2,'Veil',43000,46),
(8,27,8,'Unlock',43000,46),
(8,209,15,'Dagger Mastery',14000,46),
(8,209,16,'Dagger Mastery',14000,46),
(8,209,17,'Dagger Mastery',14000,46),
(8,171,3,'Esprit',43000,46),
(8,198,2,'Boost Evasion',43000,46),
(8,168,2,'Boost Attack Speed',43000,46),
(8,148,4,'Vital Force',43000,46),
(8,233,17,'Light Armor Mastery',14000,46),
(8,233,18,'Light Armor Mastery',14000,46),
(8,233,19,'Light Armor Mastery',14000,46),
(8,263,7,'Deadly Blow',14000,46),
(8,263,8,'Deadly Blow',14000,46),
(8,263,9,'Deadly Blow',14000,46),
(8,312,8,'Vicious Stance',43000,46),
(8,419,1,'Summon Treasure Key',43000,46),
(8,312,9,'Vicious Stance',89000,49),
(8,263,10,'Deadly Blow',30000,49),
(8,263,11,'Deadly Blow',30000,49),
(8,263,12,'Deadly Blow',30000,49),
(8,233,20,'Light Armor Mastery',30000,49),
(8,233,21,'Light Armor Mastery',30000,49),
(8,233,22,'Light Armor Mastery',30000,49),
(8,171,4,'Esprit',89000,49),
(8,137,3,'Critical Chance',89000,49),
(8,96,3,'Bleed',89000,49),
(8,209,18,'Dagger Mastery',30000,49),
(8,209,19,'Dagger Mastery',30000,49),
(8,209,20,'Dagger Mastery',30000,49),
(8,106,3,'Veil',89000,49),
(8,11,1,'Trick',89000,49),
(8,12,3,'Switch',89000,49),
(8,30,10,'Backstab',30000,49),
(8,30,11,'Backstab',30000,49),
(8,30,12,'Backstab',30000,49),
(8,30,13,'Backstab',38000,52),
(8,30,14,'Backstab',38000,52),
(8,30,15,'Backstab',38000,52),
(8,12,4,'Switch',115000,52),
(8,11,2,'Trick',115000,52),
(8,106,4,'Veil',115000,52),
(8,27,9,'Unlock',115000,52),
(8,209,21,'Dagger Mastery',38000,52),
(8,209,22,'Dagger Mastery',38000,52),
(8,209,23,'Dagger Mastery',38000,52),
(8,51,1,'Lure',115000,52),
(8,171,5,'Esprit',115000,52),
(8,148,5,'Vital Force',115000,52),
(8,193,4,'Critical Power',115000,52),
(8,233,23,'Light Armor Mastery',38000,52),
(8,233,24,'Light Armor Mastery',38000,52),
(8,233,25,'Light Armor Mastery',38000,52),
(8,263,13,'Deadly Blow',38000,52),
(8,263,14,'Deadly Blow',38000,52),
(8,263,15,'Deadly Blow',38000,52),
(8,312,10,'Vicious Stance',115000,52),
(8,312,11,'Vicious Stance',147000,55),
(8,409,1,'Critical Blow',147000,55),
(8,412,1,'Sand Bomb',147000,55),
(8,263,16,'Deadly Blow',49000,55),
(8,263,17,'Deadly Blow',49000,55),
(8,263,18,'Deadly Blow',49000,55),
(8,233,26,'Light Armor Mastery',49000,55),
(8,233,27,'Light Armor Mastery',49000,55),
(8,233,28,'Light Armor Mastery',49000,55),
(8,173,2,'Acrobatics',147000,55),
(8,195,2,'Breath Boost',147000,55),
(8,225,3,'Acrobatic Move',147000,55),
(8,111,2,'Ultimate Evasion',147000,55),
(8,209,24,'Dagger Mastery',49000,55),
(8,209,25,'Dagger Mastery',49000,55),
(8,209,26,'Dagger Mastery',49000,55),
(8,27,10,'Unlock',147000,55),
(8,106,5,'Veil',147000,55),
(8,11,3,'Trick',147000,55),
(8,12,5,'Switch',147000,55),
(8,30,16,'Backstab',49000,55),
(8,30,17,'Backstab',49000,55),
(8,30,18,'Backstab',49000,55),
(8,30,19,'Backstab',50000,58),
(8,30,20,'Backstab',50000,58),
(8,30,21,'Backstab',50000,58),
(8,12,6,'Switch',150000,58),
(8,11,4,'Trick',150000,58),
(8,106,6,'Veil',150000,58),
(8,209,27,'Dagger Mastery',50000,58),
(8,209,28,'Dagger Mastery',50000,58),
(8,209,29,'Dagger Mastery',50000,58),
(8,96,4,'Bleed',150000,58),
(8,198,3,'Boost Evasion',150000,58),
(8,168,3,'Boost Attack Speed',150000,58),
(8,148,6,'Vital Force',150000,58),
(8,233,29,'Light Armor Mastery',50000,58),
(8,233,30,'Light Armor Mastery',50000,58),
(8,233,31,'Light Armor Mastery',50000,58),
(8,263,19,'Deadly Blow',50000,58),
(8,263,20,'Deadly Blow',50000,58),
(8,263,21,'Deadly Blow',50000,58),
(8,412,2,'Sand Bomb',150000,58),
(8,419,2,'Summon Treasure Key',150000,58),
(8,411,1,'Stealth',150000,58),
(8,409,2,'Critical Blow',150000,58),
(8,312,12,'Vicious Stance',150000,58),
(8,312,13,'Vicious Stance',242000,60),
(8,409,3,'Critical Blow',242000,60),
(8,453,1,'Escape Shackle',242000,60),
(8,412,3,'Sand Bomb',242000,60),
(8,263,22,'Deadly Blow',121000,60),
(8,263,23,'Deadly Blow',121000,60),
(8,233,32,'Light Armor Mastery',121000,60),
(8,233,33,'Light Armor Mastery',121000,60),
(8,209,30,'Dagger Mastery',121000,60),
(8,209,31,'Dagger Mastery',121000,60),
(8,106,7,'Veil',242000,60),
(8,27,11,'Unlock',242000,60),
(8,11,5,'Trick',242000,60),
(8,12,7,'Switch',242000,60),
(8,30,22,'Backstab',121000,60),
(8,30,23,'Backstab',121000,60),
(8,30,24,'Backstab',180000,62),
(8,30,25,'Backstab',180000,62),
(8,12,8,'Switch',360000,62),
(8,11,6,'Trick',360000,62),
(8,106,8,'Veil',360000,62),
(8,209,32,'Dagger Mastery',180000,62),
(8,209,33,'Dagger Mastery',180000,62),
(8,171,6,'Esprit',360000,62),
(8,233,34,'Light Armor Mastery',180000,62),
(8,233,35,'Light Armor Mastery',180000,62),
(8,263,24,'Deadly Blow',180000,62),
(8,263,25,'Deadly Blow',180000,62),
(8,412,4,'Sand Bomb',360000,62),
(8,409,4,'Critical Blow',360000,62),
(8,312,14,'Vicious Stance',360000,62),
(8,312,15,'Vicious Stance',370000,64),
(8,409,5,'Critical Blow',370000,64),
(8,412,5,'Sand Bomb',370000,64),
(8,263,26,'Deadly Blow',180000,64),
(8,263,27,'Deadly Blow',180000,64),
(8,233,36,'Light Armor Mastery',180000,64),
(8,233,37,'Light Armor Mastery',180000,64),
(8,148,7,'Vital Force',370000,64),
(8,193,5,'Critical Power',370000,64),
(8,209,34,'Dagger Mastery',180000,64),
(8,209,35,'Dagger Mastery',180000,64),
(8,106,9,'Veil',370000,64),
(8,27,12,'Unlock',370000,64),
(8,11,7,'Trick',370000,64),
(8,12,9,'Switch',370000,64),
(8,30,26,'Backstab',180000,64),
(8,30,27,'Backstab',180000,64),
(8,30,28,'Backstab',270000,66),
(8,30,29,'Backstab',270000,66),
(8,12,10,'Switch',540000,66),
(8,11,8,'Trick',540000,66),
(8,106,10,'Veil',540000,66),
(8,209,36,'Dagger Mastery',270000,66),
(8,209,37,'Dagger Mastery',270000,66),
(8,96,5,'Bleed',540000,66),
(8,233,38,'Light Armor Mastery',270000,66),
(8,233,39,'Light Armor Mastery',270000,66),
(8,263,28,'Deadly Blow',270000,66),
(8,263,29,'Deadly Blow',270000,66),
(8,412,6,'Sand Bomb',540000,66),
(8,411,2,'Stealth',540000,66),
(8,419,3,'Summon Treasure Key',540000,66),
(8,409,6,'Critical Blow',540000,66),
(8,312,16,'Vicious Stance',540000,66),
(8,312,17,'Vicious Stance',650000,68),
(8,409,7,'Critical Blow',650000,68),
(8,412,7,'Sand Bomb',650000,68),
(8,263,30,'Deadly Blow',330000,68),
(8,263,31,'Deadly Blow',330000,68),
(8,233,40,'Light Armor Mastery',330000,68),
(8,233,41,'Light Armor Mastery',330000,68),
(8,171,7,'Esprit',650000,68),
(8,209,38,'Dagger Mastery',330000,68),
(8,209,39,'Dagger Mastery',330000,68),
(8,106,11,'Veil',650000,68),
(8,27,13,'Unlock',650000,68),
(8,11,9,'Trick',650000,68),
(8,12,11,'Switch',650000,68),
(8,30,30,'Backstab',330000,68),
(8,30,31,'Backstab',330000,68),
(8,30,32,'Backstab',420000,70),
(8,30,33,'Backstab',420000,70),
(8,12,12,'Switch',850000,70),
(8,11,10,'Trick',850000,70),
(8,106,12,'Veil',850000,70),
(8,209,40,'Dagger Mastery',420000,70),
(8,209,41,'Dagger Mastery',420000,70),
(8,96,6,'Bleed',850000,70),
(8,233,42,'Light Armor Mastery',420000,70),
(8,233,43,'Light Armor Mastery',420000,70),
(8,263,32,'Deadly Blow',420000,70),
(8,263,33,'Deadly Blow',420000,70),
(8,412,8,'Sand Bomb',850000,70),
(8,409,8,'Critical Blow',850000,70),
(8,312,18,'Vicious Stance',850000,70),
(8,312,19,'Vicious Stance',920000,72),
(8,409,9,'Critical Blow',920000,72),
(8,412,9,'Sand Bomb',920000,72),
(8,263,34,'Deadly Blow',460000,72),
(8,263,35,'Deadly Blow',460000,72),
(8,233,44,'Light Armor Mastery',460000,72),
(8,233,45,'Light Armor Mastery',460000,72),
(8,193,6,'Critical Power',920000,72),
(8,148,8,'Vital Force',920000,72),
(8,209,42,'Dagger Mastery',460000,72),
(8,209,43,'Dagger Mastery',460000,72),
(8,106,13,'Veil',920000,72),
(8,27,14,'Unlock',920000,72),
(8,11,11,'Trick',920000,72),
(8,12,13,'Switch',920000,72),
(8,30,34,'Backstab',460000,72),
(8,30,35,'Backstab',460000,72),
(8,30,36,'Backstab',1000000,74),
(8,30,37,'Backstab',1000000,74),
(8,12,14,'Switch',2000000,74),
(8,11,12,'Trick',2000000,74),
(8,106,14,'Veil',2000000,74),
(8,209,44,'Dagger Mastery',1000000,74),
(8,209,45,'Dagger Mastery',1000000,74),
(8,171,8,'Esprit',2000000,74),
(8,233,46,'Light Armor Mastery',1000000,74),
(8,233,47,'Light Armor Mastery',1000000,74),
(8,263,36,'Deadly Blow',1000000,74),
(8,263,37,'Deadly Blow',1000000,74),
(8,412,10,'Sand Bomb',2000000,74),
(8,419,4,'Summon Treasure Key',2000000,74),
(8,411,3,'Stealth',2000000,74),
(8,623,1,'Find Trap',1730000,74),
(8,624,1,'Remove Trap',1730000,74),
(8,409,10,'Critical Blow',2000000,74),
(8,312,20,'Vicious Stance',2000000,74),
(9,19,1,'Double Shot',16000,40),
(9,19,2,'Double Shot',16000,40),
(9,19,3,'Double Shot',16000,40),
(9,101,4,'Stunning Shot',16000,40),
(9,101,5,'Stunning Shot',16000,40),
(9,101,6,'Stunning Shot',16000,40),
(9,113,2,'Long Shot',49000,40),
(9,131,1,'Hawk Eye',49000,40),
(9,148,3,'Vital Force',49000,40),
(9,208,16,'Bow Mastery',16000,40),
(9,208,17,'Bow Mastery',16000,40),
(9,208,18,'Bow Mastery',16000,40),
(9,233,11,'Light Armor Mastery',16000,40),
(9,233,12,'Light Armor Mastery',16000,40),
(9,233,13,'Light Armor Mastery',16000,40),
(9,312,6,'Vicious Stance',49000,40),
(9,312,7,'Vicious Stance',58000,43),
(9,225,2,'Acrobatic Move',58000,43),
(9,233,14,'Light Armor Mastery',19000,43),
(9,233,15,'Light Armor Mastery',19000,43),
(9,233,16,'Light Armor Mastery',19000,43),
(9,208,19,'Bow Mastery',19000,43),
(9,208,20,'Bow Mastery',19000,43),
(9,208,21,'Bow Mastery',19000,43),
(9,169,2,'Quick Step',58000,43),
(9,171,2,'Esprit',58000,43),
(9,101,7,'Stunning Shot',19000,43),
(9,101,8,'Stunning Shot',19000,43),
(9,101,9,'Stunning Shot',19000,43),
(9,19,4,'Double Shot',19000,43),
(9,19,5,'Double Shot',19000,43),
(9,19,6,'Double Shot',19000,43),
(9,19,7,'Double Shot',22000,46),
(9,19,8,'Double Shot',22000,46),
(9,19,9,'Double Shot',22000,46),
(9,101,10,'Stunning Shot',22000,46),
(9,101,11,'Stunning Shot',22000,46),
(9,101,12,'Stunning Shot',22000,46),
(9,171,3,'Esprit',67000,46),
(9,148,4,'Vital Force',67000,46),
(9,24,1,'Burst Shot',22000,46),
(9,24,2,'Burst Shot',22000,46),
(9,24,3,'Burst Shot',22000,46),
(9,208,22,'Bow Mastery',22000,46),
(9,208,23,'Bow Mastery',22000,46),
(9,208,24,'Bow Mastery',22000,46),
(9,233,17,'Light Armor Mastery',22000,46),
(9,233,18,'Light Armor Mastery',22000,46),
(9,233,19,'Light Armor Mastery',22000,46),
(9,303,1,'Soul of Sagittarius',67000,46),
(9,312,8,'Vicious Stance',67000,46),
(9,312,9,'Vicious Stance',123000,49),
(9,233,20,'Light Armor Mastery',41000,49),
(9,233,21,'Light Armor Mastery',41000,49),
(9,233,22,'Light Armor Mastery',41000,49),
(9,208,25,'Bow Mastery',41000,49),
(9,208,26,'Bow Mastery',41000,49),
(9,208,27,'Bow Mastery',41000,49),
(9,24,4,'Burst Shot',41000,49),
(9,24,5,'Burst Shot',41000,49),
(9,24,6,'Burst Shot',41000,49),
(9,131,2,'Hawk Eye',123000,49),
(9,171,4,'Esprit',123000,49),
(9,101,13,'Stunning Shot',41000,49),
(9,101,14,'Stunning Shot',41000,49),
(9,101,15,'Stunning Shot',41000,49),
(9,19,10,'Double Shot',41000,49),
(9,19,11,'Double Shot',41000,49),
(9,19,12,'Double Shot',41000,49),
(9,19,13,'Double Shot',63000,52),
(9,19,14,'Double Shot',63000,52),
(9,19,15,'Double Shot',63000,52),
(9,101,16,'Stunning Shot',63000,52),
(9,101,17,'Stunning Shot',63000,52),
(9,101,18,'Stunning Shot',63000,52),
(9,171,5,'Esprit',188000,52),
(9,148,5,'Vital Force',188000,52),
(9,24,7,'Burst Shot',63000,52),
(9,24,8,'Burst Shot',63000,52),
(9,24,9,'Burst Shot',63000,52),
(9,208,28,'Bow Mastery',63000,52),
(9,208,29,'Bow Mastery',63000,52),
(9,208,30,'Bow Mastery',63000,52),
(9,233,23,'Light Armor Mastery',63000,52),
(9,233,24,'Light Armor Mastery',63000,52),
(9,233,25,'Light Armor Mastery',63000,52),
(9,312,10,'Vicious Stance',188000,52),
(9,312,11,'Vicious Stance',213000,55),
(9,225,3,'Acrobatic Move',213000,55),
(9,233,26,'Light Armor Mastery',71000,55),
(9,233,27,'Light Armor Mastery',71000,55),
(9,233,28,'Light Armor Mastery',71000,55),
(9,99,2,'Rapid Shot',213000,55),
(9,208,31,'Bow Mastery',71000,55),
(9,208,32,'Bow Mastery',71000,55),
(9,208,33,'Bow Mastery',71000,55),
(9,24,10,'Burst Shot',71000,55),
(9,24,11,'Burst Shot',71000,55),
(9,24,12,'Burst Shot',71000,55),
(9,101,19,'Stunning Shot',71000,55),
(9,101,20,'Stunning Shot',71000,55),
(9,101,21,'Stunning Shot',71000,55),
(9,19,16,'Double Shot',71000,55),
(9,19,17,'Double Shot',71000,55),
(9,19,18,'Double Shot',71000,55),
(9,19,19,'Double Shot',74000,58),
(9,19,20,'Double Shot',74000,58),
(9,19,21,'Double Shot',74000,58),
(9,101,22,'Stunning Shot',74000,58),
(9,101,23,'Stunning Shot',74000,58),
(9,101,24,'Stunning Shot',74000,58),
(9,24,13,'Burst Shot',74000,58),
(9,24,14,'Burst Shot',74000,58),
(9,24,15,'Burst Shot',74000,58),
(9,148,6,'Vital Force',223000,58),
(9,131,3,'Hawk Eye',223000,58),
(9,208,34,'Bow Mastery',74000,58),
(9,208,35,'Bow Mastery',74000,58),
(9,208,36,'Bow Mastery',74000,58),
(9,418,1,'Quiver of Holding',223000,58),
(9,233,29,'Light Armor Mastery',74000,58),
(9,233,30,'Light Armor Mastery',74000,58),
(9,233,31,'Light Armor Mastery',74000,58),
(9,303,2,'Soul of Sagittarius',223000,58),
(9,415,1,'Spirit of Sagittarius',223000,58),
(9,416,1,'Blessing of Sagittarius',223000,58),
(9,417,1,'Pain of Sagittarius',223000,58),
(9,312,12,'Vicious Stance',223000,58),
(9,312,13,'Vicious Stance',410000,60),
(9,313,1,'Snipe',410000,60),
(9,233,32,'Light Armor Mastery',210000,60),
(9,233,33,'Light Armor Mastery',210000,60),
(9,208,37,'Bow Mastery',210000,60),
(9,208,38,'Bow Mastery',210000,60),
(9,24,16,'Burst Shot',210000,60),
(9,24,17,'Burst Shot',210000,60),
(9,101,25,'Stunning Shot',210000,60),
(9,101,26,'Stunning Shot',210000,60),
(9,19,22,'Double Shot',210000,60),
(9,19,23,'Double Shot',210000,60),
(9,19,24,'Double Shot',220000,62),
(9,19,25,'Double Shot',220000,62),
(9,101,27,'Stunning Shot',220000,62),
(9,101,28,'Stunning Shot',220000,62),
(9,24,18,'Burst Shot',220000,62),
(9,24,19,'Burst Shot',220000,62),
(9,171,6,'Esprit',440000,62),
(9,208,39,'Bow Mastery',220000,62),
(9,208,40,'Bow Mastery',220000,62),
(9,233,34,'Light Armor Mastery',220000,62),
(9,233,35,'Light Armor Mastery',220000,62),
(9,313,2,'Snipe',440000,62),
(9,312,14,'Vicious Stance',440000,62),
(9,417,2,'Pain of Sagittarius',440000,62),
(9,303,3,'Soul of Sagittarius',530000,64),
(9,312,15,'Vicious Stance',530000,64),
(9,313,3,'Snipe',530000,64),
(9,233,36,'Light Armor Mastery',270000,64),
(9,233,37,'Light Armor Mastery',270000,64),
(9,208,41,'Bow Mastery',270000,64),
(9,208,42,'Bow Mastery',270000,64),
(9,148,7,'Vital Force',530000,64),
(9,24,20,'Burst Shot',270000,64),
(9,24,21,'Burst Shot',270000,64),
(9,101,29,'Stunning Shot',270000,64),
(9,101,30,'Stunning Shot',270000,64),
(9,19,26,'Double Shot',270000,64),
(9,19,27,'Double Shot',270000,64),
(9,19,28,'Double Shot',290000,66),
(9,19,29,'Double Shot',290000,66),
(9,101,31,'Stunning Shot',290000,66),
(9,101,32,'Stunning Shot',290000,66),
(9,24,22,'Burst Shot',290000,66),
(9,24,23,'Burst Shot',290000,66),
(9,208,43,'Bow Mastery',290000,66),
(9,208,44,'Bow Mastery',290000,66),
(9,233,38,'Light Armor Mastery',290000,66),
(9,233,39,'Light Armor Mastery',290000,66),
(9,313,4,'Snipe',580000,66),
(9,312,16,'Vicious Stance',580000,66),
(9,323,1,'Quiver of Arrow: Grade A',580000,66),
(9,417,3,'Pain of Sagittarius',580000,66),
(9,416,2,'Blessing of Sagittarius',580000,66),
(9,415,2,'Spirit of Sagittarius',580000,66),
(9,418,2,'Quiver of Holding',580000,66),
(9,312,17,'Vicious Stance',980000,68),
(9,313,5,'Snipe',980000,68),
(9,233,40,'Light Armor Mastery',490000,68),
(9,233,41,'Light Armor Mastery',490000,68),
(9,208,45,'Bow Mastery',490000,68),
(9,208,46,'Bow Mastery',490000,68),
(9,24,24,'Burst Shot',490000,68),
(9,24,25,'Burst Shot',490000,68),
(9,171,7,'Esprit',980000,68),
(9,101,33,'Stunning Shot',490000,68),
(9,101,34,'Stunning Shot',490000,68),
(9,19,30,'Double Shot',490000,68),
(9,19,31,'Double Shot',490000,68),
(9,19,32,'Double Shot',520000,70),
(9,19,33,'Double Shot',520000,70),
(9,101,35,'Stunning Shot',520000,70),
(9,101,36,'Stunning Shot',520000,70),
(9,24,26,'Burst Shot',520000,70),
(9,24,27,'Burst Shot',520000,70),
(9,208,47,'Bow Mastery',520000,70),
(9,208,48,'Bow Mastery',520000,70),
(9,233,42,'Light Armor Mastery',520000,70),
(9,233,43,'Light Armor Mastery',520000,70),
(9,313,6,'Snipe',1030000,70),
(9,312,18,'Vicious Stance',1030000,70),
(9,417,4,'Pain of Sagittarius',1030000,70),
(9,303,4,'Soul of Sagittarius',1030000,70),
(9,324,1,'Quiver of Arrow: Grade S',1330000,72),
(9,312,19,'Vicious Stance',1330000,72),
(9,313,7,'Snipe',1330000,72),
(9,233,44,'Light Armor Mastery',670000,72),
(9,233,45,'Light Armor Mastery',670000,72),
(9,208,49,'Bow Mastery',670000,72),
(9,208,50,'Bow Mastery',670000,72),
(9,24,28,'Burst Shot',670000,72),
(9,24,29,'Burst Shot',670000,72),
(9,148,8,'Vital Force',1330000,72),
(9,101,37,'Stunning Shot',670000,72),
(9,101,38,'Stunning Shot',670000,72),
(9,19,34,'Double Shot',670000,72),
(9,19,35,'Double Shot',670000,72),
(9,933,1,'Detection',1900000,74),
(9,19,36,'Double Shot',1080000,74),
(9,19,37,'Double Shot',1080000,74),
(9,101,39,'Stunning Shot',1080000,74),
(9,101,40,'Stunning Shot',1080000,74),
(9,171,8,'Esprit',2170000,74),
(9,24,30,'Burst Shot',1080000,74),
(9,24,31,'Burst Shot',1080000,74),
(9,208,51,'Bow Mastery',1080000,74),
(9,208,52,'Bow Mastery',1080000,74),
(9,233,46,'Light Armor Mastery',1080000,74),
(9,233,47,'Light Armor Mastery',1080000,74),
(9,313,8,'Snipe',2170000,74),
(9,312,20,'Vicious Stance',2170000,74),
(9,417,5,'Pain of Sagittarius',2170000,74),
(9,415,3,'Spirit of Sagittarius',2170000,74),
(9,416,3,'Blessing of Sagittarius',2170000,74),
(9,418,3,'Quiver of Holding',2170000,74),
(10,163,1,'Spellcraft',0,1),
(10,214,1,'Mana Recovery',0,1),
(10,118,1,'Magician\'s Movement',0,1),
(10,1177,1,'Wind Strike',0,1),
(10,1216,1,'Self Heal',0,1),
(10,1184,1,'Ice Bolt',240,7),
(10,1184,2,'Ice Bolt',240,7),
(10,1168,1,'Curse: Poison',470,7),
(10,1177,2,'Wind Strike',240,7),
(10,1177,3,'Wind Strike',240,7),
(10,1040,1,'Shield',470,7),
(10,1068,1,'Might',470,7),
(10,1011,1,'Heal',160,7),
(10,1011,2,'Heal',160,7),
(10,1011,3,'Heal',160,7),
(10,1012,1,'Cure Poison',470,7),
(10,146,1,'Anti Magic',240,7),
(10,146,2,'Anti Magic',240,7),
(10,244,1,'Armor Mastery',470,7),
(10,249,1,'Weapon Mastery',470,7),
(10,249,2,'Weapon Mastery',2100,14),
(10,244,2,'Armor Mastery',1100,14),
(10,244,3,'Armor Mastery',1100,14),
(10,146,3,'Anti Magic',1100,14),
(10,146,4,'Anti Magic',1100,14),
(10,1015,1,'Battle Heal',700,14),
(10,1015,2,'Battle Heal',700,14),
(10,1015,3,'Battle Heal',700,14),
(10,1027,1,'Group Heal',700,14),
(10,1027,2,'Group Heal',700,14),
(10,1027,3,'Group Heal',700,14),
(10,1011,4,'Heal',700,14),
(10,1011,5,'Heal',700,14),
(10,1011,6,'Heal',700,14),
(10,1147,1,'Vampiric Touch',1100,14),
(10,1147,2,'Vampiric Touch',1100,14),
(10,1164,1,'Curse: Weakness',2100,14),
(10,1177,4,'Wind Strike',1100,14),
(10,1177,5,'Wind Strike',1100,14),
(10,1184,3,'Ice Bolt',1100,14),
(10,1184,4,'Ice Bolt',1100,14),
(11,146,5,'Anti Magic',1400,20),
(11,146,6,'Anti Magic',1400,20),
(11,234,1,'Robe Mastery',1400,20),
(11,234,2,'Robe Mastery',1400,20),
(11,164,1,'Quick Recycle',2900,20),
(11,213,1,'Boost Mana',2900,20),
(11,249,3,'Weapon Mastery',2900,20),
(11,285,1,'Higher Mana Gain',1400,20),
(11,285,2,'Higher Mana Gain',1400,20),
(11,1078,1,'Concentration',2900,20),
(11,1111,1,'Summon Kat the Cat',2900,20),
(11,1127,1,'Servitor Heal',960,20),
(11,1127,2,'Servitor Heal',960,20),
(11,1127,3,'Servitor Heal',960,20),
(11,1147,3,'Vampiric Touch',1400,20),
(11,1147,4,'Vampiric Touch',1400,20),
(11,1164,2,'Curse: Weakness',2900,20),
(11,1172,1,'Aura Burn',1400,20),
(11,1172,2,'Aura Burn',1400,20),
(11,1184,5,'Ice Bolt',1400,20),
(11,1184,6,'Ice Bolt',1400,20),
(11,1220,1,'Blaze',1400,20),
(11,1220,2,'Blaze',1400,20),
(11,1168,2,'Curse: Poison',2900,20),
(11,1225,1,'Summon Mew the Cat',2900,20),
(11,1274,1,'Energy Bolt',2900,20),
(11,1181,1,'Flame Strike',2900,20),
(11,1181,2,'Flame Strike',5500,25),
(11,1274,2,'Energy Bolt',5500,25),
(11,1225,2,'Summon Mew the Cat',5500,25),
(11,1167,1,'Poisonous Cloud',5500,25),
(11,1220,3,'Blaze',2800,25),
(11,1220,4,'Blaze',2800,25),
(11,1172,3,'Aura Burn',2800,25),
(11,1172,4,'Aura Burn',2800,25),
(11,1164,3,'Curse: Weakness',5500,25),
(11,1083,1,'Surrender To Fire',5500,25),
(11,1157,1,'Body To Mind',5500,25),
(11,1147,5,'Vampiric Touch',2800,25),
(11,1147,6,'Vampiric Touch',2800,25),
(11,1126,1,'Servitor Recharge',2800,25),
(11,1126,2,'Servitor Recharge',2800,25),
(11,1127,4,'Servitor Heal',1800,25),
(11,1127,5,'Servitor Heal',1800,25),
(11,1127,6,'Servitor Heal',1800,25),
(11,1111,2,'Summon Kat the Cat',5500,25),
(11,228,1,'Fast Spell Casting',5500,25),
(11,229,1,'Fast Mana Recovery',5500,25),
(11,1069,1,'Sleep',1800,25),
(11,1069,2,'Sleep',1800,25),
(11,1069,3,'Sleep',1800,25),
(11,285,3,'Higher Mana Gain',2800,25),
(11,285,4,'Higher Mana Gain',2800,25),
(11,249,4,'Weapon Mastery',2800,25),
(11,249,5,'Weapon Mastery',2800,25),
(11,234,3,'Robe Mastery',2800,25),
(11,234,4,'Robe Mastery',2800,25),
(11,146,7,'Anti Magic',2800,25),
(11,146,8,'Anti Magic',2800,25),
(11,146,9,'Anti Magic',5300,30),
(11,146,10,'Anti Magic',5300,30),
(11,234,5,'Robe Mastery',5300,30),
(11,234,6,'Robe Mastery',5300,30),
(11,249,6,'Weapon Mastery',5300,30),
(11,249,7,'Weapon Mastery',5300,30),
(11,213,2,'Boost Mana',11000,30),
(11,164,2,'Quick Recycle',11000,30),
(11,285,5,'Higher Mana Gain',5300,30),
(11,285,6,'Higher Mana Gain',5300,30),
(11,1069,4,'Sleep',3500,30),
(11,1069,5,'Sleep',3500,30),
(11,1069,6,'Sleep',3500,30),
(11,1078,2,'Concentration',11000,30),
(11,1111,3,'Summon Kat the Cat',11000,30),
(11,1127,7,'Servitor Heal',3500,30),
(11,1127,8,'Servitor Heal',3500,30),
(11,1127,9,'Servitor Heal',3500,30),
(11,1126,3,'Servitor Recharge',5300,30),
(11,1126,4,'Servitor Recharge',5300,30),
(11,1151,1,'Corpse Life Drain',11000,30),
(11,1083,2,'Surrender To Fire',11000,30),
(11,1164,4,'Curse: Weakness',11000,30),
(11,1172,5,'Aura Burn',5300,30),
(11,1172,6,'Aura Burn',5300,30),
(11,1220,5,'Blaze',5300,30),
(11,1220,6,'Blaze',5300,30),
(11,1168,3,'Curse: Poison',11000,30),
(11,1225,3,'Summon Mew the Cat',11000,30),
(11,1274,3,'Energy Bolt',11000,30),
(11,1181,3,'Flame Strike',11000,30),
(11,1274,4,'Energy Bolt',18000,35),
(11,1225,4,'Summon Mew the Cat',18000,35),
(11,1167,2,'Poisonous Cloud',18000,35),
(11,1220,7,'Blaze',8800,35),
(11,1220,8,'Blaze',8800,35),
(11,1222,1,'Curse Chaos',18000,35),
(11,1172,7,'Aura Burn',8800,35),
(11,1172,8,'Aura Burn',8800,35),
(11,1164,5,'Curse: Weakness',18000,35),
(11,1083,3,'Surrender To Fire',18000,35),
(11,1160,1,'Slow',18000,35),
(11,1151,2,'Corpse Life Drain',18000,35),
(11,1126,5,'Servitor Recharge',8800,35),
(11,1126,6,'Servitor Recharge',8800,35),
(11,1127,10,'Servitor Heal',5900,35),
(11,1127,11,'Servitor Heal',5900,35),
(11,1127,12,'Servitor Heal',5900,35),
(11,1144,1,'Servitor Wind Walk',18000,35),
(11,1111,4,'Summon Kat the Cat',18000,35),
(11,229,2,'Fast Mana Recovery',18000,35),
(11,1069,7,'Sleep',5900,35),
(11,1069,8,'Sleep',5900,35),
(11,1069,9,'Sleep',5900,35),
(11,285,7,'Higher Mana Gain',8800,35),
(11,285,8,'Higher Mana Gain',8800,35),
(11,212,1,'Fast HP Recovery',18000,35),
(11,249,8,'Weapon Mastery',8800,35),
(11,249,9,'Weapon Mastery',8800,35),
(11,234,7,'Robe Mastery',8800,35),
(11,234,8,'Robe Mastery',8800,35),
(11,146,11,'Anti Magic',8800,35),
(11,146,12,'Anti Magic',8800,35),
(12,146,13,'Anti Magic',11000,40),
(12,146,14,'Anti Magic',11000,40),
(12,146,15,'Anti Magic',11000,40),
(12,234,9,'Robe Mastery',11000,40),
(12,234,10,'Robe Mastery',11000,40),
(12,234,11,'Robe Mastery',11000,40),
(12,249,10,'Weapon Mastery',11000,40),
(12,249,11,'Weapon Mastery',11000,40),
(12,249,12,'Weapon Mastery',11000,40),
(12,285,9,'Higher Mana Gain',16000,40),
(12,285,10,'Higher Mana Gain',16000,40),
(12,213,3,'Boost Mana',32000,40),
(12,1069,10,'Sleep',11000,40),
(12,1069,11,'Sleep',11000,40),
(12,1069,12,'Sleep',11000,40),
(12,1074,1,'Surrender To Wind',32000,40),
(12,1083,4,'Surrender To Fire',32000,40),
(12,1160,2,'Slow',32000,40),
(12,1171,1,'Blazing Circle',16000,40),
(12,1171,2,'Blazing Circle',16000,40),
(12,1230,1,'Prominence',16000,40),
(12,1230,2,'Prominence',16000,40),
(12,1231,1,'Aura Flare',16000,40),
(12,1231,2,'Aura Flare',16000,40),
(12,1169,1,'Curse Fear',32000,40),
(12,228,2,'Fast Spell Casting',32000,40),
(12,1232,1,'Blazing Skin',32000,40),
(12,1275,1,'Aura Bolt',32000,40),
(12,1297,1,'Clear Mind',32000,40),
(12,1275,2,'Aura Bolt',41000,44),
(12,1078,3,'Concentration',41000,44),
(12,1169,2,'Curse Fear',41000,44),
(12,1231,3,'Aura Flare',21000,44),
(12,1231,4,'Aura Flare',21000,44),
(12,1230,3,'Prominence',21000,44),
(12,1230,4,'Prominence',21000,44),
(12,1171,3,'Blazing Circle',21000,44),
(12,1171,4,'Blazing Circle',21000,44),
(12,1160,3,'Slow',41000,44),
(12,1083,5,'Surrender To Fire',41000,44),
(12,1074,2,'Surrender To Wind',41000,44),
(12,229,3,'Fast Mana Recovery',41000,44),
(12,1072,1,'Sleeping Cloud',41000,44),
(12,1069,13,'Sleep',14000,44),
(12,1069,14,'Sleep',14000,44),
(12,1069,15,'Sleep',14000,44),
(12,212,2,'Fast HP Recovery',41000,44),
(12,285,11,'Higher Mana Gain',21000,44),
(12,285,12,'Higher Mana Gain',21000,44),
(12,249,13,'Weapon Mastery',14000,44),
(12,249,14,'Weapon Mastery',14000,44),
(12,249,15,'Weapon Mastery',14000,44),
(12,234,12,'Robe Mastery',14000,44),
(12,234,13,'Robe Mastery',14000,44),
(12,234,14,'Robe Mastery',14000,44),
(12,146,16,'Anti Magic',14000,44),
(12,146,17,'Anti Magic',14000,44),
(12,146,18,'Anti Magic',14000,44),
(12,146,19,'Anti Magic',21000,48),
(12,146,20,'Anti Magic',21000,48),
(12,146,21,'Anti Magic',21000,48),
(12,234,15,'Robe Mastery',21000,48),
(12,234,16,'Robe Mastery',21000,48),
(12,234,17,'Robe Mastery',21000,48),
(12,249,16,'Weapon Mastery',21000,48),
(12,249,17,'Weapon Mastery',21000,48),
(12,249,18,'Weapon Mastery',21000,48),
(12,285,13,'Higher Mana Gain',32000,48),
(12,285,14,'Higher Mana Gain',32000,48),
(12,213,4,'Boost Mana',63000,48),
(12,1056,1,'Cancellation',63000,48),
(12,1069,16,'Sleep',21000,48),
(12,1069,17,'Sleep',21000,48),
(12,1069,18,'Sleep',21000,48),
(12,1074,3,'Surrender To Wind',63000,48),
(12,1083,6,'Surrender To Fire',63000,48),
(12,1160,4,'Slow',63000,48),
(12,1171,5,'Blazing Circle',32000,48),
(12,1171,6,'Blazing Circle',32000,48),
(12,1230,5,'Prominence',32000,48),
(12,1230,6,'Prominence',32000,48),
(12,1231,5,'Aura Flare',32000,48),
(12,1231,6,'Aura Flare',32000,48),
(12,1169,3,'Curse Fear',63000,48),
(12,1232,2,'Blazing Skin',63000,48),
(12,1275,3,'Aura Bolt',63000,48),
(12,1233,1,'Decay',63000,48),
(12,1297,2,'Clear Mind',63000,48),
(12,164,3,'Quick Recycle',63000,48),
(12,1275,4,'Aura Bolt',94000,52),
(12,1078,4,'Concentration',94000,52),
(12,1169,4,'Curse Fear',94000,52),
(12,1231,7,'Aura Flare',47000,52),
(12,1231,8,'Aura Flare',47000,52),
(12,1230,7,'Prominence',47000,52),
(12,1230,8,'Prominence',47000,52),
(12,1171,7,'Blazing Circle',47000,52),
(12,1171,8,'Blazing Circle',47000,52),
(12,1160,5,'Slow',94000,52),
(12,1083,7,'Surrender To Fire',94000,52),
(12,1074,4,'Surrender To Wind',94000,52),
(12,229,4,'Fast Mana Recovery',94000,52),
(12,1069,19,'Sleep',31000,52),
(12,1069,20,'Sleep',31000,52),
(12,1069,21,'Sleep',31000,52),
(12,1056,2,'Cancellation',94000,52),
(12,212,3,'Fast HP Recovery',94000,52),
(12,285,15,'Higher Mana Gain',47000,52),
(12,285,16,'Higher Mana Gain',47000,52),
(12,249,19,'Weapon Mastery',31000,52),
(12,249,20,'Weapon Mastery',31000,52),
(12,249,21,'Weapon Mastery',31000,52),
(12,234,18,'Robe Mastery',31000,52),
(12,234,19,'Robe Mastery',31000,52),
(12,234,20,'Robe Mastery',31000,52),
(12,146,22,'Anti Magic',31000,52),
(12,146,23,'Anti Magic',31000,52),
(12,146,24,'Anti Magic',31000,52),
(12,146,25,'Anti Magic',37000,56),
(12,146,26,'Anti Magic',37000,56),
(12,146,27,'Anti Magic',37000,56),
(12,234,21,'Robe Mastery',37000,56),
(12,234,22,'Robe Mastery',37000,56),
(12,234,23,'Robe Mastery',37000,56),
(12,249,22,'Weapon Mastery',37000,56),
(12,249,23,'Weapon Mastery',37000,56),
(12,249,24,'Weapon Mastery',37000,56),
(12,285,17,'Higher Mana Gain',55000,56),
(12,285,18,'Higher Mana Gain',55000,56),
(12,213,5,'Boost Mana',110000,56),
(12,1056,3,'Cancellation',110000,56),
(12,1069,22,'Sleep',37000,56),
(12,1069,23,'Sleep',37000,56),
(12,1069,24,'Sleep',37000,56),
(12,1072,2,'Sleeping Cloud',110000,56),
(12,1074,5,'Surrender To Wind',110000,56),
(12,1083,8,'Surrender To Fire',110000,56),
(12,1160,6,'Slow',110000,56),
(12,1171,9,'Blazing Circle',55000,56),
(12,1171,10,'Blazing Circle',55000,56),
(12,1230,9,'Prominence',55000,56),
(12,1230,10,'Prominence',55000,56),
(12,1231,9,'Aura Flare',55000,56),
(12,1231,10,'Aura Flare',55000,56),
(12,1169,5,'Curse Fear',110000,56),
(12,1232,3,'Blazing Skin',110000,56),
(12,228,3,'Fast Spell Casting',110000,56),
(12,1275,5,'Aura Bolt',110000,56),
(12,1233,2,'Decay',110000,56),
(12,1297,3,'Clear Mind',110000,56),
(12,1417,1,'Aura Flash',129000,58),
(12,1296,1,'Rain of Fire',129000,58),
(12,1275,6,'Aura Bolt',129000,58),
(12,1169,6,'Curse Fear',129000,58),
(12,1231,11,'Aura Flare',65000,58),
(12,1231,12,'Aura Flare',65000,58),
(12,1230,11,'Prominence',65000,58),
(12,1230,12,'Prominence',65000,58),
(12,1171,11,'Blazing Circle',129000,58),
(12,1160,7,'Slow',129000,58),
(12,1083,9,'Surrender To Fire',129000,58),
(12,1074,6,'Surrender To Wind',129000,58),
(12,1069,25,'Sleep',65000,58),
(12,1069,26,'Sleep',65000,58),
(12,1056,4,'Cancellation',129000,58),
(12,212,4,'Fast HP Recovery',129000,58),
(12,285,19,'Higher Mana Gain',129000,58),
(12,249,25,'Weapon Mastery',65000,58),
(12,249,26,'Weapon Mastery',65000,58),
(12,234,24,'Robe Mastery',65000,58),
(12,234,25,'Robe Mastery',65000,58),
(12,146,28,'Anti Magic',65000,58),
(12,146,29,'Anti Magic',65000,58),
(12,146,30,'Anti Magic',83000,60),
(12,146,31,'Anti Magic',83000,60),
(12,234,26,'Robe Mastery',83000,60),
(12,234,27,'Robe Mastery',83000,60),
(12,249,27,'Weapon Mastery',83000,60),
(12,249,28,'Weapon Mastery',83000,60),
(12,285,20,'Higher Mana Gain',167000,60),
(12,213,6,'Boost Mana',167000,60),
(12,1056,5,'Cancellation',167000,60),
(12,1069,27,'Sleep',83000,60),
(12,1069,28,'Sleep',83000,60),
(12,1074,7,'Surrender To Wind',167000,60),
(12,229,5,'Fast Mana Recovery',167000,60),
(12,1083,10,'Surrender To Fire',167000,60),
(12,1160,8,'Slow',167000,60),
(12,1171,12,'Blazing Circle',167000,60),
(12,1230,13,'Prominence',83000,60),
(12,1230,14,'Prominence',83000,60),
(12,1231,13,'Aura Flare',83000,60),
(12,1231,14,'Aura Flare',83000,60),
(12,1169,7,'Curse Fear',167000,60),
(12,1078,5,'Concentration',167000,60),
(12,1275,7,'Aura Bolt',167000,60),
(12,1296,2,'Rain of Fire',167000,60),
(12,1296,3,'Rain of Fire',220000,62),
(12,1417,2,'Aura Flash',220000,62),
(12,1297,4,'Clear Mind',220000,62),
(12,1275,8,'Aura Bolt',220000,62),
(12,1169,8,'Curse Fear',220000,62),
(12,1231,15,'Aura Flare',110000,62),
(12,1231,16,'Aura Flare',110000,62),
(12,1230,15,'Prominence',110000,62),
(12,1230,16,'Prominence',110000,62),
(12,1171,13,'Blazing Circle',220000,62),
(12,1160,9,'Slow',220000,62),
(12,1083,11,'Surrender To Fire',220000,62),
(12,1072,3,'Sleeping Cloud',220000,62),
(12,1074,8,'Surrender To Wind',220000,62),
(12,1069,29,'Sleep',110000,62),
(12,1069,30,'Sleep',110000,62),
(12,1056,6,'Cancellation',220000,62),
(12,285,21,'Higher Mana Gain',220000,62),
(12,249,29,'Weapon Mastery',110000,62),
(12,249,30,'Weapon Mastery',110000,62),
(12,234,28,'Robe Mastery',110000,62),
(12,234,29,'Robe Mastery',110000,62),
(12,146,32,'Anti Magic',110000,62),
(12,146,33,'Anti Magic',110000,62),
(12,146,34,'Anti Magic',140000,64),
(12,146,35,'Anti Magic',140000,64),
(12,234,30,'Robe Mastery',140000,64),
(12,234,31,'Robe Mastery',140000,64),
(12,249,31,'Weapon Mastery',140000,64),
(12,249,32,'Weapon Mastery',140000,64),
(12,285,22,'Higher Mana Gain',280000,64),
(12,1056,7,'Cancellation',280000,64),
(12,212,5,'Fast HP Recovery',280000,64),
(12,1069,31,'Sleep',140000,64),
(12,1069,32,'Sleep',140000,64),
(12,1074,9,'Surrender To Wind',280000,64),
(12,1083,12,'Surrender To Fire',280000,64),
(12,1160,10,'Slow',280000,64),
(12,1171,14,'Blazing Circle',280000,64),
(12,1230,17,'Prominence',140000,64),
(12,1230,18,'Prominence',140000,64),
(12,1231,17,'Aura Flare',140000,64),
(12,1231,18,'Aura Flare',140000,64),
(12,1169,9,'Curse Fear',280000,64),
(12,1275,9,'Aura Bolt',280000,64),
(12,1233,3,'Decay',280000,64),
(12,1296,4,'Rain of Fire',280000,64),
(12,1296,5,'Rain of Fire',370000,66),
(12,1417,3,'Aura Flash',370000,66),
(12,1285,1,'Seed of Fire',370000,66),
(12,1275,10,'Aura Bolt',370000,66),
(12,1169,10,'Curse Fear',370000,66),
(12,1231,19,'Aura Flare',180000,66),
(12,1231,20,'Aura Flare',180000,66),
(12,1230,19,'Prominence',180000,66),
(12,1230,20,'Prominence',180000,66),
(12,1171,15,'Blazing Circle',370000,66),
(12,1160,11,'Slow',370000,66),
(12,1083,13,'Surrender To Fire',370000,66),
(12,1074,10,'Surrender To Wind',370000,66),
(12,1072,4,'Sleeping Cloud',370000,66),
(12,1069,33,'Sleep',180000,66),
(12,1069,34,'Sleep',180000,66),
(12,213,7,'Boost Mana',370000,66),
(12,1056,8,'Cancellation',370000,66),
(12,285,23,'Higher Mana Gain',370000,66),
(12,249,33,'Weapon Mastery',180000,66),
(12,249,34,'Weapon Mastery',180000,66),
(12,234,32,'Robe Mastery',180000,66),
(12,234,33,'Robe Mastery',180000,66),
(12,146,36,'Anti Magic',180000,66),
(12,146,37,'Anti Magic',180000,66),
(12,146,38,'Anti Magic',200000,68),
(12,146,39,'Anti Magic',200000,68),
(12,234,34,'Robe Mastery',200000,68),
(12,234,35,'Robe Mastery',200000,68),
(12,249,35,'Weapon Mastery',200000,68),
(12,249,36,'Weapon Mastery',200000,68),
(12,285,24,'Higher Mana Gain',410000,68),
(12,1056,9,'Cancellation',410000,68),
(12,1069,35,'Sleep',200000,68),
(12,1069,36,'Sleep',200000,68),
(12,229,6,'Fast Mana Recovery',410000,68),
(12,1074,11,'Surrender To Wind',410000,68),
(12,1083,14,'Surrender To Fire',410000,68),
(12,1160,12,'Slow',410000,68),
(12,1171,16,'Blazing Circle',410000,68),
(12,1230,21,'Prominence',200000,68),
(12,1230,22,'Prominence',200000,68),
(12,1231,21,'Aura Flare',200000,68),
(12,1231,22,'Aura Flare',200000,68),
(12,1169,11,'Curse Fear',410000,68),
(12,1078,6,'Concentration',410000,68),
(12,1275,11,'Aura Bolt',410000,68),
(12,1288,1,'Aura Symphony',410000,68),
(12,1297,5,'Clear Mind',410000,68),
(12,1296,6,'Rain of Fire',410000,68),
(12,1296,7,'Rain of Fire',520000,70),
(12,1417,4,'Aura Flash',520000,70),
(12,1289,1,'Inferno',520000,70),
(12,1275,12,'Aura Bolt',520000,70),
(12,1169,12,'Curse Fear',520000,70),
(12,1231,23,'Aura Flare',260000,70),
(12,1231,24,'Aura Flare',260000,70),
(12,1230,23,'Prominence',260000,70),
(12,1230,24,'Prominence',260000,70),
(12,1171,17,'Blazing Circle',520000,70),
(12,1160,13,'Slow',520000,70),
(12,1083,15,'Surrender To Fire',520000,70),
(12,1074,12,'Surrender To Wind',520000,70),
(12,1072,5,'Sleeping Cloud',520000,70),
(12,1069,37,'Sleep',260000,70),
(12,1069,38,'Sleep',260000,70),
(12,1056,10,'Cancellation',520000,70),
(12,285,25,'Higher Mana Gain',520000,70),
(12,249,37,'Weapon Mastery',260000,70),
(12,249,38,'Weapon Mastery',260000,70),
(12,234,36,'Robe Mastery',260000,70),
(12,234,37,'Robe Mastery',260000,70),
(12,146,40,'Anti Magic',260000,70),
(12,146,41,'Anti Magic',260000,70),
(12,146,42,'Anti Magic',440000,72),
(12,146,43,'Anti Magic',440000,72),
(12,234,38,'Robe Mastery',440000,72),
(12,234,39,'Robe Mastery',440000,72),
(12,249,39,'Weapon Mastery',440000,72),
(12,249,40,'Weapon Mastery',440000,72),
(12,285,26,'Higher Mana Gain',880000,72),
(12,1056,11,'Cancellation',880000,72),
(12,213,8,'Boost Mana',880000,72),
(12,1069,39,'Sleep',440000,72),
(12,1069,40,'Sleep',440000,72),
(12,1074,13,'Surrender To Wind',880000,72),
(12,1083,16,'Surrender To Fire',880000,72),
(12,1160,14,'Slow',880000,72),
(12,1171,18,'Blazing Circle',880000,72),
(12,1230,25,'Prominence',440000,72),
(12,1230,26,'Prominence',440000,72),
(12,1231,25,'Aura Flare',440000,72),
(12,1231,26,'Aura Flare',440000,72),
(12,1169,13,'Curse Fear',880000,72),
(12,1275,13,'Aura Bolt',880000,72),
(12,1292,1,'Elemental Assault',880000,72),
(12,1296,8,'Rain of Fire',880000,72),
(12,1296,9,'Rain of Fire',1150000,74),
(12,1417,5,'Aura Flash',1150000,74),
(12,1297,6,'Clear Mind',1150000,74),
(12,1233,4,'Decay',1150000,74),
(12,1275,14,'Aura Bolt',1150000,74),
(12,1169,14,'Curse Fear',1150000,74),
(12,1231,27,'Aura Flare',580000,74),
(12,1231,28,'Aura Flare',580000,74),
(12,1230,27,'Prominence',580000,74),
(12,1230,28,'Prominence',580000,74),
(12,1171,19,'Blazing Circle',1150000,74),
(12,1160,15,'Slow',1150000,74),
(12,1083,17,'Surrender To Fire',1150000,74),
(12,1074,14,'Surrender To Wind',1150000,74),
(12,229,7,'Fast Mana Recovery',1150000,74),
(12,1069,41,'Sleep',580000,74),
(12,1069,42,'Sleep',580000,74),
(12,212,6,'Fast HP Recovery',1150000,74),
(12,1056,12,'Cancellation',1150000,74),
(12,285,27,'Higher Mana Gain',1150000,74),
(12,249,41,'Weapon Mastery',580000,74),
(12,249,42,'Weapon Mastery',580000,74),
(12,234,40,'Robe Mastery',580000,74),
(12,234,41,'Robe Mastery',580000,74),
(12,146,44,'Anti Magic',580000,74),
(12,146,45,'Anti Magic',580000,74),
(13,146,13,'Anti Magic',11000,40),
(13,146,14,'Anti Magic',11000,40),
(13,146,15,'Anti Magic',11000,40),
(13,234,9,'Robe Mastery',11000,40),
(13,234,10,'Robe Mastery',11000,40),
(13,234,11,'Robe Mastery',11000,40),
(13,249,10,'Weapon Mastery',11000,40),
(13,249,11,'Weapon Mastery',11000,40),
(13,249,12,'Weapon Mastery',11000,40),
(13,285,9,'Higher Mana Gain',16000,40),
(13,285,10,'Higher Mana Gain',16000,40),
(13,213,3,'Boost Mana',32000,40),
(13,1064,1,'Silence',32000,40),
(13,1069,10,'Sleep',11000,40),
(13,1069,11,'Sleep',11000,40),
(13,1069,12,'Sleep',11000,40),
(13,1151,3,'Corpse Life Drain',32000,40),
(13,1154,1,'Summon Corrupted Man',32000,40),
(13,1157,2,'Body To Mind',32000,40),
(13,1163,1,'Curse Discord',32000,40),
(13,1164,6,'Curse: Weakness',32000,40),
(13,1169,1,'Curse Fear',32000,40),
(13,1222,2,'Curse Chaos',32000,40),
(13,1234,1,'Vampiric Claw',16000,40),
(13,1234,2,'Vampiric Claw',16000,40),
(13,1262,1,'Transfer Pain',32000,40),
(13,228,2,'Fast Spell Casting',32000,40),
(13,1263,1,'Curse Gloom',35000,44),
(13,1234,3,'Vampiric Claw',18000,44),
(13,1234,4,'Vampiric Claw',18000,44),
(13,1222,3,'Curse Chaos',35000,44),
(13,1170,1,'Anchor',35000,44),
(13,1169,2,'Curse Fear',35000,44),
(13,1168,4,'Curse: Poison',35000,44),
(13,1164,7,'Curse: Weakness',35000,44),
(13,1163,2,'Curse Discord',35000,44),
(13,1156,1,'Forget',35000,44),
(13,1151,4,'Corpse Life Drain',35000,44),
(13,229,3,'Fast Mana Recovery',35000,44),
(13,1129,1,'Summon Reanimated Man',35000,44),
(13,1148,1,'Death Spike',35000,44),
(13,1069,13,'Sleep',12000,44),
(13,1069,14,'Sleep',12000,44),
(13,1069,15,'Sleep',12000,44),
(13,1064,2,'Silence',35000,44),
(13,212,2,'Fast HP Recovery',35000,44),
(13,285,11,'Higher Mana Gain',18000,44),
(13,285,12,'Higher Mana Gain',18000,44),
(13,249,13,'Weapon Mastery',12000,44),
(13,249,14,'Weapon Mastery',12000,44),
(13,249,15,'Weapon Mastery',12000,44),
(13,234,12,'Robe Mastery',12000,44),
(13,234,13,'Robe Mastery',12000,44),
(13,234,14,'Robe Mastery',12000,44),
(13,146,16,'Anti Magic',12000,44),
(13,146,17,'Anti Magic',12000,44),
(13,146,18,'Anti Magic',12000,44),
(13,146,19,'Anti Magic',18000,48),
(13,146,20,'Anti Magic',18000,48),
(13,146,21,'Anti Magic',18000,48),
(13,234,15,'Robe Mastery',18000,48),
(13,234,16,'Robe Mastery',18000,48),
(13,234,17,'Robe Mastery',18000,48),
(13,249,16,'Weapon Mastery',18000,48),
(13,249,17,'Weapon Mastery',18000,48),
(13,249,18,'Weapon Mastery',18000,48),
(13,285,13,'Higher Mana Gain',27000,48),
(13,285,14,'Higher Mana Gain',27000,48),
(13,213,4,'Boost Mana',55000,48),
(13,1064,3,'Silence',55000,48),
(13,1069,16,'Sleep',18000,48),
(13,1069,17,'Sleep',18000,48),
(13,1069,18,'Sleep',18000,48),
(13,1148,2,'Death Spike',55000,48),
(13,1151,5,'Corpse Life Drain',55000,48),
(13,1155,1,'Corpse Burst',27000,48),
(13,1155,2,'Corpse Burst',27000,48),
(13,1156,2,'Forget',55000,48),
(13,1154,2,'Summon Corrupted Man',55000,48),
(13,1163,3,'Curse Discord',55000,48),
(13,1164,8,'Curse: Weakness',55000,48),
(13,1167,3,'Poisonous Cloud',55000,48),
(13,1169,3,'Curse Fear',55000,48),
(13,1170,2,'Anchor',55000,48),
(13,1222,4,'Curse Chaos',55000,48),
(13,1234,5,'Vampiric Claw',27000,48),
(13,1234,6,'Vampiric Claw',27000,48),
(13,1263,2,'Curse Gloom',55000,48),
(13,1262,2,'Transfer Pain',55000,48),
(13,164,3,'Quick Recycle',55000,48),
(13,1263,3,'Curse Gloom',78000,52),
(13,1234,7,'Vampiric Claw',39000,52),
(13,1234,8,'Vampiric Claw',39000,52),
(13,1222,5,'Curse Chaos',78000,52),
(13,1170,3,'Anchor',78000,52),
(13,1169,4,'Curse Fear',78000,52),
(13,1168,5,'Curse: Poison',78000,52),
(13,1164,9,'Curse: Weakness',78000,52),
(13,1163,4,'Curse Discord',78000,52),
(13,1157,3,'Body To Mind',78000,52),
(13,1156,3,'Forget',78000,52),
(13,1159,1,'Curse Death Link',39000,52),
(13,1159,2,'Curse Death Link',39000,52),
(13,1155,3,'Corpse Burst',39000,52),
(13,1155,4,'Corpse Burst',39000,52),
(13,1151,6,'Corpse Life Drain',78000,52),
(13,1148,3,'Death Spike',78000,52),
(13,1129,2,'Summon Reanimated Man',78000,52),
(13,229,4,'Fast Mana Recovery',78000,52),
(13,1069,19,'Sleep',26000,52),
(13,1069,20,'Sleep',26000,52),
(13,1069,21,'Sleep',26000,52),
(13,1064,4,'Silence',78000,52),
(13,212,3,'Fast HP Recovery',78000,52),
(13,285,15,'Higher Mana Gain',39000,52),
(13,285,16,'Higher Mana Gain',39000,52),
(13,249,19,'Weapon Mastery',26000,52),
(13,249,20,'Weapon Mastery',26000,52),
(13,249,21,'Weapon Mastery',26000,52),
(13,234,18,'Robe Mastery',26000,52),
(13,234,19,'Robe Mastery',26000,52),
(13,234,20,'Robe Mastery',26000,52),
(13,146,22,'Anti Magic',26000,52),
(13,146,23,'Anti Magic',26000,52),
(13,146,24,'Anti Magic',26000,52),
(13,146,25,'Anti Magic',28000,56),
(13,146,26,'Anti Magic',28000,56),
(13,146,27,'Anti Magic',28000,56),
(13,234,21,'Robe Mastery',28000,56),
(13,234,22,'Robe Mastery',28000,56),
(13,234,23,'Robe Mastery',28000,56),
(13,249,22,'Weapon Mastery',28000,56),
(13,249,23,'Weapon Mastery',28000,56),
(13,249,24,'Weapon Mastery',28000,56),
(13,285,17,'Higher Mana Gain',42000,56),
(13,285,18,'Higher Mana Gain',42000,56),
(13,213,5,'Boost Mana',83000,56),
(13,1064,5,'Silence',83000,56),
(13,1069,22,'Sleep',28000,56),
(13,1069,23,'Sleep',28000,56),
(13,1069,24,'Sleep',28000,56),
(13,1148,4,'Death Spike',83000,56),
(13,1151,7,'Corpse Life Drain',83000,56),
(13,1155,5,'Corpse Burst',42000,56),
(13,1155,6,'Corpse Burst',42000,56),
(13,1159,3,'Curse Death Link',42000,56),
(13,1159,4,'Curse Death Link',42000,56),
(13,1156,4,'Forget',83000,56),
(13,1154,3,'Summon Corrupted Man',83000,56),
(13,1163,5,'Curse Discord',83000,56),
(13,1164,10,'Curse: Weakness',83000,56),
(13,1167,4,'Poisonous Cloud',83000,56),
(13,1169,5,'Curse Fear',83000,56),
(13,1170,4,'Anchor',83000,56),
(13,1222,6,'Curse Chaos',83000,56),
(13,1234,9,'Vampiric Claw',42000,56),
(13,1234,10,'Vampiric Claw',42000,56),
(13,1263,4,'Curse Gloom',83000,56),
(13,1262,3,'Transfer Pain',83000,56),
(13,1334,1,'Summon Cursed Man',83000,56),
(13,228,3,'Fast Spell Casting',83000,56),
(13,1387,1,'Summon Cursed Bones',88000,58),
(13,1381,1,'Mass Fear',88000,58),
(13,1382,1,'Mass Gloom',88000,58),
(13,1262,4,'Transfer Pain',88000,58),
(13,1263,5,'Curse Gloom',88000,58),
(13,1269,1,'Curse Disease',88000,58),
(13,1234,11,'Vampiric Claw',44000,58),
(13,1234,12,'Vampiric Claw',44000,58),
(13,1222,7,'Curse Chaos',88000,58),
(13,1170,5,'Anchor',88000,58),
(13,1169,6,'Curse Fear',88000,58),
(13,1164,11,'Curse: Weakness',88000,58),
(13,1163,6,'Curse Discord',88000,58),
(13,1157,4,'Body To Mind',88000,58),
(13,1156,5,'Forget',88000,58),
(13,1159,5,'Curse Death Link',44000,58),
(13,1159,6,'Curse Death Link',44000,58),
(13,1155,7,'Corpse Burst',88000,58),
(13,1151,8,'Corpse Life Drain',88000,58),
(13,1148,5,'Death Spike',88000,58),
(13,1069,25,'Sleep',44000,58),
(13,1069,26,'Sleep',44000,58),
(13,1064,6,'Silence',88000,58),
(13,212,4,'Fast HP Recovery',88000,58),
(13,285,19,'Higher Mana Gain',88000,58),
(13,249,25,'Weapon Mastery',44000,58),
(13,249,26,'Weapon Mastery',44000,58),
(13,234,24,'Robe Mastery',44000,58),
(13,234,25,'Robe Mastery',44000,58),
(13,146,28,'Anti Magic',44000,58),
(13,146,29,'Anti Magic',44000,58),
(13,146,30,'Anti Magic',65000,60),
(13,146,31,'Anti Magic',65000,60),
(13,234,26,'Robe Mastery',65000,60),
(13,234,27,'Robe Mastery',65000,60),
(13,249,27,'Weapon Mastery',65000,60),
(13,249,28,'Weapon Mastery',65000,60),
(13,285,20,'Higher Mana Gain',130000,60),
(13,213,6,'Boost Mana',130000,60),
(13,1064,7,'Silence',130000,60),
(13,1069,27,'Sleep',65000,60),
(13,1069,28,'Sleep',65000,60),
(13,1148,6,'Death Spike',130000,60),
(13,229,5,'Fast Mana Recovery',130000,60),
(13,1129,3,'Summon Reanimated Man',130000,60),
(13,1151,9,'Corpse Life Drain',130000,60),
(13,1155,8,'Corpse Burst',130000,60),
(13,1159,7,'Curse Death Link',65000,60),
(13,1159,8,'Curse Death Link',65000,60),
(13,1156,6,'Forget',130000,60),
(13,1163,7,'Curse Discord',130000,60),
(13,1164,12,'Curse: Weakness',130000,60),
(13,1169,7,'Curse Fear',130000,60),
(13,1170,6,'Anchor',130000,60),
(13,1222,8,'Curse Chaos',130000,60),
(13,1234,13,'Vampiric Claw',65000,60),
(13,1234,14,'Vampiric Claw',65000,60),
(13,1269,2,'Curse Disease',130000,60),
(13,1263,6,'Curse Gloom',130000,60),
(13,1334,2,'Summon Cursed Man',130000,60),
(13,1298,1,'Mass Slow',170000,62),
(13,1298,2,'Mass Slow',170000,62),
(13,1263,7,'Curse Gloom',170000,62),
(13,1269,3,'Curse Disease',170000,62),
(13,1234,15,'Vampiric Claw',80000,62),
(13,1234,16,'Vampiric Claw',80000,62),
(13,1222,9,'Curse Chaos',170000,62),
(13,1170,7,'Anchor',170000,62),
(13,1382,2,'Mass Gloom',170000,62),
(13,1381,2,'Mass Fear',170000,62),
(13,1169,8,'Curse Fear',170000,62),
(13,1168,6,'Curse: Poison',170000,62),
(13,1164,13,'Curse: Weakness',170000,62),
(13,1163,8,'Curse Discord',170000,62),
(13,1156,7,'Forget',170000,62),
(13,1154,4,'Summon Corrupted Man',170000,62),
(13,1159,9,'Curse Death Link',80000,62),
(13,1159,10,'Curse Death Link',80000,62),
(13,1155,9,'Corpse Burst',170000,62),
(13,1151,10,'Corpse Life Drain',170000,62),
(13,1148,7,'Death Spike',170000,62),
(13,1069,29,'Sleep',80000,62),
(13,1069,30,'Sleep',80000,62),
(13,1064,8,'Silence',170000,62),
(13,285,21,'Higher Mana Gain',170000,62),
(13,249,29,'Weapon Mastery',80000,62),
(13,249,30,'Weapon Mastery',80000,62),
(13,234,28,'Robe Mastery',80000,62),
(13,234,29,'Robe Mastery',80000,62),
(13,146,32,'Anti Magic',80000,62),
(13,146,33,'Anti Magic',80000,62),
(13,146,34,'Anti Magic',100000,64),
(13,146,35,'Anti Magic',100000,64),
(13,234,30,'Robe Mastery',100000,64),
(13,234,31,'Robe Mastery',100000,64),
(13,249,31,'Weapon Mastery',100000,64),
(13,249,32,'Weapon Mastery',100000,64),
(13,285,22,'Higher Mana Gain',200000,64),
(13,1064,9,'Silence',200000,64),
(13,212,5,'Fast HP Recovery',200000,64),
(13,1069,31,'Sleep',100000,64),
(13,1069,32,'Sleep',100000,64),
(13,1148,8,'Death Spike',200000,64),
(13,1129,4,'Summon Reanimated Man',200000,64),
(13,1151,11,'Corpse Life Drain',200000,64),
(13,1155,10,'Corpse Burst',200000,64),
(13,1159,11,'Curse Death Link',100000,64),
(13,1159,12,'Curse Death Link',100000,64),
(13,1156,8,'Forget',200000,64),
(13,1163,9,'Curse Discord',200000,64),
(13,1164,14,'Curse: Weakness',200000,64),
(13,1167,5,'Poisonous Cloud',200000,64),
(13,1169,9,'Curse Fear',200000,64),
(13,1170,8,'Anchor',200000,64),
(13,1222,10,'Curse Chaos',200000,64),
(13,1234,17,'Vampiric Claw',100000,64),
(13,1234,18,'Vampiric Claw',100000,64),
(13,1269,4,'Curse Disease',200000,64),
(13,1263,8,'Curse Gloom',200000,64),
(13,1298,3,'Mass Slow',100000,64),
(13,1298,4,'Mass Slow',100000,64),
(13,1334,3,'Summon Cursed Man',200000,64),
(13,1298,5,'Mass Slow',270000,66),
(13,1298,6,'Mass Slow',270000,66),
(13,1263,9,'Curse Gloom',270000,66),
(13,1269,5,'Curse Disease',270000,66),
(13,1234,19,'Vampiric Claw',130000,66),
(13,1234,20,'Vampiric Claw',130000,66),
(13,1222,11,'Curse Chaos',270000,66),
(13,1170,9,'Anchor',270000,66),
(13,1381,3,'Mass Fear',270000,66),
(13,1382,3,'Mass Gloom',270000,66),
(13,1387,2,'Summon Cursed Bones',270000,66),
(13,1169,10,'Curse Fear',270000,66),
(13,1164,15,'Curse: Weakness',270000,66),
(13,1163,10,'Curse Discord',270000,66),
(13,1156,9,'Forget',270000,66),
(13,1154,5,'Summon Corrupted Man',270000,66),
(13,1157,5,'Body To Mind',270000,66),
(13,1159,13,'Curse Death Link',130000,66),
(13,1159,14,'Curse Death Link',130000,66),
(13,1155,11,'Corpse Burst',270000,66),
(13,1151,12,'Corpse Life Drain',270000,66),
(13,1148,9,'Death Spike',270000,66),
(13,1069,33,'Sleep',130000,66),
(13,1069,34,'Sleep',130000,66),
(13,213,7,'Boost Mana',270000,66),
(13,1064,10,'Silence',270000,66),
(13,285,23,'Higher Mana Gain',270000,66),
(13,249,33,'Weapon Mastery',130000,66),
(13,249,34,'Weapon Mastery',130000,66),
(13,234,32,'Robe Mastery',130000,66),
(13,234,33,'Robe Mastery',130000,66),
(13,146,36,'Anti Magic',130000,66),
(13,146,37,'Anti Magic',130000,66),
(13,146,38,'Anti Magic',170000,68),
(13,146,39,'Anti Magic',170000,68),
(13,234,34,'Robe Mastery',170000,68),
(13,234,35,'Robe Mastery',170000,68),
(13,249,35,'Weapon Mastery',170000,68),
(13,249,36,'Weapon Mastery',170000,68),
(13,285,24,'Higher Mana Gain',330000,68),
(13,1064,11,'Silence',330000,68),
(13,1069,35,'Sleep',170000,68),
(13,1069,36,'Sleep',170000,68),
(13,1148,10,'Death Spike',330000,68),
(13,1129,5,'Summon Reanimated Man',330000,68),
(13,229,6,'Fast Mana Recovery',330000,68),
(13,1151,13,'Corpse Life Drain',330000,68),
(13,1155,12,'Corpse Burst',330000,68),
(13,1159,15,'Curse Death Link',170000,68),
(13,1159,16,'Curse Death Link',170000,68),
(13,1156,10,'Forget',330000,68),
(13,1163,11,'Curse Discord',330000,68),
(13,1164,16,'Curse: Weakness',330000,68),
(13,1169,11,'Curse Fear',330000,68),
(13,1170,10,'Anchor',330000,68),
(13,1222,12,'Curse Chaos',330000,68),
(13,1234,21,'Vampiric Claw',170000,68),
(13,1234,22,'Vampiric Claw',170000,68),
(13,1269,6,'Curse Disease',330000,68),
(13,1263,10,'Curse Gloom',330000,68),
(13,1298,7,'Mass Slow',170000,68),
(13,1298,8,'Mass Slow',170000,68),
(13,1334,4,'Summon Cursed Man',330000,68),
(13,1334,5,'Summon Cursed Man',380000,70),
(13,1262,5,'Transfer Pain',380000,70),
(13,1298,9,'Mass Slow',190000,70),
(13,1298,10,'Mass Slow',190000,70),
(13,1263,11,'Curse Gloom',380000,70),
(13,1269,7,'Curse Disease',380000,70),
(13,1234,23,'Vampiric Claw',190000,70),
(13,1234,24,'Vampiric Claw',190000,70),
(13,1222,13,'Curse Chaos',380000,70),
(13,1170,11,'Anchor',380000,70),
(13,1382,4,'Mass Gloom',380000,70),
(13,1381,4,'Mass Fear',380000,70),
(13,1169,12,'Curse Fear',380000,70),
(13,1164,17,'Curse: Weakness',380000,70),
(13,1163,12,'Curse Discord',380000,70),
(13,1156,11,'Forget',380000,70),
(13,1154,6,'Summon Corrupted Man',380000,70),
(13,1159,17,'Curse Death Link',190000,70),
(13,1159,18,'Curse Death Link',190000,70),
(13,1155,13,'Corpse Burst',380000,70),
(13,1151,14,'Corpse Life Drain',380000,70),
(13,1148,11,'Death Spike',380000,70),
(13,1069,37,'Sleep',190000,70),
(13,1069,38,'Sleep',190000,70),
(13,1064,12,'Silence',380000,70),
(13,285,25,'Higher Mana Gain',380000,70),
(13,249,37,'Weapon Mastery',190000,70),
(13,249,38,'Weapon Mastery',190000,70),
(13,234,36,'Robe Mastery',190000,70),
(13,234,37,'Robe Mastery',190000,70),
(13,146,40,'Anti Magic',190000,70),
(13,146,41,'Anti Magic',190000,70),
(13,146,42,'Anti Magic',310000,72),
(13,146,43,'Anti Magic',310000,72),
(13,234,38,'Robe Mastery',310000,72),
(13,234,39,'Robe Mastery',310000,72),
(13,249,39,'Weapon Mastery',310000,72),
(13,249,40,'Weapon Mastery',310000,72),
(13,285,26,'Higher Mana Gain',630000,72),
(13,1064,13,'Silence',630000,72),
(13,213,8,'Boost Mana',630000,72),
(13,1069,39,'Sleep',310000,72),
(13,1069,40,'Sleep',310000,72),
(13,1148,12,'Death Spike',630000,72),
(13,1129,6,'Summon Reanimated Man',630000,72),
(13,1151,15,'Corpse Life Drain',630000,72),
(13,1155,14,'Corpse Burst',630000,72),
(13,1159,19,'Curse Death Link',310000,72),
(13,1159,20,'Curse Death Link',310000,72),
(13,1156,12,'Forget',630000,72),
(13,1163,13,'Curse Discord',630000,72),
(13,1164,18,'Curse: Weakness',630000,72),
(13,1169,13,'Curse Fear',630000,72),
(13,1168,7,'Curse: Poison',630000,72),
(13,1170,12,'Anchor',630000,72),
(13,1222,14,'Curse Chaos',630000,72),
(13,1234,25,'Vampiric Claw',310000,72),
(13,1234,26,'Vampiric Claw',310000,72),
(13,1269,8,'Curse Disease',630000,72),
(13,1263,12,'Curse Gloom',630000,72),
(13,1298,11,'Mass Slow',310000,72),
(13,1298,12,'Mass Slow',310000,72),
(13,1334,6,'Summon Cursed Man',630000,72),
(13,1334,7,'Summon Cursed Man',820000,74),
(13,1298,13,'Mass Slow',410000,74),
(13,1298,14,'Mass Slow',410000,74),
(13,1263,13,'Curse Gloom',820000,74),
(13,1269,9,'Curse Disease',820000,74),
(13,1234,27,'Vampiric Claw',410000,74),
(13,1234,28,'Vampiric Claw',410000,74),
(13,1222,15,'Curse Chaos',820000,74),
(13,1170,13,'Anchor',820000,74),
(13,1381,5,'Mass Fear',820000,74),
(13,1382,5,'Mass Gloom',820000,74),
(13,1387,3,'Summon Cursed Bones',820000,74),
(13,1167,6,'Poisonous Cloud',820000,74),
(13,1169,14,'Curse Fear',820000,74),
(13,1164,19,'Curse: Weakness',820000,74),
(13,1163,14,'Curse Discord',820000,74),
(13,1156,13,'Forget',820000,74),
(13,1159,21,'Curse Death Link',410000,74),
(13,1159,22,'Curse Death Link',410000,74),
(13,1155,15,'Corpse Burst',820000,74),
(13,1151,16,'Corpse Life Drain',820000,74),
(13,1129,7,'Summon Reanimated Man',820000,74),
(13,229,7,'Fast Mana Recovery',820000,74),
(13,1148,13,'Death Spike',820000,74),
(13,1069,41,'Sleep',410000,74),
(13,1069,42,'Sleep',410000,74),
(13,212,6,'Fast HP Recovery',820000,74),
(13,1064,14,'Silence',820000,74),
(13,285,27,'Higher Mana Gain',820000,74),
(13,249,41,'Weapon Mastery',410000,74),
(13,249,42,'Weapon Mastery',410000,74),
(13,234,40,'Robe Mastery',410000,74),
(13,234,41,'Robe Mastery',410000,74),
(13,146,44,'Anti Magic',410000,74),
(13,146,45,'Anti Magic',410000,74),
(14,146,13,'Anti Magic',11000,40),
(14,146,14,'Anti Magic',11000,40),
(14,146,15,'Anti Magic',11000,40),
(14,234,9,'Robe Mastery',11000,40),
(14,234,10,'Robe Mastery',11000,40),
(14,234,11,'Robe Mastery',11000,40),
(14,249,10,'Weapon Mastery',11000,40),
(14,249,11,'Weapon Mastery',11000,40),
(14,249,12,'Weapon Mastery',11000,40),
(14,258,1,'Light Armor Mastery',11000,40),
(14,258,2,'Light Armor Mastery',11000,40),
(14,258,3,'Light Armor Mastery',11000,40),
(14,10,1,'Summon Storm Cubic',32000,40),
(14,213,3,'Boost Mana',32000,40),
(14,228,2,'Fast Spell Casting',32000,40),
(14,1111,5,'Summon Kat the Cat',32000,40),
(14,1127,13,'Servitor Heal',11000,40),
(14,1127,14,'Servitor Heal',11000,40),
(14,1127,15,'Servitor Heal',11000,40),
(14,1126,7,'Servitor Recharge',16000,40),
(14,1126,8,'Servitor Recharge',16000,40),
(14,1140,1,'Servitor Physical Shield',32000,40),
(14,1225,5,'Summon Mew the Cat',32000,40),
(14,1276,1,'Summon Kai the Cat',32000,40),
(14,1279,1,'Summon Binding Cubic',32000,40),
(14,1262,1,'Transfer Pain',32000,40),
(14,1300,1,'Servitor Cure',32000,40),
(14,1328,1,'Mass Summon Storm Cubic',32000,40),
(14,1328,2,'Mass Summon Storm Cubic',41000,44),
(14,1279,2,'Summon Binding Cubic',41000,44),
(14,1276,2,'Summon Kai the Cat',41000,44),
(14,1225,6,'Summon Mew the Cat',41000,44),
(14,1139,1,'Servitor Magic Shield',41000,44),
(14,1141,1,'Servitor Haste',41000,44),
(14,1126,9,'Servitor Recharge',21000,44),
(14,1126,10,'Servitor Recharge',21000,44),
(14,1127,16,'Servitor Heal',14000,44),
(14,1127,17,'Servitor Heal',14000,44),
(14,1127,18,'Servitor Heal',14000,44),
(14,1111,6,'Summon Kat the Cat',41000,44),
(14,143,1,'Cubic Mastery',41000,44),
(14,229,3,'Fast Mana Recovery',41000,44),
(14,212,2,'Fast HP Recovery',41000,44),
(14,10,2,'Summon Storm Cubic',41000,44),
(14,258,4,'Light Armor Mastery',14000,44),
(14,258,5,'Light Armor Mastery',14000,44),
(14,258,6,'Light Armor Mastery',14000,44),
(14,249,13,'Weapon Mastery',14000,44),
(14,249,14,'Weapon Mastery',14000,44),
(14,249,15,'Weapon Mastery',14000,44),
(14,234,12,'Robe Mastery',14000,44),
(14,234,13,'Robe Mastery',14000,44),
(14,234,14,'Robe Mastery',14000,44),
(14,146,16,'Anti Magic',14000,44),
(14,146,17,'Anti Magic',14000,44),
(14,146,18,'Anti Magic',14000,44),
(14,146,19,'Anti Magic',25000,48),
(14,146,20,'Anti Magic',25000,48),
(14,146,21,'Anti Magic',25000,48),
(14,234,15,'Robe Mastery',25000,48),
(14,234,16,'Robe Mastery',25000,48),
(14,234,17,'Robe Mastery',25000,48),
(14,249,16,'Weapon Mastery',25000,48),
(14,249,17,'Weapon Mastery',25000,48),
(14,249,18,'Weapon Mastery',25000,48),
(14,258,7,'Light Armor Mastery',25000,48),
(14,258,8,'Light Armor Mastery',25000,48),
(14,258,9,'Light Armor Mastery',25000,48),
(14,213,4,'Boost Mana',75000,48),
(14,1111,7,'Summon Kat the Cat',75000,48),
(14,1127,19,'Servitor Heal',25000,48),
(14,1127,20,'Servitor Heal',25000,48),
(14,1127,21,'Servitor Heal',25000,48),
(14,1126,11,'Servitor Recharge',38000,48),
(14,1126,12,'Servitor Recharge',38000,48),
(14,164,3,'Quick Recycle',75000,48),
(14,1144,2,'Servitor Wind Walk',75000,48),
(14,1140,2,'Servitor Physical Shield',75000,48),
(14,1225,7,'Summon Mew the Cat',75000,48),
(14,1276,3,'Summon Kai the Cat',75000,48),
(14,1279,3,'Summon Binding Cubic',75000,48),
(14,1300,2,'Servitor Cure',75000,48),
(14,1262,2,'Transfer Pain',75000,48),
(14,1328,3,'Mass Summon Storm Cubic',106000,52),
(14,1279,4,'Summon Binding Cubic',106000,52),
(14,1276,4,'Summon Kai the Cat',106000,52),
(14,1225,8,'Summon Mew the Cat',106000,52),
(14,1139,2,'Servitor Magic Shield',106000,52),
(14,1141,2,'Servitor Haste',106000,52),
(14,1126,13,'Servitor Recharge',53000,52),
(14,1126,14,'Servitor Recharge',53000,52),
(14,1127,22,'Servitor Heal',35000,52),
(14,1127,23,'Servitor Heal',35000,52),
(14,1127,24,'Servitor Heal',35000,52),
(14,1111,8,'Summon Kat the Cat',106000,52),
(14,229,4,'Fast Mana Recovery',106000,52),
(14,212,3,'Fast HP Recovery',106000,52),
(14,10,3,'Summon Storm Cubic',106000,52),
(14,258,10,'Light Armor Mastery',35000,52),
(14,258,11,'Light Armor Mastery',35000,52),
(14,258,12,'Light Armor Mastery',35000,52),
(14,249,19,'Weapon Mastery',35000,52),
(14,249,20,'Weapon Mastery',35000,52),
(14,249,21,'Weapon Mastery',35000,52),
(14,234,18,'Robe Mastery',35000,52),
(14,234,19,'Robe Mastery',35000,52),
(14,234,20,'Robe Mastery',35000,52),
(14,146,22,'Anti Magic',35000,52),
(14,146,23,'Anti Magic',35000,52),
(14,146,24,'Anti Magic',35000,52),
(14,1299,1,'Servitor Empowerment',106000,52),
(14,1403,1,'Summon Friend',105000,56),
(14,1386,1,'Arcane Disruption',105000,56),
(14,1331,1,'Summon Feline Queen',105000,56),
(14,1380,1,'Betray',105000,56),
(14,146,25,'Anti Magic',35000,56),
(14,146,26,'Anti Magic',35000,56),
(14,146,27,'Anti Magic',35000,56),
(14,234,21,'Robe Mastery',35000,56),
(14,234,22,'Robe Mastery',35000,56),
(14,234,23,'Robe Mastery',35000,56),
(14,249,22,'Weapon Mastery',35000,56),
(14,249,23,'Weapon Mastery',35000,56),
(14,249,24,'Weapon Mastery',35000,56),
(14,258,13,'Light Armor Mastery',35000,56),
(14,258,14,'Light Armor Mastery',35000,56),
(14,258,15,'Light Armor Mastery',35000,56),
(14,213,5,'Boost Mana',105000,56),
(14,143,2,'Cubic Mastery',105000,56),
(14,228,3,'Fast Spell Casting',105000,56),
(14,1111,9,'Summon Kat the Cat',105000,56),
(14,1127,25,'Servitor Heal',35000,56),
(14,1127,26,'Servitor Heal',35000,56),
(14,1127,27,'Servitor Heal',35000,56),
(14,1126,15,'Servitor Recharge',53000,56),
(14,1126,16,'Servitor Recharge',53000,56),
(14,1140,3,'Servitor Physical Shield',105000,56),
(14,1225,9,'Summon Mew the Cat',105000,56),
(14,1276,5,'Summon Kai the Cat',105000,56),
(14,1279,5,'Summon Binding Cubic',105000,56),
(14,1262,3,'Transfer Pain',105000,56),
(14,1262,4,'Transfer Pain',129000,58),
(14,1328,4,'Mass Summon Storm Cubic',129000,58),
(14,1276,6,'Summon Kai the Cat',129000,58),
(14,1225,10,'Summon Mew the Cat',129000,58),
(14,1126,17,'Servitor Recharge',65000,58),
(14,1126,18,'Servitor Recharge',65000,58),
(14,1127,28,'Servitor Heal',65000,58),
(14,1127,29,'Servitor Heal',65000,58),
(14,1111,10,'Summon Kat the Cat',129000,58),
(14,212,4,'Fast HP Recovery',129000,58),
(14,10,4,'Summon Storm Cubic',129000,58),
(14,258,16,'Light Armor Mastery',65000,58),
(14,258,17,'Light Armor Mastery',65000,58),
(14,249,25,'Weapon Mastery',65000,58),
(14,249,26,'Weapon Mastery',65000,58),
(14,234,24,'Robe Mastery',65000,58),
(14,234,25,'Robe Mastery',65000,58),
(14,146,28,'Anti Magic',65000,58),
(14,146,29,'Anti Magic',65000,58),
(14,1380,2,'Betray',129000,58),
(14,1331,2,'Summon Feline Queen',129000,58),
(14,1386,2,'Arcane Disruption',129000,58),
(14,1383,1,'Mass Surrender to Fire',129000,58),
(14,1386,3,'Arcane Disruption',188000,60),
(14,1331,3,'Summon Feline Queen',188000,60),
(14,1380,3,'Betray',188000,60),
(14,146,30,'Anti Magic',94000,60),
(14,146,31,'Anti Magic',94000,60),
(14,234,26,'Robe Mastery',94000,60),
(14,234,27,'Robe Mastery',94000,60),
(14,249,27,'Weapon Mastery',94000,60),
(14,249,28,'Weapon Mastery',94000,60),
(14,258,18,'Light Armor Mastery',94000,60),
(14,258,19,'Light Armor Mastery',94000,60),
(14,213,6,'Boost Mana',188000,60),
(14,1111,11,'Summon Kat the Cat',188000,60),
(14,229,5,'Fast Mana Recovery',188000,60),
(14,1127,30,'Servitor Heal',94000,60),
(14,1127,31,'Servitor Heal',94000,60),
(14,1126,19,'Servitor Recharge',94000,60),
(14,1126,20,'Servitor Recharge',94000,60),
(14,1225,11,'Summon Mew the Cat',188000,60),
(14,1276,7,'Summon Kai the Cat',188000,60),
(14,1279,6,'Summon Binding Cubic',188000,60),
(14,1300,3,'Servitor Cure',188000,60),
(14,1301,1,'Servitor Blessing',250000,62),
(14,1328,5,'Mass Summon Storm Cubic',250000,62),
(14,1276,8,'Summon Kai the Cat',250000,62),
(14,1225,12,'Summon Mew the Cat',250000,62),
(14,1126,21,'Servitor Recharge',130000,62),
(14,1126,22,'Servitor Recharge',130000,62),
(14,1127,32,'Servitor Heal',130000,62),
(14,1127,33,'Servitor Heal',130000,62),
(14,1111,12,'Summon Kat the Cat',250000,62),
(14,10,5,'Summon Storm Cubic',250000,62),
(14,258,20,'Light Armor Mastery',130000,62),
(14,258,21,'Light Armor Mastery',130000,62),
(14,249,29,'Weapon Mastery',130000,62),
(14,249,30,'Weapon Mastery',130000,62),
(14,234,28,'Robe Mastery',130000,62),
(14,234,29,'Robe Mastery',130000,62),
(14,146,32,'Anti Magic',130000,62),
(14,146,33,'Anti Magic',130000,62),
(14,1380,4,'Betray',250000,62),
(14,1331,4,'Summon Feline Queen',250000,62),
(14,1386,4,'Arcane Disruption',250000,62),
(14,1383,2,'Mass Surrender to Fire',250000,62),
(14,1386,5,'Arcane Disruption',340000,64),
(14,1331,5,'Summon Feline Queen',340000,64),
(14,1380,5,'Betray',340000,64),
(14,146,34,'Anti Magic',170000,64),
(14,146,35,'Anti Magic',170000,64),
(14,234,30,'Robe Mastery',170000,64),
(14,234,31,'Robe Mastery',170000,64),
(14,249,31,'Weapon Mastery',170000,64),
(14,249,32,'Weapon Mastery',170000,64),
(14,258,22,'Light Armor Mastery',170000,64),
(14,258,23,'Light Armor Mastery',170000,64),
(14,212,5,'Fast HP Recovery',340000,64),
(14,1111,13,'Summon Kat the Cat',340000,64),
(14,1127,34,'Servitor Heal',170000,64),
(14,1127,35,'Servitor Heal',170000,64),
(14,1126,23,'Servitor Recharge',170000,64),
(14,1126,24,'Servitor Recharge',170000,64),
(14,1225,13,'Summon Mew the Cat',340000,64),
(14,1276,9,'Summon Kai the Cat',340000,64),
(14,1279,7,'Summon Binding Cubic',340000,64),
(14,1276,10,'Summon Kai the Cat',440000,66),
(14,1328,6,'Mass Summon Storm Cubic',440000,66),
(14,1225,14,'Summon Mew the Cat',440000,66),
(14,1126,25,'Servitor Recharge',220000,66),
(14,1126,26,'Servitor Recharge',220000,66),
(14,1127,36,'Servitor Heal',220000,66),
(14,1127,37,'Servitor Heal',220000,66),
(14,1111,14,'Summon Kat the Cat',440000,66),
(14,213,7,'Boost Mana',440000,66),
(14,10,6,'Summon Storm Cubic',440000,66),
(14,258,24,'Light Armor Mastery',220000,66),
(14,258,25,'Light Armor Mastery',220000,66),
(14,249,33,'Weapon Mastery',220000,66),
(14,249,34,'Weapon Mastery',220000,66),
(14,234,32,'Robe Mastery',220000,66),
(14,234,33,'Robe Mastery',220000,66),
(14,146,36,'Anti Magic',220000,66),
(14,146,37,'Anti Magic',220000,66),
(14,1380,6,'Betray',440000,66),
(14,1331,6,'Summon Feline Queen',440000,66),
(14,1386,6,'Arcane Disruption',440000,66),
(14,1383,3,'Mass Surrender to Fire',440000,66),
(14,1386,7,'Arcane Disruption',550000,68),
(14,1331,7,'Summon Feline Queen',550000,68),
(14,1380,7,'Betray',550000,68),
(14,146,38,'Anti Magic',280000,68),
(14,146,39,'Anti Magic',280000,68),
(14,234,34,'Robe Mastery',280000,68),
(14,234,35,'Robe Mastery',280000,68),
(14,249,35,'Weapon Mastery',280000,68),
(14,249,36,'Weapon Mastery',280000,68),
(14,258,26,'Light Armor Mastery',280000,68),
(14,258,27,'Light Armor Mastery',280000,68),
(14,1111,15,'Summon Kat the Cat',550000,68),
(14,229,6,'Fast Mana Recovery',550000,68),
(14,1127,38,'Servitor Heal',280000,68),
(14,1127,39,'Servitor Heal',280000,68),
(14,1126,27,'Servitor Recharge',280000,68),
(14,1126,28,'Servitor Recharge',280000,68),
(14,1225,15,'Summon Mew the Cat',550000,68),
(14,1276,11,'Summon Kai the Cat',550000,68),
(14,1279,8,'Summon Binding Cubic',550000,68),
(14,1276,12,'Summon Kai the Cat',550000,70),
(14,1328,7,'Mass Summon Storm Cubic',550000,70),
(14,1262,5,'Transfer Pain',550000,70),
(14,1225,16,'Summon Mew the Cat',550000,70),
(14,1126,29,'Servitor Recharge',280000,70),
(14,1126,30,'Servitor Recharge',280000,70),
(14,1127,40,'Servitor Heal',280000,70),
(14,1127,41,'Servitor Heal',280000,70),
(14,1111,16,'Summon Kat the Cat',550000,70),
(14,10,7,'Summon Storm Cubic',550000,70),
(14,258,28,'Light Armor Mastery',280000,70),
(14,258,29,'Light Armor Mastery',280000,70),
(14,249,37,'Weapon Mastery',280000,70),
(14,249,38,'Weapon Mastery',280000,70),
(14,234,36,'Robe Mastery',280000,70),
(14,234,37,'Robe Mastery',280000,70),
(14,146,40,'Anti Magic',280000,70),
(14,146,41,'Anti Magic',280000,70),
(14,1380,8,'Betray',550000,70),
(14,1331,8,'Summon Feline Queen',550000,70),
(14,1386,8,'Arcane Disruption',550000,70),
(14,1383,4,'Mass Surrender to Fire',550000,70),
(14,1299,2,'Servitor Empowerment',550000,70),
(14,1386,9,'Arcane Disruption',1070000,72),
(14,1331,9,'Summon Feline Queen',1070000,72),
(14,1380,9,'Betray',1070000,72),
(14,146,42,'Anti Magic',540000,72),
(14,146,43,'Anti Magic',540000,72),
(14,234,38,'Robe Mastery',540000,72),
(14,234,39,'Robe Mastery',540000,72),
(14,249,39,'Weapon Mastery',540000,72),
(14,249,40,'Weapon Mastery',540000,72),
(14,258,30,'Light Armor Mastery',540000,72),
(14,258,31,'Light Armor Mastery',540000,72),
(14,213,8,'Boost Mana',1070000,72),
(14,1111,17,'Summon Kat the Cat',1070000,72),
(14,1127,42,'Servitor Heal',540000,72),
(14,1127,43,'Servitor Heal',540000,72),
(14,1126,31,'Servitor Recharge',540000,72),
(14,1126,32,'Servitor Recharge',540000,72),
(14,1225,17,'Summon Mew the Cat',1070000,72),
(14,1276,13,'Summon Kai the Cat',1070000,72),
(14,1279,9,'Summon Binding Cubic',1070000,72),
(14,1276,14,'Summon Kai the Cat',1350000,74),
(14,1328,8,'Mass Summon Storm Cubic',1350000,74),
(14,1225,18,'Summon Mew the Cat',1350000,74),
(14,1126,33,'Servitor Recharge',680000,74),
(14,1126,34,'Servitor Recharge',680000,74),
(14,1127,44,'Servitor Heal',680000,74),
(14,1127,45,'Servitor Heal',680000,74),
(14,1111,18,'Summon Kat the Cat',1350000,74),
(14,229,7,'Fast Mana Recovery',1350000,74),
(14,212,6,'Fast HP Recovery',1350000,74),
(14,10,8,'Summon Storm Cubic',1350000,74),
(14,258,32,'Light Armor Mastery',680000,74),
(14,258,33,'Light Armor Mastery',680000,74),
(14,249,41,'Weapon Mastery',680000,74),
(14,249,42,'Weapon Mastery',680000,74),
(14,234,40,'Robe Mastery',680000,74),
(14,234,41,'Robe Mastery',680000,74),
(14,146,44,'Anti Magic',680000,74),
(14,146,45,'Anti Magic',680000,74),
(14,1380,10,'Betray',1350000,74),
(14,1331,10,'Summon Feline Queen',1350000,74),
(14,1386,10,'Arcane Disruption',1350000,74),
(14,1383,5,'Mass Surrender to Fire',1350000,74),
(15,146,5,'Anti Magic',1600,20),
(15,146,6,'Anti Magic',1600,20),
(15,235,1,'Robe Mastery',1600,20),
(15,235,2,'Robe Mastery',1600,20),
(15,236,1,'Light Armor Mastery',1600,20),
(15,236,2,'Light Armor Mastery',1600,20),
(15,164,1,'Quick Recycle',3300,20),
(15,213,1,'Boost Mana',3300,20),
(15,249,3,'Weapon Mastery',3300,20),
(15,1011,7,'Heal',1100,20),
(15,1011,8,'Heal',1100,20),
(15,1011,9,'Heal',1100,20),
(15,1015,4,'Battle Heal',1100,20),
(15,1015,5,'Battle Heal',1100,20),
(15,1015,6,'Battle Heal',1100,20),
(15,1027,4,'Group Heal',1100,20),
(15,1027,5,'Group Heal',1100,20),
(15,1027,6,'Group Heal',1100,20),
(15,1031,1,'Disrupt Undead',1600,20),
(15,1031,2,'Disrupt Undead',1600,20),
(15,1016,1,'Resurrection',3300,20),
(15,1068,2,'Might',3300,20),
(15,1073,1,'Kiss of Eva',3300,20),
(15,1078,1,'Concentration',3300,20),
(15,1085,1,'Acumen',3300,20),
(15,1204,1,'Wind Walk',3300,20),
(15,1077,1,'Focus',6900,25),
(15,1201,1,'Dryad Root',2300,25),
(15,1201,2,'Dryad Root',2300,25),
(15,1201,3,'Dryad Root',2300,25),
(15,1069,1,'Sleep',2300,25),
(15,1069,2,'Sleep',2300,25),
(15,1069,3,'Sleep',2300,25),
(15,228,1,'Fast Spell Casting',6900,25),
(15,229,1,'Fast Mana Recovery',6900,25),
(15,1035,1,'Mental Shield',6900,25),
(15,1040,2,'Shield',6900,25),
(15,1043,1,'Holy Weapon',6900,25),
(15,1031,3,'Disrupt Undead',3400,25),
(15,1031,4,'Disrupt Undead',3400,25),
(15,1027,7,'Group Heal',2300,25),
(15,1027,8,'Group Heal',2300,25),
(15,1027,9,'Group Heal',2300,25),
(15,1015,7,'Battle Heal',2300,25),
(15,1015,8,'Battle Heal',2300,25),
(15,1015,9,'Battle Heal',2300,25),
(15,1011,10,'Heal',2300,25),
(15,1011,11,'Heal',2300,25),
(15,1011,12,'Heal',2300,25),
(15,249,4,'Weapon Mastery',3400,25),
(15,249,5,'Weapon Mastery',3400,25),
(15,236,3,'Light Armor Mastery',3400,25),
(15,236,4,'Light Armor Mastery',3400,25),
(15,235,3,'Robe Mastery',3400,25),
(15,235,4,'Robe Mastery',3400,25),
(15,146,7,'Anti Magic',3400,25),
(15,146,8,'Anti Magic',3400,25),
(15,146,9,'Anti Magic',6600,30),
(15,146,10,'Anti Magic',6600,30),
(15,235,5,'Robe Mastery',6600,30),
(15,235,6,'Robe Mastery',6600,30),
(15,236,5,'Light Armor Mastery',6600,30),
(15,236,6,'Light Armor Mastery',6600,30),
(15,249,6,'Weapon Mastery',6600,30),
(15,249,7,'Weapon Mastery',6600,30),
(15,213,2,'Boost Mana',13000,30),
(15,164,2,'Quick Recycle',13000,30),
(15,1011,13,'Heal',4400,30),
(15,1011,14,'Heal',4400,30),
(15,1011,15,'Heal',4400,30),
(15,1015,10,'Battle Heal',4400,30),
(15,1015,11,'Battle Heal',4400,30),
(15,1015,12,'Battle Heal',4400,30),
(15,1027,10,'Group Heal',4400,30),
(15,1027,11,'Group Heal',4400,30),
(15,1027,12,'Group Heal',4400,30),
(15,1031,5,'Disrupt Undead',6600,30),
(15,1031,6,'Disrupt Undead',6600,30),
(15,1016,2,'Resurrection',13000,30),
(15,1069,4,'Sleep',4400,30),
(15,1069,5,'Sleep',4400,30),
(15,1069,6,'Sleep',4400,30),
(15,1201,4,'Dryad Root',4400,30),
(15,1201,5,'Dryad Root',4400,30),
(15,1201,6,'Dryad Root',4400,30),
(15,1191,1,'Resist Fire',13000,30),
(15,1078,2,'Concentration',13000,30),
(15,1204,2,'Wind Walk',13000,30),
(15,1075,1,'Peace',21000,35),
(15,1085,2,'Acumen',21000,35),
(15,1201,7,'Dryad Root',7300,35),
(15,1201,8,'Dryad Root',7300,35),
(15,1201,9,'Dryad Root',7300,35),
(15,1069,7,'Sleep',7300,35),
(15,1069,8,'Sleep',7300,35),
(15,1069,9,'Sleep',7300,35),
(15,229,2,'Fast Mana Recovery',21000,35),
(15,1044,1,'Regeneration',21000,35),
(15,1062,1,'Berserker Spirit',21000,35),
(15,1031,7,'Disrupt Undead',11000,35),
(15,1031,8,'Disrupt Undead',11000,35),
(15,1027,13,'Group Heal',7300,35),
(15,1027,14,'Group Heal',7300,35),
(15,1027,15,'Group Heal',7300,35),
(15,1015,13,'Battle Heal',7300,35),
(15,1015,14,'Battle Heal',7300,35),
(15,1015,15,'Battle Heal',7300,35),
(15,1011,16,'Heal',7300,35),
(15,1011,17,'Heal',7300,35),
(15,1011,18,'Heal',7300,35),
(15,1012,2,'Cure Poison',21000,35),
(15,212,1,'Fast HP Recovery',21000,35),
(15,249,8,'Weapon Mastery',11000,35),
(15,249,9,'Weapon Mastery',11000,35),
(15,236,7,'Light Armor Mastery',11000,35),
(15,236,8,'Light Armor Mastery',11000,35),
(15,235,7,'Robe Mastery',11000,35),
(15,235,8,'Robe Mastery',11000,35),
(15,146,11,'Anti Magic',11000,35),
(15,146,12,'Anti Magic',11000,35),
(16,146,13,'Anti Magic',12000,40),
(16,146,14,'Anti Magic',12000,40),
(16,146,15,'Anti Magic',12000,40),
(16,235,9,'Robe Mastery',12000,40),
(16,235,10,'Robe Mastery',12000,40),
(16,235,11,'Robe Mastery',12000,40),
(16,236,9,'Light Armor Mastery',12000,40),
(16,236,10,'Light Armor Mastery',12000,40),
(16,236,11,'Light Armor Mastery',12000,40),
(16,249,10,'Weapon Mastery',12000,40),
(16,249,11,'Weapon Mastery',12000,40),
(16,249,12,'Weapon Mastery',12000,40),
(16,213,3,'Boost Mana',36000,40),
(16,228,2,'Fast Spell Casting',36000,40),
(16,1028,1,'Might of Heaven',18000,40),
(16,1028,2,'Might of Heaven',18000,40),
(16,1069,10,'Sleep',12000,40),
(16,1069,11,'Sleep',12000,40),
(16,1069,12,'Sleep',12000,40),
(16,1217,1,'Greater Heal',12000,40),
(16,1217,2,'Greater Heal',12000,40),
(16,1217,3,'Greater Heal',12000,40),
(16,1218,1,'Greater Battle Heal',12000,40),
(16,1218,2,'Greater Battle Heal',12000,40),
(16,1218,3,'Greater Battle Heal',12000,40),
(16,1219,1,'Greater Group Heal',12000,40),
(16,1219,2,'Greater Group Heal',12000,40),
(16,1219,3,'Greater Group Heal',12000,40),
(16,1049,1,'Requiem',36000,40),
(16,1075,2,'Peace',36000,40),
(16,1016,3,'Resurrection',36000,40),
(16,1254,1,'Mass Resurrection',36000,40),
(16,1254,2,'Mass Resurrection',43000,44),
(16,1258,1,'Restore Life',43000,44),
(16,1075,3,'Peace',43000,44),
(16,1049,2,'Requiem',43000,44),
(16,1219,4,'Greater Group Heal',14000,44),
(16,1219,5,'Greater Group Heal',14000,44),
(16,1219,6,'Greater Group Heal',14000,44),
(16,1218,4,'Greater Battle Heal',14000,44),
(16,1218,5,'Greater Battle Heal',14000,44),
(16,1218,6,'Greater Battle Heal',14000,44),
(16,1018,1,'Purify',43000,44),
(16,1217,4,'Greater Heal',14000,44),
(16,1217,5,'Greater Heal',14000,44),
(16,1217,6,'Greater Heal',14000,44),
(16,1069,13,'Sleep',14000,44),
(16,1069,14,'Sleep',14000,44),
(16,1069,15,'Sleep',14000,44),
(16,1028,3,'Might of Heaven',21000,44),
(16,1028,4,'Might of Heaven',21000,44),
(16,1034,1,'Repose',43000,44),
(16,229,3,'Fast Mana Recovery',43000,44),
(16,212,2,'Fast HP Recovery',43000,44),
(16,249,13,'Weapon Mastery',14000,44),
(16,249,14,'Weapon Mastery',14000,44),
(16,249,15,'Weapon Mastery',14000,44),
(16,236,12,'Light Armor Mastery',14000,44),
(16,236,13,'Light Armor Mastery',14000,44),
(16,236,14,'Light Armor Mastery',14000,44),
(16,235,12,'Robe Mastery',14000,44),
(16,235,13,'Robe Mastery',14000,44),
(16,235,14,'Robe Mastery',14000,44),
(16,1520,1,'Inquisitor',129000,44),
(16,146,16,'Anti Magic',14000,44),
(16,146,17,'Anti Magic',14000,44),
(16,146,18,'Anti Magic',14000,44),
(16,146,19,'Anti Magic',21000,48),
(16,146,20,'Anti Magic',21000,48),
(16,146,21,'Anti Magic',21000,48),
(16,235,15,'Robe Mastery',21000,48),
(16,235,16,'Robe Mastery',21000,48),
(16,235,17,'Robe Mastery',21000,48),
(16,236,15,'Light Armor Mastery',21000,48),
(16,236,16,'Light Armor Mastery',21000,48),
(16,236,17,'Light Armor Mastery',21000,48),
(16,249,16,'Weapon Mastery',21000,48),
(16,249,17,'Weapon Mastery',21000,48),
(16,249,18,'Weapon Mastery',21000,48),
(16,213,4,'Boost Mana',63000,48),
(16,164,3,'Quick Recycle',63000,48),
(16,1020,1,'Vitalize',21000,48),
(16,1020,2,'Vitalize',21000,48),
(16,1020,3,'Vitalize',21000,48),
(16,1034,2,'Repose',63000,48),
(16,1042,1,'Hold Undead',63000,48),
(16,1028,5,'Might of Heaven',32000,48),
(16,1028,6,'Might of Heaven',32000,48),
(16,1069,16,'Sleep',21000,48),
(16,1069,17,'Sleep',21000,48),
(16,1069,18,'Sleep',21000,48),
(16,1217,7,'Greater Heal',21000,48),
(16,1217,8,'Greater Heal',21000,48),
(16,1217,9,'Greater Heal',21000,48),
(16,1311,1,'Body of Avatar',63000,48),
(16,1218,7,'Greater Battle Heal',21000,48),
(16,1218,8,'Greater Battle Heal',21000,48),
(16,1218,9,'Greater Battle Heal',21000,48),
(16,1219,7,'Greater Group Heal',21000,48),
(16,1219,8,'Greater Group Heal',21000,48),
(16,1219,9,'Greater Group Heal',21000,48),
(16,1049,3,'Requiem',63000,48),
(16,1075,4,'Peace',63000,48),
(16,1258,2,'Restore Life',63000,48),
(16,1016,4,'Resurrection',63000,48),
(16,1254,3,'Mass Resurrection',84000,52),
(16,1258,3,'Restore Life',84000,52),
(16,1075,5,'Peace',84000,52),
(16,1049,4,'Requiem',84000,52),
(16,1219,10,'Greater Group Heal',28000,52),
(16,1219,11,'Greater Group Heal',28000,52),
(16,1219,12,'Greater Group Heal',28000,52),
(16,1218,10,'Greater Battle Heal',28000,52),
(16,1218,11,'Greater Battle Heal',28000,52),
(16,1218,12,'Greater Battle Heal',28000,52),
(16,1018,2,'Purify',84000,52),
(16,1217,10,'Greater Heal',28000,52),
(16,1217,11,'Greater Heal',28000,52),
(16,1217,12,'Greater Heal',28000,52),
(16,1069,19,'Sleep',28000,52),
(16,1069,20,'Sleep',28000,52),
(16,1069,21,'Sleep',28000,52),
(16,1028,7,'Might of Heaven',42000,52),
(16,1028,8,'Might of Heaven',42000,52),
(16,1042,2,'Hold Undead',84000,52),
(16,1034,3,'Repose',84000,52),
(16,1020,4,'Vitalize',28000,52),
(16,1020,5,'Vitalize',28000,52),
(16,1020,6,'Vitalize',28000,52),
(16,229,4,'Fast Mana Recovery',84000,52),
(16,212,3,'Fast HP Recovery',84000,52),
(16,249,19,'Weapon Mastery',28000,52),
(16,249,20,'Weapon Mastery',28000,52),
(16,249,21,'Weapon Mastery',28000,52),
(16,236,18,'Light Armor Mastery',28000,52),
(16,236,19,'Light Armor Mastery',28000,52),
(16,236,20,'Light Armor Mastery',28000,52),
(16,235,18,'Robe Mastery',28000,52),
(16,235,19,'Robe Mastery',28000,52),
(16,235,20,'Robe Mastery',28000,52),
(16,146,22,'Anti Magic',28000,52),
(16,146,23,'Anti Magic',28000,52),
(16,146,24,'Anti Magic',28000,52),
(16,146,25,'Anti Magic',27000,56),
(16,146,26,'Anti Magic',27000,56),
(16,146,27,'Anti Magic',27000,56),
(16,235,21,'Robe Mastery',27000,56),
(16,235,22,'Robe Mastery',27000,56),
(16,235,23,'Robe Mastery',27000,56),
(16,236,21,'Light Armor Mastery',27000,56),
(16,236,22,'Light Armor Mastery',27000,56),
(16,236,23,'Light Armor Mastery',27000,56),
(16,249,22,'Weapon Mastery',27000,56),
(16,249,23,'Weapon Mastery',27000,56),
(16,249,24,'Weapon Mastery',27000,56),
(16,213,5,'Boost Mana',81000,56),
(16,228,3,'Fast Spell Casting',81000,56),
(16,1020,7,'Vitalize',27000,56),
(16,1020,8,'Vitalize',27000,56),
(16,1020,9,'Vitalize',27000,56),
(16,1034,4,'Repose',81000,56),
(16,1042,3,'Hold Undead',81000,56),
(16,1028,9,'Might of Heaven',41000,56),
(16,1028,10,'Might of Heaven',41000,56),
(16,1069,22,'Sleep',27000,56),
(16,1069,23,'Sleep',27000,56),
(16,1069,24,'Sleep',27000,56),
(16,1217,13,'Greater Heal',27000,56),
(16,1217,14,'Greater Heal',27000,56),
(16,1217,15,'Greater Heal',27000,56),
(16,1311,2,'Body of Avatar',81000,56),
(16,1400,1,'Turn Undead',81000,56),
(16,1401,1,'Major Heal',81000,56),
(16,1430,1,'Invocation',81000,56),
(16,1218,13,'Greater Battle Heal',27000,56),
(16,1218,14,'Greater Battle Heal',27000,56),
(16,1218,15,'Greater Battle Heal',27000,56),
(16,1219,13,'Greater Group Heal',27000,56),
(16,1219,14,'Greater Group Heal',27000,56),
(16,1219,15,'Greater Group Heal',27000,56),
(16,1049,5,'Requiem',81000,56),
(16,1075,6,'Peace',81000,56),
(16,1258,4,'Restore Life',81000,56),
(16,1254,4,'Mass Resurrection',81000,56),
(16,1016,5,'Resurrection',81000,56),
(16,1394,1,'Trance',81000,56),
(16,1395,1,'Erase',81000,56),
(16,1396,1,'Magical Backfire',81000,56),
(16,1398,1,'Mana Burn',81000,56),
(16,1398,2,'Mana Burn',88000,58),
(16,1396,2,'Magical Backfire',88000,58),
(16,1395,2,'Erase',88000,58),
(16,1394,2,'Trance',88000,58),
(16,1254,5,'Mass Resurrection',88000,58),
(16,1075,7,'Peace',88000,58),
(16,1049,6,'Requiem',88000,58),
(16,1219,16,'Greater Group Heal',44000,58),
(16,1219,17,'Greater Group Heal',44000,58),
(16,1218,16,'Greater Battle Heal',44000,58),
(16,1218,17,'Greater Battle Heal',44000,58),
(16,1402,1,'Major Group Heal',88000,58),
(16,1401,2,'Major Heal',88000,58),
(16,1400,2,'Turn Undead',88000,58),
(16,1399,1,'Mana Storm',88000,58),
(16,1217,16,'Greater Heal',44000,58),
(16,1217,17,'Greater Heal',44000,58),
(16,1069,25,'Sleep',44000,58),
(16,1069,26,'Sleep',44000,58),
(16,1028,11,'Might of Heaven',88000,58),
(16,1042,4,'Hold Undead',88000,58),
(16,1034,5,'Repose',88000,58),
(16,1020,10,'Vitalize',44000,58),
(16,1020,11,'Vitalize',44000,58),
(16,1012,3,'Cure Poison',88000,58),
(16,212,4,'Fast HP Recovery',88000,58),
(16,249,25,'Weapon Mastery',44000,58),
(16,249,26,'Weapon Mastery',44000,58),
(16,236,24,'Light Armor Mastery',44000,58),
(16,236,25,'Light Armor Mastery',44000,58),
(16,235,24,'Robe Mastery',44000,58),
(16,235,25,'Robe Mastery',44000,58),
(16,146,28,'Anti Magic',44000,58),
(16,146,29,'Anti Magic',44000,58),
(16,146,30,'Anti Magic',60000,60),
(16,146,31,'Anti Magic',60000,60),
(16,235,26,'Robe Mastery',60000,60),
(16,235,27,'Robe Mastery',60000,60),
(16,236,26,'Light Armor Mastery',60000,60),
(16,236,27,'Light Armor Mastery',60000,60),
(16,249,27,'Weapon Mastery',60000,60),
(16,249,28,'Weapon Mastery',60000,60),
(16,213,6,'Boost Mana',120000,60),
(16,229,5,'Fast Mana Recovery',120000,60),
(16,1020,12,'Vitalize',60000,60),
(16,1020,13,'Vitalize',60000,60),
(16,1034,6,'Repose',120000,60),
(16,1042,5,'Hold Undead',120000,60),
(16,1028,12,'Might of Heaven',120000,60),
(16,1069,27,'Sleep',60000,60),
(16,1069,28,'Sleep',60000,60),
(16,1217,18,'Greater Heal',60000,60),
(16,1217,19,'Greater Heal',60000,60),
(16,1311,3,'Body of Avatar',120000,60),
(16,1400,3,'Turn Undead',120000,60),
(16,1401,3,'Major Heal',120000,60),
(16,1430,2,'Invocation',120000,60),
(16,1218,18,'Greater Battle Heal',60000,60),
(16,1218,19,'Greater Battle Heal',60000,60),
(16,1219,18,'Greater Group Heal',60000,60),
(16,1219,19,'Greater Group Heal',60000,60),
(16,1049,7,'Requiem',120000,60),
(16,1075,8,'Peace',120000,60),
(16,1016,6,'Resurrection',120000,60),
(16,1394,3,'Trance',120000,60),
(16,1395,3,'Erase',120000,60),
(16,1396,3,'Magical Backfire',120000,60),
(16,1398,3,'Mana Burn',120000,60),
(16,1398,4,'Mana Burn',170000,62),
(16,1396,4,'Magical Backfire',170000,62),
(16,1395,4,'Erase',170000,62),
(16,1394,4,'Trance',170000,62),
(16,1075,9,'Peace',170000,62),
(16,1049,8,'Requiem',170000,62),
(16,1219,20,'Greater Group Heal',90000,62),
(16,1219,21,'Greater Group Heal',90000,62),
(16,1218,20,'Greater Battle Heal',90000,62),
(16,1218,21,'Greater Battle Heal',90000,62),
(16,1402,2,'Major Group Heal',170000,62),
(16,1401,4,'Major Heal',170000,62),
(16,1400,4,'Turn Undead',170000,62),
(16,1399,2,'Mana Storm',170000,62),
(16,1018,3,'Purify',170000,62),
(16,1217,20,'Greater Heal',90000,62),
(16,1217,21,'Greater Heal',90000,62),
(16,1069,29,'Sleep',90000,62),
(16,1069,30,'Sleep',90000,62),
(16,1028,13,'Might of Heaven',170000,62),
(16,1042,6,'Hold Undead',170000,62),
(16,1034,7,'Repose',170000,62),
(16,1020,14,'Vitalize',90000,62),
(16,1020,15,'Vitalize',90000,62),
(16,249,29,'Weapon Mastery',90000,62),
(16,249,30,'Weapon Mastery',90000,62),
(16,236,28,'Light Armor Mastery',90000,62),
(16,236,29,'Light Armor Mastery',90000,62),
(16,235,28,'Robe Mastery',90000,62),
(16,235,29,'Robe Mastery',90000,62),
(16,146,32,'Anti Magic',90000,62),
(16,146,33,'Anti Magic',90000,62),
(16,146,34,'Anti Magic',100000,64),
(16,146,35,'Anti Magic',100000,64),
(16,235,30,'Robe Mastery',100000,64),
(16,235,31,'Robe Mastery',100000,64),
(16,236,30,'Light Armor Mastery',100000,64),
(16,236,31,'Light Armor Mastery',100000,64),
(16,249,31,'Weapon Mastery',100000,64),
(16,249,32,'Weapon Mastery',100000,64),
(16,1020,16,'Vitalize',100000,64),
(16,1020,17,'Vitalize',100000,64),
(16,212,5,'Fast HP Recovery',190000,64),
(16,1034,8,'Repose',190000,64),
(16,1042,7,'Hold Undead',190000,64),
(16,1028,14,'Might of Heaven',190000,64),
(16,1069,31,'Sleep',100000,64),
(16,1069,32,'Sleep',100000,64),
(16,1217,22,'Greater Heal',100000,64),
(16,1217,23,'Greater Heal',100000,64),
(16,1418,1,'Celestial Shield',190000,64),
(16,1311,4,'Body of Avatar',190000,64),
(16,1400,5,'Turn Undead',190000,64),
(16,1401,5,'Major Heal',190000,64),
(16,1430,3,'Invocation',190000,64),
(16,1218,22,'Greater Battle Heal',100000,64),
(16,1218,23,'Greater Battle Heal',100000,64),
(16,1219,22,'Greater Group Heal',100000,64),
(16,1219,23,'Greater Group Heal',100000,64),
(16,1049,9,'Requiem',190000,64),
(16,1075,10,'Peace',190000,64),
(16,1016,7,'Resurrection',190000,64),
(16,1394,5,'Trance',190000,64),
(16,1395,5,'Erase',190000,64),
(16,1396,5,'Magical Backfire',190000,64),
(16,1398,5,'Mana Burn',190000,64),
(16,1398,6,'Mana Burn',280000,66),
(16,1396,6,'Magical Backfire',280000,66),
(16,1395,6,'Erase',280000,66),
(16,1394,6,'Trance',280000,66),
(16,1271,1,'Benediction',280000,66),
(16,1307,1,'Prayer',280000,66),
(16,1075,11,'Peace',280000,66),
(16,1049,10,'Requiem',280000,66),
(16,1219,24,'Greater Group Heal',140000,66),
(16,1219,25,'Greater Group Heal',140000,66),
(16,1218,24,'Greater Battle Heal',140000,66),
(16,1218,25,'Greater Battle Heal',140000,66),
(16,1402,3,'Major Group Heal',280000,66),
(16,1401,6,'Major Heal',280000,66),
(16,1400,6,'Turn Undead',280000,66),
(16,1399,3,'Mana Storm',280000,66),
(16,1217,24,'Greater Heal',140000,66),
(16,1217,25,'Greater Heal',140000,66),
(16,1069,33,'Sleep',140000,66),
(16,1069,34,'Sleep',140000,66),
(16,1028,15,'Might of Heaven',280000,66),
(16,1042,8,'Hold Undead',280000,66),
(16,1034,9,'Repose',280000,66),
(16,213,7,'Boost Mana',280000,66),
(16,1020,18,'Vitalize',140000,66),
(16,1020,19,'Vitalize',140000,66),
(16,249,33,'Weapon Mastery',140000,66),
(16,249,34,'Weapon Mastery',140000,66),
(16,236,32,'Light Armor Mastery',140000,66),
(16,236,33,'Light Armor Mastery',140000,66),
(16,235,32,'Robe Mastery',140000,66),
(16,235,33,'Robe Mastery',140000,66),
(16,146,36,'Anti Magic',140000,66),
(16,146,37,'Anti Magic',140000,66),
(16,146,38,'Anti Magic',160000,68),
(16,146,39,'Anti Magic',160000,68),
(16,235,34,'Robe Mastery',160000,68),
(16,235,35,'Robe Mastery',160000,68),
(16,236,34,'Light Armor Mastery',160000,68),
(16,236,35,'Light Armor Mastery',160000,68),
(16,249,35,'Weapon Mastery',160000,68),
(16,249,36,'Weapon Mastery',160000,68),
(16,1020,20,'Vitalize',160000,68),
(16,1020,21,'Vitalize',160000,68),
(16,229,6,'Fast Mana Recovery',320000,68),
(16,1034,10,'Repose',320000,68),
(16,1042,9,'Hold Undead',320000,68),
(16,1028,16,'Might of Heaven',320000,68),
(16,1069,35,'Sleep',160000,68),
(16,1069,36,'Sleep',160000,68),
(16,1217,26,'Greater Heal',160000,68),
(16,1217,27,'Greater Heal',160000,68),
(16,1311,5,'Body of Avatar',320000,68),
(16,1400,7,'Turn Undead',320000,68),
(16,1401,7,'Major Heal',320000,68),
(16,1430,4,'Invocation',320000,68),
(16,1218,26,'Greater Battle Heal',160000,68),
(16,1218,27,'Greater Battle Heal',160000,68),
(16,1219,26,'Greater Group Heal',160000,68),
(16,1219,27,'Greater Group Heal',160000,68),
(16,1049,11,'Requiem',320000,68),
(16,1075,12,'Peace',320000,68),
(16,1254,6,'Mass Resurrection',320000,68),
(16,1394,7,'Trance',320000,68),
(16,1395,7,'Erase',320000,68),
(16,1396,7,'Magical Backfire',320000,68),
(16,1398,7,'Mana Burn',320000,68),
(16,1398,8,'Mana Burn',390000,70),
(16,1396,8,'Magical Backfire',390000,70),
(16,1395,8,'Erase',390000,70),
(16,1394,8,'Trance',390000,70),
(16,1016,8,'Resurrection',390000,70),
(16,1307,2,'Prayer',390000,70),
(16,1075,13,'Peace',390000,70),
(16,1049,12,'Requiem',390000,70),
(16,1219,28,'Greater Group Heal',200000,70),
(16,1219,29,'Greater Group Heal',200000,70),
(16,1218,28,'Greater Battle Heal',200000,70),
(16,1218,29,'Greater Battle Heal',200000,70),
(16,1402,4,'Major Group Heal',390000,70),
(16,1401,8,'Major Heal',390000,70),
(16,1400,8,'Turn Undead',390000,70),
(16,1399,4,'Mana Storm',390000,70),
(16,1217,28,'Greater Heal',200000,70),
(16,1217,29,'Greater Heal',200000,70),
(16,1069,37,'Sleep',200000,70),
(16,1069,38,'Sleep',200000,70),
(16,1028,17,'Might of Heaven',390000,70),
(16,1042,10,'Hold Undead',390000,70),
(16,1034,11,'Repose',390000,70),
(16,1020,22,'Vitalize',200000,70),
(16,1020,23,'Vitalize',200000,70),
(16,249,37,'Weapon Mastery',200000,70),
(16,249,38,'Weapon Mastery',200000,70),
(16,236,36,'Light Armor Mastery',200000,70),
(16,236,37,'Light Armor Mastery',200000,70),
(16,235,36,'Robe Mastery',200000,70),
(16,235,37,'Robe Mastery',200000,70),
(16,146,40,'Anti Magic',200000,70),
(16,146,41,'Anti Magic',200000,70),
(16,146,42,'Anti Magic',330000,72),
(16,146,43,'Anti Magic',330000,72),
(16,235,38,'Robe Mastery',330000,72),
(16,235,39,'Robe Mastery',330000,72),
(16,236,38,'Light Armor Mastery',330000,72),
(16,236,39,'Light Armor Mastery',330000,72),
(16,249,39,'Weapon Mastery',330000,72),
(16,249,40,'Weapon Mastery',330000,72),
(16,1020,24,'Vitalize',330000,72),
(16,1020,25,'Vitalize',330000,72),
(16,213,8,'Boost Mana',650000,72),
(16,1034,12,'Repose',650000,72),
(16,1042,11,'Hold Undead',650000,72),
(16,1028,18,'Might of Heaven',650000,72),
(16,1069,39,'Sleep',330000,72),
(16,1069,40,'Sleep',330000,72),
(16,1217,30,'Greater Heal',330000,72),
(16,1217,31,'Greater Heal',330000,72),
(16,1311,6,'Body of Avatar',650000,72),
(16,1400,9,'Turn Undead',650000,72),
(16,1401,9,'Major Heal',650000,72),
(16,1430,5,'Invocation',650000,72),
(16,1218,30,'Greater Battle Heal',330000,72),
(16,1218,31,'Greater Battle Heal',330000,72),
(16,1219,30,'Greater Group Heal',330000,72),
(16,1219,31,'Greater Group Heal',330000,72),
(16,1049,13,'Requiem',650000,72),
(16,1075,14,'Peace',650000,72),
(16,1394,9,'Trance',650000,72),
(16,1395,9,'Erase',650000,72),
(16,1396,9,'Magical Backfire',650000,72),
(16,1398,9,'Mana Burn',650000,72),
(16,1398,10,'Mana Burn',880000,74),
(16,1396,10,'Magical Backfire',880000,74),
(16,1395,10,'Erase',880000,74),
(16,1394,10,'Trance',880000,74),
(16,1075,15,'Peace',880000,74),
(16,1049,14,'Requiem',880000,74),
(16,1307,3,'Prayer',880000,74),
(16,1016,9,'Resurrection',880000,74),
(16,1219,32,'Greater Group Heal',440000,74),
(16,1219,33,'Greater Group Heal',440000,74),
(16,1218,32,'Greater Battle Heal',440000,74),
(16,1218,33,'Greater Battle Heal',440000,74),
(16,1402,5,'Major Group Heal',880000,74),
(16,1401,10,'Major Heal',880000,74),
(16,1401,11,'Major Heal',880000,74),
(16,1400,10,'Turn Undead',880000,74),
(16,1399,5,'Mana Storm',880000,74),
(16,1217,32,'Greater Heal',440000,74),
(16,1217,33,'Greater Heal',440000,74),
(16,1069,41,'Sleep',440000,74),
(16,1069,42,'Sleep',440000,74),
(16,1028,19,'Might of Heaven',880000,74),
(16,1042,12,'Hold Undead',880000,74),
(16,1034,13,'Repose',880000,74),
(16,212,6,'Fast HP Recovery',880000,74),
(16,229,7,'Fast Mana Recovery',880000,74),
(16,1020,26,'Vitalize',440000,74),
(16,1020,27,'Vitalize',440000,74),
(16,249,41,'Weapon Mastery',440000,74),
(16,249,42,'Weapon Mastery',440000,74),
(16,236,40,'Light Armor Mastery',440000,74),
(16,236,41,'Light Armor Mastery',440000,74),
(16,235,40,'Robe Mastery',440000,74),
(16,235,41,'Robe Mastery',440000,74),
(16,146,44,'Anti Magic',440000,74),
(16,146,45,'Anti Magic',440000,74),
(17,146,13,'Anti Magic',11000,40),
(17,146,14,'Anti Magic',11000,40),
(17,146,15,'Anti Magic',11000,40),
(17,235,9,'Robe Mastery',11000,40),
(17,235,10,'Robe Mastery',11000,40),
(17,235,11,'Robe Mastery',11000,40),
(17,236,9,'Light Armor Mastery',11000,40),
(17,236,10,'Light Armor Mastery',11000,40),
(17,236,11,'Light Armor Mastery',11000,40),
(17,249,10,'Weapon Mastery',11000,40),
(17,249,11,'Weapon Mastery',11000,40),
(17,249,12,'Weapon Mastery',11000,40),
(17,259,1,'Heavy Armor Mastery',11000,40),
(17,259,2,'Heavy Armor Mastery',11000,40),
(17,259,3,'Heavy Armor Mastery',11000,40),
(17,211,1,'Boost HP',32000,40),
(17,213,3,'Boost Mana',32000,40),
(17,1032,1,'Invigor',32000,40),
(17,228,2,'Fast Spell Casting',32000,40),
(17,1035,2,'Mental Shield',32000,40),
(17,1050,1,'Return',32000,40),
(17,1068,3,'Might',32000,40),
(17,1201,10,'Dryad Root',11000,40),
(17,1201,11,'Dryad Root',11000,40),
(17,1201,12,'Dryad Root',11000,40),
(17,1191,2,'Resist Fire',32000,40),
(17,1240,1,'Guidance',32000,40),
(17,1242,1,'Death Whisper',32000,40),
(17,1243,1,'Bless Shield',32000,40),
(17,1191,3,'Resist Fire',37000,44),
(17,1086,1,'Haste',37000,44),
(17,1272,1,'Word of Fear',37000,44),
(17,1201,13,'Dryad Root',12000,44),
(17,1201,14,'Dryad Root',12000,44),
(17,1201,15,'Dryad Root',12000,44),
(17,1077,2,'Focus',37000,44),
(17,1078,3,'Concentration',37000,44),
(17,1048,1,'Blessed Soul',37000,44),
(17,1036,1,'Magic Barrier',37000,44),
(17,1040,3,'Shield',37000,44),
(17,1526,1,'Steal Mana',37000,44),
(17,1045,1,'Blessed Body',37000,44),
(17,229,3,'Fast Mana Recovery',37000,44),
(17,211,2,'Boost HP',37000,44),
(17,212,2,'Fast HP Recovery',37000,44),
(17,259,4,'Heavy Armor Mastery',12000,44),
(17,259,5,'Heavy Armor Mastery',12000,44),
(17,259,6,'Heavy Armor Mastery',12000,44),
(17,249,13,'Weapon Mastery',12000,44),
(17,249,14,'Weapon Mastery',12000,44),
(17,249,15,'Weapon Mastery',12000,44),
(17,236,12,'Light Armor Mastery',12000,44),
(17,236,13,'Light Armor Mastery',12000,44),
(17,236,14,'Light Armor Mastery',12000,44),
(17,235,12,'Robe Mastery',12000,44),
(17,235,13,'Robe Mastery',12000,44),
(17,235,14,'Robe Mastery',12000,44),
(17,146,16,'Anti Magic',12000,44),
(17,146,17,'Anti Magic',12000,44),
(17,146,18,'Anti Magic',12000,44),
(17,146,19,'Anti Magic',21000,48),
(17,146,20,'Anti Magic',21000,48),
(17,146,21,'Anti Magic',21000,48),
(17,235,15,'Robe Mastery',21000,48),
(17,235,16,'Robe Mastery',21000,48),
(17,235,17,'Robe Mastery',21000,48),
(17,236,15,'Light Armor Mastery',21000,48),
(17,236,16,'Light Armor Mastery',21000,48),
(17,236,17,'Light Armor Mastery',21000,48),
(17,249,16,'Weapon Mastery',21000,48),
(17,249,17,'Weapon Mastery',21000,48),
(17,249,18,'Weapon Mastery',21000,48),
(17,259,7,'Heavy Armor Mastery',21000,48),
(17,259,8,'Heavy Armor Mastery',21000,48),
(17,259,9,'Heavy Armor Mastery',21000,48),
(17,211,3,'Boost HP',63000,48),
(17,213,4,'Boost Mana',63000,48),
(17,1045,2,'Blessed Body',63000,48),
(17,1044,2,'Regeneration',63000,48),
(17,1035,3,'Mental Shield',63000,48),
(17,1032,2,'Invigor',63000,48),
(17,1048,2,'Blessed Soul',63000,48),
(17,164,3,'Quick Recycle',63000,48),
(17,1201,16,'Dryad Root',21000,48),
(17,1201,17,'Dryad Root',21000,48),
(17,1201,18,'Dryad Root',21000,48),
(17,1272,2,'Word of Fear',63000,48),
(17,1243,2,'Bless Shield',63000,48),
(17,1242,2,'Death Whisper',63000,48),
(17,1240,2,'Guidance',63000,48),
(17,1085,3,'Acumen',63000,48),
(17,1272,3,'Word of Fear',89000,52),
(17,1086,2,'Haste',89000,52),
(17,1201,19,'Dryad Root',30000,52),
(17,1201,20,'Dryad Root',30000,52),
(17,1201,21,'Dryad Root',30000,52),
(17,1062,2,'Berserker Spirit',89000,52),
(17,1048,3,'Blessed Soul',89000,52),
(17,1078,4,'Concentration',89000,52),
(17,1077,3,'Focus',89000,52),
(17,1073,2,'Kiss of Eva',89000,52),
(17,1036,2,'Magic Barrier',89000,52),
(17,1045,3,'Blessed Body',89000,52),
(17,229,4,'Fast Mana Recovery',89000,52),
(17,211,4,'Boost HP',89000,52),
(17,212,3,'Fast HP Recovery',89000,52),
(17,259,10,'Heavy Armor Mastery',30000,52),
(17,259,11,'Heavy Armor Mastery',30000,52),
(17,259,12,'Heavy Armor Mastery',30000,52),
(17,249,19,'Weapon Mastery',30000,52),
(17,249,20,'Weapon Mastery',30000,52),
(17,249,21,'Weapon Mastery',30000,52),
(17,236,18,'Light Armor Mastery',30000,52),
(17,236,19,'Light Armor Mastery',30000,52),
(17,236,20,'Light Armor Mastery',30000,52),
(17,235,18,'Robe Mastery',30000,52),
(17,235,19,'Robe Mastery',30000,52),
(17,235,20,'Robe Mastery',30000,52),
(17,146,22,'Anti Magic',30000,52),
(17,146,23,'Anti Magic',30000,52),
(17,146,24,'Anti Magic',30000,52),
(17,146,25,'Anti Magic',31000,56),
(17,146,26,'Anti Magic',31000,56),
(17,146,27,'Anti Magic',31000,56),
(17,235,21,'Robe Mastery',31000,56),
(17,235,22,'Robe Mastery',31000,56),
(17,235,23,'Robe Mastery',31000,56),
(17,236,21,'Light Armor Mastery',31000,56),
(17,236,22,'Light Armor Mastery',31000,56),
(17,236,23,'Light Armor Mastery',31000,56),
(17,249,22,'Weapon Mastery',31000,56),
(17,249,23,'Weapon Mastery',31000,56),
(17,249,24,'Weapon Mastery',31000,56),
(17,259,13,'Heavy Armor Mastery',31000,56),
(17,259,14,'Heavy Armor Mastery',31000,56),
(17,259,15,'Heavy Armor Mastery',31000,56),
(17,211,5,'Boost HP',91000,56),
(17,213,5,'Boost Mana',91000,56),
(17,1045,4,'Blessed Body',91000,56),
(17,1044,3,'Regeneration',91000,56),
(17,1032,3,'Invigor',91000,56),
(17,1035,4,'Mental Shield',91000,56),
(17,1526,2,'Steal Mana',91000,56),
(17,228,3,'Fast Spell Casting',91000,56),
(17,1048,4,'Blessed Soul',91000,56),
(17,1050,2,'Return',91000,56),
(17,1201,22,'Dryad Root',31000,56),
(17,1201,23,'Dryad Root',31000,56),
(17,1201,24,'Dryad Root',31000,56),
(17,1272,4,'Word of Fear',91000,56),
(17,1240,3,'Guidance',91000,56),
(17,1242,3,'Death Whisper',91000,56),
(17,1243,3,'Bless Shield',91000,56),
(17,1395,1,'Erase',91000,56),
(17,1398,1,'Mana Burn',91000,56),
(17,1398,2,'Mana Burn',138000,58),
(17,1393,1,'Unholy Resistance',138000,58),
(17,1389,1,'Greater Shield',138000,58),
(17,1392,1,'Holy Resistance',138000,58),
(17,1395,2,'Erase',138000,58),
(17,1388,1,'Greater Might',138000,58),
(17,1272,5,'Word of Fear',138000,58),
(17,1182,1,'Resist Aqua',138000,58),
(17,1189,1,'Resist Wind',138000,58),
(17,1201,25,'Dryad Root',138000,58),
(17,212,4,'Fast HP Recovery',138000,58),
(17,259,16,'Heavy Armor Mastery',69000,58),
(17,259,17,'Heavy Armor Mastery',69000,58),
(17,249,25,'Weapon Mastery',69000,58),
(17,249,26,'Weapon Mastery',69000,58),
(17,236,24,'Light Armor Mastery',69000,58),
(17,236,25,'Light Armor Mastery',69000,58),
(17,235,24,'Robe Mastery',69000,58),
(17,235,25,'Robe Mastery',69000,58),
(17,146,28,'Anti Magic',69000,58),
(17,146,29,'Anti Magic',69000,58),
(17,146,30,'Anti Magic',115000,60),
(17,146,31,'Anti Magic',115000,60),
(17,235,26,'Robe Mastery',115000,60),
(17,235,27,'Robe Mastery',115000,60),
(17,236,26,'Light Armor Mastery',115000,60),
(17,236,27,'Light Armor Mastery',115000,60),
(17,249,27,'Weapon Mastery',115000,60),
(17,249,28,'Weapon Mastery',115000,60),
(17,259,18,'Heavy Armor Mastery',115000,60),
(17,259,19,'Heavy Armor Mastery',115000,60),
(17,213,6,'Boost Mana',231000,60),
(17,229,5,'Fast Mana Recovery',231000,60),
(17,1033,1,'Resist Poison',231000,60),
(17,1201,26,'Dryad Root',231000,60),
(17,1078,5,'Concentration',231000,60),
(17,1272,6,'Word of Fear',231000,60),
(17,1395,3,'Erase',231000,60),
(17,1398,3,'Mana Burn',231000,60),
(17,1398,4,'Mana Burn',301000,62),
(17,1395,4,'Erase',301000,62),
(17,1272,7,'Word of Fear',301000,62),
(17,1189,2,'Resist Wind',301000,62),
(17,1182,2,'Resist Aqua',301000,62),
(17,1048,5,'Blessed Soul',301000,62),
(17,1201,27,'Dryad Root',301000,62),
(17,211,6,'Boost HP',310000,62),
(17,259,20,'Heavy Armor Mastery',150000,62),
(17,259,21,'Heavy Armor Mastery',150000,62),
(17,249,29,'Weapon Mastery',150000,62),
(17,249,30,'Weapon Mastery',150000,62),
(17,236,28,'Light Armor Mastery',150000,62),
(17,236,29,'Light Armor Mastery',150000,62),
(17,235,28,'Robe Mastery',150000,62),
(17,235,29,'Robe Mastery',150000,62),
(17,146,32,'Anti Magic',150000,62),
(17,146,33,'Anti Magic',150000,62),
(17,146,34,'Anti Magic',180000,64),
(17,146,35,'Anti Magic',180000,64),
(17,235,30,'Robe Mastery',180000,64),
(17,235,31,'Robe Mastery',180000,64),
(17,236,30,'Light Armor Mastery',180000,64),
(17,236,31,'Light Armor Mastery',180000,64),
(17,249,31,'Weapon Mastery',180000,64),
(17,249,32,'Weapon Mastery',180000,64),
(17,259,22,'Heavy Armor Mastery',180000,64),
(17,259,23,'Heavy Armor Mastery',180000,64),
(17,212,5,'Fast HP Recovery',370000,64),
(17,1033,2,'Resist Poison',370000,64),
(17,1045,5,'Blessed Body',370000,64),
(17,1526,3,'Steal Mana',370000,64),
(17,1201,28,'Dryad Root',370000,64),
(17,1272,8,'Word of Fear',370000,64),
(17,1395,5,'Erase',370000,64),
(17,1398,5,'Mana Burn',370000,64),
(17,1398,6,'Mana Burn',440000,66),
(17,1392,2,'Holy Resistance',440000,66),
(17,1389,2,'Greater Shield',440000,66),
(17,1393,2,'Unholy Resistance',440000,66),
(17,1395,6,'Erase',440000,66),
(17,1388,2,'Greater Might',440000,66),
(17,1272,9,'Word of Fear',440000,66),
(17,1182,3,'Resist Aqua',440000,66),
(17,1189,3,'Resist Wind',440000,66),
(17,1201,29,'Dryad Root',440000,66),
(17,213,7,'Boost Mana',440000,66),
(17,259,24,'Heavy Armor Mastery',220000,66),
(17,259,25,'Heavy Armor Mastery',220000,66),
(17,249,33,'Weapon Mastery',220000,66),
(17,249,34,'Weapon Mastery',220000,66),
(17,236,32,'Light Armor Mastery',220000,66),
(17,236,33,'Light Armor Mastery',220000,66),
(17,235,32,'Robe Mastery',220000,66),
(17,235,33,'Robe Mastery',220000,66),
(17,146,36,'Anti Magic',220000,66),
(17,146,37,'Anti Magic',220000,66),
(17,146,38,'Anti Magic',320000,68),
(17,146,39,'Anti Magic',320000,68),
(17,235,34,'Robe Mastery',320000,68),
(17,235,35,'Robe Mastery',320000,68),
(17,236,34,'Light Armor Mastery',320000,68),
(17,236,35,'Light Armor Mastery',320000,68),
(17,249,35,'Weapon Mastery',320000,68),
(17,249,36,'Weapon Mastery',320000,68),
(17,259,26,'Heavy Armor Mastery',320000,68),
(17,259,27,'Heavy Armor Mastery',320000,68),
(17,229,6,'Fast Mana Recovery',640000,68),
(17,1033,3,'Resist Poison',640000,68),
(17,1201,30,'Dryad Root',640000,68),
(17,1078,6,'Concentration',640000,68),
(17,1272,10,'Word of Fear',640000,68),
(17,1395,7,'Erase',640000,68),
(17,1398,7,'Mana Burn',640000,68),
(17,1398,8,'Mana Burn',850000,70),
(17,1395,8,'Erase',850000,70),
(17,1272,11,'Word of Fear',850000,70),
(17,1048,6,'Blessed Soul',850000,70),
(17,1201,31,'Dryad Root',850000,70),
(17,211,7,'Boost HP',850000,70),
(17,259,28,'Heavy Armor Mastery',430000,70),
(17,259,29,'Heavy Armor Mastery',430000,70),
(17,249,37,'Weapon Mastery',430000,70),
(17,249,38,'Weapon Mastery',430000,70),
(17,236,36,'Light Armor Mastery',430000,70),
(17,236,37,'Light Armor Mastery',430000,70),
(17,235,36,'Robe Mastery',430000,70),
(17,235,37,'Robe Mastery',430000,70),
(17,146,40,'Anti Magic',430000,70),
(17,146,41,'Anti Magic',430000,70),
(17,146,42,'Anti Magic',680000,72),
(17,146,43,'Anti Magic',680000,72),
(17,235,38,'Robe Mastery',680000,72),
(17,235,39,'Robe Mastery',680000,72),
(17,236,38,'Light Armor Mastery',680000,72),
(17,236,39,'Light Armor Mastery',680000,72),
(17,249,39,'Weapon Mastery',680000,72),
(17,249,40,'Weapon Mastery',680000,72),
(17,259,30,'Heavy Armor Mastery',680000,72),
(17,259,31,'Heavy Armor Mastery',680000,72),
(17,213,8,'Boost Mana',1360000,72),
(17,1045,6,'Blessed Body',1360000,72),
(17,1201,32,'Dryad Root',1360000,72),
(17,1272,12,'Word of Fear',1360000,72),
(17,1395,9,'Erase',1360000,72),
(17,1398,9,'Mana Burn',1360000,72),
(17,1398,10,'Mana Burn',1530000,74),
(17,1393,3,'Unholy Resistance',1530000,74),
(17,1389,3,'Greater Shield',1530000,74),
(17,1392,3,'Holy Resistance',1530000,74),
(17,1395,10,'Erase',1530000,74),
(17,1388,3,'Greater Might',1530000,74),
(17,1272,13,'Word of Fear',1530000,74),
(17,1201,33,'Dryad Root',1530000,74),
(17,229,7,'Fast Mana Recovery',1530000,74),
(17,212,6,'Fast HP Recovery',1530000,74),
(17,259,32,'Heavy Armor Mastery',770000,74),
(17,259,33,'Heavy Armor Mastery',770000,74),
(17,249,41,'Weapon Mastery',770000,74),
(17,249,42,'Weapon Mastery',770000,74),
(17,236,40,'Light Armor Mastery',770000,74),
(17,236,41,'Light Armor Mastery',770000,74),
(17,235,40,'Robe Mastery',770000,74),
(17,235,41,'Robe Mastery',770000,74),
(17,146,44,'Anti Magic',770000,74),
(17,146,45,'Anti Magic',770000,74),
(18,3,1,'Power Strike',50,5),
(18,3,2,'Power Strike',50,5),
(18,3,3,'Power Strike',50,5),
(18,16,1,'Mortal Blow',50,5),
(18,16,2,'Mortal Blow',50,5),
(18,16,3,'Mortal Blow',50,5),
(18,56,1,'Power Shot',50,5),
(18,56,2,'Power Shot',50,5),
(18,56,3,'Power Shot',50,5),
(18,91,1,'Defense Aura',160,5),
(18,141,1,'Weapon Mastery',160,5),
(18,142,1,'Armor Mastery',160,5),
(18,142,2,'Armor Mastery',460,10),
(18,142,3,'Armor Mastery',460,10),
(18,141,2,'Weapon Mastery',910,10),
(18,56,4,'Power Shot',310,10),
(18,56,5,'Power Shot',310,10),
(18,56,6,'Power Shot',310,10),
(18,16,4,'Mortal Blow',310,10),
(18,16,5,'Mortal Blow',310,10),
(18,16,6,'Mortal Blow',310,10),
(18,3,4,'Power Strike',310,10),
(18,3,5,'Power Strike',310,10),
(18,3,6,'Power Strike',310,10),
(18,77,1,'Attack Aura',910,10),
(18,3,7,'Power Strike',1100,15),
(18,3,8,'Power Strike',1100,15),
(18,3,9,'Power Strike',1100,15),
(18,16,7,'Mortal Blow',1100,15),
(18,16,8,'Mortal Blow',1100,15),
(18,16,9,'Mortal Blow',1100,15),
(18,56,7,'Power Shot',1100,15),
(18,56,8,'Power Shot',1100,15),
(18,56,9,'Power Shot',1100,15),
(18,58,1,'Elemental Heal',1100,15),
(18,58,2,'Elemental Heal',1100,15),
(18,58,3,'Elemental Heal',1100,15),
(18,141,3,'Weapon Mastery',3300,15),
(18,142,4,'Armor Mastery',1700,15),
(18,142,5,'Armor Mastery',1700,15),
(19,15,1,'Charm',1400,20),
(19,15,2,'Charm',1400,20),
(19,15,3,'Charm',1400,20),
(19,21,1,'Poison Recovery',4100,20),
(19,58,4,'Elemental Heal',1400,20),
(19,58,5,'Elemental Heal',1400,20),
(19,58,6,'Elemental Heal',1400,20),
(19,147,1,'Magic Resistance',2100,20),
(19,147,2,'Magic Resistance',2100,20),
(19,91,2,'Defense Aura',4100,20),
(19,110,1,'Ultimate Defense',4100,20),
(19,153,1,'Shield Mastery',4100,20),
(19,217,1,'Sword/Blunt Weapon Mastery',4100,20),
(19,232,1,'Heavy Armor Mastery',1400,20),
(19,232,2,'Heavy Armor Mastery',1400,20),
(19,232,3,'Heavy Armor Mastery',1400,20),
(19,232,4,'Heavy Armor Mastery',2900,24),
(19,232,5,'Heavy Armor Mastery',2900,24),
(19,232,6,'Heavy Armor Mastery',2900,24),
(19,217,2,'Sword/Blunt Weapon Mastery',8800,24),
(19,112,1,'Deflect Arrow',8800,24),
(19,61,1,'Cure Bleeding',8800,24),
(19,147,3,'Magic Resistance',2900,24),
(19,147,4,'Magic Resistance',2900,24),
(19,147,5,'Magic Resistance',2900,24),
(19,58,7,'Elemental Heal',2900,24),
(19,58,8,'Elemental Heal',2900,24),
(19,58,9,'Elemental Heal',2900,24),
(19,28,1,'Aggression',2900,24),
(19,28,2,'Aggression',2900,24),
(19,28,3,'Aggression',2900,24),
(19,15,4,'Charm',2900,24),
(19,15,5,'Charm',2900,24),
(19,15,6,'Charm',2900,24),
(19,15,7,'Charm',5000,28),
(19,15,8,'Charm',5000,28),
(19,15,9,'Charm',5000,28),
(19,28,4,'Aggression',5000,28),
(19,28,5,'Aggression',5000,28),
(19,28,6,'Aggression',5000,28),
(19,58,10,'Elemental Heal',5000,28),
(19,58,11,'Elemental Heal',5000,28),
(19,58,12,'Elemental Heal',5000,28),
(19,147,6,'Magic Resistance',5000,28),
(19,147,7,'Magic Resistance',5000,28),
(19,147,8,'Magic Resistance',5000,28),
(19,77,2,'Attack Aura',15000,28),
(19,153,2,'Shield Mastery',15000,28),
(19,217,3,'Sword/Blunt Weapon Mastery',7500,28),
(19,217,4,'Sword/Blunt Weapon Mastery',7500,28),
(19,232,7,'Heavy Armor Mastery',5000,28),
(19,232,8,'Heavy Armor Mastery',5000,28),
(19,232,9,'Heavy Armor Mastery',5000,28),
(19,232,10,'Heavy Armor Mastery',8300,32),
(19,232,11,'Heavy Armor Mastery',8300,32),
(19,232,12,'Heavy Armor Mastery',8300,32),
(19,230,1,'Sprint',25000,32),
(19,217,5,'Sword/Blunt Weapon Mastery',13000,32),
(19,217,6,'Sword/Blunt Weapon Mastery',13000,32),
(19,112,2,'Deflect Arrow',25000,32),
(19,147,9,'Magic Resistance',8300,32),
(19,147,10,'Magic Resistance',8300,32),
(19,147,11,'Magic Resistance',8300,32),
(19,58,13,'Elemental Heal',8300,32),
(19,58,14,'Elemental Heal',8300,32),
(19,58,15,'Elemental Heal',8300,32),
(19,28,7,'Aggression',8300,32),
(19,28,8,'Aggression',8300,32),
(19,28,9,'Aggression',8300,32),
(19,15,10,'Charm',8300,32),
(19,15,11,'Charm',8300,32),
(19,15,12,'Charm',8300,32),
(19,15,13,'Charm',13000,36),
(19,15,14,'Charm',13000,36),
(19,15,15,'Charm',13000,36),
(19,28,10,'Aggression',13000,36),
(19,28,11,'Aggression',13000,36),
(19,28,12,'Aggression',13000,36),
(19,58,16,'Elemental Heal',13000,36),
(19,58,17,'Elemental Heal',13000,36),
(19,58,18,'Elemental Heal',13000,36),
(19,147,12,'Magic Resistance',13000,36),
(19,147,13,'Magic Resistance',13000,36),
(19,147,14,'Magic Resistance',13000,36),
(19,191,1,'Focus Mind',39000,36),
(19,102,1,'Entangle',39000,36),
(19,217,7,'Sword/Blunt Weapon Mastery',19000,36),
(19,217,8,'Sword/Blunt Weapon Mastery',19000,36),
(19,232,13,'Heavy Armor Mastery',13000,36),
(19,232,14,'Heavy Armor Mastery',13000,36),
(19,232,15,'Heavy Armor Mastery',13000,36),
(20,15,16,'Charm',10000,40),
(20,15,17,'Charm',10000,40),
(20,15,18,'Charm',10000,40),
(20,18,1,'Aura of Hate',10000,40),
(20,18,2,'Aura of Hate',10000,40),
(20,18,3,'Aura of Hate',10000,40),
(20,28,13,'Aggression',10000,40),
(20,28,14,'Aggression',10000,40),
(20,28,15,'Aggression',10000,40),
(20,58,19,'Elemental Heal',10000,40),
(20,58,20,'Elemental Heal',10000,40),
(20,58,21,'Elemental Heal',10000,40),
(20,10,1,'Summon Storm Cubic',30000,40),
(20,21,2,'Poison Recovery',30000,40),
(20,102,2,'Entangle',30000,40),
(20,147,15,'Magic Resistance',10000,40),
(20,147,16,'Magic Resistance',10000,40),
(20,147,17,'Magic Resistance',10000,40),
(20,217,9,'Sword/Blunt Weapon Mastery',10000,40),
(20,217,10,'Sword/Blunt Weapon Mastery',10000,40),
(20,217,11,'Sword/Blunt Weapon Mastery',10000,40),
(20,232,16,'Heavy Armor Mastery',10000,40),
(20,232,17,'Heavy Armor Mastery',10000,40),
(20,232,18,'Heavy Armor Mastery',10000,40),
(20,123,1,'Spirit Barrier',30000,40),
(20,153,3,'Shield Mastery',30000,40),
(20,197,1,'Holy Armor',30000,40),
(20,191,2,'Focus Mind',33000,43),
(20,143,1,'Cubic Mastery',33000,43),
(20,112,3,'Deflect Arrow',33000,43),
(20,288,1,'Guard Stance',33000,43),
(20,232,19,'Heavy Armor Mastery',11000,43),
(20,232,20,'Heavy Armor Mastery',11000,43),
(20,232,21,'Heavy Armor Mastery',11000,43),
(20,217,12,'Sword/Blunt Weapon Mastery',11000,43),
(20,217,13,'Sword/Blunt Weapon Mastery',11000,43),
(20,217,14,'Sword/Blunt Weapon Mastery',11000,43),
(20,147,18,'Magic Resistance',11000,43),
(20,147,19,'Magic Resistance',11000,43),
(20,147,20,'Magic Resistance',11000,43),
(20,102,3,'Entangle',33000,43),
(20,67,1,'Summon Life Cubic',33000,43),
(20,58,22,'Elemental Heal',11000,43),
(20,58,23,'Elemental Heal',11000,43),
(20,58,24,'Elemental Heal',11000,43),
(20,28,16,'Aggression',11000,43),
(20,28,17,'Aggression',11000,43),
(20,28,18,'Aggression',11000,43),
(20,812,1,'Vanguard',99000,43),
(20,18,4,'Aura of Hate',11000,43),
(20,18,5,'Aura of Hate',11000,43),
(20,18,6,'Aura of Hate',11000,43),
(20,15,19,'Charm',11000,43),
(20,15,20,'Charm',11000,43),
(20,15,21,'Charm',11000,43),
(20,15,22,'Charm',17000,46),
(20,15,23,'Charm',17000,46),
(20,15,24,'Charm',17000,46),
(20,18,7,'Aura of Hate',17000,46),
(20,18,8,'Aura of Hate',17000,46),
(20,18,9,'Aura of Hate',17000,46),
(20,28,19,'Aggression',17000,46),
(20,28,20,'Aggression',17000,46),
(20,28,21,'Aggression',17000,46),
(20,58,25,'Elemental Heal',17000,46),
(20,58,26,'Elemental Heal',17000,46),
(20,58,27,'Elemental Heal',17000,46),
(20,61,2,'Cure Bleeding',50000,46),
(20,10,2,'Summon Storm Cubic',50000,46),
(20,102,4,'Entangle',50000,46),
(20,147,21,'Magic Resistance',17000,46),
(20,147,22,'Magic Resistance',17000,46),
(20,147,23,'Magic Resistance',17000,46),
(20,217,15,'Sword/Blunt Weapon Mastery',17000,46),
(20,217,16,'Sword/Blunt Weapon Mastery',17000,46),
(20,217,17,'Sword/Blunt Weapon Mastery',17000,46),
(20,232,22,'Heavy Armor Mastery',17000,46),
(20,232,23,'Heavy Armor Mastery',17000,46),
(20,232,24,'Heavy Armor Mastery',17000,46),
(20,197,2,'Holy Armor',50000,46),
(20,110,2,'Ultimate Defense',50000,46),
(20,191,3,'Focus Mind',82000,49),
(20,112,4,'Deflect Arrow',82000,49),
(20,123,2,'Spirit Barrier',82000,49),
(20,232,25,'Heavy Armor Mastery',27000,49),
(20,232,26,'Heavy Armor Mastery',27000,49),
(20,232,27,'Heavy Armor Mastery',27000,49),
(20,217,18,'Sword/Blunt Weapon Mastery',27000,49),
(20,217,19,'Sword/Blunt Weapon Mastery',27000,49),
(20,217,20,'Sword/Blunt Weapon Mastery',27000,49),
(20,147,24,'Magic Resistance',27000,49),
(20,147,25,'Magic Resistance',27000,49),
(20,147,26,'Magic Resistance',27000,49),
(20,102,5,'Entangle',82000,49),
(20,67,2,'Summon Life Cubic',82000,49),
(20,58,28,'Elemental Heal',27000,49),
(20,58,29,'Elemental Heal',27000,49),
(20,58,30,'Elemental Heal',27000,49),
(20,28,22,'Aggression',27000,49),
(20,28,23,'Aggression',27000,49),
(20,28,24,'Aggression',27000,49),
(20,18,10,'Aura of Hate',27000,49),
(20,18,11,'Aura of Hate',27000,49),
(20,18,12,'Aura of Hate',27000,49),
(20,15,25,'Charm',27000,49),
(20,15,26,'Charm',27000,49),
(20,15,27,'Charm',27000,49),
(20,15,28,'Charm',38000,52),
(20,15,29,'Charm',38000,52),
(20,15,30,'Charm',38000,52),
(20,18,13,'Aura of Hate',38000,52),
(20,18,14,'Aura of Hate',38000,52),
(20,18,15,'Aura of Hate',38000,52),
(20,28,25,'Aggression',38000,52),
(20,28,26,'Aggression',38000,52),
(20,28,27,'Aggression',38000,52),
(20,58,31,'Elemental Heal',38000,52),
(20,58,32,'Elemental Heal',38000,52),
(20,58,33,'Elemental Heal',38000,52),
(20,10,3,'Summon Storm Cubic',115000,52),
(20,102,6,'Entangle',115000,52),
(20,147,27,'Magic Resistance',38000,52),
(20,147,28,'Magic Resistance',38000,52),
(20,147,29,'Magic Resistance',38000,52),
(20,217,21,'Sword/Blunt Weapon Mastery',38000,52),
(20,217,22,'Sword/Blunt Weapon Mastery',38000,52),
(20,217,23,'Sword/Blunt Weapon Mastery',38000,52),
(20,232,28,'Heavy Armor Mastery',38000,52),
(20,232,29,'Heavy Armor Mastery',38000,52),
(20,232,30,'Heavy Armor Mastery',38000,52),
(20,153,4,'Shield Mastery',115000,52),
(20,230,2,'Sprint',115000,52),
(20,288,2,'Guard Stance',115000,52),
(20,291,1,'Final Fortress',115000,52),
(20,291,2,'Final Fortress',157000,55),
(20,191,4,'Focus Mind',157000,55),
(20,143,2,'Cubic Mastery',157000,55),
(20,400,1,'Tribunal',157000,55),
(20,402,1,'Arrest',157000,55),
(20,232,31,'Heavy Armor Mastery',52000,55),
(20,232,32,'Heavy Armor Mastery',52000,55),
(20,232,33,'Heavy Armor Mastery',52000,55),
(20,217,24,'Sword/Blunt Weapon Mastery',52000,55),
(20,217,25,'Sword/Blunt Weapon Mastery',52000,55),
(20,217,26,'Sword/Blunt Weapon Mastery',52000,55),
(20,147,30,'Magic Resistance',52000,55),
(20,147,31,'Magic Resistance',52000,55),
(20,147,32,'Magic Resistance',52000,55),
(20,102,7,'Entangle',157000,55),
(20,67,3,'Summon Life Cubic',157000,55),
(20,58,34,'Elemental Heal',52000,55),
(20,58,35,'Elemental Heal',52000,55),
(20,58,36,'Elemental Heal',52000,55),
(20,28,28,'Aggression',52000,55),
(20,28,29,'Aggression',52000,55),
(20,28,30,'Aggression',52000,55),
(20,18,16,'Aura of Hate',52000,55),
(20,18,17,'Aura of Hate',52000,55),
(20,18,18,'Aura of Hate',52000,55),
(20,15,31,'Charm',52000,55),
(20,15,32,'Charm',52000,55),
(20,15,33,'Charm',52000,55),
(20,15,34,'Charm',57000,58),
(20,15,35,'Charm',57000,58),
(20,15,36,'Charm',57000,58),
(20,18,19,'Aura of Hate',57000,58),
(20,18,20,'Aura of Hate',57000,58),
(20,18,21,'Aura of Hate',57000,58),
(20,28,31,'Aggression',57000,58),
(20,28,32,'Aggression',57000,58),
(20,28,33,'Aggression',57000,58),
(20,58,37,'Elemental Heal',57000,58),
(20,58,38,'Elemental Heal',57000,58),
(20,58,39,'Elemental Heal',57000,58),
(20,10,4,'Summon Storm Cubic',171000,58),
(20,102,8,'Entangle',171000,58),
(20,107,1,'Holy Aura',171000,58),
(20,147,33,'Magic Resistance',57000,58),
(20,147,34,'Magic Resistance',57000,58),
(20,147,35,'Magic Resistance',57000,58),
(20,217,27,'Sword/Blunt Weapon Mastery',57000,58),
(20,217,28,'Sword/Blunt Weapon Mastery',57000,58),
(20,217,29,'Sword/Blunt Weapon Mastery',57000,58),
(20,232,34,'Heavy Armor Mastery',57000,58),
(20,232,35,'Heavy Armor Mastery',57000,58),
(20,232,36,'Heavy Armor Mastery',57000,58),
(20,402,2,'Arrest',171000,58),
(20,400,2,'Tribunal',171000,58),
(20,123,3,'Spirit Barrier',171000,58),
(20,291,3,'Final Fortress',171000,58),
(20,916,1,'Shield Deflect Magic',181000,60),
(20,291,4,'Final Fortress',193000,60),
(20,316,1,'Aegis',193000,60),
(20,400,3,'Tribunal',193000,60),
(20,402,3,'Arrest',193000,60),
(20,232,37,'Heavy Armor Mastery',97000,60),
(20,232,38,'Heavy Armor Mastery',97000,60),
(20,217,30,'Sword/Blunt Weapon Mastery',97000,60),
(20,217,31,'Sword/Blunt Weapon Mastery',97000,60),
(20,147,36,'Magic Resistance',97000,60),
(20,147,37,'Magic Resistance',97000,60),
(20,107,2,'Holy Aura',193000,60),
(20,102,9,'Entangle',193000,60),
(20,67,4,'Summon Life Cubic',193000,60),
(20,21,3,'Poison Recovery',193000,60),
(20,58,40,'Elemental Heal',97000,60),
(20,58,41,'Elemental Heal',97000,60),
(20,28,34,'Aggression',97000,60),
(20,28,35,'Aggression',97000,60),
(20,18,22,'Aura of Hate',97000,60),
(20,18,23,'Aura of Hate',97000,60),
(20,15,37,'Charm',97000,60),
(20,15,38,'Charm',97000,60),
(20,15,39,'Charm',130000,62),
(20,15,40,'Charm',130000,62),
(20,18,24,'Aura of Hate',130000,62),
(20,18,25,'Aura of Hate',130000,62),
(20,28,36,'Aggression',130000,62),
(20,28,37,'Aggression',130000,62),
(20,58,42,'Elemental Heal',130000,62),
(20,58,43,'Elemental Heal',130000,62),
(20,61,3,'Cure Bleeding',250000,62),
(20,10,5,'Summon Storm Cubic',250000,62),
(20,102,10,'Entangle',250000,62),
(20,107,3,'Holy Aura',250000,62),
(20,147,38,'Magic Resistance',130000,62),
(20,147,39,'Magic Resistance',130000,62),
(20,217,32,'Sword/Blunt Weapon Mastery',130000,62),
(20,217,33,'Sword/Blunt Weapon Mastery',130000,62),
(20,232,39,'Heavy Armor Mastery',130000,62),
(20,232,40,'Heavy Armor Mastery',130000,62),
(20,402,4,'Arrest',250000,62),
(20,400,4,'Tribunal',250000,62),
(20,449,1,'Summon Attractive Cubic',250000,62),
(20,288,3,'Guard Stance',250000,62),
(20,291,5,'Final Fortress',250000,62),
(20,916,2,'Shield Deflect Magic',300000,64),
(20,291,6,'Final Fortress',320000,64),
(20,322,1,'Shield Fortress',320000,64),
(20,191,5,'Focus Mind',320000,64),
(20,400,5,'Tribunal',320000,64),
(20,402,5,'Arrest',320000,64),
(20,232,41,'Heavy Armor Mastery',160000,64),
(20,232,42,'Heavy Armor Mastery',160000,64),
(20,217,34,'Sword/Blunt Weapon Mastery',160000,64),
(20,217,35,'Sword/Blunt Weapon Mastery',160000,64),
(20,147,40,'Magic Resistance',160000,64),
(20,147,41,'Magic Resistance',160000,64),
(20,107,4,'Holy Aura',320000,64),
(20,102,11,'Entangle',320000,64),
(20,67,5,'Summon Life Cubic',320000,64),
(20,58,44,'Elemental Heal',160000,64),
(20,58,45,'Elemental Heal',160000,64),
(20,28,38,'Aggression',160000,64),
(20,28,39,'Aggression',160000,64),
(20,18,26,'Aura of Hate',160000,64),
(20,18,27,'Aura of Hate',160000,64),
(20,15,41,'Charm',160000,64),
(20,15,42,'Charm',160000,64),
(20,15,43,'Charm',230000,66),
(20,15,44,'Charm',230000,66),
(20,18,28,'Aura of Hate',230000,66),
(20,18,29,'Aura of Hate',230000,66),
(20,28,40,'Aggression',230000,66),
(20,28,41,'Aggression',230000,66),
(20,58,46,'Elemental Heal',230000,66),
(20,58,47,'Elemental Heal',230000,66),
(20,10,6,'Summon Storm Cubic',470000,66),
(20,102,12,'Entangle',470000,66),
(20,107,5,'Holy Aura',470000,66),
(20,147,42,'Magic Resistance',230000,66),
(20,147,43,'Magic Resistance',230000,66),
(20,217,36,'Sword/Blunt Weapon Mastery',230000,66),
(20,217,37,'Sword/Blunt Weapon Mastery',230000,66),
(20,232,43,'Heavy Armor Mastery',230000,66),
(20,232,44,'Heavy Armor Mastery',230000,66),
(20,402,6,'Arrest',470000,66),
(20,400,6,'Tribunal',470000,66),
(20,449,2,'Summon Attractive Cubic',470000,66),
(20,322,2,'Shield Fortress',470000,66),
(20,291,7,'Final Fortress',470000,66),
(20,916,3,'Shield Deflect Magic',520000,68),
(20,291,8,'Final Fortress',560000,68),
(20,322,3,'Shield Fortress',560000,68),
(20,400,7,'Tribunal',560000,68),
(20,402,7,'Arrest',560000,68),
(20,232,45,'Heavy Armor Mastery',280000,68),
(20,232,46,'Heavy Armor Mastery',280000,68),
(20,217,38,'Sword/Blunt Weapon Mastery',280000,68),
(20,217,39,'Sword/Blunt Weapon Mastery',280000,68),
(20,147,44,'Magic Resistance',280000,68),
(20,147,45,'Magic Resistance',280000,68),
(20,107,6,'Holy Aura',560000,68),
(20,102,13,'Entangle',560000,68),
(20,67,6,'Summon Life Cubic',560000,68),
(20,58,48,'Elemental Heal',280000,68),
(20,58,49,'Elemental Heal',280000,68),
(20,28,42,'Aggression',280000,68),
(20,28,43,'Aggression',280000,68),
(20,18,30,'Aura of Hate',280000,68),
(20,18,31,'Aura of Hate',280000,68),
(20,15,45,'Charm',280000,68),
(20,15,46,'Charm',280000,68),
(20,15,47,'Charm',290000,70),
(20,15,48,'Charm',290000,70),
(20,18,32,'Aura of Hate',290000,70),
(20,18,33,'Aura of Hate',290000,70),
(20,28,44,'Aggression',290000,70),
(20,28,45,'Aggression',290000,70),
(20,58,50,'Elemental Heal',290000,70),
(20,58,51,'Elemental Heal',290000,70),
(20,10,7,'Summon Storm Cubic',580000,70),
(20,102,14,'Entangle',580000,70),
(20,107,7,'Holy Aura',580000,70),
(20,147,46,'Magic Resistance',290000,70),
(20,147,47,'Magic Resistance',290000,70),
(20,217,40,'Sword/Blunt Weapon Mastery',290000,70),
(20,217,41,'Sword/Blunt Weapon Mastery',290000,70),
(20,232,47,'Heavy Armor Mastery',290000,70),
(20,232,48,'Heavy Armor Mastery',290000,70),
(20,402,8,'Arrest',580000,70),
(20,400,8,'Tribunal',580000,70),
(20,449,3,'Summon Attractive Cubic',580000,70),
(20,322,4,'Shield Fortress',580000,70),
(20,288,4,'Guard Stance',580000,70),
(20,291,9,'Final Fortress',580000,70),
(20,916,4,'Shield Deflect Magic',750000,72),
(20,291,10,'Final Fortress',800000,72),
(20,322,5,'Shield Fortress',800000,72),
(20,191,6,'Focus Mind',800000,72),
(20,400,9,'Tribunal',800000,72),
(20,402,9,'Arrest',800000,72),
(20,232,49,'Heavy Armor Mastery',400000,72),
(20,232,50,'Heavy Armor Mastery',400000,72),
(20,217,42,'Sword/Blunt Weapon Mastery',400000,72),
(20,217,43,'Sword/Blunt Weapon Mastery',400000,72),
(20,147,48,'Magic Resistance',400000,72),
(20,147,49,'Magic Resistance',400000,72),
(20,107,8,'Holy Aura',800000,72),
(20,102,15,'Entangle',800000,72),
(20,67,7,'Summon Life Cubic',800000,72),
(20,58,52,'Elemental Heal',400000,72),
(20,58,53,'Elemental Heal',400000,72),
(20,28,46,'Aggression',400000,72),
(20,28,47,'Aggression',400000,72),
(20,18,34,'Aura of Hate',400000,72),
(20,18,35,'Aura of Hate',400000,72),
(20,15,49,'Charm',400000,72),
(20,15,50,'Charm',400000,72),
(20,15,51,'Charm',870000,74),
(20,15,52,'Charm',870000,74),
(20,18,36,'Aura of Hate',870000,74),
(20,18,37,'Aura of Hate',870000,74),
(20,28,48,'Aggression',870000,74),
(20,28,49,'Aggression',870000,74),
(20,58,54,'Elemental Heal',870000,74),
(20,58,55,'Elemental Heal',870000,74),
(20,10,8,'Summon Storm Cubic',1730000,74),
(20,102,16,'Entangle',1730000,74),
(20,107,9,'Holy Aura',1730000,74),
(20,147,50,'Magic Resistance',870000,74),
(20,147,51,'Magic Resistance',870000,74),
(20,217,44,'Sword/Blunt Weapon Mastery',870000,74),
(20,217,45,'Sword/Blunt Weapon Mastery',870000,74),
(20,232,51,'Heavy Armor Mastery',870000,74),
(20,232,52,'Heavy Armor Mastery',870000,74),
(20,402,10,'Arrest',1730000,74),
(20,400,10,'Tribunal',1730000,74),
(20,449,4,'Summon Attractive Cubic',1730000,74),
(20,322,6,'Shield Fortress',1730000,74),
(20,291,11,'Final Fortress',1730000,74),
(21,15,16,'Charm',16000,40),
(21,15,17,'Charm',16000,40),
(21,15,18,'Charm',16000,40),
(21,58,19,'Elemental Heal',16000,40),
(21,58,20,'Elemental Heal',16000,40),
(21,58,21,'Elemental Heal',16000,40),
(21,147,15,'Magic Resistance',16000,40),
(21,147,16,'Magic Resistance',16000,40),
(21,147,17,'Magic Resistance',16000,40),
(21,217,9,'Sword/Blunt Weapon Mastery',16000,40),
(21,217,10,'Sword/Blunt Weapon Mastery',16000,40),
(21,217,11,'Sword/Blunt Weapon Mastery',16000,40),
(21,21,2,'Poison Recovery',49000,40),
(21,102,2,'Entangle',49000,40),
(21,123,1,'Spirit Barrier',49000,40),
(21,267,1,'Song of Warding',49000,40),
(21,270,1,'Song of Invocation',58000,43),
(21,191,2,'Focus Mind',58000,43),
(21,102,3,'Entangle',58000,43),
(21,196,1,'Holy Blade',58000,43),
(21,217,12,'Sword/Blunt Weapon Mastery',19000,43),
(21,217,13,'Sword/Blunt Weapon Mastery',19000,43),
(21,217,14,'Sword/Blunt Weapon Mastery',19000,43),
(21,147,18,'Magic Resistance',19000,43),
(21,147,19,'Magic Resistance',19000,43),
(21,147,20,'Magic Resistance',19000,43),
(21,58,22,'Elemental Heal',19000,43),
(21,58,23,'Elemental Heal',19000,43),
(21,58,24,'Elemental Heal',19000,43),
(21,15,19,'Charm',19000,43),
(21,15,20,'Charm',19000,43),
(21,15,21,'Charm',19000,43),
(21,15,22,'Charm',29000,46),
(21,15,23,'Charm',29000,46),
(21,15,24,'Charm',29000,46),
(21,58,25,'Elemental Heal',29000,46),
(21,58,26,'Elemental Heal',29000,46),
(21,58,27,'Elemental Heal',29000,46),
(21,147,21,'Magic Resistance',29000,46),
(21,147,22,'Magic Resistance',29000,46),
(21,147,23,'Magic Resistance',29000,46),
(21,217,15,'Sword/Blunt Weapon Mastery',29000,46),
(21,217,16,'Sword/Blunt Weapon Mastery',29000,46),
(21,217,17,'Sword/Blunt Weapon Mastery',29000,46),
(21,102,4,'Entangle',86000,46),
(21,61,2,'Cure Bleeding',86000,46),
(21,268,1,'Song of Wind',86000,46),
(21,269,1,'Song of Hunter',123000,49),
(21,191,3,'Focus Mind',123000,49),
(21,123,2,'Spirit Barrier',123000,49),
(21,102,5,'Entangle',123000,49),
(21,217,18,'Sword/Blunt Weapon Mastery',41000,49),
(21,217,19,'Sword/Blunt Weapon Mastery',41000,49),
(21,217,20,'Sword/Blunt Weapon Mastery',41000,49),
(21,147,24,'Magic Resistance',41000,49),
(21,147,25,'Magic Resistance',41000,49),
(21,147,26,'Magic Resistance',41000,49),
(21,58,28,'Elemental Heal',41000,49),
(21,58,29,'Elemental Heal',41000,49),
(21,58,30,'Elemental Heal',41000,49),
(21,15,25,'Charm',41000,49),
(21,15,26,'Charm',41000,49),
(21,15,27,'Charm',41000,49),
(21,15,28,'Charm',71000,52),
(21,15,29,'Charm',71000,52),
(21,15,30,'Charm',71000,52),
(21,58,31,'Elemental Heal',71000,52),
(21,58,32,'Elemental Heal',71000,52),
(21,58,33,'Elemental Heal',71000,52),
(21,147,27,'Magic Resistance',71000,52),
(21,147,28,'Magic Resistance',71000,52),
(21,147,29,'Magic Resistance',71000,52),
(21,217,21,'Sword/Blunt Weapon Mastery',71000,52),
(21,217,22,'Sword/Blunt Weapon Mastery',71000,52),
(21,217,23,'Sword/Blunt Weapon Mastery',71000,52),
(21,102,6,'Entangle',214000,52),
(21,230,2,'Sprint',214000,52),
(21,265,1,'Song of Life',214000,52),
(21,264,1,'Song of Earth',220000,55),
(21,191,4,'Focus Mind',220000,55),
(21,102,7,'Entangle',220000,55),
(21,98,1,'Sword Symphony',220000,55),
(21,402,1,'Arrest',220000,55),
(21,407,1,'Psycho Symphony',220000,55),
(21,217,24,'Sword/Blunt Weapon Mastery',73000,55),
(21,217,25,'Sword/Blunt Weapon Mastery',73000,55),
(21,217,26,'Sword/Blunt Weapon Mastery',73000,55),
(21,147,30,'Magic Resistance',73000,55),
(21,147,31,'Magic Resistance',73000,55),
(21,147,32,'Magic Resistance',73000,55),
(21,58,34,'Elemental Heal',73000,55),
(21,58,35,'Elemental Heal',73000,55),
(21,58,36,'Elemental Heal',73000,55),
(21,15,31,'Charm',73000,55),
(21,15,32,'Charm',73000,55),
(21,15,33,'Charm',73000,55),
(21,15,34,'Charm',89000,58),
(21,15,35,'Charm',89000,58),
(21,15,36,'Charm',89000,58),
(21,58,37,'Elemental Heal',89000,58),
(21,58,38,'Elemental Heal',89000,58),
(21,58,39,'Elemental Heal',89000,58),
(21,147,33,'Magic Resistance',89000,58),
(21,147,34,'Magic Resistance',89000,58),
(21,147,35,'Magic Resistance',89000,58),
(21,217,27,'Sword/Blunt Weapon Mastery',89000,58),
(21,217,28,'Sword/Blunt Weapon Mastery',89000,58),
(21,217,29,'Sword/Blunt Weapon Mastery',89000,58),
(21,407,2,'Psycho Symphony',267000,58),
(21,402,2,'Arrest',267000,58),
(21,102,8,'Entangle',267000,58),
(21,123,3,'Spirit Barrier',267000,58),
(21,266,1,'Song of Water',267000,58),
(21,102,9,'Entangle',322000,60),
(21,98,2,'Sword Symphony',322000,60),
(21,21,3,'Poison Recovery',322000,60),
(21,402,3,'Arrest',322000,60),
(21,407,3,'Psycho Symphony',322000,60),
(21,217,30,'Sword/Blunt Weapon Mastery',161000,60),
(21,217,31,'Sword/Blunt Weapon Mastery',161000,60),
(21,147,36,'Magic Resistance',161000,60),
(21,147,37,'Magic Resistance',161000,60),
(21,58,40,'Elemental Heal',161000,60),
(21,58,41,'Elemental Heal',161000,60),
(21,15,37,'Charm',161000,60),
(21,15,38,'Charm',161000,60),
(21,15,39,'Charm',220000,62),
(21,15,40,'Charm',220000,62),
(21,58,42,'Elemental Heal',220000,62),
(21,58,43,'Elemental Heal',220000,62),
(21,147,38,'Magic Resistance',220000,62),
(21,147,39,'Magic Resistance',220000,62),
(21,217,32,'Sword/Blunt Weapon Mastery',220000,62),
(21,217,33,'Sword/Blunt Weapon Mastery',220000,62),
(21,407,4,'Psycho Symphony',440000,62),
(21,402,4,'Arrest',440000,62),
(21,61,3,'Cure Bleeding',440000,62),
(21,102,10,'Entangle',440000,62),
(21,306,1,'Song of Flame Guard',440000,62),
(21,191,5,'Focus Mind',530000,64),
(21,102,11,'Entangle',530000,64),
(21,98,3,'Sword Symphony',530000,64),
(21,402,5,'Arrest',530000,64),
(21,407,5,'Psycho Symphony',530000,64),
(21,217,34,'Sword/Blunt Weapon Mastery',270000,64),
(21,217,35,'Sword/Blunt Weapon Mastery',270000,64),
(21,147,40,'Magic Resistance',270000,64),
(21,147,41,'Magic Resistance',270000,64),
(21,58,44,'Elemental Heal',270000,64),
(21,58,45,'Elemental Heal',270000,64),
(21,15,41,'Charm',270000,64),
(21,15,42,'Charm',270000,64),
(21,15,43,'Charm',440000,66),
(21,15,44,'Charm',440000,66),
(21,58,46,'Elemental Heal',440000,66),
(21,58,47,'Elemental Heal',440000,66),
(21,147,42,'Magic Resistance',440000,66),
(21,147,43,'Magic Resistance',440000,66),
(21,217,36,'Sword/Blunt Weapon Mastery',440000,66),
(21,217,37,'Sword/Blunt Weapon Mastery',440000,66),
(21,407,6,'Psycho Symphony',880000,66),
(21,402,6,'Arrest',880000,66),
(21,102,12,'Entangle',880000,66),
(21,304,1,'Song of Vitality',880000,66),
(21,102,13,'Entangle',980000,68),
(21,98,4,'Sword Symphony',980000,68),
(21,402,7,'Arrest',980000,68),
(21,407,7,'Psycho Symphony',980000,68),
(21,217,38,'Sword/Blunt Weapon Mastery',490000,68),
(21,217,39,'Sword/Blunt Weapon Mastery',490000,68),
(21,147,44,'Magic Resistance',490000,68),
(21,147,45,'Magic Resistance',490000,68),
(21,58,48,'Elemental Heal',490000,68),
(21,58,49,'Elemental Heal',490000,68),
(21,15,45,'Charm',490000,68),
(21,15,46,'Charm',490000,68),
(21,15,47,'Charm',580000,70),
(21,15,48,'Charm',580000,70),
(21,58,50,'Elemental Heal',580000,70),
(21,58,51,'Elemental Heal',580000,70),
(21,147,46,'Magic Resistance',580000,70),
(21,147,47,'Magic Resistance',580000,70),
(21,217,40,'Sword/Blunt Weapon Mastery',580000,70),
(21,217,41,'Sword/Blunt Weapon Mastery',580000,70),
(21,407,8,'Psycho Symphony',1160000,70),
(21,402,8,'Arrest',1160000,70),
(21,102,14,'Entangle',1160000,70),
(21,308,1,'Song of Storm Guard',1160000,70),
(21,191,6,'Focus Mind',1330000,72),
(21,102,15,'Entangle',1330000,72),
(21,98,5,'Sword Symphony',1330000,72),
(21,402,9,'Arrest',1330000,72),
(21,407,9,'Psycho Symphony',1330000,72),
(21,217,42,'Sword/Blunt Weapon Mastery',670000,72),
(21,217,43,'Sword/Blunt Weapon Mastery',670000,72),
(21,147,48,'Magic Resistance',670000,72),
(21,147,49,'Magic Resistance',670000,72),
(21,58,52,'Elemental Heal',670000,72),
(21,58,53,'Elemental Heal',670000,72),
(21,15,49,'Charm',670000,72),
(21,15,50,'Charm',670000,72),
(21,15,51,'Charm',1630000,74),
(21,15,52,'Charm',1630000,74),
(21,58,54,'Elemental Heal',1630000,74),
(21,58,55,'Elemental Heal',1630000,74),
(21,147,50,'Magic Resistance',1630000,74),
(21,147,51,'Magic Resistance',1630000,74),
(21,217,44,'Sword/Blunt Weapon Mastery',1630000,74),
(21,217,45,'Sword/Blunt Weapon Mastery',1630000,74),
(21,407,10,'Psycho Symphony',3250000,74),
(21,402,10,'Arrest',3250000,74),
(21,102,16,'Entangle',3250000,74),
(21,305,1,'Song of Vengeance',3250000,74),
(22,15,1,'Charm',950,20),
(22,15,2,'Charm',950,20),
(22,15,3,'Charm',950,20),
(22,16,10,'Mortal Blow',1200,20),
(22,16,11,'Mortal Blow',1200,20),
(22,16,12,'Mortal Blow',1200,20),
(22,56,10,'Power Shot',1200,20),
(22,56,11,'Power Shot',1200,20),
(22,56,12,'Power Shot',1200,20),
(22,58,4,'Elemental Heal',1200,20),
(22,58,5,'Elemental Heal',1200,20),
(22,58,6,'Elemental Heal',1200,20),
(22,91,2,'Defense Aura',2800,20),
(22,27,1,'Unlock',2800,20),
(22,208,1,'Bow Mastery',950,20),
(22,208,2,'Bow Mastery',950,20),
(22,208,3,'Bow Mastery',950,20),
(22,209,1,'Dagger Mastery',2800,20),
(22,113,1,'Long Shot',2800,20),
(22,173,1,'Acrobatics',2800,20),
(22,195,1,'Breath Boost',2800,20),
(22,233,1,'Light Armor Mastery',1400,20),
(22,233,2,'Light Armor Mastery',1400,20),
(22,312,1,'Vicious Stance',2800,20),
(22,312,2,'Vicious Stance',5000,24),
(22,256,1,'Accuracy',5000,24),
(22,233,3,'Light Armor Mastery',2500,24),
(22,233,4,'Light Armor Mastery',2500,24),
(22,198,1,'Boost Evasion',5000,24),
(22,209,2,'Dagger Mastery',5000,24),
(22,208,4,'Bow Mastery',1700,24),
(22,208,5,'Bow Mastery',1700,24),
(22,208,6,'Bow Mastery',1700,24),
(22,27,2,'Unlock',5000,24),
(22,61,1,'Cure Bleeding',5000,24),
(22,21,1,'Poison Recovery',5000,24),
(22,96,1,'Bleed',5000,24),
(22,58,7,'Elemental Heal',1700,24),
(22,58,8,'Elemental Heal',1700,24),
(22,58,9,'Elemental Heal',1700,24),
(22,56,13,'Power Shot',1700,24),
(22,56,14,'Power Shot',1700,24),
(22,56,15,'Power Shot',1700,24),
(22,16,13,'Mortal Blow',1700,24),
(22,16,14,'Mortal Blow',1700,24),
(22,16,15,'Mortal Blow',1700,24),
(22,15,4,'Charm',1700,24),
(22,15,5,'Charm',1700,24),
(22,15,6,'Charm',1700,24),
(22,15,7,'Charm',3100,28),
(22,15,8,'Charm',3100,28),
(22,15,9,'Charm',3100,28),
(22,16,16,'Mortal Blow',3100,28),
(22,16,17,'Mortal Blow',3100,28),
(22,16,18,'Mortal Blow',3100,28),
(22,56,16,'Power Shot',3100,28),
(22,56,17,'Power Shot',3100,28),
(22,56,18,'Power Shot',3100,28),
(22,58,10,'Elemental Heal',3100,28),
(22,58,11,'Elemental Heal',3100,28),
(22,58,12,'Elemental Heal',3100,28),
(22,111,1,'Ultimate Evasion',9200,28),
(22,77,2,'Attack Aura',9200,28),
(22,27,3,'Unlock',9200,28),
(22,208,7,'Bow Mastery',3100,28),
(22,208,8,'Bow Mastery',3100,28),
(22,208,9,'Bow Mastery',3100,28),
(22,209,3,'Dagger Mastery',4600,28),
(22,209,4,'Dagger Mastery',4600,28),
(22,225,1,'Acrobatic Move',9200,28),
(22,169,1,'Quick Step',9200,28),
(22,233,5,'Light Armor Mastery',4600,28),
(22,233,6,'Light Armor Mastery',4600,28),
(22,312,3,'Vicious Stance',9200,28),
(22,312,4,'Vicious Stance',15000,32),
(22,233,7,'Light Armor Mastery',7700,32),
(22,233,8,'Light Armor Mastery',7700,32),
(22,137,1,'Critical Chance',15000,32),
(22,230,1,'Sprint',15000,32),
(22,209,5,'Dagger Mastery',7700,32),
(22,209,6,'Dagger Mastery',7700,32),
(22,208,10,'Bow Mastery',5100,32),
(22,208,11,'Bow Mastery',5100,32),
(22,208,12,'Bow Mastery',5100,32),
(22,27,4,'Unlock',15000,32),
(22,96,2,'Bleed',15000,32),
(22,99,1,'Rapid Shot',15000,32),
(22,58,13,'Elemental Heal',5100,32),
(22,58,14,'Elemental Heal',5100,32),
(22,58,15,'Elemental Heal',5100,32),
(22,56,19,'Power Shot',5100,32),
(22,56,20,'Power Shot',5100,32),
(22,56,21,'Power Shot',5100,32),
(22,16,19,'Mortal Blow',5100,32),
(22,16,20,'Mortal Blow',5100,32),
(22,16,21,'Mortal Blow',5100,32),
(22,15,10,'Charm',5100,32),
(22,15,11,'Charm',5100,32),
(22,15,12,'Charm',5100,32),
(22,15,13,'Charm',8600,36),
(22,15,14,'Charm',8600,36),
(22,15,15,'Charm',8600,36),
(22,16,22,'Mortal Blow',8600,36),
(22,16,23,'Mortal Blow',8600,36),
(22,16,24,'Mortal Blow',8600,36),
(22,56,22,'Power Shot',8600,36),
(22,56,23,'Power Shot',8600,36),
(22,56,24,'Power Shot',8600,36),
(22,58,16,'Elemental Heal',8600,36),
(22,58,17,'Elemental Heal',8600,36),
(22,58,18,'Elemental Heal',8600,36),
(22,101,1,'Stunning Shot',8600,36),
(22,101,2,'Stunning Shot',8600,36),
(22,101,3,'Stunning Shot',8600,36),
(22,102,1,'Entangle',26000,36),
(22,27,5,'Unlock',26000,36),
(22,208,13,'Bow Mastery',8600,36),
(22,208,14,'Bow Mastery',8600,36),
(22,208,15,'Bow Mastery',8600,36),
(22,209,7,'Dagger Mastery',13000,36),
(22,209,8,'Dagger Mastery',13000,36),
(22,171,1,'Esprit',26000,36),
(22,233,9,'Light Armor Mastery',13000,36),
(22,233,10,'Light Armor Mastery',13000,36),
(22,312,5,'Vicious Stance',26000,36),
(23,15,16,'Charm',9000,40),
(23,15,17,'Charm',9000,40),
(23,15,18,'Charm',9000,40),
(23,30,1,'Backstab',9000,40),
(23,30,2,'Backstab',9000,40),
(23,30,3,'Backstab',9000,40),
(23,58,19,'Elemental Heal',9000,40),
(23,58,20,'Elemental Heal',9000,40),
(23,58,21,'Elemental Heal',9000,40),
(23,27,6,'Unlock',28000,40),
(23,21,2,'Poison Recovery',28000,40),
(23,60,1,'Fake Death',28000,40),
(23,102,2,'Entangle',28000,40),
(23,209,9,'Dagger Mastery',9000,40),
(23,209,10,'Dagger Mastery',9000,40),
(23,209,11,'Dagger Mastery',9000,40),
(23,233,11,'Light Armor Mastery',9000,40),
(23,233,12,'Light Armor Mastery',9000,40),
(23,233,13,'Light Armor Mastery',9000,40),
(23,263,1,'Deadly Blow',9000,40),
(23,263,2,'Deadly Blow',9000,40),
(23,263,3,'Deadly Blow',9000,40),
(23,123,1,'Spirit Barrier',28000,40),
(23,137,2,'Critical Chance',28000,40),
(23,312,6,'Vicious Stance',28000,40),
(23,221,1,'Silent Move',28000,40),
(23,225,2,'Acrobatic Move',35000,43),
(23,312,7,'Vicious Stance',35000,43),
(23,169,2,'Quick Step',35000,43),
(23,171,2,'Esprit',35000,43),
(23,263,4,'Deadly Blow',12000,43),
(23,263,5,'Deadly Blow',12000,43),
(23,263,6,'Deadly Blow',12000,43),
(23,233,14,'Light Armor Mastery',12000,43),
(23,233,15,'Light Armor Mastery',12000,43),
(23,233,16,'Light Armor Mastery',12000,43),
(23,209,12,'Dagger Mastery',12000,43),
(23,209,13,'Dagger Mastery',12000,43),
(23,209,14,'Dagger Mastery',12000,43),
(23,102,3,'Entangle',35000,43),
(23,27,7,'Unlock',35000,43),
(23,12,1,'Switch',35000,43),
(23,58,22,'Elemental Heal',12000,43),
(23,58,23,'Elemental Heal',12000,43),
(23,58,24,'Elemental Heal',12000,43),
(23,30,4,'Backstab',12000,43),
(23,30,5,'Backstab',12000,43),
(23,30,6,'Backstab',12000,43),
(23,15,19,'Charm',12000,43),
(23,15,20,'Charm',12000,43),
(23,15,21,'Charm',12000,43),
(23,15,22,'Charm',13000,46),
(23,15,23,'Charm',13000,46),
(23,15,24,'Charm',13000,46),
(23,30,7,'Backstab',13000,46),
(23,30,8,'Backstab',13000,46),
(23,30,9,'Backstab',13000,46),
(23,58,25,'Elemental Heal',13000,46),
(23,58,26,'Elemental Heal',13000,46),
(23,58,27,'Elemental Heal',13000,46),
(23,12,2,'Switch',40000,46),
(23,27,8,'Unlock',40000,46),
(23,102,4,'Entangle',40000,46),
(23,61,2,'Cure Bleeding',40000,46),
(23,209,15,'Dagger Mastery',13000,46),
(23,209,16,'Dagger Mastery',13000,46),
(23,209,17,'Dagger Mastery',13000,46),
(23,233,17,'Light Armor Mastery',13000,46),
(23,233,18,'Light Armor Mastery',13000,46),
(23,233,19,'Light Armor Mastery',13000,46),
(23,263,7,'Deadly Blow',13000,46),
(23,263,8,'Deadly Blow',13000,46),
(23,263,9,'Deadly Blow',13000,46),
(23,171,3,'Esprit',40000,46),
(23,312,8,'Vicious Stance',40000,46),
(23,198,2,'Boost Evasion',40000,46),
(23,296,1,'Chameleon Rest',40000,46),
(23,419,1,'Summon Treasure Key',40000,46),
(23,312,9,'Vicious Stance',75000,49),
(23,171,4,'Esprit',75000,49),
(23,137,3,'Critical Chance',75000,49),
(23,123,2,'Spirit Barrier',75000,49),
(23,263,10,'Deadly Blow',25000,49),
(23,263,11,'Deadly Blow',25000,49),
(23,263,12,'Deadly Blow',25000,49),
(23,233,20,'Light Armor Mastery',25000,49),
(23,233,21,'Light Armor Mastery',25000,49),
(23,233,22,'Light Armor Mastery',25000,49),
(23,209,18,'Dagger Mastery',25000,49),
(23,209,19,'Dagger Mastery',25000,49),
(23,209,20,'Dagger Mastery',25000,49),
(23,96,3,'Bleed',75000,49),
(23,102,5,'Entangle',75000,49),
(23,12,3,'Switch',75000,49),
(23,58,28,'Elemental Heal',25000,49),
(23,58,29,'Elemental Heal',25000,49),
(23,58,30,'Elemental Heal',25000,49),
(23,30,10,'Backstab',25000,49),
(23,30,11,'Backstab',25000,49),
(23,30,12,'Backstab',25000,49),
(23,15,25,'Charm',25000,49),
(23,15,26,'Charm',25000,49),
(23,15,27,'Charm',25000,49),
(23,15,28,'Charm',38000,52),
(23,15,29,'Charm',38000,52),
(23,15,30,'Charm',38000,52),
(23,30,13,'Backstab',38000,52),
(23,30,14,'Backstab',38000,52),
(23,30,15,'Backstab',38000,52),
(23,58,31,'Elemental Heal',38000,52),
(23,58,32,'Elemental Heal',38000,52),
(23,58,33,'Elemental Heal',38000,52),
(23,12,4,'Switch',115000,52),
(23,27,9,'Unlock',115000,52),
(23,102,6,'Entangle',115000,52),
(23,209,21,'Dagger Mastery',38000,52),
(23,209,22,'Dagger Mastery',38000,52),
(23,209,23,'Dagger Mastery',38000,52),
(23,233,23,'Light Armor Mastery',38000,52),
(23,233,24,'Light Armor Mastery',38000,52),
(23,233,25,'Light Armor Mastery',38000,52),
(23,263,13,'Deadly Blow',38000,52),
(23,263,14,'Deadly Blow',38000,52),
(23,263,15,'Deadly Blow',38000,52),
(23,51,1,'Lure',115000,52),
(23,171,5,'Esprit',115000,52),
(23,312,10,'Vicious Stance',115000,52),
(23,230,2,'Sprint',115000,52),
(23,225,3,'Acrobatic Move',147000,55),
(23,412,1,'Sand Bomb',147000,55),
(23,312,11,'Vicious Stance',147000,55),
(23,111,2,'Ultimate Evasion',147000,55),
(23,173,2,'Acrobatics',147000,55),
(23,195,2,'Breath Boost',147000,55),
(23,263,16,'Deadly Blow',49000,55),
(23,263,17,'Deadly Blow',49000,55),
(23,263,18,'Deadly Blow',49000,55),
(23,233,26,'Light Armor Mastery',49000,55),
(23,233,27,'Light Armor Mastery',49000,55),
(23,233,28,'Light Armor Mastery',49000,55),
(23,209,24,'Dagger Mastery',49000,55),
(23,209,25,'Dagger Mastery',49000,55),
(23,209,26,'Dagger Mastery',49000,55),
(23,102,7,'Entangle',147000,55),
(23,27,10,'Unlock',147000,55),
(23,12,5,'Switch',147000,55),
(23,58,34,'Elemental Heal',49000,55),
(23,58,35,'Elemental Heal',49000,55),
(23,58,36,'Elemental Heal',49000,55),
(23,30,16,'Backstab',49000,55),
(23,30,17,'Backstab',49000,55),
(23,30,18,'Backstab',49000,55),
(23,15,31,'Charm',49000,55),
(23,15,32,'Charm',49000,55),
(23,15,33,'Charm',49000,55),
(23,137,4,'Critical Chance',150000,58),
(23,15,34,'Charm',53000,58),
(23,15,35,'Charm',53000,58),
(23,15,36,'Charm',53000,58),
(23,30,19,'Backstab',53000,58),
(23,30,20,'Backstab',53000,58),
(23,30,21,'Backstab',53000,58),
(23,58,37,'Elemental Heal',53000,58),
(23,58,38,'Elemental Heal',53000,58),
(23,58,39,'Elemental Heal',53000,58),
(23,12,6,'Switch',160000,58),
(23,102,8,'Entangle',160000,58),
(23,96,4,'Bleed',160000,58),
(23,209,27,'Dagger Mastery',53000,58),
(23,209,28,'Dagger Mastery',53000,58),
(23,209,29,'Dagger Mastery',53000,58),
(23,233,29,'Light Armor Mastery',53000,58),
(23,233,30,'Light Armor Mastery',53000,58),
(23,233,31,'Light Armor Mastery',53000,58),
(23,263,19,'Deadly Blow',53000,58),
(23,263,20,'Deadly Blow',53000,58),
(23,263,21,'Deadly Blow',53000,58),
(23,123,3,'Spirit Barrier',160000,58),
(23,312,12,'Vicious Stance',160000,58),
(23,412,2,'Sand Bomb',160000,58),
(23,198,3,'Boost Evasion',160000,58),
(23,410,1,'Mortal Strike',160000,58),
(23,419,2,'Summon Treasure Key',160000,58),
(23,453,1,'Escape Shackle',223000,60),
(23,412,3,'Sand Bomb',223000,60),
(23,312,13,'Vicious Stance',223000,60),
(23,263,22,'Deadly Blow',112000,60),
(23,263,23,'Deadly Blow',112000,60),
(23,233,32,'Light Armor Mastery',112000,60),
(23,233,33,'Light Armor Mastery',112000,60),
(23,209,30,'Dagger Mastery',112000,60),
(23,209,31,'Dagger Mastery',112000,60),
(23,21,3,'Poison Recovery',223000,60),
(23,102,9,'Entangle',223000,60),
(23,12,7,'Switch',223000,60),
(23,27,11,'Unlock',223000,60),
(23,58,40,'Elemental Heal',112000,60),
(23,58,41,'Elemental Heal',112000,60),
(23,30,22,'Backstab',112000,60),
(23,30,23,'Backstab',112000,60),
(23,15,37,'Charm',112000,60),
(23,15,38,'Charm',112000,60),
(23,15,39,'Charm',170000,62),
(23,15,40,'Charm',170000,62),
(23,30,24,'Backstab',170000,62),
(23,30,25,'Backstab',170000,62),
(23,58,42,'Elemental Heal',170000,62),
(23,58,43,'Elemental Heal',170000,62),
(23,12,8,'Switch',330000,62),
(23,102,10,'Entangle',330000,62),
(23,61,3,'Cure Bleeding',330000,62),
(23,209,32,'Dagger Mastery',170000,62),
(23,209,33,'Dagger Mastery',170000,62),
(23,233,34,'Light Armor Mastery',170000,62),
(23,233,35,'Light Armor Mastery',170000,62),
(23,263,24,'Deadly Blow',170000,62),
(23,263,25,'Deadly Blow',170000,62),
(23,312,14,'Vicious Stance',330000,62),
(23,171,6,'Esprit',330000,62),
(23,412,4,'Sand Bomb',330000,62),
(23,412,5,'Sand Bomb',440000,64),
(23,312,15,'Vicious Stance',440000,64),
(23,263,26,'Deadly Blow',220000,64),
(23,263,27,'Deadly Blow',220000,64),
(23,233,36,'Light Armor Mastery',220000,64),
(23,233,37,'Light Armor Mastery',220000,64),
(23,209,34,'Dagger Mastery',220000,64),
(23,209,35,'Dagger Mastery',220000,64),
(23,102,11,'Entangle',440000,64),
(23,12,9,'Switch',440000,64),
(23,27,12,'Unlock',440000,64),
(23,58,44,'Elemental Heal',220000,64),
(23,58,45,'Elemental Heal',220000,64),
(23,30,26,'Backstab',220000,64),
(23,30,27,'Backstab',220000,64),
(23,15,41,'Charm',220000,64),
(23,15,42,'Charm',220000,64),
(23,15,43,'Charm',250000,66),
(23,15,44,'Charm',250000,66),
(23,30,28,'Backstab',250000,66),
(23,30,29,'Backstab',250000,66),
(23,58,46,'Elemental Heal',250000,66),
(23,58,47,'Elemental Heal',250000,66),
(23,12,10,'Switch',500000,66),
(23,102,12,'Entangle',500000,66),
(23,96,5,'Bleed',500000,66),
(23,209,36,'Dagger Mastery',250000,66),
(23,209,37,'Dagger Mastery',250000,66),
(23,233,38,'Light Armor Mastery',250000,66),
(23,233,39,'Light Armor Mastery',250000,66),
(23,263,28,'Deadly Blow',250000,66),
(23,263,29,'Deadly Blow',250000,66),
(23,312,16,'Vicious Stance',500000,66),
(23,321,1,'Blinding Blow',250000,66),
(23,321,2,'Blinding Blow',250000,66),
(23,412,6,'Sand Bomb',500000,66),
(23,410,2,'Mortal Strike',500000,66),
(23,419,3,'Summon Treasure Key',500000,66),
(23,412,7,'Sand Bomb',600000,68),
(23,321,3,'Blinding Blow',300000,68),
(23,321,4,'Blinding Blow',300000,68),
(23,312,17,'Vicious Stance',600000,68),
(23,171,7,'Esprit',600000,68),
(23,263,30,'Deadly Blow',300000,68),
(23,263,31,'Deadly Blow',300000,68),
(23,233,40,'Light Armor Mastery',300000,68),
(23,233,41,'Light Armor Mastery',300000,68),
(23,209,38,'Dagger Mastery',300000,68),
(23,209,39,'Dagger Mastery',300000,68),
(23,102,13,'Entangle',600000,68),
(23,12,11,'Switch',600000,68),
(23,27,13,'Unlock',600000,68),
(23,58,48,'Elemental Heal',300000,68),
(23,58,49,'Elemental Heal',300000,68),
(23,30,30,'Backstab',300000,68),
(23,30,31,'Backstab',300000,68),
(23,15,45,'Charm',300000,68),
(23,15,46,'Charm',300000,68),
(23,15,47,'Charm',390000,70),
(23,15,48,'Charm',390000,70),
(23,30,32,'Backstab',390000,70),
(23,30,33,'Backstab',390000,70),
(23,58,50,'Elemental Heal',390000,70),
(23,58,51,'Elemental Heal',390000,70),
(23,12,12,'Switch',780000,70),
(23,102,14,'Entangle',780000,70),
(23,96,6,'Bleed',780000,70),
(23,209,40,'Dagger Mastery',390000,70),
(23,209,41,'Dagger Mastery',390000,70),
(23,233,42,'Light Armor Mastery',390000,70),
(23,233,43,'Light Armor Mastery',390000,70),
(23,263,32,'Deadly Blow',390000,70),
(23,263,33,'Deadly Blow',390000,70),
(23,312,18,'Vicious Stance',780000,70),
(23,321,5,'Blinding Blow',390000,70),
(23,321,6,'Blinding Blow',390000,70),
(23,412,8,'Sand Bomb',780000,70),
(23,412,9,'Sand Bomb',1000000,72),
(23,321,7,'Blinding Blow',500000,72),
(23,321,8,'Blinding Blow',500000,72),
(23,312,19,'Vicious Stance',1000000,72),
(23,263,34,'Deadly Blow',500000,72),
(23,263,35,'Deadly Blow',500000,72),
(23,233,44,'Light Armor Mastery',500000,72),
(23,233,45,'Light Armor Mastery',500000,72),
(23,209,42,'Dagger Mastery',500000,72),
(23,209,43,'Dagger Mastery',500000,72),
(23,102,15,'Entangle',1000000,72),
(23,12,13,'Switch',1000000,72),
(23,27,14,'Unlock',1000000,72),
(23,58,52,'Elemental Heal',500000,72),
(23,58,53,'Elemental Heal',500000,72),
(23,30,34,'Backstab',500000,72),
(23,30,35,'Backstab',500000,72),
(23,15,49,'Charm',500000,72),
(23,15,50,'Charm',500000,72),
(23,15,51,'Charm',930000,74),
(23,15,52,'Charm',930000,74),
(23,30,36,'Backstab',930000,74),
(23,30,37,'Backstab',930000,74),
(23,58,54,'Elemental Heal',930000,74),
(23,58,55,'Elemental Heal',930000,74),
(23,12,14,'Switch',1860000,74),
(23,102,16,'Entangle',1860000,74),
(23,209,44,'Dagger Mastery',930000,74),
(23,209,45,'Dagger Mastery',930000,74),
(23,233,46,'Light Armor Mastery',930000,74),
(23,233,47,'Light Armor Mastery',930000,74),
(23,263,36,'Deadly Blow',930000,74),
(23,263,37,'Deadly Blow',930000,74),
(23,312,20,'Vicious Stance',1860000,74),
(23,321,9,'Blinding Blow',930000,74),
(23,321,10,'Blinding Blow',930000,74),
(23,171,8,'Esprit',1860000,74),
(23,412,10,'Sand Bomb',1860000,74),
(23,410,3,'Mortal Strike',1860000,74),
(23,419,4,'Summon Treasure Key',1860000,74),
(23,623,1,'Find Trap',1630000,74),
(23,624,1,'Remove Trap',1630000,74),
(24,15,16,'Charm',12000,40),
(24,15,17,'Charm',12000,40),
(24,15,18,'Charm',12000,40),
(24,19,1,'Double Shot',12000,40),
(24,19,2,'Double Shot',12000,40),
(24,19,3,'Double Shot',12000,40),
(24,58,19,'Elemental Heal',12000,40),
(24,58,20,'Elemental Heal',12000,40),
(24,58,21,'Elemental Heal',12000,40),
(24,101,4,'Stunning Shot',12000,40),
(24,101,5,'Stunning Shot',12000,40),
(24,101,6,'Stunning Shot',12000,40),
(24,102,2,'Entangle',35000,40),
(24,21,2,'Poison Recovery',35000,40),
(24,113,2,'Long Shot',35000,40),
(24,123,1,'Spirit Barrier',35000,40),
(24,208,16,'Bow Mastery',12000,40),
(24,208,17,'Bow Mastery',12000,40),
(24,208,18,'Bow Mastery',12000,40),
(24,233,11,'Light Armor Mastery',12000,40),
(24,233,12,'Light Armor Mastery',12000,40),
(24,233,13,'Light Armor Mastery',12000,40),
(24,312,6,'Vicious Stance',35000,40),
(24,312,7,'Vicious Stance',42000,43),
(24,169,2,'Quick Step',42000,43),
(24,171,2,'Esprit',42000,43),
(24,225,2,'Acrobatic Move',42000,43),
(24,233,14,'Light Armor Mastery',14000,43),
(24,233,15,'Light Armor Mastery',14000,43),
(24,233,16,'Light Armor Mastery',14000,43),
(24,208,19,'Bow Mastery',14000,43),
(24,208,20,'Bow Mastery',14000,43),
(24,208,21,'Bow Mastery',14000,43),
(24,102,3,'Entangle',42000,43),
(24,101,7,'Stunning Shot',14000,43),
(24,101,8,'Stunning Shot',14000,43),
(24,101,9,'Stunning Shot',14000,43),
(24,58,22,'Elemental Heal',14000,43),
(24,58,23,'Elemental Heal',14000,43),
(24,58,24,'Elemental Heal',14000,43),
(24,19,4,'Double Shot',14000,43),
(24,19,5,'Double Shot',14000,43),
(24,19,6,'Double Shot',14000,43),
(24,15,19,'Charm',14000,43),
(24,15,20,'Charm',14000,43),
(24,15,21,'Charm',14000,43),
(24,15,22,'Charm',17000,46),
(24,15,23,'Charm',17000,46),
(24,15,24,'Charm',17000,46),
(24,19,7,'Double Shot',17000,46),
(24,19,8,'Double Shot',17000,46),
(24,19,9,'Double Shot',17000,46),
(24,58,25,'Elemental Heal',17000,46),
(24,58,26,'Elemental Heal',17000,46),
(24,58,27,'Elemental Heal',17000,46),
(24,101,10,'Stunning Shot',17000,46),
(24,101,11,'Stunning Shot',17000,46),
(24,101,12,'Stunning Shot',17000,46),
(24,102,4,'Entangle',50000,46),
(24,61,2,'Cure Bleeding',50000,46),
(24,24,1,'Burst Shot',17000,46),
(24,24,2,'Burst Shot',17000,46),
(24,24,3,'Burst Shot',17000,46),
(24,208,22,'Bow Mastery',17000,46),
(24,208,23,'Bow Mastery',17000,46),
(24,208,24,'Bow Mastery',17000,46),
(24,233,17,'Light Armor Mastery',17000,46),
(24,233,18,'Light Armor Mastery',17000,46),
(24,233,19,'Light Armor Mastery',17000,46),
(24,303,1,'Soul of Sagittarius',50000,46),
(24,171,3,'Esprit',50000,46),
(24,312,8,'Vicious Stance',50000,46),
(24,312,9,'Vicious Stance',89000,49),
(24,171,4,'Esprit',89000,49),
(24,233,20,'Light Armor Mastery',30000,49),
(24,233,21,'Light Armor Mastery',30000,49),
(24,233,22,'Light Armor Mastery',30000,49),
(24,208,25,'Bow Mastery',30000,49),
(24,208,26,'Bow Mastery',30000,49),
(24,208,27,'Bow Mastery',30000,49),
(24,24,4,'Burst Shot',30000,49),
(24,24,5,'Burst Shot',30000,49),
(24,24,6,'Burst Shot',30000,49),
(24,123,2,'Spirit Barrier',89000,49),
(24,102,5,'Entangle',89000,49),
(24,101,13,'Stunning Shot',30000,49),
(24,101,14,'Stunning Shot',30000,49),
(24,101,15,'Stunning Shot',30000,49),
(24,58,28,'Elemental Heal',30000,49),
(24,58,29,'Elemental Heal',30000,49),
(24,58,30,'Elemental Heal',30000,49),
(24,19,10,'Double Shot',30000,49),
(24,19,11,'Double Shot',30000,49),
(24,19,12,'Double Shot',30000,49),
(24,15,25,'Charm',30000,49),
(24,15,26,'Charm',30000,49),
(24,15,27,'Charm',30000,49),
(24,15,28,'Charm',45000,52),
(24,15,29,'Charm',45000,52),
(24,15,30,'Charm',45000,52),
(24,19,13,'Double Shot',45000,52),
(24,19,14,'Double Shot',45000,52),
(24,19,15,'Double Shot',45000,52),
(24,58,31,'Elemental Heal',45000,52),
(24,58,32,'Elemental Heal',45000,52),
(24,58,33,'Elemental Heal',45000,52),
(24,101,16,'Stunning Shot',45000,52),
(24,101,17,'Stunning Shot',45000,52),
(24,101,18,'Stunning Shot',45000,52),
(24,102,6,'Entangle',136000,52),
(24,24,7,'Burst Shot',45000,52),
(24,24,8,'Burst Shot',45000,52),
(24,24,9,'Burst Shot',45000,52),
(24,208,28,'Bow Mastery',45000,52),
(24,208,29,'Bow Mastery',45000,52),
(24,208,30,'Bow Mastery',45000,52),
(24,233,23,'Light Armor Mastery',45000,52),
(24,233,24,'Light Armor Mastery',45000,52),
(24,233,25,'Light Armor Mastery',45000,52),
(24,171,5,'Esprit',136000,52),
(24,230,2,'Sprint',136000,52),
(24,312,10,'Vicious Stance',136000,52),
(24,312,11,'Vicious Stance',182000,55),
(24,99,2,'Rapid Shot',182000,55),
(24,225,3,'Acrobatic Move',182000,55),
(24,233,26,'Light Armor Mastery',61000,55),
(24,233,27,'Light Armor Mastery',61000,55),
(24,233,28,'Light Armor Mastery',61000,55),
(24,208,31,'Bow Mastery',61000,55),
(24,208,32,'Bow Mastery',61000,55),
(24,208,33,'Bow Mastery',61000,55),
(24,24,10,'Burst Shot',61000,55),
(24,24,11,'Burst Shot',61000,55),
(24,24,12,'Burst Shot',61000,55),
(24,102,7,'Entangle',182000,55),
(24,101,19,'Stunning Shot',61000,55),
(24,101,20,'Stunning Shot',61000,55),
(24,101,21,'Stunning Shot',61000,55),
(24,58,34,'Elemental Heal',61000,55),
(24,58,35,'Elemental Heal',61000,55),
(24,58,36,'Elemental Heal',61000,55),
(24,19,16,'Double Shot',61000,55),
(24,19,17,'Double Shot',61000,55),
(24,19,18,'Double Shot',61000,55),
(24,15,31,'Charm',61000,55),
(24,15,32,'Charm',61000,55),
(24,15,33,'Charm',61000,55),
(24,15,34,'Charm',67000,58),
(24,15,35,'Charm',67000,58),
(24,15,36,'Charm',67000,58),
(24,19,19,'Double Shot',67000,58),
(24,19,20,'Double Shot',67000,58),
(24,19,21,'Double Shot',67000,58),
(24,58,37,'Elemental Heal',67000,58),
(24,58,38,'Elemental Heal',67000,58),
(24,58,39,'Elemental Heal',67000,58),
(24,101,22,'Stunning Shot',67000,58),
(24,101,23,'Stunning Shot',67000,58),
(24,101,24,'Stunning Shot',67000,58),
(24,102,8,'Entangle',200000,58),
(24,123,3,'Spirit Barrier',200000,58),
(24,24,13,'Burst Shot',67000,58),
(24,24,14,'Burst Shot',67000,58),
(24,24,15,'Burst Shot',67000,58),
(24,208,34,'Bow Mastery',67000,58),
(24,208,35,'Bow Mastery',67000,58),
(24,208,36,'Bow Mastery',67000,58),
(24,233,29,'Light Armor Mastery',67000,58),
(24,233,30,'Light Armor Mastery',67000,58),
(24,233,31,'Light Armor Mastery',67000,58),
(24,303,2,'Soul of Sagittarius',200000,58),
(24,312,12,'Vicious Stance',200000,58),
(24,415,1,'Spirit of Sagittarius',200000,58),
(24,416,1,'Blessing of Sagittarius',200000,58),
(24,312,13,'Vicious Stance',264000,60),
(24,413,1,'Rapid Fire',264000,60),
(24,233,32,'Light Armor Mastery',132000,60),
(24,233,33,'Light Armor Mastery',132000,60),
(24,208,37,'Bow Mastery',132000,60),
(24,208,38,'Bow Mastery',132000,60),
(24,24,16,'Burst Shot',132000,60),
(24,24,17,'Burst Shot',132000,60),
(24,21,3,'Poison Recovery',264000,60),
(24,102,9,'Entangle',264000,60),
(24,101,25,'Stunning Shot',132000,60),
(24,101,26,'Stunning Shot',132000,60),
(24,58,40,'Elemental Heal',132000,60),
(24,58,41,'Elemental Heal',132000,60),
(24,19,22,'Double Shot',132000,60),
(24,19,23,'Double Shot',132000,60),
(24,15,37,'Charm',132000,60),
(24,15,38,'Charm',132000,60),
(24,15,39,'Charm',170000,62),
(24,15,40,'Charm',170000,62),
(24,19,24,'Double Shot',170000,62),
(24,19,25,'Double Shot',170000,62),
(24,58,42,'Elemental Heal',170000,62),
(24,58,43,'Elemental Heal',170000,62),
(24,101,27,'Stunning Shot',170000,62),
(24,101,28,'Stunning Shot',170000,62),
(24,102,10,'Entangle',330000,62),
(24,61,3,'Cure Bleeding',330000,62),
(24,24,18,'Burst Shot',170000,62),
(24,24,19,'Burst Shot',170000,62),
(24,208,39,'Bow Mastery',170000,62),
(24,208,40,'Bow Mastery',170000,62),
(24,233,34,'Light Armor Mastery',170000,62),
(24,233,35,'Light Armor Mastery',170000,62),
(24,413,2,'Rapid Fire',330000,62),
(24,312,14,'Vicious Stance',330000,62),
(24,171,6,'Esprit',330000,62),
(24,303,3,'Soul of Sagittarius',440000,64),
(24,312,15,'Vicious Stance',440000,64),
(24,413,3,'Rapid Fire',440000,64),
(24,233,36,'Light Armor Mastery',220000,64),
(24,233,37,'Light Armor Mastery',220000,64),
(24,208,41,'Bow Mastery',220000,64),
(24,208,42,'Bow Mastery',220000,64),
(24,24,20,'Burst Shot',220000,64),
(24,24,21,'Burst Shot',220000,64),
(24,102,11,'Entangle',440000,64),
(24,101,29,'Stunning Shot',220000,64),
(24,101,30,'Stunning Shot',220000,64),
(24,58,44,'Elemental Heal',220000,64),
(24,58,45,'Elemental Heal',220000,64),
(24,19,26,'Double Shot',220000,64),
(24,19,27,'Double Shot',220000,64),
(24,15,41,'Charm',220000,64),
(24,15,42,'Charm',220000,64),
(24,15,43,'Charm',270000,66),
(24,15,44,'Charm',270000,66),
(24,19,28,'Double Shot',270000,66),
(24,19,29,'Double Shot',270000,66),
(24,58,46,'Elemental Heal',270000,66),
(24,58,47,'Elemental Heal',270000,66),
(24,101,31,'Stunning Shot',270000,66),
(24,101,32,'Stunning Shot',270000,66),
(24,102,12,'Entangle',540000,66),
(24,24,22,'Burst Shot',270000,66),
(24,24,23,'Burst Shot',270000,66),
(24,208,43,'Bow Mastery',270000,66),
(24,208,44,'Bow Mastery',270000,66),
(24,233,38,'Light Armor Mastery',270000,66),
(24,233,39,'Light Armor Mastery',270000,66),
(24,413,4,'Rapid Fire',540000,66),
(24,312,16,'Vicious Stance',540000,66),
(24,416,2,'Blessing of Sagittarius',540000,66),
(24,415,2,'Spirit of Sagittarius',540000,66),
(24,323,1,'Quiver of Arrow: Grade A',540000,66),
(24,312,17,'Vicious Stance',710000,68),
(24,413,5,'Rapid Fire',710000,68),
(24,171,7,'Esprit',710000,68),
(24,233,40,'Light Armor Mastery',350000,68),
(24,233,41,'Light Armor Mastery',350000,68),
(24,208,45,'Bow Mastery',350000,68),
(24,208,46,'Bow Mastery',350000,68),
(24,24,24,'Burst Shot',350000,68),
(24,24,25,'Burst Shot',350000,68),
(24,102,13,'Entangle',710000,68),
(24,101,33,'Stunning Shot',350000,68),
(24,101,34,'Stunning Shot',350000,68),
(24,58,48,'Elemental Heal',350000,68),
(24,58,49,'Elemental Heal',350000,68),
(24,19,30,'Double Shot',350000,68),
(24,19,31,'Double Shot',350000,68),
(24,15,45,'Charm',350000,68),
(24,15,46,'Charm',350000,68),
(24,15,47,'Charm',420000,70),
(24,15,48,'Charm',420000,70),
(24,19,32,'Double Shot',420000,70),
(24,19,33,'Double Shot',420000,70),
(24,58,50,'Elemental Heal',420000,70),
(24,58,51,'Elemental Heal',420000,70),
(24,101,35,'Stunning Shot',420000,70),
(24,101,36,'Stunning Shot',420000,70),
(24,102,14,'Entangle',850000,70),
(24,24,26,'Burst Shot',420000,70),
(24,24,27,'Burst Shot',420000,70),
(24,208,47,'Bow Mastery',420000,70),
(24,208,48,'Bow Mastery',420000,70),
(24,233,42,'Light Armor Mastery',420000,70),
(24,233,43,'Light Armor Mastery',420000,70),
(24,303,4,'Soul of Sagittarius',850000,70),
(24,413,6,'Rapid Fire',850000,70),
(24,312,18,'Vicious Stance',850000,70),
(24,312,19,'Vicious Stance',1090000,72),
(24,413,7,'Rapid Fire',1090000,72),
(24,233,44,'Light Armor Mastery',550000,72),
(24,233,45,'Light Armor Mastery',550000,72),
(24,208,49,'Bow Mastery',550000,72),
(24,208,50,'Bow Mastery',550000,72),
(24,24,28,'Burst Shot',550000,72),
(24,24,29,'Burst Shot',550000,72),
(24,102,15,'Entangle',1090000,72),
(24,101,37,'Stunning Shot',550000,72),
(24,101,38,'Stunning Shot',550000,72),
(24,58,52,'Elemental Heal',550000,72),
(24,58,53,'Elemental Heal',550000,72),
(24,19,34,'Double Shot',550000,72),
(24,19,35,'Double Shot',550000,72),
(24,15,49,'Charm',550000,72),
(24,15,50,'Charm',550000,72),
(24,324,1,'Quiver of Arrow: Grade S',1090000,72),
(24,933,1,'Detection',1860000,74),
(24,415,3,'Spirit of Sagittarius',2000000,74),
(24,416,3,'Blessing of Sagittarius',2000000,74),
(24,15,51,'Charm',1000000,74),
(24,15,52,'Charm',1000000,74),
(24,19,36,'Double Shot',1000000,74),
(24,19,37,'Double Shot',1000000,74),
(24,58,54,'Elemental Heal',1000000,74),
(24,58,55,'Elemental Heal',1000000,74),
(24,101,39,'Stunning Shot',1000000,74),
(24,101,40,'Stunning Shot',1000000,74),
(24,102,16,'Entangle',2000000,74),
(24,24,30,'Burst Shot',1000000,74),
(24,24,31,'Burst Shot',1000000,74),
(24,208,51,'Bow Mastery',1000000,74),
(24,208,52,'Bow Mastery',1000000,74),
(24,233,46,'Light Armor Mastery',1000000,74),
(24,233,47,'Light Armor Mastery',1000000,74),
(24,413,8,'Rapid Fire',2000000,74),
(24,312,20,'Vicious Stance',2000000,74),
(24,171,8,'Esprit',2000000,74),
(25,163,1,'Spellcraft',0,1),
(25,214,1,'Mana Recovery',0,1),
(25,118,1,'Magician\'s Movement',0,1),
(25,1177,1,'Wind Strike',0,1),
(25,1216,1,'Self Heal',0,1),
(25,1040,1,'Shield',520,7),
(25,1068,1,'Might',520,7),
(25,1177,2,'Wind Strike',260,7),
(25,1177,3,'Wind Strike',260,7),
(25,1184,1,'Ice Bolt',260,7),
(25,1184,2,'Ice Bolt',260,7),
(25,1011,1,'Heal',170,7),
(25,1011,2,'Heal',170,7),
(25,1011,3,'Heal',170,7),
(25,1012,1,'Cure Poison',520,7),
(25,146,1,'Anti Magic',260,7),
(25,146,2,'Anti Magic',260,7),
(25,244,1,'Armor Mastery',520,7),
(25,249,1,'Weapon Mastery',520,7),
(25,249,2,'Weapon Mastery',2100,14),
(25,244,2,'Armor Mastery',1100,14),
(25,244,3,'Armor Mastery',1100,14),
(25,146,3,'Anti Magic',1100,14),
(25,146,4,'Anti Magic',1100,14),
(25,1015,1,'Battle Heal',700,14),
(25,1015,2,'Battle Heal',700,14),
(25,1015,3,'Battle Heal',700,14),
(25,1027,1,'Group Heal',700,14),
(25,1027,2,'Group Heal',700,14),
(25,1027,3,'Group Heal',700,14),
(25,1011,4,'Heal',700,14),
(25,1011,5,'Heal',700,14),
(25,1011,6,'Heal',700,14),
(25,1184,3,'Ice Bolt',1100,14),
(25,1184,4,'Ice Bolt',1100,14),
(25,1206,1,'Wind Shackle',2100,14),
(25,1177,4,'Wind Strike',1100,14),
(25,1177,5,'Wind Strike',1100,14),
(25,1164,1,'Curse: Weakness',2100,14),
(26,146,5,'Anti Magic',1500,20),
(26,146,6,'Anti Magic',1500,20),
(26,234,1,'Robe Mastery',1500,20),
(26,234,2,'Robe Mastery',1500,20),
(26,164,1,'Quick Recycle',3100,20),
(26,213,1,'Boost Mana',3100,20),
(26,249,3,'Weapon Mastery',3100,20),
(26,285,1,'Higher Mana Gain',1500,20),
(26,285,2,'Higher Mana Gain',1500,20),
(26,1078,1,'Concentration',3100,20),
(26,1127,1,'Servitor Heal',1000,20),
(26,1127,2,'Servitor Heal',1000,20),
(26,1127,3,'Servitor Heal',1000,20),
(26,1172,1,'Aura Burn',1500,20),
(26,1172,2,'Aura Burn',1500,20),
(26,1175,1,'Aqua Swirl',1500,20),
(26,1175,2,'Aqua Swirl',1500,20),
(26,1164,2,'Curse: Weakness',3100,20),
(26,1184,5,'Ice Bolt',1500,20),
(26,1184,6,'Ice Bolt',1500,20),
(26,1206,2,'Wind Shackle',3100,20),
(26,1226,1,'Summon Boxer the Unicorn',3100,20),
(26,1227,1,'Summon Mirage the Unicorn',3100,20),
(26,1181,1,'Flame Strike',3100,20),
(26,1274,1,'Energy Bolt',3100,20),
(26,1274,2,'Energy Bolt',5800,25),
(26,1181,2,'Flame Strike',5800,25),
(26,1264,1,'Solar Spark',5800,25),
(26,1227,2,'Summon Mirage the Unicorn',5800,25),
(26,1226,2,'Summon Boxer the Unicorn',5800,25),
(26,1206,3,'Wind Shackle',5800,25),
(26,1164,3,'Curse: Weakness',5800,25),
(26,1175,3,'Aqua Swirl',2900,25),
(26,1175,4,'Aqua Swirl',2900,25),
(26,1182,1,'Resist Aqua',5800,25),
(26,1172,3,'Aura Burn',2900,25),
(26,1172,4,'Aura Burn',2900,25),
(26,1127,4,'Servitor Heal',1900,25),
(26,1127,5,'Servitor Heal',1900,25),
(26,1127,6,'Servitor Heal',1900,25),
(26,228,1,'Fast Spell Casting',5800,25),
(26,229,1,'Fast Mana Recovery',5800,25),
(26,1126,1,'Servitor Recharge',2900,25),
(26,1126,2,'Servitor Recharge',2900,25),
(26,1069,1,'Sleep',1900,25),
(26,1069,2,'Sleep',1900,25),
(26,1069,3,'Sleep',1900,25),
(26,285,3,'Higher Mana Gain',2900,25),
(26,285,4,'Higher Mana Gain',2900,25),
(26,249,4,'Weapon Mastery',2900,25),
(26,249,5,'Weapon Mastery',2900,25),
(26,234,3,'Robe Mastery',2900,25),
(26,234,4,'Robe Mastery',2900,25),
(26,146,7,'Anti Magic',2900,25),
(26,146,8,'Anti Magic',2900,25),
(26,146,9,'Anti Magic',5500,30),
(26,146,10,'Anti Magic',5500,30),
(26,234,5,'Robe Mastery',5500,30),
(26,234,6,'Robe Mastery',5500,30),
(26,249,6,'Weapon Mastery',5500,30),
(26,249,7,'Weapon Mastery',5500,30),
(26,213,2,'Boost Mana',11100,30),
(26,164,2,'Quick Recycle',11100,30),
(26,285,5,'Higher Mana Gain',5500,30),
(26,285,6,'Higher Mana Gain',5500,30),
(26,1069,4,'Sleep',3700,30),
(26,1069,5,'Sleep',3700,30),
(26,1069,6,'Sleep',3700,30),
(26,1126,3,'Servitor Recharge',5500,30),
(26,1126,4,'Servitor Recharge',5500,30),
(26,1078,2,'Concentration',11100,30),
(26,1127,7,'Servitor Heal',3700,30),
(26,1127,8,'Servitor Heal',3700,30),
(26,1127,9,'Servitor Heal',3700,30),
(26,1172,5,'Aura Burn',5500,30),
(26,1172,6,'Aura Burn',5500,30),
(26,1175,5,'Aqua Swirl',5500,30),
(26,1175,6,'Aqua Swirl',5500,30),
(26,1164,4,'Curse: Weakness',11100,30),
(26,1206,4,'Wind Shackle',11100,30),
(26,1226,3,'Summon Boxer the Unicorn',11100,30),
(26,1227,3,'Summon Mirage the Unicorn',11100,30),
(26,1264,2,'Solar Spark',11100,30),
(26,1181,3,'Flame Strike',11100,30),
(26,1274,3,'Energy Bolt',11100,30),
(26,1274,4,'Energy Bolt',19500,35),
(26,1264,3,'Solar Spark',19500,35),
(26,1227,4,'Summon Mirage the Unicorn',19500,35),
(26,1226,4,'Summon Boxer the Unicorn',19500,35),
(26,1206,5,'Wind Shackle',19500,35),
(26,1223,1,'Surrender To Earth',19500,35),
(26,1164,5,'Curse: Weakness',19500,35),
(26,1175,7,'Aqua Swirl',9700,35),
(26,1175,8,'Aqua Swirl',9700,35),
(26,1172,7,'Aura Burn',9700,35),
(26,1172,8,'Aura Burn',9700,35),
(26,1127,10,'Servitor Heal',6500,35),
(26,1127,11,'Servitor Heal',6500,35),
(26,1127,12,'Servitor Heal',6500,35),
(26,1145,1,'Bright Servitor',19500,35),
(26,229,2,'Fast Mana Recovery',19500,35),
(26,1126,5,'Servitor Recharge',9700,35),
(26,1126,6,'Servitor Recharge',9700,35),
(26,1069,7,'Sleep',6500,35),
(26,1069,8,'Sleep',6500,35),
(26,1069,9,'Sleep',6500,35),
(26,285,7,'Higher Mana Gain',9700,35),
(26,285,8,'Higher Mana Gain',9700,35),
(26,212,1,'Fast HP Recovery',19500,35),
(26,249,8,'Weapon Mastery',9700,35),
(26,249,9,'Weapon Mastery',9700,35),
(26,234,7,'Robe Mastery',9700,35),
(26,234,8,'Robe Mastery',9700,35),
(26,146,11,'Anti Magic',9700,35),
(26,146,12,'Anti Magic',9700,35),
(27,146,13,'Anti Magic',9000,40),
(27,146,14,'Anti Magic',9000,40),
(27,146,15,'Anti Magic',9000,40),
(27,234,9,'Robe Mastery',9000,40),
(27,234,10,'Robe Mastery',9000,40),
(27,234,11,'Robe Mastery',9000,40),
(27,249,10,'Weapon Mastery',9000,40),
(27,249,11,'Weapon Mastery',9000,40),
(27,249,12,'Weapon Mastery',9000,40),
(27,285,9,'Higher Mana Gain',14000,40),
(27,285,10,'Higher Mana Gain',14000,40),
(27,213,3,'Boost Mana',27000,40),
(27,1047,1,'Mana Regeneration',27000,40),
(27,1069,10,'Sleep',9000,40),
(27,1069,11,'Sleep',9000,40),
(27,1069,12,'Sleep',9000,40),
(27,1071,1,'Surrender To Water',27000,40),
(27,1164,6,'Curse: Weakness',27000,40),
(27,1169,1,'Curse Fear',27000,40),
(27,1182,2,'Resist Aqua',27000,40),
(27,1223,2,'Surrender To Earth',27000,40),
(27,1231,1,'Aura Flare',14000,40),
(27,1231,2,'Aura Flare',14000,40),
(27,1235,1,'Hydro Blast',14000,40),
(27,1235,2,'Hydro Blast',14000,40),
(27,1236,1,'Frost Bolt',14000,40),
(27,1236,2,'Frost Bolt',14000,40),
(27,1265,1,'Solar Flare',27000,40),
(27,1275,1,'Aura Bolt',27000,40),
(27,228,2,'Fast Spell Casting',27000,40),
(27,1238,1,'Freezing Skin',27000,40),
(27,1297,1,'Clear Mind',27000,40),
(27,1275,2,'Aura Bolt',35000,44),
(27,1265,2,'Solar Flare',35000,44),
(27,1236,3,'Frost Bolt',18000,44),
(27,1236,4,'Frost Bolt',18000,44),
(27,1237,1,'Ice Dagger',18000,44),
(27,1237,2,'Ice Dagger',18000,44),
(27,1235,3,'Hydro Blast',18000,44),
(27,1235,4,'Hydro Blast',18000,44),
(27,1231,3,'Aura Flare',18000,44),
(27,1231,4,'Aura Flare',18000,44),
(27,1223,3,'Surrender To Earth',35000,44),
(27,1182,3,'Resist Aqua',35000,44),
(27,1183,1,'Freezing Shackle',35000,44),
(27,1072,1,'Sleeping Cloud',35000,44),
(27,1169,2,'Curse Fear',35000,44),
(27,1164,7,'Curse: Weakness',35000,44),
(27,1071,2,'Surrender To Water',35000,44),
(27,1069,13,'Sleep',12000,44),
(27,1069,14,'Sleep',12000,44),
(27,1069,15,'Sleep',12000,44),
(27,229,3,'Fast Mana Recovery',35000,44),
(27,212,2,'Fast HP Recovery',35000,44),
(27,285,11,'Higher Mana Gain',18000,44),
(27,285,12,'Higher Mana Gain',18000,44),
(27,249,13,'Weapon Mastery',12000,44),
(27,249,14,'Weapon Mastery',12000,44),
(27,249,15,'Weapon Mastery',12000,44),
(27,234,12,'Robe Mastery',12000,44),
(27,234,13,'Robe Mastery',12000,44),
(27,234,14,'Robe Mastery',12000,44),
(27,146,16,'Anti Magic',12000,44),
(27,146,17,'Anti Magic',12000,44),
(27,146,18,'Anti Magic',12000,44),
(27,146,19,'Anti Magic',19000,48),
(27,146,20,'Anti Magic',19000,48),
(27,146,21,'Anti Magic',19000,48),
(27,234,15,'Robe Mastery',19000,48),
(27,234,16,'Robe Mastery',19000,48),
(27,234,17,'Robe Mastery',19000,48),
(27,249,16,'Weapon Mastery',19000,48),
(27,249,17,'Weapon Mastery',19000,48),
(27,249,18,'Weapon Mastery',19000,48),
(27,285,13,'Higher Mana Gain',29000,48),
(27,285,14,'Higher Mana Gain',29000,48),
(27,213,4,'Boost Mana',57000,48),
(27,1047,2,'Mana Regeneration',57000,48),
(27,1069,16,'Sleep',19000,48),
(27,1069,17,'Sleep',19000,48),
(27,1069,18,'Sleep',19000,48),
(27,1071,3,'Surrender To Water',57000,48),
(27,1056,1,'Cancellation',57000,48),
(27,1164,8,'Curse: Weakness',57000,48),
(27,1169,3,'Curse Fear',57000,48),
(27,1223,4,'Surrender To Earth',57000,48),
(27,1231,5,'Aura Flare',29000,48),
(27,1231,6,'Aura Flare',29000,48),
(27,1235,5,'Hydro Blast',29000,48),
(27,1235,6,'Hydro Blast',29000,48),
(27,1237,3,'Ice Dagger',29000,48),
(27,1237,4,'Ice Dagger',29000,48),
(27,1236,5,'Frost Bolt',29000,48),
(27,1236,6,'Frost Bolt',29000,48),
(27,1265,3,'Solar Flare',57000,48),
(27,1275,3,'Aura Bolt',57000,48),
(27,1238,2,'Freezing Skin',57000,48),
(27,1297,2,'Clear Mind',57000,48),
(27,164,3,'Quick Recycle',57000,48),
(27,1275,4,'Aura Bolt',90000,52),
(27,1265,4,'Solar Flare',90000,52),
(27,1236,7,'Frost Bolt',45000,52),
(27,1236,8,'Frost Bolt',45000,52),
(27,1237,5,'Ice Dagger',45000,52),
(27,1237,6,'Ice Dagger',45000,52),
(27,1235,7,'Hydro Blast',45000,52),
(27,1235,8,'Hydro Blast',45000,52),
(27,1231,7,'Aura Flare',45000,52),
(27,1231,8,'Aura Flare',45000,52),
(27,1223,5,'Surrender To Earth',90000,52),
(27,1183,2,'Freezing Shackle',90000,52),
(27,1174,1,'Frost Wall',45000,52),
(27,1174,2,'Frost Wall',45000,52),
(27,1169,4,'Curse Fear',90000,52),
(27,1164,9,'Curse: Weakness',90000,52),
(27,1056,2,'Cancellation',90000,52),
(27,1071,4,'Surrender To Water',90000,52),
(27,1069,19,'Sleep',30000,52),
(27,1069,20,'Sleep',30000,52),
(27,1069,21,'Sleep',30000,52),
(27,229,4,'Fast Mana Recovery',90000,52),
(27,212,3,'Fast HP Recovery',90000,52),
(27,285,15,'Higher Mana Gain',45000,52),
(27,285,16,'Higher Mana Gain',45000,52),
(27,249,19,'Weapon Mastery',30000,52),
(27,249,20,'Weapon Mastery',30000,52),
(27,249,21,'Weapon Mastery',30000,52),
(27,234,18,'Robe Mastery',30000,52),
(27,234,19,'Robe Mastery',30000,52),
(27,234,20,'Robe Mastery',30000,52),
(27,146,22,'Anti Magic',30000,52),
(27,146,23,'Anti Magic',30000,52),
(27,146,24,'Anti Magic',30000,52),
(27,146,25,'Anti Magic',30000,56),
(27,146,26,'Anti Magic',30000,56),
(27,146,27,'Anti Magic',30000,56),
(27,234,21,'Robe Mastery',30000,56),
(27,234,22,'Robe Mastery',30000,56),
(27,234,23,'Robe Mastery',30000,56),
(27,249,22,'Weapon Mastery',30000,56),
(27,249,23,'Weapon Mastery',30000,56),
(27,249,24,'Weapon Mastery',30000,56),
(27,285,17,'Higher Mana Gain',45000,56),
(27,285,18,'Higher Mana Gain',45000,56),
(27,213,5,'Boost Mana',91000,56),
(27,1069,22,'Sleep',30000,56),
(27,1069,23,'Sleep',30000,56),
(27,1069,24,'Sleep',30000,56),
(27,1071,5,'Surrender To Water',91000,56),
(27,1056,3,'Cancellation',91000,56),
(27,1164,10,'Curse: Weakness',91000,56),
(27,1169,5,'Curse Fear',91000,56),
(27,1174,3,'Frost Wall',45000,56),
(27,1174,4,'Frost Wall',45000,56),
(27,1072,2,'Sleeping Cloud',91000,56),
(27,1223,6,'Surrender To Earth',91000,56),
(27,1231,9,'Aura Flare',45000,56),
(27,1231,10,'Aura Flare',45000,56),
(27,1235,9,'Hydro Blast',45000,56),
(27,1235,10,'Hydro Blast',45000,56),
(27,1237,7,'Ice Dagger',45000,56),
(27,1237,8,'Ice Dagger',45000,56),
(27,1236,9,'Frost Bolt',45000,56),
(27,1236,10,'Frost Bolt',45000,56),
(27,1265,5,'Solar Flare',91000,56),
(27,1275,5,'Aura Bolt',91000,56),
(27,1238,3,'Freezing Skin',91000,56),
(27,228,3,'Fast Spell Casting',91000,56),
(27,1297,3,'Clear Mind',91000,56),
(27,1417,1,'Aura Flash',110000,58),
(27,1295,1,'Aqua Splash',110000,58),
(27,1275,6,'Aura Bolt',110000,58),
(27,1265,6,'Solar Flare',110000,58),
(27,1236,11,'Frost Bolt',110000,58),
(27,1237,9,'Ice Dagger',110000,58),
(27,1235,11,'Hydro Blast',55000,58),
(27,1235,12,'Hydro Blast',55000,58),
(27,1231,11,'Aura Flare',55000,58),
(27,1231,12,'Aura Flare',55000,58),
(27,1223,7,'Surrender To Earth',110000,58),
(27,1174,5,'Frost Wall',55000,58),
(27,1174,6,'Frost Wall',55000,58),
(27,1169,6,'Curse Fear',110000,58),
(27,1164,11,'Curse: Weakness',110000,58),
(27,1056,4,'Cancellation',110000,58),
(27,1071,6,'Surrender To Water',110000,58),
(27,1069,25,'Sleep',55000,58),
(27,1069,26,'Sleep',55000,58),
(27,212,4,'Fast HP Recovery',110000,58),
(27,285,19,'Higher Mana Gain',110000,58),
(27,249,25,'Weapon Mastery',55000,58),
(27,249,26,'Weapon Mastery',55000,58),
(27,234,24,'Robe Mastery',55000,58),
(27,234,25,'Robe Mastery',55000,58),
(27,146,28,'Anti Magic',55000,58),
(27,146,29,'Anti Magic',55000,58),
(27,146,30,'Anti Magic',71000,60),
(27,146,31,'Anti Magic',71000,60),
(27,234,26,'Robe Mastery',71000,60),
(27,234,27,'Robe Mastery',71000,60),
(27,249,27,'Weapon Mastery',71000,60),
(27,249,28,'Weapon Mastery',71000,60),
(27,285,20,'Higher Mana Gain',143000,60),
(27,213,6,'Boost Mana',143000,60),
(27,229,5,'Fast Mana Recovery',143000,60),
(27,1047,3,'Mana Regeneration',143000,60),
(27,1069,27,'Sleep',71000,60),
(27,1069,28,'Sleep',71000,60),
(27,1071,7,'Surrender To Water',143000,60),
(27,1056,5,'Cancellation',143000,60),
(27,1164,12,'Curse: Weakness',143000,60),
(27,1169,7,'Curse Fear',143000,60),
(27,1174,7,'Frost Wall',71000,60),
(27,1174,8,'Frost Wall',71000,60),
(27,1223,8,'Surrender To Earth',143000,60),
(27,1231,13,'Aura Flare',71000,60),
(27,1231,14,'Aura Flare',71000,60),
(27,1235,13,'Hydro Blast',71000,60),
(27,1235,14,'Hydro Blast',71000,60),
(27,1237,10,'Ice Dagger',143000,60),
(27,1236,12,'Frost Bolt',143000,60),
(27,1265,7,'Solar Flare',143000,60),
(27,1275,7,'Aura Bolt',143000,60),
(27,1295,2,'Aqua Splash',143000,60),
(27,1295,3,'Aqua Splash',190000,62),
(27,1275,8,'Aura Bolt',190000,62),
(27,1265,8,'Solar Flare',190000,62),
(27,1236,13,'Frost Bolt',190000,62),
(27,1237,11,'Ice Dagger',190000,62),
(27,1417,2,'Aura Flash',190000,62),
(27,1297,4,'Clear Mind',190000,62),
(27,1235,15,'Hydro Blast',100000,62),
(27,1235,16,'Hydro Blast',100000,62),
(27,1231,15,'Aura Flare',100000,62),
(27,1231,16,'Aura Flare',100000,62),
(27,1223,9,'Surrender To Earth',190000,62),
(27,1072,3,'Sleeping Cloud',190000,62),
(27,1174,9,'Frost Wall',100000,62),
(27,1174,10,'Frost Wall',100000,62),
(27,1169,8,'Curse Fear',190000,62),
(27,1164,13,'Curse: Weakness',190000,62),
(27,1056,6,'Cancellation',190000,62),
(27,1071,8,'Surrender To Water',190000,62),
(27,1069,29,'Sleep',100000,62),
(27,1069,30,'Sleep',100000,62),
(27,285,21,'Higher Mana Gain',190000,62),
(27,249,29,'Weapon Mastery',100000,62),
(27,249,30,'Weapon Mastery',100000,62),
(27,234,28,'Robe Mastery',100000,62),
(27,234,29,'Robe Mastery',100000,62),
(27,146,32,'Anti Magic',100000,62),
(27,146,33,'Anti Magic',100000,62),
(27,146,34,'Anti Magic',120000,64),
(27,146,35,'Anti Magic',120000,64),
(27,234,30,'Robe Mastery',120000,64),
(27,234,31,'Robe Mastery',120000,64),
(27,249,31,'Weapon Mastery',120000,64),
(27,249,32,'Weapon Mastery',120000,64),
(27,285,22,'Higher Mana Gain',240000,64),
(27,212,5,'Fast HP Recovery',240000,64),
(27,1069,31,'Sleep',120000,64),
(27,1069,32,'Sleep',120000,64),
(27,1071,9,'Surrender To Water',240000,64),
(27,1056,7,'Cancellation',240000,64),
(27,1164,14,'Curse: Weakness',240000,64),
(27,1169,9,'Curse Fear',240000,64),
(27,1174,11,'Frost Wall',120000,64),
(27,1174,12,'Frost Wall',120000,64),
(27,1183,3,'Freezing Shackle',240000,64),
(27,1223,10,'Surrender To Earth',240000,64),
(27,1231,17,'Aura Flare',120000,64),
(27,1231,18,'Aura Flare',120000,64),
(27,1235,17,'Hydro Blast',120000,64),
(27,1235,18,'Hydro Blast',120000,64),
(27,1237,12,'Ice Dagger',240000,64),
(27,1236,14,'Frost Bolt',240000,64),
(27,1265,9,'Solar Flare',240000,64),
(27,1275,9,'Aura Bolt',240000,64),
(27,1295,4,'Aqua Splash',240000,64),
(27,1295,5,'Aqua Splash',320000,66),
(27,1286,1,'Seed of Water',320000,66),
(27,1275,10,'Aura Bolt',320000,66),
(27,1265,10,'Solar Flare',320000,66),
(27,1236,15,'Frost Bolt',320000,66),
(27,1237,13,'Ice Dagger',320000,66),
(27,1417,3,'Aura Flash',320000,66),
(27,1235,19,'Hydro Blast',160000,66),
(27,1235,20,'Hydro Blast',160000,66),
(27,1231,19,'Aura Flare',160000,66),
(27,1231,20,'Aura Flare',160000,66),
(27,1223,11,'Surrender To Earth',320000,66),
(27,1072,4,'Sleeping Cloud',320000,66),
(27,1174,13,'Frost Wall',160000,66),
(27,1174,14,'Frost Wall',160000,66),
(27,1169,10,'Curse Fear',320000,66),
(27,1164,15,'Curse: Weakness',320000,66),
(27,1056,8,'Cancellation',320000,66),
(27,1071,10,'Surrender To Water',320000,66),
(27,1069,33,'Sleep',160000,66),
(27,1069,34,'Sleep',160000,66),
(27,213,7,'Boost Mana',320000,66),
(27,285,23,'Higher Mana Gain',320000,66),
(27,249,33,'Weapon Mastery',160000,66),
(27,249,34,'Weapon Mastery',160000,66),
(27,234,32,'Robe Mastery',160000,66),
(27,234,33,'Robe Mastery',160000,66),
(27,146,36,'Anti Magic',160000,66),
(27,146,37,'Anti Magic',160000,66),
(27,146,38,'Anti Magic',180000,68),
(27,146,39,'Anti Magic',180000,68),
(27,234,34,'Robe Mastery',180000,68),
(27,234,35,'Robe Mastery',180000,68),
(27,249,35,'Weapon Mastery',180000,68),
(27,249,36,'Weapon Mastery',180000,68),
(27,285,24,'Higher Mana Gain',370000,68),
(27,229,6,'Fast Mana Recovery',370000,68),
(27,1069,35,'Sleep',180000,68),
(27,1069,36,'Sleep',180000,68),
(27,1071,11,'Surrender To Water',370000,68),
(27,1056,9,'Cancellation',370000,68),
(27,1164,16,'Curse: Weakness',370000,68),
(27,1169,11,'Curse Fear',370000,68),
(27,1174,15,'Frost Wall',180000,68),
(27,1174,16,'Frost Wall',180000,68),
(27,1223,12,'Surrender To Earth',370000,68),
(27,1231,21,'Aura Flare',180000,68),
(27,1231,22,'Aura Flare',180000,68),
(27,1235,21,'Hydro Blast',180000,68),
(27,1235,22,'Hydro Blast',180000,68),
(27,1297,5,'Clear Mind',370000,68),
(27,1237,14,'Ice Dagger',370000,68),
(27,1236,16,'Frost Bolt',370000,68),
(27,1265,11,'Solar Flare',370000,68),
(27,1275,11,'Aura Bolt',370000,68),
(27,1288,1,'Aura Symphony',370000,68),
(27,1295,6,'Aqua Splash',370000,68),
(27,1295,7,'Aqua Splash',430000,70),
(27,1290,1,'Blizzard',430000,70),
(27,1275,12,'Aura Bolt',430000,70),
(27,1265,12,'Solar Flare',430000,70),
(27,1236,17,'Frost Bolt',430000,70),
(27,1237,15,'Ice Dagger',430000,70),
(27,1417,4,'Aura Flash',430000,70),
(27,1235,23,'Hydro Blast',210000,70),
(27,1235,24,'Hydro Blast',210000,70),
(27,1231,23,'Aura Flare',210000,70),
(27,1231,24,'Aura Flare',210000,70),
(27,1223,13,'Surrender To Earth',430000,70),
(27,1072,5,'Sleeping Cloud',430000,70),
(27,1174,17,'Frost Wall',210000,70),
(27,1174,18,'Frost Wall',210000,70),
(27,1169,12,'Curse Fear',430000,70),
(27,1164,17,'Curse: Weakness',430000,70),
(27,1056,10,'Cancellation',430000,70),
(27,1071,12,'Surrender To Water',430000,70),
(27,1069,37,'Sleep',210000,70),
(27,1069,38,'Sleep',210000,70),
(27,1047,4,'Mana Regeneration',430000,70),
(27,285,25,'Higher Mana Gain',430000,70),
(27,249,37,'Weapon Mastery',210000,70),
(27,249,38,'Weapon Mastery',210000,70),
(27,234,36,'Robe Mastery',210000,70),
(27,234,37,'Robe Mastery',210000,70),
(27,146,40,'Anti Magic',210000,70),
(27,146,41,'Anti Magic',210000,70),
(27,146,42,'Anti Magic',380000,72),
(27,146,43,'Anti Magic',380000,72),
(27,234,38,'Robe Mastery',380000,72),
(27,234,39,'Robe Mastery',380000,72),
(27,249,39,'Weapon Mastery',380000,72),
(27,249,40,'Weapon Mastery',380000,72),
(27,285,26,'Higher Mana Gain',750000,72),
(27,213,8,'Boost Mana',750000,72),
(27,1069,39,'Sleep',380000,72),
(27,1069,40,'Sleep',380000,72),
(27,1071,13,'Surrender To Water',750000,72),
(27,1056,11,'Cancellation',750000,72),
(27,1164,18,'Curse: Weakness',750000,72),
(27,1169,13,'Curse Fear',750000,72),
(27,1174,19,'Frost Wall',380000,72),
(27,1174,20,'Frost Wall',380000,72),
(27,1223,14,'Surrender To Earth',750000,72),
(27,1231,25,'Aura Flare',380000,72),
(27,1231,26,'Aura Flare',380000,72),
(27,1235,25,'Hydro Blast',380000,72),
(27,1235,26,'Hydro Blast',380000,72),
(27,1237,16,'Ice Dagger',750000,72),
(27,1236,18,'Frost Bolt',750000,72),
(27,1265,13,'Solar Flare',750000,72),
(27,1275,13,'Aura Bolt',750000,72),
(27,1293,1,'Elemental Symphony',750000,72),
(27,1295,8,'Aqua Splash',750000,72),
(27,1295,9,'Aqua Splash',1000000,74),
(27,1275,14,'Aura Bolt',1000000,74),
(27,1265,14,'Solar Flare',1000000,74),
(27,1236,19,'Frost Bolt',1000000,74),
(27,1237,17,'Ice Dagger',1000000,74),
(27,1417,5,'Aura Flash',1000000,74),
(27,1297,6,'Clear Mind',1000000,74),
(27,1235,27,'Hydro Blast',500000,74),
(27,1235,28,'Hydro Blast',500000,74),
(27,1231,27,'Aura Flare',500000,74),
(27,1231,28,'Aura Flare',500000,74),
(27,1223,15,'Surrender To Earth',1000000,74),
(27,1183,4,'Freezing Shackle',1000000,74),
(27,1174,21,'Frost Wall',500000,74),
(27,1174,22,'Frost Wall',500000,74),
(27,1169,14,'Curse Fear',1000000,74),
(27,1164,19,'Curse: Weakness',1000000,74),
(27,1056,12,'Cancellation',1000000,74),
(27,1071,14,'Surrender To Water',1000000,74),
(27,1069,41,'Sleep',500000,74),
(27,1069,42,'Sleep',500000,74),
(27,212,6,'Fast HP Recovery',1000000,74),
(27,229,7,'Fast Mana Recovery',1000000,74),
(27,285,27,'Higher Mana Gain',1000000,74),
(27,249,41,'Weapon Mastery',500000,74),
(27,249,42,'Weapon Mastery',500000,74),
(27,234,40,'Robe Mastery',500000,74),
(27,234,41,'Robe Mastery',500000,74),
(27,146,44,'Anti Magic',500000,74),
(27,146,45,'Anti Magic',500000,74),
(28,146,13,'Anti Magic',10000,40),
(28,146,14,'Anti Magic',10000,40),
(28,146,15,'Anti Magic',10000,40),
(28,234,9,'Robe Mastery',10000,40),
(28,234,10,'Robe Mastery',10000,40),
(28,234,11,'Robe Mastery',10000,40),
(28,249,10,'Weapon Mastery',10000,40),
(28,249,11,'Weapon Mastery',10000,40),
(28,249,12,'Weapon Mastery',10000,40),
(28,258,1,'Light Armor Mastery',10000,40),
(28,258,2,'Light Armor Mastery',10000,40),
(28,258,3,'Light Armor Mastery',10000,40),
(28,67,1,'Summon Life Cubic',30000,40),
(28,213,3,'Boost Mana',30000,40),
(28,228,2,'Fast Spell Casting',30000,40),
(28,1126,7,'Servitor Recharge',15000,40),
(28,1126,8,'Servitor Recharge',15000,40),
(28,1127,13,'Servitor Heal',10000,40),
(28,1127,14,'Servitor Heal',10000,40),
(28,1127,15,'Servitor Heal',10000,40),
(28,1140,1,'Servitor Physical Shield',30000,40),
(28,1206,6,'Wind Shackle',30000,40),
(28,1226,5,'Summon Boxer the Unicorn',30000,40),
(28,1227,5,'Summon Mirage the Unicorn',30000,40),
(28,1262,1,'Transfer Pain',30000,40),
(28,1277,1,'Summon Merrow the Unicorn',30000,40),
(28,1280,1,'Summon Aqua Cubic',30000,40),
(28,1329,1,'Mass Summon Aqua Cubic',30000,40),
(28,1300,1,'Servitor Cure',30000,40),
(28,1329,2,'Mass Summon Aqua Cubic',41000,44),
(28,1280,2,'Summon Aqua Cubic',41000,44),
(28,1277,2,'Summon Merrow the Unicorn',41000,44),
(28,1141,1,'Servitor Haste',41000,44),
(28,1227,6,'Summon Mirage the Unicorn',41000,44),
(28,1226,6,'Summon Boxer the Unicorn',41000,44),
(28,1206,7,'Wind Shackle',41000,44),
(28,1139,1,'Servitor Magic Shield',41000,44),
(28,229,3,'Fast Mana Recovery',41000,44),
(28,1127,16,'Servitor Heal',14000,44),
(28,1127,17,'Servitor Heal',14000,44),
(28,1127,18,'Servitor Heal',14000,44),
(28,1126,9,'Servitor Recharge',21000,44),
(28,1126,10,'Servitor Recharge',21000,44),
(28,143,1,'Cubic Mastery',41000,44),
(28,212,2,'Fast HP Recovery',41000,44),
(28,258,4,'Light Armor Mastery',14000,44),
(28,258,5,'Light Armor Mastery',14000,44),
(28,258,6,'Light Armor Mastery',14000,44),
(28,249,13,'Weapon Mastery',14000,44),
(28,249,14,'Weapon Mastery',14000,44),
(28,249,15,'Weapon Mastery',14000,44),
(28,234,12,'Robe Mastery',14000,44),
(28,234,13,'Robe Mastery',14000,44),
(28,234,14,'Robe Mastery',14000,44),
(28,146,16,'Anti Magic',14000,44),
(28,146,17,'Anti Magic',14000,44),
(28,146,18,'Anti Magic',14000,44),
(28,146,19,'Anti Magic',21000,48),
(28,146,20,'Anti Magic',21000,48),
(28,146,21,'Anti Magic',21000,48),
(28,234,15,'Robe Mastery',21000,48),
(28,234,16,'Robe Mastery',21000,48),
(28,234,17,'Robe Mastery',21000,48),
(28,249,16,'Weapon Mastery',21000,48),
(28,249,17,'Weapon Mastery',21000,48),
(28,249,18,'Weapon Mastery',21000,48),
(28,258,7,'Light Armor Mastery',21000,48),
(28,258,8,'Light Armor Mastery',21000,48),
(28,258,9,'Light Armor Mastery',21000,48),
(28,67,2,'Summon Life Cubic',63000,48),
(28,213,4,'Boost Mana',63000,48),
(28,1126,11,'Servitor Recharge',32000,48),
(28,1126,12,'Servitor Recharge',32000,48),
(28,1127,19,'Servitor Heal',21000,48),
(28,1127,20,'Servitor Heal',21000,48),
(28,1127,21,'Servitor Heal',21000,48),
(28,1140,2,'Servitor Physical Shield',63000,48),
(28,1206,8,'Wind Shackle',63000,48),
(28,1226,7,'Summon Boxer the Unicorn',63000,48),
(28,1227,7,'Summon Mirage the Unicorn',63000,48),
(28,1145,2,'Bright Servitor',63000,48),
(28,1262,2,'Transfer Pain',63000,48),
(28,1277,3,'Summon Merrow the Unicorn',63000,48),
(28,1280,3,'Summon Aqua Cubic',63000,48),
(28,1329,3,'Mass Summon Aqua Cubic',63000,48),
(28,1300,2,'Servitor Cure',63000,48),
(28,164,3,'Quick Recycle',63000,48),
(28,1299,1,'Servitor Empowerment',100000,52),
(28,1329,4,'Mass Summon Aqua Cubic',100000,52),
(28,1280,4,'Summon Aqua Cubic',100000,52),
(28,1277,4,'Summon Merrow the Unicorn',100000,52),
(28,1141,2,'Servitor Haste',100000,52),
(28,1227,8,'Summon Mirage the Unicorn',100000,52),
(28,1226,8,'Summon Boxer the Unicorn',100000,52),
(28,1206,9,'Wind Shackle',100000,52),
(28,1139,2,'Servitor Magic Shield',100000,52),
(28,229,4,'Fast Mana Recovery',100000,52),
(28,1127,22,'Servitor Heal',33000,52),
(28,1127,23,'Servitor Heal',33000,52),
(28,1127,24,'Servitor Heal',33000,52),
(28,1126,13,'Servitor Recharge',50000,52),
(28,1126,14,'Servitor Recharge',50000,52),
(28,67,3,'Summon Life Cubic',100000,52),
(28,212,3,'Fast HP Recovery',100000,52),
(28,258,10,'Light Armor Mastery',33000,52),
(28,258,11,'Light Armor Mastery',33000,52),
(28,258,12,'Light Armor Mastery',33000,52),
(28,249,19,'Weapon Mastery',33000,52),
(28,249,20,'Weapon Mastery',33000,52),
(28,249,21,'Weapon Mastery',33000,52),
(28,234,18,'Robe Mastery',33000,52),
(28,234,19,'Robe Mastery',33000,52),
(28,234,20,'Robe Mastery',33000,52),
(28,146,22,'Anti Magic',33000,52),
(28,146,23,'Anti Magic',33000,52),
(28,146,24,'Anti Magic',33000,52),
(28,146,25,'Anti Magic',32000,56),
(28,146,26,'Anti Magic',32000,56),
(28,146,27,'Anti Magic',32000,56),
(28,234,21,'Robe Mastery',32000,56),
(28,234,22,'Robe Mastery',32000,56),
(28,234,23,'Robe Mastery',32000,56),
(28,249,22,'Weapon Mastery',32000,56),
(28,249,23,'Weapon Mastery',32000,56),
(28,249,24,'Weapon Mastery',32000,56),
(28,258,13,'Light Armor Mastery',32000,56),
(28,258,14,'Light Armor Mastery',32000,56),
(28,258,15,'Light Armor Mastery',32000,56),
(28,213,5,'Boost Mana',95000,56),
(28,143,2,'Cubic Mastery',95000,56),
(28,228,3,'Fast Spell Casting',95000,56),
(28,1126,15,'Servitor Recharge',48000,56),
(28,1126,16,'Servitor Recharge',48000,56),
(28,1127,25,'Servitor Heal',32000,56),
(28,1127,26,'Servitor Heal',32000,56),
(28,1127,27,'Servitor Heal',32000,56),
(28,1140,3,'Servitor Physical Shield',95000,56),
(28,1206,10,'Wind Shackle',95000,56),
(28,1226,9,'Summon Boxer the Unicorn',95000,56),
(28,1227,9,'Summon Mirage the Unicorn',95000,56),
(28,1145,3,'Bright Servitor',95000,56),
(28,1262,3,'Transfer Pain',95000,56),
(28,1277,5,'Summon Merrow the Unicorn',95000,56),
(28,1280,5,'Summon Aqua Cubic',95000,56),
(28,1329,5,'Mass Summon Aqua Cubic',95000,56),
(28,1403,1,'Summon Friend',95000,56),
(28,1332,1,'Summon Unicorn Seraphim',95000,56),
(28,1380,1,'Betray',95000,56),
(28,1380,2,'Betray',147000,58),
(28,1332,2,'Summon Unicorn Seraphim',147000,58),
(28,1384,1,'Mass Surrender to Water',147000,58),
(28,1277,6,'Summon Merrow the Unicorn',147000,58),
(28,1262,4,'Transfer Pain',147000,58),
(28,1227,10,'Summon Mirage the Unicorn',147000,58),
(28,1226,10,'Summon Boxer the Unicorn',147000,58),
(28,1206,11,'Wind Shackle',147000,58),
(28,1127,28,'Servitor Heal',73000,58),
(28,1127,29,'Servitor Heal',73000,58),
(28,1126,17,'Servitor Recharge',73000,58),
(28,1126,18,'Servitor Recharge',73000,58),
(28,212,4,'Fast HP Recovery',147000,58),
(28,258,16,'Light Armor Mastery',73000,58),
(28,258,17,'Light Armor Mastery',73000,58),
(28,249,25,'Weapon Mastery',73000,58),
(28,249,26,'Weapon Mastery',73000,58),
(28,234,24,'Robe Mastery',73000,58),
(28,234,25,'Robe Mastery',73000,58),
(28,146,28,'Anti Magic',73000,58),
(28,146,29,'Anti Magic',73000,58),
(28,146,30,'Anti Magic',94000,60),
(28,146,31,'Anti Magic',94000,60),
(28,234,26,'Robe Mastery',94000,60),
(28,234,27,'Robe Mastery',94000,60),
(28,249,27,'Weapon Mastery',94000,60),
(28,249,28,'Weapon Mastery',94000,60),
(28,258,18,'Light Armor Mastery',94000,60),
(28,258,19,'Light Armor Mastery',94000,60),
(28,67,4,'Summon Life Cubic',188000,60),
(28,213,6,'Boost Mana',188000,60),
(28,1126,19,'Servitor Recharge',94000,60),
(28,1126,20,'Servitor Recharge',94000,60),
(28,1127,30,'Servitor Heal',94000,60),
(28,1127,31,'Servitor Heal',94000,60),
(28,1206,12,'Wind Shackle',188000,60),
(28,229,5,'Fast Mana Recovery',188000,60),
(28,1226,11,'Summon Boxer the Unicorn',188000,60),
(28,1227,11,'Summon Mirage the Unicorn',188000,60),
(28,1277,7,'Summon Merrow the Unicorn',188000,60),
(28,1300,3,'Servitor Cure',188000,60),
(28,1332,3,'Summon Unicorn Seraphim',188000,60),
(28,1380,3,'Betray',188000,60),
(28,1380,4,'Betray',250000,62),
(28,1332,4,'Summon Unicorn Seraphim',250000,62),
(28,1301,1,'Servitor Blessing',250000,62),
(28,1384,2,'Mass Surrender to Water',250000,62),
(28,1277,8,'Summon Merrow the Unicorn',250000,62),
(28,1329,6,'Mass Summon Aqua Cubic',250000,62),
(28,1280,6,'Summon Aqua Cubic',250000,62),
(28,1227,12,'Summon Mirage the Unicorn',250000,62),
(28,1226,12,'Summon Boxer the Unicorn',250000,62),
(28,1206,13,'Wind Shackle',250000,62),
(28,1127,32,'Servitor Heal',130000,62),
(28,1127,33,'Servitor Heal',130000,62),
(28,1126,21,'Servitor Recharge',130000,62),
(28,1126,22,'Servitor Recharge',130000,62),
(28,258,20,'Light Armor Mastery',130000,62),
(28,258,21,'Light Armor Mastery',130000,62),
(28,249,29,'Weapon Mastery',130000,62),
(28,249,30,'Weapon Mastery',130000,62),
(28,234,28,'Robe Mastery',130000,62),
(28,234,29,'Robe Mastery',130000,62),
(28,146,32,'Anti Magic',130000,62),
(28,146,33,'Anti Magic',130000,62),
(28,146,34,'Anti Magic',170000,64),
(28,146,35,'Anti Magic',170000,64),
(28,234,30,'Robe Mastery',170000,64),
(28,234,31,'Robe Mastery',170000,64),
(28,249,31,'Weapon Mastery',170000,64),
(28,249,32,'Weapon Mastery',170000,64),
(28,258,22,'Light Armor Mastery',170000,64),
(28,258,23,'Light Armor Mastery',170000,64),
(28,1126,23,'Servitor Recharge',170000,64),
(28,1126,24,'Servitor Recharge',170000,64),
(28,67,5,'Summon Life Cubic',340000,64),
(28,212,5,'Fast HP Recovery',340000,64),
(28,1127,34,'Servitor Heal',170000,64),
(28,1127,35,'Servitor Heal',170000,64),
(28,1206,14,'Wind Shackle',340000,64),
(28,1226,13,'Summon Boxer the Unicorn',340000,64),
(28,1227,13,'Summon Mirage the Unicorn',340000,64),
(28,1277,9,'Summon Merrow the Unicorn',340000,64),
(28,1332,5,'Summon Unicorn Seraphim',340000,64),
(28,1380,5,'Betray',340000,64),
(28,1380,6,'Betray',440000,66),
(28,1332,6,'Summon Unicorn Seraphim',440000,66),
(28,1384,3,'Mass Surrender to Water',440000,66),
(28,1277,10,'Summon Merrow the Unicorn',440000,66),
(28,1280,7,'Summon Aqua Cubic',440000,66),
(28,1329,7,'Mass Summon Aqua Cubic',440000,66),
(28,1227,14,'Summon Mirage the Unicorn',440000,66),
(28,1226,14,'Summon Boxer the Unicorn',440000,66),
(28,1206,15,'Wind Shackle',440000,66),
(28,1127,36,'Servitor Heal',220000,66),
(28,1127,37,'Servitor Heal',220000,66),
(28,213,7,'Boost Mana',440000,66),
(28,1126,25,'Servitor Recharge',220000,66),
(28,1126,26,'Servitor Recharge',220000,66),
(28,258,24,'Light Armor Mastery',220000,66),
(28,258,25,'Light Armor Mastery',220000,66),
(28,249,33,'Weapon Mastery',220000,66),
(28,249,34,'Weapon Mastery',220000,66),
(28,234,32,'Robe Mastery',220000,66),
(28,234,33,'Robe Mastery',220000,66),
(28,146,36,'Anti Magic',220000,66),
(28,146,37,'Anti Magic',220000,66),
(28,146,38,'Anti Magic',280000,68),
(28,146,39,'Anti Magic',280000,68),
(28,234,34,'Robe Mastery',280000,68),
(28,234,35,'Robe Mastery',280000,68),
(28,249,35,'Weapon Mastery',280000,68),
(28,249,36,'Weapon Mastery',280000,68),
(28,258,26,'Light Armor Mastery',280000,68),
(28,258,27,'Light Armor Mastery',280000,68),
(28,1126,27,'Servitor Recharge',280000,68),
(28,1126,28,'Servitor Recharge',280000,68),
(28,67,6,'Summon Life Cubic',550000,68),
(28,1127,38,'Servitor Heal',280000,68),
(28,1127,39,'Servitor Heal',280000,68),
(28,1206,16,'Wind Shackle',550000,68),
(28,229,6,'Fast Mana Recovery',550000,68),
(28,1226,15,'Summon Boxer the Unicorn',550000,68),
(28,1227,15,'Summon Mirage the Unicorn',550000,68),
(28,1277,11,'Summon Merrow the Unicorn',550000,68),
(28,1332,7,'Summon Unicorn Seraphim',550000,68),
(28,1380,7,'Betray',550000,68),
(28,1380,8,'Betray',550000,70),
(28,1332,8,'Summon Unicorn Seraphim',550000,70),
(28,1384,4,'Mass Surrender to Water',550000,70),
(28,1299,2,'Servitor Empowerment',550000,70),
(28,1277,12,'Summon Merrow the Unicorn',550000,70),
(28,1262,5,'Transfer Pain',550000,70),
(28,1329,8,'Mass Summon Aqua Cubic',550000,70),
(28,1280,8,'Summon Aqua Cubic',550000,70),
(28,1227,16,'Summon Mirage the Unicorn',550000,70),
(28,1226,16,'Summon Boxer the Unicorn',550000,70),
(28,1206,17,'Wind Shackle',550000,70),
(28,1127,40,'Servitor Heal',280000,70),
(28,1127,41,'Servitor Heal',280000,70),
(28,1126,29,'Servitor Recharge',280000,70),
(28,1126,30,'Servitor Recharge',280000,70),
(28,258,28,'Light Armor Mastery',280000,70),
(28,258,29,'Light Armor Mastery',280000,70),
(28,249,37,'Weapon Mastery',280000,70),
(28,249,38,'Weapon Mastery',280000,70),
(28,234,36,'Robe Mastery',280000,70),
(28,234,37,'Robe Mastery',280000,70),
(28,146,40,'Anti Magic',280000,70),
(28,146,41,'Anti Magic',280000,70),
(28,146,42,'Anti Magic',540000,72),
(28,146,43,'Anti Magic',540000,72),
(28,234,38,'Robe Mastery',540000,72),
(28,234,39,'Robe Mastery',540000,72),
(28,249,39,'Weapon Mastery',540000,72),
(28,249,40,'Weapon Mastery',540000,72),
(28,258,30,'Light Armor Mastery',540000,72),
(28,258,31,'Light Armor Mastery',540000,72),
(28,1126,31,'Servitor Recharge',540000,72),
(28,1126,32,'Servitor Recharge',540000,72),
(28,67,7,'Summon Life Cubic',1070000,72),
(28,213,8,'Boost Mana',1070000,72),
(28,1127,42,'Servitor Heal',540000,72),
(28,1127,43,'Servitor Heal',540000,72),
(28,1206,18,'Wind Shackle',1070000,72),
(28,1226,17,'Summon Boxer the Unicorn',1070000,72),
(28,1227,17,'Summon Mirage the Unicorn',1070000,72),
(28,1277,13,'Summon Merrow the Unicorn',1070000,72),
(28,1332,9,'Summon Unicorn Seraphim',1070000,72),
(28,1380,9,'Betray',1070000,72),
(28,1380,10,'Betray',1350000,74),
(28,1332,10,'Summon Unicorn Seraphim',1350000,74),
(28,1384,5,'Mass Surrender to Water',1350000,74),
(28,1277,14,'Summon Merrow the Unicorn',1350000,74),
(28,1280,9,'Summon Aqua Cubic',1350000,74),
(28,1329,9,'Mass Summon Aqua Cubic',1350000,74),
(28,1227,18,'Summon Mirage the Unicorn',1350000,74),
(28,1226,18,'Summon Boxer the Unicorn',1350000,74),
(28,1206,19,'Wind Shackle',1350000,74),
(28,229,7,'Fast Mana Recovery',1350000,74),
(28,1127,44,'Servitor Heal',680000,74),
(28,1127,45,'Servitor Heal',680000,74),
(28,212,6,'Fast HP Recovery',1350000,74),
(28,1126,33,'Servitor Recharge',680000,74),
(28,1126,34,'Servitor Recharge',680000,74),
(28,258,32,'Light Armor Mastery',680000,74),
(28,258,33,'Light Armor Mastery',680000,74),
(28,249,41,'Weapon Mastery',680000,74),
(28,249,42,'Weapon Mastery',680000,74),
(28,234,40,'Robe Mastery',680000,74),
(28,234,41,'Robe Mastery',680000,74),
(28,146,44,'Anti Magic',680000,74),
(28,146,45,'Anti Magic',680000,74),
(29,146,5,'Anti Magic',1600,20),
(29,146,6,'Anti Magic',1600,20),
(29,235,1,'Robe Mastery',1600,20),
(29,235,2,'Robe Mastery',1600,20),
(29,236,1,'Light Armor Mastery',1600,20),
(29,236,2,'Light Armor Mastery',1600,20),
(29,164,1,'Quick Recycle',3300,20),
(29,213,1,'Boost Mana',3300,20),
(29,249,3,'Weapon Mastery',3300,20),
(29,1011,7,'Heal',1100,20),
(29,1011,8,'Heal',1100,20),
(29,1011,9,'Heal',1100,20),
(29,1015,4,'Battle Heal',1100,20),
(29,1015,5,'Battle Heal',1100,20),
(29,1015,6,'Battle Heal',1100,20),
(29,1016,1,'Resurrection',3300,20),
(29,1027,4,'Group Heal',1100,20),
(29,1027,5,'Group Heal',1100,20),
(29,1027,6,'Group Heal',1100,20),
(29,1031,1,'Disrupt Undead',1600,20),
(29,1031,2,'Disrupt Undead',1600,20),
(29,1068,2,'Might',3300,20),
(29,1073,1,'Kiss of Eva',3300,20),
(29,1078,1,'Concentration',3300,20),
(29,1204,1,'Wind Walk',3300,20),
(29,1206,2,'Wind Shackle',3300,20),
(29,1206,3,'Wind Shackle',6500,25),
(29,1035,1,'Mental Shield',6500,25),
(29,1040,2,'Shield',6500,25),
(29,1043,1,'Holy Weapon',6500,25),
(29,1087,1,'Agility',6500,25),
(29,1201,1,'Dryad Root',2200,25),
(29,1201,2,'Dryad Root',2200,25),
(29,1201,3,'Dryad Root',2200,25),
(29,1069,1,'Sleep',2200,25),
(29,1069,2,'Sleep',2200,25),
(29,1069,3,'Sleep',2200,25),
(29,1031,3,'Disrupt Undead',3200,25),
(29,1031,4,'Disrupt Undead',3200,25),
(29,1027,7,'Group Heal',2200,25),
(29,1027,8,'Group Heal',2200,25),
(29,1027,9,'Group Heal',2200,25),
(29,228,1,'Fast Spell Casting',6500,25),
(29,229,1,'Fast Mana Recovery',6500,25),
(29,1015,7,'Battle Heal',2200,25),
(29,1015,8,'Battle Heal',2200,25),
(29,1015,9,'Battle Heal',2200,25),
(29,1011,10,'Heal',2200,25),
(29,1011,11,'Heal',2200,25),
(29,1011,12,'Heal',2200,25),
(29,249,4,'Weapon Mastery',3200,25),
(29,249,5,'Weapon Mastery',3200,25),
(29,236,3,'Light Armor Mastery',3200,25),
(29,236,4,'Light Armor Mastery',3200,25),
(29,235,3,'Robe Mastery',3200,25),
(29,235,4,'Robe Mastery',3200,25),
(29,146,7,'Anti Magic',3200,25),
(29,146,8,'Anti Magic',3200,25),
(29,146,9,'Anti Magic',6200,30),
(29,146,10,'Anti Magic',6200,30),
(29,235,5,'Robe Mastery',6200,30),
(29,235,6,'Robe Mastery',6200,30),
(29,236,5,'Light Armor Mastery',6200,30),
(29,236,6,'Light Armor Mastery',6200,30),
(29,249,6,'Weapon Mastery',6200,30),
(29,249,7,'Weapon Mastery',6200,30),
(29,213,2,'Boost Mana',12000,30),
(29,164,2,'Quick Recycle',12000,30),
(29,1011,13,'Heal',4100,30),
(29,1011,14,'Heal',4100,30),
(29,1011,15,'Heal',4100,30),
(29,1015,10,'Battle Heal',4100,30),
(29,1015,11,'Battle Heal',4100,30),
(29,1015,12,'Battle Heal',4100,30),
(29,1016,2,'Resurrection',12000,30),
(29,1013,1,'Recharge',6200,30),
(29,1013,2,'Recharge',6200,30),
(29,1027,10,'Group Heal',4100,30),
(29,1027,11,'Group Heal',4100,30),
(29,1027,12,'Group Heal',4100,30),
(29,1031,5,'Disrupt Undead',6200,30),
(29,1031,6,'Disrupt Undead',6200,30),
(29,1069,4,'Sleep',4100,30),
(29,1069,5,'Sleep',4100,30),
(29,1069,6,'Sleep',4100,30),
(29,1201,4,'Dryad Root',4100,30),
(29,1201,5,'Dryad Root',4100,30),
(29,1201,6,'Dryad Root',4100,30),
(29,1204,2,'Wind Walk',12000,30),
(29,1078,2,'Concentration',12000,30),
(29,1206,4,'Wind Shackle',12000,30),
(29,1206,5,'Wind Shackle',21000,35),
(29,1257,1,'Decrease Weight',21000,35),
(29,1044,1,'Regeneration',21000,35),
(29,1201,7,'Dryad Root',6900,35),
(29,1201,8,'Dryad Root',6900,35),
(29,1201,9,'Dryad Root',6900,35),
(29,1069,7,'Sleep',6900,35),
(29,1069,8,'Sleep',6900,35),
(29,1069,9,'Sleep',6900,35),
(29,1031,7,'Disrupt Undead',10000,35),
(29,1031,8,'Disrupt Undead',10000,35),
(29,1033,1,'Resist Poison',21000,35),
(29,1027,13,'Group Heal',6900,35),
(29,1027,14,'Group Heal',6900,35),
(29,1027,15,'Group Heal',6900,35),
(29,1013,3,'Recharge',10000,35),
(29,1013,4,'Recharge',10000,35),
(29,229,2,'Fast Mana Recovery',21000,35),
(29,1015,13,'Battle Heal',6900,35),
(29,1015,14,'Battle Heal',6900,35),
(29,1015,15,'Battle Heal',6900,35),
(29,1011,16,'Heal',6900,35),
(29,1011,17,'Heal',6900,35),
(29,1011,18,'Heal',6900,35),
(29,1012,2,'Cure Poison',21000,35),
(29,212,1,'Fast HP Recovery',21000,35),
(29,249,8,'Weapon Mastery',10000,35),
(29,249,9,'Weapon Mastery',10000,35),
(29,236,7,'Light Armor Mastery',10000,35),
(29,236,8,'Light Armor Mastery',10000,35),
(29,235,7,'Robe Mastery',10000,35),
(29,235,8,'Robe Mastery',10000,35),
(29,146,11,'Anti Magic',10000,35),
(29,146,12,'Anti Magic',10000,35),
(30,146,13,'Anti Magic',11000,40),
(30,146,14,'Anti Magic',11000,40),
(30,146,15,'Anti Magic',11000,40),
(30,235,9,'Robe Mastery',11000,40),
(30,235,10,'Robe Mastery',11000,40),
(30,235,11,'Robe Mastery',11000,40),
(30,236,9,'Light Armor Mastery',11000,40),
(30,236,10,'Light Armor Mastery',11000,40),
(30,236,11,'Light Armor Mastery',11000,40),
(30,249,10,'Weapon Mastery',11000,40),
(30,249,11,'Weapon Mastery',11000,40),
(30,249,12,'Weapon Mastery',11000,40),
(30,213,3,'Boost Mana',34000,40),
(30,228,2,'Fast Spell Casting',34000,40),
(30,1013,5,'Recharge',17000,40),
(30,1013,6,'Recharge',17000,40),
(30,1028,1,'Might of Heaven',17000,40),
(30,1028,2,'Might of Heaven',17000,40),
(30,1068,3,'Might',34000,40),
(30,1069,10,'Sleep',11000,40),
(30,1069,11,'Sleep',11000,40),
(30,1069,12,'Sleep',11000,40),
(30,1016,3,'Resurrection',34000,40),
(30,1033,2,'Resist Poison',34000,40),
(30,1035,2,'Mental Shield',34000,40),
(30,1206,6,'Wind Shackle',34000,40),
(30,1243,1,'Bless Shield',34000,40),
(30,1259,1,'Resist Shock',34000,40),
(30,1257,2,'Decrease Weight',39000,44),
(30,1273,1,'Serenade of Eva',39000,44),
(30,1087,2,'Agility',39000,44),
(30,1206,7,'Wind Shackle',39000,44),
(30,1033,3,'Resist Poison',39000,44),
(30,1040,3,'Shield',39000,44),
(30,1050,1,'Return',39000,44),
(30,1078,3,'Concentration',39000,44),
(30,1069,13,'Sleep',13000,44),
(30,1069,14,'Sleep',13000,44),
(30,1069,15,'Sleep',13000,44),
(30,1028,3,'Might of Heaven',19000,44),
(30,1028,4,'Might of Heaven',19000,44),
(30,1013,7,'Recharge',19000,44),
(30,1013,8,'Recharge',19000,44),
(30,229,3,'Fast Mana Recovery',39000,44),
(30,212,2,'Fast HP Recovery',39000,44),
(30,249,13,'Weapon Mastery',13000,44),
(30,249,14,'Weapon Mastery',13000,44),
(30,249,15,'Weapon Mastery',13000,44),
(30,236,12,'Light Armor Mastery',13000,44),
(30,236,13,'Light Armor Mastery',13000,44),
(30,236,14,'Light Armor Mastery',13000,44),
(30,235,12,'Robe Mastery',13000,44),
(30,235,13,'Robe Mastery',13000,44),
(30,235,14,'Robe Mastery',13000,44),
(30,146,16,'Anti Magic',13000,44),
(30,146,17,'Anti Magic',13000,44),
(30,146,18,'Anti Magic',13000,44),
(30,1521,1,'Inquisitor',117000,44),
(30,1219,1,'Greater Group Heal',21000,48),
(30,1219,2,'Greater Group Heal',21000,48),
(30,1219,3,'Greater Group Heal',21000,48),
(30,146,19,'Anti Magic',21000,48),
(30,146,20,'Anti Magic',21000,48),
(30,146,21,'Anti Magic',21000,48),
(30,235,15,'Robe Mastery',21000,48),
(30,235,16,'Robe Mastery',21000,48),
(30,235,17,'Robe Mastery',21000,48),
(30,236,15,'Light Armor Mastery',21000,48),
(30,236,16,'Light Armor Mastery',21000,48),
(30,236,17,'Light Armor Mastery',21000,48),
(30,249,16,'Weapon Mastery',21000,48),
(30,249,17,'Weapon Mastery',21000,48),
(30,249,18,'Weapon Mastery',21000,48),
(30,213,4,'Boost Mana',63000,48),
(30,164,3,'Quick Recycle',63000,48),
(30,1013,9,'Recharge',21000,48),
(30,1013,10,'Recharge',21000,48),
(30,1028,5,'Might of Heaven',21000,48),
(30,1028,6,'Might of Heaven',21000,48),
(30,1020,1,'Vitalize',21000,48),
(30,1020,2,'Vitalize',21000,48),
(30,1020,3,'Vitalize',21000,48),
(30,1069,16,'Sleep',21000,48),
(30,1069,17,'Sleep',21000,48),
(30,1069,18,'Sleep',21000,48),
(30,1044,2,'Regeneration',63000,48),
(30,1035,3,'Mental Shield',63000,48),
(30,1016,4,'Resurrection',63000,48),
(30,1217,1,'Greater Heal',21000,48),
(30,1217,2,'Greater Heal',21000,48),
(30,1217,3,'Greater Heal',21000,48),
(30,1206,8,'Wind Shackle',63000,48),
(30,1255,1,'Party Recall',63000,48),
(30,1243,2,'Bless Shield',63000,48),
(30,1273,2,'Serenade of Eva',63000,48),
(30,1219,4,'Greater Group Heal',26000,52),
(30,1219,5,'Greater Group Heal',26000,52),
(30,1219,6,'Greater Group Heal',26000,52),
(30,1273,3,'Serenade of Eva',77000,52),
(30,1257,3,'Decrease Weight',77000,52),
(30,1259,2,'Resist Shock',77000,52),
(30,1087,3,'Agility',77000,52),
(30,1206,9,'Wind Shackle',77000,52),
(30,1073,2,'Kiss of Eva',77000,52),
(30,1217,4,'Greater Heal',26000,52),
(30,1217,5,'Greater Heal',26000,52),
(30,1217,6,'Greater Heal',26000,52),
(30,1078,4,'Concentration',77000,52),
(30,1069,19,'Sleep',26000,52),
(30,1069,20,'Sleep',26000,52),
(30,1069,21,'Sleep',26000,52),
(30,1020,4,'Vitalize',26000,52),
(30,1020,5,'Vitalize',26000,52),
(30,1020,6,'Vitalize',26000,52),
(30,1028,7,'Might of Heaven',38000,52),
(30,1028,8,'Might of Heaven',38000,52),
(30,1013,11,'Recharge',38000,52),
(30,1013,12,'Recharge',38000,52),
(30,229,4,'Fast Mana Recovery',77000,52),
(30,212,3,'Fast HP Recovery',77000,52),
(30,249,19,'Weapon Mastery',26000,52),
(30,249,20,'Weapon Mastery',26000,52),
(30,249,21,'Weapon Mastery',26000,52),
(30,236,18,'Light Armor Mastery',26000,52),
(30,236,19,'Light Armor Mastery',26000,52),
(30,236,20,'Light Armor Mastery',26000,52),
(30,235,18,'Robe Mastery',26000,52),
(30,235,19,'Robe Mastery',26000,52),
(30,235,20,'Robe Mastery',26000,52),
(30,146,22,'Anti Magic',26000,52),
(30,146,23,'Anti Magic',26000,52),
(30,146,24,'Anti Magic',26000,52),
(30,1219,7,'Greater Group Heal',32000,56),
(30,1219,8,'Greater Group Heal',32000,56),
(30,1219,9,'Greater Group Heal',32000,56),
(30,146,25,'Anti Magic',32000,56),
(30,146,26,'Anti Magic',32000,56),
(30,146,27,'Anti Magic',32000,56),
(30,235,21,'Robe Mastery',32000,56),
(30,235,22,'Robe Mastery',32000,56),
(30,235,23,'Robe Mastery',32000,56),
(30,236,21,'Light Armor Mastery',32000,56),
(30,236,22,'Light Armor Mastery',32000,56),
(30,236,23,'Light Armor Mastery',32000,56),
(30,249,22,'Weapon Mastery',32000,56),
(30,249,23,'Weapon Mastery',32000,56),
(30,249,24,'Weapon Mastery',32000,56),
(30,213,5,'Boost Mana',95000,56),
(30,228,3,'Fast Spell Casting',95000,56),
(30,1013,13,'Recharge',47000,56),
(30,1013,14,'Recharge',47000,56),
(30,1028,9,'Might of Heaven',47000,56),
(30,1028,10,'Might of Heaven',47000,56),
(30,1020,7,'Vitalize',32000,56),
(30,1020,8,'Vitalize',32000,56),
(30,1020,9,'Vitalize',32000,56),
(30,1069,22,'Sleep',32000,56),
(30,1069,23,'Sleep',32000,56),
(30,1069,24,'Sleep',32000,56),
(30,1044,3,'Regeneration',95000,56),
(30,1050,2,'Return',95000,56),
(30,1016,5,'Resurrection',95000,56),
(30,1035,4,'Mental Shield',95000,56),
(30,1217,7,'Greater Heal',32000,56),
(30,1217,8,'Greater Heal',32000,56),
(30,1217,9,'Greater Heal',32000,56),
(30,1401,1,'Major Heal',95000,56),
(30,1430,1,'Invocation',95000,56),
(30,1206,10,'Wind Shackle',95000,56),
(30,1255,2,'Party Recall',95000,56),
(30,1243,3,'Bless Shield',95000,56),
(30,1273,4,'Serenade of Eva',95000,56),
(30,1394,1,'Trance',95000,56),
(30,1395,1,'Erase',95000,56),
(30,1398,1,'Mana Burn',95000,56),
(30,1400,1,'Turn Undead',95000,56),
(30,1219,10,'Greater Group Heal',33000,58),
(30,1219,11,'Greater Group Heal',33000,58),
(30,1219,12,'Greater Group Heal',33000,58),
(30,1400,2,'Turn Undead',100000,58),
(30,1398,2,'Mana Burn',100000,58),
(30,1395,2,'Erase',100000,58),
(30,1394,2,'Trance',100000,58),
(30,1273,5,'Serenade of Eva',100000,58),
(30,1206,11,'Wind Shackle',100000,58),
(30,1304,1,'Advanced Block',100000,58),
(30,1393,1,'Unholy Resistance',100000,58),
(30,1401,2,'Major Heal',100000,58),
(30,1397,1,'Clarity',100000,58),
(30,1217,10,'Greater Heal',33000,58),
(30,1217,11,'Greater Heal',33000,58),
(30,1217,12,'Greater Heal',33000,58),
(30,1069,25,'Sleep',50000,58),
(30,1069,26,'Sleep',50000,58),
(30,1020,10,'Vitalize',50000,58),
(30,1020,11,'Vitalize',50000,58),
(30,1028,11,'Might of Heaven',100000,58),
(30,1013,15,'Recharge',50000,58),
(30,1013,16,'Recharge',50000,58),
(30,1012,3,'Cure Poison',100000,58),
(30,212,4,'Fast HP Recovery',100000,58),
(30,249,25,'Weapon Mastery',50000,58),
(30,249,26,'Weapon Mastery',50000,58),
(30,236,24,'Light Armor Mastery',50000,58),
(30,236,25,'Light Armor Mastery',50000,58),
(30,235,24,'Robe Mastery',50000,58),
(30,235,25,'Robe Mastery',50000,58),
(30,146,28,'Anti Magic',50000,58),
(30,146,29,'Anti Magic',50000,58),
(30,1219,13,'Greater Group Heal',50000,60),
(30,1219,14,'Greater Group Heal',50000,60),
(30,1219,15,'Greater Group Heal',50000,60),
(30,146,30,'Anti Magic',70000,60),
(30,146,31,'Anti Magic',70000,60),
(30,235,26,'Robe Mastery',70000,60),
(30,235,27,'Robe Mastery',70000,60),
(30,236,26,'Light Armor Mastery',70000,60),
(30,236,27,'Light Armor Mastery',70000,60),
(30,249,27,'Weapon Mastery',70000,60),
(30,249,28,'Weapon Mastery',70000,60),
(30,213,6,'Boost Mana',140000,60),
(30,229,5,'Fast Mana Recovery',140000,60),
(30,1013,17,'Recharge',70000,60),
(30,1013,18,'Recharge',70000,60),
(30,1028,12,'Might of Heaven',140000,60),
(30,1020,12,'Vitalize',70000,60),
(30,1020,13,'Vitalize',70000,60),
(30,1069,27,'Sleep',70000,60),
(30,1069,28,'Sleep',70000,60),
(30,1217,13,'Greater Heal',50000,60),
(30,1217,14,'Greater Heal',50000,60),
(30,1217,15,'Greater Heal',50000,60),
(30,1078,5,'Concentration',140000,60),
(30,1401,3,'Major Heal',140000,60),
(30,1430,2,'Invocation',140000,60),
(30,1206,12,'Wind Shackle',140000,60),
(30,1273,6,'Serenade of Eva',140000,60),
(30,1394,3,'Trance',140000,60),
(30,1395,3,'Erase',140000,60),
(30,1398,3,'Mana Burn',140000,60),
(30,1400,3,'Turn Undead',140000,60),
(30,1219,16,'Greater Group Heal',110000,62),
(30,1219,17,'Greater Group Heal',110000,62),
(30,1400,4,'Turn Undead',210000,62),
(30,1398,4,'Mana Burn',210000,62),
(30,1395,4,'Erase',210000,62),
(30,1394,4,'Trance',210000,62),
(30,1273,7,'Serenade of Eva',210000,62),
(30,1303,1,'Wild Magic',210000,62),
(30,1206,13,'Wind Shackle',210000,62),
(30,1243,4,'Bless Shield',210000,62),
(30,1401,4,'Major Heal',210000,62),
(30,1217,16,'Greater Heal',110000,62),
(30,1217,17,'Greater Heal',110000,62),
(30,1069,29,'Sleep',110000,62),
(30,1069,30,'Sleep',110000,62),
(30,1020,14,'Vitalize',110000,62),
(30,1020,15,'Vitalize',110000,62),
(30,1028,13,'Might of Heaven',210000,62),
(30,1013,19,'Recharge',110000,62),
(30,1013,20,'Recharge',110000,62),
(30,249,29,'Weapon Mastery',110000,62),
(30,249,30,'Weapon Mastery',110000,62),
(30,236,28,'Light Armor Mastery',110000,62),
(30,236,29,'Light Armor Mastery',110000,62),
(30,235,28,'Robe Mastery',110000,62),
(30,235,29,'Robe Mastery',110000,62),
(30,146,32,'Anti Magic',110000,62),
(30,146,33,'Anti Magic',110000,62),
(30,1219,18,'Greater Group Heal',110000,64),
(30,1219,19,'Greater Group Heal',110000,64),
(30,146,34,'Anti Magic',110000,64),
(30,146,35,'Anti Magic',110000,64),
(30,235,30,'Robe Mastery',110000,64),
(30,235,31,'Robe Mastery',110000,64),
(30,236,30,'Light Armor Mastery',110000,64),
(30,236,31,'Light Armor Mastery',110000,64),
(30,249,31,'Weapon Mastery',110000,64),
(30,249,32,'Weapon Mastery',110000,64),
(30,1013,21,'Recharge',110000,64),
(30,1013,22,'Recharge',110000,64),
(30,212,5,'Fast HP Recovery',230000,64),
(30,1028,14,'Might of Heaven',230000,64),
(30,1020,16,'Vitalize',110000,64),
(30,1020,17,'Vitalize',110000,64),
(30,1069,31,'Sleep',110000,64),
(30,1069,32,'Sleep',110000,64),
(30,1217,18,'Greater Heal',110000,64),
(30,1217,19,'Greater Heal',110000,64),
(30,1016,6,'Resurrection',230000,64),
(30,1401,5,'Major Heal',230000,64),
(30,1430,3,'Invocation',230000,64),
(30,1206,14,'Wind Shackle',230000,64),
(30,1259,3,'Resist Shock',230000,64),
(30,1273,8,'Serenade of Eva',230000,64),
(30,1394,5,'Trance',230000,64),
(30,1395,5,'Erase',230000,64),
(30,1398,5,'Mana Burn',230000,64),
(30,1400,5,'Turn Undead',230000,64),
(30,1219,20,'Greater Group Heal',160000,66),
(30,1219,21,'Greater Group Heal',160000,66),
(30,1400,6,'Turn Undead',320000,66),
(30,1398,6,'Mana Burn',320000,66),
(30,1395,6,'Erase',320000,66),
(30,1394,6,'Trance',320000,66),
(30,1273,9,'Serenade of Eva',320000,66),
(30,1206,15,'Wind Shackle',320000,66),
(30,1243,5,'Bless Shield',320000,66),
(30,1393,2,'Unholy Resistance',320000,66),
(30,1304,2,'Advanced Block',320000,66),
(30,1401,6,'Major Heal',320000,66),
(30,1397,2,'Clarity',320000,66),
(30,1217,20,'Greater Heal',160000,66),
(30,1217,21,'Greater Heal',160000,66),
(30,1069,33,'Sleep',160000,66),
(30,1069,34,'Sleep',160000,66),
(30,1020,18,'Vitalize',160000,66),
(30,1020,19,'Vitalize',160000,66),
(30,1028,15,'Might of Heaven',320000,66),
(30,213,7,'Boost Mana',320000,66),
(30,1013,23,'Recharge',160000,66),
(30,1013,24,'Recharge',160000,66),
(30,249,33,'Weapon Mastery',160000,66),
(30,249,34,'Weapon Mastery',160000,66),
(30,236,32,'Light Armor Mastery',160000,66),
(30,236,33,'Light Armor Mastery',160000,66),
(30,235,32,'Robe Mastery',160000,66),
(30,235,33,'Robe Mastery',160000,66),
(30,146,36,'Anti Magic',160000,66),
(30,146,37,'Anti Magic',160000,66),
(30,1219,22,'Greater Group Heal',190000,68),
(30,1219,23,'Greater Group Heal',190000,68),
(30,146,38,'Anti Magic',190000,68),
(30,146,39,'Anti Magic',190000,68),
(30,235,34,'Robe Mastery',190000,68),
(30,235,35,'Robe Mastery',190000,68),
(30,236,34,'Light Armor Mastery',190000,68),
(30,236,35,'Light Armor Mastery',190000,68),
(30,249,35,'Weapon Mastery',190000,68),
(30,249,36,'Weapon Mastery',190000,68),
(30,1013,25,'Recharge',190000,68),
(30,1013,26,'Recharge',190000,68),
(30,229,6,'Fast Mana Recovery',390000,68),
(30,1028,16,'Might of Heaven',390000,68),
(30,1020,20,'Vitalize',190000,68),
(30,1020,21,'Vitalize',190000,68),
(30,1069,35,'Sleep',190000,68),
(30,1069,36,'Sleep',190000,68),
(30,1217,22,'Greater Heal',190000,68),
(30,1217,23,'Greater Heal',190000,68),
(30,1078,6,'Concentration',390000,68),
(30,1401,7,'Major Heal',390000,68),
(30,1430,4,'Invocation',390000,68),
(30,1206,16,'Wind Shackle',390000,68),
(30,1273,10,'Serenade of Eva',390000,68),
(30,1394,7,'Trance',390000,68),
(30,1395,7,'Erase',390000,68),
(30,1398,7,'Mana Burn',390000,68),
(30,1400,7,'Turn Undead',390000,68),
(30,1219,24,'Greater Group Heal',250000,70),
(30,1219,25,'Greater Group Heal',250000,70),
(30,1400,8,'Turn Undead',490000,70),
(30,1398,8,'Mana Burn',490000,70),
(30,1395,8,'Erase',490000,70),
(30,1394,8,'Trance',490000,70),
(30,1273,11,'Serenade of Eva',490000,70),
(30,1303,2,'Wild Magic',490000,70),
(30,1206,17,'Wind Shackle',490000,70),
(30,1243,6,'Bless Shield',490000,70),
(30,1401,8,'Major Heal',490000,70),
(30,1217,24,'Greater Heal',250000,70),
(30,1217,25,'Greater Heal',250000,70),
(30,1069,37,'Sleep',250000,70),
(30,1069,38,'Sleep',250000,70),
(30,1020,22,'Vitalize',250000,70),
(30,1020,23,'Vitalize',250000,70),
(30,1028,17,'Might of Heaven',490000,70),
(30,1013,27,'Recharge',250000,70),
(30,1013,28,'Recharge',250000,70),
(30,249,37,'Weapon Mastery',250000,70),
(30,249,38,'Weapon Mastery',250000,70),
(30,236,36,'Light Armor Mastery',250000,70),
(30,236,37,'Light Armor Mastery',250000,70),
(30,235,36,'Robe Mastery',250000,70),
(30,235,37,'Robe Mastery',250000,70),
(30,146,40,'Anti Magic',250000,70),
(30,146,41,'Anti Magic',250000,70),
(30,1219,26,'Greater Group Heal',360000,72),
(30,1219,27,'Greater Group Heal',360000,72),
(30,146,42,'Anti Magic',360000,72),
(30,146,43,'Anti Magic',360000,72),
(30,235,38,'Robe Mastery',360000,72),
(30,235,39,'Robe Mastery',360000,72),
(30,236,38,'Light Armor Mastery',360000,72),
(30,236,39,'Light Armor Mastery',360000,72),
(30,249,39,'Weapon Mastery',360000,72),
(30,249,40,'Weapon Mastery',360000,72),
(30,1013,29,'Recharge',360000,72),
(30,1013,30,'Recharge',360000,72),
(30,213,8,'Boost Mana',710000,72),
(30,1028,18,'Might of Heaven',710000,72),
(30,1020,24,'Vitalize',360000,72),
(30,1020,25,'Vitalize',360000,72),
(30,1069,39,'Sleep',360000,72),
(30,1069,40,'Sleep',360000,72),
(30,1217,26,'Greater Heal',360000,72),
(30,1217,27,'Greater Heal',360000,72),
(30,1401,9,'Major Heal',710000,72),
(30,1430,5,'Invocation',710000,72),
(30,1304,3,'Advanced Block',710000,72),
(30,1206,18,'Wind Shackle',710000,72),
(30,1259,4,'Resist Shock',710000,72),
(30,1273,12,'Serenade of Eva',710000,72),
(30,1394,9,'Trance',710000,72),
(30,1395,9,'Erase',710000,72),
(30,1398,9,'Mana Burn',710000,72),
(30,1400,9,'Turn Undead',710000,72),
(30,1219,28,'Greater Group Heal',520000,74),
(30,1219,29,'Greater Group Heal',520000,74),
(30,1400,10,'Turn Undead',1050000,74),
(30,1398,10,'Mana Burn',1050000,74),
(30,1395,10,'Erase',1050000,74),
(30,1394,10,'Trance',1050000,74),
(30,1273,13,'Serenade of Eva',1050000,74),
(30,1206,19,'Wind Shackle',1050000,74),
(30,1393,3,'Unholy Resistance',1050000,74),
(30,1401,10,'Major Heal',1050000,74),
(30,1397,3,'Clarity',1050000,74),
(30,1217,28,'Greater Heal',520000,74),
(30,1217,29,'Greater Heal',520000,74),
(30,1016,7,'Resurrection',1050000,74),
(30,1069,41,'Sleep',520000,74),
(30,1069,42,'Sleep',520000,74),
(30,1020,26,'Vitalize',520000,74),
(30,1020,27,'Vitalize',520000,74),
(30,1028,19,'Might of Heaven',1050000,74),
(30,212,6,'Fast HP Recovery',1050000,74),
(30,229,7,'Fast Mana Recovery',1050000,74),
(30,1013,31,'Recharge',520000,74),
(30,1013,32,'Recharge',520000,74),
(30,249,41,'Weapon Mastery',520000,74),
(30,249,42,'Weapon Mastery',520000,74),
(30,236,40,'Light Armor Mastery',520000,74),
(30,236,41,'Light Armor Mastery',520000,74),
(30,235,40,'Robe Mastery',520000,74),
(30,235,41,'Robe Mastery',520000,74),
(30,146,44,'Anti Magic',520000,74),
(30,146,45,'Anti Magic',520000,74),
(31,3,1,'Power Strike',50,5),
(31,3,2,'Power Strike',50,5),
(31,3,3,'Power Strike',50,5),
(31,16,1,'Mortal Blow',50,5),
(31,16,2,'Mortal Blow',50,5),
(31,16,3,'Mortal Blow',50,5),
(31,56,1,'Power Shot',50,5),
(31,56,2,'Power Shot',50,5),
(31,56,3,'Power Shot',50,5),
(31,91,1,'Defense Aura',160,5),
(31,141,1,'Weapon Mastery',160,5),
(31,142,1,'Armor Mastery',160,5),
(31,142,2,'Armor Mastery',460,10),
(31,142,3,'Armor Mastery',460,10),
(31,141,2,'Weapon Mastery',910,10),
(31,56,4,'Power Shot',310,10),
(31,56,5,'Power Shot',310,10),
(31,56,6,'Power Shot',310,10),
(31,16,4,'Mortal Blow',310,10),
(31,16,5,'Mortal Blow',310,10),
(31,16,6,'Mortal Blow',310,10),
(31,3,4,'Power Strike',310,10),
(31,3,5,'Power Strike',310,10),
(31,3,6,'Power Strike',310,10),
(31,77,1,'Attack Aura',910,10),
(31,294,1,'Shadow Sense',2900,15),
(31,3,7,'Power Strike',950,15),
(31,3,8,'Power Strike',950,15),
(31,3,9,'Power Strike',950,15),
(31,16,7,'Mortal Blow',950,15),
(31,16,8,'Mortal Blow',950,15),
(31,16,9,'Mortal Blow',950,15),
(31,56,7,'Power Shot',950,15),
(31,56,8,'Power Shot',950,15),
(31,56,9,'Power Shot',950,15),
(31,70,1,'Drain Health',1400,15),
(31,70,2,'Drain Health',1400,15),
(31,141,3,'Weapon Mastery',2900,15),
(31,142,4,'Armor Mastery',1400,15),
(31,142,5,'Armor Mastery',1400,15),
(32,70,3,'Drain Health',2300,20),
(32,70,4,'Drain Health',2300,20),
(32,110,1,'Ultimate Defense',4700,20),
(32,129,1,'Poison',4700,20),
(32,147,1,'Magic Resistance',2300,20),
(32,147,2,'Magic Resistance',2300,20),
(32,217,1,'Sword/Blunt Weapon Mastery',4700,20),
(32,232,1,'Heavy Armor Mastery',1500,20),
(32,232,2,'Heavy Armor Mastery',1500,20),
(32,232,3,'Heavy Armor Mastery',1500,20),
(32,91,2,'Defense Aura',4700,20),
(32,153,1,'Shield Mastery',4700,20),
(32,232,4,'Heavy Armor Mastery',2900,24),
(32,232,5,'Heavy Armor Mastery',2900,24),
(32,232,6,'Heavy Armor Mastery',2900,24),
(32,217,2,'Sword/Blunt Weapon Mastery',8800,24),
(32,223,1,'Sting',2900,24),
(32,223,2,'Sting',2900,24),
(32,223,3,'Sting',2900,24),
(32,147,3,'Magic Resistance',2900,24),
(32,147,4,'Magic Resistance',2900,24),
(32,147,5,'Magic Resistance',2900,24),
(32,112,1,'Deflect Arrow',8800,24),
(32,2,1,'Confusion',8800,24),
(32,70,5,'Drain Health',2900,24),
(32,70,6,'Drain Health',2900,24),
(32,70,7,'Drain Health',2900,24),
(32,28,1,'Aggression',2900,24),
(32,28,2,'Aggression',2900,24),
(32,28,3,'Aggression',2900,24),
(32,28,4,'Aggression',4400,28),
(32,28,5,'Aggression',4400,28),
(32,28,6,'Aggression',4400,28),
(32,70,8,'Drain Health',4400,28),
(32,70,9,'Drain Health',4400,28),
(32,70,10,'Drain Health',4400,28),
(32,2,2,'Confusion',13000,28),
(32,147,6,'Magic Resistance',4400,28),
(32,147,7,'Magic Resistance',4400,28),
(32,147,8,'Magic Resistance',4400,28),
(32,223,4,'Sting',4400,28),
(32,223,5,'Sting',4400,28),
(32,223,6,'Sting',4400,28),
(32,217,3,'Sword/Blunt Weapon Mastery',6700,28),
(32,217,4,'Sword/Blunt Weapon Mastery',6700,28),
(32,232,7,'Heavy Armor Mastery',4400,28),
(32,232,8,'Heavy Armor Mastery',4400,28),
(32,232,9,'Heavy Armor Mastery',4400,28),
(32,153,2,'Shield Mastery',13000,28),
(32,77,2,'Attack Aura',13000,28),
(32,232,10,'Heavy Armor Mastery',7400,32),
(32,232,11,'Heavy Armor Mastery',7400,32),
(32,232,12,'Heavy Armor Mastery',7400,32),
(32,217,5,'Sword/Blunt Weapon Mastery',11000,32),
(32,217,6,'Sword/Blunt Weapon Mastery',11000,32),
(32,223,7,'Sting',7400,32),
(32,223,8,'Sting',7400,32),
(32,223,9,'Sting',7400,32),
(32,147,9,'Magic Resistance',7400,32),
(32,147,10,'Magic Resistance',7400,32),
(32,147,11,'Magic Resistance',7400,32),
(32,2,3,'Confusion',22000,32),
(32,112,2,'Deflect Arrow',22000,32),
(32,115,1,'Power Break',22000,32),
(32,70,11,'Drain Health',7400,32),
(32,70,12,'Drain Health',7400,32),
(32,70,13,'Drain Health',7400,32),
(32,28,7,'Aggression',7400,32),
(32,28,8,'Aggression',7400,32),
(32,28,9,'Aggression',7400,32),
(32,28,10,'Aggression',9000,36),
(32,28,11,'Aggression',9000,36),
(32,28,12,'Aggression',9000,36),
(32,70,14,'Drain Health',9000,36),
(32,70,15,'Drain Health',9000,36),
(32,70,16,'Drain Health',9000,36),
(32,115,2,'Power Break',28000,36),
(32,2,4,'Confusion',28000,36),
(32,147,12,'Magic Resistance',9000,36),
(32,147,13,'Magic Resistance',9000,36),
(32,147,14,'Magic Resistance',9000,36),
(32,223,10,'Sting',9000,36),
(32,223,11,'Sting',9000,36),
(32,223,12,'Sting',9000,36),
(32,217,7,'Sword/Blunt Weapon Mastery',14000,36),
(32,217,8,'Sword/Blunt Weapon Mastery',14000,36),
(32,232,13,'Heavy Armor Mastery',9000,36),
(32,232,14,'Heavy Armor Mastery',9000,36),
(32,232,15,'Heavy Armor Mastery',9000,36),
(32,191,1,'Focus Mind',28000,36),
(32,105,1,'Freezing Strike',14000,36),
(32,105,2,'Freezing Strike',14000,36),
(33,18,1,'Aura of Hate',9000,40),
(33,18,2,'Aura of Hate',9000,40),
(33,18,3,'Aura of Hate',9000,40),
(33,28,13,'Aggression',9000,40),
(33,28,14,'Aggression',9000,40),
(33,28,15,'Aggression',9000,40),
(33,70,17,'Drain Health',9000,40),
(33,70,18,'Drain Health',9000,40),
(33,70,19,'Drain Health',9000,40),
(33,2,5,'Confusion',26000,40),
(33,33,1,'Summon Phantom Cubic',26000,40),
(33,105,3,'Freezing Strike',13000,40),
(33,105,4,'Freezing Strike',13000,40),
(33,115,3,'Power Break',26000,40),
(33,122,1,'Hex',26000,40),
(33,147,15,'Magic Resistance',9000,40),
(33,147,16,'Magic Resistance',9000,40),
(33,147,17,'Magic Resistance',9000,40),
(33,217,9,'Sword/Blunt Weapon Mastery',9000,40),
(33,217,10,'Sword/Blunt Weapon Mastery',9000,40),
(33,217,11,'Sword/Blunt Weapon Mastery',9000,40),
(33,223,13,'Sting',9000,40),
(33,223,14,'Sting',9000,40),
(33,223,15,'Sting',9000,40),
(33,232,16,'Heavy Armor Mastery',9000,40),
(33,232,17,'Heavy Armor Mastery',9000,40),
(33,232,18,'Heavy Armor Mastery',9000,40),
(33,289,1,'Life Leech',26000,40),
(33,153,3,'Shield Mastery',26000,40),
(33,289,2,'Life Leech',26000,43),
(33,191,2,'Focus Mind',26000,43),
(33,288,1,'Guard Stance',26000,43),
(33,232,19,'Heavy Armor Mastery',9000,43),
(33,232,20,'Heavy Armor Mastery',9000,43),
(33,232,21,'Heavy Armor Mastery',9000,43),
(33,223,16,'Sting',9000,43),
(33,223,17,'Sting',9000,43),
(33,223,18,'Sting',9000,43),
(33,217,12,'Sword/Blunt Weapon Mastery',9000,43),
(33,217,13,'Sword/Blunt Weapon Mastery',9000,43),
(33,217,14,'Sword/Blunt Weapon Mastery',9000,43),
(33,147,18,'Magic Resistance',9000,43),
(33,147,19,'Magic Resistance',9000,43),
(33,147,20,'Magic Resistance',9000,43),
(33,122,2,'Hex',26000,43),
(33,112,3,'Deflect Arrow',26000,43),
(33,143,1,'Cubic Mastery',26000,43),
(33,115,4,'Power Break',26000,43),
(33,22,1,'Summon Vampiric Cubic',26000,43),
(33,105,5,'Freezing Strike',13000,43),
(33,105,6,'Freezing Strike',13000,43),
(33,2,6,'Confusion',26000,43),
(33,70,20,'Drain Health',9000,43),
(33,70,21,'Drain Health',9000,43),
(33,70,22,'Drain Health',9000,43),
(33,28,16,'Aggression',9000,43),
(33,28,17,'Aggression',9000,43),
(33,28,18,'Aggression',9000,43),
(33,813,1,'Vanguard',78000,43),
(33,18,4,'Aura of Hate',9000,43),
(33,18,5,'Aura of Hate',9000,43),
(33,18,6,'Aura of Hate',9000,43),
(33,18,7,'Aura of Hate',13000,46),
(33,18,8,'Aura of Hate',13000,46),
(33,18,9,'Aura of Hate',13000,46),
(33,28,19,'Aggression',13000,46),
(33,28,20,'Aggression',13000,46),
(33,28,21,'Aggression',13000,46),
(33,70,23,'Drain Health',13000,46),
(33,70,24,'Drain Health',13000,46),
(33,70,25,'Drain Health',13000,46),
(33,2,7,'Confusion',40000,46),
(33,33,2,'Summon Phantom Cubic',40000,46),
(33,105,7,'Freezing Strike',20000,46),
(33,105,8,'Freezing Strike',20000,46),
(33,103,1,'Corpse Plague',40000,46),
(33,115,5,'Power Break',40000,46),
(33,122,3,'Hex',40000,46),
(33,147,21,'Magic Resistance',13000,46),
(33,147,22,'Magic Resistance',13000,46),
(33,147,23,'Magic Resistance',13000,46),
(33,217,15,'Sword/Blunt Weapon Mastery',13000,46),
(33,217,16,'Sword/Blunt Weapon Mastery',13000,46),
(33,217,17,'Sword/Blunt Weapon Mastery',13000,46),
(33,223,19,'Sting',13000,46),
(33,223,20,'Sting',13000,46),
(33,223,21,'Sting',13000,46),
(33,232,22,'Heavy Armor Mastery',13000,46),
(33,232,23,'Heavy Armor Mastery',13000,46),
(33,232,24,'Heavy Armor Mastery',13000,46),
(33,289,3,'Life Leech',40000,46),
(33,110,2,'Ultimate Defense',40000,46),
(33,289,4,'Life Leech',58000,49),
(33,191,3,'Focus Mind',58000,49),
(33,278,1,'Summon Viper Cubic',58000,49),
(33,232,25,'Heavy Armor Mastery',19000,49),
(33,232,26,'Heavy Armor Mastery',19000,49),
(33,232,27,'Heavy Armor Mastery',19000,49),
(33,223,22,'Sting',19000,49),
(33,223,23,'Sting',19000,49),
(33,223,24,'Sting',19000,49),
(33,217,18,'Sword/Blunt Weapon Mastery',19000,49),
(33,217,19,'Sword/Blunt Weapon Mastery',19000,49),
(33,217,20,'Sword/Blunt Weapon Mastery',19000,49),
(33,147,24,'Magic Resistance',19000,49),
(33,147,25,'Magic Resistance',19000,49),
(33,147,26,'Magic Resistance',19000,49),
(33,122,4,'Hex',58000,49),
(33,112,4,'Deflect Arrow',58000,49),
(33,129,2,'Poison',58000,49),
(33,115,6,'Power Break',58000,49),
(33,22,2,'Summon Vampiric Cubic',58000,49),
(33,105,9,'Freezing Strike',29000,49),
(33,105,10,'Freezing Strike',29000,49),
(33,2,8,'Confusion',58000,49),
(33,70,26,'Drain Health',19000,49),
(33,70,27,'Drain Health',19000,49),
(33,70,28,'Drain Health',19000,49),
(33,28,22,'Aggression',19000,49),
(33,28,23,'Aggression',19000,49),
(33,28,24,'Aggression',19000,49),
(33,18,10,'Aura of Hate',19000,49),
(33,18,11,'Aura of Hate',19000,49),
(33,18,12,'Aura of Hate',19000,49),
(33,18,13,'Aura of Hate',31000,52),
(33,18,14,'Aura of Hate',31000,52),
(33,18,15,'Aura of Hate',31000,52),
(33,28,25,'Aggression',31000,52),
(33,28,26,'Aggression',31000,52),
(33,28,27,'Aggression',31000,52),
(33,70,29,'Drain Health',31000,52),
(33,70,30,'Drain Health',31000,52),
(33,70,31,'Drain Health',31000,52),
(33,2,9,'Confusion',94000,52),
(33,33,3,'Summon Phantom Cubic',94000,52),
(33,105,11,'Freezing Strike',47000,52),
(33,105,12,'Freezing Strike',47000,52),
(33,115,7,'Power Break',94000,52),
(33,122,5,'Hex',94000,52),
(33,147,27,'Magic Resistance',31000,52),
(33,147,28,'Magic Resistance',31000,52),
(33,147,29,'Magic Resistance',31000,52),
(33,217,21,'Sword/Blunt Weapon Mastery',31000,52),
(33,217,22,'Sword/Blunt Weapon Mastery',31000,52),
(33,217,23,'Sword/Blunt Weapon Mastery',31000,52),
(33,223,25,'Sting',31000,52),
(33,223,26,'Sting',31000,52),
(33,223,27,'Sting',31000,52),
(33,232,28,'Heavy Armor Mastery',31000,52),
(33,232,29,'Heavy Armor Mastery',31000,52),
(33,232,30,'Heavy Armor Mastery',31000,52),
(33,288,2,'Guard Stance',94000,52),
(33,289,5,'Life Leech',94000,52),
(33,291,1,'Final Fortress',94000,52),
(33,153,4,'Shield Mastery',94000,52),
(33,450,1,'Banish Seraph',110000,55),
(33,401,1,'Judgment',110000,55),
(33,402,1,'Arrest',110000,55),
(33,291,2,'Final Fortress',110000,55),
(33,289,6,'Life Leech',110000,55),
(33,278,2,'Summon Viper Cubic',110000,55),
(33,191,4,'Focus Mind',110000,55),
(33,232,31,'Heavy Armor Mastery',37000,55),
(33,232,32,'Heavy Armor Mastery',37000,55),
(33,232,33,'Heavy Armor Mastery',37000,55),
(33,223,28,'Sting',37000,55),
(33,223,29,'Sting',37000,55),
(33,223,30,'Sting',37000,55),
(33,217,24,'Sword/Blunt Weapon Mastery',37000,55),
(33,217,25,'Sword/Blunt Weapon Mastery',37000,55),
(33,217,26,'Sword/Blunt Weapon Mastery',37000,55),
(33,147,30,'Magic Resistance',37000,55),
(33,147,31,'Magic Resistance',37000,55),
(33,147,32,'Magic Resistance',37000,55),
(33,122,6,'Hex',110000,55),
(33,143,2,'Cubic Mastery',110000,55),
(33,115,8,'Power Break',110000,55),
(33,22,3,'Summon Vampiric Cubic',110000,55),
(33,105,13,'Freezing Strike',55000,55),
(33,105,14,'Freezing Strike',55000,55),
(33,2,10,'Confusion',110000,55),
(33,70,32,'Drain Health',37000,55),
(33,70,33,'Drain Health',37000,55),
(33,70,34,'Drain Health',37000,55),
(33,28,28,'Aggression',37000,55),
(33,28,29,'Aggression',37000,55),
(33,28,30,'Aggression',37000,55),
(33,18,16,'Aura of Hate',37000,55),
(33,18,17,'Aura of Hate',37000,55),
(33,18,18,'Aura of Hate',37000,55),
(33,18,19,'Aura of Hate',40000,58),
(33,18,20,'Aura of Hate',40000,58),
(33,18,21,'Aura of Hate',40000,58),
(33,28,31,'Aggression',40000,58),
(33,28,32,'Aggression',40000,58),
(33,28,33,'Aggression',40000,58),
(33,70,35,'Drain Health',40000,58),
(33,70,36,'Drain Health',40000,58),
(33,70,37,'Drain Health',40000,58),
(33,2,11,'Confusion',120000,58),
(33,33,4,'Summon Phantom Cubic',120000,58),
(33,105,15,'Freezing Strike',60000,58),
(33,105,16,'Freezing Strike',60000,58),
(33,103,2,'Corpse Plague',120000,58),
(33,115,9,'Power Break',120000,58),
(33,129,3,'Poison',120000,58),
(33,122,7,'Hex',120000,58),
(33,147,33,'Magic Resistance',40000,58),
(33,147,34,'Magic Resistance',40000,58),
(33,147,35,'Magic Resistance',40000,58),
(33,217,27,'Sword/Blunt Weapon Mastery',40000,58),
(33,217,28,'Sword/Blunt Weapon Mastery',40000,58),
(33,217,29,'Sword/Blunt Weapon Mastery',40000,58),
(33,223,31,'Sting',40000,58),
(33,223,32,'Sting',40000,58),
(33,223,33,'Sting',40000,58),
(33,232,34,'Heavy Armor Mastery',40000,58),
(33,232,35,'Heavy Armor Mastery',40000,58),
(33,232,36,'Heavy Armor Mastery',40000,58),
(33,279,1,'Lightning Strike',120000,58),
(33,289,7,'Life Leech',120000,58),
(33,291,3,'Final Fortress',120000,58),
(33,402,2,'Arrest',120000,58),
(33,401,2,'Judgment',120000,58),
(33,450,2,'Banish Seraph',120000,58),
(33,916,1,'Shield Deflect Magic',150000,60),
(33,450,3,'Banish Seraph',153000,60),
(33,316,1,'Aegis',153000,60),
(33,401,3,'Judgment',153000,60),
(33,402,3,'Arrest',153000,60),
(33,291,4,'Final Fortress',153000,60),
(33,289,8,'Life Leech',153000,60),
(33,278,3,'Summon Viper Cubic',153000,60),
(33,232,37,'Heavy Armor Mastery',76000,60),
(33,232,38,'Heavy Armor Mastery',76000,60),
(33,223,34,'Sting',76000,60),
(33,223,35,'Sting',76000,60),
(33,217,30,'Sword/Blunt Weapon Mastery',76000,60),
(33,217,31,'Sword/Blunt Weapon Mastery',76000,60),
(33,147,36,'Magic Resistance',76000,60),
(33,147,37,'Magic Resistance',76000,60),
(33,122,8,'Hex',153000,60),
(33,115,10,'Power Break',153000,60),
(33,22,4,'Summon Vampiric Cubic',153000,60),
(33,105,17,'Freezing Strike',153000,60),
(33,2,12,'Confusion',153000,60),
(33,70,38,'Drain Health',76000,60),
(33,70,39,'Drain Health',76000,60),
(33,28,34,'Aggression',76000,60),
(33,28,35,'Aggression',76000,60),
(33,18,22,'Aura of Hate',76000,60),
(33,18,23,'Aura of Hate',76000,60),
(33,18,24,'Aura of Hate',100000,62),
(33,18,25,'Aura of Hate',100000,62),
(33,28,36,'Aggression',100000,62),
(33,28,37,'Aggression',100000,62),
(33,70,40,'Drain Health',100000,62),
(33,70,41,'Drain Health',100000,62),
(33,2,13,'Confusion',200000,62),
(33,33,5,'Summon Phantom Cubic',200000,62),
(33,105,18,'Freezing Strike',200000,62),
(33,103,3,'Corpse Plague',200000,62),
(33,115,11,'Power Break',200000,62),
(33,122,9,'Hex',200000,62),
(33,147,38,'Magic Resistance',100000,62),
(33,147,39,'Magic Resistance',100000,62),
(33,217,32,'Sword/Blunt Weapon Mastery',100000,62),
(33,217,33,'Sword/Blunt Weapon Mastery',100000,62),
(33,223,36,'Sting',100000,62),
(33,223,37,'Sting',100000,62),
(33,232,39,'Heavy Armor Mastery',100000,62),
(33,232,40,'Heavy Armor Mastery',100000,62),
(33,279,2,'Lightning Strike',200000,62),
(33,288,3,'Guard Stance',200000,62),
(33,289,9,'Life Leech',200000,62),
(33,291,5,'Final Fortress',200000,62),
(33,402,4,'Arrest',200000,62),
(33,401,4,'Judgment',200000,62),
(33,450,4,'Banish Seraph',200000,62),
(33,916,2,'Shield Deflect Magic',230000,64),
(33,450,5,'Banish Seraph',240000,64),
(33,322,1,'Shield Fortress',240000,64),
(33,401,5,'Judgment',240000,64),
(33,402,5,'Arrest',240000,64),
(33,291,6,'Final Fortress',240000,64),
(33,289,10,'Life Leech',240000,64),
(33,278,4,'Summon Viper Cubic',240000,64),
(33,191,5,'Focus Mind',240000,64),
(33,232,41,'Heavy Armor Mastery',120000,64),
(33,232,42,'Heavy Armor Mastery',120000,64),
(33,223,38,'Sting',120000,64),
(33,223,39,'Sting',120000,64),
(33,217,34,'Sword/Blunt Weapon Mastery',120000,64),
(33,217,35,'Sword/Blunt Weapon Mastery',120000,64),
(33,147,40,'Magic Resistance',120000,64),
(33,147,41,'Magic Resistance',120000,64),
(33,122,10,'Hex',240000,64),
(33,115,12,'Power Break',240000,64),
(33,22,5,'Summon Vampiric Cubic',240000,64),
(33,105,19,'Freezing Strike',240000,64),
(33,2,14,'Confusion',240000,64),
(33,70,42,'Drain Health',120000,64),
(33,70,43,'Drain Health',120000,64),
(33,28,38,'Aggression',120000,64),
(33,28,39,'Aggression',120000,64),
(33,18,26,'Aura of Hate',120000,64),
(33,18,27,'Aura of Hate',120000,64),
(33,18,28,'Aura of Hate',180000,66),
(33,18,29,'Aura of Hate',180000,66),
(33,28,40,'Aggression',180000,66),
(33,28,41,'Aggression',180000,66),
(33,70,44,'Drain Health',180000,66),
(33,70,45,'Drain Health',180000,66),
(33,2,15,'Confusion',350000,66),
(33,33,6,'Summon Phantom Cubic',350000,66),
(33,105,20,'Freezing Strike',350000,66),
(33,115,13,'Power Break',350000,66),
(33,122,11,'Hex',350000,66),
(33,129,4,'Poison',350000,66),
(33,147,42,'Magic Resistance',180000,66),
(33,147,43,'Magic Resistance',180000,66),
(33,217,36,'Sword/Blunt Weapon Mastery',180000,66),
(33,217,37,'Sword/Blunt Weapon Mastery',180000,66),
(33,223,40,'Sting',180000,66),
(33,223,41,'Sting',180000,66),
(33,232,43,'Heavy Armor Mastery',180000,66),
(33,232,44,'Heavy Armor Mastery',180000,66),
(33,279,3,'Lightning Strike',350000,66),
(33,289,11,'Life Leech',350000,66),
(33,291,7,'Final Fortress',350000,66),
(33,402,6,'Arrest',350000,66),
(33,401,6,'Judgment',350000,66),
(33,322,2,'Shield Fortress',350000,66),
(33,450,6,'Banish Seraph',350000,66),
(33,916,3,'Shield Deflect Magic',390000,68),
(33,450,7,'Banish Seraph',410000,68),
(33,322,3,'Shield Fortress',410000,68),
(33,401,7,'Judgment',410000,68),
(33,402,7,'Arrest',410000,68),
(33,291,8,'Final Fortress',410000,68),
(33,289,12,'Life Leech',410000,68),
(33,278,5,'Summon Viper Cubic',410000,68),
(33,232,45,'Heavy Armor Mastery',210000,68),
(33,232,46,'Heavy Armor Mastery',210000,68),
(33,223,42,'Sting',210000,68),
(33,223,43,'Sting',210000,68),
(33,217,38,'Sword/Blunt Weapon Mastery',210000,68),
(33,217,39,'Sword/Blunt Weapon Mastery',210000,68),
(33,147,44,'Magic Resistance',210000,68),
(33,147,45,'Magic Resistance',210000,68),
(33,122,12,'Hex',410000,68),
(33,115,14,'Power Break',410000,68),
(33,22,6,'Summon Vampiric Cubic',410000,68),
(33,105,21,'Freezing Strike',410000,68),
(33,2,16,'Confusion',410000,68),
(33,70,46,'Drain Health',210000,68),
(33,70,47,'Drain Health',210000,68),
(33,28,42,'Aggression',210000,68),
(33,28,43,'Aggression',210000,68),
(33,18,30,'Aura of Hate',210000,68),
(33,18,31,'Aura of Hate',210000,68),
(33,18,32,'Aura of Hate',230000,70),
(33,18,33,'Aura of Hate',230000,70),
(33,28,44,'Aggression',230000,70),
(33,28,45,'Aggression',230000,70),
(33,70,48,'Drain Health',230000,70),
(33,70,49,'Drain Health',230000,70),
(33,2,17,'Confusion',470000,70),
(33,33,7,'Summon Phantom Cubic',470000,70),
(33,105,22,'Freezing Strike',470000,70),
(33,103,4,'Corpse Plague',470000,70),
(33,115,15,'Power Break',470000,70),
(33,122,13,'Hex',470000,70),
(33,147,46,'Magic Resistance',230000,70),
(33,147,47,'Magic Resistance',230000,70),
(33,217,40,'Sword/Blunt Weapon Mastery',230000,70),
(33,217,41,'Sword/Blunt Weapon Mastery',230000,70),
(33,223,44,'Sting',230000,70),
(33,223,45,'Sting',230000,70),
(33,232,47,'Heavy Armor Mastery',230000,70),
(33,232,48,'Heavy Armor Mastery',230000,70),
(33,279,4,'Lightning Strike',470000,70),
(33,288,4,'Guard Stance',470000,70),
(33,289,13,'Life Leech',470000,70),
(33,291,9,'Final Fortress',470000,70),
(33,402,8,'Arrest',470000,70),
(33,401,8,'Judgment',470000,70),
(33,322,4,'Shield Fortress',470000,70),
(33,450,8,'Banish Seraph',470000,70),
(33,916,4,'Shield Deflect Magic',570000,72),
(33,450,9,'Banish Seraph',600000,72),
(33,322,5,'Shield Fortress',600000,72),
(33,401,9,'Judgment',600000,72),
(33,402,9,'Arrest',600000,72),
(33,291,10,'Final Fortress',600000,72),
(33,289,14,'Life Leech',600000,72),
(33,278,6,'Summon Viper Cubic',600000,72),
(33,191,6,'Focus Mind',600000,72),
(33,232,49,'Heavy Armor Mastery',300000,72),
(33,232,50,'Heavy Armor Mastery',300000,72),
(33,223,46,'Sting',300000,72),
(33,223,47,'Sting',300000,72),
(33,217,42,'Sword/Blunt Weapon Mastery',300000,72),
(33,217,43,'Sword/Blunt Weapon Mastery',300000,72),
(33,147,48,'Magic Resistance',300000,72),
(33,147,49,'Magic Resistance',300000,72),
(33,122,14,'Hex',600000,72),
(33,115,16,'Power Break',600000,72),
(33,22,7,'Summon Vampiric Cubic',600000,72),
(33,105,23,'Freezing Strike',600000,72),
(33,2,18,'Confusion',600000,72),
(33,70,50,'Drain Health',300000,72),
(33,70,51,'Drain Health',300000,72),
(33,28,46,'Aggression',300000,72),
(33,28,47,'Aggression',300000,72),
(33,18,34,'Aura of Hate',300000,72),
(33,18,35,'Aura of Hate',300000,72),
(33,18,36,'Aura of Hate',650000,74),
(33,18,37,'Aura of Hate',650000,74),
(33,28,48,'Aggression',650000,74),
(33,28,49,'Aggression',650000,74),
(33,70,52,'Drain Health',650000,74),
(33,70,53,'Drain Health',650000,74),
(33,2,19,'Confusion',1300000,74),
(33,33,8,'Summon Phantom Cubic',1300000,74),
(33,105,24,'Freezing Strike',1300000,74),
(33,115,17,'Power Break',1300000,74),
(33,122,15,'Hex',1300000,74),
(33,129,5,'Poison',1300000,74),
(33,147,50,'Magic Resistance',650000,74),
(33,147,51,'Magic Resistance',650000,74),
(33,217,44,'Sword/Blunt Weapon Mastery',650000,74),
(33,217,45,'Sword/Blunt Weapon Mastery',650000,74),
(33,223,48,'Sting',650000,74),
(33,223,49,'Sting',650000,74),
(33,232,51,'Heavy Armor Mastery',650000,74),
(33,232,52,'Heavy Armor Mastery',650000,74),
(33,279,5,'Lightning Strike',1300000,74),
(33,289,15,'Life Leech',1300000,74),
(33,291,11,'Final Fortress',1300000,74),
(33,402,10,'Arrest',1300000,74),
(33,401,10,'Judgment',1300000,74),
(33,322,6,'Shield Fortress',1300000,74),
(33,450,10,'Banish Seraph',1300000,74),
(34,70,17,'Drain Health',14000,40),
(34,70,18,'Drain Health',14000,40),
(34,70,19,'Drain Health',14000,40),
(34,105,3,'Freezing Strike',22000,40),
(34,105,4,'Freezing Strike',22000,40),
(34,2,5,'Confusion',43000,40),
(34,115,3,'Power Break',43000,40),
(34,144,1,'Dual Weapon Mastery',14000,40),
(34,144,2,'Dual Weapon Mastery',14000,40),
(34,144,3,'Dual Weapon Mastery',14000,40),
(34,147,15,'Magic Resistance',14000,40),
(34,147,16,'Magic Resistance',14000,40),
(34,147,17,'Magic Resistance',14000,40),
(34,223,13,'Sting',14000,40),
(34,223,14,'Sting',14000,40),
(34,223,15,'Sting',14000,40),
(34,122,1,'Hex',43000,40),
(34,274,1,'Dance of Fire',43000,40),
(34,122,2,'Hex',46000,43),
(34,191,2,'Focus Mind',46000,43),
(34,223,16,'Sting',15000,43),
(34,223,17,'Sting',15000,43),
(34,223,18,'Sting',15000,43),
(34,277,1,'Dance of Light',46000,43),
(34,147,18,'Magic Resistance',15000,43),
(34,147,19,'Magic Resistance',15000,43),
(34,147,20,'Magic Resistance',15000,43),
(34,144,4,'Dual Weapon Mastery',15000,43),
(34,144,5,'Dual Weapon Mastery',15000,43),
(34,144,6,'Dual Weapon Mastery',15000,43),
(34,115,4,'Power Break',46000,43),
(34,2,6,'Confusion',46000,43),
(34,105,5,'Freezing Strike',23000,43),
(34,105,6,'Freezing Strike',23000,43),
(34,70,20,'Drain Health',15000,43),
(34,70,21,'Drain Health',15000,43),
(34,70,22,'Drain Health',15000,43),
(34,70,23,'Drain Health',22000,46),
(34,70,24,'Drain Health',22000,46),
(34,70,25,'Drain Health',22000,46),
(34,105,7,'Freezing Strike',33000,46),
(34,105,8,'Freezing Strike',33000,46),
(34,2,7,'Confusion',67000,46),
(34,115,5,'Power Break',67000,46),
(34,144,7,'Dual Weapon Mastery',22000,46),
(34,144,8,'Dual Weapon Mastery',22000,46),
(34,144,9,'Dual Weapon Mastery',22000,46),
(34,147,21,'Magic Resistance',22000,46),
(34,147,22,'Magic Resistance',22000,46),
(34,147,23,'Magic Resistance',22000,46),
(34,223,19,'Sting',22000,46),
(34,223,20,'Sting',22000,46),
(34,223,21,'Sting',22000,46),
(34,122,3,'Hex',67000,46),
(34,272,1,'Dance of Inspiration',67000,46),
(34,273,1,'Dance of the Mystic',89000,49),
(34,122,4,'Hex',89000,49),
(34,191,3,'Focus Mind',89000,49),
(34,129,2,'Poison',89000,49),
(34,223,22,'Sting',30000,49),
(34,223,23,'Sting',30000,49),
(34,223,24,'Sting',30000,49),
(34,147,24,'Magic Resistance',30000,49),
(34,147,25,'Magic Resistance',30000,49),
(34,147,26,'Magic Resistance',30000,49),
(34,144,10,'Dual Weapon Mastery',30000,49),
(34,144,11,'Dual Weapon Mastery',30000,49),
(34,144,12,'Dual Weapon Mastery',30000,49),
(34,115,6,'Power Break',89000,49),
(34,2,8,'Confusion',89000,49),
(34,105,9,'Freezing Strike',45000,49),
(34,105,10,'Freezing Strike',45000,49),
(34,70,26,'Drain Health',30000,49),
(34,70,27,'Drain Health',30000,49),
(34,70,28,'Drain Health',30000,49),
(34,70,29,'Drain Health',56000,52),
(34,70,30,'Drain Health',56000,52),
(34,70,31,'Drain Health',56000,52),
(34,105,11,'Freezing Strike',83000,52),
(34,105,12,'Freezing Strike',83000,52),
(34,2,9,'Confusion',167000,52),
(34,115,7,'Power Break',167000,52),
(34,144,13,'Dual Weapon Mastery',56000,52),
(34,144,14,'Dual Weapon Mastery',56000,52),
(34,144,15,'Dual Weapon Mastery',56000,52),
(34,147,27,'Magic Resistance',56000,52),
(34,147,28,'Magic Resistance',56000,52),
(34,147,29,'Magic Resistance',56000,52),
(34,223,25,'Sting',56000,52),
(34,223,26,'Sting',56000,52),
(34,223,27,'Sting',56000,52),
(34,122,5,'Hex',167000,52),
(34,276,1,'Dance of Concentration',167000,52),
(34,271,1,'Dance of the Warrior',170000,55),
(34,84,1,'Poison Blade Dance',170000,55),
(34,402,1,'Arrest',170000,55),
(34,122,6,'Hex',170000,55),
(34,191,4,'Focus Mind',170000,55),
(34,223,28,'Sting',56000,55),
(34,223,29,'Sting',56000,55),
(34,223,30,'Sting',56000,55),
(34,408,1,'Demonic Blade Dance',170000,55),
(34,147,30,'Magic Resistance',56000,55),
(34,147,31,'Magic Resistance',56000,55),
(34,147,32,'Magic Resistance',56000,55),
(34,144,16,'Dual Weapon Mastery',56000,55),
(34,144,17,'Dual Weapon Mastery',56000,55),
(34,144,18,'Dual Weapon Mastery',56000,55),
(34,115,8,'Power Break',170000,55),
(34,2,10,'Confusion',170000,55),
(34,105,13,'Freezing Strike',85000,55),
(34,105,14,'Freezing Strike',85000,55),
(34,70,32,'Drain Health',56000,55),
(34,70,33,'Drain Health',56000,55),
(34,70,34,'Drain Health',56000,55),
(34,70,35,'Drain Health',67000,58),
(34,70,36,'Drain Health',67000,58),
(34,70,37,'Drain Health',67000,58),
(34,105,15,'Freezing Strike',100000,58),
(34,105,16,'Freezing Strike',100000,58),
(34,2,11,'Confusion',200000,58),
(34,115,9,'Power Break',200000,58),
(34,144,19,'Dual Weapon Mastery',67000,58),
(34,144,20,'Dual Weapon Mastery',67000,58),
(34,144,21,'Dual Weapon Mastery',67000,58),
(34,147,33,'Magic Resistance',67000,58),
(34,147,34,'Magic Resistance',67000,58),
(34,147,35,'Magic Resistance',67000,58),
(34,408,2,'Demonic Blade Dance',200000,58),
(34,223,31,'Sting',67000,58),
(34,223,32,'Sting',67000,58),
(34,223,33,'Sting',67000,58),
(34,129,3,'Poison',200000,58),
(34,122,7,'Hex',200000,58),
(34,402,2,'Arrest',200000,58),
(34,275,1,'Dance of Fury',200000,58),
(34,84,2,'Poison Blade Dance',264000,60),
(34,402,3,'Arrest',264000,60),
(34,122,8,'Hex',264000,60),
(34,223,34,'Sting',132000,60),
(34,223,35,'Sting',132000,60),
(34,408,3,'Demonic Blade Dance',264000,60),
(34,147,36,'Magic Resistance',132000,60),
(34,147,37,'Magic Resistance',132000,60),
(34,144,22,'Dual Weapon Mastery',132000,60),
(34,144,23,'Dual Weapon Mastery',132000,60),
(34,115,10,'Power Break',264000,60),
(34,2,12,'Confusion',264000,60),
(34,105,17,'Freezing Strike',264000,60),
(34,70,38,'Drain Health',132000,60),
(34,70,39,'Drain Health',132000,60),
(34,70,40,'Drain Health',180000,62),
(34,70,41,'Drain Health',180000,62),
(34,105,18,'Freezing Strike',360000,62),
(34,2,13,'Confusion',360000,62),
(34,115,11,'Power Break',360000,62),
(34,144,24,'Dual Weapon Mastery',180000,62),
(34,144,25,'Dual Weapon Mastery',180000,62),
(34,147,38,'Magic Resistance',180000,62),
(34,147,39,'Magic Resistance',180000,62),
(34,408,4,'Demonic Blade Dance',360000,62),
(34,309,1,'Dance of Earth Guard',360000,62),
(34,223,36,'Sting',180000,62),
(34,223,37,'Sting',180000,62),
(34,122,9,'Hex',360000,62),
(34,402,4,'Arrest',360000,62),
(34,402,5,'Arrest',440000,64),
(34,122,10,'Hex',440000,64),
(34,191,5,'Focus Mind',440000,64),
(34,223,38,'Sting',220000,64),
(34,223,39,'Sting',220000,64),
(34,408,5,'Demonic Blade Dance',440000,64),
(34,147,40,'Magic Resistance',220000,64),
(34,147,41,'Magic Resistance',220000,64),
(34,144,26,'Dual Weapon Mastery',220000,64),
(34,144,27,'Dual Weapon Mastery',220000,64),
(34,115,12,'Power Break',440000,64),
(34,2,14,'Confusion',440000,64),
(34,105,19,'Freezing Strike',440000,64),
(34,70,42,'Drain Health',220000,64),
(34,70,43,'Drain Health',220000,64),
(34,70,44,'Drain Health',290000,66),
(34,70,45,'Drain Health',290000,66),
(34,105,20,'Freezing Strike',580000,66),
(34,2,15,'Confusion',580000,66),
(34,115,13,'Power Break',580000,66),
(34,144,28,'Dual Weapon Mastery',290000,66),
(34,144,29,'Dual Weapon Mastery',290000,66),
(34,147,42,'Magic Resistance',290000,66),
(34,147,43,'Magic Resistance',290000,66),
(34,408,6,'Demonic Blade Dance',580000,66),
(34,311,1,'Dance of Protection',580000,66),
(34,223,40,'Sting',290000,66),
(34,223,41,'Sting',290000,66),
(34,129,4,'Poison',580000,66),
(34,122,11,'Hex',580000,66),
(34,402,6,'Arrest',580000,66),
(34,402,7,'Arrest',780000,68),
(34,122,12,'Hex',780000,68),
(34,223,42,'Sting',390000,68),
(34,223,43,'Sting',390000,68),
(34,408,7,'Demonic Blade Dance',780000,68),
(34,147,44,'Magic Resistance',390000,68),
(34,147,45,'Magic Resistance',390000,68),
(34,144,30,'Dual Weapon Mastery',390000,68),
(34,144,31,'Dual Weapon Mastery',390000,68),
(34,115,14,'Power Break',780000,68),
(34,2,16,'Confusion',780000,68),
(34,105,21,'Freezing Strike',780000,68),
(34,70,46,'Drain Health',390000,68),
(34,70,47,'Drain Health',390000,68),
(34,70,48,'Drain Health',420000,70),
(34,70,49,'Drain Health',420000,70),
(34,105,22,'Freezing Strike',850000,70),
(34,2,17,'Confusion',850000,70),
(34,115,15,'Power Break',850000,70),
(34,144,32,'Dual Weapon Mastery',420000,70),
(34,144,33,'Dual Weapon Mastery',420000,70),
(34,147,46,'Magic Resistance',420000,70),
(34,147,47,'Magic Resistance',420000,70),
(34,408,8,'Demonic Blade Dance',850000,70),
(34,307,1,'Dance of Aqua Guard',850000,70),
(34,223,44,'Sting',420000,70),
(34,223,45,'Sting',420000,70),
(34,122,13,'Hex',850000,70),
(34,402,8,'Arrest',850000,70),
(34,402,9,'Arrest',1000000,72),
(34,84,3,'Poison Blade Dance',1000000,72),
(34,122,14,'Hex',1000000,72),
(34,191,6,'Focus Mind',1000000,72),
(34,223,46,'Sting',500000,72),
(34,223,47,'Sting',500000,72),
(34,408,9,'Demonic Blade Dance',1000000,72),
(34,147,48,'Magic Resistance',500000,72),
(34,147,49,'Magic Resistance',500000,72),
(34,144,34,'Dual Weapon Mastery',500000,72),
(34,144,35,'Dual Weapon Mastery',500000,72),
(34,115,16,'Power Break',1000000,72),
(34,2,18,'Confusion',1000000,72),
(34,105,23,'Freezing Strike',1000000,72),
(34,70,50,'Drain Health',500000,72),
(34,70,51,'Drain Health',500000,72),
(34,70,52,'Drain Health',1080000,74),
(34,70,53,'Drain Health',1080000,74),
(34,105,24,'Freezing Strike',2170000,74),
(34,2,19,'Confusion',2170000,74),
(34,115,17,'Power Break',2170000,74),
(34,144,36,'Dual Weapon Mastery',1080000,74),
(34,144,37,'Dual Weapon Mastery',1080000,74),
(34,147,50,'Magic Resistance',1080000,74),
(34,147,51,'Magic Resistance',1080000,74),
(34,408,10,'Demonic Blade Dance',2170000,74),
(34,310,1,'Dance of the Vampire',2170000,74),
(34,223,48,'Sting',1080000,74),
(34,223,49,'Sting',1080000,74),
(34,129,5,'Poison',2170000,74),
(34,122,15,'Hex',2170000,74),
(34,402,10,'Arrest',2170000,74),
(35,16,10,'Mortal Blow',1000,20),
(35,16,11,'Mortal Blow',1000,20),
(35,16,12,'Mortal Blow',1000,20),
(35,27,1,'Unlock',2800,20),
(35,56,10,'Power Shot',1000,20),
(35,56,11,'Power Shot',1000,20),
(35,56,12,'Power Shot',1000,20),
(35,70,3,'Drain Health',1500,20),
(35,70,4,'Drain Health',1500,20),
(35,91,2,'Defense Aura',2800,20),
(35,113,1,'Long Shot',2800,20),
(35,129,1,'Poison',2800,20),
(35,173,1,'Acrobatics',2800,20),
(35,208,1,'Bow Mastery',950,20),
(35,208,2,'Bow Mastery',950,20),
(35,208,3,'Bow Mastery',950,20),
(35,209,1,'Dagger Mastery',2800,20),
(35,233,1,'Light Armor Mastery',1400,20),
(35,233,2,'Light Armor Mastery',1400,20),
(35,195,1,'Breath Boost',2800,20),
(35,312,1,'Vicious Stance',2800,20),
(35,312,2,'Vicious Stance',5000,24),
(35,198,1,'Boost Evasion',5000,24),
(35,256,1,'Accuracy',5000,24),
(35,233,3,'Light Armor Mastery',2500,24),
(35,233,4,'Light Armor Mastery',2500,24),
(35,223,1,'Sting',1700,24),
(35,223,2,'Sting',1700,24),
(35,223,3,'Sting',1700,24),
(35,209,2,'Dagger Mastery',5000,24),
(35,208,4,'Bow Mastery',1700,24),
(35,208,5,'Bow Mastery',1700,24),
(35,208,6,'Bow Mastery',1700,24),
(35,193,1,'Critical Power',5000,24),
(35,96,1,'Bleed',5000,24),
(35,70,5,'Drain Health',1700,24),
(35,70,6,'Drain Health',1700,24),
(35,70,7,'Drain Health',1700,24),
(35,56,13,'Power Shot',1700,24),
(35,56,14,'Power Shot',1700,24),
(35,56,15,'Power Shot',1700,24),
(35,27,2,'Unlock',5000,24),
(35,2,1,'Confusion',5000,24),
(35,16,13,'Mortal Blow',1700,24),
(35,16,14,'Mortal Blow',1700,24),
(35,16,15,'Mortal Blow',1700,24),
(35,16,16,'Mortal Blow',2900,28),
(35,16,17,'Mortal Blow',2900,28),
(35,16,18,'Mortal Blow',2900,28),
(35,2,2,'Confusion',8500,28),
(35,27,3,'Unlock',8500,28),
(35,56,16,'Power Shot',2900,28),
(35,56,17,'Power Shot',2900,28),
(35,56,18,'Power Shot',2900,28),
(35,70,8,'Drain Health',2900,28),
(35,70,9,'Drain Health',2900,28),
(35,70,10,'Drain Health',2900,28),
(35,169,1,'Quick Step',8500,28),
(35,77,2,'Attack Aura',8500,28),
(35,111,1,'Ultimate Evasion',8500,28),
(35,208,7,'Bow Mastery',2900,28),
(35,208,8,'Bow Mastery',2900,28),
(35,208,9,'Bow Mastery',2900,28),
(35,209,3,'Dagger Mastery',4300,28),
(35,209,4,'Dagger Mastery',4300,28),
(35,223,4,'Sting',2900,28),
(35,223,5,'Sting',2900,28),
(35,223,6,'Sting',2900,28),
(35,233,5,'Light Armor Mastery',4300,28),
(35,233,6,'Light Armor Mastery',4300,28),
(35,225,1,'Acrobatic Move',8500,28),
(35,312,3,'Vicious Stance',8500,28),
(35,312,4,'Vicious Stance',14000,32),
(35,233,7,'Light Armor Mastery',7100,32),
(35,233,8,'Light Armor Mastery',7100,32),
(35,223,7,'Sting',4800,32),
(35,223,8,'Sting',4800,32),
(35,223,9,'Sting',4800,32),
(35,209,5,'Dagger Mastery',7100,32),
(35,209,6,'Dagger Mastery',7100,32),
(35,208,10,'Bow Mastery',4800,32),
(35,208,11,'Bow Mastery',4800,32),
(35,208,12,'Bow Mastery',4800,32),
(35,115,1,'Power Break',14000,32),
(35,193,2,'Critical Power',14000,32),
(35,96,2,'Bleed',14000,32),
(35,99,1,'Rapid Shot',14000,32),
(35,70,11,'Drain Health',4800,32),
(35,70,12,'Drain Health',4800,32),
(35,70,13,'Drain Health',4800,32),
(35,56,19,'Power Shot',4800,32),
(35,56,20,'Power Shot',4800,32),
(35,56,21,'Power Shot',4800,32),
(35,27,4,'Unlock',14000,32),
(35,2,3,'Confusion',14000,32),
(35,16,19,'Mortal Blow',4800,32),
(35,16,20,'Mortal Blow',4800,32),
(35,16,21,'Mortal Blow',4800,32),
(35,16,22,'Mortal Blow',7400,36),
(35,16,23,'Mortal Blow',7400,36),
(35,16,24,'Mortal Blow',7400,36),
(35,2,4,'Confusion',22000,36),
(35,27,5,'Unlock',22000,36),
(35,56,22,'Power Shot',7400,36),
(35,56,23,'Power Shot',7400,36),
(35,56,24,'Power Shot',7400,36),
(35,70,14,'Drain Health',7400,36),
(35,70,15,'Drain Health',7400,36),
(35,70,16,'Drain Health',7400,36),
(35,101,1,'Stunning Shot',7400,36),
(35,101,2,'Stunning Shot',7400,36),
(35,101,3,'Stunning Shot',7400,36),
(35,105,1,'Freezing Strike',11000,36),
(35,105,2,'Freezing Strike',11000,36),
(35,171,1,'Esprit',22000,36),
(35,115,2,'Power Break',22000,36),
(35,208,13,'Bow Mastery',7400,36),
(35,208,14,'Bow Mastery',7400,36),
(35,208,15,'Bow Mastery',7400,36),
(35,209,7,'Dagger Mastery',11000,36),
(35,209,8,'Dagger Mastery',11000,36),
(35,223,10,'Sting',7400,36),
(35,223,11,'Sting',7400,36),
(35,223,12,'Sting',7400,36),
(35,233,9,'Light Armor Mastery',11000,36),
(35,233,10,'Light Armor Mastery',11000,36),
(35,312,5,'Vicious Stance',22000,36),
(36,30,1,'Backstab',9300,40),
(36,30,2,'Backstab',9300,40),
(36,30,3,'Backstab',9300,40),
(36,70,17,'Drain Health',9300,40),
(36,70,18,'Drain Health',9300,40),
(36,70,19,'Drain Health',9300,40),
(36,2,5,'Confusion',28000,40),
(36,105,3,'Freezing Strike',14000,40),
(36,105,4,'Freezing Strike',14000,40),
(36,27,6,'Unlock',28000,40),
(36,115,3,'Power Break',28000,40),
(36,122,1,'Hex',28000,40),
(36,209,9,'Dagger Mastery',9300,40),
(36,209,10,'Dagger Mastery',9300,40),
(36,209,11,'Dagger Mastery',9300,40),
(36,221,1,'Silent Move',28000,40),
(36,223,13,'Sting',9300,40),
(36,223,14,'Sting',9300,40),
(36,223,15,'Sting',9300,40),
(36,233,11,'Light Armor Mastery',9300,40),
(36,233,12,'Light Armor Mastery',9300,40),
(36,233,13,'Light Armor Mastery',9300,40),
(36,263,1,'Deadly Blow',9300,40),
(36,263,2,'Deadly Blow',9300,40),
(36,263,3,'Deadly Blow',9300,40),
(36,193,3,'Critical Power',28000,40),
(36,312,6,'Vicious Stance',28000,40),
(36,312,7,'Vicious Stance',29000,43),
(36,169,2,'Quick Step',29000,43),
(36,171,2,'Esprit',29000,43),
(36,225,2,'Acrobatic Move',29000,43),
(36,263,4,'Deadly Blow',9600,43),
(36,263,5,'Deadly Blow',9600,43),
(36,263,6,'Deadly Blow',9600,43),
(36,233,14,'Light Armor Mastery',9600,43),
(36,233,15,'Light Armor Mastery',9600,43),
(36,233,16,'Light Armor Mastery',9600,43),
(36,223,16,'Sting',9600,43),
(36,223,17,'Sting',9600,43),
(36,223,18,'Sting',9600,43),
(36,209,12,'Dagger Mastery',9600,43),
(36,209,13,'Dagger Mastery',9600,43),
(36,209,14,'Dagger Mastery',9600,43),
(36,122,2,'Hex',29000,43),
(36,115,4,'Power Break',29000,43),
(36,27,7,'Unlock',29000,43),
(36,106,1,'Veil',29000,43),
(36,105,5,'Freezing Strike',14000,43),
(36,105,6,'Freezing Strike',14000,43),
(36,2,6,'Confusion',29000,43),
(36,70,20,'Drain Health',9600,43),
(36,70,21,'Drain Health',9600,43),
(36,70,22,'Drain Health',9600,43),
(36,30,4,'Backstab',9600,43),
(36,30,5,'Backstab',9600,43),
(36,30,6,'Backstab',9600,43),
(36,30,7,'Backstab',13000,46),
(36,30,8,'Backstab',13000,46),
(36,30,9,'Backstab',13000,46),
(36,70,23,'Drain Health',13000,46),
(36,70,24,'Drain Health',13000,46),
(36,70,25,'Drain Health',13000,46),
(36,2,7,'Confusion',38000,46),
(36,105,7,'Freezing Strike',19000,46),
(36,105,8,'Freezing Strike',19000,46),
(36,106,2,'Veil',38000,46),
(36,27,8,'Unlock',38000,46),
(36,115,5,'Power Break',38000,46),
(36,122,3,'Hex',38000,46),
(36,209,15,'Dagger Mastery',13000,46),
(36,209,16,'Dagger Mastery',13000,46),
(36,209,17,'Dagger Mastery',13000,46),
(36,223,19,'Sting',13000,46),
(36,223,20,'Sting',13000,46),
(36,223,21,'Sting',13000,46),
(36,233,17,'Light Armor Mastery',13000,46),
(36,233,18,'Light Armor Mastery',13000,46),
(36,233,19,'Light Armor Mastery',13000,46),
(36,263,7,'Deadly Blow',13000,46),
(36,263,8,'Deadly Blow',13000,46),
(36,263,9,'Deadly Blow',13000,46),
(36,419,1,'Summon Treasure Key',38000,46),
(36,171,3,'Esprit',38000,46),
(36,312,8,'Vicious Stance',38000,46),
(36,198,2,'Boost Evasion',38000,46),
(36,312,9,'Vicious Stance',61000,49),
(36,171,4,'Esprit',61000,49),
(36,96,3,'Bleed',61000,49),
(36,129,2,'Poison',61000,49),
(36,263,10,'Deadly Blow',20000,49),
(36,263,11,'Deadly Blow',20000,49),
(36,263,12,'Deadly Blow',20000,49),
(36,233,20,'Light Armor Mastery',20000,49),
(36,233,21,'Light Armor Mastery',20000,49),
(36,233,22,'Light Armor Mastery',20000,49),
(36,223,22,'Sting',20000,49),
(36,223,23,'Sting',20000,49),
(36,223,24,'Sting',20000,49),
(36,209,18,'Dagger Mastery',20000,49),
(36,209,19,'Dagger Mastery',20000,49),
(36,209,20,'Dagger Mastery',20000,49),
(36,122,4,'Hex',61000,49),
(36,115,6,'Power Break',61000,49),
(36,106,3,'Veil',61000,49),
(36,105,9,'Freezing Strike',31000,49),
(36,105,10,'Freezing Strike',31000,49),
(36,2,8,'Confusion',61000,49),
(36,11,1,'Trick',61000,49),
(36,70,26,'Drain Health',20000,49),
(36,70,27,'Drain Health',20000,49),
(36,70,28,'Drain Health',20000,49),
(36,30,10,'Backstab',20000,49),
(36,30,11,'Backstab',20000,49),
(36,30,12,'Backstab',20000,49),
(36,51,1,'Lure',88000,52),
(36,30,13,'Backstab',29000,52),
(36,30,14,'Backstab',29000,52),
(36,30,15,'Backstab',29000,52),
(36,70,29,'Drain Health',29000,52),
(36,70,30,'Drain Health',29000,52),
(36,70,31,'Drain Health',29000,52),
(36,11,2,'Trick',88000,52),
(36,2,9,'Confusion',88000,52),
(36,105,11,'Freezing Strike',44000,52),
(36,105,12,'Freezing Strike',44000,52),
(36,106,4,'Veil',88000,52),
(36,27,9,'Unlock',88000,52),
(36,115,7,'Power Break',88000,52),
(36,122,5,'Hex',88000,52),
(36,209,21,'Dagger Mastery',29000,52),
(36,209,22,'Dagger Mastery',29000,52),
(36,209,23,'Dagger Mastery',29000,52),
(36,223,25,'Sting',29000,52),
(36,223,26,'Sting',29000,52),
(36,223,27,'Sting',29000,52),
(36,233,23,'Light Armor Mastery',29000,52),
(36,233,24,'Light Armor Mastery',29000,52),
(36,233,25,'Light Armor Mastery',29000,52),
(36,263,13,'Deadly Blow',29000,52),
(36,263,14,'Deadly Blow',29000,52),
(36,263,15,'Deadly Blow',29000,52),
(36,171,5,'Esprit',88000,52),
(36,312,10,'Vicious Stance',88000,52),
(36,193,4,'Critical Power',88000,52),
(36,111,2,'Ultimate Evasion',116000,55),
(36,173,2,'Acrobatics',116000,55),
(36,312,11,'Vicious Stance',116000,55),
(36,225,3,'Acrobatic Move',116000,55),
(36,195,2,'Breath Boost',116000,55),
(36,412,1,'Sand Bomb',116000,55),
(36,263,16,'Deadly Blow',39000,55),
(36,263,17,'Deadly Blow',39000,55),
(36,263,18,'Deadly Blow',39000,55),
(36,233,26,'Light Armor Mastery',39000,55),
(36,233,27,'Light Armor Mastery',39000,55),
(36,233,28,'Light Armor Mastery',39000,55),
(36,223,28,'Sting',39000,55),
(36,223,29,'Sting',39000,55),
(36,223,30,'Sting',39000,55),
(36,209,24,'Dagger Mastery',39000,55),
(36,209,25,'Dagger Mastery',39000,55),
(36,209,26,'Dagger Mastery',39000,55),
(36,122,6,'Hex',116000,55),
(36,115,8,'Power Break',116000,55),
(36,27,10,'Unlock',116000,55),
(36,106,5,'Veil',116000,55),
(36,105,13,'Freezing Strike',58000,55),
(36,105,14,'Freezing Strike',58000,55),
(36,2,10,'Confusion',116000,55),
(36,11,3,'Trick',116000,55),
(36,70,32,'Drain Health',39000,55),
(36,70,33,'Drain Health',39000,55),
(36,70,34,'Drain Health',39000,55),
(36,30,16,'Backstab',39000,55),
(36,30,17,'Backstab',39000,55),
(36,30,18,'Backstab',39000,55),
(36,30,19,'Backstab',42000,58),
(36,30,20,'Backstab',42000,58),
(36,30,21,'Backstab',42000,58),
(36,70,35,'Drain Health',42000,58),
(36,70,36,'Drain Health',42000,58),
(36,70,37,'Drain Health',42000,58),
(36,11,4,'Trick',126000,58),
(36,2,11,'Confusion',126000,58),
(36,105,15,'Freezing Strike',63000,58),
(36,105,16,'Freezing Strike',63000,58),
(36,106,6,'Veil',126000,58),
(36,115,9,'Power Break',126000,58),
(36,122,7,'Hex',126000,58),
(36,209,27,'Dagger Mastery',42000,58),
(36,209,28,'Dagger Mastery',42000,58),
(36,209,29,'Dagger Mastery',42000,58),
(36,223,31,'Sting',42000,58),
(36,223,32,'Sting',42000,58),
(36,223,33,'Sting',42000,58),
(36,233,29,'Light Armor Mastery',42000,58),
(36,233,30,'Light Armor Mastery',42000,58),
(36,233,31,'Light Armor Mastery',42000,58),
(36,263,19,'Deadly Blow',42000,58),
(36,263,20,'Deadly Blow',42000,58),
(36,263,21,'Deadly Blow',42000,58),
(36,412,2,'Sand Bomb',126000,58),
(36,410,1,'Mortal Strike',126000,58),
(36,419,2,'Summon Treasure Key',126000,58),
(36,312,12,'Vicious Stance',126000,58),
(36,198,3,'Boost Evasion',126000,58),
(36,129,3,'Poison',126000,58),
(36,96,4,'Bleed',126000,58),
(36,312,13,'Vicious Stance',181000,60),
(36,453,1,'Escape Shackle',181000,60),
(36,412,3,'Sand Bomb',181000,60),
(36,263,22,'Deadly Blow',91000,60),
(36,263,23,'Deadly Blow',91000,60),
(36,233,32,'Light Armor Mastery',91000,60),
(36,233,33,'Light Armor Mastery',91000,60),
(36,223,34,'Sting',91000,60),
(36,223,35,'Sting',91000,60),
(36,209,30,'Dagger Mastery',91000,60),
(36,209,31,'Dagger Mastery',91000,60),
(36,122,8,'Hex',181000,60),
(36,115,10,'Power Break',181000,60),
(36,106,7,'Veil',181000,60),
(36,27,11,'Unlock',181000,60),
(36,105,17,'Freezing Strike',181000,60),
(36,2,12,'Confusion',181000,60),
(36,11,5,'Trick',181000,60),
(36,70,38,'Drain Health',91000,60),
(36,70,39,'Drain Health',91000,60),
(36,30,22,'Backstab',91000,60),
(36,30,23,'Backstab',91000,60),
(36,30,24,'Backstab',130000,62),
(36,30,25,'Backstab',130000,62),
(36,70,40,'Drain Health',130000,62),
(36,70,41,'Drain Health',130000,62),
(36,11,6,'Trick',270000,62),
(36,2,13,'Confusion',270000,62),
(36,105,18,'Freezing Strike',270000,62),
(36,106,8,'Veil',270000,62),
(36,115,11,'Power Break',270000,62),
(36,122,9,'Hex',270000,62),
(36,209,32,'Dagger Mastery',130000,62),
(36,209,33,'Dagger Mastery',130000,62),
(36,223,36,'Sting',130000,62),
(36,223,37,'Sting',130000,62),
(36,233,34,'Light Armor Mastery',130000,62),
(36,233,35,'Light Armor Mastery',130000,62),
(36,263,24,'Deadly Blow',130000,62),
(36,263,25,'Deadly Blow',130000,62),
(36,412,4,'Sand Bomb',270000,62),
(36,312,14,'Vicious Stance',270000,62),
(36,171,6,'Esprit',270000,62),
(36,312,15,'Vicious Stance',300000,64),
(36,193,5,'Critical Power',300000,64),
(36,412,5,'Sand Bomb',300000,64),
(36,263,26,'Deadly Blow',150000,64),
(36,263,27,'Deadly Blow',150000,64),
(36,233,36,'Light Armor Mastery',150000,64),
(36,233,37,'Light Armor Mastery',150000,64),
(36,223,38,'Sting',150000,64),
(36,223,39,'Sting',150000,64),
(36,209,34,'Dagger Mastery',150000,64),
(36,209,35,'Dagger Mastery',150000,64),
(36,122,10,'Hex',300000,64),
(36,115,12,'Power Break',300000,64),
(36,106,9,'Veil',300000,64),
(36,27,12,'Unlock',300000,64),
(36,105,19,'Freezing Strike',300000,64),
(36,2,14,'Confusion',300000,64),
(36,11,7,'Trick',300000,64),
(36,70,42,'Drain Health',150000,64),
(36,70,43,'Drain Health',150000,64),
(36,30,26,'Backstab',150000,64),
(36,30,27,'Backstab',150000,64),
(36,30,28,'Backstab',180000,66),
(36,30,29,'Backstab',180000,66),
(36,70,44,'Drain Health',180000,66),
(36,70,45,'Drain Health',180000,66),
(36,11,8,'Trick',370000,66),
(36,2,15,'Confusion',370000,66),
(36,105,20,'Freezing Strike',370000,66),
(36,106,10,'Veil',370000,66),
(36,115,13,'Power Break',370000,66),
(36,122,11,'Hex',370000,66),
(36,209,36,'Dagger Mastery',180000,66),
(36,209,37,'Dagger Mastery',180000,66),
(36,223,40,'Sting',180000,66),
(36,223,41,'Sting',180000,66),
(36,233,38,'Light Armor Mastery',180000,66),
(36,233,39,'Light Armor Mastery',180000,66),
(36,263,28,'Deadly Blow',180000,66),
(36,263,29,'Deadly Blow',180000,66),
(36,412,6,'Sand Bomb',370000,66),
(36,321,1,'Blinding Blow',180000,66),
(36,321,2,'Blinding Blow',180000,66),
(36,419,3,'Summon Treasure Key',370000,66),
(36,410,2,'Mortal Strike',370000,66),
(36,312,16,'Vicious Stance',370000,66),
(36,96,5,'Bleed',370000,66),
(36,129,4,'Poison',370000,66),
(36,171,7,'Esprit',460000,68),
(36,312,17,'Vicious Stance',460000,68),
(36,321,3,'Blinding Blow',230000,68),
(36,321,4,'Blinding Blow',230000,68),
(36,412,7,'Sand Bomb',460000,68),
(36,263,30,'Deadly Blow',230000,68),
(36,263,31,'Deadly Blow',230000,68),
(36,233,40,'Light Armor Mastery',230000,68),
(36,233,41,'Light Armor Mastery',230000,68),
(36,223,42,'Sting',230000,68),
(36,223,43,'Sting',230000,68),
(36,209,38,'Dagger Mastery',230000,68),
(36,209,39,'Dagger Mastery',230000,68),
(36,122,12,'Hex',460000,68),
(36,115,14,'Power Break',460000,68),
(36,106,11,'Veil',460000,68),
(36,27,13,'Unlock',460000,68),
(36,105,21,'Freezing Strike',460000,68),
(36,2,16,'Confusion',460000,68),
(36,11,9,'Trick',460000,68),
(36,70,46,'Drain Health',230000,68),
(36,70,47,'Drain Health',230000,68),
(36,30,30,'Backstab',230000,68),
(36,30,31,'Backstab',230000,68),
(36,30,32,'Backstab',290000,70),
(36,30,33,'Backstab',290000,70),
(36,70,48,'Drain Health',290000,70),
(36,70,49,'Drain Health',290000,70),
(36,11,10,'Trick',580000,70),
(36,2,17,'Confusion',580000,70),
(36,105,22,'Freezing Strike',580000,70),
(36,106,12,'Veil',580000,70),
(36,115,15,'Power Break',580000,70),
(36,122,13,'Hex',580000,70),
(36,209,40,'Dagger Mastery',290000,70),
(36,209,41,'Dagger Mastery',290000,70),
(36,223,44,'Sting',290000,70),
(36,223,45,'Sting',290000,70),
(36,233,42,'Light Armor Mastery',290000,70),
(36,233,43,'Light Armor Mastery',290000,70),
(36,263,32,'Deadly Blow',290000,70),
(36,263,33,'Deadly Blow',290000,70),
(36,412,8,'Sand Bomb',580000,70),
(36,321,5,'Blinding Blow',290000,70),
(36,321,6,'Blinding Blow',290000,70),
(36,312,18,'Vicious Stance',580000,70),
(36,96,6,'Bleed',580000,70),
(36,312,19,'Vicious Stance',710000,72),
(36,193,6,'Critical Power',710000,72),
(36,321,7,'Blinding Blow',350000,72),
(36,321,8,'Blinding Blow',350000,72),
(36,412,9,'Sand Bomb',710000,72),
(36,263,34,'Deadly Blow',350000,72),
(36,263,35,'Deadly Blow',350000,72),
(36,233,44,'Light Armor Mastery',350000,72),
(36,233,45,'Light Armor Mastery',350000,72),
(36,223,46,'Sting',350000,72),
(36,223,47,'Sting',350000,72),
(36,209,42,'Dagger Mastery',350000,72),
(36,209,43,'Dagger Mastery',350000,72),
(36,122,14,'Hex',710000,72),
(36,115,16,'Power Break',710000,72),
(36,106,13,'Veil',710000,72),
(36,27,14,'Unlock',710000,72),
(36,105,23,'Freezing Strike',710000,72),
(36,2,18,'Confusion',710000,72),
(36,11,11,'Trick',710000,72),
(36,70,50,'Drain Health',350000,72),
(36,70,51,'Drain Health',350000,72),
(36,30,34,'Backstab',350000,72),
(36,30,35,'Backstab',350000,72),
(36,193,7,'Critical Power',1180000,74),
(36,30,36,'Backstab',680000,74),
(36,30,37,'Backstab',680000,74),
(36,70,52,'Drain Health',680000,74),
(36,70,53,'Drain Health',680000,74),
(36,11,12,'Trick',1370000,74),
(36,2,19,'Confusion',1370000,74),
(36,105,24,'Freezing Strike',1370000,74),
(36,106,14,'Veil',1370000,74),
(36,115,17,'Power Break',1370000,74),
(36,122,15,'Hex',1370000,74),
(36,209,44,'Dagger Mastery',680000,74),
(36,209,45,'Dagger Mastery',680000,74),
(36,223,48,'Sting',680000,74),
(36,223,49,'Sting',680000,74),
(36,233,46,'Light Armor Mastery',680000,74),
(36,233,47,'Light Armor Mastery',680000,74),
(36,263,36,'Deadly Blow',680000,74),
(36,263,37,'Deadly Blow',680000,74),
(36,412,10,'Sand Bomb',1370000,74),
(36,321,9,'Blinding Blow',680000,74),
(36,321,10,'Blinding Blow',680000,74),
(36,410,3,'Mortal Strike',1370000,74),
(36,419,4,'Summon Treasure Key',1370000,74),
(36,623,1,'Find Trap',1180000,74),
(36,624,1,'Remove Trap',1180000,74),
(36,312,20,'Vicious Stance',1370000,74),
(36,129,5,'Poison',1370000,74),
(36,171,8,'Esprit',1370000,74),
(37,19,1,'Double Shot',11000,40),
(37,19,2,'Double Shot',11000,40),
(37,19,3,'Double Shot',11000,40),
(37,70,17,'Drain Health',11000,40),
(37,70,18,'Drain Health',11000,40),
(37,70,19,'Drain Health',11000,40),
(37,101,4,'Stunning Shot',11000,40),
(37,101,5,'Stunning Shot',11000,40),
(37,101,6,'Stunning Shot',11000,40),
(37,105,3,'Freezing Strike',16000,40),
(37,105,4,'Freezing Strike',16000,40),
(37,113,2,'Long Shot',33000,40),
(37,115,3,'Power Break',33000,40),
(37,208,16,'Bow Mastery',11000,40),
(37,208,17,'Bow Mastery',11000,40),
(37,208,18,'Bow Mastery',11000,40),
(37,223,13,'Sting',11000,40),
(37,223,14,'Sting',11000,40),
(37,223,15,'Sting',11000,40),
(37,233,11,'Light Armor Mastery',11000,40),
(37,233,12,'Light Armor Mastery',11000,40),
(37,233,13,'Light Armor Mastery',11000,40),
(37,2,5,'Confusion',33000,40),
(37,122,1,'Hex',33000,40),
(37,312,6,'Vicious Stance',33000,40),
(37,312,7,'Vicious Stance',33000,43),
(37,225,2,'Acrobatic Move',33000,43),
(37,122,2,'Hex',33000,43),
(37,2,6,'Confusion',33000,43),
(37,169,2,'Quick Step',33000,43),
(37,171,2,'Esprit',33000,43),
(37,233,14,'Light Armor Mastery',11000,43),
(37,233,15,'Light Armor Mastery',11000,43),
(37,233,16,'Light Armor Mastery',11000,43),
(37,223,16,'Sting',11000,43),
(37,223,17,'Sting',11000,43),
(37,223,18,'Sting',11000,43),
(37,208,19,'Bow Mastery',11000,43),
(37,208,20,'Bow Mastery',11000,43),
(37,208,21,'Bow Mastery',11000,43),
(37,115,4,'Power Break',33000,43),
(37,105,5,'Freezing Strike',16000,43),
(37,105,6,'Freezing Strike',16000,43),
(37,101,7,'Stunning Shot',11000,43),
(37,101,8,'Stunning Shot',11000,43),
(37,101,9,'Stunning Shot',11000,43),
(37,70,20,'Drain Health',11000,43),
(37,70,21,'Drain Health',11000,43),
(37,70,22,'Drain Health',11000,43),
(37,19,4,'Double Shot',11000,43),
(37,19,5,'Double Shot',11000,43),
(37,19,6,'Double Shot',11000,43),
(37,19,7,'Double Shot',15000,46),
(37,19,8,'Double Shot',15000,46),
(37,19,9,'Double Shot',15000,46),
(37,70,23,'Drain Health',15000,46),
(37,70,24,'Drain Health',15000,46),
(37,70,25,'Drain Health',15000,46),
(37,101,10,'Stunning Shot',15000,46),
(37,101,11,'Stunning Shot',15000,46),
(37,101,12,'Stunning Shot',15000,46),
(37,105,7,'Freezing Strike',23000,46),
(37,105,8,'Freezing Strike',23000,46),
(37,115,5,'Power Break',46000,46),
(37,208,22,'Bow Mastery',15000,46),
(37,208,23,'Bow Mastery',15000,46),
(37,208,24,'Bow Mastery',15000,46),
(37,223,19,'Sting',15000,46),
(37,223,20,'Sting',15000,46),
(37,223,21,'Sting',15000,46),
(37,233,17,'Light Armor Mastery',15000,46),
(37,233,18,'Light Armor Mastery',15000,46),
(37,233,19,'Light Armor Mastery',15000,46),
(37,171,3,'Esprit',46000,46),
(37,303,1,'Soul of Sagittarius',46000,46),
(37,2,7,'Confusion',46000,46),
(37,122,3,'Hex',46000,46),
(37,312,8,'Vicious Stance',46000,46),
(37,312,9,'Vicious Stance',75000,49),
(37,122,4,'Hex',75000,49),
(37,2,8,'Confusion',75000,49),
(37,129,2,'Poison',75000,49),
(37,171,4,'Esprit',75000,49),
(37,233,20,'Light Armor Mastery',25000,49),
(37,233,21,'Light Armor Mastery',25000,49),
(37,233,22,'Light Armor Mastery',25000,49),
(37,223,22,'Sting',25000,49),
(37,223,23,'Sting',25000,49),
(37,223,24,'Sting',25000,49),
(37,208,25,'Bow Mastery',25000,49),
(37,208,26,'Bow Mastery',25000,49),
(37,208,27,'Bow Mastery',25000,49),
(37,115,6,'Power Break',75000,49),
(37,105,9,'Freezing Strike',38000,49),
(37,105,10,'Freezing Strike',38000,49),
(37,101,13,'Stunning Shot',25000,49),
(37,101,14,'Stunning Shot',25000,49),
(37,101,15,'Stunning Shot',25000,49),
(37,70,26,'Drain Health',25000,49),
(37,70,27,'Drain Health',25000,49),
(37,70,28,'Drain Health',25000,49),
(37,19,10,'Double Shot',25000,49),
(37,19,11,'Double Shot',25000,49),
(37,19,12,'Double Shot',25000,49),
(37,19,13,'Double Shot',42000,52),
(37,19,14,'Double Shot',42000,52),
(37,19,15,'Double Shot',42000,52),
(37,70,29,'Drain Health',42000,52),
(37,70,30,'Drain Health',42000,52),
(37,70,31,'Drain Health',42000,52),
(37,101,16,'Stunning Shot',42000,52),
(37,101,17,'Stunning Shot',42000,52),
(37,101,18,'Stunning Shot',42000,52),
(37,105,11,'Freezing Strike',63000,52),
(37,105,12,'Freezing Strike',63000,52),
(37,115,7,'Power Break',125000,52),
(37,208,28,'Bow Mastery',42000,52),
(37,208,29,'Bow Mastery',42000,52),
(37,208,30,'Bow Mastery',42000,52),
(37,223,25,'Sting',42000,52),
(37,223,26,'Sting',42000,52),
(37,223,27,'Sting',42000,52),
(37,233,23,'Light Armor Mastery',42000,52),
(37,233,24,'Light Armor Mastery',42000,52),
(37,233,25,'Light Armor Mastery',42000,52),
(37,171,5,'Esprit',125000,52),
(37,2,9,'Confusion',125000,52),
(37,122,5,'Hex',125000,52),
(37,312,10,'Vicious Stance',125000,52),
(37,312,11,'Vicious Stance',154000,55),
(37,225,3,'Acrobatic Move',154000,55),
(37,99,2,'Rapid Shot',154000,55),
(37,122,6,'Hex',154000,55),
(37,2,10,'Confusion',154000,55),
(37,233,26,'Light Armor Mastery',51000,55),
(37,233,27,'Light Armor Mastery',51000,55),
(37,233,28,'Light Armor Mastery',51000,55),
(37,223,28,'Sting',51000,55),
(37,223,29,'Sting',51000,55),
(37,223,30,'Sting',51000,55),
(37,208,31,'Bow Mastery',51000,55),
(37,208,32,'Bow Mastery',51000,55),
(37,208,33,'Bow Mastery',51000,55),
(37,115,8,'Power Break',154000,55),
(37,105,13,'Freezing Strike',77000,55),
(37,105,14,'Freezing Strike',77000,55),
(37,101,19,'Stunning Shot',51000,55),
(37,101,20,'Stunning Shot',51000,55),
(37,101,21,'Stunning Shot',51000,55),
(37,70,32,'Drain Health',51000,55),
(37,70,33,'Drain Health',51000,55),
(37,70,34,'Drain Health',51000,55),
(37,19,16,'Double Shot',51000,55),
(37,19,17,'Double Shot',51000,55),
(37,19,18,'Double Shot',51000,55),
(37,19,19,'Double Shot',58000,58),
(37,19,20,'Double Shot',58000,58),
(37,19,21,'Double Shot',58000,58),
(37,70,35,'Drain Health',58000,58),
(37,70,36,'Drain Health',58000,58),
(37,70,37,'Drain Health',58000,58),
(37,101,22,'Stunning Shot',58000,58),
(37,101,23,'Stunning Shot',58000,58),
(37,101,24,'Stunning Shot',58000,58),
(37,105,15,'Freezing Strike',87000,58),
(37,105,16,'Freezing Strike',87000,58),
(37,115,9,'Power Break',173000,58),
(37,208,34,'Bow Mastery',58000,58),
(37,208,35,'Bow Mastery',58000,58),
(37,208,36,'Bow Mastery',58000,58),
(37,223,31,'Sting',58000,58),
(37,223,32,'Sting',58000,58),
(37,223,33,'Sting',58000,58),
(37,233,29,'Light Armor Mastery',58000,58),
(37,233,30,'Light Armor Mastery',58000,58),
(37,233,31,'Light Armor Mastery',58000,58),
(37,2,11,'Confusion',173000,58),
(37,122,7,'Hex',173000,58),
(37,129,3,'Poison',173000,58),
(37,303,2,'Soul of Sagittarius',173000,58),
(37,415,1,'Spirit of Sagittarius',173000,58),
(37,417,1,'Pain of Sagittarius',173000,58),
(37,312,12,'Vicious Stance',173000,58),
(37,312,13,'Vicious Stance',220000,60),
(37,414,1,'Dead Eye',220000,60),
(37,314,1,'Fatal Counter',110000,60),
(37,314,2,'Fatal Counter',110000,60),
(37,122,8,'Hex',220000,60),
(37,2,12,'Confusion',220000,60),
(37,233,32,'Light Armor Mastery',110000,60),
(37,233,33,'Light Armor Mastery',110000,60),
(37,223,34,'Sting',110000,60),
(37,223,35,'Sting',110000,60),
(37,208,37,'Bow Mastery',110000,60),
(37,208,38,'Bow Mastery',110000,60),
(37,115,10,'Power Break',220000,60),
(37,105,17,'Freezing Strike',220000,60),
(37,101,25,'Stunning Shot',110000,60),
(37,101,26,'Stunning Shot',110000,60),
(37,70,38,'Drain Health',110000,60),
(37,70,39,'Drain Health',110000,60),
(37,19,22,'Double Shot',110000,60),
(37,19,23,'Double Shot',110000,60),
(37,19,24,'Double Shot',130000,62),
(37,19,25,'Double Shot',130000,62),
(37,70,40,'Drain Health',130000,62),
(37,70,41,'Drain Health',130000,62),
(37,101,27,'Stunning Shot',130000,62),
(37,101,28,'Stunning Shot',130000,62),
(37,105,18,'Freezing Strike',270000,62),
(37,115,11,'Power Break',270000,62),
(37,208,39,'Bow Mastery',130000,62),
(37,208,40,'Bow Mastery',130000,62),
(37,223,36,'Sting',130000,62),
(37,223,37,'Sting',130000,62),
(37,233,34,'Light Armor Mastery',130000,62),
(37,233,35,'Light Armor Mastery',130000,62),
(37,2,13,'Confusion',270000,62),
(37,122,9,'Hex',270000,62),
(37,171,6,'Esprit',270000,62),
(37,314,3,'Fatal Counter',130000,62),
(37,314,4,'Fatal Counter',130000,62),
(37,414,2,'Dead Eye',270000,62),
(37,312,14,'Vicious Stance',270000,62),
(37,417,2,'Pain of Sagittarius',270000,62),
(37,312,15,'Vicious Stance',340000,64),
(37,414,3,'Dead Eye',340000,64),
(37,314,5,'Fatal Counter',170000,64),
(37,314,6,'Fatal Counter',170000,64),
(37,303,3,'Soul of Sagittarius',340000,64),
(37,122,10,'Hex',340000,64),
(37,2,14,'Confusion',340000,64),
(37,233,36,'Light Armor Mastery',170000,64),
(37,233,37,'Light Armor Mastery',170000,64),
(37,223,38,'Sting',170000,64),
(37,223,39,'Sting',170000,64),
(37,208,41,'Bow Mastery',170000,64),
(37,208,42,'Bow Mastery',170000,64),
(37,115,12,'Power Break',340000,64),
(37,105,19,'Freezing Strike',340000,64),
(37,101,29,'Stunning Shot',170000,64),
(37,101,30,'Stunning Shot',170000,64),
(37,70,42,'Drain Health',170000,64),
(37,70,43,'Drain Health',170000,64),
(37,19,26,'Double Shot',170000,64),
(37,19,27,'Double Shot',170000,64),
(37,19,28,'Double Shot',210000,66),
(37,19,29,'Double Shot',210000,66),
(37,70,44,'Drain Health',210000,66),
(37,70,45,'Drain Health',210000,66),
(37,101,31,'Stunning Shot',210000,66),
(37,101,32,'Stunning Shot',210000,66),
(37,105,20,'Freezing Strike',410000,66),
(37,115,13,'Power Break',410000,66),
(37,208,43,'Bow Mastery',210000,66),
(37,208,44,'Bow Mastery',210000,66),
(37,223,40,'Sting',210000,66),
(37,223,41,'Sting',210000,66),
(37,233,38,'Light Armor Mastery',210000,66),
(37,233,39,'Light Armor Mastery',210000,66),
(37,2,15,'Confusion',410000,66),
(37,122,11,'Hex',410000,66),
(37,129,4,'Poison',410000,66),
(37,314,7,'Fatal Counter',210000,66),
(37,314,8,'Fatal Counter',210000,66),
(37,414,4,'Dead Eye',410000,66),
(37,312,16,'Vicious Stance',410000,66),
(37,417,3,'Pain of Sagittarius',410000,66),
(37,323,1,'Quiver of Arrow: Grade A',410000,66),
(37,415,2,'Spirit of Sagittarius',410000,66),
(37,312,17,'Vicious Stance',560000,68),
(37,414,5,'Dead Eye',560000,68),
(37,314,9,'Fatal Counter',280000,68),
(37,314,10,'Fatal Counter',280000,68),
(37,171,7,'Esprit',560000,68),
(37,122,12,'Hex',560000,68),
(37,2,16,'Confusion',560000,68),
(37,233,40,'Light Armor Mastery',280000,68),
(37,233,41,'Light Armor Mastery',280000,68),
(37,223,42,'Sting',280000,68),
(37,223,43,'Sting',280000,68),
(37,208,45,'Bow Mastery',280000,68),
(37,208,46,'Bow Mastery',280000,68),
(37,115,14,'Power Break',560000,68),
(37,105,21,'Freezing Strike',560000,68),
(37,101,33,'Stunning Shot',280000,68),
(37,101,34,'Stunning Shot',280000,68),
(37,70,46,'Drain Health',280000,68),
(37,70,47,'Drain Health',280000,68),
(37,19,30,'Double Shot',280000,68),
(37,19,31,'Double Shot',280000,68),
(37,19,32,'Double Shot',310000,70),
(37,19,33,'Double Shot',310000,70),
(37,70,48,'Drain Health',310000,70),
(37,70,49,'Drain Health',310000,70),
(37,101,35,'Stunning Shot',310000,70),
(37,101,36,'Stunning Shot',310000,70),
(37,105,22,'Freezing Strike',620000,70),
(37,115,15,'Power Break',620000,70),
(37,208,47,'Bow Mastery',310000,70),
(37,208,48,'Bow Mastery',310000,70),
(37,223,44,'Sting',310000,70),
(37,223,45,'Sting',310000,70),
(37,233,42,'Light Armor Mastery',310000,70),
(37,233,43,'Light Armor Mastery',310000,70),
(37,2,17,'Confusion',620000,70),
(37,122,13,'Hex',620000,70),
(37,303,4,'Soul of Sagittarius',620000,70),
(37,314,11,'Fatal Counter',310000,70),
(37,314,12,'Fatal Counter',310000,70),
(37,414,6,'Dead Eye',620000,70),
(37,312,18,'Vicious Stance',620000,70),
(37,417,4,'Pain of Sagittarius',620000,70),
(37,324,1,'Quiver of Arrow: Grade S',860000,72),
(37,312,19,'Vicious Stance',860000,72),
(37,414,7,'Dead Eye',860000,72),
(37,314,13,'Fatal Counter',430000,72),
(37,314,14,'Fatal Counter',430000,72),
(37,122,14,'Hex',860000,72),
(37,2,18,'Confusion',860000,72),
(37,233,44,'Light Armor Mastery',430000,72),
(37,233,45,'Light Armor Mastery',430000,72),
(37,223,46,'Sting',430000,72),
(37,223,47,'Sting',430000,72),
(37,208,49,'Bow Mastery',430000,72),
(37,208,50,'Bow Mastery',430000,72),
(37,115,16,'Power Break',860000,72),
(37,105,23,'Freezing Strike',860000,72),
(37,101,37,'Stunning Shot',430000,72),
(37,101,38,'Stunning Shot',430000,72),
(37,70,50,'Drain Health',430000,72),
(37,70,51,'Drain Health',430000,72),
(37,19,34,'Double Shot',430000,72),
(37,19,35,'Double Shot',430000,72),
(37,933,1,'Detection',1440000,74),
(37,19,36,'Double Shot',760000,74),
(37,19,37,'Double Shot',760000,74),
(37,70,52,'Drain Health',760000,74),
(37,70,53,'Drain Health',760000,74),
(37,101,39,'Stunning Shot',760000,74),
(37,101,40,'Stunning Shot',760000,74),
(37,105,24,'Freezing Strike',1530000,74),
(37,115,17,'Power Break',1530000,74),
(37,208,51,'Bow Mastery',760000,74),
(37,208,52,'Bow Mastery',760000,74),
(37,223,48,'Sting',760000,74),
(37,223,49,'Sting',760000,74),
(37,233,46,'Light Armor Mastery',760000,74),
(37,233,47,'Light Armor Mastery',760000,74),
(37,2,19,'Confusion',1530000,74),
(37,122,15,'Hex',1530000,74),
(37,129,5,'Poison',1530000,74),
(37,171,8,'Esprit',1530000,74),
(37,314,15,'Fatal Counter',760000,74),
(37,314,16,'Fatal Counter',760000,74),
(37,414,8,'Dead Eye',1530000,74),
(37,312,20,'Vicious Stance',1530000,74),
(37,417,5,'Pain of Sagittarius',1530000,74),
(37,415,3,'Spirit of Sagittarius',1530000,74),
(38,163,1,'Spellcraft',0,1),
(38,214,1,'Mana Recovery',0,1),
(38,118,1,'Magician\'s Movement',0,1),
(38,1177,1,'Wind Strike',0,1),
(38,1216,1,'Self Heal',0,1),
(38,1184,1,'Ice Bolt',240,7),
(38,1184,2,'Ice Bolt',240,7),
(38,1168,1,'Curse: Poison',470,7),
(38,1177,2,'Wind Strike',240,7),
(38,1177,3,'Wind Strike',240,7),
(38,1040,1,'Shield',470,7),
(38,1068,1,'Might',470,7),
(38,1011,1,'Heal',160,7),
(38,1011,2,'Heal',160,7),
(38,1011,3,'Heal',160,7),
(38,1012,1,'Cure Poison',470,7),
(38,146,1,'Anti Magic',240,7),
(38,146,2,'Anti Magic',240,7),
(38,244,1,'Armor Mastery',470,7),
(38,249,1,'Weapon Mastery',470,7),
(38,249,2,'Weapon Mastery',2100,14),
(38,244,2,'Armor Mastery',1100,14),
(38,244,3,'Armor Mastery',1100,14),
(38,146,3,'Anti Magic',1100,14),
(38,146,4,'Anti Magic',1100,14),
(38,1015,1,'Battle Heal',700,14),
(38,1015,2,'Battle Heal',700,14),
(38,1015,3,'Battle Heal',700,14),
(38,1027,1,'Group Heal',700,14),
(38,1027,2,'Group Heal',700,14),
(38,1027,3,'Group Heal',700,14),
(38,1011,4,'Heal',700,14),
(38,1011,5,'Heal',700,14),
(38,1011,6,'Heal',700,14),
(38,1147,1,'Vampiric Touch',1100,14),
(38,1147,2,'Vampiric Touch',1100,14),
(38,1177,4,'Wind Strike',1100,14),
(38,1177,5,'Wind Strike',1100,14),
(38,1184,3,'Ice Bolt',1100,14),
(38,1184,4,'Ice Bolt',1100,14),
(38,1206,1,'Wind Shackle',2100,14),
(39,146,5,'Anti Magic',1500,20),
(39,146,6,'Anti Magic',1500,20),
(39,234,1,'Robe Mastery',1500,20),
(39,234,2,'Robe Mastery',1500,20),
(39,164,1,'Quick Recycle',3100,20),
(39,213,1,'Boost Mana',3100,20),
(39,249,3,'Weapon Mastery',3100,20),
(39,285,1,'Higher Mana Gain',1500,20),
(39,285,2,'Higher Mana Gain',1500,20),
(39,1078,1,'Concentration',3100,20),
(39,1127,1,'Servitor Heal',1000,20),
(39,1127,2,'Servitor Heal',1000,20),
(39,1127,3,'Servitor Heal',1000,20),
(39,1128,1,'Summon Shadow',3100,20),
(39,1147,3,'Vampiric Touch',1500,20),
(39,1147,4,'Vampiric Touch',1500,20),
(39,1172,1,'Aura Burn',1500,20),
(39,1172,2,'Aura Burn',1500,20),
(39,1178,1,'Twister',1500,20),
(39,1178,2,'Twister',1500,20),
(39,1168,2,'Curse: Poison',3100,20),
(39,1181,1,'Flame Strike',3100,20),
(39,1184,5,'Ice Bolt',1500,20),
(39,1184,6,'Ice Bolt',1500,20),
(39,1206,2,'Wind Shackle',3100,20),
(39,1228,1,'Summon Silhouette',3100,20),
(39,1228,2,'Summon Silhouette',5500,25),
(39,1206,3,'Wind Shackle',5500,25),
(39,1181,2,'Flame Strike',5500,25),
(39,1157,1,'Body To Mind',5500,25),
(39,1167,1,'Poisonous Cloud',5500,25),
(39,1178,3,'Twister',2800,25),
(39,1178,4,'Twister',2800,25),
(39,1172,3,'Aura Burn',2800,25),
(39,1172,4,'Aura Burn',2800,25),
(39,1224,1,'Surrender To Poison',5500,25),
(39,1266,1,'Shadow Spark',5500,25),
(39,1147,5,'Vampiric Touch',2800,25),
(39,1147,6,'Vampiric Touch',2800,25),
(39,1128,2,'Summon Shadow',5500,25),
(39,1127,4,'Servitor Heal',1800,25),
(39,1127,5,'Servitor Heal',1800,25),
(39,1127,6,'Servitor Heal',1800,25),
(39,228,1,'Fast Spell Casting',5500,25),
(39,229,1,'Fast Mana Recovery',5500,25),
(39,1126,1,'Servitor Recharge',2800,25),
(39,1126,2,'Servitor Recharge',2800,25),
(39,1069,1,'Sleep',1800,25),
(39,1069,2,'Sleep',1800,25),
(39,1069,3,'Sleep',1800,25),
(39,285,3,'Higher Mana Gain',2800,25),
(39,285,4,'Higher Mana Gain',2800,25),
(39,249,4,'Weapon Mastery',2800,25),
(39,249,5,'Weapon Mastery',2800,25),
(39,234,3,'Robe Mastery',2800,25),
(39,234,4,'Robe Mastery',2800,25),
(39,146,7,'Anti Magic',2800,25),
(39,146,8,'Anti Magic',2800,25),
(39,146,9,'Anti Magic',5300,30),
(39,146,10,'Anti Magic',5300,30),
(39,234,5,'Robe Mastery',5300,30),
(39,234,6,'Robe Mastery',5300,30),
(39,249,6,'Weapon Mastery',5300,30),
(39,249,7,'Weapon Mastery',5300,30),
(39,213,2,'Boost Mana',10500,30),
(39,164,2,'Quick Recycle',10500,30),
(39,285,5,'Higher Mana Gain',5300,30),
(39,285,6,'Higher Mana Gain',5300,30),
(39,1069,4,'Sleep',3500,30),
(39,1069,5,'Sleep',3500,30),
(39,1069,6,'Sleep',3500,30),
(39,1126,3,'Servitor Recharge',5300,30),
(39,1126,4,'Servitor Recharge',5300,30),
(39,1078,2,'Concentration',10500,30),
(39,1127,7,'Servitor Heal',3500,30),
(39,1127,8,'Servitor Heal',3500,30),
(39,1127,9,'Servitor Heal',3500,30),
(39,1128,3,'Summon Shadow',10500,30),
(39,1151,1,'Corpse Life Drain',10500,30),
(39,1266,2,'Shadow Spark',10500,30),
(39,1224,2,'Surrender To Poison',10500,30),
(39,1172,5,'Aura Burn',5300,30),
(39,1172,6,'Aura Burn',5300,30),
(39,1178,5,'Twister',5300,30),
(39,1178,6,'Twister',5300,30),
(39,1181,3,'Flame Strike',10500,30),
(39,1168,3,'Curse: Poison',10500,30),
(39,1206,4,'Wind Shackle',10500,30),
(39,1228,3,'Summon Silhouette',10500,30),
(39,1228,4,'Summon Silhouette',17600,35),
(39,1206,5,'Wind Shackle',17600,35),
(39,1222,1,'Curse Chaos',17600,35),
(39,1167,2,'Poisonous Cloud',17600,35),
(39,1160,1,'Slow',17600,35),
(39,1178,7,'Twister',8800,35),
(39,1178,8,'Twister',8800,35),
(39,1172,7,'Aura Burn',8800,35),
(39,1172,8,'Aura Burn',8800,35),
(39,1224,3,'Surrender To Poison',17600,35),
(39,1266,3,'Shadow Spark',17600,35),
(39,1151,2,'Corpse Life Drain',17600,35),
(39,1128,4,'Summon Shadow',17600,35),
(39,1146,1,'Mighty Servitor',17600,35),
(39,1127,10,'Servitor Heal',5900,35),
(39,1127,11,'Servitor Heal',5900,35),
(39,1127,12,'Servitor Heal',5900,35),
(39,229,2,'Fast Mana Recovery',17600,35),
(39,1126,5,'Servitor Recharge',8800,35),
(39,1126,6,'Servitor Recharge',8800,35),
(39,1069,7,'Sleep',5900,35),
(39,1069,8,'Sleep',5900,35),
(39,1069,9,'Sleep',5900,35),
(39,285,7,'Higher Mana Gain',8800,35),
(39,285,8,'Higher Mana Gain',8800,35),
(39,212,1,'Fast HP Recovery',17600,35),
(39,249,8,'Weapon Mastery',8800,35),
(39,249,9,'Weapon Mastery',8800,35),
(39,234,7,'Robe Mastery',8800,35),
(39,234,8,'Robe Mastery',8800,35),
(39,146,11,'Anti Magic',8800,35),
(39,146,12,'Anti Magic',8800,35),
(40,146,13,'Anti Magic',9000,40),
(40,146,14,'Anti Magic',9000,40),
(40,146,15,'Anti Magic',9000,40),
(40,234,9,'Robe Mastery',9000,40),
(40,234,10,'Robe Mastery',9000,40),
(40,234,11,'Robe Mastery',9000,40),
(40,249,10,'Weapon Mastery',9000,40),
(40,249,11,'Weapon Mastery',9000,40),
(40,249,12,'Weapon Mastery',9000,40),
(40,285,9,'Higher Mana Gain',14000,40),
(40,285,10,'Higher Mana Gain',14000,40),
(40,213,3,'Boost Mana',28000,40),
(40,1064,1,'Silence',28000,40),
(40,1069,10,'Sleep',9000,40),
(40,1069,11,'Sleep',9000,40),
(40,1069,12,'Sleep',9000,40),
(40,1074,1,'Surrender To Wind',28000,40),
(40,1151,3,'Corpse Life Drain',28000,40),
(40,1157,2,'Body To Mind',28000,40),
(40,1160,2,'Slow',28000,40),
(40,1169,1,'Curse Fear',28000,40),
(40,1222,2,'Curse Chaos',28000,40),
(40,1224,4,'Surrender To Poison',28000,40),
(40,1234,1,'Vampiric Claw',14000,40),
(40,1234,2,'Vampiric Claw',14000,40),
(40,1239,1,'Hurricane',14000,40),
(40,1239,2,'Hurricane',14000,40),
(40,1267,1,'Shadow Flare',28000,40),
(40,1297,1,'Clear Mind',28000,40),
(40,228,2,'Fast Spell Casting',28000,40),
(40,1267,2,'Shadow Flare',37000,44),
(40,1239,3,'Hurricane',18000,44),
(40,1239,4,'Hurricane',18000,44),
(40,1234,3,'Vampiric Claw',18000,44),
(40,1234,4,'Vampiric Claw',18000,44),
(40,1224,5,'Surrender To Poison',37000,44),
(40,1222,3,'Curse Chaos',37000,44),
(40,1169,2,'Curse Fear',37000,44),
(40,1160,3,'Slow',37000,44),
(40,1168,4,'Curse: Poison',37000,44),
(40,229,3,'Fast Mana Recovery',37000,44),
(40,1151,4,'Corpse Life Drain',37000,44),
(40,1074,2,'Surrender To Wind',37000,44),
(40,1148,1,'Death Spike',37000,44),
(40,1069,13,'Sleep',12000,44),
(40,1069,14,'Sleep',12000,44),
(40,1069,15,'Sleep',12000,44),
(40,1064,2,'Silence',37000,44),
(40,212,2,'Fast HP Recovery',37000,44),
(40,285,11,'Higher Mana Gain',18000,44),
(40,285,12,'Higher Mana Gain',18000,44),
(40,249,13,'Weapon Mastery',12000,44),
(40,249,14,'Weapon Mastery',12000,44),
(40,249,15,'Weapon Mastery',12000,44),
(40,234,12,'Robe Mastery',12000,44),
(40,234,13,'Robe Mastery',12000,44),
(40,234,14,'Robe Mastery',12000,44),
(40,146,16,'Anti Magic',12000,44),
(40,146,17,'Anti Magic',12000,44),
(40,146,18,'Anti Magic',12000,44),
(40,146,19,'Anti Magic',19000,48),
(40,146,20,'Anti Magic',19000,48),
(40,146,21,'Anti Magic',19000,48),
(40,234,15,'Robe Mastery',19000,48),
(40,234,16,'Robe Mastery',19000,48),
(40,234,17,'Robe Mastery',19000,48),
(40,249,16,'Weapon Mastery',19000,48),
(40,249,17,'Weapon Mastery',19000,48),
(40,249,18,'Weapon Mastery',19000,48),
(40,285,13,'Higher Mana Gain',29000,48),
(40,285,14,'Higher Mana Gain',29000,48),
(40,213,4,'Boost Mana',57000,48),
(40,1064,3,'Silence',57000,48),
(40,1069,16,'Sleep',19000,48),
(40,1069,17,'Sleep',19000,48),
(40,1069,18,'Sleep',19000,48),
(40,1148,2,'Death Spike',57000,48),
(40,1074,3,'Surrender To Wind',57000,48),
(40,1151,5,'Corpse Life Drain',57000,48),
(40,1167,3,'Poisonous Cloud',57000,48),
(40,1160,4,'Slow',57000,48),
(40,1169,3,'Curse Fear',57000,48),
(40,1176,1,'Tempest',29000,48),
(40,1176,2,'Tempest',29000,48),
(40,1222,4,'Curse Chaos',57000,48),
(40,1224,6,'Surrender To Poison',57000,48),
(40,1234,5,'Vampiric Claw',29000,48),
(40,1234,6,'Vampiric Claw',29000,48),
(40,1239,5,'Hurricane',29000,48),
(40,1239,6,'Hurricane',29000,48),
(40,1267,3,'Shadow Flare',57000,48),
(40,1297,2,'Clear Mind',57000,48),
(40,164,3,'Quick Recycle',57000,48),
(40,1267,4,'Shadow Flare',82000,52),
(40,1239,7,'Hurricane',41000,52),
(40,1239,8,'Hurricane',41000,52),
(40,1234,7,'Vampiric Claw',41000,52),
(40,1234,8,'Vampiric Claw',41000,52),
(40,1224,7,'Surrender To Poison',82000,52),
(40,1222,5,'Curse Chaos',82000,52),
(40,1176,3,'Tempest',41000,52),
(40,1176,4,'Tempest',41000,52),
(40,1169,4,'Curse Fear',82000,52),
(40,1160,5,'Slow',82000,52),
(40,1168,5,'Curse: Poison',82000,52),
(40,1159,1,'Curse Death Link',41000,52),
(40,1159,2,'Curse Death Link',41000,52),
(40,1151,6,'Corpse Life Drain',82000,52),
(40,229,4,'Fast Mana Recovery',82000,52),
(40,1157,3,'Body To Mind',82000,52),
(40,1074,4,'Surrender To Wind',82000,52),
(40,1148,3,'Death Spike',82000,52),
(40,1069,19,'Sleep',27000,52),
(40,1069,20,'Sleep',27000,52),
(40,1069,21,'Sleep',27000,52),
(40,1064,4,'Silence',82000,52),
(40,212,3,'Fast HP Recovery',82000,52),
(40,285,15,'Higher Mana Gain',41000,52),
(40,285,16,'Higher Mana Gain',41000,52),
(40,249,19,'Weapon Mastery',27000,52),
(40,249,20,'Weapon Mastery',27000,52),
(40,249,21,'Weapon Mastery',27000,52),
(40,234,18,'Robe Mastery',27000,52),
(40,234,19,'Robe Mastery',27000,52),
(40,234,20,'Robe Mastery',27000,52),
(40,146,22,'Anti Magic',27000,52),
(40,146,23,'Anti Magic',27000,52),
(40,146,24,'Anti Magic',27000,52),
(40,146,25,'Anti Magic',30000,56),
(40,146,26,'Anti Magic',30000,56),
(40,146,27,'Anti Magic',30000,56),
(40,234,21,'Robe Mastery',30000,56),
(40,234,22,'Robe Mastery',30000,56),
(40,234,23,'Robe Mastery',30000,56),
(40,249,22,'Weapon Mastery',30000,56),
(40,249,23,'Weapon Mastery',30000,56),
(40,249,24,'Weapon Mastery',30000,56),
(40,285,17,'Higher Mana Gain',45000,56),
(40,285,18,'Higher Mana Gain',45000,56),
(40,213,5,'Boost Mana',91000,56),
(40,1064,5,'Silence',91000,56),
(40,1069,22,'Sleep',30000,56),
(40,1069,23,'Sleep',30000,56),
(40,1069,24,'Sleep',30000,56),
(40,1148,4,'Death Spike',91000,56),
(40,1074,5,'Surrender To Wind',91000,56),
(40,1151,7,'Corpse Life Drain',91000,56),
(40,1159,3,'Curse Death Link',45000,56),
(40,1159,4,'Curse Death Link',45000,56),
(40,1167,4,'Poisonous Cloud',91000,56),
(40,1160,6,'Slow',91000,56),
(40,1169,5,'Curse Fear',91000,56),
(40,1176,5,'Tempest',45000,56),
(40,1176,6,'Tempest',45000,56),
(40,1222,6,'Curse Chaos',91000,56),
(40,1224,8,'Surrender To Poison',91000,56),
(40,1234,9,'Vampiric Claw',45000,56),
(40,1234,10,'Vampiric Claw',45000,56),
(40,1239,9,'Hurricane',45000,56),
(40,1239,10,'Hurricane',45000,56),
(40,1267,5,'Shadow Flare',91000,56),
(40,1297,3,'Clear Mind',91000,56),
(40,228,3,'Fast Spell Casting',91000,56),
(40,1417,1,'Aura Flash',105000,58),
(40,1267,6,'Shadow Flare',105000,58),
(40,1239,11,'Hurricane',52000,58),
(40,1239,12,'Hurricane',52000,58),
(40,1234,11,'Vampiric Claw',52000,58),
(40,1234,12,'Vampiric Claw',52000,58),
(40,1224,9,'Surrender To Poison',105000,58),
(40,1222,7,'Curse Chaos',105000,58),
(40,1176,7,'Tempest',105000,58),
(40,1169,6,'Curse Fear',105000,58),
(40,1160,7,'Slow',105000,58),
(40,1159,5,'Curse Death Link',105000,58),
(40,1159,6,'Curse Death Link',105000,58),
(40,1151,8,'Corpse Life Drain',105000,58),
(40,1157,4,'Body To Mind',105000,58),
(40,1074,6,'Surrender To Wind',105000,58),
(40,1148,5,'Death Spike',105000,58),
(40,1069,25,'Sleep',52000,58),
(40,1069,26,'Sleep',52000,58),
(40,1064,6,'Silence',105000,58),
(40,212,4,'Fast HP Recovery',105000,58),
(40,285,19,'Higher Mana Gain',105000,58),
(40,249,25,'Weapon Mastery',53000,58),
(40,249,26,'Weapon Mastery',53000,58),
(40,234,24,'Robe Mastery',53000,58),
(40,234,25,'Robe Mastery',53000,58),
(40,146,28,'Anti Magic',53000,58),
(40,146,29,'Anti Magic',53000,58),
(40,146,30,'Anti Magic',75000,60),
(40,146,31,'Anti Magic',75000,60),
(40,234,26,'Robe Mastery',75000,60),
(40,234,27,'Robe Mastery',75000,60),
(40,249,27,'Weapon Mastery',75000,60),
(40,249,28,'Weapon Mastery',75000,60),
(40,285,20,'Higher Mana Gain',150000,60),
(40,213,6,'Boost Mana',150000,60),
(40,1064,7,'Silence',150000,60),
(40,1069,27,'Sleep',75000,60),
(40,1069,28,'Sleep',75000,60),
(40,1148,6,'Death Spike',150000,60),
(40,1074,7,'Surrender To Wind',150000,60),
(40,229,5,'Fast Mana Recovery',150000,60),
(40,1151,9,'Corpse Life Drain',150000,60),
(40,1159,7,'Curse Death Link',75000,60),
(40,1159,8,'Curse Death Link',75000,60),
(40,1160,8,'Slow',150000,60),
(40,1169,7,'Curse Fear',150000,60),
(40,1176,8,'Tempest',150000,60),
(40,1222,8,'Curse Chaos',150000,60),
(40,1224,10,'Surrender To Poison',150000,60),
(40,1234,13,'Vampiric Claw',75000,60),
(40,1234,14,'Vampiric Claw',75000,60),
(40,1239,13,'Hurricane',75000,60),
(40,1239,14,'Hurricane',75000,60),
(40,1267,7,'Shadow Flare',150000,60),
(40,1267,8,'Shadow Flare',190000,62),
(40,1297,4,'Clear Mind',190000,62),
(40,1417,2,'Aura Flash',190000,62),
(40,1239,15,'Hurricane',100000,62),
(40,1239,16,'Hurricane',100000,62),
(40,1234,15,'Vampiric Claw',100000,62),
(40,1234,16,'Vampiric Claw',100000,62),
(40,1224,11,'Surrender To Poison',190000,62),
(40,1222,9,'Curse Chaos',190000,62),
(40,1176,9,'Tempest',190000,62),
(40,1169,8,'Curse Fear',190000,62),
(40,1160,9,'Slow',190000,62),
(40,1168,6,'Curse: Poison',190000,62),
(40,1159,9,'Curse Death Link',100000,62),
(40,1159,10,'Curse Death Link',100000,62),
(40,1151,10,'Corpse Life Drain',190000,62),
(40,1074,8,'Surrender To Wind',190000,62),
(40,1148,7,'Death Spike',190000,62),
(40,1069,29,'Sleep',100000,62),
(40,1069,30,'Sleep',100000,62),
(40,1064,8,'Silence',190000,62),
(40,285,21,'Higher Mana Gain',190000,62),
(40,249,29,'Weapon Mastery',100000,62),
(40,249,30,'Weapon Mastery',100000,62),
(40,234,28,'Robe Mastery',100000,62),
(40,234,29,'Robe Mastery',100000,62),
(40,146,32,'Anti Magic',100000,62),
(40,146,33,'Anti Magic',100000,62),
(40,146,34,'Anti Magic',120000,64),
(40,146,35,'Anti Magic',120000,64),
(40,234,30,'Robe Mastery',120000,64),
(40,234,31,'Robe Mastery',120000,64),
(40,249,31,'Weapon Mastery',120000,64),
(40,249,32,'Weapon Mastery',120000,64),
(40,285,22,'Higher Mana Gain',240000,64),
(40,1064,9,'Silence',240000,64),
(40,212,5,'Fast HP Recovery',240000,64),
(40,1069,31,'Sleep',120000,64),
(40,1069,32,'Sleep',120000,64),
(40,1148,8,'Death Spike',240000,64),
(40,1074,9,'Surrender To Wind',240000,64),
(40,1151,11,'Corpse Life Drain',240000,64),
(40,1159,11,'Curse Death Link',120000,64),
(40,1159,12,'Curse Death Link',120000,64),
(40,1167,5,'Poisonous Cloud',240000,64),
(40,1160,10,'Slow',240000,64),
(40,1169,9,'Curse Fear',240000,64),
(40,1176,10,'Tempest',240000,64),
(40,1222,10,'Curse Chaos',240000,64),
(40,1224,12,'Surrender To Poison',240000,64),
(40,1234,17,'Vampiric Claw',120000,64),
(40,1234,18,'Vampiric Claw',120000,64),
(40,1239,17,'Hurricane',120000,64),
(40,1239,18,'Hurricane',120000,64),
(40,1267,9,'Shadow Flare',240000,64),
(40,1267,10,'Shadow Flare',320000,66),
(40,1287,1,'Seed of Wind',320000,66),
(40,1417,3,'Aura Flash',320000,66),
(40,1239,19,'Hurricane',160000,66),
(40,1239,20,'Hurricane',160000,66),
(40,1234,19,'Vampiric Claw',160000,66),
(40,1234,20,'Vampiric Claw',160000,66),
(40,1224,13,'Surrender To Poison',320000,66),
(40,1222,11,'Curse Chaos',320000,66),
(40,1176,11,'Tempest',320000,66),
(40,1169,10,'Curse Fear',320000,66),
(40,1160,11,'Slow',320000,66),
(40,1159,13,'Curse Death Link',160000,66),
(40,1159,14,'Curse Death Link',160000,66),
(40,1151,12,'Corpse Life Drain',320000,66),
(40,1157,5,'Body To Mind',320000,66),
(40,1074,10,'Surrender To Wind',320000,66),
(40,1148,9,'Death Spike',320000,66),
(40,1069,33,'Sleep',160000,66),
(40,1069,34,'Sleep',160000,66),
(40,213,7,'Boost Mana',320000,66),
(40,1064,10,'Silence',320000,66),
(40,285,23,'Higher Mana Gain',320000,66),
(40,249,33,'Weapon Mastery',160000,66),
(40,249,34,'Weapon Mastery',160000,66),
(40,234,32,'Robe Mastery',160000,66),
(40,234,33,'Robe Mastery',160000,66),
(40,146,36,'Anti Magic',160000,66),
(40,146,37,'Anti Magic',160000,66),
(40,146,38,'Anti Magic',180000,68),
(40,146,39,'Anti Magic',180000,68),
(40,234,34,'Robe Mastery',180000,68),
(40,234,35,'Robe Mastery',180000,68),
(40,249,35,'Weapon Mastery',180000,68),
(40,249,36,'Weapon Mastery',180000,68),
(40,285,24,'Higher Mana Gain',370000,68),
(40,1064,11,'Silence',370000,68),
(40,1069,35,'Sleep',180000,68),
(40,1069,36,'Sleep',180000,68),
(40,1148,10,'Death Spike',370000,68),
(40,1074,11,'Surrender To Wind',370000,68),
(40,229,6,'Fast Mana Recovery',370000,68),
(40,1151,13,'Corpse Life Drain',370000,68),
(40,1159,15,'Curse Death Link',180000,68),
(40,1159,16,'Curse Death Link',180000,68),
(40,1160,12,'Slow',370000,68),
(40,1169,11,'Curse Fear',370000,68),
(40,1176,12,'Tempest',370000,68),
(40,1222,12,'Curse Chaos',370000,68),
(40,1224,14,'Surrender To Poison',370000,68),
(40,1234,21,'Vampiric Claw',180000,68),
(40,1234,22,'Vampiric Claw',180000,68),
(40,1239,21,'Hurricane',180000,68),
(40,1239,22,'Hurricane',180000,68),
(40,1288,1,'Aura Symphony',370000,68),
(40,1297,5,'Clear Mind',370000,68),
(40,1267,11,'Shadow Flare',370000,68),
(40,1267,12,'Shadow Flare',470000,70),
(40,1291,1,'Demon Wind',470000,70),
(40,1417,4,'Aura Flash',470000,70),
(40,1239,23,'Hurricane',240000,70),
(40,1239,24,'Hurricane',240000,70),
(40,1234,23,'Vampiric Claw',240000,70),
(40,1234,24,'Vampiric Claw',240000,70),
(40,1224,15,'Surrender To Poison',470000,70),
(40,1222,13,'Curse Chaos',470000,70),
(40,1176,13,'Tempest',470000,70),
(40,1169,12,'Curse Fear',470000,70),
(40,1160,13,'Slow',470000,70),
(40,1159,17,'Curse Death Link',240000,70),
(40,1159,18,'Curse Death Link',240000,70),
(40,1151,14,'Corpse Life Drain',470000,70),
(40,1074,12,'Surrender To Wind',470000,70),
(40,1148,11,'Death Spike',470000,70),
(40,1069,37,'Sleep',240000,70),
(40,1069,38,'Sleep',240000,70),
(40,1064,12,'Silence',470000,70),
(40,285,25,'Higher Mana Gain',470000,70),
(40,249,37,'Weapon Mastery',240000,70),
(40,249,38,'Weapon Mastery',240000,70),
(40,234,36,'Robe Mastery',240000,70),
(40,234,37,'Robe Mastery',240000,70),
(40,146,40,'Anti Magic',240000,70),
(40,146,41,'Anti Magic',240000,70),
(40,146,42,'Anti Magic',360000,72),
(40,146,43,'Anti Magic',360000,72),
(40,234,38,'Robe Mastery',360000,72),
(40,234,39,'Robe Mastery',360000,72),
(40,249,39,'Weapon Mastery',360000,72),
(40,249,40,'Weapon Mastery',360000,72),
(40,285,26,'Higher Mana Gain',710000,72),
(40,1064,13,'Silence',710000,72),
(40,213,8,'Boost Mana',710000,72),
(40,1069,39,'Sleep',360000,72),
(40,1069,40,'Sleep',360000,72),
(40,1148,12,'Death Spike',710000,72),
(40,1074,13,'Surrender To Wind',710000,72),
(40,1151,15,'Corpse Life Drain',710000,72),
(40,1159,19,'Curse Death Link',360000,72),
(40,1159,20,'Curse Death Link',360000,72),
(40,1160,14,'Slow',710000,72),
(40,1168,7,'Curse: Poison',710000,72),
(40,1169,13,'Curse Fear',710000,72),
(40,1176,14,'Tempest',710000,72),
(40,1222,14,'Curse Chaos',710000,72),
(40,1224,16,'Surrender To Poison',710000,72),
(40,1234,25,'Vampiric Claw',360000,72),
(40,1234,26,'Vampiric Claw',360000,72),
(40,1239,25,'Hurricane',360000,72),
(40,1239,26,'Hurricane',360000,72),
(40,1294,1,'Elemental Storm',710000,72),
(40,1267,13,'Shadow Flare',710000,72),
(40,1267,14,'Shadow Flare',1000000,74),
(40,1297,6,'Clear Mind',1000000,74),
(40,1417,5,'Aura Flash',1000000,74),
(40,1239,27,'Hurricane',500000,74),
(40,1239,28,'Hurricane',500000,74),
(40,1234,27,'Vampiric Claw',500000,74),
(40,1234,28,'Vampiric Claw',500000,74),
(40,1224,17,'Surrender To Poison',1000000,74),
(40,1222,15,'Curse Chaos',1000000,74),
(40,1176,15,'Tempest',1000000,74),
(40,1169,14,'Curse Fear',1000000,74),
(40,1167,6,'Poisonous Cloud',1000000,74),
(40,1160,15,'Slow',1000000,74),
(40,1159,21,'Curse Death Link',500000,74),
(40,1159,22,'Curse Death Link',500000,74),
(40,1151,16,'Corpse Life Drain',1000000,74),
(40,229,7,'Fast Mana Recovery',1000000,74),
(40,1074,14,'Surrender To Wind',1000000,74),
(40,1148,13,'Death Spike',1000000,74),
(40,1069,41,'Sleep',500000,74),
(40,1069,42,'Sleep',500000,74),
(40,212,6,'Fast HP Recovery',1000000,74),
(40,1064,14,'Silence',1000000,74),
(40,285,27,'Higher Mana Gain',1000000,74),
(40,249,41,'Weapon Mastery',500000,74),
(40,249,42,'Weapon Mastery',500000,74),
(40,234,40,'Robe Mastery',500000,74),
(40,234,41,'Robe Mastery',500000,74),
(40,146,44,'Anti Magic',500000,74),
(40,146,45,'Anti Magic',500000,74),
(41,146,13,'Anti Magic',10000,40),
(41,146,14,'Anti Magic',10000,40),
(41,146,15,'Anti Magic',10000,40),
(41,234,9,'Robe Mastery',10000,40),
(41,234,10,'Robe Mastery',10000,40),
(41,234,11,'Robe Mastery',10000,40),
(41,249,10,'Weapon Mastery',10000,40),
(41,249,11,'Weapon Mastery',10000,40),
(41,249,12,'Weapon Mastery',10000,40),
(41,258,1,'Light Armor Mastery',10000,40),
(41,258,2,'Light Armor Mastery',10000,40),
(41,258,3,'Light Armor Mastery',10000,40),
(41,33,1,'Summon Phantom Cubic',30000,40),
(41,213,3,'Boost Mana',30000,40),
(41,1126,7,'Servitor Recharge',15000,40),
(41,1126,8,'Servitor Recharge',15000,40),
(41,1127,13,'Servitor Heal',10000,40),
(41,1127,14,'Servitor Heal',10000,40),
(41,1127,15,'Servitor Heal',10000,40),
(41,228,2,'Fast Spell Casting',30000,40),
(41,1128,5,'Summon Shadow',30000,40),
(41,1140,1,'Servitor Physical Shield',30000,40),
(41,1206,6,'Wind Shackle',30000,40),
(41,1228,5,'Summon Silhouette',30000,40),
(41,1278,1,'Summon Soulless',30000,40),
(41,1281,1,'Summon Spark Cubic',30000,40),
(41,1262,1,'Transfer Pain',30000,40),
(41,1300,1,'Servitor Cure',30000,40),
(41,1330,1,'Mass Summon Phantom Cubic',30000,40),
(41,1168,4,'Curse: Poison',35000,44),
(41,1530,1,'Death Spike',35000,44),
(41,1330,2,'Mass Summon Phantom Cubic',35000,44),
(41,1281,2,'Summon Spark Cubic',35000,44),
(41,1278,2,'Summon Soulless',35000,44),
(41,1228,6,'Summon Silhouette',35000,44),
(41,1206,7,'Wind Shackle',35000,44),
(41,1139,1,'Servitor Magic Shield',35000,44),
(41,1141,1,'Servitor Haste',35000,44),
(41,1128,6,'Summon Shadow',35000,44),
(41,143,1,'Cubic Mastery',35000,44),
(41,229,3,'Fast Mana Recovery',35000,44),
(41,1127,16,'Servitor Heal',12000,44),
(41,1127,17,'Servitor Heal',12000,44),
(41,1127,18,'Servitor Heal',12000,44),
(41,1126,9,'Servitor Recharge',18000,44),
(41,1126,10,'Servitor Recharge',18000,44),
(41,212,2,'Fast HP Recovery',35000,44),
(41,33,2,'Summon Phantom Cubic',35000,44),
(41,258,4,'Light Armor Mastery',12000,44),
(41,258,5,'Light Armor Mastery',12000,44),
(41,258,6,'Light Armor Mastery',12000,44),
(41,249,13,'Weapon Mastery',12000,44),
(41,249,14,'Weapon Mastery',12000,44),
(41,249,15,'Weapon Mastery',12000,44),
(41,234,12,'Robe Mastery',12000,44),
(41,234,13,'Robe Mastery',12000,44),
(41,234,14,'Robe Mastery',12000,44),
(41,146,16,'Anti Magic',12000,44),
(41,146,17,'Anti Magic',12000,44),
(41,146,18,'Anti Magic',12000,44),
(41,1530,2,'Death Spike',67000,48),
(41,146,19,'Anti Magic',22000,48),
(41,146,20,'Anti Magic',22000,48),
(41,146,21,'Anti Magic',22000,48),
(41,234,15,'Robe Mastery',22000,48),
(41,234,16,'Robe Mastery',22000,48),
(41,234,17,'Robe Mastery',22000,48),
(41,249,16,'Weapon Mastery',22000,48),
(41,249,17,'Weapon Mastery',22000,48),
(41,249,18,'Weapon Mastery',22000,48),
(41,258,7,'Light Armor Mastery',22000,48),
(41,258,8,'Light Armor Mastery',22000,48),
(41,258,9,'Light Armor Mastery',22000,48),
(41,213,4,'Boost Mana',67000,48),
(41,1126,11,'Servitor Recharge',33000,48),
(41,1126,12,'Servitor Recharge',33000,48),
(41,1127,19,'Servitor Heal',22000,48),
(41,1127,20,'Servitor Heal',22000,48),
(41,1127,21,'Servitor Heal',22000,48),
(41,1128,7,'Summon Shadow',67000,48),
(41,1146,2,'Mighty Servitor',67000,48),
(41,1140,2,'Servitor Physical Shield',67000,48),
(41,1206,8,'Wind Shackle',67000,48),
(41,1228,7,'Summon Silhouette',67000,48),
(41,1278,3,'Summon Soulless',67000,48),
(41,1281,3,'Summon Spark Cubic',67000,48),
(41,1300,2,'Servitor Cure',67000,48),
(41,1262,2,'Transfer Pain',67000,48),
(41,164,3,'Quick Recycle',67000,48),
(41,1168,5,'Curse: Poison',90000,52),
(41,1530,3,'Death Spike',90000,52),
(41,1299,1,'Servitor Empowerment',90000,52),
(41,1330,3,'Mass Summon Phantom Cubic',90000,52),
(41,1281,4,'Summon Spark Cubic',90000,52),
(41,1278,4,'Summon Soulless',90000,52),
(41,1228,8,'Summon Silhouette',90000,52),
(41,1206,9,'Wind Shackle',90000,52),
(41,1139,2,'Servitor Magic Shield',90000,52),
(41,1141,2,'Servitor Haste',90000,52),
(41,1128,8,'Summon Shadow',90000,52),
(41,229,4,'Fast Mana Recovery',90000,52),
(41,1127,22,'Servitor Heal',30000,52),
(41,1127,23,'Servitor Heal',30000,52),
(41,1127,24,'Servitor Heal',30000,52),
(41,1126,13,'Servitor Recharge',45000,52),
(41,1126,14,'Servitor Recharge',45000,52),
(41,212,3,'Fast HP Recovery',90000,52),
(41,33,3,'Summon Phantom Cubic',90000,52),
(41,258,10,'Light Armor Mastery',30000,52),
(41,258,11,'Light Armor Mastery',30000,52),
(41,258,12,'Light Armor Mastery',30000,52),
(41,249,19,'Weapon Mastery',30000,52),
(41,249,20,'Weapon Mastery',30000,52),
(41,249,21,'Weapon Mastery',30000,52),
(41,234,18,'Robe Mastery',30000,52),
(41,234,19,'Robe Mastery',30000,52),
(41,234,20,'Robe Mastery',30000,52),
(41,146,22,'Anti Magic',30000,52),
(41,146,23,'Anti Magic',30000,52),
(41,146,24,'Anti Magic',30000,52),
(41,1530,4,'Death Spike',95000,56),
(41,146,25,'Anti Magic',32000,56),
(41,146,26,'Anti Magic',32000,56),
(41,146,27,'Anti Magic',32000,56),
(41,234,21,'Robe Mastery',32000,56),
(41,234,22,'Robe Mastery',32000,56),
(41,234,23,'Robe Mastery',32000,56),
(41,249,22,'Weapon Mastery',32000,56),
(41,249,23,'Weapon Mastery',32000,56),
(41,249,24,'Weapon Mastery',32000,56),
(41,258,13,'Light Armor Mastery',32000,56),
(41,258,14,'Light Armor Mastery',32000,56),
(41,258,15,'Light Armor Mastery',32000,56),
(41,213,5,'Boost Mana',95000,56),
(41,1126,15,'Servitor Recharge',48000,56),
(41,1126,16,'Servitor Recharge',48000,56),
(41,1127,25,'Servitor Heal',32000,56),
(41,1127,26,'Servitor Heal',32000,56),
(41,1127,27,'Servitor Heal',32000,56),
(41,143,2,'Cubic Mastery',95000,56),
(41,228,3,'Fast Spell Casting',95000,56),
(41,1128,9,'Summon Shadow',95000,56),
(41,1146,3,'Mighty Servitor',95000,56),
(41,1140,3,'Servitor Physical Shield',95000,56),
(41,1206,10,'Wind Shackle',95000,56),
(41,1228,9,'Summon Silhouette',95000,56),
(41,1278,5,'Summon Soulless',95000,56),
(41,1281,5,'Summon Spark Cubic',95000,56),
(41,1262,3,'Transfer Pain',95000,56),
(41,1333,1,'Summon Nightshade',95000,56),
(41,1403,1,'Summon Friend',95000,56),
(41,1380,1,'Betray',95000,56),
(41,1387,1,'Summon Cursed Bones',120000,58),
(41,1530,5,'Death Spike',120000,58),
(41,1380,2,'Betray',120000,58),
(41,1385,1,'Mass Surrender to Wind',120000,58),
(41,1333,2,'Summon Nightshade',120000,58),
(41,1330,4,'Mass Summon Phantom Cubic',120000,58),
(41,1262,4,'Transfer Pain',120000,58),
(41,1278,6,'Summon Soulless',120000,58),
(41,1228,10,'Summon Silhouette',120000,58),
(41,1206,11,'Wind Shackle',120000,58),
(41,1128,10,'Summon Shadow',120000,58),
(41,1127,28,'Servitor Heal',58000,58),
(41,1127,29,'Servitor Heal',58000,58),
(41,1126,17,'Servitor Recharge',58000,58),
(41,1126,18,'Servitor Recharge',58000,58),
(41,212,4,'Fast HP Recovery',120000,58),
(41,33,4,'Summon Phantom Cubic',120000,58),
(41,258,16,'Light Armor Mastery',58000,58),
(41,258,17,'Light Armor Mastery',58000,58),
(41,249,25,'Weapon Mastery',58000,58),
(41,249,26,'Weapon Mastery',58000,58),
(41,234,24,'Robe Mastery',58000,58),
(41,234,25,'Robe Mastery',58000,58),
(41,146,28,'Anti Magic',58000,58),
(41,146,29,'Anti Magic',58000,58),
(41,1530,6,'Death Spike',176000,60),
(41,146,30,'Anti Magic',88000,60),
(41,146,31,'Anti Magic',88000,60),
(41,234,26,'Robe Mastery',88000,60),
(41,234,27,'Robe Mastery',88000,60),
(41,249,27,'Weapon Mastery',88000,60),
(41,249,28,'Weapon Mastery',88000,60),
(41,258,18,'Light Armor Mastery',88000,60),
(41,258,19,'Light Armor Mastery',88000,60),
(41,213,6,'Boost Mana',176000,60),
(41,1126,19,'Servitor Recharge',88000,60),
(41,1126,20,'Servitor Recharge',88000,60),
(41,1127,30,'Servitor Heal',88000,60),
(41,1127,31,'Servitor Heal',88000,60),
(41,1128,11,'Summon Shadow',176000,60),
(41,229,5,'Fast Mana Recovery',176000,60),
(41,1206,12,'Wind Shackle',176000,60),
(41,1228,11,'Summon Silhouette',176000,60),
(41,1278,7,'Summon Soulless',176000,60),
(41,1300,3,'Servitor Cure',176000,60),
(41,1281,6,'Summon Spark Cubic',176000,60),
(41,1333,3,'Summon Nightshade',176000,60),
(41,1380,3,'Betray',176000,60),
(41,1168,6,'Curse: Poison',220000,62),
(41,1530,7,'Death Spike',220000,62),
(41,1380,4,'Betray',220000,62),
(41,1385,2,'Mass Surrender to Wind',220000,62),
(41,1333,4,'Summon Nightshade',220000,62),
(41,1330,5,'Mass Summon Phantom Cubic',220000,62),
(41,1301,1,'Servitor Blessing',220000,62),
(41,1278,8,'Summon Soulless',220000,62),
(41,1228,12,'Summon Silhouette',220000,62),
(41,1206,13,'Wind Shackle',220000,62),
(41,1128,12,'Summon Shadow',220000,62),
(41,1127,32,'Servitor Heal',110000,62),
(41,1127,33,'Servitor Heal',110000,62),
(41,1126,21,'Servitor Recharge',110000,62),
(41,1126,22,'Servitor Recharge',110000,62),
(41,33,5,'Summon Phantom Cubic',220000,62),
(41,258,20,'Light Armor Mastery',110000,62),
(41,258,21,'Light Armor Mastery',110000,62),
(41,249,29,'Weapon Mastery',110000,62),
(41,249,30,'Weapon Mastery',110000,62),
(41,234,28,'Robe Mastery',110000,62),
(41,234,29,'Robe Mastery',110000,62),
(41,146,32,'Anti Magic',110000,62),
(41,146,33,'Anti Magic',110000,62),
(41,1530,8,'Death Spike',320000,64),
(41,146,34,'Anti Magic',160000,64),
(41,146,35,'Anti Magic',160000,64),
(41,234,30,'Robe Mastery',160000,64),
(41,234,31,'Robe Mastery',160000,64),
(41,249,31,'Weapon Mastery',160000,64),
(41,249,32,'Weapon Mastery',160000,64),
(41,258,22,'Light Armor Mastery',160000,64),
(41,258,23,'Light Armor Mastery',160000,64),
(41,212,5,'Fast HP Recovery',320000,64),
(41,1126,23,'Servitor Recharge',160000,64),
(41,1126,24,'Servitor Recharge',160000,64),
(41,1127,34,'Servitor Heal',160000,64),
(41,1127,35,'Servitor Heal',160000,64),
(41,1128,13,'Summon Shadow',320000,64),
(41,1206,14,'Wind Shackle',320000,64),
(41,1228,13,'Summon Silhouette',320000,64),
(41,1278,9,'Summon Soulless',320000,64),
(41,1281,7,'Summon Spark Cubic',320000,64),
(41,1333,5,'Summon Nightshade',320000,64),
(41,1380,5,'Betray',320000,64),
(41,1387,2,'Summon Cursed Bones',390000,66),
(41,1530,9,'Death Spike',390000,66),
(41,1380,6,'Betray',390000,66),
(41,1385,3,'Mass Surrender to Wind',390000,66),
(41,1333,6,'Summon Nightshade',390000,66),
(41,1330,6,'Mass Summon Phantom Cubic',390000,66),
(41,1278,10,'Summon Soulless',390000,66),
(41,1228,14,'Summon Silhouette',390000,66),
(41,1206,15,'Wind Shackle',390000,66),
(41,1128,14,'Summon Shadow',390000,66),
(41,1127,36,'Servitor Heal',190000,66),
(41,1127,37,'Servitor Heal',190000,66),
(41,1126,25,'Servitor Recharge',190000,66),
(41,1126,26,'Servitor Recharge',190000,66),
(41,213,7,'Boost Mana',390000,66),
(41,33,6,'Summon Phantom Cubic',390000,66),
(41,258,24,'Light Armor Mastery',190000,66),
(41,258,25,'Light Armor Mastery',190000,66),
(41,249,33,'Weapon Mastery',190000,66),
(41,249,34,'Weapon Mastery',190000,66),
(41,234,32,'Robe Mastery',190000,66),
(41,234,33,'Robe Mastery',190000,66),
(41,146,36,'Anti Magic',190000,66),
(41,146,37,'Anti Magic',190000,66),
(41,1530,10,'Death Spike',510000,68),
(41,146,38,'Anti Magic',260000,68),
(41,146,39,'Anti Magic',260000,68),
(41,234,34,'Robe Mastery',260000,68),
(41,234,35,'Robe Mastery',260000,68),
(41,249,35,'Weapon Mastery',260000,68),
(41,249,36,'Weapon Mastery',260000,68),
(41,258,26,'Light Armor Mastery',260000,68),
(41,258,27,'Light Armor Mastery',260000,68),
(41,1126,27,'Servitor Recharge',260000,68),
(41,1126,28,'Servitor Recharge',260000,68),
(41,1127,38,'Servitor Heal',260000,68),
(41,1127,39,'Servitor Heal',260000,68),
(41,1128,15,'Summon Shadow',510000,68),
(41,229,6,'Fast Mana Recovery',510000,68),
(41,1206,16,'Wind Shackle',510000,68),
(41,1228,15,'Summon Silhouette',510000,68),
(41,1278,11,'Summon Soulless',510000,68),
(41,1281,8,'Summon Spark Cubic',510000,68),
(41,1333,7,'Summon Nightshade',510000,68),
(41,1380,7,'Betray',510000,68),
(41,1530,11,'Death Spike',520000,70),
(41,1380,8,'Betray',520000,70),
(41,1385,4,'Mass Surrender to Wind',520000,70),
(41,1299,2,'Servitor Empowerment',520000,70),
(41,1333,8,'Summon Nightshade',520000,70),
(41,1330,7,'Mass Summon Phantom Cubic',520000,70),
(41,1262,5,'Transfer Pain',520000,70),
(41,1278,12,'Summon Soulless',520000,70),
(41,1228,16,'Summon Silhouette',520000,70),
(41,1206,17,'Wind Shackle',520000,70),
(41,1128,16,'Summon Shadow',520000,70),
(41,1127,40,'Servitor Heal',260000,70),
(41,1127,41,'Servitor Heal',260000,70),
(41,1126,29,'Servitor Recharge',260000,70),
(41,1126,30,'Servitor Recharge',260000,70),
(41,33,7,'Summon Phantom Cubic',520000,70),
(41,258,28,'Light Armor Mastery',260000,70),
(41,258,29,'Light Armor Mastery',260000,70),
(41,249,37,'Weapon Mastery',260000,70),
(41,249,38,'Weapon Mastery',260000,70),
(41,234,36,'Robe Mastery',260000,70),
(41,234,37,'Robe Mastery',260000,70),
(41,146,40,'Anti Magic',260000,70),
(41,146,41,'Anti Magic',260000,70),
(41,1168,7,'Curse: Poison',940000,72),
(41,1530,12,'Death Spike',940000,72),
(41,146,42,'Anti Magic',470000,72),
(41,146,43,'Anti Magic',470000,72),
(41,234,38,'Robe Mastery',470000,72),
(41,234,39,'Robe Mastery',470000,72),
(41,249,39,'Weapon Mastery',470000,72),
(41,249,40,'Weapon Mastery',470000,72),
(41,258,30,'Light Armor Mastery',470000,72),
(41,258,31,'Light Armor Mastery',470000,72),
(41,213,8,'Boost Mana',940000,72),
(41,1126,31,'Servitor Recharge',470000,72),
(41,1126,32,'Servitor Recharge',470000,72),
(41,1127,42,'Servitor Heal',470000,72),
(41,1127,43,'Servitor Heal',470000,72),
(41,1128,17,'Summon Shadow',940000,72),
(41,1206,18,'Wind Shackle',940000,72),
(41,1228,17,'Summon Silhouette',940000,72),
(41,1278,13,'Summon Soulless',940000,72),
(41,1281,9,'Summon Spark Cubic',940000,72),
(41,1333,9,'Summon Nightshade',940000,72),
(41,1380,9,'Betray',940000,72),
(41,1387,3,'Summon Cursed Bones',1210000,74),
(41,1530,13,'Death Spike',1210000,74),
(41,1380,10,'Betray',1210000,74),
(41,1385,5,'Mass Surrender to Wind',1210000,74),
(41,1333,10,'Summon Nightshade',1210000,74),
(41,1330,8,'Mass Summon Phantom Cubic',1210000,74),
(41,1278,14,'Summon Soulless',1210000,74),
(41,1228,18,'Summon Silhouette',1210000,74),
(41,1206,19,'Wind Shackle',1210000,74),
(41,1128,18,'Summon Shadow',1210000,74),
(41,229,7,'Fast Mana Recovery',1210000,74),
(41,1127,44,'Servitor Heal',610000,74),
(41,1127,45,'Servitor Heal',610000,74),
(41,1126,33,'Servitor Recharge',610000,74),
(41,1126,34,'Servitor Recharge',610000,74),
(41,212,6,'Fast HP Recovery',1210000,74),
(41,33,8,'Summon Phantom Cubic',1210000,74),
(41,258,32,'Light Armor Mastery',610000,74),
(41,258,33,'Light Armor Mastery',610000,74),
(41,249,41,'Weapon Mastery',610000,74),
(41,249,42,'Weapon Mastery',610000,74),
(41,234,40,'Robe Mastery',610000,74),
(41,234,41,'Robe Mastery',610000,74),
(41,146,44,'Anti Magic',610000,74),
(41,146,45,'Anti Magic',610000,74),
(42,146,5,'Anti Magic',1600,20),
(42,146,6,'Anti Magic',1600,20),
(42,235,1,'Robe Mastery',1600,20),
(42,235,2,'Robe Mastery',1600,20),
(42,236,1,'Light Armor Mastery',1600,20),
(42,236,2,'Light Armor Mastery',1600,20),
(42,164,1,'Quick Recycle',3300,20),
(42,213,1,'Boost Mana',3300,20),
(42,249,3,'Weapon Mastery',3300,20),
(42,1011,7,'Heal',1100,20),
(42,1011,8,'Heal',1100,20),
(42,1011,9,'Heal',1100,20),
(42,1015,4,'Battle Heal',1100,20),
(42,1015,5,'Battle Heal',1100,20),
(42,1015,6,'Battle Heal',1100,20),
(42,1016,1,'Resurrection',3300,20),
(42,1027,4,'Group Heal',1100,20),
(42,1027,5,'Group Heal',1100,20),
(42,1027,6,'Group Heal',1100,20),
(42,1031,1,'Disrupt Undead',1600,20),
(42,1031,2,'Disrupt Undead',1600,20),
(42,1068,2,'Might',3300,20),
(42,1073,1,'Kiss of Eva',3300,20),
(42,1078,1,'Concentration',3300,20),
(42,1204,1,'Wind Walk',3300,20),
(42,1206,2,'Wind Shackle',3300,20),
(42,1206,3,'Wind Shackle',6500,25),
(42,1077,1,'Focus',6500,25),
(42,1035,1,'Mental Shield',6500,25),
(42,1040,2,'Shield',6500,25),
(42,1059,1,'Empower',6500,25),
(42,1201,1,'Dryad Root',2200,25),
(42,1201,2,'Dryad Root',2200,25),
(42,1201,3,'Dryad Root',2200,25),
(42,1069,1,'Sleep',2200,25),
(42,1069,2,'Sleep',2200,25),
(42,1069,3,'Sleep',2200,25),
(42,1031,3,'Disrupt Undead',3200,25),
(42,1031,4,'Disrupt Undead',3200,25),
(42,1027,7,'Group Heal',2200,25),
(42,1027,8,'Group Heal',2200,25),
(42,1027,9,'Group Heal',2200,25),
(42,228,1,'Fast Spell Casting',6500,25),
(42,229,1,'Fast Mana Recovery',6500,25),
(42,1015,7,'Battle Heal',2200,25),
(42,1015,8,'Battle Heal',2200,25),
(42,1015,9,'Battle Heal',2200,25),
(42,1011,10,'Heal',2200,25),
(42,1011,11,'Heal',2200,25),
(42,1011,12,'Heal',2200,25),
(42,249,4,'Weapon Mastery',3200,25),
(42,249,5,'Weapon Mastery',3200,25),
(42,236,3,'Light Armor Mastery',3200,25),
(42,236,4,'Light Armor Mastery',3200,25),
(42,235,3,'Robe Mastery',3200,25),
(42,235,4,'Robe Mastery',3200,25),
(42,146,7,'Anti Magic',3200,25),
(42,146,8,'Anti Magic',3200,25),
(42,146,9,'Anti Magic',5800,30),
(42,146,10,'Anti Magic',5800,30),
(42,235,5,'Robe Mastery',5800,30),
(42,235,6,'Robe Mastery',5800,30),
(42,236,5,'Light Armor Mastery',5800,30),
(42,236,6,'Light Armor Mastery',5800,30),
(42,249,6,'Weapon Mastery',5800,30),
(42,249,7,'Weapon Mastery',5800,30),
(42,213,2,'Boost Mana',12000,30),
(42,164,2,'Quick Recycle',12000,30),
(42,1011,13,'Heal',3900,30),
(42,1011,14,'Heal',3900,30),
(42,1011,15,'Heal',3900,30),
(42,1015,10,'Battle Heal',3900,30),
(42,1015,11,'Battle Heal',3900,30),
(42,1015,12,'Battle Heal',3900,30),
(42,1016,2,'Resurrection',12000,30),
(42,1013,1,'Recharge',5800,30),
(42,1013,2,'Recharge',5800,30),
(42,1027,10,'Group Heal',3900,30),
(42,1027,11,'Group Heal',3900,30),
(42,1027,12,'Group Heal',3900,30),
(42,1031,5,'Disrupt Undead',5800,30),
(42,1031,6,'Disrupt Undead',5800,30),
(42,1069,4,'Sleep',3900,30),
(42,1069,5,'Sleep',3900,30),
(42,1069,6,'Sleep',3900,30),
(42,1201,4,'Dryad Root',3900,30),
(42,1201,5,'Dryad Root',3900,30),
(42,1201,6,'Dryad Root',3900,30),
(42,1204,2,'Wind Walk',12000,30),
(42,1078,2,'Concentration',12000,30),
(42,1206,4,'Wind Shackle',12000,30),
(42,1268,1,'Vampiric Rage',12000,30),
(42,1206,5,'Wind Shackle',23000,35),
(42,1189,1,'Resist Wind',23000,35),
(42,1201,7,'Dryad Root',7700,35),
(42,1201,8,'Dryad Root',7700,35),
(42,1201,9,'Dryad Root',7700,35),
(42,1069,7,'Sleep',7700,35),
(42,1069,8,'Sleep',7700,35),
(42,1069,9,'Sleep',7700,35),
(42,1031,7,'Disrupt Undead',12000,35),
(42,1031,8,'Disrupt Undead',12000,35),
(42,1027,13,'Group Heal',7700,35),
(42,1027,14,'Group Heal',7700,35),
(42,1027,15,'Group Heal',7700,35),
(42,1013,3,'Recharge',12000,35),
(42,1013,4,'Recharge',12000,35),
(42,229,2,'Fast Mana Recovery',23000,35),
(42,1015,13,'Battle Heal',7700,35),
(42,1015,14,'Battle Heal',7700,35),
(42,1015,15,'Battle Heal',7700,35),
(42,1011,16,'Heal',7700,35),
(42,1011,17,'Heal',7700,35),
(42,1011,18,'Heal',7700,35),
(42,1012,2,'Cure Poison',23000,35),
(42,212,1,'Fast HP Recovery',23000,35),
(42,249,8,'Weapon Mastery',12000,35),
(42,249,9,'Weapon Mastery',12000,35),
(42,236,7,'Light Armor Mastery',12000,35),
(42,236,8,'Light Armor Mastery',12000,35),
(42,235,7,'Robe Mastery',12000,35),
(42,235,8,'Robe Mastery',12000,35),
(42,146,11,'Anti Magic',12000,35),
(42,146,12,'Anti Magic',12000,35),
(43,1539,1,'Stigma of Shilen',34000,40),
(43,1531,1,'Bless the Blood',36000,40),
(43,146,13,'Anti Magic',12000,40),
(43,146,14,'Anti Magic',12000,40),
(43,146,15,'Anti Magic',12000,40),
(43,235,9,'Robe Mastery',12000,40),
(43,235,10,'Robe Mastery',12000,40),
(43,235,11,'Robe Mastery',12000,40),
(43,236,9,'Light Armor Mastery',12000,40),
(43,236,10,'Light Armor Mastery',12000,40),
(43,236,11,'Light Armor Mastery',12000,40),
(43,249,10,'Weapon Mastery',12000,40),
(43,249,11,'Weapon Mastery',12000,40),
(43,249,12,'Weapon Mastery',12000,40),
(43,213,3,'Boost Mana',36000,40),
(43,228,2,'Fast Spell Casting',36000,40),
(43,1013,5,'Recharge',12000,40),
(43,1013,6,'Recharge',12000,40),
(43,1035,2,'Mental Shield',36000,40),
(43,1068,3,'Might',36000,40),
(43,1189,2,'Resist Wind',36000,40),
(43,1201,10,'Dryad Root',12000,40),
(43,1201,11,'Dryad Root',12000,40),
(43,1201,12,'Dryad Root',12000,40),
(43,1206,6,'Wind Shackle',36000,40),
(43,1240,1,'Guidance',36000,40),
(43,1242,1,'Death Whisper',36000,40),
(43,1268,2,'Vampiric Rage',41000,44),
(43,1206,7,'Wind Shackle',41000,44),
(43,1201,13,'Dryad Root',14000,44),
(43,1201,14,'Dryad Root',14000,44),
(43,1201,15,'Dryad Root',14000,44),
(43,1189,3,'Resist Wind',41000,44),
(43,1077,2,'Focus',41000,44),
(43,1078,3,'Concentration',41000,44),
(43,1040,3,'Shield',41000,44),
(43,1059,2,'Empower',41000,44),
(43,1018,1,'Purify',41000,44),
(43,1013,7,'Recharge',21000,44),
(43,1013,8,'Recharge',21000,44),
(43,229,3,'Fast Mana Recovery',41000,44),
(43,212,2,'Fast HP Recovery',41000,44),
(43,249,13,'Weapon Mastery',14000,44),
(43,249,14,'Weapon Mastery',14000,44),
(43,249,15,'Weapon Mastery',14000,44),
(43,236,12,'Light Armor Mastery',14000,44),
(43,236,13,'Light Armor Mastery',14000,44),
(43,236,14,'Light Armor Mastery',14000,44),
(43,235,12,'Robe Mastery',14000,44),
(43,235,13,'Robe Mastery',14000,44),
(43,235,14,'Robe Mastery',14000,44),
(43,1522,1,'Inquisitor',123000,44),
(43,146,16,'Anti Magic',14000,44),
(43,146,17,'Anti Magic',14000,44),
(43,146,18,'Anti Magic',14000,44),
(43,1531,2,'Bless the Blood',80000,48),
(43,146,19,'Anti Magic',27000,48),
(43,146,20,'Anti Magic',27000,48),
(43,146,21,'Anti Magic',27000,48),
(43,235,15,'Robe Mastery',27000,48),
(43,235,16,'Robe Mastery',27000,48),
(43,235,17,'Robe Mastery',27000,48),
(43,236,15,'Light Armor Mastery',27000,48),
(43,236,16,'Light Armor Mastery',27000,48),
(43,236,17,'Light Armor Mastery',27000,48),
(43,249,16,'Weapon Mastery',27000,48),
(43,249,17,'Weapon Mastery',27000,48),
(43,249,18,'Weapon Mastery',27000,48),
(43,213,4,'Boost Mana',80000,48),
(43,164,3,'Quick Recycle',80000,48),
(43,1013,9,'Recharge',40000,48),
(43,1013,10,'Recharge',40000,48),
(43,1035,3,'Mental Shield',80000,48),
(43,1201,16,'Dryad Root',27000,48),
(43,1201,17,'Dryad Root',27000,48),
(43,1201,18,'Dryad Root',27000,48),
(43,1206,8,'Wind Shackle',80000,48),
(43,1242,2,'Death Whisper',80000,48),
(43,1240,2,'Guidance',80000,48),
(43,1217,1,'Greater Heal',27000,48),
(43,1217,2,'Greater Heal',27000,48),
(43,1217,3,'Greater Heal',27000,48),
(43,1219,1,'Greater Group Heal',27000,48),
(43,1219,2,'Greater Group Heal',27000,48),
(43,1219,3,'Greater Group Heal',27000,48),
(43,1539,2,'Stigma of Shilen',106000,52),
(43,1219,4,'Greater Group Heal',38000,52),
(43,1219,5,'Greater Group Heal',38000,52),
(43,1219,6,'Greater Group Heal',38000,52),
(43,1217,4,'Greater Heal',38000,52),
(43,1217,5,'Greater Heal',38000,52),
(43,1217,6,'Greater Heal',38000,52),
(43,1206,9,'Wind Shackle',113000,52),
(43,1201,19,'Dryad Root',38000,52),
(43,1201,20,'Dryad Root',38000,52),
(43,1201,21,'Dryad Root',38000,52),
(43,1018,2,'Purify',113000,52),
(43,1059,3,'Empower',113000,52),
(43,1073,2,'Kiss of Eva',113000,52),
(43,1078,4,'Concentration',113000,52),
(43,1077,3,'Focus',113000,52),
(43,1013,11,'Recharge',56000,52),
(43,1013,12,'Recharge',56000,52),
(43,229,4,'Fast Mana Recovery',113000,52),
(43,212,3,'Fast HP Recovery',113000,52),
(43,249,19,'Weapon Mastery',38000,52),
(43,249,20,'Weapon Mastery',38000,52),
(43,249,21,'Weapon Mastery',38000,52),
(43,236,18,'Light Armor Mastery',38000,52),
(43,236,19,'Light Armor Mastery',38000,52),
(43,236,20,'Light Armor Mastery',38000,52),
(43,235,18,'Robe Mastery',38000,52),
(43,235,19,'Robe Mastery',38000,52),
(43,235,20,'Robe Mastery',38000,52),
(43,146,22,'Anti Magic',38000,52),
(43,146,23,'Anti Magic',38000,52),
(43,146,24,'Anti Magic',38000,52),
(43,1531,3,'Bless the Blood',111000,56),
(43,146,25,'Anti Magic',37000,56),
(43,146,26,'Anti Magic',37000,56),
(43,146,27,'Anti Magic',37000,56),
(43,235,21,'Robe Mastery',37000,56),
(43,235,22,'Robe Mastery',37000,56),
(43,235,23,'Robe Mastery',37000,56),
(43,236,21,'Light Armor Mastery',37000,56),
(43,236,22,'Light Armor Mastery',37000,56),
(43,236,23,'Light Armor Mastery',37000,56),
(43,249,22,'Weapon Mastery',37000,56),
(43,249,23,'Weapon Mastery',37000,56),
(43,249,24,'Weapon Mastery',37000,56),
(43,213,5,'Boost Mana',111000,56),
(43,228,3,'Fast Spell Casting',111000,56),
(43,1013,13,'Recharge',56000,56),
(43,1013,14,'Recharge',56000,56),
(43,1035,4,'Mental Shield',111000,56),
(43,1201,22,'Dryad Root',37000,56),
(43,1201,23,'Dryad Root',37000,56),
(43,1201,24,'Dryad Root',37000,56),
(43,1206,10,'Wind Shackle',111000,56),
(43,1240,3,'Guidance',111000,56),
(43,1242,3,'Death Whisper',111000,56),
(43,1395,1,'Erase',111000,56),
(43,1398,1,'Mana Burn',111000,56),
(43,1217,7,'Greater Heal',37000,56),
(43,1217,8,'Greater Heal',37000,56),
(43,1217,9,'Greater Heal',37000,56),
(43,1219,7,'Greater Group Heal',37000,56),
(43,1219,8,'Greater Group Heal',37000,56),
(43,1219,9,'Greater Group Heal',37000,56),
(43,1430,1,'Invocation',111000,56),
(43,1392,1,'Holy Resistance',147000,58),
(43,1219,10,'Greater Group Heal',49000,58),
(43,1219,11,'Greater Group Heal',49000,58),
(43,1219,12,'Greater Group Heal',49000,58),
(43,1217,10,'Greater Heal',49000,58),
(43,1217,11,'Greater Heal',49000,58),
(43,1217,12,'Greater Heal',49000,58),
(43,1398,2,'Mana Burn',147000,58),
(43,1395,2,'Erase',147000,58),
(43,1268,3,'Vampiric Rage',147000,58),
(43,1206,11,'Wind Shackle',147000,58),
(43,1201,25,'Dryad Root',147000,58),
(43,1013,15,'Recharge',73000,58),
(43,1013,16,'Recharge',73000,58),
(43,1012,3,'Cure Poison',147000,58),
(43,212,4,'Fast HP Recovery',147000,58),
(43,249,25,'Weapon Mastery',73000,58),
(43,249,26,'Weapon Mastery',73000,58),
(43,236,24,'Light Armor Mastery',73000,58),
(43,236,25,'Light Armor Mastery',73000,58),
(43,235,24,'Robe Mastery',73000,58),
(43,235,25,'Robe Mastery',73000,58),
(43,146,28,'Anti Magic',73000,58),
(43,146,29,'Anti Magic',73000,58),
(43,1531,4,'Bless the Blood',190000,60),
(43,146,30,'Anti Magic',90000,60),
(43,146,31,'Anti Magic',90000,60),
(43,235,26,'Robe Mastery',90000,60),
(43,235,27,'Robe Mastery',90000,60),
(43,236,26,'Light Armor Mastery',90000,60),
(43,236,27,'Light Armor Mastery',90000,60),
(43,249,27,'Weapon Mastery',90000,60),
(43,249,28,'Weapon Mastery',90000,60),
(43,213,6,'Boost Mana',190000,60),
(43,229,5,'Fast Mana Recovery',190000,60),
(43,1013,17,'Recharge',90000,60),
(43,1013,18,'Recharge',90000,60),
(43,1201,26,'Dryad Root',190000,60),
(43,1078,5,'Concentration',190000,60),
(43,1206,12,'Wind Shackle',190000,60),
(43,1395,3,'Erase',190000,60),
(43,1398,3,'Mana Burn',190000,60),
(43,1217,13,'Greater Heal',60000,60),
(43,1217,14,'Greater Heal',60000,60),
(43,1217,15,'Greater Heal',60000,60),
(43,1219,13,'Greater Group Heal',60000,60),
(43,1219,14,'Greater Group Heal',60000,60),
(43,1219,15,'Greater Group Heal',60000,60),
(43,1430,2,'Invocation',190000,60),
(43,1539,3,'Stigma of Shilen',290000,62),
(43,1219,16,'Greater Group Heal',150000,62),
(43,1219,17,'Greater Group Heal',150000,62),
(43,1217,16,'Greater Heal',150000,62),
(43,1217,17,'Greater Heal',150000,62),
(43,1398,4,'Mana Burn',310000,62),
(43,1395,4,'Erase',310000,62),
(43,1206,13,'Wind Shackle',310000,62),
(43,1303,1,'Wild Magic',310000,62),
(43,1018,3,'Purify',310000,62),
(43,1201,27,'Dryad Root',310000,62),
(43,1013,19,'Recharge',150000,62),
(43,1013,20,'Recharge',150000,62),
(43,249,29,'Weapon Mastery',150000,62),
(43,249,30,'Weapon Mastery',150000,62),
(43,236,28,'Light Armor Mastery',150000,62),
(43,236,29,'Light Armor Mastery',150000,62),
(43,235,28,'Robe Mastery',150000,62),
(43,235,29,'Robe Mastery',150000,62),
(43,146,32,'Anti Magic',150000,62),
(43,146,33,'Anti Magic',150000,62),
(43,1531,5,'Bless the Blood',290000,64),
(43,146,34,'Anti Magic',140000,64),
(43,146,35,'Anti Magic',140000,64),
(43,235,30,'Robe Mastery',140000,64),
(43,235,31,'Robe Mastery',140000,64),
(43,236,30,'Light Armor Mastery',140000,64),
(43,236,31,'Light Armor Mastery',140000,64),
(43,249,31,'Weapon Mastery',140000,64),
(43,249,32,'Weapon Mastery',140000,64),
(43,1013,21,'Recharge',140000,64),
(43,1013,22,'Recharge',140000,64),
(43,212,5,'Fast HP Recovery',290000,64),
(43,1201,28,'Dryad Root',290000,64),
(43,1206,14,'Wind Shackle',290000,64),
(43,1395,5,'Erase',290000,64),
(43,1398,5,'Mana Burn',290000,64),
(43,1217,18,'Greater Heal',140000,64),
(43,1217,19,'Greater Heal',140000,64),
(43,1219,18,'Greater Group Heal',140000,64),
(43,1219,19,'Greater Group Heal',140000,64),
(43,1430,3,'Invocation',290000,64),
(43,1392,2,'Holy Resistance',540000,66),
(43,1219,20,'Greater Group Heal',270000,66),
(43,1219,21,'Greater Group Heal',270000,66),
(43,1217,20,'Greater Heal',270000,66),
(43,1217,21,'Greater Heal',270000,66),
(43,1398,6,'Mana Burn',540000,66),
(43,1395,6,'Erase',540000,66),
(43,1206,15,'Wind Shackle',540000,66),
(43,1201,29,'Dryad Root',540000,66),
(43,213,7,'Boost Mana',540000,66),
(43,1013,23,'Recharge',270000,66),
(43,1013,24,'Recharge',270000,66),
(43,249,33,'Weapon Mastery',270000,66),
(43,249,34,'Weapon Mastery',270000,66),
(43,236,32,'Light Armor Mastery',270000,66),
(43,236,33,'Light Armor Mastery',270000,66),
(43,235,32,'Robe Mastery',270000,66),
(43,235,33,'Robe Mastery',270000,66),
(43,146,36,'Anti Magic',270000,66),
(43,146,37,'Anti Magic',270000,66),
(43,1531,6,'Bless the Blood',470000,68),
(43,146,38,'Anti Magic',230000,68),
(43,146,39,'Anti Magic',230000,68),
(43,235,34,'Robe Mastery',230000,68),
(43,235,35,'Robe Mastery',230000,68),
(43,236,34,'Light Armor Mastery',230000,68),
(43,236,35,'Light Armor Mastery',230000,68),
(43,249,35,'Weapon Mastery',230000,68),
(43,249,36,'Weapon Mastery',230000,68),
(43,1013,25,'Recharge',230000,68),
(43,1013,26,'Recharge',230000,68),
(43,229,6,'Fast Mana Recovery',470000,68),
(43,1201,30,'Dryad Root',470000,68),
(43,1078,6,'Concentration',470000,68),
(43,1206,16,'Wind Shackle',470000,68),
(43,1395,7,'Erase',470000,68),
(43,1398,7,'Mana Burn',470000,68),
(43,1217,22,'Greater Heal',230000,68),
(43,1217,23,'Greater Heal',230000,68),
(43,1219,22,'Greater Group Heal',230000,68),
(43,1219,23,'Greater Group Heal',230000,68),
(43,1430,4,'Invocation',470000,68),
(43,1539,4,'Stigma of Shilen',720000,70),
(43,1219,24,'Greater Group Heal',390000,70),
(43,1219,25,'Greater Group Heal',390000,70),
(43,1217,24,'Greater Heal',390000,70),
(43,1217,25,'Greater Heal',390000,70),
(43,1398,8,'Mana Burn',780000,70),
(43,1395,8,'Erase',780000,70),
(43,1206,17,'Wind Shackle',780000,70),
(43,1303,2,'Wild Magic',780000,70),
(43,1201,31,'Dryad Root',780000,70),
(43,1013,27,'Recharge',390000,70),
(43,1013,28,'Recharge',390000,70),
(43,249,37,'Weapon Mastery',390000,70),
(43,249,38,'Weapon Mastery',390000,70),
(43,236,36,'Light Armor Mastery',390000,70),
(43,236,37,'Light Armor Mastery',390000,70),
(43,235,36,'Robe Mastery',390000,70),
(43,235,37,'Robe Mastery',390000,70),
(43,146,40,'Anti Magic',390000,70),
(43,146,41,'Anti Magic',390000,70),
(43,1531,7,'Bless the Blood',1000000,72),
(43,146,42,'Anti Magic',500000,72),
(43,146,43,'Anti Magic',500000,72),
(43,235,38,'Robe Mastery',500000,72),
(43,235,39,'Robe Mastery',500000,72),
(43,236,38,'Light Armor Mastery',500000,72),
(43,236,39,'Light Armor Mastery',500000,72),
(43,249,39,'Weapon Mastery',500000,72),
(43,249,40,'Weapon Mastery',500000,72),
(43,1013,29,'Recharge',500000,72),
(43,1013,30,'Recharge',500000,72),
(43,213,8,'Boost Mana',1000000,72),
(43,1201,32,'Dryad Root',1000000,72),
(43,1268,4,'Vampiric Rage',1000000,72),
(43,1206,18,'Wind Shackle',1000000,72),
(43,1395,9,'Erase',1000000,72),
(43,1398,9,'Mana Burn',1000000,72),
(43,1217,26,'Greater Heal',500000,72),
(43,1217,27,'Greater Heal',500000,72),
(43,1219,26,'Greater Group Heal',500000,72),
(43,1219,27,'Greater Group Heal',500000,72),
(43,1430,5,'Invocation',1000000,72),
(43,1392,3,'Holy Resistance',1640000,74),
(43,1219,28,'Greater Group Heal',820000,74),
(43,1219,29,'Greater Group Heal',820000,74),
(43,1217,28,'Greater Heal',820000,74),
(43,1217,29,'Greater Heal',820000,74),
(43,1398,10,'Mana Burn',1640000,74),
(43,1395,10,'Erase',1640000,74),
(43,1206,19,'Wind Shackle',1640000,74),
(43,1201,33,'Dryad Root',1640000,74),
(43,212,6,'Fast HP Recovery',1640000,74),
(43,229,7,'Fast Mana Recovery',1640000,74),
(43,1013,31,'Recharge',820000,74),
(43,1013,32,'Recharge',820000,74),
(43,249,41,'Weapon Mastery',820000,74),
(43,249,42,'Weapon Mastery',820000,74),
(43,236,40,'Light Armor Mastery',820000,74),
(43,236,41,'Light Armor Mastery',820000,74),
(43,235,40,'Robe Mastery',820000,74),
(43,235,41,'Robe Mastery',820000,74),
(43,146,44,'Anti Magic',820000,74),
(43,146,45,'Anti Magic',820000,74),
(44,134,1,'Toughness',0,1),
(44,226,1,'Relax',190,5),
(44,141,1,'Weapon Mastery',190,5),
(44,142,1,'Armor Mastery',190,5),
(44,3,1,'Power Strike',60,5),
(44,3,2,'Power Strike',60,5),
(44,3,3,'Power Strike',60,5),
(44,29,1,'Iron Punch',60,5),
(44,29,2,'Iron Punch',60,5),
(44,29,3,'Iron Punch',60,5),
(44,29,4,'Iron Punch',460,10),
(44,29,5,'Iron Punch',460,10),
(44,29,6,'Iron Punch',460,10),
(44,3,4,'Power Strike',460,10),
(44,3,5,'Power Strike',460,10),
(44,3,6,'Power Strike',460,10),
(44,142,2,'Armor Mastery',690,10),
(44,142,3,'Armor Mastery',690,10),
(44,141,2,'Weapon Mastery',1300,10),
(44,141,3,'Weapon Mastery',4000,15),
(44,142,4,'Armor Mastery',2000,15),
(44,142,5,'Armor Mastery',2000,15),
(44,3,7,'Power Strike',1300,15),
(44,3,8,'Power Strike',1300,15),
(44,3,9,'Power Strike',1300,15),
(44,29,7,'Iron Punch',1300,15),
(44,29,8,'Iron Punch',1300,15),
(44,29,9,'Iron Punch',1300,15),
(44,295,1,'Iron Body',4000,15),
(45,100,1,'Stun Attack',1100,20),
(45,100,2,'Stun Attack',1100,20),
(45,100,3,'Stun Attack',1100,20),
(45,34,1,'Bandage',3400,20),
(45,211,1,'Boost HP',3400,20),
(45,216,1,'Polearm Mastery',3400,20),
(45,227,1,'Light Armor Mastery',1700,20),
(45,227,2,'Light Armor Mastery',1700,20),
(45,231,1,'Heavy Armor Mastery',1700,20),
(45,231,2,'Heavy Armor Mastery',1700,20),
(45,245,1,'Wild Sweep',1100,20),
(45,245,2,'Wild Sweep',1100,20),
(45,245,3,'Wild Sweep',1100,20),
(45,255,1,'Power Smash',1100,20),
(45,255,2,'Power Smash',1100,20),
(45,255,3,'Power Smash',1100,20),
(45,257,1,'Sword/Blunt Weapon Mastery',3400,20),
(45,293,1,'Two-handed Weapon Mastery',3400,20),
(45,312,1,'Vicious Stance',3400,20),
(45,312,2,'Vicious Stance',5300,24),
(45,293,2,'Two-handed Weapon Mastery',5300,24),
(45,212,1,'Fast HP Recovery',5300,24),
(45,256,1,'Accuracy',5300,24),
(45,257,2,'Sword/Blunt Weapon Mastery',5300,24),
(45,255,4,'Power Smash',1800,24),
(45,255,5,'Power Smash',1800,24),
(45,255,6,'Power Smash',1800,24),
(45,245,4,'Wild Sweep',1800,24),
(45,245,5,'Wild Sweep',1800,24),
(45,245,6,'Wild Sweep',1800,24),
(45,231,3,'Heavy Armor Mastery',2700,24),
(45,231,4,'Heavy Armor Mastery',2700,24),
(45,227,3,'Light Armor Mastery',2700,24),
(45,227,4,'Light Armor Mastery',2700,24),
(45,216,2,'Polearm Mastery',5300,24),
(45,148,1,'Vital Force',5300,24),
(45,94,1,'Rage',5300,24),
(45,100,4,'Stun Attack',1800,24),
(45,100,5,'Stun Attack',1800,24),
(45,100,6,'Stun Attack',1800,24),
(45,100,7,'Stun Attack',3600,28),
(45,100,8,'Stun Attack',3600,28),
(45,100,9,'Stun Attack',3600,28),
(45,121,1,'Battle Roar',11000,28),
(45,211,2,'Boost HP',11000,28),
(45,216,3,'Polearm Mastery',5500,28),
(45,216,4,'Polearm Mastery',5500,28),
(45,227,5,'Light Armor Mastery',3600,28),
(45,227,6,'Light Armor Mastery',3600,28),
(45,227,7,'Light Armor Mastery',3600,28),
(45,231,5,'Heavy Armor Mastery',3600,28),
(45,231,6,'Heavy Armor Mastery',3600,28),
(45,231,7,'Heavy Armor Mastery',3600,28),
(45,245,7,'Wild Sweep',3600,28),
(45,245,8,'Wild Sweep',3600,28),
(45,245,9,'Wild Sweep',3600,28),
(45,255,7,'Power Smash',3600,28),
(45,255,8,'Power Smash',3600,28),
(45,255,9,'Power Smash',3600,28),
(45,257,3,'Sword/Blunt Weapon Mastery',5500,28),
(45,257,4,'Sword/Blunt Weapon Mastery',5500,28),
(45,293,3,'Two-handed Weapon Mastery',11000,28),
(45,312,3,'Vicious Stance',11000,28),
(45,312,4,'Vicious Stance',17000,32),
(45,293,4,'Two-handed Weapon Mastery',17000,32),
(45,212,2,'Fast HP Recovery',17000,32),
(45,257,5,'Sword/Blunt Weapon Mastery',8300,32),
(45,257,6,'Sword/Blunt Weapon Mastery',8300,32),
(45,255,10,'Power Smash',5600,32),
(45,255,11,'Power Smash',5600,32),
(45,255,12,'Power Smash',5600,32),
(45,245,10,'Wild Sweep',5600,32),
(45,245,11,'Wild Sweep',5600,32),
(45,245,12,'Wild Sweep',5600,32),
(45,231,8,'Heavy Armor Mastery',5600,32),
(45,231,9,'Heavy Armor Mastery',5600,32),
(45,231,10,'Heavy Armor Mastery',5600,32),
(45,227,8,'Light Armor Mastery',5600,32),
(45,227,9,'Light Armor Mastery',5600,32),
(45,227,10,'Light Armor Mastery',5600,32),
(45,216,5,'Polearm Mastery',8300,32),
(45,216,6,'Polearm Mastery',8300,32),
(45,148,2,'Vital Force',17000,32),
(45,176,1,'Frenzy',17000,32),
(45,100,10,'Stun Attack',5600,32),
(45,100,11,'Stun Attack',5600,32),
(45,100,12,'Stun Attack',5600,32),
(45,100,13,'Stun Attack',8600,36),
(45,100,14,'Stun Attack',8600,36),
(45,100,15,'Stun Attack',8600,36),
(45,211,3,'Boost HP',17000,36),
(45,139,1,'Guts',17000,36),
(45,216,7,'Polearm Mastery',13000,36),
(45,216,8,'Polearm Mastery',13000,36),
(45,227,11,'Light Armor Mastery',8600,36),
(45,227,12,'Light Armor Mastery',8600,36),
(45,227,13,'Light Armor Mastery',8600,36),
(45,231,11,'Heavy Armor Mastery',8600,36),
(45,231,12,'Heavy Armor Mastery',8600,36),
(45,231,13,'Heavy Armor Mastery',8600,36),
(45,245,13,'Wild Sweep',8600,36),
(45,245,14,'Wild Sweep',8600,36),
(45,245,15,'Wild Sweep',8600,36),
(45,255,13,'Power Smash',8600,36),
(45,255,14,'Power Smash',8600,36),
(45,255,15,'Power Smash',8600,36),
(45,257,7,'Sword/Blunt Weapon Mastery',13000,36),
(45,257,8,'Sword/Blunt Weapon Mastery',13000,36),
(45,287,1,'Lionheart',17000,36),
(45,293,5,'Two-handed Weapon Mastery',17000,36),
(45,312,5,'Vicious Stance',17000,36),
(46,36,1,'Whirlwind',11000,40),
(46,36,2,'Whirlwind',11000,40),
(46,36,3,'Whirlwind',11000,40),
(46,190,1,'Fatal Strike',11000,40),
(46,190,2,'Fatal Strike',11000,40),
(46,190,3,'Fatal Strike',11000,40),
(46,216,9,'Polearm Mastery',11000,40),
(46,216,10,'Polearm Mastery',11000,40),
(46,216,11,'Polearm Mastery',11000,40),
(46,227,14,'Light Armor Mastery',11000,40),
(46,227,15,'Light Armor Mastery',11000,40),
(46,227,16,'Light Armor Mastery',11000,40),
(46,231,14,'Heavy Armor Mastery',11000,40),
(46,231,15,'Heavy Armor Mastery',11000,40),
(46,231,16,'Heavy Armor Mastery',11000,40),
(46,257,9,'Sword/Blunt Weapon Mastery',11000,40),
(46,257,10,'Sword/Blunt Weapon Mastery',11000,40),
(46,257,11,'Sword/Blunt Weapon Mastery',11000,40),
(46,260,1,'Hammer Crush',11000,40),
(46,260,2,'Hammer Crush',11000,40),
(46,260,3,'Hammer Crush',11000,40),
(46,121,2,'Battle Roar',33000,40),
(46,148,3,'Vital Force',33000,40),
(46,212,3,'Fast HP Recovery',33000,40),
(46,293,6,'Two-handed Weapon Mastery',33000,40),
(46,312,6,'Vicious Stance',33000,40),
(46,312,7,'Vicious Stance',38000,43),
(46,293,7,'Two-handed Weapon Mastery',38000,43),
(46,212,4,'Fast HP Recovery',38000,43),
(46,211,4,'Boost HP',38000,43),
(46,139,2,'Guts',38000,43),
(46,260,4,'Hammer Crush',13000,43),
(46,260,5,'Hammer Crush',13000,43),
(46,260,6,'Hammer Crush',13000,43),
(46,257,12,'Sword/Blunt Weapon Mastery',13000,43),
(46,257,13,'Sword/Blunt Weapon Mastery',13000,43),
(46,257,14,'Sword/Blunt Weapon Mastery',13000,43),
(46,231,17,'Heavy Armor Mastery',13000,43),
(46,231,18,'Heavy Armor Mastery',13000,43),
(46,231,19,'Heavy Armor Mastery',13000,43),
(46,227,17,'Light Armor Mastery',13000,43),
(46,227,18,'Light Armor Mastery',13000,43),
(46,227,19,'Light Armor Mastery',13000,43),
(46,216,12,'Polearm Mastery',13000,43),
(46,216,13,'Polearm Mastery',13000,43),
(46,216,14,'Polearm Mastery',13000,43),
(46,190,4,'Fatal Strike',13000,43),
(46,190,5,'Fatal Strike',13000,43),
(46,190,6,'Fatal Strike',13000,43),
(46,36,4,'Whirlwind',13000,43),
(46,36,5,'Whirlwind',13000,43),
(46,36,6,'Whirlwind',13000,43),
(46,36,7,'Whirlwind',17000,46),
(46,36,8,'Whirlwind',17000,46),
(46,36,9,'Whirlwind',17000,46),
(46,190,7,'Fatal Strike',17000,46),
(46,190,8,'Fatal Strike',17000,46),
(46,190,9,'Fatal Strike',17000,46),
(46,216,15,'Polearm Mastery',17000,46),
(46,216,16,'Polearm Mastery',17000,46),
(46,216,17,'Polearm Mastery',17000,46),
(46,227,20,'Light Armor Mastery',17000,46),
(46,227,21,'Light Armor Mastery',17000,46),
(46,227,22,'Light Armor Mastery',17000,46),
(46,231,20,'Heavy Armor Mastery',17000,46),
(46,231,21,'Heavy Armor Mastery',17000,46),
(46,231,22,'Heavy Armor Mastery',17000,46),
(46,257,15,'Sword/Blunt Weapon Mastery',17000,46),
(46,257,16,'Sword/Blunt Weapon Mastery',17000,46),
(46,257,17,'Sword/Blunt Weapon Mastery',17000,46),
(46,260,7,'Hammer Crush',17000,46),
(46,260,8,'Hammer Crush',17000,46),
(46,260,9,'Hammer Crush',17000,46),
(46,34,2,'Bandage',50000,46),
(46,148,4,'Vital Force',50000,46),
(46,176,2,'Frenzy',50000,46),
(46,293,8,'Two-handed Weapon Mastery',50000,46),
(46,312,8,'Vicious Stance',50000,46),
(46,312,9,'Vicious Stance',82000,49),
(46,293,9,'Two-handed Weapon Mastery',82000,49),
(46,287,2,'Lionheart',82000,49),
(46,211,5,'Boost HP',82000,49),
(46,121,3,'Battle Roar',82000,49),
(46,260,10,'Hammer Crush',27000,49),
(46,260,11,'Hammer Crush',27000,49),
(46,260,12,'Hammer Crush',27000,49),
(46,257,18,'Sword/Blunt Weapon Mastery',27000,49),
(46,257,19,'Sword/Blunt Weapon Mastery',27000,49),
(46,257,20,'Sword/Blunt Weapon Mastery',27000,49),
(46,231,23,'Heavy Armor Mastery',27000,49),
(46,231,24,'Heavy Armor Mastery',27000,49),
(46,231,25,'Heavy Armor Mastery',27000,49),
(46,227,23,'Light Armor Mastery',27000,49),
(46,227,24,'Light Armor Mastery',27000,49),
(46,227,25,'Light Armor Mastery',27000,49),
(46,216,18,'Polearm Mastery',27000,49),
(46,216,19,'Polearm Mastery',27000,49),
(46,216,20,'Polearm Mastery',27000,49),
(46,190,10,'Fatal Strike',27000,49),
(46,190,11,'Fatal Strike',27000,49),
(46,190,12,'Fatal Strike',27000,49),
(46,36,10,'Whirlwind',27000,49),
(46,36,11,'Whirlwind',27000,49),
(46,36,12,'Whirlwind',27000,49),
(46,36,13,'Whirlwind',42000,52),
(46,36,14,'Whirlwind',42000,52),
(46,36,15,'Whirlwind',42000,52),
(46,190,13,'Fatal Strike',42000,52),
(46,190,14,'Fatal Strike',42000,52),
(46,190,15,'Fatal Strike',42000,52),
(46,216,21,'Polearm Mastery',42000,52),
(46,216,22,'Polearm Mastery',42000,52),
(46,216,23,'Polearm Mastery',42000,52),
(46,227,26,'Light Armor Mastery',42000,52),
(46,227,27,'Light Armor Mastery',42000,52),
(46,227,28,'Light Armor Mastery',42000,52),
(46,231,26,'Heavy Armor Mastery',42000,52),
(46,231,27,'Heavy Armor Mastery',42000,52),
(46,231,28,'Heavy Armor Mastery',42000,52),
(46,257,21,'Sword/Blunt Weapon Mastery',42000,52),
(46,257,22,'Sword/Blunt Weapon Mastery',42000,52),
(46,257,23,'Sword/Blunt Weapon Mastery',42000,52),
(46,260,13,'Hammer Crush',42000,52),
(46,260,14,'Hammer Crush',42000,52),
(46,260,15,'Hammer Crush',42000,52),
(46,139,3,'Guts',125000,52),
(46,148,5,'Vital Force',125000,52),
(46,212,5,'Fast HP Recovery',125000,52),
(46,293,10,'Two-handed Weapon Mastery',125000,52),
(46,312,10,'Vicious Stance',125000,52),
(46,312,11,'Vicious Stance',142000,55),
(46,94,2,'Rage',142000,55),
(46,293,11,'Two-handed Weapon Mastery',142000,55),
(46,176,3,'Frenzy',142000,55),
(46,211,6,'Boost HP',142000,55),
(46,260,16,'Hammer Crush',47000,55),
(46,260,17,'Hammer Crush',47000,55),
(46,260,18,'Hammer Crush',47000,55),
(46,257,24,'Sword/Blunt Weapon Mastery',47000,55),
(46,257,25,'Sword/Blunt Weapon Mastery',47000,55),
(46,257,26,'Sword/Blunt Weapon Mastery',47000,55),
(46,231,29,'Heavy Armor Mastery',47000,55),
(46,231,30,'Heavy Armor Mastery',47000,55),
(46,231,31,'Heavy Armor Mastery',47000,55),
(46,227,29,'Light Armor Mastery',47000,55),
(46,227,30,'Light Armor Mastery',47000,55),
(46,227,31,'Light Armor Mastery',47000,55),
(46,216,24,'Polearm Mastery',47000,55),
(46,216,25,'Polearm Mastery',47000,55),
(46,216,26,'Polearm Mastery',47000,55),
(46,190,16,'Fatal Strike',47000,55),
(46,190,17,'Fatal Strike',47000,55),
(46,190,18,'Fatal Strike',47000,55),
(46,36,16,'Whirlwind',47000,55),
(46,36,17,'Whirlwind',47000,55),
(46,36,18,'Whirlwind',47000,55),
(46,36,19,'Whirlwind',60000,58),
(46,36,20,'Whirlwind',60000,58),
(46,36,21,'Whirlwind',60000,58),
(46,190,19,'Fatal Strike',60000,58),
(46,190,20,'Fatal Strike',60000,58),
(46,190,21,'Fatal Strike',60000,58),
(46,216,27,'Polearm Mastery',60000,58),
(46,216,28,'Polearm Mastery',60000,58),
(46,216,29,'Polearm Mastery',60000,58),
(46,227,32,'Light Armor Mastery',60000,58),
(46,227,33,'Light Armor Mastery',60000,58),
(46,227,34,'Light Armor Mastery',60000,58),
(46,231,32,'Heavy Armor Mastery',60000,58),
(46,231,33,'Heavy Armor Mastery',60000,58),
(46,231,34,'Heavy Armor Mastery',60000,58),
(46,257,27,'Sword/Blunt Weapon Mastery',60000,58),
(46,257,28,'Sword/Blunt Weapon Mastery',60000,58),
(46,257,29,'Sword/Blunt Weapon Mastery',60000,58),
(46,260,19,'Hammer Crush',60000,58),
(46,260,20,'Hammer Crush',60000,58),
(46,260,21,'Hammer Crush',60000,58),
(46,148,6,'Vital Force',181000,58),
(46,121,4,'Battle Roar',181000,58),
(46,212,6,'Fast HP Recovery',181000,58),
(46,293,12,'Two-handed Weapon Mastery',181000,58),
(46,420,1,'Zealot',181000,58),
(46,422,1,'Polearm Accuracy',181000,58),
(46,423,1,'Infernal Form',181000,58),
(46,424,1,'War Frenzy',181000,58),
(46,312,12,'Vicious Stance',181000,58),
(46,312,13,'Vicious Stance',290000,60),
(46,315,1,'Crush of Doom',145000,60),
(46,315,2,'Crush of Doom',145000,60),
(46,293,13,'Two-handed Weapon Mastery',290000,60),
(46,260,22,'Hammer Crush',145000,60),
(46,260,23,'Hammer Crush',145000,60),
(46,257,30,'Sword/Blunt Weapon Mastery',145000,60),
(46,257,31,'Sword/Blunt Weapon Mastery',145000,60),
(46,231,35,'Heavy Armor Mastery',145000,60),
(46,231,36,'Heavy Armor Mastery',145000,60),
(46,227,35,'Light Armor Mastery',145000,60),
(46,227,36,'Light Armor Mastery',145000,60),
(46,216,30,'Polearm Mastery',145000,60),
(46,216,31,'Polearm Mastery',145000,60),
(46,190,22,'Fatal Strike',145000,60),
(46,190,23,'Fatal Strike',145000,60),
(46,36,22,'Whirlwind',145000,60),
(46,36,23,'Whirlwind',145000,60),
(46,36,24,'Whirlwind',150000,62),
(46,36,25,'Whirlwind',150000,62),
(46,190,24,'Fatal Strike',150000,62),
(46,190,25,'Fatal Strike',150000,62),
(46,216,32,'Polearm Mastery',150000,62),
(46,216,33,'Polearm Mastery',150000,62),
(46,227,37,'Light Armor Mastery',150000,62),
(46,227,38,'Light Armor Mastery',150000,62),
(46,231,37,'Heavy Armor Mastery',150000,62),
(46,231,38,'Heavy Armor Mastery',150000,62),
(46,257,32,'Sword/Blunt Weapon Mastery',150000,62),
(46,257,33,'Sword/Blunt Weapon Mastery',150000,62),
(46,260,24,'Hammer Crush',150000,62),
(46,260,25,'Hammer Crush',150000,62),
(46,293,14,'Two-handed Weapon Mastery',310000,62),
(46,287,3,'Lionheart',310000,62),
(46,34,3,'Bandage',310000,62),
(46,211,7,'Boost HP',310000,62),
(46,315,3,'Crush of Doom',150000,62),
(46,315,4,'Crush of Doom',150000,62),
(46,312,14,'Vicious Stance',310000,62),
(46,312,15,'Vicious Stance',400000,64),
(46,315,5,'Crush of Doom',200000,64),
(46,315,6,'Crush of Doom',200000,64),
(46,148,7,'Vital Force',400000,64),
(46,121,5,'Battle Roar',400000,64),
(46,293,15,'Two-handed Weapon Mastery',400000,64),
(46,260,26,'Hammer Crush',200000,64),
(46,260,27,'Hammer Crush',200000,64),
(46,257,34,'Sword/Blunt Weapon Mastery',200000,64),
(46,257,35,'Sword/Blunt Weapon Mastery',200000,64),
(46,231,39,'Heavy Armor Mastery',200000,64),
(46,231,40,'Heavy Armor Mastery',200000,64),
(46,227,39,'Light Armor Mastery',200000,64),
(46,227,40,'Light Armor Mastery',200000,64),
(46,216,34,'Polearm Mastery',200000,64),
(46,216,35,'Polearm Mastery',200000,64),
(46,190,26,'Fatal Strike',200000,64),
(46,190,27,'Fatal Strike',200000,64),
(46,36,26,'Whirlwind',200000,64),
(46,36,27,'Whirlwind',200000,64),
(46,36,28,'Whirlwind',220000,66),
(46,36,29,'Whirlwind',220000,66),
(46,190,28,'Fatal Strike',220000,66),
(46,190,29,'Fatal Strike',220000,66),
(46,216,36,'Polearm Mastery',220000,66),
(46,216,37,'Polearm Mastery',220000,66),
(46,227,41,'Light Armor Mastery',220000,66),
(46,227,42,'Light Armor Mastery',220000,66),
(46,231,41,'Heavy Armor Mastery',220000,66),
(46,231,42,'Heavy Armor Mastery',220000,66),
(46,257,36,'Sword/Blunt Weapon Mastery',220000,66),
(46,257,37,'Sword/Blunt Weapon Mastery',220000,66),
(46,260,28,'Hammer Crush',220000,66),
(46,260,29,'Hammer Crush',220000,66),
(46,293,16,'Two-handed Weapon Mastery',440000,66),
(46,211,8,'Boost HP',440000,66),
(46,315,7,'Crush of Doom',220000,66),
(46,315,8,'Crush of Doom',220000,66),
(46,312,16,'Vicious Stance',440000,66),
(46,320,1,'Wrath',220000,66),
(46,320,2,'Wrath',220000,66),
(46,424,2,'War Frenzy',440000,66),
(46,423,2,'Infernal Form',440000,66),
(46,422,2,'Polearm Accuracy',440000,66),
(46,420,2,'Zealot',440000,66),
(46,320,3,'Wrath',330000,68),
(46,320,4,'Wrath',330000,68),
(46,312,17,'Vicious Stance',650000,68),
(46,315,9,'Crush of Doom',330000,68),
(46,315,10,'Crush of Doom',330000,68),
(46,293,17,'Two-handed Weapon Mastery',650000,68),
(46,212,7,'Fast HP Recovery',650000,68),
(46,260,30,'Hammer Crush',330000,68),
(46,260,31,'Hammer Crush',330000,68),
(46,257,38,'Sword/Blunt Weapon Mastery',330000,68),
(46,257,39,'Sword/Blunt Weapon Mastery',330000,68),
(46,231,43,'Heavy Armor Mastery',330000,68),
(46,231,44,'Heavy Armor Mastery',330000,68),
(46,227,43,'Light Armor Mastery',330000,68),
(46,227,44,'Light Armor Mastery',330000,68),
(46,216,38,'Polearm Mastery',330000,68),
(46,216,39,'Polearm Mastery',330000,68),
(46,190,30,'Fatal Strike',330000,68),
(46,190,31,'Fatal Strike',330000,68),
(46,36,30,'Whirlwind',330000,68),
(46,36,31,'Whirlwind',330000,68),
(46,36,32,'Whirlwind',360000,70),
(46,36,33,'Whirlwind',360000,70),
(46,190,32,'Fatal Strike',360000,70),
(46,190,33,'Fatal Strike',360000,70),
(46,216,40,'Polearm Mastery',360000,70),
(46,216,41,'Polearm Mastery',360000,70),
(46,227,45,'Light Armor Mastery',360000,70),
(46,227,46,'Light Armor Mastery',360000,70),
(46,231,45,'Heavy Armor Mastery',360000,70),
(46,231,46,'Heavy Armor Mastery',360000,70),
(46,257,40,'Sword/Blunt Weapon Mastery',360000,70),
(46,257,41,'Sword/Blunt Weapon Mastery',360000,70),
(46,260,32,'Hammer Crush',360000,70),
(46,260,33,'Hammer Crush',360000,70),
(46,293,18,'Two-handed Weapon Mastery',720000,70),
(46,211,9,'Boost HP',720000,70),
(46,121,6,'Battle Roar',720000,70),
(46,315,11,'Crush of Doom',360000,70),
(46,315,12,'Crush of Doom',360000,70),
(46,312,18,'Vicious Stance',720000,70),
(46,320,5,'Wrath',360000,70),
(46,320,6,'Wrath',360000,70),
(46,320,7,'Wrath',500000,72),
(46,320,8,'Wrath',500000,72),
(46,312,19,'Vicious Stance',1000000,72),
(46,315,13,'Crush of Doom',500000,72),
(46,315,14,'Crush of Doom',500000,72),
(46,148,8,'Vital Force',1000000,72),
(46,293,19,'Two-handed Weapon Mastery',1000000,72),
(46,260,34,'Hammer Crush',500000,72),
(46,260,35,'Hammer Crush',500000,72),
(46,257,42,'Sword/Blunt Weapon Mastery',500000,72),
(46,257,43,'Sword/Blunt Weapon Mastery',500000,72),
(46,231,47,'Heavy Armor Mastery',500000,72),
(46,231,48,'Heavy Armor Mastery',500000,72),
(46,227,47,'Light Armor Mastery',500000,72),
(46,227,48,'Light Armor Mastery',500000,72),
(46,216,42,'Polearm Mastery',500000,72),
(46,216,43,'Polearm Mastery',500000,72),
(46,190,34,'Fatal Strike',500000,72),
(46,190,35,'Fatal Strike',500000,72),
(46,36,34,'Whirlwind',500000,72),
(46,36,35,'Whirlwind',500000,72),
(46,36,36,'Whirlwind',760000,74),
(46,36,37,'Whirlwind',760000,74),
(46,190,36,'Fatal Strike',760000,74),
(46,190,37,'Fatal Strike',760000,74),
(46,216,44,'Polearm Mastery',760000,74),
(46,216,45,'Polearm Mastery',760000,74),
(46,227,49,'Light Armor Mastery',760000,74),
(46,227,50,'Light Armor Mastery',760000,74),
(46,231,49,'Heavy Armor Mastery',760000,74),
(46,231,50,'Heavy Armor Mastery',760000,74),
(46,257,44,'Sword/Blunt Weapon Mastery',760000,74),
(46,257,45,'Sword/Blunt Weapon Mastery',760000,74),
(46,260,36,'Hammer Crush',760000,74),
(46,260,37,'Hammer Crush',760000,74),
(46,293,20,'Two-handed Weapon Mastery',1530000,74),
(46,212,8,'Fast HP Recovery',1530000,74),
(46,211,10,'Boost HP',1530000,74),
(46,315,15,'Crush of Doom',760000,74),
(46,315,16,'Crush of Doom',760000,74),
(46,312,20,'Vicious Stance',1530000,74),
(46,320,9,'Wrath',760000,74),
(46,320,10,'Wrath',760000,74),
(46,420,3,'Zealot',1530000,74),
(46,422,3,'Polearm Accuracy',1530000,74),
(46,423,3,'Infernal Form',1530000,74),
(46,424,3,'War Frenzy',1530000,74),
(47,29,10,'Iron Punch',2600,20),
(47,29,11,'Iron Punch',2600,20),
(47,29,12,'Iron Punch',2600,20),
(47,120,1,'Stunning Fist',2600,20),
(47,120,2,'Stunning Fist',2600,20),
(47,120,3,'Stunning Fist',2600,20),
(47,210,1,'Fist Weapon Mastery',5300,20),
(47,233,1,'Light Armor Mastery',2600,20),
(47,233,2,'Light Armor Mastery',2600,20),
(47,83,1,'Wolf Spirit Totem',5300,20),
(47,95,1,'Cripple',5300,20),
(47,319,1,'Agile Movement',5300,20),
(47,50,1,'Focused Force',10000,24),
(47,95,2,'Cripple',10000,24),
(47,233,3,'Light Armor Mastery',5000,24),
(47,233,4,'Light Armor Mastery',5000,24),
(47,210,2,'Fist Weapon Mastery',10000,24),
(47,120,4,'Stunning Fist',3300,24),
(47,120,5,'Stunning Fist',3300,24),
(47,120,6,'Stunning Fist',3300,24),
(47,29,13,'Iron Punch',3300,24),
(47,29,14,'Iron Punch',3300,24),
(47,29,15,'Iron Punch',3300,24),
(47,54,1,'Force Blaster',3300,24),
(47,54,2,'Force Blaster',3300,24),
(47,54,3,'Force Blaster',3300,24),
(47,54,4,'Force Blaster',5700,28),
(47,54,5,'Force Blaster',5700,28),
(47,54,6,'Force Blaster',5700,28),
(47,29,16,'Iron Punch',5700,28),
(47,29,17,'Iron Punch',5700,28),
(47,29,18,'Iron Punch',5700,28),
(47,120,7,'Stunning Fist',5700,28),
(47,120,8,'Stunning Fist',5700,28),
(47,120,9,'Stunning Fist',5700,28),
(47,210,3,'Fist Weapon Mastery',8600,28),
(47,210,4,'Fist Weapon Mastery',8600,28),
(47,233,5,'Light Armor Mastery',8600,28),
(47,233,6,'Light Armor Mastery',8600,28),
(47,95,3,'Cripple',17000,28),
(47,76,1,'Bear Spirit Totem',17000,28),
(47,50,2,'Focused Force',29000,32),
(47,95,4,'Cripple',29000,32),
(47,233,7,'Light Armor Mastery',14000,32),
(47,233,8,'Light Armor Mastery',14000,32),
(47,210,5,'Fist Weapon Mastery',14000,32),
(47,210,6,'Fist Weapon Mastery',14000,32),
(47,120,10,'Stunning Fist',9500,32),
(47,120,11,'Stunning Fist',9500,32),
(47,120,12,'Stunning Fist',9500,32),
(47,29,19,'Iron Punch',9500,32),
(47,29,20,'Iron Punch',9500,32),
(47,29,21,'Iron Punch',9500,32),
(47,54,7,'Force Blaster',9500,32),
(47,54,8,'Force Blaster',9500,32),
(47,54,9,'Force Blaster',9500,32),
(47,54,10,'Force Blaster',13000,36),
(47,54,11,'Force Blaster',13000,36),
(47,54,12,'Force Blaster',13000,36),
(47,29,22,'Iron Punch',13000,36),
(47,29,23,'Iron Punch',13000,36),
(47,29,24,'Iron Punch',13000,36),
(47,120,13,'Stunning Fist',13000,36),
(47,120,14,'Stunning Fist',13000,36),
(47,120,15,'Stunning Fist',13000,36),
(47,168,1,'Boost Attack Speed',39000,36),
(47,210,7,'Fist Weapon Mastery',19000,36),
(47,210,8,'Fist Weapon Mastery',19000,36),
(47,233,9,'Light Armor Mastery',19000,36),
(47,233,10,'Light Armor Mastery',19000,36),
(47,284,1,'Hurricane Assault',13000,36),
(47,284,2,'Hurricane Assault',13000,36),
(47,284,3,'Hurricane Assault',13000,36),
(47,95,5,'Cripple',39000,36),
(48,54,13,'Force Blaster',13000,40),
(48,54,14,'Force Blaster',13000,40),
(48,54,15,'Force Blaster',13000,40),
(48,95,6,'Cripple',39000,40),
(48,50,3,'Focused Force',39000,40),
(48,210,9,'Fist Weapon Mastery',13000,40),
(48,210,10,'Fist Weapon Mastery',13000,40),
(48,210,11,'Fist Weapon Mastery',13000,40),
(48,233,11,'Light Armor Mastery',13000,40),
(48,233,12,'Light Armor Mastery',13000,40),
(48,233,13,'Light Armor Mastery',13000,40),
(48,280,1,'Burning Fist',13000,40),
(48,280,2,'Burning Fist',13000,40),
(48,280,3,'Burning Fist',13000,40),
(48,281,1,'Soul Breaker',13000,40),
(48,281,2,'Soul Breaker',13000,40),
(48,281,3,'Soul Breaker',13000,40),
(48,282,1,'Puma Spirit Totem',39000,40),
(48,284,4,'Hurricane Assault',13000,40),
(48,284,5,'Hurricane Assault',13000,40),
(48,284,6,'Hurricane Assault',13000,40),
(48,319,2,'Agile Movement',39000,40),
(48,222,1,'Fist Fury',51000,43),
(48,284,7,'Hurricane Assault',17000,43),
(48,284,8,'Hurricane Assault',17000,43),
(48,284,9,'Hurricane Assault',17000,43),
(48,281,4,'Soul Breaker',17000,43),
(48,281,5,'Soul Breaker',17000,43),
(48,281,6,'Soul Breaker',17000,43),
(48,280,4,'Burning Fist',17000,43),
(48,280,5,'Burning Fist',17000,43),
(48,280,6,'Burning Fist',17000,43),
(48,233,14,'Light Armor Mastery',17000,43),
(48,233,15,'Light Armor Mastery',17000,43),
(48,233,16,'Light Armor Mastery',17000,43),
(48,210,12,'Fist Weapon Mastery',17000,43),
(48,210,13,'Fist Weapon Mastery',17000,43),
(48,210,14,'Fist Weapon Mastery',17000,43),
(48,95,7,'Cripple',51000,43),
(48,54,16,'Force Blaster',17000,43),
(48,54,17,'Force Blaster',17000,43),
(48,54,18,'Force Blaster',17000,43),
(48,17,1,'Force Burst',17000,43),
(48,17,2,'Force Burst',17000,43),
(48,17,3,'Force Burst',17000,43),
(48,17,4,'Force Burst',20000,46),
(48,17,5,'Force Burst',20000,46),
(48,17,6,'Force Burst',20000,46),
(48,54,19,'Force Blaster',20000,46),
(48,54,20,'Force Blaster',20000,46),
(48,54,21,'Force Blaster',20000,46),
(48,95,8,'Cripple',60000,46),
(48,109,1,'Ogre Spirit Totem',60000,46),
(48,168,2,'Boost Attack Speed',60000,46),
(48,210,15,'Fist Weapon Mastery',20000,46),
(48,210,16,'Fist Weapon Mastery',20000,46),
(48,210,17,'Fist Weapon Mastery',20000,46),
(48,233,17,'Light Armor Mastery',20000,46),
(48,233,18,'Light Armor Mastery',20000,46),
(48,233,19,'Light Armor Mastery',20000,46),
(48,280,7,'Burning Fist',20000,46),
(48,280,8,'Burning Fist',20000,46),
(48,280,9,'Burning Fist',20000,46),
(48,281,7,'Soul Breaker',20000,46),
(48,281,8,'Soul Breaker',20000,46),
(48,281,9,'Soul Breaker',20000,46),
(48,284,10,'Hurricane Assault',20000,46),
(48,284,11,'Hurricane Assault',20000,46),
(48,284,12,'Hurricane Assault',20000,46),
(48,284,13,'Hurricane Assault',36000,49),
(48,284,14,'Hurricane Assault',36000,49),
(48,284,15,'Hurricane Assault',36000,49),
(48,281,10,'Soul Breaker',36000,49),
(48,281,11,'Soul Breaker',36000,49),
(48,281,12,'Soul Breaker',36000,49),
(48,280,10,'Burning Fist',36000,49),
(48,280,11,'Burning Fist',36000,49),
(48,280,12,'Burning Fist',36000,49),
(48,233,20,'Light Armor Mastery',36000,49),
(48,233,21,'Light Armor Mastery',36000,49),
(48,233,22,'Light Armor Mastery',36000,49),
(48,210,18,'Fist Weapon Mastery',36000,49),
(48,210,19,'Fist Weapon Mastery',36000,49),
(48,210,20,'Fist Weapon Mastery',36000,49),
(48,95,9,'Cripple',108000,49),
(48,35,1,'Force Storm',36000,49),
(48,35,2,'Force Storm',36000,49),
(48,35,3,'Force Storm',36000,49),
(48,54,22,'Force Blaster',36000,49),
(48,54,23,'Force Blaster',36000,49),
(48,54,24,'Force Blaster',36000,49),
(48,17,7,'Force Burst',36000,49),
(48,17,8,'Force Burst',36000,49),
(48,17,9,'Force Burst',36000,49),
(48,17,10,'Force Burst',50000,52),
(48,17,11,'Force Burst',50000,52),
(48,17,12,'Force Burst',50000,52),
(48,54,25,'Force Blaster',50000,52),
(48,54,26,'Force Blaster',50000,52),
(48,54,27,'Force Blaster',50000,52),
(48,35,4,'Force Storm',50000,52),
(48,35,5,'Force Storm',50000,52),
(48,35,6,'Force Storm',50000,52),
(48,95,10,'Cripple',150000,52),
(48,50,4,'Focused Force',150000,52),
(48,210,21,'Fist Weapon Mastery',50000,52),
(48,210,22,'Fist Weapon Mastery',50000,52),
(48,210,23,'Fist Weapon Mastery',50000,52),
(48,233,23,'Light Armor Mastery',50000,52),
(48,233,24,'Light Armor Mastery',50000,52),
(48,233,25,'Light Armor Mastery',50000,52),
(48,280,13,'Burning Fist',50000,52),
(48,280,14,'Burning Fist',50000,52),
(48,280,15,'Burning Fist',50000,52),
(48,281,13,'Soul Breaker',50000,52),
(48,281,14,'Soul Breaker',50000,52),
(48,281,15,'Soul Breaker',50000,52),
(48,284,16,'Hurricane Assault',50000,52),
(48,284,17,'Hurricane Assault',50000,52),
(48,284,18,'Hurricane Assault',50000,52),
(48,284,19,'Hurricane Assault',57000,55),
(48,284,20,'Hurricane Assault',57000,55),
(48,284,21,'Hurricane Assault',57000,55),
(48,281,16,'Soul Breaker',57000,55),
(48,281,17,'Soul Breaker',57000,55),
(48,281,18,'Soul Breaker',57000,55),
(48,280,16,'Burning Fist',57000,55),
(48,280,17,'Burning Fist',57000,55),
(48,280,18,'Burning Fist',57000,55),
(48,233,26,'Light Armor Mastery',57000,55),
(48,233,27,'Light Armor Mastery',57000,55),
(48,233,28,'Light Armor Mastery',57000,55),
(48,210,24,'Fist Weapon Mastery',57000,55),
(48,210,25,'Fist Weapon Mastery',57000,55),
(48,210,26,'Fist Weapon Mastery',57000,55),
(48,81,1,'Punch of Doom',170000,55),
(48,95,11,'Cripple',170000,55),
(48,35,7,'Force Storm',57000,55),
(48,35,8,'Force Storm',57000,55),
(48,35,9,'Force Storm',57000,55),
(48,54,28,'Force Blaster',57000,55),
(48,54,29,'Force Blaster',57000,55),
(48,54,30,'Force Blaster',57000,55),
(48,17,13,'Force Burst',57000,55),
(48,17,14,'Force Burst',57000,55),
(48,17,15,'Force Burst',57000,55),
(48,17,16,'Force Burst',74000,58),
(48,17,17,'Force Burst',74000,58),
(48,17,18,'Force Burst',74000,58),
(48,54,31,'Force Blaster',74000,58),
(48,54,32,'Force Blaster',74000,58),
(48,54,33,'Force Blaster',74000,58),
(48,35,10,'Force Storm',74000,58),
(48,35,11,'Force Storm',74000,58),
(48,35,12,'Force Storm',74000,58),
(48,95,12,'Cripple',223000,58),
(48,168,3,'Boost Attack Speed',223000,58),
(48,210,27,'Fist Weapon Mastery',74000,58),
(48,210,28,'Fist Weapon Mastery',74000,58),
(48,210,29,'Fist Weapon Mastery',74000,58),
(48,233,29,'Light Armor Mastery',74000,58),
(48,233,30,'Light Armor Mastery',74000,58),
(48,233,31,'Light Armor Mastery',74000,58),
(48,280,19,'Burning Fist',74000,58),
(48,280,20,'Burning Fist',74000,58),
(48,280,21,'Burning Fist',74000,58),
(48,281,19,'Soul Breaker',74000,58),
(48,281,20,'Soul Breaker',74000,58),
(48,281,21,'Soul Breaker',74000,58),
(48,284,22,'Hurricane Assault',74000,58),
(48,284,23,'Hurricane Assault',74000,58),
(48,284,24,'Hurricane Assault',74000,58),
(48,423,1,'Infernal Form',223000,58),
(48,420,1,'Zealot',223000,58),
(48,424,1,'War Frenzy',223000,58),
(48,461,1,'Break Duress',264000,60),
(48,284,25,'Hurricane Assault',132000,60),
(48,284,26,'Hurricane Assault',132000,60),
(48,281,22,'Soul Breaker',132000,60),
(48,281,23,'Soul Breaker',132000,60),
(48,280,22,'Burning Fist',132000,60),
(48,280,23,'Burning Fist',132000,60),
(48,233,32,'Light Armor Mastery',132000,60),
(48,233,33,'Light Armor Mastery',132000,60),
(48,210,30,'Fist Weapon Mastery',132000,60),
(48,210,31,'Fist Weapon Mastery',132000,60),
(48,50,5,'Focused Force',264000,60),
(48,95,13,'Cripple',264000,60),
(48,35,13,'Force Storm',132000,60),
(48,35,14,'Force Storm',132000,60),
(48,54,34,'Force Blaster',132000,60),
(48,54,35,'Force Blaster',132000,60),
(48,17,19,'Force Burst',132000,60),
(48,17,20,'Force Burst',132000,60),
(48,17,21,'Force Burst',200000,62),
(48,17,22,'Force Burst',200000,62),
(48,54,36,'Force Blaster',200000,62),
(48,54,37,'Force Blaster',200000,62),
(48,35,15,'Force Storm',200000,62),
(48,35,16,'Force Storm',200000,62),
(48,95,14,'Cripple',400000,62),
(48,210,32,'Fist Weapon Mastery',200000,62),
(48,210,33,'Fist Weapon Mastery',200000,62),
(48,233,34,'Light Armor Mastery',200000,62),
(48,233,35,'Light Armor Mastery',200000,62),
(48,280,24,'Burning Fist',200000,62),
(48,280,25,'Burning Fist',200000,62),
(48,281,24,'Soul Breaker',200000,62),
(48,281,25,'Soul Breaker',200000,62),
(48,284,27,'Hurricane Assault',200000,62),
(48,284,28,'Hurricane Assault',200000,62),
(48,298,1,'Rabbit Spirit Totem',400000,62),
(48,284,29,'Hurricane Assault',240000,64),
(48,284,30,'Hurricane Assault',240000,64),
(48,281,26,'Soul Breaker',240000,64),
(48,281,27,'Soul Breaker',240000,64),
(48,280,26,'Burning Fist',240000,64),
(48,280,27,'Burning Fist',240000,64),
(48,233,36,'Light Armor Mastery',240000,64),
(48,233,37,'Light Armor Mastery',240000,64),
(48,210,34,'Fist Weapon Mastery',240000,64),
(48,210,35,'Fist Weapon Mastery',240000,64),
(48,95,15,'Cripple',480000,64),
(48,81,2,'Punch of Doom',480000,64),
(48,35,17,'Force Storm',240000,64),
(48,35,18,'Force Storm',240000,64),
(48,54,38,'Force Blaster',240000,64),
(48,54,39,'Force Blaster',240000,64),
(48,17,23,'Force Burst',240000,64),
(48,17,24,'Force Burst',240000,64),
(48,17,25,'Force Burst',250000,66),
(48,17,26,'Force Burst',250000,66),
(48,54,40,'Force Blaster',250000,66),
(48,54,41,'Force Blaster',250000,66),
(48,35,19,'Force Storm',250000,66),
(48,35,20,'Force Storm',250000,66),
(48,50,6,'Focused Force',500000,66),
(48,95,16,'Cripple',500000,66),
(48,210,36,'Fist Weapon Mastery',250000,66),
(48,210,37,'Fist Weapon Mastery',250000,66),
(48,233,38,'Light Armor Mastery',250000,66),
(48,233,39,'Light Armor Mastery',250000,66),
(48,280,28,'Burning Fist',250000,66),
(48,280,29,'Burning Fist',250000,66),
(48,281,28,'Soul Breaker',250000,66),
(48,281,29,'Soul Breaker',250000,66),
(48,284,31,'Hurricane Assault',250000,66),
(48,284,32,'Hurricane Assault',250000,66),
(48,461,2,'Break Duress',500000,66),
(48,424,2,'War Frenzy',500000,66),
(48,420,2,'Zealot',500000,66),
(48,423,2,'Infernal Form',500000,66),
(48,292,1,'Bison Spirit Totem',780000,68),
(48,284,33,'Hurricane Assault',390000,68),
(48,284,34,'Hurricane Assault',390000,68),
(48,281,30,'Soul Breaker',390000,68),
(48,281,31,'Soul Breaker',390000,68),
(48,280,30,'Burning Fist',390000,68),
(48,280,31,'Burning Fist',390000,68),
(48,233,40,'Light Armor Mastery',390000,68),
(48,233,41,'Light Armor Mastery',390000,68),
(48,210,38,'Fist Weapon Mastery',390000,68),
(48,210,39,'Fist Weapon Mastery',390000,68),
(48,95,17,'Cripple',780000,68),
(48,35,21,'Force Storm',390000,68),
(48,35,22,'Force Storm',390000,68),
(48,54,42,'Force Blaster',390000,68),
(48,54,43,'Force Blaster',390000,68),
(48,17,27,'Force Burst',390000,68),
(48,17,28,'Force Burst',390000,68),
(48,17,29,'Force Burst',520000,70),
(48,17,30,'Force Burst',520000,70),
(48,54,44,'Force Blaster',520000,70),
(48,54,45,'Force Blaster',520000,70),
(48,35,23,'Force Storm',520000,70),
(48,35,24,'Force Storm',520000,70),
(48,95,18,'Cripple',1030000,70),
(48,210,40,'Fist Weapon Mastery',520000,70),
(48,210,41,'Fist Weapon Mastery',520000,70),
(48,233,42,'Light Armor Mastery',520000,70),
(48,233,43,'Light Armor Mastery',520000,70),
(48,280,32,'Burning Fist',520000,70),
(48,280,33,'Burning Fist',520000,70),
(48,281,32,'Soul Breaker',520000,70),
(48,281,33,'Soul Breaker',520000,70),
(48,284,35,'Hurricane Assault',520000,70),
(48,284,36,'Hurricane Assault',520000,70),
(48,284,37,'Hurricane Assault',550000,72),
(48,284,38,'Hurricane Assault',550000,72),
(48,281,34,'Soul Breaker',550000,72),
(48,281,35,'Soul Breaker',550000,72),
(48,280,34,'Burning Fist',550000,72),
(48,280,35,'Burning Fist',550000,72),
(48,233,44,'Light Armor Mastery',550000,72),
(48,233,45,'Light Armor Mastery',550000,72),
(48,210,42,'Fist Weapon Mastery',550000,72),
(48,210,43,'Fist Weapon Mastery',550000,72),
(48,95,19,'Cripple',1090000,72),
(48,50,7,'Focused Force',1090000,72),
(48,81,3,'Punch of Doom',1090000,72),
(48,35,25,'Force Storm',550000,72),
(48,35,26,'Force Storm',550000,72),
(48,54,46,'Force Blaster',550000,72),
(48,54,47,'Force Blaster',550000,72),
(48,17,31,'Force Burst',550000,72),
(48,17,32,'Force Burst',550000,72),
(48,17,33,'Force Burst',1000000,74),
(48,17,34,'Force Burst',1000000,74),
(48,54,48,'Force Blaster',1000000,74),
(48,54,49,'Force Blaster',1000000,74),
(48,35,27,'Force Storm',1000000,74),
(48,35,28,'Force Storm',1000000,74),
(48,95,20,'Cripple',2000000,74),
(48,210,44,'Fist Weapon Mastery',1000000,74),
(48,210,45,'Fist Weapon Mastery',1000000,74),
(48,233,46,'Light Armor Mastery',1000000,74),
(48,233,47,'Light Armor Mastery',1000000,74),
(48,280,36,'Burning Fist',1000000,74),
(48,280,37,'Burning Fist',1000000,74),
(48,281,36,'Soul Breaker',1000000,74),
(48,281,37,'Soul Breaker',1000000,74),
(48,284,39,'Hurricane Assault',1000000,74),
(48,284,40,'Hurricane Assault',1000000,74),
(48,423,3,'Infernal Form',2000000,74),
(48,420,3,'Zealot',2000000,74),
(48,424,3,'War Frenzy',2000000,74),
(48,425,1,'Hawk Spirit Totem',2000000,74),
(49,163,1,'Spellcraft',0,1),
(49,214,1,'Mana Recovery',0,1),
(49,118,1,'Magician\'s Movement',0,1),
(49,134,1,'Toughness',0,1),
(49,1001,1,'Soul Cry',0,1),
(49,146,1,'Anti Magic',260,7),
(49,146,2,'Anti Magic',260,7),
(49,251,1,'Robe Mastery',260,7),
(49,251,2,'Robe Mastery',260,7),
(49,252,1,'Light Armor Mastery',260,7),
(49,252,2,'Light Armor Mastery',260,7),
(49,1010,1,'Soul Shield',520,7),
(49,1090,1,'Life Drain',520,7),
(49,250,1,'Weapon Mastery',520,7),
(49,1095,1,'Venom',520,7),
(49,1097,1,'Dreaming Spirit',520,7),
(49,1100,1,'Chill Flame',520,7),
(49,1100,2,'Chill Flame',1800,14),
(49,1097,2,'Dreaming Spirit',1800,14),
(49,1095,2,'Venom',1800,14),
(49,250,2,'Weapon Mastery',1800,14),
(49,1090,2,'Life Drain',1800,14),
(49,1092,1,'Fear',1800,14),
(49,252,3,'Light Armor Mastery',880,14),
(49,252,4,'Light Armor Mastery',880,14),
(49,253,1,'Heavy Armor Mastery',880,14),
(49,253,2,'Heavy Armor Mastery',880,14),
(49,1007,1,'Chant of Battle',1800,14),
(49,251,3,'Robe Mastery',880,14),
(49,251,4,'Robe Mastery',880,14),
(49,146,3,'Anti Magic',880,14),
(49,146,4,'Anti Magic',880,14),
(49,1001,2,'Soul Cry',1800,14),
(50,100,1,'Stun Attack',960,20),
(50,100,2,'Stun Attack',960,20),
(50,100,3,'Stun Attack',960,20),
(50,146,5,'Anti Magic',1400,20),
(50,146,6,'Anti Magic',1400,20),
(50,164,1,'Quick Recycle',2900,20),
(50,213,1,'Boost Mana',2900,20),
(50,250,3,'Weapon Mastery',2900,20),
(50,251,5,'Robe Mastery',1400,20),
(50,251,6,'Robe Mastery',1400,20),
(50,252,5,'Light Armor Mastery',1400,20),
(50,252,6,'Light Armor Mastery',1400,20),
(50,253,3,'Heavy Armor Mastery',1400,20),
(50,253,4,'Heavy Armor Mastery',1400,20),
(50,1006,1,'Chant of Fire',2900,20),
(50,1009,1,'Chant of Shielding',2900,20),
(50,1090,3,'Life Drain',2900,20),
(50,1092,2,'Fear',2900,20),
(50,1097,3,'Dreaming Spirit',2900,20),
(50,1095,3,'Venom',2900,20),
(50,1105,1,'Madness',2900,20),
(50,1107,1,'Frost Flame',2900,20),
(50,1209,1,'Seal of Poison',2900,20),
(50,1229,1,'Chant of Life',2900,20),
(50,1229,2,'Chant of Life',5800,25),
(50,1208,1,'Seal of Binding',5800,25),
(50,1001,3,'Soul Cry',5800,25),
(50,1102,1,'Aura Sink',5800,25),
(50,1105,2,'Madness',5800,25),
(50,1101,1,'Blaze Quake',5800,25),
(50,1097,4,'Dreaming Spirit',5800,25),
(50,1092,3,'Fear',5800,25),
(50,1090,4,'Life Drain',5800,25),
(50,1010,2,'Soul Shield',5800,25),
(50,1007,2,'Chant of Battle',5800,25),
(50,228,1,'Fast Spell Casting',5800,25),
(50,229,1,'Fast Mana Recovery',5800,25),
(50,253,5,'Heavy Armor Mastery',2900,25),
(50,253,6,'Heavy Armor Mastery',2900,25),
(50,252,7,'Light Armor Mastery',2900,25),
(50,252,8,'Light Armor Mastery',2900,25),
(50,251,7,'Robe Mastery',2900,25),
(50,251,8,'Robe Mastery',2900,25),
(50,250,4,'Weapon Mastery',2900,25),
(50,250,5,'Weapon Mastery',2900,25),
(50,146,7,'Anti Magic',2900,25),
(50,146,8,'Anti Magic',2900,25),
(50,100,4,'Stun Attack',1900,25),
(50,100,5,'Stun Attack',1900,25),
(50,100,6,'Stun Attack',1900,25),
(50,100,7,'Stun Attack',3500,30),
(50,100,8,'Stun Attack',3500,30),
(50,100,9,'Stun Attack',3500,30),
(50,146,9,'Anti Magic',5300,30),
(50,146,10,'Anti Magic',5300,30),
(50,250,6,'Weapon Mastery',5300,30),
(50,250,7,'Weapon Mastery',5300,30),
(50,213,2,'Boost Mana',11000,30),
(50,164,2,'Quick Recycle',11000,30),
(50,251,9,'Robe Mastery',5300,30),
(50,251,10,'Robe Mastery',5300,30),
(50,252,9,'Light Armor Mastery',5300,30),
(50,252,10,'Light Armor Mastery',5300,30),
(50,253,7,'Heavy Armor Mastery',5300,30),
(50,253,8,'Heavy Armor Mastery',5300,30),
(50,1009,2,'Chant of Shielding',11000,30),
(50,1090,5,'Life Drain',11000,30),
(50,1092,4,'Fear',11000,30),
(50,1097,5,'Dreaming Spirit',11000,30),
(50,1096,1,'Seal of Chaos',11000,30),
(50,1105,3,'Madness',11000,30),
(50,1107,2,'Frost Flame',11000,30),
(50,1002,1,'Flame Chant',11000,30),
(50,1003,1,'Pa\'agrian Gift',11000,30),
(50,1208,2,'Seal of Binding',11000,30),
(50,1209,2,'Seal of Poison',11000,30),
(50,1229,3,'Chant of Life',11000,30),
(50,1229,4,'Chant of Life',18000,35),
(50,1208,3,'Seal of Binding',18000,35),
(50,1001,4,'Soul Cry',18000,35),
(50,1102,2,'Aura Sink',18000,35),
(50,1105,4,'Madness',18000,35),
(50,1096,2,'Seal of Chaos',18000,35),
(50,1101,2,'Blaze Quake',18000,35),
(50,1097,6,'Dreaming Spirit',18000,35),
(50,1099,1,'Seal of Slow',18000,35),
(50,1092,5,'Fear',18000,35),
(50,1090,6,'Life Drain',18000,35),
(50,1010,3,'Soul Shield',18000,35),
(50,229,2,'Fast Mana Recovery',18000,35),
(50,253,9,'Heavy Armor Mastery',8800,35),
(50,253,10,'Heavy Armor Mastery',8800,35),
(50,1005,1,'Blessings of Pa\'agrio',18000,35),
(50,252,11,'Light Armor Mastery',8800,35),
(50,252,12,'Light Armor Mastery',8800,35),
(50,251,11,'Robe Mastery',8800,35),
(50,251,12,'Robe Mastery',8800,35),
(50,212,1,'Fast HP Recovery',18000,35),
(50,250,8,'Weapon Mastery',8800,35),
(50,250,9,'Weapon Mastery',8800,35),
(50,146,11,'Anti Magic',8800,35),
(50,146,12,'Anti Magic',8800,35),
(50,100,10,'Stun Attack',5900,35),
(50,100,11,'Stun Attack',5900,35),
(50,100,12,'Stun Attack',5900,35),
(51,927,1,'Burning Chop',21000,40),
(51,146,13,'Anti Magic',7200,40),
(51,146,14,'Anti Magic',7200,40),
(51,146,15,'Anti Magic',7200,40),
(51,250,10,'Weapon Mastery',7200,40),
(51,250,11,'Weapon Mastery',7200,40),
(51,250,12,'Weapon Mastery',7200,40),
(51,251,13,'Robe Mastery',7200,40),
(51,251,14,'Robe Mastery',7200,40),
(51,251,15,'Robe Mastery',7200,40),
(51,252,13,'Light Armor Mastery',7200,40),
(51,252,14,'Light Armor Mastery',7200,40),
(51,252,15,'Light Armor Mastery',7200,40),
(51,253,11,'Heavy Armor Mastery',7200,40),
(51,253,12,'Heavy Armor Mastery',7200,40),
(51,253,13,'Heavy Armor Mastery',7200,40),
(51,260,1,'Hammer Crush',7200,40),
(51,260,2,'Hammer Crush',7200,40),
(51,260,3,'Hammer Crush',7200,40),
(51,211,1,'Boost HP',22000,40),
(51,213,3,'Boost Mana',22000,40),
(51,1092,6,'Fear',22000,40),
(51,1096,3,'Seal of Chaos',22000,40),
(51,1097,7,'Dreaming Spirit',22000,40),
(51,1099,2,'Seal of Slow',22000,40),
(51,1104,1,'Seal of Winter',22000,40),
(51,1105,5,'Madness',22000,40),
(51,228,2,'Fast Spell Casting',22000,40),
(51,1208,4,'Seal of Binding',22000,40),
(51,1209,3,'Seal of Poison',22000,40),
(51,1245,1,'Steal Essence',22000,40),
(51,1247,1,'Seal of Scourge',22000,40),
(51,1008,1,'The Glory of Pa\'agrio',22000,40),
(51,1250,1,'Under the Protection of Pa\'agrio',22000,40),
(51,1260,1,'The Tact of Pa\'agrio',22000,40),
(51,1001,5,'Soul Cry',22000,40),
(51,1003,2,'Pa\'agrian Gift',22000,40),
(51,1004,1,'The Wisdom of Pa\'agrio',22000,40),
(51,927,2,'Burning Chop',27000,44),
(51,1249,1,'The Vision of Pa\'agrio',28000,44),
(51,1256,1,'The Heart of Pa\'agrio',28000,44),
(51,1283,1,'Soul Guard',28000,44),
(51,1261,1,'The Rage of Pa\'agrio',28000,44),
(51,1247,2,'Seal of Scourge',28000,44),
(51,1245,2,'Steal Essence',28000,44),
(51,1210,1,'Seal of Gloom',28000,44),
(51,1213,1,'Seal of Mirage',28000,44),
(51,1208,5,'Seal of Binding',28000,44),
(51,1005,2,'Blessings of Pa\'agrio',28000,44),
(51,1105,6,'Madness',28000,44),
(51,1104,2,'Seal of Winter',28000,44),
(51,1099,3,'Seal of Slow',28000,44),
(51,1097,8,'Dreaming Spirit',28000,44),
(51,1096,4,'Seal of Chaos',28000,44),
(51,1092,7,'Fear',28000,44),
(51,229,3,'Fast Mana Recovery',28000,44),
(51,211,2,'Boost HP',28000,44),
(51,212,2,'Fast HP Recovery',28000,44),
(51,260,4,'Hammer Crush',9300,44),
(51,260,5,'Hammer Crush',9300,44),
(51,260,6,'Hammer Crush',9300,44),
(51,253,14,'Heavy Armor Mastery',9300,44),
(51,253,15,'Heavy Armor Mastery',9300,44),
(51,253,16,'Heavy Armor Mastery',9300,44),
(51,252,16,'Light Armor Mastery',9300,44),
(51,252,17,'Light Armor Mastery',9300,44),
(51,252,18,'Light Armor Mastery',9300,44),
(51,251,16,'Robe Mastery',9300,44),
(51,251,17,'Robe Mastery',9300,44),
(51,251,18,'Robe Mastery',9300,44),
(51,250,13,'Weapon Mastery',9300,44),
(51,250,14,'Weapon Mastery',9300,44),
(51,250,15,'Weapon Mastery',9300,44),
(51,146,16,'Anti Magic',9300,44),
(51,146,17,'Anti Magic',9300,44),
(51,146,18,'Anti Magic',9300,44),
(51,927,3,'Burning Chop',39000,48),
(51,146,19,'Anti Magic',13000,48),
(51,146,20,'Anti Magic',13000,48),
(51,146,21,'Anti Magic',13000,48),
(51,250,16,'Weapon Mastery',13000,48),
(51,250,17,'Weapon Mastery',13000,48),
(51,250,18,'Weapon Mastery',13000,48),
(51,251,19,'Robe Mastery',13000,48),
(51,251,20,'Robe Mastery',13000,48),
(51,251,21,'Robe Mastery',13000,48),
(51,252,19,'Light Armor Mastery',13000,48),
(51,252,20,'Light Armor Mastery',13000,48),
(51,252,21,'Light Armor Mastery',13000,48),
(51,253,17,'Heavy Armor Mastery',13000,48),
(51,253,18,'Heavy Armor Mastery',13000,48),
(51,253,19,'Heavy Armor Mastery',13000,48),
(51,260,7,'Hammer Crush',13000,48),
(51,260,8,'Hammer Crush',13000,48),
(51,260,9,'Hammer Crush',13000,48),
(51,211,3,'Boost HP',40000,48),
(51,213,4,'Boost Mana',40000,48),
(51,1092,8,'Fear',40000,48),
(51,1096,5,'Seal of Chaos',40000,48),
(51,1097,9,'Dreaming Spirit',40000,48),
(51,1099,4,'Seal of Slow',40000,48),
(51,1104,3,'Seal of Winter',40000,48),
(51,1105,7,'Madness',40000,48),
(51,1108,1,'Seal of Flame',40000,48),
(51,1208,6,'Seal of Binding',40000,48),
(51,1213,2,'Seal of Mirage',40000,48),
(51,1245,3,'Steal Essence',40000,48),
(51,1246,1,'Seal of Silence',40000,48),
(51,1247,3,'Seal of Scourge',40000,48),
(51,1248,1,'Seal of Suspension',40000,48),
(51,1283,2,'Soul Guard',40000,48),
(51,1256,2,'The Heart of Pa\'agrio',40000,48),
(51,1008,2,'The Glory of Pa\'agrio',40000,48),
(51,1260,2,'The Tact of Pa\'agrio',40000,48),
(51,1250,2,'Under the Protection of Pa\'agrio',40000,48),
(51,1004,2,'The Wisdom of Pa\'agrio',40000,48),
(51,1003,3,'Pa\'agrian Gift',40000,48),
(51,164,3,'Quick Recycle',40000,48),
(51,1001,6,'Soul Cry',40000,48),
(51,927,4,'Burning Chop',62000,52),
(51,1249,2,'The Vision of Pa\'agrio',64000,52),
(51,1256,3,'The Heart of Pa\'agrio',64000,52),
(51,1283,3,'Soul Guard',64000,52),
(51,1261,2,'The Rage of Pa\'agrio',64000,52),
(51,1248,2,'Seal of Suspension',64000,52),
(51,1247,4,'Seal of Scourge',64000,52),
(51,1246,2,'Seal of Silence',64000,52),
(51,1245,4,'Steal Essence',64000,52),
(51,1213,3,'Seal of Mirage',64000,52),
(51,1210,2,'Seal of Gloom',64000,52),
(51,1209,4,'Seal of Poison',64000,52),
(51,1208,7,'Seal of Binding',64000,52),
(51,1005,3,'Blessings of Pa\'agrio',64000,52),
(51,1105,8,'Madness',64000,52),
(51,1104,4,'Seal of Winter',64000,52),
(51,1099,5,'Seal of Slow',64000,52),
(51,1097,10,'Dreaming Spirit',64000,52),
(51,1096,6,'Seal of Chaos',64000,52),
(51,1092,9,'Fear',64000,52),
(51,229,4,'Fast Mana Recovery',64000,52),
(51,211,4,'Boost HP',64000,52),
(51,212,3,'Fast HP Recovery',64000,52),
(51,260,10,'Hammer Crush',21000,52),
(51,260,11,'Hammer Crush',21000,52),
(51,260,12,'Hammer Crush',21000,52),
(51,253,20,'Heavy Armor Mastery',21000,52),
(51,253,21,'Heavy Armor Mastery',21000,52),
(51,253,22,'Heavy Armor Mastery',21000,52),
(51,252,22,'Light Armor Mastery',21000,52),
(51,252,23,'Light Armor Mastery',21000,52),
(51,252,24,'Light Armor Mastery',21000,52),
(51,251,22,'Robe Mastery',21000,52),
(51,251,23,'Robe Mastery',21000,52),
(51,251,24,'Robe Mastery',21000,52),
(51,250,19,'Weapon Mastery',21000,52),
(51,250,20,'Weapon Mastery',21000,52),
(51,250,21,'Weapon Mastery',21000,52),
(51,146,22,'Anti Magic',21000,52),
(51,146,23,'Anti Magic',21000,52),
(51,146,24,'Anti Magic',21000,52),
(51,927,5,'Burning Chop',65000,56),
(51,146,25,'Anti Magic',22000,56),
(51,146,26,'Anti Magic',22000,56),
(51,146,27,'Anti Magic',22000,56),
(51,250,22,'Weapon Mastery',22000,56),
(51,250,23,'Weapon Mastery',22000,56),
(51,250,24,'Weapon Mastery',22000,56),
(51,251,25,'Robe Mastery',22000,56),
(51,251,26,'Robe Mastery',22000,56),
(51,251,27,'Robe Mastery',22000,56),
(51,252,25,'Light Armor Mastery',22000,56),
(51,252,26,'Light Armor Mastery',22000,56),
(51,252,27,'Light Armor Mastery',22000,56),
(51,253,23,'Heavy Armor Mastery',22000,56),
(51,253,24,'Heavy Armor Mastery',22000,56),
(51,253,25,'Heavy Armor Mastery',22000,56),
(51,260,13,'Hammer Crush',22000,56),
(51,260,14,'Hammer Crush',22000,56),
(51,260,15,'Hammer Crush',22000,56),
(51,211,5,'Boost HP',67000,56),
(51,213,5,'Boost Mana',67000,56),
(51,1092,10,'Fear',67000,56),
(51,1096,7,'Seal of Chaos',67000,56),
(51,1097,11,'Dreaming Spirit',67000,56),
(51,1099,6,'Seal of Slow',67000,56),
(51,1104,5,'Seal of Winter',67000,56),
(51,1105,9,'Madness',67000,56),
(51,228,3,'Fast Spell Casting',67000,56),
(51,1108,2,'Seal of Flame',67000,56),
(51,1208,8,'Seal of Binding',67000,56),
(51,1213,4,'Seal of Mirage',67000,56),
(51,1245,5,'Steal Essence',67000,56),
(51,1246,3,'Seal of Silence',67000,56),
(51,1247,5,'Seal of Scourge',67000,56),
(51,1248,3,'Seal of Suspension',67000,56),
(51,1283,4,'Soul Guard',67000,56),
(51,1256,4,'The Heart of Pa\'agrio',67000,56),
(51,1249,3,'The Vision of Pa\'agrio',67000,56),
(51,1008,3,'The Glory of Pa\'agrio',67000,56),
(51,1250,3,'Under the Protection of Pa\'agrio',67000,56),
(51,1260,3,'The Tact of Pa\'agrio',67000,56),
(51,1001,7,'Soul Cry',67000,56),
(51,1004,3,'The Wisdom of Pa\'agrio',67000,56),
(51,927,6,'Burning Chop',96000,58),
(51,1256,5,'The Heart of Pa\'agrio',100000,58),
(51,1283,5,'Soul Guard',100000,58),
(51,1282,1,'Pa\'agrian Haste',100000,58),
(51,1248,4,'Seal of Suspension',100000,58),
(51,1247,6,'Seal of Scourge',100000,58),
(51,1246,4,'Seal of Silence',100000,58),
(51,1245,6,'Steal Essence',100000,58),
(51,1213,5,'Seal of Mirage',100000,58),
(51,1208,9,'Seal of Binding',100000,58),
(51,1105,10,'Madness',100000,58),
(51,1104,6,'Seal of Winter',100000,58),
(51,1099,7,'Seal of Slow',100000,58),
(51,1097,12,'Dreaming Spirit',100000,58),
(51,1096,8,'Seal of Chaos',100000,58),
(51,1092,11,'Fear',100000,58),
(51,212,4,'Fast HP Recovery',100000,58),
(51,260,16,'Hammer Crush',33000,58),
(51,260,17,'Hammer Crush',33000,58),
(51,260,18,'Hammer Crush',33000,58),
(51,253,26,'Heavy Armor Mastery',50000,58),
(51,253,27,'Heavy Armor Mastery',50000,58),
(51,252,28,'Light Armor Mastery',50000,58),
(51,252,29,'Light Armor Mastery',50000,58),
(51,251,28,'Robe Mastery',50000,58),
(51,251,29,'Robe Mastery',50000,58),
(51,250,25,'Weapon Mastery',50000,58),
(51,250,26,'Weapon Mastery',50000,58),
(51,146,28,'Anti Magic',50000,58),
(51,146,29,'Anti Magic',50000,58),
(51,927,7,'Burning Chop',125000,60),
(51,146,30,'Anti Magic',65000,60),
(51,146,31,'Anti Magic',65000,60),
(51,250,27,'Weapon Mastery',65000,60),
(51,250,28,'Weapon Mastery',65000,60),
(51,251,30,'Robe Mastery',65000,60),
(51,251,31,'Robe Mastery',65000,60),
(51,252,30,'Light Armor Mastery',65000,60),
(51,252,31,'Light Armor Mastery',65000,60),
(51,253,28,'Heavy Armor Mastery',65000,60),
(51,253,29,'Heavy Armor Mastery',65000,60),
(51,260,19,'Hammer Crush',43000,60),
(51,260,20,'Hammer Crush',43000,60),
(51,260,21,'Hammer Crush',43000,60),
(51,213,6,'Boost Mana',130000,60),
(51,229,5,'Fast Mana Recovery',130000,60),
(51,1092,12,'Fear',130000,60),
(51,1096,9,'Seal of Chaos',130000,60),
(51,1097,13,'Dreaming Spirit',130000,60),
(51,1099,8,'Seal of Slow',130000,60),
(51,1104,7,'Seal of Winter',130000,60),
(51,1105,11,'Madness',130000,60),
(51,1208,10,'Seal of Binding',130000,60),
(51,1213,6,'Seal of Mirage',130000,60),
(51,1245,7,'Steal Essence',130000,60),
(51,1246,5,'Seal of Silence',130000,60),
(51,1247,7,'Seal of Scourge',130000,60),
(51,1248,5,'Seal of Suspension',130000,60),
(51,1283,6,'Soul Guard',130000,60),
(51,1256,6,'The Heart of Pa\'agrio',130000,60),
(51,1001,8,'Soul Cry',130000,60),
(51,927,8,'Burning Chop',170000,62),
(51,1256,7,'The Heart of Pa\'agrio',180000,62),
(51,1283,7,'Soul Guard',180000,62),
(51,1248,6,'Seal of Suspension',180000,62),
(51,1247,8,'Seal of Scourge',180000,62),
(51,1246,6,'Seal of Silence',180000,62),
(51,1245,8,'Steal Essence',180000,62),
(51,1213,7,'Seal of Mirage',180000,62),
(51,1209,5,'Seal of Poison',180000,62),
(51,1208,11,'Seal of Binding',180000,62),
(51,1105,12,'Madness',180000,62),
(51,1104,8,'Seal of Winter',180000,62),
(51,1099,9,'Seal of Slow',180000,62),
(51,1097,14,'Dreaming Spirit',180000,62),
(51,1096,10,'Seal of Chaos',180000,62),
(51,1092,13,'Fear',180000,62),
(51,211,6,'Boost HP',182000,62),
(51,260,22,'Hammer Crush',91000,62),
(51,260,23,'Hammer Crush',91000,62),
(51,253,30,'Heavy Armor Mastery',91000,62),
(51,253,31,'Heavy Armor Mastery',91000,62),
(51,252,32,'Light Armor Mastery',91000,62),
(51,252,33,'Light Armor Mastery',91000,62),
(51,251,32,'Robe Mastery',91000,62),
(51,251,33,'Robe Mastery',91000,62),
(51,250,29,'Weapon Mastery',91000,62),
(51,250,30,'Weapon Mastery',91000,62),
(51,146,32,'Anti Magic',91000,62),
(51,146,33,'Anti Magic',91000,62),
(51,927,9,'Burning Chop',190000,64),
(51,146,34,'Anti Magic',100000,64),
(51,146,35,'Anti Magic',100000,64),
(51,250,31,'Weapon Mastery',100000,64),
(51,250,32,'Weapon Mastery',100000,64),
(51,251,34,'Robe Mastery',100000,64),
(51,251,35,'Robe Mastery',100000,64),
(51,252,34,'Light Armor Mastery',100000,64),
(51,252,35,'Light Armor Mastery',100000,64),
(51,253,32,'Heavy Armor Mastery',100000,64),
(51,253,33,'Heavy Armor Mastery',100000,64),
(51,260,24,'Hammer Crush',100000,64),
(51,260,25,'Hammer Crush',100000,64),
(51,212,5,'Fast HP Recovery',200000,64),
(51,1092,14,'Fear',200000,64),
(51,1096,11,'Seal of Chaos',200000,64),
(51,1097,15,'Dreaming Spirit',200000,64),
(51,1099,10,'Seal of Slow',200000,64),
(51,1104,9,'Seal of Winter',200000,64),
(51,1105,13,'Madness',200000,64),
(51,1208,12,'Seal of Binding',200000,64),
(51,1210,3,'Seal of Gloom',200000,64),
(51,1213,8,'Seal of Mirage',200000,64),
(51,1245,9,'Steal Essence',200000,64),
(51,1246,7,'Seal of Silence',200000,64),
(51,1247,9,'Seal of Scourge',200000,64),
(51,1248,7,'Seal of Suspension',200000,64),
(51,1283,8,'Soul Guard',200000,64),
(51,1282,2,'Pa\'agrian Haste',200000,64),
(51,1256,8,'The Heart of Pa\'agrio',200000,64),
(51,1306,1,'Ritual of Life',200000,64),
(51,927,10,'Burning Chop',280000,66),
(51,1306,2,'Ritual of Life',290000,66),
(51,1001,9,'Soul Cry',290000,66),
(51,1256,9,'The Heart of Pa\'agrio',290000,66),
(51,1305,1,'The Honor of Pa\'agrio',290000,66),
(51,1283,9,'Soul Guard',290000,66),
(51,1248,8,'Seal of Suspension',290000,66),
(51,1247,10,'Seal of Scourge',290000,66),
(51,1246,8,'Seal of Silence',290000,66),
(51,1245,10,'Steal Essence',290000,66),
(51,1213,9,'Seal of Mirage',290000,66),
(51,1208,13,'Seal of Binding',290000,66),
(51,1105,14,'Madness',290000,66),
(51,1104,10,'Seal of Winter',290000,66),
(51,1099,11,'Seal of Slow',290000,66),
(51,1097,16,'Dreaming Spirit',290000,66),
(51,1096,12,'Seal of Chaos',290000,66),
(51,1092,15,'Fear',290000,66),
(51,213,7,'Boost Mana',290000,66),
(51,260,26,'Hammer Crush',150000,66),
(51,260,27,'Hammer Crush',150000,66),
(51,253,34,'Heavy Armor Mastery',150000,66),
(51,253,35,'Heavy Armor Mastery',150000,66),
(51,252,36,'Light Armor Mastery',150000,66),
(51,252,37,'Light Armor Mastery',150000,66),
(51,251,36,'Robe Mastery',150000,66),
(51,251,37,'Robe Mastery',150000,66),
(51,250,33,'Weapon Mastery',150000,66),
(51,250,34,'Weapon Mastery',150000,66),
(51,146,36,'Anti Magic',150000,66),
(51,146,37,'Anti Magic',150000,66),
(51,927,11,'Burning Chop',310000,68),
(51,146,38,'Anti Magic',160000,68),
(51,146,39,'Anti Magic',160000,68),
(51,250,35,'Weapon Mastery',160000,68),
(51,250,36,'Weapon Mastery',160000,68),
(51,251,38,'Robe Mastery',160000,68),
(51,251,39,'Robe Mastery',160000,68),
(51,252,38,'Light Armor Mastery',160000,68),
(51,252,39,'Light Armor Mastery',160000,68),
(51,253,36,'Heavy Armor Mastery',160000,68),
(51,253,37,'Heavy Armor Mastery',160000,68),
(51,260,28,'Hammer Crush',160000,68),
(51,260,29,'Hammer Crush',160000,68),
(51,229,6,'Fast Mana Recovery',320000,68),
(51,1092,16,'Fear',320000,68),
(51,1096,13,'Seal of Chaos',320000,68),
(51,1097,17,'Dreaming Spirit',320000,68),
(51,1099,12,'Seal of Slow',320000,68),
(51,1104,11,'Seal of Winter',320000,68),
(51,1105,15,'Madness',320000,68),
(51,1208,14,'Seal of Binding',320000,68),
(51,1108,3,'Seal of Flame',320000,68),
(51,1213,10,'Seal of Mirage',320000,68),
(51,1245,11,'Steal Essence',320000,68),
(51,1246,9,'Seal of Silence',320000,68),
(51,1247,11,'Seal of Scourge',320000,68),
(51,1248,9,'Seal of Suspension',320000,68),
(51,1283,10,'Soul Guard',320000,68),
(51,1305,2,'The Honor of Pa\'agrio',320000,68),
(51,1256,10,'The Heart of Pa\'agrio',320000,68),
(51,1306,3,'Ritual of Life',320000,68),
(51,927,12,'Burning Chop',380000,70),
(51,1306,4,'Ritual of Life',390000,70),
(51,1256,11,'The Heart of Pa\'agrio',390000,70),
(51,1305,3,'The Honor of Pa\'agrio',390000,70),
(51,1283,11,'Soul Guard',390000,70),
(51,1248,10,'Seal of Suspension',390000,70),
(51,1247,12,'Seal of Scourge',390000,70),
(51,1246,10,'Seal of Silence',390000,70),
(51,1245,12,'Steal Essence',390000,70),
(51,1213,11,'Seal of Mirage',390000,70),
(51,1209,6,'Seal of Poison',390000,70),
(51,1208,15,'Seal of Binding',390000,70),
(51,1105,16,'Madness',390000,70),
(51,1104,12,'Seal of Winter',390000,70),
(51,1099,13,'Seal of Slow',390000,70),
(51,1097,18,'Dreaming Spirit',390000,70),
(51,1096,14,'Seal of Chaos',390000,70),
(51,1092,17,'Fear',390000,70),
(51,211,7,'Boost HP',390000,70),
(51,260,30,'Hammer Crush',200000,70),
(51,260,31,'Hammer Crush',200000,70),
(51,253,38,'Heavy Armor Mastery',200000,70),
(51,253,39,'Heavy Armor Mastery',200000,70),
(51,252,40,'Light Armor Mastery',200000,70),
(51,252,41,'Light Armor Mastery',200000,70),
(51,251,40,'Robe Mastery',200000,70),
(51,251,41,'Robe Mastery',200000,70),
(51,250,37,'Weapon Mastery',200000,70),
(51,250,38,'Weapon Mastery',200000,70),
(51,146,40,'Anti Magic',200000,70),
(51,146,41,'Anti Magic',200000,70),
(51,927,13,'Burning Chop',580000,72),
(51,146,42,'Anti Magic',300000,72),
(51,146,43,'Anti Magic',300000,72),
(51,250,39,'Weapon Mastery',300000,72),
(51,250,40,'Weapon Mastery',300000,72),
(51,251,42,'Robe Mastery',300000,72),
(51,251,43,'Robe Mastery',300000,72),
(51,252,42,'Light Armor Mastery',300000,72),
(51,252,43,'Light Armor Mastery',300000,72),
(51,253,40,'Heavy Armor Mastery',300000,72),
(51,253,41,'Heavy Armor Mastery',300000,72),
(51,260,32,'Hammer Crush',300000,72),
(51,260,33,'Hammer Crush',300000,72),
(51,213,8,'Boost Mana',600000,72),
(51,1092,18,'Fear',600000,72),
(51,1096,15,'Seal of Chaos',600000,72),
(51,1097,19,'Dreaming Spirit',600000,72),
(51,1099,14,'Seal of Slow',600000,72),
(51,1104,13,'Seal of Winter',600000,72),
(51,1105,17,'Madness',600000,72),
(51,1208,16,'Seal of Binding',600000,72),
(51,1210,4,'Seal of Gloom',600000,72),
(51,1213,12,'Seal of Mirage',600000,72),
(51,1245,13,'Steal Essence',600000,72),
(51,1246,11,'Seal of Silence',600000,72),
(51,1247,13,'Seal of Scourge',600000,72),
(51,1248,11,'Seal of Suspension',600000,72),
(51,1283,12,'Soul Guard',600000,72),
(51,1305,4,'The Honor of Pa\'agrio',600000,72),
(51,1256,12,'The Heart of Pa\'agrio',600000,72),
(51,1306,5,'Ritual of Life',600000,72),
(51,1001,10,'Soul Cry',600000,72),
(51,927,14,'Burning Chop',900000,74),
(51,1306,6,'Ritual of Life',920000,74),
(51,1256,13,'The Heart of Pa\'agrio',920000,74),
(51,1305,5,'The Honor of Pa\'agrio',920000,74),
(51,1283,13,'Soul Guard',920000,74),
(51,1248,12,'Seal of Suspension',920000,74),
(51,1247,14,'Seal of Scourge',920000,74),
(51,1246,12,'Seal of Silence',920000,74),
(51,1245,14,'Steal Essence',920000,74),
(51,1213,13,'Seal of Mirage',920000,74),
(51,1208,17,'Seal of Binding',920000,74),
(51,1108,4,'Seal of Flame',920000,74),
(51,1105,18,'Madness',920000,74),
(51,1104,14,'Seal of Winter',920000,74),
(51,1099,15,'Seal of Slow',920000,74),
(51,1097,20,'Dreaming Spirit',920000,74),
(51,1096,16,'Seal of Chaos',920000,74),
(51,1092,19,'Fear',920000,74),
(51,229,7,'Fast Mana Recovery',920000,74),
(51,212,6,'Fast HP Recovery',920000,74),
(51,260,34,'Hammer Crush',460000,74),
(51,260,35,'Hammer Crush',460000,74),
(51,253,42,'Heavy Armor Mastery',460000,74),
(51,253,43,'Heavy Armor Mastery',460000,74),
(51,252,44,'Light Armor Mastery',460000,74),
(51,252,45,'Light Armor Mastery',460000,74),
(51,251,44,'Robe Mastery',460000,74),
(51,251,45,'Robe Mastery',460000,74),
(51,250,41,'Weapon Mastery',460000,74),
(51,250,42,'Weapon Mastery',460000,74),
(51,146,44,'Anti Magic',460000,74),
(51,146,45,'Anti Magic',460000,74),
(52,927,1,'Burning Chop',26000,40),
(52,146,13,'Anti Magic',9000,40),
(52,146,14,'Anti Magic',9000,40),
(52,146,15,'Anti Magic',9000,40),
(52,250,10,'Weapon Mastery',9000,40),
(52,250,11,'Weapon Mastery',9000,40),
(52,250,12,'Weapon Mastery',9000,40),
(52,251,13,'Robe Mastery',9000,40),
(52,251,14,'Robe Mastery',9000,40),
(52,251,15,'Robe Mastery',9000,40),
(52,252,13,'Light Armor Mastery',9000,40),
(52,252,14,'Light Armor Mastery',9000,40),
(52,252,15,'Light Armor Mastery',9000,40),
(52,253,11,'Heavy Armor Mastery',9000,40),
(52,253,12,'Heavy Armor Mastery',9000,40),
(52,253,13,'Heavy Armor Mastery',9000,40),
(52,260,1,'Hammer Crush',9000,40),
(52,260,2,'Hammer Crush',9000,40),
(52,260,3,'Hammer Crush',9000,40),
(52,211,1,'Boost HP',27000,40),
(52,213,3,'Boost Mana',27000,40),
(52,1009,3,'Chant of Shielding',27000,40),
(52,1092,6,'Fear',27000,40),
(52,228,2,'Fast Spell Casting',27000,40),
(52,1006,2,'Chant of Fire',27000,40),
(52,1095,4,'Venom',27000,40),
(52,1097,7,'Dreaming Spirit',27000,40),
(52,1105,5,'Madness',27000,40),
(52,1229,5,'Chant of Life',27000,40),
(52,1244,1,'Freezing Flame',27000,40),
(52,1245,1,'Steal Essence',27000,40),
(52,1252,1,'Chant of Evasion',27000,40),
(52,1001,5,'Soul Cry',27000,40),
(52,927,2,'Burning Chop',35000,44),
(52,1310,1,'Chant of Vampire',37000,44),
(52,1253,1,'Chant of Rage',37000,44),
(52,1245,2,'Steal Essence',37000,44),
(52,1002,2,'Flame Chant',37000,44),
(52,1102,3,'Aura Sink',37000,44),
(52,1229,6,'Chant of Life',37000,44),
(52,1105,6,'Madness',37000,44),
(52,1097,8,'Dreaming Spirit',37000,44),
(52,1007,3,'Chant of Battle',37000,44),
(52,1092,7,'Fear',37000,44),
(52,229,3,'Fast Mana Recovery',37000,44),
(52,211,2,'Boost HP',37000,44),
(52,212,2,'Fast HP Recovery',37000,44),
(52,260,4,'Hammer Crush',12000,44),
(52,260,5,'Hammer Crush',12000,44),
(52,260,6,'Hammer Crush',12000,44),
(52,253,14,'Heavy Armor Mastery',12000,44),
(52,253,15,'Heavy Armor Mastery',12000,44),
(52,253,16,'Heavy Armor Mastery',12000,44),
(52,252,16,'Light Armor Mastery',12000,44),
(52,252,17,'Light Armor Mastery',12000,44),
(52,252,18,'Light Armor Mastery',12000,44),
(52,251,16,'Robe Mastery',12000,44),
(52,251,17,'Robe Mastery',12000,44),
(52,251,18,'Robe Mastery',12000,44),
(52,250,13,'Weapon Mastery',12000,44),
(52,250,14,'Weapon Mastery',12000,44),
(52,250,15,'Weapon Mastery',12000,44),
(52,146,16,'Anti Magic',12000,44),
(52,146,17,'Anti Magic',12000,44),
(52,146,18,'Anti Magic',12000,44),
(52,927,3,'Burning Chop',60000,48),
(52,146,19,'Anti Magic',21000,48),
(52,146,20,'Anti Magic',21000,48),
(52,146,21,'Anti Magic',21000,48),
(52,250,16,'Weapon Mastery',21000,48),
(52,250,17,'Weapon Mastery',21000,48),
(52,250,18,'Weapon Mastery',21000,48),
(52,251,19,'Robe Mastery',21000,48),
(52,251,20,'Robe Mastery',21000,48),
(52,251,21,'Robe Mastery',21000,48),
(52,252,19,'Light Armor Mastery',21000,48),
(52,252,20,'Light Armor Mastery',21000,48),
(52,252,21,'Light Armor Mastery',21000,48),
(52,253,17,'Heavy Armor Mastery',21000,48),
(52,253,18,'Heavy Armor Mastery',21000,48),
(52,253,19,'Heavy Armor Mastery',21000,48),
(52,260,7,'Hammer Crush',21000,48),
(52,260,8,'Hammer Crush',21000,48),
(52,260,9,'Hammer Crush',21000,48),
(52,211,3,'Boost HP',63000,48),
(52,213,4,'Boost Mana',63000,48),
(52,1092,8,'Fear',63000,48),
(52,164,3,'Quick Recycle',63000,48),
(52,1097,9,'Dreaming Spirit',63000,48),
(52,1105,7,'Madness',63000,48),
(52,1229,7,'Chant of Life',63000,48),
(52,1245,3,'Steal Essence',63000,48),
(52,1252,2,'Chant of Evasion',63000,48),
(52,1251,1,'Chant of Fury',63000,48),
(52,1308,1,'Chant of Predator',63000,48),
(52,1309,1,'Chant of Eagle',63000,48),
(52,1001,6,'Soul Cry',63000,48),
(52,927,4,'Burning Chop',90000,52),
(52,1253,2,'Chant of Rage',95000,52),
(52,1245,4,'Steal Essence',95000,52),
(52,1229,8,'Chant of Life',95000,52),
(52,1102,4,'Aura Sink',95000,52),
(52,1244,2,'Freezing Flame',95000,52),
(52,1105,8,'Madness',95000,52),
(52,1097,10,'Dreaming Spirit',95000,52),
(52,1095,5,'Venom',95000,52),
(52,1006,3,'Chant of Fire',95000,52),
(52,1092,9,'Fear',95000,52),
(52,229,4,'Fast Mana Recovery',95000,52),
(52,211,4,'Boost HP',95000,52),
(52,212,3,'Fast HP Recovery',95000,52),
(52,260,10,'Hammer Crush',32000,52),
(52,260,11,'Hammer Crush',32000,52),
(52,260,12,'Hammer Crush',32000,52),
(52,253,20,'Heavy Armor Mastery',32000,52),
(52,253,21,'Heavy Armor Mastery',32000,52),
(52,253,22,'Heavy Armor Mastery',32000,52),
(52,252,22,'Light Armor Mastery',32000,52),
(52,252,23,'Light Armor Mastery',32000,52),
(52,252,24,'Light Armor Mastery',32000,52),
(52,251,22,'Robe Mastery',32000,52),
(52,251,23,'Robe Mastery',32000,52),
(52,251,24,'Robe Mastery',32000,52),
(52,250,19,'Weapon Mastery',32000,52),
(52,250,20,'Weapon Mastery',32000,52),
(52,250,21,'Weapon Mastery',32000,52),
(52,146,22,'Anti Magic',32000,52),
(52,146,23,'Anti Magic',32000,52),
(52,146,24,'Anti Magic',32000,52),
(52,927,5,'Burning Chop',100000,56),
(52,146,25,'Anti Magic',35000,56),
(52,146,26,'Anti Magic',35000,56),
(52,146,27,'Anti Magic',35000,56),
(52,250,22,'Weapon Mastery',35000,56),
(52,250,23,'Weapon Mastery',35000,56),
(52,250,24,'Weapon Mastery',35000,56),
(52,251,25,'Robe Mastery',35000,56),
(52,251,26,'Robe Mastery',35000,56),
(52,251,27,'Robe Mastery',35000,56),
(52,252,25,'Light Armor Mastery',35000,56),
(52,252,26,'Light Armor Mastery',35000,56),
(52,252,27,'Light Armor Mastery',35000,56),
(52,253,23,'Heavy Armor Mastery',35000,56),
(52,253,24,'Heavy Armor Mastery',35000,56),
(52,253,25,'Heavy Armor Mastery',35000,56),
(52,260,13,'Hammer Crush',35000,56),
(52,260,14,'Hammer Crush',35000,56),
(52,260,15,'Hammer Crush',35000,56),
(52,211,5,'Boost HP',105000,56),
(52,213,5,'Boost Mana',105000,56),
(52,1092,10,'Fear',105000,56),
(52,228,3,'Fast Spell Casting',105000,56),
(52,1097,11,'Dreaming Spirit',105000,56),
(52,1105,9,'Madness',105000,56),
(52,1229,9,'Chant of Life',105000,56),
(52,1245,5,'Steal Essence',105000,56),
(52,1253,3,'Chant of Rage',105000,56),
(52,1251,2,'Chant of Fury',105000,56),
(52,1252,3,'Chant of Evasion',105000,56),
(52,1001,7,'Soul Cry',105000,56),
(52,1002,3,'Flame Chant',105000,56),
(52,927,6,'Burning Chop',130000,58),
(52,1390,1,'War Chant',138000,58),
(52,1391,1,'Earth Chant',138000,58),
(52,1309,2,'Chant of Eagle',138000,58),
(52,1310,2,'Chant of Vampire',138000,58),
(52,1245,6,'Steal Essence',138000,58),
(52,1229,10,'Chant of Life',138000,58),
(52,1105,10,'Madness',138000,58),
(52,1097,12,'Dreaming Spirit',138000,58),
(52,1092,11,'Fear',138000,58),
(52,212,4,'Fast HP Recovery',138000,58),
(52,260,16,'Hammer Crush',46000,58),
(52,260,17,'Hammer Crush',46000,58),
(52,260,18,'Hammer Crush',46000,58),
(52,253,26,'Heavy Armor Mastery',69000,58),
(52,253,27,'Heavy Armor Mastery',69000,58),
(52,252,28,'Light Armor Mastery',69000,58),
(52,252,29,'Light Armor Mastery',69000,58),
(52,251,28,'Robe Mastery',69000,58),
(52,251,29,'Robe Mastery',69000,58),
(52,250,25,'Weapon Mastery',69000,58),
(52,250,26,'Weapon Mastery',69000,58),
(52,146,28,'Anti Magic',69000,58),
(52,146,29,'Anti Magic',69000,58),
(52,927,7,'Burning Chop',190000,60),
(52,146,30,'Anti Magic',100000,60),
(52,146,31,'Anti Magic',100000,60),
(52,250,27,'Weapon Mastery',100000,60),
(52,250,28,'Weapon Mastery',100000,60),
(52,251,30,'Robe Mastery',100000,60),
(52,251,31,'Robe Mastery',100000,60),
(52,252,30,'Light Armor Mastery',100000,60),
(52,252,31,'Light Armor Mastery',100000,60),
(52,253,28,'Heavy Armor Mastery',100000,60),
(52,253,29,'Heavy Armor Mastery',100000,60),
(52,260,19,'Hammer Crush',67000,60),
(52,260,20,'Hammer Crush',67000,60),
(52,260,21,'Hammer Crush',67000,60),
(52,213,6,'Boost Mana',200000,60),
(52,229,5,'Fast Mana Recovery',200000,60),
(52,1092,12,'Fear',200000,60),
(52,1097,13,'Dreaming Spirit',200000,60),
(52,1105,11,'Madness',200000,60),
(52,1229,11,'Chant of Life',200000,60),
(52,1245,7,'Steal Essence',200000,60),
(52,1308,2,'Chant of Predator',200000,60),
(52,1001,8,'Soul Cry',200000,60),
(52,927,8,'Burning Chop',290000,62),
(52,1245,8,'Steal Essence',310000,62),
(52,1284,1,'Chant of Revenge',310000,62),
(52,1229,12,'Chant of Life',310000,62),
(52,1105,12,'Madness',310000,62),
(52,1097,14,'Dreaming Spirit',310000,62),
(52,1092,13,'Fear',310000,62),
(52,211,6,'Boost HP',310000,62),
(52,260,22,'Hammer Crush',150000,62),
(52,260,23,'Hammer Crush',150000,62),
(52,253,30,'Heavy Armor Mastery',150000,62),
(52,253,31,'Heavy Armor Mastery',150000,62),
(52,252,32,'Light Armor Mastery',150000,62),
(52,252,33,'Light Armor Mastery',150000,62),
(52,251,32,'Robe Mastery',150000,62),
(52,251,33,'Robe Mastery',150000,62),
(52,250,29,'Weapon Mastery',150000,62),
(52,250,30,'Weapon Mastery',150000,62),
(52,146,32,'Anti Magic',150000,62),
(52,146,33,'Anti Magic',150000,62),
(52,927,9,'Burning Chop',300000,64),
(52,146,34,'Anti Magic',160000,64),
(52,146,35,'Anti Magic',160000,64),
(52,250,31,'Weapon Mastery',160000,64),
(52,250,32,'Weapon Mastery',160000,64),
(52,251,34,'Robe Mastery',160000,64),
(52,251,35,'Robe Mastery',160000,64),
(52,252,34,'Light Armor Mastery',160000,64),
(52,252,35,'Light Armor Mastery',160000,64),
(52,253,32,'Heavy Armor Mastery',160000,64),
(52,253,33,'Heavy Armor Mastery',160000,64),
(52,260,24,'Hammer Crush',160000,64),
(52,260,25,'Hammer Crush',160000,64),
(52,212,5,'Fast HP Recovery',320000,64),
(52,1092,14,'Fear',320000,64),
(52,1097,15,'Dreaming Spirit',320000,64),
(52,1105,13,'Madness',320000,64),
(52,1229,13,'Chant of Life',320000,64),
(52,1244,3,'Freezing Flame',320000,64),
(52,1102,5,'Aura Sink',320000,64),
(52,1245,9,'Steal Essence',320000,64),
(52,1309,3,'Chant of Eagle',320000,64),
(52,927,10,'Burning Chop',410000,66),
(52,1310,3,'Chant of Vampire',440000,66),
(52,1001,9,'Soul Cry',440000,66),
(52,1391,2,'Earth Chant',440000,66),
(52,1390,2,'War Chant',440000,66),
(52,1245,10,'Steal Essence',440000,66),
(52,1229,14,'Chant of Life',440000,66),
(52,1105,14,'Madness',440000,66),
(52,1097,16,'Dreaming Spirit',440000,66),
(52,1092,15,'Fear',440000,66),
(52,213,7,'Boost Mana',440000,66),
(52,260,26,'Hammer Crush',220000,66),
(52,260,27,'Hammer Crush',220000,66),
(52,253,34,'Heavy Armor Mastery',220000,66),
(52,253,35,'Heavy Armor Mastery',220000,66),
(52,252,36,'Light Armor Mastery',220000,66),
(52,252,37,'Light Armor Mastery',220000,66),
(52,251,36,'Robe Mastery',220000,66),
(52,251,37,'Robe Mastery',220000,66),
(52,250,33,'Weapon Mastery',220000,66),
(52,250,34,'Weapon Mastery',220000,66),
(52,146,36,'Anti Magic',220000,66),
(52,146,37,'Anti Magic',220000,66),
(52,927,11,'Burning Chop',510000,68),
(52,146,38,'Anti Magic',280000,68),
(52,146,39,'Anti Magic',280000,68),
(52,250,35,'Weapon Mastery',280000,68),
(52,250,36,'Weapon Mastery',280000,68),
(52,251,38,'Robe Mastery',280000,68),
(52,251,39,'Robe Mastery',280000,68),
(52,252,38,'Light Armor Mastery',280000,68),
(52,252,39,'Light Armor Mastery',280000,68),
(52,253,36,'Heavy Armor Mastery',280000,68),
(52,253,37,'Heavy Armor Mastery',280000,68),
(52,260,28,'Hammer Crush',280000,68),
(52,260,29,'Hammer Crush',280000,68),
(52,229,6,'Fast Mana Recovery',550000,68),
(52,1092,16,'Fear',550000,68),
(52,1097,17,'Dreaming Spirit',550000,68),
(52,1105,15,'Madness',550000,68),
(52,1229,15,'Chant of Life',550000,68),
(52,1245,11,'Steal Essence',550000,68),
(52,1284,2,'Chant of Revenge',550000,68),
(52,1308,3,'Chant of Predator',550000,68),
(52,927,12,'Burning Chop',670000,70),
(52,1245,12,'Steal Essence',720000,70),
(52,1229,16,'Chant of Life',720000,70),
(52,1102,6,'Aura Sink',720000,70),
(52,1105,16,'Madness',720000,70),
(52,1097,18,'Dreaming Spirit',720000,70),
(52,1092,17,'Fear',720000,70),
(52,211,7,'Boost HP',720000,70),
(52,260,30,'Hammer Crush',360000,70),
(52,260,31,'Hammer Crush',360000,70),
(52,253,38,'Heavy Armor Mastery',360000,70),
(52,253,39,'Heavy Armor Mastery',360000,70),
(52,252,40,'Light Armor Mastery',360000,70),
(52,252,41,'Light Armor Mastery',360000,70),
(52,251,40,'Robe Mastery',360000,70),
(52,251,41,'Robe Mastery',360000,70),
(52,250,37,'Weapon Mastery',360000,70),
(52,250,38,'Weapon Mastery',360000,70),
(52,146,40,'Anti Magic',360000,70),
(52,146,41,'Anti Magic',360000,70),
(52,927,13,'Burning Chop',1000000,72),
(52,146,42,'Anti Magic',540000,72),
(52,146,43,'Anti Magic',540000,72),
(52,250,39,'Weapon Mastery',540000,72),
(52,250,40,'Weapon Mastery',540000,72),
(52,251,42,'Robe Mastery',540000,72),
(52,251,43,'Robe Mastery',540000,72),
(52,252,42,'Light Armor Mastery',540000,72),
(52,252,43,'Light Armor Mastery',540000,72),
(52,253,40,'Heavy Armor Mastery',540000,72),
(52,253,41,'Heavy Armor Mastery',540000,72),
(52,260,32,'Hammer Crush',540000,72),
(52,260,33,'Hammer Crush',540000,72),
(52,213,8,'Boost Mana',1070000,72),
(52,1092,18,'Fear',1070000,72),
(52,1097,19,'Dreaming Spirit',1070000,72),
(52,1105,17,'Madness',1070000,72),
(52,1244,4,'Freezing Flame',1070000,72),
(52,1229,17,'Chant of Life',1070000,72),
(52,1245,13,'Steal Essence',1070000,72),
(52,1001,10,'Soul Cry',1070000,72),
(52,927,14,'Burning Chop',1300000,74),
(52,1390,3,'War Chant',1350000,74),
(52,1391,3,'Earth Chant',1350000,74),
(52,1310,4,'Chant of Vampire',1350000,74),
(52,1245,14,'Steal Essence',1350000,74),
(52,1284,3,'Chant of Revenge',1350000,74),
(52,1229,18,'Chant of Life',1350000,74),
(52,1105,18,'Madness',1350000,74),
(52,1097,20,'Dreaming Spirit',1350000,74),
(52,1092,19,'Fear',1350000,74),
(52,229,7,'Fast Mana Recovery',1350000,74),
(52,212,6,'Fast HP Recovery',1350000,74),
(52,260,34,'Hammer Crush',680000,74),
(52,260,35,'Hammer Crush',680000,74),
(52,253,42,'Heavy Armor Mastery',680000,74),
(52,253,43,'Heavy Armor Mastery',680000,74),
(52,252,44,'Light Armor Mastery',680000,74),
(52,252,45,'Light Armor Mastery',680000,74),
(52,251,44,'Robe Mastery',680000,74),
(52,251,45,'Robe Mastery',680000,74),
(52,250,41,'Weapon Mastery',680000,74),
(52,250,42,'Weapon Mastery',680000,74),
(52,146,44,'Anti Magic',680000,74),
(52,146,45,'Anti Magic',680000,74),
(53,142,1,'Armor Mastery',310,5),
(53,141,1,'Weapon Mastery',310,5),
(53,141,2,'Weapon Mastery',1100,10),
(53,42,1,'Sweeper',1100,10),
(53,150,1,'Weight Limit',1100,10),
(53,142,2,'Armor Mastery',550,10),
(53,142,3,'Armor Mastery',550,10),
(53,254,1,'Spoil',1100,10),
(53,142,4,'Armor Mastery',3300,15),
(53,142,5,'Armor Mastery',3300,15),
(53,141,3,'Weapon Mastery',6700,15),
(54,248,1,'Crystallize',3700,20),
(54,34,1,'Bandage',3700,20),
(54,100,1,'Stun Attack',1200,20),
(54,100,2,'Stun Attack',1200,20),
(54,100,3,'Stun Attack',1200,20),
(54,205,1,'Blunt Weapon Mastery',3700,20),
(54,216,1,'Polearm Mastery',3700,20),
(54,227,1,'Light Armor Mastery',1900,20),
(54,227,2,'Light Armor Mastery',1900,20),
(54,231,1,'Heavy Armor Mastery',1900,20),
(54,231,2,'Heavy Armor Mastery',1900,20),
(54,245,1,'Wild Sweep',1200,20),
(54,245,2,'Wild Sweep',1200,20),
(54,245,3,'Wild Sweep',1200,20),
(54,211,1,'Boost HP',3700,20),
(54,254,2,'Spoil',3700,20),
(54,212,1,'Fast HP Recovery',7700,24),
(54,148,1,'Vital Force',7700,24),
(54,245,4,'Wild Sweep',2600,24),
(54,245,5,'Wild Sweep',2600,24),
(54,245,6,'Wild Sweep',2600,24),
(54,231,3,'Heavy Armor Mastery',3900,24),
(54,231,4,'Heavy Armor Mastery',3900,24),
(54,227,3,'Light Armor Mastery',3900,24),
(54,227,4,'Light Armor Mastery',3900,24),
(54,216,2,'Polearm Mastery',7700,24),
(54,205,2,'Blunt Weapon Mastery',7700,24),
(54,100,4,'Stun Attack',2600,24),
(54,100,5,'Stun Attack',2600,24),
(54,100,6,'Stun Attack',2600,24),
(54,150,2,'Weight Limit',7700,24),
(54,302,1,'Spoil Festival',13000,28),
(54,100,7,'Stun Attack',4400,28),
(54,100,8,'Stun Attack',4400,28),
(54,100,9,'Stun Attack',4400,28),
(54,205,3,'Blunt Weapon Mastery',6700,28),
(54,205,4,'Blunt Weapon Mastery',6700,28),
(54,216,3,'Polearm Mastery',6700,28),
(54,216,4,'Polearm Mastery',6700,28),
(54,227,5,'Light Armor Mastery',4400,28),
(54,227,6,'Light Armor Mastery',4400,28),
(54,227,7,'Light Armor Mastery',4400,28),
(54,231,5,'Heavy Armor Mastery',4400,28),
(54,231,6,'Heavy Armor Mastery',4400,28),
(54,231,7,'Heavy Armor Mastery',4400,28),
(54,245,7,'Wild Sweep',4400,28),
(54,245,8,'Wild Sweep',4400,28),
(54,245,9,'Wild Sweep',4400,28),
(54,211,2,'Boost HP',13000,28),
(54,254,3,'Spoil',13000,28),
(54,212,2,'Fast HP Recovery',25000,32),
(54,148,2,'Vital Force',25000,32),
(54,245,10,'Wild Sweep',8300,32),
(54,245,11,'Wild Sweep',8300,32),
(54,245,12,'Wild Sweep',8300,32),
(54,231,8,'Heavy Armor Mastery',8300,32),
(54,231,9,'Heavy Armor Mastery',8300,32),
(54,231,10,'Heavy Armor Mastery',8300,32),
(54,227,8,'Light Armor Mastery',8300,32),
(54,227,9,'Light Armor Mastery',8300,32),
(54,227,10,'Light Armor Mastery',8300,32),
(54,216,5,'Polearm Mastery',13000,32),
(54,216,6,'Polearm Mastery',13000,32),
(54,205,5,'Blunt Weapon Mastery',13000,32),
(54,205,6,'Blunt Weapon Mastery',13000,32),
(54,100,10,'Stun Attack',8300,32),
(54,100,11,'Stun Attack',8300,32),
(54,100,12,'Stun Attack',8300,32),
(54,100,13,'Stun Attack',11000,36),
(54,100,14,'Stun Attack',11000,36),
(54,100,15,'Stun Attack',11000,36),
(54,205,7,'Blunt Weapon Mastery',17000,36),
(54,205,8,'Blunt Weapon Mastery',17000,36),
(54,216,7,'Polearm Mastery',17000,36),
(54,216,8,'Polearm Mastery',17000,36),
(54,227,11,'Light Armor Mastery',11000,36),
(54,227,12,'Light Armor Mastery',11000,36),
(54,227,13,'Light Armor Mastery',11000,36),
(54,231,11,'Heavy Armor Mastery',11000,36),
(54,231,12,'Heavy Armor Mastery',11000,36),
(54,231,13,'Heavy Armor Mastery',11000,36),
(54,245,13,'Wild Sweep',11000,36),
(54,245,14,'Wild Sweep',11000,36),
(54,245,15,'Wild Sweep',11000,36),
(54,211,3,'Boost HP',35000,36),
(54,254,4,'Spoil',35000,36),
(54,302,2,'Spoil Festival',35000,36),
(55,190,1,'Fatal Strike',12000,40),
(55,190,2,'Fatal Strike',12000,40),
(55,190,3,'Fatal Strike',12000,40),
(55,248,2,'Crystallize',35000,40),
(55,36,1,'Whirlwind',12000,40),
(55,36,2,'Whirlwind',12000,40),
(55,36,3,'Whirlwind',12000,40),
(55,205,9,'Blunt Weapon Mastery',12000,40),
(55,205,10,'Blunt Weapon Mastery',12000,40),
(55,205,11,'Blunt Weapon Mastery',12000,40),
(55,216,9,'Polearm Mastery',12000,40),
(55,216,10,'Polearm Mastery',12000,40),
(55,216,11,'Polearm Mastery',12000,40),
(55,227,14,'Light Armor Mastery',12000,40),
(55,227,15,'Light Armor Mastery',12000,40),
(55,227,16,'Light Armor Mastery',12000,40),
(55,231,14,'Heavy Armor Mastery',12000,40),
(55,231,15,'Heavy Armor Mastery',12000,40),
(55,231,16,'Heavy Armor Mastery',12000,40),
(55,260,1,'Hammer Crush',12000,40),
(55,260,2,'Hammer Crush',12000,40),
(55,260,3,'Hammer Crush',12000,40),
(55,60,1,'Fake Death',35000,40),
(55,148,3,'Vital Force',35000,40),
(55,212,3,'Fast HP Recovery',35000,40),
(55,190,4,'Fatal Strike',14000,43),
(55,190,5,'Fatal Strike',14000,43),
(55,190,6,'Fatal Strike',14000,43),
(55,212,4,'Fast HP Recovery',42000,43),
(55,254,5,'Spoil',42000,43),
(55,211,4,'Boost HP',42000,43),
(55,302,3,'Spoil Festival',42000,43),
(55,260,4,'Hammer Crush',14000,43),
(55,260,5,'Hammer Crush',14000,43),
(55,260,6,'Hammer Crush',14000,43),
(55,231,17,'Heavy Armor Mastery',14000,43),
(55,231,18,'Heavy Armor Mastery',14000,43),
(55,231,19,'Heavy Armor Mastery',14000,43),
(55,227,17,'Light Armor Mastery',14000,43),
(55,227,18,'Light Armor Mastery',14000,43),
(55,227,19,'Light Armor Mastery',14000,43),
(55,216,12,'Polearm Mastery',14000,43),
(55,216,13,'Polearm Mastery',14000,43),
(55,216,14,'Polearm Mastery',14000,43),
(55,205,12,'Blunt Weapon Mastery',14000,43),
(55,205,13,'Blunt Weapon Mastery',14000,43),
(55,205,14,'Blunt Weapon Mastery',14000,43),
(55,36,4,'Whirlwind',14000,43),
(55,36,5,'Whirlwind',14000,43),
(55,36,6,'Whirlwind',14000,43),
(55,190,7,'Fatal Strike',20000,46),
(55,190,8,'Fatal Strike',20000,46),
(55,190,9,'Fatal Strike',20000,46),
(55,36,7,'Whirlwind',20000,46),
(55,36,8,'Whirlwind',20000,46),
(55,36,9,'Whirlwind',20000,46),
(55,205,15,'Blunt Weapon Mastery',20000,46),
(55,205,16,'Blunt Weapon Mastery',20000,46),
(55,205,17,'Blunt Weapon Mastery',20000,46),
(55,216,15,'Polearm Mastery',20000,46),
(55,216,16,'Polearm Mastery',20000,46),
(55,216,17,'Polearm Mastery',20000,46),
(55,227,20,'Light Armor Mastery',20000,46),
(55,227,21,'Light Armor Mastery',20000,46),
(55,227,22,'Light Armor Mastery',20000,46),
(55,231,20,'Heavy Armor Mastery',20000,46),
(55,231,21,'Heavy Armor Mastery',20000,46),
(55,231,22,'Heavy Armor Mastery',20000,46),
(55,260,7,'Hammer Crush',20000,46),
(55,260,8,'Hammer Crush',20000,46),
(55,260,9,'Hammer Crush',20000,46),
(55,34,2,'Bandage',60000,46),
(55,148,4,'Vital Force',60000,46),
(55,150,3,'Weight Limit',60000,46),
(55,190,10,'Fatal Strike',33000,49),
(55,190,11,'Fatal Strike',33000,49),
(55,190,12,'Fatal Strike',33000,49),
(55,211,5,'Boost HP',109000,49),
(55,254,6,'Spoil',109000,49),
(55,302,4,'Spoil Festival',98000,49),
(55,260,10,'Hammer Crush',33000,49),
(55,260,11,'Hammer Crush',33000,49),
(55,260,12,'Hammer Crush',33000,49),
(55,231,23,'Heavy Armor Mastery',33000,49),
(55,231,24,'Heavy Armor Mastery',33000,49),
(55,231,25,'Heavy Armor Mastery',33000,49),
(55,227,23,'Light Armor Mastery',33000,49),
(55,227,24,'Light Armor Mastery',33000,49),
(55,227,25,'Light Armor Mastery',33000,49),
(55,216,18,'Polearm Mastery',33000,49),
(55,216,19,'Polearm Mastery',33000,49),
(55,216,20,'Polearm Mastery',33000,49),
(55,205,18,'Blunt Weapon Mastery',33000,49),
(55,205,19,'Blunt Weapon Mastery',33000,49),
(55,205,20,'Blunt Weapon Mastery',33000,49),
(55,36,10,'Whirlwind',33000,49),
(55,36,11,'Whirlwind',33000,49),
(55,36,12,'Whirlwind',33000,49),
(55,190,13,'Fatal Strike',50000,52),
(55,190,14,'Fatal Strike',50000,52),
(55,190,15,'Fatal Strike',50000,52),
(55,248,3,'Crystallize',150000,52),
(55,36,13,'Whirlwind',50000,52),
(55,36,14,'Whirlwind',50000,52),
(55,36,15,'Whirlwind',50000,52),
(55,205,21,'Blunt Weapon Mastery',50000,52),
(55,205,22,'Blunt Weapon Mastery',50000,52),
(55,205,23,'Blunt Weapon Mastery',50000,52),
(55,216,21,'Polearm Mastery',50000,52),
(55,216,22,'Polearm Mastery',50000,52),
(55,216,23,'Polearm Mastery',50000,52),
(55,227,26,'Light Armor Mastery',50000,52),
(55,227,27,'Light Armor Mastery',50000,52),
(55,227,28,'Light Armor Mastery',50000,52),
(55,231,26,'Heavy Armor Mastery',50000,52),
(55,231,27,'Heavy Armor Mastery',50000,52),
(55,231,28,'Heavy Armor Mastery',50000,52),
(55,260,13,'Hammer Crush',50000,52),
(55,260,14,'Hammer Crush',50000,52),
(55,260,15,'Hammer Crush',50000,52),
(55,212,5,'Fast HP Recovery',150000,52),
(55,148,5,'Vital Force',150000,52),
(55,190,16,'Fatal Strike',73000,55),
(55,190,17,'Fatal Strike',73000,55),
(55,190,18,'Fatal Strike',73000,55),
(55,211,6,'Boost HP',220000,55),
(55,254,7,'Spoil',220000,55),
(55,302,5,'Spoil Festival',220000,55),
(55,260,16,'Hammer Crush',73000,55),
(55,260,17,'Hammer Crush',73000,55),
(55,260,18,'Hammer Crush',73000,55),
(55,231,29,'Heavy Armor Mastery',73000,55),
(55,231,30,'Heavy Armor Mastery',73000,55),
(55,231,31,'Heavy Armor Mastery',73000,55),
(55,227,29,'Light Armor Mastery',73000,55),
(55,227,30,'Light Armor Mastery',73000,55),
(55,227,31,'Light Armor Mastery',73000,55),
(55,216,24,'Polearm Mastery',73000,55),
(55,216,25,'Polearm Mastery',73000,55),
(55,216,26,'Polearm Mastery',73000,55),
(55,205,24,'Blunt Weapon Mastery',73000,55),
(55,205,25,'Blunt Weapon Mastery',73000,55),
(55,205,26,'Blunt Weapon Mastery',73000,55),
(55,36,16,'Whirlwind',73000,55),
(55,36,17,'Whirlwind',73000,55),
(55,36,18,'Whirlwind',73000,55),
(55,952,1,'Collector\'s Experience',200000,58),
(55,190,19,'Fatal Strike',73000,58),
(55,190,20,'Fatal Strike',73000,58),
(55,190,21,'Fatal Strike',73000,58),
(55,36,19,'Whirlwind',73000,58),
(55,36,20,'Whirlwind',73000,58),
(55,36,21,'Whirlwind',73000,58),
(55,205,27,'Blunt Weapon Mastery',73000,58),
(55,205,28,'Blunt Weapon Mastery',73000,58),
(55,205,29,'Blunt Weapon Mastery',73000,58),
(55,216,27,'Polearm Mastery',73000,58),
(55,216,28,'Polearm Mastery',73000,58),
(55,216,29,'Polearm Mastery',73000,58),
(55,227,32,'Light Armor Mastery',73000,58),
(55,227,33,'Light Armor Mastery',73000,58),
(55,227,34,'Light Armor Mastery',73000,58),
(55,231,32,'Heavy Armor Mastery',73000,58),
(55,231,33,'Heavy Armor Mastery',73000,58),
(55,231,34,'Heavy Armor Mastery',73000,58),
(55,260,19,'Hammer Crush',73000,58),
(55,260,20,'Hammer Crush',73000,58),
(55,260,21,'Hammer Crush',73000,58),
(55,422,1,'Polearm Accuracy',220000,58),
(55,212,6,'Fast HP Recovery',220000,58),
(55,148,6,'Vital Force',220000,58),
(55,424,1,'War Frenzy',220000,58),
(55,190,22,'Fatal Strike',161000,60),
(55,190,23,'Fatal Strike',161000,60),
(55,248,4,'Crystallize',322000,60),
(55,254,8,'Spoil',322000,60),
(55,260,22,'Hammer Crush',161000,60),
(55,260,23,'Hammer Crush',161000,60),
(55,231,35,'Heavy Armor Mastery',161000,60),
(55,231,36,'Heavy Armor Mastery',161000,60),
(55,227,35,'Light Armor Mastery',161000,60),
(55,227,36,'Light Armor Mastery',161000,60),
(55,216,30,'Polearm Mastery',161000,60),
(55,216,31,'Polearm Mastery',161000,60),
(55,205,30,'Blunt Weapon Mastery',161000,60),
(55,205,31,'Blunt Weapon Mastery',161000,60),
(55,36,22,'Whirlwind',161000,60),
(55,36,23,'Whirlwind',161000,60),
(55,952,2,'Collector\'s Experience',360000,62),
(55,190,24,'Fatal Strike',200000,62),
(55,190,25,'Fatal Strike',200000,62),
(55,36,24,'Whirlwind',200000,62),
(55,36,25,'Whirlwind',200000,62),
(55,205,32,'Blunt Weapon Mastery',200000,62),
(55,205,33,'Blunt Weapon Mastery',200000,62),
(55,216,32,'Polearm Mastery',200000,62),
(55,216,33,'Polearm Mastery',200000,62),
(55,227,37,'Light Armor Mastery',200000,62),
(55,227,38,'Light Armor Mastery',200000,62),
(55,231,37,'Heavy Armor Mastery',200000,62),
(55,231,38,'Heavy Armor Mastery',200000,62),
(55,260,24,'Hammer Crush',200000,62),
(55,260,25,'Hammer Crush',200000,62),
(55,211,7,'Boost HP',400000,62),
(55,34,3,'Bandage',400000,62),
(55,302,6,'Spoil Festival',400000,62),
(55,190,26,'Fatal Strike',270000,64),
(55,190,27,'Fatal Strike',270000,64),
(55,148,7,'Vital Force',530000,64),
(55,254,9,'Spoil',530000,64),
(55,260,26,'Hammer Crush',270000,64),
(55,260,27,'Hammer Crush',270000,64),
(55,231,39,'Heavy Armor Mastery',270000,64),
(55,231,40,'Heavy Armor Mastery',270000,64),
(55,227,39,'Light Armor Mastery',270000,64),
(55,227,40,'Light Armor Mastery',270000,64),
(55,216,34,'Polearm Mastery',270000,64),
(55,216,35,'Polearm Mastery',270000,64),
(55,205,34,'Blunt Weapon Mastery',270000,64),
(55,205,35,'Blunt Weapon Mastery',270000,64),
(55,36,26,'Whirlwind',270000,64),
(55,36,27,'Whirlwind',270000,64),
(55,952,3,'Collector\'s Experience',540000,66),
(55,190,28,'Fatal Strike',290000,66),
(55,190,29,'Fatal Strike',290000,66),
(55,36,28,'Whirlwind',290000,66),
(55,36,29,'Whirlwind',290000,66),
(55,205,36,'Blunt Weapon Mastery',290000,66),
(55,205,37,'Blunt Weapon Mastery',290000,66),
(55,216,36,'Polearm Mastery',290000,66),
(55,216,37,'Polearm Mastery',290000,66),
(55,227,41,'Light Armor Mastery',290000,66),
(55,227,42,'Light Armor Mastery',290000,66),
(55,231,41,'Heavy Armor Mastery',290000,66),
(55,231,42,'Heavy Armor Mastery',290000,66),
(55,260,28,'Hammer Crush',290000,66),
(55,260,29,'Hammer Crush',290000,66),
(55,211,8,'Boost HP',580000,66),
(55,302,7,'Spoil Festival',580000,66),
(55,422,2,'Polearm Accuracy',580000,66),
(55,320,1,'Wrath',290000,66),
(55,320,2,'Wrath',290000,66),
(55,424,2,'War Frenzy',580000,66),
(55,190,30,'Fatal Strike',390000,68),
(55,190,31,'Fatal Strike',390000,68),
(55,320,3,'Wrath',390000,68),
(55,320,4,'Wrath',390000,68),
(55,254,10,'Spoil',780000,68),
(55,212,7,'Fast HP Recovery',780000,68),
(55,260,30,'Hammer Crush',390000,68),
(55,260,31,'Hammer Crush',390000,68),
(55,231,43,'Heavy Armor Mastery',390000,68),
(55,231,44,'Heavy Armor Mastery',390000,68),
(55,227,43,'Light Armor Mastery',390000,68),
(55,227,44,'Light Armor Mastery',390000,68),
(55,216,38,'Polearm Mastery',390000,68),
(55,216,39,'Polearm Mastery',390000,68),
(55,205,38,'Blunt Weapon Mastery',390000,68),
(55,205,39,'Blunt Weapon Mastery',390000,68),
(55,36,30,'Whirlwind',390000,68),
(55,36,31,'Whirlwind',390000,68),
(55,952,4,'Collector\'s Experience',780000,70),
(55,190,32,'Fatal Strike',420000,70),
(55,190,33,'Fatal Strike',420000,70),
(55,248,5,'Crystallize',850000,70),
(55,36,32,'Whirlwind',420000,70),
(55,36,33,'Whirlwind',420000,70),
(55,205,40,'Blunt Weapon Mastery',420000,70),
(55,205,41,'Blunt Weapon Mastery',420000,70),
(55,216,40,'Polearm Mastery',420000,70),
(55,216,41,'Polearm Mastery',420000,70),
(55,227,45,'Light Armor Mastery',420000,70),
(55,227,46,'Light Armor Mastery',420000,70),
(55,231,45,'Heavy Armor Mastery',420000,70),
(55,231,46,'Heavy Armor Mastery',420000,70),
(55,260,32,'Hammer Crush',420000,70),
(55,260,33,'Hammer Crush',420000,70),
(55,211,9,'Boost HP',850000,70),
(55,320,5,'Wrath',420000,70),
(55,320,6,'Wrath',420000,70),
(55,302,8,'Spoil Festival',850000,70),
(55,190,34,'Fatal Strike',600000,72),
(55,190,35,'Fatal Strike',600000,72),
(55,320,7,'Wrath',600000,72),
(55,320,8,'Wrath',600000,72),
(55,148,8,'Vital Force',1200000,72),
(55,254,11,'Spoil',1200000,72),
(55,260,34,'Hammer Crush',600000,72),
(55,260,35,'Hammer Crush',600000,72),
(55,231,47,'Heavy Armor Mastery',600000,72),
(55,231,48,'Heavy Armor Mastery',600000,72),
(55,227,47,'Light Armor Mastery',600000,72),
(55,227,48,'Light Armor Mastery',600000,72),
(55,216,42,'Polearm Mastery',600000,72),
(55,216,43,'Polearm Mastery',600000,72),
(55,205,42,'Blunt Weapon Mastery',600000,72),
(55,205,43,'Blunt Weapon Mastery',600000,72),
(55,36,34,'Whirlwind',600000,72),
(55,36,35,'Whirlwind',600000,72),
(55,952,5,'Collector\'s Experience',1900000,74),
(55,190,36,'Fatal Strike',1000000,74),
(55,190,37,'Fatal Strike',1000000,74),
(55,36,36,'Whirlwind',1000000,74),
(55,36,37,'Whirlwind',1000000,74),
(55,205,44,'Blunt Weapon Mastery',1000000,74),
(55,205,45,'Blunt Weapon Mastery',1000000,74),
(55,216,44,'Polearm Mastery',1000000,74),
(55,216,45,'Polearm Mastery',1000000,74),
(55,227,49,'Light Armor Mastery',1000000,74),
(55,227,50,'Light Armor Mastery',1000000,74),
(55,231,49,'Heavy Armor Mastery',1000000,74),
(55,231,50,'Heavy Armor Mastery',1000000,74),
(55,260,36,'Hammer Crush',1000000,74),
(55,260,37,'Hammer Crush',1000000,74),
(55,212,8,'Fast HP Recovery',2000000,74),
(55,211,10,'Boost HP',2000000,74),
(55,320,9,'Wrath',1000000,74),
(55,320,10,'Wrath',1000000,74),
(55,302,9,'Spoil Festival',2000000,74),
(55,422,3,'Polearm Accuracy',2000000,74),
(55,424,3,'War Frenzy',2000000,74),
(56,34,1,'Bandage',3700,20),
(56,100,1,'Stun Attack',1200,20),
(56,100,2,'Stun Attack',1200,20),
(56,100,3,'Stun Attack',1200,20),
(56,205,1,'Blunt Weapon Mastery',3700,20),
(56,211,1,'Boost HP',3700,20),
(56,216,1,'Polearm Mastery',3700,20),
(56,227,1,'Light Armor Mastery',1900,20),
(56,227,2,'Light Armor Mastery',1900,20),
(56,231,1,'Heavy Armor Mastery',1900,20),
(56,231,2,'Heavy Armor Mastery',1900,20),
(56,245,1,'Wild Sweep',1200,20),
(56,245,2,'Wild Sweep',1200,20),
(56,245,3,'Wild Sweep',1200,20),
(56,248,1,'Crystallize',3700,20),
(56,150,2,'Weight Limit',7000,24),
(56,212,1,'Fast HP Recovery',7000,24),
(56,245,4,'Wild Sweep',2300,24),
(56,245,5,'Wild Sweep',2300,24),
(56,245,6,'Wild Sweep',2300,24),
(56,231,3,'Heavy Armor Mastery',3500,24),
(56,231,4,'Heavy Armor Mastery',3500,24),
(56,227,3,'Light Armor Mastery',3500,24),
(56,227,4,'Light Armor Mastery',3500,24),
(56,216,2,'Polearm Mastery',7000,24),
(56,148,1,'Vital Force',7000,24),
(56,205,2,'Blunt Weapon Mastery',7000,24),
(56,100,4,'Stun Attack',2300,24),
(56,100,5,'Stun Attack',2300,24),
(56,100,6,'Stun Attack',2300,24),
(56,100,7,'Stun Attack',4400,28),
(56,100,8,'Stun Attack',4400,28),
(56,100,9,'Stun Attack',4400,28),
(56,205,3,'Blunt Weapon Mastery',6700,28),
(56,205,4,'Blunt Weapon Mastery',6700,28),
(56,25,1,'Summon Mechanic Golem',13000,28),
(56,211,2,'Boost HP',13000,28),
(56,216,3,'Polearm Mastery',6700,28),
(56,216,4,'Polearm Mastery',6700,28),
(56,227,5,'Light Armor Mastery',4400,28),
(56,227,6,'Light Armor Mastery',4400,28),
(56,227,7,'Light Armor Mastery',4400,28),
(56,231,5,'Heavy Armor Mastery',4400,28),
(56,231,6,'Heavy Armor Mastery',4400,28),
(56,231,7,'Heavy Armor Mastery',4400,28),
(56,245,7,'Wild Sweep',4400,28),
(56,245,8,'Wild Sweep',4400,28),
(56,245,9,'Wild Sweep',4400,28),
(56,245,10,'Wild Sweep',8300,32),
(56,245,11,'Wild Sweep',8300,32),
(56,245,12,'Wild Sweep',8300,32),
(56,231,8,'Heavy Armor Mastery',8300,32),
(56,231,9,'Heavy Armor Mastery',8300,32),
(56,231,10,'Heavy Armor Mastery',8300,32),
(56,227,8,'Light Armor Mastery',8300,32),
(56,227,9,'Light Armor Mastery',8300,32),
(56,227,10,'Light Armor Mastery',8300,32),
(56,216,5,'Polearm Mastery',13000,32),
(56,216,6,'Polearm Mastery',13000,32),
(56,148,2,'Vital Force',25000,32),
(56,205,5,'Blunt Weapon Mastery',13000,32),
(56,205,6,'Blunt Weapon Mastery',13000,32),
(56,100,10,'Stun Attack',8300,32),
(56,100,11,'Stun Attack',8300,32),
(56,100,12,'Stun Attack',8300,32),
(56,212,2,'Fast HP Recovery',25000,32),
(56,100,13,'Stun Attack',11000,36),
(56,100,14,'Stun Attack',11000,36),
(56,100,15,'Stun Attack',11000,36),
(56,205,7,'Blunt Weapon Mastery',17000,36),
(56,205,8,'Blunt Weapon Mastery',17000,36),
(56,25,2,'Summon Mechanic Golem',34000,36),
(56,211,3,'Boost HP',34000,36),
(56,216,7,'Polearm Mastery',17000,36),
(56,216,8,'Polearm Mastery',17000,36),
(56,227,11,'Light Armor Mastery',11000,36),
(56,227,12,'Light Armor Mastery',11000,36),
(56,227,13,'Light Armor Mastery',11000,36),
(56,231,11,'Heavy Armor Mastery',11000,36),
(56,231,12,'Heavy Armor Mastery',11000,36),
(56,231,13,'Heavy Armor Mastery',11000,36),
(56,245,13,'Wild Sweep',11000,36),
(56,245,14,'Wild Sweep',11000,36),
(56,245,15,'Wild Sweep',11000,36),
(57,822,1,'Repair Golem',33000,40),
(57,824,1,'Armor Golem',33000,40),
(57,190,1,'Fatal Strike',11000,40),
(57,190,2,'Fatal Strike',11000,40),
(57,190,3,'Fatal Strike',11000,40),
(57,36,1,'Whirlwind',11000,40),
(57,36,2,'Whirlwind',11000,40),
(57,36,3,'Whirlwind',11000,40),
(57,205,9,'Blunt Weapon Mastery',11000,40),
(57,205,10,'Blunt Weapon Mastery',11000,40),
(57,205,11,'Blunt Weapon Mastery',11000,40),
(57,216,9,'Polearm Mastery',11000,40),
(57,216,10,'Polearm Mastery',11000,40),
(57,216,11,'Polearm Mastery',11000,40),
(57,227,14,'Light Armor Mastery',11000,40),
(57,227,15,'Light Armor Mastery',11000,40),
(57,227,16,'Light Armor Mastery',11000,40),
(57,231,14,'Heavy Armor Mastery',11000,40),
(57,231,15,'Heavy Armor Mastery',11000,40),
(57,231,16,'Heavy Armor Mastery',11000,40),
(57,260,1,'Hammer Crush',11000,40),
(57,260,2,'Hammer Crush',11000,40),
(57,260,3,'Hammer Crush',11000,40),
(57,148,3,'Vital Force',33000,40),
(57,212,3,'Fast HP Recovery',33000,40),
(57,248,2,'Crystallize',33000,40),
(57,823,1,'Strengthen Golem',38000,43),
(57,190,4,'Fatal Strike',13000,43),
(57,190,5,'Fatal Strike',13000,43),
(57,190,6,'Fatal Strike',13000,43),
(57,212,4,'Fast HP Recovery',38000,43),
(57,211,4,'Boost HP',38000,43),
(57,25,3,'Summon Mechanic Golem',38000,43),
(57,260,4,'Hammer Crush',13000,43),
(57,260,5,'Hammer Crush',13000,43),
(57,260,6,'Hammer Crush',13000,43),
(57,231,17,'Heavy Armor Mastery',13000,43),
(57,231,18,'Heavy Armor Mastery',13000,43),
(57,231,19,'Heavy Armor Mastery',13000,43),
(57,227,17,'Light Armor Mastery',13000,43),
(57,227,18,'Light Armor Mastery',13000,43),
(57,227,19,'Light Armor Mastery',13000,43),
(57,216,12,'Polearm Mastery',13000,43),
(57,216,13,'Polearm Mastery',13000,43),
(57,216,14,'Polearm Mastery',13000,43),
(57,205,12,'Blunt Weapon Mastery',13000,43),
(57,205,13,'Blunt Weapon Mastery',13000,43),
(57,205,14,'Blunt Weapon Mastery',13000,43),
(57,36,4,'Whirlwind',13000,43),
(57,36,5,'Whirlwind',13000,43),
(57,36,6,'Whirlwind',13000,43),
(57,190,7,'Fatal Strike',15000,46),
(57,190,8,'Fatal Strike',15000,46),
(57,190,9,'Fatal Strike',15000,46),
(57,36,7,'Whirlwind',15000,46),
(57,36,8,'Whirlwind',15000,46),
(57,36,9,'Whirlwind',15000,46),
(57,205,15,'Blunt Weapon Mastery',15000,46),
(57,205,16,'Blunt Weapon Mastery',15000,46),
(57,205,17,'Blunt Weapon Mastery',15000,46),
(57,828,1,'Case Harden',46000,46),
(57,829,1,'Hard Tanning',46000,46),
(57,830,1,'Embroider',46000,46),
(57,216,15,'Polearm Mastery',15000,46),
(57,216,16,'Polearm Mastery',15000,46),
(57,216,17,'Polearm Mastery',15000,46),
(57,227,20,'Light Armor Mastery',15000,46),
(57,227,21,'Light Armor Mastery',15000,46),
(57,227,22,'Light Armor Mastery',15000,46),
(57,231,20,'Heavy Armor Mastery',15000,46),
(57,231,21,'Heavy Armor Mastery',15000,46),
(57,231,22,'Heavy Armor Mastery',15000,46),
(57,260,7,'Hammer Crush',15000,46),
(57,260,8,'Hammer Crush',15000,46),
(57,260,9,'Hammer Crush',15000,46),
(57,34,2,'Bandage',46000,46),
(57,150,3,'Weight Limit',46000,46),
(57,148,4,'Vital Force',46000,46),
(57,822,2,'Repair Golem',46000,49),
(57,824,2,'Armor Golem',46000,49),
(57,190,10,'Fatal Strike',20000,49),
(57,190,11,'Fatal Strike',20000,49),
(57,190,12,'Fatal Strike',20000,49),
(57,25,4,'Summon Mechanic Golem',61000,49),
(57,13,1,'Summon Siege Golem',700000,49),
(57,211,5,'Boost HP',61000,49),
(57,260,10,'Hammer Crush',20000,49),
(57,260,11,'Hammer Crush',20000,49),
(57,260,12,'Hammer Crush',20000,49),
(57,231,23,'Heavy Armor Mastery',20000,49),
(57,231,24,'Heavy Armor Mastery',20000,49),
(57,231,25,'Heavy Armor Mastery',20000,49),
(57,227,23,'Light Armor Mastery',20000,49),
(57,227,24,'Light Armor Mastery',20000,49),
(57,227,25,'Light Armor Mastery',20000,49),
(57,216,18,'Polearm Mastery',20000,49),
(57,216,19,'Polearm Mastery',20000,49),
(57,216,20,'Polearm Mastery',20000,49),
(57,205,18,'Blunt Weapon Mastery',20000,49),
(57,205,19,'Blunt Weapon Mastery',20000,49),
(57,205,20,'Blunt Weapon Mastery',20000,49),
(57,825,1,'Sharp Edge',61000,49),
(57,826,1,'Spike',61000,49),
(57,827,1,'Restring',61000,49),
(57,36,10,'Whirlwind',20000,49),
(57,36,11,'Whirlwind',20000,49),
(57,36,12,'Whirlwind',20000,49),
(57,831,1,'Summon Merchant Golem',125000,52),
(57,823,2,'Strengthen Golem',125000,52),
(57,190,13,'Fatal Strike',42000,52),
(57,190,14,'Fatal Strike',42000,52),
(57,190,15,'Fatal Strike',42000,52),
(57,36,13,'Whirlwind',42000,52),
(57,36,14,'Whirlwind',42000,52),
(57,36,15,'Whirlwind',42000,52),
(57,205,21,'Blunt Weapon Mastery',42000,52),
(57,205,22,'Blunt Weapon Mastery',42000,52),
(57,205,23,'Blunt Weapon Mastery',42000,52),
(57,216,21,'Polearm Mastery',42000,52),
(57,216,22,'Polearm Mastery',42000,52),
(57,216,23,'Polearm Mastery',42000,52),
(57,227,26,'Light Armor Mastery',42000,52),
(57,227,27,'Light Armor Mastery',42000,52),
(57,227,28,'Light Armor Mastery',42000,52),
(57,231,26,'Heavy Armor Mastery',42000,52),
(57,231,27,'Heavy Armor Mastery',42000,52),
(57,231,28,'Heavy Armor Mastery',42000,52),
(57,260,13,'Hammer Crush',42000,52),
(57,260,14,'Hammer Crush',42000,52),
(57,260,15,'Hammer Crush',42000,52),
(57,212,5,'Fast HP Recovery',125000,52),
(57,248,3,'Crystallize',125000,52),
(57,148,5,'Vital Force',125000,52),
(57,822,3,'Repair Golem',171000,55),
(57,824,3,'Armor Golem',171000,55),
(57,190,16,'Fatal Strike',57000,55),
(57,190,17,'Fatal Strike',57000,55),
(57,190,18,'Fatal Strike',57000,55),
(57,25,5,'Summon Mechanic Golem',171000,55),
(57,211,6,'Boost HP',171000,55),
(57,260,16,'Hammer Crush',57000,55),
(57,260,17,'Hammer Crush',57000,55),
(57,260,18,'Hammer Crush',57000,55),
(57,231,29,'Heavy Armor Mastery',57000,55),
(57,231,30,'Heavy Armor Mastery',57000,55),
(57,231,31,'Heavy Armor Mastery',57000,55),
(57,227,29,'Light Armor Mastery',57000,55),
(57,227,30,'Light Armor Mastery',57000,55),
(57,227,31,'Light Armor Mastery',57000,55),
(57,216,24,'Polearm Mastery',57000,55),
(57,216,25,'Polearm Mastery',57000,55),
(57,216,26,'Polearm Mastery',57000,55),
(57,205,24,'Blunt Weapon Mastery',57000,55),
(57,205,25,'Blunt Weapon Mastery',57000,55),
(57,205,26,'Blunt Weapon Mastery',57000,55),
(57,36,16,'Whirlwind',57000,55),
(57,36,17,'Whirlwind',57000,55),
(57,36,18,'Whirlwind',57000,55),
(57,823,3,'Strengthen Golem',183000,58), 
(57,190,19,'Fatal Strike',61000,58),
(57,190,20,'Fatal Strike',61000,58),
(57,190,21,'Fatal Strike',61000,58),
(57,36,19,'Whirlwind',61000,58),
(57,36,20,'Whirlwind',61000,58),
(57,36,21,'Whirlwind',61000,58),
(57,205,27,'Blunt Weapon Mastery',61000,58),
(57,205,28,'Blunt Weapon Mastery',61000,58),
(57,205,29,'Blunt Weapon Mastery',61000,58),
(57,216,27,'Polearm Mastery',61000,58),
(57,216,28,'Polearm Mastery',61000,58),
(57,216,29,'Polearm Mastery',61000,58),
(57,227,32,'Light Armor Mastery',61000,58),
(57,227,33,'Light Armor Mastery',61000,58),
(57,227,34,'Light Armor Mastery',61000,58),
(57,231,32,'Heavy Armor Mastery',61000,58),
(57,231,33,'Heavy Armor Mastery',61000,58),
(57,231,34,'Heavy Armor Mastery',61000,58),
(57,260,19,'Hammer Crush',61000,58),
(57,260,20,'Hammer Crush',61000,58),
(57,260,21,'Hammer Crush',61000,58),
(57,212,6,'Fast HP Recovery',183000,58),
(57,299,1,'Summon Wild Hog Cannon',800000,58),
(57,301,1,'Summon Big Boom',183000,58),
(57,148,6,'Vital Force',183000,58),
(57,422,1,'Polearm Accuracy',183000,58),
(57,424,1,'War Frenzy',183000,58),
(57,190,22,'Fatal Strike',161000,60),
(57,190,23,'Fatal Strike',161000,60),
(57,25,6,'Summon Mechanic Golem',322000,60),
(57,248,4,'Crystallize',322000,60),
(57,260,22,'Hammer Crush',161000,60),
(57,260,23,'Hammer Crush',161000,60),
(57,231,35,'Heavy Armor Mastery',161000,60),
(57,231,36,'Heavy Armor Mastery',161000,60),
(57,227,35,'Light Armor Mastery',161000,60),
(57,227,36,'Light Armor Mastery',161000,60),
(57,216,30,'Polearm Mastery',161000,60),
(57,216,31,'Polearm Mastery',161000,60),
(57,205,30,'Blunt Weapon Mastery',161000,60),
(57,205,31,'Blunt Weapon Mastery',161000,60),
(57,36,22,'Whirlwind',161000,60),
(57,36,23,'Whirlwind',161000,60),
(57,190,24,'Fatal Strike',180000,62),
(57,190,25,'Fatal Strike',180000,62),
(57,36,24,'Whirlwind',180000,62),
(57,36,25,'Whirlwind',180000,62),
(57,205,32,'Blunt Weapon Mastery',180000,62),
(57,205,33,'Blunt Weapon Mastery',180000,62),
(57,216,32,'Polearm Mastery',180000,62),
(57,216,33,'Polearm Mastery',180000,62),
(57,227,37,'Light Armor Mastery',180000,62),
(57,227,38,'Light Armor Mastery',180000,62),
(57,231,37,'Heavy Armor Mastery',180000,62),
(57,231,38,'Heavy Armor Mastery',180000,62),
(57,260,24,'Hammer Crush',180000,62),
(57,260,25,'Hammer Crush',180000,62),
(57,301,2,'Summon Big Boom',360000,62),
(57,211,7,'Boost HP',360000,62),
(57,34,3,'Bandage',360000,62),
(57,190,26,'Fatal Strike',270000,64),
(57,190,27,'Fatal Strike',270000,64),
(57,25,7,'Summon Mechanic Golem',530000,64),
(57,148,7,'Vital Force',530000,64),
(57,260,26,'Hammer Crush',270000,64),
(57,260,27,'Hammer Crush',270000,64),
(57,231,39,'Heavy Armor Mastery',270000,64),
(57,231,40,'Heavy Armor Mastery',270000,64),
(57,227,39,'Light Armor Mastery',270000,64),
(57,227,40,'Light Armor Mastery',270000,64),
(57,216,34,'Polearm Mastery',270000,64),
(57,216,35,'Polearm Mastery',270000,64),
(57,205,34,'Blunt Weapon Mastery',270000,64),
(57,205,35,'Blunt Weapon Mastery',270000,64),
(57,36,26,'Whirlwind',270000,64),
(57,36,27,'Whirlwind',270000,64),
(57,190,28,'Fatal Strike',290000,66),
(57,190,29,'Fatal Strike',290000,66),
(57,36,28,'Whirlwind',290000,66),
(57,36,29,'Whirlwind',290000,66),
(57,205,36,'Blunt Weapon Mastery',290000,66),
(57,205,37,'Blunt Weapon Mastery',290000,66),
(57,216,36,'Polearm Mastery',290000,66),
(57,216,37,'Polearm Mastery',290000,66),
(57,227,41,'Light Armor Mastery',290000,66),
(57,227,42,'Light Armor Mastery',290000,66),
(57,231,41,'Heavy Armor Mastery',290000,66),
(57,231,42,'Heavy Armor Mastery',290000,66),
(57,260,28,'Hammer Crush',290000,66),
(57,260,29,'Hammer Crush',290000,66),
(57,211,8,'Boost HP',580000,66),
(57,301,3,'Summon Big Boom',580000,66),
(57,424,2,'War Frenzy',580000,66),
(57,422,2,'Polearm Accuracy',580000,66),
(57,320,1,'Wrath',290000,66),
(57,320,2,'Wrath',290000,66),
(57,190,30,'Fatal Strike',350000,68),
(57,190,31,'Fatal Strike',350000,68),
(57,320,3,'Wrath',350000,68),
(57,320,4,'Wrath',350000,68),
(57,448,1,'Summon Swoop Cannon',3300000,68),
(57,212,7,'Fast HP Recovery',710000,68),
(57,25,8,'Summon Mechanic Golem',710000,68),
(57,260,30,'Hammer Crush',350000,68),
(57,260,31,'Hammer Crush',350000,68),
(57,231,43,'Heavy Armor Mastery',350000,68),
(57,231,44,'Heavy Armor Mastery',350000,68),
(57,227,43,'Light Armor Mastery',350000,68),
(57,227,44,'Light Armor Mastery',350000,68),
(57,216,38,'Polearm Mastery',350000,68),
(57,216,39,'Polearm Mastery',350000,68),
(57,205,38,'Blunt Weapon Mastery',350000,68),
(57,205,39,'Blunt Weapon Mastery',350000,68),
(57,36,30,'Whirlwind',350000,68),
(57,36,31,'Whirlwind',350000,68),
(57,190,32,'Fatal Strike',390000,70),
(57,190,33,'Fatal Strike',390000,70),
(57,36,32,'Whirlwind',390000,70),
(57,36,33,'Whirlwind',390000,70),
(57,205,40,'Blunt Weapon Mastery',390000,70),
(57,205,41,'Blunt Weapon Mastery',390000,70),
(57,216,40,'Polearm Mastery',390000,70),
(57,216,41,'Polearm Mastery',390000,70),
(57,227,45,'Light Armor Mastery',390000,70),
(57,227,46,'Light Armor Mastery',390000,70),
(57,231,45,'Heavy Armor Mastery',390000,70),
(57,231,46,'Heavy Armor Mastery',390000,70),
(57,260,32,'Hammer Crush',390000,70),
(57,260,33,'Hammer Crush',390000,70),
(57,211,9,'Boost HP',780000,70),
(57,301,4,'Summon Big Boom',780000,70),
(57,248,5,'Crystallize',780000,70),
(57,320,5,'Wrath',390000,70),
(57,320,6,'Wrath',390000,70),
(57,190,34,'Fatal Strike',600000,72),
(57,190,35,'Fatal Strike',600000,72),
(57,320,7,'Wrath',600000,72),
(57,320,8,'Wrath',600000,72),
(57,25,9,'Summon Mechanic Golem',1200000,72),
(57,148,8,'Vital Force',1200000,72),
(57,260,34,'Hammer Crush',600000,72),
(57,260,35,'Hammer Crush',600000,72),
(57,231,47,'Heavy Armor Mastery',600000,72),
(57,231,48,'Heavy Armor Mastery',600000,72),
(57,227,47,'Light Armor Mastery',600000,72),
(57,227,48,'Light Armor Mastery',600000,72),
(57,216,42,'Polearm Mastery',600000,72),
(57,216,43,'Polearm Mastery',600000,72),
(57,205,42,'Blunt Weapon Mastery',600000,72),
(57,205,43,'Blunt Weapon Mastery',600000,72),
(57,36,34,'Whirlwind',600000,72),
(57,36,35,'Whirlwind',600000,72),
(57,190,36,'Fatal Strike',1000000,74),
(57,190,37,'Fatal Strike',1000000,74),
(57,36,36,'Whirlwind',1000000,74),
(57,36,37,'Whirlwind',1000000,74),
(57,205,44,'Blunt Weapon Mastery',1000000,74),
(57,205,45,'Blunt Weapon Mastery',1000000,74),
(57,216,44,'Polearm Mastery',1000000,74),
(57,216,45,'Polearm Mastery',1000000,74),
(57,227,49,'Light Armor Mastery',1000000,74),
(57,227,50,'Light Armor Mastery',1000000,74),
(57,231,49,'Heavy Armor Mastery',1000000,74),
(57,231,50,'Heavy Armor Mastery',1000000,74),
(57,260,36,'Hammer Crush',1000000,74),
(57,260,37,'Hammer Crush',1000000,74),
(57,301,5,'Summon Big Boom',2000000,74),
(57,211,10,'Boost HP',2000000,74),
(57,212,8,'Fast HP Recovery',2000000,74),
(57,320,9,'Wrath',1000000,74),
(57,320,10,'Wrath',1000000,74),
(57,422,3,'Polearm Accuracy',2000000,74),
(57,424,3,'War Frenzy',2000000,74),
(88,328,1,'Wisdom',10000000,76),
(88,329,1,'Health',10000000,76),
(88,330,1,'Skill Mastery',12250000,77),
(88,340,1,'Riposte Stance',12250000,77),
(88,359,1,'Eye of Hunter',12250000,77),
(88,360,1,'Eye of Slayer',16000000,78),
(88,440,1,'Braveheart',16000000,78),
(88,430,1,'Master of Combat',16000000,78),
(88,345,1,'Sonic Rage',16000000,78),
(88,442,1,'Sonic Barrier',80000000,79),
(88,458,1,'Symbol of Energy',150000000,80),
(88,8,8,'Sonic Focus',80000000,79),
(89,921,1,'Cursed Pierce',8300000,76),
(89,328,1,'Wisdom',10000000,76),
(89,329,1,'Health',10000000,76),
(89,330,1,'Skill Mastery',12250000,77),
(89,361,1,'Shock Blast',12250000,77),
(89,359,1,'Eye of Hunter',12250000,77),
(89,360,1,'Eye of Slayer',12800000,78),
(89,430,1,'Master of Combat',12800000,78),
(89,347,1,'Earthquake',12800000,78),
(89,339,1,'Parry Stance',12800000,78),
(89,440,1,'Braveheart',12800000,78),
(89,457,1,'Symbol of Honor',150000000,80),
(90,328,1,'Wisdom',10000000,76),
(90,329,1,'Health',10000000,76),
(90,335,1,'Fortitude',10000000,76),
(90,353,1,'Shield Slam',13000000,77),
(90,368,1,'Vengeance',13000000,77),
(90,429,1,'Knighthood',21340000,78),
(90,341,1,'Touch of Life',21340000,78),
(90,350,1,'Physical Mirror',21340000,78),
(90,438,1,'Soul of the Phoenix',80000000,79),
(90,527,1,'Iron Shield',80000000,79),
(90,528,1,'Shield of Faith',80000000,79),
(90,454,1,'Symbol of Defense',150000000,80),
(91,328,1,'Wisdom',10000000,76),
(91,329,1,'Health',10000000,76),
(91,335,1,'Fortitude',10000000,76),
(91,353,1,'Shield Slam',13000000,77),
(91,368,1,'Vengeance',13000000,77),
(91,429,1,'Knighthood',21340000,78),
(91,342,1,'Touch of Death',21340000,78),
(91,350,1,'Physical Mirror',21340000,78),
(91,439,1,'Shield of Revenge',80000000,79),
(91,527,1,'Iron Shield',80000000,79),
(91,528,1,'Shield of Faith',80000000,79),
(91,454,1,'Symbol of Defense',150000000,80),
(92,343,1,'Lethal Shot',12500000,76),
(92,328,1,'Wisdom',12500000,76),
(92,330,1,'Skill Mastery',14670000,77),
(92,354,1,'Hamstring Shot',14670000,77),
(92,334,1,'Focus Skill Mastery',32000000,78),
(92,431,1,'Archery',32000000,78),
(92,534,1,'Counter Dash',80000000,79),
(92,535,1,'Counter Mind',80000000,79),
(92,459,1,'Symbol of the Sniper',150000000,80),
(93,328,1,'Wisdom',12500000,76),
(93,344,1,'Lethal Blow',12500000,76),
(93,330,1,'Skill Mastery',14670000,77),
(93,358,1,'Bluff',14670000,77),
(93,334,1,'Focus Skill Mastery',16000000,78),
(93,356,1,'Focus Chance',16000000,78),
(93,357,1,'Focus Power',16000000,78),
(93,432,1,'Assassination',16000000,78),
(93,531,1,'Critical Wound',80000000,79),
(93,445,1,'Mirage',80000000,79),
(93,460,1,'Symbol of the Assassin',150000000,80),
(94,925,1,'Sigil Mastery',12500000,76),
(94,328,1,'Wisdom',15000000,76),
(94,331,1,'Skill Mastery',18000000,77),
(94,1339,1,'Fire Vortex',18000000,77),
(94,1338,1,'Arcane Chaos',21340000,78),
(94,337,1,'Arcane Power',21340000,78),
(94,433,1,'Arcane Roar',21340000,78),
(94,1451,1,'Fire Vortex Buster',80000000,79),
(94,1452,1,'Count of Fire',80000000,79),
(94,1419,1,'Volcano',150000000,80),
(95,925,1,'Sigil Mastery',6250000,76),
(95,329,1,'Health',8340000,76),
(95,1343,1,'Dark Vortex',8340000,76),
(95,328,1,'Wisdom',8340000,76),
(95,1344,1,'Mass Warrior Bane',11000000,77),
(95,331,1,'Skill Mastery',11000000,77),
(95,1336,1,'Curse of Doom',11000000,77),
(95,1337,1,'Curse of Abyss',16000000,78),
(95,1345,1,'Mass Mage Bane',16000000,78),
(95,337,1,'Arcane Power',16000000,78),
(95,434,1,'Necromancy',16000000,78),
(95,1422,1,'Day of Doom',150000000,80),
(95,1423,1,'Gehenna',150000000,80),
(96,934,1,'Sigil Mastery',8300000,76),
(96,1350,1,'Warrior Bane',10000000,76),
(96,328,1,'Wisdom',10000000,76),
(96,1351,1,'Mage Bane',12250000,77),
(96,331,1,'Skill Mastery',12250000,77),
(96,1346,1,'Warrior Servitor',12250000,77),
(96,1349,1,'Final Servitor',21340000,78),
(96,338,1,'Arcane Agility',21340000,78),
(96,435,1,'Summon Lore',21340000,78),
(96,1406,1,'Summon Feline King',80000000,79),
(96,1424,1,'Anti-Summoning Field',150000000,80),
(96,781,1,'Summon Smart Cubic',150000000,80),
(97,926,1,'Sigil Mastery',6250000,76),
(97,1335,1,'Balance Life',8340000,76),
(97,328,1,'Wisdom',8340000,76),
(97,329,1,'Health',8340000,76),
(97,331,1,'Skill Mastery',11000000,77),
(97,1353,1,'Divine Protection',11000000,77),
(97,1360,1,'Mass Block Shield',11000000,77),
(97,1361,1,'Mass Block Wind Walk',16000000,78),
(97,1409,1,'Cleanse',16000000,78),
(97,336,1,'Arcane Wisdom',16000000,78),
(97,436,1,'Divine Lore',16000000,78),
(97,1459,1,'Divine Power',80000000,79),
(97,1410,1,'Salvation',80000000,79),
(97,1425,1,'Purification Field',150000000,80),
(97,1426,1,'Miracle',150000000,80),
(98,935,1,'Sigil Mastery',6250000,76),
(98,329,1,'Health',8340000,76),
(98,1352,1,'Elemental Protection',8340000,76),
(98,328,1,'Wisdom',8340000,76),
(98,331,1,'Skill Mastery',11000000,77),
(98,1358,1,'Block Shield',11000000,77),
(98,1359,1,'Block Wind Walk',11000000,77),
(98,1356,1,'Prophecy of Fire',21340000,78),
(98,336,1,'Arcane Wisdom',21340000,78),
(98,436,1,'Divine Lore',21340000,78),
(98,1411,1,'Mystic Immunity',80000000,79),
(98,1412,1,'Spell Turning',80000000,79),
(99,328,1,'Wisdom',10000000,76),
(99,335,1,'Fortitude',10000000,76),
(99,329,1,'Health',10000000,76),
(99,352,1,'Shield Bash',13000000,77),
(99,368,1,'Vengeance',13000000,77),
(99,429,1,'Knighthood',21340000,78),
(99,341,1,'Touch of Life',21340000,78),
(99,351,1,'Magical Mirror',21340000,78),
(99,527,1,'Iron Shield',80000000,79),
(99,528,1,'Shield of Faith',80000000,79),
(99,454,1,'Symbol of Defense',150000000,80),
(99,779,1,'Summon Smart Cubic',150000000,80),
(100,329,1,'Health',12500000,76),
(100,328,1,'Wisdom',12500000,76),
(100,764,1,'Song of Wind Storm',0,76),
(100,349,1,'Song of Renewal',14670000,77),
(100,363,1,'Song of Meditation',14670000,77),
(100,364,1,'Song of Champion',32000000,78),
(100,428,1,'Inner Rhythm',32000000,78),
(100,437,1,'Song of Silence',80000000,79),
(100,529,1,'Song of Elemental',80000000,79),
(100,455,1,'Symbol of Noise',150000000,80),
(101,344,1,'Lethal Blow',12500000,76),
(101,328,1,'Wisdom',12500000,76),
(101,330,1,'Skill Mastery',14670000,77),
(101,358,1,'Bluff',14670000,77),
(101,334,1,'Focus Skill Mastery',16000000,78),
(101,355,1,'Focus Death',16000000,78),
(101,356,1,'Focus Chance',16000000,78),
(101,432,1,'Assassination',16000000,78),
(101,531,1,'Critical Wound',80000000,79),
(101,446,1,'Dodge',80000000,79),
(101,460,1,'Symbol of the Assassin',150000000,80),
(102,343,1,'Lethal Shot',12500000,76),
(102,328,1,'Wisdom',12500000,76),
(102,354,1,'Hamstring Shot',14670000,77),
(102,330,1,'Skill Mastery',14670000,77),
(102,334,1,'Focus Skill Mastery',21340000,78),
(102,369,1,'Evade Shot',21340000,78),
(102,431,1,'Archery',21340000,78),
(102,533,1,'Counter Rapid Shot',80000000,79),
(102,534,1,'Counter Dash',80000000,79),
(102,459,1,'Symbol of the Sniper',150000000,80),
(103,925,1,'Sigil Mastery',8300000,76),
(103,1342,1,'Light Vortex',12500000,76),
(103,328,1,'Wisdom',12500000,76),
(103,331,1,'Skill Mastery',14670000,77),
(103,1340,1,'Ice Vortex',14670000,77),
(103,1338,1,'Arcane Chaos',21340000,78),
(103,337,1,'Arcane Power',21340000,78),
(103,433,1,'Arcane Roar',21340000,78),
(103,1453,1,'Ice Vortex Crusher',80000000,79),
(103,1454,1,'Diamond Dust',80000000,79),
(103,1455,1,'Throne of Ice',80000000,79),
(103,1421,1,'Raging Waves',150000000,80),
(104,934,1,'Sigil Mastery',8300000,76),
(104,328,1,'Wisdom',12500000,76),
(104,1350,1,'Warrior Bane',12500000,76),
(104,331,1,'Skill Mastery',14670000,77),
(104,1347,1,'Wizard Servitor',14670000,77),
(104,1349,1,'Final Servitor',21340000,78),
(104,338,1,'Arcane Agility',21340000,78),
(104,435,1,'Summon Lore',21340000,78),
(104,1407,1,'Summon Magnus the Unicorn',80000000,79),
(104,1424,1,'Anti-Summoning Field',150000000,80),
(104,782,1,'Summon Smart Cubic',150000000,80),
(105,926,1,'Sigil Mastery',6250000,76),
(105,329,1,'Health',8340000,76),
(105,1354,1,'Arcane Protection',8340000,76),
(105,328,1,'Wisdom',8340000,76),
(105,1359,1,'Block Wind Walk',11000000,77),
(105,331,1,'Skill Mastery',11000000,77),
(105,1353,1,'Divine Protection',11000000,77),
(105,1355,1,'Prophecy of Water',21340000,78),
(105,336,1,'Arcane Wisdom',21340000,78),
(105,436,1,'Divine Lore',21340000,78),
(105,1460,1,'Mana Gain',80000000,79),
(105,1428,1,'Mass Recharge',150000000,80),
(106,328,1,'Wisdom',10000000,76),
(106,335,1,'Fortitude',10000000,76),
(106,329,1,'Health',10000000,76),
(106,352,1,'Shield Bash',13000000,77),
(106,368,1,'Vengeance',13000000,77),
(106,429,1,'Knighthood',21340000,78),
(106,342,1,'Touch of Death',21340000,78),
(106,351,1,'Magical Mirror',21340000,78),
(106,527,1,'Iron Shield',80000000,79),
(106,528,1,'Shield of Faith',80000000,79),
(106,454,1,'Symbol of Defense',150000000,80),
(106,780,1,'Summon Smart Cubic',150000000,80),
(107,328,1,'Wisdom',12500000,76),
(107,765,1,'Dance of Blade Storm',0,76),
(107,329,1,'Health',12500000,76),
(107,366,1,'Dance of Shadows',14670000,77),
(107,367,1,'Dance of Medusa',14670000,77),
(107,428,1,'Inner Rhythm',32000000,78),
(107,365,1,'Siren\'s Dance',32000000,78),
(107,530,1,'Dance of Alignment',80000000,79),
(107,455,1,'Symbol of Noise',150000000,80),
(108,344,1,'Lethal Blow',12500000,76),
(108,328,1,'Wisdom',12500000,76),
(108,330,1,'Skill Mastery',14670000,77),
(108,358,1,'Bluff',14670000,77),
(108,334,1,'Focus Skill Mastery',16000000,78),
(108,355,1,'Focus Death',16000000,78),
(108,357,1,'Focus Power',16000000,78),
(108,432,1,'Assassination',16000000,78),
(108,531,1,'Critical Wound',80000000,79),
(108,447,1,'Counterattack',80000000,79),
(108,460,1,'Symbol of the Assassin',150000000,80),
(109,343,1,'Lethal Shot',12500000,76),
(109,328,1,'Wisdom',12500000,76),
(109,354,1,'Hamstring Shot',14670000,77),
(109,330,1,'Skill Mastery',14670000,77),
(109,369,1,'Evade Shot',21340000,78),
(109,334,1,'Focus Skill Mastery',21340000,78),
(109,431,1,'Archery',21340000,78),
(109,532,1,'Counter Chance',80000000,79),
(109,535,1,'Counter Mind',80000000,79),
(109,459,1,'Symbol of the Sniper',150000000,80),
(110,925,1,'Sigil Mastery',6250000,76),
(110,329,1,'Health',10000000,76),
(110,328,1,'Wisdom',10000000,76),
(110,1343,1,'Dark Vortex',10000000,76),
(110,1341,1,'Wind Vortex',13000000,77),
(110,331,1,'Skill Mastery',13000000,77),
(110,1338,1,'Arcane Chaos',21340000,78),
(110,337,1,'Arcane Power',21340000,78),
(110,433,1,'Arcane Roar',21340000,78),
(110,1456,1,'Wind Vortex Slug',80000000,79),
(110,1457,1,'Empowering Echo',80000000,79),
(110,1458,1,'Throne of Wind',80000000,79),
(110,1420,1,'Cyclone',150000000,80),
(111,934,1,'Sigil Mastery',8300000,76),
(111,328,1,'Wisdom',10000000,76),
(111,329,1,'Health',10000000,76),
(111,331,1,'Skill Mastery',12250000,77),
(111,1348,1,'Assassin Servitor',12250000,77),
(111,1351,1,'Mage Bane',12250000,77),
(111,1349,1,'Final Servitor',21340000,78),
(111,338,1,'Arcane Agility',21340000,78),
(111,435,1,'Summon Lore',21340000,78),
(111,1408,1,'Summon Spectral Lord',80000000,79),
(111,1424,1,'Anti-Summoning Field',150000000,80),
(111,783,1,'Summon Smart Cubic',150000000,80),
(112,926,1,'Sigil Mastery',6250000,76),
(112,329,1,'Health',10000000,76),
(112,1354,1,'Arcane Protection',10000000,76),
(112,328,1,'Wisdom',10000000,76),
(112,331,1,'Skill Mastery',13000000,77),
(112,1358,1,'Block Shield',13000000,77),
(112,1357,1,'Prophecy of Wind',21340000,78),
(112,336,1,'Arcane Wisdom',21340000,78),
(112,436,1,'Divine Lore',21340000,78),
(112,1460,1,'Mana Gain',80000000,79),
(112,1508,1,'Throne Root',150000000,80),
(112,1428,1,'Mass Recharge',150000000,80),
(113,329,1,'Health',10000000,76),
(113,328,1,'Wisdom',10000000,76),
(113,335,1,'Fortitude',10000000,76),
(113,330,1,'Skill Mastery',13000000,77),
(113,362,1,'Armor Crush',13000000,77),
(113,430,1,'Master of Combat',16000000,78),
(113,339,1,'Parry Stance',16000000,78),
(113,347,1,'Earthquake',16000000,78),
(113,440,1,'Braveheart',16000000,78),
(113,536,1,'Over the Body',80000000,79),
(113,456,1,'Symbol of Resistance',150000000,80),
(114,329,1,'Health',10000000,76),
(114,328,1,'Wisdom',10000000,76),
(114,335,1,'Fortitude',10000000,76),
(114,330,1,'Skill Mastery',13000000,77),
(114,340,1,'Riposte Stance',13000000,77),
(114,430,1,'Master of Combat',21340000,78),
(114,441,1,'Force Meditation',21340000,78),
(114,346,1,'Raging Force',21340000,78),
(114,443,1,'Force Barrier',80000000,79),
(114,50,8,'Focused Force',80000000,79),
(114,458,1,'Symbol of Energy',150000000,80),
(115,926,1,'Sigil Mastery',6250000,76),
(115,329,1,'Health',8340000,76),
(115,1367,1,'Seal of Disease',8340000,76),
(115,328,1,'Wisdom',8340000,76),
(115,331,1,'Skill Mastery',11000000,77),
(115,1364,1,'Eye of Pa\'agrio',11000000,77),
(115,1365,1,'Soul of Pa\'agrio',11000000,77),
(115,1366,1,'Seal of Despair',16000000,78),
(115,1415,1,'Pa\'agrio\'s Emblem',16000000,78),
(115,337,1,'Arcane Power',16000000,78),
(115,436,1,'Divine Lore',16000000,78),
(115,1462,1,'Seal of Blockade',80000000,79),
(115,1416,1,'Pa\'agrio\'s Fist',80000000,79),
(115,1414,1,'Victory of Pa\'agrio',80000000,79),
(115,1427,1,'Flames of Invincibility',150000000,80),
(116,935,1,'Sigil Mastery',8300000,76),
(116,329,1,'Health',12500000,76),
(116,328,1,'Wisdom',12500000,76),
(116,331,1,'Skill Mastery',14670000,77),
(116,1362,1,'Chant of Spirit',14670000,77),
(116,1363,1,'Chant of Victory',16000000,78),
(116,336,1,'Arcane Wisdom',16000000,78),
(116,436,1,'Divine Lore',16000000,78),
(116,1429,1,'Gate Chant',16000000,78),
(116,1461,1,'Chant of Protection',80000000,79),
(116,1413,1,'Magnus\' Chant',80000000,79),
(117,329,1,'Health',8340000,76),
(117,348,1,'Spoil Crush',8340000,76),
(117,328,1,'Wisdom',8340000,76),
(117,362,1,'Armor Crush',11000000,77),
(117,330,1,'Skill Mastery',11000000,77),
(117,340,1,'Riposte Stance',11000000,77),
(117,347,1,'Earthquake',16000000,78),
(117,339,1,'Parry Stance',16000000,78),
(117,430,1,'Master of Combat',16000000,78),
(117,440,1,'Braveheart',16000000,78),
(117,537,1,'Spoil Bomb',80000000,79),
(117,456,1,'Symbol of Resistance',150000000,80),
(118,329,1,'Health',10000000,76),
(118,328,1,'Wisdom',10000000,76),
(118,330,1,'Skill Mastery',12250000,77),
(118,340,1,'Riposte Stance',12250000,77),
(118,362,1,'Armor Crush',12250000,77),
(118,440,1,'Braveheart',16000000,78),
(118,347,1,'Earthquake',16000000,78),
(118,339,1,'Parry Stance',16000000,78),
(118,430,1,'Master of Combat',16000000,78),
(118,457,1,'Symbol of Honor',150000000,80),
(123,462,1,'Guilted Body',0,1),
(123,463,1,'Weapon Mastery',160,5),
(123,464,1,'Armor Mastery',160,5),
(123,468,1,'Fallen Attack',50,5),
(123,468,2,'Fallen Attack',50,5),
(123,468,3,'Fallen Attack',50,5),
(123,1431,1,'Fallen Arrow',80,5),
(123,1431,2,'Fallen Arrow',80,5),
(123,466,1,'Magic Immunity',160,5),
(123,467,1,'Soul Mastery',160,5),
(123,467,2,'Soul Mastery',790,10),
(123,1432,1,'Increase Power',790,10),
(123,466,2,'Magic Immunity',390,10),
(123,466,3,'Magic Immunity',390,10),
(123,1431,3,'Fallen Arrow',390,10),
(123,1431,4,'Fallen Arrow',390,10),
(123,468,4,'Fallen Attack',260,10),
(123,468,5,'Fallen Attack',260,10),
(123,468,6,'Fallen Attack',260,10),
(123,464,2,'Armor Mastery',390,10),
(123,464,3,'Armor Mastery',390,10),
(123,463,2,'Weapon Mastery',790,10),
(123,463,3,'Weapon Mastery',3300,15),
(123,464,4,'Armor Mastery',1700,15),
(123,464,5,'Armor Mastery',1700,15),
(123,468,7,'Fallen Attack',1100,15),
(123,468,8,'Fallen Attack',1100,15),
(123,468,9,'Fallen Attack',1100,15),
(123,1431,5,'Fallen Arrow',1700,15),
(123,1431,6,'Fallen Arrow',1700,15),
(123,466,4,'Magic Immunity',1700,15),
(123,466,5,'Magic Immunity',1700,15),
(123,467,3,'Soul Mastery',3300,15),
(124,462,1,'Guilted Body',0,1),
(124,463,1,'Weapon Mastery',160,5),
(124,464,1,'Armor Mastery',160,5),
(124,468,1,'Fallen Attack',50,5),
(124,468,2,'Fallen Attack',50,5),
(124,468,3,'Fallen Attack',50,5),
(124,1431,1,'Fallen Arrow',80,5),
(124,466,1,'Magic Immunity',160,5),
(124,467,1,'Soul Mastery',160,5),
(124,1431,2,'Fallen Arrow',80,5),
(124,1431,3,'Fallen Arrow',400,10),
(124,1431,4,'Fallen Arrow',400,10),
(124,467,2,'Soul Mastery',790,10),
(124,469,1,'Rapid Attack',790,10),
(124,466,2,'Magic Immunity',400,10),
(124,466,3,'Magic Immunity',400,10),
(124,468,4,'Fallen Attack',260,10),
(124,468,5,'Fallen Attack',260,10),
(124,468,6,'Fallen Attack',260,10),
(124,464,2,'Armor Mastery',400,10),
(124,464,3,'Armor Mastery',400,10),
(124,463,2,'Weapon Mastery',790,10),
(124,463,3,'Weapon Mastery',2500,15),
(124,464,4,'Armor Mastery',1250,15),
(124,464,5,'Armor Mastery',1250,15),
(124,468,7,'Fallen Attack',830,15),
(124,468,8,'Fallen Attack',830,15),
(124,468,9,'Fallen Attack',830,15),
(124,466,4,'Magic Immunity',1250,15),
(124,466,5,'Magic Immunity',1250,15),
(124,470,1,'Detect Trap',1250,15),
(124,471,1,'Defuse Trap',1250,15),
(124,467,3,'Soul Mastery',2500,15),
(124,1431,5,'Fallen Arrow',1250,15),
(124,1431,6,'Fallen Arrow',1250,15),
(125,465,1,'Light Armor Mastery',1800,20),
(125,465,2,'Light Armor Mastery',1800,20),
(125,466,6,'Magic Immunity',1800,20),
(125,466,7,'Magic Immunity',1800,20),
(125,472,1,'Ancient Sword Mastery',3700,20),
(125,474,1,'Rapier Mastery',4100,20),
(125,475,1,'Strike Back',3700,20),
(125,476,1,'Dark Strike',1200,20),
(125,476,2,'Dark Strike',1200,20),
(125,476,3,'Dark Strike',1200,20),
(125,478,1,'Double Thrust',1200,20),
(125,478,2,'Double Thrust',1200,20),
(125,478,3,'Double Thrust',1200,20),
(125,467,4,'Soul Mastery',3700,20),
(125,1433,1,'Abyssal Blaze',1800,20),
(125,1433,2,'Abyssal Blaze',1800,20),
(125,1473,1,'Change Weapon',3700,20),
(125,1475,1,'Erase Mark',5800,24),
(125,1435,1,'Death Mark',5800,24),
(125,1433,3,'Abyssal Blaze',2900,24),
(125,1433,4,'Abyssal Blaze',2900,24),
(125,1434,1,'Dark Explosion',5800,24),
(125,467,5,'Soul Mastery',5800,24),
(125,482,1,'Furious Soul',5800,24),
(125,478,4,'Double Thrust',1900,24),
(125,478,5,'Double Thrust',1900,24),
(125,478,6,'Double Thrust',1900,24),
(125,476,4,'Dark Strike',1900,24),
(125,476,5,'Dark Strike',1900,24),
(125,476,6,'Dark Strike',1900,24),
(125,474,2,'Rapier Mastery',5800,24),
(125,472,2,'Ancient Sword Mastery',5800,24),
(125,466,8,'Magic Immunity',2900,24),
(125,466,9,'Magic Immunity',2900,24),
(125,465,3,'Light Armor Mastery',2900,24),
(125,465,4,'Light Armor Mastery',2900,24),
(125,465,5,'Light Armor Mastery',3300,28),
(125,465,6,'Light Armor Mastery',3300,28),
(125,465,7,'Light Armor Mastery',3300,28),
(125,466,10,'Magic Immunity',3300,28),
(125,466,11,'Magic Immunity',3300,28),
(125,466,12,'Magic Immunity',3300,28),
(125,472,3,'Ancient Sword Mastery',5000,28),
(125,472,4,'Ancient Sword Mastery',5000,28),
(125,474,3,'Rapier Mastery',5000,28),
(125,474,4,'Rapier Mastery',5000,28),
(125,476,7,'Dark Strike',3300,28),
(125,476,8,'Dark Strike',3300,28),
(125,476,9,'Dark Strike',3300,28),
(125,478,7,'Double Thrust',3300,28),
(125,478,8,'Double Thrust',3300,28),
(125,478,9,'Double Thrust',3300,28),
(125,479,1,'Hard March',10000,28),
(125,467,6,'Soul Mastery',10000,28),
(125,1434,2,'Dark Explosion',10000,28),
(125,1432,2,'Increase Power',10000,28),
(125,1433,5,'Abyssal Blaze',5000,28),
(125,1433,6,'Abyssal Blaze',5000,28),
(125,1445,1,'Surrender to the Unholy',10000,28),
(125,1445,2,'Surrender to the Unholy',15300,32),
(125,1435,2,'Death Mark',15300,32),
(125,1433,7,'Abyssal Blaze',7700,32),
(125,1433,8,'Abyssal Blaze',7700,32),
(125,481,1,'Dark Armor',15300,32),
(125,484,1,'Rush',15300,32),
(125,1434,3,'Dark Explosion',15300,32),
(125,467,7,'Soul Mastery',15300,32),
(125,478,10,'Double Thrust',5000,32),
(125,478,11,'Double Thrust',5000,32),
(125,478,12,'Double Thrust',5000,32),
(125,476,10,'Dark Strike',5000,32),
(125,476,11,'Dark Strike',5000,32),
(125,476,12,'Dark Strike',5000,32),
(125,474,5,'Rapier Mastery',7700,32),
(125,474,6,'Rapier Mastery',7700,32),
(125,472,5,'Ancient Sword Mastery',7700,32),
(125,472,6,'Ancient Sword Mastery',7700,32),
(125,466,13,'Magic Immunity',5000,32),
(125,466,14,'Magic Immunity',5000,32),
(125,466,15,'Magic Immunity',5000,32),
(125,465,8,'Light Armor Mastery',5000,32),
(125,465,9,'Light Armor Mastery',5000,32),
(125,465,10,'Light Armor Mastery',5000,32),
(125,465,11,'Light Armor Mastery',7400,36),
(125,465,12,'Light Armor Mastery',7400,36),
(125,465,13,'Light Armor Mastery',7400,36),
(125,466,16,'Magic Immunity',7400,36),
(125,466,17,'Magic Immunity',7400,36),
(125,466,18,'Magic Immunity',7400,36),
(125,472,7,'Ancient Sword Mastery',11000,36),
(125,472,8,'Ancient Sword Mastery',11000,36),
(125,474,7,'Rapier Mastery',11000,36),
(125,474,8,'Rapier Mastery',11000,36),
(125,476,13,'Dark Strike',7400,36),
(125,476,14,'Dark Strike',7400,36),
(125,476,15,'Dark Strike',7400,36),
(125,478,13,'Double Thrust',7400,36),
(125,478,14,'Double Thrust',7400,36),
(125,478,15,'Double Thrust',7400,36),
(125,467,8,'Soul Mastery',22100,36),
(125,480,1,'Dark Blade',22100,36),
(125,483,1,'Sword Shield',22100,36),
(125,1434,4,'Dark Explosion',22100,36),
(125,485,1,'Disarm',22100,36),
(125,499,1,'Courage',22100,36),
(125,1433,9,'Abyssal Blaze',11000,36),
(125,1433,10,'Abyssal Blaze',11000,36),
(125,1445,3,'Surrender to the Unholy',22100,36),
(126,465,1,'Light Armor Mastery',2100,20),
(126,465,2,'Light Armor Mastery',2100,20),
(126,466,6,'Magic Immunity',2100,20),
(126,466,7,'Magic Immunity',2100,20),
(126,467,4,'Soul Mastery',4100,20),
(126,473,1,'Crossbow Mastery',4100,20),
(126,474,1,'Rapier Mastery',4100,20),
(126,478,1,'Double Thrust',1400,20),
(126,478,2,'Double Thrust',1400,20),
(126,478,3,'Double Thrust',1400,20),
(126,487,1,'Penetrating Shot',1400,20),
(126,487,2,'Penetrating Shot',1400,20),
(126,487,3,'Penetrating Shot',1400,20),
(126,1433,1,'Abyssal Blaze',2100,20),
(126,1433,2,'Abyssal Blaze',2100,20),
(126,1473,1,'Change Weapon',4100,20),
(126,482,1,'Furious Soul',2200,24),
(126,1475,1,'Erase Mark',4700,24),
(126,1433,3,'Abyssal Blaze',2300,24),
(126,1433,4,'Abyssal Blaze',2300,24),
(126,1434,1,'Dark Explosion',4700,24),
(126,1435,1,'Death Mark',4700,24),
(126,487,4,'Penetrating Shot',1600,24),
(126,487,5,'Penetrating Shot',1600,24),
(126,487,6,'Penetrating Shot',1600,24),
(126,479,1,'Hard March',4700,24),
(126,486,1,'Increase Range',4700,24),
(126,478,4,'Double Thrust',1600,24),
(126,478,5,'Double Thrust',1600,24),
(126,478,6,'Double Thrust',1600,24),
(126,474,2,'Rapier Mastery',4700,24),
(126,473,2,'Crossbow Mastery',4700,24),
(126,467,5,'Soul Mastery',4700,24),
(126,470,2,'Detect Trap',2300,24),
(126,471,2,'Defuse Trap',2300,24),
(126,466,8,'Magic Immunity',2300,24),
(126,466,9,'Magic Immunity',2300,24),
(126,465,3,'Light Armor Mastery',2300,24),
(126,465,4,'Light Armor Mastery',2300,24),
(126,465,5,'Light Armor Mastery',3600,28),
(126,465,6,'Light Armor Mastery',3600,28),
(126,465,7,'Light Armor Mastery',3600,28),
(126,466,10,'Magic Immunity',3600,28),
(126,466,11,'Magic Immunity',3600,28),
(126,466,12,'Magic Immunity',3600,28),
(126,467,6,'Soul Mastery',10900,28),
(126,473,3,'Crossbow Mastery',5500,28),
(126,473,4,'Crossbow Mastery',5500,28),
(126,474,3,'Rapier Mastery',5500,28),
(126,474,4,'Rapier Mastery',5500,28),
(126,478,7,'Double Thrust',3600,28),
(126,478,8,'Double Thrust',3600,28),
(126,478,9,'Double Thrust',3600,28),
(126,514,1,'Fire Trap',10900,28),
(126,487,7,'Penetrating Shot',3600,28),
(126,487,8,'Penetrating Shot',3600,28),
(126,487,9,'Penetrating Shot',3600,28),
(126,1434,2,'Dark Explosion',10900,28),
(126,1433,5,'Abyssal Blaze',5500,28),
(126,1433,6,'Abyssal Blaze',5500,28),
(126,1445,1,'Surrender to the Unholy',10900,28),
(126,1445,2,'Surrender to the Unholy',14300,32),
(126,1433,7,'Abyssal Blaze',7200,32),
(126,1433,8,'Abyssal Blaze',7200,32),
(126,1434,3,'Dark Explosion',14300,32),
(126,1435,2,'Death Mark',14300,32),
(126,490,1,'Fast Shot',14300,32),
(126,628,1,'Warp',14300,32),
(126,487,10,'Penetrating Shot',4800,32),
(126,487,11,'Penetrating Shot',4800,32),
(126,487,12,'Penetrating Shot',4800,32),
(126,481,1,'Dark Armor',14300,32),
(126,478,10,'Double Thrust',4800,32),
(126,478,11,'Double Thrust',4800,32),
(126,478,12,'Double Thrust',4800,32),
(126,474,5,'Rapier Mastery',7200,32),
(126,474,6,'Rapier Mastery',7200,32),
(126,473,5,'Crossbow Mastery',7200,32),
(126,473,6,'Crossbow Mastery',7200,32),
(126,467,7,'Soul Mastery',14300,32),
(126,466,13,'Magic Immunity',4800,32),
(126,466,14,'Magic Immunity',4800,32),
(126,466,15,'Magic Immunity',4800,32),
(126,465,8,'Light Armor Mastery',4800,32),
(126,465,9,'Light Armor Mastery',4800,32),
(126,465,10,'Light Armor Mastery',4800,32),
(126,622,1,'Ultimate Escape',19000,36),
(126,465,11,'Light Armor Mastery',6900,36),
(126,465,12,'Light Armor Mastery',6900,36),
(126,465,13,'Light Armor Mastery',6900,36),
(126,466,16,'Magic Immunity',6900,36),
(126,466,17,'Magic Immunity',6900,36),
(126,466,18,'Magic Immunity',6900,36),
(126,467,8,'Soul Mastery',20700,36),
(126,471,3,'Defuse Trap',10400,36),
(126,470,3,'Detect Trap',10400,36),
(126,473,7,'Crossbow Mastery',10400,36),
(126,473,8,'Crossbow Mastery',10400,36),
(126,474,7,'Rapier Mastery',10400,36),
(126,474,8,'Rapier Mastery',10400,36),
(126,478,13,'Double Thrust',6900,36),
(126,478,14,'Double Thrust',6900,36),
(126,478,15,'Double Thrust',6900,36),
(126,480,1,'Dark Blade',20700,36),
(126,514,2,'Fire Trap',20700,36),
(126,627,1,'Soul Shock',6900,36),
(126,627,2,'Soul Shock',6900,36),
(126,627,3,'Soul Shock',6900,36),
(126,487,13,'Penetrating Shot',6900,36),
(126,487,14,'Penetrating Shot',6900,36),
(126,487,15,'Penetrating Shot',6900,36),
(126,1434,4,'Dark Explosion',20700,36),
(126,1433,9,'Abyssal Blaze',10400,36),
(126,1433,10,'Abyssal Blaze',10400,36),
(126,1445,3,'Surrender to the Unholy',20700,36),
(127,465,14,'Light Armor Mastery',14000,40),
(127,465,15,'Light Armor Mastery',14000,40),
(127,465,16,'Light Armor Mastery',14000,40),
(127,466,19,'Magic Immunity',14000,40),
(127,466,20,'Magic Immunity',14000,40),
(127,466,21,'Magic Immunity',14000,40),
(127,472,9,'Ancient Sword Mastery',14000,40),
(127,472,10,'Ancient Sword Mastery',14000,40),
(127,472,11,'Ancient Sword Mastery',14000,40),
(127,477,1,'Dark Smash',14000,40),
(127,477,2,'Dark Smash',14000,40),
(127,477,3,'Dark Smash',14000,40),
(127,467,9,'Soul Mastery',46000,40),
(127,494,1,'Shoulder Charge',14000,40),
(127,494,2,'Shoulder Charge',14000,40),
(127,494,3,'Shoulder Charge',14000,40),
(127,500,1,'True Berserker',46000,40),
(127,502,1,'Life to Soul',46000,40),
(127,832,1,'Fast Recovery',49000,43),
(127,626,1,'Critical Sense',49000,43),
(127,503,1,'Scorn',49000,43),
(127,494,4,'Shoulder Charge',16000,43),
(127,494,5,'Shoulder Charge',16000,43),
(127,494,6,'Shoulder Charge',16000,43),
(127,467,10,'Soul Mastery',49000,43),
(127,481,2,'Dark Armor',49000,43),
(127,485,2,'Disarm',49000,43),
(127,477,4,'Dark Smash',16000,43),
(127,477,5,'Dark Smash',16000,43),
(127,477,6,'Dark Smash',16000,43),
(127,472,12,'Ancient Sword Mastery',16000,43),
(127,472,13,'Ancient Sword Mastery',16000,43),
(127,472,14,'Ancient Sword Mastery',16000,43),
(127,466,22,'Magic Immunity',16000,43),
(127,466,23,'Magic Immunity',16000,43),
(127,466,24,'Magic Immunity',16000,43),
(127,465,17,'Light Armor Mastery',16000,43),
(127,465,18,'Light Armor Mastery',16000,43),
(127,465,19,'Light Armor Mastery',16000,43),
(127,625,1,'Soul Gathering',75000,46),
(127,465,20,'Light Armor Mastery',25000,46),
(127,465,21,'Light Armor Mastery',25000,46),
(127,465,22,'Light Armor Mastery',25000,46),
(127,466,25,'Magic Immunity',25000,46),
(127,466,26,'Magic Immunity',25000,46),
(127,466,27,'Magic Immunity',25000,46),
(127,472,15,'Ancient Sword Mastery',25000,46),
(127,472,16,'Ancient Sword Mastery',25000,46),
(127,472,17,'Ancient Sword Mastery',25000,46),
(127,477,7,'Dark Smash',25000,46),
(127,477,8,'Dark Smash',25000,46),
(127,477,9,'Dark Smash',25000,46),
(127,467,11,'Soul Mastery',75000,46),
(127,494,7,'Shoulder Charge',25000,46),
(127,494,8,'Shoulder Charge',25000,46),
(127,494,9,'Shoulder Charge',25000,46),
(127,496,1,'Slashing Blade',25000,46),
(127,496,2,'Slashing Blade',25000,46),
(127,496,3,'Slashing Blade',25000,46),
(127,467,1,'Soul Mastery',75000,46),
(127,502,2,'Life to Soul',82000,49),
(127,499,2,'Courage',82000,49),
(127,501,1,'Violent Temper',82000,49),
(127,496,4,'Slashing Blade',27000,49),
(127,496,5,'Slashing Blade',27000,49),
(127,496,6,'Slashing Blade',27000,49),
(127,493,1,'Storm Assault',27000,49),
(127,493,2,'Storm Assault',27000,49),
(127,493,3,'Storm Assault',27000,49),
(127,494,10,'Shoulder Charge',27000,49),
(127,494,11,'Shoulder Charge',27000,49),
(127,494,12,'Shoulder Charge',27000,49),
(127,467,12,'Soul Mastery',82000,49),
(127,485,3,'Disarm',82000,49),
(127,477,10,'Dark Smash',27000,49),
(127,477,11,'Dark Smash',27000,49),
(127,477,12,'Dark Smash',27000,49),
(127,472,18,'Ancient Sword Mastery',27000,49),
(127,472,19,'Ancient Sword Mastery',27000,49),
(127,472,20,'Ancient Sword Mastery',27000,49),
(127,466,28,'Magic Immunity',27000,49),
(127,466,29,'Magic Immunity',27000,49),
(127,466,30,'Magic Immunity',27000,49),
(127,465,23,'Light Armor Mastery',27000,49),
(127,465,24,'Light Armor Mastery',27000,49),
(127,465,25,'Light Armor Mastery',27000,49),
(127,833,1,'Body Reconstruction',107000,52),
(127,465,26,'Light Armor Mastery',36000,52),
(127,465,27,'Light Armor Mastery',36000,52),
(127,465,28,'Light Armor Mastery',36000,52),
(127,466,31,'Magic Immunity',36000,52),
(127,466,32,'Magic Immunity',36000,52),
(127,466,33,'Magic Immunity',36000,52),
(127,472,21,'Ancient Sword Mastery',36000,52),
(127,472,22,'Ancient Sword Mastery',36000,52),
(127,472,23,'Ancient Sword Mastery',36000,52),
(127,477,13,'Dark Smash',36000,52),
(127,477,14,'Dark Smash',36000,52),
(127,477,15,'Dark Smash',36000,52),
(127,467,13,'Soul Mastery',107000,52),
(127,492,1,'Spread Wing',36000,52),
(127,492,2,'Spread Wing',36000,52),
(127,492,3,'Spread Wing',36000,52),
(127,494,13,'Shoulder Charge',36000,52),
(127,494,14,'Shoulder Charge',36000,52),
(127,494,15,'Shoulder Charge',36000,52),
(127,493,4,'Storm Assault',36000,52),
(127,493,5,'Storm Assault',36000,52),
(127,493,6,'Storm Assault',36000,52),
(127,496,7,'Slashing Blade',36000,52),
(127,496,8,'Slashing Blade',36000,52),
(127,496,9,'Slashing Blade',36000,52),
(127,501,2,'Violent Temper',107000,52),
(127,500,2,'True Berserker',107000,52),
(127,483,2,'Sword Shield',107000,52),
(127,626,2,'Critical Sense',107000,52),
(127,834,1,'Blood Pact',147000,55),
(127,503,2,'Scorn',147000,55),
(127,501,3,'Violent Temper',147000,55),
(127,496,10,'Slashing Blade',49000,55),
(127,496,11,'Slashing Blade',49000,55),
(127,496,12,'Slashing Blade',49000,55),
(127,493,7,'Storm Assault',49000,55),
(127,493,8,'Storm Assault',49000,55),
(127,493,9,'Storm Assault',49000,55),
(127,495,1,'Blade Rush',147000,55),
(127,494,16,'Shoulder Charge',49000,55),
(127,494,17,'Shoulder Charge',49000,55),
(127,494,18,'Shoulder Charge',49000,55),
(127,492,4,'Spread Wing',49000,55),
(127,492,5,'Spread Wing',49000,55),
(127,492,6,'Spread Wing',49000,55),
(127,467,14,'Soul Mastery',147000,55),
(127,485,4,'Disarm',147000,55),
(127,482,2,'Furious Soul',147000,55),
(127,477,16,'Dark Smash',49000,55),
(127,477,17,'Dark Smash',49000,55),
(127,477,18,'Dark Smash',49000,55),
(127,472,24,'Ancient Sword Mastery',49000,55),
(127,472,25,'Ancient Sword Mastery',49000,55),
(127,472,26,'Ancient Sword Mastery',49000,55),
(127,466,34,'Magic Immunity',49000,55),
(127,466,35,'Magic Immunity',49000,55),
(127,466,36,'Magic Immunity',49000,55),
(127,465,29,'Light Armor Mastery',49000,55),
(127,465,30,'Light Armor Mastery',49000,55),
(127,465,31,'Light Armor Mastery',49000,55),
(127,465,32,'Light Armor Mastery',62000,58),
(127,465,33,'Light Armor Mastery',62000,58),
(127,465,34,'Light Armor Mastery',62000,58),
(127,466,37,'Magic Immunity',62000,58),
(127,466,38,'Magic Immunity',62000,58),
(127,466,39,'Magic Immunity',62000,58),
(127,472,27,'Ancient Sword Mastery',62000,58),
(127,472,28,'Ancient Sword Mastery',62000,58),
(127,472,29,'Ancient Sword Mastery',62000,58),
(127,477,19,'Dark Smash',62000,58),
(127,477,20,'Dark Smash',62000,58),
(127,477,21,'Dark Smash',62000,58),
(127,1514,1,'Soul Barrier',185000,58),
(127,467,15,'Soul Mastery',185000,58),
(127,492,7,'Spread Wing',62000,58),
(127,492,8,'Spread Wing',62000,58),
(127,492,9,'Spread Wing',62000,58),
(127,494,19,'Shoulder Charge',62000,58),
(127,494,20,'Shoulder Charge',62000,58),
(127,494,21,'Shoulder Charge',62000,58),
(127,495,2,'Blade Rush',185000,58),
(127,493,10,'Storm Assault',62000,58),
(127,493,11,'Storm Assault',62000,58),
(127,493,12,'Storm Assault',62000,58),
(127,496,13,'Slashing Blade',62000,58),
(127,496,14,'Slashing Blade',62000,58),
(127,496,15,'Slashing Blade',62000,58),
(127,501,4,'Violent Temper',185000,58),
(127,502,3,'Life to Soul',185000,58),
(127,501,5,'Violent Temper',223000,60),
(127,626,3,'Critical Sense',223000,60),
(127,496,16,'Slashing Blade',112000,60),
(127,496,17,'Slashing Blade',112000,60),
(127,493,13,'Storm Assault',112000,60),
(127,493,14,'Storm Assault',112000,60),
(127,495,3,'Blade Rush',223000,60),
(127,497,1,'Crushing Pain',112000,60),
(127,497,2,'Crushing Pain',112000,60),
(127,494,22,'Shoulder Charge',112000,60),
(127,494,23,'Shoulder Charge',112000,60),
(127,492,10,'Spread Wing',112000,60),
(127,492,11,'Spread Wing',112000,60),
(127,467,16,'Soul Mastery',223000,60),
(127,477,22,'Dark Smash',112000,60),
(127,477,23,'Dark Smash',112000,60),
(127,472,30,'Ancient Sword Mastery',112000,60),
(127,472,31,'Ancient Sword Mastery',112000,60),
(127,466,40,'Magic Immunity',112000,60),
(127,466,41,'Magic Immunity',112000,60),
(127,465,35,'Light Armor Mastery',112000,60),
(127,465,36,'Light Armor Mastery',112000,60),
(127,465,37,'Light Armor Mastery',140000,62),
(127,465,38,'Light Armor Mastery',140000,62),
(127,466,42,'Magic Immunity',140000,62),
(127,466,43,'Magic Immunity',140000,62),
(127,472,32,'Ancient Sword Mastery',140000,62),
(127,472,33,'Ancient Sword Mastery',140000,62),
(127,477,24,'Dark Smash',140000,62),
(127,477,25,'Dark Smash',140000,62),
(127,467,17,'Soul Mastery',290000,62),
(127,485,5,'Disarm',290000,62),
(127,492,12,'Spread Wing',140000,62),
(127,492,13,'Spread Wing',140000,62),
(127,494,24,'Shoulder Charge',140000,62),
(127,494,25,'Shoulder Charge',140000,62),
(127,497,3,'Crushing Pain',140000,62),
(127,497,4,'Crushing Pain',140000,62),
(127,495,4,'Blade Rush',290000,62),
(127,493,15,'Storm Assault',140000,62),
(127,493,16,'Storm Assault',140000,62),
(127,496,18,'Slashing Blade',140000,62),
(127,496,19,'Slashing Blade',140000,62),
(127,501,6,'Violent Temper',290000,62),
(127,499,3,'Courage',290000,62),
(127,501,7,'Violent Temper',340000,64),
(127,503,3,'Scorn',340000,64),
(127,496,20,'Slashing Blade',170000,64),
(127,496,21,'Slashing Blade',170000,64),
(127,493,17,'Storm Assault',170000,64),
(127,493,18,'Storm Assault',170000,64),
(127,495,5,'Blade Rush',340000,64),
(127,498,1,'Contagion',170000,64),
(127,498,2,'Contagion',170000,64),
(127,497,5,'Crushing Pain',170000,64),
(127,497,6,'Crushing Pain',170000,64),
(127,494,26,'Shoulder Charge',170000,64),
(127,494,27,'Shoulder Charge',170000,64),
(127,492,14,'Spread Wing',170000,64),
(127,492,15,'Spread Wing',170000,64),
(127,467,18,'Soul Mastery',340000,64),
(127,477,26,'Dark Smash',170000,64),
(127,477,27,'Dark Smash',170000,64),
(127,472,34,'Ancient Sword Mastery',170000,64),
(127,472,35,'Ancient Sword Mastery',170000,64),
(127,466,44,'Magic Immunity',170000,64),
(127,466,45,'Magic Immunity',170000,64),
(127,465,39,'Light Armor Mastery',170000,64),
(127,465,40,'Light Armor Mastery',170000,64),
(127,465,41,'Light Armor Mastery',220000,66),
(127,465,42,'Light Armor Mastery',220000,66),
(127,466,46,'Magic Immunity',220000,66),
(127,466,47,'Magic Immunity',220000,66),
(127,472,36,'Ancient Sword Mastery',220000,66),
(127,472,37,'Ancient Sword Mastery',220000,66),
(127,477,28,'Dark Smash',220000,66),
(127,477,29,'Dark Smash',220000,66),
(127,467,19,'Soul Mastery',440000,66),
(127,1510,1,'Soul Cleanse',440000,66),
(127,492,16,'Spread Wing',220000,66),
(127,492,17,'Spread Wing',220000,66),
(127,494,28,'Shoulder Charge',220000,66),
(127,494,29,'Shoulder Charge',220000,66),
(127,497,7,'Crushing Pain',220000,66),
(127,497,8,'Crushing Pain',220000,66),
(127,498,3,'Contagion',220000,66),
(127,498,4,'Contagion',220000,66),
(127,495,6,'Blade Rush',440000,66),
(127,493,19,'Storm Assault',220000,66),
(127,493,20,'Storm Assault',220000,66),
(127,496,22,'Slashing Blade',220000,66),
(127,496,23,'Slashing Blade',220000,66),
(127,626,4,'Critical Sense',440000,66),
(127,501,8,'Violent Temper',440000,66),
(127,502,4,'Life to Soul',440000,66),
(127,501,9,'Violent Temper',560000,68),
(127,496,24,'Slashing Blade',280000,68),
(127,496,25,'Slashing Blade',280000,68),
(127,493,21,'Storm Assault',280000,68),
(127,493,22,'Storm Assault',280000,68),
(127,495,7,'Blade Rush',560000,68),
(127,498,5,'Contagion',280000,68),
(127,498,6,'Contagion',280000,68),
(127,497,9,'Crushing Pain',280000,68),
(127,497,10,'Crushing Pain',280000,68),
(127,494,30,'Shoulder Charge',280000,68),
(127,494,31,'Shoulder Charge',280000,68),
(127,492,18,'Spread Wing',280000,68),
(127,492,19,'Spread Wing',280000,68),
(127,485,6,'Disarm',560000,68),
(127,467,20,'Soul Mastery',560000,68),
(127,477,30,'Dark Smash',280000,68),
(127,477,31,'Dark Smash',280000,68),
(127,472,38,'Ancient Sword Mastery',280000,68),
(127,472,39,'Ancient Sword Mastery',280000,68),
(127,466,48,'Magic Immunity',280000,68),
(127,466,49,'Magic Immunity',280000,68),
(127,465,43,'Light Armor Mastery',280000,68),
(127,465,44,'Light Armor Mastery',280000,68),
(127,465,45,'Light Armor Mastery',360000,70),
(127,465,46,'Light Armor Mastery',360000,70),
(127,466,50,'Magic Immunity',360000,70),
(127,466,51,'Magic Immunity',360000,70),
(127,472,40,'Ancient Sword Mastery',360000,70),
(127,472,41,'Ancient Sword Mastery',360000,70),
(127,477,32,'Dark Smash',360000,70),
(127,477,33,'Dark Smash',360000,70),
(127,467,21,'Soul Mastery',720000,70),
(127,492,20,'Spread Wing',360000,70),
(127,492,21,'Spread Wing',360000,70),
(127,494,32,'Shoulder Charge',360000,70),
(127,494,33,'Shoulder Charge',360000,70),
(127,497,11,'Crushing Pain',360000,70),
(127,497,12,'Crushing Pain',360000,70),
(127,498,7,'Contagion',360000,70),
(127,498,8,'Contagion',360000,70),
(127,495,8,'Blade Rush',720000,70),
(127,493,23,'Storm Assault',360000,70),
(127,493,24,'Storm Assault',360000,70),
(127,496,26,'Slashing Blade',360000,70),
(127,496,27,'Slashing Blade',360000,70),
(127,501,10,'Violent Temper',720000,70),
(127,501,11,'Violent Temper',860000,72),
(127,502,5,'Life to Soul',860000,72),
(127,496,28,'Slashing Blade',430000,72),
(127,496,29,'Slashing Blade',430000,72),
(127,493,25,'Storm Assault',430000,72),
(127,493,26,'Storm Assault',430000,72),
(127,495,9,'Blade Rush',860000,72),
(127,498,9,'Contagion',430000,72),
(127,498,10,'Contagion',430000,72),
(127,497,13,'Crushing Pain',430000,72),
(127,497,14,'Crushing Pain',430000,72),
(127,494,34,'Shoulder Charge',430000,72),
(127,494,35,'Shoulder Charge',430000,72),
(127,492,22,'Spread Wing',430000,72),
(127,492,23,'Spread Wing',430000,72),
(127,467,22,'Soul Mastery',860000,72),
(127,477,34,'Dark Smash',430000,72),
(127,477,35,'Dark Smash',430000,72),
(127,472,42,'Ancient Sword Mastery',430000,72),
(127,472,43,'Ancient Sword Mastery',430000,72),
(127,466,52,'Magic Immunity',430000,72),
(127,466,53,'Magic Immunity',430000,72),
(127,465,47,'Light Armor Mastery',430000,72),
(127,465,48,'Light Armor Mastery',430000,72),
(127,465,49,'Light Armor Mastery',930000,74),
(127,465,50,'Light Armor Mastery',930000,74),
(127,466,54,'Magic Immunity',930000,74),
(127,466,55,'Magic Immunity',930000,74),
(127,472,44,'Ancient Sword Mastery',930000,74),
(127,472,45,'Ancient Sword Mastery',930000,74),
(127,477,36,'Dark Smash',930000,74),
(127,477,37,'Dark Smash',930000,74),
(127,467,23,'Soul Mastery',1900000,74),
(127,485,7,'Disarm',1900000,74),
(127,492,24,'Spread Wing',930000,74),
(127,492,25,'Spread Wing',930000,74),
(127,494,36,'Shoulder Charge',930000,74),
(127,494,37,'Shoulder Charge',930000,74),
(127,497,15,'Crushing Pain',930000,74),
(127,497,16,'Crushing Pain',930000,74),
(127,498,11,'Contagion',930000,74),
(127,498,12,'Contagion',930000,74),
(127,495,10,'Blade Rush',1900000,74),
(127,493,27,'Storm Assault',930000,74),
(127,493,28,'Storm Assault',930000,74),
(127,496,30,'Slashing Blade',930000,74),
(127,496,31,'Slashing Blade',930000,74),
(127,501,12,'Violent Temper',1900000,74),
(128,1527,1,'Expert Casting',38000,40),
(128,465,14,'Light Armor Mastery',12000,40),
(128,465,15,'Light Armor Mastery',12000,40),
(128,465,16,'Light Armor Mastery',12000,40),
(128,466,19,'Magic Immunity',12000,40),
(128,466,20,'Magic Immunity',12000,40),
(128,466,21,'Magic Immunity',12000,40),
(128,474,9,'Rapier Mastery',12000,40),
(128,474,10,'Rapier Mastery',12000,40),
(128,474,11,'Rapier Mastery',12000,40),
(128,504,1,'Triple Thrust',12000,40),
(128,504,2,'Triple Thrust',12000,40),
(128,504,3,'Triple Thrust',12000,40),
(128,467,9,'Soul Mastery',38000,40),
(128,502,1,'Life to Soul',38000,40),
(128,1436,1,'Soul of Pain',19000,40),
(128,1436,2,'Soul of Pain',19000,40),
(128,1435,3,'Death Mark',38000,40),
(128,1445,4,'Surrender to the Unholy',38000,40),
(128,832,1,'Fast Recovery',39000,43),
(128,1445,5,'Surrender to the Unholy',39000,43),
(128,1474,1,'Abyssal Power',39000,43),
(128,626,1,'Critical Sense',39000,43),
(128,1441,1,'Soul to Empower',39000,43),
(128,1436,3,'Soul of Pain',20000,43),
(128,1436,4,'Soul of Pain',20000,43),
(128,467,10,'Soul Mastery',39000,43),
(128,481,2,'Dark Armor',39000,43),
(128,504,4,'Triple Thrust',13000,43),
(128,504,5,'Triple Thrust',13000,43),
(128,504,6,'Triple Thrust',13000,43),
(128,474,12,'Rapier Mastery',13000,43),
(128,474,13,'Rapier Mastery',13000,43),
(128,474,14,'Rapier Mastery',13000,43),
(128,466,22,'Magic Immunity',13000,43),
(128,466,23,'Magic Immunity',13000,43),
(128,466,24,'Magic Immunity',13000,43),
(128,465,17,'Light Armor Mastery',13000,43),
(128,465,18,'Light Armor Mastery',13000,43),
(128,465,19,'Light Armor Mastery',13000,43),
(128,625,1,'Soul Gathering',50000,46),
(128,465,20,'Light Armor Mastery',17000,46),
(128,465,21,'Light Armor Mastery',17000,46),
(128,465,22,'Light Armor Mastery',17000,46),
(128,466,25,'Magic Immunity',17000,46),
(128,466,26,'Magic Immunity',17000,46),
(128,466,27,'Magic Immunity',17000,46),
(128,474,15,'Rapier Mastery',17000,46),
(128,474,16,'Rapier Mastery',17000,46),
(128,474,17,'Rapier Mastery',17000,46),
(128,504,7,'Triple Thrust',17000,46),
(128,504,8,'Triple Thrust',17000,46),
(128,504,9,'Triple Thrust',17000,46),
(128,467,11,'Soul Mastery',50000,46),
(128,1436,5,'Soul of Pain',25000,46),
(128,1436,6,'Soul of Pain',25000,46),
(128,1475,2,'Erase Mark',50000,46),
(128,1443,1,'Dark Weapon',50000,46),
(128,1445,6,'Surrender to the Unholy',50000,46),
(128,1435,4,'Death Mark',50000,46),
(128,1437,1,'Dark Flame',25000,46),
(128,1437,2,'Dark Flame',25000,46),
(128,467,1,'Soul Mastery',50000,46),
(128,1437,3,'Dark Flame',45000,49),
(128,1437,4,'Dark Flame',45000,49),
(128,1445,7,'Surrender to the Unholy',89000,49),
(128,1444,1,'Pride of Kamael',89000,49),
(128,1436,7,'Soul of Pain',45000,49),
(128,1436,8,'Soul of Pain',45000,49),
(128,467,12,'Soul Mastery',89000,49),
(128,502,2,'Life to Soul',89000,49),
(128,505,1,'Shining Edge',30000,49),
(128,505,2,'Shining Edge',30000,49),
(128,505,3,'Shining Edge',30000,49),
(128,504,10,'Triple Thrust',30000,49),
(128,504,11,'Triple Thrust',30000,49),
(128,504,12,'Triple Thrust',30000,49),
(128,474,18,'Rapier Mastery',30000,49),
(128,474,19,'Rapier Mastery',30000,49),
(128,474,20,'Rapier Mastery',30000,49),
(128,466,28,'Magic Immunity',30000,49),
(128,466,29,'Magic Immunity',30000,49),
(128,466,30,'Magic Immunity',30000,49),
(128,465,23,'Light Armor Mastery',30000,49),
(128,465,24,'Light Armor Mastery',30000,49),
(128,465,25,'Light Armor Mastery',30000,49),
(128,465,26,'Light Armor Mastery',36000,52),
(128,465,27,'Light Armor Mastery',36000,52),
(128,465,28,'Light Armor Mastery',36000,52),
(128,466,31,'Magic Immunity',36000,52),
(128,466,32,'Magic Immunity',36000,52),
(128,466,33,'Magic Immunity',36000,52),
(128,474,21,'Rapier Mastery',36000,52),
(128,474,22,'Rapier Mastery',36000,52),
(128,474,23,'Rapier Mastery',36000,52),
(128,504,13,'Triple Thrust',36000,52),
(128,504,14,'Triple Thrust',36000,52),
(128,504,15,'Triple Thrust',36000,52),
(128,505,4,'Shining Edge',36000,52),
(128,505,5,'Shining Edge',36000,52),
(128,505,6,'Shining Edge',36000,52),
(128,492,1,'Spread Wing',36000,52),
(128,492,2,'Spread Wing',36000,52),
(128,492,3,'Spread Wing',36000,52),
(128,506,1,'Checkmate',107000,52),
(128,467,13,'Soul Mastery',107000,52),
(128,1436,9,'Soul of Pain',54000,52),
(128,1436,10,'Soul of Pain',54000,52),
(128,1446,1,'Shadow Bind',107000,52),
(128,1445,8,'Surrender to the Unholy',107000,52),
(128,626,2,'Critical Sense',107000,52),
(128,1437,5,'Dark Flame',54000,52),
(128,1437,6,'Dark Flame',54000,52),
(128,1435,5,'Death Mark',107000,52),
(128,1437,7,'Dark Flame',71000,55),
(128,1437,8,'Dark Flame',71000,55),
(128,1441,2,'Soul to Empower',141000,55),
(128,1440,1,'Steal Divinity',141000,55),
(128,1446,2,'Shadow Bind',141000,55),
(128,1445,9,'Surrender to the Unholy',141000,55),
(128,1436,11,'Soul of Pain',71000,55),
(128,1436,12,'Soul of Pain',71000,55),
(128,467,14,'Soul Mastery',141000,55),
(128,492,4,'Spread Wing',41000,55),
(128,492,5,'Spread Wing',41000,55),
(128,492,6,'Spread Wing',41000,55),
(128,505,7,'Shining Edge',41000,55),
(128,505,8,'Shining Edge',41000,55),
(128,505,9,'Shining Edge',41000,55),
(128,504,16,'Triple Thrust',41000,55),
(128,504,17,'Triple Thrust',41000,55),
(128,504,18,'Triple Thrust',41000,55),
(128,474,24,'Rapier Mastery',41000,55),
(128,474,25,'Rapier Mastery',41000,55),
(128,474,26,'Rapier Mastery',41000,55),
(128,466,34,'Magic Immunity',41000,55),
(128,466,35,'Magic Immunity',41000,55),
(128,466,36,'Magic Immunity',41000,55),
(128,465,29,'Light Armor Mastery',41000,55),
(128,465,30,'Light Armor Mastery',41000,55),
(128,465,31,'Light Armor Mastery',41000,55),
(128,837,1,'Painkiller',169000,58),
(128,465,32,'Light Armor Mastery',56000,58),
(128,465,33,'Light Armor Mastery',56000,58),
(128,465,34,'Light Armor Mastery',56000,58),
(128,466,37,'Magic Immunity',56000,58),
(128,466,38,'Magic Immunity',56000,58),
(128,466,39,'Magic Immunity',56000,58),
(128,474,27,'Rapier Mastery',56000,58),
(128,474,28,'Rapier Mastery',56000,58),
(128,474,29,'Rapier Mastery',56000,58),
(128,504,19,'Triple Thrust',56000,58),
(128,504,20,'Triple Thrust',56000,58),
(128,504,21,'Triple Thrust',56000,58),
(128,505,10,'Shining Edge',56000,58),
(128,505,11,'Shining Edge',56000,58),
(128,505,12,'Shining Edge',56000,58),
(128,492,7,'Spread Wing',56000,58),
(128,492,8,'Spread Wing',56000,58),
(128,492,9,'Spread Wing',56000,58),
(128,1446,3,'Shadow Bind',169000,58),
(128,467,15,'Soul Mastery',169000,58),
(128,502,3,'Life to Soul',169000,58),
(128,1436,13,'Soul of Pain',85000,58),
(128,1436,14,'Soul of Pain',85000,58),
(128,1445,10,'Surrender to the Unholy',169000,58),
(128,1447,1,'Voice Bind',169000,58),
(128,1442,1,'Protection from Darkness',169000,58),
(128,1437,9,'Dark Flame',85000,58),
(128,1437,10,'Dark Flame',85000,58),
(128,1435,6,'Death Mark',169000,58),
(128,1438,1,'Annihilation Circle',169000,58),
(128,1438,2,'Annihilation Circle',161000,60),
(128,1437,11,'Dark Flame',81000,60),
(128,1437,12,'Dark Flame',81000,60),
(128,1440,2,'Steal Divinity',161000,60),
(128,626,3,'Critical Sense',161000,60),
(128,1448,1,'Blink',161000,60),
(128,1511,1,'Curse of Life Flow',161000,60),
(128,1446,4,'Shadow Bind',161000,60),
(128,1445,11,'Surrender to the Unholy',161000,60),
(128,1447,2,'Voice Bind',161000,60),
(128,1436,15,'Soul of Pain',81000,60),
(128,1436,16,'Soul of Pain',81000,60),
(128,506,2,'Checkmate',161000,60),
(128,467,16,'Soul Mastery',161000,60),
(128,492,10,'Spread Wing',81000,60),
(128,492,11,'Spread Wing',81000,60),
(128,505,13,'Shining Edge',81000,60),
(128,505,14,'Shining Edge',81000,60),
(128,504,22,'Triple Thrust',81000,60),
(128,504,23,'Triple Thrust',81000,60),
(128,474,30,'Rapier Mastery',81000,60),
(128,474,31,'Rapier Mastery',81000,60),
(128,466,40,'Magic Immunity',81000,60),
(128,466,41,'Magic Immunity',81000,60),
(128,465,35,'Light Armor Mastery',81000,60),
(128,465,36,'Light Armor Mastery',81000,60),
(128,1511,2,'Curse of Life Flow',250000,62),
(128,1529,1,'Soul Web',250000,62),
(128,465,37,'Light Armor Mastery',130000,62),
(128,465,38,'Light Armor Mastery',130000,62),
(128,466,42,'Magic Immunity',130000,62),
(128,466,43,'Magic Immunity',130000,62),
(128,474,32,'Rapier Mastery',130000,62),
(128,474,33,'Rapier Mastery',130000,62),
(128,504,24,'Triple Thrust',130000,62),
(128,504,25,'Triple Thrust',130000,62),
(128,505,15,'Shining Edge',130000,62),
(128,505,16,'Shining Edge',130000,62),
(128,492,12,'Spread Wing',130000,62),
(128,492,13,'Spread Wing',130000,62),
(128,467,17,'Soul Mastery',250000,62),
(128,1436,17,'Soul of Pain',130000,62),
(128,1436,18,'Soul of Pain',130000,62),
(128,1445,12,'Surrender to the Unholy',250000,62),
(128,1447,3,'Voice Bind',250000,62),
(128,1446,5,'Shadow Bind',250000,62),
(128,1437,13,'Dark Flame',130000,62),
(128,1437,14,'Dark Flame',130000,62),
(128,1438,3,'Annihilation Circle',250000,62),
(128,1435,7,'Death Mark',250000,62),
(128,1511,3,'Curse of Life Flow',300000,64),
(128,1529,2,'Soul Web',300000,64),
(128,1438,4,'Annihilation Circle',300000,64),
(128,1437,15,'Dark Flame',150000,64),
(128,1437,16,'Dark Flame',150000,64),
(128,1445,13,'Surrender to the Unholy',300000,64),
(128,1447,4,'Voice Bind',300000,64),
(128,1446,6,'Shadow Bind',300000,64),
(128,1440,3,'Steal Divinity',300000,64),
(128,1436,19,'Soul of Pain',150000,64),
(128,1436,20,'Soul of Pain',150000,64),
(128,467,18,'Soul Mastery',300000,64),
(128,492,14,'Spread Wing',150000,64),
(128,492,15,'Spread Wing',150000,64),
(128,505,17,'Shining Edge',150000,64),
(128,505,18,'Shining Edge',150000,64),
(128,504,26,'Triple Thrust',150000,64),
(128,504,27,'Triple Thrust',150000,64),
(128,474,34,'Rapier Mastery',150000,64),
(128,474,35,'Rapier Mastery',150000,64),
(128,466,44,'Magic Immunity',150000,64),
(128,466,45,'Magic Immunity',150000,64),
(128,465,39,'Light Armor Mastery',150000,64),
(128,465,40,'Light Armor Mastery',150000,64),
(128,1511,4,'Curse of Life Flow',310000,66),
(128,1529,3,'Soul Web',310000,66),
(128,465,41,'Light Armor Mastery',160000,66),
(128,465,42,'Light Armor Mastery',160000,66),
(128,466,46,'Magic Immunity',160000,66),
(128,466,47,'Magic Immunity',160000,66),
(128,474,36,'Rapier Mastery',160000,66),
(128,474,37,'Rapier Mastery',160000,66),
(128,504,28,'Triple Thrust',160000,66),
(128,504,29,'Triple Thrust',160000,66),
(128,505,19,'Shining Edge',160000,66),
(128,505,20,'Shining Edge',160000,66),
(128,492,16,'Spread Wing',160000,66),
(128,492,17,'Spread Wing',160000,66),
(128,467,19,'Soul Mastery',310000,66),
(128,1447,5,'Voice Bind',310000,66),
(128,506,3,'Checkmate',310000,66),
(128,502,4,'Life to Soul',310000,66),
(128,1436,21,'Soul of Pain',160000,66),
(128,1436,22,'Soul of Pain',160000,66),
(128,1442,2,'Protection from Darkness',310000,66),
(128,626,4,'Critical Sense',310000,66),
(128,1439,1,'Curse of Divinity',310000,66),
(128,1445,14,'Surrender to the Unholy',310000,66),
(128,1446,7,'Shadow Bind',310000,66),
(128,1510,1,'Soul Cleanse',310000,66),
(128,1475,3,'Erase Mark',310000,66),
(128,1437,17,'Dark Flame',160000,66),
(128,1437,18,'Dark Flame',160000,66),
(128,1438,5,'Annihilation Circle',310000,66),
(128,1435,8,'Death Mark',310000,66),
(128,1511,5,'Curse of Life Flow',460000,68),
(128,1529,4,'Soul Web',460000,68),
(128,1438,6,'Annihilation Circle',460000,68),
(128,1437,19,'Dark Flame',230000,68),
(128,1437,20,'Dark Flame',230000,68),
(128,1445,15,'Surrender to the Unholy',460000,68),
(128,1447,6,'Voice Bind',460000,68),
(128,1446,8,'Shadow Bind',460000,68),
(128,1439,2,'Curse of Divinity',460000,68),
(128,1440,4,'Steal Divinity',460000,68),
(128,1436,23,'Soul of Pain',230000,68),
(128,1436,24,'Soul of Pain',230000,68),
(128,467,20,'Soul Mastery',460000,68),
(128,492,18,'Spread Wing',230000,68),
(128,492,19,'Spread Wing',230000,68),
(128,505,21,'Shining Edge',230000,68),
(128,505,22,'Shining Edge',230000,68),
(128,504,30,'Triple Thrust',230000,68),
(128,504,31,'Triple Thrust',230000,68),
(128,474,38,'Rapier Mastery',230000,68),
(128,474,39,'Rapier Mastery',230000,68),
(128,466,48,'Magic Immunity',230000,68),
(128,466,49,'Magic Immunity',230000,68),
(128,465,43,'Light Armor Mastery',230000,68),
(128,465,44,'Light Armor Mastery',230000,68),
(128,1511,6,'Curse of Life Flow',550000,70),
(128,1529,5,'Soul Web',550000,70),
(128,465,45,'Light Armor Mastery',280000,70),
(128,465,46,'Light Armor Mastery',280000,70),
(128,466,50,'Magic Immunity',280000,70),
(128,466,51,'Magic Immunity',280000,70),
(128,474,40,'Rapier Mastery',280000,70),
(128,474,41,'Rapier Mastery',280000,70),
(128,504,32,'Triple Thrust',280000,70),
(128,504,33,'Triple Thrust',280000,70),
(128,505,23,'Shining Edge',280000,70),
(128,505,24,'Shining Edge',280000,70),
(128,492,20,'Spread Wing',280000,70),
(128,492,21,'Spread Wing',280000,70),
(128,467,21,'Soul Mastery',550000,70),
(128,1436,25,'Soul of Pain',280000,70),
(128,1436,26,'Soul of Pain',280000,70),
(128,1439,3,'Curse of Divinity',550000,70),
(128,1445,16,'Surrender to the Unholy',550000,70),
(128,1447,7,'Voice Bind',550000,70),
(128,1446,9,'Shadow Bind',550000,70),
(128,1437,21,'Dark Flame',280000,70),
(128,1437,22,'Dark Flame',280000,70),
(128,1438,7,'Annihilation Circle',550000,70),
(128,1435,9,'Death Mark',550000,70),
(128,1511,7,'Curse of Life Flow',630000,72),
(128,1529,6,'Soul Web',630000,72),
(128,1438,8,'Annihilation Circle',630000,72),
(128,1437,23,'Dark Flame',320000,72),
(128,1437,24,'Dark Flame',320000,72),
(128,1445,17,'Surrender to the Unholy',630000,72),
(128,1447,8,'Voice Bind',630000,72),
(128,1446,10,'Shadow Bind',630000,72),
(128,1439,4,'Curse of Divinity',630000,72),
(128,1440,5,'Steal Divinity',630000,72),
(128,1436,27,'Soul of Pain',320000,72),
(128,1436,28,'Soul of Pain',320000,72),
(128,467,22,'Soul Mastery',630000,72),
(128,502,5,'Life to Soul',630000,72),
(128,506,4,'Checkmate',630000,72),
(128,492,22,'Spread Wing',320000,72),
(128,492,23,'Spread Wing',320000,72),
(128,505,25,'Shining Edge',320000,72),
(128,505,26,'Shining Edge',320000,72),
(128,504,34,'Triple Thrust',320000,72),
(128,504,35,'Triple Thrust',320000,72),
(128,474,42,'Rapier Mastery',320000,72),
(128,474,43,'Rapier Mastery',320000,72),
(128,466,52,'Magic Immunity',320000,72),
(128,466,53,'Magic Immunity',320000,72),
(128,465,47,'Light Armor Mastery',320000,72),
(128,465,48,'Light Armor Mastery',320000,72),
(128,1511,8,'Curse of Life Flow',1440000,74),
(128,1529,7,'Soul Web',1440000,74),
(128,465,49,'Light Armor Mastery',720000,74),
(128,465,50,'Light Armor Mastery',720000,74),
(128,466,54,'Magic Immunity',720000,74),
(128,466,55,'Magic Immunity',720000,74),
(128,474,44,'Rapier Mastery',720000,74),
(128,474,45,'Rapier Mastery',720000,74),
(128,504,36,'Triple Thrust',720000,74),
(128,504,37,'Triple Thrust',720000,74),
(128,505,27,'Shining Edge',720000,74),
(128,505,28,'Shining Edge',720000,74),
(128,492,24,'Spread Wing',720000,74),
(128,492,25,'Spread Wing',720000,74),
(128,467,23,'Soul Mastery',1440000,74),
(128,1436,29,'Soul of Pain',720000,74),
(128,1436,30,'Soul of Pain',720000,74),
(128,1442,3,'Protection from Darkness',1440000,74),
(128,1447,9,'Voice Bind',1440000,74),
(128,1439,5,'Curse of Divinity',1440000,74),
(128,1445,18,'Surrender to the Unholy',1440000,74),
(128,1446,11,'Shadow Bind',1440000,74),
(128,1437,25,'Dark Flame',720000,74),
(128,1437,26,'Dark Flame',720000,74),
(128,1438,9,'Annihilation Circle',1440000,74),
(128,1435,10,'Death Mark',1440000,74),
(129,1527,1,'Expert Casting',38000,40),
(129,465,14,'Light Armor Mastery',12000,40),
(129,465,15,'Light Armor Mastery',12000,40),
(129,465,16,'Light Armor Mastery',12000,40),
(129,466,19,'Magic Immunity',12000,40),
(129,466,20,'Magic Immunity',12000,40),
(129,466,21,'Magic Immunity',12000,40),
(129,474,9,'Rapier Mastery',12000,40),
(129,474,10,'Rapier Mastery',12000,40),
(129,474,11,'Rapier Mastery',12000,40),
(129,504,1,'Triple Thrust',12000,40),
(129,504,2,'Triple Thrust',12000,40),
(129,504,3,'Triple Thrust',12000,40),
(129,467,9,'Soul Mastery',38000,40),
(129,502,1,'Life to Soul',38000,40),
(129,1436,1,'Soul of Pain',19000,40),
(129,1436,2,'Soul of Pain',19000,40),
(129,1435,3,'Death Mark',38000,40),
(129,1445,4,'Surrender to the Unholy',38000,40),
(129,832,1,'Fast Recovery',39000,43),
(129,1445,5,'Surrender to the Unholy',39000,43),
(129,1474,1,'Abyssal Power',39000,43),
(129,626,1,'Critical Sense',39000,43),
(129,1441,1,'Soul to Empower',39000,43),
(129,1436,3,'Soul of Pain',20000,43),
(129,1436,4,'Soul of Pain',20000,43),
(129,467,10,'Soul Mastery',39000,43),
(129,481,2,'Dark Armor',39000,43),
(129,504,4,'Triple Thrust',13000,43),
(129,504,5,'Triple Thrust',13000,43),
(129,504,6,'Triple Thrust',13000,43),
(129,474,12,'Rapier Mastery',13000,43),
(129,474,13,'Rapier Mastery',13000,43),
(129,474,14,'Rapier Mastery',13000,43),
(129,466,22,'Magic Immunity',13000,43),
(129,466,23,'Magic Immunity',13000,43),
(129,466,24,'Magic Immunity',13000,43),
(129,465,17,'Light Armor Mastery',13000,43),
(129,465,18,'Light Armor Mastery',13000,43),
(129,465,19,'Light Armor Mastery',13000,43),
(129,625,1,'Soul Gathering',50000,46),
(129,465,20,'Light Armor Mastery',17000,46),
(129,465,21,'Light Armor Mastery',17000,46),
(129,465,22,'Light Armor Mastery',17000,46),
(129,466,25,'Magic Immunity',17000,46),
(129,466,26,'Magic Immunity',17000,46),
(129,466,27,'Magic Immunity',17000,46),
(129,474,15,'Rapier Mastery',17000,46),
(129,474,16,'Rapier Mastery',17000,46),
(129,474,17,'Rapier Mastery',17000,46),
(129,504,7,'Triple Thrust',17000,46),
(129,504,8,'Triple Thrust',17000,46),
(129,504,9,'Triple Thrust',17000,46),
(129,467,11,'Soul Mastery',50000,46),
(129,1436,5,'Soul of Pain',25000,46),
(129,1436,6,'Soul of Pain',25000,46),
(129,1475,2,'Erase Mark',50000,46),
(129,1443,1,'Dark Weapon',50000,46),
(129,1445,6,'Surrender to the Unholy',50000,46),
(129,1435,4,'Death Mark',50000,46),
(129,1437,1,'Dark Flame',25000,46),
(129,1437,2,'Dark Flame',25000,46),
(129,467,1,'Soul Mastery',50000,46),
(129,1437,3,'Dark Flame',45000,49),
(129,1437,4,'Dark Flame',45000,49),
(129,1445,7,'Surrender to the Unholy',89000,49),
(129,1444,1,'Pride of Kamael',89000,49),
(129,1436,7,'Soul of Pain',45000,49),
(129,1436,8,'Soul of Pain',45000,49),
(129,467,12,'Soul Mastery',89000,49),
(129,502,2,'Life to Soul',89000,49),
(129,505,1,'Shining Edge',30000,49),
(129,505,2,'Shining Edge',30000,49),
(129,505,3,'Shining Edge',30000,49),
(129,504,10,'Triple Thrust',30000,49),
(129,504,11,'Triple Thrust',30000,49),
(129,504,12,'Triple Thrust',30000,49),
(129,474,18,'Rapier Mastery',30000,49),
(129,474,19,'Rapier Mastery',30000,49),
(129,474,20,'Rapier Mastery',30000,49),
(129,466,28,'Magic Immunity',30000,49),
(129,466,29,'Magic Immunity',30000,49),
(129,466,30,'Magic Immunity',30000,49),
(129,465,23,'Light Armor Mastery',30000,49),
(129,465,24,'Light Armor Mastery',30000,49),
(129,465,25,'Light Armor Mastery',30000,49),
(129,465,26,'Light Armor Mastery',36000,52),
(129,465,27,'Light Armor Mastery',36000,52),
(129,465,28,'Light Armor Mastery',36000,52),
(129,466,31,'Magic Immunity',36000,52),
(129,466,32,'Magic Immunity',36000,52),
(129,466,33,'Magic Immunity',36000,52),
(129,474,21,'Rapier Mastery',36000,52),
(129,474,22,'Rapier Mastery',36000,52),
(129,474,23,'Rapier Mastery',36000,52),
(129,504,13,'Triple Thrust',36000,52),
(129,504,14,'Triple Thrust',36000,52),
(129,504,15,'Triple Thrust',36000,52),
(129,505,4,'Shining Edge',36000,52),
(129,505,5,'Shining Edge',36000,52),
(129,505,6,'Shining Edge',36000,52),
(129,492,1,'Spread Wing',36000,52),
(129,492,2,'Spread Wing',36000,52),
(129,492,3,'Spread Wing',36000,52),
(129,506,1,'Checkmate',107000,52),
(129,467,13,'Soul Mastery',107000,52),
(129,1436,9,'Soul of Pain',54000,52),
(129,1436,10,'Soul of Pain',54000,52),
(129,1446,1,'Shadow Bind',107000,52),
(129,1445,8,'Surrender to the Unholy',107000,52),
(129,626,2,'Critical Sense',107000,52),
(129,1437,5,'Dark Flame',54000,52),
(129,1437,6,'Dark Flame',54000,52),
(129,1435,5,'Death Mark',107000,52),
(129,1437,7,'Dark Flame',71000,55),
(129,1437,8,'Dark Flame',71000,55),
(129,1441,2,'Soul to Empower',141000,55),
(129,1440,1,'Steal Divinity',141000,55),
(129,1445,9,'Surrender to the Unholy',141000,55),
(129,1446,2,'Shadow Bind',141000,55),
(129,1436,11,'Soul of Pain',71000,55),
(129,1436,12,'Soul of Pain',71000,55),
(129,467,14,'Soul Mastery',141000,55),
(129,492,4,'Spread Wing',41000,55),
(129,492,5,'Spread Wing',41000,55),
(129,492,6,'Spread Wing',41000,55),
(129,505,7,'Shining Edge',41000,55),
(129,505,8,'Shining Edge',41000,55),
(129,505,9,'Shining Edge',41000,55),
(129,504,16,'Triple Thrust',41000,55),
(129,504,17,'Triple Thrust',41000,55),
(129,504,18,'Triple Thrust',41000,55),
(129,474,24,'Rapier Mastery',41000,55),
(129,474,25,'Rapier Mastery',41000,55),
(129,474,26,'Rapier Mastery',41000,55),
(129,466,34,'Magic Immunity',41000,55),
(129,466,35,'Magic Immunity',41000,55),
(129,466,36,'Magic Immunity',41000,55),
(129,465,29,'Light Armor Mastery',41000,55),
(129,465,30,'Light Armor Mastery',41000,55),
(129,465,31,'Light Armor Mastery',41000,55),
(129,837,1,'Painkiller',169000,58),
(129,465,32,'Light Armor Mastery',56000,58),
(129,465,33,'Light Armor Mastery',56000,58),
(129,465,34,'Light Armor Mastery',56000,58),
(129,466,37,'Magic Immunity',56000,58),
(129,466,38,'Magic Immunity',56000,58),
(129,466,39,'Magic Immunity',56000,58),
(129,474,27,'Rapier Mastery',56000,58),
(129,474,28,'Rapier Mastery',56000,58),
(129,474,29,'Rapier Mastery',56000,58),
(129,504,19,'Triple Thrust',56000,58),
(129,504,20,'Triple Thrust',56000,58),
(129,504,21,'Triple Thrust',56000,58),
(129,505,10,'Shining Edge',56000,58),
(129,505,11,'Shining Edge',56000,58),
(129,505,12,'Shining Edge',56000,58),
(129,492,7,'Spread Wing',56000,58),
(129,492,8,'Spread Wing',56000,58),
(129,492,9,'Spread Wing',56000,58),
(129,467,15,'Soul Mastery',169000,58),
(129,502,3,'Life to Soul',169000,58),
(129,1436,13,'Soul of Pain',85000,58),
(129,1436,14,'Soul of Pain',85000,58),
(129,1445,10,'Surrender to the Unholy',169000,58),
(129,1446,3,'Shadow Bind',169000,58),
(129,1447,1,'Voice Bind',169000,58),
(129,1442,1,'Protection from Darkness',169000,58),
(129,1437,9,'Dark Flame',85000,58),
(129,1437,10,'Dark Flame',85000,58),
(129,1435,6,'Death Mark',169000,58),
(129,1438,1,'Annihilation Circle',169000,58),
(129,1438,2,'Annihilation Circle',161000,60),
(129,1437,11,'Dark Flame',81000,60),
(129,1437,12,'Dark Flame',81000,60),
(129,1440,2,'Steal Divinity',161000,60),
(129,626,3,'Critical Sense',161000,60),
(129,1448,1,'Blink',161000,60),
(129,1511,1,'Curse of Life Flow',161000,60),
(129,1445,11,'Surrender to the Unholy',161000,60),
(129,1447,2,'Voice Bind',161000,60),
(129,1446,4,'Shadow Bind',161000,60),
(129,1436,15,'Soul of Pain',81000,60),
(129,1436,16,'Soul of Pain',81000,60),
(129,506,2,'Checkmate',161000,60),
(129,467,16,'Soul Mastery',161000,60),
(129,492,10,'Spread Wing',81000,60),
(129,492,11,'Spread Wing',81000,60),
(129,505,13,'Shining Edge',81000,60),
(129,505,14,'Shining Edge',81000,60),
(129,504,22,'Triple Thrust',81000,60),
(129,504,23,'Triple Thrust',81000,60),
(129,474,30,'Rapier Mastery',81000,60),
(129,474,31,'Rapier Mastery',81000,60),
(129,466,40,'Magic Immunity',81000,60),
(129,466,41,'Magic Immunity',81000,60),
(129,465,35,'Light Armor Mastery',81000,60),
(129,465,36,'Light Armor Mastery',81000,60),
(129,1511,2,'Curse of Life Flow',250000,62),
(129,1529,1,'Soul Web',250000,62),
(129,465,37,'Light Armor Mastery',130000,62),
(129,465,38,'Light Armor Mastery',130000,62),
(129,466,42,'Magic Immunity',130000,62),
(129,466,43,'Magic Immunity',130000,62),
(129,474,32,'Rapier Mastery',130000,62),
(129,474,33,'Rapier Mastery',130000,62),
(129,504,24,'Triple Thrust',130000,62),
(129,504,25,'Triple Thrust',130000,62),
(129,505,15,'Shining Edge',130000,62),
(129,505,16,'Shining Edge',130000,62),
(129,492,12,'Spread Wing',130000,62),
(129,492,13,'Spread Wing',130000,62),
(129,467,17,'Soul Mastery',250000,62),
(129,1436,17,'Soul of Pain',130000,62),
(129,1436,18,'Soul of Pain',130000,62),
(129,1445,12,'Surrender to the Unholy',250000,62),
(129,1447,3,'Voice Bind',250000,62),
(129,1446,5,'Shadow Bind',250000,62),
(129,1437,13,'Dark Flame',130000,62),
(129,1437,14,'Dark Flame',130000,62),
(129,1438,3,'Annihilation Circle',250000,62),
(129,1435,7,'Death Mark',250000,62),
(129,1511,3,'Curse of Life Flow',300000,64),
(129,1529,2,'Soul Web',300000,64),
(129,1438,4,'Annihilation Circle',300000,64),
(129,1437,15,'Dark Flame',150000,64),
(129,1437,16,'Dark Flame',150000,64),
(129,1445,13,'Surrender to the Unholy',300000,64),
(129,1447,4,'Voice Bind',300000,64),
(129,1446,6,'Shadow Bind',300000,64),
(129,1440,3,'Steal Divinity',300000,64),
(129,1436,19,'Soul of Pain',150000,64),
(129,1436,20,'Soul of Pain',150000,64),
(129,467,18,'Soul Mastery',300000,64),
(129,492,14,'Spread Wing',150000,64),
(129,492,15,'Spread Wing',150000,64),
(129,505,17,'Shining Edge',150000,64),
(129,505,18,'Shining Edge',150000,64),
(129,504,26,'Triple Thrust',150000,64),
(129,504,27,'Triple Thrust',150000,64),
(129,474,34,'Rapier Mastery',150000,64),
(129,474,35,'Rapier Mastery',150000,64),
(129,466,44,'Magic Immunity',150000,64),
(129,466,45,'Magic Immunity',150000,64),
(129,465,39,'Light Armor Mastery',150000,64),
(129,465,40,'Light Armor Mastery',150000,64),
(129,1511,4,'Curse of Life Flow',310000,66),
(129,1529,3,'Soul Web',310000,66),
(129,465,41,'Light Armor Mastery',160000,66),
(129,465,42,'Light Armor Mastery',160000,66),
(129,466,46,'Magic Immunity',160000,66),
(129,466,47,'Magic Immunity',160000,66),
(129,474,36,'Rapier Mastery',160000,66),
(129,474,37,'Rapier Mastery',160000,66),
(129,504,28,'Triple Thrust',160000,66),
(129,504,29,'Triple Thrust',160000,66),
(129,505,19,'Shining Edge',160000,66),
(129,505,20,'Shining Edge',160000,66),
(129,492,16,'Spread Wing',160000,66),
(129,492,17,'Spread Wing',160000,66),
(129,467,19,'Soul Mastery',310000,66),
(129,506,3,'Checkmate',310000,66),
(129,502,4,'Life to Soul',310000,66),
(129,1436,21,'Soul of Pain',160000,66),
(129,1436,22,'Soul of Pain',160000,66),
(129,1442,2,'Protection from Darkness',310000,66),
(129,626,4,'Critical Sense',310000,66),
(129,1439,1,'Curse of Divinity',310000,66),
(129,1445,14,'Surrender to the Unholy',310000,66),
(129,1447,5,'Voice Bind',310000,66),
(129,1446,7,'Shadow Bind',310000,66),
(129,1510,1,'Soul Cleanse',310000,66),
(129,1475,3,'Erase Mark',310000,66),
(129,1437,17,'Dark Flame',160000,66),
(129,1437,18,'Dark Flame',160000,66),
(129,1438,5,'Annihilation Circle',310000,66),
(129,1435,8,'Death Mark',310000,66),
(129,1511,5,'Curse of Life Flow',460000,68),
(129,1529,4,'Soul Web',460000,68),
(129,1438,6,'Annihilation Circle',460000,68),
(129,1437,19,'Dark Flame',230000,68),
(129,1437,20,'Dark Flame',230000,68),
(129,1445,15,'Surrender to the Unholy',460000,68),
(129,1447,6,'Voice Bind',460000,68),
(129,1446,8,'Shadow Bind',460000,68),
(129,1439,2,'Curse of Divinity',460000,68),
(129,1440,4,'Steal Divinity',460000,68),
(129,1436,23,'Soul of Pain',230000,68),
(129,1436,24,'Soul of Pain',230000,68),
(129,467,20,'Soul Mastery',460000,68),
(129,492,18,'Spread Wing',230000,68),
(129,492,19,'Spread Wing',230000,68),
(129,505,21,'Shining Edge',230000,68),
(129,505,22,'Shining Edge',230000,68),
(129,504,30,'Triple Thrust',230000,68),
(129,504,31,'Triple Thrust',230000,68),
(129,474,38,'Rapier Mastery',230000,68),
(129,474,39,'Rapier Mastery',230000,68),
(129,466,48,'Magic Immunity',230000,68),
(129,466,49,'Magic Immunity',230000,68),
(129,465,43,'Light Armor Mastery',230000,68),
(129,465,44,'Light Armor Mastery',230000,68),
(129,1511,6,'Curse of Life Flow',550000,70),
(129,1529,5,'Soul Web',550000,70),
(129,465,45,'Light Armor Mastery',280000,70),
(129,465,46,'Light Armor Mastery',280000,70),
(129,466,50,'Magic Immunity',280000,70),
(129,466,51,'Magic Immunity',280000,70),
(129,474,40,'Rapier Mastery',280000,70),
(129,474,41,'Rapier Mastery',280000,70),
(129,504,32,'Triple Thrust',280000,70),
(129,504,33,'Triple Thrust',280000,70),
(129,505,23,'Shining Edge',280000,70),
(129,505,24,'Shining Edge',280000,70),
(129,492,20,'Spread Wing',280000,70),
(129,492,21,'Spread Wing',280000,70),
(129,467,21,'Soul Mastery',550000,70),
(129,1436,25,'Soul of Pain',280000,70),
(129,1436,26,'Soul of Pain',280000,70),
(129,1439,3,'Curse of Divinity',550000,70),
(129,1445,16,'Surrender to the Unholy',550000,70),
(129,1447,7,'Voice Bind',550000,70),
(129,1446,9,'Shadow Bind',550000,70),
(129,1437,21,'Dark Flame',280000,70),
(129,1437,22,'Dark Flame',280000,70),
(129,1438,7,'Annihilation Circle',550000,70),
(129,1435,9,'Death Mark',550000,70),
(129,1511,7,'Curse of Life Flow',630000,72),
(129,1529,6,'Soul Web',630000,72),
(129,1438,8,'Annihilation Circle',630000,72),
(129,1437,23,'Dark Flame',320000,72),
(129,1437,24,'Dark Flame',320000,72),
(129,1445,17,'Surrender to the Unholy',630000,72),
(129,1447,8,'Voice Bind',630000,72),
(129,1446,10,'Shadow Bind',630000,72),
(129,1439,4,'Curse of Divinity',630000,72),
(129,1440,5,'Steal Divinity',630000,72),
(129,1436,27,'Soul of Pain',320000,72),
(129,1436,28,'Soul of Pain',320000,72),
(129,467,22,'Soul Mastery',630000,72),
(129,502,5,'Life to Soul',630000,72),
(129,506,4,'Checkmate',630000,72),
(129,492,22,'Spread Wing',320000,72),
(129,492,23,'Spread Wing',320000,72),
(129,505,25,'Shining Edge',320000,72),
(129,505,26,'Shining Edge',320000,72),
(129,504,34,'Triple Thrust',320000,72),
(129,504,35,'Triple Thrust',320000,72),
(129,474,42,'Rapier Mastery',320000,72),
(129,474,43,'Rapier Mastery',320000,72),
(129,466,52,'Magic Immunity',320000,72),
(129,466,53,'Magic Immunity',320000,72),
(129,465,47,'Light Armor Mastery',320000,72),
(129,465,48,'Light Armor Mastery',320000,72),
(129,1511,8,'Curse of Life Flow',1440000,74),
(129,1529,7,'Soul Web',1440000,74),
(129,465,49,'Light Armor Mastery',720000,74),
(129,465,50,'Light Armor Mastery',720000,74),
(129,466,54,'Magic Immunity',720000,74),
(129,466,55,'Magic Immunity',720000,74),
(129,474,44,'Rapier Mastery',720000,74),
(129,474,45,'Rapier Mastery',720000,74),
(129,504,36,'Triple Thrust',720000,74),
(129,504,37,'Triple Thrust',720000,74),
(129,505,27,'Shining Edge',720000,74),
(129,505,28,'Shining Edge',720000,74),
(129,492,24,'Spread Wing',720000,74),
(129,492,25,'Spread Wing',720000,74),
(129,467,23,'Soul Mastery',1440000,74),
(129,1436,29,'Soul of Pain',720000,74),
(129,1436,30,'Soul of Pain',720000,74),
(129,1442,3,'Protection from Darkness',1440000,74),
(129,1439,5,'Curse of Divinity',1440000,74),
(129,1445,18,'Surrender to the Unholy',1440000,74),
(129,1447,9,'Voice Bind',1440000,74),
(129,1446,11,'Shadow Bind',1440000,74),
(129,1437,25,'Dark Flame',720000,74),
(129,1437,26,'Dark Flame',720000,74),
(129,1438,9,'Annihilation Circle',1440000,74),
(129,1435,10,'Death Mark',1440000,74),
(130,627,4,'Soul Shock',11000,40),
(130,627,5,'Soul Shock',11000,40),
(130,627,6,'Soul Shock',11000,40),
(130,465,14,'Light Armor Mastery',12000,40),
(130,465,15,'Light Armor Mastery',12000,40),
(130,465,16,'Light Armor Mastery',12000,40),
(130,466,19,'Magic Immunity',12000,40),
(130,466,20,'Magic Immunity',12000,40),
(130,466,21,'Magic Immunity',12000,40),
(130,473,9,'Crossbow Mastery',12000,40),
(130,473,10,'Crossbow Mastery',12000,40),
(130,473,11,'Crossbow Mastery',12000,40),
(130,507,1,'Twin Shot',12000,40),
(130,507,2,'Twin Shot',12000,40),
(130,507,3,'Twin Shot',12000,40),
(130,467,9,'Soul Mastery',35000,40),
(130,486,2,'Increase Range',35000,40),
(130,489,1,'Shift Target',35000,40),
(130,502,1,'Life to Soul',35000,40),
(130,518,1,'Binding Trap',35000,40),
(130,522,1,'Real Target',35000,40),
(130,514,3,'Fire Trap',33000,43),
(130,832,1,'Fast Recovery',33000,43),
(130,621,1,'Create Special Bolt',33000,43),
(130,627,7,'Soul Shock',12000,43),
(130,627,8,'Soul Shock',12000,43),
(130,627,9,'Soul Shock',12000,43),
(130,525,1,'Decoy',33000,43),
(130,467,10,'Soul Mastery',33000,43),
(130,626,1,'Critical Sense',33000,43),
(130,509,1,'Bleeding Shot',11000,43),
(130,509,2,'Bleeding Shot',11000,43),
(130,509,3,'Bleeding Shot',11000,43),
(130,507,4,'Twin Shot',11000,43),
(130,507,5,'Twin Shot',11000,43),
(130,507,6,'Twin Shot',11000,43),
(130,473,12,'Crossbow Mastery',11000,43),
(130,473,13,'Crossbow Mastery',11000,43),
(130,473,14,'Crossbow Mastery',11000,43),
(130,466,22,'Magic Immunity',11000,43),
(130,466,23,'Magic Immunity',11000,43),
(130,466,24,'Magic Immunity',11000,43),
(130,465,17,'Light Armor Mastery',11000,43),
(130,465,18,'Light Armor Mastery',11000,43),
(130,465,19,'Light Armor Mastery',11000,43),
(130,627,10,'Soul Shock',17000,46),
(130,627,11,'Soul Shock',17000,46),
(130,627,12,'Soul Shock',17000,46),
(130,625,1,'Soul Gathering',50000,46),
(130,465,20,'Light Armor Mastery',17000,46),
(130,465,21,'Light Armor Mastery',17000,46),
(130,465,22,'Light Armor Mastery',17000,46),
(130,466,25,'Magic Immunity',17000,46),
(130,466,26,'Magic Immunity',17000,46),
(130,466,27,'Magic Immunity',17000,46),
(130,473,15,'Crossbow Mastery',17000,46),
(130,473,16,'Crossbow Mastery',17000,46),
(130,473,17,'Crossbow Mastery',17000,46),
(130,507,7,'Twin Shot',17000,46),
(130,507,8,'Twin Shot',17000,46),
(130,507,9,'Twin Shot',17000,46),
(130,509,4,'Bleeding Shot',17000,46),
(130,509,5,'Bleeding Shot',17000,46),
(130,509,6,'Bleeding Shot',17000,46),
(130,467,11,'Soul Mastery',50000,46),
(130,471,4,'Defuse Trap',50000,46),
(130,508,1,'Rising Shot',17000,46),
(130,508,2,'Rising Shot',17000,46),
(130,508,3,'Rising Shot',17000,46),
(130,518,2,'Binding Trap',50000,46),
(130,514,4,'Fire Trap',82000,49),
(130,627,13,'Soul Shock',27000,49),
(130,627,14,'Soul Shock',27000,49),
(130,627,15,'Soul Shock',27000,49),
(130,502,2,'Life to Soul',82000,49),
(130,511,1,'Temptation',82000,49),
(130,515,1,'Poison Trap',82000,49),
(130,508,4,'Rising Shot',27000,49),
(130,508,5,'Rising Shot',27000,49),
(130,508,6,'Rising Shot',27000,49),
(130,467,12,'Soul Mastery',82000,49),
(130,509,7,'Bleeding Shot',27000,49),
(130,509,8,'Bleeding Shot',27000,49),
(130,509,9,'Bleeding Shot',27000,49),
(130,507,10,'Twin Shot',27000,49),
(130,507,11,'Twin Shot',27000,49),
(130,507,12,'Twin Shot',27000,49),
(130,473,18,'Crossbow Mastery',27000,49),
(130,473,19,'Crossbow Mastery',27000,49),
(130,473,20,'Crossbow Mastery',27000,49),
(130,466,28,'Magic Immunity',27000,49),
(130,466,29,'Magic Immunity',27000,49),
(130,466,30,'Magic Immunity',27000,49),
(130,465,23,'Light Armor Mastery',27000,49),
(130,465,24,'Light Armor Mastery',27000,49),
(130,465,25,'Light Armor Mastery',27000,49),
(130,622,2,'Ultimate Escape',100000,52),
(130,627,16,'Soul Shock',36000,52),
(130,627,17,'Soul Shock',36000,52),
(130,627,18,'Soul Shock',36000,52),
(130,465,26,'Light Armor Mastery',36000,52),
(130,465,27,'Light Armor Mastery',36000,52),
(130,465,28,'Light Armor Mastery',36000,52),
(130,466,31,'Magic Immunity',36000,52),
(130,466,32,'Magic Immunity',36000,52),
(130,466,33,'Magic Immunity',36000,52),
(130,473,21,'Crossbow Mastery',36000,52),
(130,473,22,'Crossbow Mastery',36000,52),
(130,473,23,'Crossbow Mastery',36000,52),
(130,626,2,'Critical Sense',107000,52),
(130,507,13,'Twin Shot',36000,52),
(130,507,14,'Twin Shot',36000,52),
(130,507,15,'Twin Shot',36000,52),
(130,509,10,'Bleeding Shot',36000,52),
(130,509,11,'Bleeding Shot',36000,52),
(130,509,12,'Bleeding Shot',36000,52),
(130,467,13,'Soul Mastery',107000,52),
(130,508,7,'Rising Shot',36000,52),
(130,508,8,'Rising Shot',36000,52),
(130,508,9,'Rising Shot',36000,52),
(130,516,1,'Slow Trap',107000,52),
(130,518,3,'Binding Trap',107000,52),
(130,525,2,'Decoy',107000,52),
(130,522,2,'Real Target',107000,52),
(130,620,1,'Quiver of Bolts - Grade B',107000,52),
(130,514,5,'Fire Trap',157000,55),
(130,627,19,'Soul Shock',52000,55),
(130,627,20,'Soul Shock',52000,55),
(130,627,21,'Soul Shock',52000,55),
(130,517,1,'Flash Trap',157000,55),
(130,515,2,'Poison Trap',157000,55),
(130,508,10,'Rising Shot',52000,55),
(130,508,11,'Rising Shot',52000,55),
(130,508,12,'Rising Shot',52000,55),
(130,467,14,'Soul Mastery',157000,55),
(130,471,5,'Defuse Trap',157000,55),
(130,490,2,'Fast Shot',157000,55),
(130,509,13,'Bleeding Shot',52000,55),
(130,509,14,'Bleeding Shot',52000,55),
(130,509,15,'Bleeding Shot',52000,55),
(130,507,16,'Twin Shot',52000,55),
(130,507,17,'Twin Shot',52000,55),
(130,507,18,'Twin Shot',52000,55),
(130,473,24,'Crossbow Mastery',52000,55),
(130,473,25,'Crossbow Mastery',52000,55),
(130,473,26,'Crossbow Mastery',52000,55),
(130,466,34,'Magic Immunity',52000,55),
(130,466,35,'Magic Immunity',52000,55),
(130,466,36,'Magic Immunity',52000,55),
(130,465,29,'Light Armor Mastery',52000,55),
(130,465,30,'Light Armor Mastery',52000,55),
(130,465,31,'Light Armor Mastery',52000,55),
(130,627,22,'Soul Shock',62000,58),
(130,627,23,'Soul Shock',62000,58),
(130,627,24,'Soul Shock',62000,58),
(130,465,32,'Light Armor Mastery',62000,58),
(130,465,33,'Light Armor Mastery',62000,58),
(130,465,34,'Light Armor Mastery',62000,58),
(130,466,37,'Magic Immunity',62000,58),
(130,466,38,'Magic Immunity',62000,58),
(130,466,39,'Magic Immunity',62000,58),
(130,473,27,'Crossbow Mastery',62000,58),
(130,473,28,'Crossbow Mastery',62000,58),
(130,473,29,'Crossbow Mastery',62000,58),
(130,507,19,'Twin Shot',62000,58),
(130,507,20,'Twin Shot',62000,58),
(130,507,21,'Twin Shot',62000,58),
(130,509,16,'Bleeding Shot',62000,58),
(130,509,17,'Bleeding Shot',62000,58),
(130,509,18,'Bleeding Shot',62000,58),
(130,467,15,'Soul Mastery',185000,58),
(130,508,13,'Rising Shot',62000,58),
(130,508,14,'Rising Shot',62000,58),
(130,508,15,'Rising Shot',62000,58),
(130,502,3,'Life to Soul',185000,58),
(130,516,2,'Slow Trap',185000,58),
(130,518,4,'Binding Trap',185000,58),
(130,1514,1,'Soul Barrier',185000,58),
(130,514,6,'Fire Trap',193000,60),
(130,627,25,'Soul Shock',97000,60),
(130,627,26,'Soul Shock',97000,60),
(130,519,1,'Quiver of Bolts: A-Grade',193000,60),
(130,525,3,'Decoy',193000,60),
(130,521,1,'Sharpshooting',193000,60),
(130,517,2,'Flash Trap',193000,60),
(130,515,3,'Poison Trap',193000,60),
(130,508,16,'Rising Shot',97000,60),
(130,508,17,'Rising Shot',97000,60),
(130,467,16,'Soul Mastery',193000,60),
(130,626,3,'Critical Sense',193000,60),
(130,509,19,'Bleeding Shot',97000,60),
(130,509,20,'Bleeding Shot',97000,60),
(130,507,22,'Twin Shot',97000,60),
(130,507,23,'Twin Shot',97000,60),
(130,473,30,'Crossbow Mastery',97000,60),
(130,473,31,'Crossbow Mastery',97000,60),
(130,466,40,'Magic Immunity',97000,60),
(130,466,41,'Magic Immunity',97000,60),
(130,465,35,'Light Armor Mastery',97000,60),
(130,465,36,'Light Armor Mastery',97000,60),
(130,514,7,'Fire Trap',290000,62),
(130,627,27,'Soul Shock',140000,62),
(130,627,28,'Soul Shock',140000,62),
(130,513,1,'Create Dark Seed',290000,62),
(130,522,3,'Real Target',290000,62),
(130,523,1,'Imbue Dark Seed',290000,62),
(130,516,3,'Slow Trap',290000,62),
(130,521,2,'Sharpshooting',290000,62),
(130,518,5,'Binding Trap',290000,62),
(130,509,21,'Bleeding Shot',140000,62),
(130,509,22,'Bleeding Shot',140000,62),
(130,467,17,'Soul Mastery',290000,62),
(130,508,18,'Rising Shot',140000,62),
(130,508,19,'Rising Shot',140000,62),
(130,465,37,'Light Armor Mastery',140000,62),
(130,465,38,'Light Armor Mastery',140000,62),
(130,466,42,'Magic Immunity',140000,62),
(130,466,43,'Magic Immunity',140000,62),
(130,473,32,'Crossbow Mastery',140000,62),
(130,473,33,'Crossbow Mastery',140000,62),
(130,507,24,'Twin Shot',140000,62),
(130,507,25,'Twin Shot',140000,62),
(130,836,1,'Oblivion Trap',160000,64),
(130,627,29,'Soul Shock',160000,64),
(130,627,30,'Soul Shock',160000,64),
(130,524,1,'Cure Dark Seed',320000,64),
(130,507,26,'Twin Shot',160000,64),
(130,507,27,'Twin Shot',160000,64),
(130,473,34,'Crossbow Mastery',160000,64),
(130,473,35,'Crossbow Mastery',160000,64),
(130,466,44,'Magic Immunity',160000,64),
(130,466,45,'Magic Immunity',160000,64),
(130,465,39,'Light Armor Mastery',160000,64),
(130,465,40,'Light Armor Mastery',160000,64),
(130,508,20,'Rising Shot',160000,64),
(130,508,21,'Rising Shot',160000,64),
(130,467,18,'Soul Mastery',320000,64),
(130,509,23,'Bleeding Shot',160000,64),
(130,509,24,'Bleeding Shot',160000,64),
(130,521,3,'Sharpshooting',320000,64),
(130,517,3,'Flash Trap',320000,64),
(130,515,4,'Poison Trap',320000,64),
(130,523,2,'Imbue Dark Seed',320000,64),
(130,627,31,'Soul Shock',180000,66),
(130,627,32,'Soul Shock',180000,66),
(130,510,1,'Deadly Roulette',350000,66),
(130,523,3,'Imbue Dark Seed',350000,66),
(130,525,4,'Decoy',350000,66),
(130,502,4,'Life to Soul',350000,66),
(130,516,4,'Slow Trap',350000,66),
(130,521,4,'Sharpshooting',350000,66),
(130,518,6,'Binding Trap',350000,66),
(130,509,25,'Bleeding Shot',180000,66),
(130,509,26,'Bleeding Shot',180000,66),
(130,467,19,'Soul Mastery',350000,66),
(130,626,4,'Critical Sense',350000,66),
(130,1510,1,'Soul Cleanse',350000,66),
(130,471,6,'Defuse Trap',350000,66),
(130,508,22,'Rising Shot',180000,66),
(130,508,23,'Rising Shot',180000,66),
(130,465,41,'Light Armor Mastery',180000,66),
(130,465,42,'Light Armor Mastery',180000,66),
(130,466,46,'Magic Immunity',180000,66),
(130,466,47,'Magic Immunity',180000,66),
(130,473,36,'Crossbow Mastery',180000,66),
(130,473,37,'Crossbow Mastery',180000,66),
(130,507,28,'Twin Shot',180000,66),
(130,507,29,'Twin Shot',180000,66),
(130,514,8,'Fire Trap',490000,68),
(130,835,1,'Imbue Seed of Destruction',490000,68),
(130,836,2,'Oblivion Trap',490000,68),
(130,627,33,'Soul Shock',240000,68),
(130,627,34,'Soul Shock',240000,68),
(130,510,2,'Deadly Roulette',490000,68),
(130,507,30,'Twin Shot',240000,68),
(130,507,31,'Twin Shot',240000,68),
(130,473,38,'Crossbow Mastery',240000,68),
(130,473,39,'Crossbow Mastery',240000,68),
(130,466,48,'Magic Immunity',240000,68),
(130,466,49,'Magic Immunity',240000,68),
(130,465,43,'Light Armor Mastery',240000,68),
(130,465,44,'Light Armor Mastery',240000,68),
(130,508,24,'Rising Shot',240000,68),
(130,508,25,'Rising Shot',240000,68),
(130,467,20,'Soul Mastery',490000,68),
(130,509,27,'Bleeding Shot',240000,68),
(130,509,28,'Bleeding Shot',240000,68),
(130,521,5,'Sharpshooting',490000,68),
(130,517,4,'Flash Trap',490000,68),
(130,515,5,'Poison Trap',490000,68),
(130,523,4,'Imbue Dark Seed',490000,68),
(130,835,2,'Imbue Seed of Destruction',580000,70),
(130,627,35,'Soul Shock',290000,70),
(130,627,36,'Soul Shock',290000,70),
(130,510,3,'Deadly Roulette',580000,70),
(130,523,5,'Imbue Dark Seed',580000,70),
(130,522,4,'Real Target',580000,70),
(130,525,5,'Decoy',580000,70),
(130,516,5,'Slow Trap',580000,70),
(130,521,6,'Sharpshooting',580000,70),
(130,518,7,'Binding Trap',580000,70),
(130,509,29,'Bleeding Shot',290000,70),
(130,509,30,'Bleeding Shot',290000,70),
(130,467,21,'Soul Mastery',580000,70),
(130,508,26,'Rising Shot',290000,70),
(130,508,27,'Rising Shot',290000,70),
(130,465,45,'Light Armor Mastery',290000,70),
(130,465,46,'Light Armor Mastery',290000,70),
(130,466,50,'Magic Immunity',290000,70),
(130,466,51,'Magic Immunity',290000,70),
(130,473,40,'Crossbow Mastery',290000,70),
(130,473,41,'Crossbow Mastery',290000,70),
(130,507,32,'Twin Shot',290000,70),
(130,507,33,'Twin Shot',290000,70),
(130,514,9,'Fire Trap',710000,72),
(130,835,3,'Imbue Seed of Destruction',710000,72),
(130,836,3,'Oblivion Trap',710000,72),
(130,627,37,'Soul Shock',350000,72),
(130,627,38,'Soul Shock',350000,72),
(130,510,4,'Deadly Roulette',710000,72),
(130,507,34,'Twin Shot',350000,72),
(130,507,35,'Twin Shot',350000,72),
(130,473,42,'Crossbow Mastery',350000,72),
(130,473,43,'Crossbow Mastery',350000,72),
(130,466,52,'Magic Immunity',350000,72),
(130,466,53,'Magic Immunity',350000,72),
(130,465,47,'Light Armor Mastery',350000,72),
(130,465,48,'Light Armor Mastery',350000,72),
(130,508,28,'Rising Shot',350000,72),
(130,508,29,'Rising Shot',350000,72),
(130,467,22,'Soul Mastery',710000,72),
(130,509,31,'Bleeding Shot',350000,72),
(130,509,32,'Bleeding Shot',350000,72),
(130,521,7,'Sharpshooting',710000,72),
(130,517,5,'Flash Trap',710000,72),
(130,515,6,'Poison Trap',710000,72),
(130,502,5,'Life to Soul',710000,72),
(130,523,6,'Imbue Dark Seed',710000,72),
(130,835,4,'Imbue Seed of Destruction',1400000,74),
(130,627,39,'Soul Shock',720000,74),
(130,627,40,'Soul Shock',720000,74),
(130,510,5,'Deadly Roulette',1400000,74),
(130,523,7,'Imbue Dark Seed',1400000,74),
(130,525,6,'Decoy',1400000,74),
(130,520,1,'Quiver of Bolts: S-Grade',720000,74),
(130,516,6,'Slow Trap',1400000,74),
(130,521,8,'Sharpshooting',1400000,74),
(130,518,8,'Binding Trap',1400000,74),
(130,509,33,'Bleeding Shot',720000,74),
(130,509,34,'Bleeding Shot',720000,74),
(130,467,23,'Soul Mastery',1400000,74),
(130,471,7,'Defuse Trap',1400000,74),
(130,508,30,'Rising Shot',720000,74),
(130,508,31,'Rising Shot',720000,74),
(130,465,49,'Light Armor Mastery',720000,74),
(130,465,50,'Light Armor Mastery',720000,74),
(130,466,54,'Magic Immunity',720000,74),
(130,466,55,'Magic Immunity',720000,74),
(130,473,44,'Crossbow Mastery',720000,74),
(130,473,45,'Crossbow Mastery',720000,74),
(130,507,36,'Twin Shot',720000,74),
(130,507,37,'Twin Shot',720000,74),
(131,328,1,'Wisdom',8340000,76),
(131,335,1,'Fortitude',8340000,76),
(131,329,1,'Health',8340000,76),
(131,330,1,'Skill Mastery',22000000,77),
(131,939,1,'Soul Rage',22000000,78),
(131,793,1,'Rush Impact',22000000,78),
(131,526,1,'Enuma Elish',22000000,78),
(131,538,1,'Final Form',80000000,79),
(131,794,1,'Mass Disarm',80000000,79),
(132,329,1,'Health',8300000,76),
(132,328,1,'Wisdom',8300000,76),
(132,1516,1,'Soul Strike',8300000,76),
(132,1512,1,'Soul Vortex',11000000,77),
(132,330,1,'Skill Mastery',11000000,77),
(132,939,1,'Soul Rage',32000000,78),
(132,1469,1,'Leopold',32000000,78),
(132,538,1,'Final Form',80000000,79),
(132,1513,1,'Soul Vortex Extinction',80000000,79),
(132,1515,1,'Lightning Barrier',150000000,80),
(133,329,1,'Health',8300000,76),
(133,328,1,'Wisdom',8300000,76),
(133,1516,1,'Soul Strike',8300000,76),
(133,1512,1,'Soul Vortex',11000000,77),
(133,330,1,'Skill Mastery',11000000,77),
(133,939,1,'Soul Rage',32000000,78),
(133,1469,1,'Leopold',32000000,78),
(133,538,1,'Final Form',80000000,79),
(133,1513,1,'Soul Vortex Extinction',80000000,79),
(133,1515,1,'Lightning Barrier',150000000,80),
(134,329,1,'Health',12500000,76),
(134,328,1,'Wisdom',12500000,76),
(134,330,1,'Skill Mastery',16000000,77),
(134,939,1,'Soul Rage',22000000,78),
(134,334,1,'Focus Skill Mastery',22000000,78),
(134,1470,1,'Prahnah',16000000,78),
(134,792,1,'Betrayal Mark',22000000,78),
(134,538,1,'Final Form',80000000,79),
(135,1527,1,'Expert Casting',44000,40),
(135,465,14,'Light Armor Mastery',14000,40),
(135,465,15,'Light Armor Mastery',14000,40),
(135,465,16,'Light Armor Mastery',14000,40),
(135,466,19,'Magic Immunity',14000,40),
(135,466,20,'Magic Immunity',14000,40),
(135,466,21,'Magic Immunity',14000,40),
(135,474,9,'Rapier Mastery',14000,40),
(135,474,10,'Rapier Mastery',14000,40),
(135,474,11,'Rapier Mastery',14000,40),
(135,504,1,'Triple Thrust',14000,40),
(135,504,2,'Triple Thrust',14000,40),
(135,504,3,'Triple Thrust',14000,40),
(135,467,9,'Soul Mastery',44000,40),
(135,502,1,'Life to Soul',44000,40),
(135,1476,1,'Appetite for Destruction',44000,40),
(135,1487,1,'Restoration',44000,40),
(135,832,1,'Fast Recovery',58000,43),
(135,1481,1,'Obilivion',58000,43),
(135,467,10,'Soul Mastery',58000,43),
(135,504,4,'Triple Thrust',19000,43),
(135,504,5,'Triple Thrust',19000,43),
(135,504,6,'Triple Thrust',19000,43),
(135,474,12,'Rapier Mastery',19000,43),
(135,474,13,'Rapier Mastery',19000,43),
(135,474,14,'Rapier Mastery',19000,43),
(135,466,22,'Magic Immunity',19000,43),
(135,466,23,'Magic Immunity',19000,43),
(135,466,24,'Magic Immunity',19000,43),
(135,465,17,'Light Armor Mastery',19000,43),
(135,465,18,'Light Armor Mastery',19000,43),
(135,465,19,'Light Armor Mastery',19000,43),
(135,625,1,'Soul Gathering',67000,46),
(135,465,20,'Light Armor Mastery',22000,46),
(135,465,21,'Light Armor Mastery',22000,46),
(135,465,22,'Light Armor Mastery',22000,46),
(135,466,25,'Magic Immunity',22000,46),
(135,466,26,'Magic Immunity',22000,46),
(135,466,27,'Magic Immunity',22000,46),
(135,474,15,'Rapier Mastery',22000,46),
(135,474,16,'Rapier Mastery',22000,46),
(135,474,17,'Rapier Mastery',22000,46),
(135,504,7,'Triple Thrust',22000,46),
(135,504,8,'Triple Thrust',22000,46),
(135,504,9,'Triple Thrust',22000,46),
(135,467,11,'Soul Mastery',67000,46),
(135,1487,2,'Restoration',67000,46),
(135,467,1,'Soul Mastery',67000,46),
(135,1483,1,'Thin Skin',67000,46),
(135,1478,1,'Protection Instinct',67000,46),
(135,1488,1,'Restoration Impact',98000,49),
(135,467,12,'Soul Mastery',98000,49),
(135,502,2,'Life to Soul',98000,49),
(135,1481,2,'Obilivion',98000,49),
(135,1476,2,'Appetite for Destruction',98000,49),
(135,505,1,'Shining Edge',33000,49),
(135,505,2,'Shining Edge',33000,49),
(135,505,3,'Shining Edge',33000,49),
(135,504,10,'Triple Thrust',33000,49),
(135,504,11,'Triple Thrust',33000,49),
(135,504,12,'Triple Thrust',33000,49),
(135,474,18,'Rapier Mastery',33000,49),
(135,474,19,'Rapier Mastery',33000,49),
(135,474,20,'Rapier Mastery',33000,49),
(135,466,28,'Magic Immunity',33000,49),
(135,466,29,'Magic Immunity',33000,49),
(135,466,30,'Magic Immunity',33000,49),
(135,465,23,'Light Armor Mastery',33000,49),
(135,465,24,'Light Armor Mastery',33000,49),
(135,465,25,'Light Armor Mastery',33000,49),
(135,465,26,'Light Armor Mastery',45000,52),
(135,465,27,'Light Armor Mastery',45000,52),
(135,465,28,'Light Armor Mastery',45000,52),
(135,466,31,'Magic Immunity',45000,52),
(135,466,32,'Magic Immunity',45000,52),
(135,466,33,'Magic Immunity',45000,52),
(135,474,21,'Rapier Mastery',45000,52),
(135,474,22,'Rapier Mastery',45000,52),
(135,474,23,'Rapier Mastery',45000,52),
(135,504,13,'Triple Thrust',45000,52),
(135,504,14,'Triple Thrust',45000,52),
(135,504,15,'Triple Thrust',45000,52),
(135,505,4,'Shining Edge',45000,52),
(135,505,5,'Shining Edge',45000,52),
(135,505,6,'Shining Edge',45000,52),
(135,492,1,'Spread Wing',45000,52),
(135,492,2,'Spread Wing',45000,52),
(135,492,3,'Spread Wing',45000,52),
(135,1477,1,'Vampiric Impulse',137000,52),
(135,467,13,'Soul Mastery',137000,52),
(135,1487,3,'Restoration',137000,52),
(135,1483,2,'Thin Skin',137000,52),
(135,467,14,'Soul Mastery',244000,55),
(135,1479,1,'Magic Impulse',244000,55),
(135,1481,3,'Obilivion',244000,55),
(135,492,4,'Spread Wing',81000,55),
(135,492,5,'Spread Wing',81000,55),
(135,492,6,'Spread Wing',81000,55),
(135,505,7,'Shining Edge',81000,55),
(135,505,8,'Shining Edge',81000,55),
(135,505,9,'Shining Edge',81000,55),
(135,504,16,'Triple Thrust',81000,55),
(135,504,17,'Triple Thrust',81000,55),
(135,504,18,'Triple Thrust',81000,55),
(135,474,24,'Rapier Mastery',81000,55),
(135,474,25,'Rapier Mastery',81000,55),
(135,474,26,'Rapier Mastery',81000,55),
(135,466,34,'Magic Immunity',81000,55),
(135,466,35,'Magic Immunity',81000,55),
(135,466,36,'Magic Immunity',81000,55),
(135,465,29,'Light Armor Mastery',81000,55),
(135,465,30,'Light Armor Mastery',81000,55),
(135,465,31,'Light Armor Mastery',81000,55),
(135,465,32,'Light Armor Mastery',67000,58),
(135,465,33,'Light Armor Mastery',67000,58),
(135,465,34,'Light Armor Mastery',67000,58),
(135,466,37,'Magic Immunity',67000,58),
(135,466,38,'Magic Immunity',67000,58),
(135,466,39,'Magic Immunity',67000,58),
(135,474,27,'Rapier Mastery',67000,58),
(135,474,28,'Rapier Mastery',67000,58),
(135,474,29,'Rapier Mastery',67000,58),
(135,504,19,'Triple Thrust',67000,58),
(135,504,20,'Triple Thrust',67000,58),
(135,504,21,'Triple Thrust',67000,58),
(135,505,10,'Shining Edge',67000,58),
(135,505,11,'Shining Edge',67000,58),
(135,505,12,'Shining Edge',67000,58),
(135,492,7,'Spread Wing',67000,58),
(135,492,8,'Spread Wing',67000,58),
(135,492,9,'Spread Wing',67000,58),
(135,1476,3,'Appetite for Destruction',200000,58),
(135,467,15,'Soul Mastery',200000,58),
(135,502,3,'Life to Soul',200000,58),
(135,1483,3,'Thin Skin',200000,58),
(135,1487,4,'Restoration',200000,58),
(135,1488,2,'Restoration Impact',241000,60),
(135,1484,1,'Enervation',241000,60),
(135,1478,2,'Protection Instinct',241000,60),
(135,467,16,'Soul Mastery',241000,60),
(135,1481,4,'Obilivion',241000,60),
(135,492,10,'Spread Wing',121000,60),
(135,492,11,'Spread Wing',121000,60),
(135,505,13,'Shining Edge',121000,60),
(135,505,14,'Shining Edge',121000,60),
(135,504,22,'Triple Thrust',121000,60),
(135,504,23,'Triple Thrust',121000,60),
(135,474,30,'Rapier Mastery',121000,60),
(135,474,31,'Rapier Mastery',121000,60),
(135,466,40,'Magic Immunity',121000,60),
(135,466,41,'Magic Immunity',121000,60),
(135,465,35,'Light Armor Mastery',121000,60),
(135,465,36,'Light Armor Mastery',121000,60),
(135,465,37,'Light Armor Mastery',180000,62),
(135,465,38,'Light Armor Mastery',180000,62),
(135,466,42,'Magic Immunity',180000,62),
(135,466,43,'Magic Immunity',180000,62),
(135,474,32,'Rapier Mastery',180000,62),
(135,474,33,'Rapier Mastery',180000,62),
(135,504,24,'Triple Thrust',180000,62),
(135,504,25,'Triple Thrust',180000,62),
(135,505,15,'Shining Edge',180000,62),
(135,505,16,'Shining Edge',180000,62),
(135,492,12,'Spread Wing',180000,62),
(135,492,13,'Spread Wing',180000,62),
(135,1482,1,'Weak Constitution',360000,62),
(135,1479,2,'Magic Impulse',360000,62),
(135,467,17,'Soul Mastery',360000,62),
(135,1483,4,'Thin Skin',360000,62),
(135,1487,5,'Restoration',360000,62),
(135,1484,2,'Enervation',480000,64),
(135,467,18,'Soul Mastery',480000,64),
(135,1477,2,'Vampiric Impulse',480000,64),
(135,1481,5,'Obilivion',480000,64),
(135,492,14,'Spread Wing',240000,64),
(135,492,15,'Spread Wing',240000,64),
(135,505,17,'Shining Edge',240000,64),
(135,505,18,'Shining Edge',240000,64),
(135,504,26,'Triple Thrust',240000,64),
(135,504,27,'Triple Thrust',240000,64),
(135,474,34,'Rapier Mastery',240000,64),
(135,474,35,'Rapier Mastery',240000,64),
(135,466,44,'Magic Immunity',240000,64),
(135,466,45,'Magic Immunity',240000,64),
(135,465,39,'Light Armor Mastery',240000,64),
(135,465,40,'Light Armor Mastery',240000,64),
(135,465,41,'Light Armor Mastery',250000,66),
(135,465,42,'Light Armor Mastery',250000,66),
(135,466,46,'Magic Immunity',250000,66),
(135,466,47,'Magic Immunity',250000,66),
(135,474,36,'Rapier Mastery',250000,66),
(135,474,37,'Rapier Mastery',250000,66),
(135,504,28,'Triple Thrust',250000,66),
(135,504,29,'Triple Thrust',250000,66),
(135,505,19,'Shining Edge',250000,66),
(135,505,20,'Shining Edge',250000,66),
(135,492,16,'Spread Wing',250000,66),
(135,492,17,'Spread Wing',250000,66),
(135,1482,2,'Weak Constitution',500000,66),
(135,467,19,'Soul Mastery',500000,66),
(135,502,4,'Life to Soul',500000,66),
(135,1483,5,'Thin Skin',500000,66),
(135,1485,1,'Spite',500000,66),
(135,1487,6,'Restoration',500000,66),
(135,1510,1,'Soul Cleanse',500000,66),
(135,1488,3,'Restoration Impact',650000,68),
(135,1486,1,'Mental Impoverish',650000,68),
(135,1484,3,'Enervation',650000,68),
(135,467,20,'Soul Mastery',650000,68),
(135,1481,6,'Obilivion',650000,68),
(135,1479,3,'Magic Impulse',650000,68),
(135,492,18,'Spread Wing',330000,68),
(135,492,19,'Spread Wing',330000,68),
(135,505,21,'Shining Edge',330000,68),
(135,505,22,'Shining Edge',330000,68),
(135,504,30,'Triple Thrust',330000,68),
(135,504,31,'Triple Thrust',330000,68),
(135,474,38,'Rapier Mastery',330000,68),
(135,474,39,'Rapier Mastery',330000,68),
(135,466,48,'Magic Immunity',330000,68),
(135,466,49,'Magic Immunity',330000,68),
(135,465,43,'Light Armor Mastery',330000,68),
(135,465,44,'Light Armor Mastery',330000,68),
(135,465,45,'Light Armor Mastery',360000,70),
(135,465,46,'Light Armor Mastery',360000,70),
(135,466,50,'Magic Immunity',360000,70),
(135,466,51,'Magic Immunity',360000,70),
(135,474,40,'Rapier Mastery',360000,70),
(135,474,41,'Rapier Mastery',360000,70),
(135,504,32,'Triple Thrust',360000,70),
(135,504,33,'Triple Thrust',360000,70),
(135,505,23,'Shining Edge',360000,70),
(135,505,24,'Shining Edge',360000,70),
(135,492,20,'Spread Wing',360000,70),
(135,492,21,'Spread Wing',360000,70),
(135,1480,1,'Soul Harmony',720000,70),
(135,1482,3,'Weak Constitution',720000,70),
(135,467,21,'Soul Mastery',720000,70),
(135,1483,6,'Thin Skin',720000,70),
(135,1486,2,'Mental Impoverish',720000,70),
(135,1485,2,'Spite',720000,70),
(135,1487,7,'Restoration',720000,70),
(135,1486,3,'Mental Impoverish',1000000,72),
(135,1484,4,'Enervation',1000000,72),
(135,467,22,'Soul Mastery',1000000,72),
(135,502,5,'Life to Soul',1000000,72),
(135,1481,7,'Obilivion',1000000,72),
(135,1477,3,'Vampiric Impulse',1000000,72),
(135,492,22,'Spread Wing',500000,72),
(135,492,23,'Spread Wing',500000,72),
(135,505,25,'Shining Edge',500000,72),
(135,505,26,'Shining Edge',500000,72),
(135,504,34,'Triple Thrust',500000,72),
(135,504,35,'Triple Thrust',500000,72),
(135,474,42,'Rapier Mastery',500000,72),
(135,474,43,'Rapier Mastery',500000,72),
(135,466,52,'Magic Immunity',500000,72),
(135,466,53,'Magic Immunity',500000,72),
(135,465,47,'Light Armor Mastery',500000,72),
(135,465,48,'Light Armor Mastery',500000,72),
(135,465,49,'Light Armor Mastery',1180000,74),
(135,465,50,'Light Armor Mastery',1180000,74),
(135,466,54,'Magic Immunity',1180000,74),
(135,466,55,'Magic Immunity',1180000,74),
(135,474,44,'Rapier Mastery',1180000,74),
(135,474,45,'Rapier Mastery',1180000,74),
(135,504,36,'Triple Thrust',1180000,74),
(135,504,37,'Triple Thrust',1180000,74),
(135,505,27,'Shining Edge',1180000,74),
(135,505,28,'Shining Edge',1180000,74),
(135,492,24,'Spread Wing',1180000,74),
(135,492,25,'Spread Wing',1180000,74),
(135,1482,4,'Weak Constitution',2360000,74),
(135,467,23,'Soul Mastery',2360000,74),
(135,1486,4,'Mental Impoverish',2360000,74),
(135,1485,3,'Spite',2360000,74),
(135,1487,8,'Restoration',2360000,74),
(136,329,1,'Health',12500000,76),
(136,328,1,'Wisdom',12500000,76),
(136,330,1,'Skill Mastery',14700000,77),
(136,939,1,'Soul Rage',64000000,78),
(136,538,1,'Final Form',80000000,79),
(136,1515,1,'Lightning Barrier',150000000,80),

-- Create Item 172 (Done by DJ MELERIX)

(53,172,1,'Create Item',310,5),
(56,172,2,'Create Item',3700,20),
(56,172,3,'Create Item',13000,28),
(56,172,4,'Create Item',34000,36),
(57,172,5,'Create Item',46000,43),
(57,172,6,'Create Item',98000,49),
(57,172,7,'Create Item',189000,55),
(57,172,8,'Create Item',400000,62),
(57,172,9,'Create Item',870000,70),

-- Lucky 194 (Done by DJ MELERIX)

(0,194,1,'Lucky',0,1),
(10,194,1,'Lucky',0,1),
(18,194,1,'Lucky',0,1),
(25,194,1,'Lucky',0,1),
(31,194,1,'Lucky',0,1),
(38,194,1,'Lucky',0,1),
(44,194,1,'Lucky',0,1),
(49,194,1,'Lucky',0,1),
(53,194,1,'Lucky',0,1),
(123,194,1,'Lucky',0,1),
(124,194,1,'Lucky',0,1),

-- Expertise 239 D,C,B,A,S,S80,S84 (Done by DJ MELERIX)

(0,239,1,'Expertise D',0,20),
(0,239,2,'Expertise C',0,40),
(0,239,3,'Expertise B',0,52),
(0,239,4,'Expertise A',0,61),
(0,239,5,'Expertise S',0,76),
(0,239,6,'Expertise S80',0,80),
(0,239,7,'Expertise S84',0,84),
(10,239,1,'Expertise D',0,20),
(10,239,2,'Expertise C',0,40),
(10,239,3,'Expertise B',0,52),
(10,239,4,'Expertise A',0,61),
(10,239,5,'Expertise S',0,76),
(10,239,6,'Expertise S80',0,80),
(10,239,7,'Expertise S84',0,84),
(18,239,1,'Expertise D',0,20),
(18,239,2,'Expertise C',0,40),
(18,239,3,'Expertise B',0,52),
(18,239,4,'Expertise A',0,61),
(18,239,5,'Expertise S',0,76),
(18,239,6,'Expertise S80',0,80),
(18,239,7,'Expertise S84',0,84),
(25,239,1,'Expertise D',0,20),
(25,239,2,'Expertise C',0,40),
(25,239,3,'Expertise B',0,52),
(25,239,4,'Expertise A',0,61),
(25,239,5,'Expertise S',0,76),
(25,239,6,'Expertise S80',0,80),
(25,239,7,'Expertise S84',0,84),
(31,239,1,'Expertise D',0,20),
(31,239,2,'Expertise C',0,40),
(31,239,3,'Expertise B',0,52),
(31,239,4,'Expertise A',0,61),
(31,239,5,'Expertise S',0,76),
(31,239,6,'Expertise S80',0,80),
(31,239,7,'Expertise S84',0,84),
(38,239,1,'Expertise D',0,20),
(38,239,2,'Expertise C',0,40),
(38,239,3,'Expertise B',0,52),
(38,239,4,'Expertise A',0,61),
(38,239,5,'Expertise S',0,76),
(38,239,6,'Expertise S80',0,80),
(38,239,7,'Expertise S84',0,84),
(44,239,1,'Expertise D',0,20),
(44,239,2,'Expertise C',0,40),
(44,239,3,'Expertise B',0,52),
(44,239,4,'Expertise A',0,61),
(44,239,5,'Expertise S',0,76),
(44,239,6,'Expertise S80',0,80),
(44,239,7,'Expertise S84',0,84),
(49,239,1,'Expertise D',0,20),
(49,239,2,'Expertise C',0,40),
(49,239,3,'Expertise B',0,52),
(49,239,4,'Expertise A',0,61),
(49,239,5,'Expertise S',0,76),
(49,239,6,'Expertise S80',0,80),
(49,239,7,'Expertise S84',0,84),
(53,239,1,'Expertise D',0,20),
(53,239,2,'Expertise C',0,40),
(53,239,3,'Expertise B',0,52),
(53,239,4,'Expertise A',0,61),
(53,239,5,'Expertise S',0,76),
(53,239,6,'Expertise S80',0,80),
(53,239,7,'Expertise S84',0,84),
(123,239,1,'Expertise D',0,20),
(123,239,2,'Expertise C',0,40),
(123,239,3,'Expertise B',0,52),
(123,239,4,'Expertise A',0,61),
(123,239,5,'Expertise S',0,76),
(123,239,6,'Expertise S80',0,80),
(123,239,7,'Expertise S84',0,84),
(124,239,1,'Expertise D',0,20),
(124,239,2,'Expertise C',0,40),
(124,239,3,'Expertise B',0,52),
(124,239,4,'Expertise A',0,61),
(124,239,5,'Expertise S',0,76),
(124,239,6,'Expertise S80',0,80),
(124,239,7,'Expertise S84',0,84),

-- Create Common Item 1320 (Done by DJ MELERIX)

(0,1320,1,'Create Common Item',0,1),
(0,1320,2,'Create Common Item',0,20),
(0,1320,3,'Create Common Item',0,28),
(0,1320,4,'Create Common Item',0,36),
(0,1320,5,'Create Common Item',0,43),
(0,1320,6,'Create Common Item',0,49),
(0,1320,7,'Create Common Item',0,55),
(0,1320,8,'Create Common Item',0,62),
(0,1320,9,'Create Common Item',0,70),
(10,1320,1,'Create Common Item',0,1),
(10,1320,2,'Create Common Item',0,20),
(10,1320,3,'Create Common Item',0,28),
(10,1320,4,'Create Common Item',0,36),
(10,1320,5,'Create Common Item',0,43),
(10,1320,6,'Create Common Item',0,49),
(10,1320,7,'Create Common Item',0,55),
(10,1320,8,'Create Common Item',0,62),
(10,1320,9,'Create Common Item',0,70),
(18,1320,1,'Create Common Item',0,1),
(18,1320,2,'Create Common Item',0,20),
(18,1320,3,'Create Common Item',0,28),
(18,1320,4,'Create Common Item',0,36),
(18,1320,5,'Create Common Item',0,43),
(18,1320,6,'Create Common Item',0,49),
(18,1320,7,'Create Common Item',0,55),
(18,1320,8,'Create Common Item',0,62),
(18,1320,9,'Create Common Item',0,70),
(25,1320,1,'Create Common Item',0,1),
(25,1320,2,'Create Common Item',0,20),
(25,1320,3,'Create Common Item',0,28),
(25,1320,4,'Create Common Item',0,36),
(25,1320,5,'Create Common Item',0,43),
(25,1320,6,'Create Common Item',0,49),
(25,1320,7,'Create Common Item',0,55),
(25,1320,8,'Create Common Item',0,62),
(25,1320,9,'Create Common Item',0,70),
(31,1320,1,'Create Common Item',0,1),
(31,1320,2,'Create Common Item',0,20),
(31,1320,3,'Create Common Item',0,28),
(31,1320,4,'Create Common Item',0,36),
(31,1320,5,'Create Common Item',0,43),
(31,1320,6,'Create Common Item',0,49),
(31,1320,7,'Create Common Item',0,55),
(31,1320,8,'Create Common Item',0,62),
(31,1320,9,'Create Common Item',0,70),
(38,1320,1,'Create Common Item',0,1),
(38,1320,2,'Create Common Item',0,20),
(38,1320,3,'Create Common Item',0,28),
(38,1320,4,'Create Common Item',0,36),
(38,1320,5,'Create Common Item',0,43),
(38,1320,6,'Create Common Item',0,49),
(38,1320,7,'Create Common Item',0,55),
(38,1320,8,'Create Common Item',0,62),
(38,1320,9,'Create Common Item',0,70),
(44,1320,1,'Create Common Item',0,1),
(44,1320,2,'Create Common Item',0,20),
(44,1320,3,'Create Common Item',0,28),
(44,1320,4,'Create Common Item',0,36),
(44,1320,5,'Create Common Item',0,43),
(44,1320,6,'Create Common Item',0,49),
(44,1320,7,'Create Common Item',0,55),
(44,1320,8,'Create Common Item',0,62),
(44,1320,9,'Create Common Item',0,70),
(49,1320,1,'Create Common Item',0,1),
(49,1320,2,'Create Common Item',0,20),
(49,1320,3,'Create Common Item',0,28),
(49,1320,4,'Create Common Item',0,36),
(49,1320,5,'Create Common Item',0,43),
(49,1320,6,'Create Common Item',0,49),
(49,1320,7,'Create Common Item',0,55),
(49,1320,8,'Create Common Item',0,62),
(49,1320,9,'Create Common Item',0,70),
(53,1320,1,'Create Common Item',0,1),
(53,1320,2,'Create Common Item',0,20),
(53,1320,3,'Create Common Item',0,28),
(53,1320,4,'Create Common Item',0,36),
(53,1320,5,'Create Common Item',0,43),
(53,1320,6,'Create Common Item',0,49),
(53,1320,7,'Create Common Item',0,55),
(53,1320,8,'Create Common Item',0,62),
(53,1320,9,'Create Common Item',0,70),
(123,1320,9,'Create Common Item',0,70),
(124,1320,9,'Create Common Item',0,70),

-- Dwarven Craft 1321 (Done by DJ MELERIX)

(53,1321,1,'Dwarven Craft',0,1),

-- Common Craft 1322 (Done by DJ MELERIX)

(0,1322,1,'Common Craft',0,1),
(10,1322,1,'Common Craft',0,1),
(18,1322,1,'Common Craft',0,1),
(25,1322,1,'Common Craft',0,1),
(31,1322,1,'Common Craft',0,1),
(38,1322,1,'Common Craft',0,1),
(44,1322,1,'Common Craft',0,1),
(49,1322,1,'Common Craft',0,1),
(53,1322,1,'Common Craft',0,1),
(123,1322,1,'Common Craft',0,1),
(124,1322,1,'Common Craft',0,1),

-- Divine Inspiration (Done by Amon & Scarlet)

(0,1405,1,'Divine Inspiration',0,52),
(0,1405,2,'Divine Inspiration',0,61),
(0,1405,3,'Divine Inspiration',0,76),
(0,1405,4,'Divine Inspiration',0,76),
(10,1405,1,'Divine Inspiration',0,52),
(10,1405,2,'Divine Inspiration',0,61),
(10,1405,3,'Divine Inspiration',0,76),
(10,1405,4,'Divine Inspiration',0,76),
(18,1405,1,'Divine Inspiration',0,52),
(18,1405,2,'Divine Inspiration',0,61),
(18,1405,3,'Divine Inspiration',0,76),
(18,1405,4,'Divine Inspiration',0,76),
(25,1405,1,'Divine Inspiration',0,52),
(25,1405,2,'Divine Inspiration',0,61),
(25,1405,3,'Divine Inspiration',0,76),
(25,1405,4,'Divine Inspiration',0,76),
(31,1405,1,'Divine Inspiration',0,52),
(31,1405,2,'Divine Inspiration',0,61),
(31,1405,3,'Divine Inspiration',0,76),
(31,1405,4,'Divine Inspiration',0,76),
(38,1405,1,'Divine Inspiration',0,52),
(38,1405,2,'Divine Inspiration',0,61),
(38,1405,3,'Divine Inspiration',0,76),
(38,1405,4,'Divine Inspiration',0,76),
(44,1405,1,'Divine Inspiration',0,52),
(44,1405,2,'Divine Inspiration',0,61),
(44,1405,3,'Divine Inspiration',0,76),
(44,1405,4,'Divine Inspiration',0,76),
(49,1405,1,'Divine Inspiration',0,52),
(49,1405,2,'Divine Inspiration',0,61),
(49,1405,3,'Divine Inspiration',0,76),
(49,1405,4,'Divine Inspiration',0,76),
(53,1405,1,'Divine Inspiration',0,52),
(53,1405,2,'Divine Inspiration',0,61),
(53,1405,3,'Divine Inspiration',0,76),
(53,1405,4,'Divine Inspiration',0,76),
(123,1405,1,'Divine Inspiration',0,52),
(123,1405,2,'Divine Inspiration',0,61),
(123,1405,3,'Divine Inspiration',0,76),
(123,1405,4,'Divine Inspiration',0,76),
(124,1405,1,'Divine Inspiration',0,52),
(124,1405,2,'Divine Inspiration',0,61),
(124,1405,3,'Divine Inspiration',0,76),
(124,1405,4,'Divine Inspiration',0,76);