DROP TABLE IF EXISTS `zone_vertices`;
CREATE TABLE `zone_vertices` (
  `id` int(11) NOT NULL,
  `order` int(11) NOT NULL,
  `x` int(11) NOT NULL,
  `y` int(11) NOT NULL,
  PRIMARY KEY (`id`,`order`)
);

-- NOTE: Cuboid shapes only need 2 points in order to be defined.
-- That is their NorthWest and SouthEast corners suffice to descript a cuboid.
-- All other shapes require 3 or more vertices.
-- NOTE 2: The order is outmost important for many shapes and thus special
-- care is recommended.  Order doesn't really matter much for cuboids and prisms
-- (triangular base) but it is best to pay attention to the order there, too,
-- keeping the definitions as much as possible in a loop from NW to SE.

INSERT INTO `zone_vertices` (`id`,`order`,`x`,`y`) VALUES 
(11000,0,-117072,-252544),
(11000,1,-112080,-247536),
(11001,0,11718,181534),
(11001,1,13308,181332),
(11001,2,13297,181318),
(11001,3,14061,181319),
(11001,4,14081,181573),
(11001,5,14408,181569),
(11001,6,14403,182670),
(11001,7,14073,182669),
(11001,8,14077,182927),
(11001,9,13553,182926),
(11001,10,13554,182616),
(11001,11,13216,182780),
(11001,12,13200,184270),
(11001,13,11693,184265),
(11001,14,11694,184011),
(11001,15,12940,184013),
(11001,16,12945,183015),
(11001,17,11946,183009),
(11001,18,11948,184007),
(11001,19,11695,184011),
(11010,0,72496,142272),
(11010,1,73472,143248),
(11011,0,-88416,141728),
(11011,1,-87440,142704),
(11012,0,147784,45100),
(11012,1,151220,45100),
(11012,2,151220,46200),
(11012,3,150960,46500),
(11012,4,150960,46940),
(11012,5,151220,47240),
(11012,6,151220,48200),
(11012,7,147784,48200),
(11012,8,147784,47240),
(11012,9,148040,46940),
(11012,10,148040,46500),
(11012,11,147784,46200),
(11013,0,11948,183015),
(11013,1,12939,184015),
(11020,0,77170,147420),
(11020,1,79200,147420),
(11020,2,79200,144780),
(11020,3,80310,144780),
(11020,4,80310,143630),
(11020,5,83120,143630),
(11020,6,83120,143505),
(11020,7,83700,143505),
(11020,8,83700,141500),
(11020,9,84070,141500),
(11020,10,84070,143505),
(11020,11,85040,143505),
(11020,12,85040,145760),
(11020,13,86115,145760),
(11020,14,86115,146910),
(11020,15,88425,146910),
(11020,16,88425,147175),
(11020,17,90430,147175),
(11020,18,90430,147540),
(11020,19,88425,147540),
(11020,20,88425,150050),
(11020,21,86495,150050),
(11020,22,86495,150250),
(11020,23,85995,150250),
(11020,24,85995,152250),
(11020,25,86780,152250),
(11020,26,86780,153600),
(11020,27,84850,153600),
(11020,28,84850,152250),
(11020,29,85625,152250),
(11020,30,85265,150250),
(11020,31,85085,150250),
(11020,32,85085,149875),
(11020,33,83680,149875),
(11020,34,83680,149920),
(11020,35,83500,149920),
(11020,36,83500,151270),
(11020,37,82705,151270),
(11020,38,82705,152820),
(11020,39,79195,152820),
(11020,40,79195,149805),
(11020,41,77170,149805),
(11021,0,15704,15397),
(11021,1,15765,15878),
(11021,2,15801,16332),
(11021,3,14098,19672),
(11021,4,10278,20689),
(11021,5,8852,20421),
(11021,6,7484,18628),
(11021,7,7236,18042),
(11021,8,7141,17507),
(11021,9,7045,16819),
(11021,10,7382,14486),
(11021,11,13891,13025),
(11021,12,15542,15230),
(11022,0,-83739,245733),
(11022,1,-84049,246087),
(11022,2,-84289,246258),
(11022,3,-84556,246243),
(11022,4,-84984,245820),
(11022,5,-85336,245426),
(11022,6,-85684,245099),
(11022,7,-85969,244770),
(11022,8,-86400,244292),
(11022,9,-86664,243997),
(11022,10,-86940,243631),
(11022,11,-87517,243034),
(11022,12,-87650,242799),
(11022,13,-87613,242572),
(11022,14,-87348,242246),
(11022,15,-86956,241942),
(11022,16,-86656,241684),
(11022,17,-86343,241365),
(11022,18,-85829,240966),
(11022,19,-85544,240765),
(11022,20,-85193,240440),
(11022,21,-84865,240185),
(11022,22,-84594,239866),
(11022,23,-84284,239666),
(11022,24,-84002,239734),
(11022,25,-83822,239922),
(11022,26,-83640,240190),
(11022,27,-83295,240492),
(11022,28,-82990,240878),
(11022,29,-82635,241208),
(11022,30,-82234,241698),
(11022,31,-82027,241985),
(11022,32,-81684,242328),
(11022,33,-81421,242741),
(11022,34,-81113,243073),
(11022,35,-81011,243228),
(11022,36,-81029,243496),
(11022,37,-81340,243797),
(11022,38,-81691,244028),
(11022,39,-82292,244585),
(11022,40,-82787,244999),
(11022,41,-83726,245721),
(11023,0,45364,46535),
(11023,1,45895,46578),
(11023,2,46388,46713),
(11023,3,46861,46934),
(11023,4,47290,47232),
(11023,5,47659,47598),
(11023,6,47959,48024),
(11023,7,48182,48499),
(11023,8,48318,49006),
(11023,9,48364,49523),
(11023,10,48319,50048),
(11023,11,48186,50548),
(11023,12,47963,51022),
(11023,13,47661,51450),
(11023,14,47286,51836),
(11023,15,46864,52126),
(11023,16,46398,52345),
(11023,17,46313,52598),
(11023,18,45768,52597),
(11023,19,45735,52665),
(11023,20,45651,52791),
(11023,21,45520,52878),
(11023,22,45363,52912),
(11023,23,45210,52882),
(11023,24,45077,52794),
(11023,25,44993,52667),
(11023,26,44961,52600),
(11023,27,44422,52600),
(11023,28,44342,52347),
(11023,29,43867,52131),
(11023,30,43438,51827),
(11023,31,43075,51458),
(11023,32,42766,51019),
(11023,33,42546,50557),
(11023,34,42412,50051),
(11023,35,42367,49530),
(11023,36,42410,49012),
(11023,37,42547,48509),
(11023,38,42769,48034),
(11023,39,43065,47602),
(11023,40,43437,47232),
(11023,41,43859,46937),
(11023,42,44336,46713),
(11023,43,44843,46575),
(11023,44,45395,46530),
(11024,0,-45528,-110079),
(11024,1,-45711,-110075),
(11024,2,-45704,-110164),
(11024,3,-46633,-110080),
(11024,4,-46625,-109992),
(11024,5,-46803,-109993),
(11024,6,-47345,-109973),
(11024,7,-47388,-110012),
(11024,8,-47388,-113001),
(11024,9,-47351,-113039),
(11024,10,-47102,-113038),
(11024,11,-47107,-113382),
(11024,12,-47326,-113379),
(11024,13,-47326,-113829),
(11024,14,-47114,-113826),
(11024,15,-47102,-114171),
(11024,16,-47350,-114170),
(11024,17,-47388,-114199),
(11024,18,-47391,-117182),
(11024,19,-47339,-117239),
(11024,20,-46791,-117240),
(11024,21,-46607,-117240),
(11024,22,-46619,-117151),
(11024,23,-45701,-117000),
(11024,24,-45705,-117085),
(11024,25,-45523,-117088),
(11024,26,-44169,-116722),
(11024,27,-44147,-116804),
(11024,28,-43838,-116717),
(11024,29,-43855,-116638),
(11024,30,-43779,-116620),
(11024,31,-42581,-115424),
(11024,32,-42472,-115258),
(11024,33,-42051,-113671),
(11024,34,-42050,-113502),
(11024,35,-42474,-111925),
(11024,36,-42554,-111775),
(11024,37,-43843,-110456),
(11024,38,-44147,-110375),
(11024,39,-45529,-110078),
(11025,0,-84867,149371),
(11025,1,-82581,149364),
(11025,2,-82499,149139),
(11025,3,-81593,149177),
(11025,4,-81551,149410),
(11025,5,-79270,149392),
(11025,6,-79275,150365),
(11025,7,-79055,150368),
(11025,8,-78820,150429),
(11025,9,-78644,150595),
(11025,10,-78558,150837),
(11025,11,-78567,152410),
(11025,12,-78796,152420),
(11025,13,-78803,154319),
(11025,14,-77131,155437),
(11025,15,-78190,156459),
(11025,16,-79978,156104),
(11025,17,-84876,156106),
(11025,18,-84875,149371),
(11026,0,115499,-176771),
(11026,1,115301,-176769),
(11026,2,114877,-176811),
(11026,3,113385,-177602),
(11026,4,112934,-178507),
(11026,5,113954,-183578),
(11026,6,115493,-183698),
(11026,7,115748,-184078),
(11026,8,115936,-184197),
(11026,9,116268,-184243),
(11026,10,116716,-184246),
(11026,11,117023,-184162),
(11026,12,117211,-184022),
(11026,13,117325,-183825),
(11026,14,117490,-183411),
(11026,15,117629,-182930),
(11026,16,117762,-182686),
(11026,17,117762,-182260),
(11026,18,117734,-182090),
(11026,19,117531,-181747),
(11026,20,117452,-180534),
(11026,21,117492,-180010),
(11026,22,117466,-179559),
(11026,23,117327,-179170),
(11026,24,117328,-178966),
(11026,25,117303,-178695),
(11026,26,116860,-177230),
(11026,27,116806,-177131),
(11026,28,116650,-176975),
(11026,29,116418,-176887),
(11026,30,115929,-176804),
(11026,31,115490,-176767),
(11027,0,-14960,121148),
(11027,1,-14875,121120),
(11027,2,-14717,121106),
(11027,3,-14394,121109),
(11027,4,-14242,121104),
(11027,5,-12659,121098),
(11027,6,-12025,121767),
(11027,7,-12024,123944),
(11027,8,-12277,124668),
(11027,9,-12648,125573),
(11027,10,-12879,126199),
(11027,11,-13855,126470),
(11027,12,-14484,126463),
(11027,13,-15236,126178),
(11027,14,-16126,125356),
(11027,15,-16531,124493),
(11027,16,-16537,123850),
(11027,17,-16492,123330),
(11027,18,-16194,123160),
(11027,19,-16057,123101),
(11027,20,-15327,122741),
(11027,21,-14958,121150),
(11028,0,15264,141764),
(11028,1,15434,143574),
(11028,2,15760,144707),
(11028,3,15846,145302),
(11028,4,16134,146850),
(11028,5,16715,147153),
(11028,6,17844,147640),
(11028,7,18139,147138),
(11028,8,18541,146758),
(11028,9,18782,146598),
(11028,10,19069,146521),
(11028,11,19430,146485),
(11028,12,20363,146421),
(11028,13,20722,146319),
(11028,14,21415,146319),
(11028,15,21402,145011),
(11028,16,21381,143675),
(11028,17,20696,142841),
(11028,18,20380,142492),
(11028,19,19060,142463),
(11028,20,18821,142512),
(11028,21,17885,143046),
(11028,22,17447,143348),
(11028,23,17019,144028),
(11028,24,16780,142908),
(11028,25,17344,142847),
(11028,26,17327,142650),
(11028,27,17483,142634),
(11028,28,17396,141776),
(11028,29,17238,141792),
(11028,30,17218,141574),
(11028,31,15265,141765),
(11029,0,84014,52245),
(11029,1,84138,54683),
(11029,2,84143,55029),
(11029,3,84001,57029),
(11029,4,81773,57023),
(11029,5,81795,56237),
(11029,6,81239,56236),
(11029,7,81282,56892),
(11029,8,81187,56904),
(11029,9,81105,57179),
(11029,10,79195,57167),
(11029,11,78986,57076),
(11029,12,78844,55218),
(11029,13,78843,54882),
(11029,14,79148,54560),
(11029,15,79660,54556),
(11029,16,79662,53994),
(11029,17,79002,53990),
(11029,18,78963,53359),
(11029,19,78959,53070),
(11029,20,79027,52125),
(11029,21,79628,52070),
(11029,22,80547,52068),
(11029,23,80835,52116),
(11029,24,80733,53068),
(11029,25,81306,53070),
(11029,26,81369,52310),
(11029,27,82605,52244),
(11029,28,84010,52250),
(11030,0,115318,74260),
(11030,1,115019,74495),
(11030,2,113919,75365),
(11030,3,114386,77505),
(11030,4,114653,78197),
(11030,5,115063,80068),
(11030,6,117015,81804),
(11030,7,120527,81006),
(11030,8,121485,79049),
(11030,9,121631,74718),
(11030,10,119999,74209),
(11030,11,118499,74097),
(11030,12,117946,74068),
(11030,13,117404,73671),
(11030,14,115622,74026),
(11030,15,115328,74252),
(11031,0,143209,25727),
(11031,1,143209,26975),
(11031,2,143463,27286),
(11031,3,143473,30074),
(11031,4,144386,30947),
(11031,5,146209,30946),
(11031,6,146649,31179),
(11031,7,146830,31508),
(11031,8,148081,31511),
(11031,9,148275,31176),
(11031,10,148696,30937),
(11031,11,150367,30942),
(11031,12,151289,30008),
(11031,13,151233,25914),
(11031,14,151399,25719),
(11031,15,151403,24470),
(11031,16,151205,24271),
(11031,17,151198,21168),
(11031,18,150233,20225),
(11031,19,148287,20227),
(11031,20,148086,19992),
(11031,21,146836,19992),
(11031,22,146642,20199),
(11031,23,144429,20204),
(11031,24,143459,21124),
(11031,25,143446,25542),
(11031,26,143198,25731),
(11032,0,144345,-53353),
(11032,1,145283,-52411),
(11032,2,146840,-51665),
(11032,3,148575,-51659),
(11032,4,150128,-52405),
(11032,5,151075,-53362),
(11032,6,152091,-54735),
(11032,7,151974,-55898),
(11032,8,151852,-56567),
(11032,9,151737,-57217),
(11032,10,151608,-57387),
(11032,11,151239,-57131),
(11032,12,150447,-58201),
(11032,13,150832,-58488),
(11032,14,150551,-58851),
(11032,15,148717,-59764),
(11032,16,148590,-59759),
(11032,17,148590,-59291),
(11032,18,146839,-59291),
(11032,19,146842,-59768),
(11032,20,146700,-59766),
(11032,21,144860,-58848),
(11032,22,144589,-58489),
(11032,23,144967,-58193),
(11032,24,144179,-57141),
(11032,25,143807,-57392),
(11032,26,143685,-57210),
(11032,27,143335,-55225),
(11032,28,143679,-53917),
(11032,29,143887,-53081),
(11033,0,47150,-44815),
(11033,1,32531,-52045),
(11034,0,111391,216329),
(11034,1,106872,216579),
(11034,2,106693,217371),
(11034,3,106612,217923),
(11034,4,106612,218409),
(11034,5,106435,221617),
(11034,6,106435,222250),
(11034,7,106563,222851),
(11034,8,108183,223150),
(11034,9,108916,223150),
(11034,10,110264,222975),
(11034,11,110253,223651),
(11034,12,110185,223669),
(11034,13,110095,223756),
(11034,14,110056,223864),
(11034,15,109790,223883),
(11034,16,109703,223966),
(11034,17,109705,224197),
(11034,18,109882,224363),
(11034,19,109884,225522),
(11034,20,110764,225507),
(11034,21,110767,225985),
(11034,22,112002,225992),
(11034,23,112005,225510),
(11034,24,112891,225520),
(11034,25,112886,224389),
(11034,26,113068,224198),
(11034,27,113072,223967),
(11034,28,112983,223887),
(11034,29,112704,223864),
(11034,30,112676,223758),
(11034,31,112592,223669),
(11034,32,112520,223654),
(11034,33,112506,222975),
(11034,34,113745,223440),
(11034,35,115249,223440),
(11034,36,115249,223653),
(11034,37,115356,223653),
(11034,38,115356,223322),
(11034,39,115392,222838),
(11034,40,115393,221433),
(11034,41,115980,220372),
(11034,42,116055,219529),
(11034,43,116055,219029),
(11034,44,116220,218649),
(11034,45,116219,218388),
(11034,46,116041,218380),
(11034,47,116043,217586),
(11034,48,115310,217610),
(11034,49,114755,217086),
(11034,50,114434,217051),
(11034,51,114417,216838),
(11034,52,114182,216838),
(11034,53,114161,216957),
(11034,54,113280,216962),
(11034,55,111885,216801),
(11034,56,111808,216566),
(11034,57,111631,216386),
(11034,58,111393,216322),
(11035,0,91098,-144458),
(11035,1,91477,-143218),
(11035,2,91170,-141327),
(11035,3,90797,-140803),
(11035,4,90404,-141058),
(11035,5,90077,-140615),
(11035,6,90424,-140324),
(11035,7,89997,-139845),
(11035,8,88300,-138977),
(11035,9,87659,-138913),
(11035,10,87656,-139375),
(11035,11,87044,-139383),
(11035,12,87039,-138938),
(11035,13,86427,-138981),
(11035,14,84717,-139826),
(11035,15,84295,-140324),
(11035,16,84648,-140602),
(11035,17,84286,-141095),
(11035,18,83959,-140825),
(11035,19,83562,-141356),
(11035,20,83229,-143217),
(11035,21,83821,-145580),
(11035,22,84373,-148184),
(11035,23,89454,-148688),
(11035,24,91280,-145403),
(11035,25,91084,-144472),
(11036,0,16529,170516),
(11036,1,16645,170141),
(11036,2,16747,169833),
(11036,3,16770,169677),
(11036,4,16822,169464),
(11036,5,16858,169431),
(11036,6,17457,169398),
(11036,7,17939,169475),
(11036,8,18109,169528),
(11036,9,18435,169666),
(11036,10,18628,169781),
(11036,11,18641,169828),
(11036,12,18531,170204),
(11036,13,18473,170530),
(11036,14,18452,170686),
(11036,15,18394,170900),
(11036,16,18361,170937),
(11036,17,17771,170962),
(11036,18,17220,170888),
(11036,19,16897,170757),
(11036,20,16543,170561),
(11037,0,11280,-25435),
(11037,1,11746,-24867),
(11037,2,12538,-23468),
(11037,3,13225,-23468),
(11037,4,12309,-22425),
(11037,5,11459,-22596),
(11037,6,11186,-22450),
(11037,7,10869,-22004),
(11037,8,10418,-22035),
(11037,9,9463,-22755),
(11037,10,8795,-22152),
(11037,11,8125,-22061),
(11037,12,7502,-22233),
(11037,13,6583,-22510),
(11037,14,6089,-22818),
(11037,15,5281,-22716),
(11037,16,4046,-22869),
(11037,17,4154,-23318),
(11037,18,4437,-23535),
(11037,19,4895,-23651),
(11037,20,5457,-24055),
(11037,21,5913,-24255),
(11037,22,6275,-24344),
(11037,23,8391,-23977),
(11037,24,9158,-24085),
(11037,25,9783,-24563),
(11037,26,9910,-25185),
(11037,27,10167,-25314),
(11037,28,10368,-25340),
(11037,29,10368,-27045),
(11037,30,10564,-27045),
(11037,31,10564,-25340),
(11037,32,10758,-25332),
(11037,33,10940,-25281),
(11038,0,-121743,44424),
(11038,1,-121032,43295),
(11038,2,-120886,42480),
(11038,3,-120203,41012),
(11038,4,-118418,40332),
(11038,5,-112554,40643),
(11038,6,-111161,40894),
(11038,7,-110912,41569),
(11038,8,-110910,41908),
(11038,9,-111011,42108),
(11038,10,-111186,42197),
(11038,11,-111601,42194),
(11038,12,-111736,42102),
(11038,13,-111827,41951),
(11038,14,-113240,41951),
(11038,15,-113330,42107),
(11038,16,-113477,42193),
(11038,17,-113905,42190),
(11038,18,-114072,42096),
(11038,19,-114146,41940),
(11038,20,-114602,41944),
(11038,21,-114536,43719),
(11038,22,-114513,46154),
(11038,23,-114275,46912),
(11038,24,-114275,47297),
(11038,25,-114665,48163),
(11038,26,-115473,48310),
(11038,27,-118971,48310),
(11038,28,-119259,47970),
(11038,29,-120430,47970),
(11038,30,-120654,47199),
(11038,31,-120917,46429),
(11039,0,-88871,-77664),
(11039,1,-43060,-43491),
(11040,0,-187342,238059),
(11040,1,-181849,247548),
(11050,0,47600,38290),
(11050,1,44483,41745),
(11051,0,46249,50036),
(11051,1,44431,49176),
(11052,0,20580,51713),
(11052,1,21667,50393),
(11053,0,24993,80655),
(11053,1,25454,82314),
(11054,0,57052,85445),
(11054,1,57937,87057),
(11060,0,109448,10233),
(11060,1,118547,21446),
(11070,0,-18670,-20294),
(11070,1,-22913,-21917),
(11071,0,-73769,-251411),
(11071,1,-77579,-253831),
(11072,0,-77712,-251411),
(11072,1,-81511,-253831),
(11073,0,-81889,-251411),
(11073,1,-85696,-253831),
(11074,0,-86097,-251411),
(11074,1,-89927,-253831),
(11075,0,-73769,-248546),
(11075,1,-77579,-250987),
(11076,0,-77712,-248546),
(11076,1,-81511,-250987),
(11077,0,-81889,-248546),
(11077,1,-85696,-250987),
(11078,0,-86097,-248546),
(11078,1,-89927,-250987),
(11079,0,-73769,-245741),
(11079,1,-77579,-248185),
(11080,0,-77712,-245741),
(11080,1,-81511,-248185),
(11081,0,-81889,-245741),
(11081,1,-85696,-248185),
(11082,0,-86097,-245741),
(11082,1,-89927,-248185),
(11083,0,-73769,-243055),
(11083,1,-77579,-245505),
(11084,0,-77712,-243055),
(11084,1,-81511,-245505),
(11085,0,-81889,-243055),
(11085,1,-85696,-245505),
(11086,0,-86097,-243055),
(11086,1,-89927,-245505),
(11087,0,-73769,-240271),
(11087,1,-77579,-242742),
(11088,0,-77712,-240271),
(11088,1,-81511,-242742),
(11089,0,-81889,-240271),
(11089,1,-85696,-242742),
(11090,0,-86097,-240271),
(11090,1,-89927,-242742),
(11091,0,-86097,-237576),
(11091,1,-89927,-240094),
(11092,0,-81992,-237633),
(11092,1,-85468,-240144),
(11100,0,43151,108377),
(11100,1,43648,109399),
(11101,0,-16400,123275),
(11101,1,-15551,123850),
(11102,0,-15100,125350),
(11102,1,-14800,125800),
(11103,0,-14050,125050),
(11103,1,-13700,125700),
(11104,0,-12950,123900),
(11104,1,-12300,124250),
(11105,0,-84700,151550),
(11105,1,-84250,152350),
(11106,0,-84200,153050),
(11106,1,-83550,153600),
(11107,0,-84100,155300),
(11107,1,-83500,155700),
(11108,0,-80100,149400),
(11108,1,-79500,149850),
(11109,0,-79700,151350),
(11109,1,-79300,152250),
(11110,0,17400,144800),
(11110,1,18000,145350),
(11111,0,18850,143600),
(11111,1,18600,143100),
(11112,0,19950,146000),
(11112,1,20400,146300),
(11113,0,0,0),
(11113,1,0,0),
(11114,0,80738,-15914),
(11114,1,79627,-15054),
(11115,0,148844,22709),
(11115,1,149424,23569),
(11116,0,150343,23193),
(11116,1,150943,24113),
(11117,0,145362,24890),
(11117,1,145972,25820),
(11118,0,150460,26108),
(11118,1,151036,26972),
(11119,0,143701,26661),
(11119,1,144281,27521),
(11120,0,143704,27734),
(11120,1,144324,28670),
(11121,0,78059,147906),
(11121,1,79122,148296),
(11122,0,81859,144802),
(11122,1,82254,145870),
(11123,0,83195,144779),
(11123,1,83591,145847),
(11124,0,80773,151053),
(11124,1,81169,152121),
(11125,0,81903,151377),
(11125,1,82299,152445),
(11126,0,145643,-55883),
(11126,1,146439,-55714),
(11126,2,146390,-55288),
(11126,3,145606,-55367),
(11127,0,146486,-57148),
(11127,1,146984,-57388),
(11127,2,147299,-56613),
(11127,3,146919,-56438),
(11128,0,148469,-57355),
(11128,1,148958,-57115),
(11128,2,148502,-56409),
(11128,3,148120,-56627),
(11129,0,148970,-55727),
(11129,1,149773,-55874),
(11129,2,149852,-55302),
(11129,3,149022,-55291),
(11130,0,37435,-51012),
(11130,1,38030,-51012),
(11130,2,38030,-50568),
(11130,3,37766,-50568),
(11130,4,37766,-50425),
(11130,5,37683,-50425),
(11130,6,37683,-50568),
(11130,7,37435,-50568),
(11131,0,38562,-50786),
(11131,1,39100,-50532),
(11131,2,38943,-50151),
(11131,3,38676,-50237),
(11131,4,38603,-50111),
(11131,5,38530,-50149),
(11131,6,38586,-50282),
(11131,7,38397,-50365),
(11132,0,39714,-50109),
(11132,1,39976,-49630),
(11132,2,39401,-49276),
(11132,3,39300,-49537),
(11132,4,39166,-49467),
(11132,5,39123,-49539),
(11132,6,39244,-49615),
(11132,7,39125,-49837),
(11133,0,39339,-48297),
(11133,1,39396,-48297),
(11133,2,39396,-48634),
(11133,3,39839,-48634),
(11133,4,39839,-47841),
(11133,5,39396,-47841),
(11133,6,39396,-48199),
(11133,7,39339,-48199),
(11134,0,39174,-47020),
(11134,1,39308,-46954),
(11134,2,39422,-47176),
(11134,3,39995,-46846),
(11134,4,39716,-46347),
(11134,5,39109,-46647),
(11134,6,39256,-46867),
(11134,7,39133,-46949),
(11135,0,38370,-46087),
(11135,1,38606,-46205),
(11135,2,38549,-46331),
(11135,3,38622,-46369),
(11135,4,38692,-46249),
(11135,5,38931,-46373),
(11135,6,39134,-45839),
(11135,7,38693,-45538),
(11136,0,37692,-46044),
(11136,1,37796,-46044),
(11136,2,37796,-45905),
(11136,3,38032,-45905),
(11136,4,38032,-45460),
(11136,5,37436,-45460),
(11136,6,37436,-45905),
(11136,7,37692,-45905),
(11137,0,85207,-143382),
(11137,1,86068,-143417),
(11137,2,86118,-142951),
(11137,3,85295,-142837),
(11138,0,86556,-142317),
(11138,1,86997,-142090),
(11138,2,86595,-141349),
(11138,3,86097,-141615),
(11139,0,87746,-142099),
(11139,1,88173,-142322),
(11139,2,88570,-141586),
(11139,3,88110,-141285),
(11140,0,88664,-143440),
(11140,1,89485,-143344),
(11140,2,89438,-142800),
(11140,3,88603,-142968),
(11141,0,138896,-124384),
(11141,1,140048,-125120),
(11141,2,140352,-124752),
(11141,3,141344,-125440),
(11141,4,141536,-125504),
(11141,5,141680,-125472),
(11141,6,141888,-125280),
(11141,7,141936,-125168),
(11141,8,141920,-124992),
(11141,9,141920,-124160),
(11141,10,141840,-123952),
(11141,11,141664,-123776),
(11141,12,141504,-123664),
(11141,13,141264,-123600),
(11141,14,140944,-123632),
(11141,15,140672,-123760),
(11141,16,140544,-123744),
(11141,17,139728,-123200),
(11142,0,55456,-91840),
(11142,1,55568,-91936),
(11142,2,55520,-92032),
(11142,3,55568,-92064),
(11142,4,55584,-92752),
(11142,5,55232,-93024),
(11142,6,55344,-93296),
(11142,7,55776,-93296),
(11142,8,55936,-93728),
(11142,9,55936,-93872),
(11142,10,55824,-94000),
(11142,11,55920,-94096),
(11142,12,55824,-94208),
(11142,13,55336,-94720),
(11142,14,56448,-94640),
(11142,15,56544,-94720),
(11142,16,56704,-94576),
(11142,17,57072,-94576),
(11142,18,57200,-94512),
(11142,19,57856,-94592),
(11142,20,58128,-94816),
(11142,21,58384,-94928),
(11142,22,58480,-95040),
(11142,23,58576,-94992),
(11142,24,58688,-95120),
(11142,25,59184,-94896),
(11142,26,59552,-94896),
(11142,27,59968,-94784),
(11142,28,60560,-95024),
(11142,29,60672,-95024),
(11142,30,60736,-94960),
(11142,31,60736,-94784),
(11142,32,60912,-94496),
(11142,33,60960,-94320),
(11142,34,61312,-93696),
(11142,36,60976,-93504),
(11142,37,61120,-93280),
(11142,38,60736,-92832),
(11142,39,60464,-92416),
(11142,40,60352,-92000),
(11142,41,60208,-92000),
(11142,42,60176,-91872),
(11142,43,59968,-91888),
(11142,44,59728,-91520),
(11142,45,59648,-91264),
(11142,46,58816,-90496),
(11142,47,58816,-90400),
(11142,48,58688,-90368),
(11142,49,58672,-90240),
(11142,50,57968,-90112),
(11142,51,57936,-90240),
(11142,52,57808,-90224),
(11142,53,57744,-90416),
(11142,54,56640,-91008),
(11142,55,56320,-91136),
(11142,56,56080,-91184),
(11142,57,55968,-91136),
(11142,58,55904,-91248),
(11142,59,55776,-91200),
(11143,0,57264,-30176),
(11143,1,57600,-29472),
(11143,2,58224,-29472),
(11143,3,58672,-30176),
(11143,4,59440,-29312),
(11143,5,59440,-25648),
(11143,6,56448,-25648),
(11143,7,56448,-29312),
(11200,0,-22615,104510),
(11200,1,-13290,104564),
(11200,2,-13313,116950),
(11200,3,-22638,116896),
(11201,0,26575,165240),
(11201,1,17250,165186),
(11201,2,17273,152800),
(11201,3,26598,152854),
(11202,0,121412,140594),
(11202,1,121358,149919),
(11202,2,108972,149896),
(11202,3,109026,140571),
(11203,0,87488,32689),
(11203,1,87434,42014),
(11203,2,75048,41991),
(11203,3,75102,32666),
(11204,0,142431,362),
(11204,1,152319,344),
(11204,2,152282,15197),
(11204,3,142393,15215),
(11205,0,120526,254019),
(11205,1,111201,253965),
(11205,2,111224,241579),
(11205,3,120549,241633),
(11206,0,141457,-51510),
(11206,1,151949,-51510),
(11206,2,151949,-39107),
(11206,3,145899,-39107),
(11206,4,141457,-44407),
(11207,0,7000,-55500),
(11207,1,27250,-41716),
(11208,0,73000,-156600),
(11208,1,82560,-144750),
(11209,0,-16287,109204),
(11209,1,-17178,109518),
(11210,0,20249,160228),
(11210,1,21132,160547),
(11211,0,116400,146030),
(11211,1,116718,146924),
(11212,0,82478,38125),
(11212,1,82794,39020),
(11213,0,146944,4097),
(11213,1,147967,5112),
(11214,0,114195,249007),
(11214,1,115081,249326),
(11215,0,147293,-46267),
(11215,1,147644,-47188),
(11216,0,9337,-49734),
(11216,1,11423,-49297),
(11216,2,11423,-49006),
(11216,3,9337,-48587),
(11217,0,77381,-150335),
(11217,1,77735,-151256),
(11400,0,83327,143509),
(11400,1,83031,143121),
(11400,2,82475,142974),
(11400,3,82174,142486),
(11400,4,82333,141833),
(11400,5,82955,141507),
(11400,6,83288,141763),
(11400,7,83683,141814),
(11400,8,83680,143500),
(11401,0,141249,-109636),
(11401,1,141473,-109798),
(11401,2,141739,-109821),
(11401,3,141924,-109669),
(11401,4,142038,-109397),
(11401,5,141852,-109130),
(11401,6,141604,-109051),
(11401,7,141321,-109091),
(11401,8,141213,-109266),
(11403,0,140174,-105832),
(11403,1,140490,-105875),
(11403,2,140962,-105738),
(11403,3,141039,-105378),
(11403,4,140872,-105119),
(11403,5,140081,-105295),
(11404,0,144927,-105193),
(11404,1,145226,-105412),
(11404,2,145576,-105344),
(11404,3,145819,-104976),
(11404,4,145575,-104555),
(11404,5,145217,-104490),
(11404,6,144935,-104684),
(11404,7,144832,-104959),
(11405,0,152081,-108262),
(11405,1,152455,-108588),
(11405,2,152835,-108448),
(11405,3,152992,-108120),
(11405,4,152817,-107670),
(11405,5,152310,-107632),
(11405,6,152069,-107905),
(11406,0,155279,-105735),
(11406,1,155448,-105880),
(11406,2,155992,-105963),
(11406,3,156201,-105790),
(11406,4,156133,-105320),
(11406,5,155896,-105229),
(11406,6,155459,-105254),
(11406,7,155283,-105478),
(11407,0,156838,-109948),
(11407,1,157133,-110046),
(11407,2,157436,-109918),
(11407,3,157491,-109405),
(11407,4,157197,-109197),
(11407,5,156843,-109261),
(11407,6,156683,-109569),
(11408,0,152063,-116732),
(11408,1,152505,-116982),
(11408,2,152904,-116927),
(11408,3,153020,-116469),
(11408,4,152881,-116221),
(11408,5,152555,-116100),
(11408,6,152285,-116160),
(11408,7,152099,-116415),
(11409,0,152683,-112829),
(11409,1,152796,-113129),
(11409,2,153125,-113339),
(11409,3,153557,-113190),
(11409,4,153649,-112721),
(11409,5,153344,-112385),
(11409,6,152937,-112409),
(11410,0,157444,-115790),
(11410,1,157774,-115907),
(11410,2,158174,-115759),
(11410,3,158017,-114971),
(11410,4,157625,-114984),
(11410,5,157439,-115101),
(11411,0,147182,-113255),
(11411,1,147194,-113430),
(11411,2,147312,-113584),
(11411,3,147467,-113630),
(11411,4,147748,-113523),
(11411,5,147816,-113273),
(11411,6,147723,-113074),
(11411,7,147512,-112956),
(11411,8,147258,-113048),
(11412,0,35360,70052),  
(11412,1,54640,70780),  
(11412,2,58104,89528),  
(11412,3,38900,91644),  
(11413,0,-99139,207208),
(11413,1,-65905,254858),
(11413,2,-65905,261841),
(11413,3,-124577,261607),
(11413,4,-128220,215665),
(11414,0,134452,66180),
(11414,1,170228,67184),
(11414,2,172464,97052),
(11414,3,136188,94940),
(11415,0,135800,35476),
(11415,1,162960,35364),
(11415,2,161056,64920),
(11415,3,136496,65092),
(11416,0,97311,-229576),
(11416,1,201955,-229291),
(11416,2,201926,-163450),
(11416,3,97636,-164202),
(11417,0,89909,158343),
(11417,1,130731,153447),
(11417,2,130741,261840),
(11417,3,65549,262183),
(11417,4,65612,189166),
(11418,0,81328,136658),
(11418,1,139003,123356),
(11418,2,138584,145204),
(11418,3,121150,155944),
(11418,4,80807,160436),
(11419,0,67326,160359),
(11419,1,86813,160109),
(11419,2,64159,189723),
(11419,3,42375,183029),
(11420,0,30606,184275),
(11420,1,40957,182824),
(11420,2,62226,189792),
(11420,3,62509,228946),
(11420,4,30706,228846),
(11421,0,65472,71452),
(11421,1,86420,82248),
(11421,2,97656,93300),
(11421,3,97692,98032),
(11421,4,64528,97660),
(11422,0,66204,3448),
(11422,1,121052,30384),
(11422,2,87064,56664),
(11422,3,69484,31724),
(11423,0,4721,99932),
(11423,1,60654,99812),
(11423,2,60606,158582),
(11423,3,40546,154557),
(11423,4,3147,123027),
(11424,0,36902,-98025),
(11424,1,9543,-42544),
(11424,2,54988,-7732),
(11424,3,96957,-65614),
(11425,0,436,128216),
(11425,1,10168,128584),
(11425,2,42184,182056),
(11425,3,31996,197312),
(11425,4,680,197804),
(11426,0,35960,34780),
(11426,1,61228,52232),
(11426,2,61704,77128),
(11426,3,43360,66444),
(11426,4,32924,37972),
(11427,0,11764,36204),
(11427,1,42092,63036),
(11427,2,44408,69824),
(11427,3,444,75320),
(11427,4,2780,51824),
(11428,0,148,77464),
(11428,1,4116,80668),
(11428,2,4816,95352),
(11428,3,460,94180),
(11429,0,-37560,16423),
(11429,1,-8388,126),
(11429,2,50773,98),
(11429,3,35243,16780),
(11429,4,-76016,81087),
(11429,5,-75777,65779),
(11430,0,-27548,90040),
(11430,1,3188,95180),
(11430,2,1816,117348),
(11430,3,-1732,130032),
(11430,4,-25952,130540),
(11431,0,-13628,57148),
(11431,1,-428,57856),
(11431,2,3668,90204),
(11431,3,-21376,89884),
(11431,4,-26808,87940),
(11432,0,-64990,-109438),
(11432,1,32369,-96091),
(11432,2,31964,-83063),
(11432,3,4840,-60901),
(11432,4,-30730,-68637),
(11433,0,-65739,186145),
(11433,1,-188,193188),
(11433,2,-470,213105),
(11433,3,-22923,225218),
(11433,4,-58597,224836),
(11434,0,-62980,111764),
(11434,1,-50756,126392),
(11434,2,-63940,140572),
(11434,3,-71220,133792),
(11434,4,-69448,120784),
(11435,0,-111370,100078),
(11435,1,-77020,67100),
(11435,2,-65711,190964),
(11435,3,-99937,150239),
(11436,0,-22345,249596),
(11436,1,-22362,249348),
(11436,2,-22091,248888),
(11436,3,-20643,248660),
(11436,4,-20140,249091),
(11436,5,-20118,249225),
(11436,6,-20030,249344),
(11436,7,-20026,249545),
(11436,8,-20362,249912),
(11436,9,-20825,250116),
(11436,10,-20887,249977),
(11436,11,-21108,250055),
(11436,12,-21202,250152),
(11436,13,-21423,250197),
(11436,14,-21773,250154),
(11436,15,-21899,250065),
(11501,0,-56256,153728),
(11501,1,-49536,159424),
(11502,0,-26304,216576),
(11502,1,-19584,222912),
(11503,0,12544,185856),
(11503,1,19456,190272),
(11504,0,122432,120192),
(11504,1,129600,126656),
(11505,0,70080,1984),
(11505,1,74944,6656),
(11506,0,151936,52736),
(11506,1,157760,58304),
(11507,0,186368,36288),
(11507,1,192640,42240),
(11508,0,114432,201664),
(11508,1,122176,208704),
(11509,0,155776,-72896),
(11509,1,162368,-67776),
(11510,0,66304,-63872),
(11510,1,72832,-58688),
(11511,0,106176,-143616),
(11511,1,112704,-138752),
(11512,0,1472,145216),
(11512,1,9728,155136),
(11513,0,-57408,88704),
(11513,1,-49408,93824),
(11514,0,56256,136768),
(11514,1,64256,142016),
(11515,0,8000,92928),
(11515,1,14976,97408),
(11516,0,75904,86336),
(11516,1,80448,95488),
(11517,0,107264,-17664),
(11517,1,115392,-12544),
(11518,0,121472,92992),
(11518,1,129088,97792),
(11519,0,69120,182400),
(11519,1,76672,190784),
(11520,0,98432,-56465),
(11520,1,102912,-52288),
(11521,0,68480,-97536),
(11521,1,75520,-92224),
(12001,0,181241,-86443),
(12001,1,192134,-84575),
(12002,0,179551,-89844),
(12002,1,190342,-88042),
(12003,0,172354,-86630),
(12003,1,174073,-75565),
(12004,0,174697,-82707),
(12004,1,176500,-71885),

(12005,0,172176,-74106),	-- +[JOJO:l2jfree boss.xml rev.4469] "Last Imperial Tomb" (Cuboid)
(12005,1,175984,-90033),
(12805,0,172176,-86081),	-- +[JOJO] "Lair of Scarlet van Halisha" (Cuboid)
(12805,1,175984,-90033),

(12006,0,173439,110176),
(12006,1,187346,119469),
(12007,0,112987,14312),
(12007,1,112507,14623),
(12007,2,112129,15551),
(12007,3,111890,16230),
(12007,4,112067,16965),
(12007,5,112496,17482),
(12007,6,112863,18120),
(12007,7,113453,18561),
(12007,8,114135,18590),
(12007,9,114815,18811),
(12007,10,115549,18648),
(12007,11,116074,18205),
(12007,12,116776,17506),
(12007,13,117255,17013),
(12007,14,117371,16298),
(12007,15,117405,15925),
(12007,16,117236,15199),
(12007,17,117158,14895),
(12007,18,116784,14260),
(12007,19,116096,13902),
(12007,20,115159,13507),
(12007,21,114135,13518),
(12007,22,113203,13898),
(12008,0,196866,-130845),
(12008,1,229289,-130860),
(12008,2,229176,-98508),
(12008,3,196880,-98498),
(12009,0,183986,-13716),
(12009,1,186097,-11532),
(12010,0,184008,-10681),
(12010,1,186107,-8589),
(12011,0,50797,213515),
(12011,1,57617,213510),
(12011,2,57669,221683),
(12011,3,50773,221632),
(12012,0,-21490,178613),
(12012,1,-22258,178961),
(12012,2,-22890,182205),
(12012,3,-22770,183129),
(12012,4,-21594,183945),
(12012,5,-20570,183381),
(12012,6,-20310,182673),
(12012,7,-20762,179129),
(12013,0,43976,24664),
(12013,1,43284,18952),
(12013,2,42476,18164),
(12013,3,42480,16448),
(12013,4,43084,15944),
(12013,5,45140,15816),
(12013,6,48800,15112),
(12013,7,56556,12040),
(12013,8,59068,14288),
(12013,9,61064,18492),
(12013,10,60380,23672),
(12013,11,58724,27412),
(12013,12,55696,28496),
(12013,13,43976,24664),
(12014,0,-18176,-54972),
(12014,1,-14614,-51620),
(12015,0,101744,-130016),
(12015,1,111376,-130096),
(12015,2,114416,-126128),
(12015,3,115246,-125857),
(12015,4,115209,-125669),
(12015,5,113920,-125669),
(12015,6,102400,-121920),
(12015,7,99456,-126208),

(12807,0,26095,-8084),		-- +[JOJO:l2jfree boss.xml rev.4469] "Lair of Sailren" (Cuboid)
(12807,1,28987,-5295),

(13001,0,148040,46500),
(13001,1,147784,46200),
(13001,2,147100,46200),
(13001,3,147100,47240),
(13001,4,147784,47240),
(13001,5,148040,46940),
(13002,0,150960,46500),
(13002,1,151220,46200),
(13002,2,151920,46200),
(13002,3,151920,47240),
(13002,4,151220,47240),
(13002,5,150960,46940),
(13003,0,84800,15590),
(13003,1,85870,16790),
(13004,0,84800,15590),
(13004,1,85870,16790),
(13005,0,-88672,141456),
(13005,1,-87168,141456),
(13005,2,-87168,142976),
(13005,3,-88672,142976),
(13005,4,-88672,142705),
(13005,5,-87439,142705),
(13005,6,-87439,141727),
(13005,7,-88417,141727),
(13005,8,-88417,142705),
(13005,9,-88672,142705),
(13006,0,72240,142016),
(13006,1,73744,142016),
(13006,2,73744,143504),
(13006,3,72240,143504),
(13006,4,72240,143249),
(13006,5,73473,143249),
(13006,6,73473,142271),
(13006,7,72495,142271),
(13006,8,72495,143249),
(13006,9,72240,143249),
(13007,0,-71680,256208),
(13007,1,-71536,256416),
(13007,2,-71280,256416),
(13007,3,-70672,257120),
(13007,4,-70736,257184),
(13007,5,-70544,257408),
(13007,6,-70368,257264),
(13007,7,-70064,257616),
(13007,8,-69984,258048),
(13007,9,-71888,259680),
(13007,10,-72128,259408),
(13007,11,-72304,259552),
(13007,12,-72640,259168),
(13007,13,-72528,259072),
(13007,14,-73312,258144),
(13007,15,-73296,257888),
(13007,16,-73456,257696),
(13008,0,-90816,247856),
(13008,1,-90608,247776),
(13008,2,-90160,247136),
(13008,3,-89168,247792),
(13008,4,-89104,247728),
(13008,5,-88656,248016),
(13008,6,-88720,248112),
(13008,7,-88672,248192),
(13008,8,-88736,248320),
(13008,9,-88544,248640),
(13008,10,-88592,249008),
(13008,11,-89200,249872),
(13008,12,-89488,250080),
(13008,13,-89872,250016),
(13008,14,-89984,250144),
(13008,15,-90048,250112),
(13008,16,-90112,250208),
(13008,17,-90560,249888),
(13008,18,-90496,249808),
(13008,19,-90592,249728),
(13008,20,-90624,249760),
(13008,21,-91504,249152),
(13008,22,-91072,248496),
(13008,23,-91152,248320),
(13009,0,27680,8960),
(13009,1,28464,8960),
(13009,2,29824,10352),
(13009,3,31472,10400),
(13009,4,31472,11664),
(13009,5,29824,11792),
(13009,6,28464,13056),
(13009,7,27680,13056),
(13009,8,26208,11632),
(13009,9,26208,10304),
(13010,0,-58880,-115408),
(13010,1,-55136,-111824),
(13011,0,-126000,37168),
(13011,1,-122944,39024),
(13012,0,-115384,-178072),
(13012,1,-114200,-182120),
(13013,0,-80472,112120),
(13013,1,-80472,110600),
(13013,2,-78056,110600),
(13013,3,-77048,111208),
(13013,4,-74904,111208),
(13013,5,-74904,112728),
(13013,6,-77048,112728),
(13013,7,-78056,112120),
(13014,0,-81512,87288),
(13014,1,-81512,85768),
(13014,2,-79080,85768),
(13014,3,-78072,86376),
(13014,4,-75928,86376),
(13014,5,-75928,87896),
(13014,6,-78072,87896),
(13014,7,-79080,87288);

INSERT INTO `zone_vertices` (`id`,`order`,`x`,`y`) VALUES 
(14000,0,-186945,244064),
(14000,1,-186503,244183),
(14000,2,-186526,244273),
(14000,3,-186998,244149),
(14001,0,-186707,243348),
(14001,1,-186098,243499),
(14001,2,-186209,243886),
(14001,3,-186836,243713),
(14002,0,-186388,241751),
(14002,1,-185747,241972),
(14002,2,-186026,243171),
(14002,3,-186755,242965),
(14003,0,-186067,241090),
(14003,1,-185469,241336),
(14003,2,-185541,241652),
(14003,3,-186173,241496),
(14004,0,-186158,240243),
(14004,1,-185440,240450),
(14004,2,-185461,240566),
(14004,3,-186182,240351),
(14005,0,-185611,240192),
(14005,1,-183498,240759),
(14005,2,-183834,241948),
(14005,3,-185906,241253),
(14006,0,-186102,241831),
(14006,1,-185039,242209),
(14006,2,-185356,243326),
(14006,3,-186447,243020),
(14007,0,-184942,242302),
(14007,1,-183775,242671),
(14007,2,-184015,243618),
(14007,3,-185256,243318),
(14008,0,-186637,243638),
(14008,1,-184503,244189),
(14008,2,-184878,245409),
(14008,3,-187009,244723),
(14009,0,-203218,241627),
(14009,1,-203218,242642),
(14009,2,-203355,242648),
(14009,3,-203376,242219),
(14009,4,-204119,242289),
(14009,5,-204108,242617),
(14009,6,-204305,242631),
(14009,7,-204315,242913),
(14009,8,-204613,242930),
(14009,9,-204624,241399),
(14009,10,-204312,241374),
(14009,11,-204132,241677),
(14009,12,-204114,242019),
(14009,13,-203349,241982),
(14009,14,-203345,241646);

INSERT INTO `zone_vertices` (`id`,`order`,`x`,`y`) VALUES
-- Water zones
(15000,0,-131072,98304),
(15000,1,-98304,98304),
(15000,2,-98304,131072),
(15000,3,-131072,131072),
(15001,0,-131072,131072),
(15001,1,-98304,131072),
(15001,2,-98304,163840),
(15001,3,-131072,163840),
(15002,0,-131072,163840),
(15002,1,-98304,163840),
(15002,2,-98304,196608),
(15002,3,-131072,196608),
(15003,0,-131072,196608),
(15003,1,-98304,196608),
(15003,2,-98304,229376),
(15003,3,-131072,229376),
(15004,0,-131072,237205),
(15004,1,-98304,237205),
(15004,2,-98304,262144),
(15004,3,-131072,262144),
(15005,0,-98304,65536),
(15005,1,-85504,65536),
(15005,2,-85504,98304),
(15005,3,-98304,98304),
(15006,0,-85504,65536),
(15006,1,-65536,65536),
(15006,2,-65536,80384),
(15006,3,-85504,80384),
(15007,0,-85056,86208),
(15007,1,-84416,86208),
(15007,2,-84416,86848),
(15007,3,-85056,86848),
(15008,0,-84416,86208),
(15008,1,-82944,86208),
(15008,2,-82944,86848),
(15008,3,-84416,86848),
(15009,0,-98304,121072),
(15009,1,-88304,121072),
(15009,2,-88304,131072),
(15009,3,-98304,131072),
(15010,0,-98304,98304),
(15010,1,-96804,98304),
(15010,2,-96804,99804),
(15010,3,-98304,99804),
(15011,0,-68536,128072),
(15011,1,-65536,128072),
(15011,2,-65536,131072),
(15011,3,-68536,131072),
(15012,0,-84032,111040),
(15012,1,-83392,111040),
(15012,2,-83392,111680),
(15012,3,-84032,111680),
(15013,0,-83392,111040),
(15013,1,-81920,111040),
(15013,2,-81920,111680),
(15013,3,-83392,111680),
(15014,0,-98304,131072),
(15014,1,-78304,131072),
(15014,2,-78304,163840),
(15014,3,-98304,163840),
(15015,0,-69836,131072),
(15015,1,-65536,131072),
(15015,2,-65536,140072),
(15015,3,-69836,140072),
(15016,0,-98304,163840),
(15016,1,-65536,163840),
(15016,2,-65536,196608),
(15016,3,-98304,196608),
(15017,0,-98304,196608),
(15017,1,-65536,196608),
(15017,2,-65536,229376),
(15017,3,-98304,229376),
(15018,0,-98304,229376),
(15018,1,-65536,229376),
(15018,2,-65536,262144),
(15018,3,-98304,262144),
(15019,0,-65536,-103304),
(15019,1,-32768,-103304),
(15019,2,-32768,-98304),
(15019,3,-65536,-98304),
(15020,0,-65536,32768),
(15020,1,-52036,32768),
(15020,2,-52036,65536),
(15020,3,-65536,65536),
(15021,0,-52036,32768),
(15021,1,-32768,32768),
(15021,2,-32768,40768),
(15021,3,-52036,40768),
(15022,0,-65536,65536),
(15022,1,-55536,65536),
(15022,2,-55536,75536),
(15022,3,-65536,75536),
(15023,0,-55870,78850),
(15023,1,-54153,79360),
(15024,0,-55945,78850),
(15024,1,-55420,79360),
(15025,0,-65536,122368),
(15025,1,-52480,122368),
(15025,2,-52480,131072),
(15025,3,-65536,131072),
(15026,0,-65536,113088),
(15026,1,-57664,113088),
(15026,2,-57664,121856),
(15026,3,-65536,121856),
(15027,0,-65536,131072),
(15027,1,-62464,131072),
(15027,2,-62464,141056),
(15027,3,-65536,141056),
(15028,0,-61764,131072),
(15028,1,-55748,131072),
(15028,2,-55748,132608),
(15028,3,-61764,132608),
(15029,0,-65536,191350),
(15029,1,-53536,191350),
(15029,2,-53536,196608),
(15029,3,-65536,196608),
(15030,0,-65535,179446),
(15030,1,-62962,179446),
(15030,2,-62962,191446),
(15030,3,-65535,191446),
(15031,0,-54681,180234),
(15031,1,-53049,180234),
(15031,2,-53049,183018),
(15031,3,-54681,183018),
(15032,0,-53616,183018),
(15032,1,-52368,183018),
(15032,2,-52368,184394),
(15032,3,-53616,184394),
(15033,0,-41815,206190),
(15033,1,-41315,207860),
(15034,0,-65536,196608),
(15034,1,-53536,196608),
(15034,2,-53536,229376),
(15034,3,-65536,229376),
(15035,0,-53536,220976),
(15035,1,-32768,220976),
(15035,2,-32768,229376),
(15035,3,-53536,229376),
(15036,0,-41024,212576),
(15036,1,-32768,212576),
(15036,2,-32768,220976),
(15036,3,-41024,220976),
(15037,0,-53536,212576),
(15037,1,-45280,212576),
(15037,2,-45280,220976),
(15037,3,-53536,220976),
(15038,0,-53536,202208),
(15038,1,-47584,202208),
(15038,2,-47584,209584),
(15038,3,-53536,209584),
(15039,0,-45280,212576),
(15039,1,-41024,212576),
(15039,2,-41024,220976),
(15039,3,-45280,220976),
(15040,0,-41815,206115),
(15040,1,-41315,206620),
(15041,0,-65536,229376),
(15041,1,-32768,229376),
(15041,2,-32768,262144),
(15041,3,-65536,262144),
(15042,0,-32768,-101304),
(15042,1,-29768,-101304),
(15042,2,-29768,-98304),
(15042,3,-32768,-98304),
(15043,0,-32768,-98304),
(15043,1,0,-98304),
(15043,2,0,-65536),
(15043,3,-32768,-65536),
(15044,0,-32768,0),
(15044,1,-23424,0),
(15044,2,-23424,32768),
(15044,3,-32768,32768),
(15045,0,-23095,13245),
(15045,1,-22580,13765),
(15046,0,-23040,13245),
(15046,1,-21365,13765),
(15047,0,-23424,0),
(15047,1,0,0),
(15047,2,0,12928),
(15047,3,-23424,12928),
(15048,0,-12972,57536),
(15048,1,-5972,57536),
(15048,2,-5972,65536),
(15048,3,-12972,65536),
(15049,0,-5840,60646),
(15049,1,-3840,60646),
(15049,2,-3840,62646),
(15049,3,-5840,62646),
(15050,0,-24488,65536),
(15050,1,0,65536),
(15050,2,0,98304),
(15050,3,-24488,98304),
(15051,0,-25405,77100),
(15051,1,-24890,77635),
(15052,0,-25345,77100),
(15052,1,-23655,77635),
(15053,0,-25816,98304),
(15053,1,0,98304),
(15053,2,0,131072),
(15053,3,-25816,131072),
(15054,0,-32768,209376),
(15054,1,-10000,209376),
(15054,2,-10000,229376),
(15054,3,-32768,229376),
(15055,0,-10000,196608),
(15055,1,0,196608),
(15055,2,0,229376),
(15055,3,-10000,229376),
(15056,0,-32768,229376),
(15056,1,0,229376),
(15056,2,0,262144),
(15056,3,-32768,262144),
(15057,0,0,-73536),
(15057,1,8000,-73536),
(15057,2,8000,-65536),
(15057,3,0,-65536),
(15058,0,0,0),
(15058,1,32768,0),
(15058,2,32768,5500),
(15058,3,0,5500),
(15059,0,0,32768),
(15059,1,32768,32768),
(15059,2,32768,65536),
(15059,3,0,65536),
(15060,0,0,76174),
(15060,1,4000,76174),
(15060,2,4000,98304),
(15060,3,0,98304),
(15061,0,4608,65480),
(15061,1,32768,65480),
(15061,2,32768,70344),
(15061,3,4608,70344),
(15062,0,0,66792),
(15062,1,4624,66792),
(15062,2,4624,72936),
(15062,3,0,72936),
(15063,0,0,98304),
(15063,1,4300,98304),
(15063,2,4300,131072),
(15063,3,0,131072),
(15064,0,0,131072),
(15064,1,7168,131072),
(15064,2,7168,163840),
(15064,3,0,163840),
(15065,0,0,163840),
(15065,1,32768,163840),
(15065,2,32768,196608),
(15065,3,0,196608),
(15066,0,0,196608),
(15066,1,32768,196608),
(15066,2,32768,229376),
(15066,3,0,229376),
(15067,0,32768,0),
(15067,1,65536,0),
(15067,2,65536,10000),
(15067,3,32768,10000),
(15068,0,32768,32768),
(15068,1,60672,32768),
(15068,2,60672,65536),
(15068,3,32768,65536),
(15069,0,32768,65536),
(15069,1,63568,65536),
(15069,2,63568,90536),
(15069,3,32768,90536),
(15070,0,63236,73140),
(15070,1,65536,73140),
(15070,2,65536,75440),
(15070,3,63236,75440),
(15071,0,43517,116837),
(15071,1,52517,116837),
(15071,2,52517,126093),
(15071,3,43517,126093),
(15072,0,48773,115910),
(15072,1,50237,115910),
(15072,2,50237,116709),
(15072,3,48773,116709),
(15073,0,46597,111629),
(15073,1,49597,111629),
(15073,2,49597,115129),
(15073,3,46597,115129),
(15074,0,49172,115129),
(15074,1,50136,115129),
(15074,2,50136,116869),
(15074,3,49172,116869),
(15075,0,48000,115129),
(15075,1,49172,115129),
(15075,2,49172,116357),
(15075,3,48000,116357),
(15076,0,44980,127045),
(15076,1,45505,127555),
(15077,0,44928,127455),
(15077,1,45568,125820),
(15078,0,41917,139480),
(15078,1,51917,139480),
(15078,2,51917,152770),
(15078,3,41917,152770),
(15079,0,39360,143680),
(15079,1,39875,144190),
(15080,0,39420,143680),
(15080,1,41113,144190),
(15081,0,32768,181240),
(15081,1,65536,181240),
(15081,2,65536,196608),
(15081,3,32768,196608),
(15082,0,32768,175600),
(15082,1,44032,175600),
(15082,2,44032,181240),
(15082,3,32768,181240),
(15083,0,57472,175600),
(15083,1,65536,175600),
(15083,2,65536,181240),
(15083,3,57472,181240),
(15084,0,42560,170045),
(15084,1,43075,170565),
(15085,0,42620,170045),
(15085,1,44291,170565),
(15086,0,32768,196608),
(15086,1,65536,196608),
(15086,2,65536,229376),
(15086,3,32768,229376),
(15087,0,65536,4768),
(15087,1,75536,4768),
(15087,2,75536,32768),
(15087,3,65536,32768),
(15088,0,75536,27768),
(15088,1,98304,27768),
(15088,2,98304,32768),
(15088,3,75536,32768),
(15089,0,84727,32768),
(15089,1,91727,32768),
(15089,2,91727,53768),
(15089,3,84727,53768),
(15090,0,65536,91304),
(15090,1,98304,91304),
(15090,2,98304,98304),
(15090,3,65536,98304),
(15091,0,65536,71304),
(15091,1,70536,71304),
(15091,2,70536,91304),
(15091,3,65536,91304),
(15092,0,74050,78150),
(15092,1,74550,78665),
(15093,0,74110,78150),
(15093,1,75791,78665),
(15094,0,78304,139840),
(15094,1,98304,139840),
(15094,2,98304,163840),
(15094,3,78304,163840),
(15095,0,65536,163840),
(15095,1,74752,163840),
(15095,2,74752,196608),
(15095,3,65536,196608),
(15096,0,74752,163840),
(15096,1,85215,163840),
(15096,2,85215,173976),
(15096,3,74752,173976),
(15097,0,74752,173976),
(15097,1,83244,173976),
(15097,2,83244,178267),
(15097,3,74752,178267),
(15098,0,74752,178267),
(15098,1,78031,178267),
(15098,2,78031,180291),
(15098,3,74752,180291),
(15099,0,91149,163840),
(15099,1,98304,163840),
(15099,2,98304,166737),
(15099,3,91149,166737),
(15100,0,95485,166737),
(15100,1,98304,166737),
(15100,2,98304,193105),
(15100,3,95485,193105),
(15101,0,92290,173976),
(15101,1,95485,173976),
(15101,2,95485,185103),
(15101,3,92290,185103),
(15102,0,92290,193105),
(15102,1,98304,193105),
(15102,2,98304,196608),
(15102,3,92290,196608),
(15103,0,93696,224128),
(15103,1,98304,224128),
(15103,2,98304,229376),
(15103,3,93696,229376),
(15104,0,93056,196608),
(15104,1,98304,196608),
(15104,2,98304,201216),
(15104,3,93056,201216),
(15105,0,65536,196608),
(15105,1,76032,196608),
(15105,2,76032,200320),
(15105,3,65536,200320),
(15106,0,70024,222217),
(15106,1,77862,222217),
(15106,2,77862,229376),
(15106,3,70024,229376),
(15107,0,65536,200320),
(15107,1,70024,200320),
(15107,2,70024,229376),
(15107,3,65536,229376),
(15108,0,70024,200320),
(15108,1,79174,200320),
(15108,2,79174,222217),
(15108,3,70024,222217),
(15109,0,77862,224128),
(15109,1,93696,224128),
(15109,2,93696,229376),
(15109,3,77862,229376),
(15110,0,80192,201216),
(15110,1,98304,201216),
(15110,2,98304,224128),
(15110,3,80192,224128),
(15111,0,81856,196608),
(15111,1,93056,196608),
(15111,2,93056,201216),
(15111,3,81856,201216),
(15112,0,79410,208965),
(15112,1,79935,209470),
(15113,0,79485,208965),
(15113,1,81216,209470),
(15114,0,79174,209727),
(15114,1,80192,209727),
(15114,2,80192,224128),
(15114,3,79174,224128),
(15115,0,79174,201216),
(15115,1,80192,201216),
(15115,2,80192,208704),
(15115,3,79174,208704),
(15116,0,79010,246661),
(15116,1,86498,246661),
(15116,2,86498,254711),
(15116,3,79010,254711),
(15117,0,84195,239660),
(15117,1,86179,239660),
(15117,2,86179,242732),
(15117,3,84195,242732),
(15118,0,82979,241472),
(15118,1,84195,241472),
(15118,2,84195,241920),
(15118,3,82979,241920),
(15119,0,80356,245013),
(15119,1,84644,245013),
(15119,2,84644,245845),
(15119,3,80356,245845),
(15120,0,80303,258157),
(15120,1,84591,258157),
(15120,2,84591,258989),
(15120,3,80303,258989),
(15121,0,65536,229376),
(15121,1,98304,229376),
(15121,2,98304,262144),
(15121,3,65536,262144),
(15122,0,78624,254711),
(15122,1,82336,254711),
(15122,2,82336,255593),
(15122,3,78624,255593),
(15123,0,82785,254711),
(15123,1,86497,254711),
(15123,2,86497,255593),
(15123,3,82785,255593),
(15124,0,82336,255351),
(15124,1,82785,255351),
(15124,2,82785,255593),
(15124,3,82336,255593),
(15125,0,98304,-229376),
(15125,1,131072,-229376),
(15125,2,131072,-196608),
(15125,3,98304,-196608),
(15126,0,119040,-196608),
(15126,1,131072,-196608),
(15126,2,131072,-178624),
(15126,3,119040,-178624),
(15127,0,98305,27768),
(15127,1,120321,27768),
(15127,2,120321,32768),
(15127,3,98305,32768),
(15128,0,103091,37760),
(15128,1,128091,37760),
(15128,2,128091,62760),
(15128,3,103091,62760),
(15129,0,110270,84290),
(15129,1,110785,84800),
(15130,0,110335,84290),
(15130,1,112022,84800),
(15131,0,98304,138240),
(15131,1,131072,138240),
(15131,2,131072,163840),
(15131,3,98304,163840),
(15132,0,112096,142624),
(15132,1,119232,142624),
(15132,2,119232,147604),
(15132,3,112096,147604),
(15133,0,117509,136740),
(15133,1,122009,136740),
(15133,2,122009,138240),
(15133,3,117509,138240),
(15134,0,117509,136740),
(15134,1,122009,136740),
(15134,2,122009,138240),
(15134,3,117509,138240),
(15135,0,117509,136740),
(15135,1,122009,136740),
(15135,2,122009,138240),
(15135,3,117509,138240),
(15136,0,114630,132545),
(15136,1,115140,133055),
(15137,0,114695,132545),
(15137,1,116358,133055),
(15138,0,98304,163840),
(15138,1,131072,163840),
(15138,2,131072,167840),
(15138,3,98304,167840),
(15139,0,98304,167840),
(15139,1,102304,167840),
(15139,2,102304,196608),
(15139,3,98304,196608),
(15140,0,124072,167840),
(15140,1,131072,167840),
(15140,2,131072,196608),
(15140,3,124072,196608),
(15141,0,102304,191608),
(15141,1,124072,191608),
(15141,2,124072,196608),
(15141,3,102304,196608),
(15142,0,121672,186199),
(15142,1,124072,186199),
(15142,2,124072,189151),
(15142,3,121672,189151),
(15143,0,102304,184170),
(15143,1,105652,184170),
(15143,2,105652,187250),
(15143,3,102304,187250),
(15144,0,102304,168567),
(15144,1,106804,168567),
(15144,2,106804,173567),
(15144,3,102304,173567),
(15145,0,107585,173765),
(15145,1,108095,174270),
(15146,0,107755,173765),
(15146,1,109425,174270),
(15147,0,98304,196608),
(15147,1,131072,196608),
(15147,2,131072,229376),
(15147,3,98304,229376),
(15148,0,98304,229376),
(15148,1,131072,229376),
(15148,2,131072,262144),
(15148,3,98304,262144),
(15149,0,131072,-229376),
(15149,1,163840,-229376),
(15149,2,163840,-196608),
(15149,3,131072,-196608),
(15150,0,131072,-196608),
(15150,1,163840,-196608),
(15150,2,163840,-178608),
(15150,3,131072,-178608),
(15151,0,145081,25139),
(15151,1,149881,25139),
(15151,2,149881,29939),
(15151,3,145081,29939),
(15152,0,131059,32768),
(15152,1,163827,32768),
(15152,2,163827,65536),
(15152,3,131059,65536),
(15153,0,136765,79420),
(15153,1,137285,79935),
(15154,0,136830,79420),
(15154,1,138512,79935),
(15155,0,137472,65536),
(15155,1,163840,65536),
(15155,2,163840,98304),
(15155,3,137472,98304),
(15156,0,131072,126072),
(15156,1,136072,126072),
(15156,2,136072,131072),
(15156,3,131072,131072),
(15157,0,163840,-229376),
(15157,1,196608,-229376),
(15157,2,196608,-196608),
(15157,3,163840,-196608),
(15158,0,163840,-196608),
(15158,1,168840,-196608),
(15158,2,168840,-186608),
(15158,3,163840,-186608),
(15159,0,173411,-187756),
(15159,1,186042,-187756),
(15159,2,186042,-182534),
(15159,3,173411,-182534),
(15160,0,174206,-182687),
(15160,1,176749,-182687),
(15160,2,176749,-179167),
(15160,3,174206,-179167),
(15161,0,170908,-116846),
(15161,1,173748,-116846),
(15161,2,173748,-113953),
(15161,3,170908,-113953),
(15162,0,170926,-113936),
(15162,1,173766,-113936),
(15162,2,173766,-111043),
(15162,3,170926,-111043),
(15163,0,163840,65760),
(15163,1,173840,65760),
(15163,2,173840,95072),
(15163,3,163840,95072),
(15164,0,168625,-17850),
(15164,1,169150,-17330),
(15165,0,168700,-17850),
(15165,1,170365,-17330),
(15166,0,0,-73536),
(15166,1,8000,-73536),
(15166,2,8000,-65536),
(15166,3,0,-65536),
(15167,0,0,-65536),
(15167,1,32768,-65536),
(15167,2,32768,-32768),
(15167,3,0,-32768),
(15168,0,32768,-98304),
(15168,1,65536,-98304),
(15168,2,65536,-65536),
(15168,3,32768,-65536),
(15169,0,32768,-65536),
(15169,1,65536,-65536),
(15169,2,65536,-32768),
(15169,3,32768,-32768),
(15170,0,32768,-32768),
(15170,1,65536,-32768),
(15170,2,65536,0),
(15170,3,32768,0),
(15171,0,65536,-40960),
(15171,1,98304,-40960),
(15171,2,98304,-32768),
(15171,3,65536,-32768),
(15172,0,91829,-55930),
(15172,1,95637,-55930),
(15172,2,95637,-50266),
(15172,3,91829,-50266),
(15173,0,87765,-54554),
(15173,1,91829,-54554),
(15173,2,91829,-50266),
(15173,3,87765,-50266),
(15174,0,84947,-50234),
(15174,1,90133,-50234),
(15174,2,90133,-46202),
(15174,3,84947,-46202),
(15175,0,76003,-46368),
(15175,1,84947,-46368),
(15175,2,84947,-39968),
(15175,3,76003,-39968),
(15176,0,68852,-62008),
(15176,1,74036,-62008),
(15176,2,74036,-56192),
(15176,3,68852,-56192),
(15177,0,69480,-56192),
(15177,1,77032,-56192),
(15177,2,77032,-53203),
(15177,3,69480,-53203),
(15178,0,71311,-53203),
(15178,1,76175,-53203),
(15178,2,76175,-50292),
(15178,3,71311,-50292),
(15179,0,75059,-63591),
(15179,1,78355,-63591),
(15179,2,78355,-57517),
(15179,3,75059,-57517),
(15180,0,78355,-65184),
(15180,1,83859,-65184),
(15180,2,83859,-51872),
(15180,3,78355,-51872),
(15181,0,83859,-64826),
(15181,1,87187,-64826),
(15181,2,87187,-55418),
(15181,3,83859,-55418),
(15182,0,87187,-62909),
(15182,1,90963,-62909),
(15182,2,90963,-58301),
(15182,3,87187,-58301),
(15183,0,77283,-51872),
(15183,1,83747,-51872),
(15183,2,83747,-49440),
(15183,3,77283,-49440),
(15184,0,83859,-55418),
(15184,1,86227,-55418),
(15184,2,86227,-52602),
(15184,3,83859,-52602),
(15185,0,69635,-47328),
(15185,1,76003,-47328),
(15185,2,76003,-39776),
(15185,3,69635,-39776),
(15186,0,87187,-58301),
(15186,1,89235,-58301),
(15186,2,89235,-56541),
(15186,3,87187,-56541),
(15187,0,65536,-32768),
(15187,1,76800,-32768),
(15187,2,76800,0),
(15187,3,65536,0),
(15188,0,76800,-32768),
(15188,1,98304,-32768),
(15188,2,98304,-18432),
(15188,3,76800,-18432),
(20000,0,17869,108566),
(20000,1,18071,108774),
(20000,2,18072,109060),
(20000,3,17865,109265),
(20000,4,17580,109264),
(20000,5,17379,109062),
(20000,6,17379,108774),
(20000,7,17584,108569),
(20050,0,43084,15944),
(20050,1,45140,15816),
(20050,2,45748,17200),
(20050,3,44504,18780),
(20050,4,43284,18952),
(20050,5,42476,18164),
(20050,6,42480,16448),
(20051,0,186739,-86322),
(20051,1,190108,-86335),
(20051,2,190110,-84794),
(20051,3,186736,-84786),
(20052,0,186739,-86322),
(20052,1,190108,-86335),
(20052,2,190110,-84794),
(20052,3,186736,-84786),
(20053,0,186739,-86322),
(20053,1,190108,-86335),
(20053,2,190110,-84794),
(20053,3,186736,-84786),
(20054,0,186739,-86322),
(20054,1,190108,-86335),
(20054,2,190110,-84794),
(20054,3,186736,-84786),
(20055,0,185028,-89729),
(20055,1,188398,-89741),
(20055,2,188400,-88200),
(20055,3,185026,-88192),
(20056,0,185028,-89729),
(20056,1,188398,-89741),
(20056,2,188400,-88200),
(20056,3,185026,-88192),
(20057,0,185028,-89729),
(20057,1,188398,-89741),
(20057,2,188400,-88200),
(20057,3,185026,-88192),
(20058,0,185028,-89729),
(20058,1,188398,-89741),
(20058,2,188400,-88200),
(20058,3,185026,-88192),
(20059,0,172411,-81083),
(20059,1,173942,-81073),
(20059,2,173931,-77639),
(20059,3,172418,-77644),
(20060,0,172411,-81083),
(20060,1,173942,-81073),
(20060,2,173931,-77639),
(20060,3,172418,-77644),
(20061,0,172411,-81083),
(20061,1,173942,-81073),
(20061,2,173931,-77639),
(20061,3,172418,-77644),
(20062,0,172411,-81083),
(20062,1,173942,-81073),
(20062,2,173931,-77639),
(20062,3,172418,-77644),
(20063,0,174822,-77261),
(20063,1,176354,-77251),
(20063,2,176342,-73817),
(20063,3,174829,-73822),
(20064,0,174822,-77261),
(20064,1,176354,-77251),
(20064,2,176342,-73817),
(20064,3,174829,-73822),
(20065,0,174822,-77261),
(20065,1,176354,-77251),
(20065,2,176342,-73817),
(20065,3,174829,-73822),
(20066,0,174822,-77261),
(20066,1,176354,-77251),
(20066,2,176342,-73817),
(20066,3,174829,-73822),
(20100,0,43084,15944),
(20100,1,45140,15816),
(20100,2,45748,17200),
(20100,3,44504,18780),
(20100,4,43284,18952),
(20100,5,42476,18164),
(20100,6,42480,16448);

-- Emerald Square Zone
INSERT INTO `zone_vertices` VALUES
-- first secret room
(20105,0,144175,142396),
(20105,1,144251,142588),
-- second secret room
(20106,0,147400,143631),
(20106,1,147484,143828),
-- third secret room
(20107,0,149396,143473),
(20107,1,149559,143584);

-- Pagan's Mark Zone
INSERT INTO `zone_vertices` (`id`,`order`,`x`,`y`) VALUES 
(30100,0,-16100,-36620),
(30100,1,-16600,-36620),
(30100,2,-16600,-36925),
(30100,3,-16100,-36925);

-- Castle NoHq Zones

-- Gludio Castle
INSERT INTO `zone_vertices` VALUES
('112000','0','-19576','106760'),
('112000','1','-17288','106760'),
('112000','2','-16520','107528'),
('112000','3','-16520','108664'),
('112000','4','-15752','108664'),
('112000','5','-15752','110072'),
('112000','6','-16264','110072'),
('112000','7','-16264','112376'),
('112000','8','-17800','113912'),
('112000','9','-18824','113912'),
('112000','10','-20232','112504'),
('112000','11','-20232','108936'),
('112000','12','-19576','108280'),
('112000','13','-19576','106760');

-- Dion Castle
INSERT INTO `zone_vertices` VALUES
('112010','0','21240','162936'),
('112010','1','23544','162936'),
('112010','2','23544','161416'),
('112010','3','24184','160776'),
('112010','4','24184','157304'),
('112010','6','22664','155784'),
('112010','7','21752','155784'),
('112010','8','20232','157304'),
('112010','9','20232','159608'),
('112010','10','19592','160248'),
('112010','11','19592','160648'),
('112010','12','20104','161160'),
('112010','13','20472','161160'),
('112010','14','20472','162168'),
('112010','15','21240','162936');

-- Giran Castle
INSERT INTO `zone_vertices` VALUES
('112020','0','113544','142984'),
('112020','1','116856','142984'),
('112020','2','117496','143624'),
('112020','3','119160','143624'),
('112020','4','119160','145784'),
('112020','5','118392','146552'),
('112020','6','117240','146552'),
('112020','7','117240','147448'),
('112020','8','115976','147448'),
('112020','9','115976','146824'),
('112020','10','113672','146824'),
('112020','11','112008','145672'),
('112020','12','112008','144520'),
('112020','13','113544','142984');

-- Oren Castle
INSERT INTO `zone_vertices` VALUES 
('112030','0','79608','35080'),
('112030','1','83080','35080'),
('112030','2','83592','35592'),
('112030','3','85240','35592'),
('112030','4','85240','37896'),
('112030','5','84360','38776'),
('112030','6','83336','38776'),
('112030','7','83336','39544'),
('112030','8','81928','39544'),
('112030','9','81928','39048'),
('112030','10','79496','39048'),
('112030','11','77960','37512'),
('112030','12','77960','36728'),
('112030','13','79608','35080');

-- Aden Castle
INSERT INTO `zone_vertices` VALUES 
('112040','0','144200','9900'),
('112040','1','144200','910'),
('112040','2','150670','910'),
('112040','3','150670','9900'),
('112040','4','144200','9900');

-- Innadril Castle
INSERT INTO `zone_vertices` VALUES 
('112050','0','115832','244488'),
('112050','1','116488','244488'),
('112050','2','118136','246136'),
('112050','3','118136','249480'),
('112050','4','117496','250120'),
('112050','5','117496','251768'),
('112050','6','115192','251768'),
('112050','7','114424','251000'),
('112050','8','114424','249848'),
('112050','9','113544','249848'),
('112050','10','113544','248440'),
('112050','11','114184','248440'),
('112050','12','114184','246136'),
('112050','13','115832','244488');

-- Goddard Castle
INSERT INTO `zone_vertices` VALUES 
('112060','0','151864','-48404'),
('112060','1','150145','-45508'),
('112060','2','147512','-44268'),
('112060','3','144518','-45533'),
('112060','4','143918','-49774'),
('112060','5','144405','-52084'),
('112060','6','147751','-52301'),
('112060','7','150746','-52809'),
('112060','8','151864','-48404');

-- Rune Castle
INSERT INTO `zone_vertices` VALUES 
('112070','0','18808','-49656'),
('112070','1','18808','-48648'),
('112070','2','16904','-45832'),
('112070','3','4488','-45832'),
('112070','4','4488','-52742'),
('112070','5','17016','-52742'),
('112070','6','18808','-49656');

-- Schuttgart Castle
INSERT INTO `zone_vertices` VALUES 
('112080','0','80995','-153334'),
('112080','1','80808','-150137'),
('112080','2','79228','-148694'),
('112080','3','76451','-148399'),
('112080','4','74703','-149543'),
('112080','5','73718','-153342'),
('112080','6','75632','-156376'),
('112080','7','77635','-155680'),
('112080','8','79985','-155849'),
('112080','9','80995','-153334');