﻿<?php
/**
 * ACM main class where everything will sub to
 * @author Lauri Lüüs <mad@webpoint.ee>
 * @version $Id: AccountManager.php 5 2005-05-25 19:28:13Z madest $
 * @package AccountManager
 * @filesource
 */
  
#----------------------------------------------------
# Functions - simple basic stuff
#----------------------------------------------------
/**
 * Misc functions
 */
require_once('classes/includes/functions.php');

/**
 * Template managment functions
 */
require_once('classes/includes/template_engine.php');

#----------------------------------------------------
# Objects - (do i have to say more ?)
#----------------------------------------------------
/**
 * Mobule object
 */
require_once('classes/objects/Module.php'); 

/**
 * Account object
 */
require_once('classes/objects/Account.php');

/**
 * Character object
 */
require_once('classes/objects/Character.php'); 

/**
 * Configuration object
 */
require_once('classes/objects/InitConfig.php'); 

/**
 * Loginpanel object
 */
require_once('classes/objects/LoginPanel.php'); 

#----------------------------------------------------
# Modules - classes that give html output for manager
#----------------------------------------------------
/**
 * Account profile module
 */
require_once('classes/modules/AccountProfile.php');

/**
 * Character profile module
 */
require_once('classes/modules/CharacterProfile.php');

/**
 * Registration module
 */
//require_once('classes/modules/Registration.php');
require_once('classes/modules/RegistMail.php');		//[JOJO]

/**
 * Search module
 */
require_once('classes/modules/Search.php');

/**
 * Online players module
 */
require_once('classes/modules/OnlinePlayers.php');

/**
 * AccountManager class (TheRoot)
 * Every other class will sub to this finally...
 * @author Lauri Lüüs <mad@webpoint.ee>
 * @version $Id: AccountManager.php 5 2005-05-25 19:28:13Z madest $
 * @package AccountManager
 */
class AccountManager
{
	/**
	 * Config object for account manager
	 */
	var $config;
	
	/**
	 * Constructor - when extending execute this in class constructor to set config
	 */
	function AccountManager()
	{
		$this->config = new InitConfig();
	}	
}
?>