/*
 * Decompiled with CFR 0.152.
 */
package javolution.context;

import javolution.context.Allocator;
import javolution.context.AllocatorContext;
import javolution.context.Context;
import javolution.context.ObjectFactory;
import javolution.util.FastMap;
import javolution.util.FastTable;

public class HeapContext
extends AllocatorContext {
    private static final ThreadLocal FACTORY_TO_ALLOCATOR = new ThreadLocal(){

        protected Object initialValue() {
            return new FastMap();
        }
    };
    private static final ThreadLocal ACTIVE_ALLOCATORS = new ThreadLocal(){

        protected Object initialValue() {
            return new FastTable();
        }
    };
    private static final Class CLASS = new HeapContext().getClass();

    public static HeapContext enter() {
        return (HeapContext)Context.enter(CLASS);
    }

    public static HeapContext exit() {
        return (HeapContext)Context.exit();
    }

    @Override
    protected void deactivate() {
        FastTable fastTable = (FastTable)ACTIVE_ALLOCATORS.get();
        int n = 0;
        int n2 = fastTable.size();
        while (n < n2) {
            ((Allocator)fastTable.get((int)n++)).user = null;
        }
        fastTable.clear();
    }

    @Override
    protected Allocator getAllocator(ObjectFactory objectFactory) {
        FastMap fastMap = (FastMap)FACTORY_TO_ALLOCATOR.get();
        HeapAllocator heapAllocator = (HeapAllocator)fastMap.get(objectFactory);
        if (heapAllocator == null) {
            heapAllocator = new HeapAllocator(objectFactory);
            fastMap.put(objectFactory, heapAllocator);
        }
        if (heapAllocator.user == null) {
            heapAllocator.user = Thread.currentThread();
            FastTable fastTable = (FastTable)ACTIVE_ALLOCATORS.get();
            fastTable.add(heapAllocator);
        }
        return heapAllocator;
    }

    @Override
    protected void enterAction() {
        this.getOuter().getAllocatorContext().deactivate();
    }

    @Override
    protected void exitAction() {
        this.deactivate();
    }

    private static final class HeapAllocator
    extends Allocator {
        private final ObjectFactory _factory;

        public HeapAllocator(ObjectFactory objectFactory) {
            this._factory = objectFactory;
        }

        protected Object allocate() {
            return this._factory.create();
        }

        protected void recycle(Object object) {
            if (this._factory.doCleanup()) {
                this._factory.cleanup(object);
            }
            if (this.queueSize >= this.queue.length) {
                this.resize();
            }
            this.queue[this.queueSize++] = object;
        }

        public String toString() {
            return "Heap allocator for " + this._factory.getClass();
        }
    }
}

