/*
 * This program is free software: you can redistribute it and/or modify it under
 * the terms of the GNU General Public License as published by the Free Software
 * Foundation, either version 3 of the License, or (at your option) any later
 * version.
 * 
 * This program is distributed in the hope that it will be useful, but WITHOUT
 * ANY WARRANTY; without even the implied warranty of MERCHANTABILITY or FITNESS
 * FOR A PARTICULAR PURPOSE. See the GNU General Public License for more
 * details.
 * 
 * You should have received a copy of the GNU General Public License along with
 * this program. If not, see <http://www.gnu.org/licenses/>.
 */
package net.sf.l2j.gameserver.communitybbs.Manager;

import java.io.File;
import java.io.FileNotFoundException;
import java.io.FileReader;
import java.io.FileWriter;
import java.io.IOException;
import java.io.LineNumberReader;
import java.util.StringTokenizer;

import javolution.text.TextBuilder;
import net.sf.l2j.Config;
import net.sf.l2j.gameserver.datatables.ClanTable;
import net.sf.l2j.gameserver.model.L2Clan;
import net.sf.l2j.gameserver.model.L2ClanMember;
import net.sf.l2j.gameserver.model.L2World;
import net.sf.l2j.gameserver.model.actor.instance.L2PcInstance;
import net.sf.l2j.gameserver.network.SystemMessageId;
import net.sf.l2j.gameserver.network.serverpackets.ShowBoard;
import net.sf.l2j.gameserver.network.serverpackets.SystemMessage;

/**
 * @editor  TSL
 */
public class ClanBBSManager extends BaseBBSManager
{
	private static ClanBBSManager _instance = new ClanBBSManager();
	
	/**
	 * @return
	 */
	public static ClanBBSManager getInstance()
	{
		return _instance;
	}
	
	/**
	 * @param command
	 * @param activeChar
	 */
	@Override
	public void parsecmd(String command, L2PcInstance activeChar)
	{
		if (command.equals("_bbsclan"))
		{
			if (activeChar.getClan() != null)
			{
				if (activeChar.getClan().getLevel() >= 2)
				{
					clanhome(activeChar);
				}
				else
				{
					clanlist(activeChar, 1);
				}
			}
			else
			{
				clanlist(activeChar, 1);
			}
		}
		else if (command.startsWith("_bbsclan_clanlist"))
		{
			if (command.equals("_bbsclan_clanlist"))
			{
				clanlist(activeChar, 1);
			}
			else if (command.startsWith("_bbsclan_clanlist;"))
			{
				StringTokenizer st = new StringTokenizer(command, ";");
				st.nextToken();
				int index = Integer.parseInt(st.nextToken());
				clanlist(activeChar, index);
			}
		}
		else if (command.startsWith("_bbsclan_clanhome"))
		{
			if (command.equals("_bbsclan_clanhome"))
			{
				clanhome(activeChar);
			}
			else if (command.startsWith("_bbsclan_clanhome;"))
			{
				StringTokenizer st = new StringTokenizer(command, ";");
				st.nextToken();
				int index = Integer.parseInt(st.nextToken());
				clanhome(activeChar, index);
			}
		}
		else if (command.startsWith("_bbsclan_clanadmin;"))
		{
			StringTokenizer st = new StringTokenizer(command, ";");
			st.nextToken();
			String subcmd = st.nextToken();
			String msgType = "";
			int clanId = Integer.parseInt(st.nextToken());
			if (activeChar.getClan() == null
			        || activeChar.getClan().getClanId() != clanId
			        || activeChar.getClan().getLeaderId() != activeChar.getObjectId())
			{
				activeChar.sendPacket(new SystemMessage(SystemMessageId.YOU_ARE_NOT_AUTHORIZED_TO_DO_THAT));
				parsecmd("_bbsclan_clanlist", activeChar);
				return;
			}
			
			if (subcmd.startsWith("new"))
			{
				if (subcmd.equals("newcomm"))
					msgType = "comment";
				else if (subcmd.equals("newanno"))
					msgType = "announce";
				showMsgEdit(activeChar, msgType, clanId);
			}
			else if (subcmd.startsWith("del"))
			{
				if (subcmd.equals("delcomm"))
					msgType = "comment";
				else if (subcmd.equals("delanno"))
					msgType = "announce";
				File file = new File(Config.DATAPACK_ROOT + "/data/clans/"
				        + msgType + "_" + clanId + ".txt");
				file.delete();
				clanhome(activeChar);
			}
		}
		else
		{
			separateAndSend("<html><body><br><br><center>the command: " + command + " is not implemented yet</center><br><br></body></html>", activeChar);
			
		}
	}
	
	/**
	 * @param activeChar
	 */
	private void clanlist(L2PcInstance activeChar, int index)
	{
		if (index < 1)
		{
			index = 1;
		}
		//header
		TextBuilder html = new TextBuilder("<html><body><br><br><center>");
		html.append("<table border=0 cellspacing=0 cellpadding=0>");
		html.append("<tr><td FIXWIDTH=15>&nbsp;</td>");
		html.append("<td width=610 height=30 align=left>");
		html.append("<a action=\"bypass _bbshome\"> &$377; </a>&nbsp;>&nbsp;<a action=\"bypass _bbsclan_clanlist\"> &$809; </a>");
		html.append("</td></tr></table>");
		html.append("<table border=0 cellspacing=0 cellpadding=0 width=610 bgcolor=434343>");
		html.append("<tr><td height=10></td></tr>");
		html.append("<tr>");
		html.append("<td fixWIDTH=5></td>");
		html.append("<td fixWIDTH=600>");
		html.append("<a action=\"bypass _bbsclan_clanhome;" + ((activeChar.getClan() != null) ? activeChar.getClan().getClanId() : 0) + "\">[&$802;]</a>&nbsp;&nbsp;");
		html.append("</td>");
		html.append("<td fixWIDTH=5></td>");
		html.append("</tr>");
		html.append("<tr><td height=10></td></tr>");
		html.append("</table>");
		//body
		html.append("<br>");
		html.append("<table border=0 cellspacing=0 cellpadding=2 bgcolor=5A5A5A width=610>");
		html.append("<tr>");
		html.append("<td FIXWIDTH=5></td>");
		html.append("<td FIXWIDTH=200 align=center>&$580;</td>");
		html.append("<td FIXWIDTH=200 align=center>&$342;</td>");
		html.append("<td FIXWIDTH=100 align=center>&$392;</td>");
		html.append("<td FIXWIDTH=100 align=center>&$1036;</td>");
		html.append("<td FIXWIDTH=5></td>");
		html.append("</tr>");
		html.append("</table>");
		html.append("<img src=\"L2UI.Squareblank\" width=\"610\" height=\"5\">");
		int cnt = 0;
		L2Clan[] clanList = ClanTable.getInstance().getClans();
		for (L2Clan cl : clanList)
		{
			if (cnt > (index - 1) * 12)
			{
				break;
			}
			if (cnt >= (index - 1) * 12)
			{
				if (cl == null) continue;
				html.append("<table border=0 cellspacing=0 cellpadding=5 width=610>");
				html.append("<tr> ");
				html.append("<td FIXWIDTH=5></td>");
				html.append("<td FIXWIDTH=200 align=center><a action=\"bypass _bbsclan_clanhome;" + cl.getClanId() + "\">" + cl.getName() + "</a></td>");
				html.append("<td FIXWIDTH=200 align=center>" + cl.getLeaderName() + "</td>");
				html.append("<td FIXWIDTH=100 align=center>" + cl.getLevel() + "</td>");
				html.append("<td FIXWIDTH=100 align=center>" + cl.getMembersCount() + "</td>");
				html.append("<td FIXWIDTH=5></td>");
				html.append("</tr>");
				html.append("</table>");
				html.append("<img src=\"L2UI.SquareGray\" width=\"610\" height=\"1\">");
			}
			cnt++;
		}
		html.append("<br>");
		html.append("<table cellpadding=0 cellspacing=2 border=0><tr>");
		int nbp = clanList.length / 12;
		if (nbp * 12 != clanList.length)
		{
			nbp++;
		}
		int startIdx = 1;
		if (index % 10 == 0)
			startIdx += 10 * ((index / 10) - 1);
		else
			startIdx += 10 * (index / 10);
		if (index > 10)
		{
			html.append("<td><button action=\"bypass _bbsclan_clanlist;" + (startIdx - 1) + "\" back=\"l2ui_ch3.prev1_down\" fore=\"l2ui_ch3.prev1\" width=16 height=16 ></td>");
		}
		else
		{
			html.append("<td><button action=\"\" back=\"l2ui_ch3.prev1_down\" fore=\"l2ui_ch3.prev1\" width=16 height=16 ></td>");
		}
		for (int i = startIdx; i <= nbp && i < startIdx + 10; i++)
		{
			if (i == index)
				html.append("<td> " + i + " </td>");
			else
				html.append("<td><a action=\"bypass _bbsclan_clanlist;" + i + "\"> " + i + " </a></td>");
		}
		if (startIdx + 10 <= nbp)
		{
			html.append("<td><button action=\"bypass _bbsclan_clanlist;" + (startIdx + 10) + "\" back=\"l2ui_ch3.next1_down\" fore=\"l2ui_ch3.next1\" width=16 height=16 ></td>");
		}
		else
		{
			html.append("<td><button action=\"\" back=\"l2ui_ch3.next1_down\" fore=\"l2ui_ch3.next1\" width=16 height=16 ></td>");
		}
		html.append("</tr></table>");
		html.append("</center>");
		html.append("</body>");
		html.append("</html>");
		separateAndSend(html.toString(), activeChar);
	}
	
	/**
	 * @param activeChar
	 */
	private void clanhome(L2PcInstance activeChar)
	{
		clanhome(activeChar, activeChar.getClan().getClanId());
	}
	
	/**
	 * @param activeChar
	 * @param clanId
	 */
	private void clanhome(L2PcInstance activeChar, int clanId)
	{
		L2Clan cl = ClanTable.getInstance().getClan(clanId);
		if (cl != null)
		{
			if (activeChar.getClan() != null
			        && activeChar.getClan().getClanId() == clanId
			        && cl.getLevel() < 2)
			{
				activeChar.sendPacket(new SystemMessage(SystemMessageId.NO_CB_IN_MY_CLAN));
				parsecmd("_bbsclan_clanlist", activeChar);
			}
			else
			{
				TextBuilder html = new TextBuilder("<html><body><center><br><br>");
				html.append("<table border=0 cellspacing=0 cellpadding=0>");
				html.append("<tr><td FIXWIDTH=15>&nbsp;</td>");
				html.append("<td width=610 height=30 align=left>");
				html.append("<a action=\"bypass _bbshome\"> &$377; </a>&nbsp;>&nbsp;<a action=\"bypass _bbsclan_clanlist\"> &$809; </a>&nbsp;>&nbsp;<a action=\"bypass _bbsclan_clanhome;" + clanId + "\"> &$802; </a>");
				html.append("</td></tr></table>");
				html.append("<table border=0 cellspacing=0 cellpadding=0 width=610 bgcolor=434343>");
				html.append("<tr><td height=10></td></tr>");
				html.append("<tr>");
				html.append("<td fixWIDTH=5></td>");
				html.append("<td fixwidth=600>");
				html.append("<a action=\"bypass _bbsclan_clanadmin;newcomm;" + clanId + "\">[&$423;&$424;]</a>&nbsp;");
				html.append("<a action=\"bypass _bbsclan_clanadmin;newanno;" + clanId + "\">[&$328;&$424;]</a>&nbsp;");
				html.append("<a action=\"bypass _bbscustom;msglist;clan\">[&$382;&$387;]</a>&nbsp;");
	//DELETE//	html.append("<a action=\"bypass _bbscustom;msgnew;clan\">[&$905;&$424;]</a>&nbsp;");	//[905[][424ҏW] //XXX:[JOJO]
				html.append("</td>");
				html.append("<td fixWIDTH=5></td>");
				html.append("</tr>");
				html.append("<tr><td height=10></td></tr>");
				html.append("</table>");
				html.append("<table border=0 cellspacing=0 cellpadding=0 width=610>");
				html.append("<tr><td height=10></td></tr>");
				html.append("<tr><td fixWIDTH=5></td>");
				html.append("<td fixwidth=290 valign=top>");
				html.append(getMsgData("comment", clanId));
				html.append("</td>");
				html.append("<td fixWIDTH=5></td>");
				html.append("<td fixWIDTH=5 align=center valign=top><img src=\"l2ui.squaregray\" width=2  height=128></td>");
				html.append("<td fixWIDTH=5></td>");
				html.append("<td fixwidth=295>");
				html.append("<table border=0 cellspacing=0 cellpadding=0 width=295>");
				html.append("<tr>");
				html.append("<td fixWIDTH=100 align=left>&$580;</td>");
				html.append("<td fixWIDTH=195 align=left>" + cl.getName() + "</td>");
				html.append("</tr>");
				html.append("<tr><td height=7></td></tr>");
				html.append("<tr>");
				html.append("<td fixWIDTH=100 align=left>&$342;</td>");
				html.append("<td fixWIDTH=195 align=left height=16>" + cl.getLeaderName() + "</td>");
				html.append("</tr>");
				html.append("<tr><td height=7></td></tr>");
				html.append("<tr>");
				html.append("<td fixWIDTH=100 align=left>&$392;</td>");
				html.append("<td fixWIDTH=195 align=left height=16>" + cl.getLevel() + "</td>");
				html.append("</tr>");
				html.append("<tr><td height=7></td></tr>");
				html.append("<tr>");
				html.append("<td fixWIDTH=100 align=left>&$1036;</td>");
				html.append("<td fixWIDTH=195 align=left height=16>" + cl.getMembersCount() + "</td>");
				html.append("</tr>");
				html.append("<tr><td height=7></td></tr>");
				html.append("<tr>");
				html.append("<td fixWIDTH=100 align=left>&$571;</td>");
				html.append("<td fixWIDTH=195 align=left height=16>" + ((cl.getAllyName() != null) ? cl.getAllyName() : "") + "</td>");
				html.append("</tr>");
				html.append("</table>");
				html.append("</td>");
				html.append("<td fixWIDTH=5></td>");
				html.append("</tr>");
				html.append("<tr><td height=10></td></tr>");
				html.append("</table>");
				html.append("<img src=\"L2UI.squareblank\" width=\"1\" height=\"5\">");
				html.append("<img src=\"L2UI.squaregray\" width=\"610\" height=\"1\">");
				html.append("<img src=\"L2UI.squareblank\" width=\"1\" height=\"5\">");
				html.append("<BR> &$1322;");
				html.append("<TABLE border=0 cellspacing=0 cellpadding=0 width=610>");
				html.append("<TR>");
				html.append("<TD fixWIDTH=5></td>");
				html.append("<TD fixWIDTH=600>");
				for (L2ClanMember member : cl.getMembers())
				{
					html.append("<A action=\"bypass _bbscustom;msgnew;private;" + member.getName() + "\">"
					        + member.getName() + "</A> ("
					        + ((L2World.getInstance().getPlayer(member.getName()) != null) ? "&$1006;" : "&$1007;")
					        + ") &nbsp;");
				}
				html.append("</TD>");
				html.append("<TD fixWIDTH=5></td>");
				html.append("</TR>");
				html.append("</TABLE>");
				html.append("</center>");
				html.append("</body>");
				html.append("</html>");
				separateAndSend(html.toString(), activeChar);
			}
		}
	}
	
	/**
	 * @param activeChar
	 * @param msgType
	 * @param clanId
	 */
	private void showMsgEdit(L2PcInstance activeChar, String msgType, int clanId)
	{
		TextBuilder html = new TextBuilder("<html>");
		html.append("<body><br><br>");
		html.append("<table border=0 width=610><tr><td width=10></td><td width=600 align=left>");
		html.append(getHeaderTree(msgType, clanId));
		html.append("</td></tr>");
		html.append("</table>");
		html.append("<img src=\"L2UI.squareblank\" width=\"1\" height=\"10\">");
		html.append("<center>");
		html.append("<table border=0 cellspacing=0 cellpadding=0>");
		html.append("<tr><td width=610><img src=\"sek.cbui355\" width=\"610\" height=\"1\"></td></tr>");
		html.append("</table>");
		html.append("<table fixwidth=610 border=0 cellspacing=0 cellpadding=0>");
		html.append("<tr><td><img src=\"l2ui.mini_logo\" width=5 height=10></td></tr>");
		html.append("<tr>");
		html.append("<td><img src=\"l2ui.mini_logo\" width=5 height=1></td>");
		html.append("<td align=center FIXWIDTH=60 height=29 valign=top>&$427;</td>");
		html.append("<td align=center FIXWIDTH=540><MultiEdit var=\"Content\" width=540 height=300></td>");
		html.append("<td><img src=\"l2ui.mini_logo\" width=5 height=1></td>");
		html.append("</tr>");
		html.append("<tr><td><img src=\"l2ui.mini_logo\" width=5 height=10></td></tr>");
		html.append("</table>");
		html.append("<img src=\"L2UI.squareblank\" width=\"1\" height=\"5\">");
		html.append("<img src=\"L2UI.squaregray\" width=\"610\" height=\"1\">");
		html.append("<img src=\"L2UI.squareblank\" width=\"1\" height=\"5\">");
		html.append("<table fixwidth=610 border=0 cellspacing=0 cellpadding=0>");
		html.append("<tr><td><img src=\"l2ui.mini_logo\" width=5 height=10></td></tr>");
		html.append("<tr>");
		html.append("<td><img src=\"l2ui.mini_logo\" width=5 height=1></td>");
		html.append("<td align=center FIXWIDTH=60 height=29>&nbsp;</td>");
		html.append("<td align=center FIXWIDTH=70><button value=\"&$424;\" action=\"Write Clan " + msgType + " " + clanId + " Content Content Content\" back=\"L2UI_CT1.BUTTON_DF_DOWN\" width=65 height=20 fore=\"L2UI_CT1.BUTTON_DF\"></td>");
		html.append("<td align=center FIXWIDTH=70><button value=\"&$425;\" action=\"bypass _bbsclan_clanadmin;" + ((msgType.equals("comment") ? "delcomm" : "delanno")) + ";" + clanId + "\" back=\"L2UI_CT1.BUTTON_DF_DOWN\" width=65 height=20 fore=\"L2UI_CT1.BUTTON_DF\" ></td>&nbsp;");
		html.append("<td align=center FIXWIDTH=70><button value=\"&$141;\" action=\"bypass _bbsclan_clanhome\" back=\"L2UI_CT1.BUTTON_DF_DOWN\" width=65 height=20 fore=\"L2UI_CT1.BUTTON_DF\"></td>");
		html.append("<td align=center FIXWIDTH=330>&nbsp;</td>");
		html.append("<td><img src=\"l2ui.mini_logo\" width=5 height=1></td>");
		html.append("</tr></table>");
		html.append("</center>");
		html.append("</body>");
		html.append("</html>");
		separateAndSend(html.toString(), activeChar);
	}
    
	/* (non-Javadoc)
	 * @see net.sf.l2j.gameserver.communitybbs.Manager.BaseBBSManager#parsewrite(java.lang.String, java.lang.String, java.lang.String, java.lang.String, java.lang.String, net.sf.l2j.gameserver.model.actor.instance.L2PcInstance)
	 */
	@Override
	public void parsewrite(String ar1, String ar2, String ar3, String ar4, String ar5, L2PcInstance activeChar)
	{
		if (activeChar == null)
			return;
		
		if (ar1.equals("comment") || ar1.equals("announce"))
		{
			setMsgData(ar1, Integer.valueOf(ar2), ar3);
			parsecmd("_bbsclan_clanhome", activeChar);
		}
		else
		{
			ShowBoard sb = new ShowBoard("<html><body><br><br><center>the command: " + ar1 + " is not implemented yet</center><br><br></body></html>", "101");
			activeChar.sendPacket(sb);
			activeChar.sendPacket(new ShowBoard(null, "102"));
			activeChar.sendPacket(new ShowBoard(null, "103"));
		}
	}

	/**
	 * @param msgType
	 * @param clanId
	 */
    public String getMsgData(String msgType, int clanId)
	{
		File file = new File(Config.DATAPACK_ROOT + "/data/clans/" + msgType + "_" + clanId + ".txt");
		LineNumberReader lnr = null;
		String MsgData = "";
		try
		{
			String line = null;
			lnr = new LineNumberReader(new FileReader(file));
			while ((line = lnr.readLine()) != null)
			{
				MsgData += line;
			}
		}
		catch (FileNotFoundException e)
		{
		}
		catch (IOException e)
		{
			e.printStackTrace();
		}
		finally
		{
		}
		return MsgData;
	}
    
	/**
	 * @param msgType
	 * @param clanId
	 * @param MsgData
	 */
    private void setMsgData(String msgType, int clanId, String MsgData)
	{
		File file = new File(Config.DATAPACK_ROOT + "/data/clans/" + msgType + "_" + clanId + ".txt");
		try
		{
			file.createNewFile();
			FileWriter save = new FileWriter(file);
			MsgData = MsgData.replace("\r\n", "<br1>\r\n");
			save.write(MsgData);
			save.close();
		}
		catch (FileNotFoundException e)
		{
		}
		catch (IOException e)
		{
			e.printStackTrace();
		}
		finally
		{
		}
	}
    
	/**
	 * @param msgType
	 * @param clanId
	 */
	private String getHeaderTree(String msgType, int clanId)
	{
		String html = "";
		if (msgType.equals("comment"))
		{
			html = "<a action=\"bypass _bbshome\"> &$377; </a>&nbsp;>&nbsp;"
			        + "<a action=\"bypass _bbsclan_clanlist\"> &$809; </a>&nbsp;>&nbsp;"
			        + "<a action=\"bypass _bbsclan_clanhome;" + clanId
			        + "\"> &$802; </a>&nbsp;>&nbsp;"
			        + "<a action=\"bypass _bbsclan_clanadmin;newcomm;" + clanId
			        + "\"> &$423;&$424;";
		}
		else if (msgType.equals("announce"))
		{
			html = "<a action=\"bypass _bbshome\"> &$377; </a>&nbsp;>&nbsp;"
			        + "<a action=\"bypass _bbsclan_clanlist\"> &$809; </a>&nbsp;>&nbsp;"
			        + "<a action=\"bypass _bbsclan_clanhome;" + clanId
			        + "\"> &$802; </a>&nbsp;>&nbsp;"
			        + "<a action=\"bypass _bbsclan_clanadmin;newanno;" + clanId
			        + "\"> &$328;&$424;";
		}
		return html;
	}
}