/*
 * This program is free software: you can redistribute it and/or modify it under
 * the terms of the GNU General Public License as published by the Free Software
 * Foundation, either version 3 of the License, or (at your option) any later
 * version.
 * 
 * This program is distributed in the hope that it will be useful, but WITHOUT
 * ANY WARRANTY; without even the implied warranty of MERCHANTABILITY or FITNESS
 * FOR A PARTICULAR PURPOSE. See the GNU General Public License for more
 * details.
 * 
 * You should have received a copy of the GNU General Public License along with
 * this program. If not, see <http://www.gnu.org/licenses/>.
 */
package net.sf.l2j.gameserver.handler.skillhandlers;

import net.sf.l2j.gameserver.ai.CtrlIntention;
import net.sf.l2j.gameserver.handler.ISkillHandler;
import net.sf.l2j.gameserver.model.L2Character;
import net.sf.l2j.gameserver.model.L2Object;
import net.sf.l2j.gameserver.model.L2Skill;
import net.sf.l2j.gameserver.model.actor.instance.L2ChestInstance;
import net.sf.l2j.gameserver.model.actor.instance.L2DoorInstance;
import net.sf.l2j.gameserver.model.actor.instance.L2PcInstance;
import net.sf.l2j.gameserver.network.SystemMessageId;
import net.sf.l2j.gameserver.network.serverpackets.ActionFailed;
import net.sf.l2j.gameserver.network.serverpackets.SocialAction;
import net.sf.l2j.gameserver.network.serverpackets.SystemMessage;
import net.sf.l2j.gameserver.skills.Formulas;
import net.sf.l2j.gameserver.templates.skills.L2SkillType;
import net.sf.l2j.util.Rnd;

public class Unlock implements ISkillHandler
{
	private static final L2SkillType[] SKILL_IDS =
	{
		L2SkillType.UNLOCK
	};
	
	/**
	 * 
	 * @see net.sf.l2j.gameserver.handler.ISkillHandler#useSkill(net.sf.l2j.gameserver.model.L2Character, net.sf.l2j.gameserver.model.L2Skill, net.sf.l2j.gameserver.model.L2Object[])
	 */
	public void useSkill(L2Character activeChar, L2Skill skill, L2Object[] targets)
	{

		// [L2J_JP SANDMAN ADD START]
		final int keyId = 1661;
		int keyCnt = 0;
		int delKeyCnt = 0;
		if(activeChar instanceof L2PcInstance)
		{
			L2PcInstance pc = (L2PcInstance)activeChar;
			if(pc.getInventory().getItemByItemId(keyId) != null)
			{
				keyCnt = pc.getInventory().getItemByItemId(keyId).getCount();
			}
			else
			{
				pc.sendPacket(new SystemMessage(SystemMessageId.THERE_ARE_NOT_ENOUGH_NECESSARY_ITEMS_TO_USE_THE_SKILL));
				pc.sendPacket(ActionFailed.STATIC_PACKET);
				return;
			}

			switch (skill.getLevel())
			{
			case 1:
			case 2:
				if (keyCnt < 2)
				{
					pc.sendPacket(new SystemMessage(SystemMessageId.THERE_ARE_NOT_ENOUGH_NECESSARY_ITEMS_TO_USE_THE_SKILL));
					pc.sendPacket(ActionFailed.STATIC_PACKET);
					return;
				}
				else
					delKeyCnt = 2;
				break;
			case 3:
			case 4:
				if (keyCnt < 3)
				{
					pc.sendPacket(new SystemMessage(SystemMessageId.THERE_ARE_NOT_ENOUGH_NECESSARY_ITEMS_TO_USE_THE_SKILL));
					pc.sendPacket(ActionFailed.STATIC_PACKET);
					return;
				}
				else
					delKeyCnt = 3;
				break;
			case 5:
				if (keyCnt < 4)
				{
					pc.sendPacket(new SystemMessage(SystemMessageId.THERE_ARE_NOT_ENOUGH_NECESSARY_ITEMS_TO_USE_THE_SKILL));
					pc.sendPacket(ActionFailed.STATIC_PACKET);
					return;
				}
				else
					delKeyCnt = 4;
				break;
			case 6:
				if (keyCnt < 5)
				{
					pc.sendPacket(new SystemMessage(SystemMessageId.THERE_ARE_NOT_ENOUGH_NECESSARY_ITEMS_TO_USE_THE_SKILL));
					pc.sendPacket(ActionFailed.STATIC_PACKET);
					return;
				}
				else
					delKeyCnt = 5;
				break;
			case 7:
				if (keyCnt < 6)
				{
					pc.sendPacket(new SystemMessage(SystemMessageId.THERE_ARE_NOT_ENOUGH_NECESSARY_ITEMS_TO_USE_THE_SKILL));
					pc.sendPacket(ActionFailed.STATIC_PACKET);
					return;
				}
				else
					delKeyCnt = 6;
				break;
			case 8:
				if (keyCnt < 7)
				{
					pc.sendPacket(new SystemMessage(SystemMessageId.THERE_ARE_NOT_ENOUGH_NECESSARY_ITEMS_TO_USE_THE_SKILL));
					pc.sendPacket(ActionFailed.STATIC_PACKET);
					return;
				}
				else
					delKeyCnt = 7;
				break;
			case 9:
				if (keyCnt < 8)
				{
					pc.sendPacket(new SystemMessage(SystemMessageId.THERE_ARE_NOT_ENOUGH_NECESSARY_ITEMS_TO_USE_THE_SKILL));
					pc.sendPacket(ActionFailed.STATIC_PACKET);
					return;
				}
				else
					delKeyCnt = 8;
				break;
			case 10:
				if (keyCnt < 10)
				{
					pc.sendPacket(new SystemMessage(SystemMessageId.THERE_ARE_NOT_ENOUGH_NECESSARY_ITEMS_TO_USE_THE_SKILL));
					pc.sendPacket(ActionFailed.STATIC_PACKET);
					return;
				}
				else
					delKeyCnt = 10;
				break;
			case 11:
				if (keyCnt < 11)
				{
					pc.sendPacket(new SystemMessage(SystemMessageId.THERE_ARE_NOT_ENOUGH_NECESSARY_ITEMS_TO_USE_THE_SKILL));
					pc.sendPacket(ActionFailed.STATIC_PACKET);
					return;
				}
				else
					delKeyCnt = 11;
				break;
			case 12:
				if (keyCnt < 13)
				{
					pc.sendPacket(new SystemMessage(SystemMessageId.THERE_ARE_NOT_ENOUGH_NECESSARY_ITEMS_TO_USE_THE_SKILL));
					pc.sendPacket(ActionFailed.STATIC_PACKET);
					return;
				}
				else
					delKeyCnt = 13;
				break;
			case 13:
				if (keyCnt < 15)
				{
					pc.sendPacket(new SystemMessage(SystemMessageId.THERE_ARE_NOT_ENOUGH_NECESSARY_ITEMS_TO_USE_THE_SKILL));
					pc.sendPacket(ActionFailed.STATIC_PACKET);
					return;
				}
				else
					delKeyCnt = 15;
				break;
			case 14:
				if (keyCnt < 17)
				{
					pc.sendPacket(new SystemMessage(SystemMessageId.THERE_ARE_NOT_ENOUGH_NECESSARY_ITEMS_TO_USE_THE_SKILL));
					pc.sendPacket(ActionFailed.STATIC_PACKET);
					return;
				}
				else
					delKeyCnt = 17;
				break;
			default:
				if (keyCnt < 2)
				{
					pc.sendPacket(new SystemMessage(SystemMessageId.THERE_ARE_NOT_ENOUGH_NECESSARY_ITEMS_TO_USE_THE_SKILL));
					pc.sendPacket(ActionFailed.STATIC_PACKET);
					return;
				}
				else
					delKeyCnt = 2;
				break;

			}
		}
		// [L2J_JP SANDMAN ADD END]

		L2Object[] targetList = skill.getTargetList(activeChar);
		
		if (targetList == null)
			return;
		
		for (L2Object target: targets)
		{
//			boolean success = Formulas.getInstance().calculateUnlockChance(skill);	//XXX:[JOJO]-
			// [L2J_JP EDIT SANDMAN START]
			if (target instanceof L2DoorInstance)
			{
				L2DoorInstance door = (L2DoorInstance) target;
				if (!door.isUnlockable() || door.getFort() != null)
				{
					activeChar.sendPacket(new SystemMessage(SystemMessageId.UNABLE_TO_UNLOCK_DOOR));
					activeChar.sendPacket(ActionFailed.STATIC_PACKET);
					return;
				}
				
//<<<<<<< .mine (.r2557)
//				if (Formulas.getInstance().calculateUnlockDoor(skill,door) && (door.getOpen() == 1)) //[L2J_JP]+
				boolean success = Formulas.getInstance().calculateUnlockChance_L2J_JP(skill,door); //XXX:[JOJO]+
//=======
				if (success && (!door.getOpen()))
//>>>>>>> .r2557
				{
					door.openMe();
					door.onOpen();
					activeChar.sendMessage("Unlock the door!");

					if (activeChar instanceof L2PcInstance)
					{
						L2PcInstance pc = (L2PcInstance)activeChar;
						if(pc.getInventory().getItemByItemId(keyId) != null)
						{
							pc.getInventory().destroyItemByItemId("Consume", keyId, delKeyCnt, pc, pc);
							SystemMessage sm = new SystemMessage(SystemMessageId.S2_S1_DISAPPEARED);
							sm.addItemName(keyId);
							sm.addNumber(delKeyCnt);
							pc.sendPacket(sm);
						}
					}
				}
				else
				{
					activeChar.sendPacket(new SystemMessage(SystemMessageId.FAILED_TO_UNLOCK_DOOR));
				}
			}
			else if (target instanceof L2ChestInstance)
			{
				L2ChestInstance chest = (L2ChestInstance) target;
				if (chest.getCurrentHp() <= 0 || chest.isInteracted())
				{
					activeChar.sendPacket(ActionFailed.STATIC_PACKET);
					return;
				}
				else
				{
					int chestTrapLimit = 0;
					
					if (chest.getLevel() > 60) chestTrapLimit = 80;
					else if (chest.getLevel() > 40) chestTrapLimit = 50;
					else if (chest.getLevel() > 30) chestTrapLimit = 30;
					else chestTrapLimit = 10;
					
					if (Formulas.getInstance().calculateUnlockChest(skill, chest))
					{
						activeChar.broadcastPacket(new SocialAction(activeChar.getObjectId(), 3));
						chest.setSpecialDrop();
						chest.setMustRewardExpSp(false);
						chest.setInteracted();
						chest.reduceCurrentHp(99999999, activeChar);
					}
					else
					{
						activeChar.broadcastPacket(new SocialAction(activeChar.getObjectId(), 13));
						if (Rnd.get(100) < chestTrapLimit)
							chest.chestTrap(activeChar);
						chest.setInteracted();
						chest.addDamageHate(activeChar, 0, 1);
						chest.getAI().setIntention(CtrlIntention.AI_INTENTION_ATTACK, activeChar);
					}
				}
				// [L2J_JP EDIT SANDMAN END]
			}
		}
	}
	
	/**
	 * 
	 * @see net.sf.l2j.gameserver.handler.ISkillHandler#getSkillIds()
	 */
	public L2SkillType[] getSkillIds()
	{
		return SKILL_IDS;
	}
}
