/*
 * This program is free software: you can redistribute it and/or modify it under
 * the terms of the GNU General Public License as published by the Free Software
 * Foundation, either version 3 of the License, or (at your option) any later
 * version.
 *
 * This program is distributed in the hope that it will be useful, but WITHOUT
 * ANY WARRANTY; without even the implied warranty of MERCHANTABILITY or FITNESS
 * FOR A PARTICULAR PURPOSE. See the GNU General Public License for more
 * details.
 *
 * You should have received a copy of the GNU General Public License along with
 * this program. If not, see <http://www.gnu.org/licenses/>.
 */
package net.sf.l2j.gameserver.instancemanager.lastimperialtomb;

/**
 * @author Darki699
 */

import java.util.logging.Logger;
import java.util.concurrent.Future;
import java.util.Calendar;
import java.util.Date;
import java.util.List;
import java.util.Map;

import javolution.util.FastMap;
import net.sf.l2j.Config;
import net.sf.l2j.gameserver.GmListTable;
import net.sf.l2j.gameserver.ThreadPoolManager;
import net.sf.l2j.gameserver.ai.CtrlIntention;
import net.sf.l2j.gameserver.datatables.NpcTable;
import net.sf.l2j.gameserver.datatables.SpawnTable;
import net.sf.l2j.gameserver.instancemanager.GrandBossManager;
import net.sf.l2j.gameserver.instancemanager.lastimperialtomb.LastImperialTombManager;
import net.sf.l2j.gameserver.model.L2CharPosition;
import net.sf.l2j.gameserver.model.L2Character;
import net.sf.l2j.gameserver.model.L2Spawn;
import net.sf.l2j.gameserver.model.actor.instance.L2GrandBossInstance;
import net.sf.l2j.gameserver.model.actor.instance.L2MonsterInstance;
import net.sf.l2j.gameserver.model.actor.instance.L2NpcInstance;
import net.sf.l2j.gameserver.model.actor.instance.L2PcInstance;
import net.sf.l2j.gameserver.model.actor.status.GrandBossStatus;
import net.sf.l2j.gameserver.network.serverpackets.Earthquake;
import net.sf.l2j.gameserver.network.serverpackets.NpcInfo;
import net.sf.l2j.gameserver.network.serverpackets.MagicSkillUse;
import net.sf.l2j.gameserver.network.serverpackets.SocialAction;
import net.sf.l2j.gameserver.network.serverpackets.StopMove;
import net.sf.l2j.gameserver.templates.chars.L2NpcTemplate;
import net.sf.l2j.gameserver.templates.StatsSet;
import net.sf.l2j.gameserver.util.Util;
import net.sf.l2j.util.Point3D;
import net.sf.l2j.util.Rnd;

/**
 * control for sequence of Frintezza and Scarlet Van Halisha and their minions.
 *
 * @version 1.00.002
 * @author Darki699
 * @author SANDMAN L2J_JP(modified)
 * NOTE:
 * The class is divided from an original source file for making to L2J_LP.
 * Work has not been completed yet. now
 * Therefore, a lot of incomplete operation exists.
 */

public class FrintezzaManager
{
	
	protected static Logger _log = Logger.getLogger(FrintezzaManager.class.getName());
	
	private static FrintezzaManager _instance = new FrintezzaManager();
	
	// Must be done this way :( Each of the 11 mobs is an individual with
	// different tasks and values
	// So there is no point to place them in an array
	protected static L2Spawn frintezzaSpawn, scarletSpawnWeak, scarletSpawnStrong
//		, scarletDummySpawn, organDummySpawn, organDummySpawn2
			, portraitSpawn1, portraitSpawn2, portraitSpawn3, portraitSpawn4
			, demonSpawn1, demonSpawn2, demonSpawn3, demonSpawn4, cubeSpawn;
	
	protected static L2GrandBossInstance frintezza, weakScarlet, strongScarlet, portrait1, portrait2, portrait3, portrait4;
	
	// The minions be used as L2MonsterInstance, instead of L2MinionInstance, since they
	// have 3 Bosses: weak scarlet, strong scarlet, and frintezza. All 3 bosses control
	// the minions. Also we do not want the portraits to respawn next to the boss,
	// and we need different respawn intervals for
	// demons and portraits.
	protected static L2MonsterInstance demon1, demon2, demon3, demon4/*, scarletDummy, organDummy, organDummy2*/;
	protected static L2NpcInstance cube;
	
	// Interval time of Monsters.
	protected int _intervalOfBoss, _intervalOfDemons, _intervalOfRetarget, _intervalOfFrintezzaSongs, _callForHelpInterval;
	
	// Delay of appearance time of Boss.
	protected int					_appTimeOfBoss;

	// Activity time of Boss.
	protected int					_activityTimeOfBoss;
	
	// lists of last saved positions <objectId, location>
	protected Map<Integer, Point3D> _lastLocation = new FastMap<Integer, Point3D>();
	
	// status in lair.
	protected boolean _isBossSpawned = false, _isIntervalForNextSpawn = false,
			_respawningDemon1 = false, _respawningDemon2 = false,
			_respawningDemon3 = false, _respawningDemon4 = false,
			_scarletIsWeakest = true;
	
	protected Future<?> _monsterSpawnTask = null;
	protected Future<?> _activityTimeEndTask = null;
	protected Future<?> _IntervalEndTask = null;
	
	// Actually questname should be "Last Imperial Prince" or "Journey to a Settlement"
	protected String _questName = "lastimperialtomb";
	// status in lair.
//	protected String _zoneType = "LastImperialTomb";	//-[JOJO]
	protected StatsSet _stateSet;
	protected int _alive;
	protected int _bossId = 29045;
	
	// state of Scarlet Van Halisha.
	// 1:Weak 2:Weak(2nd Morph) 3:Strong
	protected int SVHType = 0;
	
	/** ************************************ Initial Functions ************************************* */
	
	/**
	 * Empty constructor Does nothing
	 */
	private FrintezzaManager()
	{
		// nothing.
	}
	
	/**
	 * returns an instance of <b>this</b> InstanceManager.
	 */
	public static FrintezzaManager getInstance()
	{
		return _instance;
	}
	
	/**
	 * initialize <b>this</b> Frintezza Manager
	 */
	public void init()
	{
		_callForHelpInterval = 2000;
		
		_intervalOfRetarget = 10000;
		
		_intervalOfFrintezzaSongs = 30000;
		
		_intervalOfDemons	=	1*60000; 							//= Config.FWF_INTERVALOFNEXTMONSTER;
		_intervalOfBoss		=	1440*60000;							//= Config.FWF_INTERVALOFFRINTEZZA;
		_appTimeOfBoss		=	Config.LIT_APPTIMEOFFRINTEZZA;		//= Config.FWF_INTERVALOFNEXTMONSTER;
		_activityTimeOfBoss	=	Config.LIT_ACTIVITYTIMEOFFRINTEZZA;	//= Config.FWF_ACTIVITYTIMEOFFRINTEZZA;
		
		// initialize status in lair.
		_scarletIsWeakest = true;
		_isBossSpawned = false;
		_isIntervalForNextSpawn = false;
		_stateSet = GrandBossManager.getInstance().getStatsSet(_bossId);
		_alive = GrandBossManager.getInstance().getBossStatus(_bossId);
		
		// setting spawn data of monsters.
		try
		{
			createMonsterSpawns();
		}
		catch (Throwable t)
		{
			_log.warning(t.getMessage());
		}
		
		// When state of Frintezza is not "NOTSPAWN", it begins interval.
		_log.info("FrintezzaManager : State of Frintezza is " + _alive + ".");
		if (_alive != GrandBossStatus.NOTSPAWN)
			setInetrvalEndTask();
		
		Date dt = new Date(_stateSet.getLong("respawn_time"));
		_log.info("FrintezzaManager : Next spawn date of Frintezza is " + dt + ".");
		
		_log.info("FrintezzaManager : Init FrintezzaManager.");
	}
	
	/** ***************************** Spawn Manager Creates all spawns ******************************** */
	
	/**
	 * Makes a spawn of all monsters, but doe not spawn them yet
	 */
	private void createMonsterSpawns()
	{
		
		// The boss of all bosses ofcourse
		frintezzaSpawn = createNewSpawn(29045, 174240, -89805, -5022, 16048, _intervalOfBoss);	//tebT
//	organDummySpawn = createNewSpawn(29052, 174240, -89955, -5006, 16048, 60);		//()
//	organDummySpawn2 = createNewSpawn(29052, 172450, -88313, -5089, 16048, 60);		//()
//	scarletDummySpawn = createNewSpawn(29053, 174232, -88020, -5114, 16384, 60);	//()
		
		// weak Scarlet Van Halisha.
		scarletSpawnWeak = createNewSpawn(29046, 174232, -88020, -5114, 16384, _intervalOfBoss);	//XJ[bg @ nV
		
		// Strong Scarlet Van Halisha -> x , y , z , heading, and Hp are set when the morph actually
		// happens.
		scarletSpawnStrong = createNewSpawn(29047, 174232, -88020, -5114, 16384, _intervalOfBoss);	//XJ[bg @ nV
		
		// Portrait spawns - 4 portraits = 4 spawns
		portraitSpawn1 = createNewSpawn(29048, 175833, -87165, -4972, 35048, _intervalOfBoss);	//GBCg

		portraitSpawn2 = createNewSpawn(29049, 175876, -88713, -4972, 28205, _intervalOfBoss);	//GBCg

		portraitSpawn3 = createNewSpawn(29048, 172608, -88702, -4972, 64817, _intervalOfBoss);	//GBCg

		portraitSpawn4 = createNewSpawn(29049, 172634, -87165, -4972, 57730, _intervalOfBoss);	//GBCg
		
		// Demon spawns - 4 portraits = 4 demons (?)
		demonSpawn1 = createNewSpawn(29050, 175833, -87165, -4972, 35048, _intervalOfDemons);	//nV uX

		demonSpawn2 = createNewSpawn(29051, 175876, -88713, -4972, 28205, _intervalOfDemons);	//nV uX

		demonSpawn3 = createNewSpawn(29051, 172608, -88702, -4972, 64817, _intervalOfDemons);	//nV uX

		demonSpawn4 = createNewSpawn(29050, 172634, -87165, -4972, 57730, _intervalOfDemons);	//nV uX
		
		// teleport cube
		cubeSpawn = createNewSpawn(29061, 174232, -88020, -5114, 16384, 60);	//e|[g L[u
	}
	
	/**
	 * Creates a single spawn from the parameter values and returns the L2Spawn created
	 *
	 * @param templateId
	 *            int value of the monster template id number
	 * @param x
	 *            int value of the X position
	 * @param y
	 *            int value of the Y position
	 * @param z
	 *            int value of the Z position
	 * @param heading
	 *            int value of where is the monster facing to...
	 * @param respawnDelay
	 *            int value of the respawn of this L2Spawn
	 * @return L2Spawn created
	 */
	private L2Spawn createNewSpawn(int templateId, int x, int y, int z, int heading, int respawnDelay)
	{
		L2Spawn tempSpawn = null;
		
		L2NpcTemplate template1;
		
		try
		{
			template1 = NpcTable.getInstance().getTemplate(templateId);
			tempSpawn = new L2Spawn(template1);
			
			tempSpawn.setLocx(x);
			tempSpawn.setLocy(y);
			tempSpawn.setLocz(z);
			tempSpawn.setHeading(heading);
			tempSpawn.setAmount(1);
			tempSpawn.setRespawnDelay(respawnDelay);
			tempSpawn.stopRespawn();
			
			SpawnTable.getInstance().addNewSpawn(tempSpawn, false);
			
		}
		catch (Throwable t)
		{
			_log.warning(t.getMessage());
		}
		return tempSpawn;
	}
	
	/** ***************************** Player control functions ******************************** */
	
	// Whether it lairs is confirmed.
	public boolean isEnableEnterToLair()
	{
		return _alive == GrandBossStatus.NOTSPAWN;
//-		if (_Alive == GrandBossStatus.NOTSPAWN)
//-			return true;
//-		else
//-			return false;
	}
	
	/** ************************ Starting the battle with Frintezza + co. ***************************** */
	
	/**
	 * setting Scarlet Van Halisha spawn task which also starts the whole Frintezza battle.
	 */
	public void setScarletSpawnTask()
	{
		// When no one invaded the lair, nothing is done.
		GmListTable.TRACE("__BASENAME__:__LINE__", "l=" + LastImperialTombManager.getInstance().getPlayersInLair().size() + " ,_alive=" + _alive);
//		if (LastImperialTombManager.getInstance().getPlayersInLair().size() < 1 || _alive != GrandBossStatus.NOTSPAWN)
//			return;
//		
//		if (_monsterSpawnTask == null)
		if (LastImperialTombManager.getInstance().getPlayersInLair().size() >= 1 && _alive == GrandBossStatus.NOTSPAWN && _monsterSpawnTask == null)
		{
			GmListTable.TRACE("__BASENAME__:__LINE__", (_appTimeOfBoss / 1000) + "bɃtebTo");
			_monsterSpawnTask = ThreadPoolManager.getInstance().scheduleEffect(new ScarletWeakSpawn(1), _appTimeOfBoss);
		}
	}
	
	/**
	 * Shows a movie to the players in the lair.
	 * 
	 * @param target -
	 *            L2NpcInstance target is the center of this movie
	 * @param dist -
	 *            int distance from target
	 * @param yaw -
	 *            angle of movie (north = 90, south = 270, east = 0 , west = 180)
	 * @param pitch -
	 *            pitch > 0 looks up / pitch < 0 looks down
	 * @param time -
	 *            fast ++ or slow -- depends on the value
	 * @param duration -
	 *            How long to watch the movie
	 * @param socialAction -
	 *            1,2,3 social actions / other values do nothing
	 */
	
	/*private*/ void showSocialActionMovie(L2NpcInstance target, int dist, int yaw, int pitch, int time, int duration, int socialAction)
	{
		if (target == null)
			return;

		// set camera.
		for (L2PcInstance pc : getPlayersInside())
		{

			setIdle(pc);

			pc.setTarget(null);

			if (pc.getPlanDistanceSq(target) <= 6502500)
			{
				pc.enterMovieMode();
				pc.specialCamera(target, dist, yaw, pitch, time, duration);
			}
			else
			{
				pc.leaveMovieMode();
			}
		}
		
		// do social.
		if (socialAction > 0 && socialAction < 5)
		{
			target.broadcastPacket(new SocialAction(target.getObjectId(), socialAction));
		}
	}
	
	/**
	 * I noticed that if the players do not stand at a certain position, they can not watch the entire movie, so I set them to the center during the entire
	 * movie.
	 */
	
	/*private*/ void teleportToStart()
	{
		if (_lastLocation == null)
			_lastLocation = new FastMap<Integer, Point3D>();
		
		Point3D p = new Point3D(174233, -88212, -5116);
		
		for (L2PcInstance pc : getPlayersInside())
		{
			if (pc.getX() != p.getX() && pc.getY() != p.getY() && pc.getZ() != p.getZ())
			{
				if (!_lastLocation.containsKey(pc.getObjectId()))
					_lastLocation.put(pc.getObjectId(), new Point3D(pc.getX(), pc.getY(), pc.getZ()));
				
				pc.teleToLocation(p.getX(), p.getY(), p.getZ());
			}
			
		}
		
	}

	/**
	 * Teleports the players back to their last positions before the movie started
	 */
	
	private void teleportToFinish()
	{
		if (_lastLocation == null || _lastLocation.isEmpty())
			return;

		for (L2PcInstance pc : getPlayersInside())
		{
			if (_lastLocation.containsKey(pc.getObjectId()))
			{
				Point3D loc = _lastLocation.get(pc.getObjectId());
				pc.teleToLocation(loc.getX(), loc.getY(), loc.getZ());
			}
		}
		_lastLocation.clear();
	}
	
	/** ************************** Initialize a movie and spawn the monsters *********************** */
	
	/**
	 * Spawns Frintezza, the weak version of Scarlet Van Halisha, the minions, and all that is shown in a movie to the observing players.
	 */
	private class ScarletWeakSpawn implements Runnable
	{
		private int	_taskId	= 0;

		public ScarletWeakSpawn(int taskId)
		{
			_taskId = taskId;
		}

		public void run()
		{
			if (SVHType == 1)
				return;
			
			SocialAction sa = null;
			
			switch (_taskId)
			{
			
			case 1: // spawn
				GmListTable.TRACE("__BASENAME__:__LINE__", "tebToꂵ܂B");
				frintezza = (L2GrandBossInstance) frintezzaSpawn.doSpawn();
				frintezza.setIsInvul(true);
				frintezza.setIsImmobilized(true);
				frintezza.disableAllSkills();
				frintezza.setIsInSocialAction(true);
				OrganManager.getInstance().setPlayer(frintezza);
				
//			organDummy = (L2MonsterInstance) organDummySpawn.doSpawn();
//			organDummy.setIsInvul(true);
//			organDummy.setIsImmobilized(true);
//			
//			organDummy2 = (L2MonsterInstance) organDummySpawn2.doSpawn();
//			organDummy2.setIsInvul(true);
//			organDummy2.setIsImmobilized(true);
//			
//			scarletDummy = (L2MonsterInstance) scarletDummySpawn.doSpawn();
//			scarletDummy.setIsInvul(true);
//			scarletDummy.setIsImmobilized(true);
				
				updateKnownList(frintezza);
//			updateKnownList(scarletDummy);
//			updateKnownList(organDummy2);
				
//				_monsterSpawnTask = ThreadPoolManager.getInstance().scheduleGeneral(new ScarletWeakSpawn(2), 1000);
				
				_stateSet.set("respawn_time", Calendar.getInstance().getTimeInMillis() + Rnd.get(Config.LIT_FIXINTERVALOFFRINTEZZA, Config.LIT_FIXINTERVALOFFRINTEZZA + Config.LIT_RANDOMINTERVALOFFRINTEZZA)
						+ Config.LIT_ACTIVITYTIMEOFFRINTEZZA);
				_alive = GrandBossStatus.ALIVE;
				GrandBossManager.getInstance().setBossStatus(_bossId, _alive);
				GrandBossManager.getInstance().setStatsSet(_bossId, _stateSet);
				GrandBossManager.getInstance().save();
				_log.info("FrintezzaManager : Spawn Frintezza.");
				
				teleportToStart();

				// set next task.
				ThreadPoolManager.getInstance().scheduleGeneral(new ScarletWeakSpawn(2), 1000);
				break;
			
			case 2:
				System.out.println("__BASENAME__:__LINE__: doWeakScarletSpawn#2");
				// show movie
				showSocialActionMovie(frintezza, 1000, 90, 30, 0, 5000, 0);
				
				// set next task.
				ThreadPoolManager.getInstance().scheduleGeneral(new ScarletWeakSpawn(200), 3000);
				
//				// set camera.
//				for (L2PcInstance pc : LastImperialTombManager.getInstance().getPlayersInLair())
//				{
//					pc.enterMovieMode();
//				pc.specialCamera(scarletDummy, 50, 75, -85, 0, 10000);
//				}
//				_monsterSpawnTask = ThreadPoolManager.getInstance().scheduleGeneral(new ScarletWeakSpawn(200), 3000);
				break;
				
			case 200:
				// show movie
				showSocialActionMovie(frintezza, 1000, 90, 30, 0, 5000, 0);

				// set next task.
				ThreadPoolManager.getInstance().scheduleGeneral(new ScarletWeakSpawn(3), 3000);
				break;
				
			case 3:
				System.out.println("__BASENAME__:__LINE__: doWeakScarletSpawn#3");
				// show movie
				showSocialActionMovie(frintezza, 140, 90, 0, 6000, 6000, 2);

				// set next task.
				ThreadPoolManager.getInstance().scheduleGeneral(new ScarletWeakSpawn(5), 5990);
//				// set camera.
//				for (L2PcInstance pc : LastImperialTombManager.getInstance().getPlayersInLair())
//				{
//					pc.enterMovieMode();
//				pc.specialCamera(scarletDummy, 50, 105, -10, 7000, 10000);
//				}
//				
//				_monsterSpawnTask = ThreadPoolManager.getInstance().scheduleGeneral(new ScarletWeakSpawn(4), 5500);
				break;
				
//			case 4:
//				System.out.println("__BASENAME__:__LINE__: doWeakScarletSpawn#4");
//				// set camera.
//				for (L2PcInstance pc : LastImperialTombManager.getInstance().getPlayersInLair())
//				{
//					pc.enterMovieMode();
//					pc.specialCamera(frintezza, 1500, 100, 10, 0, 10000);
//				}
//				
//				_monsterSpawnTask = ThreadPoolManager.getInstance().scheduleGeneral(new ScarletWeakSpawn(5), 100);
//				break;
//			
			case 5:
				System.out.println("__BASENAME__:__LINE__: doWeakScarletSpawn#5");
				// show movie
				showSocialActionMovie(frintezza, 240, 90, 3, 22000, 6000, 3);

				// set next task.
				ThreadPoolManager.getInstance().scheduleGeneral(new ScarletWeakSpawn(6), 5800);
//				// set camera.
//				for (L2PcInstance pc : LastImperialTombManager.getInstance().getPlayersInLair())
//				{
//					pc.enterMovieMode();
//					pc.specialCamera(frintezza, 140, 90, 0, 4000, 10000);
//				}
//				
//				_monsterSpawnTask = ThreadPoolManager.getInstance().scheduleGeneral(new ScarletWeakSpawn(6), 4900);
				break;
			
			case 6:
				System.out.println("__BASENAME__:__LINE__: doWeakScarletSpawn#6");
				// show movie
				showSocialActionMovie(frintezza, 240, 90, 3, 300, 6000, 0);
				frintezza.broadcastPacket(new MagicSkillUse(frintezza, frintezza, 5006, 1, _intervalOfFrintezzaSongs, 0), 360000/* 600 */);

				// set next task.
				ThreadPoolManager.getInstance().scheduleGeneral(new ScarletWeakSpawn(7), 5800);
				
				weakScarlet = (L2GrandBossInstance) scarletSpawnWeak.doSpawn();
				weakScarlet.setIsImmobilized(true);
				weakScarlet.setIsInSocialAction(true);
//				// set camera.
//				for (L2PcInstance pc : LastImperialTombManager.getInstance().getPlayersInLair())
//				{
//					pc.enterMovieMode();
//					pc.specialCamera(frintezza, 40, 75, -10, 0, 10000);
//				}
//				
//				_monsterSpawnTask = ThreadPoolManager.getInstance().scheduleGeneral(new ScarletWeakSpawn(7), 500);
//				break;
//			
//			case 7:
//				System.out.println("__BASENAME__:__LINE__: doWeakScarletSpawn#7");	//
				portrait1 = (L2GrandBossInstance) portraitSpawn1.doSpawn();	System.out.println("__BASENAME__:__LINE__:");
				portrait1.setIsImmobilized(true);							System.out.println("__BASENAME__:__LINE__:");
				
				portrait2 = (L2GrandBossInstance) portraitSpawn2.doSpawn();	System.out.println("__BASENAME__:__LINE__:");
				portrait2.setIsImmobilized(true);							System.out.println("__BASENAME__:__LINE__:");
				
				portrait3 = (L2GrandBossInstance) portraitSpawn3.doSpawn();	System.out.println("__BASENAME__:__LINE__:");
				portrait3.setIsImmobilized(true);							System.out.println("__BASENAME__:__LINE__:");
				
				portrait4 = (L2GrandBossInstance) portraitSpawn4.doSpawn();	System.out.println("__BASENAME__:__LINE__:");
				portrait4.setIsImmobilized(true);							System.out.println("__BASENAME__:__LINE__:");
				
				demon1 = (L2MonsterInstance) demonSpawn1.doSpawn();	System.out.println("__BASENAME__:__LINE__:");
				demon1.setIsImmobilized(true);
				
				demon2 = (L2MonsterInstance) demonSpawn2.doSpawn();	System.out.println("__BASENAME__:__LINE__:");
				demon2.setIsImmobilized(true);
				
				demon3 = (L2MonsterInstance) demonSpawn3.doSpawn();	System.out.println("__BASENAME__:__LINE__:");
				demon3.setIsImmobilized(true);
				
				demon4 = (L2MonsterInstance) demonSpawn4.doSpawn();	System.out.println("__BASENAME__:__LINE__:");
				demon4.setIsImmobilized(true);
				
				System.out.println("__BASENAME__:__LINE__:");
				updateKnownList(demon1);
				updateKnownList(demon2);
				updateKnownList(demon3);
				updateKnownList(demon4);
				System.out.println("__BASENAME__:__LINE__:");
				
				// do social.
				updateKnownList(frintezza);
				System.out.println("__BASENAME__:__LINE__:");
				sa = new SocialAction(frintezza.getObjectId(), 2);
				frintezza.broadcastPacket(sa);
				System.out.println("__BASENAME__:__LINE__:");
				
				_monsterSpawnTask = ThreadPoolManager.getInstance().scheduleGeneral(new ScarletWeakSpawn(8), 7400);
				System.out.println("__BASENAME__:__LINE__:");

				Earthquake eq = new Earthquake(weakScarlet.getX(), weakScarlet.getY(), weakScarlet.getZ(), 50, 6);

				for (L2PcInstance pc : getPlayersInside())
					pc.broadcastPacket(eq);
				break;
				
			case 7:
				
				System.out.println("__BASENAME__:__LINE__: doWeakScarletSpawn#7");
				showSocialActionMovie(demon1, 140, 0, 3, 22000, 3000, 1);
				ThreadPoolManager.getInstance().scheduleGeneral(new ScarletWeakSpawn(8), 2800);
				
				break;
			
			case 8:
				System.out.println("__BASENAME__:__LINE__: doWeakScarletSpawn#8");	//
				showSocialActionMovie(demon2, 140, 0, 3, 22000, 3000, 1);
				ThreadPoolManager.getInstance().scheduleGeneral(new ScarletWeakSpawn(9), 2800);
//				// set camera.
//				for (L2PcInstance pc : LastImperialTombManager.getInstance().getPlayersInLair())
//				{
//					pc.enterMovieMode();
//				pc.specialCamera(organDummy2, 1600, 115, 0, 0, 10000);
//				}
//				
//				_monsterSpawnTask = ThreadPoolManager.getInstance().scheduleGeneral(new ScarletWeakSpawn(9), 1000);
				break;
			
			case 9:
				System.out.println("__BASENAME__:__LINE__: doWeakScarletSpawn#9");
				showSocialActionMovie(demon3, 140, 180, 3, 22000, 3000, 1);
				ThreadPoolManager.getInstance().scheduleGeneral(new ScarletWeakSpawn(10), 2800);
//				// do social.
//				sa = new SocialAction(demon1.getObjectId(), 1);
//				demon1.broadcastPacket(sa);
//				sa = new SocialAction(demon2.getObjectId(), 1);
//				demon2.broadcastPacket(sa);
//				sa = new SocialAction(demon3.getObjectId(), 1);
//				demon3.broadcastPacket(sa);
//				sa = new SocialAction(demon4.getObjectId(), 1);
//				demon4.broadcastPacket(sa);
//				
//				_monsterSpawnTask = ThreadPoolManager.getInstance().scheduleGeneral(new ScarletWeakSpawn(10), 3000);
				break;
			
			case 10:
				System.out.println("__BASENAME__:__LINE__: doWeakScarletSpawn#10");
				showSocialActionMovie(demon4, 140, 180, 3, 22000, 3000, 1);
				ThreadPoolManager.getInstance().scheduleGeneral(new ScarletWeakSpawn(17), 2800);

				weakScarlet.broadcastPacket(new SocialAction(weakScarlet.getObjectId(), 2));
//				// set camera.
//				for (L2PcInstance pc : LastImperialTombManager.getInstance().getPlayersInLair())
//				{
//					pc.enterMovieMode();
//					pc.specialCamera(frintezza, 240, 90, 0, 0, 10000);
//				}
//				
//				_monsterSpawnTask = ThreadPoolManager.getInstance().scheduleGeneral(new ScarletWeakSpawn(11), 10);
				break;
			
			case 11:
//			organDummy2.teleToLocation(172873, -88603, -3390);
				// set camera.
				for (L2PcInstance pc : LastImperialTombManager.getInstance().getPlayersInLair())
				{
					pc.enterMovieMode();
					pc.specialCamera(frintezza, 240, 90, 25, 5500, 10000);
				}
				
				sa = new SocialAction(frintezza.getObjectId(), 3);
				frintezza.broadcastPacket(sa);
				
				_monsterSpawnTask = ThreadPoolManager.getInstance().scheduleGeneral(new ScarletWeakSpawn(12), 5500);
				break;
			
			case 12:
				// set camera.
				for (L2PcInstance pc : LastImperialTombManager.getInstance().getPlayersInLair())
				{
					pc.enterMovieMode();
					pc.specialCamera(frintezza, 100, 195, 35, 0, 10000);
				}
				
				_monsterSpawnTask = ThreadPoolManager.getInstance().scheduleGeneral(new ScarletWeakSpawn(121), 300);
				break;
			
			case 121:
				// set camera.
				for (L2PcInstance pc : LastImperialTombManager.getInstance().getPlayersInLair())
				{
					pc.enterMovieMode();
					pc.specialCamera(frintezza, 100, 195, 35, 0, 10000);
				}
				
				frintezza.startAbnormalEffect(0x0400);
				frintezza.setIsParalyzed(true);
				StopMove sm = new StopMove(frintezza);
				frintezza.sendPacket(sm);
				frintezza.broadcastPacket(sm);
				
				_monsterSpawnTask = ThreadPoolManager.getInstance().scheduleGeneral(new ScarletWeakSpawn(13), 1200);
				break;
			
			case 13:
				frintezza.stopAbnormalEffect(0x0400);
				frintezza.setIsParalyzed(false);
				frintezza.broadcastPacket(new MagicSkillUse(frintezza, frintezza, 5006, 1, 34000, 0));
				
				_monsterSpawnTask = ThreadPoolManager.getInstance().scheduleGeneral(new ScarletWeakSpawn(14), 500);
				break;
			
			case 14:
				// set camera.
				for (L2PcInstance pc : LastImperialTombManager.getInstance().getPlayersInLair())
				{
					pc.enterMovieMode();
					pc.specialCamera(frintezza, 120, 180, 45, 1500, 10000);
				}
				
				_monsterSpawnTask = ThreadPoolManager.getInstance().scheduleGeneral(new ScarletWeakSpawn(15), 1500);
				break;
			
			case 15:
				System.out.println("__BASENAME__:__LINE__: doWeakScarletSpawn#15");
				// set camera.
				for (L2PcInstance pc : LastImperialTombManager.getInstance().getPlayersInLair())
				{
					pc.enterMovieMode();
					pc.specialCamera(frintezza, 520, 135, 45, 8000, 10000);
				}
				
				_monsterSpawnTask = ThreadPoolManager.getInstance().scheduleGeneral(new ScarletWeakSpawn(16), 7500);
				break;
			
			case 16:
				// set camera.
				for (L2PcInstance pc : LastImperialTombManager.getInstance().getPlayersInLair())
				{
					pc.enterMovieMode();
					pc.specialCamera(frintezza, 1500, 110, 25, 10000, 15000);
				}
				
				_monsterSpawnTask = ThreadPoolManager.getInstance().scheduleGeneral(new ScarletWeakSpawn(17), 9500);
				break;
			
			case 17:
				weakScarlet = (L2GrandBossInstance) scarletSpawnWeak.doSpawn();
				weakScarlet.setIsImmobilized(true);
				weakScarlet.setIsInSocialAction(true);
				weakScarlet.setIsInvul(true);
				
//			scarletDummy.broadcastPacket(new MagicSkillUse(scarletDummy, weakScarlet, 5004, 1, 5800, 0));
				
				_monsterSpawnTask = ThreadPoolManager.getInstance().scheduleGeneral(new ScarletWeakSpawn(18), 1);
				break;
			
			case 18:
				// set camera.
				for (L2PcInstance pc : LastImperialTombManager.getInstance().getPlayersInLair())
				{
					pc.enterMovieMode();
//				pc.specialCamera(organDummy2, 2500, 160, -30, 0, 10000);
				}
				
				_monsterSpawnTask = ThreadPoolManager.getInstance().scheduleGeneral(new ScarletWeakSpawn(19), 5699);
				break;
			
			case 19:
				// set camera.
				for (L2PcInstance pc : LastImperialTombManager.getInstance().getPlayersInLair())
				{
					pc.enterMovieMode();
					pc.specialCamera(weakScarlet, 800, 160, 5, 0, 10000);
				}
				
				weakScarlet.broadcastPacket(new MagicSkillUse(weakScarlet, weakScarlet, 5005, 1, 0, 0));
				
				_monsterSpawnTask = ThreadPoolManager.getInstance().scheduleGeneral(new ScarletWeakSpawn(20), 2000);
				break;
			
			case 20:
				System.out.println("__BASENAME__:__LINE__: doWeakScarletSpawn#20");
				// set camera.
				for (L2PcInstance pc : LastImperialTombManager.getInstance().getPlayersInLair())
				{
					pc.enterMovieMode();
					pc.specialCamera(weakScarlet, 300, 60, 8, 0, 10000);
				}
				
				_monsterSpawnTask = ThreadPoolManager.getInstance().scheduleGeneral(new ScarletWeakSpawn(21), 1000);
				break;
			
			case 21:
				System.out.println("__BASENAME__:__LINE__: doWeakScarletSpawn#21");
				// set camera.
				for (L2PcInstance pc : LastImperialTombManager.getInstance().getPlayersInLair())
				{
					pc.enterMovieMode();
					pc.specialCamera(weakScarlet, 500, 90, 10, 3000, 6000);
				}
				
				_monsterSpawnTask = ThreadPoolManager.getInstance().scheduleGeneral(new ScarletWeakSpawn(22), 4000);
				break;
			
			case 22:
				System.out.println("__BASENAME__:__LINE__: doWeakScarletSpawn#22");
//			organDummy2.deleteMe();
//			scarletDummy.deleteMe();
				// set camera.
				for (L2PcInstance pc : LastImperialTombManager.getInstance().getPlayersInLair())
				{
					pc.leaveMovieMode();
				}
				
				_monsterSpawnTask = ThreadPoolManager.getInstance().scheduleGeneral(new ScarletWeakSpawn(23), 2000);
				break;
			
			default:
				System.out.println("__BASENAME__:__LINE__: doWeakScarletSpawn#end");
				weakScarlet.setIsImmobilized(false);
				weakScarlet.setIsInSocialAction(false);
				weakScarlet.setIsInvul(false);
				weakScarlet.broadcastStatusUpdate();
				SVHType = 1;
				OrganManager.getInstance().startMusic();
				OrganManager.getInstance().doPlayOrgan(0);
				
				_activityTimeEndTask = ThreadPoolManager.getInstance().scheduleGeneral(new ActivityTimeEnd(), _activityTimeOfBoss);
				
			}
		}
	}
	
	/**
	 * Does the 2nd Morph for Scarlet Van Halisha. Now he's bigger and he
	 * teleports to his targets
	 */
	protected void doSecondMorph(int taskId)
	{
		if (SVHType == 2)
			return;
		
		SocialAction sa = null;
		NpcInfo ni = null;
		L2CharPosition pos = null;
		
		switch (taskId)
		{
			case 1:
				weakScarlet.abortAttack();
				weakScarlet.stopAllEffects();
				weakScarlet.stopMove(pos, true);
				weakScarlet.getAI().setIntention(CtrlIntention.AI_INTENTION_IDLE);
				weakScarlet.setIsImmobilized(true);
				weakScarlet.setIsInSocialAction(true);
				ni = new NpcInfo(weakScarlet, null);
				weakScarlet.broadcastPacket(ni);
				
				// set camera.
				for (L2PcInstance pc : LastImperialTombManager.getInstance().getPlayersInLair())
				{
					pc.abortAttack();
					pc.getAI().setIntention(CtrlIntention.AI_INTENTION_IDLE);
					pc.enterMovieMode();
					pc.specialCamera(weakScarlet, 300, Util.calcCameraAngle(weakScarlet), 5, 3000, 3000);
				}
				_monsterSpawnTask = ThreadPoolManager.getInstance().scheduleGeneral(new TransSvh2nd(2), 500);
				
				break;
			
			case 2:
				sa = new SocialAction(weakScarlet.getObjectId(), 2);
				weakScarlet.broadcastPacket(sa);
				_monsterSpawnTask = ThreadPoolManager.getInstance().scheduleGeneral(new TransSvh2nd(3), 2000);
				
				break;
			
			case 3:
				// set camera.
				for (L2PcInstance pc : LastImperialTombManager.getInstance().getPlayersInLair())
				{
					pc.leaveMovieMode();
				}
				
				_monsterSpawnTask = ThreadPoolManager.getInstance().scheduleGeneral(new TransSvh2nd(4), 500);
				
				break;
			
			default:
				weakScarlet.setIsImmobilized(false);
				weakScarlet.setIsInSocialAction(false);
				weakScarlet.setIsInvul(false);
				weakScarlet.broadcastStatusUpdate();
				SVHType = 2;
		}
	}
	
	protected class TransSvh2nd implements Runnable
	{
		private int _TaskId;
		
		public TransSvh2nd(int taskId)
		{
			_TaskId = taskId;
		}
		
		public void run()
		{
			doSecondMorph(_TaskId);
		}
	}
	
	/**
	 * Does the 3rd and last polymorph for Scarlet Van Halisha. Now he looks
	 * entirely different... (he is different)
	 */
	protected void doThirdMorph(int taskId)
	{
		if (SVHType == 3)
			return;
		
		SocialAction sa = null;
		NpcInfo ni = null;
		L2CharPosition pos = null;
		
		switch (taskId)
		{
			case 1:
				OrganManager.getInstance().stopMusic();
				
				pos = new L2CharPosition(weakScarlet.getX(), weakScarlet.getY(), weakScarlet.getZ(), weakScarlet.getHeading());
				weakScarlet.abortAttack();
				weakScarlet.stopMove(pos, true);
				weakScarlet.getAI().setIntention(CtrlIntention.AI_INTENTION_IDLE);
				weakScarlet.setIsImmobilized(true);
				weakScarlet.setIsInSocialAction(true);
				ni = new NpcInfo(weakScarlet, null);
				weakScarlet.broadcastPacket(ni);
				
				// set camera.
				for (L2PcInstance pc : LastImperialTombManager.getInstance().getPlayersInLair())
				{
					pc.abortAttack();
					pc.getAI().setIntention(CtrlIntention.AI_INTENTION_IDLE);
					pc.enterMovieMode();
					pc.specialCamera(frintezza, 250, 60, 15, 0, 10000);
				}
				
				_monsterSpawnTask = ThreadPoolManager.getInstance().scheduleGeneral(new TransSvh3rd(2), 100);
				
				break;
			
			case 2:
				// do social.
				sa = new SocialAction(frintezza.getObjectId(), 4);
				frintezza.broadcastPacket(sa);
				
				_monsterSpawnTask = ThreadPoolManager.getInstance().scheduleGeneral(new TransSvh3rd(3), 4900);
				
				break;
			
			case 3:
				frintezza.broadcastPacket(new MagicSkillUse(frintezza, frintezza, 5007, 5, 35000, 0));
				
				weakScarlet.getAI().setIntention(CtrlIntention.AI_INTENTION_IDLE);
//			scarletDummySpawn.setLocx(weakScarlet.getX());
//			scarletDummySpawn.setLocy(weakScarlet.getY());
//			scarletDummySpawn.setLocz(weakScarlet.getZ());
//			scarletDummySpawn.setHeading(weakScarlet.getHeading());
//			scarletDummy = (L2MonsterInstance) scarletDummySpawn.doSpawn();
//			scarletDummy.setIsInvul(true);
//			scarletDummy.setIsImmobilized(true);
//			updateKnownList(scarletDummy);
//			ni = new NpcInfo(scarletDummy, null);
//			scarletDummy.broadcastPacket(ni);
				
				// set camera.
				for (L2PcInstance pc : LastImperialTombManager.getInstance().getPlayersInLair())
				{
					pc.enterMovieMode();
					pc.specialCamera(frintezza, 500, 60, 15, 4000, 10000);
				}
				
				_monsterSpawnTask = ThreadPoolManager.getInstance().scheduleGeneral(new TransSvh3rd(4), 4000);
				
				break;
			
			case 4:
				// set camera.
				for (L2PcInstance pc : LastImperialTombManager.getInstance().getPlayersInLair())
				{
					pc.enterMovieMode();
					pc.specialCamera(frintezza, 2500, 90, 12, 4000, 10000);
				}
				
				_monsterSpawnTask = ThreadPoolManager.getInstance().scheduleGeneral(new TransSvh3rd(5), 4000);
				
				break;
			
			case 5:
				// set camera.
				for (L2PcInstance pc : LastImperialTombManager.getInstance().getPlayersInLair())
				{
					pc.leaveMovieMode();
					pc.enterMovieMode();
//				pc.specialCamera(scarletDummy, 800, Util.calcCameraAngle(scarletDummy), 5, 0, 20000);
				}
				
				_monsterSpawnTask = ThreadPoolManager.getInstance().scheduleGeneral(new TransSvh3rd(6), 100);
				
				break;
			
			case 6:
				// do social.
				sa = new SocialAction(weakScarlet.getObjectId(), 2);
				weakScarlet.broadcastPacket(sa);
				
				_monsterSpawnTask = ThreadPoolManager.getInstance().scheduleGeneral(new TransSvh3rd(7), 6500);
				
				break;
			
			case 7:
//			scarletSpawnStrong.setLocx(scarletDummy.getX());
//			scarletSpawnStrong.setLocy(scarletDummy.getY());
//			scarletSpawnStrong.setLocz(scarletDummy.getZ());
//			scarletSpawnStrong.setHeading(scarletDummy.getHeading());
//			strongScarlet = (L2GrandBossInstance) scarletSpawnStrong.doSpawn();
				strongScarlet.setIsImmobilized(true);
				strongScarlet.setIsInSocialAction(true);
				strongScarlet.setIsInvul(true);
				strongScarlet.setCurrentHp(weakScarlet.getCurrentHp());
				strongScarlet.setCurrentMp(weakScarlet.getCurrentMp());
				updateKnownList(strongScarlet);
				ni = new NpcInfo(strongScarlet, null);
				strongScarlet.broadcastPacket(ni);
				weakScarlet.deleteMe();
				
				_monsterSpawnTask = ThreadPoolManager.getInstance().scheduleGeneral(new TransSvh3rd(8), 6000);
				
				break;
			
			case 8:
				// set camera.
				for (L2PcInstance pc : LastImperialTombManager.getInstance().getPlayersInLair())
				{
					pc.enterMovieMode();
					pc.specialCamera(strongScarlet, 800, Util.calcCameraAngle(strongScarlet), 5, 0, 10000);
				}
				
				_monsterSpawnTask = ThreadPoolManager.getInstance().scheduleGeneral(new TransSvh3rd(9), 100);
				
				break;
			
			case 9:
				// set camera.
				for (L2PcInstance pc : LastImperialTombManager.getInstance().getPlayersInLair())
				{
					pc.enterMovieMode();
					pc.specialCamera(strongScarlet, 300, Util.calcCameraAngle(strongScarlet), 5, 2000, 15000);
				}
				
				// do social.
				sa = new SocialAction(strongScarlet.getObjectId(), 2);
				strongScarlet.broadcastPacket(sa);
				
				_monsterSpawnTask = ThreadPoolManager.getInstance().scheduleGeneral(new TransSvh3rd(10), 8000);
				
				break;
			
			case 10:
//			scarletDummy.deleteMe();
				// set camera.
				for (L2PcInstance pc : LastImperialTombManager.getInstance().getPlayersInLair())
				{
					pc.leaveMovieMode();
				}
				
				_monsterSpawnTask = ThreadPoolManager.getInstance().scheduleGeneral(new TransSvh3rd(11), 2000);
				
				break;
			
			default:
				strongScarlet.setIsImmobilized(false);
				strongScarlet.setIsInSocialAction(false);
				strongScarlet.setIsInvul(false);
				strongScarlet.broadcastStatusUpdate();
				SVHType = 3;
				OrganManager.getInstance().startMusic();
				OrganManager.getInstance().doPlayOrgan(0);
		}
	}
	
	protected class TransSvh3rd implements Runnable
	{
		private int _TaskId;
		
		public TransSvh3rd(int taskId)
		{
			_TaskId = taskId;
		}
		
		public void run()
		{
			doThirdMorph(_TaskId);
		}
	}
	
	public void svhMorphCheck() //<<== lastimperialtomb.py:onAttack()
	{
		if (SVHType == 1 && weakScarlet.getCurrentHp() < weakScarlet.getMaxHp() * 0.75)
			doSecondMorph(1);
		else if (SVHType == 2 && weakScarlet.getCurrentHp() < weakScarlet.getMaxHp() * 0.5)
			doThirdMorph(1);
	}
	
	public int getSVHType()
	{
		return SVHType;
	}
	
	/**
	 * Dead Scarlet Van Halisha.
	 */
	public void doSvhDead(int taskId) //<<== lastimperialtomb.py:onKill()
	{
		switch (taskId)
		{
			case 1:
				OrganManager.getInstance().stopMusic();
				_stateSet.set("respawn_time", Calendar.getInstance().getTimeInMillis() + Rnd.get(Config.LIT_FIXINTERVALOFFRINTEZZA, Config.LIT_FIXINTERVALOFFRINTEZZA + Config.LIT_RANDOMINTERVALOFFRINTEZZA));
				_alive = GrandBossStatus.DEAD;
				GrandBossManager.getInstance().setBossStatus(_bossId, _alive);
				GrandBossManager.getInstance().setStatsSet(_bossId, _stateSet);
				GrandBossManager.getInstance().save();
				
				// set camera.
				for (L2PcInstance pc : LastImperialTombManager.getInstance().getPlayersInLair())
				{
					pc.enterMovieMode();
					pc.specialCamera(strongScarlet, 300, Util.calcCameraAngle(strongScarlet) - 180, 5, 0, 7000);
				}
				
				_monsterSpawnTask = ThreadPoolManager.getInstance().scheduleGeneral(new DeadSvh(2), 1);
				break;
			
			case 2:
				// set camera.
				for (L2PcInstance pc : LastImperialTombManager.getInstance().getPlayersInLair())
				{
					pc.enterMovieMode();
					pc.specialCamera(strongScarlet, 150, Util.calcCameraAngle(strongScarlet), 90, 4000, 7000);
				}
				
				_monsterSpawnTask = ThreadPoolManager.getInstance().scheduleGeneral(new DeadSvh(3), 6999);
				break;
			
			case 3:
				// set camera.
				for (L2PcInstance pc : LastImperialTombManager.getInstance().getPlayersInLair())
				{
					pc.enterMovieMode();
					pc.specialCamera(frintezza, 150, 120, 5, 0, 7000);
				}
				
				_monsterSpawnTask = ThreadPoolManager.getInstance().scheduleGeneral(new DeadSvh(4), 1);
				break;
			
			case 4:
				frintezza.doDie(null);
				// set camera.
				for (L2PcInstance pc : LastImperialTombManager.getInstance().getPlayersInLair())
				{
					pc.enterMovieMode();
					pc.specialCamera(frintezza, 150, 90, 5, 3000, 15000);
				}
				
				_monsterSpawnTask = ThreadPoolManager.getInstance().scheduleGeneral(new DeadSvh(5), 7000);
				break;
			
			case 5:
				cube = cubeSpawn.doSpawn();
				// set camera.
				for (L2PcInstance pc : LastImperialTombManager.getInstance().getPlayersInLair())
				{
					pc.enterMovieMode();
					pc.specialCamera(frintezza, 1200, 90, 25, 8000, 10000);
				}
				
				_monsterSpawnTask = ThreadPoolManager.getInstance().scheduleGeneral(new DeadSvh(99), 8000);
				break;
			
			default:
				// set camera.
				for (L2PcInstance pc : LastImperialTombManager.getInstance().getPlayersInLair())
				{
					pc.leaveMovieMode();
				}
		}
	}
	
	protected class DeadSvh implements Runnable
	{
		private int _TaskId;
		
		public DeadSvh(int taskId)
		{
			_TaskId = taskId;
		}
		
		public void run()
		{
			doSvhDead(_TaskId);
		}
	}
	
	/**
	 * Class ends the activity of the Bosses after a interval of time Exits the
	 * battle field in any way ...
	 *
	 * @author Darki699
	 * @author SANDMAN L2J_JP(modified)
	 */
	/*private*/ class ActivityTimeEnd implements Runnable
	{
//-		public ActivityTimeEnd()
//-		{ /* Nothing */
//-		}
//-		
		public void run()
		{
			System.out.println("__BASENAME__:__LINE__: ActivityTimeEnd");
			OrganManager.getInstance().stopMusic();
			LastImperialTombManager.getInstance().cleanUpTomb();
		}
	}
	
	/**
	 * Clean Frintezza's lair.
	 * @author Darki699
	 * @author SANDMAN L2J_JP(modified)
	 */
	public void setUnspawn()
	{
		// delete monsters.
		if (frintezza != null)
			frintezza.deleteMe();
		if (weakScarlet != null)
			weakScarlet.deleteMe();
		if (strongScarlet != null)
			strongScarlet.deleteMe();
		if (portrait1 != null)
			portrait1.deleteMe();
		if (portrait2 != null)
			portrait2.deleteMe();
		if (portrait3 != null)
			portrait3.deleteMe();
		if (portrait4 != null)
			portrait4.deleteMe();
		if (demon1 != null)
			demon1.deleteMe();
		if (demon2 != null)
			demon2.deleteMe();
		if (demon3 != null)
			demon3.deleteMe();
		if (demon4 != null)
			demon4.deleteMe();
//	if (scarletDummy != null)
//		scarletDummy.deleteMe();
//	if (organDummy != null)
//		organDummy.deleteMe();
//	if (organDummy2 != null)
//		organDummy2.deleteMe();
		
		frintezza = null;
		weakScarlet = null;
		strongScarlet = null;
		portrait1 = null;
		portrait2 = null;
		portrait3 = null;
		portrait4 = null;
		demon1 = null;
		demon2 = null;
		demon3 = null;
		demon4 = null;
//	scarletDummy = null;
//	organDummy = null;
//	organDummy2 = null;
		SVHType = 0;
		
		// delete teleport cube.
		if (cube != null)
			cube.deleteMe();
		cube = null;
		
		// not executed tasks is canceled.
		if (_monsterSpawnTask != null)
		{
			_monsterSpawnTask.cancel(true);
			_monsterSpawnTask = null;
		}
		if (_activityTimeEndTask != null)
		{
			_activityTimeEndTask.cancel(true);
			_activityTimeEndTask = null;
		}
		if (_IntervalEndTask != null)
		{
			_IntervalEndTask.cancel(true);
			_IntervalEndTask = null;
		}
		
		// interval begin.
		// When Scarlet is dead,it begins interval.
		if (_alive == GrandBossStatus.DEAD)
		{
			_alive = GrandBossStatus.INTERVAL;
			GrandBossManager.getInstance().setBossStatus(_bossId, _alive);
			GrandBossManager.getInstance().save();
			setInetrvalEndTask();
		}
		else
		{
			_stateSet.set("respawn_time", Calendar.getInstance().getTimeInMillis());
			_alive = GrandBossStatus.NOTSPAWN;
			GrandBossManager.getInstance().setBossStatus(_bossId, _alive);
			GrandBossManager.getInstance().setStatsSet(_bossId, _stateSet);
			GrandBossManager.getInstance().save();
		}
	}
	
	/**
	 * Creates a thread to initialize Frintezza again... until this loops ends,
	 * no one can enter the lair.
	 * @author Darki699
	 * @author SANDMAN L2J_JP(modified)
	 */
	public void setInetrvalEndTask()
	{
		// init state of Frintezza's lair.
		if (_alive != GrandBossStatus.INTERVAL)
		{
			_alive = GrandBossStatus.INTERVAL;
			GrandBossManager.getInstance().setBossStatus(_bossId, _alive);
			GrandBossManager.getInstance().save();
		}
		
		_IntervalEndTask = ThreadPoolManager.getInstance().scheduleGeneral(new IntervalEnd(), GrandBossManager.getInstance().getInterval(_bossId));
		_log.info("FrintezzaManager : Interval START.");
	}
	
	/**
	 * Calls for a re-initialization when time comes, only then can players
	 * enter the lair.
	 *
	 * @author Darki699
	 * @author SANDMAN L2J_JP(modified)
	 */
	private class IntervalEnd implements Runnable
	{
		public IntervalEnd()
		{ /* Nothing */
		}
		
		public void run()
		{
			doIntervalEnd();
		}
	}
	
	protected void doIntervalEnd()
	{
		_alive = GrandBossStatus.NOTSPAWN;
		GrandBossManager.getInstance().setBossStatus(_bossId, _alive);
		GrandBossManager.getInstance().save();
		_log.info("FrintezzaManager : Interval END.");
	}
	
	/**
	 * Updates knownlist for the monster. Updates players in the room list.
	 * Updates players in the room known list.
	 *
	 * @param L2NpcInstance
	 *            monster
	 */
	protected void updateKnownList(L2NpcInstance boss)
	{
		if (boss == null)
			return;
		
		boss.getKnownList().getKnownPlayers().clear();
		for (L2PcInstance pc : LastImperialTombManager.getInstance().getPlayersInLair())
		{
			boss.getKnownList().getKnownPlayers().put(pc.getObjectId(), pc);
		}
	}
	
	/**
	 * Sets a L2Character to idle state. Disables all skills, aborts attack and cast, immoblizies
	 * 
	 * @param target
	 *            L2Character
	 */
	/*public*/ void setIdle(L2Character target)
	{
		target.getAI().setIntention(CtrlIntention.AI_INTENTION_IDLE);
		target.abortAttack();
		target.abortCast();
		target.setIsImmobilized(true);
		target.disableAllSkills();
	}
	
	/**
	 * 
	 * @return
	 */
	List<L2PcInstance> getPlayersInside()
	{
		return LastImperialTombManager.getInstance().getPlayersInLair();
	}
}
