/*
 * Decompiled with CFR 0.152.
 */
package org.python.core;

import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.DataInputStream;
import java.io.DataOutputStream;
import java.io.EOFException;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.lang.reflect.Array;
import org.python.core.AbstractArray;
import org.python.core.ByteSwapper;
import org.python.core.ClassDictInit;
import org.python.core.Py;
import org.python.core.PyException;
import org.python.core.PyFile;
import org.python.core.PyIgnoreMethodTag;
import org.python.core.PyInteger;
import org.python.core.PyList;
import org.python.core.PyObject;
import org.python.core.PySequence;
import org.python.core.PyString;

public class PyArray
extends PySequence
implements Cloneable,
ClassDictInit {
    protected Object data;
    protected Class type;
    protected String typecode;
    protected ArrayDelegate delegate;
    static /* synthetic */ Class class$java$lang$Object;

    private PyArray() {
    }

    public PyArray(PyArray toCopy) {
        this.data = toCopy.delegate.copyArray();
        this.delegate = new ArrayDelegate(this);
        this.type = toCopy.type;
    }

    public PyArray(Class type, Object data) {
        this.type = type;
        this.data = data;
        this.delegate = new ArrayDelegate(this);
    }

    public PyArray(Class type, int n) {
        this(type, Array.newInstance(type, n));
    }

    public static PyArray zeros(int n, char typecode) {
        PyArray array = PyArray.zeros(n, PyArray.char2class(typecode));
        array.typecode = "" + typecode;
        return array;
    }

    public static PyArray zeros(int n, Class ctype) {
        PyArray array = new PyArray(ctype, n);
        array.typecode = ctype.getName();
        return array;
    }

    public static PyArray array(PyObject seq, char typecode) {
        PyArray array = PyArray.array(seq, PyArray.char2class(typecode));
        array.typecode = "" + typecode;
        return array;
    }

    public static PyArray array(PyObject init, Class ctype) {
        PyArray array = new PyArray(ctype, 0);
        array.typecode = ctype.getName();
        array.extendInternal(init);
        return array;
    }

    public PyObject __add__(PyObject other) {
        PyArray otherArr = null;
        if (!(other instanceof PyArray)) {
            throw Py.TypeError("can only append another array to an array");
        }
        otherArr = (PyArray)other;
        if (!otherArr.type.equals(this.type)) {
            throw Py.TypeError("can only append arrays of the same type, expected '" + this.type + ", found " + otherArr.type);
        }
        PyArray ret = new PyArray(this);
        ret.delegate.appendArray(otherArr.delegate.copyArray());
        return ret;
    }

    public PyObject __findattr__(String name) {
        if ("typecode".equals(name)) {
            return new PyString(this.getTypecode());
        }
        return super.__findattr__(name);
    }

    public int __len__() {
        return this.delegate.getSize();
    }

    public PyString __repr__() {
        StringBuffer buf = new StringBuffer(128);
        buf.append("array(").append(PyArray.class2char(this.type)).append(",[");
        for (int i = 0; i < this.__len__() - 1; ++i) {
            buf.append(this.pyget(i).__repr__().toString());
            buf.append(", ");
        }
        if (this.__len__() > 0) {
            buf.append(this.pyget(this.__len__() - 1).__repr__().toString());
        }
        buf.append("]) ");
        return new PyString(buf.toString());
    }

    public Object __tojava__(Class c) {
        if (c == (class$java$lang$Object == null ? (class$java$lang$Object = PyArray.class$("java.lang.Object")) : class$java$lang$Object) || c.isArray() && c.getComponentType().isAssignableFrom(this.type)) {
            return this.data;
        }
        if (c.isInstance(this)) {
            return this;
        }
        return Py.NoConversion;
    }

    public void append(PyObject value) {
        int afterLast = this.delegate.getSize();
        this.delegate.makeInsertSpace(afterLast);
        try {
            this.set(afterLast, value);
        }
        catch (PyException e) {
            this.delegate.setSize(afterLast);
            throw new PyException(e.type, e.value);
        }
    }

    public void byteswap() {
        if (this.getItemsize() == 0) {
            throw Py.RuntimeError("don't know how to byteswap this array type");
        }
        ByteSwapper.swap(this.data);
    }

    public static void classDictInit(PyObject dict) throws PyIgnoreMethodTag {
        PySequence.classDictInit(dict);
        dict.__setitem__("clone", null);
        dict.__setitem__("classDictInit", null);
    }

    public Object clone() {
        return new PyArray(this);
    }

    public static Class char2class(char type) throws PyIgnoreMethodTag {
        switch (type) {
            case 'z': {
                return Boolean.TYPE;
            }
            case 'c': {
                return Character.TYPE;
            }
            case 'b': {
                return Byte.TYPE;
            }
            case 'h': {
                return Short.TYPE;
            }
            case 'i': {
                return Integer.TYPE;
            }
            case 'l': {
                return Long.TYPE;
            }
            case 'f': {
                return Float.TYPE;
            }
            case 'd': {
                return Double.TYPE;
            }
        }
        throw Py.ValueError("typecode must be in [zcbhilfd]");
    }

    private static String class2char(Class cls) {
        if (cls.equals(Boolean.TYPE)) {
            return "'z'";
        }
        if (cls.equals(Character.TYPE)) {
            return "'c'";
        }
        if (cls.equals(Byte.TYPE)) {
            return "'b'";
        }
        if (cls.equals(Short.TYPE)) {
            return "'h'";
        }
        if (cls.equals(Integer.TYPE)) {
            return "'i'";
        }
        if (cls.equals(Long.TYPE)) {
            return "'l'";
        }
        if (cls.equals(Float.TYPE)) {
            return "'f'";
        }
        if (cls.equals(Double.TYPE)) {
            return "'d'";
        }
        return cls.getName();
    }

    public PyObject count(PyObject value) {
        int iCount = 0;
        for (int i = 0; i < this.delegate.getSize(); ++i) {
            if (!value.equals(Py.java2py(Array.get(this.data, i)))) continue;
            ++iCount;
        }
        return new PyInteger(iCount);
    }

    protected void del(int i) {
        this.delegate.remove(i);
    }

    protected void delRange(int start, int stop, int step) {
        if (step > 0 && stop < start) {
            stop = start;
        }
        if (step == 1) {
            this.delegate.remove(start, stop);
        } else {
            int n = PyArray.sliceLength(start, stop, step);
            int i = start;
            for (int j = 0; j < n; ++j) {
                this.delegate.remove(i);
                i += step;
            }
        }
    }

    public void extend(PyObject iterable) {
        this.extendInternal(iterable);
    }

    private void extendInternal(PyObject iterable) {
        if (iterable instanceof PyString) {
            this.fromstring(((PyString)iterable).toString());
        } else if (iterable instanceof PyArray) {
            PyArray source = (PyArray)iterable;
            if (!source.type.equals(this.type)) {
                throw Py.TypeError("can only extend with an array of the same kind");
            }
            this.delegate.appendArray(source.delegate.copyArray());
        } else {
            this.extendInternalIter(iterable);
        }
    }

    private void extendInternalIter(PyObject iterable) {
        PyObject iter = iterable.__iter__();
        PyObject item = null;
        if (iterable.__findattr__("__len__") == null) {
            int i = 0;
            while ((item = iter.__iternext__()) != null) {
                this.append(item);
                ++i;
            }
        } else {
            int last = this.delegate.getSize();
            this.delegate.ensureCapacity(last + iterable.__len__());
            int i = last;
            while ((item = iter.__iternext__()) != null) {
                this.set(i, item);
                ++this.delegate.size;
                ++i;
            }
        }
    }

    public void fromfile(PyObject f, int count) {
        if (!(f instanceof PyFile)) {
            throw Py.TypeError("arg1 must be open file");
        }
        PyFile file = (PyFile)f;
        if (file.mode.indexOf("r") == -1) {
            throw Py.TypeError("file needs to be in read mode");
        }
        int readbytes = count * this.getItemsize();
        String buffer = file.read(readbytes).toString();
        this.fromstring(buffer);
        if (buffer.length() < readbytes) {
            int readcount = buffer.length() / this.getItemsize();
            throw Py.EOFError("not enough items in file. " + Integer.toString(count) + " requested, " + Integer.toString(readcount) + " actually read");
        }
    }

    public void fromlist(PyObject obj) {
        if (!(obj instanceof PyList)) {
            throw Py.TypeError("expected list argument");
        }
        int size = this.delegate.getSize();
        try {
            this.extendInternalIter(obj);
        }
        catch (PyException e) {
            this.delegate.setSize(size);
            throw new PyException(e.type, e.value);
        }
    }

    private int fromStream(InputStream is) throws IOException, EOFException {
        return this.fromStream(is, is.available() / this.getItemsize());
    }

    private int fromStream(InputStream is, int count) throws IOException, EOFException {
        int origsize;
        DataInputStream dis = new DataInputStream(is);
        int index = origsize = this.delegate.getSize();
        this.delegate.ensureCapacity(index + count);
        if (this.type.isPrimitive()) {
            if (this.type == Boolean.TYPE) {
                int i = 0;
                while (i < count) {
                    Array.setBoolean(this.data, index, dis.readBoolean());
                    ++this.delegate.size;
                    ++i;
                    ++index;
                }
            } else if (this.type == Byte.TYPE) {
                int i = 0;
                while (i < count) {
                    Array.setByte(this.data, index, dis.readByte());
                    ++this.delegate.size;
                    ++i;
                    ++index;
                }
            } else if (this.type == Character.TYPE) {
                int i = 0;
                while (i < count) {
                    Array.setChar(this.data, index, (char)dis.readByte());
                    ++this.delegate.size;
                    ++i;
                    ++index;
                }
            } else if (this.type == Integer.TYPE) {
                int i = 0;
                while (i < count) {
                    Array.setInt(this.data, index, dis.readInt());
                    ++this.delegate.size;
                    ++i;
                    ++index;
                }
            } else if (this.type == Short.TYPE) {
                int i = 0;
                while (i < count) {
                    Array.setShort(this.data, index, dis.readShort());
                    ++this.delegate.size;
                    ++i;
                    ++index;
                }
            } else if (this.type == Long.TYPE) {
                int i = 0;
                while (i < count) {
                    Array.setLong(this.data, index, dis.readLong());
                    ++this.delegate.size;
                    ++i;
                    ++index;
                }
            } else if (this.type == Float.TYPE) {
                int i = 0;
                while (i < count) {
                    Array.setFloat(this.data, index, dis.readFloat());
                    ++this.delegate.size;
                    ++i;
                    ++index;
                }
            } else if (this.type == Double.TYPE) {
                int i = 0;
                while (i < count) {
                    Array.setDouble(this.data, index, dis.readDouble());
                    ++this.delegate.size;
                    ++i;
                    ++index;
                }
            }
        }
        dis.close();
        return index - origsize;
    }

    public void fromstring(String input) {
        int itemsize = this.getItemsize();
        int strlen = input.length();
        if (strlen % itemsize != 0) {
            throw Py.ValueError("string length not a multiple of item size");
        }
        ByteArrayInputStream bis = new ByteArrayInputStream(input.getBytes());
        int origsize = this.delegate.getSize();
        try {
            this.fromStream(bis);
        }
        catch (EOFException e) {
            throw Py.EOFError("not enough items in string");
        }
        catch (IOException e) {
            this.delegate.setSize(origsize);
            throw Py.IOError(e);
        }
    }

    protected PyObject pyget(int i) {
        return Py.java2py(Array.get(this.data, i));
    }

    public Object getArray() throws PyIgnoreMethodTag {
        return this.delegate.copyArray();
    }

    public int getItemsize() {
        if (this.type.isPrimitive()) {
            if (this.type == Boolean.TYPE) {
                return 1;
            }
            if (this.type == Byte.TYPE) {
                return 1;
            }
            if (this.type == Character.TYPE) {
                return 1;
            }
            if (this.type == Short.TYPE) {
                return 2;
            }
            if (this.type == Integer.TYPE) {
                return 4;
            }
            if (this.type == Long.TYPE) {
                return 8;
            }
            if (this.type == Float.TYPE) {
                return 4;
            }
            if (this.type == Double.TYPE) {
                return 8;
            }
        }
        return 0;
    }

    protected PyObject getslice(int start, int stop, int step) {
        if (step > 0 && stop < start) {
            stop = start;
        }
        int n = PyArray.sliceLength(start, stop, step);
        PyArray ret = new PyArray(this.type, n);
        if (step == 1) {
            System.arraycopy(this.data, start, ret.data, 0, n);
            return ret;
        }
        int i = start;
        for (int j = 0; j < n; ++j) {
            Array.set(ret.data, j, Array.get(this.data, i));
            i += step;
        }
        return ret;
    }

    public String getTypecode() throws PyIgnoreMethodTag {
        return this.typecode;
    }

    public PyObject index(PyObject value) {
        int index = this.indexInternal(value);
        if (index != -1) {
            return new PyInteger(index);
        }
        throw Py.ValueError("array.index(" + value + "): " + value + " not found in array");
    }

    private int indexInternal(PyObject value) {
        for (int i = 0; i < this.delegate.getSize(); ++i) {
            if (!value.equals(Py.java2py(Array.get(this.data, i)))) continue;
            return i;
        }
        return -1;
    }

    public void insert(int index, PyObject value) {
        this.delegate.makeInsertSpace(index);
        Array.set(this.data, index, Py.tojava(value, this.type));
    }

    public PyObject pop() {
        return this.pop(-1);
    }

    public PyObject pop(int index) {
        index = index < 0 ? this.delegate.getSize() + index : index;
        PyObject ret = Py.java2py(Array.get(this.data, index));
        this.delegate.remove(index);
        return ret;
    }

    public void remove(PyObject value) {
        int index = this.indexInternal(value);
        if (index != -1) {
            this.delegate.remove(index);
            return;
        }
        throw Py.ValueError("array.remove(" + value + "): " + value + " not found in array");
    }

    protected PyObject repeat(int count) {
        Object arraycopy = this.delegate.copyArray();
        PyArray ret = new PyArray(this.type, 0);
        for (int i = 0; i < count; ++i) {
            ret.delegate.appendArray(arraycopy);
        }
        return ret;
    }

    public void reverse() {
        Object array = Array.newInstance(this.type, Array.getLength(this.data));
        int lastIndex = this.delegate.getSize() - 1;
        for (int i = 0; i <= lastIndex; ++i) {
            Array.set(array, lastIndex - i, Array.get(this.data, i));
        }
        this.data = array;
    }

    protected void set(int i, PyObject value) {
        Object o;
        if (this.type == Byte.TYPE) {
            long val;
            try {
                val = (Long)value.__tojava__(Long.TYPE);
            }
            catch (ClassCastException e) {
                throw Py.TypeError("Type not compatible with array type");
            }
            if (val < -128L) {
                throw Py.OverflowError("value too small for " + this.type.getName());
            }
            if (val > 127L) {
                throw Py.OverflowError("value too large for " + this.type.getName());
            }
        } else if (this.type == Short.TYPE) {
            long val;
            try {
                val = (Long)value.__tojava__(Long.TYPE);
            }
            catch (ClassCastException e) {
                throw Py.TypeError("Type not compatible with array type");
            }
            if (val < -32768L) {
                throw Py.OverflowError("value too small for " + this.type.getName());
            }
            if (val > 32767L) {
                throw Py.OverflowError("value too large for " + this.type.getName());
            }
        } else if (this.type == Integer.TYPE) {
            long val;
            try {
                val = (Long)value.__tojava__(Long.TYPE);
            }
            catch (ClassCastException e) {
                throw Py.TypeError("Type not compatible with array type");
            }
            if (val < Integer.MIN_VALUE) {
                throw Py.OverflowError("value too small for " + this.type.getName());
            }
            if (val > Integer.MAX_VALUE) {
                throw Py.OverflowError("value too large for " + this.type.getName());
            }
        } else if (this.type == Long.TYPE) {
            Object o2;
            try {
                o2 = value.__tojava__(Long.TYPE);
            }
            catch (ClassCastException e) {
                throw Py.TypeError("Type not compatible with array type");
            }
            if (o2 == Py.NoConversion) {
                throw Py.OverflowError("value out of range for long");
            }
        }
        if ((o = Py.tojava(value, this.type)) == Py.NoConversion) {
            throw Py.TypeError("Type not compatible with array type");
        }
        Array.set(this.data, i, o);
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    protected void setslice(int start, int stop, int step, PyObject value) {
        if (this.type == Character.TYPE && value instanceof PyString) {
            char[] chars = null;
            if (step != 1) {
                throw Py.ValueError("invalid bounds for setting from string");
            }
            chars = value.toString().toCharArray();
            int insertSpace = chars.length - (stop - start);
            if (insertSpace > 0) {
                this.delegate.makeInsertSpace(start, insertSpace);
            } else if (insertSpace < 0) {
                this.delegate.remove(start, -insertSpace + start - 1);
            }
            this.delegate.replaceSubArray(chars, start);
            return;
        }
        if (value instanceof PyString && this.type == Byte.TYPE) {
            byte[] chars = value.toString().getBytes();
            if (chars.length != stop - start || step != 1) throw Py.ValueError("invalid bounds for setting from string");
            System.arraycopy(chars, 0, this.data, start, chars.length);
            return;
        }
        if (!(value instanceof PyArray)) return;
        PyArray array = (PyArray)value;
        int insertSpace = array.delegate.getSize() - (stop - start);
        Object arrayCopy = array.delegate.copyArray();
        if (insertSpace > 0) {
            this.delegate.makeInsertSpace(start, insertSpace);
        } else if (insertSpace < 0) {
            this.delegate.remove(start, -insertSpace + start - 1);
        }
        try {
            this.delegate.replaceSubArray(arrayCopy, start);
            return;
        }
        catch (IllegalArgumentException e) {
            throw Py.TypeError("Slice typecode '" + array.typecode + "' is not compatible with this array (typecode '" + this.typecode + "')");
        }
    }

    public void tofile(PyObject f) {
        if (!(f instanceof PyFile)) {
            throw Py.TypeError("arg must be open file");
        }
        PyFile file = (PyFile)f;
        if (file.mode.indexOf("w") == -1 && file.mode.indexOf("a") == -1) {
            throw Py.TypeError("file needs to be in write or append mode");
        }
        String buffer = this.tostring();
        file.write(buffer);
    }

    public PyObject tolist() {
        PyList list = new PyList();
        for (int i = 0; i < this.delegate.getSize(); ++i) {
            list.append(Py.java2py(Array.get(this.data, i)));
        }
        return list;
    }

    private int toStream(OutputStream os2) throws IOException {
        DataOutputStream dos;
        block8: {
            block15: {
                block14: {
                    block13: {
                        block12: {
                            block11: {
                                block10: {
                                    block9: {
                                        dos = new DataOutputStream(os2);
                                        if (!this.type.isPrimitive()) break block8;
                                        if (this.type != Boolean.TYPE) break block9;
                                        for (int i = 0; i < this.delegate.getSize(); ++i) {
                                            dos.writeBoolean(Array.getBoolean(this.data, i));
                                        }
                                        break block8;
                                    }
                                    if (this.type != Byte.TYPE) break block10;
                                    for (int i = 0; i < this.delegate.getSize(); ++i) {
                                        dos.writeByte(Array.getByte(this.data, i));
                                    }
                                    break block8;
                                }
                                if (this.type != Character.TYPE) break block11;
                                for (int i = 0; i < this.delegate.getSize(); ++i) {
                                    dos.writeByte((byte)Array.getChar(this.data, i));
                                }
                                break block8;
                            }
                            if (this.type != Integer.TYPE) break block12;
                            for (int i = 0; i < this.delegate.getSize(); ++i) {
                                dos.writeInt(Array.getInt(this.data, i));
                            }
                            break block8;
                        }
                        if (this.type != Short.TYPE) break block13;
                        for (int i = 0; i < this.delegate.getSize(); ++i) {
                            dos.writeShort(Array.getShort(this.data, i));
                        }
                        break block8;
                    }
                    if (this.type != Long.TYPE) break block14;
                    for (int i = 0; i < this.delegate.getSize(); ++i) {
                        dos.writeLong(Array.getLong(this.data, i));
                    }
                    break block8;
                }
                if (this.type != Float.TYPE) break block15;
                for (int i = 0; i < this.delegate.getSize(); ++i) {
                    dos.writeFloat(Array.getFloat(this.data, i));
                }
                break block8;
            }
            if (this.type != Double.TYPE) break block8;
            for (int i = 0; i < this.delegate.getSize(); ++i) {
                dos.writeDouble(Array.getDouble(this.data, i));
            }
        }
        return dos.size();
    }

    public String tostring() {
        ByteArrayOutputStream bos = new ByteArrayOutputStream();
        try {
            this.toStream(bos);
        }
        catch (IOException e) {
            throw Py.IOError(e);
        }
        return new String(bos.toByteArray());
    }

    static /* synthetic */ Class class$(String x0) {
        try {
            return Class.forName(x0);
        }
        catch (ClassNotFoundException x1) {
            throw new NoClassDefFoundError(x1.getMessage());
        }
    }

    private class ArrayDelegate
    extends AbstractArray {
        final PyArray pyArray;

        private ArrayDelegate(PyArray pyArray) {
            super(pyArray.data == null ? 0 : Array.getLength(pyArray.data));
            this.pyArray = pyArray;
        }

        protected Object getArray() {
            return this.pyArray.data;
        }

        protected void setArray(Object array) {
            this.pyArray.data = array;
        }

        protected void makeInsertSpace(int index) {
            super.makeInsertSpace(index, 1);
        }

        protected void makeInsertSpace(int index, int length) {
            super.makeInsertSpace(index, length);
        }

        public void remove(int index) {
            super.remove(index);
        }
    }
}

