/*
 * Decompiled with CFR 0.152.
 */
package com.l2jserver.script.java;

import java.io.ByteArrayOutputStream;
import java.io.File;
import java.io.FilterOutputStream;
import java.io.IOException;
import java.io.OutputStream;
import java.io.Reader;
import java.io.StringReader;
import java.net.URI;
import java.nio.CharBuffer;
import java.util.HashMap;
import java.util.Map;
import javax.tools.FileObject;
import javax.tools.ForwardingJavaFileManager;
import javax.tools.JavaFileManager;
import javax.tools.JavaFileObject;
import javax.tools.SimpleJavaFileObject;

public final class MemoryJavaFileManager
extends ForwardingJavaFileManager {
    private static final String EXT = ".java";
    private Map<String, byte[]> classBytes = new HashMap<String, byte[]>();

    public MemoryJavaFileManager(JavaFileManager fileManager) {
        super(fileManager);
    }

    public Map<String, byte[]> getClassBytes() {
        return this.classBytes;
    }

    @Override
    public void close() throws IOException {
        this.classBytes = new HashMap<String, byte[]>();
    }

    @Override
    public void flush() throws IOException {
    }

    @Override
    public JavaFileObject getJavaFileForOutput(JavaFileManager.Location location, String className, JavaFileObject.Kind kind, FileObject sibling) throws IOException {
        if (kind == JavaFileObject.Kind.CLASS) {
            return new ClassOutputBuffer(className.replace('/', '.'));
        }
        return super.getJavaFileForOutput(location, className, kind, sibling);
    }

    static JavaFileObject makeStringSource(String name, String code) {
        return new StringInputBuffer(name, code);
    }

    static URI toURI(String name) {
        File file = new File(name);
        if (file.exists()) {
            return file.toURI();
        }
        try {
            StringBuilder newUri = new StringBuilder();
            newUri.append("file:///");
            newUri.append(name.replace('.', '/'));
            if (name.endsWith(EXT)) {
                newUri.replace(newUri.length() - EXT.length(), newUri.length(), EXT);
            }
            return URI.create(newUri.toString());
        }
        catch (Exception exp) {
            return URI.create("file:///com/sun/script/java/java_source");
        }
    }

    private class ClassOutputBuffer
    extends SimpleJavaFileObject {
        private String name;

        ClassOutputBuffer(String name) {
            super(MemoryJavaFileManager.toURI(name), JavaFileObject.Kind.CLASS);
            this.name = name;
        }

        @Override
        public OutputStream openOutputStream() {
            return new FilterOutputStream(new ByteArrayOutputStream()){

                @Override
                public void close() throws IOException {
                    this.out.close();
                    ByteArrayOutputStream bos = (ByteArrayOutputStream)this.out;
                    MemoryJavaFileManager.this.classBytes.put(ClassOutputBuffer.this.name, bos.toByteArray());
                }
            };
        }
    }

    private static class StringInputBuffer
    extends SimpleJavaFileObject {
        final String code;

        StringInputBuffer(String name, String code) {
            super(MemoryJavaFileManager.toURI(name), JavaFileObject.Kind.SOURCE);
            this.code = code;
        }

        @Override
        public CharBuffer getCharContent(boolean ignoreEncodingErrors) {
            return CharBuffer.wrap(this.code);
        }

        public Reader openReader() {
            return new StringReader(this.code);
        }
    }
}

