/*
 * Decompiled with CFR 0.152.
 */
package javolution.context;

import javax.realtime.MemoryArea;
import javax.realtime.RealtimeThread;
import javolution.context.ConcurrentException;
import javolution.context.ConcurrentExecutor;
import javolution.lang.Reflection;

public class ConcurrentThread
extends RealtimeThread
implements ConcurrentExecutor {
    private volatile Runnable _logic;
    private MemoryArea _memoryArea;
    private int _priority;
    private ConcurrentExecutor.Status _status;
    private boolean _terminate;
    private String _name = "ConcurrentThread-" + this.getCount();
    private Thread _source;
    private static int _Count;
    private static final Reflection.Method SET_NAME;
    private static final Reflection.Method SET_DAEMON;

    public ConcurrentThread() {
        if (SET_NAME != null) {
            SET_NAME.invoke(this, this._name);
        }
        if (SET_DAEMON != null) {
            SET_DAEMON.invoke(this, new Boolean(true));
        }
    }

    private synchronized int getCount() {
        return _Count++;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public void run() {
        while (true) {
            Thread thread = this;
            synchronized (thread) {
                try {
                    while (this._logic == null && !this._terminate) {
                        this.wait();
                    }
                }
                catch (InterruptedException interruptedException) {
                    throw new ConcurrentException(interruptedException);
                }
            }
            if (this._logic == null) return;
            try {
                thread = Thread.currentThread();
                if (thread.getPriority() != this._priority) {
                    thread.setPriority(this._priority);
                }
                this._status.started();
                this._memoryArea.executeInArea(this._logic);
                continue;
            }
            catch (Throwable throwable) {
                this._status.error(throwable);
                continue;
            }
            finally {
                this._status.completed();
                this._status = null;
                this._source = null;
                this._logic = null;
                continue;
            }
            break;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean execute(Runnable runnable, ConcurrentExecutor.Status status) {
        if (this._logic != null) {
            return false;
        }
        ConcurrentThread concurrentThread = this;
        synchronized (concurrentThread) {
            if (this._logic != null) {
                return false;
            }
            this._memoryArea = RealtimeThread.getCurrentMemoryArea();
            this._source = ConcurrentThread.currentThread();
            if (this._source instanceof ConcurrentThread) {
                this._source = ((ConcurrentThread)this._source)._source;
            }
            this._priority = this._source.getPriority();
            this._status = status;
            this._logic = runnable;
            this.notify();
            return true;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void terminate() {
        ConcurrentThread concurrentThread = this;
        synchronized (concurrentThread) {
            this._terminate = true;
            this.notify();
        }
    }

    public String toString() {
        return this._name + "(" + this._source + ")";
    }

    static {
        SET_NAME = Reflection.getMethod("java.lang.Thread.setName(String)");
        SET_DAEMON = Reflection.getMethod("java.lang.Thread.setDaemon(boolean)");
    }
}

