/*
 * Decompiled with CFR 0.152.
 */
package javolution.context;

import javax.realtime.MemoryArea;
import javolution.context.Context;
import javolution.context.LocalPools;
import javolution.context.ObjectPool;
import javolution.lang.ClassInitializer;
import javolution.lang.Configurable;
import javolution.util.FastTable;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public abstract class ObjectFactory<T> {
    public static final Configurable<Integer> MAX_COUNT = new Configurable(new Integer(256)){

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        protected void notifyChange() {
            Object object = LOCK;
            synchronized (object) {
                final int n = MAX_COUNT.get();
                if (_Count >= n) {
                    throw new UnsupportedOperationException("Already " + _Count + " factories, cannot reduce to " + n);
                }
                MemoryArea.getMemoryArea(_Instances).executeInArea(new Runnable(){

                    public void run() {
                        ObjectFactory[] objectFactoryArray = new ObjectFactory[n];
                        System.arraycopy(_Instances, 0, objectFactoryArray, 0, _Count);
                        _Instances = objectFactoryArray;
                    }
                });
            }
        }
    };
    private static final Object LOCK = new Object();
    static ObjectFactory[] _Instances = new ObjectFactory[MAX_COUNT.get().intValue()];
    static int _Count;
    final int _index;
    private boolean _doCleanup = true;
    private final ThreadLocal _currentPool = new ThreadLocal(){

        protected Object initialValue() {
            return ObjectFactory.this.newHeapPool();
        }
    };

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected ObjectFactory() {
        Object object = LOCK;
        synchronized (object) {
            if (_Count >= _Instances.length) {
                throw new UnsupportedOperationException("Configuration setting of a maximum " + _Instances.length + " factories has been reached");
            }
            Class<?> clazz = this.getClass();
            for (int i = 0; i < _Count; ++i) {
                if (clazz != _Instances[i].getClass()) continue;
                throw new UnsupportedOperationException(clazz + "  cannot have more than one instance");
            }
            this._index = _Count++;
            ObjectFactory._Instances[this._index] = this;
        }
    }

    protected abstract T create();

    public T object() {
        return this.currentPool().next();
    }

    public void recycle(T t) {
        this.currentPool().recycle(t);
    }

    public ObjectPool<T> currentPool() {
        ObjectPool<T> objectPool = (ObjectPool<T>)this._currentPool.get();
        return objectPool.getUser() != null ? objectPool : this.activatePool();
    }

    private final ObjectPool<T> activatePool() {
        LocalPools localPools = Context.current().getLocalPools();
        ObjectPool objectPool = localPools.getPool(this, true);
        this._currentPool.set(objectPool);
        return objectPool;
    }

    protected void cleanup(T t) {
        this._doCleanup = false;
    }

    protected final boolean doCleanup() {
        return this._doCleanup;
    }

    protected ObjectPool newStackPool() {
        return new StackPool();
    }

    protected ObjectPool newHeapPool() {
        return new HeapPool();
    }

    static ObjectFactory getInstance(Class clazz) {
        String string = clazz.getName();
        int n = string.lastIndexOf(36);
        if (n > 0) {
            ClassInitializer.initialize(string.substring(0, n));
        }
        ClassInitializer.initialize(clazz);
        for (int i = 0; i < _Count; ++i) {
            if (!_Instances[i].getClass().equals(clazz)) continue;
            return _Instances[i];
        }
        throw new IllegalArgumentException("Factory class: " + clazz + " not found" + ", possibly container class not initialized");
    }

    private final class StackPool
    extends ObjectPool
    implements Runnable {
        private final FastTable _objects = new FastTable();
        private int _index;
        private Object _tmpObject;

        private StackPool() {
        }

        public int getSize() {
            return this._objects.size();
        }

        public void setSize(int n) {
            for (int i = this.getSize(); i < n; ++i) {
                this._objects.addLast(ObjectFactory.this.create());
            }
        }

        public Object next() {
            return this._index < this._objects.size() ? this._objects.get(this._index++) : this.newObject();
        }

        private Object newObject() {
            MemoryArea.getMemoryArea(this).executeInArea(this);
            this._objects.add(this._tmpObject);
            ++this._index;
            return this._tmpObject;
        }

        public void recycle(Object object) {
            ObjectFactory.this.cleanup(object);
            int n = this._index;
            while (--n >= 0) {
                if (this._objects.get(n) != object) continue;
                Object e = this._objects.get(--this._index);
                this._objects.set(n, e);
                this._objects.set(this._index, object);
                return;
            }
            throw new IllegalArgumentException("Object not in the pool");
        }

        protected void recycleAll() {
            for (int i = 0; i < this._index && ObjectFactory.this._doCleanup; ++i) {
                Object e = this._objects.get(i);
                ObjectFactory.this.cleanup(e);
            }
            this._index = 0;
        }

        protected void clearAll() {
            this._objects.clear();
            this._index = 0;
        }

        public void run() {
            this._tmpObject = ObjectFactory.this.create();
        }

        public ObjectFactory getFactory() {
            return ObjectFactory.this;
        }
    }

    private final class HeapPool
    extends ObjectPool {
        private final FastTable _objects = new FastTable();

        private HeapPool() {
        }

        public int getSize() {
            return this._objects.size();
        }

        public void setSize(int n) {
            for (int i = this.getSize(); i < n; ++i) {
                this._objects.addLast(ObjectFactory.this.create());
            }
        }

        public Object next() {
            return this._objects.isEmpty() ? ObjectFactory.this.create() : this._objects.removeLast();
        }

        public void recycle(Object object) {
            ObjectFactory.this.cleanup(object);
            if (MemoryArea.getMemoryArea(object) != MemoryArea.getMemoryArea(this)) {
                return;
            }
            this._objects.addLast(object);
        }

        protected void recycleAll() {
        }

        protected void clearAll() {
            this._objects.clear();
        }

        public ObjectFactory getFactory() {
            return ObjectFactory.this;
        }
    }
}

