/*
 * Decompiled with CFR 0.152.
 */
package javolution.text;

import java.io.Serializable;
import javax.realtime.MemoryArea;
import javolution.Javolution;
import javolution.context.Realtime;
import javolution.context.RealtimeObject;
import javolution.lang.Immutable;
import javolution.text.CharArray;
import javolution.text.CharSet;
import javolution.text.TextBuilder;
import javolution.util.FastComparator;
import javolution.util.FastMap;
import javolution.xml.XMLFormat;
import javolution.xml.stream.XMLStreamException;

public abstract class Text
extends RealtimeObject
implements CharSequence,
Comparable,
Serializable,
Immutable {
    private static final FastMap INTERN_INSTANCES = new FastMap().setKeyComparator(FastComparator.LEXICAL);
    public static final Text EMPTY = Text.intern("");
    public static final Text NULL = Text.intern("null");
    protected static final XMLFormat<Text> XML = new XMLFormat(Javolution.j2meGetClass("javolution.text.Text")){

        public Object newInstance(Class clazz, XMLFormat.InputElement inputElement) throws XMLStreamException {
            CharArray charArray = inputElement.getAttribute("value");
            return charArray != null ? Text.valueOf(charArray) : EMPTY;
        }

        public void read(XMLFormat.InputElement inputElement, Object object) throws XMLStreamException {
        }

        public void write(Object object, XMLFormat.OutputElement outputElement) throws XMLStreamException {
            outputElement.setAttribute("value", (Text)object);
        }
    };
    int _count;
    private static final Text TRUE = Text.intern("true");
    private static final Text FALSE = Text.intern("false");
    private static final Text[] ASCII = new Text[128];

    private Text() {
    }

    public static Text valueOf(Object object) {
        if (object instanceof Realtime) {
            return ((Realtime)object).toText();
        }
        if (object != null) {
            return Text.valueOf(object.toString());
        }
        return NULL;
    }

    private static Text valueOf(String string) {
        int n = string.length();
        if (string.length() <= 32) {
            Primitive primitive = Primitive.newInstance(n);
            string.getChars(0, n, primitive._data, 0);
            return primitive;
        }
        int n2 = n + 32 >> 1 & 0xFFFFFFE0;
        Composite composite = Composite.newInstance(Text.valueOf(string.substring(0, n2)), Text.valueOf(string.substring(n2, n)));
        return composite;
    }

    public static Text valueOf(char[] cArray) {
        return Text.valueOf(cArray, 0, cArray.length);
    }

    public static Text valueOf(char[] cArray, int n, int n2) {
        if (n < 0 || n2 < 0 || n + n2 > cArray.length) {
            throw new IndexOutOfBoundsException();
        }
        if (n2 <= 32) {
            Primitive primitive = Primitive.newInstance(n2);
            System.arraycopy(cArray, n, primitive._data, 0, n2);
            return primitive;
        }
        int n3 = n2 + 32 >> 1 & 0xFFFFFFE0;
        Composite composite = Composite.newInstance(Text.valueOf(cArray, n, n3), Text.valueOf(cArray, n + n3, n2 - n3));
        return composite;
    }

    static Text valueOf(TextBuilder textBuilder, int n, int n2) {
        int n3 = n2 - n;
        if (n3 <= 32) {
            Primitive primitive = Primitive.newInstance(n3);
            textBuilder.getChars(n, n2, primitive._data, 0);
            return primitive;
        }
        int n4 = n3 + 32 >> 1 & 0xFFFFFFE0;
        Composite composite = Composite.newInstance(Text.valueOf(textBuilder, n, n + n4), Text.valueOf(textBuilder, n + n4, n2));
        return composite;
    }

    public static Text valueOf(boolean bl) {
        return bl ? TRUE : FALSE;
    }

    public static Text valueOf(char c) {
        if (c < '\u0080' && ASCII[c] != null) {
            return ASCII[c];
        }
        Primitive primitive = Primitive.newInstance(1);
        ((Primitive)primitive)._data[0] = c;
        Text text = Text.intern(primitive);
        if (c < '\u0080') {
            Text.ASCII[c] = text;
        }
        return text;
    }

    public static Text valueOf(int n) {
        TextBuilder textBuilder = TextBuilder.newInstance();
        textBuilder.append(n);
        Text text = textBuilder.toText();
        TextBuilder.recycle(textBuilder);
        return text;
    }

    public static Text valueOf(int n, int n2) {
        TextBuilder textBuilder = TextBuilder.newInstance();
        textBuilder.append(n, n2);
        Text text = textBuilder.toText();
        TextBuilder.recycle(textBuilder);
        return text;
    }

    public static Text valueOf(long l) {
        TextBuilder textBuilder = TextBuilder.newInstance();
        textBuilder.append(l);
        Text text = textBuilder.toText();
        TextBuilder.recycle(textBuilder);
        return text;
    }

    public static Text valueOf(long l, int n) {
        TextBuilder textBuilder = TextBuilder.newInstance();
        textBuilder.append(l, n);
        Text text = textBuilder.toText();
        TextBuilder.recycle(textBuilder);
        return text;
    }

    public static Text valueOf(float f) {
        TextBuilder textBuilder = TextBuilder.newInstance();
        textBuilder.append(f);
        Text text = textBuilder.toText();
        TextBuilder.recycle(textBuilder);
        return text;
    }

    public static Text valueOf(double d) {
        TextBuilder textBuilder = TextBuilder.newInstance();
        textBuilder.append(d);
        Text text = textBuilder.toText();
        TextBuilder.recycle(textBuilder);
        return text;
    }

    public final int length() {
        return this._count;
    }

    public final Text plus(Object object) {
        return this.concat(Text.valueOf(object));
    }

    public final Text concat(Text text) {
        int n = this._count + text._count;
        if (n <= 32) {
            Primitive primitive = Primitive.newInstance(n);
            this.getChars(0, this._count, primitive._data, 0);
            text.getChars(0, text._count, primitive._data, this._count);
            return primitive;
        }
        if (this._count << 1 < text._count && text instanceof Composite) {
            Composite composite = (Composite)text;
            if (((Composite)composite)._head._count > ((Composite)composite)._tail._count) {
                composite = composite.rightRotation();
            }
            return Composite.newInstance(this.concat(composite._head), composite._tail);
        }
        if (text._count << 1 < this._count && this instanceof Composite) {
            Composite composite = (Composite)this;
            if (((Composite)composite)._tail._count > ((Composite)composite)._head._count) {
                composite = composite.leftRotation();
            }
            return Composite.newInstance(composite._head, composite._tail.concat(text));
        }
        return Composite.newInstance(this, text);
    }

    public final Text subtext(int n) {
        return this.subtext(n, this.length());
    }

    public final Text insert(int n, Text text) {
        return this.subtext(0, n).concat(text).concat(this.subtext(n));
    }

    public final Text delete(int n, int n2) {
        if (n > n2) {
            throw new IndexOutOfBoundsException();
        }
        return this.subtext(0, n).concat(this.subtext(n2));
    }

    public final Text replace(CharSequence charSequence, CharSequence charSequence2) {
        int n = this.indexOf(charSequence);
        return n < 0 ? this : this.subtext(0, n).concat(Text.valueOf(charSequence2)).concat(this.subtext(n + charSequence.length()).replace(charSequence, charSequence2));
    }

    public final Text replace(CharSet charSet, CharSequence charSequence) {
        int n = this.indexOfAny(charSet);
        return n < 0 ? this : this.subtext(0, n).concat(Text.valueOf(charSequence)).concat(this.subtext(n + 1).replace(charSet, charSequence));
    }

    public final CharSequence subSequence(int n, int n2) {
        return this.subtext(n, n2);
    }

    public final int indexOf(CharSequence charSequence) {
        return this.indexOf(charSequence, 0);
    }

    public final int indexOf(CharSequence charSequence, int n) {
        int n2 = charSequence.length();
        int n3 = Math.max(0, n);
        int n4 = this._count - n2;
        if (n2 == 0) {
            return n3 > n4 ? -1 : n3;
        }
        char c = charSequence.charAt(0);
        int n5 = this.indexOf(c, n3);
        while (n5 >= 0 && n5 <= n4) {
            boolean bl = true;
            for (int i = 1; i < n2; ++i) {
                if (this.charAt(n5 + i) == charSequence.charAt(i)) continue;
                bl = false;
                break;
            }
            if (bl) {
                return n5;
            }
            ++n5;
            n5 = this.indexOf(c, n5);
        }
        return -1;
    }

    public final int lastIndexOf(CharSequence charSequence) {
        return this.lastIndexOf(charSequence, this._count);
    }

    public final int lastIndexOf(CharSequence charSequence, int n) {
        int n2 = charSequence.length();
        int n3 = Math.min(n, this._count - n2);
        if (n2 == 0) {
            return 0 > n3 ? -1 : n3;
        }
        char c = charSequence.charAt(0);
        int n4 = this.lastIndexOf(c, n3);
        while (n4 >= 0) {
            boolean bl = true;
            for (int i = 1; i < n2; ++i) {
                if (this.charAt(n4 + i) == charSequence.charAt(i)) continue;
                bl = false;
                break;
            }
            if (bl) {
                return n4;
            }
            --n4;
            n4 = this.lastIndexOf(c, n4);
        }
        return -1;
    }

    public final boolean startsWith(CharSequence charSequence) {
        return this.startsWith(charSequence, 0);
    }

    public final boolean endsWith(CharSequence charSequence) {
        return this.startsWith(charSequence, this.length() - charSequence.length());
    }

    public final boolean startsWith(CharSequence charSequence, int n) {
        int n2 = charSequence.length();
        if (n >= 0 && n <= this.length() - n2) {
            int n3 = 0;
            int n4 = n;
            while (n3 < n2) {
                if (charSequence.charAt(n3++) == this.charAt(n4++)) continue;
                return false;
            }
            return true;
        }
        return false;
    }

    public final Text trim() {
        int n;
        int n2 = this.length() - 1;
        for (n = 0; n <= n2 && this.charAt(n) <= ' '; ++n) {
        }
        while (n2 >= n && this.charAt(n2) <= ' ') {
            --n2;
        }
        return this.subtext(n, n2 + 1);
    }

    public static Text intern(CharSequence charSequence) {
        Text text = (Text)INTERN_INSTANCES.get(charSequence);
        return text != null ? text : Text.internImpl(((Object)charSequence).toString());
    }

    public static Text intern(String string) {
        Text text = (Text)INTERN_INSTANCES.get(string);
        return text != null ? text : Text.internImpl(string);
    }

    private static synchronized Text internImpl(final String string) {
        if (INTERN_INSTANCES.containsKey(string)) {
            return (Text)INTERN_INSTANCES.get(string);
        }
        MemoryArea.getMemoryArea(INTERN_INSTANCES).executeInArea(new Runnable(){

            public void run() {
                Text text = (Text)Text.valueOf(string).moveHeap();
                INTERN_INSTANCES.put(text, text);
            }
        });
        return (Text)INTERN_INSTANCES.get(string);
    }

    public final boolean contentEquals(CharSequence charSequence) {
        if (charSequence.length() != this._count) {
            return false;
        }
        int n = 0;
        while (n < this._count) {
            if (this.charAt(n) == charSequence.charAt(n++)) continue;
            return false;
        }
        return true;
    }

    public final boolean contentEqualsIgnoreCase(CharSequence charSequence) {
        if (this._count != charSequence.length()) {
            return false;
        }
        int n = 0;
        while (n < this._count) {
            char c;
            char c2 = this.charAt(n);
            if (c2 == (c = charSequence.charAt(n++)) || (c2 = Character.toUpperCase(c2)) == (c = Character.toUpperCase(c)) || Character.toLowerCase(c2) == Character.toLowerCase(c)) continue;
            return false;
        }
        return true;
    }

    public final boolean equals(Object object) {
        if (this == object) {
            return true;
        }
        if (!(object instanceof Text)) {
            return false;
        }
        Text text = (Text)object;
        if (this._count != text._count) {
            return false;
        }
        int n = 0;
        while (n < this._count) {
            if (this.charAt(n) == text.charAt(n++)) continue;
            return false;
        }
        return true;
    }

    public final int hashCode() {
        int n = 0;
        int n2 = this.length();
        int n3 = 0;
        while (n3 < n2) {
            n = 31 * n + this.charAt(n3++);
        }
        return n;
    }

    public final int compareTo(Object object) {
        return FastComparator.LEXICAL.compare(this, (CharSequence)object);
    }

    public final Text toText() {
        return this;
    }

    public abstract Text toLowerCase();

    public abstract Text toUpperCase();

    public abstract int depth();

    public abstract char charAt(int var1);

    public abstract int indexOf(char var1, int var2);

    public abstract int lastIndexOf(char var1, int var2);

    public abstract Text subtext(int var1, int var2);

    public abstract void getChars(int var1, int var2, char[] var3, int var4);

    public abstract String stringValue();

    public static Text valueOf(char c, int n) {
        if (n < 0) {
            throw new IndexOutOfBoundsException();
        }
        if (n <= 32) {
            Primitive primitive = Primitive.newInstance(n);
            int n2 = 0;
            while (n2 < n) {
                ((Primitive)primitive)._data[n2++] = c;
            }
            return primitive;
        }
        int n3 = n >> 1;
        return Composite.newInstance(Text.valueOf(c, n3), Text.valueOf(c, n - n3));
    }

    public final boolean isBlank() {
        return this.isBlank(0, this.length());
    }

    public final boolean isBlank(int n, int n2) {
        while (n < n2) {
            if (this.charAt(n) > ' ') {
                return false;
            }
            ++n;
        }
        return true;
    }

    public final Text trimStart() {
        int n;
        int n2 = this.length() - 1;
        for (n = 0; n <= n2 && this.charAt(n) <= ' '; ++n) {
        }
        return this.subtext(n, n2 + 1);
    }

    public final Text trimEnd() {
        int n;
        int n2 = 0;
        for (n = this.length() - 1; n >= n2 && this.charAt(n) <= ' '; --n) {
        }
        return this.subtext(n2, n + 1);
    }

    public final Text padLeft(int n) {
        return this.padLeft(n, ' ');
    }

    public final Text padLeft(int n, char c) {
        int n2 = n <= this.length() ? 0 : n - this.length();
        return this.insert(0, Text.valueOf(c, n2));
    }

    public final Text padRight(int n) {
        return this.padRight(n, ' ');
    }

    public final Text padRight(int n, char c) {
        int n2 = n <= this.length() ? 0 : n - this.length();
        return this.concat(Text.valueOf(c, n2));
    }

    public final int indexOfAny(CharSet charSet) {
        return this.indexOfAny(charSet, 0, this.length());
    }

    public final int indexOfAny(CharSet charSet, int n) {
        return this.indexOfAny(charSet, n, this.length() - n);
    }

    public final int indexOfAny(CharSet charSet, int n, int n2) {
        int n3 = n + n2;
        for (int i = n; i < n3; ++i) {
            if (!charSet.contains(this.charAt(i))) continue;
            return i;
        }
        return -1;
    }

    public final int lastIndexOfAny(CharSet charSet) {
        return this.lastIndexOfAny(charSet, 0, this.length());
    }

    public final int lastIndexOfAny(CharSet charSet, int n) {
        return this.lastIndexOfAny(charSet, n, this.length() - n);
    }

    public final int lastIndexOfAny(CharSet charSet, int n, int n2) {
        int n3 = n + n2;
        while (--n3 >= n) {
            if (!charSet.contains(this.charAt(n3))) continue;
            return n3;
        }
        return -1;
    }

    private static final class Composite
    extends Text {
        private static final RealtimeObject.Factory FACTORY = new RealtimeObject.Factory(){

            public Object create() {
                return new Composite();
            }
        };
        private Text _head;
        private Text _tail;

        private Composite() {
        }

        private static Composite newInstance(Text text, Text text2) {
            Composite composite = (Composite)FACTORY.object();
            composite._count = text._count + text2._count;
            composite._head = text;
            composite._tail = text2;
            return composite;
        }

        private Composite rightRotation() {
            if (!(this._head instanceof Composite)) {
                return this;
            }
            Composite composite = (Composite)this._head;
            Text text = composite._head;
            Text text2 = composite._tail;
            Text text3 = this._tail;
            return Composite.newInstance(text, Composite.newInstance(text2, text3));
        }

        private Composite leftRotation() {
            if (!(this._tail instanceof Composite)) {
                return this;
            }
            Composite composite = (Composite)this._tail;
            Text text = composite._head;
            Text text2 = composite._tail;
            Text text3 = this._head;
            return Composite.newInstance(Composite.newInstance(text3, text), text2);
        }

        public int depth() {
            return Math.max(this._head.depth(), this._tail.depth()) + 1;
        }

        public char charAt(int n) {
            return n < this._head._count ? this._head.charAt(n) : this._tail.charAt(n - this._head._count);
        }

        public int indexOf(char c, int n) {
            int n2;
            int n3 = this._head._count;
            if (n < n3 && (n2 = this._head.indexOf(c, n)) >= 0) {
                return n2;
            }
            n2 = this._tail.indexOf(c, n - n3);
            return n2 >= 0 ? n2 + n3 : -1;
        }

        public int lastIndexOf(char c, int n) {
            int n2;
            int n3 = this._head._count;
            if (n >= n3 && (n2 = this._tail.lastIndexOf(c, n - n3)) >= 0) {
                return n2 + n3;
            }
            return this._head.lastIndexOf(c, n);
        }

        public Text subtext(int n, int n2) {
            int n3 = this._head._count;
            if (n2 <= n3) {
                return this._head.subtext(n, n2);
            }
            if (n >= n3) {
                return this._tail.subtext(n - n3, n2 - n3);
            }
            if (n == 0 && n2 == this._count) {
                return this;
            }
            return this._head.subtext(n, n3).concat(this._tail.subtext(0, n2 - n3));
        }

        public void getChars(int n, int n2, char[] cArray, int n3) {
            int n4 = this._head._count;
            if (n2 <= n4) {
                this._head.getChars(n, n2, cArray, n3);
            } else if (n >= n4) {
                this._tail.getChars(n - n4, n2 - n4, cArray, n3);
            } else {
                this._head.getChars(n, n4, cArray, n3);
                this._tail.getChars(0, n2 - n4, cArray, n3 + n4 - n);
            }
        }

        public Text toLowerCase() {
            return Composite.newInstance(this._head.toLowerCase(), this._tail.toLowerCase());
        }

        public Text toUpperCase() {
            return Composite.newInstance(this._head.toUpperCase(), this._tail.toUpperCase());
        }

        public String stringValue() {
            char[] cArray = new char[this._count];
            this.getChars(0, this._count, cArray, 0);
            return new String(cArray, 0, this._count);
        }

        public boolean move(Realtime.ObjectSpace objectSpace) {
            if (super.move(objectSpace)) {
                this._head.move(objectSpace);
                this._tail.move(objectSpace);
                return true;
            }
            return false;
        }
    }

    private static final class Primitive
    extends Text {
        private static final int BLOCK_SIZE = 32;
        private static final int BLOCK_MASK = -32;
        private static final RealtimeObject.Factory FACTORY = new RealtimeObject.Factory(){

            public Object create() {
                return new Primitive();
            }
        };
        private final char[] _data = new char[32];

        private Primitive() {
        }

        private static Primitive newInstance(int n) {
            Primitive primitive = (Primitive)FACTORY.object();
            primitive._count = n;
            return primitive;
        }

        public int depth() {
            return 0;
        }

        public char charAt(int n) {
            if (n >= this._count) {
                throw new IndexOutOfBoundsException();
            }
            return this._data[n];
        }

        public int indexOf(char c, int n) {
            for (int i = Math.max(n, 0); i < this._count; ++i) {
                if (this._data[i] != c) continue;
                return i;
            }
            return -1;
        }

        public int lastIndexOf(char c, int n) {
            for (int i = Math.min(n, this._count - 1); i >= 0; --i) {
                if (this._data[i] != c) continue;
                return i;
            }
            return -1;
        }

        public Text subtext(int n, int n2) {
            if (n < 0 || n > n2 || n2 > this._count) {
                throw new IndexOutOfBoundsException();
            }
            if (n == 0 && n2 == this._count) {
                return this;
            }
            if (n == n2) {
                return EMPTY;
            }
            int n3 = n2 - n;
            Primitive primitive = Primitive.newInstance(n3);
            System.arraycopy(this._data, n, primitive._data, 0, n3);
            return primitive;
        }

        public Text toLowerCase() {
            Primitive primitive = Primitive.newInstance(this._count);
            int n = 0;
            while (n < this._count) {
                primitive._data[n] = Character.toLowerCase(this._data[n++]);
            }
            return primitive;
        }

        public Text toUpperCase() {
            Primitive primitive = Primitive.newInstance(this._count);
            int n = 0;
            while (n < this._count) {
                primitive._data[n] = Character.toUpperCase(this._data[n++]);
            }
            return primitive;
        }

        public void getChars(int n, int n2, char[] cArray, int n3) {
            if (n < 0 || n2 > this._count || n > n2) {
                throw new IndexOutOfBoundsException();
            }
            System.arraycopy(this._data, n, cArray, n3, n2 - n);
        }

        public String stringValue() {
            return new String(this._data, 0, this._count);
        }
    }
}

