/* This program is free software; you can redistribute it and/or modify
 * it under the terms of the GNU General Public License as published by
 * the Free Software Foundation; either version 2, or (at your option)
 * any later version.
 *
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 *
 * You should have received a copy of the GNU General Public License
 * along with this program; if not, write to the Free Software
 * Foundation, Inc., 59 Temple Place - Suite 330, Boston, MA
 * 02111-1307, USA.
 *
 * http://www.gnu.org/copyleft/gpl.html
 */
package net.sf.l2j.custom;

import java.text.DateFormat;
import java.text.SimpleDateFormat;
import java.util.Date;
import java.util.regex.Matcher;
import java.util.regex.Pattern;

/**
 *
 * @author  JOJO
 */
public class CallTree
{
	static final DateFormat date_time = new SimpleDateFormat("yyyy/MM/dd HH:mm:ss");

	// Sw̃hC͒ĎזȂ̂ŁA啶Ŏn܂NXoB
	// Fyzogroup(1)
	//  "net.sf.l2j.gameserver.clientpackets.yRequestRestart.runImpl(RequestRestart.java:145)z"
	static final Pattern pattern1 = Pattern.compile("^.*\\.([A-Z].*)$");

	/**
	 * ֐Ăяoc[ɕ\B
	 * StackTraceElement[] ̒g java ̃o[WvbgtH[ɂĈႤȂ̂
	 * ̊ɂ킹ĂBǂfobOp̎ĝĂłB
	 */
	public static void print()
	{
		System.out.println(date_time.format(new Date()));
		String indent = "|";
		String ksen = " ";
		StackTraceElement[] elements = Thread.currentThread().getStackTrace();
			// elements[length-1] <<`
			// elements[3] 
			// elements[2] `܂>> EEE\
			// elements[1] CallTree.print()EEÊĂ
			// elements[0] getStackTrace()EEÊĂ
		for (int i = elements.length; --i >= 2; ) {
			StackTraceElement element = elements[i];
			Matcher m = pattern1.matcher(element.toString()); // if ($elements[i] =~ m/$pattern1/)
			if (! m.matches()) continue;
			String S1 = m.group(1); // = $1
			if (S1.indexOf(".java:") < 0) continue;	// \[XR[hŝ͎Ă
//			if (S1.startsWith("CallTree.")) continue;	// ĝ͎Ă
			System.out.println(indent + ksen + S1);
			indent += "   ";
		//	ksen    = " ";
		}
	}
	
	/**
	 * 啶ł͂܂NXoB
	 * @param: getClassName(this)
	 */
	public static String getClassName(Object _this)
	{
		String str = _this.getClass().getName();
		Matcher m = pattern1.matcher(str);
		if (m.matches()) str = m.group(1);	// if ($str =~ m/$pattern1/) { $str = $1 }
		return "<"+_this.hashCode()+">" + str;
	}
}
