/*
 * $HeadURL: $
 *
 * $Author: $
 * $Date: $
 * $Revision: $
 *
 *
 * This program is free software; you can redistribute it and/or modify
 * it under the terms of the GNU General Public License as published by
 * the Free Software Foundation; either version 2, or (at your option)
 * any later version.
 *
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 *
 * You should have received a copy of the GNU General Public License
 * along with this program; if not, write to the Free Software
 * Foundation, Inc., 59 Temple Place - Suite 330, Boston, MA
 * 02111-1307, USA.
 *
 * http://www.gnu.org/copyleft/gpl.html
 */
package net.sf.l2j.gameserver.instancemanager;

import java.util.concurrent.ScheduledFuture;
import java.util.logging.Logger;
import java.util.Map;
import java.util.Set;
import java.util.List;
import javolution.util.FastMap;
import javolution.util.FastList;
import java.sql.PreparedStatement;
import java.sql.ResultSet;

import net.sf.l2j.Config;
import net.sf.l2j.L2DatabaseFactory;
import net.sf.l2j.gameserver.datatables.SpawnTable;
import net.sf.l2j.gameserver.datatables.DoorTable;
import net.sf.l2j.gameserver.datatables.NpcTable;
import net.sf.l2j.gameserver.ThreadPoolManager;
import net.sf.l2j.gameserver.model.actor.instance.L2PcInstance;
import net.sf.l2j.gameserver.model.L2ItemInstance;
import net.sf.l2j.gameserver.model.L2World;
import net.sf.l2j.gameserver.util.Util;
import net.sf.l2j.gameserver.model.L2Spawn;
import net.sf.l2j.gameserver.templates.L2NpcTemplate;
import net.sf.l2j.gameserver.model.actor.instance.L2NpcInstance;
import net.sf.l2j.gameserver.model.actor.instance.L2SepulcherMonsterInstance;
import net.sf.l2j.util.Rnd;

/**
 * This class ...
 * S_}l[W[
 * @version $Revision: $ $Date: $
 * @author  sandman
 */
public class FourSepulchersManager
{
    // K[
    protected static Logger _log = Logger.getLogger(FourSepulchersManager.class.getName());

    // CX^X
    private static FourSepulchersManager _Instance;

    // NGXguS̔tv
    private String _QuestId = "620_FourGoblets";
    // _̒ʍs
    private int _EntrancePass = 7075;
    private int _UsedEntrancePass = 7261;
    // ̌
    private final int _HallsKey = 7260;
	// Âu[`
    private int _OldBrooch = 7262;

    // ԑJڊǗ
    // QtԂǂH
    protected boolean _InEntryTime = false;
    // EH[AbvǂH
    protected boolean _InWarmUpTime = false;
    // _UԂǂH
    protected boolean _InAttackTime = false;
    // N[_EǂH
    protected boolean _InCoolDownTime = false;

    // ԑJڗp^XN
    protected ScheduledFuture<?> _ChangeCoolDownTimeTask = null;
    protected ScheduledFuture<?> _ChangeEntryTimeTask = null;
    protected ScheduledFuture<?> _ChaneWarmUpTimeTask = null;
    protected ScheduledFuture<?> _ChangeAttackTimeTask = null;
    protected ScheduledFuture<?> _OnPartyAnnihilatedTask = null;



    // ԂƃhȂgݍ킹(<ԂIDAhAID>)
    protected static Map<Integer,Integer> _HallGateKeepers = new FastMap<Integer,Integer>();

    // j݂̉e|[gW[x,y,z]
    private int[][] _StartHallSpawn =
	{
		{181632,-85587,-7218},     // ҂̗_
		{179963,-88978,-7218},     // xz҂̗_
		{173217,-86132,-7218},     // 匫҂̗_
		{175608,-82296,-7218}      // R҂̗_
	};

    // _Ǘlƒj݂̉e|[gW̑gݍ킹(<ǗlIDAW[x,y,z]>)
    protected static Map<Integer,int[]> _StartHallSpawns = new FastMap<Integer,int[]>();

    // nVVh[̏oW[op^[][_][npcId,x,y,z,heading]
    private int[][][] _ShadowSpawnLoc =
	{
		// op^[P
		{
			{25339,191231,-85574,-7216,33380},	// 
			{25349,189534,-88969,-7216,32768},	// xz
			{25346,173195,-76560,-7215,49277},	// 匫
			{25342,175591,-72744,-7215,49317}	// R
		},
		// op^[Q
		{
			{25342,191231,-85574,-7216,33380},	// 
			{25339,189534,-88969,-7216,32768},	// xz
			{25349,173195,-76560,-7215,49277},	// 匫ҁ@
			{25346,175591,-72744,-7215,49317}	// R
		},
		// op^[R
		{
			{25346,191231,-85574,-7216,33380},	// 
			{25342,189534,-88969,-7216,32768},	// xz
			{25339,173195,-76560,-7215,49277},	// 匫
			{25349,175591,-72744,-7215,49317}	// R
		},
		// op^[S
		{
			{25349,191231,-85574,-7216,33380},	// 
			{25346,189534,-88969,-7216,32768},	// xz
			{25342,173195,-76560,-7215,49277},	// 匫
			{25339,175591,-72744,-7215,49317}	// R
		},
	};

    // ݂̖ԂƃnVVh[̑gݍ킹
    protected Map<Integer,L2Spawn> _ShadowSpawns = new FastMap<Integer,L2Spawn>();

    // _ǗlƗ_̗pԂ̑gݍ킹(<ǗlIDAp(true = NgĂ)>)
    protected static Map<Integer,Boolean> _HallInUse = new FastMap<Integer,Boolean>();

    // _Ǘlƒ҃p[eB[_[̑gݍ킹
    protected Map<Integer,L2PcInstance> _Challengers = new FastMap<Integer,L2PcInstance>();

    // ǗlEԂƓ̔spawnf[^̑gݍ킹
    protected Map<Integer,L2Spawn> _MysteriousBoxSpawns = new FastMap<Integer,L2Spawn>();

    // ̔Əo郂X^[spawnf[^̑gݍ킹inj
    protected List<L2Spawn> _PhysicalSpawns;
    protected Map<Integer,List<L2Spawn>> _PhysicalMonsters = new FastMap<Integer,List<L2Spawn>>();
    // ̔Əo郂X^[spawnf[^̑gݍ킹i@nj
    protected List<L2Spawn> _MagicalSpawns;
    protected Map<Integer,List<L2Spawn>> _MagicalMonsters = new FastMap<Integer,List<L2Spawn>>();
    // ݂̉̓̔ƁArŌɍďo郂X^[̑gݍ킹
    protected List<L2Spawn> _DukeFinalSpawns;
    protected Map<Integer,List<L2Spawn>> _DukeFinalMobs = new FastMap<Integer,List<L2Spawn>>();
    protected Map<Integer,Boolean> _ArchonSpawned = new FastMap<Integer,Boolean>();
    // nVVh[ɍc̕挊ŏoNPC̑gݍ킹
    protected List<L2Spawn> _EmperorsGraveSpawns;
    protected Map<Integer,List<L2Spawn>> _EmperorsGraveNpcs = new FastMap<Integer,List<L2Spawn>>();

    // q݂̉̓̔ƁAoX^[̑gݍ킹
    protected Map<Integer,List<L2SepulcherMonsterInstance>> _ViscountMobs =
    	new FastMap<Integer,List<L2SepulcherMonsterInstance>>();

    // ݂̉̓̔ƁAoX^[̑gݍ킹
    protected Map<Integer,List<L2SepulcherMonsterInstance>> _DukeMobs =
    	new FastMap<Integer,List<L2SepulcherMonsterInstance>>();

    // ̔o郂X^[ƌ̔̑gݍ킹<X^[NpcId,̔NpcId>
    protected Map<Integer,Integer> _KeyBoxNpc = new FastMap<Integer,Integer>();
    protected Map<Integer,L2Spawn> _KeyBoxSpawns = new FastMap<Integer,L2Spawn>();

    // P[vS[gƃnV̎s҂spawnf[^̑gݍ킹
    protected Map<Integer,Integer> _Victim = new FastMap<Integer,Integer>();
    protected Map<Integer,L2Spawn> _ExecutionerSpawns = new FastMap<Integer,L2Spawn>();

    // _UԂɗ_ɏoSẴX^[
    protected List<L2NpcInstance> _AllMobs = new FastList<L2NpcInstance>();

    // RXgN^[
    public FourSepulchersManager()
    {
    }

    // CX^X֐
    public static final FourSepulchersManager getInstance()
    {
        if (_Instance == null)
        {
            _Instance = new FourSepulchersManager();
        }
        return _Instance;
    }

    // 
    public void init()
    {
        _log.info("FourSepulchersManager:Init Four-Sepulchers Manager.");

        // ^XNׂăLZ
        if(_ChangeCoolDownTimeTask != null) _ChangeCoolDownTimeTask.cancel(true);
        if(_ChangeEntryTimeTask != null) _ChangeEntryTimeTask.cancel(true);
        if(_ChaneWarmUpTimeTask != null) _ChaneWarmUpTimeTask.cancel(true);
        if(_ChangeAttackTimeTask != null) _ChangeAttackTimeTask.cancel(true);

        _ChangeCoolDownTimeTask = null;
        _ChangeEntryTimeTask = null;
        _ChaneWarmUpTimeTask = null;
        _ChangeAttackTimeTask = null;

        // tOύX(ŏ̃N[_En܂܂ł͂ǂ̎ԑтłȂ)
        _InEntryTime = false;
        _InWarmUpTime = false;
        _InAttackTime = false;
        _InCoolDownTime = false;

        // Œ
        initFixedInfo();

        // X^[zȕ
        LoadMysteriousBox();
        InitKeyBoxSpawns();
        LoadPhysicalMonsters();
        LoadMagicalMonsters();
        InitLocationShadowSpawns();
        InitExecutionerSpawns();
        LoadDukeMonsters();
        LoadEmperorsGraveMonsters();

        // ŏ̃N[_EԂɈڍs^XNd
        _ChangeCoolDownTimeTask =
            ThreadPoolManager.getInstance().scheduleGeneral(new ChangeCoolDownTime(),Config.FS_TIME_ATTACK * 60000);

    }

    // Œ̏
    protected void initFixedInfo()
    {
        // _Ǘlƒj݂̉e|[gW̑gݍ킹쐬
        _StartHallSpawns.clear();
        _StartHallSpawns.put(31921,_StartHallSpawn[0]);    // ҂̗_
        _StartHallSpawns.put(31922,_StartHallSpawn[1]);    // xz҂̗_
        _StartHallSpawns.put(31923,_StartHallSpawn[2]);    // 匫҂̗_
        _StartHallSpawns.put(31924,_StartHallSpawn[3]);    // R҂̗_

        // ԂƃhȂgݍ킹쐬
        _HallGateKeepers.clear();
        _HallGateKeepers.put(31925, 25150012);  // ҂̗_Fj݂̉
        _HallGateKeepers.put(31926, 25150013);  // ҂̗_Fq݂̉
        _HallGateKeepers.put(31927, 25150014);  // ҂̗_F݂̉
        _HallGateKeepers.put(31928, 25150015);  // ҂̗_F݂̉
        _HallGateKeepers.put(31929, 25150016);  // ҂̗_F݂̉
        _HallGateKeepers.put(31930, 25150002);  // xz҂̗_Fj݂̉
        _HallGateKeepers.put(31931, 25150003);  // xz҂̗_Fq݂̉
        _HallGateKeepers.put(31932, 25150004);  // xz҂̗_F݂̉
        _HallGateKeepers.put(31933, 25150005);  // xz҂̗_F݂̉
        _HallGateKeepers.put(31934, 25150006);  // xz҂̗_F݂̉
        _HallGateKeepers.put(31935, 25150032);  // 匫҂̗_Fj݂̉
        _HallGateKeepers.put(31936, 25150033);  // 匫҂̗_Fq݂̉
        _HallGateKeepers.put(31937, 25150034);  // 匫҂̗_F݂̉
        _HallGateKeepers.put(31938, 25150035);  // 匫҂̗_F݂̉
        _HallGateKeepers.put(31939, 25150036);  // 匫҂̗_F݂̉
        _HallGateKeepers.put(31940, 25150022);  // R҂̗_Fj݂̉
        _HallGateKeepers.put(31941, 25150023);  // R҂̗_Fq݂̉
        _HallGateKeepers.put(31942, 25150024);  // R҂̗_F݂̉
        _HallGateKeepers.put(31943, 25150025);  // R҂̗_F݂̉
        _HallGateKeepers.put(31944, 25150026);  // R҂̗_F݂̉

        // ̔o郂X^[ƌ̔̑gݍ킹
        _KeyBoxNpc.clear();
        _KeyBoxNpc.put(18120,31455);	//nV̕,̔
        _KeyBoxNpc.put(18121,31455);	//nV̕,̔
        _KeyBoxNpc.put(18122,31455);	//nV̕,̔
        _KeyBoxNpc.put(18123,31455);	//nV̕,̔
        _KeyBoxNpc.put(18124,31456);	//nV̕,̔
        _KeyBoxNpc.put(18125,31456);	//nV̕,̔
        _KeyBoxNpc.put(18126,31456);	//nV̕,̔
        _KeyBoxNpc.put(18127,31456);	//nV̕,̔
        _KeyBoxNpc.put(18128,31457);	//nV̕,̔
        _KeyBoxNpc.put(18129,31457);	//nV̕,̔
        _KeyBoxNpc.put(18130,31457);	//nV̕,̔
        _KeyBoxNpc.put(18131,31457);	//nV̕,̔
        _KeyBoxNpc.put(18149,31458);	//n̍b,̔
        _KeyBoxNpc.put(18150,31459);	//P[vS[g,̔
        _KeyBoxNpc.put(18151,31459);	//P[vS[g,̔
        _KeyBoxNpc.put(18152,31459);	//P[vS[g,̔
        _KeyBoxNpc.put(18153,31459);	//P[vS[g,̔
        _KeyBoxNpc.put(18154,31460);	//P[vS[g,̔
        _KeyBoxNpc.put(18155,31460);	//P[vS[g,̔
        _KeyBoxNpc.put(18156,31460);	//P[vS[g,̔
        _KeyBoxNpc.put(18157,31460);	//P[vS[g,̔
        _KeyBoxNpc.put(18158,31461);	//nV̎s,̔
        _KeyBoxNpc.put(18159,31461);	//nV̎s,̔
        _KeyBoxNpc.put(18160,31461);	//nV̎s,̔
        _KeyBoxNpc.put(18161,31461);	//nV̎s,̔
        _KeyBoxNpc.put(18162,31462);	//nV̎s,̔
        _KeyBoxNpc.put(18163,31462);	//nV̎s,̔
        _KeyBoxNpc.put(18164,31462);	//nV̎s,̔
        _KeyBoxNpc.put(18165,31462);	//nV̎s,̔
        _KeyBoxNpc.put(18183,31463);	//nV̊ē,̔
        _KeyBoxNpc.put(18184,31464);	//nV̊ē,̔
        _KeyBoxNpc.put(18212,31465);	//nV Ah~jXg[^[,̔
        _KeyBoxNpc.put(18213,31465);	//nV Ah~jXg[^[,̔
        _KeyBoxNpc.put(18214,31465);	//nV Ah~jXg[^[,̔
        _KeyBoxNpc.put(18215,31465);	//nV Ah~jXg[^[,̔
        _KeyBoxNpc.put(18216,31466);	//nV Ah~jXg[^[,̔
        _KeyBoxNpc.put(18217,31466);	//nV Ah~jXg[^[,̔
        _KeyBoxNpc.put(18218,31466);	//nV Ah~jXg[^[,̔
        _KeyBoxNpc.put(18219,31466);	//nV Ah~jXg[^[,̔

        // P[vR[hƃnV̎s҂̑gݍ킹
        _Victim.clear();
        _Victim.put(18150,18158);	// P[vS[g,nV̎s
        _Victim.put(18151,18159);	// P[vS[g,nV̎s
        _Victim.put(18152,18160);	// P[vS[g,nV̎s
        _Victim.put(18153,18161);	// P[vS[g,nV̎s
        _Victim.put(18154,18162);	// P[vS[g,nV̎s
        _Victim.put(18155,18163);	// P[vS[g,nV̎s
        _Victim.put(18156,18164);	// P[vS[g,nV̎s
        _Victim.put(18157,18165);	// P[vS[g,nV̎s

    }

    // ̔spawnf[^̓ǂݍ
    private void LoadMysteriousBox()
    {
        java.sql.Connection con = null;

        // ̔̏oWNA
        _MysteriousBoxSpawns.clear();

        // ̔̏oW쐬
        try
        {
            con = L2DatabaseFactory.getInstance().getConnection();
            PreparedStatement statement = con.prepareStatement("SELECT id, count, npc_templateid, locx, locy, locz, heading, respawn_delay, key_npc_id FROM four_sepulchers_spawnlist Where spawntype = ? ORDER BY id");
            statement.setInt(1, 0);
            ResultSet rset = statement.executeQuery();

            L2Spawn spawnDat;
            L2NpcTemplate template1;

            while (rset.next())
            {
                template1 = NpcTable.getInstance().getTemplate(rset.getInt("npc_templateid"));
                if (template1 != null)
                {
                	spawnDat = new L2Spawn(template1);
                	spawnDat.setAmount(rset.getInt("count"));
                	spawnDat.setLocx(rset.getInt("locx"));
                	spawnDat.setLocy(rset.getInt("locy"));
                	spawnDat.setLocz(rset.getInt("locz"));
                	spawnDat.setHeading(rset.getInt("heading"));
                	spawnDat.setRespawnDelay(rset.getInt("respawn_delay"));
                	SpawnTable.getInstance().addNewSpawn(spawnDat, false);
                	int keyNpcId = rset.getInt("key_npc_id");
                    _MysteriousBoxSpawns.put(keyNpcId,spawnDat);
                }
                else {
                    _log.warning("FourSepulchersManager.LoadMysteriousBox: Data missing in NPC table for ID: " + rset.getInt("npc_templateid") + ".");
                }
            }

            rset.close();
            statement.close();
            _log.info("FourSepulchersManager.LoadMysteriousBox: Loaded " + _MysteriousBoxSpawns.size() + " Mysterious-Box spawn locations.");
        }
        catch (Exception e)
        {
            // problem with initializing spawn, go to next one
            _log.warning("FourSepulchersManager.LoadMysteriousBox: Spawn could not be initialized: " + e);
        }
        finally
        {
            try { con.close(); } catch (Exception e) {}
        }
    }

    // ̔spawnf[^̍쐬
    private void InitKeyBoxSpawns()
    {
    	L2Spawn spawnDat;
        L2NpcTemplate template;

        for(int keyNpcId:_KeyBoxNpc.keySet())
        {
            try
            {
                template = NpcTable.getInstance().getTemplate(_KeyBoxNpc.get(keyNpcId));
                if (template != null)
                {
                	spawnDat = new L2Spawn(template);
                	spawnDat.setAmount(1);
                	spawnDat.setLocx(0);
                	spawnDat.setLocy(0);
                	spawnDat.setLocz(0);
                	spawnDat.setHeading(0);
                	spawnDat.setRespawnDelay(3600);
                	SpawnTable.getInstance().addNewSpawn(spawnDat, false);
                	_KeyBoxSpawns.put(keyNpcId, spawnDat);
                }
                else {
                    _log.warning("FourSepulchersManager.InitKeyBoxSpawns: Data missing in NPC table for ID: " + _KeyBoxNpc.get(keyNpcId) + ".");
                }
            }
            catch (Exception e)
            {
                _log.warning("FourSepulchersManager.InitKeyBoxSpawns: Spawn could not be initialized: " + e);
            }
        }
    }

    // ^Cvspawnf[^̓ǂݍ
    private void LoadPhysicalMonsters()
    {

    	// X^[oXg
    	_PhysicalMonsters.clear();

    	// ǂݍ܂ꂽoXg̐
    	int loaded = 0;
    	java.sql.Connection con = null;

        try
        {
            con = L2DatabaseFactory.getInstance().getConnection();

            // ôƂȂNPC̃[v
            PreparedStatement statement1 = con.prepareStatement("SELECT Distinct key_npc_id FROM four_sepulchers_spawnlist Where spawntype = ? ORDER BY key_npc_id");
            statement1.setInt(1, 1);
            ResultSet rset1 = statement1.executeQuery();
            while (rset1.next())
            {
            	// o郂X^[̍WXg쐬̃[v
            	int keyNpcId = rset1.getInt("key_npc_id");

                PreparedStatement statement2 = con.prepareStatement("SELECT id, count, npc_templateid, locx, locy, locz, heading, respawn_delay, key_npc_id FROM four_sepulchers_spawnlist Where key_npc_id = ? and spawntype = ? ORDER BY id");
                statement2.setInt(1, keyNpcId);
                statement2.setInt(2, 1);
                ResultSet rset2 = statement2.executeQuery();

                L2Spawn spawnDat;
                L2NpcTemplate template1;

                // X^[Xg
                _PhysicalSpawns = new FastList<L2Spawn>();

                while (rset2.next())
                {
                    template1 = NpcTable.getInstance().getTemplate(rset2.getInt("npc_templateid"));
                    if (template1 != null)
                    {
                    	spawnDat = new L2Spawn(template1);
                    	spawnDat.setAmount(rset2.getInt("count"));
                    	spawnDat.setLocx(rset2.getInt("locx"));
                    	spawnDat.setLocy(rset2.getInt("locy"));
                    	spawnDat.setLocz(rset2.getInt("locz"));
                    	spawnDat.setHeading(rset2.getInt("heading"));
                    	spawnDat.setRespawnDelay(rset2.getInt("respawn_delay"));
                    	SpawnTable.getInstance().addNewSpawn(spawnDat, false);
                    	_PhysicalSpawns.add(spawnDat);
                    	loaded++;
                    }
                    else {
                        _log.warning("FourSepulchersManager.LoadPhysicalMonsters: Data missing in NPC table for ID: " + rset2.getInt("npc_templateid") + ".");
                    }
                }

                rset2.close();
                statement2.close();
            	_PhysicalMonsters.put(keyNpcId,_PhysicalSpawns);
            }

            rset1.close();
            statement1.close();
            _log.info("FourSepulchersManager.LoadPhysicalMonsters: Loaded " + loaded + " Physical type monsters spawn locations.");
        }
        catch (Exception e)
        {
            // problem with initializing spawn, go to next one
            _log.warning("FourSepulchersManager.LoadPhysicalMonsters: Spawn could not be initialized: " + e);
        }
        finally
        {
            try { con.close(); } catch (Exception e) {}
        }
    }

    // @^Cvspawnf[^̓ǂݍ
    private void LoadMagicalMonsters()
    {

    	// X^[oXg
    	_MagicalMonsters.clear();

    	// ǂݍ܂ꂽoXg̐
    	int loaded = 0;
    	java.sql.Connection con = null;

        try
        {
            con = L2DatabaseFactory.getInstance().getConnection();

            // ôƂȂNPC̃[v
            PreparedStatement statement1 = con.prepareStatement("SELECT Distinct key_npc_id FROM four_sepulchers_spawnlist Where spawntype = ? ORDER BY key_npc_id");
            statement1.setInt(1, 2);
            ResultSet rset1 = statement1.executeQuery();
            while (rset1.next())
            {
            	// o郂X^[̍WXg쐬̃[v
            	int keyNpcId = rset1.getInt("key_npc_id");

                PreparedStatement statement2 = con.prepareStatement("SELECT id, count, npc_templateid, locx, locy, locz, heading, respawn_delay, key_npc_id FROM four_sepulchers_spawnlist Where key_npc_id = ? and spawntype = ? ORDER BY id");
                statement2.setInt(1, keyNpcId);
                statement2.setInt(2, 2);
                ResultSet rset2 = statement2.executeQuery();

                L2Spawn spawnDat;
                L2NpcTemplate template1;

                // X^[Xg
                _MagicalSpawns = new FastList<L2Spawn>();

                while (rset2.next())
                {
                    template1 = NpcTable.getInstance().getTemplate(rset2.getInt("npc_templateid"));
                    if (template1 != null)
                    {
                    	spawnDat = new L2Spawn(template1);
                    	spawnDat.setAmount(rset2.getInt("count"));
                    	spawnDat.setLocx(rset2.getInt("locx"));
                    	spawnDat.setLocy(rset2.getInt("locy"));
                    	spawnDat.setLocz(rset2.getInt("locz"));
                    	spawnDat.setHeading(rset2.getInt("heading"));
                    	spawnDat.setRespawnDelay(rset2.getInt("respawn_delay"));
                    	SpawnTable.getInstance().addNewSpawn(spawnDat, false);
                    	_MagicalSpawns.add(spawnDat);
                    	loaded++;
                    }
                    else {
                        _log.warning("FourSepulchersManager.LoadMagicalMonsters: Data missing in NPC table for ID: " + rset2.getInt("npc_templateid") + ".");
                    }
                }

                rset2.close();
                statement2.close();
                _MagicalMonsters.put(keyNpcId,_MagicalSpawns);
            }

            rset1.close();
            statement1.close();
            _log.info("FourSepulchersManager.LoadMagicalMonsters: Loaded " + loaded + " Magical type monsters spawn locations.");
        }
        catch (Exception e)
        {
            // problem with initializing spawn, go to next one
            _log.warning("FourSepulchersManager.LoadMagicalMonsters: Spawn could not be initialized: " + e);
        }
        finally
        {
            try { con.close(); } catch (Exception e) {}
        }
    }

    // ݂̉̟rŌɍďo郂X^[spawnf[^̓ǂݍ
    private void LoadDukeMonsters()
    {

    	// X^[oXg
    	_DukeFinalMobs.clear();
    	_ArchonSpawned.clear();

    	// ǂݍ܂ꂽoXg̐
    	int loaded = 0;
    	java.sql.Connection con = null;

        try
        {
            con = L2DatabaseFactory.getInstance().getConnection();

            // ôƂȂNPC̃[v
            PreparedStatement statement1 = con.prepareStatement("SELECT Distinct key_npc_id FROM four_sepulchers_spawnlist Where spawntype = ? ORDER BY key_npc_id");
            statement1.setInt(1, 5);
            ResultSet rset1 = statement1.executeQuery();
            while (rset1.next())
            {
            	// o郂X^[̍WXg쐬̃[v
            	int keyNpcId = rset1.getInt("key_npc_id");

                PreparedStatement statement2 = con.prepareStatement("SELECT id, count, npc_templateid, locx, locy, locz, heading, respawn_delay, key_npc_id FROM four_sepulchers_spawnlist Where key_npc_id = ? and spawntype = ? ORDER BY id");
                statement2.setInt(1, keyNpcId);
                statement2.setInt(2, 5);
                ResultSet rset2 = statement2.executeQuery();

                L2Spawn spawnDat;
                L2NpcTemplate template1;

                // X^[Xg
                _DukeFinalSpawns = new FastList<L2Spawn>();

                while (rset2.next())
                {
                    template1 = NpcTable.getInstance().getTemplate(rset2.getInt("npc_templateid"));
                    if (template1 != null)
                    {
                    	spawnDat = new L2Spawn(template1);
                    	spawnDat.setAmount(rset2.getInt("count"));
                    	spawnDat.setLocx(rset2.getInt("locx"));
                    	spawnDat.setLocy(rset2.getInt("locy"));
                    	spawnDat.setLocz(rset2.getInt("locz"));
                    	spawnDat.setHeading(rset2.getInt("heading"));
                    	spawnDat.setRespawnDelay(rset2.getInt("respawn_delay"));
                    	SpawnTable.getInstance().addNewSpawn(spawnDat, false);
                    	_DukeFinalSpawns.add(spawnDat);
                    	loaded++;
                    }
                    else {
                        _log.warning("FourSepulchersManager.LoadDukeMonsters: Data missing in NPC table for ID: " + rset2.getInt("npc_templateid") + ".");
                    }
                }

                rset2.close();
                statement2.close();
                _DukeFinalMobs.put(keyNpcId,_DukeFinalSpawns);
                _ArchonSpawned.put(keyNpcId, false);
            }

            rset1.close();
            statement1.close();
            _log.info("FourSepulchersManager.LoadDukeMonsters: Loaded " + loaded + " Church of duke monsters spawn locations.");
        }
        catch (Exception e)
        {
            // problem with initializing spawn, go to next one
            _log.warning("FourSepulchersManager.LoadDukeMonsters: Spawn could not be initialized: " + e);
        }
        finally
        {
            try { con.close(); } catch (Exception e) {}
        }
    }

    // EBSbg̗HƃnV̕󔠂spawnf[^̓ǂݍ
    private void LoadEmperorsGraveMonsters()
    {

    	// X^[oXg
    	_EmperorsGraveNpcs.clear();

    	// ǂݍ܂ꂽoXg̐
    	int loaded = 0;
    	java.sql.Connection con = null;

        try
        {
            con = L2DatabaseFactory.getInstance().getConnection();

            // ôƂȂNPC̃[v
            PreparedStatement statement1 = con.prepareStatement("SELECT Distinct key_npc_id FROM four_sepulchers_spawnlist Where spawntype = ? ORDER BY key_npc_id");
            statement1.setInt(1, 6);
            ResultSet rset1 = statement1.executeQuery();
            while (rset1.next())
            {
            	// o郂X^[̍WXg쐬̃[v
            	int keyNpcId = rset1.getInt("key_npc_id");

                PreparedStatement statement2 = con.prepareStatement("SELECT id, count, npc_templateid, locx, locy, locz, heading, respawn_delay, key_npc_id FROM four_sepulchers_spawnlist Where key_npc_id = ? and spawntype = ? ORDER BY id");
                statement2.setInt(1, keyNpcId);
                statement2.setInt(2, 6);
                ResultSet rset2 = statement2.executeQuery();

                L2Spawn spawnDat;
                L2NpcTemplate template1;

                // X^[Xg
                _EmperorsGraveSpawns = new FastList<L2Spawn>();

                while (rset2.next())
                {
                    template1 = NpcTable.getInstance().getTemplate(rset2.getInt("npc_templateid"));
                    if (template1 != null)
                    {
                    	spawnDat = new L2Spawn(template1);
                    	spawnDat.setAmount(rset2.getInt("count"));
                    	spawnDat.setLocx(rset2.getInt("locx"));
                    	spawnDat.setLocy(rset2.getInt("locy"));
                    	spawnDat.setLocz(rset2.getInt("locz"));
                    	spawnDat.setHeading(rset2.getInt("heading"));
                    	spawnDat.setRespawnDelay(rset2.getInt("respawn_delay"));
                    	SpawnTable.getInstance().addNewSpawn(spawnDat, false);
                    	_EmperorsGraveSpawns.add(spawnDat);
                    	loaded++;
                    }
                    else {
                        _log.warning("FourSepulchersManager.LoadEmperorsGraveMonsters: Data missing in NPC table for ID: " + rset2.getInt("npc_templateid") + ".");
                    }
                }

                rset2.close();
                statement2.close();
                _EmperorsGraveNpcs.put(keyNpcId,_EmperorsGraveSpawns);
            }

            rset1.close();
            statement1.close();
            _log.info("FourSepulchersManager.LoadEmperorsGraveMonsters: Loaded " + loaded + " Emperor's grave NPC spawn locations.");
        }
        catch (Exception e)
        {
            // problem with initializing spawn, go to next one
            _log.warning("FourSepulchersManager.LoadEmperorsGraveMonsters: Spawn could not be initialized: " + e);
        }
        finally
        {
            try { con.close(); } catch (Exception e) {}
        }
    }

    // nVVh[spawnf[^̍쐬
    protected void InitLocationShadowSpawns()
    {
    	int locNo = Rnd.get(4);
    	final int[] gateKeeper = {31929,31934,31939,31944};

    	L2Spawn spawnDat;
        L2NpcTemplate template;

        // oWNA
        _ShadowSpawns.clear();

        // ̏oW쐬
        for(int i=0;i<=3;i++)
    	{
            template = NpcTable.getInstance().getTemplate(_ShadowSpawnLoc[locNo][i][0]);
            if (template != null)
            {
            	try
            	{
                	spawnDat = new L2Spawn(template);
                	spawnDat.setAmount(1);
                	spawnDat.setLocx(_ShadowSpawnLoc[locNo][i][1]);
                	spawnDat.setLocy(_ShadowSpawnLoc[locNo][i][2]);
                	spawnDat.setLocz(_ShadowSpawnLoc[locNo][i][3]);
                	spawnDat.setHeading(_ShadowSpawnLoc[locNo][i][4]);
                	SpawnTable.getInstance().addNewSpawn(spawnDat, false);
                	int keyNpcId = gateKeeper[i];
                	_ShadowSpawns.put(keyNpcId,spawnDat);
            	}
            	catch(Exception e)
            	{
            		_log.warning(e.getMessage());
            		e.printStackTrace();
            	}
            }
            else {
                _log.warning("FourSepulchersManager.InitLocationShadowSpawns: Data missing in NPC table for ID: " + _ShadowSpawnLoc[locNo][i][0] + ".");
            }
    	}
    }

    // nV̎s҂spawnf[^̍쐬
    protected void InitExecutionerSpawns()
    {
    	L2Spawn spawnDat;
        L2NpcTemplate template;

        for(int keyNpcId:_Victim.keySet())
        {
            try
            {
                template = NpcTable.getInstance().getTemplate(_Victim.get(keyNpcId));
                if (template != null)
                {
                	spawnDat = new L2Spawn(template);
                	spawnDat.setAmount(1);
                	spawnDat.setLocx(0);
                	spawnDat.setLocy(0);
                	spawnDat.setLocz(0);
                	spawnDat.setHeading(0);
                	spawnDat.setRespawnDelay(3600);
                	SpawnTable.getInstance().addNewSpawn(spawnDat, false);
                	_ExecutionerSpawns.put(keyNpcId, spawnDat);
                }
                else {
                    _log.warning("FourSepulchersManager.InitExecutionerSpawns: Data missing in NPC table for ID: " + _Victim.get(keyNpcId) + ".");
                }
            }
            catch (Exception e)
            {
                _log.warning("FourSepulchersManager.InitExecutionerSpawns: Spawn could not be initialized: " + e);
            }
        }
    }

    // tԂ`FbN
    public boolean IsEntryTime()
    {
    	return _InEntryTime;
    }

    // _UԂ`FbN
    public boolean IsAttackTime()
    {
    	return _InAttackTime;
    }

    // _̐\݂\ǂ`FbN
    public synchronized boolean IsEnableEntry(int npcId,L2PcInstance player)
    {
        // tԊOȂΎ󂯕tȂ
        if(!IsEntryTime()) return false;

        // ɑ̃vC[\łꍇ͎󂯕tȂ
        else if(_HallInUse.get(npcId).booleanValue()) return false;

        // Ql̊mF
        else if(Config.FS_PARTY_MEMBER_COUNT > 1)    // ConfigŃ\ł̒킪ĂȂ΂
        {
        	// vC[̓p[eBgł邱
        	if(player.getParty() == null) return false;

        	// vC[̓p[eB[_[ł邱
        	if(!player.getParty().isLeader(player)) return false;

            // vC[͋KlȏŃp[eBgł邱
            if (player.getParty().getMemberCount() < Config.FS_PARTY_MEMBER_COUNT) return false;

            else
            {
                for (L2PcInstance mem : player.getParty().getPartyMembers())
                {
                    // p[eBo[SNGXguS̔tv󂯂Ă邱
                    if(mem.getQuestState(_QuestId).get("<state>") == null) return false;
                    // p[eBo[Su_̒ʍs؁vĂ邱
                    if (mem.getInventory().getItemByItemId(_EntrancePass) == null) return false;

                    // Cxg̃ACe80%ł邱
                    int invLimitCnt = mem.getInventoryLimit();
                    int invItemCnt = mem.getInventory().getItems().length;
                    if((invItemCnt / invLimitCnt) >= 0.8) return false;

                    // Cxg̏dʂ80%ł邱
                    int invLimitWeight = mem.getMaxLoad();
                    int invWeight = mem.getInventory().getTotalWeight();
                    if((invWeight / invLimitWeight) >= 0.8) return false;
                }
            }
        }
        else    // \̏ꍇ
        {
            // ҂̓NGXguS̔tv󂯂Ă邱
            if(player.getQuestState(_QuestId).get("<state>") == null) return false;
            // ҂́u_̒ʍs؁vĂ邱
            if(player.getInventory().getItemByItemId(_EntrancePass) == null) return false;

            // Cxg̃ACe80%ł邱
            int invLimitCnt = player.getInventoryLimit();
            int invItemCnt = player.getInventory().getItems().length;
            if((invItemCnt / invLimitCnt) >= 0.8) return false;

            // Cxg̏dʂ80%ł邱
            int invLimitWeight = player.getMaxLoad();
            int invWeight = player.getInventory().getTotalWeight();
            if((invWeight / invLimitWeight) >= 0.8) return false;
        }

        // ׂĂ̔ʉ߂Ηp\
        return true;
    }

    // ҃p[eBo^Aj݂̉փe|[g
    public void Entry(int npcId, L2PcInstance player)
	{
		// ҃p[eBj݂̉փe|[g
		// e|[gW̎擾
		int[] Location = _StartHallSpawns.get(npcId);
		int driftx;
		int drifty;

		// e|[g
		if (Config.FS_PARTY_MEMBER_COUNT > 1) // ConfigŃ\ł̒킪ĂȂ΂
		{
			// _̐\ݏĊmF
			if (IsEnableEntry(npcId, player))
			{
				List<L2PcInstance> members = new FastList<L2PcInstance>(); // e|[g\ȃo[̃Xg
				for (L2PcInstance mem : player.getParty().getPartyMembers())
				{
					// o[_̒ʍs؂ĂāAĂāAp[eB[_[̔F͈͓ɂ΁Ae|[g
					if (!mem.isDead() && Util.checkIfInRange(700, player, mem, true))
					{
						members.add(mem);
					}
				}

				for (L2PcInstance mem : members)
				{
					// j݂̉փe|[g
					driftx = Rnd.get(-80, 80);
					drifty = Rnd.get(-80, 80);
					mem.teleToLocation(Location[0] + driftx, Location[1] + drifty, Location[2]);
					// _̒ʍs؂Cxg
					mem.destroyItemByItemId("Quest", _EntrancePass, 1, mem,true);
					// Âu[`ĂȂΎgpςݗ_̒ʍs؂Cxgɓ
                    if (mem.getInventory().getItemByItemId(_OldBrooch) == null)
                    {
						mem.addItem("Quest", _UsedEntrancePass, 1, mem, true);
                    }

					// sh~̂߁A̌Sď
					L2ItemInstance HallsKey = mem.getInventory().getItemByItemId(_HallsKey);
	                if(HallsKey != null)
	                {
	                    // ̌Cxg
	                	mem.destroyItemByItemId("Quest", _HallsKey, HallsKey.getCount(), mem, true);
	                }
				}

				// _ǗlɃp[eB[_[֌Wt
				_Challengers.remove(npcId);
				_Challengers.put(npcId, player);

				// _̗p󋵂XV
				_HallInUse.remove(npcId);
				_HallInUse.put(npcId, true);
			}
			else
			{
				player.sendMessage("𖞂ĂȂ߁Aꂪۂ܂B");
			}
		}
		else
		// \̏ꍇ
		{
			// _̐\ݏĊmF
			if (IsEnableEntry(npcId, player))
			{
				// j݂̉փe|[g
				driftx = Rnd.get(-80, 80);
				drifty = Rnd.get(-80, 80);
				player.teleToLocation(Location[0] + driftx, Location[1] + drifty, Location[2]);
				// _̒ʍs؂Cxg
				player.destroyItemByItemId("Quest", _EntrancePass, 1, player, true);
				// Âu[`ĂȂΎgpςݗ_̒ʍs؂Cxgɓ
                if (player.getInventory().getItemByItemId(_OldBrooch) == null)
                {
                	player.addItem("Quest", _UsedEntrancePass, 1, player, true);
                }

				// sh~̂߁A̌Sď
				L2ItemInstance HallsKey = player.getInventory().getItemByItemId(_HallsKey);
                if(HallsKey != null)
                {
                    // ̌Cxg
                	player.destroyItemByItemId("Quest", _HallsKey, HallsKey.getCount(), player, true);
                }

                // _ǗlɃp[eB[_[֌Wt
				_Challengers.remove(npcId);
				_Challengers.put(npcId, player);

				// _̗p󋵂XV
				_HallInUse.remove(npcId);
				_HallInUse.put(npcId, true);
			}
			else
			{
				player.sendMessage("𖞂ĂȂ߁Aꂪۂ܂B");
			}
		}
	}

    // ̔o
    public void SpawnMysteriousBox(int npcId)
    {
    	if (!IsAttackTime()) return;

    	L2Spawn spawnDat = _MysteriousBoxSpawns.get(npcId);
    	if(spawnDat != null)
    	{
        	_AllMobs.add(spawnDat.doSpawn());
        	spawnDat.stopRespawn();
    	}
    }

    // X^[o
    public void SpawnMonster(int npcId)
    {
    	if (!IsAttackTime()) return;

    	FastList<L2Spawn> MonsterList;
    	List<L2SepulcherMonsterInstance> Mobs = new FastList<L2SepulcherMonsterInstance>();
    	L2Spawn KeyBoxMobSpawn;

    	// nA@n̂ǂ炩߂
    	if(Rnd.get(2) == 0)	// n
    	{
    		MonsterList = (FastList<L2Spawn>)_PhysicalMonsters.get(npcId);
    	}
    	else				// @n
    	{
    		MonsterList = (FastList<L2Spawn>)_MagicalMonsters.get(npcId);
    	}

    	// X^[o
    	if(MonsterList != null)
    	{
    		boolean SpawnKeyBoxMob = false;
    		boolean SpawnedKeyBoxMob = false;

        	for (L2Spawn spawnDat:MonsterList)
        	{
        		// q݂̉Ō̔on̍bo邩肷B
        		if(SpawnedKeyBoxMob)
        		{
        			SpawnKeyBoxMob = false;
        		}
        		else
        		{
            		switch(npcId)
            		{
            		    // q݂̉̓̔
            		    case 31469:
            		    case 31474:
            		    case 31479:
            		    case 31484:
            		    	if(Rnd.get(48) == 0)
            		    	{
            		    		SpawnKeyBoxMob = true;
            		    		_log.info("FourSepulchersManager.SpawnMonster: Set to spawn Church of Viscount Key Mob.");
            		    	}
            		    	break;
        		    	default:
        		    		SpawnKeyBoxMob = false;
            		}
        		}

        		L2SepulcherMonsterInstance mob = null;

        		// ̔on̍bo鏈
        		if(SpawnKeyBoxMob)
        		{
                    try
                    {
            			L2NpcTemplate template = NpcTable.getInstance().getTemplate(18149);
                        if (template != null)
                        {
                        	KeyBoxMobSpawn = new L2Spawn(template);
                        	KeyBoxMobSpawn.setAmount(1);
                        	KeyBoxMobSpawn.setLocx(spawnDat.getLocx());
                        	KeyBoxMobSpawn.setLocy(spawnDat.getLocy());
                        	KeyBoxMobSpawn.setLocz(spawnDat.getLocz());
                        	KeyBoxMobSpawn.setHeading(spawnDat.getHeading());
                        	KeyBoxMobSpawn.setRespawnDelay(3600);
                        	SpawnTable.getInstance().addNewSpawn(KeyBoxMobSpawn, false);
                    		mob = (L2SepulcherMonsterInstance)KeyBoxMobSpawn.doSpawn();
                    		KeyBoxMobSpawn.stopRespawn();
                        }
                        else {
                            _log.warning("FourSepulchersManager.SpawnMonster: Data missing in NPC table for ID: 18149");
                        }
                    }
                    catch (Exception e)
                    {
                        _log.warning("FourSepulchersManager.SpawnMonster: Spawn could not be initialized: " + e);
                    }

        			SpawnedKeyBoxMob = true;
        		}
        		else
        		{
            		mob = (L2SepulcherMonsterInstance)spawnDat.doSpawn();
                	spawnDat.stopRespawn();
        		}

        		if(mob != null)
        		{
            		mob.MysteriousBoxId = npcId;
            		switch(npcId)
            		{
            		    // q݂̉̓̔
            		    case 31469:
            		    case 31474:
            		    case 31479:
            		    case 31484:
            		    // ݂̉̓̔
            		    case 31472:
            		    case 31477:
            		    case 31482:
            		    case 31487:
            		    	Mobs.add(mob);
            		}
            		_AllMobs.add(mob);
        		}
        	}

        	switch(npcId)
    		{
    		    // q݂̉̓̔
    		    case 31469:
    		    case 31474:
    		    case 31479:
    		    case 31484:
    		    	_ViscountMobs.put(npcId, Mobs);
    		    	break;

    		    // ݂̉̓̔
    		    case 31472:
    		    case 31477:
    		    case 31482:
    		    case 31487:
    		    	_DukeMobs.put(npcId, Mobs);
    		    	break;
    		}
    	}
    }

    // q݂̉̃X^[̟rłmF
    public synchronized boolean IsViscountMobsAnnihilated(int npcId)
    {
    	FastList<L2SepulcherMonsterInstance> Mobs =
    		(FastList<L2SepulcherMonsterInstance>)_ViscountMobs.get(npcId);

    	if(Mobs == null) return true;

    	for(L2SepulcherMonsterInstance mob:Mobs)
    	{
    		if(!mob.isDead()) return false;
    	}

    	return true;
    }

    // ݂̉̃X^[̟rłmF
    public synchronized boolean IsDukeMobsAnnihilated(int npcId)
    {
    	FastList<L2SepulcherMonsterInstance> Mobs =
    		(FastList<L2SepulcherMonsterInstance>)_DukeMobs.get(npcId);

    	if(Mobs == null) return true;

    	for(L2SepulcherMonsterInstance mob:Mobs)
    	{
    		if(!mob.isDead()) return false;
    	}

    	return true;
    }

    // ̔o
    public void SpawnKeyBox(L2NpcInstance activeChar)
    {
    	if (!IsAttackTime()) return;

    	L2Spawn	spawnDat = _KeyBoxSpawns.get(activeChar.getNpcId());

    	if(spawnDat != null)
    	{
        	spawnDat.setAmount(1);
        	spawnDat.setLocx(activeChar.getX());
        	spawnDat.setLocy(activeChar.getY());
        	spawnDat.setLocz(activeChar.getZ());
        	spawnDat.setHeading(activeChar.getHeading());
        	spawnDat.setRespawnDelay(3600);
        	_AllMobs.add(spawnDat.doSpawn());
        	spawnDat.stopRespawn();

    	}
    }

    // nV̎s҂o
    public void SpawnExecutionerOfHalisha(L2NpcInstance activeChar)
    {
    	if (!IsAttackTime()) return;

    	L2Spawn spawnDat = _ExecutionerSpawns.get(activeChar.getNpcId());

    	if(spawnDat != null)
    	{
    		spawnDat.setAmount(1);
        	spawnDat.setLocx(activeChar.getX());
        	spawnDat.setLocy(activeChar.getY());
        	spawnDat.setLocz(activeChar.getZ());
        	spawnDat.setHeading(activeChar.getHeading());
        	spawnDat.setRespawnDelay(3600);
        	_AllMobs.add(spawnDat.doSpawn());
        	spawnDat.stopRespawn();
    	}
    }

    // nVAh~jXg[^[o
    public void SpawnArchonOfHalisha(int npcId)
    {
    	if (!IsAttackTime()) return;

    	// ɏoĂꍇ͖
    	if(_ArchonSpawned.get(npcId)) return;

    	FastList<L2Spawn> MonsterList = (FastList<L2Spawn>)_DukeFinalMobs.get(npcId);

    	// X^[o
    	if(MonsterList != null)
    	{
        	for (L2Spawn spawnDat:MonsterList)
        	{
        		L2SepulcherMonsterInstance mob = (L2SepulcherMonsterInstance)spawnDat.doSpawn();
            	spawnDat.stopRespawn();

        		if(mob != null)
        		{
            		mob.MysteriousBoxId = npcId;
            		_AllMobs.add(mob);
        		}
    		}
        	_ArchonSpawned.put(npcId, true);
    	}
    }

    // EBSbg̗HƃnV̕󔠂o
    public void SpawnEmperorsGraveNpc(int npcId)
    {
    	if (!IsAttackTime()) return;

    	FastList<L2Spawn> MonsterList = (FastList<L2Spawn>)_EmperorsGraveNpcs.get(npcId);

    	// X^[o
    	if(MonsterList != null)
    	{
        	for (L2Spawn spawnDat:MonsterList)
        	{
        		_AllMobs.add(spawnDat.doSpawn());
            	spawnDat.stopRespawn();
    		}
    	}
    }

    // nVVh[̏oW肷B
    protected void LocationShadowSpawns()
    {
    	int locNo = Rnd.get(4);
    	_log.info("FourSepulchersManager.LocationShadowSpawns: Location index is " + locNo + ".");
    	final int[] gateKeeper = {31929,31934,31939,31944};

    	L2Spawn spawnDat;

        // ̏oW쐬
        for(int i=0;i<=3;i++)
    	{
        	int keyNpcId = gateKeeper[i];
        	spawnDat = _ShadowSpawns.get(keyNpcId);
        	spawnDat.setLocx(_ShadowSpawnLoc[locNo][i][1]);
        	spawnDat.setLocy(_ShadowSpawnLoc[locNo][i][2]);
        	spawnDat.setLocz(_ShadowSpawnLoc[locNo][i][3]);
        	spawnDat.setHeading(_ShadowSpawnLoc[locNo][i][4]);
        	_ShadowSpawns.put(keyNpcId,spawnDat);
    	}
    }

    // nVVh[o
    public void SpawnShadow(int npcId)
    {
    	if (!IsAttackTime()) return;

    	L2Spawn spawnDat = _ShadowSpawns.get(npcId);
    	if(spawnDat != null)
    	{
    		L2SepulcherMonsterInstance mob = (L2SepulcherMonsterInstance)spawnDat.doSpawn();
        	spawnDat.stopRespawn();

    		if(mob != null)
    		{
        		mob.MysteriousBoxId = npcId;
        		_AllMobs.add(mob);
    		}
    	}
    }

    // p[eBSłmF
    public void checkAnnihilated(L2PcInstance player)
    {
    	// Słꍇ͂Tbɏ҂̎@֔΂
    	if(IsPartyAnnihilated(player))
    	{
    		_OnPartyAnnihilatedTask =
				ThreadPoolManager.getInstance().scheduleGeneral(new OnPartyAnnihilatedTask(player),5000);
    	}
    }

    // p[eBSłmF
    public synchronized boolean IsPartyAnnihilated(L2PcInstance player)
    {
		if(player.getParty() != null)
		{
			for(L2PcInstance mem:player.getParty().getPartyMembers())
			{
				if(!mem.isDead())
				{
					return false;
				}
			}
			return true;
		}
		else
		{
			return true;
		}
    }

    // p[eBSłꍇ̏A҂̎@֔΂
    public synchronized void OnPartyAnnihilated(L2PcInstance player)
    {
		if(player.getParty() != null)
		{
			for(L2PcInstance mem:player.getParty().getPartyMembers())
			{
				if(!mem.isDead()) break;
        		int driftX = Rnd.get(-80,80);
        		int driftY = Rnd.get(-80,80);
        		mem.teleToLocation(169589 + driftX,-90493 + driftY,-2914);
			}
		}
		else
		{
    		int driftX = Rnd.get(-80,80);
    		int driftY = Rnd.get(-80,80);
    		player.teleToLocation(169589 + driftX,-90493 + driftY,-2914);
    	}
    }

    // _̃X^[
    public void DeleteAllMobs()
    {
    	_log.info("FourSepulchersManager.DeleteAllMobs: Try to delete " + _AllMobs.size() + " monsters.");

    	int delCnt = 0;
        for(L2NpcInstance mob : _AllMobs)
        {
			try
            {
				mob.getSpawn().stopRespawn();
				mob.deleteMe();
                delCnt++;
            }
            catch(Exception e)
            {
                _log.warning(e.getMessage());
            }
        }
        _AllMobs.clear();
    	_log.info("FourSepulchersManager.DeleteAllMobs: Deleted " + delCnt + " monsters.");
    }

    // ׂẲ̃hA
    protected void CloseAllDoors()
    {
    	for(int doorId:_HallGateKeepers.values())
    	{
            try
            {
            	DoorTable.getInstance().getDoor(doorId).closeMe();
            }
            catch (Exception e)
            {
                _log.warning(e.getMessage());
            }
    	}
    }

    // QtԂɓ
    protected class ChaneEntryTime implements Runnable
    {
        public void run()
        {
            _log.info("FourSepulchersManager:In Entry Time");
            // tOύX
            _InEntryTime = true;
            _InWarmUpTime = false;
            _InAttackTime = false;
            _InCoolDownTime = false;

            // EH[AbvԂɈڍs^XNdł
            _ChaneWarmUpTimeTask =
                ThreadPoolManager.getInstance().scheduleGeneral(new ChaneWarmUpTime(),Config.FS_TIME_ENTRY * 60000);

            // sꂽ^XÑN[Abv
            if(_ChangeEntryTimeTask != null)
            {
            	_ChangeEntryTimeTask.cancel(true);
            	_ChangeEntryTimeTask = null;
            }
        }
    }

    // EH[AbvԂɓ
    protected class ChaneWarmUpTime implements Runnable
    {
        public void run()
        {
            _log.info("FourSepulchersManager:In Warm-Up Time");
            // tOύX
            _InEntryTime = true;
            _InWarmUpTime = false;
            _InAttackTime = false;
            _InCoolDownTime = false;

            // _UԂɈڍs^XNdł
            _ChangeAttackTimeTask =
                ThreadPoolManager.getInstance().scheduleGeneral(new ChangeAttackTime(),Config.FS_TIME_WARMUP * 60000);

            // sꂽ^XÑN[Abv
            if(_ChaneWarmUpTimeTask != null)
            {
            	_ChaneWarmUpTimeTask.cancel(true);
            	_ChaneWarmUpTimeTask = null;
            }
        }
    }

    // _UԂɓ
    protected class ChangeAttackTime implements Runnable
    {
        public void run()
        {
            _log.info("FourSepulchersManager:In Attack Time");
            // tOύX
            _InEntryTime = false;
            _InWarmUpTime = false;
            _InAttackTime = true;
            _InCoolDownTime = false;

            // nVVh[̏oW肷
            LocationShadowSpawns();

            // j݂̉̓̔o
            SpawnMysteriousBox(31921);
            SpawnMysteriousBox(31922);
            SpawnMysteriousBox(31923);
            SpawnMysteriousBox(31924);

            // N[_E^CɈڍs^XNdł
            _ChangeCoolDownTimeTask =
                ThreadPoolManager.getInstance().scheduleGeneral(new ChangeCoolDownTime(),Config.FS_TIME_ATTACK * 60000);

            // sꂽ^XÑN[Abv
            if(_ChangeAttackTimeTask != null)
            {
            	_ChangeAttackTimeTask.cancel(true);
            	_ChangeAttackTimeTask = null;
            }
        }
    }

    // N[_E^Cɓ
    protected class ChangeCoolDownTime implements Runnable
    {

        public void run()
        {
            _log.info("FourSepulchersManager:In Cool-Down Time");
            // tOύX
            _InEntryTime = false;
            _InWarmUpTime = false;
            _InAttackTime = false;
            _InCoolDownTime = true;

            // UPC҂̎@֔΂
            for(L2PcInstance player :L2World.getInstance().getAllPlayers())
            {
            	if (GrandBossManager.getInstance().checkIfInZone("FourSepulcher", player) &&
            		(player.getZ() >= -7250 && player.getZ() <= -6841) &&
            		!player.isGM())
            	{
            		int driftX = Rnd.get(-80,80);
            		int driftY = Rnd.get(-80,80);
            		player.teleToLocation(169589 + driftX,-90493 + driftY,-2914);
            	}
            }

            // _̃X^[ނ
            DeleteAllMobs();

            // JĂ\̂ׂ̔ĕ
            CloseAllDoors();

            // _̗pԂNA
            _HallInUse.clear();
            _HallInUse.put(31921,false);    // ҂̗_
            _HallInUse.put(31922,false);    // xz҂̗_
            _HallInUse.put(31923,false);    // 匫҂̗_
            _HallInUse.put(31924,false);    // R҂̗_

            // ݂̉̃nVAh~jXg[^[̏oԂNA
            if(_ArchonSpawned.size() != 0)
            {
                Set<Integer> npcIdSet = _ArchonSpawned.keySet();
                for(int npcId:npcIdSet)
                {
                	_ArchonSpawned.put(npcId, false);
                }
            }

            // QtԂɈڍs^XNdł
            _ChangeEntryTimeTask =
                ThreadPoolManager.getInstance().scheduleGeneral(new ChaneEntryTime(),Config.FS_TIME_COOLDOWN * 60000);

            // sꂽ^XÑN[Abv
            if(_ChangeCoolDownTimeTask != null)
            {
            	_ChangeCoolDownTimeTask.cancel(true);
            	_ChangeCoolDownTimeTask = null;
            }
        }
    }

    // 4_Ŏ񂾏ꍇAp[eBSłĂΏ҂̎@֔΂
	private class OnPartyAnnihilatedTask implements Runnable
	{
		L2PcInstance _player;

		public OnPartyAnnihilatedTask(L2PcInstance player)
		{
			_player = player;
		}

		public void run()
		{
			OnPartyAnnihilated(_player);
            // sꂽ^XÑN[Abv
            if(_OnPartyAnnihilatedTask != null)
            {
            	_OnPartyAnnihilatedTask.cancel(true);
            	_OnPartyAnnihilatedTask = null;
            }

		}
	}
}
