/*
 * This program is free software: you can redistribute it and/or modify it under
 * the terms of the GNU General Public License as published by the Free Software
 * Foundation, either version 3 of the License, or (at your option) any later
 * version.
 * 
 * This program is distributed in the hope that it will be useful, but WITHOUT
 * ANY WARRANTY; without even the implied warranty of MERCHANTABILITY or FITNESS
 * FOR A PARTICULAR PURPOSE. See the GNU General Public License for more
 * details.
 * 
 * You should have received a copy of the GNU General Public License along with
 * this program. If not, see <http://www.gnu.org/licenses/>.
 */
package com.l2jserver.gameserver.instancemanager.grandbosses;
/*package com.l2jfree.gameserver.instancemanager.grandbosses;*/

import com.l2jserver.gameserver.ThreadPoolManager;
import com.l2jserver.gameserver.datatables.NpcTable;
import com.l2jserver.gameserver.model.L2Spawn;
import com.l2jserver.gameserver.model.actor.L2Npc;
import com.l2jserver.gameserver.model.entity.BossEntity;
import com.l2jserver.gameserver.model.entity.GrandBossState;

/**
 * l2j-free  l2jserver.com/l2j_jp/l2j-sfjp {XڐApbp
 *
 * @author  JOJO Sync: l2jfree-core rev6679, timestamp 2009/07/21 19:41:28
 */

public abstract class BossLair extends BossEntity
{
	public abstract void init();

	public abstract void setUnspawn();

	protected GrandBossState	_state;

	public int/*GrandBossState.StateEnum*/ getState()
	{
		return _state.getState();
	}

	public boolean isEnableEnterToLair()
	{
		return _state.getState() == GrandBossState.StateEnum.NOTSPAWN;
	}

	public synchronized boolean isPlayersAnnihilated()
	{
		return getZone().isPlayersAnnihilated();
	}

	@Override
	public void checkAnnihilated()
	{
		if (isPlayersAnnihilated())
		{
			ThreadPoolManager.getInstance().scheduleGeneral(new Runnable()
			{
				public void run()
				{
					setUnspawn();	/*(Overridden method)*/
				}
			}, 10000);
		}
	}

	/**
	 * [JOJO] Quest#addSpawn ̃TuZbg
	 */
	public L2Npc addSpawn(int npcId, int x, int y, int z, int heading)
	{
		L2Npc result = null;
		try
		{
			L2Spawn spawn = new L2Spawn(NpcTable.getInstance().getTemplate(npcId));
			spawn.setHeading(heading);
			spawn.setLocx(x);
			spawn.setLocy(y);
			spawn.setLocz(z);
			spawn.stopRespawn();
			result = spawn.doSpawn();
		}
		catch (Exception e)
		{
			e.printStackTrace();
		}
		return result;
	}
//	public L2Npc addSpawn(int npcId, int x, int y, int z, int heading, boolean randomOffset, int despawnDelay)
//	{
//		class DeSpawnScheduleTimerTask implements Runnable
//		{
//			L2Npc _npc = null;
//			
//			public DeSpawnScheduleTimerTask(L2Npc npc)
//			{
//				_npc = npc;
//			}
//			
//			public void run()
//			{
//				_npc.deleteMe();
//				_npc = null;
//			}
//		}
//		
//		if (randomOffset)
//		{
//			x += Rnd.get(-100, 100);
//			y += Rnd.get(-100, 100);
//		}
//		L2Npc result = addSpawn(npcId, x, y, z, heading);
//		if (despawnDelay > 0)
//			ThreadPoolManager.getInstance().scheduleGeneral(new DeSpawnScheduleTimerTask(result), despawnDelay);
//		return result;
//	}
}