/*
 * This program is free software: you can redistribute it and/or modify it under
 * the terms of the GNU General Public License as published by the Free Software
 * Foundation, either version 3 of the License, or (at your option) any later
 * version.
 * 
 * This program is distributed in the hope that it will be useful, but WITHOUT
 * ANY WARRANTY; without even the implied warranty of MERCHANTABILITY or FITNESS
 * FOR A PARTICULAR PURPOSE. See the GNU General Public License for more
 * details.
 * 
 * You should have received a copy of the GNU General Public License along with
 * this program. If not, see <http://www.gnu.org/licenses/>.
 */
package com.l2jserver.gameserver.model.actor.instance;

import com.l2jserver.gameserver.model.L2ItemInstance;
import com.l2jserver.gameserver.model.itemcontainer.PcInventory;
import com.l2jserver.gameserver.network.SystemMessageId;
import com.l2jserver.gameserver.network.serverpackets.SystemMessage;
import com.l2jserver.gameserver.templates.chars.L2NpcTemplate;

/**
 * Ȅl
 * @author JOJO@L2J-SFJP
 *
 * SQL: UPDATE npc SET type='L2DimensionalMerchant' WHERE id=32478;
 *
 * ֘At@C:
../../../../../../../../datapack_development/data/summon_items.csv
../../../../../../../../datapack_development/data/html/default/32478.htm
../../../../../../../../datapack_development/sql/npc_ja.sql
 */
public class L2DimensionalMerchantInstance extends L2MerchantInstance
{
	/**
	 * @param objectId
	 * @param template
	 */
	public L2DimensionalMerchantInstance(int objectId, L2NpcTemplate template)
	{
		super(objectId, template);
	}
	
	@Override
	public String getHtmlPath(int npcId, int val)
	{
		return getHtmlPath("data/html/default/", npcId, val);
	}
	
	@Override
	public void onBypassFeedback(L2PcInstance player, String command)
	{
		if (command.startsWith("exchange"))
		{
			String[] params = command.split(" ");
			int amuletId = Integer.parseInt(params[1]);
			switch (amuletId)
			{
			case 13017: //ng T|[g A~bgFzCg tFbg		 16045 zCg tFbg
			case 13018: //ng T|[g A~bgFtFA[ vZX	 16046 tFA[ vZX
			case 13019: //ng T|[g A~bgFr[Xg t@C^[		 16044 r[Xg t@C^[
			case 13020: //ng T|[g A~bgFtHbNX EBU[h	 16043 tHbNX EBU[h
			case 13548: //gCiCg ng T|[g A~bg				 16052 gC iCg
			case 13549: //Xsbg }WV ng T|[g A~bg	 16051 Xsbg EBU[h
			case 13550: //AE EBU[h ng T|[g A~bg		 16050 AE EBU[h
			case 13551: //^[g }X^[ ng T|[g A~bg		 16053 ^[g }X^[
				//13385 ng T|[g 1pbNFCxg
				if (takeItems(player, 13385, 1))
				{
					giveItems(player, amuletId, 1);
					showChatWindow(player, 13);	//32478-13.htm
				}
				//13384 ng T|[g 3pbNFCxg
				else if (takeItems(player, 13384, 1))
				{
					giveItems(player, amuletId, 1);
					giveItems(player, 13385, 2);	//
					showChatWindow(player, 13);	//32478-13.htm
				}
				//13274 ng T|[gF7
				//13276 ng T|[gF1pbN
				//13273 ng T|[gF5
				else if ( takeItems(player, 13274, 1)
				       || takeItems(player, 13276, 1)
				       || takeItems(player, 13273, 1) )
				{
					giveItems(player, amuletId, 1);
					showChatWindow(player, 13);	//32478-13.htm
				}
				//13275 ng T|[gF3pbN
				else if (takeItems(player, 13275, 1))
				{
					giveItems(player, amuletId, 1);
					giveItems(player, 13276, 2);	//
					showChatWindow(player, 13);	//32478-13.htm
				}
				else
					showChatWindow(player, 6);	//32478-6.htm
				break;


			case 14061: //㋉ng T|[g A~bgFgC iCg				 16052 gC iCg
			case 14062: //㋉ng T|[g A~bgFXsbg }WV	 16051 Xsbg EBU[h
			case 14063: //㋉ng T|[g A~bgFAE EBU[h		 16050 AE EBU[h
			case 14064: //㋉ng T|[g A~bgF^[g }X^[		 16053 ^[g }X^[
				//14291 ㋉ng T|[g 1pbNFCxg
				//14074 ㋉ng T|[gFCxg
				if ( takeItems(player, 14291, 1)
				  || takeItems(player, 14074, 1) )
				{
					giveItems(player, amuletId, 1);
					showChatWindow(player, 13);	//32478-13.htm
				}
				//14290 ㋉ng T|[g 2pbNFCxg
				else if (takeItems(player, 14290, 1))
				{
					giveItems(player, amuletId, 1);
					giveItems(player, 14291, 1);	//
					showChatWindow(player, 13);	//32478-13.htm
				}
				//14248 ㋉ng T|[g 1pbN
				//14065 ㋉ng T|[g
				else if ( takeItems(player, 14248, 1)
				       || takeItems(player, 14065, 1) )
				{
					giveItems(player, amuletId, 1);
					showChatWindow(player, 13);	//32478-13.htm
				}
				//14239 ㋉ng T|[g 2pbN
				else if (takeItems(player, 14239, 1))
				{
					giveItems(player, amuletId, 1);
					giveItems(player, 14248, 1);	//
					showChatWindow(player, 13);	//32478-13.htm
				}
				else
					showChatWindow(player, 12);	//32478-12.htm
				break;

			default:
				throw new AssertionError("onBypassFeedback(" + player.getName() + "," + command + ")");
			}
		}
		else
			super.onBypassFeedback(player, command);
	}
	
	private boolean takeItems(L2PcInstance player, int itemId, long count)
	{
		PcInventory inventory = player.getInventory();
		L2ItemInstance item = inventory.getItemByItemId(itemId);
		
        if (item == null || item.getCount() < count || inventory.destroyItemByItemId("Consume", itemId, count, player, this) == null)
			return false;
		player.sendPacket(new SystemMessage(SystemMessageId.S2_S1_DISAPPEARED).addItemName(itemId).addItemNumber(count));
		return true;
	}
	
	private void giveItems(L2PcInstance player, int itemId, long count)
	{
		player.addItem("", itemId, count, this, true);
	}
}