/*
 * This program is free software: you can redistribute it and/or modify it under
 * the terms of the GNU General Public License as published by the Free Software
 * Foundation, either version 3 of the License, or (at your option) any later
 * version.
 * 
 * This program is distributed in the hope that it will be useful, but WITHOUT
 * ANY WARRANTY; without even the implied warranty of MERCHANTABILITY or FITNESS
 * FOR A PARTICULAR PURPOSE. See the GNU General Public License for more
 * details.
 * 
 * You should have received a copy of the GNU General Public License along with
 * this program. If not, see <http://www.gnu.org/licenses/>.
 */
package com.l2jserver.gameserver.model.entity;
/*package com.l2jfree.gameserver.model.entity;*/

import java.util.Collection;
import java.util.List;
import java.util.logging.Logger;

import javolution.util.FastList;
import com.l2jserver.gameserver.GmListTable;
import com.l2jserver.gameserver.instancemanager.GrandBossManager;
import com.l2jserver.gameserver.model.actor.L2Character;
import com.l2jserver.gameserver.model.actor.instance.L2DecoyInstance;
import com.l2jserver.gameserver.model.actor.instance.L2PcInstance;
import com.l2jserver.gameserver.model.zone.type.L2BossZone;
import com.l2jserver.util.Rnd;

/**
 * l2j-free  l2jserver.com/l2j_jp/l2j-sfjp {XڐApbp
 *
 * @author JOJO Sync: Entity.java l2jfree-core rev6697, timestamp 2009/07/23 08:37:48
 */

public class BossEntity
/*public class Entity*/
{
	public/*protected*/ static Logger _log = Logger.getLogger(BossEntity.class.getName());

	private/*protected*/ L2BossZone _zone;

 	public void registerZone(L2BossZone zone)
 	{
 		_zone = zone;
		_zone.registerEntity(this);
 	}

	public L2BossZone registerZone(int x, int y, int z)
	{
		_zone = GrandBossManager.getInstance().getZone(x, y, z);
		_zone.registerEntity(this);
		return _zone;
	}

	public L2BossZone getZone()
	{
		return _zone;
	}

	public void onEnter(L2PcInstance player)	//<<== L2BossZone#onEnter
	{
	}
	public void checkAnnihilated()	//<<== L2BossZone#onExit
	{
	}

 //	public int getTownId()
 //	{
 //		if (_zone != null) return _zone.getTownId();
 //
 //		_log.error(getClassName()+" has no zone defined");
 //		return 0; // Talking Island
 //	}
 //
 //	public int getCastleId()
 //	{
 //		if (_zone != null) return _zone.getCastleId();
 //
 //		_log.error(getClassName()+" has no zone defined");
 //		return 1; // Gludio
 //	}
 //
 //	public int getFortId()
 //	{
 //		if (_zone != null) return _zone.getFortId();
 //
 //		_log.error(getClassName()+" has no zone defined");
 //		return 0;
 //	}
 //
	public boolean checkIfInZone(L2Character cha)
	{
		if (_zone != null) return _zone.isInsideZone(cha);

		_log.warning(getClassName()+" has no zone defined");
		return false;
	}

 //	public boolean checkIfInZone(int x, int y, int z)
 //	{
 //		if (_zone != null) return _zone.isInsideZone(x, y, z);
 //
 //		_log.error(getClassName()+" has no zone defined");
 //		return false;
 //	}
 //
 //	public boolean checkIfInZone(int x, int y)
 //	{
 //		if (_zone != null) return _zone.isInsideZone(x, y);
 //
 //		_log.error(getClassName()+" has no zone defined");
 //		return false;
 //	}
 //
 //	public double getDistanceToZone(int x, int y)
 //	{
 //		if (_zone != null) return _zone.getDistanceToZone(x, y);
 //
 //		_log.error(getClassName()+" has no zone defined");
 //		return Double.MAX_VALUE;
 //	}
 //
	public List<L2PcInstance> getPlayersInside()
	{
		List<L2PcInstance> lst = new FastList<L2PcInstance>();
		for (L2Character cha : getZone().getCharactersInside().values())
		{
			if (cha instanceof L2PcInstance)
				lst.add((L2PcInstance)cha);
		}
		return lst;
	}

	public L2PcInstance getRandomPlayer()
	{
		Collection<L2Character> lst = getZone().getCharactersInside().values();
		L2PcInstance[] array = new L2PcInstance[lst.size()];
		int count = 0;
		for (L2Character cha : lst)
			if (! cha.isDead() && cha instanceof L2PcInstance)
				array[count++] = (L2PcInstance)cha;
		return count > 0 ? array[Rnd.get(count)] : null;
	}

	public L2Character getRandomTarget()
	{
		Collection<L2Character> lst = getZone().getCharactersInside().values();
		L2Character[] array = new L2Character[lst.size()];
		int count = 0;
		for (L2Character cha : lst)
			if (! cha.isDead() && (cha instanceof L2PcInstance || cha instanceof L2DecoyInstance))
				array[count++] = cha;
		return count > 0 ? array[Rnd.get(count)] : null;
	}

 //	/**
 //	 * @param cha
 //	 */
 //	protected boolean checkBanish(L2PcInstance cha)
 //	{
 //		return true;
 //	}

	public void banishForeigners()
	{
		getZone().oustAllPlayers();
	}

 //	public void broadcastToPlayers(String message)
 //	{
 //		SystemMessage msg = SystemMessage.sendString(message);
 //		for (L2PcInstance player : getPlayersInside())
 //		{
 //			player.sendPacket(msg);
 //		}
 //	}
 //
 //	public void broadcastToPlayers(L2GameServerPacket gsp)
 //	{
 //		for (L2PcInstance player : getPlayersInside())
 //		{
 //			player.sendPacket(gsp);
 //		}
 //	}
 //
	public String getClassName()
	{
		return getClass().getSimpleName();
 //		String[] parts = this.getClass().toString().split("\\.");
 //		return parts[parts.length-1];
	}

	@Deprecated static final boolean DEBUG = false;
	@Deprecated public void TRACE(String msg)
	{
		if (DEBUG) TRACE("", msg);
	}
	@Deprecated public void TRACE(String title, String msg)
	{
		if (DEBUG) GmListTable.TRACE(title, msg);
	}
}