/*
 * Decompiled with CFR 0.152.
 */
package org.mmocore.network;

import java.nio.ByteBuffer;
import java.nio.channels.CancelledKeyException;
import java.nio.channels.ReadableByteChannel;
import java.nio.channels.SelectionKey;
import java.nio.channels.WritableByteChannel;
import javolution.util.FastList;
import org.mmocore.network.ISocket;
import org.mmocore.network.MMOClient;
import org.mmocore.network.SelectorThread;
import org.mmocore.network.SendablePacket;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class MMOConnection<T extends MMOClient> {
    private final SelectorThread<T> _selectorThread;
    private T _client;
    private ISocket _socket;
    private WritableByteChannel _writableByteChannel;
    private ReadableByteChannel _readableByteChannel;
    private FastList<SendablePacket<T>> _sendQueue = new FastList();
    private SelectionKey _selectionKey;
    private int _readHeaderPending;
    private ByteBuffer _readBuffer;
    private ByteBuffer _primaryWriteBuffer;
    private ByteBuffer _secondaryWriteBuffer;
    private boolean _pendingClose;

    public MMOConnection(SelectorThread<T> selectorThread, ISocket socket, SelectionKey key) {
        this._selectorThread = selectorThread;
        this.setSocket(socket);
        this.setWritableByteChannel(socket.getWritableByteChannel());
        this.setReadableByteChannel(socket.getReadableByteChannel());
        this.setSelectionKey(key);
    }

    public MMOConnection(T client, SelectorThread<T> selectorThread, ISocket socket, SelectionKey key) {
        this(selectorThread, socket, key);
        this.setClient(client);
    }

    protected void setClient(T client) {
        this._client = client;
    }

    public T getClient() {
        return this._client;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void sendPacket(SendablePacket<T> sp) {
        sp.setClient(this.getClient());
        FastList<SendablePacket<T>> fastList = this.getSendQueue();
        synchronized (fastList) {
            if (!this._pendingClose) {
                try {
                    this.getSelectionKey().interestOps(this.getSelectionKey().interestOps() | 4);
                    this.getSendQueue().addLast(sp);
                }
                catch (CancelledKeyException cancelledKeyException) {
                    // empty catch block
                }
            }
        }
    }

    protected SelectorThread<T> getSelectorThread() {
        return this._selectorThread;
    }

    protected void setSelectionKey(SelectionKey key) {
        this._selectionKey = key;
    }

    protected SelectionKey getSelectionKey() {
        return this._selectionKey;
    }

    protected void enableReadInterest() {
        try {
            this.getSelectionKey().interestOps(this.getSelectionKey().interestOps() | 1);
        }
        catch (CancelledKeyException cancelledKeyException) {
            // empty catch block
        }
    }

    protected void disableReadInterest() {
        try {
            this.getSelectionKey().interestOps(this.getSelectionKey().interestOps() & 0xFFFFFFFE);
        }
        catch (CancelledKeyException cancelledKeyException) {
            // empty catch block
        }
    }

    protected void enableWriteInterest() {
        try {
            this.getSelectionKey().interestOps(this.getSelectionKey().interestOps() | 4);
        }
        catch (CancelledKeyException cancelledKeyException) {
            // empty catch block
        }
    }

    protected void disableWriteInterest() {
        try {
            this.getSelectionKey().interestOps(this.getSelectionKey().interestOps() & 0xFFFFFFFB);
        }
        catch (CancelledKeyException cancelledKeyException) {
            // empty catch block
        }
    }

    protected void setSocket(ISocket socket) {
        this._socket = socket;
    }

    public ISocket getSocket() {
        return this._socket;
    }

    protected void setWritableByteChannel(WritableByteChannel wbc) {
        this._writableByteChannel = wbc;
    }

    public WritableByteChannel getWritableChannel() {
        return this._writableByteChannel;
    }

    protected void setReadableByteChannel(ReadableByteChannel rbc) {
        this._readableByteChannel = rbc;
    }

    public ReadableByteChannel getReadableByteChannel() {
        return this._readableByteChannel;
    }

    protected FastList<SendablePacket<T>> getSendQueue() {
        return this._sendQueue;
    }

    protected void createWriteBuffer(ByteBuffer buf) {
        if (this._primaryWriteBuffer == null) {
            this._primaryWriteBuffer = this.getSelectorThread().getPooledBuffer();
            this._primaryWriteBuffer.put(buf);
        } else {
            ByteBuffer temp = this.getSelectorThread().getPooledBuffer();
            temp.put(buf);
            int remaining = temp.remaining();
            this._primaryWriteBuffer.flip();
            int limit = this._primaryWriteBuffer.limit();
            if (remaining >= this._primaryWriteBuffer.remaining()) {
                temp.put(this._primaryWriteBuffer);
                this.getSelectorThread().recycleBuffer(this._primaryWriteBuffer);
                this._primaryWriteBuffer = temp;
            } else {
                this._primaryWriteBuffer.limit(remaining);
                temp.put(this._primaryWriteBuffer);
                this._primaryWriteBuffer.limit(limit);
                this._primaryWriteBuffer.compact();
                this._secondaryWriteBuffer = this._primaryWriteBuffer;
                this._primaryWriteBuffer = temp;
            }
        }
    }

    protected boolean hasPendingWriteBuffer() {
        return this._primaryWriteBuffer != null;
    }

    protected void movePendingWriteBufferTo(ByteBuffer dest) {
        this._primaryWriteBuffer.flip();
        dest.put(this._primaryWriteBuffer);
        this.getSelectorThread().recycleBuffer(this._primaryWriteBuffer);
        this._primaryWriteBuffer = this._secondaryWriteBuffer;
        this._secondaryWriteBuffer = null;
    }

    protected ByteBuffer getWriteBuffer() {
        ByteBuffer ret = this._primaryWriteBuffer;
        if (this._secondaryWriteBuffer != null) {
            this._primaryWriteBuffer = this._secondaryWriteBuffer;
            this._secondaryWriteBuffer = null;
        }
        return ret;
    }

    protected void setPendingHeader(int size) {
        this._readHeaderPending = size;
    }

    protected int getPendingHeader() {
        return this._readHeaderPending;
    }

    protected void setReadBuffer(ByteBuffer buf) {
        this._readBuffer = buf;
    }

    protected ByteBuffer getReadBuffer() {
        return this._readBuffer;
    }

    public boolean isClosed() {
        return this._pendingClose;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void closeNow() {
        FastList<SendablePacket<T>> fastList = this.getSendQueue();
        synchronized (fastList) {
            if (!this.isClosed()) {
                this._pendingClose = true;
                this.getSendQueue().clear();
                this.disableWriteInterest();
                this.getSelectorThread().closeConnection(this);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void close(SendablePacket<T> sp) {
        FastList<SendablePacket<T>> fastList = this.getSendQueue();
        synchronized (fastList) {
            if (!this.isClosed()) {
                this.getSendQueue().clear();
                this.sendPacket(sp);
                this._pendingClose = true;
                this.getSelectorThread().closeConnection(this);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void closeLater() {
        FastList<SendablePacket<T>> fastList = this.getSendQueue();
        synchronized (fastList) {
            if (!this.isClosed()) {
                this._pendingClose = true;
                this.getSelectorThread().closeConnection(this);
            }
        }
    }

    protected void releaseBuffers() {
        if (this._primaryWriteBuffer != null) {
            this.getSelectorThread().recycleBuffer(this._primaryWriteBuffer);
            this._primaryWriteBuffer = null;
            if (this._secondaryWriteBuffer != null) {
                this.getSelectorThread().recycleBuffer(this._secondaryWriteBuffer);
                this._secondaryWriteBuffer = null;
            }
        }
        if (this._readBuffer != null) {
            this.getSelectorThread().recycleBuffer(this._readBuffer);
            this._readBuffer = null;
        }
    }

    protected void onDisconnection() {
        ((MMOClient)this.getClient()).onDisconnection();
    }

    protected void onForcedDisconnection() {
        ((MMOClient)this.getClient()).onForcedDisconnection();
    }
}

