/*
 * Decompiled with CFR 0.152.
 */
package javolution.context;

import javolution.context.Allocator;
import javolution.context.AllocatorContext;
import javolution.context.Context;
import javolution.context.ObjectFactory;
import javolution.lang.Configurable;
import javolution.lang.ValueType;
import javolution.util.FastMap;
import javolution.util.FastTable;

public abstract class StackContext
extends AllocatorContext {
    public static final Configurable<Class<? extends StackContext>> DEFAULT = new Configurable<Class>(Default.access$000());
    public static final Configurable<Boolean> DISABLED = new Configurable<Boolean>(new Boolean(false));
    private boolean _isDisabled = false;

    public static StackContext enter() {
        StackContext stackContext = Context.enter(DEFAULT.get());
        stackContext._isDisabled = DISABLED.get();
        return stackContext;
    }

    public static StackContext exit() {
        return (StackContext)Context.exit();
    }

    public static <T extends ValueType> T outerCopy(T t) {
        StackContext stackContext = (StackContext)AllocatorContext.getCurrent();
        boolean bl = stackContext.isDisabled();
        stackContext.setDisabled(true);
        Object object = t.copy();
        stackContext.setDisabled(bl);
        return (T)((ValueType)object);
    }

    public static void outerCopy(ValueType[] valueTypeArray) {
        StackContext stackContext = (StackContext)AllocatorContext.getCurrent();
        boolean bl = stackContext.isDisabled();
        stackContext.setDisabled(true);
        for (int i = 0; i < valueTypeArray.length; ++i) {
            valueTypeArray[i] = (ValueType)valueTypeArray[i].copy();
        }
        stackContext.setDisabled(bl);
    }

    public static void outerExecute(Runnable runnable) {
        StackContext stackContext = (StackContext)AllocatorContext.getCurrent();
        boolean bl = stackContext.isDisabled();
        stackContext.setDisabled(true);
        runnable.run();
        stackContext.setDisabled(bl);
    }

    public final boolean isDisabled() {
        return this._isDisabled;
    }

    public final void setDisabled(boolean bl) {
        if (bl == this._isDisabled) {
            return;
        }
        if (bl) {
            this.deactivate();
        } else {
            this.getOuter().getAllocatorContext().deactivate();
        }
        this._isDisabled = bl;
    }

    static {
        ObjectFactory.setInstance(new ObjectFactory(){

            protected Object create() {
                return new Default();
            }
        }, Default.CLASS);
    }

    private static final class StackAllocator
    extends Allocator {
        private final ObjectFactory _factory;
        private boolean _inUse;
        private int _queueLimit;

        public StackAllocator(ObjectFactory objectFactory) {
            this._factory = objectFactory;
            this.keepInQueue = true;
        }

        protected Object allocate() {
            if (this._queueLimit >= this.queue.length) {
                this.resize();
            }
            Object t = this._factory.create();
            this.queue[this._queueLimit++] = t;
            return t;
        }

        protected void recycle(Object object) {
            if (this._factory.doCleanup()) {
                this._factory.cleanup(object);
            }
            for (int i = this.queueSize; i < this._queueLimit; ++i) {
                if (this.queue[i] != object) continue;
                this.queue[i] = this.queue[this.queueSize];
                this.queue[this.queueSize++] = object;
                return;
            }
            throw new UnsupportedOperationException("Cannot recycle to the stack an object which has not been allocated from the stack");
        }

        protected void reset() {
            this._inUse = false;
            while (this._factory.doCleanup() && this.queueSize != this._queueLimit) {
                Object object = this.queue[this.queueSize++];
                this._factory.cleanup(object);
            }
            this.queueSize = this._queueLimit;
        }

        public String toString() {
            return "Stack allocator for " + this._factory.getClass();
        }
    }

    private static final class Default
    extends StackContext {
        private static final Class CLASS = new Default().getClass();
        private final ThreadLocal _factoryToAllocator = new ThreadLocal(){

            protected Object initialValue() {
                return new FastMap();
            }
        };
        private final ThreadLocal _activeAllocators = new ThreadLocal(){

            protected Object initialValue() {
                return new FastTable();
            }
        };
        private final FastTable _ownerUsedAllocators = new FastTable();
        private final FastTable _nonOwnerUsedAllocators = new FastTable();

        private Default() {
        }

        @Override
        protected void deactivate() {
            FastTable fastTable = (FastTable)this._activeAllocators.get();
            int n = 0;
            int n2 = fastTable.size();
            while (n < n2) {
                ((Allocator)fastTable.get((int)n++)).user = null;
            }
            fastTable.clear();
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        protected Allocator getAllocator(ObjectFactory objectFactory) {
            FastTable fastTable;
            if (this.isDisabled()) {
                return this.getOuter().getAllocatorContext().getAllocator(objectFactory);
            }
            FastMap fastMap = (FastMap)this._factoryToAllocator.get();
            StackAllocator stackAllocator = (StackAllocator)fastMap.get(objectFactory);
            if (stackAllocator == null) {
                stackAllocator = new StackAllocator(objectFactory);
                fastMap.put(objectFactory, stackAllocator);
            }
            if (stackAllocator.user == null) {
                stackAllocator.user = Thread.currentThread();
                fastTable = (FastTable)this._activeAllocators.get();
                fastTable.add(stackAllocator);
            }
            if (!stackAllocator._inUse) {
                stackAllocator._inUse = true;
                if (Thread.currentThread() == this.getOwner()) {
                    this._ownerUsedAllocators.add(stackAllocator);
                } else {
                    fastTable = this._nonOwnerUsedAllocators;
                    synchronized (fastTable) {
                        this._nonOwnerUsedAllocators.add(stackAllocator);
                    }
                }
            }
            return stackAllocator;
        }

        @Override
        protected void enterAction() {
            this.getOuter().getAllocatorContext().deactivate();
        }

        @Override
        protected void exitAction() {
            StackAllocator stackAllocator;
            int n;
            this.deactivate();
            for (n = 0; n < this._ownerUsedAllocators.size(); ++n) {
                stackAllocator = (StackAllocator)this._ownerUsedAllocators.get(n);
                stackAllocator.reset();
            }
            this._ownerUsedAllocators.clear();
            for (n = 0; n < this._nonOwnerUsedAllocators.size(); ++n) {
                stackAllocator = (StackAllocator)this._nonOwnerUsedAllocators.get(n);
                stackAllocator.reset();
            }
            this._nonOwnerUsedAllocators.clear();
        }
    }
}

