/*
 * This program is free software: you can redistribute it and/or modify it under
 * the terms of the GNU General Public License as published by the Free Software
 * Foundation, either version 3 of the License, or (at your option) any later
 * version.
 * 
 * This program is distributed in the hope that it will be useful, but WITHOUT
 * ANY WARRANTY; without even the implied warranty of MERCHANTABILITY or FITNESS
 * FOR A PARTICULAR PURPOSE. See the GNU General Public License for more
 * details.
 * 
 * You should have received a copy of the GNU General Public License along with
 * this program. If not, see <http://www.gnu.org/licenses/>.
 */
package net.sf.l2j.custom;

import java.io.IOException;
import java.io.Reader;

import javax.script.ScriptException;

public class ReadAll
{
	public static String read(Reader reader) throws ScriptException
	{
		char arr[] = new char[8192];
		StringBuilder buf = new StringBuilder(8192);
		int numChars;
		try
		{
			while ((numChars = reader.read(arr, 0, arr.length)) > 0)
				buf.append(arr, 0, numChars);
		}
		catch (IOException exp)
		{
			throw new ScriptException(exp);
		}
		return buf.toString();
	}
}
